/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_DragWindow
#define GUARD_DragWindow

#include "GenWindow.h"

#include "Globals.h"

#include <string>

class WindowText: public std::wstring {
public:
	WindowText(const std::wstring& iStr, bool iBold = 0): std::wstring(iStr), bold(iBold) {}
	bool bold;
};

class DragWindow: public GenWindow_Base {
public:
	DragWindow(int ix, int iy, int i_parent_id, int flags);
	virtual ~DragWindow() {}

	virtual bool mouse_d(Uint8 button, Uint16 x, Uint16 y);
	virtual bool mouse_m(Uint8 state, Uint16 x, Uint16 y);
	virtual void draw_self();

protected:
	void get_close_rect(SDL_Rect& close_rect);

	bool b_drag;
	int save_mouse_pos_x;
	int save_mouse_pos_y;
	
	std::vector<WindowText> the_text;

	void init_rects();
};

//wstring wrapped to window size
class WrappedString: public DragWindow {
public:
	WrappedString(int ix, int iy, int iw, int ih, const std::wstring& the_string, bool bold_title, int flags);
};

//window size extends to wstring
class InfoString: public DragWindow {
public:
	InfoString(const std::wstring& i_the_string);
	virtual ~InfoString();

	void draw_self();

private:
	std::wstring the_string;
};


///

class Slider: public DragWindow {
public:
	Slider(int ix, int iy, int* iVarPointer, int i_var_min, int i_var_max, int i_parent_id, int flags);
	Slider(int ix, int iy, int iSliderVar, int i_var_min, int i_var_max, int i_parent_id, int flags);
	void init(int var_min, int var_max);

	virtual bool mouse_d(Uint8 button, Uint16 x, Uint16 y);
	virtual bool mouse_m(Uint8 state, Uint16 x, Uint16 y);
	
	virtual void draw_self();

	int GetSliderVar() const {return *var_pointer;}

protected:
	int middle;
	SDL_Rect slider_rect;
	bool b_slider_drag;

	int* var_pointer;
	int slider_var;

	float shadow_var;
	float var_min;
	float var_max;
	float rule_length;

	static const int slider_width = 15;
	static const int slider_height = 40;
};

class SliderWithUnits: public Slider {
public:
	SliderWithUnits(int ix, int iy, int iSliderVar, int i_var_min, int i_var_max, const std::wstring& iVarName, const std::wstring& iVarUnits, int i_parent_id, int flags);
	SliderWithUnits(int ix, int iy, int* iVarPointer, int i_var_min, int i_var_max, const std::wstring& iVarName, const std::wstring& iVarUnits, int i_parent_id, int flags);

	virtual void draw_self();

protected:
	std::wstring var_name;
	std::wstring var_units;
};

class LargeBlankDW: public DragWindow {
public:
	LargeBlankDW(const std::wstring& title);
};


#endif
