function any_player_big_ship() {
	//FIXME default to first ship, though I guess really this should be a frigate if all caps have been destroyed
	local pos = player_squads[0].get_pos();
	foreach(squad in player_squads) {
		if (squad.get_type() == 3) {
			pos = squad.get_pos();
			break;
		}
	}
	
	return pos;
}

//type 1 is bomber
//2 and 3 are big ships
function is_player_squad_close(type_str, distance) {
	local my_big_ship = my_squads[0];
	foreach(squad in my_squads) {
		type = squad.get_type()
		if (type == 2 || type == 3) {
			my_big_ship = squad;
			break;
		}
	}

	foreach(squad in player_squads) {
		type = squad.get_type()
		if ((type_str == "bomber" && (type != 1 || squad.get_in_hangar())) || (type_str == "big_ship" && type != 2 && type != 3))
			continue;
		
		if (squad.get_distance(my_big_ship) < distance)
			return squad.get_pos();
	}
	
	return false;
}

//FIXME only against torp bombers - maybe there should be a bomber defence launched against incoming big ships?
function check_for_launch_defence() {
	//1 minute
	if (last_defence_time && world_frame_counter() - last_defence_time <= 1800)
		return;

	local player_bomber_pos = is_player_squad_close("bomber", 7000);

	if (player_bomber_pos) {
		local take_half = true;
		foreach(squad in my_squads) {
			if (!take_half) {
				take_half = true;
				continue;
			} else
				take_half = false;
				
			if (squad.get_type() == 0 && squad.ready_for_launch())
				squad.highlight();
		}
		add_waypoint(player_bomber_pos[0], player_bomber_pos[1]);
		launch_mission("attack");
		last_defence_time = world_frame_counter();
	}
}

/*
size 0 alternate small/medium
size 1 medium
size 2 large
*/
function launch_attack_wave(attack_pos, size) {
	local fighter_counter = 0;
	local bomber_counter = 0;
	local wanted_bombers = 1;
	local wanted_fighters = 1;
	
	if (size == 2) {
		wanted_bombers = 3;
		wanted_fighters = 3;
	} else if (size == 1 || !do_small_attack) {
		wanted_bombers = 2;
		wanted_fighters = 2;
	}
	
	foreach(squad in my_squads) {
		if (fighter_counter < wanted_fighters && squad.get_type() == 0 && squad.ready_for_launch()) {
			squad.highlight();
			++fighter_counter;
		}
		
		if (bomber_counter < wanted_bombers && squad.get_type() == 1 && squad.ready_for_launch()) {
			squad.highlight();
			++bomber_counter;
		}
		
		if (fighter_counter == wanted_fighters && bomber_counter == wanted_bombers)
			break;
	}
	
	add_waypoint(attack_pos[0], attack_pos[1]);
	launch_mission("attack");
	
	if (do_small_attack == 0)
		do_small_attack = 2;
	else
		--do_small_attack;
}
