/**
 * \file system.h
 */

#ifndef	H_SYSTEM
#define	H_SYSTEM

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef	HAVE_INTRINSICS_H
# include <intrinsics.h>
#endif

#include <stddef.h>
#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#else
# include <strings.h>
void *memchr ();
#endif

#if !defined(HAVE_STPCPY)
char * stpcpy(/*@out@*/ char * dest, const char * src);
#endif

#if !defined(HAVE_STPNCPY)
char * stpncpy(/*@out@*/ char * dest, const char * src, size_t n);
#endif

#include <errno.h>
#ifndef errno
/*@-declundef @*/
extern int errno;
/*@=declundef @*/
#endif

#if defined(STDC_HEADERS) || defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif /* STDC_HEADERS */

#if defined(__LCLINT__)
/*@-declundef -incondefs @*/ /* LCL: missing annotation */
/*@only@*/ /*@out@*/
void * alloca (size_t __size)
	/*@ensures maxSet(result) == (__size - 1) @*/
	/*@*/;
/*@=declundef =incondefs @*/
#endif

#ifdef __GNUC__
# undef alloca
# define alloca __builtin_alloca
#else
# ifdef HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifndef _AIX
/* AIX alloca decl has to be the first thing in the file, bletch! */
char *alloca ();
#  endif
# endif
#endif

/**
 * Wrapper to free(3), hides const compilation noise, permit NULL, return NULL.
 * @param p		memory to free
 * @return		NULL always
 */
/*@unused@*/ static inline /*@null@*/
void * _free(/*@only@*/ /*@null@*/ /*@out@*/ const void * p)
	/*@modifies p @*/
{
    if (p != NULL)	free((void *)p);
    return NULL;
}

/*@-declundef -incondefs @*/ /* FIX: these are macros */
/**
 */
/*@mayexit@*/ /*@only@*/ /*@out@*/
void * xmalloc (size_t size)
	/*@globals errno @*/
	/*@ensures maxSet(result) == (size - 1) @*/
	/*@modifies errno @*/;

/**
 */
/*@mayexit@*/ /*@only@*/
void * xcalloc (size_t nmemb, size_t size)
	/*@ensures maxSet(result) == (nmemb - 1) @*/
	/*@*/;

/**
 * @todo Annotate ptr with returned/out.
 */
/*@mayexit@*/ /*@only@*/
void * xrealloc (/*@null@*/ /*@only@*/ void * ptr,
					size_t size)
	/*@ensures maxSet(result) == (size - 1) @*/
	/*@modifies *ptr @*/;

/**
 */
/*@mayexit@*/ /*@only@*/
char * xstrdup (const char *str)
	/*@*/;
/*@=declundef =incondefs @*/

/**
 */
/*@unused@*/ /*@exits@*/ /*@only@*/ /*@null@*/
void * syck_vmefail(size_t size)
	/*@*/;

/* Memory allocation via macro defs to get meaningful locations from mtrace() */
#if defined(__GNUC__)
#define	xmalloc(_size) 		(malloc(_size) ? : syck_vmefail(_size))
#define	xcalloc(_nmemb, _size)	(calloc((_nmemb), (_size)) ? : syck_vmefail(_size))
#define	xrealloc(_ptr, _size)	(realloc((_ptr), (_size)) ? : syck_vmefail(_size))
#define	xstrdup(_str)	(strcpy((malloc(strlen(_str)+1) ? : syck_vmefail(strlen(_str)+1)), (_str)))
#else /* ! __GNUC__ */
#define	xmalloc(_size)		malloc(_size)
#define	xcalloc(_nmemb, _size)	calloc((_nmemb), (_size))
#define	xrealloc(_ptr, _size)	realloc((_ptr), (_size))
#define	xstrdup(_str)		strcpy((malloc(strlen(_str)+1)
#endif	/* defined(__GNUC__) */

#endif	/* H_SYSTEM */
