/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of RPM.xs. Do not edit this file, edit RPM.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "RPM.xs"
#include <stdio.h>
#include <string.h>
#include "rpmlib.h"
#include "rpmcli.h"

#ifdef RPM_RPM41
#include "rpmts.h"
#include "rpmte.h"
#endif

#include "header.h"
#include "rpmdb.h"
#include "misc.h"

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#if !defined(RPM_RPM41) && !defined(RPM_RPM40)
#error Must define one of RPM_RPM41 or RPM_RPM40; perhaps Makefile.PL could not guess your RPM API version?
#endif

/* Chip, this is somewhat stripped down from the default callback used by
   the rpmcli.  It has to be here to insure that we open the pkg again. 
   If we don't do this we get segfaults.  I also, kept the updating of some
   of the rpmcli static vars, but I may not have needed to do this.

   Also, we probably want to give a nice interface such that we could allow
   users of RPM to do their own callback, but that will have to come later.
*/
void * _null_callback(
	const void * arg, 
	const rpmCallbackType what, 
	const unsigned long long amount, 
	const unsigned long long total, 
	fnpyKey key, 
	rpmCallbackData data)
{
	Header h = (Header) arg;
	char * s;
	int flags = (int) ((long)data);
	void * rc = NULL;
	const char * filename = (const char *)key;
	static FD_t fd = NULL;
	int xx;

	/* Code stolen from rpminstall.c and modified */
	switch(what) {
		case RPMCALLBACK_INST_OPEN_FILE:
	 		if (filename == NULL || filename[0] == '\0')
			     return NULL;
			fd = Fopen(filename, "r.ufdio");
			/* FIX: still necessary? */
			if (fd == NULL || Ferror(fd)) {
				fprintf(stderr, "open of %s failed!\n", filename);
				if (fd != NULL) {
					xx = Fclose(fd);
					fd = NULL;
				}
			} else
				fd = fdLink(fd, "persist (showProgress)");
			return (void *)fd;
	 		break;

	case RPMCALLBACK_INST_CLOSE_FILE:
		/* FIX: still necessary? */
		fd = fdFree(fd, "persist (showProgress)");
		if (fd != NULL) {
			xx = Fclose(fd);
			fd = NULL;
		}
		break;

	case RPMCALLBACK_INST_START:
		rpmcliHashesCurrent = 0;
		if (h == NULL || !(flags & INSTALL_LABEL))
			break;
		break;

	case RPMCALLBACK_TRANS_PROGRESS:
	case RPMCALLBACK_INST_PROGRESS:
		break;

	case RPMCALLBACK_TRANS_START:
		rpmcliHashesCurrent = 0;
		rpmcliProgressTotal = 1;
		rpmcliProgressCurrent = 0;
		break;

	case RPMCALLBACK_TRANS_STOP:
		rpmcliProgressTotal = rpmcliPackagesTotal;
		rpmcliProgressCurrent = 0;
		break;

	case RPMCALLBACK_REPACKAGE_START:
		rpmcliHashesCurrent = 0;
		rpmcliProgressTotal = total;
		rpmcliProgressCurrent = 0;
		break;

	case RPMCALLBACK_REPACKAGE_PROGRESS:
		break;

	case RPMCALLBACK_REPACKAGE_STOP:
		rpmcliProgressTotal = total;
		rpmcliProgressCurrent = total;
		rpmcliProgressTotal = rpmcliPackagesTotal;
		rpmcliProgressCurrent = 0;
		break;

	case RPMCALLBACK_UNINST_PROGRESS:
		break;
	case RPMCALLBACK_UNINST_START:
		break;
	case RPMCALLBACK_UNINST_STOP:
		break;
	case RPMCALLBACK_UNPACK_ERROR:
		break;
	case RPMCALLBACK_CPIO_ERROR:
		break;
	case RPMCALLBACK_UNKNOWN:
		break;
	default:
		break;
	}
	
	return rc;	
}

void
_populate_header_tags(HV *href)
{
    int i = 0;

    for (i = 0; i < rpmTagTableSize; i++) {
        hv_store(href, rpmTagTable[i].name, strlen(rpmTagTable[i].name), newSViv(rpmTagTable[i].val), 0);
    }
}

void
_populate_constant(HV *href, char *name, int val)
{
    hv_store(href, name, strlen(name), newSViv(val), 0);
}

#define REGISTER_CONSTANT(name) _populate_constant(constants, #name, name)

#line 158 "RPM.c"

XS(XS_RPM_rpm_api_version); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM_rpm_api_version)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::rpm_api_version(pkg)");
    {
	char *	pkg = (char *)SvPV_nolen(ST(0));
	double	RETVAL;
	dXSTARG;
#line 187 "RPM.xs"
#if defined(RPM_RPM41) && ! defined(RPM_RPM40)
	RETVAL = (double)4.1;
#endif
#if ! defined(RPM_RPM41) && defined(RPM_RPM40)
	RETVAL = (double)4.0;
#endif
#line 177 "RPM.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM_add_macro); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM_add_macro)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: RPM::add_macro(pkg, name, val)");
    {
	char *	pkg = (char *)SvPV_nolen(ST(0));
	char *	name = (char *)SvPV_nolen(ST(1));
	char *	val = (char *)SvPV_nolen(ST(2));
#line 203 "RPM.xs"
	addMacro(NULL, name, NULL, val, RMIL_DEFAULT);
#line 196 "RPM.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_RPM_delete_macro); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM_delete_macro)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::delete_macro(pkg, name)");
    {
	char *	pkg = (char *)SvPV_nolen(ST(0));
	char *	name = (char *)SvPV_nolen(ST(1));
#line 210 "RPM.xs"
	delMacro(NULL, name);
#line 213 "RPM.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_RPM_expand_macro); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM_expand_macro)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::expand_macro(pkg, str)");
    SP -= items;
    {
	char *	pkg = (char *)SvPV_nolen(ST(0));
	char *	str = (char *)SvPV_nolen(ST(1));
#line 217 "RPM.xs"
	char *ret;
#line 231 "RPM.c"
#line 219 "RPM.xs"
	ret = rpmExpand(str, NULL);
	PUSHs(sv_2mortal(newSVpv(ret, 0)));
	free(ret);
#line 236 "RPM.c"
	PUTBACK;
	return;
    }
}


XS(XS_RPM_rpmvercmp); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM_rpmvercmp)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::rpmvercmp(one, two)");
    {
	char*	one = (char *)SvPV_nolen(ST(0));
	char*	two = (char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

	RETVAL = rpmvercmp(one, two);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__read_package_info); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__read_package_info)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::_read_package_info(fp, vsflags)");
    SP -= items;
    {
	FILE *	fp = PerlIO_findFILE(IoIFP(sv_2io(ST(0))));
	int	vsflags = (int)SvIV(ST(1));
#line 233 "RPM.xs"
#ifdef RPM_RPM41
	rpmts ts;
#endif
	Header ret;
	Header sigs;
	rpmRC rc;
	FD_t fd;
#line 280 "RPM.c"
#line 241 "RPM.xs"
#ifdef RPM_RPM41
	ts = rpmtsCreate();
#endif

        /* XXX Determine type of signature verification when reading
	vsflags |= _RPMTS_VSF_NOLEGACY;
	vsflags |= _RPMTS_VSF_NODIGESTS;
	vsflags |= _RPMTS_VSF_NOSIGNATURES;
	xx = rpmtsSetVerifySigFlags(ts, vsflags);
        */ 

	fd = fdDup(fileno(fp));
#ifdef RPM_RPM41
	rpmtsSetVSFlags(ts, vsflags);
	rc = rpmReadPackageFile(ts, fd, "filename or other identifier", &ret);
#else
	rc = rpmReadPackageInfo(fd, NULL, &ret);
#endif

	Fclose(fd);

	if (rc == RPMRC_OK) {
	    SV *h_sv;

	    EXTEND(SP, 1);

	    h_sv = sv_newmortal();
            sv_setref_pv(h_sv, "RPM::C::Header", (void *)ret);

	    PUSHs(h_sv);
	}
	else {
	    croak("error reading package");
	}
#ifdef RPM_RPM41
	ts = rpmtsFree(ts);
#endif
#line 319 "RPM.c"
	PUTBACK;
	return;
    }
}


XS(XS_RPM__create_transaction); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__create_transaction)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::_create_transaction(vsflags)");
    SP -= items;
    {
	int	vsflags = (int)SvIV(ST(0));
#line 283 "RPM.xs"
	rpmts ret;
	SV *h_sv;
#line 338 "RPM.c"
#line 286 "RPM.xs"
	/* Looking at librpm, it does not look like this ever
	   returns error (though maybe it should).
	*/
	ret = rpmtsCreate();

	/* Should I save the old vsflags aside? */
	rpmtsSetVSFlags(ret, vsflags);

	/* Convert and throw the results on the stack */	
	EXTEND(SP, 1);

	h_sv = sv_newmortal();
	sv_setref_pv(h_sv, "RPM::C::Transaction", (void *)ret);

	PUSHs(h_sv);
#line 355 "RPM.c"
	PUTBACK;
	return;
    }
}


XS(XS_RPM__read_from_file); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__read_from_file)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::_read_from_file(fp)");
    SP -= items;
    {
	FILE *	fp = PerlIO_findFILE(IoIFP(sv_2io(ST(0))));
#line 306 "RPM.xs"
	SV *h_sv;
	FD_t fd;
	Header h;
#line 375 "RPM.c"
#line 310 "RPM.xs"
	fd = fdDup(fileno(fp));
	h = headerRead(fd, HEADER_MAGIC_YES);

	if (h) {
	    EXTEND(SP, 1);

	    h_sv = sv_newmortal();
	    sv_setref_pv(h_sv, "RPM::C::Header", (void *)h);

	    PUSHs(h_sv);
	}
	Fclose(fd);
#line 389 "RPM.c"
	PUTBACK;
	return;
    }
}


XS(XS_RPM__open_rpm_db); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__open_rpm_db)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::_open_rpm_db(for_write)");
    {
	int	for_write = (int)SvIV(ST(0));
#line 328 "RPM.xs"
	 rpmdb db;
#line 406 "RPM.c"
	rpmdb	RETVAL;
#line 330 "RPM.xs"
	if (rpmdbOpen(NULL, &db, for_write ? O_RDWR | O_CREAT : O_RDONLY, 0644)) {
		croak("rpmdbOpen failed");
		RETVAL = NULL;
	}
	RETVAL = db;		
#line 414 "RPM.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), "RPM::C::DB", (void*)RETVAL );
    }
    XSRETURN(1);
}


XS(XS_RPM__C__DB_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__DB_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::DB::DESTROY(db)");
    {
	rpmdb	db;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        db = (rpmdb)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::DB::DESTROY() -- db is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 344 "RPM.xs"
	rpmdbClose(db);
#line 439 "RPM.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_RPM__C__DB__close_rpm_db); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__DB__close_rpm_db)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::DB::_close_rpm_db(self)");
    {
	rpmdb	self;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        self = (rpmdb)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::DB::_close_rpm_db() -- self is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 350 "RPM.xs"
	rpmdbClose(self);
#line 462 "RPM.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_RPM__C__DB__init_iterator); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__DB__init_iterator)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: RPM::C::DB::_init_iterator(db, rpmtag, key, len)");
    {
	rpmdb	db;
	int	rpmtag = (int)SvIV(ST(1));
	char *	key = (char *)SvPV_nolen(ST(2));
	size_t	len = (size_t)SvUV(ST(3));
	rpmdbMatchIterator	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        db = (rpmdb)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::DB::_init_iterator() -- db is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 359 "RPM.xs"
	RETVAL = rpmdbInitIterator(db, rpmtag, key && *key ? key : NULL, len);
#line 489 "RPM.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), "RPM::C::PackageIterator", (void*)RETVAL );
    }
    XSRETURN(1);
}


XS(XS_RPM__C__PackageIterator__iterator_next); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__PackageIterator__iterator_next)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::PackageIterator::_iterator_next(i)");
    SP -= items;
    {
	rpmdbMatchIterator	i;
#line 368 "RPM.xs"
	Header       ret;
        SV *         h_sv;
	unsigned int offset;
#line 510 "RPM.c"
	Header	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        i = (rpmdbMatchIterator)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::PackageIterator::_iterator_next() -- i is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 372 "RPM.xs"
	ret = rpmdbNextIterator(i);
	if (ret)
		headerLink(ret);
	if(ret != NULL) 
		offset = rpmdbGetIteratorOffset(i);
	else
		offset = 0;

	EXTEND(SP, 2);
	h_sv = sv_newmortal();
	sv_setref_pv(h_sv, "RPM::C::Header", (void *)ret);
	PUSHs(h_sv);
	PUSHs(sv_2mortal(newSViv(offset)));
#line 533 "RPM.c"
	PUTBACK;
	return;
    }
}


XS(XS_RPM__C__PackageIterator_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__PackageIterator_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::PackageIterator::DESTROY(i)");
    {
	rpmdbMatchIterator	i;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        i = (rpmdbMatchIterator)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::PackageIterator::DESTROY() -- i is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 390 "RPM.xs"
	rpmdbFreeIterator(i);
#line 557 "RPM.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_RPM__C__Header_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Header_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::Header::DESTROY(h)");
    {
	Header	h;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        h = (Header)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Header::DESTROY() -- h is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 399 "RPM.xs"
	headerFree(h);
#line 580 "RPM.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_RPM__C__Header_tag_by_id); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Header_tag_by_id)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::C::Header::tag_by_id(h, tag)");
    SP -= items;
    {
	Header	h;
	int	tag = (int)SvIV(ST(1));
#line 406 "RPM.xs"
	void *ret = NULL;
	int type;
	int n;
	int ok;
#line 601 "RPM.c"

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        h = (Header)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Header::tag_by_id() -- h is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 411 "RPM.xs"
	ok = headerGetEntry(h, tag, &type, &ret, &n);

	if (!ok) {
		/* nop, empty stack */
	}
	else {
		switch(type)
		{
		case RPM_STRING_ARRAY_TYPE:
			{
			int i;
			char **s;

			EXTEND(SP, n);
			s = (char **)ret;

			for (i = 0; i < n; i++) {
				PUSHs(sv_2mortal(newSVpv(s[i], 0)));
			}
			}
			break;
		case RPM_STRING_TYPE:
			PUSHs(sv_2mortal(newSVpv((char *)ret, 0)));
			break;
		case RPM_CHAR_TYPE:
		case RPM_INT8_TYPE:
		case RPM_INT16_TYPE:
		case RPM_INT32_TYPE:
			{
			int i;
			int *r;

			EXTEND(SP, n);
			r = (int *)ret;

			for (i = 0; i < n; i++) {
				PUSHs(sv_2mortal(newSViv(r[i])));
			}
			}
			break;
		default:
			croak("unknown rpm tag type %d", type);
		}
	}
	headerFreeData(ret, type);
#line 655 "RPM.c"
	PUTBACK;
	return;
    }
}


XS(XS_RPM__C__Header__header_compare); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Header__header_compare)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::C::Header::_header_compare(h1, h2)");
    {
	Header	h1;
	Header	h2;
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        h1 = (Header)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Header::_header_compare() -- h1 is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG))
        h2 = (Header)SvIV((SV*)SvRV( ST(1) ));
    else {
        warn( "RPM::C::Header::_header_compare() -- h2 is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 462 "RPM.xs"
	RETVAL = rpmVersionCompare(h1, h2);
#line 689 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__C__Header__header_is_source); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Header__header_is_source)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::Header::_header_is_source(h)");
    {
	Header	h;
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        h = (Header)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Header::_header_is_source() -- h is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 470 "RPM.xs"
	RETVAL = headerIsEntry(h, RPMTAG_SOURCEPACKAGE);
#line 715 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__C__Header__header_sprintf); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Header__header_sprintf)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::C::Header::_header_sprintf(h, format)");
    SP -= items;
    {
	Header	h;
	char *	format = (char *)SvPV_nolen(ST(1));
#line 479 "RPM.xs"
	char * s;
#line 734 "RPM.c"

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        h = (Header)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Header::_header_sprintf() -- h is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 481 "RPM.xs"
	s =  headerSprintf(h, format, rpmTagTable, rpmHeaderFormats, NULL);
	PUSHs(sv_2mortal(newSVpv((char *)s, 0)));
	s = _free(s);
#line 746 "RPM.c"
	PUTBACK;
	return;
    }
}


XS(XS_RPM__C__Transaction_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::DESTROY(t)");
    {
	rpmts	t;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::DESTROY() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 492 "RPM.xs"
	t = rpmtsFree(t);
#line 770 "RPM.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_RPM__C__Transaction__add_install); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction__add_install)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::_add_install(t, h, fn, upgrade)");
    {
	rpmts	t;
	Header	h;
	char *	fn = (char *)SvPV_nolen(ST(2));
	int	upgrade = (int)SvIV(ST(3));
#line 502 "RPM.xs"
	rpmRC rc = 0;
#line 789 "RPM.c"
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::_add_install() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG))
        h = (Header)SvIV((SV*)SvRV( ST(1) ));
    else {
        warn( "RPM::C::Transaction::_add_install() -- h is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 504 "RPM.xs"
	rc = rpmtsAddInstallElement(t, h, (fnpyKey) fn, upgrade, NULL);
	RETVAL = (rc == RPMRC_OK) ? 1 : 0;
#line 809 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__C__Transaction__add_delete); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction__add_delete)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::_add_delete(t, h, offset)");
    {
	rpmts	t;
	Header	h;
	unsigned int	offset = (unsigned int)SvUV(ST(2));
#line 515 "RPM.xs"
	rpmRC rc = 0;
#line 828 "RPM.c"
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::_add_delete() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG))
        h = (Header)SvIV((SV*)SvRV( ST(1) ));
    else {
        warn( "RPM::C::Transaction::_add_delete() -- h is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 517 "RPM.xs"
	rc = rpmtsAddEraseElement(t, h, offset);
	RETVAL = (rc == RPMRC_OK) ? 1 : 0;
#line 848 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__C__Transaction__element_count); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction__element_count)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::_element_count(t)");
    {
	rpmts	t;
#line 526 "RPM.xs"
	int ret;
#line 865 "RPM.c"
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::_element_count() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 528 "RPM.xs"
	ret    = rpmtsNElements(t);
	RETVAL = ret;
#line 878 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__C__Transaction__close_db); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction__close_db)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::_close_db(t)");
    {
	rpmts	t;
#line 537 "RPM.xs"
	int ret;
#line 895 "RPM.c"
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::_close_db() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 539 "RPM.xs"
	ret    = rpmtsCloseDB(t);
	RETVAL = (ret == 0) ? 1 : 0;
#line 908 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__C__Transaction__check); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction__check)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::_check(t)");
    {
	rpmts	t;
#line 548 "RPM.xs"
	int ret;
#line 925 "RPM.c"
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::_check() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 550 "RPM.xs"
	ret    = rpmtsCheck(t);
	RETVAL = (ret == 0) ? 1 : 0;
#line 938 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__C__Transaction__order); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction__order)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::_order(t)");
    {
	rpmts	t;
#line 559 "RPM.xs"
	int ret;
#line 955 "RPM.c"
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::_order() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 561 "RPM.xs"
	ret    = rpmtsOrder(t);
	/* XXX:  May want to do something different here.  It actually
	         returns the number of non-ordered elements...maybe we
	         want this?
	*/
	RETVAL = (ret == 0) ? 1 : 0;
#line 972 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_RPM__C__Transaction__elements); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction__elements)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::_elements(t, type)");
    SP -= items;
    {
	rpmts	t;
	rpmElementType	type = (rpmElementType)SvIV(ST(1));
#line 575 "RPM.xs"
	rpmtsi       i;
	rpmte        te;
	const char * NEVR;
#line 993 "RPM.c"

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::_elements() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 579 "RPM.xs"
	i = rpmtsiInit(t);
	if(i == NULL) {
		printf("Did not get a thing!\n");
		return;	
	} else {
		while((te = rpmtsiNext(i, type)) != NULL) {
			NEVR = rpmteNEVR(te);
			XPUSHs(sv_2mortal(newSVpv(NEVR,	0)));
		}
		i = rpmtsiFree(i);
	}
#line 1013 "RPM.c"
	PUTBACK;
	return;
    }
}


XS(XS_RPM__C__Transaction__run); /* prototype to pass -Wmissing-prototypes */
XS(XS_RPM__C__Transaction__run)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: RPM::C::Transaction::_run(t, ok_probs, prob_filter)");
    {
	rpmts	t;
	rpmprobFilterFlags	prob_filter = (rpmprobFilterFlags)SvIV(ST(2));
#line 596 "RPM.xs"
	int i;
	rpmProblem p;
	int ret;
#line 1033 "RPM.c"
	int	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG))
        t = (rpmts)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "RPM::C::Transaction::_run() -- t is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 600 "RPM.xs"
	/* Make sure we could run this transactions */
	ret = rpmtsCheck(t);
	if (ret != 0) {
		RETVAL = 0;
		return;
	}
	ret = rpmtsOrder(t);
	if (ret != 0) {
		RETVAL = 0;
		return;
	}

	/* XXX:  Should support callbacks eventually */
	(void) rpmtsSetNotifyCallback(t, _null_callback, (void *) ((long)0));
	ret    = rpmtsRun(t, NULL, prob_filter);
	RETVAL = (ret == 0) ? 1 : 0;
#line 1060 "RPM.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_RPM); /* prototype to pass -Wmissing-prototypes */
XS(boot_RPM)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXSproto("RPM::rpm_api_version", XS_RPM_rpm_api_version, file, "$");
        newXSproto("RPM::add_macro", XS_RPM_add_macro, file, "$$$");
        newXSproto("RPM::delete_macro", XS_RPM_delete_macro, file, "$$");
        newXSproto("RPM::expand_macro", XS_RPM_expand_macro, file, "$$");
        newXSproto("RPM::rpmvercmp", XS_RPM_rpmvercmp, file, "$$");
        newXSproto("RPM::_read_package_info", XS_RPM__read_package_info, file, "$$");
        newXSproto("RPM::_create_transaction", XS_RPM__create_transaction, file, "$");
        newXSproto("RPM::_read_from_file", XS_RPM__read_from_file, file, "$");
        newXSproto("RPM::_open_rpm_db", XS_RPM__open_rpm_db, file, "$");
        newXSproto("RPM::C::DB::DESTROY", XS_RPM__C__DB_DESTROY, file, "$");
        newXSproto("RPM::C::DB::_close_rpm_db", XS_RPM__C__DB__close_rpm_db, file, "$");
        newXSproto("RPM::C::DB::_init_iterator", XS_RPM__C__DB__init_iterator, file, "$$$$");
        newXSproto("RPM::C::PackageIterator::_iterator_next", XS_RPM__C__PackageIterator__iterator_next, file, "$");
        newXSproto("RPM::C::PackageIterator::DESTROY", XS_RPM__C__PackageIterator_DESTROY, file, "$");
        newXSproto("RPM::C::Header::DESTROY", XS_RPM__C__Header_DESTROY, file, "$");
        newXSproto("RPM::C::Header::tag_by_id", XS_RPM__C__Header_tag_by_id, file, "$$");
        newXSproto("RPM::C::Header::_header_compare", XS_RPM__C__Header__header_compare, file, "$$");
        newXSproto("RPM::C::Header::_header_is_source", XS_RPM__C__Header__header_is_source, file, "$");
        newXSproto("RPM::C::Header::_header_sprintf", XS_RPM__C__Header__header_sprintf, file, "$$");
        newXSproto("RPM::C::Transaction::DESTROY", XS_RPM__C__Transaction_DESTROY, file, "$");
        newXSproto("RPM::C::Transaction::_add_install", XS_RPM__C__Transaction__add_install, file, "$$$$");
        newXSproto("RPM::C::Transaction::_add_delete", XS_RPM__C__Transaction__add_delete, file, "$$$");
        newXSproto("RPM::C::Transaction::_element_count", XS_RPM__C__Transaction__element_count, file, "$");
        newXSproto("RPM::C::Transaction::_close_db", XS_RPM__C__Transaction__close_db, file, "$");
        newXSproto("RPM::C::Transaction::_check", XS_RPM__C__Transaction__check, file, "$");
        newXSproto("RPM::C::Transaction::_order", XS_RPM__C__Transaction__order, file, "$");
        newXSproto("RPM::C::Transaction::_elements", XS_RPM__C__Transaction__elements, file, "$$");
        newXSproto("RPM::C::Transaction::_run", XS_RPM__C__Transaction__run, file, "$$$");

    /* Initialisation Section */

#line 152 "RPM.xs"
    {
	HV *header_tags, *constants;
	rpmReadConfigFiles(rpmRcfiles, NULL);

	header_tags = perl_get_hv("RPM::header_tag_map", TRUE);
	_populate_header_tags(header_tags);

	constants = perl_get_hv("RPM::constants", TRUE);

	/* not the 'standard' way of doing perl constants, but a lot easier to maintain */
#ifdef RPM_RPM41
	REGISTER_CONSTANT(RPMVSF_DEFAULT);
	REGISTER_CONSTANT(RPMVSF_NOHDRCHK);
	REGISTER_CONSTANT(RPMVSF_NEEDPAYLOAD);
	REGISTER_CONSTANT(RPMVSF_NOSHA1HEADER);
	REGISTER_CONSTANT(RPMVSF_NOMD5HEADER);
	REGISTER_CONSTANT(RPMVSF_NODSAHEADER);
	REGISTER_CONSTANT(RPMVSF_NORSAHEADER);
	REGISTER_CONSTANT(RPMVSF_NOSHA1);
	REGISTER_CONSTANT(RPMVSF_NOMD5);
	REGISTER_CONSTANT(RPMVSF_NODSA);
	REGISTER_CONSTANT(RPMVSF_NORSA);
	REGISTER_CONSTANT(_RPMVSF_NODIGESTS);
	REGISTER_CONSTANT(_RPMVSF_NOSIGNATURES);
	REGISTER_CONSTANT(_RPMVSF_NOHEADER);
	REGISTER_CONSTANT(_RPMVSF_NOPAYLOAD);
	REGISTER_CONSTANT(TR_ADDED);
	REGISTER_CONSTANT(TR_REMOVED);
#endif
    }

#line 1140 "RPM.c"

    /* End of Initialisation Section */

    XSRETURN_YES;
}

