/*****************************************************************************
 * Project: RooFit                                                           *
 * Package: RooFitCore                                                       *
 *    File: $Id: RooAbsOptGoodnessOfFit.h,v 1.15 2007/05/11 09:11:30 verkerke Exp $
 * Authors:                                                                  *
 *   WV, Wouter Verkerke, UC Santa Barbara, verkerke@slac.stanford.edu       *
 *   DK, David Kirkby,    UC Irvine,         dkirkby@uci.edu                 *
 *                                                                           *
 * Copyright (c) 2000-2005, Regents of the University of California          *
 *                          and Stanford University. All rights reserved.    *
 *                                                                           *
 * Redistribution and use in source and binary forms,                        *
 * with or without modification, are permitted according to the terms        *
 * listed in LICENSE (http://roofit.sourceforge.net/license.txt)             *
 *****************************************************************************/
#ifndef ROO_ABS_OPT_TEST_STATISTIC
#define ROO_ABS_OPT_TEST_STATISTIC

// We can't print deprecation warnings when including headers in cling, because
// this will be done automatically anyway.
#ifdef __CLING__
#ifndef ROOFIT_BUILDS_ITSELF
// These warnings should only be suppressed when building ROOT itself!
#warning "Including RooAbsOptTestStatistic.h is deprecated, and this header will be removed in ROOT v6.34: it is an implementation detail that should not be part of the public user interface"
#else
// If we are builting RooFit itself, this will serve as a reminder to actually
// remove this deprecate public header. Here is now this needs to be done:
//    1. Move this header file from inc/ to src/
//    2. Remove the LinkDef entry, ClassDefOverride, and ClassImpl macros for
//       this class
//    3. If there are are tests using this class in the test/ directory, change
//       the include to use a relative path the moved header file in the src/
//       directory, e.g. #include <RemovedInterface.h> becomes #include
//       "../src/RemovedInterface.h"
//    4. Remove this ifndef-else-endif block from the header
//    5. Remove the deprecation warning at the end of the class declaration
#include <RVersion.h>
#if ROOT_VERSION_CODE >= ROOT_VERSION(6, 34, 00)
#error "Please remove this deprecated public interface."
#endif
#endif
#endif

#include "RooAbsTestStatistic.h"
#include "RooSetProxy.h"
#include "RooCategoryProxy.h"
#include "TString.h"

class RooArgSet ;
class RooAbsData ;
class RooAbsReal ;

class RooAbsOptTestStatistic : public RooAbsTestStatistic {
public:

  // Constructors, assignment etc
  RooAbsOptTestStatistic(const char *name, const char *title, RooAbsReal& real, RooAbsData& data,
                         const RooArgSet& projDeps,
                         RooAbsTestStatistic::Configuration const& cfg);
  RooAbsOptTestStatistic(const RooAbsOptTestStatistic& other, const char* name=nullptr);
  ~RooAbsOptTestStatistic() override;

  double combinedValue(RooAbsReal** gofArray, Int_t nVal) const override ;

  RooAbsReal& function() { return *_funcClone ; }
  const RooAbsReal& function() const { return *_funcClone ; }

  RooAbsData& data() ;
  const RooAbsData& data() const ;


  const char* cacheUniqueSuffix() const override;

  // Override this to be always true to force calculation of likelihood without parameters
  bool isDerived() const override { return true ; }

  void seal(const char* notice="") { _sealed = true ; _sealNotice = notice ; }
  bool isSealed() const { return _sealed ; }
  const char* sealNotice() const { return _sealNotice.Data() ; }

private:
  void setUpBinSampling();

protected:

  bool setDataSlave(RooAbsData& data, bool cloneData=true, bool ownNewDataAnyway=false) override ;
  void initSlave(RooAbsReal& real, RooAbsData& indata, const RooArgSet& projDeps, const char* rangeName,
       const char* addCoefRangeName)  ;

  friend class RooAbsReal ;
  friend class RooAbsTestStatistic ;

  virtual bool allowFunctionCache() { return true ;  }
  void constOptimizeTestStatistic(ConstOpCode opcode, bool doAlsoTrackingOpt=true) override ;

  bool redirectServersHook(const RooAbsCollection& newServerList, bool mustReplaceAll, bool nameChange, bool isRecursive) override ;
  void printCompactTreeHook(std::ostream& os, const char* indent="") override ;
  virtual RooArgSet requiredExtraObservables() const { return RooArgSet() ; }
  void optimizeCaching() ;
  void optimizeConstantTerms(bool,bool=true) ;
  void runRecalculateCache(std::size_t firstEvent, std::size_t lastEvent, std::size_t stepSize) const override;

  RooArgSet*  _normSet = nullptr;           ///< Pointer to set with observables used for normalization
  RooArgSet*  _funcCloneSet = nullptr;      ///< Set owning all components of internal clone of input function
  RooAbsData* _dataClone = nullptr; ///< Pointer to internal clone if input data
  RooAbsReal* _funcClone = nullptr;   ///< Pointer to internal clone of input function
  RooArgSet*  _projDeps = nullptr;    ///< Set of projected observable
  bool      _ownData = false;    ///< Do we own the dataset
  bool      _sealed = false;      ///< Is test statistic sealed -- i.e. no access to data
  TString     _sealNotice ;  ///< User-defined notice shown when reading a sealed likelihood
  RooArgSet*  _funcObsSet = nullptr;  ///< List of observables in the pdf expression
  RooArgSet   _cachedNodes ; ///<! List of nodes that are cached as constant expressions
  bool _skipZeroWeights = false; ///<! Whether to skip entries with weight zero in the evaluation

  RooAbsReal* _origFunc = nullptr;  ///< Original function
  RooAbsData* _origData = nullptr;  ///< Original data
  bool      _optimized = false; ///<!
  double      _integrateBinsPrecision{-1.}; // Precision for finer sampling of bins.

  ClassDefOverride(RooAbsOptTestStatistic,0) // Abstract base class for optimized test statistics
#ifndef ROOFIT_BUILDS_ITSELF
} R__DEPRECATED(6,34, "RooAbsOptTestStatistic is a RooFit implementation detail that should not be instantiated in user code.");
#else
};
#endif

#endif
