//@ui5-bundle sap/ui/table/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/table/AnalyticalColumn',['./Column','./library','sap/ui/core/Element','sap/ui/model/type/Boolean','sap/ui/model/type/DateTime','sap/ui/model/type/Float','sap/ui/model/type/Integer','sap/ui/model/type/Time','./utils/TableUtils','./AnalyticalColumnMenu'],function(C,l,E,B,D,F,I,T,a,A){"use strict";
function i(c){return a.isA(c,"sap.ui.table.AnalyticalTable");}
var b=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});
b._DEFAULT_FILTERTYPES={"Time":new T({UTC:true}),"DateTime":new D({UTC:true}),"Float":new F(),"Integer":new I(),"Boolean":new B()};
b.prototype._createMenu=function(){return new A(this.getId()+"-menu");};
b.prototype.setGrouped=function(g){var p=this.getParent();if(i(p)){if(g){p._addGroupedColumn(this.getId());}else{p._removeGroupedColumn(this.getId());}}var r=this.setProperty("grouped",g);this._updateColumns();return r;};
b.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};
b.prototype.setVisible=function(v){C.prototype.setVisible.call(this,v);this._updateColumns();return this;};
b.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(i(p)){var o=p.getBinding();if(o){this._oBindingLabel=l.TableHelper.createLabel();this.addDependent(this._oBindingLabel);a.Binding.metadataLoaded(p).then(function(){this._oBindingLabel.setText(o.getPropertyLabel(this.getLeadingProperty()));}.bind(this));}}}L=this._oBindingLabel;}return L;};
b.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding();var L=this.getLeadingProperty();if(o&&o.getFilterablePropertyNames().indexOf(L)>-1){p=L;}}}return p;};
b.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding();var L=this.getLeadingProperty();if(o&&o.getSortablePropertyNames().indexOf(L)>-1){p=L;}}}return p;};
b.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(i(p)){var o=p.getBinding();var L=this.getLeadingProperty(),P=o&&o.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=b._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=b._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=b._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=b._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=b._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};
b.prototype._updateColumns=function(s,f){var p=this.getParent();if(i(p)){p._updateColumns(s,f);}};
b.prototype._updateTableAnalyticalInfo=function(s){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p.updateAnalyticalInfo(s);}};
b.prototype._updateTableColumnDetails=function(){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p._updateTableColumnDetails();}};
b.prototype.shouldRender=function(){if(!this.getVisible()||!this.getTemplate()){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};
b.prototype.getTooltip_AsString=function(){if(!this.getTooltip()){return this._getDefaultTooltip();}return E.prototype.getTooltip_AsString.apply(this);};
b.prototype.getTooltip_Text=function(){var t=E.prototype.getTooltip_Text.apply(this);if(!this.getTooltip()||!t){t=this._getDefaultTooltip();}return t;};
b.prototype._getDefaultTooltip=function(){var p=this.getParent();if(i(p)){var o=p.getBinding();if(o&&this.getLeadingProperty()){return o.getPropertyQuickInfo(this.getLeadingProperty());}}return null;};
b.prototype._menuHasItems=function(){var m=function(){var t=this.getParent();var o=t.getBinding();var r=o&&o.getAnalyticalQueryResult();return(t&&r&&r.findMeasureByPropertyName(this.getLeadingProperty()));}.bind(this);return C.prototype._menuHasItems.apply(this)||m();};
b.prototype.isFilterableByMenu=function(){var f=this.getFilterProperty();if(!f||!this.getShowFilterMenuEntry()){return false;}var p=this.getParent();if(i(p)){var o=p.getBinding();if(o){if(o.getFilterablePropertyNames().indexOf(f)>-1&&o.getProperty(f)){return true;}}}return false;};
b.prototype.isGroupable=function(){var p=this.getParent();if(i(p)){var o=p.getBinding();if(o){var r=o.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&o.getSortablePropertyNames().indexOf(this.getLeadingProperty())>-1&&o.getFilterablePropertyNames().indexOf(this.getLeadingProperty())>-1){return true;}}}return false;};
b.prototype._setCellContentVisibilitySettings=function(){};
return b;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenu',['./ColumnMenu',"sap/ui/unified/MenuRenderer",'./library',"sap/ui/thirdparty/jquery"],function(C,M,l,q){"use strict";var G=l.GroupEventType;
var A=C.extend("sap.ui.table.AnalyticalColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.unified.MenuRenderer"
});
A.prototype._addMenuItems=function(){C.prototype._addMenuItems.apply(this);if(this._oColumn){this._addSumMenuItem();}};
A.prototype._addGroupMenuItem=function(){var c=this._oColumn,t=this._oTable;if(c.isGroupable()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",c.getGrouped()?"accept":null,function(e){var m=e.getSource();var g=c.getGrouped();var s=g?G.group:G.ungroup;c.setGrouped(!g);t.fireGroup({column:c,groupedColumns:t._aGroupedColumns,type:s});m.setIcon(!g?"sap-icon://accept":null);});this.addItem(this._oGroupIcon);}};
A.prototype._addSumMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding(),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findMeasureByPropertyName(c.getLeadingProperty())){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",c.getSummed()?"accept":null,q.proxy(function(e){var m=e.getSource(),s=c.getSummed();c.setSummed(!s);m.setIcon(!s?"sap-icon://accept":null);},this));this.addItem(this._oSumItem);}};
A.prototype.open=function(){C.prototype.open.apply(this,arguments);var c=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(c.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(c.getGrouped()?"sap-icon://accept":null);};
return A;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenuRenderer',['sap/ui/table/AnalyticalColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/AnalyticalTable',['./AnalyticalColumn','./Column','./Table','./TreeTable',"./TableRenderer",'./library','sap/ui/model/analytics/ODataModelAdapter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/unified/Menu','sap/ui/unified/MenuItem','./utils/TableUtils',"./plugins/BindingSelection","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery"],function(A,C,T,a,b,c,O,S,d,M,e,f,B,L,g,q){"use strict";var G=c.GroupEventType;var h=c.SortOrder;var k=c.TreeAutoExpandMode;var _=f.createWeakMapFacade();
var m=T.extend("sap.ui.table.AnalyticalTable",{
metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},designtime:"sap/ui/table/designtime/AnalyticalTable.designtime"},
renderer:"sap.ui.table.TableRenderer"
});
m.prototype._getFixedBottomRowContexts=function(){var o=this.getBinding();return o?[o.getGrandTotalNode()]:[];};
m.prototype._getContexts=a.prototype._getContexts;m.prototype._getRowContexts=a.prototype._getRowContexts;
m.prototype.init=function(){T.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:false});this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;this._mGroupHeaderMenuItems=null;f.Grouping.setToDefaultGroupMode(this);f.Hook.register(this,f.Hook.Keys.Row.UpdateState,u,this);f.Hook.register(this,f.Hook.Keys.Table.OpenMenu,r,this);f.Hook.register(this,f.Hook.Keys.Row.Expand,n,this);f.Hook.register(this,f.Hook.Keys.Row.Collapse,p,this);};
m.prototype.exit=function(){T.prototype.exit.apply(this,arguments);this._cleanupGroupHeaderMenuItems();};
m.prototype._adaptLocalization=function(R,l){return T.prototype._adaptLocalization.apply(this,arguments).then(function(){if(l){this._cleanupGroupHeaderMenuItems();}}.bind(this));};
m.prototype.setFixedRowCount=function(){L.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this;};
m.prototype.setFixedBottomRowCount=function(){L.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this;};
m.prototype.setDirty=function(D){L.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",D,true);this.setShowOverlay(this.getDirty());return this;};
m.prototype.setEnableGrouping=function(){L.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this;};
m.prototype.setGroupBy=function(){L.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this;};
m.prototype.getModel=function(N){var o=T.prototype.getModel.apply(this,arguments);var R=this.getBindingInfo("rows");if(o&&R&&R.model==N){O.apply(o);}return o;};
m.prototype.updateRows=function(R){T.prototype.updateRows.apply(this,arguments);if(R!=="sort"){this._invalidateColumnMenus();}};
m.prototype._bindRows=function(o){delete _(this).bPendingRequest;this._applyAnalyticalBindingInfo(o);T.prototype._bindRows.call(this,o);};
m.prototype._bindAggregation=function(N,o){if(N==="rows"){this._invalidateColumnMenus();this._applyODataModelAnalyticalAdapter(o.model);this._setFirstVisibleRowIndex(0,{onlySetProperty:true});}T.prototype._bindAggregation.call(this,N,o);if(N==="rows"){this._updateTotalRow(true);f.Binding.metadataLoaded(this).then(function(){this._updateColumns(true);}.bind(this));}};
m.prototype._applyAnalyticalBindingInfo=function(o){var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){if(j[i].getSorted()){o.sorter=o.sorter||[];o.sorter.push(new d(j[i].getSortProperty()||j[i].getLeadingProperty(),j[i].getSortOrder()===h.Descending));}}o.parameters=o.parameters||{};o.parameters.analyticalInfo=this._getColumnInformation();if(!o.parameters.hasOwnProperty("sumOnTop")){o.parameters.sumOnTop=this.getSumOnTop();}if(!o.parameters.hasOwnProperty("numberOfExpandedLevels")){o.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();}if(o.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){o.parameters.numberOfExpandedLevels=0;}if(!o.parameters.hasOwnProperty("autoExpandMode")){var E=this.getAutoExpandMode();if(E!=k.Bundled&&E!=k.Sequential){E=k.Bundled;}o.parameters.autoExpandMode=E;}};
m.prototype._applyODataModelAnalyticalAdapter=function(o){if(o){O.apply(o);}};
m.prototype._getColumnInformation=function(){var j=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}j.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(this._aGroupedColumns.indexOf(o.getId())>-1){continue;}if(!(o instanceof A)){L.error("You have to use AnalyticalColumns for the Analytical table");}j.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return j;};
function u(s){var o=this.getBinding();var i=this.getBindingInfo("rows");var N=s.context;s.context=N.context;if(!s.context){return;}if(o.nodeHasChildren(N)){s.type=s.Type.GroupHeader;s.expandable=true;}else if(N.nodeState.sum){s.type=s.Type.Summary;}s.level=N.level+(s.type===s.Type.Summary?1:0);s.expanded=N.nodeState.expanded;s.contentHidden=s.expanded&&!i.parameters.sumOnTop;s.title=s.type===s.Type.GroupHeader?o.getGroupName(N.context,N.level):"";}
function n(R){this.expand(R.getIndex());}
function p(R){this.collapse(R.getIndex());}
m.prototype.onRowsUpdated=function(P){T.prototype.onRowsUpdated.apply(this,arguments);var R=this.getRows();var o=this.getBinding();var F=this._getVisibleColumns()[0];for(var i=0;i<R.length;i++){var j=R[i];var l=j.getCells();var s=l.length;for(var t=0;t<s;t++){var v=C.ofCell(l[t]);var I=o?o.isMeasure(v.getLeadingProperty()):false;var $=q(l[t].$().closest("td"));var H=false;if(j.isSummary()&&I){H=!v.getSummed();}else if(j.isGroupHeader()&&v===F){H=!I;}$.toggleClass("sapUiTableCellHidden",H);}}};
function r(o,i){var R=o.isOfType(f.CELLTYPE.ANYCONTENTCELL)?this.getRows()[o.rowIndex]:null;if(!R||!R.isGroupHeader()){this._removeGroupHeaderMenuItems(i);return;}this._iGroupedLevel=R.getLevel();this._addGroupHeaderMenuItems(i);}
m.prototype._addGroupHeaderMenuItems=function(o){var t=this;function j(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var v=t.getColumns().filter(function(s){return t._aGroupedColumns[i]===s.getId();})[0];return{column:v,index:i};}else{return undefined;}}if(!this._mGroupHeaderMenuItems){this._mGroupHeaderMenuItems={};}if(!this._mGroupHeaderMenuItems["visibility"]){this._mGroupHeaderMenuItems["visibility"]=new e({text:f.getResourceText("TBL_SHOW_COLUMN"),select:function(){var l=j();if(l){var s=l.column,i=s.getShowIfGrouped();s.setShowIfGrouped(!i);t.fireGroup({column:s,groupedColumns:s.getParent()._aGroupedColumns,type:(!i?G.showGroupedColumn:G.hideGroupedColumn)});}}});}o.addItem(this._mGroupHeaderMenuItems["visibility"]);if(!this._mGroupHeaderMenuItems["ungroup"]){this._mGroupHeaderMenuItems["ungroup"]=new e({text:f.getResourceText("TBL_UNGROUP"),select:function(){var l=j();if(l&&l.column){var U=l.column;U.setGrouped(false);t.fireGroup({column:U,groupedColumns:t._aGroupedColumns,type:G.ungroup});}}});}o.addItem(this._mGroupHeaderMenuItems["ungroup"]);if(!this._mGroupHeaderMenuItems["ungroupall"]){this._mGroupHeaderMenuItems["ungroupall"]=new e({text:f.getResourceText("TBL_UNGROUP_ALL"),select:function(){var v=t.getColumns();t.suspendUpdateAnalyticalInfo();for(var i=0;i<v.length;i++){v[i].setGrouped(false);}t.resumeUpdateAnalyticalInfo();t.fireGroup({column:undefined,groupedColumns:[],type:G.ungroupAll});}});}o.addItem(this._mGroupHeaderMenuItems["ungroupall"]);if(!this._mGroupHeaderMenuItems["moveup"]){this._mGroupHeaderMenuItems["moveup"]=new e({text:f.getResourceText("TBL_MOVE_UP"),select:function(){var l=j();if(l){var s=l.column;var i=t._aGroupedColumns.indexOf(s.getId());if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:s,groupedColumns:s.getParent()._aGroupedColumns,type:G.moveUp});}}},icon:"sap-icon://arrow-top"});}o.addItem(this._mGroupHeaderMenuItems["moveup"]);if(!this._mGroupHeaderMenuItems["movedown"]){this._mGroupHeaderMenuItems["movedown"]=new e({text:f.getResourceText("TBL_MOVE_DOWN"),select:function(){var l=j();if(l){var s=l.column;var i=t._aGroupedColumns.indexOf(s.getId());if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:s,groupedColumns:s.getParent()._aGroupedColumns,type:G.moveDown});}}},icon:"sap-icon://arrow-bottom"});}o.addItem(this._mGroupHeaderMenuItems["movedown"]);if(!this._mGroupHeaderMenuItems["sortasc"]){this._mGroupHeaderMenuItems["sortasc"]=new e({text:f.getResourceText("TBL_SORT_ASC"),select:function(){var l=j();if(l){var s=l.column;s.sort(false);}},icon:"sap-icon://up"});}o.addItem(this._mGroupHeaderMenuItems["sortasc"]);if(!this._mGroupHeaderMenuItems["sortdesc"]){this._mGroupHeaderMenuItems["sortdesc"]=new e({text:f.getResourceText("TBL_SORT_DESC"),select:function(){var l=j();if(l){var s=l.column;s.sort(true);}},icon:"sap-icon://down"});}o.addItem(this._mGroupHeaderMenuItems["sortdesc"]);if(!this._mGroupHeaderMenuItems["collapse"]){this._mGroupHeaderMenuItems["collapse"]=new e({text:f.getResourceText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding().collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection();}});}o.addItem(this._mGroupHeaderMenuItems["collapse"]);if(!this._mGroupHeaderMenuItems["collapseall"]){this._mGroupHeaderMenuItems["collapseall"]=new e({text:f.getResourceText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding().collapseToLevel(0);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection();}});}o.addItem(this._mGroupHeaderMenuItems["collapseall"]);if(!this._mGroupHeaderMenuItems["expand"]){this._mGroupHeaderMenuItems["expand"]=new e({text:f.getResourceText("TBL_EXPAND_LEVEL"),select:function(){t.getBinding().expandToLevel(t._iGroupedLevel);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection();}});}o.addItem(this._mGroupHeaderMenuItems["expand"]);if(!this._mGroupHeaderMenuItems["expandall"]){this._mGroupHeaderMenuItems["expandall"]=new e({text:f.getResourceText("TBL_EXPAND_ALL"),select:function(){t.expandAll();}});}o.addItem(this._mGroupHeaderMenuItems["expandall"]);var l=j();if(l){var s=l.column;if(s.getShowIfGrouped()){this._mGroupHeaderMenuItems["visibility"].setText(f.getResourceText("TBL_HIDE_COLUMN"));}else{this._mGroupHeaderMenuItems["visibility"].setText(f.getResourceText("TBL_SHOW_COLUMN"));}this._mGroupHeaderMenuItems["moveup"].setEnabled(l.index>0);this._mGroupHeaderMenuItems["movedown"].setEnabled(l.index<this._aGroupedColumns.length-1);}else{this._mGroupHeaderMenuItems["moveup"].setEnabled(true);this._mGroupHeaderMenuItems["movedown"].setEnabled(true);}};
m.prototype._removeGroupHeaderMenuItems=function(o){if(!this._mGroupHeaderMenuItems){return;}for(var i in this._mGroupHeaderMenuItems){o.removeItem(this._mGroupHeaderMenuItems[i]);}};
m.prototype._cleanupGroupHeaderMenuItems=function(){for(var i in this._mGroupHeaderMenuItems){this._mGroupHeaderMenuItems[i].destroy();}this._mGroupHeaderMenuItems=null;};
m.prototype.getContextByIndex=function(i){var o=this.getBinding();return i>=0&&o?o.getContextByIndex(i):null;};
m.prototype.getContextInfoByIndex=function(i){var o=this.getBinding();return i>=0&&o?o.getNodeByIndex(i):null;};
m.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true;};
m.prototype.resumeUpdateAnalyticalInfo=function(s,F){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(s,F);};
m.prototype.addColumn=function(v,s){var o=this._getColumn(v);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.addColumn.call(this,o,s);this._updateColumns(s);return this;};
m.prototype.insertColumn=function(v,i,s){var o=this._getColumn(v);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.insertColumn.call(this,o,i,s);this._updateColumns(s);return this;};
m.prototype.removeColumn=function(v,s){var R=T.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(V){if(v.getId){return V!=v.getId();}else{return V==v;}});}this.updateAnalyticalInfo(s);return R;};
m.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];var R=T.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(s);return R;};
m.prototype._getColumn=function(v){if(typeof v==="string"){var o=new A({leadingProperty:v,template:v,managed:true});return o;}else if(v instanceof A){return v;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};
m.prototype._updateColumns=function(s,F){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(s,F);if(this.bOutput){this.invalidate();}}};
m.prototype.updateAnalyticalInfo=function(s,F){if(this._bSuspendUpdateAnalyticalInfo){return;}var o=this.getBinding();if(o){var i=this._getColumnInformation();var N=o.getNumberOfExpandedLevels()||0;if(N>this._aGroupedColumns.length){o.setNumberOfExpandedLevels(0);}o.updateAnalyticalInfo(i,F);this._updateTotalRow(s);if(!s){this._getRowContexts();}}};
m.prototype.refreshRows=function(){T.prototype.refreshRows.apply(this,arguments);this._updateTotalRow();};
m.prototype._updateTotalRow=function(s){var o=this.getBinding();this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:o?o.providesGrandTotal()&&o.hasTotaledMeasures():false},s);};
m.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return;}var l=this.getBinding(),R=l&&l.getAnalyticalQueryResult();if(R){var t=this.getColumns(),v=[],U=[],D=[],w={},x,y;for(var i=0;i<t.length;i++){x=t[i];x._isLastGroupableLeft=false;x._bLastGroupAndGrouped=false;x._bDependendGrouped=false;if(!x.getVisible()){continue;}var z=x.getLeadingProperty();y=R.findDimensionByPropertyName(z);if(y){var E=y.getName();if(!w[E]){w[E]={dimension:y,columns:[x]};}else{w[E].columns.push(x);}if(x.getGrouped()&&v.indexOf(E)==-1){v.push(E);}if(D.indexOf(E)==-1){D.push(E);}}}U=q.grep(D,function(s){return v.indexOf(v,s)==-1;});if(v.length>0){q.each(v,function(i,s){q.each(w[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(v.length==D.length){y=R.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var F=w[y.getName()].columns;q.each(F,function(i,o){o._bLastGroupAndGrouped=true;});}}if(U.length==1){q.each(w[U[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};
m.prototype._getFirstMeasureColumnIndex=function(){var o=this.getBinding(),R=o&&o.getAnalyticalQueryResult(),j=this._getVisibleColumns();if(!R){return-1;}for(var i=0;i<j.length;i++){var l=j[i],s=l.getLeadingProperty();if(R.findMeasureByName(s)||R.findMeasureByPropertyName(s)){return i;}}};
m.prototype.getTotalSize=function(){var o=this.getBinding();if(o){return o.getTotalSize();}return 0;};
m.prototype._onPersoApplied=function(){T.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){if(j[i].getGrouped()){this._addGroupedColumn(j[i].getId());}}this._updateColumns();};
m.prototype._addGroupedColumn=function(s){if(this._aGroupedColumns.indexOf(s)===-1){this._aGroupedColumns.push(s);}};
m.prototype._removeGroupedColumn=function(s){var i=this._aGroupedColumns.indexOf(s);if(i>=0){this._aGroupedColumns.splice(i,1);}};
m.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};
m.prototype.setCollapseRecursive=function(i){var o=this.getBinding();if(o){g(o.setCollapseRecursive,"Collapse Recursive is not supported by the used binding");if(o.setCollapseRecursive){o.setCollapseRecursive(i);}}this.setProperty("collapseRecursive",!!i,true);return this;};
m.prototype.expand=a.prototype.expand;m.prototype.collapse=a.prototype.collapse;
m.prototype.expandAll=function(){var o=this.getBinding();if(o){o.expandToLevel(this._aGroupedColumns.length);this.setFirstVisibleRow(0);this._getSelectionPlugin().clearSelection();}return this;};
m.prototype.collapseAll=a.prototype.collapseAll;m.prototype.isExpanded=a.prototype.isExpanded;
m.prototype.getAnalyticalInfoOfRow=function(R){var o=this.getBinding();var j=R?R.getRowBindingContext():null;if(!f.isA(R,"sap.ui.table.Row")||R.getParent()!==this||!o||!j){return null;}var I=j===o.getGrandTotalContext();var l=null;var s=-1;if(I){l=o.getGrandTotalContextInfo();s=0;}else{l=this.getContextInfoByIndex(R.getIndex());if(l){s=l.level;}}var t=l&&o.nodeHasChildren&&o.nodeHasChildren(l);var v=!t&&!I&&l&&l.nodeState&&l.nodeState.sum;var w=[];if(v||t){var x=this.getGroupedColumns();if(x.length>0&&s>0&&s<=x.length){for(var i=0;i<s;i++){w.push(x[i]);}}}return{grandTotal:I,group:t,groupTotal:v,level:s,context:j,groupedColumns:w};};
m.prototype._createLegacySelectionPlugin=function(){return new B();};
m.prototype._setRowCountConstraints=function(){};
m.prototype._onBindingDataRequested=function(E){if(E.getParameter("__simulateAsyncAnalyticalBinding")){return;}var o=this.getBinding();if(!o.bUseBatchRequests){_(this).bPendingRequest=true;}T.prototype._onBindingDataRequested.apply(this,arguments);};
m.prototype._onBindingDataReceived=function(E){if(E.getParameter("__simulateAsyncAnalyticalBinding")){return;}var o=this.getBinding();if(!o.bUseBatchRequests){_(this).bPendingRequest=false;}T.prototype._onBindingDataReceived.apply(this,arguments);};
m.prototype._hasPendingRequests=function(){if(_(this).hasOwnProperty("bPendingRequest")){return _(this).bPendingRequest;}else{return T.prototype._hasPendingRequests.apply(this,arguments);}};
return m;});
sap.ui.predefine('sap/ui/table/AnalyticalTableRenderer',['sap/ui/table/AnalyticalTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/Column',["./ColumnMenu","./utils/TableUtils","./library","sap/ui/core/Element","sap/ui/core/Popup","sap/ui/core/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/Type","sap/ui/model/type/String","sap/base/util/ObjectPath","sap/base/util/JSTokenizer","sap/base/util/deepClone","sap/base/Log"],function(C,T,a,E,P,c,F,b,d,S,f,g,O,J,h,L){"use strict";var H=c.HorizontalAlign,j=a.SortOrder,V=c.ValueState;var k={Standard:"Standard",Creation:"Creation"};var _=T.createWeakMapFacade();var m=new window.WeakMap();
var n=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:H.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:j.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},menu:{type:"sap.ui.unified.Menu",multiple:false}},associations:{columnHeaderMenu:{type:"sap.ui.core.IColumnHeaderMenu",multiple:false,visibility:"hidden"}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});
n._DEFAULT_FILTER_TYPE=new g();
n.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};_(this).oSorter=null;_(this).mCellContentVisibilitySettings=q(this);_(this).bHasDefaultLabel=false;_(this).bHasDefaultTemplate=false;this._initTemplateClonePool();};
n.prototype._initTemplateClonePool=function(){this._mTemplateClones=Object.keys(k).reduce(function(t,s){t[s]=[];return t;},{});};
n.prototype.exit=function(){this._destroyTemplateClones();};
n.prototype.setParent=function(){var R=E.prototype.setParent.apply(this,arguments);var M=this.getAggregation("menu");if(M&&typeof M._updateReferences==="function"){M._updateReferences(this);}return R;};
n.prototype.invalidate=function(e){if(e!==this.getTemplate()&&e!==this.getCreationTemplate()&&!T.isA(e,"sap.ui.table.ColumnMenu")){E.prototype.invalidate.apply(this,arguments);}};
n.prototype.setLabel=function(l){var e=l;if(typeof l==="string"){if(_(this).bHasDefaultLabel){this.getLabel().setText(l);return this;}e=a.TableHelper.createLabel({text:l});_(this).bHasDefaultLabel=true;}else if(_(this).bHasDefaultLabel){this.destroyLabel();_(this).bHasDefaultLabel=false;}return this.setAggregation("label",e);};
n.prototype.setTemplate=function(t){var e=t;var i=this._getTable();var l=this.getTemplate();var N=true;if(typeof t==="string"){if(_(this).bHasDefaulTemplate){this.getTemplate().bindProperty("text",t);N=false;}else{e=a.TableHelper.createTextView().bindProperty("text",t);_(this).bHasDefaulTemplate=true;}}else if(_(this).bHasDefaulTemplate){this.destroyTemplate();_(this).bHasDefaulTemplate=false;}if(N){this.setAggregation("template",e,true);}if(this.getVisible()){this.invalidate();}this._destroyTemplateClones("Standard");if(i&&this.getVisible()){if(e){i.invalidateRowsAggregation();}if(!l||!e){var s=i.getCreationRow();if(s){s._update();}}}return this;};
n.prototype.destroyTemplate=function(){this.destroyAggregation("template");this._destroyTemplateClones("Standard");var t=this._getTable();var e=t?t.getCreationRow():null;if(e){e._update();}return this;};
n.prototype.setCreationTemplate=function(e){var t=this._getTable();this.setAggregation("creationTemplate",e,true);this._destroyTemplateClones("Creation");if(e&&t&&this.getVisible()){var i=t.getCreationRow();if(i){i._update();}}return this;};
n.prototype.getCreationTemplate=function(){return this.getAggregation("creationTemplate");};
n.prototype.destroyCreationTemplate=function(){this.destroyAggregation("creationTemplate",true);this._destroyTemplateClones("Creation");return this;};
n.prototype.getMenu=function(){var M=this.getAggregation("menu");if(!M){M=this._createMenu();this.setMenu(M);}return M;};
n.prototype.invalidateMenu=function(){var M=this.getAggregation("menu");if(this._bMenuIsColumnMenu){M._invalidate();}};
n.prototype._menuHasItems=function(){var M=this.getAggregation("menu");var t=this._getTable();var e=(M?M.getItems().length>0:false)||(t?t.getEnableColumnFreeze():false)||(t?t.getShowColumnVisibilityMenu():false)||this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupable();if(e){return true;}return T.Hook.call(t,T.Hook.Keys.Column.MenuItemNotification,this).some(function(i){return i;});};
n.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry());};
n.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry());};
n.prototype.isGroupable=function(){var t=this.getParent();return!!(t&&t.getEnableGrouping&&t.getEnableGrouping()&&this.getSortProperty());};
n.prototype.setMenu=function(M){this.setAggregation("menu",M,true);this._bMenuIsColumnMenu=T.isA(M,"sap.ui.table.ColumnMenu");return this;};
n.prototype._createMenu=function(){if(!this._defaultMenu){this._defaultMenu=new C(this.getId()+"-menu",{ariaLabelledBy:this});}return this._defaultMenu;};
n.prototype.setSortProperty=function(s){this.setProperty("sortProperty",s);this.invalidateMenu();return this;};
n.prototype.setSorted=function(e){this.setProperty("sorted",e,true);this._updateIcons();return this;};
n.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._updateIcons();return this;};
n.prototype.setFilterProperty=function(s){this.invalidateMenu();return this.setProperty("filterProperty",s);};
n.prototype.setFiltered=function(e){this.setProperty("filtered",e,true);this._updateIcons();return this;};
n.prototype.setFilterValue=function(s){this.setProperty("filterValue",s,true);var M=this.getMenu();if(this._bMenuIsColumnMenu){M._setFilterValue(s);}return this;};
n.prototype.setFilterOperator=function(s){return this.setProperty("filterOperator",s,true);};
n.prototype._openMenu=function(D){var M=this.getMenu();if(!this._menuHasItems()){return false;}var e=this.fireColumnMenuOpen({menu:M});if(e){var i=P.Dock;var l=D;if(!D){D=this.getDomRef();l=this.getFocusDomRef();}M.open(null,l,i.BeginTop,i.BeginBottom,D);return true;}else{return true;}};
n.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===j.Ascending);};
n.prototype.sort=function(D,A){var t=this.getParent();if(t){t.pushSortedColumn(this,A);var N=D?j.Descending:j.Ascending;var e=t.fireSort({column:this,sortOrder:N,columnAdded:A});if(e){var s=t.getSortedColumns();var u=t.getColumns();for(var i=0,l=u.length;i<l;i++){if(s.indexOf(u[i])<0){u[i].setProperty("sorted",false,true);u[i].setProperty("sortOrder",j.Ascending,true);u[i]._updateIcons(true);delete _(u[i]).oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",N,true);_(this).oSorter=new S(this.getSortProperty(),this.getSortOrder()===j.Descending);var w=[];for(var i=0,l=s.length;i<l;i++){s[i]._updateIcons(true);w.push(_(s[i]).oSorter);}t._resetColumnHeaderHeights();t._updateRowHeights(t._collectRowHeights(true),true);var B=t.getBinding();if(B){if(this._updateTableAnalyticalInfo){this._updateTableAnalyticalInfo(true);}B.sort(w);}else{L.warning("Sorting not performed because no binding present",this);}}}return this;};
n.prototype._updateIcons=function(s){var t=this.getParent(),e=this.getSorted(),i=this.getFiltered();if(!t||!t.getDomRef()){return;}this.$().parents(".sapUiTableCHT").find('td[data-sap-ui-colindex="'+this.getIndex()+'"]:not([colspan]):not(.sapUiTableHidden):first').toggleClass("sapUiTableColFiltered",i).toggleClass("sapUiTableColSorted",e).toggleClass("sapUiTableColSortedD",e&&this.getSortOrder()===j.Descending);t._getAccExtension().updateAriaStateOfColumn(this);if(!s){t._resetColumnHeaderHeights();t._updateRowHeights(t._collectRowHeights(true),true);}};
n.prototype._renderSortIcon=function(){this._updateIcons();};
n.prototype._getFilter=function(){var e,s=this.getFilterProperty(),i=this.getFilterValue(),l=this.getFilterOperator(),t,u,w=this.getFilterType()||n._DEFAULT_FILTER_TYPE,I=w instanceof g,B;if(i){if(!l){B=i.match(/(.*)\s*\.\.\s*(.*)/);if(i.indexOf("=")==0){l=b.EQ;t=i.substr(1);}else if(i.indexOf("!=")==0){l=b.NE;t=i.substr(2);}else if(i.indexOf("<=")==0){l=b.LE;t=i.substr(2);}else if(i.indexOf("<")==0){l=b.LT;t=i.substr(1);}else if(i.indexOf(">=")==0){l=b.GE;t=i.substr(2);}else if(i.indexOf(">")==0){l=b.GT;t=i.substr(1);}else if(B){if(B[1]&&B[2]){l=b.BT;t=B[1];u=B[2];}else if(B[1]&&!B[2]){l=b.GE;t=B[1];}else{l=b.LE;t=B[2];}}else if(I&&i.indexOf("*")==0&&i.lastIndexOf("*")==i.length-1){l=b.Contains;t=i.substr(1,i.length-2);}else if(I&&i.indexOf("*")==0){l=b.EndsWith;t=i.substr(1);}else if(I&&i.lastIndexOf("*")==i.length-1){l=b.StartsWith;t=i.substr(0,i.length-1);}else{if(this.getDefaultFilterOperator()){l=this.getDefaultFilterOperator();}else{if(I){l=b.Contains;}else{l=b.EQ;}}t=i.substr(0);}if(!u){e=new F(s,l,this._parseFilterValue(t));}else{e=new F(s,l,this._parseFilterValue(t),this._parseFilterValue(u));}}else{e=new F(s,l,this._parseFilterValue(i));}}return e;};
n.prototype.filter=function(s){var t=this.getParent();if(t&&t.isBound("rows")){var u=t.fireFilter({column:this,value:s});if(u){this.setProperty("filtered",!!s,true);this.setProperty("filterValue",s,true);var M=this.getMenu();if(this._bMenuIsColumnMenu){M._setFilterValue(s);}var w=[];var x=t.getColumns();for(var i=0,l=x.length;i<l;i++){var y=x[i],z;M=y.getMenu();try{z=y._getFilter();if(y._bMenuIsColumnMenu){M._setFilterState(V.None);}}catch(e){if(y._bMenuIsColumnMenu){M._setFilterState(V.Error);}continue;}if(z){w.push(z);}}t.getBinding().filter(w,d.Control);this._updateIcons();}}return this;};
n.prototype._parseFilterValue=function(s){var e=this.getFilterType();if(e){if(typeof e==="function"){s=e(s);}else{s=e.parseValue(s,"string");}}return s;};
n.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()&&this.getTemplate()!=null;};
n.prototype.setProperty=function(N,e){var t=this._getTable();var i=t&&this.getProperty(N)!=e;var l=i&&N==="visible";var I=i&&(N==="visible"||N==="headerSpan");var R=E.prototype.setProperty.apply(this,arguments);if(l){t.invalidateRowsAggregation();var s=t.getCreationRow();if(s){s._update();}}if(I){t._invalidateComputedFixedColumnCount();}return R;};
n.prototype.setFilterType=function(t){var e=t;if(typeof(t)==="string"){try{var i=J.parseJS(t);if(typeof(i.type)==="string"){var l=O.get(i.type);e=l&&new l(i.formatOptions,i.constraints);}}catch(s){var l=O.get(t);e=l&&new l();}if(!(e instanceof f)){L.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");e=undefined;}}this.setProperty("filterType",e,true);return this;};
n.prototype.getIndex=function(){var t=this.getParent();if(t){return t.indexOfColumn(this);}else{return-1;}};
n.prototype._getFreeTemplateClone=function(t){var e=this._mTemplateClones[t];var l=null;if(!e){return null;}for(var i=0;i<e.length;i++){if(!e[i]||e[i].bIsDestroyed){e.splice(i,1);i--;}else if(!l&&!e[i].getParent()){l=e[i];}}return l;};
n.prototype.getTemplateClone=function(i,s){if(typeof i!=="number"||this.getTemplate()==null){return null;}var t=s==null?"Standard":s;var e=this._getFreeTemplateClone(t);if(!e&&k.hasOwnProperty(t)){var G=this["get"+(t==="Standard"?"":t)+"Template"];var l=G.call(this);if(l){e=l.clone();this._mTemplateClones[t].push(e);}}if(e){m.set(e,this);var u=this.getParent();if(u){u._getAccExtension().addColumnHeaderLabel(this,e);}}return e;};
function o(e){for(var i=0;i<e.length;i++){if(e[i]!=null&&!e[i].bIsDestroyed){e[i].destroy();}}}
n.prototype._destroyTemplateClones=function(t){if(t==null){for(var s in k){o(this._mTemplateClones[s]);}this._initTemplateClonePool();}else{o(this._mTemplateClones[t]);this._mTemplateClones[t]=[];}};
n.prototype._closeMenu=function(){var M=this.getAggregation("menu");if(M){M.close();}};
n.prototype._getTable=function(){var e=this.getParent();return T.isA(e,"sap.ui.table.Table")?e:null;};
n.prototype._setCellContentVisibilitySettings=function(s){v(s);_(this).mCellContentVisibilitySettings=q(this,s);};
n.prototype._getCellContentVisibilitySettings=function(){return _(this).mCellContentVisibilitySettings;};
n.prototype.getColumnHeaderMenu=function(){return sap.ui.getCore().byId(this.getAssociation("columnHeaderMenu"));};
function v(s){if(s==null){return;}p(s,null,false,["standard","groupHeader","summary"]);p(s.standard,"standard",true);p(s.groupHeader,"groupHeader",true,["nonExpandable","expanded","collapsed"]);p(s.summary,"summary",true,["group","total"]);}
function p(e,s,A,i){if(e!=null&&!(A&&typeof e==="boolean"||i&&typeof e==="object")){throw new Error("Invalid value"+(s?" for '"+s+"'":""));}if(i&&e!=null&&typeof e==="object"){Object.keys(e).forEach(function(l){if(i.includes(l)){if(s!=null){p(e[l],s+"."+l,true);}}else{throw new Error("Unsupported setting '"+(s?s+".":"")+l+"'");}});}}
function q(e,s){s=s?s:{};return{standard:r(s.standard),groupHeader:{nonExpandable:r(s.groupHeader,"nonExpandable"),expanded:r(s.groupHeader,"expanded"),collapsed:r(s.groupHeader,"collapsed")},summary:{group:r(s.summary,"group"),total:r(s.summary,"total")}};}
function r(s,K){if(typeof s==="boolean"){return s;}else if(K&&s){return s[K]!==false;}else{return true;}}
n.ofCell=function(e){return m.get(e)||null;};
return n;});
sap.ui.predefine('sap/ui/table/ColumnMenu',['./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/unified/MenuTextFieldItem',"sap/ui/unified/MenuRenderer",'sap/ui/Device','./utils/TableUtils',"sap/base/assert","sap/ui/thirdparty/jquery"],function(l,M,a,b,c,D,T,d,q){"use strict";var C=new window.WeakMap();
var e=M.extend("sap.ui.table.ColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.unified.MenuRenderer"
});
e.prototype.init=function(){if(M.prototype.init){M.prototype.init.apply(this,arguments);}this.addStyleClass("sapUiTableColumnMenu");this._bInvalidated=true;this._iPopupClosedTimeoutId=null;this._oColumn=null;this._oTable=null;};
e.prototype.exit=function(){if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}window.clearTimeout(this._iPopupClosedTimeoutId);e._destroyColumnVisibilityMenuItem(this._oTable);this._oColumn=this._oTable=null;};
e.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate();}};
e.prototype.setParent=function(p){this._invalidate();this._updateReferences(p);return M.prototype.setParent.apply(this,arguments);};
e.prototype._updateReferences=function(p){this._oColumn=p;if(this._oColumn){d(T.isA(this._oColumn,"sap.ui.table.Column"),"ColumnMenu.setParent: parent must be a subclass of sap.ui.table.Column");this._oTable=this._oColumn.getParent();if(this._oTable){d(T.isA(this._oTable,"sap.ui.table.Table"),"ColumnMenu.setParent: parent of parent must be subclass of sap.ui.table.Table");}}};
e._destroyColumnVisibilityMenuItem=function(t){if(!t||!t._oColumnVisibilityMenuItem){return;}t._oColumnVisibilityMenuItem.destroy();t._oColumnVisibilityMenuItem=null;};
e.prototype._removeColumnVisibilityFromAggregation=function(){if(!this._oTable||!this._oTable._oColumnVisibilityMenuItem){return;}this.removeAggregation("items",this._oTable._oColumnVisibilityMenuItem,true);};
e.prototype._invalidate=function(){this._bInvalidated=true;};
e.prototype.open=function(){if(this._bInvalidated){this._bInvalidated=false;this._removeColumnVisibilityFromAggregation();this.destroyItems();this._addMenuItems();}else if(this._oColumn){this._addColumnVisibilityMenuItem();}T.Hook.call(this._oTable,T.Hook.Keys.Table.OpenMenu,T.getCellInfo(arguments[4]),this);if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];M.prototype.open.apply(this,arguments);}};
e.prototype._addMenuItems=function(){if(this._oColumn){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem();}};
e.prototype._addSortMenuItem=function(h){var o=this._oColumn;if(o.isSortableByMenu()){var s=h?"desc":"asc";var i=h?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(s,"TBL_SORT_"+s.toUpperCase(),i,function(E){o.sort(h,E.getParameter("ctrlKey")===true);}));}};
e.prototype._addFilterMenuItem=function(){var o=this._oColumn;if(o.isFilterableByMenu()){var t=o.getParent();var h=t&&t.getEnableCustomFilter();if(h){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:o});}));}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",o.getFilterValue(),function(){o.filter(this.getValue());}));}}};
e.prototype._addGroupMenuItem=function(){var o=this._oColumn;if(o.isGroupable()){var t=this._oTable;this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){t.setGroupBy(o);}));}};
e.prototype._addFreezeMenuItem=function(){var o=this._oColumn;var t=this._oTable;var h=t&&t.getEnableColumnFreeze();if(h){var i=o.getIndex();var I=i+T.Column.getHeaderSpan(o)==t.getComputedFixedColumnCount();this.addItem(this._createMenuItem("freeze",I?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var E=t.fireColumnFreeze({column:o});if(E){if(I){t.setFixedColumnCount(0);}else{t.setFixedColumnCount(i+1);}}}));}};
e.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){if(!t._oColumnVisibilityMenuItem||t._oColumnVisibilityMenuItem.bIsDestroyed){t._oColumnVisibilityMenuItem=this._createMenuItem("column-visibilty","TBL_COLUMNS");var o=new M(t._oColumnVisibilityMenuItem.getId()+"-menu");t._oColumnVisibilityMenuItem.setSubmenu(o);}this.addItem(t._oColumnVisibilityMenuItem);this._updateColumnVisibilityMenuItem();}};
e.prototype._createColumnVisibilityMenuItem=function(o){var t=this._oTable;var s=T.Column.getHeaderText(t,o.getIndex());return new a({text:s,icon:o.getVisible()?"sap-icon://accept":null,ariaLabelledBy:[t.getId()+(o.getVisible()?"-ariahidecolmenu":"-ariashowcolmenu")],select:q.proxy(function(E){var v=!o.getVisible();if(v||T.getVisibleColumnCount(this._oTable)>1){var t=o.getParent();var h=true;if(T.isA(t,"sap.ui.table.Table")){h=t.fireColumnVisibility({column:o,newVisible:v});}if(h){o.setVisible(v);}}},this)});};
e.prototype._createMenuItem=function(i,t,I,h){return new a(this.getId()+"-"+i,{text:T.getResourceText(t),icon:I?"sap-icon://"+I:null,select:h||function(){}});};
e.prototype._createMenuTextFieldItem=function(i,t,I,v,h){h=h||function(){};return new b(this.getId()+"-"+i,{label:T.getResourceText(t),icon:I?"sap-icon://"+I:null,value:v,select:h||function(){}});};
e.prototype._setFilterValue=function(v){var o=this.getParent();var t=(o?o.getParent():undefined);var F=sap.ui.getCore().byId(this.getId()+"-filter");if(F&&F.setValue&&(t&&!t.getEnableCustomFilter())){F.setValue(v);}return this;};
e.prototype._setFilterState=function(F){var o=this.getParent();var t=(o?o.getParent():undefined);var h=sap.ui.getCore().byId(this.getId()+"-filter");if(h&&h.setValueState&&(t&&!t.getEnableCustomFilter())){h.setValueState(F);}return this;};
function g(t){var h=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){var s=t.getColumnVisibilityMenuSorter();if(typeof s==="function"){h=h.sort(s);}}return h;}
function f(B,o){if(o.isA("sap.ui.table.AnalyticalColumn")){var Q=B.getAnalyticalQueryResult();var E=Q.getEntityType();var m=B.getModel().getProperty("/#"+E.getTypeDescription().name+"/"+o.getLeadingProperty()+"/sap:visible");if(m&&(m.value==="false"||m.value===false)){return true;}}return false;}
e.prototype._updateColumnVisibilityMenuItem=function(){var t=this._oTable;if(!t||!t._oColumnVisibilityMenuItem){return;}var s=t._oColumnVisibilityMenuItem.getSubmenu();if(!s){return;}var h=g(t);var S=s.getItems();var v=t._getVisibleColumns();var B=t.getBinding();var A=T.isA(B,"sap.ui.model.analytics.AnalyticalBinding");for(var i=0;i<h.length;i++){var o=h[i];if(A){if(f(B,o)){continue;}}var I=C.get(o);if(!I||I.bIsDestroyed){var I=this._createColumnVisibilityMenuItem(o);s.insertItem(I,i);C.set(o,I);}else{var j=S.indexOf(I);if(i!==j){s.removeItem(I);s.insertItem(I,i);}}var V=v.indexOf(o)>-1;var k=V?"sap-icon://accept":"";S=s.getItems();S[i].setProperty("icon",k);S[i].setEnabled(!V||v.length>1);S[i].removeAllAriaLabelledBy();S[i].addAriaLabelledBy(t.getId()+(V?"-ariahidecolmenu":"-ariashowcolmenu"));}for(var i=S.length;i>h.length;i--){S[i-1].destroy();}};
return e;});
sap.ui.predefine('sap/ui/table/ColumnMenuRenderer',['sap/ui/table/ColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/CreationRow',["./CreationRowRenderer","./Column","./utils/TableUtils","sap/ui/core/Control","sap/m/library","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button"],function(R,C,T,a,M,O,b,B){"use strict";
var c=a.extend("sap.ui.table.CreationRow",{metadata:{library:"sap.ui.table",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_defaultToolbar:{type:"sap.ui.core.Toolbar",multiple:false,visibility:"hidden"}},events:{apply:{allowPreventDefault:true}}}});
c.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);this._updateDefaultToolbar();return this;};
c.prototype.setVisible=function(v){var V=this.getVisible();var t=this.getTable();this.setProperty("visible",v);if(V!==v&&t){t.invalidate();}return this;};
c.prototype.setParent=function(p){a.prototype.setParent.apply(this,arguments);this._update();return this;};
c.prototype.resetFocus=function(){var i=T.getFirstInteractiveElement(this);if(i){i.focus();if(i instanceof window.HTMLInputElement){i.select();}return true;}return false;};
c.prototype.getFocusDomRef=function(){var i=T.getFirstInteractiveElement(this);if(i){return i;}return a.prototype.getFocusDomRef.apply(this,arguments);};
c.prototype._fireApply=function(){var f=false;if(this.fireApply()){f=this.resetFocus();}return f;};
function s(o,e){var f=document.activeElement;o.getTable().getDomRef("focusDummy").focus();e.setMarked();window.setTimeout(function(){if(!o._fireApply()){f.focus();}},0);}
c.prototype.onsapenter=function(e){if(this.getApplyEnabled()&&!e.isMarked()){s(this,e);}};
c.prototype.onsapentermodifiers=function(e){if(this.getApplyEnabled()&&(e.metaKey||e.ctrlKey)){s(this,e);}};
function d(o){return new O(o.getId()+"-tb",{content:[new b(),new B(o.getId()+"-applyBtn",{text:T.getResourceText("TBL_CREATIONROW_APPLY"),enabled:o.getApplyEnabled(),press:function(){o._fireApply();}})],style:M.ToolbarStyle.Clear,ariaLabelledBy:[o.getId()+"-label"]});}
c.prototype._getToolbar=function(){var t=this.getToolbar();if(!t){var D=this.getAggregation("_defaultToolbar");if(!D){D=d(this);this.setAggregation("_defaultToolbar",D,true);}t=D;if(t.data("sap-ui-table-invalid")){this._updateDefaultToolbar();}}return t;};
c.prototype._updateDefaultToolbar=function(){var D=this.getAggregation("_defaultToolbar");var A;if(this.getToolbar()){if(D){D.data("sap-ui-table-invalid",true);}return;}if(!D){return;}A=D.getContent()[1];A.setEnabled(this.getApplyEnabled());D.data("sap-ui-table-invalid",null);};
c.prototype._getCell=function(i){var e=this.getCells();var o=e.filter(function(o){return C.ofCell(o).getIndex()===i;})[0];if(!o){return null;}return o;};
c.prototype._getCellDomRef=function(i){var o=this._getCell(i);var e=o?o.getDomRef():null;var $=T.getCell(this.getTable(),e,true);if(!$){return null;}return $;};
c.prototype._focusCell=function(i){var o=this._getCellDomRef(i);var I=T.getInteractiveElements(o);if(I){I[0].focus();if(I[0]instanceof window.HTMLInputElement){I[0].select();}return true;}return false;};
c.prototype._takeOverKeyboardHandling=function(e){var t=this.getTable();var o=t?t.getDomRef():null;if(!o||!o.contains(document.activeElement)){return false;}var f=T.getCell(this.getTable(),document.activeElement);var g=T.getCellInfo(f);var F=false;if(g.columnIndex!=null&&g.columnIndex>=0){F=this._focusCell(g.columnIndex);}else{F=this.resetFocus();}if(F&&e){e.preventDefault();}return F;};
c.prototype._update=function(){var t=this.getTable();if(!t){this.removeAllCells();return;}var e=t.getColumns();this.removeAllCells();for(var i=0,l=e.length;i<l;i++){if(e[i].getVisible()){this.addCell(e[i].getTemplateClone(i,"Creation"));}}};
c.prototype.getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};
return c;});
sap.ui.predefine('sap/ui/table/CreationRowRenderer',["./TableRenderer","./utils/TableUtils","sap/ui/core/Renderer"],function(T,a,R){"use strict";var C={apiVersion:2};
C.render=function(r,c){var t=c.getTable();if(!t){return;}r.openStart("div",c);r.attr("data-sap-ui-fastnavgroup","true");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CREATIONROW",{creationRow:c});r.class("sapUiTableCreationRow");r.openEnd();this.renderBeginSection(r);this.renderMiddleSection(r,c,t);this.renderEndSection(r,t);t._getAccRenderExtension().writeAccCreationRowText(r,t,c);r.close("div");};
C.renderBeginSection=function(r){r.openStart("div");r.class("sapUiTableCreationRowBeginSection");r.class("sapUiTableRowHdrScr");r.openEnd();r.close("div");};
C.renderMiddleSection=function(r,c,t){r.openStart("div");r.class("sapUiTableCreationRowMiddleSection");r.openEnd();this.renderForm(r,c,t);this.renderToolbar(r,c);r.close("div");};
C.renderEndSection=function(r,t){r.openStart("div");r.class("sapUiTableCreationRowEndSection");if(a.hasRowActions(t)){r.class("sapUiTableCell");r.class("sapUiTableRowActionHeaderCell");}else{r.class("sapUiTableVSbBg");}r.openEnd();r.close("div");};
C.renderForm=function(r,c,t){if(c.getCells().length===0){return;}r.openStart("div");r.class("sapUiTableCreationRowForm");r.openEnd();if(t.getComputedFixedColumnCount()>0){this.renderRowFormTable(r,t,true);}r.openStart("div");r.class("sapUiTableCtrlScr");r.openEnd();this.renderRowFormTable(r,t,false);r.close("div");r.close("div");};
C.renderRowFormTable=function(r,t,f){var s=f?0:t.getComputedFixedColumnCount();var e=f?t.getComputedFixedColumnCount():t.getColumns().length;var c=t.getCreationRow();r.openStart("table");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CREATIONROW_TABLE");r.class("sapUiTableCtrl");r.style(f?"width":"min-width",t._getColumnsWidth(s,e)+"px");r.openEnd();r.openStart("thead").openEnd();r.openStart("tr");r.class("sapUiTableCtrlCol");r.openEnd();var b=t.getColumns();var d=new Array(e);var i;var o;var g=!f&&e>s;var h;for(i=s;i<e;i++){o=b[i];h={shouldRender:!!(o&&o.shouldRender())};if(h.shouldRender){var w=o.getWidth();if(a.isVariableWidth(w)){g=false;if(f){o._iFixWidth=o._iFixWidth||160;w=o._iFixWidth+"px";}}else if(f){delete o._iFixWidth;}h.width=w;}d[i]=h;}for(i=s;i<e;i++){o=b[i];h=d[i];if(h.shouldRender){r.openStart("th");r.style("width",h.width);r.attr("data-sap-ui-headcolindex",i);r.attr("data-sap-ui-colid",o.getId());r.openEnd();r.close("th");}}if(g){r.openStart("th").openEnd().close("th");}r.close("tr");r.close("thead");r.openStart("tbody").openEnd();r.openStart("tr");r.class("sapUiTableTr");r.openEnd();var j=c.getCells();var v=T.getColumnsToRender(t,s,e);for(i=s;i<e;i++){o=b[i];h=d[i];if(h.shouldRender){r.openStart("td");r.attr("data-sap-ui-colid",o.getId());var k=c._getCell(i);var n=v.length;var I=n>0&&v[0]===o;var l=n>0&&v[n-1]===o;var L=T.getLastFixedColumnIndex(t);var m=f&L===i;var H=R.getTextAlign(o.getHAlign(),k&&k.getTextDirection&&k.getTextDirection());r.style("text-align",H);r.class("sapUiTableCell");r.class("sapUiTablePseudoCell");if(I){r.class("sapUiTableCellFirst");}if(m){r.class("sapUiTableCellLastFixed");}if(l){r.class("sapUiTableCellLast");}r.openEnd();if(k){r.openStart("div");r.class("sapUiTableCellInner");r.openEnd();T.renderTableCellControl(r,t,k,I);r.close("div");}r.close("td");}}if(!f&&g&&j.length>0){r.openStart("td").class("sapUiTableCellDummy").openEnd().close("td");}r.close("tr");r.close("tbody");r.close("table");};
C.renderToolbar=function(r,c){r.renderControl(c._getToolbar());};
return C;},true);
sap.ui.predefine('sap/ui/table/Row',["sap/ui/core/Element","./utils/TableUtils","sap/ui/thirdparty/jquery"],function(E,T,q){"use strict";var R=Object.freeze({Standard:"Standard",Summary:"Summary",GroupHeader:"GroupHeader"});
function a(){var c=null;var t=R.Standard;var C=false;var d="";var e=false;var f=false;var l=0;Object.defineProperties(this,{context:{get:function(){return c;},set:function(_){c=_||null;}},Type:{get:function(){return R;}},type:{get:function(){return t;},set:function(_){if(!(_ in R)){throw Error("Is not a valid type for sap.ui.table.Row: "+_);}t=_;}},empty:{get:function(){return this.context==null;}},contentHidden:{get:function(){return this.empty?true:C;},set:function(_){C=_===true;}},title:{get:function(){return this.empty?"":d;},set:function(_){d=(typeof _==="string"?_:"");}},expandable:{get:function(){return this.empty?false:f;},set:function(_){f=_===true;}},expanded:{get:function(){return this.expandable?e:false;},set:function(_){e=_===true;}},level:{get:function(){return this.empty?0:l;},set:function(_){l=(typeof _==="number"?Math.max(1,_||1):1);}},reset:{value:function(){c=null;t=R.Standard;C=false;d="";f=false;e=false;l=1;}}});}
var S=new window.WeakMap();
function s(r){if(!S.has(r)){S.set(r,Object.seal(new a()));}return S.get(r);}
var b=E.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});
b.prototype.init=function(){this.initDomRefs();};
b.prototype.exit=function(){this.initDomRefs();};
b.prototype.getFocusInfo=function(){var t=this.getTable();return t?t.getFocusInfo():E.prototype.getFocusInfo.apply(this,arguments);};
b.prototype.applyFocusInfo=function(f){var t=this.getTable();if(t){t.applyFocusInfo(f);}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};
b.prototype._setFocus=function(f){var F=T.getFirstInteractiveElement(this);if(f===true&&F){F.focus();}else{this.getDomRef("col0").focus();}};
b.prototype.addStyleClass=function(c){this.getDomRefs(true).row.addClass(c);};
b.prototype.removeStyleClass=function(c){this.getDomRefs(true).row.removeClass(c);};
b.prototype.initDomRefs=function(){this._mDomRefs={};};
b.prototype.getIndex=function(){var t=this.getTable();if(!t){return-1;}var r=t.indexOfRow(this);var m=t._getRowCounts();if(m.fixedTop>0&&r<m.fixedTop){return r;}if(m.fixedBottom>0&&r>=m.count-m.fixedBottom){var i=t._getTotalRowCount();if(i>=m.count){return i-(m.count-r);}else{return r;}}return t._getFirstRenderedRowIndex()+r;};
b.prototype.getDomRefs=function(j,c){j=j===true;c=c===true;var k=j?"jQuery":"dom";var d=this._mDomRefs;if(!d[k]){var t=this.getTable();var g=function(i){var e=document.getElementById(i);if(e){return j?q(e):e;}return null;};var G=function(e){if(e){return j?e.parent():e.parentNode;}return null;};d[k]={};if(t){var r=t.indexOfRow(this);d[k].rowSelector=g(t.getId()+"-rowsel"+r);d[k].rowAction=g(t.getId()+"-rowact"+r);}d[k].rowHeaderPart=G(d[k].rowSelector);d[k].rowFixedPart=g(this.getId()+"-fixed");d[k].rowScrollPart=g(this.getId());d[k].rowActionPart=G(d[k].rowAction);d[k].rowSelectorText=g(this.getId()+"-rowselecttext");if(j){d[k].row=q().add(d[k].rowHeaderPart).add(d[k].rowFixedPart).add(d[k].rowScrollPart).add(d[k].rowActionPart);}else{d[k].row=[d[k].rowHeaderPart,d[k].rowFixedPart,d[k].rowScrollPart,d[k].rowActionPart].filter(Boolean);}}var K=d[k];if(c){return Object.keys(K).map(function(k){return k==="row"?null:K[k];}).filter(Boolean);}return K;};
b.prototype._updateSelection=function(){var t=this.getTable();var i=t._getSelectionPlugin().isIndexSelected(this.getIndex());this._setSelected(i);t._getAccExtension().updateSelectionStateOfRow(this);};
b.prototype.setRowBindingContext=function(c,t){var B=t.getBindingInfo("rows");var m=B?B.model:undefined;var o=s(this);o.reset();o.context=c;if(o.context){T.Hook.call(t,T.Hook.Keys.Row.UpdateState,o);}this.setBindingContext(o.context,m);this.getDomRefs(true).row.toggleClass("sapUiTableRowHidden",this.isContentHidden());this._updateTableCells(t);};
b.prototype.getRowBindingContext=function(){return s(this).context;};
b.prototype.setBindingContext=function(c,m){return E.prototype.setBindingContext.call(this,c||null,m);};
b.prototype._updateTableCells=function(t){var c=this.getCells(),A=this.getIndex(),h=!!t._updateTableCell,C,$,H,B=this.getRowBindingContext();for(var i=0;i<c.length;i++){C=c[i];H=!!C._updateTableCell;$=H||h?C.$().closest("td"):null;if(H){C._updateTableCell(C,B,$,A);}if(h){t._updateTableCell(C,B,$,A);}}};
b.prototype.getType=function(){return s(this).type;};
b.prototype.isGroupHeader=function(){return this.getType()===R.GroupHeader;};
b.prototype.isSummary=function(){return this.getType()===R.Summary;};
b.prototype.isGroupSummary=function(){return this.isSummary()&&this.getLevel()>1;};
b.prototype.isTotalSummary=function(){return this.isSummary()&&this.getLevel()===1;};
b.prototype.isEmpty=function(){return s(this).empty;};
b.prototype.isContentHidden=function(){return s(this).contentHidden;};
b.prototype.getLevel=function(){return s(this).level;};
b.prototype.getTitle=function(){return s(this).title;};
b.prototype.isExpandable=function(){return s(this).expandable;};
b.prototype.isExpanded=function(){return s(this).expanded;};
b.prototype.destroy=function(){this.removeAllCells();return E.prototype.destroy.apply(this,arguments);};
b.prototype.invalidate=function(){return this;};
b.prototype.getDragGhost=function(){var t=this.getTable();var o=t.getDomRef();var r=this.getDomRefs();var g;var G;var c;var d=t._getSelectionPlugin().getSelectedCount();function e(j){j.removeAttribute("id");j.removeAttribute("data-sap-ui");j.removeAttribute("data-sap-ui-related");var k=j.children.length;for(var i=0;i<k;i++){e(j.children[i]);}}function f(o,i){var j=o.cloneNode();var k=o.querySelector("thead").cloneNode(true);var l=o.querySelector("tbody").cloneNode();var m=i.cloneNode(true);l.appendChild(m);j.appendChild(k);j.appendChild(l);return j;}g=o.cloneNode();g.classList.add("sapUiTableRowGhost");g.classList.remove("sapUiTableVScr");g.classList.remove("sapUiTableHScr");g.style.width=o.getBoundingClientRect().width+"px";if(r.rowSelector){G=t.getDomRef("sapUiTableRowHdrScr").cloneNode();c=r.rowSelector.cloneNode(true);G.appendChild(c);g.appendChild(G);}if(r.rowFixedPart){G=t.getDomRef("sapUiTableCtrlScrFixed").cloneNode();c=f(t.getDomRef("table-fixed"),r.rowFixedPart);G.appendChild(c);g.appendChild(G);}if(r.rowScrollPart){var h=t.getDomRef("sapUiTableCtrlScr");G=h.cloneNode();c=f(t.getDomRef("table"),r.rowScrollPart);G.appendChild(t.getDomRef("tableCtrlCnt").cloneNode());G.firstChild.appendChild(c);g.appendChild(G);}if(r.rowAction){G=t.getDomRef("sapUiTableRowActionScr").cloneNode();c=r.rowAction.cloneNode(true);G.appendChild(c);g.appendChild(G);}if(d>1){G=document.createElement("div");G.classList.add("sapUiTableRowGhostCount");var C=document.createElement("div");C.textContent=d;G.appendChild(C);g.appendChild(G);}e(g);return g;};
b.prototype._setSelected=function(c){var t=this.getTable();if(c){this.addStyleClass("sapUiTableRowSel");}else{this.removeStyleClass("sapUiTableRowSel");}if(t){T.dynamicCall(t._getSyncExtension,function(o){o.syncRowSelection(t.indexOfRow(this),c);},this);}};
b.prototype._setHovered=function(h){var t=this.getTable();if(h){this.addStyleClass("sapUiTableRowHvr");}else{this.removeStyleClass("sapUiTableRowHvr");}if(t){T.dynamicCall(t._getSyncExtension,function(o){o.syncRowHover(t.indexOfRow(this),h);},this);}};
b.prototype.getRowAction=function(){return this.getAggregation("_rowAction");};
b.prototype.getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};
b.prototype.expand=function(){if(this.isExpandable()&&!this.isExpanded()){T.Hook.call(this.getTable(),T.Hook.Keys.Row.Expand,this);}};
b.prototype.collapse=function(){if(this.isExpandable()&&this.isExpanded()){T.Hook.call(this.getTable(),T.Hook.Keys.Row.Collapse,this);}};
b.prototype.toggleExpandedState=function(){if(this.isExpanded()){this.collapse();}else{this.expand();}};
b.prototype.Type=R;return b;});
sap.ui.predefine('sap/ui/table/RowAction',["./library","./utils/TableUtils","./RowActionRenderer","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/unified/Menu","sap/ui/core/Popup"],function(l,T,R,C,I,M,P){"use strict";
var a=C.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}}});
a.prototype.init=function(){this._bFixedLayout=true;this._aActions=["",""];this._iLastCloseTime=0;this.addAggregation("_icons",new I(this.getId()+"-icon0",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var i=this.getAggregation("_icons")[0].getDomRef();if(this._aActions[0]==="menu"){i.setAttribute("aria-haspopup","menu");}else{i.removeAttribute("aria-haspopup");}}},this);this.addAggregation("_icons",new I(this.getId()+"-icon1",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var i=this.getAggregation("_icons")[1].getDomRef();if(this._aActions[1]==="menu"){i.setAttribute("aria-haspopup","menu");}else{i.removeAttribute("aria-haspopup");}}},this);};
a.prototype.onBeforeRendering=function(){var r=this.getRow();var t=r?r.getTable():null;var i=this.getAggregation("_icons");var b=this.getItems();var v=this._getVisibleItems();var V=v.length;var s=this._getSize();var h=t?t.getId()+"-rowacthdr":"";if(this._bFixedLayout&&V===1&&s===2&&b.length>1&&v[0]===b[1]){v[0]._syncIcon(i[1]);this._aActions=["","action_fixed"];}else if(V===0||s===0){this._aActions=["",""];}else if(V===1&&s>0){v[0]._syncIcon(i[0]);this._aActions=["action",""];}else if(V===2&&s===2){v[0]._syncIcon(i[0]);v[1]._syncIcon(i[1]);this._aActions=["action","action"];}else if(V>2&&s===2){v[0]._syncIcon(i[0]);i[1].setSrc("sap-icon://overflow");i[1].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["action","menu"];}else{i[0].setSrc("sap-icon://overflow");i[0].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["menu",""];}i.forEach(function(o,c){o.removeAllAriaLabelledBy();o.removeStyleClass("sapUiTableActionHidden");if(h){o.addAriaLabelledBy(h);}if(this._aActions[c]===""){o.addStyleClass("sapUiTableActionHidden");}}.bind(this));};
a.prototype.getAccessibilityInfo=function(){var r=this.getRow();var v=this._getVisibleItems().length;var s=this._getSize();var A=this.getVisible()&&v>0&&s>0&&(!r||(!r.isContentHidden()&&!r.isGroupHeader()&&!r.isSummary()));var t;if(A){t=T.getResourceText(v==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[v]);}else{t=T.getResourceText("TBL_ROW_ACTION_NO_ACTION");}return{focusable:A,enabled:A,description:t};};
a.prototype._getVisibleItems=function(){return this.getItems().filter(function(i){return i.getVisible();});};
a.prototype.getRow=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Row")?p:null;};
a.prototype._getSize=function(){var r=this.getRow();var t=r?r.getTable():null;return t?t.getRowActionCount():2;};
a.prototype._onIconPress=function(e){var o=e.getSource();var b=this.indexOfAggregation("_icons",o);var A=this._aActions[b];if(A==="action"){this._getVisibleItems()[b]._firePress();}else if(A==="action_fixed"){this._getVisibleItems()[0]._firePress();}else if(A==="menu"){var m=this.getAggregation("_menu");if(!m){m=new M();this.setAggregation("_menu",m,true);m.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now();},this);}m.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return;}var c=this.getItems();for(var i=b;i<c.length;i++){m.addItem(c[i]._getMenuItem());}m.open(null,o,P.Dock.EndTop,P.Dock.EndBottom,o);}};
return a;});
sap.ui.predefine('sap/ui/table/RowActionItem',["./library","./utils/TableUtils","sap/ui/core/Element","sap/ui/unified/MenuItem","sap/ui/core/IconPool"],function(l,T,E,M,I){"use strict";var R=l.RowActionType;
var a=E.extend("sap.ui.table.RowActionItem",{metadata:{library:"sap.ui.table",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Misc",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.ui.table.RowActionType",group:"Behavior",defaultValue:R.Custom}},events:{press:{item:{type:"sap.ui.table.RowActionItem"},row:{type:"sap.ui.table.Row"}}}}});
a.prototype.init=function(){this._oMenuItem=null;};
a.prototype.exit=function(){if(this._oMenuItem){this._oMenuItem.destroy();this._oMenuItem=null;}};
a.prototype.getRowAction=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.RowAction")?p:null;};
a.prototype._firePress=function(){var r=this.getRowAction();this.firePress({item:this,row:r?r.getRow():null});};
a.prototype._getMenuItem=function(){if(!this._oMenuItem){this._oMenuItem=new M({select:[this._firePress,this]});}this._oMenuItem.setIcon(this._getIcon());this._oMenuItem.setVisible(this.getVisible());this._oMenuItem.setText(this._getText(false));return this._oMenuItem;};
a.prototype._getIcon=function(){var i=this.getIcon();if(i){return i;}if(this.getType()===R.Navigation){return I.getIconURI(T.ThemeParameters.navigationIcon);}if(this.getType()===R.Delete){return I.getIconURI(T.ThemeParameters.deleteIcon);}return null;};
a.prototype._getText=function(p){var t=p?(this.getTooltip_AsString()||this.getText()):(this.getText()||this.getTooltip_AsString());if(t){return t;}if(this.getType()===R.Navigation){return T.getResourceText("TBL_ROW_ACTION_NAVIGATE");}if(this.getType()===R.Delete){return T.getResourceText("TBL_ROW_ACTION_DELETE");}return null;};
a.prototype._syncIcon=function(i){i.setSrc(this._getIcon());i.setTooltip(this._getText(true));};
return a;});
sap.ui.predefine('sap/ui/table/RowActionRenderer',['sap/ui/table/Row'],function(R){"use strict";var a={apiVersion:2};
a.render=function(r,A){r.openStart("div",A);r.class("sapUiTableAction");if(!A.getRow()){r.style("display","none");}if(!A.getVisible()){r.class("sapUiTableActionHidden");}var t=A.getTooltip_AsString();if(t){r.attr("title",t);}r.openEnd();var i=A.getAggregation("_icons");r.renderControl(i[0]);r.renderControl(i[1]);r.close("div");};
return a;},true);
sap.ui.predefine('sap/ui/table/RowSettings',['sap/ui/core/Element','./utils/TableUtils','sap/ui/base/DataType','./library','sap/ui/core/library'],function(E,T,D,l,c){"use strict";var M=c.MessageType;var I=c.IndicationColor;
var R=E.extend("sap.ui.table.RowSettings",{metadata:{library:"sap.ui.table",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}}}});
R.prototype.validateProperty=function(p,v){if(p!="highlight"||v==null){return E.prototype.validateProperty.apply(this,arguments);}if(!D.getType("sap.ui.core.MessageType").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected is a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor"+" for property \""+p+"\" of "+this);}return v;};
R.prototype.setHighlight=function(h){var r;var H;this.setProperty("highlight",h,true);r=this._getRow();if(!r){return this;}H=r.getDomRef("highlight");if(!H){return this;}for(var m in M){H.classList.remove("sapUiTableRowHighlight"+m);}for(var i in I){H.classList.remove("sapUiTableRowHighlight"+i);}H.classList.add(this._getHighlightCSSClassName());var t=r.getParent();var a=t?t._getAccExtension():null;if(a){a.updateAriaStateOfRowHighlight(this);}return this;};
R.prototype.setNavigated=function(n){var r;var N;this.setProperty("navigated",n,true);r=this._getRow();if(!r){return this;}N=r.getDomRef("navIndicator");if(!N){return this;}if(n){N.classList.add("sapUiTableRowNavigated");}else{N.classList.remove("sapUiTableRowNavigated");}var t=r.getParent();var a=t?t._getAccExtension():null;if(a){a._updateAriaStateOfNavigatedRow(this);}return this;};
R.prototype.setHighlightText=function(h){var r=this._getRow();var t=r?r.getParent():null;var a=t?t._getAccExtension():null;this.setProperty("highlightText",h,true);if(a){a.updateAriaStateOfRowHighlight(this);}return this;};
R.prototype._getHighlightCSSClassName=function(){var h=this.getHighlight();if(h==null){h=M.None;}return"sapUiTableRowHighlight"+h;};
R.prototype._getHighlightText=function(){var h=this.getHighlight();if(h===M.None){return"";}var H=this.getHighlightText();if(h in M&&H===""){H=T.getResourceText("TBL_ROW_STATE_"+h.toUpperCase());}return H;};
R.prototype._getRow=function(){var r=this.getParent();if(T.isA(r,"sap.ui.table.Row")){return r;}else{return null;}};
return R;});
sap.ui.predefine('sap/ui/table/Table',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/util/PasteHelper','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./utils/TableUtils','./extensions/ExtensionBase','./extensions/Accessibility','./extensions/Keyboard','./extensions/Pointer','./extensions/Scrolling','./extensions/DragAndDrop',"./TableRenderer","./rowmodes/FixedRowMode","./rowmodes/InteractiveRowMode","./rowmodes/AutoRowMode","./plugins/SelectionModelSelection","sap/ui/thirdparty/jquery","sap/base/Log"],function(D,C,P,a,F,S,B,b,R,c,T,E,A,K,d,e,f,g,h,I,j,k,q,L){"use strict";var G=c.GroupEventType;var N=c.NavigationMode;var m=c.SelectionMode;var n=c.SelectionBehavior;var o=c.SortOrder;var V=c.VisibleRowCountMode;var H=T.Hook.Keys.Table;var _=T.createWeakMapFacade();
var p=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:m.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:n.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar,deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},rowCountConstraints:{type:"object",visibility:"hidden"}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false,deprecated:true},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin"},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}},rowsUpdated:{}},designtime:"sap/ui/table/designtime/Table.designtime"}});
p.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};_(this).iCachedBindingLength=0;_(this).iFirstRenderedRowIndex=0;_(this).iComputedFixedColumnCount=null;this._attachExtensions();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._aRowHeights=[];this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;_(this).iPendingRequests=0;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){T.readThemeParameters();}this._bInvalid=true;};
p.prototype.applySettings=function(l,X){if(l){var Y=["rowMode","plugins"];var Z={};for(var i=0;i<Y.length;i++){var $=Y[i];if($ in l){Z[$]=l[$];delete l[$];}}if(Object.keys(Z).length>0){C.prototype.applySettings.call(this,Z,X);}}this._initLegacyRowMode();this._initLegacySelectionPlugin();C.prototype.applySettings.call(this,l,X);};
p.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}E.enrich(this,d);E.enrich(this,e);E.enrich(this,K);E.enrich(this,A);E.enrich(this,f);if(D.os.ios){sap.ui.require(["sap/ui/table/extensions/ScrollingIOS"],function(i){if(!this.bIsDestroyed){E.enrich(this,i);}}.bind(this));}this._bExtensionsInitialized=true;};
p.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();this._cleanUpTimers();this._detachEvents();T.Menu.cleanupDefaultContentCellContextMenu(this);Q(this);delete this._aTableHeaders;};
p.prototype._detachExtensions=function(){E.cleanup(this);};
p.prototype.onpaste=function(i){if(i.isMarked()||/^(input|textarea)$/i.test(i.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(i.target)){return;}var l=P.getPastedDataAs2DArray(i.originalEvent);if(l.length===0||l[0].length===0){return;}this.firePaste({data:l});};
p.prototype.onThemeChanged=function(){T.readThemeParameters();if(this.getDomRef()){this.invalidate();}};
p.prototype.onlocalizationChanged=function(i){var l=i.changes||{};var X=l.hasOwnProperty("rtl");var Y=l.hasOwnProperty("language");this._adaptLocalization(X,Y).then(function(){this.invalidate();}.bind(this)).catch(function(){});};
p.prototype._adaptLocalization=function(i,l){if(!i&&!l){return Promise.reject();}var X=Promise.resolve();if(i){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){X=T.getResourceBundle({async:true,reload:true});}return X.then(function(){if(l){T.Menu.cleanupDefaultContentCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};
p.prototype._collectRowHeights=function(l){var X=this.getDomRef();if(!X){return[];}var Y=this._getBaseRowHeight();var Z=l?".sapUiTableColHdrTr":".sapUiTableTr";var $=X.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Z);var a1=X.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Z);var b1=l?T.getHeaderRowCount(this):this.getRows().length;var c1=[];var d1=D.browser.chrome&&window.devicePixelRatio!=1;if(l){if(this.getColumnHeaderHeight()>0){Y=this.getColumnHeaderHeight();}else if(this.getRowMode()){Y=this._getDefaultRowHeight();}}for(var i=0;i<b1;i++){var e1=$[i]?$[i].getBoundingClientRect().height:0;var f1=a1[i]?a1[i].getBoundingClientRect().height:0;var g1=Math.max(e1,f1);if(d1){var h1=Y-g1;if(h1>0&&h1<1){c1.push(Math.max(g1,Y-1));continue;}}c1.push(Math.max(g1,Y));}if(c1.length>0&&!l){T.dynamicCall(this._getSyncExtension,function(i1){var j1=i1.syncRowHeights(c1.slice());if(j1&&j1.length===c1.length){c1=j1.slice();}});}return c1;};
p.prototype._resetRowHeights=function(){var l=this._getBaseRowHeight();var X="";if(l){X=l+"px";}var Y=this.getDomRef("tableCCnt");if(Y){var Z=Y.querySelectorAll(".sapUiTableTr");for(var i=0;i<Z.length;i++){Z[i].style.height=X;}}};
p.prototype._resetColumnHeaderHeights=function(){var l=this.getDomRef();if(l){var X=l.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<X.length;i++){X[i].style.height=null;}}};
p.prototype._collectTableSizes=function(){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var X=this.getDomRef();if(!X){return l;}var Y=X.querySelector(".sapUiTableCnt");if(Y){l.tableCntHeight=Y.clientHeight;l.tableCntWidth=Y.clientWidth;}var Z=X.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(Z){l.tableCtrlScrollWidth=Z.clientWidth;}var $=X.querySelector(".sapUiTableRowHdrScr");if($){l.tableRowHdrScrWidth=$.clientWidth;}var a1=X.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(a1){l.tableCtrlScrWidth=a1.clientWidth;}var b1=X.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(b1){l.tableCtrlFixedWidth=b1.clientWidth;}var c1=this._getSpanBasedComputedFixedColumnCount();var d1=0;if(c1){var e1=this.getColumns();var f1=X.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<f1.length;i++){var g1=parseInt(f1[i].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(g1)&&(g1<c1)){var h1=e1[g1];var i1;if(h1._iFixWidth!=null){i1=h1._iFixWidth;}else{i1=f1[i].getBoundingClientRect().width;}d1+=i1;}}}if(d1>0){var j1=this._getScrollExtension();var k1=l.tableRowHdrScrWidth;var l1=j1.getVerticalScrollbar();if(l1&&!j1.isVerticalScrollbarExternal()){k1+=l1.offsetWidth;}if(T.hasRowActions(this)){var m1=this.getDomRef("sapUiTableRowActionScr");if(m1){k1+=m1.offsetWidth;}}k1+=T.Column.getMinColumnWidth();var n1=l.tableCntWidth-k1;var o1=n1>d1;var p1=!o1;if(this._bIgnoreFixedColumnCount!==p1){this._bIgnoreFixedColumnCount=p1;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return l;};
p.prototype._updateRowHeights=function(i,l){var X=this.getDomRef();if(!X){return;}function Y(d1,e1){var f1=i[e1];if(f1){d1.style.height=f1+"px";}}var Z=l?".sapUiTableColHdrTr":".sapUiTableTr";var $=l?[]:X.querySelectorAll(".sapUiTableRowSelectionCell");var a1=l?[]:X.querySelectorAll(".sapUiTableRowActionCell");var b1=X.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Z);var c1=X.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Z);Array.prototype.forEach.call($,Y);Array.prototype.forEach.call(a1,Y);Array.prototype.forEach.call(b1,Y);Array.prototype.forEach.call(c1,Y);};
p.prototype.onBeforeRendering=function(i){this._bInvalid=true;this._detachEvents();if(i&&i.isMarked("renderRows")){return;}this._cleanUpTimers();this.getBinding();this._aTableHeaders=[];};
p.prototype.onAfterRendering=function(i){var l=i&&i.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!l){this._disableTextSelection(this.$().find(".sapUiTableCHA"));}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!l){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");}this._updateTableSizes(T.RowsUpdateReason.Render,true);this._adjustFirstVisibleRowToTotalRowCount();T.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false;};
p.prototype.invalidate=function(){this._bInvalid=true;T.Column.invalidateColumnUtils(this);return C.prototype.invalidate.call(this);};
p.prototype._initRowDomRefs=function(){var l=this.getRows();for(var i=0;i<l.length;i++){l[i].initDomRefs();}};
p.prototype._updateTableSizes=function(l,X){X=X===true;var Y=this.getDomRef();if(this._bInvalid||!Y||!sap.ui.getCore().isThemeApplied()||Y.offsetWidth===0){return;}if(!X){this._resetRowHeights();this._resetColumnHeaderHeights();}this._aRowHeights=this._collectRowHeights(false);var Z=this._collectRowHeights(true);function $(k1){var l1=k1.getDomRef();var m1=T.Column.getMinColumnWidth();var n1=[];var o1=k1.getColumnHeaderVisible();function p1(s1,t1){if(s1<=t1){return Math.max(s1,t1-5,m1)+"px";}return-1;}function q1(t1){var u1=Math.max(t1._minWidth||0,m1,t1.getMinWidth());var v1=t1.getWidth();var w1;var x1;var y1;if(T.isVariableWidth(v1)&&!T.isFixedColumn(k1,t1.getIndex())){w1=l1.querySelectorAll('th[data-sap-ui-colid="'+t1.getId()+'"]');x1=w1[o1?0:1];y1=x1?x1.offsetWidth:null;if(y1!==null){if(y1<=u1){return{headers:w1,newWidth:p1(y1,u1)};}else if(x1&&x1.style.width!=v1){n1.push({col:t1,header:x1,minWidth:u1,headers:w1});return{headers:w1,newWidth:v1};}n1.push({col:t1,header:x1,minWidth:u1,headers:w1});}}return null;}function r1(t1){if(t1){Array.prototype.forEach.call(t1.headers,function(u1){u1.style.width=t1.newWidth;});}}k1._getVisibleColumns().map(q1).forEach(r1);if(n1.length){var s1;for(var i=0;i<n1.length;i++){s1=n1[i].header&&n1[i].header.offsetWidth;n1[i].newWidth=p1(s1,n1[i].minWidth);if(parseInt(n1[i].newWidth)>=0){r1(n1[i]);}}}}$(this);var a1=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(Z,true);T.dynamicCall(this._getSyncExtension,function(i){i.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height});},this);var b1=this.$();if(T.hasRowActions(this)||T.hasRowNavigationIndicators(this)){var c1=b1.hasClass("sapUiTableRActFlexible");var d1=this.getDomRef("dummycolhdr");if(d1){var e1=this.getDomRef("header");var f1=e1.clientWidth;var g1=this.getColumns().reduce(function(g1,i){if(i.getDomRef()&&i.getIndex()>=this.getComputedFixedColumnCount()){return g1+T.convertCSSSizeToPixel(i.getWidth());}return g1;}.bind(this),0);var h1=f1>g1+1;if(!c1&&h1){var i1=g1+a1.tableRowHdrScrWidth+a1.tableCtrlFixedWidth;var j1={};if(!T.hasRowActions(this)){i1=i1-T.ThemeParameters.navIndicatorWidth+T.BaseBorderWidth;}j1[this._bRtlMode?"right":"left"]=i1;this.$("sapUiTableRowActionScr").css(j1);this.$("rowacthdr").css(j1);b1.toggleClass("sapUiTableRActFlexible",true);}else if(c1&&!h1){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");b1.toggleClass("sapUiTableRActFlexible",false);}}}b1.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");T.Hook.call(this,H.UpdateSizes,l);};
p.prototype.setShowOverlay=function(i){this.setProperty("showOverlay",i,true);if(this.getDomRef()){this.$().toggleClass("sapUiTableOverlay",this.getShowOverlay());this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus();}return this;};
p.prototype._updateFixedBottomRows=function(){var i=this.getDomRef();if(!i||this._getRowCounts().fixedBottom===0){return;}var l=T.getFirstFixedBottomRowIndex(this);var X=this.getRows();var $;q(i).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");q(i).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(l>=0&&l<X.length){$=X[l].getDomRefs(true);$.row.addClass("sapUiTableRowFirstFixedBottom",true);}if(l>=1&&l<X.length){$=X[l-1].getDomRefs(true);$.row.addClass("sapUiTableRowLastScrollable",true);}};
p.prototype.focus=function(i){this._oFocusInfo=i;C.prototype.focus.apply(this,arguments);delete this._oFocusInfo;};
p.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return C.prototype.getFocusInfo.apply(this,arguments);}};
p.prototype.applyFocusInfo=function(i){if(i&&i.customId){q(document.getElementById(i.customId)).trigger("focus");}else{C.prototype.applyFocusInfo.apply(this,arguments);}return this;};
p.prototype.setTitle=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});l.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",l);return this;};
p.prototype.setFooter=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});}this.setAggregation("footer",l);return this;};
p.prototype.setSelectionMode=function(i){if(i===m.Multi){i=m.MultiToggle;L.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this);}if(this._hasSelectionPlugin()){L.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this);}else{this.setProperty("selectionMode",i);this._oLegacySelectionPlugin.setSelectionMode(i);}return this;};
p.prototype.setFirstVisibleRow=function(i){if(i==null){i=0;}else if(i<0){L.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);i=0;}else if(this._bContextsAvailable){var l=this._getMaxFirstVisibleRowIndex();if(l<i){L.warning("The index of the first visible row is too high. The value has been set to "+l+".",this);i=l;}}this._setFirstVisibleRowIndex(i);return this;};
p.prototype._setFirstVisibleRowIndex=function(i,l){l=Object.assign({onScroll:false,suppressScrolling:false,suppressEvent:false,forceEvent:false,suppressRendering:false,onlySetProperty:false},l);if(this._bContextsAvailable){i=Math.min(i,this._getMaxFirstVisibleRowIndex());}i=Math.max(0,i);var X=this.getFirstVisibleRow()!==i;var Y=this._getFirstRenderedRowIndex();var Z=this._bContextsAvailable?Math.min(i,this._getMaxFirstRenderedRowIndex()):i;var $=this._getScrollExtension();this.setProperty("firstVisibleRow",i,true);if(!l.suppressRendering){_(this).iFirstRenderedRowIndex=Z;}if(l.onlySetProperty){return false;}if((X||l.forceEvent)&&!l.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}if(!this.getBinding()){$.updateVerticalScrollPosition();return false;}var a1=false;var b1=this.getBinding()!=null&&Z!==Y;if(b1){if(!l.suppressRendering){y(this,l.onScroll?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange);a1=true;}if(!l.onScroll&&!l.suppressScrolling){$.updateVerticalScrollPosition(a1);}}else if(!l.onScroll&&!l.suppressScrolling){$.updateVerticalScrollPosition(!this._bContextsAvailable);}return a1;};
p.prototype._setFocus=function(i,l){return new Promise(function(X){if(i===-1){i=this._getTotalRowCount()-1;}if(typeof i!=='number'||i<-1){i=0;}var Y=this.getFirstVisibleRow();var Z=this._getRowCounts().count;if(i>Y&&i<Y+Z){this.getRows()[i-Y]._setFocus(l);return X();}if(this._setFirstVisibleRowIndex(i)){this.attachEventOnce("rowsUpdated",function(){s(this,i,l);return X();});}else{s(this,i,l);return X();}}.bind(this));};
function s(i,l,X){var Y=i._getTotalRowCount();var Z=i._getFirstRenderedRowIndex();i.getRows()[Math.min(l,Y-1)-Z]._setFocus(X);}
p.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
p.prototype.bindAggregation=function(i,l){if(i==="rows"){this._bindRows(t(Array.prototype.slice.call(arguments,1)));return this;}return C.prototype.bindAggregation.apply(this,arguments);};
p.prototype.bindRows=function(i){this._bindRows(t(arguments));return this;};
p.prototype._bindRows=function(i){r(this);this._bRowsBeingBound=true;x(this);O(this);p._addBindingListener(i,"change",function(){this._onBindingChange.apply(this,arguments);}.bind(this));p._addBindingListener(i,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments);}.bind(this));p._addBindingListener(i,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments);}.bind(this));T.Hook.call(this,H.BindRows,i);C.prototype.bindAggregation.call(this,"rows",i);this._bRowsBeingBound=false;};
p.prototype._bindAggregation=function(i,l){if(i==="rows"){r(this);this._bRowsBeingBound=true;}C.prototype._bindAggregation.call(this,i,l);if(i==="rows"){T.Grouping.setupExperimentalGrouping(this);var X=this.getBinding();var Y=X?X.getModel():null;this._bRowsBeingBound=false;T.Hook.call(this,H.RowsBound,X);if(Y&&Y.getDefaultBindingMode()===B.OneTime){L.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}};
p.prototype.unbindAggregation=function(i,l){if(i==="rows"){this._unbindRows();return this;}return C.prototype.unbindAggregation.apply(this,arguments);};
p.prototype.unbindRows=function(){this._unbindRows();return this;};
p.prototype._unbindRows=function(){var i=this.getBindingInfo("rows");if(i){T.Hook.call(this,H.UnbindRows,i);}C.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return;}this._adjustToTotalRowCount();if(i){T.Hook.call(this,H.RowsUnbound);}r(this);O(this);};
function r(i){i._bRowsBeingBound=false;i._bContextsAvailable=false;_(i).iPendingRequests=0;i._iBindingLength=null;}
function t(i){var l;if(i==null||i[0]==null){l={};}else if(typeof i[0]==="string"){var X=i[0];var Y=i[1];var Z=i[2];var $=i[3];if(Y instanceof S||Array.isArray(Z)&&Z[0]instanceof F){$=Z;Z=Y;Y=undefined;}l={path:X,sorter:Z,filters:$,template:Y};}else{l=i[0];}return l;}
p._addBindingListener=function(i,l,X,Y){if(!i.events){i.events={};}var Z=i.events[l];i.events[l]=function(){X.apply(Y,arguments);if(Z){Z.apply(this,arguments);}};};
p.prototype._onBindingChange=function(i){};
p.prototype.setRowMode=function(i){this._destroyLegacyRowMode();this.setAggregation("rowMode",i);this._initLegacyRowMode();};
p.prototype.getRowMode=function(){return this.getAggregation("rowMode");};
p.prototype._getRowMode=function(){var i=this.getRowMode()||this._oLegacyRowMode;if(!i){this._initLegacyRowMode();i=this._oLegacyRowMode;}return i;};
p.prototype._initLegacyRowMode=function(){if(this._oLegacyRowMode||this.getRowMode()){return;}this._oLegacyRowMode=u(this);this.addAggregation("_hiddenDependents",this._oLegacyRowMode);};
p.prototype._destroyLegacyRowMode=function(){if(this._oLegacyRowMode){this._oLegacyRowMode.destroy();delete this._oLegacyRowMode;}};
function u(i){var l;switch(i.getVisibleRowCountMode()){case V.Fixed:l=new h(true);break;case V.Interactive:l=new I(true);break;case V.Auto:l=new j(true);break;default:}return l;}
p.prototype._getRowCounts=function(){var i=this._getRowMode().getComputedRowCounts();var l=this._bVariableRowHeightEnabled&&!i.fixedTop&&!i.fixedBottom;i._fullsize=i.count;i._scrollSize=i.scrollable;if(i.count>0&&l){i.count++;i.scrollable++;}return i;};
p.prototype.setVisibleRowCountMode=function(i){if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCountMode\" has no effect");return this.setProperty("visibleRowCountMode",i,true);}var l=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",i);var X=this.getVisibleRowCountMode();if(X!==l){this._destroyLegacyRowMode();this._initLegacyRowMode();}return this;};
p.prototype.setVisibleRowCount=function(i){var l=this.getVisibleRowCountMode();if(l==V.Auto){L.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}if(i!=null&&!isFinite(i)){return this;}var X=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=X&&X>0){L.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCount\" has no effect");return this.setProperty("visibleRowCount",i,true);}i=this.validateProperty("visibleRowCount",i);this.setProperty("visibleRowCount",i);T.dynamicCall(this._getSyncExtension,function(Y){Y.syncRowCount(i);});return this;};
p.prototype.setMinAutoRowCount=function(i){if(parseInt(i)<1){L.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);i=1;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"minAutoRowCount\" has no effect");return this.setProperty("minAutoRowCount",i,true);}return this.setProperty("minAutoRowCount",i);};
p.prototype.setTooltip=function(i){L.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",i,true);};
p.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);L.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this;};
p.prototype._getRowContexts=function(i){var l=this.getBinding();var X=this._getRowCounts();var Y=this.getThreshold();i=i==null?X.count:i;if(Y!==0){Y=Math.max(i-X.fixedTop-X.fixedBottom,Y);}i=Math.max(i,this._getRowMode().getMinRequestLength(),0);if(!l||i===0){return[];}var Z=this._getFirstRenderedRowIndex();var $=[];if(X.fixedTop>0&&Z>0){v($,this._getFixedTopRowContexts(),0);v($,this._getContexts(Z+X.fixedTop,i-X.fixedBottom-X.fixedTop,Y),X.fixedTop);}else{v($,this._getContexts(Z,i-X.fixedBottom,Y),0);}if(X.fixedBottom>0){v($,this._getFixedBottomRowContexts(),Math.min(X.fixedTop+X.scrollable,Math.max(this._getTotalRowCount()-X.fixedBottom,0)));}return $;};
function v(l,X,Y){for(var i=0;i<X.length;i++){l[Y+i]=X[i];}}
p.prototype._getFixedTopRowContexts=function(){var i=this._getRowCounts();return i.fixedTop>0?this._getContexts(0,i.fixedTop,0,true):[];};
p.prototype._getFixedBottomRowContexts=function(){var i=this._getRowCounts();var l=M(this,true);if(i.fixedBottom>0&&i.count-i.fixedBottom<l){return this._getContexts(l-i.fixedBottom,i.fixedBottom,0,true);}else{return[];}};
p.prototype._getContexts=function(i,l,X,Y){var Z=this.getBinding();return Z?Z.getContexts(i,l,X,Y):[];};
p.prototype._adjustToTotalRowCount=function(){var i=this._getTotalRowCount();if(this._iBindingLength!==i){this._iBindingLength=i;this._updateFixedBottomRows();this._adjustFirstVisibleRowToTotalRowCount();T.Hook.call(this,H.TotalRowCountChanged);}};
p.prototype._adjustFirstVisibleRowToTotalRowCount=function(){var i=this.getFirstVisibleRow();var l=this._getMaxFirstVisibleRowIndex();if(l<i&&this._bContextsAvailable){this._setFirstVisibleRowIndex(l,{onlySetProperty:true});}};
p.prototype.refreshRows=function(i){this._bContextsAvailable=false;if(i===a.Sort||i===a.Filter){this.setFirstVisibleRow(0);}T.Hook.call(this,H.RefreshRows,i||T.RowsUpdateReason.Unknown);};
p.prototype.updateRows=function(i,l){if(this.bIsDestroyed||this._bIsBeingDestroyed){return;}if(l.detailedReason==="AddVirtualContext"){w(this);return;}else if(l.detailedReason==="RemoveVirtualContext"){x(this);return;}this._bContextsAvailable=true;if(i===a.Sort||i===a.Filter){this.setFirstVisibleRow(0);}this._adjustToTotalRowCount();y(this,i);};
function w(i){var l=i._getRowContexts(null,true)[0];x(i);i._oVirtualRow=i._getRowClone("virtual");i._oVirtualRow.setBindingContext(l,i.getBindingInfo("rows").model);i.addAggregation("_hiddenDependents",i._oVirtualRow);}
function x(i){if(i._oVirtualRow){i._oVirtualRow.destroy();delete i._oVirtualRow;}}
function y(i,l){if(i._bContextsAvailable){T.Hook.call(i,H.UpdateRows,l||T.RowsUpdateReason.Unknown);}}
p.prototype.insertRow=function(){L.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);return this;};
p.prototype.addRow=function(){L.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);return this;};
p.prototype.removeRow=function(){L.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);return null;};
p.prototype.removeAllRows=function(){L.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);return[];};
p.prototype.destroyRows=function(){L.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);return this;};
p.prototype.setCreationRow=function(i){if(!T.isA(i,"sap.ui.table.CreationRow")){i=null;}return this.setAggregation("creationRow",i);};
p.prototype.getCreationRow=function(){return this.getAggregation("creationRow");};
p.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};
p.prototype._attachEvents=function(){var $=this.$();var i=this.getId();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd."+i+" transitionend."+i,function(l){if(q(l.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);E.attachEvents(this);};
p.prototype._detachEvents=function(){var i=this.getId();q(document.body).off('webkitTransitionEnd.'+i+' transitionend.'+i);T.deregisterResizeHandler(this,"Table");D.resize.detachHandler(this._onWindowResize,this);E.detachEvents(this);};
p.prototype._cleanUpTimers=function(){var i;for(i in this._mTimeouts){if(this._mTimeouts[i]){window.clearTimeout(this._mTimeouts[i]);delete this._mTimeouts[i];}}for(i in this._mAnimationFrames){if(this._mAnimationFrames[i]){window.cancelAnimationFrame(this._mAnimationFrames[i]);delete this._mAnimationFrames[i];}}};
function z(i){var l=i.getDomRef();if(l){i.getDomRef().classList.toggle("sapUiTableEmpty",T.isNoDataVisible(i));i._getAccExtension().updateAriaStateForOverlayAndNoData();i._getKeyboardExtension().updateNoDataAndOverlayFocus();}}
p.prototype.removeColumn=function(i){i=this.removeAggregation("columns",i);if(i===null){return i;}if(!this._bReorderInProcess){var l=this._aSortedColumns.indexOf(i);if(l>=0){this._aSortedColumns.splice(l,1);}}J(this);return i;};
p.prototype.removeAllColumns=function(){var i=this.removeAllAggregation("columns");this._aSortedColumns=[];J(this);return i;};
p.prototype.destroyColumns=function(){var i=this.destroyAggregation("columns");this._aSortedColumns=[];J(this);return i;};
p.prototype.addColumn=function(i){this.addAggregation("columns",i);J(this);return this;};
p.prototype.insertColumn=function(i,l){this.insertAggregation("columns",i,l);J(this);return this;};
function J(i){i.invalidateRowsAggregation();i._invalidateComputedFixedColumnCount();var l=i.getCreationRow();if(l){l._update();}}
p.prototype._getTotalRowCount=function(){return M(this);};
function M(i,l){var X=i.getBinding();var Y=i.getBindingInfo("rows");if(!X){return 0;}if(Y.length!=null){return Y.length;}if(l===true){return X.getLength();}if(!i._bContextsAvailable){return _(i).iCachedBindingLength;}_(i).iCachedBindingLength=X.getLength();return _(i).iCachedBindingLength;}
p.prototype._getMaxFirstVisibleRowIndex=function(){var i;if(T.isVariableRowHeightEnabled(this)){i=this._getTotalRowCount()-1;}else{i=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,i);};
p.prototype._getMaxFirstRenderedRowIndex=function(){var i=this._getTotalRowCount()-this._getRowCounts().count;return Math.max(0,i);};
p.prototype._getFirstRenderedRowIndex=function(){return _(this).iFirstRenderedRowIndex;};
p.prototype._getVisibleColumns=function(){var X=[];var Y=this.getColumns();for(var i=0,l=Y.length;i<l;i++){if(Y[i].shouldRender()){X.push(Y[i]);}}return X;};
p.prototype._getColumnsWidth=function(X,Y){var Z=this.getColumns();var $=0;if(X!==0&&!X){X=0;}if(Y!==0&&!Y){Y=Z.length;}for(var i=X,l=Y;i<l;i++){if(Z[i]&&Z[i].shouldRender()){var a1=T.convertCSSSizeToPixel(Z[i].getWidth());if(a1==null){a1=T.Column.getMinColumnWidth();}$+=a1;}}return $;};
p.prototype._onTableResize=function(i){var l=i.oldSize.width;var X=i.size.width;if(this._bInvalid||!this.getDomRef()||l===X){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};
p.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);this._adjustOutlineOffset();}};
p.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout");}else{this.removeStyleClass("sapUiTableZoomout");}};
p.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(l){l.preventDefault();return false;});};
p.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart");};
p.prototype._findAndfireCellEvent=function(i,l,X){var $=q(l.target);var Y=$.closest(".sapUiTableDataCell");var Z=Y.attr("id");var a1=/.*-row(\d*)-col(\d*)/i.exec(Z);var b1=false;if(a1){var c1=a1[1];var d1=a1[2];var e1=this.getRows()[c1];var f1=e1&&e1.getCells()[d1];var g1=e1&&e1.getIndex();var h1=b.ofCell(f1).getId();var i1=e1.getRowBindingContext();var j1={rowIndex:g1,columnIndex:d1,columnId:h1,cellControl:f1,rowBindingContext:i1,cellDomRef:Y.get(0)};b1=!i.call(this,j1);if(!b1&&typeof X==="function"){j1.cellDomRef=Y[0];b1=X.call(this,j1);}}return b1;};
p.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();if(this.getShowOverlay()){return this.getDomRef("overlay");}if(T.isNoDataVisible(this)){return this.getDomRef("noDataCnt");}var i=this._oFocusInfo&&this._oFocusInfo.targetInfo&&T.isA(this._oFocusInfo.targetInfo,"sap.ui.core.message.Message");if(i&&this.getColumnHeaderVisible()){var l=this._getVisibleColumns()[0];if(l){return l.getDomRef();}}var X=T.getFocusedItemInfo(this);if(X&&X.domRef){return X.domRef;}return C.prototype.getFocusDomRef.apply(this,arguments);};
p.prototype.pushSortedColumn=function(i,l){if(!l){this._aSortedColumns=[];}if(this._aSortedColumns.indexOf(i)===-1){this._aSortedColumns.push(i);}};
p.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};
p.prototype.sort=function(l,X,Y){if(!l){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var Z=this.getBinding();if(Z){Z.sort();}this._aSortedColumns=[];}if(this.getColumns().indexOf(l)>=0){l.sort(X===o.Descending,Y);}};
p.prototype.filter=function(i,l){if(this.getColumns().indexOf(i)>=0){if(l==null){l="";}else if(typeof l!=="string"){throw new Error("The filter value is not a string");}i.filter(l);}};
p.prototype._updateSelection=function(){var l=this.getSelectionMode();if(l===m.None){return;}var X=this._getSelectionPlugin().getRenderConfig();var Y;var Z;var $=this.$("selall");var a1=this.getRows();for(var i=0;i<a1.length;i++){var b1=a1[i];b1._updateSelection();}if(!X.headerSelector.visible){return;}if(X.headerSelector.type==="toggle"){var c1=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!c1);this._getAccExtension().setSelectAllState(c1);Y=c1?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(X.headerSelector.type==="clear"){$.toggleClass("sapUiTableSelAllDisabled",!X.headerSelector.enabled);Y="TBL_DESELECT_ALL";if(X.headerSelector.enabled){$.removeAttr("aria-disabled");}else{$.attr("aria-disabled","true");}}if(Y){Z=T.getResourceText(Y);if(this._getShowStandardTooltips()){$.attr('title',Z);}else if(X.headerSelector.type==="toggle"){this.getDomRef("ariaselectall").innerText=Z;}}};
p.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};
p.prototype._onSelectionChanged=function(i){var l=this._getSelectionPlugin();var X=i.getParameter("rowIndices");var Y=i.getParameter("selectAll");var Z=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:l.getSelectedIndex();this._updateSelection();if(!this._hasSelectionPlugin()){this.setProperty("selectedIndex",l.getSelectedIndex(),true);this.fireRowSelectionChange({rowIndex:Z,rowContext:this.getContextByIndex(Z),rowIndices:X,selectAll:Y,userInteraction:this._iSourceRowIndex!==undefined});}};
p.prototype.getContextByIndex=function(i){var l=this.getBinding();return i>=0&&l?l.getContexts(i,1,0,true)[0]:null;};
p.prototype.getSelectedIndex=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndex();};
p.prototype.setSelectedIndex=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectedIndex(i);return this;};
p.prototype.clearSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.");}this._getSelectionPlugin().clearSelection();return this;};
p.prototype.selectAll=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.");}if(T.hasSelectAll(this)){this._getSelectionPlugin().selectAll();}return this;};
p.prototype.getSelectedIndices=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndices();};
p.prototype.addSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().addSelectionInterval(i,l);return this;};
p.prototype.setSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectionInterval(i,l);return this;};
p.prototype.removeSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().removeSelectionInterval(i,l);return this;};
p.prototype.isIndexSelected=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().isIndexSelected(i);};
p.prototype.setGroupBy=function(i){var l=i;var X=sap.ui.getCore().byId(this.getGroupBy());if(typeof l==="string"){l=sap.ui.getCore().byId(l);}var Y=false;if(l instanceof b&&l!==X){if(this.getColumns().indexOf(l)===-1){throw new Error("Column has to be part of the columns aggregation!");}var Z=this.fireGroup({column:l,groupedColumns:[l.getId()],type:G.group});if(X){X.setGrouped(false);Y=true;}if(Z&&this.getEnableGrouping()){l.setGrouped(true);}}if(!l||Y){if(X){X.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}this.setAssociation("groupBy",l);T.Grouping.setupExperimentalGrouping(this);return this;};
p.prototype.getBinding=function(i){return C.prototype.getBinding.call(this,i==null?"rows":i);};
p.prototype.setEnableGrouping=function(i){var l=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",i);if(l){l.setGrouped(i);}if(i){T.Grouping.setupExperimentalGrouping(this);}else{T.Grouping.resetExperimentalGrouping(this);}this._invalidateColumnMenus();return this;};
p.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};
p.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};
p.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};
p.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this._getSpanBasedComputedFixedColumnCount();};
p.prototype._getSpanBasedComputedFixedColumnCount=function(){if(_(this).iComputedFixedColumnCount===null){var l=this.getColumns();var X;var Y=this.getFixedColumnCount();for(var i=Y-1;i>=0;i--){X=l[i];if(X){Y=Math.max(Y,X.getIndex()+T.Column.getHeaderSpan(X));break;}}_(this).iComputedFixedColumnCount=Math.min(Y,l.length);}return _(this).iComputedFixedColumnCount;};
p.prototype.setFixedColumnCount=function(l){this.setProperty("fixedColumnCount",l);this._invalidateComputedFixedColumnCount();var X=this.getColumns();var Y;var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=this._getSpanBasedComputedFixedColumnCount()-1;i>=0;i--){Y=X[i];if(Y&&T.isVariableWidth(Y.getWidth())){Y._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+Y.getIndex()+"']").width();}}this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};
p.prototype.setFixedRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"fixedRowCount\" has no effect");return this.setProperty("fixedRowCount",i,true);}return this.setProperty("fixedRowCount",i);};
p.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"iFixedBottomRowCount\" has no effect");return this.setProperty("fixedBottomRowCount",i,true);}return this.setProperty("fixedBottomRowCount",i);};
p.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);return this;};
p.prototype._invalidateColumnMenus=function(){var X=this.getColumns();for(var i=0,l=X.length;i<l;i++){X[i].invalidateMenu();}};
p.prototype._isTouchEvent=function(i){return!!(i&&i.originalEvent&&i.originalEvent.touches);};
p.prototype._getRowClone=function(X){var Y=typeof X==="number";var Z=Y;var $=Z?this._aRowClones[X]:null;if($&&!$.bIsDestroyed){return $;}$=new R(this.getId()+"-rows"+"-row"+(Y?X:"-"+X));if(Z){this._aRowClones[X]=$;}var a1=this.getColumns();for(var i=0,l=a1.length;i<l;i++){if(a1[i].getVisible()){var b1=a1[i].getTemplateClone(i);if(b1){$.addCell(b1);}}}if(T.hasRowActions(this)){var c1=this.getRowActionTemplate().clone();$.setAggregation("_rowAction",c1,true);}var d1=this.getRowSettingsTemplate();if(d1){var e1=d1.clone();$.setAggregation("_settings",e1,true);}return $;};
p.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};
p.prototype._invalidateComputedFixedColumnCount=function(){_(this).iComputedFixedColumnCount=null;};
p.prototype._getBaseRowHeight=function(){var i=this._getRowMode().getBaseRowContentHeight();if(i>0){return i+T.RowHorizontalFrameSize;}else{return this._getDefaultRowHeight();}};
p.prototype._getDefaultRowHeight=function(){var i=T.getContentDensity(this);return T.DefaultRowHeight[i];};
p.prototype._getDefaultRowContentHeight=function(){var i=T.getContentDensity(this);return T.BaseSize[i];};
p.prototype.setNoData=function(i){var l=T.getNoDataText(this);this.setAggregation("noData",i,true);var X=T.getNoDataText(this);if(l!=null&&X!=null){if(l!==X){this.$("noDataMsg").text(X);}}else{this.invalidate();}return this;};
p.prototype.exportData=function(X){var Y=sap.ui.requireSync("sap/ui/core/util/Export");X=X||{};if(!X.rows){var Z=this.getBinding(),$=this.getBindingInfo("rows");var a1=Z.aFilters.concat(Z.aApplicationFilters);X.rows={path:$.path,model:$.model,sorter:Z.aSorters,filters:a1,parameters:$.parameters};}if(!X.exportType){var b1=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");X.exportType=new b1();}var c1=X.rows.model;if(!c1){var d1=X.rows.path;var e1=d1.indexOf(">");if(e1>0){c1=d1.substr(0,e1);}}if(!X.columns){X.columns=[];var f1=this.getColumns();for(var i=0,l=f1.length;i<l;i++){var g1=f1[i];if(g1.getSortProperty()){X.columns.push({name:g1.getLabel().getText(),template:{content:{path:g1.getSortProperty(),model:c1}}});}}}var h1=new Y(X);this.addDependent(h1);return h1;};
p.prototype._onPersoApplied=function(){var X=this.getColumns();var Y=[];for(var i=0,l=X.length;i<l;i++){var Z=X[i];if(Z.getSorted()){Y.push(new S(Z.getSortProperty(),Z.getSortOrder()===o.Descending));}}var $=this.getBinding();if($){if(Y.length>0){$.sort(Y);}}};
p.prototype._toggleSelectAll=function(){if(!T.hasData(this)||this.getSelectionMode()!==m.MultiToggle){return;}var i=this._getSelectionPlugin();if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;i.clearSelection();}else{this._iSourceRowIndex=0;i.selectAll();}this._iSourceRowIndex=undefined;};
p.prototype.setBusy=function(i){var l=this.getBusy();var X=C.prototype.setBusy.call(this,i,"sapUiTableGridCnt");var Y=this.getBusy();if(l!==Y){this.fireBusyStateChanged({busy:Y});}return X;};
p.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);if(this.getEnableBusyIndicator()){O(this);}else{this.setBusy(false);Q(this);}return this;};
p.prototype._onBindingDataRequested=function(){_(this).iPendingRequests++;O(this);};
p.prototype._onBindingDataReceived=function(){_(this).iPendingRequests--;O(this);};
p.prototype._hasPendingRequests=function(){return _(this).iPendingRequests>0;};
function O(i){if(!i.getEnableBusyIndicator()){return;}Q(i);if(i._hasPendingRequests()){i.setBusy(true);}else{_(i).hideBusyIndicatorTimeoutId=setTimeout(function(){i.setBusy(false);Q(i);},0);}}
function Q(i){clearTimeout(_(i).hideBusyIndicatorTimeoutId);delete _(i).hideBusyIndicatorTimeoutId;}
p.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};
p.prototype.setRowActionTemplate=function(i){this.setAggregation("rowActionTemplate",i);this.invalidateRowsAggregation();return this;};
p.prototype.setRowActionCount=function(i){if(typeof i==="number"){i=Math.max(0,Math.min(i,2));}return this.setProperty("rowActionCount",i);};
p.prototype.setRowSettingsTemplate=function(i){this.setAggregation("rowSettingsTemplate",i);this.invalidateRowsAggregation();return this;};
p.prototype.addPlugin=function(i){this.addAggregation("plugins",i);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};
p.prototype.insertPlugin=function(i,l){this.insertAggregation("plugins",i,l);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};
p.prototype.removePlugin=function(i){var l=this.removeAggregation("plugins",i);if(T.isA(l,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return l;};
p.prototype.removeAllPlugins=function(){var i=this.removeAllAggregation("plugins");this._initSelectionPlugin();return i;};
p.prototype.destroyPlugins=function(){this.destroyAggregation('plugins');this._initSelectionPlugin();return this;};
p.prototype.getPlugin=function(l){if(typeof l!=="string"){return null;}var X=this.getPlugins();for(var i=0;i<X.length;i++){if(X[i].isA(l)){return X[i];}}return null;};
p.prototype._getSelectionPlugin=function(){var i=this._oSelectionPlugin||this._oLegacySelectionPlugin;if(!i){this._initLegacySelectionPlugin();i=this._oLegacySelectionPlugin;}if(typeof this._getSelectedIndicesCount==="function"&&i.getSelectedCount!==this._getSelectedIndicesCount){i.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(function(l){i[l]=this[l];}.bind(this));}return i;};
p.prototype._hasSelectionPlugin=function(){return this._oSelectionPlugin!=null;};
p.prototype._initSelectionPlugin=function(){var i=this.getPlugin("sap.ui.table.plugins.SelectionPlugin");if(i){this._destroyLegacySelectionPlugin();if(i!==this._oSelectionPlugin){W(this,this._oSelectionPlugin);U(this,i);this._oSelectionPlugin=i;}}else{this._initLegacySelectionPlugin();W(this,this._oSelectionPlugin);delete this._oSelectionPlugin;}};
p.prototype._initLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin||this.getPlugin("sap.ui.table.plugins.SelectionPlugin")){return;}this._oLegacySelectionPlugin=this._createLegacySelectionPlugin();this.addAggregation("_hiddenDependents",this._oLegacySelectionPlugin);U(this,this._oLegacySelectionPlugin);};
p.prototype._destroyLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin){this._oLegacySelectionPlugin.destroy();delete this._oLegacySelectionPlugin;}};
p.prototype._createLegacySelectionPlugin=function(){return new k();};
function U(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.attachSelectionChange(i._onSelectionChanged,i);}}
function W(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.detachSelectionChange(i._onSelectionChanged,i);}}
p.prototype.insertAggregation=function(i,l,X,Y){if(i==="_hiddenDependents"){return C.prototype.insertAggregation.call(this,i,l,X,true);}return C.prototype.insertAggregation.apply(this,arguments);};
p.prototype.addAggregation=function(i,l,X){if(i==="_hiddenDependents"){return C.prototype.addAggregation.call(this,i,l,true);}return C.prototype.addAggregation.apply(this,arguments);};
p.prototype.removeAggregation=function(i,l,X){if(i==="_hiddenDependents"){return C.prototype.removeAggregation.call(this,i,l,true);}return C.prototype.removeAggregation.apply(this,arguments);};
p.prototype.removeAllAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.removeAllAggregation.call(this,i,true);}return C.prototype.removeAllAggregation.apply(this,arguments);};
p.prototype.destroyAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.destroyAggregation.call(this,i,true);}C.prototype.destroyAggregation.apply(this,arguments);if(i==="rows"){this._aRowClones.forEach(function(X){X.destroy();});this._aRowClones=[];}return this;};
p.prototype.getCellControl=function(i,l,X){var Y=T.getRowColCell(this,i,l,!X);return Y.cell;};
p.prototype._fireRowsUpdated=function(i){var l={reason:i||T.RowsUpdateReason.Unknown};this.onRowsUpdated(l);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(l);this.fireEvent("_rowsUpdated",l);this.fireRowsUpdated();}.bind(this),0);};
p.prototype.onRowsUpdated=function(i){T.Grouping.updateGroups(this);this._getAccExtension()._updateAriaRowIndices();this._updateSelection();z(this);this.getRows().forEach(function(l){l.getCells().forEach(function(X){var Y=b.ofCell(X);var Z=Y._getCellContentVisibilitySettings();var $=l.getDomRefs(true).row.find("td[data-sap-ui-colid=\""+Y.getId()+"\"]");var a1=true;if(!$){return;}if(l.isGroupHeader()){if(!l.isExpandable()){a1=Z.groupHeader.nonExpandable;}else if(l.isExpanded()){a1=Z.groupHeader.expanded;}else{a1=Z.groupHeader.collapsed;}}else if(l.isTotalSummary()){a1=Z.summary.total;}else if(l.isGroupSummary()){a1=Z.summary.group;}else{a1=Z.standard;}$.toggleClass("sapUiTableCellHidden",!a1);});});};
p.prototype.onRowsContentUpdated=function(i){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(i.reason);}};
p.prototype._enableSynchronization=function(){var i=this;return new Promise(function(l,X){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(Y){l(E.enrich(i,Y).getInterface());},function(Y){X(Y);});});};
p.prototype._enableLegacyMultiSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.");}this._legacyMultiSelection=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied");}var X=!!(l.metaKey||l.ctrlKey);if(!this.isIndexSelected(i)){if(X){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else if(X||this._getSelectionPlugin().getSelectedCount()===1){this.removeSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}.bind(this);};
p.prototype._setRowCountConstraints=function(i){this.setProperty("rowCountConstraints",i);};
return p;});
sap.ui.predefine('sap/ui/table/TablePersoController',["./library",'sap/ui/base/ManagedObject',"sap/ui/core/syncStyleClass","sap/base/Log","sap/ui/thirdparty/jquery",'./utils/TableUtils'],function(L,M,s,a,q,T){"use strict";var R=L.ResetAllMode;
var b=M.extend("sap.ui.table.TablePersoController",{
constructor:function(i,S){M.apply(this,arguments);},
metadata:{properties:{"autoSave":{type:"boolean",defaultValue:true},"persoService":{type:"any"},"customDataKey":{type:"string",defaultValue:"persoKey"},"showResetAll":{type:"boolean",defaultValue:true,since:"1.88"},"resetAllMode":{type:"sap.ui.table.ResetAllMode",defaultValue:R.Default,since:"1.88"}},associations:{"table":{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}
});
b.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue");}};
b.prototype.setResetAllMode=function(r){if(!this._resetAllModeSet){this.setProperty("resetAllMode",r);this._resetAllModeSet=true;}else{a.warning("resetAllMode of the TablePersoController can only be set once.");}};
b.prototype.exit=function(){var t=this._getTable();if(t){this._manageTableEventHandlers(t,false);}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;if(this._oDialog){this._oDialog.destroy();delete this._oDialog;}};
b.prototype.setPersoService=function(S){S=this.validateProperty("persoService",S);if(S&&(typeof S.getPersData!=="function"||typeof S.setPersData!=="function"||typeof S.delPersData!=="function")){throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods "+"\"getPersData\", \"setPersData\" and \"delPersData\".");}var o=this.getPersoService();this.setProperty("persoService",S,true);var n=this.getPersoService();if(n&&n!==o&&this._getTable()&&(this.getAutoSave()||!o)){this.refresh();}return this;};
b.prototype.setAutoSave=function(A){var o=this.getAutoSave();this.setProperty("autoSave",A,true);var n=this.getAutoSave();if(n&&!o){this.savePersonalizations();}return this;};
b.prototype.setTable=function(t){var o=this._getTable();if(o){o._oPersoController=undefined;}this.setAssociation("table",t,true);var n=this._getTable();if(n){n._oPersoController=this;}if(o){this._manageTableEventHandlers(o,false);}if(n&&n!==o){if(this.getResetAllMode()===R.Default){this._oInitialPersoData=this._getCurrentTablePersoData(true);}this._manageTableEventHandlers(n,true);if(this.getPersoService()&&(this.getAutoSave()||!o)){this.refresh();}}else if(!n){this._oInitialPersoData=null;}return this;};
b.prototype.setCustomDataKey=function(c){var o=this.getCustomDataKey();this.setProperty("customDataKey",c,true);var n=this.getCustomDataKey();if(this.getResetAllMode()===R.Default&&this._getTable()){this._oInitialPersoData=this._getCurrentTablePersoData(true);}if(o!==n&&this.getAutoSave()){this.savePersonalizations();}return this;};
b.prototype._manageTableEventHandlers=function(t,A){for(var i=0,l=this._aTableEvents.length;i<l;i++){var f=t[(A?"attachEvent":"detachEvent")];f.apply(t,[this._aTableEvents[i],this._tableEventHandler,this]);}};
b.prototype.refresh=function(){var t=this;var S=this.getPersoService();if(S){return S.getPersData().done(function(o){var D=(o&&Array.isArray(o.aColumns))?o:t._oInitialPersoData;t._adjustTable(D);if(t.getResetAllMode()===R.ServiceDefault){t._oInitialPersoData=t._getCurrentTablePersoData(true);}}).fail(function(){a.error("Problem reading persisted personalization data.");});}else{a.error("The Personalization Service is not available!");var d=q.Deferred();d.reject();return d.promise();}};
b.prototype.savePersonalizations=function(){var S=this.getPersoService();if(S){var d=this._getCurrentTablePersoData();d[this._schemaProperty]=this._schemaVersion;return S.setPersData(d).fail(function(){a.error("Problem persisting personalization data.");});}else{a.error("The Personalization Service is not available!");var D=q.Deferred();D.reject();return D.promise();}};
b.prototype._adjustTable=function(d){var t=this._getTable();if(!t||!d||!Array.isArray(d.aColumns)){return;}var c={},C=t.getColumns();for(var i=0,l=C.length;i<l;i++){c[this._getColumnPersoKey(C[i])]=C[i];}var e=d.aColumns;for(var i=0,l=e.length;i<l;i++){var o=e[i];var f=c[o.id];if(f){if(t.indexOfColumn(f)!==o.order){t.removeColumn(f);t.insertColumn(f,o.order);}var m=f.getMetadata();for(var j=0,g=this._aColumnProperties.length;j<g;j++){var p=this._aColumnProperties[j];if(o[p]!==undefined){try{if(m.hasProperty(p)&&f.getProperty(p)!=o[p]){f.setProperty(p,o[p]);}}catch(h){a.error("sap.ui.table.TablePersoController: failed to apply the value \""+f[p]+"\" for the property + \""+p+"\".");}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied();}};
b.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null;},0);}};
b.prototype._getCurrentTablePersoData=function(f){var t=this._getTable(),c=t.getColumns();var d={aColumns:[]};for(var i=0,l=c.length;i<l;i++){var C=c[i];var p=this._getColumnPersoKey(C);var o={id:p,order:i};var m=C.getMetadata();for(var j=0,e=this._aColumnProperties.length;j<e;j++){var P=this._aColumnProperties[j];if(m.hasProperty(P)){o[P]=C.getProperty(P);}}if(f){o.text=T.Column.getHeaderText(t,i)||p;}d.aColumns.push(o);}return d;};
b.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable());};
b.prototype._getColumnPersoKey=function(c){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(c);};
b.prototype._getPersoKey=function(c){var p=c.data(this.getCustomDataKey());if(!p){p=c.getId();if(p.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())===0){a.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \""+c.getId()+"\")");}}return p;};
b.prototype.openDialog=function(S){var t=this;function _(){if(t._oDialog){s("sapUiSizeCompact",t._getTable(),t._oDialog._oDialog);t._oDialog.open();}}if(!this._oDialog){sap.ui.getCore().loadLibrary("sap.m",{async:true}).then(function(){sap.ui.require(["sap/m/TablePersoDialog"],function(c){t._oDialog=new c(t._getTable().getId()+"-PersoDialog",{persoService:t.getPersoService(),showSelectAll:true,showResetAll:(S&&S.showResetAll)||t.getShowResetAll(),hasGrouping:false,contentWidth:S&&S.contentWidth,contentHeight:S&&S.contentHeight||"20rem",initialColumnState:t._oInitialPersoData.aColumns,columnInfoCallback:function(o,p,P){return t._getCurrentTablePersoData(true).aColumns;},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations();}}});t._oDialog._oDialog.addStyleClass("sapUiNoContentPadding");if(t.getResetAllMode()===R.ServiceReset&&t.getPersoService().getResetPersData){t._oDialog.setShowResetAll(false);t.getPersoService().getResetPersData().done(function(r){if(this._bIsBeingDestroyed){return;}if(r){t._oDialog.setInitialColumnState(r.aColumns);t._oDialog.setShowResetAll(t.getShowResetAll());}});}_();});});}else{_();}};
return b;});
sap.ui.predefine('sap/ui/table/TableRenderer',['sap/ui/core/Control','sap/ui/Device','./library',"./Column",'./utils/TableUtils',"./extensions/ExtensionBase",'sap/ui/core/Renderer','sap/ui/core/IconPool',"sap/base/Log"],function(C,D,a,b,T,E,R,I,L){"use strict";var V=a.VisibleRowCountMode;var S=a.SortOrder;var c=T.Column;var f={Begin:"flex-start",End:"flex-end",Left:undefined,Right:undefined,Center:"center"};var d={apiVersion:2};
d.render=function(r,t){delete t._iHeaderRowCount;f.Left=t._bRtlMode?"flex-end":"flex-start";f.Right=t._bRtlMode?"flex-start":"flex-end";T.getResourceBundle();r.openStart("div",t);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.class("sapUiTable");if(D.browser.chrome&&window.devicePixelRatio<1){r.class("sapUiTableZoomout");}if('ontouchstart'in document){r.class("sapUiTableTouch");}r.class("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.class("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.class("sapUiTableRowSelectors");}if(T.hasRowHighlights(t)){r.class("sapUiTableRowHighlights");}var s=a.TableHelper.addTableClass();if(s){r.class(s);}var o=t._getScrollExtension();if(o.isVerticalScrollbarRequired()&&!o.isVerticalScrollbarExternal()){r.class("sapUiTableVScr");}if(t.getEditable()){r.class("sapUiTableEdt");}if(T.hasRowActions(t)){var i=t.getRowActionCount();r.class(i==1?"sapUiTableRActS":"sapUiTableRAct");}else if(T.hasRowNavigationIndicators(t)){r.class("sapUiTableRowNavIndicator");}if(T.isNoDataVisible(t)&&!t._hasPendingRequests()){r.class("sapUiTableEmpty");}if(t.getShowOverlay()){r.class("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.class(m);}r.style("width",t.getWidth());t._getRowMode().applyTableStyles(r);if(t._bFirstRendering){r.class("sapUiTableNoOpacity");}r.openEnd();this.renderTabElement(r,"sapUiTableOuterBefore");r.openStart("div",t.getId()+"-before");r.openEnd();r.renderControl(t.getAggregation("_messageStrip"));if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.close("div");r.openStart("div",t.getId()+"-sapUiTableCnt");r.class("sapUiTableCnt");r.attr("data-sap-ui-fastnavgroup","true");r.attr("data-sap-ui-pasteregion","true");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTAINER");r.openEnd();r.openStart("div",t.getId()+"-sapUiTableGridCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.openEnd();this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);r.close("div");var e=t.getCreationRow();if(e&&e.getVisible()){r.renderControl(e);this.renderHSbBackground(r,t);this.renderHSb(r,t);}t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.openStart("div",t.getId()+"-overlay");r.class("sapUiTableOverlayArea");r.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.openEnd();r.close("div");r.close("div");r.openStart("div",t.getId()+"-after");r.openEnd();if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderBottomPlaceholder(r,t);r.close("div");this.renderTabElement(r,"sapUiTableOuterAfter");r.close("div");};
d.renderHeader=function(r,t,o){r.openStart("div");r.class("sapUiTableHdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.openEnd();r.renderControl(o);r.close("div");};
d.renderToolbar=function(r,t,o){if(!T.isA(o,"sap.ui.core.Toolbar")){return;}r.openStart("div");r.class("sapUiTableTbr");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}if(o.isA("sap.m.Toolbar")){o.setDesign("Transparent",true);o.addStyleClass("sapMTBHeader-CTX");r.class("sapUiTableMTbr");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.openEnd();r.renderControl(o);r.close("div");};
d.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};
d.renderExtension=function(r,t,e){r.openStart("div");r.class("sapUiTableExt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.openEnd();r.renderControl(e);r.close("div");};
d.renderTable=function(r,t){var h=t.getRows().length>0;this.renderTabElement(r,"sapUiTableCtrlBefore",h?"0":"-1");r.openStart("div",t.getId()+"-tableCCnt");t._getRowMode().applyRowContainerStyles(r);r.class("sapUiTableCCnt");r.openEnd();this.renderTableCCnt(r,t);r.close("div");this.renderTabElement(r,"sapUiTableCtrlAfter",h?"0":"-1");this.renderTabElement(r,null,"-1",t.getId()+"-focusDummy");var o=t.getCreationRow();if(!o||!o.getVisible()){this.renderHSbBackground(r,t);this.renderHSb(r,t);}};
d.renderTableCCnt=function(r,t){this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderRowActions(r,t);if(!t._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSb(r,t);}r.openStart("div",t.getId()+"-noDataCnt");r.class("sapUiTableCtrlEmpty");r.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.openEnd();if(t.getNoData()instanceof C&&t._getVisibleColumns().length>0){r.renderControl(t.getNoData());}else{r.openStart("span",t.getId()+"-noDataMsg");r.class("sapUiTableCtrlEmptyMsg");r.openEnd();r.text(T.getNoDataText(t));r.close("span");}r.close("div");};
d.renderFooter=function(r,t,F){r.openStart("div");r.class("sapUiTableFtr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.openEnd();r.renderControl(F);r.close("div");};
d.renderVariableHeight=function(r,t){r.openStart("div",t.getId()+"-sb");r.attr("tabindex","-1");r.class("sapUiTableHeightResizer");r.style("height","5px");r.openEnd();r.close("div");};
d.renderBottomPlaceholder=function(r,t){var p=t._getRowMode().getTableBottomPlaceholderStyles();if(p===undefined){return;}r.openStart("div",t.getId()+"-placeholder-bottom");r.class("sapUiTablePlaceholder");t._getRowMode().applyTableBottomPlaceholderStyles(r);r.openEnd();r.close("div");};
d.renderColHdr=function(r,t){var n=T.getHeaderRowCount(t);var e=t.getColumns();var F=t.getComputedFixedColumnCount();r.openStart("div");r.class("sapUiTableColHdrCnt");r.openEnd();this.renderColRowHdr(r,t);if(F>0){r.openStart("div");r.class("sapUiTableCHA");r.class("sapUiTableCtrlScrFixed");r.class("sapUiTableNoOpacity");r.openEnd();this.renderTableControlCnt(r,t,true,0,F,true,false,0,n,true);r.close("div");}r.openStart("div",t.getId()+"-sapUiTableColHdrScr");r.class("sapUiTableCHA");r.class("sapUiTableCtrlScr");if(e.length==0){r.class("sapUiTableHasNoColumns");}if(F>0){if(t._bRtlMode){r.style("margin-right","0");}else{r.style("margin-left","0");}}r.openEnd();this.renderTableControlCnt(r,t,false,F,e.length,false,false,0,n,true);r.close("div");r.openStart("div");r.class("sapUiTableVSbHeader");r.openEnd();r.close("div");if(T.hasRowActions(t)){r.openStart("div",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWACTIONHEADER");r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableRowActionHeaderCell");r.openEnd();r.openStart("span");r.openEnd();r.text(T.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));r.close("span");r.close("div");}r.close("div");};
d.renderColRowHdr=function(r,t){var e=false;var s=false;var m=t._getSelectionPlugin().getRenderConfig();r.openStart("div",t.getId()+"-selall");r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableRowSelectionHeaderCell");var g;if(m.headerSelector.visible){var A=T.areAllRowsSelected(t);if(m.headerSelector.type==="toggle"){g=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(m.headerSelector.type==="clear"){g="TBL_DESELECT_ALL";if(!m.headerSelector.enabled){r.class("sapUiTableSelAllDisabled");r.attr("aria-disabled","true");}}if(t._getShowStandardTooltips()&&g){r.attr("title",T.getResourceText(g));}if(!A){r.class("sapUiTableSelAll");}else{s=true;}r.class("sapUiTableSelAllVisible");e=true;}r.attr("tabindex","-1");var p={enabled:e,checked:s};t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",p);r.openEnd();if(m.headerSelector.visible){if(m.headerSelector.type==="clear"&&m.headerSelector.icon){r.renderControl(m.headerSelector.icon);}else{r.openStart("div");r.class("sapUiTableSelectAllCheckBox");r.openEnd();r.close("div");}}r.close("div");};
d.renderCol=function(r,t,o,h,n,i,e,g,j){var l,k=!n,m=o.getIndex(),p=o.getMultiLabels();if(p.length>0){l=p[h];}else if(h==0){l=o.getLabel();}var H=o.getId();if(h===0){r.openStart("td",o);}else{H=H+"_"+h;r.openStart("td",H);}r.attr('data-sap-ui-related',o.getId());r.attr('data-sap-ui-colid',o.getId());r.attr("data-sap-ui-colindex",m);r.attr("tabindex","-1");var A={column:o,headerId:H,index:m};if(n>1){r.attr("colspan",n);A.colspan=true;}if(j){var F=o.getFiltered();var s=o.getSorted();if(F){r.class("sapUiTableColFiltered");}if(s){r.class("sapUiTableColSorted");if(o.getSortOrder()===S.Descending){r.class("sapUiTableColSortedD");}}}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",A);r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableHeaderDataCell");if(t.getEnableColumnReordering()||t.hasListeners("columnSelect")||o._menuHasItems()){r.class("sapUiTableHeaderCellActive");}if(i){r.class("sapUiTableCellFirst");}if(e){r.class("sapUiTableCellLastFixed");}if(g){r.class("sapUiTableCellLast");}if(k){r.class("sapUiTableHidden");}if(t.getColumnHeaderHeight()>0){r.style("height",t.getColumnHeaderHeight()+"px");}var q=o.getTooltip_AsString();if(q){r.attr("title",q);}r.openEnd();r.openStart("div",H+"-inner");r.class("sapUiTableCellInner");var u=o.getHAlign();var v=R.getTextAlign(u);if(v){r.style("text-align",v);}r.openEnd();r.openStart("div");r.style("justify-content",f[u]);r.openEnd();if(l){r.renderControl(l);}r.close("div");r.close("div");r.close("td");};
d.renderColRsz=function(r,t){r.openStart("div",t.getId()+"-rsz");r.class("sapUiTableColRsz");r.openEnd();r.close("div");};
d.renderRowHdr=function(r,t){r.openStart("div",t.getId()+"-sapUiTableRowHdrScr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.class("sapUiTableRowHdrScr");r.class("sapUiTableNoOpacity");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.openEnd();for(var e=0,g=t.getRows().length;e<g;e++){this.renderRowAddon(r,t,t.getRows()[e],e,true);}r.close("div");};
d.renderRowActions=function(r,t){if(!T.hasRowActions(t)&&!T.hasRowNavigationIndicators(t)){return;}r.openStart("div",t.getId()+"-sapUiTableRowActionScr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");T.hasRowActions(t)?r.class("sapUiTableRowWithAction"):r.class("sapUiTableRowActionScr");r.class("sapUiTableNoOpacity");r.openEnd();for(var e=0,g=t.getRows().length;e<g;e++){this.renderRowAddon(r,t,t.getRows()[e],e,false);}r.close("div");};
d.addRowCSSClasses=function(r,t,i){var m=t._getRowCounts();var F=T.getFirstFixedBottomRowIndex(t);if(i===0){r.class("sapUiTableFirstRow");}else if(i===t.getRows().length-1){r.class("sapUiTableLastRow");}if(m.fixedTop>0){if(i==m.fixedTop-1){r.class("sapUiTableRowLastFixedTop");}if(i==m.fixedTop){r.class("sapUiTableRowFirstScrollable");}}if(F>=0&&F===i){r.class("sapUiTableRowFirstFixedBottom");}else if(F>=1&&F-1===i){r.class("sapUiTableRowLastScrollable");}};
d.renderRowAddon=function(r,t,o,i,h){var e=t._getSelectionPlugin().isIndexSelected(o.getIndex());r.openStart("div");var g=o.getAggregation("_settings");var p={index:i,rowHidden:o.isEmpty(),rowNavigated:g?g.getNavigated():false};t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",p);r.attr("data-sap-ui-related",o.getId());r.attr("data-sap-ui-rowindex",i);r.class("sapUiTableRow");r.class("sapUiTableContentRow");if(o.isContentHidden()){r.class("sapUiTableRowHidden");}else if(e){r.class("sapUiTableRowSel");}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isInTreeMode(t)){r.class("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.openEnd();r.openStart("div",t.getId()+(h?"-rowsel":"-rowact")+i);r.class("sapUiTableCell");r.class("sapUiTableContentCell");r.class(h?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");t._getRowMode().renderRowStyles(r);r.attr("tabindex","-1");p={rowSelected:e,rowHidden:o.isEmpty()};t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"ROWHEADER":"ROWACTION",p);r.openEnd();if(h){this.writeRowHighlightContent(r,t,o,i);this.writeRowSelectorContent(r,t,o,i);}else{var A=o.getRowAction();if(A){r.renderControl(A);}this.writeRowNavigationContent(r,t,o,i);}r.close("div");r.close("div");};
d.renderTableCtrl=function(r,t){if(t.getComputedFixedColumnCount()>0){r.openStart("div",t.getId()+"-sapUiTableCtrlScrFixed");r.class("sapUiTableCtrlScrFixed");r.openEnd();this.renderTableControl(r,t,true);r.close("div");}r.openStart("div",t.getId()+"-sapUiTableCtrlScr");r.class("sapUiTableCtrlScr");if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){r.style("margin-right","0");}else{r.style("margin-left","0");}}r.openEnd();r.openStart("div",t.getId()+"-tableCtrlCnt");r.class("sapUiTableCtrlCnt");r.openEnd();this.renderTableControl(r,t,false);r.close("div");r.close("div");};
d.renderTableControl=function(r,t,F){var s,e;if(F){s=0;e=t.getComputedFixedColumnCount();}else{s=t.getComputedFixedColumnCount();e=t.getColumns().length;}var m=t._getRowCounts();var g=t.getRows();if(m.fixedTop>0){this.renderTableControlCnt(r,t,F,s,e,true,false,0,m.fixedTop);}this.renderTableControlCnt(r,t,F,s,e,false,false,m.fixedTop,g.length-m.fixedBottom);if(m.fixedBottom>0&&g.length>0){this.renderTableControlCnt(r,t,F,s,e,false,true,g.length-m.fixedBottom,g.length);}};
d.renderTableControlCnt=function(r,t,F,s,e,g,h,i,j,H){var k=H?"-header":"-table";var l=t.getId()+k;var m=[];if(F){l+="-fixed";m.push("sapUiTableCtrlFixed");}else{m.push("sapUiTableCtrlScroll");}if(g){l+="-fixrow";m.push("sapUiTableCtrlRowFixed");}else if(h){l+="-fixrow-bottom";m.push("sapUiTableCtrlRowFixedBottom");}else{m.push("sapUiTableCtrlRowScroll");}r.openStart("table",l);m.forEach(function(M){r.class(M);});t._getAccRenderExtension().writeAriaAttributesFor(r,t,H?"COLUMNHEADER_TABLE":"TABLE");r.class("sapUiTableCtrl");if(H){r.class("sapUiTableCHT");}r.style(F?"width":"min-width",t._getColumnsWidth(s,e)+"px");r.openEnd();r.openStart("thead").openEnd();r.openStart("tr");r.class("sapUiTableCtrlCol");if(i==0){r.class("sapUiTableCtrlFirstCol");}if(H){r.class("sapUiTableCHTHR");}r.openEnd();var n=t.getColumns();var o=new Array(e);var p;var q;var u=!F&&e>s;for(p=s;p<e;p++){q=n[p];var v={shouldRender:!!(q&&q.shouldRender())};if(v.shouldRender){var w=q.getWidth();if(T.isVariableWidth(w)){u=false;if(F){q._iFixWidth=q._iFixWidth||160;w=q._iFixWidth+"px";}}else if(F){delete q._iFixWidth;}v.width=w;}o[p]=v;}if(n.length===0){r.openStart("th").openEnd().close("th");}for(p=s;p<e;p++){k=H?"_hdr":"_col";q=n[p];v=o[p];if(v.shouldRender){if(i==0){r.openStart("th",t.getId()+k+p);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:q});}else{r.openStart("th");}r.style("width",v.width);r.attr("data-sap-ui-headcolindex",p);r.attr("data-sap-ui-colid",q.getId());r.openEnd();if(i==0&&T.getHeaderRowCount(t)==0&&!H){if(q.getMultiLabels().length>0){r.renderControl(q.getMultiLabels()[0]);}else{r.renderControl(q.getLabel());}}r.close("th");}}if(u){r.openStart("th",H&&t.getId()+"-dummycolhdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd().close("th");}r.close("tr");r.close("thead");r.openStart("tbody").openEnd();var x=t._getVisibleColumns();var y=t.getRows();var z;var A;if(H){for(z=i,A=j;z<A;z++){this.renderColumnHeaderRow(r,t,z,F,s,e,u,z===A-1);}}else{var B=t._getAccExtension().getAriaTextsForSelectionMode(true);var G=T.isRowSelectionAllowed(t);var J=t.getDragDropConfig().some(function(M){return M.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&M.getSourceAggregation()==="rows";});var K=this.getLastFixedColumnIndex(t);for(z=i,A=j;z<A;z++){this.renderTableRow(r,t,y[z],z,F,s,e,false,x,K,u,B,G,J);}}r.close("tbody");r.close("table");};
d.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isInGroupMode(t)){r.openStart("div");r.class("sapUiTableGroupShield");r.openEnd();r.close("div");r.openStart("div",o.getId()+"-groupHeader");r.class("sapUiTableGroupIcon");r.openEnd();r.close("div");if(T.Grouping.showGroupMenuButton(t)){var e=I.getIconInfo("sap-icon://drop-down-list");r.openStart("div").class("sapUiTableGroupMenuButton").openEnd();r.text(e.content);r.close("div");}}};
d.writeRowHighlightContent=function(r,t,o,i){if(!T.hasRowHighlights(t)){return;}var e=o.getAggregation("_settings");var h=e._getHighlightCSSClassName();r.openStart("div",o.getId()+"-highlight");r.class("sapUiTableRowHighlight");r.class(h);r.openEnd();t._getAccRenderExtension().writeAccRowHighlightText(r,t,o,i);r.close("div");};
d.writeRowNavigationContent=function(r,t,o,i){if(!T.hasRowNavigationIndicators(t)){return;}var e=o.getAggregation("_settings");r.openStart("div",o.getId()+"-navIndicator");if(e.getNavigated()){r.class("sapUiTableRowNavigated");}r.openEnd();r.close("div");};
d.renderColumnHeaderRow=function(r,t,i,F,s,e,h,l){r.openStart("tr");r.class("sapUiTableRow");r.class("sapUiTableHeaderRow");r.class("sapUiTableColHdrTr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.openEnd();var g=this.getColumnsToRender(t,s,e),n=0,j=-1;function k(o,p,q){var u=c.getHeaderSpan(o,i),v;if(n<1){if(u>1){v=o.getIndex();u=q.slice(p+1,p+u).reduce(function(w,x){return x.getIndex()-v<u?w+1:w;},1);}o._nSpan=n=u;j=p;}else{o._nSpan=0;}n--;}g.forEach(k);function m(o,p){this.renderCol(r,t,o,i,o._nSpan,p===0,F&&(p==j),!F&&(p==j),o._nSpan===1&&!o._bIconsRendered);o._bIconsRendered=o._bIconsRendered||o._nSpan===1;delete o._nSpan;if(l){delete o._bIconsRendered;}}g.forEach(m.bind(this));if(!F&&h&&g.length>0){r.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd().close("td");}r.close("tr");};
d.renderTableRow=function(r,t,o,i,F,s,e,g,v,l,h,m,j,k){if(!o){return;}var n=t._getSelectionPlugin();if(F){r.openStart("tr",o.getId()+"-fixed");r.attr("data-sap-ui-related",o.getId());}else{r.openStart("tr",o);}if(o._bDummyRow){r.style("opacity","0");}r.class("sapUiTableRow");r.class("sapUiTableContentRow");r.class("sapUiTableTr");if(o.isContentHidden()){r.class("sapUiTableRowHidden");}else{if(k&&F){r.attr("draggable",true);}if(n.isIndexSelected(o.getIndex())){r.class("sapUiTableRowSel");}}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isInTreeMode(t)){r.class("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.attr("data-sap-ui-rowindex",i);t._getRowMode().renderRowStyles(r);var p=o.getAggregation("_settings");var P={index:i,rowHidden:o.isEmpty(),rowNavigated:p?p.getNavigated():false};t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",P);r.openEnd();var q=!o.isEmpty()&&n.isIndexSelected(o.getIndex());var u=o.getCells();for(var w=0,x=u.length;w<x;w++){this.renderTableCell(r,t,o,u[w],w,F,s,e,v,l,q);}if(!F&&h&&u.length>0){r.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd();r.close("td");}r.close("tr");};
d.renderTableCell=function(r,t,o,e,i,F,s,g,v,l,h){var j=b.ofCell(e);var k=j.getIndex();if(j.shouldRender()&&s<=k&&g>k){var m=o.getId()+"-col"+i;r.openStart("td",m);r.attr("tabindex","-1");r.attr("data-sap-ui-colid",j.getId());var n=v.length;var p=n>0&&v[0]===j;var q=n>0&&v[n-1]===j;var u=F&&l===k;var P={index:k,column:j,row:o,fixed:F,rowSelected:h};t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",P);var w=R.getTextAlign(j.getHAlign());if(w){r.style("text-align",w);}r.class("sapUiTableCell");r.class("sapUiTableContentCell");r.class("sapUiTableDataCell");if(p){r.class("sapUiTableCellFirst");}if(u){r.class("sapUiTableCellLastFixed");}if(q){r.class("sapUiTableCellLast");}if(p&&T.Grouping.isInTreeMode(t)){r.class("sapUiTableCellFlex");}r.openEnd();r.openStart("div");r.class("sapUiTableCellInner");t._getRowMode().renderCellContentStyles(r);r.openEnd();this.renderTableCellControl(r,t,e,p);r.close("div");r.close("td");}};
d.renderTableCellControl=function(r,t,o,i){if(i&&T.Grouping.isInTreeMode(t)){var e=o.getParent();r.openStart("span",e.getId()+"-treeicon");r.class("sapUiTableTreeIcon");r.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:e});r.openEnd();r.close("span");}r.renderControl(o);};
d.renderVSb=function(r,t,m){var s=t._getScrollExtension();var e=t._getRowCounts();m=Object.assign({tabIndex:true},m);r.openStart("div");r.class("sapUiTableVSbContainer");if(!s.isVerticalScrollbarRequired()){r.class("sapUiTableHidden");}r.class(m.cssClass);r.openEnd();r.openStart("div",t.getId()+"-vsb");r.class("sapUiTableVSb");r.style("max-height",s.getVerticalScrollbarHeight()+"px");if(e.fixedTop>0){r.style("top",e.fixedTop*t._getBaseRowHeight()-1+"px");}if(m.tabIndex){r.attr("tabindex","-1");}r.openEnd();r.openStart("div");r.class("sapUiTableVSbContent");r.style("height",s.getVerticalScrollHeight()+"px");r.openEnd();r.close("div");r.close("div");r.close("div");};
d.renderVSbExternal=function(r,t){if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderVSb(r,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};
d.renderHSb=function(r,t,m){m=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},m);r.openStart("div",m.id);r.class(m.cssClass);if(m.hidden){r.class("sapUiTableHidden");}if(m.tabIndex){r.attr("tabindex","-1");}r.openEnd();r.openStart("div",m.id+"-content");r.class("sapUiTableHSbContent");if(m.scrollWidth>0){r.style("width",m.scrollWidth+"px");}r.openEnd();r.close("div");r.close("div");};
d.renderHSbExternal=function(r,t,i,s){if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderHSb(r,t,{id:i,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:s});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};
d.renderHSbBackground=function(r,t){r.openStart("div",t.getId()+"-hsb-bg");r.class("sapUiTableHSbBg");r.openEnd().close("div");};
d.renderTabElement=function(r,s,t,i){r.openStart("div");if(s){r.class(s);}if(i){r.attr("id",i);}r.attr("tabindex",t==null?"0":t);r.openEnd().close("div");};
d.getColumnsToRender=function(t,s,e){return t.getColumns().slice(s,e).filter(function(o){return o&&o.shouldRender();});};
d.getLastFixedColumnIndex=function(t){var F=t.getComputedFixedColumnCount();var e=t.getColumns();var o,l;for(var i=F-1;i>=0;i--){o=e[i];if(o.shouldRender()){l=i;break;}}return l;};
return d;},true);
sap.ui.predefine('sap/ui/table/TreeTable',['./Table',"./TableRenderer",'sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./library','./utils/TableUtils',"./plugins/BindingSelection","sap/base/Log","sap/base/assert"],function(T,c,C,d,l,e,B,L,f){"use strict";var _=e.createWeakMapFacade();
var g=T.extend("sap.ui.table.TreeTable",{
metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false,deprecated:true},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},rootLevel:{type:"int",group:"Data",defaultValue:0,deprecated:true}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},
renderer:"sap.ui.table.TableRenderer"
});
g.prototype.init=function(){T.prototype.init.apply(this,arguments);_(this).bPendingRequest=false;e.Grouping.setToDefaultTreeMode(this);e.Hook.register(this,e.Hook.Keys.Row.UpdateState,u,this);e.Hook.register(this,e.Hook.Keys.Row.Expand,h,this);e.Hook.register(this,e.Hook.Keys.Row.Collapse,j,this);};
g.prototype._bindRows=function(b){_(this).bPendingRequest=false;if(!b.parameters){b.parameters={};}if(!("rootLevel"in b.parameters)){b.parameters.rootLevel=this.getRootLevel();}if(!("collapseRecursive"in b.parameters)){b.parameters.collapseRecursive=this.getCollapseRecursive();}if(!("numberOfExpandedLevels"in b.parameters)){b.parameters.numberOfExpandedLevels=this.getExpandFirstLevel()?1:0;}return T.prototype._bindRows.call(this,b);};
function u(s){var b=this.getBinding();var n=s.context;s.context=n.context;if(!s.context){return;}s.level=n.level+1;if(b.nodeHasChildren){s.expandable=b.nodeHasChildren(n);}else{s.expandable=b.hasChildren(n.context);}s.expanded=n.nodeState.expanded;if(e.Grouping.isInGroupMode(this)){var H=this.getGroupHeaderProperty();if(H){s.title=s.context.getProperty(H);}if(s.expandable){s.type=s.Type.GroupHeader;s.contentHidden=true;}}}
function h(r){var i=r.getIndex();var I=t(this,i,true);if(typeof I==="boolean"){this._onGroupHeaderChanged(i,I);}}
function j(r){var i=r.getIndex();var I=t(this,i,false);if(typeof I==="boolean"){this._onGroupHeaderChanged(i,I);}}
function t(o,r,E){var I=[];var n=o.getBinding();if(!n||r==null){return null;}if(typeof r==="number"){I=[r];}else if(Array.isArray(r)){if(E==null&&r.length>1){return null;}I=r;}var p=o._getTotalRowCount();var v=I.filter(function(a){var b=n.isExpanded(a);var q=true;if(n.nodeHasChildren){if(n.getNodeByIndex){q=!n.nodeHasChildren(n.getNodeByIndex(a));}else{q=false;}}return a>=0&&a<p&&!q&&E!==b;}).sort(function(a,b){return a-b;});if(v.length===0){return null;}for(var i=v.length-1;i>0;i--){if(E){n.expand(v[i],true);}else{n.collapse(v[i],true);}}if(E===true){n.expand(v[0],false);}else if(E===false){n.collapse(v[0],false);}else{n.toggleIndex(v[0]);}return n.isExpanded(v[0]);}
g.prototype.setFixedRowCount=function(r){L.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};
g.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return T.prototype.isTreeBinding.apply(this,arguments);};
g.prototype.getBinding=function(n){n=n==null?"rows":n;var b=T.prototype.getBinding.call(this,n);if(b&&n==="rows"&&!b.getLength){if(b.isA("sap.ui.model.odata.ODataTreeBinding")){d(b,this);}else if(b.isA("sap.ui.model.odata.v2.ODataTreeBinding")){b.applyAdapterInterface();}else if(b.isA("sap.ui.model.ClientTreeBinding")){C.apply(b);}else{L.error("Binding not supported by sap.ui.table.TreeTable");}}return b;};
g.prototype._getContexts=function(s,i,a){var b=this.getBinding();if(b){return b.getNodes(s,i,a);}else{return[];}};
g.prototype._getRowContexts=function(r){return k(this,r);};
function k(o,r,s){var O=o._getTotalRowCount();var R=T.prototype._getRowContexts.call(o,r);if(s===true){return R;}var n=o._getTotalRowCount();var F=o._getFirstRenderedRowIndex();var M=o._getMaxFirstRenderedRowIndex();o._adjustToTotalRowCount();if(M<F&&o._bContextsAvailable){R=k(o,r,true);}else if(O!==n){R=k(o,r,true);}return R;}
g.prototype._onGroupHeaderChanged=function(r,E){this.fireToggleOpenState({rowIndex:r,rowContext:this.getContextByIndex(r),expanded:E});};
g.prototype.expand=function(r){t(this,r,true);return this;};
g.prototype.collapse=function(r){t(this,r,false);return this;};
g.prototype.collapseAll=function(){var b=this.getBinding();if(b){b.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
g.prototype.expandToLevel=function(i){var b=this.getBinding();f(b&&b.expandToLevel,"TreeTable.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.");if(b&&b.expandToLevel){b.expandToLevel(i);}return this;};
g.prototype.isExpanded=function(r){var b=this.getBinding();if(b){return b.isExpanded(r);}return false;};
g.prototype.getContextByIndex=function(r){var b=this.getBinding();if(b){return b.getContextByIndex(r);}};
g.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var b=this.getBinding();if(b){f(b.setRootLevel,"rootLevel is not supported by the used binding");if(b.setRootLevel){b.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};
g.prototype.setCollapseRecursive=function(b){var o=this.getBinding();if(o){f(o.setCollapseRecursive,"Collapse Recursive is not supported by the used binding");if(o.setCollapseRecursive){o.setCollapseRecursive(b);}}this.setProperty("collapseRecursive",!!b,true);return this;};
g.prototype.setUseGroupMode=function(G){this.setProperty("useGroupMode",!!G);m(this);return this;};
g.prototype.setEnableGrouping=function(){L.warning("The property enableGrouping is not supported by the sap.ui.table.TreeTable control");return this;};
g.prototype.setGroupBy=function(){L.warning("The groupBy association is not supported by the sap.ui.table.TreeTable control");return this;};
g.prototype.setUseFlatMode=function(F){this._bFlatMode=!!F;m(this);return this;};
function m(o){if(o.getUseGroupMode()){e.Grouping.setHierarchyMode(o,e.Grouping.HierarchyMode.GroupedTree);}else if(o._bFlatMode){e.Grouping.setToDefaultFlatMode(o);}else if(!o._bFlatMode){e.Grouping.setToDefaultTreeMode(o);}}
g.prototype._createLegacySelectionPlugin=function(){return new B();};
g.prototype._onBindingDataRequested=function(E){_(this).bPendingRequest=true;T.prototype._onBindingDataRequested.apply(this,arguments);};
g.prototype._onBindingDataReceived=function(E){_(this).bPendingRequest=false;T.prototype._onBindingDataReceived.apply(this,arguments);};
g.prototype._hasPendingRequests=function(){return _(this).bPendingRequest;};
return g;});
sap.ui.predefine('sap/ui/table/TreeTableRenderer',['sap/ui/table/TreeTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/extensions/Accessibility',["./ExtensionBase","./AccessibilityRender","../utils/TableUtils","../library","sap/ui/core/Control","sap/ui/Device","sap/ui/thirdparty/jquery"],function(E,A,T,l,C,D,q){"use strict";var S=l.SelectionMode;var a=T.CELLTYPE;var b={getAccInfoOfControl:function(o){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return b._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};b._flatten(s,t);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,L){L=L?L:0;b._normalize(s);if(L==0){b._normalize(t);t._descriptions=[];}t._descriptions.push(b._getFullDescription(s));s.children.forEach(function(o){if(!o.getAccessibilityInfo||(o.getVisible&&!o.getVisible())){return;}var e=o.getAccessibilityInfo();if(e){b._flatten(e,t,L+1);}});if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i){var s=i.type+" "+i.description;if(i.enabled===false){s=s+" "+T.getResourceText("TBL_CTRL_STATE_DISABLED");}else if(i.editable===false){s=s+" "+T.getResourceText("TBL_CTRL_STATE_READONLY");}return s.trim();}};var c={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();var i=T.getFocusedItemInfo(t);return i.cellInRow-(T.hasRowHeader(t)?1:0);},getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var f=i.getFocusedDomRef();if(!f||f!==document.activeElement){return null;}return T.getCellInfo(f);},getRelevantColumnHeaders:function(t,o){var L=[];if(!t||!o||!t.getColumnHeaderVisible()){return L;}var h=T.getHeaderRowCount(t);if(h>0){var s=o.getId();L.push(s);for(var i=1;i<h;i++){L.push(s+"_"+i);}var e=T.Column.getParentSpannedColumns(t,s);if(e&&e.length){for(var j=0;j<e.length;j++){var f=e[j].level;var p=e[j].column.getId();L[f]=f===0?p:(p+"_"+f);}}}return L;},isHiddenCell:function($,o){var g=T.Grouping.isInGroupHeaderRow($);var s=T.Grouping.isInSummaryRow($);var e=!!o&&!!o.hasStyleClass;var i=$.parent().hasClass("sapUiTableRowHidden");var I=$.hasClass("sapUiTableCellHidden");var G=g&&e&&o.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var f=s&&e&&o.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return i||I||G||f;},isTreeColumnCell:function(e,$){return T.Grouping.isInTreeMode(e.getTable())&&$.hasClass("sapUiTableCellFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},getGridSize:function(t){var h=T.hasRowHeader(t);var H=T.hasRowActions(t);var i=T.getVisibleColumnCount(t)+(h?1:0)+(H?1:0);var e=T.isNoDataVisible(t)?0:Math.max(t._getTotalRowCount(),t._getRowCounts().count);return{columnCount:i,rowCount:T.getHeaderRowCount(t)+e};},getRowIndex:function(r){return r.getIndex()+1+T.getHeaderRowCount(r.getTable());},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,f=false,g=false,h=T.hasRowHeader(t);if(i){var j=c.getColumnIndexOfFocusedCell(e)+1+(h?1:0);var r=t.getRows()[T.getRowIndexOfFocusedCell(t)];var R=r?c.getRowIndex(r):0;var G=c.getGridSize(t);I=e._iLastRowNumber!=R||(e._iLastRowNumber==R&&e._iLastColumnNumber==j);f=e._iLastColumnNumber!=j;g=e._iLastRowNumber==null&&e._iLastColumnNumber==null;t.$("rownumberofrows").text(I&&R>0?T.getResourceText("TBL_ROW_ROWCOUNT",[R,G.rowCount]):" ");t.$("colnumberofcols").text(f?T.getResourceText("TBL_COL_COLCOUNT",[j,G.columnCount]):" ");t.$("ariacount").text(g?T.getResourceText("TBL_DATA_ROWS_COLS",[G.rowCount,G.columnCount]):" ");e._iLastRowNumber=R;e._iLastColumnNumber=j;}return{rowChange:I,colChange:f,initial:g};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,f,g){e._cleanupInfo={cell:$,attr:{"aria-labelledby":f&&f.length?f.join(" "):null,"aria-describedby":g&&g.length?g.join(" "):null}};},performCellModifications:function(e,$,f,g,L,h,t,i){c.storeDefaultsBeforeCellModifications(e,$,f,g);var o=c.updateRowColCount(e);var j=e.getTable();j.$("cellacc").text(t||" ");if(i){i(L,h,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){s=j.getId()+"-ariacount";if(j.getSelectionMode()!==S.None){s=s+" "+j.getId()+"-ariaselection";}}if(L&&L.length){s=s+" "+L.join(" ");}if(o.initial||o.rowChange){if(T.hasRowNavigationIndicators(j)){var k=T.getCellInfo($);if(k.type!==T.CELLTYPE.COLUMNHEADER&&k.type!==T.CELLTYPE.COLUMNROWHEADER){var r=j.getRows()[k.rowIndex].getAggregation("_settings");if(r.getNavigated()){s=s+" "+j.getId()+"-rownavigatedtext";}}}}$.attr({"aria-labelledby":s?s:null,"aria-describedby":h&&h.length?h.join(" "):null});},modifyAccOfDATACELL:function(o){var t=this.getTable();var s=t.getId();var i=t._getItemNavigation();var $=o.cell;if(!i){return;}var r=T.getRowIndexOfFocusedCell(t),e=c.getColumnIndexOfFocusedCell(this),f=T.getRowColCell(t,r,e,false),I=null,R=f.row,g=R.getId(),h=c.isHiddenCell($,f.cell),j=c.isTreeColumnCell(this,$),k=c.getAriaAttributesFor(this,d.ELEMENTTYPES.DATACELL,{index:e,column:f.column,fixed:T.isFixedColumn(t,e)})["aria-labelledby"]||[],m=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"],n=R.isGroupHeader(),p=R.isSummary();if(n){L.push(s+"-ariarowgrouplabel");}else if(R.isTotalSummary()){L.push(s+"-ariagrandtotallabel");}else if(R.isGroupSummary()){L.push(s+"-ariagrouptotallabel");}if(T.hasRowHighlights(t)&&!n&&!p){L.push(g+"-highlighttext");}L=L.concat(k);if(!h){I=b.getAccInfoOfControl(f.cell);L.push(I?(s+"-cellacc"):f.cell.getId());if(T.getInteractiveElements($)!==null){L.push(s+"-toggleedit");}if(T.Grouping.isInTreeMode(t)&&$.parent().attr("aria-selected")==="true"){L.push(s+"-ariarowselected");}}var u=I?I.description:" ";if(j&&!h){var v=c.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:f.row});if(v&&v["aria-label"]){u=v["aria-label"]+" "+u;}}c.performCellModifications(this,$,k,null,L,m,u,function(L,m,w,x){if(n&&w){L.splice(3,0,g+"-groupHeader");}var y=$.find(".sapUiTableTreeIcon").not(".sapUiTableTreeIconLeaf").length==1;if((y||n)&&(w||x)){m.push(t.getId()+(!R.isExpanded()?"-rowexpandtext":"-rowcollapsetext"));}else if(!h&&!n&&!p&&T.isRowSelectionAllowed(t)&&w){L.push(g+"-rowselecttext");}});},modifyAccOfROWHEADER:function(o){var t=this.getTable();var s=t.getId();var $=o.cell;var r=t.getRows()[o.rowIndex];var R=r.getId();var e=c.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[];var L=e.concat([s+"-rownumberofrows",s+"-colnumberofcols"]);if(!r.isSummary()&&!r.isGroupHeader()&&!r.isContentHidden()){L.push(R+"-rowselecttext");if(T.hasRowHighlights(t)){L.push(R+"-highlighttext");}}if(r.isGroupHeader()){L.push(s+"-ariarowgrouplabel");L.push(R+"-groupHeader");L.push(s+(r.isExpanded()?"-rowcollapsetext":"-rowexpandtext"));}if(r.isTotalSummary()){L.push(s+"-ariagrandtotallabel");}else if(r.isGroupSummary()){L.push(s+"-ariagrouptotallabel");}c.performCellModifications(this,$,e,null,L,null,null);},modifyAccOfCOLUMNHEADER:function(o){var t=this.getTable();var $=o.cell;var e=sap.ui.getCore().byId($.attr("data-sap-ui-colid"));var m=c.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:e,index:$.attr("data-sap-ui-colindex")});var s=c.getColumnTooltip(e);var L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]);var i=o.columnSpan;if(i>1){L.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(T.getResourceText("TBL_COL_DESC_SPAN",[""+i]));}if(s){L.push(t.getId()+"-cellacc");}if(i<=1&&e&&e.getFiltered()){L.push(t.getId()+"-ariacolfiltered");}c.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function(o){var t=this.getTable();var $=o.cell;var e=$.hasClass("sapUiTableSelAllVisible");var m=c.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNROWHEADER,{enabled:e,checked:e&&!t.$().hasClass("sapUiTableSelAll")});var L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]);c.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],null);},modifyAccOfROWACTION:function(o){var t=this.getTable();var s=t.getId();var $=o.cell;var r=t.getRows()[o.rowIndex];var R=r.getId();var h=c.isHiddenCell($);var e=c.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWACTION)["aria-labelledby"]||[];var L=[s+"-rownumberofrows",s+"-colnumberofcols"].concat(e);var f=[];var i=r.isGroupHeader();if(i){L.push(s+"-ariarowgrouplabel");L.push(s+(r.isExpanded()?"-rowcollapsetext":"-rowexpandtext"));}if(r.isTotalSummary()){L.push(s+"-ariagrandtotallabel");}else if(r.isGroupSummary()){L.push(s+"-ariagrouptotallabel");}if(!r.isSummary()&&!r.isGroupHeader()&&$.attr("aria-selected")==="true"){L.push(s+"-ariarowselected");}if(T.hasRowHighlights(t)&&!r.isGroupHeader()&&!r.isSummary()){L.push(R+"-highlighttext");}var g="";if(!h){var j=r.getRowAction();if(j){var I=j.getAccessibilityInfo();if(I){L.push(s+"-cellacc");g=I.description;if(T.getInteractiveElements($)!==null){f.push(s+"-toggleedit");}}}}c.performCellModifications(this,$,e,[],L,f,g,function(L,f,k){if(i&&k){var m=L.indexOf(s+"-ariarowgrouplabel")+1;L.splice(m,0,R+"-groupHeader");}});},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function f(o,x,O,y){var M="";if(O&&y){M="overlay,nodata";}else if(O&&!y){M="overlay";}else if(!O&&y){M="nodata";}var z=false;if(O&&o.getShowOverlay()||y&&T.isNoDataVisible(o)){z=true;}if(z){m["aria-hidden"]="true";}if(M){m["data-sap-ui-table-acc-covered"]=M;}}switch(t){case d.ELEMENTTYPES.COLUMNROWHEADER:var r=o._getSelectionPlugin().getRenderConfig();if(r.headerSelector.visible){if(r.headerSelector.type==="toggle"){m["role"]=["checkbox"];if(p&&p.enabled){m["aria-checked"]=p.checked?"true":"false";}}else if(r.headerSelector.type==="clear"){m["role"]=["button"];if(!p||!p.enabled){m["aria-disabled"]="true";}}}if(!o._getShowStandardTooltips()&&r.headerSelector.type==="toggle"){m["aria-labelledby"]=[s+"-ariaselectall"];}break;case d.ELEMENTTYPES.ROWHEADER:m["role"]="gridcell";m["aria-colindex"]=1;break;case d.ELEMENTTYPES.ROWACTION:m["role"]="gridcell";m["aria-colindex"]=o._getVisibleColumns().length+1+(T.hasRowHeader(o)?1:0);m["aria-labelledby"]=[s+"-rowacthdr"];break;case d.ELEMENTTYPES.COLUMNHEADER:var g=p&&p.column;var h=p&&p.colspan;m["role"]="columnheader";m["aria-colindex"]=p.index+1+(T.hasRowHeader(o)?1:0);var L=[];if(p&&p.headerId){var H=c.getRelevantColumnHeaders(o,g);var I=H.indexOf(p.headerId);L=I>0?H.slice(0,I+1):[p.headerId];}for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}m["aria-labelledby"]=L;if(p&&(p.index<o.getComputedFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(!h&&g&&g.getSorted()){m["aria-sort"]=g.getSortOrder()==="Ascending"?"ascending":"descending";}if(!h&&g){var P=g.getColumnHeaderMenu();if(P){m["aria-haspopup"]=P.getAriaHasPopupType().toLowerCase();}else if(g._menuHasItems()){m["aria-haspopup"]="menu";}}break;case d.ELEMENTTYPES.DATACELL:m["role"]="gridcell";m["aria-colindex"]=p.index+1+(T.hasRowHeader(o)?1:0);if(p.column){var L=c.getRelevantColumnHeaders(o,p.column);for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}m["aria-labelledby"]=L;}break;case d.ELEMENTTYPES.ROOT:break;case d.ELEMENTTYPES.TABLE:m["role"]="presentation";f(o,m,true,true);break;case d.ELEMENTTYPES.CONTAINER:break;case d.ELEMENTTYPES.CONTENT:m["role"]=T.Grouping.isInGroupMode(o)||T.Grouping.isInTreeMode(o)?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===S.MultiToggle){m["aria-multiselectable"]="true";}var R=o._getRowCounts();var j=T.hasFixedColumns(o);var k=R.fixedTop>0;var n=R.fixedBottom>0;var u=T.hasRowHeader(o);var v=T.hasRowActions(o);var G=c.getGridSize(o);m["aria-owns"]=[s+"-table"];if(j){m["aria-owns"].push(s+"-table-fixed");}if(k){m["aria-owns"].push(s+"-table-fixrow");if(j){m["aria-owns"].push(s+"-table-fixed-fixrow");}}if(n){m["aria-owns"].push(s+"-table-fixrow-bottom");if(j){m["aria-owns"].push(s+"-table-fixed-fixrow-bottom");}}if(u){m["aria-owns"].push(s+"-sapUiTableRowHdrScr");}if(v){m["aria-owns"].push(s+"-sapUiTableRowActionScr");}m["aria-rowcount"]=G.rowCount;m["aria-colcount"]=G.columnCount;if(o.isA("sap.ui.table.AnalyticalTable")){m["aria-roledescription"]=T.getResourceText("TBL_ANALYTICAL_TABLE_ROLE_DESCRIPTION");}break;case d.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";m["aria-level"]="2";f(o,m,true,false);break;case d.ELEMENTTYPES.COLUMNHEADER_TBL:m["role"]="presentation";break;case d.ELEMENTTYPES.COLUMNHEADER_ROW:m["role"]="row";f(o,m,true,false);break;case d.ELEMENTTYPES.CREATIONROW_TBL:m["role"]="presentation";break;case d.ELEMENTTYPES.CREATIONROW:m["role"]="form";m["aria-labelledby"]=p.creationRow.getId()+"-label";f(o,m,true,false);break;case d.ELEMENTTYPES.ROWHEADER_COL:f(o,m,true,true);break;case d.ELEMENTTYPES.TH:m["role"]="presentation";m["scope"]="col";m["aria-hidden"]="true";break;case d.ELEMENTTYPES.TR:m["role"]="row";if(p.rowNavigated){m["aria-current"]=true;}break;case d.ELEMENTTYPES.TREEICON:if(T.Grouping.isInTreeMode(o)){m={"aria-label":"","title":"","role":""};if(o.getBinding()){if(p&&p.row){if(p.row.isExpandable()){var w=T.getResourceText(p.row.isExpanded()?"TBL_COLLAPSE":"TBL_EXPAND");if(o._getShowStandardTooltips()){m["title"]=w;}else{m["aria-label"]=w;}m["aria-expanded"]=""+(!!p.row.isExpanded());m["aria-hidden"]="false";m["role"]="button";}else{m["aria-label"]=T.getResourceText("TBL_LEAF");m["aria-hidden"]="true";}}}}break;case d.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];f(o,m,true,false);break;case d.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case d.ELEMENTTYPES.TABLEFOOTER:case d.ELEMENTTYPES.TABLESUBHEADER:f(o,m,true,false);break;case d.ELEMENTTYPES.ROWACTIONHEADER:m["aria-hidden"]="true";break;case"PRESENTATION":m["role"]="presentation";break;}return m;}};
var d=E.extend("sap.ui.table.extensions.Accessibility",{
_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._busyCells=[];T.addDelegate(t,this);E.enrich(t,A);return"AccExtension";},
_attachEvents:function(){T.Hook.register(this.getTable(),T.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this);},
_detachEvents:function(){T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this);},
_debug:function(){this._ExtensionHelper=c;this._ACCInfoHelper=b;},
destroy:function(){this.getTable().removeEventDelegate(this);this._busyCells=[];E.prototype.destroy.apply(this,arguments);},
getAriaAttributesFor:function(t,p){return c.getAriaAttributesFor(this,t,p);},
onfocusin:function(e){var t=this.getTable();if(!t||T.getCellInfo(e.target).cell==null){return;}if(t._mTimeouts._cleanupACCExtension){clearTimeout(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell("Focus");},
onfocusout:function(e){var t=this.getTable();if(!t){return;}t._mTimeouts._cleanupACCExtension=setTimeout(function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;c.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;}.bind(this),100);}
});
d.ELEMENTTYPES={DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",ROWACTION:"ROWACTION",COLUMNROWHEADER:"COLUMNROWHEADER",ROOT:"ROOT",CONTAINER:"CONTAINER",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_TBL:"COLUMNHEADER_TABLE",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",CREATIONROW_TBL:"CREATIONROW_TABLE",CREATIONROW:"CREATIONROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",TR:"TR",TREEICON:"TREEICON",ROWACTIONHEADER:"ROWACTIONHEADER",NODATA:"NODATA",OVERLAY:"OVERLAY"};
d.prototype.getAccMode=function(){return this._accMode;};
d.prototype._updateAriaRowIndices=function(){if(!this._accMode){return;}var t=this.getTable();var r=t.getRows();var R,i;for(i=0;i<r.length;i++){R=r[i];R.getDomRefs(true).row.attr("aria-rowindex",c.getRowIndex(R));}};
d.prototype._updateAriaRowCount=function(){var t=this.getTable();var $=t.$("sapUiTableGridCnt");if($){$.attr("aria-rowcount",c.getGridSize(t).rowCount);}};
d.prototype.updateAccForCurrentCell=function(r){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}if(r==="Focus"||r===T.RowsUpdateReason.Expand||r===T.RowsUpdateReason.Collapse){c.cleanupCellModifications(this);}var i=c.getInfoOfFocusedCell(this);var s;if(!i||!i.isOfType(a.ANY)){return;}if(i.isOfType(a.DATACELL)){s=d.ELEMENTTYPES.DATACELL;}else if(i.isOfType(a.COLUMNHEADER)){s=d.ELEMENTTYPES.COLUMNHEADER;}else if(i.isOfType(a.ROWHEADER)){s=d.ELEMENTTYPES.ROWHEADER;}else if(i.isOfType(a.ROWACTION)){s=d.ELEMENTTYPES.ROWACTION;}else if(i.isOfType(a.COLUMNROWHEADER)){s=d.ELEMENTTYPES.COLUMNROWHEADER;}if(!c["modifyAccOf"+s]){return;}if(r!=="Focus"&&r!==T.RowsUpdateReason.Expand&&r!==T.RowsUpdateReason.Collapse){if(i.isOfType(a.DATACELL|a.ROWHEADER|a.ROWACTION)){i.cell.attr("role","status");i.cell.attr("role","gridcell");}else{return;}}c["modifyAccOf"+s].apply(this,[i]);};
d.prototype.updateAriaStateOfColumn=function(o){if(!this._accMode){return;}var m=c.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});var h=c.getRelevantColumnHeaders(this.getTable(),o);for(var i=0;i<h.length;i++){var H=q(document.getElementById(h[i]));if(!H.attr("colspan")){H.attr({"aria-sort":m["aria-sort"]||null});}}};
d.prototype.updateRowTooltips=function(r,R,t){if(!this._accMode){return;}var o=this.getTable();var s=!r.isEmpty()&&!r.isGroupHeader()&&!r.isSummary()&&o._getShowStandardTooltips();if(R.row){if(s&&T.isRowSelectionAllowed(o)&&!R.row.hasClass("sapUiTableRowHidden")){R.row.attr("title",t);}else{R.row.removeAttr("title");}}if(R.rowSelector){if(s&&T.isRowSelectorSelectionAllowed(o)){R.rowSelector.attr("title",t);}else{R.rowSelector.removeAttr("title");}}if(R.rowScrollPart){var $=R.rowScrollPart.add(R.rowFixedPart).add(R.rowActionPart);if(s&&T.isRowSelectionAllowed(o)){$.attr("title",t);}else{$.removeAttr("title");}}};
d.prototype.updateSelectionStateOfRow=function(r){if(!this._accMode){return;}var R=r.getDomRefs(true);var t="";var s="";if(!r.isEmpty()&&!r.isGroupHeader()&&!r.isSummary()){var m=this.getAriaTextsForSelectionMode(true);var o=this.getTable();var i=o._getSelectionPlugin().isIndexSelected(r.getIndex());if(R.row){R.row.add(R.row.children(".sapUiTableCell")).attr("aria-selected",i?"true":"false");}if(!i){t=m.keyboard["rowSelect"];s=m.mouse["rowSelect"];}else{t=T.getResourceText("TBL_ROW_DESC_SELECTED")+" "+m.keyboard["rowDeselect"];s=m.mouse["rowDeselect"];}}if(R.rowSelectorText){R.rowSelectorText.text(t);}this.updateRowTooltips(r,R,s);};
d.prototype.updateAriaExpandAndLevelState=function(r){if(!this._accMode){return;}var o=r.getDomRefs(true);var t=o.row.find(".sapUiTableTreeIcon");if(o.rowHeaderPart){o.rowHeaderPart.attr({"aria-haspopup":r.isGroupHeader()?"menu":null});}o.row.attr({"aria-expanded":r.isExpandable()?r.isExpanded()+"":null,"aria-level":r.getLevel()});if(t){t.attr(c.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:r}));}};
d.prototype.updateAriaStateOfRowHighlight=function(r){if(!this._accMode||!r){return;}var R=r._getRow();var h=R?R.getDomRef("highlighttext"):null;if(h){h.innerText=r._getHighlightText();}};
d.prototype._updateAriaStateOfNavigatedRow=function(r){if(!this._accMode||!r){return;}var R=r._getRow();var n=r.getNavigated();R.getDomRefs(true).row.attr("aria-current",n?true:null);};
d.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(T.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};
d.prototype.getAriaTextsForSelectionMode=function(e,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var f=t._getShowStandardTooltips();var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectionPlugin().getSelectedCount();if(s===S.Single){m.mouse.rowSelect=f?T.getResourceText("TBL_ROW_SELECT"):"";m.mouse.rowDeselect=f?T.getResourceText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=T.getResourceText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=T.getResourceText("TBL_ROW_DESELECT_KEY");}else if(s===S.MultiToggle){m.mouse.rowSelect=f?T.getResourceText("TBL_ROW_SELECT_MULTI_TOGGLE"):"";m.mouse.rowDeselect=f?T.getResourceText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=T.getResourceText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=T.getResourceText("TBL_ROW_DESELECT_KEY");if(e===true&&i===0){m.mouse.rowSelect=f?T.getResourceText("TBL_ROW_SELECT"):"";}}return m;};
d.prototype.setSelectAllState=function(s){var t=this.getTable();if(this._accMode&&t){t.$("selall").attr("aria-checked",s?"true":"false");}};
d.prototype.addColumnHeaderLabel=function(o,e){var t=this.getTable();if(!this._accMode||!e.getAriaLabelledBy||!t){return;}var L=t.getColumnHeaderVisible()?o.getId():null;if(!L){var f=o.getAggregation("label");if(f){L=f.getId();}}var g=e.getAriaLabelledBy();if(L&&g.indexOf(L)<0){e.addAriaLabelledBy(L);}};
return d;});
sap.ui.predefine('sap/ui/table/extensions/AccessibilityRender',["./ExtensionBase","../utils/TableUtils","../library"],function(E,T,l){"use strict";var S=l.SelectionMode;var _=function(r,p,i,t,c){c=c||[];c.push("sapUiInvisibleText");r.openStart("span",p+"-"+i);c.forEach(function(C){r.class(C);});r.attr("aria-hidden","true");r.openEnd();if(t){r.text(t);}r.close("span");};
var A=E.extend("sap.ui.table.extensions.AccessibilityRender",{
_init:function(t,s,m){return"AccRenderExtension";},
writeHiddenAccTexts:function(r,t){if(!t._getAccExtension().getAccMode()){return;}var s=t.getId();r.openStart("div");r.class("sapUiTableHiddenTexts");r.style("display","none");r.attr("aria-hidden","true");r.openEnd();_(r,s,"ariacount");_(r,s,"toggleedit",T.getResourceText("TBL_TOGGLE_EDIT_KEY"));var a=T.areAllRowsSelected(t);var R=t._getSelectionPlugin().getRenderConfig();var b;if(R.headerSelector.type==="toggle"){b=a?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(R.headerSelector.type==="clear"){b="TBL_DESELECT_ALL";}_(r,s,"ariaselectall",T.getResourceText(b));_(r,s,"ariarowgrouplabel",T.getResourceText("TBL_ROW_GROUP_LABEL"));_(r,s,"ariagrandtotallabel",T.getResourceText("TBL_GRAND_TOTAL_ROW"));_(r,s,"ariagrouptotallabel",T.getResourceText("TBL_GROUP_TOTAL_ROW"));_(r,s,"rownumberofrows");_(r,s,"colnumberofcols");_(r,s,"cellacc");_(r,s,"ariarowselected",T.getResourceText("TBL_ROW_DESC_SELECTED"));_(r,s,"ariacolmenu",T.getResourceText("TBL_COL_DESC_MENU"));_(r,s,"ariacolspan");_(r,s,"ariacolfiltered",T.getResourceText("TBL_COL_DESC_FILTERED"));_(r,s,"ariacolsortedasc",T.getResourceText("TBL_COL_DESC_SORTED_ASC"));_(r,s,"ariacolsorteddes",T.getResourceText("TBL_COL_DESC_SORTED_DES"));_(r,s,"ariainvalid",T.getResourceText("TBL_TABLE_INVALID"));_(r,s,"ariashowcolmenu",T.getResourceText("TBL_COL_VISBILITY_MENUITEM_SHOW"));_(r,s,"ariahidecolmenu",T.getResourceText("TBL_COL_VISBILITY_MENUITEM_HIDE"));_(r,s,"rowexpandtext",T.getResourceText("TBL_ROW_EXPAND_KEY"));_(r,s,"rowcollapsetext",T.getResourceText("TBL_ROW_COLLAPSE_KEY"));var o=t.getSelectionMode();if(o!==S.None){_(r,s,"ariaselection",T.getResourceText(o==S.MultiToggle?"TBL_TABLE_SELECTION_MULTI":"TBL_TABLE_SELECTION_SINGLE"));}if(t.getComputedFixedColumnCount()>0){_(r,s,"ariafixedcolumn",T.getResourceText("TBL_FIXED_COLUMN"));}if(T.hasRowNavigationIndicators(t)){_(r,s,"rownavigatedtext",T.getResourceText("TBL_ROW_STATE_NAVIGATED"));}r.close("div");},
writeAriaAttributesFor:function(r,t,s,p){var e=t._getAccExtension();if(!e.getAccMode()){return;}var a=e.getAriaAttributesFor(s,p);var v,k;for(k in a){v=a[k];if(Array.isArray(v)){v=v.join(" ");}if(v){r.attr(k.toLowerCase(),v);}}},
writeAccRowSelectorText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var I=t._getSelectionPlugin().isIndexSelected(i);var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var s=m.keyboard[I?"rowDeselect":"rowSelect"];if(!R.isGroupHeader()&&!R.isSummary()){_(r,R.getId(),"rowselecttext",R.isEmpty()?"":s,["sapUiTableAriaRowSel"]);}},
writeAccRowHighlightText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var o=R.getAggregation("_settings");var h=o._getHighlightText();_(r,R.getId(),"highlighttext",h);},
writeAccCreationRowText:function(r,t,c){if(!t._getAccExtension().getAccMode()){return;}_(r,c.getId(),"label",T.getResourceText("TBL_CREATEROW_LABEL"));}
});
return A;});
sap.ui.predefine('sap/ui/table/extensions/DragAndDrop',["./ExtensionBase","../utils/TableUtils","sap/ui/core/library"],function(E,T,C){"use strict";var S="sap.ui.table";var D=C.dnd.DropPosition;var a={getSessionData:function(d,k){return d.getComplexData(S+(k==null?"":"-"+k));},setSessionData:function(d,s,k){d.setComplexData(S+(k==null?"":"-"+k),s);},getInstanceSessionData:function(d,t){return this.getSessionData(d,t.getId());},setInstanceSessionData:function(d,t,s){this.setSessionData(d,s,t.getId());}};var b={ondragstart:function(e){var d=e.dragSession;if(!d||!d.getDragControl()){return;}var o=d.getDragControl();var s={};if(o.isA("sap.ui.table.Row")){if(o.isEmpty()||o.isGroupHeader()||o.isSummary()){e.preventDefault();return;}else{s.draggedRowContext=o.getRowBindingContext();}}a.setInstanceSessionData(d,this,s);},ondragenter:function(e){var d=e.dragSession;if(!d||!d.getDropControl()){return;}var s=a.getInstanceSessionData(d,this);var o=d.getDragControl();var f=d.getDropControl();if(!s){s={};}if(f.isA("sap.ui.table.Row")){var g=s.draggedRowContext;var h=f.getRowBindingContext();var i=d.getDropInfo().getDropPosition();if((f.isEmpty()&&i===D.On&&T.hasData(this))||(g&&g===h)||f.isGroupHeader()||f.isSummary()){e.setMarked("NonDroppable");}else{if(!h){var l=this.getRows()[T.getNonEmptyRowCount(this)-1];d.setDropControl(l||this);}if(d.getDropControl()!==this){var v=this.getDomRef().classList.contains("sapUiTableVScr");var t=this.getDomRef("sapUiTableCnt").getBoundingClientRect();d.setIndicatorConfig({width:t.width-(v?16:0),left:t.left+(this._bRtlMode&&v?16:0)});}}}else if(f.isA("sap.ui.table.Column")){var t=this.getDomRef("sapUiTableCnt").getBoundingClientRect();d.setIndicatorConfig({height:t.height-(this._getScrollExtension().isHorizontalScrollbarVisible()?16:0)});}else if(o===f){e.setMarked("NonDroppable");}if(!s.verticalScrollEdge){var p=window.pageYOffset;var V=this.getDomRef("table").getBoundingClientRect();s.verticalScrollEdge={bottom:V.bottom+p,top:V.top+p};}var P=window.pageXOffset;var H=this.getDomRef("sapUiTableCtrlScr").getBoundingClientRect();s.horizontalScrollEdge={left:H.left+P,right:H.right+P};a.setInstanceSessionData(d,this,s);},ondragover:function(e){var d=e.dragSession;if(!d){return;}var s=a.getInstanceSessionData(d,this);if(!s){return;}var i=32;var t=50;var o=d.getDropControl();var f=this._getScrollExtension();var v=f.getVerticalScrollbar();var h=f.getHorizontalScrollbar();var V=s.verticalScrollEdge;var H=s.horizontalScrollEdge;if(V&&v&&o!==this){var p=e.pageY;if(p>=V.top-t&&p<=V.top+t){v.scrollTop-=i;}else if(p<=V.bottom+t&&p>=V.bottom-t){v.scrollTop+=i;}}if(H&&h&&o!==this){var P=e.pageX;if(P>=H.left-t&&P<=H.left+t){h.scrollLeft-=i;}else if(P<=H.right+t&&P>=H.right-t){h.scrollLeft+=i;}}},onlongdragover:function(e){var d=e.dragSession;if(!d){return;}var $=T.getCell(this,e.target);var r=T.getCellInfo($).rowIndex;var R=r==null?null:this.getRows()[r];var o=d.getDropControl();if(R&&(o===R||!o)){R.expand();}}};
var c=E.extend("sap.ui.table.extensions.DragAndDrop",{
_init:function(t,s,m){this._oDelegate=b;T.addDelegate(t,this._oDelegate,t);return"DragAndDropExtension";},
_debug:function(){this._ExtensionDelegate=b;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._oDelegate);}this._oDelegate=null;E.prototype.destroy.apply(this,arguments);}
});
return c;});
sap.ui.predefine('sap/ui/table/extensions/ExtensionBase',["sap/ui/base/Object"],function(B){"use strict";
var E=B.extend("sap.ui.table.extensions.ExtensionBase",{
_table:null,
_type:null,
_settings:null,
constructor:function(t,s){B.call(this);this._table=t;this._settings=s||{};this._type=E.TABLETYPES.STANDARD;if(t.isA("sap.ui.table.TreeTable")){this._type=E.TABLETYPES.TREE;}else if(t.isA("sap.ui.table.AnalyticalTable")){this._type=E.TABLETYPES.ANALYTICAL;}var e=this._init(this._table,this._type,this._settings);if(e){var a=this;t["_get"+e]=function(){return a;};}},
destroy:function(){this._table=null;this._type=null;this.bIsDestroyed=true;B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
E.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};
E.prototype.getTable=function(){return this._table;};
E.prototype._init=function(t,T,s){return null;};
E.prototype._attachEvents=function(){};
E.prototype._detachEvents=function(){};
E.attachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._attachEvents();}};
E.detachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._detachEvents();}};
E.enrich=function(t,a,s){if(!a||!(a.prototype instanceof E)){return null;}var e=new a(t,s);if(!t._aExtensions){t._aExtensions=[];}t._aExtensions.push(e);return e;};
E.cleanup=function(t){if(!t._bExtensionsInitialized||!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i].destroy();}delete t._aExtensions;delete t._bExtensionsInitialized;};
E.isEnrichedWith=function(t,e){if(!t||!t._aExtensions){return false;}for(var i=0;i<t._aExtensions.length;i++){if(t._aExtensions[i].getMetadata().getName()===e){return true;}}return false;};
return E;});
sap.ui.predefine('sap/ui/table/extensions/Keyboard',["./ExtensionBase","./KeyboardDelegate","../utils/TableUtils","sap/ui/core/delegate/ItemNavigation","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(E,K,T,I,D,c,q){"use strict";var a={_forward:function(t,o){var i=t._getItemNavigation();if(i!=null&&!t._getKeyboardExtension().isItemNavigationSuspended()&&!o.isMarked("sapUiTableSkipItemNavigation")){i["on"+o.type](o);}},onfocusin:function(o){a._forward(this,o);},onsapfocusleave:function(o){a._forward(this,o);},onmousedown:function(o){a._forward(this,o);},onsapnext:function(o){a._forward(this,o);},onsapnextmodifiers:function(o){a._forward(this,o);},onsapprevious:function(o){a._forward(this,o);},onsappreviousmodifiers:function(o){a._forward(this,o);},onsappageup:function(o){a._forward(this,o);},onsappagedown:function(o){a._forward(this,o);},onsaphome:function(o){a._forward(this,o);},onsaphomemodifiers:function(o){a._forward(this,o);},onsapend:function(o){a._forward(this,o);},onsapendmodifiers:function(o){a._forward(this,o);},onsapkeyup:function(o){a._forward(this,o);}};var b={onBeforeRendering:function(o){this._oStoredFocusInfo=this.getFocusInfo();},onAfterRendering:function(o){var R=o&&o.isMarked("renderRows");this._getKeyboardExtension().invalidateItemNavigation();if(this._oStoredFocusInfo&&this._oStoredFocusInfo.customId){if(R){this.applyFocusInfo(this._oStoredFocusInfo);}else{d.initItemNavigation(this._getKeyboardExtension(),true);}}delete this._oStoredFocusInfo;},onfocusin:function(o){var f=this._getKeyboardExtension();if(!f._bIgnoreFocusIn){d.initItemNavigation(this._getKeyboardExtension());}else{o.setMarked("sapUiTableIgnoreFocusIn");}if(o.target&&o.target.id===this.getId()+"-rsz"){o.preventDefault();o.setMarked("sapUiTableSkipItemNavigation");}}};var d={initItemNavigation:function(o,S){if(d.isItemNavigationInvalid(o)){d._initItemNavigation(o,S);}},_initItemNavigation:function(o,S){var t=o.getTable();if(!t){return;}var $=t.$();var R=t.getRows().length;var C=T.getVisibleColumnCount(t);var h=T.hasRowHeader(t);var H=T.hasRowActions(t);var f=T.hasFixedColumns(t);var i;var g=[],j,k,l,m,n;if(f){l=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");m=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");n=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");}var p=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");var u=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");var v=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");if(h){j=$.find(".sapUiTableRowSelectionCell").get();C++;}if(H){k=$.find(".sapUiTableRowActionCell").get();C++;}for(i=0;i<R;i++){if(h){g.push(j[i]);}if(f){g=g.concat(l.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}g=g.concat(p.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(f){g=g.concat(m.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}g=g.concat(u.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(f){g=g.concat(n.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}g=g.concat(v.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(H){g.push(k[i]);}}if(t.getColumnHeaderVisible()){var w=[];var F=$.find(".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr");var x=$.find(".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr");var y=T.getHeaderRowCount(t);for(i=0;i<y;i++){if(h){w.push(t.getDomRef("selall"));}if(F.length){w=w.concat(q(F.get(i)).find(".sapUiTableHeaderCell").get());}if(x.length){w=w.concat(q(x.get(i)).find(".sapUiTableHeaderCell").get());}if(H){w.push($.find(".sapUiTableRowActionHeaderCell").children().get(0));}}g=w.concat(g);}if(!o._itemNavigation){o._itemNavigation=new I();o._itemNavigation.setTableMode(true);o._itemNavigation.attachEvent(I.Events.AfterFocus,function(z){var A=T.getFocusedItemInfo(t);A.header=T.getHeaderRowCount(t);A.domRef=null;if(A.row>=A.header){o._oLastFocusedCellInfo=A;}},t);}o._itemNavigation.setColumns(C);o._itemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));o._itemNavigation.setItemDomRefs(g);if(!S){o._itemNavigation.setFocusedIndex(d.getInitialItemNavigationIndex(o));}o._itemNavigationInvalidated=false;},getInitialItemNavigationIndex:function(o){return T.hasRowHeader(o.getTable())?1:0;},isItemNavigationInvalid:function(o){return!o._itemNavigation||o._itemNavigationInvalidated;}};
var e=E.extend("sap.ui.table.extensions.Keyboard",{
_init:function(t,f,S){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._delegate=new K(f);this._actionMode=false;T.addDelegate(t,b,t);T.addDelegate(t,this._delegate,t);T.addDelegate(t,a,t);t._getItemNavigation=function(){return this._itemNavigation;}.bind(this);return"KeyboardExtension";},
_debug:function(){this._ExtensionHelper=d;this._ItemNavigationDelegate=a;this._ExtensionDelegate=b;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(b);t.removeEventDelegate(this._delegate);t.removeEventDelegate(a);}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}if(this._delegate){this._delegate.destroy();this._delegate=null;}E.prototype.destroy.apply(this,arguments);}
});
e.prototype.initItemNavigation=function(){d.initItemNavigation(this);};
e.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true;};
e.prototype.setActionMode=function(f){if(!this._delegate){return;}if(f===true&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=this._delegate.enterActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1))===true;}else if(f===false&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1));}};
e.prototype.isInActionMode=function(){return this._actionMode;};
e.prototype.updateNoDataAndOverlayFocus=function(){var t=this.getTable();var f=document.activeElement;if(!t||!t.getDomRef()){return;}if(t.getShowOverlay()){if(c(t.getDomRef(),f)&&t.$("overlay")[0]!==f){this._oLastFocus={Ref:f,Pos:"overlay"};t.getDomRef("overlay").focus();}}else if(T.isNoDataVisible(t)&&t.$("noDataCnt")[0]!==f){if(c(t.getDomRef("tableCCnt"),f)){this._oLastFocus={Ref:f,Pos:"table content"};if(D.browser.safari){t.getDomRef("noDataCnt").getBoundingClientRect();}t.getDomRef("noDataCnt").focus();}else if(t.$("overlay")[0]===f){s(t,this);}}else if(this._oLastFocus){if(this._oLastFocus.Pos==="table content"){if(c(t.getDomRef("tableCCnt"),this._oLastFocus.Ref)){r(t,this);}else if(t.getRows()[0]&&t.getRows()[0].getDomRef("col0")){t.getRows()[0].getDomRef("col0").focus();this._oLastFocus=null;}}else if(this._oLastFocus.Pos==="overlay"){if(c(t.getDomRef(),this._oLastFocus.Ref)){r(t,this);}else{s(t,this);}}}};
function r(t,k){if(!q(k._oLastFocus.Ref).hasClass("sapUiTableCell")){var p=T.getParentCell(t,k._oLastFocus.Ref);if(p&&p[0]&&q(p[0]).hasClass("sapUiTableCell")){p[0].focus();}else{k._oLastFocus.Ref.focus();}}else{k._oLastFocus.Ref.focus();}k._oLastFocus=null;}
function s(t,k){if(t.getColumnHeaderVisible()){T.focusItem(t,d.getInitialItemNavigationIndex(k));k._oLastFocus=null;}else if(T.isNoDataVisible(t)){t.getDomRef("noDataCnt").focus();k._oLastFocus=null;}else if(t.getRows()[0]&&t.getRows()[0].getDomRef("col0")){t.getRows()[0].getDomRef("col0").focus();k._oLastFocus=null;}}
e.prototype.suspendItemNavigation=function(){this._itemNavigationSuspended=true;};
e.prototype.resumeItemNavigation=function(){this._itemNavigationSuspended=false;};
e.prototype.isItemNavigationSuspended=function(){return this._itemNavigationSuspended;};
e.prototype.getLastFocusedCellInfo=function(){var h=T.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=h){var i=T.getFocusedItemInfo(this.getTable());var f=d.getInitialItemNavigationIndex(this);return{cellInRow:f,row:h,header:h,cellCount:i.cellCount,columnCount:i.columnCount,cell:i.columnCount*h+f};}return this._oLastFocusedCellInfo;};
e.prototype.setSilentFocus=function(o){this._bIgnoreFocusIn=true;this.setFocus(o);this._bIgnoreFocusIn=false;};
e.prototype.setFocus=function(o){if(!o){return;}var t=this.getTable();var C=T.getCellInfo(o);if(C.isOfType(T.CELLTYPE.ANY)&&t){var $=q(o);if($.attr("tabindex")!="0"){var f=t._getItemNavigation();if(f&&f.aItemDomRefs){for(var i=0;i<f.aItemDomRefs.length;i++){if(f.aItemDomRefs[i]){f.aItemDomRefs[i].setAttribute("tabindex","-1");}}}$.attr("tabindex","0");}}if(o instanceof HTMLElement){o.focus();}else{o.trigger("focus");}};
return e;});
sap.ui.predefine('sap/ui/table/extensions/KeyboardDelegate',["../utils/TableUtils","../library","sap/ui/base/Object","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(T,l,B,D,K,q){"use strict";var C=T.CELLTYPE;var S=l.SelectionMode;var M={CTRL:1,SHIFT:2,ALT:4};var H=5;var a="1rem";
function p(i,P){i.setMarked("sapUiTableSkipItemNavigation",P!==false);}
function h(i){if(T.getCellInfo(i.target).isOfType(C.ANY)){i.preventDefault();i.stopPropagation();}}
var b=B.extend("sap.ui.table.extensions.KeyboardDelegate",{
constructor:function(i){B.call(this);},
destroy:function(){B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
function n(i,G){if(!e(i,G)){return;}var I=T.getCellInfo(T.getCell(i,G.target));if(I.isOfType(C.ANYCOLUMNHEADER)){_(i,I,G);}else if(I.isOfType(C.ANYCONTENTCELL)){c(i,I,G);}}
function _(i,G,I){var J=T.getHeaderRowCount(i);if(T.isNoDataVisible(i)){var L=T.getFocusedItemInfo(i);if(L.row-J<=1){p(I);}}else if(G.isOfType(C.COLUMNROWHEADER)&&J>1){p(I);T.focusItem(i,J*(T.getVisibleColumnCount(i)+1),I);}}
function c(i,G,I){var J=i._getKeyboardExtension();var L=J.isInActionMode();var N=b._isKeyCombination(I,null,M.CTRL);var O=N||L;var P=T.getParentCell(i,I.target);if(!O&&P){P.trigger("focus");return;}p(I);if(T.isLastScrollableRow(i,G.cell)){var Q=s(i,I);if(Q){I.preventDefault();return;}}if(G.rowIndex===i.getRows().length-1){if(!L&&P){P.trigger("focus");}else{var R=i.getCreationRow();if(!R||!R._takeOverKeyboardHandling(I)){J.setActionMode(false);}}return;}A(i,G.type,G.rowIndex+1,G.columnIndex,O);I.preventDefault();}
function d(i,G){var I=T.getCellInfo(T.getCell(i,G.target));if(!I.isOfType(C.ANYCONTENTCELL)||!e(i,G)){return;}var J=b._isKeyCombination(G,null,M.CTRL);var L=i._getKeyboardExtension();var N=L.isInActionMode();var O=J||N;var P=T.getParentCell(i,G.target);if(!O&&P){P.trigger("focus");return;}p(G);if(T.isFirstScrollableRow(i,I.cell)){var Q=g(i,G);if(Q){G.preventDefault();return;}}if(I.rowIndex===0){p(G,I.isOfType(C.ROWACTION)||O);if(!N&&P){P.trigger("focus");}else{L.setActionMode(false);}return;}A(i,I.type,I.rowIndex-1,I.columnIndex,O);G.preventDefault();}
function e(i,G){var I=b._isKeyCombination(G,null,M.CTRL);return!G.isMarked()&&(I||!(G.target instanceof window.HTMLInputElement)&&!(G.target instanceof window.HTMLTextAreaElement));}
function f(i,G){if(G.isMarked()){return;}var I=T.getCellInfo(T.getCell(i,G.target));var J=sap.ui.getCore().getConfiguration().getRTL();if(!I.isOfType(C.COLUMNHEADER)||!J){return;}var L=T.getFocusedItemInfo(i);var N=L.cellInRow-(T.hasRowHeader(i)?1:0);var O=T.getVisibleColumnCount(i);if(T.hasRowActions(i)&&N===O-1){p(G);}}
function s(i,G,P,I){var J=i._getFirstRenderedRowIndex()===i._getMaxFirstRenderedRowIndex();if(J){return null;}j(i,G,true,P,I);return true;}
function g(i,G,P,I){var J=i._getFirstRenderedRowIndex()===0;if(J){return false;}j(i,G,false,P,I);return true;}
function j(i,G,I,P,J){var L=T.getCellInfo(T.getCell(i,G.target));var N=i._getKeyboardExtension().isInActionMode();var O=b._isKeyCombination(G,null,M.CTRL);var Q=O||N;var R=N&&L.isOfType(C.DATACELL);if(R){i._getKeyboardExtension().setSilentFocus(i.getDomRef("focusDummy"));setTimeout(function(){i._getScrollExtension().scrollVertically(I===true,P);},0);}else{i._getScrollExtension().scrollVertically(I===true,P);}if(Q||J){i.attachEventOnce("rowsUpdated",function(){if(J){J();}else{A(i,L.type,L.rowIndex,L.columnIndex,true);}});}}
function k(i,G){var R=i._getRowCounts();var I=s(i,G,false,function(){m(i,R.fixedTop+R.scrollable-1);});if(I){return;}if(R.fixedBottom>0){m(i,R.fixedTop+R.scrollable);}else{i._getKeyboardExtension().setActionMode(false);}}
function m(i,R){var G=i.getRows()[R];var I=G.isGroupHeader()||T.isRowSelectorSelectionAllowed(i);if(I){A(i,C.ROWHEADER,R);}else{var $=b._getFirstInteractiveElement(G);if($){b._focusElement(i,$[0]);}else{A(i,C.DATACELL,R,0,false,true);if(G.getIndex()===i._getTotalRowCount()-1){i._getKeyboardExtension().setActionMode(false);}}}}
function o(i,G){var R=i._getRowCounts();var I=g(i,G,false,function(){r(i,R.fixedTop);});if(I){return;}if(R.fixedTop>0){r(i,R.fixedTop-1);}else{i._getKeyboardExtension().setActionMode(false);}}
function r(i,R){var G=i.getRows()[R];var I=G.isGroupHeader()||T.isRowSelectorSelectionAllowed(i);var $=b._getLastInteractiveElement(G);if($){b._focusElement(i,$[0]);}else if(I){A(i,C.ROWHEADER,R);}else{A(i,C.DATACELL,R,0,false,true);if(G.getIndex()===0){i._getKeyboardExtension().setActionMode(false);}}}
function t(i,G){var I=T.getFocusedItemInfo(i);var L=i._getKeyboardExtension().getLastFocusedCellInfo();T.focusItem(i,I.cellInRow+(I.columnCount*L.row),G);}
function u(i,G){var I=T.getFocusedItemInfo(i);T.focusItem(i,I.cellInRow,G);}
function v(i,G){i._getKeyboardExtension().setSilentFocus(i.$().find("."+G));}
b._isKeyCombination=function(i,G,I){if(I==null){I=0;}var J=typeof G==="string"?String.fromCharCode(i.charCode):i.keyCode;var L=0;L|=(D.os.macintosh?i.metaKey:i.ctrlKey)&&G!==K.CONTROL?M.CTRL:0;L|=i.shiftKey&&G!==K.SHIFT?M.SHIFT:0;L|=i.altKey&&G!==K.ALT?M.ALT:0;var V=G==null||J===G;var N=I===L;return V&&N;};
function w(i,G){var $=T.getCell(i,G);var I=T.getCellInfo($);return i.getRows()[I.rowIndex];}
function x(i,G){var I=T.getCellInfo(G.target);if(I.isOfType(C.COLUMNROWHEADER)){i._getSelectionPlugin().onHeaderSelectorPress();}else if(b._allowsToggleExpandedState(i,G.target)){w(i,G.target).toggleExpandedState();}else if(I.isOfType(C.ROWHEADER)){L();}else if(I.isOfType(C.DATACELL|C.ROWACTION)){var J=!i.hasListeners("cellClick");if(!i._findAndfireCellEvent(i.fireCellClick,G)){if(T.isRowSelectionAllowed(i)){L();J=false;}}if(J){var $=T.getInteractiveElements(G.target);if($){i._getKeyboardExtension().setActionMode(true);}}}function L(){var N=null;if(i._legacyMultiSelection){N=function(R){i._legacyMultiSelection(R,G);return true;};}T.toggleRowSelection(i,G.target,null,N);}}
function y(i,N){var G=i.getParent();var V=G._getVisibleColumns();var I=V.indexOf(i);var J;if(N&&I<V.length-1){J=G.indexOfColumn(V[I+1])+1;}else if(!N&&I>0){J=G.indexOfColumn(V[I-1]);}if(J!=null){T.Column.moveColumnTo(i,J);}}
function z(G,I){var V=G.getColumns().filter(function(I){return I.getVisible()||I.getGrouped();});for(var i=0;i<V.length;i++){var J=V[i];if(J===I){return i;}}return-1;}
b._focusElement=function(i,G,I){if(!i||!G){return;}if(I==null){I=false;}if(I){i._getKeyboardExtension().setSilentFocus(G);}else{G.focus();}if(G instanceof window.HTMLInputElement){G.select();}};
function A(i,G,R,I,J,L){if(!i||G==null||R==null||R<0||R>=i.getRows().length){return;}var N=i.getRows()[R];var O;if(G===C.ROWHEADER){i._getKeyboardExtension().setFocus(i.getDomRef("rowsel"+R));return;}else if(G===C.ROWACTION){O=i.getDomRef("rowact"+R);}else if(G===C.DATACELL&&(I!=null&&I>=0)){var P=i.getColumns()[I];var Q=z(i,P);if(Q>=0){O=N.getDomRef("col"+Q);}}if(!O){return;}if(J){var $=T.getInteractiveElements(O);if($){b._focusElement(i,$[0]);return;}}if(L){i._getKeyboardExtension()._bStayInActionMode=true;}O.focus();}
function E(i){return i.classList.contains("sapUiTableTreeIconNodeOpen")||i.classList.contains("sapUiTableTreeIconNodeClosed");}
b._allowsToggleExpandedState=function(i,G){return T.Grouping.isInGroupHeaderRow(G)||(T.Grouping.isInTreeMode(i)&&G.classList.contains("sapUiTableCellFirst")&&(G.querySelector(".sapUiTableTreeIconNodeOpen")||G.querySelector(".sapUiTableTreeIconNodeClosed")))||E(G);};
b._isElementInteractive=function(i){if(!i){return false;}return q(i).is(T.INTERACTIVE_ELEMENT_SELECTORS);};
b._getFirstInteractiveElement=function(R){var i=T.getFirstInteractiveElement(R,true);if(!i){return null;}return q(i);};
b._getLastInteractiveElement=function(R){if(!R){return null;}var G=R.getParent();var I=R.getCells();var $;var J;if(T.hasRowActions(G)){I.push(R.getRowAction());}for(var i=I.length-1;i>=0;i--){$=T.getParentCell(G,I[i].getDomRef());J=T.getInteractiveElements($);if(J){return J.last();}}return null;};
b._getPreviousInteractiveElement=function(G,I){if(!G||!I){return null;}var $=q(I);if(!this._isElementInteractive($)){return null;}var J=T.getParentCell(G,I);var L;var N;var O;var P;var Q;var R;var U;L=T.getInteractiveElements(J);if(L[0]!==$[0]){return L.eq(L.index(I)-1);}N=T.getCellInfo(J);P=G.getRows()[N.rowIndex].getCells();if(N.isOfType(C.ROWACTION)){U=P.length-1;}else{Q=G.getColumns()[N.columnIndex];R=z(G,Q);U=R-1;}for(var i=U;i>=0;i--){O=P[i].getDomRef();J=T.getParentCell(G,O);L=T.getInteractiveElements(J);if(L){return L.last();}}return null;};
b._getNextInteractiveElement=function(G,I){if(!G||!I){return null;}var $=q(I);if(!this._isElementInteractive($)){return null;}var J=T.getParentCell(G,I);var L;var N;var O;var P;var Q;var R;var U;L=T.getInteractiveElements(J);if(L.get(-1)!==$[0]){return L.eq(L.index(I)+1);}N=T.getCellInfo(J);if(N.isOfType(C.ROWACTION)){return null;}R=G.getRows()[N.rowIndex];P=R.getCells();Q=G.getColumns()[N.columnIndex];U=z(G,Q);for(var i=U+1;i<P.length;i++){O=P[i].getDomRef();J=T.getParentCell(G,O);L=T.getInteractiveElements(J);if(L){return L.first();}}if(T.hasRowActions(G)){J=T.getParentCell(G,R.getRowAction().getDomRef());L=T.getInteractiveElements(J);if(L.get(-1)!==$[0]){return L.eq(L.index(I)+1);}}return null;};
function F(i){var G=T.getRowIndexOfFocusedCell(i);var I=i.getRows()[G].getIndex();var J=i._getSelectionPlugin();i._oRangeSelection={startIndex:I,selected:J.isIndexSelected(I)};}
b.prototype.enterActionMode=function(){var i=this._getKeyboardExtension();var G=document.activeElement;var I=T.getInteractiveElements(G);var $=T.getParentCell(this,G);var J=T.getCellInfo($);if(J.isOfType(C.ANYCOLUMNHEADER)){return false;}if(I){i.suspendItemNavigation();G.tabIndex=-1;b._focusElement(this,I[0],true);return true;}else if($){this._getKeyboardExtension().suspendItemNavigation();return true;}return false;};
b.prototype.leaveActionMode=function(i){i=i==null?true:i;var G=this._getKeyboardExtension();var I=document.activeElement;var $=T.getParentCell(this,I);G.resumeItemNavigation();if(i){if($){b._focusElement(this,$[0],true);}else{var J=this._getItemNavigation();if(J){var L=J.aItemDomRefs;var N=L.indexOf(I);if(N>-1){J.setFocusedIndex(N);}}G.setSilentFocus(I);}}};
b.prototype.onfocusin=function(i){if(i.isMarked("sapUiTableIgnoreFocusIn")){return;}var $=q(i.target);if($.hasClass("sapUiTableOuterBefore")||$.hasClass("sapUiTableOuterAfter")||(i.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this.$("overlay").trigger("focus");}else if($.hasClass("sapUiTableCtrlBefore")){var N=T.isNoDataVisible(this);if(!N||N&&this.getColumnHeaderVisible()){u(this,i);}else{this._getKeyboardExtension().setSilentFocus(this.$("noDataCnt"));}}else if($.hasClass("sapUiTableCtrlAfter")){if(!T.isNoDataVisible(this)){t(this,i);}}var G=T.getCellInfo(i.target);var I=G.isOfType(C.ROWHEADER)&&T.Grouping.isInGroupHeaderRow(i.target);var J=G.isOfType(C.ROWHEADER)&&!I&&T.isRowSelectorSelectionAllowed(this);var L=G.isOfType(C.DATACELL)&&this._getKeyboardExtension()._bStayInActionMode;var P=T.getCellInfo(T.getParentCell(this,i.target)).isOfType(C.ANYCONTENTCELL);var O=b._isElementInteractive(i.target);var Q=this._getKeyboardExtension().isInActionMode();var R=(Q&&(I||J||L)||(O&&P));if(L){this._getKeyboardExtension()._bStayInActionMode=false;}this._getKeyboardExtension().setActionMode(R,false);};
b.prototype.onkeydown=function(i){var G=this._getKeyboardExtension();var I=T.getCellInfo(i.target);var J=this.getSelectionMode();var L=this._getSelectionPlugin();if(b._isKeyCombination(i,K.F2)){var N=G.isInActionMode();var $=T.getCell(this,i.target);var O=T.getParentCell(this,i.target)!=null;I=T.getCellInfo($);if(!N&&O){$.trigger("focus");}else if(I.isOfType(C.ANYCOLUMNHEADER)){var P=T.getInteractiveElements($);if(P){P[0].focus();}}else{G.setActionMode(!N);}return;}if(b._isKeyCombination(i,K.F4)&&b._allowsToggleExpandedState(this,i.target)){w(this,i.target).toggleExpandedState();return;}if(b._isKeyCombination(i,K.SPACE)&&E(i.target)){i.preventDefault();return;}if(this._getKeyboardExtension().isInActionMode()||!I.isOfType(C.ANY)){return;}if(b._isKeyCombination(i,K.SPACE)){i.preventDefault();}if(b._isKeyCombination(i,K.SHIFT)&&J===S.MultiToggle&&(I.isOfType(C.ROWHEADER)&&T.isRowSelectorSelectionAllowed(this)||(I.isOfType(C.DATACELL|C.ROWACTION)))){F(this);}else if(b._isKeyCombination(i,K.A,M.CTRL)){i.preventDefault();if(I.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)&&J===S.MultiToggle){L.onKeyboardShortcut("toggle");}}else if(b._isKeyCombination(i,K.A,M.CTRL+M.SHIFT)){if(I.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)){L.onKeyboardShortcut("clear");}}else if(b._isKeyCombination(i,K.F4)){if(I.isOfType(C.DATACELL)){G.setActionMode(true);}}};
b.prototype.onkeypress=function(i){var G=this._getKeyboardExtension();var I=T.getCellInfo(i.target);if(b._isKeyCombination(i,"+")){if(b._allowsToggleExpandedState(this,i.target)){w(this,i.target).expand();}else if(I.isOfType(C.DATACELL|C.ROWACTION)){G.setActionMode(true);}}else if(b._isKeyCombination(i,"-")){if(b._allowsToggleExpandedState(this,i.target)){w(this,i.target).collapse();}else if(I.isOfType(C.DATACELL|C.ROWACTION)){G.setActionMode(true);}}};
b.prototype.oncontextmenu=function(i){if(i.isMarked("handledByPointerExtension")){return;}var G=T.getCellInfo(document.activeElement);if(G.isOfType(C.ANY)){i.preventDefault();T.Menu.openContextMenu(this,i.target,i);}};
b.prototype.onkeyup=function(i){var G=T.getCellInfo(i.target);if(b._isKeyCombination(i,K.SHIFT)){delete this._oRangeSelection;}if(G.isOfType(C.COLUMNHEADER)){if(b._isKeyCombination(i,K.SPACE)||b._isKeyCombination(i,K.ENTER)){T.Menu.openContextMenu(this,i.target);}}else if(b._isKeyCombination(i,K.SPACE)){x(this,i);}else if(b._isKeyCombination(i,K.SPACE,M.SHIFT)){T.toggleRowSelection(this,this.getRows()[G.rowIndex].getIndex());F(this);}else if(this._legacyMultiSelection&&!G.isOfType(C.COLUMNROWHEADER)&&(b._isKeyCombination(i,K.SPACE,M.CTRL)||b._isKeyCombination(i,K.ENTER,M.CTRL))){x(this,i);}};
b.prototype.onsaptabnext=function(G){var I=this._getKeyboardExtension();var J=T.getCellInfo(G.target);var $;if(I.isInActionMode()){var L;$=T.getCell(this,G.target);J=T.getCellInfo($);if(!J.isOfType(C.ANYCONTENTCELL)){return;}var R=this.getRows()[J.rowIndex];var N=b._getLastInteractiveElement(R);var O=N===null||N[0]===G.target;if(O){var P=R.getIndex();var Q=T.isLastScrollableRow(this,$);var U=this._getTotalRowCount()-1===P;var V=T.isRowSelectorSelectionAllowed(this);G.preventDefault();if(U){I.setActionMode(false);}else if(Q){k(this,G);}else{var W=J.rowIndex;if(V){A(this,C.ROWHEADER,W+1);}else{var X=this.getRows().length;var Y=false;for(var i=J.rowIndex+1;i<X;i++){W=i;R=this.getRows()[W];L=b._getFirstInteractiveElement(R);Y=R.isGroupHeader();if(L||Y){break;}}if(L){b._focusElement(this,L[0]);}else if(Y){A(this,C.ROWHEADER,W);}else{k(this,G);}}}}else if(J.isOfType(C.ROWHEADER)){G.preventDefault();L=b._getFirstInteractiveElement(R);b._focusElement(this,L[0]);}else{G.preventDefault();L=b._getNextInteractiveElement(this,G.target);b._focusElement(this,L[0]);}}else if(J.isOfType(C.ANYCOLUMNHEADER)){if(T.isNoDataVisible(this)){this.$("noDataCnt").trigger("focus");G.preventDefault();}else if(this.getRows().length>0){t(this,G);G.preventDefault();}}else if(J.isOfType(C.ANYCONTENTCELL)){v(this,"sapUiTableCtrlAfter");}else if(G.target===this.getDomRef("overlay")){I.setSilentFocus(this.$().find(".sapUiTableOuterAfter"));}else if(!J.isOfType(C.ANY)){$=T.getParentCell(this,G.target);if($){G.preventDefault();$.trigger("focus");}}};
b.prototype.onsaptabprevious=function(G){var I=this._getKeyboardExtension();var J=T.getCellInfo(G.target);var $;if(I.isInActionMode()){var L;$=T.getCell(this,G.target);J=T.getCellInfo($);if(!J.isOfType(C.ANYCONTENTCELL)){return;}var R=this.getRows()[J.rowIndex];var N=R.getIndex();var O=b._getFirstInteractiveElement(R);var P=O!==null&&O[0]===G.target;var Q=T.isRowSelectorSelectionAllowed(this);var U=Q||R.isGroupHeader();if(P&&U){G.preventDefault();A(this,C.ROWHEADER,J.rowIndex);}else if((P&&!U)||J.isOfType(C.ROWHEADER)||O===null){var V=T.isFirstScrollableRow(this,$);var W=N===0;G.preventDefault();if(W){I.setActionMode(false);}else if(V){o(this,G);}else{var X=J.rowIndex;var Y=false;for(var i=J.rowIndex-1;i>=0;i--){X=i;R=this.getRows()[X];L=b._getLastInteractiveElement(R);Y=R.isGroupHeader();if(L||U||Y){break;}}if(L){b._focusElement(this,L[0]);}else if(Y||U){A(this,C.ROWHEADER,X);}else{o(this,G);}}}else{G.preventDefault();L=b._getPreviousInteractiveElement(this,G.target);b._focusElement(this,L[0]);}}else if(J.isOfType(C.ANYCONTENTCELL)||G.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()&&!J.isOfType(C.ROWACTION)){u(this,G);G.preventDefault();}else{v(this,"sapUiTableCtrlBefore");}}else if(G.target===this.getDomRef("overlay")){this._getKeyboardExtension().setSilentFocus(this.$().find(".sapUiTableOuterBefore"));}else if(!J.isOfType(C.ANY)){$=T.getParentCell(this,G.target);if($){G.preventDefault();$.trigger("focus");}}};
b.prototype.onsapdown=function(i){h(i);n(this,i);};
b.prototype.onsapdownmodifiers=function(i){h(i);if(b._isKeyCombination(i,null,M.CTRL)){n(this,i);return;}var G=this._getKeyboardExtension();if(b._isKeyCombination(i,null,M.ALT)&&b._allowsToggleExpandedState(this,i.target)){p(i);w(this,i.target).expand();return;}if(G.isInActionMode()){return;}var I=T.getCellInfo(i.target);if(b._isKeyCombination(i,null,M.SHIFT)){if(I.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(i);return;}var J=T.getRowIndexOfFocusedCell(this);var L=this.getRows()[J].getIndex();if(L===this._getTotalRowCount()-1){return;}if(T.isLastScrollableRow(this,i.target)){var N=s(this,i);if(N){p(i);}}if(this._oRangeSelection.startIndex<=L){L++;if(this._oRangeSelection.selected){T.toggleRowSelection(this,L,true);}else{T.toggleRowSelection(this,L,false);}}else{T.toggleRowSelection(this,L,false);}}else{p(i);}}if(b._isKeyCombination(i,null,M.ALT)){if(I.isOfType(C.DATACELL)){G.setActionMode(true);}p(i);}};
b.prototype.onsapup=function(i){h(i);d(this,i);};
b.prototype.onsapupmodifiers=function(i){h(i);if(b._isKeyCombination(i,null,M.CTRL)){d(this,i);return;}if(b._isKeyCombination(i,null,M.ALT)&&b._allowsToggleExpandedState(this,i.target)){p(i);w(this,i.target).collapse();return;}var G=this._getKeyboardExtension();if(G.isInActionMode()){return;}var I=T.getCellInfo(i.target);if(b._isKeyCombination(i,null,M.SHIFT)){if(I.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(i);return;}var J=T.getRowIndexOfFocusedCell(this);var L=this.getRows()[J].getIndex();if(L===0){p(i);return;}if(T.isFirstScrollableRow(this,i.target)){var N=g(this,i);if(N){p(i);}}if(this._oRangeSelection.startIndex>=L){L--;if(this._oRangeSelection.selected){T.toggleRowSelection(this,L,true);}else{T.toggleRowSelection(this,L,false);}}else{T.toggleRowSelection(this,L,false);}}else{p(i);}}if(b._isKeyCombination(i,null,M.ALT)){if(I.isOfType(C.DATACELL)){G.setActionMode(true);}p(i);}};
b.prototype.onsapleft=function(i){h(i);f(this,i);};
b.prototype.onsapleftmodifiers=function(G){h(G);if(this._getKeyboardExtension().isInActionMode()){return;}var I=T.getCellInfo(G.target);var J=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(G,null,M.SHIFT)){if(I.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(G);return;}var L=T.getFocusedItemInfo(this);var N=T.hasRowHeader(this)&&L.cellInRow===1;if(N&&!T.isRowSelectorSelectionAllowed(this)){p(G);}}else if(I.isOfType(C.ROWACTION)){if(!this._oRangeSelection){p(G);}}else if(I.isOfType(C.ROWHEADER)&&J){if(!T.isRowSelectionAllowed(this)){p(G);}}else if(I.isOfType(C.COLUMNROWHEADER)&&J){p(G);}else if(I.isOfType(C.COLUMNHEADER)){var R=-T.convertCSSSizeToPixel(a);var O=0;if(J){R=R*-1;}for(var i=I.columnIndex;i<I.columnIndex+I.columnSpan;i++){O+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,I.columnIndex,O+R,true,I.columnSpan);p(G);}}else if(b._isKeyCombination(G,null,M.CTRL)){if(I.isOfType(C.COLUMNHEADER)){p(G);y(this.getColumns()[I.columnIndex],J);}}else if(b._isKeyCombination(G,null,M.ALT)){p(G);}};
b.prototype.onsaprightmodifiers=function(G){h(G);if(this._getKeyboardExtension().isInActionMode()){return;}var I=T.getCellInfo(G.target);var J=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(G,null,M.SHIFT)){if(I.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(G);}}else if(I.isOfType(C.ROWHEADER)){if(!T.isRowSelectionAllowed(this)){p(G);}}else if(I.isOfType(C.ROWACTION)&&J){if(!this._oRangeSelection){p(G);}}else if(I.isOfType(C.COLUMNHEADER)){var R=T.convertCSSSizeToPixel(a);var L=0;if(J){R=R*-1;}for(var i=I.columnIndex;i<I.columnIndex+I.columnSpan;i++){L+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,I.columnIndex,L+R,true,I.columnSpan);p(G);}else if(I.isOfType(C.COLUMNROWHEADER)){p(G);}}else if(b._isKeyCombination(G,null,M.CTRL)){if(I.isOfType(C.COLUMNHEADER)){p(G);y(this.getColumns()[I.columnIndex],!J);}}else if(b._isKeyCombination(G,null,M.ALT)){p(G);}};
b.prototype.onsaphome=function(i){h(i);if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupHeaderRow(i.target)){p(i);return;}var G=T.getCellInfo(i.target);if(G.isOfType(C.DATACELL|C.ROWACTION|C.COLUMNHEADER)){var I=T.getFocusedItemInfo(this);var J=I.cell;var L=I.cellInRow;var N=this.getComputedFixedColumnCount();var O=T.hasRowHeader(this);var R=O?1:0;if(T.hasFixedColumns(this)&&L>N+R){p(i);T.focusItem(this,J-L+N+R,null);}else if(O&&L>1){p(i);T.focusItem(this,J-L+R,null);}}};
b.prototype.onsapend=function(i){h(i);if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupHeaderRow(i.target)){p(i);return;}var G=T.getCellInfo(i.target);if(G.isOfType(C.ANY)){var I=T.getFocusedItemInfo(this);var J=I.cell;var L=I.columnCount;var N=this.getComputedFixedColumnCount();var O=I.cellInRow;var P=T.hasRowHeader(this);var R=P?1:0;var Q=false;if(G.isOfType(C.COLUMNHEADER)&&T.hasFixedColumns(this)){var U=parseInt(G.cell.attr("colspan")||1);if(U>1&&O+U-R===N){Q=true;}}if(P&&O===0){p(i);T.focusItem(this,J+1,null);}else if(T.hasFixedColumns(this)&&O<N-1+R&&!Q){p(i);T.focusItem(this,J+N-O,null);}else if(T.hasRowActions(this)&&G.isOfType(C.DATACELL)&&O<L-2){p(i);T.focusItem(this,J-O+L-2,null);}}};
b.prototype.onsaphomemodifiers=function(i){h(i);if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(i,null,M.CTRL)){var G=T.getCellInfo(i.target);if(G.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){p(i);var I=T.getFocusedItemInfo(this);var J=I.row;if(J>0){var L=I.cell;var N=I.columnCount;var O=T.getHeaderRowCount(this);var R=this._getRowCounts();if(J<O+R.fixedTop){if(G.isOfType(C.ROWACTION)){T.focusItem(this,L-N*(J-O),i);}else{T.focusItem(this,L-N*J,i);}}else if(J>=O+R.fixedTop&&J<O+T.getNonEmptyRowCount(this)-R.fixedBottom){this._getScrollExtension().scrollVerticallyMax(false);if(R.fixedTop>0||G.isOfType(C.ROWACTION)){T.focusItem(this,L-N*(J-O),i);}else{T.focusItem(this,L-N*J,i);}}else{this._getScrollExtension().scrollVerticallyMax(false);T.focusItem(this,L-N*(J-O-R.fixedTop),i);}}}}};
b.prototype.onsapendmodifiers=function(i){h(i);if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(i,null,M.CTRL)){var G=T.getCellInfo(i.target);if(G.isOfType(C.ANY)){var I=T.getFocusedItemInfo(this);var J=I.row;var L=T.getHeaderRowCount(this);var N=T.getNonEmptyRowCount(this);var R=this._getRowCounts();p(i);if(R.fixedBottom===0||J<L+N-1||(T.isNoDataVisible(this)&&J<L-1)){var O=I.cell;var P=I.columnCount;if(T.isNoDataVisible(this)){T.focusItem(this,O+P*(L-J-1),i);}else if(J<L){if(R.fixedTop>0){T.focusItem(this,O+P*(L+R.fixedTop-J-1),i);}else{this._getScrollExtension().scrollVerticallyMax(true);T.focusItem(this,O+P*(L+N-R.fixedBottom-J-1),i);}}else if(J>=L&&J<L+R.fixedTop){this._getScrollExtension().scrollVerticallyMax(true);T.focusItem(this,O+P*(L+N-R.fixedBottom-J-1),i);}else if(J>=L+R.fixedTop&&J<L+N-R.fixedBottom){this._getScrollExtension().scrollVerticallyMax(true);T.focusItem(this,O+P*(L+N-J-1),i);}else{T.focusItem(this,O+P*(L+N-J-1),i);}}}}};
b.prototype.onsappageup=function(i){h(i);if(this._getKeyboardExtension().isInActionMode()){return;}var G=T.getCellInfo(i.target);if(G.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){var I=T.getFocusedItemInfo(this);var J=I.row;var L=T.getHeaderRowCount(this);var R=this._getRowCounts();if(R.fixedTop===0&&J>=L||R.fixedTop>0&&J>L){p(i);var N=I.cell;var O=I.columnCount;if(J<L+R.fixedTop){T.focusItem(this,N-O*(J-L),i);}else if(J===L+R.fixedTop){var P=T.getNonEmptyRowCount(this)-R.fixedTop-R.fixedBottom;var Q=this.getFirstVisibleRow();g(this,i,true);if(Q<P){if(R.fixedTop>0||G.isOfType(C.ROWACTION)){T.focusItem(this,N-O*(J-L),i);}else{T.focusItem(this,N-O*L,i);}}}else if(J>L+R.fixedTop&&J<L+T.getNonEmptyRowCount(this)){T.focusItem(this,N-O*(J-L-R.fixedTop),i);}else{T.focusItem(this,N-O*(J-L-T.getNonEmptyRowCount(this)+1),i);}}if(G.isOfType(C.ROWACTION)&&J===L&&R.fixedTop>0){p(i);}}};
b.prototype.onsappagedown=function(i){h(i);if(this._getKeyboardExtension().isInActionMode()){return;}var G=T.getCellInfo(i.target);if(G.isOfType(C.ANY)){var I=T.getFocusedItemInfo(this);var J=I.row;var L=T.getHeaderRowCount(this);var N=T.getNonEmptyRowCount(this);var R=this._getRowCounts();p(i);if((T.isNoDataVisible(this)&&J<L-1)||R.fixedBottom===0||J<L+N-1){var O=I.cell;var P=I.columnCount;if(J<L-1&&!G.isOfType(C.COLUMNROWHEADER)){T.focusItem(this,O+P*(L-J-1),i);}else if(J<L){if(!T.isNoDataVisible(this)){T.focusItem(this,O+P*(L-J),i);}}else if(J>=L&&J<L+N-R.fixedBottom-1){T.focusItem(this,O+P*(L+N-R.fixedBottom-J-1),i);}else if(J===L+N-R.fixedBottom-1){var Q=T.getNonEmptyRowCount(this)-R.fixedTop-R.fixedBottom;var U=this._getTotalRowCount()-R.fixedBottom-this.getFirstVisibleRow()-Q*2;s(this,i,true);if(U<Q&&R.fixedBottom>0){T.focusItem(this,O+P*(L+N-J-1),i);}}else{T.focusItem(this,O+P*(L+N-J-1),i);}}}};
b.prototype.onsappageupmodifiers=function(i){h(i);if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(i,null,M.ALT)){var G=T.getCellInfo(i.target);var I=T.getFocusedItemInfo(this);if(G.isOfType(C.DATACELL|C.COLUMNHEADER)){var J=I.cell;var L=I.cellInRow;var N=T.hasRowHeader(this);var R=N?1:0;var P=H;p(i);if(N&&(T.Grouping.isInGroupHeaderRow(i.target)||L===1)){T.focusItem(this,J-L,null);}else if(L-R<P){T.focusItem(this,J-L+R,null);}else{T.focusItem(this,J-P,null);}}else if(G.isOfType(C.ROWACTION)){T.focusItem(this,I.cell-1,null);}}};
b.prototype.onsappagedownmodifiers=function(i){h(i);if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(i,null,M.ALT)){var G=T.getCellInfo(i.target);if(G.isOfType(C.DATACELL|C.ROWHEADER|C.ANYCOLUMNHEADER)){var I=T.getFocusedItemInfo(this);var J=I.cellInRow;var L=T.hasRowHeader(this);var R=L?1:0;var V=T.getVisibleColumnCount(this);var N=parseInt(G.cell.attr("colspan")||1);p(i);if(J+N-R<V){var O=I.cell;var P=H;if(L&&J===0){T.focusItem(this,O+1,null);}else if(N>P){T.focusItem(this,O+N,null);}else if(J+N-R+P>V){T.focusItem(this,O+V-J-1+R,null);}else if(!T.Grouping.isInGroupHeaderRow(i.target)){T.focusItem(this,O+P,null);}}else if(G.isOfType(C.DATACELL)&&T.hasRowActions(this)&&J===I.columnCount-2){T.focusItem(this,I.cell+1,null);}}}};
b.prototype.onsapenter=function(i){x(this,i);};
return b;});
sap.ui.predefine('sap/ui/table/extensions/Pointer',["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/control"],function(E,T,l,D,P,L,q){"use strict";var S=l.SelectionMode;var K=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer","sapMBtnIcon","sapMObjStatusActive"];var a={_getEventPosition:function(e,t){var p;function g(o){if(!t._isTouchEvent(o)){return null;}var f=["touches","targetTouches","changedTouches"];for(var i=0;i<f.length;i++){var s=f[i];if(e[s]&&e[s][0]){return e[s][0];}if(e.originalEvent[s]&&e.originalEvent[s][0]){return e.originalEvent[s][0];}}return null;}p=g(e)||e;return{x:p.pageX,y:p.pageY};},_skipClick:function(e,t,o){if(!o.isOfType(T.CELLTYPE.DATACELL|T.CELLTYPE.ROWACTION)){return false;}if(e.isMarked()){return true;}var f=t.control(0);if(f){var $=f.$();if($.length){for(var i=0;i<K.length;i++){if($.hasClass(K[i])){return typeof f.getEnabled==="function"?f.getEnabled():true;}}}}return false;},_handleClickSelection:function(e,$,t){T.toggleRowSelection(t,$,null,function(r){var s=t._getSelectionPlugin();var o=t.getSelectionMode();if(o===S.Single){if(!s.isIndexSelected(r)){s.setSelectedIndex(r);}else{s.clearSelection();}}else if(e.shiftKey){var i=s.getSelectedIndex();if(i>=0){s.addSelectionInterval(i,r);}else if(s.getSelectedCount()===0){s.setSelectedIndex(r);}}else if(!t._legacyMultiSelection){if(!s.isIndexSelected(r)){s.addSelectionInterval(r,r);}else{s.removeSelectionInterval(r,r);}}else{t._legacyMultiSelection(r,e);}return true;});}};var C={initColumnResizing:function(t,e){if(t._bIsColumnResizerMoving){return;}t._bIsColumnResizerMoving=true;t._bColumnResizerMoved=false;t._iColumnResizeStart=a._getEventPosition(e,t).x;t.$().toggleClass("sapUiTableResizing",true);var $=q(document);var f=t._isTouchEvent(e);t._$colResize=t.$("rsz");$.on((f?"touchend":"mouseup")+".sapUiTableColumnResize",C.exitColumnResizing.bind(t));$.on((f?"touchmove":"mousemove")+".sapUiTableColumnResize",C.onMouseMoveWhileColumnResizing.bind(t));t._disableTextSelection();},exitColumnResizing:function(e){var i=a._getEventPosition(e,this).x;var o=this._getVisibleColumns()[this._iLastHoveredVisibleColumnIndex];var r=this.$().find("th[data-sap-ui-colid=\""+o.getId()+"\"]");var f=r[0].offsetWidth;var g=i-(r.offset().left+(this._bRtlMode?0:f));var h=Math.round(f+g*(this._bRtlMode?-1:1));var n=Math.max(h,T.Column.getMinColumnWidth());C._resizeColumn(this,this._iLastHoveredVisibleColumnIndex,this._bColumnResizerMoved?n:null);},onMouseMoveWhileColumnResizing:function(e){var i=a._getEventPosition(e,this).x;var r=this.$().find(".sapUiTableCnt").offset().left;var f=Math.floor(i-r);if(!this._bColumnResizerMoved&&Math.abs(i-this._iColumnResizeStart)>=5){this._bColumnResizerMoved=true;}this._$colResize.css("left",f+"px");this._$colResize.toggleClass("sapUiTableColRszActive",true);if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault();}},_cleanupColumResizing:function(t){if(t._$colResize){t._$colResize.toggleClass("sapUiTableColRszActive",false);t._$colResize=null;}t._bIsColumnResizerMoving=false;t.$().toggleClass("sapUiTableResizing",false);t._enableTextSelection();var $=q(document);$.off("touchmove.sapUiTableColumnResize");$.off("touchend.sapUiTableColumnResize");$.off("mousemove.sapUiTableColumnResize");$.off("mouseup.sapUiTableColumnResize");},_resizeColumn:function(t,i,n){var v=t._getVisibleColumns();var o;if(i>=0&&i<v.length){o=v[i];if(n!=null){T.Column.resizeColumn(t,t.indexOfColumn(o),n);}}C._cleanupColumResizing(t);o.focus();},doAutoResizeColumn:function(t,i){var v=t._getVisibleColumns(),o;if(i>=0&&i<v.length){o=v[i];if(!o.getAutoResizable()||!o.getResizable()){return;}var n=C._calculateAutomaticColumnWidth.apply(t,[o,i]);if(n){C._resizeColumn(t,i,n);}}},_calculateAutomaticColumnWidth:function(o,i){o=o||this.getColumns()[i];var $=this.$();var e=q("<div>").addClass("sapUiTableHiddenSizeDetector sapUiTableHeaderDataCell sapUiTableDataCell");$.append(e);var f=$.find("td[data-sap-ui-colid = \""+o.getId()+"\"]:not([colspan])").filter(function(g,h){return h.style.display!="none";}).children().clone();f.removeAttr("id");var w=e.append(f).width()+4;w=Math.min(w,$.find(".sapUiTableCnt").width());w=Math.max(w+4,T.Column.getMinColumnWidth());e.remove();return w;},initColumnTracking:function(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").on("mousemove",function(e){var o=this.getDomRef();if(!o||this._bIsColumnResizerMoving){return;}var p=e.clientX,f=o.getBoundingClientRect(),g=0,r=this._bRtlMode?10000:-10000;for(var i=0;i<this._aTableHeaders.length;i++){var h=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if((p<h.right-5)&&(p>=h.left)){g=i;r=h.left-f.left;break;}}else{if((p>h.left+5)&&(p<=h.right)){g=i;r=h.right-f.left;break;}}}var j=this._getVisibleColumns()[g];if(j&&j.getResizable()){this.$("rsz").css("left",r+"px");this._iLastHoveredVisibleColumnIndex=g;}}.bind(t));}};var R={initReordering:function(t,i,e){var o=t.getColumns()[i],$=o.$(),f=t.$();t._disableTextSelection();f.addClass("sapUiTableDragDrop");var g=$.clone();g.find("*").addBack(g).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");g.attr("id",t.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({"left":-10000,"top":-10000,"z-index":P.getNextZIndex()});g.toggleClass(T.getContentDensity(t),true);g.appendTo(document.body);t._$ReorderGhost=t.getDomRef("roghost");f.find("td[data-sap-ui-colid='"+o.getId()+"']").toggleClass("sapUiTableColReorderFade",true);var I=q("<div id='"+t.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");I.appendTo(t.getDomRef("sapUiTableCnt"));t._$ReorderIndicator=t.getDomRef("roind");t._iDnDColIndex=i;var h=q(document),j=t._isTouchEvent(e);h.on((j?"touchend":"mouseup")+".sapUiColumnMove",R.exitReordering.bind(t));h.on((j?"touchmove":"mousemove")+".sapUiColumnMove",R.onMouseMoveWhileReordering.bind(t));},onMouseMoveWhileReordering:function(e){var o=a._getEventPosition(e,this),i=o.x,f=o.y,O=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();var p=R.findColumnForPosition(this,i);if(!p||!p.id){this._iNewColPos=O;return;}var s=40,g=this.getDomRef("sapUiTableColHdrScr"),$=q(g),h=g.getBoundingClientRect(),j=$.outerWidth(),k=this._bRtlMode?$.scrollLeftRTL():$.scrollLeft();this._bReorderScroll=false;if(i>h.left+j-s&&k+j<g.scrollWidth){this._bReorderScroll=true;R.doScroll(this,!this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}else if(i<h.left+s&&k>0){this._bReorderScroll=true;R.doScroll(this,this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}q(this._$ReorderGhost).css({"left":i+5,"top":f+5});if(this._bReorderScroll||!p){return;}if(p.before||(p.after&&p.index==this._iDnDColIndex)){this._iNewColPos=p.index;}else if(p.after&&p.index!=this._iDnDColIndex){this._iNewColPos=p.index+1;}if(!T.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=O;}else{R.adaptReorderMarkerPosition(this,p,true);}},exitReordering:function(e){var o=this._iDnDColIndex;var n=this._iNewColPos;var $=q(document);$.off("touchmove.sapUiColumnMove");$.off("touchend.sapUiColumnMove");$.off("mousemove.sapUiColumnMove");$.off("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;q(this._$ReorderGhost).remove();delete this._$ReorderGhost;q(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();T.Column.moveColumnTo(this.getColumns()[o],n);},findColumnForPosition:function(t,e){var h,H,r,w,p,B,A;for(var i=0;i<t._aTableHeaders.length;i++){h=t._aTableHeaders[i];H=q(h);r=h.getBoundingClientRect();w=H.outerWidth();p={left:r.left,center:r.left+w/2,right:r.left+w,width:w,index:parseInt(H.attr("data-sap-ui-headcolindex")),id:H.attr("data-sap-ui-colid")};B=e>=p.left&&e<=p.center;A=e>=p.center&&e<=p.right;if(B||A){p.before=t._bRtlMode?A:B;p.after=t._bRtlMode?B:A;return p;}}return null;},doScroll:function(t,f){if(t._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(t._mTimeouts.horizontalReorderScrollTimerId);t._mTimeouts.horizontalReorderScrollTimerId=null;}if(t._bReorderScroll){var s=f?30:-30;if(t._bRtlMode){s=(-1)*s;}t._mTimeouts.horizontalReorderScrollTimerId=setTimeout(R.doScroll.bind(t,t,f),60);var $=t.$("sapUiTableColHdrScr");var e=t._bRtlMode?"scrollLeftRTL":"scrollLeft";$[e]($[e]()+s);}},adaptReorderMarkerPosition:function(t,p,s){if(!p||!t._$ReorderIndicator){return;}var i=p.left-t.getDomRef().getBoundingClientRect().left;if(t._bRtlMode&&p.before||!t._bRtlMode&&p.after){i=i+p.width;}q(t._$ReorderIndicator).css({"left":i+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",s);}};var b={ROWAREAS:[".sapUiTableRowSelectionCell",".sapUiTableRowActionCell",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(t){var $=t.$();for(var i=0;i<b.ROWAREAS.length;i++){b._initRowHoveringForArea(t,$,b.ROWAREAS[i]);}},_initRowHoveringForArea:function(t,$,A){$.find(A).on("mouseenter",function(){b._onHover(t,$,A,this);}).on("mouseleave",function(){b._onUnhover(t,$,A,this);});},_onHover:function(t,$,A,e){var i=$.find(A).index(e);var r=t.getRows()[i];if(r){r._setHovered(true);}},_onUnhover:function(t,$,A,e){var i=$.find(A).index(e);var r=t.getRows()[i];if(r){r._setHovered(false);}}};var c={onmousedown:function(e){var p=this._getPointerExtension();var $=T.getCell(this,e.target);var o=T.getCellInfo($);var t=q(e.target);var f;var m;var M;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("rsz")){e.preventDefault();e.stopPropagation();C.initColumnResizing(this,e);}else if(t.hasClass("sapUiTableColResizer")){var i=t.closest(".sapUiTableHeaderCell").attr("data-sap-ui-colindex");this._iLastHoveredVisibleColumnIndex=this._getVisibleColumns().indexOf(this.getColumns()[i]);C.initColumnResizing(this,e);}else if(o.isOfType(T.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=setTimeout(function(){delete p._bShowMenu;},200);}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&t.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(o.columnIndex,e);}}if((D.browser.firefox&&(e.metaKey||e.ctrlKey))||t.closest(".sapUiTableHSb",this.getDomRef()).length===1||t.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault();}}if(e.button===2){if(a._skipClick(e,t,o)){p._bShowDefaultMenu=true;return;}if(o.isOfType(T.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;}else{p._bHideMenu=true;}}else if(o.isOfType(T.CELLTYPE.ANYCONTENTCELL)){p._bShowMenu=true;}else{p._bShowDefaultMenu=true;}}},onmouseup:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);},ondblclick:function(e){if(D.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();C.doAutoResizeColumn(this,this._iLastHoveredVisibleColumnIndex);}},onclick:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return;}var t=q(e.target);var $=T.getCell(this,e.target);var o=T.getCellInfo($);var r=this.getRows()[o.rowIndex];if(!o.isOfType(T.CELLTYPE.ANY)){return;}if(o.isOfType(T.CELLTYPE.COLUMNHEADER)){var p=this._getPointerExtension();if(p._bShowMenu){T.Menu.openContextMenu(this,e.target);delete p._bShowMenu;}}else if(r&&r.isSummary()){e.preventDefault();}else if(t.hasClass("sapUiTableGroupMenuButton")){T.Menu.openContextMenu(this,e.target,e);}else if(t.hasClass("sapUiTableGroupIcon")||t.hasClass("sapUiTableTreeIcon")){r.toggleExpandedState();}else{if(a._skipClick(e,t,o)){return;}var s=window.getSelection().toString();if(!e.shiftKey&&s.length>0&&s!=="\n"){L.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return;}if(!this._findAndfireCellEvent(this.fireCellClick,e)){if(o.isOfType(T.CELLTYPE.COLUMNROWHEADER)){this._getSelectionPlugin().onHeaderSelectorPress();}else{a._handleClickSelection(e,$,this);}}else{e.preventDefault();}}},oncontextmenu:function(e){var p=this._getPointerExtension();if(p._bShowDefaultMenu){e.setMarked("handledByPointerExtension");delete p._bShowDefaultMenu;}else if(p._bShowMenu){var f=T.Menu.openContextMenu(this,e.target,e);if(f){e.preventDefault();}e.setMarked("handledByPointerExtension");delete p._bShowMenu;}else if(p._bHideMenu){e.setMarked("handledByPointerExtension");e.preventDefault();delete p._bHideMenu;}}};
var d=E.extend("sap.ui.table.extensions.Pointer",{
_init:function(t,s,m){this._delegate=c;T.addDelegate(t,this._delegate,t);t._iLastHoveredVisibleColumnIndex=0;t._bIsColumnResizerMoving=false;t._iFirstReorderableIndex=s==E.TABLETYPES.TREE?1:0;return"PointerExtension";},
_attachEvents:function(){var t=this.getTable();if(t){C.initColumnTracking(t);b.initRowHovering(t);}},
_detachEvents:function(){var t=this.getTable();if(t){var $=t.$();$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").off();$.find(".sapUiTableCtrl > tbody > tr").off();$.find(".sapUiTableRowSelectionCell").off();}},
_debug:function(){this._ExtensionHelper=a;this._ColumnResizeHelper=C;this._ReorderHelper=R;this._ExtensionDelegate=c;this._RowHoverHandler=b;this._KNOWNCLICKABLECONTROLS=K;},
doAutoResizeColumn:function(i){var t=this.getTable();if(t){C.doAutoResizeColumn(t,i);}},
doReorderColumn:function(i,e){var t=this.getTable();if(t&&T.Column.isColumnMovable(t.getColumns()[i])){t._mTimeouts.delayedColumnReorderTimerId=setTimeout(function(){R.initReordering(this,i,e);}.bind(t),200);}},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;E.prototype.destroy.apply(this,arguments);}
});
return d;});
sap.ui.predefine('sap/ui/table/extensions/Scrolling',["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery"],function(E,T,l,D,I,L,q){"use strict";var S=l.SharedDomRef;var H=T.Hook.Keys;var c=T.createWeakMapFacade();var M=1000000;var V=2;var d={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};
function e(s,t){L.debug("sap.ui.table.extensions.Scrolling",s,t);}
function P(a,p){var r=true;var C=false;var b=[];var o={cancel:function(){if(this.isCancelled()||!this.isRunning()){return;}C=true;for(var i=0;i<b.length;i++){b[i]();}e("Process cancelled: "+p.id);},isCancelled:function(){return C;},addCancelListener:function(i){b.push(i);},isRunning:function(){return r;},getInfo:function(){return p;},onPromiseCreated:function(i){}};var s;e("Process started: "+p.id);if(typeof a==="function"){s=new Promise(function(){a.apply(this,Array.prototype.slice.call(arguments).concat(o));});}else{s=Promise.resolve();}Object.assign(s,o);s.then(function(){if(o.isCancelled()){e("Process finished due to cancellation: "+p.id);}else{e("Process finished: "+p.id);}r=false;});o.onPromiseCreated(s);return s;}
function f(){this.iIndex=0;this.nOffset=0;this.sOffsetType=f.OffsetType.Pixel;this.bIsInitial=true;}
f.OffsetType={Pixel:"Pixel",Percentage:"Percentage",PercentageOfViewport:"PercentageOfViewport"};
f.prototype.getIndex=function(){return this.iIndex;};
f.prototype.getOffset=function(){return this.nOffset;};
f.prototype.getOffsetType=function(){return this.sOffsetType;};
f.prototype.isOffsetInPixel=function(){return this.sOffsetType===f.OffsetType.Pixel;};
f.prototype.isInitial=function(){return this.bIsInitial;};
f.prototype.setPosition=function(i,a,o){e("ScrollPosition#setPosition(index: "+i+", offset: "+a+", offsetType: "+o+")");if(!f._isPositiveNumber(i)){return;}if(!f._isPositiveNumber(a)){this.nOffset=0;}this.setIndex(i);this.setOffset(a,o);};
f.prototype.setIndex=function(i){e("ScrollPosition#setIndex(index: "+i+")");if(!f._isPositiveNumber(i)){return;}this.bIsInitial=false;this.iIndex=i;};
f.prototype.setOffset=function(a,o){e("ScrollPosition#setOffset(offset: "+a+", offsetType: "+o+")");if(!f._isPositiveNumber(a)){return;}this.bIsInitial=false;this.sOffsetType=o in f.OffsetType?o:f.OffsetType.Pixel;if(this.isOffsetInPixel()){this.nOffset=Math.round(a);}else{this.nOffset=Math.min(a,1);}};
f.prototype.scrollRows=function(r){var N=this.getIndex()+r;var i=this.getOffset();if(!this.isOffsetInPixel()||N<0){i=0;}this.setPosition(Math.max(0,N),i);};
f._isPositiveNumber=function(a){return typeof a==="number"&&!isNaN(a)&&a>=0;};
var g={UpdateFromFirstVisibleRow:{id:"UpdateFromFirstVisibleRow",rank:6},UpdateFromScrollPosition:{id:"UpdateFromScrollPosition",rank:5},RestoreScrollPosition:{id:"RestoreScrollPosition",rank:4},AdjustToTotalRowCount:{id:"AdjustToTotalRowCount",rank:3},OnRowsUpdated:{id:"OnRowsUpdated",rank:3},UpdateFromScrollbar:{id:"UpdateFromScrollbar",rank:2},UpdateFromViewport:{id:"UpdateFromViewport",rank:1},canStart:function(t,p){var a=c(t).pVerticalScrollUpdateProcess;var C=a?a.getInfo():null;if(a&&a.isRunning()&&C.rank>p.rank){e("Cannot start update process "+p.id+" - A higher-ranked update process is currently running ("+C.id+")",t);return false;}return true;},start:function(t,p,a){if(!g.canStart(t,p)){return;}if(c(t).pVerticalScrollUpdateProcess){c(t).pVerticalScrollUpdateProcess.cancel();}c(t).pVerticalScrollUpdateProcess=new P(a,p);}};var h={onScrollbarScroll:function(o){var N=o.target.scrollLeft;var O=o.target._scrollLeft;I.notifyScrollEvent&&I.notifyScrollEvent(o);if(N!==O){var s=h.getScrollAreas(this);o.target._scrollLeft=N;for(var i=0;i<s.length;i++){var a=s[i];if(a!==o.target&&a.scrollLeft!==N){a.scrollLeft=N;a._scrollLeft=N;}}c(this).iHorizontalScrollPosition=N;}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();if(o&&c(t).iHorizontalScrollPosition!==null){var a=h.getScrollAreas(t);for(var i=0;i<a.length;i++){var b=a[i];delete b._scrollLeft;}if(o.scrollLeft!==c(t).iHorizontalScrollPosition){o.scrollLeft=c(t).iHorizontalScrollPosition;}else{var p=q.Event("scroll");p.target=o;h.onScrollbarScroll.call(t,p);}}},updateScrollbar:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();if(!o){return;}var a=t._collectTableSizes();var $=t.$();var C=a.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,t._getColumnsWidth(t.getComputedFixedColumnCount()));}var b=C>a.tableCtrlScrWidth;if(b){if(!s.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");o.classList.remove("sapUiTableHidden");if(D.browser.safari){var i=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");i.outerWidth(C);}}var p=a.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){p+=a.tableRowHdrScrWidth;}if(t._bRtlMode){o.style.marginRight=p+"px";o.style.marginLeft="";}else{o.style.marginLeft=p+"px";o.style.marginRight="";}var r=t.getDomRef("hsb-content");if(r){r.style.width=C+"px";}}if(!b&&s.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");o.classList.add("sapUiTableHidden");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}},onScrollbarMouseDown:function(o){this._getKeyboardExtension().setActionMode(false);},addEventListeners:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();var a=h.getScrollAreas(t);if(!s._onHorizontalScrollEventHandler){s._onHorizontalScrollEventHandler=h.onScrollbarScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}if(o){if(!s._onHorizontalScrollbarMouseDownEventHandler){s._onHorizontalScrollbarMouseDownEventHandler=h.onScrollbarMouseDown.bind(t);}o.addEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();var a=h.getScrollAreas(t);if(s._onHorizontalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete a[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}if(o&&s._onHorizontalScrollbarMouseDownEventHandler){o.removeEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);delete s._onHorizontalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var o=t.getDomRef();var s;if(o){s=Array.prototype.slice.call(t.getDomRef().querySelectorAll(".sapUiTableCtrlScr"));}var a=[t._getScrollExtension().getHorizontalScrollbar()].concat(s);return a.filter(function(b){return b!=null;});}};var j={performUpdateFromFirstVisibleRow:function(t,b){e("VerticalScrollingHelper.performUpdateFromFirstVisibleRow",t);g.start(t,g.UpdateFromFirstVisibleRow,function(r,a,p){T.Hook.call(t,H.Signal,"StartTableUpdate");p.onPromiseCreated=function(i){i.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(b===true){var o=function(){e("VerticalScrollingHelper.performUpdateFromFirstVisibleRow (async: rows update)",t);j._performUpdateFromFirstVisibleRow(t,p).then(r);return false;};j.addOnRowsUpdatedPreprocessor(t,o);p.addCancelListener(function(){var R=j.removeOnRowsUpdatedPreprocessor(t,o);if(R){r();}});}else{j._performUpdateFromFirstVisibleRow(t,p).then(r);}});},_performUpdateFromFirstVisibleRow:function(t,p){return j.adjustScrollPositionToFirstVisibleRow(t,p).then(function(){return j.fixTemporaryFirstVisibleRow(t,null,p);}).then(function(){return j.fixScrollPosition(t,p);}).then(function(){return Promise.all([j.scrollViewport(t,p),j.scrollScrollbar(t,p)]);});},performUpdateFromScrollPosition:function(t){e("VerticalScrollingHelper.performUpdateFromScrollPosition",t);g.start(t,g.UpdateFromScrollPosition,function(r,a,p){T.Hook.call(t,H.Signal,"StartTableUpdate");p.onPromiseCreated=function(o){o.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};j.adjustFirstVisibleRowToScrollPosition(t,null,p).then(function(){if(p.isCancelled()){return;}var s=c(t).oVerticalScrollPosition;e("VerticalScrollingHelper.performUpdateFromScrollPosition (async: firstVisibleRow update)",t);if(s.getIndex()>t.getFirstVisibleRow()){s.setIndex(t.getFirstVisibleRow());if(T.isVariableRowHeightEnabled(t)){s.setOffset(1,f.OffsetType.Percentage);}else{s.setOffset(0);}}}).then(function(){return j.fixScrollPosition(t,p);}).then(function(){return Promise.all([j.scrollViewport(t,p),j.scrollScrollbar(t,p)]);}).then(r);});},performUpdateFromScrollbar:function(t){e("VerticalScrollingHelper.performUpdateFromScrollbar",t);clearTimeout(c(t).mTimeouts.largeDataScrolling);delete c(t).mTimeouts.largeDataScrolling;g.start(t,g.UpdateFromScrollbar,function(r,a,p){T.Hook.call(t,H.Signal,"StartTableUpdate");p.onPromiseCreated=function(o){o.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};t._getKeyboardExtension().setActionMode(false);if(t._bLargeDataScrolling){c(t).mTimeouts.largeDataScrolling=setTimeout(function(){delete c(t).mTimeouts.largeDataScrolling;if(t._getScrollExtension().getVerticalScrollbar()!=null){e("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling)",t);j._performUpdateFromScrollbar(t,p).then(r);}else{e("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling): No scrollbar",t);}},300);p.addCancelListener(function(){if(c(t).mTimeouts.largeDataScrolling!=null){clearTimeout(c(t).mTimeouts.largeDataScrolling);delete c(t).mTimeouts.largeDataScrolling;r();}});}else{j._performUpdateFromScrollbar(t,p).then(r);}});},_performUpdateFromScrollbar:function(t,p){return j.adjustScrollPositionToScrollbar(t,p).then(function(){return j.adjustFirstVisibleRowToScrollPosition(t,null,p);}).then(function(){return j.fixScrollPosition(t,p);}).then(function(){return j.scrollViewport(t,p);});},performUpdateFromViewport:function(t){e("VerticalScrollingHelper.performUpdateFromViewport",t);g.start(t,g.UpdateFromViewport,function(r,a,p){T.Hook.call(t,H.Signal,"StartTableUpdate");p.onPromiseCreated=function(o){o.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};j.adjustScrollPositionToViewport(t,p).then(function(){return j.adjustFirstVisibleRowToScrollPosition(t,true,p);}).then(function(){return j.scrollScrollbar(t,p);}).then(r);});},onScrollbarScroll:function(o){I.notifyScrollEvent&&I.notifyScrollEvent(o);var a=o.target.scrollTop;var b=o.target._scrollTop;var s=a!==b;delete o.target._scrollTop;if(a===0&&!o.target.isConnected){e("VerticalScrollingHelper.onScrollbarScroll: Scrollbar is not connected with the DOM",this);}else if(s){e("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+a+" by interaction",this);j.performUpdateFromScrollbar(this);}else{e("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+a+" by API",this);}},onViewportScroll:function(o){if(!g.canStart(this,g.UpdateFromViewport)){return;}var a=o.target.scrollTop;var b=o.target._scrollTop;delete o.target._scrollTop;if(a!==b){e("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+a+" by interaction",this);j.performUpdateFromViewport(this);}else{e("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+a+" by API",this);}},adjustFirstVisibleRowToScrollPosition:function(t,s,p){if(p&&p.isCancelled()){return Promise.resolve();}s=s===true;var o=c(t).oVerticalScrollPosition;var O=o.getOffsetType()===f.OffsetType.PercentageOfViewport;var N=o.getIndex();var i=t.getFirstVisibleRow();var b=j.isIndexInBuffer(t,N);var a=b||O;e("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition:"+" Set \"firstVisibleRow\" from "+i+" to "+N,t);var r=t._setFirstVisibleRowIndex(N,{onScroll:true,suppressEvent:a,suppressRendering:s});if(!r){if(a){return j.fixTemporaryFirstVisibleRow(t,true,p);}return Promise.resolve();}return new Promise(function(u){var v=function(w){e("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition (async: rows updated):"+" Reason "+w.getParameters().reason,this);if(a){j.fixTemporaryFirstVisibleRow(t,true,p).then(u);}else{u();}return false;};j.addOnRowsUpdatedPreprocessor(t,v);if(p){p.addCancelListener(function(){var R=j.removeOnRowsUpdatedPreprocessor(t,v);if(R){u();}});}});},fixTemporaryFirstVisibleRow:function(t,F,p){if(p&&p.isCancelled()){return Promise.resolve();}F=F===true;var s=c(t).oVerticalScrollPosition;var o=s.getOffsetType()===f.OffsetType.PercentageOfViewport;var i=s.getIndex();var b=j.isIndexInBuffer(t,i);var a=b||o;if(!a){e("VerticalScrollingHelper.fixTemporaryFirstVisibleRow: Aborted - The index is already final",t);return Promise.resolve();}var N=i;var v=j.getScrollRangeOfViewport(t);var r=t._getMaxFirstRenderedRowIndex();var R=t._aRowHeights;var u;e("VerticalScrollingHelper.fixTemporaryFirstVisibleRow",t);if(o){var w=v*s.getOffset();if(b){N=r;}for(u=0;u<R.length;u++){var x=w-R[u];if(x>=0){w=x;N++;}else{break;}}}else if(b){var y=Math.max(0,Math.min(R.length-1,i-r));var z=0;for(u=0;u<y;u++){z+=R[u];if(z>v){N=r+u;break;}}}if(i!==N||F){e("VerticalScrollingHelper.fixTemporaryFirstVisibleRow: Set \"firstVisibleRow\" to "+N,t);t._setFirstVisibleRowIndex(N,{onScroll:true,forceEvent:F,suppressRendering:true});}return Promise.resolve();},adjustScrollPositionToFirstVisibleRow:function(t,p){if(p&&p.isCancelled()){return Promise.resolve();}e("VerticalScrollingHelper.adjustScrollPositionToFirstVisibleRow",t);c(t).oVerticalScrollPosition.setPosition(t.getFirstVisibleRow());return Promise.resolve();},adjustScrollPositionToScrollbar:function(t,p){if(p&&p.isCancelled()){return Promise.resolve();}var s=c(t).oVerticalScrollPosition;var a=j.getScrollPositionOfScrollbar(t);var i=j.getScrollRange(t);var b=j.getScrollRangeRowFraction(t);var N=0;var o=0;var r=f.OffsetType.Percentage;var u;e("VerticalScrollingHelper.adjustScrollPositionToScrollbar",t);if(T.isVariableRowHeightEnabled(t)){if(j.isScrollPositionOfScrollbarInBuffer(t)){var B=j.getScrollRangeBuffer(t);var v=i-B;var w=a-v;var x=w/B;N=t._getMaxFirstRenderedRowIndex();if(j.isIndexInBuffer(t,s.getIndex())){var y=j.getScrollRangeOfViewport(t);var z=y*x;var R=t._aRowHeights;for(var A=0;A<R.length;A++){var C=z-R[A];if(C>=0){z=C;N++;}else{o=Math.round(z);r=f.OffsetType.Pixel;break;}}}else{o=x;r=f.OffsetType.PercentageOfViewport;}}else{u=a/b;N=Math.floor(u);o=u-N;}}else{var F=i-a;var G=F<1;if(G){N=t._getMaxFirstVisibleRowIndex();o=0;r=f.OffsetType.Pixel;}else{u=a/b;N=Math.floor(u);o=u-N;}}s.setPosition(N,o,r);return Promise.resolve();},adjustScrollPositionToViewport:function(t,p){if(p&&p.isCancelled()){return Promise.resolve();}var s=c(t).oVerticalScrollPosition;var r=t._aRowHeights;var N=t._getFirstRenderedRowIndex();var i=0;var a=j.getScrollPositionOfViewport(t);e("VerticalScrollingHelper.adjustScrollPositionToViewport",t);for(var R=0;R<r.length;R++){var b=a-r[R];if(b>=0){a=b;N++;}else{i=Math.round(a);break;}}s.setPosition(N,i);return Promise.resolve();},fixScrollPosition:function(t,p){if(p&&p.isCancelled()){return Promise.resolve();}var s=c(t).oVerticalScrollPosition;var v=t.getDomRef("tableCCnt");var i=j.getScrollRangeOfViewport(t);var r=t._aRowHeights;if(!v||!t.getBinding()){e("VerticalScrollingHelper.fixScrollPosition: Aborted - Viewport or binding not available",t);return Promise.resolve();}e("VerticalScrollingHelper.fixScrollPosition",t);var N=s.getIndex();var a=s.getOffset();var b=0;var R;var F=t._getFirstRenderedRowIndex();switch(s.getOffsetType()){case f.OffsetType.Pixel:case f.OffsetType.Percentage:var o=s.getIndex();var u=0;var C=s.getOffsetType();if(j.isIndexInBuffer(t,o)){var w=0;b=Math.max(0,Math.min(r.length-1,o-F));for(R=0;R<b;R++){w+=r[R];if(w>i){N=F+R;a=i-u;C=f.OffsetType.Pixel;b=R;break;}else{u=w;}}}if(C===f.OffsetType.Pixel){a=Math.min(a,r[b]);}else{a=r[b]*a;}u+=a;if(u>i&&T.isVariableRowHeightEnabled(t)){a-=u-i;}break;case f.OffsetType.PercentageOfViewport:var x=i*s.getOffset();for(R=0;R<r.length;R++){var y=x-r[R];if(y>=0){x=y;b++;}else{N=F+b;a=Math.round(x);break;}}break;default:}s.setPosition(N,a);return Promise.resolve();},scrollViewport:function(t,p){if(p&&p.isCancelled()){return Promise.resolve();}if(!T.isVariableRowHeightEnabled(t)){e("VerticalScrollingHelper.scrollViewport: Aborted - Variable row height not enabled",t);return Promise.resolve();}var s=c(t).oVerticalScrollPosition;var v=t.getDomRef("tableCCnt");var i=j.getScrollRangeOfViewport(t);var r=t._aRowHeights;var a=0;if(i===0){e("VerticalScrollingHelper.scrollViewport: Aborted - No overflow in viewport",t);v.scrollTop=a;v._scrollTop=v.scrollTop;return Promise.resolve();}e("VerticalScrollingHelper.scrollViewport",t);switch(s.getOffsetType()){case f.OffsetType.Pixel:var b=s.getIndex();var o=Math.max(0,Math.min(r.length-1,b-t._getFirstRenderedRowIndex()));for(var R=0;R<o;R++){a+=r[R];}a+=s.getOffset();break;default:e("VerticalScrollingHelper.scrollViewport: The viewport can only be scrolled if the offset is in pixel",t);return Promise.resolve();}e("VerticalScrollingHelper.scrollViewport: Scroll from "+v.scrollTop+" to "+a,t);v.scrollTop=a;v._scrollTop=v.scrollTop;return Promise.resolve();},scrollScrollbar:function(t,p){if(p&&p.isCancelled()){return Promise.resolve();}var s=c(t).oVerticalScrollPosition;var i=s.getIndex();var b=j.getScrollRangeBuffer(t);var a=j.getScrollRange(t);var o=a-b;var r=0;var u=0;var v=j.getScrollRangeOfViewport(t);var R=t._aRowHeights;var w;e("VerticalScrollingHelper.scrollScrollbar",t);if(a===0||R.length===0){e("VerticalScrollingHelper.scrollScrollbar: No scrollable content",t);return Promise.resolve();}switch(s.getOffsetType()){case f.OffsetType.Pixel:if(j.isIndexInBuffer(t,i)){var x=0;w=Math.max(0,Math.min(R.length-1,i-t._getMaxFirstRenderedRowIndex()));for(var y=0;y<w;y++){x+=R[y];}x+=Math.min(R[w],s.getOffset());var z=Math.min(x/v,1);var A=b*z;r=o+A;}else{var B=j.getScrollRangeRowFraction(t);r=i*B;w=Math.max(0,Math.min(R.length-1,i-t._getFirstRenderedRowIndex()));r+=B*Math.min(s.getOffset()/R[w],1);}break;default:e("VerticalScrollingHelper.scrollViewport: The scrollbar can only be scrolled if the offset is in pixel",t);return Promise.resolve();}if(r>0&&r<0.5){u=1;}else if(r>=a-0.5&&r<a){u=a-1;}else{u=Math.round(r);}var C=t._getScrollExtension().getVerticalScrollbar();if(C){e("VerticalScrollingHelper.scrollScrollbar: Scroll from "+C.scrollTop+" to "+u,t);C.scrollTop=u;C._scrollTop=C.scrollTop;}else{e("VerticalScrollingHelper.scrollScrollbar: Not scrolled - No scrollbar available",t);}return Promise.resolve();},getScrollRange:function(t){var s=t._getScrollExtension();var v=s.getVerticalScrollHeight()-s.getVerticalScrollbarHeight();return Math.max(0,v);},getScrollRangeBuffer:function(t){if(!T.isVariableRowHeightEnabled(t)){return 0;}return V*t._getBaseRowHeight();},getScrollPositionOfScrollbar:function(t){var s=t._getScrollExtension();if(s.isVerticalScrollbarVisible()){return s.getVerticalScrollbar().scrollTop;}else{return 0;}},getScrollPositionOfViewport:function(t){var v=t?t.getDomRef("tableCCnt"):null;return v?v.scrollTop:0;},getScrollRangeRowFraction:function(t){var s=t._getScrollExtension();var v=t._getTotalRowCount()-t._getRowCounts()._fullsize;var i;if(T.isVariableRowHeightEnabled(t)){i=j.getScrollRange(t)-j.getScrollRangeBuffer(t);var b=s.getVerticalScrollHeight()===M;if(!b){i+=t._getBaseRowHeight();}}else{i=j.getScrollRange(t);}return i/Math.max(1,v);},isScrollPositionOfScrollbarInBuffer:function(t){if(!T.isVariableRowHeightEnabled(t)){return false;}var s=j.getScrollRange(t);var a=j.getScrollPositionOfScrollbar(t);var i=j.getScrollRangeBuffer(t);return s-a<=i;},isIndexInBuffer:function(t,i){if(!T.isVariableRowHeightEnabled(t)){return false;}return i>=t._getMaxFirstRenderedRowIndex();},getScrollRangeOfViewport:function(t){if(!t||!t._aRowHeights){return 0;}var r=t._aRowHeights;var v=t._getBaseRowHeight()*t._getRowCounts()._fullsize;if(t._getRowCounts()._fullsize>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var i=r.reduce(function(a,b){return a+b;},0)-v;if(i>0){i=Math.ceil(i);}return Math.max(0,i);},addOnRowsUpdatedPreprocessor:function(t,p){c(t).aOnRowsUpdatedPreprocessors.push(p);},removeOnRowsUpdatedPreprocessor:function(t,p){if(!p){c(t).aOnRowsUpdatedPreprocessors=[];return false;}var i=c(t).aOnRowsUpdatedPreprocessors.indexOf(p);if(i>-1){c(t).aOnRowsUpdatedPreprocessors.splice(i,1);return true;}return false;},onRowsUpdated:function(o){e("VerticalScrollingHelper.onRowsUpdated: Reason "+o.getParameters().reason,this);j.updateScrollbarVisibility(this);if(c(this).aOnRowsUpdatedPreprocessors.length>0){e("VerticalScrollingHelper.onRowsUpdated (preprocessors)",this);var b=c(this).aOnRowsUpdatedPreprocessors.reduce(function(b,p){var _=p.call(this,o);return!(b&&!_);},true);j.removeOnRowsUpdatedPreprocessor(this);if(!b){e("VerticalScrollingHelper.onRowsUpdated (preprocessors): Default prevented",this);return;}}if(!T.isVariableRowHeightEnabled(this)){e("VerticalScrollingHelper.onRowsUpdated: Aborted - Variable row heights not enabled",this);return;}var t=this;g.start(this,g.OnRowsUpdated,function(r,a,p){T.Hook.call(t,H.Signal,"StartTableUpdate");p.onPromiseCreated=function(i){i.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};j.fixScrollPosition(t,p).then(function(){return Promise.all([j.adjustFirstVisibleRowToScrollPosition(t,true,p),j.scrollViewport(t,p),j.scrollScrollbar(t,p)]);}).then(r);});},restoreScrollPosition:function(t,b){e("VerticalScrollingHelper.restoreScrollPosition",t);g.start(t,g.RestoreScrollPosition,function(r,a,p){T.Hook.call(t,H.Signal,"StartTableUpdate");p.onPromiseCreated=function(i){i.then(function(){if(!p.isCancelled()){j._restoreScrollPosition(t);}}).finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(b!==true){r();return;}var o=function(){e("VerticalScrollingHelper.restoreScrollPosition (async: rows updated)",t);r();return false;};j.addOnRowsUpdatedPreprocessor(t,o);p.addCancelListener(function(){var R=j.removeOnRowsUpdatedPreprocessor(t,o);if(R){r();}});});},_restoreScrollPosition:function(t){var s=c(t).oVerticalScrollPosition;var b=s.isInitial();e("VerticalScrollingHelper.restoreScrollPosition: "+"Scroll position is"+(b?" ":" not ")+"initial",t);if(b){j.performUpdateFromFirstVisibleRow(t);}else{j.performUpdateFromScrollPosition(t);}},onTotalRowCountChanged:function(){j.adjustToTotalRowCount(this);},adjustToTotalRowCount:function(t){var s=t._getScrollExtension();e("VerticalScrollingHelper.adjustToTotalRowCount",t);j.updateScrollbarVisibility(t);h.updateScrollbar(t);s.updateVerticalScrollHeight();g.start(t,g.AdjustToTotalRowCount,function(r,a,p){T.Hook.call(t,H.Signal,"StartTableUpdate");p.onPromiseCreated=function(b){b.then(function(){if(p.isCancelled()||c(t).oVerticalScrollPosition.isInitial()){return;}j.performUpdateFromScrollPosition(t);}).finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(c(t).oVerticalScrollPosition.isInitial()){r();}else{var o=function(){e("VerticalScrollingHelper.adjustToTotalRowCount (async: rows updated)",t);r();return false;};j.addOnRowsUpdatedPreprocessor(t,o);p.addCancelListener(function(){var R=j.removeOnRowsUpdatedPreprocessor(t,o);if(R){r();}});}});},onUpdateTableSizes:function(r){j.updateScrollbarVisibility(this);h.updateScrollbar(this);},updateScrollbarVisibility:function(t){var s=t._getScrollExtension();var v=s.getVerticalScrollbar();var o=t?t.getDomRef():null;if(!v||!o){return;}var b=s.isVerticalScrollbarRequired();o.classList.toggle("sapUiTableVScr",b&&!s.isVerticalScrollbarExternal());v.parentElement.classList.toggle("sapUiTableHidden",!b);},addEventListeners:function(t){var s=t._getScrollExtension();var a=j.getScrollAreas(t);var v=t.getDomRef("tableCCnt");if(!s._onVerticalScrollEventHandler){s._onVerticalScrollEventHandler=j.onScrollbarScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v){if(!s._onViewportScrollEventHandler){s._onViewportScrollEventHandler=j.onViewportScroll.bind(t);}v.addEventListener("scroll",s._onViewportScrollEventHandler);}t.attachRowsUpdated(j.onRowsUpdated);},removeEventListeners:function(t){var s=t._getScrollExtension();var a=j.getScrollAreas(t);var v=t.getDomRef("tableCCnt");if(s._onVerticalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v&&s._onViewportScrollEventHandler){v.removeEventListener("scroll",s._onViewportScrollEventHandler);delete s._onViewportScrollEventHandler;}t.detachRowsUpdated(j.onRowsUpdated);},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(o){return o!=null;});}};var k={onMouseWheelScrolling:function(o,a){var s=this._getScrollExtension();var v=Math.abs(a.deltaY)>Math.abs(a.deltaX);var i=v?a.deltaY:a.deltaX;var b=v&&a.shiftKey||!v;var p=i>0;var r=false;if(i===0){return;}if(b&&(o.scrollDirection===d.HORIZONAL||o.scrollDirection===d.BOTH)){var t=s.getHorizontalScrollbar();if(a.deltaMode!==window.WheelEvent.DOM_DELTA_PIXEL){var u=T.Column.getMinColumnWidth();i=p?u:-u;}if(p){r=t.scrollLeft===t.scrollWidth-t.offsetWidth;}else{r=t.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!r){a.preventDefault();a.stopPropagation();this._getKeyboardExtension().setActionMode(false);t.scrollLeft=t.scrollLeft+i;}}else if(!b&&(o.scrollDirection===d.VERTICAL||o.scrollDirection===d.BOTH)){var w=s.getVerticalScrollbar();var x=c(this).oVerticalScrollPosition;if(p){r=w.scrollTop===w.scrollHeight-w.offsetHeight;}else{r=w.scrollTop===0;}if(!s.isVerticalScrollbarVisible()||r){return;}a.preventDefault();a.stopPropagation();if(a.deltaMode===window.WheelEvent.DOM_DELTA_PIXEL){var y=i/this._getDefaultRowHeight();if(y>=0){x.scrollRows(Math.max(1,Math.floor(y)));}else{x.scrollRows(Math.min(-1,Math.ceil(y)));}}else if(a.deltaMode===window.WheelEvent.DOM_DELTA_LINE){x.scrollRows(i);}else if(a.deltaMode===window.WheelEvent.DOM_DELTA_PAGE){x.scrollRows(i*this._getRowCounts()._scrollSize);}this._getKeyboardExtension().setActionMode(false);j.performUpdateFromScrollPosition(this);}},onTouchStart:function(o,a){if(a.type==="touchstart"||a.pointerType==="touch"){var s=this._getScrollExtension();var b=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=a.touches?a.touches[0]:a;c(this).mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v?v.scrollTop:0,initialScrollLeft:b?b.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(o,a){if(a.type!=="touchmove"&&a.pointerType!=="touch"){return;}var s=this._getScrollExtension();var t=c(this).mTouchSessionData;if(!t){return;}var b=a.touches?a.touches[0]:a;var i=(b.pageX-t.initialPageX);var p=(b.pageY-t.initialPageY);var r=false;if(!t.touchMoveDirection){if(i===0&&p===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(p)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var u=s.getHorizontalScrollbar();if(u&&(o.scrollDirection===d.HORIZONAL||o.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(i<0){t.initialScrolledToEnd=u.scrollLeft===u.scrollWidth-u.offsetWidth;}else{t.initialScrolledToEnd=u.scrollLeft===0;}}if(!t.initialScrolledToEnd){u.scrollLeft=t.initialScrollLeft-i;r=true;}}break;case"vertical":var v=s.getVerticalScrollbar();if(v&&(o.scrollDirection===d.VERTICAL||o.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(p<0){t.initialScrolledToEnd=v.scrollTop===v.scrollHeight-v.offsetHeight;}else{t.initialScrolledToEnd=v.scrollTop===0;}}if(!t.initialScrolledToEnd){v.scrollTop=t.initialScrollTop-p;r=true;}}break;default:}if(r){a.preventDefault();}},addEventListeners:function(t){var s=t._getScrollExtension();var a=k.getEventListenerTargets(t);s._mMouseWheelEventListener=this.addMouseWheelEventListener(a,t,{scrollDirection:d.BOTH});s._mTouchEventListener=this.addTouchEventListener(a,t,{scrollDirection:d.BOTH});},addMouseWheelEventListener:function(a,t,o){var O=k.onMouseWheelScrolling.bind(t,o);for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",O);}return{wheel:O};},addTouchEventListener:function(a,t,o){var O=k.onTouchStart.bind(t,o);var b=k.onTouchMoveScrolling.bind(t,o);var p={};for(var i=0;i<a.length;i++){if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",O);a[i].addEventListener("pointermove",b,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",O);a[i].addEventListener("touchmove",b);}}if(D.support.pointer&&D.system.desktop){p={pointerdown:O,pointermove:b};}else if(D.support.touch){p={touchstart:O,touchmove:b};}return p;},removeEventListeners:function(t){var s=t._getScrollExtension();var a=k.getEventListenerTargets(t);function r(o,b){for(var p in b){var u=b[p];if(u){o.removeEventListener(p,u);}}}for(var i=0;i<a.length;i++){r(a[i],s._mMouseWheelEventListener);r(a[i],s._mTouchEventListener);}delete s._mMouseWheelEventListener;delete s._mTouchEventListener;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(o){return o!=null;});}};var m={onBeforeRendering:function(o){this._getScrollExtension()._clearCache();},onAfterRendering:function(o){var s=this._getScrollExtension();var r=o!=null&&o.isMarked("renderRows");if(r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}else{j.restoreScrollPosition(this,this.getBinding()!=null);}h.restoreScrollPosition(this);},onfocusin:function(o){var r;var C=T.getCellInfo(o.target);var a=this._getScrollExtension().getHorizontalScrollbar();if(C.isOfType(T.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(T.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r&&a&&C.columnIndex>=this.getComputedFixedColumnCount()){var $=q(a);var b=C.cell[0];var i=this._bRtlMode?$.scrollLeftRTL():a.scrollLeft;var R=r.clientWidth;var p=b.offsetLeft;var s=p+b.offsetWidth;var O=p-i;var t=s-R-i;var N;if(O<0&&t<0){N=i+O;}else if(t>0&&O>0){N=i+t;}if(N!=null){if(this._bRtlMode){$.scrollLeftRTL(N);}else{a.scrollLeft=N;}}}var u=T.getParentCell(this,o.target);if(u){var v=this;var w=function(){var x=u.find(".sapUiTableCellInner");if(x.length>0){if(v._bRtlMode){x.scrollLeftRTL(x[0].scrollWidth-x[0].clientWidth);}else{x[0].scrollLeft=0;}x[0].scrollTop=0;}T.Hook.call(v,H.Signal,"EndFocusHandling");T.Hook.call(v,H.Signal,"EndTableUpdate");};T.Hook.call(this,H.Signal,"StartTableUpdate");T.Hook.call(this,H.Signal,"StartFocusHandling");Promise.resolve().then(function(){if(D.browser.safari){window.setTimeout(w,0);}else{w();}});}}};
var n=E.extend("sap.ui.table.extensions.Scrolling",{
_init:function(t,s,a){var _=c(t);_.oHorizontalScrollbar=null;_.iHorizontalScrollPosition=null;_.oVerticalScrollbar=null;_.oVerticalScrollPosition=new f(t);_.pVerticalScrollUpdateProcess=null;_.oExternalVerticalScrollbar=null;_.bIsVerticalScrollbarExternal=false;_.mTimeouts={};_.mAnimationFrames={};_.mTouchSessionData=null;_.aOnRowsUpdatedPreprocessors=[];T.addDelegate(t,m,t);return"ScrollExtension";},
_attachEvents:function(){var t=this.getTable();h.addEventListeners(t);j.addEventListeners(t);k.addEventListeners(t);T.Hook.register(t,T.Hook.Keys.Table.TotalRowCountChanged,j.onTotalRowCountChanged,t);T.Hook.register(t,T.Hook.Keys.Table.UpdateSizes,j.onUpdateTableSizes,t);},
_detachEvents:function(){var t=this.getTable();h.removeEventListeners(t);j.removeEventListeners(t);k.removeEventListeners(t);T.Hook.deregister(t,T.Hook.Keys.Table.TotalRowCountChanged,j.onTotalRowCountChanged,t);T.Hook.deregister(t,T.Hook.Keys.Table.UpdateSizes,j.onUpdateTableSizes,t);},
destroy:function(){var t=this.getTable();this._clearCache();if(t){T.removeDelegate(t,m);if(c(t).pVerticalScrollUpdateProcess){c(t).pVerticalScrollUpdateProcess.cancel();c(t).pVerticalScrollUpdateProcess=null;}}E.prototype.destroy.apply(this,arguments);}
});
n.prototype.scrollVertically=function(b,p){var t=this.getTable();if(!t){return;}var r=t._getRowCounts();var F=t._getFirstRenderedRowIndex();var s=p===true?r.scrollable:1;if(b===true){c(t).oVerticalScrollPosition.setPosition(F+s,1,f.OffsetType.PercentageOfViewport);}else{c(t).oVerticalScrollPosition.setPosition(Math.max(0,F-s));}j.performUpdateFromScrollPosition(t);};
n.prototype.scrollVerticallyMax=function(b){var t=this.getTable();if(!t){return;}if(b===true){c(t).oVerticalScrollPosition.setPosition(t._getMaxFirstRenderedRowIndex(),1,f.OffsetType.PercentageOfViewport);}else{c(t).oVerticalScrollPosition.setPosition(0);}j.performUpdateFromScrollPosition(t);};
n.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(!t){return null;}if(!t._bInvalid&&!c(t).oHorizontalScrollbar){c(t).oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return c(t).oHorizontalScrollbar;};
n.prototype.getVerticalScrollbar=function(){var t=this.getTable();var i=this.isVerticalScrollbarExternal();if(!t){return null;}if(!t._bInvalid&&!c(t).oVerticalScrollbar){c(t).oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);if(!c(t).oVerticalScrollbar&&i){c(t).oVerticalScrollbar=c(t).oExternalVerticalScrollbar;}}var s=c(t).oVerticalScrollbar;if(s&&!i&&!s.isConnected){return null;}return s;};
n.prototype.isHorizontalScrollbarVisible=function(){var o=this.getHorizontalScrollbar();return o!=null&&!o.classList.contains("sapUiTableHidden");};
n.prototype.isVerticalScrollbarVisible=function(){var v=this.getVerticalScrollbar();return v!=null&&!v.parentElement.classList.contains("sapUiTableHidden");};
n.prototype.isVerticalScrollbarExternal=function(){var t=this.getTable();return t?c(t).bIsVerticalScrollbarExternal:false;};
n.prototype.markVerticalScrollbarAsExternal=function(s){var t=this.getTable();if(t&&s){c(t).bIsVerticalScrollbarExternal=true;c(t).oExternalVerticalScrollbar=s;}};
n.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}v.style.maxHeight=this.getVerticalScrollbarHeight()+"px";v._scrollTop=v.scrollTop;};
n.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(!t){return 0;}return t._getRowCounts()._scrollSize*t._getBaseRowHeight();};
n.prototype.updateVerticalScrollPosition=function(b){var t=this.getTable();if(!t){return;}b=b===true;if(b||t.getBinding()){j.performUpdateFromFirstVisibleRow(t,b);}else{j.adjustScrollPositionToFirstVisibleRow(t);}};
n.prototype.restoreVerticalScrollPosition=function(){j.restoreScrollPosition(this.getTable());};
n.prototype.updateVerticalScrollHeight=function(){var v=this.getVerticalScrollbar();var o=v?v.firstChild:null;if(!o){return;}o.style.height=this.getVerticalScrollHeight()+"px";v._scrollTop=v.scrollTop;};
n.prototype.getVerticalScrollHeight=function(b){var t=this.getTable();if(!t){return 0;}var i=t._getTotalRowCount();var r=t._getRowCounts();var R=Math.max(i,r.count);var B=t._getBaseRowHeight();var s;if(T.isVariableRowHeightEnabled(t)){s=B*(R-1)+j.getScrollRangeBuffer(t);}else{s=B*R;}if(b===true){return s;}else{return Math.min(M,s);}};
n.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(!t){return false;}return T.isVariableRowHeightEnabled(t)&&j.getScrollRangeOfViewport(t)>0||t._getTotalRowCount()>t._getRowCounts()._fullsize;};
n.prototype.registerForMouseWheel=function(a,o){var t=this.getTable();if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){return k.addMouseWheelEventListener(a,t,o);}else{L.error("This method can only be used with synchronization enabled.",t,"sap.ui.table.extensions.Scrolling#registerForMouseWheel");return null;}};
n.prototype.registerForTouch=function(a,o){var t=this.getTable();if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){return k.addTouchEventListener(a,t,o);}else{L.error("This method can only be used with synchronization enabled.",t,"sap.ui.table.extensions.Scrolling#registerForTouch");return null;}};
n.prototype._clearCache=function(){var t=this.getTable();if(!t){return;}c(t).oVerticalScrollbar=null;c(t).oHorizontalScrollbar=null;};
n.ScrollDirection=d;return n;});
sap.ui.predefine('sap/ui/table/extensions/ScrollingIOS',["./ExtensionBase","../utils/TableUtils"],function(E,T){"use strict";var a={onAfterRendering:function(){this.attachScrollbar();}};
var S=E.extend("sap.ui.table.extensions.ScrollingIOS",{
_init:function(t){T.addDelegate(t,a,this);this.attachScrollbar();return"ScrollIOSExtension";},
destroy:function(){var t=this.getTable();T.removeDelegate(t,a);clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);E.prototype.destroy.apply(this,arguments);},
_attachEvents:function(){var t=this.getTable();T.Hook.register(t,T.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);T.Hook.register(t,T.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this);},
_detachEvents:function(){var t=this.getTable();var v=t._getScrollExtension().getVerticalScrollbar();if(v){v.removeEventListener("scroll",this._onVerticalScrollEventHandler);}delete this._onVerticalScrollEventHandler;var V=this.getVerticalScrollbar();if(V){V.removeEventListener("pointerdown",this._onPointerDownEventHandler);}delete this._onPointerDownEventHandler;var o=this.getVerticalScrollbarThumb();if(o){o.removeEventListener("touchmove",this._onTouchMoveEventHandler);}delete this._onTouchMoveEventHandler;T.Hook.deregister(t,T.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);T.Hook.deregister(t,T.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this);}
});
S.prototype.onUpdateTableSizes=function(){this.updateVerticalScrollbarThumbHeight();this.updateVerticalScrollbarThumbPosition();};
S.prototype.onTotalRowCountChanged=function(){this.updateVerticalScrollbarThumbHeight();};
S.prototype.attachScrollbar=function(){var t=this.getTable();var v=t._getScrollExtension().getVerticalScrollbar();var V=this.getVerticalScrollbar();var o=this.getVerticalScrollbarThumb();if(!v){return;}if(!V){V=document.createElement("div");V.setAttribute("id",t.getId()+"-vsb-ios");V.classList.add("sapUiTableVSbIOS");o=document.createElement("div");o.classList.add("sapUiTableVSbIOSThumb");V.append(o);v.after(V);}if(!this._onPointerDownEventHandler){this._onPointerDownEventHandler=this.onPointerDown.bind(this);V.addEventListener("pointerdown",this._onPointerDownEventHandler);this._onTouchMoveEventHandler=this.onTouchMove.bind(this);o.addEventListener("touchmove",this._onTouchMoveEventHandler);this._onVerticalScrollEventHandler=this.updateVerticalScrollbarThumbPosition.bind(this);v.addEventListener("scroll",this._onVerticalScrollEventHandler);}this.updateVerticalScrollbar();};
S.prototype.getVerticalScrollbar=function(){var t=this.getTable();return t?t.getDomRef("vsb-ios"):null;};
S.prototype.getVerticalScrollbarThumb=function(){var v=this.getVerticalScrollbar();return v?v.firstElementChild:null;};
S.prototype.updateVerticalScrollbar=function(){var t=this.getTable();var v=this.getVerticalScrollbar();v.style.height=t._getScrollExtension().getVerticalScrollbarHeight()+"px";v.style.top=Math.max(0,t._getRowCounts().fixedTop*t._getBaseRowHeight()-1)+"px";this.updateVerticalScrollbarThumbPosition();this.updateVerticalScrollbarThumbHeight();};
S.prototype.updateVerticalScrollbarThumbPosition=function(){var v=this.getVerticalScrollbarThumb();if(v){v.style.top=this.getCalculateThumbOffset()+"px";}};
S.prototype.updateVerticalScrollbarThumbHeight=function(){var t=this.getTable();var s=t._getScrollExtension();var v=this.getVerticalScrollbarThumb();if(v){if(s.isVerticalScrollbarRequired()){v.style.height=this.getCalculateThumbHeight()+"px";}else{v.style.height="0";}}};
S.prototype.getCalculateThumbHeight=function(){var t=this.getTable();var s=t._getScrollExtension();var v=s.getVerticalScrollbarHeight();var V=s.getVerticalScrollHeight();return Math.round(Math.pow(v,2)/V);};
S.prototype.getCalculateThumbOffset=function(){var t=this.getTable();var s=t._getScrollExtension();var v=s.getVerticalScrollbarHeight();var V=s.getVerticalScrollHeight();var o=s.getVerticalScrollbar();var i=o?s.getVerticalScrollbar().scrollTop:0;return Math.round(i*v/V);};
S.prototype.onTouchMove=function(e){var t=this.getTable();var s=t._getScrollExtension();var v=this.getVerticalScrollbarThumb();var i=v.getBoundingClientRect().y;var b=this.getCalculateThumbHeight();var c=v.offsetTop+e.touches[0].pageY-i-b/2;var o=Math.min(s.getVerticalScrollbarHeight()-b,Math.max(0,c));e.preventDefault();e.stopPropagation();v.style.top=o+"px";clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);this._iUpdateDefaultScrollbarPositionTimeoutId=setTimeout(function(){this.updateDefaultScrollbarPosition(o,b);delete this._iUpdateDefaultScrollbarPositionTimeoutId;}.bind(this),30);};
S.prototype.onPointerDown=function(e){var t=this.getTable();var s=t._getScrollExtension();var v=this.getVerticalScrollbarThumb();var i=v.getBoundingClientRect().y;var b=this.getCalculateThumbHeight();var c=v.offsetTop+e.clientY-i-b/2;var o=Math.min(s.getVerticalScrollbarHeight()-b,Math.max(0,c));e.preventDefault();e.stopPropagation();v.style.top=o+"px";this.updateDefaultScrollbarPosition(o,b);};
S.prototype.updateDefaultScrollbarPosition=function(o,t){var b=this.getTable();if(!b){return;}var s=b._getScrollExtension();var i=s.getVerticalScrollbarHeight();if(o+t>=i){s.scrollVerticallyMax(true);}else{var c=o*s.getVerticalScrollHeight()/i;var v=s.getVerticalScrollbar();v.scrollTop=c;}};
return S;});
sap.ui.predefine('sap/ui/table/extensions/Synchronization',["./ExtensionBase","../Table","../utils/TableUtils","../library","sap/base/Log"],function(E,T,a,l,L){"use strict";var b={setRowSelection:function(i,s){var t=this.getTable();var r=t.getRows()[i];if(r&&s!=null){a.toggleRowSelection(t,r.getIndex(),s);}},setRowHover:function(i,h){var t=this.getTable();var r=t.getRows()[i];if(r&&h!=null){r._setHovered(h);}},addVerticalScrollingListener:function(C){var t=this.getTable();var s=t._getScrollExtension();var d=s.constructor.ScrollDirection;if(C){s.registerForMouseWheel(C.wheelAreas,{scrollDirection:d.VERTICAL});s.registerForTouch(C.touchAreas,{scrollDirection:d.VERTICAL});}},placeVerticalScrollbarAt:function(h){var t=this.getTable();var s=t._getScrollExtension();if(!h){throw new Error("The HTMLElement in which the vertical scrollbar should be placed must be specified.");}if(!s.isVerticalScrollbarExternal()){var r=sap.ui.getCore().createRenderManager();t.getRenderer().renderVSbExternal(r,t);r.flush(h);var e=h.querySelector("#"+t.getId()+"-"+l.SharedDomRef.VerticalScrollBar);s.markVerticalScrollbarAsExternal(e);t.invalidate();}else{h.appendChild(s.getVerticalScrollbar().parentElement);s.restoreVerticalScrollPosition();}},renderHorizontalScrollbar:function(r,i,s){var t=this.getTable();if(i==null){throw new Error("The id must be specified.");}t.getRenderer().renderHSbExternal(r,t,i,s);}};var c={onBeforeRendering:function(e){var s=this._getSyncExtension();var r=e&&e.isMarked("renderRows");var C=this.getDomRef("tableCCnt");if(!r&&C&&s._onTableContainerScrollEventHandler){C.removeEventListener("scroll",s._onTableContainerScrollEventHandler);delete s._onTableContainerScrollEventHandler;}},onAfterRendering:function(e){var s=this._getScrollExtension();var r=e&&e.isMarked("renderRows");var C=this.getDomRef("tableCCnt");if(s.isVerticalScrollbarExternal()&&!r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}if(!r){var o=this._getSyncExtension();o.syncInnerVerticalScrollPosition(C.scrollTop);if(!o._onTableContainerScrollEventHandler){o._onTableContainerScrollEventHandler=function(e){o.syncInnerVerticalScrollPosition(e.target.scrollTop);};}C.addEventListener("scroll",o._onTableContainerScrollEventHandler);}}};
var S=E.extend("sap.ui.table.extensions.Synchronization",{
_init:function(t,s,m){this._delegate=c;this._oPublicInterface={syncRowSelection:b.setRowSelection.bind(this),syncRowHover:b.setRowHover.bind(this),registerVerticalScrolling:b.addVerticalScrollingListener.bind(this),placeVerticalScrollbarAt:b.placeVerticalScrollbarAt.bind(this),renderHorizontalScrollbar:b.renderHorizontalScrollbar.bind(this)};a.addDelegate(t,this._delegate,t);return"SyncExtension";},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;this._oPublicInterface=null;E.prototype.destroy.apply(this,arguments);}
});
S.prototype.syncRowCount=function(C){this.callInterfaceHook("rowCount",arguments);};
S.prototype.syncRowSelection=function(i,s){this.callInterfaceHook("rowSelection",arguments);};
S.prototype.syncRowHover=function(i,h){this.callInterfaceHook("rowHover",arguments);};
S.prototype.syncRowHeights=function(h){return this.callInterfaceHook("rowHeights",arguments);};
S.prototype.syncInnerVerticalScrollPosition=function(s){this.callInterfaceHook("innerVerticalScrollPosition",arguments);};
S.prototype.syncLayout=function(m){this.callInterfaceHook("layout",arguments);};
S.prototype.callInterfaceHook=function(h,A){var C={};C[h]=Array.prototype.slice.call(A);L.debug("sap.ui.table.extensions.Synchronization","Sync "+h+"("+C[h]+")",this.getTable());return a.dynamicCall(this._oPublicInterface,C);};
S.prototype.getInterface=function(){return this._oPublicInterface;};
return S;});
sap.ui.predefine('sap/ui/table/library',['sap/ui/core/Core','sap/ui/model/TreeAutoExpandMode','sap/ui/core/library','sap/ui/unified/library'],function(C,T){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.98.0",dependencies:["sap.ui.core","sap.ui.unified"],designtime:"sap/ui/table/designtime/library.designtime",types:["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.TreeAutoExpandMode"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.CreationRow","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings","sap.ui.table.rowmodes.RowMode","sap.ui.table.rowmodes.FixedRowMode","sap.ui.table.rowmodes.InteractiveRowMode","sap.ui.table.rowmodes.AutoRowMode","sap.ui.table.plugins.MultiSelectionPlugin","sap.ui.table.plugins.SelectionPlugin"],extensions:{flChangeHandlers:{"sap.ui.table.Table":{"moveElements":"default"},"sap.ui.table.AnalyticalTable":{"moveElements":"default"}},"sap.ui.support":{publicRules:true}}});var t=sap.ui.table;t.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};t.RowActionType={Custom:"Custom",Navigation:"Navigation",Delete:"Delete"};t.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};t.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};t.SortOrder={Ascending:"Ascending",Descending:"Descending"};t.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};t.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};t.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};t.ResetAllMode={Default:"Default",ServiceDefault:"ServiceDefault",ServiceReset:"ServiceReset"};t.ColumnHeader=t.Column;t.TreeAutoExpandMode=T;if(!t.TableHelper){t.TableHelper={addTableClass:function(){return"";},createLabel:function(c){throw new Error("no Label control available!");},createTextView:function(c){throw new Error("no TextView control available!");},bFinal:false};}return t;});
sap.ui.predefine('sap/ui/table/plugins/BindingSelection',['./SelectionPlugin',"../utils/TableUtils",'../library'],function(S,T,l){"use strict";var a=l.SelectionMode;
var B=S.extend("sap.ui.table.plugins.BindingSelection",{metadata:{library:"sap.ui.table",events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});
B.prototype.onDeactivate=function(t){S.prototype.onDeactivate.apply(this,arguments);d(this,this.getTableBinding());};
B.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:T.hasSelectAll(this.getTable())}};};
B.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){this.getTable()._toggleSelectAll();}};
B.prototype.onKeyboardShortcut=function(t){if(t==="toggle"){this.getTable()._toggleSelectAll();}else if(t==="clear"){this.clearSelection();}};
B.prototype.addSelectionInterval=function(i,I){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.addSelectionInterval){if(this._getSelectionMode()===a.Single){i=I;o.setSelectionInterval(i,I);}o.addSelectionInterval(i,I);}};
B.prototype.clearSelection=function(){var o=this.getTableBinding();if(o&&o.clearSelection){o.clearSelection();}};
B.prototype.getSelectedIndex=function(){var o=this.getTableBinding();if(o&&o.findNode){return o.getSelectedIndex();}else{return-1;}};
B.prototype.getSelectedIndices=function(){var o=this.getTableBinding();if(this._getSelectionMode()===a.Single){var s=this.getSelectedIndex();if(s===-1){return[];}return[s];}if(o&&o.findNode&&o.getSelectedIndices){return o.getSelectedIndices();}else{return[];}};
B.prototype.getSelectableCount=function(){var o=this.getTableBinding();if(!o){return 0;}else if(o.getGrandTotalContextInfo){var r=o.getGrandTotalContextInfo();return r?r.totalNumberOfLeafs:0;}else{return o.getLength();}};
B.prototype.getSelectedCount=function(){var o=this.getTableBinding();if(o&&o.getSelectedNodesCount){return o.getSelectedNodesCount();}else{return 0;}};
B.prototype.isIndexSelectable=function(i){var o=this.getTableBinding();if(o){return o.isIndexSelectable(i);}else{return false;}};
B.prototype.isIndexSelected=function(i){var o=this.getTableBinding();if(this._getSelectionMode()===a.Single){if(i<0){return false;}return i===this.getSelectedIndex();}if(o&&o.isIndexSelected){return o.isIndexSelected(i);}else{return false;}};
B.prototype.removeSelectionInterval=function(i,I){var o=this.getTableBinding();if(o&&o.findNode&&o.removeSelectionInterval){o.removeSelectionInterval(i,I);}};
B.prototype.selectAll=function(){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.selectAll){o.selectAll();}};
B.prototype.setSelectedIndex=function(i){if(this._getSelectionMode()===a.None){return;}if(i===-1){this.clearSelection();}else{var o=this.getTableBinding();if(o&&o.setSelectedIndex){o.setSelectedIndex(i);}}};
B.prototype.setSelectionInterval=function(i,I){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.setSelectionInterval){if(this._getSelectionMode()===a.Single){i=I;}o.setSelectionInterval(i,I);}};
B.prototype.setSelectionMode=function(s){var o=this._getSelectionMode();S.prototype._setSelectionMode.apply(this,arguments);if(this._getSelectionMode()!==o){this.clearSelection();}return this;};
B.prototype._getHighestSelectableIndex=function(){var o=this.getTableBinding();return o?o.getLength()-1:-1;};
B.prototype.onTableRowsBound=function(o){S.prototype.onTableRowsBound.apply(this,arguments);b(this,o);};
function b(p,o){if(o){o.attachChange(p._onBindingChange,p);o.attachSelectionChanged(p._onSelectionChange,p);}}
function d(p,o){if(o){o.detachChange(p._onBindingChange,p);o.detachSelectionChanged(p._onSelectionChange,p);}}
B.prototype._onBindingChange=function(e){var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r==="sort"||r==="filter"){this.clearSelection();}};
B.prototype._onSelectionChange=function(e){var r=e.getParameter("rowIndices");var s=e.getParameter("selectAll");this.fireSelectionChange({rowIndices:r,selectAll:s});};
return B;});
sap.ui.predefine('sap/ui/table/plugins/MultiSelectionPlugin',["./SelectionPlugin","./SelectionModelSelection","./BindingSelection","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool","sap/base/Log"],function(S,a,B,l,T,I,b,L){"use strict";var c=l.SelectionMode;
var M=S.extend("sap.ui.table.plugins.MultiSelectionPlugin",{metadata:{library:"sap.ui.table",properties:{limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:c.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},limitReached:{type:"boolean"},customPayload:{type:"object"}}}}}});
M.prototype.init=function(){S.prototype.init.apply(this,arguments);var i=new I({src:b.getIconURI(T.ThemeParameters.clearSelectionIcon),useIconTooltip:false});i.addStyleClass("sapUiTableSelectClear");this._bLimitReached=false;this._bLimitDisabled=this.getLimit()===0;this.oInnerSelectionPlugin=null;this.oDeselectAllIcon=i;this._oNotificationPopover=null;};
M.prototype.exit=function(){if(this.oDeselectAllIcon){this.oDeselectAllIcon.destroy();this.oDeselectAllIcon=null;}if(this._oNotificationPopover){this._oNotificationPopover.destroy();this._oNotificationPopover=null;}};
M.prototype.onActivate=function(o){S.prototype.onActivate.apply(this,arguments);this.oInnerSelectionPlugin=o._createLegacySelectionPlugin();this.oInnerSelectionPlugin.attachSelectionChange(this._onSelectionChange,this);o.addAggregation("_hiddenDependents",this.oInnerSelectionPlugin);o.setProperty("selectionMode",this.getSelectionMode());};
M.prototype.onDeactivate=function(o){S.prototype.onDeactivate.apply(this,arguments);o.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);if(this._oNotificationPopover){this._oNotificationPopover.close();}if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.destroy();this.oInnerSelectionPlugin=null;}};
M.prototype.getRenderConfig=function(){return{headerSelector:{type:this._bLimitDisabled?"toggle":"clear",icon:this.oDeselectAllIcon,visible:this.getSelectionMode()===c.MultiToggle&&this.getShowHeaderSelector(),enabled:this._bLimitDisabled||this.getSelectedCount()>0}};};
M.prototype.onHeaderSelectorPress=function(){var r=this.getRenderConfig();if(!r.headerSelector.visible||!r.headerSelector.enabled){return;}if(r.headerSelector.type==="toggle"){t(this);}else if(r.headerSelector.type==="clear"){this.clearSelection();}};
M.prototype.onKeyboardShortcut=function(s){if(s==="toggle"){if(this._bLimitDisabled){t(this);}}else if(s==="clear"){this.clearSelection();}};
function t(P){if(P.getSelectableCount()>P.getSelectedCount()){P.selectAll();}else{P.clearSelection();}}
M.prototype.setSelectionMode=function(s){var o=this.getSelectionMode();var f=this.getParent();if(f){f.setProperty("selectionMode",s,true);}this.setProperty("selectionMode",s);if(this.getSelectionMode()!==o){this.clearSelection();}return this;};
M.prototype.setLimit=function(i){if(typeof i==="number"&&i<0){L.warning("The limit must be greater than or equal to 0",this);return this;}this.setProperty("limit",i,!!this.getLimit()===!!i);this._bLimitDisabled=i===0;return this;};
M.prototype.setEnableNotification=function(n){this.setProperty("enableNotification",n,true);return this;};
M.prototype.isLimitReached=function(){return this._bLimitReached;};
M.prototype.setLimitReached=function(f){this._bLimitReached=f;};
M.prototype.selectAll=function(E){if(!this._bLimitDisabled){return Promise.reject(new Error("Not possible if the limit is enabled"));}var s=this.getSelectableCount();if(s===0){return Promise.reject(new Error("Nothing to select"));}return this.addSelectionInterval(0,this._getHighestSelectableIndex(),E);};
function p(P,i,f,A){var h=P._getHighestSelectableIndex();if(i<0&&f<0||i>h&&f>h){return Promise.reject(new Error("Out of range"));}i=Math.min(Math.max(0,i),h);f=Math.min(Math.max(0,f),h);var g=P.getLimit();var r=f<i;var G=r?f:i;var j;if(A&&P.isIndexSelected(i)){if(r){i--;}else if(i!==f){i++;G++;}}j=Math.abs(f-i)+1;if(!P._bLimitDisabled){P.setLimitReached(j>g);if(P.isLimitReached()){if(r){f=i-g+1;}else{f=i+g-1;}j=g+1;}}return d(P.getTableBinding(),G,j).then(function(){return{indexFrom:i,indexTo:f};});}
M.prototype.setSelectionInterval=function(i,f,E){var s=this.getSelectionMode();if(s===c.None){return Promise.reject(new Error("SelectionMode is '"+c.None+"'"));}if(s===c.Single){i=f;}return p(this,i,f,false).then(function(m){this._oCustomEventPayloadTmp=E;this.oInnerSelectionPlugin.setSelectionInterval(m.indexFrom,m.indexTo);delete this._oCustomEventPayloadTmp;return this._scrollTableToIndex(m.indexTo,m.indexFrom>m.indexTo);}.bind(this));};
M.prototype.setSelectedIndex=function(i,E){return this.setSelectionInterval(i,i,E);};
M.prototype.addSelectionInterval=function(i,f,E){var s=this.getSelectionMode();if(s===c.None){return Promise.reject(new Error("SelectionMode is '"+c.None+"'"));}if(s===c.Single){return this.setSelectionInterval(f,f);}if(s===c.MultiToggle){return p(this,i,f,true).then(function(m){this._oCustomEventPayloadTmp=E;this.oInnerSelectionPlugin.addSelectionInterval(m.indexFrom,m.indexTo);delete this._oCustomEventPayloadTmp;return this._scrollTableToIndex(m.indexTo,m.indexFrom>m.indexTo);}.bind(this));}};
M.prototype._scrollTableToIndex=function(i,r){var o=this.getParent();if(!o||!this.isLimitReached()){return Promise.resolve();}var f=o.getFirstVisibleRow();var R=o._getRowCounts();var g=f+R.scrollable-1;var E=false;if(i<f||i>g){var n=r?i-R.fixedTop-1:i-R.scrollable-R.fixedTop+2;E=o._setFirstVisibleRowIndex(Math.max(0,n));}this._showNotificationPopoverAtIndex(i);return new Promise(function(h){if(E){o.attachEventOnce("rowsUpdated",h);}else{h();}});};
M.prototype._showNotificationPopoverAtIndex=function(i){var f=this;var P=this._oNotificationPopover;var o=this.getParent();var r=o.getRows()[i-o._getFirstRenderedRowIndex()];var s=T.getResourceText("TBL_SELECT_LIMIT_TITLE");var m=T.getResourceText("TBL_SELECT_LIMIT",[this.getLimit()]);if(!this.getEnableNotification()){return Promise.resolve();}return new Promise(function(g){sap.ui.require(["sap/m/Popover","sap/m/Bar","sap/m/Title","sap/m/Text","sap/m/HBox","sap/ui/core/library","sap/m/library"],function(h,j,k,n,H,q,u){if(!P){P=new h(f.getId()+"-notificationPopover",{customHeader:[new j({contentMiddle:[new H({items:[new I({src:"sap-icon://message-warning",color:q.IconColor.Critical}).addStyleClass("sapUiTinyMarginEnd"),new k({text:s,level:q.TitleLevel.H2})],renderType:u.FlexRendertype.Bare,justifyContent:u.FlexJustifyContent.Center,alignItems:u.FlexAlignItems.Center})]})],content:new n({text:m})});P.addStyleClass("sapUiContentPadding");f._oNotificationPopover=P;}else{P.getContent()[0].setText(m);}o.detachFirstVisibleRowChanged(f.onFirstVisibleRowChange,f);o.attachFirstVisibleRowChanged(f.onFirstVisibleRowChange,f);var R=r.getDomRefs().rowSelector;if(R){P.attachEventOnce("afterOpen",g);P.openBy(R);}else{g();}});});};
M.prototype.onFirstVisibleRowChange=function(){if(!this._oNotificationPopover){return;}var o=this.getParent();if(o){o.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);}this._oNotificationPopover.close();};
function d(o,s,i){return new Promise(function(r){e(o,s,i,r);});}
function e(o,s,f,r){var C=o.getContexts(s,f,0,true);var g=false;for(var i=0;i<C.length;i++){if(!C[i]){g=true;break;}}if(!g&&!C.dataRequested){r(C);return;}o.attachEventOnce("dataReceived",function(){if(C.length==f){r(C);}else{e(o,s,f,r);}});}
M.prototype.clearSelection=function(E){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=E;this.oInnerSelectionPlugin.clearSelection();delete this._oCustomEventPayloadTmp;}};
M.prototype.getSelectedIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndex();}return-1;};
M.prototype.getSelectedIndices=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndices();}return[];};
M.prototype.getSelectableCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectableCount();}return 0;};
M.prototype.getSelectedCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedCount();}return 0;};
M.prototype.isIndexSelectable=function(i){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelectable(i);}return false;};
M.prototype.isIndexSelected=function(i){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelected(i);}return false;};
M.prototype.removeSelectionInterval=function(i,f,E){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=E;this.oInnerSelectionPlugin.removeSelectionInterval(i,f);delete this._oCustomEventPayloadTmp;}};
M.prototype._onSelectionChange=function(E){var r=E.getParameter("rowIndices");this.fireSelectionChange({rowIndices:r,limitReached:this.isLimitReached(),customPayload:typeof this._oCustomEventPayloadTmp==="object"?this._oCustomEventPayloadTmp:null});};
M.prototype._getHighestSelectableIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._getHighestSelectableIndex();}return 0;};
M.prototype.onThemeChanged=function(){this.oDeselectAllIcon.setSrc(b.getIconURI(T.ThemeParameters.clearSelectionIcon));};
return M;});
sap.ui.predefine('sap/ui/table/plugins/PluginBase',["../utils/TableUtils","sap/ui/core/Element"],function(T,E){"use strict";var H=T.Hook.Keys;var h={};var _=T.createWeakMapFacade();
var P=E.extend("sap.ui.table.plugins.PluginBase",{metadata:{"abstract":true,library:"sap.ui.table"}});
P.prototype.init=function(){E.prototype.init.apply(this,arguments);_(this).bIsActive=false;};
P.prototype.exit=function(){E.prototype.exit.apply(this,arguments);this.deactivate();};
P.prototype.onActivate=function(t){};
P.prototype.onDeactivate=function(t){};
P.prototype.isActive=function(){return _(this).bIsActive;};
P.prototype.isApplicable=function(c){return T.isA(c,"sap.ui.table.Table");};
P.prototype.setParent=function(p){this.deactivate();E.prototype.setParent.apply(this,arguments);if(p){if(!this.isApplicable(this.getTable())){throw new Error(this+" is not applicable to "+p);}this.activate();}return this;};
P.prototype.onTableBindRows=function(){};
h[H.Table.BindRows]=function(b){this.onTableBindRows(b);};
P.prototype.onTableRowsBound=function(b){};
h[H.Table.RowsBound]=function(b){this.onTableRowsBound(b);};
P.prototype.onTableUnbindRows=function(){};
h[H.Table.UnbindRows]=function(){this.onTableUnbindRows();};
P.prototype.getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};
P.prototype.getTableBinding=function(){var t=this.getTable();var b=t?t.getBinding():null;return b?b:null;};
P.prototype.setRowCountConstraints=function(c){var t=this.getTable();if(t){t._setRowCountConstraints(c);}};
P.prototype.activate=function(){var t=this.getTable();if(!t||this.isActive()){return;}T.Hook.install(t,h,this);this.onActivate(t);var o=this.getTableBinding();if(o){this.onTableRowsBound(o);}_(this).bIsActive=true;};
P.prototype.deactivate=function(){var t=this.getTable();if(!this.isActive()){return;}T.Hook.uninstall(t,h,this);this.onDeactivate(t);_(this).bIsActive=false;};
return P;});
sap.ui.predefine('sap/ui/table/plugins/SelectionModelSelection',['sap/ui/model/SelectionModel','./SelectionPlugin',"../utils/TableUtils",'../library'],function(S,a,T,l){"use strict";var b=l.SelectionMode;
var c=a.extend("sap.ui.table.plugins.SelectionModelSelection",{metadata:{library:"sap.ui.table",events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this.oSelectionModel=new S(this._getSelectionMode);};
c.prototype.exit=function(){a.prototype.exit.apply(this,arguments);if(this.oSelectionModel){this.oSelectionModel.destroy();this.oSelectionModel=null;}};
c.prototype.onActivate=function(t){a.prototype.onActivate.apply(this,arguments);this.oSelectionModel.attachSelectionChanged(o,this);T.Hook.register(t,T.Hook.Keys.Table.TotalRowCountChanged,g,this);this._iTotalRowCount=t._getTotalRowCount();};
c.prototype.onDeactivate=function(t){a.prototype.onDeactivate.apply(this,arguments);this.oSelectionModel.detachSelectionChanged(o,this);this.oSelectionModel.clearSelection();e(this,this.getTableBinding());T.Hook.deregister(t,T.Hook.Keys.Table.TotalRowCountChanged,g,this);};
c.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:T.hasSelectAll(this.getTable())}};};
c.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){this.getTable()._toggleSelectAll();}};
c.prototype.onKeyboardShortcut=function(t){if(t==="toggle"){this.getTable()._toggleSelectAll();}else if(t==="clear"){this.clearSelection();}};
c.prototype.addSelectionInterval=function(i,I){if(!this.oSelectionModel||this._getSelectionMode()===b.None){return;}this.oSelectionModel.addSelectionInterval(i,I);};
c.prototype.clearSelection=function(){if(this.oSelectionModel){this.oSelectionModel.clearSelection();}};
c.prototype.getSelectedIndex=function(){if(this.oSelectionModel){return this.oSelectionModel.getLeadSelectedIndex();}return-1;};
c.prototype.getSelectedIndices=function(){if(this.oSelectionModel){return this.oSelectionModel.getSelectedIndices();}return[];};
c.prototype.getSelectableCount=function(){var B=this.getTableBinding();return B?B.getLength():0;};
c.prototype.getSelectedCount=function(){return this.getSelectedIndices().length;};
c.prototype.isIndexSelectable=function(i){return i>=0&&i<=this._getHighestSelectableIndex();};
c.prototype.isIndexSelected=function(i){return this.getSelectedIndices().indexOf(i)!==-1;};
c.prototype.removeSelectionInterval=function(i,I){if(this.oSelectionModel){this.oSelectionModel.removeSelectionInterval(i,I);}};
c.prototype.selectAll=function(){if(!this.oSelectionModel||this._getSelectionMode()===b.None){return;}this.oSelectionModel.selectAll(this._getHighestSelectableIndex());};
c.prototype.setSelectedIndex=function(i){if(this._getSelectionMode()===b.None){return;}if(i===-1){this.clearSelection();}else{this.setSelectionInterval(i,i);}};
c.prototype.setSelectionInterval=function(i,I){if(!this.oSelectionModel||this._getSelectionMode()===b.None){return;}this.oSelectionModel.setSelectionInterval(i,I);};
c.prototype.setSelectionMode=function(s){var O=this._getSelectionMode();a.prototype._setSelectionMode.apply(this,arguments);if(this._getSelectionMode()!==O){this.clearSelection();}if(this.oSelectionModel){var i=(s===b.MultiToggle?S.MULTI_SELECTION:S.SINGLE_SELECTION);this.oSelectionModel.setSelectionMode(i);}return this;};
c.prototype._getHighestSelectableIndex=function(){var B=this.getTableBinding();return B?B.getLength()-1:-1;};
c.prototype.onTableRowsBound=function(B){a.prototype.onTableRowsBound.apply(this,arguments);d(this,B);};
c.prototype.onTableUnbindRows=function(){a.prototype.onTableUnbindRows.apply(this,arguments);this._suspend();this.clearSelection();this._resume();};
function o(E){var r=E.getParameter("rowIndices");var s=E.getParameter("selectAll");this.fireSelectionChange({rowIndices:r,selectAll:s});}
function d(p,B){if(B){B.attachChange(f,p);}}
function e(p,B){if(B){B.detachChange(f,p);}}
function f(E){var r=typeof(E)==="object"?E.getParameter("reason"):E;if(r==="sort"||r==="filter"){this.clearSelection();}}
function g(){var t=this.getTable()._getTotalRowCount();if(this._iTotalRowCount>0&&this._iTotalRowCount!==t){this.clearSelection();}this._iTotalRowCount=t;}
return c;});
sap.ui.predefine('sap/ui/table/plugins/SelectionPlugin',["sap/ui/core/Element","./PluginBase","../library"],function(E,P,l){"use strict";var S=l.SelectionMode;
var a=E.extend("sap.ui.table.plugins.SelectionPlugin",{metadata:{"abstract":true,library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",defaultValue:S.MultiToggle,visibility:"hidden"}},events:{selectionChange:{parameters:{}}}}});
for(var p in P.prototype){if(!a.prototype.hasOwnProperty(p)){a.prototype[p]=P.prototype[p];}}
a.prototype.init=function(){P.prototype.init.apply(this,arguments);this._bSuspended=false;};
a.prototype.getRenderConfig=function(){return{headerSelector:{type:"none"}};};
a.prototype.addSelectionInterval=function(i,I){};
a.prototype.clearSelection=function(){};
a.prototype.getSelectedIndex=function(){return-1;};
a.prototype.getSelectedIndices=function(){return[];};
a.prototype.getSelectableCount=function(){return 0;};
a.prototype.getSelectedCount=function(){return 0;};
a.prototype.isIndexSelectable=function(i){return false;};
a.prototype.isIndexSelected=function(i){return false;};
a.prototype.removeSelectionInterval=function(i,I){};
a.prototype.selectAll=function(){};
a.prototype.setSelectedIndex=function(i){};
a.prototype.setSelectionInterval=function(i,I){};
a.prototype.fireSelectionChange=function(A){if(!this._isSuspended()){this.fireEvent("selectionChange",A);}};
a.prototype._setSelectionMode=function(s){this.setProperty("selectionMode",s);};
a.prototype._getSelectionMode=function(){return this.getProperty("selectionMode");};
a.prototype._suspend=function(){this._bSuspended=true;};
a.prototype._resume=function(){this._bSuspended=false;};
a.prototype._isSuspended=function(){return this._bSuspended;};
return a;});
sap.ui.predefine('sap/ui/table/plugins/V4Aggregation',["./PluginBase","../utils/TableUtils","sap/base/util/deepClone"],function(P,T,d){"use strict";
function a(C,G){var R="TBL_ROW_GROUP_TITLE";var v=[G.property.label,C.getProperty(G.property.path,true)];if(G.textProperty){R="TBL_ROW_GROUP_TITLE_FULL";v.push(C.getProperty(G.textProperty.path,true));}return T.getResourceText(R,v);}
var V=P.extend("sap.ui.table.plugins.V4Aggregation",{metadata:{library:"sap.ui.table",properties:{totalSummaryOnTop:{type:"string",defaultValue:"Off"},totalSummaryOnBottom:{type:"string",defaultValue:"Fixed"},groupSummary:{type:"string",defaultValue:"Bottom"},groupHeaderFormatter:{type:"function"}}}});
V.prototype.isApplicable=function(C){return P.prototype.isApplicable.apply(this,arguments)&&C.getMetadata().getName()==="sap.ui.table.Table";};
V.prototype.activate=function(){var B=this.getTableBinding();if(B&&!B.isA("sap.ui.model.odata.v4.ODataListBinding")){return;}P.prototype.activate.apply(this,arguments);};
V.prototype.onActivate=function(t){this.setRowCountConstraints({fixedTop:false,fixedBottom:false});T.Grouping.setToDefaultGroupMode(t);T.Hook.register(t,T.Hook.Keys.Row.UpdateState,this.updateRowState,this);T.Hook.register(t,T.Hook.Keys.Row.Expand,e,this);T.Hook.register(t,T.Hook.Keys.Row.Collapse,c,this);};
V.prototype.onDeactivate=function(t){this._mGroup=undefined;this._mAggregate=undefined;this._aGroupLevels=undefined;this._mColumnState=undefined;this.setRowCountConstraints();r(this);T.Grouping.setToDefaultFlatMode(t);T.Hook.deregister(t,T.Hook.Keys.Row.UpdateState,this.updateRowState,this);T.Hook.deregister(this,T.Hook.Keys.Row.Expand,e,this);T.Hook.deregister(this,T.Hook.Keys.Row.Collapse,c,this);var B=t.getBinding();if(B){B.setAggregation();}};
function r(p){var t=p.getTable();if(t){t.getColumns().forEach(function(C){C._setCellContentVisibilitySettings();});}}
function u(p){var t=p.getTable();var G=p.getGroupSummary();if(!t||!p._mColumnState){return;}t.getColumns().forEach(function(C){var m=p._mColumnState[C.getId()];if(m){C._setCellContentVisibilitySettings({groupHeader:{expanded:!!m.subtotals&&(G==="Top"||G==="TopAndBottom"),collapsed:!!m.subtotals&&(G==="Bottom"||G==="TopAndBottom")},summary:{group:!!m.subtotals,total:!!m.grandTotal}});}else{C._setCellContentVisibilitySettings();}});}
V.prototype.onTableRowsBound=function(B){if(!B.getModel().isA("sap.ui.model.odata.v4.ODataModel")){this.deactivate();}};
V.prototype.onTableBindRows=function(B){B.parameters=B.parameters||{};B.parameters.$$aggregation=this.getAggregationInfo();};
V.prototype.updateRowState=function(s){var l=s.context.getValue("@$ui5.node.level");var C=s.context.getValue("@$ui5.node.isTotal");var i=s.context.getValue("@$ui5.node.isExpanded")===undefined;var I=l===0&&C;var f=l>0&&!i;var j=!f&&C;s.level=l;s.expandable=f;s.expanded=s.context.getValue("@$ui5.node.isExpanded")===true;if(I||j){s.type=s.Type.Summary;s.level++;}else if(f){s.type=s.Type.GroupHeader;}if(f){var G=this._aGroupLevels[l-1];var k=this.getGroupHeaderFormatter();var m=k?k(s.context,G.property.name):undefined;if(m===undefined){s.title=a(s.context,G);}else if(typeof m!=="string"){throw new Error("The group header title must be a string or undefined");}else{s.title=m;}}};
V.prototype.setPropertyInfos=function(p){this._aPropertyInfos=p;};
V.prototype.getPropertyInfos=function(){return this._aPropertyInfos||[];};
V.prototype.findPropertyInfo=function(p){return this.getPropertyInfos().find(function(o){return o.name===p;});};
V.prototype.isPropertyAggregatable=function(p){return(p.extension&&p.extension.defaultAggregate)?true:false;};
V.prototype.setAggregationInfo=function(A){A=Object.assign({columnState:{}},A);if(!Array.isArray(A.visible)){this._mGroup=undefined;this._mAggregate=undefined;this._aGroupLevels=undefined;this._sSearch=undefined;}else{var f=[];var i=[];var j;this._mGroup=this.getPropertyInfos().reduce(function(G,p){if(p.key){G[p.path]={};j=g(this,p);if(j){G[p.path].additionally=j;i.concat(j);}}return G;}.bind(this),{});this._mAggregate={};var v=A.visible.concat();if(A.groupLevels){A.groupLevels.forEach(function(G){if(v.indexOf(G)<0){v.push(G);}});}v.forEach(function(s){var p=this.findPropertyInfo(s);if(p&&p.groupable){this._mGroup[p.path]={};j=g(this,p);if(j){this._mGroup[p.path].additionally=j;i=i.concat(j);}}if(p&&this.isPropertyAggregatable(p)){this._mAggregate[p.path]={};if(A.grandTotal&&(A.grandTotal.indexOf(s)>=0)){this._mAggregate[p.path].grandTotal=true;}if(A.subtotals&&(A.subtotals.indexOf(s)>=0)){this._mAggregate[p.path].subtotals=true;}if(p.unit){var U=this.findPropertyInfo(p.unit);if(U){this._mAggregate[p.path].unit=U.path;f.push(U.path);}}if(p.extension.defaultAggregate.contextDefiningProperties){p.extension.defaultAggregate.contextDefiningProperties.forEach(function(C){var D=this.findPropertyInfo(C);if(D){this._mGroup[D.path]={};j=g(this,p);if(j){this._mGroup[D.path].additionally=j;i=i.concat(j);}}}.bind(this));}}}.bind(this));this._aGroupLevels=[];if(A.groupLevels){A.groupLevels.forEach(function(G){var p=this.findPropertyInfo(G);this._aGroupLevels.push({property:p,textProperty:this.findPropertyInfo(p.text)});}.bind(this));}Object.keys(this._mGroup).forEach(function(k){if(this._mAggregate.hasOwnProperty(k)){if(this._mAggregate[k].grandTotal||this._mAggregate[k].subtotals){delete this._mGroup[k];return;}else{delete this._mAggregate[k];}}if(this._mGroup[k].additionally){this._mGroup[k].additionally=this._mGroup[k].additionally.filter(function(s){return f.indexOf(s)===-1;});}if(i.indexOf(k)>-1){delete this._mGroup[k];}}.bind(this));this._sSearch=A.search;}this._mColumnState=A.columnState;u(this);this.updateAggregation();};
V.prototype.getAggregationInfo=function(){if(!Object.keys(this._mGroup||{}).length&&!Object.keys(this._mAggregate||{}).length){return;}var A={aggregate:d(this._mAggregate),group:d(this._mGroup),groupLevels:this._aGroupLevels?this._aGroupLevels.map(function(G){return G.property.path;}):undefined,search:this._sSearch};if(A.aggregate){h(this,A);b(this,A);}return A;};
function g(p,o){if(o.text){var t=p.findPropertyInfo(o.text);if(t){return[t.path];}}return null;}
function e(R){var B=R.getRowBindingContext();if(B){B.expand();}}
function c(R){var B=R.getRowBindingContext();if(B){B.collapse();}}
V.prototype.setTotalSummaryOnTop=function(v){this.setProperty("totalSummaryOnTop",v,true);this.updateAggregation();};
V.prototype.setTotalSummaryOnBottom=function(v){this.setProperty("totalSummaryOnBottom",v,true);this.updateAggregation();};
V.prototype.setGroupSummary=function(v){this.setProperty("groupSummary",v,true);u(this);this.updateAggregation();};
V.prototype.updateAggregation=function(){var B=this.getTableBinding();if(B){B.setAggregation(this.getAggregationInfo());}};
function h(p,A){var t=p.getTotalSummaryOnTop();var s=p.getTotalSummaryOnBottom();var S=t==="On"||t==="Fixed";var f=s==="On"||s==="Fixed";var H=Object.keys(A.aggregate).some(function(k){return A.aggregate[k].grandTotal;});if(S&&f){A.grandTotalAtBottomOnly=false;}else if(f){A.grandTotalAtBottomOnly=true;}else if(S){A.grandTotalAtBottomOnly=undefined;}else{Object.keys(A.aggregate).forEach(function(k){delete A.aggregate[k].grandTotal;});}p.setRowCountConstraints({fixedTop:t==="Fixed"&&H,fixedBottom:s==="Fixed"&&H});}
function b(p,A){var G=p.getGroupSummary();if(G==="Top"){A.subtotalsAtBottomOnly=undefined;}else if(G==="Bottom"){A.subtotalsAtBottomOnly=true;}else if(G==="TopAndBottom"){A.subtotalsAtBottomOnly=false;}else{Object.keys(A.aggregate).forEach(function(k){delete A.aggregate[k].subtotals;});}}
return V;});
sap.ui.predefine('sap/ui/table/rowmodes/AutoRowMode',["../library","../utils/TableUtils","./RowMode","sap/ui/Device"],function(l,T,R,D){"use strict";var _=T.createWeakMapFacade();
var A=R.extend("sap.ui.table.rowmodes.AutoRowMode",{
metadata:{library:"sap.ui.table",properties:{minRowCount:{type:"int",defaultValue:5,group:"Appearance"},maxRowCount:{type:"int",defaultValue:-1,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance"}}},
constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});R.apply(this,arguments);}
});
var a={};
function g(r){var t=r.getTable();var o=t?t.getDomRef("tableCCnt"):null;if(o&&D.browser.chrome&&window.devicePixelRatio!==1){var d=document.createElement("table");var e=d.insertRow();var i=r.getRowContentHeight();var n;d.classList.add("sapUiTableCtrl");e.classList.add("sapUiTableTr");if(i>0){e.style.height=r.getBaseRowHeightOfTable()+"px";}o.appendChild(d);n=e.getBoundingClientRect().height;o.removeChild(d);return n;}else{return r.getBaseRowHeightOfTable();}}
A.prototype.init=function(){R.prototype.init.apply(this,arguments);_(this).iPendingStartTableUpdateSignals=0;_(this).bRowCountAutoAdjustmentActive=false;_(this).iLastAvailableSpace=0;_(this).rowCount=-1;_(this).bTableIsFlexItem=false;_(this).adjustRowCountToAvailableSpaceAsync=T.throttleFrameWise(this.adjustRowCountToAvailableSpace.bind(this));};
A.prototype.attachEvents=function(){R.prototype.attachEvents.apply(this,arguments);T.addDelegate(this.getTable(),a,this);};
A.prototype.detachEvents=function(){R.prototype.detachEvents.apply(this,arguments);T.removeDelegate(this.getTable(),a);};
A.prototype.cancelAsyncOperations=function(){R.prototype.cancelAsyncOperations.apply(this,arguments);this.stopAutoRowMode();};
A.prototype.registerHooks=function(){R.prototype.registerHooks.apply(this,arguments);T.Hook.register(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);T.Hook.register(this.getTable(),T.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this);};
A.prototype.deregisterHooks=function(){R.prototype.deregisterHooks.apply(this,arguments);T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this);};
A.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0;}return this.getProperty("fixedTopRowCount");};
A.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0;}return this.getProperty("fixedBottomRowCount");};
A.prototype.getMinRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getMinAutoRowCount():0;}return this.getProperty("minRowCount");};
A.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0;}return this.getProperty("rowContentHeight");};
A.prototype.setHideEmptyRows=function(h){this.setProperty("hideEmptyRows",h);if(h){this.disableNoData();}else{this.enableNoData();}return this;};
A.prototype._getMinRowCount=function(){var m=this.getMinRowCount();var M=this.getMaxRowCount();if(M>=0){return Math.min(m,M);}else{return m;}};
A.prototype.getMinRequestLength=function(){var t=this.getTable();var r=this.getConfiguredRowCount();if(c(this)||(t&&!t._bContextsAvailable)){var e=Math.ceil(D.resize.height/T.DefaultRowHeight.sapUiSizeCondensed);r=Math.max(r,e);}return r;};
A.prototype.updateTableRows=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){var C=this.getConfiguredRowCount();if(C>0){return this.getRowContexts(C,true).length>0;}}else{return R.prototype.updateTableRows.call(this);}};
A.prototype.getComputedRowCounts=function(){if(c(this)){return{count:0,scrollable:0,fixedTop:0,fixedBottom:0};}var r=this.getConfiguredRowCount();var f=this.getFixedTopRowCount();var F=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){r=Math.min(r,this.getTotalRowCountOfTable());}return this.computeStandardizedRowCounts(r,f,F);};
A.prototype.getTableStyles=function(){var h="0px";if(c(this)){h="auto";}else{var r=this.getConfiguredRowCount();if(r===0||r===this._getMinRowCount()){h="auto";}}return{height:h};};
A.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined;}var r;if(c(this)){r=this._getMinRowCount();}else{r=this.getConfiguredRowCount()-this.getComputedRowCounts().count;}return{height:r*this.getBaseRowHeightOfTable()+"px"};};
A.prototype.getRowContainerStyles=function(){return{height:this.getComputedRowCounts().count*Math.max(this.getBaseRowHeightOfTable(),g(this))+"px"};};
A.prototype.renderRowStyles=function(r){var i=this.getRowContentHeight();if(i>0){r.style("height",this.getBaseRowHeightOfTable()+"px");}};
A.prototype.renderCellContentStyles=function(r){var i=this.getRowContentHeight();if(!this.bLegacy&&i<=0){i=this.getDefaultRowContentHeightOfTable();}if(i>0){r.style("max-height",i+"px");}};
A.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight());};
A.prototype._onTableRefreshRows=function(){var C=this.getConfiguredRowCount();if(C>0){if(!c(this)){this.initTableRowsAfterDataRequested(C);}this.getRowContexts(C);}};
A.prototype.getConfiguredRowCount=function(){var r=Math.max(0,this.getMinRowCount(),_(this).rowCount);var m=this.getMaxRowCount();if(m>=0){r=Math.min(r,m);}return r;};
A.prototype.startAutoRowMode=function(){_(this).adjustRowCountToAvailableSpaceAsync(T.RowsUpdateReason.Render,true);};
A.prototype.stopAutoRowMode=function(){this.deregisterResizeHandler();_(this).adjustRowCountToAvailableSpaceAsync.cancel();_(this).bRowCountAutoAdjustmentActive=false;b(this);};
A.prototype.registerResizeHandler=function(o){var t=this.getTable();if(t){T.registerResizeHandler(t,"AutoRowMode",this.onResize.bind(this),null,o===true);T.registerResizeHandler(t,"AutoRowMode-BeforeTable",this.onResize.bind(this),"before");T.registerResizeHandler(t,"AutoRowMode-AfterTable",this.onResize.bind(this),"after");}};
A.prototype.deregisterResizeHandler=function(){var t=this.getTable();if(t){T.deregisterResizeHandler(t,["AutoRowMode, AutoRowMode-BeforeTable, AutoRowMode-AfterTable"]);}};
A.prototype.onResize=function(e){var o=e.oldSize.height;var n=e.size.height;if(o!==n){s(this);_(this).adjustRowCountToAvailableSpaceAsync(T.RowsUpdateReason.Resize);}};
A.prototype._onUpdateTableSizes=function(r){if(r===T.RowsUpdateReason.Resize||r===T.RowsUpdateReason.Render){return;}if(_(this).bRowCountAutoAdjustmentActive){s(this);_(this).adjustRowCountToAvailableSpaceAsync(r);}};
A.prototype.adjustRowCountToAvailableSpace=function(r,S){S=S===true;var t=this.getTable();var o=t?t.getDomRef():null;if(!t||t._bInvalid||!o||!sap.ui.getCore().isThemeApplied()){b(this);return;}_(this).bTableIsFlexItem=window.getComputedStyle(o.parentNode).display==="flex";if(o.scrollHeight===0){if(S){this.registerResizeHandler(!_(this).bTableIsFlexItem);_(this).bRowCountAutoAdjustmentActive=true;}b(this);return;}var n=this.determineAvailableSpace();var O=this.getConfiguredRowCount();var N=Math.floor(n/g(this));var i=this.getComputedRowCounts().count;var d;_(this).rowCount=N;d=this.getComputedRowCounts().count;if(this.bLegacy){t.setProperty("visibleRowCount",d,true);}if(i!==d){this.updateTable(r);}else{if(O!==N||r===T.RowsUpdateReason.Zoom){this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles();}if(!this._bFiredRowsUpdatedAfterRendering&&t.getRows().length>0){this.fireRowsUpdated(r);}}if(S){this.registerResizeHandler(!_(this).bTableIsFlexItem);_(this).bRowCountAutoAdjustmentActive=true;}b(this);};
A.prototype.determineAvailableSpace=function(){var t=this.getTable();var o=t?t.getDomRef():null;var r=t?t.getDomRef("tableCCnt"):null;var p=t?t.getDomRef("placeholder-bottom"):null;if(!o||!r||!o.parentNode){return 0;}var u=0;var d=r.clientHeight;var P=p?p.clientHeight:0;if(_(this).bTableIsFlexItem){var C=o.childNodes;for(var i=0;i<C.length;i++){u+=C[i].offsetHeight;}u-=d-P;}else{u=o.scrollHeight-d-P;}var S=t._getScrollExtension();if(!S.isHorizontalScrollbarVisible()){var m={};m[D.browser.BROWSER.CHROME]=16;m[D.browser.BROWSER.FIREFOX]=16;m[D.browser.BROWSER.SAFARI]=16;m[D.browser.BROWSER.ANDROID]=8;u+=m[D.browser.name];}var e=_(this).bTableIsFlexItem?o:o.parentNode;var n=Math.max(0,Math.floor(jQuery(e).height()-u));var f=Math.abs(n-_(this).iLastAvailableSpace);if(f>=5){_(this).iLastAvailableSpace=n;}return _(this).iLastAvailableSpace;};
a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this.stopAutoRowMode();this.updateTable(T.RowsUpdateReason.Render);}};
a.onAfterRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this.startAutoRowMode();}};
function s(r){_(r).iPendingStartTableUpdateSignals++;T.Hook.call(r.getTable(),T.Hook.Keys.Signal,"StartTableUpdate");}
function b(r){for(var i=0;i<_(r).iPendingStartTableUpdateSignals;i++){T.Hook.call(r.getTable(),T.Hook.Keys.Signal,"EndTableUpdate");}_(r).iPendingStartTableUpdateSignals=0;}
function c(r){return _(r).rowCount===-1;}
return A;});
sap.ui.predefine('sap/ui/table/rowmodes/FixedRowMode',["../library","./RowMode","../utils/TableUtils"],function(l,R,T){"use strict";
var F=R.extend("sap.ui.table.rowmodes.FixedRowMode",{
metadata:{library:"sap.ui.table",properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance"}}},
constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});R.apply(this,arguments);}
});
var a={};
F.prototype.attachEvents=function(){R.prototype.attachEvents.apply(this,arguments);T.addDelegate(this.getTable(),a,this);};
F.prototype.detachEvents=function(){R.prototype.detachEvents.apply(this,arguments);T.removeDelegate(this.getTable(),a);};
F.prototype.registerHooks=function(){R.prototype.registerHooks.apply(this,arguments);T.Hook.register(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);};
F.prototype.deregisterHooks=function(){R.prototype.deregisterHooks.apply(this,arguments);T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);};
F.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0;}return this.getProperty("rowCount");};
F.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0;}return this.getProperty("fixedTopRowCount");};
F.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0;}return this.getProperty("fixedBottomRowCount");};
F.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0;}return this.getProperty("rowContentHeight");};
F.prototype.setHideEmptyRows=function(h){this.setProperty("hideEmptyRows",h);if(h){this.disableNoData();}else{this.enableNoData();}return this;};
F.prototype.getMinRequestLength=function(){return Math.max(0,this.getRowCount());};
F.prototype.updateTableRows=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){var r=this.getRowCount();if(r>0){return this.getRowContexts(r,true).length>0;}}else{return R.prototype.updateTableRows.call(this);}};
F.prototype.getComputedRowCounts=function(){var r=this.getRowCount();var f=this.getFixedTopRowCount();var i=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){r=Math.min(r,this.getTotalRowCountOfTable());}return this.computeStandardizedRowCounts(r,f,i);};
F.prototype.getTableStyles=function(){return{height:"auto"};};
F.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined;}var r=Math.max(0,this.getRowCount()-this.getComputedRowCounts().count);return{height:r*this.getBaseRowHeightOfTable()+"px"};};
F.prototype.getRowContainerStyles=function(){var h=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!T.isVariableRowHeightEnabled(this.getTable())){return{minHeight:h};}else{return{height:h};}};
F.prototype.renderRowStyles=function(r){var i=this.getRowContentHeight();if(i>0){r.style("height",this.getBaseRowHeightOfTable()+"px");}};
F.prototype.renderCellContentStyles=function(r){var i=this.getRowContentHeight();if(this.bLegacy){return;}if(i<=0){i=this.getDefaultRowContentHeightOfTable();}if(i>0){r.style("max-height",i+"px");}};
F.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight());};
F.prototype._onTableRefreshRows=function(){var r=this.getRowCount();if(r>0){if(T.isVariableRowHeightEnabled(this.getTable())){r++;}this.initTableRowsAfterDataRequested(r);this.getRowContexts(r);}};
a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this.updateTable(T.RowsUpdateReason.Render);}};
a.onAfterRendering=function(e){var t=this.getTable();var r=e&&e.isMarked("renderRows");if(!r&&t.getRows().length>0){this.fireRowsUpdated(T.RowsUpdateReason.Render);}};
return F;});
sap.ui.predefine('sap/ui/table/rowmodes/InteractiveRowMode',["../library","./RowMode","../utils/TableUtils","sap/base/Log","sap/ui/thirdparty/jquery"],function(l,R,T,L,q){"use strict";
var I=R.extend("sap.ui.table.rowmodes.InteractiveRowMode",{
metadata:{library:"sap.ui.table","final":true,properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},minRowCount:{type:"int",defaultValue:5,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"}}},
constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});R.apply(this,arguments);}
});
var a={};var b={};
I.prototype.attachEvents=function(){R.prototype.attachEvents.apply(this,arguments);T.addDelegate(this.getTable(),a,this);};
I.prototype.detachEvents=function(){R.prototype.detachEvents.apply(this,arguments);T.removeDelegate(this.getTable(),a);};
I.prototype.registerHooks=function(){R.prototype.registerHooks.apply(this,arguments);T.Hook.register(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);};
I.prototype.deregisterHooks=function(){R.prototype.deregisterHooks.apply(this,arguments);T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);};
I.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0;}return this.getProperty("rowCount");};
I.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0;}return this.getProperty("fixedTopRowCount");};
I.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0;}return this.getProperty("fixedBottomRowCount");};
I.prototype.getMinRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getMinAutoRowCount():0;}return this.getProperty("minRowCount");};
I.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0;}return this.getProperty("rowContentHeight");};
I.prototype.getMinRequestLength=function(){return this.getConfiguredRowCount();};
I.prototype.getComputedRowCounts=function(){var r=this.getConfiguredRowCount();var f=this.getFixedTopRowCount();var F=this.getFixedBottomRowCount();return this.computeStandardizedRowCounts(r,f,F);};
I.prototype.getTableStyles=function(){return{height:"auto"};};
I.prototype.getTableBottomPlaceholderStyles=function(){return undefined;};
I.prototype.getRowContainerStyles=function(){var h=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!T.isVariableRowHeightEnabled(this.getTable())){return{minHeight:h};}else{return{height:h};}};
I.prototype.renderRowStyles=function(r){var i=this.getRowContentHeight();if(i>0){r.style("height",this.getBaseRowHeightOfTable()+"px");}};
I.prototype.renderCellContentStyles=function(r){var i=this.getRowContentHeight();if(this.bLegacy){return;}if(i<=0){i=this.getDefaultRowContentHeightOfTable();}if(i>0){r.style("max-height",i+"px");}};
I.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight());};
I.prototype._onTableRefreshRows=function(){var r=this.getConfiguredRowCount();if(r>0){this.initTableRowsAfterDataRequested(r);this.getRowContexts(r);}};
I.prototype.getConfiguredRowCount=function(){return Math.max(0,this.getMinRowCount(),this.getRowCount());};
a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(this.bLegacy){this.getTable().setVisibleRowCount(this.getComputedRowCounts().count);}if(!r){this.updateTable(T.RowsUpdateReason.Render);}};
a.onAfterRendering=function(e){var t=this.getTable();var r=e&&e.isMarked("renderRows");if(!r&&t.getRows().length>0){this.fireRowsUpdated(T.RowsUpdateReason.Render);}};
a.onmousedown=function(e){var t=this.getTable();if(e.button===0&&e.target===t.getDomRef("sb")){b.initInteractiveResizing(t,this,e);}};
b.initInteractiveResizing=function(t,m,e){var B=q(document.body);var s=t.$("sb");var d=q(document);var o=s.offset();var h=s.height();var w=s.width();var c=t._isTouchEvent(e);var g=document.createElement("div");g.style.width=w+"px";g.style.height=h+"px";g.style.left=o.left+"px";g.style.top=o.top+"px";g.className="sapUiTableInteractiveResizerGhost";g.id=t.getId()+"-ghost";B.append(g);var O=document.createElement("div");O.style.top="0px";O.style.bottom="0px";O.style.left="0px";O.style.right="0px";O.style.position="absolute";O.id=t.getId()+"-rzoverlay";s.append(O);d.on((c?"touchend":"mouseup")+".sapUiTableInteractiveResize",b.exitInteractiveResizing.bind(t,m));d.on((c?"touchmove":"mousemove")+".sapUiTableInteractiveResize",b.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection();};
b.exitInteractiveResizing=function(m,e){var d=q(document);var t=this.$();var g=this.$("ghost");var i=b.getEventPosition(this,e).y;var n=i-t.find(".sapUiTableCCnt").offset().top-g.height()-t.find(".sapUiTableFtr").height();var u=Math.floor(n/m.getBaseRowHeightOfTable());var N=Math.max(1,u,m.getMinRowCount());if(m.bLegacy){N=Math.max(N,m.getFixedTopRowCount()+m.getFixedBottomRowCount()+1);this.setVisibleRowCount(N);}m.setRowCount(N);g.remove();this.$("rzoverlay").remove();d.off("touchend.sapUiTableInteractiveResize");d.off("touchmove.sapUiTableInteractiveResize");d.off("mouseup.sapUiTableInteractiveResize");d.off("mousemove.sapUiTableInteractiveResize");this._enableTextSelection();};
b.onMouseMoveWhileInteractiveResizing=function(e){var i=b.getEventPosition(this,e).y;var m=this.$().offset().top;if(i>m){this.$("ghost").css("top",i+"px");}};
b.getEventPosition=function(t,e){var p;function g(o){if(!t._isTouchEvent(o)){return null;}var c=["touches","targetTouches","changedTouches"];for(var i=0;i<c.length;i++){var s=c[i];if(e[s]&&e[s][0]){return e[s][0];}if(e.originalEvent[s]&&e.originalEvent[s][0]){return e.originalEvent[s][0];}}return null;}p=g(e)||e;return{x:p.pageX,y:p.pageY};};
return I;});
sap.ui.predefine('sap/ui/table/rowmodes/RowMode',["../library","../utils/TableUtils","sap/ui/core/Element","sap/base/Log","sap/ui/thirdparty/jquery"],function(l,T,E,L,q){"use strict";var _=T.createWeakMapFacade();
var R=E.extend("sap.ui.table.rowmodes.RowMode",{metadata:{library:"sap.ui.table","abstract":true}});
var a={};
R.prototype.init=function(){this._bFiredRowsUpdatedAfterRendering=false;_(this).bListeningForFirstRowsUpdatedAfterRendering=false;_(this).bNoDataDisabled=false;_(this).updateTableAsync=T.throttle(this.updateTable.bind(this),50,{asyncLeading:true});};
R.prototype.exit=function(){this.detachEvents();this.cancelAsyncOperations();this.deregisterHooks();};
R.prototype.setParent=function(){this.detachEvents();this.cancelAsyncOperations();this.deregisterHooks();E.prototype.setParent.apply(this,arguments);this.attachEvents();this.registerHooks();};
R.prototype.attachEvents=function(){T.addDelegate(this.getTable(),a,this);};
R.prototype.detachEvents=function(){T.removeDelegate(this.getTable(),a);};
R.prototype.cancelAsyncOperations=function(){var o=this.getTable();if(o){clearTimeout(o._mTimeouts.refreshRowsCreateRows);}_(this).updateTableAsync.cancel();};
R.prototype.registerHooks=function(){var o=this.getTable();var H=T.Hook.Keys;T.Hook.register(o,H.Table.RowsUnbound,this._onTableRowsUnbound,this);T.Hook.register(o,H.Table.UpdateRows,this._onTableUpdateRows,this);};
R.prototype.deregisterHooks=function(){var o=this.getTable();var H=T.Hook.Keys;T.Hook.deregister(o,H.Table.RowsUnbound,this._onTableRowsUnbound,this);T.Hook.deregister(o,H.Table.UpdateRows,this._onTableUpdateRows,this);};
R.prototype.getMinRequestLength=function(){t(this,"getMinRequestLength");};
R.prototype.getComputedRowCounts=function(){t(this,"getComputedRowCounts");};
R.prototype.getTableStyles=function(){t(this,"getTableStyles");};
R.prototype.getTableBottomPlaceholderStyles=function(){t(this,"getTableBottomPlaceholderStyles");};
R.prototype.getRowContainerStyles=function(){t(this,"getRowContainerStyles");};
R.prototype.getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};
R.prototype.updateTable=function(r){var o=this.getTable();if(!o){return;}_(this).updateTableAsync.cancel();var b=this.updateTableRows();if(o._bInvalid){return;}this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles();if(b||o.getRows().some(function(d){return d.getDomRef()==null;})){this.renderTableRows();}if(b||o.getRows().length>0){this.fireRowsUpdated(r);}};
R.prototype.getBaseRowContentHeight=function(){return 0;};
R.prototype.getBaseRowHeightOfTable=function(){var o=this.getTable();return o?o._getBaseRowHeight():0;};
R.prototype.getDefaultRowContentHeightOfTable=function(){var o=this.getTable();return o?o._getDefaultRowContentHeight():0;};
R.prototype.getTotalRowCountOfTable=function(){var o=this.getTable();return o?o._getTotalRowCount():0;};
R.prototype._onTableRowsUnbound=function(){clearTimeout(this.getTable()._mTimeouts.refreshRowsCreateRows);this.updateTable(T.RowsUpdateReason.Unbind);};
R.prototype._onTableUpdateRows=function(r){var o=this.getTable();clearTimeout(o._mTimeouts.refreshRowsCreateRows);_(this).updateTableAsync(r);};
R.prototype.applyTableStyles=function(r){var m=this.getTableStyles();if(r){r.style("height",m.height);r.style("min-height",m.minHeight);r.style("max-height",m.maxHeight);return;}var o=this.getTable();var b=o?o.getDomRef():null;if(b){b.style.height=m.height;b.style.minHeight=m.minHeight;b.style.maxHeight=m.maxHeight;}};
R.prototype.applyTableBottomPlaceholderStyles=function(r){var p=this.getTableBottomPlaceholderStyles();if(r){r.style("height",p.height);return;}var o=this.getTable();var P=o?o.getDomRef("placeholder-bottom"):null;if(P){P.style.height=p.height;}};
R.prototype.applyRowContainerStyles=function(r){var m=this.getRowContainerStyles();if(r){r.style("height",m.height);r.style("min-height",m.minHeight);r.style("max-height",m.maxHeight);return;}var o=this.getTable();var b=o?o.getDomRef("tableCCnt"):null;if(b){b.style.height=m.height;b.style.minHeight=m.minHeight;b.style.maxHeight=m.maxHeight;}};
R.prototype.computeStandardizedRowCounts=function(C,f,F){var r=this.getRowCountConstraints();if(r.fixedTop===true){f=1;}else if(r.fixedTop===false){f=0;}if(r.fixedBottom===true){F=1;}else if(r.fixedBottom===false){F=0;}C=Math.max(0,C);f=Math.max(0,f);F=Math.max(0,F);if(f+F>=C){F=Math.max(F>0?1:0,F-Math.max(0,(f+F-(C-1))));f=Math.max(f>0?1:0,f-Math.max(0,(f+F-(C-1))));}if(f+F>=C){F=0;}if(f+F>=C){f=0;}return{count:C,scrollable:C-f-F,fixedTop:f,fixedBottom:F};};
R.prototype.getRowCountConstraints=function(){var o=this.getTable();return o?o.getProperty("rowCountConstraints")||{}:{};};
R.prototype.renderRowStyles=function(r){};
R.prototype.renderCellContentStyles=function(r){};
R.prototype.initTableRowsAfterDataRequested=function(r){var o=this.getTable();var b=o.getBinding();clearTimeout(o._mTimeouts.refreshRowsCreateRows);if(!b||r<=0||o.getRows().length>0){return;}b.attachEventOnce("dataRequested",function(){clearTimeout(o._mTimeouts.refreshRowsCreateRows);o._mTimeouts.refreshRowsCreateRows=setTimeout(function(){if(o.getRows().length>0){return;}var d=c(o,r),e;for(var i=0;i<d.length;i++){e=d[i];e.setRowBindingContext(null,o);o.addAggregation("rows",e,true);}o._bRowAggregationInvalid=false;},0);});};
R.prototype.updateTableRows=function(){var o=this.getTable();var r=o.getRows();var n=this.getComputedRowCounts().count;var i;var b=false;if(T.isNoDataVisible(o)&&!o.getBinding()){n=0;}else if(T.isVariableRowHeightEnabled(o)&&n>0){n++;}if(o._bRowAggregationInvalid){b=r.length>0;o.destroyAggregation("rows",o._bInvalid?"KeepDom":true);r=[];}if(n===r.length){u(this,r);return b;}T.dynamicCall(o._getSyncExtension,function(s){s.syncRowCount(n);});if(r.length<n){var N=c(o,n-r.length);r=r.concat(N);u(this,r);for(i=0;i<N.length;i++){o.addAggregation("rows",N[i],true);}}else{for(i=r.length-1;i>=n;i--){o.removeAggregation("rows",i,true);}r.splice(n);u(this,r);}b=true;o._bRowAggregationInvalid=false;return b;};
R.prototype.renderTableRows=function(){var o=this.getTable();var b=o?o.getDomRef("tableCCnt"):null;if(!b){return;}var B=q.Event("BeforeRendering");B.setMarked("renderRows");B.srcControl=o;o._handleEvent(B);var r=sap.ui.getCore().createRenderManager();var d=o.getRenderer();d.renderTableCCnt(r,o);r.flush(b,false,false);r.destroy();var A=q.Event("AfterRendering");A.setMarked("renderRows");A.srcControl=o;o._handleEvent(A);var h=o.getRows().length>0;var D=o.getDomRef();D.querySelector(".sapUiTableCtrlBefore").setAttribute("tabindex",h?"0":"-1");D.querySelector(".sapUiTableCtrlAfter").setAttribute("tabindex",h?"0":"-1");};
R.prototype.getRowContexts=function(r){var o=this.getTable();return o?o._getRowContexts(r):[];};
R.prototype.fireRowsUpdated=function(r){var o=this.getTable();if(!o||!o._bContextsAvailable){return;}if(!this._bFiredRowsUpdatedAfterRendering){r=T.RowsUpdateReason.Render;if(!_(this).bListeningForFirstRowsUpdatedAfterRendering){_(this).bListeningForFirstRowsUpdatedAfterRendering=true;o.attachEvent("_rowsUpdated",function(){this._bFiredRowsUpdatedAfterRendering=true;_(this).bListeningForFirstRowsUpdatedAfterRendering=false;}.bind(this));}}o._fireRowsUpdated(r);};
R.prototype.disableNoData=function(){var o=this.getTable();if(o&&!this.isNoDataDisabled()){_(this).bNoDataDisabled=true;o.invalidate();}};
R.prototype.enableNoData=function(){var o=this.getTable();if(o&&this.isNoDataDisabled()){_(this).bNoDataDisabled=false;o.invalidate();}};
R.prototype.isNoDataDisabled=function(){return _(this).bNoDataDisabled;};
function c(o,r){var b=[];var s=o.getRows().length;for(var i=0;i<r;i++){b.push(o._getRowClone(s+i));}return b;}
function u(m,r){var o=m.getTable();if(!o||r.length===0){return;}var C=m.getRowContexts(r.length);for(var i=0;i<r.length;i++){r[i].setRowBindingContext(C[i],o);}}
function t(p,f){throw new Error(p+": sap.ui.table.rowmodes.RowMode subclass does not implement #"+f);}
a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this._bFiredRowsUpdatedAfterRendering=false;}};
return R;});
sap.ui.predefine('sap/ui/table/rowmodes/VariableRowMode',["../library","./RowMode"],function(l,R){"use strict";
var V=R.extend("sap.ui.table.rowmodes.VariableRowMode",{
metadata:{library:"sap.ui.table",properties:{tableHeight:{type:"sap.ui.core.CSSSize",defaultValue:"100%",group:"Dimension"}}},
constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});if(this.bLegacy){R.call(this);}else{R.apply(this,arguments);}}
});
V.prototype.getComputedRowCounts=function(){var t=this.getTotalRowCountOfTable();var r=this.getHideEmptyRows()?Math.min(this.getRowCount(),t):this.getRowCount();return{count:r,fixedTopCount:this.getFixedTopRowCount(),fixedBottomCount:this.getFixedBottomRowCount()};};
V.prototype.getComputedRowCounts=function(){var t=this.getTotalRowCountOfTable();var r=this.getHideEmptyRows()?Math.min(this.getRowCount(),t):this.getRowCount();return{count:r,fixedTopCount:this.getFixedTopRowCount(),fixedBottomCount:this.getFixedBottomRowCount()};};
V.prototype.getTableHeight=function(){return{height:this.getTableHeight()};};
V.prototype.getRowContainerHeight=function(){return{height:this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()};};
return V;});
sap.ui.predefine('sap/ui/table/utils/TableUtils',["./_GroupingUtils","./_ColumnUtils","./_MenuUtils","./_BindingUtils","./_HookUtils","../library","sap/ui/base/Object","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/ui/core/theming/Parameters","sap/ui/model/ChangeReason","sap/ui/thirdparty/jquery","sap/base/util/restricted/_throttle"],function(G,C,M,B,H,l,a,R,c,T,b,q,t){"use strict";var S=l.SelectionBehavior;var d=l.SelectionMode;var e=c.MessageType;var r;var f=null;var g={DATACELL:1<<1,COLUMNHEADER:1<<2,ROWHEADER:1<<3,ROWACTION:1<<4,COLUMNROWHEADER:1<<5,PSEUDO:1<<6};g.ANYCONTENTCELL=g.ROWHEADER|g.DATACELL|g.ROWACTION;g.ANYCOLUMNHEADER=g.COLUMNHEADER|g.COLUMNROWHEADER;g.ANYROWHEADER=g.ROWHEADER|g.COLUMNROWHEADER;g.ANY=g.ANYCONTENTCELL|g.ANYCOLUMNHEADER;var m={sapUiSizeCozy:48,sapUiSizeCompact:32,sapUiSizeCondensed:24,undefined:32};var h=1;var j=1;var D={sapUiSizeCozy:m.sapUiSizeCozy+j,sapUiSizeCompact:m.sapUiSizeCompact+j,sapUiSizeCondensed:m.sapUiSizeCondensed+j,undefined:m.undefined+j};var k={navigationIcon:"navigation-right-arrow",deleteIcon:"sys-cancel",clearSelectionIcon:"clear-all",navIndicatorWidth:3};var n={Render:"Render",VerticalScroll:"VerticalScroll",FirstVisibleRowChange:"FirstVisibleRowChange",Unbind:"Unbind",Animation:"Animation",Resize:"Resize",Zoom:"Zoom",Unknown:"Unknown"};for(var p in b){n[p]=b[p];}var I=":sapTabbable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)";var o={Grouping:G,Column:C,Menu:M,Binding:B,Hook:H,CELLTYPE:g,BaseSize:m,BaseBorderWidth:h,RowHorizontalFrameSize:j,DefaultRowHeight:D,RowsUpdateReason:n,INTERACTIVE_ELEMENT_SELECTORS:I,ThemeParameters:k,hasRowHeader:function(i){return(i.getSelectionMode()!==d.None&&i.getSelectionBehavior()!==S.RowOnly)||G.isInGroupMode(i);},hasSelectAll:function(i){var s=i?i.getSelectionMode():d.None;return s===d.MultiToggle&&i.getEnableSelectAll();},hasRowHighlights:function(i){if(!i){return false;}var s=i.getRowSettingsTemplate();if(!s){return false;}var u=s.getHighlight();return s.isBound("highlight")||(u!=null&&u!==e.None);},hasRowNavigationIndicators:function(i){if(!i){return false;}var s=i.getRowSettingsTemplate();if(!s){return false;}var N=s.getNavigated();return s.isBound("navigated")||N;},hasRowActions:function(i){var s=i?i.getRowActionTemplate():null;return s!=null&&(s.isBound("visible")||s.getVisible())&&i.getRowActionCount()>0;},isRowSelectionAllowed:function(i){return i.getSelectionMode()!==d.None&&(i.getSelectionBehavior()===S.Row||i.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(i){return i.getSelectionMode()!==d.None&&o.hasRowHeader(i);},areAllRowsSelected:function(i){if(!i){return false;}var s=i._getSelectionPlugin();var u=s.getSelectableCount();var v=s.getSelectedCount();return u>0&&u===v;},isNoDataVisible:function(i){return i.getShowNoData()&&!i._getRowMode().isNoDataDisabled()&&!o.hasData(i)||o.getVisibleColumnCount(i)===0;},hasData:function(i){var s=i.getBinding();var u=i._getTotalRowCount();var v=u>0;if(s&&s.providesGrandTotal){var w=s.providesGrandTotal()&&s.hasTotaledMeasures();v=(w&&u>1)||(!w&&u>0);}return v;},isBusyIndicatorVisible:function(i){if(!i||!i.getDomRef()){return false;}return i.getDomRef().querySelector("#"+i.getId()+"-sapUiTableGridCnt > .sapUiLocalBusyIndicator")!=null;},isA:function(O,v){return a.isA(O,v);},toggleRowSelection:function(i,v,s,u){if(!i||!i.getBinding()||i.getSelectionMode()===d.None||v==null){return false;}var w=i._getSelectionPlugin();function x(A){if(!w.isIndexSelectable(A)){return false;}i._iSourceRowIndex=A;var E=false;if(u){E=u(A,s);}else if(w.isIndexSelected(A)){if(s!==true){E=true;w.removeSelectionInterval(A,A);}}else if(s!==false){E=true;w.addSelectionInterval(A,A);}delete i._iSourceRowIndex;return E;}if(typeof v==="number"){if(v<0||v>=i._getTotalRowCount()){return false;}return x(v);}else{var $=q(v);var y=o.getCellInfo($[0]);var z=o.isRowSelectionAllowed(i);if(!o.Grouping.isInGroupHeaderRow($[0])&&((y.isOfType(o.CELLTYPE.DATACELL|o.CELLTYPE.ROWACTION)&&z)||(y.isOfType(o.CELLTYPE.ROWHEADER)&&o.isRowSelectorSelectionAllowed(i)))){var A=i.getRows()[y.rowIndex].getIndex();return x(A);}return false;}},getNoDataText:function(i){if(o.getVisibleColumnCount(i)===0){return o.getResourceText("TBL_NO_COLUMNS");}var N=i.getNoData();if(o.isA(N,"sap.ui.core.Control")){return null;}else if(typeof N==="string"){return N;}else{return o.getResourceText("TBL_NO_DATA");}},getVisibleColumnCount:function(i){return i._getVisibleColumns().length;},getHeaderRowCount:function(s){if(s._iHeaderRowCount===undefined){if(!s.getColumnHeaderVisible()){s._iHeaderRowCount=0;}else{var u=1;var v=s.getColumns();for(var i=0;i<v.length;i++){if(v[i].shouldRender()){u=Math.max(u,v[i].getMultiLabels().length);}}s._iHeaderRowCount=u;}}return s._iHeaderRowCount;},isVariableRowHeightEnabled:function(i){var s=i._getRowCounts();return i&&i._bVariableRowHeightEnabled&&!s.fixedTop&&!s.fixedBottom;},getNonEmptyRowCount:function(i){return Math.min(i._getRowCounts().count,i._getTotalRowCount());},getFocusedItemInfo:function(i){var s=i._getItemNavigation();if(!s){return null;}return{cell:s.getFocusedIndex(),columnCount:s.iColumns,cellInRow:s.getFocusedIndex()%s.iColumns,row:Math.floor(s.getFocusedIndex()/s.iColumns),cellCount:s.getItemDomRefs().length,domRef:s.getFocusedDomRef()};},getRowIndexOfFocusedCell:function(i){var s=o.getFocusedItemInfo(i);return s.row-o.getHeaderRowCount(i);},isFixedColumn:function(i,s){return s<i.getComputedFixedColumnCount();},hasFixedColumns:function(i){return i.getComputedFixedColumnCount()>0;},focusItem:function(i,s,E){var u=i._getItemNavigation();if(u){u.focusItem(s,E);}},getCellInfo:function(i){var s;var $=q(i);var u;var v;var w;var x;var y;s={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};if($.hasClass("sapUiTableDataCell")){u=$.attr("data-sap-ui-colid");v=sap.ui.getCore().byId(u);s.type=o.CELLTYPE.DATACELL;s.rowIndex=parseInt($.parent().attr("data-sap-ui-rowindex"));s.columnIndex=v.getIndex();s.columnSpan=1;}else if($.hasClass("sapUiTableHeaderDataCell")){w=/_([\d]+)/;u=$.attr("id");x=w.exec(u);y=x&&x[1]!=null?parseInt(x[1]):0;s.type=o.CELLTYPE.COLUMNHEADER;s.rowIndex=y;s.columnIndex=parseInt($.attr("data-sap-ui-colindex"));s.columnSpan=parseInt($.attr("colspan")||1);}else if($.hasClass("sapUiTableRowSelectionCell")){s.type=o.CELLTYPE.ROWHEADER;s.rowIndex=parseInt($.parent().attr("data-sap-ui-rowindex"));s.columnIndex=-1;s.columnSpan=1;}else if($.hasClass("sapUiTableRowActionCell")){s.type=o.CELLTYPE.ROWACTION;s.rowIndex=parseInt($.parent().attr("data-sap-ui-rowindex"));s.columnIndex=-2;s.columnSpan=1;}else if($.hasClass("sapUiTableRowSelectionHeaderCell")){s.type=o.CELLTYPE.COLUMNROWHEADER;s.columnIndex=-1;s.columnSpan=1;}else if($.hasClass("sapUiTablePseudoCell")){u=$.attr("data-sap-ui-colid");v=sap.ui.getCore().byId(u);s.type=o.CELLTYPE.PSEUDO;s.rowIndex=-1;s.columnIndex=v?v.getIndex():-1;s.columnSpan=1;}if(s.type!==0){s.cell=$;}s.isOfType=function(z){if(z==null){return false;}return(this.type&z)>0;};return s;},getRowColCell:function(i,s,u,v){var w=i.getRows()[s]||null;var x=v?i.getColumns():i._getVisibleColumns();var y=x[u]||null;var z;var A=null;if(w&&y){if(!z){var E=y.getMetadata();while(E.getName()!=="sap.ui.table.Column"){E=E.getParent();}z=E.getClass();}A=w.getCells().find(function(A){return y===z.ofCell(A);})||null;}return{row:w,column:y,cell:A};},getCell:function(i,E,s){s=s===true;if(!i||!E){return null;}var $=q(E);var u=i.getDomRef();var v=".sapUiTableCell";if(!s){v+=":not(.sapUiTablePseudoCell)";}var w=$.closest(v,u);if(w.length>0){return w;}return null;},getParentCell:function(i,E,s){s=s===true;var $=q(E);var u=o.getCell(i,E,s);if(!u||u[0]===$[0]){return null;}else{return u;}},registerResizeHandler:function(i,s,u,v,w){v=v==null?"":v;w=w===true;if(!i||typeof s!=="string"||typeof u!=="function"){return undefined;}var x=i.getDomRef(v);o.deregisterResizeHandler(i,s);if(!i._mResizeHandlerIds){i._mResizeHandlerIds={};}if(w&&x){x=x.parentNode;}if(x){i._mResizeHandlerIds[s]=R.register(x,u);}return i._mResizeHandlerIds[s];},deregisterResizeHandler:function(s,v){var u=[];if(!s._mResizeHandlerIds){return;}if(typeof v==="string"){u.push(v);}else if(v===undefined){for(var K in s._mResizeHandlerIds){if(typeof K=="string"&&s._mResizeHandlerIds.hasOwnProperty(K)){u.push(K);}}}else if(Array.isArray(v)){u=v;}for(var i=0;i<u.length;i++){var w=u[i];if(s._mResizeHandlerIds[w]){R.deregister(s._mResizeHandlerIds[w]);s._mResizeHandlerIds[w]=undefined;}}},isFirstScrollableRow:function(i,s){if(isNaN(s)){var $=q(s);s=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"));}return s==i._getRowCounts().fixedTop;},isLastScrollableRow:function(i,s){if(isNaN(s)){var $=q(s);s=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"));}var u=i._getRowCounts();return s==u.count-u.fixedBottom-1;},getContentDensity:function(s){var u;var v=["sapUiSizeCondensed","sapUiSizeCompact","sapUiSizeCozy"];var w=function(F,O){if(!O[F]){return;}for(var i=0;i<v.length;i++){if(O[F](v[i])){return v[i];}}};var $=s.$();if($.length>0){u=w("hasClass",$);}else{u=w("hasStyleClass",s);}if(u){return u;}var P=null;var x=s.getParent();if(x){do{u=w("hasStyleClass",x);if(u){return u;}if(x.getDomRef){P=x.getDomRef();}else if(x.getRootNode){P=x.getRootNode();}if(!P&&x.getParent){x=x.getParent();}else{x=null;}}while(x&&!P);}$=q(P||document.body);u=w("hasClass",$.closest("."+v.join(",.")));return u;},isVariableWidth:function(w){return!w||w=="auto"||w.toString().match(/%$/);},getFirstFixedBottomRowIndex:function(i){var s=i._getRowCounts();if(!i.getBinding()||s.fixedBottom===0){return-1;}var F=-1;var u=i.getFirstVisibleRow();var v=i._getTotalRowCount();if(v>=s.count){F=s.count-s.fixedBottom;}else{var w=v-s.fixedBottom-u;if(w>=0&&(u+w)<v){F=w;}}return F;},getResourceBundle:function(O){O=q.extend({async:false,reload:false},O);if(r&&O.reload!==true){if(O.async===true){return Promise.resolve(r);}else{return r;}}var v=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table",O.async===true);if(v instanceof Promise){v=v.then(function(i){r=i;return r;});}else{r=v;}return v;},getResourceText:function(K,v){return r?r.getText(K,v):"";},dynamicCall:function(O,v,i){var s=typeof O==="function"?O():O;if(!s||!v){return undefined;}i=i||s;if(typeof v==="function"){v.call(i,s);return undefined;}else{var P;var u=[];for(var F in v){if(typeof s[F]==="function"){P=v[F];u.push(s[F].apply(i,P));}else{u.push(undefined);}}if(u.length===1){return u[0];}else{return u;}}},throttle:function(i,w,O){O=Object.assign({leading:true,asyncLeading:false,trailing:true},O);var s;var u=false;var L={};var _;var v;if(O.leading&&O.asyncLeading){_=function(){if(u){var P=Promise.resolve().then(function(){if(!P.canceled){i.apply(L.context,L.args);}s=null;});P.cancel=function(){P.canceled=true;};s=P;}else{i.apply(this,arguments);}};}else{_=i;}var x=t(_,w,{leading:O.leading,trailing:O.trailing});if(O.leading&&O.asyncLeading){var y=x.cancel;x.cancel=function(){if(s){s.cancel();}y();};v=Object.assign(function(){L={context:this,args:arguments};u=true;x.apply(this,arguments);u=false;},x);}else{v=x;}return v;},throttleFrameWise:function(i){var A=null;var s=function(){s.cancel();A=window.requestAnimationFrame(function(u){i.apply(this,u);}.bind(this,arguments));};s.cancel=function(){window.cancelAnimationFrame(A);A=null;};return s;},getInteractiveElements:function(i){if(!i){return null;}var $=q(i);var s=o.getCellInfo($);if(s.isOfType(g.ANY|g.PSEUDO)){var u=$.find(I);if(u.length>0){return u;}}return null;},getFirstInteractiveElement:function(s,u){if(!s){return null;}var v=s.getTable();var w=s.getCells();if(u===true&&this.hasRowActions(v)){w.push(s.getRowAction());}for(var i=0;i<w.length;i++){var x=w[i].getDomRef();var $=this.getCell(v,x,true);var y=o.getInteractiveElements($);if(y){return y[0];}}return null;},convertCSSSizeToPixel:function(s,w){var P;if(typeof s!=="string"){return null;}if(s.endsWith("px")){P=parseFloat(s);}else if(s.endsWith("em")||s.endsWith("rem")){P=parseFloat(s)*o.getBaseFontSize();}else{return null;}if(w){return P+"px";}else{return P;}},getBaseFontSize:function(){if(f==null){var i=document.documentElement;if(i){f=parseInt(window.getComputedStyle(i).fontSize);}}return f==null?16:f;},readThemeParameters:function(){var P=T.get({name:["_sap_ui_table_BaseSize","_sap_ui_table_BaseSizeCozy","_sap_ui_table_BaseSizeCompact","_sap_ui_table_BaseSizeCondensed","_sap_ui_table_BaseBorderWidth","_sap_ui_table_NavigationIcon","_sap_ui_table_DeleteIcon","_sap_ui_table_ClearSelectionIcon","_sap_ui_table_NavIndicatorWidth"]});function i(s){return o.convertCSSSizeToPixel(P[s]);}m.undefined=i("_sap_ui_table_BaseSize");m.sapUiSizeCozy=i("_sap_ui_table_BaseSizeCozy");m.sapUiSizeCompact=i("_sap_ui_table_BaseSizeCompact");m.sapUiSizeCondensed=i("_sap_ui_table_BaseSizeCondensed");h=i("_sap_ui_table_BaseBorderWidth");j=h;D.undefined=m.undefined+j;D.sapUiSizeCozy=m.sapUiSizeCozy+j;D.sapUiSizeCompact=m.sapUiSizeCompact+j;D.sapUiSizeCondensed=m.sapUiSizeCondensed+j;k.navigationIcon=P["_sap_ui_table_NavigationIcon"];k.deleteIcon=P["_sap_ui_table_DeleteIcon"];k.clearSelectionIcon=P["_sap_ui_table_ClearSelectionIcon"];k.navIndicatorWidth=i("_sap_ui_table_NavIndicatorWidth");},addDelegate:function(E,i,s){if(E&&i){E.addDelegate(i,false,s?s:i,false);}},removeDelegate:function(E,i){if(E&&i){E.removeDelegate(i);}},createWeakMapFacade:function(){var w=new window.WeakMap();return function(K){if(!K||!(typeof K==="object")){return null;}if(!w.has(K)){w.set(K,{});}return w.get(K);};}};G.TableUtils=o;C.TableUtils=o;M.TableUtils=o;B.TableUtils=o;H.TableUtils=o;return o;},true);
sap.ui.predefine('sap/ui/table/utils/_BindingUtils',[],function(){"use strict";var B={TableUtils:null,metadataLoaded:function(t){var b=t.getBinding();var m=b?b.getModel():null;var r=null;var R=null;var p=new Promise(function(a,c){r=a;R=c;});if(!m){R();return p;}if(m.metadataLoaded){m.metadataLoaded().then(function(){r();});}else if(m.attachMetadataLoaded){if(m.oMetadata&&m.oMetadata.isLoaded()){r();}else{m.attachMetadataLoaded(function(){r();});}}return p;}};return B;},true);
sap.ui.predefine('sap/ui/table/utils/_ColumnUtils',["sap/ui/Device","../library","sap/base/Log"],function(D,l,L){"use strict";var C={TableUtils:null,initColumnUtils:function(t){if(!t._oColumnInfo){C.updateColumnInfo(t,C.collectColumnInfo(t));}},invalidateColumnUtils:function(t){t._oColumnInfo=null;},updateColumnInfo:function(t,c){t._oColumnInfo=c;},collectColumnInfo:function(t){return{columnCount:t.getColumns().length,visibleColumnCount:C.TableUtils.getVisibleColumnCount(t),columnMap:C.getColumnMap(t)};},getColumnMap:function(t){var i;var c;var o={};var a={};var b=t.getColumns();var m=C.TableUtils.getHeaderRowCount(t);var p={};for(var d=0;d<b.length;d++){c=b[d];o={};o.id=c.getId();o.column=c;o.levelInfo=[];o.parents=[];for(var e=0;e<m;e++){o.levelInfo[e]={};o.levelInfo[e].spannedColumns=[];var h=C.getHeaderSpan(c,e);for(i=1;i<h;i++){var s=b[d+i];if(s){var P=s.getId();o.levelInfo[e].spannedColumns.push(b[d+i]);if(!p[P]){p[P]=[];}p[P].push({column:c,level:e});}}}a[o.id]=o;}var f=Object.keys(p);for(i=0;i<f.length;i++){var g=f[i];a[g].parents=p[g];}return a;},getColumnMapItem:function(t,c){C.initColumnUtils(t);var s=t._oColumnInfo.columnMap[c];if(!s){L.error("Column with ID '"+c+"' not found",t);}else{return s;}},getParentSpannedColumns:function(t,c,a){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var p=[];for(var i=0;i<o.parents.length;i++){var P=o.parents[i];if(a===undefined||P.level===a){p.push(P);}}return p;},getChildrenSpannedColumns:function(t,c,a){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var b=[];var e;if(a===undefined){e=o.levelInfo.length;}else{e=a+1;}for(var i=a||0;i<e;i++){var d=o.levelInfo[i];for(var j=0;j<d.spannedColumns.length;j++){b.push({column:d.spannedColumns[j],level:i});}}return b;},getHeaderSpan:function(c,i){var h=c.getHeaderSpan();var H;if(!h){return 1;}if(!Array.isArray(h)){h=(h+"").split(",");}function g(s){var r=parseInt(s);return isNaN(r)?1:r;}if(isNaN(i)){H=Math.max.apply(null,h.map(g));}else{H=g(h[i]);}return Math.max(H,1);},getMaxHeaderSpan:function(c){return C.getHeaderSpan(c);},hasHeaderSpan:function(c){return C.getHeaderSpan(c)>1;},getColumnBoundaries:function(t,c){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var m={};if(c){m[c]=o.column;}var T=function(m,n){var e;var i;var f=[];n=n||[];for(i=0;i<n.length;i++){e=m[n[i]];f=f.concat(C.getParentSpannedColumns(t,e.getId()));f=f.concat(C.getChildrenSpannedColumns(t,e.getId()));}n=[];for(i=0;i<f.length;i++){e=f[i].column;var c=e.getId();if(!m[c]){n.push(c);m[c]=e;}}if(n.length>0){return T(m,n);}else{return m;}};m=T(m,[c]);var a=t.indexOfColumn(o.column);var b={startColumn:o.column,startIndex:a,endColumn:o.column,endIndex:-1};var d=t.getColumns();var k=Object.getOwnPropertyNames(m);for(var i=0;i<k.length;i++){var e=m[k[i]];a=t.indexOfColumn(e);var h=C.getMaxHeaderSpan(e);if(a<b.startIndex){b.startIndex=a;b.startColumn=e;}var E=a+h-1;if(E>b.endIndex){b.endIndex=E;b.endColumn=d[E];}}return b;},isColumnMovable:function(c){var t=c.getParent();if(!t||!t.getEnableColumnReordering()){return false;}var i=t.indexOfColumn(c);if(i<t.getComputedFixedColumnCount()||i<t._iFirstReorderableIndex){return false;}if(C.hasHeaderSpan(c)||C.getParentSpannedColumns(t,c.getId()).length!=0){return false;}return true;},normalizeColumnMoveTargetIndex:function(c,n){var t=c.getParent(),i=t.indexOfColumn(c),a=t.getColumns();if(n>i){n--;}if(n<0){n=0;}else if(n>a.length){n=a.length;}return n;},isColumnMovableTo:function(c,n){var t=c.getParent();if(!t||n===undefined||!C.isColumnMovable(c)){return false;}n=C.normalizeColumnMoveTargetIndex(c,n);if(n<t.getComputedFixedColumnCount()||n<t._iFirstReorderableIndex){return false;}var i=t.indexOfColumn(c),a=t.getColumns();if(n>i){var b=a[n>=a.length?a.length-1:n];var T=C.getColumnBoundaries(t,b.getId());if(C.hasHeaderSpan(b)||T.endIndex>n){return false;}}else{var A=a[n];if(C.getParentSpannedColumns(t,A.getId()).length!=0){return false;}}return true;},moveColumnTo:function(c,n){if(!C.isColumnMovableTo(c,n)){return false;}var t=c.getParent(),i=t.indexOfColumn(c);if(n===i){return false;}n=C.normalizeColumnMoveTargetIndex(c,n);var e=t.fireColumnMove({column:c,newPos:n});if(!e){return false;}t._bReorderInProcess=true;t.removeColumn(c,true);t.insertColumn(c,n);t._bReorderInProcess=false;return true;},getMinColumnWidth:function(){if(this._iColMinWidth){return this._iColMinWidth;}this._iColMinWidth=48;if(!D.system.desktop){this._iColMinWidth=88;}return this._iColMinWidth;},resizeColumn:function(t,c,w,f,a){if(!t||c==null||c<0||w==null||w<=0){return false;}if(a==null||a<=0){a=1;}if(f==null){f=true;}var b=t.getColumns();if(c>=b.length||!b[c].getVisible()){return false;}var v=[];for(var i=c;i<b.length;i++){var o=b[i];if(o.getVisible()){v.push(o);if(v.length===a){break;}}}var r=[];for(var i=0;i<v.length;i++){var V=v[i];if(V.getResizable()){r.push(V);}}if(r.length===0){return false;}var s=0;for(var i=0;i<v.length;i++){var V=v[i];s+=C.getColumnWidth(t,V.getIndex());}var p=w-s;var S=Math.round(p/r.length);var R=false;var T=t.getDomRef();if(!C.TableUtils.isFixedColumn(t,c)){t._getVisibleColumns().forEach(function(k){var m=k.getWidth(),q;if(T&&r.indexOf(k)<0&&C.TableUtils.isVariableWidth(m)){q=T.querySelector("th[data-sap-ui-colid=\""+k.getId()+"\"]");if(q){k._minWidth=Math.max(q.offsetWidth,C.getMinColumnWidth());}}});}for(var i=0;i<r.length;i++){var d=r[i];var e=C.getColumnWidth(t,d.getIndex());var n=e+S;var g=C.getMinColumnWidth();if(n<g){n=g;}var W=n-e;if(Math.abs(W)<Math.abs(S)){var h=r.length-(i+1);p-=W;S=Math.round(p/h);}if(W!==0){var E=true;var j=n+"px";if(f){E=t.fireColumnResize({column:d,width:j});}if(E){d.setWidth(j);R=true;}}}return R;},getColumnWidth:function(t,c){if(!t||c==null||c<0){return null;}var a=t.getColumns();if(c>=a.length){return null;}var o=a[c];var s=o.getWidth();if(s===""||s==="auto"||s.match(/%$/)){if(o.getVisible()){var b=o.getDomRef();return b?b.offsetWidth:0;}else{return 0;}}else{return C.TableUtils.convertCSSSizeToPixel(s);}},getHeaderText:function(t,c){if(!t||c==null||c<0){return null;}var a=t.getColumns();if(c>=a.length){return null;}function g(b){return b&&b.getText&&b.getText()||"";}var o=a[c];var T=o.getName();if(!T){var m=o.getMultiLabels();for(var i=m.length-1;i>=0;i--){var s=g(m[i]);if(C.getHeaderSpan(o,i)===1&&s){T=s;break;}}}if(!T){T=g(o.getLabel());}return T;}};return C;},true);
sap.ui.predefine('sap/ui/table/utils/_GroupingUtils',["sap/ui/model/Sorter","sap/ui/Device","sap/ui/thirdparty/jquery"],function(S,D,q){"use strict";var T=new window.WeakMap();var G={TableUtils:null,HierarchyMode:{Flat:"Flat",Group:"Group",Tree:"Tree",GroupedTree:"GroupedTree"},setHierarchyMode:function(t,m){if(!G.TableUtils.isA(t,"sap.ui.table.Table")||!(m in G.HierarchyMode)){return;}var c=G.getHierarchyMode(t);if(c!==m){T.set(t,m);t.invalidate();}},getHierarchyMode:function(t){return G.TableUtils.isA(t,"sap.ui.table.Table")?T.get(t)||G.HierarchyMode.Flat:null;},setToDefaultFlatMode:function(t){G.setHierarchyMode(t,G.HierarchyMode.Flat);},setToDefaultGroupMode:function(t){G.setHierarchyMode(t,G.HierarchyMode.Group);},setToDefaultTreeMode:function(t){G.setHierarchyMode(t,G.HierarchyMode.Tree);},isInFlatMode:function(t){return G.getHierarchyMode(t)===G.HierarchyMode.Flat;},isInGroupMode:function(t){var h=G.getHierarchyMode(t);return h===G.HierarchyMode.Group||h===G.HierarchyMode.GroupedTree;},isInTreeMode:function(t){return G.getHierarchyMode(t)===G.HierarchyMode.Tree;},getModeCssClass:function(t){switch(G.getHierarchyMode(t)){case G.HierarchyMode.Group:case G.HierarchyMode.GroupedTree:return"sapUiTableGroupMode";case G.HierarchyMode.Tree:return"sapUiTableTreeMode";default:return null;}},showGroupMenuButton:function(t){return!D.system.desktop&&G.TableUtils.isA(t,"sap.ui.table.AnalyticalTable");},isInGroupHeaderRow:function(c){var i=G.TableUtils.getCellInfo(c);if(i.isOfType(G.TableUtils.CELLTYPE.ANYCONTENTCELL)){return i.cell.parent().hasClass("sapUiTableGroupHeaderRow");}return false;},isInSummaryRow:function(c){var i=G.TableUtils.getCellInfo(c);if(i.isOfType(G.TableUtils.CELLTYPE.ANYCONTENTCELL)){return i.cell.parent().hasClass("sapUiTableSummaryRow");}return false;},calcGroupIndent:function(r){var t=G.getHierarchyMode(r.getTable())===G.HierarchyMode.GroupedTree;var R=!t&&!r.isGroupHeader()&&!r.isTotalSummary();var l=r.getLevel()-(R?1:0);var I=0;for(var i=1;i<l;i++){if(i===1){I=24;}else if(i===2){I+=12;}else{I+=8;}}return I;},calcTreeIndent:function(r){return(r.getLevel()-1)*17;},setGroupIndent:function(r,i){var d=r.getDomRefs(true);var R=d.row;var $=d.rowHeaderPart;var b=r.getTable()._bRtlMode;var f=R.find("td.sapUiTableCellFirst > .sapUiTableCellInner");var s=$.find(".sapUiTableGroupShield");if(i<=0){$.css(b?"right":"left","");s.css("width","").css(b?"margin-right":"margin-left","");f.css(b?"padding-right":"padding-left","");R.css("--CalculatedGroupIndent","0");}else{$.css(b?"right":"left",i+"px");s.css("width",i+"px").css(b?"margin-right":"margin-left",((-1)*i)+"px");f.css(b?"padding-right":"padding-left",(i+8)+"px");R.css("--CalculatedGroupIndent",i+"px");}},setTreeIndent:function(r,i){var d=r.getDomRefs(true);var R=d.row;var b=r.getTable()._bRtlMode;var t=R.find(".sapUiTableTreeIcon");t.css(b?"margin-right":"margin-left",i>0?i+"px":"");},updateTableRowForGrouping:function(r){var t=r.getTable();var d=r.getDomRefs(true);var R=d.row;var i=r.isExpanded();var I=r.isExpandable();R.toggleClass("sapUiTableSummaryRow",r.isSummary());if(G.isInGroupMode(t)){var s=r.getTitle();var a=G.calcGroupIndent(r);r.$("groupHeader").toggleClass("sapUiTableGroupIconOpen",I&&i).toggleClass("sapUiTableGroupIconClosed",I&&!i).attr("title",t._getShowStandardTooltips()&&s?s:null).text(s);G.setGroupIndent(r,a);R.toggleClass("sapUiTableRowIndented",a>0).toggleClass("sapUiTableGroupHeaderRow",r.isGroupHeader());if(G.showGroupMenuButton(t)){var $=t.$();var b=$.hasClass("sapUiTableVScr")?$.find(".sapUiTableVSb").width():0;var g=d.rowHeaderPart.find(".sapUiTableGroupMenuButton");var m=$.width()-g.width()-b-5-a;g.css(t._bRtlMode?"right":"left",m+"px");}}if(G.isInTreeMode(t)){var c=R.find(".sapUiTableTreeIcon");if(!I&&document.activeElement===c[0]){G.TableUtils.getParentCell(t,c[0]).trigger("focus");}c.toggleClass("sapUiTableTreeIconLeaf",!I).toggleClass("sapUiTableTreeIconNodeOpen",I&&i).toggleClass("sapUiTableTreeIconNodeClosed",I&&!i);G.setTreeIndent(r,G.calcTreeIndent(r));}if(!G.isInFlatMode(t)){t._getAccExtension().updateAriaExpandAndLevelState(r);}},cleanupTableRowForGrouping:function(r){var t=r.getTable();var d=r.getDomRefs(true);if(G.isInGroupMode(t)){d.row.removeClass("sapUiTableGroupHeaderRow sapUiTableSummaryRow sapUiTableRowIndented");r.$("groupHeader").removeClass("sapUiTableGroupIconOpen","sapUiTableGroupIconClosed").attr("title","").text("");G.setGroupIndent(r,0);}if(G.isInTreeMode(t)){d.row.find(".sapUiTableTreeIcon").removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed");G.setTreeIndent(r,0);}t._getAccExtension().updateAriaExpandAndLevelState(r);},updateGroups:function(t){if(t.getBinding()){t.getRows().forEach(function(r){G.updateTableRowForGrouping(r);});}else{t.getRows().forEach(function(r){G.cleanupTableRowForGrouping(r);});}},setupExperimentalGrouping:function(t){if(!t.getEnableGrouping()){return;}var b=t.getBinding();var g=sap.ui.getCore().byId(t.getGroupBy());var I=g&&g.getGrouped()&&G.TableUtils.isA(b,"sap.ui.model.ClientListBinding");if(!I||b._modified){return;}b._modified=true;G.setToDefaultGroupMode(t);var p=g.getSortProperty();b.sort(new S(p));var l=t._getTotalRowCount(),c=b.getContexts(0,l);var k;var C=0;for(var i=l-1;i>=0;i--){var n=c[i].getProperty(p);if(!k){k=n;}if(k!==n){var o=c[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);o.__groupInfo={oContext:c[i+1],name:k,count:C,groupHeader:true,expanded:true};c.splice(i+1,0,o);k=n;C=0;}C++;}var o=c[0].getModel().getContext("/sap.ui.table.GroupInfo");o.__groupInfo={oContext:c[0],name:k,count:C,groupHeader:true,expanded:true};c.splice(0,0,o);q.extend(b,{getLength:function(){return c.length;},getContexts:function(s,l){return c.slice(s,s+l);}});function a(d){var e=c[d];return(e&&e.__groupInfo&&e.__groupInfo.groupHeader)===true;}t._experimentalGroupingRowState=function(s){var d=s.context;if((d&&d.__groupInfo&&d.__groupInfo.groupHeader)===true){s.type=s.Type.GroupHeader;}s.title=d&&d.__groupInfo&&d.__groupInfo.name+" - "+d.__groupInfo.count;s.expandable=s.type===s.Type.GroupHeader;s.expanded=s.expandable&&d.__groupInfo&&d.__groupInfo.expanded;s.level=s.expandable?1:2;s.contentHidden=s.expandable;};t._experimentalGroupingExpand=function(r){var R=r.getIndex();if(a(R)&&!c[R].__groupInfo.expanded){for(var i=0;i<c[R].__childs.length;i++){c.splice(R+1+i,0,c[R].__childs[i]);}delete c[R].__childs;c[R].__groupInfo.expanded=true;b._fireChange();}};t._experimentalGroupingCollapse=function(r){var R=r.getIndex();if(a(R)&&c[R].__groupInfo.expanded){c[R].__childs=c.splice(R+1,c[R].__groupInfo.count);c[R].__groupInfo.expanded=false;b._fireChange();}};var H=G.TableUtils.Hook;H.register(t,H.Keys.Row.UpdateState,t._experimentalGroupingRowState);H.register(t,H.Keys.Row.Expand,t._experimentalGroupingExpand);H.register(t,H.Keys.Row.Collapse,t._experimentalGroupingCollapse);t._mTimeouts.groupingFireBindingChange=t._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){b._fireChange();},0);},resetExperimentalGrouping:function(t){var b=t.getBinding();var H=G.TableUtils.Hook;if(b&&b._modified){G.setToDefaultFlatMode(t);t.bindRows(t.getBindingInfo("rows"));}H.deregister(t,H.Keys.Row.UpdateState,t._experimentalGroupingRowState);H.deregister(t,H.Keys.Row.Expand,t._experimentalGroupingExpand);H.deregister(t,H.Keys.Row.Collapse,t._experimentalGroupingCollapse);delete t._experimentalGroupingRowState;delete t._experimentalGroupingExpand;delete t._experimentalGroupingCollapse;}};return G;},true);
sap.ui.predefine('sap/ui/table/utils/_HookUtils',["sap/ui/base/DataType","sap/base/Log"],function(D,L){"use strict";var H=new window.WeakMap();var M={};var k={};var h={};var f=["function"];var a={};var m={Table:{BindRows:{arguments:[{type:"object"}]},RowsBound:{arguments:[{type:"class:sap.ui.model.Binding"}]},UnbindRows:{arguments:[{type:"object"}]},RowsUnbound:{arguments:[]},RefreshRows:{arguments:[{type:j}]},UpdateRows:{arguments:[{type:j}]},UpdateSizes:{arguments:[{type:j}]},OpenMenu:{arguments:[{type:l},{type:"class:sap.ui.unified.Menu"}]},TotalRowCountChanged:{arguments:[]}},Row:{UpdateState:{arguments:[{type:n}]},Expand:{arguments:[{type:"class:sap.ui.table.Row"}]},Collapse:{arguments:[{type:"class:sap.ui.table.Row"}]}},Column:{MenuItemNotification:{arguments:[{type:"class:sap.ui.table.Column"}],returnValue:"boolean"}},Signal:{arguments:[{type:"string"}]}};a.TableUtils=null;a.Keys=k;
a.call=function(S,K){var i=H.get(S);if(!c(S)||!b(K)){return undefined;}var m=g(K);if(i==null){if(m.returnValue){return[];}return undefined;}var A=s(Array.prototype.slice.call(arguments,2));var o=v(m,A);if(!o){throw new Error("Hook with key "+K+" was not called. Invalid arguments passed\n"+S);}var r=i.map(function(p){if(p.key===M){var C={};var q=p.handlerContext==null?p.target:p.handlerContext;C[K]=A;return a.TableUtils.dynamicCall(p.target,C,q);}else if(p.key===K){return p.handler.apply(p.handlerContext,A);}});r=d(m,r);return r;};
a.install=function(S,t,T){if(!t||!c(S)){return;}var i=H.get(S);if(i==null){i=[];}var o=i.some(function(p){return p.key===M&&p.target===t&&p.handlerContext===T;});if(o){return;}i.push({key:M,target:t,handlerContext:T});H.set(S,i);};
a.uninstall=function(S,t,T){var o=H.get(S);if(o==null||!t){return;}for(var i=0;i<o.length;i++){var p=o[i];if(p.key===M&&p.target===t&&p.handlerContext===T){o.splice(i,1);break;}}if(o.length===0){H.delete(S);}else{H.set(S,o);}};
a.register=function(S,K,i,t){if(typeof i!=="function"||!c(S)||!b(K)){return;}var o=H.get(S);if(o==null){o=[];}o.push({key:K,handler:i,handlerContext:t});H.set(S,o);};
a.deregister=function(S,K,o,t){var p=H.get(S);if(p==null){return;}for(var i=0;i<p.length;i++){var q=p[i];if(q.key===K&&q.handler===o&&q.handlerContext===t){p.splice(i,1);break;}}if(p.length===0){H.delete(S);}else{H.set(S,p);}};
function e(K,C,i){Object.keys(C).forEach(function(p){var o=i?i+"."+p:p;if("arguments"in C[p]){f.forEach(function(F){if(C[p].arguments.indexOf(F)>-1||C[p].returnValue===F){throw new Error("Forbidden type found in metadata of hook "+i+": "+F);}});K[p]=o;h[o]=C[p];}else{K[p]={};e(K[p],C[p],o);}});return K;}
e(k,m);
function b(K){return K in h;}
function c(S){return a.TableUtils.isA(S,"sap.ui.table.Table")&&!S.bIsDestroyed&&!S._bIsBeingDestroyed;}
function g(K){return h[K];}
function s(A){while(A.length>0){var i=A.pop();if(i!=null){A.push(i);break;}}A.map(function(i){if(i===null){return undefined;}else{return i;}});return A;}
function v(m,A){return m.arguments.length>=A.length&&A.every(function(V,i){var o=m.arguments[i];if(typeof o.type==="function"){return o.type(V);}if(o.type.startsWith("class:")){return a.TableUtils.isA(V,o.type.substring(6));}return o.optional===true&&V==null||D.getType(o.type).isValid(V);});}
function d(m,V){if(!m.returnValue){return undefined;}var t=m.returnValue;return V.filter(function(i){if(i==null){return false;}else if(typeof t==="function"){return t(i);}else if(t==="Promise"){return i instanceof Promise;}else if(t.startsWith("class:")){return a.TableUtils.isA(i,t.substring(6));}else{return D.getType(t).isValid(i);}});}
function j(r){return r in a.TableUtils.RowsUpdateReason||D.getType("sap.ui.model.ChangeReason").isValid(r);}
function l(C){return C?typeof C.isOfType==="function":false;}
function n(r){return r!=null&&r.hasOwnProperty("context")&&r.hasOwnProperty("Type")&&r.hasOwnProperty("type")&&r.type in r.Type;}
return a;},true);
sap.ui.predefine('sap/ui/table/utils/_MenuUtils',["sap/ui/Device","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/core/Popup"],function(D,M,a,P){"use strict";P.setInitialZIndex(10);
function o(c,r){var R=r.getRowBindingContext();var f=c.getFilterProperty();var F=R.getProperty(f);if(F!=null&&typeof F!=="string"){F=F.toString();}if(this.getEnableCustomFilter()){this.fireCustomFilter({column:c,value:F});}else{this.filter(c,F);}}
var b={TableUtils:null,openContextMenu:function(t,e,E){if(!t||!e){return false;}var c=b.TableUtils.getCell(t,e);var C=c?c[0]:null;var d=b.TableUtils.getCellInfo(C);var i=d.columnIndex;var r=d.rowIndex;var f=true;if(d.isOfType(b.TableUtils.CELLTYPE.COLUMNHEADER)){var g=C.querySelector(".sapUiTableColDropDown")!==null;if(D.system.desktop||g){b._removeColumnHeaderCellMenu(t);var h=t.getColumns()[i];var p=h.getColumnHeaderMenu();if(p){p.openBy(h);}else{f=t.fireColumnSelect({column:h});if(f){return b._openColumnContextMenu(t,C);}else{return true;}}}else{return b._applyColumnHeaderCellMenu(t,C);}}else if(d.isOfType(b.TableUtils.CELLTYPE.ANYCONTENTCELL)){var R=b.TableUtils.getRowColCell(t,r,i,i>=0);var j=R.row;var k;var l=t.getBindingInfo("rows");if(l){k=j.getBindingContext(l.model);}if(i>=0){f=t.fireCellContextmenu({rowIndex:j.getIndex(),columnIndex:i,columnId:R.column.getId(),cellControl:R.cell,rowBindingContext:k,cellDomRef:C});}if(f){var m=t.getContextMenu();if(m&&l){m.setBindingContext(k,l.model);}f=t.fireBeforeOpenContextMenu({rowIndex:j.getIndex(),columnIndex:R.column?i:null,contextMenu:m});}if(f){return b._openContentCellContextMenu(t,C,E);}else{return true;}}return false;},_openColumnContextMenu:function(t,c){var C=b.TableUtils.getCellInfo(c);var d=t.getColumns();var e=d[C.columnIndex];for(var i=0;i<d.length;i++){if(d[i]!==e){b._closeColumnContextMenu(t,i);}}b._closeContentCellContextMenu(t);var s=c.getAttribute("colspan");if(s&&s!=="1"){return false;}return e._openMenu(c);},_closeColumnContextMenu:function(t,c){t.getColumns()[c]._closeMenu();},_openContentCellContextMenu:function(t,c,e){var C=b.TableUtils.getCellInfo(c);if(C.rowIndex>=b.TableUtils.getNonEmptyRowCount(t)){return false;}if(b.hasCustomContextMenu(t)){return b._openCustomContentCellContextMenu(t,c,e);}else{return b._openDefaultContentCellContextMenu(t,c,e);}},_openCustomContentCellContextMenu:function(t,c,e){var C=b.TableUtils.getCellInfo(c);var r=t.getRows()[C.rowIndex];if(r.isGroupHeader()||r.isSummary()){return false;}var d=t.getContextMenu();var f=t.getColumns();for(var i=0;i<f.length;i++){b._closeColumnContextMenu(t,i);}b._closeDefaultContentCellContextMenu(t);if(e){d.openAsContextMenu(e,c);}else if(typeof d.openBy==="function"){d.openBy(c);}else{d.open(null,c,P.Dock.BeginTop,P.Dock.BeginBottom,c);}return true;},_openDefaultContentCellContextMenu:function(t,c,e){var C=b.TableUtils.getCellInfo(c);var r=C.rowIndex;var R=t.getRows()[r];var d=C.columnIndex;var f=t.getColumns();var g=f[d];if(!t._oCellContextMenu){t._oCellContextMenu=new M(t.getId()+"-cellcontextmenu");}var s=t._oCellContextMenu.getId()+"-cellfilter";var h=sap.ui.getCore().byId(s);if(t.getEnableCellFilter()&&g&&g.isFilterableByMenu()&&!R.isGroupHeader()){if(!h){h=new a({id:s,text:b.TableUtils.getResourceText("TBL_FILTER")});h._onSelect=o.bind(t,g,R);h.attachSelect(h._onSelect);}else{h.detachSelect(h._onSelect);h._onSelect=o.bind(t,g,R);h.attachSelect(h._onSelect);}t._oCellContextMenu.insertItem(h,0);}else{t._oCellContextMenu.removeItem(h);}b.TableUtils.Hook.call(t,b.TableUtils.Hook.Keys.Table.OpenMenu,C,t._oCellContextMenu);if(t._oCellContextMenu.getItems().length===0){return false;}for(var i=0;i<f.length;i++){b._closeColumnContextMenu(t,i);}b._closeCustomContentCellContextMenu(t);if(e){t._oCellContextMenu.openAsContextMenu(e,c);}else{t._oCellContextMenu.open(null,c,P.Dock.BeginTop,P.Dock.BeginBottom,c);}return true;},_closeContentCellContextMenu:function(t){b._closeCustomContentCellContextMenu(t);b._closeDefaultContentCellContextMenu(t);},_closeCustomContentCellContextMenu:function(t){var c=t.getContextMenu();var C=c?c.bOpen:false;if(C){c.close();}},_closeDefaultContentCellContextMenu:function(t){var d=t._oCellContextMenu;var c=d?d.bOpen:false;if(c){d.close();}},cleanupDefaultContentCellContextMenu:function(t){if(!t||!t._oCellContextMenu){return;}var c=t._oCellContextMenu.getId()+"-cellfilter";var C=sap.ui.getCore().byId(c);t._oCellContextMenu.removeAllItems();t._oCellContextMenu.destroy();t._oCellContextMenu=null;if(C){C.destroy();}},_applyColumnHeaderCellMenu:function(t,c){var C=b.TableUtils.getCellInfo(c);var d=t.getColumns()[C.columnIndex];var s=c.getAttribute("colspan");var e=c.querySelector(".sapUiTableCellInner");var f=c.querySelector(".sapUiTableCellTouchMenu")!==null;if(s&&s!=="1"||f||(!d.getResizable()&&!d._menuHasItems())){return false;}var g=document.createElement("div");b._removeColumnHeaderCellMenu(t);e.style.display="none";if(d._menuHasItems()){var h;h=document.createElement("div");h.classList.add("sapUiTableColDropDown");h.textContent="";g.appendChild(h);}if(d.getResizable()){var i;i=document.createElement("div");i.classList.add("sapUiTableColResizer");i.textContent="";g.appendChild(i);}g.classList.add("sapUiTableCellTouchMenu");c.appendChild(g);var j=function(){b._removeColumnHeaderCellMenu(t);c.removeEventListener("focusout",j);};c.addEventListener("focusout",j);return true;},_removeColumnHeaderCellMenu:function(t){var c=t&&t.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(c.length){c.parent().find(".sapUiTableCellInner").show();c.remove();}},hasCustomContextMenu:function(t){return t!=null&&t.getContextMenu()!=null;}};return b;},true);
sap.ui.require.preload({
	"sap/ui/table/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.table","type":"library","embeds":[],"applicationVersion":{"version":"1.98.0"},"title":"Table-like controls, mainly for desktop scenarios.","description":"Table-like controls, mainly for desktop scenarios.","ach":"CA-UI5-TBL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.98","libs":{"sap.ui.core":{"minVersion":"1.98.0"},"sap.ui.unified":{"minVersion":"1.98.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.CreationRow","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],"elements":["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings","sap.ui.table.rowmodes.RowMode","sap.ui.table.rowmodes.FixedRowMode","sap.ui.table.rowmodes.InteractiveRowMode","sap.ui.table.rowmodes.AutoRowMode","sap.ui.table.plugins.MultiSelectionPlugin","sap.ui.table.plugins.SelectionPlugin"],"types":["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.TreeAutoExpandMode"],"interfaces":[]}}}}'
},"sap/ui/table/library-preload"
);
//# sourceMappingURL=library-preload.js.map