//@ui5-bundle sap/ui/table/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/table/AnalyticalColumn',['./Column','./library','sap/ui/core/Element','sap/ui/model/type/Boolean','sap/ui/model/type/DateTime','sap/ui/model/type/Float','sap/ui/model/type/Integer','sap/ui/model/type/Time','./utils/TableUtils','./AnalyticalColumnMenu'],function(C,l,E,B,D,F,I,T,a,A){"use strict";
function i(c){return a.isA(c,"sap.ui.table.AnalyticalTable");}
var b=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});
b._DEFAULT_FILTERTYPES={"Time":new T({UTC:true}),"DateTime":new D({UTC:true}),"Float":new F(),"Integer":new I(),"Boolean":new B()};
b.prototype._createMenu=function(){return new A(this.getId()+"-menu");};
b.prototype.setGrouped=function(g,s){var p=this.getParent();if(i(p)){if(g){p._addGroupedColumn(this.getId());}else{p._removeGroupedColumn(this.getId());}}var r=this.setProperty("grouped",g,s);this._updateColumns();return r;};
b.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};
b.prototype.setVisible=function(v){C.prototype.setVisible.call(this,v);this._updateColumns();return this;};
b.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){this._oBindingLabel=l.TableHelper.createLabel();this.addDependent(this._oBindingLabel);a.Binding.metadataLoaded(p).then(function(){this._oBindingLabel.setText(o.getPropertyLabel(this.getLeadingProperty()));}.bind(this));}}}L=this._oBindingLabel;}return L;};
b.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding("rows");var L=this.getLeadingProperty();if(o&&o.getFilterablePropertyNames().indexOf(L)>-1){p=L;}}}return p;};
b.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding("rows");var L=this.getLeadingProperty();if(o&&o.getSortablePropertyNames().indexOf(L)>-1){p=L;}}}return p;};
b.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");var L=this.getLeadingProperty(),P=o&&o.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=b._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=b._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=b._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=b._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=b._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};
b.prototype._updateColumns=function(s,f){var p=this.getParent();if(i(p)){p._updateColumns(s,f);}};
b.prototype._updateTableAnalyticalInfo=function(s){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p.updateAnalyticalInfo(s);}};
b.prototype._updateTableColumnDetails=function(){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p._updateTableColumnDetails();}};
b.prototype.shouldRender=function(){if(!this.getVisible()||!this.getTemplate()){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};
b.prototype.getTooltip_AsString=function(){if(!this.getTooltip()){return this._getDefaultTooltip();}return E.prototype.getTooltip_AsString.apply(this);};
b.prototype.getTooltip_Text=function(){var t=E.prototype.getTooltip_Text.apply(this);if(!this.getTooltip()||!t){t=this._getDefaultTooltip();}return t;};
b.prototype._getDefaultTooltip=function(){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o&&this.getLeadingProperty()){return o.getPropertyQuickInfo(this.getLeadingProperty());}}return null;};
b.prototype._menuHasItems=function(){var m=function(){var t=this.getParent();var o=t.getBinding("rows");var r=o&&o.getAnalyticalQueryResult();return(t&&r&&r.findMeasureByPropertyName(this.getLeadingProperty()));}.bind(this);return C.prototype._menuHasItems.apply(this)||m();};
b.prototype.isFilterableByMenu=function(){var f=this.getFilterProperty();if(!f||!this.getShowFilterMenuEntry()){return false;}var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){if(o.getFilterablePropertyNames().indexOf(f)>-1&&o.getProperty(f)){return true;}}}return false;};
b.prototype.isGroupable=function(){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){var r=o.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&o.getSortablePropertyNames().indexOf(this.getLeadingProperty())>-1&&o.getFilterablePropertyNames().indexOf(this.getLeadingProperty())>-1){return true;}}}return false;};
b.ofCell=C.ofCell;return b;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenu',['./ColumnMenu',"sap/ui/unified/MenuRenderer",'./library',"sap/ui/thirdparty/jquery"],function(C,M,l,q){"use strict";var G=l.GroupEventType;
var A=C.extend("sap.ui.table.AnalyticalColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.unified.MenuRenderer"
});
A.prototype._addMenuItems=function(){C.prototype._addMenuItems.apply(this);if(this._oColumn){this._addSumMenuItem();}};
A.prototype._addGroupMenuItem=function(){var c=this._oColumn,t=this._oTable;if(c.isGroupable()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",c.getGrouped()?"accept":null,function(e){var m=e.getSource();var g=c.getGrouped();var s=g?G.group:G.ungroup;c.setGrouped(!g);t.fireGroup({column:c,groupedColumns:t._aGroupedColumns,type:s});m.setIcon(!g?"sap-icon://accept":null);});this.addItem(this._oGroupIcon);}};
A.prototype._addSumMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding("rows"),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findMeasureByPropertyName(c.getLeadingProperty())){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",c.getSummed()?"accept":null,q.proxy(function(e){var m=e.getSource(),s=c.getSummed();c.setSummed(!s);m.setIcon(!s?"sap-icon://accept":null);},this));this.addItem(this._oSumItem);}};
A.prototype.open=function(){C.prototype.open.apply(this,arguments);var c=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(c.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(c.getGrouped()?"sap-icon://accept":null);};
return A;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenuRenderer',['sap/ui/table/AnalyticalColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/AnalyticalTable',['./AnalyticalColumn','./Table','./TreeTable',"./TableRenderer",'./library','sap/ui/model/analytics/ODataModelAdapter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/unified/Menu','sap/ui/unified/MenuItem','./utils/TableUtils',"./plugins/BindingSelection","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery","sap/base/util/UriParameters"],function(A,T,a,b,c,O,S,d,M,e,f,B,L,g,q,U){"use strict";var G=c.GroupEventType,h=c.SortOrder,k=c.TreeAutoExpandMode;
var m=T.extend("sap.ui.table.AnalyticalTable",{
metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},designtime:"sap/ui/table/designtime/AnalyticalTable.designtime"},
renderer:"sap.ui.table.TableRenderer"
});
m.prototype._getFixedBottomRowContexts=function(){var o=this.getBinding("rows");if(o){return[o.getGrandTotalNode()];}};
m.prototype._getContexts=a.prototype._getContexts;m.prototype._getRowContexts=a.prototype._getRowContexts;
m.prototype.init=function(){T.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;this._mGroupHeaderMenuItems=null;f.Grouping.setGroupMode(this);f.Hook.register(this,f.Hook.Keys.Row.UpdateState,this._updateRowState,this);f.Hook.register(this,f.Hook.Keys.Table.OpenMenu,this._onOpenTableContextMenu,this);};
m.prototype.exit=function(){T.prototype.exit.apply(this,arguments);this._cleanupGroupHeaderMenuItems();};
m.prototype._adaptLocalization=function(r,l){return T.prototype._adaptLocalization.apply(this,arguments).then(function(){if(l){this._cleanupGroupHeaderMenuItems();}}.bind(this));};
m.prototype.setFixedRowCount=function(){L.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this;};
m.prototype.setFixedBottomRowCount=function(){L.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this;};
m.prototype.setDirty=function(D){L.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",D,true);this.setShowOverlay(this.getDirty());return this;};
m.prototype.setEnableGrouping=function(){L.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this;};
m.prototype.setGroupBy=function(){L.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this;};
m.prototype.getModel=function(n){var o=T.prototype.getModel.apply(this,arguments);var r=this.getBindingInfo("rows");if(o&&r&&r.model==n){O.apply(o);}return o;};
m.prototype._onBindingChange=function(E){T.prototype._onBindingChange.apply(this,arguments);var r=typeof(E)==="object"?E.getParameter("reason"):E;if(r!=="sort"){this._invalidateColumnMenus();}};
m.prototype._bindRows=function(o){this._applyAnalyticalBindingInfo(o);T.prototype._bindRows.call(this,o);};
m.prototype._bindAggregation=function(n,o){if(n==="rows"){this._invalidateColumnMenus();this._applyODataModelAnalyticalAdapter(o.model);this.setProperty("firstVisibleRow",0,true);}T.prototype._bindAggregation.call(this,n,o);if(n==="rows"){this._updateTotalRow(true);f.Binding.metadataLoaded(this).then(function(){this._updateColumns(true);}.bind(this));}};
m.prototype._applyAnalyticalBindingInfo=function(o){var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getSorted()){o.sorter=o.sorter||[];o.sorter.push(new d(C[i].getSortProperty()||C[i].getLeadingProperty(),C[i].getSortOrder()===h.Descending));}}o.parameters=o.parameters||{};o.parameters.analyticalInfo=this._getColumnInformation();if(!o.parameters.hasOwnProperty("sumOnTop")){o.parameters.sumOnTop=this.getSumOnTop();}if(!o.parameters.hasOwnProperty("numberOfExpandedLevels")){o.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();}if(o.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){o.parameters.numberOfExpandedLevels=0;}if(!o.parameters.hasOwnProperty("autoExpandMode")){var E=this.getAutoExpandMode();if(E!=k.Bundled&&E!=k.Sequential){E=k.Bundled;}o.parameters.autoExpandMode=E;}};
m.prototype._applyODataModelAnalyticalAdapter=function(o){if(o){O.apply(o);}};
m.prototype._getColumnInformation=function(){var C=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(this._aGroupedColumns.indexOf(o.getId())>-1){continue;}if(!o instanceof A){L.error("You have to use AnalyticalColumns for the Analytical table");}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return C;};
m.prototype._updateRowState=function(s){var o=this.getBinding("rows");var i=this.getBindingInfo("rows");var n=s.context;s.context=n.context;if(!s.context){return;}if(o.nodeHasChildren(n)){s.type=s.Type.GroupHeader;s.expandable=true;}else if(n.nodeState.sum){s.type=s.Type.Summary;}s.level=n.level;s.expanded=n.nodeState.expanded;s.contentHidden=s.expanded&&!i.parameters.sumOnTop;s.title=s.type===s.Type.GroupHeader?o.getGroupName(n.context,n.level):"";};
m.prototype.onRowsUpdated=function(p){T.prototype.onRowsUpdated.apply(this,arguments);var r=this.getRows();var o=this.getBinding("rows");var F=this._getVisibleColumns()[0];for(var R=0;R<r.length;R++){var i=r[R];var l=i.getLevel()-(!i.isGroupHeader()&&!i.isSummary()?1:0);var I=0;for(var j=1;j<l;j++){if(j===1){I=24;}else if(j===2){I+=12;}else{I+=8;}}f.Grouping.setGroupIndent(i,I);var C=i.getCells();var n=C.length;for(var s=0;s<n;s++){var t=A.ofCell(C[s]);var u=o?o.isMeasure(t.getLeadingProperty()):false;var $=q(C[s].$().closest("td"));var H=false;if(i.isSummary()&&u){H=!t.getSummed();}else if(i.isGroupHeader()&&t===F){H=!u;}$.toggleClass("sapUiTableCellHidden",H);}}};
m.prototype._onOpenTableContextMenu=function(C,o){var r=C.isOfType(f.CELLTYPE.ANYCONTENTCELL)?this.getRows()[C.rowIndex]:null;if(!r||!r.isGroupHeader()){this._removeGroupHeaderMenuItems(o);return;}this._iGroupedLevel=r.getLevel();this._addGroupHeaderMenuItems(o);};
m.prototype._addGroupHeaderMenuItems=function(o){var t=this;function j(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var n=t.getColumns().filter(function(C){return t._aGroupedColumns[i]===C.getId();})[0];return{column:n,index:i};}else{return undefined;}}if(!this._mGroupHeaderMenuItems){this._mGroupHeaderMenuItems={};}if(!this._mGroupHeaderMenuItems["visibility"]){this._mGroupHeaderMenuItems["visibility"]=new e({text:f.getResourceText("TBL_SHOW_COLUMN"),select:function(){var l=j();if(l){var C=l.column,s=C.getShowIfGrouped();C.setShowIfGrouped(!s);t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:(!s?G.showGroupedColumn:G.hideGroupedColumn)});}}});}o.addItem(this._mGroupHeaderMenuItems["visibility"]);if(!this._mGroupHeaderMenuItems["ungroup"]){this._mGroupHeaderMenuItems["ungroup"]=new e({text:f.getResourceText("TBL_UNGROUP"),select:function(){var l=j();if(l&&l.column){var u=l.column;u.setGrouped(false);t.fireGroup({column:u,groupedColumns:t._aGroupedColumns,type:G.ungroup});}}});}o.addItem(this._mGroupHeaderMenuItems["ungroup"]);if(!this._mGroupHeaderMenuItems["ungroupall"]){this._mGroupHeaderMenuItems["ungroupall"]=new e({text:f.getResourceText("TBL_UNGROUP_ALL"),select:function(){var n=t.getColumns();t.suspendUpdateAnalyticalInfo();for(var i=0;i<n.length;i++){n[i].setGrouped(false);}t.resumeUpdateAnalyticalInfo();t.fireGroup({column:undefined,groupedColumns:[],type:G.ungroupAll});}});}o.addItem(this._mGroupHeaderMenuItems["ungroupall"]);if(!this._mGroupHeaderMenuItems["moveup"]){this._mGroupHeaderMenuItems["moveup"]=new e({text:f.getResourceText("TBL_MOVE_UP"),select:function(){var l=j();if(l){var C=l.column;var i=t._aGroupedColumns.indexOf(C.getId());if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveUp});}}},icon:"sap-icon://arrow-top"});}o.addItem(this._mGroupHeaderMenuItems["moveup"]);if(!this._mGroupHeaderMenuItems["movedown"]){this._mGroupHeaderMenuItems["movedown"]=new e({text:f.getResourceText("TBL_MOVE_DOWN"),select:function(){var l=j();if(l){var C=l.column;var i=t._aGroupedColumns.indexOf(C.getId());if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveDown});}}},icon:"sap-icon://arrow-bottom"});}o.addItem(this._mGroupHeaderMenuItems["movedown"]);if(!this._mGroupHeaderMenuItems["sortasc"]){this._mGroupHeaderMenuItems["sortasc"]=new e({text:f.getResourceText("TBL_SORT_ASC"),select:function(){var l=j();if(l){var C=l.column;C.sort(false);}},icon:"sap-icon://up"});}o.addItem(this._mGroupHeaderMenuItems["sortasc"]);if(!this._mGroupHeaderMenuItems["sortdesc"]){this._mGroupHeaderMenuItems["sortdesc"]=new e({text:f.getResourceText("TBL_SORT_DESC"),select:function(){var l=j();if(l){var C=l.column;C.sort(true);}},icon:"sap-icon://down"});}o.addItem(this._mGroupHeaderMenuItems["sortdesc"]);if(!this._mGroupHeaderMenuItems["collapse"]){this._mGroupHeaderMenuItems["collapse"]=new e({text:f.getResourceText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding("rows").collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection();}});}o.addItem(this._mGroupHeaderMenuItems["collapse"]);if(!this._mGroupHeaderMenuItems["collapseall"]){this._mGroupHeaderMenuItems["collapseall"]=new e({text:f.getResourceText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding("rows").collapseToLevel(0);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection();}});}o.addItem(this._mGroupHeaderMenuItems["collapseall"]);if(!this._mGroupHeaderMenuItems["expand"]){this._mGroupHeaderMenuItems["expand"]=new e({text:f.getResourceText("TBL_EXPAND_LEVEL"),select:function(){t.getBinding("rows").expandToLevel(t._iGroupedLevel);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection();}});}o.addItem(this._mGroupHeaderMenuItems["expand"]);if(!this._mGroupHeaderMenuItems["expandall"]){this._mGroupHeaderMenuItems["expandall"]=new e({text:f.getResourceText("TBL_EXPAND_ALL"),select:function(){t.expandAll();}});}o.addItem(this._mGroupHeaderMenuItems["expandall"]);var l=j();if(l){var C=l.column;if(C.getShowIfGrouped()){this._mGroupHeaderMenuItems["visibility"].setText(f.getResourceText("TBL_HIDE_COLUMN"));}else{this._mGroupHeaderMenuItems["visibility"].setText(f.getResourceText("TBL_SHOW_COLUMN"));}this._mGroupHeaderMenuItems["moveup"].setEnabled(l.index>0);this._mGroupHeaderMenuItems["movedown"].setEnabled(l.index<this._aGroupedColumns.length-1);}else{this._mGroupHeaderMenuItems["moveup"].setEnabled(true);this._mGroupHeaderMenuItems["movedown"].setEnabled(true);}};
m.prototype._removeGroupHeaderMenuItems=function(o){if(!this._mGroupHeaderMenuItems){return;}for(var i in this._mGroupHeaderMenuItems){o.removeItem(this._mGroupHeaderMenuItems[i]);}};
m.prototype._cleanupGroupHeaderMenuItems=function(){for(var i in this._mGroupHeaderMenuItems){this._mGroupHeaderMenuItems[i].destroy();}this._mGroupHeaderMenuItems=null;};
m.prototype.getContextByIndex=function(i){var o=this.getBinding("rows");return i>=0&&o?o.getContextByIndex(i):null;};
m.prototype.getContextInfoByIndex=function(i){var o=this.getBinding("rows");return i>=0&&o?o.getNodeByIndex(i):null;};
m.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true;};
m.prototype.resumeUpdateAnalyticalInfo=function(s,F){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(s,F);};
m.prototype.addColumn=function(C,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.addColumn.call(this,o,s);this._updateColumns(s);return this;};
m.prototype.insertColumn=function(C,i,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.insertColumn.call(this,o,i,s);this._updateColumns(s);return this;};
m.prototype.removeColumn=function(C,s){var r=T.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(v){if(C.getId){return v!=C.getId();}else{return v==C;}});}this.updateAnalyticalInfo(s);return r;};
m.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];var r=T.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(s);return r;};
m.prototype._getColumn=function(C){if(typeof C==="string"){var o=new A({leadingProperty:C,template:C,managed:true});return o;}else if(C instanceof A){return C;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};
m.prototype._updateColumns=function(s,F){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(s,F);if(this.bOutput){this.invalidate();}}};
m.prototype.updateAnalyticalInfo=function(s,F){if(this._bSuspendUpdateAnalyticalInfo){return;}var o=this.getBinding("rows");if(o){var C=this._getColumnInformation();var n=o.getNumberOfExpandedLevels()||0;if(n>this._aGroupedColumns.length){o.setNumberOfExpandedLevels(0);}o.updateAnalyticalInfo(C,F);this._updateTotalRow(s);if(!s){this._getRowContexts();}}};
m.prototype.refreshRows=function(){T.prototype.refreshRows.apply(this,arguments);this._updateTotalRow();};
m.prototype._updateTotalRow=function(s){var o=this.getBinding("rows");var n=0;var r=this.getRowMode();if(o&&(o.providesGrandTotal()&&o.hasTotaledMeasures())){n=1;}if(r){r.setProperty("fixedBottomRowCount",n,s);}else{this.setProperty("fixedBottomRowCount",n,s);}};
m.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return;}var l=this.getBinding("rows"),r=l&&l.getAnalyticalQueryResult();if(r){var C=this.getColumns(),n=[],u=[],D=[],p={},t,v;for(var i=0;i<C.length;i++){t=C[i];t._isLastGroupableLeft=false;t._bLastGroupAndGrouped=false;t._bDependendGrouped=false;if(!t.getVisible()){continue;}var w=t.getLeadingProperty();v=r.findDimensionByPropertyName(w);if(v){var x=v.getName();if(!p[x]){p[x]={dimension:v,columns:[t]};}else{p[x].columns.push(t);}if(t.getGrouped()&&n.indexOf(x)==-1){n.push(x);}if(D.indexOf(x)==-1){D.push(x);}}}u=q.grep(D,function(s){return n.indexOf(n,s)==-1;});if(n.length>0){q.each(n,function(i,s){q.each(p[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(n.length==D.length){v=r.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var y=p[v.getName()].columns;q.each(y,function(i,o){o._bLastGroupAndGrouped=true;});}}if(u.length==1){q.each(p[u[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};
m.prototype._getFirstMeasureColumnIndex=function(){var o=this.getBinding("rows"),r=o&&o.getAnalyticalQueryResult(),C=this._getVisibleColumns();if(!r){return-1;}for(var i=0;i<C.length;i++){var j=C[i],l=j.getLeadingProperty();if(r.findMeasureByName(l)||r.findMeasureByPropertyName(l)){return i;}}};
m.prototype.getTotalSize=function(){var o=this.getBinding("rows");if(o){return o.getTotalSize();}return 0;};
m.prototype._onPersoApplied=function(){T.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getGrouped()){this._addGroupedColumn(C[i].getId());}}this._updateColumns();};
m.prototype._addGroupedColumn=function(C){if(this._aGroupedColumns.indexOf(C)===-1){this._aGroupedColumns.push(C);}};
m.prototype._removeGroupedColumn=function(C){var i=this._aGroupedColumns.indexOf(C);if(i>=0){this._aGroupedColumns.splice(i,1);}};
m.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};
m.prototype.setCollapseRecursive=function(C){var o=this.getBinding("rows");if(o){g(o.setCollapseRecursive,"Collapse Recursive is not supported by the used binding");if(o.setCollapseRecursive){o.setCollapseRecursive(C);}}this.setProperty("collapseRecursive",!!C,true);return this;};
m.prototype.expand=a.prototype.expand;m.prototype.collapse=a.prototype.collapse;
m.prototype.expandAll=function(){var o=this.getBinding("rows");if(o){o.expandToLevel(this._aGroupedColumns.length);this.setFirstVisibleRow(0);this._getSelectionPlugin().clearSelection();}return this;};
m.prototype.collapseAll=a.prototype.collapseAll;m.prototype.isExpanded=a.prototype.isExpanded;
m.prototype.getAnalyticalInfoOfRow=function(r){var o=this.getBinding("rows");var C=r?r.getRowBindingContext():null;if(!f.isA(r,"sap.ui.table.Row")||r.getParent()!==this||!o||!C){return null;}var I=C===o.getGrandTotalContext();var j=null;var l=-1;if(I){j=o.getGrandTotalContextInfo();l=0;}else{j=this.getContextInfoByIndex(r.getIndex());if(j){l=j.level;}}var n=j&&o.nodeHasChildren&&o.nodeHasChildren(j);var p=!n&&!I&&j&&j.nodeState&&j.nodeState.sum;var s=[];if(p||n){var t=this.getGroupedColumns();if(t.length>0&&l>0&&l<=t.length){for(var i=0;i<l;i++){s.push(t[i]);}}}return{grandTotal:I,group:n,groupTotal:p,level:l,context:C,groupedColumns:s};};
m.prototype.setRowMode=function(r){T.prototype.setRowMode.apply(this,arguments);this._getRowMode().disableFixedRows();};
m.prototype._initLegacyRowMode=function(r){T.prototype._initLegacyRowMode.apply(this,arguments);this._getRowMode().disableFixedRows();};
m.prototype._createLegacySelectionPlugin=function(){return new B();};
return m;});
sap.ui.predefine('sap/ui/table/AnalyticalTableRenderer',['sap/ui/table/AnalyticalTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/Column',['sap/ui/core/Element','sap/ui/core/library','sap/ui/core/Popup','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/Type','sap/ui/model/type/String','./utils/TableUtils','./library','./ColumnMenu','sap/base/util/ObjectPath',"sap/base/util/JSTokenizer","sap/base/Log","sap/ui/thirdparty/jquery"],function(E,c,P,F,a,b,S,T,d,f,g,C,O,J,L,q){"use strict";var H=c.HorizontalAlign,h=g.SortOrder,V=c.ValueState;var j={Standard:"Standard",Creation:"Creation"};var k=new window.WeakMap();
var m=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:H.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:h.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},menu:{type:"sap.ui.unified.Menu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});
m._DEFAULT_FILTER_TYPE=new d();
m.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};this._oSorter=null;this._initTemplateClonePool();};
m.prototype._initTemplateClonePool=function(){this._mTemplateClones=Object.keys(j).reduce(function(t,s){t[s]=[];return t;},{});};
m.prototype.exit=function(){this._destroyTemplateClones();};
m.prototype.setParent=function(p,A,s){var r=E.prototype.setParent.apply(this,arguments);var M=this.getAggregation("menu");if(M&&typeof M._updateReferences==="function"){M._updateReferences(this);}return r;};
m.prototype.invalidate=function(o){if(o!==this.getTemplate()&&o!==this.getCreationTemplate()&&!f.isA(o,"sap.ui.table.ColumnMenu")){E.prototype.invalidate.apply(this,arguments);}};
m.prototype.setLabel=function(l){var o=l;if(typeof(l)==="string"){o=g.TableHelper.createLabel({text:l});}this.setAggregation("label",o);return this;};
m.prototype.setTemplate=function(t){var o=t;var e=this._getTable();var i=this.getTemplate();if(typeof t==="string"){o=g.TableHelper.createTextView().bindProperty("text",t);}this.setAggregation("template",o,true);if(this.getVisible()){this.invalidate();}this._destroyTemplateClones("Standard");if(e&&this.getVisible()){if(o){e.invalidateRowsAggregation();}if(!i||!o){var l=e.getCreationRow();if(l){l._update();}}}return this;};
m.prototype.destroyTemplate=function(){this.destroyAggregation("template");this._destroyTemplateClones("Standard");var t=this._getTable();var o=t?t.getCreationRow():null;if(o){o._update();}return this;};
m.prototype.setCreationTemplate=function(o){var t=this._getTable();this.setAggregation("creationTemplate",o,true);this._destroyTemplateClones("Creation");if(o&&t&&this.getVisible()){var e=t.getCreationRow();if(e){e._update();}}return this;};
m.prototype.getCreationTemplate=function(){return this.getAggregation("creationTemplate");};
m.prototype.destroyCreationTemplate=function(){this.destroyAggregation("creationTemplate",true);this._destroyTemplateClones("Creation");return this;};
m.prototype.getMenu=function(){var M=this.getAggregation("menu");if(!M){M=this._createMenu();this.setMenu(M);}return M;};
m.prototype.invalidateMenu=function(){var M=this.getAggregation("menu");if(this._bMenuIsColumnMenu){M._invalidate();}};
m.prototype._menuHasItems=function(){var M=this.getAggregation("menu");var t=this._getTable();var e=(M?M.getItems().length>0:false)||(t?t.getEnableColumnFreeze():false)||(t?t.getShowColumnVisibilityMenu():false)||this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupable();if(e){return true;}return f.Hook.call(t,f.Hook.Keys.Column.MenuItemNotification,this).some(function(v){return v;});};
m.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry());};
m.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry());};
m.prototype.isGroupable=function(){var t=this.getParent();return!!(t&&t.getEnableGrouping&&t.getEnableGrouping()&&this.getSortProperty());};
m.prototype.setMenu=function(M){this.setAggregation("menu",M,true);this._bMenuIsColumnMenu=f.isA(M,"sap.ui.table.ColumnMenu");return this;};
m.prototype._createMenu=function(){if(!this._defaultMenu){this._defaultMenu=new C(this.getId()+"-menu",{ariaLabelledBy:this});}return this._defaultMenu;};
m.prototype.setSortProperty=function(v){this.setProperty("sortProperty",v);this.invalidateMenu();return this;};
m.prototype.setSorted=function(e){this.setProperty("sorted",e,true);this._updateIcons();return this;};
m.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._updateIcons();return this;};
m.prototype.setFilterProperty=function(v){this.invalidateMenu();return this.setProperty("filterProperty",v);};
m.prototype.setFiltered=function(e){this.setProperty("filtered",e,true);this._updateIcons();return this;};
m.prototype.setFilterValue=function(v){this.setProperty("filterValue",v,true);var M=this.getMenu();if(this._bMenuIsColumnMenu){M._setFilterValue(v);}return this;};
m.prototype.setFilterOperator=function(v){return this.setProperty("filterOperator",v,true);};
m.prototype._openMenu=function(D){var M=this.getMenu();if(!this._menuHasItems()){return false;}var e=this.fireColumnMenuOpen({menu:M});if(e){var i=P.Dock;var o=D;if(!D){D=this.getDomRef();o=this.getFocusDomRef();}M.open(null,o,i.BeginTop,i.BeginBottom,D);return true;}else{return true;}};
m.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===h.Ascending);};
m.prototype.sort=function(D,A){var t=this.getParent();if(t){t.pushSortedColumn(this,A);var N=D?h.Descending:h.Ascending;var e=t.fireSort({column:this,sortOrder:N,columnAdded:A});if(e){var s=t.getSortedColumns();var o=t.getColumns();for(var i=0,l=o.length;i<l;i++){if(s.indexOf(o[i])<0){o[i].setProperty("sorted",false,true);o[i].setProperty("sortOrder",h.Ascending,true);o[i]._updateIcons(true);delete o[i]._oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",N,true);this._oSorter=new S(this.getSortProperty(),this.getSortOrder()===h.Descending);var p=[];for(var i=0,l=s.length;i<l;i++){s[i]._updateIcons(true);p.push(s[i]._oSorter);}t._resetColumnHeaderHeights();t._updateRowHeights(t._collectRowHeights(true),true);var B=t.getBinding("rows");if(B){if(this._updateTableAnalyticalInfo){this._updateTableAnalyticalInfo(true);}B.sort(p);}else{L.warning("Sorting not performed because no binding present",this);}}}return this;};
m.prototype._updateIcons=function(s){var t=this.getParent(),e=this.getSorted(),i=this.getFiltered();if(!t||!t.getDomRef()){return;}this.$().parents(".sapUiTableCHT").find('td[data-sap-ui-colindex="'+this.getIndex()+'"]:not([colspan]):not(.sapUiTableHidden):first').toggleClass("sapUiTableColFiltered",i).toggleClass("sapUiTableColSorted",e).toggleClass("sapUiTableColSortedD",e&&this.getSortOrder()===h.Descending);t._getAccExtension().updateAriaStateOfColumn(this);if(!s){t._resetColumnHeaderHeights();t._updateRowHeights(t._collectRowHeights(true),true);}};
m.prototype._renderSortIcon=function(){this._updateIcons();};
m.prototype._getFilter=function(){var o,p=this.getFilterProperty(),v=this.getFilterValue(),s=this.getFilterOperator(),e,i,t=this.getFilterType()||m._DEFAULT_FILTER_TYPE,I=t instanceof d,B;if(v){if(!s){B=v.match(/(.*)\s*\.\.\s*(.*)/);if(v.indexOf("=")==0){s=a.EQ;e=v.substr(1);}else if(v.indexOf("!=")==0){s=a.NE;e=v.substr(2);}else if(v.indexOf("<=")==0){s=a.LE;e=v.substr(2);}else if(v.indexOf("<")==0){s=a.LT;e=v.substr(1);}else if(v.indexOf(">=")==0){s=a.GE;e=v.substr(2);}else if(v.indexOf(">")==0){s=a.GT;e=v.substr(1);}else if(B){if(B[1]&&B[2]){s=a.BT;e=B[1];i=B[2];}else if(B[1]&&!B[2]){s=a.GE;e=B[1];}else{s=a.LE;e=B[2];}}else if(I&&v.indexOf("*")==0&&v.lastIndexOf("*")==v.length-1){s=a.Contains;e=v.substr(1,v.length-2);}else if(I&&v.indexOf("*")==0){s=a.EndsWith;e=v.substr(1);}else if(I&&v.lastIndexOf("*")==v.length-1){s=a.StartsWith;e=v.substr(0,v.length-1);}else{if(this.getDefaultFilterOperator()){s=this.getDefaultFilterOperator();}else{if(I){s=a.Contains;}else{s=a.EQ;}}e=v.substr(0);}if(!i){o=new F(p,s,this._parseFilterValue(e));}else{o=new F(p,s,this._parseFilterValue(e),this._parseFilterValue(i));}}else{o=new F(p,s,this._parseFilterValue(v));}}return o;};
m.prototype.filter=function(v){var t=this.getParent();if(t&&t.isBound("rows")){var o=t.fireFilter({column:this,value:v});if(o){this.setProperty("filtered",!!v,true);this.setProperty("filterValue",v,true);var M=this.getMenu();if(this._bMenuIsColumnMenu){M._setFilterValue(v);}var p=[];var r=t.getColumns();for(var i=0,l=r.length;i<l;i++){var s=r[i],u;M=s.getMenu();try{u=s._getFilter();if(s._bMenuIsColumnMenu){M._setFilterState(V.None);}}catch(e){if(s._bMenuIsColumnMenu){M._setFilterState(V.Error);}continue;}if(u){p.push(u);}}t.getBinding("rows").filter(p,b.Control);this._updateIcons();}}return this;};
m.prototype._parseFilterValue=function(v){var o=this.getFilterType();if(o){if(q.isFunction(o)){v=o(v);}else{v=o.parseValue(v,"string");}}return v;};
m.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()&&this.getTemplate()!=null;};
m.prototype.setProperty=function(N,v){var t=this._getTable();var e=t&&N==="visible"&&this.getProperty(N)!=v;var r=E.prototype.setProperty.apply(this,arguments);if(e){t.invalidateRowsAggregation();var o=t.getCreationRow();if(o){o._update();}}return r;};
m.prototype.setFilterType=function(t){var o=t;if(typeof(t)==="string"){try{var e=J.parseJS(t);if(typeof(e.type)==="string"){var i=O.get(e.type);o=i&&new i(e.formatOptions,e.constraints);}}catch(l){var i=O.get(t);o=i&&new i();}if(!(o instanceof T)){L.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");o=undefined;}}this.setProperty("filterType",o,true);return this;};
m.prototype.getIndex=function(){var t=this.getParent();if(t){return t.indexOfColumn(this);}else{return-1;}};
m.prototype._getFreeTemplateClone=function(t){var e=this._mTemplateClones[t];var o=null;if(!e){return null;}for(var i=0;i<e.length;i++){if(!e[i]||e[i].bIsDestroyed){e.splice(i,1);i--;}else if(!o&&!e[i].getParent()){o=e[i];}}return o;};
m.prototype.getTemplateClone=function(i,p){if(typeof i!=="number"||this.getTemplate()==null){return null;}var t=p==null?"Standard":p;var o=this._getFreeTemplateClone(t);if(!o&&j.hasOwnProperty(t)){var G=this["get"+(t==="Standard"?"":t)+"Template"];var e=G.call(this);if(e){o=e.clone();this._mTemplateClones[t].push(o);}}if(o){k.set(o,this);var l=this.getParent();if(l){l._getAccExtension().addColumnHeaderLabel(this,o);}}return o;};
function n(e){for(var i=0;i<e.length;i++){if(e[i]!=null&&!e[i].bIsDestroyed){e[i].destroy();}}}
m.prototype._destroyTemplateClones=function(t){if(t==null){for(var s in j){n(this._mTemplateClones[s]);}this._initTemplateClonePool();}else{n(this._mTemplateClones[t]);this._mTemplateClones[t]=[];}};
m.prototype._closeMenu=function(){var M=this.getAggregation("menu");if(M){M.close();}};
m.prototype._getTable=function(){var p=this.getParent();return f.isA(p,"sap.ui.table.Table")?p:null;};
m.ofCell=function(o){return k.get(o)||null;};
return m;});
sap.ui.predefine('sap/ui/table/ColumnMenu',['./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/unified/MenuTextFieldItem',"sap/ui/unified/MenuRenderer",'sap/ui/Device','./utils/TableUtils',"sap/base/assert","sap/ui/thirdparty/jquery"],function(l,M,a,b,c,D,T,d,q){"use strict";var C=new window.WeakMap();
var e=M.extend("sap.ui.table.ColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.unified.MenuRenderer"
});
e.prototype.init=function(){if(M.prototype.init){M.prototype.init.apply(this,arguments);}this.addStyleClass("sapUiTableColumnMenu");this._bInvalidated=true;this._iPopupClosedTimeoutId=null;this._oColumn=null;this._oTable=null;this._attachPopupClosed();};
e.prototype.exit=function(){if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}window.clearTimeout(this._iPopupClosedTimeoutId);e._destroyColumnVisibilityMenuItem(this._oTable);this._oColumn=this._oTable=null;};
e.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate();}};
e.prototype.setParent=function(p){this._invalidate();this._updateReferences(p);return M.prototype.setParent.apply(this,arguments);};
e.prototype._updateReferences=function(p){this._oColumn=p;if(this._oColumn){d(T.isA(this._oColumn,"sap.ui.table.Column"),"ColumnMenu.setParent: parent must be a subclass of sap.ui.table.Column");this._oTable=this._oColumn.getParent();if(this._oTable){d(T.isA(this._oTable,"sap.ui.table.Table"),"ColumnMenu.setParent: parent of parent must be subclass of sap.ui.table.Table");}}};
e._destroyColumnVisibilityMenuItem=function(t){if(!t||!t._oColumnVisibilityMenuItem){return;}t._oColumnVisibilityMenuItem.destroy();t._oColumnVisibilityMenuItem=null;};
e.prototype._removeColumnVisibilityFromAggregation=function(){if(!this._oTable||!this._oTable._oColumnVisibilityMenuItem){return;}this.removeAggregation("items",this._oTable._oColumnVisibilityMenuItem,true);};
e.prototype._invalidate=function(){this._bInvalidated=true;};
e.prototype._attachPopupClosed=function(){var t=this;if(!D.support.touch){this.getPopup().attachClosed(function(){t._iPopupClosedTimeoutId=window.setTimeout(function(){if(t._oColumn){if(t._lastFocusedDomRef){t._lastFocusedDomRef.focus();}else{t._oColumn.focus();}}},0);});}};
e.prototype.open=function(){if(this._bInvalidated){this._bInvalidated=false;this._removeColumnVisibilityFromAggregation();this.destroyItems();this._addMenuItems();}else if(this._oColumn){this._addColumnVisibilityMenuItem();}T.Hook.call(this._oTable,T.Hook.Keys.Table.OpenMenu,T.getCellInfo(arguments[4]),this);if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];M.prototype.open.apply(this,arguments);}};
e.prototype._addMenuItems=function(){if(this._oColumn){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem();}};
e.prototype._addSortMenuItem=function(h){var o=this._oColumn;if(o.isSortableByMenu()){var s=h?"desc":"asc";var i=h?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(s,"TBL_SORT_"+s.toUpperCase(),i,function(E){o.sort(h,E.getParameter("ctrlKey")===true);}));}};
e.prototype._addFilterMenuItem=function(){var o=this._oColumn;if(o.isFilterableByMenu()){var t=o.getParent();var h=t&&t.getEnableCustomFilter();if(h){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:o});}));}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",o.getFilterValue(),function(){o.filter(this.getValue());}));}}};
e.prototype._addGroupMenuItem=function(){var o=this._oColumn;if(o.isGroupable()){var t=this._oTable;this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){t.setGroupBy(o);}));}};
e.prototype._addFreezeMenuItem=function(){var o=this._oColumn;var t=this._oTable;var h=t&&t.getEnableColumnFreeze();if(h){var i=o.getIndex();var I=i+T.Column.getHeaderSpan(o)==t.getComputedFixedColumnCount();this.addItem(this._createMenuItem("freeze",I?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var E=t.fireColumnFreeze({column:o});if(E){if(I){t.setFixedColumnCount(0);}else{t.setFixedColumnCount(i+1);}}}));}};
e.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){if(!t._oColumnVisibilityMenuItem||t._oColumnVisibilityMenuItem.bIsDestroyed){t._oColumnVisibilityMenuItem=this._createMenuItem("column-visibilty","TBL_COLUMNS");var o=new M(t._oColumnVisibilityMenuItem.getId()+"-menu");t._oColumnVisibilityMenuItem.setSubmenu(o);}this.addItem(t._oColumnVisibilityMenuItem);this._updateColumnVisibilityMenuItem();}};
e.prototype._createColumnVisibilityMenuItem=function(o){var t=this._oTable;var s=T.Column.getHeaderText(t,o.getIndex());return new a({text:s,icon:o.getVisible()?"sap-icon://accept":null,ariaLabelledBy:[t.getId()+(o.getVisible()?"-ariahidecolmenu":"-ariashowcolmenu")],select:q.proxy(function(E){var v=!o.getVisible();if(v||T.getVisibleColumnCount(this._oTable)>1){var t=o.getParent();var h=true;if(T.isA(t,"sap.ui.table.Table")){h=t.fireColumnVisibility({column:o,newVisible:v});}if(h){o.setVisible(v);}}},this)});};
e.prototype._createMenuItem=function(i,t,I,h){return new a(this.getId()+"-"+i,{text:T.getResourceText(t),icon:I?"sap-icon://"+I:null,select:h||function(){}});};
e.prototype._createMenuTextFieldItem=function(i,t,I,v,h){h=h||function(){};return new b(this.getId()+"-"+i,{label:T.getResourceText(t),icon:I?"sap-icon://"+I:null,value:v,select:h||function(){}});};
e.prototype._setFilterValue=function(v){var o=this.getParent();var t=(o?o.getParent():undefined);var F=sap.ui.getCore().byId(this.getId()+"-filter");if(F&&F.setValue&&(t&&!t.getEnableCustomFilter())){F.setValue(v);}return this;};
e.prototype._setFilterState=function(F){var o=this.getParent();var t=(o?o.getParent():undefined);var h=sap.ui.getCore().byId(this.getId()+"-filter");if(h&&h.setValueState&&(t&&!t.getEnableCustomFilter())){h.setValueState(F);}return this;};
function g(t){var h=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){var s=t.getColumnVisibilityMenuSorter();if(typeof s==="function"){h=h.sort(s);}}return h;}
function f(B,o){if(o.isA("sap.ui.table.AnalyticalColumn")){var Q=B.getAnalyticalQueryResult();var E=Q.getEntityType();var m=B.getModel().getProperty("/#"+E.getTypeDescription().name+"/"+o.getLeadingProperty()+"/sap:visible");if(m&&(m.value==="false"||m.value===false)){return true;}}return false;}
e.prototype._updateColumnVisibilityMenuItem=function(){var t=this._oTable;if(!t||!t._oColumnVisibilityMenuItem){return;}var s=t._oColumnVisibilityMenuItem.getSubmenu();if(!s){return;}var h=g(t);var S=s.getItems();var v=t._getVisibleColumns();var B=t.getBinding();var A=T.isA(B,"sap.ui.model.analytics.AnalyticalBinding");for(var i=0;i<h.length;i++){var o=h[i];if(A){if(f(B,o)){continue;}}var I=C.get(o);if(!I||I.bIsDestroyed){var I=this._createColumnVisibilityMenuItem(o);s.insertItem(I,i);C.set(o,I);}else{var j=S.indexOf(I);if(i!==j){s.removeItem(I);s.insertItem(I,i);}}var V=v.indexOf(o)>-1;var k=V?"sap-icon://accept":"";S=s.getItems();S[i].setProperty("icon",k);S[i].setEnabled(!V||v.length>1);}for(var i=S.length;i>h.length;i--){S[i-1].destroy();}};
return e;});
sap.ui.predefine('sap/ui/table/ColumnMenuRenderer',['sap/ui/table/ColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/CreationRow',["./CreationRowRenderer","./Column","./utils/TableUtils","sap/ui/core/Control","sap/m/library","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button"],function(R,C,T,a,M,O,b,B){"use strict";
var c=a.extend("sap.ui.table.CreationRow",{metadata:{library:"sap.ui.table",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_defaultToolbar:{type:"sap.ui.core.Toolbar",multiple:false,visibility:"hidden"}},events:{apply:{allowPreventDefault:true}}}});
c.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);this._updateDefaultToolbar();return this;};
c.prototype.setParent=function(p){a.prototype.setParent.apply(this,arguments);this._update();return this;};
c.prototype.resetFocus=function(){var i=this._getFirstInteractiveElement();if(i){i.focus();T.selectElementText(i);return true;}return false;};
c.prototype.getFocusDomRef=function(){var i=this._getFirstInteractiveElement();if(i){return i;}return a.prototype.getFocusDomRef.apply(this,arguments);};
c.prototype._fireApply=function(){var f=false;if(this.fireApply()){f=this.resetFocus();}return f;};
c.prototype.onsapentermodifiers=function(e){if(this.getApplyEnabled()&&(e.metaKey||e.ctrlKey)){var f=document.activeElement;f.blur();e.setMarked();window.setTimeout(function(){if(!this._fireApply()){f.focus();}}.bind(this),0);}};
function d(o){return new O(o.getId()+"-tb",{content:[new b(),new B(o.getId()+"-applyBtn",{text:T.getResourceText("TBL_CREATIONROW_APPLY"),enabled:o.getApplyEnabled(),press:function(){o._fireApply();}})],style:M.ToolbarStyle.Clear,ariaLabelledBy:[o.getId()+"-label"]});}
c.prototype._getToolbar=function(){var t=this.getToolbar();if(!t){var D=this.getAggregation("_defaultToolbar");if(!D){D=d(this);this.setAggregation("_defaultToolbar",D,true);}t=D;if(t.data("sap-ui-table-invalid")){this._updateDefaultToolbar();}}return t;};
c.prototype._updateDefaultToolbar=function(){var D=this.getAggregation("_defaultToolbar");var A;if(this.getToolbar()){if(D){D.data("sap-ui-table-invalid",true);}return;}if(!D){return;}A=D.getContent()[1];A.setEnabled(this.getApplyEnabled());D.data("sap-ui-table-invalid",null);};
c.prototype._getFirstInteractiveElement=function(){var e=this.getCells();for(var i=0;i<e.length;i++){var o=e[i].getDomRef();var $=T.getCell(this._getTable(),o,true);var I=T.getInteractiveElements($);if(I){return I[0];}}return null;};
c.prototype._getCell=function(i){var e=this.getCells();var o=e.filter(function(o){return C.ofCell(o).getIndex()===i;})[0];if(!o){return null;}return o;};
c.prototype._getCellDomRef=function(i){var o=this._getCell(i);var e=o?o.getDomRef():null;var $=T.getCell(this._getTable(),e,true);if(!$){return null;}return $;};
c.prototype._focusCell=function(i){var o=this._getCellDomRef(i);var I=T.getInteractiveElements(o);if(I){I[0].focus();T.selectElementText(I[0]);return true;}return false;};
c.prototype._takeOverKeyboardHandling=function(e){var t=this._getTable();var o=t?t.getDomRef():null;if(!o||!o.contains(document.activeElement)){return false;}var f=T.getCell(this._getTable(),document.activeElement);var g=T.getCellInfo(f);var F=false;if(g.columnIndex!=null&&g.columnIndex>=0){F=this._focusCell(g.columnIndex);}else{F=this.resetFocus();}if(F&&e){e.preventDefault();}return F;};
c.prototype._update=function(){var t=this._getTable();if(!t){this.removeAllCells();return;}var e=t.getColumns();this.removeAllCells();for(var i=0,l=e.length;i<l;i++){if(e[i].getVisible()){this.addCell(e[i].getTemplateClone(i,"Creation"));}}};
c.prototype._getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};
return c;});
sap.ui.predefine('sap/ui/table/CreationRowRenderer',["./TableRenderer","./utils/TableUtils","sap/ui/core/Renderer"],function(T,a,R){"use strict";var C={apiVersion:2};
C.render=function(r,c){var t=c._getTable();if(!t){return;}r.openStart("div",c);r.attr("data-sap-ui-fastnavgroup","true");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CREATIONROW",{creationRow:c});r.class("sapUiTableCreationRow");r.openEnd();this.renderBeginSection(r);this.renderMiddleSection(r,c,t);this.renderEndSection(r,t);t._getAccRenderExtension().writeAccCreationRowText(r,t,c);r.close("div");};
C.renderBeginSection=function(r){r.openStart("div");r.class("sapUiTableCreationRowBeginSection");r.class("sapUiTableRowHdrScr");r.openEnd();r.close("div");};
C.renderMiddleSection=function(r,c,t){r.openStart("div");r.class("sapUiTableCreationRowMiddleSection");r.openEnd();this.renderForm(r,c,t);this.renderToolbar(r,c);r.close("div");};
C.renderEndSection=function(r,t){r.openStart("div");r.class("sapUiTableCreationRowEndSection");if(a.hasRowActions(t)){r.class("sapUiTableCell");r.class("sapUiTableRowActionHeaderCell");}else{r.class("sapUiTableVSbBg");}r.openEnd();r.close("div");};
C.renderForm=function(r,c,t){if(c.getCells().length===0){return;}r.openStart("div");r.class("sapUiTableCreationRowForm");r.openEnd();if(t.getComputedFixedColumnCount()>0){this.renderRowFormTable(r,t,true);}r.openStart("div");r.class("sapUiTableCtrlScr");r.openEnd();this.renderRowFormTable(r,t,false);r.close("div");r.close("div");};
C.renderRowFormTable=function(r,t,f){var s=f?0:t.getComputedFixedColumnCount();var e=f?t.getComputedFixedColumnCount():t.getColumns().length;var c=t.getCreationRow();r.openStart("table");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CREATIONROW_TABLE");r.class("sapUiTableCtrl");r.style(f?"width":"min-width",t._getColumnsWidth(s,e)+"px");r.openEnd();r.openStart("thead").openEnd();r.openStart("tr");r.class("sapUiTableCtrlCol");r.openEnd();var b=t.getColumns();var d=new Array(e);var i;var o;var g=!f&&e>s;var h;for(i=s;i<e;i++){o=b[i];h={shouldRender:!!(o&&o.shouldRender())};if(h.shouldRender){var w=o.getWidth();if(a.isVariableWidth(w)){g=false;if(f){o._iFixWidth=o._iFixWidth||160;w=o._iFixWidth+"px";}}else if(f){delete o._iFixWidth;}h.width=w;}d[i]=h;}for(i=s;i<e;i++){o=b[i];h=d[i];if(h.shouldRender){r.openStart("th");r.style("width",h.width);r.attr("data-sap-ui-headcolindex",i);r.attr("data-sap-ui-colid",o.getId());r.openEnd();r.close("th");}}if(g){r.openStart("th").openEnd().close("th");}r.close("tr");r.close("thead");r.openStart("tbody").openEnd();r.openStart("tr");r.class("sapUiTableTr");r.openEnd();var j=c.getCells();var v=t._getVisibleColumns();for(i=s;i<e;i++){o=b[i];h=d[i];if(h.shouldRender){r.openStart("td");r.attr("data-sap-ui-colid",o.getId());var k=c._getCell(i);var n=v.length;var I=n>0&&v[0]===o;var l=n>0&&v[n-1]===o;var L=b[t.getFixedColumnCount()-1];var m=f&L===o;var H=R.getTextAlign(o.getHAlign(),k&&k.getTextDirection&&k.getTextDirection());r.style("text-align",H);r.class("sapUiTableCell");r.class("sapUiTablePseudoCell");if(I){r.class("sapUiTableCellFirst");}if(m){r.class("sapUiTableCellLastFixed");}if(l){r.class("sapUiTableCellLast");}r.openEnd();if(k){r.openStart("div");r.class("sapUiTableCellInner");r.openEnd();T.renderTableCellControl(r,t,k,I);r.close("div");}r.close("td");}}if(!f&&g&&j.length>0){r.openStart("td").class("sapUiTableCellDummy").openEnd().close("td");}r.close("tr");r.close("tbody");r.close("table");};
C.renderToolbar=function(r,c){r.renderControl(c._getToolbar());};
return C;},true);
sap.ui.predefine('sap/ui/table/Row',["sap/ui/core/Element","./utils/TableUtils","sap/ui/thirdparty/jquery"],function(E,T,q){"use strict";var R=Object.freeze({Standard:"Standard",Summary:"Summary",GroupHeader:"GroupHeader"});
function a(){var c=null;var t=R.Standard;var C=false;var d="";var e=false;var f=false;var l=0;Object.defineProperties(this,{context:{get:function(){return c;},set:function(_){c=_||null;}},Type:{get:function(){return R;}},type:{get:function(){return t;},set:function(_){if(!(_ in R)){throw Error("Is not a valid type for sap.ui.table.Row: "+_);}t=_;}},empty:{get:function(){return this.context==null;}},contentHidden:{get:function(){return this.empty?true:C;},set:function(_){C=_===true;}},title:{get:function(){return this.empty?"":d;},set:function(_){d=(typeof _==="string"?_:"");}},expandable:{get:function(){return this.empty?false:f;},set:function(_){f=_===true;}},expanded:{get:function(){return this.expandable?e:false;},set:function(_){e=_===true;}},level:{get:function(){return this.empty?0:l;},set:function(_){l=(typeof _==="number"?Math.max(1,_||1):1);}},reset:{value:function(){c=null;t=R.Standard;C=false;d="";f=false;e=false;l=1;}}});}
var S=new window.WeakMap();
function s(r){if(!S.has(r)){S.set(r,Object.seal(new a()));}return S.get(r);}
var b=E.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});
b.prototype.init=function(){this.initDomRefs();};
b.prototype.exit=function(){this.initDomRefs();};
b.prototype.getFocusInfo=function(){var t=this.getTable();return t?t.getFocusInfo():E.prototype.getFocusInfo.apply(this,arguments);};
b.prototype.applyFocusInfo=function(f){var t=this.getTable();if(t){t.applyFocusInfo(f);}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};
b.prototype.addStyleClass=function(c){this.getDomRefs(true).row.addClass(c);};
b.prototype.removeStyleClass=function(c){this.getDomRefs(true).row.removeClass(c);};
b.prototype.initDomRefs=function(){this._mDomRefs={};};
b.prototype.getIndex=function(){var t=this.getTable();if(!t){return-1;}var r=t.indexOfRow(this);var m=t._getRowCounts();if(m.fixedTop>0&&r<m.fixedTop){return r;}if(m.fixedBottom>0&&r>=m.count-m.fixedBottom){var i=t._getTotalRowCount();if(i>=m.count){return i-(m.count-r);}else{return r;}}return t._getFirstRenderedRowIndex()+r;};
b.prototype.getDomRefs=function(j,c){j=j===true;c=c===true;var k=j?"jQuery":"dom";var d=this._mDomRefs;if(!d[k]){var t=this.getTable();var g=function(i){var e=document.getElementById(i);if(e){return j?q(e):e;}return null;};var G=function(e){if(e){return j?e.parent():e.parentNode;}return null;};d[k]={};if(t){var r=t.indexOfRow(this);d[k].rowSelector=g(t.getId()+"-rowsel"+r);d[k].rowAction=g(t.getId()+"-rowact"+r);}d[k].rowHeaderPart=G(d[k].rowSelector);d[k].rowFixedPart=g(this.getId()+"-fixed");d[k].rowScrollPart=g(this.getId());d[k].rowActionPart=G(d[k].rowAction);d[k].rowSelectorText=g(this.getId()+"-rowselecttext");if(j){d[k].row=q().add(d[k].rowHeaderPart).add(d[k].rowFixedPart).add(d[k].rowScrollPart).add(d[k].rowActionPart);}}var K=d[k];if(c){return Object.keys(K).map(function(k){return K[k];}).filter(Boolean);}return K;};
b.prototype._updateSelection=function(){var t=this.getTable();var i=t._getSelectionPlugin().isIndexSelected(this.getIndex());this._setSelected(i);t._getAccExtension().updateSelectionStateOfRow(this);};
b.prototype.setRowBindingContext=function(c,t){var B=t.getBindingInfo("rows");var m=B?B.model:undefined;var o=s(this);o.reset();o.context=c;if(o.context){T.Hook.call(t,T.Hook.Keys.Row.UpdateState,o);}this.setBindingContext(o.context,m);this.getDomRefs(true).row.toggleClass("sapUiTableRowHidden",this.isContentHidden());this._updateTableCells(t);};
b.prototype.getRowBindingContext=function(){return s(this).context;};
b.prototype.setBindingContext=function(c,m){return E.prototype.setBindingContext.call(this,c||null,m);};
b.prototype._updateTableCells=function(t){var c=this.getCells(),A=this.getIndex(),h=!!t._updateTableCell,C,$,H,B=this.getRowBindingContext();for(var i=0;i<c.length;i++){C=c[i];H=!!C._updateTableCell;$=H||h?C.$().closest("td"):null;if(H){C._updateTableCell(C,B,$,A);}if(h){t._updateTableCell(C,B,$,A);}}};
b.prototype.getType=function(){return s(this).type;};
b.prototype.isGroupHeader=function(){return this.getType()===R.GroupHeader;};
b.prototype.isSummary=function(){return this.getType()===R.Summary;};
b.prototype.isGroupSummary=function(){return this.isSummary()&&this.getLevel()>1;};
b.prototype.isTotalSummary=function(){return this.isSummary()&&this.getLevel()===1;};
b.prototype.isEmpty=function(){return s(this).empty;};
b.prototype.isContentHidden=function(){return s(this).contentHidden;};
b.prototype.getLevel=function(){return s(this).level;};
b.prototype.getTitle=function(){return s(this).title;};
b.prototype.isExpandable=function(){return s(this).expandable;};
b.prototype.isExpanded=function(){return s(this).expanded;};
b.prototype.destroy=function(){this.removeAllCells();return E.prototype.destroy.apply(this,arguments);};
b.prototype.invalidate=function(){return this;};
b.prototype.getDragGhost=function(){var t=this.getTable();var o=t.getDomRef();var r=this.getDomRefs();var g;var G;var c;var d=t._getSelectionPlugin().getSelectedCount();function e(j){j.removeAttribute("id");j.removeAttribute("data-sap-ui");j.removeAttribute("data-sap-ui-related");var k=j.children.length;for(var i=0;i<k;i++){e(j.children[i]);}}function f(o,i){var j=o.cloneNode();var k=o.querySelector("thead").cloneNode(true);var l=o.querySelector("tbody").cloneNode();var m=i.cloneNode(true);l.appendChild(m);j.appendChild(k);j.appendChild(l);return j;}g=o.cloneNode();g.classList.add("sapUiTableRowGhost");g.classList.remove("sapUiTableVScr");g.classList.remove("sapUiTableHScr");g.style.width=o.getBoundingClientRect().width+"px";if(r.rowSelector){G=t.getDomRef("sapUiTableRowHdrScr").cloneNode();c=r.rowSelector.cloneNode(true);G.appendChild(c);g.appendChild(G);}if(r.rowFixedPart){G=t.getDomRef("sapUiTableCtrlScrFixed").cloneNode();c=f(t.getDomRef("table-fixed"),r.rowFixedPart);G.appendChild(c);g.appendChild(G);}if(r.rowScrollPart){var h=t.getDomRef("sapUiTableCtrlScr");G=h.cloneNode();c=f(t.getDomRef("table"),r.rowScrollPart);G.appendChild(t.getDomRef("tableCtrlCnt").cloneNode());G.firstChild.appendChild(c);g.appendChild(G);}if(r.rowAction){G=t.getDomRef("sapUiTableRowActionScr").cloneNode();c=r.rowAction.cloneNode(true);G.appendChild(c);g.appendChild(G);}if(d>1){G=document.createElement("div");G.classList.add("sapUiTableRowGhostCount");var C=document.createElement("div");C.textContent=d;G.appendChild(C);g.appendChild(G);}e(g);return g;};
b.prototype._setSelected=function(c){var t=this.getTable();if(c){this.addStyleClass("sapUiTableRowSel");}else{this.removeStyleClass("sapUiTableRowSel");}if(t){T.dynamicCall(t._getSyncExtension,function(o){o.syncRowSelection(t.indexOfRow(this),c);},this);}};
b.prototype._setHovered=function(h){var t=this.getTable();if(h){this.addStyleClass("sapUiTableRowHvr");}else{this.removeStyleClass("sapUiTableRowHvr");}if(t){T.dynamicCall(t._getSyncExtension,function(o){o.syncRowHover(t.indexOfRow(this),h);},this);}};
b.prototype.getRowAction=function(){return this.getAggregation("_rowAction");};
b.prototype.getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};
b.prototype.Type=R;return b;});
sap.ui.predefine('sap/ui/table/RowAction',["./library","./utils/TableUtils","./RowActionRenderer","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/unified/Menu","sap/ui/core/Popup"],function(l,T,R,C,I,M,P){"use strict";
var a=C.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}}});
a.prototype.init=function(){this._bFixedLayout=true;this._aActions=["",""];this._iLastCloseTime=0;this.addAggregation("_icons",new I(this.getId()+"-icon0",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var i=this.getAggregation("_icons")[0].getDomRef();if(this._aActions[0]==="menu"){i.setAttribute("aria-haspopup",true);}else{i.removeAttribute("aria-haspopup");}}},this);this.addAggregation("_icons",new I(this.getId()+"-icon1",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var i=this.getAggregation("_icons")[1].getDomRef();if(this._aActions[1]==="menu"){i.setAttribute("aria-haspopup",true);}else{i.removeAttribute("aria-haspopup");}}},this);};
a.prototype.onBeforeRendering=function(){var r=this.getRow();var t=r?r.getTable():null;var i=this.getAggregation("_icons");var b=this.getItems();var v=this._getVisibleItems();var V=v.length;var s=this._getSize();var h=t?t.getId()+"-rowacthdr":"";if(this._bFixedLayout&&V===1&&s===2&&b.length>1&&v[0]===b[1]){v[0]._syncIcon(i[1]);this._aActions=["","action_fixed"];}else if(V===0||s===0){this._aActions=["",""];}else if(V===1&&s>0){v[0]._syncIcon(i[0]);this._aActions=["action",""];}else if(V===2&&s===2){v[0]._syncIcon(i[0]);v[1]._syncIcon(i[1]);this._aActions=["action","action"];}else if(V>2&&s===2){v[0]._syncIcon(i[0]);i[1].setSrc("sap-icon://overflow");i[1].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["action","menu"];}else{i[0].setSrc("sap-icon://overflow");i[0].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["menu",""];}i.forEach(function(o,c){o.removeAllAriaLabelledBy();o.removeStyleClass("sapUiTableActionHidden");if(h){o.addAriaLabelledBy(h);}if(this._aActions[c]===""){o.addStyleClass("sapUiTableActionHidden");}}.bind(this));};
a.prototype.getAccessibilityInfo=function(){var r=this.getRow();var v=this._getVisibleItems().length;var s=this._getSize();var A=this.getVisible()&&v>0&&s>0&&(!r||(!r.isContentHidden()&&!r.isGroupHeader()&&!r.isSummary()));var t;if(A){t=T.getResourceText(v==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[v]);}else{t=T.getResourceText("TBL_ROW_ACTION_NO_ACTION");}return{focusable:A,enabled:A,description:t};};
a.prototype._getVisibleItems=function(){return this.getItems().filter(function(i){return i.getVisible();});};
a.prototype.getRow=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Row")?p:null;};
a.prototype._getSize=function(){var r=this.getRow();var t=r?r.getTable():null;return t?t.getRowActionCount():2;};
a.prototype._onIconPress=function(e){var o=e.getSource();var b=this.indexOfAggregation("_icons",o);var A=this._aActions[b];if(A==="action"){this._getVisibleItems()[b]._firePress();}else if(A==="action_fixed"){this._getVisibleItems()[0]._firePress();}else if(A==="menu"){var m=this.getAggregation("_menu");if(!m){m=new M();this.setAggregation("_menu",m,true);m.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now();},this);}m.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return;}var c=this.getItems();for(var i=b;i<c.length;i++){m.addItem(c[i]._getMenuItem());}m.open(null,o,P.Dock.EndTop,P.Dock.EndBottom,o);}};
return a;});
sap.ui.predefine('sap/ui/table/RowActionItem',["./library","./utils/TableUtils","sap/ui/core/Element","sap/ui/unified/MenuItem","sap/ui/core/IconPool"],function(l,T,E,M,I){"use strict";var R=l.RowActionType;
var a=E.extend("sap.ui.table.RowActionItem",{metadata:{library:"sap.ui.table",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Misc",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.ui.table.RowActionType",group:"Behavior",defaultValue:R.Custom}},events:{press:{item:{type:"sap.ui.table.RowActionItem"},row:{type:"sap.ui.table.Row"}}}}});
a.prototype.init=function(){this._oMenuItem=null;};
a.prototype.exit=function(){if(this._oMenuItem){this._oMenuItem.destroy();this._oMenuItem=null;}};
a.prototype.getRowAction=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.RowAction")?p:null;};
a.prototype._firePress=function(){var r=this.getRowAction();this.firePress({item:this,row:r?r.getRow():null});};
a.prototype._getMenuItem=function(){if(!this._oMenuItem){this._oMenuItem=new M({select:[this._firePress,this]});}this._oMenuItem.setIcon(this._getIcon());this._oMenuItem.setVisible(this.getVisible());this._oMenuItem.setText(this._getText(false));return this._oMenuItem;};
a.prototype._getIcon=function(){var i=this.getIcon();if(i){return i;}if(this.getType()===R.Navigation){return I.getIconURI(T.ThemeParameters.navigationIcon);}if(this.getType()===R.Delete){return I.getIconURI(T.ThemeParameters.deleteIcon);}return null;};
a.prototype._getText=function(p){var t=p?(this.getTooltip_AsString()||this.getText()):(this.getText()||this.getTooltip_AsString());if(t){return t;}if(this.getType()===R.Navigation){return T.getResourceText("TBL_ROW_ACTION_NAVIGATE");}if(this.getType()===R.Delete){return T.getResourceText("TBL_ROW_ACTION_DELETE");}return null;};
a.prototype._syncIcon=function(i){i.setSrc(this._getIcon());i.setTooltip(this._getText(true));};
return a;});
sap.ui.predefine('sap/ui/table/RowActionRenderer',['sap/ui/table/Row'],function(R){"use strict";var a={apiVersion:2};
a.render=function(r,A){r.openStart("div",A);r.class("sapUiTableAction");if(!A.getRow()){r.style("display","none");}if(!A.getVisible()){r.class("sapUiTableActionHidden");}var t=A.getTooltip_AsString();if(t){r.attr("title",t);}r.openEnd();var i=A.getAggregation("_icons");r.renderControl(i[0]);r.renderControl(i[1]);r.close("div");};
return a;},true);
sap.ui.predefine('sap/ui/table/RowSettings',['sap/ui/core/Element','./utils/TableUtils','sap/ui/base/DataType','./library','sap/ui/core/library'],function(E,T,D,l,c){"use strict";var M=c.MessageType;var I=c.IndicationColor;
var R=E.extend("sap.ui.table.RowSettings",{metadata:{library:"sap.ui.table",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}}}});
R.prototype.validateProperty=function(p,v){if(p!="highlight"||v==null){return E.prototype.validateProperty.apply(this,arguments);}if(!D.getType("sap.ui.core.MessageType").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected is a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor"+" for property \""+p+"\" of "+this);}return v;};
R.prototype.setHighlight=function(h){var r;var H;this.setProperty("highlight",h,true);r=this._getRow();if(!r){return this;}H=r.getDomRef("highlight");if(!H){return this;}for(var m in M){H.classList.remove("sapUiTableRowHighlight"+m);}for(var i in I){H.classList.remove("sapUiTableRowHighlight"+i);}H.classList.add(this._getHighlightCSSClassName());var t=r.getParent();var a=t?t._getAccExtension():null;if(a){a.updateAriaStateOfRowHighlight(this);}return this;};
R.prototype.setNavigated=function(n){var r;var N;this.setProperty("navigated",n,true);r=this._getRow();if(!r){return this;}N=r.getDomRef("navIndicator");if(!N){return this;}if(n){N.classList.add("sapUiTableRowNavigated");}else{N.classList.remove("sapUiTableRowNavigated");}return this;};
R.prototype.setHighlightText=function(h){var r=this._getRow();var t=r?r.getParent():null;var a=t?t._getAccExtension():null;this.setProperty("highlightText",h,true);if(a){a.updateAriaStateOfRowHighlight(this);}return this;};
R.prototype._getHighlightCSSClassName=function(){var h=this.getHighlight();if(h==null){h=M.None;}return"sapUiTableRowHighlight"+h;};
R.prototype._getHighlightText=function(){var h=this.getHighlight();if(h===M.None){return"";}var H=this.getHighlightText();if(h in M&&H===""){H=T.getResourceText("TBL_ROW_STATE_"+h.toUpperCase());}return H;};
R.prototype._getRow=function(){var r=this.getParent();if(T.isA(r,"sap.ui.table.Row")){return r;}else{return null;}};
return R;});
sap.ui.predefine('sap/ui/table/Table',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/util/PasteHelper','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./utils/TableUtils','./extensions/ExtensionBase','./extensions/Accessibility','./extensions/Keyboard','./extensions/Pointer','./extensions/Scrolling','./extensions/DragAndDrop',"./TableRenderer","./rowmodes/FixedRowMode","./rowmodes/InteractiveRowMode","./rowmodes/AutoRowMode","./plugins/SelectionModelSelection","sap/ui/thirdparty/jquery","sap/base/Log"],function(D,C,E,I,P,a,F,S,B,b,R,c,T,d,A,K,e,f,g,h,j,k,m,n,q,L){"use strict";var G=c.GroupEventType,N=c.NavigationMode,o=c.SelectionMode,p=c.SelectionBehavior,r=c.SortOrder,V=c.VisibleRowCountMode,H=T.Hook.Keys.Table;
var s=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:o.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:p.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar,deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin"},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}}},designtime:"sap/ui/table/designtime/Table.designtime"}});
I.insertFontFaceStyle();
s.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};this._attachExtensions();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._aRowHeights=[];this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){T.readThemeParameters();}this._bInvalid=true;};
s.prototype.applySettings=function(l,M){if(l){var O=["rowMode","plugins"];var Q={};for(var i=0;i<O.length;i++){var U=O[i];if(U in l){Q[U]=l[U];delete l[U];}}if(Object.keys(Q).length>0){C.prototype.applySettings.call(this,Q,M);}}this._initLegacyRowMode();this._initLegacySelectionPlugin();C.prototype.applySettings.call(this,l,M);};
s.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}d.enrich(this,e);d.enrich(this,f);d.enrich(this,K);d.enrich(this,A);d.enrich(this,g);this._bExtensionsInitialized=true;};
s.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();T.Menu.cleanupDefaultContentCellContextMenu(this);delete this._aTableHeaders;};
s.prototype._detachExtensions=function(){d.cleanup(this);};
s.prototype.onpaste=function(i){if(i.isMarked()||/^(input|textarea)$/i.test(i.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(i.target)){return;}var l=P.getPastedDataAs2DArray(i.originalEvent);if(l.length===0||l[0].length===0){return;}this.firePaste({data:l});};
s.prototype.onThemeChanged=function(){T.readThemeParameters();if(this.getDomRef()){this.invalidate();}};
s.prototype.onlocalizationChanged=function(i){var l=i.changes||{};var M=l.hasOwnProperty("rtl");var O=l.hasOwnProperty("language");this._adaptLocalization(M,O).then(function(){this.invalidate();}.bind(this));};
s.prototype._adaptLocalization=function(i,l){if(!i&&!l){return Promise.reject();}var M=Promise.resolve();if(i){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){M=T.getResourceBundle({async:true,reload:true});}return M.then(function(){if(l){T.Menu.cleanupDefaultContentCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};
s.prototype._collectRowHeights=function(l){var M=this.getDomRef();if(!M){return[];}var O=this._getBaseRowHeight();var Q=l?".sapUiTableColHdrTr":".sapUiTableTr";var U=M.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Q);var W=M.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Q);var X=l?T.getHeaderRowCount(this):this.getRows().length;var Y=[];var Z=D.browser.chrome&&window.devicePixelRatio!=1;if(l){if(this.getColumnHeaderHeight()>0){O=this.getColumnHeaderHeight();}else if(this.getRowMode()){O=this._getDefaultRowHeight();}}for(var i=0;i<X;i++){var $=U[i]?U[i].getBoundingClientRect().height:0;var _=W[i]?W[i].getBoundingClientRect().height:0;var a1=Math.max($,_);if(Z){var b1=O-a1;if(b1>0&&b1<1){Y.push(Math.max(a1,O-1));continue;}}Y.push(Math.max(a1,O));}if(Y.length>0&&!l){T.dynamicCall(this._getSyncExtension,function(c1){var d1=c1.syncRowHeights(Y.slice());if(d1&&d1.length===Y.length){Y=d1.slice();}});}return Y;};
s.prototype._resetRowHeights=function(){var l=this._getBaseRowHeight();var M="";if(l){M=l+"px";}var O=this.getDomRef("tableCCnt");if(O){var Q=O.querySelectorAll(".sapUiTableTr");for(var i=0;i<Q.length;i++){Q[i].style.height=M;}}};
s.prototype._resetColumnHeaderHeights=function(){var l=this.getDomRef();if(l){var M=l.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<M.length;i++){M[i].style.height=null;}}};
s.prototype._collectTableSizes=function(){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var M=this.getDomRef();if(!M){return l;}var O=M.querySelector(".sapUiTableCnt");if(O){l.tableCntHeight=O.clientHeight;l.tableCntWidth=O.clientWidth;}var Q=M.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(Q){l.tableCtrlScrollWidth=Q.clientWidth;}var U=M.querySelector(".sapUiTableRowHdrScr");if(U){l.tableRowHdrScrWidth=U.clientWidth;}var W=M.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(W){l.tableCtrlScrWidth=W.clientWidth;}var X=this._getScrollExtension().getHorizontalScrollbar();if(X){l.tableHSbScrollLeft=X.scrollLeft;}var Y=M.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(Y){l.tableCtrlFixedWidth=Y.clientWidth;}var Z=this.getFixedColumnCount();var $=0;if(Z){var _=this.getColumns();var a1=M.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<a1.length;i++){var b1=parseInt(a1[i].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(b1)&&(b1<Z)){var c1=_[b1];var d1;if(c1._iFixWidth!=null){d1=c1._iFixWidth;}else{d1=a1[i].getBoundingClientRect().width;}$+=d1;}}}if($>0){var e1=this._getScrollExtension();var f1=l.tableRowHdrScrWidth;var g1=e1.getVerticalScrollbar();if(g1&&!e1.isVerticalScrollbarExternal()){f1+=g1.offsetWidth;}if(T.hasRowActions(this)){var h1=this.getDomRef("sapUiTableRowActionScr");if(h1){f1+=h1.offsetWidth;}}f1+=T.Column.getMinColumnWidth();var i1=l.tableCntWidth-f1;var j1=i1>$;var k1=!j1;if(this._bIgnoreFixedColumnCount!==k1){this._bIgnoreFixedColumnCount=k1;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return l;};
s.prototype._updateRowHeights=function(i,l){var M=this.getDomRef();if(!M){return;}function O(Z,$){var _=i[$];if(_){Z.style.height=_+"px";}}var Q=l?".sapUiTableColHdrTr":".sapUiTableTr";var U=l?[]:M.querySelectorAll(".sapUiTableRowSelectionCell");var W=l?[]:M.querySelectorAll(".sapUiTableRowActionCell");var X=M.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Q);var Y=M.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Q);Array.prototype.forEach.call(U,O);Array.prototype.forEach.call(W,O);Array.prototype.forEach.call(X,O);Array.prototype.forEach.call(Y,O);};
s.prototype.onBeforeRendering=function(i){this._bInvalid=true;this._detachEvents();if(i&&i.isMarked("renderRows")){return;}this._cleanUpTimers();this.getBinding("rows");this._aTableHeaders=[];};
s.prototype.onAfterRendering=function(i){var l=i&&i.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!l){this._disableTextSelection(this.$().find(".sapUiTableColHdrCnt"));}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!l){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");}this._updateTableSizes(T.RowsUpdateReason.Render,true);T.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false;};
s.prototype.invalidate=function(){this._bInvalid=true;T.Column.invalidateColumnUtils(this);return C.prototype.invalidate.call(this);};
s.prototype._initRowDomRefs=function(){var l=this.getRows();for(var i=0;i<l.length;i++){l[i].initDomRefs();}};
s.prototype._updateTableSizes=function(l,M){M=M===true;var O=this.getDomRef();if(this._bInvalid||!O||!sap.ui.getCore().isThemeApplied()||O.offsetWidth===0){return;}if(!M){this._resetRowHeights();this._resetColumnHeaderHeights();}this._aRowHeights=this._collectRowHeights(false);var Q=this._collectRowHeights(true);function U(f1){var g1=f1.getDomRef();var h1=T.Column.getMinColumnWidth();var i1=[];var j1=f1.getColumnHeaderVisible();function k1(n1,o1){if(n1<=o1){return Math.max(n1,o1-5,h1)+"px";}return-1;}function l1(o1){var p1=Math.max(o1._minWidth||0,h1,o1.getMinWidth());var q1=o1.getWidth();var r1;var s1;var t1;if(T.isVariableWidth(q1)&&!T.isFixedColumn(f1,o1.getIndex())){r1=g1.querySelectorAll('th[data-sap-ui-colid="'+o1.getId()+'"]');s1=r1[j1?0:1];t1=s1?s1.offsetWidth:null;if(t1!==null){if(t1<=p1){return{headers:r1,newWidth:k1(t1,p1)};}else if(s1&&s1.style.width!=q1){i1.push({col:o1,header:s1,minWidth:p1,headers:r1});return{headers:r1,newWidth:q1};}i1.push({col:o1,header:s1,minWidth:p1,headers:r1});}}return null;}function m1(o1){if(o1){Array.prototype.forEach.call(o1.headers,function(p1){p1.style.width=o1.newWidth;});}}f1._getVisibleColumns().map(l1).forEach(m1);if(i1.length){var n1;for(var i=0;i<i1.length;i++){n1=i1[i].header&&i1[i].header.offsetWidth;i1[i].newWidth=k1(n1,i1[i].minWidth);if(parseInt(i1[i].newWidth)>=0){m1(i1[i]);}}}}U(this);var W=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(Q,true);T.dynamicCall(this._getSyncExtension,function(i){i.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height});},this);var X=this._getScrollExtension();X.updateHorizontalScrollbar(W);X.updateVerticalScrollbarPosition();X.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)||T.hasRowNavigationIndicators(this)){var Y=$.hasClass("sapUiTableRActFlexible");var Z=this.getDomRef("dummycolhdr");if(Z){var _=this.getDomRef("header");var a1=_.clientWidth;var b1=this.getColumns().reduce(function(b1,i){if(i.getDomRef()&&i.getIndex()>=this.getComputedFixedColumnCount()){return b1+T.convertCSSSizeToPixel(i.getWidth());}return b1;}.bind(this),0);var c1=a1>b1;if(!Y&&c1){var d1=b1+W.tableRowHdrScrWidth+W.tableCtrlFixedWidth;var e1={};if(!T.hasRowActions(this)){d1=d1-T.ThemeParameters.navIndicatorWidth+T.BaseBorderWidth;}e1[this._bRtlMode?"right":"left"]=d1;this.$("sapUiTableRowActionScr").css(e1);this.$("rowacthdr").css(e1);$.toggleClass("sapUiTableRActFlexible",true);}else if(Y&&!c1){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");T.Hook.call(this,H.UpdateSizes,l);};
s.prototype.setShowOverlay=function(i){i=!!i;this.setProperty("showOverlay",i,true);if(this.getDomRef()){var l=document.activeElement;this.$().toggleClass("sapUiTableOverlay",i);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(l);}return this;};
s.prototype._updateFixedBottomRows=function(){var i=this.getDomRef();if(!i||this._getRowCounts().fixedBottom===0){return;}var l=T.getFirstFixedBottomRowIndex(this);var M=this.getRows();var $;q(i).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");q(i).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(l>=0&&l<M.length){$=M[l].getDomRefs(true);$.row.addClass("sapUiTableRowFirstFixedBottom",true);}if(l>=1&&l<M.length){$=M[l-1].getDomRefs(true);$.row.addClass("sapUiTableRowLastScrollable",true);}};
s.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};
s.prototype.applyFocusInfo=function(i){if(i&&i.customId){q(document.getElementById(i.customId)).trigger("focus");}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};
s.prototype.setTitle=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});l.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",l);return this;};
s.prototype.setFooter=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});}this.setAggregation("footer",l);return this;};
s.prototype.setSelectionMode=function(i){if(i===o.Multi){i=o.MultiToggle;L.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this);}if(this._hasSelectionPlugin()){L.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this);}else{this.setProperty("selectionMode",i);this._oLegacySelectionPlugin.setSelectionMode(i);}return this;};
s.prototype.setFirstVisibleRow=function(i){this._setFirstVisibleRowIndex(i);return this;};
s.prototype._setFirstVisibleRowIndex=function(i,l){l=Object.assign({onScroll:false,suppressEvent:false,forceEvent:false,suppressRendering:false},l);if(parseInt(i)<0){L.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);i=0;}if(this._getTotalRowCount()>0){var M=this._getMaxFirstVisibleRowIndex();if(M<i){if(!l.onScroll){L.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);}i=M;}}var O=this.getFirstVisibleRow()!=i;var Q=this._getScrollExtension();var U=false;if(O){var W=this._getFirstRenderedRowIndex();this.setProperty("firstVisibleRow",i,true);if(this.getBinding("rows")){var X=this._getFirstRenderedRowIndex()!==W;if(X&&!l.suppressRendering){y(this,l.onScroll?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange);U=true;}if(!l.onScroll){Q.updateVerticalScrollPosition(X);}}if(!l.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}else{if(l.forceEvent&&!l.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}if(!l.onScroll){Q.updateVerticalScrollPosition();}}return U;};
s.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
s.prototype.bindAggregation=function(i,l){if(i==="rows"){this._bindRows(u(Array.prototype.slice.call(arguments,1)));return this;}return C.prototype.bindAggregation.apply(this,arguments);};
s.prototype.bindRows=function(i){this._bindRows(u(arguments));return this;};
s.prototype._bindRows=function(i){t(this);x(this);s._addBindingListener(i,"change",function(){this._onBindingChange.apply(this,arguments);}.bind(this));s._addBindingListener(i,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments);}.bind(this));s._addBindingListener(i,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments);}.bind(this));if(this.getEnableBusyIndicator()){this.setBusy(false);}T.Hook.call(this,H.BindRows,i);C.prototype.bindAggregation.call(this,"rows",i);this._bRowsBeingBound=false;};
s.prototype._bindAggregation=function(i,l){if(i==="rows"){t(this);}C.prototype._bindAggregation.call(this,i,l);if(i==="rows"){var M=this.getBinding("rows");var O=M?M.getModel():null;this._bRowsBeingBound=false;T.Hook.call(this,H.RowsBound,M);if(O&&O.getDefaultBindingMode()===B.OneTime){L.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}};
s.prototype.unbindAggregation=function(i,l){if(i==="rows"){this._unbindRows();return this;}return C.prototype.unbindAggregation.apply(this,arguments);};
s.prototype.unbindRows=function(){this._unbindRows();return this;};
s.prototype._unbindRows=function(){var i=this.getBindingInfo("rows");if(i){T.Hook.call(this,H.UnbindRows,i);}C.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return;}this._adjustToTotalRowCount();if(i){T.Hook.call(this,H.RowsUnbound);}};
function t(i){i._bRowsBeingBound=true;i._bContextsAvailable=false;i._iPendingRequests=0;i._bPendingRequest=false;i._iBindingLength=null;}
function u(i){var l;if(i==null||i[0]==null){l={};}else if(typeof i[0]==="string"){var M=i[0];var O=i[1];var Q=i[2];var U=i[3];if(O instanceof S||Array.isArray(Q)&&Q[0]instanceof F){U=Q;Q=O;O=undefined;}l={path:M,sorter:Q,filters:U,template:O};}else{l=i[0];}return l;}
s._addBindingListener=function(i,l,M,O){if(!i.events){i.events={};}var Q=i.events[l];i.events[l]=function(){M.apply(O,arguments);if(Q){Q.apply(this,arguments);}};};
s.prototype._onBindingChange=function(i){var l=i.getParameter("reason");if(l===a.Sort||l===a.Filter){this.setFirstVisibleRow(0);}};
s.prototype.setRowMode=function(i){this._destroyLegacyRowMode();this.setAggregation("rowMode",i);this._initLegacyRowMode();};
s.prototype.getRowMode=function(){return this.getAggregation("rowMode");};
s.prototype._getRowMode=function(){var i=this.getRowMode()||this._oLegacyRowMode;if(!i){this._initLegacyRowMode();i=this._oLegacyRowMode;}return i;};
s.prototype._initLegacyRowMode=function(){if(this._oLegacyRowMode||this.getRowMode()){return;}this._oLegacyRowMode=v(this);this.addAggregation("_hiddenDependents",this._oLegacyRowMode);};
s.prototype._destroyLegacyRowMode=function(){if(this._oLegacyRowMode){this._oLegacyRowMode.destroy();delete this._oLegacyRowMode;}};
function v(i){var l;switch(i.getVisibleRowCountMode()){case V.Fixed:l=new j(true);break;case V.Interactive:l=new k(true);break;case V.Auto:l=new m(true);break;default:}return l;}
s.prototype._getRowCounts=function(){return this._getRowMode().getComputedRowCounts();};
s.prototype.setVisibleRowCountMode=function(i){if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCountMode\" has no effect");return this.setProperty("visibleRowCountMode",i,true);}var O=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",i);var l=this.getVisibleRowCountMode();if(l!==O){this._destroyLegacyRowMode();this._initLegacyRowMode();}return this;};
s.prototype.setVisibleRowCount=function(i){var l=this.getVisibleRowCountMode();if(l==V.Auto){L.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}if(i!=null&&!isFinite(i)){return this;}var M=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=M&&M>0){L.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCount\" has no effect");return this.setProperty("visibleRowCount",i,true);}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this._getTotalRowCount()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);T.dynamicCall(this._getSyncExtension,function(O){O.syncRowCount(i);});return this;};
s.prototype.setMinAutoRowCount=function(M){if(parseInt(M)<1){L.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);M=1;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"minAutoRowCount\" has no effect");return this.setProperty("minAutoRowCount",M,true);}return this.setProperty("minAutoRowCount",M);};
s.prototype.setTooltip=function(i){L.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",i,true);};
s.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);L.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this;};
s.prototype._getFixedBottomRowContexts=function(){var i=this._getRowCounts();var l=this._getTotalRowCount();if(i.fixedBottom>0&&i.count-i.fixedBottom<l){return this._getContexts(l-i.fixedBottom,i.fixedBottom);}else{return[];}};
s.prototype._getFixedRowContexts=function(){var i=this._getRowCounts();if(i.fixedTop>0){return this._getContexts(0,i.fixedTop);}else{return[];}};
s.prototype._getContexts=function(i,l,M){var O=this.getBinding("rows");if(O){return O.getContexts(i,l,M);}else{return[];}};
s.prototype._getRowContexts=function(l,M,O){var Q=this.getBinding("rows");var U=this.getRows().length;l=l==null?U:l;l=Math.max(l,this._getRowMode().getMinRequestLength());if(!Q||l<=0){return[];}M=M===true;O=O===true;var W=this._getFirstRenderedRowIndex();var X=this._getRowCounts();var Y=[];var Z;var $=l-X.fixedBottom;var _=0;var a1=$;var b1=this.getThreshold();b1=b1?Math.max(U,b1):0;var c1=W;var d1=function(g1,h1,c1){for(var i=0;i<h1.length;i++){g1[c1+i]=h1[i];}};if(X.fixedTop>0&&W>0){c1=W+X.fixedTop;$-=X.fixedTop;_=X.fixedTop;Z=this._getFixedRowContexts();Y=Y.concat(Z);}Z=this._getContexts(c1,$,b1);if(!M){this._adjustToTotalRowCount();}var e1=this._getTotalRowCount();d1(Y,Z,_);a1=Math.min(a1,Math.max(e1-X.fixedBottom,0));if(X.fixedBottom>0){Z=this._getFixedBottomRowContexts();d1(Y,Z,a1);}var f1=this._getMaxFirstRenderedRowIndex();if(f1<W&&this._bContextsAvailable&&!O){this.setProperty("firstVisibleRow",f1,true);Y=this._getRowContexts(l,M,true);}return Y;};
s.prototype._adjustToTotalRowCount=function(){var i=this.getBinding("rows");var l=this._getTotalRowCount();var M=this._getScrollExtension();if(this._iBindingLength!==l){this._iBindingLength=l;this._updateFixedBottomRows();M.adjustToTotalRowCount();if(!i||!T.hasPendingRequests(this)){this._updateNoData();}}};
s.prototype.refreshRows=function(i){this._bContextsAvailable=false;if(i===a.Sort||i===a.Filter){this.setFirstVisibleRow(0);}T.Hook.call(this,H.RefreshRows,i||T.RowsUpdateReason.Unknown);};
s.prototype.updateRows=function(i,l){if(this.bIsDestroyed||this._bIsBeingDestroyed){return;}if(l.detailedReason==="AddVirtualContext"){w(this);return;}else if(l.detailedReason==="RemoveVirtualContext"){x(this);return;}this._bContextsAvailable=true;y(this,i);};
function w(i){var l=i._getRowContexts(null,true)[0];x(i);i._oVirtualRow=i._getRowClone("virtual");i._oVirtualRow.setBindingContext(l,i.getBindingInfo("rows").model);i.addAggregation("_hiddenDependents",i._oVirtualRow);}
function x(i){if(i._oVirtualRow){i._oVirtualRow.destroy();delete i._oVirtualRow;}}
function y(i,l){if(i._bContextsAvailable){T.Hook.call(i,H.UpdateRows,l||T.RowsUpdateReason.Unknown);}}
s.prototype.insertRow=function(){L.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);return this;};
s.prototype.addRow=function(){L.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);return this;};
s.prototype.removeRow=function(){L.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);return null;};
s.prototype.removeAllRows=function(){L.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);return[];};
s.prototype.destroyRows=function(){L.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);return this;};
s.prototype.setCreationRow=function(i){if(!T.isA(i,"sap.ui.table.CreationRow")){i=null;}return this.setAggregation("creationRow",i);};
s.prototype.getCreationRow=function(){return this.getAggregation("creationRow");};
s.prototype.destroyCreationRow=function(){return this.destroyAggregation("creationRow");};
s.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};
s.prototype._attachEvents=function(){var $=this.$();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(i){if(q(i.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);d.attachEvents(this);};
s.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this,"Table");D.resize.detachHandler(this._onWindowResize,this);d.detachEvents(this);};
s.prototype._cleanUpTimers=function(){var i;for(i in this._mTimeouts){if(this._mTimeouts[i]){window.clearTimeout(this._mTimeouts[i]);delete this._mTimeouts[i];}}for(i in this._mAnimationFrames){if(this._mAnimationFrames[i]){window.cancelAnimationFrame(this._mAnimationFrames[i]);delete this._mAnimationFrames[i];}}};
s.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};
s.prototype.removeColumn=function(i,l){var M=this.removeAggregation('columns',i,l);if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var O=this._aSortedColumns.indexOf(i);if(!this._bReorderInProcess&&O>=0){this._aSortedColumns.splice(O,1);}this.invalidateRowsAggregation();var Q=this.getCreationRow();if(Q){Q._update();}return M;};
s.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return i;};
s.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return i;};
s.prototype.addColumn=function(i,l){this.addAggregation('columns',i,l);this.invalidateRowsAggregation();var M=this.getCreationRow();if(M){M._update();}return this;};
s.prototype.insertColumn=function(i,l,M){this.insertAggregation('columns',i,l,M);this.invalidateRowsAggregation();var O=this.getCreationRow();if(O){O._update();}return this;};
s.prototype._getTotalRowCount=function(){var i=this.getBinding("rows");var l=this.getBindingInfo("rows");if(!i){return 0;}if(l.length!=null){return l.length;}return i.getLength();};
s.prototype._getMaxFirstVisibleRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount()-1;}else{M=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,M);};
s.prototype._getMaxFirstRenderedRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount()-this._getRowCounts().count-1;}else{M=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,M);};
s.prototype._getFirstRenderedRowIndex=function(){var i=this.getFirstVisibleRow();if(T.isVariableRowHeightEnabled(this)&&i>this._getMaxFirstRenderedRowIndex()){return this._getMaxFirstRenderedRowIndex();}else{return i;}};
s.prototype._getVisibleColumns=function(){var M=[];var O=this.getColumns();for(var i=0,l=O.length;i<l;i++){if(O[i].shouldRender()){M.push(O[i]);}}return M;};
s.prototype._getColumnsWidth=function(M,O){var Q=this.getColumns();var U=0;if(M!==0&&!M){M=0;}if(O!==0&&!O){O=Q.length;}for(var i=M,l=O;i<l;i++){if(Q[i]&&Q[i].shouldRender()){var W=T.convertCSSSizeToPixel(Q[i].getWidth());if(W==null){W=T.Column.getMinColumnWidth();}U+=W;}}return U;};
s.prototype._onTableResize=function(i){var O=i.oldSize.width;var l=i.size.width;if(this._bInvalid||!this.getDomRef()||O===l){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};
s.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);this._adjustOutlineOffset();}};
s.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout");}else{this.removeStyleClass("sapUiTableZoomout");}};
s.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(l){l.preventDefault();return false;});};
s.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart");};
s.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};
s.prototype._findAndfireCellEvent=function(i,l,M){var $=q(l.target);var O=$.closest(".sapUiTableDataCell");var Q=O.attr("id");var U=/.*-row(\d*)-col(\d*)/i.exec(Q);var W=false;if(U){var X=U[1];var Y=U[2];var Z=this.getRows()[X];var _=Z&&Z.getCells()[Y];var a1=Z&&Z.getIndex();var b1=b.ofCell(_).getId();var c1=Z.getRowBindingContext();var d1={rowIndex:a1,columnIndex:Y,columnId:b1,cellControl:_,rowBindingContext:c1,cellDomRef:O.get(0)};W=!i.call(this,d1);if(!W&&typeof M==="function"){d1.cellDomRef=O[0];W=M.call(this,d1);}}return W;};
s.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var i=T.getFocusedItemInfo(this);if(i){return i.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};
s.prototype.pushSortedColumn=function(i,l){if(!l){this._aSortedColumns=[];}if(this._aSortedColumns.indexOf(i)===-1){this._aSortedColumns.push(i);}};
s.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};
s.prototype.sort=function(l,M,O){if(!l){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var Q=this.getBinding("rows");if(Q){Q.sort();}this._aSortedColumns=[];}if(this.getColumns().indexOf(l)>=0){l.sort(M===r.Descending,O);}};
s.prototype.filter=function(i,l){if(this.getColumns().indexOf(i)>=0){if(l==null){l="";}else if(typeof l!=="string"){throw new Error("The filter value is not a string");}i.filter(l);}};
s.prototype._updateSelection=function(){var l=this.getSelectionMode();if(l===o.None){return;}var M=this._getSelectionPlugin().getRenderConfig();var O;var Q;var $=this.$("selall");var U=this.getRows();for(var i=0;i<U.length;i++){var W=U[i];W._updateSelection();}if(!M.headerSelector.visible){return;}if(M.headerSelector.type==="toggle"){var X=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!X);this._getAccExtension().setSelectAllState(X);O=X?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(M.headerSelector.type==="clear"){$.toggleClass("sapUiTableSelAllDisabled",!M.headerSelector.enabled);O="TBL_DESELECT_ALL";if(M.headerSelector.enabled){$.removeAttr("aria-disabled");}else{$.attr("aria-disabled","true");}}if(O){Q=T.getResourceText(O);if(this._getShowStandardTooltips()){$.attr('title',Q);}else if(M.headerSelector.type==="toggle"){this.getDomRef("ariaselectall").innerText=Q;}}};
s.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};
s.prototype._onSelectionChanged=function(i){var l=this._getSelectionPlugin();var M=i.getParameter("rowIndices");var O=i.getParameter("selectAll");var Q=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:l.getSelectedIndex();this._updateSelection();if(!this._hasSelectionPlugin()){this.setProperty("selectedIndex",l.getSelectedIndex(),true);this.fireRowSelectionChange({rowIndex:Q,rowContext:this.getContextByIndex(Q),rowIndices:M,selectAll:O,userInteraction:this._iSourceRowIndex!==undefined});}};
s.prototype.getContextByIndex=function(i){var l=this.getBinding("rows");return i>=0&&l?l.getContexts(i,1)[0]:null;};
s.prototype.getSelectedIndex=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndex();};
s.prototype.setSelectedIndex=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectedIndex(i);return this;};
s.prototype.clearSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.");}this._getSelectionPlugin().clearSelection();return this;};
s.prototype.selectAll=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.");}if(T.hasSelectAll(this)){this._getSelectionPlugin().selectAll();}return this;};
s.prototype.getSelectedIndices=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndices();};
s.prototype.addSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().addSelectionInterval(i,l);return this;};
s.prototype.setSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectionInterval(i,l);return this;};
s.prototype.removeSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().removeSelectionInterval(i,l);return this;};
s.prototype.isIndexSelected=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().isIndexSelected(i);};
s.prototype.setGroupBy=function(i){var l=i;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof l==="string"){l=sap.ui.getCore().byId(l);}var M=false;if(l instanceof b&&l!==O){if(this.getColumns().indexOf(l)===-1){throw new Error("Column has to be part of the columns aggregation!");}var Q=this.fireGroup({column:l,groupedColumns:[l.getId()],type:G.group});if(O){O.setGrouped(false);M=true;}if(Q&&this.getEnableGrouping()){l.setGrouped(true);}}if(!l||M){if(O){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",l);};
s.prototype.getBinding=function(i){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[i||"rows"]);};
s.prototype.setEnableGrouping=function(i){var l=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",i);if(l){l.setGrouped(i);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};
s.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};
s.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};
s.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};
s.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this.getFixedColumnCount();};
s.prototype.setFixedColumnCount=function(l,M){var O=this.getColumns();var Q,i;for(i=l-1;i>=0;i--){Q=O[i];if(Q&&Q.getVisible()){l=Math.max(l,Q.getIndex()+T.Column.getHeaderSpan(Q));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=l-1;i>=0;i--){Q=O[i];if(Q&&T.isVariableWidth(Q.getWidth())){Q._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+Q.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",l,M);this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};
s.prototype.setFixedRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"fixedRowCount\" has no effect");return this.setProperty("fixedRowCount",i,true);}return this.setProperty("fixedRowCount",i);};
s.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"iFixedBottomRowCount\" has no effect");return this.setProperty("fixedBottomRowCount",i,true);}return this.setProperty("fixedBottomRowCount",i);};
s.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);return this;};
s.prototype._invalidateColumnMenus=function(){var M=this.getColumns();for(var i=0,l=M.length;i<l;i++){M[i].invalidateMenu();}};
s.prototype._isTouchEvent=function(i){return!!(i&&i.originalEvent&&i.originalEvent.touches);};
s.prototype._getRowClone=function(M){var O=typeof M==="number";var Q=O;var U=Q?this._aRowClones[M]:null;if(U&&!U.bIsDestroyed){return U;}U=new R(this.getId()+"-rows"+"-row"+(O?M:"-"+M));if(Q){this._aRowClones[M]=U;}var W=this.getColumns();for(var i=0,l=W.length;i<l;i++){if(W[i].getVisible()){var X=W[i].getTemplateClone(i);if(X){U.addCell(X);}}}if(T.hasRowActions(this)){var Y=this.getRowActionTemplate().clone();U.setAggregation("_rowAction",Y,true);}var Z=this.getRowSettingsTemplate();if(Z){var $=Z.clone();U.setAggregation("_settings",$,true);}return U;};
s.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};
s.prototype._getBaseRowHeight=function(){var i=this._getRowMode().getBaseRowContentHeight();if(i>0){return i+T.RowHorizontalFrameSize;}else{return this._getDefaultRowHeight();}};
s.prototype._getDefaultRowHeight=function(){var i=T.getContentDensity(this);return T.DefaultRowHeight[i];};
s.prototype._getDefaultRowContentHeight=function(){var i=T.getContentDensity(this);return T.BaseSize[i];};
s.prototype.setShowNoData=function(i){this.setProperty('showNoData',i,true);this._updateNoData();return this;};
s.prototype.setNoData=function(i){var O=T.getNoDataText(this);this.setAggregation("noData",i,true);var l=T.getNoDataText(this);if(O!=null&&l!=null){if(O!==l){this.$("noDataMsg").text(l);}}else{this.invalidate();}return this;};
s.prototype.exportData=function(M){var O=sap.ui.requireSync("sap/ui/core/util/Export");M=M||{};if(!M.rows){var Q=this.getBinding("rows"),U=this.getBindingInfo("rows");var W=Q.aFilters.concat(Q.aApplicationFilters);M.rows={path:U.path,model:U.model,sorter:Q.aSorters,filters:W,parameters:U.parameters};}if(!M.exportType){var X=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");M.exportType=new X();}var Y=M.rows.model;if(!Y){var Z=M.rows.path;var $=Z.indexOf(">");if($>0){Y=Z.substr(0,$);}}if(!M.columns){M.columns=[];var _=this.getColumns();for(var i=0,l=_.length;i<l;i++){var a1=_[i];if(a1.getSortProperty()){M.columns.push({name:a1.getLabel().getText(),template:{content:{path:a1.getSortProperty(),model:Y}}});}}}var b1=new O(M);this.addDependent(b1);return b1;};
s.prototype._onPersoApplied=function(){var M=this.getColumns();var O=[];for(var i=0,l=M.length;i<l;i++){var Q=M[i];if(Q.getSorted()){O.push(new S(Q.getSortProperty(),Q.getSortOrder()===r.Descending));}}var U=this.getBinding("rows");if(U){if(O.length>0){U.sort(O);}}};
s.prototype._toggleSelectAll=function(){if(!T.hasData(this)||this.getSelectionMode()!==o.MultiToggle){return;}var i=this._getSelectionPlugin();if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;i.clearSelection();}else{this._iSourceRowIndex=0;i.selectAll();}this._iSourceRowIndex=undefined;};
s.prototype.setBusy=function(i,l){var M=this.getBusy()!=i;l="sapUiTableGridCnt";var O=C.prototype.setBusy.call(this,i,l);if(M){this.fireBusyStateChanged({busy:i});}return O;};
s.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);if(!i){this.setBusy(false);}return this;};
s.prototype._onBindingDataRequested=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var l=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(l&&this._iPendingRequests===1||!l)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
s.prototype._onBindingDataReceived=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._adjustToTotalRowCount();if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=setTimeout(function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;}.bind(this),0);}};
s.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};
s.prototype.setRowActionTemplate=function(i){this.setAggregation("rowActionTemplate",i);this.invalidateRowsAggregation();return this;};
s.prototype.setRowActionCount=function(i){if(typeof i==="number"){i=Math.max(0,Math.min(i,2));}return this.setProperty("rowActionCount",i);};
s.prototype.setRowSettingsTemplate=function(i){this.setAggregation("rowSettingsTemplate",i);this.invalidateRowsAggregation();return this;};
s.prototype.addPlugin=function(i){this.addAggregation("plugins",i);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};
s.prototype.insertPlugin=function(i,l){this.insertAggregation("plugins",i,l);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};
s.prototype.removePlugin=function(i){var l=this.removeAggregation("plugins",i);if(T.isA(l,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return l;};
s.prototype.removeAllPlugins=function(){var i=this.removeAllAggregation("plugins");this._initSelectionPlugin();return i;};
s.prototype.destroyPlugins=function(){this.destroyAggregation('plugins');this._initSelectionPlugin();return this;};
s.prototype.getPlugin=function(l){if(typeof l!=="string"){return null;}var M=this.getPlugins();for(var i=0;i<M.length;i++){if(M[i].isA(l)){return M[i];}}return null;};
s.prototype._getSelectionPlugin=function(){var i=this._oSelectionPlugin||this._oLegacySelectionPlugin;if(!i){this._initLegacySelectionPlugin();i=this._oLegacySelectionPlugin;}if(typeof this._getSelectedIndicesCount==="function"&&i.getSelectedCount!==this._getSelectedIndicesCount){i.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(function(M){i[M]=this[M];}.bind(this));}return i;};
s.prototype._hasSelectionPlugin=function(){return this._oSelectionPlugin!=null;};
s.prototype._initSelectionPlugin=function(){var i=this.getPlugin("sap.ui.table.plugins.SelectionPlugin");if(i){this._destroyLegacySelectionPlugin();if(i!==this._oSelectionPlugin){J(this,this._oSelectionPlugin);z(this,i);this._oSelectionPlugin=i;}}else{this._initLegacySelectionPlugin();J(this,this._oSelectionPlugin);delete this._oSelectionPlugin;}};
s.prototype._initLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin||this.getPlugin("sap.ui.table.plugins.SelectionPlugin")){return;}this._oLegacySelectionPlugin=this._createLegacySelectionPlugin();this.addAggregation("_hiddenDependents",this._oLegacySelectionPlugin);z(this,this._oLegacySelectionPlugin);};
s.prototype._destroyLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin){this._oLegacySelectionPlugin.destroy();delete this._oLegacySelectionPlugin;}};
s.prototype._createLegacySelectionPlugin=function(){return new n();};
function z(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.attachSelectionChange(i._onSelectionChanged,i);}}
function J(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.detachSelectionChange(i._onSelectionChanged,i);}}
s.prototype.insertAggregation=function(i,O,l,M){if(i==="_hiddenDependents"){return C.prototype.insertAggregation.call(this,i,O,l,true);}return C.prototype.insertAggregation.apply(this,arguments);};
s.prototype.addAggregation=function(i,O,l){if(i==="_hiddenDependents"){return C.prototype.addAggregation.call(this,i,O,true);}return C.prototype.addAggregation.apply(this,arguments);};
s.prototype.removeAggregation=function(i,O,l){if(i==="_hiddenDependents"){return C.prototype.removeAggregation.call(this,i,O,true);}return C.prototype.removeAggregation.apply(this,arguments);};
s.prototype.removeAllAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.removeAllAggregation.call(this,i,true);}return C.prototype.removeAllAggregation.apply(this,arguments);};
s.prototype.destroyAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.destroyAggregation.call(this,i,true);}C.prototype.destroyAggregation.apply(this,arguments);if(i==="rows"){this._aRowClones.forEach(function(M){M.destroy();});this._aRowClones=[];}return this;};
s.prototype.getCellControl=function(i,l,M){var O=T.getRowColCell(this,i,l,!M);return O.cell;};
s.prototype._fireRowsUpdated=function(i){var l={reason:i||T.RowsUpdateReason.Unknown};this.onRowsUpdated(l);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(l);this.fireEvent("_rowsUpdated",l);}.bind(this),0);};
s.prototype.onRowsUpdated=function(i){this._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();T.Grouping.updateGroups(this);this._updateSelection();};
s.prototype.onRowsContentUpdated=function(i){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(i.reason);}};
s.prototype._enableSynchronization=function(){var i=this;return new Promise(function(l,M){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(O){l(d.enrich(i,O).getInterface());},function(O){M(O);});});};
s.prototype._enableLegacyMultiSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.");}this._legacyMultiSelection=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied");}var M=!!(l.metaKey||l.ctrlKey);if(!this.isIndexSelected(i)){if(M){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else if(M||this._getSelectionPlugin().getSelectedCount()===1){this.removeSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}.bind(this);};
return s;});
sap.ui.predefine('sap/ui/table/TablePersoController',['sap/ui/base/ManagedObject',"sap/ui/core/syncStyleClass","sap/base/Log","sap/ui/thirdparty/jquery",'./utils/TableUtils'],function(M,s,L,q,T){"use strict";
var a=M.extend("sap.ui.table.TablePersoController",{
constructor:function(i,S){M.apply(this,arguments);},
metadata:{properties:{"autoSave":{type:"boolean",defaultValue:true},"persoService":{type:"any"},"customDataKey":{type:"string",defaultValue:"persoKey"}},associations:{"table":{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}
});
a.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue");}};
a.prototype.exit=function(){var t=this._getTable();if(t){this._manageTableEventHandlers(t,false);}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;if(this._oDialog){this._oDialog.destroy();delete this._oDialog;}};
a.prototype.setPersoService=function(S){S=this.validateProperty("persoService",S);if(S&&(!q.isFunction(S.getPersData)||!q.isFunction(S.setPersData)||!q.isFunction(S.delPersData))){throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods "+"\"getPersData\", \"setPersData\" and \"delPersData\".");}var o=this.getPersoService();this.setProperty("persoService",S,true);var n=this.getPersoService();if(n&&n!==o&&this._getTable()&&(this.getAutoSave()||!o)){this.refresh();}return this;};
a.prototype.setAutoSave=function(A){var o=this.getAutoSave();this.setProperty("autoSave",A,true);var n=this.getAutoSave();if(n&&!o){this.savePersonalizations();}return this;};
a.prototype.setTable=function(t){var o=this._getTable();if(o){o._oPersoController=undefined;}this.setAssociation("table",t,true);var n=this._getTable();if(n){n._oPersoController=this;}if(o){this._manageTableEventHandlers(o,false);}if(n&&n!==o){this._oInitialPersoData=this._getCurrentTablePersoData(true);this._manageTableEventHandlers(n,true);if(this.getPersoService()&&(this.getAutoSave()||!o)){this.refresh();}}else if(!n){this._oInitialPersoData=null;}return this;};
a.prototype.setCustomDataKey=function(c){var o=this.getCustomDataKey();this.setProperty("customDataKey",c,true);var n=this.getCustomDataKey();if(o!==n&&this.getAutoSave()){this.savePersonalizations();}return this;};
a.prototype._manageTableEventHandlers=function(t,A){for(var i=0,l=this._aTableEvents.length;i<l;i++){var f=t[(A?"attachEvent":"detachEvent")];f.apply(t,[this._aTableEvents[i],this._tableEventHandler,this]);}};
a.prototype.refresh=function(){var t=this;var S=this.getPersoService();if(S){return S.getPersData().done(function(o){var D=(o&&Array.isArray(o.aColumns))?o:t._oInitialPersoData;t._adjustTable(D);}).fail(function(){L.error("Problem reading persisted personalization data.");});}else{L.error("The Personalization Service is not available!");var d=q.Deferred();d.reject();return d.promise();}};
a.prototype.savePersonalizations=function(){var S=this.getPersoService();if(S){var d=this._getCurrentTablePersoData();d[this._schemaProperty]=this._schemaVersion;return S.setPersData(d).fail(function(){L.error("Problem persisting personalization data.");});}else{L.error("The Personalization Service is not available!");var D=q.Deferred();D.reject();return D.promise();}};
a.prototype._adjustTable=function(d){var t=this._getTable();if(!t||!d||!Array.isArray(d.aColumns)){return;}var c={},C=t.getColumns();for(var i=0,l=C.length;i<l;i++){c[this._getColumnPersoKey(C[i])]=C[i];}var b=d.aColumns;for(var i=0,l=b.length;i<l;i++){var o=b[i];var e=c[o.id];if(e){if(t.indexOfColumn(e)!==o.order){t.removeColumn(e);t.insertColumn(e,o.order);}var m=e.getMetadata();for(var j=0,f=this._aColumnProperties.length;j<f;j++){var p=this._aColumnProperties[j];if(o[p]!==undefined){try{if(m.hasProperty(p)&&e.getProperty(p)!=o[p]){e.setProperty(p,o[p]);}}catch(g){L.error("sap.ui.table.TablePersoController: failed to apply the value \""+e[p]+"\" for the property + \""+p+"\".");}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied();}};
a.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null;},0);}};
a.prototype._getCurrentTablePersoData=function(f){var t=this._getTable(),c=t.getColumns();var d={aColumns:[]};for(var i=0,l=c.length;i<l;i++){var C=c[i];var p=this._getColumnPersoKey(C);var o={id:p,order:i};var m=C.getMetadata();for(var j=0,b=this._aColumnProperties.length;j<b;j++){var P=this._aColumnProperties[j];if(m.hasProperty(P)){o[P]=C.getProperty(P);}}if(f){o.text=T.Column.getHeaderText(t,i)||p;}d.aColumns.push(o);}return d;};
a.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable());};
a.prototype._getColumnPersoKey=function(c){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(c);};
a.prototype._getPersoKey=function(c){var p=c.data(this.getCustomDataKey());if(!p){p=c.getId();if(p.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())===0){L.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \""+c.getId()+"\")");}}return p;};
a.prototype.openDialog=function(S){var t=this;function _(){if(t._oDialog){s("sapUiSizeCompact",t._getTable(),t._oDialog._oDialog);t._oDialog.open();}}if(!this._oDialog){sap.ui.getCore().loadLibrary("sap.m",{async:true}).then(function(){sap.ui.require(["sap/m/TablePersoDialog"],function(b){t._oDialog=new b(t._getTable().getId()+"-PersoDialog",{persoService:t.getPersoService(),showSelectAll:true,showResetAll:true,hasGrouping:false,contentWidth:S&&S.contentWidth,contentHeight:S&&S.contentHeight||"20rem",initialColumnState:t._oInitialPersoData.aColumns,columnInfoCallback:function(o,p,P){return t._getCurrentTablePersoData(true).aColumns;},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations();}}});t._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding");_();});});}else{_();}};
return a;});
sap.ui.predefine('sap/ui/table/TableRenderer',['sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/Device','./library',"./Column",'./utils/TableUtils',"./extensions/ExtensionBase",'sap/ui/core/Renderer','sap/ui/core/IconPool',"sap/base/Log"],function(C,P,D,a,b,T,E,R,I,L){"use strict";var V=a.VisibleRowCountMode;var S=a.SortOrder;var c=T.Column;var f={Begin:"flex-start",End:"flex-end",Left:undefined,Right:undefined,Center:"center"};var d={apiVersion:2};
d.render=function(r,t){delete t._iHeaderRowCount;f.Left=t._bRtlMode?"flex-end":"flex-start";f.Right=t._bRtlMode?"flex-start":"flex-end";T.getResourceBundle();r.openStart("div",t);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.class("sapUiTable");if(D.browser.chrome&&window.devicePixelRatio<1){r.class("sapUiTableZoomout");}if('ontouchstart'in document){r.class("sapUiTableTouch");}r.class("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.class("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.class("sapUiTableRowSelectors");}if(T.hasRowHighlights(t)){r.class("sapUiTableRowHighlights");}var s=a.TableHelper.addTableClass();if(s){r.class(s);}var o=t._getScrollExtension();if(o.isVerticalScrollbarRequired()&&!o.isVerticalScrollbarExternal()){r.class("sapUiTableVScr");}if(t.getEditable()){r.class("sapUiTableEdt");}if(T.hasRowActions(t)){var i=t.getRowActionCount();r.class(i==1?"sapUiTableRActS":"sapUiTableRAct");}else if(T.hasRowNavigationIndicators(t)){r.class("sapUiTableRowNavIndicator");}if(T.isNoDataVisible(t)&&!T.hasPendingRequests(t)){r.class("sapUiTableEmpty");}if(t.getShowOverlay()){r.class("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.class(m);}r.style("width",t.getWidth());t._getRowMode().applyTableStyles(r);if(t._bFirstRendering){r.class("sapUiTableNoOpacity");}r.openEnd();this.renderTabElement(r,"sapUiTableOuterBefore");r.renderControl(t.getAggregation("_messageStrip"));if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.openStart("div",t.getId()+"-sapUiTableCnt");r.class("sapUiTableCnt");r.attr("data-sap-ui-fastnavgroup","true");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTAINER");r.openEnd();r.openStart("div",t.getId()+"-sapUiTableGridCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.openEnd();this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);r.close("div");var e=t.getCreationRow();if(e){r.renderControl(e);this.renderHSbBackground(r,t);this.renderHSb(r,t);}t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.openStart("div",t.getId()+"-overlay");r.class("sapUiTableOverlayArea");r.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.openEnd();r.close("div");r.close("div");if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderBottomPlaceholder(r,t);this.renderTabElement(r,"sapUiTableOuterAfter");r.close("div");};
d.renderHeader=function(r,t,o){r.openStart("div");r.class("sapUiTableHdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.openEnd();r.renderControl(o);r.close("div");};
d.renderToolbar=function(r,t,o){if(!T.isA(o,"sap.ui.core.Toolbar")){return;}r.openStart("div");r.class("sapUiTableTbr");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}if(o.isA("sap.m.Toolbar")){o.setDesign("Transparent",true);o.addStyleClass("sapMTBHeader-CTX");r.class("sapUiTableMTbr");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.openEnd();r.renderControl(o);r.close("div");};
d.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};
d.renderExtension=function(r,t,e){r.openStart("div");r.class("sapUiTableExt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.openEnd();r.renderControl(e);r.close("div");};
d.renderTable=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");r.openStart("div",t.getId()+"-tableCCnt");t._getRowMode().applyRowContainerStyles(r);r.class("sapUiTableCCnt");r.openEnd();this.renderTableCCnt(r,t);r.close("div");this.renderTabElement(r,"sapUiTableCtrlAfter");if(!t._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSbBackground(r,t);this.renderVSb(r,t);}var o=t.getCreationRow();if(!o){this.renderHSbBackground(r,t);this.renderHSb(r,t);}};
d.renderTableCCnt=function(r,t){this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderRowActions(r,t);r.openStart("div",t.getId()+"-noDataCnt");r.class("sapUiTableCtrlEmpty");r.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.openEnd();if(t.getNoData()instanceof C&&t._getVisibleColumns().length>0){r.renderControl(t.getNoData());}else{r.openStart("span",t.getId()+"-noDataMsg");r.class("sapUiTableCtrlEmptyMsg");r.openEnd();r.text(T.getNoDataText(t));r.close("span");}r.close("div");};
d.renderFooter=function(r,t,F){r.openStart("div");r.class("sapUiTableFtr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.openEnd();r.renderControl(F);r.close("div");};
d.renderVariableHeight=function(r,t){r.openStart("div",t.getId()+"-sb");r.attr("tabindex","-1");r.class("sapUiTableHeightResizer");r.style("height","5px");r.openEnd();r.close("div");};
d.renderBottomPlaceholder=function(r,t){var p=t._getRowMode().getTableBottomPlaceholderStyles();if(p===undefined){return;}r.openStart("div",t.getId()+"-placeholder-bottom");r.class("sapUiTablePlaceholder");t._getRowMode().applyTableBottomPlaceholderStyles(r);r.openEnd();r.close("div");};
d.renderColHdr=function(r,t){var n=T.getHeaderRowCount(t);var e=t.getColumns();var F=t.getComputedFixedColumnCount();r.openStart("div");r.class("sapUiTableColHdrCnt");r.openEnd();this.renderColRowHdr(r,t);if(F>0){r.openStart("div");r.class("sapUiTableCHA");r.class("sapUiTableCtrlScrFixed");r.class("sapUiTableNoOpacity");r.openEnd();this.renderTableControlCnt(r,t,true,0,F,true,false,0,n,true);r.close("div");}r.openStart("div",t.getId()+"-sapUiTableColHdrScr");r.class("sapUiTableCHA");r.class("sapUiTableCtrlScr");if(e.length==0){r.class("sapUiTableHasNoColumns");}if(F>0){if(t._bRtlMode){r.style("margin-right","0");}else{r.style("margin-left","0");}}r.openEnd();this.renderTableControlCnt(r,t,false,F,e.length,false,false,0,n,true);r.close("div");r.openStart("div");r.class("sapUiTableVSbHeader");r.openEnd();r.close("div");if(T.hasRowActions(t)){r.openStart("div",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWACTIONHEADER");r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableRowActionHeaderCell");r.openEnd();r.openStart("span");r.openEnd();r.text(T.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));r.close("span");r.close("div");}r.close("div");};
d.renderColRowHdr=function(r,t){var e=false;var s=false;var m=t._getSelectionPlugin().getRenderConfig();r.openStart("div",t.getId()+"-selall");r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableRowSelectionHeaderCell");var g;if(m.headerSelector.visible){var A=T.areAllRowsSelected(t);if(m.headerSelector.type==="toggle"){g=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(m.headerSelector.type==="clear"){g="TBL_DESELECT_ALL";if(!m.headerSelector.enabled){r.class("sapUiTableSelAllDisabled");r.attr("aria-disabled","true");}}if(t._getShowStandardTooltips()&&g){r.attr("title",T.getResourceText(g));}if(!A){r.class("sapUiTableSelAll");}else{s=true;}r.class("sapUiTableSelAllVisible");e=true;}r.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e,checked:s});r.openEnd();if(m.headerSelector.visible){if(m.headerSelector.type==="clear"&&m.headerSelector.icon){r.renderControl(m.headerSelector.icon);}else{r.openStart("div");r.class("sapUiTableSelectAllCheckBox");r.openEnd();r.close("div");}}r.close("div");};
d.renderCol=function(r,t,o,h,n,i,e,g,j){var l,k=!n,m=o.getIndex(),p=o.getMultiLabels();if(p.length>0){l=p[h];}else if(h==0){l=o.getLabel();}var H=o.getId();if(h===0){r.openStart("td",o);}else{H=H+"_"+h;r.openStart("td",H);}r.attr('data-sap-ui-colid',o.getId());r.attr("data-sap-ui-colindex",m);r.attr("tabindex","-1");var A={column:o,headerId:H,index:m};if(n>1){r.attr("colspan",n);A.colspan=true;}if(j){var F=o.getFiltered();var s=o.getSorted();if(F){r.class("sapUiTableColFiltered");}if(s){r.class("sapUiTableColSorted");if(o.getSortOrder()===S.Descending){r.class("sapUiTableColSortedD");}}}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",A);r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableHeaderDataCell");if(t.getEnableColumnReordering()||t.hasListeners("columnSelect")||o._menuHasItems()){r.class("sapUiTableHeaderCellActive");}if(i){r.class("sapUiTableCellFirst");}if(e){r.class("sapUiTableCellLastFixed");}if(g){r.class("sapUiTableCellLast");}if(k){r.class("sapUiTableHidden");}if(t.getColumnHeaderHeight()>0){r.style("height",t.getColumnHeaderHeight()+"px");}var q=o.getTooltip_AsString();if(q){r.attr("title",q);}r.openEnd();r.openStart("div",H+"-inner");r.class("sapUiTableCellInner");var u=o.getHAlign();var v=R.getTextAlign(u);if(v){r.style("text-align",v);}r.openEnd();r.openStart("div");r.style("justify-content",f[u]);r.openEnd();if(l){r.renderControl(l);}r.close("div");r.close("div");r.close("td");};
d.renderColRsz=function(r,t){r.openStart("div",t.getId()+"-rsz");r.class("sapUiTableColRsz");r.openEnd();r.close("div");};
d.renderRowHdr=function(r,t){r.openStart("div",t.getId()+"-sapUiTableRowHdrScr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.class("sapUiTableRowHdrScr");r.class("sapUiTableNoOpacity");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.openEnd();for(var e=0,g=t.getRows().length;e<g;e++){this.renderRowAddon(r,t,t.getRows()[e],e,true);}r.close("div");};
d.renderRowActions=function(r,t){if(!T.hasRowActions(t)&&!T.hasRowNavigationIndicators(t)){return;}r.openStart("div",t.getId()+"-sapUiTableRowActionScr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");T.hasRowActions(t)?r.class("sapUiTableRowWithAction"):r.class("sapUiTableRowActionScr");r.class("sapUiTableNoOpacity");r.openEnd();for(var e=0,g=t.getRows().length;e<g;e++){this.renderRowAddon(r,t,t.getRows()[e],e,false);}r.close("div");};
d.addRowCSSClasses=function(r,t,i){var m=t._getRowCounts();var F=T.getFirstFixedBottomRowIndex(t);if(i===0){r.class("sapUiTableFirstRow");}else if(i===t.getRows().length-1){r.class("sapUiTableLastRow");}if(m.fixedTop>0){if(i==m.fixedTop-1){r.class("sapUiTableRowLastFixedTop");}if(i==m.fixedTop){r.class("sapUiTableRowFirstScrollable");}}if(F>=0&&F===i){r.class("sapUiTableRowFirstFixedBottom");}else if(F>=1&&F-1===i){r.class("sapUiTableRowLastScrollable");}};
d.renderRowAddon=function(r,t,o,i,h){var e=t._getSelectionPlugin().isIndexSelected(o.getIndex());r.openStart("div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i,rowHidden:o.isEmpty()});r.attr("data-sap-ui-related",o.getId());r.attr("data-sap-ui-rowindex",i);r.class("sapUiTableRow");r.class("sapUiTableContentRow");if(o.isContentHidden()){r.class("sapUiTableRowHidden");}else if(e){r.class("sapUiTableRowSel");}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.class("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.openEnd();r.openStart("div",t.getId()+(h?"-rowsel":"-rowact")+i);r.class("sapUiTableCell");r.class("sapUiTableContentCell");r.class(h?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");t._getRowMode().renderRowStyles(r);r.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"ROWHEADER":"ROWACTION",{rowSelected:e,rowHidden:o.isEmpty()});r.openEnd();if(h){this.writeRowHighlightContent(r,t,o,i);this.writeRowSelectorContent(r,t,o,i);}else{var A=o.getRowAction();if(A){r.renderControl(A);}this.writeRowNavigationContent(r,t,o,i);}r.close("div");r.close("div");};
d.renderTableCtrl=function(r,t){if(t.getComputedFixedColumnCount()>0){r.openStart("div",t.getId()+"-sapUiTableCtrlScrFixed");r.class("sapUiTableCtrlScrFixed");r.openEnd();this.renderTableControl(r,t,true);r.close("div");}r.openStart("div",t.getId()+"-sapUiTableCtrlScr");r.class("sapUiTableCtrlScr");if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){r.style("margin-right","0");}else{r.style("margin-left","0");}}r.openEnd();r.openStart("div",t.getId()+"-tableCtrlCnt");r.class("sapUiTableCtrlCnt");r.openEnd();this.renderTableControl(r,t,false);r.close("div");r.close("div");};
d.renderTableControl=function(r,t,F){var s,e;if(F){s=0;e=t.getComputedFixedColumnCount();}else{s=t.getComputedFixedColumnCount();e=t.getColumns().length;}var m=t._getRowCounts();var g=t.getRows();if(m.fixedTop>0){this.renderTableControlCnt(r,t,F,s,e,true,false,0,m.fixedTop);}this.renderTableControlCnt(r,t,F,s,e,false,false,m.fixedTop,g.length-m.fixedBottom);if(m.fixedBottom>0&&g.length>0){this.renderTableControlCnt(r,t,F,s,e,false,true,g.length-m.fixedBottom,g.length);}};
d.renderTableControlCnt=function(r,t,F,s,e,g,h,i,j,H){var k=H?"-header":"-table";var l=t.getId()+k;var m=[];if(F){l+="-fixed";m.push("sapUiTableCtrlFixed");}else{m.push("sapUiTableCtrlScroll");}if(g){l+="-fixrow";m.push("sapUiTableCtrlRowFixed");}else if(h){l+="-fixrow-bottom";m.push("sapUiTableCtrlRowFixedBottom");}else{m.push("sapUiTableCtrlRowScroll");}r.openStart("table",l);m.forEach(function(K){r.class(K);});t._getAccRenderExtension().writeAriaAttributesFor(r,t,H?"COLUMNHEADER_TABLE":"TABLE");r.class("sapUiTableCtrl");if(H){r.class("sapUiTableCHT");}r.style(F?"width":"min-width",t._getColumnsWidth(s,e)+"px");r.openEnd();r.openStart("thead").openEnd();r.openStart("tr");r.class("sapUiTableCtrlCol");if(i==0){r.class("sapUiTableCtrlFirstCol");}if(H){r.class("sapUiTableCHTHR");}r.openEnd();var n=t.getColumns();var o=new Array(e);var p;var q;var u=!F&&e>s;for(p=s;p<e;p++){q=n[p];var v={shouldRender:!!(q&&q.shouldRender())};if(v.shouldRender){var w=q.getWidth();if(T.isVariableWidth(w)){u=false;if(F){q._iFixWidth=q._iFixWidth||160;w=q._iFixWidth+"px";}}else if(F){delete q._iFixWidth;}v.width=w;}o[p]=v;}if(n.length===0){r.openStart("th").openEnd().close("th");}for(p=s;p<e;p++){k=H?"_hdr":"_col";q=n[p];v=o[p];if(v.shouldRender){if(i==0){r.openStart("th",t.getId()+k+p);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:q});}else{r.openStart("th");}r.style("width",v.width);r.attr("data-sap-ui-headcolindex",p);r.attr("data-sap-ui-colid",q.getId());r.openEnd();if(i==0&&T.getHeaderRowCount(t)==0&&!H){if(q.getMultiLabels().length>0){r.renderControl(q.getMultiLabels()[0]);}else{r.renderControl(q.getLabel());}}r.close("th");}}if(u){r.openStart("th",H&&t.getId()+"-dummycolhdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd().close("th");}r.close("tr");r.close("thead");r.openStart("tbody").openEnd();var x=t._getVisibleColumns();var y=t.getRows();var z;var A;if(H){for(z=i,A=j;z<A;z++){this.renderColumnHeaderRow(r,t,z,F,s,e,u,z===A-1);}}else{var B=t._getAccExtension().getAriaTextsForSelectionMode(true);var G=T.isRowSelectionAllowed(t);var J=t.getDragDropConfig().some(function(K){return K.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&K.getSourceAggregation()==="rows";});for(z=i,A=j;z<A;z++){this.renderTableRow(r,t,y[z],z,F,s,e,false,x,u,B,G,J);}}r.close("tbody");r.close("table");};
d.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.openStart("div");r.class("sapUiTableGroupShield");r.openEnd();r.close("div");r.openStart("div",o.getId()+"-groupHeader");r.class("sapUiTableGroupIcon");r.openEnd();r.close("div");if(T.Grouping.showGroupMenuButton(t)){var e=I.getIconInfo("sap-icon://drop-down-list");r.openStart("div").class("sapUiTableGroupMenuButton").openEnd();r.text(e.content);r.close("div");}}};
d.writeRowHighlightContent=function(r,t,o,i){if(!T.hasRowHighlights(t)){return;}var e=o.getAggregation("_settings");var h=e._getHighlightCSSClassName();r.openStart("div",o.getId()+"-highlight");r.class("sapUiTableRowHighlight");r.class(h);r.openEnd();t._getAccRenderExtension().writeAccRowHighlightText(r,t,o,i);r.close("div");};
d.writeRowNavigationContent=function(r,t,o,i){if(!T.hasRowNavigationIndicators(t)){return;}var e=o.getAggregation("_settings");r.openStart("div",o.getId()+"-navIndicator");if(e.getNavigated()){r.class("sapUiTableRowNavigated");}r.openEnd();r.close("div");};
d.renderColumnHeaderRow=function(r,t,i,F,s,e,h,l){r.openStart("tr");r.class("sapUiTableRow");r.class("sapUiTableHeaderRow");r.class("sapUiTableColHdrTr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.openEnd();var g,n=0,j=-1;g=t.getColumns().slice(s,e).filter(function(o){return o&&o.shouldRender();});function k(o,p,q){var u=c.getHeaderSpan(o,i),v;if(n<1){if(u>1){v=o.getIndex();u=q.slice(p+1,p+u).reduce(function(w,x){return x.getIndex()-v<u?w+1:w;},1);}o._nSpan=n=u;j=p;}else{o._nSpan=0;}n--;}g.forEach(k);function m(o,p){this.renderCol(r,t,o,i,o._nSpan,p===0,F&&(p==j),!F&&(p==j),o._nSpan===1&&!o._bIconsRendered);o._bIconsRendered=o._bIconsRendered||o._nSpan===1;delete o._nSpan;if(l){delete o._bIconsRendered;}}g.forEach(m.bind(this));if(!F&&h&&g.length>0){r.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd().close("td");}r.close("tr");};
d.renderTableRow=function(r,t,o,i,F,s,e,g,v,h,m,j,k){if(!o){return;}var l=t._getSelectionPlugin();if(F){r.openStart("tr",o.getId()+"-fixed");r.attr("data-sap-ui-related",o.getId());}else{r.openStart("tr",o);}if(o._bDummyRow){r.style("opacity","0");}r.class("sapUiTableRow");r.class("sapUiTableContentRow");r.class("sapUiTableTr");if(o.isContentHidden()){r.class("sapUiTableRowHidden");}else{if(k&&F){r.attr("draggable",true);}if(l.isIndexSelected(o.getIndex())){r.class("sapUiTableRowSel");}}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.class("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.attr("data-sap-ui-rowindex",i);t._getRowMode().renderRowStyles(r);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i,rowHidden:o.isEmpty()});r.openEnd();var n=!o.isEmpty()&&l.isIndexSelected(o.getIndex());var p=o.getCells();for(var q=0,u=p.length;q<u;q++){this.renderTableCell(r,t,o,p[q],q,F,s,e,v,n);}if(!F&&h&&p.length>0){r.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd();r.close("td");}r.close("tr");};
d.renderTableCell=function(r,t,o,e,i,F,s,g,v,h){var j=b.ofCell(e);var k=j.getIndex();var l=t.getColumns()[c.getFixedColumnCount(t,true)-1];if(j.shouldRender()&&s<=k&&g>k){var m=o.getId()+"-col"+i;r.openStart("td",m);r.attr("tabindex","-1");r.attr("data-sap-ui-colid",j.getId());var n=v.length;var p=n>0&&v[0]===j;var q=n>0&&v[n-1]===j;var u=F&l===j;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:k,column:j,row:o,fixed:F,rowSelected:h});var w=R.getTextAlign(j.getHAlign());if(w){r.style("text-align",w);}r.class("sapUiTableCell");r.class("sapUiTableContentCell");r.class("sapUiTableDataCell");if(p){r.class("sapUiTableCellFirst");}if(u){r.class("sapUiTableCellLastFixed");}if(q){r.class("sapUiTableCellLast");}if(p&&T.Grouping.isTreeMode(t)){r.class("sapUiTableCellFlex");}r.openEnd();r.openStart("div");r.class("sapUiTableCellInner");t._getRowMode().renderCellContentStyles(r);r.openEnd();this.renderTableCellControl(r,t,e,p);r.close("div");r.close("td");}};
d.renderTableCellControl=function(r,t,o,i){if(i&&T.Grouping.isTreeMode(t)&&!t._bFlatMode){var e=o.getParent();r.openStart("span",e.getId()+"-treeicon");r.class("sapUiTableTreeIcon");r.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:e});r.openEnd();r.close("span");}r.renderControl(o);};
d.renderVSb=function(r,t,m){m=Object.assign({cssClass:"sapUiTableVSb",tabIndex:true,hidden:true},m);m.id=t.getId()+"-vsb";var s=t._getScrollExtension();r.openStart("div",m.id);r.class(m.cssClass);if(m.hidden){r.class("sapUiTableHidden");}if(m.tabIndex){r.attr("tabindex","-1");}r.style("max-height",s.getVerticalScrollbarHeight()+"px");var e=t._getRowCounts();if(e.fixedTop>0){t._iVsbTop=e.fixedTop*t._getBaseRowHeight()-1;r.style("top",t._iVsbTop+'px');}r.openEnd();r.openStart("div",m.id+"-content");r.class("sapUiTableVSbContent");r.style("height",s.getVerticalScrollHeight()+"px");r.openEnd();r.close("div");r.close("div");};
d.renderVSbExternal=function(r,t){if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderVSb(r,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};
d.renderVSbBackground=function(r,t){r.openStart("div",t.getId()+"-vsb-bg");r.class("sapUiTableVSbBg");r.openEnd().close("div");};
d.renderHSb=function(r,t,m){m=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},m);r.openStart("div",m.id);r.class(m.cssClass);if(m.hidden){r.class("sapUiTableHidden");}if(m.tabIndex){r.attr("tabindex","-1");}r.openEnd();r.openStart("div",m.id+"-content");r.class("sapUiTableHSbContent");if(m.scrollWidth>0){r.style("width",m.scrollWidth+"px");}r.openEnd();r.close("div");r.close("div");};
d.renderHSbExternal=function(r,t,i,s){if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderHSb(r,t,{id:i,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:s});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};
d.renderHSbBackground=function(r,t){r.openStart("div",t.getId()+"-hsb-bg");r.class("sapUiTableHSbBg");r.openEnd().close("div");};
d.renderTabElement=function(r,s){r.openStart("div");if(s){r.class(s);}r.attr("tabindex","0");r.openEnd().close("div");};
return d;},true);
sap.ui.predefine('sap/ui/table/TreeTable',['./Table',"./TableRenderer",'sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./library','sap/ui/core/Element','./utils/TableUtils',"./plugins/BindingSelection","sap/base/Log","sap/base/assert"],function(T,a,C,b,l,E,c,B,L,d){"use strict";
var e=T.extend("sap.ui.table.TreeTable",{
metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false,deprecated:true},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},rootLevel:{type:"int",group:"Data",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},
renderer:"sap.ui.table.TableRenderer"
});
e.prototype.init=function(){T.prototype.init.apply(this,arguments);c.Grouping.setTreeMode(this);c.Hook.register(this,c.Hook.Keys.Row.UpdateState,this._updateRowState,this);};
e.prototype._bindRows=function(o){if(!o.parameters){o.parameters={};}if(!("rootLevel"in o.parameters)){o.parameters.rootLevel=this.getRootLevel();}if(!("collapseRecursive"in o.parameters)){o.parameters.collapseRecursive=this.getCollapseRecursive();}if(!("numberOfExpandedLevels"in o.parameters)){o.parameters.numberOfExpandedLevels=this.getExpandFirstLevel()?1:0;}return T.prototype._bindRows.call(this,o);};
e.prototype._updateRowState=function(s){var o=this.getBinding("rows");var n=s.context;s.context=n.context;if(!s.context){return;}s.level=n.level+1;if(o.nodeHasChildren){s.expandable=o.nodeHasChildren(n);}else{s.expandable=o.hasChildren(n.context);}s.expanded=n.nodeState.expanded;if(c.Grouping.isGroupMode(this)){var h=this.getGroupHeaderProperty();if(h){s.title=s.context.getProperty(h);}if(s.expandable){s.type=s.Type.GroupHeader;s.contentHidden=true;}}};
e.prototype.setFixedRowCount=function(r){L.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};
e.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return E.prototype.isTreeBinding.apply(this,arguments);};
e.prototype.getBinding=function(n){n=n||"rows";var o=E.prototype.getBinding.call(this,n);if(o&&n==="rows"&&!o.getLength){if(o.isA("sap.ui.model.odata.ODataTreeBinding")){b(o,this);}else if(o.isA("sap.ui.model.odata.v2.ODataTreeBinding")){o.applyAdapterInterface();}else if(o.isA("sap.ui.model.ClientTreeBinding")){C.apply(o);}else{L.error("Binding not supported by sap.ui.table.TreeTable");}}return o;};
e.prototype._getContexts=function(s,i,t){var o=this.getBinding("rows");if(o){return o.getNodes(s,i,t);}else{return[];}};
e.prototype._getRowContexts=function(){var o=this._getTotalRowCount();var r=T.prototype._getRowContexts.apply(this,arguments);var n=this._getTotalRowCount();if(c.isVariableRowHeightEnabled(this)&&o!==n){return T.prototype._getRowContexts.apply(this,arguments);}return r;};
e.prototype._onGroupHeaderChanged=function(r,f){this.fireToggleOpenState({rowIndex:r,rowContext:this.getContextByIndex(r),expanded:f});};
e.prototype.expand=function(r){c.Grouping.toggleGroupHeader(this,r,true);return this;};
e.prototype.collapse=function(r){c.Grouping.toggleGroupHeader(this,r,false);return this;};
e.prototype.collapseAll=function(){var o=this.getBinding("rows");if(o){o.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
e.prototype.expandToLevel=function(i){var o=this.getBinding("rows");d(o&&o.expandToLevel,"TreeTable.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.");if(o&&o.expandToLevel){o.expandToLevel(i);}return this;};
e.prototype.isExpanded=function(r){var o=this.getBinding("rows");if(o){return o.isExpanded(r);}return false;};
e.prototype.getContextByIndex=function(r){var o=this.getBinding("rows");if(o){return o.getContextByIndex(r);}};
e.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var o=this.getBinding("rows");if(o){d(o.setRootLevel,"rootLevel is not supported by the used binding");if(o.setRootLevel){o.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};
e.prototype.setCollapseRecursive=function(f){var o=this.getBinding("rows");if(o){d(o.setCollapseRecursive,"Collapse Recursive is not supported by the used binding");if(o.setCollapseRecursive){o.setCollapseRecursive(f);}}this.setProperty("collapseRecursive",!!f,true);return this;};
e.prototype.setUseGroupMode=function(g){this.setProperty("useGroupMode",!!g);if(!!g){c.Grouping.setGroupMode(this);}else{c.Grouping.setTreeMode(this);}return this;};
e.prototype.setEnableGrouping=function(){L.warning("The property enableGrouping is not supported by the sap.ui.table.TreeTable control");return this;};
e.prototype.setGroupBy=function(){L.warning("The groupBy association is not supported by the sap.ui.table.TreeTable control");return this;};
e.prototype.setUseFlatMode=function(f){f=!!f;if(f!=this._bFlatMode){this._bFlatMode=f;if(this.getDomRef()&&c.Grouping.isTreeMode(this)){this.invalidate();}}return this;};
e.prototype._createLegacySelectionPlugin=function(){return new B();};
return e;});
sap.ui.predefine('sap/ui/table/TreeTableRenderer',['sap/ui/table/TreeTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/extensions/Accessibility',["./ExtensionBase","./AccessibilityRender","../utils/TableUtils","../library","sap/ui/core/Control","sap/ui/Device","sap/ui/thirdparty/jquery"],function(E,A,T,l,C,D,q){"use strict";var S=l.SelectionMode;var a=T.CELLTYPE;var b={getAccInfoOfControl:function(o){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return b._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};b._flatten(s,t);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,L){L=L?L:0;b._normalize(s);if(L==0){b._normalize(t);t._descriptions=[];}t._descriptions.push(b._getFullDescription(s));s.children.forEach(function(o){if(!o.getAccessibilityInfo||(o.getVisible&&!o.getVisible())){return;}var e=o.getAccessibilityInfo();if(e){b._flatten(e,t,L+1);}});if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i){var s=i.type+" "+i.description;if(i.enabled===false){s=s+" "+T.getResourceText("TBL_CTRL_STATE_DISABLED");}else if(i.editable===false){s=s+" "+T.getResourceText("TBL_CTRL_STATE_READONLY");}return s.trim();}};var c={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();var i=T.getFocusedItemInfo(t);return i.cellInRow-(T.hasRowHeader(t)?1:0);},getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var f=i.getFocusedDomRef();if(!f||f!==document.activeElement){return null;}return T.getCellInfo(f);},getRelevantColumnHeaders:function(t,o){if(!t||!o){return[];}var h=T.getHeaderRowCount(t),s=o.getId(),L=[s];if(h>1){for(var i=1;i<h;i++){L.push(s+"_"+i);}var e=T.Column.getParentSpannedColumns(t,s);if(e&&e.length){for(var i=0;i<e.length;i++){var f=e[i].level;var p=e[i].column.getId();L[f]=f===0?p:(p+"_"+f);}}}return L;},isHiddenCell:function($,o){var g=T.Grouping.isInGroupHeaderRow($);var s=T.Grouping.isInSummaryRow($);var e=!!o&&!!o.hasStyleClass;var i=$.parent().hasClass("sapUiTableRowHidden");var I=$.hasClass("sapUiTableCellHidden");var G=g&&e&&o.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var f=s&&e&&o.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return i||I||G||f;},isTreeColumnCell:function(e,$){return T.Grouping.isTreeMode(e.getTable())&&$.hasClass("sapUiTableCellFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,f=false,g=false;if(i){var h=c.getColumnIndexOfFocusedCell(e)+1;var r=T.getRowIndexOfFocusedCell(t)+t._getFirstRenderedRowIndex()+1;var j=T.getVisibleColumnCount(t)+(T.hasRowActions(t)?1:0);var R=T.isNoDataVisible(t)?0:T.getTotalRowCount(t,true);I=e._iLastRowNumber!=r||(e._iLastRowNumber==r&&e._iLastColumnNumber==h);f=e._iLastColumnNumber!=h;g=e._iLastRowNumber==null&&e._iLastColumnNumber==null;t.$("rownumberofrows").text(I?T.getResourceText("TBL_ROW_ROWCOUNT",[r,R]):" ");t.$("colnumberofcols").text(f?T.getResourceText("TBL_COL_COLCOUNT",[h,j]):" ");t.$("ariacount").text(g?T.getResourceText("TBL_DATA_ROWS_COLS",[R,j]):" ");e._iLastRowNumber=r;e._iLastColumnNumber=h;}return{rowChange:I,colChange:f,initial:g};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,f,g){e._cleanupInfo={cell:$,attr:{"aria-labelledby":f&&f.length?f.join(" "):null,"aria-describedby":g&&g.length?g.join(" "):null}};},performCellModifications:function(e,$,f,g,L,h,t,i){c.storeDefaultsBeforeCellModifications(e,$,f,g);var o=c.updateRowColCount(e);var j=e.getTable();j.$("cellacc").text(t||" ");if(i){i(L,h,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){s=j.getId()+"-ariacount";if(j.getSelectionMode()!==S.None){s=s+" "+j.getId()+"-ariaselection";}}if(L&&L.length){s=s+" "+L.join(" ");}if(o.initial||o.rowChange){if(T.hasRowNavigationIndicators(j)){var k=T.getCellInfo($);if(k.type!==T.CELLTYPE.COLUMNHEADER&&k.type!==T.CELLTYPE.COLUMNROWHEADER){var r=j.getRows()[k.rowIndex].getAggregation("_settings");if(r.getNavigated()){s=s+" "+j.getId()+"-rownavigatedtext";}}}}$.attr({"aria-labelledby":s?s:null,"aria-describedby":h&&h.length?h.join(" "):null});},modifyAccOfDATACELL:function(o){var t=this.getTable();var s=t.getId();var i=t._getItemNavigation();var $=o.cell;if(!i){return;}var r=T.getRowIndexOfFocusedCell(t),e=c.getColumnIndexOfFocusedCell(this),f=T.getRowColCell(t,r,e,false),I=null,R=f.row,h=c.isHiddenCell($,f.cell),g=c.isTreeColumnCell(this,$),j=c.getAriaAttributesFor(this,d.ELEMENTTYPES.DATACELL,{index:e,column:f.column,fixed:T.isFixedColumn(t,e)})["aria-labelledby"]||[],k=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"],m=R.isGroupHeader(),n=R.isSummary();if(m){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}else if(R.isTotalSummary()){L.push(s+"-ariagrandtotallabel");}else if(R.isGroupSummary()){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(T.hasRowHighlights(t)&&!m&&!n){L.push(R.getId()+"-highlighttext");}L=L.concat(j);if(!h){I=b.getAccInfoOfControl(f.cell);L.push(I?(s+"-cellacc"):f.cell.getId());if(T.getInteractiveElements($)!==null){L.push(s+"-toggleedit");}if(T.Grouping.isTreeMode(t)&&$.parent().attr("aria-selected")==="true"){L.push(s+"-ariarowselected");}}var p=I?I.description:" ";if(g&&!h){var u=c.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:f.row});if(u&&u["aria-label"]){p=u["aria-label"]+" "+p;}}c.performCellModifications(this,$,j,null,L,k,p,function(L,k,v,w,x){var y=$.find(".sapUiTableTreeIcon").not(".sapUiTableTreeIconLeaf").length==1;if((y||m)&&(v||w)){k.push(t.getId()+(!R.isExpanded()?"-rowexpandtext":"-rowcollapsetext"));}else if(!h&&!m&&!n&&T.isRowSelectionAllowed(t)&&v){L.push(R.getId()+"-rowselecttext");}});},modifyAccOfROWHEADER:function(o){var t=this.getTable();var s=t.getId();var $=o.cell;var r=t.getRows()[o.rowIndex];var e=c.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[];var L=e.concat([s+"-rownumberofrows"]);if(!r.isSummary()&&!r.isGroupHeader()){if(!r.isContentHidden()){L.push(r.getId()+"-rowselecttext");if(T.hasRowHighlights(t)){L.push(r.getId()+"-highlighttext");}}}if(r.isGroupHeader()){L.push(s+"-ariarowgrouplabel");L.push(s+(r.isExpanded()?"-rowcollapsetext":"-rowexpandtext"));}if(r.isTotalSummary()){L.push(s+"-ariagrandtotallabel");}else if(r.isGroupSummary()){L.push(s+"-ariagrouptotallabel");}c.performCellModifications(this,$,e,null,L,null,null);},modifyAccOfCOLUMNHEADER:function(o){var t=this.getTable();var $=o.cell;var e=sap.ui.getCore().byId($.attr("data-sap-ui-colid"));var m=c.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:e,index:$.attr("data-sap-ui-colindex")});var s=c.getColumnTooltip(e);var L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]);var i=o.columnSpan;if(i>1){L.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(T.getResourceText("TBL_COL_DESC_SPAN",[""+i]));}if(s){L.push(t.getId()+"-cellacc");}if(D.browser.msie){if(i<=1&&e&&e.getSorted()){L.push(t.getId()+(e.getSortOrder()==="Ascending"?"-ariacolsortedasc":"-ariacolsorteddes"));}}if(i<=1&&e&&e.getFiltered()){L.push(t.getId()+"-ariacolfiltered");}if(D.browser.msie){if(i<=1&&$.attr("aria-haspopup")==="true"){L.push(t.getId()+"-ariacolmenu");}}c.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function(o){var t=this.getTable();var $=o.cell;var e=$.hasClass("sapUiTableSelAllVisible");var m=c.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNROWHEADER,{enabled:e,checked:e&&!t.$().hasClass("sapUiTableSelAll")});c.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],m["aria-labelledby"],m["aria-describedby"],null);},modifyAccOfROWACTION:function(o){var t=this.getTable();var s=t.getId();var $=o.cell;var r=o.rowIndex;var R=t.getRows()[o.rowIndex];var h=c.isHiddenCell($);var e=c.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWACTION)["aria-labelledby"]||[];var L=[s+"-rownumberofrows",s+"-colnumberofcols"].concat(e);var f=[];if(R.isGroupHeader()){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");L.push(s+(R.isExpanded()?"-rowcollapsetext":"-rowexpandtext"));}if(R.isTotalSummary()){L.push(s+"-ariagrandtotallabel");}else if(R.isGroupSummary()){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(!R.isSummary()&&!R.isGroupHeader()&&$.attr("aria-selected")==="true"){L.push(s+"-ariarowselected");}if(T.hasRowHighlights(t)&&!R.isGroupHeader()&&!R.isSummary()){L.push(R.getId()+"-highlighttext");}var g="";if(!h){var i=R.getRowAction();if(i){var I=i.getAccessibilityInfo();if(I){L.push(s+"-cellacc");g=I.description;if(T.getInteractiveElements($)!==null){f.push(s+"-toggleedit");}}}}c.performCellModifications(this,$,e,[],L,f,g);},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function f(o,x,O,y){var M="";if(O&&y){M="overlay,nodata";}else if(O&&!y){M="overlay";}else if(!O&&y){M="nodata";}var z=false;if(O&&o.getShowOverlay()||y&&T.isNoDataVisible(o)){z=true;}if(z){m["aria-hidden"]="true";}if(M){m["data-sap-ui-table-acc-covered"]=M;}}switch(t){case d.ELEMENTTYPES.COLUMNROWHEADER:m["aria-labelledby"]=[s+"-ariacolrowheaderlabel"];var r=o._getSelectionPlugin().getRenderConfig();if(r.headerSelector.visible){if(r.headerSelector.type==="toggle"){m["role"]=["checkbox"];if(p&&p.enabled){m["aria-checked"]=p.checked?"true":"false";}}else if(r.headerSelector.type==="clear"){m["role"]=["button"];if(!p||!p.enabled){m["aria-disabled"]="true";}}}if(!o._getShowStandardTooltips()&&r.headerSelector.type==="toggle"){m["aria-labelledby"].push(s+"-ariaselectall");}break;case d.ELEMENTTYPES.ROWHEADER:m["role"]="rowheader";if(D.browser.msie){m["aria-labelledby"]=[s+"-ariarowheaderlabel"];}break;case d.ELEMENTTYPES.ROWACTION:m["role"]="gridcell";m["aria-labelledby"]=[s+"-rowacthdr"];break;case d.ELEMENTTYPES.COLUMNHEADER:var g=p&&p.column;var h=p&&p.colspan;m["role"]="columnheader";var L=[];if(p&&p.headerId){var H=c.getRelevantColumnHeaders(o,g);var I=H.indexOf(p.headerId);L=I>0?H.slice(0,I+1):[p.headerId];}for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}m["aria-labelledby"]=L;if(p&&(p.index<o.getComputedFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(!h&&g&&g.getSorted()){m["aria-sort"]=g.getSortOrder()==="Ascending"?"ascending":"descending";}if(!h&&g&&g._menuHasItems()){m["aria-haspopup"]="true";}break;case d.ELEMENTTYPES.DATACELL:m["role"]="gridcell";var L=[],g=p&&p.column?p.column:null;if(g){L=c.getRelevantColumnHeaders(o,g);m["headers"]=L.join(" ");for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}}m["aria-labelledby"]=L;break;case d.ELEMENTTYPES.ROOT:break;case d.ELEMENTTYPES.TABLE:m["role"]="presentation";f(o,m,true,true);break;case d.ELEMENTTYPES.CONTAINER:m["role"]="application";break;case d.ELEMENTTYPES.CONTENT:m["role"]=T.Grouping.isGroupMode(o)||T.Grouping.isTreeMode(o)?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===S.MultiToggle){m["aria-multiselectable"]="true";}var R=o._getRowCounts();var j=T.hasFixedColumns(o);var k=R.fixedTop>0;var n=R.fixedBottom>0;var u=T.hasRowHeader(o);var v=T.hasRowActions(o);m["aria-owns"]=[s+"-table"];if(j){m["aria-owns"].push(s+"-table-fixed");}if(k){m["aria-owns"].push(s+"-table-fixrow");if(j){m["aria-owns"].push(s+"-table-fixed-fixrow");}}if(n){m["aria-owns"].push(s+"-table-fixrow-bottom");if(j){m["aria-owns"].push(s+"-table-fixed-fixrow-bottom");}}if(u){m["aria-owns"].push(s+"-sapUiTableRowHdrScr");}if(v){m["aria-owns"].push(s+"-sapUiTableRowActionScr");}break;case d.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";m["aria-level"]="2";f(o,m,true,false);break;case d.ELEMENTTYPES.COLUMNHEADER_TBL:m["role"]="presentation";break;case d.ELEMENTTYPES.COLUMNHEADER_ROW:m["role"]="row";f(o,m,true,false);break;case d.ELEMENTTYPES.CREATIONROW_TBL:m["role"]="presentation";break;case d.ELEMENTTYPES.CREATIONROW:m["role"]="form";m["aria-labelledby"]=p.creationRow.getId()+"-label";f(o,m,true,false);break;case d.ELEMENTTYPES.ROWHEADER_COL:f(o,m,true,true);break;case d.ELEMENTTYPES.TH:m["role"]="presentation";m["scope"]="col";m["aria-hidden"]="true";break;case d.ELEMENTTYPES.TR:m["role"]="row";break;case d.ELEMENTTYPES.TREEICON:if(T.Grouping.isTreeMode(o)){m={"aria-label":"","title":"","role":""};if(o.getBinding("rows")){if(p&&p.row){if(p.row.isExpandable()){var w=T.getResourceText(p.row.isExpanded()?"TBL_COLLAPSE":"TBL_EXPAND");if(o._getShowStandardTooltips()){m["title"]=w;}else{m["aria-label"]=w;}m["aria-expanded"]=""+(!!p.row.isExpanded());m["aria-hidden"]="false";m["role"]="button";}else{m["aria-label"]=T.getResourceText("TBL_LEAF");m["aria-hidden"]="true";}}}}break;case d.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];f(o,m,true,false);break;case d.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case d.ELEMENTTYPES.TABLEFOOTER:case d.ELEMENTTYPES.TABLESUBHEADER:f(o,m,true,false);break;case d.ELEMENTTYPES.ROWACTIONHEADER:m["aria-hidden"]="true";break;case"PRESENTATION":m["role"]="presentation";break;}return m;}};
var d=E.extend("sap.ui.table.extensions.Accessibility",{
_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._busyCells=[];T.addDelegate(t,this);E.enrich(t,A);return"AccExtension";},
_debug:function(){this._ExtensionHelper=c;this._ACCInfoHelper=b;},
destroy:function(){this.getTable().removeEventDelegate(this);this._busyCells=[];E.prototype.destroy.apply(this,arguments);},
getAriaAttributesFor:function(t,p){return c.getAriaAttributesFor(this,t,p);},
onfocusin:function(e){var t=this.getTable();if(!t||T.getCellInfo(e.target).cell==null){return;}if(t._mTimeouts._cleanupACCExtension){clearTimeout(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell("Focus");},
onfocusout:function(e){var t=this.getTable();if(!t){return;}t._mTimeouts._cleanupACCExtension=setTimeout(function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;c.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;}.bind(this),100);}
});
d.ELEMENTTYPES={DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",ROWACTION:"ROWACTION",COLUMNROWHEADER:"COLUMNROWHEADER",ROOT:"ROOT",CONTAINER:"CONTAINER",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_TBL:"COLUMNHEADER_TABLE",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",CREATIONROW_TBL:"CREATIONROW_TABLE",CREATIONROW:"CREATIONROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",TR:"TR",TREEICON:"TREEICON",ROWACTIONHEADER:"ROWACTIONHEADER",NODATA:"NODATA",OVERLAY:"OVERLAY"};
d.prototype.getAccMode=function(){return this._accMode;};
d.prototype.updateAccForCurrentCell=function(r){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}if(r==="Focus"||r===T.RowsUpdateReason.Expand||r===T.RowsUpdateReason.Collapse){c.cleanupCellModifications(this);}var t=this.getTable();var I=c.getInfoOfFocusedCell(this);var s;if(!I||!I.isOfType(a.ANY)){return;}if(I.isOfType(a.DATACELL)){s=d.ELEMENTTYPES.DATACELL;}else if(I.isOfType(a.COLUMNHEADER)){s=d.ELEMENTTYPES.COLUMNHEADER;}else if(I.isOfType(a.ROWHEADER)){s=d.ELEMENTTYPES.ROWHEADER;}else if(I.isOfType(a.ROWACTION)){s=d.ELEMENTTYPES.ROWACTION;}else if(I.isOfType(a.COLUMNROWHEADER)){s=d.ELEMENTTYPES.COLUMNROWHEADER;}if(!c["modifyAccOf"+s]){return;}if(r!=="Focus"&&r!==T.RowsUpdateReason.Expand&&r!==T.RowsUpdateReason.Collapse){if(I.isOfType(a.DATACELL|a.ROWHEADER|a.ROWACTION)){if(D.browser.msie){if(t._mTimeouts._cleanupACCCellBusy){clearTimeout(t._mTimeouts._cleanupACCCellBusy);t._mTimeouts._cleanupACCCellBusy=null;}t._mTimeouts._cleanupACCCellBusy=setTimeout(function(){for(var i=0;i<this._busyCells.length;i++){this._busyCells[i].removeAttr("aria-hidden");this._busyCells[i].removeAttr("aria-busy");}t._mTimeouts._cleanupACCCellBusy=null;this._busyCells=[];}.bind(this),100);I.cell.attr("aria-busy","true");this._busyCells.push(I.cell);}else{I.cell.attr("role","status");I.cell.attr("role","gridcell");}}else{return;}}c["modifyAccOf"+s].apply(this,[I]);};
d.prototype.updateAriaStateOfColumn=function(o){if(!this._accMode){return;}var m=c.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});var h=c.getRelevantColumnHeaders(this.getTable(),o);for(var i=0;i<h.length;i++){var H=q(document.getElementById(h[i]));if(!H.attr("colspan")){H.attr({"aria-sort":m["aria-sort"]||null});}}};
d.prototype.updateRowTooltips=function(r,R,t,s){if(!this._accMode){return;}var o=this.getTable();var e=!r.isEmpty()&&!r.isGroupHeader()&&!r.isSummary()&&o._getShowStandardTooltips();if(R.row){if(e&&T.isRowSelectionAllowed(o)&&!R.row.hasClass("sapUiTableRowHidden")){R.row.attr("title",t.mouse[s]);}else{R.row.removeAttr("title");}}if(R.rowSelector){if(e&&T.isRowSelectorSelectionAllowed(o)){R.rowSelector.attr("title",t.mouse[s]);}else{R.rowSelector.removeAttr("title");}}if(R.rowScrollPart){var $=R.rowScrollPart.add(R.rowFixedPart).add(R.rowActionPart);if(e&&T.isRowSelectionAllowed(o)){$.attr("title",t.mouse[s]);}else{$.removeAttr("title");}}};
d.prototype.updateSelectionStateOfRow=function(r){if(!this._accMode){return;}var R=r.getDomRefs(true);var t=this.getAriaTextsForSelectionMode(true);var o=this.getTable();var i=o._getSelectionPlugin().isIndexSelected(r.getIndex());var s="rowSelect";if(i){s="rowDeselect";}this.updateRowTooltips(r,R,t,s);if(!r.isEmpty()&&!r.isGroupHeader()&&!r.isSummary()){if(R.row){R.row.add(R.row.children(".sapUiTableCell")).attr("aria-selected",i?"true":"false");}if(R.rowSelectorText){var e=t.keyboard[s];if(i){e=T.getResourceText("TBL_ROW_DESC_SELECTED")+" "+e;}R.rowSelectorText.text(e);}}};
d.prototype.updateAriaExpandAndLevelState=function(r){if(!this._accMode){return;}var o=r.getDomRefs(true);var t=o.row.find(".sapUiTableTreeIcon");if(o.rowHeaderPart){o.rowHeaderPart.attr({"aria-haspopup":r.isGroupHeader()?"true":null});}o.row.attr({"aria-expanded":r.isExpandable()?r.isExpanded()+"":null,"aria-level":r.getLevel()});if(t){t.attr(c.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:r}));}};
d.prototype.updateAriaStateOfRowHighlight=function(r){if(!this._accMode||!r){return;}var R=r._getRow();var h=R?R.getDomRef("highlighttext"):null;if(h){h.innerText=r._getHighlightText();}};
d.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(T.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};
d.prototype.getAriaTextsForSelectionMode=function(e,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var f=t._getShowStandardTooltips();var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectionPlugin().getSelectedCount();if(s===S.Single){m.mouse.rowSelect=f?T.getResourceText("TBL_ROW_SELECT"):"";m.mouse.rowDeselect=f?T.getResourceText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=T.getResourceText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=T.getResourceText("TBL_ROW_DESELECT_KEY");}else if(s===S.MultiToggle){m.mouse.rowSelect=f?T.getResourceText("TBL_ROW_SELECT_MULTI_TOGGLE"):"";m.mouse.rowDeselect=f?T.getResourceText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=T.getResourceText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=T.getResourceText("TBL_ROW_DESELECT_KEY");if(e===true&&i===0){m.mouse.rowSelect=f?T.getResourceText("TBL_ROW_SELECT"):"";}}return m;};
d.prototype.setSelectAllState=function(s){var t=this.getTable();if(this._accMode&&t){t.$("selall").attr("aria-checked",s?"true":"false");}};
d.prototype.addColumnHeaderLabel=function(o,e){var t=this.getTable();if(!this._accMode||!e.getAriaLabelledBy||!t){return;}var L=t.getColumnHeaderVisible()?o.getId():null;if(!L){var f=o.getAggregation("label");if(f){L=f.getId();}}var g=e.getAriaLabelledBy();if(L&&g.indexOf(L)<0){e.addAriaLabelledBy(L);}};
return d;});
sap.ui.predefine('sap/ui/table/extensions/AccessibilityRender',["./ExtensionBase","../utils/TableUtils","../library"],function(E,T,l){"use strict";var S=l.SelectionMode;var _=function(r,p,i,t,c){c=c||[];c.push("sapUiInvisibleText");r.openStart("span",p+"-"+i);c.forEach(function(C){r.class(C);});r.attr("aria-hidden","true");r.openEnd();if(t){r.text(t);}r.close("span");};
var A=E.extend("sap.ui.table.extensions.AccessibilityRender",{
_init:function(t,s,m){return"AccRenderExtension";},
writeHiddenAccTexts:function(r,t){if(!t._getAccExtension().getAccMode()){return;}var s=t.getId();r.openStart("div");r.class("sapUiTableHiddenTexts");r.style("display","none");r.attr("aria-hidden","true");r.openEnd();_(r,s,"ariacount");_(r,s,"toggleedit",T.getResourceText("TBL_TOGGLE_EDIT_KEY"));var a=T.areAllRowsSelected(t);var R=t._getSelectionPlugin().getRenderConfig();var b;if(R.headerSelector.type==="toggle"){b=a?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(R.headerSelector.type==="clear"){b="TBL_DESELECT_ALL";}_(r,s,"ariaselectall",T.getResourceText(b));_(r,s,"ariarowheaderlabel",T.getResourceText("TBL_ROW_HEADER_LABEL"));_(r,s,"ariarowgrouplabel",T.getResourceText("TBL_ROW_GROUP_LABEL"));_(r,s,"ariagrandtotallabel",T.getResourceText("TBL_GRAND_TOTAL_ROW"));_(r,s,"ariagrouptotallabel",T.getResourceText("TBL_GROUP_TOTAL_ROW"));_(r,s,"ariacolrowheaderlabel",T.getResourceText("TBL_ROW_COL_HEADER_LABEL"));_(r,s,"rownumberofrows");_(r,s,"colnumberofcols");_(r,s,"cellacc");_(r,s,"ariarowselected",T.getResourceText("TBL_ROW_DESC_SELECTED"));_(r,s,"ariacolmenu",T.getResourceText("TBL_COL_DESC_MENU"));_(r,s,"ariacolspan");_(r,s,"ariacolfiltered",T.getResourceText("TBL_COL_DESC_FILTERED"));_(r,s,"ariacolsortedasc",T.getResourceText("TBL_COL_DESC_SORTED_ASC"));_(r,s,"ariacolsorteddes",T.getResourceText("TBL_COL_DESC_SORTED_DES"));_(r,s,"ariainvalid",T.getResourceText("TBL_TABLE_INVALID"));_(r,s,"ariashowcolmenu",T.getResourceText("TBL_COL_VISBILITY_MENUITEM_SHOW"));_(r,s,"ariahidecolmenu",T.getResourceText("TBL_COL_VISBILITY_MENUITEM_HIDE"));_(r,s,"rowexpandtext",T.getResourceText("TBL_ROW_EXPAND_KEY"));_(r,s,"rowcollapsetext",T.getResourceText("TBL_ROW_COLLAPSE_KEY"));var o=t.getSelectionMode();if(o!==S.None){_(r,s,"ariaselection",T.getResourceText(o==S.MultiToggle?"TBL_TABLE_SELECTION_MULTI":"TBL_TABLE_SELECTION_SINGLE"));}if(t.getComputedFixedColumnCount()>0){_(r,s,"ariafixedcolumn",T.getResourceText("TBL_FIXED_COLUMN"));}if(T.hasRowNavigationIndicators(t)){_(r,s,"rownavigatedtext",T.getResourceText("TBL_ROW_STATE_NAVIGATED"));}r.close("div");},
writeAriaAttributesFor:function(r,t,s,p){var e=t._getAccExtension();if(!e.getAccMode()){return;}var a=e.getAriaAttributesFor(s,p);var v,k;for(k in a){v=a[k];if(Array.isArray(v)){v=v.join(" ");}if(v){r.attr(k.toLowerCase(),v);}}},
writeAccRowSelectorText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var I=t._getSelectionPlugin().isIndexSelected(i);var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var s=m.keyboard[I?"rowDeselect":"rowSelect"];_(r,R.getId(),"rowselecttext",R.isEmpty()?"":s,["sapUiTableAriaRowSel"]);},
writeAccRowHighlightText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var o=R.getAggregation("_settings");var h=o._getHighlightText();_(r,R.getId(),"highlighttext",h);},
writeAccCreationRowText:function(r,t,c){if(!t._getAccExtension().getAccMode()){return;}_(r,c.getId(),"label",T.getResourceText("TBL_CREATEROW_LABEL"));}
});
return A;});
sap.ui.predefine('sap/ui/table/extensions/DragAndDrop',["./ExtensionBase","../utils/TableUtils","sap/ui/core/library"],function(E,T,C){"use strict";var S="sap.ui.table";var D=C.dnd.DropPosition;var a={getSessionData:function(d,k){return d.getComplexData(S+(k==null?"":"-"+k));},setSessionData:function(d,s,k){d.setComplexData(S+(k==null?"":"-"+k),s);},getInstanceSessionData:function(d,t){return this.getSessionData(d,t.getId());},setInstanceSessionData:function(d,t,s){this.setSessionData(d,s,t.getId());}};var b={ondragstart:function(e){var d=e.dragSession;if(!d||!d.getDragControl()){return;}var o=d.getDragControl();var s={};if(o.isA("sap.ui.table.Row")){if(o.isEmpty()||o.isGroupHeader()||o.isSummary()){e.preventDefault();return;}else{s.draggedRowContext=o.getRowBindingContext();}}a.setInstanceSessionData(d,this,s);},ondragenter:function(e){var d=e.dragSession;if(!d||!d.getDropControl()){return;}var s=a.getInstanceSessionData(d,this);var o=d.getDragControl();var f=d.getDropControl();if(!s){s={};}if(f.isA("sap.ui.table.Row")){var g=s.draggedRowContext;var h=f.getRowBindingContext();var i=d.getDropInfo().getDropPosition();if((f.isEmpty()&&i===D.On&&T.hasData(this))||(g&&g===h)||f.isGroupHeader()||f.isSummary()){e.setMarked("NonDroppable");}else{if(!h){var l=this.getRows()[T.getNonEmptyVisibleRowCount(this)-1];d.setDropControl(l||this);}if(d.getDropControl()!==this){var v=this.getDomRef().classList.contains("sapUiTableVScr");var t=this.getDomRef("sapUiTableCnt").getBoundingClientRect();d.setIndicatorConfig({width:t.width-(v?16:0),left:t.left+(this._bRtlMode&&v?16:0)});}}}else if(f.isA("sap.ui.table.Column")){var t=this.getDomRef("sapUiTableCnt").getBoundingClientRect();d.setIndicatorConfig({height:t.height-(this._getScrollExtension().isHorizontalScrollbarVisible()?16:0)});}else if(o===f){e.setMarked("NonDroppable");}if(!s.verticalScrollEdge){var p=window.pageYOffset;var V=this.getDomRef("table").getBoundingClientRect();s.verticalScrollEdge={bottom:V.bottom+p,top:V.top+p};}var P=window.pageXOffset;var H=this.getDomRef("sapUiTableCtrlScr").getBoundingClientRect();s.horizontalScrollEdge={left:H.left+P,right:H.right+P};a.setInstanceSessionData(d,this,s);},ondragover:function(e){var d=e.dragSession;if(!d){return;}var s=a.getInstanceSessionData(d,this);if(!s){return;}var i=32;var t=50;var o=d.getDropControl();var f=this._getScrollExtension();var v=f.getVerticalScrollbar();var h=f.getHorizontalScrollbar();var V=s.verticalScrollEdge;var H=s.horizontalScrollEdge;if(V&&v&&o!==this){var p=e.pageY;if(p>=V.top-t&&p<=V.top+t){v.scrollTop-=i;}else if(p<=V.bottom+t&&p>=V.bottom-t){v.scrollTop+=i;}}if(H&&h&&o!==this){var P=e.pageX;if(P>=H.left-t&&P<=H.left+t){h.scrollLeft-=i;}else if(P<=H.right+t&&P>=H.right-t){h.scrollLeft+=i;}}},onlongdragover:function(e){var d=e.dragSession;if(!d){return;}var $=T.getCell(this,e.target);var r=T.getCellInfo($).rowIndex;var R=r==null?null:this.getRows()[r];var o=d.getDropControl();if(R&&(o==R||!o)){T.Grouping.toggleGroupHeader(this,R.getIndex(),true);}}};
var c=E.extend("sap.ui.table.extensions.DragAndDrop",{
_init:function(t,s,m){this._oDelegate=b;T.addDelegate(t,this._oDelegate,t);return"DragAndDropExtension";},
_debug:function(){this._ExtensionDelegate=b;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._oDelegate);}this._oDelegate=null;E.prototype.destroy.apply(this,arguments);}
});
return c;});
sap.ui.predefine('sap/ui/table/extensions/ExtensionBase',["sap/ui/base/Object"],function(B){"use strict";
var E=B.extend("sap.ui.table.extensions.ExtensionBase",{
_table:null,
_type:null,
_settings:null,
constructor:function(t,s){B.call(this);this._table=t;this._settings=s||{};this._type=E.TABLETYPES.STANDARD;if(t.isA("sap.ui.table.TreeTable")){this._type=E.TABLETYPES.TREE;}else if(t.isA("sap.ui.table.AnalyticalTable")){this._type=E.TABLETYPES.ANALYTICAL;}var e=this._init(this._table,this._type,this._settings);if(e){var a=this;t["_get"+e]=function(){return a;};}},
destroy:function(){this._table=null;this._type=null;this.bIsDestroyed=true;B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
E.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};
E.prototype.getTable=function(){return this._table;};
E.prototype._init=function(t,T,s){return null;};
E.prototype._attachEvents=function(){};
E.prototype._detachEvents=function(){};
E.attachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._attachEvents();}};
E.detachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._detachEvents();}};
E.enrich=function(t,a,s){if(!a||!(a.prototype instanceof E)){return null;}var e=new a(t,s);if(!t._aExtensions){t._aExtensions=[];}t._aExtensions.push(e);return e;};
E.cleanup=function(t){if(!t._bExtensionsInitialized||!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i].destroy();}delete t._aExtensions;delete t._bExtensionsInitialized;};
E.isEnrichedWith=function(t,e){if(!t||!t._aExtensions){return false;}for(var i=0;i<t._aExtensions.length;i++){if(t._aExtensions[i].getMetadata().getName()===e){return true;}}return false;};
return E;});
sap.ui.predefine('sap/ui/table/extensions/Keyboard',["./ExtensionBase","./KeyboardDelegate","../utils/TableUtils","sap/ui/core/delegate/ItemNavigation","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(E,K,T,I,D,c,q){"use strict";var b=false;
function a(o){if(D.browser.msie){if(!b){q("head").append("<style type=\"text/css\">"+"/* Avoid focus outline problems in tables */\n"+".sapUiTableStatic[data-sap-ui-table-focus]{}"+"</style>");b=true;}var C=T.getCellInfo(o)||{};if(C.isOfType(T.CELLTYPE.ANY)){C.cell.attr("data-sap-ui-table-focus",Date.now());}}}
var d={_forward:function(t,o){var i=t._getItemNavigation();if(i!=null&&!t._getKeyboardExtension()._isItemNavigationSuspended()&&!o.isMarked("sapUiTableSkipItemNavigation")){i["on"+o.type](o);}},onfocusin:function(o){d._forward(this,o);a(o.target);},onsapfocusleave:function(o){d._forward(this,o);},onmousedown:function(o){d._forward(this,o);},onsapnext:function(o){d._forward(this,o);},onsapnextmodifiers:function(o){d._forward(this,o);},onsapprevious:function(o){d._forward(this,o);},onsappreviousmodifiers:function(o){d._forward(this,o);},onsappageup:function(o){d._forward(this,o);},onsappagedown:function(o){d._forward(this,o);},onsaphome:function(o){d._forward(this,o);},onsaphomemodifiers:function(o){d._forward(this,o);},onsapend:function(o){d._forward(this,o);},onsapendmodifiers:function(o){d._forward(this,o);},onsapkeyup:function(o){d._forward(this,o);}};var e={onBeforeRendering:function(o){this._oStoredFocusInfo=this.getFocusInfo();},onAfterRendering:function(o){var r=o&&o.isMarked("renderRows");this._getKeyboardExtension().invalidateItemNavigation();if(this._oStoredFocusInfo&&this._oStoredFocusInfo.customId){if(r){this.applyFocusInfo(this._oStoredFocusInfo);}else{this._getKeyboardExtension().initItemNavigation();}}delete this._oStoredFocusInfo;},onfocusin:function(o){var h=this._getKeyboardExtension();if(!h._bIgnoreFocusIn){h.initItemNavigation();}else{o.setMarked("sapUiTableIgnoreFocusIn");}if(o.target&&o.target.id===this.getId()+"-rsz"){o.preventDefault();o.setMarked("sapUiTableSkipItemNavigation");}}};var f={_initItemNavigation:function(o){var t=o.getTable();if(!t){return;}var $=t.$();var r=t.getRows().length;var C=T.getVisibleColumnCount(t);var h=T.hasRowHeader(t);var H=T.hasRowActions(t);var j=T.hasFixedColumns(t);var i;var k=[],R,l,m,n,p;if(j){m=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");n=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");p=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");}var s=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");var u=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");var v=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");if(h){R=$.find(".sapUiTableRowSelectionCell").get();C++;}if(H){l=$.find(".sapUiTableRowActionCell").get();C++;}for(i=0;i<r;i++){if(h){k.push(R[i]);}if(j){k=k.concat(m.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}k=k.concat(s.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(j){k=k.concat(n.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}k=k.concat(u.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(j){k=k.concat(p.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}k=k.concat(v.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(H){k.push(l[i]);}}if(t.getColumnHeaderVisible()){var w=[];var F=$.find(".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr");var S=$.find(".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr");var x=T.getHeaderRowCount(t);for(i=0;i<x;i++){if(h){w.push(t.getDomRef("selall"));}if(F.length){w=w.concat(q(F.get(i)).find(".sapUiTableHeaderCell").get());}if(S.length){w=w.concat(q(S.get(i)).find(".sapUiTableHeaderCell").get());}if(H){w.push($.find(".sapUiTableRowActionHeaderCell").children().get(0));}}k=w.concat(k);}if(!o._itemNavigation){o._itemNavigation=new I();o._itemNavigation.setTableMode(true);o._itemNavigation.attachEvent(I.Events.AfterFocus,function(y){var z=T.getFocusedItemInfo(t);z.header=T.getHeaderRowCount(t);z.domRef=null;if(z.row>=z.header){o._oLastFocusedCellInfo=z;}},t);}o._itemNavigation.setColumns(C);o._itemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));o._itemNavigation.setItemDomRefs(k);o._itemNavigation.setFocusedIndex(f.getInitialItemNavigationIndex(o));o._itemNavigationInvalidated=false;},getInitialItemNavigationIndex:function(o){return T.hasRowHeader(o.getTable())?1:0;},isItemNavigationInvalid:function(o){return!o._itemNavigation||o._itemNavigationInvalidated;}};
var g=E.extend("sap.ui.table.extensions.Keyboard",{
_init:function(t,s,S){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._delegate=new K(s);this._actionMode=false;T.addDelegate(t,e,t);T.addDelegate(t,this._delegate,t);T.addDelegate(t,d,t);t._getItemNavigation=function(){return this._itemNavigation;}.bind(this);return"KeyboardExtension";},
_debug:function(){this._ExtensionHelper=f;this._ItemNavigationDelegate=d;this._ExtensionDelegate=e;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(e);t.removeEventDelegate(this._delegate);t.removeEventDelegate(d);}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}if(this._delegate){this._delegate.destroy();this._delegate=null;}E.prototype.destroy.apply(this,arguments);}
});
g.prototype.initItemNavigation=function(){if(f.isItemNavigationInvalid(this)){f._initItemNavigation(this);}};
g.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true;};
g.prototype.setActionMode=function(h){if(!this._delegate){return;}if(h===true&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=this._delegate.enterActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1))===true;}else if(h===false&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1));}};
g.prototype.isInActionMode=function(){return this._actionMode;};
g.prototype.updateNoDataAndOverlayFocus=function(p){var t=this.getTable();if(!t||!t.getDomRef()){return;}if(t.getShowOverlay()){if(c(t.getDomRef(),p)){t.$("overlay").trigger("focus");}}else if(T.isNoDataVisible(t)){if(c(t.getDomRef("sapUiTableCnt"),p)){t.$("noDataCnt").trigger("focus");}}else if(c(t.getDomRef("noDataCnt"),p)||c(t.getDomRef("overlay"),p)){T.focusItem(t,f.getInitialItemNavigationIndex(this));}};
g.prototype._suspendItemNavigation=function(){this._itemNavigationSuspended=true;};
g.prototype._resumeItemNavigation=function(){this._itemNavigationSuspended=false;};
g.prototype._isItemNavigationSuspended=function(){return this._itemNavigationSuspended;};
g.prototype._getLastFocusedCellInfo=function(){var h=T.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=h){var i=T.getFocusedItemInfo(this.getTable());var j=f.getInitialItemNavigationIndex(this);return{cellInRow:j,row:h,header:h,cellCount:i.cellCount,columnCount:i.columnCount,cell:i.columnCount*h+j};}return this._oLastFocusedCellInfo;};
g.prototype._setSilentFocus=function(o){this._bIgnoreFocusIn=true;this._setFocus(o);this._bIgnoreFocusIn=false;};
g.prototype._setFocus=function(o){if(!o){return;}var t=this.getTable();var C=T.getCellInfo(o);if(C.isOfType(T.CELLTYPE.ANY)&&t){var $=q(o);if($.attr("tabindex")!="0"){var h=t._getItemNavigation();if(h&&h.aItemDomRefs){for(var i=0;i<h.aItemDomRefs.length;i++){if(h.aItemDomRefs[i]){h.aItemDomRefs[i].setAttribute("tabindex","-1");}}}$.attr("tabindex","0");}}o.focus();};
g.prototype._getTableType=function(){return this._type;};
return g;});
sap.ui.predefine('sap/ui/table/extensions/KeyboardDelegate',["../utils/TableUtils","../library","sap/ui/base/Object","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(T,l,B,D,K,q){"use strict";var C=T.CELLTYPE;var S=l.SelectionMode;var M={CTRL:1,SHIFT:2,ALT:4};var N={LEFT:"Left",RIGHT:"Right",UP:"Up",DOWN:"Down"};var H=5;var a="1rem";
function p(E,P){E.setMarked("sapUiTableSkipItemNavigation",P!==false);}
var b=B.extend("sap.ui.table.extensions.KeyboardDelegate",{
constructor:function(t){B.call(this);},
destroy:function(){B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
b._restoreFocusOnLastFocusedDataCell=function(t,E){var o=T.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();T.focusItem(t,o.cellInRow+(o.columnCount*L.row),E);};
b._setFocusOnColumnHeaderOfLastFocusedDataCell=function(t,E){var o=T.getFocusedItemInfo(t);T.focusItem(t,o.cellInRow,E);};
b._forwardFocusToTabDummy=function(t,g){t._getKeyboardExtension()._setSilentFocus(t.$().find("."+g));};
b._isKeyCombination=function(E,k,m){if(m==null){m=0;}var g=typeof k==="string"?String.fromCharCode(E.charCode):E.keyCode;var h=0;h|=(D.os.macintosh?E.metaKey:E.ctrlKey)&&k!==K.CONTROL?M.CTRL:0;h|=E.shiftKey&&k!==K.SHIFT?M.SHIFT:0;h|=E.altKey&&k!==K.ALT?M.ALT:0;var v=k==null||g===k;var V=m===h;return v&&V;};
b._handleSpaceAndEnter=function(t,E){var o=T.getCellInfo(E.target);if(o.isOfType(C.COLUMNROWHEADER)){t._getSelectionPlugin().onHeaderSelectorPress();}else if(b._isElementGroupToggler(t,E.target)){T.Grouping.toggleGroupHeaderByRef(t,E.target);}else if(o.isOfType(C.ROWHEADER)){h();}else if(o.isOfType(C.DATACELL|C.ROWACTION)){var g=!t.hasListeners("cellClick");if(!t._findAndfireCellEvent(t.fireCellClick,E)){if(T.isRowSelectionAllowed(t)){h();g=false;}}if(g){var i=T.getInteractiveElements(E.target);if(i){t._getKeyboardExtension().setActionMode(true);}}}function h(){var _=null;if(t._legacyMultiSelection){_=function(r){t._legacyMultiSelection(r,E);return true;};}T.toggleRowSelection(t,E.target,null,_);}};
b._moveColumn=function(o,n){var t=o.getParent();var v=t._getVisibleColumns();var i=v.indexOf(o);var g;if(n&&i<v.length-1){g=t.indexOfColumn(v[i+1])+1;}else if(!n&&i>0){g=t.indexOfColumn(v[i-1]);}if(g!=null){T.Column.moveColumnTo(o,g);}};
b._getVisibleAndGroupedColumns=function(t){return t.getColumns().filter(function(o){return o.getVisible()||o.getGrouped();});};
b._getColumnIndexInVisibleAndGroupedColumns=function(t,o){var v=b._getVisibleAndGroupedColumns(t);for(var i=0;i<v.length;i++){var V=v[i];if(V===o){return i;}}return-1;};
b._focusElement=function(t,E,g){if(!t||!E){return;}if(g==null){g=false;}T.deselectElementText(document.activeElement);if(g){t._getKeyboardExtension()._setSilentFocus(E);}else{E.focus();}T.selectElementText(E);};
b._focusCell=function(t,i,r,g,F,A){if(!t||i==null||r==null||r<0||r>=t.getRows().length){return;}var R=t.getRows()[r];var o;if(i===C.ROWHEADER){t._getKeyboardExtension()._setFocus(t.getDomRef("rowsel"+r));return;}else if(i===C.ROWACTION){o=t.getDomRef("rowact"+r);}else if(i===C.DATACELL&&(g!=null&&g>=0)){var h=t.getColumns()[g];var j=b._getColumnIndexInVisibleAndGroupedColumns(t,h);if(j>=0){o=R.getDomRef("col"+j);}}if(!o){return;}if(F){var I=T.getInteractiveElements(o);if(I){b._focusElement(t,I[0]);return;}}if(A){t._getKeyboardExtension()._bStayInActionMode=true;}o.focus();};
b._navigate=function(t,E,g){if(E.isMarked()){return;}var k=t._getKeyboardExtension();var A=k.isInActionMode();var o=T.getCellInfo(T.getCell(t,E.target));var h=false;if((g===N.UP||g===N.DOWN)&&o.isOfType(C.ANYCONTENTCELL)){var i=b._isKeyCombination(E,null,M.CTRL);var j=i||A;var P=T.getParentCell(t,E.target);var m=A&&o.isOfType(C.DATACELL);if(!i&&(E.target instanceof window.HTMLInputElement||E.target instanceof window.HTMLTextAreaElement)){return;}if(!j&&P){P.trigger("focus");return;}p(E);if(g===N.UP){if(T.isFirstScrollableRow(t,o.cell)){h=t._getScrollExtension().scrollVertically(false,false,m,function(){if(m){document.activeElement.blur();}});}}else if(T.isLastScrollableRow(t,o.cell)){h=t._getScrollExtension().scrollVertically(true,false,m,function(){if(m){document.activeElement.blur();}});}if(h){E.preventDefault();if(j){t.attachEventOnce("_rowsUpdated",function(){b._focusCell(t,o.type,o.rowIndex,o.columnIndex,true);});}}else if(g===N.UP&&o.rowIndex===0){p(E,o.isOfType(C.ROWACTION)||j);if(!A&&P){P.trigger("focus");}else{k.setActionMode(false);}}else if(g===N.DOWN&&o.rowIndex===t._getRowCounts().count-1){if(!A&&P){P.trigger("focus");}else{var n=t.getCreationRow();if(!n||!n._takeOverKeyboardHandling(E)){k.setActionMode(false);}}}else{var r=g===N.DOWN?1:-1;b._focusCell(t,o.type,o.rowIndex+r,o.columnIndex,j);E.preventDefault();}}else if(g===N.DOWN&&o.isOfType(C.ANYCOLUMNHEADER)){var u=T.getHeaderRowCount(t);if(T.isNoDataVisible(t)){var F=T.getFocusedItemInfo(t);if(F.row-u<=1){p(E);}}else if(o.isOfType(C.COLUMNROWHEADER)&&u>1){p(E);T.focusItem(t,u*(T.getVisibleColumnCount(t)+1),E);}}else if(g===N.LEFT&&!A){var I=sap.ui.getCore().getConfiguration().getRTL();if(o.isOfType(C.COLUMNHEADER)&&I){var v=T.getFocusedItemInfo(t);var w=v.cellInRow-(T.hasRowHeader(t)?1:0);var x=T.getVisibleColumnCount(t);if(T.hasRowActions(t)&&w===x-1){p(E);}}}};
b._isElementGroupToggler=function(t,E){return T.Grouping.isInGroupHeaderRow(E)||(T.Grouping.isTreeMode(t)&&E.classList.contains("sapUiTableCellFirst")&&(E.querySelector(".sapUiTableTreeIconNodeOpen")||E.querySelector(".sapUiTableTreeIconNodeClosed")))||E.classList.contains("sapUiTableTreeIconNodeOpen")||E.classList.contains("sapUiTableTreeIconNodeClosed");};
b._isElementInteractive=function(E){if(!E){return false;}return q(E).is(T.INTERACTIVE_ELEMENT_SELECTORS);};
b._getFirstInteractiveElement=function(r){if(!r){return null;}var t=r.getParent();var g=r.getCells();var $;var I;if(T.hasRowActions(t)){g.push(r.getRowAction());}for(var i=0;i<g.length;i++){$=T.getParentCell(t,g[i].getDomRef());I=T.getInteractiveElements($);if(I){return I.first();}}return null;};
b._getLastInteractiveElement=function(r){if(!r){return null;}var t=r.getParent();var g=r.getCells();var $;var I;if(T.hasRowActions(t)){g.push(r.getRowAction());}for(var i=g.length-1;i>=0;i--){$=T.getParentCell(t,g[i].getDomRef());I=T.getInteractiveElements($);if(I){return I.last();}}return null;};
b._getPreviousInteractiveElement=function(t,E){if(!t||!E){return null;}var $=q(E);if(!this._isElementInteractive($)){return null;}var g=T.getParentCell(t,E);var I;var o;var h;var j;var k;var m;var n;I=T.getInteractiveElements(g);if(I[0]!==$[0]){return I.eq(I.index(E)-1);}o=T.getCellInfo(g);j=t.getRows()[o.rowIndex].getCells();if(o.isOfType(C.ROWACTION)){n=j.length-1;}else{k=t.getColumns()[o.columnIndex];m=b._getColumnIndexInVisibleAndGroupedColumns(t,k);n=m-1;}for(var i=n;i>=0;i--){h=j[i].getDomRef();g=T.getParentCell(t,h);I=T.getInteractiveElements(g);if(I){return I.last();}}return null;};
b._getNextInteractiveElement=function(t,E){if(!t||!E){return null;}var $=q(E);if(!this._isElementInteractive($)){return null;}var g=T.getParentCell(t,E);var I;var o;var h;var j;var k;var r;var m;I=T.getInteractiveElements(g);if(I.get(-1)!==$[0]){return I.eq(I.index(E)+1);}o=T.getCellInfo(g);if(o.isOfType(C.ROWACTION)){return null;}r=t.getRows()[o.rowIndex];j=r.getCells();k=t.getColumns()[o.columnIndex];m=b._getColumnIndexInVisibleAndGroupedColumns(t,k);for(var i=m+1;i<j.length;i++){h=j[i].getDomRef();g=T.getParentCell(t,h);I=T.getInteractiveElements(g);if(I){return I.first();}}if(T.hasRowActions(t)){g=T.getParentCell(t,r.getRowAction().getDomRef());I=T.getInteractiveElements(g);if(I.get(-1)!==$[0]){return I.eq(I.index(E)+1);}}return null;};
function s(t){var F=T.getRowIndexOfFocusedCell(t);var i=t.getRows()[F].getIndex();var o=t._getSelectionPlugin();t._oRangeSelection={startIndex:i,selected:o.isIndexSelected(i)};}
b.prototype.enterActionMode=function(){var k=this._getKeyboardExtension();var A=document.activeElement;var i=T.getInteractiveElements(A);var $=T.getParentCell(this,A);var o=T.getCellInfo($);if(o.isOfType(C.ANYCOLUMNHEADER)){return false;}if(i){k._suspendItemNavigation();A.tabIndex=-1;b._focusElement(this,i[0],true);return true;}else if($){this._getKeyboardExtension()._suspendItemNavigation();return true;}return false;};
b.prototype.leaveActionMode=function(A){A=A==null?true:A;var k=this._getKeyboardExtension();var o=document.activeElement;var $=T.getParentCell(this,o);k._resumeItemNavigation();if(A){if($){b._focusElement(this,$[0],true);}else{var i=this._getItemNavigation();if(i){var I=i.aItemDomRefs;var F=I.indexOf(o);if(F>-1){i.setFocusedIndex(F);}}k._setSilentFocus(o);}}};
b.prototype.onfocusin=function(E){if(E.isMarked("sapUiTableIgnoreFocusIn")){return;}var t=q(E.target);if(t.hasClass("sapUiTableOuterBefore")||t.hasClass("sapUiTableOuterAfter")||(E.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this.$("overlay").trigger("focus");}else if(t.hasClass("sapUiTableCtrlBefore")){var n=T.isNoDataVisible(this);if(!n||n&&this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,E);}else{this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}}else if(t.hasClass("sapUiTableCtrlAfter")){if(!T.isNoDataVisible(this)){b._restoreFocusOnLastFocusedDataCell(this,E);}}var o=T.getCellInfo(E.target);var i=o.isOfType(C.ROWHEADER)&&T.Grouping.isInGroupHeaderRow(E.target);var I=o.isOfType(C.ROWHEADER)&&!i&&T.isRowSelectorSelectionAllowed(this);var g=o.isOfType(C.DATACELL)&&this._getKeyboardExtension()._bStayInActionMode;var P=T.getCellInfo(T.getParentCell(this,E.target)).isOfType(C.ANYCONTENTCELL);var h=b._isElementInteractive(E.target);var j=this._getKeyboardExtension().isInActionMode();var k=(j&&(i||I||g)||(h&&P));if(g){this._getKeyboardExtension()._bStayInActionMode=false;}this._getKeyboardExtension().setActionMode(k,false);};
b.prototype.onkeydown=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);var g=this.getSelectionMode();var h=this._getSelectionPlugin();if(D.browser.msie&&b._isKeyCombination(E,K.V,M.CTRL)){this.onpaste(E);return;}if(b._isKeyCombination(E,K.F2)){var i=k.isInActionMode();var $=T.getCell(this,E.target);var I=T.getParentCell(this,E.target)!=null;o=T.getCellInfo($);if(!i&&I){$.trigger("focus");}else if(o.isOfType(C.ANYCOLUMNHEADER)){var j=T.getInteractiveElements($);if(j){j[0].focus();}}else{k.setActionMode(!i);}return;}else if(b._isKeyCombination(E,K.F4)&&b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target);return;}if(this._getKeyboardExtension().isInActionMode()||!o.isOfType(C.ANY)){return;}if(b._isKeyCombination(E,K.SPACE)){E.preventDefault();}if(b._isKeyCombination(E,K.SHIFT)&&g===S.MultiToggle&&(o.isOfType(C.ROWHEADER)&&T.isRowSelectorSelectionAllowed(this)||(o.isOfType(C.DATACELL|C.ROWACTION)))){s(this);}else if(b._isKeyCombination(E,K.A,M.CTRL)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)&&g===S.MultiToggle){h.onKeyboardShortcut("toggle");}}else if(b._isKeyCombination(E,K.A,M.CTRL+M.SHIFT)){if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)){h.onKeyboardShortcut("clear");}}else if(b._isKeyCombination(E,K.F4)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}}};
b.prototype.onkeypress=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,"+")){if(b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target,true);}else if(o.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}else if(b._isKeyCombination(E,"-")){if(b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target,false);}else if(o.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}};
b.prototype.oncontextmenu=function(E){if(E.isMarked("handledByPointerExtension")){return;}var o=T.getCellInfo(document.activeElement);if(o.isOfType(C.ANY)){E.preventDefault();T.Menu.openContextMenu(this,E.target,E);}};
b.prototype.onkeyup=function(E){var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,K.SHIFT)){delete this._oRangeSelection;}if(o.isOfType(C.COLUMNHEADER)){if(b._isKeyCombination(E,K.SPACE)||b._isKeyCombination(E,K.ENTER)){T.Menu.openContextMenu(this,E.target);}}else if(b._isKeyCombination(E,K.SPACE)){b._handleSpaceAndEnter(this,E);}else if(b._isKeyCombination(E,K.SPACE,M.SHIFT)){T.toggleRowSelection(this,this.getRows()[o.rowIndex].getIndex());s(this);}else if(this._legacyMultiSelection&&!o.isOfType(C.COLUMNROWHEADER)&&(b._isKeyCombination(E,K.SPACE,M.CTRL)||b._isKeyCombination(E,K.ENTER,M.CTRL))){b._handleSpaceAndEnter(this,E);}};
b.prototype.onsaptabnext=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);var $;if(k.isInActionMode()){var I;$=T.getCell(this,E.target);o=T.getCellInfo($);if(!o.isOfType(C.ANYCONTENTCELL)){return;}var r=this.getRows()[o.rowIndex];var L=b._getLastInteractiveElement(r);var g=L===null||L[0]===E.target;if(g){var A=r.getIndex();var h=T.isLastScrollableRow(this,$);var j=this._getTotalRowCount()-1===A;var t=T.isRowSelectorSelectionAllowed(this);E.preventDefault();if(j){k.setActionMode(false);}else if(h){c(this,o,t,o.rowIndex,r);}else{var R=o.rowIndex;if(t){b._focusCell(this,C.ROWHEADER,R+1);}else{var v=this._getRowCounts().count;var m=false;for(var i=o.rowIndex+1;i<v;i++){R=i;r=this.getRows()[R];I=b._getFirstInteractiveElement(r);m=r.isGroupHeader();if(I||m){break;}}if(I){b._focusElement(this,I[0]);}else if(m){b._focusCell(this,C.ROWHEADER,R);}else{c(this,o,t,R,r);}}}}else if(o.isOfType(C.ROWHEADER)){E.preventDefault();I=b._getFirstInteractiveElement(r);b._focusElement(this,I[0]);}else{E.preventDefault();I=b._getNextInteractiveElement(this,E.target);b._focusElement(this,I[0]);}}else if(o.isOfType(C.ANYCOLUMNHEADER)){if(T.isNoDataVisible(this)){this.$("noDataCnt").trigger("focus");}else{b._restoreFocusOnLastFocusedDataCell(this,E);}E.preventDefault();}else if(o.isOfType(C.ANYCONTENTCELL)){b._forwardFocusToTabDummy(this,"sapUiTableCtrlAfter");}else if(E.target===this.getDomRef("overlay")){k._setSilentFocus(this.$().find(".sapUiTableOuterAfter"));}else if(!o.isOfType(C.ANY)){$=T.getParentCell(this,E.target);if($){E.preventDefault();$.trigger("focus");}}};
function c(t,o,g,r,R){var A=o.isOfType(C.DATACELL);var k=t._getKeyboardExtension();var h=t._getScrollExtension().scrollVertically(true,false,A,function(){if(A){document.activeElement.blur();}});if(h){t.attachEventOnce("_rowsUpdated",function(){d(t,R,r,g,R.isGroupHeader());});}else if(R.getIndex()!==t._getTotalRowCount()-1){var n=o.rowIndex+1;var i=t.getRows()[n];d(t,i,n,g,i.isGroupHeader());}else{k.setActionMode(false);}}
function d(t,r,R,g,i){var k=t._getKeyboardExtension();if(g||i){b._focusCell(t,C.ROWHEADER,R);}else{var I=b._getFirstInteractiveElement(r);if(I){b._focusElement(t,I[0]);}else{b._focusCell(t,C.DATACELL,R,0,false,true);if(r.getIndex()===t._getTotalRowCount()-1){k.setActionMode(false);}}}}
b.prototype.onsaptabprevious=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);var $;if(k.isInActionMode()){var I;$=T.getCell(this,E.target);o=T.getCellInfo($);if(!o.isOfType(C.ANYCONTENTCELL)){return;}var r=this.getRows()[o.rowIndex];var A=r.getIndex();var F=b._getFirstInteractiveElement(r);var g=F!==null&&F[0]===E.target;var t=T.isRowSelectorSelectionAllowed(this);var R=t||r.isGroupHeader();if(g&&R){E.preventDefault();b._focusCell(this,C.ROWHEADER,o.rowIndex);}else if((g&&!R)||o.isOfType(C.ROWHEADER)||F===null){var h=T.isFirstScrollableRow(this,$);var j=A===0;E.preventDefault();if(j){k.setActionMode(false);}else if(h){e(this,o,R,o.rowIndex,r);}else{var m=o.rowIndex;var n=false;for(var i=o.rowIndex-1;i>=0;i--){m=i;r=this.getRows()[m];I=b._getLastInteractiveElement(r);n=r.isGroupHeader();if(I||R||n){break;}}if(I){b._focusElement(this,I[0]);}else if(n||R){b._focusCell(this,C.ROWHEADER,m);}else{e(this,o,R,m,r);}}}else{E.preventDefault();I=b._getPreviousInteractiveElement(this,E.target);b._focusElement(this,I[0]);}}else if(o.isOfType(C.ANYCONTENTCELL)||E.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()&&!o.isOfType(C.ROWACTION)){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,E);E.preventDefault();}else{b._forwardFocusToTabDummy(this,"sapUiTableCtrlBefore");}}else if(E.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus(this.$().find(".sapUiTableOuterBefore"));}else if(!o.isOfType(C.ANY)){$=T.getParentCell(this,E.target);if($){E.preventDefault();$.trigger("focus");}}};
function e(t,o,r,R,g){var A=o.isOfType(C.DATACELL);var k=t._getKeyboardExtension();var h=t._getScrollExtension().scrollVertically(false,false,A,function(){if(A){document.activeElement.blur();}});if(h){t.attachEventOnce("_rowsUpdated",function(){f(t,g,R,r,g.isGroupHeader());});}else if(g.getIndex()!==0){var P=o.rowIndex-1;var i=t.getRows()[P];f(t,i,P,r,i.isGroupHeader());}else{k.setActionMode(false);}}
function f(t,r,R,g,i){var k=t._getKeyboardExtension();var I=b._getLastInteractiveElement(r);if(I){b._focusElement(t,I[0]);}else if(g||i){b._focusCell(t,C.ROWHEADER,R);}else{b._focusCell(t,C.DATACELL,R,0,false,true);if(r.getIndex()===0){k.setActionMode(false);}}}
b.prototype.onsapdown=function(E){b._navigate(this,E,N.DOWN);};
b.prototype.onsapdownmodifiers=function(E){if(b._isKeyCombination(E,null,M.CTRL)){b._navigate(this,E,N.DOWN);return;}var k=this._getKeyboardExtension();if(b._isKeyCombination(E,null,M.ALT)&&b._isElementGroupToggler(this,E.target)){p(E);T.Grouping.toggleGroupHeaderByRef(this,E.target,true);return;}if(k.isInActionMode()){return;}var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(E);return;}var F=T.getRowIndexOfFocusedCell(this);var i=this.getRows()[F].getIndex();if(i===this._getTotalRowCount()-1){return;}if(T.isLastScrollableRow(this,E.target)){var g=this._getScrollExtension().scrollVertically(true,false);if(g){p(E);}}if(this._oRangeSelection.startIndex<=i){i++;if(this._oRangeSelection.selected){T.toggleRowSelection(this,i,true);}else{T.toggleRowSelection(this,i,false);}}else{T.toggleRowSelection(this,i,false);}}else{p(E);}}if(b._isKeyCombination(E,null,M.ALT)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}p(E);}};
b.prototype.onsapup=function(E){b._navigate(this,E,N.UP);};
b.prototype.onsapupmodifiers=function(E){var k=this._getKeyboardExtension();if(b._isKeyCombination(E,null,M.CTRL)){b._navigate(this,E,N.UP);return;}if(b._isKeyCombination(E,null,M.ALT)&&b._isElementGroupToggler(this,E.target)){p(E);T.Grouping.toggleGroupHeaderByRef(this,E.target,false);return;}if(k.isInActionMode()){return;}var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(E);return;}var F=T.getRowIndexOfFocusedCell(this);var i=this.getRows()[F].getIndex();if(i===0){p(E);return;}if(T.isFirstScrollableRow(this,E.target)){var g=this._getScrollExtension().scrollVertically(false,false);if(g){p(E);}}if(this._oRangeSelection.startIndex>=i){i--;if(this._oRangeSelection.selected){T.toggleRowSelection(this,i,true);}else{T.toggleRowSelection(this,i,false);}}else{T.toggleRowSelection(this,i,false);}}else{p(E);}}if(b._isKeyCombination(E,null,M.ALT)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}p(E);}};
b.prototype.onsapleft=function(E){b._navigate(this,E,N.LEFT);};
b.prototype.onsapleftmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}var o=T.getCellInfo(E.target);var I=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(E);return;}var F=T.getFocusedItemInfo(this);var g=T.hasRowHeader(this)&&F.cellInRow===1;if(g&&!T.isRowSelectorSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.ROWACTION)){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.ROWHEADER)&&I){if(!T.isRowSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.COLUMNROWHEADER)&&I){p(E);}else if(o.isOfType(C.COLUMNHEADER)){var r=-T.convertCSSSizeToPixel(a);var h=0;if(I){r=r*-1;}for(var i=o.columnIndex;i<o.columnIndex+o.columnSpan;i++){h+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,o.columnIndex,h+r,true,o.columnSpan);p(E);}}else if(b._isKeyCombination(E,null,M.CTRL)){if(o.isOfType(C.COLUMNHEADER)){E.preventDefault();E.stopImmediatePropagation();var j=this.getColumns()[o.columnIndex];b._moveColumn(j,I);}}};
b.prototype.onsaprightmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}var o=T.getCellInfo(E.target);var I=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.ROWHEADER)){if(!T.isRowSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.ROWACTION)&&I){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.COLUMNHEADER)){var r=T.convertCSSSizeToPixel(a);var g=0;if(I){r=r*-1;}for(var i=o.columnIndex;i<o.columnIndex+o.columnSpan;i++){g+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,o.columnIndex,g+r,true,o.columnSpan);p(E);}else if(o.isOfType(C.COLUMNROWHEADER)){p(E);}}else if(b._isKeyCombination(E,null,M.CTRL)){if(o.isOfType(C.COLUMNHEADER)){E.preventDefault();E.stopImmediatePropagation();var h=this.getColumns()[o.columnIndex];b._moveColumn(h,!I);}}};
b.prototype.onsaphome=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupHeaderRow(E.target)){p(E);E.preventDefault();return;}var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){E.preventDefault();}if(o.isOfType(C.DATACELL|C.ROWACTION|C.COLUMNHEADER)){var F=T.getFocusedItemInfo(this);var i=F.cell;var g=F.cellInRow;var h=this.getComputedFixedColumnCount();var j=T.hasRowHeader(this);var r=j?1:0;if(T.hasFixedColumns(this)&&g>h+r){p(E);T.focusItem(this,i-g+h+r,null);}else if(j&&g>1){p(E);T.focusItem(this,i-g+r,null);}}};
b.prototype.onsapend=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupHeaderRow(E.target)){E.preventDefault();p(E);return;}var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){E.preventDefault();var F=T.getFocusedItemInfo(this);var i=F.cell;var g=F.columnCount;var h=this.getComputedFixedColumnCount();var j=F.cellInRow;var k=T.hasRowHeader(this);var r=k?1:0;var I=false;if(o.isOfType(C.COLUMNHEADER)&&T.hasFixedColumns(this)){var m=parseInt(o.cell.attr("colspan")||1);if(m>1&&j+m-r===h){I=true;}}if(k&&j===0){p(E);T.focusItem(this,i+1,null);}else if(T.hasFixedColumns(this)&&j<h-1+r&&!I){p(E);T.focusItem(this,i+h-j,null);}else if(T.hasRowActions(this)&&o.isOfType(C.DATACELL)&&j<g-2){p(E);T.focusItem(this,i-j+g-2,null);}}};
b.prototype.onsaphomemodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.CTRL)){E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){p(E);var F=T.getFocusedItemInfo(this);var i=F.row;if(i>0){var g=F.cell;var h=F.columnCount;var j=T.getHeaderRowCount(this);var r=this._getRowCounts();if(i<j+r.fixedTop){if(o.isOfType(C.ROWACTION)){T.focusItem(this,g-h*(i-j),E);}else{T.focusItem(this,g-h*i,E);}}else if(i>=j+r.fixedTop&&i<j+T.getNonEmptyVisibleRowCount(this)-r.fixedBottom){this._getScrollExtension().scrollVerticallyMax(false);if(r.fixedTop>0||o.isOfType(C.ROWACTION)){T.focusItem(this,g-h*(i-j),E);}else{T.focusItem(this,g-h*i,E);}}else{this._getScrollExtension().scrollVerticallyMax(false);T.focusItem(this,g-h*(i-j-r.fixedTop),E);}}}}};
b.prototype.onsapendmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.CTRL)){E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){var F=T.getFocusedItemInfo(this);var i=F.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var r=this._getRowCounts();p(E);if(r.fixedBottom===0||i<h+n-1||(T.isNoDataVisible(this)&&i<h-1)){var g=F.cell;var j=F.columnCount;if(T.isNoDataVisible(this)){T.focusItem(this,g+j*(h-i-1),E);}else if(i<h){if(r.fixedTop>0){T.focusItem(this,g+j*(h+r.fixedTop-i-1),E);}else{this._getScrollExtension().scrollVerticallyMax(true);T.focusItem(this,g+j*(h+n-r.fixedBottom-i-1),E);}}else if(i>=h&&i<h+r.fixedTop){this._getScrollExtension().scrollVerticallyMax(true);T.focusItem(this,g+j*(h+n-r.fixedBottom-i-1),E);}else if(i>=h+r.fixedTop&&i<h+n-r.fixedBottom){this._getScrollExtension().scrollVerticallyMax(true);T.focusItem(this,g+j*(h+n-i-1),E);}else{T.focusItem(this,g+j*(h+n-i-1),E);}}}}};
b.prototype.onsappageup=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){var F=T.getFocusedItemInfo(this);var i=F.row;var h=T.getHeaderRowCount(this);var r=this._getRowCounts();if(r.fixedTop===0&&i>=h||r.fixedTop>0&&i>h){p(E);var g=F.cell;var j=F.columnCount;if(i<h+r.fixedTop){T.focusItem(this,g-j*(i-h),E);}else if(i===h+r.fixedTop){var P=T.getNonEmptyVisibleRowCount(this)-r.fixedTop-r.fixedBottom;var R=this.getFirstVisibleRow();this._getScrollExtension().scrollVertically(false,true);if(R<P){if(r.fixedTop>0||o.isOfType(C.ROWACTION)){T.focusItem(this,g-j*(i-h),E);}else{T.focusItem(this,g-j*h,E);}}}else if(i>h+r.fixedTop&&i<h+T.getNonEmptyVisibleRowCount(this)){T.focusItem(this,g-j*(i-h-r.fixedTop),E);}else{T.focusItem(this,g-j*(i-h-T.getNonEmptyVisibleRowCount(this)+1),E);}}if(o.isOfType(C.ROWACTION)&&i===h&&r.fixedTop>0){p(E);}}};
b.prototype.onsappagedown=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){var F=T.getFocusedItemInfo(this);var i=F.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var r=this._getRowCounts();p(E);if((T.isNoDataVisible(this)&&i<h-1)||r.fixedBottom===0||i<h+n-1){var g=F.cell;var j=F.columnCount;if(i<h-1&&!o.isOfType(C.COLUMNROWHEADER)){T.focusItem(this,g+j*(h-i-1),E);}else if(i<h){if(!T.isNoDataVisible(this)){T.focusItem(this,g+j*(h-i),E);}}else if(i>=h&&i<h+n-r.fixedBottom-1){T.focusItem(this,g+j*(h+n-r.fixedBottom-i-1),E);}else if(i===h+n-r.fixedBottom-1){var P=T.getNonEmptyVisibleRowCount(this)-r.fixedTop-r.fixedBottom;var R=this._getTotalRowCount()-r.fixedBottom-this.getFirstVisibleRow()-P*2;this._getScrollExtension().scrollVertically(true,true);if(R<P&&r.fixedBottom>0){T.focusItem(this,g+j*(h+n-i-1),E);}}else{T.focusItem(this,g+j*(h+n-i-1),E);}}}};
b.prototype.onsappageupmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.ALT)){var o=T.getCellInfo(E.target);var F=T.getFocusedItemInfo(this);if(o.isOfType(C.DATACELL|C.COLUMNHEADER)){var i=F.cell;var g=F.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var P=H;p(E);if(h&&(T.Grouping.isInGroupHeaderRow(E.target)||g===1)){T.focusItem(this,i-g,null);}else if(g-r<P){T.focusItem(this,i-g+r,null);}else{T.focusItem(this,i-P,null);}}else if(o.isOfType(C.ROWACTION)){T.focusItem(this,F.cell-1,null);}}};
b.prototype.onsappagedownmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.ALT)){var o=T.getCellInfo(E.target);if(o.isOfType(C.DATACELL|C.ROWHEADER|C.ANYCOLUMNHEADER)){var F=T.getFocusedItemInfo(this);var i=F.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var v=T.getVisibleColumnCount(this);var g=parseInt(o.cell.attr("colspan")||1);p(E);if(i+g-r<v){var j=F.cell;var P=H;if(h&&i===0){T.focusItem(this,j+1,null);}else if(g>P){T.focusItem(this,j+g,null);}else if(i+g-r+P>v){T.focusItem(this,j+v-i-1+r,null);}else if(!T.Grouping.isInGroupHeaderRow(E.target)){T.focusItem(this,j+P,null);}}else if(o.isOfType(C.DATACELL)&&T.hasRowActions(this)&&i===F.columnCount-2){T.focusItem(this,F.cell+1,null);}}}};
b.prototype.onsapenter=function(E){b._handleSpaceAndEnter(this,E);};
return b;});
sap.ui.predefine('sap/ui/table/extensions/Pointer',["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/control"],function(E,T,l,D,P,L,q){"use strict";var S=l.SelectionMode;var K=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer","sapMBtnIcon"];var a={_getEventPosition:function(e,t){var p;function g(o){if(!t._isTouchEvent(o)){return null;}var f=["touches","targetTouches","changedTouches"];for(var i=0;i<f.length;i++){var s=f[i];if(e[s]&&e[s][0]){return e[s][0];}if(e.originalEvent[s]&&e.originalEvent[s][0]){return e.originalEvent[s][0];}}return null;}p=g(e)||e;return{x:p.pageX,y:p.pageY};},_skipClick:function(e,t,o){if(!o.isOfType(T.CELLTYPE.DATACELL|T.CELLTYPE.ROWACTION)){return false;}if(e.isMarked()){return true;}var f=t.control(0);if(f){var $=f.$();if($.length){for(var i=0;i<K.length;i++){if($.hasClass(K[i])){return typeof f.getEnabled==="function"?f.getEnabled():true;}}}}return false;},_handleClickSelection:function(e,$,t){T.toggleRowSelection(t,$,null,function(r){var s=t._getSelectionPlugin();if((D.browser.msie||D.browser.edge)&&e.shiftKey){t._clearTextSelection();}var o=t.getSelectionMode();if(o===S.Single){if(!s.isIndexSelected(r)){s.setSelectedIndex(r);}else{s.clearSelection();}}else if(e.shiftKey){var i=s.getSelectedIndex();if(i>=0){s.addSelectionInterval(i,r);}else if(s.getSelectedCount()===0){s.setSelectedIndex(r);}}else if(!t._legacyMultiSelection){if(!s.isIndexSelected(r)){s.addSelectionInterval(r,r);}else{s.removeSelectionInterval(r,r);}}else{t._legacyMultiSelection(r,e);}return true;});}};var C={initColumnResizing:function(t,e){if(t._bIsColumnResizerMoving){return;}t._bIsColumnResizerMoving=true;t._bColumnResizerMoved=false;t._iColumnResizeStart=a._getEventPosition(e,t).x;t.$().toggleClass("sapUiTableResizing",true);var $=q(document);var f=t._isTouchEvent(e);t._$colResize=t.$("rsz");$.on((f?"touchend":"mouseup")+".sapUiTableColumnResize",C.exitColumnResizing.bind(t));$.on((f?"touchmove":"mousemove")+".sapUiTableColumnResize",C.onMouseMoveWhileColumnResizing.bind(t));t._disableTextSelection();},exitColumnResizing:function(e){var i=a._getEventPosition(e,this).x;var o=this._getVisibleColumns()[this._iLastHoveredVisibleColumnIndex];var r=this.$().find("th[data-sap-ui-colid=\""+o.getId()+"\"]");var f=r[0].offsetWidth;var g=i-(r.offset().left+(this._bRtlMode?0:f));var h=Math.round(f+g*(this._bRtlMode?-1:1));var n=Math.max(h,T.Column.getMinColumnWidth());C._resizeColumn(this,this._iLastHoveredVisibleColumnIndex,this._bColumnResizerMoved?n:null);},onMouseMoveWhileColumnResizing:function(e){var i=a._getEventPosition(e,this).x;var r=this.$().find(".sapUiTableCnt").offset().left;var f=Math.floor(i-r);if(!this._bColumnResizerMoved&&Math.abs(i-this._iColumnResizeStart)>=5){this._bColumnResizerMoved=true;}this._$colResize.css("left",f+"px");this._$colResize.toggleClass("sapUiTableColRszActive",true);if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault();}},_cleanupColumResizing:function(t){if(t._$colResize){t._$colResize.toggleClass("sapUiTableColRszActive",false);t._$colResize=null;}t._bIsColumnResizerMoving=false;t.$().toggleClass("sapUiTableResizing",false);t._enableTextSelection();var $=q(document);$.off("touchmove.sapUiTableColumnResize");$.off("touchend.sapUiTableColumnResize");$.off("mousemove.sapUiTableColumnResize");$.off("mouseup.sapUiTableColumnResize");},_resizeColumn:function(t,i,n){var v=t._getVisibleColumns();var o;if(i>=0&&i<v.length){o=v[i];if(n!=null){T.Column.resizeColumn(t,t.indexOfColumn(o),n);}}C._cleanupColumResizing(t);o.focus();},doAutoResizeColumn:function(t,i){var v=t._getVisibleColumns(),o;if(i>=0&&i<v.length){o=v[i];if(!o.getAutoResizable()||!o.getResizable()){return;}var n=C._calculateAutomaticColumnWidth.apply(t,[o,i]);if(n){C._resizeColumn(t,i,n);}}},_calculateAutomaticColumnWidth:function(o,i){o=o||this.getColumns()[i];var $=this.$();var e=q("<div>").addClass("sapUiTableHiddenSizeDetector sapUiTableHeaderDataCell sapUiTableDataCell");$.append(e);var f=$.find("td[data-sap-ui-colid = \""+o.getId()+"\"]:not([colspan])").filter(function(g,h){return h.style.display!="none";}).children().clone();f.removeAttr("id");var w=e.append(f).width()+4;w=Math.min(w,$.find(".sapUiTableCnt").width());w=Math.max(w+4,T.Column.getMinColumnWidth());e.remove();return w;},initColumnTracking:function(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").on("mousemove",function(e){var o=this.getDomRef();if(!o||this._bIsColumnResizerMoving){return;}var p=e.clientX,f=o.getBoundingClientRect(),g=0,r=this._bRtlMode?10000:-10000;for(var i=0;i<this._aTableHeaders.length;i++){var h=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if((p<h.right-5)&&(p>=h.left)){g=i;r=h.left-f.left;break;}}else{if((p>h.left+5)&&(p<=h.right)){g=i;r=h.right-f.left;break;}}}var j=this._getVisibleColumns()[g];if(j&&j.getResizable()){this.$("rsz").css("left",r+"px");this._iLastHoveredVisibleColumnIndex=g;}}.bind(t));}};var R={initReordering:function(t,i,e){var o=t.getColumns()[i],$=o.$(),f=t.$();t._disableTextSelection();f.addClass("sapUiTableDragDrop");var g=$.clone();g.find("*").addBack(g).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");g.attr("id",t.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({"left":-10000,"top":-10000,"z-index":P.getNextZIndex()});g.toggleClass(T.getContentDensity(t),true);g.appendTo(document.body);t._$ReorderGhost=t.getDomRef("roghost");f.find("td[data-sap-ui-colid='"+o.getId()+"']").toggleClass("sapUiTableColReorderFade",true);var I=q("<div id='"+t.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");I.appendTo(t.getDomRef("sapUiTableCnt"));t._$ReorderIndicator=t.getDomRef("roind");t._iDnDColIndex=i;var h=q(document),j=t._isTouchEvent(e);h.on((j?"touchend":"mouseup")+".sapUiColumnMove",R.exitReordering.bind(t));h.on((j?"touchmove":"mousemove")+".sapUiColumnMove",R.onMouseMoveWhileReordering.bind(t));},onMouseMoveWhileReordering:function(e){var o=a._getEventPosition(e,this),i=o.x,f=o.y,O=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();var p=R.findColumnForPosition(this,i);if(!p||!p.id){this._iNewColPos=O;return;}var s=40,g=this.getDomRef("sapUiTableColHdrScr"),$=q(g),h=g.getBoundingClientRect(),j=$.outerWidth(),k=this._bRtlMode?$.scrollLeftRTL():$.scrollLeft();this._bReorderScroll=false;if(i>h.left+j-s&&k+j<g.scrollWidth){this._bReorderScroll=true;R.doScroll(this,!this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}else if(i<h.left+s&&k>0){this._bReorderScroll=true;R.doScroll(this,this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}q(this._$ReorderGhost).css({"left":i+5,"top":f+5});if(this._bReorderScroll||!p){return;}if(p.before||(p.after&&p.index==this._iDnDColIndex)){this._iNewColPos=p.index;}else if(p.after&&p.index!=this._iDnDColIndex){this._iNewColPos=p.index+1;}if(!T.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=O;}else{R.adaptReorderMarkerPosition(this,p,true);}},exitReordering:function(e){var o=this._iDnDColIndex;var n=this._iNewColPos;var $=q(document);$.off("touchmove.sapUiColumnMove");$.off("touchend.sapUiColumnMove");$.off("mousemove.sapUiColumnMove");$.off("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;q(this._$ReorderGhost).remove();delete this._$ReorderGhost;q(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();T.Column.moveColumnTo(this.getColumns()[o],n);if(this._mTimeouts.reApplyFocusTimerId){window.clearTimeout(this._mTimeouts.reApplyFocusTimerId);}var t=this;this._mTimeouts.reApplyFocusTimerId=window.setTimeout(function(){var O=T.getFocusedItemInfo(t).cell;T.focusItem(t,0,e);T.focusItem(t,O,e);},0);},findColumnForPosition:function(t,e){var h,H,r,w,p,B,A;for(var i=0;i<t._aTableHeaders.length;i++){h=t._aTableHeaders[i];H=q(h);r=h.getBoundingClientRect();w=H.outerWidth();p={left:r.left,center:r.left+w/2,right:r.left+w,width:w,index:parseInt(H.attr("data-sap-ui-headcolindex")),id:H.attr("data-sap-ui-colid")};B=e>=p.left&&e<=p.center;A=e>=p.center&&e<=p.right;if(B||A){p.before=t._bRtlMode?A:B;p.after=t._bRtlMode?B:A;return p;}}return null;},doScroll:function(t,f){if(t._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(t._mTimeouts.horizontalReorderScrollTimerId);t._mTimeouts.horizontalReorderScrollTimerId=null;}if(t._bReorderScroll){var s=f?30:-30;if(t._bRtlMode){s=(-1)*s;}t._mTimeouts.horizontalReorderScrollTimerId=setTimeout(R.doScroll.bind(t,t,f),60);var $=t.$("sapUiTableColHdrScr");var e=t._bRtlMode?"scrollLeftRTL":"scrollLeft";$[e]($[e]()+s);}},adaptReorderMarkerPosition:function(t,p,s){if(!p||!t._$ReorderIndicator){return;}var i=p.left-t.getDomRef().getBoundingClientRect().left;if(t._bRtlMode&&p.before||!t._bRtlMode&&p.after){i=i+p.width;}q(t._$ReorderIndicator).css({"left":i+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",s);}};var b={ROWAREAS:[".sapUiTableRowSelectionCell",".sapUiTableRowActionCell",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(t){var $=t.$();for(var i=0;i<b.ROWAREAS.length;i++){b._initRowHoveringForArea(t,$,b.ROWAREAS[i]);}},_initRowHoveringForArea:function(t,$,A){$.find(A).on("mouseenter",function(){b._onHover(t,$,A,this);}).on("mouseleave",function(){b._onUnhover(t,$,A,this);});},_onHover:function(t,$,A,e){var i=$.find(A).index(e);var r=t.getRows()[i];if(r){r._setHovered(true);}},_onUnhover:function(t,$,A,e){var i=$.find(A).index(e);var r=t.getRows()[i];if(r){r._setHovered(false);}}};var c={onmousedown:function(e){var p=this._getPointerExtension();var $=T.getCell(this,e.target);var o=T.getCellInfo($);var t=q(e.target);var f;var m;var M;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("rsz")){e.preventDefault();e.stopPropagation();C.initColumnResizing(this,e);}else if(t.hasClass("sapUiTableColResizer")){var i=t.closest(".sapUiTableHeaderCell").attr("data-sap-ui-colindex");this._iLastHoveredVisibleColumnIndex=this._getVisibleColumns().indexOf(this.getColumns()[i]);C.initColumnResizing(this,e);}else if(o.isOfType(T.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=setTimeout(function(){delete p._bShowMenu;},200);}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&t.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(o.columnIndex,e);}}if((D.browser.firefox&&!!(e.metaKey||e.ctrlKey))||t.closest(".sapUiTableHSb",this.getDomRef()).length===1||t.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault();}}if(e.button===2){if(a._skipClick(e,t,o)){p._bShowDefaultMenu=true;return;}if(o.isOfType(T.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;}else{p._bHideMenu=true;}}else if(o.isOfType(T.CELLTYPE.ANYCONTENTCELL)){p._bShowMenu=true;}else{p._bShowDefaultMenu=true;}}},onmouseup:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);},ondblclick:function(e){if(D.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();C.doAutoResizeColumn(this,this._iLastHoveredVisibleColumnIndex);}},onclick:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return;}var t=q(e.target);var $=T.getCell(this,e.target);var o=T.getCellInfo($);var r=this.getRows()[o.rowIndex];if(r&&r.isSummary()){e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupMenuButton")){T.Menu.openContextMenu(this,e.target,e);return;}else if(t.hasClass("sapUiTableGroupIcon")||t.hasClass("sapUiTableTreeIcon")){if(T.Grouping.toggleGroupHeaderByRef(this,e.target)){return;}}if(o.isOfType(T.CELLTYPE.COLUMNHEADER)){var p=this._getPointerExtension();if(p._bShowMenu){T.Menu.openContextMenu(this,e.target);delete p._bShowMenu;}}else{if(a._skipClick(e,t,o)){return;}var s=window.getSelection().toString();if(!e.shiftKey&&s.length>0&&s!=="\n"){L.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return;}if(!this._findAndfireCellEvent(this.fireCellClick,e)){if(o.isOfType(T.CELLTYPE.COLUMNROWHEADER)){this._getSelectionPlugin().onHeaderSelectorPress();}else{a._handleClickSelection(e,$,this);}}else{e.preventDefault();}}},oncontextmenu:function(e){var p=this._getPointerExtension();if(p._bShowDefaultMenu){e.setMarked("handledByPointerExtension");delete p._bShowDefaultMenu;}else if(p._bShowMenu){var f=T.Menu.openContextMenu(this,e.target,e);if(f){e.preventDefault();}e.setMarked("handledByPointerExtension");delete p._bShowMenu;}else if(p._bHideMenu){e.setMarked("handledByPointerExtension");e.preventDefault();delete p._bHideMenu;}}};
var d=E.extend("sap.ui.table.extensions.Pointer",{
_init:function(t,s,m){this._delegate=c;T.addDelegate(t,this._delegate,t);t._iLastHoveredVisibleColumnIndex=0;t._bIsColumnResizerMoving=false;t._iFirstReorderableIndex=s==E.TABLETYPES.TREE?1:0;return"PointerExtension";},
_attachEvents:function(){var t=this.getTable();if(t){C.initColumnTracking(t);b.initRowHovering(t);}},
_detachEvents:function(){var t=this.getTable();if(t){var $=t.$();$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").off();$.find(".sapUiTableCtrl > tbody > tr").off();$.find(".sapUiTableRowSelectionCell").off();}},
_debug:function(){this._ExtensionHelper=a;this._ColumnResizeHelper=C;this._ReorderHelper=R;this._ExtensionDelegate=c;this._RowHoverHandler=b;this._KNOWNCLICKABLECONTROLS=K;},
doAutoResizeColumn:function(i){var t=this.getTable();if(t){C.doAutoResizeColumn(t,i);}},
doReorderColumn:function(i,e){var t=this.getTable();if(t&&T.Column.isColumnMovable(t.getColumns()[i])){t._mTimeouts.delayedColumnReorderTimerId=setTimeout(function(){R.initReordering(this,i,e);}.bind(t),200);}},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;E.prototype.destroy.apply(this,arguments);}
});
return d;});
sap.ui.predefine('sap/ui/table/extensions/Scrolling',["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery"],function(E,T,l,D,I,L,q){"use strict";var S=l.SharedDomRef;var H=T.Hook.Keys;var M=1000000;var V=2;var c={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};
function d(s,t){L.debug("sap.ui.table.extensions.Scrolling",s,t);}
function e(a){return typeof a.isConnected==="boolean"&&a.isConnected||document.body.contains(a);}
function P(a,b){var r=true;var C=false;var s=[];var t={cancel:function(){if(this.isCancelled()||!this.isRunning()){return;}C=true;for(var i=0;i<s.length;i++){s[i]();}d("Process cancelled: "+b.id);},isCancelled:function(){return C;},addCancelListener:function(i){s.push(i);},isRunning:function(){return r;},getInfo:function(){return b;},onPromiseCreated:function(i){}};var u;d("Process started: "+b.id);if(typeof a==="function"){u=new Promise(function(){a.apply(this,Array.prototype.slice.call(arguments).concat(t));});}else{u=Promise.resolve();}Object.assign(u,t);u.then(function(){if(t.isCancelled()){d("Process finished due to cancellation: "+b.id);}else{d("Process finished: "+b.id);}r=false;});t.onPromiseCreated(u);return u;}
function f(){this.iIndex=0;this.nOffset=0;this.sOffsetType=f.OffsetType.Pixel;this.bIsInitial=true;}
f.OffsetType={Pixel:"Pixel",Percentage:"Percentage",PercentageOfBuffer:"PercentageOfBuffer"};
f.prototype.getIndex=function(){return this.iIndex;};
f.prototype.getOffset=function(){return this.nOffset;};
f.prototype.getOffsetType=function(){return this.sOffsetType;};
f.prototype.isOffsetInPixel=function(){return this.sOffsetType===f.OffsetType.Pixel;};
f.prototype.isInitial=function(){return this.bIsInitial;};
f.prototype.setPosition=function(i,a,O){d("ScrollPosition#setPosition(index: "+i+", offset: "+a+", offsetType: "+O+")");if(!f._isPositiveNumber(i)){return;}if(!f._isPositiveNumber(a)){this.nOffset=0;}this.setIndex(i);this.setOffset(a,O);};
f.prototype.setIndex=function(i){d("ScrollPosition#setIndex(index: "+i+")");if(!f._isPositiveNumber(i)){return;}this.bIsInitial=false;this.iIndex=i;};
f.prototype.setOffset=function(a,O){d("ScrollPosition#setOffset(offset: "+a+", offsetType: "+O+")");if(!f._isPositiveNumber(a)){return;}this.bIsInitial=false;this.sOffsetType=O in f.OffsetType?O:f.OffsetType.Pixel;if(this.isOffsetInPixel()){this.nOffset=Math.round(a);}else{this.nOffset=Math.min(a,1);}};
f.prototype.scrollRows=function(r){var N=this.getIndex()+r;var i=this.getOffset();if(!this.isOffsetInPixel()||N<0){i=0;}this.setPosition(Math.max(0,N),i);};
f._isPositiveNumber=function(a){return typeof a==="number"&&!isNaN(a)&&a>=0;};
var g=new window.WeakMap();var h=function(t){if(!t){return{};}if(!g.has(t)){g.set(t,{oHorizontalScrollbar:null,iHorizontalScrollPosition:null,oVerticalScrollbar:null,oVerticalScrollPosition:new f(t),pVerticalScrollUpdateProcess:null,oExternalVerticalScrollbar:null,bIsVerticalScrollbarExternal:false,mTimeouts:{},mAnimationFrames:{},mTouchSessionData:null,aOnRowsUpdatedPreprocessors:[]});}return g.get(t);};
h.destroy=function(t){delete g.delete(t);};
var j={UpdateFromFirstVisibleRow:{id:"UpdateFromFirstVisibleRow",rank:6},UpdateFromScrollPosition:{id:"UpdateFromScrollPosition",rank:5},RestoreScrollPosition:{id:"RestoreScrollPosition",rank:4},AdjustToTotalRowCount:{id:"AdjustToTotalRowCount",rank:3},OnRowsUpdated:{id:"OnRowsUpdated",rank:3},UpdateFromScrollbar:{id:"UpdateFromScrollbar",rank:2},UpdateFromViewport:{id:"UpdateFromViewport",rank:1},canStart:function(t,a){var b=h(t).pVerticalScrollUpdateProcess;var C=b?b.getInfo():null;if(b&&b.isRunning()&&C.rank>a.rank){d("Cannot start update process "+a.id+" - A higher-ranked update process is currently running ("+C.id+")",t);return false;}return true;},start:function(t,a,b){if(!j.canStart(t,a)){return;}if(h(t).pVerticalScrollUpdateProcess){h(t).pVerticalScrollUpdateProcess.cancel();}h(t).pVerticalScrollUpdateProcess=new P(b,a);}};var k={onScrollbarScroll:function(a){var N=a.target.scrollLeft;var O=a.target._scrollLeft;I.notifyScrollEvent&&I.notifyScrollEvent(a);if(N!==O){var s=k.getScrollAreas(this);a.target._scrollLeft=N;for(var i=0;i<s.length;i++){var b=s[i];if(b!==a.target&&b.scrollLeft!==N){b.scrollLeft=N;b._scrollLeft=N;}}h(this).iHorizontalScrollPosition=N;}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var a=s.getHorizontalScrollbar();if(a&&h(t).iHorizontalScrollPosition!==null){var b=k.getScrollAreas(t);for(var i=0;i<b.length;i++){var r=b[i];delete r._scrollLeft;}if(a.scrollLeft!==h(t).iHorizontalScrollPosition){a.scrollLeft=h(t).iHorizontalScrollPosition;}else{var u=q.Event("scroll");u.target=a;k.onScrollbarScroll.call(t,u);}}},onScrollbarMouseDown:function(a){this._getKeyboardExtension().setActionMode(false);},addEventListeners:function(t){var s=t._getScrollExtension();var a=s.getHorizontalScrollbar();var b=k.getScrollAreas(t);if(!s._onHorizontalScrollEventHandler){s._onHorizontalScrollEventHandler=k.onScrollbarScroll.bind(t);}for(var i=0;i<b.length;i++){b[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}if(a){if(!s._onHorizontalScrollbarMouseDownEventHandler){s._onHorizontalScrollbarMouseDownEventHandler=k.onScrollbarMouseDown.bind(t);}a.addEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=s.getHorizontalScrollbar();var b=k.getScrollAreas(t);if(s._onHorizontalScrollEventHandler){for(var i=0;i<b.length;i++){b[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete b[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}if(a&&s._onHorizontalScrollbarMouseDownEventHandler){a.removeEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);delete s._onHorizontalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var a=t.getDomRef();var s;if(a){s=Array.prototype.slice.call(t.getDomRef().querySelectorAll(".sapUiTableCtrlScr"));}var b=[t._getScrollExtension().getHorizontalScrollbar()].concat(s);return b.filter(function(i){return i!=null;});}};var m={performUpdateFromFirstVisibleRow:function(t,b){d("VerticalScrollingHelper.performUpdateFromFirstVisibleRow",t);j.start(t,j.UpdateFromFirstVisibleRow,function(r,a,i){T.Hook.call(t,H.Signal,"StartTableUpdate");i.onPromiseCreated=function(s){s.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(b===true){var O=function(){d("VerticalScrollingHelper.performUpdateFromFirstVisibleRow (async: rows update)",t);m._performUpdateFromFirstVisibleRow(t,i).then(r);return false;};m.addOnRowsUpdatedPreprocessor(t,O);i.addCancelListener(function(){var R=m.removeOnRowsUpdatedPreprocessor(t,O);if(R){r();}});}else{m._performUpdateFromFirstVisibleRow(t,i).then(r);}});},_performUpdateFromFirstVisibleRow:function(t,a){return m.adjustScrollPositionToFirstVisibleRow(t,a).then(function(){if(m.isIndexInBuffer(t,t.getFirstVisibleRow())){return m.adjustFirstVisibleRowToScrollPositionInBuffer(t,null,a);}return Promise.resolve();}).then(function(){return Promise.all([m.scrollViewport(t,a),m.scrollScrollbar(t,a)]);});},performUpdateFromScrollPosition:function(t){d("VerticalScrollingHelper.performUpdateFromScrollPosition",t);j.start(t,j.UpdateFromScrollPosition,function(r,a,b){T.Hook.call(t,H.Signal,"StartTableUpdate");b.onPromiseCreated=function(i){i.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};m.adjustFirstVisibleRowToScrollPosition(t,null,b).then(function(){if(b.isCancelled()){return;}var s=h(t).oVerticalScrollPosition;d("VerticalScrollingHelper.performUpdateFromScrollPosition (async: firstVisibleRow update)",t);if(s.getIndex()>t.getFirstVisibleRow()){s.setIndex(t.getFirstVisibleRow());if(T.isVariableRowHeightEnabled(t)){s.setOffset(1,f.OffsetType.Percentage);}else{s.setOffset(0);}}}).then(function(){return Promise.all([m.scrollViewport(t,b),m.scrollScrollbar(t,b)]);}).then(r);});},performUpdateFromScrollbar:function(t){var _=h(t);d("VerticalScrollingHelper.performUpdateFromScrollbar",t);clearTimeout(_.mTimeouts.largeDataScrolling);delete _.mTimeouts.largeDataScrolling;j.start(t,j.UpdateFromScrollbar,function(r,a,b){T.Hook.call(t,H.Signal,"StartTableUpdate");b.onPromiseCreated=function(i){i.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};t._getKeyboardExtension().setActionMode(false);if(t._bLargeDataScrolling){_.mTimeouts.largeDataScrolling=setTimeout(function(){delete _.mTimeouts.largeDataScrolling;if(t._getScrollExtension().getVerticalScrollbar()!=null){d("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling)",t);m._performUpdateFromScrollbar(t,b).then(r);}else{d("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling): No scrollbar",t);}},300);b.addCancelListener(function(){if(_.mTimeouts.largeDataScrolling!=null){clearTimeout(_.mTimeouts.largeDataScrolling);delete _.mTimeouts.largeDataScrolling;r();}});}else{m._performUpdateFromScrollbar(t,b).then(r);}});},_performUpdateFromScrollbar:function(t,a){return m.adjustScrollPositionToScrollbar(t,a).then(function(){return m.adjustFirstVisibleRowToScrollPosition(t,null,a);}).then(function(){if(T.isVariableRowHeightEnabled(t)){return m.scrollViewport(t,a);}if(a.isCancelled()){return Promise.resolve();}var s=h(t).oVerticalScrollPosition;var i=s.getIndex();var b=t._getMaxFirstRenderedRowIndex();var r=t._aRowHeights;switch(s.getOffsetType()){case f.OffsetType.Percentage:var u=Math.max(0,Math.min(r.length-1,i-b));s.setOffset(r[u]*s.getOffset());break;case f.OffsetType.PercentageOfBuffer:s.setOffset(0);break;default:}return Promise.resolve();});},performUpdateFromViewport:function(t){d("VerticalScrollingHelper.performUpdateFromViewport",t);j.start(t,j.UpdateFromViewport,function(r,a,b){T.Hook.call(t,H.Signal,"StartTableUpdate");b.onPromiseCreated=function(i){i.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};m.adjustScrollPositionToViewport(t,b).then(function(){return m.adjustFirstVisibleRowToScrollPosition(t,true,b);}).then(function(){return m.scrollScrollbar(t,b);}).then(r);});},onScrollbarScroll:function(a){I.notifyScrollEvent&&I.notifyScrollEvent(a);var b=a.target.scrollTop;var i=a.target._scrollTop;var s=b!==i;delete a.target._scrollTop;if(b===0&&!e(a.target)){d("VerticalScrollingHelper.onScrollbarScroll: Scrollbar is not connected with the DOM",this);}else if(s){d("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+b+" by interaction",this);m.performUpdateFromScrollbar(this);}else{d("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+b+" by API",this);}},onViewportScroll:function(a){if(!j.canStart(this,j.UpdateFromViewport)){return;}var b=a.target.scrollTop;var i=a.target._scrollTop;delete a.target._scrollTop;if(b!==i){d("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+b+" by interaction",this);m.performUpdateFromViewport(this);}else{d("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+b+" by API",this);}},adjustFirstVisibleRowToScrollPosition:function(t,s,a){if(a&&a.isCancelled()){return Promise.resolve();}s=s===true;var b=h(t).oVerticalScrollPosition;var N=b.getIndex();var O=t.getFirstVisibleRow();var i=m.isIndexInBuffer(t,N);var r=i;d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition:"+" Set \"firstVisibleRow\" from "+O+" to "+N,t);var u=t._setFirstVisibleRowIndex(N,{onScroll:true,suppressEvent:r,suppressRendering:s});if(!u){if(i){return m.adjustFirstVisibleRowToScrollPositionInBuffer(t,true,a);}return Promise.resolve();}return new Promise(function(v){var w=function(x){d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition (async: rows updated):"+" Reason "+x.getParameters().reason,this);if(i){m.adjustFirstVisibleRowToScrollPositionInBuffer(t,true,a).then(v);}else{v();}return false;};m.addOnRowsUpdatedPreprocessor(t,w);if(a){a.addCancelListener(function(){var R=m.removeOnRowsUpdatedPreprocessor(t,w);if(R){v();}});}});},adjustFirstVisibleRowToScrollPositionInBuffer:function(t,F,a){if(a&&a.isCancelled()){return Promise.resolve();}F=F===true;var s=h(t).oVerticalScrollPosition;var i=s.getIndex();if(!m.isIndexInBuffer(t,i)){d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPositionInBuffer:"+" Aborted - Scroll position is not in buffer",t);return Promise.resolve();}var N=i;var v=m.getScrollRangeOfViewport(t);var b=t._getMaxFirstRenderedRowIndex();var r=t._aRowHeights;var R;d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPositionInBuffer");if(s.getOffsetType()===f.OffsetType.PercentageOfBuffer){var u=v*s.getOffset();N=b;for(R=0;R<r.length;R++){var w=u-r[R];if(w>=0){u=w;N++;}else{break;}}}else{var x=Math.max(0,Math.min(r.length-1,i-b));var y=0;for(R=0;R<x;R++){y+=r[R];if(y>v){N=b+R;break;}}}if(i!==N||F){d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPositionInBuffer: Set \"firstVisibleRow\" to "+N,t);t._setFirstVisibleRowIndex(N,{onScroll:true,forceEvent:F,suppressRendering:true});}return Promise.resolve();},adjustScrollPositionToFirstVisibleRow:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}d("VerticalScrollingHelper.adjustScrollPositionToFirstVisibleRow",t);h(t).oVerticalScrollPosition.setPosition(t.getFirstVisibleRow());return Promise.resolve();},adjustScrollPositionToScrollbar:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}var s=h(t).oVerticalScrollPosition;var b=m.getScrollPositionOfScrollbar(t);var i=m.getScrollRange(t);var r=m.getScrollRangeRowFraction(t);var N=0;var u=0;var v=f.OffsetType.Percentage;var w;d("VerticalScrollingHelper.adjustScrollPositionToScrollbar",t);if(T.isVariableRowHeightEnabled(t)){if(m.isScrollPositionOfScrollbarInBuffer(t)){var B=m.getScrollRangeBuffer(t);var x=i-B;var y=b-x;var z=y/B;N=t._getMaxFirstRenderedRowIndex();if(m.isIndexInBuffer(t,s.getIndex())){var A=m.getScrollRangeOfViewport(t);var C=A*z;var R=t._aRowHeights;for(var F=0;F<R.length;F++){var G=C-R[F];if(G>=0){C=G;N++;}else{u=Math.round(C);v=f.OffsetType.Pixel;break;}}}else{u=z;v=f.OffsetType.PercentageOfBuffer;}}else{w=b/r;N=Math.floor(w);u=w-N;}}else{var J=i-b;var K=J<1;if(K){N=t._getMaxFirstVisibleRowIndex();u=0;v=f.OffsetType.Pixel;}else{w=b/r;N=Math.floor(w);u=w-N;}}s.setPosition(N,u,v);return Promise.resolve();},adjustScrollPositionToViewport:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}var s=h(t).oVerticalScrollPosition;var r=t._aRowHeights;var N=t._iRenderedFirstVisibleRow;var i=0;var b=m.getScrollPositionOfViewport(t);d("VerticalScrollingHelper.adjustScrollPositionToViewport",t);for(var R=0;R<r.length;R++){var u=b-r[R];if(u>=0){b=u;N++;}else{i=Math.round(b);break;}}s.setPosition(N,i);return Promise.resolve();},scrollViewport:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}var s=h(t).oVerticalScrollPosition;var v=t.getDomRef("tableCCnt");var i=m.getScrollRangeOfViewport(t);var r=t._aRowHeights;if(!T.isVariableRowHeightEnabled(t)||!v||!t.getBinding("rows")){d("VerticalScrollingHelper.scrollViewport: Aborted - Guard clause not passed",t);return Promise.resolve();}if(t._getFirstRenderedRowIndex()!==t._iRenderedFirstVisibleRow){d("VerticalScrollingHelper.scrollViewport: Aborted - Rows will be updated",t);return Promise.resolve();}if(i===0){d("VerticalScrollingHelper.scrollViewport: No overflow in viewport - Scroll to 0",t);t._setFirstVisibleRowIndex(0,{onScroll:true});s.setPosition(0);v.scrollTop=0;return Promise.resolve();}var b=s.getIndex();var u=t._getMaxFirstRenderedRowIndex();var w=0;var x=0;var R;d("VerticalScrollingHelper.scrollViewport");switch(s.getOffsetType()){case f.OffsetType.Pixel:case f.OffsetType.Percentage:if(m.isIndexInBuffer(t,b)){var y=0;x=Math.max(0,Math.min(r.length-1,b-u));for(R=0;R<x;R++){y+=r[R];if(y>i){s.setPosition(u+R,i-w);x=R;break;}else{w=y;}}}if(s.isOffsetInPixel()){s.setOffset(Math.min(s.getOffset(),r[x]));}else{s.setOffset(r[x]*s.getOffset());}w+=s.getOffset();if(w>i){s.setOffset(s.getOffset()-(w-i));w=i;}break;case f.OffsetType.PercentageOfBuffer:if(!m.isIndexInBuffer(t,b)){s.setOffset(0);break;}var z=i*s.getOffset();w=Math.round(z);for(R=0;R<r.length;R++){var A=z-r[R];if(A>=0){z=A;x++;}else{s.setPosition(u+x,Math.round(z));break;}}break;default:}d("VerticalScrollingHelper.scrollViewport: Scroll from "+v.scrollTop+" to "+w,t);v.scrollTop=w;v._scrollTop=v.scrollTop;return Promise.resolve();},scrollScrollbar:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}var _=h(t);var s=_.oVerticalScrollPosition;var i=s.getIndex();var b=m.getScrollRangeBuffer(t);var r=m.getScrollRange(t);var u=r-b;var v=0;var w=0;var x=m.getScrollRangeOfViewport(t);var R=t._aRowHeights;var y;d("VerticalScrollingHelper.scrollScrollbar",t);if(r===0||R.length===0){d("VerticalScrollingHelper.scrollScrollbar: No scrollable content",t);return Promise.resolve();}switch(s.getOffsetType()){case f.OffsetType.Pixel:case f.OffsetType.Percentage:if(m.isIndexInBuffer(t,i)){var z=0;y=Math.max(0,Math.min(R.length-1,i-t._getMaxFirstRenderedRowIndex()));for(var A=0;A<y;A++){z+=R[A];}if(s.isOffsetInPixel()){z+=Math.min(R[y],s.getOffset());}else{z+=R[y]*s.getOffset();}var B=Math.min(z/x,1);var C=b*B;v=u+C;}else{var F=m.getScrollRangeRowFraction(t);v=i*F;if(s.isOffsetInPixel()){y=Math.max(0,Math.min(R.length-1,i-t._iRenderedFirstVisibleRow));v+=F*Math.min(s.getOffset()/R[y],1);}else{v+=F*s.getOffset();}}break;case f.OffsetType.PercentageOfBuffer:if(m.isIndexInBuffer(t,i)){v=u+Math.round(x*s.getOffset());}break;default:}if(v>0&&v<0.5){w=1;}else if(v>=r-0.5&&v<r){w=r-1;}else{w=Math.round(v);}var G=t._getScrollExtension().getVerticalScrollbar();if(G){d("VerticalScrollingHelper.scrollScrollbar: Scroll from "+G.scrollTop+" to "+w,t);G.scrollTop=w;G._scrollTop=G.scrollTop;}else{d("VerticalScrollingHelper.scrollScrollbar: Not scrolled - No scrollbar available",t);}return Promise.resolve();},getScrollRange:function(t){var s=t._getScrollExtension();var v=s.getVerticalScrollHeight()-s.getVerticalScrollbarHeight();return Math.max(0,v);},getScrollRangeBuffer:function(t){if(!T.isVariableRowHeightEnabled(t)){return 0;}return V*t._getBaseRowHeight();},getScrollPositionOfScrollbar:function(t){var s=t._getScrollExtension();if(s.isVerticalScrollbarVisible()){return s.getVerticalScrollbar().scrollTop;}else{return 0;}},getScrollPositionOfViewport:function(t){var v=t?t.getDomRef("tableCCnt"):null;return v?v.scrollTop:0;},getScrollRangeRowFraction:function(t){var s=t._getScrollExtension();var v=t._getTotalRowCount()-t._getRowCounts().count;var i;if(T.isVariableRowHeightEnabled(t)){i=m.getScrollRange(t)-m.getScrollRangeBuffer(t);var b=s.getVerticalScrollHeight()===M;if(!b){i+=t._getBaseRowHeight();}}else{i=m.getScrollRange(t);}return i/Math.max(1,v);},isScrollPositionOfScrollbarInBuffer:function(t){if(!T.isVariableRowHeightEnabled(t)){return false;}var s=m.getScrollRange(t);var a=m.getScrollPositionOfScrollbar(t);var i=m.getScrollRangeBuffer(t);return s-a<=i;},isIndexInBuffer:function(t,i){if(!T.isVariableRowHeightEnabled(t)){return false;}return i>=t._getMaxFirstRenderedRowIndex();},getScrollRangeOfViewport:function(t){if(!t||!t._aRowHeights){return 0;}var r=t._aRowHeights;var v=t._getBaseRowHeight()*t._getRowCounts().count;if(t._getRowCounts().count>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var i=r.reduce(function(a,b){return a+b;},0)-v;if(i>0){i=Math.ceil(i);}return Math.max(0,i);},addOnRowsUpdatedPreprocessor:function(t,a){h(t).aOnRowsUpdatedPreprocessors.push(a);},removeOnRowsUpdatedPreprocessor:function(t,a){if(!a){h(t).aOnRowsUpdatedPreprocessors=[];return false;}var i=h(t).aOnRowsUpdatedPreprocessors.indexOf(a);if(i>-1){h(t).aOnRowsUpdatedPreprocessors.splice(i,1);return true;}return false;},onRowsUpdated:function(a){d("VerticalScrollingHelper.onRowsUpdated: Reason "+a.getParameters().reason,this);this._getScrollExtension().updateVerticalScrollbarVisibility();if(h(this).aOnRowsUpdatedPreprocessors.length>0){d("VerticalScrollingHelper.onRowsUpdated (preprocessors)",this);var b=h(this).aOnRowsUpdatedPreprocessors.reduce(function(b,i){var _=i.call(this,a);return!(b&&!_);},true);m.removeOnRowsUpdatedPreprocessor(this);if(!b){d("VerticalScrollingHelper.onRowsUpdated (preprocessors): Default prevented",this);return;}}if(!T.isVariableRowHeightEnabled(this)){d("VerticalScrollingHelper.onRowsUpdated: Aborted - Variable row heights not enabled",this);return;}var t=this;j.start(this,j.OnRowsUpdated,function(r,i,s){T.Hook.call(t,H.Signal,"StartTableUpdate");s.onPromiseCreated=function(u){u.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};m.scrollViewport(t,s).then(function(){return Promise.all([m.adjustFirstVisibleRowToScrollPosition(t,true,s),m.scrollScrollbar(t,s)]);}).then(r);});},restoreScrollPosition:function(t,b){d("VerticalScrollingHelper.restoreScrollPosition",t);j.start(t,j.RestoreScrollPosition,function(r,a,i){T.Hook.call(t,H.Signal,"StartTableUpdate");i.onPromiseCreated=function(s){s.then(function(){if(!i.isCancelled()){m._restoreScrollPosition(t);}}).finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(b!==true){r();return;}var O=function(){d("VerticalScrollingHelper.restoreScrollPosition (async: rows updated)",t);r();return false;};m.addOnRowsUpdatedPreprocessor(t,O);i.addCancelListener(function(){var R=m.removeOnRowsUpdatedPreprocessor(t,O);if(R){r();}});});},_restoreScrollPosition:function(t){var s=h(t).oVerticalScrollPosition;var b=s.isInitial();d("VerticalScrollingHelper.restoreScrollPosition: "+"Scroll position is"+(b?" ":" not ")+"initial",t);if(b){m.performUpdateFromFirstVisibleRow(t);}else{m.performUpdateFromScrollPosition(t);}},adjustToTotalRowCount:function(t){d("VerticalScrollingHelper.adjustToTotalRowCount",t);var s=t._getScrollExtension();s.updateVerticalScrollbarVisibility();s.updateVerticalScrollHeight();j.start(t,j.AdjustToTotalRowCount,function(r,a,b){T.Hook.call(t,H.Signal,"StartTableUpdate");b.onPromiseCreated=function(i){i.then(function(){if(b.isCancelled()||h(t).oVerticalScrollPosition.isInitial()){return;}m.scrollViewport(t);m.performUpdateFromScrollPosition(t);}).finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(h(t).oVerticalScrollPosition.isInitial()){r();}else{var O=function(){d("VerticalScrollingHelper.adjustToTotalRowCount (async: rows updated)",t);r();return false;};m.addOnRowsUpdatedPreprocessor(t,O);b.addCancelListener(function(){var R=m.removeOnRowsUpdatedPreprocessor(t,O);if(R){r();}});}});},addEventListeners:function(t){var s=t._getScrollExtension();var a=m.getScrollAreas(t);var v=t.getDomRef("tableCCnt");if(!s._onVerticalScrollEventHandler){s._onVerticalScrollEventHandler=m.onScrollbarScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v){if(!s._onViewportScrollEventHandler){s._onViewportScrollEventHandler=m.onViewportScroll.bind(t);}v.addEventListener("scroll",s._onViewportScrollEventHandler);}t.attachEvent("_rowsUpdated",m.onRowsUpdated);},removeEventListeners:function(t){var s=t._getScrollExtension();var a=m.getScrollAreas(t);var v=t.getDomRef("tableCCnt");if(s._onVerticalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v&&s._onViewportScrollEventHandler){v.removeEventListener("scroll",s._onViewportScrollEventHandler);delete s._onViewportScrollEventHandler;}t.detachEvent("_rowsUpdated",m.onRowsUpdated);},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(a){return a!=null;});}};var n={onMouseWheelScrolling:function(O,a){var s=this._getScrollExtension();var v=Math.abs(a.deltaY)>Math.abs(a.deltaX);var i=v?a.deltaY:a.deltaX;var b=v&&a.shiftKey||!v;var r=i>0;var t=false;if(i===0){return;}if(b&&(O.scrollDirection===c.HORIZONAL||O.scrollDirection===c.BOTH)){var u=s.getHorizontalScrollbar();if(a.deltaMode!==window.WheelEvent.DOM_DELTA_PIXEL){var w=T.Column.getMinColumnWidth();i=r?w:-w;}if(r){t=u.scrollLeft===u.scrollWidth-u.offsetWidth;}else{t=u.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!t){a.preventDefault();a.stopPropagation();this._getKeyboardExtension().setActionMode(false);u.scrollLeft=u.scrollLeft+i;}}else if(!b&&(O.scrollDirection===c.VERTICAL||O.scrollDirection===c.BOTH)){var x=s.getVerticalScrollbar();var y=h(this).oVerticalScrollPosition;if(r){t=x.scrollTop===x.scrollHeight-x.offsetHeight;}else{t=x.scrollTop===0;}if(!s.isVerticalScrollbarVisible()||t){return;}a.preventDefault();a.stopPropagation();if(a.deltaMode===window.WheelEvent.DOM_DELTA_PIXEL){var z=i/this._getDefaultRowHeight();if(z>=0){y.scrollRows(Math.max(1,Math.floor(z)));}else{y.scrollRows(Math.min(-1,Math.ceil(z)));}}else if(a.deltaMode===window.WheelEvent.DOM_DELTA_LINE){y.scrollRows(i);}else if(a.deltaMode===window.WheelEvent.DOM_DELTA_PAGE){y.scrollRows(i*this._getRowCounts().count);}this._getKeyboardExtension().setActionMode(false);m.performUpdateFromScrollPosition(this);}},onTouchStart:function(O,a){if(a.type==="touchstart"||a.pointerType==="touch"){var s=this._getScrollExtension();var b=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=a.touches?a.touches[0]:a;h(this).mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v?v.scrollTop:0,initialScrollLeft:b?b.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(O,a){if(a.type!=="touchmove"&&a.pointerType!=="touch"){return;}var s=this._getScrollExtension();var t=h(this).mTouchSessionData;if(!t){return;}var b=a.touches?a.touches[0]:a;var i=(b.pageX-t.initialPageX);var r=(b.pageY-t.initialPageY);var u=false;if(!t.touchMoveDirection){if(i===0&&r===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(r)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var v=s.getHorizontalScrollbar();if(v&&(O.scrollDirection===c.HORIZONAL||O.scrollDirection===c.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(i<0){t.initialScrolledToEnd=v.scrollLeft===v.scrollWidth-v.offsetWidth;}else{t.initialScrolledToEnd=v.scrollLeft===0;}}if(!t.initialScrolledToEnd){v.scrollLeft=t.initialScrollLeft-i;u=true;}}break;case"vertical":var w=s.getVerticalScrollbar();if(w&&(O.scrollDirection===c.VERTICAL||O.scrollDirection===c.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(r<0){t.initialScrolledToEnd=w.scrollTop===w.scrollHeight-w.offsetHeight;}else{t.initialScrolledToEnd=w.scrollTop===0;}}if(!t.initialScrolledToEnd){w.scrollTop=t.initialScrollTop-r;u=true;}}break;default:}if(u){a.preventDefault();}},addEventListeners:function(t){var s=t._getScrollExtension();var a=n.getEventListenerTargets(t);s._mMouseWheelEventListener=this.addMouseWheelEventListener(a,t,{scrollDirection:c.BOTH});s._mTouchEventListener=this.addTouchEventListener(a,t,{scrollDirection:c.BOTH});},addMouseWheelEventListener:function(a,t,O){var b=n.onMouseWheelScrolling.bind(t,O);for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",b);}return{wheel:b};},addTouchEventListener:function(a,t,O){var b=n.onTouchStart.bind(t,O);var r=n.onTouchMoveScrolling.bind(t,O);var s={};for(var i=0;i<a.length;i++){if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",b);a[i].addEventListener("pointermove",r,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",b);a[i].addEventListener("touchmove",r);}}if(D.support.pointer&&D.system.desktop){s={pointerdown:b,pointermove:r};}else if(D.support.touch){s={touchstart:b,touchmove:r};}return s;},removeEventListeners:function(t){var s=t._getScrollExtension();var a=n.getEventListenerTargets(t);function r(b,u){for(var v in u){var w=u[v];if(w){b.removeEventListener(v,w);}}}for(var i=0;i<a.length;i++){r(a[i],s._mMouseWheelEventListener);r(a[i],s._mTouchEventListener);}delete s._mMouseWheelEventListener;delete s._mTouchEventListener;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(b){return b!=null;});}};var o={onBeforeRendering:function(a){this._getScrollExtension()._clearCache();},onAfterRendering:function(a){var s=this._getScrollExtension();var r=a!=null&&a.isMarked("renderRows");if(r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}else{m.restoreScrollPosition(this,this.getBinding("rows")!=null);}k.restoreScrollPosition(this);},onfocusin:function(a){var r;var C=T.getCellInfo(a.target);var b=this._getScrollExtension().getHorizontalScrollbar();if(C.isOfType(T.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(T.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r&&b&&C.columnIndex>=this.getComputedFixedColumnCount()){var $=q(b);var i=C.cell[0];var s=this._bRtlMode?$.scrollLeftRTL():b.scrollLeft;var R=r.clientWidth;var t=i.offsetLeft;var u=t+i.offsetWidth;var O=t-s;var v=u-R-s;var N;if(O<0&&v<0){N=s+O;}else if(v>0&&O>0){N=s+v;}if(N!=null){if(this._bRtlMode){$.scrollLeftRTL(N);}else{b.scrollLeft=N;}}}var w=T.getParentCell(this,a.target);if(w){var x=this;var y=function(){var z=w.find(".sapUiTableCellInner");if(z.length>0){if(x._bRtlMode){z.scrollLeftRTL(z[0].scrollWidth-z[0].clientWidth);}else{z[0].scrollLeft=0;}z[0].scrollTop=0;}T.Hook.call(x,H.Signal,"EndFocusHandling");T.Hook.call(x,H.Signal,"EndTableUpdate");};T.Hook.call(this,H.Signal,"StartTableUpdate");T.Hook.call(this,H.Signal,"StartFocusHandling");Promise.resolve().then(function(){if(D.browser.safari){window.setTimeout(y,0);}else{y();}});}}};
var p=E.extend("sap.ui.table.extensions.Scrolling",{
_init:function(t,s,a){T.addDelegate(t,o,t);return"ScrollExtension";},
_attachEvents:function(){var t=this.getTable();k.addEventListeners(t);m.addEventListeners(t);n.addEventListeners(t);},
_detachEvents:function(){var t=this.getTable();k.removeEventListeners(t);m.removeEventListeners(t);n.removeEventListeners(t);},
destroy:function(){var t=this.getTable();T.removeDelegate(t,o);this._clearCache();if(h(t).pVerticalScrollUpdateProcess){h(t).pVerticalScrollUpdateProcess.cancel();h(t).pVerticalScrollUpdateProcess=null;}h.destroy(t);E.prototype.destroy.apply(this,arguments);}
});
p.prototype.scrollVertically=function(b,a,A,B){var t=this.getTable();if(!t){return false;}b=b===true;a=a===true;A=A===true;var s=false;var i=t._getTotalRowCount();var r=t._getRowCounts();var F=t.getFirstVisibleRow();var u=a?r.scrollable:1;if(b){if(F+r.count<i){if(B){B();}if(A){setTimeout(function(){t.setFirstVisibleRow(Math.min(F+u,i-r.count));},0);}else{t.setFirstVisibleRow(Math.min(F+u,i-r.count));}s=true;}}else if(F>0){if(B){B();}if(A){setTimeout(function(){t.setFirstVisibleRow(Math.max(F-u,0));},0);}else{t.setFirstVisibleRow(Math.max(F-u,0));}s=true;}return s;};
p.prototype.scrollVerticallyMax=function(b){var t=this.getTable();if(!t){return false;}b=b===true;var s=false;var F=t.getFirstVisibleRow();if(b){var i=t._getTotalRowCount()-T.getNonEmptyVisibleRowCount(t);if(F<i){t.setFirstVisibleRow(i);s=true;}}else if(F>0){t.setFirstVisibleRow(0);s=true;}return s;};
p.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t&&!t._bInvalid&&!h(t).oHorizontalScrollbar){h(t).oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return h(t).oHorizontalScrollbar||null;};
p.prototype.getVerticalScrollbar=function(i){var t=this.getTable();var b=this.isVerticalScrollbarExternal();if(t&&!t._bInvalid&&!h(t).oVerticalScrollbar){h(t).oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);if(!h(t).oVerticalScrollbar&&b){h(t).oVerticalScrollbar=h(t).oExternalVerticalScrollbar;}}var s=h(t).oVerticalScrollbar;if(s&&!b&&!i&&!e(s)){return null;}return s||null;};
p.prototype.isHorizontalScrollbarVisible=function(){var a=this.getHorizontalScrollbar();return a!=null&&!a.classList.contains("sapUiTableHidden");};
p.prototype.isVerticalScrollbarVisible=function(){var v=this.getVerticalScrollbar();return v!=null&&!v.classList.contains("sapUiTableHidden");};
p.prototype.isVerticalScrollbarExternal=function(){return h(this.getTable()).bIsVerticalScrollbarExternal;};
p.prototype.markVerticalScrollbarAsExternal=function(s){if(s){h(this.getTable()).bIsVerticalScrollbarExternal=true;h(this.getTable()).oExternalVerticalScrollbar=s;}};
p.prototype.updateHorizontalScrollbar=function(t){var a=this.getTable();var b=this.getHorizontalScrollbar();if(!a||!b||!t){return;}var $=a.$();var C=t.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,a._getColumnsWidth(a.getComputedFixedColumnCount()));}var i=C>t.tableCtrlScrWidth;if(i){if(!this.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");b.classList.remove("sapUiTableHidden");if(D.browser.safari){var r=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");r.outerWidth(C);}}var s=t.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){s+=t.tableRowHdrScrWidth;}if(a._bRtlMode){b.style.marginRight=s+"px";b.style.marginLeft="";}else{b.style.marginLeft=s+"px";b.style.marginRight="";}var u=a.getDomRef("hsb-content");if(u){u.style.width=C+"px";}}if(!i&&this.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");b.classList.add("sapUiTableHidden");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}};
p.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}v.style.maxHeight=this.getVerticalScrollbarHeight()+"px";v._scrollTop=v.scrollTop;};
p.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(!t){return 0;}return t._getRowCounts().scrollable*t._getBaseRowHeight();};
p.prototype.updateVerticalScrollbarPosition=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var a=t.getDomRef("tableCCnt");if(a){var i=a.offsetTop;var b=t.getDomRef("vsb-bg");if(b){b.style.top=i+"px";}if(t._getRowCounts().fixedTop>0){i+=t._iVsbTop;}v.style.top=i+"px";}};
p.prototype.updateVerticalScrollPosition=function(b){var t=this.getTable();if(!t){return;}m.performUpdateFromFirstVisibleRow(t,b);};
p.prototype.adjustToTotalRowCount=function(){m.adjustToTotalRowCount(this.getTable());};
p.prototype.restoreVerticalScrollPosition=function(){m.restoreScrollPosition(this.getTable());};
p.prototype.updateVerticalScrollHeight=function(){var v=this.getVerticalScrollbar();var a=v?v.firstChild:null;if(!a){return;}a.style.height=this.getVerticalScrollHeight()+"px";v._scrollTop=v.scrollTop;};
p.prototype.getVerticalScrollHeight=function(b){var t=this.getTable();if(!t){return 0;}var i=t._getTotalRowCount();var v=t._getRowCounts().count;var B=t._getBaseRowHeight();var r;var s;if(T.isVariableRowHeightEnabled(t)){r=Math.max(i,v+1);s=B*(r-1)+m.getScrollRangeBuffer(t);}else{r=Math.max(i,v);s=B*r;}if(b===true){return s;}else{return Math.min(M,s);}};
p.prototype.updateVerticalScrollbarVisibility=function(){var t=this.getTable();var a=t?t.getDomRef():null;var v=this.getVerticalScrollbar();if(!a||!v){return;}var b=this.isVerticalScrollbarRequired();if(b&&!this.isVerticalScrollbarVisible()){if(!this.isVerticalScrollbarExternal()){a.classList.add("sapUiTableVScr");}v.classList.remove("sapUiTableHidden");}if(!b&&this.isVerticalScrollbarVisible()){a.classList.remove("sapUiTableVScr");v.classList.add("sapUiTableHidden");}};
p.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(!t){return false;}return T.isVariableRowHeightEnabled(t)&&m.getScrollRangeOfViewport(t)>0||t._getTotalRowCount()>t._getRowCounts().count;};
p.prototype.registerForMouseWheel=function(a,O){var t=this.getTable();if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){return n.addMouseWheelEventListener(a,t,O);}else{L.error("This method can only be used with synchronization enabled.",t,"sap.ui.table.extensions.Scrolling#registerForMouseWheel");return null;}};
p.prototype.registerForTouch=function(a,O){var t=this.getTable();if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){return n.addTouchEventListener(a,t,O);}else{L.error("This method can only be used with synchronization enabled.",t,"sap.ui.table.extensions.Scrolling#registerForTouch");return null;}};
p.prototype._clearCache=function(){h(this.getTable()).oVerticalScrollbar=null;h(this.getTable()).oHorizontalScrollbar=null;};
p.ScrollDirection=c;return p;});
sap.ui.predefine('sap/ui/table/extensions/Synchronization',["./ExtensionBase","../Table","../utils/TableUtils","../library","sap/base/Log"],function(E,T,a,l,L){"use strict";var b={setRowSelection:function(i,s){var t=this.getTable();var r=t.getRows()[i];if(r&&s!=null){a.toggleRowSelection(t,r.getIndex(),s);}},setRowHover:function(i,h){var t=this.getTable();var r=t.getRows()[i];if(r&&h!=null){r._setHovered(h);}},addVerticalScrollingListener:function(C){var t=this.getTable();var s=t._getScrollExtension();var d=s.constructor.ScrollDirection;if(C){s.registerForMouseWheel(C.wheelAreas,{scrollDirection:d.VERTICAL});s.registerForTouch(C.touchAreas,{scrollDirection:d.VERTICAL});}},placeVerticalScrollbarAt:function(h){var t=this.getTable();var s=t._getScrollExtension();if(!h){throw new Error("The HTMLElement in which the vertical scrollbar should be placed must be specified.");}if(!s.isVerticalScrollbarExternal()){var r=sap.ui.getCore().createRenderManager();t.getRenderer().renderVSbExternal(r,t);r.flush(h);var e=h.querySelector("#"+t.getId()+"-"+l.SharedDomRef.VerticalScrollBar);s.markVerticalScrollbarAsExternal(e);t.invalidate();}else{h.appendChild(s.getVerticalScrollbar());s.restoreVerticalScrollPosition();}},renderHorizontalScrollbar:function(r,i,s){var t=this.getTable();if(i==null){throw new Error("The id must be specified.");}t.getRenderer().renderHSbExternal(r,t,i,s);}};var c={onBeforeRendering:function(e){var s=this._getSyncExtension();var r=e&&e.isMarked("renderRows");var C=this.getDomRef("tableCCnt");if(!r&&C&&s._onTableContainerScrollEventHandler){C.removeEventListener("scroll",s._onTableContainerScrollEventHandler);delete s._onTableContainerScrollEventHandler;}},onAfterRendering:function(e){var s=this._getScrollExtension();var r=e&&e.isMarked("renderRows");var C=this.getDomRef("tableCCnt");if(s.isVerticalScrollbarExternal()&&!r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}if(!r){var o=this._getSyncExtension();if(!o._onTableContainerScrollEventHandler){o._onTableContainerScrollEventHandler=function(e){o.syncInnerVerticalScrollPosition(e.target.scrollTop);};}C.addEventListener("scroll",o._onTableContainerScrollEventHandler);}}};
var S=E.extend("sap.ui.table.extensions.Synchronization",{
_init:function(t,s,m){this._delegate=c;this._oPublicInterface={syncRowSelection:b.setRowSelection.bind(this),syncRowHover:b.setRowHover.bind(this),registerVerticalScrolling:b.addVerticalScrollingListener.bind(this),placeVerticalScrollbarAt:b.placeVerticalScrollbarAt.bind(this),renderHorizontalScrollbar:b.renderHorizontalScrollbar.bind(this)};a.addDelegate(t,this._delegate,t);return"SyncExtension";},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;this._oPublicInterface=null;E.prototype.destroy.apply(this,arguments);}
});
S.prototype.syncRowCount=function(C){this.callInterfaceHook("rowCount",arguments);};
S.prototype.syncRowSelection=function(i,s){this.callInterfaceHook("rowSelection",arguments);};
S.prototype.syncRowHover=function(i,h){this.callInterfaceHook("rowHover",arguments);};
S.prototype.syncRowHeights=function(h){return this.callInterfaceHook("rowHeights",arguments);};
S.prototype.syncInnerVerticalScrollPosition=function(s){this.callInterfaceHook("innerVerticalScrollPosition",arguments);};
S.prototype.syncLayout=function(m){this.callInterfaceHook("layout",arguments);};
S.prototype.callInterfaceHook=function(h,A){var C={};C[h]=Array.prototype.slice.call(A);L.debug("sap.ui.table.extensions.Synchronization","Sync "+h+"("+C[h]+")",this.getTable());return a.dynamicCall(this._oPublicInterface,C);};
S.prototype.getInterface=function(){return this._oPublicInterface;};
return S;});
sap.ui.predefine('sap/ui/table/library',['sap/ui/core/Core','sap/ui/model/TreeAutoExpandMode','sap/ui/core/library','sap/ui/unified/library'],function(C,T){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.82.2",dependencies:["sap.ui.core","sap.ui.unified"],designtime:"sap/ui/table/designtime/library.designtime",types:["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.TreeAutoExpandMode"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.CreationRow","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings","sap.ui.table.rowmodes.RowMode","sap.ui.table.rowmodes.FixedRowMode","sap.ui.table.rowmodes.InteractiveRowMode","sap.ui.table.rowmodes.AutoRowMode","sap.ui.table.plugins.MultiSelectionPlugin","sap.ui.table.plugins.SelectionPlugin"],extensions:{flChangeHandlers:{"sap.ui.table.Column":{"propertyChange":"default"},"sap.ui.table.Table":{"moveElements":"default"},"sap.ui.table.AnalyticalTable":{"moveElements":"default"}},"sap.ui.support":{publicRules:true}}});var t=sap.ui.table;t.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};t.RowActionType={Custom:"Custom",Navigation:"Navigation",Delete:"Delete"};t.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};t.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};t.SortOrder={Ascending:"Ascending",Descending:"Descending"};t.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};t.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};t.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};t.ColumnHeader=t.Column;t.TreeAutoExpandMode=T;if(!t.TableHelper){t.TableHelper={addTableClass:function(){return"";},createLabel:function(c){throw new Error("no Label control available!");},createTextView:function(c){throw new Error("no TextView control available!");},bFinal:false};}return t;});
sap.ui.predefine('sap/ui/table/plugins/BindingSelection',['./SelectionPlugin',"../utils/TableUtils",'../library'],function(S,T,l){"use strict";var a=l.SelectionMode;
var B=S.extend("sap.ui.table.plugins.BindingSelection",{metadata:{library:"sap.ui.table",events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});
B.prototype.onDeactivate=function(t){S.prototype.onDeactivate.apply(this,arguments);d(this,this.getTableBinding());};
B.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:T.hasSelectAll(this.getTable())}};};
B.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){this.getTable()._toggleSelectAll();}};
B.prototype.onKeyboardShortcut=function(t){if(t==="toggle"){this.getTable()._toggleSelectAll();}else if(t==="clear"){this.clearSelection();}};
B.prototype.addSelectionInterval=function(i,I){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.addSelectionInterval){if(this._getSelectionMode()===a.Single){i=I;o.setSelectionInterval(i,I);}o.addSelectionInterval(i,I);}};
B.prototype.clearSelection=function(){var o=this.getTableBinding();if(o&&o.clearSelection){o.clearSelection();}};
B.prototype.getSelectedIndex=function(){var o=this.getTableBinding();if(o&&o.findNode){return o.getSelectedIndex();}else{return-1;}};
B.prototype.getSelectedIndices=function(){var o=this.getTableBinding();if(this._getSelectionMode()===a.Single){var s=this.getSelectedIndex();if(s===-1){return[];}return[s];}if(o&&o.findNode&&o.getSelectedIndices){return o.getSelectedIndices();}else{return[];}};
B.prototype.getSelectableCount=function(){var o=this.getTableBinding();if(!o){return 0;}else if(o.getGrandTotalContextInfo){var r=o.getGrandTotalContextInfo();return r?r.totalNumberOfLeafs:0;}else{return o.getLength();}};
B.prototype.getSelectedCount=function(){var o=this.getTableBinding();if(o&&o.getSelectedNodesCount){return o.getSelectedNodesCount();}else{return 0;}};
B.prototype.isIndexSelectable=function(i){var o=this.getTableBinding();if(o){return o.isIndexSelectable(i);}else{return false;}};
B.prototype.isIndexSelected=function(i){var o=this.getTableBinding();if(this._getSelectionMode()===a.Single){if(i<0){return false;}return i===this.getSelectedIndex();}if(o&&o.isIndexSelected){return o.isIndexSelected(i);}else{return false;}};
B.prototype.removeSelectionInterval=function(i,I){var o=this.getTableBinding();if(o&&o.findNode&&o.removeSelectionInterval){o.removeSelectionInterval(i,I);}};
B.prototype.selectAll=function(){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.selectAll){o.selectAll();}};
B.prototype.setSelectedIndex=function(i){if(this._getSelectionMode()===a.None){return;}if(i===-1){this.clearSelection();}else{var o=this.getTableBinding();if(o&&o.setSelectedIndex){o.setSelectedIndex(i);}}};
B.prototype.setSelectionInterval=function(i,I){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.setSelectionInterval){if(this._getSelectionMode()===a.Single){i=I;}o.setSelectionInterval(i,I);}};
B.prototype.setSelectionMode=function(s){var o=this._getSelectionMode();S.prototype._setSelectionMode.apply(this,arguments);if(this._getSelectionMode()!==o){this.clearSelection();}return this;};
B.prototype._getHighestSelectableIndex=function(){var o=this.getTableBinding();return o?o.getLength()-1:-1;};
B.prototype.onTableRowsBound=function(o){S.prototype.onTableRowsBound.apply(this,arguments);b(this,o);};
function b(p,o){if(o){o.attachChange(p._onBindingChange,p);o.attachSelectionChanged(p._onSelectionChange,p);}}
function d(p,o){if(o){o.detachChange(p._onBindingChange,p);o.detachSelectionChanged(p._onSelectionChange,p);}}
B.prototype._onBindingChange=function(e){var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r==="sort"||r==="filter"){this.clearSelection();}};
B.prototype._onSelectionChange=function(e){var r=e.getParameter("rowIndices");var s=e.getParameter("selectAll");this.fireSelectionChange({rowIndices:r,selectAll:s});};
return B;});
sap.ui.predefine('sap/ui/table/plugins/MultiSelectionPlugin',["./SelectionPlugin","./SelectionModelSelection","./BindingSelection","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool","sap/base/Log"],function(S,a,B,l,T,I,b,L){"use strict";var c=l.SelectionMode;
var M=S.extend("sap.ui.table.plugins.MultiSelectionPlugin",{metadata:{properties:{limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:c.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},limitReached:{type:"boolean"},customPayload:{type:"object"}}}}}});
M.prototype.init=function(){S.prototype.init.apply(this,arguments);var i=new I({src:b.getIconURI(T.ThemeParameters.resetIcon),useIconTooltip:false});i.addStyleClass("sapUiTableSelectClear");this._bLimitReached=false;this._bLimitDisabled=this.getLimit()===0;this.oInnerSelectionPlugin=null;this.oDeselectAllIcon=i;this._oNotificationPopover=null;};
M.prototype.exit=function(){if(this.oDeselectAllIcon){this.oDeselectAllIcon.destroy();this.oDeselectAllIcon=null;}if(this._oNotificationPopover){this._oNotificationPopover.destroy();this._oNotificationPopover=null;}};
M.prototype.onActivate=function(o){S.prototype.onActivate.apply(this,arguments);this.oInnerSelectionPlugin=o._createLegacySelectionPlugin();this.oInnerSelectionPlugin.attachSelectionChange(this._onSelectionChange,this);o.addAggregation("_hiddenDependents",this.oInnerSelectionPlugin);o.setProperty("selectionMode",this.getSelectionMode());};
M.prototype.onDeactivate=function(o){S.prototype.onDeactivate.apply(this,arguments);o.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);if(this._oNotificationPopover){this._oNotificationPopover.close();}if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.destroy();this.oInnerSelectionPlugin=null;}};
M.prototype.getRenderConfig=function(){return{headerSelector:{type:this._bLimitDisabled?"toggle":"clear",icon:this.oDeselectAllIcon,visible:this.getSelectionMode()===c.MultiToggle&&this.getShowHeaderSelector(),enabled:this._bLimitDisabled||this.getSelectedCount()>0}};};
M.prototype.onHeaderSelectorPress=function(){var r=this.getRenderConfig();if(!r.headerSelector.visible||!r.headerSelector.enabled){return;}if(r.headerSelector.type==="toggle"){t(this);}else if(r.headerSelector.type==="clear"){this.clearSelection();}};
M.prototype.onKeyboardShortcut=function(s){if(s==="toggle"){if(this._bLimitDisabled){t(this);}}else if(s==="clear"){this.clearSelection();}};
function t(P){if(P.getSelectableCount()>P.getSelectedCount()){P.selectAll();}else{P.clearSelection();}}
M.prototype.setSelectionMode=function(s){var o=this.getSelectionMode();var f=this.getParent();if(f){f.setProperty("selectionMode",s,true);}this.setProperty("selectionMode",s);if(this.getSelectionMode()!==o){this.clearSelection();}return this;};
M.prototype.setLimit=function(i){if(typeof i==="number"&&i<0){L.warning("The limit must be greater than or equal to 0",this);return this;}this.setProperty("limit",i,!!this.getLimit()===!!i);this._bLimitDisabled=i===0;return this;};
M.prototype.setEnableNotification=function(n){this.setProperty("enableNotification",n,true);return this;};
M.prototype.isLimitReached=function(){return this._bLimitReached;};
M.prototype.setLimitReached=function(f){this._bLimitReached=f;};
M.prototype.selectAll=function(E){if(!this._bLimitDisabled){return Promise.reject(new Error("Not possible if the limit is enabled"));}var s=this.getSelectableCount();if(s===0){return Promise.reject(new Error("Nothing to select"));}return this.addSelectionInterval(0,this._getHighestSelectableIndex(),E);};
function p(P,i,f,A){var h=P._getHighestSelectableIndex();if(i<0&&f<0||i>h&&f>h){return Promise.reject(new Error("Out of range"));}i=Math.min(Math.max(0,i),h);f=Math.min(Math.max(0,f),h);var g=P.getLimit();var r=f<i;var G=r?f:i;var j;if(A&&P.isIndexSelected(i)){if(r){i--;}else if(i!==f){i++;G++;}}j=Math.abs(f-i)+1;if(!P._bLimitDisabled){P.setLimitReached(j>g);if(P.isLimitReached()){if(r){f=i-g+1;}else{f=i+g-1;}j=g+1;}}return d(P.getTableBinding(),G,j).then(function(){return{indexFrom:i,indexTo:f};});}
M.prototype.setSelectionInterval=function(i,f,E){var s=this.getSelectionMode();if(s===c.None){return Promise.reject(new Error("SelectionMode is '"+c.None+"'"));}if(s===c.Single){i=f;}return p(this,i,f,false).then(function(m){this._oCustomEventPayloadTmp=E;this.oInnerSelectionPlugin.setSelectionInterval(m.indexFrom,m.indexTo);delete this._oCustomEventPayloadTmp;return this._scrollTableToIndex(m.indexTo,m.indexFrom>m.indexTo);}.bind(this));};
M.prototype.setSelectedIndex=function(i,E){return this.setSelectionInterval(i,i,E);};
M.prototype.addSelectionInterval=function(i,f,E){var s=this.getSelectionMode();if(s===c.None){return Promise.reject(new Error("SelectionMode is '"+c.None+"'"));}if(s===c.Single){return this.setSelectionInterval(f,f);}if(s===c.MultiToggle){return p(this,i,f,true).then(function(m){this._oCustomEventPayloadTmp=E;this.oInnerSelectionPlugin.addSelectionInterval(m.indexFrom,m.indexTo);delete this._oCustomEventPayloadTmp;return this._scrollTableToIndex(m.indexTo,m.indexFrom>m.indexTo);}.bind(this));}};
M.prototype._scrollTableToIndex=function(i,r){var o=this.getParent();if(!o||!this.isLimitReached()){return Promise.resolve();}var f=o.getFirstVisibleRow();var R=o._getRowCounts();var g=f+R.scrollable-1;var E=false;if(i<f||i>g){var n=r?i-R.fixedTop-1:i-R.scrollable-R.fixedTop+2;E=o._setFirstVisibleRowIndex(Math.max(0,n));}this._showNotificationPopoverAtIndex(i);return new Promise(function(h){if(E){o.attachEventOnce("_rowsUpdated",h);}else{h();}});};
M.prototype._showNotificationPopoverAtIndex=function(i){var f=this;var P=this._oNotificationPopover;var o=this.getParent();var r=o.getRows()[i-o._getFirstRenderedRowIndex()];var s=T.getResourceText("TBL_SELECT_LIMIT_TITLE");var m=T.getResourceText("TBL_SELECT_LIMIT",[this.getLimit()]);if(!this.getEnableNotification()){return Promise.resolve();}return new Promise(function(g){sap.ui.require(["sap/m/Popover","sap/m/Bar","sap/m/Title","sap/m/Text","sap/m/HBox","sap/ui/core/library","sap/m/library"],function(h,j,k,n,H,q,u){if(!P){P=new h(f.getId()+"-notificationPopover",{customHeader:[new j({contentMiddle:[new H({items:[new I({src:"sap-icon://message-warning",color:q.IconColor.Critical}).addStyleClass("sapUiTinyMarginEnd"),new k({text:s,level:q.TitleLevel.H2})],renderType:u.FlexRendertype.Bare,justifyContent:u.FlexJustifyContent.Center,alignItems:u.FlexAlignItems.Center})]})],content:new n({text:m})});P.addStyleClass("sapUiContentPadding");f._oNotificationPopover=P;}else{P.getContent()[0].setText(m);}o.detachFirstVisibleRowChanged(f.onFirstVisibleRowChange,f);o.attachFirstVisibleRowChanged(f.onFirstVisibleRowChange,f);var R=r.getDomRefs().rowSelector;if(R){P.attachEventOnce("afterOpen",g);P.openBy(R);}else{g();}});});};
M.prototype.onFirstVisibleRowChange=function(){if(!this._oNotificationPopover){return;}var o=this.getParent();if(o){o.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);}this._oNotificationPopover.close();};
function d(o,s,i){return new Promise(function(r){e(o,s,i,r);});}
function e(o,s,f,r){var C=o.getContexts(s,f);var g=false;for(var i=0;i<C.length;i++){if(!C[i]){g=true;break;}}if(!g&&!C.dataRequested){r(C);return;}o.attachEventOnce("dataReceived",function(){if(C.length==f){r(C);}else{e(o,s,f,r);}});}
M.prototype.clearSelection=function(E){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=E;this.oInnerSelectionPlugin.clearSelection();delete this._oCustomEventPayloadTmp;}};
M.prototype.getSelectedIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndex();}return-1;};
M.prototype.getSelectedIndices=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndices();}return[];};
M.prototype.getSelectableCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectableCount();}return 0;};
M.prototype.getSelectedCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedCount();}return 0;};
M.prototype.isIndexSelectable=function(i){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelectable(i);}return false;};
M.prototype.isIndexSelected=function(i){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelected(i);}return false;};
M.prototype.removeSelectionInterval=function(i,f,E){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=E;this.oInnerSelectionPlugin.removeSelectionInterval(i,f);delete this._oCustomEventPayloadTmp;}};
M.prototype._onSelectionChange=function(E){var r=E.getParameter("rowIndices");this.fireSelectionChange({rowIndices:r,limitReached:this.isLimitReached(),customPayload:typeof this._oCustomEventPayloadTmp==="object"?this._oCustomEventPayloadTmp:null});};
M.prototype._getHighestSelectableIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._getHighestSelectableIndex();}return 0;};
M.prototype.onThemeChanged=function(){this.oDeselectAllIcon.setSrc(b.getIconURI(T.ThemeParameters.resetIcon));};
return M;});
sap.ui.predefine('sap/ui/table/plugins/PluginBase',["../utils/TableUtils","sap/ui/core/Element"],function(T,E){"use strict";var H=T.Hook.Keys;var h={};
var P=E.extend("sap.ui.table.plugins.PluginBase",{metadata:{"abstract":true,library:"sap.ui.table"}});
P.prototype.init=function(){E.prototype.init.apply(this,arguments);this._bIsActive=false;};
P.prototype.exit=function(){E.prototype.exit.apply(this,arguments);this._deactivate(this.getTable());};
P.prototype.onActivate=function(t){T.Hook.install(t,h,this);var o=t.getBinding("rows");if(o){this.onTableRowsBound(o);}this._bIsActive=true;};
P.prototype.onDeactivate=function(t){T.Hook.uninstall(t,h,this);this._bIsActive=false;};
P.prototype.isActive=function(){return this._bIsActive;};
P.prototype.isApplicable=function(t){return T.isA(t,"sap.ui.table.Table");};
P.prototype.setParent=function(p){var o=this.getTable();E.prototype.setParent.apply(this,arguments);var n=this.getTable();if(n){if(!this.isApplicable(n)){throw new Error(this+" is not applicable to "+n);}this._activate(n);}else if(o){this._deactivate(o);}return this;};
P.prototype.onTableRowsBound=function(b){};
h[H.Table.RowsBound]=function(b){this.onTableRowsBound(b);};
P.prototype.onTableUnbindRows=function(){};
h[H.Table.UnbindRows]=function(){this.onTableUnbindRows();};
P.prototype.getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};
P.prototype.getTableBinding=function(){var t=this.getTable();var b=t?t.getBinding("rows"):null;return b?b:null;};
P.prototype._activate=function(t){if(!this.isActive()){this.onActivate(t);}};
P.prototype._deactivate=function(t){if(this.isActive()){this.onDeactivate(t);}};
return P;});
sap.ui.predefine('sap/ui/table/plugins/SelectionModelSelection',['sap/ui/model/SelectionModel','./SelectionPlugin',"../utils/TableUtils",'../library'],function(S,a,T,l){"use strict";var b=l.SelectionMode;
var c=a.extend("sap.ui.table.plugins.SelectionModelSelection",{metadata:{library:"sap.ui.table",events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this.oSelectionModel=new S(this._getSelectionMode);};
c.prototype.exit=function(){a.prototype.exit.apply(this,arguments);if(this.oSelectionModel){this.oSelectionModel.destroy();this.oSelectionModel=null;}};
c.prototype.onActivate=function(){a.prototype.onActivate.apply(this,arguments);this.oSelectionModel.attachSelectionChanged(this._onSelectionChange,this);};
c.prototype.onDeactivate=function(){a.prototype.onDeactivate.apply(this,arguments);this.oSelectionModel.detachSelectionChanged(this._onSelectionChange,this);this.oSelectionModel.clearSelection();e(this,this.getTableBinding());};
c.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:T.hasSelectAll(this.getTable())}};};
c.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){this.getTable()._toggleSelectAll();}};
c.prototype.onKeyboardShortcut=function(t){if(t==="toggle"){this.getTable()._toggleSelectAll();}else if(t==="clear"){this.clearSelection();}};
c.prototype.addSelectionInterval=function(i,I){if(!this.oSelectionModel||this._getSelectionMode()===b.None){return;}this.oSelectionModel.addSelectionInterval(i,I);};
c.prototype.clearSelection=function(){if(this.oSelectionModel){this.oSelectionModel.clearSelection();}};
c.prototype.getSelectedIndex=function(){if(this.oSelectionModel){return this.oSelectionModel.getLeadSelectedIndex();}return-1;};
c.prototype.getSelectedIndices=function(){if(this.oSelectionModel){return this.oSelectionModel.getSelectedIndices();}return[];};
c.prototype.getSelectableCount=function(){var B=this.getTableBinding();return B?B.getLength():0;};
c.prototype.getSelectedCount=function(){return this.getSelectedIndices().length;};
c.prototype.isIndexSelectable=function(i){return i>=0&&i<=this._getHighestSelectableIndex();};
c.prototype.isIndexSelected=function(i){return this.getSelectedIndices().indexOf(i)!==-1;};
c.prototype.removeSelectionInterval=function(i,I){if(this.oSelectionModel){this.oSelectionModel.removeSelectionInterval(i,I);}};
c.prototype.selectAll=function(){if(!this.oSelectionModel||this._getSelectionMode()===b.None){return;}this.oSelectionModel.selectAll(this._getHighestSelectableIndex());};
c.prototype.setSelectedIndex=function(i){if(this._getSelectionMode()===b.None){return;}if(i===-1){this.clearSelection();}else{this.setSelectionInterval(i,i);}};
c.prototype.setSelectionInterval=function(i,I){if(!this.oSelectionModel||this._getSelectionMode()===b.None){return;}this.oSelectionModel.setSelectionInterval(i,I);};
c.prototype.setSelectionMode=function(s){var o=this._getSelectionMode();a.prototype._setSelectionMode.apply(this,arguments);if(this._getSelectionMode()!==o){this.clearSelection();}if(this.oSelectionModel){var i=(s===b.MultiToggle?S.MULTI_SELECTION:S.SINGLE_SELECTION);this.oSelectionModel.setSelectionMode(i);}return this;};
c.prototype._getHighestSelectableIndex=function(){var B=this.getTableBinding();return B?B.getLength()-1:-1;};
c.prototype._onSelectionChange=function(E){var r=E.getParameter("rowIndices");var s=E.getParameter("selectAll");this.fireSelectionChange({rowIndices:r,selectAll:s});};
c.prototype.onTableRowsBound=function(B){a.prototype.onTableRowsBound.apply(this,arguments);d(this,B);};
c.prototype.onTableUnbindRows=function(){a.prototype.onTableUnbindRows.apply(this,arguments);this._suspend();this.clearSelection();this._resume();};
function d(p,B){if(B){B.attachChange(p._onBindingChange,p);}}
function e(p,B){if(B){B.detachChange(p._onBindingChange,p);}}
c.prototype._onBindingChange=function(E){var r=typeof(E)==="object"?E.getParameter("reason"):E;if(r==="sort"||r==="filter"){this.clearSelection();}};
return c;});
sap.ui.predefine('sap/ui/table/plugins/SelectionPlugin',["sap/ui/core/Element","./PluginBase","../library"],function(E,P,l){"use strict";var S=l.SelectionMode;
var a=E.extend("sap.ui.table.plugins.SelectionPlugin",{metadata:{"abstract":true,library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",defaultValue:S.MultiToggle,visibility:"hidden"}},events:{selectionChange:{parameters:{}}}}});
for(var p in P.prototype){if(!a.prototype.hasOwnProperty(p)){a.prototype[p]=P.prototype[p];}}
a.prototype.init=function(){P.prototype.init.apply(this,arguments);this._bSuspended=false;};
a.prototype.getRenderConfig=function(){return{headerSelector:{type:"none"}};};
a.prototype.addSelectionInterval=function(i,I){};
a.prototype.clearSelection=function(){};
a.prototype.getSelectedIndex=function(){return-1;};
a.prototype.getSelectedIndices=function(){return[];};
a.prototype.getSelectableCount=function(){return 0;};
a.prototype.getSelectedCount=function(){return 0;};
a.prototype.isIndexSelectable=function(i){return false;};
a.prototype.isIndexSelected=function(i){return false;};
a.prototype.removeSelectionInterval=function(i,I){};
a.prototype.selectAll=function(){};
a.prototype.setSelectedIndex=function(i){};
a.prototype.setSelectionInterval=function(i,I){};
a.prototype.fireSelectionChange=function(A){if(!this._isSuspended()){this.fireEvent("selectionChange",A);}};
a.prototype._setSelectionMode=function(s){this.setProperty("selectionMode",s);};
a.prototype._getSelectionMode=function(){return this.getProperty("selectionMode");};
a.prototype._suspend=function(){this._bSuspended=true;};
a.prototype._resume=function(){this._bSuspended=false;};
a.prototype._isSuspended=function(){return this._bSuspended;};
return a;});
sap.ui.predefine('sap/ui/table/plugins/V4Aggregation',["./PluginBase","../utils/TableUtils","sap/ui/unified/MenuItem"],function(P,T,M){"use strict";
var V=P.extend("sap.ui.table.plugins.V4Aggregation",{metadata:{library:"sap.ui.table",properties:{},events:{}}});
V.prototype.init=function(){this.aGroupMenuItems=[];this.aAggregateMenuItems=[];this.aContextMenuItems=[];};
V.prototype.isApplicable=function(t){return t.getMetadata().getName()==="sap.ui.table.Table";};
V.prototype.onActivate=function(t){P.prototype.onActivate.apply(this,arguments);T.Grouping.setGroupMode(t);T.Hook.register(t,T.Hook.Keys.Row.UpdateState,this.updateRowState,this);T.Hook.register(t,T.Hook.Keys.Table.OpenMenu,this.onOpenMenu,this);T.Hook.register(t,T.Hook.Keys.Column.MenuItemNotification,this.notifyColumnAboutMenuItems,this);};
V.prototype.onDeactivate=function(t){P.prototype.onDeactivate.apply(this,arguments);T.Grouping.clearMode(t);T.Hook.deregister(t,T.Hook.Keys.Row.UpdateState,this.updateRowState,this);T.Hook.deregister(t,T.Hook.Keys.Table.OpenMenu,this.onOpenMenu,this);T.Hook.deregister(t,T.Hook.Keys.Column.MenuItemNotification,this.notifyColumnAboutMenuItems,this);this.aGroupMenuItems.concat(this.aAggregateMenuItems,this.aContextMenuItems).forEach(function(i){i.destroy();});this.aGroupMenuItems=[];this.aAggregateMenuItems=[];this.aContextMenuItems=[];var B=t.getBinding("rows");if(B){B.setAggregation();}};
V.prototype.onTableRowsBound=function(B){this.updateAggregation();};
V.prototype.updateRowState=function(s){if(typeof s.context.getValue("@$ui5.node.isExpanded")==="boolean"){s.type=s.Type.GroupHeader;}else if(s.context.getValue("@$ui5.node.isTotal")){s.type=s.Type.Summary;}s.title="todo";s.expandable=s.type===s.Type.GroupHeader;s.expanded=s.context.getValue("@$ui5.node.isExpanded")===true;s.level=s.context.getValue("@$ui5.node.level");};
V.prototype.setGroupLevels=function(G){this._aGroupLevels=G;};
V.prototype.getGroupLevels=function(){return this._aGroupLevels||[];};
V.prototype.expandRow=function(r){var B=this.getTableBinding();if(B&&T.isA(r,"sap.ui.table.Row")){if(B.expand){B.expand(r.getIndex());}else{sap.m.MessageToast.show("not yet ;)");}}};
V.prototype.collapseRow=function(r){var B=this.getTableBinding();if(B&&T.isA(r,"sap.ui.table.Row")){if(B.collapse){B.collapse(r.getIndex());}else{sap.m.MessageToast.show("not yet ;)");}}};
function g(i){var C;if(i.isA("sap.ui.table.Table")){C=i.getColumns();}else{C=[i];}return C.reduce(function(G,o){var p=o.data("propertyInfo");if(o.getVisible()&&p){for(var s in p){if(p[s].groupable&&G.indexOf(s)===-1){G.push(s);}}}return G;},[]);}
function a(i){var C;if(i.isA("sap.ui.table.Table")){C=i.getColumns();}else{C=[i];}return C.reduce(function(A,o){var p=o.data("propertyInfo");if(o.getVisible()&&p){for(var s in p){if(p[s].aggregatable&&A.indexOf(s)===-1){A.push(s);}}}return A;},[]);}
function b(C){var A=a(C);var p=C.data("propertyInfo");var e=[];for(var i=0;i<A.length;i++){var s=A[i];var o=p[A[i]];var D=Object.assign({grandtotal:true,subtotals:true},o.aggregationDetails);var f={grandTotal:D.grandtotal===true,subtotals:D.subtotals===true};if(f.grandTotal&&f.subtotals){e.push({name:s,menuText:"All Totals",config:f});}if(f.grandTotal){e.push({name:s,menuText:"GrandTotal",config:{grandTotal:true}});}if(f.subtotals){e.push({name:s,menuText:"Subtotals",config:{subtotals:true}});}if(D.custom){for(var h in D.custom){var j=D.custom[h];e.push({name:h,menuText:h,config:j});}}}return e;}
function c(t){return g(t).reduce(function(G,s){G[s]={};return G;},{});}
function d(t){var A=a(t).reduce(function(A,s){A[s]={};return A;},{});return t.getColumns().reduce(function(A,C){var e=C.data("extendedState");if(e&&e.aggregations){e.aggregations.forEach(function(o){A[o.name]=o.config;});}return A;},A);}
V.prototype.updateAggregation=function(){var t=this.getTable();var B=this.getTableBinding();var A={aggregate:d(t),group:c(t),groupLevels:this.getGroupLevels()};B.setAggregation(A);};
V.prototype.onOpenMenu=function(C,m){var t=this;var o=this.getTable();if(C.isOfType(T.CELLTYPE.COLUMNHEADER)){var e=o.getColumns()[C.columnIndex];var G=g(e);var A=b(e);if(G.length>0){var f=function(p){var i=this.getGroupLevels();if(this.getGroupLevels().indexOf(p)===-1){i.push(p);this.setGroupLevels(i);}else{i.splice(i.indexOf(p),1);this.setGroupLevels(i);}this.updateAggregation();}.bind(this);G.forEach(function(s,i){if(!this.aGroupMenuItems[i]||this.aGroupMenuItems[i].bIsDestroyed){this.aGroupMenuItems[i]=new M(this.getId()+"-group"+"-"+i,{text:T.getResourceText("TBL_GROUP")+": "+s,icon:this.getGroupLevels().indexOf(s)>-1?"sap-icon://accept":null,select:function(){f(s);}});}else{this.aGroupMenuItems[i].mEventRegistry.select[0].fFunction=function(){f(s);};this.aGroupMenuItems[i].setText(T.getResourceText("TBL_GROUP")+": "+s);this.aGroupMenuItems[i].setIcon(this.getGroupLevels().indexOf(s)>-1?"sap-icon://accept":null);}m.addItem(this.aGroupMenuItems[i]);}.bind(this));}if(A.length>0){var h=function(k){var E=e.data("extendedState");var l=true;if(!E){E={aggregations:[]};}for(var i=0;i<E.aggregations.length;i++){var n=E.aggregations[i];if(n.name===k.name){E.aggregations.splice(i,1);l=false;break;}}if(l){E.aggregations.push(k);}e.data("extendedState",E);this.updateAggregation();}.bind(this);var j=function(i){var E=e.data("extendedState");if(!E||!E.aggregations){return{icon:null,enabled:true};}return{icon:E.aggregations.some(function(k){return k.name===i.name&&k.menuText===i.menuText;})?"sap-icon://accept":null,enabled:!E.aggregations.some(function(k){return k.name===i.name;})||E.aggregations.some(function(k){return k.menuText===i.menuText;})};};A.forEach(function(i,I){if(!this.aAggregateMenuItems[I]||this.aAggregateMenuItems[I].bIsDestroyed){var k=j(i);this.aAggregateMenuItems[I]=new M(this.getId()+"-aggregate"+"-"+I,{text:i.menuText,icon:k.icon,enabled:k.enabled,select:function(){h(i);}});}else{var k=j(i);this.aAggregateMenuItems[I].mEventRegistry.select[0].fFunction=function(){h(i);};this.aAggregateMenuItems[I].setText(i.menuText);this.aAggregateMenuItems[I].setIcon(k.icon);this.aAggregateMenuItems[I].setEnabled(k.enabled);}m.addItem(this.aAggregateMenuItems[I]);}.bind(this));}}else if(C.isOfType(T.CELLTYPE.ANYCONTENTCELL)){var r=this.getTable().getRows()[C.rowIndex];if(r.isGroupHeader()){if(this.aContextMenuItems[0]){this.aContextMenuItems[0].destroy();}this.aContextMenuItems[0]=new M(this.getId()+"-expandrow",{text:"expand index ("+r.getIndex()+")",select:function(){t.expandRow(r);}});m.addItem(this.aContextMenuItems[0]);if(this.aContextMenuItems[1]){this.aContextMenuItems[1].destroy();}this.aContextMenuItems[1]=new M(this.getId()+"-collapserow",{text:"collapse ("+r.getIndex()+")",select:function(){t.collapseRow(r);}});m.addItem(this.aContextMenuItems[1]);}}};
V.prototype.notifyColumnAboutMenuItems=function(C,n){if(g(C).length>0||b(C).length>0){n();}};
return V;});
sap.ui.predefine('sap/ui/table/rowmodes/AutoRowMode',["../library","../utils/TableUtils","./RowMode","sap/ui/Device","sap/base/Log"],function(l,T,R,D,L){"use strict";
var A=R.extend("sap.ui.table.rowmodes.AutoRowMode",{
metadata:{library:"sap.ui.table",properties:{rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},minRowCount:{type:"int",defaultValue:5,group:"Appearance"},maxRowCount:{type:"int",defaultValue:-1,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance"}}},
constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});R.apply(this,arguments);}
});
var a={};
function g(r){var t=r.getTable();var o=t?t.getDomRef("tableCCnt"):null;if(o&&D.browser.chrome&&window.devicePixelRatio!==1){var b=document.createElement("table");var c=b.insertRow();var i=r.getRowContentHeight();var n;b.classList.add("sapUiTableCtrl");c.classList.add("sapUiTableTr");if(i>0){c.style.height=r.getBaseRowHeightOfTable()+"px";}o.appendChild(b);n=c.getBoundingClientRect().height;o.removeChild(b);return n;}else{return r.getBaseRowHeightOfTable();}}
A.prototype.init=function(){R.prototype.init.apply(this,arguments);this.bRowCountAutoAdjustmentActive=false;this.iLastAvailableSpace=0;this.bTableIsFlexItem=false;this.adjustRowCountToAvailableSpaceAsync=T.debounce(this.adjustRowCountToAvailableSpace,{requestAnimationFrame:true});};
A.prototype.attachEvents=function(){R.prototype.attachEvents.apply(this,arguments);T.addDelegate(this.getTable(),a,this);};
A.prototype.detachEvents=function(){R.prototype.detachEvents.apply(this,arguments);T.removeDelegate(this.getTable(),a);};
A.prototype.cancelAsyncOperations=function(){R.prototype.cancelAsyncOperations.apply(this,arguments);this.stopAutoRowMode();};
A.prototype.registerHooks=function(){R.prototype.registerHooks.apply(this,arguments);T.Hook.register(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);T.Hook.register(this.getTable(),T.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this);};
A.prototype.deregisterHooks=function(){R.prototype.deregisterHooks.apply(this,arguments);T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this);};
A.prototype.setRowCount=function(){L.error("The row count is set automatically and cannot be set manually.",this);return this;};
A.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0;}return this.getProperty("rowCount");};
A.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0;}return this.getProperty("fixedTopRowCount");};
A.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0;}return this.getProperty("fixedBottomRowCount");};
A.prototype.getMinRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getMinAutoRowCount():0;}return this.getProperty("minRowCount");};
A.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0;}return this.getProperty("rowContentHeight");};
A.prototype._getMinRowCount=function(){var m=this.getMinRowCount();var M=this.getMaxRowCount();if(M>=0){return Math.min(m,M);}else{return m;}};
A.prototype.getMinRequestLength=function(){var t=this.getTable();var r=this.getConfiguredRowCount();if(this.isPropertyInitial("rowCount")||(t&&!t._bContextsAvailable)){var e=Math.ceil(D.resize.height/T.DefaultRowHeight.sapUiSizeCondensed);r=Math.max(r,e);}return r;};
A.prototype.getComputedRowCounts=function(){if(this.isPropertyInitial("rowCount")){return{count:0,scrollable:0,fixedTop:0,fixedBottom:0};}var r=this.getConfiguredRowCount();var f=this.getFixedTopRowCount();var F=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){r=Math.min(r,this.getTotalRowCountOfTable());}return this.sanitizeRowCounts(r,f,F);};
A.prototype.getTableStyles=function(){var h="0px";if(this.isPropertyInitial("rowCount")){h="auto";}else{var r=this.getConfiguredRowCount();if(r===0||r===this._getMinRowCount()){h="auto";}}return{height:h};};
A.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined;}var r;if(this.isPropertyInitial("rowCount")){r=this._getMinRowCount();}else{r=this.getConfiguredRowCount()-this.getComputedRowCounts().count;}return{height:r*this.getBaseRowHeightOfTable()+"px"};};
A.prototype.getRowContainerStyles=function(){return{height:this.getComputedRowCounts().count*Math.max(this.getBaseRowHeightOfTable(),g(this))+"px"};};
A.prototype.renderRowStyles=function(r){var i=this.getRowContentHeight();if(i>0){r.style("height",this.getBaseRowHeightOfTable()+"px");}};
A.prototype.renderCellContentStyles=function(r){var i=this.getRowContentHeight();if(!this.bLegacy&&i<=0){i=this.getDefaultRowContentHeightOfTable();}if(i>0){r.style("max-height",i+"px");}};
A.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight());};
A.prototype._onTableRefreshRows=function(){var c=this.getConfiguredRowCount();if(c>0){if(!this.isPropertyInitial("rowCount")){this.initTableRowsAfterDataRequested(c);}this.getRowContexts(c,true);}};
A.prototype.getConfiguredRowCount=function(){var r=Math.max(0,this.getMinRowCount(),this.getRowCount());var m=this.getMaxRowCount();if(m>=0){r=Math.min(r,m);}return r;};
A.prototype.startAutoRowMode=function(){this.adjustRowCountToAvailableSpaceAsync(T.RowsUpdateReason.Render,true);};
A.prototype.stopAutoRowMode=function(){this.deregisterResizeHandler();this.adjustRowCountToAvailableSpaceAsync.cancel();this.bRowCountAutoAdjustmentActive=false;};
A.prototype.registerResizeHandler=function(o){var t=this.getTable();if(t){T.registerResizeHandler(t,"AutoRowMode",this.onResize.bind(this),null,o===true);}};
A.prototype.deregisterResizeHandler=function(){var t=this.getTable();if(t){T.deregisterResizeHandler(t,"AutoRowMode");}};
A.prototype.onResize=function(e){var o=e.oldSize.height;var n=e.size.height;if(o!==n){this.adjustRowCountToAvailableSpaceAsync(T.RowsUpdateReason.Resize);}};
A.prototype._onUpdateTableSizes=function(r){if(r===T.RowsUpdateReason.Resize||r===T.RowsUpdateReason.Render){return;}if(this.bRowCountAutoAdjustmentActive){this.adjustRowCountToAvailableSpaceAsync(r);}};
A.prototype.adjustRowCountToAvailableSpace=function(r,s){s=s===true;var t=this.getTable();var o=t?t.getDomRef():null;if(!t||t._bInvalid||!o||!sap.ui.getCore().isThemeApplied()){return;}this.bTableIsFlexItem=window.getComputedStyle(o.parentNode).display==="flex";if(o.scrollHeight===0){if(s){this.registerResizeHandler(!this.bTableIsFlexItem);this.bRowCountAutoAdjustmentActive=true;}return;}var n=this.determineAvailableSpace();var O=this.getConfiguredRowCount();var N=Math.floor(n/g(this));var i=this.getComputedRowCounts().count;var b;if(this.bLegacy){t.setProperty("visibleRowCount",N,true);}this.setProperty("rowCount",N,true);b=this.getComputedRowCounts().count;if(this.bLegacy){t.setProperty("visibleRowCount",b,true);}if(i!==b){this.updateTable(r);}else{if(O!==N||r===T.RowsUpdateReason.Zoom){this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles();}if(!this._bFiredRowsUpdatedAfterRendering&&t.getRows().length>0){this.fireRowsUpdated(r);}}if(s){this.registerResizeHandler(!this.bTableIsFlexItem);this.bRowCountAutoAdjustmentActive=true;}};
A.prototype.determineAvailableSpace=function(){var t=this.getTable();var o=t?t.getDomRef():null;var r=t?t.getDomRef("tableCCnt"):null;var p=t?t.getDomRef("placeholder-bottom"):null;if(!o||!r||!o.parentNode){return 0;}var u=0;var b=r.clientHeight;var P=p?p.clientHeight:0;if(this.bTableIsFlexItem){var c=o.childNodes;for(var i=0;i<c.length;i++){u+=c[i].offsetHeight;}u-=b-P;}else{u=o.scrollHeight-b-P;}var s=t._getScrollExtension();if(!s.isHorizontalScrollbarVisible()){var d={};d[D.browser.BROWSER.CHROME]=16;d[D.browser.BROWSER.FIREFOX]=16;d[D.browser.BROWSER.INTERNET_EXPLORER]=18;d[D.browser.BROWSER.EDGE]=16;d[D.browser.BROWSER.SAFARI]=16;d[D.browser.BROWSER.ANDROID]=8;u+=d[D.browser.name];}var e=this.bTableIsFlexItem?o:o.parentNode;var n=Math.max(0,Math.floor(jQuery(e).height()-u));var f=Math.abs(n-this.iLastAvailableSpace);if(f>=5){this.iLastAvailableSpace=n;}return this.iLastAvailableSpace;};
a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this.stopAutoRowMode();this.updateTable(T.RowsUpdateReason.Render);}};
a.onAfterRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this.startAutoRowMode();}};
return A;});
sap.ui.predefine('sap/ui/table/rowmodes/FixedRowMode',["../library","./RowMode","../utils/TableUtils"],function(l,R,T){"use strict";
var F=R.extend("sap.ui.table.rowmodes.FixedRowMode",{
metadata:{library:"sap.ui.table",properties:{rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance"}}},
constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});R.apply(this,arguments);}
});
var a={};
F.prototype.attachEvents=function(){R.prototype.attachEvents.apply(this,arguments);T.addDelegate(this.getTable(),a,this);};
F.prototype.detachEvents=function(){R.prototype.detachEvents.apply(this,arguments);T.removeDelegate(this.getTable(),a);};
F.prototype.registerHooks=function(){R.prototype.registerHooks.apply(this,arguments);T.Hook.register(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);};
F.prototype.deregisterHooks=function(){R.prototype.deregisterHooks.apply(this,arguments);T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);};
F.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0;}return this.getProperty("rowCount");};
F.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0;}return this.getProperty("fixedTopRowCount");};
F.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0;}return this.getProperty("fixedBottomRowCount");};
F.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0;}return this.getProperty("rowContentHeight");};
F.prototype.getMinRequestLength=function(){return Math.max(0,this.getRowCount());};
F.prototype.getComputedRowCounts=function(){var r=this.getRowCount();var f=this.getFixedTopRowCount();var i=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){r=Math.min(r,this.getTotalRowCountOfTable());}return this.sanitizeRowCounts(r,f,i);};
F.prototype.getTableStyles=function(){return{height:"auto"};};
F.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined;}var r=Math.max(0,this.getRowCount()-this.getComputedRowCounts().count);return{height:r*this.getBaseRowHeightOfTable()+"px"};};
F.prototype.getRowContainerStyles=function(){var h=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!T.isVariableRowHeightEnabled(this.getTable())){return{minHeight:h};}else{return{height:h};}};
F.prototype.renderRowStyles=function(r){var i=this.getRowContentHeight();if(i>0){r.style("height",this.getBaseRowHeightOfTable()+"px");}};
F.prototype.renderCellContentStyles=function(r){var i=this.getRowContentHeight();if(this.bLegacy){return;}if(i<=0){i=this.getDefaultRowContentHeightOfTable();}if(i>0){r.style("max-height",i+"px");}};
F.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight());};
F.prototype._onTableRefreshRows=function(){var r=this.getRowCount();if(r>0){this.initTableRowsAfterDataRequested(r);this.getRowContexts(r,true);}};
a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this.updateTable(T.RowsUpdateReason.Render);}};
a.onAfterRendering=function(e){var t=this.getTable();var r=e&&e.isMarked("renderRows");if(!r&&t.getRows().length>0){this.fireRowsUpdated(T.RowsUpdateReason.Render);}};
return F;});
sap.ui.predefine('sap/ui/table/rowmodes/InteractiveRowMode',["../library","./RowMode","../utils/TableUtils","sap/base/Log","sap/ui/thirdparty/jquery"],function(l,R,T,L,q){"use strict";
var I=R.extend("sap.ui.table.rowmodes.InteractiveRowMode",{
metadata:{library:"sap.ui.table","final":true,properties:{rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},minRowCount:{type:"int",defaultValue:5,group:"Appearance"}}},
constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});R.apply(this,arguments);}
});
var a={};var b={};
I.prototype.attachEvents=function(){R.prototype.attachEvents.apply(this,arguments);T.addDelegate(this.getTable(),a,this);};
I.prototype.detachEvents=function(){R.prototype.detachEvents.apply(this,arguments);T.removeDelegate(this.getTable(),a);};
I.prototype.registerHooks=function(){R.prototype.registerHooks.apply(this,arguments);T.Hook.register(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);};
I.prototype.deregisterHooks=function(){R.prototype.deregisterHooks.apply(this,arguments);T.Hook.deregister(this.getTable(),T.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);};
I.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0;}return this.getProperty("rowCount");};
I.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0;}return this.getProperty("fixedTopRowCount");};
I.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0;}return this.getProperty("fixedBottomRowCount");};
I.prototype.getMinRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getMinAutoRowCount():0;}return this.getProperty("minRowCount");};
I.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0;}return this.getProperty("rowContentHeight");};
I.prototype.getMinRequestLength=function(){return this.getConfiguredRowCount();};
I.prototype.getComputedRowCounts=function(){return this.sanitizeRowCounts(this.getConfiguredRowCount(),this.getFixedTopRowCount(),this.getFixedBottomRowCount());};
I.prototype.getTableStyles=function(){return{height:"auto"};};
I.prototype.getTableBottomPlaceholderStyles=function(){return undefined;};
I.prototype.getRowContainerStyles=function(){var h=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!T.isVariableRowHeightEnabled(this.getTable())){return{minHeight:h};}else{return{height:h};}};
I.prototype.renderRowStyles=function(r){var i=this.getRowContentHeight();if(i>0){r.style("height",this.getBaseRowHeightOfTable()+"px");}};
I.prototype.renderCellContentStyles=function(r){var i=this.getRowContentHeight();if(this.bLegacy){return;}if(i<=0){i=this.getDefaultRowContentHeightOfTable();}if(i>0){r.style("max-height",i+"px");}};
I.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight());};
I.prototype._onTableRefreshRows=function(){var r=this.getConfiguredRowCount();if(r>0){this.initTableRowsAfterDataRequested(r);this.getRowContexts(r,true);}};
I.prototype.getConfiguredRowCount=function(){return Math.max(0,this.getMinRowCount(),this.getRowCount());};
a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(this.bLegacy){this.getTable().setVisibleRowCount(this.getComputedRowCounts().count);}if(!r){this.updateTable(T.RowsUpdateReason.Render);}};
a.onAfterRendering=function(e){var t=this.getTable();var r=e&&e.isMarked("renderRows");if(!r&&t.getRows().length>0){this.fireRowsUpdated(T.RowsUpdateReason.Render);}};
a.onmousedown=function(e){var t=this.getTable();if(e.button===0&&e.target===t.getDomRef("sb")){b.initInteractiveResizing(t,this,e);}};
b.initInteractiveResizing=function(t,m,e){var B=q(document.body);var s=t.$("sb");var d=q(document);var o=s.offset();var h=s.height();var w=s.width();var c=t._isTouchEvent(e);B.on("selectstart",b.onSelectStartWhileInteractiveResizing);B.append("<div id=\""+t.getId()+"-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");s.append("<div id=\""+t.getId()+"-rzoverlay\" style =\"left: 0px; right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");d.on((c?"touchend":"mouseup")+".sapUiTableInteractiveResize",b.exitInteractiveResizing.bind(t,m));d.on((c?"touchmove":"mousemove")+".sapUiTableInteractiveResize",b.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection();};
b.exitInteractiveResizing=function(m,e){var B=q(document.body);var d=q(document);var t=this.$();var g=this.$("ghost");var i=b.getEventPosition(this,e).y;var n=i-t.find(".sapUiTableCCnt").offset().top-g.height()-t.find(".sapUiTableFtr").height();var u=Math.floor(n/m.getBaseRowHeightOfTable());var N=Math.max(1,u,m.getMinRowCount());if(m.bLegacy){N=Math.max(N,m.getFixedTopRowCount()+m.getFixedBottomRowCount()+1);this.setVisibleRowCount(N);}m.setRowCount(N);g.remove();this.$("rzoverlay").remove();B.off("selectstart",b.onSelectStartWhileInteractiveResizing);d.off("touchend.sapUiTableInteractiveResize");d.off("touchmove.sapUiTableInteractiveResize");d.off("mouseup.sapUiTableInteractiveResize");d.off("mousemove.sapUiTableInteractiveResize");this._enableTextSelection();};
b.onSelectStartWhileInteractiveResizing=function(e){e.preventDefault();e.stopPropagation();return false;};
b.onMouseMoveWhileInteractiveResizing=function(e){var i=b.getEventPosition(this,e).y;var m=this.$().offset().top;if(i>m){this.$("ghost").css("top",i+"px");}};
b.getEventPosition=function(t,e){var p;function g(o){if(!t._isTouchEvent(o)){return null;}var c=["touches","targetTouches","changedTouches"];for(var i=0;i<c.length;i++){var s=c[i];if(e[s]&&e[s][0]){return e[s][0];}if(e.originalEvent[s]&&e.originalEvent[s][0]){return e.originalEvent[s][0];}}return null;}p=g(e)||e;return{x:p.pageX,y:p.pageY};};
return I;});
sap.ui.predefine('sap/ui/table/rowmodes/RowMode',["../library","../utils/TableUtils","sap/ui/core/Element","sap/base/Log","sap/ui/thirdparty/jquery"],function(l,T,E,L,q){"use strict";
var R=E.extend("sap.ui.table.rowmodes.RowMode",{metadata:{library:"sap.ui.table","abstract":true,properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"}}}});
var a={};
R.prototype.init=function(){this._bFiredRowsUpdatedAfterRendering=false;this._bListeningForFirstRowsUpdatedAfterRendering=false;this.updateTableAsync=T.throttle(this.updateTable,{wait:50,asyncLeading:true});};
R.prototype.exit=function(){this.detachEvents();this.cancelAsyncOperations();this.deregisterHooks();};
R.prototype.setParent=function(){this.detachEvents();this.cancelAsyncOperations();this.deregisterHooks();E.prototype.setParent.apply(this,arguments);this.attachEvents();this.registerHooks();};
R.prototype.attachEvents=function(){T.addDelegate(this.getTable(),a,this);};
R.prototype.detachEvents=function(){T.removeDelegate(this.getTable(),a);};
R.prototype.cancelAsyncOperations=function(){var t=this.getTable();if(t){clearTimeout(t._mTimeouts.refreshRowsCreateRows);}this.updateTableAsync.cancel();};
R.prototype.registerHooks=function(){var t=this.getTable();var H=T.Hook.Keys;T.Hook.register(t,H.Table.RowsUnbound,this._onTableRowsUnbound,this);T.Hook.register(t,H.Table.UpdateRows,this._onTableUpdateRows,this);};
R.prototype.deregisterHooks=function(){var t=this.getTable();var H=T.Hook.Keys;T.Hook.deregister(t,H.Table.RowsUnbound,this._onTableRowsUnbound,this);T.Hook.deregister(t,H.Table.UpdateRows,this._onTableUpdateRows,this);};
R.prototype.getMinRequestLength=function(){throw new Error(this.getMetadata().getName()+": sap.ui.table.rowmodes.RowMode subclass did not implement #getMinRequestLength");};
R.prototype.getComputedRowCounts=function(){throw new Error(this.getMetadata().getName()+": sap.ui.table.rowmodes.RowMode subclass did not implement #getComputedRowCounts");};
R.prototype.getTableStyles=function(){throw new Error(this.getMetadata().getName()+": sap.ui.table.rowmodes.RowMode subclass did not implement #getTableStyles");};
R.prototype.getTableBottomPlaceholderStyles=function(){throw new Error(this.getMetadata().getName()+": sap.ui.table.rowmodes.RowMode subclass did not implement #getTableBottomPlaceholderStyles");};
R.prototype.getRowContainerStyles=function(){throw new Error(this.getMetadata().getName()+": sap.ui.table.rowmodes.RowMode subclass did not implement #getRowContainerStyles");};
R.prototype.getTable=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Table")?p:null;};
R.prototype.updateTable=function(r){var t=this.getTable();if(!t){return;}this.updateTableAsync.cancel();var b=this.updateTableRows();if(t._bInvalid){return;}this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles();if(b||t.getRows().some(function(o){return o.getDomRef()==null;})){this.renderTableRows();}if(b||t.getRows().length>0){this.fireRowsUpdated(r);}};
R.prototype.getBaseRowContentHeight=function(){return 0;};
R.prototype.getBaseRowHeightOfTable=function(){var t=this.getTable();return t?t._getBaseRowHeight():0;};
R.prototype.getDefaultRowContentHeightOfTable=function(){var t=this.getTable();return t?t._getDefaultRowContentHeight():0;};
R.prototype.getTotalRowCountOfTable=function(){var t=this.getTable();return t?t._getTotalRowCount():0;};
R.prototype._onTableRowsUnbound=function(){clearTimeout(this.getTable()._mTimeouts.refreshRowsCreateRows);this.updateTable(T.RowsUpdateReason.Unbind);};
R.prototype._onTableUpdateRows=function(r){var t=this.getTable();clearTimeout(t._mTimeouts.refreshRowsCreateRows);this.updateTableAsync(r);};
R.prototype.applyTableStyles=function(r){var t=this.getTableStyles();if(r){r.style("height",t.height);r.style("min-height",t.minHeight);r.style("max-height",t.maxHeight);return;}var o=this.getTable();var b=o?o.getDomRef():null;if(b){b.style.height=t.height;b.style.minHeight=t.minHeight;b.style.maxHeight=t.maxHeight;}};
R.prototype.applyTableBottomPlaceholderStyles=function(r){var p=this.getTableBottomPlaceholderStyles();if(r){r.style("height",p.height);return;}var t=this.getTable();var P=t?t.getDomRef("placeholder-bottom"):null;if(P){P.style.height=p.height;}};
R.prototype.applyRowContainerStyles=function(r){var m=this.getRowContainerStyles();if(r){r.style("height",m.height);r.style("min-height",m.minHeight);r.style("max-height",m.maxHeight);return;}var t=this.getTable();var o=t?t.getDomRef("tableCCnt"):null;if(o){o.style.height=m.height;o.style.minHeight=m.minHeight;o.style.maxHeight=m.maxHeight;}};
R.prototype.sanitizeRowCounts=function(C,f,F){C=Math.max(0,C);f=Math.max(0,f);F=Math.max(0,F);if(f+F>=C){F=Math.max(0,F-Math.max(0,(f+F-(C-1))));f=Math.max(0,f-Math.max(0,(f+F-(C-1))));}return{count:C,scrollable:C-f-F,fixedTop:f,fixedBottom:F};};
R.prototype.renderRowStyles=function(r){};
R.prototype.renderCellContentStyles=function(r){};
R.prototype.initTableRowsAfterDataRequested=function(r){var t=this.getTable();var b=t.getBinding("rows");clearTimeout(t._mTimeouts.refreshRowsCreateRows);if(!b||r<=0||t.getRows().length>0){return;}b.attachEventOnce("dataRequested",function(){clearTimeout(t._mTimeouts.refreshRowsCreateRows);t._mTimeouts.refreshRowsCreateRows=setTimeout(function(){if(t.getRows().length>0){return;}var d=c(t,r),o;for(var i=0;i<d.length;i++){o=d[i];o.setRowBindingContext(null,t);t.addAggregation("rows",o,true);}t._bRowAggregationInvalid=false;},0);});};
R.prototype.updateTableRows=function(){var t=this.getTable();var r=t.getRows();var n=this.getComputedRowCounts().count;var i;var b=false;if(T.isNoDataVisible(t)&&!t.getBinding("rows")){n=0;}else if(T.isVariableRowHeightEnabled(t)){n=n+1;}if(t._bRowAggregationInvalid){b=r.length>0;t.destroyAggregation("rows",t._bInvalid?"KeepDom":true);r=[];}if(n===r.length){u(this,r);return b;}T.dynamicCall(t._getSyncExtension,function(s){s.syncRowCount(n);});if(r.length<n){var N=c(t,n-r.length);r=r.concat(N);u(this,r);for(i=0;i<N.length;i++){t.addAggregation("rows",N[i],true);}}else{for(i=r.length-1;i>=n;i--){t.removeAggregation("rows",i,true);}r.splice(n);u(this,r);}b=true;t._bRowAggregationInvalid=false;return b;};
R.prototype.renderTableRows=function(){var t=this.getTable();var o=t?t.getDomRef("tableCCnt"):null;if(!o){return;}var b=q.Event("BeforeRendering");b.setMarked("renderRows");b.srcControl=t;t._handleEvent(b);var r=sap.ui.getCore().createRenderManager();var d=t.getRenderer();d.renderTableCCnt(r,t);r.flush(o,false,false);r.destroy();var A=q.Event("AfterRendering");A.setMarked("renderRows");A.srcControl=t;t._handleEvent(A);};
R.prototype.getRowContexts=function(r,s){var t=this.getTable();if(!t){return[];}return t._getRowContexts(r,s===true);};
R.prototype.fireRowsUpdated=function(r){var t=this.getTable();if(!t||!t._bContextsAvailable){return;}if(!this._bFiredRowsUpdatedAfterRendering){r=T.RowsUpdateReason.Render;if(!this._bListeningForFirstRowsUpdatedAfterRendering){this._bListeningForFirstRowsUpdatedAfterRendering=true;t.attachEvent("_rowsUpdated",function(){this._bFiredRowsUpdatedAfterRendering=true;this._bListeningForFirstRowsUpdatedAfterRendering=false;}.bind(this));}}t._fireRowsUpdated(r);};
R.prototype.disableFixedRows=function(){if(this.bFixedRowsDisabled===true){return;}Object.defineProperty(this,"bFixedRowsDisabled",{value:true});function b(){L.error("This mode does not support fixed rows",this);}this.setProperty("fixedTopRowCount",0,true);this.setFixedTopRowCount=b;this.setProperty("fixedBottomRowCount",0,true);this.setFixedBottomRowCount=b;};
function c(t,r){var b=[];var s=t.getRows().length;for(var i=0;i<r;i++){b.push(t._getRowClone(s+i));}return b;}
function u(m,r){var t=m.getTable();var C=m.getRowContexts(r.length);if(!t||r.length===0){return;}for(var i=0;i<r.length;i++){r[i].setRowBindingContext(C[i],t);}}
a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this._bFiredRowsUpdatedAfterRendering=false;}};
return R;});
sap.ui.predefine('sap/ui/table/rowmodes/VariableRowMode',["../library","./RowMode"],function(l,R){"use strict";
var V=R.extend("sap.ui.table.rowmodes.VariableRowMode",{
metadata:{library:"sap.ui.table",properties:{tableHeight:{type:"sap.ui.core.CSSSize",defaultValue:"100%",group:"Dimension"}}},
constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});if(this.bLegacy){R.call(this);}else{R.apply(this,arguments);}}
});
V.prototype.getComputedRowCounts=function(){var t=this.getTotalRowCountOfTable();var r=this.getHideEmptyRows()?Math.min(this.getRowCount(),t):this.getRowCount();return{count:r,fixedTopCount:this.getFixedTopRowCount(),fixedBottomCount:this.getFixedBottomRowCount()};};
V.prototype.getComputedRowCounts=function(){var t=this.getTotalRowCountOfTable();var r=this.getHideEmptyRows()?Math.min(this.getRowCount(),t):this.getRowCount();return{count:r,fixedTopCount:this.getFixedTopRowCount(),fixedBottomCount:this.getFixedBottomRowCount()};};
V.prototype.getTableHeight=function(){return{height:this.getTableHeight()};};
V.prototype.getRowContainerHeight=function(){return{height:this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()};};
return V;});
sap.ui.predefine('sap/ui/table/utils/TableUtils',["./_GroupingUtils","./_ColumnUtils","./_MenuUtils","./_BindingUtils","./_HookUtils","../library","sap/ui/base/Object","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/ui/core/theming/Parameters","sap/ui/model/ChangeReason","sap/ui/thirdparty/jquery"],function(G,C,M,B,H,l,a,R,c,T,b,q){"use strict";var S=l.SelectionBehavior;var d=l.SelectionMode;var e=c.MessageType;var r;var f=null;var g={DATACELL:1<<1,COLUMNHEADER:1<<2,ROWHEADER:1<<3,ROWACTION:1<<4,COLUMNROWHEADER:1<<5,PSEUDO:1<<6};g.ANYCONTENTCELL=g.ROWHEADER|g.DATACELL|g.ROWACTION;g.ANYCOLUMNHEADER=g.COLUMNHEADER|g.COLUMNROWHEADER;g.ANYROWHEADER=g.ROWHEADER|g.COLUMNROWHEADER;g.ANY=g.ANYCONTENTCELL|g.ANYCOLUMNHEADER;var m={sapUiSizeCozy:48,sapUiSizeCompact:32,sapUiSizeCondensed:24,undefined:32};var h=1;var j=1;var D={sapUiSizeCozy:m.sapUiSizeCozy+j,sapUiSizeCompact:m.sapUiSizeCompact+j,sapUiSizeCondensed:m.sapUiSizeCondensed+j,undefined:m.undefined+j};var t={navigationIcon:"navigation-right-arrow",deleteIcon:"sys-cancel",resetIcon:"undo",navIndicatorWidth:3};var k={Render:"Render",VerticalScroll:"VerticalScroll",FirstVisibleRowChange:"FirstVisibleRowChange",Unbind:"Unbind",Animation:"Animation",Resize:"Resize",Zoom:"Zoom",Unknown:"Unknown"};for(var p in b){k[p]=b[p];}var I=":sapTabbable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)";
function n(E){return E!=null&&E instanceof window.HTMLInputElement&&/^(text|password|search|tel|url)$/.test(E.type);}
var o={Grouping:G,Column:C,Menu:M,Binding:B,Hook:H,CELLTYPE:g,BaseSize:m,BaseBorderWidth:h,RowHorizontalFrameSize:j,DefaultRowHeight:D,RowsUpdateReason:k,INTERACTIVE_ELEMENT_SELECTORS:I,ThemeParameters:t,hasRowHeader:function(i){return(i.getSelectionMode()!==d.None&&i.getSelectionBehavior()!==S.RowOnly)||G.isGroupMode(i);},hasSelectAll:function(i){var s=i?i.getSelectionMode():d.None;return s===d.MultiToggle&&i.getEnableSelectAll();},hasRowHighlights:function(i){if(!i){return false;}var s=i.getRowSettingsTemplate();if(!s){return false;}var u=s.getHighlight();return s.isBound("highlight")||(u!=null&&u!==e.None);},hasRowNavigationIndicators:function(i){if(!i){return false;}var s=i.getRowSettingsTemplate();if(!s){return false;}var N=s.getNavigated();return s.isBound("navigated")||N;},hasRowActions:function(i){var s=i?i.getRowActionTemplate():null;return s!=null&&(s.isBound("visible")||s.getVisible())&&i.getRowActionCount()>0;},isRowSelectionAllowed:function(i){return i.getSelectionMode()!==d.None&&(i.getSelectionBehavior()===S.Row||i.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(i){return i.getSelectionMode()!==d.None&&o.hasRowHeader(i);},areAllRowsSelected:function(i){if(!i){return false;}var s=i._getSelectionPlugin();var u=s.getSelectableCount();var v=s.getSelectedCount();return u>0&&u===v;},isNoDataVisible:function(i){return i.getShowNoData()&&!o.hasData(i)||o.getVisibleColumnCount(i)===0;},hasData:function(i){var s=i.getBinding("rows");var u=i._getTotalRowCount();var v=u>0;if(s&&s.providesGrandTotal){var w=s.providesGrandTotal()&&s.hasTotaledMeasures();v=(w&&u>1)||(!w&&u>0);}return v;},isBusyIndicatorVisible:function(i){if(!i||!i.getDomRef()){return false;}return i.getDomRef().querySelector("#"+i.getId()+"-sapUiTableGridCnt > .sapUiLocalBusyIndicator")!=null;},hasPendingRequests:function(i){if(!i){return false;}if(o.canUsePendingRequestsCounter(i)){return i._iPendingRequests>0;}else{return i._bPendingRequest;}},canUsePendingRequestsCounter:function(i){var s=i?i.getBinding("rows"):null;if(o.isA(s,"sap.ui.model.analytics.AnalyticalBinding")){return s.bUseBatchRequests;}else if(o.isA(s,"sap.ui.model.TreeBinding")){return false;}return true;},isA:function(O,v){return a.isA(O,v);},toggleRowSelection:function(i,v,s,u){if(!i||!i.getBinding("rows")||i.getSelectionMode()===d.None||v==null){return false;}var w=i._getSelectionPlugin();function x(A){if(!w.isIndexSelectable(A)){return false;}i._iSourceRowIndex=A;var E=false;if(u){E=u(A,s);}else if(w.isIndexSelected(A)){if(s!==true){E=true;w.removeSelectionInterval(A,A);}}else if(s!==false){E=true;w.addSelectionInterval(A,A);}delete i._iSourceRowIndex;return E;}if(typeof v==="number"){if(v<0||v>=i._getTotalRowCount()){return false;}return x(v);}else{var $=q(v);var y=o.getCellInfo($[0]);var z=o.isRowSelectionAllowed(i);if(!o.Grouping.isInGroupHeaderRow($[0])&&((y.isOfType(o.CELLTYPE.DATACELL|o.CELLTYPE.ROWACTION)&&z)||(y.isOfType(o.CELLTYPE.ROWHEADER)&&o.isRowSelectorSelectionAllowed(i)))){var A=i.getRows()[y.rowIndex].getIndex();return x(A);}return false;}},getNoDataText:function(i){if(o.getVisibleColumnCount(i)===0){return o.getResourceText("TBL_NO_COLUMNS");}var N=i.getNoData();if(o.isA(N,"sap.ui.core.Control")){return null;}else if(typeof N==="string"){return N;}else{return o.getResourceText("TBL_NO_DATA");}},getVisibleColumnCount:function(i){return i._getVisibleColumns().length;},getHeaderRowCount:function(s){if(s._iHeaderRowCount===undefined){if(!s.getColumnHeaderVisible()){s._iHeaderRowCount=0;}else{var u=1;var v=s.getColumns();for(var i=0;i<v.length;i++){if(v[i].shouldRender()){u=Math.max(u,v[i].getMultiLabels().length);}}s._iHeaderRowCount=u;}}return s._iHeaderRowCount;},isVariableRowHeightEnabled:function(i){var s=i._getRowCounts();return i&&i._bVariableRowHeightEnabled&&!s.fixedTop&&!s.fixedBottom;},getTotalRowCount:function(i,s){var u=i._getTotalRowCount();if(s){u=Math.max(u,i._getRowCounts().count);}return u;},getNonEmptyVisibleRowCount:function(i){return Math.min(i._getRowCounts().count,i._getTotalRowCount());},getFocusedItemInfo:function(i){var s=i._getItemNavigation();if(!s){return null;}return{cell:s.getFocusedIndex(),columnCount:s.iColumns,cellInRow:s.getFocusedIndex()%s.iColumns,row:Math.floor(s.getFocusedIndex()/s.iColumns),cellCount:s.getItemDomRefs().length,domRef:s.getFocusedDomRef()};},getRowIndexOfFocusedCell:function(i){var s=o.getFocusedItemInfo(i);return s.row-o.getHeaderRowCount(i);},isFixedColumn:function(i,s){return s<i.getComputedFixedColumnCount();},hasFixedColumns:function(i){return i.getComputedFixedColumnCount()>0;},focusItem:function(i,s,E){var u=i._getItemNavigation();if(u){u.focusItem(s,E);}},getCellInfo:function(i){var s;var $=q(i);var u;var v;var w;var x;var y;s={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};if($.hasClass("sapUiTableDataCell")){u=$.attr("data-sap-ui-colid");v=sap.ui.getCore().byId(u);s.type=o.CELLTYPE.DATACELL;s.rowIndex=parseInt($.parent().attr("data-sap-ui-rowindex"));s.columnIndex=v.getIndex();s.columnSpan=1;}else if($.hasClass("sapUiTableHeaderDataCell")){w=/_([\d]+)/;u=$.attr("id");x=w.exec(u);y=x&&x[1]!=null?parseInt(x[1]):0;s.type=o.CELLTYPE.COLUMNHEADER;s.rowIndex=y;s.columnIndex=parseInt($.attr("data-sap-ui-colindex"));s.columnSpan=parseInt($.attr("colspan")||1);}else if($.hasClass("sapUiTableRowSelectionCell")){s.type=o.CELLTYPE.ROWHEADER;s.rowIndex=parseInt($.parent().attr("data-sap-ui-rowindex"));s.columnIndex=-1;s.columnSpan=1;}else if($.hasClass("sapUiTableRowActionCell")){s.type=o.CELLTYPE.ROWACTION;s.rowIndex=parseInt($.parent().attr("data-sap-ui-rowindex"));s.columnIndex=-2;s.columnSpan=1;}else if($.hasClass("sapUiTableRowSelectionHeaderCell")){s.type=o.CELLTYPE.COLUMNROWHEADER;s.columnIndex=-1;s.columnSpan=1;}else if($.hasClass("sapUiTablePseudoCell")){u=$.attr("data-sap-ui-colid");v=sap.ui.getCore().byId(u);s.type=o.CELLTYPE.PSEUDO;s.rowIndex=-1;s.columnIndex=v?v.getIndex():-1;s.columnSpan=1;}if(s.type!==0){s.cell=$;}s.isOfType=function(z){if(z==null){return false;}return(this.type&z)>0;};return s;},getRowColCell:function(s,u,v,w){var x=u>=0&&u<s.getRows().length?s.getRows()[u]:null;var y=w?s.getColumns():s._getVisibleColumns();var z=v>=0&&v<y.length?y[v]:null;var A=null;if(x&&z){if(w){if(z.shouldRender()){var V=s._getVisibleColumns();for(var i=0;i<V.length;i++){if(V[i]===z){A=x.getCells()[i];break;}}}}else{A=x.getCells()[v];}}return{row:x,column:z,cell:A};},getCell:function(i,E,s){s=s===true;if(!i||!E){return null;}var $=q(E);var u=i.getDomRef();var v=".sapUiTableCell";if(!s){v+=":not(.sapUiTablePseudoCell)";}var w=$.closest(v,u);if(w.length>0){return w;}return null;},getParentCell:function(i,E,s){s=s===true;var $=q(E);var u=o.getCell(i,E,s);if(!u||u[0]===$[0]){return null;}else{return u;}},registerResizeHandler:function(i,s,u,v,w){v=v==null?"":v;w=w===true;if(!i||typeof s!=="string"||typeof u!=="function"){return undefined;}var x=i.getDomRef(v);o.deregisterResizeHandler(i,s);if(!i._mResizeHandlerIds){i._mResizeHandlerIds={};}if(w&&x){x=x.parentNode;}if(x){i._mResizeHandlerIds[s]=R.register(x,u);}return i._mResizeHandlerIds[s];},deregisterResizeHandler:function(s,v){var u=[];if(!s._mResizeHandlerIds){return;}if(typeof v==="string"){u.push(v);}else if(v===undefined){for(var K in s._mResizeHandlerIds){if(typeof K=="string"&&s._mResizeHandlerIds.hasOwnProperty(K)){u.push(K);}}}else if(Array.isArray(v)){u=v;}for(var i=0;i<u.length;i++){var w=u[i];if(s._mResizeHandlerIds[w]){R.deregister(s._mResizeHandlerIds[w]);s._mResizeHandlerIds[w]=undefined;}}},isFirstScrollableRow:function(i,s){if(isNaN(s)){var $=q(s);s=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"));}return s==i._getRowCounts().fixedTop;},isLastScrollableRow:function(i,s){if(isNaN(s)){var $=q(s);s=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"));}var u=i._getRowCounts();return s==u.count-u.fixedBottom-1;},getContentDensity:function(s){var u;var v=["sapUiSizeCondensed","sapUiSizeCompact","sapUiSizeCozy"];var w=function(F,O){if(!O[F]){return;}for(var i=0;i<v.length;i++){if(O[F](v[i])){return v[i];}}};var $=s.$();if($.length>0){u=w("hasClass",$);}else{u=w("hasStyleClass",s);}if(u){return u;}var P=null;var x=s.getParent();if(x){do{u=w("hasStyleClass",x);if(u){return u;}if(x.getDomRef){P=x.getDomRef();}else if(x.getRootNode){P=x.getRootNode();}if(!P&&x.getParent){x=x.getParent();}else{x=null;}}while(x&&!P);}$=q(P||document.body);u=w("hasClass",$.closest("."+v.join(",.")));return u;},isVariableWidth:function(w){return!w||w=="auto"||w.toString().match(/%$/);},getFirstFixedBottomRowIndex:function(i){var s=i._getRowCounts();if(!i.getBinding("rows")||s.fixedBottom===0){return-1;}var F=-1;var u=i.getFirstVisibleRow();var v=i._getTotalRowCount();if(v>=s.count){F=s.count-s.fixedBottom;}else{var w=v-s.fixedBottom-u;if(w>=0&&(u+w)<v){F=w;}}return F;},getResourceBundle:function(O){O=q.extend({async:false,reload:false},O);if(r&&O.reload!==true){if(O.async===true){return Promise.resolve(r);}else{return r;}}var v=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table",O.async===true);if(v instanceof Promise){v=v.then(function(i){r=i;return r;});}else{r=v;}return v;},getResourceText:function(K,v){return r?r.getText(K,v):"";},dynamicCall:function(O,v,i){var s=typeof O==="function"?O():O;if(!s||!v){return undefined;}i=i||s;if(typeof v==="function"){v.call(i,s);return undefined;}else{var P;var u=[];for(var F in v){if(typeof s[F]==="function"){P=v[F];u.push(s[F].apply(i,P));}else{u.push(undefined);}}if(u.length===1){return u[0];}else{return u;}}},throttle:function(i,O){O=Object.assign({wait:0,leading:true},O);O.maxWait=O.wait;O.trailing=true;O.requestAnimationFrame=false;return o.debounce(i,O);},debounce:function(i,O){O=Object.assign({wait:0,maxWait:null,leading:false,asyncLeading:false,trailing:true,requestAnimationFrame:false},O);var L=null;var s=null;var u=null;var v=O.maxWait!=null;O.wait=Math.max(0,O.wait);O.maxWait=v?Math.max(O.maxWait,O.wait):O.maxWait;function w(J,K,N,P){L=P===true?null:Date.now();if(K==null){return;}if(N===true){var Q=Promise.resolve().then(function(){if(!Q.canceled){i.apply(J,K);}u=null;});Q.cancel=function(){Q.canceled=true;};u=Q;}else{i.apply(J,K);}}function x(J,K){y();function _(V){V=V!==false;if(V){A();}if(O.trailing){w(J,K,null,V);}}if(O.requestAnimationFrame){s=window.requestAnimationFrame(function(){_();});}else{var N=Date.now();var P=L==null?0:N-L;var Q=Math.max(0,v?Math.min(O.maxWait-P,O.wait):O.wait);var U=Q<O.wait;s=setTimeout(function(){if(U){var V=Math.max(0,(Date.now()-N)-Q);var W=O.wait-Q;if(V>W){_();}else{s=setTimeout(A,W-V);_(false);}}else{_();}},Q);}}function y(){if(O.requestAnimationFrame){window.cancelAnimationFrame(s);}else{clearTimeout(s);}s=null;}function z(){if(u){u.cancel();u=null;}}function A(){y();z();L=null;}function E(){return s!=null;}var F=function(){if(!E()&&!O.leading){w();}if(E()||!O.leading){x(this,arguments);}else if(O.asyncLeading){w(this,arguments,true);x();}else{x();w(this,arguments);}};F.cancel=A;F.pending=E;return F;},getInteractiveElements:function(i){if(!i){return null;}var $=q(i);var s=o.getCellInfo($);if(s.isOfType(g.ANY|g.PSEUDO)){var u=$.find(I);if(u.length>0){return u;}}return null;},convertCSSSizeToPixel:function(s,w){var P;if(typeof s!=="string"){return null;}if(s.endsWith("px")){P=parseInt(s);}else if(s.endsWith("em")||s.endsWith("rem")){P=Math.ceil(parseFloat(s)*o.getBaseFontSize());}else{return null;}if(w){return P+"px";}else{return P;}},getBaseFontSize:function(){if(f==null){var i=document.documentElement;if(i){f=parseInt(window.getComputedStyle(i).fontSize);}}return f==null?16:f;},readThemeParameters:function(){function i(s){return o.convertCSSSizeToPixel(T.get(s));}m.undefined=i("_sap_ui_table_BaseSize");m.sapUiSizeCozy=i("_sap_ui_table_BaseSizeCozy");m.sapUiSizeCompact=i("_sap_ui_table_BaseSizeCompact");m.sapUiSizeCondensed=i("_sap_ui_table_BaseSizeCondensed");h=i("_sap_ui_table_BaseBorderWidth");j=h;D.undefined=m.undefined+j;D.sapUiSizeCozy=m.sapUiSizeCozy+j;D.sapUiSizeCompact=m.sapUiSizeCompact+j;D.sapUiSizeCondensed=m.sapUiSizeCondensed+j;t.navigationIcon=T.get("_sap_ui_table_NavigationIcon");t.deleteIcon=T.get("_sap_ui_table_DeleteIcon");t.resetIcon=T.get("_sap_ui_table_ResetIcon");t.navIndicatorWidth=i("_sap_ui_table_NavIndicatorWidth");},selectElementText:function(E){if(n(E)){E.select();}},deselectElementText:function(E){if(n(E)){E.setSelectionRange(0,0);}},addDelegate:function(E,i,s){if(E&&i){E.addDelegate(i,false,s?s:i,false);}},removeDelegate:function(E,i){if(E&&i){E.removeDelegate(i);}}};G.TableUtils=o;C.TableUtils=o;M.TableUtils=o;B.TableUtils=o;H.TableUtils=o;return o;},true);
sap.ui.predefine('sap/ui/table/utils/_BindingUtils',[],function(){"use strict";var B={TableUtils:null,metadataLoaded:function(t){var b=t.getBinding("rows");var m=b?b.getModel():null;var r=null;var R=null;var p=new Promise(function(a,c){r=a;R=c;});if(!m){R();return p;}if(m.metadataLoaded){m.metadataLoaded().then(function(){r();});}else if(m.attachMetadataLoaded){if(m.oMetadata&&m.oMetadata.isLoaded()){r();}else{m.attachMetadataLoaded(function(){r();});}}return p;}};return B;},true);
sap.ui.predefine('sap/ui/table/utils/_ColumnUtils',["sap/ui/Device","../library","sap/base/Log"],function(D,l,L){"use strict";var C={TableUtils:null,initColumnUtils:function(t){if(!t._oColumnInfo){C.updateColumnInfo(t,C.collectColumnInfo(t));}},invalidateColumnUtils:function(t){t._oColumnInfo=null;},updateColumnInfo:function(t,c){t._oColumnInfo=c;},collectColumnInfo:function(t){return{columnCount:t.getColumns().length,visibleColumnCount:C.TableUtils.getVisibleColumnCount(t),columnMap:C.getColumnMap(t)};},getColumnMap:function(t){var i;var c;var o={};var a={};var b=t.getColumns();var m=C.TableUtils.getHeaderRowCount(t);var p={};for(var d=0;d<b.length;d++){c=b[d];o={};o.id=c.getId();o.column=c;o.levelInfo=[];o.parents=[];for(var e=0;e<m;e++){o.levelInfo[e]={};o.levelInfo[e].spannedColumns=[];var h=C.getHeaderSpan(c,e);for(i=1;i<h;i++){var s=b[d+i];if(s){var P=s.getId();o.levelInfo[e].spannedColumns.push(b[d+i]);if(!p[P]){p[P]=[];}p[P].push({column:c,level:e});}}}a[o.id]=o;}var f=Object.keys(p);for(i=0;i<f.length;i++){var g=f[i];a[g].parents=p[g];}return a;},getColumnMapItem:function(t,c){C.initColumnUtils(t);var s=t._oColumnInfo.columnMap[c];if(!s){L.error("Column with ID '"+c+"' not found",t);}else{return s;}},getParentSpannedColumns:function(t,c,a){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var p=[];for(var i=0;i<o.parents.length;i++){var P=o.parents[i];if(a===undefined||P.level===a){p.push(P);}}return p;},getChildrenSpannedColumns:function(t,c,a){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var b=[];var e;if(a===undefined){e=o.levelInfo.length;}else{e=a+1;}for(var i=a||0;i<e;i++){var d=o.levelInfo[i];for(var j=0;j<d.spannedColumns.length;j++){b.push({column:d.spannedColumns[j],level:i});}}return b;},getHeaderSpan:function(c,i){var h=c.getHeaderSpan();var H;if(!h){return 1;}if(!Array.isArray(h)){h=(h+"").split(",");}function g(s){var r=parseInt(s);return isNaN(r)?1:r;}if(isNaN(i)){H=Math.max.apply(null,h.map(g));}else{H=g(h[i]);}return Math.max(H,1);},getMaxHeaderSpan:function(c){return C.getHeaderSpan(c);},hasHeaderSpan:function(c){return C.getHeaderSpan(c)>1;},getColumnBoundaries:function(t,c){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var m={};if(c){m[c]=o.column;}var T=function(m,n){var e;var i;var f=[];n=n||[];for(i=0;i<n.length;i++){e=m[n[i]];f=f.concat(C.getParentSpannedColumns(t,e.getId()));f=f.concat(C.getChildrenSpannedColumns(t,e.getId()));}n=[];for(i=0;i<f.length;i++){e=f[i].column;var c=e.getId();if(!m[c]){n.push(c);m[c]=e;}}if(n.length>0){return T(m,n);}else{return m;}};m=T(m,[c]);var a=t.indexOfColumn(o.column);var b={startColumn:o.column,startIndex:a,endColumn:o.column,endIndex:-1};var d=t.getColumns();var k=Object.getOwnPropertyNames(m);for(var i=0;i<k.length;i++){var e=m[k[i]];a=t.indexOfColumn(e);var h=C.getMaxHeaderSpan(e);if(a<b.startIndex){b.startIndex=a;b.startColumn=e;}var E=a+h-1;if(E>b.endIndex){b.endIndex=E;b.endColumn=d[E];}}return b;},isColumnMovable:function(c){var t=c.getParent();if(!t||!t.getEnableColumnReordering()){return false;}var i=t.indexOfColumn(c);if(i<t.getComputedFixedColumnCount()||i<t._iFirstReorderableIndex){return false;}if(C.hasHeaderSpan(c)||C.getParentSpannedColumns(t,c.getId()).length!=0){return false;}return true;},normalizeColumnMoveTargetIndex:function(c,n){var t=c.getParent(),i=t.indexOfColumn(c),a=t.getColumns();if(n>i){n--;}if(n<0){n=0;}else if(n>a.length){n=a.length;}return n;},isColumnMovableTo:function(c,n){var t=c.getParent();if(!t||n===undefined||!C.isColumnMovable(c)){return false;}n=C.normalizeColumnMoveTargetIndex(c,n);if(n<t.getComputedFixedColumnCount()||n<t._iFirstReorderableIndex){return false;}var i=t.indexOfColumn(c),a=t.getColumns();if(n>i){var b=a[n>=a.length?a.length-1:n];var T=C.getColumnBoundaries(t,b.getId());if(C.hasHeaderSpan(b)||T.endIndex>n){return false;}}else{var A=a[n];if(C.getParentSpannedColumns(t,A.getId()).length!=0){return false;}}return true;},moveColumnTo:function(c,n){if(!C.isColumnMovableTo(c,n)){return false;}var t=c.getParent(),i=t.indexOfColumn(c);if(n===i){return false;}n=C.normalizeColumnMoveTargetIndex(c,n);var e=t.fireColumnMove({column:c,newPos:n});if(!e){return false;}t._bReorderInProcess=true;t.removeColumn(c,true);t.insertColumn(c,n);t._bReorderInProcess=false;return true;},getMinColumnWidth:function(){if(this._iColMinWidth){return this._iColMinWidth;}this._iColMinWidth=48;if(!D.system.desktop){this._iColMinWidth=88;}return this._iColMinWidth;},resizeColumn:function(t,c,w,f,a){if(!t||c==null||c<0||w==null||w<=0){return false;}if(a==null||a<=0){a=1;}if(f==null){f=true;}var b=t.getColumns();if(c>=b.length||!b[c].getVisible()){return false;}var v=[];for(var i=c;i<b.length;i++){var o=b[i];if(o.getVisible()){v.push(o);if(v.length===a){break;}}}var r=[];for(var i=0;i<v.length;i++){var V=v[i];if(V.getResizable()){r.push(V);}}if(r.length===0){return false;}var s=0;for(var i=0;i<v.length;i++){var V=v[i];s+=C.getColumnWidth(t,V.getIndex());}var p=w-s;var S=Math.round(p/r.length);var R=false;var T=t.getDomRef();if(!C.TableUtils.isFixedColumn(t,c)){t._getVisibleColumns().forEach(function(k){var m=k.getWidth(),q;if(T&&r.indexOf(k)<0&&C.TableUtils.isVariableWidth(m)){q=T.querySelector("th[data-sap-ui-colid=\""+k.getId()+"\"]");if(q){k._minWidth=Math.max(q.offsetWidth,C.getMinColumnWidth());}}});}for(var i=0;i<r.length;i++){var d=r[i];var e=C.getColumnWidth(t,d.getIndex());var n=e+S;var g=C.getMinColumnWidth();if(n<g){n=g;}var W=n-e;if(Math.abs(W)<Math.abs(S)){var h=r.length-(i+1);p-=W;S=Math.round(p/h);}if(W!==0){var E=true;var j=n+"px";if(f){E=t.fireColumnResize({column:d,width:j});}if(E){d.setWidth(j);R=true;}}}return R;},getColumnWidth:function(t,c){if(!t||c==null||c<0){return null;}var a=t.getColumns();if(c>=a.length){return null;}var o=a[c];var s=o.getWidth();if(s===""||s==="auto"||s.match(/%$/)){if(o.getVisible()){var b=o.getDomRef();return b?b.offsetWidth:0;}else{return 0;}}else{return C.TableUtils.convertCSSSizeToPixel(s);}},getFixedColumnCount:function(t,c){var f=t.getComputedFixedColumnCount();if(!c){return f;}if(f<=0||t._bIgnoreFixedColumnCount){return 0;}var a=t.getColumns();var v=0;f=Math.min(f,a.length);for(var i=0;i<f;i++){if(a[i].shouldRender()){v++;}}return v;},getHeaderText:function(t,c){if(!t||c==null||c<0){return null;}var a=t.getColumns();if(c>=a.length){return null;}function g(b){return b&&b.getText&&b.getText()||"";}var o=a[c];var T=o.getName();if(!T){var m=o.getMultiLabels();for(var i=m.length-1;i>=0;i--){var s=g(m[i]);if(C.getHeaderSpan(o,i)===1&&s){T=s;break;}}}if(!T){T=g(o.getLabel());}return T;}};return C;},true);
sap.ui.predefine('sap/ui/table/utils/_GroupingUtils',["sap/ui/core/Element","sap/ui/model/Sorter","sap/ui/Device","../library","sap/ui/thirdparty/jquery"],function(E,S,D,l,q){"use strict";var G={TableUtils:null,clearMode:function(t){t._mode=null;},setGroupMode:function(t){t._mode="Group";},isGroupMode:function(t){return t?t._mode==="Group":false;},setTreeMode:function(t){t._mode="Tree";},isTreeMode:function(t){return t?t._mode==="Tree":false;},getModeCssClass:function(t){switch(t._mode){case"Group":return"sapUiTableGroupMode";case"Tree":return"sapUiTableTreeMode";default:return null;}},showGroupMenuButton:function(t){return!D.system.desktop&&G.TableUtils.isA(t,"sap.ui.table.AnalyticalTable");},toggleGroupHeader:function(t,r,e){var I=[];var B=t?t.getBinding("rows"):null;if(!t||!B||!B.expand||r==null){return null;}if(typeof r==="number"){I=[r];}else if(Array.isArray(r)){if(e==null&&r.length>1){return null;}I=r;}var T=t._getTotalRowCount();var v=I.filter(function(a){var b=B.isExpanded(a);var c=true;if(B.nodeHasChildren){if(B.getNodeByIndex){c=!B.nodeHasChildren(B.getNodeByIndex(a));}else{c=false;}}return a>=0&&a<T&&!c&&e!==b;}).sort(function(a,b){return a-b;});if(v.length===0){return null;}for(var i=v.length-1;i>0;i--){if(e){B.expand(v[i],true);}else{B.collapse(v[i],true);}}if(e===true){B.expand(v[0],false);}else if(e===false){B.collapse(v[0],false);}else{B.toggleIndex(v[0]);}return B.isExpanded(v[0]);},toggleGroupHeaderByRef:function(t,r,e){var c=G.TableUtils.getCell(t,r);var C=G.TableUtils.getCellInfo(c);var R=t.getRows()[C.rowIndex];var b=t.getBinding("rows");if(R&&R.isExpandable()&&b){var a=R.getIndex();var i=G.toggleGroupHeader(t,a,e);var d=i===true||i===false;if(d&&t._onGroupHeaderChanged){t._onGroupHeaderChanged(a,i);}return d;}return false;},isInGroupHeaderRow:function(c){var i=G.TableUtils.getCellInfo(c);if(i.isOfType(G.TableUtils.CELLTYPE.ANYCONTENTCELL)){return i.cell.parent().hasClass("sapUiTableGroupHeaderRow");}return false;},isInSummaryRow:function(c){var i=G.TableUtils.getCellInfo(c);if(i.isOfType(G.TableUtils.CELLTYPE.ANYCONTENTCELL)){return i.cell.parent().hasClass("sapUiTableSummaryRow");}return false;},calcGroupIndent:function(r){var L=r.getLevel();var I=0;for(var i=1;i<L;i++){I+=i<=2?12:8;}return I;},calcTreeIndent:function(r){return(r.getLevel()-1)*17;},setGroupIndent:function(r,i){var d=r.getDomRefs(true);var R=d.row;var $=d.rowHeaderPart;var b=r.getTable()._bRtlMode;var f=R.find("td.sapUiTableCellFirst > .sapUiTableCellInner");var s=$.find(".sapUiTableGroupShield");if(i<=0){$.css(b?"right":"left","");s.css("width","").css(b?"margin-right":"margin-left","");f.css(b?"padding-right":"padding-left","");}else{$.css(b?"right":"left",i+"px");s.css("width",i+"px").css(b?"margin-right":"margin-left",((-1)*i)+"px");f.css(b?"padding-right":"padding-left",(i+8)+"px");}},setTreeIndent:function(r,i){var d=r.getDomRefs(true);var R=d.row;var b=r.getTable()._bRtlMode;var t=R.find(".sapUiTableTreeIcon");t.css(b?"margin-right":"margin-left",i>0?i+"px":"");},updateTableRowForGrouping:function(r){var t=r.getTable();var d=r.getDomRefs(true);var R=d.row;var L=r.getLevel();var i=r.isExpanded();var I=r.isExpandable();R.attr({"data-sap-ui-level":L}).data("sap-ui-level",L).toggleClass("sapUiTableSummaryRow",r.isSummary()).toggleClass("sapUiTableGroupHeaderRow",r.isGroupHeader());if(G.isGroupMode(t)){var T=r.getTitle();var a=G.calcGroupIndent(r);r.$("groupHeader").toggleClass("sapUiTableGroupIconOpen",I&&i).toggleClass("sapUiTableGroupIconClosed",I&&!i).attr("title",t._getShowStandardTooltips()&&T?T:null).text(T);G.setGroupIndent(r,a);R.toggleClass("sapUiTableRowIndented",a>0);}if(G.isTreeMode(t)){var $=R.find(".sapUiTableTreeIcon");$.toggleClass("sapUiTableTreeIconLeaf",!I).toggleClass("sapUiTableTreeIconNodeOpen",I&&i).toggleClass("sapUiTableTreeIconNodeClosed",I&&!i);G.setTreeIndent(r,G.calcTreeIndent(r));}if(G.showGroupMenuButton(t)){var b=d.rowHeaderPart;var s=0;var c=t.$();if(c.hasClass("sapUiTableVScr")){s+=c.find(".sapUiTableVSb").width();}var g=b.find(".sapUiTableGroupMenuButton");if(t._bRtlMode){g.css("right",(c.width()-g.width()+b.position().left-s-5)+"px");}else{g.css("left",(c.width()-g.width()-b.position().left-s-5)+"px");}}t._getAccExtension().updateAriaExpandAndLevelState(r);},cleanupTableRowForGrouping:function(r){var t=r.getTable();var d=r.getDomRefs(true);d.row.removeAttr("data-sap-ui-level");d.row.removeData("sap-ui-level");if(G.isGroupMode(t)){d.row.removeClass("sapUiTableGroupHeaderRow sapUiTableSummaryRow sapUiTableRowIndented");r.$("groupHeader").removeClass("sapUiTableGroupIconOpen","sapUiTableGroupIconClosed").attr("title","").text("");G.setGroupIndent(r,0);}if(G.isTreeMode(t)){d.row.find(".sapUiTableTreeIcon").removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed");G.setTreeIndent(r,0);}t._getAccExtension().updateAriaExpandAndLevelState(r);},updateGroups:function(t){if(G.isGroupMode(t)||G.isTreeMode(t)){var b=t.getBinding("rows");if(b){t.getRows().forEach(function(r){G.updateTableRowForGrouping(r);});}else{t.getRows().forEach(function(r){G.cleanupTableRowForGrouping(r);});}}},setupExperimentalGrouping:function(t){if(!t.getEnableGrouping()){return;}var b=E.prototype.getBinding.call(t,"rows");var g=sap.ui.getCore().byId(t.getGroupBy());var I=g&&g.getGrouped()&&G.TableUtils.isA(b,"sap.ui.model.ClientListBinding");if(!I||b._modified){return;}b._modified=true;G.setGroupMode(t);var p=g.getSortProperty();b.sort(new S(p));var L=t._getTotalRowCount(),c=b.getContexts(0,L);var k;var C=0;for(var i=L-1;i>=0;i--){var n=c[i].getProperty(p);if(!k){k=n;}if(k!==n){var o=c[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);o.__groupInfo={oContext:c[i+1],name:k,count:C,groupHeader:true,expanded:true};c.splice(i+1,0,o);k=n;C=0;}C++;}var o=c[0].getModel().getContext("/sap.ui.table.GroupInfo");o.__groupInfo={oContext:c[0],name:k,count:C,groupHeader:true,expanded:true};c.splice(0,0,o);q.extend(b,{getLength:function(){return c.length;},getContexts:function(s,L){return c.slice(s,s+L);},isGroupHeader:function(a){var d=c[a];return(d&&d.__groupInfo&&d.__groupInfo.groupHeader)===true;},getTitle:function(a){var d=c[a];return d&&d.__groupInfo&&d.__groupInfo.name+" - "+d.__groupInfo.count;},isExpanded:function(a){var d=c[a];return this.isGroupHeader(a)&&d.__groupInfo&&d.__groupInfo.expanded;},expand:function(a){if(this.isGroupHeader(a)&&!c[a].__groupInfo.expanded){for(var i=0;i<c[a].__childs.length;i++){c.splice(a+1+i,0,c[a].__childs[i]);}delete c[a].__childs;c[a].__groupInfo.expanded=true;this._fireChange();}},collapse:function(a){if(this.isGroupHeader(a)&&c[a].__groupInfo.expanded){c[a].__childs=c.splice(a+1,c[a].__groupInfo.count);c[a].__groupInfo.expanded=false;this._fireChange();}},toggleIndex:function(a){if(this.isExpanded(a)){this.collapse(a);}else{this.expand(a);}},nodeHasChildren:function(a){if(!a||!a.__groupInfo){return false;}else{return a.__groupInfo.groupHeader===true;}},getNodeByIndex:function(a){return c[a];}});t._experimentalGroupingRowState=function(s){var a=s.context;if((a&&a.__groupInfo&&a.__groupInfo.groupHeader)===true){s.type=s.Type.GroupHeader;}s.title=a&&a.__groupInfo&&a.__groupInfo.name+" - "+a.__groupInfo.count;s.expandable=s.type===s.Type.GroupHeader;s.expanded=s.expandable&&a.__groupInfo&&a.__groupInfo.expanded;s.level=s.expandable?1:2;s.contentHidden=s.expandable;};G.TableUtils.Hook.register(t,G.TableUtils.Hook.Keys.Row.UpdateState,t._experimentalGroupingRowState,t);t._mTimeouts.groupingFireBindingChange=t._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){b._fireChange();},0);},resetExperimentalGrouping:function(t){var b=t.getBinding("rows");if(b&&b._modified){G.clearMode(t);var B=t.getBindingInfo("rows");t.unbindRows();t.bindRows(B);}G.TableUtils.Hook.deregister(t,G.TableUtils.Hook.Keys.Row.UpdateState,t._experimentalGroupingRowState,t);}};return G;},true);
sap.ui.predefine('sap/ui/table/utils/_HookUtils',["sap/ui/base/DataType","sap/base/Log"],function(D,L){"use strict";var H=new window.WeakMap();var M={};var k={};var h={};var f=["function"];var a={};var m={Table:{BindRows:{arguments:["object"]},RowsBound:{arguments:["class:sap.ui.model.Binding"]},UnbindRows:{arguments:["object"]},RowsUnbound:{arguments:[]},RefreshRows:{arguments:[function(r){return r in a.TableUtils.RowsUpdateReason||D.getType("sap.ui.model.ChangeReason").isValid(r);}]},UpdateRows:{arguments:[function(r){return r in a.TableUtils.RowsUpdateReason||D.getType("sap.ui.model.ChangeReason").isValid(r);}]},UpdateSizes:{arguments:[function(r){return r in a.TableUtils.RowsUpdateReason||D.getType("sap.ui.model.ChangeReason").isValid(r);}]},OpenMenu:{arguments:[function(C){return C?typeof C.isOfType==="function":false;},"class:sap.ui.unified.Menu"]}},Row:{UpdateState:{arguments:[function(r){return r!=null&&r.hasOwnProperty("context")&&r.hasOwnProperty("Type")&&r.hasOwnProperty("type")&&r.type in r.Type;}]}},Column:{MenuItemNotification:{arguments:["class:sap.ui.table.Column"],returnValue:"boolean"}},Signal:{arguments:["string"]}};a.TableUtils=null;a.Keys=k;
a.call=function(s,K){var i=H.get(s);if(!c(s)||!b(K)){return undefined;}var m=g(K);if(i==null){if(m.returnValue){return[];}return undefined;}var A=Array.prototype.slice.call(arguments,2);var j=v(m,A);if(!j){throw new Error("Hook with key "+K+" was not called. Invalid arguments passed\n"+s);}var r=i.map(function(o){if(o.key===M){var C={};var l=o.handlerContext==null?o.target:o.handlerContext;C[K]=A;return a.TableUtils.dynamicCall(o.target,C,l);}else if(o.key===K){return o.handler.apply(o.handlerContext,A);}});r=d(m,r);return r;};
a.install=function(s,t,T){if(!t||!c(s)){return;}var i=H.get(s);if(i==null){i=[];}var j=i.some(function(o){return o.key===M&&o.target===t&&o.handlerContext===T;});if(j){return;}i.push({key:M,target:t,handlerContext:T});H.set(s,i);};
a.uninstall=function(s,t,T){var j=H.get(s);if(j==null||!t){return;}for(var i=0;i<j.length;i++){var o=j[i];if(o.key===M&&o.target===t&&o.handlerContext===T){j.splice(i,1);break;}}if(j.length===0){H.delete(s);}else{H.set(s,j);}};
a.register=function(s,K,i,t){if(typeof i!=="function"||!c(s)||!b(K)){return;}var j=H.get(s);if(j==null){j=[];}j.push({key:K,handler:i,handlerContext:t});H.set(s,j);};
a.deregister=function(s,K,j,t){var l=H.get(s);if(l==null){return;}for(var i=0;i<l.length;i++){var o=l[i];if(o.key===K&&o.handler===j&&o.handlerContext===t){l.splice(i,1);break;}}if(l.length===0){H.delete(s);}else{H.set(s,l);}};
function e(K,C,s){Object.keys(C).forEach(function(p){var i=s?s+"."+p:p;if("arguments"in C[p]){f.forEach(function(F){if(C[p].arguments.indexOf(F)>-1||C[p].returnValue===F){throw new Error("Forbidden type found in metadata of hook "+s+": "+F);}});K[p]=i;h[i]=C[p];}else{K[p]={};e(K[p],C[p],i);}});return K;}
e(k,m);
function b(K){return K in h;}
function c(s){return a.TableUtils.isA(s,"sap.ui.table.Table")&&!s.bIsDestroyed&&!s._bIsBeingDestroyed;}
function g(K){return h[K];}
function v(m,A){return m.arguments.length===A.length&&m.arguments.every(function(t,i){if(typeof t==="function"){return t(A[i]);}else if(t.startsWith("class:")){return a.TableUtils.isA(A[i],t.substring(6));}else{return D.getType(t).isValid(A[i]);}});}
function d(m,V){if(!m.returnValue){return undefined;}var t=m.returnValue;return V.filter(function(i){if(i==null){return false;}else if(typeof t==="function"){return t(i);}else if(t==="Promise"){return i instanceof Promise;}else if(t.startsWith("class:")){return a.TableUtils.isA(i,t.substring(6));}else{return D.getType(t).isValid(i);}});}
return a;},true);
sap.ui.predefine('sap/ui/table/utils/_MenuUtils',["sap/ui/Device","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/core/Popup"],function(D,M,a,P){"use strict";P.setInitialZIndex(10);
function o(c,r){var R=r.getRowBindingContext();var f=c.getFilterProperty();var F=R.getProperty(f);if(F!=null&&typeof F!=="string"){F=F.toString();}if(this.getEnableCustomFilter()){this.fireCustomFilter({column:c,value:F});}else{this.filter(c,F);}}
var b={TableUtils:null,openContextMenu:function(t,e,E){if(!t||!e){return false;}var c=b.TableUtils.getCell(t,e);var C=c?c[0]:null;var d=b.TableUtils.getCellInfo(C);var i=d.columnIndex;var r=d.rowIndex;var f=true;if(d.isOfType(b.TableUtils.CELLTYPE.COLUMNHEADER)){var g=C.querySelector(".sapUiTableColDropDown")!==null;if(D.system.desktop||g){b._removeColumnHeaderCellMenu(t);f=t.fireColumnSelect({column:t.getColumns()[i]});if(f){return b._openColumnContextMenu(t,C);}else{return true;}}else{return b._applyColumnHeaderCellMenu(t,C);}}else if(d.isOfType(b.TableUtils.CELLTYPE.ANYCONTENTCELL)){var R=b.TableUtils.getRowColCell(t,r,i,i>=0);var h=R.row;var j;var k=t.getBindingInfo("rows");if(k){j=h.getBindingContext(k.model);}if(i>=0){f=t.fireCellContextmenu({rowIndex:h.getIndex(),columnIndex:i,columnId:R.column.getId(),cellControl:R.cell,rowBindingContext:j,cellDomRef:C});}if(f){var l=t.getContextMenu();if(l&&k){l.setBindingContext(j,k.model);}f=t.fireBeforeOpenContextMenu({rowIndex:h.getIndex(),columnIndex:R.column?i:null,contextMenu:l});}if(f){return b._openContentCellContextMenu(t,C,E);}else{return true;}}return false;},_openColumnContextMenu:function(t,c){var C=b.TableUtils.getCellInfo(c);var d=t.getColumns();var e=d[C.columnIndex];for(var i=0;i<d.length;i++){if(d[i]!==e){b._closeColumnContextMenu(t,i);}}b._closeContentCellContextMenu(t);var s=c.getAttribute("colspan");if(s&&s!=="1"){return false;}return e._openMenu(c);},_closeColumnContextMenu:function(t,c){t.getColumns()[c]._closeMenu();},_openContentCellContextMenu:function(t,c,e){var C=b.TableUtils.getCellInfo(c);if(C.rowIndex>=b.TableUtils.getNonEmptyVisibleRowCount(t)){return false;}if(b.hasCustomContextMenu(t)){return b._openCustomContentCellContextMenu(t,c,e);}else{return b._openDefaultContentCellContextMenu(t,c,e);}},_openCustomContentCellContextMenu:function(t,c,e){var C=b.TableUtils.getCellInfo(c);var r=t.getRows()[C.rowIndex];if(r.isGroupHeader()||r.isSummary()){return false;}var d=t.getContextMenu();var f=t.getColumns();for(var i=0;i<f.length;i++){b._closeColumnContextMenu(t,i);}b._closeDefaultContentCellContextMenu(t);if(e){d.openAsContextMenu(e,c);}else if(typeof d.openBy==="function"){d.openBy(c);}else{d.open(null,c,P.Dock.BeginTop,P.Dock.BeginBottom,c);}return true;},_openDefaultContentCellContextMenu:function(t,c,e){var C=b.TableUtils.getCellInfo(c);var r=C.rowIndex;var R=t.getRows()[r];var d=C.columnIndex;var f=t.getColumns();var g=f[d];if(!t._oCellContextMenu){t._oCellContextMenu=new M(t.getId()+"-cellcontextmenu");}var s=t._oCellContextMenu.getId()+"-cellfilter";var h=sap.ui.getCore().byId(s);if(t.getEnableCellFilter()&&g&&g.isFilterableByMenu()&&!R.isGroupHeader()){if(!h){h=new a({id:s,text:b.TableUtils.getResourceText("TBL_FILTER")});h._onSelect=o.bind(t,g,R);h.attachSelect(h._onSelect);}else{h.detachSelect(h._onSelect);h._onSelect=o.bind(t,g,R);h.attachSelect(h._onSelect);}t._oCellContextMenu.insertItem(h,0);}else{t._oCellContextMenu.removeItem(h);}b.TableUtils.Hook.call(t,b.TableUtils.Hook.Keys.Table.OpenMenu,C,t._oCellContextMenu);if(t._oCellContextMenu.getItems().length===0){return false;}for(var i=0;i<f.length;i++){b._closeColumnContextMenu(t,i);}b._closeCustomContentCellContextMenu(t);if(e){t._oCellContextMenu.openAsContextMenu(e,c);}else{t._oCellContextMenu.open(null,c,P.Dock.BeginTop,P.Dock.BeginBottom,c);}return true;},_closeContentCellContextMenu:function(t){b._closeCustomContentCellContextMenu(t);b._closeDefaultContentCellContextMenu(t);},_closeCustomContentCellContextMenu:function(t){var c=t.getContextMenu();var C=c?c.bOpen:false;if(C){c.close();}},_closeDefaultContentCellContextMenu:function(t){var d=t._oCellContextMenu;var c=d?d.bOpen:false;if(c){d.close();}},cleanupDefaultContentCellContextMenu:function(t){if(!t||!t._oCellContextMenu){return;}var c=t._oCellContextMenu.getId()+"-cellfilter";var C=sap.ui.getCore().byId(c);t._oCellContextMenu.removeAllItems();t._oCellContextMenu.destroy();t._oCellContextMenu=null;if(C){C.destroy();}},_applyColumnHeaderCellMenu:function(t,c){var C=b.TableUtils.getCellInfo(c);var d=t.getColumns()[C.columnIndex];var s=c.getAttribute("colspan");var e=c.querySelector(".sapUiTableCellInner");var f=c.querySelector(".sapUiTableCellTouchMenu")!==null;if(s&&s!=="1"||f||(!d.getResizable()&&!d._menuHasItems())){return false;}var g=document.createElement("div");b._removeColumnHeaderCellMenu(t);e.style.display="none";if(d._menuHasItems()){var h;h=document.createElement("div");h.classList.add("sapUiTableColDropDown");h.textContent="";g.appendChild(h);}if(d.getResizable()){var i;i=document.createElement("div");i.classList.add("sapUiTableColResizer");i.textContent="";g.appendChild(i);}g.classList.add("sapUiTableCellTouchMenu");c.appendChild(g);var j=function(){b._removeColumnHeaderCellMenu(t);c.removeEventListener("focusout",j);};c.addEventListener("focusout",j);return true;},_removeColumnHeaderCellMenu:function(t){var c=t&&t.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(c.length){c.parent().find(".sapUiTableCellInner").show();c.remove();}},hasCustomContextMenu:function(t){return t!=null&&t.getContextMenu()!=null;}};return b;},true);
sap.ui.require.preload({
	"sap/ui/table/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.table","type":"library","embeds":[],"applicationVersion":{"version":"1.82.2"},"title":"Table-like controls, mainly for desktop scenarios.","description":"Table-like controls, mainly for desktop scenarios.","ach":"CA-UI5-TBL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.82","libs":{"sap.ui.core":{"minVersion":"1.82.2"},"sap.ui.unified":{"minVersion":"1.82.2"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en-US-sappsd","en-US-saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.CreationRow","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],"elements":["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings","sap.ui.table.rowmodes.RowMode","sap.ui.table.rowmodes.FixedRowMode","sap.ui.table.rowmodes.InteractiveRowMode","sap.ui.table.rowmodes.AutoRowMode","sap.ui.table.plugins.MultiSelectionPlugin","sap.ui.table.plugins.SelectionPlugin"],"types":["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.TreeAutoExpandMode"],"interfaces":[]}}}}'
},"sap/ui/table/library-preload"
);
//# sourceMappingURL=library-preload.js.map