/// \file
/// \ingroup tutorial_io
/// \notebook -nodraw
/// Example of script to loop on all the objects of a ROOT file directory
/// and print on Postscript all TH1 derived objects.
/// This script uses the file generated by tutorial hsimple.C
///
/// \macro_image
/// \macro_code
///
/// \author Rene Brun

void loopdir() {
   TFile *f1 = TFile::Open("hsimple.root");
   TIter keyList(f1->GetListOfKeys());
   TKey *key;
   TCanvas c1;
   c1.Print("hsimple.ps[");
   while ((key = (TKey*)keyList())) {
      TClass *cl = gROOT->GetClass(key->GetClassName());
      if (!cl->InheritsFrom("TH1")) continue;
      TH1 *h = (TH1*)key->ReadObj();
      h->Draw();
      c1.Print("hsimple.ps");
   }
   c1.Print("hsimple.ps]");
}

