void open_session(void *p = 0) {
//=========Macro generated by ROOT version3.00/00
//=========for tree "T" (Wed Feb 21 14:16:23 2001)
//===This macro can be opened from a TreeViewer session after loading
//===the corresponding tree
   TTreeViewer *treeview = (TTreeViewer *) p;
   if (!treeview) treeview = new TTreeViewer();
   TTree *tv_tree = (TTree*)gROOT->FindObject("T");
   TFile *tv_file = (TFile*)gROOT->GetListOfFiles()->FindObject("Event.root");
   if (!tv_tree) {
      if (!tv_file) tv_file = new TFile("$ROOTSYS/test/Event.root");
      if (tv_file)  tv_tree = (TTree*)tv_file->Get("T");
      if(!tv_tree) {
         printf("Tree not found\n");
         return;
      }
   }

   treeview->SetTreeName("T");
   treeview->SetNexpressions(10);
//         Set expressions on axis and cut
   TTVLVEntry *item;
//   X expression
   item = treeview->ExpressionItem(0);
   item->SetExpression("fTemperature", "fTemperature");
//   Y expression
   item = treeview->ExpressionItem(1);
   item->SetExpression("", "-empty-");
//   Z expression
   item = treeview->ExpressionItem(2);
   item->SetExpression("", "-empty-");
//   Cut expression
   item = treeview->ExpressionItem(3);
   item->SetExpression("", "-empty-");
//         Scan list
   item = treeview->ExpressionItem(4);
   item->SetExpression("", "Scan box");
//         User defined expressions
   item = treeview->ExpressionItem(5);
   item->SetExpression("sqrt(fTracks.fPx*fTracks.fPx+fTracks.fPy*fTracks.fPy)", "~Pt", kFALSE);
   item = treeview->ExpressionItem(6);
   item->SetExpression("fTracks.fPx>0", "~Cut1", kTRUE);
   item = treeview->ExpressionItem(7);
   item->SetExpression("", "-empty-", kFALSE);
   item = treeview->ExpressionItem(8);
   item->SetExpression("", "-empty-", kFALSE);
   item = treeview->ExpressionItem(9);
   item->SetExpression("", "-empty-", kFALSE);
   item = treeview->ExpressionItem(10);
   item->SetExpression("", "-empty-", kFALSE);
   item = treeview->ExpressionItem(11);
   item->SetExpression("", "-empty-", kFALSE);
   item = treeview->ExpressionItem(12);
   item->SetExpression("", "-empty-", kFALSE);
   item = treeview->ExpressionItem(13);
   item->SetExpression("", "-empty-", kFALSE);
   item = treeview->ExpressionItem(14);
   item->SetExpression("", "-empty-", kFALSE);
//--- session object
   auto tv_session = new TTVSession(treeview);
   treeview->SetSession(tv_session);
//--- tree viewer record
   auto tv_record = tv_session->AddRecord(kTRUE);
   tv_session->SetRecordName("Temperature");
   tv_record->fX        = "fTemperature";
   tv_record->fY        = "";
   tv_record->fZ        = "";
   tv_record->fCut      = "";
   tv_record->fXAlias   = "fTemperature";
   tv_record->fYAlias   = "-empty-";
   tv_record->fZAlias   = "-empty-";
   tv_record->fCutAlias = "-empty-";
   tv_record->fOption   = "lego1";
   tv_record->fScanRedirected = kFALSE;
   tv_record->fCutEnabled = kTRUE;
//--- tree viewer record
   tv_record = tv_session->AddRecord(kTRUE);
   tv_session->SetRecordName("Py versus Px");
   tv_record->fX        = "fTracks.fPx";
   tv_record->fY        = "fTracks.fPy";
   tv_record->fZ        = "";
   tv_record->fCut      = "";
   tv_record->fXAlias   = "fTracks.fPx";
   tv_record->fYAlias   = "fTracks.fPy";
   tv_record->fZAlias   = "-empty-";
   tv_record->fCutAlias = "-empty-";
   tv_record->fOption   = "lego";
   tv_record->fScanRedirected = kFALSE;
   tv_record->fCutEnabled = kTRUE;
//--- tree viewer record
   tv_record = tv_session->AddRecord(kTRUE);
   tv_session->SetRecordName("Transverse momentum");
   tv_record->fX        = "sqrt(fTracks.fPx*fTracks.fPx+fTracks.fPy*fTracks.fPy)";
   tv_record->fY        = "";
   tv_record->fZ        = "";
   tv_record->fCut      = "fTracks.fPx>0";
   tv_record->fXAlias   = "~Pt";
   tv_record->fYAlias   = "-empty-";
   tv_record->fZAlias   = "-empty-";
   tv_record->fCutAlias = "~Cut1";
   tv_record->fOption   = "";
   tv_record->fScanRedirected = kFALSE;
   tv_record->fCutEnabled = kTRUE;
//--- tree viewer record
   tv_record = tv_session->AddRecord(kTRUE);
   tv_session->SetRecordName("Surface plot of Py vs. Px");
   tv_record->fX        = "fTracks.fPx";
   tv_record->fY        = "fTracks.fPy";
   tv_record->fZ        = "";
   tv_record->fCut      = "";
   tv_record->fXAlias   = "fTracks.fPx";
   tv_record->fYAlias   = "fTracks.fPy";
   tv_record->fZAlias   = "-empty-";
   tv_record->fCutAlias = "-empty-";
   tv_record->fOption   = "SURF";
   tv_record->fScanRedirected = kFALSE;
   tv_record->fCutEnabled = kTRUE;
//--- Show first record
   tv_session->Show(tv_session->First());
}

void tvdemo() {
   printf("This demo show how to handle TTreeViewer sessions\n");
   printf("Compile class Event from test directory before running this\n");
   printf("- use arrow buttons from bottom to cycle records ...\n");
   printf("- make new expressions and drag them to X, Y, Z or Cut items ...\n");
   printf("- use the Draw button to check your current selection ...\n");
   printf("- click the record button once you are happy with this ...\n");
   printf("- open the TV context menu (right-click on the right panel)...\n");
   printf("  Use : RemoveLastRecord() - to remove last record :-)\n");
   printf("        SetRecordName()    - to name current record\n");
   printf("        UpdateRecord()     - if you want to change a record from the list\n");
   printf("                             with your new X, Y, Z, Cut configuration.\n");
   printf("  Best luck !\n");

   open_session();
}