/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/table/AnalyticalColumn',['./Column','./library','sap/ui/core/Element','sap/ui/model/type/Boolean','sap/ui/model/type/DateTime','sap/ui/model/type/Float','sap/ui/model/type/Integer','sap/ui/model/type/Time','./TableUtils','./AnalyticalColumnMenu'],function(C,l,E,B,D,F,I,T,a,A){"use strict";
function i(c){return a.isA(c,"sap.ui.table.AnalyticalTable");}
var b=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});
b.prototype.init=function(){C.prototype.init.apply(this,arguments);};
b._DEFAULT_FILTERTYPES={"Time":new T({UTC:true}),"DateTime":new D({UTC:true}),"Float":new F(),"Integer":new I(),"Boolean":new B()};
b.prototype._createMenu=function(){return new A(this.getId()+"-menu");};
b.prototype.setGrouped=function(g,s){var p=this.getParent();if(i(p)){if(g){p._addGroupedColumn(this.getId());}else{p._removeGroupedColumn(this.getId());}}var r=this.setProperty("grouped",g,s);this._updateColumns();return r;};
b.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};
b.prototype.setVisible=function(v){C.prototype.setVisible.call(this,v);this._updateColumns();return this;};
b.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){this._oBindingLabel=l.TableHelper.createLabel();a.Binding.metadataLoaded(p).then(function(){this._oBindingLabel.setText(o.getPropertyLabel(this.getLeadingProperty()));}.bind(this));}}}L=this._oBindingLabel;}return L;};
b.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding("rows");var L=this.getLeadingProperty();if(o&&o.getFilterablePropertyNames().indexOf(L)>-1){p=L;}}}return p;};
b.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding("rows");var L=this.getLeadingProperty();if(o&&o.getSortablePropertyNames().indexOf(L)>-1){p=L;}}}return p;};
b.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");var L=this.getLeadingProperty(),P=o&&o.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=b._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=b._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=b._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=b._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=b._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};
b.prototype._updateColumns=function(s,f){var p=this.getParent();if(i(p)){p._updateColumns(s,f);}};
b.prototype._updateTableAnalyticalInfo=function(s){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p.updateAnalyticalInfo(s);}};
b.prototype._updateTableColumnDetails=function(){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p._updateTableColumnDetails();}};
b.prototype.shouldRender=function(){if(!this.getVisible()||!this.getTemplate()){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};
b.prototype.getTooltip_AsString=function(){var t=E.prototype.getTooltip_AsString.apply(this);var p=this.getParent();if(!t&&i(p)){var o=p.getBinding("rows");if(o&&this.getLeadingProperty()){t=o.getPropertyQuickInfo(this.getLeadingProperty());}}return t;};
b.prototype._menuHasItems=function(){var m=function(){var t=this.getParent();var o=t.getBinding("rows");var r=o&&o.getAnalyticalQueryResult();return(t&&r&&r.findMeasureByPropertyName(this.getLeadingProperty()));}.bind(this);return C.prototype._menuHasItems.apply(this)||m();};
b.prototype.isFilterableByMenu=function(){var f=this.getFilterProperty();if(!f||!this.getShowFilterMenuEntry()){return false;}var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){if(o.getFilterablePropertyNames().indexOf(f)>-1&&o.getProperty(f)){return true;}}}return false;};
b.prototype.isGroupable=function(){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){var r=o.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&o.getSortablePropertyNames().indexOf(this.getLeadingProperty())>-1&&o.getFilterablePropertyNames().indexOf(this.getLeadingProperty())>-1){return true;}}}return false;};
return b;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenu',['./ColumnMenu',"sap/ui/unified/MenuRenderer",'./library',"sap/ui/thirdparty/jquery"],function(C,M,l,q){"use strict";var G=l.GroupEventType;
var A=C.extend("sap.ui.table.AnalyticalColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.unified.MenuRenderer"
});
A.prototype._addMenuItems=function(){C.prototype._addMenuItems.apply(this);if(this._oColumn){this._addSumMenuItem();}};
A.prototype._addGroupMenuItem=function(){var c=this._oColumn,t=this._oTable;if(c.isGroupable()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",c.getGrouped()?"accept":null,function(e){var m=e.getSource();var g=c.getGrouped();var s=g?G.group:G.ungroup;c.setGrouped(!g);t.fireGroup({column:c,groupedColumns:t._aGroupedColumns,type:s});m.setIcon(!g?"sap-icon://accept":null);});this.addItem(this._oGroupIcon);}};
A.prototype._addSumMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding("rows"),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findMeasureByPropertyName(c.getLeadingProperty())){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",c.getSummed()?"accept":null,q.proxy(function(e){var m=e.getSource(),s=c.getSummed();c.setSummed(!s);m.setIcon(!s?"sap-icon://accept":null);},this));this.addItem(this._oSumItem);}};
A.prototype.open=function(){C.prototype.open.apply(this,arguments);var c=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(c.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(c.getGrouped()?"sap-icon://accept":null);};
return A;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenuRenderer',['sap/ui/table/AnalyticalColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/AnalyticalTable',['./AnalyticalColumn','./Table','./TreeTable',"./TableRenderer",'./library','sap/ui/model/analytics/ODataModelAdapter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/core/Popup','sap/ui/unified/Menu','sap/ui/unified/MenuItem','./TableUtils',"./BindingSelectionAdapter","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery"],function(A,T,a,b,c,O,S,d,P,M,e,f,B,L,g,q){"use strict";var G=c.GroupEventType,h=c.SortOrder,k=c.TreeAutoExpandMode;
var m=T.extend("sap.ui.table.AnalyticalTable",{
metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},designtime:"sap/ui/table/designtime/AnalyticalTable.designtime"},
renderer:"sap.ui.table.TableRenderer"
});
m.prototype._getFixedBottomRowContexts=function(){var o=this.getBinding("rows");if(o){return[o.getGrandTotalNode()];}};
m.prototype._getContexts=a.prototype._getContexts;
m.prototype.init=function(){T.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.attachBrowserEvent("contextmenu",this._onContextMenu);this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;f.Grouping.setGroupMode(this);};
m.prototype._initSelectionAdapter=a.prototype._initSelectionAdapter;
m.prototype.exit=function(){this._cleanupGroupHeaderMenu();T.prototype.exit.apply(this,arguments);};
m.prototype._adaptLocalization=function(r,l){return T.prototype._adaptLocalization.apply(this,arguments).then(function(){if(l){this._cleanupGroupHeaderMenu();}}.bind(this));};
m.prototype.setFixedRowCount=function(){L.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this;};
m.prototype.setFixedBottomRowCount=function(){L.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this;};
m.prototype.setDirty=function(D){L.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",D,true);this.setShowOverlay(this.getDirty());return this;};
m.prototype.setEnableGrouping=function(){L.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this;};
m.prototype.setGroupBy=function(){L.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this;};
m.prototype.getModel=function(n){var o=T.prototype.getModel.apply(this,arguments);var r=this.getBindingInfo("rows");if(o&&r&&r.model==n){O.apply(o);}return o;};
m.prototype._onBindingChange=function(E){T.prototype._onBindingChange.apply(this,arguments);var r=typeof(E)==="object"?E.getParameter("reason"):E;if(r!=="sort"){this._invalidateColumnMenus();}};
m.prototype._bindAggregation=function(n,o){if(n==="rows"){this.setProperty("firstVisibleRow",0,true);this._applyAnalyticalBindingInfo(o);this._updateTotalRow(true);this._applyODataModelAnalyticalAdapter(o.model);T._addBindingListener(o,"selectionChanged",this._onSelectionChanged.bind(this));}T.prototype._bindAggregation.call(this,n,o);if(n==="rows"){f.Binding.metadataLoaded(this).then(function(){this._updateColumns(true);}.bind(this));}};
m.prototype._applyAnalyticalBindingInfo=function(o){var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getSorted()){o.sorter=o.sorter||[];o.sorter.push(new d(C[i].getSortProperty()||C[i].getLeadingProperty(),C[i].getSortOrder()===h.Descending));}}o.parameters=o.parameters||{};o.parameters.analyticalInfo=this._getColumnInformation();if(!o.parameters.hasOwnProperty("sumOnTop")){o.parameters.sumOnTop=this.getSumOnTop();}if(!o.parameters.hasOwnProperty("numberOfExpandedLevels")){o.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();}if(o.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){o.parameters.numberOfExpandedLevels=0;}if(!o.parameters.hasOwnProperty("autoExpandMode")){var E=this.getAutoExpandMode();if(E!=k.Bundled&&E!=k.Sequential){E=k.Bundled;}o.parameters.autoExpandMode=E;}};
m.prototype._applyODataModelAnalyticalAdapter=function(o){if(o){O.apply(o);}};
m.prototype._getColumnInformation=function(){var C=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(this._aGroupedColumns.indexOf(o.getId())>-1){continue;}if(!o instanceof A){L.error("You have to use AnalyticalColumns for the Analytical table");}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return C;};
m.prototype._updateTableContent=function(){var o=this.getBinding("rows"),F=this.getFirstVisibleRow(),j=this.getFixedBottomRowCount(),C=this.getVisibleRowCount(),n=this.getColumns();var r=this.getRows();if(!o){for(var i=0;i<r.length;i++){f.Grouping.cleanupTableRowForGrouping(this,r[i]);}return;}var p=this.getBindingInfo("rows");for(var R=0,l=Math.min(C,r.length);R<l;R++){var I=R>(C-j-1)&&this._getTotalRowCount()>C,s=I?(this._getTotalRowCount()-1-(C-1-R)):F+R,t=r[R],$=t.$(),u=this.$().find("div[data-sap-ui-rowindex="+$.attr("data-sap-ui-rowindex")+"]");var v;if(I&&o.bProvideGrandTotals){v=o.getGrandTotalContextInfo();}else{v=this.getContextInfoByIndex(s);}var w=v?v.level:0;if(!v||!v.context){f.Grouping.cleanupTableRowForGrouping(this,t);if(v&&!v.context){$.addClass("sapUiAnalyticalTableDummy");u.addClass("sapUiAnalyticalTableDummy");}continue;}if(o.nodeHasChildren&&o.nodeHasChildren(v)){f.Grouping.updateTableRowForGrouping(this,t,true,v.nodeState.expanded,v.nodeState.expanded&&!p.parameters.sumOnTop,false,w,o.getGroupName(v.context,v.level));}else{f.Grouping.updateTableRowForGrouping(this,t,false,false,false,v.nodeState.sum,w,v.nodeState.sum&&v.level>0?o.getGroupName(v.context,v.level):null);}var x=t.getCells();for(var i=0,y=x.length;i<y;i++){var z=x[i].data("sap-ui-colindex");var D=n[z];var E=q(x[i].$().closest("td"));if(o.isMeasure(D.getLeadingProperty())){E.addClass("sapUiTableMeasureCell");E.toggleClass("sapUiTableCellHidden",v.nodeState.sum&&!D.getSummed());}else{E.removeClass("sapUiTableMeasureCell");}}}};
m.prototype._onContextMenu=function(E){if(q(E.target).closest('tr').hasClass('sapUiTableGroupHeader')||q(E.target).closest('.sapUiTableRowSelectionCell.sapUiTableGroupHeader').length>0){this._iGroupedLevel=q(E.target).closest('[data-sap-ui-level]').data('sap-ui-level');var o=this._getGroupHeaderMenu();var i=P.Dock;var l=E.pageX||E.clientX;var j=E.pageY||E.clientY;o.open(false,E.target,i.LeftTop,i.LeftTop,document,(l-2)+" "+(j-2));E.preventDefault();E.stopPropagation();return;}return true;};
m.prototype._getGroupHeaderMenu=function(){var t=this;function j(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var l=t.getColumns().filter(function(C){return t._aGroupedColumns[i]===C.getId();})[0];return{column:l,index:i};}else{return undefined;}}if(!this._oGroupHeaderMenu){this._oGroupHeaderMenu=new M();this._oGroupHeaderMenuVisibilityItem=new e({text:f.getResourceText("TBL_SHOW_COLUMN"),select:function(){var o=j();if(o){var C=o.column,s=C.getShowIfGrouped();C.setShowIfGrouped(!s);t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:(!s?G.showGroupedColumn:G.hideGroupedColumn)});}}});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);this._oGroupHeaderMenu.addItem(new e({text:f.getResourceText("TBL_UNGROUP"),select:function(){var o=j();if(o&&o.column){var u=o.column;u.setGrouped(false);t.fireGroup({column:u,groupedColumns:t._aGroupedColumns,type:G.ungroup});}}}));this._oGroupHeaderMenu.addItem(new e({text:f.getResourceText("TBL_UNGROUP_ALL"),select:function(){var l=t.getColumns();t.suspendUpdateAnalyticalInfo();for(var i=0;i<l.length;i++){l[i].setGrouped(false);}t.resumeUpdateAnalyticalInfo();t.fireGroup({column:undefined,groupedColumns:[],type:G.ungroupAll});}}));this._oGroupHeaderMoveUpItem=new e({text:f.getResourceText("TBL_MOVE_UP"),select:function(){var o=j();if(o){var C=o.column;var i=t._aGroupedColumns.indexOf(C.getId());if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveUp});}}},icon:"sap-icon://arrow-top"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);this._oGroupHeaderMoveDownItem=new e({text:f.getResourceText("TBL_MOVE_DOWN"),select:function(){var o=j();if(o){var C=o.column;var i=t._aGroupedColumns.indexOf(C.getId());if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveDown});}}},icon:"sap-icon://arrow-bottom"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);this._oGroupHeaderMenu.addItem(new e({text:f.getResourceText("TBL_SORT_ASC"),select:function(){var o=j();if(o){var C=o.column;C.sort(false);}},icon:"sap-icon://up"}));this._oGroupHeaderMenu.addItem(new e({text:f.getResourceText("TBL_SORT_DESC"),select:function(){var o=j();if(o){var C=o.column;C.sort(true);}},icon:"sap-icon://down"}));this._oGroupHeaderMenu.addItem(new e({text:f.getResourceText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding("rows").collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t.clearSelection();}}));this._oGroupHeaderMenu.addItem(new e({text:f.getResourceText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding("rows").collapseToLevel(0);t.setFirstVisibleRow(0);t.clearSelection();}}));}var o=j();if(o){var C=o.column;if(C.getShowIfGrouped()){this._oGroupHeaderMenuVisibilityItem.setText(f.getResourceText("TBL_HIDE_COLUMN"));}else{this._oGroupHeaderMenuVisibilityItem.setText(f.getResourceText("TBL_SHOW_COLUMN"));}this._oGroupHeaderMoveUpItem.setEnabled(o.index>0);this._oGroupHeaderMoveDownItem.setEnabled(o.index<this._aGroupedColumns.length-1);}else{this._oGroupHeaderMoveUpItem.setEnabled(true);this._oGroupHeaderMoveDownItem.setEnabled(true);}return this._oGroupHeaderMenu;};
m.prototype._cleanupGroupHeaderMenu=function(){if(this._oGroupHeaderMenu){this._oGroupHeaderMenu.destroy();this._oGroupHeaderMenu=null;this._oGroupHeaderMenuVisibilityItem=null;this._oGroupHeaderMoveUpItem=null;this._oGroupHeaderMoveDownItem=null;}};
m.prototype.getContextByIndex=function(i){var o=this.getBinding("rows");return i>=0&&o?o.getContextByIndex(i):null;};
m.prototype.getContextInfoByIndex=function(i){var o=this.getBinding("rows");return i>=0&&o?o.getNodeByIndex(i):null;};
m.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true;};
m.prototype.resumeUpdateAnalyticalInfo=function(s,F){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(s,F);};
m.prototype.addColumn=function(C,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.addColumn.call(this,o,s);this._updateColumns(s);return this;};
m.prototype.insertColumn=function(C,i,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.insertColumn.call(this,o,i,s);this._updateColumns(s);return this;};
m.prototype.removeColumn=function(C,s){var r=T.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(v){if(C.getId){return v!=C.getId();}else{return v==C;}});}this.updateAnalyticalInfo(s);return r;};
m.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];var r=T.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(s);return r;};
m.prototype._getColumn=function(C){if(typeof C==="string"){var o=new A({leadingProperty:C,template:C,managed:true});return o;}else if(C instanceof A){return C;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};
m.prototype._updateColumns=function(s,F){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(s,F);if(this.bOutput){this.invalidate();}}};
m.prototype.updateAnalyticalInfo=function(s,F){if(this._bSuspendUpdateAnalyticalInfo){return;}var o=this.getBinding("rows");if(o){var C=this._getColumnInformation();var n=o.getNumberOfExpandedLevels()||0;if(n>this._aGroupedColumns.length){o.setNumberOfExpandedLevels(0);}o.updateAnalyticalInfo(C,F);this._updateTotalRow(s);if(!s){this._getRowContexts();}}};
m.prototype.refreshRows=function(){T.prototype.refreshRows.apply(this,arguments);this._updateTotalRow();};
m.prototype._updateTotalRow=function(s){var o=this.getBinding("rows");var F=this.getFixedBottomRowCount();if(o&&(o.providesGrandTotal()&&o.hasTotaledMeasures())){if(F!==1){this.setProperty("fixedBottomRowCount",1,s);}}else{if(F!==0){this.setProperty("fixedBottomRowCount",0,s);}}};
m.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return;}var l=this.getBinding("rows"),r=l&&l.getAnalyticalQueryResult();if(r){var C=this.getColumns(),n=[],u=[],D=[],p={},t,v;for(var i=0;i<C.length;i++){t=C[i];t._isLastGroupableLeft=false;t._bLastGroupAndGrouped=false;t._bDependendGrouped=false;if(!t.getVisible()){continue;}var w=t.getLeadingProperty();v=r.findDimensionByPropertyName(w);if(v){var x=v.getName();if(!p[x]){p[x]={dimension:v,columns:[t]};}else{p[x].columns.push(t);}if(t.getGrouped()&&n.indexOf(x)==-1){n.push(x);}if(D.indexOf(x)==-1){D.push(x);}}}u=q.grep(D,function(s){return n.indexOf(n,s)==-1;});if(n.length>0){q.each(n,function(i,s){q.each(p[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(n.length==D.length){v=r.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var y=p[v.getName()].columns;q.each(y,function(i,o){o._bLastGroupAndGrouped=true;});}}if(u.length==1){q.each(p[u[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};
m.prototype._getFirstMeasureColumnIndex=function(){var o=this.getBinding("rows"),r=o&&o.getAnalyticalQueryResult(),C=this._getVisibleColumns();if(!r){return-1;}for(var i=0;i<C.length;i++){var j=C[i],l=j.getLeadingProperty();if(r.findMeasureByName(l)||r.findMeasureByPropertyName(l)){return i;}}};
m.prototype.getTotalSize=function(){var o=this.getBinding("rows");if(o){return o.getTotalSize();}return 0;};
m.prototype._onPersoApplied=function(){T.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getGrouped()){this._addGroupedColumn(C[i].getId());}}this._updateColumns();};
m.prototype._addGroupedColumn=function(C){if(this._aGroupedColumns.indexOf(C)===-1){this._aGroupedColumns.push(C);}};
m.prototype._removeGroupedColumn=function(C){var i=this._aGroupedColumns.indexOf(C);if(i>=0){this._aGroupedColumns.splice(i,1);}};
m.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};
m.prototype.setCollapseRecursive=function(C){var o=this.getBinding("rows");if(o){g(o.setCollapseRecursive,"Collapse Recursive is not supported by the used binding");if(o.setCollapseRecursive){o.setCollapseRecursive(C);}}this.setProperty("collapseRecursive",!!C,true);return this;};
m.prototype.expand=a.prototype.expand;m.prototype.collapse=a.prototype.collapse;m.prototype.collapseAll=a.prototype.collapseAll;m.prototype.isExpanded=a.prototype.isExpanded;
m.prototype.getAnalyticalInfoOfRow=function(r){if(!this._validateRow(r)){return null;}var o=this.getBindingInfo("rows");var j=this.getBinding("rows");if(!o||!j){return null;}var C=r.getBindingContext(o.model);if(!C){return null;}var I=C===j.getGrandTotalContext();var l=null;var n=-1;if(I){l=j.getGrandTotalContextInfo();n=0;}else{l=this.getContextInfoByIndex(r.getIndex());if(l){n=l.level;}}var p=l&&j.nodeHasChildren&&j.nodeHasChildren(l);var s=!p&&!I&&l&&l.nodeState&&l.nodeState.sum;var t=[];if(s||p){var u=this.getGroupedColumns();if(u.length>0&&n>0&&n<=u.length){for(var i=0;i<n;i++){t.push(u[i]);}}}return{grandTotal:I,group:p,groupTotal:s,level:n,context:C,groupedColumns:t};};
return m;});
sap.ui.predefine('sap/ui/table/AnalyticalTableRenderer',['sap/ui/table/AnalyticalTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/BindingSelectionAdapter',['./SelectionAdapter','./library'],function(S,l){"use strict";var a=l.SelectionMode;
var B=S.extend("sap.ui.table.BindingSelectionAdapter");
B.prototype.exit=function(){var b=this._getBinding();if(b){b.detachEvent("change",this._onBindingChange);}S.prototype.exit.call(this);};
B.prototype.addSelectionInterval=function(i,I){if(this.getSelectionMode()===a.None){return;}var b=this._getBinding();if(b&&b.addSelectionInterval){if(this.getSelectionMode()===a.Single){i=I;b.setSelectionInterval(i,I);}b.addSelectionInterval(i,I);}};
B.prototype.clearSelection=function(){var b=this._getBinding();if(b&&b.clearSelection){b.clearSelection();}};
B.prototype.getSelectedIndex=function(){var b=this._getBinding();if(b&&b.findNode){return b.getSelectedIndex();}else{return-1;}};
B.prototype.getSelectedIndices=function(){var b=this._getBinding();if(b&&b.findNode&&b.getSelectedIndices){return b.getSelectedIndices();}else{return[];}};
B.prototype.getSelectableCount=function(){var b=this._getBinding();if(!b){return 0;}else if(b.getGrandTotalContextInfo){var r=b.getGrandTotalContextInfo();return r?r.totalNumberOfLeafs:0;}else{return b.getLength();}};
B.prototype.getSelectedCount=function(){var b=this._getBinding();if(b&&b.getSelectedNodesCount){return b.getSelectedNodesCount();}else{return 0;}};
B.prototype.isIndexSelectable=function(i){var b=this._getBinding();if(b){return b.isIndexSelectable(i);}else{return false;}};
B.prototype.isIndexSelected=function(i){var b=this._getBinding();if(b&&b.isIndexSelected){return b.isIndexSelected(i);}else{return false;}};
B.prototype.removeSelectionInterval=function(i,I){var b=this._getBinding();if(b&&b.findNode&&b.removeSelectionInterval){b.removeSelectionInterval(i,I);}};
B.prototype.selectAll=function(){if(this.getSelectionMode()===a.None){return;}var b=this._getBinding();if(b&&b.selectAll){b.selectAll();}};
B.prototype.setSelectedIndex=function(i){if(this.getSelectionMode()===a.None){return;}if(i===-1){this.clearSelection();}else{var b=this._getBinding();if(b&&b.setSelectedIndex){b.setSelectedIndex(i);}}};
B.prototype.setSelectionInterval=function(i,I){if(this.getSelectionMode()===a.None){return;}var b=this._getBinding();if(b&&b.setSelectionInterval){if(this.getSelectionMode()===a.Single){i=I;}b.setSelectionInterval(i,I);}};
B.prototype.setSelectionMode=function(s){var o=this.getSelectionMode();S.prototype.setSelectionMode.apply(this,arguments);if(this.getSelectionMode()!==o){this.clearSelection();}return this;};
B.prototype._setBinding=function(b){var c=this._getBinding();S.prototype._setBinding.call(this,b);if(c!==b){if(b){b.attachEvent("change",this._onBindingChange,this);}if(c){c.detachEvent("change",this._onBindingChange);}}};
B.prototype._onBindingChange=function(e){var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r==="sort"||r==="filter"){this.clearSelection();}};
return B;});
sap.ui.predefine('sap/ui/table/Column',['sap/ui/core/Element','sap/ui/core/library','sap/ui/core/Popup','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/Type','sap/ui/model/type/String','./TableUtils','./library','./ColumnMenu','sap/base/util/ObjectPath',"sap/base/util/JSTokenizer","sap/base/Log","sap/ui/thirdparty/jquery"],function(E,c,P,F,a,b,S,T,d,f,g,C,O,J,L,q){"use strict";var H=c.HorizontalAlign,h=g.SortOrder,V=c.ValueState;
var j=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:H.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:h.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},menu:{type:"sap.ui.unified.Menu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});
j._DEFAULT_FILTER_TYPE=new d();
j.prototype.init=function(){this._oSorter=null;this.mSkipPropagation={template:true};this._aTemplateClones=[];};
j.prototype.exit=function(){this._destroyTemplateClones();C._destroyColumnVisibilityMenuItem();};
j.prototype.setParent=function(p,A,s){var r=E.prototype.setParent.apply(this,arguments);var m=this.getAggregation("menu");if(m&&typeof m._updateReferences==="function"){m._updateReferences(this);}C._destroyColumnVisibilityMenuItem();return r;};
j.prototype.invalidate=function(o){if(o!==this.getTemplate()&&!f.isA(o,"sap.ui.table.ColumnMenu")){E.prototype.invalidate.apply(this,arguments);}};
j.prototype.setLabel=function(l){var o=l;if(typeof(l)==="string"){o=g.TableHelper.createLabel({text:l});}this.setAggregation("label",o);return this;};
j.prototype.setTemplate=function(t){var o=t;if(typeof(t)==="string"){o=g.TableHelper.createTextView().bindProperty("text",t);}this.setAggregation("template",o);this.invalidate();this._destroyTemplateClones();var e=this.getParent();if(e&&e.invalidateRowsAggregation&&this.getVisible()==true){e.invalidateRowsAggregation();}return this;};
j.prototype.getMenu=function(){var m=this.getAggregation("menu");if(!m){m=this._createMenu();this.setMenu(m);}return m;};
j.prototype.invalidateMenu=function(){var m=this.getAggregation("menu");if(this._bMenuIsColumnMenu){m._invalidate();}};
j.prototype._menuHasItems=function(){var m=this.getAggregation("menu");var t=this.getParent();var M=function(){return(this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupable()||(t&&t.getEnableColumnFreeze())||(t&&t.getShowColumnVisibilityMenu()));}.bind(this);return!!((m&&m.getItems().length>0)||M());};
j.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry());};
j.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry());};
j.prototype.isGroupable=function(){var t=this.getParent();return!!(t&&t.getEnableGrouping&&t.getEnableGrouping()&&this.getSortProperty());};
j.prototype.setMenu=function(m){this.setAggregation("menu",m,true);this._bMenuIsColumnMenu=f.isA(m,"sap.ui.table.ColumnMenu");return this;};
j.prototype._createMenu=function(){if(!this._defaultMenu){this._defaultMenu=new C(this.getId()+"-menu",{ariaLabelledBy:this});}return this._defaultMenu;};
j.prototype.setSortProperty=function(v){this.setProperty("sortProperty",v);this.invalidateMenu();return this;};
j.prototype.setSorted=function(e){this.setProperty("sorted",e,true);this._updateIcons();return this;};
j.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._updateIcons();return this;};
j.prototype.setFilterProperty=function(v){this.invalidateMenu();return this.setProperty("filterProperty",v);};
j.prototype.setFiltered=function(e){this.setProperty("filtered",e,true);this._updateIcons();return this;};
j.prototype.setFilterValue=function(v){this.setProperty("filterValue",v,true);var m=this.getMenu();if(this._bMenuIsColumnMenu){m._setFilterValue(v);}return this;};
j.prototype.setFilterOperator=function(v){return this.setProperty("filterOperator",v,true);};
j.prototype._openMenu=function(D,w){var m=this.getMenu();var e=this.fireColumnMenuOpen({menu:m});if(e){var i=P.Dock;var o=D;if(!D){D=this.getDomRef();o=this.getFocusDomRef();}m.open(!!w,o,i.BeginTop,i.BeginBottom,D,"none none");}};
j.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===h.Ascending);};
j.prototype.sort=function(D,A){var t=this.getParent();if(t){t.pushSortedColumn(this,A);var n=D?h.Descending:h.Ascending;var e=t.fireSort({column:this,sortOrder:n,columnAdded:A});if(e){var s=t.getSortedColumns();var k=t.getColumns();for(var i=0,l=k.length;i<l;i++){if(s.indexOf(k[i])<0){k[i].setProperty("sorted",false,true);k[i].setProperty("sortOrder",h.Ascending,true);k[i]._updateIcons();delete k[i]._oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new S(this.getSortProperty(),this.getSortOrder()===h.Descending);var m=[];for(var i=0,l=s.length;i<l;i++){s[i]._updateIcons();m.push(s[i]._oSorter);}var B=t.getBinding("rows");if(B){if(this._updateTableAnalyticalInfo){this._updateTableAnalyticalInfo(true);}B.sort(m);}else{L.warning("Sorting not performed because no binding present",this);}}}return this;};
j.prototype._updateIcons=function(){var t=this.getParent(),s=this.getSorted(),e=this.getFiltered();if(!t||!t.getDomRef()){return;}this.$().parents(".sapUiTableCHT").find('td[data-sap-ui-colindex="'+this.getIndex()+'"]:not([colspan]):not(.sapUiTableHidden):first').toggleClass("sapUiTableColFiltered",e).toggleClass("sapUiTableColSorted",s).toggleClass("sapUiTableColSortedD",s&&this.getSortOrder()===h.Descending);t._getAccExtension().updateAriaStateOfColumn(this);t._resetColumnHeaderHeights();t._updateRowHeights(t._collectRowHeights(true),true);};
j.prototype._renderSortIcon=function(){this._updateIcons();};
j.prototype._getFilter=function(){var o,p=this.getFilterProperty(),v=this.getFilterValue(),s=this.getFilterOperator(),e,i,t=this.getFilterType()||j._DEFAULT_FILTER_TYPE,I=t instanceof d,B;if(v){if(!s){B=v.match(/(.*)\s*\.\.\s*(.*)/);if(v.indexOf("=")==0){s=a.EQ;e=v.substr(1);}else if(v.indexOf("!=")==0){s=a.NE;e=v.substr(2);}else if(v.indexOf("<=")==0){s=a.LE;e=v.substr(2);}else if(v.indexOf("<")==0){s=a.LT;e=v.substr(1);}else if(v.indexOf(">=")==0){s=a.GE;e=v.substr(2);}else if(v.indexOf(">")==0){s=a.GT;e=v.substr(1);}else if(B){if(B[1]&&B[2]){s=a.BT;e=B[1];i=B[2];}else if(B[1]&&!B[2]){s=a.GE;e=B[1];}else{s=a.LE;e=B[2];}}else if(I&&v.indexOf("*")==0&&v.lastIndexOf("*")==v.length-1){s=a.Contains;e=v.substr(1,v.length-2);}else if(I&&v.indexOf("*")==0){s=a.EndsWith;e=v.substr(1);}else if(I&&v.lastIndexOf("*")==v.length-1){s=a.StartsWith;e=v.substr(0,v.length-1);}else{if(this.getDefaultFilterOperator()){s=this.getDefaultFilterOperator();}else{if(I){s=a.Contains;}else{s=a.EQ;}}e=v.substr(0);}if(!i){o=new F(p,s,this._parseFilterValue(e));}else{o=new F(p,s,this._parseFilterValue(e),this._parseFilterValue(i));}}else{o=new F(p,s,this._parseFilterValue(v));}}return o;};
j.prototype.filter=function(v){var t=this.getParent();if(t&&t.isBound("rows")){var k=t.fireFilter({column:this,value:v});if(k){this.setProperty("filtered",!!v,true);this.setProperty("filterValue",v,true);var m=this.getMenu();if(this._bMenuIsColumnMenu){m._setFilterValue(v);}var n=[];var o=t.getColumns();for(var i=0,l=o.length;i<l;i++){var p=o[i],r;m=p.getMenu();try{r=p._getFilter();if(p._bMenuIsColumnMenu){m._setFilterState(V.None);}}catch(e){if(p._bMenuIsColumnMenu){m._setFilterState(V.Error);}continue;}if(r){n.push(r);}}t.getBinding("rows").filter(n,b.Control);this._updateIcons();}}return this;};
j.prototype._parseFilterValue=function(v){var o=this.getFilterType();if(o){if(q.isFunction(o)){v=o(v);}else{v=o.parseValue(v,"string");}}return v;};
j.prototype._restoreIcons=function(){this._updateIcons();};
j.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()&&this.getTemplate()!=null;};
j.PROPERTIES_FOR_ROW_INVALIDATION={visible:true,flexible:true,headerSpan:true};
j.prototype.setProperty=function(n,v){var t=this.getParent();if(t&&t.invalidateRowsAggregation&&this.getProperty(n)!=v&&j.PROPERTIES_FOR_ROW_INVALIDATION[n]&&(this.getVisible()||n=="visible")){t.invalidateRowsAggregation();}return E.prototype.setProperty.apply(this,arguments);};
j.prototype.setFilterType=function(t){var o=t;if(typeof(t)==="string"){try{var m=J.parseJS(t);if(typeof(m.type)==="string"){var e=O.get(m.type);o=e&&new e(m.formatOptions,m.constraints);}}catch(i){var e=O.get(t);o=e&&new e();}if(!(o instanceof T)){L.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");o=undefined;}}this.setProperty("filterType",o,true);return this;};
j.prototype.getIndex=function(){var t=this.getParent();if(t){return t.indexOfColumn(this);}else{return-1;}};
j.prototype._getFreeTemplateClone=function(){var o=null;for(var i=0;i<this._aTemplateClones.length;i++){if(!this._aTemplateClones[i]||this._aTemplateClones[i].bIsDestroyed){this._aTemplateClones.splice(i,1);i--;}else if(!o&&!this._aTemplateClones[i].getParent()){o=this._aTemplateClones[i];}}return o;};
j.prototype.getTemplateClone=function(i){if(i==null){return null;}var o=this._getFreeTemplateClone();if(!o){var t=this.getTemplate();if(t){o=t.clone();this._aTemplateClones.push(o);}}if(o){o.data("sap-ui-colindex",i);o.data("sap-ui-colid",this.getId());var e=this.getParent();if(e){e._getAccExtension().addColumnHeaderLabel(this,o);}}return o;};
j.prototype._destroyTemplateClones=function(){for(var i=0;i<this._aTemplateClones.length;i++){if(this._aTemplateClones[i]!=null&&!this._aTemplateClones[i].bIsDestroyed){this._aTemplateClones[i].destroy();}}this._aTemplateClones=[];};
j.prototype._closeMenu=function(){var m=this.getAggregation("menu");if(m){m.close();}};
j.prototype.setVisible=function(v){this.setProperty("visible",v);C._updateVisibilityIcon(this.getIndex(),v);};
return j;});
sap.ui.predefine('sap/ui/table/ColumnMenu',['./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/unified/MenuTextFieldItem',"sap/ui/unified/MenuRenderer",'sap/ui/Device','./TableUtils',"sap/base/assert","sap/ui/thirdparty/jquery"],function(a,M,b,c,d,D,T,e,q){"use strict";
var C=M.extend("sap.ui.table.ColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.unified.MenuRenderer"
});
C.prototype.init=function(){if(M.prototype.init){M.prototype.init.apply(this,arguments);}this.addStyleClass("sapUiTableColumnMenu");this._bInvalidated=true;this._iPopupClosedTimeoutId=null;this._oColumn=null;this._oTable=null;this._attachPopupClosed();};
C.prototype.exit=function(){if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}window.clearTimeout(this._iPopupClosedTimeoutId);this._oColumn=this._oTable=null;};
C.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate();}};
C.prototype.setParent=function(p){this._invalidate();this._updateReferences(p);return M.prototype.setParent.apply(this,arguments);};
C.prototype._updateReferences=function(p){this._oColumn=p;if(this._oColumn){e(T.isA(this._oColumn,"sap.ui.table.Column"),"ColumnMenu.setParent: parent must be a subclass of sap.ui.table.Column");this._oTable=this._oColumn.getParent();if(this._oTable){e(T.isA(this._oTable,"sap.ui.table.Table"),"ColumnMenu.setParent: parent of parent must be subclass of sap.ui.table.Table");}}};
C._destroyColumnVisibilityMenuItem=function(){if(C._oColumnVisibilityMenuItem){C._oColumnVisibilityMenuItem.destroy();C._oColumnVisibilityMenuItem=null;}};
C.prototype._removeColumnVisibilityFromAggregation=function(){if(!C._oColumnVisibilityMenuItem){return;}this.removeAggregation("items",C._oColumnVisibilityMenuItem,true);};
C.prototype._invalidate=function(){this._bInvalidated=true;};
C.prototype._attachPopupClosed=function(){var t=this;if(!D.support.touch){this.getPopup().attachClosed(function(){t._iPopupClosedTimeoutId=window.setTimeout(function(){if(t._oColumn){if(t._lastFocusedDomRef){t._lastFocusedDomRef.focus();}else{t._oColumn.focus();}}},0);});}};
C.prototype.open=function(){if(this._bInvalidated){this._bInvalidated=false;this._removeColumnVisibilityFromAggregation();this.destroyItems();this._addMenuItems();}else if(this._oColumn){this._addColumnVisibilityMenuItem();}if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];M.prototype.open.apply(this,arguments);}};
C.prototype._addMenuItems=function(){if(this._oColumn){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem();}};
C.prototype._addSortMenuItem=function(f){var o=this._oColumn;if(o.isSortableByMenu()){var s=f?"desc":"asc";var i=f?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(s,"TBL_SORT_"+s.toUpperCase(),i,function(E){o.sort(f,E.getParameter("ctrlKey")===true);}));}};
C.prototype._addFilterMenuItem=function(){var o=this._oColumn;if(o.isFilterableByMenu()){var t=o.getParent();var f=t&&t.getEnableCustomFilter();if(f){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:o});}));}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",o.getFilterValue(),function(){o.filter(this.getValue());}));}}};
C.prototype._addGroupMenuItem=function(){var o=this._oColumn;if(o.isGroupable()){var t=this._oTable;this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){t.setGroupBy(o);}));}};
C.prototype._addFreezeMenuItem=function(){var o=this._oColumn;var t=this._oTable;var f=t&&t.getEnableColumnFreeze();if(f){var i=o.getIndex();var I=i+T.Column.getHeaderSpan(o)==t.getComputedFixedColumnCount();this.addItem(this._createMenuItem("freeze",I?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var E=t.fireColumnFreeze({column:o});if(E){if(I){t.setFixedColumnCount(0);}else{t.setFixedColumnCount(i+1);}}}));}};
C.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){if(C._oColumnVisibilityMenuItem&&!C._oColumnVisibilityMenuItem.bIsDestroyed){this.addItem(C._oColumnVisibilityMenuItem);return;}C._oColumnVisibilityMenuItem=this._createMenuItem("column-visibilty","TBL_COLUMNS");var o=new M(C._oColumnVisibilityMenuItem.getId()+"-menu");C._oColumnVisibilityMenuItem.setSubmenu(o);var f=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){var s=t.getColumnVisibilityMenuSorter();if(typeof s==="function"){f=f.sort(s);}}var B=t.getBinding();var A=T.isA(B,"sap.ui.model.analytics.AnalyticalBinding");var v=t._getVisibleColumns();for(var i=0,l=f.length;i<l;i++){var g=f[i];if(A&&g.isA("sap.ui.table.AnalyticalColumn")){var Q=B.getAnalyticalQueryResult();var E=Q.getEntityType();var m=B.getModel().getProperty("/#"+E.getTypeDescription().name+"/"+g.getLeadingProperty()+"/sap:visible");if(m&&(m.value==="false"||m.value===false)){continue;}}var h=this._createColumnVisibilityMenuItem(o.getId()+"-item-"+i,g);o.addItem(h);if(v.length==1&&v[0]===g){h.setEnabled(false);}}this.addItem(C._oColumnVisibilityMenuItem);}};
C.prototype._createColumnVisibilityMenuItem=function(i,o){var t=this._oTable;function g(l){return l&&l.getText&&l.getText();}var s=o.getName()||g(o.getLabel());if(!s){o.getMultiLabels().forEach(function(l,f){if(T.Column.getHeaderSpan(o,f)===1){s=g(l)||s;}});}return new b(i,{text:s,icon:o.getVisible()?"sap-icon://accept":null,ariaLabelledBy:[t.getId()+(o.getVisible()?"-ariahidecolmenu":"-ariashowcolmenu")],select:q.proxy(function(E){var v=!o.getVisible();if(v||T.getVisibleColumnCount(this._oTable)>1){var t=o.getParent();var f=true;if(T.isA(t,"sap.ui.table.Table")){f=t.fireColumnVisibility({column:o,newVisible:v});}if(f){o.setVisible(v);}}},this)});};
C.prototype._createMenuItem=function(i,t,I,h){return new b(this.getId()+"-"+i,{text:T.getResourceText(t),icon:I?"sap-icon://"+I:null,select:h||function(){}});};
C.prototype._createMenuTextFieldItem=function(i,t,I,v,h){h=h||function(){};return new c(this.getId()+"-"+i,{label:T.getResourceText(t),icon:I?"sap-icon://"+I:null,value:v,select:h||function(){}});};
C.prototype._setFilterValue=function(v){var o=this.getParent();var t=(o?o.getParent():undefined);var f=sap.ui.getCore().byId(this.getId()+"-filter");if(f&&(t&&!t.getEnableCustomFilter())){f.setValue(v);}return this;};
C.prototype._setFilterState=function(f){var o=this.getParent();var t=(o?o.getParent():undefined);var F=sap.ui.getCore().byId(this.getId()+"-filter");if(F&&(t&&!t.getEnableCustomFilter())){F.setValueState(f);}return this;};
C._updateVisibilityIcon=function(I,v){if(C._oColumnVisibilityMenuItem){var s=v?"sap-icon://accept":"";var S=C._oColumnVisibilityMenuItem.getSubmenu();if(!S){return;}var f=S.getItems();var o;for(var i=0;i<f.length;i++){if(f[i].getId().endsWith("-item-"+I)){o=f[i];break;}}if(!o){return;}o.setProperty("icon",s);}};
return C;});
sap.ui.predefine('sap/ui/table/ColumnMenuRenderer',['sap/ui/table/ColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/Row',['sap/ui/core/Element','sap/ui/model/Context','./TableUtils',"sap/ui/thirdparty/jquery"],function(E,C,T,q){"use strict";
var R=E.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});
R.prototype.init=function(){this.initDomRefs();};
R.prototype.exit=function(){this.initDomRefs();};
R.prototype.getFocusInfo=function(){var t=this.getParent();return t?t.getFocusInfo():E.prototype.getFocusInfo.apply(this,arguments);};
R.prototype.applyFocusInfo=function(f){var t=this.getParent();if(t){t.applyFocusInfo(f);}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};
R.prototype.addStyleClass=function(s){this.getDomRefs(true).row.addClass(s);};
R.prototype.removeStyleClass=function(s){this.getDomRefs(true).row.removeClass(s);};
R.prototype.initDomRefs=function(){this._mDomRefs={};};
R.prototype.getIndex=function(){var t=this.getParent();if(t){var r=t.indexOfRow(this);var n=t.getFixedRowCount();if(n>0&&r<n){return r;}var N=t.getFixedBottomRowCount();var v=t.getVisibleRowCount();if(N>0&&r>=v-N){var i=t._getTotalRowCount();if(i>=v){return i-(v-r);}else{return r;}}return t._getFirstRenderedRowIndex()+r;}return-1;};
R.prototype.getDomRefs=function(j,c){var b=function(i){return q(document.getElementById(i));};var d=function(i){return(i?window.document.getElementById(i):null);};var k=(j===true)?"jQuery":"dom",a=(j===true)?b:d,D=this._mDomRefs;if(!D[k]){D[k]={};var t=this.getParent();if(t){var r=t.indexOfRow(this);D[k].rowSelector=a(t.getId()+"-rowsel"+r);D[k].rowAction=a(t.getId()+"-rowact"+r);}D[k].rowScrollPart=a(this.getId());D[k].rowFixedPart=a(this.getId()+"-fixed");D[k].rowSelectorText=a(this.getId()+"-rowselecttext");if(j===true){D[k].row=D[k].rowScrollPart;if(D[k].rowFixedPart.length>0){D[k].row=D[k].row.add(D[k].rowFixedPart);}else{D[k].rowFixedPart=undefined;}if(D[k].rowSelector&&D[k].rowSelector.length>0){D[k].row=D[k].row.add(D[k].rowSelector);}else{D[k].rowSelector=undefined;}if(D[k].rowAction&&D[k].rowAction.length>0){D[k].row=D[k].row.add(D[k].rowAction);}else{D[k].rowAction=undefined;}}}var K=D[k];if(c){return Object.keys(K).map(function(k){return K[k];}).filter(Boolean);}return K;};
R.prototype._updateSelection=function(t,m,s){var i=t.isIndexSelected(this.getIndex());var d=this.getDomRefs(true);var S="rowSelect";if(i){S="rowDeselect";}if(d.rowSelector){d.rowSelector.attr("title",!this._bHidden?m.mouse[S]:"");}if(d.rowSelectorText){var a="";if(!this._bHidden&&!T.Grouping.isInSumRow(d.rowSelector)&&!T.Grouping.isInGroupingRow(d.rowSelector)){a=m.keyboard[S];}d.rowSelectorText.text(a);}var r=d.rowScrollPart;if(d.rowFixedPart){r=r.add(d.rowFixedPart);}if(s&&!this._bHidden){r.attr("title",m.mouse[S]);}else{r.removeAttr("title");}if(d.row){this._setSelected(i);t._getAccExtension().updateAriaStateOfRow(this,d,i);}};
R.prototype.setRowBindingContext=function(c,m,b){var n;if(c&&!(c instanceof C)){n=c;c=c.context;}var $=this.getDomRefs(true).row;this._bHidden=!c;$.toggleClass("sapUiTableRowHidden",this._bHidden);this._collectRenderingInformation(c,n,b);this.setBindingContext(c,m);};
R.prototype.setBindingContext=function(c,m){var r=E.prototype.setBindingContext.call(this,c||null,m);this._updateTableCells(c);return r;};
R.prototype._updateTableCells=function(c){var t=this.getParent();if(!t){return;}var a=this.getCells(),A=this.getIndex(),h=!!t._updateTableCell,o,$,H;for(var i=0;i<a.length;i++){o=a[i];H=!!o._updateTableCell;$=H||h?o.$().closest("td"):null;if(H){o._updateTableCell(o,c,$,A);}if(h){t._updateTableCell(o,c,$,A);}}};
R.prototype._collectRenderingInformation=function(c,n,b){this._oNodeState=undefined;this._iLevel=0;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="";if(n){this._oNodeState=n.nodeState;this._iLevel=n.level;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="sapUiTableTreeIconLeaf";this._sGroupIconClass="";if(b){if(b.getLevel){this._bIsExpanded=b.isExpanded(this.getIndex());}else if(b.findNode){this._bIsExpanded=this&&this._oNodeState?this._oNodeState.expanded:false;}if(b.nodeHasChildren){if(this._oNodeState){this._bHasChildren=b.nodeHasChildren(n);}}else if(b.hasChildren){this._bHasChildren=b.hasChildren(c);}if(this._bHasChildren){this._sTreeIconClass=this._bIsExpanded?"sapUiTableTreeIconNodeOpen":"sapUiTableTreeIconNodeClosed";this._sGroupIconClass=this._bIsExpanded?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";}}}};
R.prototype.destroy=function(){this.removeAllCells();return E.prototype.destroy.apply(this,arguments);};
R.prototype.invalidate=function(){return this;};
R.prototype.getDragGhost=function(){var t=this.getParent();var o=t.getDomRef();var r=this.getDomRefs();var g;var G;var a;var s=t._getSelectedIndicesCount();function b(e){e.removeAttribute("id");e.removeAttribute("data-sap-ui");e.removeAttribute("data-sap-ui-related");var f=e.children.length;for(var i=0;i<f;i++){b(e.children[i]);}}function c(o,e){var f=o.cloneNode();var h=o.querySelector("thead").cloneNode(true);var i=o.querySelector("tbody").cloneNode();var j=e.cloneNode(true);i.appendChild(j);f.appendChild(h);f.appendChild(i);return f;}g=o.cloneNode();g.classList.add("sapUiTableRowGhost");g.classList.remove("sapUiTableVScr");g.classList.remove("sapUiTableHScr");g.style.width=o.getBoundingClientRect().width+"px";if(r.rowSelector){G=t.getDomRef("sapUiTableRowHdrScr").cloneNode();a=r.rowSelector.cloneNode(true);G.appendChild(a);g.appendChild(G);}if(r.rowFixedPart){G=t.getDomRef("sapUiTableCtrlScrFixed").cloneNode();a=c(t.getDomRef("table-fixed"),r.rowFixedPart);G.appendChild(a);g.appendChild(G);}if(r.rowScrollPart){var S=t.getDomRef("sapUiTableCtrlScr");G=S.cloneNode();a=c(t.getDomRef("table"),r.rowScrollPart);G.appendChild(t.getDomRef("tableCtrlCnt").cloneNode());G.firstChild.appendChild(a);g.appendChild(G);}if(r.rowAction){G=t.getDomRef("sapUiTableRowActionScr").cloneNode();a=r.rowAction.cloneNode(true);G.appendChild(a);g.appendChild(G);}if(s>1){G=document.createElement("div");G.classList.add("sapUiTableRowGhostCount");var d=document.createElement("div");d.textContent=s;G.appendChild(d);g.appendChild(G);}b(g);return g;};
R.prototype._setSelected=function(s){var t=this.getParent();if(s){this.addStyleClass("sapUiTableRowSel");}else{this.removeStyleClass("sapUiTableRowSel");}if(t){T.dynamicCall(t._getSyncExtension,function(S){S.syncRowSelection(t.indexOfRow(this),s);},this);}};
R.prototype._setHovered=function(h){var t=this.getParent();if(h){this.addStyleClass("sapUiTableRowHvr");}else{this.removeStyleClass("sapUiTableRowHvr");}if(t){T.dynamicCall(t._getSyncExtension,function(s){s.syncRowHover(t.indexOfRow(this),h);},this);}};
R.prototype.getRowAction=function(){return this.getAggregation("_rowAction");};
return R;});
sap.ui.predefine('sap/ui/table/RowAction',['sap/ui/core/Control',"sap/ui/table/TableUtils",'./library','sap/ui/core/Icon','sap/ui/unified/Menu','sap/ui/core/Popup',"./RowActionRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,T,l,I,M,P,R,K,q){"use strict";
var a=C.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}}});
a.prototype.init=function(){var s=function(v){this.setAggregation("tooltip",v,true);this.setSrc(this.getSrc());return this;};var o=function(e){this._bKeyboard=e.which===K.SPACE||e.which===K.ENTER;I.prototype.onkeyup.apply(this,arguments);};var t=this;var i=new I(this.getId()+"-icon0",{decorative:false,press:function(e){t._handlePress(e,true);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);i=new I(this.getId()+"-icon1",{decorative:false,press:function(e){t._handlePress(e,false);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);this._iLen=0;this._iCount=2;this._aActions=["",""];this._iLastCloseTime=0;};
a.prototype.onAfterRendering=function(){this._updateIcons();};
a.prototype.setVisible=function(v){this.setProperty("visible",v,true);this.$().toggleClass("sapUiTableActionHidden",!v);return this;};
a.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);var s=this.getTooltip_AsString();if(!s){this.$().removeAttr("title");}else{this.$().attr("title",s);}return this;};
a.prototype.insertItem=function(i,b){this.insertAggregation("items",i,b,true);this._updateIcons(true);return this;};
a.prototype.addItem=function(i){this.addAggregation("items",i,true);this._updateIcons(true);return this;};
a.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true);this._updateIcons(true);return r;};
a.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",true);this._updateIcons(true);return r;};
a.prototype.destroyItems=function(){this.destroyAggregation("items",true);this._updateIcons(true);return this;};
a.prototype.getAccessibilityInfo=function(){var p=this.$().parent();var A=this.getVisible()&&this._iLen>0&&this._iCount>0&&!p.hasClass("sapUiTableRowHidden")&&!p.hasClass("sapUiTableGroupHeader")&&!p.hasClass("sapUiAnalyticalTableSum");var t;if(A){t=T.getResourceText(this._iLen==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[this._iLen]);}else{t=T.getResourceText("TBL_ROW_ACTION_NO_ACTION");}return{focusable:A,enabled:A,description:t};};
a.prototype._getVisibleItems=function(f){if(!this._aVisibleItems||f){this._aVisibleItems=[];this._iLen=0;var b=this.getItems();for(var i=0;i<b.length;i++){if(b[i].getVisible()){this._aVisibleItems.push(b[i]);this._iLen++;}}}return this._aVisibleItems;};
a.prototype._getRow=function(){return this.getParent();};
a.prototype._getCount=function(){return this._iCount;};
a.prototype._setCount=function(c){if(c<0){this._iCount=0;}else if(c>=0){this._iCount=Math.min(c,2);}this._updateIcons();};
a.prototype._setFixedLayout=function(f){this._bFixedLayout=!!f;this._updateIcons();};
a.prototype._setIconLabel=function(L){var b=this.getAggregation("_icons");for(var i=0;i<b.length;i++){b[i].removeAllAriaLabelledBy();if(L){b[i].addAriaLabelledBy(L);}}};
a.prototype._handlePress=function(e,f){var b=f?0:1;var o=this.getAggregation("_icons")[b];var A=this._aActions[b];var k=o._bKeyboard;o._bKeyboard=false;if(A=="action"){this._getVisibleItems()[b]._doFirePress();}else if(A=="action_fixed"){this._getVisibleItems()[0]._doFirePress();}else if(A=="menu"){var m=this.getAggregation("_menu");if(!m){m=new M();this.setAggregation("_menu",m,true);m.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now();},this);}m.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return;}var c=this.getItems();for(var i=f?0:1;i<c.length;i++){m.addItem(c[i]._getMenuItem());}m.open(!!k,o,P.Dock.EndTop,P.Dock.EndBottom,o);}};
a.prototype._updateIcons=function(f){var i=this._getVisibleItems(f);var b=this.getAggregation("_icons");var $=this.$().children();function s(c){b[0].$()[c==0?"attr":"removeAttr"]("aria-haspopup",c==0?"true":undefined);b[1].$()[c==1?"attr":"removeAttr"]("aria-haspopup",c==1?"true":undefined);}if(this._bFixedLayout&&this._iLen==1&&this._iCount==2){var A=this.getItems();if(A.length>1&&i[0]===A[1]){i[0]._syncIcon(b[1]);q($.get(0)).toggleClass("sapUiTableActionHidden",true);q($.get(1)).toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["","action_fixed"];return;}}if(this._iLen==0||this._iCount==0){$.toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["",""];}else if(this._iLen==1&&this._iCount>0){i[0]._syncIcon(b[0]);q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["action",""];}else if(this._iLen==2&&this._iCount==2){i[0]._syncIcon(b[0]);i[1]._syncIcon(b[1]);$.toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["action","action"];}else if(this._iLen>2&&this._iCount==2){i[0]._syncIcon(b[0]);b[1].setSrc("sap-icon://overflow");b[1].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));$.toggleClass("sapUiTableActionHidden",false);s(1);this._aActions=["action","menu"];}else{b[0].setSrc("sap-icon://overflow");b[0].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(0);this._aActions=["menu",""];}};
return a;});
sap.ui.predefine('sap/ui/table/RowActionItem',['sap/ui/core/Element','./library','sap/ui/unified/MenuItem',"sap/ui/table/TableUtils"],function(E,l,M,T){"use strict";var R=l.RowActionType;
var I=E.extend("sap.ui.table.RowActionItem",{metadata:{library:"sap.ui.table",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Misc",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.ui.table.RowActionType",group:"Behavior",defaultValue:R.Custom}},events:{press:{item:{type:"sap.ui.table.RowActionItem"},row:{type:"sap.ui.table.Row"}}}}});
I.prototype.exit=function(){if(this._menuItem){this._menuItem.destroy();this._menuItem=null;}};
I.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._updateRowAction();return this;};
I.prototype.setText=function(t){this.setProperty("text",t,true);this._updateRowAction();return this;};
I.prototype.setType=function(t){this.setProperty("type",t,true);this._updateRowAction();return this;};
I.prototype.setVisible=function(v){this.setProperty("visible",v,true);this._updateRowAction(true);return this;};
I.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);this._updateRowAction();return this;};
I.prototype._doFirePress=function(){var p=this.getParent();this.firePress({item:this,row:p&&p._getRow?p._getRow():null});};
I.prototype._getMenuItem=function(){if(!this._menuItem){var t=this;this._menuItem=new M({select:function(e){t._doFirePress();}});}this._menuItem.setIcon(this._getIcon());this._menuItem.setVisible(this.getVisible());this._menuItem.setText(this._getText(false));return this._menuItem;};
I.prototype._getIcon=function(){var i=this.getIcon();if(i){return i;}if(this.getType()==R.Navigation){return"sap-icon://navigation-right-arrow";}if(this.getType()==R.Delete){return"sap-icon://sys-cancel";}return null;};
I.prototype._getText=function(p){var t=p?(this.getTooltip_AsString()||this.getText()):(this.getText()||this.getTooltip_AsString());if(t){return t;}if(this.getType()==R.Navigation){return T.getResourceText("TBL_ROW_ACTION_NAVIGATE");}if(this.getType()==R.Delete){return T.getResourceText("TBL_ROW_ACTION_DELETE");}return null;};
I.prototype._syncIcon=function(i){i.setSrc(this._getIcon());i.setTooltip(this._getText(true));};
I.prototype._updateRowAction=function(f){var p=this.getParent();if(p&&p._updateIcons){p._updateIcons(f);}};
return I;});
sap.ui.predefine('sap/ui/table/RowActionRenderer',['sap/ui/table/Row'],function(R){"use strict";var a={};
a.render=function(r,A){r.write("<div");r.writeControlData(A);r.addClass("sapUiTableAction");if(!(A.getParent()instanceof R)){r.addStyle("display","none");}if(!A.getVisible()){r.addClass("sapUiTableActionHidden");}r.writeClasses();r.writeStyles();var t=A.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");var i=A.getAggregation("_icons");r.renderControl(i[0]);r.renderControl(i[1]);r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/table/RowSettings',['sap/ui/core/Element','./TableUtils','sap/ui/base/DataType','./library','sap/ui/core/library'],function(E,T,D,l,c){"use strict";var M=c.MessageType;var I=c.IndicationColor;
var R=E.extend("sap.ui.table.RowSettings",{metadata:{library:"sap.ui.table",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""}}}});
R.prototype.validateProperty=function(p,v){if(p!="highlight"||v==null){return E.prototype.validateProperty.apply(this,arguments);}if(!D.getType("sap.ui.core.MessageType").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected is a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor"+" for property \""+p+"\" of "+this);}return v;};
R.prototype.setHighlight=function(h){var r;var H;this.setProperty("highlight",h,true);r=this._getRow();if(!r){return this;}H=r.getDomRef("highlight");if(!H){return this;}for(var m in M){H.classList.remove("sapUiTableRowHighlight"+m);}for(var i in I){H.classList.remove("sapUiTableRowHighlight"+i);}H.classList.add(this._getHighlightCSSClassName());var t=r.getParent();var a=t?t._getAccExtension():null;if(a){a.updateAriaStateOfRowHighlight(this);}return this;};
R.prototype.setHighlightText=function(h){var r=this._getRow();var t=r?r.getParent():null;var a=t?t._getAccExtension():null;this.setProperty("highlightText",h,true);if(a){a.updateAriaStateOfRowHighlight(this);}return this;};
R.prototype._getHighlightCSSClassName=function(){var h=this.getHighlight();if(h==null){h=M.None;}return"sapUiTableRowHighlight"+h;};
R.prototype._getHighlightText=function(){var h=this.getHighlight();if(h===M.None){return"";}var H=this.getHighlightText();if(h in M&&H===""){H=T.getResourceText("TBL_ROW_STATE_"+h.toUpperCase());}return H;};
R.prototype._getRow=function(){var r=this.getParent();if(T.isA(r,"sap.ui.table.Row")){return r;}else{return null;}};
return R;});
sap.ui.predefine('sap/ui/table/SelectionAdapter',['sap/ui/base/ManagedObject','./library'],function(M,l){"use strict";var S=l.SelectionMode;
var a=M.extend("sap.ui.table.SelectionAdapter",{metadata:{properties:{selectionMode:{type:"sap.ui.table.SelectionMode",defaultValue:S.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});
a.prototype.init=function(){this._bSuspended=false;};
a.prototype.exit=function(){this._oBinding=null;};
a.prototype.addSelectionInterval=function(i,I){};
a.prototype.clearSelection=function(){};
a.prototype.getSelectedIndex=function(){return-1;};
a.prototype.getSelectedIndices=function(){return[];};
a.prototype.getSelectableCount=function(){return 0;};
a.prototype.getSelectedCount=function(){return 0;};
a.prototype.isIndexSelectable=function(i){return false;};
a.prototype.isIndexSelected=function(i){return false;};
a.prototype.removeSelectionInterval=function(i,I){};
a.prototype.selectAll=function(){};
a.prototype.setSelectedIndex=function(i){};
a.prototype.setSelectionInterval=function(i,I){};
a.prototype.fireSelectionChange=function(A){if(!this._isSuspended()){this.fireEvent("selectionChange",A);}};
a.prototype._getBinding=function(){return this._oBinding;};
a.prototype._setBinding=function(b){this._oBinding=b;};
a.prototype._suspend=function(){this._bSuspended=true;};
a.prototype._resume=function(){this._bSuspended=false;};
a.prototype._isSuspended=function(){return this._bSuspended;};
return a;});
sap.ui.predefine('sap/ui/table/SelectionModelAdapter',['sap/ui/model/SelectionModel','./SelectionAdapter','./library'],function(S,a,l){"use strict";var b=l.SelectionMode;
var c=a.extend("sap.ui.table.SelectionModelAdapter");
c.prototype.init=function(){this.oSelectionModel=new S(this.getSelectionMode);this.oSelectionModel.attachEvent("selectionChanged",this._onSelectionChange,this);a.prototype.init.call(this);};
c.prototype.exit=function(){var B=this._getBinding();if(B){B.detachEvent("change",this._onBindingChange);}if(this.oSelectionModel){this.oSelectionModel.destroy();this.oSelectionModel=null;}a.prototype.exit.call(this);};
c.prototype.addSelectionInterval=function(i,I){if(!this.oSelectionModel||this.getSelectionMode()===b.None){return;}this.oSelectionModel.addSelectionInterval(i,I);};
c.prototype.clearSelection=function(){if(this.oSelectionModel){this.oSelectionModel.clearSelection();}};
c.prototype.getSelectedIndex=function(){if(this.oSelectionModel){return this.oSelectionModel.getLeadSelectedIndex();}return-1;};
c.prototype.getSelectedIndices=function(){if(this.oSelectionModel){return this.oSelectionModel.getSelectedIndices();}return[];};
c.prototype.getSelectableCount=function(){var B=this._getBinding();return B?B.getLength():0;};
c.prototype.getSelectedCount=function(){return this.getSelectedIndices().length;};
c.prototype.isIndexSelectable=function(i){var C=this._getLastIndex();return i>=0&&i<=C;};
c.prototype.isIndexSelected=function(i){return this.getSelectedIndices().indexOf(i)!==-1;};
c.prototype.removeSelectionInterval=function(i,I){if(this.oSelectionModel){this.oSelectionModel.removeSelectionInterval(i,I);}};
c.prototype.selectAll=function(){if(!this.oSelectionModel||this.getSelectionMode()===b.None){return;}this.oSelectionModel.selectAll(this._getLastIndex());};
c.prototype.setSelectedIndex=function(i){if(this.getSelectionMode()===b.None){return;}if(i===-1){this.clearSelection();}else{this.setSelectionInterval(i,i);}};
c.prototype.setSelectionInterval=function(i,I){if(!this.oSelectionModel||this.getSelectionMode()===b.None){return;}this.oSelectionModel.setSelectionInterval(i,I);};
c.prototype.setSelectionMode=function(s){var o=this.getSelectionMode();a.prototype.setSelectionMode.apply(this,arguments);if(this.getSelectionMode()!==o){this.clearSelection();}if(this.oSelectionModel){var i=(s===b.MultiToggle?S.MULTI_SELECTION:S.SINGLE_SELECTION);this.oSelectionModel.setSelectionMode(i);}return this;};
c.prototype._getLastIndex=function(){if(!this._getBinding()){return 0;}return this._getBinding().getLength()-1;};
c.prototype._onSelectionChange=function(e){var r=e.getParameter("rowIndices");var s=e.getParameter("selectAll");this.fireSelectionChange({rowIndices:r,selectAll:s});};
c.prototype._setBinding=function(B){var C=this._getBinding();a.prototype._setBinding.call(this,B);if(C!==B){this._suspend();this.clearSelection();this._resume();if(B){B.attachEvent("change",this._onBindingChange,this);}if(C){C.detachEvent("change",this._onBindingChange);}}};
c.prototype._onBindingChange=function(e){var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r==="sort"||r==="filter"){this.clearSelection();}};
return c;});
sap.ui.predefine('sap/ui/table/Table',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/util/PasteHelper','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','./TableDragAndDropExtension',"./TableRenderer","./SelectionModelAdapter","sap/ui/thirdparty/jquery","sap/base/Log"],function(D,C,E,I,P,a,F,S,B,b,R,c,T,d,e,f,g,h,j,k,m,q,L){"use strict";var G=c.GroupEventType,N=c.NavigationMode,n=c.SelectionMode,o=c.SelectionBehavior,p=c.SortOrder,V=c.VisibleRowCountMode;var M=5;
var r=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:o.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar,deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}}},designtime:"sap/ui/table/designtime/Table.designtime"}});
I.insertFontFaceStyle();
r.prototype.init=function(){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._bIsFlexItem=false;this._attachExtensions();this._initSelectionAdapter();this._bRowsBeingBound=false;this._bContextsRequested=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._aRowHeights=[];this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];this._performUpdateRows=T.throttle(function(s){this._updateBindingContexts();if(this._bInvalid){return;}this._getAccExtension().updateAccForCurrentCell(s);this._updateTableContent();this._updateSelection();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._collectRowHeights(true),true);this._updateRowHeights(this._aRowHeights,false);this._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();this._getScrollExtension().updateVerticalScrollbarVisibility();this._fireRowsUpdated(s);},{wait:50,asyncLeading:true});this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){T.readThemeParameters();}this._bInvalid=true;};
r.prototype._initSelectionAdapter=function(){this._oSelectionAdapter=new m();this._oSelectionAdapter.attachEvent("selectionChange",this._onSelectionChanged,this);};
r.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}d.enrich(this,g);d.enrich(this,h);d.enrich(this,f);d.enrich(this,e);d.enrich(this,j);this._bExtensionsInitialized=true;};
r.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();if(this._oSelectionAdapter){this._oSelectionAdapter.destroy();}delete this._aTableHeaders;};
r.prototype._detachExtensions=function(){d.cleanup(this);};
r.prototype.onpaste=function(i){if(i.isMarked()||/^(input|textarea)$/i.test(i.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(i.target)){return;}var l=P.getPastedDataAs2DArray(i.originalEvent);if(l.length===0||l[0].length===0){return;}this.firePaste({data:l});};
r.prototype.onThemeChanged=function(){T.readThemeParameters();if(this.getDomRef()){this.invalidate();}};
r.prototype.onlocalizationChanged=function(i){var l=i.changes||{};var s=l.hasOwnProperty("rtl");var t=l.hasOwnProperty("language");this._adaptLocalization(s,t).then(function(){this.invalidate();}.bind(this));};
r.prototype._adaptLocalization=function(i,l){if(!i&&!l){return Promise.reject();}var s=Promise.resolve();if(i){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){s=T.getResourceBundle({async:true,reload:true});}return s.then(function(){if(l){T.Menu.cleanupDataCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};
r.prototype._collectRowHeights=function(H){var l=this.getDomRef();if(!l){return[];}var s=this._getDefaultRowHeight();var t=H?".sapUiTableColHdrTr":".sapUiTableTr";var u=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+t);var v=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+t);var w=this.getRows().length;var x=[];var y=D.browser.chrome&&window.devicePixelRatio!=1;if(H&&this.getColumnHeaderHeight()>0){s=this.getColumnHeaderHeight();}for(var i=0;i<w;i++){var z=u[i]?u[i].getBoundingClientRect().height:0;var A=v[i]?v[i].getBoundingClientRect().height:0;var J=Math.max(z,A);if(y){var K=s-J;if(K>0&&K<1){x.push(Math.max(J,s-1));continue;}}x.push(Math.max(J,s));}if(x.length>0&&!H){T.dynamicCall(this._getSyncExtension,function(O){var Q=O.syncRowHeights(x.slice());if(Q&&Q.length===x.length){x=Q.slice();}});}return x;};
r.prototype._resetRowHeights=function(){var l=this._getDefaultRowHeight();var s="";if(l){s=l+"px";}var t=this.getDomRef();if(t){var u=t.querySelectorAll(".sapUiTableTr");for(var i=0;i<u.length;i++){u[i].style.height=s;}}};
r.prototype._resetColumnHeaderHeights=function(){var l=this.getDomRef();if(l){var s=l.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<s.length;i++){s[i].style.height=null;}}};
r.prototype._determineAvailableSpace=function(){var l=this.getDomRef();if(l&&l.parentNode){var s=l.querySelector(".sapUiTableCCnt");if(s){var u=0;if(this._bIsFlexItem){var t=l.childNodes;for(var i=0;i<t.length;i++){u+=t[i].offsetHeight;}u-=s.clientHeight;}else{u=l.scrollHeight-s.clientHeight;}var v=this._getScrollExtension();if(!v.isHorizontalScrollbarVisible()){var w={};w[D.browser.BROWSER.CHROME]=16;w[D.browser.BROWSER.FIREFOX]=16;w[D.browser.BROWSER.INTERNET_EXPLORER]=18;w[D.browser.BROWSER.EDGE]=16;w[D.browser.BROWSER.SAFARI]=16;w[D.browser.BROWSER.ANDROID]=8;u+=w[D.browser.name];}if(this._iLastAvailableSpace==null){this._iLastAvailableSpace=0;}var x=this._bIsFlexItem?l:l.parentNode;var y=Math.floor(q(x).height()-u);var A=Math.abs(y-this._iLastAvailableSpace);if(A>=5){this._iLastAvailableSpace=y;}return this._iLastAvailableSpace;}}return 0;};
r.prototype._collectTableSizes=function(){var s={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var l=this.getDomRef();if(!l){return s;}var t=l.querySelector(".sapUiTableCnt");if(t){s.tableCntHeight=t.clientHeight;s.tableCntWidth=t.clientWidth;}var u=l.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(u){s.tableCtrlScrollWidth=u.clientWidth;}var v=l.querySelector(".sapUiTableRowHdrScr");if(v){s.tableRowHdrScrWidth=v.clientWidth;}var w=l.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(w){s.tableCtrlScrWidth=w.clientWidth;}var H=this._getScrollExtension().getHorizontalScrollbar();if(H){s.tableHSbScrollLeft=H.scrollLeft;}var x=l.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(x){s.tableCtrlFixedWidth=x.clientWidth;}var y=this.getFixedColumnCount();var z=0;if(y){var A=this.getColumns();var J=l.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<J.length;i++){var K=parseInt(J[i].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(K)&&(K<y)){var O=A[K];var W;if(O._iFixWidth!=null){W=O._iFixWidth;}else{W=J[i].getBoundingClientRect().width;}z+=W;}}}if(z>0){var Q=this._getScrollExtension();var U=s.tableRowHdrScrWidth;var X=Q.getVerticalScrollbar();if(X&&!Q.isVerticalScrollbarExternal()){U+=X.offsetWidth;}if(T.hasRowActions(this)){var Y=this.getDomRef("sapUiTableRowActionScr");if(Y){U+=Y.offsetWidth;}}U+=T.Column.getMinColumnWidth();var Z=s.tableCntWidth-U;var $=Z>z;var _=!$;if(this._bIgnoreFixedColumnCount!==_){this._bIgnoreFixedColumnCount=_;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return s;};
r.prototype._updateRowHeights=function(i,H){var l=this.getDomRef();if(!l){return;}function u(y,z){var A=i[z];if(A){y.style.height=A+"px";}}var s=H?".sapUiTableColHdrTr":".sapUiTableTr";var t=H?[]:l.querySelectorAll(".sapUiTableRowSelectionCell");var v=H?[]:l.querySelectorAll(".sapUiTableRowActionCell");var w=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+s);var x=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+s);Array.prototype.forEach.call(t,u);Array.prototype.forEach.call(v,u);Array.prototype.forEach.call(w,u);Array.prototype.forEach.call(x,u);};
r.prototype.onBeforeRendering=function(i){if(i&&i.isMarked("renderRows")){return;}if(this._performUpdateRows.pending()){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var v=this.getVisibleRowCountMode();var l=this.getRows();this.getBinding("rows");if(v==V.Interactive||v==V.Fixed||(v==V.Auto&&this._iTableRowContentHeight&&l.length==0)){this._updateRows(this._calculateRowsToDisplay(),T.RowsUpdateReason.Render);}else if(this._bRowAggregationInvalid&&l.length>0){this._updateRows(this.getVisibleRowCount(),T.RowsUpdateReason.Render);}this._aTableHeaders=[];};
r.prototype.onAfterRendering=function(s){var t=s&&s.isMarked("renderRows");var v=this.getVisibleRowCountMode();var O=this.getVisibleRowCount();var $=this.$();this._bInvalid=false;this._attachEvents();this._initRowDomRefs();var u=this.getColumns();for(var i=0,l=u.length;i<l;i++){if(u[i].getVisible()){u[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection&&!t){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!t){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");}if(this._bFirstRendering&&v===V.Auto){Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,{forceUpdate:true}));}else{var w={skipHandleRowCountMode:t};var x=function(){if(t||this.getBinding("rows")==null){return;}if(v===V.Auto){if(O===this.getVisibleRowCount()){this._fireRowsUpdated(T.RowsUpdateReason.Render);}}else{this._fireRowsUpdated(T.RowsUpdateReason.Render);}}.bind(this);if(t){if(T.isVariableRowHeightEnabled(this)){w.rowContentHeight="reset";}else if(this.getRows().length===0&&v!==V.Interactive){w.rowContentHeight="recalculate";}}if(!t&&v===V.Auto&&this._bIsFlexItem){Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,w)).then(x);}else{this._updateTableSizes(T.RowsUpdateReason.Render,w);x();}}this._bFirstRendering=false;};
r.prototype.invalidate=function(){this._bInvalid=true;T.Column.invalidateColumnUtils(this);return C.prototype.invalidate.call(this);};
r.prototype._initRowDomRefs=function(){var l=this.getRows();for(var i=0;i<l.length;i++){l[i].initDomRefs();}};
r.prototype._updateTableSizes=function(s,O){var l=this.getDomRef();var t=this;function u(){T.registerResizeHandler(t,"",t._onTableResize.bind(t),!t._bIsFlexItem);}function v(){T.deregisterResizeHandler(t,"");}if(this._bInvalid||!l||!sap.ui.getCore().isThemeApplied()){return;}O=Object.assign({forceUpdate:false,skipHandleRowCountMode:false,rowContentHeight:undefined},O);this._bIsFlexItem=window.getComputedStyle(l.parentNode).display==="flex";if(l.offsetWidth===0){u();return;}this._resetRowHeights();this._resetColumnHeaderHeights();this._aRowHeights=this._collectRowHeights(false);var w=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)&&!T.isNoDataVisible(this)){this._getScrollExtension().updateInnerVerticalScrollPosition();}var x=null;if(!O.skipHandleRowCountMode&&this.getVisibleRowCountMode()==V.Auto){x=this._determineAvailableSpace();var y=this._calculateRowsToDisplay(x);if(this._updateRows(y,s)&&!O.forceUpdate){return;}}if(!this._bIsFlexItem){v();}function z(b1){var c1=b1.getDomRef();var d1=T.Column.getMinColumnWidth();var e1=[];var f1=b1.getColumnHeaderVisible();function g1(j1,k1){if(j1<=k1){return Math.max(j1,k1-5,d1)+"px";}return-1;}function h1(k1){var l1=Math.max(k1._minWidth||0,d1,k1.getMinWidth());var m1=k1.getWidth();var n1;var o1;var p1;if(T.isVariableWidth(m1)&&!T.isFixedColumn(b1,k1.getIndex())){n1=c1.querySelectorAll('th[data-sap-ui-colid="'+k1.getId()+'"]');o1=n1[f1?0:1];p1=o1?o1.offsetWidth:null;if(p1!==null){if(p1<=l1){return{headers:n1,newWidth:g1(p1,l1)};}else if(o1&&o1.style.width!=m1){e1.push({col:k1,header:o1,minWidth:l1,headers:n1});return{headers:n1,newWidth:m1};}e1.push({col:k1,header:o1,minWidth:l1,headers:n1});}}return null;}function i1(k1){if(k1){Array.prototype.forEach.call(k1.headers,function(l1){l1.style.width=k1.newWidth;});}}b1._getVisibleColumns().map(h1).forEach(i1);if(e1.length){var j1;for(var i=0;i<e1.length;i++){j1=e1[i].header&&e1[i].header.offsetWidth;e1[i].newWidth=g1(j1,e1[i].minWidth);if(parseInt(e1[i].newWidth)>=0){i1(e1[i]);}}}}z(this);this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(w,true);if(!O.skipHandleRowCountMode||O.rowContentHeight==="reset"){this._setRowContentHeight(x);}else if(O.rowContentHeight==="recalculate"){this._setRowContentHeight(this._determineAvailableSpace());}if(this.getVisibleRowCountMode()==V.Auto){var A=this._calculateRowsToDisplay(x!=null?x:this._determineAvailableSpace());if(A==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}}T.dynamicCall(this._getSyncExtension,function(i){i.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height});},this);var H=this._collectTableSizes();var J=this._getScrollExtension();J.updateHorizontalScrollbar(H);J.updateVerticalScrollbarPosition();J.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)){var K=$.hasClass("sapUiTableRActFlexible");var Q=this.getDomRef("dummycolhdr");if(Q){var U=this.getDomRef("header");var W=U.clientWidth;var X=this.getColumns().reduce(function(X,i){if(i.getDomRef()&&i.getIndex()>=this.getComputedFixedColumnCount()){return X+T.convertCSSSizeToPixel(i.getWidth());}return X;}.bind(this),0);var Y=Q.clientWidth;var Z=W>X;if(!K&&Z){var _=H.tableCtrlScrWidth+H.tableRowHdrScrWidth+H.tableCtrlFixedWidth-Y;var a1={width:"auto"};a1[this._bRtlMode?"right":"left"]=_;this.$("sapUiTableRowActionScr").css(a1);this.$("rowacthdr").css(a1);$.toggleClass("sapUiTableRActFlexible",true);}else if(K&&!Z){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");if(this._bIsFlexItem){u();}else{Promise.resolve().then(function(){if(t.getVisibleRowCountMode()===V.Auto){var i=t._calculateRowsToDisplay(t._determineAvailableSpace());if(t.getVisibleRowCount()!==i){t._iRenderingLoopCount=t._iRenderingLoopCount?t._iRenderingLoopCount+1:1;if(t._iRenderingLoopCount>M){L.error("Rendering has been re-started too many times ("+t._iRenderingLoopCount+")."+" Please run the Support Assistant to detect possible configuration issues.",t);return;}t._updateRows(i,s);}else{delete t._iRenderingLoopCount;u();}}else{u();}});}};
r.prototype.setShowOverlay=function(s){s=!!s;this.setProperty("showOverlay",s,true);if(this.getDomRef()){var i=document.activeElement;this.$().toggleClass("sapUiTableOverlay",s);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);}return this;};
r.prototype._updateFixedBottomRows=function(){var i=this.getFixedBottomRowCount();var l=this.getDomRef();if(l&&i>0){var $=q(l).find(".sapUiTableRowLastScrollable");$.removeClass("sapUiTableRowLastScrollable");var s=q(l).find(".sapUiTableRowFirstFixedBottom");s.removeClass("sapUiTableRowFirstFixedBottom");var t=T.getFirstFixedBottomRowIndex(this);var u=this.getRows();var v;if(t>=0&&t<u.length){v=u[t].getDomRefs(true);v.row.addClass("sapUiTableRowFirstFixedBottom",true);}if(t>=1&&t<u.length){v=u[t-1].getDomRefs(true);v.row.addClass("sapUiTableRowLastScrollable",true);}}};
r.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};
r.prototype.applyFocusInfo=function(i){if(i&&i.customId){q(document.getElementById(i.customId)).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};
r.prototype.setTitle=function(t){var i=t;if(typeof(t)==="string"||t instanceof String){i=c.TableHelper.createTextView({text:t,width:"100%"});i.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",i);return this;};
r.prototype.setFooter=function(v){var i=v;if(typeof(v)==="string"||v instanceof String){i=c.TableHelper.createTextView({text:v,width:"100%"});}this.setAggregation("footer",i);return this;};
r.prototype.setSelectionMode=function(s){if(s===n.Multi){s=n.MultiToggle;L.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'");}this.setProperty("selectionMode",s);this._oSelectionAdapter.setSelectionMode(s);return this;};
r.prototype.setFirstVisibleRow=function(i,O,s){if(parseInt(i)<0){L.error("The index of the first visible row must be greater than or equal to 0."+" The value has been set to 0.",this);i=0;}if(this._getTotalRowCount()>0){var l=this._getMaxFirstVisibleRowIndex();if(l<i){L.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+l+".",this);i=l;}}var t=this.getFirstVisibleRow()!=i;var u=this._getScrollExtension();if(t){var v=this._getFirstRenderedRowIndex();this.setProperty("firstVisibleRow",i,true);var w=this._getFirstRenderedRowIndex()!==v;if(this.getBinding("rows")){if(w){var x=O===true?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(x);}if(!O){u.updateVerticalScrollPosition();}}if(!s){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}else if(!O){u.updateVerticalScrollPosition();}return this;};
r.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
r.prototype.bindAggregation=function(s){if(s==="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};
r.prototype.bindRows=function(i){this._bRowsBeingBound=true;this._bContextsRequested=false;this._bContextsAvailable=false;if(this.getEnableBusyIndicator()){this.setBusy(false);}this._iPendingRequests=0;this._bPendingRequest=false;return C.prototype.bindAggregation.call(this,"rows",r._getSanitizedBindingInfo(arguments));};
r.prototype._bindAggregation=function(s,i){if(s==="rows"){this._bRowsBeingBound=true;this._bContextsRequested=false;this._bContextsAvailable=false;r._addBindingListener(i,"change",this._onBindingChange.bind(this));r._addBindingListener(i,"dataRequested",this._onBindingDataRequested.bind(this));r._addBindingListener(i,"dataReceived",this._onBindingDataReceived.bind(this));}E.prototype._bindAggregation.call(this,s,i);if(s==="rows"){var l=this.getBinding("rows");var t=l?l.getModel():null;this._oSelectionAdapter._setBinding(l);if(t&&t.getDefaultBindingMode()===B.OneTime){L.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}this._bRowsBeingBound=false;}};
r.prototype.destroyAggregation=function(A,s){var v=C.prototype.destroyAggregation.apply(this,arguments);if(A==="rows"){this._aRowClones.forEach(function(i){i.destroy();});this._aRowClones=[];}return v;};
r._getSanitizedBindingInfo=function(i){var l;if(i==null||i[0]==null){l=null;}else if(typeof i[0]==="string"){var s=i[0];var t=i[1];var u=i[2];var v=i[3];if(t instanceof S||Array.isArray(u)&&u[0]instanceof F){v=u;u=t;t=undefined;}l={path:s,sorter:u,filters:v,template:t};}else{l=i[0];}return l;};
r._addBindingListener=function(i,s,H){if(!i.events){i.events={};}if(!i.events[s]){i.events[s]=H;}else{var O=i.events[s];i.events[s]=function(){H.apply(this,arguments);O.apply(this,arguments);};}};
r.prototype._onBindingChange=function(i){var s=typeof(i)==="object"?i.getParameter("reason"):i;if(s==="sort"||s==="filter"){this.setFirstVisibleRow(0);}};
r.prototype.unbindAggregation=function(s,i){var l=this.getBinding("rows");if(s==="rows"&&this.isBound("rows")){i=true;}var v=E.prototype.unbindAggregation.call(this,s,i);if(s==="rows"&&l){this._invalidateColumnMenus();if(!this._bRowsBeingBound){this._oSelectionAdapter._setBinding(null);this._adjustToTotalRowCount();this._updateRows(this.getVisibleRowCount(),T.RowsUpdateReason.Unbind);this.updateRows(T.RowsUpdateReason.Unbind);}}return v;};
r.prototype.setVisibleRowCount=function(v){if(v!=null&&!isFinite(v)){return this;}var s=this.getVisibleRowCountMode();if(s==V.Auto){L.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var i=this.getFixedRowCount()+this.getFixedBottomRowCount();if(v<=i&&i>0){L.error("Table: "+this.getId()+" visibleRowCount('"+v+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}v=this.validateProperty("visibleRowCount",v);if(this.getBinding("rows")&&this._getTotalRowCount()<=v){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",v);this._setRowContentHeight(v*this._getDefaultRowHeight());T.dynamicCall(this._getSyncExtension,function(l){l.syncRowCount(v);});return this;};
r.prototype.setMinAutoRowCount=function(i){if(parseInt(i)<1){L.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);i=1;}this.setProperty("minAutoRowCount",i);return this;};
r.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};
r.prototype.setTooltip=function(t){L.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",t,true);};
r.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);L.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this;};
r.prototype._getFixedBottomRowContexts=function(i,l){var s=this.getBinding("rows");var t=[];if(!s){return t;}i=i||this.getFixedBottomRowCount();l=l||this._getTotalRowCount();var v=this.getVisibleRowCount();if(i>0&&(v-i)<l){t=this._getContexts(l-i,i);}return t;};
r.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};
r.prototype._getContexts=function(s,l,t){var i=this.getBinding("rows");if(i){return i.getContexts(s,l,t);}else{return[];}};
r.prototype._computeRequestLength=function(l){if(this.getVisibleRowCountMode()===V.Auto&&!this._bContextsRequested){var i=Math.ceil(D.resize.height/T.DefaultRowHeight.sapUiSizeCondensed);return Math.max(l,i);}return l;};
r.prototype._getRowContexts=function(v,s,l){var t=this.getBinding("rows");var u=v==null?this.getRows().length:v;if(!t||u<=0){return[];}s=s===true;l=l===true;var w=this._getFirstRenderedRowIndex();var x=this.getFixedRowCount();var y=this.getFixedBottomRowCount();var z=[];var A;var H=u-y;var J=0;var K=H;var O=this.getThreshold();O=O?Math.max(u,O):0;var Q=w;var U=function(Y,Z,Q){for(var i=0;i<Z.length;i++){Y[Q+i]=Z[i];}};if(x>0&&w>0){Q=w+x;H-=x;J=x;A=this._getFixedRowContexts(x);z=z.concat(A);}A=this._getContexts(Q,this._computeRequestLength(H),O);if(!s){this._adjustToTotalRowCount();}var W=this._getTotalRowCount();this._bContextsRequested=true;U(z,A,J);K=Math.min(K,Math.max(W-y,0));if(y>0){A=this._getFixedBottomRowContexts(y,W);U(z,A,K);}var X=this._getMaxFirstRenderedRowIndex();if(X<w&&this._bContextsAvailable&&!l){this.setProperty("firstVisibleRow",X,true);z=this._getRowContexts(u,s,true);}return z;};
r.prototype._adjustToTotalRowCount=function(){var i=this.getBinding("rows");var t=this._getTotalRowCount();var s=this._getScrollExtension();if(this._iBindingLength!==t){this._iBindingLength=t;this._updateFixedBottomRows();s.updateVerticalScrollbarVisibility();s.updateVerticalScrollHeight();if(!i||!T.hasPendingRequests(this)){this._updateNoData();}}};
r.prototype.refreshRows=function(v){var i=this.getBinding("rows");if(!i){L.error("RefreshRows must not be called without a binding",this);return;}this._bContextsAvailable=false;var t=this;var s=typeof(v)==="object"?v.getParameter("reason"):v;var l=this.getVisibleRowCountMode();var A=l===V.Auto;var u=A&&this.bOutput;if(!A||u){if(this.bOutput&&this.getRows().length===0){i.attachEventOnce("dataRequested",function(){if(t._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(t._mTimeouts.refreshRowsAdjustRows);}t._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){t._updateRows(t._calculateRowsToDisplay(),s,false);},0);});}if(s===a.Filter||s===a.Sort){this.setFirstVisibleRow(0);}var w=s!=null;this._updateBindingContexts(this._calculateRowsToDisplay(),w);}};
r.prototype.updateRows=function(s){if(this.bIsDestroyed||this._bIsBeingDestroyed){return;}if(!this._bRowsBeingBound||this._getTotalRowCount(true)>0){this._bContextsAvailable=true;}var v=this.getVisibleRowCountMode();var i=this.getRows().length===0||this._bRowAggregationInvalid;var A=v===V.Auto;var l=A&&this.bOutput;if(i&&(!A||l)){if(this._iTableRowContentHeight){var u=this._updateRows(this._calculateRowsToDisplay(),s);if(u){return;}}}this._performUpdateRows(s);};
r.prototype.insertRow=function(){L.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);return this;};
r.prototype.addRow=function(){L.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);return this;};
r.prototype.removeRow=function(){L.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);return null;};
r.prototype.removeAllRows=function(){L.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);return[];};
r.prototype.destroyRows=function(){L.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);return this;};
r.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};
r.prototype._attachEvents=function(){var $=this.$();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(i){if(q(i.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);d.attachEvents(this);};
r.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);D.resize.detachHandler(this._onWindowResize,this);d.detachEvents(this);};
r.prototype._cleanUpTimers=function(){var K;for(K in this._mTimeouts){if(this._mTimeouts[K]){window.clearTimeout(this._mTimeouts[K]);delete this._mTimeouts[K];}}for(K in this._mAnimationFrames){if(this._mAnimationFrames[K]){window.cancelAnimationFrame(this._mAnimationFrames[K]);delete this._mAnimationFrames[K];}}this._performUpdateRows.cancel();};
r.prototype._updateBindingContexts=function(i,s){var l=this.getBinding("rows");var t;s=s===true;if(l){t=this._getRowContexts(i,s);}if(!s){this._resetRowHeights();var u=this.getRows(),v=this.mBindingInfos["rows"],w=v&&v.model;for(var x=u.length-1;x>=0;x--){var y=t?t[x]:undefined;var z=u[x];if(z){z.setRowBindingContext(y,w,l);}}}};
r.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};
r.prototype.removeColumn=function(i,s){var l=this.removeAggregation('columns',i,s);if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var t=this._aSortedColumns.indexOf(i);if(!this._bReorderInProcess&&t>=0){this._aSortedColumns.splice(t,1);}this.invalidateRowsAggregation();return l;};
r.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return i;};
r.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return i;};
r.prototype.addColumn=function(i,s){this.addAggregation('columns',i,s);this.invalidateRowsAggregation();return this;};
r.prototype.insertColumn=function(i,l,s){this.insertAggregation('columns',i,l,s);this.invalidateRowsAggregation();return this;};
r.prototype._getTotalRowCount=function(){var i=this.getBinding("rows");return i?i.getLength():0;};
r.prototype._getSelectableRowCount=function(){return this._oSelectionAdapter.getSelectableCount();};
r.prototype._getMaxFirstVisibleRowIndex=function(){var i;if(T.isVariableRowHeightEnabled(this)){i=this._getTotalRowCount(true)-1;}else{i=this._getTotalRowCount(true)-this.getVisibleRowCount();}return Math.max(0,i);};
r.prototype._getMaxFirstRenderedRowIndex=function(){var i;if(T.isVariableRowHeightEnabled(this)){i=this._getTotalRowCount(true)-this.getVisibleRowCount()-1;}else{i=this._getTotalRowCount(true)-this.getVisibleRowCount();}return Math.max(0,i);};
r.prototype._getFirstRenderedRowIndex=function(){var i=this.getFirstVisibleRow();if(T.isVariableRowHeightEnabled(this)&&i>this._getMaxFirstRenderedRowIndex()){return this._getMaxFirstRenderedRowIndex();}else{return i;}};
r.prototype._getVisibleColumns=function(){var s=[];var t=this.getColumns();for(var i=0,l=t.length;i<l;i++){if(t[i].shouldRender()){s.push(t[i]);}}return s;};
r.prototype._getColumnsWidth=function(s,t){var u=this.getColumns();var v=0;if(s!==0&&!s){s=0;}if(t!==0&&!t){t=u.length;}for(var i=s,l=t;i<l;i++){if(u[i]&&u[i].shouldRender()){var w=T.convertCSSSizeToPixel(u[i].getWidth());if(w==null){w=T.Column.getMinColumnWidth();}v+=w;}}return v;};
r.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};
r.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);}};
r.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(l){l.preventDefault();return false;});};
r.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};
r.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};
r.prototype._findAndfireCellEvent=function(i,l,s){var $=q(l.target);var t=$.closest(".sapUiTableDataCell");var u=t.attr("id");var v=/.*-row(\d*)-col(\d*)/i.exec(u);var w=false;if(v){var x=v[1];var y=v[2];var z=this.getRows()[x];var A=z&&z.getCells()[y];var H=z&&z.getIndex();var J=A.data("sap-ui-colid");var K;if(this.getBindingInfo("rows")){K=z.getBindingContext(this.getBindingInfo("rows").model);}var O={rowIndex:H,columnIndex:y,columnId:J,cellControl:A,rowBindingContext:K,cellDomRef:t.get(0)};w=!i.call(this,O);if(!w&&typeof s==="function"){O.cellDomRef=t[0];w=s.call(this,O);}}return w;};
r.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var i=T.getFocusedItemInfo(this);if(i){return i.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};
r.prototype._isRowSelectable=function(i){return this._oSelectionAdapter.isIndexSelectable(i);};
r.prototype.pushSortedColumn=function(i,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(i);};
r.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};
r.prototype.sort=function(l,s,A){if(!l){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var t=this.getBinding("rows");if(t){t.sort();}this._aSortedColumns=[];}if(this.getColumns().indexOf(l)>=0){l.sort(s===p.Descending,A);}};
r.prototype.filter=function(i,v){if(this.getColumns().indexOf(i)>=0){i.filter(v);}};
r.prototype._updateSelection=function(){var s=this.getSelectionMode();if(s===n.None){return;}var t=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=T.isRowSelectionAllowed(this);var u=this.getRows();for(var i=0;i<u.length;i++){var v=u[i];v._updateSelection(this,t,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);if(T.hasSelectAll(this)){var $=this.$("selall");var A=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!A);this._getAccExtension().setSelectAllState(A);if(this._getShowStandardTooltips()){$.attr('title',T.getResourceText(A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL"));}}};
r.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};
r.prototype._onSelectionChanged=function(i){var l=i.getParameter("rowIndices");var s=i.getParameter("selectAll");var t=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:t,rowContext:this.getContextByIndex(t),rowIndices:l,selectAll:s,userInteraction:this._iSourceRowIndex!==undefined});};
r.prototype.getContextByIndex=function(i){var l=this.getBinding("rows");return i>=0&&l?l.getContexts(i,1)[0]:null;};
r.prototype.getSelectedIndex=function(){return this._oSelectionAdapter.getSelectedIndex();};
r.prototype.setSelectedIndex=function(i){this._oSelectionAdapter.setSelectedIndex(i);return this;};
r.prototype.clearSelection=function(){this._oSelectionAdapter.clearSelection();return this;};
r.prototype.selectAll=function(){if(T.hasSelectAll(this)){this._oSelectionAdapter.selectAll();}return this;};
r.prototype.getSelectedIndices=function(){return this._oSelectionAdapter.getSelectedIndices();};
r.prototype.addSelectionInterval=function(i,l){this._oSelectionAdapter.addSelectionInterval(i,l);return this;};
r.prototype.setSelectionInterval=function(i,l){this._oSelectionAdapter.setSelectionInterval(i,l);return this;};
r.prototype.removeSelectionInterval=function(i,l){this._oSelectionAdapter.removeSelectionInterval(i,l);return this;};
r.prototype.isIndexSelected=function(i){return this._oSelectionAdapter.isIndexSelected(i);};
r.prototype.setGroupBy=function(v){var i=v;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof i==="string"){i=sap.ui.getCore().byId(i);}var l=false;if(i instanceof b&&i!==O){if(this.getColumns().indexOf(i)===-1){throw new Error("Column has to be part of the columns aggregation!");}var s=this.fireGroup({column:i,groupedColumns:[i.getId()],type:G.group});if(O){O.setGrouped(false);l=true;}if(s&&this.getEnableGrouping()){i.setGrouped(true);}}if(!i||l){if(O){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",i);};
r.prototype.getBinding=function(s){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[s||"rows"]);};
r.prototype.setEnableGrouping=function(i){var l=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",i);if(l){l.setGrouped(i);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};
r.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};
r.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};
r.prototype.setShowColumnVisibilityMenu=function(s){this.setProperty("showColumnVisibilityMenu",s);this._invalidateColumnMenus();return this;};
r.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this.getFixedColumnCount();};
r.prototype.setFixedColumnCount=function(l,s){var t=this.getColumns();var u,i;for(i=l-1;i>=0;i--){u=t[i];if(u&&u.getVisible()){l=Math.max(l,u.getIndex()+T.Column.getHeaderSpan(u));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=l-1;i>=0;i--){u=t[i];if(u&&T.isVariableWidth(u.getWidth())){u._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+u.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",l,s);this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};
r.prototype.setFixedRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};
r.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};
r.prototype.setThreshold=function(t){this.setProperty("threshold",t,true);return this;};
r.prototype._invalidateColumnMenus=function(){var s=this.getColumns();for(var i=0,l=s.length;i<l;i++){s[i].invalidateMenu();}};
r.prototype._isTouchEvent=function(i){return!!(i&&i.originalEvent&&i.originalEvent.touches);};
r.prototype._getRowClone=function(s){var t=this._aRowClones[s];if(t&&!t.bIsDestroyed){return t;}t=new R(this.getId()+"-rows"+"-row"+s);this._aRowClones[s]=t;var u=this.getColumns();for(var i=0,l=u.length;i<l;i++){if(u[i].getVisible()){var v=u[i].getTemplateClone(i);if(v){t.addCell(v);}}}if(T.hasRowActions(this)){var w=this.getRowActionTemplate().clone();w._setFixedLayout(true);w._setCount(this.getRowActionCount());w._setIconLabel(this.getId()+"-rowacthdr");t.setAggregation("_rowAction",w,true);}var x=this.getRowSettingsTemplate();if(x){var y=x.clone();t.setAggregation("_settings",y,true);}return t;};
r.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};
r.prototype._updateRows=function(l,s,u){if(isNaN(l)||this.bIsDestroyed||this._bIsBeingDestroyed){return false;}if(u==null){u=true;}var t=this.getBinding("rows");var v=this.getRows();var i;this.setProperty("visibleRowCount",l,true);if(T.isNoDataVisible(this)&&!t){l=0;}else if(T.isVariableRowHeightEnabled(this)){l=l+1;}T.dynamicCall(this._getSyncExtension,function(H){H.syncRowCount(l);},this);if(this._bRowAggregationInvalid){this.destroyAggregation("rows",this._bInvalid?"KeepDom":true);v=[];}if(l===v.length){return false;}for(i=v.length-1;i>=l;i--){this.removeAggregation("rows",i,true);}v.splice(l);var w;var x;var y;if(u){x=this.getBindingInfo("rows");y=x&&x.model;w=this._getRowContexts(l);for(i=0;i<v.length;i++){v[i].setRowBindingContext(w[i],y,t);}}if(v.length<l){for(i=v.length;i<l;i++){var z=this._getRowClone(i);if(u){z.setRowBindingContext(w[i],y,t);}this.addAggregation("rows",z,true);this._bRowAggregationInvalid=false;if(u){z._updateTableCells(w[i]);}}}this._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();var A=u&&w.length>0;return this._renderRows(s,A);};
r.prototype._renderRows=function(s,i){var l=false;i=i===true;if(!this._bInvalid){var t=this.getDomRef("tableCCnt");if(!t){return false;}this._detachEvents();if(this.getVisibleRowCountMode()===V.Auto){var u=this.getDomRef();if(u){u.style.height="0px";}}var v=q.Event("BeforeRendering");v.setMarked("renderRows");v.srcControl=this;this._handleEvent(v);var w=sap.ui.getCore().createRenderManager(),x=this.getRenderer();x.renderTableCCnt(w,this);w.flush(t,false,false);w.destroy();v=q.Event("AfterRendering");v.setMarked("renderRows");v.srcControl=this;this._handleEvent(v);l=true;}if(i&&!this._bInvalid&&this.getBinding("rows")){var y=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){y._fireRowsUpdated(s);},0);}return l;};
r.prototype._getDefaultRowHeight=function(){var i=this.getRowHeight();if(i>0){return i+T.RowHorizontalFrameSize;}else{var s=T.getContentDensity(this);return T.DefaultRowHeight[s];}};
r.prototype._setRowContentHeight=function(H){H=H||0;var v=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var l=this._getDefaultRowHeight();var s=this.getMinAutoRowCount();var t;if(v==V.Interactive||v==V.Fixed){if(this._iTableRowContentHeight&&v==V.Interactive){t=s*l;if(!H){H=this._iTableRowContentHeight;}}else{t=i*l;H=t;}}else if(v==V.Auto){t=s*l;}var u=Math.max(H,t);if((v==V.Fixed&&this.getRows().length==0)||v!=V.Fixed){this._iTableRowContentHeight=Math.floor(u/l)*l;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",l*i+"px");}else{if((v==V.Fixed||v==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};
r.prototype._determineMinAutoRowCount=function(){var i=this.getMinAutoRowCount();if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){i=this.getVisibleRowCount()||i;}return i;};
r.prototype._calculateRowsToDisplay=function(t){this._iRowsToDisplayHeight=t||this._iRowsToDisplayHeight||this._iTableRowContentHeight;t=this._iRowsToDisplayHeight;var v=this.getVisibleRowCountMode();var i=0;if(v==V.Fixed){i=this.getVisibleRowCount()||0;}else if(v==V.Interactive||v==V.Auto){var l=this._determineMinAutoRowCount();var s=this._getDefaultRowHeight();if(!s||!t){i=l;}else{var A=Math.min(t,50000);var u=Math.floor(A/s);i=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(l,u));}}return Math.max(i,0);};
r.prototype.setShowNoData=function(s){this.setProperty('showNoData',s,true);this._updateNoData();return this;};
r.prototype.setNoData=function(v){var O=T.getNoDataText(this);this.setAggregation("noData",v,true);var s=T.getNoDataText(this);if(O!=null&&s!=null){if(O!==s){this.$("noDataMsg").text(s);}}else{this.invalidate();}return this;};
r.prototype.exportData=function(s){var t=sap.ui.requireSync("sap/ui/core/util/Export");s=s||{};if(!s.rows){var u=this.getBinding("rows"),v=this.getBindingInfo("rows");var w=u.aFilters.concat(u.aApplicationFilters);s.rows={path:v.path,model:v.model,sorter:u.aSorters,filters:w,parameters:v.parameters};}if(!s.exportType){var x=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");s.exportType=new x();}var y=s.rows.model;if(!y){var z=s.rows.path;var A=z.indexOf(">");if(A>0){y=z.substr(0,A);}}if(!s.columns){s.columns=[];var H=this.getColumns();for(var i=0,l=H.length;i<l;i++){var J=H[i];if(J.getSortProperty()){s.columns.push({name:J.getLabel().getText(),template:{content:{path:J.getSortProperty(),model:y}}});}}}var K=new t(s);this.addDependent(K);return K;};
r.prototype._onPersoApplied=function(){var s=this.getColumns();var t=[];for(var i=0,l=s.length;i<l;i++){var u=s[i];if(u.getSorted()){t.push(new S(u.getSortProperty(),u.getSortOrder()===p.Descending));}}var v=this.getBinding("rows");if(v){if(t.length>0){v.sort(t);}this.refreshRows();}};
r.prototype._toggleSelectAll=function(){if(!T.hasData(this)||this.getSelectionMode()!==n.MultiToggle){return;}if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}this._iSourceRowIndex=undefined;};
r.prototype.setBusy=function(i,s){var l=this.getBusy()!=i;s="sapUiTableCnt";var v=C.prototype.setBusy.call(this,i,s);if(l){this.fireBusyStateChanged({busy:i});}return v;};
r.prototype.setEnableBusyIndicator=function(v){this.setProperty("enableBusyIndicator",v,true);if(!v){this.setBusy(false);}return this;};
r.prototype._onBindingDataRequested=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var l=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(l&&this._iPendingRequests===1||!l)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
r.prototype._onBindingDataReceived=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;if(this._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(this._mTimeouts.refreshRowsAdjustRows);}this._adjustToTotalRowCount();if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=setTimeout(function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;}.bind(this),0);}};
r.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};
r.prototype._getSelectedIndicesCount=function(){return this._oSelectionAdapter.getSelectedCount();};
r.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};
r.prototype.setRowActionTemplate=function(t){this.setAggregation("rowActionTemplate",t);t=this.getRowActionTemplate();if(t){t._setCount(this.getRowActionCount());}this.invalidateRowsAggregation();return this;};
r.prototype.setRowActionCount=function(l){this.setProperty("rowActionCount",l);l=this.getRowActionCount();var s=this.getRowActionTemplate();if(s){s._setCount(l);}for(var i=0;i<this._aRowClones.length;i++){s=this._aRowClones[i].getRowAction();if(s){s._setCount(l);}}return this;};
r.prototype.setRowSettingsTemplate=function(t){this.setAggregation("rowSettingsTemplate",t);this.invalidateRowsAggregation();return this;};
r.prototype._validateRow=function(i){return i&&i instanceof R&&i.getParent()===this;};
r.prototype.getRowForCell=function(i){if(i){var l=i.getParent();if(this._validateRow(l)){return l;}}return null;};
r.prototype.getColumnForCell=function(i){if(this.getRowForCell(i)){var l=i.data("sap-ui-colindex");var s=this.getColumns();if(l>=0&&l<s.length){return s[l];}}return null;};
r.prototype.getCellControl=function(i,l,v){var s=T.getRowColCell(this,i,l,!v);return s.cell;};
r.prototype._fireRowsUpdated=function(s){if(s==null){s=T.RowsUpdateReason.Unknown;}this.fireEvent("_rowsUpdated",{reason:s});};
r.prototype._enableSynchronization=function(){var t=this;return new Promise(function(i,l){sap.ui.require(["sap/ui/table/TableSyncExtension"],function(s){i(d.enrich(t,s).getInterface());},function(s){l(s);});});};
r.prototype._enableLegacyMultiSelection=function(){this._legacyMultiSelection=function(i,l){var A=!!(l.metaKey||l.ctrlKey);if(!this.isIndexSelected(i)){if(A){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else if(A||this._getSelectedIndicesCount()===1){this.removeSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}.bind(this);};
return r;});
sap.ui.predefine('sap/ui/table/TableAccExtension',["sap/ui/core/Control","./library","./TableExtension","./TableAccRenderExtension","./TableUtils","sap/ui/Device","sap/ui/thirdparty/jquery"],function(C,l,T,a,b,D,q){"use strict";var S=l.SelectionMode;var c=b.CELLTYPE;var A={getAccInfoOfControl:function(o){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return A._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};A._flatten(s,t);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,L){L=L?L:0;A._normalize(s);if(L==0){A._normalize(t);t._descriptions=[];}t._descriptions.push(A._getFullDescription(s));s.children.forEach(function(o){if(!o.getAccessibilityInfo||(o.getVisible&&!o.getVisible())){return;}var e=o.getAccessibilityInfo();if(e){A._flatten(e,t,L+1);}});if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i){var s=i.type+" "+i.description;if(i.enabled===false){s=s+" "+b.getResourceText("TBL_CTRL_STATE_DISABLED");}else if(i.editable===false){s=s+" "+b.getResourceText("TBL_CTRL_STATE_READONLY");}return s.trim();}};var E={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();var i=b.getFocusedItemInfo(t);return i.cellInRow-(b.hasRowHeader(t)?1:0);},getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var f=i.getFocusedDomRef();if(!f||f!==document.activeElement){return null;}return b.getCellInfo(f);},getRelevantColumnHeaders:function(t,o){if(!t||!o){return[];}var h=b.getHeaderRowCount(t),s=o.getId(),L=[s];if(h>1){for(var i=1;i<h;i++){L.push(s+"_"+i);}var e=b.Column.getParentSpannedColumns(t,s);if(e&&e.length){for(var i=0;i<e.length;i++){var f=e[i].level;var p=e[i].column.getId();L[f]=f===0?p:(p+"_"+f);}}}return L;},isHiddenCell:function($,o){var g=b.Grouping.isInGroupingRow($);var s=b.Grouping.isInSumRow($);var e=!!o&&!!o.hasStyleClass;var i=$.parent().hasClass("sapUiTableRowHidden");var I=$.hasClass("sapUiTableCellHidden");var n=g&&$.hasClass("sapUiTableCellFirst")&&!$.hasClass("sapUiTableMeasureCell");var G=g&&e&&o.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var f=s&&e&&o.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return i||I||n||G||f;},isTreeColumnCell:function(e,$){return b.Grouping.isTreeMode(e.getTable())&&$.hasClass("sapUiTableCellFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,f=false,g=false;if(i){var h=E.getColumnIndexOfFocusedCell(e)+1;var r=b.getRowIndexOfFocusedCell(t)+t._getFirstRenderedRowIndex()+1;var j=b.getVisibleColumnCount(t)+(b.hasRowActions(t)?1:0);var R=b.isNoDataVisible(t)?0:b.getTotalRowCount(t,true);I=e._iLastRowNumber!=r||(e._iLastRowNumber==r&&e._iLastColumnNumber==h);f=e._iLastColumnNumber!=h;g=!e._iLastRowNumber&&!e._iLastColumnNumber;t.$("rownumberofrows").text(I?b.getResourceText("TBL_ROW_ROWCOUNT",[r,R]):" ");t.$("colnumberofcols").text(f?b.getResourceText("TBL_COL_COLCOUNT",[h,j]):" ");t.$("ariacount").text(g?b.getResourceText("TBL_DATA_ROWS_COLS",[R,j]):" ");e._iLastRowNumber=r;e._iLastColumnNumber=h;}return{rowChange:I,colChange:f,initial:g};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,f,g){e._cleanupInfo={cell:$,attr:{"aria-labelledby":f&&f.length?f.join(" "):null,"aria-describedby":g&&g.length?g.join(" "):null}};},performCellModifications:function(e,$,f,g,L,h,t,i){E.storeDefaultsBeforeCellModifications(e,$,f,g);var o=E.updateRowColCount(e);e.getTable().$("cellacc").text(t||" ");if(i){i(L,h,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){var j=e.getTable();s=j.getAriaLabelledBy().join(" ")+" "+j.getId()+"-ariadesc "+j.getId()+"-ariacount";if(j.getSelectionMode()!==S.None){s=s+" "+j.getId()+"-ariaselection";}}if(L&&L.length){s=s+" "+L.join(" ");}$.attr({"aria-labelledby":s?s:null,"aria-describedby":h&&h.length?h.join(" "):null});},modifyAccOfDATACELL:function($){var t=this.getTable(),s=t.getId(),i=t._getItemNavigation();if(!i){return;}var r=b.getRowIndexOfFocusedCell(t),e=E.getColumnIndexOfFocusedCell(this),o=b.getRowColCell(t,r,e,false),I=null,h=E.isHiddenCell($,o.cell),f=E.isTreeColumnCell(this,$),g=b.Grouping.isInGroupingRow($),j=b.Grouping.isInSumRow($),k=E.getAriaAttributesFor(this,d.ELEMENTTYPES.DATACELL,{index:e,column:o.column,fixed:b.isFixedColumn(t,e)})["aria-labelledby"]||[],m=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"];if(g){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(j){var n=$.parent().data("sap-ui-level");if(n==0){L.push(s+"-ariagrandtotallabel");}else if(n>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}if(b.hasRowHighlights(t)&&!g&&!j){L.push(o.row.getId()+"-highlighttext");}L=L.concat(k);if(!h){I=A.getAccInfoOfControl(o.cell);L.push(I?(s+"-cellacc"):o.cell.getId());if(b.getInteractiveElements($)!==null){m.push(s+"-toggleedit");}if(b.Grouping.isTreeMode(t)&&!!$.parent().attr("aria-selected")){L.push(s+"-ariarowselected");}}var p=I?I.description:" ";if(f&&!h){var u=E.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:o.row});if(u&&u["aria-label"]){p=u["aria-label"]+" "+p;}}E.performCellModifications(this,$,k,null,L,m,p,function(L,m,R,v,w){var x=$.find(".sapUiTableTreeIcon").length==1;if((x||b.Grouping.isInGroupingRow($))&&(R||v)){m.push(t.getId()+(!o.row._bIsExpanded?"-rowexpandtext":"-rowcollapsetext"));}else if(!h&&b.isRowSelectionAllowed(t)&&R){m.push(o.row.getId()+"-rowselecttext");}});},modifyAccOfROWHEADER:function($){var t=this.getTable(),s=t.getId(),i=b.Grouping.isInGroupingRow($),I=b.Grouping.isInSumRow($),r=t.getRows()[$.attr("data-sap-ui-rowindex")],e=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[],L=e.concat([s+"-rownumberofrows"]);if(!I&&!i){if(!$.hasClass("sapUiTableRowHidden")){L.push(r.getId()+"-rowselecttext");if(b.hasRowHighlights(t)){L.push(r.getId()+"-highlighttext");}}}if(i){L.push(s+"-ariarowgrouplabel");L.push(s+(r._bIsExpanded?"-rowcollapsetext":"-rowexpandtext"));}if(I){var f=$.data("sap-ui-level");if(f==0){L.push(s+"-ariagrandtotallabel");}else if(f>0){L.push(s+"-ariagrouptotallabel");}}E.performCellModifications(this,$,e,null,L,null,null);},modifyAccOfCOLUMNHEADER:function($){var t=this.getTable(),o=sap.ui.getCore().byId($.attr("data-sap-ui-colid")),m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:o,index:$.attr("data-sap-ui-colindex")}),s=E.getColumnTooltip(o),L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]),e=b.getCellInfo($),i=e.columnSpan;if(i>1){L.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(b.getResourceText("TBL_COL_DESC_SPAN",[""+i]));}if(s){L.push(t.getId()+"-cellacc");}if(i<=1&&o&&o.getSorted()){L.push(t.getId()+(o.getSortOrder()==="Ascending"?"-ariacolsortedasc":"-ariacolsorteddes"));}if(i<=1&&o&&o.getFiltered()){L.push(t.getId()+"-ariacolfiltered");}if(i<=1&&$.attr("aria-haspopup")==="true"){L.push(t.getId()+"-ariacolmenu");}E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function($){var t=this.getTable(),e=$.hasClass("sapUiTableSelAllEnabled");t.$("sapUiTableGridCnt").removeAttr("role");var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNROWHEADER,{enabled:e,checked:e&&!t.$().hasClass("sapUiTableSelAll")});E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],m["aria-labelledby"],m["aria-describedby"],null);},modifyAccOfROWACTION:function($){var t=this.getTable(),s=t.getId(),i=b.Grouping.isInGroupingRow($),I=b.Grouping.isInSumRow($),r=$.attr("data-sap-ui-rowindex"),R=t.getRows()[r],h=E.isHiddenCell($),e=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWACTION)["aria-labelledby"]||[],L=[s+"-rownumberofrows",s+"-colnumberofcols"].concat(e),f=[];if(i){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");L.push(s+(R._bIsExpanded?"-rowcollapsetext":"-rowexpandtext"));}if(I){var g=$.data("sap-ui-level");if(g==0){L.push(s+"-ariagrandtotallabel");}else if(g>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}if(!I&&!i&&$.attr("aria-selected")=="true"){L.push(s+"-ariarowselected");}if(b.hasRowHighlights(t)&&!i&&!I){L.push(R.getId()+"-highlighttext");}var j="";if(!h){var o=R.getRowAction();if(o){var k=o.getAccessibilityInfo();if(k){L.push(s+"-cellacc");j=k.description;if(b.getInteractiveElements($)!==null){f.push(s+"-toggleedit");}}}}E.performCellModifications(this,$,e,[],L,f,j);},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function f(o,v,O,w){var M="";if(O&&w){M="overlay,nodata";}else if(O&&!w){M="overlay";}else if(!O&&w){M="nodata";}var x=false;if(O&&o.getShowOverlay()||w&&b.isNoDataVisible(o)){x=true;}if(x){m["aria-hidden"]="true";}if(M){m["data-sap-ui-table-acc-covered"]=M;}}switch(t){case d.ELEMENTTYPES.COLUMNROWHEADER:m["aria-labelledby"]=[s+"-ariacolrowheaderlabel"];var g=false;m["role"]=["button"];if(p&&p.enabled){m["aria-pressed"]=p.checked?"true":"false";}else{g=true;m["aria-disabled"]="true";m["aria-pressed"]="false";}if(g||!o._getShowStandardTooltips()){m["aria-labelledby"].push(s+"-ariaselectall");}break;case d.ELEMENTTYPES.ROWHEADER:m["aria-labelledby"]=[s+"-ariarowheaderlabel"];if(!b.Grouping.isTreeMode(o)){m["role"]=["rowheader"];}if(o.getSelectionMode()!==S.None&&(!p||!p.rowHidden)){var h=p&&p.rowSelected;m["aria-selected"]=""+h;var j=e.getAriaTextsForSelectionMode(true);m["title"]=j.mouse[h?"rowDeselect":"rowSelect"];}break;case d.ELEMENTTYPES.ROWACTION:m["role"]=["gridcell"];m["aria-labelledby"]=[s+"-rowacthdr"];if(o.getSelectionMode()!==S.None&&(!p||!p.rowHidden)){var h=p&&p.rowSelected;m["aria-selected"]=""+h;}break;case d.ELEMENTTYPES.COLUMNHEADER:var k=p&&p.column;var H=p&&p.colspan;m["role"]="columnheader";var L=[];if(p&&p.headerId){var n=E.getRelevantColumnHeaders(o,k);var I=n.indexOf(p.headerId);L=I>0?n.slice(0,I+1):[p.headerId];}for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}m["aria-labelledby"]=L;if(p&&(p.index<o.getComputedFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(!H&&k&&k.getSorted()){m["aria-sort"]=k.getSortOrder()==="Ascending"?"ascending":"descending";}if(!H&&k&&k._menuHasItems()){m["aria-haspopup"]="true";}break;case d.ELEMENTTYPES.DATACELL:m["role"]="gridcell";var L=[],k=p&&p.column?p.column:null;if(k){L=E.getRelevantColumnHeaders(o,k);m["headers"]=L.join(" ");for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}}m["aria-labelledby"]=L;if(b.Grouping.isTreeMode(o)&&p&&p.firstCol&&p.row){var B=o.mBindingInfos["rows"];if(p.row.getBindingContext(B&&B.model)){m["aria-level"]=p.row._iLevel+1;m["aria-expanded"]=""+p.row._bIsExpanded;}}break;case d.ELEMENTTYPES.ROOT:break;case d.ELEMENTTYPES.TABLE:m["role"]="presentation";f(o,m,true,true);break;case d.ELEMENTTYPES.CONTENT:m["role"]=b.Grouping.isGroupMode(o)||b.Grouping.isTreeMode(o)?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===S.MultiToggle){m["aria-multiselectable"]="true";}break;case d.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";f(o,m,true,false);break;case d.ELEMENTTYPES.COLUMNHEADER_TBL:m["role"]="presentation";break;case d.ELEMENTTYPES.COLUMNHEADER_ROW:m["role"]="row";f(o,m,true,false);break;case d.ELEMENTTYPES.ROWHEADER_COL:f(o,m,true,true);break;case d.ELEMENTTYPES.TH:var r=o.getComputedFixedColumnCount()>0;if(!r){m["role"]="presentation";}m["scope"]="col";if(r){if(p&&p.column){m["aria-owns"]=p.column.getId();m["aria-labelledby"]=[p.column.getId()];}}else{m["aria-hidden"]="true";}break;case d.ELEMENTTYPES.ROWHEADER_TD:m["role"]="rowheader";m["aria-labelledby"]=[s+"-ariarowheaderlabel"];m["headers"]=s+"-colsel";if(p&&typeof p.index==="number"){m["aria-owns"]=s+"-rowsel"+p.index;}if(o.getSelectionMode()!==S.None){var h=p&&p.rowSelected;m["aria-selected"]=""+h;}break;case d.ELEMENTTYPES.TR:m["role"]="row";var h=false;if(p&&typeof p.index==="number"&&o.getSelectionMode()!==S.None&&o.isIndexSelected(p.index)){m["aria-selected"]="true";h=true;}if(b.isRowSelectionAllowed(o)&&o.getContextByIndex(p.index)){var j=e.getAriaTextsForSelectionMode(true);m["title"]=j.mouse[h?"rowDeselect":"rowSelect"];}break;case d.ELEMENTTYPES.TREEICON:if(b.Grouping.isTreeMode(o)){m={"aria-label":"","title":"","role":""};if(o.getBinding("rows")){m["role"]="button";if(p&&p.row){if(p.row._bHasChildren){var u=b.getResourceText(p.row._bIsExpanded?"TBL_COLLAPSE":"TBL_EXPAND");if(o._getShowStandardTooltips()){m["title"]=u;}else{m["aria-label"]=u;}m["aria-expanded"]=""+(!!p.row._bIsExpanded);m["aria-hidden"]="false";}else{m["aria-label"]=b.getResourceText("TBL_LEAF");m["aria-hidden"]="true";}}}}break;case d.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];f(o,m,true,false);break;case d.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case d.ELEMENTTYPES.TABLEFOOTER:case d.ELEMENTTYPES.TABLESUBHEADER:f(o,m,true,false);break;case d.ELEMENTTYPES.ROWACTIONHEADER:m["aria-hidden"]="true";break;case"PRESENTATION":m["role"]="presentation";break;}return m;}};
var d=T.extend("sap.ui.table.TableAccExtension",{
_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._busyCells=[];t.addEventDelegate(this);T.enrich(t,a);return"AccExtension";},
_debug:function(){this._ExtensionHelper=E;this._ACCInfoHelper=A;},
destroy:function(){this.getTable().removeEventDelegate(this);this._busyCells=[];T.prototype.destroy.apply(this,arguments);},
getAriaAttributesFor:function(t,p){return E.getAriaAttributesFor(this,t,p);},
onfocusin:function(e){var t=this.getTable();if(!t||b.getCellInfo(e.target).cell==null){return;}if(t._mTimeouts._cleanupACCExtension){clearTimeout(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell("Focus");},
onfocusout:function(e){var t=this.getTable();if(!t){return;}t.$("sapUiTableGridCnt").attr("role",E.getAriaAttributesFor(this,"CONTENT",{}).role);t._mTimeouts._cleanupACCExtension=setTimeout(function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;E.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;}.bind(this),100);}
});
d.ELEMENTTYPES={DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",ROWACTION:"ROWACTION",COLUMNROWHEADER:"COLUMNROWHEADER",ROOT:"ROOT",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_TBL:"COLUMNHEADER_TABLE",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",ROWHEADER_TD:"ROWHEADER_TD",TR:"TR",TREEICON:"TREEICON",ROWACTIONHEADER:"ROWACTIONHEADER",NODATA:"NODATA",OVERLAY:"OVERLAY"};
d.prototype.getAccMode=function(){return this._accMode;};
d.prototype.updateAccForCurrentCell=function(r){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}if(r==="Focus"||r===b.RowsUpdateReason.Expand||r===b.RowsUpdateReason.Collapse){E.cleanupCellModifications(this);}var t=this.getTable();var I=E.getInfoOfFocusedCell(this);var s;if(!I||!I.cell){return;}if(I.isOfType(c.DATACELL)){s=d.ELEMENTTYPES.DATACELL;}else if(I.isOfType(c.COLUMNHEADER)){s=d.ELEMENTTYPES.COLUMNHEADER;}else if(I.isOfType(c.ROWHEADER)){s=d.ELEMENTTYPES.ROWHEADER;}else if(I.isOfType(c.ROWACTION)){s=d.ELEMENTTYPES.ROWACTION;}else if(I.isOfType(c.COLUMNROWHEADER)){s=d.ELEMENTTYPES.COLUMNROWHEADER;}if(!E["modifyAccOf"+s]){return;}if(r!=="Focus"&&r!==b.RowsUpdateReason.Expand&&r!==b.RowsUpdateReason.Collapse){if(I.isOfType(c.DATACELL|c.ROWHEADER)){if(t._mTimeouts._cleanupACCCellBusy){clearTimeout(t._mTimeouts._cleanupACCCellBusy);t._mTimeouts._cleanupACCCellBusy=null;}t._mTimeouts._cleanupACCCellBusy=setTimeout(function(){for(var i=0;i<this._busyCells.length;i++){this._busyCells[i].removeAttr("aria-hidden");this._busyCells[i].removeAttr("aria-busy");}t._mTimeouts._cleanupACCCellBusy=null;this._busyCells=[];}.bind(this),100);if(D.browser.chrome){I.cell.attr("aria-hidden","true");}I.cell.attr("aria-busy","true");this._busyCells.push(I.cell);}else{return;}}E["modifyAccOf"+s].apply(this,[I.cell]);};
d.prototype.updateAriaStateOfColumn=function(o){if(!this._accMode){return;}var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});var h=E.getRelevantColumnHeaders(this.getTable(),o);for(var i=0;i<h.length;i++){var H=q(document.getElementById(h[i]));if(!H.attr("colspan")){H.attr({"aria-sort":m["aria-sort"]||null});}}};
d.prototype.updateAriaStateOfRow=function(r,R,i){if(!this._accMode){return;}if(!R){R=r.getDomRefs(true);}if(R.row){R.row.children("td").add(R.row).attr("aria-selected",i?"true":null);if(i&&R.rowSelectorText){var t=R.rowSelectorText.text();if(t){t=b.getResourceText("TBL_ROW_DESC_SELECTED")+" "+t;}R.rowSelectorText.text(t);}}};
d.prototype.updateAriaExpandAndLevelState=function(r,s,R,f,$,g,e,L,t){if(!this._accMode){return;}var h=null,o=this.getTable(),j=[s,s.children(),R,f,f?f.children():null,$],k=!!t,B=o.getBinding("rows");if(!g&&R&&!k){var I=R.attr("data-sap-ui-rowindex");var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER,{rowSelected:!r._bHidden&&o.isIndexSelected(I)});h=m["title"]||null;}if(R&&!k){R.attr({"aria-haspopup":g?"true":null,"title":h});}if(B&&B.hasTotaledMeasures&&L>0&&(!B.bProvideGrandTotals||!B.hasTotaledMeasures())){L=L-1;}for(var i=0;i<j.length;i++){if(j[i]){j[i].attr({"aria-expanded":g?e+"":null,"aria-level":L<0?null:(L+1)});}}if(k){t.attr(E.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:r}));}};
d.prototype.updateAriaStateOfRowHighlight=function(r){if(!this._accMode||!r){return;}var R=r._getRow();var h=R?R.getDomRef("highlighttext"):null;if(h){h.innerText=r._getHighlightText();}};
d.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(b.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};
d.prototype.getAriaTextsForSelectionMode=function(e,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var f=t._getShowStandardTooltips();var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectedIndicesCount();if(s===S.Single){m.mouse.rowSelect=f?b.getResourceText("TBL_ROW_SELECT"):"";m.mouse.rowDeselect=f?b.getResourceText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=b.getResourceText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=b.getResourceText("TBL_ROW_DESELECT_KEY");}else if(s===S.MultiToggle){m.mouse.rowSelect=f?b.getResourceText("TBL_ROW_SELECT_MULTI_TOGGLE"):"";m.mouse.rowDeselect=f?b.getResourceText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=b.getResourceText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=b.getResourceText("TBL_ROW_DESELECT_KEY");if(e===true&&i===0){m.mouse.rowSelect=f?b.getResourceText("TBL_ROW_SELECT"):"";}}return m;};
d.prototype.setSelectAllState=function(s){var t=this.getTable();if(t){t.$("selall").attr("aria-pressed",s?"true":"false");}};
d.prototype.addColumnHeaderLabel=function(o,e){var t=this.getTable();if(!this._accMode||!e.getAriaLabelledBy||!t){return;}var L=t.getColumnHeaderVisible()?o.getId():null;if(!L){var f=o.getAggregation("label");if(f){L=f.getId();}}var g=e.getAriaLabelledBy();if(L&&g.indexOf(L)<0){e.addAriaLabelledBy(L);}};
return d;});
sap.ui.predefine('sap/ui/table/TableAccRenderExtension',["./TableExtension","./TableUtils","./library"],function(T,a,l){"use strict";var S=l.SelectionMode;var _=function(r,p,i,t,c){c=c||[];c.push("sapUiInvisibleText");r.write("<span");r.writeAttribute("id",p+"-"+i);r.writeAttribute("class",c.join(" "));r.writeAttribute("aria-hidden","true");r.write(">");if(t){r.writeEscaped(t);}r.write("</span>");};
var A=T.extend("sap.ui.table.TableAccRenderExtension",{
_init:function(t,s,m){return"AccRenderExtension";},
writeHiddenAccTexts:function(r,t){if(!t._getAccExtension().getAccMode()){return;}var s=t.getId();r.write("<div class='sapUiTableHiddenTexts' style='display:none;' aria-hidden='true'>");var d=t.getTitle()&&t.getTitle().getText&&t.getTitle().getText()!=""?t.getTitle().getText():"";_(r,s,"ariadesc",d);_(r,s,"ariacount");_(r,s,"toggleedit",a.getResourceText("TBL_TOGGLE_EDIT_KEY"));_(r,s,"ariaselectall",a.getResourceText("TBL_SELECT_ALL"));_(r,s,"ariarowheaderlabel",a.getResourceText("TBL_ROW_HEADER_LABEL"));_(r,s,"ariarowgrouplabel",a.getResourceText("TBL_ROW_GROUP_LABEL"));_(r,s,"ariagrandtotallabel",a.getResourceText("TBL_GRAND_TOTAL_ROW"));_(r,s,"ariagrouptotallabel",a.getResourceText("TBL_GROUP_TOTAL_ROW"));_(r,s,"ariacolrowheaderlabel",a.getResourceText("TBL_ROW_COL_HEADER_LABEL"));_(r,s,"rownumberofrows");_(r,s,"colnumberofcols");_(r,s,"cellacc");_(r,s,"ariarowselected",a.getResourceText("TBL_ROW_DESC_SELECTED"));_(r,s,"ariacolmenu",a.getResourceText("TBL_COL_DESC_MENU"));_(r,s,"ariacolspan");_(r,s,"ariacolfiltered",a.getResourceText("TBL_COL_DESC_FILTERED"));_(r,s,"ariacolsortedasc",a.getResourceText("TBL_COL_DESC_SORTED_ASC"));_(r,s,"ariacolsorteddes",a.getResourceText("TBL_COL_DESC_SORTED_DES"));_(r,s,"ariainvalid",a.getResourceText("TBL_TABLE_INVALID"));_(r,s,"ariashowcolmenu",a.getResourceText("TBL_COL_VISBILITY_MENUITEM_SHOW"));_(r,s,"ariahidecolmenu",a.getResourceText("TBL_COL_VISBILITY_MENUITEM_HIDE"));_(r,s,"rowexpandtext",a.getResourceText("TBL_ROW_EXPAND_KEY"));_(r,s,"rowcollapsetext",a.getResourceText("TBL_ROW_COLLAPSE_KEY"));var o=t.getSelectionMode();if(o!==S.None){_(r,s,"ariaselection",a.getResourceText(o==S.MultiToggle?"TBL_TABLE_SELECTION_MULTI":"TBL_TABLE_SELECTION_SINGLE"));}if(t.getComputedFixedColumnCount()>0){_(r,s,"ariafixedcolumn",a.getResourceText("TBL_FIXED_COLUMN"));}r.write("</div>");},
writeAriaAttributesFor:function(r,t,s,p){var e=t._getAccExtension();if(!e.getAccMode()){return;}var m=e.getAriaAttributesFor(s,p);var v,k;for(k in m){v=m[k];if(Array.isArray(v)){v=v.join(" ");}if(v){r.writeAttributeEscaped(k,v);}}},
writeAccRowSelectorText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var I=t.isIndexSelected(i);var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var s=m.keyboard[I?"rowDeselect":"rowSelect"];_(r,R.getId(),"rowselecttext",R._bHidden?"":s,["sapUiTableAriaRowSel"]);},
writeAccRowHighlightText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var o=R.getAggregation("_settings");var h=o._getHighlightText();_(r,R.getId(),"highlighttext",h);}
});
return A;});
sap.ui.predefine('sap/ui/table/TableBindingUtils',[],function(){"use strict";return{TableUtils:null,metadataLoaded:function(t){var b=t.getBinding("rows");var m=b?b.getModel():null;var r=null;var R=null;var p=new Promise(function(a,c){r=a;R=c;});if(!m){R();return p;}if(m.metadataLoaded){m.metadataLoaded().then(function(){r();});}else if(m.attachMetadataLoaded){if(m.oMetadata&&m.oMetadata.isLoaded()){r();}else{m.attachMetadataLoaded(function(){r();});}}return p;}};},true);
sap.ui.predefine('sap/ui/table/TableColumnUtils',['sap/ui/Device','./library',"sap/base/Log"],function(D,l,L){"use strict";var T={TableUtils:null,initColumnUtils:function(t){if(!t._oColumnInfo){T.updateColumnInfo(t,T.collectColumnInfo(t));}},invalidateColumnUtils:function(t){t._oColumnInfo=null;},updateColumnInfo:function(t,c){t._oColumnInfo=c;},collectColumnInfo:function(t){return{columnCount:t.getColumns().length,visibleColumnCount:T.TableUtils.getVisibleColumnCount(t),columnMap:T._getColumnMap(t)};},_getColumnMap:function(t){var i;var c;var C={};var o={};var a=t.getColumns();var m=T.TableUtils.getHeaderRowCount(t);var p={};for(var b=0;b<a.length;b++){c=a[b];C={};C.id=c.getId();C.column=c;C.levelInfo=[];C.parents=[];for(var d=0;d<m;d++){C.levelInfo[d]={};C.levelInfo[d].spannedColumns=[];var h=T.getHeaderSpan(c,d);for(i=1;i<h;i++){var s=a[b+i];if(s){var P=s.getId();C.levelInfo[d].spannedColumns.push(a[b+i]);if(!p[P]){p[P]=[];}p[P].push({column:c,level:d});}}}o[C.id]=C;}var e=Object.keys(p);for(i=0;i<e.length;i++){var f=e[i];o[f].parents=p[f];}return o;},_getColumnMapItem:function(t,c){T.initColumnUtils(t);var s=t._oColumnInfo.columnMap[c];if(!s){L.error("Column with ID '"+c+"' not found",t);}else{return s;}},getParentSpannedColumns:function(t,c,a){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var p=[];for(var i=0;i<C.parents.length;i++){var P=C.parents[i];if(a===undefined||P.level===a){p.push(P);}}return p;},getChildrenSpannedColumns:function(t,c,a){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var b=[];var e;if(a===undefined){e=C.levelInfo.length;}else{e=a+1;}for(var i=a||0;i<e;i++){var o=C.levelInfo[i];for(var j=0;j<o.spannedColumns.length;j++){b.push({column:o.spannedColumns[j],level:i});}}return b;},getHeaderSpan:function(c,i){var h=c.getHeaderSpan();var H;if(!h){return 1;}if(!Array.isArray(h)){h=(h+"").split(",");}function g(s){var r=parseInt(s);return isNaN(r)?1:r;}if(isNaN(i)){H=Math.max.apply(null,h.map(g));}else{H=g(h[i]);}return Math.max(H,1);},getMaxHeaderSpan:function(c){return T.getHeaderSpan(c);},hasHeaderSpan:function(c){return T.getHeaderSpan(c)>1;},getColumnBoundaries:function(t,c){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var m={};if(c){m[c]=C.column;}var f=function(m,n){var o;var i;var g=[];n=n||[];for(i=0;i<n.length;i++){o=m[n[i]];g=g.concat(T.getParentSpannedColumns(t,o.getId()));g=g.concat(T.getChildrenSpannedColumns(t,o.getId()));}n=[];for(i=0;i<g.length;i++){o=g[i].column;var c=o.getId();if(!m[c]){n.push(c);m[c]=o;}}if(n.length>0){return f(m,n);}else{return m;}};m=f(m,[c]);var a=t.indexOfColumn(C.column);var b={startColumn:C.column,startIndex:a,endColumn:C.column,endIndex:-1};var d=t.getColumns();var k=Object.getOwnPropertyNames(m);for(var i=0;i<k.length;i++){var o=m[k[i]];a=t.indexOfColumn(o);var h=T.getMaxHeaderSpan(o);if(a<b.startIndex){b.startIndex=a;b.startColumn=o;}var e=a+h-1;if(e>b.endIndex){b.endIndex=e;b.endColumn=d[e];}}return b;},isColumnMovable:function(c){var t=c.getParent();if(!t||!t.getEnableColumnReordering()){return false;}var C=t.indexOfColumn(c);if(C<t.getComputedFixedColumnCount()||C<t._iFirstReorderableIndex){return false;}if(T.hasHeaderSpan(c)||T.getParentSpannedColumns(t,c.getId()).length!=0){return false;}return true;},_normalizeColumnMoveTargetIndex:function(c,n){var t=c.getParent(),C=t.indexOfColumn(c),a=t.getColumns();if(n>C){n--;}if(n<0){n=0;}else if(n>a.length){n=a.length;}return n;},isColumnMovableTo:function(c,n){var t=c.getParent();if(!t||n===undefined||!T.isColumnMovable(c)){return false;}n=T._normalizeColumnMoveTargetIndex(c,n);if(n<t.getComputedFixedColumnCount()||n<t._iFirstReorderableIndex){return false;}var C=t.indexOfColumn(c),a=t.getColumns();if(n>C){var b=a[n>=a.length?a.length-1:n];var o=T.getColumnBoundaries(t,b.getId());if(T.hasHeaderSpan(b)||o.endIndex>n){return false;}}else{var A=a[n];if(T.getParentSpannedColumns(t,A.getId()).length!=0){return false;}}return true;},moveColumnTo:function(c,n){if(!T.isColumnMovableTo(c,n)){return false;}var t=c.getParent(),C=t.indexOfColumn(c);if(n===C){return false;}n=T._normalizeColumnMoveTargetIndex(c,n);var e=t.fireColumnMove({column:c,newPos:n});if(!e){return false;}t._bReorderInProcess=true;t.removeColumn(c,true);t.insertColumn(c,n);t._bReorderInProcess=false;return true;},getMinColumnWidth:function(){if(this._iColMinWidth){return this._iColMinWidth;}this._iColMinWidth=48;if(!D.system.desktop){this._iColMinWidth=88;}return this._iColMinWidth;},resizeColumn:function(t,c,w,f,C){if(!t||c==null||c<0||w==null||w<=0){return false;}if(C==null||C<=0){C=1;}if(f==null){f=true;}var a=t.getColumns();if(c>=a.length||!a[c].getVisible()){return false;}var v=[];for(var i=c;i<a.length;i++){var o=a[i];if(o.getVisible()){v.push(o);if(v.length===C){break;}}}var r=[];for(var i=0;i<v.length;i++){var V=v[i];if(V.getResizable()){r.push(V);}}if(r.length===0){return false;}var s=0;for(var i=0;i<v.length;i++){var V=v[i];s+=T.getColumnWidth(t,V.getIndex());}var p=w-s;var S=Math.round(p/r.length);var R=false;var b=t.getDomRef();if(!T.TableUtils.isFixedColumn(t,c)){t._getVisibleColumns().forEach(function(k){var m=k.getWidth(),q;if(b&&r.indexOf(k)<0&&T.TableUtils.isVariableWidth(m)){q=b.querySelector('th[data-sap-ui-colid="'+k.getId()+'"]');if(q){k._minWidth=Math.max(q.offsetWidth,T.getMinColumnWidth());}}});}for(var i=0;i<r.length;i++){var d=r[i];var e=T.getColumnWidth(t,d.getIndex());var n=e+S;var g=T.getMinColumnWidth();if(n<g){n=g;}var W=n-e;if(Math.abs(W)<Math.abs(S)){var h=r.length-(i+1);p-=W;S=Math.round(p/h);}if(W!==0){var E=true;var j=n+"px";if(f){E=t.fireColumnResize({column:d,width:j});}if(E){d.setWidth(j);R=true;}}}return R;},getColumnWidth:function(t,c){if(!t||c==null||c<0){return null;}var C=t.getColumns();if(c>=C.length){return null;}var o=C[c];var s=o.getWidth();if(s===""||s==="auto"||s.match(/%$/)){if(o.getVisible()){var a=o.getDomRef();return a?a.offsetWidth:0;}else{return 0;}}else{return T.TableUtils.convertCSSSizeToPixel(s);}},getFixedColumnCount:function(t,c){var f=t.getComputedFixedColumnCount();if(!c){return f;}if(f<=0||t._bIgnoreFixedColumnCount){return 0;}var C=t.getColumns();var v=0;f=Math.min(f,C.length);for(var i=0;i<f;i++){if(C[i].shouldRender()){v++;}}return v;}};return T;},true);
sap.ui.predefine('sap/ui/table/TableDragAndDropExtension',["./TableExtension","sap/ui/table/TableUtils","sap/ui/core/library"],function(T,a,C){"use strict";var S="sap.ui.table";var D=C.dnd.DropPosition;var E={getSessionData:function(d,k){return d.getComplexData(S+(k==null?"":"-"+k));},setSessionData:function(d,s,k){d.setComplexData(S+(k==null?"":"-"+k),s);},getInstanceSessionData:function(d,t){return this.getSessionData(d,t.getId());},setInstanceSessionData:function(d,t,s){this.setSessionData(d,s,t.getId());}};var b={ondragstart:function(e){var d=e.dragSession;if(!d||!d.getDragControl()){return;}var o=d.getDragControl();var s={};if(o.isA("sap.ui.table.Row")){var f=this.getContextByIndex(o.getIndex());var g=o.getDomRef();if(!f||g.classList.contains("sapUiTableGroupHeader")||g.classList.contains("sapUiAnalyticalTableSum")){e.preventDefault();return;}else{s.draggedRowContext=f;}}E.setInstanceSessionData(d,this,s);},ondragenter:function(e){var d=e.dragSession;if(!d||!d.getDropControl()){return;}var s=E.getInstanceSessionData(d,this);var o=d.getDragControl();var f=d.getDropControl();if(!s){s={};}if(f.isA("sap.ui.table.Row")){var g=s.draggedRowContext;var h=this.getContextByIndex(f.getIndex());var i=f.getDomRef();var j=d.getDropInfo().getDropPosition();if((!h&&j===D.On&&a.hasData(this))||(g&&g===h)||i.classList.contains("sapUiTableGroupHeader")||i.classList.contains("sapUiAnalyticalTableSum")){e.setMarked("NonDroppable");}else{if(!h){var l=this.getRows()[a.getNonEmptyVisibleRowCount(this)-1];d.setDropControl(l||this);}if(d.getDropControl()!==this){var v=this.getDomRef().classList.contains("sapUiTableVScr");var t=this.getDomRef("sapUiTableCnt").getBoundingClientRect();d.setIndicatorConfig({width:t.width-(v?16:0),left:t.left+(this._bRtlMode&&v?16:0)});}}}else if(f.isA("sap.ui.table.Column")){var t=this.getDomRef("sapUiTableCnt").getBoundingClientRect();d.setIndicatorConfig({height:t.height-(this._getScrollExtension().isHorizontalScrollbarVisible()?16:0)});}else if(o===f){e.setMarked("NonDroppable");}if(!s.verticalScrollEdge){var p=window.pageYOffset;var V=this.getDomRef("table").getBoundingClientRect();s.verticalScrollEdge={bottom:V.bottom+p,top:V.top+p};}var P=window.pageXOffset;var H=this.getDomRef("sapUiTableCtrlScr").getBoundingClientRect();s.horizontalScrollEdge={left:H.left+P,right:H.right+P};E.setInstanceSessionData(d,this,s);},ondragover:function(e){var d=e.dragSession;if(!d){return;}var s=E.getInstanceSessionData(d,this);if(!s){return;}var i=32;var t=50;var o=d.getDropControl();var f=this._getScrollExtension();var v=f.getVerticalScrollbar();var h=f.getHorizontalScrollbar();var V=s.verticalScrollEdge;var H=s.horizontalScrollEdge;if(V&&v&&o!==this){var p=e.pageY;if(p>=V.top-t&&p<=V.top+t){v.scrollTop-=i;}else if(p<=V.bottom+t&&p>=V.bottom-t){v.scrollTop+=i;}}if(H&&h&&o!==this){var P=e.pageX;if(P>=H.left-t&&P<=H.left+t){h.scrollLeft-=i;}else if(P<=H.right+t&&P>=H.right-t){h.scrollLeft+=i;}}},onlongdragover:function(e){var d=e.dragSession;if(!d){return;}var $=a.getCell(this,e.target);var r=a.getCellInfo($).rowIndex;var R=r==null?null:this.getRows()[r];var o=d.getDropControl();if(R&&(o==R||!o)){a.Grouping.toggleGroupHeader(this,R.getIndex(),true);}}};
var c=T.extend("sap.ui.table.TableDragAndDropExtension",{
_init:function(t,s,m){this._oDelegate=b;t.addEventDelegate(this._oDelegate,t);return"DragAndDropExtension";},
_debug:function(){this._ExtensionDelegate=b;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._oDelegate);}this._oDelegate=null;T.prototype.destroy.apply(this,arguments);}
});
return c;});
sap.ui.predefine('sap/ui/table/TableExtension',["sap/ui/base/Object","./TableUtils"],function(B,T){"use strict";
var a=B.extend("sap.ui.table.TableExtension",{
_table:null,
_type:null,
_settings:null,
constructor:function(t,s){B.call(this);this._table=t;this._settings=s||{};this._type=a.TABLETYPES.STANDARD;if(t.isA("sap.ui.table.TreeTable")){this._type=a.TABLETYPES.TREE;}else if(t.isA("sap.ui.table.AnalyticalTable")){this._type=a.TABLETYPES.ANALYTICAL;}var e=this._init(this._table,this._type,this._settings);if(e){var b=this;t["_get"+e]=function(){return b;};}},
destroy:function(){this._table=null;this._type=null;this.bIsDestroyed=true;B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
a.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};
a.prototype.getTable=function(){return this._table;};
a.prototype._init=function(t,s,S){return null;};
a.prototype._attachEvents=function(){};
a.prototype._detachEvents=function(){};
a.attachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._attachEvents();}};
a.detachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._detachEvents();}};
a.enrich=function(t,E,s){if(!E||!(E.prototype instanceof a)){return null;}var e=new E(t,s);if(!t._aExtensions){t._aExtensions=[];}t._aExtensions.push(e);return e;};
a.cleanup=function(t){if(!t._bExtensionsInitialized||!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i].destroy();}delete t._aExtensions;delete t._bExtensionsInitialized;};
a.isEnrichedWith=function(t,e){if(!t||!t._aExtensions){return false;}for(var i=0;i<t._aExtensions.length;i++){if(t._aExtensions[i].getMetadata().getName()===e){return true;}}return false;};
return a;});
sap.ui.predefine('sap/ui/table/TableGrouping',['sap/ui/core/Element','sap/ui/model/Sorter','sap/ui/Device','./library',"sap/ui/thirdparty/jquery"],function(E,S,D,l,q){"use strict";var T={TableUtils:null,clearMode:function(t){t._mode=null;},setGroupMode:function(t){t._mode="Group";},isGroupMode:function(t){return t._mode=="Group";},setTreeMode:function(t){t._mode="Tree";},isTreeMode:function(t){return t._mode=="Tree";},getModeCssClass:function(t){switch(t._mode){case"Group":return"sapUiTableGroupMode";case"Tree":return"sapUiTableTreeMode";default:return null;}},showGroupMenuButton:function(t){if(t._bShowGroupMenuButton===true||t._bShowGroupMenuButton===false){return t._bShowGroupMenuButton;}if(!D.system.desktop&&t.isA("sap.ui.table.AnalyticalTable")){t._bShowGroupMenuButton=true;}else{t._bShowGroupMenuButton=false;}return t._bShowGroupMenuButton;},toggleGroupHeader:function(t,r,e){var I=[];var b=t?t.getBinding("rows"):null;if(!t||!b||!b.expand||r==null){return null;}if(typeof r==="number"){I=[r];}else if(Array.isArray(r)){if(e==null&&r.length>1){return null;}I=r;}var a=t._getTotalRowCount(true);var v=I.filter(function(c){var d=b.isExpanded(c);var f=true;if(b.nodeHasChildren){if(b.getNodeByIndex){f=!b.nodeHasChildren(b.getNodeByIndex(c));}else{f=false;}}return c>=0&&c<a&&!f&&e!==d;}).sort();if(v.length===0){return null;}for(var i=v.length-1;i>0;i--){if(e){b.expand(v[i],true);}else{b.collapse(v[i],true);}}if(e===true){b.expand(v[0],false);}else if(e===false){b.collapse(v[0],false);}else{b.toggleIndex(v[0]);}return b.isExpanded(v[0]);},toggleGroupHeaderByRef:function(t,r,e){var R=q(r);var g;if(R.hasClass("sapUiTableTreeIcon")||(T.isTreeMode(t)&&R.hasClass("sapUiTableCellFirst"))){g=R.closest("tr",t.getDomRef());}else{g=R.closest(".sapUiTableGroupHeader",t.getDomRef());}var b=t.getBinding("rows");if(g.length>0&&b){var G=g.data("sap-ui-rowindex");var o=t.getRows()[G];if(o){var a=o.getIndex();var i=T.toggleGroupHeader(t,a,e);var c=i===true||i===false;if(c&&t._onGroupHeaderChanged){t._onGroupHeaderChanged(a,i);}return c;}}return false;},isInGroupingRow:function(c){var i=T.TableUtils.getCellInfo(c);if(i.isOfType(T.TableUtils.CELLTYPE.DATACELL)){return i.cell.parent().hasClass("sapUiTableGroupHeader");}else if(i.isOfType(T.TableUtils.CELLTYPE.ROWHEADER|T.TableUtils.CELLTYPE.ROWACTION)){return i.cell.hasClass("sapUiTableGroupHeader");}return false;},isGroupingRow:function(r){if(!r){return false;}return q(r).hasClass("sapUiTableGroupHeader");},isInSumRow:function(c){var i=T.TableUtils.getCellInfo(c);if(i.isOfType(T.TableUtils.CELLTYPE.DATACELL)){return i.cell.parent().hasClass("sapUiAnalyticalTableSum");}else if(i.isOfType(T.TableUtils.CELLTYPE.ROWHEADER|T.TableUtils.CELLTYPE.ROWACTION)){return i.cell.hasClass("sapUiAnalyticalTableSum");}return false;},_calcGroupIndent:function(t,L,c,s){if(t.isA("sap.ui.table.TreeTable")){var I=0;for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}else if(t.isA("sap.ui.table.AnalyticalTable")){var I=0;L=L-1;L=!c&&!s?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){if(I==0){I=12;}I=I+(i<2?12:8);}return I;}else{var I=0;L=!c?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}},_setIndent:function(t,r,R,i){var b=t._bRtlMode,f=r.find("td.sapUiTableCellFirst > .sapUiTableCellInner"),s=R.find(".sapUiTableGroupShield");if(i<=0){R.css(b?"right":"left","");s.css("width","").css(b?"margin-right":"margin-left","");f.css(b?"padding-right":"padding-left","");}else{R.css(b?"right":"left",i+"px");s.css("width",i+"px").css(b?"margin-right":"margin-left",((-1)*i)+"px");f.css(b?"padding-right":"padding-left",(i+8)+"px");}},updateTableRowForGrouping:function(t,r,c,e,h,s,L,g){var d=r.getDomRefs(true),R=d.row,$=d.rowScrollPart,f=d.rowFixedPart,a=d.rowSelector,b=d.rowAction;R.attr({"data-sap-ui-level":L});R.data("sap-ui-level",L);if(T.isGroupMode(t)){R.toggleClass("sapUiAnalyticalTableSum",!c&&s).toggleClass("sapUiAnalyticalTableDummy",false).toggleClass("sapUiTableGroupHeader",c).toggleClass("sapUiTableRowHidden",c&&h||r._bHidden);q(document.getElementById(r.getId()+"-groupHeader")).toggleClass("sapUiTableGroupIconOpen",c&&e).toggleClass("sapUiTableGroupIconClosed",c&&!e).attr("title",t._getShowStandardTooltips()&&g?g:null).text(g||"");T._setIndent(t,R,a,T._calcGroupIndent(t,L,c,s));}var i=null;if(T.isTreeMode(t)){i=R.find(".sapUiTableTreeIcon");i.css(t._bRtlMode?"margin-right":"margin-left",(L*17)+"px").toggleClass("sapUiTableTreeIconLeaf",!c).toggleClass("sapUiTableTreeIconNodeOpen",c&&e).toggleClass("sapUiTableTreeIconNodeClosed",c&&!e);}if(T.showGroupMenuButton(t)){var j=0;var k=t.$();if(k.hasClass("sapUiTableVScr")){j+=k.find('.sapUiTableVSb').width();}var G=a.find(".sapUiTableGroupMenuButton");if(t._bRtlMode){G.css("right",(k.width()-G.width()+a.position().left-j-5)+"px");}else{G.css("left",(k.width()-G.width()-a.position().left-j-5)+"px");}}t._getAccExtension().updateAriaExpandAndLevelState(r,$,a,f,b,c,e,L,i);},cleanupTableRowForGrouping:function(t,r){var d=r.getDomRefs(true);d.row.removeAttr("data-sap-ui-level");d.row.removeData("sap-ui-level");if(T.isGroupMode(t)){d.row.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");T._setIndent(t,d.row,d.rowSelector,0);}var $=null;if(T.isTreeMode(t)){$=d.row.find(".sapUiTableTreeIcon");$.removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed").css(this._bRtlMode?"margin-right":"margin-left","");}t._getAccExtension().updateAriaExpandAndLevelState(r,d.rowScrollPart,d.rowSelector,d.rowFixedPart,d.rowAction,false,false,-1,$);},updateGroups:function(t){if(T.isGroupMode(t)||T.isTreeMode(t)){var b=t.getBinding("rows"),r=t.getBindingInfo("rows"),R=t.getRows(),c=R.length;if(b){var o;for(var i=0;i<c;i++){o=T._getRowGroupInfo(t,R[i],b,r);T.updateTableRowForGrouping(t,R[i],o.isHeader,o.expanded,o.hidden,false,o.level,o.title);}}else{for(var i=0;i<c;i++){T.cleanupTableRowForGrouping(t,R[i]);}}}},_getRowGroupInfo:function(t,r,R,o){var a={isHeader:false,expanded:false,hidden:false,title:"",level:0};if(t.getGroupHeaderProperty){a.isHeader=r._bHasChildren;a.expanded=r._bIsExpanded;a.hidden=a.isHeader;a.level=r._iLevel;var h=t.getGroupHeaderProperty();if(T.isGroupMode(t)&&h){var m=o&&o.model;a.title=t.getModel(m).getProperty(h,r.getBindingContext(m));}}else{var i=r.getIndex();a.isHeader=!!R.isGroupHeader(i);a.level=a.isHeader?0:1;if(a.isHeader){a.expanded=!!R.isExpanded(i);a.hidden=true;a.title=R.getTitle(i);}}return a;},setupExperimentalGrouping:function(t){if(!t.getEnableGrouping()){return;}var b=E.prototype.getBinding.call(t,"rows");var g=sap.ui.getCore().byId(t.getGroupBy());var I=g&&g.getGrouped()&&T.TableUtils.isA(b,"sap.ui.model.ClientListBinding");if(!I||b._modified){return;}b._modified=true;T.setGroupMode(t);var p=g.getSortProperty();b.sort(new S(p));var L=t._getTotalRowCount(),c=b.getContexts(0,L);var k;var C=0;for(var i=L-1;i>=0;i--){var n=c[i].getProperty(p);if(!k){k=n;}if(k!==n){var G=c[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);G.__groupInfo={oContext:c[i+1],name:k,count:C,groupHeader:true,expanded:true};c.splice(i+1,0,G);k=n;C=0;}C++;}var G=c[0].getModel().getContext("/sap.ui.table.GroupInfo");G.__groupInfo={oContext:c[0],name:k,count:C,groupHeader:true,expanded:true};c.splice(0,0,G);q.extend(b,{getLength:function(){return c.length;},getContexts:function(s,L){return c.slice(s,s+L);},isGroupHeader:function(a){var o=c[a];return(o&&o.__groupInfo&&o.__groupInfo.groupHeader)===true;},getTitle:function(a){var o=c[a];return o&&o.__groupInfo&&o.__groupInfo.name+" - "+o.__groupInfo.count;},isExpanded:function(a){var o=c[a];return this.isGroupHeader(a)&&o.__groupInfo&&o.__groupInfo.expanded;},expand:function(a){if(this.isGroupHeader(a)&&!c[a].__groupInfo.expanded){for(var i=0;i<c[a].__childs.length;i++){c.splice(a+1+i,0,c[a].__childs[i]);}delete c[a].__childs;c[a].__groupInfo.expanded=true;this._fireChange();}},collapse:function(a){if(this.isGroupHeader(a)&&c[a].__groupInfo.expanded){c[a].__childs=c.splice(a+1,c[a].__groupInfo.count);c[a].__groupInfo.expanded=false;this._fireChange();}},toggleIndex:function(a){if(this.isExpanded(a)){this.collapse(a);}else{this.expand(a);}},nodeHasChildren:function(o){if(!o||!o.__groupInfo){return false;}else{return o.__groupInfo.groupHeader===true;}},getNodeByIndex:function(a){return c[a];}});t._mTimeouts.groupingFireBindingChange=t._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){b._fireChange();},0);},resetExperimentalGrouping:function(t){var b=t.getBinding("rows");if(b&&b._modified){T.clearMode(t);var B=t.getBindingInfo("rows");t.unbindRows();t.bindRows(B);}}};return T;},true);
sap.ui.predefine('sap/ui/table/TableKeyboardDelegate2',["sap/ui/base/Object","sap/ui/Device","./library","./TableUtils","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(B,D,l,T,K,q){"use strict";var C=T.CELLTYPE;var S=l.SelectionMode;var M={CTRL:1,SHIFT:2,ALT:4};var N={LEFT:"Left",RIGHT:"Right",UP:"Up",DOWN:"Down"};var H=5;var a="1rem";
function p(e,P){e.setMarked("sapUiTableSkipItemNavigation",P!==false);}
var b=B.extend("sap.ui.table.TableKeyboardDelegate2",{
constructor:function(t){B.call(this);},
destroy:function(){B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
b._restoreFocusOnLastFocusedDataCell=function(t,e){var c=T.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();T.focusItem(t,c.cellInRow+(c.columnCount*L.row),e);};
b._setFocusOnColumnHeaderOfLastFocusedDataCell=function(t,e){var c=T.getFocusedItemInfo(t);T.focusItem(t,c.cellInRow,e);};
b._forwardFocusToTabDummy=function(t,s){t._getKeyboardExtension()._setSilentFocus(t.$().find("."+s));};
b._isKeyCombination=function(e,k,m){if(m==null){m=0;}var c=typeof k==="string"?String.fromCharCode(e.charCode):e.keyCode;var d=0;d|=(D.os.macintosh?e.metaKey:e.ctrlKey)&&k!==K.CONTROL?M.CTRL:0;d|=e.shiftKey&&k!==K.SHIFT?M.SHIFT:0;d|=e.altKey&&k!==K.ALT?M.ALT:0;var v=k==null||c===k;var V=m===d;return v&&V;};
b._handleSpaceAndEnter=function(t,e){var c=T.getCellInfo(e.target);if(c.isOfType(C.COLUMNROWHEADER)){t._toggleSelectAll();}else if(b._isElementGroupToggler(t,e.target)){T.Grouping.toggleGroupHeaderByRef(t,e.target);}else if(c.isOfType(C.ROWHEADER)){s();}else if(c.isOfType(C.DATACELL|C.ROWACTION)){var E=!t.hasListeners("cellClick");if(!t._findAndfireCellEvent(t.fireCellClick,e)){if(T.isRowSelectionAllowed(t)){s();E=false;}}if(E){var i=T.getInteractiveElements(e.target);if(i){t._getKeyboardExtension().setActionMode(true);}}}function s(){var _=null;if(t._legacyMultiSelection){_=function(r){t._legacyMultiSelection(r,e);return true;};}T.toggleRowSelection(t,e.target,null,_);}};
b._moveColumn=function(c,n){var t=c.getParent();var v=t._getVisibleColumns();var i=v.indexOf(c);var d;if(n&&i<v.length-1){d=t.indexOfColumn(v[i+1])+1;}else if(!n&&i>0){d=t.indexOfColumn(v[i-1]);}if(d!=null){T.Column.moveColumnTo(c,d);}};
b._getVisibleAndGroupedColumns=function(t){return t.getColumns().filter(function(c){return c.getVisible()||c.getGrouped();});};
b._getColumnIndexInVisibleAndGroupedColumns=function(t,c){var v=b._getVisibleAndGroupedColumns(t);for(var i=0;i<v.length;i++){var V=v[i];if(V===c){return i;}}return-1;};
b._focusElement=function(t,e,s){if(!t||!e){return;}if(s==null){s=false;}function h(e){return e instanceof window.HTMLInputElement&&/^(text|password|search|tel|url)$/.test(e.type);}if(h(document.activeElement)){document.activeElement.setSelectionRange(0,0);}if(s){t._getKeyboardExtension()._setSilentFocus(e);}else{e.focus();}if(h(e)){e.select();}};
b._focusCell=function(t,c,r,i,f){if(!t||c==null||r==null||r<0||r>=t.getRows().length){return;}var R=t.getRows()[r];var o;if(c===C.ROWHEADER){t._getKeyboardExtension()._setFocus(t.getDomRef("rowsel"+r));return;}else if(c===C.ROWACTION){o=t.getDomRef("rowact"+r);}else if(c===C.DATACELL&&(i!=null&&i>=0)){var d=t.getColumns()[i];var e=b._getColumnIndexInVisibleAndGroupedColumns(t,d);if(e>=0&&e<T.getVisibleColumnCount(t)){o=R.getDomRef("col"+e);}}if(!o){return;}if(f){var I=T.getInteractiveElements(o);if(I){b._focusElement(t,I[0]);return;}}o.focus();};
b._navigate=function(t,e,d){if(e.isMarked()){return;}var k=t._getKeyboardExtension();var A=k.isInActionMode();var c=T.getCellInfo(T.getCell(t,e.target));var s=false;if((d===N.UP||d===N.DOWN)&&c.isOfType(C.ANYCONTENTCELL)){var f=b._isKeyCombination(e,null,M.CTRL);var g=f||A;var P=T.getParentCell(t,e.target);var h=A&&c.isOfType(C.DATACELL);if(!f&&(e.target instanceof window.HTMLInputElement||e.target instanceof window.HTMLTextAreaElement)){return;}if(!g&&P){P.focus();return;}p(e);if(d===N.UP){if(T.isFirstScrollableRow(t,c.cell)){s=t._getScrollExtension().scrollVertically(false,false,true,h,function(){if(h){document.activeElement.blur();}});}}else if(T.isLastScrollableRow(t,c.cell)){s=t._getScrollExtension().scrollVertically(true,false,true,h,function(){if(h){document.activeElement.blur();}});}if(s){e.preventDefault();if(g){t.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){b._focusCell(t,c.type,c.rowIndex,c.columnIndex,true);},0);});}}else if(d===N.UP&&c.rowIndex===0){p(e,c.isOfType(C.ROWACTION)||g);if(!A&&P){P.focus();}else{k.setActionMode(false);}}else if(d===N.DOWN&&c.rowIndex===t.getVisibleRowCount()-1){if(!A&&P){P.focus();}else{k.setActionMode(false);}}else{var i=d===N.DOWN?1:-1;b._focusCell(t,c.type,c.rowIndex+i,c.columnIndex,g);e.preventDefault();}}else if(d===N.DOWN&&c.isOfType(C.ANYCOLUMNHEADER)){var j=T.getHeaderRowCount(t);if(T.isNoDataVisible(t)){var F=T.getFocusedItemInfo(t);if(F.row-j<=1){p(e);}}else if(c.isOfType(C.COLUMNROWHEADER)&&j>1){p(e);T.focusItem(t,j*(T.getVisibleColumnCount(t)+1),e);}}else if(d===N.LEFT&&!A){var I=sap.ui.getCore().getConfiguration().getRTL();if(c.isOfType(C.COLUMNHEADER)&&I){var o=T.getFocusedItemInfo(t);var m=o.cellInRow-(T.hasRowHeader(t)?1:0);var n=T.getVisibleColumnCount(t);if(T.hasRowActions(t)&&m===n-1){p(e);}}}};
b._isElementGroupToggler=function(t,e){return T.Grouping.isInGroupingRow(e)||(T.Grouping.isTreeMode(t)&&e.classList.contains("sapUiTableCellFirst")&&(e.querySelector(".sapUiTableTreeIconNodeOpen")||e.querySelector(".sapUiTableTreeIconNodeClosed")))||e.classList.contains("sapUiTableTreeIconNodeOpen")||e.classList.contains("sapUiTableTreeIconNodeClosed");};
b._isElementInteractive=function(e){if(!e){return false;}return q(e).is(T.INTERACTIVE_ELEMENT_SELECTORS);};
b._getFirstInteractiveElement=function(r){if(!r){return null;}var t=r.getParent();var c=r.getCells();var $;var I;if(T.hasRowActions(t)){c.push(r.getRowAction());}for(var i=0;i<c.length;i++){$=T.getParentCell(t,c[i].getDomRef());I=T.getInteractiveElements($);if(I){return I.first();}}return null;};
b._getLastInteractiveElement=function(r){if(!r){return null;}var t=r.getParent();var c=r.getCells();var $;var I;if(T.hasRowActions(t)){c.push(r.getRowAction());}for(var i=c.length-1;i>=0;i--){$=T.getParentCell(t,c[i].getDomRef());I=T.getInteractiveElements($);if(I){return I.last();}}return null;};
b._getPreviousInteractiveElement=function(t,e){if(!t||!e){return null;}var E=q(e);if(!this._isElementInteractive(E)){return null;}var c=T.getParentCell(t,e);var I;var o;var d;var f;var g;var h;var j;I=T.getInteractiveElements(c);if(I[0]!==E[0]){return I.eq(I.index(e)-1);}o=T.getCellInfo(c);f=t.getRows()[o.rowIndex].getCells();if(o.isOfType(C.ROWACTION)){j=f.length-1;}else{g=t.getColumns()[o.columnIndex];h=b._getColumnIndexInVisibleAndGroupedColumns(t,g);j=h-1;}for(var i=j;i>=0;i--){d=f[i].getDomRef();c=T.getParentCell(t,d);I=T.getInteractiveElements(c);if(I){return I.last();}}return null;};
b._getNextInteractiveElement=function(t,e){if(!t||!e){return null;}var E=q(e);if(!this._isElementInteractive(E)){return null;}var c=T.getParentCell(t,e);var I;var o;var d;var f;var g;var r;var h;I=T.getInteractiveElements(c);if(I.get(-1)!==E[0]){return I.eq(I.index(e)+1);}o=T.getCellInfo(c);if(o.isOfType(C.ROWACTION)){return null;}r=t.getRows()[o.rowIndex];f=r.getCells();g=t.getColumns()[o.columnIndex];h=b._getColumnIndexInVisibleAndGroupedColumns(t,g);for(var i=h+1;i<f.length;i++){d=f[i].getDomRef();c=T.getParentCell(t,d);I=T.getInteractiveElements(c);if(I){return I.first();}}if(T.hasRowActions(t)){c=T.getParentCell(t,r.getRowAction().getDomRef());I=T.getInteractiveElements(c);if(I.get(-1)!==E[0]){return I.eq(I.index(e)+1);}}return null;};
b.prototype.enterActionMode=function(){var k=this._getKeyboardExtension();var A=document.activeElement;var i=T.getInteractiveElements(A);var c=T.getParentCell(this,A);if(i){k._suspendItemNavigation();A.tabIndex=-1;b._focusElement(this,i[0],true);return true;}else if(c){this._getKeyboardExtension()._suspendItemNavigation();return true;}return false;};
b.prototype.leaveActionMode=function(A){A=A==null?true:A;var k=this._getKeyboardExtension();var o=document.activeElement;var c=T.getParentCell(this,o);k._resumeItemNavigation();if(A){if(c){b._focusElement(this,c[0],true);}else{k._setSilentFocus(o);}}};
b.prototype.onfocusin=function(e){if(e.isMarked("sapUiTableIgnoreFocusIn")){return;}var t=q(e.target);if(t.hasClass("sapUiTableOuterBefore")||t.hasClass("sapUiTableOuterAfter")||(e.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this.$("overlay").focus();}else if(t.hasClass("sapUiTableCtrlBefore")){var n=T.isNoDataVisible(this);if(!n||n&&this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);}else{this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}}else if(t.hasClass("sapUiTableCtrlAfter")){if(!T.isNoDataVisible(this)){b._restoreFocusOnLastFocusedDataCell(this,e);}}var c=T.getParentCell(this,t);var E=c!==null;var i=E&&b._isElementInteractive(t);if(this._getKeyboardExtension().isInActionMode()){var o=T.getCellInfo(e.target);var d=o.cell!=null;var I=o.isOfType(C.ROWHEADER)&&T.Grouping.isInGroupingRow(e.target);var f=o.isOfType(C.ROWHEADER)&&!I&&T.isRowSelectorSelectionAllowed(this);if(d&&!I&&!f){this._getKeyboardExtension().setActionMode(false);}else if(E&&!i){this._getKeyboardExtension().setActionMode(false,false);}}else if(i){this._getKeyboardExtension().setActionMode(true);}};
b.prototype.onkeydown=function(e){var k=this._getKeyboardExtension();if(b._isKeyCombination(e,K.F2)){var i=k.isInActionMode();var P=T.getParentCell(this,e.target);if(!i&&P){P.focus();}else{k.setActionMode(!i);}return;}else if(b._isKeyCombination(e,K.F4)&&b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target);return;}if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,K.SPACE)&&T.getCellInfo(e.target).type){e.preventDefault();}var t=q(e.target);var c=T.getCellInfo(t);var s=this.getSelectionMode();if(b._isKeyCombination(e,K.SHIFT)&&s===S.MultiToggle&&(c.isOfType(C.ROWHEADER)&&T.isRowSelectorSelectionAllowed(this)||(c.isOfType(C.DATACELL|C.ROWACTION))&&T.isRowSelectionAllowed(this))){var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();this._oRangeSelection={startIndex:d,selected:this.isIndexSelected(d)};}else if(b._isKeyCombination(e,K.A,M.CTRL)){e.preventDefault();if(c.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)&&s===S.MultiToggle){this._toggleSelectAll();}}else if(b._isKeyCombination(e,K.A,M.CTRL+M.SHIFT)){if(c.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)){this.clearSelection();}}else if(b._isKeyCombination(e,K.F4)){if(c.isOfType(C.DATACELL)){k.setActionMode(true);}}else if(b._isKeyCombination(e,K.F10,M.SHIFT)){e.preventDefault();T.Menu.openContextMenu(this,e.target,true,null,e);}};
b.prototype.onkeypress=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target);if(b._isKeyCombination(e,"+")){if(b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target,true);}else if(c.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}else if(b._isKeyCombination(e,"-")){if(b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target,false);}else if(c.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}};
b.prototype.oncontextmenu=function(e){if(e.isMarked("handledByPointerExtension")){return;}e.preventDefault();var c=T.getCell(this,e.target);var o=T.getCellInfo(c);if(o.isOfType(C.COLUMNHEADER|C.ANYCONTENTCELL)){T.Menu.openContextMenu(this,e.target,true,null,e);}};
b.prototype.onkeyup=function(e){var c=T.getCellInfo(e.target);if(b._isKeyCombination(e,K.SHIFT)){delete this._oRangeSelection;}if(c.isOfType(C.COLUMNHEADER)){if(b._isKeyCombination(e,K.SPACE)||b._isKeyCombination(e,K.ENTER)){T.Menu.openContextMenu(this,e.target,true);}}else if(b._isKeyCombination(e,K.SPACE)){b._handleSpaceAndEnter(this,e);}else if(this._legacyMultiSelection&&!c.isOfType(C.COLUMNROWHEADER)&&(b._isKeyCombination(e,K.SPACE,M.CTRL)||b._isKeyCombination(e,K.ENTER,M.CTRL))){b._handleSpaceAndEnter(this,e);}};
b.prototype.onsaptabnext=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target);var $;if(k.isInActionMode()){var i;$=T.getCell(this,e.target);c=T.getCellInfo($);if(!$){return;}var r=this.getRows()[c.rowIndex];var L=b._getLastInteractiveElement(r);var I=L===null||L[0]===e.target;if(I){var A=r.getIndex();var d=T.isLastScrollableRow(this,$);var f=this._getTotalRowCount()-1===A;var t=T.isRowSelectorSelectionAllowed(this);var s=false;if(!f&&d){var g=c.isOfType(C.DATACELL);s=this._getScrollExtension().scrollVertically(true,false,true,g,function(){if(g){document.activeElement.blur();}});}if(f){e.preventDefault();k.setActionMode(false);}else if(s){e.preventDefault();this.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var j=T.Grouping.isGroupingRow(r.getDomRef());if(t||j){b._focusCell(this,C.ROWHEADER,c.rowIndex);}else{i=b._getFirstInteractiveElement(r);b._focusElement(this,i[0]);}}.bind(this),0);}.bind(this));}else{e.preventDefault();var n=c.rowIndex+1;var o=this.getRows()[n];var h=T.Grouping.isGroupingRow(o.getDomRef());if(t||h){b._focusCell(this,C.ROWHEADER,n);}else{i=b._getFirstInteractiveElement(o);b._focusElement(this,i[0]);}}}else if(c.isOfType(C.ROWHEADER)){e.preventDefault();i=b._getFirstInteractiveElement(r);b._focusElement(this,i[0]);}else{e.preventDefault();i=b._getNextInteractiveElement(this,e.target);b._focusElement(this,i[0]);}}else if(c.isOfType(C.ANYCOLUMNHEADER)){if(T.isNoDataVisible(this)){this.$("noDataCnt").focus();}else{b._restoreFocusOnLastFocusedDataCell(this,e);}e.preventDefault();}else if(c.isOfType(C.ANYCONTENTCELL)){b._forwardFocusToTabDummy(this,"sapUiTableCtrlAfter");}else if(e.target===this.getDomRef("overlay")){k._setSilentFocus(this.$().find(".sapUiTableOuterAfter"));}else if(!c.cell){$=T.getParentCell(this,e.target);if($){e.preventDefault();$.focus();}}};
b.prototype.onsaptabprevious=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target);var $;if(k.isInActionMode()){var i;$=T.getCell(this,e.target);c=T.getCellInfo($);if(!$){return;}var r=this.getRows()[c.rowIndex];var A=r.getIndex();var f=b._getFirstInteractiveElement(r);var I=f!==null&&f[0]===e.target;var t=T.isRowSelectorSelectionAllowed(this);var R=T.Grouping.isGroupingRow(r);var d=t||R;if(I&&d){e.preventDefault();b._focusCell(this,C.ROWHEADER,c.rowIndex);}else if((I&&!d)||c.isOfType(C.ROWHEADER)){var g=T.isFirstScrollableRow(this,$);var h=A===0;var s=false;if(!h&&g){var j=c.isOfType(C.DATACELL);s=this._getScrollExtension().scrollVertically(false,false,true,j,function(){if(j){document.activeElement.blur();}});}if(h){e.preventDefault();k.setActionMode(false);}else if(s){e.preventDefault();this.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var n=T.Grouping.isGroupingRow(r.getDomRef());if(n){b._focusCell(this,C.ROWHEADER,c.rowIndex);}else{i=b._getLastInteractiveElement(r);b._focusElement(this,i[0]);}}.bind(this),0);}.bind(this));}else{e.preventDefault();var P=c.rowIndex-1;var o=this.getRows()[P];var m=T.Grouping.isGroupingRow(o.getDomRef());if(m){b._focusCell(this,C.ROWHEADER,P);}else{i=b._getLastInteractiveElement(o);b._focusElement(this,i[0]);}}}else{e.preventDefault();i=b._getPreviousInteractiveElement(this,e.target);b._focusElement(this,i[0]);}}else if(c.isOfType(C.ANYCONTENTCELL)||e.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()&&!c.isOfType(C.ROWACTION)){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);e.preventDefault();}else{b._forwardFocusToTabDummy(this,"sapUiTableCtrlBefore");}}else if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus(this.$().find(".sapUiTableOuterBefore"));}else if(!c.cell){$=T.getParentCell(this,e.target);if($){e.preventDefault();$.focus();}}};
b.prototype.onsapdown=function(e){b._navigate(this,e,N.DOWN);};
b.prototype.onsapdownmodifiers=function(e){if(b._isKeyCombination(e,null,M.CTRL)){b._navigate(this,e,N.DOWN);return;}var k=this._getKeyboardExtension();if(b._isKeyCombination(e,null,M.ALT)&&b._isElementGroupToggler(this,e.target)){p(e);T.Grouping.toggleGroupHeaderByRef(this,e.target,true);return;}if(k.isInActionMode()){return;}var c=T.getCellInfo(e.target);if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(e);return;}var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();if(d===this._getTotalRowCount()-1){return;}if(T.isLastScrollableRow(this,e.target)){var s=this._getScrollExtension().scrollVertically(true,false,true);if(s){p(e);}}if(this._oRangeSelection.startIndex<=d){d++;if(this._oRangeSelection.selected){T.toggleRowSelection(this,d,true);}else{T.toggleRowSelection(this,d,false);}}else{T.toggleRowSelection(this,d,false);}}else{p(e);}}if(b._isKeyCombination(e,null,M.ALT)){if(c.isOfType(C.DATACELL)){k.setActionMode(true);}p(e);}};
b.prototype.onsapup=function(e){b._navigate(this,e,N.UP);};
b.prototype.onsapupmodifiers=function(e){var k=this._getKeyboardExtension();if(b._isKeyCombination(e,null,M.CTRL)){b._navigate(this,e,N.UP);return;}if(b._isKeyCombination(e,null,M.ALT)&&b._isElementGroupToggler(this,e.target)){p(e);T.Grouping.toggleGroupHeaderByRef(this,e.target,false);return;}if(k.isInActionMode()){return;}var c=T.getCellInfo(e.target);if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(e);return;}var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();if(d===0){p(e);return;}if(T.isFirstScrollableRow(this,e.target)){var s=this._getScrollExtension().scrollVertically(false,false,true);if(s){p(e);}}if(this._oRangeSelection.startIndex>=d){d--;if(this._oRangeSelection.selected){T.toggleRowSelection(this,d,true);}else{T.toggleRowSelection(this,d,false);}}else{T.toggleRowSelection(this,d,false);}}else{p(e);}}if(b._isKeyCombination(e,null,M.ALT)){if(c.isOfType(C.DATACELL)){k.setActionMode(true);}p(e);}};
b.prototype.onsapleft=function(e){b._navigate(this,e,N.LEFT);};
b.prototype.onsapleftmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target);var I=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(e);return;}var f=T.getFocusedItemInfo(this);var F=T.hasRowHeader(this)&&f.cellInRow===1;if(F&&!T.isRowSelectorSelectionAllowed(this)){p(e);}}else if(c.isOfType(C.ROWACTION)){if(!this._oRangeSelection){p(e);}}else if(c.isOfType(C.ROWHEADER)&&I){if(!T.isRowSelectionAllowed(this)){p(e);}}else if(c.isOfType(C.COLUMNROWHEADER)&&I){p(e);}else if(c.isOfType(C.COLUMNHEADER)){var r=-T.convertCSSSizeToPixel(a);var d=0;if(I){r=r*-1;}for(var i=c.columnIndex;i<c.columnIndex+c.columnSpan;i++){d+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,c.columnIndex,d+r,true,c.columnSpan);p(e);}}else if(b._isKeyCombination(e,null,M.CTRL)){if(c.isOfType(C.COLUMNHEADER)){e.preventDefault();e.stopImmediatePropagation();var o=this.getColumns()[c.columnIndex];b._moveColumn(o,I);}}};
b.prototype.onsaprightmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target);var I=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(e);}}else if(c.isOfType(C.ROWHEADER)){if(!T.isRowSelectionAllowed(this)){p(e);}}else if(c.isOfType(C.ROWACTION)&&I){if(!this._oRangeSelection){p(e);}}else if(c.isOfType(C.COLUMNHEADER)){var r=T.convertCSSSizeToPixel(a);var d=0;if(I){r=r*-1;}for(var i=c.columnIndex;i<c.columnIndex+c.columnSpan;i++){d+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,c.columnIndex,d+r,true,c.columnSpan);p(e);}else if(c.isOfType(C.COLUMNROWHEADER)){p(e);}}else if(b._isKeyCombination(e,null,M.CTRL)){if(c.isOfType(C.COLUMNHEADER)){e.preventDefault();e.stopImmediatePropagation();var o=this.getColumns()[c.columnIndex];b._moveColumn(o,!I);}}};
b.prototype.onsaphome=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupingRow(e.target)){p(e);e.preventDefault();return;}var c=T.getCellInfo(e.target);if(c.isOfType(C.ANY)){e.preventDefault();}if(c.isOfType(C.DATACELL|C.ROWACTION|C.COLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var d=this.getComputedFixedColumnCount();var h=T.hasRowHeader(this);var r=h?1:0;if(T.hasFixedColumns(this)&&i>d+r){p(e);T.focusItem(this,F-i+d+r,null);}else if(h&&i>1){p(e);T.focusItem(this,F-i+r,null);}}};
b.prototype.onsapend=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupingRow(e.target)){e.preventDefault();p(e);return;}var c=T.getCellInfo(e.target);if(c.isOfType(C.ANY)){e.preventDefault();var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.columnCount;var d=this.getComputedFixedColumnCount();var g=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var I=false;if(c.isOfType(C.COLUMNHEADER)&&T.hasFixedColumns(this)){var j=parseInt(c.cell.attr("colspan")||1);if(j>1&&g+j-r===d){I=true;}}if(h&&g===0){p(e);T.focusItem(this,F+1,null);}else if(T.hasFixedColumns(this)&&g<d-1+r&&!I){p(e);T.focusItem(this,F+d-g,null);}else if(T.hasRowActions(this)&&c.isOfType(C.DATACELL)&&g<i-2){p(e);T.focusItem(this,F-g+i-2,null);}}};
b.prototype.onsaphomemodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.CTRL)){e.preventDefault();var c=T.getCellInfo(e.target);if(c.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){p(e);var f=T.getFocusedItemInfo(this);var F=f.row;if(F>0){var i=f.cell;var d=f.columnCount;var h=T.getHeaderRowCount(this);var g=this.getFixedRowCount();var j=this.getFixedBottomRowCount();if(F<h+g){if(c.isOfType(C.ROWACTION)){T.focusItem(this,i-d*(F-h),e);}else{T.focusItem(this,i-d*F,e);}}else if(F>=h+g&&F<h+T.getNonEmptyVisibleRowCount(this)-j){this._getScrollExtension().scrollVerticallyMax(false,true);if(g>0||c.isOfType(C.ROWACTION)){T.focusItem(this,i-d*(F-h),e);}else{T.focusItem(this,i-d*F,e);}}else{this._getScrollExtension().scrollVerticallyMax(false,true);T.focusItem(this,i-d*(F-h-g),e);}}}}};
b.prototype.onsapendmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.CTRL)){e.preventDefault();var c=T.getCellInfo(e.target);if(c.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var i=this.getFixedRowCount();var d=this.getFixedBottomRowCount();p(e);if(d===0||F<h+n-1||(T.isNoDataVisible(this)&&F<h-1)){var g=f.cell;var j=f.columnCount;if(T.isNoDataVisible(this)){T.focusItem(this,g+j*(h-F-1),e);}else if(F<h){if(i>0){T.focusItem(this,g+j*(h+i-F-1),e);}else{this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,g+j*(h+n-d-F-1),e);}}else if(F>=h&&F<h+i){this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,g+j*(h+n-d-F-1),e);}else if(F>=h+i&&F<h+n-d){this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,g+j*(h+n-F-1),e);}else{T.focusItem(this,g+j*(h+n-F-1),e);}}}}};
b.prototype.onsappageup=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}e.preventDefault();var c=T.getCellInfo(e.target);if(c.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var i=this.getFixedRowCount();var d=this.getFixedBottomRowCount();if(i===0&&F>=h||i>0&&F>h){p(e);var g=f.cell;var j=f.columnCount;if(F<h+i){T.focusItem(this,g-j*(F-h),e);}else if(F===h+i){var P=T.getNonEmptyVisibleRowCount(this)-i-d;var r=this.getFirstVisibleRow();this._getScrollExtension().scrollVertically(false,true,true);if(r<P){if(i>0||c.isOfType(C.ROWACTION)){T.focusItem(this,g-j*(F-h),e);}else{T.focusItem(this,g-j*h,e);}}}else if(F>h+i&&F<h+T.getNonEmptyVisibleRowCount(this)){T.focusItem(this,g-j*(F-h-i),e);}else{T.focusItem(this,g-j*(F-h-T.getNonEmptyVisibleRowCount(this)+1),e);}}if(c.isOfType(C.ROWACTION)&&F===h&&i>0){p(e);}}};
b.prototype.onsappagedown=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}e.preventDefault();var c=T.getCellInfo(e.target);if(c.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var i=this.getFixedRowCount();var d=this.getFixedBottomRowCount();p(e);if((T.isNoDataVisible(this)&&F<h-1)||d===0||F<h+n-1){var g=f.cell;var j=f.columnCount;if(F<h-1&&!c.isOfType(C.COLUMNROWHEADER)){T.focusItem(this,g+j*(h-F-1),e);}else if(F<h){if(!T.isNoDataVisible(this)){T.focusItem(this,g+j*(h-F),e);}}else if(F>=h&&F<h+n-d-1){T.focusItem(this,g+j*(h+n-d-F-1),e);}else if(F===h+n-d-1){var P=T.getNonEmptyVisibleRowCount(this)-i-d;var r=this._getTotalRowCount()-d-this.getFirstVisibleRow()-P*2;this._getScrollExtension().scrollVertically(true,true,true);if(r<P&&d>0){T.focusItem(this,g+j*(h+n-F-1),e);}}else{T.focusItem(this,g+j*(h+n-F-1),e);}}}};
b.prototype.onsappageupmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.ALT)){var c=T.getCellInfo(e.target);var f=T.getFocusedItemInfo(this);if(c.isOfType(C.DATACELL|C.COLUMNHEADER)){var F=f.cell;var i=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var P=H;p(e);if(h&&(T.Grouping.isInGroupingRow(e.target)||i===1)){T.focusItem(this,F-i,null);}else if(i-r<P){T.focusItem(this,F-i+r,null);}else{T.focusItem(this,F-P,null);}}else if(c.isOfType(C.ROWACTION)){T.focusItem(this,f.cell-1,null);}}};
b.prototype.onsappagedownmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.ALT)){var c=T.getCellInfo(e.target);if(c.isOfType(C.DATACELL|C.ROWHEADER|C.ANYCOLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var v=T.getVisibleColumnCount(this);var i=parseInt(c.cell.attr("colspan")||1);p(e);if(F+i-r<v){var d=f.cell;var P=H;if(h&&F===0){T.focusItem(this,d+1,null);}else if(i>P){T.focusItem(this,d+i,null);}else if(F+i-r+P>v){T.focusItem(this,d+v-F-1+r,null);}else if(!T.Grouping.isInGroupingRow(e.target)){T.focusItem(this,d+P,null);}}else if(c.isOfType(C.DATACELL)&&T.hasRowActions(this)&&F===f.columnCount-2){T.focusItem(this,f.cell+1,null);}}}};
b.prototype.onsapenter=function(e){b._handleSpaceAndEnter(this,e);};
return b;});
sap.ui.predefine('sap/ui/table/TableKeyboardExtension',["./TableExtension","sap/ui/core/delegate/ItemNavigation","./TableUtils","./TableKeyboardDelegate2","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(T,I,a,b,D,c,q){"use strict";var d=false;
function e(o){if(D.browser.msie){if(!d){q("head").append("<style type=\"text/css\">"+"/* Avoid focus outline problems in tables */\n"+".sapUiTableStatic[data-sap-ui-table-focus]{}"+"</style>");d=true;}var C=a.getCellInfo(o)||{};if(C.cell){C.cell.attr("data-sap-ui-table-focus",Date.now());}}}
var f={_forward:function(t,o){var i=t._getItemNavigation();if(i!=null&&!t._getKeyboardExtension()._isItemNavigationSuspended()&&!o.isMarked("sapUiTableSkipItemNavigation")){i["on"+o.type](o);}},onfocusin:function(o){f._forward(this,o);e(o.target);},onsapfocusleave:function(o){f._forward(this,o);},onmousedown:function(o){f._forward(this,o);},onsapnext:function(o){f._forward(this,o);},onsapnextmodifiers:function(o){f._forward(this,o);},onsapprevious:function(o){f._forward(this,o);},onsappreviousmodifiers:function(o){f._forward(this,o);},onsappageup:function(o){f._forward(this,o);},onsappagedown:function(o){f._forward(this,o);},onsaphome:function(o){f._forward(this,o);},onsaphomemodifiers:function(o){f._forward(this,o);},onsapend:function(o){f._forward(this,o);},onsapendmodifiers:function(o){f._forward(this,o);},onsapkeyup:function(o){f._forward(this,o);}};var E={onfocusin:function(o){var i=this._getKeyboardExtension();if(!i._bIgnoreFocusIn){i.initItemNavigation();if(g.isItemNavigationInvalid(this)){o.setMarked("sapUiTableInitItemNavigation");}}else{o.setMarked("sapUiTableIgnoreFocusIn");}if(o.target&&o.target.id===this.getId()+"-rsz"){o.preventDefault();o.setMarked("sapUiTableSkipItemNavigation");}}};var g={_initItemNavigation:function(o){var t=o.getTable();var $=t.$();var C=a.getVisibleColumnCount(t);var j=C;var H=a.hasRowHeader(t);var k=a.hasRowActions(t);var l=a.hasFixedColumns(t);var m=[],r,R,n,p,s;if(l){n=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");p=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");s=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");}var u=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");var v=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");var w=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");if(H){r=$.find(".sapUiTableRowSelectionCell").get();j++;}if(k){R=$.find(".sapUiTableRowActionCell").get();j++;}for(var i=0;i<t.getVisibleRowCount();i++){if(H){m.push(r[i]);}if(l){m=m.concat(n.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}m=m.concat(u.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(l){m=m.concat(p.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}m=m.concat(v.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(l){m=m.concat(s.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}m=m.concat(w.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(k){m.push(R[i]);}}if(t.getColumnHeaderVisible()){var x=[];var F=$.find(".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr");var S=$.find(".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr");for(var i=0;i<a.getHeaderRowCount(t);i++){if(H){x.push(t.getDomRef("selall"));}if(F.length){x=x.concat(q(F.get(i)).find(".sapUiTableHeaderCell").get());}if(S.length){x=x.concat(q(S.get(i)).find(".sapUiTableHeaderCell").get());}if(k){x.push($.find(".sapUiTableRowActionHeaderCell").children().get(0));}}m=x.concat(m);}if(!o._itemNavigation){o._itemNavigation=new I();o._itemNavigation.setTableMode(true);o._itemNavigation.attachEvent(I.Events.AfterFocus,function(y){var z=a.getFocusedItemInfo(t);z.header=a.getHeaderRowCount(t);z.domRef=null;if(z.row>=z.header){o._oLastFocusedCellInfo=z;}},t);}o._itemNavigation.setColumns(j);o._itemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));o._itemNavigation.setItemDomRefs(m);o._itemNavigation.setFocusedIndex(g.getInitialItemNavigationIndex(o));o._itemNavigationInvalidated=false;},getInitialItemNavigationIndex:function(o){return a.hasRowHeader(o.getTable())?1:0;},isItemNavigationInvalid:function(o){return!o._itemNavigation||o._itemNavigationInvalidated;}};
var h=T.extend("sap.ui.table.TableKeyboardExtension",{
_init:function(t,s,S){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._delegate=new b(s);this._actionMode=false;t.addEventDelegate(E,t);t.addEventDelegate(this._delegate,t);t.addEventDelegate(f,t);t._getItemNavigation=function(){return this._itemNavigation;}.bind(this);return"KeyboardExtension";},
_debug:function(){this._ExtensionHelper=g;this._ItemNavigationDelegate=f;this._ExtensionDelegate=E;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(E);t.removeEventDelegate(this._delegate);t.removeEventDelegate(f);}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}if(this._delegate){this._delegate.destroy();this._delegate=null;}T.prototype.destroy.apply(this,arguments);}
});
h.prototype.initItemNavigation=function(){if(g.isItemNavigationInvalid(this)){g._initItemNavigation(this);}};
h.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true;};
h.prototype.setActionMode=function(i){if(i===true&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=this._delegate.enterActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1))===true;}else if(i===false&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1));}};
h.prototype.isInActionMode=function(){return this._actionMode;};
h.prototype.updateNoDataAndOverlayFocus=function(p){var t=this.getTable();if(!t||!t.getDomRef()){return;}if(t.getShowOverlay()){if(c(t.getDomRef(),p)){t.$("overlay").focus();}}else if(a.isNoDataVisible(t)){if(c(t.getDomRef("sapUiTableCnt"),p)){t.$("noDataCnt").focus();}}else if(c(t.getDomRef("noDataCnt"),p)||c(t.getDomRef("overlay"),p)){a.focusItem(t,g.getInitialItemNavigationIndex(this));}};
h.prototype._suspendItemNavigation=function(){this._itemNavigationSuspended=true;};
h.prototype._resumeItemNavigation=function(){this._itemNavigationSuspended=false;};
h.prototype._isItemNavigationSuspended=function(){return this._itemNavigationSuspended;};
h.prototype._getLastFocusedCellInfo=function(){var H=a.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=H){var i=a.getFocusedItemInfo(this.getTable());var j=g.getInitialItemNavigationIndex(this);return{cellInRow:j,row:H,header:H,cellCount:i.cellCount,columnCount:i.columnCount,cell:i.columnCount*H+j};}return this._oLastFocusedCellInfo;};
h.prototype._setSilentFocus=function(o){this._bIgnoreFocusIn=true;this._setFocus(o);this._bIgnoreFocusIn=false;};
h.prototype._setFocus=function(o){if(!o){return;}var t=this.getTable();var C=a.getCellInfo(o);if(C.cell&&t){var $=q(o);if($.attr("tabindex")!="0"){var j=t._getItemNavigation();if(j&&j.aItemDomRefs){for(var i=0;i<j.aItemDomRefs.length;i++){if(j.aItemDomRefs[i]){j.aItemDomRefs[i].setAttribute("tabindex","-1");}}}$.attr("tabindex","0");}}o.focus();};
h.prototype._getTableType=function(){return this._type;};
return h;});
sap.ui.predefine('sap/ui/table/TableMenuUtils',['sap/ui/Device','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/core/Popup',"sap/ui/thirdparty/jquery"],function(D,M,a,P,q){"use strict";P.setInitialZIndex(10);var b={TableUtils:null,openContextMenu:function(t,e,h,f,E){if(!t||!e){return;}if(f==null){f=true;}var T=q(e);var $=b.TableUtils.getCell(t,T);if(!$){return;}var c=b.TableUtils.getCellInfo($);var C=c.columnIndex;var r=c.rowIndex;var d;if(c.isOfType(b.TableUtils.CELLTYPE.COLUMNHEADER)){var g=$.find(".sapUiTableColDropDown").length>0;if(D.system.desktop||g){b.removeColumnHeaderCellMenu(t,C);d=true;if(f){d=t.fireColumnSelect({column:t.getColumns()[C]});}if(d){b.openColumnContextMenu(t,C,h,$);}}else{b.applyColumnHeaderCellMenu(t,C,$);}}else if(c.isOfType(b.TableUtils.CELLTYPE.ANYCONTENTCELL)){d=true;if(f){var R=b.TableUtils.getRowColCell(t,r,C,C>=0);var o=R.row;var i;var j=t.getBindingInfo("rows");if(j){i=o.getBindingContext(j.model);}var k=t.getContextMenu();if(k){k.setBindingContext(i);}if(C>=0){d=t.fireCellContextmenu({rowIndex:o.getIndex(),columnIndex:C,columnId:R.column.getId(),cellControl:R.cell,rowBindingContext:i,cellDomRef:$[0]});}if(d){d=t.fireBeforeOpenContextMenu({rowIndex:o.getIndex(),columnIndex:R.column?C:null,contextMenu:k});}}if(d){b.openDataCellContextMenu(t,c,h,E);}}},openColumnContextMenu:function(t,c,h,C){if(!t||c==null||c<0){return;}if(h==null){h=false;}var o=t.getColumns();if(c>=o.length){return;}var d=o[c];if(!d.getVisible()){return;}for(var i=0;i<o.length;i++){if(o[i]!==d){b.closeColumnContextMenu(t,i);}}b.closeDataCellContextMenu(t);var e=C&&C.attr("colspan");if(e&&e!=="1"){return;}d._openMenu(C&&C[0]||d.getDomRef(),h);},closeColumnContextMenu:function(t,c){if(!t||c==null||c<0){return;}var C=t.getColumns();if(c>=C.length){return;}var o=C[c];o._closeMenu();},openDataCellContextMenu:function(t,c,h,e){if(!t||!c||!c.cell||c.rowIndex>=b.TableUtils.getNonEmptyVisibleRowCount(t)){return;}var C=c.columnIndex;var r=c.rowIndex;if(h==null){h=false;}var o=t.getColumns();if(C>=o.length){return;}var d=o[C];if(d&&!d.getVisible()){return;}var R=t.getRows()[r];if(b.hasContextMenu(t)){var $=R.$();var s=$.hasClass("sapUiAnalyticalTableSum");var g=$.hasClass("sapUiTableGroupHeader");if(!s&&!g){t.getContextMenu().openAsContextMenu(e,c.cell);}}else if(t.getEnableCellFilter()&&d&&d.isFilterableByMenu()){if(!t._oCellContextMenu){t._oCellContextMenu=new M(t.getId()+"-cellcontextmenu");var f=new a({text:b.TableUtils.getResourceText("TBL_FILTER")});f._onSelect=function(d,r){var n=this.getContextByIndex(r);var F=d.getFilterProperty();var p=n.getProperty(F);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:d,value:p});}else{this.filter(d,p);}};f.attachSelect(f._onSelect.bind(t,d,R.getIndex()));t._oCellContextMenu.addItem(f);t.addDependent(t._oCellContextMenu);}else{var m=t._oCellContextMenu.getItems()[0];m.mEventRegistry.select[0].fFunction=m._onSelect.bind(t,d,R.getIndex());}var j=R.getCells()[C];var k=b.TableUtils.getParentCell(t,j.getDomRef());if(k&&!b.TableUtils.Grouping.isInGroupingRow(k)){j=k[0];var l=t._oCellContextMenu.bOpen&&t._oCellContextMenu.oOpenerRef!==j;if(l){b.closeDataCellContextMenu(t);}for(var i=0;i<o.length;i++){b.closeColumnContextMenu(t,i);}t._oCellContextMenu.open(h,j,P.Dock.BeginTop,P.Dock.BeginBottom,j,"none none");}}},closeDataCellContextMenu:function(t){if(!t){return;}var m=t._oCellContextMenu;var c=m!=null&&m.bOpen;if(c){m.close();}},cleanupDataCellContextMenu:function(t){if(!t||!t._oCellContextMenu){return;}t._oCellContextMenu.destroy();t._oCellContextMenu=null;},applyColumnHeaderCellMenu:function(t,c,T){if(!t||c==null||c<0){return;}var C=t.getColumns();if(c>=C.length){return;}var d=T&&T.attr("colspan");if(d&&d!=="1"){return;}var o=C[c];if(o.getVisible()&&(o.getResizable()||o._menuHasItems())){var $=T||o.$();var e=$.find(".sapUiTableCellInner");var f=$.find(".sapUiTableCellTouchMenu").length>0;if(!f){b.removeColumnHeaderCellMenu(t);e.hide();var s="";if(o._menuHasItems()){s="<div class='sapUiTableColDropDown'></div>";}var g="";if(o.getResizable()){g="<div class='sapUiTableColResizer'></div>";}var h=q("<div class='sapUiTableCellTouchMenu'>"+s+g+"</div>");$.append(h);$.on("focusout",function(t,c){b.removeColumnHeaderCellMenu(t);this.off("focusout");}.bind($,t,c));}}},removeColumnHeaderCellMenu:function(t){var c=t&&t.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(c.length){c.parent().find(".sapUiTableCellInner").show();c.remove();}},hasContextMenu:function(t){return t&&t.getContextMenu();}};return b;},true);
sap.ui.predefine('sap/ui/table/TablePersoController',['sap/ui/base/ManagedObject',"sap/ui/core/syncStyleClass","sap/base/Log","sap/ui/thirdparty/jquery"],function(M,s,L,q){"use strict";
var T=M.extend("sap.ui.table.TablePersoController",{
constructor:function(i,S){M.apply(this,arguments);},
metadata:{properties:{"autoSave":{type:"boolean",defaultValue:true},"persoService":{type:"any"},"customDataKey":{type:"string",defaultValue:"persoKey"}},associations:{"table":{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}
});
T.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue");}};
T.prototype.exit=function(){var t=this._getTable();if(t){this._manageTableEventHandlers(t,false);}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;if(this._oDialog){this._oDialog.destroy();delete this._oDialog;}};
T.prototype.setPersoService=function(S){S=this.validateProperty("persoService",S);if(S&&(!q.isFunction(S.getPersData)||!q.isFunction(S.setPersData)||!q.isFunction(S.delPersData))){throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods "+"\"getPersData\", \"setPersData\" and \"delPersData\".");}var o=this.getPersoService();this.setProperty("persoService",S,true);var n=this.getPersoService();if(n&&n!==o&&this._getTable()&&(this.getAutoSave()||!o)){this.refresh();}return this;};
T.prototype.setAutoSave=function(a){var o=this.getAutoSave();this.setProperty("autoSave",a,true);var n=this.getAutoSave();if(n&&!o){this.savePersonalizations();}return this;};
T.prototype.setTable=function(t){var o=this._getTable();if(o){o._oPersoController=undefined;}this.setAssociation("table",t,true);var n=this._getTable();if(n){n._oPersoController=this;}if(o){this._manageTableEventHandlers(o,false);}if(n&&n!==o){this._oInitialPersoData=this._getCurrentTablePersoData(true);this._manageTableEventHandlers(n,true);if(this.getPersoService()&&(this.getAutoSave()||!o)){this.refresh();}}else if(!n){this._oInitialPersoData=null;}return this;};
T.prototype.setCustomDataKey=function(c){var o=this.getCustomDataKey();this.setProperty("customDataKey",c,true);var n=this.getCustomDataKey();if(o!==n&&this.getAutoSave()){this.savePersonalizations();}return this;};
T.prototype._manageTableEventHandlers=function(t,a){for(var i=0,l=this._aTableEvents.length;i<l;i++){var f=t[(a?"attachEvent":"detachEvent")];f.apply(t,[this._aTableEvents[i],this._tableEventHandler,this]);}};
T.prototype.refresh=function(){var t=this;var S=this.getPersoService();if(S){return S.getPersData().done(function(o){var D=(o&&Array.isArray(o.aColumns))?o:t._oInitialPersoData;t._adjustTable(D);}).fail(function(){L.error("Problem reading persisted personalization data.");});}else{L.error("The Personalization Service is not available!");var d=q.Deferred();d.reject();return d.promise();}};
T.prototype.savePersonalizations=function(){var S=this.getPersoService();if(S){var d=this._getCurrentTablePersoData();d[this._schemaProperty]=this._schemaVersion;return S.setPersData(d).fail(function(){L.error("Problem persisting personalization data.");});}else{L.error("The Personalization Service is not available!");var D=q.Deferred();D.reject();return D.promise();}};
T.prototype._adjustTable=function(d){var t=this._getTable();if(!t||!d||!Array.isArray(d.aColumns)){return;}var c={},C=t.getColumns();for(var i=0,l=C.length;i<l;i++){c[this._getColumnPersoKey(C[i])]=C[i];}var a=d.aColumns;for(var i=0,l=a.length;i<l;i++){var o=a[i];var b=c[o.id];if(b){if(t.indexOfColumn(b)!==o.order){t.removeColumn(b);t.insertColumn(b,o.order);}var m=b.getMetadata();for(var j=0,e=this._aColumnProperties.length;j<e;j++){var p=this._aColumnProperties[j];if(o[p]!==undefined){try{if(m.hasProperty(p)&&b.getProperty(p)!=o[p]){b.setProperty(p,o[p]);}}catch(f){L.error("sap.ui.table.TablePersoController: failed to apply the value \""+b[p]+"\" for the property + \""+p+"\".");}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied();}};
T.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null;},0);}};
T.prototype._getCurrentTablePersoData=function(f){var t=this._getTable(),c=t.getColumns();var d={aColumns:[]};for(var i=0,l=c.length;i<l;i++){var C=c[i];var p=this._getColumnPersoKey(C);var o={id:p,order:i};var m=C.getMetadata();for(var j=0,a=this._aColumnProperties.length;j<a;j++){var P=this._aColumnProperties[j];if(m.hasProperty(P)){o[P]=C.getProperty(P);}}if(f){o.text=C.getLabel()&&C.getLabel().getText()||p;}d.aColumns.push(o);}return d;};
T.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable());};
T.prototype._getColumnPersoKey=function(c){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(c);};
T.prototype._getPersoKey=function(c){var p=c.data(this.getCustomDataKey());if(!p){p=c.getId();if(p.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())===0){L.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \""+c.getId()+"\")");}}return p;};
T.prototype.openDialog=function(S){var t=this;function _(){if(t._oDialog){s("sapUiSizeCompact",t._getTable(),t._oDialog._oDialog);t._oDialog.open();}}if(!this._oDialog){sap.ui.getCore().loadLibrary("sap.m",{async:true}).then(function(){sap.ui.require(["sap/m/TablePersoDialog"],function(a){t._oDialog=new a(t._getTable().getId()+"-PersoDialog",{persoService:t.getPersoService(),showSelectAll:true,showResetAll:true,grouping:false,contentWidth:S&&S.contentWidth,contentHeight:S&&S.contentHeight||"20rem",initialColumnState:t._oInitialPersoData.aColumns,columnInfoCallback:function(o,p,P){return t._getCurrentTablePersoData(true).aColumns;},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations();}}});t._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding");_();});});}else{_();}};
return T;});
sap.ui.predefine('sap/ui/table/TablePointerExtension',["./library","./TableExtension","./TableUtils","sap/ui/Device","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/control"],function(l,T,a,D,P,L,q){"use strict";var S=l.SelectionMode;var K=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer","sapMBtnIcon"];var E={_getEventPosition:function(e,t){var p;function g(o){if(!t._isTouchEvent(o)){return null;}var f=["touches","targetTouches","changedTouches"];for(var i=0;i<f.length;i++){var s=f[i];if(e[s]&&e[s][0]){return e[s][0];}if(e.originalEvent[s]&&e.originalEvent[s][0]){return e.originalEvent[s][0];}}return null;}p=g(e)||e;return{x:p.pageX,y:p.pageY};},_skipClick:function(e,t,o){if(!o.isOfType(a.CELLTYPE.DATACELL|a.CELLTYPE.ROWACTION)){return false;}if(e.isMarked()){return true;}var f=t.control(0);if(f){var $=f.$();if($.length){for(var i=0;i<K.length;i++){if($.hasClass(K[i])){return typeof f.getEnabled==="function"?f.getEnabled():true;}}}}var h=false;if(window.getSelection){var s=window.getSelection();h=s.rangeCount?!s.getRangeAt(0).collapsed:false;}if(h){L.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return true;}return false;},_handleClickSelection:function(e,$,t){a.toggleRowSelection(t,$,null,function(r){if((D.browser.msie||D.browser.edge)&&e.shiftKey){t._clearTextSelection();}var s=t.getSelectionMode();if(s===S.Single){if(!t.isIndexSelected(r)){t.setSelectedIndex(r);}else{t.clearSelection();}}else if(e.shiftKey){var i=t.getSelectedIndex();if(i>=0){t.addSelectionInterval(i,r);}else{t.setSelectedIndex(r);}}else if(!t._legacyMultiSelection){if(!t.isIndexSelected(r)){t.addSelectionInterval(r,r);}else{t.removeSelectionInterval(r,r);}}else{t._legacyMultiSelection(r,e);}return true;});}};var C={initColumnResizing:function(t,e){if(t._bIsColumnResizerMoving){return;}t._bIsColumnResizerMoving=true;t.$().toggleClass("sapUiTableResizing",true);var $=q(document),f=t._isTouchEvent(e);t._$colResize=t.$("rsz");t._iColumnResizeStart=E._getEventPosition(e,t).x;$.bind((f?"touchend":"mouseup")+".sapUiTableColumnResize",C.exitColumnResizing.bind(t));$.bind((f?"touchmove":"mousemove")+".sapUiTableColumnResize",C.onMouseMoveWhileColumnResizing.bind(t));t._disableTextSelection();},exitColumnResizing:function(e){C._resizeColumn(this,this._iLastHoveredColumnIndex);},onMouseMoveWhileColumnResizing:function(e){var i=E._getEventPosition(e,this).x;if(this._iColumnResizeStart&&i<this._iColumnResizeStart+3&&i>this._iColumnResizeStart-3){return;}if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault();}this._$colResize.toggleClass("sapUiTableColRszActive",true);var o=this._getVisibleColumns()[this._iLastHoveredColumnIndex];var f=i-this._iColumnResizeStart;var g=this.$().find("th[data-sap-ui-colid=\""+o.getId()+"\"]").width();var w=Math.max(g+f*(this._bRtlMode?-1:1),a.Column.getMinColumnWidth());var r=this.$().find(".sapUiTableCnt").offset().left;var h=Math.floor((i-r)-(this._$colResize.width()/2));this._$colResize.css("left",h+"px");o._iNewWidth=w;},_cleanupColumResizing:function(t){if(t._$colResize){t._$colResize.toggleClass("sapUiTableColRszActive",false);t._$colResize=null;}t._iColumnResizeStart=null;t._bIsColumnResizerMoving=false;t.$().toggleClass("sapUiTableResizing",false);t._enableTextSelection();var $=q(document);$.unbind("touchmove.sapUiTableColumnResize");$.unbind("touchend.sapUiTableColumnResize");$.unbind("mousemove.sapUiTableColumnResize");$.unbind("mouseup.sapUiTableColumnResize");},_resizeColumn:function(t,i){var v=t._getVisibleColumns();var o;if(i>=0&&i<v.length){o=v[i];if(o._iNewWidth){a.Column.resizeColumn(t,t.indexOfColumn(o),o._iNewWidth);delete o._iNewWidth;}}C._cleanupColumResizing(t);o.focus();},doAutoResizeColumn:function(t,i){var v=t._getVisibleColumns(),o;if(i>=0&&i<v.length){o=v[i];if(!o.getAutoResizable()||!o.getResizable()){return;}var n=C._calculateAutomaticColumnWidth.apply(t,[o,i]);if(n){o._iNewWidth=n;C._resizeColumn(t,i);}}},_calculateAutomaticColumnWidth:function(o,i){o=o||this.getColumns()[i];var $=this.$();var e=q("<div>").addClass("sapUiTableHiddenSizeDetector sapUiTableHeaderDataCell sapUiTableDataCell");$.append(e);var f=$.find("td[data-sap-ui-colid = \""+o.getId()+"\"]:not([colspan])").filter(function(g,h){return h.style.display!="none";}).children().clone();f.removeAttr("id");var w=e.append(f).width()+4;w=Math.min(w,$.find(".sapUiTableCnt").width());w=Math.max(w+4,a.Column.getMinColumnWidth());e.remove();return w;},initColumnTracking:function(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").mousemove(function(e){var o=this.getDomRef();if(!o||this._bIsColumnResizerMoving){return;}var p=e.clientX,f=o.getBoundingClientRect(),g=0,r=this._bRtlMode?10000:-10000;for(var i=0;i<this._aTableHeaders.length;i++){var h=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if((p<h.right-5)&&(p>=h.left)){g=i;r=h.left-f.left;break;}}else{if((p>h.left+5)&&(p<=h.right)){g=i;r=h.right-f.left;break;}}}var j=this._getVisibleColumns()[g];if(j&&j.getResizable()){this.$("rsz").css("left",r+"px");this._iLastHoveredColumnIndex=g;}}.bind(t));}};var I={initInteractiveResizing:function(t,e){var B=q(document.body),s=t.$("sb"),$=q(document),o=s.offset(),h=s.height(),w=s.width(),f=t._isTouchEvent(e);B.bind("selectstart",I.onSelectStartWhileInteractiveResizing);B.append("<div id=\""+t.getId()+"-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");s.append("<div id=\""+t.getId()+"-rzoverlay\" style =\"left: 0px; right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");$.bind((f?"touchend":"mouseup")+".sapUiTableInteractiveResize",I.exitInteractiveResizing.bind(t));$.bind((f?"touchmove":"mousemove")+".sapUiTableInteractiveResize",I.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection();},exitInteractiveResizing:function(e){var B=q(document.body),$=q(document),t=this.$(),g=this.$("ghost"),i=E._getEventPosition(e,this).y;var n=i-t.find(".sapUiTableCCnt").offset().top-g.height()-t.find(".sapUiTableFtr").height();this._updateRows(this._calculateRowsToDisplay(n),a.RowsUpdateReason.Resize);this._setRowContentHeight(n);g.remove();this.$("rzoverlay").remove();B.unbind("selectstart",I.onSelectStartWhileInteractiveResizing);$.unbind("touchend.sapUiTableInteractiveResize");$.unbind("touchmove.sapUiTableInteractiveResize");$.unbind("mouseup.sapUiTableInteractiveResize");$.unbind("mousemove.sapUiTableInteractiveResize");this._enableTextSelection();},onSelectStartWhileInteractiveResizing:function(e){e.preventDefault();e.stopPropagation();return false;},onMouseMoveWhileInteractiveResizing:function(e){var i=E._getEventPosition(e,this).y;var m=this.$().offset().top;if(i>m){this.$("ghost").css("top",i+"px");}}};var R={initReordering:function(t,i,e){var o=t.getColumns()[i],$=o.$(),f=t.$();t._disableTextSelection();f.addClass("sapUiTableDragDrop");var g=$.clone();g.find("*").addBack(g).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");g.attr("id",t.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({"left":-10000,"top":-10000,"z-index":P.getNextZIndex()});g.toggleClass(a.getContentDensity(t),true);g.appendTo(document.body);t._$ReorderGhost=t.getDomRef("roghost");f.find("td[data-sap-ui-colid='"+o.getId()+"']").toggleClass("sapUiTableColReorderFade",true);var h=q("<div id='"+t.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");h.appendTo(t.getDomRef("sapUiTableCnt"));t._$ReorderIndicator=t.getDomRef("roind");t._iDnDColIndex=i;var j=q(document),k=t._isTouchEvent(e);j.bind((k?"touchend":"mouseup")+".sapUiColumnMove",R.exitReordering.bind(t));j.bind((k?"touchmove":"mousemove")+".sapUiColumnMove",R.onMouseMoveWhileReordering.bind(t));},onMouseMoveWhileReordering:function(e){var o=E._getEventPosition(e,this),i=o.x,f=o.y,O=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();var p=R.findColumnForPosition(this,i);if(!p||!p.id){this._iNewColPos=O;return;}var s=40,g=this.getDomRef("sapUiTableColHdrScr"),$=q(g),h=g.getBoundingClientRect(),j=$.outerWidth(),k=this._bRtlMode?$.scrollLeftRTL():$.scrollLeft();this._bReorderScroll=false;if(i>h.left+j-s&&k+j<g.scrollWidth){this._bReorderScroll=true;R.doScroll(this,!this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}else if(i<h.left+s&&k>0){this._bReorderScroll=true;R.doScroll(this,this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}q(this._$ReorderGhost).css({"left":i+5,"top":f+5});if(this._bReorderScroll||!p){return;}if(p.before||(p.after&&p.index==this._iDnDColIndex)){this._iNewColPos=p.index;}else if(p.after&&p.index!=this._iDnDColIndex){this._iNewColPos=p.index+1;}if(!a.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=O;}else{R.adaptReorderMarkerPosition(this,p,true);}},exitReordering:function(e){var o=this._iDnDColIndex;var n=this._iNewColPos;var $=q(document);$.unbind("touchmove.sapUiColumnMove");$.unbind("touchend.sapUiColumnMove");$.unbind("mousemove.sapUiColumnMove");$.unbind("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;q(this._$ReorderGhost).remove();delete this._$ReorderGhost;q(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();a.Column.moveColumnTo(this.getColumns()[o],n);if(this._mTimeouts.reApplyFocusTimerId){window.clearTimeout(this._mTimeouts.reApplyFocusTimerId);}var t=this;this._mTimeouts.reApplyFocusTimerId=window.setTimeout(function(){var O=a.getFocusedItemInfo(t).cell;a.focusItem(t,0,e);a.focusItem(t,O,e);},0);},findColumnForPosition:function(t,e){var h,H,r,w,p,B,A;for(var i=0;i<t._aTableHeaders.length;i++){h=t._aTableHeaders[i];H=q(h);r=h.getBoundingClientRect();w=H.outerWidth();p={left:r.left,center:r.left+w/2,right:r.left+w,width:w,index:parseInt(H.attr("data-sap-ui-headcolindex")),id:H.attr("data-sap-ui-colid")};B=e>=p.left&&e<=p.center;A=e>=p.center&&e<=p.right;if(B||A){p.before=t._bRtlMode?A:B;p.after=t._bRtlMode?B:A;return p;}}return null;},doScroll:function(t,f){if(t._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(t._mTimeouts.horizontalReorderScrollTimerId);t._mTimeouts.horizontalReorderScrollTimerId=null;}if(t._bReorderScroll){var s=f?30:-30;if(t._bRtlMode){s=(-1)*s;}t._mTimeouts.horizontalReorderScrollTimerId=setTimeout(R.doScroll.bind(t,t,f),60);var $=t.$("sapUiTableColHdrScr");var e=t._bRtlMode?"scrollLeftRTL":"scrollLeft";$[e]($[e]()+s);}},adaptReorderMarkerPosition:function(t,p,s){if(!p||!t._$ReorderIndicator){return;}var i=p.left-t.getDomRef().getBoundingClientRect().left;if(t._bRtlMode&&p.before||!t._bRtlMode&&p.after){i=i+p.width;}q(t._$ReorderIndicator).css({"left":i+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",s);}};var b={ROWAREAS:[".sapUiTableRowSelectionCell",".sapUiTableRowActionCell",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(t){var $=t.$();for(var i=0;i<b.ROWAREAS.length;i++){b._initRowHoveringForArea(t,$,b.ROWAREAS[i]);}},_initRowHoveringForArea:function(t,$,A){$.find(A).hover(function(){b._onHover(t,$,A,this);},function(){b._onUnhover(t,$,A,this);});},_onHover:function(t,$,A,e){var i=$.find(A).index(e);t.getRows()[i]._setHovered(true);},_onUnhover:function(t,$,A,e){var i=$.find(A).index(e);t.getRows()[i]._setHovered(false);}};var c={onmousedown:function(e){var p=this._getPointerExtension();var $=a.getCell(this,e.target);var o=a.getCellInfo($);var t=q(e.target);var f;var m;var M;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("sb")){I.initInteractiveResizing(this,e);}else if(e.target===this.getDomRef("rsz")){e.preventDefault();e.stopPropagation();C.initColumnResizing(this,e);}else if(t.hasClass("sapUiTableColResizer")){var i=t.closest(".sapUiTableHeaderCell").attr("data-sap-ui-colindex");this._iLastHoveredColumnIndex=parseInt(i);C.initColumnResizing(this,e);}else if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=setTimeout(function(){delete p._bShowMenu;},200);}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&t.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(o.columnIndex,e);}}if((D.browser.firefox&&!!(e.metaKey||e.ctrlKey))||t.closest(".sapUiTableHSb",this.getDomRef()).length===1||t.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault();}}if(e.button===2){if(E._skipClick(e,t,o)){p._bShowDefaultMenu=true;return;}if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;}else{p._bHideMenu=true;}}else if(o.isOfType(a.CELLTYPE.ANYCONTENTCELL)){if(a.Menu.hasContextMenu(this)){p._bShowMenu=true;}else{M=this._oCellContextMenu&&this._oCellContextMenu.bOpen;var g=M&&this._oCellContextMenu.oOpenerRef!==$[0];if(!M||g){p._bShowMenu=true;}else{p._bHideMenu=true;}}}else{p._bShowDefaultMenu=true;}}},onmouseup:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);},ondblclick:function(e){if(D.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();C.doAutoResizeColumn(this,this._iLastHoveredColumnIndex);}},onclick:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return;}var t=q(e.target);if(t.hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupMenuButton")){this._onContextMenu(e);e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupIcon")||t.hasClass("sapUiTableTreeIcon")){if(a.Grouping.toggleGroupHeaderByRef(this,e.target)){return;}}var $=a.getCell(this,e.target);var o=a.getCellInfo($);if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){var p=this._getPointerExtension();if(p._bShowMenu){a.Menu.openContextMenu(this,e.target,false);delete p._bShowMenu;}}else{if(E._skipClick(e,t,o)){return;}if(!this._findAndfireCellEvent(this.fireCellClick,e)){if(o.isOfType(a.CELLTYPE.COLUMNROWHEADER)){this._toggleSelectAll();}else{E._handleClickSelection(e,$,this);}}else{e.preventDefault();}}},oncontextmenu:function(e){var p=this._getPointerExtension();if(p._bShowDefaultMenu){e.setMarked("handledByPointerExtension");delete p._bShowDefaultMenu;}else if(p._bShowMenu){e.setMarked("handledByPointerExtension");e.preventDefault();a.Menu.openContextMenu(this,e.target,false,null,e);delete p._bShowMenu;}else if(p._bHideMenu){e.setMarked("handledByPointerExtension");e.preventDefault();delete p._bHideMenu;}}};
var d=T.extend("sap.ui.table.TablePointerExtension",{
_init:function(t,s,m){this._delegate=c;t.addEventDelegate(this._delegate,t);t._iLastHoveredColumnIndex=0;t._bIsColumnResizerMoving=false;t._iFirstReorderableIndex=s==T.TABLETYPES.TREE?1:0;return"PointerExtension";},
_attachEvents:function(){var t=this.getTable();if(t){C.initColumnTracking(t);b.initRowHovering(t);}},
_detachEvents:function(){var t=this.getTable();if(t){var $=t.$();$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowSelectionCell").unbind();}},
_debug:function(){this._ExtensionHelper=E;this._ColumnResizeHelper=C;this._InteractiveResizeHelper=I;this._ReorderHelper=R;this._ExtensionDelegate=c;this._RowHoverHandler=b;this._KNOWNCLICKABLECONTROLS=K;},
doAutoResizeColumn:function(i){var t=this.getTable();if(t){C.doAutoResizeColumn(t,i);}},
doReorderColumn:function(i,e){var t=this.getTable();if(t&&a.Column.isColumnMovable(t.getColumns()[i])){t._mTimeouts.delayedColumnReorderTimerId=setTimeout(function(){R.initReordering(this,i,e);}.bind(t),200);}},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;T.prototype.destroy.apply(this,arguments);}
});
return d;});
sap.ui.predefine('sap/ui/table/TableRenderer',['sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/Device','./library','./TableUtils',"./TableExtension",'sap/ui/core/Renderer','sap/ui/core/IconPool',"sap/base/Log"],function(C,P,D,a,T,b,R,I,L){"use strict";var S=a.SelectionMode,V=a.VisibleRowCountMode;var c={};
c.render=function(r,t){delete t._iHeaderRowCount;T.getResourceBundle();r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.writeControlData(t);r.addClass("sapUiTable");if('ontouchstart'in document){r.addClass("sapUiTableTouch");}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.addClass("sapUiTableRowSelectors");}if(T.hasRowHighlights(t)){r.addClass("sapUiTableRowHighlights");}var s=a.TableHelper.addTableClass();if(s){r.addClass(s);}var o=t._getScrollExtension();if(o.isVerticalScrollbarRequired()&&!o.isVerticalScrollbarExternal()){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}if(T.hasRowActions(t)){var i=T.getRowActionCount(t);r.addClass(i==1?"sapUiTableRActS":"sapUiTableRAct");}if(T.isNoDataVisible(t)&&!T.hasPendingRequests(t)){r.addClass("sapUiTableEmpty");}if(t.getShowOverlay()){r.addClass("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.addClass(m);}if(t.getWidth()){r.addStyle("width",t.getWidth());}if(t.getVisibleRowCountMode()==V.Auto){r.addStyle("height","0px");if(t._bFirstRendering){r.addClass("sapUiTableNoOpacity");}}r.writeClasses();r.writeStyles();r.write(">");this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCnt");r.addClass("sapUiTableCnt");r.writeClasses();r.writeAttribute("data-sap-ui-fastnavgroup","true");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableGridCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.write(">");this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);r.write("</div>");t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.write("<div");r.addClass("sapUiTableOverlayArea");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-overlay");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.write("></div>");r.write("</div>");if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderTabElement(r,"sapUiTableOuterAfter");r.write("</div>");};
c.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.write(">");r.renderControl(o);r.write("</div>");};
c.renderToolbar=function(r,t,o){r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}if(o.isA("sap.m.Toolbar")){o.setDesign("Transparent",true);o.addStyleClass("sapMTBHeader-CTX");r.addClass("sapUiTableMTbr");}r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(o);r.write("</div>");};
c.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};
c.renderExtension=function(r,t,e){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(e);r.write("</div>");};
c.renderTable=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCCnt");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");this.renderTableCCnt(r,t);r.write("</div>");this.renderTabElement(r,"sapUiTableCtrlAfter");if(!t._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSbBackground(r,t);this.renderVSb(r,t);}this.renderHSbBackground(r,t);this.renderHSb(r,t);};
c.renderTableCCnt=function(r,t){this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderRowActions(r,t);r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-noDataCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.write(">");if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.write("<span");r.writeAttribute("id",t.getId()+"-noDataMsg");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");r.writeEscaped(T.getNoDataText(t));r.write("</span>");}r.write("</div>");};
c.renderFooter=function(r,t,f){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.write(">");r.renderControl(f);r.write("</div>");};
c.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabIndex="-1"');r.addClass("sapUiTableHeightResizer");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};
c.renderColHdr=function(r,t){var n=T.getHeaderRowCount(t);var d=t.getColumns();var f=t.getComputedFixedColumnCount();r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();r.write(">");this.renderColRowHdr(r,t);if(f>0){r.write("<div");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScrFixed");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");this.renderTableControlCnt(r,t,true,0,f,true,false,0,n,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableColHdrScr");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScr");if(d.length==0){r.addClass("sapUiTableHasNoColumns");}r.writeClasses();if(f>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");this.renderTableControlCnt(r,t,false,f,d.length,false,false,0,n,true);r.write("</div>");if(T.hasRowActions(t)){r.write("<div");r.writeAttribute("id",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWACTIONHEADER");r.addClass("sapUiTableCell");r.addClass("sapUiTableHeaderCell");r.addClass("sapUiTableRowActionHeaderCell");r.writeClasses();r.write(">");r.write("<span>");r.writeEscaped(T.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));r.write("</span>");r.write("</div>");}r.write("</div>");};
c.renderColRowHdr=function(r,t){var e=false;var s=false;r.write("<div");r.writeAttribute("id",t.getId()+"-selall");r.addClass("sapUiTableCell");r.addClass("sapUiTableHeaderCell");r.addClass("sapUiTableRowSelectionHeaderCell");if(T.hasSelectAll(t)){var A=T.areAllRowsSelected(t);if(t._getShowStandardTooltips()){var d=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";r.writeAttributeEscaped("title",T.getResourceText(d));}if(!A){r.addClass("sapUiTableSelAll");}else{s=true;}r.addClass("sapUiTableSelAllEnabled");e=true;}else{r.addClass("sapUiTableSelAllDisabled");}r.writeClasses();r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e,checked:s});r.write(">");if(t.getSelectionMode()!==S.Single){r.write("<div");r.addClass("sapUiTableSelectAllCheckBox");r.writeClasses();r.write("></div>");}r.write("</div>");};
c.renderCol=function(r,t,o,h,n,i,d,e){var l,f=!n,g=o.getIndex(),j=o.getMultiLabels();if(j.length>0){l=j[h];}else if(h==0){l=o.getLabel();}r.write("<td");var H=o.getId();if(h===0){r.writeElementData(o);}else{H=H+"_"+h;r.writeAttribute('id',H);}r.writeAttribute('data-sap-ui-colid',o.getId());r.writeAttribute("data-sap-ui-colindex",g);r.writeAttribute("tabindex","-1");var A={column:o,headerId:H,index:g};if(n>1){r.writeAttribute("colspan",n);A.colspan=true;}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",A);r.addClass("sapUiTableCell");r.addClass("sapUiTableHeaderCell");r.addClass("sapUiTableHeaderDataCell");if(i){r.addClass("sapUiTableCellFirst");}if(d){r.addClass("sapUiTableCellLastFixed");}if(e){r.addClass("sapUiTableCellLast");}if(f){r.addClass("sapUiTableHidden");}r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.writeStyles();var s=o.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write("><div");r.addClass("sapUiTableCellInner");r.writeAttribute("id",H+"-inner");r.writeClasses();var k=R.getTextAlign(o.getHAlign(),l&&l.getTextDirection&&l.getTextDirection());if(k){r.addStyle("text-align",k);}r.writeStyles();r.write(">");if(l){r.renderControl(l);}r.write("</div></td>");};
c.renderColRsz=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-rsz");r.addClass("sapUiTableColRsz");r.writeClasses();r.write("></div>");};
c.renderRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowHdrScr");r.addClass("sapUiTableRowHdrScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.write(">");for(var d=0,e=t.getRows().length;d<e;d++){this.renderRowAddon(r,t,t.getRows()[d],d,true);}r.write("</div>");};
c.renderRowActions=function(r,t){if(!T.hasRowActions(t)){return;}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowActionScr");r.addClass("sapUiTableRowActionScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");for(var d=0,e=t.getRows().length;d<e;d++){this.renderRowAddon(r,t,t.getRows()[d],d,false);}r.write("</div>");};
c.addRowCSSClasses=function(r,t,i){var f=t.getFixedRowCount();var F=T.getFirstFixedBottomRowIndex(t);if(i===0){r.addClass("sapUiTableFirstRow");}else if(i===t.getRows().length-1){r.addClass("sapUiTableLastRow");}if(f>0){if(i==f-1){r.addClass("sapUiTableRowLastFixedTop");}}if(F>=0&&F===i){r.addClass("sapUiTableRowFirstFixedBottom");}else if(F>=1&&F-1===i){r.addClass("sapUiTableRowLastScrollable");}};
c.renderRowAddon=function(r,t,o,i,h){r.write("<div");r.writeAttribute("id",t.getId()+(h?"-rowsel":"-rowact")+i);r.writeAttribute("data-sap-ui-related",o.getId());r.writeAttribute("data-sap-ui-rowindex",i);r.addClass("sapUiTableCell");r.addClass("sapUiTableContentCell");r.addClass(h?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.addClass("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);var d=false;var e=false;if(o._bHidden){r.addClass("sapUiTableRowHidden");e=true;}else{if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");d=true;}}r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t._getDefaultRowHeight()+"px");}r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"ROWHEADER":"ROWACTION",{rowSelected:d,rowHidden:e});r.writeStyles();r.write(">");if(h){this.writeRowHighlightContent(r,t,o,i);this.writeRowSelectorContent(r,t,o,i);}else{var A=o.getRowAction();if(A){r.renderControl(A);}}r.write("</div>");};
c.renderTableCtrl=function(r,t){if(t.getComputedFixedColumnCount()>0){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScrFixed");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScr");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCtrlCnt");r.addClass("sapUiTableCtrlCnt");r.writeClasses();if(!T.isVariableRowHeightEnabled(t)){var v=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(v==V.Fixed||v==V.Interactive)){var s="height";if(t.getVisibleRowCountMode()==V.Fixed){s="min-height";}r.addStyle(s,t._iTableRowContentHeight+"px");r.writeStyles();}}r.write(">");this.renderTableControl(r,t,false);r.write("</div></div>");};
c.renderTableControl=function(r,t,f){var s,e;if(f){s=0;e=t.getComputedFixedColumnCount();}else{s=t.getComputedFixedColumnCount();e=t.getColumns().length;}var F=t.getFixedRowCount();var i=t.getFixedBottomRowCount();var d=t.getRows();if(F>0){this.renderTableControlCnt(r,t,f,s,e,true,false,0,F);}this.renderTableControlCnt(r,t,f,s,e,false,false,F,d.length-i);if(i>0&&d.length>0){this.renderTableControlCnt(r,t,f,s,e,false,true,d.length-i,d.length);}};
c.renderTableControlCnt=function(r,t,f,s,e,F,d,i,E,h){r.write("<table");var g=h?"-header":"-table";var j=t.getId()+g;if(f){j+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(F){j+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(d){j+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",j);t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"COLUMNHEADER_TABLE":"TABLE");r.addClass("sapUiTableCtrl");if(h){r.addClass("sapUiTableCHT");}r.writeClasses();r.addStyle(f?"width":"min-width",t._getColumnsWidth(s,e)+"px");r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(i==0){r.addClass("sapUiTableCtrlFirstCol");}if(h){r.addClass("sapUiTableCHTHR");}r.writeClasses();r.write(">");var k=t.getColumns();var l=new Array(e);var m;var o;var H=false;var n=!f&&e>s;for(m=s;m<e;m++){o=k[m];var p={shouldRender:!!(o&&o.shouldRender())};if(p.shouldRender){var w=o.getWidth();if(T.isVariableWidth(w)){n=false;if(f){o._iFixWidth=o._iFixWidth||160;w=o._iFixWidth+"px";}else if(w&&w.indexOf("%")>0){H=true;}}else if(f){delete o._iFixWidth;}p.width=w;}l[m]=p;}if(T.hasRowHeader(t)&&!h){r.write("<th");if(H){r.addStyle("width","0%");}else{r.addStyle("width","0px");}r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH");if(!h){r.writeAttribute("id",t.getId()+"-colsel");}r.addClass("sapUiTableColSel");r.writeClasses();}r.write("></th>");}else{if(k.length===0){r.write("<th></th>");}}for(m=s;m<e;m++){g=h?"_hdr":"_col";o=k[m];p=l[m];if(p.shouldRender){r.write("<th");if(p.width){r.addStyle("width",p.width);r.writeStyles();}if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:o});r.writeAttribute("id",t.getId()+g+m);}r.writeAttribute("data-sap-ui-headcolindex",m);r.writeAttribute("data-sap-ui-colid",o.getId());r.write(">");if(i==0&&T.getHeaderRowCount(t)==0&&!h){if(o.getMultiLabels().length>0){r.renderControl(o.getMultiLabels()[0]);}else{r.renderControl(o.getLabel());}}r.write("</th>");}}if(n){r.write("<th");if(h){r.writeAttribute("id",t.getId()+"-dummycolhdr");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write("></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var v=t._getVisibleColumns();var q=t.getRows();var u;var x;if(h){for(u=i,x=E;u<x;u++){this.renderColumnHeaderRow(r,t,u,f,s,e,n);}}else{var y=t._getAccExtension().getAriaTextsForSelectionMode(true);var z=T.isRowSelectionAllowed(t);var A=t.getDragDropConfig().some(function(B){return B.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&B.getSourceAggregation()==="rows";});for(u=i,x=E;u<x;u++){this.renderTableRow(r,t,q[u],u,f,s,e,false,v,n,y,z,A);}}r.write("</tbody>");r.write("</table>");};
c.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.write("<div");r.writeAttribute("class","sapUiTableGroupShield");r.write("></div>");r.write("<div");r.writeAttribute("id",o.getId()+"-groupHeader");r.writeAttribute("class","sapUiTableGroupIcon");r.write("></div>");if(T.Grouping.showGroupMenuButton(t)){var d=I.getIconInfo("sap-icon://drop-down-list");r.write("<div class='sapUiTableGroupMenuButton'>");r.writeEscaped(d.content);r.write("</div>");}}};
c.writeRowHighlightContent=function(r,t,o,i){if(!T.hasRowHighlights(t)){return;}var d=o.getAggregation("_settings");var h=d._getHighlightCSSClassName();r.write("<div");r.writeAttribute("id",o.getId()+"-highlight");r.addClass("sapUiTableRowHighlight");r.addClass(h);r.writeClasses();r.write(">");t._getAccRenderExtension().writeAccRowHighlightText(r,t,o,i);r.write("</div>");};
c.renderColumnHeaderRow=function(r,t,i,f,s,e,h){r.write("<tr");r.addClass("sapUiTableColHdrTr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.write(">");var d,n=0,l=-1;d=t.getColumns().slice(s,e).filter(function(o){return o&&o.shouldRender();});function g(o,k,m){var p=T.Column.getHeaderSpan(o,i),q;if(n<1){if(p>1){q=o.getIndex();p=m.slice(k+1,k+p).reduce(function(u,v){return v.getIndex()-q<p?u+1:u;},1);}o._nSpan=n=p;l=k;}else{o._nSpan=0;}n--;}d.forEach(g);function j(o,k){this.renderCol(r,t,o,i,o._nSpan,k===0,f&&(k==l),!f&&(k==l));o._nSpan=undefined;}d.forEach(j.bind(this));if(!f&&h&&d.length>0){r.write('<td class="sapUiTableCellDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};
c.renderTableRow=function(r,t,o,i,f,s,e,F,v,h,m,d,g){if(!o){return;}r.write("<tr");if(o._bDummyRow){r.addStyle("opacity","0");}r.addClass("sapUiTableTr");if(f){r.writeAttribute("id",o.getId()+"-fixed");r.writeAttribute("data-sap-ui-related",o.getId());}else{r.writeElementData(o);}if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(g&&f){r.writeAttribute("draggable",true);}if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");}}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.addClass("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);if(t.getRowHeight()>0){r.addStyle("height",t._getDefaultRowHeight()+"px");}r.writeStyles();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i});r.write(">");var j=o.getCells();if(T.hasRowHeader(t)||j.length===0){r.write("<td");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_TD",{rowSelected:!o._bHidden&&t.isIndexSelected(o.getIndex()),index:i});r.write("></td>");}for(var k=0,l=j.length;k<l;k++){this.renderTableCell(r,t,o,j[k],k,f,s,e,v);}if(!f&&h&&j.length>0){r.write('<td class="sapUiTableCellDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};
c.renderTableCell=function(r,t,o,d,i,f,s,e,v){var g=d.data("sap-ui-colindex");var h=t.getColumns();var j=h[g];var l=h[t.getFixedColumnCount()-1];if(j.shouldRender()&&s<=g&&e>g){r.write("<td");var k=o.getId()+"-col"+i;r.writeAttribute("id",k);r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-ui-colid",j.getId());var n=v.length;var m=n>0&&v[0]===j;var p=n>0&&v[n-1]===j;var q=f&l===j;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:g,column:j,row:o,fixed:f,firstCol:m});var H=R.getTextAlign(j.getHAlign(),d&&d.getTextDirection&&d.getTextDirection());if(H){r.addStyle("text-align",H);}r.writeStyles();r.addClass("sapUiTableCell");r.addClass("sapUiTableContentCell");r.addClass("sapUiTableDataCell");if(m){r.addClass("sapUiTableCellFirst");}if(q){r.addClass("sapUiTableCellLastFixed");}if(p){r.addClass("sapUiTableCellLast");}var B=t.getBinding("rows");if(B&&j.getLeadingProperty&&B.isMeasure(j.getLeadingProperty())){r.addClass("sapUiTableMeasureCell");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCellInner");if(m&&T.Grouping.isTreeMode(t)){r.addClass("sapUiTableCellFlex");}r.writeClasses();if(t.getRowHeight()>0&&(t.getVisibleRowCountMode()==V.Auto||t.hasStyleClass("sapUiTableFixedRowHeights"))){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,d,m);r.write("</div></td>");}};
c.renderTableCellControl=function(r,t,o,i){if(i&&T.Grouping.isTreeMode(t)&&!t._bFlatMode){var d=o.getParent();r.write("<span class='sapUiTableTreeIcon' tabindex='-1' id='"+d.getId()+"-treeicon'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:d});r.write("></span>");}r.renderControl(o);};
c.renderVSb=function(r,t,m){m=Object.assign({cssClass:"sapUiTableVSb",tabIndex:true,hidden:true},m);m.id=t.getId()+"-vsb";var s=t._getScrollExtension();r.write("<div");r.addClass(m.cssClass);if(m.hidden){r.addClass("sapUiTableHidden");}r.writeClasses();r.writeAttribute("id",m.id);if(m.tabIndex){r.writeAttribute("tabindex","-1");}r.addStyle("max-height",s.getVerticalScrollbarHeight()+"px");if(t.getFixedRowCount()>0){t._iVsbTop=(t.getFixedRowCount()*t._getDefaultRowHeight())-1;r.addStyle("top",t._iVsbTop+'px');}r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",m.id+"-content");r.addClass("sapUiTableVSbContent");r.writeClasses();r.addStyle("height",s.getVerticalScrollHeight()+"px");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};
c.renderVSbExternal=function(r,t){if(b.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){this.renderVSb(r,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};
c.renderVSbBackground=function(r,t){r.write("<div");r.addClass("sapUiTableVSbBg");r.writeAttribute("id",t.getId()+"-vsb-bg");r.writeClasses();r.write("></div>");};
c.renderHSb=function(r,t,m){m=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},m);r.write("<div");r.addClass(m.cssClass);if(m.hidden){r.addClass("sapUiTableHidden");}r.writeClasses();r.writeAttribute("id",m.id);if(m.tabIndex){r.writeAttribute("tabindex","-1");}r.write(">");r.write("<div");r.writeAttribute("id",m.id+"-content");r.addClass("sapUiTableHSbContent");r.writeClasses();if(m.scrollWidth>0){r.addStyle("width",m.scrollWidth+"px");}r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};
c.renderHSbExternal=function(r,t,i,s){if(b.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){this.renderHSb(r,t,{id:i,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:s});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};
c.renderHSbBackground=function(r,t){r.write("<div");r.addClass("sapUiTableHSbBg");r.writeAttribute("id",t.getId()+"-hsb-bg");r.writeClasses();r.write("></div>");};
c.renderTabElement=function(r,s){r.write("<div");if(s){r.addClass(s);r.writeClasses();}r.writeAttribute("tabindex","0");r.write("></div>");};
return c;},true);
sap.ui.predefine('sap/ui/table/TableRendererUtils',['sap/ui/core/Control'],function(C){"use strict";var T=null;var a={addClass:function(r,c,s){if(c&&(!!s||arguments.length==2)){r.addClass(c);if(T){T.writeClasses=true;}}return a;},addStyle:function(r,n,v,s){if(n&&v&&(!!s||arguments.length==3)){r.addStyle(n,v);if(T){T.writeStyles=true;}}return a;},startElement:function(r,t,c){c=c||{};r.write("<",c.tag||"div");T=c;if(c.furtherSettings){c.furtherSettings(r,t);}if(Array.isArray(c.classname)&&c.classname.length){for(var i=0;i<c.classname.length;i++){a.addClass(r,c.classname[i]);}}else if(c.classname){a.addClass(r,c.classname);}if(c.id){r.writeAttribute("id",(c.element||t).getId()+"-"+c.id);}else if(c.element){if(c.element instanceof C){r.writeControlData(c.element);}else{r.writeElementData(c.element);}}if(c.attributes){for(var n in c.attributes){if(c.attributes.hasOwnProperty(n)){r.writeAttribute(n,c.attributes[n]);}}}if(typeof c.tabindex==="number"){r.writeAttribute("tabindex",""+c.tabindex);}if(c.aria){t._getAccRenderExtension().writeAriaAttributesFor(r,t,c.aria,c.ariaconfig);}if(T.writeClasses){r.writeClasses();}if(T.writeStyles){r.writeStyles();}T=null;r.write(">");return a;},endElement:function(r,t){r.write("</",t||"div",">");return a;},renderElement:function(r,t,c){a.startElement(r,t,c);a.endElement(r,c?c.tag:null);return a;}};return a;},true);
sap.ui.predefine('sap/ui/table/TableScrollExtension',["./TableExtension","./TableUtils","sap/ui/Device","./library","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery"],function(T,c,D,l,I,L,q){"use strict";var S=l.SharedDomRef;var M=1000000;var V=2;var d={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};var e={SCROLLBAR:"Scrollbar",KEYBOARD:"Keyboard",MOUSEWHEEL:"MouseWheel",TOUCH:"Touch",FOCUS:"Focus",EXTENSION:"Extension",TABLE:"Table"};
function f(s,t){L.debug("sap.ui.table.TableScrollExtension",s,t);}
var g=new window.WeakMap();var h=function(t){if(!t){return{};}if(!g.has(t)){g.set(t,{oHorizontalScrollbar:null,iHorizontalScrollPosition:null,bVerticalScrollingSuspended:false,oVerticalScrollbar:null,oExternalVerticalScrollbar:null,nVerticalScrollPosition:null,iVerticalScrollHeight:null,iVerticalScrollbarHeight:null,iFirstVisibleRowInBuffer:null,bIsScrolledVerticallyByWheel:false,bIsScrolledVerticallyByKeyboard:false,mTouchSessionData:null,bIsVerticalScrollbarExternal:false,fnOnRowsUpdatedPreprocessor:null});}return g.get(t);};
h.destroy=function(t){delete g.delete(t);};
var H={onScroll:function(o){var n=o.target.scrollLeft;var O=o.target._scrollLeft;I.notifyScrollEvent&&I.notifyScrollEvent(o);if(n!==O){var s=H.getScrollAreas(this);o.target._scrollLeft=n;for(var i=0;i<s.length;i++){var a=s[i];if(a!==o.target&&a.scrollLeft!==n){a.scrollLeft=n;a._scrollLeft=n;}}h(this).iHorizontalScrollPosition=n;}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();if(o&&h(t).iHorizontalScrollPosition!==null){var a=H.getScrollAreas(t);for(var i=0;i<a.length;i++){var b=a[i];delete b._scrollLeft;}if(o.scrollLeft!==h(t).iHorizontalScrollPosition){o.scrollLeft=h(t).iHorizontalScrollPosition;}else{var n=q.Event("scroll");n.target=o;H.onScroll.call(t,n);}}},onScrollbarMouseDown:function(o){this._getKeyboardExtension().setActionMode(false);},addEventListeners:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();var a=H.getScrollAreas(t);if(!s._onHorizontalScrollEventHandler){s._onHorizontalScrollEventHandler=H.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}if(o){if(!s._onHorizontalScrollbarMouseDownEventHandler){s._onHorizontalScrollbarMouseDownEventHandler=H.onScrollbarMouseDown.bind(t);}o.addEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();var a=H.getScrollAreas(t);if(s._onHorizontalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete a[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}if(o&&s._onHorizontalScrollbarMouseDownEventHandler){o.removeEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);delete s._onHorizontalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var s=[t._getScrollExtension().getHorizontalScrollbar(),t.getDomRef("sapUiTableColHdrScr"),t.getDomRef("sapUiTableCtrlScr")];return s.filter(function(o){return o!=null;});}};var j={updateScrollPosition:function(t,n,s,p){s=s==null?e.EXTENSION:s;var o=t._getScrollExtension();var v=o.getVerticalScrollbar();if(!t||!v||!o.isVerticalScrollbarRequired()||h(t).bVerticalScrollingSuspended){f("VerticalScrollingHelper#updateScrollPosition: Not executed - Guard clause not passed",t);return;}var a=h(t).nVerticalScrollPosition;var i=j.getScrollRange(t);if(n==null){var F=t.getFirstVisibleRow();var b=t._getMaxFirstRenderedRowIndex();if(F>b){n=i;h(t).iFirstVisibleRowInBuffer=F-b;}else{n=F*j.getScrollRangeRowFraction(t);h(t).iFirstVisibleRowInBuffer=null;}}else{h(t).iFirstVisibleRowInBuffer=null;}h(t).nVerticalScrollPosition=Math.min(Math.max(0,n),i);f("VerticalScrollingHelper#updateScrollPosition: From "+a+" to "+h(t).nVerticalScrollPosition+" (diff: "+(h(t).nVerticalScrollPosition-a)+", trigger: "+s+")",t);if(p===true){f("VerticalScrollingHelper#updateScrollPosition: Scrolling prevented",t);return;}window.cancelAnimationFrame(t._mAnimationFrames.verticalScrollUpdate);delete t._mAnimationFrames.verticalScrollUpdate;switch(s){case e.SCROLLBAR:clearTimeout(t._mTimeouts.largeDataScrolling);delete t._mTimeouts.largeDataScrolling;if(t._bLargeDataScrolling&&!h(t).bIsScrolledVerticallyByWheel){t._mTimeouts.largeDataScrolling=setTimeout(function(){delete t._mTimeouts.largeDataScrolling;j.updateFirstVisibleRow(t);},300);}else{j.updateFirstVisibleRow(t);}break;case e.KEYBOARD:case e.MOUSEWHEEL:case e.TOUCH:case e.EXTENSION:case e.TABLE:var N=0;var r=j.getScrollRange(t);if(h(t).nVerticalScrollPosition>0&&h(t).nVerticalScrollPosition<0.5){N=1;}else if(h(t).nVerticalScrollPosition>=r-0.5&&h(t).nVerticalScrollPosition<r){N=r-1;}else{N=Math.round(h(t).nVerticalScrollPosition);}if(v.scrollTop!==N){f("VerticalScrollingHelper#updateScrollPosition: scrollTop will be set asynchronously",t);t._mAnimationFrames.verticalScrollUpdate=window.requestAnimationFrame(function(){var u=v.scrollTop;delete t._mAnimationFrames.verticalScrollUpdate;f("VerticalScrollingHelper#updateScrollPosition: (async) Set scrollTop from "+u+" to "+N,t);v.scrollTop=N;v._scrollTop=v.scrollTop;if(N===r&&N!==v.scrollTop){f("VerticalScrollingHelper#updateScrollPosition: (async) Adjusted from "+h(t).nVerticalScrollPosition+" to "+v.scrollTop,t);h(t).nVerticalScrollPosition=v.scrollTop;}j.updateFirstVisibleRow(t);});}else if(h(t).nVerticalScrollPosition!==a){f("VerticalScrollingHelper#updateScrollPosition: firstVisibleRow will be set asynchronously",t);t._mAnimationFrames.verticalScrollUpdate=window.requestAnimationFrame(function(){delete t._mAnimationFrames.verticalScrollUpdate;j.updateFirstVisibleRow(t);});}else{f("VerticalScrollingHelper#updateScrollPosition: scrollTop and nVerticalScrollPosition not changed"+" -> update inner vertical scroll position",t);o.updateInnerVerticalScrollPosition();}break;default:}},onScroll:function(o){I.notifyScrollEvent&&I.notifyScrollEvent(o);if(h(this).bIsScrolledVerticallyByKeyboard){f("Vertical scroll event handler: Aborted - Scrolled by keyboard",this);return;}this._getKeyboardExtension().setActionMode(false);var n=o.target.scrollTop;var a=o.target._scrollTop;var s=n!==a;if(s){f("Vertical scroll event handler: Scroll position changed by scrolling with the scrollbar:"+" From "+h(this).nVerticalScrollPosition+" to "+n,this);delete o.target._scrollTop;j.updateScrollPosition(this,n,e.SCROLLBAR);}else{f("Vertical scroll event handler: Scroll position changed by scrolling with VerticalScrollingHelper#updateScrollPosition",this);}h(this).bIsScrolledVerticallyByWheel=false;},updateFirstVisibleRow:function(t){var s=t._getScrollExtension();var i=t._getMaxFirstRenderedRowIndex();var n=j.getRowIndexAtCurrentScrollPosition(t);var o=t.getFirstVisibleRow();var N=n<0;var O=o>=i;var F=n!==o;var r=F&&!(N&&O);if(r){var b=!O||n!==i;if(N){n=i;}f("updateFirstVisibleRow: From "+o+" to "+n,t);t.setFirstVisibleRow(n,true,N);if(b){j.setOnRowsUpdatedPreprocessor(t,function(a){f("updateFirstVisibleRow - onRowsUpdatedPreprocessor: Reason "+a.getParameters().reason,this);s.updateInnerVerticalScrollPosition();if(N){var C=this.getFirstVisibleRow();var p=n===C;if(p){this.setProperty("firstVisibleRow",-1,true);this.setFirstVisibleRow(C,true);}}return false;});}else{f("updateFirstVisibleRow: Update inner vertical scroll position",t);s.updateInnerVerticalScrollPosition();}}else if(c.isVariableRowHeightEnabled(t)){f("updateFirstVisibleRow: Update inner vertical scroll position",t);s.updateInnerVerticalScrollPosition();}},getRowIndexAtCurrentScrollPosition:function(t){var s=t._getScrollExtension();var i=t._getMaxFirstVisibleRowIndex();if(i===0){return 0;}else{var n=j.getScrollPosition(t);var a=j.getScrollRange(t);var b=j.getScrollRangeRowFraction(t);if(c.isVariableRowHeightEnabled(t)){if(j.isScrollPositionInBuffer(t)){return-1;}else{return Math.min(i,Math.floor(n/b));}}else{var r=Math.floor(n/b);var o=a-n;var p=s.getVerticalScrollbar()._scrollTop==null||h(t).bIsScrolledVerticallyByWheel;var u=o<1&&p||o<0.01;if(u){j.updateScrollPosition(t,a,null,true);}return u?i:Math.min(i,r);}}},getScrollRange:function(t){var s=t._getScrollExtension();var v=s.getVerticalScrollHeight()-s.getVerticalScrollbarHeight();return Math.max(0,v);},getScrollRangeBuffer:function(t){if(!c.isVariableRowHeightEnabled(t)){return 0;}return V*t._getDefaultRowHeight();},getScrollPosition:function(t){var s=t._getScrollExtension();if(h(t).nVerticalScrollPosition!=null){return h(t).nVerticalScrollPosition;}else if(s.isVerticalScrollbarVisible()){return s.getVerticalScrollbar().scrollTop;}else{return 0;}},getScrollRangeRowFraction:function(t){var s=t._getScrollExtension();var v=t._getTotalRowCount()-t.getVisibleRowCount();var i;if(c.isVariableRowHeightEnabled(t)){i=j.getScrollRange(t)-j.getScrollRangeBuffer(t);var b=s.getVerticalScrollHeight()===M;if(!b){i+=t._getDefaultRowHeight();}}else{i=j.getScrollRange(t);}return i/Math.max(1,v);},isScrollPositionInBuffer:function(t){if(!c.isVariableRowHeightEnabled(t)){return false;}var s=j.getScrollRange(t);var n=j.getScrollPosition(t);var i=j.getScrollRangeBuffer(t);return s-n<=i;},getInnerScrollRange:function(t){if(!t||!t._aRowHeights){return 0;}var r=t._aRowHeights;var i=t._getDefaultRowHeight()*t.getVisibleRowCount();if(t.getVisibleRowCount()>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var n=r.reduce(function(a,b){return a+b;},0)-i;if(n>0){n=Math.ceil(n);}return Math.max(0,n);},onScrollbarMouseDown:function(o){h(this).bIsScrolledVerticallyByWheel=false;h(this).bIsScrolledVerticallyByKeyboard=false;},setOnRowsUpdatedPreprocessor:function(t,p){h(t).fnOnRowsUpdatedPreprocessor=p;},runOnRowsUpdatedPreprocessor:function(t,o){var b=true;if(h(t).fnOnRowsUpdatedPreprocessor!=null){b=h(t).fnOnRowsUpdatedPreprocessor.call(t,o)!==false;}h(t).fnOnRowsUpdatedPreprocessor=null;return b;},onRowsUpdated:function(o){var s=this._getScrollExtension();var b=j.runOnRowsUpdatedPreprocessor(this,o);if(!c.isVariableRowHeightEnabled(this)||!b){return;}var r=o.getParameters().reason;var R=r===c.RowsUpdateReason.Expand||r===c.RowsUpdateReason.Collapse;var F=this.getFirstVisibleRow()-this._getMaxFirstRenderedRowIndex();f("onRowsUpdated: Reason "+r,this);if(F>=0&&R){h(this).iFirstVisibleRowInBuffer=F;s.updateInnerVerticalScrollPosition();}},restoreScrollPosition:function(t){j.updateScrollPosition(t,h(t).nVerticalScrollPosition);},addEventListeners:function(t){var s=t._getScrollExtension();var a=j.getScrollAreas(t);var v=s.getVerticalScrollbar();if(!s._onVerticalScrollEventHandler){s._onVerticalScrollEventHandler=j.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v){if(!s._onVerticalScrollbarMouseDownEventHandler){s._onVerticalScrollbarMouseDownEventHandler=j.onScrollbarMouseDown.bind(t);}v.addEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);}t.attachEvent("_rowsUpdated",j.onRowsUpdated);},removeEventListeners:function(t){var s=t._getScrollExtension();var a=j.getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v&&s._onVerticalScrollbarMouseDownEventHandler){v.removeEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);delete s._onVerticalScrollbarMouseDownEventHandler;}t.detachEvent("_rowsUpdated",j.onRowsUpdated);},isUpdatePending:function(t){return!!(t&&t._mAnimationFrames.verticalScrollUpdate);},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(o){return o!=null;});}};var k={onMouseWheelScrolling:function(o,a){var s=this._getScrollExtension();var v=Math.abs(a.deltaY)>Math.abs(a.deltaX);var i=v?a.deltaY:a.deltaX;var b=v&&a.shiftKey||!v;var n=i>0;var p=false;if(i===0){return;}if(b&&(o.scrollDirection===d.HORIZONAL||o.scrollDirection===d.BOTH)){var r=s.getHorizontalScrollbar();if(a.deltaMode>0){var t=c.Column.getMinColumnWidth();i=n?t:-t;}if(n){p=r.scrollLeft===r.scrollWidth-r.offsetWidth;}else{p=r.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!p){a.preventDefault();a.stopPropagation();this._getKeyboardExtension().setActionMode(false);r.scrollLeft=r.scrollLeft+i;}}else if(!b&&(o.scrollDirection===d.VERTICAL||o.scrollDirection===d.BOTH)){var u=s.getVerticalScrollbar();var w=this._getMaxFirstRenderedRowIndex();var x=this._getFirstRenderedRowIndex()===w;var y=j.getScrollRangeRowFraction(this);var z=x?this._getDefaultRowHeight():y;if(a.deltaMode===1){i*=z;}else if(a.deltaMode===2){i*=z*this.getVisibleRowCount();}if(n){p=u.scrollTop===u.scrollHeight-u.offsetHeight;}else{p=u.scrollTop===0;}if(s.isVerticalScrollbarVisible()&&!p){a.preventDefault();a.stopPropagation();var A=j.getScrollPosition(this);var B=A-(w*y);var C=i;if(!x||(x&&B===0&&!n)){var F=i/(a.deltaMode===0?this._getDefaultRowHeight():y);if(F>1){F=Math.floor(F);}else if(F<-1){F=Math.ceil(F);}C=F*y;}else if(!n){if(B+C<0){C=-B;}}h(this).bIsScrolledVerticallyByWheel=true;h(this).bIsScrolledVerticallyByKeyboard=false;j.updateScrollPosition(this,A+C,e.MOUSEWHEEL);}}},onTouchStart:function(o,a){if(a.type==="touchstart"||a.pointerType==="touch"){var s=this._getScrollExtension();var b=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=a.touches?a.touches[0]:a;h(this).mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v?v.scrollTop:0,initialScrollLeft:b?b.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(o,a){if(a.type!=="touchmove"&&a.pointerType!=="touch"){return;}var s=this._getScrollExtension();var t=h(this).mTouchSessionData;if(!t){return;}var b=a.touches?a.touches[0]:a;var i=(b.pageX-t.initialPageX);var n=(b.pageY-t.initialPageY);var p=false;if(!t.touchMoveDirection){if(i===0&&n===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(n)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var r=s.getHorizontalScrollbar();if(r&&(o.scrollDirection===d.HORIZONAL||o.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(i<0){t.initialScrolledToEnd=r.scrollLeft===r.scrollWidth-r.offsetWidth;}else{t.initialScrolledToEnd=r.scrollLeft===0;}}if(!t.initialScrolledToEnd){r.scrollLeft=t.initialScrollLeft-i;p=true;}}break;case"vertical":var v=s.getVerticalScrollbar();if(v&&(o.scrollDirection===d.VERTICAL||o.scrollDirection===d.BOTH)){if(t.initialScrolledToEnd==null){if(n<0){t.initialScrolledToEnd=v.scrollTop===v.scrollHeight-v.offsetHeight;}else{t.initialScrolledToEnd=v.scrollTop===0;}}if(!t.initialScrolledToEnd){j.updateScrollPosition(this,t.initialScrollTop-n,e.TOUCH);p=true;}}break;default:}if(p){a.preventDefault();}},addEventListeners:function(t){var s=t._getScrollExtension();var a=k.getEventListenerTargets(t);s._mMouseWheelEventListener=this.addMouseWheelEventListener(a,t,{scrollDirection:d.BOTH});s._mTouchEventListener=this.addTouchEventListener(a,t,{scrollDirection:d.BOTH});},addMouseWheelEventListener:function(a,t,o){var O=k.onMouseWheelScrolling.bind(t,o);for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",O);}return{wheel:O};},addTouchEventListener:function(a,t,o){var O=k.onTouchStart.bind(t,o);var b=k.onTouchMoveScrolling.bind(t,o);var n={};for(var i=0;i<a.length;i++){if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",O);a[i].addEventListener("pointermove",b,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",O);a[i].addEventListener("touchmove",b);}}if(D.support.pointer&&D.system.desktop){n={pointerdown:O,pointermove:b};}else if(D.support.touch){n={touchstart:O,touchmove:b};}return n;},removeEventListeners:function(t){var s=t._getScrollExtension();var a=k.getEventListenerTargets(t);function r(o,b){for(var n in b){var p=b[n];if(p){o.removeEventListener(n,p);}}}for(var i=0;i<a.length;i++){r(a[i],s._mMouseWheelEventListener);r(a[i],s._mTouchEventListener);}delete s._mMouseWheelEventListener;delete s._mTouchEventListener;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(o){return o!=null;});}};var E={onBeforeRendering:function(o){var s=this._getScrollExtension();var r=o!=null&&o.isMarked("renderRows");s._clearCache();if(!r){h(this).bVerticalScrollingSuspended=true;this.attachEventOnce("_rowsUpdated",function(){h(this).bVerticalScrollingSuspended=false;j.restoreScrollPosition(this);});}},onAfterRendering:function(o){var s=this._getScrollExtension();var r=o!=null&&o.isMarked("renderRows");if(r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}H.restoreScrollPosition(this);},onfocusin:function(o){var r;var C=c.getCellInfo(o.target);if(C.isOfType(c.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(c.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r&&C.columnIndex>=this.getComputedFixedColumnCount()){var a=this._getScrollExtension().getHorizontalScrollbar();var $=q(a);var b=C.cell[0];var i=this._bRtlMode?$.scrollLeftRTL():a.scrollLeft;var R=r.clientWidth;var n=b.offsetLeft;var p=n+b.offsetWidth;var O=n-i;var s=p-R-i;var N;if(O<0&&s<0){N=i+O;}else if(s>0&&O>0){N=i+s;}if(N!=null){if(this._bRtlMode){$.scrollLeftRTL(N);}else{a.scrollLeft=N;}}}var P=c.getParentCell(this,o.target);if(P){Promise.resolve().then(function(){var t=P.find(".sapUiTableCellInner");if(t.length>0){if(this._bRtlMode){t.scrollLeftRTL(t[0].scrollWidth-t[0].clientWidth);}else{t[0].scrollLeft=0;}t[0].scrollTop=0;}}.bind(this));}}};
var m=T.extend("sap.ui.table.TableScrollExtension",{
_init:function(t,s,a){this._delegate=E;t.addEventDelegate(this._delegate,t);return"ScrollExtension";},
_attachEvents:function(){var t=this.getTable();H.addEventListeners(t);j.addEventListeners(t);k.addEventListeners(t);},
_detachEvents:function(){var t=this.getTable();H.removeEventListeners(t);j.removeEventListeners(t);k.removeEventListeners(t);},
_debug:function(){this._ScrollingHelper=k;this._ExtensionDelegate=E;this._HorizontalScrollingHelper=H;this._VerticalScrollingHelper=j;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;this._clearCache();h.destroy(t);T.prototype.destroy.apply(this,arguments);}
});
m.prototype.scrollVertically=function(b,p,i,a,B){var t=this.getTable();if(!t){return false;}b=b===true;p=p===true;i=i===true;a=a===true;var s=false;var r=t._getTotalRowCount();var v=t.getVisibleRowCount();var n=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var F=t.getFirstVisibleRow();var o=p?n:1;if(b){if(F+v<r){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.min(F+o,r-v));},0);}else{t.setFirstVisibleRow(Math.min(F+o,r-v));}s=true;}}else if(F>0){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.max(F-o,0));},0);}else{t.setFirstVisibleRow(Math.max(F-o,0));}s=true;}if(s&&i){h(t).bIsScrolledVerticallyByKeyboard=true;}return s;};
m.prototype.scrollVerticallyMax=function(b,i){var t=this.getTable();if(!t){return false;}if(b==null){b=false;}if(i==null){i=false;}var s=false;var F=t.getFirstVisibleRow();if(b){var a=t._getTotalRowCount()-c.getNonEmptyVisibleRowCount(t);if(F<a){t.setFirstVisibleRow(a);s=true;}}else if(F>0){t.setFirstVisibleRow(0);s=true;}if(s&&i){h(t).bIsScrolledVerticallyByKeyboard=true;}return s;};
m.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t&&!t._bInvalid&&!h(t).oHorizontalScrollbar){h(t).oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return h(t).oHorizontalScrollbar||null;};
m.prototype.getVerticalScrollbar=function(){var t=this.getTable();if(t&&!t._bInvalid&&!h(t).oVerticalScrollbar){h(t).oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);if(!h(t).oVerticalScrollbar&&this.isVerticalScrollbarExternal()){h(t).oVerticalScrollbar=h(t).oExternalVerticalScrollbar;}}return h(t).oVerticalScrollbar||null;};
m.prototype.isHorizontalScrollbarVisible=function(){var o=this.getHorizontalScrollbar();return o!=null&&!o.classList.contains("sapUiTableHidden");};
m.prototype.isVerticalScrollbarVisible=function(){var v=this.getVerticalScrollbar();return v!=null&&!v.classList.contains("sapUiTableHidden");};
m.prototype.isVerticalScrollbarExternal=function(){return h(this.getTable()).bIsVerticalScrollbarExternal;};
m.prototype.markVerticalScrollbarAsExternal=function(s){if(s){h(this.getTable()).bIsVerticalScrollbarExternal=true;h(this.getTable()).oExternalVerticalScrollbar=s;}};
m.prototype.updateHorizontalScrollbar=function(t){var o=this.getTable();var a=this.getHorizontalScrollbar();if(!o||!a||!t){return;}var $=o.$();var C=t.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,o._getColumnsWidth(o.getComputedFixedColumnCount()));}var b=C>t.tableCtrlScrWidth;if(b){if(!this.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");a.classList.remove("sapUiTableHidden");if(D.browser.safari){var i=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");i.outerWidth(C);}}var s=t.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){s+=t.tableRowHdrScrWidth;}if(o._bRtlMode){a.style.marginRight=s+"px";a.style.marginLeft="";}else{a.style.marginLeft=s+"px";a.style.marginRight="";}var n=o.getDomRef("hsb-content");if(n){n.style.width=C+"px";}}if(!b&&this.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");a.classList.add("sapUiTableHidden");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}};
m.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var n=this.getVerticalScrollbarHeight();v.style.maxHeight=n+"px";if(h(t).iVerticalScrollbarHeight!==n){h(t).iVerticalScrollbarHeight=n;j.updateScrollPosition(t);}};
m.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(!t){return 0;}var s=Math.max(1,t.getVisibleRowCount()-t.getFixedRowCount()-t.getFixedBottomRowCount());return s*t._getDefaultRowHeight();};
m.prototype.updateVerticalScrollbarPosition=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var o=t.getDomRef("tableCCnt");if(o){var i=o.offsetTop;var a=t.getDomRef("vsb-bg");if(a){a.style.top=i+"px";}var F=t.getFixedRowCount();if(F>0){i+=t._iVsbTop;}v.style.top=i+"px";}};
m.prototype.updateVerticalScrollPosition=function(){j.updateScrollPosition(this.getTable(),undefined,e.TABLE);};
m.prototype.restoreVerticalScrollPosition=function(){j.restoreScrollPosition(this.getTable());};
m.prototype.updateVerticalScrollHeight=function(){var v=this.getVerticalScrollbar();var o=v?v.firstChild:null;if(!o){return;}var n=this.getVerticalScrollHeight(true);o.style.height=this.getVerticalScrollHeight()+"px";if(h(this.getTable()).iVerticalScrollHeight!==n){h(this.getTable()).iVerticalScrollHeight=n;j.updateScrollPosition(this.getTable());}};
m.prototype.getVerticalScrollHeight=function(b){var t=this.getTable();if(!t){return 0;}var i=t._getTotalRowCount();var v=t.getVisibleRowCount();var a=t._getDefaultRowHeight();var r;var s;if(c.isVariableRowHeightEnabled(t)){r=Math.max(i,v+1);s=a*(r-1)+j.getScrollRangeBuffer(t);}else{r=Math.max(i,v);s=a*r;}if(b===true){return s;}else{return Math.min(M,s);}};
m.prototype.updateVerticalScrollbarVisibility=function(){var t=this.getTable();var o=t?t.getDomRef():null;var v=this.getVerticalScrollbar();if(!o||!v){return;}var b=this.isVerticalScrollbarRequired();if(b&&!this.isVerticalScrollbarVisible()){if(!this.isVerticalScrollbarExternal()){o.classList.add("sapUiTableVScr");}v.classList.remove("sapUiTableHidden");}if(!b&&this.isVerticalScrollbarVisible()){o.classList.remove("sapUiTableVScr");v.classList.add("sapUiTableHidden");}};
m.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(!t){return false;}return j.getInnerScrollRange(t)>0||(t._getTotalRowCount()>t.getVisibleRowCount());};
m.prototype.updateInnerVerticalScrollPosition=function(){var t=this.getTable();var C=t?t.getDomRef("tableCCnt"):null;if(!c.isVariableRowHeightEnabled(t)||!C||j.isUpdatePending(t)){return;}if(t._getFirstRenderedRowIndex()!==t._iRenderedFirstVisibleRow){f("updateInnerVerticalScrollPosition: Skipped, because rows will be updated",t);return;}var a=j.getInnerScrollRange(t);if(a===0){f("updateInnerVerticalScrollPosition: 0",t);t.setFirstVisibleRow(0,true);this._nVerticalScrollPosition=0;C.scrollTop=0;return;}var F=t.getFirstVisibleRow();var n=j.getScrollPosition(t);var s=j.isScrollPositionInBuffer(t);var b=0;var o;var p;var r=null;var R=t._aRowHeights;if(!s){var u=j.getScrollRangeRowFraction(t);b=n-(F*u);o=R[0];p=Math.max(0,Math.min(b/u,1));r=Math.round(o*p);}else{var v=0;var w=0;var i;for(i=0;i<R.length&&w<a;i++){v++;w+=R[i];}var x=j.getScrollRange(t);var B=j.getScrollRangeBuffer(t);var y=B/v;if(h(t).iFirstVisibleRowInBuffer==null){b=n-x+B;var z=b/y;var A;if(Math.ceil(z)-z<0.00001){A=Math.ceil(b/y);}else{A=Math.floor(b/y);}A=Math.min(A,v);o=R[A]||0;p=Math.max(0,Math.min((b-(y*A))/y,1));for(i=0;i<A;i++){r+=R[i];}r+=o*p;r=Math.min(r,a);var N=t._getMaxFirstRenderedRowIndex()+A;if(N!==F){f("updateInnerVerticalScrollPosition: Set firstVisibleRow from "+F+" to "+N,t);t.setFirstVisibleRow(N,true);}}else{var G=x-B;b=h(t).iFirstVisibleRowInBuffer*y;var J=G+b;p=0;f("updateInnerVerticalScrollPosition: Set scroll position to "+J,t);j.updateScrollPosition(t,J);return;}}f("updateInnerVerticalScrollPosition: "+r+" of "+o+" ("+(p*100)+"%)"+" (in buffer: "+s+")",t);C.scrollTop=r;};
m.prototype.registerForMouseWheel=function(a,o){var t=this.getTable();if(T.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){return k.addMouseWheelEventListener(a,t,o);}else{L.error("This method can only be used with synchronization enabled.",t,"TableScrollExtension#registerForMouseWheel");return null;}};
m.prototype.registerForTouch=function(a,o){var t=this.getTable();if(T.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){return k.addTouchEventListener(a,t,o);}else{L.error("This method can only be used with synchronization enabled.",t,"TableScrollExtension#registerForTouch");return null;}};
m.prototype._clearCache=function(){h(this.getTable()).oVerticalScrollbar=null;h(this.getTable()).oHorizontalScrollbar=null;};
m.ScrollDirection=d;return m;});
sap.ui.predefine('sap/ui/table/TableSyncExtension',["./Table","./TableExtension","./TableUtils","./library","sap/base/Log"],function(T,a,b,l,L){"use strict";var E={setRowSelection:function(i,s){var t=this.getTable();var r=t.getRows()[i];if(r&&s!=null){b.toggleRowSelection(t,r.getIndex(),s);}},setRowHover:function(i,h){var t=this.getTable();var r=t.getRows()[i];if(r&&h!=null){r._setHovered(h);}},addVerticalScrollingListener:function(C){var t=this.getTable();var s=t._getScrollExtension();var S=s.constructor.ScrollDirection;if(C){s.registerForMouseWheel(C.wheelAreas,{scrollDirection:S.VERTICAL});s.registerForTouch(C.touchAreas,{scrollDirection:S.VERTICAL});}},placeVerticalScrollbarAt:function(h){var t=this.getTable();var s=t._getScrollExtension();if(!h){throw new Error("The HTMLElement in which the vertical scrollbar should be placed must be specified.");}if(!s.isVerticalScrollbarExternal()){var r=sap.ui.getCore().createRenderManager();t.getRenderer().renderVSbExternal(r,t);r.flush(h);var e=h.querySelector("#"+t.getId()+"-"+l.SharedDomRef.VerticalScrollBar);s.markVerticalScrollbarAsExternal(e);t.invalidate();}else{h.appendChild(s.getVerticalScrollbar());s.restoreVerticalScrollPosition();}},renderHorizontalScrollbar:function(r,i,s){var t=this.getTable();if(i==null){throw new Error("The id must be specified.");}t.getRenderer().renderHSbExternal(r,t,i,s);}};var c={onAfterRendering:function(e){var s=this._getScrollExtension();var r=e&&e.isMarked("renderRows");var C=this.getDomRef("tableCCnt");if(s.isVerticalScrollbarExternal()&&!r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}if(!r){C.addEventListener("scroll",function(e){this._getSyncExtension().syncInnerVerticalScrollPosition(e.target.scrollTop);}.bind(this));}}};
var d=a.extend("sap.ui.table.TableSyncExtension",{
_init:function(t,s,S){this._delegate=c;this._oPublicInterface={syncRowSelection:E.setRowSelection.bind(this),syncRowHover:E.setRowHover.bind(this),registerVerticalScrolling:E.addVerticalScrollingListener.bind(this),placeVerticalScrollbarAt:E.placeVerticalScrollbarAt.bind(this),renderHorizontalScrollbar:E.renderHorizontalScrollbar.bind(this)};t.addEventDelegate(this._delegate,t);return"SyncExtension";},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;this._oPublicInterface=null;a.prototype.destroy.apply(this,arguments);}
});
d.prototype.syncRowCount=function(C){this.callInterfaceHook("rowCount",arguments);};
d.prototype.syncRowSelection=function(i,s){this.callInterfaceHook("rowSelection",arguments);};
d.prototype.syncRowHover=function(i,h){this.callInterfaceHook("rowHover",arguments);};
d.prototype.syncRowHeights=function(h){return this.callInterfaceHook("rowHeights",arguments);};
d.prototype.syncInnerVerticalScrollPosition=function(s){this.callInterfaceHook("innerVerticalScrollPosition",arguments);};
d.prototype.syncLayout=function(m){this.callInterfaceHook("layout",arguments);};
d.prototype.callInterfaceHook=function(h,A){var C={};C[h]=Array.prototype.slice.call(A);L.debug("sap.ui.table.TableSyncExtension","Sync "+h+"("+C[h]+")",this.getTable());return b.dynamicCall(this._oPublicInterface,C);};
d.prototype.getInterface=function(){return this._oPublicInterface;};
return d;});
sap.ui.predefine('sap/ui/table/TableUtils',["sap/ui/base/Object","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/ui/core/theming/Parameters","sap/ui/model/ChangeReason","./TableGrouping","./TableColumnUtils","./TableMenuUtils","./TableBindingUtils","./library","sap/base/Log","sap/ui/thirdparty/jquery"],function(B,C,R,c,T,a,b,d,e,f,l,L,q){"use strict";var S=l.SelectionBehavior;var g=l.SelectionMode;var M=c.MessageType;var r;var h=null;var j={DATACELL:1,COLUMNHEADER:2,ROWHEADER:4,ROWACTION:8,COLUMNROWHEADER:16};j.ANYCONTENTCELL=j.ROWHEADER|j.DATACELL|j.ROWACTION;j.ANYCOLUMNHEADER=j.COLUMNHEADER|j.COLUMNROWHEADER;j.ANYROWHEADER=j.ROWHEADER|j.COLUMNROWHEADER;j.ANY=j.ANYCONTENTCELL|j.ANYCOLUMNHEADER;var m={sapUiSizeCozy:48,sapUiSizeCompact:32,sapUiSizeCondensed:24,undefined:32};var k=1;var n=1;var D={sapUiSizeCozy:m.sapUiSizeCozy+n,sapUiSizeCompact:m.sapUiSizeCompact+n,sapUiSizeCondensed:m.sapUiSizeCondensed+n,undefined:m.undefined+n};var o={Render:"Render",VerticalScroll:"VerticalScroll",FirstVisibleRowChange:"FirstVisibleRowChange",Unbind:"Unbind",Animation:"Animation",Resize:"Resize",Unknown:"Unknown"};for(var p in a){o[p]=a[p];}var I=":sapTabbable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)";var s={Grouping:b,Column:d,Menu:e,Binding:f,CELLTYPE:j,BaseSize:m,BaseBorderWidth:k,RowHorizontalFrameSize:n,DefaultRowHeight:D,RowsUpdateReason:o,INTERACTIVE_ELEMENT_SELECTORS:I,hasRowHeader:function(t){return(t.getSelectionMode()!==g.None&&t.getSelectionBehavior()!==S.RowOnly)||b.isGroupMode(t);},hasSelectAll:function(t){var i=t?t.getSelectionMode():g.None;return i===g.MultiToggle&&t.getEnableSelectAll();},hasRowHighlights:function(t){if(!t){return false;}var i=t.getRowSettingsTemplate();if(!i){return false;}var H=i.getHighlight();return i.isBound("highlight")||(H!=null&&H!==M.None);},getRowActionCount:function(t){var i=t.getRowActionTemplate();return i?i._getCount():0;},hasRowActions:function(t){var i=t.getRowActionTemplate();return i!=null&&(i.isBound("visible")||i.getVisible())&&s.getRowActionCount(t)>0;},isRowSelectionAllowed:function(t){return t.getSelectionMode()!==g.None&&(t.getSelectionBehavior()===S.Row||t.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(t){return t.getSelectionMode()!==g.None&&s.hasRowHeader(t);},areAllRowsSelected:function(t){if(!t){return false;}var i=t._getSelectableRowCount();return i>0&&i===t._getSelectedIndicesCount();},isNoDataVisible:function(t){if(!t.getShowNoData()){return false;}return!s.hasData(t);},hasData:function(t){var i=t.getBinding("rows");var u=t._getTotalRowCount();var H=u>0;if(i&&i.providesGrandTotal){var v=i.providesGrandTotal()&&i.hasTotaledMeasures();H=(v&&u>1)||(!v&&u>0);}return H;},isBusyIndicatorVisible:function(t){if(!t||!t.getDomRef()){return false;}return t.getDomRef().querySelector(".sapUiTableCnt > .sapUiLocalBusyIndicator")!=null;},hasPendingRequests:function(t){if(!t){return false;}if(s.canUsePendingRequestsCounter(t)){return t._iPendingRequests>0;}else{return t._bPendingRequest;}},canUsePendingRequestsCounter:function(t){var i=t?t.getBinding("rows"):null;if(s.isA(i,"sap.ui.model.analytics.AnalyticalBinding")){return i.bUseBatchRequests;}else if(s.isA(i,"sap.ui.model.TreeBinding")){return false;}return true;},isA:function(O,t){return B.isA(O,t);},toggleRowSelection:function(t,v,i,u){if(!t||!t.getBinding("rows")||t.getSelectionMode()===g.None||v==null){return false;}function w(A){if(!t._isRowSelectable(A)){return false;}t._iSourceRowIndex=A;var z=false;if(u){z=u(A,i);}else if(t.isIndexSelected(A)){if(i!==true){z=true;t.removeSelectionInterval(A,A);}}else if(i!==false){z=true;t.addSelectionInterval(A,A);}delete t._iSourceRowIndex;return z;}if(typeof v==="number"){if(v<0||v>=t._getTotalRowCount()){return false;}return w(v);}else{var $=q(v);var x=s.getCellInfo($[0]);var y=s.isRowSelectionAllowed(t);if(!s.Grouping.isInGroupingRow($[0])&&((x.isOfType(s.CELLTYPE.DATACELL|s.CELLTYPE.ROWACTION)&&y)||(x.isOfType(s.CELLTYPE.ROWHEADER)&&s.isRowSelectorSelectionAllowed(t)))){var A;if(x.isOfType(s.CELLTYPE.DATACELL)){A=t.getRows()[parseInt($.closest("tr",t.getDomRef()).attr("data-sap-ui-rowindex"))].getIndex();}else{A=t.getRows()[parseInt($.attr("data-sap-ui-rowindex"))].getIndex();}return w(A);}return false;}},getNoDataText:function(t){var N=t.getNoData();if(N instanceof C){return null;}else if(typeof N==="string"||t.getNoData()instanceof String){return N;}else{return s.getResourceText("TBL_NO_DATA");}},getVisibleColumnCount:function(t){return t._getVisibleColumns().length;},getHeaderRowCount:function(t){if(t._iHeaderRowCount===undefined){if(!t.getColumnHeaderVisible()){t._iHeaderRowCount=0;}else{var H=1;var u=t.getColumns();for(var i=0;i<u.length;i++){if(u[i].shouldRender()){H=Math.max(H,u[i].getMultiLabels().length);}}t._iHeaderRowCount=H;}}return t._iHeaderRowCount;},isVariableRowHeightEnabled:function(t){return t&&t._bVariableRowHeightEnabled&&t.getFixedRowCount()<=0&&t.getFixedBottomRowCount()<=0;},getTotalRowCount:function(t,i){var u=t._getTotalRowCount();if(i){u=Math.max(u,t.getVisibleRowCount());}return u;},getNonEmptyVisibleRowCount:function(t){return Math.min(t.getVisibleRowCount(),t._getTotalRowCount());},getFocusedItemInfo:function(t){var i=t._getItemNavigation();if(!i){return null;}return{cell:i.getFocusedIndex(),columnCount:i.iColumns,cellInRow:i.getFocusedIndex()%i.iColumns,row:Math.floor(i.getFocusedIndex()/i.iColumns),cellCount:i.getItemDomRefs().length,domRef:i.getFocusedDomRef()};},getRowIndexOfFocusedCell:function(t){var i=s.getFocusedItemInfo(t);return i.row-s.getHeaderRowCount(t);},isFixedColumn:function(t,i){return i<t.getComputedFixedColumnCount();},hasFixedColumns:function(t){return t.getComputedFixedColumnCount()>0;},focusItem:function(t,i,E){var u=t._getItemNavigation();if(u){u.focusItem(i,E);}},getCellInfo:function(i){var t;var $=q(i);var u;var v;var w;var x;var y;t={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};if($.hasClass("sapUiTableDataCell")){u=$.data("sap-ui-colid");v=sap.ui.getCore().byId(u);t.type=s.CELLTYPE.DATACELL;t.rowIndex=parseInt($.parent().data("sap-ui-rowindex"));t.columnIndex=v.getIndex();t.columnSpan=1;}else if($.hasClass("sapUiTableHeaderDataCell")){w=/_([\d]+)/;u=$.attr("id");x=w.exec(u);y=x&&x[1]!=null?parseInt(x[1]):0;t.type=s.CELLTYPE.COLUMNHEADER;t.rowIndex=y;t.columnIndex=parseInt($.data("sap-ui-colindex"));t.columnSpan=parseInt($.attr("colspan")||1);}else if($.hasClass("sapUiTableRowSelectionCell")){t.type=s.CELLTYPE.ROWHEADER;t.rowIndex=parseInt($.data("sap-ui-rowindex"));t.columnIndex=-1;t.columnSpan=1;}else if($.hasClass("sapUiTableRowActionCell")){t.type=s.CELLTYPE.ROWACTION;t.rowIndex=parseInt($.data("sap-ui-rowindex"));t.columnIndex=-2;t.columnSpan=1;}else if($.hasClass("sapUiTableRowSelectionHeaderCell")){t.type=s.CELLTYPE.COLUMNROWHEADER;t.columnIndex=-1;t.columnSpan=1;}if(t.type!==0){t.cell=$;}t.isOfType=function(z){if(z==null){return false;}return(this.type&z)>0;};return t;},getRowColCell:function(t,u,v,w){var x=u>=0&&u<t.getRows().length?t.getRows()[u]:null;var y=w?t.getColumns():t._getVisibleColumns();var z=v>=0&&v<y.length?y[v]:null;var A=null;if(x&&z){if(w){if(z.shouldRender()){var V=t._getVisibleColumns();for(var i=0;i<V.length;i++){if(V[i]===z){A=x.getCells()[i];break;}}}}else{A=x.getCells()[v];}if(A&&A.data("sap-ui-colid")!=z.getId()){var E=x.getCells();for(var i=0;i<E.length;i++){if(E[i].data("sap-ui-colid")===z.getId()){A=E[i];break;}}}}return{row:x,column:z,cell:A};},getCell:function(t,E){if(!t||!E){return null;}var $=q(E);var i=t.getDomRef();var u=$.closest(".sapUiTableCell",i);if(u.length>0){return u;}return null;},getParentCell:function(t,E){var $=q(E);var i=s.getCell(t,E);if(!i||i[0]===$[0]){return null;}else{return i;}},registerResizeHandler:function(t,i,H,u){var v;if(typeof i=="string"){v=t.getDomRef(i);}else{L.error("sIdSuffix must be a string",t);return;}if(typeof H!=="function"){L.error("fnHandler must be a function",t);return;}s.deregisterResizeHandler(t,i);if(!t._mResizeHandlerIds){t._mResizeHandlerIds={};}if(u&&v){v=v.parentNode;}if(v){t._mResizeHandlerIds[i]=R.register(v,H);}return t._mResizeHandlerIds[i];},deregisterResizeHandler:function(t,v){var u;if(!t._mResizeHandlerIds){return;}if(typeof v=="string"){u=[v];}else if(v===undefined){u=[];for(var K in t._mResizeHandlerIds){if(typeof K=="string"&&t._mResizeHandlerIds.hasOwnProperty(K)){u.push(K);}}}else if(Array.isArray(v)){u=v;}for(var i=0;i<u.length;i++){var w=u[i];if(t._mResizeHandlerIds[w]){R.deregister(t._mResizeHandlerIds[w]);t._mResizeHandlerIds[w]=undefined;}}},isFirstScrollableRow:function(t,i){if(isNaN(i)){var $=q(i);i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"));}var F=t.getFixedRowCount()||0;return i==F;},isLastScrollableRow:function(t,i){if(isNaN(i)){var $=q(i);i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"));}var F=t.getFixedBottomRowCount()||0;return i==t.getVisibleRowCount()-F-1;},getContentDensity:function(t){var u;var v=["sapUiSizeCondensed","sapUiSizeCompact","sapUiSizeCozy"];var G=function(F,O){if(!O[F]){return;}for(var i=0;i<v.length;i++){if(O[F](v[i])){return v[i];}}};var $=t.$();if($.length>0){u=G("hasClass",$);}else{u=G("hasStyleClass",t);}if(u){return u;}var P=null;var w=t.getParent();if(w){do{u=G("hasStyleClass",w);if(u){return u;}if(w.getDomRef){P=w.getDomRef();}else if(w.getRootNode){P=w.getRootNode();}if(!P&&w.getParent){w=w.getParent();}else{w=null;}}while(w&&!P);}$=q(P||document.body);u=G("hasClass",$.closest("."+v.join(",.")));return u;},isVariableWidth:function(w){return!w||w=="auto"||w.toString().match(/%$/);},getFirstFixedBottomRowIndex:function(t){var F=t.getFixedBottomRowCount();var i=t.getBinding("rows");var u=-1;if(i&&F>0){var v=t.getVisibleRowCount();var w=t.getFirstVisibleRow();var x=t._getTotalRowCount();if(x>=v){u=v-F;}else{var y=x-F-w;if(y>=0&&(w+y)<x){u=y;}}}return u;},getResourceBundle:function(O){O=q.extend({async:false,reload:false},O);if(r&&O.reload!==true){if(O.async===true){return Promise.resolve(r);}else{return r;}}var v=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table",O.async===true);if(v instanceof Promise){v=v.then(function(i){r=i;return r;});}else{r=v;}return v;},getResourceText:function(K,v){return r?r.getText(K,v):"";},dynamicCall:function(O,v,t){var i=O instanceof Function?O():O;if(!i||!v){return undefined;}t=t||i;if(v instanceof Function){v.call(t,i);return undefined;}else{var P;var u=[];for(var F in v){if(i[F]instanceof Function){P=v[F];u.push(i[F].apply(t,P));}else{u.push(undefined);}}if(u.length===1){return u[0];}else{return u;}}},throttle:function(i,O){O=Object.assign({wait:0,leading:true},O);O.maxWait=O.wait;O.trailing=true;O.requestAnimationFrame=false;return s.debounce(i,O);},debounce:function(i,O){O=Object.assign({wait:0,maxWait:null,leading:false,asyncLeading:false,trailing:true,requestAnimationFrame:false},O);var t=null;var u=null;var v=null;var w=O.maxWait!=null;O.wait=Math.max(0,O.wait);O.maxWait=w?Math.max(O.maxWait,O.wait):O.maxWait;function x(H,J,K,N){t=N===true?null:Date.now();if(J==null){return;}if(K===true){var P=Promise.resolve().then(function(){if(!P.canceled){i.apply(H,J);}v=null;});P.cancel=function(){P.canceled=true;};v=P;}else{i.apply(H,J);}}function y(H,J){z();function _(U){U=U!==false;if(U){E();}if(O.trailing){x(H,J,null,U);}}if(O.requestAnimationFrame){u=window.requestAnimationFrame(function(){_();});}else{var N=Date.now();var K=t==null?0:N-t;var P=Math.max(0,w?Math.min(O.maxWait-K,O.wait):O.wait);var Q=P<O.wait;u=setTimeout(function(){if(Q){var U=Math.max(0,(Date.now()-N)-P);var V=O.wait-P;if(U>V){_();}else{u=setTimeout(E,V-U);_(false);}}else{_();}},P);}}function z(){if(O.requestAnimationFrame){window.cancelAnimationFrame(u);}else{clearTimeout(u);}u=null;}function A(){if(v){v.cancel();v=null;}}function E(){z();A();t=null;}function F(){return u!=null;}var G=function(){if(!F()&&!O.leading){x();}if(F()||!O.leading){y(this,arguments);}else if(O.asyncLeading){x(this,arguments,true);y();}else{y();x(this,arguments);}};G.cancel=E;G.pending=F;return G;},getInteractiveElements:function(i){if(!i){return null;}var $=q(i);var t=s.getCellInfo($);if(t.isOfType(j.DATACELL|j.ROWACTION)){var u=$.find(I);if(u.length>0){return u;}}return null;},convertCSSSizeToPixel:function(i,w){var P;if(typeof i!=="string"){return null;}if(i.endsWith("px")){P=parseInt(i);}else if(i.endsWith("em")||i.endsWith("rem")){P=Math.ceil(parseFloat(i)*s.getBaseFontSize());}else{return null;}if(w){return P+"px";}else{return P;}},getBaseFontSize:function(){if(h==null){var i=document.documentElement;if(i){h=parseInt(window.getComputedStyle(i).fontSize);}}return h==null?16:h;},readThemeParameters:function(){function i(t){return s.convertCSSSizeToPixel(T.get(t));}m.undefined=i("_sap_ui_table_BaseSize");m.sapUiSizeCozy=i("_sap_ui_table_BaseSizeCozy");m.sapUiSizeCompact=i("_sap_ui_table_BaseSizeCompact");m.sapUiSizeCondensed=i("_sap_ui_table_BaseSizeCondensed");k=i("_sap_ui_table_BaseBorderWidth");n=k;D.undefined=m.undefined+n;D.sapUiSizeCozy=m.sapUiSizeCozy+n;D.sapUiSizeCompact=m.sapUiSizeCompact+n;D.sapUiSizeCondensed=m.sapUiSizeCondensed+n;}};b.TableUtils=s;d.TableUtils=s;e.TableUtils=s;f.TableUtils=s;return s;},true);
sap.ui.predefine('sap/ui/table/TreeTable',['./Table',"./TableRenderer",'sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./library','sap/ui/core/Element','./TableUtils',"./BindingSelectionAdapter","sap/base/Log","sap/base/assert"],function(T,a,C,b,l,E,c,B,L,d){"use strict";
var e=T.extend("sap.ui.table.TreeTable",{
metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false,deprecated:true},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},rootLevel:{type:"int",group:"Data",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},
renderer:"sap.ui.table.TableRenderer"
});
e.prototype.init=function(){T.prototype.init.apply(this,arguments);c.Grouping.setTreeMode(this);this._initSelectionAdapter();};
e.prototype._initSelectionAdapter=function(){this._oSelectionAdapter=new B();this._oSelectionAdapter.attachEvent("selectionChange",this._onSelectionChanged,this);};
e.prototype.bindRows=function(o){o=T._getSanitizedBindingInfo(arguments);if(o){if(!o.parameters){o.parameters={};}o.parameters.rootLevel=this.getRootLevel();o.parameters.collapseRecursive=this.getCollapseRecursive();o.parameters.numberOfExpandedLevels=o.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0);}return T.prototype.bindRows.call(this,o);};
e.prototype._bindAggregation=function(n,o){T.prototype._bindAggregation.call(this,n,o);var f=this.getBinding("rows");if(n==="rows"&&f){f.attachEvents({selectionChanged:this._onSelectionChanged.bind(this)});}};
e.prototype.setFixedRowCount=function(r){L.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};
e.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return E.prototype.isTreeBinding.apply(this,arguments);};
e.prototype.getBinding=function(n){n=n||"rows";var o=E.prototype.getBinding.call(this,n);if(o&&n==="rows"&&!o.getLength){if(o.isA("sap.ui.model.odata.ODataTreeBinding")){b(o,this);}else if(o.isA("sap.ui.model.odata.v2.ODataTreeBinding")){o.applyAdapterInterface();}else if(o.isA("sap.ui.model.ClientTreeBinding")){C.apply(o);}else{L.error("Binding not supported by sap.ui.table.TreeTable");}}return o;};
e.prototype._getContexts=function(s,i,t){var o=this.getBinding("rows");if(o){return o.getNodes(s,i,t);}else{return[];}};
e.prototype._onGroupHeaderChanged=function(r,f){this.fireToggleOpenState({rowIndex:r,rowContext:this.getContextByIndex(r),expanded:f});};
e.prototype.expand=function(r){c.Grouping.toggleGroupHeader(this,r,true);return this;};
e.prototype.collapse=function(r){c.Grouping.toggleGroupHeader(this,r,false);return this;};
e.prototype.collapseAll=function(){var o=this.getBinding("rows");if(o){o.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
e.prototype.expandToLevel=function(i){var o=this.getBinding("rows");d(o&&o.expandToLevel,"TreeTable.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.");if(o&&o.expandToLevel){o.expandToLevel(i);}return this;};
e.prototype.isExpanded=function(r){var o=this.getBinding("rows");if(o){return o.isExpanded(r);}return false;};
e.prototype.getContextByIndex=function(r){var o=this.getBinding("rows");if(o){return o.getContextByIndex(r);}};
e.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var o=this.getBinding("rows");if(o){d(o.setRootLevel,"rootLevel is not supported by the used binding");if(o.setRootLevel){o.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};
e.prototype.setCollapseRecursive=function(f){var o=this.getBinding("rows");if(o){d(o.setCollapseRecursive,"Collapse Recursive is not supported by the used binding");if(o.setCollapseRecursive){o.setCollapseRecursive(f);}}this.setProperty("collapseRecursive",!!f,true);return this;};
e.prototype.setUseGroupMode=function(g){this.setProperty("useGroupMode",!!g);if(!!g){c.Grouping.setGroupMode(this);}else{c.Grouping.setTreeMode(this);}return this;};
e.prototype.setEnableGrouping=function(){L.warning("The property enableGrouping is not supported by the sap.ui.table.TreeTable control");return this;};
e.prototype.setGroupBy=function(){L.warning("The groupBy association is not supported by the sap.ui.table.TreeTable control");return this;};
e.prototype.setUseFlatMode=function(f){f=!!f;if(f!=this._bFlatMode){this._bFlatMode=f;if(this.getDomRef()&&c.Grouping.isTreeMode(this)){this.invalidate();}}return this;};
return e;});
sap.ui.predefine('sap/ui/table/TreeTableRenderer',['sap/ui/table/TreeTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/library',['sap/ui/core/Core','sap/ui/model/TreeAutoExpandMode','sap/ui/core/library','sap/ui/unified/library'],function(C,T){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.63.0",dependencies:["sap.ui.core","sap.ui.unified"],designtime:"sap/ui/table/designtime/library.designtime",types:["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.SharedDomRef","sap.ui.table.TreeAutoExpandMode"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings"],extensions:{flChangeHandlers:{"sap.ui.table.Column":{"propertyChange":"default"},"sap.ui.table.Table":{"moveElements":"default"},"sap.ui.table.AnalyticalTable":{"moveElements":"default"}},"sap.ui.support":{publicRules:true}}});var t=sap.ui.table;t.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};t.RowActionType={Custom:"Custom",Navigation:"Navigation",Delete:"Delete"};t.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};t.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};t.SortOrder={Ascending:"Ascending",Descending:"Descending"};t.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};t.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};t.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};t.ColumnHeader=t.Column;t.TreeAutoExpandMode=T;if(!t.TableHelper){t.TableHelper={addTableClass:function(){return"";},createLabel:function(c){throw new Error("no Label control available!");},createTextView:function(c){throw new Error("no TextView control available!");},bFinal:false};}return t;});
sap.ui.require.preload({
	"sap/ui/table/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.table","type":"library","embeds":[],"applicationVersion":{"version":"1.63.0"},"title":"Table-like controls, mainly for desktop scenarios.","description":"Table-like controls, mainly for desktop scenarios.","ach":"CA-UI5-TBL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.63","libs":{"sap.ui.core":{"minVersion":"1.63.0"},"sap.ui.unified":{"minVersion":"1.63.0"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],"elements":["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings"],"types":["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.SharedDomRef","sap.ui.table.TreeAutoExpandMode"],"interfaces":[]}}}}'
},"sap/ui/table/library-preload"
);
//# sourceMappingURL=library-preload.js.map