#ifndef CPYCPPYY_CPPMETHOD_H
#define CPYCPPYY_CPPMETHOD_H

// Bindings
#include "PyCallable.h"

// Standard
#include <string>
#include <vector>


namespace CPyCppyy {

class Executor;
class Converter;

class CPPMethod : public PyCallable {
public:
    CPPMethod(Cppyy::TCppScope_t scope, Cppyy::TCppMethod_t method);
    CPPMethod(const CPPMethod&);
    CPPMethod& operator=(const CPPMethod&);
    virtual ~CPPMethod();

public:
    virtual PyObject* GetSignature(bool show_formalargs = true);
    virtual PyObject* GetPrototype(bool show_formalargs = true);
    virtual int       GetPriority();

    virtual int       GetMaxArgs();
    virtual PyObject* GetCoVarNames();
    virtual PyObject* GetArgDefault(int iarg);
    virtual PyObject* GetScopeProxy();
    virtual Cppyy::TCppFuncAddr_t GetFunctionAddress();

    virtual PyCallable* Clone() { return new CPPMethod(*this); }

public:
    virtual PyObject* Call(
        CPPInstance*& self, PyObject* args, PyObject* kwds, CallContext* ctxt = nullptr);

    virtual bool      Initialize(CallContext* ctxt = nullptr);
    virtual PyObject* PreProcessArgs(CPPInstance*& self, PyObject* args, PyObject* kwds);
    virtual bool      ConvertAndSetArgs(PyObject* args, CallContext* ctxt = nullptr);
    virtual PyObject* Execute(void* self, ptrdiff_t offset, CallContext* ctxt = nullptr);

protected:
    Cppyy::TCppMethod_t GetMethod()   { return fMethod; }
    Cppyy::TCppScope_t  GetScope()    { return fScope; }
    Executor*           GetExecutor() { return fExecutor; }
    std::string         GetSignatureString(bool show_formalargs = true);
    std::string         GetReturnTypeName();

    virtual bool InitExecutor_(Executor*&, CallContext* ctxt = nullptr);

private:
    void Copy_(const CPPMethod&);
    void Destroy_() const;

    PyObject* CallFast(void*, ptrdiff_t, CallContext*);
    PyObject* CallSafe(void*, ptrdiff_t, CallContext*);

    bool InitConverters_();

    void SetPyError_(PyObject* msg);

private:
// representation
    Cppyy::TCppMethod_t fMethod;
    Cppyy::TCppScope_t  fScope;
    Executor*           fExecutor;

// call dispatch buffers
    std::vector<Converter*> fConverters;

// cached values
    int  fArgsRequired;

// admin
    bool fIsInitialized;
};

} // namespace CPyCppyy

#endif // !CPYCPPYY_CPPMETHOD_H
