/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/base/ManagedObjectObserver',['jquery.sap.global','sap/ui/base/Object','sap/ui/base/ManagedObject','sap/ui/base/EventProvider','jquery.sap.script'],function(q,B,M,E){"use strict";
var a=B.extend("sap.ui.base.ManagedObjectObserver",{constructor:function(C){if(!C&&typeof C!=="function"){throw new Error("Missing callback function in ManagedObjectObserver constructor");}this._fnCallback=C;}});
a.prototype.observe=function(o,C){if(!(o instanceof M)){if(o==null){return;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but observe was called for "+o);}m(o,C);c(o,this,C);};
a.prototype.unobserve=function(o,C){if(!(o instanceof M)){if(o==null){return;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but unobserve was called for "+o);}if(C){m(o,C);}r(o,this,C);};
a.prototype.isObserved=function(o,C){if(!(o instanceof M)){if(o==null){return false;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but isObserved was called for "+o);}return d(o,this,C);};
a.prototype.disconnect=function(){e(this);};
a.prototype.getConfiguration=function(o){return g(o,this);};
var O={},t=Object.create(null);
O.propertyChange=function(o,n,v,N){h("properties",o,n,function(){return{type:"property",old:v,current:N};});};
O.aggregationChange=function(o,n,s,v){h("aggregations",o,n,function(){return{type:"aggregation",mutation:s,children:Array.isArray(v)?v:null,child:!Array.isArray(v)?v:null};});};
O.associationChange=function(o,n,s,i){h("associations",o,n,function(){return{type:"association",mutation:s,ids:i};});};
O.eventChange=function(o,n,s,L,F,D){h("events",o,n,function(){return{type:"event",mutation:s,listener:L,func:F,data:D};});};
O.bindingChange=function(o,n,s,i,p){h("bindings",o,n,function(){return{type:"binding",mutation:s,bindingInfo:i,memberType:p};});};
O.objectDestroyed=function(o){h("destroy",o,null,function(){return{type:"destroy"};});var i=o.getId();if(t[i]){o.detachEvent("EventHandlerChange",H);delete t[i];}delete o._observer;};
function h(T,o,n,C){var I=o.getId(),p=t[I];if(p){var s;for(var i=0;i<p.listeners.length;i++){if(b(p.configurations[i],T,n)){if(!s){s=C();s.name=n;s.object=o;}var L=p.listeners[i];L._fnCallback(s);}}}}
function b(C,T,n){if(C==null||!T){return false;}if(T!="destroy"&&!n){return false;}return C[T]===true||(Array.isArray(C[T])&&C[T].indexOf(n)>-1);}
function c(T,L,C){u(T,L,C,false);}
function g(T,L){var i=T.getId();var o=t[i];if(o&&o.listeners){var I=o.listeners.indexOf(L);if(I>=0){var C=q.extend(true,{},o.configurations[I]);return C;}}return null;}
function r(T,L,C){C=C||g(T,L);u(T,L,C,true);}
function d(T,L,C){var i=T.getId(),o=t[i];C=C||g(T,L);if(!o){return false;}var I=o.listeners.indexOf(L);if(I===-1){return false;}else{return k(o.configurations[I].properties,C.properties)&&k(o.configurations[I].aggregations,C.aggregations)&&k(o.configurations[I].associations,C.associations)&&k(o.configurations[I].bindings,C.bindings)&&k(o.configurations[I].events,C.events)&&l(o.configurations[I].destroy,C.destroy);}}
function e(L){for(var n in t){var T=t[n];for(var i=0;i<T.listeners.length;i++){if(T.listeners[i]===L){T.listeners.splice(i,1);T.configurations.splice(i,1);}}if(T.listeners&&T.listeners.length===0){delete t[n];T.object._observer=undefined;}}}
function u(T,L,C,R){var i=T.getId(),o=t[i],n,I;if(R){if(!o){return;}I=o.listeners.indexOf(L);if(I>=0){n=o.configurations[I];}}else{if(!o){o=t[i]={listeners:[],configurations:[],object:T};}I=o.listeners.indexOf(L);if(I===-1){o.listeners.push(L);o.configurations.push(C);}else{n=o.configurations[I];}}if(n){n.properties=n.properties||[];j(n.properties,C.properties,R);n.aggregations=n.aggregations||[];j(n.aggregations,C.aggregations,R);n.associations=n.associations||[];j(n.associations,C.associations,R);n.bindings=n.bindings||[];j(n.bindings,C.bindings,R);n.events=n.events||[];j(n.events,C.events,R);if(C.destroy!=null){if(R){delete n.destroy;}else{n.destroy=C.destroy;}}}var p=f(T,"events");if(T._observer&&R){if(!p&&E.hasListener(T,"EventHandlerChange",H)){T.detachEvent("EventHandlerChange",H);}if(!p&&!f(T,"properties")&&!f(T,"aggregations")&&!f(T,"associations")&&!f(T,"destroy")&&!f(T,"bindings")){delete T._observer;delete t[i];}}else if(!T._observer&&!R){if(p&&!E.hasListener(T,"EventHandlerChange",H)){T.attachEvent("EventHandlerChange",H);}T._observer=O;}}
function f(T,s){var i=T.getId(),o=t[i];if(o){var C=o.configurations.filter(function(n){return n.hasOwnProperty(s)&&n[s]&&(n[s]===true||n[s].length>0);});return C.length>0;}return false;}
function H(o){var T=o.getSource(),s=o.mParameters.EventId;if(T.getMetadata().hasEvent(s)){if(o.mParameters.type==="listenerAttached"){O.eventChange(T,s,"insert",o.mParameters.listener,o.mParameters.func,o.mParameters.data);}else if(o.mParameters.type==="listenerDetached"){O.eventChange(T,s,"remove",o.mParameters.listener,o.mParameters.func,o.mParameters.data);}}}
function j(o,A,R){if(!A){return;}for(var i=0;i<A.length;i++){var I=o.indexOf(A[i]);if(I>-1&&R){o.splice(I,1);}else if(I===-1&&!R){o.push(A[i]);}}}
function k(F,s){if(!Array.isArray(s)||s.length==0){return true;}if(!Array.isArray(F)||F.length==0){return false;}var U=q.sap.unique(F.concat(s));return F.length===U.length;}
function l(o,C){if(C==null){return true;}return o===C;}
function m(o,C){var i=o.getMetadata(),p=Object.keys(i.getAllProperties()),A=Object.keys(i.getAllAggregations()),n=Object.keys(i.getAllAssociations()),s=q.sap.unique(p.concat(A)),v=Object.keys(i.getAllEvents());C.properties=C.properties===true?p:C.properties;C.aggregations=C.aggregations===true?A:C.aggregations;C.associations=C.associations===true?n:C.associations;C.bindings=C.bindings===true?s:C.bindings;C.events=C.events===true?v:C.events;C.destroy=(C.destroy==null)?false:C.destroy;}
return a;});
sap.ui.predefine('sap/ui/model/base/ManagedObjectModel',['jquery.sap.global','../json/JSONModel','../json/JSONPropertyBinding','../json/JSONListBinding','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','../Context','../ChangeReason'],function(q,J,a,b,M,c,C,d){"use strict";var e=b.extend("sap.ui.model.base.ManagedObjectModelAggregationBinding"),f=a.extend("sap.ui.model.base.ManagedObjectModelPropertyBinding"),g="@custom",I="--";
var h=J.extend("sap.ui.model.base.ManagedObjectModel",{constructor:function(o,D){if(!D&&typeof D!="object"){D={};}D[g]={};this._oObject=o;this._mObservedCount={properties:{},aggregations:{}};this.mListBinding={};J.apply(this,[D]);this._oObserver=new c(this.observerChanges.bind(this));}});
h.prototype.getAggregation=J.prototype.getProperty;
h.prototype.setData=function(D,m){var _={};_[g]=D;J.prototype.setData.apply(this,[_,m]);};
h.prototype.getJSON=function(){return JSON.stringify(this.oData[g]);};
h.prototype.setProperty=function(p,v,o,A){var r=this.resolve(p,o),l,O,P;if(!r){return false;}if(r.indexOf("/"+g)===0){return J.prototype.setProperty.apply(this,arguments);}l=r.lastIndexOf("/");O=r.substring(0,l||1);P=r.substr(l+1);var i=this._getObject(O);if(i){if(i instanceof M){var j=i.getMetadata().getProperty(P);if(j){var s=j._sMutator,G=j._sGetter;if(i[G]()!==v){i[s](v);this.checkUpdate(false,A);return true;}}}else if(i[P]!==v){i[P]=v;this.checkUpdate(false,A);return true;}}return false;};
h.prototype.addBinding=function(B){J.prototype.addBinding.apply(this,arguments);if(B instanceof e){var A=B.sPath.replace("/","");this.mListBinding[A]=B;}B.checkUpdate(false);};
h.prototype.removeBinding=function(B){J.prototype.removeBinding.apply(this,arguments);if(B instanceof e){var A=B.sPath.replace("/","");delete this.mListBinding[A];}this._observeBeforeEvaluating(B,false);};
h.prototype.firePropertyChange=function(A){if(A.reason===d.Binding){A.resolvedPath=this.resolve(A.path,A.context);}J.prototype.firePropertyChange.call(this,A);};
h.prototype.bindAggregation=function(p,o,P){return J.prototype.bindProperty.apply(this,arguments);};
h.prototype.bindProperty=function(p,o,P){var B=new f(this,p,o,P);return B;};
h.prototype.bindList=function(p,o,s,F,P){var B=new e(this,p,o,s,F,P);B.enableExtendedChangeDetection();return B;};
h.prototype.getManagedObject=function(p,o){if(p instanceof C){o=p;p=o.getPath();}var O=this.getProperty(p,o);if(O instanceof M){return O;}return null;};
h.prototype.getRootObject=function(){return this._oObject;};
h.prototype._observePropertyChange=function(o,p){if(!o||!p){return;}var k=o.getId()+"/@"+p.name;if(!this._oObserver.isObserved(o,{properties:[p.name]})){this._oObserver.observe(o,{properties:[p.name]});this._mObservedCount.properties[k]=1;}else{this._mObservedCount.properties[k]++;}};
h.prototype._unobservePropertyChange=function(o,p){if(!o||!p){return;}var k=o.getId()+"/@"+p.name;this._mObservedCount.properties[k]--;if(this._mObservedCount.properties[k]==0){this._oObserver.unobserve(o,{properties:[p.name]});delete this._mObservedCount.properties[k];}};
h.prototype._observeAggregationChange=function(o,A){if(!o||!A){return;}var k=o.getId()+"/@"+A.name;if(!this._oObserver.isObserved(o,{aggregations:[A.name]})){this._oObserver.observe(o,{aggregations:[A.name]});this._mObservedCount.aggregations[k]=1;}else{this._mObservedCount.aggregations[k]++;}};
h.prototype._unobserveAggregationChange=function(o,A){if(!o||!A){return;}var k=o.getId()+"/@"+A.name;this._mObservedCount.aggregations[k]--;if(this._mObservedCount.aggregations[k]==0){this._oObserver.unobserve(o,{aggregations:[A.name]});delete this._mObservedCount.aggregations[k];}};
h.prototype._createId=function(i){var o=this._oObject;if(typeof o.createId==="function"){return o.createId(i);}if(!i){return o.getId()+I+q.sap.uid();}if(i.indexOf(o.getId()+I)!=0){return o.getId()+I+i;}return i;};
h.prototype._getSpecialNode=function(n,s,p,P){if(n instanceof M){if(s==="className"){if(n.getMetadata){return n.getMetadata().getName();}else{return typeof n;}}else if(s==="id"){return n.getId();}else if(s==="metadataContexts"){return n._oProviderData;}}else if(s==="binding"&&p&&P){return p.getBinding(P);}else if(s==="bound"&&p&&P){return p.isBound(P);}else if(s==="bindingInfo"&&p&&P){return p.getBindingInfo(P);}else if(q.isArray(n)){if(s==="length"){return n.length;}else if(s.indexOf("id=")===0){var j=s.substring(3),F=null;for(var i=0;i<n.length;i++){if(n[i].getId()===this._createId(j)||n[i].getId()===j){F=n[i];break;}}return F;}}return null;};
h.prototype._getObject=function(p,o){var n=this._oObject,r="",t=this;this.aBindings.forEach(function(B){if(!B._bAttached){t._observeBeforeEvaluating(B,true);}});if(typeof p==="string"&&p.indexOf("/")!=0&&!o){return null;}if(o instanceof M){n=o;r=p;}else if(!o||o instanceof C){r=this.resolve(p,o);if(!r){return n;}if(r.indexOf("/"+g)===0){return J.prototype._getObject.apply(this,[p,o]);}}else{n=o;r=p;}if(!n){return null;}var P=r.split("/"),i=0;if(!P[0]){i++;}var j=null,s=null,k;while(n!==null&&P[i]){k=P[i];if(k.indexOf("@")===0){n=this._getSpecialNode(n,k.substring(1),j,s);}else if(n instanceof M){var N=n.getMetadata();if(N.isInstanceOf("sap.ui.core.IDScope")&&k.indexOf("#")===0){n=n.byId(k.substring(1));}else{j=n;s=k;var l=N.getProperty(k);if(l){n=n[l._sGetter]();}else{var A=N.getAggregation(k)||N.getAllPrivateAggregations()[k];if(A){n=n[A._sGetter]?n[A._sGetter]():n.getAggregation(k);}else{if(n&&n[k]&&typeof n[k]==="function"){n=n[k]();}else{n=null;}}}}}else if(q.isArray(n)||q.isPlainObject(n)){n=n[k];}else{if(n&&n[k]&&typeof n[k]==="function"){n=n[k]();}else{n=null;}}i++;}return n;};
h.prototype.destroy=function(){for(var n in this._mAggregationObjects){var o=this._mAggregationObjects[n];if(o.object.invalidate.fn){o.object.invalidate=o.object.invalidate.fn;}}J.prototype.destroy.apply(this,arguments);};
h.prototype._observeBeforeEvaluating=function(B,o){if(!B.isResolved()){return;}var p=B.getPath();var i=B.getContext(),n=this._oObject,r;if(i instanceof M){n=i;r=p;}else if(!i||i instanceof C){r=this.resolve(p,i);if(!r){return;}if(r.indexOf("/"+g)===0){return;}}else{return;}var P=r.split("/");if(!P[0]){P.shift();}var s=P[0];if(n.getMetadata().isInstanceOf("sap.ui.core.IDScope")&&s.indexOf("#")===0){n=n.byId(s.substring(1));s=P[1];}if(n instanceof M){var N=n.getMetadata(),j=N.getProperty(s);if(j){if(o===true){this._observePropertyChange(n,j);}else if(o===false){this._unobservePropertyChange(n,j);}}else{var A=N.getAggregation(s)||N.getAllPrivateAggregations()[s];if(A){if(o===true){this._observeAggregationChange(n,A);}else if(o===false){this._unobserveAggregationChange(n,A);}}}B._bAttached=o;}};
h.prototype.observerChanges=function(o){if(o.type=="aggregation"){if(o.mutation=="insert"){this._oObserver.observe(o.child,{properties:true,aggegations:true});}else{this._oObserver.unobserve(o.child,{properties:true,aggegations:true});}if(this.mListBinding[o.name]){var l=this._oObject.getBinding(o.name);var A=this._oObject.getAggregation(o.name);if(l&&l.getLength()!=A.length){return;}}}this.checkUpdate();};
return h;});
sap.ui.predefine('sap/ui/model/base/XMLNodeAttributesModel',['../json/JSONModel','sap/ui/base/ManagedObject','./XMLNodeUtils','sap/ui/core/util/reflection/XmlTreeModifier'],function(J,M,U,X){"use strict";
var a=J.extend("sap.ui.model.base.XMLNodeAttributesModel",{
constructor:function(n,c,C){this.oCallback=c;this.oNode=n;this.sContext=C;this.getMetadata();J.apply(this,[n]);},
evalMode:{simple:"",binding:"@binding",bindingStr:"@bindingStr",data:"@data",metaContext:"@metaContext"}
});
a.prototype.getMetadata=function(){if(!this.oMetadata){var n=this.oNode.namespaceURI,c=U.findControlClass(n,U.localName(this.oNode));this.oMetadata=c.getMetadata();this.mAggregations=this.oMetadata.getAllAggregations();this.mProperties=this.oMetadata.getAllProperties();this.mSpecialSettings=this.oMetadata._mAllSpecialSettings;this.mEvent=this.oMetadata.getAllEvents();}return this.oMetadata;};
a.prototype.getVisitor=function(){return this.oCallback;};
a.prototype.getProperty=function(p,c){p=p||"/";var r,C=p.length==0;var e=this.evalMode.simple;p=this.resolve(p,c);p=p.substring(1);var P=p.split("/");var d=P.indexOf("@data");var m=P.indexOf("@metaContext");if(d>-1){e=this.evalMode.data;P.splice(d,1);}else if(m>-1){var b=P.slice(0,m);var s=P.slice(m+1,P.length);var o=this._diveDeep(b,C,this.evalMode.metaContext);r=this._getAnnotation(s,o);return r;}else{var l=P[P.length-1];if(l.startsWith("@")){P.splice(-1,1);e=l;}}if(P[0]=="metadataContexts"){var f=this.oNode.getAttribute("metadataContexts");if(P.length==1){r=f;}else{var g=M.bindingParser(f);switch(P[1]){case"model":r=g.model;break;case"data":P.splice(1,1);r=this._diveDeep(P,C,this.evalMode.data);break;default:r=f;break;}}}else{r=this._diveDeep(P,C,e);}return r;};
a.prototype.getAggregation=a.prototype.getProperty;a.prototype.getSpecialSetting=a.prototype.getProperty;a.prototype.getEvent=a.prototype.getProperty;
a.prototype._diveDeep=function(p,c,e){var r=this._getTopProperty(p[0],e);if(p.length>1){p.shift();for(var i=0;i<p.length;i++){if(r){r=r[p[i]];}}}return r;};
a.prototype._getTopProperty=function(p,e){var r=null;var P;if(p.length==0){return this.oNode;}if(this.mProperties.hasOwnProperty(p)){P=this.mProperties[p];if(e===this.evalMode.simple){e=this.evalMode.data;}if(!this.oNode.hasAttribute(p)){r=P.defaultValue;}else{r=this.oNode.getAttribute(p);}}else if(this.mAggregations.hasOwnProperty(p)){if(this.oNode.hasAttribute(p)){r=this.oNode.getAttribute(p);}else{r=X.getAggregation(this.oNode,p);}}else if(!this.mSpecialSettings.hasOwnProperty(p)&&!this.mEvents.hasOwnProperty(p)){r=null;}else{if(this.oNode.hasAttribute(p)){r=this.oNode.getAttribute(p);}}var b=M.bindingParser(r);switch(e){case this.evalMode.simple:break;case this.evalMode.binding:r=b;break;case this.evalMode.bindingStr:if(!b){r="";}break;case this.evalMode.metaContext:var m={};if(b){if(typeof b==="string"){b=M.bindingParser("{"+b+"}");}var o=this.oCallback.getSettings().models[b.model];if(o){m.metaModel=o.getMetaModel();if(m.metaModel&&m.metaModel.getMetaContext){m.metaContext=m.metaModel.getMetaContext(b.path);m.schema=m.metaModel.getProperty(m.metaContext.getPath());}}r=m;}return r;case this.evalMode.data:if(b){var R=null;try{R=this.oCallback.getResult(r);}catch(c){}if(R){r=R;}}break;}if(r){if(P){var s=U.parseScalarType(P.type,r,p);if(!(typeof s==="object"&&s.path)){r=s;}}}return r;};
a.prototype._getObject=function(p,c,C){p=this.resolve(p,c);var i,o=this.getProperty(p,c);if(Array.isArray(o)){var l=o;var P=function(b){return function(){return p+"/"+b;};};for(i=0;i<l.length;i++){l[i].getPath=P(i);}return l;}return o;};
a.prototype.getContextName=function(){return this.sContext;};
a.prototype._getAnnotation=function(p,m){var A=m.schema;var i=0;while(A&&p[i]){A=A[p[i]];i++;}return A;};
return a;});
sap.ui.predefine('sap/ui/model/base/XMLNodeUtils',['jquery.sap.global','sap/ui/base/DataType','sap/ui/base/ManagedObject'],function(q,D,M){"use strict";return{parseScalarType:function(t,v,n,c){var b=M.bindingParser(v,c,true);if(b&&typeof b==="object"){return b;}var V=v=b||v;var T=D.getType(t);if(T){if(T instanceof D&&!T.isValid(V)){V=T.parseValue(v);}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof V==="string"?M.bindingParser.escape(V):V;},localName:function(x){return x.localName||x.baseName||x.nodeName;},findControlClass:function(n,l){var c;var L=sap.ui.getCore().getLoadedLibraries();q.each(L,function(s,o){if(n===o.namespace||n===o.name){c=o.name+"."+((o.tagNames&&o.tagNames[l])||l);}});c=c||n+"."+l;q.sap.require(c);var C=q.sap.getObject(c);if(C){return C;}else{q.sap.log.error("Can't find object class '"+c+"' for XML-view","","XMLTemplateProcessor.js");}}};});
sap.ui.predefine('sap/ui/model/meta/AdapterFactory',[],function(){"use strict";var A=function(){};
A.requestAdapter=function(m){return null;};
A.getAdapter=function(m){return null;};
return A;});
sap.ui.predefine('sap/ui/model/meta/BaseAdapter',["jquery.sap.global","sap/ui/base/Object"],function(q,B){"use strict";
var a=B.extend("sap.ui.model.meta.BaseAdapter",{
oMetaModel:undefined,
sModelName:undefined,
constructor:function(m,p){this.mMetadataContext=m;this.oModel=m.model;this.oMetaModel=this.oModel.getMetaModel();this.modelName=m.modelName;this.contextName=m.contextName;this.path=m.path;this.metaPath=m.metaPath;this._mProperties={};this._mPropertyBag={};this._mCustomPropertyBag={};this.oMetaContext=this.oMetaModel.getMetaContext(this.path);if(!this.metaPath){this.metaPath=this.oMetaContext.getPath();}this.init();this.enhance(p);},
enhance:function(p){if(p){for(var P in p){this.putProperty(P,p[P]);}}},
init:function(m,p){},
getModelName:function(){return this.modelName;},
putProperty:function(p,g,A,c){if(!g){return;}if(!c){c=this;}Object.defineProperty(this,p,{configurable:true,get:function(){if(this._mCustomPropertyBag[p]){return this._mCustomPropertyBag[p];}if(!this._mPropertyBag.hasOwnProperty(p)){if(typeof g=='function'){this._mPropertyBag[p]=g.apply(c,A);}else{this._mPropertyBag[p]=g;}}return this._mPropertyBag[p];},set:function(v){this._mCustomPropertyBag[p]=v;}});},
convertToSimpleBinding:function(v,t){var p="{";if(this.modelName){p=p+"model: '"+this.modelName+"',";}p=p+"path: '"+v+"'";if(t){p=p+", type: '"+t+"'";}p=p+"}";return p;},
getContext:function(){return this.contextName;},
setValue:function(p,v){this.putProperty(p,this._identity,[v],this);},
_identity:function(v){return v;},
parentPromise:function(p,m){return new Promise(function(r,b){sap.ui.define([p],function(P){var o=new P(m);r(o);});});}
});
a.Relation={atMostOne:"0..1",one:"1",many:"n"};a.SupportedSortDirection={none:"none",both:"both",asc:"ascending",desc:"descending"};return a;});
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('jquery.sap.history',["jquery.sap.global","sap/base/Log","sap/base/util/uid","sap/base/strings/escapeRegExp"],function(q,L,u,e){"use strict";(function(w){var s="_skip",r=/\|id-[0-9]+-[0-9]+/,a=new RegExp(s+"[0-9]*$"),b=[],h=[],S={},c=0,d,I="|",H=[],f=false,g,j=false;
q.sap.history=function(B){if(!q.isPlainObject(B)){return;}if(!j){var W=q(w),C=(w.location.href.split("#")[1]||"");W.bind('hashchange',l);if(q.isArray(B.routes)){var i,D;for(i=0;i<B.routes.length;i++){D=B.routes[i];if(D.path&&D.handler){q.sap.history.addRoute(D.path,D.handler);}}}if(q.isFunction(B.defaultHandler)){g=B.defaultHandler;}h.push(C);if(C.length>1){W.trigger("hashchange",[true]);}else{d=C;}j=true;}};
q.sap.history.addHistory=function(i,B,C,V){var U,D;if(C===undefined){C=true;}if(!V){D=p(i,B);U=o(D);if(U){D+=(I+U);}D+=(I+(C?"1":"0"));}else{D=n(d);}H.push(D);S[D]=true;w.location.hash=D;return D;};
q.sap.history.addVirtualHistory=function(){q.sap.history.addHistory("",undefined,false,true);};
q.sap.history.addRoute=function(i,B,T){if(T){B=q.proxy(B,T);}var R={};R.sIdentifier=i;R['action']=B;b.push(R);return this;};
q.sap.history.setDefaultHandler=function(i){g=i;};
q.sap.history.getDefaultHandler=function(){return g;};
q.sap.history.backToHash=function(i){i=i||"";var B;if(h.length===1){if(q.isFunction(g)){g();}}else{B=k(d,i);if(B<0){w.history.go(B);}else{L.error("jQuery.sap.history.backToHash: "+i+"is not in the history stack or it's after the current hash");}}};
q.sap.history.backThroughPath=function(P){P=P||"";P=w.encodeURIComponent(P);var i;if(h.length===1){if(q.isFunction(g)){g();}}else{i=k(d,P,true);if(i<0){w.history.go(i);}else{L.error("jQuery.sap.history.backThroughPath: there's no history state which has the "+P+" identifier in the history stack before the current hash");}}};
q.sap.history.back=function(i){if(h.length===1){if(q.isFunction(g)){g(q.sap.history.NavType.Back);}}else{if(!i){i=1;}w.history.go(-1*i);}};
q.sap.history.NavType={Back:"_back",Forward:"_forward",Bookmark:"_bookmark",Unknown:"_unknown"};
function k(C,T,P){var B=q.inArray(C,h),D,i,E;if(B>0){if(P){for(i=B-1;i>=0;i--){E=h[i];if(E.indexOf(T)===0&&!v(E)){return i-B;}}}else{D=q.inArray(T,h);if((D===-1)&&T.length===0){return-1*B;}if((D>-1)&&(D<B)){return D-B;}}}return 0;}
function l(E,M){var i=(w.location.href.split("#")[1]||"");i=m(i);if(M||!S[i]){H.push(i);}if(!f){f=true;if(H.length>0){var B=H.shift();if(S[B]){t(B);delete S[B];}else{y(B);}d=B;}f=false;}}
function m(i,R){var B=i,C=i?i.indexOf("#"):-1;if(C===0){B=B.slice(C+1);}if(R){B=B.replace(r,"");}return B;}
function n(i){var P=i?i:"";if(v(P)){var B=P.lastIndexOf(s);P=P.slice(0,B);}return P+s+c++;}
function p(i,B){var E=w.encodeURIComponent(i);var C=w.encodeURIComponent(w.JSON.stringify(B));return E+I+C;}
function o(B){var C=q.inArray(d,h),i,D;if(C>-1){for(i=0;i<C+1;i++){D=h[i];if(D.slice(0,D.length-2)===B){return u();}}}return"";}
function t(i){var B=q.inArray(d,h);if(!(B===-1||B===h.length-1)){h.splice(B+1,h.length-1-B);}h.push(i);}
function v(i){return a.test(i);}
function x(C,F){var B=q.inArray(C,h),i;if(B!==-1){if(F){for(i=B;i<h.length;i++){if(!v(h[i])){return i-B;}}}else{for(i=B;i>=0;i--){if(!v(h[i])){return i-B;}}return-1*(B+1);}}}
function y(i){var R,B,P,N,C;if(d===undefined){P=A(i);if(!P||!P.bBookmarkable){if(q.isFunction(g)){g(q.sap.history.NavType.Bookmark);}return;}}if(i.length===0){if(q.isFunction(g)){g(q.sap.history.NavType.Back);}}else{N=h.indexOf(i);if(N===0){P=A(i);if(!P||!P.bBookmarkable){if(q.isFunction(g)){g(q.sap.history.NavType.Back);}return;}}if(v(i)){if(v(d)){B=x(i,false);w.history.go(B);}else{var D=new RegExp(e(d+s)+"[0-9]*$");if(D.test(i)){B=x(i,true);if(B){w.history.go(B);}else{w.history.back();}}else{B=x(i,false);w.history.go(B);}}}else{if(N===-1){C=q.sap.history.NavType.Unknown;h.push(i);}else{if(h.indexOf(d,N+1)===-1){C=q.sap.history.NavType.Forward;}else{C=q.sap.history.NavType.Back;}}P=A(i);if(P){R=z(P.sIdentifier);if(R){R.action.apply(null,[P.oStateData,C]);}}else{L.error("hash format error! The current Hash: "+i);}}}}
function z(B){var i;for(i=0;i<b.length;i++){if(b[i].sIdentifier===B){return b[i];}}}
function A(B){if(v(B)){var i=B.lastIndexOf(s);B=B.slice(0,i);}var P=B.split(I),R={};if(P.length===4||P.length===3){R.sIdentifier=w.decodeURIComponent(P[0]);R.oStateData=w.JSON.parse(w.decodeURIComponent(P[1]));if(P.length===4){R.uid=P[2];}R.bBookmarkable=P[P.length-1]==="0"?false:true;return R;}else{return null;}}
})(this);return q;});
sap.ui.predefine('jquery.sap.promise',['sap/ui/Device'],function(D){"use strict";if(D.browser.edge||D.browser.safari){window.Promise=undefined;}if(!window.Promise){sap.ui.requireSync("sap/ui/thirdparty/es6-promise");ES6Promise.polyfill();}});
sap.ui.predefine('jquery.sap.storage',['jquery.sap.global','sap/base/storage'],function(q,s){"use strict";q.sap.storage=s(window).getInstance;q.sap.storage.Type=s.Type;return q;});
sap.ui.predefine('jquery.sap.xml',['jquery.sap.global','sap/ui/xml/XMLParser','sap/ui/xml/serializeXML'],function(q,X,s){"use strict";q.sap.parseXML=X.parse;
q.sap.serializeXML=function(x){var a="";if(window.ActiveXObject){a=x.xml;if(a){return a;}}if(window.XMLSerializer){return s(x);}return a;};
q.sap.isEqualNode=function(n,N){if(n===N){return true;}if(!n||!N){return false;}if(n.isEqualNode){return n.isEqualNode(N);}if(n.nodeType!=N.nodeType){return false;}if(n.nodeValue!=N.nodeValue){return false;}if(n.baseName!=N.baseName){return false;}if(n.nodeName!=N.nodeName){return false;}if(n.nameSpaceURI!=N.nameSpaceURI){return false;}if(n.prefix!=N.prefix){return false;}if(n.nodeType!=1){return true;}if(n.attributes.length!=N.attributes.length){return false;}for(var i=0;i<n.attributes.length;i++){if(!q.sap.isEqualNode(n.attributes[i],N.attributes[i])){return false;}}if(n.childNodes.length!=N.childNodes.length){return false;}for(var i=0;i<n.childNodes.length;i++){if(!q.sap.isEqualNode(n.childNodes[i],N.childNodes[i])){return false;}}return true;};
q.sap.getParseError=X.getParseError;return q;});
sap.ui.predefine('sap/base/storage',["./assert"],function(a){"use strict";var s=function(S){var b=!!(S.JSON&&JSON.parse&&JSON.stringify);var c="state.key_";var C=function(d,f){var t="unknown",P=f||c;P+="-";var T=P+"___sapui5TEST___",o;if(!d||typeof(d)==="string"){t=d||"session";try{o=S[t+"Storage"];}catch(e){o=null;}try{if(o){o.setItem(T,"1");o.removeItem(T);}}catch(e){o=null;}}else if(typeof(d)==="object"){t=d.getType?d.getType():"unknown";o=d;}var g=!!o;this.isSupported=function(){if(!g){return false;}if(typeof(o.isSupported)=="function"){return o.isSupported();}return true;};this.put=function(i,h){a(typeof i==="string"&&i,"sId must be a non-empty string");a(typeof h==="string"||b,"sStateToStore must be string or JSON must be supported");if(this.isSupported()&&i){try{o.setItem(P+i,b?JSON.stringify(h):h);return true;}catch(e){return false;}}else{return false;}};this.get=function(i){a(typeof i==="string"&&i,"sId must be a non-empty string");if(this.isSupported()&&i){try{var I=o.getItem(P+i);return b?JSON.parse(I):I;}catch(e){return null;}}else{return null;}};this.remove=function(i){a(typeof i==="string"&&i,"sId must be a non-empty string");if(this.isSupported()&&i){try{o.removeItem(P+i);return true;}catch(e){return false;}}else{return false;}};this.removeAll=function(I){if(this.isSupported()&&o.length&&typeof o.key==="function"){try{var l=o.length;var k=[];var h,i;var p=P+(I||"");for(i=0;i<l;i++){h=o.key(i);if(h&&h.indexOf(p)==0){k.push(h);}}for(i=0;i<k.length;i++){o.removeItem(k[i]);}return true;}catch(e){return false;}}else{return false;}};this.clear=function(){if(this.isSupported()){try{o.clear();return true;}catch(e){return false;}}else{return false;}};this.getType=function(){return t;};};var m={};var E={getInstance:function(o,i){if(!o){o=s.Type.session;}if(typeof(o)==="string"&&s.Type[o]){var k=o;if(i&&i!=c){k=o+"_"+i;}return m[k]||(m[k]=new C(o,i));}a(o instanceof Object&&o.clear&&o.setItem&&o.getItem&&o.removeItem,"storage: duck typing the storage");return new C(o,i);}};C.apply(E.getInstance);m[s.Type.session]=E.getInstance;return E;};s.Type={local:"local",session:"session",global:"global"};return s;});
sap.ui.predefine('sap/base/strings/normalize-polyfill',["sap/ui/thirdparty/unorm","sap/ui/thirdparty/unormdata"],function(){"use strict";
function apply(){String.prototype.normalize=function(s){switch(s){case'NFC':return nfcQuickCheck(this)?this:UNorm.nfc(this);case'NFD':return UNorm.nfd(this);case'NFKC':return UNorm.nfkc(this);case'NFKD':return UNorm.nfkd(this);default:return nfcQuickCheck(this)?this:UNorm.nfc(this);}};}
var mData={};(function(){var N=[[0x0340,0x0341],[0x0343,0x0344],0x374,0x037E,0x387,[0x0958,0x095F],[0x09DC,0x09DD],0x09DF,0x0A33,0x0A36,[0x0A59,0x0A5B],0x0A5E,[0x0B5C,0x0B5D],0x0F43,0x0F4D,0x0F52,0x0F57,0x0F5C,0x0F69,0x0F73,[0x0F75,0x0F76],0x0F78,0x0F81,0x0F93,0x0F9D,0x0FA2,0x0FA7,0x0FAC,0x0FB9,0x1F71,0x1F73,0x1F75,0x1F77,0x1F79,0x1F7B,0x1F7D,0x1FBB,0x1FBE,0x1FC9,0x1FCB,0x1FD3,0x1FDB,0x1FE3,0x1FEB,[0x1FEE,0x1FEF],0x1FF9,0x1FFB,0x1FFD,[0x2000,0x2001],0x2126,[0x212A,0x212B],0x2329,0x232A,0x2ADC,[0xF900,0xFA0D],0xFA10,0xFA12,[0xFA15,0xFA1E],0xFA20,0xFA22,[0xFA25,0xFA26],[0xFA2A,0xFA6D],[0xFA70,0xFAD9],0xFB1D,0xFB1F,[0xFB2A,0xFB36],[0xFB38,0xFB3C],0xFB3E,[0xFB40,0xFB41],[0xFB43,0xFB44],[0xFB46,0xFB4E],[0x1D15E,0x1D164],[0x1D1BB,0x1D1C0],[0x2F800,0x2FA1D],[0x0300,0x0304],[0x0306,0x030C],0x030F,0x311,[0x0313,0x0314],0x031B,[0x0323,0x0328],[0x032D,0x032E],[0x0330,0x0331],0x338,0x342,0x345,[0x0653,0x0655],0x093C,0x09BE,0x09D7,0x0B3E,0x0B56,0x0B57,0x0BBE,0x0BD7,0x0C56,0x0CC2,[0x0CD5,0x0CD6],0x0D3E,0x0D57,0x0DCA,0x0DCF,0x0DDF,0x102E,[0x1161,0x1175],[0x11A8,0x11C2],0x1B35,[0x3099,0x309A],0x110BA,0x11127,0x1133E,0x11357,0x114B0,0x114BA,0x114BD,0x115AF];for(var i=0;i<N.length;i++){if(typeof N[i]=="number"){mData[N[i]]=true;}else{var a=N[i][0];var b=N[i][1];while(a<=b){mData[a++]=true;}}}}());
function isHighSurrogate(c){return c>=0xD800&&c<=0xDBFF;}
function isLowSurrogate(c){return c>=0xDC00&&c<=0xDFFF;}
function getCanonicalClass(cp){var dunit,hash;hash=cp&0xFF00;dunit=UNorm.UChar.udata[hash];if(dunit===undefined){dunit=UNorm.UChar.udata[hash]={};}else if(typeof dunit==="string"){dunit=UNorm.UChar.udata[hash]=eval("("+dunit+")");}return dunit[cp]&&!!dunit[cp][1]?(dunit[cp][1]&0xff):0;}
function isNotAllowed(c){return mData[c];}
function nfcQuickCheck(s){if(!/^[\u0001-\u00ff]*$/.test(s)){var l=0;for(var i=0;i<s.length;++i){var c=s.charCodeAt(i);if(isHighSurrogate(c)){var n=s.charCodeAt(i+1);if(isLowSurrogate(n)){c=(c-0xD800)*0x400+(n-0xDC00)+0x10000;++i;}}var a=getCanonicalClass(c);if(l>a&&a!==0||isNotAllowed(c)){return false;}l=a;}}return true;}
var NormalizePolyfill=Object.create(null);NormalizePolyfill.apply=apply;NormalizePolyfill.isStringNFC=nfcQuickCheck;return NormalizePolyfill;});
sap.ui.predefine('sap/base/util/includes',["sap/base/util/values"],function(v){"use strict";
function e(a,b){return a===b||(a!==a&&b!==b);}
var I=function(c,V,f){if(typeof f!=='number'){f=0;}if(Array.isArray(c)){if(typeof c.includes==='function'){return c.includes(V,f);}f=f<0?f+c.length:f;f=f<0?0:f;for(var i=f;i<c.length;i++){if(e(c[i],V)){return true;}}return false;}else if(typeof c==='string'){f=f<0?c.length+f:f;if(typeof c.includes==='function'){return c.includes(V,f);}return c.indexOf(V,f)!==-1;}else{return I(v(c),V,f);}};return I;});
sap.ui.predefine('sap/base/util/values',function(){"use strict";return function values(o){if(typeof o==="undefined"||o===null||o!==o){return[];}if(typeof Object.values==='function'){return Object.values(o);}if(typeof o==='string'){return o.split('');}if(typeof o!=='object'){return[];}return Object.keys(o).map(function(v){return o[v];});};});
sap.ui.predefine('sap/ui/app/Application',['jquery.sap.global','./ApplicationMetadata','sap/ui/core/Component','jquery.sap.sjax'],function(q,A,C){"use strict";
var a=C.extend("sap.ui.app.Application",{
metadata:{"abstract":true,properties:{root:"string",config:"any"},aggregations:{rootComponent:{type:"sap.ui.core.UIComponent",multiple:false}},publicMethods:["getView"],deprecated:true},
constructor:function(i,s){if(this.onError){this.onWindowError=this.onError;}if(this.onBeforeExit){this.onWindowBeforeUnload=this.onBeforeExit;}if(this.onExit){this.onWindowUnload=this.onExit;}C.apply(this,arguments);if(sap.ui.getApplication){throw new Error("Only one instance of sap.ui.app.Application is allowed");}sap.ui.getApplication=q.proxy(this._getInstance,this);sap.ui.getCore().attachInit(q.proxy(function(){this._initRootComponent();this.main();},this));},
_initRootComponent:function(){var r=this.createRootComponent();if(r){this.setRootComponent(r);var c=new sap.ui.core.ComponentContainer({component:r});c.placeAt(this.getRoot()||document.body);}},
createRootComponent:function(){var r=this.getMetadata().getRootComponent();var R;if(r){R=sap.ui.component({name:r});}return R;},
getView:function(){return this.getRootComponent();},
_getInstance:function(){return this;},
main:function(){},
onBeforeExit:function(){},
onExit:function(){},
onError:null,
setConfig:function(c){if(typeof c==="string"){var u=c;var c=new sap.ui.model.json.JSONModel();var r=q.sap.sjax({url:u,dataType:'json'});if(r.success){c.setData(r.data);}else{throw new Error("Could not load config file: "+u);}}if(typeof c==="object"&&!c instanceof sap.ui.model.Model){c=new sap.ui.model.JSONModel(c);}this.setProperty("config",c);},
destroy:function(s){delete sap.ui.getApplication;C.prototype.destroy.apply(this,arguments);}
},A);
return a;},true);
sap.ui.predefine('sap/ui/app/ApplicationMetadata',['jquery.sap.global','sap/ui/core/ComponentMetadata','jquery.sap.sjax'],function(q,C){"use strict";var A=function(c,o){C.apply(this,arguments);};A.prototype=q.sap.newObject(C.prototype);
A.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};
A.prototype.applySettings=function(c){var s=c.metadata;C.prototype.applySettings.call(this,c);if(s._src){q.sap.log.warning("The metadata of the application "+this.getName()+" is loaded from file "+s._src+". This is a design time feature and not for productive usage!");var p=this.getName().replace(/\.\w+?$/,"");var u=q.sap.getModulePath(p,"/"+s._src);var r=q.sap.syncGetJSON(u);if(r.success){q.extend(s,r.data);}else{q.sap.log.error("Failed to load application metadata from \""+s._src+"\"! Reason: "+r.error);}}this._mRootComponent=s.rootComponent||null;};
A.prototype.getRootComponent=function(){return this._mRootComponent;};
return A;},true);
sap.ui.predefine('sap/ui/app/MockServer',['jquery.sap.global','sap/ui/core/util/MockServer'],function(q,M){"use strict";var a=M;return a;},true);
sap.ui.predefine('sap/ui/base/SyncPromise',["jquery.sap.global"],function(q){"use strict";
function c(t,r,a){var o;function b(R){if(!o){o=true;a(R);}}function d(R){if(!o){o=true;r(R);}}try{t(d,b);}catch(e){b(e);}}
function h(v){return v&&(typeof v==="function"||typeof v==="object")&&"then"in v;}
function S(E){var C=false,s,r,R,v,t=this;function a(d){v=d;s=-1;if(!C&&S.listener){S.listener(t,false);}if(r){r(d);r=R=null;}}function b(d){var T;if(d===t){a(new TypeError("A promise cannot be resolved with itself."));return;}if(d instanceof S){if(d.isFulfilled()){b(d.getResult());return;}else if(d.isRejected()){d.caught();a(d.getResult());return;}else{d.caught();d=d.getResult();}}s=0;v=d;if(h(v)){try{T=v.then;}catch(e){a(e);return;}if(typeof T==="function"){c(T.bind(v),b,a);return;}}s=1;if(R){R(v);r=R=null;}}this.caught=function(){if(!C){C=true;if(S.listener&&this.isRejected()){S.listener(this,true);}}};this.getResult=function(){return v;};this.isFulfilled=function(){return s===1;};this.isPending=function(){return!s;};this.isRejected=function(){return s===-1;};c(E,b,a);if(s===undefined){v=new Promise(function(b,a){R=b;r=a;});v.catch(function(){});}}
S.prototype.catch=function(o){return this.then(undefined,o);};
S.prototype.then=function(o,O){var C=this.isFulfilled()?o:O,b=typeof C==="function",p=this.isPending(),t=this;if(p||b){this.caught();}if(!p){return b?new S(function(r,a){r(C(t.getResult()));}):this;}return S.resolve(this.getResult().then(o,O));};
S.prototype.toString=function(){if(this.isPending()){return"SyncPromise: pending";}return String(this.getResult());};
S.all=function(v){return new S(function(r,a){var d=false,p=0;function b(){if(d&&p===0){r(v);}}v=Array.prototype.slice.call(v);v.forEach(function(V,i){if(V!==v[i+1]&&h(V)){p+=1;V.then(function(R){do{v[i]=R;i-=1;}while(i>=0&&V===v[i]);p-=1;b();},function(R){a(R);});}});d=true;b();});};
S.reject=function(r){return new S(function(a,b){b(r);});};
S.resolve=function(r){return r instanceof S?r:new S(function(a,b){a(r);});};
return S;},true);
sap.ui.predefine('sap/ui/bootstrap/Debug',['sap/ui/bootstrap/Info'],function(_){"use strict";
function r(d){if(d&&d.parentNode){d.parentNode.removeChild(d);}}
if(/sap-bootstrap-debug=(true|x|X)/.test(location.search)){debugger;}var R;try{R=window.localStorage.getItem("sap-ui-reboot-URL");window.localStorage.removeItem("sap-ui-reboot-URL");}catch(e){}if(R&&R!=="undefined"){var u=confirm("WARNING!\n\nUI5 will be booted from the URL below.\nPress 'Cancel' unless you have configured this.\n\n"+R);if(u){var s=_.tag,S="<script id=\"sap-ui-bootstrap\" src=\""+R+"\"";for(var i=0;i<s.attributes.length;i++){var a=s.attributes[i];if(a.nodeName==="data-sap-ui-resourceroots"){var o=JSON.parse(a.nodeValue+"");if(o){o[""]=undefined;S+=" data-sap-ui-resourceroots=\""+JSON.stringify(o).replace(/"/g,"&quot;")+"\"";}}else if(a.nodeName.indexOf("data-sap-ui-")===0){S+=" "+a.nodeName+"=\""+a.nodeValue.replace(/"/g,"&quot;")+"\"";}}S+="></script>";r(s);r(document.getElementById("sap-ui-bootstrap-cachebusted"));var c=window["sap-ui-config"];if(c&&c.resourceRoots){c.resourceRoots[""]=undefined;}document.write(S);var b=new Error("This is not a real error. Aborting UI5 bootstrap and rebooting from: "+R);b.name="Restart";throw b;}}});
sap.ui.predefine('sap/ui/core/AppCacheBuster',['jquery.sap.global','sap/ui/base/ManagedObject','./Core','sap/ui/thirdparty/URI'],function(q,M,C,U){"use strict";var c=sap.ui.getCore().getConfiguration();var l=c.getLanguage();var s=c.getAppCacheBusterMode()==="sync";var b=c.getAppCacheBusterMode()==="batch";var S={index:{},active:false};var v,d,a,x,E;var L=document.baseURI.replace(/\?.*|#.*/g,"");var u=U(q.sap.getModulePath("","/../"));var o=u.toString();if(u.is("relative")){u=u.absoluteTo(L);}var B=u.normalize().toString();var r=U("resources").absoluteTo(B).toString();var f=new RegExp("^"+q.sap.escapeRegExp(r));var g=function(e){if(e.length>0&&e.slice(-1)!=="/"){e+="/";}return e;};var R=function(B,e){var i=S.index;var j;var k;var m;if(Array.isArray(B)&&!b){B.forEach(function(D){R(D,e);});}else if(Array.isArray(B)&&b){var n=g(B[0]);var p=[];q.sap.log.debug("sap.ui.core.AppCacheBuster.register(\""+n+"\"); // BATCH MODE!");var t=A.normalizeURL(n);q.sap.log.debug("  --> normalized to: \""+t+"\"");B.forEach(function(D){k=g(D);var F=A.normalizeURL(k);if(!i[m]){p.push(F);}});if(p.length>0){var k=t+"sap-ui-cachebuster-info.json?sap-ui-language="+l;j={url:k,type:"POST",async:!s&&!!e,dataType:"json",contentType:"text/plain",data:p.join("\n"),success:function(D){A.onIndexLoaded(k,D);q.extend(i,D);},error:function(){q.sap.log.error("Failed to batch load AppCacheBuster index file from: \""+k+"\".");}};}}else{B=g(B);q.sap.log.debug("sap.ui.core.AppCacheBuster.register(\""+B+"\");");m=A.normalizeURL(B);q.sap.log.debug("  --> normalized to: \""+m+"\"");if(!i[m]){var k=m+"sap-ui-cachebuster-info.json?sap-ui-language="+l;j={url:k,async:!s&&!!e,dataType:"json",success:function(D){A.onIndexLoaded(k,D);i[m]=D;},error:function(){q.sap.log.error("Failed to load AppCacheBuster index file from: \""+k+"\".");}};}}if(j){var I=A.onIndexLoad(j.url);if(I!=null){q.sap.log.info("AppCacheBuster index file injected for: \""+k+"\".");j.success(I);}else{if(j.async){var w=e.startTask("load "+k);var y=j.success,z=j.error;q.extend(j,{success:function(D){y.apply(this,arguments);e.finishTask(w);},error:function(){z.apply(this,arguments);e.finishTask(w,false);}});}q.sap.log.info("Loading AppCacheBuster index file from: \""+k+"\".");q.ajax(j);}}};var A={boot:function(e){var i=c.getAppCacheBuster();if(i&&i.length>0){i=i.slice();var j=true;var V=String(i[0]).toLowerCase();if(i.length===1){if(V==="true"||V==="x"){var u=U(o);i=u.is("relative")?[u.toString()]:[];}else if(V==="false"){j=false;}}if(j){A.init();R(i,e);}}},init:function(){S.active=true;v=M.prototype.validateProperty;d=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");a=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href");var i=A.convertURL;var n=A.normalizeURL;var I=function(e){if(this.active===true&&e&&typeof(e)==="string"){e=n(e);return!e.match(f);}return false;}.bind(S);x=XMLHttpRequest.prototype.open;XMLHttpRequest.prototype.open=function(e,p){if(p&&I(p)){arguments[1]=i(p);}x.apply(this,arguments);};E=XMLHttpRequest.prototype.open;M.prototype.validateProperty=function(p,V){var t=this.getMetadata(),P=t.getProperty(p),w;if(P&&P.type==="sap.ui.core.URI"){w=Array.prototype.slice.apply(arguments);try{if(I(w[1])){w[1]=i(w[1]);}}catch(e){}}return v.apply(this,w||arguments);};var j=function(e){var p={get:e.get,set:function(t){if(I(t)){t=i(t);}e.set.call(this,t);},enumerable:e.enumerable,configurable:e.configurable};p.set._sapUiCoreACB=true;return p;};var k=false;try{Object.defineProperty(HTMLScriptElement.prototype,"src",j(d));}catch(m){q.sap.log.error("Your browser doesn't support redefining the src property of the script tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+m);k=true;}try{Object.defineProperty(HTMLLinkElement.prototype,"href",j(a));}catch(m){q.sap.log.error("Your browser doesn't support redefining the href property of the link tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+m);k=true;}if(k){this.exit();}},exit:function(){M.prototype.validateProperty=v;if(XMLHttpRequest.prototype.open===E){XMLHttpRequest.prototype.open=x;}var e;if((e=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src"))&&e.set&&e.set._sapUiCoreACB===true){Object.defineProperty(HTMLScriptElement.prototype,"src",d);}if((e=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href"))&&e.set&&e.set._sapUiCoreACB===true){Object.defineProperty(HTMLLinkElement.prototype,"href",a);}S.index={};S.active=false;S={index:{},active:false};},register:function(B){R(B);},convertURL:function(e){q.sap.log.debug("sap.ui.core.AppCacheBuster.convertURL(\""+e+"\");");var i=S.index;if(i&&e){var n=A.normalizeURL(e);q.sap.log.debug("  --> normalized to: \""+n+"\"");if(n&&A.handleURL(n)){q.each(i,function(B,m){var j;if(B&&n.length>=B.length&&n.slice(0,B.length)===B){j=n.slice(B.length);j=j.match(/([^?#]*)/)[1];if(m[j]){e=B+"~"+m[j]+"~/"+j;q.sap.log.debug("  ==> rewritten to \""+e+"\";");return false;}}});}}return e;},normalizeURL:function(e){var u=U(e||"./");if(u.is("relative")){u=u.absoluteTo(L);}return u.normalizeProtocol().normalizeHostname().normalizePort().normalizePath().toString();},handleURL:function(e){return true;},onIndexLoad:function(e){return null;},onIndexLoaded:function(e,i){}};var h=c.getAppCacheBusterHooks();if(h){["handleURL","onIndexLoad","onIndexLoaded"].forEach(function(F){if(typeof h[F]==="function"){A[F]=h[F];}});}return A;},true);
sap.ui.predefine('sap/ui/core/BusyIndicator',['jquery.sap.global','../base/EventProvider','./Popup','./Core','./BusyIndicatorUtils','sap/ui/core/library'],function(q,E,P,C,B,l){"use strict";var a=l.BusyIndicatorSize;var b=q.extend(new E(),{oPopup:null,oDomRef:null,bOpenRequested:false,iDEFAULT_DELAY_MS:1000,sDOM_ID:"sapUiBusyIndicator"});b.M_EVENTS={Open:"Open",Close:"Close"};b._bShowIsDelayed=undefined;
b._init=function(){var r=document.createElement("div");r.id=this.sDOM_ID;var o=document.createElement("div");this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");var t=this._oResBundle.getText("BUSY_TEXT");delete this._oResBundle;o.className="sapUiBusy";o.setAttribute("tabindex","0");o.setAttribute("role","progressbar");o.setAttribute("alt","");o.setAttribute("title",t);r.appendChild(o);var c=B.getElement(a.Large);c.setAttribute("title",t);r.appendChild(c);var i=sap.ui.getCore().getStaticAreaRef();i.appendChild(r);this.oDomRef=r;this.oPopup=new P(r);this.oPopup.setModal(true,"sapUiBlyBusy");this.oPopup.setShadow(false);this.oPopup.attachOpened(function(e){this._onOpen(e);},this);};
b._onOpen=function(e){var d=q.sap.domById(b.sDOM_ID);d.style.height="100%";d.style.width="100%";var A=d.querySelector(".sapUiLocalBusyIndicator");A.className+=" sapUiLocalBusyIndicatorFade";q.sap.focus(d);q("body").attr("aria-busy",true);this.fireOpen({$Busy:this.oPopup._$()});};
b.show=function(d){q.sap.log.debug("sap.ui.core.BusyIndicator.show (delay: "+d+") at "+new Date().getTime());if(!document.body||!sap.ui.getCore().isInitialized()){if(b._bShowIsDelayed===undefined){sap.ui.getCore().attachInit(function(){if(b._bShowIsDelayed){b.show(d);}});}b._bShowIsDelayed=true;return;}if((d===undefined)||((d!=0)&&(parseInt(d,10)==0))||(parseInt(d,10)<0)){d=this.iDEFAULT_DELAY_MS;}if(q.sap.fesr.getActive()){this._fDelayedStartTime=q.sap.now()+d;}if(!this.oDomRef){this._init();}this.bOpenRequested=true;if(d===0){this._showNowIfRequested();}else{q.sap.delayedCall(d,this,"_showNowIfRequested");}};
b._showNowIfRequested=function(){q.sap.log.debug("sap.ui.core.BusyIndicator._showNowIfRequested (bOpenRequested: "+this.bOpenRequested+") at "+new Date().getTime());if(!this.bOpenRequested){return;}var o=(window.scrollX===undefined?window.pageXOffset:window.scrollX);var O=(window.scrollY===undefined?window.pageYOffset:window.scrollY);var s=o+" "+O;this.bOpenRequested=false;this.oPopup.open(0,P.Dock.LeftTop,P.Dock.LeftTop,document,s);};
b.hide=function(){q.sap.log.debug("sap.ui.core.BusyIndicator.hide at "+new Date().getTime());if(this._fDelayedStartTime){var f=q.sap.now()-this._fDelayedStartTime;q.sap.fesr.addBusyDuration((f>0)?f:0);delete this._fDelayedStartTime;}var c=b;if(b._bShowIsDelayed===true){b._bShowIsDelayed=false;}c.bOpenRequested=false;if(c.oDomRef){q("body").removeAttr("aria-busy");var A=c.oDomRef.querySelector(".sapUiLocalBusyIndicator");q(A).removeClass("sapUiLocalBusyIndicatorFade");this.fireClose({$Busy:this.oPopup._$()});c.oPopup.close(0);}};
b.attachOpen=function(f,L){this.attachEvent(b.M_EVENTS.Open,f,L);return this;};
b.detachOpen=function(f,L){this.detachEvent(b.M_EVENTS.Open,f,L);return this;};
b.attachClose=function(f,L){this.attachEvent(b.M_EVENTS.Close,f,L);return this;};
b.detachClose=function(f,L){this.detachEvent(b.M_EVENTS.Close,f,L);return this;};
b.fireOpen=function(p){this.fireEvent(b.M_EVENTS.Open,p);};
b.fireClose=function(p){this.fireEvent(b.M_EVENTS.Close,p);};
return b;},true);
sap.ui.predefine('sap/ui/core/ComponentContainer',['sap/ui/base/ManagedObject','./Control','./Component','./Core','./library',"./ComponentContainerRenderer"],function(M,C,a,b,l,c){"use strict";var d=l.ComponentLifecycle;
var e=C.extend("sap.ui.core.ComponentContainer",{metadata:{library:"sap.ui.core",properties:{name:{type:"string",defaultValue:null},url:{type:"sap.ui.core.URI",defaultValue:null},async:{type:"boolean",defaultValue:false},handleValidation:{type:"boolean",defaultValue:false},settings:{type:"object",defaultValue:null},propagateModel:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},lifecycle:{type:"sap.ui.core.ComponentLifecycle",defaultValue:d.Legacy},autoPrefixId:{type:"boolean",defaultValue:false},usage:{type:"string",defaultValue:null},manifest:{type:"any",defaultValue:null}},associations:{component:{type:"sap.ui.core.UIComponent",multiple:false}},events:{componentCreated:{parameters:{component:{type:"sap.ui.core.UIComponent"}}}},designtime:"sap/ui/core/designtime/ComponentContainer.designtime"}});
function s(o,v,S,D){var g=typeof v==="string"?b.getComponent(v):v;var O=o.getComponentInstance();if(O!==g){if(O){O.setContainer(undefined);if(D){O.destroy();}else{o._propagateProperties(true,O,M._oEmptyPropagatedProperties,true);}}o.setAssociation("component",g,S);g=o.getComponentInstance();if(g){g.setContainer(o);o.propagateProperties(true);}}}
e.prototype.getComponentInstance=function(){var g=this.getComponent();return g&&b.getComponent(g);};
e.prototype.setComponent=function(v,S){s(this,v,S,this.getLifecycle()===d.Container||(typeof this.getUsage()==="string"&&this.getUsage()&&this.getLifecycle()===d.Legacy));return this;};
e.prototype.applySettings=function(S,o){if(S){if(S.autoPrefixId===true&&S.settings&&S.settings.id){S.settings.id=this.getId()+"-"+S.settings.id;}if(S.manifest==="true"||S.manifest==="false"){S.manifest=S.manifest==="true";}if(S.manifest&&S.async===undefined){S.async=true;}}C.prototype.applySettings.apply(this,arguments);};
function f(o){var n=o.getName();var u=o.getUsage();var m=o.getManifest();var U=o.getUrl();var S=o.getSettings();var g={name:n?n:undefined,usage:u?u:undefined,manifest:m!==null?m:false,async:o.getAsync(),url:U?U:undefined,handleValidation:o.getHandleValidation(),settings:S!==null?S:undefined};return g;}
e.prototype._createComponent=function(){var o=a.getOwnerComponentFor(this),m=f(this);if(!o){if(m.async){return a.create(m);}else{return sap.ui.component(m);}}else{return o._createComponent(m);}};
e.prototype.onBeforeRendering=function(){var o=this.getComponentInstance(),u=this.getUsage(),n=this.getName(),m=this.getManifest();if(!this._oComponentPromise&&!o&&(u||n||m)){o=this._createComponent();if(o instanceof Promise){this._oComponentPromise=o;o.then(function(o){delete this._oComponentPromise;this.setComponent(o);this.fireComponentCreated({component:o});}.bind(this),function(r){delete this._oComponentPromise;jQuery.sap.log.error("Failed to load component for container "+this.getId()+". Reason: "+r);}.bind(this));}else{this.setComponent(o,true);this.fireComponentCreated({component:o});}}if(o&&o.onBeforeRendering){o.onBeforeRendering();}};
e.prototype.onAfterRendering=function(){var o=this.getComponentInstance();if(o&&o.onAfterRendering){o.onAfterRendering();}};
e.prototype.exit=function(){s(this,undefined,true,this.getLifecycle()!==d.Application);};
e.prototype.propagateProperties=function(n){var o=this.getComponentInstance();if(o&&this.getPropagateModel()){this._propagateProperties(n,o);C.prototype.propagateProperties.apply(this,arguments);}};
e.prototype._propagateContextualSettings=function(){var o=this.getComponentInstance();if(o){o._applyContextualSettings(this._getContextualSettings());}};
return e;});
sap.ui.predefine('sap/ui/core/ComponentContainerRenderer',function(){"use strict";var C={};
C.render=function(r,c){var R=r;var o=c.getComponentInstance();var w=c.getWidth();var h=c.getHeight();R.write("<div");R.writeControlData(c);if(w){R.addStyle("width",w);}if(h){R.addStyle("height",h);}R.writeStyles();R.addClass("sapUiComponentContainer");R.writeClasses();R.write(">");R.write("<div id=\""+c.getId()+"-uiarea\"");if(w&&w!=="auto"){R.addStyle("width","100%");}if(h&&h!=="auto"){R.addStyle("height","100%");}R.writeStyles();R.write(">");if(o){o.render(R);}R.write("</div></div>");};
return C;},true);
sap.ui.predefine('sap/ui/core/CompositeSupport',['jquery.sap.global','./Control','sap/ui/model/control/ControlModel','sap/ui/base/EventProvider'],function(q,C,a,E){"use strict";var b={};
b.mixInto=function(f,F,m){if(arguments.length==2&&typeof F==="object"){m=F;F="ComponentFactory";}function _(){var M=f.getMetadata();do{M=M.getParent();if(M&&M.getComponentFactoryClass){return M.getComponentFactoryClass();}}while(M);return c;}f[F]=(_()).subclass(m);f.getMetadata().getComponentFactoryClass=q.sap.getter(f[F]);if(!f.prototype._initCompositeSupport){f.prototype._initCompositeSupport=function(s){var o=new(this.getMetadata().getComponentFactoryClass())(this);if(s.componentFactory){o.customize(s.componentFactory);delete s.componentFactory;}this.getComponentFactory=q.sap.getter(o);};}if(!f.prototype._exitCompositeSupport){f.prototype._exitCompositeSupport=function(){this.getComponentFactory().destroy();delete this.getComponentFactory;};}};
var c=E.extend("sap.ui.core.ComponentFactory",{constructor:function(o){E.apply(this);this.oComposite=o;return this;}});
c.prototype.attachChange=function(f,o){this.getModel();this.attachEvent("change",f,o);return this;};
c.prototype.detachChange=function(f,o){this.getModel();this.detachEvent("change",f,o);return this;};
c.prototype.getModel=function(){if(!this.oModel){var t=this;this.oModel=new a(this.oComposite);this.oModel._onchange=function(e){t.fireEvent("change",e.getParameters&&e.getParameters());};}return this.oModel;};
c.prototype.addFacadeComponent=function(e){this.getModel().add(e);};
c.prototype.removeFacadeComponent=function(e){this.getModel().remove(e);};
(function(){
function _(o,m,D){q.each(m,function(n,f){if(n.indexOf("default")!=0){o[n]=f;}if(D&&n.indexOf("create")==0){o["defaultC"+n.substring(1)]=o[n];}});}
function d(B){return function(m){var f=function(){B.apply(this,arguments);};f.prototype=Object.create(B.prototype);_(f.prototype,m,true);f.customize=function(m){_(f.prototype,m);return this;};f.subclass=d(f);return f;};}
c.subclass=d(c);
c.prototype.customize=function(m){_(this,m);if(this.oComposite&&this.oComposite._onComponentFactoryChanged){this.oComposite._onComponentFactoryChanged();}return this;};
}());return b;},true);
sap.ui.predefine('sap/ui/core/ContextMenuSupport',["./Control"],function(C){"use strict";var a=function(){var c;if(!(this instanceof C)){return;}function o(e){e.stopPropagation();if(e.srcControl!==this){return;}e.preventDefault();this._oContextMenu.openAsContextMenu(e,this);}c={oncontextmenu:o};this.setContextMenu=function(b){if(b==null&&this.getContextMenu()){this._oContextMenu=null;this.removeEventDelegate(c,this);return;}else if(!b||!b.getMetadata||!b.getMetadata().isInstanceOf("sap.ui.core.IContextMenu")){return;}if(!this._oContextMenu){this.addEventDelegate(c,this);}this._oContextMenu=b;};this.getContextMenu=function(){return this._oContextMenu;};};return a;},true);
sap.ui.predefine('sap/ui/core/CustomData',['jquery.sap.global','./Element','./library'],function(q,E,l){"use strict";var I=l.ID;
var C=E.extend("sap.ui.core.CustomData",{metadata:{library:"sap.ui.core",properties:{key:{type:"string",group:"Data",defaultValue:null},value:{type:"any",group:"Data",defaultValue:null},writeToDom:{type:"boolean",group:"Data",defaultValue:false}},designtime:"sap/ui/core/designtime/CustomData.designtime"}});
C.prototype.setValue=function(v){this.setProperty("value",v,true);var c=this.getParent();if(c&&c.getDomRef()){var o=this._checkWriteToDom(c);if(o){c.$().attr(o.key,o.value);}}return this;};
C.prototype._checkWriteToDom=function(r){if(!this.getWriteToDom()){return null;}var k=this.getKey();var v=this.getValue();if(typeof v!="string"){q.sap.log.error("CustomData with key "+k+" should be written to HTML of "+r+" but the value is not a string.");return null;}if(!(I.isValid(k))||(k.indexOf(":")!=-1)){q.sap.log.error("CustomData with key "+k+" should be written to HTML of "+r+" but the key is not valid (must be a valid sap.ui.core.ID without any colon).");return null;}if(k==q.sap._FASTNAVIGATIONKEY){v=/^\s*(x|true)\s*$/i.test(v)?"true":"false";}else if(k.indexOf("sap-ui")==0){q.sap.log.error("CustomData with key "+k+" should be written to HTML of "+r+" but the key is not valid (may not start with 'sap-ui').");return null;}return{key:"data-"+k,value:v};};
return C;});
sap.ui.predefine('sap/ui/core/CustomizingConfiguration',['jquery.sap.global','./Core','./Component'],function(q,C,a){"use strict";var b="sap.ui.viewReplacements",c="sap.ui.viewExtensions",d="sap.ui.viewModifications",e="sap.ui.controllerExtensions",f="sap.ui.controllerReplacements";var m={};
function g(t,o,i){var s=o&&typeof o==="string"?o:(o&&a.getOwnerIdFor(o));if(s){var j=a.get(s);var k=j&&j.getMetadata().getComponentName();var l=m[k+"::"+s];if(l&&l[t]&&i(l[t])){return false;}else{l=m[k];if(l&&l[t]&&i(l[t])){return false;}}}else{q.each(m,function(k,l){if(l&&l[t]&&i(l[t])){return false;}});}}
var h={log:function(){if(window.console){window.console.log(m);}},activateForComponent:function(s){q.sap.log.info("CustomizingConfiguration: activateForComponent('"+s+"')");var F=s+".Component";q.sap.require(F);var o=q.sap.getObject(F).getMetadata().getCustomizing();m[s]=o;q.sap.log.debug("CustomizingConfiguration: customizing configuration for component '"+s+"' loaded: "+JSON.stringify(o));},deactivateForComponent:function(s){if(m[s]){q.sap.log.info("CustomizingConfiguration: deactivateForComponent('"+s+"')");delete m[s];}},activateForComponentInstance:function(o){q.sap.log.info("CustomizingConfiguration: activateForComponentInstance('"+o.getId()+"')");var s=o.getMetadata().getComponentName(),k=s+"::"+o.getId(),i=o.getManifest()["sap.ui5"]&&o.getManifest()["sap.ui5"]["extends"]&&o.getManifest()["sap.ui5"]["extends"]["extensions"];m[k]=i;q.sap.log.debug("CustomizingConfiguration: customizing configuration for component '"+k+"' loaded: "+JSON.stringify(i));},deactivateForComponentInstance:function(o){var s=o.getMetadata().getComponentName(),k=s+"::"+o.getId();if(m[k]){q.sap.log.info("CustomizingConfiguration: deactivateForComponent('"+k+"')");delete m[k];}},getViewReplacement:function(v,o){var r;g(b,o,function(i){r=i[v];return!!r;});return r;},getViewExtension:function(v,E,o){var r;g(c,o,function(i){r=i[v]&&i[v][E];return!!r;});return r;},getControllerExtension:function(s,o){var r;g(e,o,function(i){r=i[s];return!!r;});return r;},getControllerReplacement:function(s,o){var r;g(f,o,function(i){r=i[s];return!!r;});return r;},getCustomProperties:function(v,s,o){var S;g(d,o,function(i){var j=i[v]&&i[v][s];var u={};var V=false;if(j){q.each(j,function(n,k){if(n==="visible"){V=true;u[n]=k;q.sap.log.info("Customizing: custom value for property '"+n+"' of control '"+s+"' in View '"+v+"' applied: "+k);}else{q.sap.log.warning("Customizing: custom value for property '"+n+"' of control '"+s+"' in View '"+v+"' ignored: only the 'visible' property can be customized.");}});if(V){S=S||{};q.extend(S,u);}}});return S;},hasCustomProperties:function(v,o){var s={};g(d,o,function(i){if(!!i[v]){s=i[v];}});return(!q.isEmptyObject(s));}};if(sap.ui.getCore().getConfiguration().getDisableCustomizing()){q.sap.log.info("CustomizingConfiguration: disabling Customizing now");q.each(h,function(n,A){if(typeof A==="function"){h[n]=function(){};}});}return h;},true);
sap.ui.predefine('sap/ui/core/DeclarativeSupport',['jquery.sap.global','sap/ui/base/DataType','sap/ui/base/ManagedObject','./Control','./CustomData','./HTML','./mvc/View','./mvc/EventHandlerResolver'],function(q,D,M,C,a,H,V,E){"use strict";var b={};b.attributes={"data-sap-ui-type":true,"data-sap-ui-id":true,"data-sap-ui-aggregation":true,"data-sap-ui-default-aggregation":true,"data-sap-ui-binding":function(v,s){var B=M.bindingParser(v);s.objectBindings=s.objectBindings||{};s.objectBindings[B.model||undefined]=B;},"data-tooltip":function(v,s){s["tooltip"]=v;},"tooltip":function(v,s,c){s["tooltip"]=v;q.sap.log.warning('[Deprecated] Control "'+s.id+'": The attribute "tooltip" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.');},"class":true,"style":true,"id":true};
b.compile=function(e,v,i){var t=this;q(e).find("[data-sap-ui-type]").filter(function(){return q(this).parents("[data-sap-ui-type]").length===0;}).each(function(){t._compile(this,v,i);});};
b._compile=function(e,v,i){var $=q(e);var t=$.attr("data-sap-ui-type");var c=[];var I=t==="sap.ui.core.UIArea";if(I){var d=this;$.children().each(function(){var o=d._createControl(this,v);if(o){c.push(o);}});}else{var o=this._createControl(e,v);if(o){c.push(o);}}$.empty();var A=[];q.each(e.attributes,function(f,g){var n=g.name;if(!I||I&&/^data-/g.test(n.toLowerCase())){A.push(n);}});if(A.length>0){$.removeAttr(A.join(" "));}c.forEach(function(o){if(o instanceof C){if(v&&!i){v.addContent(o);}else{o.placeAt(e);if(v){v.connectControl(o);}}}});};
b._createControl=function(e,v){var $=q(e);var c=null;var t=$.attr("data-sap-ui-type");if(t){q.sap.require(t);var f=q.sap.getObject(t);var s={};s.id=this._getId($,v);this._addSettingsForAttributes(s,f,e,v);this._addSettingsForAggregations(s,f,e,v);var c;if(V.prototype.isPrototypeOf(f.prototype)&&typeof f._sType==="string"){c=sap.ui.view(s,undefined,f._sType);}else{c=new f(s);}if(e.className){c.addStyleClass(e.className);}$.removeAttr("data-sap-ui-type");}else{c=this._createHtmlControl(e,v);}return c;};
b._createHtmlControl=function(e,v){var h=new H();h.setDOMContent(e);this.compile(e,v,true);return h;};
b._addSettingsForAttributes=function(s,c,e,v){var t=this;var S=b.attributes;var B=M.bindingParser;var d=[];var r=/^data-custom-data:(.+)/i;q.each(e.attributes,function(i,A){var n=A.name;var f=A.value;if(!r.test(n)){if(typeof S[n]==="undefined"){n=t.convertAttributeToSettingName(n,s.id);var p=t._getProperty(c,n);if(p){var o=B(f,v&&v.getController(),true);if(o&&typeof o==="object"){s[n]=o;}else{s[n]=t.convertValueToType(t.getPropertyDataType(p),o||f);}}else if(t._getAssociation(c,n)){var g=t._getAssociation(c,n);if(g.multiple){f=f.replace(/\s*,\s*|\s+/g,",");s[n]=f.split(",").map(function(I){return v?v.createId(I):I;});}else{s[n]=v?v.createId(f):f;}}else if(t._getAggregation(c,n)){var h=t._getAggregation(c,n);if(h.multiple){var o=B(f,v&&v.getController());if(o){s[n]=o;}else{throw new Error("Aggregation "+n+" with cardinality 0..n only allows binding paths as attribute value");}}else if(h.altTypes){var o=B(f,v&&v.getController(),true);if(o&&typeof o==="object"){s[n]=o;}else{s[n]=t.convertValueToType(h.altTypes[0],o||f);}}else{throw new Error("Aggregation "+n+" not supported");}}else if(t._getEvent(c,n)){var j=v&&(v._oContainingView||v).getController();var k=E.resolveEventHandler(f,j);if(k){s[n]=k;}else{throw new Error('Control "'+s.id+'": The function "'+f+'" for the event "'+n+'" is not defined');}}else{}}else if(typeof S[n]==="function"){S[n](f,s,c);}}else{n=q.sap.camelCase(r.exec(n)[1]);var o=B(f,v&&v.getController());d.push(new a({key:n,value:o||f}));}});if(d.length>0){s.customData=d;}return s;};
b._addSettingsForAggregations=function(s,c,e,v){var $=q(e);var d=this._getDefaultAggregation(c,e);var t=this;var A=c.getMetadata().getAllAggregations();$.children().each(function(){var f=q(this);var g=f.attr("data-sap-ui-aggregation");var T=f.attr("data-sap-ui-type");var u=false;if(!g){u=true;g=d;}if(g&&A[g]){var m=A[g].multiple;var h=function(o){var i=t._createControl(o,v);if(i){if(m){if(!s[g]){s[g]=[];}if(typeof s[g].path==="string"){s[g].template=i;}else{s[g].push(i);}}else{s[g]=i;}}};if(u||(T&&!u)){h(this);}else{f.children().each(function(){h(this);});}}f.removeAttr("data-sap-ui-aggregation");f.removeAttr("data-sap-ui-type");});return s;};
b._getId=function(e,v){var $=q(e);var i=$.attr("id");if(i){if(v){i=v.createId(i);$.attr("data-sap-ui-id",i);}$.attr("id","");}return i;};
b._getProperty=function(c,n){return c.getMetadata().getProperty(n);};
b.convertValueToType=function(t,v){if(t instanceof D){v=t.parseValue(v);}return typeof v==="string"?M.bindingParser.escape(v):v;};
b.getPropertyDataType=function(p){var t=D.getType(p.type);if(!t){throw new Error("Property "+p.name+" has no known type");}return t;};
b.convertAttributeToSettingName=function(A,i,d){if(A.indexOf("data-")===0){A=A.substr(5);}else if(d){q.sap.log.warning('[Deprecated] Control "'+i+'": The attribute "'+A+'" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.');}else{throw new Error('Control "'+i+'": The attribute "'+A+'" is not prefixed with "data-*".');}return q.sap.camelCase(A);};
b._getAssociation=function(c,n){return c.getMetadata().getAssociation(n);};
b._getAggregation=function(c,n){return c.getMetadata().getAggregation(n);};
b._getEvent=function(c,n){return c.getMetadata().getEvent(n);};
b._getDefaultAggregation=function(c,e){var $=q(e);var d=$.attr("data-sap-ui-default-aggregation")||c.getMetadata().getDefaultAggregationName();$.removeAttr("data-sap-ui-default-aggregation");return d;};
return b;},true);
sap.ui.predefine('sap/ui/core/EnabledPropagator',['./Control'],function(C){"use strict";var E=function(d,l){if(!(this instanceof C)){throw new Error("EnabledPropagator only supports subclasses of Control");}if(d===undefined){d=true;}function f(c){var p=c.getParent();while(p&&!p.getEnabled&&p.getParent){p=p.getParent();}return p;}if(this.getEnabled===undefined){this.getEnabled=function(){var p=f(this);return(p&&p.getEnabled&&!p.getEnabled())?false:this.getProperty("enabled");};if(l){this.getMetadata().addProperty("Enabled",{type:"boolean",group:"Behavior",defaultValue:!!d});}this.getMetadata().addProperty("enabled",{type:"boolean",group:"Behavior",defaultValue:!!d});this.getMetadata().addPublicMethods('getEnabled');}else{var o=this.getEnabled;this.getEnabled=function(){var p=f(this);return(p&&p.getEnabled&&!p.getEnabled())?false:o.apply(this);};}if(this.setEnabled===undefined){this.setEnabled=function(e){return this.setProperty("enabled",e);};this.getMetadata().addPublicMethods('setEnabled');}};return E;},true);
sap.ui.predefine('sap/ui/core/EventBus',['jquery.sap.global','sap/ui/base/Object','sap/ui/base/EventProvider'],function(q,B,E){"use strict";
var a=B.extend("sap.ui.core.EventBus",{constructor:function(){B.apply(this);this._mChannels={};this._defaultChannel=new E();}});
a.prototype.subscribe=function(c,e,f,l){if(typeof(e)==="function"){l=f;f=e;e=c;c=null;}var C=b(this,c);C.attachEvent(e,f,l);return this;};
a.prototype.subscribeOnce=function(c,e,f,l){if(typeof(e)==="function"){l=f;f=e;e=c;c=null;}function o(){this.unsubscribe(c,e,o,undefined);f.apply(l||this,arguments);}return this.subscribe(c,e,o,undefined);};
a.prototype.unsubscribe=function(c,e,f,l){if(typeof(e)==="function"){l=f;f=e;e=c;c=null;}var C=g(this,c);if(!C){return this;}C.detachEvent(e,f,l);if(C!=this._defaultChannel){var m=E.getEventList(C);var i=true;for(var I in m){if(C.hasListeners(I)){i=false;break;}}if(i){delete this._mChannels[c];}}return this;};
a.prototype.publish=function(c,e,d){if(arguments.length==1){d=null;e=c;c=null;}else if(arguments.length==2){if(typeof(e)!="string"){d=e;e=c;c=null;}}d=d?d:{};var C=g(this,c);if(!C){if(q.sap.log.isLoggable(q.sap.log.Level.DEBUG,"sap.ui.core.EventBus")){q.sap.log.debug("Failed to publish into channel '"+c+"'."+" No such channel.",c,"sap.ui.core.EventBus");}return;}var f=E.getEventList(C)[e];if(Array.isArray(f)){f=f.slice();var I;for(var i=0,l=f.length;i<l;i++){I=f[i];this._callListener(I.fFunction,I.oListener||this,c,e,d);}}else if(q.sap.log.isLoggable(q.sap.log.Level.DEBUG,"sap.ui.core.EventBus")){q.sap.log.debug("Failed to publish Event '"+e+"' in '"+c+"'."+" No listeners found.",c+"#"+e,"sap.ui.core.EventBus");}};
a.prototype.getInterface=function(){return this;};
a.prototype._callListener=function(c,l,C,e,d){c.call(l,C,e,d);};
a.prototype.destroy=function(){this._defaultChannel.destroy();for(var c in this._mChannels){this._mChannels[c].destroy();}this._mChannels={};B.prototype.destroy.apply(this,arguments);};
function g(e,c){if(!c){return e._defaultChannel;}return e._mChannels[c];}
function b(e,c){var C=g(e,c);if(!C&&c){e._mChannels[c]=new E();C=e._mChannels[c];}return C;}
return a;});
sap.ui.predefine('sap/ui/core/ExtensionPoint',['jquery.sap.global'],function(q){"use strict";
sap.ui.extensionpoint=function(c,e,C,t,a){q.sap.log.warning("Do not use deprecated factory function 'sap.ui.extensionpoint'. Use 'sap.ui.core.ExtensionPoint.load' instead");return E._factory(c,e,C,t,a);};
var E=sap.ui.extensionpoint;
E._factory=function(c,e,C,t,a){var b,v,r;var d=sap.ui.require('sap/ui/core/CustomizingConfiguration'),V=sap.ui.require('sap/ui/core/mvc/View'),F=sap.ui.require('sap/ui/core/Fragment');if(d){if(V&&c instanceof V){b=d.getViewExtension(c.sViewName,e,c);v=c;}else if(F&&c instanceof F){b=d.getViewExtension(c.getFragmentName(),e,c);v=c._oContainingView;}if(b){if(b.className){q.sap.require(b.className);var o=q.sap.getObject(b.className),I=v&&b.id?v.createId(b.id):b.id;q.sap.log.info("Customizing: View extension found for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className+": "+(b.viewName||b.fragmentName));if(b.className==="sap.ui.core.Fragment"){var f=new o({id:I,type:b.type,fragmentName:b.fragmentName,containingView:v});r=(Array.isArray(f)?f:[f]);}else if(b.className==="sap.ui.core.mvc.View"){var v=sap.ui.view({type:b.type,viewName:b.viewName,id:I});r=[v];}else{q.sap.log.warning("Customizing: Unknown extension className configured (and ignored) in Component.js for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className);}}else{q.sap.log.warning("Customizing: no extension className configured in Component.js for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className);}}}if(!r&&typeof C==='function'){r=C();}var p=function(r){if(r&&!Array.isArray(r)){r=[r];}if(r&&t){var A=t.getMetadata().getAggregation(a);if(A){for(var i=0,l=r.length;i<l;i++){t[A._sMutator](r[i]);}}else{q.sap.log.error("Creating extension point failed - Tried to add extension point with name "+e+" to an aggregation of "+t.getId()+" in view "+v.sViewName+", but sAggregationName was not provided correctly and I could not find a default aggregation");}}return r||[];};if(r&&typeof r.then==='function'){return r.then(p);}else{return p(r);}};
E.load=function(o){return Promise.resolve(E._factory(o.container,o.name,o.createDefaultContent));};
return E;});
sap.ui.predefine('sap/ui/core/Fragment',['jquery.sap.global','../base/ManagedObject','./Element','./DeclarativeSupport','./XMLTemplateProcessor'],function(q,M,E,D,X){"use strict";var r={},t={};
var F=M.extend("sap.ui.core.Fragment",{
metadata:{properties:{type:"string"},specialSettings:{fragmentName:'string',fragmentContent:'any',containingView:{type:'sap.ui.core.mvc.View',visibility:'hidden'},oController:{type:'sap.ui.core.mvc.Controller',visibility:'hidden'},sId:{type:'sap.ui.core.ID',visibility:'hidden'}}},
constructor:function(i,s){M.apply(this,arguments);if(this._aContent&&this._aContent.length==1){return this._aContent[0];}else{return this._aContent;}}
});
F.registerType=function(T,f){if(!typeof(T)==="string"){q.sap.log.error("Ignoring non-string Fragment type: "+T);return;}if(t[T]){q.sap.log.warning("sap.ui.core.Fragment.registerType(): Fragment type '"+T+"' is already defined. Overriding this type now!");}t[T]=f;};
F.prototype._initCompositeSupport=function(s){if(!s){throw new Error("Settings must be set");}if(!(s.fragmentName||s.fragmentContent)){throw new Error("Please provide a fragment name");}if(s.oController){this.oController=s.oController;}this._sExplicitId=s.sId||s.id;this._sFragmentName=s.fragmentName;var f=t[s.type];if(f){f.init.apply(this,[s]);}else{throw new Error("No type for the fragment has been specified: "+s.type);}};
F.prototype.getFragmentName=function(){return this._sFragmentName;};
F.prototype.getController=function(){return this.oController;};
F.byId=function(f,i){if(!(typeof(f)==="string"&&typeof(i)==="string")){q.sap.log.error("sap.ui.core.Fragment.byId: two strings must be given as parameters, but are: "+f+" and "+i);return undefined;}return sap.ui.getCore().byId(f+"--"+i);};
F.createId=function(f,i){if(!(typeof(f)==="string"&&typeof(i)==="string")){q.sap.log.error("sap.ui.core.Fragment.createId: two strings must be given as parameters, but are: "+f+" and "+i);return undefined;}return f+"--"+i;};
F.prototype.createId=function(i){var a=this._sExplicitId?this._sExplicitId+"--"+i:i;if(this._oContainingView&&this._oContainingView!=this){a=this._oContainingView.createId(a);}return a;};
F.prototype.isSubView=function(){return true;};
sap.ui.fragment=function(n,T,c){var s={};if(typeof(n)==="string"){s.fragmentName=n;s.oController=c;s.type=T;}else if(typeof(n)==="object"){s=n;if(T){s.oController=T;}}else{q.sap.log.error("sap.ui.fragment() must be called with Fragment name or config object as first parameter, but is: "+n);}return new F(s);};
sap.ui.xmlfragment=function(i,f,c){if(typeof(i)==="string"){if(typeof(f)==="string"){return sap.ui.fragment({fragmentName:f,sId:i,type:"XML"},c);}else{return sap.ui.fragment(i,"XML",f);}}else{i.type="XML";return sap.ui.fragment(i,f);}};
sap.ui.jsfragment=function(n,f){if(typeof(n)==="string"&&typeof(f)==="object"){if(f.createContent){r[n]=f;q.sap.declare({modName:n,type:"fragment"},false);}else{return sap.ui.fragment(n,"JS",f);}}else if(typeof(n)==="string"&&f===undefined){return sap.ui.fragment(n,"JS");}else{if(typeof(n)==="object"){n.type="JS";return sap.ui.fragment(n,f);}else if(arguments&&arguments.length>=3){return sap.ui.fragment({id:n,fragmentName:f,type:"JS"},arguments[2]);}else{q.sap.log.error("sap.ui.jsfragment() was called with wrong parameter set: "+n+" + "+f);}}};
sap.ui.htmlfragment=function(i,f,c){if(typeof(i)==="string"){if(typeof(f)==="string"){return sap.ui.fragment({fragmentName:f,sId:i,type:"HTML"},c);}else{return sap.ui.fragment(i,"HTML",f);}}else{i.type="HTML";return sap.ui.fragment(i,f);}};
F.registerType("XML",{init:function(s){if(s.fragmentContent){if(typeof(s.fragmentContent)==="string"){this._xContent=q.parseXML(s.fragmentContent).documentElement;}else{this._xContent=s.fragmentContent;}}else{this._xContent=X.loadTemplate(s.fragmentName,"fragment");}this._oContainingView=this._sExplicitId?this:(s.containingView||this);if((this._oContainingView===this)){this._oContainingView.oController=(s.containingView&&s.containingView.oController)||s.oController;}var a=this;M.runWithPreprocessors(function(){a._aContent=X.parseTemplate(a._xContent,a);if(a._aContent&&a._aContent.length&&s.objectBindings){a._aContent.forEach(function(c,i){if(c instanceof E){for(var m in s.objectBindings){c.bindObject(s.objectBindings[m]);}}});}},{settings:a._oContainingView._fnSettingsPreprocessor});}});F.registerType("JS",{init:function(s){if(!r[s.fragmentName]){q.sap.require({modName:s.fragmentName,type:"fragment"});}q.extend(this,r[s.fragmentName]);this._oContainingView=s.containingView||this;var a=this;M.runWithPreprocessors(function(){var c=a.createContent(s.oController||a._oContainingView.oController);a._aContent=[];a._aContent=a._aContent.concat(c);},{settings:a._oContainingView._fnSettingsPreprocessor});}});(function(){var _={};var a=function(T){var u=q.sap.getModulePath(T,".fragment.html");var h=_[u];var R;if(!h){R=q.sap.getResourceName(T,".fragment.html");h=q.sap.loadResource(R);_[u]=h;}return h;};F.registerType("HTML",{init:function(s){this._aContent=[];this.getContent=function(){return this._aContent;};this.addContent=function(c){this._aContent.push(c);};this._oContainingView=s.containingView||this;var h=s.fragmentContent||a(s.fragmentName);this._oTemplate=document.createElement("div");if(typeof h==="string"){this._oTemplate.innerHTML=h;}else{var n=h;var f=document.createDocumentFragment();for(var i=0;i<n.length;i++){f.appendChild(n.item(i));}this._oTemplate.appendChild(f);}var m=this._oTemplate.getElementsByTagName("template")[0];var p=this.getMetadata().getAllProperties();if(m){var b=this;q.each(m.attributes,function(I,A){var N=D.convertAttributeToSettingName(A.name,b.getId());var v=A.value;var P=p[N];if(!s[N]){if(P){s[N]=D.convertValueToType(D.getPropertyDataType(P),v);}else if(sap.ui.core.mvc.HTMLView._mAllowedSettings[N]){s[N]=v;}}});this._oTemplate=m;}if(this._oTemplate.content){var f=this._oTemplate.content;this._oTemplate=document.createElement("div");this._oTemplate.appendChild(f);}var b=this;M.runWithPreprocessors(function(){D.compile(b._oTemplate,b);var c=b.getContent();if(c&&c.length===1){b._aContent=[c[0]];}},{settings:b._oContainingView._fnSettingsPreprocessor});}});}());return F;});
sap.ui.predefine('sap/ui/core/HTML',['jquery.sap.global','./Control','./RenderManager',"./HTMLRenderer"],function(q,C,R,H){"use strict";var b=R.RenderPrefixes;
var c=C.extend("sap.ui.core.HTML",{metadata:{library:"sap.ui.core",properties:{content:{type:"string",group:"Misc",defaultValue:null},preferDOM:{type:"boolean",group:"Misc",defaultValue:true},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{afterRendering:{parameters:{isPreservedDOM:{type:"boolean"}}}}}});
c.prototype.getDomRef=function(s){var i=s?this.getId()+"-"+s:this.getId();return q.sap.domById(b.Dummy+i)||q.sap.domById(i);};
c.prototype.setContent=function(d){function p(s){if(q.parseHTML){var a=q.parseHTML(s);if(a){var e=0,f=a.length;while(e<f&&a[e].nodeType!=1){e++;}while(e<f&&a[f-1].nodeType!=1){f--;}if(e>0||f<a.length){a=a.slice(e,f);}return q(a);}}return q(s);}if(this.getSanitizeContent()){d=q.sap._sanitizeHTML(d);}this.setProperty("content",d,true);if(this.getDomRef()){var $=p(this.getContent());q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{this.invalidate();}return this;};
c.prototype.setSanitizeContent=function(s){this.setProperty("sanitizeContent",s,true);if(s){this.setContent(this.getContent());}return this;};
c.prototype.onBeforeRendering=function(){if(this.getPreferDOM()&&this.getDomRef()&&!R.isPreservedContent(this.getDomRef())){R.preserveContent(this.getDomRef(),true,false);}};
c.prototype.onAfterRendering=function(){if(!this.getVisible()){return;}var $=q(q.sap.domById(b.Dummy+this.getId()));var a=R.findPreservedContent(this.getId());var d;var i=false;if((!this.getPreferDOM()||a.size()==0)){a.remove();d=new q(this.getContent());$.replaceWith(d);}else if(a.size()>0){$.replaceWith(a);d=a;i=true;}else{$.remove();}this._postprocessNewContent(d);this.fireAfterRendering({isPreservedDOM:i});};
c.prototype._postprocessNewContent=function($){if($&&$.size()>0){if($.length>1){q.sap.log.warning("[Unsupported Feature]: "+this+" has rendered "+$.length+" root nodes!");}else{var s=$.attr("id");if(s&&s!=this.getId()){q.sap.log.warning("[Unsupported Feature]: Id of HTML Control '"+this.getId()+"' does not match with content id '"+s+"'!");}}R.markPreservableContent($,this.getId());if($.find("#"+this.getId().replace(/(:|\.)/g,'\\$1')).length===0){$.filter(":not([id])").first().attr("id",this.getId());}}else{q.sap.log.debug(""+this+" is empty after rendering, setting bOutput to false");this.bOutput=false;}};
c.prototype.setDOMContent=function(d){var $=q(d);if(this.getDomRef()){q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{$.appendTo(R.getPreserveAreaRef());if(this.getUIArea()){this.getUIArea().invalidate();}this._postprocessNewContent($);}return this;};
c.prototype.setTooltip=function(){q.sap.log.warning("The sap.ui.core.HTML control doesn't support tooltips. Add the tooltip to the HTML content instead.");return C.prototype.setTooltip.apply(this,arguments);};
"hasStyleClass addStyleClass removeStyleClass toggleStyleClass".split(" ").forEach(function(m){c.prototype[m]=function(){q.sap.log.warning("The sap.ui.core.HTML control doesn't support custom style classes. Manage custom CSS classes in the HTML content instead.");return C.prototype[m].apply(this,arguments);};});return c;});
sap.ui.predefine('sap/ui/core/HTMLRenderer',['./RenderManager'],function(R){"use strict";var a=R.RenderPrefixes;var H={render:function(r,c){r.write("<div id=\""+a.Dummy+c.getId()+"\" style=\"display:none\">");r.write("</div>");}};return H;},true);
sap.ui.predefine('sap/ui/core/History',['jquery.sap.global','sap/ui/base/Object','jquery.sap.storage'],function(q,B){"use strict";
var H=B.extend("sap.ui.core.History",{
constructor:function(i,s){B.apply(this);if(!s){s={};}var h=s.prefix?s.prefix:document.location.pathname;this._iMaxHistory=s.max?s.max:100;this._sHistoryId=h+i;this._oStorage=q.sap.storage(q.sap.storage.Type.local);this._fFilter=s.filter?s.filter:function(a,v){return a&&(!v||(v&&q.sap.startsWithIgnoreCase(a,v)));};this._fCheckHistory=s.checkHistory?s.checkHistory:function(a){return a;};},
_initHistory:function(){if(!this._aHistory){var h=this._oStorage.get(this._sHistoryId);if(typeof(h)==="string"){h=h.split(",");}else if(!h){h=[];}this._aHistory=this._fCheckHistory(h);}return this._aHistory;},
get:function(v){var h=this._initHistory();var r=[];for(var i=0;i<h.length;i++){if(this._fFilter(h[i],v)){r.push(h[i]);}}return r;},
remove:function(v){var h=this._initHistory();for(var i=0;i<h.length;i++){if(h[i]==v){h.splice(i,1);break;}}},
add:function(v){var h=this._initHistory();for(var i=0;i<h.length;i++){if(h[i]===v){h.splice(i,1);break;}}h.unshift(v);if(h.length>this._iMaxHistory){h.splice(this._iMaxHistory);}this._oStorage.put(this._sHistoryId,h);},
clear:function(){this._oStorage.remove(this._sHistoryId);this._aHistory=null;}
});
return H;});
sap.ui.predefine('sap/ui/core/Icon',['jquery.sap.global','sap/base/assert','../Device','./Control','./IconPool','./InvisibleText','./library',"./IconRenderer",'jquery.sap.keycodes'],function(q,a,D,C,I,b,l,c){"use strict";var d=l.IconColor;
var e=C.extend("sap.ui.core.Icon",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.core",designtime:"sap/ui/core/designtime/Icon.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},color:{type:"string",group:"Appearance",defaultValue:null},hoverColor:{type:"string",group:"Appearance",defaultValue:null},activeColor:{type:"string",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},hoverBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},activeBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},useIconTooltip:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},noTabStop:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{_invisibleText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
e.prototype[D.support.touch?"ontouchstart":"onmousedown"]=function(E){if(this.hasListeners("press")){E.setMarked();}var A=this.getActiveColor(),s=this.getActiveBackgroundColor(),i;if(A||s){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===1)){i=this.$();i.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}}};e.prototype[D.support.touch?"ontouchend":"onmouseup"]=function(E){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===0)){this.$().removeClass("sapUiIconActive");this._restoreColors();}};
e.prototype.onmouseover=function(){var h=this.getHoverColor(),H=this.getHoverBackgroundColor();if(h){this._addColorClass(h,"color");}if(H){this._addColorClass(H,"background-color");}};
e.prototype.onmouseout=function(){this._restoreColors();};
e.prototype[D.support.touch&&!D.system.desktop?"ontap":"onclick"]=function(E){if(this.hasListeners("press")){E.setMarked();}this.firePress({});};
e.prototype.onkeydown=function(E){if(E.which===q.sap.KeyCodes.SPACE||E.which===q.sap.KeyCodes.ENTER){E.preventDefault();var i=this.$(),A=this.getActiveColor(),s=this.getActiveBackgroundColor();i.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}};
e.prototype.onkeyup=function(E){if(E.which===q.sap.KeyCodes.SPACE||E.which===q.sap.KeyCodes.ENTER){this.$().removeClass("sapUiIconActive");this._restoreColors();this.firePress({});}};
e.prototype._restoreColors=function(){this._addColorClass(this.getColor()||"","color");this._addColorClass(this.getBackgroundColor()||"","background-color");};
e.prototype.setSrc=function(s){a(s==null||I.isIconURI(s),this+": Property 'src' (value: '"+s+"') should be a valid Icon URI (sap-icon://...)");var i=I.getIconInfo(s,undefined,"mixed"),$=this.$(),f,t,u,L,o;this.setProperty("src",s,!!i);if(i instanceof Promise){i.then(this.invalidate.bind(this));}else if(i&&$.length){$.css("font-family",i.fontFamily);$.attr("data-sap-ui-icon-content",i.content);$.toggleClass("sapUiIconMirrorInRTL",!i.suppressMirroring);t=this.getTooltip_AsString();L=this.getAriaLabelledBy();u=this.getUseIconTooltip();f=this._getIconLabel(i);if(t||(u&&i.text)){$.attr("title",t||i.text);}else{$.attr("title",null);}if(L.length===0){if(f){$.attr("aria-label",f);}else{$.attr("aria-label",null);}}else{o=this.getAggregation("_invisibleText");if(o){o.setText(f);}}}return this;};
e.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};
e.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css({"height":h,"line-height":h});return this;};
e.prototype.setSize=function(s){this.setProperty("size",s,true);this.$().css("font-size",s);return this;};
e.prototype.setColor=function(s){this.setProperty("color",s,true);this._addColorClass(s,"color");return this;};
e.prototype._addColorClass=function(s,f){var i=this.$(),t=this;var g="";if(f==="color"){g="sapUiIconColor";}else if(f==="background-color"){g="sapUiIconBGColor";}else{return;}q.each(d,function(p,P){t.removeStyleClass(g+P);});if(s in d){i.css(f,"");this.addStyleClass(g+s);}else{i.css(f,s);}};
e.prototype.setActiveColor=function(s){return this.setProperty("activeColor",s,true);};
e.prototype.setHoverColor=function(s){return this.setProperty("hoverColor",s,true);};
e.prototype.setBackgroundColor=function(s){this.setProperty("backgroundColor",s,true);this._addColorClass(s,"background-color");return this;};
e.prototype.setActiveBackgroundColor=function(s){return this.setProperty("activeBackgroundColor",s,true);};
e.prototype.setHoverBackgroundColor=function(s){return this.setProperty("hoverBackgroundColor",s,true);};
e.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.attachEvent.apply(this,m);if(this.hasListeners("press")){this.$().toggleClass("sapUiIconPointer",true).attr({role:"button",tabindex:this.getNoTabStop()?undefined:0});}return this;};
e.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.detachEvent.apply(this,m);if(!this.hasListeners("press")){this.$().toggleClass("sapUiIconPointer",false).attr({role:this.getDecorative()?"presentation":"img"}).removeAttr("tabindex");}return this;};
e.prototype._getOutputTitle=function(i){var t=this.getTooltip_AsString(),u=this.getUseIconTooltip();if(t||(u&&i&&i.text)){return t||i.text;}};
e.prototype._getIconLabel=function(i){var A=this.getAlt(),t=this.getTooltip_AsString(),u=this.getUseIconTooltip(),L=A||t||(u&&i&&(i.text||i.name)),o=this._getOutputTitle(i);if(L&&L!==o){return L;}};
e.prototype._createInvisibleText=function(t){var i=this.getAggregation("_invisibleText");if(!i){i=new b(this.getId()+"-label",{text:t});this.setAggregation("_invisibleText",i,true);}else{i.setProperty("text",t,true);}return i;};
e.prototype._getAccessibilityAttributes=function(i){var L=this.getAriaLabelledBy(),A={},s=this._getIconLabel(i),o;if(this.getDecorative()){A.role="presentation";A.hidden="true";}else{if(this.hasListeners("press")){A.role="button";}else{A.role="img";}}if(L.length>0){if(s){o=this._createInvisibleText(s);L.push(o.getId());}A.labelledby=L.join(" ");}else if(s){A.label=s;}return A;};
e.prototype.getAccessibilityInfo=function(){if(this.getDecorative()){return null;}var h=this.hasListeners("press");var i=I.getIconInfo(this.getSrc(),undefined,"sync");return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.core").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||(i?i.text||i.name:""),focusable:h};};
return e;});
sap.ui.predefine('sap/ui/core/IconPool',['jquery.sap.global','./Core','sap/ui/thirdparty/URI'],function(q,c,U){"use strict";var S='SAP-icons';var I='sap-icon';var f={undefined:{config:{fontFamily:S},metadataLoaded:true,inserted:false}};var r={'undefined':{'accidental-leave':0xe000,'account':0xe001,'wrench':0xe002,'windows-doors':0xe003,'washing-machine':0xe004,'visits':0xe005,'video':0xe006,'travel-expense':0x1e007,'temperature':0xe008,'task':0x1e009,'synchronize':0xe00a,'survey':0x1e00b,'settings':0xe00c,'search':0x1e00d,'sales-document':0x1e00e,'retail-store':0xe00f,'refresh':0xe010,'product':0xe011,'present':0xe012,'ppt-attachment':0xe013,'pool':0xe014,'pie-chart':0xe015,'picture':0xe016,'photo-voltaic':0xe017,'phone':0xe018,'pending':0xe019,'pdf-attachment':0xe01a,'past':0x1e01b,'outgoing-call':0xe01c,'opportunity':0xe01d,'opportunities':0x1e01e,'notes':0xe01f,'money-bills':0x1e020,'map':0xe021,'log':0xe022,'line-charts':0xe023,'lightbulb':0xe024,'leads':0xe025,'lead':0x1e026,'laptop':0xe027,'kpi-managing-my-area':0x1e028,'kpi-corporate-performance':0x1e029,'incoming-call':0xe02a,'inbox':0xe02b,'horizontal-bar-chart':0xe02c,'history':0xe02d,'heating-cooling':0xe02e,'gantt-bars':0xe02f,'future':0x1e030,'fridge':0xe031,'fallback':0xe032,'expense-report':0x1e033,'excel-attachment':0xe034,'energy-saving-lightbulb':0xe035,'employee':0xe036,'email':0xe037,'edit':0xe038,'duplicate':0xe039,'download':0xe03a,'doc-attachment':0xe03b,'dishwasher':0xe03c,'delete':0xe03d,'decline':0xe03e,'complete':0x1e03f,'competitor':0xe040,'collections-management':0xe041,'chalkboard':0x1e042,'cart':0xe043,'card':0xe044,'camera':0xe045,'calendar':0x1e046,'begin':0xe047,'basket':0xe048,'bar-chart':0xe049,'attachment':0xe04a,'arrow-top':0xe04b,'arrow-right':0xe04c,'arrow-left':0xe04d,'arrow-bottom':0xe04e,'approvals':0x1e04f,'appointment':0xe050,'alphabetical-order':0x1e051,'along-stacked-chart':0xe052,'alert':0xe053,'addresses':0xe054,'address-book':0x1e055,'add-filter':0xe056,'add-favorite':0xe057,'add':0xe058,'activities':0x1e059,'action':0xe05a,'accept':0x1e05b,'hint':0x1e05c,'group':0xe05d,'check-availability':0x1e05e,'weather-proofing':0xe05f,'payment-approval':0x1e060,'batch-payments':0x1e061,'bed':0xe062,'arobase':0x1e063,'family-care':0xe064,'favorite':0xe065,'navigation-right-arrow':0xe066,'navigation-left-arrow':0xe067,'e-care':0xe068,'less':0xe069,'lateness':0xe06a,'lab':0xe06b,'internet-browser':0xe06c,'instance':0xe06d,'inspection':0xe06e,'image-viewer':0xe06f,'home':0xe070,'grid':0xe071,'goalseek':0xe072,'general-leave-request':0xe073,'create-leave-request':0xe074,'flight':0xe075,'filter':0xe076,'favorite-list':0xe077,'factory':0xe078,'endoscopy':0xe079,'employee-pane':0xe07a,'employee-approvals':0x1e07b,'email-read':0xe07c,'electrocardiogram':0xe07d,'documents':0xe07e,'decision':0xe07f,'database':0xe080,'customer-history':0xe081,'customer':0xe082,'credit-card':0xe083,'create-entry-time':0xe084,'contacts':0xe085,'compare':0xe086,'clinical-order':0xe087,'chain-link':0xe088,'pull-down':0xe089,'cargo-train':0xe08a,'car-rental':0xe08b,'business-card':0xe08c,'bar-code':0xe08d,'folder-blank':0xe08e,'passenger-train':0xe08f,'question-mark':0x1e090,'world':0xe091,'iphone':0xe092,'ipad':0xe093,'warning':0xe094,'sort':0xe095,'course-book':0xe096,'course-program':0xe097,'add-coursebook':0xe098,'print':0xe099,'save':0xe09a,'play':0x1e09b,'pause':0xe09c,'record':0xe09d,'response':0xe09e,'pushpin-on':0xe09f,'pushpin-off':0xe0a0,'unfavorite':0xe0a1,'learning-assistant':0xe0a2,'timesheet':0xe0a3,'time-entry-request':0xe0a4,'list':0xe0a5,'action-settings':0xe0a6,'share':0xe0a7,'feed':0xe0a8,'role':0xe0a9,'flag':0x1e0aa,'post':0xe0ab,'inspect':0xe0ac,'inspect-down':0xe0ad,'appointment-2':0xe0ae,'target-group':0xe0af,'marketing-campaign':0xe0b0,'notification':0xe0b1,'message-error':0xe0b1,'comment':0xe0b2,'shipping-status':0xe0b3,'collaborate':0xe0b4,'shortcut':0xe0b5,'lead-outdated':0x1e0b6,'tools-opportunity':0xe0b7,'permission':0xe0b8,'supplier':0xe0b9,'table-view':0xe0ba,'table-chart':0xe0bb,'switch-views':0xe0bc,'e-learning':0xe0bd,'manager':0xe0be,'switch-classes':0xe0bf,'simple-payment':0x1e0c0,'signature':0xe0c1,'sales-order-item':0x1e0c2,'sales-order':0x1e0c3,'request':0xe0c4,'receipt':0xe0c5,'puzzle':0xe0c6,'process':0xe0c7,'private':0xe0c8,'popup-window':0xe0c9,'person-placeholder':0xe0ca,'per-diem':0x1e0cb,'paper-plane':0xe0cc,'paid-leave':0x1e0cd,'pdf-reader':0x1e0ce,'overview-chart':0xe0cf,'overlay':0xe0d0,'org-chart':0xe0d1,'number-sign':0xe0d2,'notification-2':0xe0d3,'my-sales-order':0x1e0d4,'meal':0xe0d5,'loan':0x1e0d6,'order-status':0x1e0d7,'customer-order-entry':0x1e0d8,'performance':0xe0d9,'menu':0xe0da,'employee-lookup':0xe0db,'education':0xe0dc,'customer-briefing':0xe0dd,'customer-and-contacts':0xe0de,'my-view':0xe0df,'accelerated':0xe0e0,'to-be-reviewed':0xe0e1,'warning2':0xe0e2,'feeder-arrow':0xe0e3,'quality-issue':0xe0e4,'workflow-tasks':0xe0e5,'create':0xe0e6,'home-share':0xe0e7,'globe':0x1e0e8,'tags':0xe0e9,'work-history':0xe0ea,'x-ray':0xe0eb,'wounds-doc':0xe0ec,'web-cam':0xe0ed,'waiver':0x1e0ee,'vertical-bar-chart':0xe0ef,'upstacked-chart':0xe0f0,'trip-report':0xe0f1,'microphone':0xe0f2,'unpaid-leave':0x1e0f3,'tree':0xe0f4,'toaster-up':0xe0f5,'toaster-top':0xe0f6,'toaster-down':0xe0f7,'time-account':0xe0f8,'theater':0xe0f9,'taxi':0xe0fa,'subway-train':0xe0fb,'study-leave':0xe0fc,'stethoscope':0xe0fd,'step':0xe0fe,'sonography':0xe0ff,'soccor':0xe100,'physical-activity':0xe101,'pharmacy':0xe102,'official-service':0xe103,'offsite-work':0xe104,'nutrition-activity':0xe105,'newspaper':0xe106,'monitor-payments':0x1e107,'map-2':0xe108,'machine':0xe109,'mri-scan':0xe10a,'end-user-experience-monitoring':0xe10b,'unwired':0xe10c,'customer-financial-fact-sheet':0x1e10d,'retail-store-manager':0xe10e,'Netweaver-business-client':0xe10f,'electronic-medical-record':0xe110,'eam-work-order':0x1e111,'customer-view':0xe112,'crm-service-manager':0xe113,'crm-sales':0x1e114,'widgets':0x1e115,'commission-check':0x1e116,'collections-insight':0x1e117,'clinical-tast-tracker':0xe118,'citizen-connect':0xe119,'cart-approval':0x1e11a,'capital-projects':0x1e11b,'bo-strategy-management':0xe11c,'business-objects-mobile':0xe11d,'business-objects-explorer':0xe11e,'business-objects-experience':0xe11f,'bbyd-dashboard':0xe120,'bbyd-active-sales':0x1e121,'business-by-design':0x1e122,'business-one':0x1e123,'sap-box':0xe124,'manager-insight':0xe125,'accounting-document-verification':0x1e126,'hr-approval':0x1e127,'idea-wall':0xe128,'Chart-Tree-Map':0xe129,'cart-5':0xe12a,'cart-4':0xe12b,'wallet':0xe12c,'vehicle-repair':0xe12d,'upload':0xe12e,'unlocked':0xe12f,'umbrella':0xe130,'travel-request':0x1e131,'travel-expense-report':0x1e132,'travel-itinerary':0xe133,'time-overtime':0x1e134,'thing-type':0xe135,'technical-object':0xe136,'tag':0xe137,'syringe':0xe138,'syntax':0xe139,'suitcase':0xe13a,'simulate':0xe13b,'shield':0xe13c,'share-2':0xe13d,'sales-quote':0x1e13e,'repost':0xe13f,'provision':0xe140,'projector':0xe141,'add-product':0xe142,'pipeline-analysis':0xe143,'add-photo':0xe144,'palette':0xe145,'nurse':0xe146,'sales-notification':0x1e147,'mileage':0xe148,'meeting-room':0xe149,'media-forward':0x1e14a,'media-play':0x1e14b,'media-pause':0xe14c,'media-reverse':0x1e14d,'media-rewind':0x1e14e,'measurement-document':0xe14f,'measuring-point':0xe150,'measure':0xe151,'map-3':0xe152,'locked':0xe153,'letter':0xe154,'journey-arrive':0xe155,'journey-change':0xe156,'journey-depart':0xe157,'it-system':0xe158,'it-instance':0xe159,'it-host':0xe15a,'iphone-2':0xe15b,'ipad-2':0xe15c,'inventory':0xe15d,'insurance-house':0xe15e,'insurance-life':0xe15f,'insurance-car':0xe160,'initiative':0xe161,'incident':0x1e162,'group-2':0xe163,'goal':0xe164,'functional-location':0xe165,'full-screen':0xe166,'form':0xe167,'fob-watch':0xe168,'blank-tag':0xe169,'family-protection':0xe16a,'folder':0xe16b,'fax-machine':0xe16c,'example':0xe16d,'eraser':0xe16e,'employee-rejections':0xe16f,'drop-down-list':0xe170,'draw-rectangle':0xe171,'document':0xe172,'doctor':0xe173,'discussion-2':0xe174,'discussion':0xe175,'dimension':0xe176,'customer-and-supplier':0xe177,'crop':0xe178,'add-contact':0xe179,'compare-2':0xe17a,'color-fill':0xe17b,'collision':0xe17c,'curriculum':0xe17d,'chart-axis':0xe17e,'full-stacked-chart':0xe17f,'full-stacked-column-chart':0xe180,'vertical-bar-chart-2':0xe181,'horizontal-bar-chart-2':0xe182,'horizontal-stacked-chart':0xe183,'vertical-stacked-chart':0xe184,'choropleth-chart':0x1e185,'geographic-bubble-chart':0x1e186,'multiple-radar-chart':0xe187,'radar-chart':0xe188,'crossed-line-chart':0xe189,'multiple-line-chart':0xe18a,'multiple-bar-chart':0xe18b,'line-chart':0xe18c,'line-chart-dual-axis':0xe18d,'bubble-chart':0xe18e,'scatter-chart':0xe18f,'multiple-pie-chart':0xe190,'column-chart-dual-axis':0xe191,'tag-cloud-chart':0xe192,'area-chart':0xe193,'cause':0xe194,'cart-3':0xe195,'cart-2':0xe196,'bus-public-transport':0xe197,'burglary':0xe198,'building':0xe199,'border':0xe19a,'bookmark':0xe19b,'badge':0xe19c,'attachment-audio':0xe19d,'attachment-video':0xe19e,'attachment-html':0xe19f,'attachment-photo':0xe1a0,'attachment-e-pub':0xe1a1,'attachment-zip-file':0xe1a2,'attachment-text-file':0xe1a3,'add-equipment':0xe1a4,'add-activity':0x1e1a5,'activity-individual':0xe1a6,'activity-2':0x1e1a7,'add-activity-2':0x1e1a8,'activity-items':0xe1a9,'activity-assigned-to-goal':0xe1aa,'status-completed':0xe1ab,'status-positive':0xe1ab,'status-error':0xe1ac,'status-negative':0xe1ac,'status-inactive':0xe1ad,'status-in-process':0xe1ae,'status-critical':0xe1ae,'blank-tag-2':0xe1af,'cart-full':0xe1b0,'locate-me':0xe1b1,'paging':0xe1b2,'company-view':0xe1b3,'document-text':0xe1b4,'explorer':0xe1b5,'personnel-view':0xe1b6,'sorting-ranking':0xe1b7,'drill-down':0xe1b8,'drill-up':0xe1b9,'vds-file':0xe1ba,'sap-logo-shape':0x1e1bb,'folder-full':0xe1bc,'system-exit':0xe1bd,'system-exit-2':0xe1be,'close-command-field':0xe1bf,'open-command-field':0xe1c0,'sys-enter-2':0x1e1c1,'sys-enter':0x1e1c2,'sys-help-2':0x1e1c3,'sys-help':0x1e1c4,'sys-back':0xe1c5,'sys-back-2':0xe1c6,'sys-cancel':0xe1c7,'sys-cancel-2':0xe1c8,'open-folder':0xe1c9,'sys-find-next':0xe1ca,'sys-find':0xe1cb,'sys-monitor':0xe1cc,'sys-prev-page':0xe1cd,'sys-first-page':0xe1ce,'sys-next-page':0xe1cf,'sys-last-page':0xe1d0,'generate-shortcut':0xe1d1,'create-session':0xe1d2,'display-more':0xe1d3,'enter-more':0xe1d4,'zoom-in':0xe1d5,'zoom-out':0xe1d6,'header':0xe1d7,'detail-view':0xe1d8,'show-edit':0xe1d8,'collapse':0xe1d9,'expand':0xe1da,'positive':0xe1db,'negative':0xe1dc,'display':0xe1dd,'menu2':0xe1de,'redo':0xe1df,'undo':0xe1e0,'navigation-up-arrow':0xe1e1,'navigation-down-arrow':0xe1e2,'down':0xe1e3,'up':0xe1e4,'shelf':0xe1e5,'background':0xe1e6,'resize':0xe1e7,'move':0xe1e8,'show':0xe1e9,'hide':0xe1ea,'nav-back':0xe1eb,'error':0xe1ec,'slim-arrow-right':0xe1ed,'slim-arrow-left':0xe1ee,'slim-arrow-down':0xe1ef,'slim-arrow-up':0xe1f0,'forward':0xe1f1,'overflow':0xe1f2,'value-help':0xe1f3,'multi-select':0x1e1f4,'exit-full-screen':0xe1f5,'sys-add':0xe1f6,'sys-minus':0xe1f7,'dropdown':0xe1f8,'expand-group':0xe1f9,'collapse-group':0xe200,'vertical-grip':0xe1fa,'horizontal-grip':0xe1fb,'sort-descending':0xe1fc,'sort-ascending':0xe1fd,'arrow-down':0xe1fe,'legend':0xe1ff,'message-warning':0xe201,'message-information':0x1e202,'message-success':0x1e203,'restart':0xe204,'stop':0xe205,'add-process':0xe206,'cancel-maintenance':0xe207,'activate':0xe208,'resize-horizontal':0xe209,'resize-vertical':0xe20a,'connected':0xe20b,'disconnected':0xe20c,'edit-outside':0xe20d,'key':0xe20e,'minimize':0xe20f,'back-to-top':0xe210,'hello-world':0xe211,'outbox':0xe212,'donut-chart':0xe213,'heatmap-chart':0xe214,'horizontal-bullet-chart':0xe215,'vertical-bullet-chart':0xe216,'call':0xe217,'download-from-cloud':0xe218,'upload-to-cloud':0xe219,'jam':0xe21a,'sap-ui5':0xe21b,'message-popup':0xe21c,'cloud':0xe21d,'horizontal-waterfall-chart':0x1e21e,'vertical-waterfall-chart':0x1e21f,'broken-link':0xe220,'headset':0xe221,'thumb-up':0x1e222,'thumb-down':0x1e223,'multiselect-all':0x1e224,'multiselect-none':0x1e225,'scissors':0xe226,'sound':0x1e227,'sound-loud':0x1e228,'sound-off':0x1e229,'date-time':0x1e22a,'user-settings':0xe22b,'key-user-settings':0xe22c,'developer-settings':0xe22d,'text-formatting':0x1e22e,'bold-text':0x1e22f,'italic-text':0x1e230,'underline-text':0x1e231,'text-align-justified':0x1e232,'text-align-left':0x1e233,'text-align-center':0x1e234,'text-align-right':0x1e235,'bullet-text':0x1e236,'numbered-text':0x1e237,'co':0xe238,'ui-notifications':0xe239,'bell':0xe23a,'cancel-share':0xe23b,'write-new-document':0xe23c,'write-new':0xe23d,'cancel':0x1e23e,'screen-split-one':0xe23f,'screen-split-two':0xe240,'screen-split-three':0xe241,'customize':0xe242,'user-edit':0xe243,'source-code':0xe244,'copy':0xe245,'paste':0xe246,'line-chart-time-axis':0x1e247,'clear-filter':0xe248,'reset':0xe249,'trend-up':0xe24a,'trend-down':0xe24b,'cursor-arrow':0xe24c,'add-document':0xe24d,'create-form':0xe24e,'resize-corner':0xe24f,'chevron-phase':0xe250,'chevron-phase-2':0xe251,'rhombus-milestone':0xe252,'rhombus-milestone-2':0xe253,'circle-task':0xe254,'circle-task-2':0xe255,'project-definition-triangle':0xe256,'project-definition-triangle-2':0xe257,'master-task-triangle':0xe258,'master-task-triangle-2':0xe259,'program-triangles':0xe25a,'program-triangles-2':0xe25b,'mirrored-task-circle':0xe25c,'mirrored-task-circle-2':0xe25d,'checklist-item':0xe25e,'checklist-item-2':0xe25f,'checklist':0xe260,'checklist-2':0xe261,'chart-table-view':0xe262,'filter-analytics':0xe263,'filter-facets':0xe264,'filter-fields':0xe265,'indent':0xe266,'outdent':0xe267,'heading1':0x1e268,'heading2':0x1e269,'heading3':0x1e26a,'decrease-line-height':0xe26b,'increase-line-height':0xe26c,'fx':0x1e26d,'add-folder':0xe26e,'away':0xe26f,'busy':0xe270,'appear-offline':0xe271,'blur':0xe272,'pixelate':0xe273,'horizontal-combination-chart':0xe274,'add-employee':0xe275,'text-color':0x1e276,'browse-folder':0xe277,'primary-key':0xe278,'two-keys':0xe279,'strikethrough':0xe27a,'text':0xe27b,'responsive':0xe27c,'desktop-mobile':0xe27d,'table-row':0xe27e,'table-column':0xe27f,'validate':0x1e280,'keyboard-and-mouse':0xe281,'touch':0xe282,'expand-all':0xe283,'collapse-all':0xe284}};var C=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");var a;var b={};
b.createControlByURI=function(s,d){if(typeof s==="string"){s={src:s};}if(s&&s.src){var e=s.src,g=d;if(b.isIconURI(e)){a=a||sap.ui.requireSync("sap/ui/core/Icon");g=a;if(s.tap){s.press=s.tap;delete s.tap;}}if(typeof g==="function"){s=g.getMetadata().removeUnknownSettings(s);return new g(s);}}};
b.addIcon=function(d,e,g){if(typeof g==="string"){g={fontFamily:arguments[2],content:arguments[3],overWrite:!!arguments[4],suppressMirroring:!!arguments[5]};}if(typeof e!=="string"){e=String(e);}e=e==='undefined'?undefined:e;if(!r[e]){r[e]={};}var h=r[e],j=h[d],p,s,t,k;if(j){if(e===undefined){q.sap.log.warning("Icon with name '"+d+"' in built-in collection already exists and can not be overwritten.","sap.ui.core.IconPool");return;}else if(!g.overWrite){q.sap.log.warning("Icon with name '"+d+"' in collection '"+e+"' already exists. Specify 'iconInfo.overWrite' in order to overwrite.","sap.ui.core.IconPool");return;}}p={protocol:I,hostname:e||d,path:e?d:undefined};if(Array.isArray(g.content)){s=g.content.map(m).join('');}else{s=m(g.content);}if(q.sap.resources.isBundle(g.resourceBundle)){k="Icon."+d;if(g.resourceBundle.hasText(k)){t=g.resourceBundle.getText(k);}}j=h[d]={name:d,collection:e,uri:U.build(p),fontFamily:g.fontFamily,content:s,text:t||'',suppressMirroring:g.suppressMirroring,skipMirroring:g.suppressMirroring};return j;};
b.getIconURI=function(d,e){var g=this.getIconInfo(d,e);return g&&g.uri;};
b.getIconInfo=function(d,e,l){var p,g,h,n=b.isIconURI(d);if(!d){return;}if(!l&&n){l=e;}l=l||"sync";h=(l==="async"||l==="mixed");function j(){var k=r[e];var g=k&&k[d];if(typeof g==='number'){r[e][d]=undefined;g=b.addIcon(d,e,{fontFamily:f[e].config.fontFamily,content:g&0xFFFF,suppressMirroring:!!(g&0x10000),resourceBundle:C});}return g;}if(n){p=U.parse(d);if(p.path.length===1){e=undefined;d=p.hostname;}else{e=p.hostname;d=p.path.slice(1);}if(!d){return;}}if(typeof e!=="string"){e=String(e);}e=e==='undefined'?undefined:e;if(e===undefined&&!f[e].inserted){b.insertFontFaceStyle();}g=j();if(g===undefined&&e!==undefined){var L=b._loadFontMetadata(e,h);}if(h){if(L){return L.then(function(){g=j();if(!g){q.sap.log.warning("Icon info for icon '"+d+"' in collection '"+e+"' could not be fetched");}return g;});}else{if(l==="async"){return Promise.resolve(g);}else{g=j();}}}else{g=j();}if(!g){q.sap.log.warning("Icon info for icon '"+d+"' in collection '"+e+"' could not be fetched");}return g;};
b.fontLoaded=function(s){if(f[s]){if(f[s].metadataLoaded instanceof Promise){return f[s].metadataLoaded;}else if(f[s].metadataLoaded===true){return Promise.resolve();}}};
b.isIconURI=function(u){if(!u){return false;}var p=U.parse(u);return p.protocol===I&&!!p.hostname;};
b.getIconCollectionNames=function(){return Object.keys(r);};
b.getIconNames=function(d){var e=r[d];return e?Object.keys(e):[];};
b.insertFontFaceStyle=function(F,p,s){F=F||S;if(s===undefined&&F!==S){s=F;}if(!f[s]){q.sap.log.error("Icon font '"+s+"' has not been registered yet.");return;}if(f[s].inserted){if(s===undefined){q.sap.log.info("The font face style of standard icon font was already inserted.");}else{q.sap.log.info("The font face style of icon font '"+s+"' was already inserted.");}return;}if(F===S&&s!==undefined){q.sap.log.error("Must not overwrite the standard icon set with '"+s+"'.");return;}var d=p||q.sap.getModulePath("sap.ui.core.themes.base","/fonts/");var e="@font-face {"+"font-family: '"+F+"';"+"src: url('"+d+F+".woff2') format('woff2'),"+"url('"+d+F+".woff') format('woff'),"+"url('"+d+F+".ttf') format('truetype'),"+"local('"+F+"');"+"font-weight: normal;"+"font-style: normal;"+"}";q('head').append('<style type="text/css">'+e+'</style>');f[s].inserted=true;f[s].fontFace=F;};
b.registerFont=function(o){o.collectionName=o.collectionName||o.fontFamily;if(!o.fontURI){q.sap.log.error("The configuration parameter fontURI is missing, cannot register the font '"+o.collectionName+"'!");return;}if(o.fontFamily===S){q.sap.log.error("The font family"+S+" is already registered");return;}if(o.fontURI.substr(o.fontURI.length-1)!=="/"){o.fontURI+="/";}if(!f[o.collectionName]||f[o.collectionName].metadataLoaded===false){f[o.collectionName]={config:o,inserted:false};}else{q.sap.log.warning("The font '"+o.collectionName+"' is already registered");}if(!o.lazy){b._loadFontMetadata(o.collectionName,true);}};
b._loadFontMetadata=function(d,e){var o;if(f[d]){if(typeof f[d].metadataLoaded==="boolean"){return;}if(e&&f[d].metadataLoaded instanceof Promise){return f[d].metadataLoaded;}o=f[d].config;}else{if(!r[d]){q.sap.log.error("The font configuration for collection '"+d+"' is not registered");}f[d]={metadataLoaded:false};}function l(F){for(var k in F){F[k]=parseInt(F[k],16);}r[d]=F;b.insertFontFaceStyle(o.fontFamily,o.fontURI,d);f[d].metadataLoaded=true;}if(o){if(o.metadataURI===undefined){o.metadataURI=o.fontURI+o.fontFamily+".json";}if(e&&!o.metadata){if(f[d].metadataLoaded instanceof Promise){return f[d].metadataLoaded;}var p=new Promise(function(R){if(r[d]===undefined){f[d].metadataLoadedResolve=R;f[d].metadataXhr=q.ajax(o.metadataURI,{dataType:"json",success:function(j){l(j);delete f[d].metadataXhr;delete f[d].metadataLoadedResolve;R();},error:function(j,s){if(s!=="abort"){q.sap.log.error("An error occurred loading the font metadata for collection '"+d+"'");f[d].metadataLoaded=false;R();}}});}});f[d].metadataLoaded=p;return p;}else{if(o.metadataURI){if(f[d].metadataXhr){f[d].metadataXhr.abort("Replaced by sync request");f[d].metadataXhr=null;}q.ajax(o.metadataURI,{dataType:"json",async:false,success:function(j){l(j);if(f[d].metadataLoadedResolve){f[d].metadataLoadedResolve();delete f[d].metadataLoadedResolve;}},error:function(){if(f[d].metadataLoadedResolve){f[d].metadataLoadedResolve();delete f[d].metadataLoadedResolve;}q.sap.log.error("An error occurred loading the font metadata for collection '"+d+"'");f[d].metadataLoaded=false;}});}else{l(o.metadata);}}}};
var i={"application/msword":"sap-icon://doc-attachment","application/vnd.openxmlformats-officedocument.wordprocessingml.document":"sap-icon://doc-attachment","application/rtf":"sap-icon://doc-attachment","application/pdf":"sap-icon://pdf-attachment","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":"sap-icon://excel-attachment","application/vnd.ms-excel":"sap-icon://excel-attachment","application/msexcel":"sap-icon://excel-attachment","application/vnd.ms-powerpoint":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.presentation":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.slideshow":"sap-icon://ppt-attachment","application/mspowerpoint":"sap-icon://ppt-attachment","application/xml":"sap-icon://attachment-html","application/xhtml+xml":"sap-icon://attachment-html","application/x-httpd-php":"sap-icon://attachment-html","application/x-javascript":"sap-icon://attachment-html","application/gzip":"sap-icon://attachment-zip-file","application/x-rar-compressed":"sap-icon://attachment-zip-file","application/x-tar":"sap-icon://attachment-zip-file","application/zip":"sap-icon://attachment-zip-file","audio/voxware":"sap-icon://attachment-audio","audio/x-aiff":"sap-icon://attachment-audio","audio/x-midi":"sap-icon://attachment-audio","audio/x-mpeg":"sap-icon://attachment-audio","audio/x-pn-realaudio":"sap-icon://attachment-audio","audio/x-pn-realaudio-plugin":"sap-icon://attachment-audio","audio/x-qt-stream":"sap-icon://attachment-audio","audio/x-wav":"sap-icon://attachment-audio","image/png":"sap-icon://attachment-photo","image/tiff":"sap-icon://attachment-photo","image/bmp":"sap-icon://attachment-photo","image/jpeg":"sap-icon://attachment-photo","image/gif":"sap-icon://attachment-photo","text/plain":"sap-icon://attachment-text-file","text/comma-separated-values":"sap-icon://attachment-text-file","text/css":"sap-icon://attachment-text-file","text/html":"sap-icon://attachment-text-file","text/javascript":"sap-icon://attachment-text-file","text/richtext":"sap-icon://attachment-text-file","text/rtf":"sap-icon://attachment-text-file","text/tab-separated-values":"sap-icon://attachment-text-file","text/xml":"sap-icon://attachment-text-file","video/mpeg":"sap-icon://attachment-video","video/quicktime":"sap-icon://attachment-video","video/x-msvideo":"sap-icon://attachment-video","application/x-shockwave-flash":"sap-icon://attachment-video"};
b.getIconForMimeType=function(M){return i[M]||"sap-icon://document";};
function m(d){return String.fromCharCode(typeof d==='number'?d:parseInt(d,16));}
return b;},true);
sap.ui.predefine('sap/ui/core/IconRenderer',['jquery.sap.global','./IconPool','./library'],function(q,I,l){"use strict";var a=l.IconColor;var b={};
b.render=function(r,c){var i=I.getIconInfo(c.getSrc(),undefined,"mixed"),w=c.getWidth(),h=c.getHeight(),C=c.getColor(),B=c.getBackgroundColor(),s=c.getSize(),n=c.getNoTabStop(),t=c._getOutputTitle(i),L,o,A,d=false;if(i instanceof Promise){i.then(c.invalidate.bind(c));}else if(i){d=true;L=c.getAriaLabelledBy();A=c._getAccessibilityAttributes(i);o=c.getAggregation("_invisibleText");}r.write("<span");r.writeControlData(c);if(d){r.writeAccessibilityState(c,A);}if(t){r.writeAttributeEscaped("title",t);}if(c.hasListeners("press")&&!n){r.writeAttribute("tabindex",0);}if(d){r.writeAttributeEscaped("data-sap-ui-icon-content",i.content);r.addStyle("font-family","'"+q.sap.encodeHTML(i.fontFamily)+"'");}if(w){r.addStyle("width",w);}if(h){r.addStyle("height",h);r.addStyle("line-height",h);}if(C&&!(C in a)){r.addStyle("color",q.sap.encodeHTML(C));}if(B&&!(B in a)){r.addStyle("background-color",q.sap.encodeHTML(B));}if(s){r.addStyle("font-size",s);}r.addClass("sapUiIcon");if(d&&!i.suppressMirroring){r.addClass("sapUiIconMirrorInRTL");}if(c.hasListeners("press")){r.addClass("sapUiIconPointer");}r.writeClasses();r.writeStyles();r.write(">");if(L&&L.length&&o){r.renderControl(o);}r.write("</span>");};
return b;},true);
sap.ui.predefine('sap/ui/core/IntervalTrigger',['jquery.sap.global','../base/Object','./EventBus'],function(q,B,E){"use strict";var _="sapUiIntervalTrigger-event";
var I=B.extend("sap.ui.core.IntervalTrigger",{constructor:function(i){B.apply(this);this._oEventBus=new E();this._delayedCallId=null;this._triggerProxy=q.proxy(t,this);this._iInterval=0;if(i){this.setInterval(i);}}});
var t=function(){q.sap.clearDelayedCall(this._delayedCallId);var h=this._oEventBus._defaultChannel.hasListeners(_);if(this._iInterval>0&&h){this._oEventBus.publish(_);this._delayedCallId=q.sap.delayedCall(this._iInterval,this,this._triggerProxy);}};
I.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);delete this._triggerProxy;this._oEventBus.destroy();delete this._oEventBus;};
I.prototype.setInterval=function(i){if(this._iInterval!==i){this._iInterval=i;this._triggerProxy();}};
I.prototype.addListener=function(f,l){this._oEventBus.subscribe(_,f,l);this._triggerProxy();};
I.prototype.removeListener=function(f,l){this._oEventBus.unsubscribe(_,f,l);};
I.prototype.getInterface=function(){return this;};
return I;});
sap.ui.predefine('sap/ui/core/InvisibleText',['jquery.sap.global','./Control','./library','jquery.sap.encoder'],function(q,C,l){"use strict";
var I=C.extend("sap.ui.core.InvisibleText",{
metadata:{library:"sap.ui.core",publicMethods:["toStatic"],properties:{text:{type:"string",defaultValue:""}}},
renderer:function(r,c){r.write("<span");r.writeControlData(c);r.addClass("sapUiInvisibleText");r.writeClasses();r.writeAttribute("aria-hidden","true");r.write(">");r.writeEscaped(c.getText()||"");r.write("</span>");}
});
function m(w){return function(){q.sap.log.warning(w+" is not supported by control sap.ui.core.InvisibleText.");return this;};}
I.prototype.setBusy=m("Property busy");I.prototype.setBusyIndicatorDelay=m("Property busy");I.prototype.setBusyIndicatorSize=m("Property busy");I.prototype.setVisible=m("Property visible");I.prototype.setTooltip=m("Aggregation tooltip");
I.prototype.setText=function(T){this.setProperty("text",T,true);this.$().html(q.sap.encodeHTML(this.getText()||""));return this;};
I.prototype.toStatic=function(){var c=sap.ui.getCore();try{var s=c.getStaticAreaRef();var r=c.createRenderManager();r.render(this,s);r.destroy();}catch(e){this.placeAt("sap-ui-static");}return this;};
var t=Object.create(null);
I.getStaticId=function(L,T){var s="",k,b,o;if(sap.ui.getCore().getConfiguration().getAccessibility()&&T){k=L+"|"+T;s=t[k];if(s==null){b=sap.ui.getCore().getLibraryResourceBundle(L);o=new I().setText(b.getText(T));o.toStatic();s=t[k]=o.getId();}}return s;};
sap.ui.getCore().attachLocalizationChanged(function(e){var c=sap.ui.getCore(),k,p,b,T;for(k in t){p=k.indexOf('|');b=c.getLibraryResourceBundle(k.slice(0,p));T=c.byId(t[k]);T&&T.setText(b.getText(k.slice(p+1)));}});return I;});
sap.ui.predefine('sap/ui/core/Item',['./Element','./library'],function(E,l){"use strict";var T=l.TextDirection;
var I=E.extend("sap.ui.core.Item",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Misc",defaultValue:T.Inherit},key:{type:"string",group:"Data",defaultValue:null}}}});
return I;});
sap.ui.predefine('sap/ui/core/LayoutData',['jquery.sap.global','./Element','./library'],function(q,E,l){"use strict";
var L=E.extend("sap.ui.core.LayoutData",{metadata:{"abstract":true,library:"sap.ui.core"}});
L.prototype.invalidate=function(){var p=this.getParent();if(p&&p.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){p=p.getParent();}if(p){var o=p.getParent();if(o){var e=q.Event("LayoutDataChange");e.srcControl=p;o._handleEvent(e);}}};
L.prototype.setLayoutData=function(o){return this;};
return L;});
sap.ui.predefine('sap/ui/core/ListItem',['./Item','./library'],function(I,l){"use strict";
var L=I.extend("sap.ui.core.ListItem",{metadata:{library:"sap.ui.core",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},additionalText:{type:"string",group:"Data",defaultValue:null}}}});
return L;});
sap.ui.predefine('sap/ui/core/LocalBusyIndicator',['jquery.sap.global','./Control','./library','./theming/Parameters',"./LocalBusyIndicatorRenderer"],function(q,C,l,P,L){"use strict";
var a=C.extend("sap.ui.core.LocalBusyIndicator",{metadata:{deprecated:true,library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'}}}});
(function(){
a.prototype.init=function(){var r="sap.ui.core.LocalBusyIndicator:";var p="sapUiLocalBusyIndicatorBoxSize";p=P.get(r+p);this._iBoxSize=8;p="sapUiLocalBusyIndicatorBoxColor";this._sBoxColor=P.get(r+p);p="sapUiLocalBusyIndicatorBoxColorActive";this._sBoxColorActive=P.get(r+p);this._animateProxy=q.proxy(A,this);};
a.prototype.exit=function(){q.sap.clearDelayedCall(this._delayedCallId);delete this._delayedCallId;};
a.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};
a.prototype.onAfterRendering=function(){var w=parseInt(this.getWidth(),10);var h=parseInt(this.getHeight(),10);var $=this.$();$.css("width",w+"px");$.css("height",h+"px");var b=this.$("animation");var c=Math.floor(w/2);c-=Math.floor((5*this._iBoxSize)/2);var t=Math.floor(h/2)-Math.floor(this._iBoxSize/2);b.css("left",c+"px");b.css("top",t+"px");if(!this._$left){this._$left=this.$("leftBox");}if(!this._$middle){this._$middle=this.$("middleBox");}if(!this._$right){this._$right=this.$("rightBox");}this._delayedCallId=q.sap.delayedCall(0,this,this._animateProxy);};
var A=function(){if(this.getDomRef()){var t=this;var $,b,c;var d="",e="";if(t._$left){$=t._$left;}else{return;}if(t._$middle){b=t._$middle;}else{return;}if(t._$right){c=t._$right;}else{return;}if(t._sBoxColor){d=t._sBoxColor;}else{return;}if(t._sBoxColorActive){e=t._sBoxColorActive;}else{return;}$.css("background-color",e);setTimeout(function(){$.css("background-color",d);b.css("background-color",e);setTimeout(function(){b.css("background-color",d);c.css("background-color",e);setTimeout(function(){c.css("background-color",d);},150);},150);},150);this._delayedCallId=q.sap.delayedCall(1200,this,this._animateProxy);}};}());return a;});
sap.ui.predefine('sap/ui/core/LocalBusyIndicatorRenderer',function(){"use strict";var L={};
L.render=function(R,c){R.write("<div");R.writeControlData(c);R.addClass("sapUiLocalBusyIndicator");R.writeClasses();R.write(">");r(R,c);R.write("</div>");};
var r=function(R,c){var I=c.getId();var s=I+"-animation";var b=["-leftBox","-middleBox","-rightBox"];R.write('<div');R.writeAttribute('id',s);R.addClass("sapUiLocalBusyIndicatorAnimation");R.writeClasses();R.write(">");for(var i=0;i<b.length;i++){R.write('<div');R.addClass("sapUiLocalBusyIndicatorBox");R.writeClasses();R.writeAttribute("id",I+b[i]);R.write(">");R.write("</div>");}R.write("</div>");};return L;},true);
sap.ui.predefine('sap/ui/core/LocalBusyIndicatorSupport',['jquery.sap.global','./Control'],function(q,C){"use strict";var L=function(){if(this===C.prototype){this.setDelay=this.setBusyIndicatorDelay;}else{q.sap.log.error("Only controls can use the LocalBusyIndicator",this);}};return L;},true);
sap.ui.predefine('sap/ui/core/LocaleData',['jquery.sap.global','sap/ui/base/Object','./Locale'],function(q,B,L){"use strict";
var a=B.extend("sap.ui.core.LocaleData",{
constructor:function(o){this.oLocale=o;B.apply(this);this.mData=e(o);},
_get:function(){return this._getDeep(this.mData,arguments);},
_getMerged:function(){return this._get.apply(this,arguments);},
_getDeep:function(o,p){var r=o;for(var i=0;i<p.length;i++){r=r[p[i]];if(r===undefined){break;}}return r;},
getOrientation:function(){return this._get("orientation");},
getLanguages:function(){return this._get("languages");},
getScripts:function(){return this._get("scripts");},
getTerritories:function(){return this._get("territories");},
getMonths:function(w,s){return this._get(g(s),"months","format",w);},
getMonthsStandAlone:function(w,s){return this._get(g(s),"months","stand-alone",w);},
getDays:function(w,s){return this._get(g(s),"days","format",w);},
getDaysStandAlone:function(w,s){return this._get(g(s),"days","stand-alone",w);},
getQuarters:function(w,s){return this._get(g(s),"quarters","format",w);},
getQuartersStandAlone:function(w,s){return this._get(g(s),"quarters","stand-alone",w);},
getDayPeriods:function(w,s){return this._get(g(s),"dayPeriods","format",w);},
getDayPeriodsStandAlone:function(w,s){return this._get(g(s),"dayPeriods","stand-alone",w);},
getDatePattern:function(s,h){return this._get(g(h),"dateFormats",s);},
getTimePattern:function(s,h){return this._get(g(h),"timeFormats",s);},
getDateTimePattern:function(s,h){return this._get(g(h),"dateTimeFormats",s);},
getCombinedDateTimePattern:function(D,t,s){var h=this.getDateTimePattern(D,s),i=this.getDatePattern(D,s),T=this.getTimePattern(t,s);return h.replace("{0}",T).replace("{1}",i);},
getCustomDateTimePattern:function(s,h){var A=this._get(g(h),"dateTimeFormats","availableFormats");return this._getFormatPattern(s,A,h);},
getIntervalPattern:function(i,s){var I=this._get(g(s),"dateTimeFormats","intervalFormats"),h,j,D,o,p;if(i){h=i.split("-");j=h[0];D=h[1];o=I[j];if(o){p=o[D];if(p){return p;}}}return I.intervalFormatFallback;},
getCombinedIntervalPattern:function(p,s){var i=this._get(g(s),"dateTimeFormats","intervalFormats"),F=i.intervalFormatFallback;return F.replace(/\{(0|1)\}/g,p);},
getCustomIntervalPattern:function(s,G,h){var A=this._get(g(h),"dateTimeFormats","intervalFormats");return this._getFormatPattern(s,A,h,G);},
_getFormatPattern:function(s,A,h,D){var p,P,i;if(!D){p=A[s];}else if(typeof D==="string"){if(D=="j"||D=="J"){D=this.getPreferredHourSymbol();}i=A[s];p=i&&i[D];}if(p){if(typeof p==="object"){P=Object.keys(p).map(function(k){return p[k];});}else{return p;}}if(!P){P=this._createFormatPattern(s,A,h,D);}if(P&&P.length===1){return P[0];}return P;},
_createFormatPattern:function(s,A,h,D){var t=this._parseSkeletonFormat(s),p,o=this._findBestMatch(t,s,A),T,j,P,S,k,m,r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,n,i;if(D){if(typeof D==="string"){m=C[D]?C[D].group:"";if(m){n=c[m].index>t[t.length-1].index;}k=D;}else{n=true;for(i=t.length-1;i>=0;i--){T=t[i];if(D[T.group]){n=false;break;}}for(i=0;i<t.length;i++){T=t[i];if(D[T.group]){k=T.symbol;break;}}if((k=="h"||k=="K")&&D.DayPeriod){k="a";}}if(n){return[this.getCustomDateTimePattern(s,h)];}if(o&&o.missingTokens.length===0){P=o.pattern[k];if(P&&o.distance>0){P=this._expandFields(P,o.patternTokens,t);}}if(!P){j=this._get(g(h),"dateTimeFormats","availableFormats");if(r.test(s)&&"ahHkKjJms".indexOf(k)>=0){P=this._getMixedFormatPattern(s,j,h,D);}else{S=this._getFormatPattern(s,j,h);P=this.getCombinedIntervalPattern(S,h);}}p=[P];}else if(!o){P=s;p=[P];}else{if(typeof o.pattern==="string"){p=[o.pattern];}else if(typeof o.pattern==="object"){p=[];for(var K in o.pattern){P=o.pattern[K];p.push(P);}}if(o.distance>0){if(o.missingTokens.length>0){if(r.test(s)){p=[this._getMixedFormatPattern(s,A,h)];}else{p=this._expandFields(p,o.patternTokens,t);p=this._appendItems(p,o.missingTokens,h);}}else{p=this._expandFields(p,o.patternTokens,t);}}}if(s.indexOf("J")>=0){p.forEach(function(P,I){p[I]=P.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"");});}return p;},
_parseSkeletonFormat:function(s){var t=[],T={index:-1},S,o,G;for(var i=0;i<s.length;i++){S=s.charAt(i);if(S=="j"||S=="J"){S=this.getPreferredHourSymbol();}if(S==T.symbol){T.length++;continue;}o=C[S];G=c[o.group];if(o.group=="Other"||G.diffOnly){throw new Error("Symbol '"+S+"' is not allowed in skeleton format '"+s+"'");}if(G.index<=T.index){throw new Error("Symbol '"+S+"' at wrong position or duplicate in skeleton format '"+s+"'");}T={symbol:S,group:o.group,match:o.match,index:G.index,field:G.field,length:1};t.push(T);}return t;},
_findBestMatch:function(t,s,A){var T,m,o,h,j,D,k,F,n,p,r={distance:10000,firstDiffPos:-1};for(var u in A){if(u==="intervalFormatFallback"||u.indexOf("B")>-1){continue;}T=this._parseSkeletonFormat(u);D=0;m=[];k=true;if(t.length<T.length){continue;}j=0;F=t.length;for(var i=0;i<t.length;i++){o=t[i];h=T[j];if(F===t.length){F=i;}if(h){n=C[o.symbol];p=C[h.symbol];if(o.symbol===h.symbol){if(o.length===h.length){if(F===i){F=t.length;}}else{if(o.length<n.numericCeiling?h.length<p.numericCeiling:h.length>=p.numericCeiling){D+=Math.abs(o.length-h.length);}else{D+=5;}}j++;continue;}else{if(o.match==h.match){D+=Math.abs(o.length-h.length)+10;j++;continue;}}}m.push(o);D+=50-i;}if(j<T.length){k=false;}if(k&&(D<r.distance||(D===r.distance&&F>r.firstDiffPos))){r.distance=D;r.firstDiffPos=F;r.missingTokens=m;r.pattern=A[u];r.patternTokens=T;}}if(r.pattern){return r;}},
_expandFields:function(p,P,t){var s=(typeof p==="string");var h;if(s){h=[p];}else{h=p;}var r=h.map(function(k){var G={},m={},R="",Q=false,i=0,S,n,o,N,u,v,w,x,y,z;t.forEach(function(T){G[T.group]=T;});P.forEach(function(T){m[T.group]=T;});while(i<k.length){z=k.charAt(i);if(Q){R+=z;if(z=="'"){Q=false;}}else{w=C[z];if(w&&G[w.group]&&m[w.group]){u=G[w.group];v=m[w.group];x=C[u.symbol];y=C[v.symbol];S=u.length;n=v.length;o=1;while(k.charAt(i+1)==z){i++;o++;}if(S===n||((S<x.numericCeiling)?(n>=y.numericCeiling):(n<y.numericCeiling))){N=o;}else{N=Math.max(o,S);}for(var j=0;j<N;j++){R+=z;}}else{R+=z;if(z=="'"){Q=true;}}}i++;}return R;});return s?r[0]:r;},
_appendItems:function(p,m,s){var A=this._get(g(s),"dateTimeFormats","appendItems");p.forEach(function(P,I){var D,h,j;m.forEach(function(t){h=A[t.group];D="'"+this.getDisplayName(t.field)+"'";j="";for(var i=0;i<t.length;i++){j+=t.symbol;}p[I]=h.replace(/\{0\}/,P).replace(/\{1\}/,j).replace(/\{2\}/,D);}.bind(this));}.bind(this));return p;},
_getMixedFormatPattern:function(s,A,h,D){var r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,i=/MMMM|LLLL/,j=/MMM|LLL/,k=/E|e|c/,R,m,t,S,n,T,o,p;R=r.exec(s);m=R[1];t=R[2];n=this._getFormatPattern(m,A,h);if(D){T=this.getCustomIntervalPattern(t,D,h);}else{T=this._getFormatPattern(t,A,h);}if(i.test(m)){S=k.test(m)?"full":"long";}else if(j.test(m)){S="medium";}else{S="short";}o=this.getDateTimePattern(S,h);p=o.replace(/\{1\}/,n).replace(/\{0\}/,T);return p;},
getNumberSymbol:function(t){return this._get("symbols-latn-"+t);},
getDecimalPattern:function(){return this._get("decimalFormat").standard;},
getCurrencyPattern:function(s){return this._get("currencyFormat")[s]||this._get("currencyFormat").standard;},
getCurrencySpacing:function(p){return this._get("currencyFormat","currencySpacing",p==="after"?"afterCurrency":"beforeCurrency");},
getPercentPattern:function(){return this._get("percentFormat").standard;},
getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays");},
getFirstDayOfWeek:function(){return this._get("weekData-firstDay");},
getWeekendStart:function(){return this._get("weekData-weekendStart");},
getWeekendEnd:function(){return this._get("weekData-weekendEnd");},
getCurrencyDigits:function(s){var m=this._get("currency");if(m){if(m[s]&&m[s].hasOwnProperty("digits")){return m[s].digits;}else if(m["DEFAULT"]&&m["DEFAULT"].hasOwnProperty("digits")){return m["DEFAULT"].digits;}}var D=this._get("currencyDigits",s);if(D==null){D=this._get("currencyDigits","DEFAULT");if(D==null){D=2;}}return D;},
getCurrencySymbol:function(s){var o=this._get("currencySymbols");return(o&&o[s])||s;},
getCurrencyCodeBySymbol:function(s){var o=this._get("currencySymbols"),h;for(h in o){if(o[h]===s){return h;}}return s;},
getUnitDisplayName:function(u){var U=this.getUnitFormat(u);return(U&&U["displayName"])||"";},
getRelativePatterns:function(s,S){if(S===undefined){S="wide";}var p=[],P=this.getPluralCategories(),o,t,v,i;if(!s){s=["year","month","week","day","hour","minute","second"];}s.forEach(function(h){o=this._get("dateFields",h+"-"+S);for(var E in o){if(E.indexOf("relative-type-")===0){v=parseInt(E.substr(14),10);p.push({scale:h,value:v,pattern:o[E]});}else if(E.indexOf("relativeTime-type-")==0){t=o[E];i=E.substr(18)==="past"?-1:1;P.forEach(function(k){p.push({scale:h,sign:i,pattern:t["relativeTimePattern-count-"+k]});});}}}.bind(this));return p;},
getRelativePattern:function(s,D,F,S){var p,t,k,P;if(typeof F==="string"){S=F;F=undefined;}if(F===undefined){F=D>0;}if(S===undefined){S="wide";}k=s+"-"+S;if(D===0||D===-2||D===2){p=this._get("dateFields",k,"relative-type-"+D);}if(!p){t=this._get("dateFields",k,"relativeTime-type-"+(F?"future":"past"));P=this.getPluralCategory(Math.abs(D).toString());p=t["relativeTimePattern-count-"+P];}return p;},
getRelativeSecond:function(D,s){return this.getRelativePattern("second",D,s);},
getRelativeMinute:function(D,s){if(D==0){return null;}return this.getRelativePattern("minute",D,s);},
getRelativeHour:function(D,s){if(D==0){return null;}return this.getRelativePattern("hour",D,s);},
getRelativeDay:function(D,s){return this.getRelativePattern("day",D,s);},
getRelativeWeek:function(D,s){return this.getRelativePattern("week",D,s);},
getRelativeMonth:function(D,s){return this.getRelativePattern("month",D,s);},
getDisplayName:function(t,s){if(s===undefined){s="wide";}var S=["era","weekday","zone"],k=S.indexOf(t)===-1?t+"-"+s:t;return this._get("dateFields",k,"displayName");},
getRelativeYear:function(D,s){return this.getRelativePattern("year",D,s);},
getDecimalFormat:function(s,n,p){var F;var o;switch(s){case"long":o=this._get("decimalFormat-long");break;default:o=this._get("decimalFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},
getCurrencyFormat:function(s,n,p){var F;var o;switch(s){default:o=this._get("currencyFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},
getListFormat:function(t,s){var F=this._get("listPattern-"+(t||"standard")+"-"+(s||"wide"));if(F){return F;}return{};},
getResolvedUnitFormat:function(u){u=this.getUnitFromMapping(u)||u;return this.getUnitFormat(u);},
getUnitFormat:function(u){return this._get("units","short",u);},
getUnitFormats:function(){return this._getMerged("units","short");},
getUnitFromMapping:function(m){return this._get("unitMappings",m);},
getEras:function(w,s){var E=this._get(g(s),"era-"+w),h=[];for(var i in E){h[parseInt(i,10)]=E[i];}return h;},
getEraDates:function(s){var E=this._get("eras-"+s.toLowerCase()),h=[];for(var i in E){h[parseInt(i,10)]=E[i];}return h;},
getCalendarWeek:function(s,w){var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),k="date.week.calendarweek."+s;return m.getText(k,w);},
getPreferredCalendarType:function(){var s=this._get("calendarPreference"),h=s?s.split(" "):[],j,t,i;sap.ui.getCore().loadLibrary('sap.ui.core');var k=sap.ui.require("sap/ui/core/library").CalendarType;for(i=0;i<h.length;i++){j=h[i];for(t in k){if(j===g(t).substring(3)){return t;}}}return k.Gregorian;},
getPreferredHourSymbol:function(){return this._get("timeData","_preferred");},
getPluralCategories:function(){var p=this._get("plurals"),h=Object.keys(p);h.push("other");return h;},
getPluralCategory:function(n){var p=this._get("plurals");if(typeof n==="number"){n=n.toString();}if(!this._pluralTest){this._pluralTest={};}for(var s in p){var t=this._pluralTest[s];if(!t){t=this._parsePluralRule(p[s]);this._pluralTest[s]=t;}if(t(n)){return s;}}return"other";},
_parsePluralRule:function(r){var O="or",h="and",j="%",k="=",m="!=",n="n",p="i",s="f",t="t",u="v",v="w",R="..",S=",";var i=0,T;T=r.split(" ");function w(o){if(T[i]===o){i++;return true;}return false;}function x(){var o=T[i];i++;return o;}function y(){var H,G;H=z();if(w(O)){G=y();return function(o){return H(o)||G(o);};}return H;}function z(){var H,I;H=A();if(w(h)){I=z();return function(o){return H(o)&&I(o);};}return H;}function A(){var H,I,J;H=D();if(w(k)){J=true;}else if(w(m)){J=false;}else{throw new Error("Expected '=' or '!='");}I=F();if(J){return function(o){return I(o).indexOf(H(o))>=0;};}else{return function(o){return I(o).indexOf(H(o))===-1;};}}function D(){var H;H=E();if(w(j)){var I=parseInt(x(),10);return function(o){return H(o)%I;};}return H;}function E(){if(w(n)){return function(o){return o.n;};}else if(w(p)){return function(o){return o.i;};}else if(w(s)){return function(o){return o.f;};}else if(w(t)){return function(o){return o.t;};}else if(w(u)){return function(o){return o.v;};}else if(w(v)){return function(o){return o.w;};}else{throw new Error("Unknown operand: "+x());}}function F(){var V=[],H=x(),P=H.split(S),I,J,K;P.forEach(function(o){I=o.split(R);if(I.length===1){V.push(parseInt(o,10));}else{J=parseInt(I[0],10);K=parseInt(I[1],10);for(var i=J;i<=K;i++){V.push(i);}}});return function(o){return V;};}var G=y();if(i!=T.length){throw new Error("Not completely parsed");}return function(V){var H=V.indexOf("."),I,J,K,o;if(H===-1){I=V;J="";K="";}else{I=V.substr(0,H);J=V.substr(H+1);K=J.replace(/0+$/,'');}o={n:parseFloat(V),i:parseInt(I,10),v:J.length,w:K.length,f:parseInt(J,10),t:parseInt(K,10)};return G(o);};}
});
var c={"Era":{field:"era",index:0},"Year":{field:"year",index:1},"Quarter":{field:"quarter",index:2},"Month":{field:"month",index:3},"Week":{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},"Day":{field:"day",index:6},"DayPeriod":{field:"hour",index:7,diffOnly:true},"Hour":{field:"hour",index:8},"Minute":{field:"minute",index:9},"Second":{field:"second",index:10},"Timezone":{field:"zone",index:11}};var C={"G":{group:"Era",match:"Era",numericCeiling:1},"y":{group:"Year",match:"Year",numericCeiling:100},"Y":{group:"Year",match:"Year",numericCeiling:100},"Q":{group:"Quarter",match:"Quarter",numericCeiling:3},"q":{group:"Quarter",match:"Quarter",numericCeiling:3},"M":{group:"Month",match:"Month",numericCeiling:3},"L":{group:"Month",match:"Month",numericCeiling:3},"w":{group:"Week",match:"Week",numericCeiling:100},"W":{group:"Week",match:"Week",numericCeiling:100},"d":{group:"Day",match:"Day",numericCeiling:100},"D":{group:"Day",match:"Day",numericCeiling:100},"E":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},"e":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},"c":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},"h":{group:"Hour",match:"Hour12",numericCeiling:100},"H":{group:"Hour",match:"Hour24",numericCeiling:100},"k":{group:"Hour",match:"Hour24",numericCeiling:100},"K":{group:"Hour",match:"Hour12",numericCeiling:100},"m":{group:"Minute",match:"Minute",numericCeiling:100},"s":{group:"Second",match:"Second",numericCeiling:100},"z":{group:"Timezone",match:"Timezone",numericCeiling:1},"Z":{group:"Timezone",match:"Timezone",numericCeiling:1},"O":{group:"Timezone",match:"Timezone",numericCeiling:1},"v":{group:"Timezone",match:"Timezone",numericCeiling:1},"V":{group:"Timezone",match:"Timezone",numericCeiling:1},"X":{group:"Timezone",match:"Timezone",numericCeiling:1},"x":{group:"Timezone",match:"Timezone",numericCeiling:1},"S":{group:"Other",numericCeiling:100},"u":{group:"Other",numericCeiling:100},"U":{group:"Other",numericCeiling:1},"r":{group:"Other",numericCeiling:100},"F":{group:"Other",numericCeiling:100},"g":{group:"Other",numericCeiling:100},"a":{group:"DayPeriod",numericCeiling:1},"b":{group:"Other",numericCeiling:1},"B":{group:"Other",numericCeiling:1},"A":{group:"Other",numericCeiling:100}};var M={"orientation":"left-to-right","languages":{},"scripts":{},"territories":{},"ca-gregorian":{"dateFormats":{"full":"EEEE, MMMM d, y","long":"MMMM d, y","medium":"MMM d, y","short":"M/d/yy"},"timeFormats":{"full":"h:mm:ss a zzzz","long":"h:mm:ss a z","medium":"h:mm:ss a","short":"h:mm a"},"dateTimeFormats":{"full":"{1} 'at' {0}","long":"{1} 'at' {0}","medium":"{1}, {0}","short":"{1}, {0}","availableFormats":{"d":"d","E":"ccc","Ed":"d E","Ehm":"E h:mm a","EHm":"E HH:mm","Ehms":"E h:mm:ss a","EHms":"E HH:mm:ss","Gy":"y G","GyMMM":"MMM y G","GyMMMd":"MMM d, y G","GyMMMEd":"E, MMM d, y G","h":"h a","H":"HH","hm":"h:mm a","Hm":"HH:mm","hms":"h:mm:ss a","Hms":"HH:mm:ss","hmsv":"h:mm:ss a v","Hmsv":"HH:mm:ss v","hmv":"h:mm a v","Hmv":"HH:mm v","M":"L","Md":"M/d","MEd":"E, M/d","MMM":"LLL","MMMd":"MMM d","MMMEd":"E, MMM d","MMMMd":"MMMM d","ms":"mm:ss","y":"y","yM":"M/y","yMd":"M/d/y","yMEd":"E, M/d/y","yMMM":"MMM y","yMMMd":"MMM d, y","yMMMEd":"E, MMM d, y","yMMMM":"MMMM y","yQQQ":"QQQ y","yQQQQ":"QQQQ y"},"appendItems":{"Day":"{0} ({2}: {1})","Day-Of-Week":"{0} {1}","Era":"{0} {1}","Hour":"{0} ({2}: {1})","Minute":"{0} ({2}: {1})","Month":"{0} ({2}: {1})","Quarter":"{0} ({2}: {1})","Second":"{0} ({2}: {1})","Timezone":"{0} {1}","Week":"{0} ({2}: {1})","Year":"{0} {1}"},"intervalFormats":{"intervalFormatFallback":"{0} – {1}","d":{"d":"d – d"},"h":{"a":"h a – h a","h":"h – h a"},"H":{"H":"HH – HH"},"hm":{"a":"h:mm a – h:mm a","h":"h:mm – h:mm a","m":"h:mm – h:mm a"},"Hm":{"H":"HH:mm – HH:mm","m":"HH:mm – HH:mm"},"hmv":{"a":"h:mm a – h:mm a v","h":"h:mm – h:mm a v","m":"h:mm – h:mm a v"},"Hmv":{"H":"HH:mm – HH:mm v","m":"HH:mm – HH:mm v"},"hv":{"a":"h a – h a v","h":"h – h a v"},"Hv":{"H":"HH – HH v"},"M":{"M":"M – M"},"Md":{"d":"M/d – M/d","M":"M/d – M/d"},"MEd":{"d":"E, M/d – E, M/d","M":"E, M/d – E, M/d"},"MMM":{"M":"MMM – MMM"},"MMMd":{"d":"MMM d – d","M":"MMM d – MMM d"},"MMMEd":{"d":"E, MMM d – E, MMM d","M":"E, MMM d – E, MMM d"},"y":{"y":"y – y"},"yM":{"M":"M/y – M/y","y":"M/y – M/y"},"yMd":{"d":"M/d/y – M/d/y","M":"M/d/y – M/d/y","y":"M/d/y – M/d/y"},"yMEd":{"d":"E, M/d/y – E, M/d/y","M":"E, M/d/y – E, M/d/y","y":"E, M/d/y – E, M/d/y"},"yMMM":{"M":"MMM – MMM y","y":"MMM y – MMM y"},"yMMMd":{"d":"MMM d – d, y","M":"MMM d – MMM d, y","y":"MMM d, y – MMM d, y"},"yMMMEd":{"d":"E, MMM d – E, MMM d, y","M":"E, MMM d – E, MMM d, y","y":"E, MMM d, y – E, MMM d, y"},"yMMMM":{"M":"MMMM – MMMM y","y":"MMMM y – MMMM y"}}},"months":{"format":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]},"stand-alone":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]}},"days":{"format":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},"stand-alone":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]}},"quarters":{"format":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]},"stand-alone":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]}},"dayPeriods":{"format":{"abbreviated":["AM","PM"],"narrow":["a","p"],"wide":["AM","PM"]},"stand-alone":{"abbreviated":["AM","PM"],"narrow":["AM","PM"],"wide":["AM","PM"]}},"era-wide":{"0":"Before Christ","1":"Anno Domini"},"era-abbreviated":{"0":"BC","1":"AD"},"era-narrow":{"0":"B","1":"A"}},"eras-gregorian":{"0":{"_end":"0-12-31"},"1":{"_start":"1-01-01"}},"dateFields":{"era":{"displayName":"era"},"year-wide":{"displayName":"year","relative-type--1":"last year","relative-type-0":"this year","relative-type-1":"next year","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} year","relativeTimePattern-count-other":"in {0} years"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} year ago","relativeTimePattern-count-other":"{0} years ago"}},"year-short":{"displayName":"yr.","relative-type--1":"last yr.","relative-type-0":"this yr.","relative-type-1":"next yr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} yr.","relativeTimePattern-count-other":"in {0} yr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} yr. ago","relativeTimePattern-count-other":"{0} yr. ago"}},"year-narrow":{"displayName":"yr.","relative-type--1":"last yr.","relative-type-0":"this yr.","relative-type-1":"next yr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} yr.","relativeTimePattern-count-other":"in {0} yr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} yr. ago","relativeTimePattern-count-other":"{0} yr. ago"}},"quarter-wide":{"displayName":"quarter","relative-type--1":"last quarter","relative-type-0":"this quarter","relative-type-1":"next quarter","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} quarter","relativeTimePattern-count-other":"in {0} quarters"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} quarter ago","relativeTimePattern-count-other":"{0} quarters ago"}},"quarter-short":{"displayName":"qtr.","relative-type--1":"last qtr.","relative-type-0":"this qtr.","relative-type-1":"next qtr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} qtr.","relativeTimePattern-count-other":"in {0} qtrs."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} qtr. ago","relativeTimePattern-count-other":"{0} qtrs. ago"}},"quarter-narrow":{"displayName":"qtr.","relative-type--1":"last qtr.","relative-type-0":"this qtr.","relative-type-1":"next qtr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} qtr.","relativeTimePattern-count-other":"in {0} qtrs."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} qtr. ago","relativeTimePattern-count-other":"{0} qtrs. ago"}},"month-wide":{"displayName":"month","relative-type--1":"last month","relative-type-0":"this month","relative-type-1":"next month","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} month","relativeTimePattern-count-other":"in {0} months"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} month ago","relativeTimePattern-count-other":"{0} months ago"}},"month-short":{"displayName":"mo.","relative-type--1":"last mo.","relative-type-0":"this mo.","relative-type-1":"next mo.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} mo.","relativeTimePattern-count-other":"in {0} mo."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} mo. ago","relativeTimePattern-count-other":"{0} mo. ago"}},"month-narrow":{"displayName":"mo.","relative-type--1":"last mo.","relative-type-0":"this mo.","relative-type-1":"next mo.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} mo.","relativeTimePattern-count-other":"in {0} mo."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} mo. ago","relativeTimePattern-count-other":"{0} mo. ago"}},"week-wide":{"displayName":"week","relative-type--1":"last week","relative-type-0":"this week","relative-type-1":"next week","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} week","relativeTimePattern-count-other":"in {0} weeks"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} week ago","relativeTimePattern-count-other":"{0} weeks ago"},"relativePeriod":"the week of {0}"},"week-short":{"displayName":"wk.","relative-type--1":"last wk.","relative-type-0":"this wk.","relative-type-1":"next wk.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} wk.","relativeTimePattern-count-other":"in {0} wk."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} wk. ago","relativeTimePattern-count-other":"{0} wk. ago"},"relativePeriod":"the week of {0}"},"week-narrow":{"displayName":"wk.","relative-type--1":"last wk.","relative-type-0":"this wk.","relative-type-1":"next wk.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} wk.","relativeTimePattern-count-other":"in {0} wk."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} wk. ago","relativeTimePattern-count-other":"{0} wk. ago"},"relativePeriod":"the week of {0}"},"day-wide":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"day-short":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"day-narrow":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"weekday":{"displayName":"day of the week"},"hour-wide":{"displayName":"hour","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hour","relativeTimePattern-count-other":"in {0} hours"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hour ago","relativeTimePattern-count-other":"{0} hours ago"}},"hour-short":{"displayName":"hr.","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hr.","relativeTimePattern-count-other":"in {0} hr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hr. ago","relativeTimePattern-count-other":"{0} hr. ago"}},"hour-narrow":{"displayName":"hr.","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hr.","relativeTimePattern-count-other":"in {0} hr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hr. ago","relativeTimePattern-count-other":"{0} hr. ago"}},"minute-wide":{"displayName":"minute","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} minute","relativeTimePattern-count-other":"in {0} minutes"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} minute ago","relativeTimePattern-count-other":"{0} minutes ago"}},"minute-short":{"displayName":"min.","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} min.","relativeTimePattern-count-other":"in {0} min."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} min. ago","relativeTimePattern-count-other":"{0} min. ago"}},"minute-narrow":{"displayName":"min.","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} min.","relativeTimePattern-count-other":"in {0} min."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} min. ago","relativeTimePattern-count-other":"{0} min. ago"}},"second-wide":{"displayName":"second","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} second","relativeTimePattern-count-other":"in {0} seconds"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} second ago","relativeTimePattern-count-other":"{0} seconds ago"}},"second-short":{"displayName":"sec.","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} sec.","relativeTimePattern-count-other":"in {0} sec."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} sec. ago","relativeTimePattern-count-other":"{0} sec. ago"}},"second-narrow":{"displayName":"sec.","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} sec.","relativeTimePattern-count-other":"in {0} sec."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} sec. ago","relativeTimePattern-count-other":"{0} sec. ago"}},"zone":{"displayName":"time zone"}},"decimalFormat":{"standard":"#,##0.###"},"currencyFormat":{"standard":"¤#,##0.00","currencySpacing":{"beforeCurrency":{"currencyMatch":"[:^S:]","surroundingMatch":"[:digit:]","insertBetween":" "},"afterCurrency":{"currencyMatch":"[:^S:]","surroundingMatch":"[:digit:]","insertBetween":" "}}},"percentFormat":{"standard":"#,##0%"},"symbols-latn-decimal":".","symbols-latn-group":",","symbols-latn-plusSign":"+","symbols-latn-minusSign":"-","symbols-latn-percentSign":"%","weekData-minDays":4,"weekData-firstDay":1,"weekData-weekendStart":6,"weekData-weekendEnd":0,"timeData":{_allowed:"H h",_preferred:"H"},"plurals":{},"units":{"short":{"per":{"compoundUnitPattern":"{0}/{1}"},"acceleration-g-force":{"displayName":"g-force","unitPattern-count-one":"{0} G","unitPattern-count-other":"{0} G"},"acceleration-meter-per-second-squared":{"displayName":"meters/sec²","unitPattern-count-one":"{0} m/s²","unitPattern-count-other":"{0} m/s²"},"angle-revolution":{"displayName":"rev","unitPattern-count-one":"{0} rev","unitPattern-count-other":"{0} rev"},"angle-radian":{"displayName":"radians","unitPattern-count-one":"{0} rad","unitPattern-count-other":"{0} rad"},"angle-degree":{"displayName":"degrees","unitPattern-count-one":"{0} deg","unitPattern-count-other":"{0} deg"},"angle-arc-minute":{"displayName":"arcmins","unitPattern-count-one":"{0} arcmin","unitPattern-count-other":"{0} arcmins"},"angle-arc-second":{"displayName":"arcsecs","unitPattern-count-one":"{0} arcsec","unitPattern-count-other":"{0} arcsecs"},"area-square-kilometer":{"displayName":"km²","unitPattern-count-one":"{0} km²","unitPattern-count-other":"{0} km²","perUnitPattern":"{0}/km²"},"area-hectare":{"displayName":"hectares","unitPattern-count-one":"{0} ha","unitPattern-count-other":"{0} ha"},"area-square-meter":{"displayName":"meters²","unitPattern-count-one":"{0} m²","unitPattern-count-other":"{0} m²","perUnitPattern":"{0}/m²"},"area-square-centimeter":{"displayName":"cm²","unitPattern-count-one":"{0} cm²","unitPattern-count-other":"{0} cm²","perUnitPattern":"{0}/cm²"},"area-square-mile":{"displayName":"sq miles","unitPattern-count-one":"{0} sq mi","unitPattern-count-other":"{0} sq mi","perUnitPattern":"{0}/mi²"},"area-acre":{"displayName":"acres","unitPattern-count-one":"{0} ac","unitPattern-count-other":"{0} ac"},"area-square-yard":{"displayName":"yards²","unitPattern-count-one":"{0} yd²","unitPattern-count-other":"{0} yd²"},"area-square-foot":{"displayName":"sq feet","unitPattern-count-one":"{0} sq ft","unitPattern-count-other":"{0} sq ft"},"area-square-inch":{"displayName":"inches²","unitPattern-count-one":"{0} in²","unitPattern-count-other":"{0} in²","perUnitPattern":"{0}/in²"},"concentr-karat":{"displayName":"karats","unitPattern-count-one":"{0} kt","unitPattern-count-other":"{0} kt"},"concentr-milligram-per-deciliter":{"displayName":"mg/dL","unitPattern-count-one":"{0} mg/dL","unitPattern-count-other":"{0} mg/dL"},"concentr-millimole-per-liter":{"displayName":"millimol/liter","unitPattern-count-one":"{0} mmol/L","unitPattern-count-other":"{0} mmol/L"},"concentr-part-per-million":{"displayName":"parts/million","unitPattern-count-one":"{0} ppm","unitPattern-count-other":"{0} ppm"},"consumption-liter-per-kilometer":{"displayName":"liters/km","unitPattern-count-one":"{0} L/km","unitPattern-count-other":"{0} L/km"},"consumption-liter-per-100kilometers":{"displayName":"L/100 km","unitPattern-count-one":"{0} L/100 km","unitPattern-count-other":"{0} L/100 km"},"consumption-mile-per-gallon":{"displayName":"miles/gal","unitPattern-count-one":"{0} mpg","unitPattern-count-other":"{0} mpg"},"consumption-mile-per-gallon-imperial":{"displayName":"miles/gal Imp.","unitPattern-count-one":"{0} mpg Imp.","unitPattern-count-other":"{0} mpg Imp."},"digital-terabyte":{"displayName":"TByte","unitPattern-count-one":"{0} TB","unitPattern-count-other":"{0} TB"},"digital-terabit":{"displayName":"Tbit","unitPattern-count-one":"{0} Tb","unitPattern-count-other":"{0} Tb"},"digital-gigabyte":{"displayName":"GByte","unitPattern-count-one":"{0} GB","unitPattern-count-other":"{0} GB"},"digital-gigabit":{"displayName":"Gbit","unitPattern-count-one":"{0} Gb","unitPattern-count-other":"{0} Gb"},"digital-megabyte":{"displayName":"MByte","unitPattern-count-one":"{0} MB","unitPattern-count-other":"{0} MB"},"digital-megabit":{"displayName":"Mbit","unitPattern-count-one":"{0} Mb","unitPattern-count-other":"{0} Mb"},"digital-kilobyte":{"displayName":"kByte","unitPattern-count-one":"{0} kB","unitPattern-count-other":"{0} kB"},"digital-kilobit":{"displayName":"kbit","unitPattern-count-one":"{0} kb","unitPattern-count-other":"{0} kb"},"digital-byte":{"displayName":"byte","unitPattern-count-one":"{0} byte","unitPattern-count-other":"{0} byte"},"digital-bit":{"displayName":"bit","unitPattern-count-one":"{0} bit","unitPattern-count-other":"{0} bit"},"duration-century":{"displayName":"c","unitPattern-count-one":"{0} c","unitPattern-count-other":"{0} c"},"duration-year":{"displayName":"years","unitPattern-count-one":"{0} yr","unitPattern-count-other":"{0} yrs","perUnitPattern":"{0}/y"},"duration-month":{"displayName":"months","unitPattern-count-one":"{0} mth","unitPattern-count-other":"{0} mths","perUnitPattern":"{0}/m"},"duration-week":{"displayName":"weeks","unitPattern-count-one":"{0} wk","unitPattern-count-other":"{0} wks","perUnitPattern":"{0}/w"},"duration-day":{"displayName":"days","unitPattern-count-one":"{0} day","unitPattern-count-other":"{0} days","perUnitPattern":"{0}/d"},"duration-hour":{"displayName":"hours","unitPattern-count-one":"{0} hr","unitPattern-count-other":"{0} hr","perUnitPattern":"{0}/h"},"duration-minute":{"displayName":"mins","unitPattern-count-one":"{0} min","unitPattern-count-other":"{0} min","perUnitPattern":"{0}/min"},"duration-second":{"displayName":"secs","unitPattern-count-one":"{0} sec","unitPattern-count-other":"{0} sec","perUnitPattern":"{0}/s"},"duration-millisecond":{"displayName":"millisecs","unitPattern-count-one":"{0} ms","unitPattern-count-other":"{0} ms"},"duration-microsecond":{"displayName":"μsecs","unitPattern-count-one":"{0} μs","unitPattern-count-other":"{0} μs"},"duration-nanosecond":{"displayName":"nanosecs","unitPattern-count-one":"{0} ns","unitPattern-count-other":"{0} ns"},"electric-ampere":{"displayName":"amps","unitPattern-count-one":"{0} A","unitPattern-count-other":"{0} A"},"electric-milliampere":{"displayName":"milliamps","unitPattern-count-one":"{0} mA","unitPattern-count-other":"{0} mA"},"electric-ohm":{"displayName":"ohms","unitPattern-count-one":"{0} Ω","unitPattern-count-other":"{0} Ω"},"electric-volt":{"displayName":"volts","unitPattern-count-one":"{0} V","unitPattern-count-other":"{0} V"},"energy-kilocalorie":{"displayName":"kcal","unitPattern-count-one":"{0} kcal","unitPattern-count-other":"{0} kcal"},"energy-calorie":{"displayName":"cal","unitPattern-count-one":"{0} cal","unitPattern-count-other":"{0} cal"},"energy-foodcalorie":{"displayName":"Cal","unitPattern-count-one":"{0} Cal","unitPattern-count-other":"{0} Cal"},"energy-kilojoule":{"displayName":"kilojoule","unitPattern-count-one":"{0} kJ","unitPattern-count-other":"{0} kJ"},"energy-joule":{"displayName":"joules","unitPattern-count-one":"{0} J","unitPattern-count-other":"{0} J"},"energy-kilowatt-hour":{"displayName":"kW-hour","unitPattern-count-one":"{0} kWh","unitPattern-count-other":"{0} kWh"},"frequency-gigahertz":{"displayName":"GHz","unitPattern-count-one":"{0} GHz","unitPattern-count-other":"{0} GHz"},"frequency-megahertz":{"displayName":"MHz","unitPattern-count-one":"{0} MHz","unitPattern-count-other":"{0} MHz"},"frequency-kilohertz":{"displayName":"kHz","unitPattern-count-one":"{0} kHz","unitPattern-count-other":"{0} kHz"},"frequency-hertz":{"displayName":"Hz","unitPattern-count-one":"{0} Hz","unitPattern-count-other":"{0} Hz"},"length-kilometer":{"displayName":"km","unitPattern-count-one":"{0} km","unitPattern-count-other":"{0} km","perUnitPattern":"{0}/km"},"length-meter":{"displayName":"m","unitPattern-count-one":"{0} m","unitPattern-count-other":"{0} m","perUnitPattern":"{0}/m"},"length-decimeter":{"displayName":"dm","unitPattern-count-one":"{0} dm","unitPattern-count-other":"{0} dm"},"length-centimeter":{"displayName":"cm","unitPattern-count-one":"{0} cm","unitPattern-count-other":"{0} cm","perUnitPattern":"{0}/cm"},"length-millimeter":{"displayName":"mm","unitPattern-count-one":"{0} mm","unitPattern-count-other":"{0} mm"},"length-micrometer":{"displayName":"µmeters","unitPattern-count-one":"{0} µm","unitPattern-count-other":"{0} µm"},"length-nanometer":{"displayName":"nm","unitPattern-count-one":"{0} nm","unitPattern-count-other":"{0} nm"},"length-picometer":{"displayName":"pm","unitPattern-count-one":"{0} pm","unitPattern-count-other":"{0} pm"},"length-mile":{"displayName":"miles","unitPattern-count-one":"{0} mi","unitPattern-count-other":"{0} mi"},"length-yard":{"displayName":"yards","unitPattern-count-one":"{0} yd","unitPattern-count-other":"{0} yd"},"length-foot":{"displayName":"feet","unitPattern-count-one":"{0} ft","unitPattern-count-other":"{0} ft","perUnitPattern":"{0}/ft"},"length-inch":{"displayName":"inches","unitPattern-count-one":"{0} in","unitPattern-count-other":"{0} in","perUnitPattern":"{0}/in"},"length-parsec":{"displayName":"parsecs","unitPattern-count-one":"{0} pc","unitPattern-count-other":"{0} pc"},"length-light-year":{"displayName":"light yrs","unitPattern-count-one":"{0} ly","unitPattern-count-other":"{0} ly"},"length-astronomical-unit":{"displayName":"au","unitPattern-count-one":"{0} au","unitPattern-count-other":"{0} au"},"length-furlong":{"displayName":"furlongs","unitPattern-count-one":"{0} fur","unitPattern-count-other":"{0} fur"},"length-fathom":{"displayName":"fathoms","unitPattern-count-one":"{0} ftm","unitPattern-count-other":"{0} ftm"},"length-nautical-mile":{"displayName":"nmi","unitPattern-count-one":"{0} nmi","unitPattern-count-other":"{0} nmi"},"length-mile-scandinavian":{"displayName":"smi","unitPattern-count-one":"{0} smi","unitPattern-count-other":"{0} smi"},"length-point":{"displayName":"points","unitPattern-count-one":"{0} pt","unitPattern-count-other":"{0} pt"},"light-lux":{"displayName":"lux","unitPattern-count-one":"{0} lx","unitPattern-count-other":"{0} lx"},"mass-metric-ton":{"displayName":"t","unitPattern-count-one":"{0} t","unitPattern-count-other":"{0} t"},"mass-kilogram":{"displayName":"kg","unitPattern-count-one":"{0} kg","unitPattern-count-other":"{0} kg","perUnitPattern":"{0}/kg"},"mass-gram":{"displayName":"grams","unitPattern-count-one":"{0} g","unitPattern-count-other":"{0} g","perUnitPattern":"{0}/g"},"mass-milligram":{"displayName":"mg","unitPattern-count-one":"{0} mg","unitPattern-count-other":"{0} mg"},"mass-microgram":{"displayName":"µg","unitPattern-count-one":"{0} µg","unitPattern-count-other":"{0} µg"},"mass-ton":{"displayName":"tons","unitPattern-count-one":"{0} tn","unitPattern-count-other":"{0} tn"},"mass-stone":{"displayName":"stones","unitPattern-count-one":"{0} st","unitPattern-count-other":"{0} st"},"mass-pound":{"displayName":"pounds","unitPattern-count-one":"{0} lb","unitPattern-count-other":"{0} lb","perUnitPattern":"{0}/lb"},"mass-ounce":{"displayName":"oz","unitPattern-count-one":"{0} oz","unitPattern-count-other":"{0} oz","perUnitPattern":"{0}/oz"},"mass-ounce-troy":{"displayName":"oz troy","unitPattern-count-one":"{0} oz t","unitPattern-count-other":"{0} oz t"},"mass-carat":{"displayName":"carats","unitPattern-count-one":"{0} CD","unitPattern-count-other":"{0} CD"},"power-gigawatt":{"displayName":"GW","unitPattern-count-one":"{0} GW","unitPattern-count-other":"{0} GW"},"power-megawatt":{"displayName":"MW","unitPattern-count-one":"{0} MW","unitPattern-count-other":"{0} MW"},"power-kilowatt":{"displayName":"kW","unitPattern-count-one":"{0} kW","unitPattern-count-other":"{0} kW"},"power-watt":{"displayName":"watts","unitPattern-count-one":"{0} W","unitPattern-count-other":"{0} W"},"power-milliwatt":{"displayName":"mW","unitPattern-count-one":"{0} mW","unitPattern-count-other":"{0} mW"},"power-horsepower":{"displayName":"hp","unitPattern-count-one":"{0} hp","unitPattern-count-other":"{0} hp"},"pressure-hectopascal":{"displayName":"hPa","unitPattern-count-one":"{0} hPa","unitPattern-count-other":"{0} hPa"},"pressure-millimeter-of-mercury":{"displayName":"mmHg","unitPattern-count-one":"{0} mmHg","unitPattern-count-other":"{0} mmHg"},"pressure-pound-per-square-inch":{"displayName":"psi","unitPattern-count-one":"{0} psi","unitPattern-count-other":"{0} psi"},"pressure-inch-hg":{"displayName":"inHg","unitPattern-count-one":"{0} inHg","unitPattern-count-other":"{0} inHg"},"pressure-millibar":{"displayName":"mbar","unitPattern-count-one":"{0} mbar","unitPattern-count-other":"{0} mbar"},"speed-kilometer-per-hour":{"displayName":"km/hour","unitPattern-count-one":"{0} kph","unitPattern-count-other":"{0} kph"},"speed-meter-per-second":{"displayName":"meters/sec","unitPattern-count-one":"{0} m/s","unitPattern-count-other":"{0} m/s"},"speed-mile-per-hour":{"displayName":"miles/hour","unitPattern-count-one":"{0} mph","unitPattern-count-other":"{0} mph"},"speed-knot":{"displayName":"kn","unitPattern-count-one":"{0} kn","unitPattern-count-other":"{0} kn"},"temperature-generic":{"displayName":"°","unitPattern-count-other":"{0}°"},"temperature-celsius":{"displayName":"deg. C","unitPattern-count-one":"{0}°C","unitPattern-count-other":"{0}°C"},"temperature-fahrenheit":{"displayName":"deg. F","unitPattern-count-one":"{0}°F","unitPattern-count-other":"{0}°F"},"temperature-kelvin":{"displayName":"K","unitPattern-count-one":"{0} K","unitPattern-count-other":"{0} K"},"volume-cubic-kilometer":{"displayName":"km³","unitPattern-count-one":"{0} km³","unitPattern-count-other":"{0} km³"},"volume-cubic-meter":{"displayName":"m³","unitPattern-count-one":"{0} m³","unitPattern-count-other":"{0} m³","perUnitPattern":"{0}/m³"},"volume-cubic-centimeter":{"displayName":"cm³","unitPattern-count-one":"{0} cm³","unitPattern-count-other":"{0} cm³","perUnitPattern":"{0}/cm³"},"volume-cubic-mile":{"displayName":"mi³","unitPattern-count-one":"{0} mi³","unitPattern-count-other":"{0} mi³"},"volume-cubic-yard":{"displayName":"yards³","unitPattern-count-one":"{0} yd³","unitPattern-count-other":"{0} yd³"},"volume-cubic-foot":{"displayName":"feet³","unitPattern-count-one":"{0} ft³","unitPattern-count-other":"{0} ft³"},"volume-cubic-inch":{"displayName":"inches³","unitPattern-count-one":"{0} in³","unitPattern-count-other":"{0} in³"},"volume-megaliter":{"displayName":"ML","unitPattern-count-one":"{0} ML","unitPattern-count-other":"{0} ML"},"volume-hectoliter":{"displayName":"hL","unitPattern-count-one":"{0} hL","unitPattern-count-other":"{0} hL"},"volume-liter":{"displayName":"liters","unitPattern-count-one":"{0} L","unitPattern-count-other":"{0} L","perUnitPattern":"{0}/L"},"volume-deciliter":{"displayName":"dL","unitPattern-count-one":"{0} dL","unitPattern-count-other":"{0} dL"},"volume-centiliter":{"displayName":"cL","unitPattern-count-one":"{0} cL","unitPattern-count-other":"{0} cL"},"volume-milliliter":{"displayName":"mL","unitPattern-count-one":"{0} mL","unitPattern-count-other":"{0} mL"},"volume-pint-metric":{"displayName":"mpt","unitPattern-count-one":"{0} mpt","unitPattern-count-other":"{0} mpt"},"volume-cup-metric":{"displayName":"mcup","unitPattern-count-one":"{0} mc","unitPattern-count-other":"{0} mc"},"volume-acre-foot":{"displayName":"acre ft","unitPattern-count-one":"{0} ac ft","unitPattern-count-other":"{0} ac ft"},"volume-bushel":{"displayName":"bushels","unitPattern-count-one":"{0} bu","unitPattern-count-other":"{0} bu"},"volume-gallon":{"displayName":"gal","unitPattern-count-one":"{0} gal","unitPattern-count-other":"{0} gal","perUnitPattern":"{0}/gal US"},"volume-gallon-imperial":{"displayName":"Imp. gal","unitPattern-count-one":"{0} gal Imp.","unitPattern-count-other":"{0} gal Imp.","perUnitPattern":"{0}/gal Imp."},"volume-quart":{"displayName":"qts","unitPattern-count-one":"{0} qt","unitPattern-count-other":"{0} qt"},"volume-pint":{"displayName":"pints","unitPattern-count-one":"{0} pt","unitPattern-count-other":"{0} pt"},"volume-cup":{"displayName":"cups","unitPattern-count-one":"{0} c","unitPattern-count-other":"{0} c"},"volume-fluid-ounce":{"displayName":"fl oz","unitPattern-count-one":"{0} fl oz","unitPattern-count-other":"{0} fl oz"},"volume-tablespoon":{"displayName":"tbsp","unitPattern-count-one":"{0} tbsp","unitPattern-count-other":"{0} tbsp"},"volume-teaspoon":{"displayName":"tsp","unitPattern-count-one":"{0} tsp","unitPattern-count-other":"{0} tsp"},"coordinateUnit":{"east":"{0} E","north":"{0} N","south":"{0} S","west":"{0} W"}}}};var b={"iw":"he","ji":"yi","in":"id","sh":"sr"};var d=(function(){var h=L._cldrLocales,r={},i;if(h){for(i=0;i<h.length;i++){r[h[i]]=true;}}return r;}());var l={};
function g(s){if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}return"ca-"+s.toLowerCase();}
function e(o){var s=o.getLanguage()||"",S=o.getScript()||"",r=o.getRegion()||"",D;function m(j,k){var n,v,p;if(!k){return;}for(n in k){if(k.hasOwnProperty(n)){v=j[n];p=k[n];if(v===undefined){j[n]=p;}else if(v===null){delete j[n];}else if(typeof v==='object'&&typeof p==='object'){m(v,p);}}}}function h(i){if(!l[i]&&(!d||d[i]===true)){var j=l[i]=q.sap.loadResource("sap/ui/core/cldr/"+i+".json",{dataType:"json",failOnError:false});if(j&&j.__fallbackLocale){m(j,h(j.__fallbackLocale));delete j.__fallbackLocale;}}return l[i];}s=(s&&b[s])||s;if(s==="no"){s="nb";}if(s==="zh"&&!r){if(S==="Hans"){r="CN";}else if(S==="Hant"){r="TW";}}var i=s+"_"+r;if(s&&r){D=h(i);}if(!D&&s){D=h(s);}l[i]=D||M;return l[i];}
var f=a.extend("sap.ui.core.CustomLocaleData",{
constructor:function(o){a.apply(this,arguments);this.mCustomData=sap.ui.getCore().getConfiguration().getFormatSettings().getCustomLocaleData();},
_get:function(){var A=Array.prototype.slice.call(arguments),s,k;if(A[0].indexOf("ca-")==0){s=A[0];if(s==g()){A=A.slice(1);}}k=A.join("-");var v=this.mCustomData[k];if(v==null){v=this._getDeep(this.mCustomData,arguments);if(v==null){v=this._getDeep(this.mData,arguments);}}return v;},
_getMerged:function(){var D=this._getDeep(this.mData,arguments);var m=this._getDeep(this.mCustomData,arguments);return q.extend({},D,m);}
});
a.getInstance=function(o){return o.hasPrivateUseSubtag("sapufmt")?new f(o):new a(o);};
return a;});
sap.ui.predefine('sap/ui/core/Message',['jquery.sap.global','./Element','./library'],function(q,E,l){"use strict";var M=l.MessageType;
var a=E.extend("sap.ui.core.Message",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:null},timestamp:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},level:{type:"sap.ui.core.MessageType",group:"Misc",defaultValue:M.None},readOnly:{type:"boolean",group:"Misc",defaultValue:false}}}});
a.prototype.getDefaultIcon=function(s){var m=q.sap.getModulePath("sap.ui.core.themes."+sap.ui.getCore().getConfiguration().getTheme());var i=m+"/img/message/";if(s&&s=="32x32"){i+="32x32/";}else{i+="16x16/";}var u="";switch(this.getProperty("level")){case M.Error:u=i+"Message_Icon_Error.png";break;case M.Information:u=i+"Message_Icon_Information.png";break;case M.Warning:u=i+"Message_Icon_Warning.png";break;case M.Success:u=i+"Message_Icon_Success.png";break;case M.None:default:u=this.getProperty("icon");break;}return u;};
a.prototype.compareByType=function(o){return a.compareByType(this,o);};
a.compareByType=function(m,o){if(!m&&!o){return 0;}if(m&&!o){return 1;}if(!m&&o){return-1;}var L=m.getLevel();var s=o.getLevel();if(L===s){return 0;}switch(L){case M.Error:return 1;case M.Warning:return s===M.Error?-1:1;case M.Success:return s===M.Error||s===M.Warning?-1:1;case M.Information:return s===M.None?1:-1;case M.None:return-1;default:q.sap.log.error("Comparison error",this);return 0;}};
return a;});
sap.ui.predefine('sap/ui/core/Popup',['jquery.sap.global','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/base/Object','sap/ui/base/ObjectPool','./Control','./IntervalTrigger','./RenderManager','./Element','./ResizeHandler','./library','jquery.sap.script','jquery.sap.dom'],function(q,D,M,B,O,C,I,R,E,a,b){"use strict";var c=b.CSSSize;var d=b.OpenState;
var P=M.extend("sap.ui.core.Popup",{
constructor:function(o,m,s,A){M.apply(this);this._popupUID=q.sap.uid();this.bOpen=false;this.eOpenState=d.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;if(o){this.setContent(o);}this._oDefaultPosition={my:P.Dock.CenterCenter,at:P.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=q.extend({},this._oDefaultPosition);this._bModal=!!m;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof(s)==="boolean"?s:true;this._bAutoClose=!!A;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this._oBlindLayer=null;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(e){if(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose")){return;}if(this.eOpenState===d.CLOSING||this.eOpenState===d.CLOSED){return;}if(!this._contains(e.target)){this.close();}};}this._F6NavigationHandler=function(e){var S={},f=this._sF6NavMode,g;if(f=="DOCK"){if(this._bModal){f="NONE";}else if(this._oLastPosition&&this._oLastPosition.of){g=this._getOfDom(this._oLastPosition.of);if(!g||g===document){g=null;f="NONE";}}}switch(f){case"SCOPE":S.scope=this._$()[0];break;case"DOCK":S.target=g;var $=q(g).parents("[data-sap-ui-popup]");S.scope=$.length?$[0]:null;break;default:S.skip=true;}q.sap.handleF6GroupNavigation(e,S);};},
metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{"childPopups":{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{"opened":{},"closed":{}}}
});
P._activateBlindLayer=true;P.blStack=[];P.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};P.prototype.touchEnabled=D.support.touch||q.sap.simulateMobileOnDesktop;P.prototype.preventBrowserFocus=(D.support.touch||q.sap.simulateMobileOnDesktop)&&!D.system.combi;
B.extend("sap.ui.core.Popup.Layer",{constructor:function(){var s=this.getDomString();this._$Ref=q(s).appendTo(sap.ui.getCore().getStaticAreaRef());}});
P.Layer.prototype.init=function(o,z){this._$Ref.css({"visibility":"visible","z-index":z});this.update(o,z);this._$Ref.insertAfter(o).show();};
P.Layer.prototype.update=function(o,z){if(o.length){var e=o.rect();this._$Ref.css({"left":e.left,"top":e.top});if(o.css("right")!="auto"&&o.css("right")!="inherit"){this._$Ref.css({"right":o.css("right"),"width":"auto"});}else{this._$Ref.css({"width":e.width,"right":"auto"});}if(o.css("bottom")!="auto"&&o.css("bottom")!="inherit"){this._$Ref.css({"bottom":o.css("bottom"),"height":"auto"});}else{this._$Ref.css({"height":e.height,"bottom":"auto"});}if(typeof(z)==="number"){this._$Ref.css("z-index",z);}}};
P.Layer.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(sap.ui.getCore().getStaticAreaRef());}};
P.Layer.prototype.getDomString=function(){q.sap.log.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return"";};
P.Layer.extend("sap.ui.core.Popup.BlindLayer",{constructor:function(){P.Layer.apply(this);}});
P.BlindLayer.prototype.getDomString=function(){return"<div class=\"sapUiBliLy\" id=\"sap-ui-blindlayer-"+q.sap.uid()+"\"><iframe scrolling=\"no\" tabIndex=\"-1\"></iframe></div>";};
P.prototype.oBlindLayerPool=new O(P.BlindLayer);
P.Layer.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){P.Layer.apply(this);}});
P.ShieldLayer.prototype.getDomString=function(){return"<div class=\"sapUiPopupShield\" id=\"sap-ui-shieldlayer-"+q.sap.uid()+"\"></div>";};
P.prototype.oShieldLayerPool=new O(P.ShieldLayer);(function(){var l=0;var m=Math.pow(2,32)-1;
P.setInitialZIndex=function(i){if(i>=m){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}l=Math.max(i,this.getLastZIndex());};
P.getLastZIndex=function(){return l;};
P.prototype.getLastZIndex=function(){return P.getLastZIndex();};
P.getNextZIndex=function(){l+=10;if(l>=m){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}return l;};
P.prototype.getNextZIndex=function(){return P.getNextZIndex();};
}());var r=function(o,e){var p=3;var l=Math.abs(o.left-e.left);var t=Math.abs(o.top-e.top);var w=Math.abs(o.width-e.width);var h=Math.abs(o.height-e.height);if(l>p||t>p||w>p||h>p){return false;}return true;};
P.prototype.open=function(i,m,f,o,g,h,j){if(this.eOpenState!=d.CLOSED){return;}this.eOpenState=d.OPENING;var s;try{s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);}catch(e){q.sap.log.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}this._bContentAddedToStatic=false;if(this.oContent instanceof C&&!this.oContent.getParent()){s.addContent(this.oContent,true);this._bContentAddedToStatic=true;}if(this.oContent.getUIArea){var A=this.oContent.getUIArea();if(A===null){q.sap.log.warning("The Popup content is NOT connected with a UIArea and may not work properly!");}else if(P._bEnableUIAreaCheck&&A.getRootNode().id!==s.getRootNode().id){q.sap.log.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!");}}if(typeof(i)=="string"){j=h;h=g;g=o;o=f;f=m;m=i;i=-1;}if(i===undefined){i=-1;}this._oPreviousFocus=P.getCurrentFocusInfo();if(this._bModal&&document.activeElement){document.activeElement.blur();}if(this.isInPopup(o)||this.isInPopup(this._oPosition.of)){var p=this.getParentPopupId(o)||this.getParentPopupId(this._oPosition.of);var k="";var l=this.getContent();if(l instanceof E){k=l.getId();}else if(typeof l==="object"){k=l.id;}this.addChildToPopup(p,k);this.addChildToPopup(p,this._popupUID);}var $=this._$(true);var n="fast";if((i===0)||(i>0)){n=i;}else if((this._durations.open===0)||(this._durations.open>0)){n=this._durations.open;}var _;if(m||f||o||g||h){_=this._createPosition(m,f,o,g,h);this._oPosition=_;}else{_=this._oPosition;}if(!_.of){_.of=this._oPosition.of||document;}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var S=sap.ui.getCore().getStaticAreaRef();$.css({"position":"absolute","visibility":"hidden"});if(!($[0].parentNode==S)){$.appendTo(S);}$.css("z-index",this._iZIndex);q.sap.log.debug("position popup content "+$.attr("id")+" at "+(window.JSON?JSON.stringify(_.at):String(_.at)));this._applyPosition(_);if(j!==undefined){this.setFollowOf(j);}$.toggleClass("sapUiShd",this._bShadow);var t=$[0];if(t){t.style.display="none";t.style.visibility="visible";}this._duringOpen();if(n==0){this._opened();}else if(this._animations.open){this._animations.open.call(null,$,n,this._opened.bind(this));}else{$.fadeIn(n,this._opened.bind(this));}};
P.prototype._opened=function(){if(this.eOpenState!==d.OPENING){return;}this.bOpen=true;var $=this._$(false,true);if($[0]&&$[0].style){$[0].style.display="block";}if(this._bModal||this._bAutoClose||this._sInitialFocusId){var e=null;if(this._sInitialFocusId){var f=sap.ui.getCore().byId(this._sInitialFocusId);if(f){e=f.getFocusDomRef();}e=e||q.sap.domById(this._sInitialFocusId);}q.sap.focus(e||$.firstFocusableDomRef());var o=this._getOfDom(this._oLastPosition.of);var g=q(o).rect();if(this._oLastOfRect&&g&&!r(this._oLastOfRect,g)){this._applyPosition(this._oLastPosition);}}this.eOpenState=d.OPEN;if(this.getFollowOf()){P.DockTrigger.addListener(P.checkDocking,this);}this._updateBlindLayer();this.fireOpened();};
P.prototype._duringOpen=function(){var $=this._$(false,true);if(q.sap.isMouseEventDelayed){if(this._oTopShieldLayer){q.sap.clearDelayedCall(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null;}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex+1);}this._iTopShieldRemoveTimer=q.sap.delayedCall(500,this,function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;});}if(!!D.browser.msie&&!D.os.windows_phone&&P._activateBlindLayer){this._oBlindLayer=this.oBlindLayerPool.borrowObject($,this._iZIndex-1);}if(this._bModal){this._showBlockLayer();}if(this.oContent instanceof E){this.oContent.addDelegate(this);}this.bOpen=true;this._activateFocusHandle();this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}};
P.prototype._contains=function(o){var p=this._$().get(0);if(!p){return false;}var e=q.sap.containsOrEquals(p,o);var f;if(!e){f=this.getChildPopups();e=f.some(function(s){var g=q.sap.domById(s);var e=q.sap.containsOrEquals(g,o);if(!e){var h="sap.ui.core.Popup.contains-"+s;var i={domRef:o};sap.ui.getCore().getEventBus().publish("sap.ui",h,i);e=i.contains;}return e;});}return e;};
P.prototype._containsEventBusWrapper=function(s,e,o){o.contains=this._contains(o.domRef);};
P.prototype.onFocusEvent=function(o){var e=q.event.fix(o);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){e=q.event.fix(arguments[2]);}var t=(e.type=="focus"||e.type=="activate")?"focus":"blur";var f=false;if(t=="focus"){var g=this._$().get(0);if(g){f=this._contains(e.target);q.sap.log.debug("focus event on "+e.target.id+", contains: "+f);if(this._bModal&&!f){var T=P.blStack.length>0&&P.blStack[P.blStack.length-1].popup===this;if(T){if(D.system.desktop||q(e.target).is(":input")){if(this.oLastBlurredElement){q.sap.delayedCall(0,this,function(){q.sap.focus(this.oLastBlurredElement);});}else{q.sap.focus(g);}}}}else if(this._bAutoClose&&f&&this._sTimeoutId){q.sap.clearDelayedCall(this._sTimeoutId);this._sTimeoutId=null;}}}else if(t=="blur"){q.sap.log.debug("blur event on "+e.target.id);if(this._bModal){this.oLastBlurredElement=e.target;}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(e.target===document.activeElement){return;}var i=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=q.sap.delayedCall(i,this,function(){this.close(i,"autocloseBlur");var h=this._oLastPosition&&this._oLastPosition.of;if(h){var p=this.getParentPopupId(h);if(p){var s="sap.ui.core.Popup.onFocusEvent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",s,e);}}});}}}};
P.prototype.setInitialFocusId=function(i){this._sInitialFocusId=i;};
P.prototype.close=function(i){if(P._autoCloseDebug){return;}if(this._sTimeoutId){q.sap.clearDelayedCall(this._sTimeoutId);this._sTimeoutId=null;if(arguments.length>1){var A=arguments[1];if(typeof A=="string"&&A=="autocloseBlur"&&this._isFocusInsidePopup()){return;}}}if(this.eOpenState==d.CLOSED||this.eOpenState==d.CLOSING){return;}var e="fast";if((i===0)||(i>0)){e=i;}else if((this._durations.close===0)||(this._durations.close>0)){e=this._durations.close;}this.eOpenState=d.CLOSING;if(this.getFollowOf()){P.DockTrigger.removeListener(P.checkDocking,this);}if(this.oContent&&this._bContentAddedToStatic){sap.ui.getCore().getEventBus().publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.removeContent(s.indexOfContent(this.oContent),true);}this._bContentAddedToStatic=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof E){this.oContent.removeDelegate(this);}var $=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._oBlindLayer){this.oBlindLayerPool.returnObject(this._oBlindLayer);}this._oBlindLayer=null;if(q.sap.isMouseEventDelayed){if(this._oBottomShieldLayer){q.sap.clearDelayedCall(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null;}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex-3);}this._iBottomShieldRemoveTimer=q.sap.delayedCall(500,this,function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;});}if(this.isInPopup(this._oLastPosition.of)){var p=this.getParentPopupId(this._oLastPosition.of);var f="";var o=this.getContent();if(o instanceof E){f=o.getId();}else if(typeof o==="object"){f=o.id;}this.removeChildFromPopup(p,f);this.removeChildFromPopup(p,this._popupUID);}if(this._bModal&&this.preventBrowserFocus){$.one("mousedown",function(g){g.preventDefault();});}this._duringClose();if(e==0){this._closed();}else if(this._animations.close){this._animations.close.call(null,$,e,this._closed.bind(this));}else{$.fadeOut(e,this._closed.bind(this));}};
P.prototype._closed=function(){if(this._bModal){this._hideBlockLayer();}var $=this._$(false,true);if($.length){var o=$.get(0);if(o){o.style.display="none";o.style.visibility="hidden";o.style.left="0px";o.style.top="0px";o.style.right="";}$=this._$(false,true);o=$.length?$[0]:null;if(o){o.style.display="none";o.style.visibility="hidden";o.style.left="0px";o.style.top="0px";o.style.right="";}}if(this._bModal){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null;}this.bOpen=false;this.eOpenState=d.CLOSED;var e=this.getChildPopups();for(var j=0,l=e.length;j<l;j++){this.closePopup(e[j]);}this.fireClosed();};
P.prototype._duringClose=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
P.getCurrentFocusInfo=function(){var _=null;var f=sap.ui.getCore().getCurrentFocusedControlId();if(f){var F=sap.ui.getCore().byId(f);_={'sFocusId':f,'oFocusInfo':F?F.getFocusInfo():{}};}else{try{var e=document.activeElement;if(e&&e.nodeName){_={'sFocusId':e.id,'oFocusedElement':e,'oFocusInfo':{}};}}catch(g){_=null;}}if(_){_.popup=this;}return _;};
P.applyFocusInfo=function(p){if(p){var f=sap.ui.getCore().byId(p.sFocusId);if(f){f.applyFocusInfo(p.oFocusInfo);}else{var e=q.sap.domById(p.sFocusId)||p.oFocusedElement;q.sap.focus(e);}}};
P.prototype.setContent=function(o){this.oContent=o;return this;};
P.prototype.getContent=function(){return this.oContent;};
P.prototype.setPosition=function(m,e,o,f,g){this._oPosition=this._createPosition(m,e,o,f,g);if(this.eOpenState!=d.CLOSED){this._applyPosition(this._oPosition);this._oBlindLayer&&this._oBlindLayer.update(this._$());}return this;};
P.prototype._createPosition=function(m,e,o,f,g){var n=false;if(m&&(m.indexOf("+")>=0||m.indexOf("-")>=0)){n=true;if(f&&f!="0 0"){q.sap.log.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition");}f=null;}var p=q.extend({},this._oDefaultPosition,{"my":m||this._oDefaultPosition.my,"at":e||this._oDefaultPosition.at,"of":o,"offset":f,"collision":g});if(!q.ui.version){if(P._bNewOffset==null){P._bNewOffset=true;var $=q(document.createElement("div"));$.position({of:window,using:function(k,l){P._bNewOffset=(l!==undefined);}});}}var h=[];var i=[];if(P._bNewOffset||q.sap.Version(q.ui.version).compareTo("1.8.23")>0){if(f&&f!="0 0"){h=p.my.split(" ");i=f.split(" ");var s=[parseInt(i[0],10)<0?"":"+",parseInt(i[1],10)<0?"":"+"];p.my=h[0]+s[0]+i[0]+" "+h[1]+s[1]+i[1];p.offset=null;}}else if(n){h=p.my.split(" ");i=["",""];var j=h[0].indexOf("+");if(j<0){j=h[0].indexOf("-");}if(j>=0){i[0]=h[0].slice(j);h[0]=h[0].slice(0,j);}j=h[1].indexOf("+");if(j<0){j=h[1].indexOf("-");}if(j>=0){i[1]=h[1].slice(j);h[1]=h[1].slice(0,j);}p.my=h[0]+" "+h[1];p.offset=i[0]+" "+i[1];}return p;};
P.prototype._getPositionOffset=function(){var o=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var m=this._oPosition.my.split(" ");var i=m[0].indexOf("+");if(i<0){i=m[0].indexOf("-");}if(i>=0){o[0]=m[0].slice(i);}i=m[1].indexOf("+");if(i<0){i=m[1].indexOf("-");}if(i>=0){o[1]=m[1].slice(i);}}else if(this._oPosition.offset){o=this._oPosition.offset.split(" ");}return o;};
P.prototype._applyPosition=function(p){var e=sap.ui.getCore().getConfiguration().getRTL();var $=this._$();if($.length){var A=p.at;var o=$.get(0);if(typeof(A)==="string"){o.style.display="block";o.style.left="";o.style.right="";$.position(this._resolveReference(this._convertPositionRTL(p,e)));this._fixPositioning(p,e);}else if(c.isValid(A.left)&&c.isValid(A.top)){$.css({"left":A.left,"top":A.top});}else if(c.isValid(A.right)&&c.isValid(A.top)){$.css({"right":A.right,"top":A.top});}else if(typeof(A.left)==="number"&&typeof(A.top)==="number"){var f=$[0];if(f&&f.style.right){var w=$.outerWidth();$.css({"right":(document.documentElement.clientWidth-(A.left+w))+"px","top":A.top+"px"});}else{$.css({"left":A.left+"px","top":A.top+"px"});}}this._oLastPosition=p;this._oLastOfRect=this._calcOfRect(p.of);}};
P.prototype._calcOfRect=function(o){var e=this._getOfDom(o);if(e){return q(e).rect();}return null;};
P.prototype._getOfDom=function(o){if(o instanceof q.Event){return null;}var $;if(typeof(o)==="string"){$=q.sap.byId(o);}else if(o instanceof q){$=o;}else{$=q(o instanceof E?o.getDomRef():o);}return $[0];};
P.prototype._convertPositionRTL=function(p,e){var f=q.extend({},p);if(e){var n=false;if(f.my&&(f.my.indexOf("+")>=0||f.my.indexOf("-")>=0)){n=true;}if((f.offset||n)&&((f.my.indexOf("begin")>-1)||(f.my.indexOf("end")>-1))&&((f.at.indexOf("begin")>-1)||(f.at.indexOf("end")>-1))){if(n){var m=f.my.split(" ");if(m.length==2){f.my="";if(m[0]){if(m[0].indexOf("begin")>-1||m[0].indexOf("end")>-1){if(m[0].indexOf("+")>-1){m[0]=m[0].replace("+","-");}else if(m[0].indexOf("-")>-1){m[0]=m[0].replace("-","+");}}f.my=m[0];}if(m[1]){if(m[1].indexOf("begin")>-1||m[1].indexOf("end")>-1){if(m[1].indexOf("+")>-1){m[1]=m[1].replace("+","-");}else if(m[1].indexOf("-")>-1){m[1]=m[1].replace("-","+");}}if(m[0]){f.my=f.my+" ";}f.my=f.my+m[1];}}}else{f.offset=this._mirrorOffset(f.offset);}}f.my=f.my.replace("begin","right").replace("end","left");f.at=f.at.replace("begin","right").replace("end","left");}else{f.my=f.my.replace("end","right").replace("begin","left");f.at=f.at.replace("end","right").replace("begin","left");}return f;};
P.prototype._mirrorOffset=function(o){var e=q.trim(o).split(/\s/);var p=parseInt(e[0],10);return(-p)+" "+e[e.length-1];};
P.prototype._fixPositioning=function(p,e){var m=p.my;var $=this._$();var f=0;if(typeof(m)==="string"){if(e&&((m.indexOf("right")>-1)||(m.indexOf("begin")>-1)||(m.indexOf("center")>-1))){$=this._$();f=q(window).width()-$.outerWidth()-$.offset().left;$.css({"right":f+"px","left":""});}else if((m.indexOf("right")>-1)||(m.indexOf("end")>-1)){$=this._$();f=q(window).width()-$.outerWidth()-$.offset().left;$.css({"right":f+"px","left":""});}}};
P.prototype._resolveReference=function(p){var o=p;if(p.of instanceof E){o=q.extend({},p,{of:p.of.getDomRef()});}return o;};
P.prototype.setShadow=function(s){this._bShadow=s;if(this.eOpenState!=d.CLOSED){this._$().toggleClass("sapUiShd",s);}return this;};
P.prototype.setModal=function(m,s){var o=this._bModal;this._bModal=m;this._sModalCSSClass=s;if(this.isOpen()){if(o!==m){if(m){this._showBlockLayer();}else{this._hideBlockLayer();}if(this.touchEnabled&&this._bAutoClose){if(!m){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}}return this;};
P.prototype.getModal=function(){return this._bModal;};
P.prototype.setNavigationMode=function(m){if(m!="NONE"&&m!="DOCK"&&m!="SCOPE"){this._sF6NavMode="NONE";}this._sF6NavMode=m;};
P.prototype.setAutoClose=function(A){if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==A){if(!this._bModal){if(A){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}this._bAutoClose=A;return this;};
P.prototype.setAutoCloseAreas=function(A){if(!this._aAutoCloseAreas){this._aAutoCloseAreas=[];}var e=function(h){return{onBeforeRendering:function(){var j=o.getDomRef();if(j&&this.isOpen()){if(D.browser.msie){q(j).unbind("deactivate."+this._popupUID,this.fEventHandler);}else{j.removeEventListener("blur",this.fEventHandler,true);}}},onAfterRendering:function(){var j=o.getDomRef();if(j&&this.isOpen()){if(D.browser.msie){q(j).bind("deactivate."+this._popupUID,this.fEventHandler);}else{j.addEventListener("blur",this.fEventHandler,true);}}}};};var s,o,f,g;for(var i=0,l=A.length;i<l;i++){o=A[i];if(o instanceof E){s=o.getId();}else if(typeof o==="object"){s=o.id;}else if(typeof o==="string"){s=o;}if(this.getChildPopups().indexOf(s)===-1){this.addChildPopup(s);g={id:s};if(o instanceof E){f=e(o);o.addEventDelegate(f,this);g.delegate=f;}this._aAutoCloseAreas.push(g);}}return this;};
P.prototype.setAnimations=function(o,f){if(o&&(typeof(o)=="function")){this._animations.open=o;}if(f&&(typeof(f)=="function")){this._animations.close=f;}return this;};
P.prototype.setDurations=function(o,i){if((o>0)||(o===0)){this._durations.open=o;}if((i>0)||(i===0)){this._durations.close=i;}return this;};
P.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";
P.prototype._fnCloseOnScroll=function(e){this.close();};
P.prototype.setFollowOf=function(f){P.DockTrigger.removeListener(P.checkDocking,this);var u=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof(f)==="function"){this._followOfHandler=f;u=true;}else if(typeof(f)==="boolean"){u=f;}else if(f===P.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;u=true;}else{this._bFollowOf=false;if(f!==null){q.sap.log.error("Trying to set an invalid type to 'followOf: "+f);}}if(u&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of);}if(this._bFollowOf&&this.getOpenState()===d.OPEN){P.DockTrigger.addListener(P.checkDocking,this);}};
P.prototype.getAutoClose=function(){return this._bAutoClose;};
P.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof(this._followOfHandler)==="function"?this._followOfHandler:true;}return false;};
P.prototype.isOpen=function(){return this.bOpen;};
P.prototype.getOpenState=function(){return this.eOpenState;};
P.prototype.destroy=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null);}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._iTopShieldRemoveTimer){q.sap.clearDelayedCall(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}if(this._iBottomShieldRemoveTimer){q.sap.clearDelayedCall(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}if(this._aAutoCloseAreas){var e;this._aAutoCloseAreas.forEach(function(A){if(A.delegate){e=q.sap.byId(A.id).control(0);if(e){e.removeEventDelegate(A.delegate);}}});}M.prototype.destroy.apply(this,arguments);};
P.prototype.exit=function(){delete this._mEvents;};
P.prototype._addFocusEventListeners=function(s,e,o){if(!this.fEventHandler){this.fEventHandler=q.proxy(this.onFocusEvent,this);}var p=this._$();var f=this.getChildPopups();var g={};var i=0,l=0;if(p.length){if(document.addEventListener&&!D.browser.msie){document.addEventListener("focus",this.fEventHandler,true);p.get(0).addEventListener("blur",this.fEventHandler,true);for(i=0,l=f.length;i<l;i++){g=q.sap.domById(f[i]);if(g){g.addEventListener("blur",this.fEventHandler,true);}}}else{q(document).bind("activate."+this._popupUID,this.fEventHandler);p.bind("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=f.length;i<l;i++){g=q.sap.domById(f[i]);if(g){q(g).bind("deactivate."+this._popupUID,this.fEventHandler);}}}}};
P.prototype._removeFocusEventListeners=function(s,e,o){var p=this._$(false,true);if(!p.length){return;}var f=this.getChildPopups();var g={};var i=0,l=0;if(document.removeEventListener&&!D.browser.msie){document.removeEventListener("focus",this.fEventHandler,true);p.get(0).removeEventListener("blur",this.fEventHandler,true);for(i=0,l=f.length;i<l;i++){g=q.sap.domById(f[i]);if(g){g.removeEventListener("blur",this.fEventHandler,true);}this.closePopup(f[i]);}}else{q(document).unbind("activate."+this._popupUID,this.fEventHandler);p.unbind("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=f.length;i<l;i++){g=q.sap.domById(f[i]);if(g){q(g).unbind("deactivate."+this._popupUID,this.fEventHandler);}}}this.fEventHandler=null;};
P.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}};
P.prototype._deactivateFocusHandle=function(){if(this.fEventHandler){this._removeFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).off("touchstart mousedown",this._fAutoCloseHandler);}};
P.prototype._registerEventBusEvents=function(s,e,o){var t=this;q.each(t._mEvents,function(f,l){sap.ui.getCore().getEventBus().subscribe("sap.ui",f,l,t);});this._bEventBusEventsRegistered=true;};
P.prototype._unregisterEventBusEvents=function(s,e,o){var t=this;q.each(t._mEvents,function(f,l){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",f,l,t);});delete this._bEventBusEventsRegistered;};
P.prototype._addFocusableArea=function(s,e,o){if(this.getChildPopups().indexOf(o.id)===-1){this.addChildPopup(o.id);}};
P.prototype._removeFocusableArea=function(s,e,o){this.removeChildPopup(o.id);};
P.prototype._closePopup=function(s,e,o){this.close(typeof this._durations.close==="string"?0:this._durations.close);};
P.prototype._setIdentity=function($){if(typeof $==="object"){$.attr("data-sap-ui-popup",this._popupUID);}else{q.sap.log.warning("Incorrect DomRef-type for 'setIdentity': "+$,this);return;}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents();}};
P.prototype._$=function(f,g){var $;if(this.oContent instanceof C){$=this.oContent.$();if(f||($.length===0&&!g)){q.sap.log.info("Rendering of popup content: "+this.oContent.getId());if($.length>0){R.preserveContent($[0],true,false);}sap.ui.getCore().getRenderManager().render(this.oContent,sap.ui.getCore().getStaticAreaRef());$=this.oContent.$();}}else if(this.oContent instanceof E){$=this.oContent.$();}else{$=q(this.oContent);}this._setIdentity($);return $;};
P.prototype._showBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),s="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:"");if($.length===0){$=q('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+s+'"></div>');$.appendTo(sap.ui.getCore().getStaticAreaRef());}else{$.removeClass().addClass(s);}P.blStack.push({zIndex:this._iZIndex-2,popup:this});$.css({"z-index":this._iZIndex-2,"visibility":"visible"}).show();q("html").addClass("sapUiBLyBack");};
P.prototype._hideBlockLayer=function(){P.blStack.pop();var $=q("#sap-ui-blocklayer-popup");if($.length){var o=$.get(0);if(P.blStack.length>0){o.style.zIndex=P.blStack[P.blStack.length-1].zIndex;o.style.visibility="visible";o.style.display="block";}else{o.style.visibility="hidden";o.style.display="none";window.requestAnimationFrame(function(){q("html").removeClass("sapUiBLyBack");});}}};
P.prototype._isFocusInsidePopup=function(){var o=this._$(false).get(0);if(o&&q.sap.containsOrEquals(o,document.activeElement)){return true;}return false;};
P.DockTrigger=new I(200);
P.checkDocking=function(){if(this.getOpenState()===d.OPEN){var o=this._getOfDom(this._oLastPosition.of),e=q(o).rect();if(!e){this.close();return;}else if(e.left===0&&e.top===0&&e.height===0&&e.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=q.sap.domById(this._oLastPosition.of.id);o=this._getOfDom(this._oLastPosition.of);e=q(o).rect();if(!e){this.close();return;}}if(!q.sap.containsOrEquals(document.documentElement,o)){if(o.id&&o.id!==""){var n=q.sap.domById(o.id);var N=q(n).rect();if(N&&!r(e,N)){e=N;delete this._oLastPosition.of;this._oLastPosition.of=n;}}}if(this._oLastOfRect){if(!r(this._oLastOfRect,e)){if(this._followOfHandler){var l=q.extend(true,{},this._oLastPosition),L=q.extend(true,{},this._oLastOfRect);this._followOfHandler({lastPosition:l,lastOfRect:L,currentOfRect:e});}else{this._applyPosition(this._oLastPosition);}}}}};
P.prototype.ontouchstart=function(e){this.onmousedown(e,true);this._bMousedownCalled=true;};
P.prototype.onmousedown=function(e,s){if(this._bMousedownCalled&&!s){this._bMousedownCalled=false;return;}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return;}this._increaseMyZIndex("","mousedown",e);};
P.prototype._increaseMyZIndex=function(s,e,o){var p=this.getParentPopup(this._oLastPosition.of);if(o&&o.type==="mousedown"||o&&o.isFromParentPopup||p.length===0){this._iZIndex=this.getNextZIndex();var $=this._$(false,true);$.css("z-index",this._iZIndex);if(this._oBlindLayer){this._oBlindLayer.update($,this._iZIndex-1);}if(o&&!o.type||o&&o.type!="mousedown"||e==="mousedown"){var f=this.getChildPopups();for(var i=0,l=f.length;i<l;i++){this.increaseZIndex(f[i],true);}}}else if(p.length>0){var g=q(p.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(g,false);}};
P.prototype.onAfterRendering=function(e){var o=this.getContent();var $=o instanceof E?o.$():q(o);$.toggleClass("sapUiShd",this._bShadow);$.css("position","absolute");this._setIdentity($);var f=$[0];var l=f.style.left;var g=f.style.right;var t=f.style.top;var h=f.style.bottom;if(!(l&&l!="auto"||g&&g!="auto"||t&&t!="auto"||h&&h!="auto")){q.sap.log.debug("reposition popup content "+$.attr("id")+" at "+(window.JSON?JSON.stringify(this._oLastPosition.at):String(this._oLastPosition.at)));this._applyPosition(this._oLastPosition);}$.show().css({"visibility":"visible","z-index":this._iZIndex});if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};
P.prototype.onBeforeRendering=function(e){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);};
P.prototype.onresize=function(e){if(this.eOpenState!=d.CLOSED&&this._oBlindLayer){var t=this;setTimeout(function(){t._updateBlindLayer();},0);}};
P.prototype._updateBlindLayer=function(){if(this.eOpenState!=d.CLOSED&&this._oBlindLayer){this._oBlindLayer.update(this._$(false,true));}};
P.prototype.isInPopup=function(t){var p=this.getParentPopup(t);return p&&p.length>0;};
P.prototype.getParentPopup=function(t){var T=t?t:this;var $=q(T instanceof E?T.getDomRef():T);return $.closest("[data-sap-ui-popup]");};
P.prototype.getParentPopupId=function(t){var p=this.getParentPopup(t);return p.attr("data-sap-ui-popup");};
P.prototype.addChildToPopup=function(p,s){var e="sap.ui.core.Popup.addFocusableContent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{id:s});};
P.prototype.removeChildFromPopup=function(p,s){var e="sap.ui.core.Popup.removeFocusableContent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{id:s});};
P.prototype.closePopup=function(p){var e="sap.ui.core.Popup.closePopup-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e);};
P.prototype.increaseZIndex=function(p,i){var e="sap.ui.core.Popup.increaseZIndex-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{isFromParentPopup:i?i:false});};
P.prototype.focusTabChain=function(p){var s=p.event.target,n=p.that.getMetadata().getName(),f;if((!p.$FocusablesContent||!p.$FocusablesFooter)||(!p.$FocusablesContent.length&&!p.$FocusablesFooter.length)){return;}if(s.id===p.firstFocusable){q.sap.log.debug("First dummy focus element was focused","",n);if(p.$FocusablesFooter.length>0){q.sap.log.debug("Last footer element will be focused","",n);f=p.$FocusablesFooter[p.$FocusablesFooter.length-1];}else{q.sap.log.debug("Last content element will be focused","",n);f=p.$FocusablesContent[p.$FocusablesContent.length-1];}}else if(s.id===p.lastFocusable){q.sap.log.debug("Last dummy focus element was focues","",n);if(p.$FocusablesContent.length>0){q.sap.log.debug("First content element will be focused","",n);f=p.$FocusablesContent[0];}else{q.sap.log.debug("First footer element will be focused","",n);f=p.$FocusablesFooter[0];}}if(f){q.sap.delayedCall(0,this,function(){var o=sap.ui.getCore().byId(f.id);if(o instanceof C){q.sap.log.debug("Focus will be handled by "+o.getMetadata().getName(),"",n);}else{q.sap.log.debug("oFocusDomRef will be focused","",n);}q.sap.focus(o?o:f);return o?o.getId():f.id;});}};
return P;});
sap.ui.predefine('sap/ui/core/ScrollBar',['jquery.sap.global','sap/ui/Device','./Control','./library',"./ScrollBarRenderer",'jquery.sap.script','jquery.sap.trace'],function(q,D,C,l,S){"use strict";var a=l.ScrollBarAction;
var b=C.extend("sap.ui.core.ScrollBar",{metadata:{library:"sap.ui.core",properties:{vertical:{type:"boolean",group:"Behavior",defaultValue:true},scrollPosition:{type:"int",group:"Behavior",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},steps:{type:"int",group:"Dimension",defaultValue:null}},events:{scroll:{parameters:{action:{type:"sap.ui.core.ScrollBarAction"},forward:{type:"boolean"},newScrollPos:{type:"int"},oldScrollPos:{type:"int"}}}}}});
b.prototype.init=function(){this._$ScrollDomRef=null;this._iOldScrollPos=0;this._iOldStep=0;this._bScrollPosIsChecked=false;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._bSuppressScroll=false;this._iMaxContentDivSize=1000000;if(q.sap.touchEventMode==="ON"){sap.ui.requireSync("sap/ui/thirdparty/zyngascroll");this._iLastTouchScrollerPosition=null;this._iTouchStepTreshold=24;this._bSkipTouchHandling=false;this._oTouchScroller=new window.Scroller(q.proxy(this._handleTouchScroll,this),{bouncing:false});}};
b.prototype.onBeforeRendering=function(){this.$("sb").unbind("scroll",this.onscroll);};
b.prototype.onAfterRendering=function(){this._iSteps=this.getSteps();var c=this.getContentSize();this._bStepMode=!c;var s=this.getSize();if(q.sap.endsWith(s,"px")){s=s.substr(0,s.length-2);}else{s=this.getVertical()?this.$().height():this.$().width();}var d=null;var $=this.$("ffsize");if(D.browser.firefox){d=$.outerHeight();if(d===0){d=window.getComputedStyle(q("body").get(0))["font-size"];if(q.sap.endsWith(d,"px")){d=d.substr(0,d.length-2);}d=parseInt(d,10);}}$.remove();if(D.browser.webkit){if(!document.width){d=Math.round(40/(window.outerWidth/q(document).width()));}else{d=Math.round(40/(document.width/q(document).width()));}}if(this.getVertical()){if(D.browser.firefox){this._iFactor=d;}else if(D.browser.webkit){this._iFactor=d;}else{this._iFactor=Math.floor(s*0.125);}this._iFactorPage=D.browser.firefox?s-d:Math.floor(s*0.875);}else{if(D.browser.firefox){this._iFactor=10;this._iFactorPage=Math.floor(s*0.8);}else if(D.browser.webkit){this._iFactor=d;this._iFactorPage=Math.floor(s*0.875);}else{this._iFactor=7;this._iFactorPage=s-14;}}this._$ScrollDomRef=this.$("sb");if(this._bStepMode){if(this.getVertical()){var i=this._iSteps*this._iFactor;if(i>this._iMaxContentDivSize){this._iFactor=this._iFactor/(i/this._iMaxContentDivSize);}var e=this._$ScrollDomRef.height()+Math.ceil(this._iSteps*this._iFactor);this._$ScrollDomRef.find("div").height(e);}else{var e=this._$ScrollDomRef.width()+this._iSteps*this._iFactor;this._$ScrollDomRef.find("div").width(e);}}this.setCheckedScrollPosition(this.getScrollPosition()?this.getScrollPosition():0,true);this._$ScrollDomRef.bind("scroll",q.proxy(this.onscroll,this));if(q.sap.touchEventMode==="ON"){this._bSkipTouchHandling=true;var o={width:0,height:0};o[this.getVertical()?"height":"width"]=this._bStepMode?(this.getSteps()*this._iTouchStepTreshold):parseInt(this.getContentSize(),10);this._oTouchScroller.setDimensions(0,0,o.width,o.height);var E=this._$ScrollDomRef.get(0);if(E){var r=E.getBoundingClientRect();this._oTouchScroller.setPosition(r.left+E.clientLeft,r.top+E.clientTop);this._bSkipTouchHandling=false;}}};
b.prototype.onmousewheel=function(e){if(this.$().is(":visible")){var o=e.originalEvent;var w=o.detail?o.detail:o.wheelDelta*(-1)/40;var f=w>0?true:false;if(q.sap.containsOrEquals(this._$ScrollDomRef[0],e.target)){this._doScroll(a.MouseWheel,f);}else{this._bMouseWheel=true;var p=null;if(this._bStepMode){p=w+this._iOldStep;}else{p=w*this._iFactor+this._iOldScrollPos;}this.setCheckedScrollPosition(p,true);}e.preventDefault();e.stopPropagation();return false;}};
b.prototype.ontouchstart=function(e){var t=e.touches;var f=t[0];if(f&&f.target&&f.target.tagName.match(/input|textarea|select/i)){return;}if(this._oTouchScroller){this._oTouchScroller.doTouchStart(t,e.timeStamp);}if(t.length==1){e.preventDefault();}};
b.prototype.ontouchmove=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchMove(e.touches,e.timeStamp,e.scale);}};
b.prototype.ontouchend=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};
b.prototype.ontouchcancel=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};
b.prototype.onscroll=function(e){if(this._bSuppressScroll){this._bSuppressScroll=false;e.preventDefault();e.stopPropagation();return false;}var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}var d=s-this._iOldScrollPos;var f=d>0?true:false;if(d<0){d=d*(-1);}var c=a.Drag;if(d==this._iFactor){c=a.Step;}else if(d==this._iFactorPage){c=a.Page;}else if(this._bMouseWheel){c=a.MouseWheel;}if(this._bLargeDataScrolling&&c===a.Drag){this._eAction=c;this._bForward=f;if(D.browser.msie){if(this._scrollTimeout){window.clearTimeout(this._scrollTimeout);}this._scrollTimeout=window.setTimeout(this._onScrollTimeout.bind(this),300);}}else{this._doScroll(c,f);}e.preventDefault();e.stopPropagation();return false;};
b.prototype._onScrollTimeout=function(){this._scrollTimeout=undefined;this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;};
b.prototype.onmouseup=function(){if(this._bLargeDataScrolling&&(this._eAction||this._bForward||this._bTouchScroll)&&!D.browser.msie){this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;}};
b.prototype.ontouchend=b.prototype.onmouseup;
b.prototype._handleTouchScroll=function(L,t,z){if(this._bSkipTouchHandling){return;}var v=this.getVertical()?t:L;var p;if(this._bStepMode){p=Math.max(Math.round(v/this._iTouchStepTreshold),0);}else{p=Math.round(v);}if(this._iLastTouchScrollerPosition!==p){this._iLastTouchScrollerPosition=p;this.setCheckedScrollPosition(p,true);if(this._bLargeDataScrolling){this._bTouchScroll=true;}else{this.fireScroll();}}};
b.prototype.unbind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.unbind(D.browser.firefox?"DOMMouseScroll":"mousewheel",this.onmousewheel);}if(q.sap.touchEventMode==="ON"){this._$OwnerDomRef.unbind(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchcancel"),q.proxy(this.ontouchcancel,this));}}};
b.prototype.bind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.bind(D.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this.onmousewheel,this));}if(q.sap.touchEventMode==="ON"){this._$OwnerDomRef.bind(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchcancel"),q.proxy(this.ontouchcancel,this));}}};
b.prototype._getTouchEventType=function(t){return q.sap.touchEventMode==="SIM"?("sap"+t):t;};
b.prototype.pageUp=function(){this._doScroll(a.Page,false);};
b.prototype.pageDown=function(){this._doScroll(a.Page,true);};
b.prototype.setScrollPosition=function(s){if(this._$ScrollDomRef){this.setCheckedScrollPosition(s,true);}else{this.setProperty("scrollPosition",s);}return this;};
b.prototype.setCheckedScrollPosition=function(s,c){var i=Math.max(s,0);if(this._bStepMode===undefined){this._bStepMode=!this.getContentSize();}var d=i;if(this._bStepMode){i=Math.min(i,this.getSteps());d=i*this._iFactor;}i=Math.round(i);this._bSuppressScroll=!c;this.setProperty("scrollPosition",i,true);if(this.getVertical()){this._$ScrollDomRef.scrollTop(d);}else{if(D.browser.firefox&&this._bRTL){this._$ScrollDomRef.scrollLeft(-d);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);this._$ScrollDomRef.scrollLeft(o.scrollWidth-o.clientWidth-d);}else{this._$ScrollDomRef.scrollLeft(d);}}if(q.sap.touchEventMode==="ON"){var v=i;if(this._bStepMode){v=Math.round(i*this._iTouchStepTreshold);}this._oTouchScroller.__scrollTop=this.getVertical()?v:0;this._oTouchScroller.__scrollLeft=this.getVertical()?0:v;}};
b.prototype.setContentSize=function(c){this.setProperty("contentSize",c,true);this._bStepMode=false;var s=this.$("sbcnt");if(s){if(this.getVertical()){s.height(c);}else{s.width(c);}}return this;};
b.prototype._doScroll=function(A,f){var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}if(this._bStepMode){var i=Math.round(s/this._iFactor);var O=this._iOldStep;if(O!==i){this.setCheckedScrollPosition(i,false);q.sap.log.debug("-----STEPMODE-----: New Step: "+i+" --- Old Step: "+O+" --- Scroll Pos in px: "+s+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:i,oldScrollPos:O});this._iOldStep=i;}}else{s=Math.round(s);this.setProperty("scrollPosition",s,true);q.sap.log.debug("-----PIXELMODE-----: New ScrollPos: "+s+" --- Old ScrollPos: "+this._iOldScrollPos+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:s,oldScrollPos:this._iOldScrollPos});}if(Math.round(this._iFactor)==this._iFactor||!D.browser.msie){this._bSuppressScroll=false;}this._iOldScrollPos=s;this._bMouseWheel=false;q.sap.interaction.notifyScrollEvent({type:A});};
b.prototype.onThemeChanged=function(){this.rerender();};
b.prototype.getNativeScrollPosition=function(){if(this._$ScrollDomRef){if(this.getVertical()){return Math.round(this._$ScrollDomRef.scrollTop());}else{return Math.round(this._$ScrollDomRef.scrollLeft());}}return 0;};
b.prototype.setNativeScrollPosition=function(n){var s=Math.round(n);if(this._$ScrollDomRef){if(this.getVertical()){this._$ScrollDomRef.scrollTop(s);}else{this._$ScrollDomRef.scrollLeft(s);}}};
return b;});
sap.ui.predefine('sap/ui/core/ScrollBarRenderer',['jquery.sap.global','sap/ui/Device'],function(q,D){"use strict";var S={};
S.render=function(r,s){var a=r;var R=sap.ui.getCore().getConfiguration().getRTL();a.addClass("sapUiScrollBar");var b;if(D.support.touch){b="sapUiScrollBarTouch";a.addClass(b);}var v=s.getVertical();var c=s.getSize();var C=s.getContentSize();var B=q.sap.scrollbarSize(b);var w=B.width;var h=B.height;if(D.browser.edge){if(!w){w="15";}if(!h){h="15";}}if(v){a.write("<div");a.writeControlData(s);a.write(" style=\"overflow:hidden;width:"+w+"px");if(c){a.write(";height:"+c);}a.write("\"");a.writeClasses();a.write(">");a.write("<div ");a.writeAttribute("id",s.getId()+"-sb");a.write(" style=\"width:"+w*2+"px;height:100%;overflow-y:scroll;overflow-x:hidden");if(R){a.write(";margin-right:-"+w+"px");}else{a.write(";margin-left:-"+w+"px;");}a.write("\">");a.write("<div");a.writeAttribute("id",s.getId()+"-sbcnt");a.write(" style=\"width:"+w+"px");if(C){a.write(";height:"+C);}a.write("\"");a.write(">");a.write("</div>");a.write("</div>");a.write("<div> <span id="+s.getId()+"-ffsize"+" style='position: absolute; top: -9000px; left: -9000px; visibility: hidden; line-height: normal;'> FF Size</span></div>");a.write("</div>");}else{a.write("<div");a.writeControlData(s);a.write(" style=\"overflow:hidden;height:"+h+"px");if(c){a.write(";width:"+c);}a.write("\"");a.writeClasses();a.write(">");a.write("<div ");a.writeAttribute("id",s.getId()+"-sb");a.write(" style=\"height:"+h*2+"px;margin-top:-"+h+"px;overflow-x:scroll;overflow-y:hidden\">");a.write("<div");a.writeAttribute("id",s.getId()+"-sbcnt");a.write(" style=\"height:"+h+"px");if(C){a.write(";width:"+C);}a.write("\"");a.write(">");a.write("</div>");a.write("</div>");a.write("</div>");}};
return S;},true);
sap.ui.predefine('sap/ui/core/SeparatorItem',['./Item','./library'],function(I,l){"use strict";
var S=I.extend("sap.ui.core.SeparatorItem",{metadata:{library:"sap.ui.core"}});
return S;});
sap.ui.predefine('sap/ui/core/StashedControlSupport',['jquery.sap.global','sap/ui/core/Element'],function(q,E){"use strict";var S={},s={},a=E.extend("sap.ui.core._StashedControl",{constructor:function(i,b){E.apply(this,arguments);b.stashed=true;q.sap.extend(this,b);this._stash(b.sParentId,b.sParentAggregationName);return this;},metadata:{specialSettings:{stashed:{type:'boolean',visibility:'hidden'},sParentId:{type:'string',visibility:'hidden'},sParentAggregationName:{type:'string',visibility:'hidden'},fnCreate:{type:'function',visibility:'hidden'}}}});
a.prototype.setParent=function(){q.sap.log.error("Cannot set parent on a StashedControl",this.getId());};
a.prototype.clone=function(){var c=E.prototype.clone.apply(this,arguments);s[c.getId()]=c;return c;};
a.prototype.destroy=function(){delete s[this.getId()];E.prototype.destroy.apply(this,arguments);};
m(a,true);
S.mixInto=function(c,d){m(c,d);};
function m(c,d){c.getMetadata().addSpecialSetting("stashed",{type:"boolean",defaultValue:!!d});c.prototype.setStashed=function(b){if(this.stashed===true&&!b){if(this.sParentId){var C=u(this,sap.ui.getCore().byId(this.sParentId));C.stashed=false;return;}}else if(b){q.sap.log.warning("Cannot re-stash a control",this.getId());}};c.prototype.getStashed=function(){return this.stashed;};var D=c.prototype.destroy;c.prototype.destroy=function(){delete s[this.getId()];D.apply(this,arguments);};c.prototype._stash=function(p,P){this.sParentId=p;this.sParentAggregationName=P;s[this.getId()]=this;};}
function u(C,p){if(C instanceof a){var b,d,o,f=C.fnCreate,P=C.sParentAggregationName;C.destroy();d=sap.ui.require("sap/ui/core/Component");o=d&&d.getOwnerComponentFor(p);if(o){b=o.runAsOwner(f);}else{b=f();}b.forEach(function(c){p.getMetadata().getAggregation(P).add(p,c);});}delete s[C.getId()];return C;}
function g(A,p){var b=[];for(var i in s){var I=A?s[i]:s[i].getId();if(!p||s[i].sParentId===p){b.push(I);}}return b;}
S.getStashedControlIds=function(p){return g(false,p);};
S.getStashedControls=function(p){return g(true,p);};
S.createStashedControl=function(i,b){return new a(i,b);};
return S;});
sap.ui.predefine('sap/ui/core/Title',['./Element','./library'],function(E,l){"use strict";var T=l.TitleLevel;
var a=E.extend("sap.ui.core.Title",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},level:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},emphasized:{type:"boolean",group:"Appearance",defaultValue:false}}}});
return a;});
sap.ui.predefine('sap/ui/core/TooltipBase',['jquery.sap.global','./Control','./Popup','./library','jquery.sap.keycodes'],function(q,C,P,l){"use strict";var O=l.OpenState;
var T=C.extend("sap.ui.core.TooltipBase",{metadata:{"abstract":true,library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},openDuration:{type:"int",group:"Behavior",defaultValue:200},closeDuration:{type:"int",group:"Behavior",defaultValue:200},myPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:'begin top'},atPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:'begin bottom'},offset:{type:"string",group:"Behavior",defaultValue:'10 3'},collision:{type:"sap.ui.core.Collision",group:"Behavior",defaultValue:'flip'},openDelay:{type:"int",group:"Misc",defaultValue:500},closeDelay:{type:"int",group:"Misc",defaultValue:100}},events:{closed:{}}}});
T.prototype._getPopup=q.sap.getter((function(){var p=new P();p.setShadow(true);return p;}()));
T.prototype.onfocusin=function(e){var s=q(e.target).control(0);if(s!=null){var d=s.getFocusDomRef();this.sStoredTooltip=null;if(d.title&&d.title!=""){this.sStoredTooltip=d.title;d.title="";}var p=this._getPopup();if(!(p.isOpen()&&p.getContent()==this)){sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);}var v=d.getAttribute("aria-describedby");var i=this.getId()+"-title "+this.getId()+"-txt";if(v==null||v==""){d.setAttribute("aria-describedby",i);}else if(v.indexOf(i)==-1){d.setAttribute("aria-describedby",v+" "+i);}}};
T.prototype.onfocusout=function(e){var s=q(e.target).control(0);if(s!=null){var d=s.getFocusDomRef();if(this.sStoredTooltip){d.title=this.sStoredTooltip;}var v=d.getAttribute("aria-describedby");var i=this.getId()+"-title "+this.getId()+"-txt";if(v&&v.indexOf(i)>=0){if(v.trim()==i){d.removeAttribute("aria-describedby");}else{v=v.replace(i,"");d.setAttribute("aria-describedby",v);}}}if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}this.sCloseNowTimeout=q.sap.delayedCall(this.getCloseDelay(),this,"closePopup");};
T.prototype.isStandardTooltip=function(t){return typeof t==="string"&&!!t.trim();};
T.prototype.onmouseover=function(e){var E=q(e.target).control(0),c=q(e.currentTarget).control(0),L=q(e.relatedTarget).control(0);if(!E){return;}if(E===this){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}e.stopPropagation();e.preventDefault();return;}if(c===E||!this.isStandardTooltip(E.getTooltip())){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;e.stopPropagation();e.preventDefault();}}if(L){if(L.getParent()){if(L.getParent()===c&&c===E){var o=L.getTooltip();if(!this.isStandardTooltip(o)&&(!o||!(o instanceof T))){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;e.stopPropagation();e.preventDefault();}}}}}if(this._currentControl===E||!this.isStandardTooltip(E.getTooltip())){this.removeStandardTooltips();if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);}T.sOpenTimeout=q.sap.delayedCall(this.getOpenDelay(),this,"openPopup",[this._currentControl]);e.stopPropagation();e.preventDefault();}};
T.prototype.onmouseout=function(e){if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}if(!this.sCloseNowTimeout){this.sCloseNowTimeout=q.sap.delayedCall(this.getCloseDelay(),this,"closePopup");}this.restoreStandardTooltips();e.stopPropagation();e.preventDefault();};
T.prototype.closePopup=function(){var p=this._getPopup();if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);}this.sCloseNowTimeout=undefined;p.attachClosed(this.handleClosed,this);p.close();this.restoreStandardTooltips();};
T.prototype.handleClosed=function(){this._getPopup().detachClosed(this.handleClosed,this);this.fireClosed();};
T.prototype.openPopup=function(s){if(!this.getVisible()){return;}if(s.getTooltip()!=null){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;return;}var p=this._getPopup();if(p.isOpen()&&p.getContent()==this){return;}sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);var d=s.getDomRef();p.setContent(this);p.setPosition(this.getMyPosition(),this.getAtPosition(),d,this.getOffset(),this.getCollision());p.setDurations(this.getOpenDuration(),this.getCloseDuration());p.open();this.removeStandardTooltips();}};
T.prototype.removeStandardTooltips=function(){var d=this._currentControl.getDomRef();if(!this.aStoredTooltips){this.aStoredTooltips=[];}else{return;}var t="";while(d&&!(d===document)){t=d.title;if(t){this.aStoredTooltips.push({domref:d,tooltip:t});d.title="";}d=d.parentNode;}if(this._currentControl.getTooltipDomRefs){var D=this._currentControl.getTooltipDomRefs();for(var i=0;i<D.length;i++){d=D[i];if(d){t=d.title;if(t){this.aStoredTooltips.push({domref:d,tooltip:t});d.title="";}}}}};
T.prototype.restoreStandardTooltips=function(){var p=this._getPopup();var e=p.getOpenState();if(e===O.OPEN||e===O.OPENING){return;}if(T.sOpenTimeout){return;}if(this.aStoredTooltips){for(var i=0;i<this.aStoredTooltips.length;i++){var d=this.aStoredTooltips[i].domref;d.title=this.aStoredTooltips[i].tooltip;}}this.aStoredTooltips=null;};
T.prototype._setParent=T.prototype.setParent;
T.prototype.setParent=function(p,a){var _=this._getPopup();if(_&&_.isOpen()){this.closePopup();}this._setParent.apply(this,arguments);};
T.prototype.onkeydown=function(e){if(e.ctrlKey&&e.which==q.sap.KeyCodes.I){var E=q(e.target).control(0);if(E!=null){if(this._currentControl===E||!this.isStandardTooltip(E.getTooltip())){this.removeStandardTooltips();this.openPopup(this._currentControl);e.preventDefault();e.stopPropagation();}}}else if(e.which==q.sap.KeyCodes.ESCAPE){if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}var w=this.oPopup&&this.oPopup.isOpen();this.closePopup();if(w){e.preventDefault();e.stopPropagation();}}};
T.prototype._closeOrPreventOpen=function(){var p=this._getPopup();if(p.isOpen()){this.closePopup();}else if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}};
return T;});
sap.ui.predefine('sap/ui/core/UIComponent',['jquery.sap.global','../base/ManagedObject','./Component','./library','./UIComponentMetadata','./mvc/Controller','./mvc/View'],function(q,M,C,l,U,a,V){"use strict";var b=l.mvc.ViewType;
var c=C.extend("sap.ui.core.UIComponent",{
constructor:function(i,s){var d=false;try{C.apply(this,arguments);d=true;}finally{if(!d){this._destroyCreatedInstances();}}},
metadata:{"abstract":true,rootView:null,publicMethods:["render"],aggregations:{"rootControl":{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},designtime:"sap/ui/core/designtime/UIComponent.designtime",routing:{}}
},U);
c._fnOnInstanceInitialized=null;c._fnOnInstanceDestroy=null;
c.prototype.init=function(){var t=this;var p={};if(this.getAutoPrefixId()){p.id=function(i){return t.createId(i);};}var r=this._getManifestEntry("/sap.ui5/routing",true)||{},R=r.config||{},v=r.routes;if(v){var d=sap.ui.requireSync("sap/ui/core/routing/Router");var f=g(this._getRouterClassName()||d);this._oRouter=new f(v,R,this,r.targets);this._oTargets=this._oRouter.getTargets();this._oViews=this._oRouter.getViews();}else if(r.targets){var T=sap.ui.requireSync("sap/ui/core/routing/Targets");var e=sap.ui.requireSync("sap/ui/core/routing/Views");this._oViews=new e({component:this});var h=g(R.targetsClass||T);this._oTargets=new h({targets:r.targets,config:R,views:this._oViews});}this.runAsOwner(function(){M.runWithPreprocessors(function(){t.setAggregation("rootControl",t.createContent());},p);});var o=this.getRootControl();if(o instanceof V){if(R.targetParent===undefined){R.targetParent=o.getId();}if(this._oTargets){this._oTargets._setRootViewId(o.getId());}}if(typeof c._fnOnInstanceInitialized==="function"){c._fnOnInstanceInitialized(this);}};
function g(r){var f;if(typeof r==="string"){f=q.sap.getObject(r);if(!f){q.sap.log.error("The specified class for router or targets '"+r+"' is undefined.",this);}}else{f=r;}return f;}
c.prototype.destroy=function(){if(typeof c._fnOnInstanceDestroy==="function"){c._fnOnInstanceDestroy(this);}this._destroyCreatedInstances();C.prototype.destroy.apply(this,arguments);};
c.prototype._destroyCreatedInstances=function(){if(this._oRouter){this._oRouter.destroy();delete this._oRouter;}if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}if(this._oViews){this._oViews.destroy();this._oViews=null;}};
c.getRouterFor=function(o){var v=o;if(v instanceof a){v=v.getView();}if(v instanceof V){var d=C.getOwnerComponentFor(v);if(d){return d.getRouter();}else{return undefined;}}};
c.prototype.getRouter=function(){return this._oRouter;};
c.prototype.getTargets=function(){return this._oTargets;};
c.prototype.getAutoPrefixId=function(){return!!this.getManifestObject().getEntry("/sap.ui5/autoPrefixId");};
c.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};
c.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"---"+i;}return i;};
c.prototype.getLocalId=function(i){var p=this.getId()+"---";return(i&&i.indexOf(p)===0)?i.slice(p.length):null;};
c.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"---")===0);};
c.prototype.createContent=function(){var r=this._getManifestEntry("/sap.ui5/rootView",true);if(r&&typeof r==="string"){return sap.ui.view({viewName:r,type:b.XML});}else if(r&&typeof r==="object"){if(r.id){r.id=this.createId(r.id);}return sap.ui.view(r);}else if(r){throw new Error("Configuration option 'rootView' of component '"+this.getMetadata().getName()+"' is invalid! 'rootView' must be type of string or object!");}return null;};
c.prototype.getRootControl=function(){return this.getAggregation("rootControl");};
c.prototype.render=function(r){var o=this.getRootControl();if(o&&r){r.renderControl(o);}};
c.prototype.getUIArea=function(){return(this.oContainer?this.oContainer.getUIArea():null);};
c.prototype.getEventingParent=function(){return this.getUIArea();};
c.prototype.setContainer=function(o){this.oContainer=o;if(o){this._applyContextualSettings(o._getContextualSettings());}else{this._oContextualSettings=M._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oContainer){this._propagateContextualSettings();}}.bind(this),0);}}return this;};
c.prototype.onBeforeRendering=function(){};
c.prototype.onAfterRendering=function(){};
c.prototype._getRouterClassName=function(){var r=this._getManifestEntry("/sap.ui5/routing",true)||{},R=r.config||{};return R.routerClass;};
return c;});
sap.ui.predefine('sap/ui/core/UIComponentMetadata',['./ComponentMetadata','./library'],function(C,l){"use strict";var V=l.mvc.ViewType;var U=function(c,o){C.apply(this,arguments);};U.prototype=Object.create(C.prototype);
U.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};
U.prototype.getRootView=function(d){return this.getManifestEntry("/sap.ui5/rootView",!d);};
U.prototype.getRoutingConfig=function(d){return this.getManifestEntry("/sap.ui5/routing/config",!d);};
U.prototype.getRoutes=function(d){return this.getManifestEntry("/sap.ui5/routing/routes",!d);};
U.prototype._convertLegacyMetadata=function(s,m){C.prototype._convertLegacyMetadata.call(this,s,m);var u=m["sap.ui5"];var r=u["rootView"]||s["rootView"];if(r){u["rootView"]=r;}var R=u["routing"]||s["routing"];if(R){u["routing"]=R;}if(u["rootView"]&&typeof u["rootView"]==="string"){u["rootView"]={viewName:u["rootView"],type:V.XML};}};
return U;},true);
sap.ui.predefine('sap/ui/core/ValueStateSupport',['jquery.sap.global','./Element','./library'],function(q,E,l){"use strict";var V=l.ValueState;var a={};var t=null;var e=function(){if(!t){t={};var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");t[V.Error]=r.getText("VALUE_STATE_ERROR");t[V.Warning]=r.getText("VALUE_STATE_WARNING");t[V.Success]=r.getText("VALUE_STATE_SUCCESS");}};
a.enrichTooltip=function(o,T){if(!T&&o.getTooltip()){return undefined;}var s=a.getAdditionalText(o);if(s){return(T?T+" - ":"")+s;}return T;};
a.getAdditionalText=function(v){var s=null;if(v&&v.getValueState){s=v.getValueState();}else if(V[v]){s=v;}if(s&&(s!=V.None)){e();return t[s];}return null;};
a.formatValueState=function(s){switch(s){case 1:return V.Warning;case 2:return V.Success;case 3:return V.Error;default:return V.None;}};
return a;},true);
sap.ui.predefine('sap/ui/core/VariantLayoutData',['./LayoutData','./library'],function(L,l){"use strict";
var V=L.extend("sap.ui.core.VariantLayoutData",{metadata:{library:"sap.ui.core",aggregations:{multipleLayoutData:{type:"sap.ui.core.LayoutData",multiple:true,singularName:"multipleLayoutData"}}}});
return V;});
sap.ui.predefine('sap/ui/core/XMLComposite',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/XMLCompositeMetadata','sap/ui/model/base/ManagedObjectModel','sap/ui/core/util/XMLPreprocessor','sap/ui/model/json/JSONModel','sap/ui/core/Fragment','sap/ui/base/ManagedObject','sap/ui/base/DataType','sap/ui/model/base/XMLNodeAttributesModel','sap/ui/core/util/reflection/XmlTreeModifier','sap/ui/model/resource/ResourceModel'],function(q,C,X,M,a,J,F,b,D,c,d,R){"use strict";var m={};
function e(s,o){if(!m[s]){q.sap.require(s);m[s]=q.sap.getObject(s);}return m[s];}
function p(T,v,n,o){var B=b.bindingParser(v,o,true);if(B&&typeof B==="object"){return B;}var V=v=B||v;var i=D.getType(T);if(i){if(i instanceof D){V=i.parseValue(v);}}else{throw new Error("Property "+n+" has unknown type "+T);}return typeof V==="string"?b.bindingParser.escape(V):V;}
function f(j,n,E,I,v){var A=new J(E),o=I.getMetadata(),r=o.getAllAggregations(),P=o.getAllProperties(),s=o._mAllSpecialSettings;A.getVisitor=function(){return v;};A._getObject=function(u,w){var x;u=this.resolve(u,w);u=u.substring(1);var y=u.split("/");if(u&&u.startsWith&&u.startsWith("metadataContexts")){return this._navInMetadataContexts(u);}if(P.hasOwnProperty(u)){var z=P[u];if(!E.hasAttribute(u)){return z.defaultValue;}x=v.getResult(E.getAttribute(u))||E.getAttribute(u);if(x){var S=p(z.type,x,u);if(typeof S==="object"&&S.path){return x;}return S;}return null;}else if(r.hasOwnProperty(y[0])){var B=r[y[0]];var G,H=d.getAggregation(E,y[0]);if(!H){return null;}if(B.multiple){var K=[];for(var i=0;i<H.length;i++){G=new c(H[i],v,"");K.push(G.getContext("/"));}x=K;}else{G=new c(H,v,"");x=G.getContext("/");}y.shift();return this._getNode(y,x);}else if(s.hasOwnProperty(u)){var L=s[u];if(!E.hasAttribute(u)){return L.defaultValue||null;}x=v.getResult(E.getAttribute(u));if(L.type){var S=p(L.type,x,u);if(typeof S==="object"&&S.path){return x;}return S;}if(x){return x;}return E.getAttribute(u);}};A._navInMetadataContexts=function(i){var u=i.replace("metadataContexts","");var w=u.split("/"),N=j["metadataContexts"].getObject();w.shift();return this._getNode(w,N);};A._getNode=function(i,N){var u=null,w;while(i.length>0&&N){if(N.getObject){u=N.getObject(i.join("/"));}if(!u){w=i.shift();N=N[w];}else{return u;}}return N;};A.getContextName=function(){return n;};j[n]=A.getContext("/");if(j["metadataContexts"]){j["metadataContexts"].oModel.setProperty("/"+n,j[n]);}}
function g(i,v,o,j,s){o.model=o.model||s;var K=o.name||o.model||undefined;if(j[K]){return;}try{i[K]=v.getContext(o.model+">"+o.path);j[K]=i[K];}catch(n){i["_$error"].oModel.setProperty("/"+K,n);}}
function h(i,v,s,n,o){if(!s&&!n){return;}var r=s?b.bindingParser(s):{parts:[]};var u=n?b.bindingParser(n):{parts:[]};if(!u.parts){u={parts:[u]};}if(!r.parts){r={parts:[r]};}q.merge(r.parts,u.parts);for(var j=0;j<r.parts.length;j++){g(i,v,r.parts[j],r,o);v=v["with"](i,false);}var w=new J(r);i["metadataContexts"]=w.getContext("/");}
function k(P){var s={};s.models=P.oModels||{};s.bindingContexts=P.oBindingContexts||{};return s;}
function t(P,o,i){var A=o._aggregationFragments,L=o.getLibraryName(),n;if(A){Object.keys(A).forEach(function(s){var r=o.getAggregation(s);if(!r){return true;}var u=P.getElementsByTagNameNS(L,s)[0];if(!u){u=document.createElementNS(L,s);P.appendChild(u);n=false;}else{n=true;}if(n&&!r.multiple){return true;}var v=A[s].cloneNode(true);i.visitChildNodes(v);for(var j=v.childElementCount;j>0;j--){u.appendChild(v.children[0]);}});}}
var l=C.extend("sap.ui.core.XMLComposite",{
metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%',invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},displayBlock:{type:"boolean",group:"Appearance",defaultValue:true,invalidate:true}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},
constructor:function(i,s){this._bIsCreating=true;C.apply(this,arguments);delete this._bIsCreating;},
renderer:function(r,o){r.write("<div");r.writeControlData(o);if(!o.getDisplayBlock()&&(o.getWidth()!=="100%"||o.getHeight()!=="100%")){r.addStyle("display","inline-block");}r.writeClasses();if(o.getHeight()){r.addStyle("height",o.getHeight());}if(o.getWidth()){r.addStyle("width",o.getWidth());}r.writeStyles();r.write(">");var i=o.getAggregation(o.getMetadata().getCompositeAggregationName());if(i){r.renderControl(i);}r.write("</div>");}
},X);
l.prototype.byId=function(i){return sap.ui.getCore().byId(F.createId(this.getId(),i));};
l.prototype._getManagedObjectModel=function(){if(!this._oManagedObjectModel){this._oManagedObjectModel=new M(this);}return this._oManagedObjectModel;};
l.prototype.getSuppressInvalidateAggregation=function(n,s){var o=this.getMetadata(),A=o.getAggregation(n)||o.getAllPrivateAggregations()[n];if(!A){return true;}s=o._suppressInvalidate(A,s);o._requestFragmentRetemplatingCheck(this,A);return s;};
l.prototype.setProperty=function(n,v,s){var o=this.getMetadata(),P=o.getProperty(n);if(!P){return this;}s=this.getMetadata()._suppressInvalidate(P,s);if(C.prototype.getProperty.apply(this,[n])!==v){o._requestFragmentRetemplatingCheck(this,P);}return C.prototype.setProperty.apply(this,[n,v,s]);};
l.prototype.bindAggregation=function(n,o){var i=this.getMetadata(),A=i.getAggregation(n)||i.getAllPrivateAggregations()[n],B=C.prototype.getBinding.apply(this,[n]);if(!B||(B&&B.getPath()!==o.path)){i._requestFragmentRetemplatingCheck(this,A);}return C.prototype.bindAggregation.apply(this,[n,o]);};
l.prototype.unbindAggregation=function(n){var o=this.getMetadata(),A=o.getAggregation(n)||o.getAllPrivateAggregations()[n];if(this.isBound(n)){o._requestFragmentRetemplatingCheck(this,A,true);}return C.prototype.unbindAggregation.apply(this,[n]);};
l.prototype.setAggregation=function(n,o,s){return C.prototype.setAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
l.prototype.addAggregation=function(n,o,s){return C.prototype.addAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
l.prototype.insertAggregation=function(n,o,i,s){return C.prototype.insertAggregation.apply(this,[n,o,i,this.getSuppressInvalidateAggregation(n,s)]);};
l.prototype.removeAggregation=function(n,o,s){return C.prototype.removeAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
l.prototype.removeAllAggregation=function(n,s){return C.prototype.removeAllAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
l.prototype.destroyAggregation=function(n,s){return C.prototype.destroyAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
l.prototype.updateAggregation=function(n,s){var A=this.getMetadata().getAggregation(n);if(A&&A.type==="TemplateMetadataContext"){this.invalidate();return;}C.prototype.updateAggregation.apply(this,arguments);};
l.prototype.setVisible=function(v){this.setProperty("visible",v);if(this.getParent()){this.getParent().invalidate();}return this;};
l.prototype._destroyCompositeAggregation=function(){var s=this.getMetadata().getCompositeAggregationName(),o=this.getAggregation(s);if(o){o.destroy();}return this;};
l.prototype.updateBindings=function(){if(this._bIsInitializing){return;}var r=C.prototype.updateBindings.apply(this,arguments);for(var n in this.mBindingInfos){var A=this.getMetadata().getAggregation(n);if(A&&A.multiple&&!A._doesNotRequireFactory&&this.isBound(n)&&!this.getBinding(n)){this[A._sDestructor]();}}return r;};
l.prototype._setCompositeAggregation=function(n){var s=this.getMetadata().getCompositeAggregationName();this._destroyCompositeAggregation();if(!this._oManagedObjectModel){this._getManagedObjectModel();}if(q.isArray(n)){this.setAggregation(s,null);return;}if(n){n.setModel(this._oManagedObjectModel,"$"+this.alias);n.bindObject("$"+this.alias+">/");var r=this._getResourceModel();if(r){n.setModel(r,"$"+this.alias+".i18n");}}this.setAggregation(s,n);this.invalidate();};
l.mResourceModels={};
l.getLibraryResourceModel=function(L){var o=l.mResourceModels[L];if(!o){o=new R({bundleName:L+".messagebundle",async:true});l.mResourceModels[L]=o;}return o;};
l.prototype._getResourceModel=function(){if(this.resourceModel){return this.resourceModel;}if(this.messageBundle){this.resourceModel=new R({bundleName:this.messageBundle,async:true});return this.resourceModel;}else{this.sLibraryName=this.sLibraryName||this.getMetadata().getLibraryName();return l.getLibraryResourceModel(this.sLibraryName);}};
l.prototype.getResourceBundle=function(){var r=this._getResourceModel();return r?r.getResourceBundle():null;};
l.prototype.destroy=function(){C.prototype.destroy.apply(this,arguments);if(this.resourceModel){this.resourceModel.destroy();}};
l.prototype._initCompositeSupport=function(s){var o=this.getMetadata(),A=o.getCompositeAggregationName(),i=false;if(s&&A){var n=s[A];if(n instanceof b){this._destroyCompositeAggregation();this._setCompositeAggregation(n);i=true;}else{if(n&&n.localName==="FragmentDefinition"){this._destroyCompositeAggregation();this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:s[A],oController:this}));i=true;}}delete s[A];}if(!i){this._destroyCompositeAggregation();this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:this.getMetadata()._fragment,oController:this}));}};
l.prototype.requestFragmentRetemplating=function(i){if(i){this.fragmentRetemplating();return;}var A=this.getMetadata().getMandatoryAggregations(),B=true;for(var n in A){B=typeof this.getBindingInfo(n)==="object";if(!B){break;}}if(B){this.fragmentRetemplating();}};
l.prototype.fragmentRetemplating=function(){var o=this.getMetadata(),i=o.getFragment();if(!i){throw new Error("Fragment "+i.tagName+" not found");}var j=this._getManagedObjectModel();var n=this;j.getContextName=function(){return n.alias;};this.setModel(j,this.alias);this.bindObject(this.alias+">/");j._mSettings=k(this._getPropertiesToPropagate());delete j._mSettings.models["$"+this.alias];delete j._mSettings.bindingContexts["$"+this.alias];this.setModel(null,this.alias);a.process(i.querySelector("*"),{},j._mSettings);var s={};s[o.getCompositeAggregationName()]=i;this._initCompositeSupport(s);};
l.initialTemplating=function(E,v,s){var i=e(s),o=new J({}),j={"_$error":o.getContext("/")},n=i.getMetadata(),r=n.getFragment(),u=n._mSpecialSettings.metadataContexts?n._mSpecialSettings.metadataContexts.defaultValue:"";if(!r){throw new Error("Fragment "+s+" not found");}h(j,v,E.getAttribute("metadataContexts"),u,i.prototype.defaultMetaModel);f(j,i.prototype.alias,E,i,v);var w=v["with"](j,true);t(E,n,w);w.visitChildNodes(r);var N=r.ownerDocument.createElementNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1",n.getCompositeAggregationName());N.appendChild(r);E.appendChild(N);};
return l;});
sap.ui.predefine('sap/ui/core/XMLCompositeMetadata',['jquery.sap.global','sap/ui/core/ElementMetadata','sap/ui/core/XMLTemplateProcessor'],function(q,E,X){"use strict";var I={Render:true,Template:"template",None:false};var f={};var a=function(c,C){if(!C.hasOwnProperty("renderer")){C.renderer="sap.ui.core.XMLCompositeRenderer";}if(!C.hasOwnProperty("alias")){C.alias="this";}E.apply(this,arguments);var b=this._bAbstract;if(!b){if(!C.fragment&&c!=="sap.ui.core.XMLComposite"){C.fragment=c;C.fragmentUnspecified=true;}if(!this._fragment&&C.fragment){try{if(!this._fragment){this._fragment=this._loadFragment(C.fragment,"control");}if(C.aggregationFragments){this._aggregationFragments={};C.aggregationFragments.forEach(function(A){this._aggregationFragments[A]=this._loadFragment(C.fragment+"_"+A,"aggregation");}.bind(this));}}catch(e){if(!C.fragmentUnspecified){throw(e);}else{q.sap.log.warning("Implicitly inferred fragment xml "+C.fragment+" not found. "+c+" is not abstract!");}}}}this._sCompositeAggregation=C.metadata?C.metadata.compositeAggregation||null:null;this._createPrivateAggregationAccessors();this._applyAggregationSettings();};a.prototype=Object.create(E.prototype);a.uid=E.uid;
a.prototype.getCompositeAggregationName=function(){return this._sCompositeAggregation||"_content";};
a.prototype.getFragment=function(){if(this._fragment){return this._fragment.cloneNode(true);}};
a.prototype._applyAggregationSettings=function(){var A=this.getAllAggregations();for(var n in A){if(A[n].type==="TemplateMetadataContext"){this.getAggregation(n)._doesNotRequireFactory=true;}}};
a.prototype._createPrivateAggregationAccessors=function(){var p=this.getAllPrivateAggregations(),b=this.getClass().prototype,g=function(c,d){if(!b[c]){b[c]=d;}};for(var n in p){p[n].generate(g);}};
a.prototype._suppressInvalidate=function(m,s){if(s){return true;}if(!m.appData){m.appData={};m.appData.invalidate=I.None;}if(m&&m.appData&&m.appData.invalidate===I.Render){return false;}return true;};
a.prototype._requestFragmentRetemplatingCheck=function(c,m,F){if(!c._bIsCreating&&!c._bIsBeingDestroyed&&m&&m.appData&&m.appData.invalidate===I.Template&&!c._requestFragmentRetemplatingPending){if(c.requestFragmentRetemplating){c._requestFragmentRetemplatingPending=true;setTimeout(function(){c.requestFragmentRetemplating(F);c._requestFragmentRetemplatingPending=false;},0);}else{throw new Error("Function requestFragmentRetemplating not available although invalidationMode was set to template");}}};
a.prototype.getMandatoryAggregations=function(){if(!this._mMandatoryAggregations){var A=this.getAllAggregations(),m={};for(var n in A){if(A[n].type==="TemplateMetadataContext"&&A[n].appData.mandatory){m[n]=A[n];}}this._mMandatoryAggregations=m;}return this._mMandatoryAggregations;};
a.prototype.requireFor=function(e){var m=e.getAttribute("template:require");if(m){q.sap.require.apply(q.sap,m.split(" "));}};
a.prototype._loadFragment=function(F,e){if(!f[F]){f[F]=X.loadTemplate(F,e);this.requireFor(f[F]);}return f[F];};
a.prototype.hasAggregation=function(n){return!!this._mAllAggregations[n]||!!this._mAllPrivateAggregations[n];};
return a;},true);
sap.ui.predefine('sap/ui/core/XMLTemplateProcessor',['jquery.sap.global','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/ui/core/CustomData','./mvc/View','./mvc/EventHandlerResolver','./ExtensionPoint','./StashedControlSupport','sap/ui/base/SyncPromise'],function(q,D,M,C,V,E,a,S,b){"use strict";
function p(t,v,n,o){var B=M.bindingParser(v,o,true);if(B&&typeof B==="object"){return B;}var d=v=B||v;var T=D.getType(t);if(T){if(T instanceof D){d=T.parseValue(v,{context:o});}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof d==="string"?M.bindingParser.escape(d):d;}
function l(x){return x.localName||x.baseName||x.nodeName;}
function u(d){if(d.isRejected()){throw d.getResult();}return d.getResult();}
function g(A,f){function s(n,o,m){var e,v,h=[];for(e=n.firstChild;e;e=e.nextSibling){v=f(n,o,m,e);if(v){h.push(u(v));}}return b.resolve(h);}function d(n,o,m){var e,h=Promise.resolve(),i=[];for(e=n.firstChild;e;e=e.nextSibling){h=h.then(f.bind(null,n,o,m,e));i.push(h);}return Promise.all(i);}return A?d:s;}
var X={};
X.loadTemplate=function(t,e){var r=q.sap.getResourceName(t,"."+(e||"view")+".xml");return q.sap.loadResource(r).documentElement;};
X.loadTemplatePromise=function(t,e){var r=q.sap.getResourceName(t,"."+(e||"view")+".xml");return q.sap.loadResource(r,{async:true}).then(function(R){return R.documentElement;});};
X.parseViewAttributes=function(x,v,s){var A=v.getMetadata().getAllProperties();for(var i=0;i<x.attributes.length;i++){var d=x.attributes[i];if(d.name==='controllerName'){v._controllerName=d.value;}else if(d.name==='resourceBundleName'){v._resourceBundleName=d.value;}else if(d.name==='resourceBundleUrl'){v._resourceBundleUrl=d.value;}else if(d.name==='resourceBundleLocale'){v._resourceBundleLocale=d.value;}else if(d.name==='resourceBundleAlias'){v._resourceBundleAlias=d.value;}else if(d.name==='class'){v.addStyleClass(d.value);}else if(!s[d.name]&&A[d.name]){s[d.name]=p(A[d.name].type,d.value,d.name,v._oContainingView.oController);}}};
X.enrichTemplateIds=function(x,v){X.enrichTemplateIdsPromise(x,v,false);return x;};
X.enrichTemplateIdsPromise=function(x,v,A){return c(x,v,true,A).then(function(){return x;});};
X.parseTemplate=function(x,v){return u(X.parseTemplatePromise(x,v,false));};
X.parseTemplatePromise=function(x,v,A,P){return c(x,v,false,A,P);};
function c(x,v,d,A,P){var r=[],f=b.resolve(),s=v._sProcessingMode||sap.ui.getCore().getConfiguration().getXMLProcessingMode();A=A&&s==="sequential";q.sap.log.debug("XML processing mode is "+(A?"sequential":"default"),"","XMLTemplateProcessor");var h=sap.ui.getCore().getConfiguration().getDesignMode();if(h){v._sapui_declarativeSourceInfo={xmlNode:x,xmlRootNode:v._oContainingView===v?x:v._oContainingView._sapui_declarativeSourceInfo.xmlRootNode};}var k=v.sViewName||v._sFragmentName;if(!k){var t=v;var L=0;while(++L<1000&&t&&t!==t._oContainingView){t=t._oContainingView;}k=t.sViewName;}if(v.isSubView()){y(x,true);}else{if(x.localName==="View"&&x.namespaceURI!=="sap.ui.core.mvc"){q.sap.log.warning("XMLView root node must have the 'sap.ui.core.mvc' namespace, not '"+x.namespaceURI+"'"+(k?" (View name: "+k+")":""));}z(x);}var i=0;function m(){for(;i<r.length;i++){var e=r[i];if(e&&typeof e.then==='function'){return e.then(n).then(m);}}return r;}function n(e){var j=[i,1].concat(e);Array.prototype.splice.apply(r,j);}return f.then(m);function o(e){return e;}function w(e){return v._oContainingView.createId(e);}function y(x,R,e){if(x.nodeType===1){var j=l(x);if(x.namespaceURI==="http://www.w3.org/1999/xhtml"||x.namespaceURI==="http://www.w3.org/2000/svg"){r.push("<"+j+" ");var K=false;for(var i=0;i<x.attributes.length;i++){var N=x.attributes[i];var O=N.value;if(N.name==="id"){K=true;O=I(v,x);}r.push(N.name+"=\""+q.sap.encodeHTML(O)+"\" ");}if(R===true){r.push("data-sap-ui-preserve"+"=\""+v.getId()+"\" ");if(!K){r.push("id"+"=\""+v.getId()+"\" ");}}r.push(">");var Q=x;if(window.HTMLTemplateElement&&x instanceof HTMLTemplateElement&&x.content instanceof DocumentFragment){Q=x.content;}z(Q);r.push("</"+j+">");}else if(j==="FragmentDefinition"&&x.namespaceURI==="sap.ui.core"){z(x,false,true);}else{f=f.then(function(){return G(x).then(function(W){for(var i=0;i<W.length;i++){var Y=W[i];if(v.getMetadata().hasAggregation("content")){v.addAggregation("content",Y);}else if(v.getMetadata().hasAssociation(("content"))){v.addAssociation("content",Y);}}return W;});});r.push(f);}}else if(x.nodeType===3&&!e){var T=x.textContent||x.text,U=l(x.parentNode);if(T){if(U!="style"){T=q.sap.encodeHTML(T);}r.push(T);}}}function z(x,R,e){var j=x.childNodes;for(var i=0;i<j.length;i++){y(j[i],R,e);}}function B(N,e){var j;var K=sap.ui.getCore().getLoadedLibraries();q.each(K,function(T,U){if(N===U.namespace||N===U.name){j=U.name+"."+((U.tagNames&&U.tagNames[e])||e);}});j=j||N+"."+e;function O(Q){if(!Q){q.sap.log.error("Control '"+j+"' did not return a class definition from sap.ui.define.","","XMLTemplateProcessor");Q=q.sap.getObject(j);}if(!Q){q.sap.log.error("Can't find object class '"+j+"' for XML-view","","XMLTemplateProcessor");}return Q;}var R=q.sap.getResourceName(j,"");var Q=sap.ui.require(R);if(!Q){if(A){return new Promise(function(T){sap.ui.require([R],function(Q){Q=O(Q);T(Q);});});}else{Q=sap.ui.requireSync(R);Q=O(Q);}}return Q;}function F(e){if(e.namespaceURI==="http://www.w3.org/1999/xhtml"||e.namespaceURI==="http://www.w3.org/2000/svg"){var j=e.attributes['id']?e.attributes['id'].textContent||e.attributes['id'].text:null;if(d){return X.enrichTemplateIdsPromise(e,v,A).then(function(){return[];});}else{var K=function(O){var Q={id:j?I(v,e,j):undefined,xmlNode:e,containingView:v._oContainingView};if(v.fnScopedRunWithOwner){return v.fnScopedRunWithOwner(function(){return new O(Q);});}return new O(Q);};if(A){return new Promise(function(O,Q){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(N){O([K(N)]);});});}else{var N=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return b.resolve([K(N)]);}}}else{return G(e);}}function G(e){if(l(e)==="ExtensionPoint"&&e.namespaceURI==="sap.ui.core"){if(d){return b.resolve([]);}else{var j=v instanceof V?v._oContainingView:v;return b.resolve(a._factory(j,e.getAttribute("name"),function(){var N=b.resolve();var O=[];var Q=e.childNodes;for(var i=0;i<Q.length;i++){var R=Q[i];if(R.nodeType===1){N=N.then(F.bind(null,R));O.push(N);}}return b.all(O).then(function(T){var U=[];T.forEach(function(W){U=U.concat(W);});return U;});}));}}else{var K=B(e.namespaceURI,l(e));if(K&&typeof K.then==='function'){return K.then(function(N){return H(e,N);});}else{return H(e,K);}}}function H(K,N){var O=K.namespaceURI,Q={},R="",T=[],U=null,W=null;if(!N){return b.resolve([]);}var Y=N.getMetadata();var Z=Y.getAllSettings();if(!d){for(var i=0;i<K.attributes.length;i++){var $=K.attributes[i],_=$.name,a1=Z[_],b1=$.value;if(_==="id"){Q[_]=I(v,K,b1);}else if(_==="class"){R+=b1;}else if(_==="viewName"){Q[_]=b1;}else if(_==="fragmentName"){Q[_]=b1;Q['containingView']=v._oContainingView;}else if((_==="binding"&&!a1)||_==='objectBindings'){var c1=M.bindingParser(b1,v._oContainingView.oController);if(c1){Q.objectBindings=Q.objectBindings||{};Q.objectBindings[c1.model||undefined]=c1;}}else if(_==='metadataContexts'){var d1=null;try{d1=X._calculatedModelMapping(b1,v._oContainingView.oController,true);}catch(e){q.sap.log.error(v+":"+e.message);}if(d1){Q.metadataContexts=d1;if(X._preprocessMetadataContexts){X._preprocessMetadataContexts(N.getMetadata().getName(),Q,v._oContainingView.oController);}}}else if(_.indexOf(":")>-1){if($.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"){var e1=l($);T.push(new C({key:e1,value:p("any",b1,e1,v._oContainingView.oController)}));}else if($.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1"){W=b1;}else if(_.indexOf("xmlns:")!==0){if(!U){U={};}if(!U.hasOwnProperty($.namespaceURI)){U[$.namespaceURI]={};}U[$.namespaceURI][l($)]=$.nodeValue;q.sap.log.debug(v+": XMLView parser encountered unknown attribute '"+_+"' (value: '"+b1+"') with unknown namespace, stored as sap-ui-custom-settings of customData");}}else if(a1&&a1._iKind===0){Q[_]=p(a1.type,b1,_,v._oContainingView.oController);}else if(a1&&a1._iKind===1&&a1.altTypes){Q[_]=p(a1.altTypes[0],b1,_,v._oContainingView.oController);}else if(a1&&a1._iKind===2){var c1=M.bindingParser(b1,v._oContainingView.oController);if(c1){Q[_]=c1;}else{q.sap.log.error(v+": aggregations with cardinality 0..n only allow binding paths as attribute value (wrong value: "+_+"='"+b1+"')");}}else if(a1&&a1._iKind===3){Q[_]=w(b1);}else if(a1&&a1._iKind===4){Q[_]=b1.split(/[\s,]+/g).filter(o).map(w);}else if(a1&&a1._iKind===5){var f1=E.resolveEventHandler(b1,v._oContainingView.oController);if(f1){Q[_]=f1;}else{q.sap.log.warning(v+": event handler function \""+b1+"\" is not a function or does not exist in the controller.");}}else if(a1&&a1._iKind===-1){if(V.prototype.isPrototypeOf(N.prototype)&&_=="async"){Q[_]=p(a1.type,b1,_,v._oContainingView.oController);}else{q.sap.log.warning(v+": setting '"+_+"' for class "+Y.getName()+" (value:'"+b1+"') is not supported");}}else{if(X._supportInfo){X._supportInfo({context:K,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+_+"' for class "+Y.getName()}});}}}if(U){T.push(new C({key:"sap-ui-custom-settings",value:U}));}if(T.length>0){Q.customData=T;}}var g1=g(A,h1);function h1(K,i1,j1,k1,l1){var m1;if(k1.nodeType===1){if(k1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1"){Q[l(k1)]=k1.querySelector("*");return;}m1=k1.namespaceURI===O&&j1&&j1[l(k1)];if(m1){return g1(k1,m1);}else if(i1){if(!l1&&k1.getAttribute("stashed")==="true"&&!d){S.createStashedControl(I(v,k1),{sParentId:Q["id"],sParentAggregationName:i1.name,fnCreate:function(){var j=A;A=false;try{return u(h1(K,i1,j1,k1,true));}finally{A=j;}}});return;}return F(k1).then(function(n1){for(var j=0;j<n1.length;j++){var o1=n1[j];var p1=i1.name;if(i1.multiple){if(!Q[p1]){Q[p1]=[];}if(typeof Q[p1].path==="string"){Q[p1].template=o1;}else{Q[p1].push(o1);}}else{Q[p1]=o1;}}return n1;});}else if(l(K)!=="FragmentDefinition"||K.namespaceURI!=="sap.ui.core"){throw new Error("Cannot add direct child without default aggregation defined for control "+Y.getElementName());}}else if(k1.nodeType===3){if(q.trim(k1.textContent||k1.text)){throw new Error("Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed: "+q.trim(k1.textContent||k1.text));}}}var i1=Y.getDefaultAggregation();var j1=Y.getAllAggregations();return g1(K,i1,j1).then(function(){var j;if(d&&K.hasAttribute("id")){J(v,K);}else if(!d){if(V.prototype.isPrototypeOf(N.prototype)&&typeof N._sType==="string"){var k1=function(){return sap.ui.view(Q,undefined,N._sType);};if(v.fnScopedRunWithOwner){j=v.fnScopedRunWithOwner(k1);}else{j=k1();}}else{var l1=function(){if(v.fnScopedRunWithOwner){return v.fnScopedRunWithOwner(function(){return new N(Q);});}else{return new N(Q);}};if(P&&P.fnRunWithPreprocessor){j=P.fnRunWithPreprocessor(l1);}else{j=l1();}}if(R&&j.addStyleClass){j.addStyleClass(R);}}if(!j){j=[];}else if(!Array.isArray(j)){j=[j];}if(X._supportInfo&&j){for(var i=0,m1=j.length;i<m1;i++){var n1=j[i];if(n1&&n1.getId()){var o1=X._supportInfo({context:K,env:{caller:"createRegularControls",nodeid:K.getAttribute("id"),controlid:n1.getId()}}),p1=W?W+",":"";p1+=o1;X._supportInfo.addSupportInfo(n1.getId(),p1);}}}if(h){j.forEach(function(n1){if(Y.getCompositeAggregationName){var q1=K.getElementsByTagName(n1.getMetadata().getCompositeAggregationName());for(var i=0;i<q1.length;i++){K.removeChild(q1[0]);}}n1._sapui_declarativeSourceInfo={xmlNode:K,xmlRootNode:v._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:Y.getName()==='sap.ui.core.Fragment'?Q['fragmentName']:null};});}return j;});}function I(v,x,e){if(x.getAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id")){return x.getAttribute("id");}else{return w(e?e:x.getAttribute("id"));}}function J(v,x){x.setAttribute("id",w(x.getAttribute("id")));x.setAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id",true);}}
X._preprocessMetadataContexts=null;
X._calculatedModelMapping=function(B,o,A){var d,m={},e=M.bindingParser(B,o);function f(F){if(F.length%2===0){throw new Error("The last entry is no binding");}for(var i=1;i<=F.length;i=i+2){if(typeof F[i-1]=='string'){throw new Error("Binding expected not a string");}if(F[i]){if((typeof F[i]!='string')||(F[i]!=",")){throw new Error("Missing delimiter ','");}}}}if(e){if(!e.formatter){d=e;e={parts:[d]};}else{f(e.formatter.textFragments);}for(var i=0;i<e.parts.length;i++){d=e.parts[i];m[d.model]=m[d.model]||(A?[]:null);if(Array.isArray(m[d.model])){m[d.model].push(d);}else{m[d.model]=d;}}}return m;};
return X;},true);
sap.ui.predefine('sap/ui/core/cache/CacheManager',['jquery.sap.global','./LRUPersistentCache','./CacheManagerNOP','sap/ui/Device'],function(q,L,C,D){"use strict";var a={_instance:null,_getInstance:function(){var p,M=c("_getInstance"),t=this;p=new Promise(function(r,d){var I;q.sap.log.debug("Cache Manager: Initialization...");if(!a._instance){I=t._findImplementation();q.sap.measure.start(b,"CM",S);I.init().then(e,d);q.sap.measure.end(b,"CM");}else{e(a._instance);}function e(f){a._instance=f;M.endAsync();q.sap.log.debug("Cache Manager initialized with implementation ["+a._instance.name+"], resolving _getInstance promise");r(f);}});M.endSync();return p;},_findImplementation:function(){if(i()&&this._isSupportedEnvironment()){return L;}else{q.sap.log.warning("UI5 Cache Manager is switched off");return C;}},set:function(k,v){var p,M=c("set",k);q.sap.log.debug("Cache Manager: Setting value of type["+typeof v+"] with key ["+k+"]");p=this._callInstanceMethod("set",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: Setting key ["+k+"] completed successfully");M.endAsync();},function(e){q.sap.log.error("Cache Manager: Setting key ["+k+"] failed. Error:"+e);M.endAsync();throw e;});M.endSync();return p;},get:function(k){var p,M=c("get",k);q.sap.log.debug("Cache Manager: Getting key ["+k+"]");p=this._callInstanceMethod("get",arguments).then(function callInstanceHandler(v){q.sap.log.debug("Cache Manager: Getting key ["+k+"] done");M.endAsync();return v;},function(e){q.sap.log.debug("Cache Manager: Getting key ["+k+"] failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},has:function(k){var p,M=c("has",k);q.sap.log.debug("Cache Manager: has key ["+k+"] called");p=this._callInstanceMethod("has",arguments).then(function callInstanceHandler(r){M.endAsync();q.sap.log.debug("Cache Manager: has key ["+k+"] returned "+r);return r;});M.endSync();return p;},del:function(k){var p,M=c("del",k);q.sap.log.debug("Cache Manager: del called.");p=this._callInstanceMethod("del",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: del completed successfully.");M.endAsync();},function(e){q.sap.log.debug("Cache Manager: del failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},reset:function(){var p,M=c("reset");q.sap.log.debug("Cache Manager: Reset called.");p=this._callInstanceMethod("reset",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: Reset completed successfully.");M.endAsync();},function(e){q.sap.log.debug("Cache Manager: Reset failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},_switchOff:function(){var t=this;return Promise.resolve().then(function(){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(false);});},_switchOn:function(){var t=this;return Promise.resolve().then(function(){var o=sap.ui.getCore().getConfiguration();if(!o.isUI5CacheOn()){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(true);}return Promise.resolve();});},_callInstanceMethod:function(M,A){var p,d="[sync ] _callInstanceMethod";q.sap.measure.start(d,"CM",S);if(this._instance){q.sap.log.debug("Cache Manager: calling instance...");return this._instance[M].apply(this._instance,A);}q.sap.log.debug("Cache Manager: getting instance...");p=this._getInstance().then(function instanceResolving(e){return e[M].apply(e,A);});q.sap.measure.end(d);return p;},_isSupportedEnvironment:function(){var d=[];if(this._bSupportedEnvironment==undefined){d.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.CHROME,browserVersion:49});d.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.INTERNET_EXPLORER,browserVersion:11});this._bSupportedEnvironment=d.some(function(o){var e=D.system[o.system],f=o.browserName===D.browser.name,g=D.browser.version>=o.browserVersion;return e&&f&&g&&window.indexedDB;});}return this._bSupportedEnvironment;}};var S="CacheManager",b="[sync ] _initImplementation",m=0;
function i(){return sap.ui.getCore().getConfiguration().isUI5CacheOn();}
function s(d){if(d._instance){d._instance._destroy();d._instance=null;}}
function c(o,k){m++;var M="[async]  "+o+"["+k+"]- #"+(m),d="[sync ]  "+o+"["+k+"]- #"+(m);q.sap.measure.start(M,"CM",[S,o]);q.sap.measure.start(d,"CM",[S,o]);return{sMeasureAsync:M,sMeasureSync:d,endAsync:function(){q.sap.measure.end(this.sMeasureAsync);},endSync:function(){q.sap.measure.end(this.sMeasureSync);}};}
return a;},false);
sap.ui.predefine('sap/ui/core/cache/CacheManagerNOP',[],function(){"use strict";var C={name:"CacheManagerNOP",set:function(){return Promise.resolve();},get:function(){return Promise.resolve(undefined);},has:function(){return Promise.resolve(false);},del:function(){return Promise.resolve();},reset:function(){return Promise.resolve();},init:function(){return Promise.resolve(this);},_db:{close:function(){}},_getCount:function(){return Promise.resolve(0);},_destroy:function(){}};return C;},false);
sap.ui.predefine('sap/ui/core/date/Gregorian',['jquery.sap.global','./UniversalDate'],function(q,U){"use strict";
var G=U.extend("sap.ui.core.date.Gregorian",{constructor:function(){this.oDate=this.createDate(Date,arguments);this.sCalendarType=sap.ui.core.CalendarType.Gregorian;}});
G.UTC=function(){return Date.UTC.apply(Date,arguments);};
G.now=function(){return Date.now();};
return G;});
sap.ui.predefine('sap/ui/core/date/Islamic',['jquery.sap.global','./UniversalDate'],function(q,U){"use strict";
var I=U.extend("sap.ui.core.date.Islamic",{constructor:function(){var a=arguments;if(a.length>1){a=f(a);}this.oDate=this.createDate(Date,a);this.sCalendarType=sap.ui.core.CalendarType.Islamic;}});
I.UTC=function(){var a=f(arguments);return Date.UTC.apply(Date,a);};
I.now=function(){return Date.now();};
var B=1400,G=1721425.5,c=1948439.5,d=-42521587200000,O=86400000;var C=null;
function t(o){var a=o.year,b=o.month,k=o.day,l,n,r,M,D,L,J;L=0;if((b+1)>2){L=j(a)?-1:-2;}J=(G-1)+(365*(a-1))+Math.floor((a-1)/4)+(-Math.floor((a-1)/100))+Math.floor((a-1)/400)+Math.floor((((367*(b+1))-362)/12)+L+k);J=Math.floor(J)+0.5;D=J-c;M=Math.floor(D/29.530588853);if(M<0){l=Math.floor(M/12)+1;n=M%12;if(n<0){n+=12;}r=D-m(l,n)+1;}else{M++;while(g(M)>D){M--;}l=Math.floor(M/12)+1;n=M%12;r=(D-g(12*(l-1)+n))+1;}return{day:r,month:n,year:l};}
function e(o){var a=o.year,b=o.month,k=o.day,M=a<1?m(a,b):g(12*(a-1)+b),J=k+M+c-1,l=Math.floor(J-0.5)+0.5,D=l-G,Q=Math.floor(D/146097),n=h(D,146097),r=Math.floor(n/36524),s=h(n,36524),u=Math.floor(s/1461),v=h(s,1461),y=Math.floor(v/365),Y=(Q*400)+(r*100)+(u*4)+y,w,x,z,A,E,F,L,H;if(!(r==4||y==4)){Y++;}z=G+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400);A=l-z;E=(G-1)+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400)+Math.floor((739/12)+((j(Y)?-1:-2))+1);L=0;if(l<E){L=0;}else{L=j(Y)?1:2;}w=Math.floor((((A+L)*12)+373)/367);F=(G-1)+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400);H=0;if(w>2){H=j(Y)?-1:-2;}F+=Math.floor((((367*w)-362)/12)+H+1);x=(l-F)+1;return{day:x,month:w-1,year:Y};}
function f(a){var b=Array.prototype.slice.call(a),o,k;o={year:a[0],month:a[1],day:a[2]!==undefined?a[2]:1};k=e(o);b[0]=k.year;b[1]=k.month;b[2]=k.day;return b;}
function i(){var D,o;C={};D=sap.ui.getCore().getConfiguration().getFormatSettings().getLegacyDateFormat();o=sap.ui.getCore().getConfiguration().getFormatSettings().getLegacyDateCalendarCustomizing();o=o||[];if(!D&&!o.length){q.sap.log.info("No calendar customizations.");return;}if((D&&!o.length)||(!D&&o.length)){q.sap.log.warning("There is an inconsistency between customization data ["+JSON.stringify(o)+"] and the date format ["+D+"]. Calendar customization won't be used.");return;}o.forEach(function(E){if(E.dateFormat===D){var a=p(E.gregDate);var b=new Date(Date.UTC(a.year,a.month-1,a.day));var M=b.getTime();var k=(M-d)/O;a=p(E.islamicMonthStart);var l=(a.year-1)*12+a.month-1;C[l]=k;}});q.sap.log.info("Working with date format: ["+D+"] and customization: "+JSON.stringify(o));}
function p(D){return{year:parseInt(D.substr(0,4),10),month:parseInt(D.substr(4,2),10),day:parseInt(D.substr(6,2),10)};}
function g(a){if(!C){i();}var b=C[a];if(!b){var y=Math.floor(a/12)+1;var k=a%12;b=m(y,k);}return b;}
function m(y,a){return Math.ceil(29.5*a)+(y-1)*354+Math.floor((3+11*y)/30.0);}
function h(a,b){return a-(b*Math.floor(a/b));}
function j(y){return!(y%400)||(!(y%4)&&!!(y%100));}
I.prototype._getIslamic=function(){return t({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()});};
I.prototype._setIslamic=function(o){var a=e(o);return this.oDate.setFullYear(a.year,a.month,a.day);};
I.prototype._getUTCIslamic=function(){return t({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()});};
I.prototype._setUTCIslamic=function(o){var a=e(o);return this.oDate.setUTCFullYear(a.year,a.month,a.day);};
I.prototype.getDate=function(D){return this._getIslamic().day;};
I.prototype.getMonth=function(){return this._getIslamic().month;};
I.prototype.getYear=function(){return this._getIslamic().year-B;};
I.prototype.getFullYear=function(){return this._getIslamic().year;};
I.prototype.setDate=function(D){var o=this._getIslamic();o.day=D;return this._setIslamic(o);};
I.prototype.setMonth=function(M,D){var o=this._getIslamic();o.month=M;if(D!==undefined){o.day=D;}return this._setIslamic(o);};
I.prototype.setYear=function(y){var o=this._getIslamic();o.year=y+B;return this._setIslamic(o);};
I.prototype.setFullYear=function(y,M,D){var o=this._getIslamic();o.year=y;if(M!==undefined){o.month=M;}if(D!==undefined){o.day=D;}return this._setIslamic(o);};
I.prototype.getUTCDate=function(D){return this._getUTCIslamic().day;};
I.prototype.getUTCMonth=function(){return this._getUTCIslamic().month;};
I.prototype.getUTCFullYear=function(){return this._getUTCIslamic().year;};
I.prototype.setUTCDate=function(D){var o=this._getUTCIslamic();o.day=D;return this._setUTCIslamic(o);};
I.prototype.setUTCMonth=function(M,D){var o=this._getUTCIslamic();o.month=M;if(D!==undefined){o.day=D;}return this._setUTCIslamic(o);};
I.prototype.setUTCFullYear=function(y,M,D){var o=this._getUTCIslamic();o.year=y;if(M!==undefined){o.month=M;}if(D!==undefined){o.day=D;}return this._setUTCIslamic(o);};
return I;});
sap.ui.predefine('sap/ui/core/date/Japanese',['./UniversalDate'],function(U){"use strict";
var J=U.extend("sap.ui.core.date.Japanese",{constructor:function(){var A=arguments;if(A.length>1){A=b(A);}this.oDate=this.createDate(Date,A);this.sCalendarType=sap.ui.core.CalendarType.Japanese;}});
J.UTC=function(){var A=b(arguments);return Date.UTC.apply(Date,A);};
J.now=function(){return Date.now();};
function t(g){var e=U.getEraByDate(sap.ui.core.CalendarType.Japanese,g.year,g.month,g.day),E=U.getEraStartDate(sap.ui.core.CalendarType.Japanese,e).year;return{era:e,year:g.year-E+1,month:g.month,day:g.day};}
function a(j){var e=U.getEraStartDate(sap.ui.core.CalendarType.Japanese,j.era).year;return{year:e+j.year-1,month:j.month,day:j.day};}
function b(A){var j,g,e,y=A[0];if(typeof y=="number"){if(y>=100){return A;}else{e=U.getCurrentEra(sap.ui.core.CalendarType.Japanese);y=[e,y];}}else if(!Array.isArray(y)){y=[];}j={era:y[0],year:y[1],month:A[1],day:A[2]!==undefined?A[2]:1};g=a(j);A[0]=g.year;return A;}
J.prototype._getJapanese=function(){var g={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return t(g);};
J.prototype._setJapanese=function(j){var g=a(j);return this.oDate.setFullYear(g.year,g.month,g.day);};
J.prototype._getUTCJapanese=function(){var g={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return t(g);};
J.prototype._setUTCJapanese=function(j){var g=a(j);return this.oDate.setUTCFullYear(g.year,g.month,g.day);};
J.prototype.getYear=function(){return this._getJapanese().year;};
J.prototype.getFullYear=function(){return this._getJapanese().year;};
J.prototype.getEra=function(){return this._getJapanese().era;};
J.prototype.getUTCFullYear=function(){return this._getUTCJapanese().year;};
J.prototype.getUTCEra=function(){return this._getUTCJapanese().era;};
J.prototype.setYear=function(y){var j=this._getJapanese();j.year=y;return this._setJapanese(j);};
J.prototype.setFullYear=function(y,m,d){var j=this._getJapanese();j.year=y;if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setJapanese(j);};
J.prototype.setEra=function(e,y,m,d){var E=U.getEraStartDate(sap.ui.core.CalendarType.Japanese,e),j=t(E);if(y!==undefined){j.year=y;}if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setJapanese(j);};
J.prototype.setUTCFullYear=function(y,m,d){var j=this._getUTCJapanese();j.year=y;if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setUTCJapanese(j);};
J.prototype.setUTCEra=function(e,y,m,d){var E=U.getEraStartDate(sap.ui.core.CalendarType.Japanese,e),j=t(E);if(y!==undefined){j.year=y;}if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setUTCJapanese(j);};
J.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate());};
J.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
return J;});
sap.ui.predefine('sap/ui/core/date/Persian',['./UniversalDate'],function(U){"use strict";
var P=U.extend("sap.ui.core.date.Persian",{constructor:function(){var a=arguments;if(a.length>1){a=e(a);}this.oDate=this.createDate(Date,a);this.sCalendarType=sap.ui.core.CalendarType.Persian;}});
P.UTC=function(){var a=e(arguments);return Date.UTC.apply(Date,a);};
P.now=function(){return Date.now();};
var B=1300;
function t(G){var j=l(G.year,G.month+1,G.day);return h(j);}
function c(a){var j=g(a.year,a.month+1,a.day);return m(j);}
function e(a){var G=Array.prototype.slice.call(a),b,d;if(typeof a[0]!=="number"||typeof a[1]!=="number"||(a[2]!==undefined&&typeof a[2]!="number")){G[0]=NaN;G[1]=NaN;G[2]=NaN;return G;}b={year:a[0],month:a[1],day:a[2]!==undefined?a[2]:1};d=c(b);G[0]=d.year;G[1]=d.month;G[2]=d.day;return G;}
function f(j){var b=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178],a=b.length,d=j+621,k=-14,q=b[0],r,s,u,v,w,n,i;for(i=1;i<a;i+=1){r=b[i];s=r-q;if(j<r){break;}k=k+o(s,33)*8+o(p(s,33),4);q=r;}n=j-q;k=k+o(n,33)*8+o(p(n,33)+3,4);if(p(s,33)===4&&s-n===4){k+=1;}v=o(d,4)-o((o(d,100)+1)*3,4)-150;w=20+k-v;if(s-n<6){n=n-s+o(s+4,33)*33;}u=p(p(n+1,33)-1,4);if(u===-1){u=4;}return{leap:u,gy:d,march:w};}
function g(j,a,b){while(a<1){a+=12;j--;}while(a>12){a-=12;j++;}var r=f(j);return l(r.gy,3,r.march)+(a-1)*31-o(a,7)*(a-7)+b-1;}
function h(j){var a=m(j).year,b=a-621,r=f(b),d=l(a,3,r.march),i,n,k;k=j-d;if(k>=0){if(k<=185){n=1+o(k,31);i=p(k,31)+1;return{year:b,month:n-1,day:i};}else{k-=186;}}else{b-=1;k+=179;if(r.leap===1){k+=1;}}n=7+o(k,30);i=p(k,30)+1;return{year:b,month:n-1,day:i};}
function l(a,b,i){var d=o((a+o(b-8,6)+100100)*1461,4)+o(153*p(b+9,12)+2,5)+i-34840408;d=d-o(o(a+100100+o(b-8,6),100)*3,4)+752;return d;}
function m(a){var j,i,b,d,k;j=4*a+139361631;j=j+o(o(4*a+183187720,146097)*3,4)*4-3908;i=o(p(j,1461),4)*5+308;b=o(p(i,153),5)+1;d=p(o(i,153),12)+1;k=o(j,1461)-100100+o(8-d,6);return{year:k,month:d-1,day:b};}
function o(a,b){return~~(a/b);}
function p(a,b){return a-~~(a/b)*b;}
P.prototype._getPersian=function(){return t({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()});};
P.prototype._setPersian=function(a){var G=c(a);return this.oDate.setFullYear(G.year,G.month,G.day);};
P.prototype._getUTCPersian=function(){return t({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()});};
P.prototype._setUTCPersian=function(a){var G=c(a);return this.oDate.setUTCFullYear(G.year,G.month,G.day);};
P.prototype.getDate=function(d){return this._getPersian().day;};
P.prototype.getMonth=function(){return this._getPersian().month;};
P.prototype.getYear=function(){return this._getPersian().year-B;};
P.prototype.getFullYear=function(){return this._getPersian().year;};
P.prototype.setDate=function(d){var a=this._getPersian();a.day=d;return this._setPersian(a);};
P.prototype.setMonth=function(M,d){var a=this._getPersian();a.month=M;if(d!==undefined){a.day=d;}return this._setPersian(a);};
P.prototype.setYear=function(y){var a=this._getPersian();a.year=y+B;return this._setPersian(a);};
P.prototype.setFullYear=function(y,M,d){var a=this._getPersian();a.year=y;if(M!==undefined){a.month=M;}if(d!==undefined){a.day=d;}return this._setPersian(a);};
P.prototype.getUTCDate=function(d){return this._getUTCPersian().day;};
P.prototype.getUTCMonth=function(){return this._getUTCPersian().month;};
P.prototype.getUTCFullYear=function(){return this._getUTCPersian().year;};
P.prototype.setUTCDate=function(d){var a=this._getUTCPersian();a.day=d;return this._setUTCPersian(a);};
P.prototype.setUTCMonth=function(M,d){var a=this._getUTCPersian();a.month=M;if(d!==undefined){a.day=d;}return this._setUTCPersian(a);};
P.prototype.setUTCFullYear=function(y,M,d){var a=this._getUTCPersian();a.year=y;if(M!==undefined){a.month=M;}if(d!==undefined){a.day=d;}return this._setUTCPersian(a);};
return P;});
sap.ui.predefine('sap/ui/core/date/UniversalDate',['sap/ui/base/Object','sap/ui/core/LocaleData'],function(B,L){"use strict";
var U=B.extend("sap.ui.core.date.UniversalDate",{constructor:function(){var b=U.getClass();return this.createDate(b,arguments);}});
U.UTC=function(){var b=U.getClass();return b.UTC.apply(b,arguments);};
U.now=function(){return Date.now();};
U.prototype.createDate=function(b,A){switch(A.length){case 0:return new b();case 1:return new b(A[0]);case 2:return new b(A[0],A[1]);case 3:return new b(A[0],A[1],A[2]);case 4:return new b(A[0],A[1],A[2],A[3]);case 5:return new b(A[0],A[1],A[2],A[3],A[4]);case 6:return new b(A[0],A[1],A[2],A[3],A[4],A[5]);case 7:return new b(A[0],A[1],A[2],A[3],A[4],A[5],A[6]);}};
U.getInstance=function(d,C){var b,i;if(d instanceof U){d=d.getJSDate();}if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}b=U.getClass(C);i=Object.create(b.prototype);i.oDate=d;i.sCalendarType=C;return i;};
U.getClass=function(C){if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}return sap.ui.requireSync("sap/ui/core/date/"+C);};
["getDate","getMonth","getFullYear","getYear","getDay","getHours","getMinutes","getSeconds","getMilliseconds","getUTCDate","getUTCMonth","getUTCFullYear","getUTCDay","getUTCHours","getUTCMinutes","getUTCSeconds","getUTCMilliseconds","getTime","valueOf","getTimezoneOffset","toString","toDateString","setDate","setFullYear","setYear","setMonth","setHours","setMinutes","setSeconds","setMilliseconds","setUTCDate","setUTCFullYear","setUTCMonth","setUTCHours","setUTCMinutes","setUTCSeconds","setUTCMilliseconds"].forEach(function(n){U.prototype[n]=function(){return this.oDate[n].apply(this.oDate,arguments);};});
U.prototype.getJSDate=function(){return this.oDate;};
U.prototype.getCalendarType=function(){return this.sCalendarType;};
U.prototype.getEra=function(){return U.getEraByDate(this.sCalendarType,this.oDate.getFullYear(),this.oDate.getMonth(),this.oDate.getDate());};
U.prototype.setEra=function(E){};
U.prototype.getUTCEra=function(){return U.getEraByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.oDate.getUTCMonth(),this.oDate.getUTCDate());};
U.prototype.setUTCEra=function(E){};
U.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.getFullYear(),this.getMonth(),this.getDate());};
U.prototype.setWeek=function(w){var d=U.getFirstDateOfWeek(this.sCalendarType,w.year||this.getFullYear(),w.week);this.setFullYear(d.year,d.month,d.day);};
U.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
U.prototype.setUTCWeek=function(w){var d=U.getFirstDateOfWeek(this.sCalendarType,w.year||this.getFullYear(),w.week);this.setUTCFullYear(d.year,d.month,d.day);};
U.prototype.getQuarter=function(){return Math.floor((this.getMonth()/3));};
U.prototype.getUTCQuarter=function(){return Math.floor((this.getUTCMonth()/3));};
U.prototype.getDayPeriod=function(){if(this.getHours()<12){return 0;}else{return 1;}};
U.prototype.getUTCDayPeriod=function(){if(this.getUTCHours()<12){return 0;}else{return 1;}};
U.prototype.getTimezoneShort=function(){if(this.oDate.getTimezoneShort){return this.oDate.getTimezoneShort();}};
U.prototype.getTimezoneLong=function(){if(this.oDate.getTimezoneLong){return this.oDate.getTimezoneLong();}};
var m=7*24*60*60*1000;
U.getWeekByDate=function(C,y,M,d){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),b=this.getClass(C),f=g(b,y),D=new b(b.UTC(y,M,d)),w,i,n,o,N;if(l.getRegion()==="US"){w=c(f,D);}else{i=y-1;n=y+1;o=g(b,i);N=g(b,n);if(D>=N){y=n;w=0;}else if(D<f){y=i;w=c(o,D);}else{w=c(f,D);}}return{year:y,week:w};};
U.getFirstDateOfWeek=function(C,y,w){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),b=this.getClass(C),f=g(b,y),d=new b(f.valueOf()+w*m);if(l.getRegion()==="US"&&w===0&&f.getUTCFullYear()<y){return{year:y,month:0,day:1};}return{year:d.getUTCFullYear(),month:d.getUTCMonth(),day:d.getUTCDate()};};
function g(b,y){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),M=o.getMinimalDaysInFirstWeek(),f=o.getFirstDayOfWeek(),F=new b(b.UTC(y,0,1)),d=7;while(F.getUTCDay()!==f){F.setUTCDate(F.getUTCDate()-1);d--;}if(d<M){F.setUTCDate(F.getUTCDate()+7);}return F;}
function c(f,t){return Math.floor((t.valueOf()-f.valueOf())/m);}
var e={};
U.getEraByDate=function(C,y,M,d){var E=a(C),t=new Date(0).setUTCFullYear(y,M,d),o;for(var i=E.length-1;i>=0;i--){o=E[i];if(!o){continue;}if(o._start&&t>=o._startInfo.timestamp){return i;}if(o._end&&t<o._endInfo.timestamp){return i;}}};
U.getCurrentEra=function(C){var n=new Date();return this.getEraByDate(C,n.getFullYear(),n.getMonth(),n.getDate());};
U.getEraStartDate=function(C,E){var b=a(C),o=b[E]||b[0];if(o._start){return o._startInfo;}};
function a(C){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),E=e[C];if(!E){var E=o.getEraDates(C);if(!E[0]){E[0]={_start:"1-1-1"};}for(var i=0;i<E.length;i++){var b=E[i];if(!b){continue;}if(b._start){b._startInfo=p(b._start);}if(b._end){b._endInfo=p(b._end);}}e[C]=E;}return E;}
function p(d){var P=d.split("-"),y,M,D;if(P[0]==""){y=-parseInt(P[1],10);M=parseInt(P[2],10)-1;D=parseInt(P[3],10);}else{y=parseInt(P[0],10);M=parseInt(P[1],10)-1;D=parseInt(P[2],10);}return{timestamp:new Date(0).setUTCFullYear(y,M,D),year:y,month:M,day:D};}
return U;});
sap.ui.predefine('sap/ui/core/delegate/ItemNavigation',['jquery.sap.global','sap/ui/base/EventProvider','jquery.sap.keycodes'],function(q,E){"use strict";
var I=E.extend("sap.ui.core.delegate.ItemNavigation",{constructor:function(d,i,n){E.apply(this);this.oDomRef=null;if(d){this.setRootDomRef(d);}this.aItemDomRefs=[];if(i){this.setItemDomRefs(i);}this.iTabIndex=-1;this.iActiveTabIndex=!!n?-1:0;this.iFocusedIndex=-1;this.iSelectedIndex=-1;this.bCycling=true;this.bTableMode=false;this.iPageSize=-1;this._bMouseDownHappened=false;this.oDisabledModifiers={sapend:["alt","shift"],saphome:["alt","shift"]};}});
I.Events={BeforeFocus:"BeforeFocus",AfterFocus:"AfterFocus",BorderReached:"BorderReached",FocusAgain:"FocusAgain",FocusLeave:"FocusLeave"};
I.prototype.setDisabledModifiers=function(d){this.oDisabledModifiers=d;return this;};
I.prototype.getDisabledModifiers=function(d){return this.oDisabledModifiers;};
I.prototype.hasDisabledModifier=function(e){var d=this.oDisabledModifiers[e.type.replace("modifiers","")];if(Array.isArray(d)){for(var i=0;i<d.length;i++){if(e[d[i]+"Key"]){return true;}}}return false;};
I.prototype.setRootDomRef=function(d){this.oDomRef=d;if(!q(this.oDomRef).data("sap.INItem")){if(this.iFocusedIndex>=0){q(this.oDomRef).attr("tabIndex",this.iTabIndex);}else{q(this.oDomRef).attr("tabIndex",this.iActiveTabIndex);}}q(this.oDomRef).data("sap.INRoot",this);return this;};
I.prototype.getRootDomRef=function(){return this.oDomRef;};
I.prototype.getItemDomRefs=function(){return this.aItemDomRefs;};
I.prototype.setItemDomRefs=function(a){this.aItemDomRefs=a;if(this.iFocusedIndex>a.length-1){this.iFocusedIndex=a.length-1;}for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){var $=q(this.aItemDomRefs[i]);if(i==this.iFocusedIndex&&!$.data("sap.INRoot")){$.attr("tabIndex",this.iActiveTabIndex);}else if($.attr("tabindex")=="0"){$.attr("tabIndex",-1);}$.data("sap.INItem",true);$.data("sap.InNavArea",true);if($.data("sap.INRoot")&&i!=this.iFocusedIndex){$.data("sap.INRoot").setNestedItemsTabindex();}}}return this;};
I.prototype.setItemsTabindex=function(){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){var $=q(this.aItemDomRefs[i]);if($.is(":sapFocusable")){if(i==this.iFocusedIndex&&!$.data("sap.INRoot")){$.attr("tabIndex",this.iActiveTabIndex);}else{$.attr("tabIndex",-1);}}}}return this;};
I.prototype.setNestedItemsTabindex=function(){if(q(this.oDomRef).data("sap.INItem")){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]&&q(this.aItemDomRefs[i]).attr("tabindex")=="0"){q(this.aItemDomRefs[i]).attr("tabIndex",-1);}}}return this;};
I.prototype.destroy=function(){if(this.oDomRef){q(this.oDomRef).removeData("sap.INRoot");this.oDomRef=null;}if(this.aItemDomRefs){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){q(this.aItemDomRefs[i]).removeData("sap.INItem");q(this.aItemDomRefs[i]).removeData("sap.InNavArea");}}this.aItemDomRefs=null;}this._bItemTabIndex=undefined;this.iFocusedIndex=-1;};
I.prototype.setCycling=function(c){this.bCycling=c;return this;};
I.prototype.setTableMode=function(t,T){this.bTableMode=t;if(this.oConfiguration===undefined){this.oConfiguration=sap.ui.getCore().getConfiguration();}this.bTableList=t?T:false;return this;};
I.prototype.setPageSize=function(p){this.iPageSize=p;return this;};
I.prototype.setSelectedIndex=function(i){this.iSelectedIndex=i;return this;};
I.prototype.setColumns=function(c,n){this.iColumns=c;this.bNoColumnChange=n;return this;};
I.prototype.setHomeEndColumnMode=function(s,c){this._bStayInRow=s;this._bCtrlEnabled=c;return this;};
I.prototype.focusItem=function(i,e){q.sap.log.info("FocusItem: "+i+" iFocusedIndex: "+this.iFocusedIndex,"focusItem","ItemNavigation");if(i==this.iFocusedIndex&&this.aItemDomRefs[this.iFocusedIndex]==document.activeElement){this.fireEvent(I.Events.FocusAgain,{index:i,event:e});return;}if(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){if(this.bTableMode){var c=i%this.iColumns;var o=i;if(e&&e.keyCode==q.sap.KeyCodes.ARROW_RIGHT){if(c<this.iColumns-1){i+=this.oConfiguration.getRTL()?-1:1;}}else if(e&&e.keyCode==q.sap.KeyCodes.ARROW_LEFT){if(c>1){i-=this.oConfiguration.getRTL()?-1:1;}}else{if(c>1){i-=1;}}if(i!=o){this.focusItem(i,e);}}return;}this.fireEvent(I.Events.BeforeFocus,{index:i,event:e});this.setFocusedIndex(i);this.bISetFocus=true;if(e&&q(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot")){var a=q(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot");a._sFocusEvent=e.type;}q.sap.log.info("Set Focus on ID: "+this.aItemDomRefs[this.iFocusedIndex].id,"focusItem","ItemNavigation");q.sap.focus(this.aItemDomRefs[this.iFocusedIndex]);this.fireEvent(I.Events.AfterFocus,{index:i,event:e});};
I.prototype.setFocusedIndex=function(i){var $;if(this.aItemDomRefs.length<0){this.iFocusedIndex=-1;return this;}if(i<0){i=0;}if(i>this.aItemDomRefs.length-1){i=this.aItemDomRefs.length-1;}q(this.oDomRef).attr("tabIndex",this.iTabIndex);if(this.iFocusedIndex!==-1&&this.aItemDomRefs.length>this.iFocusedIndex){q(this.aItemDomRefs[this.iFocusedIndex]).attr("tabIndex",-1);$=q(this.aItemDomRefs[this.iFocusedIndex]);if($.data("sap.INRoot")&&i!=this.iFocusedIndex){q($.data("sap.INRoot").aItemDomRefs[$.data("sap.INRoot").iFocusedIndex]).attr("tabIndex",-1);}}this.iFocusedIndex=i;var f=this.aItemDomRefs[this.iFocusedIndex];$=q(this.aItemDomRefs[this.iFocusedIndex]);if(!$.data("sap.INRoot")){q(f).attr("tabIndex",this.iActiveTabIndex);}return this;};
I.prototype.getFocusedDomRef=function(){return this.aItemDomRefs[this.iFocusedIndex];};
I.prototype.getFocusedIndex=function(){return this.iFocusedIndex;};
I.prototype.onfocusin=function(e){var s=e.target;var i=0;if(s==this.oDomRef){if(!this._bItemTabIndex){this.setItemsTabindex();this._bItemTabIndex=true;}if(this._bMouseDownHappened){return;}var a;if(q(this.oDomRef).data("sap.INItem")&&this._sFocusEvent&&!q(this.oDomRef).data("sap.InNavArea")){switch(this._sFocusEvent){case"sapnext":a=0;break;case"sapprevious":a=this.aItemDomRefs.length-1;break;default:if(this.iSelectedIndex!=-1){a=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){a=this.iFocusedIndex;}else{a=0;}break;}this._sFocusEvent=undefined;}else{if(this.iSelectedIndex!=-1){a=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){a=this.iFocusedIndex;}else{a=0;}}this.focusItem(a,e);if(this.iFocusedIndex==-1){for(i=a+1;i<this.aItemDomRefs.length;i++){this.focusItem(i,e);if(this.iFocusedIndex==i){break;}}if(this.iFocusedIndex==-1&&a>0){for(i=a-1;i>=0;i--){this.focusItem(i,e);if(this.iFocusedIndex==i){break;}}}}e.preventDefault();e.stopPropagation();}else if(!this.bISetFocus){if(this.aItemDomRefs&&e.target!=this.aItemDomRefs[this.iFocusedIndex]){for(i=0;i<this.aItemDomRefs.length;i++){if(e.target==this.aItemDomRefs[i]){this.focusItem(i,e);break;}}}else{this.fireEvent(I.Events.AfterFocus,{index:this.iFocusedIndex,event:e});}}this.bISetFocus=false;};
I.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!q.sap.containsOrEquals(this.oDomRef,sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){var i;if(this.iSelectedIndex!=-1){i=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){i=this.iFocusedIndex;}else{i=0;}this.setFocusedIndex(i);var d;if(q(this.oDomRef).data("sap.INItem")){var p;d=q(this.oDomRef);while(!p){d=d.parent();if(d.data("sap.INRoot")){p=d.get(0);}}if(!e.relatedControlId||q.sap.containsOrEquals(p,sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){q(this.aItemDomRefs[this.iFocusedIndex]).attr("tabIndex",-1);}}d=q(this.oDomRef);if(d.data("sap.InNavArea")===false){d.data("sap.InNavArea",true);}this.fireEvent(I.Events.FocusLeave,{index:i,event:e});}};
I.prototype.onmousedown=function(e){var s=e.target;var c=function(d,o){var f=false;var C=q(d);while(!C.is(":sapFocusable")&&C.get(0)!=o){C=C.parent();}if(C.get(0)!=o){f=true;}return f;};if(q.sap.containsOrEquals(this.oDomRef,s)){for(var i=0;i<this.aItemDomRefs.length;i++){var o=this.aItemDomRefs[i];if(q.sap.containsOrEquals(o,s)){if(!this.bTableMode){this.focusItem(i,e);}else{if(o===s||!c(s,o)){this.focusItem(i,e);}}return;}}if(s==this.oDomRef){this._bMouseDownHappened=true;var t=this;window.setTimeout(function(){t._bMouseDownHappened=false;},20);}}};
I.prototype.onsapnext=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(q(this.oDomRef).data("sap.InNavArea")){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.iFocusedIndex,f=true,b=false;if(i>-1){if(this.bTableMode){var r=this.aItemDomRefs.length/this.iColumns,R=Math.floor(i/this.iColumns),c=i%this.iColumns;if(e.keyCode==q.sap.KeyCodes.ARROW_DOWN){if(R<r-1){i+=this.iColumns;}}else{if(c<this.iColumns-1){i+=1;}}}else{do{if(this.iColumns>1&&e.keyCode==q.sap.KeyCodes.ARROW_DOWN){if((i+this.iColumns)>=this.aItemDomRefs.length){if(!this.bNoColumnChange){if((i%this.iColumns)<(this.iColumns-1)){i=(i%this.iColumns)+1;}else if(this.bCycling){i=0;}}else{i=this.iFocusedIndex;b=true;}}else{i=i+this.iColumns;}}else{if(i==this.aItemDomRefs.length-1){if(q(this.oDomRef).data("sap.INItem")){return;}else if(this.bCycling){i=0;}else{i=this.iFocusedIndex;b=true;}}else{i++;}}if(i===this.iFocusedIndex){if(f){f=false;}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the next one");}}}while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable"));}this.focusItem(i,e);if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();}};
I.prototype.onsapnextmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapnext(e);};
I.prototype.onsapprevious=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(q(this.oDomRef).data("sap.InNavArea")){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.iFocusedIndex,f=true,b=false;var c=0;if(i>-1){if(this.bTableMode){var r=Math.floor(i/this.iColumns);c=i%this.iColumns;if(e.keyCode==q.sap.KeyCodes.ARROW_UP){if(r>0){i-=this.iColumns;}}else{if(c>0){i-=1;}}}else{do{if(this.iColumns>1&&e.keyCode==q.sap.KeyCodes.ARROW_UP){if((i-this.iColumns)<0){if(!this.bNoColumnChange){c=0;if((i%this.iColumns)>0){c=(i%this.iColumns)-1;}else if(this.bCycling){c=Math.min(this.iColumns-1,this.aItemDomRefs.length-1);}if(i===0&&c===0){i=0;}else{var R=Math.ceil(this.aItemDomRefs.length/this.iColumns);i=c+((R-1)*this.iColumns);if(i>=this.aItemDomRefs.length){i=i-this.iColumns;}}}else{i=this.iFocusedIndex;b=true;}}else{i=i-this.iColumns;}}else{if(i==0){if(q(this.oDomRef).data("sap.INItem")){return;}else if(this.bCycling){i=this.aItemDomRefs.length-1;}else{i=this.iFocusedIndex;b=true;}}else{i--;}}if(i==this.iFocusedIndex){if(f){f=false;}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the previous one");}}}while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable"));}this.focusItem(i,e);if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();}};
I.prototype.onsappreviousmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapprevious(e);};
I.prototype.onsappageup=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var b=false;if(this.iPageSize>0){i=this.iFocusedIndex;if(i>-1){i=i-this.iPageSize;while(i>0&&!q(this.aItemDomRefs[i]).is(":sapFocusable")){i--;}if(i<0){if(!this.bNoColumnChange){i=0;}else{i=this.iFocusedIndex;b=true;}}this.focusItem(i,e);}}else if(this.bTableMode){i=this.iFocusedIndex%this.iColumns;this.focusItem(i,e);}if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();};
I.prototype.onsappagedown=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var b=false;if(this.iPageSize>0){i=this.iFocusedIndex;if(i>-1){i=i+this.iPageSize;while(i<this.aItemDomRefs.length-1&&!q(this.aItemDomRefs[i]).is(":sapFocusable")){i++;}if(i>this.aItemDomRefs.length-1){if(!this.bNoColumnChange){i=this.aItemDomRefs.length-1;}else{i=this.iFocusedIndex;b=true;}}this.focusItem(i,e);}}else if(this.bTableMode){var r=this.aItemDomRefs.length/this.iColumns,c=this.iFocusedIndex%this.iColumns;i=(r-1)*this.iColumns+c;this.focusItem(i,e);}if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();};
I.prototype.onsaphome=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var r=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns;}}else{if(!!(e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return;}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns;}else{while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){i++;if(i==this.aItemDomRefs.length){return;}}}}this.focusItem(i,e);e.preventDefault();e.stopPropagation();};
I.prototype.onsaphomemodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsaphome(e);};
I.prototype.onsapend=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.aItemDomRefs.length-1;var r=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns+this.iColumns-1;}}else{if(!!(e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return;}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){r=Math.floor(this.iFocusedIndex/this.iColumns);i=(r+1)*this.iColumns-1;if(i>=this.aItemDomRefs.length){i=this.aItemDomRefs.length-1;}}else{while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){i--;if(i<0){return;}}}}this.focusItem(i,e);e.preventDefault();e.stopPropagation();};
I.prototype.onsapendmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapend(e);};
I.prototype.setTabIndex0=function(){this.iTabIndex=0;this.iActiveTabIndex=0;};
I.prototype.onkeyup=function(e){if(e.keyCode==q.sap.KeyCodes.F2){var d=q(this.oDomRef);if(d.data("sap.InNavArea")){d.data("sap.InNavArea",false);}else if(d.data("sap.InNavArea")===false){d.data("sap.InNavArea",true);}e.preventDefault();e.stopPropagation();}};
return I;});
sap.ui.predefine('sap/ui/core/delegate/ScrollEnablement',['jquery.sap.global','sap/ui/Device','sap/ui/base/Object','sap/ui/core/ResizeHandler','jquery.sap.keycodes','jquery.sap.trace'],function(q,D,B,R){"use strict";var $=q;
var S=B.extend("sap.ui.core.delegate.ScrollEnablement",{
constructor:function(c,s,C){B.apply(this);this._oControl=c;this._oControl.addDelegate(this);this._sContentId=s;this._sContainerId=C.scrollContainerId;this._bHorizontal=!!C.horizontal;this._bVertical=!!C.vertical;this._scrollX=0;this._scrollY=0;this._scrollCoef=0.9;i(this);if(this._init){this._init.apply(this,arguments);}},
setHorizontal:function(h){this._bHorizontal=!!h;this._setOverflow&&this._setOverflow();},
setVertical:function(v){this._bVertical=!!v;this._setOverflow&&this._setOverflow();},
getHorizontal:function(){return this._bHorizontal;},
getVertical:function(){return this._bVertical;},
setBounce:function(b){},
setPullDown:function(c){this._oPullDown=c;return this;},
setGrowingList:function(s,a){this._fnScrollLoadCallback=s;this._sScrollLoadDirection=a;return this;},
setIconTabBar:function(I,s,f){this._oIconTabBar=I;this._fnScrollEndCallback=q.proxy(s,I);this._fnScrollStartCallback=q.proxy(f,I);return this;},
scrollTo:function(x,y,t){this._scrollX=x;this._scrollY=y;this._scrollTo(x,y,t);return this;},
getChildPosition:function(e){var E=e instanceof q?e:$(e),o=E.position(),O=E.offsetParent(),a;while(!O.is(this._$Container)){a=O.position();o.top+=a.top;o.left+=a.left;O=O.offsetParent();}return o;},
scrollToElement:function(e,t,o){o=o||[0,0];if(!this._$Container[0].contains(e)||e.style.display==="none"||e.offsetParent.nodeName.toUpperCase()==="HTML"){return this;}var E=$(e),s=this.getChildPosition(E),l=this.getScrollLeft()+s.left+o[0],T=this.getScrollTop()+s.top+o[1];if(this._bFlipX){l=this.getScrollLeft()-(s.left-this._$Container.width())-E.width();}this._scrollTo(l,T,t);return this;},
destroy:function(){if(this._exit){this._exit();}if(this._oControl){this._oControl.removeDelegate(this);this._oControl=undefined;}},
refresh:function(){if(this._refresh){this._refresh();}},
_useDefaultScroll:function(t){return t.isContentEditable;},
onkeydown:function(e){if(this._useDefaultScroll(e.target)){return;}var c=this._$Container[0];if(e.altKey&&this.getHorizontal()){switch(e.keyCode){case q.sap.KeyCodes.PAGE_UP:this._customScrollTo(this._scrollX-c.clientWidth,this._scrollY,e);break;case q.sap.KeyCodes.PAGE_DOWN:this._customScrollTo(this._scrollX+c.clientWidth,this._scrollY,e);break;}}if(e.ctrlKey){switch(e.keyCode){case q.sap.KeyCodes.ARROW_UP:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY-c.clientHeight*this._scrollCoef,e);}break;case q.sap.KeyCodes.ARROW_DOWN:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY+c.clientHeight*this._scrollCoef,e);}break;case q.sap.KeyCodes.ARROW_LEFT:if(this.getHorizontal()){this._customScrollTo(this._scrollX-c.clientWidth,this._scrollY,e);}break;case q.sap.KeyCodes.ARROW_RIGHT:if(this.getHorizontal()){this._customScrollTo(this._scrollX+c.clientWidth,this._scrollY,e);}break;case q.sap.KeyCodes.HOME:if(this.getHorizontal()){this._customScrollTo(0,this._scrollY,e);}if(this.getVertical()){this._customScrollTo(this._scrollX,0,e);}break;case q.sap.KeyCodes.END:var l=c.scrollWidth-c.clientWidth;var t=c.scrollHeight-c.clientHeight;if(!this.getHorizontal()){t=this._scrollY;}if(!this.getVertical()){l=this._scrollX;}this._customScrollTo(l,t,e);break;}}},
_customScrollTo:function(l,t,e){var N=e.target.nodeName;if(N!="INPUT"&&N!="TEXTAREA"){e.preventDefault();e.setMarked();this._scrollTo(l,t);}}
});
var n={getScrollTop:function(){return this._scrollY||0;},getScrollLeft:function(){return this._scrollX||0;},getScrollHeight:function(){var c=this._$Container;return(c&&c[0])?c[0].scrollHeight:0;},getMaxScrollTop:function(){var c=this._$Container;return(c&&c[0])?c[0].scrollHeight-c[0].clientHeight:-1;},_cleanup:function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}},_setOverflow:function(){var c=this._$Container;if(!c||!c[0]){return;}if(D.os.ios){c.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"scroll":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"scroll":"hidden").css("-webkit-overflow-scrolling","touch");}else{c.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"auto":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"auto":"hidden");}},_refresh:function(){var c=this._$Container;if(!(c&&c.length)){return;}if(this._oPullDown&&this._oPullDown._bTouchMode){var d=this._oPullDown.getDomRef();if(d){d.style.marginTop=this._oPullDown._iState==2?"":"-"+d.offsetHeight+"px";}}if(c.scrollTop()!=this._scrollY){c.scrollTop(this._scrollY);}if(!(this._oPullDown&&this._oPullDown._bTouchMode)&&!this._fnScrollLoadCallback&&!D.browser.msie){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}},_onScroll:function(){var c=this._$Container,s=c.scrollTop(),v=s-this._scrollY;q.sap.interaction.notifyStepStart(this._oControl);this._scrollX=c.scrollLeft();this._scrollY=s;if(this._fnScrollLoadCallback){if(this._sScrollLoadDirection=="Upwards"){if(v<0&&s<10){this._fnScrollLoadCallback();}}else if(v>=0&&c[0].scrollHeight-s-c[0].clientHeight<100){this._fnScrollLoadCallback();}}if(this._oIconTabBar&&this._fnScrollEndCallback){this._fnScrollEndCallback();}},_onStart:function(e){var c=this._$Container[0];if(!c){return;}this._bDoDrag=this._bDragScroll;var p=e.touches?e.touches[0]:e;this._iX=p.pageX;this._iY=p.pageY;this._bPullDown=false;this._iDirection="";},_onTouchMove:function(e){var c=this._$Container[0];var p=e.touches?e.touches[0]:e;var d=p.pageX-this._iX;var a=p.pageY-this._iY;if(this._iDirection==""){if(d!=0||a!=0){this._iDirection=Math.abs(a)>Math.abs(d)?"v":"h";}if(this._oPullDown&&this._oPullDown._bTouchMode&&this._iDirection=="v"&&c.scrollTop<=1){if(a>Math.abs(d)){this._bPullDown=true;}}}if(this._bPullDown===true){var b=this._oPullDown.getDomRef();var t=e.touches[0].pageY-this._iY-b.offsetHeight;if(t>20){t=20;}b.style.marginTop=t+"px";this._oPullDown.doPull(t);e.preventDefault();this._bDoDrag=false;}if(this._bDoDrag){var s=c.scrollLeft,f=c.scrollTop;if(this._bHorizontal){if(this._bFlipX){c.scrollLeft=s-this._iX+p.pageX;}else{c.scrollLeft=s+this._iX-p.pageX;}}if(this._bVertical){c.scrollTop=f+this._iY-p.pageY;}if((c.scrollLeft!=s)||(c.scrollTop!=f)){e.setMarked&&e.setMarked();e.preventDefault();}this._iX=p.pageX;this._iY=p.pageY;return;}},_onEnd:function(e){q.sap.interaction.notifyEventStart(e);if(this._oPullDown&&this._oPullDown._bTouchMode){this._oPullDown.doScrollEnd();this._refresh();}if(this._bDragScroll&&this._iDirection){e.setMarked&&e.setMarked();}},_onMouseDown:function(e){if(this._bDragScroll&&e.button==0){this._bScrolling=true;this._onStart(e);}},_onMouseMove:function(E){if(this._bScrolling){var e=E.originalEvent||E;var b=e.buttons||e.which;if(b==1||E.pressure){var c=this._$Container[0];if(this._bHorizontal){if(this._bFlipX){c.scrollLeft=c.scrollLeft-this._iX+E.pageX;}else{c.scrollLeft=c.scrollLeft+this._iX-E.pageX;}}if(this._bVertical){c.scrollTop=c.scrollTop+this._iY-E.pageY;}this._iX=E.pageX;this._iY=E.pageY;}}},_onMouseUp:function(){if(this._bScrolling){this._bScrolling=false;this._onEnd();}},onBeforeRendering:function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}var c=this._$Container;if(c){if(c.height()>0){this._scrollX=c.scrollLeft();this._scrollY=c.scrollTop();}c.off();}},onAfterRendering:function(){var c=this._$Container=this._sContainerId?$.sap.byId(this._sContainerId):$.sap.byId(this._sContentId).parent();var _=q.proxy(this._refresh,this);var e=c.is(":visible");this._setOverflow();if(this._scrollX!==0||this._scrollY!==0){this._scrollTo(this._scrollX,this._scrollY);}this._refresh();if(!e||D.browser.msie||this._oPullDown||this._fnScrollLoadCallback){this._sResizeListenerId=R.register(c[0],_);}c.on("scroll",this._onScroll.bind(this));var C=c[0];function a(E,l){E.split(" ").forEach(function(s){C&&C.addEventListener(s,l);});}function o(E){return E.pointerType=="touch"?this._onStart(E):this._onMouseDown(E);}function b(E){return E.pointerType=="touch"?this._onTouchMove(E):this._onMouseMove(E);}function d(E){return E.pointerType=="touch"?this._onEnd(E):this._onMouseUp(E);}if(D.support.pointer&&D.system.desktop){if(this._bDragScroll){a("pointerdown",o.bind(this));a("pointermove",b.bind(this));a("pointerup pointercancel pointerleave",d.bind(this));}}else if(D.support.touch){if(this._bDragScroll||this._oPullDown&&this._oPullDown._bTouchMode){c.on("touchcancel touchend",this._onEnd.bind(this)).on("touchstart",this._onStart.bind(this)).on("touchmove",this._onTouchMove.bind(this));}}else if(this._bDragScroll){c.on("mouseup mouseleave",this._onMouseUp.bind(this)).mousedown(this._onMouseDown.bind(this)).mousemove(this._onMouseMove.bind(this));}},_readActualScrollPosition:function(){if(this._$Container.width()>0){this._scrollX=this._$Container.scrollLeft();}if(this._$Container.height()>0){this._scrollY=this._$Container.scrollTop();}},_scrollTo:function(x,y,t){if(this._$Container.length>0){if(t>0){this._$Container.finish().animate({scrollTop:y,scrollLeft:x},t,q.proxy(this._readActualScrollPosition,this));}else{this._$Container.scrollTop(y);this._$Container.scrollLeft(x);this._readActualScrollPosition();}}}};
function i(s){var d={_init:function(c,a,C){if($.event&&$.event.special&&$.event.special.swipe&&$.event.special.swipe.scrollSupressionThreshold<120){$.event.special.swipe.scrollSupressionThreshold=120;}$.extend(this,n);if(C.nonTouchScrolling===true){this._bDragScroll=true;}if(sap.ui.getCore().getConfiguration().getRTL()){this._scrollX=9999;if(D.browser.msie||D.browser.edge){this._bFlipX=true;}}},_exit:function(){if(this._cleanup){this._cleanup();}}};$.extend(s,d);}
return S;});
sap.ui.predefine('sap/ui/core/dnd/DragAndDrop',["jquery.sap.global","sap/ui/Device","../UIArea"],function(q,D,U){"use strict";var a={},d=null,o=null,v=null,V=[],b=[],c=null,$,g,C,t;
function e(E,S){if(!E){return;}if(E.addStyleClass){E.addStyleClass(S);}else{E.$().addClass(S);}}
function r(E,S){if(!E){return;}if(E.removeStyleClass){E.removeStyleClass(S);}else{E.$().removeClass(S);}}
function f(E,i){var y=q(E.target).control(0,true);if(!y){return;}var N=q.Event(null,E);N.type=i;y.getUIArea()._handleEvent(N);}
function s(d,E){if(D.browser.msie||!d||!d.getDragGhost){return;}var i=d.getDragGhost();if(!i){return;}if(!g){g=q('<div class="sapUiDnDGhostContainer"></div>');q(document.body).append(g);}g.append(i);window.setTimeout(function(){g.empty();},0);var O=E.originalEvent;O.dataTransfer.setDragImage(i,O.offsetX,O.offsetY);}
function h(E){var i={},I,y=E.originalEvent.dataTransfer,z=function(T,A){if(y&&T=="text"||(D.browser!="msie"&&D.browser!="edge")){y.setData(T,A);}};return{setData:function(K,A){A=""+A;i[K]=A;z(K,A);},getData:function(K){return i[K];},setTextData:function(A){A=""+A;i["text/plain"]=A;i["text"]=A;z("text/plain",A);z("text",A);},getTextData:function(){return i["text/plain"];},setComplexData:function(K,A){i[K]=A;},getComplexData:function(K){return i[K];},getIndicator:function(){return $&&$[0];},setIndicatorConfig:function(A){I=A;},getIndicatorConfig:function(A){return I;},getDragControl:function(){return d;},getDropControl:function(){return v;},setDropControl:function(A){v=A;},getDropInfo:function(){return b[0]||null;},getDropPosition:function(){return C;}};}
function j(E){l();r(d,"sapUiDnDDragging");d=o=v=c=null;C="";V=[];b=[];}
function k(){if($){return $;}$=q("<div class='sapUiDnDIndicator'></div>");q(sap.ui.getCore().getStaticAreaRef()).append($);return $;}
function l(){if($){$.removeAttr("style").hide();}}
function m(E,i,y,z){if(!i){return;}var I=E.dragSession&&E.dragSession.getIndicatorConfig(),A=i.getBoundingClientRect(),P=window.pageYOffset,B=window.pageXOffset,F=k(),R,S={},G={top:A.top+P,bottom:A.bottom+P,left:A.left+B,right:A.right+B,width:A.width,height:A.height};if(!y||y=="On"){R="On";z="";}else if(z=="Horizontal"){var H=E.pageX-G.left;S.height=G.height;S.top=G.top;if(y=="Between"){S.width="";if(H<G.width*0.5){R="Before";S.left=G.left;}else{R="After";S.left=G.right;}}else if(y=="OnOrBetween"){if(H<G.width*0.25){R="Before";S.left=G.left;S.width="";}else if(H>G.width*0.75){R="After";S.left=G.right;S.width="";}else{R="On";}}}else{var J=E.pageY-G.top;S.width=G.width;S.left=G.left;if(y=="Between"){S.height="";if(J<G.height*0.5){R="Before";S.top=G.top;}else{R="After";S.top=G.bottom;}}else if(y=="OnOrBetween"){if(J<G.height*0.25){R="Before";S.top=G.top;S.height="";}else if(J>G.height*0.75){R="After";S.top=G.bottom;S.height="";}else{R="On";}}}if(I&&I.display=="none"){return R;}if(R=="On"){S.top=G.top;S.left=G.left;S.width=G.width;S.height=G.height;y=R;}else{y="Between";}F.attr("data-drop-layout",z);F.attr("data-drop-position",y);F.css(q.extend(S,I)).show();return R;}
function n(i){var P=i.getParent(),S=(i.getDragDropConfig)?i.getDragDropConfig():[],y=(P&&P.getDragDropConfig)?P.getDragDropConfig():[];return S.concat(y);}
function p(d){var i=n(d);return i.filter(function(y){return y.isDraggable(d);});}
function u(o,i,E){var y=n(o);i=i||[];return y.filter(function(z){return!z.isA("sap.ui.core.dnd.IDragInfo");}).concat(i).filter(function(z){if(!z.isDroppable(o,E)){return false;}var A=z.getGroupName();if(!A){return true;}return i.some(function(B){return B.getGroupName()==A;});});}
function w(E,i){E.preventDefault();var y=i.getDropEffect().toLowerCase();E.originalEvent.dataTransfer.dropEffect=y;}
function x(E,i,v){var T=i.getTargetAggregation();if(!T){return m(E,v.getDomRef());}var y;if(E.getMark("DragWithin")==T){y=v.getDomRefForSetting(T);}y=y||v.getDomRef();return m(E,y,i.getDropPosition(true),i.getDropLayout(true));}
a.preprocessEvent=function(E){if(c&&E.type.indexOf("dr")==0){E.dragSession=c;}var i="onbefore"+E.type;if(a[i]){a[i](E);}};
a.postprocessEvent=function(E){var i="onafter"+E.type;if(a[i]){a[i](E);}};
a.onbeforedragstart=function(E){if(!E.target.draggable){return;}if(/^(input|textarea)$/i.test(document.activeElement.tagName)){return;}d=q(E.target).control(0,true);if(!d){return;}V=p(d);if(!V.length){return;}if(D.browser.firefox&&E.originalEvent.dataTransfer.types.length===0){E.originalEvent.dataTransfer.setData("ui5/dummyDataForFirefox","data");}E.dragSession=c=h(E);};
a.onafterdragstart=function(E){if(!V.length||E.isDefaultPrevented()){j();return;}V=E.isMarked("NonDraggable")?[]:V.filter(function(i){return i.fireDragStart(E);});if(!V.length){E.preventDefault();j();return;}s(d,E);e(d,"sapUiDnDDragging");};
a.onbeforedragenter=function(E){var y=q(E.target).control(0,true);if(y&&o===y){E.setMark("DragWithin","SameControl");}else{t=Date.now();o=y;}var z=[];v=y;for(var i=0;i<20&&v;i++,v=v.getParent()){z=u(v,V,E);if(z.length){break;}}if(E.getMark("DragWithin")!="SameControl"){b=z;if(c){c.setIndicatorConfig(null);}}if(!b.length){v=null;}else if(!c){E.dragSession=c=h(E);}};
a.onafterdragenter=function(E){if(!v||E.isMarked("NonDroppable")){b=[];}else if(E.getMark("DragWithin")!="SameControl"){b=b.filter(function(y){return y.fireDragEnter(E);});}var i=b[0];if(!i||i.getDropEffect()=="None"){l();C="";}else{w(E,i);C=x(E,i,v);}};
a.onbeforedragover=function(E){var i=Date.now();if(i-t>=1000){f(E,"longdragover");t=i;}};
a.onafterdragover=function(E){var i=b[0];if(!i||i.getDropEffect()=="None"){return;}b.forEach(function(y){y.fireDragOver(E);});w(E,i);if(i&&i.getDropPosition(true)=="On"){return;}C=x(E,i,v);};
a.onbeforedrop=function(E){if(b.length){E.preventDefault();}};
a.onafterdrop=function(E){b.forEach(function(i){i.fireDrop(E);});this.iDragEndTimer=window.requestAnimationFrame(this.onafterdragend.bind(this,E));};
a.onafterdragend=function(E){this.iDragEndTimer=window.cancelAnimationFrame(this.iDragEndTimer);V.forEach(function(i){i.fireDragEnd(E);});j();};
U.addEventPreprocessor(a.preprocessEvent);U.addEventPostprocessor(a.postprocessEvent);return a;},true);
sap.ui.predefine('sap/ui/core/dnd/DragDropBase',['../Element','../library','./DragAndDrop'],function(E,l){"use strict";
var D=E.extend("sap.ui.core.dnd.DragDropBase",{metadata:{"abstract":true,library:"sap.ui.core",properties:{groupName:{type:"string",defaultValue:null,invalidate:false},enabled:{type:"boolean",defaultValue:true}}}});
D.prototype.isDraggable=function(c){return false;};
D.prototype.isDroppable=function(c,e){return false;};
D.prototype.setEnabled=function(e){return this.setProperty("enabled",e,!this.isA("sap.ui.core.dnd.IDragInfo"));};
D.prototype.setProperty=function(p,v,s){s=s||(this.getMetadata().getProperty(p).appData||{}).invalidate===false;return E.prototype.setProperty.call(this,p,v,s);};
return D;});
sap.ui.predefine('sap/ui/core/dnd/DragDropInfo',["./DragInfo","./DropInfo"],function(D,a){"use strict";
var b=a.extend("sap.ui.core.dnd.DragDropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDragInfo","sap.ui.core.dnd.IDropInfo"],properties:{sourceAggregation:{type:"string",defaultValue:null}},associations:{targetElement:{type:"sap.ui.core.Element",multiple:false}},events:{dragStart:{allowPreventDefault:true},dragEnd:{}}}});
b.prototype.isDraggable=D.prototype.isDraggable;b.prototype.fireDragEnd=D.prototype.fireDragEnd;b.prototype.fireDragStart=D.prototype.fireDragStart;
b.prototype.getDropTarget=function(){var t=this.getTargetElement();if(t){return sap.ui.getCore().byId(t);}return this.getParent();};
b.prototype.setGroupName=function(){jQuery.sap.log.error("groupName property must not be set on "+this);return this;};
return b;},true);
sap.ui.predefine('sap/ui/core/dnd/DragInfo',["jquery.sap.global","./DragDropBase"],function(q,D){"use strict";
var a=D.extend("sap.ui.core.dnd.DragInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDragInfo"],properties:{sourceAggregation:{type:"string",defaultValue:null}},events:{dragStart:{allowPreventDefault:true},dragEnd:{}}}});
a.prototype.isDraggable=function(c){if(!this.getEnabled()){return false;}var d=this.getParent();if(!d){return false;}var s=this.getSourceAggregation();var m=d.getMetadata().getDragDropInfo(s);if(!m.draggable){q.sap.log.warning((s?s+" aggregation of ":"")+d+" is not configured to be draggable");return false;}if(d===c&&!s){return true;}if(c.getParent()===d&&s===c.sParentAggregationName){return true;}return false;};
a.prototype.fireDragStart=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragStart",{dragSession:d,browserEvent:e.originalEvent,target:d.getDragControl()},true);};
a.prototype.fireDragEnd=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragEnd",{dragSession:d,browserEvent:e.originalEvent,target:d.getDragControl()});};
return a;},true);
sap.ui.predefine('sap/ui/core/dnd/DropInfo',["jquery.sap.global","./DragDropBase"],function(q,D){"use strict";
var a=D.extend("sap.ui.core.dnd.DropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{targetAggregation:{type:"string",defaultValue:null,invalidate:false},dropEffect:{type:"sap.ui.core.dnd.DropEffect",defaultValue:"Move",invalidate:false},dropPosition:{type:"sap.ui.core.dnd.DropPosition",defaultValue:"On",invalidate:false},dropLayout:{type:"sap.ui.core.dnd.DropLayout",defaultValue:"Default",invalidate:false}},events:{dragEnter:{allowPreventDefault:true},dragOver:{},drop:{}}}});
a.prototype.getDropTarget=function(){return this.getParent();};
a.prototype.isDroppable=function(c,e){this.sTemporaryDropPosition="";if(!this.getEnabled()){return false;}var d=this.getDropTarget();if(!d){return false;}var t=this.getTargetAggregation();var m=d.getMetadata().getDragDropInfo(t);if(!m.droppable){q.sap.log.warning((t?t+" aggregation of ":"")+d+" is not configured to be droppable");return false;}var t=this.getTargetAggregation();if(d===c&&!t){return true;}if(c.getParent()===d&&t===c.sParentAggregationName){return true;}if(e&&t&&d===c){var A=c.getDomRefForSetting(t);if(A&&A!=e.target&&A.contains(e.target)){e.setMark("DragWithin",t);this.sTemporaryDropPosition="On";return true;}}return false;};
a.prototype.getDropPosition=function(c){if(c&&this.sTemporaryDropPosition){return this.sTemporaryDropPosition;}return this.getProperty("dropPosition");};
a.prototype.getDropLayout=function(d){var s=this.getProperty("dropLayout");if(!d||s!="Default"){return s;}return this.getDropTarget().getMetadata().getDragDropInfo(this.getTargetAggregation()).layout;};
a.prototype.fireDragEnter=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragEnter",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d.getDropControl()},true);};
a.prototype.fireDragOver=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragOver",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d.getDropControl(),dropPosition:d.getDropPosition()});};
a.prototype.fireDrop=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;this.fireEvent("drop",{dragSession:e.dragSession,browserEvent:e.originalEvent,dropPosition:d.getDropPosition(),draggedControl:d.getDragControl(),droppedControl:d.getDropControl()});};
return a;},true);
sap.ui.predefine('sap/ui/core/format/DateFormat',['jquery.sap.global','sap/ui/core/library','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/date/UniversalDate','jquery.sap.strings'],function(q,l,L,a,U){"use strict";var C=l.CalendarType;var D=function(){throw new Error();};var c={};D.oDateInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(o,s,g){return o.getDatePattern(s,g);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["FullYear","Quarter","Month","Week","Date"]};D.oDateTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(o,s,g){var S=s.indexOf("/");if(S>0){return o.getCombinedDateTimePattern(s.substr(0,S),s.substr(S+1),g);}else{return o.getCombinedDateTimePattern(s,s,g);}},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};D.oTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(o,s,g){return o.getTimePattern(s,g);},oRequiredParts:{"text":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};
D.getInstance=function(F,o){return this.getDateInstance(F,o);};
D.getDateInstance=function(F,o){return this.createInstance(F,o,this.oDateInfo);};
D.getDateTimeInstance=function(F,o){return this.createInstance(F,o,this.oDateTimeInfo);};
D.getTimeInstance=function(F,o){return this.createInstance(F,o,this.oTimeInfo);};
function b(F){var P=F.oLocaleData.getIntervalPattern("",F.oFormatOptions.calendarType);P=P.replace(/[^\{\}01 ]/,"-");return P.replace(/\{(0|1)\}/g,F.oFormatOptions.pattern);}
D.createInstance=function(F,o,i){var g=Object.create(this.prototype);if(F instanceof L){o=F;F=undefined;}if(!o){o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}g.oLocale=o;g.oLocaleData=a.getInstance(o);g.oFormatOptions=q.extend(false,{},i.oDefaultFormatOptions,F);if(!g.oFormatOptions.calendarType){g.oFormatOptions.calendarType=sap.ui.getCore().getConfiguration().getCalendarType();}if(!g.oFormatOptions.pattern){if(g.oFormatOptions.format){g.oFormatOptions.pattern=g.oLocaleData.getCustomDateTimePattern(g.oFormatOptions.format,g.oFormatOptions.calendarType);}else{g.oFormatOptions.pattern=i.getPattern(g.oLocaleData,g.oFormatOptions.style,g.oFormatOptions.calendarType);}}if(g.oFormatOptions.interval){if(g.oFormatOptions.format){g.intervalPatterns=g.oLocaleData.getCustomIntervalPattern(g.oFormatOptions.format,null,g.oFormatOptions.calendarType);if(typeof g.intervalPatterns==="string"){g.intervalPatterns=[g.intervalPatterns];}g.intervalPatterns.push(g.oLocaleData.getCustomDateTimePattern(g.oFormatOptions.format,g.oFormatOptions.calendarType));}else{g.intervalPatterns=[g.oLocaleData.getCombinedIntervalPattern(g.oFormatOptions.pattern,g.oFormatOptions.calendarType),g.oFormatOptions.pattern];}var s=b(g);g.intervalPatterns.push(s);}if(!g.oFormatOptions.fallback){if(!i.oFallbackFormats){i.oFallbackFormats={};}var h=o.toString(),j=g.oFormatOptions.calendarType,k=h+"-"+j,P,n;if(g.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){k=k+"-"+g.oFormatOptions.pattern;}if(g.oFormatOptions.interval){k=k+"-"+"interval";}var t=i.oFallbackFormats[k]?Object.assign({},i.oFallbackFormats[k]):undefined;if(!t){n=i.aFallbackFormatOptions;if(i.bShortFallbackFormatOptions){P=i.getPattern(g.oLocaleData,"short");n=n.concat(D._createFallbackOptionsWithoutDelimiter(P));}if(g.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){n=D._createFallbackOptionsWithoutDelimiter(g.oFormatOptions.pattern).concat(n);}t=D._createFallbackFormat(n,j,o,i,g.oFormatOptions.interval);}g.aFallbackFormats=t;}g.oRequiredParts=i.oRequiredParts;g.aRelativeScales=i.aRelativeScales;g.aRelativeParseScales=i.aRelativeParseScales;g.aIntervalCompareFields=i.aIntervalCompareFields;g.init();return g;};
D.prototype.init=function(){var s=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData.getMonths("abbreviated",s);this.aMonthsWide=this.oLocaleData.getMonths("wide",s);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",s);this.aMonthsAbbrevSt=this.oLocaleData.getMonthsStandAlone("abbreviated",s);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",s);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",s);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",s);this.aDaysWide=this.oLocaleData.getDays("wide",s);this.aDaysNarrow=this.oLocaleData.getDays("narrow",s);this.aDaysShort=this.oLocaleData.getDays("short",s);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",s);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",s);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",s);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",s);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",s);this.aQuartersWide=this.oLocaleData.getQuarters("wide",s);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",s);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",s);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",s);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",s);this.aErasNarrow=this.oLocaleData.getEras("narrow",s);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",s);this.aErasWide=this.oLocaleData.getEras("wide",s);this.aDayPeriods=this.oLocaleData.getDayPeriods("abbreviated",s);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray);};
D._createFallbackFormat=function(F,s,o,i,I){return F.map(function(O){var g=Object.assign({},O);if(I){g.interval=true;}g.calendarType=s;g.fallback=true;var h=D.createInstance(g,o,i);h.bIsFallback=true;return h;});};
D._createFallbackOptionsWithoutDelimiter=function(B){var g=/[^dMyGU]/g,o={regex:/d+/g,replace:"dd"},M={regex:/M+/g,replace:"MM"},y={regex:/[yU]+/g,replace:["yyyy","yy"]};B=B.replace(g,"");B=B.replace(o.regex,o.replace);B=B.replace(M.regex,M.replace);return y.replace.map(function(R){return{pattern:B.replace(y.regex,R),strictParsing:true};});};
var p={isNumber:function(i){return i>=48&&i<=57;},findNumbers:function(v,M){var i=0;while(i<M&&this.isNumber(v.charCodeAt(i))){i++;}if(typeof v!=="string"){v=v.toString();}return v.substr(0,i);},findEntry:function(v,g){var F=-1,M=0;for(var j=0;j<g.length;j++){if(g[j]&&g[j].length>M&&v.indexOf(g[j])===0){F=j;M=g[j].length;}}return{index:F,value:F===-1?null:g[F]};},parseTZ:function(v,i){var g=0;var t=v.charAt(0)=="+"?-1:1;var P;g++;P=this.findNumbers(v.substr(g),2);var T=parseInt(P,10);g+=2;if(i){g++;}P=this.findNumbers(v.substr(g),2);g+=2;var h=parseInt(P,10);return{length:g,tzDiff:(h+60*T)*t};},checkValid:function(t,P,F){if(t in F.oRequiredParts&&P){return false;}}};D.prototype.oSymbols={"":{name:"text",format:function(F,o,u,g){return F.value;},parse:function(v,P,F,o){var s;var V=true;var i=0;var g=0;for(;g<P.value.length;g++){s=P.value.charAt(g);if(s!==" "){if(v.charAt(i)!==s){V=false;}i++;}else{while(v.charAt(i)===" "){i++;}}if(!V){break;}}if(V){return{length:i};}else{var h=false;if(o.index<o.formatArray.length-1){h=(o.formatArray[o.index+1].type in F.oRequiredParts);}return{valid:p.checkValid(P.type,h,F)};}}},"G":{name:"era",format:function(F,o,u,g){var E=u?o.getUTCEra():o.getEra();if(F.digits<=3){return g.aErasAbbrev[E];}else if(F.digits===4){return g.aErasWide[E];}else{return g.aErasNarrow[E];}},parse:function(v,P,F,o){var E=[F.aErasWide,F.aErasAbbrev,F.aErasNarrow];for(var i=0;i<E.length;i++){var V=E[i];var g=p.findEntry(v,V);if(g.index!==-1){return{era:g.index,length:g.value.length};}}return{era:F.aErasWide.length-1,valid:p.checkValid(P.type,true,F)};}},"y":{name:"year",format:function(F,o,u,g){var y=u?o.getUTCFullYear():o.getFullYear();var Y=String(y);var s=g.oFormatOptions.calendarType;if(F.digits==2&&Y.length>2){Y=Y.substr(Y.length-2);}if(s!=C.Japanese&&F.digits==1&&y<100){Y=q.sap.padLeft(Y,"0",4);}return q.sap.padLeft(Y,"0",F.digits);},parse:function(v,P,F,o){var s=F.oFormatOptions.calendarType;var g;if(P.digits==1){g=p.findNumbers(v,4);}else if(P.digits==2){g=p.findNumbers(v,2);}else{g=p.findNumbers(v,P.digits);}var y=parseInt(g,10);if(s!=C.Japanese&&g.length<=2){var h=U.getInstance(new Date(),s),i=h.getFullYear(),j=Math.floor(i/100),Y=j*100+y-i;if(Y<-70){y+=(j+1)*100;}else if(Y<30){y+=j*100;}else{y+=(j-1)*100;}}return{length:g.length,valid:p.checkValid(P.type,g==="",F),year:y};}},"Y":{name:"weekYear",format:function(F,o,u,g){var w=u?o.getUTCWeek():o.getWeek();var W=w.year;var s=String(W);var h=g.oFormatOptions.calendarType;if(F.digits==2&&s.length>2){s=s.substr(s.length-2);}if(h!=C.Japanese&&F.digits==1&&W<100){s=q.sap.padLeft(s,"0",4);}return q.sap.padLeft(s,"0",F.digits);},parse:function(v,P,F,o){var s=F.oFormatOptions.calendarType;var g;if(P.digits==1){g=p.findNumbers(v,4);}else if(P.digits==2){g=p.findNumbers(v,2);}else{g=p.findNumbers(v,P.digits);}var y=parseInt(g,10);var w;if(s!=C.Japanese&&g.length<=2){var h=U.getInstance(new Date(),s),i=h.getFullYear(),j=Math.floor(i/100),Y=j*100+w-i;if(Y<-70){w+=(j+1)*100;}else if(Y<30){w+=j*100;}else{w+=(j-1)*100;}}return{length:g.length,valid:p.checkValid(P.type,g==="",F),year:y,weekYear:w};}},"M":{name:"month",format:function(F,o,u,g){var M=u?o.getUTCMonth():o.getMonth();if(F.digits==3){return g.aMonthsAbbrev[M];}else if(F.digits==4){return g.aMonthsWide[M];}else if(F.digits>4){return g.aMonthsNarrow[M];}else{return q.sap.padLeft(String(M+1),"0",F.digits);}},parse:function(v,P,F,o){var M=[F.aMonthsWide,F.aMonthsWideSt,F.aMonthsAbbrev,F.aMonthsAbbrevSt,F.aMonthsNarrow,F.aMonthsNarrowSt];var V;var g;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);g=parseInt(s,10)-1;if(o.strict&&(g>11||g<0)){V=false;}}else{for(var i=0;i<M.length;i++){var h=M[i];var j=p.findEntry(v,h);if(j.index!==-1){return{month:j.index,length:j.value.length};}}V=p.checkValid(P.type,true,F);}return{month:g,length:s?s.length:0,valid:V};}},"L":{name:"monthStandalone",format:function(F,o,u,g){var M=u?o.getUTCMonth():o.getMonth();if(F.digits==3){return g.aMonthsAbbrevSt[M];}else if(F.digits==4){return g.aMonthsWideSt[M];}else if(F.digits>4){return g.aMonthsNarrowSt[M];}else{return q.sap.padLeft(String(M+1),"0",F.digits);}},parse:function(v,P,F,o){var M=[F.aMonthsWide,F.aMonthsWideSt,F.aMonthsAbbrev,F.aMonthsAbbrevSt,F.aMonthsNarrow,F.aMonthsNarrowSt];var V;var g;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);g=parseInt(s,10)-1;if(o.strict&&(g>11||g<0)){V=false;}}else{for(var i=0;i<M.length;i++){var h=M[i];var j=p.findEntry(v,h);if(j.index!==-1){return{month:j.index,length:j.value.length};}}V=p.checkValid(P.type,true,F);}return{month:g,length:s?s.length:0,valid:V};}},"w":{name:"weekInYear",format:function(F,o,u,g){var w=u?o.getUTCWeek():o.getWeek();var W=w.week;var s=String(W+1);if(F.digits<3){s=q.sap.padLeft(s,"0",F.digits);}else{s=g.oLocaleData.getCalendarWeek(F.digits===3?"narrow":"wide",q.sap.padLeft(s,"0",2));}return s;},parse:function(v,P,F,o){var V;var s;var w;var i=0;if(P.digits<3){s=p.findNumbers(v,2);i=s.length;w=parseInt(s,10)-1;V=p.checkValid(P.type,!s,F);}else{s=F.oLocaleData.getCalendarWeek(P.digits===3?"narrow":"wide");s=s.replace("{0}","[0-9]+");var g=new RegExp(s),R=g.exec(v);if(R){i=R[0].length;w=parseInt(R[0],10)-1;}else{V=p.checkValid(P.type,true,F);}}return{length:i,valid:V,week:w};}},"W":{name:"weekInMonth",format:function(F,o,u,g){return"";},parse:function(){return{};}},"D":{name:"dayInYear",format:function(F,o,u,g){},parse:function(){return{};}},"d":{name:"day",format:function(F,o,u,g){var i=u?o.getUTCDate():o.getDate();return q.sap.padLeft(String(i),"0",F.digits);},parse:function(v,P,F,o){var s=p.findNumbers(v,Math.max(P.digits,2));var V=p.checkValid(P.type,s==="",F);var i=parseInt(s,10);if(o.strict&&(i>31||i<1)){V=false;}return{day:i,length:s.length,valid:V};}},"Q":{name:"quarter",format:function(F,o,u,g){var Q=u?o.getUTCQuarter():o.getQuarter();if(F.digits==3){return g.aQuartersAbbrev[Q];}else if(F.digits==4){return g.aQuartersWide[Q];}else if(F.digits>4){return g.aQuartersNarrow[Q];}else{return q.sap.padLeft(String(Q+1),"0",F.digits);}},parse:function(v,P,F,o){var V;var Q;var s;var g=[F.aQuartersWide,F.aQuartersWideSt,F.aQuartersAbbrev,F.aQuartersAbbrevSt,F.aQuartersNarrow,F.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);Q=parseInt(s,10)-1;if(o.strict&&Q>3){V=false;}}else{for(var i=0;i<g.length;i++){var h=g[i];var j=p.findEntry(v,h);if(j.index!==-1){return{quarter:j.index,length:j.value.length};}}V=p.checkValid(P.type,true,F);}return{length:s?s.length:0,quarter:Q,valid:V};}},"q":{name:"quarterStandalone",format:function(F,o,u,g){var Q=u?o.getUTCQuarter():o.getQuarter();if(F.digits==3){return g.aQuartersAbbrevSt[Q];}else if(F.digits==4){return g.aQuartersWideSt[Q];}else if(F.digits>4){return g.aQuartersNarrowSt[Q];}else{return q.sap.padLeft(String(Q+1),"0",F.digits);}},parse:function(v,P,F,o){var V;var Q;var s;var g=[F.aQuartersWide,F.aQuartersWideSt,F.aQuartersAbbrev,F.aQuartersAbbrevSt,F.aQuartersNarrow,F.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);Q=parseInt(s,10)-1;if(o.strict&&Q>3){V=false;}}else{for(var i=0;i<g.length;i++){var h=g[i];var j=p.findEntry(v,h);if(j.index!==-1){return{quarter:j.index,length:j.value.length};}}V=p.checkValid(P.type,true,F);}return{length:s?s.length:0,quarter:Q,valid:V};}},"F":{name:"dayOfWeekInMonth",format:function(F,o,u,g){return"";},parse:function(){return{};}},"E":{name:"dayNameInWeek",format:function(F,o,u,g){var i=u?o.getUTCDay():o.getDay();if(F.digits<4){return g.aDaysAbbrev[i];}else if(F.digits==4){return g.aDaysWide[i];}else if(F.digits==5){return g.aDaysNarrow[i];}else{return g.aDaysShort[i];}},parse:function(v,P,F,o){var g=[F.aDaysWide,F.aDaysWideSt,F.aDaysAbbrev,F.aDaysAbbrevSt,F.aDaysShort,F.aDaysShortSt,F.aDaysNarrow,F.aDaysNarrowSt];for(var i=0;i<g.length;i++){var V=g[i];var h=p.findEntry(v,V);if(h.index!==-1){return{dayNumberOfWeek:F._adaptDayOfWeek(h.index),length:h.value.length};}}}},"c":{name:"dayNameInWeekStandalone",format:function(F,o,u,g){var i=u?o.getUTCDay():o.getDay();if(F.digits<4){return g.aDaysAbbrevSt[i];}else if(F.digits==4){return g.aDaysWideSt[i];}else if(F.digits==5){return g.aDaysNarrowSt[i];}else{return g.aDaysShortSt[i];}},parse:function(v,P,F,o){var g=[F.aDaysWide,F.aDaysWideSt,F.aDaysAbbrev,F.aDaysAbbrevSt,F.aDaysShort,F.aDaysShortSt,F.aDaysNarrow,F.aDaysNarrowSt];for(var i=0;i<g.length;i++){var V=g[i];var h=p.findEntry(v,V);if(h.index!==-1){return{day:h.index,length:h.value.length};}}}},"u":{name:"dayNumberOfWeek",format:function(F,o,u,g){var i=u?o.getUTCDay():o.getDay();return g._adaptDayOfWeek(i);},parse:function(v,P,F,o){var s=p.findNumbers(v,P.digits);return{dayNumberOfWeek:parseInt(s,10),length:s.length};}},"a":{name:"amPmMarker",format:function(F,o,u,g){var i=u?o.getUTCDayPeriod():o.getDayPeriod();return g.aDayPeriods[i];},parse:function(v,P,F,o){var g;var i;var A=F.aDayPeriods[0],s=F.aDayPeriods[1];var h=/[aApP](?:\.)?[mM](?:\.)?/;var M=v.match(h);var V=(M&&M.index===0);if(V){v=M[0].replace(/\./g,"").toLowerCase()+v.substring(M[0].length);A=A.toLowerCase();s=s.toLowerCase();}if(v.indexOf(A)===0){g=false;i=(V?M[0].length:A.length);}else if(v.indexOf(s)===0){g=true;i=(V?M[0].length:s.length);}return{pm:g,length:i};}},"H":{name:"hour0_23",format:function(F,o,u,g){var h=u?o.getUTCHours():o.getHours();return q.sap.padLeft(String(h),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&h>23){V=false;}return{hour:h,length:s.length,valid:V};}},"k":{name:"hour1_24",format:function(F,o,u,g){var h=u?o.getUTCHours():o.getHours();var H=(h===0?"24":String(h));return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(h==24){h=0;}if(o.strict&&h>23){V=false;}return{hour:h,length:s.length,valid:V};}},"K":{name:"hour0_11",format:function(F,o,u,g){var h=u?o.getUTCHours():o.getHours();var H=String(h>11?h-12:h);return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&h>11){V=false;}return{hour:h,length:s.length,valid:V};}},"h":{name:"hour1_12",format:function(F,o,u,g){var h=u?o.getUTCHours():o.getHours();var H;if(h>12){H=String(h-12);}else if(h==0){H="12";}else{H=String(h);}return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var g=o.dateValue.pm;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);var V=p.checkValid(P.type,s==="",F);if(h==12){h=0;g=(g===undefined)?true:g;}if(o.strict&&h>11){V=false;}return{hour:h,length:s.length,pm:g,valid:V};}},"m":{name:"minute",format:function(F,o,u,g){var M=u?o.getUTCMinutes():o.getMinutes();return q.sap.padLeft(String(M),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var M=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&M>59){V=false;}return{length:s.length,minute:M,valid:V};}},"s":{name:"second",format:function(F,o,u,g){var s=u?o.getUTCSeconds():o.getSeconds();return q.sap.padLeft(String(s),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var S=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&S>59){V=false;}return{length:s.length,second:S,valid:V};}},"S":{name:"fractionalsecond",format:function(F,o,u,g){var M=u?o.getUTCMilliseconds():o.getMilliseconds();var s=String(M);var h=q.sap.padLeft(s,"0",3);h=h.substr(0,F.digits);h=q.sap.padRight(h,"0",F.digits);return h;},parse:function(v,P,F,o){var s=p.findNumbers(v,P.digits);var i=s.length;s=s.substr(0,3);s=q.sap.padRight(s,"0",3);var M=parseInt(s,10);return{length:i,millisecond:M};}},"z":{name:"timezoneGeneral",format:function(F,o,u,g){if(F.digits>3&&o.getTimezoneLong()){return o.getTimezoneLong();}else if(o.getTimezoneShort()){return o.getTimezoneShort();}var t="GMT";var T=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(T/60);var M=T%60;if(!u&&T!=0){t+=(P?"-":"+");t+=q.sap.padLeft(String(h),"0",2);t+=":";t+=q.sap.padLeft(String(M),"0",2);}else{t+="Z";}return t;},parse:function(v,P,F,o){var i=0;var t;var T=v.substring(0,3);if(T==="GMT"||T==="UTC"){i=3;}else if(v.substring(0,2)==="UT"){i=2;}else if(v.charAt(0)=="Z"){i=1;t=0;}else{return{error:"cannot be parsed correcly by sap.ui.core.format.DateFormat: The given timezone is not supported!"};}if(v.charAt(0)!="Z"){var g=p.parseTZ(v.substr(i),true);i+=g.length;t=g.tzDiff;}return{length:i,tzDiff:t};}},"Z":{name:"timezoneRFC822",format:function(F,o,u,g){var t=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=q.sap.padLeft(String(h),"0",2);T+=q.sap.padLeft(String(M),"0",2);}return T;},parse:function(v,P,F,o){return p.parseTZ(v,false);}},"X":{name:"timezoneISO8601",format:function(F,o,u,g){var t=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=q.sap.padLeft(String(h),"0",2);T+=":";T+=q.sap.padLeft(String(M),"0",2);}else{T+="Z";}return T;},parse:function(v,P,F,o){if(v.charAt(0)=="Z"){return{length:1,tzDiff:0};}else{return p.parseTZ(v,true);}}}};
D.prototype._format=function(j,u){if(this.oFormatOptions.relative){var R=this.formatRelative(j,u,this.oFormatOptions.relativeRange);if(R){return R;}}var s=this.oFormatOptions.calendarType;var o=U.getInstance(j,s);var B=[],P,g,S;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";B.push(this.oSymbols[S].format(P,o,u,this));}g=B.join("");if(sap.ui.getCore().getConfiguration().getOriginInfo()){g=new String(g);g.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern};}return g;};
D.prototype.format=function(j,u){if(u===undefined){u=this.oFormatOptions.UTC;}if(Array.isArray(j)){if(!this.oFormatOptions.interval){q.sap.log.error("Non-interval DateFormat can't format more than one date instance.");return"";}if(j.length!==2){q.sap.log.error("Interval DateFormat can only format with 2 date instances but "+j.length+" is given.");return"";}var v=j.every(function(J){return J&&!isNaN(J.getTime());});if(!v){q.sap.log.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return"";}return this._formatInterval(j,u);}else{if(!j||isNaN(j.getTime())){q.sap.log.error("The given date instance isn't valid.");return"";}if(this.oFormatOptions.interval){q.sap.log.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return"";}return this._format(j,u);}};
D.prototype._formatInterval=function(j,u){var s=this.oFormatOptions.calendarType;var F=U.getInstance(j[0],s);var t=U.getInstance(j[1],s);var o;var P;var S;var B=[];var g;var h=this._getGreatestDiffField([F,t],u);if(!h){return this._format(j[0],u);}if(this.oFormatOptions.format){g=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,h,s);}else{g=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s);}this.aFormatArray=this.parseCldrDatePattern(g);o=F;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";if(P.repeat){o=t;}B.push(this.oSymbols[S].format(P,o,u,this));}return B.join("");};
var f={FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};
D.prototype._getGreatestDiffField=function(g,u){var h=false,i={};this.aIntervalCompareFields.forEach(function(F){var G="get"+(u?"UTC":""),M=G+F,s=f[F],v=g[0][M].apply(g[0]),t=g[1][M].apply(g[1]);if(!q.sap.equal(v,t)){h=true;i[s]=true;}});if(h){return i;}return null;};
D.prototype._parse=function(v,F,u,s){var I=0,P,S,R;var o={valid:true};var g={formatArray:F,dateValue:o,strict:s};for(var i=0;i<F.length;i++){S=v.substr(I);P=F[i];g.index=i;R=this.oSymbols[P.symbol||""].parse(S,P,this,g)||{};o=q.extend(o,R);if(R.valid===false){break;}I+=R.length||0;}o.index=I;if(o.pm){o.hour+=12;}if(o.quarter!==undefined&&o.month===undefined&&o.day===undefined){o.month=3*o.quarter;o.day=1;}return o;};
D.prototype._parseInterval=function(v,s,u,S){var g,R,o;this.intervalPatterns.some(function(P){var F=this.parseCldrDatePattern(P);R=undefined;for(var i=0;i<F.length;i++){if(F[i].repeat){R=i;break;}}if(R===undefined){o=this._parse(v,F,u,S);if(o.index===0||o.index<v.length){o.valid=false;}if(o.valid===false){return;}g=[o,o];return true;}else{g=[];o=this._parse(v,F.slice(0,R),u,S);if(o.valid===false){return;}g.push(o);var h=o.index;o=this._parse(v.substring(h),F.slice(R),u,S);if(o.index===0||o.index+h<v.length){o.valid=false;}if(o.valid===false){return;}g.push(o);return true;}}.bind(this));return g;};
var d=function(o,s,u,S){var g,y=typeof o.year==="number"?o.year:1970;if(o.valid){if(u||o.tzDiff!==undefined){g=U.getInstance(new Date(0),s);g.setUTCEra(o.era||U.getCurrentEra(s));g.setUTCFullYear(y);g.setUTCMonth(o.month||0);g.setUTCDate(o.day||1);g.setUTCHours(o.hour||0);g.setUTCMinutes(o.minute||0);g.setUTCSeconds(o.second||0);g.setUTCMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==g.getUTCDate()){o.valid=false;g=undefined;}else{if(o.tzDiff){g.setUTCMinutes((o.minute||0)+o.tzDiff);}if(o.week!==undefined){g.setUTCWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){g.setUTCDate(g.getUTCDate()+o.dayNumberOfWeek-1);}}}}else{g=U.getInstance(new Date(1970,0,1,0,0,0),s);g.setEra(o.era||U.getCurrentEra(s));g.setFullYear(y);g.setMonth(o.month||0);g.setDate(o.day||1);g.setHours(o.hour||0);g.setMinutes(o.minute||0);g.setSeconds(o.second||0);g.setMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==g.getDate()){o.valid=false;g=undefined;}else if(o.week!==undefined){g.setWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){g.setDate(g.getDate()+o.dayNumberOfWeek-1);}}}if(o.valid){g=g.getJSDate();return g;}}return null;};
function m(o,g){if(o===g){return o;}var M={};Object.keys(o).forEach(function(k){M[k]=o[k];});Object.keys(g).forEach(function(k){if(!M.hasOwnProperty(k)){M[k]=g[k];}});return M;}
D.prototype.parse=function(v,u,s){v=q.trim(v);var o;var g=this.oFormatOptions.calendarType;if(u===undefined){u=this.oFormatOptions.UTC;}if(s===undefined){s=this.oFormatOptions.strictParsing;}if(!this.oFormatOptions.interval){var j=this.parseRelative(v,u);if(j){return j;}o=this._parse(v,this.aFormatArray,u,s);if(o.index===0||o.index<v.length){o.valid=false;}j=d(o,g,u,s);if(j){return j;}}else{var h=this._parseInterval(v,g,u,s);var J,k;if(h&&h.length==2){var n=m(h[0],h[1]);var t=m(h[1],h[0]);J=d(n,g,u,s);k=d(t,g,u,s);if(J&&k){return[J,k];}}}if(!this.bIsFallback){var w;q.each(this.aFallbackFormats,function(i,F){w=F.parse(v,u,s);if(Array.isArray(w)){return!(w[0]&&w[1]);}else{return!w;}});return w;}if(!this.oFormatOptions.interval){return null;}else{return[null,null];}};
D.prototype.parseCldrDatePattern=function(P){if(c[P]){return c[P];}var F=[],i,Q=false,o=null,s="",n="",A={},I=false;for(i=0;i<P.length;i++){var g=P.charAt(i),N,h,j;if(Q){if(g=="'"){h=P.charAt(i-1);j=P.charAt(i-2);N=P.charAt(i+1);if(h=="'"&&j!="'"){Q=false;}else if(N=="'"){i+=1;}else{Q=false;continue;}}if(s=="text"){o.value+=g;}else{o={type:"text",value:g};F.push(o);s="text";}}else{if(g=="'"){Q=true;}else if(this.oSymbols[g]){n=this.oSymbols[g].name;if(s==n){o.digits++;}else{o={type:n,symbol:g,digits:1};F.push(o);s=n;if(!I){if(A[n]){o.repeat=true;I=true;}else{A[n]=true;}}}}else{if(s=="text"){o.value+=g;}else{o={type:"text",value:g};F.push(o);s="text";}}}}c[P]=F;return F;};
D.prototype.parseRelative=function(v,u){var P,E,g,R,V;if(!v){return null;}P=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var i=0;i<P.length;i++){E=P[i];g=new RegExp("^\\s*"+E.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");R=g.exec(v);if(R){if(E.value!==undefined){return h(E.value,E.scale);}else{V=parseInt(R[1],10);return h(V*E.sign,E.scale);}}}function h(j,s){var t,T=new Date(),J;if(u){t=T.getTime();}else{t=Date.UTC(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours(),T.getMinutes(),T.getSeconds(),T.getMilliseconds());}J=new Date(t);switch(s){case"second":J.setUTCSeconds(J.getUTCSeconds()+j);break;case"minute":J.setUTCMinutes(J.getUTCMinutes()+j);break;case"hour":J.setUTCHours(J.getUTCHours()+j);break;case"day":J.setUTCDate(J.getUTCDate()+j);break;case"week":J.setUTCDate(J.getUTCDate()+j*7);break;case"month":J.setUTCMonth(J.getUTCMonth()+j);break;case"quarter":J.setUTCMonth(J.getUTCMonth()+j*3);break;case"year":J.setUTCFullYear(J.getUTCFullYear()+j);break;}if(u){return J;}else{return new Date(J.getUTCFullYear(),J.getUTCMonth(),J.getUTCDate(),J.getUTCHours(),J.getUTCMinutes(),J.getUTCSeconds(),J.getUTCMilliseconds());}}};
D.prototype.formatRelative=function(j,u,R){var t=new Date(),o,s=this.oFormatOptions.relativeScale||"day",i,P,g;g=(j.getTime()-t.getTime())/1000;if(this.oFormatOptions.relativeScale=="auto"){s=this._getScale(g,this.aRelativeScales);}if(!R){R=this._mRanges[s];}if(s=="year"||s=="month"||s=="day"){t=new Date(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate()));o=new Date(0);if(u){o.setUTCFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());}else{o.setUTCFullYear(j.getFullYear(),j.getMonth(),j.getDate());}j=o;}i=this._getDifference(s,[t,j]);if(this.oFormatOptions.relativeScale!="auto"&&(i<R[0]||i>R[1])){return null;}P=this.oLocaleData.getRelativePattern(s,i,g>0,this.oFormatOptions.relativeStyle);return q.sap.formatMessage(P,[Math.abs(i)]);};
D.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};D.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592000,quarter:7776000,year:31536000};
D.prototype._getScale=function(g,s){var S,t;g=Math.abs(g);for(var i=0;i<s.length;i++){t=s[i];if(g>=this._mScales[t]){S=t;break;}}if(!S){S=s[s.length-1];}return S;};
function e(o,s){var F=["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],M;for(var i=s;i<F.length;i++){M="set"+F[s];o[M].apply(o,[0]);}}
var r={year:function(F,t){return t.getFullYear()-F.getFullYear();},month:function(F,t){return t.getMonth()-F.getMonth()+(this.year(F,t)*12);},week:function(F,t,o){var i=o._adaptDayOfWeek(F.getDay());var T=o._adaptDayOfWeek(t.getDay());e(F,3);e(t,3);return(t.getTime()-F.getTime()-(T-i)*o._mScales.day*1000)/(o._mScales.week*1000);},day:function(F,t,o){e(F,3);e(t,3);return(t.getTime()-F.getTime())/(o._mScales.day*1000);},hour:function(F,t,o){e(F,4);e(t,4);return(t.getTime()-F.getTime())/(o._mScales.hour*1000);},minute:function(F,t,o){e(F,5);e(t,5);return(t.getTime()-F.getTime())/(o._mScales.minute*1000);},second:function(F,t,o){e(F,6);e(t,6);return(t.getTime()-F.getTime())/(o._mScales.second*1000);}};
D.prototype._adaptDayOfWeek=function(i){var F=this.oLocaleData.getFirstDayOfWeek();var g=i-(F-1);if(g<=0){g+=7;}return g;};
D.prototype._getDifference=function(s,g){var F=g[0];var t=g[1];return Math.round(r[s](F,t,this));};
D.prototype.getAllowedCharacters=function(F){if(this.oFormatOptions.relative){return"";}var A="";var n=false;var g=false;var P;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];switch(P.type){case"text":if(A.indexOf(P.value)<0){A+=P.value;}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!n){A+="0123456789";n=true;}break;case"month":case"monthStandalone":if(P.digits<3){if(!n){A+="0123456789";n=true;}}else{g=true;}break;default:g=true;break;}}if(g){A="";}return A;};
return D;},true);
sap.ui.predefine('sap/ui/core/format/FileSizeFormat',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/format/NumberFormat'],function(q,B,L,a,N){"use strict";var _=[{binaryFactor:1,decimalFactor:1,decimalUnit:"Byte",binaryUnit:"Byte"},{binaryFactor:1,decimalFactor:1,decimalUnit:"Bytes",binaryUnit:"Bytes"},{binaryFactor:Math.pow(2,10),decimalFactor:1e3,decimalUnit:"Kilobyte",binaryUnit:"Kibibyte"},{binaryFactor:Math.pow(2,20),decimalFactor:1e6,decimalUnit:"Megabyte",binaryUnit:"Mebibyte"},{binaryFactor:Math.pow(2,30),decimalFactor:1e9,decimalUnit:"Gigabyte",binaryUnit:"Gibibyte"},{binaryFactor:Math.pow(2,40),decimalFactor:1e12,decimalUnit:"Terabyte",binaryUnit:"Tebibyte"},{binaryFactor:Math.pow(2,50),decimalFactor:1e15,decimalUnit:"Petabyte",binaryUnit:"Pebibyte"},{binaryFactor:Math.pow(2,60),decimalFactor:1e18,decimalUnit:"Exabyte",binaryUnit:"Exbibyte"},{binaryFactor:Math.pow(2,70),decimalFactor:1e21,decimalUnit:"Zettabyte",binaryUnit:"Zebibyte"},{binaryFactor:Math.pow(2,80),decimalFactor:1e24,decimalUnit:"Yottabyte",binaryUnit:"Yobibyte"}];
var F=B.extend("sap.ui.core.format.FileSizeFormat",{constructor:function(f){throw new Error();}});
F.getInstance=function(f,l){return this.createInstance(f,l);};
F.createInstance=function(f,l){var o=Object.create(this.prototype);if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}o.oLocale=l;o.oLocaleData=a.getInstance(l);o.oNumberFormat=N.getFloatInstance(f,l);o.oBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",l.toString());o.bBinary=f?!!f.binaryFilesize:false;return o;};
F.prototype.format=function(v){var V=null,o;if(typeof v=="string"){try{if(/^\s*[\+-]?0[xX]/.test(v)){V=parseInt(v,16);}else{V=parseFloat(v,10);}}catch(e){}}else if(typeof v=="number"){V=v;}if(V===null){return"NaN";}o=V;var u=c(V,this.bBinary),s=this.oNumberFormat.format(V/u.factor);if(!u.noSecondRounding){V=this.oNumberFormat.parse(s);if((this.bBinary&&Math.abs(V)>=1024)||(!this.bBinary&&Math.abs(V)>=1000)){u=c(V*u.factor,this.bBinary);s=this.oNumberFormat.format(o/u.factor);}}return this.oBundle.getText("FileSize."+u.unit,s);};
F.prototype.parse=function(v){var u,b,V,e;if(!v){return NaN;}for(var i=0;i<_.length;i++){u=_[i];b=d(this.oBundle,u.decimalUnit,v);if(b){e=false;break;}else{b=d(this.oBundle,u.binaryUnit,v);if(b){e=true;break;}}}if(!b){b=v;e=false;u=_[0];}V=this.oNumberFormat.parse(b);return V*(e?u.binaryFactor:u.decimalFactor);};
function c(f,e){var b=Math.abs(f),u,g;for(var i=_.length-1;i>=2;i--){u=_[i];g=e?u.binaryFactor:u.decimalFactor;if(b>=g){return{factor:g,unit:e?u.binaryUnit:u.decimalUnit,noSecondRounding:(i==_.length-1)};}}return{factor:1,unit:_[b>=2?1:0].decimalUnit};}
function d(b,u,v){var p=b.getText("FileSize."+u),e;if(q.sap.startsWith(p,"{0}")){e=p.substr(3,p.length);if(q.sap.endsWithIgnoreCase(v,e)){return v.substr(0,v.length-e.length);}}else if(q.sap.endsWith(p,"{0}")){e=p.substr(0,p.length-3);if(q.sap.startsWithIgnoreCase(v,e)){return v.substr(e.length,v.length);}}else{e=p.split("{0}");if(e.length==2&&q.sap.startsWithIgnoreCase(v,e[0])&&q.sap.endsWithIgnoreCase(v,e[1])){return v.substr(e[0].length,v.length-e[1].length);}}return null;}
return F;});
sap.ui.predefine('sap/ui/core/format/ListFormat',['sap/ui/core/Locale','sap/ui/core/LocaleData'],function(L,a){"use strict";var b=function(){throw new Error();};b.oDefaultListFormat={type:"standard",style:"wide"};
b.getInstance=function(f,l){return this.createInstance(f,l);};
b.createInstance=function(f,l){var F=Object.create(this.prototype);if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=l;F.oLocaleData=a.getInstance(l);F.oOriginalFormatOptions=jQuery.extend({},this.oDefaultListFormat,f);return F;};
b.prototype.format=function(l){if(!Array.isArray(l)){jQuery.sap.log.error("ListFormat can only format with an array given.");return"";}var o=this.oOriginalFormatOptions,m,p,v,s,M,e,V=[].concat(l),S,c;m=this.oLocaleData.getListFormat(o.type,o.style);if(jQuery.isEmptyObject(m)){jQuery.sap.log.error("No list pattern exists for the provided format options (type, style).");return"";}function r(V,p){var R=V[0];for(var i=1;i<V.length;i++){R=p.replace("{0}",R);R=R.replace("{1}",V[i]);}return R;}if(m[V.length]){p=m[V.length];for(var i=0;i<V.length;i++){p=p.replace('{'+i+'}',V[i]);}v=p;}else if(V.length<2){v=V.toString();}else{S=V.shift();e=V.pop();c=V;s=m.start.replace("{0}",S);e=m.end.replace("{1}",e);M=r(c,m.middle);v=s.replace("{1}",e.replace("{0}",M));}return v;};
b.prototype.parse=function(v){if(typeof v!=='string'){jQuery.sap.log.error("ListFormat can only parse a String.");return[];}var r=[],s=[],m=[],e=[],E=[],o=this.oOriginalFormatOptions,l,c=/\{[01]\}/g,d,S,f,g,h;if(!o){o=b.oDefaultListFormat;}l=this.oLocaleData.getListFormat(o.type,o.style);if(jQuery.isEmptyObject(l)){jQuery.sap.log.error("No list pattern exists for the provided format options (type, style).");return[];}f=l.start.replace(c,"");g=l.middle.replace(c,"");h=l.end.replace(c,"");s=v.split(f);r=r.concat(s.shift());e=s.join(f).split(h);d=e.pop();m=e.join(h).split(g);r=r.concat(m);r.push(d);if(s.length<1||m.length<1||e.length<1){S=l["2"].replace(c,"");E=v.split(S);if(E.length===2){return E;}if(v){return[v];}else{return[];}}return r;};
return b;});
sap.ui.predefine('sap/ui/core/format/NumberFormat',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData'],function(q,B,L,a){"use strict";
var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(f){throw new Error();}});
var r=/0+(\.0+)?/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(f){return f>0?Math.floor(f):Math.ceil(f);};m[R.AWAY_FROM_ZERO]=function(f){return f>0?Math.ceil(f):Math.floor(f);};m[R.HALF_TOWARDS_ZERO]=function(f){return f>0?Math.ceil(f-0.5):Math.floor(f+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(f){return f>0?Math.floor(f+0.5):Math.ceil(f-0.5);};m[R.HALF_FLOOR]=function(f){return Math.ceil(f-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",customUnits:undefined,allowedUnits:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};
N.getInstance=function(f,l){return this.getFloatInstance(f,l);};
N.getFloatInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.FLOAT);F.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,o,f);return F;};
N.getIntegerInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.INTEGER);F.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,o,f);return F;};
N.getCurrencyInstance=function(f,l){var F=this.createInstance(f,l),C=f&&f.currencyContext,o=this.getLocaleFormatOptions(F.oLocaleData,n.CURRENCY,C);F.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,o,f);return F;};
N.getUnitInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.UNIT);F.oFormatOptions=q.extend(false,{},this.oDefaultUnitFormat,o,f);return F;};
N.getPercentInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.PERCENT);F.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,o,f);return F;};
N.createInstance=function(f,l){var F=Object.create(this.prototype),P;if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=l;F.oLocaleData=a.getInstance(l);F.oOriginalFormatOptions=f;if(f){if(f.pattern){P=this.parseNumberPattern(f.pattern);q.each(P,function(s,o){f[s]=o;});}if(f.emptyString!==undefined){}}return F;};
N.getLocaleFormatOptions=function(l,t,C){var o,s;switch(t){case n.PERCENT:s=l.getPercentPattern();break;case n.CURRENCY:s=l.getCurrencyPattern(C);break;case n.UNIT:s=l.getDecimalPattern();break;default:s=l.getDecimalPattern();}o=this.parseNumberPattern(s);o.plusSign=l.getNumberSymbol("plusSign");o.minusSign=l.getNumberSymbol("minusSign");o.decimalSeparator=l.getNumberSymbol("decimal");o.groupingSeparator=l.getNumberSymbol("group");o.percentSign=l.getNumberSymbol("percentSign");o.pattern=s;switch(t){case n.FLOAT:case n.PERCENT:o.minFractionDigits=0;o.maxFractionDigits=99;break;case n.INTEGER:o.minFractionDigits=0;o.maxFractionDigits=0;o.groupingEnabled=false;break;case n.CURRENCY:o.minFractionDigits=undefined;o.maxFractionDigits=undefined;break;}return o;};
N.parseNumberPattern=function(f){var M=0,h=0,j=0,G=false,k=0,l=0,s=f.indexOf(";"),S={Integer:0,Fraction:1},o=S.Integer;if(s!==-1){f=f.substring(0,s);}for(var i=0;i<f.length;i++){var C=f[i];switch(C){case",":if(G){k=l;l=0;}G=true;break;case".":o=S.Fraction;break;case"0":if(o===S.Integer){M++;if(G){l++;}}else{h++;j++;}break;case"#":if(o===S.Integer){if(G){l++;}}else{j++;}break;}}if(!k){k=l;l=0;}return{minIntegerDigits:M,minFractionDigits:h,maxFractionDigits:j,groupingEnabled:G,groupingSize:k,groupingBaseSize:l};};
N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",f="",G="",s="",h="",P="",j=0,l=0,k=0,o=0,t=v<0,D=-1,O=q.extend({},this.oFormatOptions),u=this.oOriginalFormatOptions,w,S,x,y,U,z;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{z=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(z);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){x=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(x,O,this.oLocaleData);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(u.minFractionDigits===undefined&&u.maxFractionDigits===undefined&&u.decimals===undefined&&u.precision===undefined&&u.pattern===undefined){O.precision=2;}if(u.maxFractionDigits===undefined&&u.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if(O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,e(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var A=this.oLocaleData.getCurrencyDigits(M);if(O.maxFractionDigits===undefined){O.maxFractionDigits=A;}if(O.minFractionDigits===undefined){O.minFractionDigits=A;}}if(typeof v==="number"){v=c(v,O.maxFractionDigits,O.roundingMode);}if(v==0){t=false;}h=this.convertToDecimal(v);if(h=="NaN"){return h;}if(t){h=h.substr(1);}D=h.indexOf(".");if(D>-1){i=h.substr(0,D);f=h.substr(D+1);}else{i=h;}if(i.length<O.minIntegerDigits){i=q.sap.padLeft(i,"0",O.minIntegerDigits);}else if(i.length>O.maxIntegerDigits){i=q.sap.padLeft("","?",O.maxIntegerDigits);}if(f.length<O.minFractionDigits){f=q.sap.padRight(f,"0",O.minFractionDigits);}else if(f.length>O.maxFractionDigits){f=f.substr(0,O.maxFractionDigits);}l=i.length;if(O.groupingEnabled){k=O.groupingSize;o=O.groupingBaseSize||k;j=Math.max(l-o,0)%k||k;G=i.substr(0,j);while(l-j>=o){G+=O.groupingSeparator;G+=i.substr(j,k);j+=k;}G+=i.substr(j);}else{G=i;}if(t){s=O.minusSign;}s+=G;if(f){s+=O.decimalSeparator+f;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){y=this.oLocaleData.getPluralCategory(i+"."+f);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,y);s=S.formatString.replace(S.valueSubString,s);s=s.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){y=this.oLocaleData.getPluralCategory(i+"."+f);P=this.oLocaleData.getCurrencyFormat("short",S.key,y);P=P.replace(/'.'/g,".");}w=P.split(";");if(w.length===2){P=t?w[1]:w[0];if(t){s=s.substring(1);}}if(!O.currencyCode){M=this.oLocaleData.getCurrencySymbol(M);}s=this._composeCurrencyResult(P,s,M,{showMeasure:O.showMeasure,negative:t,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;s=P.replace(/[0#.,]+/,s);s=s.replace(/%/,O.percentSign);}if(O.showMeasure&&O.type===n.UNIT){y=this.oLocaleData.getPluralCategory(i+"."+f);var C=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!C){return"";}if(U){P=U["unitPattern-count-"+y];if(!P){P=U["unitPattern-count-other"];}if(!P){return"";}s=P.replace("{0}",s);}else{return"";}}if(sap.ui.getCore().getConfiguration().getOriginInfo()){s=new String(s);s.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return s;};
N.prototype._composeCurrencyResult=function(P,f,M,o){var s=o.minusSign;P=P.replace(/[0#.,]+/,f);if(o.showMeasure&&M){var h="\u00a4",i={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},j=P.indexOf(h),k=j<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(k),C=(k==="after"?M.charAt(M.length-1):M.charAt(0)),l,t=i[S.currencyMatch],u=i[S.surroundingMatch],I;P=P.replace(h,M);l=(k==="after"?P.charAt(j+M.length):P.charAt(j-1));if(t&&t.test(C)&&u&&u.test(l)){if(k==="after"){I=j+M.length;}else{I=j;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(o.negative&&k==="after"){s="\ufeff"+o.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(o.negative){P=P.replace(/-/,s);}return P;};
N.prototype.parse=function(v){var o=this.oFormatOptions,P=d(o.plusSign+o.minusSign),G=d(o.groupingSeparator),D=d(o.decimalSeparator),s="^\\s*(["+P+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",f="^\\s*(["+P+"]?[0-9"+G+"]+)\\s*$",h=new RegExp(G,"g"),j=new RegExp(D,"g"),k=this.oLocaleData.getNumberSymbol("percentSign"),l,t,u,w,x,M,y,z=0,S,E;if(v===""){E=o.emptyString;if(o.parseAsString&&(o.emptyString===0||isNaN(o.emptyString))){E=o.emptyString+"";}if(o.type===n.CURRENCY){return[E,undefined];}else{return E;}}y=o.type===n.PERCENT?o.pattern:this.oLocaleData.getPercentPattern();if(y.charAt(0)==="%"){s=s.slice(0,1)+"%?"+s.slice(1);}else if(y.charAt(y.length-1)==="%"){s=s.slice(0,s.length-1)+"%?"+s.slice(s.length-1);}var U;if(o.type===n.UNIT){var A;if(o.customUnits&&typeof o.customUnits==="object"){A=o.customUnits;}else{A=this.oLocaleData.getUnitFormats();}if(o.allowedUnits){var F={};for(var i=0;i<o.allowedUnits.length;i++){var C=o.allowedUnits[i];F[C]=A[C];}A=F;}var H=p(A,v);U=H.cldrCode;if(U.length===1){M=U[0];}else if(U.length===0){return null;}else{M=undefined;}v=H.numberValue||v;}if(typeof v==="string"||v instanceof String){v=v.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");v=v.replace(/\s/g,"");}S=b(v,this.oFormatOptions.style,this.oLocaleData);if(S){v=S.number;l=new RegExp(s);}else if(o.isInteger){l=new RegExp(f);}else if(o.type===n.CURRENCY){w="[^\\d\\s+-]*";u="(?:^("+w+")"+s.substring(1,s.length-1)+"$)|(?:^"+s.substring(1,s.length-1)+"("+w+")\\s*$)";l=new RegExp(u);}else{l=new RegExp(s);}if(!l.test(v)){return o.type===n.CURRENCY||o.type===n.UNIT?null:NaN;}if(o.type===n.CURRENCY){x=l.exec(v);if(x[2]){v=x[2];M=x[1]||undefined;}else{v=x[3];M=x[4]||undefined;}if(M&&!o.showMeasure){return null;}if(M){M=this.oLocaleData.getCurrencyCodeBySymbol(M)||M;}}v=v.replace(h,"");v=v.replace(o.plusSign,"+");v=v.replace(o.minusSign,"-");v=v.replace(/^\+/,"");if(S){v=v.replace(j,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(o.isInteger){z=o.parseAsString?v:parseInt(v,10);}else{v=v.replace(j,".");if(v.indexOf(k)!==-1){t=true;v=v.replace(k,"");}z=o.parseAsString?v:parseFloat(v);if(t){z=N._shiftDecimalPoint(z,-2);}}if(o.parseAsString){z=N._shiftDecimalPoint(v,0);}if(o.type===n.CURRENCY||o.type===n.UNIT){return[z,M];}return z;};
N.prototype.convertToDecimal=function(v){var V=""+v,f,s,D,F,E,P;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var h=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);f=h[1]=="-";s=h[2].replace(/\./g,"");D=h[3]?h[3].length:0;F=h[4]?h[4].length:0;E=parseInt(h[5],10);if(E>0){if(E<F){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(f){V="-"+V;}return V;};
N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var s=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),S;if(s&&s.formatString){S=s.formatString.replace(r,"").replace(/'.'/g,".").trim();if(S){return S;}}};
N._shiftDecimalPoint=function(v,s){if(typeof s!=="number"){return NaN;}var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){s=E[1]?(+E[1]+s):s;return+(E[0]+"e"+s);}else if(typeof v==="string"){if(parseInt(v,10)===0&&s>=0){return v;}v=E[0];var D=v.indexOf("."),A,i,f;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+s;if(A<=0){v=q.sap.padLeft(v,'0',v.length-A+1);A=1;}else if(A>=v.length-1){v=q.sap.padRight(v,'0',A+1);A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);f=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return i+(f?("."+f):"");}else{return null;}};
function g(v,o,l){var s,k,K,S=o.style,P=o.precision!==undefined?o.precision:2;if(S!="short"&&S!="long"){return undefined;}for(var i=0;i<14;i++){k=Math.pow(10,i);if(c(Math.abs(v)/k,P-1)<10){break;}}K=k.toString();var C=l.getDecimalFormat(S,K,"other");if(!C||C=="0"){return undefined;}else{s={};s.key=K;s.formatString=C;var f=C.match(r);if(f){s.valueSubString=f[0];var h=s.valueSubString.indexOf(".");if(h==-1){s.decimals=0;s.magnitude=k*Math.pow(10,1-s.valueSubString.length);}else{s.decimals=s.valueSubString.length-h-1;s.magnitude=k*Math.pow(10,1-h);}}else{return undefined;}}return s;}
function b(v,s,l){if(s!="short"&&s!="long"){return;}var f,F=1,k=10,P=l.getPluralCategories(),C,h={number:undefined,factor:F},G=function(o,k){C=l.getDecimalFormat(s,k.toString(),o);if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var t=C.match(r);if(t){var V=t[0];var u=C.replace(V,"");if(!u){return;}var I=v.indexOf(u);if(I>=0){f=v.replace(u,"");f=f.replace(/\u200F/g,"");F=k;F*=Math.pow(10,1-V.length);if(h.number===undefined||f.length<h.number.length){h.number=f;h.factor=F;}}}}};while(k<1e14){for(var i=0;i<P.length;i++){var j=P[i];G(j,k);}k=k*10;}if(!f){return;}return h;}
function c(v,M,s){if(typeof v!=="number"){return NaN;}s=s||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M,10);if(typeof s==="function"){v=s(v,M);}else{if(!M){return m[s](v);}v=N._shiftDecimalPoint(m[s](N._shiftDecimalPoint(v,M)),-M);}return v;}
function d(s){return s.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}
function e(v,P){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,P-i-1);}
function p(u,v){var o={numberValue:undefined,cldrCode:[]};var i;var U,k;for(U in u){for(k in u[U]){if(k.indexOf("unitPattern")===0){var s=u[U][k];var C=s.indexOf("{0}")>-1;if(C){s="^"+q.sap.escapeRegExp(s).replace("\\{0\\}","(.+)")+"$";var f=new RegExp(s);var h=f.exec(v);if(h&&h[1]){if(i===undefined||h[1].length<i){i=h[1].length;o.numberValue=h[1];o.cldrCode=[U];}else if(h[1].length===i&&o.cldrCode.indexOf(U)===-1){o.cldrCode.push(U);}}}else if(s===v){o.cldrCode=[U];var j;if(q.sap.endsWith(k,"-zero")){j="0";}else if(q.sap.endsWith(k,"-one")){j="1";}else if(q.sap.endsWith(k,"-two")){j="2";}o.numberValue=j;return o;}}}}return o;}
return N;});
sap.ui.predefine('sap/ui/core/message/MessageMixin',["jquery.sap.global","sap/ui/core/library"],function(q,l){"use strict";var V=l.ValueState;var M=function(){this.refreshDataState=r;};
function r(n,d){if(d.getChanges().messages){var m=d.getMessages();var L=sap.ui.core.LabelEnablement.getReferencingLabels(this);var s=L[0];var f=false;m.forEach(function(a){if(L&&L.length>0){var b=sap.ui.getCore().byId(s);if(b.getMetadata().isInstanceOf("sap.ui.core.Label")&&b.getText&&a.getAdditionalText()!==b.getText()){a.setAdditionalText(b.getText());f=true;}else{q.sap.log.warning("sap.ui.core.message.Message: Can't create labelText."+"Label with id "+s+" is no valid sap.ui.core.Label.",this);}}if(a.getControlId()!==this.getId()){a.setControlId(this.getId());f=true;}}.bind(this));var o=sap.ui.getCore().getMessageManager().getMessageModel();o.checkUpdate(f,true);if(m&&m.length>0){var a=m[0];if(V[a.type]){this.setValueState(a.type);this.setValueStateText(a.message);}}else{this.setValueState(V.None);this.setValueStateText('');}}}
return M;},true);
sap.ui.predefine('sap/ui/core/message/MessageParser',["jquery.sap.global","sap/ui/base/Object"],function(q,O){"use strict";
var M=O.extend("sap.ui.core.message.MessageParser",{
metadata:{publicMethods:["parse","setProcessor"]},
constructor:function(){this._processor=null;}
});
M.prototype.setProcessor=function(p){this._processor=p;return this;};
M.prototype.getProcessor=function(){return this._processor;};
M.prototype.parse=function(r){q.sap.log.error("MessageParser: parse-method must be implemented in the specific parser class. Messages "+"have been ignored.");};
return M;});
sap.ui.predefine('sap/ui/core/mvc/Controller',['jquery.sap.global','sap/base/util/extend','sap/ui/base/EventProvider','sap/ui/base/ManagedObject','sap/ui/core/mvc/ControllerMetadata','sap/ui/core/mvc/ControllerExtension','sap/ui/core/mvc/OverrideExecution'],function(q,e,E,M,C,a,O){"use strict";var r={};var m={};
var b=E.extend("sap.ui.core.mvc.Controller",{
metadata:{stereotype:"controller",methods:{"byId":{"public":true,"final":true},"getView":{"public":true,"final":true},"getInterface":{"public":false,"final":true},"onInit":{"public":false,"final":false,"overrideExecution":O.After},"onExit":{"public":false,"final":false,"overrideExecution":O.Before},"onBeforeRendering":{"public":false,"final":false,"overrideExecution":O.Before},"onAfterRendering":{"public":false,"final":false,"overrideExecution":O.After}}},
constructor:function(n){var t=null;if(typeof(n)=="string"){if(!r[n]){q.sap.log.warning("Do not call sap.ui.core.mvc.Controller constructor for non typed scenario!");}t=r[n];}E.apply(this,arguments);if(t){q.extend(this,r[n]);}if(this.extension){throw new Error("The keyword 'extension' cannot be used as a member of a controller");}this["_sapui_Extensions"]={};b.extendByMember(this,false);this._sapui_isExtended=false;},
_isExtended:function(){return this._sapui_isExtended;},
getInterface:function(){var i={};var o=this.getMetadata();var p=o.getAllPublicMethods();p.forEach(function(s){var F=this[s];if(typeof F==='function'){i[s]=function(){var t=F.apply(this,arguments);return(t instanceof b)?t.getInterface():t;}.bind(this);}}.bind(this));this.getInterface=q.sap.getter(i);return i;}
},C);
function c(o,i,l){var n=i.getMetadata().getName();var k=o.getMetadata();var p=o["_sapui_Extensions"];var I=o.getInterface();var L=a.getMetadata().getLifecycleConfiguration();var s={namespace:n,extension:i,reloadNeeded:false};i._setController(I);if(i.getMetadata().hasOverrides()){var t,u,v,w,x=i.getMetadata().getOverrides(),S=i.getMetadata().getStaticOverrides();for(w in S){v=i.getMetadata();if(!v.isMethodFinal(w)){a.overrideMethod(w,i,S,i,v.getOverrideExecution(w));}else{q.sap.log.error("Method '"+w+"' of extension '"+n+"' is flagged final and cannot be overridden by calling 'override'");}}for(w in x){if(w!=='extension'){if(w in i.base){q.sap.log.debug("Overriding  member '"+w+"' of original controller.");var y=x[w];var z=o[w];if(typeof z=="object"&&typeof y=="object"){u=p[w];v=u.extension.getMetadata();for(t in y){if(!v.isMethodFinal(t)){a.overrideMethod(t,z,y,i,v.getOverrideExecution(t));}else{q.sap.log.error("Method '"+t+"' of extension '"+u.namespace+"' is flagged final and cannot be overridden by extension '"+n+"'");}}}else if(!k.isMethodFinal(w)){a.overrideMethod(w,o,x,i,k.getOverrideExecution(w));}else{q.sap.log.error("Method '"+w+"' of controller '"+o.getMetadata().getName()+"' is flagged final and cannot be overridden by extension '"+n+"'");}}else if(w in L){a.overrideMethod(w,o,x,i,k.getOverrideExecution(w));}else{q.sap.log.error("Method '"+t+"' of extension '"+u.namespace+" does not exist in controller "+o.getMetadata().getName()+" and cannot be overridden");}}if(x.extension){for(var A in x.extension){v=p[A].extension.getMetadata();var B=q.sap.getObject(A,null,o.extension);var D=p[A].extension;var F=x.extension[A];for(t in F){if(!v.isMethodFinal(t)){a.overrideMethod(t,B,F,i,v.getOverrideExecution(t));a.overrideMethod(t,D,F,i,v.getOverrideExecution(t));}else{q.sap.log.error("Method '"+t+"' of extension '"+A+"' is flagged final and cannot be overridden by extension '"+n+"'");}}}}s.reloadNeeded=true;}}var G=i.getInterface();if(l){p[l]=s;s.location=l;o[l]=G;I[l]=G;}else{p[n]=s;s.location="extension."+n;q.sap.setObject("extension."+n,G,o);q.sap.setObject("extension."+n,G,I);}}
function d(o,i,l){if(i instanceof a){c(o,i,l);}else if(i.getMetadata&&i.getMetadata().getStereotype()=="controllerextension"){var k=new i();c(o,k,l);}else{var L=a.getMetadata().getLifecycleConfiguration();for(var s in i){if(s in L){a.overrideMethod(s,o,i,o,L[s].overrideExecution);}else{a.overrideMethod(s,o,i);}}}}
function f(n,A){if(!n){throw new Error("Controller name ('sName' parameter) is required");}var s=n.replace(/\./g,"/")+".controller",i=k(sap.ui.require(s));function k(i){if(i){return i;}else if(r[n]){return b;}else{return q.sap.getObject(n);}}if(A){return new Promise(function(l,o){if(!i){sap.ui.require([s],function(i){l(k(i));});}else{l(i);}});}else if(!i){i=sap.ui.requireSync(s);return k(i);}else{return i;}}
function g(o,A){var p=b._sExtensionProvider.replace(/\./g,"/"),P=m[p];if(A){return new Promise(function(k,l){if(p){if(P){k(P);}else{sap.ui.require([p],function(i){P=new i();m[p]=P;k(P);});}}else{k();}});}else if(p){if(P){return P;}else{var i=sap.ui.requireSync(p);P=new i();m[p]=P;return P;}}}
function h(i,n){var o;if(r[n]){o=new i(n);}else{o=new i();}if(!o){throw new Error("Controller "+n+" couldn't be instantiated");}return o;}
b.extendByMember=function(o,A){var s;for(s in o){if(o[s]&&o[s].getMetadata&&o[s].getMetadata().getStereotype()=="controllerextension"){o[s]=new o[s]();}}for(s in o){if(o[s]&&o[s].getMetadata&&o[s].getMetadata().getStereotype()=="controllerextension"){d(o,o[s],s);}}if(A){return Promise.resolve(o);}else{return o;}};
b.extendByCustomizing=function(o,n,A){var k=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(!k){return A?Promise.resolve(o):o;}function p(y,o){return f(y,A).then(function(s){if((s=r[y])!==undefined){d(o,s);return o;}},function(z){q.sap.log.error("Attempt to load Extension Controller "+y+" was not successful - is the Controller correctly defined in its file?");});}var s,t=[],u,v=A?Promise.resolve(o):o,w=k.getControllerExtension(n,M._sOwnerId);if(w){u=typeof w==="string"?w:w.controllerName;t=w.controllerNames||[];if(u){t.unshift(u);}}for(var i=0,l=t.length;i<l;i++){var x=t[i];if(typeof x==="string"){q.sap.log.info("Customizing: Controller '"+n+"' is now extended by '"+x+"'");if(A){v=v.then(p.bind(null,x,o));}else{if(!r[x]&&!sap.ui.require(x)){f(x);}if((s=r[x])!==undefined){d(o,s);}else{q.sap.log.error("Attempt to load Extension Controller "+x+" was not successful - is the Controller correctly defined in its file?");}}}}return v;};
b.extendByProvider=function(o,n,s,A){if(!b._sExtensionProvider){return A?Promise.resolve(o):o;}q.sap.log.info("Customizing: Controller '"+n+"' is now extended by Controller Extension Provider '"+b._sExtensionProvider+"'");var k,p;if(A){return g(o,A).then(function(p){return p.getControllerExtensions(n,s,A);}).then(function(t){if(t&&t.length){for(var i=0,l=t.length;i<l;i++){d(o,t[i]);}}return o;},function(t){q.sap.log.error("Controller Extension Provider: Error '"+t+"' thrown in "+b._sExtensionProvider+"extension provider ignored.");return o;});}else{p=g(o,A);k=p.getControllerExtensions(n,s,A);if(k&&Array.isArray(k)){for(var i=0,l=k.length;i<l;i++){d(o,k[i]);}}else{q.sap.log.error("Controller Extension Provider: Error in ExtensionProvider.getControllerExtensions: "+b._sExtensionProvider+" - no valid extensions returned");}}return o;};
b.create=function(o){return j(o.name,undefined,true);};
sap.ui.controller=function(n,o,A){if(A){q.sap.log.info("Do not use deprecated factory function 'sap.ui.controller("+n+")'. Use 'sap.ui.core.mvc.Controller.create(...)' instead.");}else{q.sap.log.warning("Do not use synchronous controller creation for controller '"+n+"'! Use the new asynchronous factory 'sap.ui.core.mvc.Controller.create(...)' instead.");}return j.apply(this,arguments);};
function j(n,o,A){var i,k,s=M._sOwnerId;if(typeof o==="boolean"){o=undefined;}if(!o){if(A){return f(n,A).then(function(k){return h(k,n);}).then(function(i){return b.extendByCustomizing(i,n,A);}).then(function(i){return b.extendByProvider(i,n,s,A);}).then(function(i){i._sapui_isExtended=true;return i;});}else{k=f(n,A);i=h(k,n);i=b.extendByCustomizing(i,n,A);i=b.extendByProvider(i,n,s,A);i._sapui_isExtended=true;}return i;}else{r[n]=o;q.sap.log.info("For defining controllers use Controller.extend instead");}}
b.prototype.getPublicMethods=function(){var p={},o=this.getMetadata(),i=o.getAllMethods(),l=o.getLifecycleConfiguration();Object.keys(i).forEach(function(s){if(o.isMethodPublic(s)){p[s]=i[s];p[s].reloadNeeded=!!(s in l);}});delete p.extension;var k=this["_sapui_Extensions"];Object.keys(k).forEach(function(n){var s=k[n];var t=s.extension.getInterface();var A=s.extension.getMetadata().getAllMethods();Object.keys(t).forEach(function(u){delete p[s.location];var v=q.extend({},A[u],{reloadNeeded:s.reloadNeeded});p[s.location+"."+u]=v;});});return p;};
b.prototype.destroy=function(){Object.keys(this["_sapui_Extensions"]).forEach(function(o){q.sap.setObject(o.location,null,this);}.bind(this));delete this["_sapui_Extensions"];delete this["_sapui_Interface"];E.prototype.destroy.apply(this,arguments);};
b.prototype.getView=function(){return this.oView;};
b.prototype.byId=function(i){return this.oView?this.oView.byId(i):undefined;};
b.prototype.createId=function(i){return this.oView?this.oView.createId(i):undefined;};
b.prototype.getOwnerComponent=function(){var i=sap.ui.requireSync("sap/ui/core/Component");return i.getOwnerComponentFor(this.getView());};
b.prototype.connectToView=function(v){this.oView=v;if(this.onInit){v.attachAfterInit(this.onInit,this);}if(this.onExit){v.attachBeforeExit(this.onExit,this);}if(this.onAfterRendering){v.attachAfterRendering(this.onAfterRendering,this);}if(this.onBeforeRendering){v.attachBeforeRendering(this.onBeforeRendering,this);}};
b._sExtensionProvider=null;
b.registerExtensionProvider=function(s){b._sExtensionProvider=s;};
return b;});
sap.ui.predefine('sap/ui/core/mvc/ControllerExtension',['sap/ui/base/Object','sap/ui/base/Metadata','sap/ui/core/mvc/ControllerMetadata','sap/ui/core/mvc/OverrideExecution','sap/base/util/uid'],function(B,M,C,O,u){"use strict";
var a=B.extend("sap.ui.core.mvc.ControllerExtension",{
metadata:{stereotype:"controllerextension",methods:{"byId":{"public":true,"final":true},"getView":{"public":true,"final":true},"getInterface":{"public":false,"final":true}}},
_setController:function(c){this.base=c;},
byId:function(i){var n=this.getMetadata().getNamespace();i=n+"."+i;return this.base?this.base.byId(i):undefined;},
getView:function(){return this.base.getView();},
getInterface:function(){var m={};var o=this.getMetadata();var p=o.getAllPublicMethods();p.forEach(function(s){var f=this[s];if(typeof f==='function'){m[s]=function(){var t=f.apply(this,arguments);return(t instanceof a)?t.getInterface():t;}.bind(this);}}.bind(this));this.getInterface=jQuery.sap.getter(m);return m;}
},C);
a.override=function(e){var c=M.createClass(this,"anonymousExtension~"+u(),{},C);c.getMetadata()._staticOverride=e;c.getMetadata()._override=this.getMetadata()._override;return c;};
a.overrideMethod=function(m,o,c,b,s){var f=o[m];var d=c[m];s=s||O.Instead;function w(e){(function(d,f,b,e){o[m]=function(){if(e){d.apply(b,arguments);return f.apply(o,arguments);}else{f.apply(o,arguments);return d.apply(b,arguments);}};})(d,f,b,e);}if(typeof d==='function'&&b){d=d.bind(b);}switch(s){case O.Before:if(f&&typeof f==="function"){w(true);}else if(typeof d==="function"){o[m]=d;}else{jQuery.sap.log.error("Controller extension failed: lifecycleMethod '"+m+"', is not a function");}break;case O.After:if(f&&typeof f==="function"){w(false);}else if(typeof d==="function"){o[m]=d;}else{jQuery.sap.log.error("Controller extension failed: lifecycleMethod '"+m+"', is not a function");}break;case O.Instead:default:if(m in o){jQuery.sap.log.debug("Overriding  member '"+m+"' of extension "+this.getMetadata().getName());if(!this.getMetadata().isMethodFinal(m)){o[m]=d;}else{jQuery.sap.log.error("Error in ControllerExtension.override: Method '"+m+"' of extension '"+this.getMetadata().getName()+"' is flagged final and cannot be overridden!");}}else{o[m]=d;}break;}};
return a;});
sap.ui.predefine('sap/ui/core/mvc/ControllerMetadata',['sap/ui/base/Metadata','sap/base/util/extend','sap/ui/core/mvc/OverrideExecution'],function(M,e,O){"use strict";var C=function(c,o){M.apply(this,arguments);if(this.isA("sap.ui.core.mvc.ControllerExtension")&&this.getParent().getClass().override){this.getClass().override=this.getParent().getClass().override;}};C.prototype=Object.create(M.prototype);
C.prototype.applySettings=function(c){if(c.override){this._override=c.override;delete c.override;}M.prototype.applySettings.call(this,c);var s=c.metadata;this._defaultLifecycleMethodMetadata={"onInit":{"public":true,"final":false,"overrideExecution":O.After},"onExit":{"public":true,"final":false,"overrideExecution":O.Before},"onBeforeRendering":{"public":true,"final":false,"overrideExecution":O.Before},"onAfterRendering":{"public":true,"final":false,"overrideExecution":O.After}};var i=this.isA("sap.ui.core.mvc.ControllerExtension");var r=/^_/;var E=this._oParent.isA("sap.ui.core.mvc.Controller");var d=c.metadata&&c.metadata.methods?true:false;if(!i){if(E&&!d){r=/^_|^on|^init$|^exit$/;}if(E&&d){e(s.methods,this._defaultLifecycleMethodMetadata);}}if(i||d){this._aPublicMethods=[];}this._mMethods=s.methods||{};for(var n in c){if(n!=="metadata"&&n!=="constructor"){if(!n.match(r)){if(E&&this._oParent&&this._oParent.isMethodFinal(n)){jQuery.sap.log.error("Method: '"+n+"' of controller '"+this._oParent.getName()+"' is final and cannot be overridden by controller '"+this.getName()+"'");delete this._oClass.prototype[n];}if(!(n in this._mMethods)&&typeof c[n]==='function'){if(!(c[n].getMetadata&&c[n].getMetadata().isA("sap.ui.core.mvc.ControllerExtension"))){this._mMethods[n]={"public":true,"final":false};}}}}}for(var m in this._mMethods){if(this.isMethodPublic(m)){this._aPublicMethods.push(m);}}};
C.prototype.afterApplySettings=function(){M.prototype.afterApplySettings.call(this);var i=this.isA("sap.ui.core.mvc.ControllerExtension");if(this._oParent){var p=this._oParent._mMethods?this._oParent._mMethods:{};for(var m in p){if(this._mMethods[m]&&!i){var P=this._mMethods[m].public;this._mMethods[m]=e({},p[m]);if(P!==undefined){this._mMethods[m].public=P;}if(!this.isMethodPublic(m)&&this._mMethods[m].public!==p[m].public){this._aAllPublicMethods.splice(this._aAllPublicMethods.indexOf(m),1);}}else{this._mMethods[m]=p[m];}}}if(this._oParent&&this._oParent.isA("sap.ui.core.mvc.ControllerExtension")){this._bFinal=true;}};
C.prototype.getNamespace=function(){var i=this._sClassName.indexOf("anonymousExtension~")==0;var n=i?this._oParent._sClassName:this._sClassName;return n.substr(0,n.lastIndexOf("."));};
C.prototype.isMethodFinal=function(m){var o=this._mMethods[m];return o&&o.final;};
C.prototype.isMethodPublic=function(m){var o=this._mMethods[m];return o&&o.public;};
C.prototype.getAllMethods=function(){return this._mMethods;};
C.prototype.getOverrideExecution=function(m){var o=this._mMethods[m];var s=O.Instead;if(o){s=o.overrideExecution;}return s;};
C.prototype.getOverrides=function(){return this._override;};
C.prototype.getStaticOverrides=function(){return this._staticOverride;};
C.prototype.hasOverrides=function(){return!!this._override||!!this._staticOverride;};
C.prototype.getLifecycleConfiguration=function(){return this._defaultLifecycleMethodMetadata;};
return C;});
sap.ui.predefine('sap/ui/core/mvc/EventHandlerResolver',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/base/BindingParser","sap/ui/core/Element","sap/ui/model/BindingMode","sap/ui/model/CompositeBinding","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel"],function(q,M,B,E,a,C,J,b){"use strict";var c={resolveEventHandler:function(n,o){var h;n=n.trim();if(sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){h=function(){};}else{var s=n.indexOf("("),f=n;if(s>0){f=n.substring(0,s).trim();}else if(s===0){throw new Error("Event handler name starts with a bracket, must start with a function name "+"(or with a dot followed by controller-local function name): "+n);}switch(f.indexOf('.')){case 0:h=o&&q.sap.getObject(f.slice(1),undefined,o);break;case-1:h=o&&o[f];if(h!=null){break;}default:h=q.sap.getObject(f);}if(h&&s>0){var i=n.lastIndexOf(")");if(i>s){if(n.substring(s).indexOf("{=")>-1){q.sap.log.warning("It looks like an event handler parameter contains a binding expression ({=...}). This is not allowed and will cause an error later on "+"because the entire event handler is already considered an expression: "+n);}h=(function(f,o){return function(d){var p,S,j=n;if(n.indexOf("$parameters")>-1){p=new J(d.mParameters);}if(n.indexOf("$source")>-1){S=new b(d.getSource());}var G={"$controller":o,$event:d};if(f.indexOf(".")>0){var k=f.split(".")[0];G[k]=window[k];}else if(f.indexOf(".")===-1){if(o&&o[f]){j="$controller."+j;}else if(window[f]){G[f]=window[f];}}var l=B.parseExpression(j.replace(/^\./,"$controller."),0,{oContext:o},G);if(l.result){try{g(l.result,d.getSource(),o,p,S);}catch(e){e.message="Error when evaluating event handler '"+n+"': "+e.message;throw e;}}if(p){p.destroy();}if(S){S.destroy();}};})(f,o);}else{q.sap.log.error("Syntax error in event handler '"+n+"': arguments must be enclosed in a pair of brackets");}}}if(typeof h==="function"){h._sapui_handlerName=n;return[h,o];}q.sap.log.warning("Event handler name '"+n+"' could not be resolved to an event handler function");}};
function g(o,e,d,p,s){var t;o.mode=a.OneWay;if(!o.parts){o.parts=[];o.parts[0]={path:o.path,targetType:o.targetType,type:o.type,suspended:o.suspended,formatOptions:o.formatOptions,constraints:o.constraints,model:o.model,mode:o.mode};delete o.path;delete o.targetType;delete o.mode;delete o.model;}for(var i=0;i<o.parts.length;i++){var P=o.parts[i];if(typeof P=="string"){P={path:P};o.parts[i]=P;}if(!P.path&&P.parts){throw new Error("Bindings in event handler parameters cannot use parts. Just use one single path.");}var S=P.path.indexOf(">");if(S>0){P.model=P.path.substr(0,S);P.path=P.path.substr(S+1);}}var f,h,j=[];o.parts.forEach(function(P){var m;if(P.model==="$parameters"){m=p;f=p.createBindingContext("/");}else if(P.model==="$source"){m=s;f=s.createBindingContext("/");}else{m=e.getModel(P.model);f=e.getBindingContext(P.model);}t=P.type;if(typeof t=="string"){k=q.sap.getObject(t);if(typeof k!=="function"){throw new Error("Cannot find type \""+t+"\" used for binding \""+P.path+"\"!");}t=new k(P.formatOptions,P.constraints);}h=m.bindProperty(P.path,f,o.parameters);h.setType(t,P.targetType||"any");h.setFormatter(P.formatter);h.setBindingMode(a.OneTime);j.push(h);});if(j.length>1||(o.formatter&&o.formatter.textFragments)){t=o.type;if(typeof t=="string"){var k=q.sap.getObject(t);t=new k(o.formatOptions,o.constraints);}h=new C(j,o.useRawValues,o.useInternalValues);h.setType(t,P.targetType||"any");h.setBindingMode(a.OneTime);}else{h=j[0];}h.setFormatter(o.formatter);h.initialize();return h.getExternalValue();}
return c;});
sap.ui.predefine('sap/ui/core/mvc/HTMLView',['jquery.sap.global','./View','./HTMLViewRenderer','sap/base/util/extend','sap/ui/base/ManagedObject','sap/ui/core/DeclarativeSupport','sap/ui/core/library','sap/ui/model/resource/ResourceModel'],function(q,V,H,e,M,D,l,R){"use strict";var a=l.mvc.ViewType;
var b=V.extend("sap.ui.core.mvc.HTMLView",{metadata:{library:"sap.ui.core"}});
b.create=function(o){var p=e(true,{},o);p.type=a.HTML;return V.create(p);};
sap.ui.htmlview=function(i,v){return sap.ui.view(i,v,a.HTML);};
b._sType=a.HTML;b.asyncSupport=true;b._mTemplates={};b._mAllowedSettings={"viewName":true,"controller":true,"viewContent":true,"definition":true,"controllerName":true,"resourceBundleName":true,"resourceBundleUrl":true,"resourceBundleLocale":true,"resourceBundleAlias":true};
b._getTemplate=function(t,o){var u=this._getViewUrl(t);var h=this._mTemplates[u];if(!h){h=this._loadTemplate(t,o);if(o&&o.async){var c=this;return h.then(function(_){c._mTemplates[u]=_;return Promise.resolve(_);});}else{this._mTemplates[u]=h;}}return o.async?Promise.resolve(h):h;};
b.prototype.getControllerName=function(){return this._controllerName;};
b._getViewUrl=function(t){return q.sap.getModulePath(t,".view.html");};
b._loadTemplate=function(t,o){var r=q.sap.getResourceName(t,".view.html");return q.sap.loadResource(r,o);};
b.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if(!s.viewName&&!s.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.");}var t=this;function I(){t._oTemplate=document.createElement("div");if(typeof h==="string"){t._oTemplate.innerHTML=h;}else{var n=h;var f=document.createDocumentFragment();for(var i=0;i<n.length;i++){f.appendChild(n.item(i));}t._oTemplate.appendChild(f);}var m=t._oTemplate.getElementsByTagName("template")[0];var p=t.getMetadata().getAllProperties();if(m){q.each(m.attributes,function(d,A){var N=D.convertAttributeToSettingName(A.name,t.getId());var v=A.value;var P=p[N];if(!s[N]){if(P){s[N]=D.convertValueToType(D.getPropertyDataType(P),v);}else if(b._mAllowedSettings[N]){s[N]=v;}}});t._oTemplate=m;}if(t._oTemplate.content){var f=t._oTemplate.content;t._oTemplate=document.createElement("div");t._oTemplate.appendChild(f);}if(s.controllerName){t._controllerName=s.controllerName;}if((s.resourceBundleName||s.resourceBundleUrl)&&(!s.models||!s.models[s.resourceBundleAlias])){var c=new R({bundleName:s.resourceBundleName,bundleUrl:s.resourceBundleUrl,bundleLocale:s.resourceBundleLocale});t.setModel(c,s.resourceBundleAlias);}}var h=s.viewContent;if(!h){h=b._getTemplate(s.viewName,{async:s.async});}if(s.async){return h.then(function(_){h=_;I();});}I();};
b.prototype.onControllerConnected=function(c){var t=this;M.runWithPreprocessors(function(){D.compile(t._oTemplate,t);},{settings:this._fnSettingsPreprocessor});};
b.prototype.exit=function(){this._oTemplate=null;V.prototype.exit.call(this);if(this._connectedControls){for(var i=0;i<this._connectedControls.length;i++){this._connectedControls[i].destroy();}this._connectedControls=null;}};
b.prototype.connectControl=function(c){this._connectedControls=this._connectedControls||[];this._connectedControls.push(c);};
return b;});
sap.ui.predefine('sap/ui/core/mvc/HTMLViewRenderer',['./ViewRenderer'],function(V){"use strict";var H={};
H.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiView");a.addClass("sapUiHTMLView");V.addDisplayClass(a,c);if(c.getWidth()){a.addStyle("width",c.getWidth());}if(c.getHeight()){a.addStyle("height",c.getHeight());}a.writeStyles();a.writeClasses();a.write(">");if(c._oTemplate){var h=c._oTemplate.innerHTML;var b=c.getContent();var d=[];var e=function(c){var t=H._getHTML(a,c,h);if(t){h=t;}else{d.push(c);}};if(b){if(Array.isArray(b)){for(var i=0;i<b.length;i++){e(b[i]);}}else if(b){e(b);}}a.write(h);for(var i=0;i<d.length;i++){a.renderControl(d[i]);}}a.write("</div>");};
H._getHTML=function(r,c,h){var i=c.getId();h=h.replace(/(<div)/gi,"\n$1");var a=new RegExp('<div.*?data-sap-ui-id="'+i+'".*?></div>',"gi");var m=a.exec(h);if(m){h=h.replace(m[0],r.getHTML(c));return h;}else{return"";}};
return H;},true);
sap.ui.predefine('sap/ui/core/mvc/JSONView',['jquery.sap.global','./View','./JSONViewRenderer','./EventHandlerResolver','sap/base/util/extend','sap/ui/base/ManagedObject','sap/ui/core/library','sap/ui/model/resource/ResourceModel'],function(q,V,J,E,e,M,l,R){"use strict";var a=l.mvc.ViewType;
var b=V.extend("sap.ui.core.mvc.JSONView",{metadata:{library:"sap.ui.core"}});
b.create=function(o){var p=e(true,{},o);for(var O in p){if(O==='preprocessors'){delete p[O];q.sap.log.warning("JSView.create does not support the option preprocessors!");}}p.type=a.JSON;return V.create(p);};
sap.ui.jsonview=function(i,v){return sap.ui.view(i,v,a.JSON);};
b._sType=a.JSON;b.asyncSupport=true;
b.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if(!s.viewName&&!s.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.");}var t=this;var i=function(){if((t._oJSONView.resourceBundleName||t._oJSONView.resourceBundleUrl)&&(!s.models||!s.models[t._oJSONView.resourceBundleAlias])){var m=new R({bundleName:t._oJSONView.resourceBundleName,bundleUrl:t._oJSONView.resourceBundleUrl});t.setModel(m,t._oJSONView.resourceBundleAlias);}};if(s.viewName){if(s.async){return this._loadTemplate(s.viewName,{async:true}).then(i);}else{this._loadTemplate(s.viewName);i();}}else if(s.viewContent){this.mProperties["viewContent"]=s.viewContent;if(typeof s.viewContent==="string"){this._oJSONView=q.parseJSON(s.viewContent);if(!this._oJSONView){throw new Error("error when parsing viewContent: "+s.viewContent);}}else if(typeof s.viewContent==="object"){this._oJSONView=s.viewContent;}else{throw new Error("viewContent must be a JSON string or object, but is a "+(typeof s.viewContent));}if(s.async){return Promise.resolve().then(i);}else{i();}}};
b.prototype.onControllerConnected=function(c){var t=this;M.runWithPreprocessors(function(){t.applySettings({content:t._oJSONView.content},c);},{id:function(i){return t.createId(i);},settings:function(s){var m=this.getMetadata(),v=m.getJSONKeys(),k,o,K;for(k in s){if((K=v[k])!==undefined){o=s[k];switch(K._iKind){case 3:if(typeof o==="string"){s[k]=t.createId(o);}break;case 5:if(typeof o==="string"){s[k]=E.resolveEventHandler(o,c);}break;}}}}});};
b.prototype._loadTemplate=function(t,o){var r=q.sap.getResourceName(t,".view.json");if(!o||!o.async){this._oJSONView=q.sap.loadResource(r);}else{var c=this;return q.sap.loadResource(r,o).then(function(j){c._oJSONView=j;});}};
b.prototype.getControllerName=function(){return this._oJSONView.controllerName;};
return b;});
sap.ui.predefine('sap/ui/core/mvc/JSONViewRenderer',['./ViewRenderer','sap/ui/core/Control'],function(V,C){"use strict";var J={};
J.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiView");a.addClass("sapUiJSONView");V.addDisplayClass(a,c);if(c.getWidth()){a.addStyle("width",c.getWidth());}if(c.getHeight()){a.addStyle("height",c.getHeight());}a.writeStyles();a.writeClasses();a.write(">");var b=c.getContent();if(b){if(b instanceof Array&&!(b instanceof C)){for(var i=0;i<b.length;i++){a.renderControl(b[i]);}}else{a.renderControl(c.getContent());}}a.write("</div>");};
return J;},true);
sap.ui.predefine('sap/ui/core/mvc/JSView',['jquery.sap.global','./View','./JSViewRenderer','sap/base/util/extend','sap/ui/base/ManagedObject','sap/ui/core/library'],function(q,V,J,e,M,l){"use strict";
var a=V.extend("sap.ui.core.mvc.JSView",{metadata:{library:"sap.ui.core"}});
var r={};a.asyncSupport=true;var b=l.mvc.ViewType;
a.create=function(o){var p=e(true,{},o);for(var O in p){if(O==='definition'||O==='preprocessors'){delete p[O];q.sap.log.warning("JSView.create does not support the options definition or preprocessor!");}}p.type=b.JS;return V.create(p);};
sap.ui.jsview=function(i,c,A){if(c&&c.async){q.sap.log.info("Do not use deprecated factory function 'sap.ui.jsview' for view instance creation. Use 'JSView.create' instead.");}else{q.sap.log.warning("Do not use synchronous view creation! Use the new asynchronous factory 'JSView.create' for view instance creation instead.");}return v.apply(this,arguments);};
function v(i,c,A){var s={},o;if(c&&typeof(c)=="string"){s.viewName=c;if(typeof arguments[2]=="boolean"){s.async=A;}else if(typeof arguments[2]=="object"){s.controller=arguments[2];s.async=!!arguments[3];}o=new a(i,s);return o;}else if(c&&typeof(c)=="object"){r[i]=c;q.sap.declare({modName:i,type:"view"},false);q.sap.log.info("For defining views use JSView.extend instead.");}else if(arguments.length==1&&typeof i=="string"||arguments.length==2&&typeof arguments[0]=="string"&&typeof arguments[1]=="boolean"){s.viewName=arguments[0];s.async=!!arguments[1];o=s.id?new a(s.id,s):new a(s);return o;}else{throw new Error("Wrong arguments ('"+i+"', '"+c+"')! Either call sap.ui.jsview([sId,] sViewName) to instantiate a View or sap.ui.jsview(sViewName, oViewImpl) to define a View type.");}}
a.prototype.initViewSettings=function(s){var p;if(!r[s.viewName]){var m=q.sap.getResourceName(s.viewName,".view");if(s.async){p=new Promise(function(c){sap.ui.require([m],c);});}else{sap.ui.requireSync(m);}}if(s.async){return Promise.resolve(p).then(function(){q.extend(this,r[s.viewName]);}.bind(this));}q.extend(this,r[s.viewName]);};
a.prototype.onControllerConnected=function(c){M.runWithPreprocessors(function(){this.applySettings({content:this.createContent(c)});},{id:this.getAutoPrefixId()?this.createId.bind(this):undefined,settings:this._fnSettingsPreprocessor},this);};
a.prototype.getAutoPrefixId=function(){return false;};
return a;});
sap.ui.predefine('sap/ui/core/mvc/JSViewRenderer',['./ViewRenderer'],function(V){"use strict";var J={};
J.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiView");a.addClass("sapUiJSView");V.addDisplayClass(a,c);if(c.getWidth()){a.addStyle("width",c.getWidth());}if(c.getHeight()){a.addStyle("height",c.getHeight());}a.writeStyles();a.writeClasses();a.write(">");var b=c.getContent();if(b){if(Array.isArray(b)){for(var i=0;i<b.length;i++){a.renderControl(b[i]);}}else if(b){a.renderControl(b);}}a.write("</div>");};
return J;},true);
sap.ui.predefine('sap/ui/core/mvc/OverrideExecution',function(){"use strict";var O={After:"After",Before:"Before",Instead:"Instead"};return O;},true);
sap.ui.predefine('sap/ui/core/mvc/TemplateView',['jquery.sap.global','sap/ui/core/library','./View',"./TemplateViewRenderer"],function(q,l,V,T){"use strict";var a=l.mvc.ViewType;
var b=V.extend("sap.ui.core.mvc.TemplateView",{metadata:{library:"sap.ui.core"}});
(function(){
sap.ui.templateview=function(i,v){q.sap.log.warning("sap.ui.core.mvc.TemplateView is deprecated. Use XMLView or JSView instead.");return sap.ui.view(i,v,a.Template);};
b._sType=a.Template;
b.prototype.getControllerName=function(){return this._sControllerName;};
b._getViewUrl=function(t){return q.sap.getModulePath(t,".view.tmpl");};
b.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(!s.viewName){throw new Error("No view name is given.");}this._oTemplate=sap.ui.template({id:this.getId(),src:b._getViewUrl(s.viewName)});this._sControllerName=this._oTemplate._sControllerName;this._oTemplate=this._oTemplate.createControl(undefined,undefined,this);this.addContent(this._oTemplate);};
}());return b;});
sap.ui.predefine('sap/ui/core/mvc/TemplateViewRenderer',['./ViewRenderer'],function(V){"use strict";var T={};
T.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiView");a.addClass("sapUiTmplView");V.addDisplayClass(a,c);a.addStyle("width",c.getWidth());a.addStyle("height",c.getHeight());a.writeStyles();a.writeClasses();a.write(">");a.renderControl(c._oTemplate);a.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/core/mvc/View',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/mvc/Controller','sap/base/util/extend','sap/ui/core/library',"./ViewRenderer"],function(q,M,C,a,e,b,V){"use strict";var c=b.mvc.ViewType;
var d=C.extend("sap.ui.core.mvc.View",{metadata:{interfaces:["sap.ui.core.IDScope"],library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:'sap.ui.core.mvc.Controller',controllerName:'string',preprocessors:'Object',resourceBundleName:'string',resourceBundleUrl:'sap.ui.core.URI',resourceBundleLocale:'string',resourceBundleAlias:'string',type:'string',definition:'any',viewContent:{type:'any',deprecated:true},viewData:'any',async:{type:"boolean",defaultValue:false}},designtime:"sap/ui/core/designtime/mvc/View.designtime"}});
d._mPreprocessors={};
function f(P){P._settings={};for(var i in P){if(i.indexOf("_")!==0){P._settings[i]=P[i];}}}
function g(P,A){var i;if(typeof P.preprocessor==="string"){var j=P.preprocessor.replace(/\./g,"/");if(A){return new Promise(function(l,u){sap.ui.require([j],function(i){l(i);});});}else{return sap.ui.requireSync(j);}}else if(typeof P.preprocessor==="function"&&!P.preprocessor.process){i={process:P.preprocessor};}else{i=P.preprocessor;}if(A){return Promise.resolve(i);}else{return i;}}
function h(j,T){var L=this.mPreprocessors[T]||[],G=[],i,l,O,P=[];if(d._mPreprocessors[j]&&d._mPreprocessors[j][T]){G=d._mPreprocessors[j][T].map(function(u){return q.extend({},u);});}for(i=0,l=G.length;i<l;i++){if(G[i]._onDemand){O=G[i];}else{P.push(G[i]);}}for(i=0,l=L.length;i<l;i++){var I=!L[i].preprocessor;if(I&&O){P.unshift(q.extend(L[i],O));}else if(!I){P.push(L[i]);}}return P;}
function k(i,S){var j=i.getMetadata().getClass();function l(P){P.preprocessor=g(P,S.async);}i.mPreprocessors=q.extend({},S.preprocessors);for(var _ in j.PreprocessorType){var T=j.PreprocessorType[_];if(i.mPreprocessors[T]&&!Array.isArray(i.mPreprocessors[T])){i.mPreprocessors[T]=[i.mPreprocessors[T]];}else if(!i.mPreprocessors[T]){i.mPreprocessors[T]=[];}i.mPreprocessors[T].forEach(f);i.mPreprocessors[T]=h.call(i,j._sType,T);i.mPreprocessors[T].forEach(l);}}
function m(i){i.oAsyncState={};i.oAsyncState.promise=null;}
var n=function(T,S){if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){var i=S.controller,N=i&&typeof i.getMetadata==="function"&&i.getMetadata().getName(),A=S.async;if(!i&&T.getControllerName){var j=T.getControllerName();if(j){var l=sap.ui.require('sap/ui/core/CustomizingConfiguration');var u=l&&l.getControllerReplacement(j,M._sOwnerId);if(u){j=typeof u==="string"?u:u.controllerName;}i=sap.ui.controller(j,true,A);}}else if(i){var O=M._sOwnerId;if(!i._isExtended()){if(A){i=a.extendByCustomizing(i,N,A).then(function(i){return a.extendByProvider(i,N,O,A);});}else{i=a.extendByCustomizing(i,N,A);i=a.extendByProvider(i,N,O,A);}}else if(A){i=Promise.resolve(i);}}if(i){var w=function(i){T.oController=i;i.oView=T;};if(A){if(!T.oAsyncState){throw new Error("The view "+T.sViewName+" runs in sync mode and therefore cannot use async controller extensions!");}return i.then(w);}else{w(i);}}}else{sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl",{"_sap.ui.core.mvc.EmptyControllerImpl":true});T.oController=sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl");}};
d.prototype._initCompositeSupport=function(S){this.oViewData=S.viewData;this.sViewName=S.viewName;var i=this;k(this,S);if(S.async){m(this);}var j=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(j&&j.hasCustomProperties(this.sViewName,this)){this._fnSettingsPreprocessor=function(S){var I=this.getId();if(j&&I){if(i.isPrefixedId(I)){I=I.substring((i.getId()+"--").length);}var l=j.getCustomProperties(i.sViewName,I,i);if(l){S=q.extend(S,l);}}};}var P=function(l,u){var w=sap.ui.require("sap/ui/core/Component");var O=w&&w.getOwnerComponentFor(i);if(O){if(u){i.fnScopedRunWithOwner=i.fnScopedRunWithOwner||function(x){return O.runAsOwner(x);};}return O.runAsOwner(l);}return l();};var A=function(l){if(l.oController&&l.oController.connectToView){return l.oController.connectToView(l);}};var F=function(){if(i.onControllerConnected){return i.onControllerConnected(i.oController);}};if(this.initViewSettings){if(S.async){this.oAsyncState.promise=this.initViewSettings(S).then(function(){return P(n.bind(null,i,S),true);}).then(function(){return P(F,true);}).then(function(){return A(i);}).then(function(){return i.runPreprocessor("controls",i,false);}).then(function(){return P(i.fireAfterInit.bind(i),true);}).then(function(){return i;});}else{this.initViewSettings(S);n(this,S);F();A(this);this.runPreprocessor("controls",this,true);this.fireAfterInit();}}};
d.prototype.getController=function(){return this.oController;};
d.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};
d.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"--"+i;}return i;};
d.prototype.getLocalId=function(i){var P=this.getId()+"--";return(i&&i.indexOf(P)===0)?i.slice(P.length):null;};
d.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"--")===0);};
d.prototype.getViewData=function(){return this.oViewData;};
function o(){this.oAsyncState=null;}
d.prototype.exit=function(){this.fireBeforeExit();delete this.oController;delete this.oPreprocessorInfo;if(this.oAsyncState){var D=o.bind(this);this.oAsyncState.promise.then(D,D);}};
d.prototype.onAfterRendering=function(){this.fireAfterRendering();};
d.prototype.onBeforeRendering=function(){this.fireBeforeRendering();};
d.prototype.clone=function(i,l){var S={},K,u;for(K in this.mProperties&&!(this.isBound&&this.isBound(K))){if(this.mProperties.hasOwnProperty(K)){S[K]=this.mProperties[K];}}u=C.prototype.clone.call(this,i,l,{cloneChildren:false,cloneBindings:true});var E,w,j;for(E in u.mEventRegistry){w=u.mEventRegistry[E];for(j=w.length-1;j>=0;j--){if(w[j].oListener===this.getController()){w[j]={oListener:u.getController(),fFunction:w[j].fFunction,oData:w[j].oData};}}}u.applySettings(S);return u;};
d.prototype.getPreprocessors=function(){return this.mPreprocessors;};
d.prototype.getPreprocessorInfo=function(S){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!S};}if(d._supportInfo){this.oPreprocessorInfo._supportInfo=d._supportInfo;}return this.oPreprocessorInfo;};
d.prototype.runPreprocessor=function(T,S,j){var u=this.getPreprocessorInfo(j),P=this.mPreprocessors&&this.mPreprocessors[T]||[],w,A,x;if(!j){A=function(u,y){return function(S){return y.preprocessor.then(function(z){return z.process(S,u,y._settings);});};};x=Promise.resolve(S);}for(var i=0,l=P.length;i<l;i++){if(j&&P[i]._syncSupport===true){w=P[i].preprocessor.process;S=w(S,u,P[i]._settings);}else if(!j){x=x.then(A(u,P[i]));}else{q.sap.log.debug("Async \""+T+"\"-preprocessor was skipped in sync view execution for "+this.getMetadata().getClass()._sType+"View",this.getId());}}return j?S:x;};
function p(T,i){if(!d._mPreprocessors[i]){d._mPreprocessors[i]={};}if(!d._mPreprocessors[i][T]){d._mPreprocessors[i][T]=[];}}
function r(i,j,T){d._mPreprocessors[j][T].forEach(function(P){if(P._onDemand){q.sap.log.error("Registration for \""+T+"\" failed, only one on-demand-preprocessor allowed",i.getMetadata().getName());return false;}});return true;}
d.registerPreprocessor=function(T,P,i,S,O,j){if(typeof O!=="boolean"){j=O;O=false;}if(P){p(T,i);if(O&&!r(this,i,T)){return;}d._mPreprocessors[i][T].push({preprocessor:P,_onDemand:O,_syncSupport:S,_settings:j});q.sap.log.debug("Registered "+(O?"on-demand-":"")+"preprocessor for \""+T+"\""+(S?" with syncSupport":""),this.getMetadata().getName());}else{q.sap.log.error("Registration for \""+T+"\" failed, no preprocessor specified",this.getMetadata().getName());}};
d.prototype.hasPreprocessor=function(T){return!!this.mPreprocessors[T].length;};
d.create=function(O){var P=e(true,{},O);P.async=true;P.viewContent=P.definition;var i=sap.ui.require("sap/ui/core/Component");var j;if(i&&M._sOwnerId){j=i.get(M._sOwnerId);}function t(){return v(P.id,P,P.type).loaded();}return new Promise(function(l,u){var w=s(P);sap.ui.require([w],function(x){l(x);},function(E){u(E);});}).then(function(l){if(j){return j.runAsOwner(t);}else{return t();}});};
sap.ui.view=function(i,j,T){if(j&&j.async){q.sap.log.info("Do not use deprecated factory function 'sap.ui.view'. Use 'sap.ui.mvc.View.create' instead");}else{q.sap.log.warning("Do not use synchronous view creation! Use the new asynchronous factory 'sap.ui.mvc.View.create' instead");}return v(i,j,T);};
function v(i,j,T){var l=null,u={};if(typeof i==="object"||typeof i==="string"&&j===undefined){j=i;i=undefined;}if(j){if(typeof j==="string"){u.viewName=j;}else{u=j;}}if(i){u.id=i;}if(T){u.type=T;}var w=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(w){var x=w.getViewReplacement(u.viewName,M._sOwnerId);if(x){q.sap.log.info("Customizing: View replacement for view '"+u.viewName+"' found and applied: "+x.viewName+" (type: "+x.type+")");q.extend(u,x);}else{q.sap.log.debug("Customizing: no View replacement found for view '"+u.viewName+"'.");}}var y=s(u);l=t(y,u);return l;}
function s(i){var j;if(!i.type){throw new Error("No view type specified.");}else if(i.type===c.JS){j='sap/ui/core/mvc/JSView';}else if(i.type===c.JSON){j='sap/ui/core/mvc/JSONView';}else if(i.type===c.XML){j='sap/ui/core/mvc/XMLView';}else if(i.type===c.HTML){j='sap/ui/core/mvc/HTMLView';}else if(i.type===c.Template){j='sap/ui/core/mvc/TemplateView';}else{throw new Error("Unknown view type "+i.type+" specified.");}return j;}
function t(i,j){var l=sap.ui.require(i);if(!l){l=sap.ui.requireSync(i);if(j.async){q.sap.log.warning("sap.ui.view was called without requiring the according view class.");}}return new l(j);}
d.prototype.loaded=function(){if(this.oAsyncState&&this.oAsyncState.promise){return this.oAsyncState.promise;}else{return Promise.resolve(this);}};
return d;});
sap.ui.predefine('sap/ui/core/mvc/ViewRenderer',function(){"use strict";var V={};
V.addDisplayClass=function(r,c){if(c.getDisplayBlock()||(c.getWidth()==="100%"&&c.getHeight()==="100%")){r.addClass("sapUiViewDisplayBlock");}};
return V;},true);
sap.ui.predefine('sap/ui/core/mvc/XMLView',['jquery.sap.global','./View',"./XMLViewRenderer","sap/base/util/extend",'sap/ui/base/ManagedObject','sap/ui/core/XMLTemplateProcessor','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/core/cache/CacheManager','sap/ui/model/resource/ResourceModel','jquery.sap.xml','jquery.sap.script'],function(q,V,X,a,M,b,l,C,R,c,d){"use strict";var f=R.RenderPrefixes,g=l.mvc.ViewType,x="XMLViewCacheError",n={};
var h=V.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'},cache:'Object',processingMode:{type:"string",defaultValue:"",visibility:"hidden"}},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"}});
sap.ui.xmlview=function(i,e){return sap.ui.view(i,e,g.XML);};
h.create=function(o){var P=a(true,{},o);P.viewContent=P.definition;P.async=true;P.type=g.XML;P.processingMode=P.processingMode||"sequential";return V.create(P);};
h._sType=g.XML;h.asyncSupport=true;h._bUseCache=sap.ui.getCore().getConfiguration().getViewCache()&&c._isSupportedEnvironment();
function v(e){if(e.parseError.errorCode!==0){var P=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}}
function j(o,S){if(!S){throw new Error("mSettings must be given");}else if(S.viewName&&S.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((S.viewName||S.viewContent)&&S.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(S.viewName||S.viewContent)&&!S.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}else if(S.cache&&!(S.cache.keys&&S.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.");}}
function k(o,S){o.mProperties["viewContent"]=S.viewContent;var e=q.sap.parseXML(S.viewContent);v(e);return e.documentElement;}
function s(o,S){if((o._resourceBundleName||o._resourceBundleUrl)&&(!S.models||!S.models[o._resourceBundleAlias])){var e=new d({bundleName:o._resourceBundleName,bundleUrl:o._resourceBundleUrl,bundleLocale:o._resourceBundleLocale});o.setModel(e,o._resourceBundleAlias);}}
function m(o){o.oAfterRenderingNotifier=new D();o.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){o.onAfterRenderingBeforeChildren();}});}
function p(S){var e=sap.ui.require("sap/ui/core/Component"),o;while(S&&e){var i=e.getOwnerComponentFor(S);if(i){S=o=i;}else{if(S instanceof e){o=S;}S=S.getParent&&S.getParent();}}return o;}
function r(o,e){var i=p(o),E=i?JSON.stringify(i.getManifest()):null,F=[];F=F.concat(w(o,i),z(),y(o),e.keys);return u(o,F).then(function(K){return{key:K+"("+q.sap.hashCode(E||"")+")",componentManifest:E,additionalData:e.additionalData};});}
function t(K){return K;}
function u(o,F){return Promise.all(F).then(function(K){K=K.filter(function(E){return E!==n;});if(K.every(t)){return K.join('_');}else{var e=new Error("Provided cache keys may not be empty or undefined.");e.name=x;return Promise.reject(e);}});}
function w(o,e){var i=e&&e.getMetadata().getName();return[i||window.location.host+window.location.pathname,o.getId(),sap.ui.getCore().getConfiguration().getLanguageTag()];}
function y(e){var P=e.getPreprocessors(),i=e.getPreprocessorInfo(false),F=[];function E(o){F.push(o.preprocessor.then(function(G){if(G.getCacheKey){return G.getCacheKey(i);}else{return n;}}));}for(var T in P){P[T].forEach(E);}return F;}
function z(){return sap.ui.getVersionInfo({async:true}).then(function(i){var T="";if(!i.libraries){T=sap.ui.buildinfo.buildtime;}else{i.libraries.forEach(function(L){T+=L.buildTimestamp;});}return T;}).catch(function(e){q.sap.log.warning("sap.ui.getVersionInfo could not be retrieved","sap.ui.core.mvc.XMLView");q.sap.log.debug(e);return"";});}
function A(e,i){var K=e.key;delete e.key;e.xml=q.sap.serializeXML(i);return c.set(K,e);}
function B(e){return c.get(e.key).then(function(i){if(i&&i.componentManifest==e.componentManifest){i.xml=q.sap.parseXML(i.xml,"application/xml").documentElement;if(i.additionalData){q.extend(true,e.additionalData,i.additionalData);}return i;}});}
h.prototype.initViewSettings=function(S){var e=this,_;function i(J){e._xContent=J;if(V._supportInfo){V._supportInfo({context:e._xContent,env:{caller:"view",viewinfo:q.extend(true,{},e),settings:q.extend(true,{},S||{}),type:"xmlview"}});}if(!e.isSubView()){var K={};b.parseViewAttributes(J,e,K);if(!S.async){q.sap.extend(S,K);}else{e.applySettings(K);}}else{delete S.controller;}s(e,S);m(e);}function o(J,K){if(e.hasPreprocessor("viewxml")){return b.enrichTemplateIdsPromise(J,e,K).then(function(){return e.runPreprocessor("viewxml",J,!K);});}return J;}function E(J){return e.runPreprocessor("xml",J).then(function(J){return o(J,true);});}function F(I){return q.sap.loadResource(I,{async:true}).then(function(J){return J.documentElement;});}function G(I,J){return F(I).then(E).then(function(K){if(J){A(J,K);}return K;});}function H(I,J){return r(e,J).then(function(K){return B(K).then(function(L){if(!L){return G(I,K);}else{return L.xml;}});}).catch(function(K){if(K.name===x){q.sap.log.debug(K.message,K.name,"sap.ui.core.mvc.XMLView");q.sap.log.debug("Processing the View without caching.","sap.ui.core.mvc.XMLView");return G(I);}else{return Promise.reject(K);}});}this._oContainingView=S.containingView||this;this._sProcessingMode=S.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true;}j(this,S);if(S.viewName){var I=q.sap.getResourceName(S.viewName,".view.xml");if(S.async){if(S.cache&&h._bUseCache){return H(I,S.cache).then(i);}else{return F(I).then(E).then(i);}}else{_=q.sap.loadResource(I).documentElement;}}else if(S.viewContent){if(S.viewContent.nodeType===window.Node.DOCUMENT_NODE){_=S.viewContent.documentElement;}else{_=k(this,S);}}else if(S.xmlNode){_=S.xmlNode;}if(S.async){return E(_).then(i);}else{_=this.runPreprocessor("xml",_,true);_=o(_,false);if(_&&typeof _.then==='function'){if(_.isRejected()){throw _.getResult();}_=_.getResult();}i(_);}};
h.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};
h.prototype.onControllerConnected=function(o){var e=this;function i(E){return M.runWithPreprocessors(E,{settings:e._fnSettingsPreprocessor});}if(!this.oAsyncState){this._aParsedContent=i(b.parseTemplate.bind(null,this._xContent,this));}else{return b.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:i}).then(function(P){e._aParsedContent=P;delete e.oAsyncState.suppressPreserve;});}};
h.prototype.getControllerName=function(){return this._controllerName;};
h.prototype.isSubView=function(){return this._oContainingView!=this;};
h.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var i=0;i<e.length;i++){var o=e[i].getDomRef()||q.sap.domById(f.Invisible+e[i].getId());if(o){q.sap.byId(f.Dummy+e[i].getId(),this._$oldContent).replaceWith(o);}}}q.sap.byId(f.Dummy+this.getId()).replaceWith(this._$oldContent);}this._$oldContent=undefined;};
h.prototype._onChildRerenderedEmpty=function(o,e){q(e).replaceWith('<div id="'+f.Dummy+o.getId()+'" class="sapUiHidden"/>');return true;};
h.prototype.destroy=function(S){var $=R.findPreservedContent(this.getId());if($){$.remove();}if(S=="KeepDom"&&this.getDomRef()){this.getDomRef().removeAttribute("data-sap-ui-preserve");}V.prototype.destroy.call(this,S);};
h.registerPreprocessor=function(T,P,S,o,e){T=T.toUpperCase();if(h.PreprocessorType[T]){V.registerPreprocessor(h.PreprocessorType[T],P,this.getMetadata().getClass()._sType,S,o,e);}else{q.sap.log.error("Preprocessor could not be registered due to unknown sType \""+T+"\"",this.getMetadata().getName());}};
h.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};
var D=C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{
metadata:{library:"sap.ui.core"},
renderer:function(o,e){o.write("");}
});
h.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return h;});
sap.ui.predefine('sap/ui/core/mvc/XMLViewRenderer',['jquery.sap.global','./ViewRenderer','../RenderManager'],function(q,V,R){"use strict";var P=R.RenderPrefixes.Dummy,a=R.RenderPrefixes.Invisible;var X={};
X.render=function(r,c){var d=c.getDomRef();if(d&&!R.isPreservedContent(d)){R.preserveContent(d,true);}var $=c._$oldContent=R.findPreservedContent(c.getId());if($.length===0){var s=c.isSubView();if(!s){r.write("<div");r.writeControlData(c);r.addClass("sapUiView");r.addClass("sapUiXMLView");V.addDisplayClass(r,c);if(!c.oAsyncState||!c.oAsyncState.suppressPreserve){r.writeAttribute("data-sap-ui-preserve",c.getId());}if(c.getWidth()){r.addStyle("width",c.getWidth());}if(c.getHeight()){r.addStyle("height",c.getHeight());}r.writeStyles();r.writeClasses();r.write(">");}if(c._aParsedContent){for(var i=0;i<c._aParsedContent.length;i++){var f=c._aParsedContent[i];if(f&&typeof(f)==="string"){r.write(f);}else{r.renderControl(f);if(!f.bOutput){r.write('<div id="'+P+f.getId()+'" class="sapUiHidden"/>');}}}}if(!s){r.write("</div>");}}else{r.renderControl(c.oAfterRenderingNotifier);r.write('<div id="'+P+c.getId()+'" class="sapUiHidden">');for(var i=0;i<c._aParsedContent.length;i++){var f=c._aParsedContent[i];if(typeof(f)!=="string"){r.renderControl(f);var F=f.getId(),b=q.sap.byId(F,$);if(b.length==0){b=q.sap.byId(a+F,$);}b.replaceWith('<div id="'+P+F+'" class="sapUiHidden"/>');}}r.write('</div>');}};
return X;},true);
sap.ui.predefine('sap/ui/core/plugin/TemplatingSupport',['jquery.sap.global','sap/ui/core/Core','sap/ui/core/tmpl/Template'],function(q,C,T){"use strict";var a=function(){};
a.prototype.startPlugin=function(c,o){q.sap.log.info("Starting TemplatingSupport plugin.");this.oCore=c;sap.ui.template();};
a.prototype.stopPlugin=function(){q.sap.log.info("Stopping TemplatingSupport plugin.");this.oCore=null;};
(function(){var t=new a();sap.ui.getCore().registerPlugin(t);}());return a;},true);
sap.ui.predefine('sap/ui/core/postmessage/Bus',["sap/ui/core/EventBus","sap/base/util/equal","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/util/isWindow","sap/base/Log"],function(E,e,i,a,b,L){"use strict";var I;var s='______UI5______';
var P=E.extend("sap.ui.core.postmessage.Bus",{constructor:function(){if(I){return I;}I=this;E.apply(this,arguments);this._aAcceptedOrigins=[window.location.origin];this._aDeclinedOrigins=[];this._oPendingProcess=null;this._aEventQueue=[];this._receiver=this._receiver.bind(this);window.addEventListener('message',this._receiver);}});
P.event={CONNECT:'______CONNECT______',READY:'______READY______',ACCEPTED:'______ACCEPTED______',DECLINED:'______DECLINED______'};
P.prototype.destroy=function(){window.removeEventListener('message',this._receiver);this._aEventQueue=[];E.prototype.destroy.apply(this,arguments);I=undefined;this.bIsDestroyed=true;};
P.getInstance=function(){if(!I){I=new P();}return I;};
P.prototype.publish=function(p){var t=p.target;var o=p.origin;var c=p.channelId;var d=p.eventId;var D=p.data;if(d===P.event.READY){if(!t){if(window.opener&&window.opener!==window){t=window.opener;}else if(window.parent!==window){t=window.parent;}else{return;}}if(!o){o='*';}}if(!b(t)||t===window){throw TypeError("Target must be a window object and has to differ from current window");}if(typeof o!=="string"){throw TypeError("Origin must be a string");}if(typeof c!=="string"){throw TypeError("ChannelId must be a string");}if(typeof d!=="string"){throw TypeError("EventId must be a string");}if(!i([P.event.READY,P.event.ACCEPTED,P.event.DECLINED],d)&&o!=='*'&&!i(this._aAcceptedOrigins,o)){this._aAcceptedOrigins.push(o);}var m={origin:o,channelId:c,eventId:d,data:D};m[s]=true;t.postMessage(m,o);};
P.prototype._callListener=function(c,l,C,d,D){c.call(l,D);};
P.prototype._getText=function(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);};
P.prototype._receiver=function(o){var d=o.data;if(!a(d)||!d.hasOwnProperty(s)){return;}if(this._oPendingProcess){this._aEventQueue.push(o);}else{this._oPendingProcess=this._processEvent(o);}};
P.prototype._processEvent=function(o){return new Promise(function(r){var d=o.data;var O=o.origin;if(i(this._aDeclinedOrigins,O)){r();return;}switch(d.eventId){case P.event.CONNECT:{if(typeof d.data!=="string"){this.publish({target:o.source,origin:o.origin,channelId:d.channelId,eventId:P.event.DECLINED});r();}else if(i(this._aAcceptedOrigins,O)){this.publish({target:o.source,origin:o.origin,channelId:d.channelId,eventId:P.event.ACCEPTED});r();}else{sap.ui.require(["sap/ui/core/postmessage/confirmationDialog"],function(c){c(this._getText('PostMessage.Message',[d.data,O])).then(function(){this.addAcceptedOrigin(O);this.publish({target:o.source,origin:o.origin,channelId:d.channelId,eventId:P.event.ACCEPTED});}.bind(this),function(){this.addDeclinedOrigin(O);this.publish({target:o.source,origin:o.origin,channelId:d.channelId,eventId:P.event.DECLINED});}.bind(this)).then(r);}.bind(this));}break;}case P.event.ACCEPTED:case P.event.DECLINED:case P.event.READY:{o.data.data=undefined;this._emitMessage(o);r();break;}default:{if(i(this._aAcceptedOrigins,O)){this._emitMessage(o);}r();}}}.bind(this)).catch(function(v){var m;var d;if(typeof v==='string'){m=v;}else if(v instanceof Error){m=v.message;d=v.stack;}else{m='Some unexpected error happened during post message processing';}L.error(m,d,'sap.ui.core.postmessage.Bus');}).then(function(){this._oPendingProcess=(this._aEventQueue.length>0?this._processEvent(this._aEventQueue.shift()):null);}.bind(this));};
P.prototype._emitMessage=function(o){var c=o.data.channelId;var d=o.data.eventId;E.prototype.publish.call(this,c,d,{originalEvent:o,channelId:c,eventId:d,source:o.source,origin:o.origin,data:o.data.data});};
P.prototype.getAcceptedOrigins=function(){return this._aAcceptedOrigins.slice();};
P.prototype.setAcceptedOrigins=function(o){if(!Array.isArray(o)){throw new TypeError('Expected an array, but got '+typeof o);}this._aAcceptedOrigins=o.slice();};
P.prototype.addAcceptedOrigin=function(o){if(typeof o!=='string'){throw new TypeError('Expected a string, but got '+typeof o);}if(!i(this._aAcceptedOrigins,o)){this._aAcceptedOrigins.push(o);}};
P.prototype.resetAcceptedOrigins=function(){this.setAcceptedOrigins([]);};
P.prototype.getDeclinedOrigins=function(){return this._aDeclinedOrigins.slice();};
P.prototype.setDeclinedOrigins=function(o){if(!Array.isArray(o)){throw new TypeError('Expected an array, but got '+typeof o);}this._aDeclinedOrigins=o.slice();};
P.prototype.addDeclinedOrigin=function(o){if(typeof o!=='string'){throw new TypeError('Expected a string, but got '+typeof o);}if(!i(this._aDeclinedOrigins,o)){this._aDeclinedOrigins.push(o);}};
P.prototype.resetDeclinedOrigins=function(){this.setDeclinedOrigins([]);};
return P;});
sap.ui.predefine('sap/ui/core/postmessage/confirmationDialog',function(){"use strict";return function(m){return new Promise(function(r,R){var M=sap.ui.getCore().getLoadedLibraries().hasOwnProperty('sap.m');if(M){sap.ui.require(['sap/m/MessageBox'],function(a){a.confirm(m,{actions:[a.Action.YES,a.Action.NO],onClose:function(A){if(A===a.Action.YES){r();}else{R();}}});});}else{var c=window.confirm(m);if(c){r();}else{R();}}});};});
sap.ui.predefine('sap/ui/core/routing/HashChanger',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/thirdparty/hasher'],function(q,E,h){"use strict";
var H=E.extend("sap.ui.core.routing.HashChanger",{constructor:function(){E.apply(this);}});
H.prototype.init=function(){if(this._initialized){q.sap.log.info("this HashChanger instance has already been initialized.");return false;}this._initialized=true;h.changed.add(this.fireHashChanged,this);if(!h.isActive()){h.initialized.addOnce(this.fireHashChanged,this);h.init();}else{this.fireHashChanged(h.getHash());}return this._initialized;};
H.prototype.fireHashChanged=function(n,o){this.fireEvent("hashChanged",{newHash:n,oldHash:o});};
H.prototype.setHash=function(s){this.fireEvent("hashSet",{sHash:s});h.setHash(s);};
H.prototype.replaceHash=function(s){this.fireEvent("hashReplaced",{sHash:s});h.replaceHash(s);};
H.prototype.getHash=function(){return h.getHash();};
H.prototype.destroy=function(){h.changed.remove(this.fireHashChanged,this);E.prototype.destroy.apply(this,arguments);};
(function(){var _=null;
H.getInstance=function(){if(!_){_=new H();}return _;};
function e(o){var s,a,n;for(s in _.mEventRegistry){if(_.mEventRegistry.hasOwnProperty(s)){a=_.mEventRegistry[s];n=o.mEventRegistry[s];if(n){o.mEventRegistry[s]=a.concat(n);}else{o.mEventRegistry[s]=a;}}}}
H.replaceHashChanger=function(o){if(_&&o){var g=q.sap.getObject("sap.ui.core.routing.History.getInstance"),a;if(g){a=g();a._unRegisterHashChanger();}e(o);_.destroy();if(a){a._setHashChanger(o);}}_=o;};
}());return H;});
sap.ui.predefine('sap/ui/core/routing/History',['jquery.sap.global','sap/ui/core/library','./HashChanger'],function(q,l,H){"use strict";var a=l.routing.HistoryDirection;var b=function(h){this._iHistoryLength=window.history.length;this.aHistory=[];this._bIsInitial=true;if(!h){q.sap.log.error("sap.ui.core.routing.History constructor was called and it did not get a hashChanger as parameter");}this._setHashChanger(h);this._reset();};
b.prototype.destroy=function(n){this._unRegisterHashChanger();};
b.prototype.getDirection=function(n){if(n!==undefined&&this._bIsInitial){return undefined;}if(n===undefined){return this._sCurrentDirection;}return this._getDirection(n);};
b.prototype.getPreviousHash=function(){return this.aHistory[this.iHistoryPosition-1];};
b.prototype._setHashChanger=function(h){if(this._oHashChanger){this._unRegisterHashChanger();}this._oHashChanger=h;this._oHashChanger.attachEvent("hashChanged",this._onHashChange,this);this._oHashChanger.attachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.attachEvent("hashSet",this._hashSet,this);};
b.prototype._unRegisterHashChanger=function(){this._oHashChanger.detachEvent("hashChanged",this._onHashChange,this);this._oHashChanger.detachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.detachEvent("hashSet",this._hashSet,this);this._oHashChanger=null;};
b.prototype._reset=function(){this.aHistory.length=0;this.iHistoryPosition=0;this._bUnknown=true;this.aHistory[0]=this._oHashChanger.getHash();};
b.prototype._getDirection=function(n,h,c){if(c&&this._oNextHash&&this._oNextHash.sHash===n){return a.NewEntry;}if(h){return a.NewEntry;}if(this._bUnknown){return a.Unknown;}if(this.aHistory[this.iHistoryPosition+1]===n&&this.aHistory[this.iHistoryPosition-1]===n){return a.Unknown;}if(this.aHistory[this.iHistoryPosition-1]===n){return a.Backwards;}if(this.aHistory[this.iHistoryPosition+1]===n){return a.Forwards;}return a.Unknown;};
b.prototype._onHashChange=function(e){this._hashChange(e.getParameter("newHash"));};
b.prototype._hashChange=function(n){var c=window.history.length,d;if(this._oNextHash&&this._oNextHash.bWasReplaced&&this._oNextHash.sHash===n){this.aHistory[this.iHistoryPosition]=n;this._oNextHash=null;if(!this._bIsInitial){this._sCurrentDirection=a.Unknown;}return;}this._bIsInitial=false;d=this._sCurrentDirection=this._getDirection(n,this._iHistoryLength<window.history.length,true);this._iHistoryLength=c;if(this._oNextHash){this._oNextHash=null;}if(d===a.Unknown){this._reset();return;}this._bUnknown=false;if(d===a.NewEntry){if(this.iHistoryPosition+1<this.aHistory.length){this.aHistory=this.aHistory.slice(0,this.iHistoryPosition+1);}this.aHistory.push(n);this.iHistoryPosition+=1;return;}if(d===a.Forwards){this.iHistoryPosition++;return;}if(d===a.Backwards){this.iHistoryPosition--;}};
b.prototype._hashSet=function(e){this._hashChangedByApp(e.getParameter("sHash"),false);};
b.prototype._hashReplaced=function(e){this._hashChangedByApp(e.getParameter("sHash"),true);};
b.prototype._hashChangedByApp=function(n,w){this._oNextHash={sHash:n,bWasReplaced:w};};
var i=new b(H.getInstance());
b.getInstance=function(){return i;};
return b;},true);
sap.ui.predefine('sap/ui/core/routing/Route',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/core/routing/Target','sap/ui/core/routing/async/Route','sap/ui/core/routing/sync/Route','sap/ui/core/Component'],function($,E,T,a,s,C){"use strict";
var R=E.extend("sap.ui.core.routing.Route",{
metadata:{publicMethods:["getURL","getPattern"]},
constructor:function(r,c,p){E.apply(this,arguments);if(!c.name){$.sap.log.error("A name has to be specified for every route",this);}this._aPattern=[];this._aRoutes=[];this._oParent=p;this._oConfig=c;this._oRouter=r;var t=this,v=c.pattern,S,b,d=r._isAsync();b=d?a:s;for(var f in b){this[f]=b[f];}if(!$.isArray(v)){v=[v];}if(c.parent){var o=this._getParentRoute(c.parent);if(!o){$.sap.log.error("No parent route with '"+c.parent+"' could be found",this);}else if(o._aPattern.length>1){$.sap.log.error("Routes with multiple patterns cannot be used as parent for nested routes",this);return;}else{this._oNestingParent=o;v.forEach(function(e,i){var n=o._aPattern[0];n=n.charAt(n.length)==="/"?n:n+"/";v[i]=n+e;});}}if($.isArray(c.subroutes)){S=c.subroutes;c.subroutes={};$.each(S,function(i,e){c.subroutes[e.name]=e;});}if(!c.target){c._async=d;this._oTarget=new T(c,r._oViews,p&&p._oTarget);this._oTarget._bUseRawViewId=true;}if(c.subroutes){$.each(c.subroutes,function(e,g){if(g.name===undefined){g.name=e;}r.addRoute(g,t);});}if(c.pattern===undefined){return;}$.each(v,function(i,e){t._aPattern[i]=e;t._aRoutes[i]=r._oRouter.addRoute(e);t._aRoutes[i].greedy=c.greedy;t._aRoutes[i].matched.add(function(){var A={};$.each(arguments,function(g,h){A[t._aRoutes[i]._paramsIds[g]]=h;});t._routeMatched(A,true);});});},
destroy:function(){E.prototype.destroy.apply(this);this._aPattern=null;this._aRoutes=null;this._oParent=null;this._oConfig=null;this.bIsDestroyed=true;return this;},
getURL:function(p){return this._aRoutes[0].interpolate(p);},
getPattern:function(){return this._aPattern[0];},
attachMatched:function(d,f,l){return this.attachEvent("matched",d,f,l);},
detachMatched:function(f,l){return this.detachEvent("matched",f,l);},
attachBeforeMatched:function(d,f,l){return this.attachEvent("beforeMatched",d,f,l);},
detachBeforeMatched:function(f,l){return this.detachEvent("beforeMatched",f,l);},
fireBeforeMatched:function(A){this.fireEvent("beforeMatched",A);return this;},
attachPatternMatched:function(d,f,l){return this.attachEvent("patternMatched",d,f,l);},
detachPatternMatched:function(f,l){return this.detachEvent("patternMatched",f,l);},
_convertToTargetOptions:function(o){return $.extend(true,{},o,{rootView:o.targetParent,controlId:o.targetControl,controlAggregation:o.targetAggregation,clearControlAggregation:o.clearTarget,viewName:o.view,viewType:o.viewType,viewId:o.viewId});},
_getParentRoute:function(p){var P=p.split(":");if(P.length===1||(P.length===2&&!P[0])){return this._oRouter.getRoute(P[P.length-1]);}else{var o=C.getOwnerComponentFor(this._oRouter._oOwner);while(o){if(o.getMetadata().getName()===P[0]){var r=o.getRouter();return r.getRoute(P[1]);}o=C.getOwnerComponentFor(o);}return null;}}
});
R.M_EVENTS={BeforeMatched:"beforeMatched",Matched:"matched",PatternMatched:"patternMatched"};return R;});
sap.ui.predefine('sap/ui/core/routing/Router',['jquery.sap.global','sap/ui/core/library','sap/ui/base/EventProvider','./HashChanger','./Route','./Views','./Targets','./History','sap/ui/thirdparty/crossroads'],function(q,l,E,H,R,V,T,a,c){"use strict";var r={};
var b=E.extend("sap.ui.core.routing.Router",{
constructor:function(o,C,O,t){E.apply(this);this._oConfig=C||{};this._oRouter=c.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=O;function e(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true;}return false;}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=e();}this._oViews=new V({component:O,async:this._oConfig._async});if(t){this._oTargets=this._createTargets(this._oConfig,t);}var f=this,h;if(!o){o={};}if(Array.isArray(o)){h=o;o={};h.forEach(function(i){o[i.name]=i;});}q.each(o,function(s,i){if(i.name===undefined){i.name=s;}f.addRoute(i);});this._oRouter.bypassed.add(q.proxy(this._onBypassed,this));},
addRoute:function(C,p){if(!C.name){q.sap.log.error("A name has to be specified for every route",this);}if(this._oRoutes[C.name]){q.sap.log.error("Route with name "+C.name+" already exists",this);}this._oRoutes[C.name]=this._createRoute(this,C,p);},
parse:function(n){if(this._oRouter){this._oRouter.parse(n);}else{q.sap.log.warning("This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this);}},
initialize:function(i){var t=this,h=this.oHashChanger=H.getInstance();if(this._bIsInitialized){q.sap.log.warning("Router is already initialized.",this);return this;}this._bIsInitialized=true;this._bLastHashReplaced=false;this._bHashChangedAfterTitleChange=false;this.fnHashChanged=function(f){t.parse(f.getParameter("newHash"));t._bHashChangedAfterTitleChange=true;};if(!h){q.sap.log.error("navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return;}if(this._oTargets){var o=this._oRoutes[this._oConfig.homeRoute];this._oTargets.attachTitleChanged(function(f){var j=f.getParameters();if(o&&d(j.name,o._oConfig.name)){j.isHome=true;}this.fireTitleChanged(j);},this);this.fnHashReplaced=function(){this._bLastHashReplaced=true;};this.oHashChanger.attachEvent("hashReplaced",this.fnHashReplaced,this);this._aHistory=[];var e=o&&g(this._oOwner,o);if(e){this._aHistory.push(e);}}h.init();h.attachEvent("hashChanged",this.fnHashChanged);if(!i){this.parse(h.getHash());}return this;},
stop:function(){if(!this._bIsInitialized){q.sap.log.warning("Router is not initialized. But it got stopped",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._bIsInitialized=false;return this;},
destroy:function(){E.prototype.destroy.apply(this);if(!this._bIsInitialized){q.sap.log.info("Router is not initialized, but got destroyed.",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._oRouter.removeAllRoutes();this._oRouter=null;q.each(this._oRoutes,function(i,o){o.destroy();});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}this.bIsDestroyed=true;return this;},
getURL:function(n,p){if(p===undefined){p={};}var o=this.getRoute(n);if(!o){q.sap.log.warning("Route with name "+n+" does not exist",this);return;}return o.getURL(p);},
getRoute:function(n){return this._oRoutes[n];},
getViews:function(){return this._oViews;},
_createTargets:function(C,t){return new T({views:this._oViews,config:C,targets:t});},
_createRoute:function(o,C,p){return new R(o,C,p);},
getView:function(v,s,e){var o=this._oViews._getViewWithGlobalId({viewName:v,type:s,id:e});this.fireViewCreated({view:o,viewName:v,type:s});return o;},
setView:function(v,o){this._oViews.setView(v,o);return this;},
navTo:function(n,p,e){var u=this.getURL(n,p);if(u===undefined){q.sap.log.error("Can not navigate to route with name "+n+" because the route does not exist");}if(e){this.oHashChanger.replaceHash(u);}else{this.oHashChanger.setHash(u);}return this;},
getTargets:function(){return this._oTargets;},
getTarget:function(n){return this._oTargets.getTarget(n);},
attachRouteMatched:function(D,f,L){this.attachEvent("routeMatched",D,f,L);return this;},
detachRouteMatched:function(f,L){this.detachEvent("routeMatched",f,L);return this;},
fireRouteMatched:function(A){this.fireEvent("routeMatched",A);return this;},
attachBeforeRouteMatched:function(D,f,L){this.attachEvent("beforeRouteMatched",D,f,L);return this;},
detachBeforeRouteMatched:function(f,L){this.detachEvent("beforeRouteMatched",f,L);return this;},
fireBeforeRouteMatched:function(A){this.fireEvent("beforeRouteMatched",A);return this;},
attachViewCreated:function(D,f,L){this.attachEvent("viewCreated",D,f,L);return this;},
detachViewCreated:function(f,L){this.detachEvent("viewCreated",f,L);return this;},
fireViewCreated:function(A){this.fireEvent("viewCreated",A);return this;},
attachRoutePatternMatched:function(D,f,L){this.attachEvent("routePatternMatched",D,f,L);return this;},
detachRoutePatternMatched:function(f,L){this.detachEvent("routePatternMatched",f,L);return this;},
fireRoutePatternMatched:function(A){this.fireEvent("routePatternMatched",A);return this;},
attachBypassed:function(D,f,L){return this.attachEvent(b.M_EVENTS.BYPASSED,D,f,L);},
detachBypassed:function(f,L){return this.detachEvent(b.M_EVENTS.BYPASSED,f,L);},
fireBypassed:function(A){return this.fireEvent(b.M_EVENTS.BYPASSED,A);},
attachTitleChanged:function(D,f,L){this.attachEvent(b.M_EVENTS.TITLE_CHANGED,D,f,L);return this;},
detachTitleChanged:function(f,L){return this.detachEvent(b.M_EVENTS.TITLE_CHANGED,f,L);},
fireTitleChanged:function(A){var D=a.getInstance().getDirection(),h=this.oHashChanger.getHash(),e=l.routing.HistoryDirection,L=this._aHistory[this._aHistory.length-1],n;if(D===e.Backwards&&L&&!L.isHome){if(L&&L.title!==A.title){this._aHistory.pop();}}else if(L&&L.hash==h){L.title=A.title;this._aHistory.some(function(o,i,f){if(i<f.length-1&&q.sap.equal(o,L)){return f.splice(i,1);}});}else{if(this._bLastHashReplaced){this._aHistory.pop();}n={hash:h,title:A.title};this._aHistory.some(function(o,i,f){if(q.sap.equal(o,n)){return f.splice(i,1);}});this._aHistory.push(n);}A.history=this._aHistory.slice(0,-1);this.fireEvent(b.M_EVENTS.TITLE_CHANGED,A);this._bLastHashReplaced=false;return this;},
getTitleHistory:function(){return this._aHistory||[];},
register:function(n){r[n]=this;return this;},
_onBypassed:function(h){var f=function(){this.fireBypassed({hash:h});}.bind(this);if(this._oConfig.bypassed){var o=this._oTargets.display(this._oConfig.bypassed.target,{hash:h});if(o instanceof Promise){o.then(f);return;}}f();},
_isAsync:function(){return this._oConfig._async;},
metadata:{publicMethods:["initialize","getURL","register","getRoute"]}
});
function d(s,h){return h&&h.indexOf(s)>-1;}
function g(o,h){var s=h.getPattern(),A=o&&o.getManifestEntry("sap.app/title");if(s===""||(s!==undefined&&!/({.*})+/.test(s))){return{hash:s,isHome:true,title:A};}else{q.sap.log.error("Routes with dynamic parts cannot be resolved as home route.");}}
b.M_EVENTS={BEFORE_ROUTE_MATCHED:"beforeRouteMatched",ROUTE_MATCHED:"routeMatched",ROUTE_PATTERN_MATCHED:"routePatternMatched",VIEW_CREATED:"viewCreated",BYPASSED:"bypassed",TITLE_CHANGED:"titleChanged"};
b.getRouter=function(n){return r[n];};
return b;});
sap.ui.predefine('sap/ui/core/routing/Target',['jquery.sap.global','sap/ui/core/Control','sap/ui/base/EventProvider','sap/ui/core/mvc/View','sap/ui/core/routing/async/Target','sap/ui/core/routing/sync/Target'],function(q,C,E,V,a,s){"use strict";
var T=E.extend("sap.ui.core.routing.Target",{
constructor:function(o,v){function c(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Target");return true;}return false;}if(o._async===undefined){o._async=c();}this._oOptions=o;this._oViews=v;E.apply(this,arguments);if(this._oOptions.title){this._oTitleProvider=new b({target:this});}var d=this._oOptions._async?a:s;for(var f in d){this[f]=d[f];}this._bIsDisplayed=false;},
destroy:function(){this._oParent=null;this._oOptions=null;this._oViews=null;if(this._oTitleProvider){this._oTitleProvider.destroy();}this._oTitleProvider=null;E.prototype.destroy.apply(this,arguments);this.bIsDestroyed=true;return this;},
attachDisplay:function(d,f,l){return this.attachEvent(this.M_EVENTS.DISPLAY,d,f,l);},
detachDisplay:function(f,l){return this.detachEvent(this.M_EVENTS.DISPLAY,f,l);},
fireDisplay:function(A){var t=this._oTitleProvider&&this._oTitleProvider.getTitle();if(t){this.fireTitleChanged({name:this._oOptions.name,title:t});}this._bIsDisplayed=true;return this.fireEvent(this.M_EVENTS.DISPLAY,A);},
attachTitleChanged:function(d,f,l){var h=this.hasListeners("titleChanged"),t=this._oTitleProvider&&this._oTitleProvider.getTitle();this.attachEvent(this.M_EVENTS.TITLE_CHANGED,d,f,l);if(!h&&t&&this._bIsDisplayed){this.fireTitleChanged({name:this._oOptions.name,title:t});}return this;},
detachTitleChanged:function(f,l){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,f,l);},
fireTitleChanged:function(A){return this.fireEvent(this.M_EVENTS.TITLE_CHANGED,A);},
_getEffectiveViewName:function(v){var c=this._oOptions.viewPath;if(c){v=c+"."+v;}return v;},
_bindTitleInTitleProvider:function(v){if(this._oTitleProvider&&v instanceof V){this._oTitleProvider.applySettings({title:this._oOptions.title},v.getController());}},
_addTitleProviderAsDependent:function(v){if(!this._oTitleProvider){return;}var o=this._oTitleProvider.getParent();if(o){o.removeDependent(this._oTitleProvider);}v.addDependent(this._oTitleProvider);},
_beforePlacingViewIntoContainer:function(A){},
M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"}
});
var b=C.extend("sap.ui.core.routing.Target.TitleProvider",{
metadata:{library:"sap.ui.core",properties:{title:{type:"string",group:"Data",defaultValue:null}}},
constructor:function(S){this._oTarget=S.target;delete S.target;C.prototype.constructor.call(this,S);},
setTitle:function(t){this.setProperty("title",t,true);if(this._oTarget._bIsDisplayed){this._oTarget.fireTitleChanged({name:this._oTarget._oOptions.name,title:t});}}
});
return T;});
sap.ui.predefine('sap/ui/core/routing/Targets',['jquery.sap.global','sap/ui/base/EventProvider','./Target','./async/Targets','./sync/Targets'],function(q,E,T,a,s){"use strict";
var b=E.extend("sap.ui.core.routing.Targets",{
constructor:function(o){var t,c;E.apply(this);this._mTargets={};this._oConfig=o.config;this._oViews=o.views;if(!this._oConfig){this._oConfig={_async:false};}function d(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Targets");return true;}return false;}if(this._oConfig._async===undefined){this._oConfig._async=(this._oConfig.async===undefined)?d():this._oConfig.async;}var e=this._oConfig._async?a:s;for(var f in e){this[f]=e[f];}for(t in o.targets){if(o.targets.hasOwnProperty(t)){this._createTarget(t,o.targets[t]);}}for(c in this._mTargets){if(this._mTargets.hasOwnProperty(c)){this._addParentTo(this._mTargets[c]);}}},
destroy:function(){var t;E.prototype.destroy.apply(this);for(t in this._mTargets){if(this._mTargets.hasOwnProperty(t)){this._mTargets[t].destroy();}}this._mTargets=null;this._oViews=null;this._oConfig=null;this.bIsDestroyed=true;return this;},
getViews:function(){return this._oViews;},
getTarget:function(n){var t=this,r=[];if(Array.isArray(n)){n.forEach(function(N){var o=t._mTargets[N];if(o){r.push(o);}else{q.sap.log.error("The target you tried to get \""+N+"\" does not exist!",t);}});return r;}return this._mTargets[n];},
addTarget:function(n,t){var o=this.getTarget(n),c;if(o){q.sap.log.error("Target with name "+n+" already exists",this);}else{c=this._createTarget(n,t);this._addParentTo(c);}return this;},
attachDisplay:function(d,f,l){return this.attachEvent(this.M_EVENTS.DISPLAY,d,f,l);},
detachDisplay:function(f,l){return this.detachEvent(this.M_EVENTS.DISPLAY,f,l);},
fireDisplay:function(A){return this.fireEvent(this.M_EVENTS.DISPLAY,A);},
attachTitleChanged:function(d,f,l){this.attachEvent(this.M_EVENTS.TITLE_CHANGED,d,f,l);return this;},
detachTitleChanged:function(f,l){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,f,l);},
fireTitleChanged:function(A){return this.fireEvent(this.M_EVENTS.TITLE_CHANGED,A);},
M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"},
_createTarget:function(n,t){var o,O;O=q.extend(true,{name:n},this._oConfig,t);o=this._constructTarget(O);o.attachDisplay(function(e){var p=e.getParameters();this.fireDisplay({name:n,view:p.view,control:p.control,config:p.config,data:p.data});},this);this._mTargets[n]=o;return o;},
_addParentTo:function(t){var p,P=t._oOptions.parent;if(!P){return;}p=this._mTargets[P];if(!p){q.sap.log.error("The target '"+t._oOptions.name+" has a parent '"+P+"' defined, but it was not found in the other targets",this);return;}t._oParent=p;},
_constructTarget:function(o,p){return new T(o,this._oViews,p);},
_setRootViewId:function(i){var t,o;for(t in this._mTargets){if(this._mTargets.hasOwnProperty(t)){o=this._mTargets[t]._oOptions;if(o.rootView===undefined){o.rootView=i;}}}},
_getTitleTargetName:function(t,p){var o,c;c=p||(typeof t==="string"&&t);if(!c){t.some(function(d){o=this.getTarget(d);while(o&&o._oParent&&o._oParent._oOptions.title){o=o._oParent;}if(o&&o._oOptions.title){c=o._oOptions.name;return true;}}.bind(this));}return c;},
_forwardTitleChanged:function(e){this.fireTitleChanged({name:e.getParameter("name"),title:e.getParameter("title")});},
_attachTitleChanged:function(t,c){var o;c=this._getTitleTargetName(t,c);o=this.getTarget(c);if(this._oLastTitleTarget){this._oLastTitleTarget.detachTitleChanged(this._forwardTitleChanged,this);this._oLastTitleTarget._bIsDisplayed=false;}if(o){o.attachTitleChanged({name:o._oOptions.name},this._forwardTitleChanged,this);this._oLastTitleTarget=o;}else if(c){q.sap.log.error("The target with the name \""+c+"\" where the titleChanged event should be fired does not exist!",this);}}
});
return b;});
sap.ui.predefine('sap/ui/core/routing/Views',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/core/UIComponent','sap/ui/core/routing/async/Views','sap/ui/core/routing/sync/Views'],function(q,E,U,a,s){"use strict";
var V=E.extend("sap.ui.core.routing.Views",{
constructor:function(o){if(!o){o={};}this._oViews={};this._oComponent=o.component;if(this._oComponent){}E.apply(this,arguments);function c(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Views");return true;}return false;}var b=(o.async===undefined)?c():o.async;var d=b?a:s;for(var f in d){this[f]=d[f];}},
metadata:{publicMethods:["getView","setView"]},
getView:function(o){return this._getView(o).loaded();},
setView:function(v,o){this._checkViewName(v);this._oViews[v]=o;return this;},
destroy:function(){var p;E.prototype.destroy.apply(this);for(p in this._oViews){if(this._oViews.hasOwnProperty(p)&&this._oViews[p]){this._oViews[p].destroy();}}this._oViews=undefined;this.bIsDestroyed=true;return this;},
attachCreated:function(d,f,l){return this.attachEvent("created",d,f,l);},
detachCreated:function(f,l){return this.detachEvent("created",f,l);},
fireCreated:function(A){return this.fireEvent("created",A);},
_getView:function(o){if(this._oComponent&&o.id){o=q.extend({},o,{id:this._oComponent.createId(o.id)});}return this._getViewWithGlobalId(o);},
_checkViewName:function(v){if(!v){q.sap.log.error("A name for the view has to be defined",this);}}
});
return V;});
sap.ui.predefine('sap/ui/core/routing/async/Route',['jquery.sap.global','sap/ui/Device'],function(q,D){"use strict";return{_routeMatched:function(a,s,n){var r=this._oRouter,t,c,e,v=null,T=null,i,o,C,b=this;if(!s||s===true){i=true;s=Promise.resolve();}if(this._oParent){s=this._oParent._routeMatched(a,s);}else if(this._oNestingParent){this._oNestingParent._routeMatched(a,s,this);}c=q.extend({},r._oConfig,this._oConfig);o=q.extend({},a);o.routeConfig=c;e={name:c.name,arguments:a,config:c};if(n){e.nestedRoute=n;}this.fireBeforeMatched(e);r.fireBeforeRouteMatched(e);if(this._oTarget){t=this._oTarget;t._oOptions=this._convertToTargetOptions(c);s=t._place(s);if(this._oRouter._oTargetHandler&&this._oRouter._oTargetHandler._chainNavigation){C=s;s=this._oRouter._oTargetHandler._chainNavigation(function(){return C;});}}else if(D.browser.msie||D.browser.edge){C=s;s=new Promise(function(d,f){setTimeout(function(){var g=r._oTargets._display(b._oConfig.target,o,b._oConfig.titleTarget,C);g.then(d,f);},0);});}else{s=r._oTargets._display(this._oConfig.target,o,this._oConfig.titleTarget,s);}return s.then(function(R){R=R||{};v=R.view;T=R.control;e.view=v;e.targetControl=T;if(c.callback){c.callback(this,a,c,T,v);}this.fireEvent("matched",e);r.fireRouteMatched(e);if(i){q.sap.log.info("The route named '"+c.name+"' did match with its pattern",this);this.fireEvent("patternMatched",e);r.fireRoutePatternMatched(e);}return R;}.bind(this));}};});
sap.ui.predefine('sap/ui/core/routing/async/Target',['jquery.sap.global'],function(q){"use strict";return{display:function(d){var s=Promise.resolve();return this._display(d,s).catch(function(v){if(v instanceof Error){return Promise.reject(v);}else{return v;}});},_display:function(d,s){if(this._oParent){s=this._oParent._display(d,s);}return this._place(d,s);},_place:function(d,s){if(d instanceof Promise){s=d;d=undefined;}var o=this._oOptions,t=this,v,V,a,e;if(o.viewName){V=this._getEffectiveViewName(o.viewName);a={viewName:V,type:o.viewType,id:o.viewId,async:o.async};if(this._bUseRawViewId){v=this._oViews._getViewWithGlobalId(a);}else{v=this._oViews._getView(a);}s=s.then(function(p){return v.loaded().then(function(v){t._bindTitleInTitleProvider(v);t._addTitleProviderAsDependent(v);return{view:v,parentInfo:p||{}};},function(e){return Promise.reject({name:o.name,error:e});});}).then(function(b){var c=t._isValid(b.parentInfo);if(c!==true){e=c;return t._refuseInvalidTarget(o.name,e);}var f=b.parentInfo.view,C=b.parentInfo.control,p=Promise.resolve(C);v=b.view;if(!f&&o.rootView){f=sap.ui.getCore().byId(o.rootView);if(!f){e="Did not find the root view with the id "+o.rootView;return t._refuseInvalidTarget(o.name,e);}}if(o.controlId){if(f){p=f.loaded().then(function(g){return g.byId(o.controlId);});}p=p.then(function(g){if(!g){g=sap.ui.getCore().byId(o.controlId);}if(!g){e="Control with ID "+o.controlId+" could not be found";return t._refuseInvalidTarget(o.name,e);}else{return g;}}).catch(function(){e="Something went wrong during loading the root view with id "+o.rootView;return t._refuseInvalidTarget(o.name,e);});}return p.then(function(g){if(g.error){return g;}t._beforePlacingViewIntoContainer({container:g,view:v,data:d});var A=g.getMetadata().getJSONKeys()[o.controlAggregation];if(!A){e="Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation;return t._refuseInvalidTarget(o.name,e);}if(o.clearControlAggregation===true){g[A._sRemoveAllMutator]();}q.sap.log.info("Did place the view '"+V+"' with the id '"+v.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+g.getId()+"'",t);g[A._sMutator](v);t.fireDisplay({view:v,control:g,config:t._oOptions,data:d});return{name:o.name,view:v,control:g};});});}else{s=s.then(function(){return{name:o.name};});}return s;},_isValid:function(p){var o=this._oOptions,c=p&&p.control,h=(c||o.controlId),i=true,l="";if(!h){l="The target "+o.name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){l="The target "+o.name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(l){q.sap.log.error(l,this);}return i||l;},_refuseInvalidTarget:function(n,m){if(m){q.sap.log.error(m,this);}return{name:n,error:m};}};});
sap.ui.predefine('sap/ui/core/routing/async/Targets',['jquery.sap.global'],function(q){"use strict";return{display:function(t,d,T){var s=Promise.resolve();return this._display(t,d,T,s);},_display:function(t,d,T,s){var a=this,v=[];if(!Array.isArray(t)){t=[t];}this._attachTitleChanged(t,T);return t.reduce(function(p,b){return a._displaySingleTarget(b,d,p).then(function(V){v.push(V);});},s).then(function(){return v;});},_displaySingleTarget:function(n,d,s){var t=this.getTarget(n);if(t!==undefined){return t._display(d,s);}else{var e="The target with the name \""+n+"\" does not exist!";q.sap.log.error(e,this);return Promise.resolve({name:n,error:e});}}};});
sap.ui.predefine('sap/ui/core/routing/async/Views',['jquery.sap.global'],function(q){"use strict";return{_getViewWithGlobalId:function(o){function c(){return sap.ui.view(o);}var v,V;if(!o){q.sap.log.error("the oOptions parameter of getView is mandatory",this);}else{if(o.async===undefined){o.async=true;}V=o.viewName;this._checkViewName(V);v=this._oViews[V];}if(v){return v;}if(this._oComponent){v=this._oComponent.runAsOwner(c);}else{v=c();}this._oViews[V]=v;v.loaded().then(function(v){this.fireCreated({view:v,viewOptions:o});}.bind(this));return v;}};});
sap.ui.predefine('sap/ui/core/routing/sync/Route',['jquery.sap.global'],function(q){"use strict";return{_routeMatched:function(a,i,n){var r=this._oRouter,p,P,t,c,e,v=null,T=null,o;if(this._oParent){p=this._oParent._routeMatched(a);}else if(this._oNestingParent){this._oNestingParent._routeMatched(a,false,this);}c=q.extend({},r._oConfig,this._oConfig);o=q.extend({},a);o.routeConfig=c;e={name:c.name,arguments:a,config:c};if(n){e.nestedRoute=n;}this.fireBeforeMatched(e);r.fireBeforeRouteMatched(e);if(this._oTarget){t=this._oTarget;t._oOptions=this._convertToTargetOptions(c);if(t._isValid(p,false)){P=t._place(p);}P=P||{};v=P.oTargetParent;T=P.oTargetControl;e.view=v;e.targetControl=T;}else{r._oTargets._display(this._oConfig.target,o,this._oConfig.titleTarget);}if(c.callback){c.callback(this,a,c,T,v);}this.fireEvent("matched",e);r.fireRouteMatched(e);if(i){q.sap.log.info("The route named '"+c.name+"' did match with its pattern",this);this.fireEvent("patternMatched",e);r.fireRoutePatternMatched(e);}return P;}};});
sap.ui.predefine('sap/ui/core/routing/sync/Target',['jquery.sap.global'],function(q){"use strict";return{display:function(d){var p;if(this._oParent){p=this._oParent.display(d);}return this._place(p,d);},_place:function(p,d){var o=this._oOptions;p=p||{};var v,c=p.oTargetControl,V=p.oTargetParent;if(!this._isValid(p,true)){return;}if(!V&&o.rootView){V=sap.ui.getCore().byId(o.rootView);if(!V){q.sap.log.error("Did not find the root view with the id "+o.rootView,this);return;}}if(o.controlId){if(V){c=V.byId(o.controlId);}if(!c){c=sap.ui.getCore().byId(o.controlId);}if(!c){q.sap.log.error("Control with ID "+o.controlId+" could not be found",this);return;}}var a=c.getMetadata().getJSONKeys()[o.controlAggregation];if(!a){q.sap.log.error("Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation,this);return;}var s=this._getEffectiveViewName(o.viewName);var b={viewName:s,type:o.viewType,id:o.viewId};if(this._bUseRawViewId){v=this._oViews._getViewWithGlobalId(b);}else{v=this._oViews._getView(b);}this._beforePlacingViewIntoContainer({container:c,view:v,data:d});this._bindTitleInTitleProvider(v);this._addTitleProviderAsDependent(v);if(o.clearControlAggregation===true){c[a._sRemoveAllMutator]();}q.sap.log.info("Did place the view '"+s+"' with the id '"+v.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+c.getId()+"'",this);c[a._sMutator](v);this.fireDisplay({view:v,control:c,config:this._oOptions,data:d});return{oTargetParent:v,oTargetControl:c};},_isValid:function(p,l){var o=this._oOptions,c=p&&p.oTargetControl,h=(c||o.controlId),i=true,L="";if(!h){L="The target "+o.name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){L="The target "+o.name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(!o.viewName){L="The target "+o.name+" no viewName defined.";i=false;}if(l&&L){q.sap.log.error(L,this);}return i;}};});
sap.ui.predefine('sap/ui/core/routing/sync/Targets',['jquery.sap.global'],function(q){"use strict";return{display:function(t,d,T){this._display(t,d,T);},_display:function(t,d,T){var a=this;this._attachTitleChanged(t,T);if(Array.isArray(t)){t.forEach(function(s){a._displaySingleTarget(s,d);});}else{this._displaySingleTarget(t,d);}return this;},_displaySingleTarget:function(n,d){var t=this.getTarget(n);if(t!==undefined){t.display(d);}else{q.sap.log.error("The target with the name \""+n+"\" does not exist!",this);}}};});
sap.ui.predefine('sap/ui/core/routing/sync/Views',['jquery.sap.global'],function(q){"use strict";return{_getViewWithGlobalId:function(o){function c(){return sap.ui.view(o);}if(!o){q.sap.log.error("the oOptions parameter of getView is mandatory",this);}var v,V=o.viewName;this._checkViewName(V);v=this._oViews[V];if(v){return v;}if(this._oComponent){v=this._oComponent.runAsOwner(c);}else{v=c();}this._oViews[V]=v;this.fireCreated({view:v,viewOptions:o});return v;}};});
sap.ui.predefine('sap/ui/core/search/OpenSearchProvider',['jquery.sap.global','sap/ui/core/library','./SearchProvider','jquery.sap.encoder'],function(q,l,S){"use strict";
var O=S.extend("sap.ui.core.search.OpenSearchProvider",{metadata:{library:"sap.ui.core",properties:{suggestUrl:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},suggestType:{type:"string",group:"Misc",defaultValue:'json'}}}});
O.prototype.suggest=function(v,c){var u=this.getSuggestUrl();if(!u){return;}u=u.replace("{searchTerms}",q.sap.encodeURL(v));var t=this.getSuggestType();var s;if(t&&t.toLowerCase()==="xml"){t="xml";s=function(d){var x=q(d);var i=x.find("Text");var a=[];i.each(function(){a.push(q(this).text());});c(v,a);};}else{t="json";s=function(d){c(v,d[1]);};}q.ajax({url:u,dataType:t,success:s,error:function(X,a,e){q.sap.log.fatal("The following problem occurred: "+a,X.responseText+","+X.status);}});};
return O;});
sap.ui.predefine('sap/ui/core/search/SearchProvider',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/library'],function(q,E,l){"use strict";
var S=E.extend("sap.ui.core.search.SearchProvider",{metadata:{library:"sap.ui.core",properties:{icon:{type:"string",group:"Misc",defaultValue:null}}}});
S.prototype.suggest=function(v,c){q.sap.log.warning("sap.ui.core.search.SearchProvider is the abstract base class for all SearchProviders. Do not create instances of this class, but use a concrete sub class instead.");};
return S;});
sap.ui.predefine('sap/ui/core/service/Service',['jquery.sap.global','sap/ui/base/Object'],function(q,B){"use strict";
var S=B.extend("sap.ui.core.service.Service",{
metadata:{"abstract":true,"library":"sap.ui.core"},
constructor:function(s){B.apply(this);if(s){}this._oServiceContext=s;if(typeof this.init==="function"){this.init();}}
});
S.create=function(s){var A=function A(o){for(var m in s){if(!m.match(/^(metadata|constructor|getContext|destroy)$/)){this[m]=s[m];}else{q.sap.log.warning("The member "+m+" is not allowed for anonymous service declaration and will be ignored!");}}S.apply(this,arguments);};A.prototype=Object.create(S.prototype);return A;};
S.prototype.getInterface=function(){var p=Object.create(null);for(var m in this){if(!m.match(/^_|^metadata$|^constructor$|^getInterface$|^destroy$|^init$|^exit$|^getContext$/)&&typeof this[m]==="function"){p[m]=this[m].bind(this);}}this.getInterface=function(){return p;};return p;};
S.prototype.getContext=function(){return this._oServiceContext;};
S.prototype.destroy=function(){if(typeof this.exit==="function"){this.exit();}B.prototype.destroy.apply(this,arguments);delete this._oServiceContext;};
return S;});
sap.ui.predefine('sap/ui/core/service/ServiceFactory',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/service/Service'],function(q,B,S){"use strict";
var a=B.extend("sap.ui.core.service.ServiceFactory",{
metadata:{"library":"sap.ui.core"},
constructor:function(s){B.apply(this);var f=typeof s==="object"?S.create(s):s;this._fnService=f;}
});
a.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);delete this._fnService;};
a.prototype.createInstance=function(s){if(typeof this._fnService==="function"){return Promise.resolve(new this._fnService(s));}else{return Promise.reject(new Error("Usage of sap.ui.core.service.ServiceFactory requires a service constructor function to create a new service instance or to override the createInstance function!"));}};
return a;});
sap.ui.predefine('sap/ui/core/service/ServiceFactoryRegistry',['jquery.sap.global','./ServiceFactory'],function(q,S){"use strict";var s=Object.create(null);var a=Object.create(null);
a.register=function(b,o){s[b]=o;return this;};
a.unregister=function(b){delete s[b];return this;};
a.get=function(b){return s[b];};
return a;},true);
sap.ui.predefine('sap/ui/core/theming/Parameters',['jquery.sap.global','sap/ui/thirdparty/URI','../Element','jquery.sap.sjax','jquery.sap.script'],function(q,U,E){"use strict";var c=window["sap-ui-config"]||{};var s=0;if(c['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(window.location.search)){s=1;}if(c['xx-nosync']===true||c['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(window.location.search)){s=2;}var P={};var p=null;var t=null;var a=[];var r=/url[\s]*\('?"?([^\'")]*)'?"?\)/;var u=q.sap.getUriParameters().get("sap-ui-xx-no-inline-theming-parameters")!=="true";
function b(){p=null;}
function d(i,T){var M=r.exec(i);if(M){var j=new U(M[1]);if(j.is("relative")){var N=j.absoluteTo(T).normalize().path();i="url('"+N+"')";}}return i;}
function m(C,N,T){for(var i in N){if(typeof C[i]==="undefined"){C[i]=d(N[i],T);}}return C;}
function e(N,T){if(typeof N["default"]!=="object"){N={"default":N,"scopes":{}};}p=p||{};p["default"]=p["default"]||{};p["scopes"]=p["scopes"]||{};m(p["default"],N["default"],T);if(typeof N["scopes"]==="object"){for(var S in N["scopes"]){p["scopes"][S]=p["scopes"][S]||{};m(p["scopes"][S],N["scopes"][S],T);}}}
function f(C){q("link[id^=sap-ui-theme-]").each(function(){C(this.getAttribute("id"));});}
function l(i){var L=document.getElementById(i);if(!L){q.sap.log.warning("Could not find stylesheet element with ID",i,"sap.ui.core.theming.Parameters");return;}var S=L.href;var T=new U(S).filename("").query("").toString();var k=sap.ui.getCore().isThemeApplied();if(!k){q.sap.log.warning("Parameters have been requested but theme is not applied, yet.","sap.ui.core.theming.Parameters");}if(k&&u){var $=q(L);var D=$.css("background-image");var v=/\(["']?data:text\/plain;utf-8,(.*?)['"]?\)$/i.exec(D);if(v&&v.length>=2){var w=v[1];if(w.charAt(0)!=="{"&&w.charAt(w.length-1)!=="}"){try{w=decodeURIComponent(w);}catch(x){q.sap.log.warning("Could not decode theme parameters URI from "+S);}}try{var y=q.parseJSON(w);e(y,T);return;}catch(x){q.sap.log.warning("Could not parse theme parameters from "+S+". Loading library-parameters.json as fallback solution.");}}}var R,z;var A=S.replace(/\/library([^\/.]*)\.(?:css|less)($|[?#])/,function(B,C,F){return"/library-parameters.json"+(F?F:"");});if(s===2){q.sap.log.error("[nosync] Loading library-parameters.json ignored",A,"sap.ui.core.theming.Parameters");return;}else if(s===1){q.sap.log.error("[nosync] Loading library-parameters.json with sync XHR",A,"sap.ui.core.theming.Parameters");}R=q.sap.sjax({url:A,dataType:'json'});if(R.success){z=R.data;if(Array.isArray(z)){for(var j=0;j<z.length;j++){var y=z[j];e(y,T);}}else{e(z,T);}}else{q.sap.log.error("Could not load theme parameters from: "+A,R.error);}}
function g(){if(!p){e({},"");t=sap.ui.getCore().getConfiguration().getTheme();f(l);}return p;}
function h(){a.forEach(l);a=[];}
P._addLibraryTheme=function(L){if(p){a.push("sap-ui-theme-"+L);}};
function n(O){var i=g();if(O.scopeName){i=i["scopes"][O.scopeName];}else{i=i["default"];}var j=i[O.parameterName];if(typeof j==="undefined"&&typeof O.parameterName==="string"){var I=O.parameterName.indexOf(":");if(I!==-1){O.parameterName=O.parameterName.substr(I+1);}j=i[O.parameterName];}if(O.loadPendingParameters&&typeof j==="undefined"){h();j=n({parameterName:O.parameterName,scopeName:O.scopeName,loadPendingParameters:false});}return j;}
function o(j,S){for(var i=0;i<S.length;i++){var C=S[i];for(var k=0;k<C.length;k++){var v=C[k];var w=n({parameterName:j,scopeName:v});if(w){return w;}}}return n({parameterName:j});}
P._getScopes=function(A){if(A&&!p){return;}var i=g();var S=Object.keys(i["scopes"]);return S;};
P.getActiveScopesFor=function(i){var S=[];if(i instanceof E){var j=i.getDomRef();h();var k=this._getScopes();if(j){var N=function(v){var w=j.classList;return w&&w.contains(v);};while(j){var F=k.filter(N);if(F.length>0){S.push(F);}j=j.parentNode;}}else{var C=function(v){return typeof i.hasStyleClass==="function"&&i.hasStyleClass(v);};while(i){var F=k.filter(C);if(F.length>0){S.push(F);}i=typeof i.getParent==="function"&&i.getParent();}}}return S;};
P.get=function(N,k){var v;if(!sap.ui.getCore().isInitialized()){q.sap.log.warning("Called sap.ui.core.theming.Parameters.get() before core has been initialized. "+"This could lead to bad performance and sync XHR as inline parameters might not be available, yet. "+"Consider using the API only when required, e.g. onBeforeRendering.");}if(arguments.length===0){h();var w=g();return q.extend({},w["default"]);}if(!N){return undefined;}if(k instanceof E){h();var S=this.getActiveScopesFor(k);if(typeof N==="string"){return o(N,S);}else if(Array.isArray(N)){var x={};for(var j=0;j<N.length;j++){var y=N[j];x[y]=o(y,S);}return x;}}else{if(typeof N==="string"){v=n({parameterName:N,loadPendingParameters:true});return v;}else if(Array.isArray(N)){var x={};for(var i=0;i<N.length;i++){var y=N[i];x[y]=P.get(y);}return x;}}};
P._setOrLoadParameters=function(L){p={"default":{},"scopes":{}};t=sap.ui.getCore().getConfiguration().getTheme();f(function(i){var j=i.substr(13);if(L[j]){q.extend(p["default"],L[j]);}else{l(i);}});};
P.reset=function(){var O=arguments[0]===true;if(!O||sap.ui.getCore().getConfiguration().getTheme()!==t){b();}};
P._getThemeImage=function(i,F){i=i||"sapUiGlobalLogo";var j=P.get(i);if(j){var k=r.exec(j);if(k){j=k[1];}else if(j==="''"||j==="none"){j=null;}}if(!!F&&!j){return sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif');}return j;};
return P;},true);
sap.ui.predefine('sap/ui/core/tmpl/DOMAttribute',['sap/ui/core/Element','sap/ui/core/library'],function(E,l){"use strict";
var D=E.extend("sap.ui.core.tmpl.DOMAttribute",{metadata:{library:"sap.ui.core",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
D.prototype.setValue=function(v){this.setProperty("value",v,true);var p=this.getParent(),$=p&&p.$();if($&&$.length>0){$.attr(this.getName(),this.getProperty("value"));}return this;};
return D;});
sap.ui.predefine('sap/ui/core/tmpl/DOMElement',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/library','./DOMAttribute',"./DOMElementRenderer"],function(q,C,l,D,a){"use strict";
var b=C.extend("sap.ui.core.tmpl.DOMElement",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},tag:{type:"string",group:"Behavior",defaultValue:'span'}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.core.tmpl.DOMAttribute",multiple:true,singularName:"attribute"},elements:{type:"sap.ui.core.tmpl.DOMElement",multiple:true,singularName:"element"}}}});
b.prototype.applySettings=function(s){var m=this.getMetadata(),j=m.getJSONKeys();if(s){if(!s["attributes"]){var A=s["attributes"]=[];q.each(s,function(k,v){if(k!=="id"&&!j[k]&&typeof v==="string"){A.push(new D({name:k,value:v}));delete s[k];}});}else{q.sap.log.warning("DOMElement#"+this.getId()+": custom attributes in settings will be ignored since attributes are provided!");}}C.prototype.applySettings.apply(this,arguments);};
b.prototype.exit=b.prototype.onBeforeRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().off("change");}};
b.prototype.onAfterRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().on("change",q.proxy(this.oninputchange,this));}};
b.prototype.oninputchange=function(e){var t=this.getTag().toLowerCase();if(t==="input"){var v=this.$().val();this.getAttributes().forEach(function(A){if(A.getName().toLowerCase()==="value"){A.setValue(v);}});}else if(t==="textarea"){var T=this.$().val();this.setText(T);}else if(t==="select"){var T="";this.$().find("select option:selected").each(function(){T+=q(this).text()+" ";});this.setText(T);}};
b.prototype.attr=function(k,v){var A=this.getAttributes(),o;A.forEach(function(V){var n=V.getName();if(n.toLowerCase()===k){o=V;return false;}});if(v===undefined){return o&&o.getValue();}else{if(o){if(v===null){this.removeAttribute(o);}else{o.setValue(v);}}else{if(v!==null){this.addAttribute(new D({name:k,value:v}));}}return this;}};
b.prototype.removeAttr=function(k){this.attr(k,null);return this;};
b.prototype.setText=function(t){this.setProperty("text",t,true);var $=this.$();if($.length>0){var T=this.getTag().toLowerCase();if(T==="textarea"){$.val(this.getProperty("text"));}else{$.text(this.getProperty("text"));}}};
return b;});
sap.ui.predefine('sap/ui/core/tmpl/DOMElementRenderer',['jquery.sap.global'],function(q){"use strict";var D={};
D.render=function(r,e){r.write("<");r.writeEscaped(e.getTag());r.writeControlData(e);e.getAttributes().forEach(function(a){var n=a.getName().toLowerCase();if(n==="class"){var c=a.getValue().split(" ");c.forEach(function(C){var C=C.trim();if(C){r.addClass(q.sap.encodeHTML(C));}});}else if(n==="style"){var s=a.getValue().split(";");s.forEach(function(S){var i=S.indexOf(":");if(i!=-1){var k=S.substring(0,i).trim();var v=S.substring(i+1).trim();r.addStyle(q.sap.encodeHTML(k),q.sap.encodeHTML(v));}});}else{r.writeAttributeEscaped(q.sap.encodeHTML(a.getName()),a.getValue());}});r.writeClasses();r.writeStyles();var E=e.getElements(),h=!!e.getText()||E.length>0;if(!h){r.write("/>");}else{r.write(">");if(e.getText()){r.writeEscaped(e.getText());}E.forEach(function(i,c){r.renderControl(c);});r.write("</");r.writeEscaped(e.getTag());r.write(">");}};
return D;},true);
sap.ui.predefine('sap/ui/core/tmpl/HandlebarsTemplate',['jquery.sap.global','sap/ui/core/Core','./Template','./TemplateControl','sap/ui/thirdparty/handlebars','sap/ui/base/ManagedObject'],function(q,C,T,a,H,M){"use strict";
var b=T.extend("sap.ui.core.tmpl.HandlebarsTemplate",{constructor:function(i,s){T.apply(this,arguments);}});
T.registerType("text/x-handlebars-template","sap.ui.core.tmpl.HandlebarsTemplate");
function d(h){for(var k in h){h[k]=h[k].replace("&gt;",">").replace("&lt;","<").replace("&quot;","\"").replace("&amp;","&");}}
function c(p,P){var r=/^((\w+)>)?(.*)/,e=r.exec(p),s=e[2],f=r.exec(P),g=f[2];var e=r.exec(p);if(P&&s==g){return P+e[3];}else{return p;}}
b.RENDER_HELPERS=(function(){var e=H.helpers["each"],w=H.helpers["with"],I=H.helpers["if"],u=H.helpers["unless"],r=sap.ui.getCore().createRenderManager();r.renderControl=function(o){this.writeControlData(o);this.writeClasses(o);this.writeStyles(o);};var h={"each":function(f,o){o=o||f;if(!o.hash.path){return e.apply(this,arguments);}else{d(o.hash);var R=o.data.renderManager,g=o.data.rootControl,p=o.data.path,P=o.data.parentControl,s=c(o.hash.path,p),i=g.bindList(s),j=[],k;if(o.data){k=H.createFrame(o.data);}if(i){for(var K in i){if(k){k.renderManager=R;k.rootControl=g;k.path=s+"/"+K+"/";k.parentControl=P;}j.push(o.fn({},{data:k}));}}if(!P){return new H.SafeString(j.join(""));}}},"with":function(f,o){o=o||f;if(!o.hash.path){return w.apply(this,arguments);}},"if":function(f,o){o=o||f;if(!o.hash.path){return I.apply(this,arguments);}else{d(o.hash);var R=o.data.rootControl,p=o.data.path,P=c(o.hash.path,p);if(P){var v=R.bindProp(P);if(v){return o.fn(this);}else{return o.inverse(this);}}}},"unless":function(f,o){o=o||f;if(!o.hash.path){return u.apply(this,arguments);}else{d(o.hash);var R=o.data.rootControl,p=o.data.path,P=c(o.hash.path,p);if(P){var v=R.bindProp(P);if(!v){return o.fn(this);}else{return o.inverse(this);}}}},"text":function(f,o){o=o||f;d(o.hash);var R=o.data.rootControl,p=o.data.path,P=c(o.hash.path,p);if(P){var v=R.bindProp(P);return v&&new H.SafeString(q.sap.encodeHTML(v));}else{throw new Error("The expression \"text\" requires the option \"path\"!");}},"element":function(f,o){o=o||f;d(o.hash);var R=o.data.renderManager,g=o.data.rootControl,E=g.createDOMElement(o.hash,o.data.path),p=o.data.parentElement;if(o.fn){o.fn({},{data:{renderManager:R,rootControl:g,parentElement:E}});}if(p){p.addElement(E);return;}return new H.SafeString(R.getHTML(E));},"control":function(f,o){o=o||f;d(o.hash);var R=o.data.renderManager,g=o.data.control;if(g){return new H.SafeString(R.getHTML(g));}var j=o.data.rootControl,p=o.data.path,P=o.data.children,t=o.hash["sap-ui-type"],k=q.sap.getObject(t),m=k&&k.getMetadata(),D=o.hash["sap-ui-default-aggregation"]||m&&m.getDefaultAggregationName(),v=o.data.view;if(!k){throw new Error("Control of type "+t+" cannot be found.");}var n={};if(o.fn){o.fn({},{data:{rootControl:j,path:p,children:n,defaultAggregation:D,view:v}});}var s=q.extend({},o.hash),S;for(var K in s){if(K==="sap-ui-class"&&typeof s[K]==="string"){S=s["sap-ui-class"]&&s["sap-ui-class"].split(" ");delete s[K];}else if(n[K]){delete s[K];}}var N=j.createControl(s,o.data.path,!!P,v);if(S&&S.length>0){S.forEach(N.addStyleClass.bind(N));}if(!q.isEmptyObject(n)){s=o.hash;var A=m.getAllAggregations();for(var x in n){var y=n[x];for(var i=0,l=y.length;i<l;i++){var z=y[i],B=A[x],E=B&&B.multiple;if(typeof s[x]==="string"){var F=M.bindingParser(s[x],v&&v.getController());F.template=z;N.bindAggregation(x,F);}else{if(E){N.addAggregation(x,z);}else{N.setAggregation(x,z);}}}}}if(P){var x=o.hash["sap-ui-aggregation"]||o.data.defaultAggregation;P[x]=P[x]||[];P[x].push(N);return;}return new H.SafeString(R.getHTML(N));},"property":function(f,o){o=o||f;d(o.hash);var R=o.data.rootControl,m=R.getMetadata(),p=o.hash.name,g=m.getProperty(p)._sGetter;return R[g]();},"aggregation":function(f,o){o=o||f;d(o.hash);if(o.data.children){var A=o.hash.name;if(o.fn){var D=q.extend({},o.data,{defaultAggregation:A});o.fn({},{data:D});}}else{var R=o.data.renderManager,g=o.data.rootControl,m=g.getMetadata(),A=o.hash.name,G=m.getAggregation(A)._sGetter,j=[];var k=g[G]();if(k){for(var i=0,l=k.length;i<l;i++){if(o.fn){j.push(o.fn({},{data:{renderManager:R,rootControl:g,control:k[i]}}));}else{j.push(R.getHTML(k[i]));}}}return new H.SafeString(j.join(""));}},"event":function(f,o){o=o||f;},"controlData":function(f,o){o=o||f;var R=o.data.rootControl;return new H.SafeString(r.getHTML(R));}};return h;}());
b.prototype.createMetadata=function(){var t=this.getContent(),f=this._fnTemplate=this._fnTemplate||H.compile(t);var m={},j=a.getMetadata().getAllSettings(),p=a.getMetadata().getAllPrivateAggregations();var h={"property":function(e,o){o=o||e;d(o.hash);var n=o.hash.name;if(n&&n!=="id"&&!j[n]){m.properties=m.properties||{};m.properties[n]=q.extend({},{type:"string"},o.hash);}else{throw new Error("The property name \""+n+"\" is reserved.");}},"aggregation":function(e,o){o=o||e;d(o.hash);var n=o.hash.name;if(n&&!j[n]&&!p[n]){o.hash.multiple=o.hash.multiple=="true";m.aggregations=m.aggregations||{};m.aggregations[n]=q.extend({},o.hash);}else{throw new Error("The aggregation name \""+n+"\" is reserved.");}},"event":function(e,o){o=o||e;},"controlData":function(e,o){o=o||e;m._hasControlData=true;}};["each","if","unless","with"].forEach(function(v){h[v]=function(){};});f({},{helpers:h});return m;};
b.prototype.createRenderer=function(v){var t=this.getContent(),f=this._fnTemplate=this._fnTemplate||H.compile(t);var r=function(e,o){var h=f(o.getContext()||{},{data:{renderManager:e,rootControl:o,view:v},helpers:b.RENDER_HELPERS});e.write(h);};return r;};
return b;});
sap.ui.predefine('sap/ui/core/tmpl/Template',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/base/BindingParser','sap/ui/core/Control','sap/ui/core/RenderManager','jquery.sap.sjax'],function(q,M,B,C,R){"use strict";
var T=M.extend("sap.ui.core.tmpl.Template",{
constructor:function(i,s){M.apply(this,arguments);},
metadata:{stereotype:"template","abstract":true,library:"sap.ui.core",properties:{"content":{type:"string",group:"Data",defaultValue:null}},publicMethods:["declareControl","createControl","placeAt","createMetadata","createRenderer"]}
});
var t={};
T.prototype.register=function(){var i=this.getId(),o=t[i],m;if(o&&this!==o){m="adding template with duplicate id '"+i+"'";q.sap.log.error(m);throw new Error("Error: "+m);}t[i]=this;};
T.prototype.deregister=function(){delete t[this.getId()];};
T.byId=function(i){return t[i];};
T.prototype.getInterface=function(){return this;};
T._mSupportedTypes={};
T.registerType=function(s,c){T._mSupportedTypes[s]=c;};
T.unregisterType=function(s){delete T._mSupportedTypes[s];};
T.parsePath=function(p){var m,s=p.indexOf(">");if(s>0){m=p.substr(0,s);p=p.substr(s+1);}return{path:p,model:m};};
T.prototype.init=function(s,S){if(this.getMetadata().getName()==="sap.ui.core.tmpl.Template"){throw new Error("The class 'sap.ui.core.tmpl.Template' is abstract and must not be instantiated!");}if(M.bindingParser===B.complexParser){T.prototype.extractBindingInfo=function(v,i,S){M.bindingParser=B.simpleParser;var r=C.prototype.extractBindingInfo.apply(this,arguments);M.bindingParser=B.complexParser;return r;};}};
T.prototype.declareControl=function(c){if(c){var m=this.createMetadata(),r=this.createRenderer(),a=this;var b=sap.ui.requireSync('sap/ui/core/tmpl/TemplateControl');b.extend(c,{metadata:m,init:function(){b.prototype.init.apply(this,arguments);this.setTemplate(a);},renderer:{renderTemplate:r,hasControlData:m._hasControlData}});return q.sap.getObject(c);}};
T.prototype.createControl=function(i,c,v){var a=sap.ui.requireSync('sap/ui/core/tmpl/TemplateControl');var o=new a({id:i,template:this,context:c});o.setTemplateRenderer(this.createRenderer(v));return o;};
T.prototype.placeAt=function(r,c,p,i){if(typeof c==="string"||typeof c==="number"){p=c;c=undefined;}var I;if(!(r instanceof C)&&i){var $=typeof r==="string"?q.sap.byId(r):q(r);if($.length>0){I=$.attr("id");r=$.get(0);var s=$.attr("data-context");c=c||s&&q.parseJSON(s);R.markInlineTemplate($);}}var o=this.createControl(I,c);o.placeAt(r,p);return o;};
T.prototype.createMetadata=function(){q.sap.log.error("The function createMetadata is an abstract function which needs to be implemented by subclasses.");};
T.prototype.createRenderer=function(){q.sap.log.error("The function createRenderer is an abstract function which needs to be implemented by subclasses.");};
sap.ui.template=function(o){if(!o){var a=[];q.each(T._mSupportedTypes,function(s,j){q("script[type='"+s+"'], [data-type='"+s+"']").each(function(n,E){a.push(sap.ui.template({id:E.id,domref:E,type:s,_class:j}));});});return a;}else{if(typeof o==="string"){return sap.ui.template({id:o});}else if(o&&o.tagName&&o.nodeName&&o.ownerDocument&&o.nodeType===1){return sap.ui.template({id:o.id,domref:o});}o=q.extend({type:T.DEFAULT_TEMPLATE},o);var i,s,c,b,d=false,l=typeof o.src==="string",I=false;if(l){var r=q.sap.sjax({url:o.src,dataType:"text"});if(r.success){i=o.id;s=o.type;c=o.control;b=r.data;var e=/^<!--\sUI5:Template\stype=([a-z\/\-]*)\s(?:controller=([A-Za-z.]*)\s)?-->/,f=b.match(e);if(f){s=f[1];if(f.length==3){d=f[2];}b=b.substr(f[0].length);}}else{throw new Error("The template could not be loaded from "+o.src+"!");}}else{var E=o.domref||q.sap.domById(o.id),$=q(E);I=false;i=o.id||E&&E.id;s=$.attr("type")||o.type;c=$.attr("data-control")||o.control;if(i){var g=sap.ui.getCore().getTemplate(i);if(!g instanceof T){throw new Error("Object for id \""+i+"\" is no sap.ui.core.tmpl.Template!");}else{if(g){return g;}}}if($.length===0){throw new Error("DOM element for the Template with the id \""+i+"\" not found!");}b=$.html();var h=E.tagName.toLowerCase();if(h!=="script"){I=$.parents("body").length===1;}}var j=o._class;if(!j){j=T._mSupportedTypes[s];if(!j){throw new Error("The type \""+s+"\" is not supported.");}}q.sap.require(j);var k=q.sap.getObject(j);var m=new k({id:i,content:b});if(c){m.declareControl(c);}if(d){m._sControllerName=d;}if(I){m.placeAt(i,o.context,undefined,true);}return m;}};
T.DEFAULT_TEMPLATE="text/x-handlebars-template";T.registerType(T.DEFAULT_TEMPLATE,"sap.ui.core.tmpl.HandlebarsTemplate");return T;});
sap.ui.predefine('sap/ui/core/tmpl/TemplateControl',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/DeclarativeSupport','sap/ui/core/library','sap/ui/core/UIArea','./DOMElement','./Template',"./TemplateControlRenderer"],function(q,C,D,l,U,a,T,b){"use strict";
var c=C.extend("sap.ui.core.tmpl.TemplateControl",{metadata:{library:"sap.ui.core",properties:{context:{type:"object",group:"Data",defaultValue:null}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},associations:{template:{type:"sap.ui.core.tmpl.Template",multiple:false}},events:{afterRendering:{},beforeRendering:{}}}});
c.prototype.init=function(){this._aBindingInfos=[];};
c.prototype.isInline=function(){var i=false,p=this.getParent();if(p instanceof U&&q(p.getRootNode()).attr("id")===this.getId()){i=true;}return i;};
c.prototype.placeAt=function(r,p){var i=this.isInline();var $=this.$(),u=this.getUIArea();C.prototype.placeAt.apply(this,arguments);if(i&&$.length===1){$.remove();u.destroyContent();}};
c.prototype.getTemplateRenderer=function(){return this.fnRenderer;};
c.prototype.setTemplateRenderer=function(r){this.fnRenderer=r;return this;};
c.prototype._cleanup=function(){this.destroyAggregation("controls");this._aBindingInfos.forEach(function(B){var o=B.binding;if(o){o.detachChange(B.changeHandler);o.destroy();}});this._aBindingInfos=[];};
c.prototype._compile=function(){var t=sap.ui.getCore().byId(this.getTemplate()),d=t&&t.getDeclarativeSupport();if(d){var e=this;setTimeout(function(){D.compile(e.getDomRef());});}};
c.prototype.exit=function(){this._cleanup();};
c.prototype.onBeforeRendering=function(){this.fireBeforeRendering();this._cleanup();};
c.prototype.onAfterRendering=function(){this.fireAfterRendering();};
c.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments);o.fnRenderer=this.fnRenderer;return o;};
c.prototype.updateBindings=function(u,m){C.prototype.updateBindings.apply(this,arguments);if(this.getDomRef()){this.invalidate();}};
c.prototype.bind=function(p,t){var P=T.parsePath(p),m=this.getModel(P.model),p=P.path,M=t?"bind"+q.sap.charToUpperCase(t):"bindProperty",B=m&&m[M](p),o={binding:B,path:P.path,model:P.model};if(B){o.changeHandler=function(){q.sap.log.debug("TemplateControl#"+this.getId()+": "+t+" binding changed for path \""+p+"\"");this.invalidate();}.bind(this);B.attachChange(o.changeHandler);}this._aBindingInfos.push(o);return B;};
c.prototype.calculatePath=function(p,t){var B=this.getBindingContext(),s=B&&B.getPath();if(p&&s&&!q.sap.startsWith(p,"/")){if(!q.sap.endsWith(s,"/")){s+="/";}p=s+p;}return p;};
c.prototype.bindProp=function(p){var B=this.bind(this.calculatePath(p),"property");return B&&B.getExternalValue();};
c.prototype.bindList=function(p){var B=this.bind(this.calculatePath(p),"list"),m=B&&B.getModel(),p=B&&B.getPath();return B&&m.getProperty(p);};
c.prototype.createDOMElement=function(s,p,d){var e=new a(s);if(p){e.bindObject(p);}if(!d){this.addAggregation("controls",e);}return e;};
c.prototype.createControl=function(s,p,d,v){var h={};q.each(s,function(k,V){h["data-"+q.sap.hyphen(k)]=V;});var $=q("<div/>",h);var o=D._createControl($.get(0),v);if(p){o.bindObject(p);}if(!d){this.addAggregation("controls",o);}return o;};
return c;});
sap.ui.predefine('sap/ui/core/tmpl/TemplateControlRenderer',function(){"use strict";var T={};
T.render=function(r,c){var s=c.isInline()||this.hasControlData;if(!s){r.write("<div");r.writeControlData(c);r.writeStyles();r.writeClasses();r.write(">");}var R=this.renderTemplate||c.getTemplateRenderer();if(R){R.apply(this,arguments);}if(!s){r.write("</div>");}};
return T;},true);
sap.ui.predefine('sap/ui/core/util/DraftEnabledMockServer',["jquery.sap.global","sap/ui/core/util/MockServer","jquery.sap.sjax"],function(q,M){"use strict";return{_oDraftMetadata:{},_oConstants:{COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT:"com.sap.vocabularies.Common.v1.DraftRoot",COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE:"com.sap.vocabularies.Common.v1.DraftNode",COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY:"com.sap.vocabularies.Common.v1.SemanticKey",EMPTY_GUID:"00000000-0000-0000-0000-000000000000",SIBLINGENTITY_NAVIGATION:"SiblingEntity",DRAFT_ADMINISTRATIVE_DATA:"DraftAdministrativeData",DRAFT_ADMINISTRATIVE_DATA_UUID:"DraftAdministrativeDataUUID",ACTIVATION_ACTION:"ActivationAction",EDIT_ACTION:"EditAction",VALIDATE_ACTION:"ValidationFunction",PREPARE_ACTION:"PreparationAction"},handleDraft:function(a,m){var n=function(b){var N=b.getParameter("oEntity");N.IsActiveEntity=false;N.HasActiveEntity=false;N.HasDraftEntity=false;};var d=function(b){var x=b.getParameter("oXhr");var c=q.sap.sjax({url:x.url,dataType:"json"}).data.d;for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var f in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[f].to.entitySet===this._oDraftMetadata.draftNodes[i]){var r=q.sap.sjax({url:c[f].__deferred.uri,dataType:"json"});if(r.data&&r.data.d&&r.data.d.results){var N;for(var j=0;j<r.data.d.results.length;j++){N=r.data.d.results[j];q.sap.sjax({url:N.__metadata.uri,type:"DELETE"});}}}}}};if(a&&a.EntityContainer){var e=a.EntityContainer[Object.keys(a.EntityContainer)[0]];for(var E in e){var o=e[E];if(o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT]){this._oDraftMetadata.draftRootName=E;this._oDraftMetadata.annotations=a;this._oDraftMetadata.mockServerRootUri=m.getRootUri();if(o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION]){this._oDraftMetadata.draftRootActivationName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION].String;}if(this._oDraftMetadata.draftRootActivationName){this._oDraftMetadata.draftRootActivationName=this._oDraftMetadata.draftRootActivationName.substring(this._oDraftMetadata.draftRootActivationName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootEditName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.EDIT_ACTION];this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName?this._oDraftMetadata.draftRootEditName.String:undefined;if(this._oDraftMetadata.draftRootEditName){this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName.substring(this._oDraftMetadata.draftRootEditName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootValidationName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.VALIDATE_ACTION];this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName?this._oDraftMetadata.draftRootValidationName.String:undefined;if(this._oDraftMetadata.draftRootValidationName){this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName.substring(this._oDraftMetadata.draftRootValidationName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootPreparationtionName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.PREPARE_ACTION];this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName?this._oDraftMetadata.draftRootPreparationtionName.String:undefined;if(this._oDraftMetadata.draftRootPreparationtionName){this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName.substring(this._oDraftMetadata.draftRootPreparationtionName.lastIndexOf("/")+1);}q.extend(m,this);m.attachAfter(M.HTTPMETHOD.POST,n,this._oDraftMetadata.draftRootName);m.attachBefore(M.HTTPMETHOD.DELETE,d,this._oDraftMetadata.draftRootName);m.attachAfter(M.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftRootName);}}}},_calcSemanticKeys:function(e,E){var s=[];for(var a in this._oDraftMetadata.annotations){if(a.lastIndexOf(E[e].type)>-1){s=this._oDraftMetadata.annotations[a][this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY]||[];break;}}var S=[];var b;for(var i=0;i<s.length;i++){b=s[i];for(var k in b){S.push(b[k]);}}return S;},_prepareDraftMetadata:function(e){var t=this;this._oDraftMetadata.draftNodes=[];this._oDraftMetadata.draftRootKey=e[this._oDraftMetadata.draftRootName].keys.filter(function(x){return q.inArray(x,t._calcSemanticKeys(t._oDraftMetadata.draftRootName,e))<0;})[0];var a=t._oDraftMetadata.annotations;var E=a.EntityContainer[Object.keys(a.EntityContainer)[0]];for(var s in E){var o=E[s];if(o[t._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE]){this._oDraftMetadata.draftNodes.push(s);}}for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){this.attachAfter(M.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftNodes[j]);}},_fnDraftAdministrativeData:function(e){var E={};var d=e.getParameter("oFilteredData");if(!d){E=e.getParameter("oEntry");if(E.IsActiveEntity&&!E.HasDraftEntity){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null;}}else{if(d.results){d=d.results;}else{if(q.isEmptyObject(d)){d=null;return;}}for(var i=0;i<d.length;i++){E=d[i];if(E.IsActiveEntity&&!E.HasDraftEntity){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null;}}}},_handleDraftArtifacts:function(e){var t=this;var m=this._oMockdata;var d=m[this._oDraftMetadata.draftRootName];var g=function(c,C){return c.filter(function(x){return q.inArray(x,C)<0;})[0];};if(d.length===100){for(var i=0;i<d.length;i++){var E=d[i];if(i<25){E.IsActiveEntity=true;E.HasActiveEntity=false;E.HasDraftEntity=false;E[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null;}var D=[];var s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=true;D[i].HasActiveEntity=false;D[i].HasDraftEntity=false;D[i][this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(D[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){D[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null;}var a=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);D[i][a]=this._oConstants.EMPTY_GUID;}}else if(i<50){E.IsActiveEntity=false;E.HasActiveEntity=false;E.HasDraftEntity=false;D=[];s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=false;D[i].HasActiveEntity=false;D[i].HasDraftEntity=false;a=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);}}else if(i<75){var S=q.extend(true,{},E);E.IsActiveEntity=true;E.HasActiveEntity=false;E.HasDraftEntity=true;E[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;D=[];s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=true;D[i].HasActiveEntity=false;D[i].HasDraftEntity=true;a=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);D[i][a]=this._oConstants.EMPTY_GUID;}S.IsActiveEntity=false;S.HasActiveEntity=true;S.HasDraftEntity=false;d[i+25]=S;}}}var r=this._getRootUri();q.each(e,function(b,o){q.each(m[b],function(I,c){c.__metadata=c.__metadata||{};c.__metadata.uri=r+b+"("+t._createKeysString(o,c)+")";c.__metadata.type=o.schema+"."+o.type;q.each(o.navprops,function(K){c[K]={__deferred:{uri:r+b+"("+t._createKeysString(o,c)+")/"+K}};});});});},_activate:function(e){var r;var g=function(c,C){return c.filter(function(x){return q.inArray(x,C)<0;})[0];};for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var n in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[n].to.entitySet===this._oDraftMetadata.draftNodes[i]){r=q.sap.sjax({url:e[n].__deferred.uri,dataType:"json"});if(r.success&&r.data&&r.data.d&&r.data.d.results){var N;for(var j=0;j<r.data.d.results.length;j++){N=r.data.d.results[j];N.IsActiveEntity=true;N.HasActiveEntity=false;N.HasDraftEntity=false;N[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;var s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[i],this._mEntitySets);var d=g(this._mEntitySets[this._oDraftMetadata.draftNodes[i]].keys,s);N[d]=this._oConstants.EMPTY_GUID;q.sap.sjax({url:N.__metadata.uri,type:"PATCH",data:JSON.stringify(N)});}}}}}e.IsActiveEntity=true;e.HasActiveEntity=false;e.HasDraftEntity=false;e[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;q.sap.sjax({url:e.__metadata.uri,type:"PATCH",data:JSON.stringify(e)});return e;},setRequests:function(r){var t=this;r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootActivationName),response:function(x){var R=JSON.parse(x.requestBody);var f=[];for(var p in R){f.push(p+" eq "+R[p]);}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];if(e.IsActiveEntity){x.respond(400);}if(e.HasActiveEntity){var s=e.SiblingEntity.__deferred.uri;o=q.sap.sjax({url:s,dataType:"json"});if(o.success&&o.data&&o.data.d.__metadata){var S=o.data.d;o=q.sap.sjax({url:S.__metadata.uri,type:"DELETE"});}}e=t._activate(e);x.respondJSON(200,{},JSON.stringify({d:e}));return true;}});if(t._oDraftMetadata.draftRootEditName){r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootEditName+"(\\?(.*))?"),response:function(x,u){var f=[];var R=JSON.parse(x.requestBody);if(R&&!q.isEmptyObject(R)){for(var p in R){f.push(p+" eq "+R[p]);}}else{var U=decodeURIComponent(u).replace("?","&").split("&");for(var a in U){var P=U[a];var b=new RegExp("(.*)=(.*)");var c;if(P){c=b.exec(P);f.push(c[1]+" eq "+c[2]);}}}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];if(!e.IsActiveEntity||e.HasDraftEntity){x.respond(400);}var d=q.extend(true,{},e);d.IsActiveEntity=false;d.HasActiveEntity=true;d.HasDraftEntity=false;d[t._oDraftMetadata.draftRootKey]=t._generatePropertyValue(t._oDraftMetadata.draftRootKey,"Guid");var s=t._getRootUri();var E=t._mEntitySets[t._oDraftMetadata.draftRootName];d.__metadata=d.__metadata||{};d.__metadata.uri=s+t._oDraftMetadata.draftRootName+"("+t._createKeysString(E,d)+")";d.__metadata.type=E.schema+"."+E.type;q.each(E.navprops,function(k){d[k]={__deferred:{uri:s+t._oDraftMetadata.draftRootName+"("+t._createKeysString(E,d)+")/"+k}};});t._oMockdata[t._oDraftMetadata.draftRootName].push(d);o=q.sap.sjax({url:e.__metadata.uri,type:"PATCH",data:JSON.stringify({HasDraftEntity:true})});x.respondJSON(200,{},JSON.stringify({d:d}));return true;}});}if(t._oDraftMetadata.draftRootValidationName){r.push({method:"GET",path:new RegExp(t._oDraftMetadata.draftRootValidationName+"(\\?(.*))?"),response:function(x,u){var v=t._oDraftMetadata.draftRootValidationName;t.fireEvent(M.HTTPMETHOD.GET+v+":before",{oXhr:x,sUrlParams:u});t.fireEvent(M.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var R={d:{}};R.d[v]={"__metadata":{"type":"ValidationResult"},"IsValid":true};t.fireEvent(M.HTTPMETHOD.GET+v+":after",{oXhr:x,oResult:R});t.fireEvent(M.HTTPMETHOD.GET+":after",{oXhr:x,oResult:R});x.respondJSON(200,{},JSON.stringify(R));return true;}});}if(t._oDraftMetadata.draftRootPreparationtionName){r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootPreparationtionName),response:function(x){t.fireEvent(M.HTTPMETHOD.POST+t._oDraftMetadata.draftRootPreparationtionName+":before",{oXhr:x});t.fireEvent(M.HTTPMETHOD.POST+":before",{oXhr:x});var R=JSON.parse(x.requestBody);var f=[];for(var p in R){f.push(p+" eq "+R[p]);}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];t.fireEvent(M.HTTPMETHOD.POST+t._oDraftMetadata.draftRootPreparationtionName+":after",{oXhr:x,oEntry:e});t.fireEvent(M.HTTPMETHOD.POST+":after",{oXhr:x,oEntry:e});x.respondJSON(200,{},JSON.stringify({d:e}));return true;}});}M.prototype.setRequests.apply(this,[r]);},_generateMockdata:function(e,b){M.prototype._generateMockdata.apply(this,[e,b]);this._handleDraftArtifacts(e);},_loadMockdata:function(e,b){M.prototype._loadMockdata.apply(this,[e,b]);this._handleDraftArtifacts(e);},_resolveNavigation:function(e,f,n,E){var a=M.prototype._resolveNavigation.apply(this,[e,f,n,E]);if(n===this._oConstants.SIBLINGENTITY_NAVIGATION){if(E&&E.IsActiveEntity){a.splice(0,1);}else{a.length>1?a.splice(1,1):a.splice(0,1);}}else if(n===this._oConstants.DRAFT_ADMINISTRATIVE_DATA){if(E){if(E.IsActiveEntity&&!E.HasDraftEntity){a[0]=null;}}else{a[0]=null;}}return a;},_findEntitySets:function(m){var e=M.prototype._findEntitySets.apply(this,[m]);this._prepareDraftMetadata(e);return e;},getEntitySetData:function(e){var E=M.prototype.getEntitySetData.apply(this,[e]);var g=function(){return E;};if(e===this._oDraftMetadata.draftRootName){this._fnDraftAdministrativeData({getParameter:g});return E;}for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){if(e===this._oDraftMetadata.draftNodes[j]){this._fnDraftAdministrativeData({getParameter:g});return E;}}return E;}};},true);
sap.ui.predefine('sap/ui/core/util/Export',['jquery.sap.global','sap/ui/core/Control','./ExportColumn','./ExportRow','./ExportType','./File'],function(q,C,E,a,b,F){'use strict';
function w(f,o){if(f){return function(){return f.apply(o,arguments);};}else{return f;}}
function p(m){q.sap.log.warning("Usage of deprecated jQuery Promise method: '"+m+"'. "+"Please use the standard Promise methods 'then' / 'catch' instead!","","sap.ui.core.util.Export");}
function c(P,o){var O=new Promise(P);o=o||O;var r=false,R=false;O.then(function(v){r=true;return v;},function(e){R=true;throw e;});var m={then:O.then,"catch":O["catch"]};function f(e){e.then=function(s,g){var A=[w(s,o),w(g,o)];return f(m.then.apply(e,A),o);};e["catch"]=function(g){var A=[w(g,o)];return f(m["catch"].apply(e,A),o);};[{jq:"done",es6:"then"},{jq:"fail",es6:"catch"},{jq:"always",es6:"then"}].forEach(function(g){e[g.jq]=function(){p(g.jq);var h=null;Array.prototype.concat.apply([],arguments).forEach(function(i){var W=w(i,o);var j=function(v){W.apply(this,arguments);return v;};var A=[j];if(g.jq==="always"){A.push(j);}if(!h){h=m[g.es6].apply(e,A);}else{h=h[g.es6].apply(h,A);}});return f(h,o);};});e.pipe=function(D,g){p("pipe");return e.then(D,g);};e.state=function(){p("state");if(r){return"resolved";}else if(R){return"rejected";}else{return"pending";}};return e;}return f(O);}
var d=C.extend('sap.ui.core.util.Export',{metadata:{publicMethods:["generate","saveFile"],library:"sap.ui.core",aggregations:{exportType:{type:'sap.ui.core.util.ExportType',multiple:false},columns:{type:'sap.ui.core.util.ExportColumn',multiple:true,bindable:'bindable'},rows:{type:'sap.ui.core.util.ExportRow',multiple:true,bindable:'bindable'},_template:{type:'sap.ui.core.util.ExportRow',multiple:false,visibility:'hidden'}}}});
d.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
d.prototype.init=function(){this._oPromise=null;this._fnResolvePromise=null;this._oRowBindingArgs=null;};
d.prototype.exit=function(){delete this._oPromise;delete this._fnResolvePromise;delete this._oRowBindingArgs;};
d.prototype._createRowTemplate=function(){var t=new a(this.getId()+"-row"),e=this.getColumns();for(var i=0,l=e.length;i<l;i++){var o=e[i].getTemplate();if(o){t.addCell(o.clone("col"+i));}}return t;};
d.prototype.bindAggregation=function(n,B){if(n==='rows'){this._oRowBindingArgs=arguments;return this;}return C.prototype.bindAggregation.apply(this,arguments);};
d.prototype.updateRows=function(r){if(r==='change'&&this._fnResolvePromise){var s=this.getExportType()._generate(this);this.destroyAggregation('_template');this.unbindAggregation('rows');this._fnResolvePromise(s);this._oPromise=null;this._fnResolvePromise=null;}};
d.prototype.generate=function(){var t=this;if(!this._oPromise){this._oPromise=c(function(r,e){t._fnResolvePromise=r;if(!t.hasModel()){e("Generate is not possible beause no model was set.");}else{var T=t._createRowTemplate();t.setAggregation('_template',T,true);C.prototype.bindAggregation.apply(t,t._oRowBindingArgs);if(t.getBinding("rows")){t.getBinding("rows").getContexts(0,t.getBinding("rows").getLength());}}},this);}return this._oPromise;};
d.prototype.saveFile=function(f){return this.generate().then(function(s){var e=this.getExportType();F.save(s,f||"data",e.getFileExtension(),e.getMimeType(),e.getCharset(),e.getByteOrderMark());});};
return d;});
sap.ui.predefine('sap/ui/core/util/ExportCell',['sap/ui/core/Element'],function(E){'use strict';
var a=E.extend('sap.ui.core.util.ExportCell',{metadata:{library:"sap.ui.core",properties:{content:'string'}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportColumn',['sap/ui/base/ManagedObject','./ExportCell'],function(M,E){'use strict';
var a=M.extend("sap.ui.core.util.ExportColumn",{metadata:{library:"sap.ui.core",properties:{name:"string"},aggregations:{template:{type:"sap.ui.core.util.ExportCell",multiple:false}}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportRow',['sap/ui/base/ManagedObject','./ExportCell'],function(M,E){'use strict';
var a=M.extend("sap.ui.core.util.ExportRow",{metadata:{library:"sap.ui.core",aggregations:{cells:{type:"sap.ui.core.util.ExportCell",multiple:true}}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportType',['sap/ui/base/ManagedObject'],function(M){'use strict';
var E=M.extend('sap.ui.core.util.ExportType',{metadata:{library:"sap.ui.core",properties:{fileExtension:'string',mimeType:'string',charset:'string',byteOrderMark:{type:'boolean',defaultValue:undefined}}}});
E.prototype.init=function(){this._oExport=null;};
E.prototype._generate=function(e){this._oExport=e;var c=this.generate();this._oExport=null;return c;};
E.prototype.generate=function(){return'';};
E.prototype.getColumnCount=function(){if(this._oExport){return this._oExport.getColumns().length;}return 0;};
E.prototype.getRowCount=function(){if(this._oExport&&this._oExport.getBinding("rows")){return this._oExport.getBinding("rows").getLength();}return 0;};
E.prototype.columnGenerator=function(){var i=0,c=this._oExport.getColumns(),C=c.length;return{next:function(){if(i<C){var I=i;i++;return{value:{index:I,name:c[I].getName()},done:false};}else{return{value:undefined,done:true};}}};};
E.prototype.cellGenerator=function(){var i=0,r=this._oExport.getAggregation('_template'),c=r.getCells(),C=c.length;return{next:function(){if(i<C){var I=i;i++;var m={};c[I].getCustomData().forEach(function(o){m[o.getKey()]=o.getValue();});return{value:{index:I,content:c[I].getContent(),customData:m},done:false};}else{return{value:undefined,done:true};}}};};
E.prototype.rowGenerator=function(){var t=this,i=0,e=this._oExport,b=e.getBinding("rows"),B=e.getBindingInfo("rows"),c=b.getContexts(0,b.getLength()),C=c.length,r=e.getAggregation('_template');return{next:function(){if(i<C){var I=i;i++;r.setBindingContext(c[I],B.model);return{value:{index:I,cells:t.cellGenerator()},done:false};}else{return{value:undefined,done:true};}}};};
return E;});
sap.ui.predefine('sap/ui/core/util/ExportTypeCSV',['./ExportType'],function(E){'use strict';var r=/[\r\n"\t;,]/;var a=/^[=\+\-@](?![\d.,]+(?:e[\+-]?\d+)?$)/i;
var C=E.extend('sap.ui.core.util.ExportTypeCSV',{metadata:{library:"sap.ui.core",properties:{separatorChar:{type:'string',defaultValue:','}}}});
C.prototype.setSeparatorChar=function(s){var s=this.validateProperty('separatorChar',s);if(s.length>1){throw new Error("Value of property \"separatorChar\" needs to be exactly one character or empty. "+"\""+s+"\" is "+s.length+" characters long.");}return this.setProperty('separatorChar',s);};
C.prototype.init=function(){this.setProperty('fileExtension','csv',true);this.setProperty('mimeType','text/csv',true);this.setProperty('charset','utf-8',true);};
C.prototype.escapeContent=function(v){if(!v){return v;}if(a.test(v)){v="'"+v;}var c=v.indexOf(this.getSeparatorChar())>-1;if(c||r.test(v)){v=v.replace(/"/g,'""');v='"'+v+'"';}return v;};
C.prototype.generate=function(){var b=[];this.generateColumns(b);this.generateRows(b);return b.join('\r\n');};
C.prototype.generateColumns=function(b){var c=[],o=this.columnGenerator(),d;while(!(d=o.next()).done){c.push(this.escapeContent(d.value.name));}b.push(c.join(this.getSeparatorChar()));};
C.prototype.generateRows=function(b){var R=this.rowGenerator(),o;while(!(o=R.next()).done){var c=[];var d=o.value.cells,e;while(!(e=d.next()).done){c.push(this.escapeContent(e.value.content));}b.push(c.join(this.getSeparatorChar()));}};
return C;});
sap.ui.predefine('sap/ui/core/util/File',['jquery.sap.global'],function(q){'use strict';var F={save:function(d,f,s,m,c,b){var a=f+'.'+s;if(typeof b==='undefined'&&c==='utf-8'&&s==='csv'){b=true;}if(b===true&&c==='utf-8'){d='\ufeff'+d;}if(window.Blob){var t='data:'+m;if(c){t+=';charset='+c;}var B=new window.Blob([d],{type:t});if(window.navigator.msSaveOrOpenBlob){window.navigator.msSaveOrOpenBlob(B,a);}else{var u=window.URL||window.webkitURL;var e=u.createObjectURL(B);var l=window.document.createElement('a');if('download'in l){var $=q(document.body);var g=q(l).attr({download:a,href:e,style:'display:none'});$.append(g);g.get(0).click();g.remove();}else{d=encodeURI(d);var w=window.open(t+","+d);if(!w){throw new Error("Could not download the file, please deactivate your pop-up blocker.");}}}}}};return F;},true);
sap.ui.predefine('sap/ui/core/util/LibraryInfo',['jquery.sap.global','sap/ui/base/Object','jquery.sap.script'],function(q,B){"use strict";
var L=B.extend("sap.ui.core.util.LibraryInfo",{
constructor:function(){B.apply(this);this._oLibInfos={};},
destroy:function(){B.prototype.destroy.apply(this,arguments);this._oLibInfos={};},
getInterface:function(){return this;}
});
L.prototype._loadLibraryMetadata=function(l,c){l=l.replace(/\//g,".");if(this._oLibInfos[l]){q.sap.delayedCall(0,window,c,[this._oLibInfos[l]]);return;}var t=this,u,s,p=/themelib_(.*)/i.exec(l);if(!p){s=".library";u=q.sap.getModulePath(l,'/');}else{s=".theme";u=q.sap.getModulePath("sap.ui.core",'/themes/'+p[1]+"/");}q.ajax({url:u+s,dataType:"xml",error:function(x,a,e){q.sap.log.error("failed to load library details from '"+u+s+": "+a+", "+e);t._oLibInfos[l]={name:l,data:null,url:u};c(t._oLibInfos[l]);},success:function(d,S,x){t._oLibInfos[l]={name:l,data:d,url:u};c(t._oLibInfos[l]);}});};
L.prototype._getLibraryInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data);r.vendor=$.find("vendor").text();r.copyright=$.find("copyright").text();r.version=$.find("version").text();r.documentation=$.find("documentation").text();r.releasenotes=$.find("releasenotes").attr("url");r.componentInfo=L.prototype._getLibraryComponentInfo($);}c(r);});};
L.prototype._getThirdPartyInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data).find("appData").find("thirdparty").children();$.each(function(i,o){if(o.nodeName==="lib"){var a=q(o);var b=a.children("license");r.libs.push({displayName:a.attr("displayName"),homepage:a.attr("homepage"),license:{url:b.attr("url"),type:b.attr("type"),file:d.url+b.attr("file")}});}});}c(r);});};
L.prototype._getDocuIndex=function(l,c){this._loadLibraryMetadata(l,function(d){var a=d.name,b=d.url,r={"docu":{},library:a,libraryUrl:b};if(!d.data){c(r);return;}var D=q(d.data).find("appData").find("documentation");var u=D.attr("indexUrl");if(!u){c(r);return;}if(D.attr("resolve")=="lib"){u=d.url+u;}q.ajax({url:u,dataType:"json",error:function(x,s,e){q.sap.log.error("failed to load library docu from '"+u+"': "+s+", "+e);c(r);},success:function(d,s,x){d.library=a;d.libraryUrl=b;c(d);}});});};
L.prototype._getReleaseNotes=function(l,v,c){this._loadLibraryMetadata(l,function(d){if(!d.data){c({});return;}var i=(v.split(".").length===3)&&!(/-SNAPSHOT/.test(v));var V=q.sap.Version(v);var m=V.getMajor();var M=V.getMinor();var p=V.getPatch();var D=q(d.data).find("appData").find("releasenotes");var u=D.attr("url");if(!u){q.sap.log.warning("failed to load release notes for library "+l);c({});return;}if(V.getSuffix()==="-SNAPSHOT"){if(M%2!=0){M=(M+1);p=0;}v=m+"."+M+"."+p;}var b=window.location.href,r=/\/\d.\d{1,2}.\d{1,2}\//;if(D.attr("resolve")=="lib"){if(r.test(b)||i===false){u=d.url+u;}else{u="{major}.{minor}.{patch}/"+d.url+u;}}u=u.replace(/\{major\}/g,m);u=u.replace(/\{minor\}/g,M);u=u.replace(/\{patch\}/g,p);q.ajax({url:u,dataType:"json",error:function(x,s,e){if(s==="parsererror"){q.sap.log.error("failed to parse release notes for library '"+l+", "+e);}else{q.sap.log.warning("failed to load release notes for library '"+l+", "+e);}c({});},success:function(d,s,x){c(d,v);}});});};
L.prototype._getLibraryComponentInfo=function(d){var a={};var c=[];var D="";d.find("ownership > component").each(function(b,C){if(C.childElementCount===0){D=C.textContent;}else{var v=C.getElementsByTagName("name");if(v&&v.length>0){v=v[0].textContent;var e=C.getElementsByTagName("module");if(v&&e&&e.length>0){var m=[];for(var i=0;i<e.length;i++){var M=e[i].textContent.replace(/\//g,".");if(M){m.push(M);}}if(m.length>0){c.push({"component":v,"modules":m});}}}}});a["defaultComponent"]=D;if(c&&c.length>0){a["specialCases"]=c;}return a;};
L.prototype._getActualComponent=function(c,m){function a(m,p){m=m.toLowerCase();p=p.toLowerCase();return(m===p||p.match(/\*$/)&&m.indexOf(p.slice(0,-1))===0||p.match(/\.\*$/)&&m===p.slice(0,-2));}if(m){for(var k in c){if(!c[k]){q.sap.log.error("No library information deployed for "+k);continue;}var C;if(m.indexOf(k)===0){C=c[k].defaultComponent;}var s=c[k].specialCases;if(s){for(var i=0;i<s.length;i++){var S=s[i].modules;for(var j=0;j<S.length;j++){if(a(m,S[j])){C=s[i].component;}}}}if(C){return C;}}}};
L.prototype._getDefaultComponent=function(l){return l&&l.componentInfo&&l.componentInfo.defaultComponent;};
return L;});
sap.ui.predefine('sap/ui/core/util/MockServer',['jquery.sap.global','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/thirdparty/sinon','jquery.sap.sjax'],function(q,D,M,d){"use strict";if(D.browser.msie){q.sap.require("sap.ui.thirdparty.sinon-ie");if(!window.FormData){window.FormData=function(){};}}
var f=M.extend("sap.ui.core.util.MockServer",{
constructor:function(i,s,S){M.apply(this,arguments);f._aServers.push(this);},
metadata:{properties:{rootUri:"string",recordRequests:{type:"boolean",defaultValue:true},requests:{type:"object[]",defaultValue:[]}}},
_oServer:null,
_aFilter:null,
_oMockdata:null,
_oMetadata:null,
_sMetadataUrl:null,
_sMockdataBaseUrl:null,
_mEntitySets:null,
_oErrorMessages:{INVALID_SYSTEM_QUERY_OPTION_VALUE:"Invalid system query options value",IS_NOT_A_VALID_SYSTEM_QUERY_OPTION:"## is not a valid system query option",URI_VIOLATING_CONSTRUCTION_RULES:"The URI is violating the construction rules defined in the Data Services specification",UNSUPPORTED_FORMAT_VALUE:"Unsupported format value. Only json format is supported",MALFORMED_SYNTAX:"The Data Services Request could not be understood due to malformed syntax",RESOURCE_NOT_FOUND:"Resource not found",INVALID_SORTORDER_DETECTED:"Invalid sortorder ## detected",PROPERTY_NOT_FOUND:"Property ## not found",INVALID_FILTER_QUERY_STATEMENT:"Invalid filter query statement",INVALID_FILTER_OPERATOR:"Invalid $filter operator ##",RESOURCE_NOT_FOUND_FOR_SEGMENT:"Resource not found for the segment ##",MALFORMED_URI_LITERAL_SYNTAX_IN_KEY:"Malformed URI literal syntax in key ##",INVALID_KEY_NAME:"Invalid key name in key predicate. Expected name is ##",INVALID_KEY_PREDICATE_QUANTITY:"Invalid key predicate. The quantity of provided keys does not match the expected value",INVALID_KEY_TYPE:"Invalid key predicate. The key literal for key property ## does not match its type."}
});
f.prototype._getPseudoRandomNumber=function(t){if(!this._iRandomSeed){this._iRandomSeed={};}if(!this._iRandomSeed.hasOwnProperty(t)){this._iRandomSeed[t]=0;}this._iRandomSeed[t]=(this._iRandomSeed[t]+11)*25214903917%281474976710655;return this._iRandomSeed[t]/281474976710655;};
f.prototype.start=function(){this._oServer=f._getInstance();this._aFilters=[];var r=this.getRequests();var t=this;r.forEach(function(R){var a;if(t.getRecordRequests()===false&&R.response){a=function(){R.response.apply(this,arguments);t._oServer.requests=[];};}else{a=R.response;}t._addRequestHandler(R.method,R.path,a);});};
f.prototype.stop=function(){if(this.isStarted()){this._removeAllRequestHandlers();this._removeAllFilters();this._oServer=null;}};
f.prototype.attachBefore=function(h,c,e){e=e?e:"";this.attachEvent(h+e+":before",c);};
f.prototype.attachAfter=function(h,c,e){e=e?e:"";this.attachEvent(h+e+":after",c);};
f.prototype.detachBefore=function(h,c,e){e=e?e:"";this.detachEvent(h+e+":before",c);};
f.prototype.detachAfter=function(h,c,e){e=e?e:"";this.detachEvent(h+e+":after",c);};
f.prototype.isStarted=function(){return!!this._oServer;};
f.prototype.getEntitySetData=function(e){var t=this;var c;if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){c=q.extend(true,[],t._oMockdata[e]);}else{q.sap.log.error("Unrecognized EntitySet name: "+e);}return c;};
f.prototype.setEntitySetData=function(e,a){if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){this._oMockdata[e]=a;}else{q.sap.log.error("Unrecognized EntitySet name: "+e);}};
f.prototype._applyQueryOnCollection=function(F,Q,e,u){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$top":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(0,o);break;case"$skip":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(o,F.results.length);break;case"$orderby":F.results=this._getOdataQueryOrderby(F.results,o,e);break;case"$filter":F.results=this._recursiveOdataQueryFilter(F.results,o);break;case"search-focus":break;case"search":var s="";for(var i=0;i<u.length;i++){if(u[i].indexOf("search-focus")!=-1){s=u[i].split('=')[1];break;}}F.results=this._recursiveOdataQuerySearch(F.results,o,s,e);break;case"$select":F.results=this._getOdataQuerySelect(F.results,o,e);break;case"$inlinecount":var c=this._getOdataInlineCount(F.results,o);if(c){F.__count=c;}break;case"$expand":F.results=this._getOdataQueryExpand(F.results,o,e);break;case"$format":F.results=this._getOdataQueryFormat(F.results,o);break;default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};
f.prototype._applyQueryOnEntry=function(e,Q,E){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$filter":return this._recursiveOdataQueryFilter([e],o)[0];case"$select":return this._getOdataQuerySelect([e],o,E)[0];case"$expand":return this._getOdataQueryExpand([e],o,E)[0];case"$format":return this._getOdataQueryFormat([e],o);default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};
f.prototype._getOdataQueryOrderby=function(c,o,e){var p=o.split(',');var t=this;q.each(p,function(i,P){p[i]=t._trim(P);});var C=function compare(a,b){for(var i=0;i<p.length;i++){var s=p[i].split(' ');var S=1;if(s.length>1){switch(s[1]){case'asc':S=1;break;case'desc':S=-1;break;default:t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_SORTORDER_DETECTED,s[1]);}}var P,h;var j=s[0].indexOf("/");if(j!==-1){P=s[0].substring(j+1);h=s[0].substring(0,j);if(!a[h].hasOwnProperty(P)){var E=false;var T=[];if(h){var k=t._mEntitySets[e].navprops[h].to.entitySet;T=t._mEntityTypes[t._mEntitySets[k].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===P){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}}if(a[h][P]<b[h][P]){return-1*S;}if(a[h][P]>b[h][P]){return 1*S;}}else{P=s[0];if(!a.hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}if(a[P]<b[P]){return-1*S;}if(a[P]>b[P]){return 1*S;}}}return 0;};return c.sort(C);};
f.prototype._arrayUnique=function(b){var a=b.concat();for(var i=0;i<a.length;++i){for(var j=i+1;j<a.length;++j){if(a[i]===a[j]){a.splice(j--,1);}}}return a;};
f.prototype._getBracketIndices=function(s){var S=[];var r=false;var i,e=0;for(var c=0;c<s.length;c++){if(s[c]==='('){if(/[substringof|endswith|startswith]$/.test(s.substring(0,c))){r=true;}else{S.push(s[c]);if(i===undefined){i=c;}}}else if(s[c]===')'){if(!r){S.pop();e=c;if(S.length===0){return{start:i,end:e};}}else{r=false;}}}return{start:i,end:e};};
f.prototype._recursiveOdataQueryFilter=function(a,o){var I=this._getBracketIndices(o);if(I.start===0&&I.end===o.length-1){o=this._trim(o.substring(I.start+1,I.end));return this._recursiveOdataQueryFilter(a,o);}var r=/([^substringof|endswith|startswith]|^)\((.*)\)/,s,p;var O;if(r.test(o)){var b=o.substring(I.start,I.end+1);var c=new RegExp("(.*) +(or|and) +("+this._trim(this._escapeStringForRegExp(b))+".*)");if(I.start===0){c=new RegExp("("+this._trim(this._escapeStringForRegExp(b))+") +(or|and) +(.*)");}var e=c.exec(o);if(e===null){o=o.replace(/[\(\)]/g,"");return this._getOdataQueryFilter(a,this._trim(o));}var E=e[1];O=e[2];var h=e[3];var S=this._recursiveOdataQueryFilter(a,E);if(O==="or"){s=this._recursiveOdataQueryFilter(a,h);return this._arrayUnique(S.concat(s));}if(O==="and"){return this._recursiveOdataQueryFilter(S,h);}}else{p=o.split(/ +and | or +/);if(p.length===1){if(o.match(/ +and | or +/)){throw new Error("400");}return this._getOdataQueryFilter(a,this._trim(o));}var R=this._recursiveOdataQueryFilter(a,p[0]);var j;for(var i=1;i<p.length;i++){j=new RegExp(this._trim(this._escapeStringForRegExp(p[i-1]))+" +(and|or) +"+this._trim(this._escapeStringForRegExp(p[i])));O=j.exec(o)[1];if(O==="or"){s=this._recursiveOdataQueryFilter(a,p[i]);R=this._arrayUnique(R.concat(s));}if(O==="and"){R=this._recursiveOdataQueryFilter(R,p[i]);}}return R;}};
f.prototype._getOdataQueryFilter=function(a,o){if(a.length===0){return a;}var r=new RegExp("(.*) (eq|ne|gt|lt|le|ge) (.*)");var b=new RegExp("(endswith|startswith|substringof)\\((.*)");var O=null;var c=r.exec(o);if(c){O=c[2];}else{c=b.exec(o);if(c){O=c[1];}else{this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_FILTER_QUERY_STATEMENT);}}var t=this;var G=function(v,V,p,s){var c,e,P;if(!v){c=r.exec(o);e=t._trim(c[V+1]);P=t._trim(c[p+1]);}else{var h=new RegExp("(substringof|startswith|endswith)\\(([^\\)]*),(.*)\\)");c=h.exec(o);e=t._trim(c[V+2]);P=t._trim(c[p+2]);}var T=e[e.length-1];if(T==="M"||T==="m"||T==="L"||T==="f"){e=e.substring(0,e.length-1);}if(e.indexOf("datetime")===0){e=t._getJsonDate(e);}else if(e.indexOf("guid")===0){e=e.substring(5,e.length-1);}else if(e==="true"){e=true;}else if(e==="false"){e=false;}else if(t._isValidNumber(e)){e=parseFloat(e);}else if((e.charAt(0)==="'")&&(e.charAt(e.length-1)==="'")){e=e.substr(1,e.length-2);}var C=P.indexOf("/");if(C!==-1){var i=P.substring(C+1);var j=P.substring(0,C);if(a[0][j]){if(!a[0][j].hasOwnProperty(i)){var E=t._oErrorMessages.PROPERTY_NOT_FOUND.replace("##","'"+i+"'");q.sap.log.error("MockServer: navigation property '"+j+"' was not expanded, so "+E);return a;}}else{t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e,j,i);}else{if(!a[0].hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e);}};switch(O){case"substringof":return G(true,0,1,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)!==-1);}return(typeof m[p]==="string"&&m[p].indexOf(v)!==-1);});});case"startswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===0);}return(typeof m[p]==="string"&&m[p].indexOf(v)===0);});});case"endswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===(m[C][P].length-v.length));}return(typeof m[p]==="string"&&m[p].indexOf(v)===(m[p].length-v.length));});});case"eq":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]===v);}return(m[p]===v);});});case"ne":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]!==v);}return(m[p]!==v);});});case"gt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>v);}return(m[p]>v);});});case"lt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<v);}return(m[p]<v);});});case"ge":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>=v);}return(m[p]>=v);});});case"le":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<=v);}return(m[p]<=v);});});default:this._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_FILTER_OPERATOR,O);}};
f.prototype._recursiveOdataQuerySearch=function(a,o,O,e){var F="";if(O==""||O==undefined){for(var i=0;i<this._mEntitySets[e].keys.length;i++){if(i!=0){F=F+" or ";}F=F+"startswith("+this._mEntitySets[e].keys[i]+",'"+o+"')";}}else{F="substringof('"+o+"',"+O+")";}return this._recursiveOdataQueryFilter(a,F);};
f.prototype._getOdataQuerySelect=function(a,o,e){var t=this;var p,c;var P=o.split(',');var s=[];var b;var h=a[0]?a[0][P[0].split('/')[0]]:null;if(!(h!=null&&h.results&&h.results.length>0)){var C=function(P,k,b,l){var n={};q.each(P,function(i,j){var r=j.indexOf("/");if(r!==-1){p=j.substring(r+1);c=j.substring(0,r);if(n[c]){n[c].push(p);}else{n[c]=[p];}}});q.each(Object.keys(n),function(i,j){if(!b[j]){b[j]={};}b[j]=C(n[j],k[j],b[j],j);});if(k.results){var F=[];q.each(k.results,function(i,r){var u={};q.each(P,function(j,v){u[v]=r[v];});F.push(u);});if(b){b.results=F;}}else{if(k["__metadata"]){b["__metadata"]=k["__metadata"];}q.each(P,function(i,j){var r=j.indexOf("/");if(r===-1){if(k&&!k.hasOwnProperty(j)){var E=false;var T=[];if(l){var u=t._mEntitySets[e].navprops[l].to.entitySet;T=t._mEntityTypes[t._mEntitySets[u].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===j){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,j);}}b[j]=k[j];}});}return b;};if(q.inArray("*",P)!==-1){return a;}q.each(P,function(i,j){P[i]=t._trim(j);});q.each(a,function(i,j){b={};s.push(C(P,j,b));});}else{var m=function(i,j,k){var r={};k=k||'';if(typeof i!=='object'){return i;}if(typeof i.slice==='function'){return i.map(function(l,n){return m(l,j,k);});}if(i.__metadata!==undefined&&k.length===0){r.__metadata=i.__metadata;}j.filter(function(l){return(l+'/').indexOf(k)===0;}).forEach(function(l,_,n){var u=l.substr(k.length).split('/')[0];if(i[u]!==undefined){r[u]=m(i[u],n,k+u+'/');}});if(i.results!==undefined){r.results=m(i.results,j,k);}return r;};s=m(a,P);}return s;};
f.prototype._getOdataInlineCount=function(a,o){var p=o.split(',');if(p.length!==1||(p[0]!=='none'&&p[0]!=='allpages')){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}if(p[0]==='none'){return;}return a.length;};
f.prototype._getOdataQueryFormat=function(a,o){if(o!=='json'){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.UNSUPPORTED_FORMAT_VALUE);}return a;};
f.prototype._getOdataQueryExpand=function(a,o,e){var t=this;var n=o.split(',');q.each(n,function(i,p){n[i]=t._trim(p);});var E=t._mEntitySets[e].navprops;q.each(a,function(i,r){q.each(n,function(i,N){var b=N.split("/");var s=b[0];if(!r[s]){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,s);}var c=r[s].results||r[s];if(!c||!!c.__deferred){c=q.extend(true,[],t._resolveNavigation(e,r,s,r));}else if(!q.isArray(c)){c=[c];}if(!!c&&b.length>1){var R=b.splice(1,b.length).join("/");c=t._getOdataQueryExpand(c,R,E[s].to.entitySet);}if(E[s].to.multiplicity==="*"){r[s]={results:c};}else{r[s]=c[0]?c[0]:{};}});});return a;};
f.prototype._refreshData=function(){var m=this._loadMetadata(this._sMetadataString);if(!m){return;}this._mEntitySets=this._findEntitySets(this._oMetadata);this._mEntityTypes=this._findEntityTypes(this._oMetadata);if(!this._sMockdataBaseUrl){this._generateMockdata(this._mEntitySets,this._oMetadata);}else{if(!q.sap.endsWith(this._sMockdataBaseUrl,"/")&&!q.sap.endsWith(this._sMockdataBaseUrl,".json")){this._sMockdataBaseUrl+="/";}this._loadMockdata(this._mEntitySets,this._sMockdataBaseUrl);}};
f.prototype._getRootUri=function(){var u=this.getRootUri();u=u&&/([^?#]*)([?#].*)?/.exec(u)[1];return u;};
f.prototype._loadMetadata=function(m){var m;m=m.trim();if(m.substring(0,1)!=="<"){m=q.sap.sjax({url:m,dataType:"text"}).data;if(!m){q.sap.log.error("MockServer: The metadata for url \""+m+"\" could not be found!");}}this._sMetadata=m;try{this._oMetadata=q.parseXML(m);}catch(e){q.sap.log.error("MockServer: Invalid metadata XML! Reason: "+e);}return this._oMetadata;};
f.prototype._findEntitySets=function(m){var e={};var p=q(m).find("Principal");var o=q(m).find("Dependent");q(m).find("EntitySet").each(function(i,E){var $=q(E);var a=/((.*)\.)?(.*)/.exec($.attr("EntityType"));e[$.attr("Name")]={"name":$.attr("Name"),"schema":a[2],"type":a[3],"keys":[],"keysType":{},"navprops":{}};});var r=function(R,a,A,F){var E=q(A).find("End[Role='"+R+"']").attr("EntitySet");var s=q(a).find("End[Role='"+R+"']").attr("Multiplicity");var P=[];var c=q(a).find("ReferentialConstraint > [Role='"+R+"']");if(c&&c.length>0){q(c[0]).children("PropertyRef").each(function(i,h){P.push(q(h).attr("Name"));});}else{var b=(F)?p:o;q(b).each(function(i,h){if(R===(q(h).attr("Role"))){q(h).children("PropertyRef").each(function(i,j){P.push(q(j).attr("Name"));});return false;}});}return{"role":R,"entitySet":E,"propRef":P,"multiplicity":s};};q.each(e,function(E,a){var $=q(m).find("EntityType[Name='"+a.type+"']");var k=q($).find("PropertyRef");q.each(k,function(i,P){var K=q(P).attr("Name");a.keys.push(K);a.keysType[K]=q($).find("Property[Name='"+K+"']").attr("Type");});var n=q(m).find("EntityType[Name='"+a.type+"'] NavigationProperty");q.each(n,function(i,N){var b=q(N);var R=b.attr("Relationship").split(".");var A=q(m).find("AssociationSet[Association = '"+R.join(".")+"']");var s=R.pop();var c=q(m).find("Association[Name = '"+s+"']");a.navprops[b.attr("Name")]={"name":b.attr("Name"),"from":r(b.attr("FromRole"),c,A,true),"to":r(b.attr("ToRole"),c,A,false)};});});return e;};
f.prototype._findEntityTypes=function(m){var e={};q(m).find("EntityType").each(function(i,E){var $=q(E);e[$.attr("Name")]={"name":$.attr("Name"),"properties":[],"keys":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");e[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});$.find("PropertyRef").each(function(i,k){var K=q(k);var p=K.attr("Name");e[$.attr("Name")].keys.push(p);});});return e;};
f.prototype._findComplexTypes=function(m){var c={};q(m).find("ComplexType").each(function(i,C){var $=q(C);c[$.attr("Name")]={"name":$.attr("Name"),"properties":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");c[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});});return c;};
f.prototype._createKeysString=function(e,E){var t=this;var k="";if(E){q.each(e.keys,function(i,K){if(k){k+=",";}var o=E[K];if(e.keysType[K]==="Edm.String"){o=encodeURIComponent("'"+o+"'");}else if(e.keysType[K]==="Edm.DateTime"){o=t._getDateTime(o);o=encodeURIComponent(o);}else if(e.keysType[K]==="Edm.Guid"){o="guid'"+o+"'";}if(e.keys.length===1){k+=o;return k;}k+=K+"="+o;});}return k;};
f.prototype._loadMockdata=function(e,b){var t=this,m={};this._oMockdata={};var l=function(u,o){var r=q.sap.sjax({url:u,dataType:"json"});if(r.success){if(r.data.d){if(r.data.d.results){m[o.name]=r.data.d.results;}else{q.sap.log.error("The mock data format for entity set \""+o.name+"\" invalid");}}else{if(q.isArray(r.data)){m[o.name]=r.data;}else{q.sap.log.error("The mock data for entity set \""+o.name+"\" could not be loaded due to wrong format!");return false;}}return true;}else{if(r.status==="parsererror"){q.sap.log.error("The mock data for entity set \""+o.name+"\" could not be loaded due to a parsing error!");}return false;}};if(q.sap.endsWith(b,".json")){var r=q.sap.sjax({url:b,dataType:"json"});if(r.success){m=r.data;}else{q.sap.log.warning("The mock data for all the entity types could not be found at \""+b+"\"!");}}else{var E={};if(t._aEntitySetsNames&&t._aEntitySetsNames.length>0){var s;for(var i=0;i<t._aEntitySetsNames.length;i++){s=t._aEntitySetsNames[i];if(e[s]){E[s]=e[s];}}}else{E=e;}q.each(E,function(a,o){if(!m[o.type]||!m[o.name]){var c=b+o.name+".json";if(!l(c,o)){q.sap.log.warning("The mock data for entity set \""+o.name+"\" could not be found at \""+b+"\"!");var h=b+o.type+".json";if(!l(h,o)){q.sap.log.warning("The mock data for entity type \""+o.type+"\" could not be found at \""+b+"\"!");if(t._bGenerateMissingMockData){var j={};j[o.name]=o;m[o.type]=t._generateODataMockdataForEntitySet(j,t._oMetadata)[o.name];}}}}});}q.each(e,function(a,o){t._oMockdata[a]=[];if(m[o.name]){q.each(m[o.name],function(I,c){t._oMockdata[a].push(q.extend(true,{},c));});}else if(m[o.type]){q.each(m[o.type],function(I,c){t._oMockdata[a].push(q.extend(true,{},c));});}});q.each(e,function(a,o){if(t._oMockdata[a].length>0){t._enhanceWithMetadata(o,t._oMockdata[a]);}});return this._oMockdata;};
f.prototype._enhanceWithMetadata=function(e,m){if(m){var t=this,r=this._getRootUri(),E=e&&e.name;q.each(m,function(i,o){o.__metadata=o.__metadata||{};o.__metadata.id=r+E+"("+t._createKeysString(e,o)+")";o.__metadata.type=e.schema+"."+e.type;o.__metadata.uri=r+E+"("+t._createKeysString(e,o)+")";q.each(e.navprops,function(k,n){if(o[k]&&!q.isEmptyObject(o[k])&&!o[k]["__deferred"]){t._oMockdata[n.to.entitySet]=t._oMockdata[n.to.entitySet].concat(o[k]);}o[k]={__deferred:{uri:r+E+"("+t._createKeysString(e,o)+")/"+k}};});});}};
f.prototype._isRequestedKeysValid=function(e,r){if(r.length===1){var s=r[0].split('=');if(this._trim(s[0])!==e.keys[0]){r=[e.keys[0]+"="+r[0]];}}for(var i=0;i<r.length;i++){var k=this._trim(r[i].substring(0,r[i].indexOf('=')));var R=this._trim(r[i].substring(r[i].indexOf('=')+1));var F=R.charAt(0);var l=R.charAt(R.length-1);if(e.keysType[k]==="Edm.String"){if(F!=="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.DateTime"){if(F==="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Guid"){if(F==="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Binary"){if(!(new RegExp("(binary|X)'[A-Fa-f0-9][A-Fa-f0-9]*'").test(R))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else{if((F==="'"&&l!=="'")||(l==="'"&&F!=="'")){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}var K=e.keys.join(",");if(e.keys.indexOf(k)===-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_KEY_NAME,K);}}};
f.prototype._parseKeys=function(k,e){var r={};var p=k.split(",");var K,s,P;for(var i=0;i<p.length;i++){P=p[i].split("=");if(P.length===1&&e.keys.length===1){K=e.keys[0];s=P[0];}else{if(P.length===2){K=P[0];s=P[1];}}r[K]=s;switch(e.keysType[K]){case"Edm.String":r[K]=r[K].replace(/^\'|\'$/g,"");break;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":r[K]=parseFloat(r[K]);break;case"Edm.Guid":r[K]=r[K].replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":case"Edm.Binary":case"Edm.DateTimeOffset":default:r[K]=r[K];}}return r;};
f.prototype._generatePropertyValue=function(k,t,C,i){var I=i;if(!I){I=Math.floor(this._getPseudoRandomNumber("String")*10000)+101;}switch(t){case"String":return k+" "+I;case"DateTime":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTime")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTime")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTime")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+")/";case"Int16":case"Int32":case"Int64":return Math.floor(this._getPseudoRandomNumber("Int")*10000);case"Decimal":return Math.floor(this._getPseudoRandomNumber("Decimal")*1000000)/100;case"Boolean":return this._getPseudoRandomNumber("Boolean")<0.5;case"Byte":return Math.floor(this._getPseudoRandomNumber("Byte")*10);case"Double":return this._getPseudoRandomNumber("Double")*10;case"Single":return this._getPseudoRandomNumber("Single")*1000000000;case"SByte":return Math.floor(this._getPseudoRandomNumber("SByte")*10);case"Time":return"PT"+Math.floor(this._getPseudoRandomNumber("Time")*23)+"H"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"M"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"S";case"Guid":return'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=this._getPseudoRandomNumber("Guid")*16|0,v=c==='x'?r:(r&0x3|0x8);return v.toString(16);}.bind(this));case"Binary":var n=Math.floor(-2147483648+this._getPseudoRandomNumber("Binary")*4294967295),m="";for(var b=0,e=n;b<32;b++,m+=String(e>>>31),e<<=1);return m;case"DateTimeOffset":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+"+0000)/";default:return this._generateDataFromEntity(C[t],I,C);}};
f.prototype._isFalseyValue=function(k,K,s){switch(s){case"Edm.String":return k==="";case"Edm.Boolean":return k===false;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":return k===0||isNaN(k);default:return false;}};
f.prototype._completeKey=function(e,k,E){if(E){for(var i=0;i<e.keys.length;i++){var K=e.keys[i];if(k[K]!==undefined&&k[K]!==null){if(!E[K]){switch(e.keysType[K]){case"Edm.DateTime":E[K]=this._getJsonDate(k[K]);break;case"Edm.Guid":E[K]=k[K].replace(/^guid\'|\'$/g,"");break;default:E[K]=k[K];}}}else{if(!E[K]){E[K]=this._generatePropertyValue(K,e.keysType[K].substring(e.keysType[K].lastIndexOf('.')+1));}}}}};
f.prototype._generateDataFromEntity=function(e,I,c){var E={};if(!e){return E;}for(var i=0;i<e.properties.length;i++){var p=e.properties[i];E[p.name]=this._generatePropertyValue(p.name,p.type,c,I);}return E;};
f.prototype._generateDataFromEntitySet=function(e,E,c){var o=E[e.type];var m=[];for(var i=0;i<100;i++){m.push(this._generateDataFromEntity(o,i+1,c));}return m;};
f.prototype._generateMockdata=function(e,m){var t=this;var o={};var r=this._getRootUri();q.each(e,function(E,a){var b={};b[a.name]=a;o[E]=t._generateODataMockdataForEntitySet(b,m)[E];});q.each(e,function(E,a){for(var n in a.navprops){var N=a.navprops[n];var p=N.from.propRef.length;for(var j=0;j<p;j++){for(var i=0;i<o[E].length;i++){var b=o[E][i];o[N.to.entitySet][i][N.to.propRef[j]]=b[N.from.propRef[j]];}}}q.each(o[E],function(I,c){c.__metadata={uri:r+E+"("+t._createKeysString(a,c)+")",type:a.schema+"."+a.type};q.each(a.navprops,function(k,N){c[k]={__deferred:{uri:r+E+"("+t._createKeysString(a,c)+")/"+k}};});});});this._oMockdata=o;};
f.prototype._generateODataMockdataForEntitySet=function(e,m){var t=this,o={};var E=this._findEntityTypes(m);var c=this._findComplexTypes(m);q.each(e,function(s,a){o[s]=t._generateDataFromEntitySet(a,E,c);});return o;};
f.prototype._resolveNavigation=function(e,F,n){var E=this._mEntitySets[e];var N=E.navprops[n];if(!N){this._logAndThrowMockServerCustomError(404,this._oErrorMessages.RESOURCE_NOT_FOUND);}var a=[];var p=N.from.propRef.length;if(p===0){if(N.to.multiplicity==="*"){return this._oMockdata[N.to.entitySet];}else{a.push(this._oMockdata[N.to.entitySet][0]);return a;}}q.each(this._oMockdata[N.to.entitySet],function(I,t){var b=true;for(var i=0;i<p;i++){if(F[N.from.propRef[i]]!==t[N.to.propRef[i]]){b=false;break;}}if(b){a.push(t);}});return a;};
f.prototype.simulate=function(s,v){var t=this;this._sMetadataString=s;if(!v||typeof v==="string"){this._sMockdataBaseUrl=v;}else{this._sMockdataBaseUrl=v.sMockdataBaseUrl;this._bGenerateMissingMockData=v.bGenerateMissingMockData;this._aEntitySetsNames=v.aEntitySetsNames;}var o=this._loadMetadata(this._sMetadataString);if(!o){return;}if(this._sMetadata){var a=sap.ui.requireSync("sap/ui/core/util/MockServerAnnotationsHandler");var A=a.parse(this._oMetadata,this._sMetadata);var b=sap.ui.requireSync("sap/ui/core/util/DraftEnabledMockServer");b.handleDraft(A,this);}this._refreshData();var h=function(x,m){if(x.requestHeaders["x-csrf-token"]==="Fetch"){m["X-CSRF-Token"]="42424242424242424242424242424242";}};var G=function(e,k){k=decodeURIComponent(k);var F;var E=t._mEntitySets[e];var K=E.keys;var j=k.split(',');if(j.length!==K.length){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_PREDICATE_QUANTITY);}t._isRequestedKeysValid(E,j);if(j.length===1&&!j[0].split('=')[1]){j=[K[0]+"="+j[0]];}q.each(t._oMockdata[e],function(I,l){for(var i=0;i<j.length;i++){var m=j[i].split('=');var n=t._trim(m[0]);if(q.inArray(n,K)===-1){return true;}var N=t._trim(m[1]);var O=l[n];switch(E.keysType[n]){case"Edm.String":N=N.replace(/^\'|\'$/g,'');break;case"Edm.Time":case"Edm.DateTime":O=t._getDateTime(O);break;case"Edm.Int16":case"Edm.Int32":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":if(!t._isValidNumber(N)){return false;}N=parseFloat(N);break;case"Edm.Guid":N=N.replace(/^guid\'|\'$/g,'');break;case"Edm.Boolean":if(["true","false"].indexOf(N)===-1){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_TYPE,n);}N=N==="true";break;case"Edm.Binary":case"Edm.DateTimeOffset":default:N=N;}if(O!==N){return true;}}F={index:I,entry:l};return false;});return F;};var r=function(e,k,u){var S=e.name;var n;if(u){n=e.navprops[u];}if(n){S=n.to.entitySet;}return S;};var H=function(u){var U=[];var S=function(V){var j=V.indexOf("'");var m=V.indexOf("\"");if(j===-1&&m===-1){return null;}else{if(j>-1&&m===-1){return"appost";}if(m>-1&&j===-1){return"doublequotes";}if(j>-1&&m>-1&&j<m){return"appost";}if(j>-1&&m>-1&&m<j){return"doublequotes";}}};var e=function(p,P,m,n){var w=p[m];var j=m+1;while(j<p.length&&p[j].indexOf(n)===-1){w=w+"&"+p[j];j++;}w=w+"&"+p[j];P.push(w);m=j;return m;};for(var i=0;i<u.length;i++){if(!S(u[i])){U.push(u[i]);}if(S(u[i])==="appost"){var k=u[i].indexOf("'");if(u[i].indexOf("'",k+1)===-1){i=e(u,U,i,"'");}else{U.push(u[i]);}}if(S(u[i])==="doublequotes"){var l=u[i].indexOf("\"");if(u[i].indexOf("\"",l+1)===-1){i=e(u,U,i,"\"");}else{U.push(u[i]);}}}return U;};var c=function(x,T,k,u){k=k?decodeURIComponent(k):k;var e=JSON.parse(x.requestBody);if(e){var K={};if(k){K=t._parseKeys(k,t._mEntitySets[T]);}t._completeKey(t._mEntitySets[T],K,e);t._enhanceWithMetadata(t._mEntitySets[T],[e]);return e;}return null;};var R=[];R.push({method:"GET",path:new RegExp("\\$metadata([?#].*)?"),response:function(x){q.sap.require("jquery.sap.xml");q.sap.log.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/xml;charset=utf-8"};h(x,m);x.respond(200,m,t._sMetadata);q.sap.log.debug("MockServer: response sent with: 200, "+t._sMetadata);return true;}});R.push({method:"HEAD",path:new RegExp("$"),response:function(x){q.sap.log.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};h(x,m);x.respond(200,m);q.sap.log.debug("MockServer: response sent with: 200");return true;}});R.push({method:"GET",path:new RegExp("$"),response:function(x){q.sap.log.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};h(x,m);var e=[];q.each(t._mEntitySets,function(E,j){e.push(E);});var i={EntitySets:e};x.respond(200,m,JSON.stringify({d:i}));q.sap.log.debug("MockServer: response sent with: 200, "+JSON.stringify({d:i}));return true;}});R.push({method:"POST",path:new RegExp("\\$batch([?#].*)?"),response:function(x){q.sap.log.debug("MockServer: incoming request for url: "+x.url);var e=function(Z){switch(Z.statusCode){case 200:return"200 OK";case 201:return"201 Created";case 204:return"204 No Content";case 400:return"400 Bad Request";case 401:return"401 Unauthorized";case 403:return"403 Forbidden";case 404:return"404 Not Found";case 405:return"405 Method Not Allowed";case 409:return"409 Conflict";case 412:return"412 Precondition Failed";case 415:return"415 Unsupported Media Type";case 500:return"500 Internal Server Error";case 501:return"501 Not Implemented";case 503:return"503 Service Unavailable";default:return Z.statusCode+" "+Z.status;}};var B=function(Z,$){var _;if(Z.success){_=JSON.stringify(Z.data)||"";}else{_=Z.errorResponse;}$=$||"application/json";if(Z.responseHeaders){return"HTTP/1.1 "+e(Z)+"\r\n"+Z.responseHeaders+"dataserviceversion: 2.0\r\n\r\n"+_+"\r\n";}else{return"HTTP/1.1 "+e(Z)+"\r\nContent-Type: "+$+"\r\nContent-Length: "+_.length+"\r\ndataserviceversion: 2.0\r\n\r\n"+_+"\r\n";}};var C=function(Z,T,$,N){var _;var a1=function(c1,d1,e1){_={success:true,data:c1,status:d1,statusCode:e1&&e1.status,responseHeaders:e1&&e1.getAllResponseHeaders()};};var b1=function(c1,d1,e1){_={success:false,data:undefined,status:d1,error:e1,statusCode:c1.status,errorResponse:c1.responseText,responseHeaders:c1&&c1.getAllResponseHeaders()};};q.ajax({type:$,async:false,url:Z,data:T,dataType:"json",success:a1,error:b1});if(_.statusCode===400||_.statusCode===404){var W=B(_);throw new Error(W);}N.push(B(_));};var l=function(Z,w){var $;var _;var a1=function(c1,d1,e1){$={success:true,data:c1,status:d1,statusCode:e1&&e1.status,responseHeaders:e1&&e1.getAllResponseHeaders()};};var b1=function(c1,d1,e1){$={success:false,data:undefined,status:d1,error:e1,statusCode:c1.status,errorResponse:c1.responseText,responseHeaders:c1&&c1.getAllResponseHeaders()};};q.ajax({async:false,url:Z,dataType:"json",success:a1,error:b1});var _;if(Z.indexOf('$count')!==-1){_=B($,"text/plain");}else{_=B($);}w.push("\r\nContent-Type: application/http\r\n"+"Content-Length: "+_.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+_);};var n=x.requestBody;var p=new RegExp("--batch_[a-z0-9-]*");var u=p.exec(n)[0];if(!!u){var w=[];var y=n.split(u);var S=x.url.split("$")[0];var z=new RegExp("PUT (.*) HTTP");var E=new RegExp("MERGE (.*) HTTP");var F=new RegExp("POST (.*) HTTP");var I=new RegExp("DELETE (.*) HTTP");var J=new RegExp("GET (.*) HTTP");for(var i=1;i<y.length-1;i++){var K=y[i];if(J.test(K)&&K.indexOf("multipart/mixed")===-1){if(z.test(K)||F.test(K)||I.test(K)){x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");q.sap.log.debug("MockServer: response sent with: 400");return true;}l(S+J.exec(K)[1],w);}else{var L=q.extend(true,{},t._oMockdata);var N=[];var O=K.substring(K.indexOf("boundary=")+9,K.indexOf("\r\n\r\n"));var P=K.split("--"+O);try{for(var j=1;j<P.length-1;j++){var Q=P[j];var T;if(J.test(Q)){t._oMockdata=L;x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");q.sap.log.debug("MockServer: response sent with: 400");return;}else if(z.test(Q)){T=Q.substring(Q.indexOf("{"),Q.lastIndexOf("}")+1);C(S+z.exec(Q)[1],T,'PUT',N);}else if(E.test(Q)){T=Q.substring(Q.indexOf("{"),Q.lastIndexOf("}")+1);C(S+E.exec(Q)[1],T,'MERGE',N);}else if(F.test(Q)){T=Q.substring(Q.indexOf("{"),Q.lastIndexOf("}")+1);C(S+F.exec(Q)[1],T,'POST',N);}else if(I.test(Q)){C(S+I.exec(Q)[1],T,'DELETE',N);}}var U="\r\nContent-Type: multipart/mixed; boundary=ejjeeffe1\r\n\r\n--ejjeeffe1";for(var k=0;k<N.length;k++){U+="\r\nContent-Type: application/http\r\n"+"Content-Length: "+N[k].length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+N[k]+"--ejjeeffe1";}U+="--\r\n";w.push(U);}catch(V){t._oMockdata=L;var W="\r\nContent-Type: application/http\r\n"+"Content-Length: "+V.message.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+V.message;w.push(W);}}}var X="--ejjeeffe0";for(var m=0;m<w.length;m++){X+=w[m]+"--ejjeeffe0";}X+="--";var Y={'Content-Type':"multipart/mixed; boundary=ejjeeffe0"};h(x,Y);x.respond(202,Y,X);q.sap.log.debug("MockServer: response sent with: 202, "+X);}else{x.respond(202);}return true;}});q.each(this._mEntitySets,function(E,i){R.push({method:"GET",path:new RegExp("("+E+")/\\$count/?(.*)?"),response:function(x,E,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};h(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,""+F.results.length);q.sap.log.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{q.sap.log.error("MockServer: request failed due to invalid system query options value!");x.respond(parseInt(e.message||e.number,10));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")/?(\\?(.*))?"),response:function(x,E,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};h(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));q.sap.log.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));x.respond(parseInt(e.message||e.number,10));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(\\?(.*))?"),response:function(x,E,k,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};try{var j=q.extend(true,{},G(E,k));if(!q.isEmptyObject(j)){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){j.entry=t._applyQueryOnEntry(j.entry,Q,E);});}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oEntry:j.entry});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oEntry:j.entry});x.respond(200,m,JSON.stringify({d:j.entry}));q.sap.log.debug("MockServer: response sent with: 200, "+JSON.stringify({d:j.entry}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));x.respond(parseInt(e.message||e.number,10));}}return true;}});q.each(i.navprops,function(n,N){R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/\\$count/?(.*)?"),response:function(x,E,k,j,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};h(x,m);try{var l=G(E,k);if(l){var p,F={};p=t._resolveNavigation(E,l.entry,j);var w=t._mEntitySets[E].navprops[j].to.multiplicity;if(w==="*"){F={results:q.extend(true,[],p)};}else{F=q.extend(true,{},p[0]);}if(p&&p.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}if(w==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});F.results=F.results||[];x.respond(200,m,""+F.results.length);q.sap.log.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));x.respond(parseInt(e.message||e.number,10));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/?(\\?(.*))?"),response:function(x,E,k,j,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};h(x,m);try{var l=G(E,k);if(l){var p,F={};p=t._resolveNavigation(E,l.entry,j,l.entry);var w=t._mEntitySets[E].navprops[j].to.multiplicity;if(w==="*"){F={results:q.extend(true,[],p)};}else{F=q.extend(true,{},p[0]);}if(p&&p.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}if(w==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));q.sap.log.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});});R.push({method:"POST",path:new RegExp("("+E+")(\\(([^/\\?#]+)\\)/?(.*)?)?"),response:function(x,E,j,k,n){var m=false;if(x.requestHeaders["x-http-method"]==="MERGE"){m=true;}q.sap.log.debug("MockServer: incoming create request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.POST+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(f.HTTPMETHOD.POST+":before",{oXhr:x,sKeys:k,sNavName:n});var l=null;var p=null;var u=405;try{if(k&&!k.split('=')[1]){k=t._mEntitySets[E].keys[0]+"="+k;}var T=r(i,decodeURIComponent(k),n);if(T){var w=c(x,T,k,n);if(w){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(f.HTTPMETHOD.POST+E+":after",{oXhr:x,oEntity:w});t.fireEvent(f.HTTPMETHOD.POST+":after",{oXhr:x,oEntity:w});if(m){var y=G(E,k);if(y){q.extend(t._oMockdata[E][y.index],w);}u=204;}else{var U=t._getRootUri()+T+"("+t._createKeysString(t._mEntitySets[T],w)+")";l=JSON.stringify({d:w,uri:U});t._oMockdata[T]=t._oMockdata[T].concat([w]);u=201;}}}x.respond(u,p,l);q.sap.log.debug("MockServer: response sent with: "+u+", "+l);}catch(e){if(e.error){var z={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,z,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});R.push({method:"PUT",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){q.sap.log.debug("MockServer: incoming update request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.PUT+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(f.HTTPMETHOD.PUT+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var l=null;var m=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var p=c(x,T,k,n);if(p){m={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(f.HTTPMETHOD.PUT+E+":after",{oXhr:x,oEntity:p});t.fireEvent(f.HTTPMETHOD.PUT+":after",{oXhr:x,oEntity:p});var u=G(E,k);if(u){t._oMockdata[E][u.index]=p;}j=204;}}x.respond(j,m,l);q.sap.log.debug("MockServer: response sent with: "+j+", "+l);}catch(e){if(e.error){var w={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,w,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});R.push({method:"MERGE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){q.sap.log.debug("MockServer: incoming merge update request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.MERGE+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(f.HTTPMETHOD.MERGE+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var l=null;var m=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var p=c(x,T,k,n);if(p){m={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(f.HTTPMETHOD.MERGE+E+":after",{oXhr:x,oEntity:p});t.fireEvent(f.HTTPMETHOD.MERGE+":after",{oXhr:x,oEntity:p});var u=G(E,k);if(u){q.extend(t._oMockdata[E][u.index],p);}j=204;}}x.respond(j,m,l);q.sap.log.debug("MockServer: response sent with: "+j+", "+l);}catch(e){if(e.error){var w={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,w,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});R.push({method:"PATCH",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){q.sap.log.debug("MockServer: incoming patch update request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.PATCH+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(f.HTTPMETHOD.PATCH+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var l=null;var m=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var p=c(x,T,k,n);if(p){m={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(f.HTTPMETHOD.PATCH+E+":after",{oXhr:x,oEntity:p});t.fireEvent(f.HTTPMETHOD.PATCH+":after",{oXhr:x,oEntity:p});var u=G(E,k);if(u){q.extend(t._oMockdata[E][u.index],p);}j=204;}}x.respond(j,m,l);q.sap.log.debug("MockServer: response sent with: "+j+", "+l);}catch(e){if(e.error){var w={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,w,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});R.push({method:"DELETE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,u){q.sap.log.debug("MockServer: incoming delete request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.DELETE+E+":before",{oXhr:x});t.fireEvent(f.HTTPMETHOD.DELETE+":before",{oXhr:x});var j=204;try{var l=G(E,k);if(l){t._oMockdata[E].splice(l.index,1);}else{j=400;}t.fireEvent(f.HTTPMETHOD.DELETE+E+":after",{oXhr:x});t.fireEvent(f.HTTPMETHOD.DELETE+":after",{oXhr:x});x.respond(j,null,null);q.sap.log.debug("MockServer: response sent with: "+j);}catch(e){if(e.error){var m={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,m,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});});this.setRequests(R);};
f.prototype._orderQueryOptions=function(u){var F,i,s,t,o,S,e,a,b,c,O=[];var h=this;q.each(u,function(I,Q){switch(Q.split('=')[0]){case"$top":t=q.inArray(Q,u);break;case"$skip":s=q.inArray(Q,u);break;case"$orderby":o=q.inArray(Q,u);break;case"$expand":e=q.inArray(Q,u);break;case"$filter":F=q.inArray(Q,u);break;case"$select":S=q.inArray(Q,u);break;case"$inlinecount":i=q.inArray(Q,u);break;case"$format":a=q.inArray(Q,u);break;case"search-focus":c=q.inArray(Q,u);break;case"search":b=q.inArray(Q,u);break;default:if(Q.split('=')[0].indexOf('$')===0){h._logAndThrowMockServerCustomError(400,h._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,Q.split('=')[0]);}}});if(e>=0){O.push(u[e]);}if(F>=0){O.push(u[F]);}if(c>=0){O.push(u[c]);}if(b>=0){O.push(u[b]);}if(i>=0){O.push(u[i]);}if(o>=0){O.push(u[o]);}if(s>=0){O.push(u[s]);}if(t>=0){O.push(u[t]);}if(S>=0){O.push(u[S]);}if(a>=0){O.push(u[a]);}return O;};
f.prototype._removeAllRequestHandlers=function(){var r=this.getRequests();var l=r.length;for(var i=0;i<l;i++){f._removeResponse(r[i].response);}};
f.prototype._removeAllFilters=function(){for(var i=0;i<this._aFilters.length;i++){f._removeFilter(this._aFilters[i]);}this._aFilters=null;};
f.prototype._addRequestHandler=function(m,p,r){m=m?m.toUpperCase():m;if(typeof m!=="string"){throw new Error("Error in request configuration: value of 'method' has to be a string");}if(!(typeof p==="string"||p instanceof RegExp)){throw new Error("Error in request configuration: value of 'path' has to be a string or a regular expression");}if(typeof r!=="function"){throw new Error("Error in request configuration: value of 'response' has to be a function");}var u=this._getRootUri();u=u&&new RegExp(this._escapeStringForRegExp(u));if(p&&!(p instanceof RegExp)){p=new RegExp(this._createRegExpPattern(p));}var R=this._createRegExp(u?u.source+p.source:p.source);this._addFilter(this._createFilter(m,R));this._oServer.respondWith(m,R,r);q.sap.log.debug("MockServer: adding "+m+" request handler for pattern "+R);};
f.prototype._createRegExp=function(p){return new RegExp("^"+p+"$");};
f.prototype._createRegExpPattern=function(p){return p.replace(/:([\w\d]+)/g,"([^\/]+)");};
f.prototype._escapeStringForRegExp=function(s){return s.replace(/[\\\/\[\]\{\}\(\)\-\*\+\?\.\^\$\|]/g,"\\$&");};
f.prototype._trim=function(s){return s&&s.replace(/^\s+|\s+$/g,"");};
f.prototype._isValidNumber=function(s){return!isNaN(parseFloat(s))&&isFinite(s);};
f.prototype._getDateTime=function(s){if(!s){return;}return"datetime'"+new Date(Number(s.replace("/Date(",'').replace(")/",''))).toJSON().substring(0,19)+"'";};
f.prototype._getJsonDate=function(S){if(!S){return;}var n=function(s){var a=q.map(s.slice(0,-5).split(/\D/),function(i){return parseInt(i,10)||0;});a[1]-=1;a=new Date(Date.UTC.apply(Date,a));var o=s.slice(-5);var b=parseInt(o,10)/100;if(o.slice(0,1)==="+"){b*=-1;}a.setHours(a.getHours()+b);return a.getTime();};if(S.indexOf("datetimeoffset")>-1){return"/Date("+n(S.substring("datetimeoffset'".length,S.length-1))+")/";}else{return"/Date("+n(S.substring("datetime'".length,S.length-1))+")/";}};
f.prototype._addFilter=function(F){this._aFilters.push(F);f._addFilter(F);};
f.prototype._createFilter=function(r,R){return function(m,u,a,U,p){return r===m&&R.test(u);};};
f.prototype._logAndThrowMockServerCustomError=function(e,E,p){if(E.indexOf('##')>-1&&p){E=E.replace("##","'"+p+"'");}q.sap.log.error("MockServer: "+E);throw{error:{code:e,message:{lang:"en",value:E}}};};
f.prototype.destroy=function(s){M.prototype.destroy.apply(this,arguments);this.stop();var S=f._aServers;var i=q.inArray(this,S);S.splice(i,1);};
f._aFilters=[];f._oServer=null;f._aServers=[];
f._getInstance=function(){if(!this._oServer){this._oServer=window.sinon.fakeServer.create();this._oServer.autoRespond=true;}return this._oServer;};
f.config=function(c){var s=this._getInstance();s.autoRespond=c.autoRespond===false?false:true;s.autoRespondAfter=c.autoRespondAfter||0;s.fakeHTTPMethods=c.fakeHTTPMethods||false;};
f.respond=function(){this._getInstance().respond();};
f.startAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].start();}};
f.stopAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].stop();}this._getInstance().restore();this._oServer=null;};
f.destroyAll=function(){this.stopAll();for(var i=0;i<this._aServers.length;i++){this._aServers[i].destroy();}};
f.HTTPMETHOD={GET:"GET",POST:"POST",DELETE:"DELETE",PUT:"PUT",MERGE:"MERGE",PATCH:"PATCH"};
f._addFilter=function(F){this._aFilters.push(F);};
f._removeFilter=function(F){var i=q.inArray(F,this._aFilters);if(i!==-1){this._aFilters.splice(i,1);}return i!==-1;};
f._removeResponse=function(r){var R=this._oServer.responses;var l=R.length;for(var i=0;i<l;i++){if(R[i].response===r){R.splice(i,1);return true;}}return false;};
window.sinon.FakeXMLHttpRequest.useFilters=true;window.sinon.xhr.supportsCORS=q.support.cors;window.sinon.FakeXMLHttpRequest.addFilter(function(m,u,a,U,p){var F=f._aFilters;for(var i=0;i<F.length;i++){var b=F[i];if(b(m,u,a,U,p)){return false;}}return true;});var g=function(F){if(/.*\.json$/i.test(F)){return"JSON";}if(/.*\.xml$/i.test(F)){return"XML";}if(/.*metadata$/i.test(F)){return"XML";}return null;};
window.sinon.FakeXMLHttpRequest.prototype.respondFile=function(s,h,F){var r=q.sap.sjax({url:F,dataType:"text"});if(!r.success){throw new Error("Could not load file from: "+F);}var o=r.data;var m=g(F);if(this["respond"+m]){this["respond"+m](s,h,o);}else{this.respond(s,h,o);}};
window.sinon.FakeXMLHttpRequest.prototype.respondJSON=function(s,h,j){h=h||{};h["Content-Type"]=h["Content-Type"]||"application/json";this.respond(s,h,typeof j==="string"?j:JSON.stringify(j));};
window.sinon.FakeXMLHttpRequest.prototype.respondXML=function(s,h,x){h=h||{};h["Content-Type"]=h["Content-Type"]||"application/xml";this.respond(s,h,x);};
return f;});
sap.ui.predefine('sap/ui/core/util/MockServerAnnotationsHandler',['sap/ui/core/util/MockServer','sap/ui/model/odata/ODataModel','jquery.sap.xml'],function(M,O){"use strict";return{parse:function(m,s){if(!this._index){this._index=0;}var u="/annotationhandler"+this._index++ +"/";var o=new M({rootUri:u,requests:[{method:"GET",path:new RegExp("\\$metadata"),response:function(x){x.respond(200,{"Content-Type":"application/xml;charset=utf-8"},s);}}]});o.start();var a={annotationURI:[u+"$metadata"],json:true};var b=new O(u,a);var A=b.getServiceAnnotations();o.destroy();return A;}};},true);
sap.ui.predefine('sap/ui/core/util/XMLPreprocessor',['jquery.sap.global','sap/ui/base/BindingParser','sap/ui/base/ManagedObject','sap/ui/core/XMLTemplateProcessor','sap/ui/model/BindingMode','sap/ui/model/CompositeBinding','sap/ui/model/Context'],function(q,B,M,X,a,C,b){'use strict';var u={},N="http://schemas.sap.com/sapui5/extension/sap.ui.core.template/1",x="sap.ui.core.util.XMLPreprocessor",p=[x],P=x+"/insertFragment",s=x+"/getResolvedBinding",c=x+".process",t=Object.prototype.toString,v={},W=M.extend("sap.ui.core.util._with",{metadata:{properties:{any:"any"},aggregations:{child:{multiple:false,type:"sap.ui.core.util._with"}}}}),R=W.extend("sap.ui.core.util._repeat",{metadata:{aggregations:{list:{multiple:true,type:"n/a",_doesNotRequireFactory:true}}},updateList:function(){}});
function d(w,S,i,j){function k(m){if(!j){j=w.getBinding("any");if(j instanceof C){j=j.getBindings();if(i!==undefined){j=j[i];}}}return Array.isArray(j)?j[m]:j;}function l(o){return o instanceof b?o.getPath():o.getModel().resolve(o.getPath(),o.getContext());}return{getInterface:function(m,n){var o,y,z;if(typeof m==="string"){n=m;m=undefined;}k();if(Array.isArray(j)){if(m>=0&&m<j.length){y=j[m];}else{throw new Error("Invalid index of part: "+m);}}else if(m!==undefined){throw new Error("Not the root formatter of a composite binding");}else if(n){y=j;}else{throw new Error("Missing path");}if(n){z=y.getModel();if(n.charAt(0)!=='/'){o=y instanceof b?y:z.createBindingContext(y.getPath(),y.getContext());}y=z.createBindingContext(n,o);if(!y){throw new Error("Model could not create binding context synchronously: "+z);}}return d(null,S,undefined,y);},getModel:function(m){var o=k(m);return o&&o.getModel();},getPath:function(m){var o=k(m);return o&&l(o);},getSetting:function(n){if(n==="bindingContexts"||n==="models"){throw new Error("Illegal argument: "+n);}return S[n];}};}
function g(w,o,S,j){function k(I,i){var F=I.formatter;I.mode=a.OneTime;if(F&&F.requiresIContext===true){I.formatter=F.bind(null,d(w,S,i));}I.parameters=I.parameters||{};I.parameters.scope=j;}try{k(o);if(o.parts){o.parts.forEach(k);}w.bindProperty("any",o);return w.getBinding("any")?w.getAny():u;}finally{w.unbindProperty("any",true);}}
function e(E,l){return E.namespaceURI===N&&E.localName===l;}
function r(E){var m=E.getAttribute("template:require");if(m){q.sap.require.apply(q.sap,m.split(" "));}}
function f(E){var A,o=E.attributes,T="<"+E.nodeName,i,n;for(i=0,n=o.length;i<n;i+=1){A=o.item(i);T+=" "+A.name+'="'+A.value+'"';}return T+(E.childNodes.length?">":"/>");}
function h(E,i){i.visitNode(E);}
return{plugIn:function(V,n,l){var o=v[n];if(V!==null&&typeof V!=="function"||V===h){throw new Error("Invalid visitor: "+V);}if(!n||n===N||n==="sap.ui.core"||n.indexOf(" ")>=0){throw new Error("Invalid namespace: "+n);}q.sap.log.debug("Plug-in visitor for namespace '"+n+"', local name '"+l+"'",V,x);if(l){n=n+" "+l;o=v[n]||o;}v[n]=V;return o||h;},visitNodeWrapper:h,process:function(o,V,S){var j=V.caller,D=q.sap.log.isLoggable(q.sap.log.Level.DEBUG,x),k=D,l=V.name,F={},m,w=0,y={},z=V._supportInfo,A=q.sap.log.isLoggable(q.sap.log.Level.WARNING,x);function E(i){return{getContext:function(n){var i1,j1,k1;n=n||"";if(n[0]==="{"){throw new Error("Must be a simple path, not a binding: "+n);}i1=B.simpleParser("{"+n+"}");j1=i.getModel(i1.model);if(!j1){throw new Error("Unknown model '"+i1.model+"': "+n);}k1=j1.resolve(i1.path,i.getBindingContext(i1.model));if(!k1){throw new Error("Cannot resolve path: "+n);}return j1.createBindingContext(k1);},getResult:function(n,i1){var j1=O(n,i1,i,true);if(j1===u){throw new Error("Binding not ready: "+n);}return j1;},getSettings:function(){return S;},getViewInfo:function(){return q.extend(true,{},V);},insertFragment:function(n,i1){Q(n,i1,i);},visitAttribute:function(n,i1){d1(n,i1,i);},visitAttributes:function(n){e1(n,i);},visitChildNodes:function(n){f1(n,i);},visitNode:function(n){g1(n,i);},"with":function(n,i1){var j1,k1=false,m,l1=new W();if(!i1){i.setChild(l1);}for(m in n){j1=n[m];k1=true;l1.setModel(j1.getModel(),m);l1.bindObject({model:m,path:j1.getPath()});}return k1||i1?E(l1):this;}};}function G(i){if(D){q.sap.log.debug(K()+Array.prototype.slice.call(arguments,1).join(" "),i&&f(i),x);}}function H(i){if(D){q.sap.log.debug(K()+"Finished","</"+i.nodeName+">",x);}}function I(i,n){i=i+f(n);q.sap.log.error(i,j,x);throw new Error(j+": "+i);}function J(i1){var j1=i1.childNodes,k1,l1=[],i,n,m1=false;for(i=0,n=j1.length;i<n;i+=1){k1=j1.item(i);if(k1.nodeType===1){l1.push(k1);}}if(!l1.length||!e(l1[0],"then")){return null;}for(i=1,n=l1.length;i<n;i+=1){k1=l1[i];if(m1){I("Expected </"+i1.prefix+":if>, but instead saw ",k1);}if(e(k1,"else")){m1=true;}else if(!e(k1,"elseif")){I("Expected <"+i1.prefix+":elseif> or <"+i1.prefix+":else>, but instead saw ",l1[i]);}}return l1;}function K(){return(w<10?"[ ":"[")+w+"] ";}function L(m){return m&&m.charAt(0)==="."?q.sap.getObject(m.slice(1),undefined,y):q.sap.getObject(m);}function O(i,n,i1,j1,k1){var l1;q.sap.measure.average(s,"",p);l1=B.complexParser(i,y,j1,true,true)||i;if(l1.functionsNotFound){if(j1){h1(n,'Function name(s)',l1.functionsNotFound.join(", "),'not found');}q.sap.measure.end(s);return u;}if(typeof l1==="object"){l1=g(i1,l1,S,y);if(j1&&l1===u){h1(n,'Binding not ready');}}else if(k1){k1();}q.sap.measure.end(s);return l1;}function Q(i,n,i1){var j1,k1=l;i1.$mFragmentContexts=i1.$mFragmentContexts||{};if(i1.$mFragmentContexts[i]){I("Cyclic reference to fragment '"+i+"' ",n);}w++;G(n,"fragmentName =",i);i1.$mFragmentContexts[i]=true;l=i;q.sap.measure.average(P,"",p);j1=F[i];if(!j1){j1=X.loadTemplate(i,"fragment");F[i]=j1;}j1=n.ownerDocument.importNode(j1,true);q.sap.measure.end(P);r(j1);if(j1.namespaceURI==="sap.ui.core"&&j1.localName==="FragmentDefinition"){T(j1,i1,n);}else{n.parentNode.insertBefore(j1,n);g1(j1,i1);}n.parentNode.removeChild(n);l=k1;i1.$mFragmentContexts[i]=false;H(n);w--;}function T(i,n,i1){var j1;i1=i1||i;f1(i,n);while((j1=i.firstChild)){i1.parentNode.insertBefore(j1,i1);}}function U(i,n){var i1=h1.bind(null,i,'Constant test condition'),j1,k1=i.getAttribute("test"),l1;try{l1=O(k1,i,n,true,i1);if(l1===u){l1=false;}}catch(ex){h1(i,'Error in formatter:',ex);l1=undefined;}j1=!!l1&&l1!=="false";if(D){if(typeof l1==="string"){l1=JSON.stringify(l1);}else if(l1===undefined){l1="undefined";}else if(Array.isArray(l1)){l1="[object Array]";}G(i,"test ==",l1,"-->",j1);}return j1;}function Y(i,n,i1){var j1=n.value,k1;try{k1=O(j1,i,i1,false);if(k1===u){G(i,'Binding not ready for attribute',n.name);}else if(k1===undefined){G(i,"Removed attribute",n.name);i.removeAttribute(n.name);}else if(k1!==n.value){switch(typeof k1){case"boolean":case"number":case"string":G(i,n.name,"=",k1);n.value=k1;break;default:G(i,"Ignoring",t.call(k1),"value for attribute",n.name);}}}catch(ex){G(i,"Error in formatter of attribute",n.name,ex);}}function Z(i,n){var m=i.getAttribute("name"),i1,j1,k1=i.getAttribute("value");if(!m||m.length<=1||m.lastIndexOf(".")!==0){I("Missing proper relative name in ",i);}m=m.slice(1);i1=L(k1);if(!i1){I("Invalid value in ",i);}j1=y[m];y[m]=i1;T(i,n);i.parentNode.removeChild(i);y[m]=j1;}function $(i,n){var m=i.getAttribute("name"),i1=u,j1;try{i1=O(m,i,n,true);if(i1!==u&&i1!==m){G(i,"name =",i1);}}catch(ex){h1(i,'Error in formatter:',ex);}var l1=sap.ui.require("sap/ui/core/CustomizingConfiguration");if(i1!==u&&l1){j1=l1.getViewExtension(l,i1,V.componentId);if(j1&&j1.className==="sap.ui.core.Fragment"&&j1.type==="XML"){Q(j1.fragmentName,i,n);return true;}}return false;}function _(i,n){var i1=i.getAttribute("fragmentName"),j1;try{j1=O(i1,i,n,true);}catch(ex){h1(i,'Error in formatter:',ex);return;}if(j1!==u){Q(j1,i,n);}}function a1(i,n){var i1=J(i),j1,k1;w++;if(i1){k1=i;j1=i1.shift();do{if(U(k1,n)){break;}k1=j1=i1.shift();}while(k1&&k1.localName==="elseif");}else if(U(i,n)){j1=i;}if(j1){T(j1,n,i);}i.parentNode.removeChild(i);H(i);w--;}function b1(n,i1){var j1=n.getAttribute("list")||"",k1=B.complexParser(j1,y,false,true,true),l1,m1,n1,o1,p1=n.getAttribute("var");if(p1===""){I("Missing variable name for ",n);}if(!k1){I("Missing binding for ",n);}if(k1.functionsNotFound){h1(n,'Function name(s)',k1.functionsNotFound.join(", "),'not found');}o1=new R();i1.setChild(o1);k1.mode=a.OneTime;o1.bindAggregation("list",k1);m1=o1.getBinding("list");o1.unbindAggregation("list",true);n1=k1.model;if(!m1){I("Missing model '"+n1+"' in ",n);}l1=m1.getContexts(k1.startIndex,k1.length);p1=p1||n1;o1.setModel(m1.getModel(),p1);w++;G(n,"Starting");l1.forEach(function(q1,i){var r1=(i===l1.length-1)?n:n.cloneNode(true);o1.setBindingContext(q1,p1);G(n,p1,"=",q1.getPath());T(r1,o1,n);});H(n);w--;n.parentNode.removeChild(n);}function c1(i,n){var i1,j1,k1,l1,m1=i.getAttribute("helper"),n1,o1=i.getAttribute("path"),p1,q1=i.getAttribute("var");if(q1===""){I("Missing variable name for ",i);}k1=new W();n.setChild(k1);i1=B.simpleParser("{"+o1+"}");q1=q1||i1.model;if(m1||q1){j1=n.getModel(i1.model);if(!j1){I("Missing model '"+i1.model+"' in ",i);}p1=j1.resolve(i1.path,n.getBindingContext(i1.model));if(!p1){I("Cannot resolve path for ",i);}n1=j1.createBindingContext(p1);if(m1){l1=L(m1);if(typeof l1!=="function"){I("Cannot resolve helper for ",i);}n1=l1(n1);}if(n1 instanceof b){j1=n1.getModel();p1=n1.getPath();}else if(n1!==undefined){if(typeof n1!=="string"||n1===""){I("Illegal helper result '"+n1+"' in ",i);}p1=n1;}k1.setModel(j1,q1);k1.bindObject({model:q1,path:p1});}else{k1.bindObject(o1);}w++;G(i,q1,"=",p1);if(k1.getBindingContext(q1)===n.getBindingContext(q1)){h1(i,'Set unchanged path:',p1);k1=n;}T(i,k1);i.parentNode.removeChild(i);H(i);w--;}function d1(i,n,i1){if(z){z({context:undefined,env:{caller:"visitAttribute",before:{name:n.name,value:n.value}}});}Y(i,n,i1);if(z){z({context:undefined,env:{caller:"visitAttribute",after:{name:n.name,value:n.value}}});}}function e1(n,i1){var i,j1=n.attributes;for(i=j1.length-1;i>=0;i-=1){d1(n,j1.item(i),i1);}}function f1(i1,j1){var i,k1=i1.childNodes,n=k1.length,l1=new Array(n);for(i=0;i<n;i+=1){l1[i]=k1.item(i);}k1=null;for(i=0;i<n;i+=1){g1(l1[i],j1);}}function g1(n,i){var i1,j1;if(n.nodeType!==1){return;}if(z){z({context:n,env:{caller:"visitNode",before:{name:n.tagName}}});}if(n.namespaceURI===N){switch(n.localName){case"alias":Z(n,i);return;case"if":a1(n,i);return;case"repeat":b1(n,i);return;case"with":c1(n,i);return;default:I("Unexpected tag ",n);}}else if(n.namespaceURI==="sap.ui.core"){switch(n.localName){case"ExtensionPoint":if($(n,i)){return;}break;case"Fragment":if(n.getAttribute("type")==="XML"){_(n,i);return;}break;}}else{i1=v[n.namespaceURI+" "+n.localName]||v[n.namespaceURI];if(i1){w++;G(n,"Calling visitor");j1=i1(n,E(i));if(j1!==undefined){I("Unexpected return value from visitor for ",n);}H(n);w--;return;}}e1(n,i);f1(n,i);if(z){z({context:n,env:{caller:"visitNode",after:{name:n.tagName}}});}}function h1(i){if(A){if(!k){k=true;q.sap.log.warning("Warning(s) during processing of "+j,null,x);}q.sap.log.warning(K()+Array.prototype.slice.call(arguments,1).join(" "),i&&f(i),x);}}q.sap.measure.average(c,"",p);S=S||{};if(D){G(undefined,"Start processing",j);if(S.bindingContexts instanceof b){G(undefined,"undefined =",S.bindingContexts);}else{for(m in S.bindingContexts){G(undefined,m,"=",S.bindingContexts[m]);}}}if(z){z({context:o,env:{caller:"view",viewinfo:q.extend(true,{},V),settings:q.extend(true,{},S),clone:o.cloneNode(true),type:"template"}});}r(o);g1(o,new W({models:S.models,bindingContexts:S.bindingContexts}));G(undefined,"Finished processing",j);q.sap.measure.end(c);return o;}};},true);
sap.ui.predefine('sap/ui/core/util/reflection/BaseTreeModifier',["sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectMetadata","jquery.sap.global","jquery.sap.xml"],function(M,a,q){"use strict";return{bySelector:function(s,A,v){var c=this.getControlIdBySelector(s,A);return this._byId(c,v);},getControlIdBySelector:function(s,A){if(!s){return undefined;}if(typeof s==="string"){s={id:s};}var c=s.id;if(s.idIsLocal){if(A){c=A.createId(c);}else{throw new Error("App Component instance needed to get a control's ID from selector");}}else{var p=/^application-[^-]*-[^-]*-component---/igm;var h=!!p.exec(s.id);if(h){c=c.replace(/^application-[^-]*-[^-]*-component---/g,"");if(A){c=A.createId(c);}else{throw new Error("App Component instance needed to get a control's ID from selector");}}}return c;},getSelector:function(c,A,m){var C=c;if(c instanceof M){C=c.getId();}else if(!A){throw new Error("App Component instance needed to get a selector from string ID");}if(m&&(m.id||m.idIsLocal)){throw new Error("A selector of control with the ID '"+C+"' was requested, "+"but core properties were overwritten by the additionally passed information.");}var v=this.checkControlId(c,A);if(!v){throw new Error("Generated ID attribute found - to offer flexibility a stable control ID is needed to assign the changes to, but for this control the ID was generated by SAPUI5 "+C);}var s=q.extend(m||{},{id:"",idIsLocal:false},true);if(this.hasLocalIdSuffix(c,A)){var l=A.getLocalId(C);s.id=l;s.idIsLocal=true;}else{s.id=C;}return s;},checkControlId:function(c,A,s){var C=c instanceof M?c.getId():c;var i=a.isGeneratedId(C);if(!i||this.hasLocalIdSuffix(c,A)){return true;}else{var h=C.indexOf("--")!==-1;if(!s&&!h&&this._fnCheckElementIsNoClone(c)){q.sap.log.warning("Generated id attribute found, to offer flexibility a stable control id is needed "+"to assign the changes to, but for this control the id was generated by SAPUI5",C);}return false;}},hasLocalIdSuffix:function(c,A){var C=(c instanceof M)?c.getId():c;if(!A){q.sap.log.error("determination of a local id suffix failed due to missing app component for "+C);return false;}return!!A.getLocalId(C);},_fnCheckElementIsNoClone:function(e){var E=true;if(e.getBindingContext&&e.getBindingContext()){var b=e.getBindingContext().getPath().split("/");var l=b[b.length-1];E=isNaN(l);}return E;},_checkAndPrefixIdsInFragment:function(f,I){var p=q.sap.getParseError(f);if(p.errorCode!==0){throw new Error(f.parseError.reason);}var c=f.documentElement;var r=[],C=[];if(c.localName==="FragmentDefinition"){r=this._getElementNodeChildren(c);}else{r=[c];}C=[].concat(r);function o(b){C.push(b);}for(var i=0,n=r.length;i<n;i++){this._traverseXmlTree(o,r[i]);}for(var j=0,m=C.length;j<m;j++){if(C[j].getAttribute("id")){C[j].setAttribute("id",I+"."+C[j].getAttribute("id"));}else{throw new Error("At least one control does not have a stable ID");}}return c;},_getElementNodeChildren:function(N){var c=[];var b=N.childNodes;for(var i=0,n=b.length;i<n;i++){if(b[i].nodeType===1){c.push(b[i]);}}return c;},_isInstanceOf:function(e,t){var i=q.sap.getObject(t);if(typeof i==="function"){return e instanceof i;}else{return false;}},_hasInterface:function(e,i){var I=e.getMetadata().getInterfaces();return I.indexOf(i)!==-1;},_getControlMetadataInXml:function(c){var C=this._getControlTypeInXml(c);q.sap.require(C);var b=q.sap.getObject(C);return b.getMetadata();},_getControlTypeInXml:function(c){var C=c.namespaceURI;C=C?C+".":"";C+=c.localName;return C;},_traverseXmlTree:function(c,r){function b(p,C,i){var A;if(!i){var m=this._getControlMetadataInXml(C);A=m.getAllAggregations();}var d=this._getElementNodeChildren(C);d.forEach(function(o){var I=A&&A[o.localName];b.call(this,C,o,I);if(!I){c(o);}}.bind(this));}b.call(this,r,r,false);},setVisible:function(c,v){},getVisible:function(c){},setStashed:function(c,s){},getStashed:function(c){},bindProperty:function(c,p,b){},unbindProperty:function(c,p){},setProperty:function(c,p,P){},getProperty:function(c,p){},isPropertyInitial:function(c,p){},setPropertyBinding:function(c,p,P){},getPropertyBinding:function(c,p){},createControl:function(c,A,v,s,S){},getId:function(c){},getParent:function(c){},getControlType:function(c){},getAllAggregations:function(c){},getAggregation:function(p,n){},insertAggregation:function(p,A,o,i,v){},removeAggregation:function(p,A,o){},removeAllAggregation:function(p,A){},getBindingTemplate:function(c,A){},updateAggregation:function(p,A){},findIndexInParentAggregation:function(c){},getParentAggregationName:function(c,p){},validateType:function(c,A,p,f,i){},instantiateFragment:function(f,n,v){},getChangeHandlerModulePath:function(c){}};});
sap.ui.predefine('sap/ui/core/util/reflection/JsControlTreeModifier',["./BaseTreeModifier","jquery.sap.global","sap/ui/core/Component"],function(B,q,C){"use strict";var J={targets:"jsControlTree",setVisible:function(c,v){if(c.setVisible){this.unbindProperty(c,"visible");c.setVisible(v);}else{throw new Error("Provided control instance has no setVisible method");}},getVisible:function(c){if(c.getVisible){return c.getVisible();}else{throw new Error("Provided control instance has no getVisible method");}},setStashed:function(c,s,a){if(c.setStashed){var u;if(c.getStashed()===true&&s===false){c.setStashed(s);if(a instanceof C){u=this.bySelector(this.getSelector(c,a),a);}}if((u||c)["setVisible"]){this.setVisible(u||c,!s);}return u;}else{throw new Error("Provided control instance has no setStashed method");}},getStashed:function(c){if(c.getStashed){return typeof c.getStashed()!=="boolean"?!this.getVisible(c):c.getStashed();}else{throw new Error("Provided control instance has no getStashed method");}},bindProperty:function(c,p,b){c.bindProperty(p,b);},unbindProperty:function(c,p){if(c){c.unbindProperty(p,true);}},setProperty:function(c,p,P){var m=c.getMetadata().getPropertyLikeSetting(p);this.unbindProperty(c,p);if(m){var s=m._sMutator;c[s](P);}},getProperty:function(c,p){var m=c.getMetadata().getPropertyLikeSetting(p);if(m){var P=m._sGetter;return c[P]();}},isPropertyInitial:function(c,p){return c.isPropertyInitial(p);},setPropertyBinding:function(c,p,P){this.unbindProperty(c,p);var s={};s[p]=P;c.applySettings(s);},getPropertyBinding:function(c,p){return c.getBindingInfo(p);},createControl:function(c,a,v,s,S){if(this.bySelector(s,a)){throw new Error("Can't create a control with duplicated id "+s);}q.sap.require(c);var b=q.sap.getObject(c);var i=this.getControlIdBySelector(s,a);return new b(i,S);},applySettings:function(c,s){c.applySettings(s);},byId:function(i){return this._byId(i);},_byId:function(i){return sap.ui.getCore().byId(i);},getId:function(c){return c.getId();},getParent:function(c){return c.getParent();},getControlType:function(c){return c&&c.getMetadata().getName();},getAllAggregations:function(p){return p.getMetadata().getAllAggregations();},getAggregation:function(p,n){var a=this.findAggregation(p,n);if(a){return p[a._sGetter]();}},insertAggregation:function(p,n,o,i){var a=this.findAggregation(p,n);if(a){if(a.multiple){var I=i||0;p[a._sInsertMutator](o,I);}else{p[a._sMutator](o);}}},removeAggregation:function(c,n,o){var a=this.findAggregation(c,n);if(a){c[a._sRemoveMutator](o);}},removeAllAggregation:function(c,n){var a=this.findAggregation(c,n);if(a){c[a._sRemoveAllMutator]();}},getBindingTemplate:function(c,a){var b=c.getBindingInfo(a);return b&&b.template;},updateAggregation:function(c,a){var A=this.findAggregation(c,a);if(A){c[A._sDestructor]();c.updateAggregation(a);}},findIndexInParentAggregation:function(c){var p=this.getParent(c),a;if(!p){return-1;}a=this.getAggregation(p,this.getParentAggregationName(c));if(Array.isArray(a)){return a.indexOf(c);}else{return 0;}},getParentAggregationName:function(c){return c.sParentAggregationName;},findAggregation:function(c,a){if(c){if(c.getMetadata){var m=c.getMetadata();var A=m.getAllAggregations();if(A){return A[a];}}}},validateType:function(c,a,p,f){var t=a.type;if(a.multiple===false&&this.getAggregation(p,a.name)&&this.getAggregation(p,a.name).length>0){return false;}return this._isInstanceOf(c,t)||this._hasInterface(c,t);},instantiateFragment:function(f,n,v){var F=q.sap.parseXML(f);F=this._checkAndPrefixIdsInFragment(F,n);var N;var i=v&&v.getId();var c=v.getController();N=sap.ui.xmlfragment({fragmentContent:F,sId:i},c);if(!Array.isArray(N)){N=[N];}return N;},getChangeHandlerModulePath:function(c){if(typeof c==="object"&&typeof c.data==="function"&&c.data("sap-ui-custom-settings")&&c.data("sap-ui-custom-settings")["sap.ui.fl"]){return c.data("sap-ui-custom-settings")["sap.ui.fl"].flexibility;}else{return undefined;}}};return q.sap.extend(true,{},B,J);},true);
sap.ui.predefine('sap/ui/core/util/reflection/XmlTreeModifier',["./BaseTreeModifier","sap/ui/base/DataType","sap/ui/core/XMLTemplateProcessor","jquery.sap.global","sap/ui/core/Fragment","jquery.sap.xml"],function(B,D,X,q){"use strict";var a={targets:"xmlTree",setVisible:function(c,v){if(v){c.removeAttribute("visible");}else{this.setProperty(c,"visible",v);}},getVisible:function(c){return this.getProperty(c,"visible");},setStashed:function(c,s){if(!s){c.removeAttribute("stashed");}else{this.setProperty(c,"stashed",s);}this.setVisible(c,!s);},getStashed:function(c){return this.getProperty(c,"stashed");},bindProperty:function(c,p,b){c.setAttribute(p,"{"+b+"}");},unbindProperty:function(c,p){c.removeAttribute(p);},setProperty:function(c,p,P){c.setAttribute(p,P);},getProperty:function(c,p){var P=this._getControlMetadata(c).getProperty(p);var v=c.getAttribute(p);if(P){var t=P.getType();if(v===null){v=P.getDefaultValue()||t.getDefaultValue();}else{v=t.parseValue(v);}}return v;},isPropertyInitial:function(c,p){var P=c.getAttribute(p);return(P==null);},setPropertyBinding:function(c,p,P){c.setAttribute(p,P);},getPropertyBinding:function(c,p){return c.getAttribute(p);},createControl:function(c,A,v,s,S){var i,l;if(!this.bySelector(s,A,v)){var C=c.split('.');var n="";if(C.length>1){l=C.pop();n=C.join('.');}var N=v.ownerDocument.createElementNS(n,l);i=this.getControlIdBySelector(s,A);if(i){N.setAttribute("id",i);}if(S){var V;Object.keys(S).forEach(function(k){V=S[k];N.setAttribute(k,V);});}return N;}else{throw new Error("Can't create a control with duplicated id "+i);}},_byId:function(i,v){if(v){if(v.ownerDocument&&v.ownerDocument.getElementById&&v.ownerDocument.getElementById(i)){return v.ownerDocument.getElementById(i);}else{return v.querySelector("[id='"+i+"']");}var n=q.sap.byId(i,v);if(n.length===1){return n[0];}}},getId:function(c){return c.getAttribute("id");},getParent:function(c){var p=c.parentNode;if(!this.getId(p)){p=p.parentNode;}return p;},_getLocalName:function(x){return x.localName||x.baseName||x.nodeName;},getControlType:function(c){return this._getControlTypeInXml(c);},getAllAggregations:function(c){var C=this._getControlMetadata(c);return C.getAllAggregations();},getAggregation:function(p,n){var A=this._findAggregationNode(p,n);var s=this._isSingleValueAggregation(p,n);if(!A){if(s&&this._isAltTypeAggregation(p,n)){return this.getProperty(p,n);}return s?undefined:[];}var c=this._getControlsInAggregation(p,A);if(s){return c[0];}return c;},insertAggregation:function(p,n,o,i,v){var A=this._findAggregationNode(p,n);if(!A){var N=p.namespaceURI;A=this.createControl(N+"."+n,undefined,v);p.appendChild(A);}if(i>=A.childElementCount){A.appendChild(o);}else{var r=this._getControlsInAggregation(p,A)[i];A.insertBefore(o,r);}},removeAggregation:function(p,n,o){var A=this._findAggregationNode(p,n);A.removeChild(o);},removeAllAggregation:function(c,n){var A=this._findAggregationNode(c,n);if(c===A){var C=this._getControlsInAggregation(c,c);C.forEach(function(o){c.removeChild(o);});}else{c.removeChild(A);}},_findAggregationNode:function(p,n){var A;var c=this._children(p);for(var i=0;i<c.length;i++){var N=c[i];if(N.localName===n){A=N;break;}}if(!A&&this._isDefaultAggregation(p,n)){A=p;}return A;},_isDefaultAggregation:function(p,A){var c=this._getControlMetadata(p);var d=c.getDefaultAggregation();return d&&A===d.name;},_isNotNamedAggregationNode:function(p,c){var A=this.getAllAggregations(p);var o=A[c.localName];return p.namespaceURI!==c.namespaceURI||!o;},_isSingleValueAggregation:function(p,A){var m=this.getAllAggregations(p);var o=m[A];return!o.multiple;},_isAltTypeAggregation:function(p,A){var c=this._getControlMetadata(p);var o=c.getAllAggregations()[A];return!!o.altTypes;},_getControlMetadata:function(c){return this._getControlMetadataInXml(c);},_getControlsInAggregation:function(p,A){var c=Array.prototype.slice.call(this._children(A));return c.filter(this._isNotNamedAggregationNode.bind(this,p));},_children:function(p){if(p.children){return p.children;}else{var c=[];for(var i=0;i<p.childNodes.length;i++){var n=p.childNodes[i];if(n.nodeType===n.ELEMENT_NODE){c.push(n);}}return c;}},getBindingTemplate:function(c,A){var o=this._findAggregationNode(c,A);if(o){var C=this._children(o);if(C.length===1){return C[0];}}},updateAggregation:function(c,A){},findIndexInParentAggregation:function(c){var p,A,C;p=this.getParent(c);if(!p){return-1;}A=this.getParentAggregationName(c,p);C=this.getAggregation(p,A);if(Array.isArray(C)){return C.indexOf(c);}else{return 0;}},getParentAggregationName:function(c,p){var n,A;if(!p.isSameNode(c.parentNode)){n=false;}else{n=this._isNotNamedAggregationNode(p,c);}if(n){A=this._getControlMetadata(p).getDefaultAggregationName();}else{A=this._getLocalName(c.parentNode);}return A;},findAggregation:function(c,A){var m=this._getControlMetadata(c);var o=m.getAllAggregations();if(o){return o[A];}},validateType:function(c,A,p,f,i){var t=A.type;if(A.multiple===false&&this.getAggregation(p,A.name)&&this.getAggregation(p,A.name).length>0){return false;}var C=sap.ui.xmlfragment({fragmentContent:f});if(!Array.isArray(C)){C=[C];}var r=this._isInstanceOf(C[i],t)||this._hasInterface(C[i],t);C.forEach(function(F){F.destroy();});return r;},instantiateFragment:function(f,n){var F=q.sap.parseXML(f);F=this._checkAndPrefixIdsInFragment(F,n);if(F.localName==="FragmentDefinition"){return this._getElementNodeChildren(F);}else{return[F];}},getChangeHandlerModulePath:function(c){if(!c){return undefined;}return c.getAttributeNS("sap.ui.fl","flexibility");}};return q.sap.extend(true,{},B,a);},true);
sap.ui.predefine('sap/ui/core/util/serializer/HTMLViewSerializer',['sap/ui/base/EventProvider','./Serializer','./delegate/HTML','sap/ui/thirdparty/vkbeautify'],function(E,S,H,v){"use strict";
var a=E.extend("sap.ui.core.util.serializer.HTMLViewSerializer",{constructor:function(V,w,g,G){E.apply(this);this._oView=V;this._oWindow=w;this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
a.prototype.serialize=function(){var t=this;var s=function(C){return C instanceof this._oWindow.sap.ui.core.mvc.View&&C!==t._oView;};var c=new S(this._oView,new H(this._fnGetControlId,this._fnGetEventHandlerName),true,this._oWindow,s);var r=c.serialize();var V=[];V.push('<template');if(this._oView.getControllerName&&this._oView.getControllerName()){V.push(' data-controller-name="'+this._oView.getControllerName()+'"');}V.push(" >");V.push(r);V.push("</template>");return v.xml(V.join(""));};
return a;});
sap.ui.predefine('sap/ui/core/util/serializer/Serializer',['jquery.sap.global','sap/ui/base/EventProvider'],function(q,E){"use strict";
var S=E.extend("sap.ui.core.util.serializer.Serializer",{constructor:function(r,s,b,w,f,a){E.apply(this);this._oRootControl=r;this._delegate=s;this._bSkipRoot=!!b;this._oWindow=w||window;this._fnSkipAggregations=f;this._fnSkipElement=a;}});
S.prototype.serialize=function(){return this._serializeRecursive(this._oRootControl,0);};
S.prototype._serializeRecursive=function(c,l,a,b){var C=[];var w=(!this._bSkipRoot||l!==0);if(w){var s=this._delegate.start(c,a,b);var m=this._delegate.middle(c,a,b);C.push(s+m);}var A=c.getMetadata().getAllAggregations();if(A){for(var n in A){if(this._fnSkipAggregations&&this._fnSkipAggregations(c,n)){continue;}var e=[];var o=A[n];var v=c[o._sGetter]();if(c.getBindingPath(n)&&c.getBindingInfo(n).template){e.push(c.getBindingInfo(n).template);}else if(v&&v.length){for(var i=0;i<v.length;i++){var O=v[i];if(this._isObjectSerializable(O)){e.push(O);}}}else if(this._isObjectSerializable(v)){e.push(v);}if(e.length>0){if(w){C.push(this._delegate.startAggregation(c,n));}var d=this._isDefaultAggregation(c,n);for(var j=0;j<e.length;j++){C.push(this._serializeRecursive(e[j],l+1,n,d));}if(w){C.push(this._delegate.endAggregation(c,n));}}}}if(w){var f=this._delegate.end(c,a,b);C.push(f);}return C.join("");};
S.prototype._isObjectSerializable=function(o){return o instanceof this._oWindow.sap.ui.core.Element&&!(this._fnSkipElement&&this._fnSkipElement(o));};
S.prototype._isDefaultAggregation=function(c,a){return c.getMetadata().getDefaultAggregationName()===a;};
return S;});
sap.ui.predefine('sap/ui/core/util/serializer/ViewSerializer',['jquery.sap.global','sap/ui/base/EventProvider','./HTMLViewSerializer','./XMLViewSerializer'],function(q,E,H,X){"use strict";
var V=E.extend("sap.ui.core.util.serializer.ViewSerializer",{constructor:function(r,w,d){E.apply(this);this._oRootControl=r;this._oWindow=w||window;this._mViews={};this._sDefaultXmlNamespace=d;}});
V.prototype.serializeToXML=function(){return this.serialize("XML");};
V.prototype.serializeToHTML=function(){return this.serialize("HTML");};
V.prototype.serialize=function(c){this._mViews={};this._sConvertToViewType=c||undefined;return this._serializeRecursive(this._oRootControl);};
V.prototype._getViewType=function(v){if(!this._sConvertToViewType){if(v instanceof this._oWindow.sap.ui.core.mvc.HTMLView){return"HTML";}else if(v instanceof this._oWindow.sap.ui.core.mvc.XMLView){return"XML";}}return this._sConvertToViewType;};
V.prototype._serializeRecursive=function(c){if(c instanceof this._oWindow.sap.ui.core.mvc.View){var v=this._getViewSerializer(c,this._getViewType(c));if(v){var o=c.getViewName()||c.getControllerName();if(!this._mViews[o]){this._mViews[o]=v.serialize(this._getViewType(c));}}}if(c.getMetadata().getClass()===this._oWindow.sap.ui.core.UIArea){var C=c.getContent();for(var i=0;i<C.length;i++){this._serializeRecursive(C[i]);}}else if(c.getMetadata().getClass()===this._oWindow.sap.ui.core.ComponentContainer){this._serializeRecursive(c.getComponentInstance().getRootControl());}else{var a=c.getMetadata().getAllAggregations();if(a){for(var n in a){var A=a[n];var b=c[A._sGetter]();if(b&&b.length){for(var i=0;i<b.length;i++){var O=b[i];if(O instanceof this._oWindow.sap.ui.core.Element){this._serializeRecursive(O);}}}else if(b instanceof this._oWindow.sap.ui.core.Element){this._serializeRecursive(b);}}}}return this._mViews;};
V.prototype._getViewSerializer=function(v,t){var g=function(e){if(e.fFunction&&e.fFunction._sapui_handlerName){var h=e.fFunction._sapui_handlerName;var c=v.getController();if(c[h]||sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){return h;}}};var G=function(c){if(c._sapui_controlId){return c._sapui_controlId;}return c.getId().replace(v.createId(""),"");};if(t==="HTML"){return new H(v,this._oWindow,G,g);}else if(t==="XML"){return new X(v,this._oWindow,this._sDefaultXmlNamespace,G,g);}else{var t=(v)?v.constructor:"?";throw Error("View type '"+t+"' is not supported for conversion. Only HTML and XML is supported");}};
return V;});
sap.ui.predefine('sap/ui/core/util/serializer/XMLViewSerializer',['sap/ui/base/EventProvider','./Serializer','./delegate/XML','sap/ui/thirdparty/vkbeautify'],function(E,S,X,v){"use strict";
var a=E.extend("sap.ui.core.util.serializer.XMLViewSerializer",{constructor:function(V,w,d,g,G){E.apply(this);this._oView=V;this._oWindow=w;this._sDefaultNamespace=d;this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
a.prototype.serialize=function(){var p=[];var m=function(C,P){if(!P){var T=(C)?C.constructor:"?";throw Error("Controls with empty package are currently not supported by the XML serializer: "+T);}if(p.indexOf(P)===-1){p.push(P);}};var t=this;var s=function(C){return C instanceof this._oWindow.sap.ui.core.mvc.View&&C!==t._oView;};var c=new S(this._oView,new X(this._sDefaultNamespace,this._fnGetControlId,this._fnGetEventHandlerName,m),true,this._oWindow,s);var r=c.serialize();var V=[];V.push('<sap.ui.core.mvc:View');if(this._oView.getControllerName&&this._oView.getControllerName()){V.push(' controllerName="'+this._oView.getControllerName()+'"');}if(p.indexOf('sap.ui.core.mvc')===-1){p.push('sap.ui.core.mvc');}for(var i=0;i<p.length;i++){if(this._sDefaultNamespace&&this._sDefaultNamespace===p[i]){V.push(' xmlns="'+p[i]+'"');}else{V.push(' xmlns:'+p[i]+'="'+p[i]+'"');}}V.push(" >");V.push(r);V.push("</sap.ui.core.mvc:View>");return v.xml(V.join(""));};
return a;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/Delegate',['sap/ui/base/EventProvider'],function(E){"use strict";
var D=E.extend("sap.ui.core.util.serializer.delegate.Delegate",{constructor:function(){E.apply(this);}});
D.prototype.start=function(c,a,i){return"";};
D.prototype.middle=function(c,a,i){return"";};
D.prototype.end=function(c,a,i){return"";};
D.prototype.startAggregation=function(c,a){return"";};
D.prototype.endAggregation=function(c,a){return"";};
return D;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/HTML',['jquery.sap.global','./Delegate'],function(q,D){"use strict";
var H=D.extend("sap.ui.core.util.serializer.delegate.HTML",{constructor:function(g,G){D.apply(this);this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
H.prototype.startAggregation=function(c,a){return'<div data-sap-ui-aggregation="'+a+'">';};
H.prototype.endAggregation=function(c,a){return'</div>';};
H.prototype.start=function(c,a,i){return"<div";};
H.prototype.middle=function(c,a,b){var h=[];var I=(this._fnGetControlId)?this._fnGetControlId(c):c.getId();if(I.indexOf("__")!==0){h.push(this._createAttribute("id",I));}h.push(this._createAttribute("data-sap-ui-type",c.getMetadata()._sClassName));if(c.aCustomStyleClasses){var C=c.aCustomStyleClasses;var d=[];for(var i=0;i<C.length;i++){var s=C[i];if(!q.sap.startsWith(s,"sapM")&&!q.sap.startsWith(s,"sapUi")){d.push(s);}}if(d.length>0){h.push(this._createAttribute("class",d.join(" ")));}}if(this._fnGetEventHandlerName){var e=c.getMetadata().getAllEvents();for(var E in e){if(c.hasListeners(E)){var f=c.mEventRegistry[E];for(var i=0;i<f.length;i++){var g=this._fnGetEventHandlerName(f[i]);if(g){h.push(this._createAttribute("data-"+this._createHtmlAttributeName(E),g));break;}}}}}var A=c.getMetadata().getAllAssociations();this._createAttributes(h,c,A,function(n,v){if(A[n].multiple){return v.join(" ");}return v;},function(n,v){return(v!==null&&typeof v!==undefined&&v!=="");});var p=c.getMetadata().getAllProperties();var o=c.getMetadata().getPropertyDefaults();this._createAttributes(h,c,p,null,function(n,v){return!q.sap.equal(v,o[n]);});var j=c.getMetadata().getAllAggregations();this._createAttributes(h,c,j,null,function(n,v){if(!c.getBindingInfo(n)&&(!v||(typeof v!=="string"))){return false;}return true;});h.push('>');return h.join('');};
H.prototype.end=function(c,a,i){return"</div>";};
H.prototype._createAttributes=function(h,c,o,g,v){for(var n in o){var p=o[n];var G=p._sGetter;if(c[G]){var V=c[G]();V=g?g(n,V):V;if(!c.getBindingInfo(n)){if(!v||v(n,V)){h.push(this._createAttribute("data-"+this._createHtmlAttributeName(n),V));}}else{h.push(this._createDataBindingAttribute(c,n,V));}}}};
H.prototype._createDataBindingAttribute=function(c,n,v){var b=c.getBindingInfo(n);var B=null;var p=v;if(!b.bindingString){if(b.binding){var C=b.binding.getMetadata().getName();if(C==="sap.ui.model.PropertyBinding"||C==="sap.ui.model.resource.ResourcePropertyBinding"){B=b.binding.getValue();}}if(b.parts){b=b.parts[0];}var m=b.model;if(B===v||B===null){p="{"+(m?(m+">"+b.path):b.path)+"}";}}else{p=b.bindingString;}return this._createAttribute("data-"+this._createHtmlAttributeName(n),p);};
H.prototype._createAttribute=function(a,v){return' '+a+'="'+v+'"';};
H.prototype._createHtmlAttributeName=function(n){return q.sap.hyphen(n);};
return H;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/XML',['jquery.sap.global','./Delegate'],function(q,D){"use strict";
var X=D.extend("sap.ui.core.util.serializer.delegate.XML",{constructor:function(d,g,G,m){D.apply(this);this._sDefaultNamespace=d;this._fnGetControlId=g;this._fnMemorizePackage=m;this._fnGetEventHandlerName=G;}});
X.prototype.startAggregation=function(c,a){return'<'+this._createAggregationName(c,a)+'>';};
X.prototype.endAggregation=function(c,a){return'</'+this._createAggregationName(c,a)+'>';};
X.prototype.start=function(c,a,i){return"<"+this._createTagName(c);};
X.prototype.end=function(c,a,i){return"</"+this._createTagName(c)+">";};
X.prototype.middle=function(c,a,b){var x=[];var I=(this._fnGetControlId)?this._fnGetControlId(c):c.getId();if(I.indexOf("__")!==0){x.push(this._createAttribute("id",I));}if(c.aCustomStyleClasses){var C=c.aCustomStyleClasses;var d=[];for(var i=0;i<C.length;i++){var s=C[i];if(!q.sap.startsWith(s,"sapM")&&!q.sap.startsWith(s,"sapUi")){d.push(s);}}if(d.length>0){x.push(this._createAttribute("class",d.join(" ")));}}if(this._fnGetEventHandlerName){var e=c.getMetadata().getAllEvents();for(var E in e){if(c.hasListeners(E)){var f=c.mEventRegistry[E];for(var i=0;i<f.length;i++){var h=this._fnGetEventHandlerName(f[i]);if(h){x.push(this._createAttribute(E,h));break;}}}}}var A=c.getMetadata().getAllAssociations();this._createAttributes(x,c,A,function(n,v){if(A[n].multiple){return v.join(" ");}return v;},function(n,v){return(v!==null&&typeof v!==undefined&&v!=="");});var p=c.getMetadata().getAllProperties();var o=c.getMetadata().getPropertyDefaults();this._createAttributes(x,c,p,null,function(n,v){return!q.sap.equal(v,o[n]);});var g=c.getMetadata().getAllAggregations();this._createAttributes(x,c,g,null,function(n,v){if(!c.getBindingInfo(n)&&(!v||(typeof v!=="string"))){return false;}return true;});x.push('>');return x.join('');};
X.prototype._createAttributes=function(x,c,o,g,v){for(var n in o){var p=o[n];var G=p._sGetter;if(c[G]){var V=c[G]();V=g?g(n,V):V;if(!c.getBindingInfo(n)){if(!v||v(n,V)){x.push(this._createAttribute(n,V));}}else{x.push(this._createDataBindingAttribute(c,n,V));}}}};
X.prototype._createDataBindingAttribute=function(c,n,v){var b=c.getBindingInfo(n);var B=null;var p=v;if(!b.bindingString){if(b.binding){var C=b.binding.getMetadata().getName();if(C==="sap.ui.model.PropertyBinding"||C==="sap.ui.model.resource.ResourcePropertyBinding"){B=b.binding.getValue();}}if(b.parts){b=b.parts[0];}var m=b.model;if(B===v||B===null){p="{"+(m?(m+">"+b.path):b.path)+"}";}}else{p=b.bindingString;}return this._createAttribute(n,p);};
X.prototype._createAttribute=function(a,v){var e=q.type(v)==="string"?q.sap.encodeHTML(v):v;return' '+a+'="'+e+'"';};
X.prototype._createTagName=function(c){var C=c.getMetadata()._sClassName;var l=C.lastIndexOf(".");var s=(l===-1)?C:C.substring(l+1);var p=(l===-1)?C:C.substring(0,l);if(this._fnMemorizePackage){this._fnMemorizePackage(c,p);}return this._createNamespace(p,s);};
X.prototype._createAggregationName=function(c,a){var C=c.getMetadata()._sClassName;var l=C.lastIndexOf(".");var p=(l===-1)?C:C.substring(0,l);return this._createNamespace(p,a);};
X.prototype._createNamespace=function(n,N){if(this._sDefaultNamespace&&this._sDefaultNamespace===n){return N;}else{return n+":"+N;}};
return X;});
sap.ui.predefine('sap/ui/core/ws/ReadyState',function(){"use strict";var R={CONNECTING:0,OPEN:1,CLOSING:2,CLOSED:3};return R;},true);
sap.ui.predefine('sap/ui/core/ws/SapPcpWebSocket',['jquery.sap.global','./WebSocket'],function(q,W){"use strict";
var S=W.extend("sap.ui.core.ws.SapPcpWebSocket",{constructor:function(u,p){W.apply(this,arguments);}});
S.SUPPORTED_PROTOCOLS={v10:"v10.pcp.sap.com"};S._deserializeRegexp=/((?:[^:\\]|(?:\\.))+):((?:[^:\\\n]|(?:\\.))*)/;S._SEPARATOR="\n\n";S._MESSAGE="MESSAGE";
S.prototype._onopen=function(){var s=false;if(this.getProtocol()===""){s=true;}else{for(var p in S.SUPPORTED_PROTOCOLS){if(S.SUPPORTED_PROTOCOLS.hasOwnProperty(p)){if(S.SUPPORTED_PROTOCOLS[p]===this.getProtocol()){s=true;break;}}}}if(s){this.fireOpen();}else{q.sap.log.error("Unsupported protocol '"+this.getProtocol()+"' selected by the server. "+"Connection will be closed.");this.close("Unsupported protocol selected by the server");}};
S.prototype._onmessage=function(m){var s=-1,e={};if(typeof m.data==="string"){s=m.data.indexOf(S._SEPARATOR);}if(s!==-1){e.pcpFields=this._extractPcpFields(m.data.substring(0,s));e.data=m.data.substr(s+S._SEPARATOR.length);}else{q.sap.log.warning("Invalid PCP message received: "+m.data);e.pcpFields={};e.data=m.data;}this.fireMessage(e);};
S.prototype._extractPcpFields=function(h){var f=h.split("\n"),l=[],p={};for(var i=0;i<f.length;i++){l=f[i].match(S._deserializeRegexp);if(l&&l.length===3){p[this._unescape(l[1])]=this._unescape(l[2]);}}return p;};
S.prototype._unescape=function(e){var p=e.split("\u0008"),u="";for(var i=0;i<p.length;i++){p[i]=p[i].replace(/\\\\/g,"\u0008").replace(/\\:/g,':').replace(/\\n/g,'\n').replace(/\u0008/g,"\\");}u=p.join("\u0008");return u;};
S.prototype._serializePcpFields=function(p,m,P){var s="",f="",a="";if(m==='string'){a='text';}else if(m==='blob'||m==='arraybuffer'){a='binary';}if(p&&typeof p==='object'){for(f in p){if(p.hasOwnProperty(f)&&f.indexOf('pcp-')!==0){s+=this._escape(f)+":"+this._escape(String(p[f]))+"\n";}}}return"pcp-action:"+P+"\npcp-body-type:"+a+"\n"+s+"\n";};
S.prototype._escape=function(u){return u.replace(/\\/g,'\\\\').replace(/:/g,'\\:').replace(/\n/g,'\\n');};
S.prototype.send=function(m,p){var M=typeof m,P="";P=this._serializePcpFields(p,M,S._MESSAGE);W.prototype.send.call(this,P+m);return this;};
return S;});
sap.ui.predefine('sap/ui/core/ws/WebSocket',['jquery.sap.global','sap/ui/Device','sap/ui/base/EventProvider','./ReadyState','sap/ui/thirdparty/URI'],function(q,D,E,R,U){"use strict";
var W=E.extend("sap.ui.core.ws.WebSocket",{
constructor:function(u,p){E.apply(this);if(!D.support.websocket){throw new Error("Browser does not support WebSockets.");}if(typeof(u)!=="string"){throw new Error("sUrl must be a string.");}if(typeof(p)!=='undefined'&&!Array.isArray(p)&&typeof(p)!=='string'){throw new Error("aProtocols must be a string, array of strings or undefined.");}this._openConnection(u,p);},
metadata:{publicMethods:["send","close","getReadyState","getProtocol"]}
});
W.prototype.getInterface=function(){return this;};
W.M_EVENTS={Open:"open",Close:"close",Error:"error",Message:"message"};
W.prototype.attachOpen=function(d,f,l){this.attachEvent("open",d,f,l);return this;};
W.prototype.detachOpen=function(f,l){this.detachEvent("open",f,l);return this;};
W.prototype.fireOpen=function(a){this.fireEvent("open",a);return this;};
W.prototype.attachClose=function(d,f,l){this.attachEvent("close",d,f,l);return this;};
W.prototype.detachClose=function(f,l){this.detachEvent("close",f,l);return this;};
W.prototype.fireClose=function(a){this.fireEvent("close",a);return this;};
W.prototype.attachError=function(d,f,l){this.attachEvent("error",d,f,l);return this;};
W.prototype.detachError=function(f,l){this.detachEvent("error",f,l);return this;};
W.prototype.fireError=function(a){this.fireEvent("error",a);return this;};
W.prototype.attachMessage=function(d,f,l){this.attachEvent("message",d,f,l);return this;};
W.prototype.detachMessage=function(f,l){this.detachEvent("message",f,l);return this;};
W.prototype.fireMessage=function(a){this.fireEvent("message",a);return this;};
W.prototype._resolveFullUrl=function(u){var o=new U(u);var b=new U(document.baseURI);b.search('');b.protocol(b.protocol()==='https'?'wss':'ws');o=o.absoluteTo(b);return o.toString();};
W.prototype._openConnection=function(u,p){var u=this._resolveFullUrl(u);this._oWs=(typeof(p)==='undefined')?new window.WebSocket(u):new window.WebSocket(u,p);this._oWs.onopen=q.proxy(this._onopen,this);this._oWs.onclose=q.proxy(this._onclose,this);this._oWs.onmessage=q.proxy(this._onmessage,this);this._oWs.onerror=q.proxy(this._onerror,this);};
W.prototype._onopen=function(){this.fireOpen();};
W.prototype._onclose=function(c){this.fireClose({code:c.code,reason:c.reason,wasClean:c.wasClean});};
W.prototype._onerror=function(e){this.fireError();};
W.prototype._onmessage=function(m){this.fireMessage({data:m.data});};
W.prototype.send=function(m){if(this.getReadyState()===R.OPEN){this._oWs.send(m);}else if(this.getReadyState()===R.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.send(m);});}else{q.sap.log.warning("Unable to send WebSocket message. "+"Connection is already closed or closing. message: "+m);}return this;};
W.prototype.close=function(c,r){if(typeof(c)==='string'){r=c;c=undefined;}c=(typeof(c)==='undefined')?1000:c;r=(typeof(r)==='undefined')?"":r;if(this.getReadyState()===R.OPEN){this._oWs.close(c,r);}else if(this.getReadyState()===R.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.close(c,r);});}else{var t='';switch(this.getReadyState()){case R.CLOSED:t="Connection is already closed.";break;case R.CLOSING:t="Connection is already closing.";break;}q.sap.log.warning("Unable to close WebSocket connection. "+t);}return this;};
W.prototype.getReadyState=function(){return this._oWs.readyState;};
W.prototype.getProtocol=function(){return this._oWs.protocol;};
return W;});
sap.ui.predefine('sap/ui/model/ClientTreeBindingAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ClientTreeBinding','./TreeBindingAdapter','sap/ui/model/ChangeReason'],function(q,T,C,a,b){"use strict";var c=function(){if(!(this instanceof T)||this._bIsAdapted){return;}a.apply(this);for(var f in c.prototype){if(c.prototype.hasOwnProperty(f)){this[f]=c.prototype[f];}}this._invalidTree=true;this.setNumberOfExpandedLevels(this.mParameters.numberOfExpandedLevels||0);};
c.prototype.setNumberOfExpandedLevels=function(n){this._iNumberOfExpandedLevels=parseInt(n,10);};
c.prototype.getNumberOfExpandedLevels=function(){return this._iNumberOfExpandedLevels;};
c.prototype.nodeHasChildren=function(n){if(!n){return false;}else if(n.isArtificial){return true;}else{return C.prototype.hasChildren.call(this,n.context);}};
c.prototype.resetData=function(o,p){var r=C.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==b.Sort){this.clearSelection();this._createTreeState(true);}return r;};
c.prototype._calculateGroupID=function(n){var B=this.getPath();var g;if(n.context){var s=n.context.getPath();if(B!="/"){var m=s.match(B+"(.*)");if(m!=null&&m[1]){g=m[1];}else{q.sap.log.warning("CTBA: BindingPath/ContextPath matching problem!");}}if(!g){g=s;}if(q.sap.startsWith(g,"/")){g=g.substring(1,g.length);}var p;if(!n.parent){p=this._calculateGroupID({context:n.context._parentContext||null});}else{p=n.parent.groupID;}g=p+g.replace(/\//g,"_")+"/";}else if(n.context===null){g="/";}return g;};
c.prototype.expand=function(){this._buildTree();a.prototype.expand.apply(this,arguments);};
c.prototype.collapse=function(){this._buildTree();a.prototype.collapse.apply(this,arguments);};
c.prototype._buildTree=function(s,l){if(this._invalidTree){s=s||0;l=l||this.getRootContexts().length;this._invalidTree=false;this._aRowIndexMap=[];a.prototype._buildTree.call(this,s,l);}};
c.prototype.findNode=function(){this._buildTree();return a.prototype.findNode.apply(this,arguments);};
c.prototype.setSelectedIndex=function(){this._buildTree();return a.prototype.setSelectedIndex.apply(this,arguments);};
c.prototype.setSelectionInterval=function(){this._buildTree();return a.prototype.setSelectionInterval.apply(this,arguments);};
c.prototype.addSelectionInterval=function(){this._buildTree();a.prototype.addSelectionInterval.apply(this,arguments);};
c.prototype.removeSelectionInterval=function(){this._buildTree();a.prototype.removeSelectionInterval.apply(this,arguments);};
c.prototype.clearSelection=function(){this._buildTree();a.prototype.clearSelection.apply(this,arguments);};
c.prototype.selectAll=function(){this._buildTree();a.prototype.selectAll.apply(this,arguments);};
c.prototype._calculateRequestLength=function(m,s){return m;};
c.prototype.getLength=function(){this._buildTree();return a.prototype.getLength.apply(this,arguments);};
c.prototype._fireChange=function(){this._invalidTree=true;this.constructor.prototype._fireChange.apply(this,arguments);};
return c;},true);
sap.ui.predefine('sap/ui/model/MetaModel',['./Model'],function(M){"use strict";
var a=M.extend("sap.ui.model.MetaModel",{constructor:function(){M.apply(this,arguments);}});
a.prototype.createBindingContext=function(p,c,P,C){if(typeof c=="function"){C=c;c=null;}if(typeof P=="function"){C=P;P=null;}var s=this.resolve(p,c),n=(s==undefined)?undefined:this.getContext(s?s:"/");if(!n){n=null;}if(C){C(n);}return n;};
a.prototype.destroyBindingContext=function(c){};
a.prototype.getAdapterFactoryModulePath=null;return a;});
sap.ui.predefine('sap/ui/model/SelectionModel',['jquery.sap.global','sap/ui/base/EventProvider'],function(q,E){"use strict";
var S=E.extend("sap.ui.model.SelectionModel",{constructor:function(s){E.apply(this);this.iSelectionMode=s||S.SINGLE_SELECTION;this.aSelectedIndices=[];this.iLeadIndex=-1;this.fnSort=function(a,b){return a-b;};this.fnSortReverse=function(a,b){return b-a;};}});
S.SINGLE_SELECTION=0;S.MULTI_SELECTION=1;
S.prototype.getSelectionMode=function(){return this.iSelectionMode;};
S.prototype.setSelectionMode=function(s){this.iSelectionMode=s||S.SINGLE_SELECTION;};
S.prototype.isSelectedIndex=function(i){return this.aSelectedIndices.indexOf(i)!==-1;};
S.prototype.getLeadSelectedIndex=function(){return this.iLeadIndex;};
S.prototype.setLeadSelectedIndex=function(l){this.setSelectionInterval(l,l);return this;};
S.prototype.getMinSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSort);return i[0];}else{return-1;}};
S.prototype.getMaxSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSortReverse);return i[0];}else{return-1;}};
S.prototype.getSelectedIndices=function(){var i=this.aSelectedIndices.sort(this.fnSort);return i;};
S.prototype.setSelectionInterval=function(f,t){if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var o=this.aSelectedIndices.slice();var l={};var c=[];for(var i=0;i<o.length;i++){l[o[i]]=true;if(o[i]<f||o[i]>t){c.push(o[i]);}}var s=[];for(var I=F;I<=T;I++){s.push(I);if(!l[I]){c.push(I);}}this._update(s,t,c);return this;};
S.prototype.addSelectionInterval=function(f,t){if(this.iSelectionMode===S.SINGLE_SELECTION){return this.setSelectionInterval(f,t);}var F=Math.min(f,t);var T=Math.max(f,t);var c=[];var s=this.aSelectedIndices;for(var i=F;i<=T;i++){if(s.indexOf(i)===-1){s.push(i);c.push(i);}}this._update(s,T,c);return this;};
S.prototype.moveSelectionInterval=function(s,m){var c=[];var a=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=0;i<a.length;i++){var I=a[i];if(I>=s){c.push(a[i]);a[i]+=m;c.push(a[i]);if(I===this.iLeadIndex){l+=m;}}}this._update(a,l,c);return this;};
S.prototype.removeSelectionInterval=function(f,t){if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var c=[];var s=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=F;i<=T;i++){var I=s.indexOf(i);if(I>-1){s.splice(I,1);c.push(i);}if(i===this.iLeadIndex){l=-1;}}this._update(s,l,c);return this;};
S.prototype.sliceSelectionInterval=function(f,t){var F=Math.min(f,t);var T=Math.max(f,t);var c=[];var r=[];var o=this.aSelectedIndices.slice(0);var s=this.aSelectedIndices;var l=this.iLeadIndex;var R=T-F+1;for(var I=T;I>=F;I--){var a=s.indexOf(I);if(a>-1){s.splice(a,1);r.push(I);}if(I===this.iLeadIndex){l=-1;}}for(var I=0;I<s.length;I++){var O=s[I];if(O>=F){var n=s[I]-R;if(O===l){l=n;}s[I]=n;if(o.indexOf(n)===-1){c.push(n);}}}for(var i=0;i<r.length;i++){var I=o[o.length-1-i];if(c.indexOf(I)===-1){c.push(I);}}for(var i=0;i<r.length;i++){if(s.indexOf(r[i])===-1&&c.indexOf(r[i])===-1){c.push(r[i]);}}this._update(s,l,c);return this;};
S.prototype.clearSelection=function(){if(this.aSelectedIndices.length>0||this.iLeadIndex!==-1){this._update([],-1,this.aSelectedIndices.slice());}return this;};
S.prototype.attachSelectionChanged=function(d,f,l){this.attachEvent("selectionChanged",d,f,l);return this;};
S.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};
S.prototype.fireSelectionChanged=function(a){this.fireEvent("selectionChanged",a);return this;};
S.prototype._update=function(s,l,c,b){var p={rowIndices:c&&c.sort(this.fnSort),selectAll:b};this.aSelectedIndices=s;p.oldIndex=this.iLeadIndex;if(this.iLeadIndex!==l){this.iLeadIndex=l;p.leadIndex=this.iLeadIndex;}if(c.length>0||typeof p.leadIndex!=="undefined"){this.fireSelectionChanged(p);}};
S.prototype.selectAll=function(t){var o=this.aSelectedIndices.slice();var l={};var c=[];var s=[];var i=0;for(i=0;i<o.length;i++){l[o[i]]=true;if(o[i]>t){c.push(o[i]);}}for(i=0;i<=t;i++){s.push(i);if(!l[i]){c.push(i);}}this._update(s,0,c,true);return this;};
return S;});
sap.ui.predefine('sap/ui/model/TreeAutoExpandMode',[],function(){"use strict";var T={Sequential:"Sequential",Bundled:"Bundled"};return T;},true);
sap.ui.predefine('sap/ui/model/TreeBindingAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils'],function(q,T,c,C,d){"use strict";var e=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var f in e.prototype){if(e.prototype.hasOwnProperty(f)){this[f]=e.prototype[f];}}this.mParameters=this.mParameters||{};this._aRowIndexMap=[];this._iThreshold=0;this._iPageSize=0;this.setAutoExpandMode(this.mParameters.autoExpandMode||c.Sequential);if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._createTreeState();this._bIsAdapted=true;};
e.prototype.getCurrentTreeState=function(){var D=";";var E={};for(var g in this._mTreeState.expanded){E[g]=true;}var m={};for(var g in this._mTreeState.collapsed){m[g]=true;}var s={};for(var g in this._mTreeState.selected){s[g]=true;}return{_getExpandedList:function(){return Object.keys(E).join(D);},_getCollapsedList:function(){return Object.keys(m).join(D);},_getSelectedList:function(){return Object.keys(s).join(D);},_isExpanded:function(g){return!!E[g];},_isCollapsed:function(g){return!!m[g];},_remove:function(g){delete E[g];delete m[g];delete s[g];}};};
e.prototype.setTreeState=function(t){this._oInitialTreeState=t;};
e.prototype.setAutoExpandMode=function(a){this._autoExpandMode=a;};
e.prototype.getLength=function(){if(!this._oRootNode){return 0;}return this._oRootNode.magnitude;};
e.prototype.getContextByIndex=function(i){if(this.isInitial()){return;}var n=this.findNode(i);return n?n.context:undefined;};
e.prototype.getNodeByIndex=function(i){if(this.isInitial()){return;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};
e.prototype.findNode=function(p){if(this.isInitial()){return;}var P=typeof p;var f;var s=[];if(P==="number"){f=this._aRowIndexMap[p];if(!f){var i=-1;this._match(this._oRootNode,s,1,function(n){if(i===p){return true;}i+=1;});f=s[0];}}return f;};
e.prototype._createTreeState=function(r){if(!this._mTreeState||r){this._mTreeState={expanded:{},collapsed:{},selected:{},deselected:{}};}};
e.prototype._updateTreeState=function(p){p=p||{};var t=p.expanded?this._mTreeState.expanded:this._mTreeState.collapsed;var s=p.expanded?this._mTreeState.collapsed:this._mTreeState.expanded;var n=this._getNodeState(p.groupID);if(!n){n=p.fallbackNodeState||this._createNodeState({groupID:p.groupID,expanded:p.expanded,sum:p.sum});}delete s[p.groupID];t[p.groupID]=n;n.expanded=p.expanded;return n;};
e.prototype._createNodeState=function(p){if(!p.groupID){return;}var i;var I;if(this._oInitialTreeState){i=this._oInitialTreeState._isExpanded(p.groupID);I=this._oInitialTreeState._isCollapsed(p.groupID);this._oInitialTreeState._remove(p.groupID);}var b=p.expanded||i||false;var a=p.selected||false;var n={groupID:p.groupID,expanded:b,sections:p.sections||[{startIndex:0,length:this._iPageSize}],sum:p.sum||false,selected:a};if(i||I){this._updateTreeState({groupID:p.groupID,fallbackNodeState:n,expanded:i,collapsed:I});}return n;};
e.prototype._getNodeState=function(g){var E=this._mTreeState.expanded[g];var o=this._mTreeState.collapsed[g];var s=this._mTreeState.selected[g];var D=this._mTreeState.deselected[g];return E||o||s||D;};
e.prototype._updateNodeSections=function(g,n){var N=this._getNodeState(g);if(!N){return;}else if(!n){return;}else if(n.length<=0){return;}else if(n.startIndex<0){return;}N.sections=d.mergeSections(N.sections,n);return N.sections;};
e.prototype._increaseSections=function(){var I=function(n){if(!n){return;}var m=this._getMaxGroupSize(n);var N=n.nodeState;if(m===undefined){var a=[];for(var i=0;i<N.sections.length;i++){var o=N.sections[i];o.length=Math.max(o.length,this._iPageSize);a=d.mergeSections(a,o);}N.sections=a;}};this._map(this._oRootNode,I);};
e.prototype._getMaxGroupSize=function(n){var m=0;if(n.isArtificial){var i=this.oModel.isList(this.sPath,this.getContext());if(this.bDisplayRootNode&&!i&&!this._bRootMissing){m=1;}else{m=this._getGroupSize(n)||0;}}else{m=this.nodeHasChildren(n)?this._getGroupSize(n):0;}return m;};
e.prototype.getContexts=function(s,l,t,r){if(this.isInitial()){return[];}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}if(l>this._iPageSize){this._iPageSize=l;this._increaseSections();}this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(s,l);var n=[];if(this._oRootNode){n=this._retrieveNodeSection(this._oRootNode,s,l);}this._updateRowIndexMap(n,s);var a=[];var m;for(var i=0;i<n.length;i++){var N=n[i];if(!N.context){m=m||{};var p=N.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:N.positionInParent,length:1});}a.push(N.context);}if(m){var b=this;q.each(m,function(g,N){N.magnitude=0;N.numberOfTotals=0;b._loadChildContexts(N);});a=[];for(var j=0;j<n.length;j++){var N=n[j];a.push(N.context);}}if(r){return n;}else{return a;}};
e.prototype.getNodes=function(s,l,t){return this.getContexts(s,l,t,true);};
e.prototype._updateRowIndexMap=function(n,s){this._aRowIndexMap=[];for(var i=0;i<n.length;i++){this._aRowIndexMap[s+i]=n[i];}};
e.prototype._retrieveNodeSection=function(n,s,l){var N=-1;var a=[];this._match(this._oRootNode,[],l,function(n,p,P){if(!n||!n.isArtificial){N++;}if(N>=s&&N<s+l){if(!n){n=this._createNode({parent:P,positionInParent:p});P.children[p]=n;}a.push(n);return true;}});return a;};
e.prototype._buildTree=function(s,l){this._oRootNode=undefined;var r=null;var R=this._calculateGroupID({context:r,parent:null});var o=this._getNodeState(R);if(!o){var o=this._createNodeState({groupID:R,sum:true,sections:[{startIndex:s,length:l}]});this._updateTreeState({groupID:o.groupID,fallbackNodeState:o,expanded:true});}this._oRootNode=this._createNode({context:r,parent:null,level:this.bDisplayRootNode&&!(r===null)?0:-1,nodeState:o,isLeaf:false,autoExpand:this.getNumberOfExpandedLevels()+1});this._oRootNode.isArtificial=true;if(this._mTreeState.expanded[this._oRootNode.groupID]){this._loadChildContexts(this._oRootNode);}};
e.prototype._calculateRequestLength=function(m,s){var r;if(!m){r=s.length;}else{r=Math.max(Math.min(s.length,m-s.startIndex),0);}return r;};
e.prototype._loadChildContexts=function(n){var N=n.nodeState;var m=this._getMaxGroupSize(n);if(m>0){if(!n.children[m-1]){n.children[m-1]=undefined;}N.leafCount=m;}if(this.bClientOperation){N.sections=[{startIndex:0,length:m}];}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];var r=this._calculateRequestLength(m,o);if(n.autoExpand>=0&&this._autoExpandMode===c.Bundled){r=Math.max(0,m);}var a;if(n.isArtificial){a=this.getRootContexts(o.startIndex,r,this._iThreshold);}else{a=this.nodeHasChildren(n)?this.getNodeContexts(n.context,o.startIndex,r,this._iThreshold):[];}for(var j=0;j<a.length;j++){var b=a[j];if(!b){continue;}var f=j+o.startIndex;var g=n.children[f];var u={context:a[j],parent:n,level:n.level+1,positionInParent:f,autoExpand:Math.max(n.autoExpand-1,-1)};if(g){g.context=u.context;g.parent=u.parent;g.level=u.level;g.positionInParent=u.positionInParent;g.magnitude=0;g.numberOfTotals=0;g.autoExpand=u.autoExpand;var G;if(b){G=this._calculateGroupID(g);}g.groupID=G;}else{g=this._createNode(u);}g.nodeState=this._getNodeState(g.groupID);if(!g.nodeState){g.nodeState=this._createNodeState({groupID:g.groupID,expanded:false});}g.nodeState.parentGroupID=n.groupID;g.isLeaf=!this.nodeHasChildren(g);n.children[f]=g;if(g.isLeaf){n.numberOfLeafs+=1;}if(g.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[g.groupID]){this.setNodeSelection(g.nodeState,true);}if((g.autoExpand>0||g.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[g.groupID]&&!g.isLeaf){this._updateTreeState({groupID:g.nodeState.groupID,fallbackNodeState:g.nodeState,expanded:true});this._loadChildContexts(g);}n.magnitude+=Math.max(g.magnitude||0,0);n.numberOfLeafs+=g.numberOfLeafs;}}}n.magnitude+=Math.max(m||0,0);};
e.prototype.isGrouped=function(){return true;};
e.prototype._calculateGroupID=function(n){q.sap.log.error("TreeBindingAdapter#_calculateGroupID: Not implemented. Needs to be implemented in respective sub-classes.");};
e.prototype._createNode=function(p){p=p||{};var o=p.context;var l=p.level||0;var n={context:o,level:l,children:p.children||[],parent:p.parent,nodeState:p.nodeState,isLeaf:p.isLeaf||false,positionInParent:p.positionInParent,magnitude:p.magnitude||0,numberOfTotals:p.numberOfTotals||0,numberOfLeafs:p.numberOfLeafs||0,autoExpand:p.autoExpand||0,absoluteNodeIndex:p.absoluteNodeIndex||0,totalNumberOfLeafs:0};if(o!==undefined){n.groupID=this._calculateGroupID(n);}return n;};
e.prototype.expand=function(i,s){var n=this.findNode(i);if(!n){return;}this._updateTreeState({groupID:n.nodeState.groupID,fallbackNodeState:n.nodeState,expanded:true});if(!s){this._fireChange({reason:C.Expand});}};
e.prototype.expandToLevel=function(l){this._mTreeState.collapsed={};this.setNumberOfExpandedLevels(l);this._fireChange({reason:C.Expand});};
e.prototype.isExpanded=function(i){var n=this.findNode(i);return n&&n.nodeState?n.nodeState.expanded:false;};
e.prototype.collapse=function(p,s){var n;var t=this;if(typeof p==="object"){n=p;}else if(typeof p==="number"){var N=this.findNode(p);if(!N){return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,fallbackNodeState:n,expanded:false});n.selectAllMode=false;if(this.bCollapseRecursive){var g=n.groupID;q.each(this._mTreeState.expanded,function(G,o){if(q.sap.startsWith(G,g)){t._updateTreeState({groupID:G,expanded:false});}});var D=[];q.each(this._mTreeState.selected,function(G,o){if(q.sap.startsWith(G,g)&&G!==g){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(G);}});if(D.length){var a={rowIndices:[]};var i=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){a.oldIndex=i;a.leadIndex=-1;}a.rowIndices.push(i);}});this._publishSelectionChanges(a);}}if(!s){this._fireChange({reason:C.Collapse});}};
e.prototype.collapseToLevel=function(l){if(!l||l<0){l=0;}var t=this;q.each(this._mTreeState.expanded,function(g,n){var N=t._getGroupIdLevel(g)-1;if(N===l){t.collapse(n,true);}});this._fireChange({reason:C.Collapse});};
e.prototype._map=function(n,m){m.call(this,n);if(!n){return;}for(var i=0;i<n.children.length;i++){var o=n.children[i];this._map(o,m);}if(this._afterMapHook){this._afterMapHook(n,m);}};
e.prototype._match=function(n,r,m,M,p,P){if(r.length===m){return true;}var N=M.call(this,n,p,P);if(N){r.push(n);}if(!n){return false;}for(var i=0;i<n.children.length;i++){var o=n.children[i];var b=this._match(o,r,m,M,i,n);if(b){return true;}}return this._afterMatchHook?this._afterMatchHook(n,r,m,M,p,P):false;};
e.prototype.toggleIndex=function(i){var n=this.findNode(i);if(!n){return;}if(n.nodeState.expanded){this.collapse(i);}else{this.expand(i);}};
e.prototype._getGroupIdLevel=function(g){if(g==null){q.sap.log.warning("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};
e.prototype._getGroupSize=function(n){return this.getChildCount(n.context);};
e.prototype.setNodeSelection=function(n,i){if(!n.groupID){return;}n.selected=i;if(i){this._mTreeState.selected[n.groupID]=n;delete this._mTreeState.deselected[n.groupID];}else{delete this._mTreeState.selected[n.groupID];this._mTreeState.deselected[n.groupID]=n;}};
e.prototype.isIndexSelected=function(r){var n=this.getNodeByIndex(r);return n&&n.nodeState?n.nodeState.selected:false;};
e.prototype.isIndexSelectable=function(r){var n=this.getNodeByIndex(r);return this._isNodeSelectable(n);};
e.prototype._isNodeSelectable=function(n){return!!n&&!n.isArtificial;};
e.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n&&this._isNodeSelectable(n)){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadGroupID=n.groupID;o.leadIndex=r;this.setNodeSelection(n.nodeState,true);this._publishSelectionChanges(o);}else{q.sap.log.warning("TreeBindingAdapter: The selection was ignored. Please make sure to only select rows, for which data has been fetched to the client. For AnalyticalTables, some rows might not be selectable at all.");}};
e.prototype.getSelectedIndex=function(){if(!this._sLeadSelectionGroupID||q.isEmptyObject(this._mTreeState.selected)){return-1;}var n=-1;var m=function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){return true;}}};this._match(this._oRootNode,[],1,m);return n;};
e.prototype.getSelectedIndices=function(){var r=[];var t=this;if(q.isEmptyObject(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(N);t._aRowIndexMap[N]=o;return true;}}};this._match(this._oRootNode,[],n,m);return r;};
e.prototype.getSelectedNodesCount=function(){var s;if(this._oRootNode&&this._oRootNode.nodeState.selectAllMode){var g,v,p,G;var o,V=[];if(this.filterInfo&&this.aAllFilters){for(var i=this.filterInfo.aFilteredContexts.length-1;i>=0;i--){o=this.filterInfo.aFilteredContexts[i];V.push(this._calculateGroupID({context:o}));}}v=0;for(g in this._mTreeState.expanded){if(!this.aAllFilters||V.indexOf(g)!==-1){G=this._mTreeState.expanded[g];if(!G.selectAllMode&&G.leafCount!==undefined){v+=G.leafCount;}}}for(g in this._mTreeState.selected){if(!this.aAllFilters||V.indexOf(g)!==-1){G=this._mTreeState.selected[g];p=this._mTreeState.expanded[G.parentGroupID];if(p&&!p.selectAllMode){v--;}}}for(g in this._mTreeState.deselected){if(!this.aAllFilters||V.indexOf(g)!==-1){G=this._mTreeState.deselected[g];p=this._mTreeState.expanded[G.parentGroupID];if(p&&p.selectAllMode){v++;}}}s=this._getSelectableNodesCount(this._oRootNode)-v;}else{s=Object.keys(this._mTreeState.selected).length;}return s;};
e.prototype._getSelectableNodesCount=function(n){if(n){return n.magnitude;}else{return 0;}};
e.prototype.getSelectedContexts=function(){var r=[];var t=this;if(q.isEmptyObject(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(o.context);t._aRowIndexMap[N]=o;return true;}}};this._match(this._oRootNode,[],n,m);return r;};
e.prototype.setSelectionInterval=function(f,t){var m=this._clearSelection();var s=this._setSelectionInterval(f,t,true);var I={};var r=[];for(var i=0;i<m.rowIndices.length;i++){var a=m.rowIndices[i];I[a]=true;}for(i=0;i<s.rowIndices.length;i++){a=s.rowIndices[i];if(I[a]){delete I[a];}else{I[a]=true;}}for(a in I){if(I[a]){r.push(parseInt(a,10));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadGroupID:s.leadGroupID});};
e.prototype._setSelectionInterval=function(f,t,s){var n=Math.min(f,t);var N=Math.max(f,t);var a=[];var b=[];var i=Math.abs(N-n)+1;var o;var g=-1;var m=function(h){if(!h||!h.isArtificial){g++;}if(h){if(g>=n&&g<=N){if(this._isNodeSelectable(h)){if(h.nodeState.selected!==!!s){b.push(g);}if(h.groupID===this._sLeadSelectionGroupID){o=g;}this.setNodeSelection(h.nodeState,!!s);}return true;}}};this._match(this._oRootNode,a,i,m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadGroupID=l.groupID;p.leadIndex=N;}return p;};
e.prototype.addSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,true);this._publishSelectionChanges(p);};
e.prototype.removeSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,false);this._publishSelectionChanges(p);};
e.prototype.selectAll=function(){this._mTreeState.deselected={};var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){p.oldIndex=n;}if(this._isNodeSelectable(N)){if(N.nodeState.selected!==true){p.rowIndices.push(n);}this.setNodeSelection(N.nodeState,true);p.leadGroupID=N.groupID;p.leadIndex=n;}if(N.nodeState.expanded){N.nodeState.selectAllMode=true;}}});this._publishSelectionChanges(p);};
e.prototype._clearSelection=function(){var n=-1;var o=-1;var m=0;var a=[];for(var g in this._mTreeState.selected){if(g){m++;}}var M=function(N){if(!N||!N.isArtificial){n++;}if(N){N.nodeState.selectAllMode=false;if(this._mTreeState.selected[N.groupID]){if(!N.isArtificial){a.push(n);}this.setNodeSelection(N.nodeState,false);if(N.groupID===this._sLeadSelectionGroupID){o=n;}return true;}}};this._match(this._oRootNode,[],m,M);if(this._oRootNode&&this._oRootNode.nodeState&&this._oRootNode.isArtificial){this._oRootNode.nodeState.selectAllMode=false;}return{rowIndices:a,oldIndex:o,leadIndex:-1};};
e.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};
e.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadGroupID){this._sLeadSelectionGroupID=p.leadGroupID;}else if(p.leadIndex===-1){this._sLeadSelectionGroupID=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};
e.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};
e.prototype.getCollapseRecursive=function(){return this.bCollapseRecursive;};
e.prototype.attachSelectionChanged=function(D,f,l){this.attachEvent("selectionChanged",D,f,l);return this;};
e.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};
e.prototype.fireSelectionChanged=function(a){this.fireEvent("selectionChanged",a);return this;};
return e;},true);
sap.ui.predefine('sap/ui/model/TreeBindingCompatibilityAdapter',['jquery.sap.global'],function(q){"use strict";var T=function(b,t){var a=t;q.extend(b,{_init:function(e){this._bExpandFirstLevel=e;this.mContextInfo={};this._initContexts();if(e&&!this._bFirstLevelExpanded){this._expandFirstLevel();}},_initContexts:function(s){this.aContexts=this.getRootContexts(0,Number.MAX_VALUE);for(var i=0,l=this.aContexts.length;i<l;i++){var o=this._getContextInfo(this.aContexts[i]);this._setContextInfo({oContext:this.aContexts[i],iLevel:0,bExpanded:o?o.bExpanded:false});}if(this._bExpandFirstLevel&&!this._bFirstLevelExpanded){this._expandFirstLevel(s);}},_expandFirstLevel:function(s){var a=this;if(this.aContexts&&this.aContexts.length>0){q.each(this.aContexts.slice(),function(i,c){if(!s){a._loadChildContexts(c);}a._getContextInfo(c).bExpanded=true;});this._bFirstLevelExpanded=true;}},_fnFireFilter:b._fireFilter,_fireFilter:function(){this._fnFireFilter.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_fnFireChange:b._fireChange,_fireChange:function(){this._fnFireChange.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_restoreContexts:function(c){var a=this;var n=[];q.each(c.slice(),function(i,C){var o=a._getContextInfo(C);if(o&&o.bExpanded){n.push.apply(n,a._loadChildContexts(C));}});if(n.length>0){this._restoreContexts(n);}},_loadChildContexts:function(c){var C=this._getContextInfo(c);var I=q.inArray(c,this.aContexts);var n=this.getNodeContexts(c,0,Number.MAX_VALUE);for(var i=0,l=n.length;i<l;i++){this.aContexts.splice(I+i+1,0,n[i]);var o=this._getContextInfo(n[i]);this._setContextInfo({oParentContext:c,oContext:n[i],iLevel:C.iLevel+1,bExpanded:o?o.bExpanded:false});}return n;},_getContextInfo:function(c){return c?this.mContextInfo[c.getPath()]:undefined;},_setContextInfo:function(d){if(d&&d.oContext){this.mContextInfo[d.oContext.getPath()]=d;}},getLength:function(){return this.aContexts?this.aContexts.length:0;},getContexts:function(s,l){return this.aContexts.slice(s,s+l);},getNodes:function(s,l){var c=this.getContexts(s,s+l);var n=[];for(var i=0;i<c.length;i++){var C=this._getContextInfo(c[i])||{};var o=c[i];n.push({context:o,level:C.iLevel,parent:C.oParentContext,nodeState:{expanded:C.bExpanded,collapsed:!C.bExpanded,selected:false}});}return n;},hasChildren:function(){return true;},nodeHasChildren:function(){return true;},getContextByIndex:function(r){return this.aContexts[r];},getLevel:function(c){var C=this._getContextInfo(c);return C?C.iLevel:-1;},isExpanded:function(r){var c=this.getContextByIndex(r);var C=this._getContextInfo(c);return C?C.bExpanded:false;},expandContext:function(c){var C=this._getContextInfo(c);if(C&&!C.bExpanded){this.storeSelection();this._loadChildContexts(c);C.bExpanded=true;this._fireChange();this.restoreSelection();}},expand:function(r){this.expandContext(this.getContextByIndex(r));},collapseContext:function(c,s){var C=this._getContextInfo(c);if(C&&C.bExpanded){this.storeSelection();for(var i=this.aContexts.length-1;i>0;i--){if(this._getContextInfo(this.aContexts[i]).oParentContext===c){this.aContexts.splice(i,1);}}C.bExpanded=false;if(!s){this._fireChange();}this.restoreSelection();}},collapse:function(r){this.collapseContext(this.getContextByIndex(r));},collapseToLevel:function(l){if(!l||l<0){l=0;}var c=this.aContexts.slice();for(var i=c.length-1;i>=0;i--){var C=this.getLevel(c[i]);if(C!=-1&&C>=l){this.collapseContext(c[i],true);}}this._fireChange();},toggleContext:function(c){var C=this._getContextInfo(c);if(C){if(C.bExpanded){this.collapseContext(c);}else{this.expandContext(c);}}},toggleIndex:function(r){this.toggleContext(this.getContextByIndex(r));},storeSelection:function(){var s=a.getSelectedIndices();var S=[];q.each(s,function(i,v){S.push(a.getContextByIndex(v));});this._aSelectedContexts=S;},restoreSelection:function(){a.clearSelection();var _=this._aSelectedContexts;q.each(this.aContexts,function(i,c){if(q.inArray(c,_)>=0){a.addSelectionInterval(i,i);}});this._aSelectedContexts=undefined;},attachSelectionChanged:function(){return undefined;},clearSelection:function(){a._oSelection.clearSelection();},attachSort:function(){},detachSort:function(){}});b._init(t.getExpandFirstLevel());};return T;},true);
sap.ui.predefine('sap/ui/model/TreeBindingUtils',function(){"use strict";var T=function(){};
T.mergeSections=function(s,n){var N=[];for(var i=0;i<s.length;i++){var c=s[i];var C=c.startIndex+c.length;var a=n.startIndex+n.length;if(n.startIndex<=C&&a>=C&&n.startIndex>=c.startIndex){n.startIndex=c.startIndex;n.length=a-c.startIndex;}else if(n.startIndex<=c.startIndex&&a>=c.startIndex&&a<=C){n.length=C-n.startIndex;}else if(n.startIndex>=c.startIndex&&a<=C){n.startIndex=c.startIndex;n.length=c.length;}else if(a<c.startIndex||n.startIndex>C){N.push(c);}}N.push(n);return N;};
T._determineRequestDelta=function(n,p){var N=n.iSkip+n.iTop;var P=p.iSkip+p.iTop;if(n.iSkip===p.iSkip&&n.iTop===p.iTop){return false;}else if(n.iSkip<p.iSkip&&N>p.iSkip&&N<=P){n.iTop=p.iSkip-n.iSkip;if(n.iThreshold){n.iTop=n.iTop+n.iThreshold;n.iSkip=n.iSkip-n.iThreshold;}}else if(n.iSkip<P&&N>P&&n.iSkip>=p.iSkip){n.iSkip=P;n.iTop=N-n.iSkip;if(n.iThreshold){n.iTop+=n.iThreshold;}}else if(n.iSkip>=p.iSkip&&N<=P){return false;}else if(n.iSkip<=p.iSkip&&N>=P){p.oRequestHandle.abort();}else if(N<=p.iSkip||n.iSkip>=P){}};
return T;});
sap.ui.predefine('sap/ui/model/analytics/AnalyticalBinding',['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','sap/ui/model/TreeAutoExpandMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo'],function(Q,T,C,F,a,b,S,c,d,f,B,A){"use strict";var t="sap.ui.model.analytics.AnalyticalBinding";
function u(o){var e=new f.QueryResultRequest(o.oAnalyticalQueryResult),g,s,D,i,j,m,n,p,h=o.mParameters.select.split(","),E=w(h,o.sPath);e.setAggregationLevel(o.aMaxAggregationLevel);e.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(k){D=o.oDimensionDetailsSet[k];e.includeDimensionKeyTextAttributes(k,true,D.textPropertyName!==undefined,D.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(M){m=o.oMeasureDetailsSet[M];e.includeMeasureRawFormattedValueUnit(M,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=e.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=h.indexOf(p);if(j<0){Q.sap.log.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath,t);E=true;}else{h.splice(j,1);}}}for(i=0,n=h.length;i<n;i++){p=h[i];D=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(D&&o.oDimensionDetailsSet[D.getName()]===undefined){v(o.sPath,p,D);E=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){v(o.sPath,p,m);E=true;}}return E?[]:h;}
function v(p,s,D){var e=D instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(D.getName()===s){Q.sap.log.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p,t);}else{Q.sap.log.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+D.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p,t);}}
function w(s,p){var e,E=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){Q.sap.log.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p,t);s.splice(i,1);E=true;}}return E;}
var x=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==c.None){Q.sap.log.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==c.Request||P.countMode==c.Both)){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==c.Request){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){Q.sap.log.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});
function y(o,e){return function(){if(!o.__supportUID){o.__supportUID=Q.sap.uid();}return{type:t,analyticalError:e,analyticalBindingId:o.__supportUID};};}
x.prototype.setContext=function(o){var r;if(this.oContext!==o){this.oContext=o;if(!this.isRelative()){return;}this.oDataState=null;this.bApplySortersToGroups=true;r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}else{this.bInitial=true;}}};
x.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};
x.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};
x.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(x._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(x._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){Q.sap.log.fatal("assertion failed: grand total represented by a single entry");}return r;};
x.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,L,n,e;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;L=p.level;n=p.numberOfExpandedLevels;e=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];L=arguments[4];n=arguments[5];e=arguments[6];}var g=this._getContextsForParentContext(o,s,l,i,L,n,e);return g;};
x.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};
x.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return x.prototype.ContextsAvailabilityStatus.ALL;}else{return x.prototype.ContextsAvailabilityStatus.SOME;}}else{return x.prototype.ContextsAvailabilityStatus.NONE;}};
x.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};
x.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){Q.sap.log.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};
x.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return Q.inArray(this.aAggregationLevel[i-1],this.aMaxAggregationLevel)<this.aMaxAggregationLevel.length-1;};
x.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};
x.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};
x.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};
x.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};
x.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};
x.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};
x.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};
x.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};
x.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};
x.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};
x.prototype.isMeasure=function(p){return Q.inArray(p,this.aMeasureName)!==-1;};
x.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==b.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:C.Filter});return this;};
x.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};
x.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],D=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),e,s,G;if(D&&this.oDimensionDetailsSet[g].textPropertyName){e=D.getTextProperty();}var h,i,j;if(e){h=D.getTextProperty().name;j=this.mAnalyticalInfoByProperty[h]&&this.mAnalyticalInfoByProperty[h].formatter;i=o.getProperty(h);}if(!e){s=V?V(p):p;G=(D.getLabelText?D.getLabelText()+': ':'')+s;}else{s=V?V(p,i):p;G=(D.getLabelText?D.getLabelText()+': ':'')+s;var k=j?j(i,p):i;if(k){G+=' - '+k;}}return G;};
x.prototype.updateAnalyticalInfo=function(e,g){var D,E,h,k=this;function l(G){var L=G.level,N=G.name;h=h||E.getAllHierarchyPropertyNames();h.forEach(function(H){var I=k.oAnalyticalQueryResult.findDimensionByPropertyName(H).getHierarchy(),J=null,K=I.getNodeIDProperty().name,O;if(K===N){J=m(I);}else{O=I.getNodeExternalKeyProperty();if(O&&O.name===N){J=m(I);J.nodeExternalKeyName=N;}else{O=E.getTextPropertyOfProperty(K);if(O&&O.name===N){J=m(I);J.nodeTextName=N;}}}if(J&&"level"in G){if(typeof L==="number"){if("level"in J&&J.level!==L){throw new Error("Multiple different level filter for hierarchy '"+K+"' defined");}J.level=L;J.grouped=!!G.grouped;}else{throw new Error("The level of '"+K+"' has to be an integer value");}}});}function m(H){var N=H.getNodeIDProperty().name,G,I=k.mHierarchyDetailsByName[N];if(!I){G=H.getNodeLevelProperty();I={dimensionName:H.getNodeValueProperty().name,nodeIDName:N,nodeLevelName:G&&G.name};k.mHierarchyDetailsByName[N]=I;}return I;}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}if(Q.sap.equal(this._aLastChangedAnalyticalInfo,e)){if(g){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}E=this.oAnalyticalQueryResult.getEntityType();this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}var p=this.oDimensionDetailsSet||{},P=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};for(var i=0;i<e.length;i++){var o=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(o&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=o.getName();D=this.oDimensionDetailsSet[o.getName()];if(!D){D={};D.name=o.getName();D.aAttributeName=[];D.grouped=false;this.oDimensionDetailsSet[o.getName()]=D;this.aMaxAggregationLevel.push(D.name);if(e[i].grouped==true){this.aAggregationLevel.push(D.name);}}if(e[i].grouped==true){if(Q.inArray(o.getName(),this.getSortablePropertyNames())==-1){Q.sap.log.fatal("property "+o.getName()+" must be sortable in order to be used as grouped dimension");}D.grouped=true;}if(o.getName()==e[i].name){D.keyPropertyName=e[i].name;}var n=o.getTextProperty();if(n&&n.name==e[i].name){D.textPropertyName=e[i].name;}if(o.findAttributeByName(e[i].name)){D.aAttributeName.push(e[i].name);}D.analyticalInfo=e[i];}var M=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(M&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=M.getName();var q=this.oMeasureDetailsSet[M.getName()];if(!q){q={};q.name=M.getName();this.oMeasureDetailsSet[M.getName()]=q;this.aMeasureName.push(q.name);}if(M.getRawValueProperty().name==e[i].name){q.rawValuePropertyName=e[i].name;}var r=M.getFormattedValueProperty();if(r&&r.name==e[i].name){q.formattedValuePropertyName=e[i].name;}q.analyticalInfo=e[i];}if(!o&&!M){l(e[i]);}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}Object.keys(this.mHierarchyDetailsByName).forEach(function(N){var H=k.mHierarchyDetailsByName[N];if(!("level"in H)){delete k.mHierarchyDetailsByName[N];if(Q.sap.log.isLoggable(Q.sap.log.Level.INFO,t)){Q.sap.log.info("No level specified for hierarchy node '"+N+"'; ignoring hierarchy","",t);}}else if(!k.oDimensionDetailsSet[N]){k.oDimensionDetailsSet[N]={aAttributeName:[],grouped:H.grouped,isHierarchyDimension:true,name:N};k.aMaxAggregationLevel.push(N);if(H.grouped){k.aAggregationLevel.push(N);}}});for(var s in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(s).getUnitProperty();if(U){this.oMeasureDetailsSet[s].unitPropertyName=U.name;}}var z=Object.keys(p).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(z){this.iTotalSize=-1;}if(z||Object.keys(P).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=u(this);}if(g){this._fireChange({reason:C.Change});}};
x.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};
x.prototype.loadGroups=function(g){var G=[];for(var s in g){G.push(s);this._resetData(s);var e=g[s];for(var i=0;i<e.length;i++){var o=e[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,h;(h=G[++j])!==undefined;){r.push(this._getRequestId(x._requestType.groupMembersQuery,{groupId:h}));}this._considerRequestGrouping(r);}};
x.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};
x._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};x._artificialRootContextGroupId="artificialRootContext";
x._addHierarchyLevelFilters=function(e,o){e.forEach(function(g){o.removeConditions(g.propertyName);o.addCondition(g.propertyName,a.EQ,g.level);});};
x.prototype._getContextsForParentContext=function(p,s,l,i,L,n,e){if(p===undefined){return[];}if(p&&p.getPath()=="/"+x._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,i,n,e);};
x.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){Q.sap.log.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){Q.sap.log.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){Q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],L,G,o,m;var k=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[k]){this.aMultiUnitLoadFactor[k]=1;}var q=n>0&&p!=null;if(q){var M=this._getGroupIdLevel(p);var r=M+n;var D=true;if(!g){o=this._calculateRequiredGroupExpansion(p,r,s,l+e);D=o.groupId_Missing==null;D=D||o.groupId_Missing.length<p.length||o.groupId_Missing.substring(0,p.length)!=p;}if(D){h=this._getLoadedContextsForGroup(p,s,l);}else{m=l+e;}L=!D;m=Math.ceil(m*this.aMultiUnitLoadFactor[k]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);L=false;if(!g){G=this._calculateRequiredGroupSection(p,s,l,e,h);var P=G.length>0&&l<G.length;L=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;G.length=Math.ceil(G.length*this.aMultiUnitLoadFactor[k]);}}if(!L){this._cleanupGroupingForCompletedRequest(this._getRequestId(x._requestType.groupMembersQuery,{groupId:p}));}var E=false;if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(x._requestType.totalSizeQuery));E=true;var z;if(this.bUseBatchRequests){if(q){z=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=z[++i])!==undefined;){if(this._isRequestPending(R)){E=false;break;}}if(E){this.aBatchRequestQueue.push([x._requestType.groupMembersAutoExpansionQuery,p,o,m,n]);}}else{E=!this._isRequestPending(this._getRequestId(x._requestType.groupMembersQuery,{groupId:p}));if(E){this.aBatchRequestQueue.push([x._requestType.groupMembersQuery,p,G.startIndex,G.length]);z=[this._getRequestId(x._requestType.groupMembersQuery,{groupId:p})];}}if(E&&N){z.push(this._getRequestId(x._requestType.totalSizeQuery));this._considerRequestGrouping(z);this.aBatchRequestQueue.push([x._requestType.totalSizeQuery]);}if(E){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(x.prototype._processRequestQueue.bind(this));}}else{var H;if(q){z=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,I;(I=z[++j])!==undefined;){if(this._isRequestPending(I)){E=false;break;}}if(E){H=this._prepareGroupMembersAutoExpansionQueryRequest(x._requestType.groupMembersAutoExpansionQuery,p,o,m,n);}}else{E=!this._isRequestPending(this._getRequestId(x._requestType.groupMembersQuery,{groupId:p}));if(E){H=this._prepareGroupMembersQueryRequest(x._requestType.groupMembersQuery,p,G.startIndex,G.length);z=[H.sRequestId];}}if(E){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(H);if(N&&!H.bIsFlatListRequest){z.push(this._getRequestId(x._requestType.totalSizeQuery));this._considerRequestGrouping(z);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(x._requestType.totalSizeQuery));}}}}}return h;};
x.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(o,g){var h,H=[],e=this;if(g===null){return H;}h=Object.keys(this.mHierarchyDetailsByName);if(h.length>0&&g!=="/"){Q.sap.log.error("Hierarchy cannot be requested for members of a group",g,t);return H;}h.forEach(function(s){var i=e.mHierarchyDetailsByName[s];o.addRecursiveHierarchy(i.dimensionName,!!i.nodeExternalKeyName,!!i.nodeTextName);H.push({propertyName:i.nodeLevelName,level:i.level});});return H;};
x.prototype._getNonHierarchyDimensions=function(e){var g=this;return e.filter(function(D){return!g.oDimensionDetailsSet[D].isHierarchyDimension;});};
x.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==x._requestType.groupMembersQuery){o=x.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case x._requestType.groupMembersQuery:continue;case x._requestType.totalSizeQuery:if(!e){o=x.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case x._requestType.groupMembersAutoExpansionQuery:o=x.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case x._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:Q.sap.log.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};
x.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[],e=[],h;var o=new f.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var m=0,p=-1;if(g){G=this._getGroupIdComponents(g);m=p=G.length;var U=0;for(var j=0,q=0;j<m;q++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[q]].grouped==false){++U;}else{++j;}}m=p=m+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[p]].grouped==false){if(++p==this.aMaxAggregationLevel.length){break;}}}}var I=p>=this.aMaxAggregationLevel.length-1;h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,g);var z=this.aMaxAggregationLevel.slice(0,p+1);var D=this._getNonHierarchyDimensions(z);o.setAggregationLevel(D);for(var i=0;i<D.length;i++){var E=this.oDimensionDetailsSet[D[i]];var H=(E.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(E.name,true,H,E.aAttributeName);if(E.grouped){e.push({sPath:D[i],bDescending:false});}}var J=o.getFilterExpression();J.clear();if(this.aApplicationFilter){J.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){J.addUI5FilterConditions(this.aControlFilter);}if(m>=1){for(var k=0,l=G.length;k<l;k++){J.removeConditions(this.aAggregationLevel[k]);J.addCondition(this.aAggregationLevel[k],a.EQ,G[k]);}}x._addHierarchyLevelFilters(h,J);var K;var M;var N;var O;var P=[];if(g!=null||this.bProvideGrandTotals||(this._canApplySortersToGroups()&&this.aSorter.length>0)){o.setMeasures(this.aMeasureName);for(var R in this.oMeasureDetailsSet){O=this.oMeasureDetailsSet[R];if(!I&&this.mAnalyticalInfoByProperty[R].total==false){K=false;M=false;N=false;}else{K=(O.rawValuePropertyName!=undefined);M=(O.formattedValuePropertyName!=undefined);N=(O.unitPropertyName!=undefined);if(N){if(Q.inArray(O.unitPropertyName,P)==-1){P.push(O.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(O.name,K,M,N);}for(var n in D){var V;if((V=Q.inArray(D[n],P))!=-1){P.splice(V,1);}}}this._addSorters(o.getSortExpression(),e);if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var W=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){o.setResultPageBoundaries(W.iServiceKeyIndex+1,W.iServiceKeyIndex+L);}o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(x._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:P,aAggregationLevel:z,bIsFlatListRequest:I&&m==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L,oKeyIndexMapping:W};};
x.prototype._prepareTotalSizeQueryRequest=function(r){var h;var o=new f.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,"/");o.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}x._addHierarchyLevelFilters(h,e);o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(x._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};
x.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,L,n){var e=this;var p=function(G,o){var z=[];if(G.groupId_Missing==null){Q.sap.log.fatal("missing group Id not present");return z;}var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;if(s>o){Q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return z;}var k=[];for(var i=0;i<s;i++){var l=e.aAggregationLevel[i];var V=q[i];var U=e._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,U,V);}var W=null;if(G.startIndex_Missing>0){var X=e._getKey(G.groupId_Missing,G.startIndex_Missing-1);var Y=e.oModel.getObject("/"+X);var Z=e.aAggregationLevel[s];var $=Y[Z];W=new F(Z,e._getFilterOperatorMatchingPropertySortOrder(Z,false),$);}for(var E=0;E<o;E++){var _=[];var a1=Math.min(s,E+1);for(var b1=0;b1<a1;b1++){var c1=[];var d1=Math.min(s,b1+1);var e1=G.startIndex_Missing>0;for(var f1=0;f1<d1;f1++){var g1=new F("x",a.EQ,"x");g1=Q.extend(true,g1,k[f1]);if(d1>1&&f1<d1-1){g1.sOperator=a.EQ;}if(f1==s-1&&E>s-1&&!e1){if(g1.sOperator==a.GT){g1.sOperator=a.GE;}else{g1.sOperator=a.LE;}}c1.push(g1);}if(c1.length>0){_.push(new F(c1,true));if(E>s-1&&b1==s-1&&e1){var h1=[];for(var j=0;j<c1.length;j++){var i1=new F("x",a.EQ,"x");i1=Q.extend(true,i1,c1[j]);h1.push(i1);}h1[s-1].sOperator=a.EQ;h1.push(W);_.push(new F(h1,true));break;}}}if(_.length>0){z[E]=new F(_,false);}else{z[E]=null;}}return z;};var h=function(r,g,E,U,H,L,V,W){var X;var Y=new f.QueryResultRequest(e.oAnalyticalQueryResult);Y.setResourcePath(e._getResourcePath());Y.getSortExpression().clear();var Z=0,$=-1;Z=$=E-1;var _=0;for(var i=0,a1=0;i<Z;a1++){if(e.oDimensionDetailsSet[e.aMaxAggregationLevel[a1]].grouped==false){++_;}else{++i;}}Z=$=Z+_;if(e.aMaxAggregationLevel.length>0){while(e.oDimensionDetailsSet[e.aMaxAggregationLevel[$]].grouped==false){if(++$==e.aMaxAggregationLevel.length){break;}}}var b1=$>=e.aMaxAggregationLevel.length-1;X=e._getHierarchyLevelFiltersAndAddRecursiveHierarchy(Y,g);var c1=e.aMaxAggregationLevel.slice(0,$+1);Y.setAggregationLevel(c1);for(var l=0;l<c1.length;l++){var d1=e.oDimensionDetailsSet[c1[l]];var e1=(d1.textPropertyName!=undefined);Y.includeDimensionKeyTextAttributes(d1.name,true,e1,d1.aAttributeName);if(d1.grouped){Y.getSortExpression().addSorter(c1[l],f.SortOrder.Ascending);}}var f1=Y.getFilterExpression();f1.clear();if(e.aApplicationFilter){f1.addUI5FilterConditions(e.aApplicationFilter);}if(e.aControlFilter){f1.addUI5FilterConditions(e.aControlFilter);}if(U){f1.addUI5FilterConditions([U]);}x._addHierarchyLevelFilters(X,f1);var g1;var h1;var i1;var j1;var k1=[];Y.setMeasures(e.aMeasureName);for(var l1 in e.oMeasureDetailsSet){j1=e.oMeasureDetailsSet[l1];if(!b1&&e.mAnalyticalInfoByProperty[l1].total==false){g1=false;h1=false;i1=false;}else{g1=(j1.rawValuePropertyName!=undefined);h1=(j1.formattedValuePropertyName!=undefined);i1=(j1.unitPropertyName!=undefined);if(i1){if(Q.inArray(j1.unitPropertyName,k1)==-1){k1.push(j1.unitPropertyName);}}}Y.includeMeasureRawFormattedValueUnit(j1.name,g1,h1,i1);}for(var j in c1){var m1;if((m1=Q.inArray(c1[j],k1))!=-1){k1.splice(m1,1);}}var n1=Y.getSortExpression();for(var k=0;k<e.aSorter.length;k++){if(e.aSorter[k]){n1.addSorter(e.aSorter[k].sPath,e.aSorter[k].bDescending?f.SortOrder.Descending:f.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var o1=H;if(!W){o1=0;}else{var p1=0;for(var q1 in e.mServiceKey){if(q1.split("/").length===E+1){p1+=e.mServiceKey[q1].length;}}o1=Math.max(o1,p1);}if(!e.bNoPaging){Y.setResultPageBoundaries(o1+1,L);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:Y,iLevel:E,aSelectedUnitPropertyName:k1,aAggregationLevel:c1,bIsFlatListRequest:b1,bIsLeafGroupsRequest:b1,iStartIndex:H,iLength:L,bAvoidLengthUpdate:V};};var m=[];var R=[];if(!G){Q.sap.log.fatal("no first missing group member specified");}var o=this._getGroupIdLevel(g)+n+1;var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;var z=p(G,o);var D;for(var E=1;E<=o;E++){var H;if(E>=s+2){H=0;D=undefined;}else if(E==s+1){H=G.startIndex_Missing;D=G.groupId_Missing;}else if(s>0){if(E==s){D=G.groupId_Missing;}else{D=this._getGroupIdAncestors(G.groupId_Missing,-(s-E))[0];}var I=this._getGroupIdAncestors(G.groupId_Missing,-(s-E+1))[0];if(!I){Q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+E);}H=this._findKeyIndex(I,this.mEntityKey[D]);if(H==-1){Q.sap.log.fatal("failed to determine position of value "+D+" in group "+I);}D=I;H++;}var J=L>E?Math.ceil((L-E)/(o-E+1)):L;var K=z[E-1];if(this.bUseAcceleratedAutoExpand){var M=h(x._requestType.levelMembersQuery,g,E,K,H,J,false,K==null?true:false);M.sGroupId_Missing_AtLevel=D;M.sRequestId=this._getRequestId(x._requestType.levelMembersQuery,{groupId:g,level:E});m.push(M);R.push(M.sRequestId);}else if(K&&K.aFilters.length>0){if(!K._bMultiFilter||K.bAnd){Q.sap.log.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<K.aFilters.length;i++){var N=K.aFilters[i];var O=h(x._requestType.levelMembersQuery,g,E,N,H,J,false,K==null?true:false);O.sGroupId_Missing_AtLevel=D;O.sRequestId=this._getRequestId(x._requestType.levelMembersQuery,{groupId:g,level:E,tupleIndex:i});m.push(O);R.push(O.sRequestId);}}else{var P=h(x._requestType.levelMembersQuery,g,E,null,H,J,false,K==null?true:false);P.sGroupId_Missing_AtLevel=D;P.sRequestId=this._getRequestId(x._requestType.levelMembersQuery,{groupId:g,level:E});m.push(P);R.push(P.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:m,sGroupId:g,iLength:L};};
x.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new f.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var z in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[z];if(Q.inArray(M.name,m.aReloadMeasurePropertyName)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[z].total==false){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(Q.inArray(M.unitPropertyName,s)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var D;if((D=Q.inArray(e[j],s))!=-1){s.splice(D,1);}}return{iRequestType:r,sRequestId:this._getRequestId(x._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};
x.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(x._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};
x.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){Q.sap.log.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var j=o.getURIQueryOptionValue("$skip");var k=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){if(h===null){h=this.mParameters["filter"];}else{h+="and ("+this.mParameters["filter"]+")";}}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(O!==null){P.push("$orderby="+O);}if(j!==null){P.push("$skip="+j);}if(k!==null){P.push("$top="+k);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};
x.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],E=[];function l(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function m(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var D=0;D<r.length;D++){var n=r[D];if(n.aAggregationLevel&&n.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,p;(p=r[++i])!==undefined;){var q=p.oAnalyticalQueryRequest,G=p.sGroupId;if(q.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),x._artificialRootContextGroupId);setTimeout(l);this.bArtificalRootContext=true;continue;}var P=q.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(p.sRequestId)){this._registerNewRequest(p.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(q,p.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var z=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:m,context:this.oContext,urlParameters:U});h.push(z);}E.push(p);}}if(h.length>0){Q.sap.log.debug("AnalyticalBinding: executing batch request with "+E.length+" operations");var H;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);H=this.oModel.submitBatch(I,J,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{H={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:E,binding:this,success:I,error:J});}this._registerNewRequestHandle(R,H);}function I(K,L){g._deregisterHandleOfCompletedRequest(R);if(E.length!=K.__batchResponses.length){Q.sap.log.fatal("assertion failed: received "+K.__batchResponses.length+" responses for "+E.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<E.length;j++){var M=E[j].sRequestId;if(M!==undefined){g._deregisterCompletedRequest(M);g._cleanupGroupingForCompletedRequest(M);}}g.fireDataReceived({data:[]});return;}var N=0;for(var k=0;k<K.__batchResponses.length;k++){if(K.__batchResponses[k].data!=undefined){if(K.__batchResponses[k].data.results.length==0){N++;}switch(E[k].iRequestType){case x._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(E[k],K.__batchResponses[k].data);break;case x._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(E[k],K.__batchResponses[k].data);break;case x._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(E[k],K.__batchResponses[k].data);break;case x._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(E[k],K.__batchResponses[k].data);break;default:Q.sap.log.fatal("invalid request type "+E[k].iRequestType);continue;}}g._deregisterCompletedRequest(E[k].sRequestId);g._cleanupGroupingForCompletedRequest(E[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(N==K.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var O=true;var V;g.fireDataReceived({data:K});var W={};if(g.iModelVersion===A.V1){V=g.oModel._getBatchErrors(K);if(V.length>0){O=false;W=g.oModel._handleError(V[0]);}g.oModel.fireRequestCompleted({url:L.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:W});if(O){g.oModel.checkUpdate();}}}function J(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,K;(K=E[++j])!==undefined;){g._deregisterCompletedRequest(K.sRequestId);g._cleanupGroupingForCompletedRequest(K.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var V=k;if(g.iModelVersion===A.V1){V=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:V});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(V);}g.fireDataReceived();}};
x.prototype._executeQueryRequest=function(r){if(r.iRequestType==x._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,G=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),x._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}Q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,s,E,false,U,l);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p,{success:s,error:E,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function s(D){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case x._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,D);break;case x._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,D);break;case x._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,D);break;case x._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,D);break;default:Q.sap.log.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){l(D);}}function l(D){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:D});}}function E(m){if(m&&m.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};
x.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};
x.prototype._processGroupMembersQueryResponse=function(R,D){var e,G=R.sGroupId,H=this.aSorter.length>0,s=R.aSelectedUnitPropertyName,n=R.aAggregationLevel,z=R.oKeyIndexMapping.iIndex,E=R.oKeyIndexMapping.iServiceKeyIndex,L=R.iLength,K=R.oKeyIndexMapping,I=G==null?0:this._getGroupIdLevel(G)+1,U=(s.length>0),P,J,M,N=0,O,V,W=[];var X=D.results.length;if(G===null&&X>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(H?"binding is refreshed":undefined);if(H){setTimeout(this.refresh.bind(this),0);return;}}var Y=this._getServiceKeys(G,K.iIndex-1);P=undefined;if(Y&&Y.length>0){for(var i=0,Z=Y.length;i<Z;i++){D.results[i-Z]=this.oModel.getObject("/"+Y[i]);}var $=D.results[-Y.length];P="";for(var j=0;j<n.length;j++){P+=$[n[j]]+"|";}}O=Y&&Y.length==1;for(var h=0;h<X;h++){var _=D.results[h];if(U){J="";for(var g=0;g<n.length;g++){J+=_[n[g]]+"|";}if(P==J){this._warnNoSortingOfGroups();if(M===undefined){if(h==0){M=-Y.length;K.iServiceKeyIndex-=Y.length-1;}else{M=h-1;}}var a1=-1,b1=D.results[h-1];for(var k=0;k<s.length;k++){if(b1[s[k]]!=_[s[k]]){a1=k;break;}}if(a1==-1){Q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,y(this,"NO_DEVIATING_UNITS"));}}if((P!=J||h==X-1)&&M!==undefined){var c1=[];for(var l=M;l<h;l++){c1.push(D.results[l]);}if(P==J){c1.push(D.results[h]);}var d1=[];for(var m=0;m<s.length;m++){var e1=s[m];for(var o=1;o<c1.length;o++){if(c1[o-1][e1]!=c1[o][e1]){d1.push(e1);break;}}}var f1=this._createMultiUnitRepresentativeEntry(G,D.results[M],s,d1,R.bIsFlatListRequest);if(f1.aReloadMeasurePropertyName.length>0){V=this._prepareReloadMeasurePropertiesQueryRequest(x._requestType.reloadMeasuresQuery,R,f1);if(V.oAnalyticalQueryRequest&&V.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){W.push(V);}}var g1=this._setAdjacentMultiUnitKeys(K,f1,c1);var h1;if(f1.bIsNewEntry){h1=c1.length-1;}else{h1=g1;}if(O){O=false;}if(h1<0){Q.sap.log.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}N+=h1;var i1=this.oModel._getKey(f1.oEntry);var j1=this.oModel.getContext('/'+i1);this._getGroupIdFromContext(j1,I);this.mEntityKey[e]=i1;M=undefined;if(P!=J){O=this._setServiceKey(K,this.oModel._getKey(_));}}else if(P!=J){O=this._setServiceKey(K,this.oModel._getKey(_));}P=J;}else{this._setServiceKey(K,this.oModel._getKey(_));}if(!R.bIsLeafGroupsRequest){var k1=this._getKey(G,K.iIndex-1);e=this._getGroupIdFromContext(this.oModel.getContext('/'+k1),I);this.mEntityKey[e]=k1;}}var l1=[];if(this.bReloadSingleUnitMeasures&&W.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([x._requestType.reloadMeasuresQuery,W]);Promise.resolve().then(x.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<W.length;q++){var m1=W[q];this._executeQueryRequest(m1);}}for(var p=0;p<W.length;p++){var n1=W[p];l1.push(n1.sRequestId);}this._considerRequestGrouping(l1);}if(Y&&Y.length>0){for(var r=0,o1=Y.length;r<o1;r++){delete D.results[r-o1];}}if(U){N+=this._mergeLoadedKeyIndexWithSubsequentIndexes(K,n,s,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var p1=false;if(D.__count){this.mServiceLength[G]=parseInt(D.__count,10);this.mLength[G]=this.mServiceLength[G]-N;this.mFinalLength[G]=true;if(R.bIsFlatListRequest){this.iTotalSize=D.__count;}p1=true;}if(this.mServiceLength[G]<E+X){this.mServiceLength[G]=E+X;this.mLength[G]=z+X-N;this.mFinalLength[G]=false;}if(X<L||L===undefined){this.mServiceLength[G]=E+X;this.mLength[G]=z+K.iIndex-z;this.mFinalLength[G]=true;p1=true;}if(X==0){this.mLength[G]=this.mServiceLength[G]=0;this.mFinalLength[G]=true;p1=true;}if(!p1&&this.mLength[G]!==undefined&&N>0){this.mLength[G]-=N;}}this.bNeedsUpdate=true;if(N>0){if(D.results.length-N>0){this.aMultiUnitLoadFactor[n.length]=D.results.length/(D.results.length-N);}if(this.aMultiUnitLoadFactor[n.length]<1.5){this.aMultiUnitLoadFactor[n.length]=2;}}Q.sap.log.info("MultiUnit Situation in Group ("+G+"), discarded: "+N+", load-factor is now: "+this.aMultiUnitLoadFactor[n.length]);};
x.prototype._processTotalSizeQueryResponse=function(r,D){if(D.__count==undefined){Q.sap.log.fatal("missing entity count in query result");return;}this.iTotalSize=D.__count;};
x.prototype._processLevelMembersQueryResponse=function(r,D){var e=this;var p,P;var g=function(h,I){var G={iRequestType:x._requestType.groupMembersQuery,sRequestId:e._getRequestId(x._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=G.sGroupId||e._getKeys(G.sGroupId)===undefined)){var s=e._getParentGroupId(G.sGroupId);var j=e._findKeyIndex(s,e.mEntityKey[G.sGroupId]);if(j==-1){Q.sap.log.fatal("assertion failed: failed to determine position of "+G.sGroupId+" in group "+s);}if(j>0&&e._getKey(s,j-1)!==undefined){var k=e._getKey(s,j-1);var l=e._getGroupIdFromContext(e.oModel.getContext('/'+k),e._getGroupIdLevel(G.sGroupId));e.mFinalLength[l]=true;G.iStartIndex=0;}}if(I){G.iLength=P.length;}G.oKeyIndexMapping=e._getKeyIndexMapping(G.sGroupId,G.iStartIndex);var m=Q.extend(true,{},D);m.results=P;e._processGroupMembersQueryResponse(G,m);};if(D.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(D.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<D.results.length;i++){var E=D.results[i];var o=this.oModel.getContext("/"+this.oModel._getKey(D.results[i]));var s=this._getGroupIdFromContext(o,r.iLevel-1);if(p==s){P.push(E);if(i<D.results.length-1){continue;}}g(h,D.results.length==r.iLength&&i==D.results.length-1);h=false;if(p!=s){P=[E];}p=s;}if(D.results.length>1&&P.length==1){g(h,D.results.length==r.iLength);}};
x.prototype._processReloadMeasurePropertiesQueryResponse=function(r,D){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(D.results.length!=1){Q.sap.log.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=D.results[0];var o=this.oModel.getObject("/"+M);if(!o){Q.sap.log.fatal("assertion failed: no entity found with key "+M);return;}var e=m.aReloadMeasurePropertyName;for(var i=0;i<e.length;i++){o[e[i]]=R[e[i]];}};
x.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};
x.prototype._calculateRequiredGroupSection=function(g,s,l,e,h){var k,m,p,P,r,o={},K=this._getKeys(g),n;m=s;k=0;if(!K){P=s;p=s+l;}else{for(var i=s-1;i>=Math.max(s-e,0);i--){n=K(i);if(!n){P=i+1;break;}}for(var j=s+l;j<s+l+e;j++){n=K(j);if(!n){p=j;break;}}}r=s-P;if(P&&s>e&&r<e){if(h.length!==l){m=s-e;}else{m=P-e;}k=e;}m=Math.max(m,0);if(m===s){m+=h.length;}if(h.length!==l){k+=l-h.length;}r=p-s-l;if(r==0){k+=e;}if(p&&r<e&&r>0){if(m>s){m=p;k+=e;}}if(this.mFinalLength[g]&&this.mLength[g]<(k+m)){k=this.mLength[g]-m;}o.startIndex=m;o.length=k;return o;};
x.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var L=h._getGroupIdLevel(g);if(L==e){var z=h._getLoadedContextsForGroup(g,s,l);var D=s+z.length-1;if(z.length>=l){return n;}else if(h.mFinalLength[g]){if(z.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-z.length};}else{return{groupId_Missing:g,startIndex_Missing:D+1,length_Missing:l-z.length};}}else{return{groupId_Missing:g,startIndex_Missing:D+1,length_Missing:l-z.length};}}var E=h._getLoadedContextsForGroup(g,s,l);var k=l,H=s+E.length-1;for(var i=-1,I;(I=E[++i])!==undefined;){k--;var G=j(h._getGroupIdFromContext(I,L+1),e,0,k);if(G.groupId_Missing==null){if(G.length_Missing==0){return G;}else{k=G.length_Missing;}}else{return G;}if(k==0){break;}}if(h.mFinalLength[g]||k==0){return{groupId_Missing:null,length_Missing:k};}else{return{groupId_Missing:g,startIndex_Missing:H+1,length_Missing:k};}};var L=this._getGroupIdLevel(g);if(L==e+1){g=this._getParentGroupId(g);--L;}if(g==null||L>e){return n;}var k=l,m=s;while(g!=null){var G=j(g,e,m,k);if(G.groupId_Missing!=null){return G;}else if(G.length_Missing==0){return G;}else{var o=false;while(!o){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break;}var q=this.mEntityKey[g];if(!q){return n;}var r=this._findKeyIndex(p,q);if(r==-1){return n;}if(r==this._getKeyCount(p)-1){if(this.mFinalLength[p]){g=p;--L;continue;}else{return{groupId_Missing:p,startIndex_Missing:r+1,length_Missing:k};}}else{q=this._getKey(p,r+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+q),L);o=true;}}m=0;k=G.length_Missing;}}return{groupId_Missing:null,length_Missing:k};};
x.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};
x.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};
x.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?f.SortOrder.Descending:f.SortOrder.Ascending;}}return null;};
x.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case f.SortOrder.Ascending:if(W){s=a.GE;}else{s=a.GT;}break;case f.SortOrder.Descending:if(W){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};
x.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};
x.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var D=null;if(l>this.aAggregationLevel.length){Q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){D=o.getProperty(this.aAggregationLevel[i]);if(D!=null){g+=encodeURIComponent(D)+"/";}else{g+="@/";}}return g;};
x.prototype._getGroupIdLevel=function(g){if(g==null){Q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};
x.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var G=g.split("/");var D=[];for(var i=1;i<G.length-1;i++){if(G[i]=="@"){D[i-1]=null;}else{D[i-1]=decodeURIComponent(G[i]);}}return D;};
x.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){Q.sap.log.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var G=g.split("/");var e=[],s="";var h=0,k=G.length-3;if(n>0){if(n-1>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=n-1;}}else if(-(n+1)>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{h=k+1+n;for(var i=0;i<h;i++){s+=G[i]+"/";}}for(var j=h;j<=k;j++){s+=G[j]+"/";e.push(s);}return e;};
x.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};
x.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};
x.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};
x.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){Q.sap.log.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};
x.prototype._deregisterHandleOfCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequestHandle)){Q.sap.log.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){Q.sap.log.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};
x.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};
x.prototype._getRequestId=function(r,p){switch(r){case x._requestType.groupMembersQuery:if(p.groupId===undefined){Q.sap.log.fatal("missing group ID");}return x._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case x._requestType.levelMembersQuery:if(p.level===undefined){Q.sap.log.fatal("missing level");}if(p.groupId===undefined){Q.sap.log.fatal("missing groupId");}return""+x._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case x._requestType.totalSizeQuery:return x._requestType.totalSizeQuery;case x._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){Q.sap.log.fatal("missing multi unit entry key");}return x._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:Q.sap.log.fatal("invalid request type "+r);return-1;}};
x.prototype._registerNewRequest=function(r){if(r==undefined||r==""){Q.sap.log.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};
x.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};
x.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};
x.prototype._deregisterCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequests)){Q.sap.log.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){Q.sap.log.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};
x.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};
x.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var e=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}var L;if(l==0){L=0;}else{if(k[l]>=0){L=k[l];}else if(k[l+1]===undefined){L=k[l]=="ZERO"?0:-k[l];while(e[L+1]!==undefined){++L;}}else{L=Math.abs(k[l+1])-1;}if(e[L]===undefined){Q.sap.log.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+L);}}var D=s-l;i=L+D;}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K;};
x.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};
x.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};
x.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};
x.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var G=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){G.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){G.push(s[i]);}}return G;};
x.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};
x.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};
x.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};
x.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};
x.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],D=0,n=k.iServiceKeyIndex,h=k.iIndex;var M,o;if(K===undefined){return D;}var N=false;var p=g[n-1],j=g[n];if(j===undefined){return D;}if(p===undefined){Q.sap.log.fatal("assertion failed: missing expected entry before given key index");return D;}var P=this.oModel.getObject("/"+p);var l=this.oModel.getObject("/"+j);var q="",r="";for(var i=0;i<e.length;i++){q+=P[e[i]]+"|";r+=l[e[i]]+"|";}N=q==r;var z=h;if(z>=this.mLength[k.sGroupId]){Q.sap.log.fatal("assertion failed: service key exists,but no corresponding key index found");return D;}while(K[z]===undefined||Math.abs(K[z])<n){++z;}if(N){if(Math.abs(K[z])==n&&K[z]<0){if(z>h){if(K[h-1]<0){m[z]=undefined;K.splice(h,z-h+1);m.splice(h,z-h+1);}else{K[h-1]=-K[h-1];m[h-1]=m[z];m[z]=undefined;K.splice(h,z-h+1);m.splice(h,z-h+1);D=1;}}}else if(Math.abs(K[z])>n){var E=z-1;if(K[E]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[E]=-K[E];m[E]=o;if(E>h){K.splice(h,E-h);m.splice(h,E-h);}if(M.bIsNewEntry){D=1;}else{D=0;}}else if(K[h-1]<0){if(z>h){m[E]=undefined;K.splice(h,E-h+1);m.splice(h,E-h+1);}}else{K[h-1]=-K[h-1];m[h-1]=m[E];m[E]=undefined;K.splice(h,E-h+1);m.splice(h,E-h+1);}}else if(K[z]==n){if(z>h){if(K[h-1]<0){K.splice(h,z-h+1);m.splice(h,z-h+1);D=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){Q.sap.log.fatal("assertion failed: multi-unit entry already existed before");}K[h-1]=-K[h-1];m[h-1]=o;K.splice(h,z-h+1);m.splice(h,z-h+1);D=1;}}}else{Q.sap.log.fatal("assertion failed: uncovered case detected");return D;}}else if(K[z]>n){Q.sap.log.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(z-h>0){K.splice(h,z-h);m.splice(h,z-h);}return D;};
x.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,D,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(D){if(!o.unitPropertyName||Q.inArray(o.unitPropertyName,D)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(Q.inArray(s[k],D)!=-1){m[s[k]]="*";}}var e="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var h=m[this.aAllDimensionSortedByName[l]];var j=h===""?'""':h;j=j===undefined?"":j;e+=(encodeURIComponent(j)+",");}e+="-multiple-units-not-dereferencable";var n;if(this.mMultiUnitKey[g]&&(n=Q.inArray(e,this.mMultiUnitKey[g]))!=-1){return{oEntry:this.oModel.getObject("/"+e),bIsNewEntry:false,iIndex:n,aReloadMeasurePropertyName:R};}m.__metadata.uri=e;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var p=this.oModel._getKey(m);this.oModel.getContext('/'+p)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};
x.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};
x.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};
x.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};
x.prototype.refresh=function(e){x.prototype._refresh.apply(this,arguments);};
x.prototype._refresh=function(e,m,E){var g=false;if(!e){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in E)){g=true;}}if(m&&!g){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}if(!m&&!E){g=true;}}if(e||g){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};
x.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};
x.prototype.getDownloadUrl=function(s){var e,p,z;var o=new f.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var D in this.oDimensionDetailsSet){g.push(D);}o.setAggregationLevel(g);for(var n in this.oDimensionDetailsSet){var q=this.oDimensionDetailsSet[n];var I=(q.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(q.name,true,I,q.aAttributeName);}for(var M in this.oMeasureDetailsSet){h.push(M);}o.setMeasures(h);for(var r in this.oMeasureDetailsSet){var E=this.oMeasureDetailsSet[r];var G=(E.rawValuePropertyName!=undefined);var H=(E.formattedValuePropertyName!=undefined);var J=(E.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(E.name,G,H,J);}var K=o.getSortExpression();K.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){K.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?f.SortOrder.Descending:f.SortOrder.Ascending);}}var L=o.getFilterExpression();L.clear();if(this.aApplicationFilter){L.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){L.addUI5FilterConditions(this.aControlFilter);}var P=o.getURIToQueryResultEntitySet();var N=this._getQueryODataRequestOptions(o,true);if(!N){return undefined;}var O=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var R=this.aAnalyticalInfo[k];if((R.visible||R.inResult)&&R.name!==""&&R.name!==O[O.length-1]){O.push(R.name);if(this.oMeasureDetailsSet[R.name]!=undefined&&this.oMeasureDetailsSet[R.name].unitPropertyName!=undefined){O.push(this.oMeasureDetailsSet[R.name].unitPropertyName);}}}for(var j=0,l=N.length;j<l;j++){if(/^\$select/i.test(N[j])){if(this.mParameters.select){e=N[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(O.indexOf(p)===-1){O.push(p);}}}N[j]="$select="+O.join(",");break;}}if(s){N.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){N.push(this.sCustomParams);}if(P){return this.oModel._createRequestUrl(P,null,N).replace(/ /g,"%20");}};
x.prototype._addSorters=function(s,g){var e=this._canApplySortersToGroups()?[].concat(this.aSorter).concat(g):[].concat(g).concat(this.aSorter);e.forEach(function(o){s.addSorter(o.sPath,o.bDescending?f.SortOrder.Descending:f.SortOrder.Ascending);});};
x.prototype._canApplySortersToGroups=function(){var s=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(s!==this.sLastAutoExpandMode&&s!==d.Sequential){Q.sap.log.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+s,this.sPath,t);}this.sLastAutoExpandMode=s;}return s===d.Sequential;}return false;};
x.prototype._warnNoSortingOfGroups=function(D){var m;if(this.bApplySortersToGroups){m="Detected a multi-unit case, so sorting is only possible on leaves";if(D){m+="; "+D;}Q.sap.log.warning(m,this.sPath,t);}this.bApplySortersToGroups=false;};
return x;});
sap.ui.predefine('sap/ui/model/analytics/AnalyticalTreeBindingAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','./AnalyticalBinding','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/odata/ODataTreeBindingAdapter','sap/ui/model/TreeBindingAdapter','sap/ui/model/TreeBindingUtils'],function(q,T,A,a,C,O,b,c){"use strict";var d=function(){if(!(this instanceof T)||this._bIsAdapted){return;}O.apply(this);for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this.setAutoExpandMode(this.mParameters.autoExpandMode||a.Bundled);};
d.prototype.getGrandTotalContext=function(){if(this._oRootNode){return this._oRootNode.context;}};
d.prototype.getGrandTotalNode=function(){if(this._oRootNode){return this._oRootNode;}};
d.prototype.getGrandTotalContextInfo=function(){return this._oRootNode;};
d.prototype.getLength=function(){if(!this._oRootNode){return 0;}if(this._oRootNode&&this._oWatermark&&this._isRunningInAutoExpand(a.Bundled)){if(this._oWatermark.groupID===this._oRootNode.groupID){return this._oRootNode.magnitude+this._oRootNode.numberOfTotals;}return this._oWatermark.absoluteNodeIndex+this._oRootNode.numberOfTotals+1;}return this._oRootNode.magnitude+this._oRootNode.numberOfTotals;};
d.prototype.getContextByIndex=function(i){if(this._oRootNode&&i===(this.getLength()-1)&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode.context;}var n=this.findNode(i);if(!n||!n.context){n={context:this.getContexts(i,1,0)[0]};}return n?n.context:undefined;};
d.prototype.getNodeByIndex=function(i){if(i===(this.getLength()-1)&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};
d.prototype._isNodeSelectable=function(n){if(!n){return false;}return n.isLeaf&&!n.isArtificial;};
d.prototype.getContexts=function(s,l,t,r){if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}this._iPageSize=l;this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(s,l);var n=[];if(this._oRootNode){n=this._retrieveNodeSection(this._oRootNode,s,l);}this._updateRowIndexMap(n,s);var e=[];var m;for(var i=0;i<n.length;i++){var N=n[i];if(this._isRunningInAutoExpand(a.Bundled)&&this._oWatermark){if(N.groupID===this._oWatermark.groupID||(this._oWatermark.groupID===this._oRootNode.groupID&&(s+i+1)==this.getLength()-1)){this._autoExpandPaging();}}if(!N.context){m=m||{};var p=N.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:N.positionInParent,length:1});}e.push(N.context);}if(m){var f=this;q.each(m,function(g,N){N.magnitude=0;N.numberOfTotals=0;f._loadChildContexts(N,{absoluteNodeIndex:N.absoluteNodeIndex});});e=[];for(var j=0;j<n.length;j++){var N=n[j];e.push(N.context);}}if(r){return n;}else{return e;}};
d.prototype._autoExpandPaging=function(){var e=this.getNodeContexts(this._oWatermark.context,{startIndex:this._oWatermark.startIndex,length:this._iPageSize,threshold:this._iThreshold,level:this._oWatermark.level,numberOfExpandedLevels:this._oWatermark.autoExpand});return e;};
d.prototype._afterMatchHook=function(n,r,m,M,p,P){if(n.sumNode&&n!==this._oRootNode){if(r.length===m){return true;}var N=M.call(this,n.sumNode,n.sumNode.positionInParent,P);if(N){r.push(n.sumNode);}}};
d.prototype._afterMapHook=function(n,m){if(n.sumNode&&n!==this._oRootNode){m.call(this,n.sumNode);}};
d.prototype._createSumNode=function(n){var s;if(this.bProvideGrandTotals&&!this.mParameters.sumOnTop&&this.hasTotaledMeasures()&&n.children.length>1){s=this._createNode({parent:n.parent,positionInParent:n.children.length,context:n.context,level:n.level});s.nodeState=this._createNodeState({groupID:s.groupID,sum:true,expanded:false});}return s;};
d.prototype._buildTree=function(s,l){this._oRootNode=undefined;this._oWatermark=undefined;var n=this.mParameters&&this.getNumberOfExpandedLevels();var r=this.getRootContexts({startIndex:0,length:this._iPageSize,threshold:this._iThreshold,numberOfExpandedLevels:this._autoExpandMode===a.Bundled?n:undefined});var R;if(r==null){q.sap.log.warning("AnalyticalTreeBindingAdapter: No Dimensions given. An artificial rootContext has be created. Please check your Table/Service definition for dimension columns!");}else{R=r[0];}if(!R){return;}var o=this._getNodeState("/");if(!o){o=this._updateTreeState({groupID:"/",expanded:true,sum:true});this._updateNodeSections("/",{startIndex:0,length:l});}this._oRootNode=this._createNode({context:R,parent:null,level:0,nodeState:o,isLeaf:false,autoExpand:n,absoluteNodeIndex:-1});this._oRootNode.isArtificial=true;this._loadChildContexts(this._oRootNode,{absoluteNodeIndex:-1});};
d.prototype._loadChildContexts=function(n,r){var N=n.nodeState;var m=this.getGroupSize(n.context,n.level);if(m>=0){if(!n.children[m-1]){n.children[m-1]=undefined;}if(n.level===this.aAggregationLevel.length){N.leafCount=m;}n.sumNode=this._createSumNode(n);}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];if(o.startIndex>n.children.length){continue;}var R;if(m===-1){R=o.length;}else{R=Math.min(o.length,m-o.startIndex);}var s=false;if(n.autoExpand>=0&&this._isRunningInAutoExpand(a.Bundled)){s=true;R=Math.max(0,m);}var e=this.getNodeContexts(n.context,{startIndex:o.startIndex,length:R,threshold:s?0:this._iThreshold,level:n.level,supressRequest:s});for(var j=0;j<e.length;j++){var f=e[j];var g=j+o.startIndex;var h=n.children[g];var u={context:e[j],parent:n,level:n.level+1,positionInParent:g,autoExpand:Math.max(n.autoExpand-1,-1),absoluteNodeIndex:(++r.absoluteNodeIndex)};if(h){h.context=u.context;h.parent=u.parent;h.level=u.level;h.positionInParent=u.positionInParent;h.magnitude=0;h.numberOfTotals=0;h.totalNumberOfLeafs=0;h.autoExpand=u.autoExpand;h.absoluteNodeIndex=u.absoluteNodeIndex;var G;if(f){G=this._calculateGroupID(h);}h.groupID=G;}else{h=this._createNode(u);}h.nodeState=this._getNodeState(h.groupID);if(!h.nodeState){h.nodeState=this._createNodeState({groupID:h.groupID,expanded:false});}h.nodeState.parentGroupID=n.groupID;h.isLeaf=!this.nodeHasChildren(h);n.children[g]=h;if(h.isLeaf){n.numberOfLeafs+=1;}if(h.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[h.groupID]&&h.isLeaf){this.setNodeSelection(h.nodeState,true);}if((h.autoExpand>=0||h.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[h.groupID]){if(h.autoExpand>=0&&h.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[h.groupID]){if(h.nodeState.selectAllMode===undefined){h.nodeState.selectAllMode=true;}}this._updateTreeState({groupID:h.nodeState.groupID,fallbackNodeState:h.nodeState,expanded:true});this._loadChildContexts(h,r);}n.magnitude+=h.magnitude;n.numberOfTotals+=h.numberOfTotals;n.numberOfLeafs+=h.numberOfLeafs;}if(h&&h.isLeaf){n.totalNumberOfLeafs=m;}else{n.totalNumberOfLeafs+=h.totalNumberOfLeafs;}}}m=this._isRunningInAutoExpand(a.Bundled)?n.children.length:m;n.magnitude+=Math.max(m||0,0);if(!m&&!this._isRunningInAutoExpand(a.Bundled)){q.sap.log.warning("AnalyticalTreeBindingAdapter: iMaxGroupSize("+m+") is undefined for node '"+n.groupID+"'!");}if(n.sumNode||(n===this._oRootNode&&this.providesGrandTotal()&&this.hasTotaledMeasures())){n.numberOfTotals+=1;}if(this._isRunningInAutoExpand(a.Bundled)&&n.autoExpand!=-1){if(!this._oWatermark&&!n.isLeaf&&!this.mFinalLength[n.groupID]){this._oWatermark={groupID:n.groupID,context:n.context,absoluteNodeIndex:n.absoluteNodeIndex,startIndex:n.children.length,level:n.level,autoExpand:n.autoExpand};}}};
d.prototype._calculateGroupID=function(n){var g;var m=this.aAggregationLevel.length;if(!this.isGrouped()&&n&&n.positionInParent){g="/"+n.positionInParent+"/";}else{if(n.level>m){g=this._getGroupIdFromContext(n.context,m);g+=n.positionInParent+"/";}else{g=this._getGroupIdFromContext(n.context,n.level);}}return g;};
d.prototype.collapse=function(p){var n,N;if(typeof p==="object"){n=p;}else if(typeof p==="number"){N=this.findNode(p);if(!N){return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,expanded:false});n.selectAllMode=false;var e=false;if(this.bCollapseRecursive||this._isRunningInAutoExpand(a.Bundled)){var g=n.groupID;if(this._isRunningInAutoExpand(a.Bundled)&&this._oWatermark&&q.sap.startsWith(this._oWatermark.groupID,g)){if(N&&N.parent){this._oWatermark={groupID:N.parent.groupID,context:N.parent.context,absoluteNodeIndex:N.parent.absoluteNodeIndex,startIndex:N.positionInParent+1,level:N.parent.level,autoExpand:N.parent.autoExpand};}this._autoExpandPaging();e=true;}var t=this;q.each(this._mTreeState.expanded,function(G,o){if(q.sap.startsWith(G,g)){t._updateTreeState({groupID:G,expanded:false});}});var D=[];q.each(this._mTreeState.selected,function(G,o){if(q.sap.startsWith(G,g)){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(G);}});if(D.length){var s={rowIndices:[]};var i=0;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){s.oldIndex=i;s.leadIndex=-1;}s.rowIndices.push(i);}});this._publishSelectionChanges(s);}}if(!e){this._fireChange({reason:C.Collapse});}};
d.prototype.collapseToLevel=function(l){this.setNumberOfExpandedLevels(l,true);b.prototype.collapseToLevel.call(this,l);};
d.prototype.nodeHasChildren=function(n){if(!n||!n.parent||n.nodeState.sum){return false;}else if(n.isArtificial){return true;}else{return A.prototype.hasChildren.call(this,n.context,{level:n.level});}};
d.prototype.resetData=function(o,p){var r=A.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._oWatermark=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==C.Sort){this.clearSelection();this._createTreeState(true);}return r;};
d.prototype.hasTotaledMeasures=function(){var h=false;q.each(this.getMeasureDetails()||[],function(i,m){if(m.analyticalInfo.total){h=true;return false;}});return h;};
d.prototype.isGrouped=function(){return(this.aAggregationLevel.length>0);};
d.prototype._isRunningInAutoExpand=function(s){if(this.getNumberOfExpandedLevels()>0&&this._autoExpandMode===s){return true;}else{return false;}};
d.prototype.setNumberOfExpandedLevels=function(l,s){l=l||0;if(l<0){q.sap.log.warning("AnalyticalTreeBindingAdapter: numberOfExpanded levels was set to 0. Negative values are prohibited.");l=0;}if(!s){this.resetData();}this.mParameters.numberOfExpandedLevels=l;};
d.prototype.getNumberOfExpandedLevels=function(){return this.mParameters.numberOfExpandedLevels;};
d.prototype._getSelectableNodesCount=function(n){if(n){return n.totalNumberOfLeafs;}else{return 0;}};
return d;},true);
sap.ui.predefine('sap/ui/model/analytics/AnalyticalVersionInfo',['jquery.sap.global'],function(q){"use strict";var A={NONE:null,V1:1,V2:2,getVersion:function(o){var v;var O;if(o&&o.getMetadata){O=o.getMetadata().getName();}switch(O){case"sap.ui.model.odata.ODataModel":v=this.V1;break;case"sap.ui.model.odata.v2.ODataModel":v=this.V2;break;default:v=this.NONE;q.sap.log.info("AnalyticalVersionInfo.getVersion(...) - The given object is no instance of ODataModel V1 or V2!");break;}return v;}};return A;},true);
sap.ui.predefine('sap/ui/model/analytics/BatchResponseCollector',function(){"use strict";
function B(p){if(p){this.setup(p);}}
B.TYPE_SUCCESS="success";B.TYPE_ERROR="error";
B.prototype.setup=function(p){this.iRequestCollectionCount=0;this.aCollectedSuccesses=[];this.aCollectedErrors=[];this.aExecutedRequestDetails=p.executedRequests;this.oAnalyticalBinding=p.binding;this.fnSuccessHandler=p.success;this.fnErrorHandler=p.error;};
B.prototype.success=function(r){this.collect(r,B.TYPE_SUCCESS);};
B.prototype.error=function(r){this.collect(r,B.TYPE_ERROR);};
B.prototype.collect=function(r,R){this.iRequestCollectionCount++;if(R===B.TYPE_SUCCESS){this.aCollectedSuccesses.push(r);}else{this.aCollectedErrors.push(r);}var o=(this.aCollectedSuccesses.length+this.aCollectedErrors.length);if(o===this.aExecutedRequestDetails.length){if((this.aCollectedSuccesses.length===o)&&this.aCollectedErrors.length===0){this.fnSuccessHandler.call(window,{__batchResponses:this.aCollectedSuccesses},{requestUri:this.oAnalyticalBinding.oModel.sServiceUrl+"/$batch"});}else{this.fnErrorHandler.call(window,this.aCollectedErrors[0]||{});}}};
return B;},true);
sap.ui.predefine('sap/ui/model/analytics/ODataModelAdapter',['jquery.sap.global','./AnalyticalBinding',"./AnalyticalTreeBindingAdapter",'./odata4analytics','./AnalyticalVersionInfo'],function(q,A,a,o,b){"use strict";var O=function(){var m=b.getVersion(this);if(m===b.NONE||this.getAnalyticalExtensions){return;}this._mPreadapterFunctions={bindList:this.bindList,bindTree:this.bindTree};for(var f in O.prototype){if(O.prototype.hasOwnProperty(f)){this[f]=O.prototype[f];}}if(m===b.V1&&this.isCountSupported()){q.sap.log.info("ODataModelAdapter: switched ODataModel to use inlinecount (mandatory for the AnalyticalBinding)");this.setCountSupported(false);}};
O.prototype.bindList=function(p,c,s,f,P){if(P&&P.analyticalInfo){var B=new A(this,p,c,s,f,P);a.apply(B);return B;}else{return this._mPreadapterFunctions.bindList.apply(this,arguments);}};
O.prototype.bindTree=function(p,c,f,P){if(P&&P.analyticalInfo){var B=new A(this,p,c,[],f,P);return B;}else{return this._mPreadapterFunctions.bindTree.apply(this,arguments);}};
O.prototype.getAnalyticalExtensions=function(){if(this.oOData4SAPAnalyticsModel!=undefined&&this.oOData4SAPAnalyticsModel!=null){return this.oOData4SAPAnalyticsModel;}var m=b.getVersion(this);if(m===b.V2&&!(this.oMetadata&&this.oMetadata.isLoaded())){throw"Failed to get the analytical extensions. The metadata have not been loaded by the model yet."+"Register for the 'metadataLoaded' event of the ODataModel(v2) to know when the analytical extensions can be retrieved.";}var s=null;if(arguments.length==1){var c=arguments[0];var r=q.sap.syncGetText(c);if(r.success){s=r.data;}}try{this.oOData4SAPAnalyticsModel=new o.Model(new o.Model.ReferenceByModel(this),{sAnnotationJSONDoc:s});}catch(e){throw"Failed to instantiate analytical extensions for given OData model: "+e.message;}return this.oOData4SAPAnalyticsModel;};
O.prototype.setAnalyticalExtensions=function(c){this.oOData4SAPAnalyticsModel=c;};
return O;},true);
sap.ui.predefine('sap/ui/model/analytics/odata4analytics',['jquery.sap.global','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/Sorter','./AnalyticalVersionInfo'],function(q,F,c,S,A){"use strict";var o=o||{};o.constants={};o.constants["SAP_NAMESPACE"]="http://www.sap.com/Protocols/SAPData";o.constants["VERSION"]="0.7";o.helper={tokenizeNametoLabelText:function(n){var l="";l=n.replace(/^P_(.*)/,"$1");l=l.replace(/([^A-Z0-9_]+)([A-Z0-9_])/g,"$1 $2");l=l.replace(/([A-Z0-9_]{2,})([A-Z0-9_])([^A-Z0-9_]+)/g,"$1 $2$3");l=l.replace(/(.*) _E$/,"$1");l=l.replace(/(.*) _(.*)/g,"$1 $2");return l;}};
o.Model=function(m,p){this._init(m,p);};
o.Model.ReferenceByURI=function(u){return{sServiceURI:u};};
o.Model.ReferenceByModel=function(m){return{oModel:m};};
o.Model.ReferenceWithWorkaround=function(m,w){return{oModelReference:m,aWorkaroundID:w};};
o.Model.prototype={_init:function(m,p){if(typeof p=="string"){throw"Deprecated second argument: Adjust your invocation by passing an object with a property sAnnotationJSONDoc as a second argument instead";}this._mParameter=p;var t=this;this._oActivatedWorkarounds={};if(m&&m.aWorkaroundID){for(var i=-1,I;(I=m.aWorkaroundID[++i])!==undefined;){this._oActivatedWorkarounds[I]=true;}m=m.oModelReference;}if(!m||(!m.sServiceURI&&!m.oModel)){throw"Usage with oModelReference being an instance of Model.ReferenceByURI or Model.ReferenceByModel";}if(m.oModel){this._oModel=m.oModel;this._iVersion=A.getVersion(this._oModel);a();}else if(p&&p.modelVersion===A.V2){var V=sap.ui.requireSync("sap/ui/model/odata/v2/ODataModel");this._oModel=new V(m.sServiceURI);this._iVersion=A.V2;a();}else{var O=sap.ui.requireSync("sap/ui/model/odata/ODataModel");this._oModel=new O(m.sServiceURI);this._iVersion=A.V1;a();}if(this._oModel.getServiceMetadata().dataServices==undefined){throw"Model could not be loaded";}function a(){if(!t._oModel.getServiceMetadata()){t._oModel.attachMetadataLoaded(b);}else{b();}}function b(){if(t.bIsInitialized){return;}t.bIsInitialized=true;if(p&&p.sAnnotationJSONDoc){t.mergeV2Annotations(p.sAnnotationJSONDoc);}t._interpreteMetadata(t._oModel.getServiceMetadata().dataServices);}},_interpreteMetadata:function(M){this._oQueryResultSet={};this._oParameterizationSet={};this._oEntityTypeSet={};this._oEntitySetSet={};this._oEntityTypeNameToEntitySetMap={};var a=this._oModel.getServiceMetadata().dataServices.schema[0];for(var j=-1,C;(C=a.entityContainer[++j])!==undefined;){if(C.isDefaultEntityContainer=="true"){this._oDefaultEntityContainer=C;break;}}var e=a.entityType;var Q=[],P=[],u=[];for(var k=-1,T;(T=e[++k])!==undefined;){var b=false;if(T.extensions!=undefined){for(var l=-1,E;(E=T.extensions[++l])!==undefined;){if(E.namespace==o.constants.SAP_NAMESPACE&&E.name=="semantics"){b=true;switch(E.value){case"aggregate":Q.push(T);break;case"parameters":P.push(T);break;default:u.push(T);}}if(b){continue;}}if(!b){u.push(T);}}else{u.push(T);}}for(var m=-1,d;(d=u[++m])!==undefined;){var f=new o.EntityType(this._oModel.getServiceMetadata(),a,d);this._oEntityTypeSet[f.getQName()]=f;var g=this._getEntitySetsOfType(a,f.getQName());if(g.length==0){throw"Invalid consumption model: No entity set for entity type "+f.getQName()+" found";}if(g.length>1){throw"Unsupported consumption model: More than one entity set for entity type "+f.getQName()+" found";}var h=new o.EntitySet(this._oModel.getServiceMetadata(),a,g[0][0],g[0][1],f);this._oEntitySetSet[h.getQName()]=h;this._oEntityTypeNameToEntitySetMap[f.getQName()]=h;}var i={};for(var n=-1,v;(v=P[++n])!==undefined;){var w=new o.EntityType(this._oModel.getServiceMetadata(),a,v);this._oEntityTypeSet[w.getQName()]=w;var x=this._getEntitySetsOfType(a,w.getQName());if(x.length==0){throw"Invalid consumption model: No entity set for parameter entity type "+w.getQName()+" found";}if(x.length>1){throw"Unsupported consumption model: More than one entity set for parameter entity type "+w.getQName()+" found";}var y=new o.EntitySet(this._oModel.getServiceMetadata(),a,x[0][0],x[0][1],w);this._oEntitySetSet[y.getQName()]=y;this._oEntityTypeNameToEntitySetMap[w.getQName()]=y;var z=new o.Parameterization(w,y);this._oParameterizationSet[z.getName()]=z;i[w.getQName()]=z;var B=w.getQName();if(a.association!=undefined){for(var p=-1,D;(D=a.association[++p])!==undefined;){if(D.referentialConstraint==undefined){continue;}var G=null;if(D.end[0].type==B&&D.end[0].multiplicity=="*"&&D.end[1].multiplicity=="1"){G=D.end[1].type;}else if(D.end[1].type==B&&D.end[1].multiplicity=="*"&&D.end[0].multiplicity=="1"){G=D.end[0].type;}if(!G){continue;}if(D.referentialConstraint.dependent.propertyRef.length!=1){continue;}var H=z.findParameterByName(D.referentialConstraint.dependent.propertyRef[0].name);if(H==null){continue;}var V=this._oEntityTypeSet[G];var I=this._oEntityTypeNameToEntitySetMap[G];H.setValueSetEntity(V,I);}}}for(var r=-1,J;(J=Q[++r])!==undefined;){var K=new o.EntityType(this._oModel.getServiceMetadata(),a,J);this._oEntityTypeSet[K.getQName()]=K;var L=K.getQName();var N=null;var O=null;if(a.association!=undefined){for(var s=-1,R;(R=a.association[++s])!==undefined;){var U=null;if(R.end[0].type==L){U=R.end[1].type;}else if(R.end[1].type==L){U=R.end[0].type;}else{continue;}var W=null;W=i[U];if(W!=null){if(N!=null){throw"LIMITATION: Unable to handle multiple parameter entity types of query entity "+K.name;}else{N=W;O=R;}}}}var X=this._getEntitySetsOfType(a,K.getQName());if(X.length!=1){throw"Invalid consumption model: There must be exactly one entity set for an entity type annotated with aggregating semantics";}var Y=new o.EntitySet(this._oModel.getServiceMetadata(),a,X[0][0],X[0][1],K);this._oEntitySetSet[Y.getQName()]=Y;this._oEntityTypeNameToEntitySetMap[K.getQName()]=Y;var Z=new o.QueryResult(this,K,Y,N);this._oQueryResultSet[Z.getName()]=Z;if(N){N.setTargetQueryResult(Z,O);}if(a.association!=undefined){for(var t=-1,$;($=a.association[++t])!==undefined;){if($.referentialConstraint==undefined){continue;}var _=null;if($.end[0].type==L&&$.end[0].multiplicity=="*"&&$.end[1].multiplicity=="1"){_=$.end[1].type;}else if($.end[1].type==L&&$.end[1].multiplicity=="*"&&$.end[0].multiplicity=="1"){_=$.end[0].type;}if(!_){continue;}if($.referentialConstraint.dependent.propertyRef.length!=1){continue;}var a1=Z.findDimensionByName($.referentialConstraint.dependent.propertyRef[0].name);if(a1==null){continue;}var b1=this._oEntityTypeNameToEntitySetMap[_];a1.setMembersEntitySet(b1);}}}},oUI5ODataModelAnnotatableObject:{objectName:"schema",keyPropName:"namespace",extensions:true,aSubObject:[{objectName:"entityType",keyPropName:"name",extensions:true,aSubObject:[{objectName:"property",keyPropName:"name",aSubObject:[],extensions:true}]},{objectName:"entityContainer",keyPropName:"name",extensions:false,aSubObject:[{objectName:"entitySet",keyPropName:"name",extensions:true,aSubObject:[]}]}]},mergeV2Annotations:function(a){var b=null;try{b=JSON.parse(a);}catch(e){return;}var m;try{m=this._oModel.getServiceMetadata().dataServices;}catch(e){return;}for(var p in b){if(!(this.oUI5ODataModelAnnotatableObject.objectName==p)){continue;}if(!(b[p]instanceof Array)){continue;}this.mergeV2AnnotationLevel(m[this.oUI5ODataModelAnnotatableObject.objectName],b[this.oUI5ODataModelAnnotatableObject.objectName],this.oUI5ODataModelAnnotatableObject);break;}return;},mergeV2AnnotationLevel:function(M,a,u){for(var i=-1,b;(b=a[++i])!==undefined;){for(var j=-1,d;(d=M[++j])!==undefined;){if(!(b[u.keyPropName]==d[u.keyPropName])){continue;}if(b["extensions"]!=undefined){if(d["extensions"]==undefined){d["extensions"]=[];}for(var l=-1,e;(e=b["extensions"][++l])!==undefined;){var f=false;for(var m=-1,g;(g=d["extensions"][++m])!==undefined;){if(e.name==g.name&&e.namespace==g.namespace){g.value=e.value;f=true;break;}}if(!f){d["extensions"].push(e);}}}for(var k=-1,U;(U=u.aSubObject[++k])!==undefined;){for(var p in b){if(!(U.objectName==p)){continue;}if(!(b[U.objectName]instanceof Array)){continue;}if((d[U.objectName]==undefined)||(!(d[U.objectName]instanceof Array))){continue;}this.mergeV2AnnotationLevel(d[U.objectName],b[U.objectName],U);break;}}}}return;},findQueryResultByName:function(n){var Q=this._oQueryResultSet[n];if(!Q&&this._oDefaultEntityContainer){var s=this._oDefaultEntityContainer.name+"."+n;Q=this._oQueryResultSet[s];}return Q;},getAllQueryResultNames:function(){if(this._aQueryResultNames){return this._aQueryResultNames;}this._aQueryResultNames=new Array(0);for(var n in this._oQueryResultSet){this._aQueryResultNames.push(this._oQueryResultSet[n].getName());}return this._aQueryResultNames;},getAllQueryResults:function(){return this._oQueryResultSet;},getODataModel:function(){return this._oModel;},_getEntitySetsOfType:function(s,Q){var e=[];for(var i=-1,E;(E=s.entityContainer[++i])!==undefined;){for(var j=-1,a;(a=E.entitySet[++j])!==undefined;){if(a.entityType==Q){e.push([E,a]);}}}return e;},_mParameter:null,_oModel:null,_oDefaultEntityContainer:null,_aQueryResultNames:null,_oQueryResultSet:null,_oParameterizationSet:null,_oEntityTypeSet:null,_oEntitySetSet:null,_oEntityTypeNameToEntitySetMap:null,_oActivatedWorkarounds:null};
o.QueryResult=function(m,e,E,p){this._init(m,e,E,p);};
o.QueryResult.prototype={_init:function(m,e,E,p,a){this._oModel=m;this._oEntityType=e;this._oEntitySet=E;this._oParameterization=p;this._oDimensionSet={};this._oMeasureSet={};var P=e.getTypeDescription().property;var b={};for(var i=-1,d;(d=P[++i])!==undefined;){if(d.extensions==undefined){continue;}for(var j=-1,f;(f=d.extensions[++j])!==undefined;){if(!f.namespace==o.constants.SAP_NAMESPACE){continue;}switch(f.name){case"aggregation-role":switch(f.value){case"dimension":{var D=new o.Dimension(this,d);this._oDimensionSet[D.getName()]=D;break;}case"measure":{var M=new o.Measure(this,d);this._oMeasureSet[M.getName()]=M;break;}case"totaled-properties-list":this._oTotaledPropertyListProperty=d;break;default:}break;case"attribute-for":{var g=new o.DimensionAttribute(this,d);var k=g.getKeyProperty();b[k.name]=g;break;}default:}}}for(var s in b){var h=b[s];h.getDimension().addAttribute(h);}if(m._oActivatedWorkarounds.IdentifyTextPropertiesByName){var l=[];for(var n in this._oDimensionSet){var r=this._oDimensionSet[n];if(!r.getTextProperty()){var T=null;T=e.findPropertyByName(n+"Name");if(!T){T=e.findPropertyByName(n+"Text");}if(!T){T=e.findPropertyByName(n+"Desc");}if(!T){T=e.findPropertyByName(n+"Description");}if(T){r.setTextProperty(T);l.push(T.name);}}}for(var t=-1,u;(u=l[++t])!==undefined;){delete this._oDimensionSet[u];}}},getName:function(){return this.getEntitySet().getQName();},getParameterization:function(){return this._oParameterization;},getAllDimensionNames:function(){if(this._aDimensionNames){return this._aDimensionNames;}this._aDimensionNames=[];for(var n in this._oDimensionSet){this._aDimensionNames.push(this._oDimensionSet[n].getName());}return this._aDimensionNames;},getAllDimensions:function(){return this._oDimensionSet;},getAllMeasureNames:function(){if(this._aMeasureNames){return this._aMeasureNames;}this._aMeasureNames=[];for(var n in this._oMeasureSet){this._aMeasureNames.push(this._oMeasureSet[n].getName());}return this._aMeasureNames;},getAllMeasures:function(){return this._oMeasureSet;},findDimensionByName:function(n){return this._oDimensionSet[n];},findDimensionByPropertyName:function(n){if(this._oDimensionSet[n]){return this._oDimensionSet[n];}for(var d in this._oDimensionSet){var D=this._oDimensionSet[d];var t=D.getTextProperty();if(t&&t.name==n){return D;}if(D.findAttributeByName(n)){return D;}}return null;},getTotaledPropertiesListProperty:function(){return this._oTotaledPropertyListProperty;},findMeasureByName:function(n){return this._oMeasureSet[n];},findMeasureByPropertyName:function(n){if(this._oMeasureSet[n]){return this._oMeasureSet[n];}for(var m in this._oMeasureSet){var M=this._oMeasureSet[m];var f=M.getFormattedValueProperty();if(f&&f.name==n){return M;}}return null;},getModel:function(){return this._oModel;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oModel:null,_oEntityType:null,_oEntitySet:null,_oParameterization:null,_aDimensionNames:null,_oDimensionSet:null,_aMeasureNames:null,_oMeasureSet:null,_oTotaledPropertyListProperty:null};
o.Parameterization=function(e,E){this._init(e,E);};
o.Parameterization.prototype={_init:function(e,E){this._oEntityType=e;this._oEntitySet=E;this._oParameterSet={};var p=e.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){if(P.extensions==undefined){continue;}for(var j=-1,a;(a=P.extensions[++j])!==undefined;){if(!a.namespace==o.constants.SAP_NAMESPACE){continue;}switch(a.name){case"parameter":{var b=new o.Parameter(this,P);this._oParameterSet[b.getName()]=b;break;}default:}}}},setTargetQueryResult:function(Q,a){this._oQueryResult=Q;var s=this._oEntityType.getSchema().namespace+"."+a.name;var n=this._oEntityType.getTypeDescription().navigationProperty;if(!n){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}for(var i=-1,N;(N=n[++i])!==undefined;){if(N.relationship==s){this._oNavPropToQueryResult=N.name;}}if(!this._oNavPropToQueryResult){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}},getTargetQueryResult:function(){if(!this._oQueryResult){throw"No target query result set";}return this._oQueryResult;},getName:function(){return this.getEntitySet().getQName();},getAllParameterNames:function(){if(this._aParameterNames){return this._aParameterNames;}this._aParameterNames=[];for(var n in this._oParameterSet){this._aParameterNames.push(this._oParameterSet[n].getName());}return this._aParameterNames;},getAllParameters:function(){return this._oParameterSet;},findParameterByName:function(n){return this._oParameterSet[n];},getNavigationPropertyToQueryResult:function(){return this._oNavPropToQueryResult;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oEntityType:null,_oEntitySet:null,_oQueryResult:null,_oNavPropToQueryResult:null,_aParameterNames:null,_oParameterSet:null};
o.Parameter=function(p,P){this._init(p,P);};
o.Parameter.prototype={_init:function(p,P){this._oParameterization=p;this._oProperty=P;var e=p.getEntityType();if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"parameter":switch(E.value){case"mandatory":this._bRequired=true;break;case"optional":this._bRequired=false;break;default:throw"Invalid annotation value for parameter property";}break;case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=e.findPropertyByName(E.value);break;case"upper-boundary":this._bIntervalBoundaryParameter=true;this._oUpperIntervalBoundaryParameterProperty=e.findPropertyByName(E.value);break;case"lower-boundary":this._bIntervalBoundaryParameter=true;this._oLowerIntervalBoundaryParameterProperty=e.findPropertyByName(E.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},setValueSetEntity:function(e,E){this._oValueSetEntityType=e;this._oValueSetEntitySet=E;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oParameterization._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isOptional:function(){return(!this._bRequired);},isIntervalBoundary:function(){return this._bIntervalBoundaryParameter;},isLowerIntervalBoundary:function(){return(this._oUpperIntervalBoundaryParameterProperty?true:false);},getPeerIntervalBoundaryParameter:function(){var p=null;if(this._oLowerIntervalBoundaryParameterProperty){p=this._oLowerIntervalBoundaryParameterProperty.name;}else{p=this._oUpperIntervalBoundaryParameterProperty.name;}if(!p){throw"Parameter is not an interval boundary";}return this._oParameterization.findParameterByName(p);},isValueSetAvailable:function(){return(this._oValueSetEntityType?true:false);},getName:function(){return this._oProperty.name;},getProperty:function(){return this._oProperty;},getContainingParameterization:function(){return this._oParameterization;},getURIToValueEntitySet:function(s){var u=null;u=(s?s:"")+"/"+this._oValueSetEntitySet.getQName();return u;},_oParameterization:null,_oProperty:null,_sLabelText:null,_oTextProperty:null,_bRequired:false,_bIntervalBoundaryParameter:false,_oLowerIntervalBoundaryParameterProperty:null,_oUpperIntervalBoundaryParameterProperty:null,_oValueSetEntityType:null,_oValueSetEntitySet:null};
o.Dimension=function(Q,p){this._init(Q,p);};
o.Dimension.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;this._oAttributeSet={};},setMembersEntitySet:function(e){this._oMembersEntitySet=e;},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){if(!this._oTextProperty){this._oTextProperty=this._oQueryResult.getEntityType().getTextPropertyOfProperty(this.getName());}return this._oTextProperty;},setTextProperty:function(t){this._oTextProperty=t;},getLabelText:function(){if(!this._sLabelText){this._sLabelText=this._oQueryResult.getEntityType().getLabelOfProperty(this.getName());}if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return(this._sLabelText==null?"":this._sLabelText);},getSuperOrdinateDimension:function(){if(!this._sSuperOrdinateDimension){var s=this._oQueryResult.getEntityType().getSuperOrdinatePropertyOfProperty(this.getName()).name;this._sSuperOrdinateDimension=this._oQueryResult.findDimensionByName(s);}return this._sSuperOrdinateDimension;},getHierarchy:function(){if(!this._oHierarchy){this._oHierarchy=this._oQueryResult.getEntityType().getHierarchy(this._oProperty.name);}return this._oHierarchy;},getAllAttributeNames:function(){if(this._aAttributeNames){return this._aAttributeNames;}this._aAttributeNames=[];for(var n in this._oAttributeSet){this._aAttributeNames.push(this._oAttributeSet[n].getName());}return this._aAttributeNames;},getAllAttributes:function(){return this._oAttributeSet;},findAttributeByName:function(n){return this._oAttributeSet[n];},addAttribute:function(d){this._oAttributeSet[d.getName()]=d;},getContainingQueryResult:function(){return this._oQueryResult;},hasMasterData:function(){return this._oMembersEntitySet!=null?true:false;},getMasterDataEntitySet:function(){return this._oMembersEntitySet;},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sSuperOrdinateDimension:null,_aAttributeNames:null,_oAttributeSet:null,_oMembersEntitySet:null,_oHierarchy:null};
o.DimensionAttribute=function(Q,p){this._init(Q,p);};
o.DimensionAttribute.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,e;(e=p.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}switch(e.name){case"attribute-for":this._sDimensionName=e.value;break;case"label":this._sLabelText=e.value;break;case"text":this._oTextProperty=Q.getEntityType().findPropertyByName(e.value);break;default:}}}},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},getDimension:function(){return this._oQueryResult.findDimensionByName(this._sDimensionName);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sDimensionName:null};
o.Measure=function(Q,p){this._init(Q,p);};
o.Measure.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,e;(e=p.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}switch(e.name){case"label":this._sLabelText=e.value;break;case"text":this._oTextProperty=Q.getEntityType().findPropertyByName(e.value);break;case"unit":this._oUnitProperty=Q.getEntityType().findPropertyByName(e.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},getName:function(){return this._oProperty.name;},getRawValueProperty:function(){return this._oProperty;},getFormattedValueProperty:function(){return this._oTextProperty;},getUnitProperty:function(){return this._oUnitProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isUpdatable:function(){if(this._bIsUpdatable!=null){return this._bIsUpdatable;}var u=this._oQueryResult.getEntitySet().getUpdatablePropertyNameSet();return(u[this.getName()]!=undefined);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_oUnitProperty:null,_bIsUpdatable:null};
o.EntitySet=function(m,s,C,e,E){this._init(m,s,C,e,E);};
o.EntitySet.prototype={_init:function(m,s,C,e,E){this._oEntityType=E;this._oEntitySet=e;this._oContainer=C;this._oSchema=s;this._oModel=m;if(s.entityContainer.length>1){this._sQName=C.name+"."+e.name;}else{this._sQName=e.name;}},getQName:function(){return this._sQName;},getSetDescription:function(){return this._oEntitySet;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},getUpdatablePropertyNameSet:function(){if(this._oUpdatablePropertyNames){return this._oUpdatablePropertyNames;}this._oUpdatablePropertyNames={};var s=true;if(this._oEntitySet.extensions!=undefined){for(var j=-1,e;(e=this._oEntitySet.extensions[++j])!==undefined;){if(e.namespace==o.constants.SAP_NAMESPACE&&e.name=="updatable"){if(e.value=="false"){s=false;break;}}}}if(!s){return this._oUpdatablePropertyNames;}var p=this._oEntityType.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){var b=true;if(P.extensions==undefined){continue;}for(var k=-1,E;(E=P.extensions[++k])!==undefined;){if(E.namespace!=o.constants.SAP_NAMESPACE){continue;}if(E.name=="updatable"){if(E.value=="false"){b=false;break;}}}if(b){this._oUpdatablePropertyNames[P.name]=true;}}return this._oUpdatablePropertyNames;},_oEntityType:null,_oEntitySet:null,_oContainer:null,_oSchema:null,_oModel:null,_sQName:null,_oUpdatablePropertyNames:null};
o.EntityType=function(m,s,e){this._init(m,s,e);};
o.EntityType.propertyFilterRestriction={SINGLE_VALUE:"single-value",MULTI_VALUE:"multi-value",INTERVAL:"interval"};o.EntityType.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aKeyProperties=[];this._oPropertySet={};this._aFilterablePropertyNames=[];this._aSortablePropertyNames=[];this._aRequiredFilterPropertyNames=[];this._oPropertyFilterRestrictionSet={};this._oPropertyHeadingsSet={};this._oPropertyQuickInfosSet={};this._sQName=s.namespace+"."+e.name;var r={};function g(K){var R=r[K];if(!R){R=r[K]={};}return R;}for(var i=-1,p;(p=e.key.propertyRef[++i])!==undefined;){this._aKeyProperties.push(p.name);}for(var k=-1,P;(P=e.property[++k])!==undefined;){this._oPropertySet[P.name]=P;this._aFilterablePropertyNames.push(P.name);this._aSortablePropertyNames.push(P.name);if(P.extensions==undefined){continue;}for(var j=-1,E;(E=P.extensions[++j])!==undefined;){if(E.namespace!==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"filterable":if(E.value=="false"){this._aFilterablePropertyNames.pop(P.name);}break;case"sortable":if(E.value=="false"){this._aSortablePropertyNames.pop(P.name);}break;case"required-in-filter":if(E.value=="true"){this._aRequiredFilterPropertyNames.push(P.name);}break;case"filter-restriction":if(E.value==o.EntityType.propertyFilterRestriction.SINGLE_VALUE||E.value==o.EntityType.propertyFilterRestriction.MULTI_VALUE||E.value==o.EntityType.propertyFilterRestriction.INTERVAL){this._oPropertyFilterRestrictionSet[P.name]=E.value;}break;case"hierarchy-node-external-key-for":g(E.value).externalKeyProperty=P;break;case"hierarchy-node-for":g(P.name).dimensionName=E.value;break;case"hierarchy-parent-node-for":case"hierarchy-parent-nod":g(E.value).parentNodeIDProperty=P;break;case"hierarchy-level-for":g(E.value).levelProperty=P;break;case"hierarchy-drill-state-for":case"hierarchy-drill-stat":g(E.value).drillStateProperty=P;break;default:}}}this._oRecursiveHierarchySet={};for(var h in r){var H=r[h];var a=this._oPropertySet[h];var d=this._oPropertySet[H.dimensionName];if(d==null){d=a;}this._oRecursiveHierarchySet[d.name]=new o.RecursiveHierarchy(e,a,H.parentNodeIDProperty,H.levelProperty,d,H.externalKeyProperty);}},getProperties:function(){return this._oPropertySet;},findPropertyByName:function(p){return this._oPropertySet[p];},getKeyProperties:function(){return this._aKeyProperties;},getLabelOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}if(e.name=="label"){return e.value;}}}return null;},getHeadingOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}if(e.name=="heading"){return e.value;}if(e.name=="label"){s=e.value;}}}return s;},getQuickInfoOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}if(e.name=="quickinfo"){return e.value;}if(e.name=="label"){s=e.value;}}}return s;},getTextPropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(e.name=="text"){return this.findPropertyByName(e.value);}}}return null;},getSuperOrdinatePropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(e.name=="super-ordinate"){return this.findPropertyByName(e.value);}}}return null;},getFilterablePropertyNames:function(){return this._aFilterablePropertyNames;},getSortablePropertyNames:function(){return this._aSortablePropertyNames;},getRequiredFilterPropertyNames:function(){return this._aRequiredFilterPropertyNames;},getPropertiesWithFilterRestrictions:function(){return this._oPropertyFilterRestrictionSet;},getAllHierarchyPropertyNames:function(){if(this._aHierarchyPropertyNames){return this._aHierarchyPropertyNames;}this._aHierarchyPropertyNames=[];for(var n in this._oRecursiveHierarchySet){this._aHierarchyPropertyNames.push(this._oRecursiveHierarchySet[n].getNodeValueProperty().name);}return this._aHierarchyPropertyNames;},getHierarchy:function(n){if(this._oRecursiveHierarchySet[n]==undefined){return null;}return this._oRecursiveHierarchySet[n];},getQName:function(){return this._sQName;},getTypeDescription:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_sQName:null,_aKeyProperties:null,_oPropertySet:null,_aFilterablePropertyNames:null,_aRequiredFilterPropertyNames:null,_oPropertyFilterRestrictionSet:null,_aHierarchyPropertyNames:null,_oRecursiveHierarchySet:null};
o.RecursiveHierarchy=function(e,n,p,N,a,b){this._init(e,n,p,N,a,b);};
o.RecursiveHierarchy.prototype={_init:function(e,n,p,N,a,b){this._oEntityType=e;this._oNodeIDProperty=n;this._oParentNodeIDProperty=p;this._oNodeLevelProperty=N;this._oNodeValueProperty=a;this._oNodeExternalKeyProperty=b;},isRecursiveHierarchy:function(){return true;},isLeveledHierarchy:function(){return false;},getNodeExternalKeyProperty:function(){return this._oNodeExternalKeyProperty;},getNodeIDProperty:function(){return this._oNodeIDProperty;},getParentNodeIDProperty:function(){return this._oParentNodeIDProperty;},getNodeLevelProperty:function(){return this._oNodeLevelProperty;},getNodeValueProperty:function(){return this._oNodeValueProperty;},_oEntityType:null,_oNodeIDProperty:null,_oParentNodeIDProperty:null,_oNodeLevelProperty:null,_oNodeValueProperty:null,_oNodeExternalKeyProperty:null};
o.FilterExpression=function(m,s,e){this._init(m,s,e);};
o.FilterExpression.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_renderPropertyFilterValue:function(f,p){return q.sap.encodeURL(this._oModel.getODataModel().formatValue(f,p));},clear:function(){this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_addCondition:function(p,O,v,V){for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(u.sPath==p&&u.sOperator==O&&u.oValue1==v&&u.oValue2==V){return;}}this._aConditionUI5Filter.push(new F(p,O,v,V));},_addUI5FilterArray:function(u){this._aUI5FilterArray.push(u);},addCondition:function(p,O,v,V){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(q.inArray(p,f)===-1){throw"Cannot add filter condition for not filterable property name "+p;}this._addCondition(p,O,v,V);return this;},removeConditions:function(p){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot remove filter conditions for unknown property name "+p;}for(var i=0;i<this._aConditionUI5Filter.length;i++){var u=this._aConditionUI5Filter[i];if(u.sPath==p){this._aConditionUI5Filter.splice(i--,1);}}return this;},addSetCondition:function(p,v){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(q.inArray(p,f)===-1){throw"Cannot add filter condition for not filterable property name "+p;}for(var i=-1,V;(V=v[++i])!==undefined;){this._addCondition(p,c.EQ,V);}return this;},addUI5FilterConditions:function(u){if(!Array.isArray(u)){throw"Argument is not an array";}if(u.length==0){return this;}var h=false;for(var i=0;i<u.length;i++){if(u[i].aFilters!=undefined){h=true;break;}}if(h){this._addUI5FilterArray(u);}else{for(var j=0;j<u.length;j++){this.addCondition(u[j].sPath,u[j].sOperator,u[j].oValue1,u[j].oValue2);}}return this;},getExpressionAsUI5FilterArray:function(){var f=this._aConditionUI5Filter.concat([]);for(var i=-1,a;(a=this._aUI5FilterArray[++i])!==undefined;){for(var j=-1,b;(b=a[++j])!==undefined;){f.push(b);}}return f;},getPropertiesReferencedByUI5FilterArray:function(u,r){for(var i=-1,U;(U=u[++i])!==undefined;){if(U.aFilters!=undefined){this.getPropertiesReferencedByUI5FilterArray(U.aFilters,r);}else{if(r[U.sPath]==undefined){r[U.sPath]=[];}r[U.sPath].push(U);}}},getReferencedProperties:function(){var r={};for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(r[u.sPath]==undefined){r[u.sPath]=[];}r[u.sPath].push(u);}for(var j=-1,U;(U=this._aUI5FilterArray[++j])!==undefined;){this.getPropertiesReferencedByUI5FilterArray(U,r);}return r;},renderUI5Filter:function(u){var p=this._oEntityType.findPropertyByName(u.sPath);if(p==null){throw"Cannot add filter condition for unknown property name "+u.sPath;}var f=null;switch(u.sOperator){case c.BT:f="("+u.sPath+" "+c.GE.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type)+" and "+u.sPath+" "+c.LE.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case c.Contains:f="substringof("+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+","+u.sPath+")";break;case c.StartsWith:case c.EndsWith:f=u.sOperator.toLowerCase()+"("+u.sPath+","+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+")";break;default:f=u.sPath+" "+u.sOperator.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type);}return f;},renderUI5MultiFilter:function(u){var U=[];var O="";var l=u.bAnd==true?" and ":" or ";for(var i=-1,a;(a=u.aFilters[++i])!==undefined;){if(a.aFilters!=undefined){U.push(a);continue;}O+=(O==""?"":l)+"("+this.renderUI5Filter(a)+")";}if(U.length>0){for(var j=-1,m;(m=U[++j])!==undefined;){O+=(O==""?"":l)+"("+this.renderUI5MultiFilter(m)+")";}}return O;},renderUI5FilterArray:function(u){if(u.length==0){return"";}var O="";u.sort(function(a,b){if(a.sPath==b.sPath){return 0;}if(a.sPath>b.sPath){return 1;}else{return-1;}});var p=u[0].sPath;var s="";var n=[],U=[];for(var i=-1,d;(d=u[++i])!==undefined;){if(d.aFilters!=undefined){U.push(d);continue;}if(p!=d.sPath){if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}s="";if(n.length>0){for(var j=-1,N;(N=n[++j])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(N);}O+=(O==""?"":" and ")+"("+s+")";s="";}p=d.sPath;n=[];}if(d.sOperator==c.NE){n.push(d);continue;}s+=(s==""?"":" or ")+this.renderUI5Filter(d);}if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}if(n.length>0){s="";for(var k=-1,e;(e=n[++k])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(e);}O+=(O==""?"":" and ")+"("+s+")";}if(U.length>0){for(var l=-1,m;(m=U[++l])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5MultiFilter(m)+")";}}return O;},getURIFilterOptionValue:function(){var O=this.renderUI5FilterArray(this._aConditionUI5Filter);for(var i=-1,u;(u=this._aUI5FilterArray[++i])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5FilterArray(u)+")";}return O;},checkValidity:function(){var r=this._oEntityType.getRequiredFilterPropertyNames();var p=this.getReferencedProperties();for(var i=-1,P;(P=r[++i])!==undefined;){if(p[P]==undefined){throw"filter expression does not contain required property "+P;}}var a=this._oEntityType.getPropertiesWithFilterRestrictions();for(var s in a){var f=a[s];if(f==o.EntityType.propertyFilterRestriction.SINGLE_VALUE){if(p[s]!=undefined){if(p[s].length>1){var t=p[s][0].oValue1;for(var j=0;j<p[s].length;j++){if(p[s][j].oValue1!=t||p[s][j].sOperator!=c.EQ){throw"filter expression may use "+s+" only with a single EQ condition";}}}}}}return true;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aFilterCondition:null};o.SortOrder={Ascending:"asc",Descending:"desc"};
o.SortExpression=function(m,s,e){this._init(m,s,e);};
o.SortExpression.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aSortCondition=[];},_containsSorter:function(p){var r=null;for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(C.property.name===p){r={sorter:C,index:i};break;}}return r;},_removeFromArray:function(a,f,t){var r=a.slice((t||f)+1||a.length);a.length=f<0?a.length+f:f;return a.push.apply(a,r);},clear:function(){this._aSortCondition=[];},addSorter:function(p,s){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add sort condition for unknown property name "+p;}var e=this._containsSorter(p);if(e!=null){e.sorter.order=s;return this;}var a=this._oEntityType.getSortablePropertyNames();if(q.inArray(p,a)===-1){throw"Cannot add sort condition for not sortable property name "+p;}this._aSortCondition.push({property:P,order:s});return this;},removeSorter:function(p){if(!p){return;}var s=this._containsSorter(p);if(s){this._removeFromArray(this._aSortCondition,s.index);}},getExpressionsAsUI5SorterArray:function(){var s=[];for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){s.push(new S(C.property.name,C.order==o.SortOrder.Descending));}return s;},getExpressionAsUI5Sorter:function(){var s=this.getExpressionsAsUI5SorterArray();if(s.length==0){return null;}else{return s[0];}},getURIOrderByOptionValue:function(s){if(this._aSortCondition.length==0){return"";}var O="";for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(!s[C.property.name]){continue;}O+=(O==""?"":",")+C.property.name+" "+C.order;}return O;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aSortCondition:null};
o.ParameterizationRequest=function(p){this._init(p);};
o.ParameterizationRequest.prototype={_init:function(p){if(!p){throw"No parameterization given";}this._oParameterization=p;this._oParameterValueAssignment=[];},_renderParameterKeyValue:function(k,p){return q.sap.encodeURL(this._oParameterization.getTargetQueryResult().getModel().getODataModel().formatValue(k,p));},getParameterization:function(){return this._oParameterization;},setParameterValue:function(p,v,t){var P=this._oParameterization.findParameterByName(p);if(!P){throw"Invalid parameter name "+p;}if(t!=null){if(!P.isIntervalBoundary()){throw"Range value cannot be applied to parameter "+p+" accepting only single values";}if(!P.isLowerIntervalBoundary()){throw"Range value given, but parameter "+p+" does not hold the lower boundary";}}if(!P.isIntervalBoundary()){if(v==null){delete this._oParameterValueAssignment[p];}else{this._oParameterValueAssignment[p]=v;}}else{if(v==null&&t!=null){throw"Parameter "+p+": An upper boundary cannot be given without the lower boundary";}if(v==null){delete this._oParameterValueAssignment[p];t=null;}else{this._oParameterValueAssignment[p]=v;}var u=P.getPeerIntervalBoundaryParameter();if(t==null){t=v;}if(v==null){delete this._oParameterValueAssignment[u.getName()];}else{this._oParameterValueAssignment[u.getName()]=t;}}return;},getURIToParameterizationEntitySet:function(s){return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName();},getURIToParameterizationEntry:function(s){var d=this._oParameterization.getAllParameters();for(var D in d){if(this._oParameterValueAssignment[D]==undefined){throw"Parameter "+D+" has no value assigned";}}var k="",f=true;for(var p in this._oParameterValueAssignment){k+=(f?"":",")+p+"="+this._renderParameterKeyValue(this._oParameterValueAssignment[p],d[p].getProperty().type);f=false;}return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName()+"("+k+")";},_oParameterization:null,_oParameterValueAssignment:null};
o.QueryResultRequest=function(Q,p){this._init(Q,p);};
o.QueryResultRequest.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oParameterizationRequest=p;this._oAggregationLevel={};this._oDimensionHierarchies={};this._oMeasures={};this._bIncludeEntityKey=false;this._oFilterExpression=null;this._oSortExpression=null;this._oSelectedPropertyNames=null;},addRecursiveHierarchy:function(h,i,I){var d;if(!h){return;}d=this._oQueryResult.findDimensionByName(h);if(!d){throw new Error("'"+h+"' is not a dimension property");}if(!d.getHierarchy()){throw new Error("Dimension '"+h+"' does not have a hierarchy");}this._oSelectedPropertyNames=null;this._oDimensionHierarchies[h]={externalKey:i,id:true,text:I};},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},setResourcePath:function(r){this._sResourcePath=r;if(this._sResourcePath.indexOf("/")!=0){throw"Missing leading / (slash) for resource path";}if(this._oQueryResult.getParameterization()){var l=r.lastIndexOf("/");if(l==-1){throw"Missing navigation from parameter entity set to query result in resource path";}var n=r.substring(l+1);if(n!=this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()){throw"Invalid navigation property from parameter entity set to query result in resource path";}}},getParameterizationRequest:function(){return this._oParameterizationRequest;},getQueryResult:function(){return this._oQueryResult;},setAggregationLevel:function(d){this._oAggregationLevel={};if(!d){d=this._oQueryResult.getAllDimensionNames();}this.addToAggregationLevel(d);this._oSelectedPropertyNames=null;},addToAggregationLevel:function(d){if(!d){return;}this._oSelectedPropertyNames=null;for(var i=-1,D;(D=d[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(D)){throw D+" is not a valid dimension name";}this._oAggregationLevel[D]={key:true,text:false,attributes:null};}},removeFromAggregationLevel:function(d){if(!d){return;}this._oSelectedPropertyNames=null;for(var i=-1,D;(D=d[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(D)){throw D+" is not a valid dimension name";}if(this._oAggregationLevel[D]!=undefined){delete this._oAggregationLevel[D];this.getSortExpression().removeSorter(D);}}},getAggregationLevel:function(){var d=[];for(var D in this._oAggregationLevel){d.push(D);}return d;},getAggregationLevelDetails:function(d){if(this._oAggregationLevel[d]==undefined){throw"Aggregation level does not include dimension "+d;}return this._oAggregationLevel[d];},setMeasures:function(m){if(!m){m=this._oQueryResult.getAllMeasureNames();}this._oSelectedPropertyNames=null;this._oMeasures={};for(var i=-1,M;(M=m[++i])!==undefined;){if(!this._oQueryResult.findMeasureByName(M)){throw M+" is not a valid measure name";}this._oMeasures[M]={value:true,text:false,unit:false};}},getMeasureNames:function(){var m=[];for(var M in this._oMeasures){m.push(M);}return m;},includeDimensionKeyTextAttributes:function(d,I,b,a){this._oSelectedPropertyNames=null;var D=[];if(d){if(this._oAggregationLevel[d]==undefined){throw d+" is not included in the aggregation level";}D.push(d);}else{for(var n in this._oAggregationLevel){D.push(n);}a=null;}for(var i=-1,s;(s=D[++i])!==undefined;){if(I!=null){this._oAggregationLevel[s].key=I;}if(b!=null){this._oAggregationLevel[s].text=b;}if(a!=null){this._oAggregationLevel[s].attributes=a;}}},includeMeasureRawFormattedValueUnit:function(m,I,b,a){this._oSelectedPropertyNames=null;var M=[];if(m){if(this._oMeasures[m]==undefined){throw m+" is not part of the query result";}M.push(m);}else{for(var n in this._oMeasures){M.push(n);}}for(var i=-1,s;(s=M[++i])!==undefined;){if(I!=null){this._oMeasures[s].value=I;}if(b!=null){this._oMeasures[s].text=b;}if(a!=null){this._oMeasures[s].unit=a;}}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oQueryResult.getEntityType();this._oFilterExpression=new o.FilterExpression(this._oQueryResult.getModel(),e.getSchema(),e);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var e=this._oQueryResult.getEntityType();this._oSortExpression=new o.SortExpression(e.getModel(),e.getSchema(),e);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i,I,r){if(i!=null){this._bIncludeEntityKey=i;}if(I!=null){this._bIncludeCount=I;}if(r!=null){this._bReturnNoEntities=r;}},setResultPageBoundaries:function(s,e){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(e!==null&&typeof e!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(e==null?s:e)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(e!=null)?(e-s+1):null;},getResultPageBoundaries:function(){var e=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){e=1;}else{e=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:e};},getURIToQueryResultEntitySet:function(s){var u=null;if(this._sResourcePath!=null){u=(s?s:"")+this._sResourcePath;}else if(this._oQueryResult.getParameterization()){if(!this._oParameterizationRequest){throw"Missing parameterization request";}else{u=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult();}}else{u=(s?s:"")+"/"+this._oQueryResult.getEntitySet().getQName();}return u;},getURIOrderByOptionValue:function(){var a,C,O=null,s=this._oSortExpression?this._oSortExpression._aSortCondition:[],i,n=s.length;if(n){a=this._oQueryResult.getAllMeasureNames();for(i=0;i<n;i+=1){C=s[i];if(!this._oSelectedPropertyNames[C.property.name]&&a.indexOf(C.property.name)<0){continue;}O=(O?O+",":"")+C.property.name+" "+C.order;}}return O;},getURIQueryOptionValue:function(Q){var n,s=null,a,t=this;function b(p){var P;if(!p){return;}P=typeof p==="string"?p:p.name;if(!t._oSelectedPropertyNames[P]){a+=(a==""?"":",")+P;t._oSelectedPropertyNames[P]=true;}}switch(Q){case"$select":{a="";this._oSelectedPropertyNames={};for(n in this._oAggregationLevel){var d=this._oQueryResult.findDimensionByName(n);var D=this._oAggregationLevel[n];if(D.key==true){b(d.getKeyProperty());}if(D.text==true){b(d.getTextProperty());}if(D.attributes){for(var i=-1,e;(e=D.attributes[++i])!==undefined;){b(d.findAttributeByName(e).getName());}}}for(n in this._oMeasures){var m=this._oQueryResult.findMeasureByName(n);var M=this._oMeasures[n];if(M.value==true){b(m.getRawValueProperty());}if(M.text==true){b(m.getFormattedValueProperty());}if(M.unit==true){b(m.getUnitProperty());}}for(n in this._oDimensionHierarchies){var h=this._oQueryResult.findDimensionByName(n).getHierarchy();var H=this._oDimensionHierarchies[n];if(H.id){b(h.getNodeIDProperty());}if(H.externalKey){b(h.getNodeExternalKeyProperty());}if(H.text){b(this._oQueryResult.getEntityType().getTextPropertyOfProperty(h.getNodeIDProperty().name));}}if(this._bIncludeEntityKey){var k=this._oQueryResult.getEntityType().getTypeDescription().key.propertyRef;for(var j=-1,K;(K=k[++j])!==undefined;){a+=(a==""?"":",")+K.name;}}s=(a?a:null);break;}case"$filter":{var f=null;if(this._oFilterExpression){f=this._oFilterExpression.getURIFilterOptionValue();}s=(f?f:null);break;}case"$orderby":{s=this.getURIOrderByOptionValue();break;}case"$top":{s=null;if(this._bReturnNoEntities){s=0;}else if(this._iTopRequestOption!==null){s=this._iTopRequestOption;}break;}case"$skip":{s=null;if(!this._bReturnNoEntities){s=this._iSkipRequestOption;}break;}case"$inlinecount":{s=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return s;},getURIToQueryResultEntries:function(s,r){if(!r){r=this.getURIToQueryResultEntitySet(s);}this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var d=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var Q=false;if(a!==null){u+="?$select="+a;Q=true;}if(this._oFilterExpression&&f!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$orderby="+b;}if((this._iTopRequestOption||this._bReturnNoEntities)&&t!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&d!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$skip="+d;}if(this._bIncludeCount&&i!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oQueryResult:null,_oParameterizationRequest:null,_sResourcePath:null,_oAggregationLevel:null,_oDimensionHierarchies:null,_oMeasures:null,_bIncludeEntityKey:null,_bIncludeCount:null,_bReturnNoEntities:null,_oFilterExpression:null,_oSortExpression:null,_iSkipRequestOption:null,_iTopRequestOption:null};
o.ParameterValueSetRequest=function(p){this._init(p);};
o.ParameterValueSetRequest.prototype={_init:function(p){this._oParameter=p;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;},includeParameterText:function(i){if(i!=null){this._oValueSetResult.text=i;}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oParameter.getContainingParameterization().getEntityType();var m=this._oParameter.getContainingParameterization().getTargetQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,e.getSchema(),e);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var e=this._oParameter.getContainingParameterization().getEntityType();this._oSortExpression=new o.SortExpression(e.getModel(),e.getSchema(),e);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},getURIQueryOptionValue:function(Q){var s=null;switch(Q){case"$select":{var a="";a+=(a==""?"":",")+this._oParameter.getProperty().name;if(this._oValueSetResult.text==true&&this._oParameter.getTextProperty()){a+=(a==""?"":",")+this._oParameter.getTextProperty().name;}s=(a?a:null);break;}case"$filter":{var f=null;if(this._oFilterExpression){f=this._oFilterExpression.getURIFilterOptionValue();}s=(f?f:null);break;}case"$orderby":{var b=null;if(this._oSortExpression){b=this._oSortExpression.getURIOrderByOptionValue();}s=(b?b:null);break;}default:break;}return s;},getURIToParameterValueSetEntries:function(s){var r=null;r=(s?s:"")+"/"+this._oParameter.getContainingParameterization().getEntitySet().getQName();this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var u=r;var Q=false;if(a){u+="?$select="+a;Q=true;}if(this._oFilterExpression&&f){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$orderby="+b;}return u;},_oParameter:null,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null};
o.DimensionMemberSetRequest=function(d,p,u){this._init(d,p,u);};
o.DimensionMemberSetRequest.prototype={_init:function(d,p,u){this._oDimension=d;this._oParameterizationRequest=p;this._bUseMasterData=u;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;if(this._oParameterizationRequest!=null&&this._bUseMasterData==true){throw"LIMITATION: parameterized master data entity sets are not yet implemented";}if(this._bUseMasterData){this._oEntitySet=this._oDimension.getMasterDataEntitySet();}else{this._oEntitySet=this._oDimension.getContainingQueryResult().getEntitySet();if(this._oDimension.getContainingQueryResult().getParameterization()&&!this._oParameterizationRequest){throw"Missing parameterization request";}}},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},includeDimensionTextAttributes:function(i,I){this._oValueSetResult.text={text:false,attributes:false};if(i==true){this._oValueSetResult.text=true;}if(I==true){this._oValueSetResult.attributes=true;}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oEntitySet.getEntityType();var m=this._oDimension.getContainingQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,e.getSchema(),e);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){this._oSortExpression=new o.SortExpression(this._oEntityType.getModel(),this._oEntityType.getSchema(),this._oEntityType);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i){if(i!=null){this._bIncludeCount=i;}},setResultPageBoundaries:function(s,e){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(e!==null&&typeof e!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(e==null?s:e)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(e!=null)?(e-s+1):null;},getResultPageBoundaries:function(){var e=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){e=1;}else{e=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:e};},getURIQueryOptionValue:function(Q){var s=null;switch(Q){case"$select":{var a="";var e=this._oEntitySet.getEntityType();var K=e.getKeyProperties();var b=[];if(this._bUseMasterData){for(var i=-1,d;(d=K[++i])!==undefined;){a+=(a==""?"":",")+d;var f=e.getTextPropertyOfProperty(d);if(f){if(this._oValueSetResult.text==true){a+=","+f.name;}b.push(f.name);}}}else{a+=(a==""?"":",")+this._oDimension.getKeyProperty().name;if(this._oValueSetResult.text==true&&this._oDimension.getTextProperty()){a+=(a==""?"":",")+this._oDimension.getTextProperty().name;}}if(this._oValueSetResult.attributes){if(this._bUseMasterData){var g=e.getProperties();for(var p in g){var I=false;for(var j=-1,h;(h=K[++j])!==undefined;){if(p==h){I=true;break;}}if(I){continue;}for(var k=-1,m;(m=b[++k])!==undefined;){if(p==m){I=true;break;}}if(!I){a+=","+p;}}}else{var n=this._oDimension.getAllAttributeNames();for(var l=-1,r;(r=n[++l])!==undefined;){a+=(a==""?"":",")+this._oDimension.findAttributeByName(r).getName();}}}s=(a?a:null);break;}case"$filter":{var t=null;if(this._oFilterExpression){t=this._oFilterExpression.getURIFilterOptionValue();}s=(t?t:null);break;}case"$orderby":{var u=null;if(this._oSortExpression){u=this._oSortExpression.getURIOrderByOptionValue();}s=(u?u:null);break;}case"$top":{if(this._iTopRequestOption!==null){s=this._iTopRequestOption;}break;}case"$skip":{s=this._iSkipRequestOption;break;}case"$inlinecount":{s=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return s;},getURIToDimensionMemberEntitySet:function(s){var r=null;if(!this._bUseMasterData&&this._oParameterizationRequest){r=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oDimension.getContainingQueryResult().getParameterization().getNavigationPropertyToQueryResult();}else{r=(s?s:"")+"/"+this._oEntitySet.getQName();}return r;},getURIToDimensionMemberEntries:function(s){var r=this.getURIToDimensionMemberEntitySet(s);this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var d=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var Q=false;if(a){u+="?$select="+a;Q=true;}if(this._oFilterExpression&&f){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$orderby="+b;}if(this._iTopRequestOption&&t){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&d){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$skip="+d;}if(this._bIncludeCount&&i){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oDimension:null,_oParameterizationRequest:null,_oEntitySet:null,_bUseMasterData:false,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null,_bIncludeCount:null,_iSkipRequestOption:0,_iTopRequestOption:null};return o;},true);
sap.ui.predefine('sap/ui/model/control/ControlModel',['jquery.sap.global','sap/ui/model/Model','./ControlPropertyBinding'],function(q,M,C){"use strict";
var a=M.extend("sap.ui.model.control.ControlModel",{constructor:function(c){M.apply(this,arguments);this.oControl=c;this.oControl.attachEvent("_change",this.checkUpdate,this);this.oElements=[];}});
a.prototype.destroy=function(){this.oControl.detachEvent("_change",this.checkUpdate,this);};
a.prototype.addFacadeComponent=function(e){var i=q.inArray(e,this.oElements);if(i<0){this.oElements.push(e);e.attachEvent("_change",this.checkUpdate,this);}};
a.prototype.removeFacadeComponent=function(e){var i=q.inArray(e,this.oElements);if(i>=0){this.oElements.splice(i,1);e.detachEvent("_change",this.checkUpdate,this);}};
a.prototype.bindProperty=function(p,c){c=c||this.oControl;if(c!==this.oControl){this.addFacadeComponent(c);}return new C(this,p,c);};
a.prototype.checkUpdate=function(e){if(this._onchange){this._onchange(e);}if(this.aBindings.length){var b=this.aBindings.slice(0);q.each(b,function(i,B){B.checkUpdate();});}};
return a;});
sap.ui.predefine('sap/ui/model/control/ControlPropertyBinding',['sap/ui/model/PropertyBinding'],function(P){"use strict";
var C=P.extend("sap.ui.model.control.ControlPropertyBinding",{constructor:function(m,p,c){P.apply(this,arguments);this.oValue=this._getValue();}});
C.prototype.getValue=function(){return this.oValue;};
C.prototype.setValue=function(v){this.oValue=v;this.oContext.setProperty(this.sPath,v);};
C.prototype._getValue=function(){return this.oContext.getProperty(this.sPath);};
C.prototype.setContext=function(c){this.oContext=c;this.checkUpdate();};
C.prototype.checkUpdate=function(){var v=this._getValue();if(v!==this.oValue){this.oValue=v;this._fireChange();}};
return C;});
sap.ui.predefine('sap/ui/model/json/JSONListBinding',['jquery.sap.global','sap/ui/model/ChangeReason','sap/ui/model/ClientListBinding'],function(q,C,a){"use strict";
var J=a.extend("sap.ui.model.json.JSONListBinding");
J.prototype.getContexts=function(s,l){this.iLastStartIndex=s;this.iLastLength=l;if(!s){s=0;}if(!l){l=Math.min(this.iLength,this.oModel.iSizeLimit);}var c=this._getContexts(s,l),b=[];if(this.bUseExtendedChangeDetection){try{for(var i=0;i<c.length;i++){b.push(this.getContextData(c[i]));}if(this.aLastContextData&&s<this.iLastEndIndex){c.diff=q.sap.arraySymbolDiff(this.aLastContextData,b);}this.iLastEndIndex=s+l;this.aLastContexts=c.slice(0);this.aLastContextData=b.slice(0);}catch(e){this.bUseExtendedChangeDetection=false;q.sap.log.warning("JSONListBinding: Extended change detection has been disabled as JSON data could not be serialized.");}}return c;};
J.prototype.getCurrentContexts=function(){if(this.bUseExtendedChangeDetection){return this.aLastContexts||[];}else{return this.getContexts(this.iLastStartIndex,this.iLastLength);}};
J.prototype.updateIndices=function(){var i;this.aIndices=[];if(Array.isArray(this.oList)){for(i=0;i<this.oList.length;i++){this.aIndices.push(i);}}else{for(i in this.oList){this.aIndices.push(i);}}};
J.prototype.update=function(){var l=this.oModel._getObject(this.sPath,this.oContext);if(l){if(Array.isArray(l)){if(this.bUseExtendedChangeDetection){this.oList=q.extend(true,[],l);}else{this.oList=l.slice(0);}}else{this.oList=q.extend(this.bUseExtendedChangeDetection,{},l);}this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();}else{this.oList=[];this.aIndices=[];this.iLength=0;}};
J.prototype.checkUpdate=function(f){if(this.bSuspended&&!this.bIgnoreSuspend&&!f){return;}if(!this.bUseExtendedChangeDetection){var l=this.oModel._getObject(this.sPath,this.oContext)||[];if(!q.sap.equal(this.oList,l)||f){this.update();this._fireChange({reason:C.Change});}}else{var c=false;var t=this;var l=this.oModel._getObject(this.sPath,this.oContext)||[];if(this.oList.length!=l.length){c=true;}if(!q.sap.equal(this.oList,l)){this.update();}var b=this._getContexts(this.iLastStartIndex,this.iLastLength);if(this.aLastContexts){if(this.aLastContexts.length!=b.length){c=true;}else{q.each(this.aLastContextData,function(i,L){var o=t.getContextData(b[i]);if(o!==L){c=true;return false;}});}}else{c=true;}if(c||f){this._fireChange({reason:C.Change});}}};
return J;});
sap.ui.predefine('sap/ui/model/json/JSONModel',['jquery.sap.global','sap/ui/model/ClientModel','sap/ui/model/Context','./JSONListBinding','./JSONPropertyBinding','./JSONTreeBinding'],function(q,C,a,J,b,c){"use strict";
var d=C.extend("sap.ui.model.json.JSONModel",{
constructor:function(D,o){this.pSequentialImportCompleted=Promise.resolve();C.apply(this,arguments);this.bObserve=o;if(D&&typeof D=="object"){this.setData(D);}},
metadata:{publicMethods:["setJSON","getJSON"]}
});
d.prototype.setData=function(D,m){if(m){this.oData=q.extend(true,Array.isArray(this.oData)?[]:{},this.oData,D);}else{this.oData=D;}if(this.bObserve){this.observeData();}this.checkUpdate();};
d.prototype.observeData=function(){var t=this;function e(v){return function(){return v;};}function f(O,n){return function(v){o(v,O,n);t.checkUpdate();};}function g(O,n,v){if(typeof v=="function"){O[n]=v;}else{Object.defineProperty(O,n,{get:e(v),set:f(O,n)});}}function o(O,p,n){if(Array.isArray(O)){for(var i=0;i<O.length;i++){o(O[i],O,i);}}else if(q.isPlainObject(O)){for(var i in O){o(O[i],O,i);}}if(p){g(p,n,O);}}o(this.oData);};
d.prototype.setJSON=function(j,m){var o;try{o=q.parseJSON(j);this.setData(o,m);}catch(e){q.sap.log.fatal("The following problem occurred: JSON parse Error: "+e);this.fireParseError({url:"",errorCode:-1,reason:"",srcText:e,line:-1,linepos:-1,filepos:-1});}};
d.prototype.getJSON=function(){return JSON.stringify(this.oData);};
d.prototype.loadData=function(u,p,A,t,m,e,h){var f;A=(A!==false);t=t||"GET";e=e===undefined?this.bCache:e;this.fireRequestSent({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m}});var s=function(D){if(!D){q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+u);}this.setData(D,m);this.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m},success:true});}.bind(this);var E=function(P,T){var M=T||P.textStatus;var P=A?P.request:P;var S=P.status;var g=P.statusText;var r=P.responseText;var o={message:M,statusCode:S,statusText:g,responseText:r};q.sap.log.fatal("The following problem occurred: "+M,r+","+S+","+g);this.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m},success:false,errorobject:o});this.fireRequestFailed(o);}.bind(this);var _=function(s,E){this._ajax({url:u,async:A,dataType:'json',cache:e,data:p,headers:h,type:t,success:s,error:E});}.bind(this);if(A){f=new Promise(function(r,g){var R=function(x,T,o){g({request:x,textStatus:T,error:o});};_(r,R);});this.pSequentialImportCompleted=this.pSequentialImportCompleted.then(function(){return f.then(s,E).catch(function(o){q.sap.log.error("Loading of data failed: "+o.stack);});});}else{_(s,E);}};
d.prototype.bindProperty=function(p,o,P){var B=new b(this,p,o,P);return B;};
d.prototype.bindList=function(p,o,s,f,P){var B=new J(this,p,o,s,f,P);return B;};
d.prototype.bindTree=function(p,o,f,P,s){var B=new c(this,p,o,f,P,s);return B;};
d.prototype.setProperty=function(p,v,o,A){var r=this.resolve(p,o),l,O,P;if(!r){return false;}if(r=="/"){this.setData(v);return true;}l=r.lastIndexOf("/");O=r.substring(0,l||1);P=r.substr(l+1);var e=this._getObject(O);if(e){e[P]=v;this.checkUpdate(false,A);return true;}return false;};
d.prototype.getProperty=function(p,o){return this._getObject(p,o);};
d.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null;if(o instanceof a){n=this._getObject(o.getPath());}else if(o){n=o;}if(!p){return n;}var P=p.split("/"),i=0;if(!P[0]){n=this.oData;i++;}while(n&&P[i]){n=n[P[i]];i++;}return n;};
d.prototype.isList=function(p,o){var A=this.resolve(p,o);return Array.isArray(this._getObject(A));};
d.prototype._setMetaModel=function(m){this._oMetaModel=m;};
d.prototype.getMetaModel=function(){return this._oMetaModel;};
return d;});
sap.ui.predefine('sap/ui/model/json/JSONPropertyBinding',['jquery.sap.global','sap/ui/model/ChangeReason','sap/ui/model/ClientPropertyBinding','sap/ui/model/ChangeReason'],function(q,C,a){"use strict";
var J=a.extend("sap.ui.model.json.JSONPropertyBinding");
J.prototype.setValue=function(v){if(this.bSuspended){return;}if(!q.sap.equal(this.oValue,v)){if(this.oModel.setProperty(this.sPath,v,this.oContext,true)){this.oValue=v;this.getDataState().setValue(this.oValue);this.oModel.firePropertyChange({reason:C.Binding,path:this.sPath,context:this.oContext,value:v});}}};
J.prototype.checkUpdate=function(f){if(this.bSuspended&&!f){return;}var v=this._getValue();if(!q.sap.equal(v,this.oValue)||f){this.oValue=v;this.getDataState().setValue(this.oValue);this.checkDataState();this._fireChange({reason:C.Change});}};
return J;});
sap.ui.predefine('sap/ui/model/json/JSONTreeBinding',['jquery.sap.global','sap/ui/model/ClientTreeBinding'],function(q,C){"use strict";
var J=C.extend("sap.ui.model.json.JSONTreeBinding");
J.prototype._saveSubContext=function(n,c,s,N){if(n&&typeof n=="object"){var o=this.oModel.getContext(s+N);if(this.aAllFilters&&!this.bIsFiltering){if(q.inArray(o,this.filterInfo.aFilteredContexts)!=-1){c.push(o);}}else{c.push(o);}}};
return J;});
sap.ui.predefine('sap/ui/model/odata/AnnotationHelper',["jquery.sap.global","sap/ui/base/BindingParser","./_AnnotationHelperBasics","./_AnnotationHelperExpression"],function(q,B,a,E){'use strict';
function c(f,b){if(!b){return f;}function d(){return f.call(this,b.apply(this,arguments));}return d;}
var A={createPropertySetting:function(p,r){var m=false,P;p=p.slice();p.forEach(function(v,i){switch(typeof v){case"boolean":case"number":case"undefined":m=true;break;case"string":P=B.complexParser(v,null,true,true);if(P!==undefined){if(P.functionsNotFound){throw new Error("Function name(s) "+P.functionsNotFound.join(", ")+" not found");}p[i]=v=P;}case"object":if(!v||typeof v!=="object"||!("path"in v)){m=true;}break;default:throw new Error("Unsupported part: "+v);}});P={formatter:r,parts:p};if(m){B.mergeParts(P);}if(P.parts.length===0){P=P.formatter&&P.formatter();if(typeof P==="string"){P=B.complexParser.escape(P);}}else if(P.parts.length===1){r=P.formatter;P=P.parts[0];if(r){P.formatter=c(r,P.formatter);}}return P;},format:function(i,r){if(arguments.length===1){r=i.getObject("");}return E.getExpression(i,r,true);},getNavigationPath:function(i,r){if(arguments.length===1){r=i.getObject("");}var R=a.followPath(i,r);return R?"{"+R.navigationProperties.join("/")+"}":"";},gotoEntitySet:function(C){var e,s,r=C.getObject(),R;if(typeof r==="string"){e=r;}else{R=a.followPath(C,r);e=R&&R.associationSetEnd&&R.associationSetEnd.entitySet;}if(e){s=C.getModel().getODataEntitySet(e,true);}if(!s){q.sap.log.warning(C.getPath()+": found '"+e+"' which is not a name of an entity set",undefined,"sap.ui.model.odata.AnnotationHelper");}return s;},gotoEntityType:function(C){var e=C.getProperty(""),r=C.getModel().getODataEntityType(e,true);if(!r){q.sap.log.warning(C.getPath()+": found '"+e+"' which is not a name of an entity type",undefined,"sap.ui.model.odata.AnnotationHelper");}return r;},gotoFunctionImport:function(C){var f=C.getProperty("String"),r=C.getModel().getODataFunctionImport(f,true);if(!r){q.sap.log.warning(C.getPath()+": found '"+f+"' which is not a name of a function import",undefined,"sap.ui.model.odata.AnnotationHelper");}return r;},isMultiple:function(i,r){if(arguments.length===1){r=i.getObject("");}var R=a.followPath(i,r);if(R){if(R.navigationAfterMultiple){throw new Error('Association end with multiplicity "*" is not the last one: '+r.AnnotationPath);}return String(R.isMultiple);}return"";},resolvePath:function(C){var r=a.followPath(C,C.getObject());if(!r){q.sap.log.warning(C.getPath()+": Path could not be resolved ",undefined,"sap.ui.model.odata.AnnotationHelper");}return r?r.resolvedPath:undefined;},simplePath:function(i,r){if(arguments.length===1){r=i.getObject("");}return E.getExpression(i,r,false);}};A.format.requiresIContext=true;A.getNavigationPath.requiresIContext=true;A.isMultiple.requiresIContext=true;A.simplePath.requiresIContext=true;return A;},true);
sap.ui.predefine('sap/ui/model/odata/AnnotationParser',['jquery.sap.global','sap/ui/Device'],function(q,D){"use strict";var a={EnumMember:true,Path:true,PropertyPath:true,NavigationPropertyPath:true,AnnotationPath:true};var t={Binary:true,Bool:true,Date:true,DateTimeOffset:true,Decimal:true,Duration:true,Float:true,Guid:true,Int:true,String:true,TimeOfDay:true,LabelElementReference:true,EnumMember:true,Path:true,PropertyPath:true,NavigationPropertyPath:true,AnnotationPath:true};var M={And:true,Or:true,Eq:true,Ne:true,Gt:true,Ge:true,Lt:true,Le:true,If:true,Collection:true};var A={merge:function(T,s){var b,c;var S=["annotationsAtArrays","propertyAnnotations","EntityContainer","annotationReferences"];for(b in s){if(S.indexOf(b)!==-1){continue;}A._mergeAnnotation(b,s,T);}for(var i=1;i<S.length;++i){var d=S[i];T[d]=T[d]||{};for(b in s[d]){for(c in s[d][b]){T[d][b]=T[d][b]||{};A._mergeAnnotation(c,s[d][b],T[d][b]);}}}if(s.annotationsAtArrays){T.annotationsAtArrays=(T.annotationsAtArrays||[]).concat(s.annotationsAtArrays);}},_mergeAnnotation:function(n,m,T){if(Array.isArray(m[n])){T[n]=m[n].slice(0);}else{T[n]=T[n]||{};for(var k in m[n]){T[n][k]=m[n][k];}}},parse:function(m,x,s){var b={},c,d,e,T,f,g,h,l,n,p,r,u,v,w,y,z,B,C,E,F,G,i,H,I=[];A._parserData={};A._oXPath=A.getXPath();A._parserData.metadataInstance=m;A._parserData.serviceMetadata=m.getServiceMetadata();A._parserData.xmlDocument=A._oXPath.setNameSpace(x);A._parserData.schema={};A._parserData.aliases={};A._parserData.url=s?s:"metadata document";A._parserData.annotationsAtArrays=I;c=A._oXPath.selectNodes("//d:Schema",A._parserData.xmlDocument);for(i=0;i<c.length;i+=1){d=A._oXPath.nextNode(c,i);A._parserData.schema.Alias=d.getAttribute("Alias");A._parserData.schema.Namespace=d.getAttribute("Namespace");}var J={};var K=A._parseReferences(J);if(K){b.annotationReferences=J;b.aliasDefinitions=A._parserData.aliases;}e=A._oXPath.selectNodes("//d:Term",A._parserData.xmlDocument);if(e.length>0){T={};for(H=0;H<e.length;H+=1){f=A._oXPath.nextNode(e,H);g=A.replaceWithAlias(f.getAttribute("Type"));T["@"+A._parserData.schema.Alias+"."+f.getAttribute("Name")]=g;}b.termDefinitions=T;}A._parserData.metadataProperties=A.getAllPropertiesMetadata(A._parserData.serviceMetadata);if(A._parserData.metadataProperties.extensions){b.propertyExtensions=A._parserData.metadataProperties.extensions;}h=A._oXPath.selectNodes("//d:Annotations ",A._parserData.xmlDocument);for(H=0;H<h.length;H+=1){l=A._oXPath.nextNode(h,H);if(l.hasChildNodes()===false){continue;}n=l.getAttribute("Target");p=n.split(".")[0];if(p&&A._parserData.aliases[p]){n=n.replace(new RegExp(p,""),A._parserData.aliases[p]);}r=n;u=null;var L=null;if(n.indexOf("/")>0){r=n.split("/")[0];var S=A._parserData.serviceMetadata.dataServices&&A._parserData.serviceMetadata.dataServices.schema&&A._parserData.serviceMetadata.dataServices.schema.length;if(S){for(var j=A._parserData.serviceMetadata.dataServices.schema.length-1;j>=0;j--){var N=A._parserData.serviceMetadata.dataServices.schema[j];if(N.entityContainer){var O=r.split('.');for(var k=N.entityContainer.length-1;k>=0;k--){if(N.entityContainer[k].name===O[O.length-1]){L=n.replace(r+"/","");break;}}}}}if(!L){u=n.replace(r+"/","");}}if(u){if(!b.propertyAnnotations){b.propertyAnnotations={};}if(!b.propertyAnnotations[r]){b.propertyAnnotations[r]={};}if(!b.propertyAnnotations[r][u]){b.propertyAnnotations[r][u]={};}v=A._oXPath.selectNodes("./d:Annotation",l);for(var P=0;P<v.length;P+=1){w=A._oXPath.nextNode(v,P);y=A.replaceWithAlias(w.getAttribute("Term"));var Q=l.getAttribute("Qualifier")||w.getAttribute("Qualifier");if(Q){y+="#"+Q;}if(w.hasChildNodes()===false){var o={};A.enrichFromPropertyValueAttributes(o,w);if(q.isEmptyObject(o)){o.Bool="true";}b.propertyAnnotations[r][u][y]=o;}else{b.propertyAnnotations[r][u][y]=A.getPropertyValue(w);}}}else{var R;if(L){if(!b["EntityContainer"]){b["EntityContainer"]={};}if(!b["EntityContainer"][r]){b["EntityContainer"][r]={};}R=b["EntityContainer"][r];}else{if(!b[r]){b[r]={};}R=b[r];}z=r.replace(A._parserData.aliases[p],p);v=A._oXPath.selectNodes("./d:Annotation",l);for(var U=0;U<v.length;U+=1){w=A._oXPath.nextNode(v,U);var V=R;if(L){if(!R[L]){R[L]={};}V=R[L];}A._parseAnnotation(r,l,w,V);}B=A._oXPath.selectNodes("//d:Annotations[contains(@Target, '"+z+"')]//d:PropertyValue[contains(@Path, '/')]//@Path",A._parserData.xmlDocument);for(i=0;i<B.length;i+=1){C=A._oXPath.nextNode(B,i);E=C.value;if(b.propertyAnnotations){if(b.propertyAnnotations[r]){if(b.propertyAnnotations[r][E]){continue;}}}F=E.split('/');if(A.findNavProperty(r,F[0])){if(!b.expand){b.expand={};}if(!b.expand[r]){b.expand[r]={};}b.expand[r][F[0]]=F[0];}}G=A._oXPath.selectNodes("//d:Annotations[contains(@Target, '"+z+"')]//d:Path[contains(., '/')]",A._parserData.xmlDocument);for(i=0;i<G.length;i+=1){C=A._oXPath.nextNode(G,i);E=A._oXPath.getNodeText(C);if(b.propertyAnnotations&&b.propertyAnnotations[r]&&b.propertyAnnotations[r][E]){continue;}if(!b.expand){b.expand={};}if(!b.expand[r]){b.expand[r]={};}F=E.split('/');if(A.findNavProperty(r,F[0])){if(!b.expand){b.expand={};}if(!b.expand[r]){b.expand[r]={};}b.expand[r][F[0]]=F[0];}}}}if(I.length){b.annotationsAtArrays=I.map(function(W){return A.backupAnnotationAtArray(W,b);});}delete A._parserData;return b;},backupAnnotationAtArray:function(e,m){var o=e,s,Q,S=[];function i(){return Array.prototype.filter.call(e.parentNode.childNodes,function(n){return n.nodeType===1;}).indexOf(e);}while(o.nodeName!=="Annotations"){o=o.parentNode;}s=o.getAttribute("Qualifier");while(e!==o){switch(e.nodeName){case"Annotation":Q=e.getAttribute("Qualifier")||s;S.unshift(e.getAttribute("Term")+(Q?"#"+Q:""));break;case"Collection":break;case"PropertyValue":S.unshift(e.getAttribute("Property"));break;case"Record":if(e.parentNode.nodeName==="Collection"){S.unshift(i());}break;default:if(e.parentNode.nodeName==="Apply"){S.unshift("Value");S.unshift(i());S.unshift("Parameters");}else{S.unshift(e.nodeName);}break;}e=e.parentNode;}S.unshift(o.getAttribute("Target"));S=S.map(function(v){return typeof v==="string"?A.replaceWithAlias(v):v;});A.syncAnnotationsAtArrays(m,S,true);return S;},restoreAnnotationsAtArrays:function(m){if(m.annotationsAtArrays){m.annotationsAtArrays.forEach(function(s){A.syncAnnotationsAtArrays(m,s);});}},syncAnnotationsAtArrays:function(m,s,w){var i,n=s.length-2,b=s[n+1],p=m,P=s[n],S=P+"@"+b;for(i=0;i<n;i+=1){p=p&&p[s[i]];}if(p&&Array.isArray(p[P])){if(!(S in p)){p[S]=p[P][b];}if(!(b in p[P])){p[P][b]=p[S];}}else if(w){q.sap.log.warning("Wrong path to annotation at array",s,"sap.ui.model.odata.AnnotationParser");}},_parseAnnotation:function(s,o,b,c){var Q=b.getAttribute("Qualifier")||o.getAttribute("Qualifier");var T=A.replaceWithAlias(b.getAttribute("Term"));if(Q){T+="#"+Q;}var v=A.getPropertyValue(b,s);v=A.setEdmTypes(v,A._parserData.metadataProperties.types,s,A._parserData.schema);c[T]=v;if(Array.isArray(c)){A._parserData.annotationsAtArrays.push(b);}},_parseReferences:function(m){var f=false;var n,i;var x=A._oXPath;var s="//edmx:Reference/edmx:Include[@Namespace and @Alias]";var o=x.selectNodes(s,A._parserData.xmlDocument);for(i=0;i<o.length;++i){f=true;n=x.nextNode(o,i);A._parserData.aliases[n.getAttribute("Alias")]=n.getAttribute("Namespace");}var r="//edmx:Reference[@Uri]/edmx:IncludeAnnotations[@TermNamespace]";var R=x.selectNodes(r,A._parserData.xmlDocument);for(i=0;i<R.length;++i){f=true;n=x.nextNode(R,i);var T=n.getAttribute("TermNamespace");var b=n.getAttribute("TargetNamespace");var c=n.parentNode.getAttribute("Uri");if(b){if(!m[b]){m[b]={};}m[b][T]=c;}else{m[T]=c;}}return f;},getAllPropertiesMetadata:function(o){var b={},P={},c={},d=false,n,e,C,E={},f={},g={},h=false,r,s,u,T,v,R={types:P};if(!o.dataServices.schema){return R;}for(var i=o.dataServices.schema.length-1;i>=0;i-=1){b=o.dataServices.schema[i];if(b.entityType){n=b.namespace;e=b.entityType;C=b.complexType;for(var j=0;j<e.length;j+=1){E=e[j];g={};f={};if(E.property){for(var k=0;k<E.property.length;k+=1){r=E.property[k];if(r.type.substring(0,n.length)===n){if(C){for(var l=0;l<C.length;l+=1){if(C[l].name===r.type.substring(n.length+1)){if(C[l].property){for(var m=0;m<C[l].property.length;m+=1){s=C[l].property[m];f[C[l].name+"/"+s.name]=s.type;}}}}}}else{u=r.name;T=r.type;if(r.extensions){for(var p=0;p<r.extensions.length;p+=1){v=r.extensions[p];if((v.name==="display-format")&&(v.value==="Date")){T="Edm.Date";}else{h=true;if(!g[u]){g[u]={};}if(v.namespace&&!g[u][v.namespace]){g[u][v.namespace]={};}g[u][v.namespace][v.name]=v.value;}}}f[u]=T;}}}if(!P[n+"."+E.name]){P[n+"."+E.name]={};}P[n+"."+E.name]=f;if(h){if(!c[n+"."+E.name]){d=true;}c[n+"."+E.name]={};c[n+"."+E.name]=g;}}}}if(d){R={types:P,extensions:c};}return R;},setEdmTypes:function(p,P,T,s){function b(c){var o,e='';if(p[c]){o=p[c];if(o.Value&&o.Value.Path){e=A.getEdmType(o.Value.Path,P,T,s);if(e){p[c].EdmType=e;}}else if(o.Path){e=A.getEdmType(o.Path,P,T,s);if(e){p[c].EdmType=e;}}else if(o.Facets){p[c].Facets=A.setEdmTypes(o.Facets,P,T,s);}else if(o.Data){p[c].Data=A.setEdmTypes(o.Data,P,T,s);}else if(c==="Data"){p.Data=A.setEdmTypes(o,P,T,s);}else if(o.Value&&o.Value.Apply){p[c].Value.Apply.Parameters=A.setEdmTypes(o.Value.Apply.Parameters,P,T,s);}else if(o.Value&&o.Type&&(o.Type==="Path")){e=A.getEdmType(o.Value,P,T,s);if(e){p[c].EdmType=e;}}}}if(Array.isArray(p)){for(var v=0;v<p.length;v+=1){b(v);}}else{for(var V in p){b(V);}}return p;},getEdmType:function(p,P,T,s){var i=p.indexOf("/");if(i>-1){var b=p.substr(0,i);var n=A.findNavProperty(T,b);if(n){var m=A._parserData.metadataInstance._getEntityTypeByNavPropertyObject(n);if(m){T=m.entityType;p=p.substr(i+1);}}}if((p.charAt(0)==="@")&&(p.indexOf(s.Alias)===1)){p=p.slice(s.Alias.length+2);}if(p.indexOf("/")>=0){if(P[p.slice(0,p.indexOf("/"))]){T=p.slice(0,p.indexOf("/"));p=p.slice(p.indexOf("/")+1);}}return P[T]&&P[T][p];},enrichFromPropertyValueAttributes:function(m,n){var I={"Property":true,"Qualifier":true,"Term":true,"xmlns":true};for(var i=0;i<n.attributes.length;i+=1){var N=n.attributes[i].name;if(!I[N]&&(N.indexOf("xmlns:")!==0)){var v=n.attributes[i].value;if(N==="EnumMember"&&v.indexOf(" ")>-1){var V=v.split(" ");m[N]=V.map(A.replaceWithAlias).join(" ");}else{m[N]=A.replaceWithAlias(v);}}}return m;},_getRecordValues:function(n){var N=[];var x=A._oXPath;for(var i=0;i<n.length;++i){var o=x.nextNode(n,i);var v=A.getPropertyValues(o);var T=o.getAttribute("Type");if(T){v["RecordType"]=A.replaceWithAlias(T);}N.push(v);}return N;},_getTextValues:function(n){var N=[];var x=A._oXPath;for(var i=0;i<n.length;i+=1){var o=x.nextNode(n,i);var v={};var T=x.getNodeText(o);v[o.nodeName]=A._parserData.aliases?A.replaceWithAlias(T):T;N.push(v);}return N;},_getTextValue:function(n){var x=A._oXPath;var v="";if(n.nodeName in a){v=A.replaceWithAlias(x.getNodeText(n));}else{v=x.getNodeText(n);}if(n.nodeName!=="String"){v=v.trim();}return v;},getPropertyValue:function(d,s){var i;var x=A._oXPath;var p=d.nodeName==="Collection"?[]:{};if(d.hasChildNodes()){var r=x.selectNodes("./d:Record",d);var R=A._getRecordValues(r);var c=x.selectNodes("./d:Collection/d:Record | ./d:Collection/d:If/d:Record",d);var C=A._getRecordValues(c);var P=R.concat(C);if(P.length>0){if(c.length===0&&r.length>0){p=P[0];}else{p=P;}}else{var o=x.selectNodes("./d:Collection/d:AnnotationPath | ./d:Collection/d:NavigationPropertyPath | ./d:Collection/d:PropertyPath",d);if(o.length>0){p=A._getTextValues(o);}else{var b=x.selectNodes("./d:*[not(local-name() = \"Annotation\")]",d);if(b.length>0){for(i=0;i<b.length;i++){var e=x.nextNode(b,i);var v;var n=e.nodeName;var f=e.parentNode.nodeName;if(n==="Apply"){v=A.getApplyFunctions(e);}else{v=A.getPropertyValue(e);}if(M[f]){if(!Array.isArray(p)){p=[];}var V={};V[n]=v;p.push(V);}else if(n==="Collection"){p=v;}else{if(p[n]){q.sap.log.warning("Annotation contained multiple "+n+" values. Only the last "+"one will be stored: "+x.getPath(e));}p[n]=v;}}A.enrichFromPropertyValueAttributes(p,d);}else if(d.nodeName in t){p=A._getTextValue(d);}else{A.enrichFromPropertyValueAttributes(p,d);}}}var N=x.selectNodes("./d:Annotation",d);if(N.length>0){for(i=0;i<N.length;i++){var g=x.nextNode(N,i);A._parseAnnotation(s,d,g,p);}}}else if(d.nodeName in t){p=A._getTextValue(d);}else if(d.nodeName.toLowerCase()==="null"){p=null;}else{A.enrichFromPropertyValueAttributes(p,d);}return p;},getPropertyValues:function(p){var P={},i;var x=A._oXPath;var o=x.selectNodes("./d:Annotation",p);var b=x.selectNodes("./d:PropertyValue",p);function g(p,w,N){var h,j=p;while(j.nodeName!=="Annotation"){j=j.parentNode;}h=j.parentNode;return(w+" '"+N+"' is defined twice; "+"Source = "+A._parserData.url+", Annotation Target = "+h.getAttribute("Target")+", Term = "+j.getAttribute("Term"));}if(o.length===0&&b.length===0){P=A.getPropertyValue(p);}else{for(i=0;i<o.length;i++){var c=x.nextNode(o,i);var T=A.replaceWithAlias(c.getAttribute("Term"));P[T]=A.getPropertyValue(c);}for(i=0;i<b.length;i++){var d=x.nextNode(b,i);var s=d.getAttribute("Property");P[s]=A.getPropertyValue(d);var e=x.selectNodes("./d:Apply",d);for(var n=0;n<e.length;n+=1){var f=x.nextNode(e,n);P[s]={};P[s]['Apply']=A.getApplyFunctions(f);}}}return P;},getApplyFunctions:function(b){var x=A._oXPath;var m={Name:b.getAttribute('Function'),Parameters:[]};var p=x.selectNodes("./d:*",b);for(var i=0;i<p.length;i+=1){var P=x.nextNode(p,i);var c={Type:P.nodeName};if(P.nodeName==="Apply"){c.Value=A.getApplyFunctions(P);}else if(P.nodeName==="LabeledElement"){c.Value=A.getPropertyValue(P);c.Name=c.Value.Name;delete c.Value.Name;}else if(M[P.nodeName]){c.Value=A.getPropertyValue(P);}else{c.Value=x.getNodeText(P);}m.Parameters.push(c);}return m;},findNavProperty:function(e,p){var m=A._parserData.serviceMetadata;for(var i=m.dataServices.schema.length-1;i>=0;i-=1){var o=m.dataServices.schema[i];if(o.entityType){var n=o.namespace+".";var E=o.entityType;for(var k=E.length-1;k>=0;k-=1){if(n+E[k].name===e&&E[k].navigationProperty){for(var j=0;j<E[k].navigationProperty.length;j+=1){if(E[k].navigationProperty[j].name===p){return E[k].navigationProperty[j];}}}}}}return null;},replaceWithAlias:function(v,r){if(r===undefined){r=1;}for(var s in A._parserData.aliases){if(v.indexOf(s+".")>=0&&v.indexOf("."+s+".")<0){v=v.replace(s+".",A._parserData.aliases[s]+".");r--;if(r===0){return v;}}}return v;},getXPath:function(){var x={};var p=A._parserData;if(D.browser.msie){x={setNameSpace:function(o){o.setProperty("SelectionNamespaces",'xmlns:edmx="http://docs.oasis-open.org/odata/ns/edmx" xmlns:d="http://docs.oasis-open.org/odata/ns/edm"');o.setProperty("SelectionLanguage","XPath");return o;},selectNodes:function(x,i){return i.selectNodes(x);},nextNode:function(n){return n.nextNode();},getNodeText:function(n){return n.text;}};}else{x={setNameSpace:function(o){return o;},nsResolver:function(b){var n={"edmx":"http://docs.oasis-open.org/odata/ns/edmx","d":"http://docs.oasis-open.org/odata/ns/edm"};return n[b]||null;},selectNodes:function(P,i){var b=p.xmlDocument.evaluate(P,i,this.nsResolver,7,null);b.length=b.snapshotLength;return b;},nextNode:function(n,i){return n.snapshotItem(i);},getNodeText:function(n){return n.textContent;}};}x.getPath=function(n){var P="";var I="getAttribute"in n?n.getAttribute("id"):"";var T=n.tagName?n.tagName:"";if(I){P='id("'+I+'")';}else if(n instanceof Document){P="/";}else if(T.toLowerCase()==="body"){P=T;}else if(n.parentNode){var b=1;for(var i=0;i<n.parentNode.childNodes.length;++i){if(n.parentNode.childNodes[i]===n){P=x.getPath(n.parentNode)+"/"+T+"["+b+"]";break;}else if(n.parentNode.childNodes[i].nodeType===1&&n.parentNode.childNodes[i].tagName===T){++b;}}}else{q.sap.log.error("Wrong Input node - cannot find XPath to it: "+T);}return P;};return x;}};return A;});
sap.ui.predefine('sap/ui/model/odata/CountMode',function(){"use strict";var C={Request:"Request",Inline:"Inline",InlineRepeat:"InlineRepeat",Both:"Both",None:"None"};return C;},true);
sap.ui.predefine('sap/ui/model/odata/Filter',['sap/ui/base/Object','sap/ui/model/Filter','sap/ui/model/FilterOperator'],function(B,F,a){"use strict";
var O=B.extend("sap.ui.model.odata.Filter",{
constructor:function(p,v,A){if(typeof p==="object"){var f=p;p=f.path;v=f.values;A=f.and;}this.sPath=p;this.aValues=v;this.bAND=A==undefined?true:A;},
convert:function(){var f=[];for(var i=0,l=this.aValues&&this.aValues.length||0;i<l;i++){f.push(new F({path:this.sPath,operator:this.aValues[i].operator,value1:this.aValues[i].value1,value2:this.aValues[i].value2}));}if(f.length>1){var o=new F({filters:f,and:this.bAND});return o;}else{return f[0];}}
});
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataAnnotations',['./AnnotationParser','jquery.sap.global','sap/ui/Device','sap/ui/base/EventProvider'],function(A,q,D,E){"use strict";
var O=E.extend("sap.ui.model.odata.ODataAnnotations",{
constructor:function(o){E.apply(this,arguments);if(arguments.length!==1){if(typeof arguments[2]==="object"){o=arguments[2];}o.urls=arguments[0];o.metadata=arguments[1];}this.oMetadata=o.metadata;this.oAnnotations=o.annotationData?o.annotationData:{};this.bLoaded=false;this.bAsync=o&&o.async;this.xPath=null;this.oError=null;this.bValidXML=true;this.oRequestHandles=[];this.oLoadEvent=null;this.oFailedEvent=null;this.mCustomHeaders=o.headers?q.extend({},o.headers):{};if(o.urls){this.addUrl(o.urls);if(!this.bAsync){if(this.oError){q.sap.log.error("OData annotations could not be loaded: "+this.oError.message);}}}},
metadata:{publicMethods:["parse","getAnnotationsData","attachFailed","detachFailed","attachLoaded","detachLoaded"]}
});
O.prototype.getAnnotationsData=function(){return this.oAnnotations;};
O.prototype.isLoaded=function(){return this.bLoaded;};
O.prototype.isFailed=function(){return this.oError!==null;};
O.prototype.fireLoaded=function(a){this.fireEvent("loaded",a);return this;};
O.prototype.attachLoaded=function(d,f,l){this.attachEvent("loaded",d,f,l);return this;};
O.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};
O.prototype.fireFailed=function(a){this.fireEvent("failed",a);return this;};
O.prototype.attachFailed=function(d,f,l){this.attachEvent("failed",d,f,l);return this;};
O.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};
O.prototype.setHeaders=function(h){this.mCustomHeaders=q.extend({},h);};
O.prototype._createXMLDocument=function(x,X){var o=null;if(typeof x==="string"){X=x;x=null;}if(D.browser.msie){o=new ActiveXObject("Microsoft.XMLDOM");o.preserveWhiteSpace=true;if(X.indexOf(" xmlns:xml=")>-1){X=X.replace(' xmlns:xml="http://www.w3.org/XML/1998/namespace"',"").replace(" xmlns:xml='http://www.w3.org/XML/1998/namespace'","");}o.loadXML(X);}else if(x){o=x;}else if(window.DOMParser){o=new DOMParser().parseFromString(X,'application/xml');}else{q.sap.log.fatal("The browser does not support XML parsing. Annotations are not available.");}return o;};
O.prototype._documentHasErrors=function(x){return(x.getElementsByTagName("parsererror").length>0||(x.parseError&&x.parseError.errorCode!==0));};
O.prototype._mergeAnnotationData=function(a,s){if(!this.oAnnotations){this.oAnnotations={};}A.merge(this.oAnnotations,a);this.bLoaded=true;if(!s){this.fireLoaded({annotations:a});}};
O.prototype.setXML=function(x,X,o){var d={success:function(){},error:function(){},fireEvents:false};o=q.extend({},d,o);var a=this._createXMLDocument(x,X);var p=function(a){var r={xmlDoc:a};var b=A.parse(this.oMetadata,a);if(b){r.annotations=b;o.success(r);this._mergeAnnotationData(b,!o.fireEvents);}else{o.error(r);if(o.fireEvents){this.fireFailed(r);}}}.bind(this,a);if(this._documentHasErrors(a)){o.error({xmlDoc:a});return false;}else{var m=this.oMetadata.getServiceMetadata();if(!m||q.isEmptyObject(m)){this.oMetadata.attachLoaded(p);}else{p();}return true;}};
O.prototype.addUrl=function(u){var t=this;var U=u;if(Array.isArray(u)&&u.length==0){return Promise.resolve({annotations:this.oAnnotations});}if(!Array.isArray(u)){U=[u];}return new Promise(function(r,R){var l=0;var m={annotations:null,success:[],fail:[]};var f=function(a){l++;if(a.type==="success"){m.success.push(a);}else{m.fail.push(a);}if(l===U.length){m.annotations=t.oAnnotations;if(m.success.length>0){var s={annotations:t.oAnnotations,results:m};t.fireLoaded(s);}if(m.success.length<U.length){var e=new Error("At least one annotation failed to load/parse/merge");e.annotations=m.annotations;e.success=m.success;e.fail=m.fail;R(e);}else{r(m);}}};var i=0;if(t.bAsync){var p=Promise.resolve();for(i=0;i<U.length;++i){var L=t._loadFromUrl.bind(t,U[i]);p=p.then(L,L).then(f,f);}}else{for(i=0;i<U.length;++i){t._loadFromUrl(U[i]).then(f,f);}}});};
O.prototype._loadFromUrl=function(u){var t=this;return new Promise(function(r,R){var a={url:u,async:t.bAsync,headers:q.extend({},t.mCustomHeaders,{"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()})};var o;var f=function(j,S){if(o&&o.bSuppressErrorHandlerCall){return;}t.oError={type:"fail",url:u,message:S,statusCode:j.statusCode,statusText:j.statusText,responseText:j.responseText};if(t.bAsync){t.oFailedEvent=q.sap.delayedCall(0,t,t.fireFailed,[t.oError]);}else{t.fireFailed(t.oError);}R(t.oError);};var s=function(d,S,j){t.setXML(j.responseXML,j.responseText,{success:function(m){r({type:"success",url:u,message:S,statusCode:j.statusCode,statusText:j.statusText,responseText:j.responseText});},error:function(m){f(j,"Malformed XML document");},url:u});};q.ajax(a).done(s).fail(f);});};
O.prototype.destroy=function(){for(var i=0;i<this.oRequestHandles.length;++i){if(this.oRequestHandles[i]){this.oRequestHandles[i].bSuppressErrorHandlerCall=true;this.oRequestHandles[i].abort();this.oRequestHandles[i]=null;}}E.prototype.destroy.apply(this,arguments);if(this.oLoadEvent){q.sap.clearDelayedCall(this.oLoadEvent);}if(this.oFailedEvent){q.sap.clearDelayedCall(this.oFailedEvent);}};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataContextBinding',['sap/ui/model/ContextBinding','sap/ui/model/ChangeReason'],function(C,a){"use strict";
var O=C.extend("sap.ui.model.odata.ODataContextBinding",{constructor:function(m,p,c,P,e){C.call(this,m,p,c,P,e);}});
O.prototype.initialize=function(){var t=this,r=this.oModel.resolve(this.sPath,this.oContext),d=this.oModel._getObject(this.sPath,this.oContext),R=this.oModel._isReloadNeeded(r,d,this.mParameters);if(this.oModel.oMetadata.isLoaded()){if(r&&R){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(c){t.oElementContext=c;t._fireChange({reason:a.Context});if(r&&R){t.fireDataReceived();}},R);}};
O.prototype.refresh=function(f,c){var t=this,k,s,b=false,r=this.oModel.resolve(this.sPath,this.oContext);if(c){s=this.oModel._getObject(this.sPath,this.oContext);if(s){k=this.oModel._getKey(s);if(k in c){b=true;}}}else{b=true;}if(f||b){if(r){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(o){if(t.oElementContext===o){if(f){t._fireChange({reason:a.Context});}}else{t.oElementContext=o;t._fireChange({reason:a.Context});}if(r){t.fireDataReceived();}},true);}};
O.prototype.setContext=function(c){var t=this,r,d,R;if(this.oContext!==c&&this.isRelative()){this.oContext=c;r=this.oModel.resolve(this.sPath,this.oContext);d=this.oModel._getObject(this.sPath,this.oContext);R=this.oModel._isReloadNeeded(r,d,this.mParameters);if(r&&R){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(c){t.oElementContext=c;t._fireChange({reason:a.Context});if(r&&R){t.fireDataReceived();}},R);}};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataListBinding',['jquery.sap.global','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterType','sap/ui/model/ListBinding','sap/ui/model/Sorter','./ODataUtils','./CountMode'],function(q,C,F,a,L,S,O,b){"use strict";
var c=L.extend("sap.ui.model.odata.ODataListBinding",{constructor:function(m,p,o,s,f,P){L.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.bPendingChange=false;this.aKeys=[];this.bInitial=true;this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.oModel.checkFilterOperation(this.aApplicationFilters);if(!this.oModel.getServiceMetadata()){var t=this,d=function(e){t.bInitial=false;t._initSortersFilters();t.oModel.detachMetadataLoaded(d);};this.oModel.attachMetadataLoaded(this,d);}else{this.bInitial=false;this._initSortersFilters();}var r=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=r;if(Array.isArray(r)&&!s&&!f){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this.bDataAvailable=true;}else if(r===null&&this.oModel.resolve(this.sPath,this.oContext)){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true;}else{if(this.oModel.getServiceMetadata()){this.resetData();}}}});
c.prototype.getContexts=function(s,l,t){if(this.bInitial){return[];}this.iLastLength=l;this.iLastStartIndex=s;this.iLastThreshold=t;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength;}}if(!t){t=0;}var d=true,e=this._getContexts(s,l),o={},f;f=this.calculateSection(s,l,t,e);d=e.length!=l&&!(this.bLengthFinal&&e.length>=this.iLength-s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&f.length>0&&(d||l<f.length)){this.loadData(f.startIndex,f.length);e.dataRequested=true;}}if(this.bRefresh){if(this.bLengthFinal&&this.iLength==0){this.loadData(f.startIndex,f.length,true);e.dataRequested=true;}this.bRefresh=false;}else{for(var i=0;i<e.length;i++){o[e[i].getPath()]=e[i].getObject();}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&s<this.iLastEndIndex){var g=this;var D=q.sap.arrayDiff(this.aLastContexts,e,function(h,n){return q.sap.equal(h&&g.oLastContextData&&g.oLastContextData[h.getPath()],n&&o&&o[n.getPath()]);},true);e.diff=D;}}this.iLastEndIndex=s+l;this.aLastContexts=e.slice(0);this.oLastContextData=q.sap.extend(true,{},o);}return e;};
c.prototype.getCurrentContexts=function(){return this.aLastContexts||[];};
c.prototype._getContexts=function(s,l){var d=[],o,k;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength;}}for(var i=s;i<s+l;i++){k=this.aKeys[i];if(!k){break;}o=this.oModel.getContext('/'+k);d.push(o);}return d;};
c.prototype.calculateSection=function(s,l,t,d){var e,f,p,P,r,o={},k;f=s;e=0;for(var i=s;i>=Math.max(s-t,0);i--){k=this.aKeys[i];if(!k){P=i+1;break;}}for(var j=s+l;j<s+l+t;j++){k=this.aKeys[j];if(!k){p=j;break;}}r=s-P;if(P&&s>t&&r<t){if(d.length!=l){f=s-t;}else{f=P-t;}e=t;}f=Math.max(f,0);if(f==s){f+=d.length;}if(d.length!=l){e+=l-d.length;}r=p-s-l;if(r==0){e+=t;}if(p&&r<t&&r>0){if(f>s){f=p;e+=t;}}if(this.bLengthFinal&&this.iLength<(e+f)){e=this.iLength-f;}o.startIndex=f;o.length=e;return o;};
c.prototype.setContext=function(o){if(this.oContext!=o){this.oContext=o;if(this.isRelative()){this._initSortersFilters();if(!this.bInitial){var r=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=r;if(Array.isArray(r)&&!this.aSorters.length>0&&!this.aFilters.length>0){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this._fireChange({reason:C.Context});}else if(!this.oModel.resolve(this.sPath,this.oContext)||r===null){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this._fireChange({reason:C.Context});}else{this.refresh();}}}}};
c.prototype.getDownloadUrl=function(f){var p=[],P;if(f){p.push("$format="+encodeURIComponent(f));}if(this.sSortParams){p.push(this.sSortParams);}if(this.sFilterParams){p.push(this.sFilterParams);}if(this.sCustomParams){p.push(this.sCustomParams);}P=this.oModel.resolve(this.sPath,this.oContext);if(P){return this.oModel._createRequestUrl(P,null,p);}};
c.prototype.loadData=function(s,l,p){var t=this,I=false;if(s||l){this.sRangeParams="$skip="+s+"&$top="+l;this.iStartIndex=s;}else{s=this.iStartIndex;}var P=[];if(this.sRangeParams){P.push(this.sRangeParams);}if(this.sSortParams){P.push(this.sSortParams);}if(this.sFilterParams){P.push(this.sFilterParams);}if(this.sCustomParams){P.push(this.sCustomParams);}if(!this.bLengthFinal&&(this.sCountMode==b.Inline||this.sCountMode==b.Both)){P.push("$inlinecount=allpages");I=true;}function f(D){q.each(D.results,function(i,h){t.aKeys[s+i]=t.oModel._getKey(h);});if(I&&D.__count){t.iLength=parseInt(D.__count,10);t.bLengthFinal=true;}if(t.iLength<s+D.results.length){t.iLength=s+D.results.length;t.bLengthFinal=false;}if(D.results.length<l||l===undefined){t.iLength=s+D.results.length;t.bLengthFinal=true;}if(s==0&&D.results.length==0){t.iLength=0;t.bLengthFinal=true;}t.oRequestHandle=null;t.bPendingRequest=false;t.bNeedsUpdate=true;t.bIgnoreSuspend=true;}function d(D){t.fireDataReceived({data:D});}function e(E,A){t.oRequestHandle=null;t.bPendingRequest=false;if(!A){t.aKeys=[];t.iLength=0;t.bLengthFinal=true;t.bDataAvailable=true;t._fireChange({reason:C.Change});}t.fireDataReceived();}function u(h){t.oRequestHandle=h;}var g=this.sPath,o=this.oContext;if(this.isRelative()){g=this.oModel.resolve(g,o);}if(g){if(p){var U=this.oModel._createRequestUrl(g,null,P);this.fireDataRequested();this.oModel.fireRequestSent({url:U,method:"GET",async:true});setTimeout(function(){t.bNeedsUpdate=true;t.checkUpdate();t.oModel.fireRequestCompleted({url:U,method:"GET",async:true,success:true});t.fireDataReceived({data:{}});},0);}else{this.bPendingRequest=true;this.fireDataRequested();this.oModel._loadData(g,P,f,e,false,u,d);}}};
c.prototype.getLength=function(){if(this.bLengthFinal||this.iLength==0){return this.iLength;}else{var A=this.iLastThreshold||this.iLastLength||10;return this.iLength+A;}};
c.prototype.isLengthFinal=function(){return this.bLengthFinal;};
c.prototype._getLength=function(){var t=this;var p=[];if(this.sFilterParams){p.push(this.sFilterParams);}if(this.mParameters&&this.mParameters.custom){var o={custom:{}};q.each(this.mParameters.custom,function(s,v){o.custom[s]=v;});p.push(this.oModel.createCustomParams(o));}function _(D){t.iLength=parseInt(D,10);t.bLengthFinal=true;}function d(e){var E="Request for $count failed: "+e.message;if(e.response){E+=", "+e.response.statusCode+", "+e.response.statusText+", "+e.response.body;}q.sap.log.warning(E);}var P=this.oModel.resolve(this.sPath,this.oContext);if(P){var u=this.oModel._createRequestUrl(P+"/$count",null,p);var r=this.oModel._createRequest(u,"GET",false);r.headers["Accept"]="text/plain, */*;q=0.5";this.oModel._request(r,_,d,undefined,undefined,this.oModel.getServiceMetadata());}};
c.prototype.refresh=function(f,m,e){var d=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e)){d=true;}}if(m&&!d){q.each(this.aKeys,function(i,k){if(k in m){d=true;return false;}});}if(!m&&!e){d=true;}}if(f||d){this.abortPendingRequest();this.resetData();this._fireRefresh({reason:C.Refresh});}};
c.prototype._fireRefresh=function(A){if(this.oModel.resolve(this.sPath,this.oContext)){this.bRefresh=true;this.fireEvent("refresh",A);}};
c.prototype.initialize=function(){if(this.oModel.oMetadata.isLoaded()){if(this.bDataAvailable){this._fireChange({reason:C.Change});}else{this._fireRefresh({reason:C.Refresh});}}};
c.prototype.checkUpdate=function(f,m){var d=this.sChangeReason?this.sChangeReason:C.Change,e=false,l,o,t=this,r,R;if(this.bSuspended&&!this.bIgnoreSuspend){return;}if(!f&&!this.bNeedsUpdate){r=this.oModel._getObject(this.sPath,this.oContext);R=Array.isArray(r)&&!q.sap.equal(r,this.aExpandRefs);this.aExpandRefs=r;if(R){if(this.aSorters.length>0||this.aFilters.length>0){this.refresh();return;}else{this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;e=true;}}else if(m){q.each(this.aKeys,function(i,k){if(k in m){e=true;return false;}});}else{e=true;}if(e&&this.aLastContexts){e=false;var g=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!=g.length){e=true;}else{q.each(this.aLastContexts,function(i,h){l=t.oLastContextData[h.getPath()];o=g[i].getObject();if(!q.sap.equal(l,o,true)){e=true;return false;}});}}}if(f||e||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:d});}this.sChangeReason=undefined;this.bIgnoreSuspend=false;};
c.prototype.resetData=function(){this.aKeys=[];this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;if(this.oModel.isCountSupported()&&(this.sCountMode==b.Request||this.sCountMode==b.Both)){this._getLength();}};
c.prototype.abortPendingRequest=function(){if(this.oRequestHandle){this.oRequestHandle.abort();this.oRequestHandle=null;this.bPendingRequest=false;}};
c.prototype.sort=function(s,r){var d=false;if(!s){s=[];}if(s instanceof S){s=[s];}this.aSorters=s;this.createSortParams(s);if(!this.bInitial){this.aKeys=[];this.abortPendingRequest();this.sChangeReason=C.Sort;this._fireRefresh({reason:this.sChangeReason});this._fireSort({sorter:s});d=true;}if(r){return d;}else{return this;}};
c.prototype.createSortParams=function(s){this.sSortParams=O.createSortParams(s);};
c.prototype.filter=function(f,s,r){var d=false;if(!f){f=[];}if(f instanceof F){f=[f];}this.oModel.checkFilterOperation(f);if(s==a.Application){this.aApplicationFilters=f;}else{this.aFilters=f;}if(!f||!Array.isArray(f)||f.length==0){this.aFilters=[];}if(!this.aApplicationFilters||!Array.isArray(this.aApplicationFilters)||this.aApplicationFilters.length===0){this.aApplicationFilters=[];}this.createFilterParams(this.aFilters,this.aApplicationFilters);if(!this.bInitial){this.resetData();this.abortPendingRequest();this.sChangeReason=C.Filter;this._fireRefresh({reason:this.sChangeReason});if(s==a.Application){this._fireFilter({filters:this.aApplicationFilters});}else{this._fireFilter({filters:this.aFilters});}d=true;}if(r){return d;}else{return this;}};
c.prototype.createFilterParams=function(d,A){var f,s=O._createFilterParams(d,this.oModel.oMetadata,this.oEntityType),e=O._createFilterParams(A,this.oModel.oMetadata,this.oEntityType);if(s){f=s;}if(e){if(s){f="("+f+")"+"%20and%20"+"("+e+")";}else{f=e;}}if(f){this.sFilterParams="$filter="+f;}else{this.sFilterParams=undefined;}};
c.prototype._initSortersFilters=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(!r){return;}this.oEntityType=this._getEntityType();this.createSortParams(this.aSorters);this.createFilterParams(this.aFilters.concat(this.aApplicationFilters));};
c.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var e=this.oModel.oMetadata._getEntityTypeByPath(r);return e;}return undefined;};
c.prototype.resume=function(){this.bIgnoreSuspend=false;L.prototype.resume.apply(this,arguments);};
return c;});
sap.ui.predefine('sap/ui/model/odata/ODataMessageParser',["jquery.sap.global","sap/ui/model/odata/ODataUtils","sap/ui/core/library","sap/ui/thirdparty/URI","sap/ui/core/message/MessageParser","sap/ui/core/message/Message"],function(q,O,c,U,M,a){"use strict";var b=c.MessageType;var s={"error":b.Error,"warning":b.Warning,"success":b.Success,"info":b.Information};
var d=M.extend("sap.ui.model.odata.ODataMessageParser",{
metadata:{publicMethods:["parse","setProcessor","getHeaderField","setHeaderField"]},
constructor:function(S,m){M.apply(this);this._serviceUrl=e(this._parseUrl(S).url);this._metadata=m;this._processor=null;this._headerField="sap-message";this._lastMessages=[];}
});
d.prototype.getHeaderField=function(){return this._headerField;};
d.prototype.setHeaderField=function(F){this._headerField=F;return this;};
d.prototype.parse=function(r,R,G,C){var m=[];var h={url:R?R.requestUri:r.requestUri,request:R,response:r};if(r.statusCode>=200&&r.statusCode<300){this._parseHeader(m,r,h);}else if(r.statusCode>=400&&r.statusCode<600){this._parseBody(m,r,h);}else{q.sap.log.warning("No rule to parse OData response with status "+r.statusCode+" for messages");}if(this._processor){this._propagateMessages(m,h,G,C);}else{this._outputMesages(m);}};
d.prototype._isNavigationProperty=function(p,P){var E=this._metadata._getEntityTypeByPath(p);if(E){var n=this._metadata._getNavigationPropertyNames(E);return n.indexOf(P)>-1;}return false;};
d.prototype._getAffectedTargets=function(m,r,G,C){var A=q.extend({"":true},G,C);var R=this._parseUrl(r).url;if(R.indexOf(this._serviceUrl)===0){R=R.substr(this._serviceUrl.length+1);}var E=this._metadata._getEntitySetByPath(R);if(E){A[E.name]=true;}for(var i=0;i<m.length;++i){var t=m[i].getTarget();if(t){var T=t.replace(/^\/+|\/$/g,"");A[T]=true;var S=T.lastIndexOf("/");if(S>0){var p=T.substr(0,S);var P=T.substr(S);var I=this._isNavigationProperty(p,P);if(!I){A[p]=true;}}}}return A;};
d.prototype._propagateMessages=function(m,r,G,C){var i,t;var A=this._getAffectedTargets(m,r.url,G,C);var R=[];var k=[];for(i=0;i<this._lastMessages.length;++i){t=this._lastMessages[i].getTarget().replace(/^\/+|\/$/g,"");var p=t.lastIndexOf(")/");if(p>0){t=t.substr(0,p+1);}if(A[t]&&!this._lastMessages[i].getPersistent()){R.push(this._lastMessages[i]);}else{k.push(this._lastMessages[i]);}}this.getProcessor().fireMessageChange({oldMessages:R,newMessages:m});this._lastMessages=k.concat(m);};
d.prototype._createMessage=function(m,r,i){var t=m["@sap.severity"]?m["@sap.severity"]:m["severity"];t=s[t]?s[t]:t;var C=m.code?m.code:"";var T=typeof m["message"]==="object"&&m["message"]["value"]?m["message"]["value"]:m["message"];var D=m.longtext_url?m.longtext_url:"";var p=false;if(!m.target&&m.propertyref){m.target=m.propertyref;}if(typeof m.target==="undefined"){m.target="";}if(m.target.indexOf("/#TRANSIENT#")===0){p=true;m.target=m.target.substr(12);}else if(m.transient){p=true;}var h=this._createTarget(m,r);return new a({type:t,code:C,message:T,descriptionUrl:D,target:O._normalizeKey(h),processor:this._processor,technical:i,persistent:p});};
d.prototype._getFunctionTarget=function(F,r,u){var t="";var i;if(r.response&&r.response.headers&&r.response.headers["location"]){t=r.response.headers["location"];var p=t.lastIndexOf(this._serviceUrl);if(p>-1){t=t.substr(p+this._serviceUrl.length);}}else{var A=null;if(F.extensions){for(i=0;i<F.extensions.length;++i){if(F.extensions[i].name==="action-for"){A=F.extensions[i].value;break;}}}var E;if(A){E=this._metadata._getEntityTypeByName(A);}else if(F.entitySet){E=this._metadata._getEntityTypeByPath(F.entitySet);}else if(F.returnType){E=this._metadata._getEntityTypeByName(F.returnType);}if(E){var m=this._metadata._getEntitySetByType(E);if(m&&E&&E.key&&E.key.propertyRef){var I="";var P;if(E.key.propertyRef.length===1){P=E.key.propertyRef[0].name;if(u.parameters[P]){I=u.parameters[P];}}else{var k=[];for(i=0;i<E.key.propertyRef.length;++i){P=E.key.propertyRef[i].name;if(u.parameters[P]){k.push(P+"="+u.parameters[P]);}}I=k.join(",");}t="/"+m.name+"("+I+")";}else if(!m){q.sap.log.error("Could not determine path of EntitySet for function call: "+u.url);}else{q.sap.log.error("Could not determine keys of EntityType for function call: "+u.url);}}}return t;};
d.prototype._createTarget=function(m,r){var t=m.target;if(t.substr(0,1)!=="/"){var R="";var h=(r.request&&r.request.method)?r.request.method:"GET";var i=(h==="POST"&&r.response&&r.response.statusCode==201&&r.response.headers&&r.response.headers["location"]);var u;if(i){u=r.response.headers["location"];}else if(r.request&&r.request.key&&r.request.created&&r.response&&r.response.statusCode>=400){u=r.request.key;}else{u=r.url;}var j=this._parseUrl(u);var k=j.url;var p=k.lastIndexOf(this._serviceUrl);if(p>-1){R=k.substr(p+this._serviceUrl.length+1);}else{R=k;}if(!i){var F=this._metadata._getFunctionImportMetadata(R,h);if(F){R=this._getFunctionTarget(F,r,j);if(t){t=R+"/"+t;}else{t=R;}return t;}}R="/"+R;var S=R.lastIndexOf("/");var n=S>-1?R.substr(S):R;if(n.indexOf("(")>-1){t=t?R+"/"+t:R;}else{t=R+t;}}return t;};
d.prototype._parseHeader=function(m,r,R){var F=this.getHeaderField();if(!r.headers){return;}for(var k in r.headers){if(k.toLowerCase()===F.toLowerCase()){F=k;}}if(!r.headers[F]){return;}var h=r.headers[F];var S=null;try{S=JSON.parse(h);m.push(this._createMessage(S,R));if(Array.isArray(S.details)){for(var i=0;i<S.details.length;++i){m.push(this._createMessage(S.details[i],R));}}}catch(j){q.sap.log.error("The message string returned by the back-end could not be parsed");return;}};
d.prototype._parseBody=function(m,r,R){var C=g(r);if(C&&C.indexOf("xml")>-1){this._parseBodyXML(m,r,R,C);}else{this._parseBodyJSON(m,r,R);}if(m.length>1){for(var i=1;i<m.length;i++){if(m[0].getCode()==m[i].getCode()&&m[0].getMessage()==m[i].getMessage()){m.shift();break;}}}};
d.prototype._parseBodyXML=function(h,r,R,C){try{var D=new DOMParser().parseFromString(r.body,C);var E=f(D,["error","errordetail"]);for(var i=0;i<E.length;++i){var N=E[i];var o={};o["severity"]=b.Error;for(var n=0;n<N.childNodes.length;++n){var j=N.childNodes[n];var k=j.nodeName;if(k==="errordetails"||k==="details"||k==="innererror"||k==="#text"){continue;}if(k==="message"&&j.hasChildNodes()&&j.firstChild.nodeType!==window.Node.TEXT_NODE){for(var m=0;m<j.childNodes.length;++m){if(j.childNodes[m].nodeName==="value"){o["message"]=j.childNodes[m].text||j.childNodes[m].textContent;}}}else{o[j.nodeName]=j.text||j.textContent;}}h.push(this._createMessage(o,R,true));}}catch(p){q.sap.log.error("Error message returned by server could not be parsed");}};
d.prototype._parseBodyJSON=function(m,r,R){try{var E=JSON.parse(r.body);var o;if(E["error"]){o=E["error"];}else{o=E["odata.error"];}if(!o){q.sap.log.error("Error message returned by server did not contain error-field");return;}o["severity"]=b.Error;m.push(this._createMessage(o,R,true));var F=null;if(Array.isArray(o.details)){F=o.details;}else if(o.innererror&&Array.isArray(o.innererror.errordetails)){F=o.innererror.errordetails;}else{F=[];}for(var i=0;i<F.length;++i){m.push(this._createMessage(F[i],R,true));}}catch(h){q.sap.log.error("Error message returned by server could not be parsed");}};
d.prototype._parseUrl=function(u){var m={url:u,parameters:{},hash:""};var p=-1;p=u.indexOf("#");if(p>-1){m.hash=m.url.substr(p+1);m.url=m.url.substr(0,p);}p=u.indexOf("?");if(p>-1){var P=m.url.substr(p+1);m.parameters=U.parseQuery(P);m.url=m.url.substr(0,p);}return m;};
d.prototype._outputMesages=function(m){for(var i=0;i<m.length;++i){var o=m[i];var h="[OData Message] "+o.getMessage()+" - "+o.getDescription()+" ("+o.getTarget()+")";switch(m[i].getType()){case b.Error:q.sap.log.error(h);break;case b.Warning:q.sap.log.warning(h);break;case b.Success:q.sap.log.debug(h);break;case b.Information:case b.None:default:q.sap.log.info(h);break;}}};
function g(r){if(r&&r.headers){for(var h in r.headers){if(h.toLowerCase()==="content-type"){return r.headers[h].replace(/([^;]*);.*/,"$1");}}}return false;}
var l=document.createElement("a");
function e(u){l.href=u;return U.parse(l.href).path;}
function f(D,E){var h=[];var m={};for(var i=0;i<E.length;++i){m[E[i]]=true;}var o=D;while(o){if(m[o.tagName]){h.push(o);}if(o.hasChildNodes()){o=o.firstChild;}else{while(!o.nextSibling){o=o.parentNode;if(!o||o===D){o=null;break;}}if(o){o=o.nextSibling;}}}return h;}
return d;});
sap.ui.predefine('sap/ui/model/odata/ODataMetaModel',['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/base/BindingParser','sap/ui/model/Context','sap/ui/base/ManagedObject','sap/ui/model/ClientContextBinding','sap/ui/model/FilterProcessor','sap/ui/model/json/JSONModel','sap/ui/model/json/JSONListBinding','sap/ui/model/json/JSONPropertyBinding','sap/ui/model/json/JSONTreeBinding','sap/ui/model/MetaModel','./_ODataMetaModelUtils'],function(q,B,a,C,M,b,F,J,c,d,e,f,U){"use strict";var o="sap.ui.model.odata.ODataMetaModel",p=[o],P=o+"/load",r=/^((\/dataServices\/schema\/\d+)\/(?:complexType|entityType)\/\d+)\/property\/\d+$/;var O=c.extend("sap.ui.model.odata.ODataMetaListBinding"),R=M.extend("sap.ui.model.odata._resolver",{metadata:{properties:{any:"any"}}});
O.prototype.applyFilter=function(){var t=this;this.aIndices=F.apply(this.aIndices,this.aFilters.concat(this.aApplicationFilters),function(v,s){return s==="@sapui.name"?v:t.oModel.getProperty(s,t.oList[v]);});this.iLength=this.aIndices.length;};
var g=f.extend("sap.ui.model.odata.ODataMetaModel",{constructor:function(m,A,h){var t=this;function l(){var D;if(t.bDestroyed){throw new Error("Meta model already destroyed");}q.sap.measure.average(P,"",p);D=JSON.parse(JSON.stringify(m.getServiceMetadata()));t.oModel=new J(D);t.oModel.setDefaultBindingMode(t.sDefaultBindingMode);U.merge(A?A.getAnnotationsData():{},D,t);q.sap.measure.end(P);}h=h||{};f.apply(this);this.oModel=null;this.mContext2Promise={};this.sDefaultBindingMode=B.OneTime;this.oLoadedPromise=h.annotationsLoadedPromise?h.annotationsLoadedPromise.then(l):new Promise(function(i,j){l();i();});this.oMetadata=m;this.oODataModelInterface=h;this.mQueryCache={};this.mQName2PendingRequest={};this.oResolver=undefined;this.mSupportedBindingModes={"OneTime":true};}});
g.prototype._getObject=function(s,h){var j=h,k,l,i,E,n,v,m,t=s||"",u;if(!h||h instanceof C){t=this.resolve(s||"",h);if(!t){q.sap.log.error("Invalid relative path w/o context",s,o);return null;}}if(t.charAt(0)==="/"){j=this.oModel._getObject("/");t=t.slice(1);}m="/";n=j;while(t){v=undefined;k=undefined;if(t.charAt(0)==='['){try{u=a.parseExpression(t,1);E=u.at;if(t.length===E+1||t.charAt(E+1)==='/'){k=u.result;v=t.slice(0,E+1);t=t.slice(E+2);}}catch(w){if(!(w instanceof SyntaxError)){throw w;}}}if(v===undefined){E=t.indexOf("/");if(E<0){v=t;t="";}else{v=t.slice(0,E);t=t.slice(E+1);}}if(!n){if(q.sap.log.isLoggable(q.sap.log.Level.WARNING,o)){q.sap.log.warning("Invalid part: "+v,"path: "+s+", context: "+(h instanceof C?h.getPath():h),o);}break;}if(k){if(j===h){q.sap.log.error("A query is not allowed when an object context has been given",s,o);return null;}if(!Array.isArray(n)){q.sap.log.error("Invalid query: '"+m+"' does not point to an array",s,o);return null;}l=m+v;v=this.mQueryCache[l];if(v===undefined){this.oResolver=this.oResolver||new R({models:this.oModel});for(i=0;i<n.length;i++){this.oResolver.bindObject(m+i);this.oResolver.bindProperty("any",k);try{if(this.oResolver.getAny()){this.mQueryCache[l]=v=i;break;}}finally{this.oResolver.unbindProperty("any");this.oResolver.unbindObject();}}}}n=n[v];m=m+v+"/";}return n;};
g.prototype._mergeMetadata=function(h){var E=this.getODataEntityContainer(),m=U.getChildAnnotations(h.annotations,E.namespace+"."+E.name,true),i=E.entitySet.length,s=this.oModel.getObject("/dataServices/schema"),t=this;h.entitySets.forEach(function(j){var k,S,T=j.entityType,n=T.slice(0,T.lastIndexOf("."));if(!t.getODataEntitySet(j.name)){E.entitySet.push(JSON.parse(JSON.stringify(j)));if(!t.getODataEntityType(T)){k=t.oMetadata._getEntityTypeByName(T);S=U.getSchema(s,n);S.entityType.push(JSON.parse(JSON.stringify(k)));U.visitParents(S,h.annotations,"entityType",U.visitEntityType,S.entityType.length-1);}}});U.visitChildren(E.entitySet,m,"EntitySet",s,null,i);};
g.prototype._sendBundledRequest=function(){var Q=this.mQName2PendingRequest,h=Object.keys(Q),t=this;if(!h.length){return;}this.mQName2PendingRequest={};h=h.sort();h.forEach(function(s,i){h[i]=encodeURIComponent(s);});this.oODataModelInterface.addAnnotationUrl("$metadata?sap-value-list="+h.join(",")).then(function(i){var s;t._mergeMetadata(i);for(s in Q){try{Q[s].resolve(i);}catch(E){Q[s].reject(E);}}},function(E){var s;for(s in Q){Q[s].reject(E);}});};
g.prototype.bindContext=function(s,h,m){return new b(this,s,h,m);};
g.prototype.bindList=function(s,h,S,i,m){return new O(this,s,h,S,i,m);};
g.prototype.bindProperty=function(s,h,m){return new d(this,s,h,m);};
g.prototype.bindTree=function(s,h,i,m){return new e(this,s,h,i,m);};
g.prototype.destroy=function(){f.prototype.destroy.apply(this,arguments);return this.oModel&&this.oModel.destroy.apply(this.oModel,arguments);};
g.prototype.getAdapterFactoryModulePath=function(){return"sap/ui/model/odata/v2/meta/ODataAdapterFactory";};
g.prototype.getMetaContext=function(s){var A,E,h,i,m,n,j,k,Q;function l(S){var t=S.indexOf("(");return t>=0?S.slice(0,t):S;}if(!s){return null;}k=s.split("/");if(k[0]!==""){throw new Error("Not an absolute path: "+s);}k.shift();j=l(k[0]);E=this.getODataEntitySet(j);if(E){Q=E.entityType;}else{i=this.getODataFunctionImport(j);if(i){if(k.length===1){m=this.getODataFunctionImport(j,true);}Q=i.returnType;if(Q.lastIndexOf("Collection(",0)===0){Q=Q.slice(11,-1);}}else{throw new Error("Entity set or function import not found: "+j);}}k.shift();while(k.length){h=this.getODataEntityType(Q);if(h){n=l(k[0]);A=this.getODataAssociationEnd(h,n);}else{h=this.getODataComplexType(Q);}if(A){Q=A.type;if(A.multiplicity==="1"&&n!==k[0]){throw new Error("Multiplicity is 1: "+k[0]);}k.shift();}else{m=this.getODataProperty(h,k,true);if(k.length){throw new Error("Property not found: "+k.join("/"));}break;}}m=m||this.getODataEntityType(Q,true);return this.createBindingContext(m);};
g.prototype.getODataAssociationEnd=function(E,n){var N=E?U.findObject(E.navigationProperty,n):null,A=N?U.getObject(this.oModel,"association",N.relationship):null,h=A?U.findObject(A.end,N.toRole,"role"):null;return h;};
g.prototype.getODataAssociationSetEnd=function(E,n){var A,h=null,i=this.getODataEntityContainer(),N=E?U.findObject(E.navigationProperty,n):null;if(i&&N){A=U.findObject(i.associationSet,N.relationship,"association");h=A?U.findObject(A.end,N.toRole,"role"):null;}return h;};
g.prototype.getODataComplexType=function(Q,A){return U.getObject(this.oModel,"complexType",Q,A);};
g.prototype.getODataEntityContainer=function(A){var v=A?undefined:null,s=this.oModel.getObject("/dataServices/schema");if(s){s.forEach(function(S,i){var j=U.findIndex(S.entityContainer,"true","isDefaultEntityContainer");if(j>=0){v=A?"/dataServices/schema/"+i+"/entityContainer/"+j:S.entityContainer[j];return false;}});if(!v&&s.length===1&&s[0].entityContainer&&s[0].entityContainer.length===1){v=A?"/dataServices/schema/0/entityContainer/0":s[0].entityContainer[0];}}return v;};
g.prototype.getODataEntitySet=function(n,A){return U.getFromContainer(this.getODataEntityContainer(),"entitySet",n,A);};
g.prototype.getODataEntityType=function(Q,A){return U.getObject(this.oModel,"entityType",Q,A);};
g.prototype.getODataFunctionImport=function(n,A){var h=n&&n.indexOf('/')>=0?n.split('/'):undefined,E=h?U.getObject(this.oModel,"entityContainer",h[0]):this.getODataEntityContainer();return U.getFromContainer(E,"functionImport",h?h[1]:n,A);};
g.prototype.getODataProperty=function(t,n,A){var i,h=Array.isArray(n)?n:[n],j=null,s;while(t&&h.length){i=U.findIndex(t.property,h[0]);if(i<0){break;}h.shift();j=t.property[i];s=t.$path+"/property/"+i;if(h.length){t=this.getODataComplexType(j.type);}}return A?s:j;};
g.prototype.getODataValueLists=function(h){var i=false,m,s=h.getPath(),j=this.mContext2Promise[s],t=this;if(j){return j;}m=r.exec(s);if(!m){throw new Error("Unsupported property context with path "+s);}j=new Promise(function(k,l){var n=h.getObject(),Q,v=U.getValueLists(n);if(!(""in v)&&n["sap:value-list"]&&t.oODataModelInterface.addAnnotationUrl){i=true;Q=t.oModel.getObject(m[2]).namespace+"."+t.oModel.getObject(m[1]).name;t.mQName2PendingRequest[Q+"/"+n.name]={resolve:function(u){q.extend(n,(u.annotations.propertyAnnotations[Q]||{})[n.name]);v=U.getValueLists(n);if(q.isEmptyObject(v)){l(new Error("No value lists returned for "+s));}else{delete t.mContext2Promise[s];k(v);}},reject:l};setTimeout(t._sendBundledRequest.bind(t),0);}else{k(v);}});if(i){this.mContext2Promise[s]=j;}return j;};
g.prototype.getProperty=function(){return this._getObject.apply(this,arguments);};
g.prototype.isList=function(){return this.oModel.isList.apply(this.oModel,arguments);};
g.prototype.loaded=function(){return this.oLoadedPromise;};
g.prototype.refresh=function(){throw new Error("Unsupported operation: ODataMetaModel#refresh");};
g.prototype.setLegacySyntax=function(l){if(l){throw new Error("Legacy syntax not supported by ODataMetaModel");}};
g.prototype.setProperty=function(){throw new Error("Unsupported operation: ODataMetaModel#setProperty");};
return g;});
sap.ui.predefine('sap/ui/model/odata/ODataMetadata',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/thirdparty/datajs','sap/ui/core/cache/CacheManager','./_ODataMetaModelUtils'],function(q,E,O,C,U){"use strict";
var a=E.extend("sap.ui.model.odata.ODataMetadata",{
constructor:function(m,p){E.apply(this,arguments);this.bLoaded=false;this.bFailed=false;this.mEntityTypes={};this.mRequestHandles={};this.sUrl=m;this.bAsync=p.async;this.sUser=p.user;this.bWithCredentials=p.withCredentials;this.sPassword=p.password;this.mHeaders=p.headers;this.sCacheKey=p.cacheKey;this.oLoadEvent=null;this.oFailedEvent=null;this.oMetadata=null;this.mNamespaces=p.namespaces||{sap:"http://www.sap.com/Protocols/SAPData",m:"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata","":"http://schemas.microsoft.com/ado/2007/06/edmx"};var t=this;this.fnResolve;this.pLoaded=new Promise(function(r,b){t.fnResolve=r;});function w(p){C.set(t.sCacheKey,JSON.stringify({metadata:t.oMetadata,params:p}));}function l(){q.sap.log.error("[ODataMetadata] initial loading of metadata failed");}if(this.sCacheKey){C.get(this.sCacheKey).then(function(M){if(M){var c=JSON.parse(M);this.oMetadata=c.metadata;this._handleLoaded(this.oMetadata,c.params,false);}else{this._loadMetadata().then(w).catch(l);}}.bind(this)).catch(l);}else{this._loadMetadata().catch(l);}},
metadata:{publicMethods:["getServiceMetadata","attachFailed","detachFailed","attachLoaded","detachLoaded","refresh"]}
});
a.prototype._setNamespaces=function(n){this.mNamespaces=n;};
a.prototype._handleLoaded=function(m,p,s){var e=[];this.oMetadata=this.oMetadata?this.merge(this.oMetadata,m,e):m;this.oRequestHandle=null;p.entitySets=e;this.fnResolve(p);if(this.bAsync&&!s){this.fireLoaded(this);}else if(!this.bAsync&&!s){this.bLoaded=true;this.bFailed=false;this.oLoadEvent=q.sap.delayedCall(0,this,this.fireLoaded,[p]);}};
a.prototype._loadMetadata=function(u,s){var t=this;u=u||this.sUrl;var r=this._createRequest(u);return new Promise(function(b,c){var R;function _(m,o){if(!m||!m.dataServices){var p={message:"Invalid metadata document",request:r,response:o};d(p);return;}t.sMetadataBody=o.body;t.oRequestHandle=null;var P={metadataString:t.sMetadataBody};var l=o.headers["Last-Modified"];if(l){P.lastModified=l;}t._handleLoaded(m,P,s);b(P);}function d(e){var p={message:e.message,request:e.request,response:e.response};if(e.response){p.statusCode=e.response.statusCode;p.statusText=e.response.statusText;p.responseText=e.response.body;}if(R&&R.bSuppressErrorHandlerCall){return;}if(t.bAsync){delete t.mRequestHandles[R.id];}c(p);if(t.bAsync&&!s){t.fireFailed(p);}else if(!t.bAsync&&!s){t.bFailed=true;t.oFailedEvent=q.sap.delayedCall(0,t,t.fireFailed,[p]);}}R=O.request(r,_,d,O.metadataHandler);if(t.bAsync){R.id=q.sap.uid();t.mRequestHandles[R.id]=R;}});};
a.prototype.refresh=function(){return this._loadMetadata();};
a.prototype.getServiceMetadata=function(){return this.oMetadata;};
a.prototype.isLoaded=function(){return this.bLoaded;};
a.prototype.loaded=function(){return this.pLoaded;};
a.prototype.isFailed=function(){return this.bFailed;};
a.prototype.fireLoaded=function(p){this.bLoaded=true;this.bFailed=false;this.fireEvent("loaded",p);q.sap.log.debug(this+" - loaded was fired");return this;};
a.prototype.attachLoaded=function(d,f,l){this.attachEvent("loaded",d,f,l);return this;};
a.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};
a.prototype.fireFailed=function(A){this.bFailed=true;this.fireEvent("failed",A);return this;};
a.prototype.attachFailed=function(d,f,l){this.attachEvent("failed",d,f,l);return this;};
a.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};
a.prototype._getEntityAssociationEnd=function(e,n){if(!this.oMetadata||q.isEmptyObject(this.oMetadata)){return null;}if(!this._mGetEntityAssociationEndCache||!this._mGetEntityAssociationEndCache[e.name+"|"+n]){this._mGetEntityAssociationEndCache={};var N=e?U.findObject(e.navigationProperty,n):null,A=N?U.getObject(this.oMetadata.dataServices.schema,"association",N.relationship):null,o=A?U.findObject(A.end,N.toRole,"role"):null;this._mGetEntityAssociationEndCache[e.name+"|"+n]=o;}return this._mGetEntityAssociationEndCache[e.name+"|"+n];};
function g(s){var e={};for(var i=0;i<s.length;i++){var S=s[i];if(S.entityContainer){for(var j=0;j<S.entityContainer.length;j++){var o=S.entityContainer[j];if(o.entitySet){for(var k=0;k<o.entitySet.length;k++){if(o.entitySet[k].name!=null){e[o.entitySet[k].name]=o.entitySet[k];}}}}}}return e;}
a.prototype._findEntitySetByName=function(n){if(!this.mEntitySets){this.mEntitySets=g(this.oMetadata.dataServices.schema);}return this.mEntitySets[n];};
a.prototype._getEntityTypeByPath=function(p){if(!p){return null;}if(!this.oMetadata||q.isEmptyObject(this.oMetadata)){return null;}if(this.mEntityTypes[p]){return this.mEntityTypes[p];}var c=p.replace(/^\/|\/$/g,""),P=c.split("/"),l=P.length,o,e,b,r,t=this;if(P[0].indexOf("(")!=-1){P[0]=P[0].substring(0,P[0].indexOf("("));}if(l>1){o=t._getEntityTypeByPath(P[0]);for(var i=1;i<P.length;i++){if(o){if(P[i].indexOf("(")!=-1){P[i]=P[i].substring(0,P[i].indexOf("("));}r=t._getEntityTypeByNavProperty(o,P[i]);if(r){o=r;}b=o;}}}else{e=this._splitName(this._getEntityTypeName(P[0]));b=this._getObjectMetadata("entityType",e.name,e.namespace);if(b){b.entityType=this._getEntityTypeName(P[0]);}}if(!b){var f=P[P.length-1];var F=this._getFunctionImportMetadata(f,"GET");if(!F){F=this._getFunctionImportMetadata(f,"POST");}if(F&&F.entitySet){b=this._getEntityTypeByPath(F.entitySet);if(b){b.entityType=this._getEntityTypeName(F.entitySet);}}}if(b){this.mEntityTypes[p]=b;}return b;};
a.prototype._getEntityTypeByName=function(n){var e,t=this,s,N,o;if(!n){return null;}o=this._splitName(n);N=o.namespace;s=o.name;if(!this.oMetadata||q.isEmptyObject(this.oMetadata)){return null;}if(this.mEntityTypes[n]){e=this.mEntityTypes[n];}else{q.each(this.oMetadata.dataServices.schema,function(i,S){if(S.entityType&&(!N||S.namespace===N)){q.each(S.entityType,function(k,b){if(b.name===s){e=b;t.mEntityTypes[n]=e;e.namespace=S.namespace;return false;}});}});}return e;};
a.prototype._getAnnotation=function(p){var n,P,m,M,e,s,o;P=p.split('/#');M=P[1].split('/');if(!P[0]){e=this._getEntityTypeByName(M[0]);if(!e){return;}s=P[1].substr(P[1].indexOf('/')+1);o=this._getPropertyMetadata(e,s);if(!o){return;}m=s.substr(s.indexOf(o.name));m=m.substr(m.indexOf('/')+1);}else{e=this._getEntityTypeByPath(P[0]);if(!e){return;}p=P[0].replace(/^\/|\/$/g,"");s=p;while(!o&&s.indexOf("/")>0){s=s.substr(s.indexOf('/')+1);o=this._getPropertyMetadata(e,s);}if(!o){return;}m=M.join('/');}n=this._getAnnotationObject(e,o,m);return n;};
a.prototype._getAnnotationObject=function(e,o,m){var A,p,b,n,s;if(!o){return;}n=o;p=m.split('/');if(p[0].indexOf('.')>-1){return this._getV4AnnotationObject(e,o,p);}else{if(p.length>1){n=n[p[0]];if(!n&&o.extensions){for(var i=0;i<o.extensions.length;i++){var c=o.extensions[i];if(c.name==p[0]){n=c;break;}}}m=p.splice(0,1);b=this._getAnnotationObject(e,n,p.join('/'));}else{if(p[0].indexOf('@')>-1){s=p[0].substr(1);A=s.split(':');b=n[A[0]];if(!b&&n.extensions){for(var i=0;i<n.extensions.length;i++){var c=n.extensions[i];if(c.name===A[1]&&c.namespace===this.mNamespaces[A[0]]){b=c.value;break;}}}}else{A=p[0].split(':');b=n[A[0]];b=n[p[0]];if(!b&&n.extensions){for(var i=0;i<n.extensions.length;i++){var c=n.extensions[i];if(c.name===A[1]&&c.namespace===this.mNamespaces[A[0]]){b=c;break;}}}}}}return b;};
a.prototype._getV4AnnotationObject=function(e,o,p){var A,b=[];if(p.length>1){return;}var t=e.namespace?e.namespace+".":"";t+=e.name+"/"+o.name;q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.annotations){q.each(s.annotations,function(k,o){if(o.target===t&&!o.qualifier){b.push(o.annotation);return false;}});}});if(b){q.each(b,function(i,c){q.each(c,function(j,d){if(d.term===p[0]){A=d;}});});}return A;};
a.prototype._splitName=function(f){var i={};if(f){var s=f.lastIndexOf(".");i.name=f.substr(s+1);i.namespace=f.substr(0,s);}return i;};
a.prototype._getEntityTypeName=function(c){var e,o;if(c){o=this._findEntitySetByName(c);if(o){e=o.entityType;}}return e;};
a.prototype._getObjectMetadata=function(o,s,n){var b;if(s&&n){q.each(this.oMetadata.dataServices.schema,function(i,S){if(S[o]&&S.namespace===n){q.each(S[o],function(j,c){if(c.name===s){b=c;b.namespace=S.namespace;return false;}});return!b;}});}return b;};
a.prototype.getUseBatch=function(){var u=false;q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.entityContainer){q.each(s.entityContainer,function(k,e){if(e.extensions){q.each(e.extensions,function(l,o){if(o.name==="use-batch"&&o.namespace==="http://www.sap.com/Protocols/SAPData"){u=(typeof o.value==='string')?(o.value.toLowerCase()==='true'):!!o.value;return false;}});}});}});return u;};
a.prototype._getFunctionImportMetadata=function(f,m){var o=null;if(f.indexOf("/")>-1){f=f.substr(f.indexOf("/")+1);}q.each(this.oMetadata.dataServices.schema,function(i,s){if(s["entityContainer"]){q.each(s["entityContainer"],function(j,e){if(e["functionImport"]){q.each(e["functionImport"],function(k,F){if(F.name===f&&F.httpMethod===m){o=F;return false;}});}return!o;});}return!o;});return o;};
a.prototype._getEntityTypeByNavProperty=function(e,n){if(!e.navigationProperty){return undefined;}for(var i=0;i<e.navigationProperty.length;++i){var N=e.navigationProperty[i];if(N.name===n){return this._getEntityTypeByNavPropertyObject(N);}}return undefined;};
a.prototype._getEntityTypeByNavPropertyObject=function(n){var t;var A=this._splitName(n.relationship);var m=this._getObjectMetadata("association",A.name,A.namespace);if(m){var e=m.end[0];if(e.role!==n.toRole){e=m.end[1];}var o=this._splitName(e.type);t=this._getObjectMetadata("entityType",o.name,o.namespace);if(t){t.entityType=e.type;}}return t;};
a.prototype._getNavigationPropertyNames=function(e){var n=[];if(e.navigationProperty){q.each(e.navigationProperty,function(k,N){n.push(N.name);});}return n;};
a.prototype._getPropertyMetadata=function(e,p){var P,t=this;if(!e){return;}p=p.replace(/^\/|\/$/g,"");var b=p.split("/");q.each(e.property,function(k,o){if(o.name===b[0]){P=o;return false;}});if(b.length>1){if(!P){while(e&&b.length>1){e=this._getEntityTypeByNavProperty(e,b[0]);b.shift();}if(e){P=t._getPropertyMetadata(e,b[0]);}}else if(!q.sap.startsWith(P.type.toLowerCase(),"edm.")){var n=this._splitName(P.type);P=this._getPropertyMetadata(this._getObjectMetadata("complexType",n.name,n.namespace),b[1]);}}return P;};
a.prototype.destroy=function(){delete this.oMetadata;var t=this;q.each(this.mRequestHandles,function(k,r){r.bSuppressErrorHandlerCall=true;r.abort();delete t.mRequestHandles[k];});if(!!this.oLoadEvent){q.sap.clearDelayedCall(this.oLoadEvent);}if(!!this.oFailedEvent){q.sap.clearDelayedCall(this.oFailedEvent);}E.prototype.destroy.apply(this,arguments);};
a.prototype._createRequest=function(u){var h={},l={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()};q.extend(h,this.mHeaders,l);var r={headers:h,requestUri:u,method:'GET',user:this.sUser,password:this.sPassword,async:this.bAsync};if(this.bAsync){r.withCredentials=this.bWithCredentials;}return r;};
a.prototype._getEntitySetByPath=function(e){if(!this._entitySetMap){this._entitySetMap={};this.oMetadata.dataServices.schema.forEach(function(s){if(s.entityContainer){s.entityContainer.forEach(function(c){if(c.entitySet){c.entitySet.forEach(function(m){this._entitySetMap[m.entityType]=m;},this);}},this);}},this);}var o=this._getEntityTypeByPath(e);if(o){return this._entitySetMap[o.entityType];}return;};
a.prototype._addUrl=function(u){var b=[].concat(u);return Promise.all(b.map(function(s){return this._loadMetadata(s,true);},this));};
a.prototype.merge=function(t,s,e){var b=this;if(this.mEntitySets){delete this.mEntitySets;}q.each(t.dataServices.schema,function(i,T){q.each(s.dataServices.schema,function(j,S){if(S.namespace===T.namespace){if(S.entityType){if(!b.mEntityTypeNames){b.mEntityTypeNames={};T.entityType.map(function(o){b.mEntityTypeNames[o.name]=true;});}T.entityType=!T.entityType?[]:T.entityType;for(var i=0;i<S.entityType.length;i++){if(!(S.entityType[i].name in b.mEntityTypeNames)){T.entityType.push(S.entityType[i]);b.mEntityTypeNames[S.entityType[i].name]=true;}}}if(T.entityContainer&&S.entityContainer){q.each(T.entityContainer,function(k,c){q.each(S.entityContainer,function(l,d){if(d.entitySet){if(d.name===c.name){if(!b.mEntitySetNames){b.mEntitySetNames={};c.entitySet.map(function(o){b.mEntitySetNames[o.name]=true;});}c.entitySet=!c.entitySet?[]:c.entitySet;for(var i=0;i<d.entitySet.length;i++){if(!(d.entitySet[i].name in b.mEntitySetNames)){c.entitySet.push(d.entitySet[i]);b.mEntitySetNames[d.entitySet[i].name]=true;}}d.entitySet.forEach(function(o){e.push(o);});}}});});}if(S.annotations){T.annotations=!T.annotations?[]:T.annotations;T.annotations=T.annotations.concat(S.annotations);}}});});return t;};
a.prototype._getEntitySetByType=function(e){var s=e.namespace+"."+e.name;var S=this.oMetadata.dataServices.schema;for(var i=0;i<S.length;++i){var c=S[i].entityContainer;if(c){for(var n=0;n<c.length;++n){var b=c[n].entitySet;if(b){for(var m=0;m<b.length;++m){if(b[m].entityType===s){return b[m];}}}}}}return null;};
return a;});
sap.ui.predefine('sap/ui/model/odata/ODataModel',['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','./ODataUtils','./CountMode','./ODataContextBinding','./ODataListBinding','./ODataMetadata','./ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/odata/ODataMetaModel','sap/ui/thirdparty/URI','sap/ui/thirdparty/datajs'],function(q,B,C,M,O,a,b,c,d,e,f,g,U,h){"use strict";
var m=M.extend("sap.ui.model.odata.ODataModel",{
constructor:function(s,j,u,p,H,t,w,l){M.apply(this,arguments);var i,r,k,A=null,L,n,D,S,o,v,x=this;if(typeof(s)==="object"){j=s;s=j.serviceUrl;}if(typeof j==="object"){u=j.user;p=j.password;H=j.headers;t=j.tokenHandling;l=j.loadMetadataAsync;w=j.withCredentials;k=j.maxDataServiceVersion;i=j.useBatch;r=j.refreshAfterChange;A=j.annotationURI;L=j.loadAnnotationsJoined;D=j.defaultCountMode;n=j.metadataNamespaces;S=j.serviceUrlParams;o=j.metadataUrlParams;v=j.skipMetadataAnnotationParsing;j=j.json;}this.oServiceData={};this.sDefaultBindingMode=B.OneWay;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.bCountSupported=true;this.bJSON=j;this.bCache=true;this.aPendingRequestHandles=[];this.oRequestQueue={};this.aBatchOperations=[];this.oHandler;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=i===true;this.bRefreshAfterChange=r!==false;this.sMaxDataServiceVersion=k;this.bLoadMetadataAsync=!!l;this.bLoadAnnotationsJoined=L===undefined?true:L;this.sAnnotationURI=A;this.sDefaultCountMode=D||a.Both;this.oMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.bSkipMetadataAnnotationParsing=v;this.oHeaders={};this.setHeaders(H);this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];if(s.indexOf("?")==-1){this.sServiceUrl=s;}else{var y=s.split("?");this.sServiceUrl=y[0];if(y[1]){this.aUrlParams.push(y[1]);}}if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");var z=this._createRequestUrl("$metadata",undefined,o);if(!m.mServiceData[z]){m.mServiceData[z]={};}this.oServiceData=m.mServiceData[z];if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.sUser=u;this.sPassword=p;this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();if(!this.oServiceData.oMetadata){this.oServiceData.oMetadata=new d(z,{async:this.bLoadMetadataAsync,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:n,withCredentials:this.bWithCredentials});}this.oMetadata=this.oServiceData.oMetadata;this.pAnnotationsLoaded=this.oMetadata.loaded();if(this.sAnnotationURI||!this.bSkipMetadataAnnotationParsing){var E=this._getAnnotationParser();if(!this.bSkipMetadataAnnotationParsing){if(!this.bLoadMetadataAsync){this.addAnnotationXML(this.oMetadata.sMetadataBody,!!this.sAnnotationURI);}else{this.pAnnotationsLoaded=this.oMetadata.loaded().then(function(F,P){if(this.bDestroyed){return Promise.reject();}return this.addAnnotationXML(P["metadataString"],F);}.bind(this,!!this.sAnnotationURI));}}if(this.sAnnotationURI){if(this.bLoadMetadataAsync){this.pAnnotationsLoaded=this.pAnnotationsLoaded.then(E.addUrl.bind(E,this.sAnnotationURI));}else{this.pAnnotationsLoaded=Promise.all([this.pAnnotationsLoaded,E.addUrl(this.sAnnotationURI)]);}}}if(S){this.aUrlParams=this.aUrlParams.concat(O._createUrlParamsArray(S));}this.onMetadataLoaded=function(F){x._initializeMetadata();x.initialize();};this.onMetadataFailed=function(F){x.fireMetadataFailed(F.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachLoaded(this.onMetadataLoaded);this.oMetadata.attachFailed(this.onMetadataFailed);}if(this.oMetadata.isFailed()){this.refreshMetadata();}if(this.oMetadata.isLoaded()){this._initializeMetadata(true);}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}this.oHandler=h.jsonHandler;}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";this.oHandler=h.atomHandler;}this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}this.oHeaders["DataServiceVersion"]="2.0";},
metadata:{publicMethods:["create","remove","update","submitChanges","getServiceMetadata","read","hasPendingChanges","refresh","refreshMetadata","resetChanges","isCountSupported","setCountSupported","setDefaultCountMode","getDefaultCountMode","forceNoCache","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch"]}
});
m.M_EVENTS={RejectChange:"rejectChange",MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed"};m.mServiceData={};
m.prototype.fireRejectChange=function(A){this.fireEvent("rejectChange",A);return this;};
m.prototype.attachRejectChange=function(D,F,l){this.attachEvent("rejectChange",D,F,l);return this;};
m.prototype.detachRejectChange=function(F,l){this.detachEvent("rejectChange",F,l);return this;};
m.prototype._initializeMetadata=function(D){var t=this;this.bUseBatch=this.bUseBatch||this.oMetadata.getUseBatch();var i=function(j){if(!!j){t.metadataLoadEvent=q.sap.delayedCall(0,t,i);}else{if(t.oMetadata){t.fireMetadataLoaded({metadata:t.oMetadata});q.sap.log.debug("ODataModel fired metadataloaded");}}};if(this.sAnnotationURI&&this.bLoadAnnotationsJoined){if(this.oAnnotations&&(this.oAnnotations.bInitialized||this.oAnnotations.isFailed())){i(!this.bLoadMetadataAsync);}else{this.oAnnotations.attachEventOnce("loaded",function(){i(true);});}}else{i(D);}};
m.prototype.fireAnnotationsLoaded=function(A){if(!this.bLoadMetadataAsync){setTimeout(this.fireEvent.bind(this,"annotationsLoaded",A),0);}else{this.fireEvent("annotationsLoaded",A);}return this;};
m.prototype.attachAnnotationsLoaded=function(D,F,l){this.attachEvent("annotationsLoaded",D,F,l);return this;};
m.prototype.detachAnnotationsLoaded=function(F,l){this.detachEvent("annotationsLoaded",F,l);return this;};
m.prototype.fireAnnotationsFailed=function(A){if(!this.bLoadMetadataAsync){setTimeout(this.fireEvent.bind(this,"annotationsFailed",A),0);}else{this.fireEvent("annotationsFailed",A);}q.sap.log.debug("ODataModel fired annotationsfailed");return this;};
m.prototype.attachAnnotationsFailed=function(D,F,l){this.attachEvent("annotationsFailed",D,F,l);return this;};
m.prototype.detachAnnotationsFailed=function(F,l){this.detachEvent("annotationsFailed",F,l);return this;};
m.prototype.fireMetadataLoaded=function(A){this.fireEvent("metadataLoaded",A);return this;};
m.prototype.attachMetadataLoaded=function(D,F,l){this.attachEvent("metadataLoaded",D,F,l);return this;};
m.prototype.detachMetadataLoaded=function(F,l){this.detachEvent("metadataLoaded",F,l);return this;};
m.prototype.fireMetadataFailed=function(A){this.fireEvent("metadataFailed",A);return this;};
m.prototype.attachMetadataFailed=function(D,F,l){this.attachEvent("metadataFailed",D,F,l);return this;};
m.prototype.detachMetadataFailed=function(F,l){this.detachEvent("metadataFailed",F,l);return this;};
m.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){this.oMetadata.refresh();}};
m.prototype._createRequestUrl=function(p,o,u,i,j){var k,r,s,l="";if(p&&p.indexOf('?')!=-1){s=p.substr(p.indexOf('?')+1);p=p.substr(0,p.indexOf('?'));}r=this._normalizePath(p,o);if(!i){l=this.sServiceUrl+r;}else{l=r.substr(r.indexOf('/')+1);}k=O._createUrlParamsArray(u);if(this.aUrlParams){k=k.concat(this.aUrlParams);}if(s){k.push(s);}if(k.length>0){l+="?"+k.join("&");}if(j===undefined){j=true;}if(j===false){var t=q.now();var n=l.replace(/([?&])_=[^&]*/,"$1_="+t);l=n+((n===l)?(/\?/.test(l)?"&":"?")+"_="+t:"");}return l;};
m.prototype._loadData=function(p,P,s,E,i,H,j){var r,R,t=this;function _(D,o){var v=D,w={};if(o.statusCode==204){if(s){s(null);}if(j){j(null);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true});return;}if(!v){q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+o.requestUri);t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false});return false;}if(t.bUseBatch){var x=t._getBatchErrors(D);if(x.length>0){k(x[0]);return false;}if(v.__batchResponses&&v.__batchResponses.length>0){v=v.__batchResponses[0].data;}else{q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+o.requestUri);}}n=n.concat(v.results);if(v.__next){var y=new U(v.__next);R.requestUri=y.absoluteTo(o.requestUri).toString();l(R);}else{q.sap.extend(v.results,n);if(v.results&&!Array.isArray(v.results)){v=v.results;}t._importData(v,w);if(t.sChangeKey&&w){var z=t.sChangeKey.substr(t.sChangeKey.lastIndexOf('/')+1);if(w[z]){delete t.oRequestQueue[t.sChangeKey];t.sChangeKey=null;}}if(s){s(v);}t.checkUpdate(false,false,w);if(j){j(v);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true});}}function k(o){if(t.bTokenHandling&&o.response){var T=t._getHeader("x-csrf-token",o.response.headers);if(!R.bTokenReset&&o.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();R.bTokenReset=true;l();return;}}var v=t._handleError(o);if(E){E(o,r&&r.bAborted);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false,errorobject:v});if(!r||!r.bAborted){v.url=R.requestUri;t.fireRequestFailed(v);}}function l(){if(t.bUseBatch){t.updateSecurityToken();var o=U.parse(R.requestUri).query;var v=t._createRequestUrl(p,null,o,t.bUseBatch);R=t._createRequest(v,"GET",true);var w=t._createBatchRequest([R],true);r=t._request(w,_,k,h.batchHandler,undefined,t.getServiceMetadata());}else{r=t._request(R,_,k,t.oHandler,undefined,t.getServiceMetadata());}if(H){var W={abort:function(){r.bAborted=true;r.abort();}};H(W);}}var n=[];var u=this._createRequestUrl(p,null,P,null,i||this.bCache);R=this._createRequest(u,"GET",true);this.fireRequestSent({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]}});l();};
m.prototype._importData=function(D,k){var t=this,l,K,r,E;if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._importData(j,k));});return l;}else{K=this._getKey(D);E=this.oData[K];if(!E){E=D;this.oData[K]=E;}q.each(D,function(n,p){if(p&&(p.__metadata&&p.__metadata.uri||p.results)&&!p.__deferred){r=t._importData(p,k);if(Array.isArray(r)){E[n]={__list:r};}else{E[n]={__ref:r};}}else if(!p||!p.__deferred){E[n]=p;}});k[K]=true;return K;}};
m.prototype._removeReferences=function(D){var t=this,l;if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._removeReferences(j));});return l;}else{q.each(D,function(p,o){if(o){if(o["__ref"]||o["__list"]){delete D[p];}}});return D;}};
m.prototype._restoreReferences=function(D){var t=this,l,r=[];if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._restoreReferences(j));});return l;}else{q.each(D,function(p,o){if(o&&o["__ref"]){var i=t._getObject("/"+o["__ref"]);if(i){delete o["__ref"];D[p]=i;t._restoreReferences(i);}}else if(o&&o["__list"]){q.each(o["__list"],function(j,E){var i=t._getObject("/"+o["__list"][j]);if(i){r.push(i);t._restoreReferences(i);}});delete o["__list"];o.results=r;r=[];}});return D;}};
m.prototype.removeData=function(){this.oData={};};
m.prototype.initialize=function(){var i=this.aBindings.slice(0);q.each(i,function(I,o){o.initialize();});};
m.prototype.refresh=function(F,r){if(r){this.removeData();}this._refresh(F);};
m.prototype._refresh=function(F,i,E){var j=this.aBindings.slice(0);q.each(j,function(I,o){o.refresh(F,i,E);});};
m.prototype.checkUpdate=function(F,A,i,j){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(F,false,i);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var k=this.aBindings.slice(0);q.each(k,function(I,o){if(!j||this.isMetaModelPath(o.getPath())){o.checkUpdate(F,i);}}.bind(this));};
m.prototype.bindProperty=function(p,o,P){var i=new e(this,p,o,P);return i;};
m.prototype.bindList=function(p,o,s,F,P){var i=new c(this,p,o,s,F,P);return i;};
m.prototype.bindTree=function(p,o,F,P){var i=new f(this,p,o,F,P);return i;};
m.prototype.createBindingContext=function(p,o,P,i,r){var r=!!r,F=this.resolve(p,o);if(typeof o=="function"){i=o;o=null;}if(typeof P=="function"){i=P;P=null;}if(!F){if(i){i(null);}return null;}var D=this._getObject(p,o),k,n,t=this;if(!r){r=this._isReloadNeeded(F,D,P);}if(!r){k=this._getKey(D);n=this.getContext('/'+k);if(i){i(n);}return n;}if(i){var I=!q.sap.startsWith(p,"/");if(F){var j=[],s=this.createCustomParams(P);if(s){j.push(s);}this._loadData(F,j,function(D){k=D?t._getKey(D):undefined;if(k&&o&&I){var l=o.getPath();l=l.substr(1);if(t.oData[l]){t.oData[l][p]={__ref:k};}}n=t.getContext('/'+k);i(n);},function(){i(null);});}else{i(null);}}};
m.prototype._isReloadNeeded=function(F,D,p){var n,N=[],s,S=[];if(!F){return false;}if(!D){return true;}if(p&&p["expand"]){n=p["expand"].replace(/\s/g,"");N=n.split(',');}if(N){for(var i=0;i<N.length;i++){var j=N[i].indexOf("/");if(j!==-1){var k=N[i].slice(0,j);var l=N[i].slice(j+1);N[i]=[k,l];}}}for(var i=0;i<N.length;i++){var o=N[i];if(Array.isArray(o)){var r=D[o[0]];var t=o[1];if(!r||(r&&r.__deferred)){return true;}else{if(r){if(r.__list&&r.__list.length>0){for(var u=0;u<r.__list.length;u++){var P="/"+r.__list[u];var v=this.getObject(P);var R=this._isReloadNeeded(P,v,{expand:t});if(R){return true;}}}else if(r.__ref){var P="/"+r.__ref;var v=this.getObject(P);var R=this._isReloadNeeded(P,v,{expand:t});if(R){return true;}}}}}else{if(D[o]===undefined||(D[o]&&D[o].__deferred)){return true;}}}if(p&&p["select"]){s=p["select"].replace(/\s/g,"");S=s.split(',');}for(var i=0;i<S.length;i++){if(D[S[i]]===undefined){return true;}}if(S.length==0){var E=this.oMetadata._getEntityTypeByPath(F);if(!E){return false;}else{for(var i=0;i<E.property.length;i++){if(D[E.property[i].name]===undefined){return true;}}}}return false;};
m.prototype.destroyBindingContext=function(o){};
m.prototype.createCustomParams=function(p){var i=[],j,s={expand:true,select:true};for(var n in p){if(n in s){i.push("$"+n+"="+q.sap.encodeURL(p[n]));}if(n=="custom"){j=p[n];for(var n in j){if(n.indexOf("$")==0){q.sap.log.warning("Trying to set OData parameter "+n+" as custom query option!");}else{i.push(n+"="+q.sap.encodeURL(j[n]));}}}}return i.join("&");};
m.prototype.bindContext=function(p,o,P){var i=new b(this,p,o,P);return i;};
m.prototype.setCountSupported=function(i){this.bCountSupported=i;};
m.prototype.isCountSupported=function(){return this.bCountSupported;};
m.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s;};
m.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};
m.prototype._getKey=function(o,D){var k,u;if(o instanceof C){k=o.getPath().substr(1);}else if(o&&o.__metadata&&o.__metadata.uri){u=o.__metadata.uri;k=u.substr(u.lastIndexOf("/")+1);}if(D){k=decodeURIComponent(k);}return k;};
m.prototype.getKey=function(o,D){return this._getKey(o,D);};
m.prototype.createKey=function(s,k,D){var E=this.oMetadata._getEntityTypeByPath(s),K=s,t=this,n,v,p;K+="(";if(E.key.propertyRef.length==1){n=E.key.propertyRef[0].name;p=this.oMetadata._getPropertyMetadata(E,n);v=O.formatValue(k[n],p.type);K+=D?v:encodeURIComponent(v);}else{q.each(E.key.propertyRef,function(i,P){if(i>0){K+=",";}n=P.name;p=t.oMetadata._getPropertyMetadata(E,n);v=O.formatValue(k[n],p.type);K+=n;K+="=";K+=D?v:encodeURIComponent(v);});}K+=")";return K;};
m.prototype.getProperty=function(p,o,i){var v=this._getObject(p,o);if(i==null||i==undefined){return v;}if(!q.isPlainObject(v)){return v;}v=q.sap.extend(true,{},v);if(i==true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};
m.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null,r=this.resolve(p,o),s,D,i,j,k,l;if(this.oMetadata&&r&&r.indexOf('/#')>-1){if(this.isMetaModelPath(r)){s=r.indexOf('/##');l=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=r.substr(0,s);i=r.substr(s+3);j=l.getMetaContext(D);n=l.getProperty(i,j);}else{n=this.oMetadata._getAnnotation(r);}}else{if(o){k=o.getPath();k=k.substr(1);n=this.oData[k];}if(!p){return n;}var P=p.split("/"),I=0;if(!P[0]){n=this.oData;I++;}while(n&&P[I]){n=n[P[I]];if(n){if(n.__ref){n=this.oData[n.__ref];}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}I++;}}return n;};
m.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};
m.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];};
m.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};
m.prototype.refreshSecurityToken=function(s,E,A){var t=this,u,T;A=A===true;u=this._createRequestUrl("/");var r=this._createRequest(u,"GET",A);r.headers["x-csrf-token"]="Fetch";function _(D,R){if(R){T=t._getHeader("x-csrf-token",R.headers);if(T){t.oServiceData.securityToken=T;t.oHeaders["x-csrf-token"]=T;}else{t.resetSecurityToken();t.bTokenHandling=false;}}if(s){s(D,R);}}function i(o){t.resetSecurityToken();t.bTokenHandling=false;t._handleError(o);if(E){E(o);}}return this._request(r,_,i,undefined,undefined,this.getServiceMetadata());};
m.prototype._submitRequest=function(r,i,s,E,H,I){var t=this,R,j={};function _(D,o){if(i&&H){var n=t._getBatchErrors(D);if(n.length>0){k(n[0]);return false;}if(D.__batchResponses&&D.__batchResponses.length>0){R=D.__batchResponses[0].data;if(!R&&D.__batchResponses[0].__changeResponses){R=D.__batchResponses[0].__changeResponses[0].data;}}D=R;}if(I){if(D&&D.__batchResponses){q.each(D.__batchResponses,function(p,o){if(o&&o.data){t._importData(o.data,j);}});}}t._handleETag(r,o,i);t._updateRequestQueue(r,i);if(t._isRefreshNeeded(r,o)){t._refresh(false,r.keys,r.entityTypes);}if(s){s(D,o);}}function k(o){if(t.bTokenHandling&&o.response){var T=t._getHeader("x-csrf-token",o.response.headers);if(!r.bTokenReset&&o.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();r.bTokenReset=true;l();return;}}t._handleError(o);if(E){E(o);}}function l(){if(t.bTokenHandling&&r.method!=="GET"){t.updateSecurityToken();if(t.bTokenHandling){r.headers["x-csrf-token"]=t.oServiceData.securityToken;}}if(i){return t._request(r,_,k,h.batchHandler,undefined,t.getServiceMetadata());}else{return t._request(r,_,k,t.oHandler,undefined,t.getServiceMetadata());}}return l();};
m.prototype._createBatchRequest=function(n,A){var u,r,o={},p={},K={},E={};p.__batchRequests=n;u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&");}q.extend(o,this.mCustomHeaders,this.oHeaders);delete o["Content-Type"];r={headers:o,requestUri:u,method:"POST",data:p,user:this.sUser,password:this.sPassword,async:A};if(A){r.withCredentials=this.bWithCredentials;}q.each(n,function(i,s){if(s["__changeRequests"]){q.each(s["__changeRequests"],function(j,t){if(t.keys&&t.method!="POST"){q.each(t.keys,function(k,l){K[k]=l;});}else if(t.entityTypes&&t.method=="POST"){q.each(t.entityTypes,function(l,k){E[l]=k;});}});}});r.keys=K;r.entityTypes=E;return r;};
m.prototype._handleETag=function(r,R,k){var u,E,l,n,o,p;if(k){o=r.data.__batchRequests;p=R.data.__batchResponses;if(p&&o){for(var i=0;i<o.length;i++){l=o[i].__changeRequests;if(p[i]){n=p[i].__changeResponses;if(l&&n){for(var j=0;j<l.length;j++){if(l[j].method=="MERGE"||l[j].method=="PUT"){u=l[j].requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);if(E&&E.__metadata&&n[j].headers&&n[j].headers.ETag){E.__metadata.etag=n[j].headers.ETag;}}}}}else{q.sap.log.warning("could not update ETags for batch request: corresponding response for request missing");}}}else{q.sap.log.warning("could not update ETags for batch request: no batch responses/requests available");}}else{u=r.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);if(E&&E.__metadata&&R.headers.ETag){E.__metadata.etag=R.headers.ETag;}}};
m.prototype._handleBatchErrors=function(r,D){this._getBatchErrors(D);this._handleETag();};
m.prototype._getBatchErrors=function(D){var E=[],s;q.each(D.__batchResponses,function(i,o){if(o.message){s="The following problem occurred: "+o.message;if(o.response){s+=o.response.statusCode+","+o.response.statusText+","+o.response.body;}E.push(o);q.sap.log.fatal(s);}if(o.__changeResponses){q.each(o.__changeResponses,function(i,j){if(j.message){s="The following problem occurred: "+j.message;if(j.response){s+=j.response.statusCode+","+j.response.statusText+","+j.response.body;}E.push(j);q.sap.log.fatal(s);}});}});return E;};
m.prototype._handleError=function(E){var p={},t;var s="The following problem occurred: "+E.message;p.message=E.message;if(E.response){if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()=="required"){this.resetSecurityToken();}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;p.statusCode=E.response.statusCode;p.statusText=E.response.statusText;p.responseText=E.response.body;}q.sap.log.fatal(s);return p;};
m.prototype.getData=function(p,o,i){return this.getProperty(p,o,i);};
m.prototype._getETag=function(p,P,E){var s,i,I;if(E){s=E;}else{if(P&&P.__metadata){s=P.__metadata.etag;}else if(p){i=p.replace(this.sServiceUrl+'/','');I=i.indexOf("?");if(I>-1){i=i.substr(0,I);}if(this.oData.hasOwnProperty(i)){s=this.getProperty('/'+i+'/__metadata/etag');}}}return s;};
m.prototype._createRequest=function(u,s,A,p,E){var o={},i;q.extend(o,this.mCustomHeaders,this.oHeaders);i=this._getETag(u,p,E);if(i&&s!="GET"){o["If-Match"]=i;}if(this.bJSON&&s!="DELETE"&&this.sMaxDataServiceVersion==="2.0"){o["Content-Type"]="application/json";}if(s=="MERGE"&&!this.bUseBatch){o["x-http-method"]="MERGE";s="POST";}var r={headers:o,requestUri:u,method:s,user:this.sUser,password:this.sPassword,async:A};if(p){r.data=p;}if(A){r.withCredentials=this.bWithCredentials;}return r;};
m.prototype._isRefreshNeeded=function(r,R){var i=false,E,j=[],t=this;if(!this.bRefreshAfterChange){return i;}if(r.data&&Array.isArray(r.data.__batchRequests)){if(R){j=t._getBatchErrors(R.data);q.each(j,function(I,o){if(o.response&&o.response.statusCode=="412"){E=o.response.statusCode;return false;}});if(!!E){return false;}}q.each(r.data.__batchRequests,function(I,o){if(Array.isArray(o.__changeRequests)){q.each(o.__changeRequests,function(I,k){i=i||t._isRefreshNeeded(k);return!i;});}return!i;});}else{if(r.method==="GET"){return false;}else{if(R&&R.statusCode=="412"){i=false;}else{i=true;}}}return i;};
m.prototype.update=function(p,D,P){var s,E,i,r,u,o,j,R,k,S,K,l,A=false;if(P instanceof C||arguments.length>3){o=P;s=arguments[3];E=arguments[4];i=arguments[5];}else{o=P.context||P.oContext;s=P.success||P.fnSuccess;E=P.error||P.fnError;j=P.eTag||P.sETag;i=typeof(P.merge)=="undefined"?P.bMerge===true:P.merge===true;A=typeof(P.async)=="undefined"?P.bAsync===true:P.async===true;l=P.urlParameters;}u=this._createRequestUrl(p,o,l,this.bUseBatch);if(i){r=this._createRequest(u,"MERGE",A,D,j);}else{r=this._createRequest(u,"PUT",A,D,j);}p=this._normalizePath(p,o);S=this._getObject(p);r.keys={};if(S){K=this._getKey(S);r.keys[K]=true;}if(this.bUseBatch){k=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(k,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;};
m.prototype.create=function(p,D,P){var r,o,u,R,E,i,s,j,A=false,k;if(P&&typeof(P)=="object"&&!(P instanceof C)){i=P.context;s=P.success;k=P.urlParameters;j=P.error;A=P.async===true;}else{i=P;s=arguments[3];j=arguments[4];}u=this._createRequestUrl(p,i,k,this.bUseBatch);r=this._createRequest(u,"POST",A,D);p=this._normalizePath(p,i);E=this.oMetadata._getEntityTypeByPath(p);r.entityTypes={};if(E){r.entityTypes[E.entityType]=true;}if(this.bUseBatch){o=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(o,this.bUseBatch,s,j,true);}else{R=this._submitRequest(r,this.bUseBatch,s,j);}return R;};
m.prototype.remove=function(p,P){var o,E,s,S,i,r,u,j,k,l,_,n,R,t,A=false,v=this;if((P instanceof C)||arguments[2]){o=P;S=arguments[2];i=arguments[3];}else if(P){o=P.context||P.oContext;S=P.success||P.fnSuccess;i=P.error||P.fnError;j=P.eTag||P.sETag;l=P.payload||P.oPayload;A=typeof(P.async)=="undefined"?P.bAsync===true:P.async===true;t=P.urlParameters;}_=function(D,w){E=u.substr(u.lastIndexOf('/')+1);if(E.indexOf('?')!=-1){E=E.substr(0,E.indexOf('?'));}delete v.oData[E];delete v.mContexts["/"+E];if(S){S(D,w);}};u=this._createRequestUrl(p,o,t,this.bUseBatch);r=this._createRequest(u,"DELETE",A,l,j);p=this._normalizePath(p,o);s=this._getObject(p);r.keys={};if(s){k=this._getKey(s);r.keys[k]=true;}if(this.bUseBatch){n=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(n,this.bUseBatch,_,i,true);}else{R=this._submitRequest(r,this.bUseBatch,_,i);}return R;};
m.prototype.callFunction=function(F,p){var r,o,u,R,i,P,j,s,E,A,k="GET",l={},t=this;if(p&&typeof(p)=="object"){k=p.method?p.method:k;P=p.urlParameters;j=p.context;s=p.success;E=p.error;A=p.async===true;}else{k=p;P=arguments[2];j=arguments[3];s=arguments[4];E=arguments[5];A=arguments[6]===true;}i=this.oMetadata._getFunctionImportMetadata(F,k);if(i){u=this._createRequestUrl(F,j,null,this.bUseBatch);var n=U(u);if(i.parameter!=null){q.each(P,function(v,w){var x=i.parameter.filter(function(z){return z.name==v&&z.mode=="In";});if(x.length>0){var y=x[0];l[v]=O.formatValue(w,y.type);}else{q.sap.log.warning("Parameter "+v+" is not defined for function call "+F+"!");}});}if(k==="GET"){return t.read(F,j,l,true,s,E);}else{q.each(l,function(v,w){n.addQuery(v,w);});r=this._createRequest(n.toString(),k,A);if(this.bUseBatch){o=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(o,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;}}};
m.prototype.read=function(p,P){var r,u,R,o,i,j,A,s,E,F,S,k,l,n,t,v;if(P&&typeof(P)=="object"&&!(P instanceof C)){i=P.context;j=P.urlParameters;A=P.async!==false;s=P.success;E=P.error;F=P.filters;S=P.sorters;}else{i=P;j=arguments[2];A=arguments[3]!==false;s=arguments[4];E=arguments[5];}A=A!==false;v=O._createUrlParamsArray(j);l=O.createSortParams(S);if(l){v.push(l);}if(F&&!this.oMetadata){q.sap.log.fatal("Tried to use filters in read method before metadata is available.");}else{t=this._normalizePath(p,i);n=this.oMetadata&&this.oMetadata._getEntityTypeByPath(t);k=O.createFilterParams(F,this.oMetadata,n);if(k){v.push(k);}}u=this._createRequestUrl(p,i,v,this.bUseBatch);r=this._createRequest(u,"GET",A);if(this.bUseBatch){o=this._createBatchRequest([r],A);R=this._submitRequest(o,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;};
m.prototype.createBatchOperation=function(p,s,D,P){var o={},E,S,k,i;q.extend(o,this.mCustomHeaders,this.oHeaders);if(q.sap.startsWith(p,"/")){p=p.substr(1);}if(P){E=P.sETag;}if(s!="GET"){E=this._getETag(p,D,E);if(E){o["If-Match"]=E;}}if(this.bJSON){if(s!="DELETE"&&s!="GET"&&this.sMaxDataServiceVersion==="2.0"){o["Content-Type"]="application/json";}}else{o["Content-Type"]="application/atom+xml";}var r={requestUri:p,method:s.toUpperCase(),headers:o};if(D){r.data=D;}if(s!="GET"&&s!="POST"){if(p&&p.indexOf("/")!=0){p='/'+p;}S=this._getObject(p);if(S){k=this._getKey(S);r.keys={};r.keys[k]=true;}}else if(s=="POST"){var n=p;if(p.indexOf('?')!=-1){n=p.substr(0,p.indexOf('?'));}i=this.oMetadata._getEntityTypeByPath(n);if(i){r.entityTypes={};r.entityTypes[i.entityType]=true;}}return r;};
m.prototype.addBatchReadOperations=function(r){if(!Array.isArray(r)||r.length<=0){q.sap.log.warning("No array with batch operations provided!");return false;}var t=this;q.each(r,function(i,R){if(R.method!="GET"){q.sap.log.warning("Batch operation should be a GET operation!");return false;}t.aBatchOperations.push(R);});};
m.prototype.addBatchChangeOperations=function(i){if(!Array.isArray(i)||i.length<=0){return false;}q.each(i,function(I,o){if(o.method!="POST"&&o.method!="PUT"&&o.method!="MERGE"&&o.method!="DELETE"){q.sap.log.warning("Batch operation should be a POST/PUT/MERGE/DELETE operation!");return false;}});this.aBatchOperations.push({__changeRequests:i});};
m.prototype.clearBatch=function(){this.aBatchOperations=[];};
m.prototype.submitBatch=function(s,E,A,i){var r,R,t=this;function _(D,k){if(s){s(D,k,t._getBatchErrors(D));}}if(!(typeof(s)=="function")){var o=A;var j=E;A=s;s=j;E=o;}A=A!==false;if(this.aBatchOperations.length<=0){q.sap.log.warning("No batch operations in batch. No request will be triggered!");return false;}r=this._createBatchRequest(this.aBatchOperations,A);R=this._submitRequest(r,true,_,E,false,i);this.clearBatch();return R;};
m.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};
m.prototype.getServiceAnnotations=function(){if(this.oAnnotations&&this.oAnnotations.getAnnotationsData){return this.oAnnotations.getAnnotationsData();}};
m.prototype.submitChanges=function(s,E,p){var r,P,t=this,i,j,T,k,S,K;if(this.sChangeKey){i=this.sChangeKey.replace(this.sServiceUrl,'');S=this._getObject(i);P=S;if(q.isPlainObject(S)){P=q.sap.extend(true,{},S);if(P.__metadata){T=P.__metadata.type;k=P.__metadata.etag;delete P.__metadata;if(T||k){P.__metadata={};}if(T){P.__metadata.type=T;}if(!!k){P.__metadata.etag=k;}}q.each(P,function(u,v){if(v&&v.__deferred){delete P[u];}});var o=this.oMetadata._getEntityTypeByPath(i);if(o){var n=this.oMetadata._getNavigationPropertyNames(o);q.each(n,function(I,N){delete P[N];});}P=this._removeReferences(P);}if(p&&p.sETag){j=p.sETag;}r=this._createRequest(this.sChangeKey,"MERGE",true,P,j);if(this.sUrlParams){r.requestUri+="?"+this.sUrlParams;}r.keys={};if(S){K=this._getKey(S);r.keys[K]=true;}this.oRequestQueue[this.sChangeKey]=r;}if(q.isEmptyObject(this.oRequestQueue)){return undefined;}if(this.bUseBatch){var l=[];q.each(this.oRequestQueue,function(K,u){delete u._oRef;var R=q.sap.extend(true,{},u);u._oRef=R;R.requestUri=R.requestUri.replace(t.sServiceUrl+'/','');R.data._bCreate?delete R.data._bCreate:false;l.push(R);});r=this._createBatchRequest([{__changeRequests:l}],true);this._submitRequest(r,this.bUseBatch,s,E,true);}else{q.each(this.oRequestQueue,function(K,u){delete u._oRef;var R=q.sap.extend(true,{},u);u._oRef=R;if(R.data&&R.data._bCreate){delete R.data._bCreate;}t._submitRequest(R,this.bUseBatch,s,E,true);});}return undefined;};
m.prototype._updateRequestQueue=function(r,k){var l,n,o,t=this;if(k){l=r.data.__batchRequests;if(l){for(var i=0;i<l.length;i++){n=l[i].__changeRequests;if(n){for(var j=0;j<n.length;j++){o=n[j];q.each(this.oRequestQueue,function(K,p){if(p._oRef===o&&K!==t.sChangeKey){delete t.oRequestQueue[K];delete t.oData[K];delete t.mContexts["/"+K];}else if(t.sChangeKey&&K===t.sChangeKey){delete t.oRequestQueue[K];t.sChangeKey=null;}});}}}}}else{q.each(this.oRequestQueue,function(K,p){if(p._oRef===r&&K!==t.sChangeKey){delete t.oRequestQueue[K];delete t.oData[K];delete t.mContexts["/"+K];}else if(t.sChangeKey&&K===t.sChangeKey){delete t.oRequestQueue[K];t.sChangeKey=null;}});}};
m.prototype.resetChanges=function(s,E){var p;if(this.sChangeKey){p=this.sChangeKey.replace(this.sServiceUrl,'');this._loadData(p,null,s,E);}};
m.prototype.setProperty=function(p,v,o,A){var P,E={},D={},s=this._createRequestUrl(p,o),j=p.substring(0,p.lastIndexOf("/")),k,l,n={},r=false;if(!this.resolve(p,o)){return false;}s=s.replace(this.sServiceUrl+'/','');s=s.substring(0,s.indexOf("/"));s=this.sServiceUrl+'/'+s;P=p.substr(p.lastIndexOf("/")+1);D=this._getObject(j,o);if(!D){return false;}l=j.split("/");for(var i=l.length-1;i>=0;i--){E=this._getObject(l.join("/"),o);if(E){k=this._getKey(E);if(k){break;}}l.splice(i-1,1);}if(!k){k=this._getKey(o);}if(k){n[k]=true;}if(D._bCreate){D[P]=v;r=true;this.checkUpdate(false,A,n);}else{if(!this.sChangeKey){this.sChangeKey=s;}if(this.sChangeKey==s){D[P]=v;r=true;this.checkUpdate(false,A,n);}else{this.fireRejectChange({rejectedValue:v,oldValue:D[P]});}}return r;};
m.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;default:return false;}};
m.prototype.setHeaders=function(H){var i={},t=this;if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning("Not allowed to modify private header: "+s);}else{i[s]=j;}});this.mCustomHeaders=i;}else{this.mCustomHeaders={};}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};
m.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};
m.prototype._getHeader=function(F,H){var s;for(s in H){if(s.toLowerCase()===F.toLowerCase()){return H[s];}}return null;};
m.prototype.hasPendingChanges=function(){return this.sChangeKey!=null;};
m.prototype.updateBindings=function(F){this.checkUpdate(F);};
m.prototype.forceNoCache=function(F){this.bCache=!F;};
m.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};
m.prototype.setUseBatch=function(u){this.bUseBatch=u;};
m.prototype.formatValue=function(v,t){return O.formatValue(v,t);};
m.prototype.deleteCreatedEntry=function(o){if(o){var p=o.getPath();delete this.mContexts[p];if(q.sap.startsWith(p,"/")){p=p.substr(1);}delete this.oRequestQueue[p];delete this.oData[p];}};
m.prototype.createEntry=function(p,P){var E={},k,u,r;if(!q.sap.startsWith(p,"/")){p="/"+p;}var o=this.oMetadata._getEntityTypeByPath(p);if(!o){return undefined;}if(typeof P==="object"&&!Array.isArray(P)){E=P;}else{for(var i=0;i<o.property.length;i++){var j=o.property[i];var l=q.inArray(j.name,P)>-1;if(!P||l){E[j.name]=this._createPropertyValue(j.type);if(l){P.splice(P.indexOf(j.name),1);}}}if(P){}}E._bCreate=true;k=p.substring(1)+"('"+q.sap.uid()+"')";this.oData[k]=E;E.__metadata={type:""+o.entityType};u=this._createRequestUrl(p);r=this._createRequest(u,"POST",true,E);r.entityTypes={};r.entityTypes[o.entityType]=true;this.oRequestQueue[k]=r;return this.getContext("/"+k);};
m.prototype._createPropertyValue=function(t){var T=this.oMetadata._splitName(t);var n=T.namespace;var s=T.name;if(n.toUpperCase()!=='EDM'){var o={};var j=this.oMetadata._getObjectMetadata("complexType",s,n);for(var i=0;i<j.property.length;i++){var p=j.property[i];o[p.name]=this._createPropertyValue(p.type);}return o;}else{return this._getDefaultPropertyValue(s,n);}};
m.prototype._getDefaultPropertyValue=function(t,n){return undefined;};
m.prototype._normalizePath=function(p,o){if(p&&p.indexOf('?')!=-1){p=p.substr(0,p.indexOf('?'));}if(!o&&!q.sap.startsWith(p,"/")){p='/'+p;q.sap.log.warning(this+" path "+p+" should be absolute if no Context is set");}return this.resolve(p,o);};
m.prototype.setRefreshAfterChange=function(r){this.bRefreshAfterChange=r;};
m.prototype.isList=function(p,o){var p=this.resolve(p,o);return p&&p.substr(p.lastIndexOf("/")).indexOf("(")===-1;};
m.prototype.isMetaModelPath=function(p){return p.indexOf("##")==0||p.indexOf("/##")>-1;};
m.prototype._request=function(r,s,E,H,o,i){if(this.bDestroyed){return{abort:function(){}};}var t=this;function w(j){return function(){var I=q.inArray(R,t.aPendingRequestHandles);if(I>-1){t.aPendingRequestHandles.splice(I,1);}if(!(R&&R.bSuppressErrorHandlerCall)){j.apply(this,arguments);}};}var R=h.request(r,w(s||h.defaultSuccess),w(E||h.defaultError),H,o,i);if(r.async!==false){this.aPendingRequestHandles.push(R);}return R;};
m.prototype.destroy=function(){this.bDestroyed=true;if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var r=this.aPendingRequestHandles[i];if(r&&r.abort){r.bSuppressErrorHandlerCall=true;r.abort();}}delete this.aPendingRequestHandles;}if(!!this.oMetadataLoadEvent){q.sap.clearDelayedCall(this.oMetadataLoadEvent);}if(!!this.oMetadataFailedEvent){q.sap.clearDelayedCall(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachLoaded(this.onMetadataLoaded);this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oServiceData.oMetadata;}delete this.oMetadata;}if(this.oAnnotations){this.oAnnotations.detachFailed(this.onAnnotationsFailed);this.oAnnotations.detachLoaded(this.onAnnotationsLoaded);this.oAnnotations.destroy();delete this.oAnnotations;}M.prototype.destroy.apply(this,arguments);};
m.prototype._getAnnotationParser=function(A){if(!this.oAnnotations){var i=sap.ui.requireSync("sap/ui/model/odata/ODataAnnotations");this.oAnnotations=new i({annotationData:A,url:null,metadata:this.oMetadata,async:this.bLoadMetadataAsync,headers:this.mCustomHeaders});this.oAnnotations.attachFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachLoaded(this.onAnnotationsLoaded,this);}return this.oAnnotations;};
m.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};
m.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};
m.prototype.addAnnotationUrl=function(u){var j=[].concat(u),k=[],A=[],E=[],t=this;q.each(j,function(i,s){var I=s.indexOf("$metadata");if(I>=0){if(I==0){s=t.sServiceUrl+'/'+s;}k.push(s);}else{A.push(s);}});return this.oMetadata._addUrl(k).then(function(p){return Promise.all(q.map(p,function(P){E=E.concat(P.entitySets);return t.addAnnotationXML(P["metadataString"]);}));}).then(function(){return t._getAnnotationParser().addUrl(A);}).then(function(p){return{annotations:p.annotations,entitySets:E};});};
m.prototype.addAnnotationXML=function(x,s){return new Promise(function(r,i){this._getAnnotationParser().setXML(null,x,{success:r,error:i,fireEvents:!s});}.bind(this));};
m.prototype.getMetaModel=function(){var t=this;if(!this.oMetaModel){this.oMetaModel=new g(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.oMetadata.isLoaded()&&(!this.oAnnotations||this.oAnnotations.isLoaded())?null:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){t.bMetaModelLoaded=true;t.checkUpdate(false,false,null,true);});}return this.oMetaModel;};
return m;});
sap.ui.predefine('sap/ui/model/odata/ODataPropertyBinding',['jquery.sap.global','sap/ui/model/Context','sap/ui/model/ChangeReason','sap/ui/model/PropertyBinding','sap/ui/model/ChangeReason'],function(q,C,a,P){"use strict";
var O=P.extend("sap.ui.model.odata.ODataPropertyBinding",{constructor:function(m,p,c,b){P.apply(this,arguments);this.bInitial=true;this.oValue=this._getValue();this.vOriginalValue;this.getDataState().setValue(this.oValue);}});
O.prototype.initialize=function(){if(this.oModel.oMetadata.isLoaded()&&this.bInitial){this.checkUpdate(true);this.bInitial=false;}};
O.prototype.getValue=function(){return this.oValue;};
O.prototype._getValue=function(){return this.oModel._getObject(this.sPath,this.oContext);};
O.prototype.setValue=function(v){if(this.bSuspended){return;}if(!q.sap.equal(v,this.oValue)&&this.oModel.setProperty(this.sPath,v,this.oContext,true)){this.oValue=v;var d=this.getDataState();d.setValue(this.oValue);this.oModel.firePropertyChange({reason:a.Binding,path:this.sPath,context:this.oContext,value:v});}};
O.prototype.setContext=function(c){if(c&&c.isPreliminary()){return;}if(C.hasChanged(this.oContext,c)){sap.ui.getCore().getMessageManager().removeMessages(this.getDataState().getControlMessages(),true);this.oContext=c;if(this.isRelative()){this.checkUpdate();}}};
O.prototype.checkUpdate=function(f){if(this.bSuspended&&!f){return;}var d=this.getDataState();var c=false;var o=this.oModel.getOriginalProperty(this.sPath,this.oContext);if(f||!q.sap.equal(o,this.vOriginalValue)){this.vOriginalValue=o;d.setOriginalValue(o);c=true;}var v=this._getValue();if(f||!q.sap.equal(v,this.oValue)){this.oValue=v;d.setValue(this.oValue);this._fireChange({reason:a.Change});c=true;}if(c){this.checkDataState();}};
O.prototype.checkDataState=function(p){var c=this.oModel.resolve(this.sPath,this.oContext,true);if(!p||c&&c in p){var d=this.getDataState();d.setLaundering(!!p&&!!(c in p));P.prototype.checkDataState.apply(this,arguments);d.setModelMessages(this.oModel.getMessagesByPath(c));}};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataTreeBinding',['jquery.sap.global','sap/ui/model/TreeBinding','./CountMode'],function(q,T,C){"use strict";
var O=T.extend("sap.ui.model.odata.ODataTreeBinding",{constructor:function(m,p,c,f,P){T.apply(this,arguments);this.bPendingRequest=false;this.oFinalLengths={};this.oLengths={};this.oKeys={};this.bNeedsUpdate=false;this.bHasTreeAnnotations=this._hasTreeAnnotations();this.oRootContext=null;this.iNumberOfExpandedLevels=P&&P.numberOfExpandedLevels;this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;if(!this.bHasTreeAnnotations){if(!P||!P.navigation){q.sap.log.error("A navigation paths parameter object has to be defined");this.oNavigationPaths={};}else{this.oNavigationPaths=P.navigation;}}else{q.sap.log.warning("Tree hierarchy annotations are deprecated and may not work correctly with the sap.ui.model.odata.ODataModel."+" Please use the sap.ui.model.odata.v2.ODataModel (since version 1.28) instead which fully supports hierarchy annotations.");}}});
O.prototype.getRootContexts=function(s,l,t){var n=null,r={numberOfExpandedLevels:this.iNumberOfExpandedLevels},R=[],b=true,a=this;if(this.bHasTreeAnnotations){r.level=0;if(!this.bDisplayRootNode){r.level=1;}}else{n=this.oModel.resolve(this.getPath(),this.getContext());r.navPath=this._getNavPath(this.getPath());if(r.numberOfExpandedLevels>0){var A=n;for(var i=0;i<r.numberOfExpandedLevels;i++){var N=this._getNavPath(A);r.navPath+="/"+N;A+="/"+N;}}var I=this.oModel.isList(this.sPath,this.getContext());if(I){this.bDisplayRootNode=true;}else{b=false;this.oModel.createBindingContext(n,null,{expand:r.navPath},function(o){R=[o];if(a.oRootContext!==o){a.oRootContext=o;a._processODataObject(o.getObject(),n,r.navPath);a.bNeedsUpdate=true;}},this.bRefresh);this.bRefresh=false;}}if(b){if(!this.bDisplayRootNode){R=this._getContextsForNodeId(n,0,1,0,r);}else{R=this._getContextsForNodeId(n,s,l,t,r);}}if(!this.bDisplayRootNode&&R.length>0){this.oRootContext=R[0];R=this.getNodeContexts(R[0],s,l,t);}return R;};
O.prototype.getNodeContexts=function(c,s,l,t){var n,r={};if(this.bHasTreeAnnotations){var d=c.getProperty(this.oTreeProperties["hierarchy-drill-state-for"]);if(d=="leaf"){return[];}n=c.getProperty(this.oTreeProperties["hierarchy-node-for"]);r.level=parseInt(c.getProperty(this.oTreeProperties["hierarchy-level-for"]),10)+1;}else{var N=this._getNavPath(c.getPath());if(!N){return[];}n=this.oModel.resolve(N,c);r.navPath=this.oNavigationPaths[N];}return this._getContextsForNodeId(n,s,l,t,r);};
O.prototype.hasChildren=function(c){if(!c){return false;}if(this.bHasTreeAnnotations){var d=c.getProperty(this.oTreeProperties["hierarchy-drill-state-for"]);return d==="expanded"||d==="collapsed";}else{var n=this._getNavPath(c.getPath());var p=c.getPath()+"/"+n;return n&&this.oLengths[p]>0;}};
O.prototype.getChildCount=function(c){if(this.bHasTreeAnnotations){var h;if(!c){if(this.oRootContext){h=this.oRootContext.getProperty(this.oTreeProperties["hierarchy-node-for"]);}else{h="000000";}}else{h=c.getProperty(this.oTreeProperties["hierarchy-node-for"]);}return this.oLengths[h];}else{if(!c){return this.oLengths[this.getPath()];}return this.oLengths[c.getPath()+"/"+this._getNavPath(c.getPath())];}};
O.prototype._getContextsForNodeId=function(n,s,l,t,p){var c=[],L,k;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}if(this.bHasTreeAnnotations){if(n==null){n="000000";}if(p.level==0){p.level++;}}if(this.oFinalLengths[n]&&this.oLengths[n]<l){l=this.oLengths[n];}if(this.oKeys[n]){for(var i=s;i<s+l;i++){k=this.oKeys[n][i];if(!k){break;}c.push(this.oModel.getContext('/'+k));}}L=c.length!=l&&!(this.oFinalLengths[n]&&c.length>=this.oLengths[n]);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&L){var P=[];if(this.bHasTreeAnnotations){if(p.numberOfExpandedLevels>0){var a=p.level+p.numberOfExpandedLevels;P.push("$filter="+this.oTreeProperties["hierarchy-level-for"]+" le '0"+a+"'");}else{P.push("$filter="+this.oTreeProperties["hierarchy-level-for"]+" eq '0"+p.level+"' and "+this.oTreeProperties["hierarchy-parent-node-for"]+" eq '"+n+"'");}}else{if(p.navPath){P.push("$expand="+p.navPath);}}this._loadSubNodes(n,s,l,t,P,p);}}return c;};
O.prototype._getCountForNodeId=function(n,s,l,t,p){var a=this;var P=[];function _(d){a.oFinalLengths[n]=true;a.oLengths[n]=parseInt(d,10);}function b(e){var E="Request for $count failed: "+e.message;if(e.response){E+=", "+e.response.statusCode+", "+e.response.statusText+", "+e.response.body;}q.sap.log.warning(E);}var c;if(this.bHasTreeAnnotations){c=this.oModel.resolve(this.getPath(),this.getContext());P.push("$filter="+this.oTreeProperties["hierarchy-parent-node-for"]+" eq '"+n+"'");}else{c=n;}if(c){var u=this.oModel._createRequestUrl(c+"/$count",null,P);var r=this.oModel._createRequest(u,"GET",false);r.headers["Accept"]="text/plain, */*;q=0.5";this.oModel._request(r,_,b,undefined,undefined,this.oModel.getServiceMetadata());}};
O.prototype._loadSubNodes=function(n,s,l,t,p,P){var a=this,I=false;if(s||l){p.push("$skip="+s+"&$top="+l);}if(!a.bHasTreeAnnotations&&!this.oFinalLengths[n]&&(this.sCountMode==C.Inline||this.sCountMode==C.Both)){p.push("$inlinecount=allpages");I=true;}function S(d){if(d.results){if(!a.bHasTreeAnnotations){if(I&&d.__count){a.oLengths[n]=parseInt(d.__count,10);a.oFinalLengths[n]=true;}else{if(a.oModel.isCountSupported()){a._getCountForNodeId(n);}}a.oKeys[n]=[];for(var i=0;i<d.results.length;i++){var E=d.results[i];var k=a.oModel._getKey(E);a._processODataObject(E,"/"+k,P.navPath);a.oKeys[n][i+s]=k;}}else{var L={};for(var i=0;i<d.results.length;i++){var E=d.results[i];n=E[a.oTreeProperties["hierarchy-parent-node-for"]];if(i==0){L[n]=s;}else if(L[n]==undefined){L[n]=0;}if(!(n in a.oKeys)){a.oKeys[n]=[];a._getCountForNodeId(n);}a.oKeys[n][L[n]]=a.oModel._getKey(E);L[n]++;}}}else{a.oKeys[null]=a.oModel._getKey(d);if(!a.bHasTreeAnnotations){a._processODataObject(d,n,P.navPath);}}a.oRequestHandle=null;a.bPendingRequest=false;a.bNeedsUpdate=true;}function c(){a.fireDataReceived();}function e(d){a.oRequestHandle=null;a.bPendingRequest=false;a.fireDataReceived();}function u(h){a.oRequestHandle=h;}if(n){if(!this.oFinalLengths[n]){this.bPendingRequest=true;this.fireDataRequested();var A;if(this.bHasTreeAnnotations){A=this.oModel.resolve(this.getPath(),this.getContext());}else{A=n;}this.oModel._loadData(A,p,S,e,false,u,c);}}};
O.prototype.resetData=function(c){if(c){var p=c.getPath();delete this.oKeys[p];delete this.oLengths[p];delete this.oFinalLengths[p];}else{this.oKeys={};this.oLengths={};this.oFinalLengths={};this.oRootContext=null;}};
O.prototype.refresh=function(f,c,e){var b=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e)){b=true;}}if(c&&!b){q.each(this.oKeys,function(i,n){q.each(n,function(i,k){if(k in c){b=true;return false;}});if(b){return false;}});}if(!c&&!e){b=true;}}if(f||b){this.resetData();this.bNeedsUpdate=false;this.bRefresh=true;this._fireChange();}};
O.prototype.filter=function(f){q.sap.log.warning("Filtering is currently not possible in the ODataTreeBinding");return this;};
O.prototype.checkUpdate=function(f,c){var b=false;if(!f){if(this.bNeedsUpdate||!c){b=true;}else{q.each(this.oKeys,function(i,n){q.each(n,function(i,k){if(k in c){b=true;return false;}});if(b){return false;}});}}if(f||b){this.bNeedsUpdate=false;this._fireChange();}};
O.prototype._getNavPath=function(p){var a=this.oModel.resolve(p,this.getContext());if(!a){return;}var P=a.split("/"),e=P[P.length-1],n;var c=e.split("(")[0];if(c&&this.oNavigationPaths[c]){n=this.oNavigationPaths[c];}return n;};
O.prototype._processODataObject=function(o,p,n){var N=[],t=this;if(n&&n.indexOf("/")>-1){N=n.split("/");n=N[0];N.splice(0,1);}var r=this.oModel._getObject(p);if(Array.isArray(r)){this.oKeys[p]=r;this.oLengths[p]=r.length;this.oFinalLengths[p]=true;}if(n&&o[n]){if(Array.isArray(r)){r.forEach(function(R){var o=t.getModel().getData("/"+R);t._processODataObject(o,"/"+R+"/"+n,N.join("/"));});}else if(typeof r==="object"){t._processODataObject(o,p+"/"+n,N.join("/"));}}};
O.prototype._hasTreeAnnotations=function(){var m=this.oModel,M=m.oMetadata,a=m.resolve(this.getPath(),this.getContext()),e=M._getEntityTypeByPath(a),t=M.mNamespaces["sap"],b=this;this.oTreeProperties={"hierarchy-level-for":false,"hierarchy-parent-node-for":false,"hierarchy-node-for":false,"hierarchy-drill-state-for":false};if(!e){q.sap.log.fatal("EntityType for path "+a+" could not be found.");return false;}q.each(e.property,function(i,p){if(!p.extensions){return true;}q.each(p.extensions,function(i,E){var n=E.name;if(E.namespace===t&&n in b.oTreeProperties&&!b.oTreeProperties[n]){b.oTreeProperties[n]=p.name;}});});var c=false;q.each(this.oTreeProperties,function(i,o){if(!o){c=true;return false;}});return!c;};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataTreeBindingAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','./v2/ODataTreeBinding','sap/ui/model/TreeBindingAdapter','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','./OperationMode'],function(q,T,O,a,b,C,c){"use strict";var d=function(){if(!(this instanceof T)||this._bIsAdapted){return;}a.apply(this);for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this.mParameters=this.mParameters||{};this._aRowIndexMap=[];this._iThreshold=0;this._iPageSize=0;this.setAutoExpandMode(this.mParameters.autoExpandMode||b.Sequential);if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._createTreeState();if(this.mParameters.treeState&&this.sOperationMode==c.Client){this.setTreeState(this.mParameters.treeState);}};
d.prototype.nodeHasChildren=function(n){if(!n){return false;}else if(n.isArtificial){return true;}else{return O.prototype.hasChildren.call(this,n.context);}};
d.prototype._calculateGroupID=function(n){var g="";var G="";var e;if(n.context===null){return"/";}if(n.parent){g=n.parent.groupID;g=g[g.length-1]!=="/"?g+"/":g;if(this.bHasTreeAnnotations){e=(n.context.getProperty(this.oTreeProperties["hierarchy-node-for"])+"").replace(/\//g,"%2F");G=e+"/";}else{G=n.context.sPath.substring(1)+"/";}}else{if(this.bHasTreeAnnotations){g="/";e=(n.context.getProperty(this.oTreeProperties["hierarchy-node-for"])+"").replace(/\//g,"%2F");G=e+"/";}else{g="/";G=n.context.sPath[0]==="/"?n.context.sPath.substring(1):n.context.sPath;}}var s=g+G;return s;};
d.prototype.resetData=function(o,p){var r=O.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==C.Sort){this.clearSelection();this._createTreeState(true);}return r;};
return d;},true);
sap.ui.predefine('sap/ui/model/odata/ODataTreeBindingFlat',['jquery.sap.global','sap/ui/model/Filter','sap/ui/model/TreeBinding','sap/ui/model/odata/v2/ODataTreeBinding','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils'],function(q,F,T,O,C,c){"use strict";var d=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this.mParameters=this.mParameters||{};this._iPageSize=0;this._aNodes=this._aNodes||[];this._aNodeCache=[];this._aCollapsed=this._aCollapsed||[];this._aExpanded=this._aExpanded||[];this._aRemoved=[];this._aAdded=[];this._aNodeChanges=[];this._aAllChangedNodes=[];this._mSubtreeHandles={};this._iLowestServerLevel=null;this._aExpandedAfterSelectAll=this._aExpandedAfterSelectAll||[];this._mSelected=this._mSelected||{};this._mDeselected=this._mDeselected||{};this._bSelectAll=false;this._iLengthDelta=0;if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._bIsAdapted=true;this._bReadOnly=true;this._aPendingRequests=[];this._aPendingChildrenRequests=[];};
d.prototype.setNumberOfExpandedLevels=function(l){this.resetData();O.prototype.setNumberOfExpandedLevels.apply(this,arguments);};
d.prototype.getContexts=function(s,l,t,r){if(this.isInitial()){return[];}s=s||0;l=l||this.oModel.iSizeLimit;t=t||0;this._iPageSize=l;this._iThreshold=t;if(this._aNodes.length==0&&!this.isLengthFinal()){this._loadData(s,l,t);}var R=[];var n=this._retrieveNodeSection(s,l);this._aNodeCache=[];var S;var a=0;var L=0;var g={};for(var i=0;i<n.length;i++){var N=n[i];this._aNodeCache[s+i]=N&&N.context?N:undefined;R.push(N.context);if(!N.context){if(N.serverIndex!=undefined){if(S==undefined){S=N.serverIndex;}L=N.serverIndex;}else if(N.positionInParent!=undefined){var p=N.parent;g[p.key]=g[p.key]||[];g[p.key].push(N);}}}a=1+Math.max(L-(S||0),0);if(S!=undefined&&a){this._loadData(S,a,t);}for(var m in g){var o=this._calculateRequestParameters(g[m]);this._loadChildren(g[m][0].parent,o.skip,o.top);}if(r){return n;}else{return R;}};
d.prototype._calculateRequestParameters=function(m){var p=m[0].parent;var M=m[0].positionInParent;var a=Math.min(M+Math.max(this._iThreshold,m.length),p.children.length);for(var i=M;i<a;i++){var o=p.children[i];if(o){break;}}return{skip:M,top:i-M};};
d.prototype._retrieveNodeSection=function(s,l){return this._bReadOnly?this._indexRetrieveNodeSection(s,l):this._mapRetrieveNodeSection(s,l);};
d.prototype._mapRetrieveNodeSection=function(s,l){var n=-1;var N=[];this._map(function(o,r,i,I,p){n++;if(n>=s){if(!o){if(i=="serverIndex"){o={serverIndex:I};}else if(i=="positionInParent"){o={positionInParent:I,parent:p};}}N.push(o);}if(N.length>=l){r.broken=true;}});return N;};
d.prototype._indexRetrieveNodeSection=function(s,l){var i,n=[],N,o;for(i=s;i<s+l;i++){N=this.getNodeInfoByRowIndex(i);if(N.index!==undefined&&N.index<this._aNodes.length){o=this._aNodes[N.index];if(!o){o={serverIndex:N.index};}}else if(N.parent){o=N.parent.children[N.childIndex];if(!o){o={parent:N.parent,positionInParent:N.childIndex};}}if(o){n.push(o);o=null;}}return n;};
d.prototype.getNodes=function(s,l,t){var n=this.getContexts(s,l,t,true);return n;};
d.prototype._map=function(m){var r={broken:false};var f=function(n){if(n.addedSubtrees.length>0&&!n.nodeState.collapsed){for(var j=0;j<n.addedSubtrees.length;j++){var s=n.addedSubtrees[j];t(n,s);if(r.broken){return;}}}};var t=function(n,s){var S=s._getSubtree();if(s){if(Array.isArray(S)){if(s._oSubtreeRoot){b(S,s._oSubtreeRoot.serverIndex,s._oSubtreeRoot,s._oSubtreeRoot.originalLevel||0,n.level+1);}else{b(S,null,null,0,n.level+1);}}else{s._oSubtreeRoot.level=n.level+1;a(s._oSubtreeRoot,false,s._oNewParentNode,-1,s._oSubtreeRoot);}}};var a=function(n,I,p,P,o){if(!I){if(!n.nodeState.removed||o==n){m(n,r,"positionInParent",P,p);if(r.broken){return;}}}f(n);if(r.broken){return;}if(n&&n.children&&n.nodeState.expanded){for(var i=0;i<n.children.length;i++){var e=n.children[i];if(e&&!e.nodeState.removed&&!e.nodeState.reinserted){e.level=n.level+1;}if(e&&!e.nodeState.removed){a(e,false,n,i,o);}else if(!e){m(e,r,"positionInParent",i,n);}if(r.broken){return;}}}};var b=function(e,s,I,S,n){for(var i=0;i<e.length;i++){var N=e[i];if(N&&N.nodeState&&N.nodeState.removed&&N!=I){if(!N.initiallyCollapsed){i+=N.magnitude;}continue;}if(N&&S>=0&&n>=0){N.level=N.originalLevel||0;var l=(N.level-S)||0;N.level=n+l||0;}if(s===null){m(N,r,"newNode");}else{m(N,r,"serverIndex",s+i);}if(r.broken){return;}if(N&&N.nodeState){if(!N.initiallyCollapsed&&N.nodeState.collapsed){i+=N.magnitude;}else{if(N.initiallyCollapsed&&N.nodeState.expanded){a(N,true);if(r.broken){return;}}else if(!N.initiallyCollapsed&&N.nodeState.expanded){f(N);}}}if(r.broken){return;}}};b(this._aNodes,0,null);};
d.prototype._loadData=function(s,t,i){var a=this;this.fireDataRequested();this._requestServerIndexNodes(s,t,i).then(function(r){a._addServerIndexNodes(r.oData,r.iSkip);a._fireChange({reason:C.Change});a.fireDataReceived({data:r.oData});},function(e){var A=e.statusCode===0;if(!A){a._aNodes=[];a._bLengthFinal=true;a._fireChange({reason:C.Change});}a.fireDataReceived();});};
d.prototype._restoreServerIndexNodes=function(s,t,i){var a=this;return this._requestServerIndexNodes(s,t,0,i).then(function(r){a._addServerIndexNodes(r.oData,r.iSkip);return r;});};
d.prototype._addServerIndexNodes=function(D,s){var e,k,I,i,t=function(n,b){if(!n.isDeepOne&&!n.initiallyCollapsed&&n.serverIndex<I&&n.serverIndex+n.magnitude>=I){return true;}};if(!this._bLengthFinal){var a=D.__count?parseInt(D.__count,10):0;this._aNodes[a-1]=undefined;this._bLengthFinal=true;}if(D.results&&D.results.length>0){for(i=0;i<D.results.length;i++){e=D.results[i];k=this.oModel.getKey(e);I=s+i;var m=e[this.oTreeProperties["hierarchy-node-descendant-count-for"]];if(m<0){m=0;q.sap.log.error("The entry data with key '"+k+"' under binding path '"+this.getPath()+"' has a negative 'hierarchy-node-descendant-count-for' which isn't allowed.");}var n=this._aNodes[I]=this._aNodes[I]||{key:k,context:this.oModel.getContext("/"+k),magnitude:m,level:e[this.oTreeProperties["hierarchy-level-for"]],originalLevel:e[this.oTreeProperties["hierarchy-level-for"]],initiallyCollapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",nodeState:{isLeaf:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[k]?this._mSelected[k].nodeState.selected:false},children:[],addedSubtrees:[],serverIndex:I,parent:null,isDeepOne:false};if(this._iLowestServerLevel===null){this._iLowestServerLevel=n.level;}else{this._iLowestServerLevel=Math.min(this._iLowestServerLevel,n.level);}if(this._bSelectAll){if(!this._aExpandedAfterSelectAll.some(t)){this.setNodeSelection(n,true);}}}}};
d.prototype._requestServerIndexNodes=function(s,t,e,I){return new Promise(function(r,f){var R={iSkip:s,iTop:t+(e||0),iThreshold:e};this._aPendingRequests.sort(function(a,b){return a.iSkip-b.iSkip;});for(var i=0;i<this._aPendingRequests.length;i++){if(c._determineRequestDelta(R,this._aPendingRequests[i])===false){return;}}s=R.iSkip;t=R.iTop;function _(D){var a=this._aPendingRequests.indexOf(R);this._aPendingRequests.splice(a,1);r({oData:D,iSkip:s,iTop:t});}function g(E){var a=this._aPendingRequests.indexOf(R);this._aPendingRequests.splice(a,1);f(E);}var u=["$skip="+s,"$top="+t];if(!this._bLengthFinal||I){u.push("$inlinecount=allpages");}if(this.sCustomParams){u.push(this.sCustomParams);}var l=new F(this.oTreeProperties["hierarchy-level-for"],"LE",this.getNumberOfExpandedLevels());var h=[l];if(this.aApplicationFilters){h=h.concat(this.aApplicationFilters);}R.oRequestHandle=this.oModel.read(this.getPath(),{context:this.oContext,urlParameters:u,filters:[new F({filters:h,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:g.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingRequests.push(R);}.bind(this));};
d.prototype._propagateMagnitudeChange=function(p,D){while(p!=null&&(p.initiallyCollapsed||p.isDeepOne)){p.magnitude+=D;p=p.parent;}};
d.prototype._getInitialMagnitude=function(n){var D=0,o;if(n.isDeepOne){return 0;}if(n.children){for(var i=0;i<n.children.length;i++){o=n.children[i];D+=o.magnitude+1;}}return n.magnitude-D;};
d.prototype._loadChildren=function(p,s,t){var a=this;this.fireDataRequested();this._requestChildren(p,s,t).then(function(r){a._addChildNodes(r.oData,p,r.iSkip);a._fireChange({reason:C.Change});a.fireDataReceived({data:r.oData});},function(e){var A=e.statusCode===0;if(!A){if(p.childCount===undefined){p.children=[];p.childCount=0;a._fireChange({reason:C.Change});}}a.fireDataReceived();});};
d.prototype._restoreChildren=function(p,s,t){var a=this,P=this.oModel.getKey(p.context);return this._requestChildren(p,s,t,true).then(function(r){var n;a._map(function(N,R){if(N&&N.key===P){n=N;R.broken=true;}});if(n){a._addChildNodes(r.oData,n,r.iSkip);a.expand(n,true);}return r;});};
d.prototype._addChildNodes=function(D,p,s){if(p.childCount==undefined&&D&&D.__count){var a=D.__count?parseInt(D.__count,10):0;p.childCount=a;p.children[a-1]=undefined;if(p.nodeState.expanded){this._propagateMagnitudeChange(p,a);}else{p.magnitude=a;}this._cleanTreeStateMaps();}if(D.results&&D.results.length>0){for(var i=0;i<D.results.length;i++){var e=D.results[i];var k=this.oModel.getKey(e);var n=p.children[s+i]=p.children[s+i]||{key:k,context:this.oModel.getContext("/"+k),magnitude:0,level:p.level+1,originalLevel:p.level+1,initiallyCollapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",nodeState:{isLeaf:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[k]?this._mSelected[k].nodeState.selected:false},positionInParent:s+i,children:[],addedSubtrees:[],parent:p,originalParent:p,isDeepOne:true,containingServerIndex:p.containingServerIndex||p.serverIndex};if(this._bSelectAll&&this._aExpandedAfterSelectAll.indexOf(p)===-1){this.setNodeSelection(n,true);}}}};
d.prototype._requestChildren=function(p,s,t,I){return new Promise(function(r,e){var R={sParent:p.key,iSkip:s,iTop:t};this._aPendingChildrenRequests.sort(function(a,b){return a.iSkip-b.iSkip;});for(var i=0;i<this._aPendingChildrenRequests.length;i++){var P=this._aPendingChildrenRequests[i];if(P.sParent===R.sParent){if(c._determineRequestDelta(R,P)===false){return;}}}s=R.iSkip;t=R.iTop;function _(D){var a=this._aPendingChildrenRequests.indexOf(R);this._aPendingChildrenRequests.splice(a,1);r({oData:D,iSkip:s,iTop:t});}function f(E){var a=this._aPendingChildrenRequests.indexOf(R);this._aPendingChildrenRequests.splice(a,1);e(E);}var u=["$skip="+s,"$top="+t];if(p.childCount==undefined||I){u.push("$inlinecount=allpages");}if(this.sCustomParams){u.push(this.sCustomParams);}var l=new F(this.oTreeProperties["hierarchy-parent-node-for"],"EQ",p.context.getProperty(this.oTreeProperties["hierarchy-node-for"]));var g=[l];if(this.aApplicationFilters){g=g.concat(this.aApplicationFilters);}R.oRequestHandle=this.oModel.read(this.getPath(),{context:this.oContext,urlParameters:u,filters:[new F({filters:g,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:f.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingChildrenRequests.push(R);}.bind(this));};
d.prototype.findNode=function(r){return this._bReadOnly?this._indexFindNode(r):this._mapFindNode(r);};
d.prototype._mapFindNode=function(r){if(this.isInitial()){return;}var f=this._aNodeCache[r];if(f){return f;}var n=-1;this._map(function(N,R,i,I,p){n++;if(n===r){f=N;R.broken=true;}});return f;};
d.prototype._indexFindNode=function(r){if(this.isInitial()){return;}var n=this._aNodeCache[r];if(n){return n;}var N=this.getNodeInfoByRowIndex(r),n;if(N.parent){n=N.parent.children[N.childIndex];}else{n=this._aNodes[N.index];}this._aNodeCache[r]=n;return n;};
d.prototype.toggleIndex=function(r){var t=this.findNode(r);if(t){if(t.nodeState.expanded){this.collapse(t);}else{this.expand(t);}}};
d.prototype.expand=function(r,s){var t=r;if(typeof r!=="object"){t=this.findNode(r);}if(t.nodeState.expanded){return;}t.nodeState.expanded=true;t.nodeState.collapsed=false;var i=this._aCollapsed.indexOf(t);if(i!=-1){this._aCollapsed.splice(i,1);}this._aExpanded.push(t);this._sortNodes(this._aExpanded);if(t.serverIndex!==undefined){this._aNodeChanges[t.serverIndex]=true;}if(this._bSelectAll){this._aExpandedAfterSelectAll.push(t);}if(t.initiallyCollapsed&&t.childCount==undefined){this._loadChildren(t,0,this._iPageSize);}else{this._propagateMagnitudeChange(t.parent,t.magnitude);}this._cleanTreeStateMaps();this._aNodeCache=[];if(!s){this._fireChange({reason:C.Expand});}};
d.prototype.expandToLevel=function(l){if(l>this.getNumberOfExpandedLevels()){this.setNumberOfExpandedLevels(l);}};
d.prototype.collapse=function(r,s){var t=r;if(typeof r!=="object"){t=this.findNode(r);}if(t.nodeState.collapsed){return;}t.nodeState.expanded=false;t.nodeState.collapsed=true;var i=this._aExpanded.indexOf(t);if(i!=-1){this._aExpanded.splice(i,1);}if(this._bSelectAll){i=this._aExpandedAfterSelectAll.indexOf(t);if(i!==-1){this._aExpandedAfterSelectAll.splice(i,1);}}this._aCollapsed.push(t);this._sortNodes(this._aCollapsed);if(t.isDeepOne){this._propagateMagnitudeChange(t.parent,t.magnitude*-1);}if(t.serverIndex!==undefined){this._aNodeChanges[t.serverIndex]=true;}this._cleanUpSelection();this._cleanTreeStateMaps();this._aNodeCache=[];if(!s){this._fireChange({reason:C.Collapse});}};
d.prototype.collapseToLevel=function(l){if(l<this.getNumberOfExpandedLevels()){if(this.bCollapseRecursive){for(var k in this._mSelected){var s=this._mSelected[k];if(s.level>l){this.setNodeSelection(s,false);}}}this.setNumberOfExpandedLevels(l);}};
d.prototype._getInvisibleSelectedNodes=function(){var a=[];var i=true;var f=function(n,b){if(n.nodeState.collapsed||(n.nodeState.removed&&!n.nodeState.reinserted)){i=false;b.broken=true;}};for(var k in this._mSelected){var s=this._mSelected[k];i=true;this._up(s,f,false);if(!i){a.push(s);}}return a;};
d.prototype._cleanUpSelection=function(f){var i=this._getInvisibleSelectedNodes();i.forEach(function(s){if(s.key==this._sLeadSelectionKey){this._sLeadSelectionKey=null;}if(this.bCollapseRecursive||f){this.setNodeSelection(s,false);}}.bind(this));};
d.prototype._isInSubtree=function(a,o){var i=false;var f=function(n,b){if(n==a){b.broken=true;i=true;}};this._up(o,f,false);return i;};
d.prototype._up=function(n,u,o){var r={broken:false};var p=this._getParent(n,o);if(p){this._structuralUp(p,u,r,o);}else{this._flatUp(n,u,r,true);}};
d.prototype._structuralUp=function(n,u,b,o){var p=n;do{u(p,b);if(b.broken){return;}n=p;p=this._getParent(p);}while(p);this._flatUp(n,u,b);};
d.prototype._flatUp=function(n,u,b,I){var s=n.serverIndex,i=I?s-1:s,o,p;for(;i>=0;i--){if(this._aNodeChanges[i]){o=this._aNodes[i];if(o.initiallyCollapsed){continue;}if(o.serverIndex+o.magnitude>=s){u(o,b);if(b.broken){return;}p=this._getParent(o);if(p){this._structuralUp(p,u,b);return;}}else{continue;}}}};
d.prototype._getParent=function(n,o){return o?n.originalParent:n.parent;};
d.prototype._cleanTreeStateMaps=function(){this._iLengthDelta=this._bReadOnly?this._indexCleanTreeStateMaps():this._mapCleanTreeStateMaps();};
d.prototype._indexCleanTreeStateMaps=function(){return this._calcIndexDelta(this._aNodes.length);};
d.prototype._mapCleanTreeStateMaps=function(){var a=this._aCollapsed.concat(this._aRemoved).concat(this._aExpanded).concat(this._aAdded),v=true,V,D=0,f=function(n,B){if(n.nodeState.collapsed||(n.nodeState.removed&&!n.nodeState.reinserted)){v=false;B.broken=true;}},s={};var b=[[0,1],[-1,0]];a.forEach(function(n){if(s[n.key]){return;}else{s[n.key]=true;}if(n.nodeState.added){if(!n.nodeState.removed||n.nodeState.reinserted){v=true;this._up(n,f,false);if(v){D++;}}}else{if(n.nodeState.collapsed||n.nodeState.expanded||n.nodeState.removed){v=true;this._up(n,f,false);if(v){if(n.nodeState.removed&&!n.nodeState.reinserted){if(n.isDeepOne||n.initiallyCollapsed){D-=1;}else{D-=(n.magnitude+1);}}else{if(n.nodeState.collapsed&&n.serverIndex!==undefined&&!n.initiallyCollapsed){D-=n.magnitude;}if(n.nodeState.expanded&&(n.isDeepOne||n.initiallyCollapsed)){D+=n.children.length;}}}if(n.nodeState.reinserted){V=v;v=true;this._up(n,f,true);var i=(b[v|0][V|0]);if(!!i){if(n.isDeepOne){D+=i*1;}else{if(n.initiallyCollapsed){D+=i;}else{D+=i*(1+n.magnitude);}}}}}}}.bind(this));return D;};
d.prototype.isLengthFinal=function(){return this._bLengthFinal;};
d.prototype.getLength=function(){return this._aNodes.length+this._iLengthDelta;};
d.prototype.getContextByIndex=function(r){if(this.isInitial()){return;}var n=this.findNode(r);return n&&n.context;};
d.prototype.getNodeByIndex=function(r){if(this.isInitial()){return;}var n=this.findNode(r);return n;};
d.prototype.isExpanded=function(r){var n=this.findNode(r);return n&&n.nodeState.expanded;};
d.prototype.hasChildren=function(o){if(!o){return false;}var n=this._findNodeByContext(o);var N=n&&n.node;return!(N&&N.nodeState.isLeaf);};
d.prototype.nodeHasChildren=function(n){return!(n&&n.nodeState.isLeaf);};
d.prototype.setNodeSelection=function(n,i){n.nodeState.selected=i;if(i){delete this._mDeselected[n.key];this._mSelected[n.key]=n;}else{delete this._mSelected[n.key];this._mDeselected[n.key]=n;if(n.key===this._sLeadSelectionKey){this._sLeadSelectionKey=null;}}};
d.prototype.isIndexSelected=function(r){var n=this.findNode(r);return n&&n.nodeState?n.nodeState.selected:false;};
d.prototype.isIndexSelectable=function(r){var n=this.findNode(r);return!!n;};
d.prototype._clearSelection=function(){return this._bReadOnly?this._indexClearSelection():this._mapClearSelection();};
d.prototype._indexClearSelection=function(){var o=-1,a=[],s,n,r;this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(s in this._mSelected){n=this._mSelected[s];this.setNodeSelection(n,false);r=this.getRowIndexByNode(n);a.push(r);if(this._sLeadSelectionKey==s){o=r;}}return{rowIndices:a,oldIndex:o,leadIndex:-1};};
d.prototype._mapClearSelection=function(){var n=-1;var o=-1;var m=0;var a=[];this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(var k in this._mSelected){if(k){m++;}}this._map(function(N,r,i,I,p){n++;if(N&&N.nodeState.selected){this.setNodeSelection(N,false);a.push(n);if(this._sLeadSelectionKey==N.key){o=n;}if(a.length==m){r.broken=true;}}}.bind(this));return{rowIndices:a,oldIndex:o,leadIndex:-1};};
d.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadKey=n.key;o.leadIndex=r;this.setNodeSelection(n,true);this._publishSelectionChanges(o);}else{q.sap.log.warning("ODataTreeBindingFlat: The selection of index '"+r+"' was ignored. Please make sure to only select rows, for which data has been fetched to the client.");}};
d.prototype.getSelectedIndex=function(){return this._bReadOnly?this._indexGetSelectedIndex():this._mapGetSelectedIndex();};
d.prototype._indexGetSelectedIndex=function(){if(!this._sLeadSelectionKey||q.isEmptyObject(this._mSelected)){return-1;}var s=this._mSelected[this._sLeadSelectionKey];if(s){return this.getRowIndexByNode(s);}else{return-1;}};
d.prototype._mapGetSelectedIndex=function(){if(!this._sLeadSelectionKey||q.isEmptyObject(this._mSelected)){return-1;}var n=-1;this._map(function(N,r){n++;if(N){if(N.key===this._sLeadSelectionKey){r.broken=true;}}}.bind(this));return n;};
d.prototype.getSelectedIndices=function(){return this._bReadOnly?this._indexGetSelectedIndices():this._mapGetSelectedIndices();};
d.prototype._indexGetSelectedIndices=function(){var n=this._getSelectedNodesInfo();return n.map(function(N){return N.rowIndex;});};
d.prototype._mapGetSelectedIndices=function(){var r=[];if(q.isEmptyObject(this._mSelected)){return r;}var n=-1;this._map(function(N){n++;if(N){if(N.nodeState&&N.nodeState.selected){r.push(n);}}});return r;};
d.prototype.getSelectedNodesCount=function(){var s;if(this._bSelectAll){if(this._bReadOnly){var r=[],n=0,k;this._aExpandedAfterSelectAll.sort(function(a,b){var A=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);if(A==B&&a.isDeepOne&&b.isDeepOne){return a.originalLevel-b.originalLevel;}return A-B;}.bind(this));var l=-1,N,e,i;for(i=0;i<this._aExpandedAfterSelectAll.length;i++){N=this._aExpandedAfterSelectAll[i];e=this._getRelatedServerIndex(N);if(e<=l&&!N.initiallyCollapsed){continue;}if(N.initiallyCollapsed){l=e;}else{l=e+N.magnitude;}r.push(N);n+=N.magnitude;}var f=function(N,b){if(r.indexOf(N)!==-1){n--;b.broken=true;}};for(k in this._mSelected){this._up(this._mSelected[k],f,true);}var I;var g=function(N,b){if(N.nodeState.collapsed||(N.nodeState.removed&&!N.nodeState.reinserted)||r.indexOf(N)!==-1){I=false;b.broken=true;}};for(k in this._mDeselected){I=true;this._up(this._mDeselected[k],g,true);if(I){n++;}}s=this.getLength()-n;}else{s=0;this._map(function(N,R,a,b,p){var P;if(N){if(N.nodeState.selected){s++;}}else if(N===undefined&&a==="serverIndex"){var j=true;for(var i=b-1;i>=0;i--){if(this._aNodeChanges[i]){P=this._aNodes[i];if(P.serverIndex+P.magnitude>=b&&this._aExpandedAfterSelectAll.indexOf(P)!==-1){j=false;break;}}}if(j){s++;}}}.bind(this));}}else{var h=this._getInvisibleSelectedNodes();s=Math.max(Object.keys(this._mSelected).length-h.length,0);}return s;};
d.prototype.getSelectedContexts=function(){return this._bReadOnly?this._indexGetSelectedContexts():this._mapGetSelectedContexts();};
d.prototype._indexGetSelectedContexts=function(){var n=this._getSelectedNodesInfo();return n.map(function(N){return N.node.context;});};
d.prototype._mapGetSelectedContexts=function(){var r=[];if(q.isEmptyObject(this._mSelected)){return r;}var m=function(n){if(n){if(n.nodeState.selected&&!n.isArtificial){r.push(n.context);}}};this._map(m);return r;};
d.prototype.setSelectionInterval=function(f,t){var m=this._clearSelection();var s=this._setSelectionInterval(f,t,true);var I={};var r=[];var a;for(var i=0;i<m.rowIndices.length;i++){a=m.rowIndices[i];I[a]=true;}for(i=0;i<s.rowIndices.length;i++){a=s.rowIndices[i];if(I[a]){delete I[a];}else{I[a]=true;}}for(a in I){if(I[a]){r.push(parseInt(a,10));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadKey:s.leadKey});};
d.prototype._setSelectionInterval=function(f,t,s){return this._bReadOnly?this._indexSetSelectionInterval(f,t,s):this._mapSetSelectionInterval(f,t,s);};
d.prototype._indexSetSelectionInterval=function(f,t,s){var n=Math.min(f,t),N=Math.max(f,t),a=[],b=[],o,e,i,p;s=!!s;for(i=n;i<=N;i++){e=this.findNode(i);if(e){if(e.nodeState.selected!==s){b.push(i);}if(e.key===this._sLeadSelectionKey){o=i;}this.setNodeSelection(e,s);a.push(e);}}p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){p.leadKey=a[a.length-1].key;p.leadIndex=N;}return p;};
d.prototype._mapSetSelectionInterval=function(f,t,s){var n=Math.min(f,t);var N=Math.max(f,t);var a=[];var b=[];var i=Math.abs(N-n)+1;var o;var e=-1;var m=function(g,r,I,h,P){e++;if(g){if(e>=n&&e<=N){if(g.nodeState.selected!==!!s){b.push(e);}if(g.key===this._sLeadSelectionKey){o=e;}this.setNodeSelection(g,!!s);a.push(g);if(a.length===i){r.broken=true;}}}}.bind(this);this._map(m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadKey=l.key;p.leadIndex=N;}return p;};
d.prototype.addSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,true);this._publishSelectionChanges(p);};
d.prototype.removeSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,false);this._publishSelectionChanges(p);};
d.prototype.selectAll=function(){this._bReadOnly?this._indexSelectAll():this._mapSelectAll();};
d.prototype._indexSelectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var p={rowIndices:[],oldIndex:-1,selectAll:true};var l=this.getLength(),i,n;for(i=0;i<l;i++){n=this.findNode(i);if(n&&!n.isArtificial){if(n.key===this._sLeadSelectionKey){p.oldIndex=i;}if(!n.nodeState.selected){p.rowIndices.push(i);}this.setNodeSelection(n,true);p.leadKey=n.key;p.leadIndex=i;}}this._publishSelectionChanges(p);};
d.prototype._mapSelectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.key===this._sLeadSelectionKey){p.oldIndex=n;}if(N){if(!N.isArtificial&&!N.nodeState.selected){p.rowIndices.push(n);}this.setNodeSelection(N,true);p.leadKey=N.key;p.leadIndex=n;}}}.bind(this));this._publishSelectionChanges(p);};
d.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};
d.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadKey){this._sLeadSelectionKey=p.leadKey;}else if(p.leadIndex===-1){this._sLeadSelectionKey=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};
d.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};
d.prototype.resetData=function(){O.prototype.resetData.apply(this,arguments);this._aNodes=[];this._aNodeCache=[];this._aCollapsed=[];this._aExpanded=[];this._aExpandedAfterSelectAll=[];this._mSelected={};this._mDeselected={};this._aAdded=[];this._aRemoved=[];this._aNodeChanges=[];this._aAllChangedNodes=[];this._bLengthFinal=false;this._iLowestServerLevel=null;this._bSelectAll=false;this._iLengthDelta=0;};
d.prototype._findNodeByContext=function(o){for(var i in this._aNodeCache){if(this._aNodeCache[i]&&this._aNodeCache[i].context==o){return{node:this._aNodeCache[i],index:parseInt(i,10)};}}var n=-1;var N;this._map(function(a,r,I,b,p){n++;if(a){if(a.context===o){N=a;r.broken=true;}}});return{node:N,index:n};};
d.prototype._getCorrectChangeGroup=function(k){if(!k){k=this.oModel.resolve(this.getPath(),this.getContext());}return this.oModel._resolveGroup(k).groupId;};
d.prototype.createEntry=function(p){var a=this.oModel.resolve(this.getPath(),this.getContext());var n;if(a){p=p||{};p.groupId=this._getCorrectChangeGroup(a);p.refreshAfterChange=false;n=this.oModel.createEntry(a,p);}else{q.sap.log.warning("ODataTreeBindingFlat: createEntry failed, as the binding path could not be resolved.");}return n;};
d.prototype.submitChanges=function(p){p=p||{};var a=this.oModel.resolve(this.getPath(),this.getContext()),o=this._optimizeChanges();if(!a){q.sap.log.warning("ODataTreeBindingFlat: submitChanges failed, because the binding-path could not be resolved.");return;}p.groupId=this._getCorrectChangeGroup(a);var f=p.success||q.noop;var b=p.error||q.noop;var r=false;p.success=function(D){f(D);var s=false;if(D.__batchResponses&&D.__batchResponses[0]&&D.__batchResponses[0].__changeResponses&&D.__batchResponses[0].__changeResponses.length>0){var e=D.__batchResponses[0].__changeResponses;for(var i=0;i<e.length;i++){var R=e[i];var S=parseInt(R.statusCode,10);if(S<200||S>299){s=true;break;}}if(s){}else if(this._bRestoreTreeStateAfterChange&&!r&&(!this.aApplicationFilters||this.aApplicationFilters.length===0)){this._restoreTreeState(o).catch(function(g){q.sap.log.error("ODataTreeBindingFlat - "+g.message,g.stack);this._refresh(true);}.bind(this));}else{this._refresh(true);}}else{q.sap.log.warning("ODataTreeBindingFlat.submitChanges - success: Batch-request response does not contain change response.");}}.bind(this);p.error=function(e){b(e);};this._generateSubmitData(o,function(e){q.sap.log.error("ODataTreeBindingFlat - Tree state restoration request failed. "+e.message,e.stack);r=true;});this.oModel.submitChanges(p);};
d.prototype._generateSubmitData=function(o,r){var R=o.removed,a=o.creationCancelled,A=o.added,m=o.moved,t=this;function s(n){var p=n.parent.context.getProperty(t.oTreeProperties["hierarchy-node-for"]);t.oModel.setProperty(t.oTreeProperties["hierarchy-parent-node-for"],p,n.context);}var b={groupId:this._getCorrectChangeGroup(),error:r};A.forEach(s);m.forEach(function(n){s(n);if(this._bRestoreTreeStateAfterChange&&(!this.aApplicationFilters||this.aApplicationFilters.length===0)){this._generatePreorderPositionRequest(n,b);this._generateSiblingsPositionRequest(n,b);}}.bind(this));R.forEach(function(n){this._generateDeleteRequest(n);q.sap.log.debug("ODataTreeBindingFlat: DELETE "+n.key);}.bind(this));a.forEach(function(n){this._generateDeleteRequest(n);}.bind(this));};
d.prototype._generatePreorderPositionRequest=function(n,p){var g,k,K,u,s,e,f=[],S=this.aSorters||[],i;if(p){g=p.groupId||this.sGroupId;s=p.success;e=p.error;}if(this.aApplicationFilters){f=f.concat(this.aApplicationFilters);}for(i=this._aTreeKeyProperties.length-1;i>=0;i--){k=this._aTreeKeyProperties[i];if(!K){K=k;}else{K+=","+k;}f.push(new F(k,"EQ",n.context.getProperty(k)));}f.push(new F(this.oTreeProperties["hierarchy-level-for"],"LE",this.getNumberOfExpandedLevels()));u=q.extend({},this.mParameters);u.select=K+","+this.oTreeProperties["hierarchy-node-descendant-count-for"]+","+this.oTreeProperties["hierarchy-drill-state-for"]+","+this.oTreeProperties["hierarchy-preorder-rank-for"];this.oModel.read(this.getPath(),{context:this.oContext,urlParameters:this.oModel.createCustomParams(u),filters:[new F({filters:f,and:true})],sorters:S,groupId:g,success:s,error:e});};
d.prototype._generateSiblingsPositionRequest=function(n,p){var g,u,s,e;if(p){g=p.groupId||this.sGroupId;s=p.success;e=p.error;}u=q.extend({},this.mParameters);u.select=this.oTreeProperties["hierarchy-sibling-rank-for"];this.oModel.read(n.context.getPath(),{urlParameters:this.oModel.createCustomParams(u),groupId:g,success:s,error:e});};
d.prototype._nodeIsOnTopLevel=function(n){if(n&&n.serverIndex>=0){var p=n.parent==null;if(p){if(n.originalLevel==this._iLowestServerLevel){return true;}else{return false;}}}else{q.sap.log.warning("ODataTreeBindingFlat.nodeIsOnTopLevel: Node is not defined or not a server-indexed node.");}};
d.prototype._generateDeleteRequest=function(n){var o=n.context;if(n.nodeState.added){this.oModel.deleteCreatedEntry(o);}else{var D=this.oModel.remove(o.getPath(),{groupId:this._getCorrectChangeGroup(),refreshAfterChange:false});return D;}};
d.prototype._filterChangeForServerSections=function(o){var a={};a.removed=o.removed.filter(function(r){return!r.isDeepOne;});a.added=o.added.filter(function(A){return!A.isDeepOne;});o.moved.forEach(function(m){if(!m.newIsDeepOne){a.added.push(m);}if(!m.isDeepOne){a.removed.push(m);}});return a;};
d.prototype._filterChangesForDeepSections=function(o){var m={};o.removed.forEach(function(r){var p;if(r.isDeepOne){p=r.parent;if(!m[p.key]){m[p.key]={added:[],removed:[]};}m[p.key].removed.push(r);}});o.added.forEach(function(a){var p;if(a.isDeepOne){p=a.parent;if(!m[p.key]){m[p.key]={added:[],removed:[]};}m[p.key].added.push(a);}});o.moved.forEach(function(M){var p;if(M.newIsDeepOne){p=M.parent;if(!m[p.key]){m[p.key]={added:[],removed:[]};}m[p.key].added.push(M);}if(M.isDeepOne){p=M.originalParent;if(!m[p.key]){m[p.key]={added:[],removed:[]};}m[p.key].removed.push(M);}});return m;};
d.prototype._optimizeOptimizedChanges=function(o){var A,t=this;A=o.added.slice();A.sort(function(a,b){var I=a.newIsDeepOne!==undefined?a.newIsDeepOne:a.isDeepOne,e=b.newIsDeepOne!==undefined?b.newIsDeepOne:b.isDeepOne;if(I&&e){return 0;}if(I){return 1;}if(e){return-1;}return a.context.getProperty(t.oTreeProperties["hierarchy-preorder-rank-for"])-b.context.getProperty(t.oTreeProperties["hierarchy-preorder-rank-for"]);});var i=-1;A=A.filter(function(n,a){if(n.newIsDeepOne!==undefined?n.newIsDeepOne:n.isDeepOne){return true;}if(a<=i){return false;}var m=n.context.getProperty(t.oTreeProperties["hierarchy-node-descendant-count-for"]);if(m){i=a+m;}return true;});return{added:A,removed:o.removed,moved:o.moved};};
d.prototype._updateNodeInfoAfterSave=function(n){var i=n.context.getProperty(this.oTreeProperties["hierarchy-preorder-rank-for"])===undefined;if(n.isDeepOne===undefined){n.isDeepOne=i;}else{n.newIsDeepOne=i;}var I=n.context.getProperty(this.oTreeProperties["hierarchy-drill-state-for"])==="collapsed";if(n.initiallyCollapsed===undefined){n.initiallyCollapsed=I;}else{n.newInitiallyCollapsed=I;}};
d.prototype._requestExtraInfoForAddedNodes=function(a){var P=[],t=this;a.forEach(function(n){var p=new Promise(function(r,b){t._generatePreorderPositionRequest(n,{success:r,error:b});});P.push(p);});P=P.map(function(p){return p.then(function(r){return{responseData:r};},function(e){return{error:e};});});return Promise.all(P).then(function(D){var A=0;D.forEach(function(o){if(o.error){if(o.error.statusCode===0){A++;}else{throw new Error("Tree state restoration request failed. Complete or partial tree state might get lost. Error: "+(o.error.message.value||o.error.message));}}});return A===0;});};
d.prototype._restoreTreeState=function(o){var t=this;o=o||{creationCancelled:[],added:[],removed:[],moved:[]};this.fireDataRequested();return this._requestExtraInfoForAddedNodes(o.added).then(function(n){if(n){return t._executeRestoreTreeState(o).then(function(D){if(D){t._fireRefresh({reason:C.Refresh});t.fireDataReceived({data:D});return D;}});}});};
d.prototype._executeRestoreTreeState=function(o){var a,s,S,D,b,m,p,i,j,k,l,e,f,t=this;o.added.forEach(this._updateNodeInfoAfterSave.bind(this));o.moved.forEach(this._updateNodeInfoAfterSave.bind(this));p=[];S=this._collectServerSections(this._aNodes);o=this._optimizeOptimizedChanges(o);e=this._filterChangeForServerSections(o);this._adaptSections(S,e);for(i=0;i<S.length;i++){s=S[i];p.push(this._restoreServerIndexNodes(s.iSkip,s.iTop,i===0));}var g=this._collectDeepNodes();f=this._filterChangesForDeepSections(o);for(j=0;j<g.length;j++){D=g[j];if(f){e=f[D.oParentNode.key];if(e){this._adaptSections(D.aChildSections,e,{indexName:"positionInParent",ignoreMagnitude:true});}}for(k=0;k<D.aChildSections.length;k++){b=D.aChildSections[k];p.push(this._restoreChildren(D.oParentNode,b.iSkip,b.iTop));}}m={};for(l=0;l<this._aCollapsed.length;l++){m[this._aCollapsed[l].key]=true;}a=this._aCollapsed.length;this.resetData();function r(){if(a>0){t._map(function(n,R){if(n&&m[n.key]){t.collapse(n,true);a--;if(a===0){R.broken=true;}}});}}p=p.map(function(h){return h.then(function(R){return{responseData:R};},function(E){return{error:E};});});return Promise.all(p).then(function(h){var A=0;h.forEach(function(n){if(n.error){if(n.error.statusCode===0){A++;}else{throw new Error("Tree state restoration request failed. Complete or partial tree state might get lost. Error: "+(n.error.message.value||n.error.message));}}});if(A<h.length){r();return h;}});};
d.prototype._collectServerSections=function(n){var s=[];var S;for(var i=0;i<n.length;i++){if(n[i]!==undefined){if(!S){S={iSkip:i,iTop:1};s.push(S);}else{S.iTop++;}}else{S=null;}}return s;};
d.prototype._adaptSections=function(s,o,e){var r=o.removed||[],A=o.added||[],I=(e&&e.indexName)||"serverIndex",N,S,f,R,g,h=0,M,p,P,t,u,v,w,x=0,y,z,B=[];for(var l=A.length-1;l>=0;l--){N=A[l];if(N.newIsDeepOne!==undefined?N.newIsDeepOne:N.isDeepOne){z=this.oTreeProperties["hierarchy-sibling-rank-for"];}else{z=this.oTreeProperties["hierarchy-preorder-rank-for"];if(N.newInitiallyCollapsed!==undefined?!N.newInitiallyCollapsed:!N.initiallyCollapsed){M=N.context.getProperty(this.oTreeProperties["hierarchy-node-descendant-count-for"]);}}p=N.context.getProperty(z);if(p===undefined){q.sap.log.warning("ODataTreeBindingFlat","Missing "+z+" value for node "+N.key);break;}B.push({position:p,magnitude:M||0,assignedToSection:false});}for(var i=0;i<s.length;i++){S=s[i];w=x;P=t;t=0;y=0;for(var j=r.length-1;j>=0;j--){N=r[j];p=N[I];if(p>=S.iSkip&&p<=S.iSkip+S.iTop){if(I==="serverIndex"){h++;}M=(e&&e.ignoreMagnitude)?0:this._getInitialMagnitude(N);g=(1+M);R=(S.iSkip+S.iTop)-p-g;if(R>0){y-=g;}else{y-=(S.iSkip+S.iTop)-p;if(R<0){t=p+g;}}w-=g;}}if(S.iSkip<=P){u=S.iSkip-P;y+=u;if(S.iTop+y<0){t=P;}}S.iSkip+=x;S.iTop+=y;if(S.iTop>0){x=0;y=0;for(var k=0;k<B.length;k++){f=B[k];p=f.position;v=(e&&e.ignoreMagnitude)?1:f.magnitude+1;if(p>=S.iSkip&&p<=S.iSkip+S.iTop){y+=v;B[k].assignedToSection=true;}else if(p<S.iSkip){x+=v;}}S.iSkip+=x;S.iTop+=y;S.iTop+=h;}if(S.iTop<=0){s.splice(i,1);i--;}x=w;}for(var m=0;m<B.length;m++){f=B[m];v=(e&&e.ignoreMagnitude)?1:f.magnitude+1;if(!f.assignedToSection){s.push({iSkip:f.position,iTop:v});}}s.sort(function(a,b){return a.iSkip-b.iSkip;});for(var n=0;n<s.length;n++){if(n+1<s.length){S=s[n];var D=s[n+1];if(S.iSkip+S.iTop===D.iSkip){S.iTop+=D.iTop;s.splice(n+1,1);n--;}}}};
d.prototype._optimizeChanges=function(){var r=[],e=[],A=[],m=[];var I=false;var f=function(N,b){if(N.nodeState.removed&&!N.nodeState.reinserted){I=true;b.broken=true;}};var p=[];var t=function(N){if((N.isDeepOne||N.serverIndex>=0)&&p.indexOf(N)==-1){p.push(N);}if(N.nodeState.added){e.push(N);}};this._aAllChangedNodes.forEach(function(N){I=false;this._up(N,f,false);if(I){t(N);}else{if(N.nodeState.removed&&!N.nodeState.reinserted){t(N);}else if(N.nodeState.added){A.push(N);}else{m.push(N);}}}.bind(this));p.sort(function(a,b){var g=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);if(g==B&&a.isDeepOne&&b.isDeepOne){if(a.parent===b.parent){return a.positionInParent-b.positionInParent;}else{return a.originalLevel-b.originalLevel;}}return g-B;}.bind(this));var n=function(D){var b=false;this._up(D,function(P,B){if(P.nodeState.removed&&!P.nodeState.reinserted){b=true;B.broken=true;}},true);return b;}.bind(this);for(var i=0;i<p.length;i++){var D=p[i];if(!n(D)){r.push(D);}}return{removed:r,creationCancelled:e,added:A,moved:m};};
d.prototype._collectDeepNodes=function(){var D=[],t=this;this._map(function(n){if(n&&n.nodeState.expanded&&(n.initiallyCollapsed||n.isDeepOne)){D.push({oParentNode:n,aChildSections:t._collectServerSections(n.children)});}});return D;};
d.prototype._trackChangedNode=function(n){if(this._aAllChangedNodes.indexOf(n)==-1){this._aAllChangedNodes.push(n);}};
d.prototype.addContexts=function(p,v){var n=this._findNodeByContext(p),N=n.node,m=this.getModel(),o,a;if(N){this._bReadOnly=false;if(N.nodeState&&N.nodeState.isLeaf){N.nodeState.isLeaf=false;N.nodeState.collapsed=true;}if(!q.isArray(v)){if(v instanceof sap.ui.model.Context){v=[v];}else{q.sap.log.warning("ODataTreeBinding.addContexts(): The child node argument is not of type sap.ui.model.Context.");}}var b=function(f){return function(){return[f];};};v=v.slice();v.reverse();for(var j=0;j<v.length;j++){var a=v[j];if(!a||!(a instanceof sap.ui.model.Context)){q.sap.log.warning("ODataTreeBindingFlat.addContexts(): no valid child context given!");return;}var o=this._mSubtreeHandles[a.getPath()];this._ensureHierarchyNodeIDForContext(a);if(o&&o._isRemovedSubtree){q.sap.log.info("ODataTreeBindingFlat.addContexts(): Existing context added '"+a.getPath()+"'");o._oNewParentNode=N;o._oSubtreeRoot.nodeState.reinserted=true;o._oSubtreeRoot.originalParent=o._oSubtreeRoot.originalParent||o._oSubtreeRoot.parent;o._oSubtreeRoot.parent=N;o._oSubtreeRoot.containingSubtreeHandle=o;a=o.getContext();this._trackChangedNode(o._oSubtreeRoot);this._mSubtreeHandles[a.getPath()];}else{q.sap.log.info("ODataTreeBindingFlat.addContexts(): Newly created context added.");this._ensureHierarchyNodeIDForContext(a);var f={context:a,key:m.getKey(a),parent:N,nodeState:{isLeaf:true,collapsed:false,expanded:false,selected:false,added:true},addedSubtrees:[],children:[],magnitude:0};this._trackChangedNode(f);this._aAdded.push(f);o={_getSubtree:b(f),_oSubtreeRoot:null,_oNewParentNode:N};}o._iContainingServerIndex=N.serverIndex||N.containingServerIndex;N.addedSubtrees.unshift(o);if(N.serverIndex!==undefined){this._aNodeChanges[N.serverIndex]=true;}}this._aNodeCache=[];this._cleanTreeStateMaps();this._fireChange({reason:C.Add});}else{q.sap.log.warning("The given parent context could not be found in the tree. No new sub-nodes were added!");}};
d.prototype._ensureHierarchyNodeIDForContext=function(o){if(o){var n=o.getProperty(this.oTreeProperties["hierarchy-node-for"]);if(o.bCreated&&!n){this.oModel.setProperty(this.oTreeProperties["hierarchy-node-for"],q.sap.uid(),o);}}};
d.prototype.removeContext=function(o){var t=this;var n=this._findNodeByContext(o);var N=n.node;var i=n.index;if(N){this._bReadOnly=false;N.nodeState.removed=true;this._aRemoved.push(N);this._trackChangedNode(N);if(N.serverIndex!==undefined){this._aNodeChanges[N.serverIndex]=true;}if(N.containingSubtreeHandle&&N.parent!=null){var a=N.parent.addedSubtrees.indexOf(N.containingSubtreeHandle);if(a!=-1){N.parent.addedSubtrees.splice(a,1);N.nodeState.reinserted=false;N.parent=null;}}this._aNodeCache=[];this.setNodeSelection(N,false);this._cleanUpSelection(true);this._cleanTreeStateMaps();this._fireChange({reason:C.Remove});this._mSubtreeHandles[o.getPath()]={_removedFromVisualIndex:i,_isRemovedSubtree:true,_oSubtreeRoot:N,_getSubtree:function(){if(N.serverIndex!=undefined&&!N.initiallyCollapsed){return t._aNodes.slice(N.serverIndex,N.serverIndex+N.magnitude+1);}else{return N;}},getContext:function(){return o;},_restore:function(){N.nodeState.removed=false;var b=t._aRemoved.indexOf(N);if(b!=-1){t._aRemoved.splice(b,1);}this._aNodeCache=[];t._cleanTreeStateMaps();t._fireChange({reason:C.Add});}};return o;}else{q.sap.log.warning("ODataTreeBinding.removeContexts(): The given context is not part of the tree. Was it removed already?");}};
d.prototype._getRelatedServerIndex=function(n){if(n.serverIndex===undefined){return n.containingServerIndex;}else{return n.serverIndex;}};
d.prototype.getNodeInfoByRowIndex=function(r){var i=0,e=0,n,t,v=-1;while(i<this._aCollapsed.length||e<this._aExpanded.length){if(this._aCollapsed[i]&&this._aExpanded[e]){if(this._getRelatedServerIndex(this._aCollapsed[i])>this._getRelatedServerIndex(this._aExpanded[e])){n=this._aExpanded[e];e++;t=false;}else{n=this._aCollapsed[i];i++;t=true;}}else if(this._aCollapsed[i]){n=this._aCollapsed[i];i++;t=true;}else{n=this._aExpanded[e];e++;t=false;}if(r<=this._getRelatedServerIndex(n)){break;}if(t){if(!n.isDeepOne&&!n.initiallyCollapsed&&n.serverIndex>v){r+=n.magnitude;v=n.serverIndex+n.magnitude;}}else{if(n.serverIndex>v){if(!n.isDeepOne&&n.initiallyCollapsed){r-=n.magnitude;}if(r<=n.serverIndex){return this._calcDirectIndex(n,r+n.magnitude-n.serverIndex-1);}}}}return{index:r};};
d.prototype._calcDirectIndex=function(n,a){var i,m,o;for(i=0;i<n.children.length;i++){o=n.children[i];if(a===0){return{parent:n,childIndex:i};}m=o?o.magnitude:0;a--;if(!o||o.nodeState.collapsed){continue;}if(a<m){return this._calcDirectIndex(o,a);}else{a-=m;}}};
d.prototype.getRowIndexByNode=function(n){var D=0;var o;var i;if(n.isDeepOne){while(n.parent){D+=n.positionInParent+1;for(i=0;i<n.positionInParent;i++){o=n.parent.children[i];if(o&&o.nodeState.expanded){D+=o.magnitude;}}n=n.parent;}}return this._calcIndexDelta(n.serverIndex)+n.serverIndex+D;};
d.prototype._getSelectedNodesInfo=function(){var n=[];if(q.isEmptyObject(this._mSelected)){return n;}var i=true;var f=function(N,b){if(N.nodeState.collapsed||(N.nodeState.removed&&!N.nodeState.reinserted)){i=false;b.broken=true;}};for(var k in this._mSelected){var s=this._mSelected[k];i=true;this._up(s,f,false);if(i){n.push({node:s,rowIndex:this.getRowIndexByNode(s)});}}n.sort(function(N,o){return N.rowIndex-o.rowIndex;});return n;};
d.prototype._calcIndexDelta=function(e){var m={};this._aCollapsed.forEach(function(n){if(n.serverIndex>=0&&n.serverIndex<e&&!n.isDeepOne&&!n.initiallyCollapsed){m[n.serverIndex]=n.magnitude;}});var l=0;var a=0;for(var i=0;i<this._aCollapsed.length;i++){var o=this._aCollapsed[i];if(this._getRelatedServerIndex(o)>=e){break;}if(!o.isDeepOne){if(o.serverIndex>=l&&!o.initiallyCollapsed){a-=o.magnitude;l=o.serverIndex+o.magnitude;}else{}}else{}}var E=0;var I=function(n){var f=false;var g=n.serverIndex||n.containingServerIndex;for(var j in m){if(g>j&&g<j+m[j]){f=true;break;}}return f;};for(i=0;i<this._aExpanded.length;i++){var b=this._aExpanded[i];if(this._getRelatedServerIndex(b)>=e){break;}if(b.isDeepOne){var p=b.parent;var y=false;while(p){if(p.nodeState.collapsed){y=true;break;}p=p.parent;}var f=I(b);if(!y&&!f){E+=b.children.length;}}else if(b.initiallyCollapsed){var f=I(b);if(!f){E+=b.children.length;}}}return E+a;};
d.prototype._sortNodes=function(n){var s=function(a,b){var A=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);return A-B;}.bind(this);n.sort(s);};
d.prototype.attachSelectionChanged=function(D,f,l){this.attachEvent("selectionChanged",D,f,l);return this;};
d.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};
d.prototype.fireSelectionChanged=function(a){this.fireEvent("selectionChanged",a);return this;};
d.prototype.getRootContexts=function(){};
d.prototype.getNodeContexts=function(){};
return d;},true);
sap.ui.predefine('sap/ui/model/odata/ODataUtils',['jquery.sap.global','./Filter','sap/ui/model/Sorter','sap/ui/core/format/DateFormat'],function(q,O,S,D){"use strict";var r=/^([-+]?)0*(\d+)(\.\d+|)$/,a=/\.$/,b=/0+$/;var c=function(){};
c.createSortParams=function(j){var m;if(!j||j.length==0){return;}m="$orderby=";for(var i=0;i<j.length;i++){var o=j[i];if(o instanceof S){m+=o.sPath;m+=o.bDescending?"%20desc":"%20asc";m+=",";}else{q.sap.log.error("Trying to use "+o+" as a Sorter, but it is a "+typeof o);}}m=m.slice(0,-1);return m;};
c.createFilterParams=function(F,m,E){if(!F||F.length==0){return;}return"$filter="+this._createFilterParams(F,m,E);};
c._createFilterParams=function(F,m,E){var o;if(!F||F.length==0){return;}var t={},u=0,v,o="",w=0,x=this;q.each(F,function(j,i){if(i.sPath){v=t[i.sPath];if(!v){v=t[i.sPath]=[];u++;}}else{v=t["__multiFilter"];if(!v){v=t["__multiFilter"]=[];u++;}}v.push(i);});q.each(t,function(P,v){if(v.length>1){o+='(';}q.each(v,function(i,j){if(j instanceof O){if(j.aValues.length>1){o+='(';}q.each(j.aValues,function(i,y){if(i>0){if(j.bAND){o+="%20and%20";}else{o+="%20or%20";}}o=x._createFilterSegment(j.sPath,m,E,y.operator,y.value1,y.value2,o,j.bCaseSensitive);});if(j.aValues.length>1){o+=')';}}else if(j._bMultiFilter){o+=x._resolveMultiFilter(j,m,E);}else{o=x._createFilterSegment(j.sPath,m,E,j.sOperator,j.oValue1,j.oValue2,o,j.bCaseSensitive);}if(i<v.length-1){o+="%20or%20";}});if(v.length>1){o+=')';}if(w<u-1){o+="%20and%20";}w++;});return o;};
c._createUrlParamsArray=function(P){var u,t=q.type(P),i;if(t==="array"){return P;}u=[];if(t==="object"){i=this._encodeURLParameters(P);if(i){u.push(i);}}else if(t==="string"){if(P){u.push(P);}}return u;};
c._encodeURLParameters=function(P){if(!P){return"";}var u=[];q.each(P,function(i,v){if(q.type(v)==="string"){v=encodeURIComponent(v);}i=q.sap.startsWith(i,'$')?i:encodeURIComponent(i);u.push(i+"="+v);});return u.join("&");};
c.setOrigin=function(i,P){var o,j,C;if(!i||!P||i.indexOf(";mo")>0){return i;}if(typeof P=="string"){o=P;}else{o=P.alias;if(!o){j=P.system;C=P.client;if(!j||!C){q.sap.log.warning("ODataUtils.setOrigin: No Client or System ID given for Origin");return i;}o="sid("+j+"."+C+")";}}var u=i.split("?");var B=u[0];var U=u[1]?"?"+u[1]:"";var t="";if(B[B.length-1]==="/"){B=B.substring(0,B.length-1);t="/";}var m=/(\/[^\/]+)$/g;var v=/(;o=[^\/;]+)/g;var L=B.match(m)[0];var w=L.match(v);var F=w?w[0]:null;if(F){if(P.force){var x=L.replace(F,";o="+o);B=B.replace(L,x);return B+t+U;}return i;}B=B+";o="+o+t;return B+U;};
c.setAnnotationOrigin=function(A,P){var F;var i=A.indexOf("/Annotations(");if(i===-1){i=A.indexOf("/Annotations%28");}if(i>=0){if(A.indexOf("/$value",i)===-1){q.sap.log.warning("ODataUtils.setAnnotationOrigin: Annotation url is missing $value segment.");F=A;}else{var j=A.substring(0,i);var m=A.substring(i,A.length);var o=c.setOrigin(j,P);F=o+m;}}else{F=A.replace(P.preOriginBaseUri,P.postOriginBaseUri);}return F;};
c._resolveMultiFilter=function(m,M,E){var t=this,F=m.aFilters,j="";if(F){j+="(";q.each(F,function(i,o){if(o._bMultiFilter){j+=t._resolveMultiFilter(o,M,E);}else if(o.sPath){j+=t._createFilterSegment(o.sPath,M,E,o.sOperator,o.oValue1,o.oValue2,"",o.bCaseSensitive);}if(i<(F.length-1)){if(m.bAnd){j+="%20and%20";}else{j+="%20or%20";}}});j+=")";}return j;};
c._createFilterSegment=function(P,m,E,o,v,V,F,C){var i,t;if(C===undefined){C=true;}if(E){i=m._getPropertyMetadata(E,P);t=i&&i.type;}if(t){v=this.formatValue(v,t,C);V=(V!=null)?this.formatValue(V,t,C):null;}else{}if(v){v=q.sap.encodeURL(String(v));}if(V){V=q.sap.encodeURL(String(V));}if(!C&&t==="Edm.String"){P="toupper("+P+")";}switch(o){case"EQ":case"NE":case"GT":case"GE":case"LT":case"LE":F+=P+"%20"+o.toLowerCase()+"%20"+v;break;case"BT":F+="("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";break;case"Contains":F+="substringof("+v+","+P+")";break;case"StartsWith":F+="startswith("+P+","+v+")";break;case"EndsWith":F+="endswith("+P+","+v+")";break;default:F+="true";}return F;};
c.formatValue=function(v,t,C){if(C===undefined){C=true;}if(!this.oDateTimeFormat){this.oDateTimeFormat=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss''"});this.oDateTimeFormatMs=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss.SSS''"});this.oDateTimeOffsetFormat=D.getDateInstance({pattern:"'datetimeoffset'''yyyy-MM-dd'T'HH:mm:ss'Z'''"});this.oTimeFormat=D.getTimeInstance({pattern:"'time''PT'HH'H'mm'M'ss'S'''"});}if(v===null||v===undefined){return"null";}var V;switch(t){case"Edm.String":v=C?v:v.toUpperCase();V="'"+String(v).replace(/'/g,"''")+"'";break;case"Edm.Time":if(typeof v==="object"){V=this.oTimeFormat.format(new Date(v.ms),true);}else{V="time'"+v+"'";}break;case"Edm.DateTime":var o=new Date(v);if(o.getMilliseconds()>0){V=this.oDateTimeFormatMs.format(o,true);}else{V=this.oDateTimeFormat.format(o,true);}break;case"Edm.DateTimeOffset":var o=new Date(v);V=this.oDateTimeOffsetFormat.format(o,true);break;case"Edm.Guid":V="guid'"+v+"'";break;case"Edm.Decimal":V=v+"m";break;case"Edm.Int64":V=v+"l";break;case"Edm.Double":V=v+"d";break;case"Edm.Float":case"Edm.Single":V=v+"f";break;case"Edm.Binary":V="binary'"+v+"'";break;default:V=String(v);break;}return V;};
function s(v,V){if(v===V){return 0;}if(v===null||V===null||v===undefined||V===undefined){return NaN;}return v>V?1:-1;}
function p(v){var m;if(typeof v!=="string"){return undefined;}m=r.exec(v);if(!m){return undefined;}return{sign:m[1]==="-"?-1:1,integerLength:m[2].length,abs:m[2]+m[3].replace(b,"").replace(a,"")};}
function d(v,V){var o,i,R;if(v===V){return 0;}o=p(v);i=p(V);if(!o||!i){return NaN;}if(o.sign!==i.sign){return o.sign>i.sign?1:-1;}R=s(o.integerLength,i.integerLength)||s(o.abs,i.abs);return o.sign*R;}
var e=/^PT(\d\d)H(\d\d)M(\d\d)S$/;
function f(v){if(typeof v==="string"&&e.test(v)){v=parseInt(RegExp.$1,10)*3600000+parseInt(RegExp.$2,10)*60000+parseInt(RegExp.$3,10)*1000;}if(v instanceof Date){return v.getTime();}if(v&&v.__edmType==="Edm.Time"){return v.ms;}return v;}
c.compare=function(v,V,A){return A?d(v,V):s(f(v),f(V));};
c.getComparator=function(E){switch(E){case"Edm.Date":case"Edm.DateTime":case"Edm.DateTimeOffset":case"Edm.Time":return c.compare;case"Edm.Decimal":case"Edm.Int64":return d;default:return s;}};
var g=/([(=,])('.*?')([,)])/g,h=/[MLDF](?=[,)](?:[^']*'[^']*')*[^']*$)/g,k=/([(=,])(X')/g,n=function(v,i,j,m){return i+encodeURIComponent(decodeURIComponent(j))+m;},N=function(v){return v.toLowerCase();},l=function(v,i){return i+"binary'";};
c._normalizeKey=function(K){return K.replace(g,n).replace(h,N).replace(k,l);};
return c;},true);
sap.ui.predefine('sap/ui/model/odata/OperationMode',function(){"use strict";var O={Default:"Default",Server:"Server",Client:"Client",Auto:"Auto"};return O;},true);
sap.ui.predefine('sap/ui/model/odata/UpdateMethod',function(){"use strict";var U={Merge:"MERGE",Put:"PUT"};return U;},true);
sap.ui.predefine('sap/ui/model/odata/_AnnotationHelperBasics',['jquery.sap.global','sap/ui/base/BindingParser'],function(q,B){'use strict';var a="sap.ui.model.odata.AnnotationHelper",r=/[\\\{\}:]/,b,d=/^(\/dataServices\/schema\/\d+\/entityContainer\/\d+\/entitySet\/\d+)(?:\/|$)/,p=[a],P=a+"/followPath",f=/^(\/dataServices\/schema\/\d+\/(?:complex|entity)Type\/\d+)(?:\/|$)/,u={"Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Float":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.Single":"sap.ui.model.odata.type.Single","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time"};b={descend:function(o,v,e){var t=q.extend({},o);b.expectType(o,typeof v==="number"?"array":"object");t.path=o.path+"/"+v;t.value=o.value[v];if(e===true){t.asExpression=true;}else if(e){b.expectType(t,e);}return t;},error:function(o,m,c){m=o.path+": "+m;q.sap.log.error(m,b.toErrorString(o.value),c||a);throw new SyntaxError(m);},expectType:function(o,e){var E,v=o.value;if(e==="array"){E=!Array.isArray(v);}else{E=typeof v!==e||v===null||Array.isArray(v);}if(E){b.error(o,"Expected "+e);}},followPath:function(i,R){var A,s,c,I,m=i.getModel(),e,o={associationSetEnd:undefined,navigationAfterMultiple:false,isMultiple:false,navigationProperties:[],resolvedPath:undefined},S,t;q.sap.measure.average(P,"",p);s=b.getPath(R);c=s!==undefined&&b.getStartingPoint(i,s);if(!c){q.sap.measure.end(P);return undefined;}e=s.split("/");while(s&&e.length&&c){S=e[0];I=S.indexOf("@");if(I===0){c+="/"+S.slice(1);e.shift();continue;}t=m.getObject(c);A=m.getODataAssociationEnd(t,S);if(A){o.associationSetEnd=m.getODataAssociationSetEnd(t,S);o.navigationProperties.push(S);if(o.isMultiple){o.navigationAfterMultiple=true;}o.isMultiple=A.multiplicity==="*";c=m.getODataEntityType(A.type,true);e.shift();continue;}c=m.getODataProperty(t,e,true);}o.resolvedPath=c;q.sap.measure.end(P);return o;},getPath:function(R){if(R){if(R.hasOwnProperty("AnnotationPath")){return R.AnnotationPath;}if(R.hasOwnProperty("Path")){return R.Path;}if(R.hasOwnProperty("PropertyPath")){return R.PropertyPath;}if(R.hasOwnProperty("NavigationPropertyPath")){return R.NavigationPropertyPath;}}return undefined;},getStartingPoint:function(i,s){var e,m=f.exec(i.getPath()),M;if(m){return m[1];}m=d.exec(i.getPath());if(m){if(!s){return m[1];}M=i.getModel();e=M.getObject(m[1]);return M.getODataEntityType(e.entityType,true);}return undefined;},property:function(o,v,e){return b.descend(o,v,e).value;},resultToString:function(R,e,w){var v=R.value;function c(A){var C,s;A=A&&!R.ignoreTypeInPath&&R.type;if(A||r.test(v)){s="{path:"+b.toJSON(v);if(A){s+=",type:'"+u[R.type]+"'";C=b.toJSON(R.constraints);if(C&&C!=="{}"){s+=",constraints:"+C;}}return s+"}";}return"{"+v+"}";}function g(R){switch(R.type){case"Edm.Boolean":case"Edm.Double":case"Edm.Int32":return String(R.value);default:return b.toJSON(R.value);}}switch(R.result){case"binding":return(e?"$":"")+c(w);case"composite":if(e){throw new Error("Trying to embed a composite binding into an expression binding");}return v;case"constant":if(R.type==="edm:Null"){return e?"null":null;}if(e){return g(R);}return typeof v==="string"?B.complexParser.escape(v):String(v);case"expression":return e?v:"{="+v+"}";}},toErrorString:function(v){var j;if(typeof v!=="function"){try{j=b.toJSON(v);if(j!==undefined&&j!=="null"){return j;}}catch(e){}}return String(v);},toJSON:function(v){var s,e=false,R="",i,c;s=JSON.stringify(v);if(s===undefined){return undefined;}for(i=0;i<s.length;i+=1){switch(c=s.charAt(i)){case"'":R+="\\'";break;case'"':if(e){R+=c;e=false;}else{R+="'";}break;case"\\":if(e){R+="\\\\";}e=!e;break;default:if(e){R+="\\";e=false;}R+=c;}}return R;}};return b;},false);
sap.ui.predefine('sap/ui/model/odata/_AnnotationHelperExpression',['jquery.sap.global','./_AnnotationHelperBasics','sap/ui/base/BindingParser','sap/ui/base/ManagedObject','sap/ui/core/format/DateFormat','sap/ui/model/odata/ODataUtils'],function(q,B,a,M,D,O){'use strict';var A="sap.ui.model.odata.AnnotationHelper",d="\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\\d|3[01])",s="[-+]?\\d+(?:\\.\\d+)?",m="9007199254740991",b="-"+m,p=[A],P=A+"/getExpression",t="(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d(\\.\\d{1,12})?)?",E={Bool:/^true$|^false$/i,Float:new RegExp("^"+s+"(?:[eE][-+]?\\d+)?$|^NaN$|^-INF$|^INF$"),Date:new RegExp("^"+d+"$"),DateTimeOffset:new RegExp("^"+d+"T"+t+"(?:Z|[-+](?:0\\d|1[0-3]):[0-5]\\d|[-+]14:00)$","i"),Decimal:new RegExp("^"+s+"$"),Guid:/^[A-F0-9]{8}-(?:[A-F0-9]{4}-){3}[A-F0-9]{12}$/i,Int:/^[-+]?\d{1,19}$/,TimeOfDay:new RegExp("^"+t+"$")},c,r=/^\{@i18n>[^\\\{\}:]+\}$/,f=/^\d+$/,o={And:"&&",Eq:"===",Ge:">=",Gt:">",Le:"<=",Lt:"<",Ne:"!==",Not:"!",Or:"||"},g=/^(\/dataServices\/schema\/\d+)(?:\/|$)/,T={"Edm.Boolean":"boolean","Edm.Byte":"number","Edm.Date":"date","Edm.DateTime":"datetime","Edm.DateTimeOffset":"datetime","Edm.Decimal":"decimal","Edm.Double":"number","Edm.Float":"number","Edm.Guid":"string","Edm.Int16":"number","Edm.Int32":"number","Edm.Int64":"decimal","Edm.SByte":"number","Edm.Single":"number","Edm.String":"string","Edm.Time":"time","Edm.TimeOfDay":"time"},h={Bool:"Edm.Boolean",Float:"Edm.Double",Date:"Edm.Date",DateTimeOffset:"Edm.DateTimeOffset",Decimal:"Edm.Decimal",Guid:"Edm.Guid",Int:"Edm.Int64",String:"Edm.String",TimeOfDay:"Edm.TimeOfDay"},j={"boolean":false,"date":true,"datetime":true,"decimal":true,"number":false,"string":false,"time":true};c={adjustOperands:function(e,i){if(e.result!=="constant"&&e.category==="number"&&i.result==="constant"&&i.type==="Edm.Int64"){i.category="number";}if(e.result!=="constant"&&e.category==="decimal"&&i.result==="constant"&&i.type==="Edm.Int32"){i.category="decimal";i.type=e.type;}if(e.result==="constant"&&e.category==="date"&&i.result!=="constant"&&i.category==="datetime"){i.category="date";}},apply:function(i,e){var n=B.descend(e,"Name","string"),k=B.descend(e,"Parameters");switch(n.value){case"odata.concat":return c.concat(i,k);case"odata.fillUriTemplate":return c.fillUriTemplate(i,k);case"odata.uriEncode":return c.uriEncode(i,k);default:B.error(n,"unknown function: "+n.value);}},concat:function(I,e){var k=e.asExpression,l=[],R,n=[];B.expectType(e,"array");e.value.forEach(function(u,i){R=c.parameter(I,e,i);k=k||R.result==="expression";n.push(R);});n.forEach(function(R){if(k){c.wrapExpression(R);}if(R.type!=='edm:Null'){l.push(B.resultToString(R,k,e.withType));}});R=k?{result:"expression",value:l.join("+")}:{result:"composite",value:l.join("")};R.type="Edm.String";return R;},conditional:function(i,e){var C=c.parameter(i,e,0,"Edm.Boolean"),k=c.parameter(i,e,1),l=c.parameter(i,e,2),n=k.type,w=e.withType;if(k.type==="edm:Null"){n=l.type;}else if(l.type!=="edm:Null"&&k.type!==l.type){B.error(e,"Expected same type for second and third parameter, types are '"+k.type+"' and '"+l.type+"'");}return{result:"expression",type:n,value:B.resultToString(c.wrapExpression(C),true,false)+"?"+B.resultToString(c.wrapExpression(k),true,w)+":"+B.resultToString(c.wrapExpression(l),true,w)};},constant:function(i,e,k){var v=e.value;B.expectType(e,"string");if(k==="String"){if(r.test(v)){return{ignoreTypeInPath:true,result:"binding",type:"Edm.String",value:v.slice(1,-1)};}else if(i.getSetting&&i.getSetting("bindTexts")){return{result:"binding",type:"Edm.String",ignoreTypeInPath:true,value:"/##"+c.replaceIndexes(i.getModel(),e.path)};}k="Edm.String";}else if(!E[k].test(v)){B.error(e,"Expected "+k+" value but instead saw '"+v+"'");}else{k=h[k];if(k==="Edm.Int64"&&O.compare(v,b,true)>=0&&O.compare(v,m,true)<=0){k="Edm.Int32";}}return{result:"constant",type:k,value:v};},expression:function(i,e){var R=e.value,S,k;B.expectType(e,"object");if(R.hasOwnProperty("Type")){k=B.property(e,"Type","string");S=B.descend(e,"Value");}else{["And","Apply","Bool","Date","DateTimeOffset","Decimal","Float","Eq","Ge","Gt","Guid","If","Int","Le","Lt","Ne","Not","Null","Or","Path","PropertyPath","String","TimeOfDay"].forEach(function(l){if(R.hasOwnProperty(l)){k=l;S=B.descend(e,l);}});}switch(k){case"Apply":return c.apply(i,S);case"If":return c.conditional(i,S);case"Path":case"PropertyPath":return c.path(i,S);case"Bool":case"Date":case"DateTimeOffset":case"Decimal":case"Float":case"Guid":case"Int":case"String":case"TimeOfDay":return c.constant(i,S,k);case"And":case"Eq":case"Ge":case"Gt":case"Le":case"Lt":case"Ne":case"Or":return c.operator(i,S,k);case"Not":return c.not(i,S);case"Null":return{result:"constant",value:"null",type:"edm:Null"};default:B.error(e,"Unsupported OData expression");}},formatOperand:function(e,i,R,w){var k;if(R.result==="constant"){switch(R.category){case"boolean":case"number":return R.value;case"date":k=c.parseDate(R.value);if(!k){B.error(B.descend(e,i),"Invalid Date "+R.value);}return String(k.getTime());case"datetime":k=c.parseDateTimeOffset(R.value);if(!k){B.error(B.descend(e,i),"Invalid DateTime "+R.value);}return String(k.getTime());case"time":return String(c.parseTimeOfDay(R.value).getTime());}}if(w){c.wrapExpression(R);}return B.resultToString(R,true);},getExpression:function(i,R,w){var k;if(R===undefined){return undefined;}q.sap.measure.average(P,"",p);if(!c.simpleParserWarningLogged&&M.bindingParser===a.simpleParser){q.sap.log.warning("Complex binding syntax not active",null,A);c.simpleParserWarningLogged=true;}try{k=c.expression(i,{asExpression:false,path:i.getPath(),value:R,withType:w});q.sap.measure.end(P);return B.resultToString(k,false,w);}catch(e){q.sap.measure.end(P);if(e instanceof SyntaxError){return"Unsupported: "+a.complexParser.escape(B.toErrorString(R));}throw e;}},fillUriTemplate:function(I,e){var i,n,k=[],l="",u,v=e.value,R,w=c.parameter(I,e,0,"Edm.String");k.push('odata.fillUriTemplate(',B.resultToString(w,true),',{');for(i=1;i<v.length;i+=1){u=B.descend(e,i,"object");n=B.property(u,"Name","string");R=c.expression(I,B.descend(u,"Value"),true);k.push(l,B.toJSON(n),":",B.resultToString(R,true));l=",";}k.push("})");return{result:"expression",value:k.join(""),type:"Edm.String"};},not:function(i,e){var k;e.asExpression=true;k=c.expression(i,e);return{result:"expression",value:"!"+B.resultToString(c.wrapExpression(k),true),type:"Edm.Boolean"};},operator:function(i,e,k){var l=k==="And"||k==="Or"?"Edm.Boolean":undefined,n=c.parameter(i,e,0,l),u=c.parameter(i,e,1,l),v,N,V,w;if(n.type!=="edm:Null"&&u.type!=="edm:Null"){n.category=T[n.type];u.category=T[u.type];c.adjustOperands(n,u);c.adjustOperands(u,n);if(n.category!==u.category){B.error(e,"Expected two comparable parameters but instead saw "+n.type+" and "+u.type);}v=n.category==="decimal"?",true":"";N=j[n.category];}V=c.formatOperand(e,0,n,!N);w=c.formatOperand(e,1,u,!N);return{result:"expression",value:N?"odata.compare("+V+","+w+v+")"+o[k]+"0":V+o[k]+w,type:"Edm.Boolean"};},parameter:function(i,e,I,k){var l=B.descend(e,I),R;l.asExpression=true;R=c.expression(i,l);if(k&&k!==R.type){B.error(l,"Expected "+k+" but instead saw "+R.type);}return R;},parseDate:function(v){return D.getDateInstance({pattern:"yyyy-MM-dd",strictParsing:true,UTC:true}).parse(v);},parseDateTimeOffset:function(v){var e=E.DateTimeOffset.exec(v);if(e&&e[1]&&e[1].length>4){v=v.replace(e[1],e[1].slice(0,4));}return D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSX",strictParsing:true}).parse(v.toUpperCase());},parseTimeOfDay:function(v){if(v.length>12){v=v.slice(0,12);}return D.getTimeInstance({pattern:"HH:mm:ss.SSS",strictParsing:true,UTC:true}).parse(v);},path:function(i,e){var k=e.value,C={},l,I,n,u=i.getModel(),v={getModel:function(){return u;},getPath:function(){return e.path;}},w,R={result:"binding",value:k},x;B.expectType(e,"string");x=B.followPath(v,{"Path":k});if(x&&x.resolvedPath){w=u.getProperty(x.resolvedPath);R.type=w.type;switch(w.type){case"Edm.DateTime":C.displayFormat=w["sap:display-format"];break;case"Edm.Decimal":if(w.precision){C.precision=w.precision;}if(w.scale){C.scale=w.scale;}n=w["Org.OData.Validation.V1.Minimum"];if(n&&(n.Decimal||n.String)){C.minimum=n.Decimal||n.String;l=n["Org.OData.Validation.V1.Exclusive"];if(l){C.minimumExclusive=l.Bool||"true";}}n=w["Org.OData.Validation.V1.Maximum"];if(n&&(n.Decimal||n.String)){C.maximum=n.Decimal||n.String;l=n["Org.OData.Validation.V1.Exclusive"];if(l){C.maximumExclusive=l.Bool||"true";}}break;case"Edm.String":C.maxLength=w.maxLength;I=w["com.sap.vocabularies.Common.v1.IsDigitSequence"];if(I){C.isDigitSequence=I.Bool||"true";}break;}if(w.nullable==="false"){C.nullable="false";}R.constraints=C;}else{q.sap.log.warning("Could not find property '"+k+"' starting from '"+e.path+"'",null,A);}return R;},replaceIndexes:function(e,k){var l,n=k.split('/'),u,R;function v(w,i){var x=e.getProperty(u+"/"+w);if(typeof x==="string"){n[i]="[${"+w+"}==="+B.toJSON(x)+"]";return true;}return false;}l=g.exec(k);if(!l){return k;}u=l[1];if(!v("namespace",3)){return k;}for(var i=4;i<n.length;i++){u=u+"/"+n[i];if(f.test(n[i])&&!v("name",i)){R=e.getProperty(u+"/RecordType");if(R){if(R==="com.sap.vocabularies.UI.v1.DataFieldForAction"){v("Action/String",i);}else if(R==="com.sap.vocabularies.UI.v1.DataFieldForAnnotation"){v("Target/AnnotationPath",i);}else if(R.indexOf("com.sap.vocabularies.UI.v1.DataField")===0){v("Value/Path",i);}}}}return n.join('/');},simpleParserWarningLogged:false,uriEncode:function(i,e){var R=c.parameter(i,e,0);if(R.result==="constant"){if(R.type==="Edm.Date"){R.type="Edm.DateTime";R.value=R.value+"T00:00:00Z";}else if(R.type==="Edm.TimeOfDay"){R.type="Edm.Time";R.value="PT"+R.value.slice(0,2)+"H"+R.value.slice(3,5)+"M"+R.value.slice(6,8)+"S";}}return{result:"expression",value:'odata.uriEncode('+B.resultToString(R,true)+","+B.toJSON(R.type)+")",type:"Edm.String"};},wrapExpression:function(R){if(R.result==="expression"){R.value="("+R.value+")";}return R;}};return c;},false);
sap.ui.predefine('sap/ui/model/odata/_ODataMetaModelUtils',["jquery.sap.global","./_AnnotationHelperBasics"],function(q,_){"use strict";var b={"Bool":"false"},B={"Bool":"true"},d={"fiscalyear":"IsFiscalYear","fiscalyearperiod":"IsFiscalYearPeriod","year":"IsCalendarYear","yearmonth":"IsCalendarYearMonth","yearmonthday":"IsCalendarDate","yearquarter":"IsCalendarYearQuarter","yearweek":"IsCalendarYearWeek"},f={"interval":"SingleInterval","multi-value":"MultiValue","single-value":"SingleValue"},l="sap.ui.model.odata.ODataMetaModel",s={"bday":"Contact","city":"Contact/adr","country":"Contact/adr","email":"Contact/email","familyname":"Contact/n","givenname":"Contact/n","honorific":"Contact/n","middlename":"Contact/n","name":"Contact","nickname":"Contact","note":"Contact","org":"Contact","org-role":"Contact","org-unit":"Contact","photo":"Contact","pobox":"Contact/adr","region":"Contact/adr","street":"Contact/adr","suffix":"Contact/n","tel":"Contact/tel","title":"Contact","zip":"Contact/adr","class":"Event","dtend":"Event","dtstart":"Event","duration":"Event","fbtype":"Event","location":"Event","status":"Event","transp":"Event","wholeday":"Event","body":"Message","from":"Message","received":"Message","sender":"Message","subject":"Message","completed":"Task","due":"Task","percent-complete":"Task","priority":"Task"},r=/(\w+)(?:;type=([\w,]+))?/,v={"email":{typeMapping:{"home":"home","pref":"preferred","work":"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.ContactInformationType",v4PropertyAnnotation:"com.sap.vocabularies.Communication.v1.IsEmailAddress"},"tel":{typeMapping:{"cell":"cell","fax":"fax","home":"home","pref":"preferred","video":"video","voice":"voice","work":"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.PhoneType",v4PropertyAnnotation:"com.sap.vocabularies.Communication.v1.IsPhoneNumber"}},V={creatable:{"Org.OData.Capabilities.V1.InsertRestrictions":{"Insertable":b}},pageable:{"Org.OData.Capabilities.V1.SkipSupported":b,"Org.OData.Capabilities.V1.TopSupported":b},"requires-filter":{"Org.OData.Capabilities.V1.FilterRestrictions":{"RequiresFilter":B}},topable:{"Org.OData.Capabilities.V1.TopSupported":b}},m={"city":"locality","email":"address","familyname":"surname","givenname":"given","honorific":"prefix","middlename":"additional","name":"fn","org-role":"role","org-unit":"orgunit","percent-complete":"percentcomplete","tel":"uri","zip":"code"},a={"sap:filterable":["Org.OData.Capabilities.V1.FilterRestrictions","NonFilterableProperties"],"sap:required-in-filter":["Org.OData.Capabilities.V1.FilterRestrictions","RequiredProperties"],"sap:sortable":["Org.OData.Capabilities.V1.SortRestrictions","NonSortableProperties"]},c=/^com\.sap\.vocabularies\.Common\.v1\.ValueList(#.*)?$/,w=q.sap.log.Level.WARNING,U;U={addEntitySetAnnotation:function(o,e,t,n,D){if(t==="EntitySet"&&e.value===n){if(D){q.extend(true,o,V[e.name]);}else{q.extend(o,V[e.name]);}}},addFilterRestriction:function(p,e){var F,g=f[p["sap:filter-restriction"]];if(!g){if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported sap:filter-restriction: "+p["sap:filter-restriction"],e.entityType+"."+p.name,l);}return;}F=e["com.sap.vocabularies.Common.v1.FilterExpressionRestrictions"]||[];F.push({"Property":{"PropertyPath":p.name},"AllowedExpressions":{"EnumMember":"com.sap.vocabularies.Common.v1.FilterExpressionType/"+g}});e["com.sap.vocabularies.Common.v1.FilterExpressionRestrictions"]=F;},addNavigationFilterRestriction:function(n,e){var N=e["Org.OData.Capabilities.V1.NavigationRestrictions"]||{};N.RestrictedProperties=N.RestrictedProperties||[];N.RestrictedProperties.push({"FilterRestrictions":{"Filterable":b},"NavigationProperty":{"NavigationPropertyPath":n.name}});e["Org.OData.Capabilities.V1.NavigationRestrictions"]=N;},addPropertyToAnnotation:function(e,E,p){var n=a[e],t=n[0],C=n[1],A=E[t]||{},g=A[C]||[];g.push({"PropertyPath":p.name});A[C]=g;E[t]=A;},addSapSemantics:function(t){if(t.property){t.property.forEach(function(p){var A,i,M,S,T,e=p["sap:semantics"],g,h,o,j,k;if(!e){return;}if(e==="url"){p["Org.OData.Core.V1.IsURL"]=B;return;}if(e in d){g="com.sap.vocabularies.Common.v1."+d[e];p[g]=B;return;}M=r.exec(e);if(!M){if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported sap:semantics: "+e,t.name+"."+p.name,l);}return;}if(M[2]){e=M[1];k=U.getV4TypesForV2Semantics(e,M[2],p,t);}j=v[e];i=e==="tel"||e==="email";h=s[e];if(h){A=h.split("/");g="com.sap.vocabularies.Communication.v1."+A[0];t[g]=t[g]||{};o=t[g];S=A[1];if(S){o[S]=o[S]||(i?[]:{});if(i){T={};o[S].push(T);o=T;}else{o=o[S];}}o[m[e]||e]={"Path":p.name};if(k){o.type={"EnumMember":k};}}if(j){p[j.v4PropertyAnnotation]=p[j.v4PropertyAnnotation]||B;}});}},addUnitAnnotations:function(S,M){function p(t){(t||[]).forEach(function(T){(T.property||[]).forEach(function(P){var A,e,o,u,g=P["sap:unit"],h;if(g){u={"Path":g};o=_.followPath({getModel:function(){return M;},getPath:function(){return T.$path;}},u);if(o&&o.resolvedPath){h=M.getProperty(o.resolvedPath);e=h["sap:semantics"];if(e==="unit-of-measure"){A="Org.OData.Measures.V1.Unit";}else if(e==="currency-code"){A="Org.OData.Measures.V1.ISOCurrency";}else if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported sap:semantics='"+e+"' at sap:unit='"+g+"'; "+"expected 'currency-code' or 'unit-of-measure'",T.namespace+"."+T.name+"/"+P.name,l);}if(A&&!(A in P)){P[A]=u;}}else if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Path '"+g+"' for sap:unit cannot be resolved",T.namespace+"."+T.name+"/"+P.name,l);}}});});}S.forEach(function(o){p(o.complexType);p(o.entityType);});},addV4Annotation:function(o,e,t){switch(e.name){case"aggregation-role":if(e.value==="dimension"){o["com.sap.vocabularies.Analytics.v1.Dimension"]=B;}else if(e.value==="measure"){o["com.sap.vocabularies.Analytics.v1.Measure"]=B;}break;case"display-format":if(e.value==="NonNegative"){o["com.sap.vocabularies.Common.v1.IsDigitSequence"]=B;}else if(e.value==="UpperCase"){o["com.sap.vocabularies.Common.v1.IsUpperCase"]=B;}break;case"pageable":case"topable":U.addEntitySetAnnotation(o,e,t,"false",false);break;case"creatable":U.addEntitySetAnnotation(o,e,t,"false",true);break;case"deletable":case"deletable-path":U.handleXableAndXablePath(o,e,t,"Org.OData.Capabilities.V1.DeleteRestrictions","Deletable");break;case"updatable":case"updatable-path":U.handleXableAndXablePath(o,e,t,"Org.OData.Capabilities.V1.UpdateRestrictions","Updatable");break;case"requires-filter":U.addEntitySetAnnotation(o,e,t,"true",true);break;case"field-control":o["com.sap.vocabularies.Common.v1.FieldControl"]={"Path":e.value};break;case"heading":o["com.sap.vocabularies.Common.v1.Heading"]={"String":e.value};break;case"label":o["com.sap.vocabularies.Common.v1.Label"]={"String":e.value};break;case"precision":o["Org.OData.Measures.V1.Scale"]={"Path":e.value};break;case"quickinfo":o["com.sap.vocabularies.Common.v1.QuickInfo"]={"String":e.value};break;case"text":o["com.sap.vocabularies.Common.v1.Text"]={"Path":e.value};break;case"visible":if(e.value==="false"){o["com.sap.vocabularies.Common.v1.FieldControl"]={"EnumMember":"com.sap.vocabularies.Common.v1.FieldControlType/Hidden"};o["com.sap.vocabularies.UI.v1.Hidden"]=B;}break;default:}},calculateEntitySetAnnotations:function(e,E){if(E.property){E.property.forEach(function(p){if(p["sap:filterable"]==="false"){U.addPropertyToAnnotation("sap:filterable",e,p);}if(p["sap:required-in-filter"]==="true"){U.addPropertyToAnnotation("sap:required-in-filter",e,p);}if(p["sap:sortable"]==="false"){U.addPropertyToAnnotation("sap:sortable",e,p);}if(p["sap:filter-restriction"]){U.addFilterRestriction(p,e);}});}if(E.navigationProperty){E.navigationProperty.forEach(function(n){if(n["sap:filterable"]==="false"){U.addNavigationFilterRestriction(n,e);U.addPropertyToAnnotation("sap:filterable",e,n);}U.handleCreatableNavigationProperty(e,n);});}},findIndex:function(A,e,p){var i,n;p=p||"name";if(A){for(i=0,n=A.length;i<n;i++){if(A[i][p]===e){return i;}}}return-1;},findObject:function(A,e,p){var i=U.findIndex(A,e,p);return i<0?null:A[i];},getChildAnnotations:function(A,Q,i){var o=i?A.EntityContainer:A.propertyAnnotations;return o&&o[Q]||{};},getFromContainer:function(e,A,n,g){var k,R=g?undefined:null;if(e){k=U.findIndex(e[A],n);if(k>=0){R=g?e.$path+"/"+A+"/"+k:e[A][k];}}return R;},getObject:function(M,A,Q,e){var g,R=e?undefined:null,S,i,n,N;Q=Q||"";i=Q.lastIndexOf(".");n=Q.slice(0,i);N=Q.slice(i+1);S=U.getSchema(M,n);if(S){g=S[A];if(g){g.forEach(function(t){if(t.name===N){R=e?t.$path:t;return false;}});}}return R;},getSchema:function(M,n){var S=null,e=Array.isArray(M)?M:M.getObject("/dataServices/schema");if(e){e.forEach(function(o){if(o.namespace===n){S=o;return false;}});}return S;},getV4TypesForV2Semantics:function(S,t,p,T){var R=[],o=v[S];if(o){t.split(",").forEach(function(e){var g=o.typeMapping[e];if(g){R.push(o.v4EnumType+"/"+g);}else if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported type for sap:semantics: "+e,T.name+"."+p.name,l);}});}return R.join(" ");},getValueLists:function(p){var M,n,Q,e={};for(n in p){M=c.exec(n);if(M){Q=(M[1]||"").slice(1);e[Q]=p[n];}}return e;},handleCreatableNavigationProperty:function(e,n){var C=n["sap:creatable"],g=n["sap:creatable-path"],i,N={"NavigationPropertyPath":n.name},h;if(C&&g){q.sap.log.warning("Inconsistent service","Use either 'sap:creatable' or 'sap:creatable-path' at navigation property "+"'"+e.entityType+"/"+n.name+"'",l);C="false";g=undefined;}if(C==="false"||g){i=e["Org.OData.Capabilities.V1.InsertRestrictions"]=e["Org.OData.Capabilities.V1.InsertRestrictions"]||{};h=i["NonInsertableNavigationProperties"]=i["NonInsertableNavigationProperties"]||[];if(g){N={"If":[{"Not":{"Path":g}},N]};}h.push(N);}},handleXableAndXablePath:function(o,e,t,T,p){var g=p.toLowerCase(),h;if(t!=="EntitySet"){return;}if(o["sap:"+g]&&o["sap:"+g+"-path"]){q.sap.log.warning("Inconsistent service","Use either 'sap:"+g+"' or 'sap:"+g+"-path'"+" at entity set '"+o.name+"'",l);h=b;}else if(g!==e.name){h={"Path":e.value};}else if(e.value==="false"){h=b;}if(h){o[T]=o[T]||{};o[T][p]=h;}},liftSAPData:function(o,t){if(!o.extensions){return;}o.extensions.forEach(function(e){if(e.namespace==="http://www.sap.com/Protocols/SAPData"){o["sap:"+e.name]=e.value;U.addV4Annotation(o,e,t);}});switch(t){case"Property":if(o["sap:updatable"]==="false"){if(o["sap:creatable"]==="false"){o["Org.OData.Core.V1.Computed"]=B;}else{o["Org.OData.Core.V1.Immutable"]=B;}}break;case"EntitySet":if(o["sap:searchable"]!=="true"){o["Org.OData.Capabilities.V1.SearchRestrictions"]={"Searchable":b};}break;default:}},merge:function(A,D,M){var S=D.dataServices.schema;if(!S){return;}S.forEach(function(o,i){var e;delete o.annotations;U.liftSAPData(o);o.$path="/dataServices/schema/"+i;e=o["sap:schema-version"];if(e){o["Org.Odata.Core.V1.SchemaVersion"]={String:e};}q.extend(o,A[o.namespace]);U.visitParents(o,A,"association",function(g,C){U.visitChildren(g.end,C);});U.visitParents(o,A,"complexType",function(C,g){U.visitChildren(C.property,g,"Property");U.addSapSemantics(C);});U.visitParents(o,A,"entityType",U.visitEntityType);U.visitParents(o,A,"entityContainer",function(E,C){U.visitChildren(E.associationSet,C);U.visitChildren(E.entitySet,C,"EntitySet",S);U.visitChildren(E.functionImport,C,"",null,U.visitParameters.bind(this,A,o,E));});});U.addUnitAnnotations(S,M);},visitChildren:function(C,e,t,S,g,i){if(!C){return;}if(i){C=C.slice(i);}C.forEach(function(o){U.liftSAPData(o,t);});C.forEach(function(o){var E;if(t==="EntitySet"){E=U.getObject(S,"entityType",o.entityType);U.calculateEntitySetAnnotations(o,E);}if(g){g(o);}q.extend(o,e[o.name||o.role]);});},visitEntityType:function(e,C){U.visitChildren(e.property,C,"Property");U.visitChildren(e.navigationProperty,C);U.addSapSemantics(e);},visitParameters:function(A,S,e,F){var g;if(!F.parameter){return;}g=U.getChildAnnotations(A,S.namespace+"."+e.name,true);F.parameter.forEach(function(p){U.liftSAPData(p);q.extend(p,g[F.name+"/"+p.name]);});},visitParents:function(S,A,e,C,i){var p=S[e];function g(P,j){var Q=S.namespace+"."+P.name,h=U.getChildAnnotations(A,Q,e==="entityContainer");U.liftSAPData(P);P.namespace=S.namespace;P.$path=S.$path+"/"+e+"/"+j;C(P,h);q.extend(P,A[Q]);}if(!p){return;}if(i!==undefined){g(p[i],i);}else{p.forEach(g);}}};return U;},false);
sap.ui.predefine('sap/ui/model/odata/type/Boolean',['jquery.sap.global','sap/ui/core/Core','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,C,F,O,P,V){"use strict";
function g(){return a("EnterYesOrNo",[b(true),b(false)]);}
function a(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);}
function b(v){return a(v?"YES":"NO");}
function s(t,c){var n;t.oConstraints=undefined;if(c){n=c.nullable;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}}}
var E=O.extend("sap.ui.model.odata.type.Boolean",{constructor:function(f,c){O.apply(this,arguments);s(this,c);}});
E.prototype.formatValue=function(v,t){if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":case"boolean":return v;case"string":return b(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
E.prototype.parseValue=function(v,S){var c;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"boolean":return v;case"string":c=v.trim().toLowerCase();if(c===b(true).toLowerCase()){return true;}if(c===b(false).toLowerCase()){return false;}throw new P(g());default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}};
E.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g());}return;}if(typeof v!=="boolean"){throw new V("Illegal "+this.getName()+" value: "+v);}};
E.prototype.getName=function(){return"sap.ui.model.odata.type.Boolean";};
return E;});
sap.ui.predefine('sap/ui/model/odata/type/Byte',['sap/ui/model/odata/type/Int'],function(I){"use strict";var r={minimum:0,maximum:255};
var B=I.extend("sap.ui.model.odata.type.Byte",{constructor:function(){I.apply(this,arguments);}});
B.prototype.getName=function(){return"sap.ui.model.odata.type.Byte";};
B.prototype.getRange=function(){return r;};
return B;});
sap.ui.predefine('sap/ui/model/odata/type/Date',['jquery.sap.global','sap/ui/core/format/DateFormat','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,D,F,O,P,V){"use strict";var r=/\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\d|3[01])/,d="2014-11-27",m;
function g(t){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterDate",[t.formatValue(d,"string")]);}
function a(t){var f;if(!t.oFormat){f=q.extend({strictParsing:true},t.oFormatOptions);f.UTC=true;t.oFormat=D.getDateInstance(f);}return t.oFormat;}
function b(){if(!m){m=D.getDateInstance({pattern:'yyyy-MM-dd',strictParsing:true,UTC:true});}return m;}
function s(t,c){var n;t.oConstraints=undefined;if(c){n=c.nullable;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}}}
var E=O.extend("sap.ui.model.odata.type.Date",{constructor:function(f,c){O.apply(this,arguments);this.oFormatOptions=f;s(this,c);}});
E.prototype._handleLocalizationChange=function(){this.oFormat=null;};
E.prototype.formatValue=function(v,t){var o;if(v===undefined||v===null){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"string":o=v instanceof Date?v:b().parse(v);return o?a(this).format(o):v;default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
E.prototype.getModelFormat=function(){return b();};
E.prototype.getName=function(){return"sap.ui.model.odata.type.Date";};
E.prototype.parseValue=function(v,S){var R;if(v===""||v===null){return null;}switch(this.getPrimitiveType(S)){case"string":R=a(this).parse(v);if(!R){throw new P(g(this));}return b().format(R);default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}};
E.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g(this));}}else if(typeof v!=="string"||!r.test(v)){throw new V("Illegal "+this.getName()+" value: "+v);}};
return E;});
sap.ui.predefine('sap/ui/model/odata/type/DateTime',['jquery.sap.global','sap/ui/model/odata/type/DateTimeBase'],function(q,D){"use strict";
function a(t,c){var A={};if(c){switch(c.displayFormat){case"Date":A.isDateOnly=true;break;case undefined:break;default:q.sap.log.warning("Illegal displayFormat: "+c.displayFormat,null,t.getName());}A.nullable=c.nullable;}return A;}
var b=D.extend("sap.ui.model.odata.type.DateTime",{constructor:function(f,c){D.call(this,f,a(this,c));}});
b.prototype.getName=function(){return"sap.ui.model.odata.type.DateTime";};
return b;});
sap.ui.predefine('sap/ui/model/odata/type/DateTimeBase',["jquery.sap.global","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/odata/type/ODataType","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(q,D,F,O,P,V){"use strict";var d=new Date(2014,10,27,13,47,26);
function i(t){return t.oConstraints&&t.oConstraints.isDateOnly;}
function g(t){return sap.ui.getCore().getLibraryResourceBundle().getText(i(t)?"EnterDate":"EnterDateTime",[t.formatValue(d,"string")]);}
function a(t){var f;if(!t.oFormat){f=q.extend({strictParsing:true},t.oFormatOptions);if(i(t)){f.UTC=true;t.oFormat=D.getDateInstance(f);}else{t.oFormat=D.getDateTimeInstance(f);}}return t.oFormat;}
function s(t,c){var n,p;t.oConstraints=undefined;if(c){n=c.nullable;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}if(c.isDateOnly===true){t.oConstraints=t.oConstraints||{};t.oConstraints.isDateOnly=true;}p=c.precision;if(p!==undefined){if(p===Math.floor(p)&&p>=1&&p<=12){t.oConstraints=t.oConstraints||{};t.oConstraints.precision=p;}else if(p!==0){q.sap.log.warning("Illegal precision: "+p,null,t.getName());}}}t._handleLocalizationChange();}
var b=O.extend("sap.ui.model.odata.type.DateTimeBase",{
constructor:function(f,c){O.apply(this,arguments);s(this,c);this.oFormat=null;this.oFormatOptions=f;},
metadata:{"abstract":true}
});
b.prototype.formatValue=function(v,t){if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"string":if(!(v instanceof Date)){throw new F("Illegal "+this.getName()+" value: "+v);}return a(this).format(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
b.prototype.parseValue=function(v,S){var r;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"string":r=a(this).parse(v);if(!r){throw new P(g(this));}return r;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}};
b.prototype._handleLocalizationChange=function(){this.oFormat=null;};
b.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g(this));}return;}else if(v instanceof Date){return;}throw new V("Illegal "+this.getName()+" value: "+v);};
return b;});
sap.ui.predefine('sap/ui/model/odata/type/DateTimeOffset',["jquery.sap.global","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/odata/type/DateTimeBase"],function(q,D,F,a){"use strict";
var b=a.extend("sap.ui.model.odata.type.DateTimeOffset",{constructor:function(f,c){var v;a.call(this,f,{nullable:c?c.nullable:undefined,precision:c?c.precision:undefined});this.rDateTimeOffset=undefined;this.bV4=false;if(c){v=c.V4;if(v===true){this.bV4=true;}else if(v!==undefined&&v!==false){q.sap.log.warning("Illegal V4: "+v,null,this.getName());}}}});
function g(t){var p="yyyy-MM-dd'T'HH:mm:ss",P;if(!t.oModelFormat){P=t.oConstraints&&t.oConstraints.precision;if(P){p+="."+q.sap.padRight("","S",P);}t.oModelFormat=D.getDateInstance({pattern:p+"X",strictParsing:true,UTC:t.oFormatOptions&&t.oFormatOptions.UTC});}return t.oModelFormat;}
b.prototype.formatValue=function(v,t){var d;if(typeof v==="string"&&this.getPrimitiveType(t)==="string"){d=g(this).parse(v);if(!d){throw new F("Illegal "+this.getName()+" value: "+v);}v=d;}return a.prototype.formatValue.call(this,v,t);};
b.prototype.getModelFormat=function(){if(this.bV4){return g(this);}return a.prototype.getModelFormat.call(this);};
b.prototype.getName=function(){return"sap.ui.model.odata.type.DateTimeOffset";};
b.prototype.parseValue=function(v,s){var r=a.prototype.parseValue.call(this,v,s);return this.bV4&&r!==null?g(this).format(r):r;};
b.prototype.setV4=function(){this.bV4=true;return this;};
b.prototype.validateValue=function(v){var p;if(this.bV4){if(typeof v==="string"){if(!this.rDateTimeOffset){p=this.oConstraints&&this.oConstraints.precision;this.rDateTimeOffset=new RegExp("^"+"\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\\d|3[01])"+"T"+"(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d"+(p?"(\\.\\d{1,"+p+"})?":"")+")?"+"(?:Z|[-+](?:0\\d|1[0-3]):[0-5]\\d|[-+]14:00)$","i");}if(this.rDateTimeOffset.test(v)){return;}}else if(v){v=v.toString();}}a.prototype.validateValue.call(this,v);};
return b;});
sap.ui.predefine('sap/ui/model/odata/type/Decimal',['jquery.sap.global','sap/ui/core/format/NumberFormat','sap/ui/model/FormatException',"sap/ui/model/odata/ODataUtils",'sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,N,F,B,O,P,V){"use strict";var r=/^[-+]?(\d+)(?:\.(\d+))?$/;
function g(t){var f,S;if(!t.oFormat){f={groupingEnabled:true,maxIntegerDigits:Infinity};S=a(t);if(S!==Infinity){f.minFractionDigits=f.maxFractionDigits=S;}f=q.extend(f,t.oFormatOptions);f.parseAsString=true;t.oFormat=N.getFloatInstance(f);}return t.oFormat;}
function a(t){return(t.oConstraints&&t.oConstraints.scale)||0;}
function b(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);}
function s(t,c){var n,p,v,S,d;function l(j,k){q.sap.log.warning("Illegal "+k+": "+j,null,t.getName());}function e(j,k,m,o){var u=typeof j==="string"?parseInt(j,10):j;if(u===undefined){return k;}if(typeof u!=="number"||isNaN(u)||u<m){l(j,o);return k;}return u;}function f(j,k){if(j){if(j.match(r)){return j;}l(j,k);}}function h(j,k){if(j===true||j==="true"){return true;}if(j!==undefined&&j!==false&&j!=="false"){l(j,k);}}function i(j,k,m){if(k!==m){t.oConstraints=t.oConstraints||{};t.oConstraints[j]=k;}}t.oConstraints=undefined;if(c){n=c.nullable;v=c.precision;d=c.scale;S=d==="variable"?Infinity:e(d,0,0,"scale");p=e(v,Infinity,1,"precision");if(S!==Infinity&&p<=S){q.sap.log.warning("Illegal scale: must be less than precision (precision="+v+", scale="+d+")",null,t.getName());S=Infinity;}i("precision",p,Infinity);i("scale",S,0);if(n===false||n==="false"){i("nullable",false,true);}else if(n!==undefined&&n!==true&&n!=="true"){l(n,"nullable");}i("minimum",f(c.minimum,"minimum"));i("minimumExclusive",h(c.minimumExclusive,"minimumExclusive"));i("maximum",f(c.maximum,"maximum"));i("maximumExclusive",h(c.maximumExclusive,"maximumExclusive"));}t._handleLocalizationChange();}
var D=O.extend("sap.ui.model.odata.type.Decimal",{constructor:function(f,c){O.apply(this,arguments);this.oFormatOptions=f;s(this,c);}});
D.prototype.formatValue=function(v,t){if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"float":return parseFloat(v);case"int":return Math.floor(parseFloat(v));case"string":return g(this).format(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
D.prototype.parseValue=function(v,S){var R;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"string":R=g(this).parse(v);if(!R){throw new P(sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber"));}if(R.indexOf(".")>=0){R=R.replace(/0+$/,"").replace(/\.$/,"");}break;case"int":case"float":R=N.getFloatInstance({maxIntegerDigits:Infinity,decimalSeparator:".",groupingEnabled:false}).format(v);break;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}return R;};
D.prototype._handleLocalizationChange=function(){this.oFormat=null;};
D.prototype.validateValue=function(v){var f,i,m,M,c,d,e,p,S;if(v===null&&(!this.oConstraints||this.oConstraints.nullable!==false)){return;}if(typeof v!=="string"){throw new V(b("EnterNumber"));}m=r.exec(v);if(!m){throw new V(b("EnterNumber"));}i=m[1].length;f=(m[2]||"").length;S=a(this);p=(this.oConstraints&&this.oConstraints.precision)||Infinity;d=this.oConstraints&&this.oConstraints.minimum;M=this.oConstraints&&this.oConstraints.maximum;if(f>S){if(S===0){throw new V(b("EnterInt"));}else if(i+S>p){throw new V(b("EnterNumberIntegerFraction",[p-S,S]));}throw new V(b("EnterNumberFraction",[S]));}if(S===Infinity){if(i+f>p){throw new V(b("EnterNumberPrecision",[p]));}}else if(i>p-S){throw new V(b("EnterNumberInteger",[p-S]));}if(d){e=this.oConstraints.minimumExclusive;if(B.compare(d,v,true)>=(e?0:1)){throw new V(b(e?"EnterNumberMinExclusive":"EnterNumberMin",[this.formatValue(d,"string")]));}}if(M){c=this.oConstraints.maximumExclusive;if(B.compare(M,v,true)<=(c?0:-1)){throw new V(b(c?"EnterNumberMaxExclusive":"EnterNumberMax",[this.formatValue(M,"string")]));}}};
D.prototype.getName=function(){return"sap.ui.model.odata.type.Decimal";};
return D;});
sap.ui.predefine('sap/ui/model/odata/type/Double',['jquery.sap.global','sap/ui/core/format/NumberFormat','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,N,F,O,P,V){"use strict";
function g(){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber");}
function a(t){var f;if(!t.oFormat){f=q.extend({groupingEnabled:true},t.oFormatOptions);t.oFormat=N.getFloatInstance(f);}return t.oFormat;}
function i(t){return!t.oConstraints||t.oConstraints.nullable!==false;}
function s(t,c){var n;t.oConstraints=undefi