\mainpage %ROOT Reference Documentation

### Introduction
Welcome to %ROOT

This documentation describes the software classes and functions that makes up the %ROOT software system as well as their application programming interface (API).
This is not an introduction of %ROOT, for this please refer to  the [%ROOT User Guides and Manuals](http://root.cern.ch/root-user-guides-and-manuals).
This documentation is generated directly from the source code using [Doxygen](http://doxygen.org) and in principle is kept up to date.
The version of %ROOT corresponding to this documentation is indicated at the page heading.
You may also find in [reference documentation page](http://root.cern.ch/guides/reference-guide) pointers to reference manuals for other %ROOT versions.

### How to use this reference documentation
The [User’s Classes](modules.html) in the top bar provides the user API, mainly the list of main Users' classes organized by module or functionality.
The full list of classes, both for the public API and for the implementation details are available under the [All Classes](annotated.html) tab.
A classification of classes based on their C++ namespace can be found under the [Namespace](namespaces.html) tab.
The fully indexed list of all source code is available under the tab [Files](files.html).

### %ROOT provides other types of documentation:

- A general [Users Guide](https://root.cern.ch/root/htmldoc/guides/users-guide/ROOTUsersGuide.html) is provided for a more in depth explanation of concepts and functionality available in the %ROOT system.
- A number of topical [User Guides and Manuals](http://root.cern.ch/root-user-guides-and-manuals) for various components of the system.
- A rich set of %ROOT [tutorials and code examples](https://root.cern/doc/master/group__Tutorials.html) are offered to developers to exercise specific functionality.
- A rich set of [HowTo's](https://root.cern.ch/howtos) is also present to discuss issues commonly faced by %ROOT users.

### Caveat
We have moved recently to generate the documentation with Doxygen.
To achieve this the comments in the source code needed to be formatted and written specifically for Doxygen to generated proper documentation.
If you find missing documentation or inaccuracies please report them to our [bug tracker](https://sft.its.cern.ch/jira/secure/CreateIssue.jspa?pid=10010&issuetype=1). Detailed instructions on how to submit a bug can be found [here](http://root.cern.ch/how/report-bug-jira).

