/*-
 * $Id: echo.h,v 1.6 2002/07/15 20:07:37 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_NULL_ECHO_H__
#define __RR_NULL_ECHO_H__

typedef struct _RRNullEcho RRNullEcho;
typedef struct _RRNullEchoClass RRNullEchoClass;

#define NULL_ECHO_URI "http://xml.resource.org/profiles/NULL/ECHO"

#include <librr/rr-channel.h>

G_BEGIN_DECLS

#define RR_TYPE_NULL_ECHO (rr_null_echo_get_type ())
#define RR_NULL_ECHO(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_NULL_ECHO, RRNullEcho))
#define RR_NULL_ECHO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_NULL_ECHO, RRNullEchoClass))
#define RR_IS_NULL_ECHO(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_NULL_ECHO))
#define RR_IS_NULL_ECHO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_NULL_ECHO))
#define RR_NULL_ECHO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_NULL_ECHO, RRNullEchoClass))

struct _RRNullEcho {
	RRChannel parent_object;

	GError *echo_error;

	gboolean  active;
	GMutex   *active_mutex;
	GCond    *active_cond;

	guint8 *obuffer;
};

struct _RRNullEchoClass {
	RRChannelClass parent_class;
};

GType rr_null_echo_get_type (void);

gboolean
rr_null_echo_trip (RRNullEcho *echo, 
		   const guint8 *ibuffer, gsize ilen,
		   guint8 *obuffer, gsize olen,
		   GError **error);

G_END_DECLS

#endif /* __RR_NULL_ECHO_H__ */


