/*-
 * $Id: rr-win32.c,v 1.3 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include "rr-win32.h"

gint
rr_win32_enable_nonblock (gint fd)
{
	unsigned long enable=1;

	return (ioctlsocket (fd, FIONBIO, &enable) == 0);
}

gboolean
rr_win32_init_winsock ()
{
	WORD wVersionRequested; 
	WSADATA wsaData; 
	int error; 
	static gboolean done = FALSE;

	/* Only do this once */
	if (done)
		return TRUE;
	done = TRUE;

	wVersionRequested = MAKEWORD( 1, 1 ); 

	error = WSAStartup( wVersionRequested, &wsaData ); 
	if (error != 0) {
			return FALSE;
	}
	return TRUE;
}
