/*-
 * $Id: rr-tcpfilter.c,v 1.7 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>

#include <stdio.h>
#include <stdlib.h>


static GIOStatus tcp_filter_read (RRFilter *filter, guint8 *data, 
				  gsize len, gsize *read, GSList *stack, 
				  GError **error);

static GIOStatus tcp_filter_write (RRFilter *filter, guint8 *data, 
				   gsize len, gsize *written, 
				   GSList *stack, GError **error);

static void
rr_tcp_filter_init (GObject *object)
{
}

static void
rr_tcp_filter_class_init (GObjectClass *klass)
{
	RRFilterClass *filter_class = (RRFilterClass *)klass;

	filter_class->read = tcp_filter_read;
	filter_class->write = tcp_filter_write;
}

GType 
rr_tcp_filter_get_type (void)
{
	static GType rr_type = 0;

	if (!rr_type) {
		static GTypeInfo type_info = {
			sizeof (RRTCPFilterClass),
			NULL,
			NULL,
			(GClassInitFunc) rr_tcp_filter_class_init,
			NULL,
			NULL,
			sizeof (RRTCPFilter),
			16,
			(GInstanceInitFunc) rr_tcp_filter_init
		};
		rr_type = g_type_register_static (RR_TYPE_FILTER, "RRTCPFilter", 
						  &type_info, 0);
	}
	return rr_type;
}

static GIOStatus
tcp_filter_read (RRFilter *filter, guint8 *data, gsize len, gsize *read,
		GSList *stack, GError **error)
{
	RRTCPFilter *tcpfilter = RR_TCP_FILTER (filter);
	GIOStatus status;

	/* We should be the last one on the io stack */
	g_assert (stack == NULL);

	status = g_io_channel_read_chars (tcpfilter->iochannel,
					  data, len, read, error);

	rr_debug_net_log_transfer (data, *read, TRUE);

	return status;
}

static GIOStatus
tcp_filter_write (RRFilter *filter, guint8 *data, gsize len, 
		  gsize *written, GSList *stack, GError **error)
{
	RRTCPFilter *tcpfilter = RR_TCP_FILTER (filter);

	/* We should be the last one on the io stack */
	g_assert (stack == NULL);

	rr_debug_net_log_transfer (data, len, FALSE);

	return g_io_channel_write_chars (tcpfilter->iochannel,
					   data, len, written, error);
}

RRTCPFilter *
rr_tcp_filter_new ()
{
	return g_object_new (RR_TYPE_TCP_FILTER, NULL);
}

void
rr_tcp_filter_set_iochannel (RRTCPFilter *tcpfilter, GIOChannel *iochannel)
{
	tcpfilter->iochannel = iochannel;
}
