/*-
 * $Id: rr-tcpconnection.h,v 1.19 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_TCPCONNECTION_H__
#define __RR_TCPCONNECTION_H__

typedef struct _RRTCPConnection RRTCPConnection;
typedef struct _RRTCPConnectionClass RRTCPConnectionClass;

#include <librr/tcp/rr-tcpfilter.h>
#include <librr/rr-connection.h>

G_BEGIN_DECLS

#define RR_TYPE_TCP_CONNECTION (rr_tcp_connection_get_type ())
#define RR_TCP_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_TCP_CONNECTION, RRTCPConnection))
#define RR_TCP_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_TCP_CONNECTION, RRTCPConnectionClass))
#define RR_IS_TCP_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_TCP_CONNECTION))
#define RR_IS_TCP_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_TCP_CONNECTION))
#define RR_TCP_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_TCP_CONNECTION, RRTCPConnectionClass))

struct _RRTCPConnection {
	RRConnection parent_object;

	RRTCPFilter *filter;

	GIOChannel *iochannel;
	gchar *ibuffer;
	gchar *obuffer;
	gint ibuffer_offset;

	guint in_event;
	guint out_event;
	guint err_event;

	GStaticMutex event_lock;

	GMutex *active_mutex;
	GCond  *active_cond;
	guint   in_active;
	guint   out_active;
	guint   err_active;
};

struct _RRTCPConnectionClass {
	RRConnectionClass parent_class;
};

GType rr_tcp_connection_get_type (void);

RRConnection *rr_tcp_connection_new (RRProfileRegistry *profreg,
				     const gchar *hostname, 
				     gint port, GError **error);

gboolean rr_tcp_connection_connect (RRTCPConnection *connection,
				    const gchar *hostname, gint port, 
				    GError **error);

RRTCPConnection *rr_tcp_connection_new_unconnected (RRProfileRegistry *profreg);
gboolean rr_tcp_connection_connect_fd (RRTCPConnection *tcpc,
				       gint fd, RRRole role, 
				       GError **error);

gint rr_tcp_connection_get_fd (RRTCPConnection *tcpc);

G_END_DECLS

#endif /* __RR_TCPCONNECTION_H__ */
