/*-
 * $Id: rr-frame-seq.h,v 1.2 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_FRAME_SEQ_H__
#define __RR_FRAME_SEQ_H__

typedef struct _RRFrameSeq RRFrameSeq;
typedef struct _RRFrameSeqClass RRFrameSeqClass;

#include <librr/rr-frame.h>

G_BEGIN_DECLS

#define RR_TYPE_FRAME_SEQ (rr_frame_seq_get_type ())
#define RR_FRAME_SEQ(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_FRAME_SEQ, RRFrameSeq))
#define RR_FRAME_SEQ_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_FRAME_SEQ, RRFrameSeqClass))
#define RR_IS_FRAME_SEQ(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_FRAME_SEQ))
#define RR_IS_FRAME_SEQ_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_FRAME_SEQ))
#define RR_FRAME_SEQ_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_FRAME_SEQ, RRFrameClass))

struct _RRFrameSeq {
	RRFrame parent_object;

	gint32   channel_id;
	guint32  seqno;
	gint32   size;
};

struct _RRFrameSeqClass {
	RRFrameClass parent_class;
};

GType rr_frame_seq_get_type (void);

RRFrameSeq *rr_frame_seq_new (gint32 channel_id, guint32 seqno, gint32 size);

G_END_DECLS

#endif /* __RR_FRAME_SEQ_H__ */
