/*-
 * $Id: rr-frame-seq.c,v 1.7 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>

#include <stdio.h>
#include <string.h>

static GObjectClass *parent_class = NULL;

static gint build (RRFrame *frame, gchar *buffer);
static gint parse (RRFrame *frame, const gchar *buffer, 
		   const gchar *next_line, gint len, GError **error);

static void
rr_frame_seq_init (GObject *object)
{
}

static void
rr_frame_seq_class_init (GObjectClass *klass)
{
	RRFrameClass *frame_class = (RRFrameClass *)klass;

	frame_class->build = build;
	frame_class->parse = parse;

	parent_class = g_type_class_peek_parent (klass);
}

GType 
rr_frame_seq_get_type (void)
{
	static GType rr_type = 0;

	if (!rr_type) {
		static GTypeInfo type_info = {
			sizeof (RRFrameSeqClass),
			NULL,
			NULL,
			(GClassInitFunc) rr_frame_seq_class_init,
			NULL,
			NULL,
			sizeof (RRFrameSeq),
			16,
			(GInstanceInitFunc) rr_frame_seq_init
		};
		rr_type = g_type_register_static (RR_TYPE_FRAME, "RRFrameSeq", 
						  &type_info, 0);

	}
	return rr_type;
}

RRFrameSeq *
rr_frame_seq_new (gint32 channel_id, guint32 seqno, gint32 size)
{
	RRFrameSeq *frame;

	frame = g_object_new (RR_TYPE_FRAME_SEQ, NULL);

	frame->channel_id = channel_id;
	frame->seqno      = seqno;
	frame->size       = size;

	return frame;
}

static gint
build (RRFrame *rrframe, gchar *buffer)
{
	RRFrameSeq *frame = RR_FRAME_SEQ (rrframe);

	g_return_val_if_fail (RR_IS_FRAME_SEQ (frame), 0);

	sprintf (buffer, "SEQ %d %u %d\r\n", frame->channel_id, 
		 frame->seqno, frame->size);

	return strlen (buffer);
}

static gint
parse (RRFrame *rrframe, const gchar *buffer, const gchar *next_line, 
       gint len, GError **error)
{
	RRFrameSeq *frame = RR_FRAME_SEQ (rrframe);
	gint header_len;
	
	g_return_val_if_fail (RR_IS_FRAME_SEQ (frame), 0);

	header_len = next_line - buffer;

	if (sscanf (buffer, "SEQ %d %u %d", 
		    &frame->channel_id, &frame->seqno, &frame->size) != 3) {
		
		g_set_error (error, RR_BEEP_ERROR, RR_BEEP_CODE_SYNTAX_ERROR,
			     "seq frame: parse error");
		return -1;
	}
	
	return header_len;
}

