/*-
 * $Id: rr-manager.h,v 1.26 2002/08/28 21:37:40 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_MANAGER_H__
#define __RR_MANAGER_H__

typedef struct _RRManager RRManager;
typedef struct _RRManagerClass RRManagerClass;

#include <librr/rr-channel.h>

G_BEGIN_DECLS

#define RR_TYPE_MANAGER (rr_manager_get_type ())
#define RR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_MANAGER, RRManager))
#define RR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_MANAGER, RRManagerClass))
#define RR_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_MANAGER))
#define RR_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_MANAGER))
#define RR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_MANAGER, RRManagerClass))

typedef enum {
	RR_MANAGER_NORMAL,
	RR_MANAGER_STARTING,
	RR_MANAGER_CLOSING
} RRManagerState;

struct _RRManager {
	RRChannel parent_object;

	/* greeting specific variables */
	GError *greeting_error;
	GMutex *state_mutex;
	GCond *state_cond;
	gboolean expects_greeting;
	gboolean greeting_sent;

	GMutex *id_mutex;
	gint32 next_channel_id;

	/* Active messages waiting for a reply */
	GMutex *active_mutex;
	GQueue *active_queue;
	
	gboolean shutting_down;
};

struct _RRManagerClass {
	RRChannelClass parent_class;
};

GType rr_manager_get_type (void);

RRManager *rr_manager_new (gint id);

RRChannel *rr_manager_start (RRManager *manager, const gchar *server_name,
			     GType channel_type, gpointer config_data,
			     GError **error);

RRChannel *rr_manager_start_multi (RRManager *manager, const gchar *server_name,
				   GError **error, ...);

RRChannel *rr_manager_start_multiv (RRManager *manager, const gchar *server_name,
				    GError **error, va_list args);

gboolean rr_manager_close_channel (RRManager *manager, RRChannel *channel,
				   gint code, const gchar *xml_lang, 
				   const gchar *diagnostic,
				   GError **error);

gboolean rr_manager_close_channel_nonblock (RRManager *manager, 
					    RRChannel *channel,
					    gint code, const gchar *xml_lang, 
					    const gchar *diagnostic, 
					    GError **error);

gboolean rr_manager_wait_for_greeting (RRManager *manager, GError **error);
gboolean rr_manager_wait_for_greeting_sent (RRManager *manager, GError **error);

gboolean rr_manager_send_greeting (RRManager *manager, GError **error);

void rr_manager_set_expects_greeting (RRManager *manager, gboolean state);
void rr_manager_set_greeting_sent (RRManager *manager, gboolean state);


G_END_DECLS

#endif /* __RR_MANAGER_H__ */
