#ifndef __RR_FRAME_H__
#define __RR_FRAME_H__

typedef struct _RRFrame RRFrame;
typedef struct _RRFrameClass RRFrameClass;

#include <librr/rr-channel.h>
#include <librr/rr-mime.h>
#include <librr/message/rr-message.h>

G_BEGIN_DECLS

#define RR_NEXT_MSGNO (-1)
#define RR_BEEP_MIME_HEADER_LEN 38
#define RR_BEEP_MIME_HEADER "Content-Type: application/beep+xml\r\n\r\n"

#define RR_TYPE_FRAME (rr_frame_get_type ())
#define RR_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_FRAME, RRFrame))
#define RR_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_FRAME, RRFrameClass))
#define RR_IS_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_FRAME))
#define RR_IS_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_FRAME))
#define RR_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_FRAME, RRFrameClass))

typedef enum {
	RR_FRAME_TYPE_UNKNOWN,
	RR_FRAME_TYPE_MSG,
	RR_FRAME_TYPE_RPY,
	RR_FRAME_TYPE_ERR,
	RR_FRAME_TYPE_ANS,
	RR_FRAME_TYPE_NUL
} RRFrameType;

struct _RRFrame {
	GObject parent_object;

	RRFrameType type;
	gint32   channel_id;
	gint32   msgno;
	gboolean more;
	guint32  seqno;
	gint32   size;
	gint32   ansno;
	gchar   *payload;

	/* <private> */
	RRMimePart *part;
	gboolean should_free;

	/* The frame can hold a reference of the message the frame
	 * "belongs" to. This can be helpful to be able to make sure
	 * the frame is finalized before the message */
	RRMessage *msg;
};

struct _RRFrameClass {
	GObjectClass parent_class;
	gint (* parse) (RRFrame *frame, const gchar *buffer, 
			const gchar *body, gint len, GError **error);
	gint (* build) (RRFrame *frame, gchar *buffer);
};

GType        rr_frame_get_type           (void);

RRFrame     *rr_frame_new                (RRFrameType type, 
					  gint32 channel_id, 
			                  gboolean more, 
					  gint32 msgno, 
					  gint32 size, 
					  gint32 ansno, 
					  gchar *payload, 
					  gboolean should_free);

const gchar *rr_frame_mime_get_body      (RRFrame *frame);
gint32       rr_frame_mime_get_body_size (RRFrame *frame);

RRMimePart  *rr_frame_parse_mime         (RRFrame *frame);

gint         rr_frame_build              (RRFrame *frame, gchar *buffer);
gint         rr_frame_parse              (RRFrame *frame, 
					  const gchar *buffer, 
					  const gchar *body, gint len, 
					  GError **error);

void         rr_frame_reference_message  (RRFrame *frame, RRMessage *msg);

RRFrame     *rr_frame_aggregate          (GSList **list, RRFrame *frame);
void         rr_frame_aggregator_free    (GSList **list);


G_END_DECLS

#endif /* __RR_FRAME_H__ */
