/*-
 * $Id: rr-filterstack.h,v 1.3 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_FILTERSTACK_H__
#define __RR_FILTERSTACK_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _RRFilterStack RRFilterStack;

typedef GIOStatus  (*RRReaderFunc) (guint8 *data, gsize len, 
				    gsize *read, gpointer user_data,
				    RRFilterStack *stack, GError **error);
typedef GIOStatus  (*RRWriterFunc) (guint8 *data, gsize len, 
				    gsize *written, gpointer user_data,
				    RRFilterStack *stack, GError **error);

#include <librr/rr-filter.h>

struct _RRFilterStack
{
	GSList *stack;
	GStaticRWLock lock;
};

RRFilterStack *rr_filterstack_new (void);
void rr_filterstack_free (RRFilterStack *stack);

GIOStatus rr_filterstack_read (RRFilterStack *stack, guint8 *data, 
			       gsize len, gsize *read, GError **error);

GIOStatus rr_filterstack_write (RRFilterStack *stack, guint8 *data, 
				gsize len, gsize *written, GError **error);


void rr_filterstack_push (RRFilterStack *stack, RRFilter *filter);

GIOStatus rr_filterstack_read_next (GSList *stack, guint8 *data, 
				    gsize len, gsize *read, GError **error);

GIOStatus rr_filterstack_write_next (GSList *next, guint8 *data, 
				     gsize len, gsize *written, 
				     GError **error);

G_END_DECLS

#endif /* __RR_FILTERSTACK_H__ */
