/*-
 * $Id: rr-filterstack.c,v 1.3 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include "rr-filterstack.h"

GIOStatus
rr_filterstack_read_next (GSList *stack, guint8 *data, gsize len, 
			  gsize *read, GError **error)
{
	RRFilter *filter;

	filter = RR_FILTER (stack->data);
	return rr_filter_read (filter, data, len, read, stack->next, 
			       error);
}

GIOStatus
rr_filterstack_read (RRFilterStack *fs, guint8 *data, gsize len, 
		     gsize *read, GError **error)
{
	GIOStatus status;

	g_return_val_if_fail (data != NULL, 0);
	g_return_val_if_fail (len >0, 0);
	g_return_val_if_fail (fs != NULL, 0);
	g_return_val_if_fail (fs->stack != NULL, 0);

	g_static_rw_lock_reader_lock (&fs->lock);
	status = rr_filterstack_read_next (fs->stack, data, len, read, error);
	g_static_rw_lock_reader_unlock (&fs->lock);

	return status;
}

GIOStatus
rr_filterstack_write_next (GSList *stack, guint8 *data, gsize len, 
			   gsize *written, GError **error)
{
	RRFilter *filter;
	
	filter = RR_FILTER (stack->data);
	return rr_filter_write (filter, data, len, written, stack->next,
				error);
}

GIOStatus
rr_filterstack_write (RRFilterStack *fs, guint8 *data, gsize len, 
		      gsize *written, GError **error)
{
	GIOStatus status;

	g_return_val_if_fail (data != NULL, 0);
	g_return_val_if_fail (len >0, 0);
	g_return_val_if_fail (fs != NULL, 0);
	g_return_val_if_fail (fs->stack != NULL, 0);

	g_static_rw_lock_reader_lock (&fs->lock);
	status = rr_filterstack_write_next (fs->stack, data, len, written, 
					    error);
	g_static_rw_lock_reader_unlock (&fs->lock);

	return status;
}

void
rr_filterstack_push (RRFilterStack *fs, RRFilter *filter)
{
	g_static_rw_lock_writer_lock (&fs->lock);
	fs->stack = g_slist_prepend (fs->stack, filter);
	g_static_rw_lock_writer_unlock (&fs->lock);
}

RRFilterStack *
rr_filterstack_new ()
{
	RRFilterStack *fs;
	
	fs = g_new0 (RRFilterStack, 1);
	g_static_rw_lock_init (&fs->lock);

	return fs;
}

void
rr_filterstack_free (RRFilterStack *fs)
{
	g_static_rw_lock_writer_lock (&fs->lock);
	g_slist_foreach (fs->stack, (GFunc)g_object_unref, NULL);
	g_slist_free (fs->stack);
	g_static_rw_lock_writer_unlock (&fs->lock);

	g_static_rw_lock_free (&fs->lock);
	g_free (fs);
}			     
