/*-
 * $Id: rr-filter.h,v 1.3 2002/05/11 17:54:00 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_FILTER_H__
#define __RR_FILTER_H__

typedef struct _RRFilter RRFilter;
typedef struct _RRFilterClass RRFilterClass;

#include <librr/rr-filterstack.h>

G_BEGIN_DECLS

#define RR_TYPE_FILTER (rr_filter_get_type ())
#define RR_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_FILTER, RRFilter))
#define RR_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_FILTER, RRFilterClass))
#define RR_IS_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_FILTER))
#define RR_IS_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_FILTER))
#define RR_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_FILTER, RRFilterClass))

struct _RRFilter {
	GObject parent_object;
};

struct _RRFilterClass {
	GObjectClass parent_class;

	GIOStatus  (*read) (RRFilter *filter, guint8 *data, 
			    gsize len, gsize *read,
			    GSList *stack, GError **error);
	GIOStatus  (*write) (RRFilter *filter, guint8 *data, 
			     gsize len, gsize *written, 
			     GSList *stack, GError **error);
	
};

GType rr_filter_get_type (void);

GIOStatus  rr_filter_read (RRFilter *filter, guint8 *data, 
			   gsize len, gsize *read,
			   GSList *stack, GError **error);
GIOStatus rr_filter_write (RRFilter *filter, guint8 *data, 
			   gsize len, gsize *written, 
			   GSList *stack, GError **error);
	
G_END_DECLS

#endif /* __RR_FILTER_H__ */
