/*-
 * $Id: rr-debug.h,v 1.6 2002/11/28 21:00:24 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_DEBUG_H__
#define __RR_DEBUG_H__

#include <glib/gmessages.h>

typedef enum                                                                                 
{                 
	RR_LOG_LEVEL_DEBUG1 = 1 << (G_LOG_LEVEL_USER_SHIFT),
	RR_LOG_LEVEL_DEBUG2 = 1 << (G_LOG_LEVEL_USER_SHIFT + 1),
	RR_LOG_LEVEL_DEBUG3 = 1 << (G_LOG_LEVEL_USER_SHIFT + 2),
	RR_LOG_LEVEL_DEBUG4 = 1 << (G_LOG_LEVEL_USER_SHIFT + 3),
	RR_LOG_LEVEL_DEBUG  = (RR_LOG_LEVEL_DEBUG1 | RR_LOG_LEVEL_DEBUG2 | 
			       RR_LOG_LEVEL_DEBUG3 | RR_LOG_LEVEL_DEBUG4),
	/* These are inappropriate but do the job.  */
	RR_LOG_LEVEL_NET_IN  = 1 << (G_LOG_LEVEL_USER_SHIFT + 4),
	RR_LOG_LEVEL_NET_OUT = 1 << (G_LOG_LEVEL_USER_SHIFT + 5),
	RR_LOG_LEVEL_NET     = (RR_LOG_LEVEL_NET_IN | RR_LOG_LEVEL_NET_OUT)
} RRLogLevelFlags;


#ifndef RR_LOG_DOMAIN
#define RR_LOG_DOMAIN "RR"
#endif


#ifdef G_HAVE_ISO_VARARGS

#ifdef RR_NO_DEBUG
#define rr_debug(...) 
#define rr_debug1(...) 
#define rr_debug2(...) 
#define rr_debug3(...) 
#define rr_debug4(...) 
#else
#define rr_debug(...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG1, __VA_ARGS__)
#define rr_debug1(...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG1, __VA_ARGS__)
#define rr_debug2(...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG2, __VA_ARGS__)
#define rr_debug3(...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG3, __VA_ARGS__)
#define rr_debug4(...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG4, __VA_ARGS__)
#endif


#elif defined(G_HAVE_GNUC_VARARGS)

#ifdef RR_NO_DEBUG
#define rr_debug(fmt...) 
#define rr_debug1(fmt...) 
#define rr_debug2(fmt...) 
#define rr_debug3(fmt...) 
#define rr_debug4(fmt...) 
#else
#define rr_debug(fmt...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG1, fmt)
#define rr_debug1(fmt...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG1, fmt)
#define rr_debug2(fmt...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG2, fmt)
#define rr_debug3(fmt...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG3, fmt)
#define rr_debug4(fmt...) \
 g_log (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG4, fmt)
#endif


#else /* No VARARGS at all */


#ifdef RR_NO_DEBUG
static void rr_debug  (const gchar *format, ...) {};
static void rr_debug1 (const gchar *format, ...) {};
static void rr_debug2 (const gchar *format, ...) {};
static void rr_debug3 (const gchar *format, ...) {};
static void rr_debug4 (const gchar *format, ...) {};
#else

static void
rr_debug (const gchar *format, ...)
{
  va_list args;
  va_start (args, format);
  g_logv (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG1, format, args);
  va_end (args);
}

static void
rr_debug1 (const gchar *format, ...)
{
  va_list args;
  va_start (args, format);
  g_logv (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG1, format, args);
  va_end (args);
}

static void
rr_debug2 (const gchar *format, ...)
{
  va_list args;
  va_start (args, format);
  g_logv (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG2, format, args);
  va_end (args);
}

static void
rr_debug3 (const gchar *format, ...)
{
  va_list args;
  va_start (args, format);
  g_logv (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG3, format, args);
  va_end (args);
}

static void
rr_debug4 (const gchar *format, ...)
{
  va_list args;
  va_start (args, format);
  g_logv (RR_LOG_DOMAIN, RR_LOG_LEVEL_DEBUG4, format, args);
  va_end (args);
}
#endif


#endif /* VARARGS */


void rr_debug_init (void);

void rr_debug_exit (void);


#ifndef RR_DEBUG_NET_ENABLE
#define rr_debug_net_log_transfer(a,b,c)
#else
void rr_debug_net_log_transfer (const void *data, size_t size, gboolean is_read);
#endif


#endif /* __RR_DEBUG_-H__ */
