/*-1 2002/05/12 09:53:13 2002/07/15 20:07:37
 * $Id: rr-channel.h,v 1.38 2002/10/06 18:17:03 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_CHANNEL_H__
#define __RR_CHANNEL_H__

typedef struct _RRChannel RRChannel;
typedef struct _RRChannelClass RRChannelClass;

#include <glib-object.h>
#include <librr/rr-connection.h>
#include <librr/message/rr-message.h>

G_BEGIN_DECLS

#define RR_DEFAULT_WINDOW_SIZE 8192

#define RR_TYPE_CHANNEL (rr_channel_get_type ())
#define RR_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_CHANNEL, RRChannel))
#define RR_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_CHANNEL, RRChannelClass))
#define RR_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_CHANNEL))
#define RR_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_CHANNEL))
#define RR_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_CHANNEL, RRChannelClass))

#define RR_CHANNEL_GTYPE_KEY_URI "RR_CHANNEL_URI"

typedef void (*RRWorkFunc) (RRChannel *channel, gpointer data);

struct _RRChannel {
	GObject parent_object;

	RRConnection *connection;

	gint32 id;
	gint32 msgno;

	guint32 seq_in;
	guint32 seq_out;

	GMutex *out_lock;
	GCond  *out_cond;
	GSList *out_queue;

	GSList *frame_list;
	gboolean aggregate_frames;
	gboolean starved;
	gboolean disabled;
	gboolean dont_queue_frames;

	gint window_in;   /* bytes left in the receive window */
	gint window_out;  /* bytes left in the outbound window */
	gint window_size; /* The receive window size */

	gchar *piggyback;

	gpointer instance_config;
	gpointer global_config;

	GMutex *mutex;
};

struct _RRChannelClass {
	GObjectClass parent_class;
	gboolean (* frame_available)   (RRChannel *channel, RRFrame *frame,
					GError **error);

	void (* close_confirmation)    (RRChannel *channel, gint code,
					const gchar *xml_lang, 
					const gchar *diagnostic);
	gboolean (* close_indication)  (RRChannel *channel, gint code,
					const gchar *xml_lang, 
					const gchar *diagnostic,
					GError **error);

	gboolean (* client_init)       (RRChannel *channel, GError **error);
	gboolean (* server_init)       (RRChannel *channel, 
					const gchar *piggyback, 
					 GError **error);

	void (* client_confirmation)   (RRChannel *channel, 
					const gchar *piggyback);
	void (* server_confirmation)   (RRChannel *channel);
};

GType rr_channel_get_type (void);

gboolean rr_channel_close (RRChannel *channel, gint code, 
			   const gchar *xml_lang, const gchar *diagnostic,
			   GError **error);


gint rr_channel_get_window_size (RRChannel *channel);
void rr_channel_set_window_size (RRChannel *channel, gint size);

void     rr_channel_set_aggregate (RRChannel *channel, gboolean aggregate);
gboolean rr_channel_get_aggregate (RRChannel *channel);

void rr_channel_set_connection (RRChannel *channel, 
				RRConnection *connection);
RRConnection *rr_channel_get_connection (RRChannel *channel);

gboolean rr_channel_close_indication (RRChannel *channel, gint code,
				      const gchar *xml_lang, 
				      const gchar *diagnostic,
				      GError **error);
void rr_channel_close_confirmation (RRChannel *channel, gint code,
				    const gchar *xml_lang, 
				    const gchar *diagnostic);
void rr_channel_frame_available (RRChannel *channel, 
				 RRFrame *frame);
gboolean rr_channel_send_frame (RRChannel *channel, 
			      RRFrame *frame, 
			      GError **error);
gboolean rr_channel_send_message (RRChannel *channel, 
				RRMessage *message, 
				GError **error);

gboolean rr_channel_client_init (RRChannel *channel, GError **error);
gboolean rr_channel_server_init (RRChannel *channel, 
				 const gchar *piggyback, GError **error);

void rr_channel_client_confirmation  (RRChannel *channel, 
				      const gchar *piggyback);
void rr_channel_server_confirmation  (RRChannel *channel);

gboolean rr_channel_flush (RRChannel *channel, GError **error);

GObject *rr_channel_get_active_item    (RRChannel *channel);
gboolean rr_channel_remove_active_item (RRChannel *channel);
gboolean rr_channel_out_queue_empty    (RRChannel *channel);

void rr_channel_register_frame (RRChannel *channel, RRFrame *frame);

const gchar *rr_channel_get_uri (GType type);
void rr_channel_set_uri (GType type, const gchar *uri);

const gchar *rr_channel_get_piggyback (RRChannel *channel);
void rr_channel_set_piggyback (RRChannel *channel, const gchar *piggyback);

void rr_channel_lock (RRChannel *channel);
void rr_channel_unlock (RRChannel *channel);

G_END_DECLS

#endif /* __RR_CHANNEL_H__ */
