/*-
 * $Id: rr-beeperror.c,v 1.5 2002/05/11 17:54:00 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>
#include <librr/rr-beeperror-priv.h>

extern const RRBeepLangIso rr_langs[];
extern const RRBeepError rr_errors_en[];
extern const RRBeepError rr_errors_sv[];
extern const RRBeepErrorTable rr_errors[];

static const gint rr_numlangs = sizeof (rr_langs) / sizeof (RRBeepLangIso);


GQuark
rr_beep_error_quark (void)
{
	static GQuark quark;
	if (!quark)
		quark = g_quark_from_static_string ("rr_beep_error");
	return quark;
}


RRBeepLang
rr_beep_error_get_supported_lang (const gchar *langtokens)
{
	gchar **langs;
	gchar **iso;
	RRBeepLang lang = RR_BEEP_LANG_DEFAULT;

	langs = g_strsplit (langtokens, " ", 0);

	iso = langs;
	while (*iso) {
		g_print ("testing lang: %s\n", *iso);
		lang = rr_beep_error_get_lang (*iso);
		if (lang) {
			g_print ("prefferred language: %s\n", *iso);
			break;
		}
		iso++;
	}

	g_strfreev (langs);

	return lang;
}

gchar *
rr_beep_error_get_lang_iso (RRBeepLang lang)
{
	gint i;

	for (i = 0; i < rr_numlangs; i++) {
		if (rr_langs[i].lang == lang) {
			return g_strdup (rr_langs[i].isocode);
		}
	}

	return NULL;
}


RRBeepLang 
rr_beep_error_get_lang (const gchar *isolang)
{
	gint i;

	if (isolang) {
		for (i=0; i<rr_numlangs; i++) {
			if (0 == g_ascii_strcasecmp (rr_langs[i].isocode, 
						     isolang)) {

				return rr_langs[i].lang;
			}
		}
	}

	return 0;
}


gchar *
rr_beep_error_get_message (RRBeepReplyCode code, RRBeepLang lang)
{
	gint i;
	gint errtable;
	gint numerrs, numlangs;

	numerrs = (sizeof (rr_errors_en) / sizeof (RRBeepError));
	numlangs = (sizeof (rr_errors) / sizeof (RRBeepErrorTable));
	errtable = 0;

	while (errtable < numlangs && rr_errors[errtable].lang != lang) {
		errtable++;
	}
	for (i = 0; i < numerrs; i++) {
		if (rr_errors[errtable].errors[i].code == code) {
			return g_strdup (rr_errors[errtable].errors[i].msg);
		}
	}
	if (code != RR_BEEP_CODE_UNKNOWN) {
		return rr_beep_error_get_message (RR_BEEP_CODE_UNKNOWN, lang);
	}

	return NULL;
}



gchar *
rr_beep_error_get_message_iso (RRBeepReplyCode code, const gchar *isolang)
{
	return rr_beep_error_get_message (code, 
					  rr_beep_error_get_lang (isolang));
}
