/*-
 * $Id: rr-beeperror-priv.h,v 1.3 2002/05/11 17:54:00 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_BEEP_ERROR_PRIV_H__
#define __RR_BEEP_ERROR_PRIV_H__

#include <librr/rr-beeperror.h>

/* Map enum to iso string representations  */
const RRBeepLangIso rr_langs[] = {
	{RR_BEEP_LANG_EN, "en"},
	{RR_BEEP_LANG_SV, "sv"}
};

/* English error messages */
const RRBeepError rr_errors_en[] = {
	{RR_BEEP_CODE_UNKNOWN,   "Unknown result"},
	{RR_BEEP_CODE_SUCCESS,   "Success"}, 
	{RR_BEEP_CODE_NO_ACTION, "No action"},
	{RR_BEEP_CODE_ABORTED,   "Aborted"}
};



/* Swedish error messages */
const RRBeepError rr_errors_sv[] = {
	{RR_BEEP_CODE_UNKNOWN,   "Oknt resultat"},
	{RR_BEEP_CODE_SUCCESS,   "Fantastiskt gott"}, 
	{RR_BEEP_CODE_NO_ACTION, "Fr lat fr att gra nt"},
	{RR_BEEP_CODE_ABORTED,   "Det sket sig storartat"}
};

/* All errors */
const RRBeepErrorTable rr_errors[] = {
	{RR_BEEP_LANG_EN, (RRBeepError *) rr_errors_en},
	{RR_BEEP_LANG_SV, (RRBeepError *) rr_errors_sv}
};

#endif /* __RR_BEEP_ERROR_PRIV_H__ */
