/*-
 * $Id: rr-message.h,v 1.13 2002/12/12 14:59:53 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_MESSAGE_H__
#define __RR_MESSAGE_H__

typedef struct _RRMessage RRMessage;
typedef struct _RRMessageClass RRMessageClass;

#include <librr/rr-channel.h>
#include <librr/rr-frame.h>

G_BEGIN_DECLS

#define RR_TYPE_MESSAGE (rr_message_get_type ())
#define RR_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_MESSAGE, RRMessage))
#define RR_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_MESSAGE, RRMessageClass))
#define RR_IS_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_MESSAGE))
#define RR_IS_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_MESSAGE))
#define RR_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_MESSAGE, RRMessageClass))

struct _RRMessage {
	GObject parent_object;
	RRChannel *channel;

	RRFrameType type;
	/* <private> */
	GSList *frame_list;
	gboolean aggregate_frames;

	gint32 msgno, ansno;
};

struct _RRMessageClass {
	GObjectClass parent_class;

	RRFrame *(* get_frame)     (RRMessage *message, gsize max_size);
	gboolean (* process_frame) (RRMessage *message, RRFrame *frame, 
				    GError **error);
};

GType    rr_message_get_type      (void);

void     rr_message_set_aggregate (RRMessage *message, gboolean aggregate);
gboolean rr_message_get_aggregate (RRMessage *message);

RRFrame *rr_message_get_frame     (RRMessage *message, gsize max_size);

gboolean rr_message_process_frame (RRMessage *message, RRFrame *frame, 
				   GError **error);

void rr_message_set_channel       (RRMessage *message, RRChannel *channel);

G_END_DECLS

#endif /* __RR_MESSAGE_H__ */
