/*-
 * $Id: rr-message-error.h,v 1.5 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_MESSAGE_ERROR_H__
#define __RR_MESSAGE_ERROR_H__

typedef struct _RRMessageError RRMessageError;
typedef struct _RRMessageErrorClass RRMessageErrorClass;

#include <librr/rr-frame.h>
#include <librr/message/rr-message.h>

G_BEGIN_DECLS

#define RR_TYPE_MESSAGE_ERROR (rr_message_error_get_type ())
#define RR_MESSAGE_ERROR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_MESSAGE_ERROR, RRMessageError))
#define RR_MESSAGE_ERROR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_MESSAGE_ERROR, RRMessageErrorClass))
#define RR_IS_MESSAGE_ERROR(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_MESSAGE_ERROR))
#define RR_IS_MESSAGE_ERROR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_MESSAGE_ERROR))
#define RR_MESSAGE_ERROR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_MESSAGE_ERROR, RRMessageErrorClass))

struct _RRMessageError {
	RRMessage parent_object;

	gint code;
	gchar *xml_lang;
	gchar *diagnostic;
};

struct _RRMessageErrorClass {
	RRMessageClass parent_class;
};

GType rr_message_error_get_type (void);

RRMessageError *rr_message_error_new (gint code, const gchar *xml_lang,
				      const gchar *diagnostic);

RRMessageError *rr_message_error_new_from_gerror (GError *error, 
						  const gchar *xml_lang);

void rr_message_error_set_gerror (RRMessageError *err, GError **error);


RRMessageError *rr_message_error_new (gint code, const gchar *xml_lang,
				      const gchar *diagnostic);



G_END_DECLS

#endif /* __RR_MESSAGE_ERROR_H__ */
