/*-
 * $Id: rr-message-close.h,v 1.5 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_MESSAGE_CLOSE_H__
#define __RR_MESSAGE_CLOSE_H__

typedef struct _RRMessageClose RRMessageClose;
typedef struct _RRMessageCloseClass RRMessageCloseClass;

#include <librr/rr-frame.h>
#include <librr/message/rr-message.h>

G_BEGIN_DECLS

#define RR_BEEP_CLOSE_OK "Content-Type: application/beep+xml\r\n\r\n" \
			 "<ok />\r\n"

#define RR_TYPE_MESSAGE_CLOSE (rr_message_close_get_type ())
#define RR_MESSAGE_CLOSE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_MESSAGE_CLOSE, RRMessageClose))
#define RR_MESSAGE_CLOSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_MESSAGE_CLOSE, RRMessageCloseClass))
#define RR_IS_MESSAGE_CLOSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_MESSAGE_CLOSE))
#define RR_IS_MESSAGE_CLOSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_MESSAGE_CLOSE))
#define RR_MESSAGE_CLOSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_MESSAGE_CLOSE, RRMessageCloseClass))

struct _RRMessageClose {
	RRMessage parent_object;

	gint channelnumber;
	gint code;
	gchar *xml_lang;
	gchar *diagnostic;

	GMutex *done_mutex;
	GCond *done_cond;
	gboolean done;
	GError *done_error;
};

struct _RRMessageCloseClass {
	RRMessageClass parent_class;
};

GType rr_message_close_get_type (void);

RRMessageClose *rr_message_close_new (gint channelnumber, gint code, 
				      const gchar *xml_lang, 
				      const gchar *diagnostic);


gboolean rr_message_close_wait_for_reply (RRMessageClose *close,
					  GError **error);

void rr_message_close_done (RRMessageClose *close, GError *error);

G_END_DECLS

#endif /* __RR_MESSAGE_CLOSE_H__ */
