/*-
 * $Id: simple-profile.c,v 1.7 2002/09/28 18:11:28 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>
#include <string.h>

#include "simple-profile.h"

#define SIMPLE_URI "http://codefactory.se/beep/simple"

#define MSG_STRING "My Message"
#define RPY_STRING "My Reply"

static gboolean frame_available (RRChannel *channel, RRFrame *frame, 
				 GError **error);

static void
rr_simple_init (GObject *object)
{
}

static void
rr_simple_class_init (GObjectClass *klass)
{
	RRChannelClass *channel_class = (RRChannelClass *)klass;

	channel_class->frame_available = frame_available;
}

GType 
rr_simple_get_type (void)
{
	static GType rr_type = 0;

	if (!rr_type) {
		static GTypeInfo type_info = {
			sizeof (RRSimpleClass),
			NULL,
			NULL,
			(GClassInitFunc) rr_simple_class_init,
			NULL,
			NULL,
			sizeof (RRSimple),
			16,
			(GInstanceInitFunc) rr_simple_init
		};
		rr_type = g_type_register_static (RR_TYPE_CHANNEL, "RRSimple", 
						  &type_info, 0);

		rr_channel_set_uri (rr_type, SIMPLE_URI);
	}
	return rr_type;
}

static gboolean
frame_available (RRChannel *channel, RRFrame *frame, GError **error)
{
	if (frame->type == RR_FRAME_TYPE_MSG) {
		RRMessage *rpy;

		g_print ("Received a MSG frame: '%s'\n", frame->payload);

		/* Send a reply */
		rpy = rr_message_static_new (RR_FRAME_TYPE_RPY, RPY_STRING, 
					     strlen (RPY_STRING), FALSE);
		/* the reply has to have the same msgno as the MSG */
		rpy->msgno = frame->msgno;
		return rr_channel_send_message (channel, rpy, error);
	}
	else if (frame->type == RR_FRAME_TYPE_RPY) {

		g_print ("Received a RPY frame: '%s'\n", frame->payload);
		return TRUE;
	}
	else {
		/* Simple error handling for unexpected frames. */
		g_set_error (error, RR_BEEP_ERROR, RR_BEEP_CODE_SYNTAX_ERROR,
			     "Unexpected frame received.");
		return FALSE;
	}
}

RRSimple *
rr_simple_start (RRConnection *connection, GError **error)
{
	RRSimple *simple;

	g_return_val_if_fail (RR_IS_CONNECTION (connection), NULL);

	if ((simple = (RRSimple *)rr_connection_start (connection, NULL, 
						    RR_TYPE_SIMPLE, NULL, 
						    error)) == NULL)
		return NULL;

	return simple;
}

gboolean
rr_simple_do_stuff (RRSimple *simple, GError **error)
{
	RRMessage *msg;

	g_return_val_if_fail (RR_IS_SIMPLE (simple), FALSE);

	msg = rr_message_static_new (RR_FRAME_TYPE_MSG, MSG_STRING, 
				     strlen (MSG_STRING), FALSE);

	return rr_channel_send_message (RR_CHANNEL (simple), msg, error);
}

gboolean
rr_simple_close (RRSimple *simple, GError **error)
{
	g_return_val_if_fail (RR_IS_SIMPLE (simple), FALSE);

	if (!rr_channel_close (RR_CHANNEL (simple), RR_BEEP_CODE_SUCCESS, 
			       NULL, "bye", error))
		return FALSE;
	
	g_object_unref (G_OBJECT (simple));

	return TRUE;
}
