/*  RetroArch - A frontend for libretro.
 *  Copyright (C) 2010-2014 - Hans-Kristian Arntzen
 *  Copyright (C) 2011-2016 - Daniel De Matteis
 *  Copyright (C) 2016-2019 - Brad Parker
 *
 *  RetroArch is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  RetroArch is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with RetroArch.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __CONFIG_DEF_KEYBINDS_H
#define __CONFIG_DEF_KEYBINDS_H

#ifndef IS_SALAMANDER

/* User 1 */
static const struct retro_keybind retro_keybinds_1[] = {
#ifdef __QNX__
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_B, RETROK_k,
      RETRO_DEVICE_ID_JOYPAD_B, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_Y, RETROK_i,
      RETRO_DEVICE_ID_JOYPAD_Y, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_SELECT, RETROK_v,
      RETRO_DEVICE_ID_JOYPAD_SELECT, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_START, RETROK_b,
      RETRO_DEVICE_ID_JOYPAD_START, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_UP, RETROK_e,
      RETRO_DEVICE_ID_JOYPAD_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_DOWN, RETROK_s,
      RETRO_DEVICE_ID_JOYPAD_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_LEFT, RETROK_w,
      RETRO_DEVICE_ID_JOYPAD_LEFT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_RIGHT, RETROK_d,
      RETRO_DEVICE_ID_JOYPAD_RIGHT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_A, RETROK_l,
      RETRO_DEVICE_ID_JOYPAD_A, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_X, RETROK_o,
      RETRO_DEVICE_ID_JOYPAD_X, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L, RETROK_f,
      RETRO_DEVICE_ID_JOYPAD_L, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R, RETROK_j,
      RETRO_DEVICE_ID_JOYPAD_R, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L2, RETROK_r,
      RETRO_DEVICE_ID_JOYPAD_L2, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R2, RETROK_u,
      RETRO_DEVICE_ID_JOYPAD_R2, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L3, RETROK_g,
      RETRO_DEVICE_ID_JOYPAD_L3, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R3, RETROK_h,
      RETRO_DEVICE_ID_JOYPAD_R3, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_X_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_X_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_Y_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_Y_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_X_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_X_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_Y_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_Y_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_TRIGGER, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_TRIGGER, RETRO_DEVICE_ID_MOUSE_LEFT, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      RARCH_LIGHTGUN_RELOAD,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_RELOAD, RETROK_UNKNOWN,
      NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_A, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_A, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_B, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_B, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_C, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_C, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_START, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_START, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_SELECT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_SELECT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_UP, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_DOWN, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_LEFT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_LEFT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_RIGHT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_RIGHT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_TURBO_ENABLE, RETROK_UNKNOWN,
      RARCH_TURBO_ENABLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_KEY, RETROK_UNKNOWN,
      RARCH_FAST_FORWARD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_HOLD_KEY, RETROK_UNKNOWN,
      RARCH_FAST_FORWARD_HOLD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION_KEY, RETROK_UNKNOWN,
      RARCH_SLOWMOTION_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION_HOLD_KEY, RETROK_UNKNOWN,
      RARCH_SLOWMOTION_HOLD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VRR_RUNLOOP_TOGGLE, RETROK_UNKNOWN,
      RARCH_VRR_RUNLOOP_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_LOAD_STATE_KEY, RETROK_UNKNOWN,
      RARCH_LOAD_STATE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SAVE_STATE_KEY, RETROK_UNKNOWN,
      RARCH_SAVE_STATE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FULLSCREEN_TOGGLE_KEY, RETROK_UNKNOWN,  
      RARCH_FULLSCREEN_TOGGLE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CLOSE_CONTENT_KEY, RETROK_UNKNOWN,
      RARCH_CLOSE_CONTENT_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_QUIT_KEY, RETROK_UNKNOWN,
      RARCH_QUIT_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_PLUS, RETROK_UNKNOWN,
      RARCH_STATE_SLOT_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_MINUS, RETROK_UNKNOWN,
      RARCH_STATE_SLOT_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_REWIND, RETROK_UNKNOWN,
      RARCH_REWIND, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_BSV_RECORD_TOGGLE, RETROK_UNKNOWN,
      RARCH_BSV_RECORD_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_PAUSE_TOGGLE, RETROK_UNKNOWN,
      RARCH_PAUSE_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FRAMEADVANCE, RETROK_UNKNOWN,
      RARCH_FRAMEADVANCE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RESET, RETROK_UNKNOWN,
      RARCH_RESET, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_NEXT, RETROK_UNKNOWN,
      RARCH_SHADER_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_PREV, RETROK_UNKNOWN,
      RARCH_SHADER_PREV, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_PLUS, RETROK_UNKNOWN,
      RARCH_CHEAT_INDEX_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_MINUS, RETROK_UNKNOWN,
      RARCH_CHEAT_INDEX_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_TOGGLE, RETROK_UNKNOWN,
      RARCH_CHEAT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SCREENSHOT, RETROK_UNKNOWN,
      RARCH_SCREENSHOT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_MUTE, RETROK_UNKNOWN,
      RARCH_MUTE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_OSK, RETROK_UNKNOWN,
      RARCH_OSK, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FPS_TOGGLE, RETROK_UNKNOWN,
      RARCH_FPS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATISTICS_TOGGLE, RETROK_UNKNOWN,
      RARCH_STATISTICS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_PING_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_PING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SEND_DEBUG_INFO, RETROK_UNKNOWN,
      RARCH_SEND_DEBUG_INFO, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_HOST_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_HOST_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_GAME_WATCH, RETROK_UNKNOWN,
      RARCH_NETPLAY_GAME_WATCH, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_PLAYER_CHAT, RETROK_UNKNOWN,
      RARCH_NETPLAY_PLAYER_CHAT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_FADE_CHAT_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_FADE_CHAT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_ENABLE_HOTKEY, RETROK_UNKNOWN,
      RARCH_ENABLE_HOTKEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_UP, RETROK_UNKNOWN,
      RARCH_VOLUME_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_DOWN, RETROK_UNKNOWN,
      RARCH_VOLUME_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_OVERLAY_NEXT, RETROK_UNKNOWN,
      RARCH_OVERLAY_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_EJECT_TOGGLE, RETROK_UNKNOWN,
      RARCH_DISK_EJECT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_NEXT, RETROK_UNKNOWN,
      RARCH_DISK_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_PREV, RETROK_UNKNOWN,
      RARCH_DISK_PREV, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_GRAB_MOUSE_TOGGLE, RETROK_UNKNOWN,
      RARCH_GRAB_MOUSE_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_GAME_FOCUS_TOGGLE, RETROK_UNKNOWN,
      RARCH_GAME_FOCUS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_UI_COMPANION_TOGGLE, RETROK_UNKNOWN,
      RARCH_UI_COMPANION_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_MENU_TOGGLE, RETROK_SPACE,
      RARCH_MENU_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RECORDING_TOGGLE, RETROK_UNKNOWN,
      RARCH_RECORDING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STREAMING_TOGGLE, RETROK_UNKNOWN,
      RARCH_STREAMING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RUNAHEAD_TOGGLE, RETROK_UNKNOWN,
      RARCH_RUNAHEAD_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_AI_SERVICE, RETROK_UNKNOWN,
      RARCH_AI_SERVICE, NO_BTN, NO_BTN, 0,
      true
   },
#elif defined(DINGUX)
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_B, RETROK_LALT,
      RETRO_DEVICE_ID_JOYPAD_B, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_Y, RETROK_LSHIFT,
      RETRO_DEVICE_ID_JOYPAD_Y, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_SELECT, RETROK_ESCAPE,
      RETRO_DEVICE_ID_JOYPAD_SELECT, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_START, RETROK_RETURN,
      RETRO_DEVICE_ID_JOYPAD_START, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_UP, RETROK_UP,
      RETRO_DEVICE_ID_JOYPAD_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_DOWN, RETROK_DOWN,
      RETRO_DEVICE_ID_JOYPAD_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_LEFT, RETROK_LEFT,
      RETRO_DEVICE_ID_JOYPAD_LEFT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_RIGHT, RETROK_RIGHT,
      RETRO_DEVICE_ID_JOYPAD_RIGHT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_A, RETROK_LCTRL,
      RETRO_DEVICE_ID_JOYPAD_A, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_X, RETROK_SPACE,
      RETRO_DEVICE_ID_JOYPAD_X, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L, RETROK_TAB,
      RETRO_DEVICE_ID_JOYPAD_L, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R, RETROK_BACKSPACE,
      RETRO_DEVICE_ID_JOYPAD_R, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L2, RETROK_PAGEUP,
      RETRO_DEVICE_ID_JOYPAD_L2, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R2, RETROK_PAGEDOWN,
      RETRO_DEVICE_ID_JOYPAD_R2, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L3, RETROK_KP_DIVIDE,
      RETRO_DEVICE_ID_JOYPAD_L3, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R3, RETROK_KP_PERIOD,
      RETRO_DEVICE_ID_JOYPAD_R3, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_X_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_X_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_Y_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_Y_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_X_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_X_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_Y_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_Y_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_TRIGGER, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_TRIGGER, RETRO_DEVICE_ID_MOUSE_LEFT, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_RELOAD, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_RELOAD, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_A, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_A, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_B, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_B, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_C, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_C, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_START, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_START, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_SELECT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_SELECT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_UP, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_DOWN, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_LEFT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_LEFT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_RIGHT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_RIGHT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_TURBO_ENABLE, RETROK_UNKNOWN,
      RARCH_TURBO_ENABLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_KEY, RETROK_UNKNOWN,
      RARCH_FAST_FORWARD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_HOLD_KEY, RETROK_UNKNOWN,
      RARCH_FAST_FORWARD_HOLD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION_KEY, RETROK_UNKNOWN,
      RARCH_SLOWMOTION_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION_HOLD_KEY, RETROK_UNKNOWN,
      RARCH_SLOWMOTION_HOLD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VRR_RUNLOOP_TOGGLE, RETROK_UNKNOWN,
      RARCH_VRR_RUNLOOP_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_LOAD_STATE_KEY, RETROK_UNKNOWN,
      RARCH_LOAD_STATE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SAVE_STATE_KEY, RETROK_UNKNOWN,
      RARCH_SAVE_STATE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FULLSCREEN_TOGGLE_KEY, RETROK_UNKNOWN,  
      RARCH_FULLSCREEN_TOGGLE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CLOSE_CONTENT_KEY, RETROK_UNKNOWN,
      RARCH_CLOSE_CONTENT_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_QUIT_KEY, RETROK_UNKNOWN,
      RARCH_QUIT_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_PLUS, RETROK_UNKNOWN,
      RARCH_STATE_SLOT_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_MINUS, RETROK_UNKNOWN,
      RARCH_STATE_SLOT_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_REWIND, RETROK_UNKNOWN,
      RARCH_REWIND, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_BSV_RECORD_TOGGLE, RETROK_UNKNOWN,
      RARCH_BSV_RECORD_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_PAUSE_TOGGLE, RETROK_UNKNOWN,
      RARCH_PAUSE_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FRAMEADVANCE, RETROK_UNKNOWN,
      RARCH_FRAMEADVANCE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RESET, RETROK_UNKNOWN,
      RARCH_RESET, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_NEXT, RETROK_UNKNOWN,
      RARCH_SHADER_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_PREV, RETROK_UNKNOWN,
      RARCH_SHADER_PREV, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_PLUS, RETROK_UNKNOWN,
      RARCH_CHEAT_INDEX_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_MINUS, RETROK_UNKNOWN,
      RARCH_CHEAT_INDEX_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_TOGGLE, RETROK_UNKNOWN,
      RARCH_CHEAT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SCREENSHOT, RETROK_UNKNOWN,
      RARCH_SCREENSHOT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_MUTE, RETROK_UNKNOWN,
      RARCH_MUTE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_OSK, RETROK_UNKNOWN,
      RARCH_OSK, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FPS_TOGGLE, RETROK_UNKNOWN,
      RARCH_FPS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATISTICS_TOGGLE, RETROK_UNKNOWN,
      RARCH_STATISTICS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_PING_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_PING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SEND_DEBUG_INFO, RETROK_UNKNOWN,
      RARCH_SEND_DEBUG_INFO, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_HOST_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_HOST_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_GAME_WATCH, RETROK_UNKNOWN,
      RARCH_NETPLAY_GAME_WATCH, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_PLAYER_CHAT, RETROK_UNKNOWN,
      RARCH_NETPLAY_PLAYER_CHAT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_FADE_CHAT_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_FADE_CHAT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_ENABLE_HOTKEY, RETROK_UNKNOWN,
      RARCH_ENABLE_HOTKEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_UP, RETROK_UNKNOWN,
      RARCH_VOLUME_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_DOWN, RETROK_UNKNOWN,
      RARCH_VOLUME_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_OVERLAY_NEXT, RETROK_UNKNOWN,
      RARCH_OVERLAY_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_EJECT_TOGGLE, RETROK_UNKNOWN,
      RARCH_DISK_EJECT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_NEXT, RETROK_UNKNOWN,
      RARCH_DISK_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_PREV, RETROK_UNKNOWN,
      RARCH_DISK_PREV, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_GRAB_MOUSE_TOGGLE, RETROK_UNKNOWN,
      RARCH_GRAB_MOUSE_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_GAME_FOCUS_TOGGLE, RETROK_UNKNOWN,
      RARCH_GAME_FOCUS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_UI_COMPANION_TOGGLE, RETROK_UNKNOWN,
      RARCH_UI_COMPANION_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_MENU_TOGGLE, RETROK_HOME,
      RARCH_MENU_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RECORDING_TOGGLE, RETROK_UNKNOWN,
      RARCH_RECORDING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STREAMING_TOGGLE, RETROK_UNKNOWN,
      RARCH_STREAMING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RUNAHEAD_TOGGLE, RETROK_UNKNOWN,
      RARCH_RUNAHEAD_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_AI_SERVICE, RETROK_UNKNOWN,
      RARCH_AI_SERVICE, NO_BTN, NO_BTN, 0,
      true
   },
#else
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_B, RETROK_z,
      RETRO_DEVICE_ID_JOYPAD_B, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_Y, RETROK_a,
      RETRO_DEVICE_ID_JOYPAD_Y, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_SELECT, RETROK_RSHIFT,
      RETRO_DEVICE_ID_JOYPAD_SELECT, NO_BTN, NO_BTN, 0,
      true
   },
   { 
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_START, RETROK_RETURN,
      RETRO_DEVICE_ID_JOYPAD_START, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_UP, RETROK_UP,
      RETRO_DEVICE_ID_JOYPAD_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_DOWN, RETROK_DOWN,
      RETRO_DEVICE_ID_JOYPAD_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_LEFT, RETROK_LEFT,
      RETRO_DEVICE_ID_JOYPAD_LEFT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_RIGHT, RETROK_RIGHT,
      RETRO_DEVICE_ID_JOYPAD_RIGHT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_A, RETROK_x,
      RETRO_DEVICE_ID_JOYPAD_A, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_X, RETROK_s,
      RETRO_DEVICE_ID_JOYPAD_X, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L, RETROK_q,
      RETRO_DEVICE_ID_JOYPAD_L, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R, RETROK_w,
      RETRO_DEVICE_ID_JOYPAD_R, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L2, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_L2, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R2, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_R2, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L3, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_L3, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R3, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_R3, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_X_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_X_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_Y_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_Y_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_X_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_X_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_Y_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_Y_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_TRIGGER, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_TRIGGER, RETRO_DEVICE_ID_MOUSE_LEFT, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_RELOAD, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_RELOAD, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_A, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_A, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_B, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_B, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_C, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_C, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_START, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_START, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_SELECT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_SELECT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_UP, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_DOWN, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_LEFT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_LEFT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_RIGHT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_RIGHT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_TURBO_ENABLE, RETROK_UNKNOWN,
      RARCH_TURBO_ENABLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_KEY, RETROK_SPACE,
      RARCH_FAST_FORWARD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_HOLD_KEY, RETROK_l,
      RARCH_FAST_FORWARD_HOLD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION_KEY, RETROK_UNKNOWN,
      RARCH_SLOWMOTION_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION_HOLD_KEY, RETROK_e,
      RARCH_SLOWMOTION_HOLD_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VRR_RUNLOOP_TOGGLE, RETROK_UNKNOWN,
      RARCH_VRR_RUNLOOP_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_LOAD_STATE_KEY, RETROK_F4,
      RARCH_LOAD_STATE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SAVE_STATE_KEY, RETROK_F2,
      RARCH_SAVE_STATE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FULLSCREEN_TOGGLE_KEY, RETROK_f,  
      RARCH_FULLSCREEN_TOGGLE_KEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CLOSE_CONTENT_KEY, RETROK_UNKNOWN,
      RARCH_CLOSE_CONTENT_KEY, NO_BTN, NO_BTN, 0,
      true
   },
#ifdef HAVE_LAKKA
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RESTART_KEY, RETROK_ESCAPE,
      RARCH_QUIT_KEY, NO_BTN, NO_BTN, 0,
      true
   },
#else
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_QUIT_KEY, RETROK_ESCAPE,
      RARCH_QUIT_KEY, NO_BTN, NO_BTN, 0,
      true
   },
#endif
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_PLUS, RETROK_F7,
      RARCH_STATE_SLOT_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_MINUS, RETROK_F6,
      RARCH_STATE_SLOT_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_REWIND, RETROK_r,
      RARCH_REWIND, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_BSV_RECORD_TOGGLE, RETROK_o,
      RARCH_BSV_RECORD_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_PAUSE_TOGGLE, RETROK_p,
      RARCH_PAUSE_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FRAMEADVANCE, RETROK_k,
      RARCH_FRAMEADVANCE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RESET, RETROK_h,
      RARCH_RESET, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_NEXT, RETROK_m,
      RARCH_SHADER_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_PREV, RETROK_n,
      RARCH_SHADER_PREV, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_PLUS, RETROK_y,
      RARCH_CHEAT_INDEX_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_MINUS, RETROK_t,
      RARCH_CHEAT_INDEX_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_TOGGLE, RETROK_u,
      RARCH_CHEAT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SCREENSHOT, RETROK_F8,
      RARCH_SCREENSHOT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_MUTE, RETROK_F9,
      RARCH_MUTE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_OSK, RETROK_F12,
      RARCH_OSK, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_FPS_TOGGLE, RETROK_F3,
      RARCH_FPS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STATISTICS_TOGGLE, RETROK_UNKNOWN,
      RARCH_STATISTICS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_PING_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_PING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_SEND_DEBUG_INFO, RETROK_F10,
      RARCH_SEND_DEBUG_INFO, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_HOST_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_HOST_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_GAME_WATCH, RETROK_i,
      RARCH_NETPLAY_GAME_WATCH, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_PLAYER_CHAT, RETROK_BACKQUOTE,
      RARCH_NETPLAY_PLAYER_CHAT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_FADE_CHAT_TOGGLE, RETROK_UNKNOWN,
      RARCH_NETPLAY_FADE_CHAT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_ENABLE_HOTKEY, RETROK_UNKNOWN,
      RARCH_ENABLE_HOTKEY, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_UP, RETROK_KP_PLUS,
      RARCH_VOLUME_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_DOWN, RETROK_KP_MINUS,
      RARCH_VOLUME_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_OVERLAY_NEXT, RETROK_UNKNOWN,
      RARCH_OVERLAY_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_EJECT_TOGGLE, RETROK_UNKNOWN,
      RARCH_DISK_EJECT_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_NEXT, RETROK_UNKNOWN,
      RARCH_DISK_NEXT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_PREV, RETROK_UNKNOWN,
      RARCH_DISK_PREV, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_GRAB_MOUSE_TOGGLE, RETROK_F11,
      RARCH_GRAB_MOUSE_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_GAME_FOCUS_TOGGLE, RETROK_SCROLLOCK,
      RARCH_GAME_FOCUS_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_UI_COMPANION_TOGGLE, RETROK_F5,
      RARCH_UI_COMPANION_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_MENU_TOGGLE, RETROK_F1,
      RARCH_MENU_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RECORDING_TOGGLE, RETROK_UNKNOWN,
      RARCH_RECORDING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_STREAMING_TOGGLE, RETROK_UNKNOWN,
      RARCH_STREAMING_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_RUNAHEAD_TOGGLE, RETROK_UNKNOWN,
      RARCH_RUNAHEAD_TOGGLE, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_META_AI_SERVICE, RETROK_UNKNOWN,
      RARCH_AI_SERVICE, NO_BTN, NO_BTN, 0,
      true
   },
#endif
};

/* Users 2 to MAX_USERS */
static const struct retro_keybind retro_keybinds_rest[] = {
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_B, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_B, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_Y, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_Y, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_SELECT, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_SELECT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_START, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_START, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_UP, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_DOWN, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_LEFT, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_LEFT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_RIGHT, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_RIGHT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_A, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_A, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_X, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_X, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_L, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_R, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L2, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_L2, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R2, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_R2, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L3, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_L3, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R3, RETROK_UNKNOWN,
      RETRO_DEVICE_ID_JOYPAD_R3, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_X_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_X_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_Y_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_LEFT_Y_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_X_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_X_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_PLUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_Y_PLUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_MINUS, RETROK_UNKNOWN,
      RARCH_ANALOG_RIGHT_Y_MINUS, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_TRIGGER, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_TRIGGER, RETRO_DEVICE_ID_MOUSE_LEFT, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_RELOAD, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_RELOAD, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_A, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_A, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_B, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_B, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_C, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_AUX_C, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_START, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_START, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_SELECT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_SELECT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_UP, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_UP, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_DOWN, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_DOWN, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_LEFT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_LEFT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_RIGHT, RETROK_UNKNOWN,
      RARCH_LIGHTGUN_DPAD_RIGHT, NO_BTN, NO_BTN, 0,
      true
   },
   {
      NULL, NULL,
      AXIS_NONE, AXIS_NONE, AXIS_NONE,
      MENU_ENUM_LABEL_VALUE_INPUT_TURBO_ENABLE, RETROK_UNKNOWN,
      RARCH_TURBO_ENABLE, NO_BTN, NO_BTN, 0,
      true
   },
};

#endif

#endif
