// Copyright 2010-2012 RethinkDB, all rights reserved.
#ifndef RPC_SERIALIZE_MACROS_HPP_
#define RPC_SERIALIZE_MACROS_HPP_

/* This file is automatically generated by '../scripts/generate_serialize_macros.py'.
Please modify '../scripts/generate_serialize_macros.py' instead of modifying this file.*/

#include "containers/archive/archive.hpp"

/* The purpose of these macros is to make it easier to serialize and
unserialize data types that consist of a simple series of fields, each of which
is serializable. Suppose we have a type "struct point_t { int x, y; }" that we
want to be able to serialize. To make it serializable automatically, either
write RDB_MAKE_SERIALIZABLE_2(point_t, x, y) at the global scope or write
RDB_MAKE_ME_SERIALIZABLE(x, y) within the body of the point_t type.
The reason for the second form is to make it possible to serialize template
types. There is at present no non-intrusive way to use these macros to
serialize template types; this is less-than-ideal, but not worth fixing right
now.

A note about "dont_use_RDB_MAKE_SERIALIZABLE_within_a_class_body": It's wrong
to invoke RDB_MAKE_SERIALIZABLE_*() within the body of a class. You should
invoke it at global scope after the class declaration, or use
RDB_MAKE_ME_SERIALIZABLE_*() instead. In order to force the compiler to catch
this error, we declare a dummy "extern int" in RDB_MAKE_ME_SERIALIZABLE_*().
This is a noop at the global scope, but produces a (somewhat weird) error in
the class scope. */

#define RDB_DECLARE_SERIALIZABLE(type_t) \
    write_message_t &operator<<(write_message_t &, const type_t &); \
    MUST_USE archive_result_t deserialize(read_stream_t *s, type_t *thing)

#define RDB_DECLARE_ME_SERIALIZABLE \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const; \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s)

#define RDB_EXPAND_SERIALIZABLE_0(function_attr, type_t) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, UNUSED const type_t &thing) { \
    return msg; \
    } \
    function_attr archive_result_t deserialize(UNUSED read_stream_t *s, UNUSED type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_0(...) RDB_EXPAND_SERIALIZABLE_0(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_0(...) RDB_EXPAND_SERIALIZABLE_0(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_0() \
    friend class write_message_t; \
    void rdb_serialize(UNUSED write_message_t &msg /* NOLINT */) const { \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(UNUSED read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_0(typ) \
    void typ::rdb_serialize(UNUSED write_message_t &msg /* NOLINT */) const { \
    } \
    archive_result_t typ::rdb_deserialize(UNUSED read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_1(function_attr, type_t, field1) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_1(...) RDB_EXPAND_SERIALIZABLE_1(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_1(...) RDB_EXPAND_SERIALIZABLE_1(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_1(field1) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_1(typ, field1) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_2(function_attr, type_t, field1, field2) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_2(...) RDB_EXPAND_SERIALIZABLE_2(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_2(...) RDB_EXPAND_SERIALIZABLE_2(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_2(field1, field2) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_2(typ, field1, field2) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_3(function_attr, type_t, field1, field2, field3) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_3(...) RDB_EXPAND_SERIALIZABLE_3(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_3(...) RDB_EXPAND_SERIALIZABLE_3(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_3(field1, field2, field3) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_3(typ, field1, field2, field3) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_4(function_attr, type_t, field1, field2, field3, field4) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_4(...) RDB_EXPAND_SERIALIZABLE_4(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_4(...) RDB_EXPAND_SERIALIZABLE_4(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_4(field1, field2, field3, field4) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_4(typ, field1, field2, field3, field4) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_5(function_attr, type_t, field1, field2, field3, field4, field5) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_5(...) RDB_EXPAND_SERIALIZABLE_5(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_5(...) RDB_EXPAND_SERIALIZABLE_5(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_5(field1, field2, field3, field4, field5) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_5(typ, field1, field2, field3, field4, field5) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_6(function_attr, type_t, field1, field2, field3, field4, field5, field6) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_6(...) RDB_EXPAND_SERIALIZABLE_6(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_6(...) RDB_EXPAND_SERIALIZABLE_6(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_6(field1, field2, field3, field4, field5, field6) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_6(typ, field1, field2, field3, field4, field5, field6) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_7(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_7(...) RDB_EXPAND_SERIALIZABLE_7(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_7(...) RDB_EXPAND_SERIALIZABLE_7(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_7(field1, field2, field3, field4, field5, field6, field7) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_7(typ, field1, field2, field3, field4, field5, field6, field7) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_8(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_8(...) RDB_EXPAND_SERIALIZABLE_8(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_8(...) RDB_EXPAND_SERIALIZABLE_8(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_8(field1, field2, field3, field4, field5, field6, field7, field8) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_8(typ, field1, field2, field3, field4, field5, field6, field7, field8) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_9(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_9(...) RDB_EXPAND_SERIALIZABLE_9(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_9(...) RDB_EXPAND_SERIALIZABLE_9(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_9(field1, field2, field3, field4, field5, field6, field7, field8, field9) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_9(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_10(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_10(...) RDB_EXPAND_SERIALIZABLE_10(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_10(...) RDB_EXPAND_SERIALIZABLE_10(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_10(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_10(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_11(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_11(...) RDB_EXPAND_SERIALIZABLE_11(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_11(...) RDB_EXPAND_SERIALIZABLE_11(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_11(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_11(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_12(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
        msg << thing.field12; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field12)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_12(...) RDB_EXPAND_SERIALIZABLE_12(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_12(...) RDB_EXPAND_SERIALIZABLE_12(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_12(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_12(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_13(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
        msg << thing.field12; \
        msg << thing.field13; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field13)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_13(...) RDB_EXPAND_SERIALIZABLE_13(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_13(...) RDB_EXPAND_SERIALIZABLE_13(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_13(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_13(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_14(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
        msg << thing.field12; \
        msg << thing.field13; \
        msg << thing.field14; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field14)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_14(...) RDB_EXPAND_SERIALIZABLE_14(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_14(...) RDB_EXPAND_SERIALIZABLE_14(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_14(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_14(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_15(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
        msg << thing.field12; \
        msg << thing.field13; \
        msg << thing.field14; \
        msg << thing.field15; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field15)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_15(...) RDB_EXPAND_SERIALIZABLE_15(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_15(...) RDB_EXPAND_SERIALIZABLE_15(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_15(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_15(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_16(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
        msg << thing.field12; \
        msg << thing.field13; \
        msg << thing.field14; \
        msg << thing.field15; \
        msg << thing.field16; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field16)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_16(...) RDB_EXPAND_SERIALIZABLE_16(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_16(...) RDB_EXPAND_SERIALIZABLE_16(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_16(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
        msg << field16; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field16)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_16(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
        msg << field16; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field16)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_17(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
        msg << thing.field12; \
        msg << thing.field13; \
        msg << thing.field14; \
        msg << thing.field15; \
        msg << thing.field16; \
        msg << thing.field17; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field17)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_17(...) RDB_EXPAND_SERIALIZABLE_17(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_17(...) RDB_EXPAND_SERIALIZABLE_17(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_17(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
        msg << field16; \
        msg << field17; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field17)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_17(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
        msg << field16; \
        msg << field17; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field17)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_18(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
        msg << thing.field12; \
        msg << thing.field13; \
        msg << thing.field14; \
        msg << thing.field15; \
        msg << thing.field16; \
        msg << thing.field17; \
        msg << thing.field18; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field17)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field18)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_18(...) RDB_EXPAND_SERIALIZABLE_18(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_18(...) RDB_EXPAND_SERIALIZABLE_18(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_18(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
        msg << field16; \
        msg << field17; \
        msg << field18; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field17)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field18)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_18(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
        msg << field16; \
        msg << field17; \
        msg << field18; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field17)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field18)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_EXPAND_SERIALIZABLE_19(function_attr, type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19) \
    function_attr write_message_t &operator<<(write_message_t &msg /* NOLINT */, const type_t &thing) { \
        msg << thing.field1; \
        msg << thing.field2; \
        msg << thing.field3; \
        msg << thing.field4; \
        msg << thing.field5; \
        msg << thing.field6; \
        msg << thing.field7; \
        msg << thing.field8; \
        msg << thing.field9; \
        msg << thing.field10; \
        msg << thing.field11; \
        msg << thing.field12; \
        msg << thing.field13; \
        msg << thing.field14; \
        msg << thing.field15; \
        msg << thing.field16; \
        msg << thing.field17; \
        msg << thing.field18; \
        msg << thing.field19; \
    return msg; \
    } \
    function_attr archive_result_t deserialize(read_stream_t *s, type_t *thing) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(thing->field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field17)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field18)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(thing->field19)); \
        if (res) { return res; } \
        return res; \
    } \
    extern int dont_use_RDB_EXPAND_SERIALIZABLE_within_a_class_body
#define RDB_MAKE_SERIALIZABLE_19(...) RDB_EXPAND_SERIALIZABLE_19(inline, __VA_ARGS__)
#define RDB_IMPL_SERIALIZABLE_19(...) RDB_EXPAND_SERIALIZABLE_19(, __VA_ARGS__)

#define RDB_MAKE_ME_SERIALIZABLE_19(field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19) \
    friend class write_message_t; \
    void rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
        msg << field16; \
        msg << field17; \
        msg << field18; \
        msg << field19; \
    } \
    friend class archive_deserializer_t; \
    archive_result_t rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field17)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field18)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field19)); \
        if (res) { return res; } \
        return res; \
    }

#define RDB_IMPL_ME_SERIALIZABLE_19(typ, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19) \
    void typ::rdb_serialize(write_message_t &msg /* NOLINT */) const { \
        msg << field1; \
        msg << field2; \
        msg << field3; \
        msg << field4; \
        msg << field5; \
        msg << field6; \
        msg << field7; \
        msg << field8; \
        msg << field9; \
        msg << field10; \
        msg << field11; \
        msg << field12; \
        msg << field13; \
        msg << field14; \
        msg << field15; \
        msg << field16; \
        msg << field17; \
        msg << field18; \
        msg << field19; \
    } \
    archive_result_t typ::rdb_deserialize(read_stream_t *s) { \
        archive_result_t res = ARCHIVE_SUCCESS; \
        res = deserialize(s, deserialize_deref(field1)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field2)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field3)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field4)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field5)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field6)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field7)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field8)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field9)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field10)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field11)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field12)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field13)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field14)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field15)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field16)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field17)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field18)); \
        if (res) { return res; } \
        res = deserialize(s, deserialize_deref(field19)); \
        if (res) { return res; } \
        return res; \
    }

#endif // RPC_SERIALIZE_MACROS_HPP_
