// Copyright 2010-2012 RethinkDB, all rights reserved.
#ifndef RPC_SEMILATTICE_JOINS_MACROS_HPP_
#define RPC_SEMILATTICE_JOINS_MACROS_HPP_

/* This file is automatically generated by '../scripts/generate_join_macros.py'.
Please modify '../scripts/generate_join_macros.py' instead of modifying this file.*/

/* The purpose of these macros is to make it easier to define semilattice joins
for types that consist of a fixed set of fields which it is a simple product of.
In the same namespace as the type, call `RDB_MAKE_SEMILATTICE_JOINABLE_[n]()`,
where `[n]` is the number of fields in the type. The first parameter is the name
of the type; the remaining parameters are the fields. You will also need an
`==` operator; for this you can use `RDB_MAKE_EQUALITY_COMPARABLE_[n]()`.

Example:
    struct point_t {
        vclock_t<int> x, y;
    };
    RDB_MAKE_SEMILATTICE_JOINABLE_2(point_t, x, y)

You can also use this with templated types, but it's pretty hacky:
    template<class T>
    struct pair_t {
        T a, b;
    };
    template<class T>
    RDB_MAKE_SEMILATTICE_JOINABLE_2(pair_t<T>, a, b)
*/

#define RDB_MAKE_SEMILATTICE_JOINABLE_0(type_t) \
    inline void semilattice_join(UNUSED type_t *_a_, UNUSED const type_t &_b_) { \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_0(type_t) \
    inline bool operator==(UNUSED const type_t &_a_, UNUSED const type_t &_b_) { \
        return true; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_1(type_t, field1) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_1(type_t, field1) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_2(type_t, field1, field2) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_2(type_t, field1, field2) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_3(type_t, field1, field2, field3) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_3(type_t, field1, field2, field3) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_4(type_t, field1, field2, field3, field4) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_4(type_t, field1, field2, field3, field4) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_5(type_t, field1, field2, field3, field4, field5) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_5(type_t, field1, field2, field3, field4, field5) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_6(type_t, field1, field2, field3, field4, field5, field6) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_6(type_t, field1, field2, field3, field4, field5, field6) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_7(type_t, field1, field2, field3, field4, field5, field6, field7) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_7(type_t, field1, field2, field3, field4, field5, field6, field7) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_8(type_t, field1, field2, field3, field4, field5, field6, field7, field8) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_8(type_t, field1, field2, field3, field4, field5, field6, field7, field8) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_9(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_9(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_10(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_10(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_11(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_11(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_12(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
        semilattice_join(&_a_->field12, _b_.field12); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_12(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11 && _a_.field12 == _b_.field12; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_13(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
        semilattice_join(&_a_->field12, _b_.field12); \
        semilattice_join(&_a_->field13, _b_.field13); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_13(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11 && _a_.field12 == _b_.field12 && _a_.field13 == _b_.field13; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_14(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
        semilattice_join(&_a_->field12, _b_.field12); \
        semilattice_join(&_a_->field13, _b_.field13); \
        semilattice_join(&_a_->field14, _b_.field14); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_14(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11 && _a_.field12 == _b_.field12 && _a_.field13 == _b_.field13 && _a_.field14 == _b_.field14; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_15(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
        semilattice_join(&_a_->field12, _b_.field12); \
        semilattice_join(&_a_->field13, _b_.field13); \
        semilattice_join(&_a_->field14, _b_.field14); \
        semilattice_join(&_a_->field15, _b_.field15); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_15(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11 && _a_.field12 == _b_.field12 && _a_.field13 == _b_.field13 && _a_.field14 == _b_.field14 && _a_.field15 == _b_.field15; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_16(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
        semilattice_join(&_a_->field12, _b_.field12); \
        semilattice_join(&_a_->field13, _b_.field13); \
        semilattice_join(&_a_->field14, _b_.field14); \
        semilattice_join(&_a_->field15, _b_.field15); \
        semilattice_join(&_a_->field16, _b_.field16); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_16(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11 && _a_.field12 == _b_.field12 && _a_.field13 == _b_.field13 && _a_.field14 == _b_.field14 && _a_.field15 == _b_.field15 && _a_.field16 == _b_.field16; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_17(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
        semilattice_join(&_a_->field12, _b_.field12); \
        semilattice_join(&_a_->field13, _b_.field13); \
        semilattice_join(&_a_->field14, _b_.field14); \
        semilattice_join(&_a_->field15, _b_.field15); \
        semilattice_join(&_a_->field16, _b_.field16); \
        semilattice_join(&_a_->field17, _b_.field17); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_17(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11 && _a_.field12 == _b_.field12 && _a_.field13 == _b_.field13 && _a_.field14 == _b_.field14 && _a_.field15 == _b_.field15 && _a_.field16 == _b_.field16 && _a_.field17 == _b_.field17; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_18(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
        semilattice_join(&_a_->field12, _b_.field12); \
        semilattice_join(&_a_->field13, _b_.field13); \
        semilattice_join(&_a_->field14, _b_.field14); \
        semilattice_join(&_a_->field15, _b_.field15); \
        semilattice_join(&_a_->field16, _b_.field16); \
        semilattice_join(&_a_->field17, _b_.field17); \
        semilattice_join(&_a_->field18, _b_.field18); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_18(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11 && _a_.field12 == _b_.field12 && _a_.field13 == _b_.field13 && _a_.field14 == _b_.field14 && _a_.field15 == _b_.field15 && _a_.field16 == _b_.field16 && _a_.field17 == _b_.field17 && _a_.field18 == _b_.field18; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#define RDB_MAKE_SEMILATTICE_JOINABLE_19(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19) \
    inline void semilattice_join(type_t *_a_, const type_t &_b_) { \
        semilattice_join(&_a_->field1, _b_.field1); \
        semilattice_join(&_a_->field2, _b_.field2); \
        semilattice_join(&_a_->field3, _b_.field3); \
        semilattice_join(&_a_->field4, _b_.field4); \
        semilattice_join(&_a_->field5, _b_.field5); \
        semilattice_join(&_a_->field6, _b_.field6); \
        semilattice_join(&_a_->field7, _b_.field7); \
        semilattice_join(&_a_->field8, _b_.field8); \
        semilattice_join(&_a_->field9, _b_.field9); \
        semilattice_join(&_a_->field10, _b_.field10); \
        semilattice_join(&_a_->field11, _b_.field11); \
        semilattice_join(&_a_->field12, _b_.field12); \
        semilattice_join(&_a_->field13, _b_.field13); \
        semilattice_join(&_a_->field14, _b_.field14); \
        semilattice_join(&_a_->field15, _b_.field15); \
        semilattice_join(&_a_->field16, _b_.field16); \
        semilattice_join(&_a_->field17, _b_.field17); \
        semilattice_join(&_a_->field18, _b_.field18); \
        semilattice_join(&_a_->field19, _b_.field19); \
    } \
    extern int semilattice_joinable_force_semicolon_declaration
#define RDB_MAKE_EQUALITY_COMPARABLE_19(type_t, field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19) \
    inline bool operator==(const type_t &_a_, const type_t &_b_) { \
        return _a_.field1 == _b_.field1 && _a_.field2 == _b_.field2 && _a_.field3 == _b_.field3 && _a_.field4 == _b_.field4 && _a_.field5 == _b_.field5 && _a_.field6 == _b_.field6 && _a_.field7 == _b_.field7 && _a_.field8 == _b_.field8 && _a_.field9 == _b_.field9 && _a_.field10 == _b_.field10 && _a_.field11 == _b_.field11 && _a_.field12 == _b_.field12 && _a_.field13 == _b_.field13 && _a_.field14 == _b_.field14 && _a_.field15 == _b_.field15 && _a_.field16 == _b_.field16 && _a_.field17 == _b_.field17 && _a_.field18 == _b_.field18 && _a_.field19 == _b_.field19; \
    } \
    extern int semilattice_joinable_force_semicolon_declaration

#endif  // RPC_SEMILATTICE_JOINS_MACROS_HPP_
