// Copyright 2010-2012 RethinkDB, all rights reserved.
#ifndef RPC_MAILBOX_TYPED_HPP_
#define RPC_MAILBOX_TYPED_HPP_

/* This file is automatically generated by '../scripts/generate_rpc_templates.py'.
Please modify '../scripts/generate_rpc_templates.py' instead of modifying this file.*/

#include "errors.hpp"
#include <boost/bind.hpp>
#include <boost/function.hpp>

#include "containers/archive/archive.hpp"
#include "rpc/serialize_macros.hpp"
#include "rpc/mailbox/mailbox.hpp"

template <class> class mailbox_t;

template <class T>
class mailbox_addr_t {
public:
    bool is_nil() const { return addr.is_nil(); }
    peer_id_t get_peer() const { return addr.get_peer(); }

    friend class mailbox_t<T>;

    RDB_MAKE_ME_SERIALIZABLE_1(addr);

private:
    friend void send(mailbox_manager_t *, mailbox_addr_t<void()>);
    template <class a0_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t) >::address_t, const a0_t&);
    template <class a0_t, class a1_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t) >::address_t, const a0_t&, const a1_t&);
    template <class a0_t, class a1_t, class a2_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t) >::address_t, const a0_t&, const a1_t&, const a2_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t, class a10_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t, a10_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&, const a10_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t, class a10_t, class a11_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t, a10_t, a11_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&, const a10_t&, const a11_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t, class a10_t, class a11_t, class a12_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t, a10_t, a11_t, a12_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&, const a10_t&, const a11_t&, const a12_t&);
    template <class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t, class a10_t, class a11_t, class a12_t, class a13_t>
    friend void send(mailbox_manager_t *,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t, a10_t, a11_t, a12_t, a13_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&, const a10_t&, const a11_t&, const a12_t&, const a13_t&);

    raw_mailbox_t::address_t addr;
};

template<>
class mailbox_t< void() > {
    class write_impl_t : public mailbox_write_callback_t {
    public:
        write_impl_t() { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void() > *_parent) : parent(_parent) { }
        void read(UNUSED read_stream_t *stream) {
            parent->fun();
        }
    private:
        mailbox_t< void() > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void() > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void()> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    friend void send(mailbox_manager_t*, address_t);

    boost::function< void() > fun;
    raw_mailbox_t mailbox;
};

inline
void send(mailbox_manager_t *src,
           mailbox_t< void() >::address_t dest) {
    mailbox_t< void() >::write_impl_t writer;
    send(src, dest.addr, &writer);
}


template<class arg0_t>
class mailbox_t< void(arg0_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
    public:
        explicit write_impl_t(const arg0_t& _arg0) :
            arg0(_arg0)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0);
        }
    private:
        mailbox_t< void(arg0_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t) >::address_t, const a0_t&);

    boost::function< void(arg0_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t) >::address_t dest, const arg0_t &arg0) {
    typename mailbox_t< void(arg0_t) >::write_impl_t writer(arg0);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t>
class mailbox_t< void(arg0_t, arg1_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1) :
            arg0(_arg0), arg1(_arg1)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t) >::address_t, const a0_t&, const a1_t&);

    boost::function< void(arg0_t, arg1_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1) {
    typename mailbox_t< void(arg0_t, arg1_t) >::write_impl_t writer(arg0, arg1);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t) >::address_t, const a0_t&, const a1_t&, const a2_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t) >::write_impl_t writer(arg0, arg1, arg2);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t) >::write_impl_t writer(arg0, arg1, arg2, arg3);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
        const arg6_t &arg6;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5, const arg6_t& _arg6) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5), arg6(_arg6)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            msg << arg6;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            arg6_t arg6;
            res = deserialize(stream, &arg6);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5, const arg6_t &arg6) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
        const arg6_t &arg6;
        const arg7_t &arg7;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5, const arg6_t& _arg6, const arg7_t& _arg7) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5), arg6(_arg6), arg7(_arg7)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            msg << arg6;
            msg << arg7;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            arg6_t arg6;
            res = deserialize(stream, &arg6);
            if (res) { throw fake_archive_exc_t(); }
            arg7_t arg7;
            res = deserialize(stream, &arg7);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5, const arg6_t &arg6, const arg7_t &arg7) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
        const arg6_t &arg6;
        const arg7_t &arg7;
        const arg8_t &arg8;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5, const arg6_t& _arg6, const arg7_t& _arg7, const arg8_t& _arg8) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5), arg6(_arg6), arg7(_arg7), arg8(_arg8)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            msg << arg6;
            msg << arg7;
            msg << arg8;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            arg6_t arg6;
            res = deserialize(stream, &arg6);
            if (res) { throw fake_archive_exc_t(); }
            arg7_t arg7;
            res = deserialize(stream, &arg7);
            if (res) { throw fake_archive_exc_t(); }
            arg8_t arg8;
            res = deserialize(stream, &arg8);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5, const arg6_t &arg6, const arg7_t &arg7, const arg8_t &arg8) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
        const arg6_t &arg6;
        const arg7_t &arg7;
        const arg8_t &arg8;
        const arg9_t &arg9;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5, const arg6_t& _arg6, const arg7_t& _arg7, const arg8_t& _arg8, const arg9_t& _arg9) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5), arg6(_arg6), arg7(_arg7), arg8(_arg8), arg9(_arg9)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            msg << arg6;
            msg << arg7;
            msg << arg8;
            msg << arg9;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            arg6_t arg6;
            res = deserialize(stream, &arg6);
            if (res) { throw fake_archive_exc_t(); }
            arg7_t arg7;
            res = deserialize(stream, &arg7);
            if (res) { throw fake_archive_exc_t(); }
            arg8_t arg8;
            res = deserialize(stream, &arg8);
            if (res) { throw fake_archive_exc_t(); }
            arg9_t arg9;
            res = deserialize(stream, &arg9);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5, const arg6_t &arg6, const arg7_t &arg7, const arg8_t &arg8, const arg9_t &arg9) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t, class arg10_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
        const arg6_t &arg6;
        const arg7_t &arg7;
        const arg8_t &arg8;
        const arg9_t &arg9;
        const arg10_t &arg10;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5, const arg6_t& _arg6, const arg7_t& _arg7, const arg8_t& _arg8, const arg9_t& _arg9, const arg10_t& _arg10) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5), arg6(_arg6), arg7(_arg7), arg8(_arg8), arg9(_arg9), arg10(_arg10)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            msg << arg6;
            msg << arg7;
            msg << arg8;
            msg << arg9;
            msg << arg10;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            arg6_t arg6;
            res = deserialize(stream, &arg6);
            if (res) { throw fake_archive_exc_t(); }
            arg7_t arg7;
            res = deserialize(stream, &arg7);
            if (res) { throw fake_archive_exc_t(); }
            arg8_t arg8;
            res = deserialize(stream, &arg8);
            if (res) { throw fake_archive_exc_t(); }
            arg9_t arg9;
            res = deserialize(stream, &arg9);
            if (res) { throw fake_archive_exc_t(); }
            arg10_t arg10;
            res = deserialize(stream, &arg10);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t, class a10_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t, a10_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&, const a10_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t, class arg10_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5, const arg6_t &arg6, const arg7_t &arg7, const arg8_t &arg8, const arg9_t &arg9, const arg10_t &arg10) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t, class arg10_t, class arg11_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
        const arg6_t &arg6;
        const arg7_t &arg7;
        const arg8_t &arg8;
        const arg9_t &arg9;
        const arg10_t &arg10;
        const arg11_t &arg11;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5, const arg6_t& _arg6, const arg7_t& _arg7, const arg8_t& _arg8, const arg9_t& _arg9, const arg10_t& _arg10, const arg11_t& _arg11) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5), arg6(_arg6), arg7(_arg7), arg8(_arg8), arg9(_arg9), arg10(_arg10), arg11(_arg11)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            msg << arg6;
            msg << arg7;
            msg << arg8;
            msg << arg9;
            msg << arg10;
            msg << arg11;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            arg6_t arg6;
            res = deserialize(stream, &arg6);
            if (res) { throw fake_archive_exc_t(); }
            arg7_t arg7;
            res = deserialize(stream, &arg7);
            if (res) { throw fake_archive_exc_t(); }
            arg8_t arg8;
            res = deserialize(stream, &arg8);
            if (res) { throw fake_archive_exc_t(); }
            arg9_t arg9;
            res = deserialize(stream, &arg9);
            if (res) { throw fake_archive_exc_t(); }
            arg10_t arg10;
            res = deserialize(stream, &arg10);
            if (res) { throw fake_archive_exc_t(); }
            arg11_t arg11;
            res = deserialize(stream, &arg11);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t, class a10_t, class a11_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t, a10_t, a11_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&, const a10_t&, const a11_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t, class arg10_t, class arg11_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5, const arg6_t &arg6, const arg7_t &arg7, const arg8_t &arg8, const arg9_t &arg9, const arg10_t &arg10, const arg11_t &arg11) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t, class arg10_t, class arg11_t, class arg12_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
        const arg6_t &arg6;
        const arg7_t &arg7;
        const arg8_t &arg8;
        const arg9_t &arg9;
        const arg10_t &arg10;
        const arg11_t &arg11;
        const arg12_t &arg12;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5, const arg6_t& _arg6, const arg7_t& _arg7, const arg8_t& _arg8, const arg9_t& _arg9, const arg10_t& _arg10, const arg11_t& _arg11, const arg12_t& _arg12) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5), arg6(_arg6), arg7(_arg7), arg8(_arg8), arg9(_arg9), arg10(_arg10), arg11(_arg11), arg12(_arg12)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            msg << arg6;
            msg << arg7;
            msg << arg8;
            msg << arg9;
            msg << arg10;
            msg << arg11;
            msg << arg12;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            arg6_t arg6;
            res = deserialize(stream, &arg6);
            if (res) { throw fake_archive_exc_t(); }
            arg7_t arg7;
            res = deserialize(stream, &arg7);
            if (res) { throw fake_archive_exc_t(); }
            arg8_t arg8;
            res = deserialize(stream, &arg8);
            if (res) { throw fake_archive_exc_t(); }
            arg9_t arg9;
            res = deserialize(stream, &arg9);
            if (res) { throw fake_archive_exc_t(); }
            arg10_t arg10;
            res = deserialize(stream, &arg10);
            if (res) { throw fake_archive_exc_t(); }
            arg11_t arg11;
            res = deserialize(stream, &arg11);
            if (res) { throw fake_archive_exc_t(); }
            arg12_t arg12;
            res = deserialize(stream, &arg12);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t, class a10_t, class a11_t, class a12_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t, a10_t, a11_t, a12_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&, const a10_t&, const a11_t&, const a12_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t, class arg10_t, class arg11_t, class arg12_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5, const arg6_t &arg6, const arg7_t &arg7, const arg8_t &arg8, const arg9_t &arg9, const arg10_t &arg10, const arg11_t &arg11, const arg12_t &arg12) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    send(src, dest.addr, &writer);
}


template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t, class arg10_t, class arg11_t, class arg12_t, class arg13_t>
class mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t, arg13_t) > {
    class write_impl_t : public mailbox_write_callback_t {
    private:
        const arg0_t &arg0;
        const arg1_t &arg1;
        const arg2_t &arg2;
        const arg3_t &arg3;
        const arg4_t &arg4;
        const arg5_t &arg5;
        const arg6_t &arg6;
        const arg7_t &arg7;
        const arg8_t &arg8;
        const arg9_t &arg9;
        const arg10_t &arg10;
        const arg11_t &arg11;
        const arg12_t &arg12;
        const arg13_t &arg13;
    public:
        write_impl_t(const arg0_t& _arg0, const arg1_t& _arg1, const arg2_t& _arg2, const arg3_t& _arg3, const arg4_t& _arg4, const arg5_t& _arg5, const arg6_t& _arg6, const arg7_t& _arg7, const arg8_t& _arg8, const arg9_t& _arg9, const arg10_t& _arg10, const arg11_t& _arg11, const arg12_t& _arg12, const arg13_t& _arg13) :
            arg0(_arg0), arg1(_arg1), arg2(_arg2), arg3(_arg3), arg4(_arg4), arg5(_arg5), arg6(_arg6), arg7(_arg7), arg8(_arg8), arg9(_arg9), arg10(_arg10), arg11(_arg11), arg12(_arg12), arg13(_arg13)
        { }
        void write(write_stream_t *stream) {
            write_message_t msg;
            msg << arg0;
            msg << arg1;
            msg << arg2;
            msg << arg3;
            msg << arg4;
            msg << arg5;
            msg << arg6;
            msg << arg7;
            msg << arg8;
            msg << arg9;
            msg << arg10;
            msg << arg11;
            msg << arg12;
            msg << arg13;
            int res = send_write_message(stream, &msg);
            if (res) { throw fake_archive_exc_t(); }
        }
    };

    class read_impl_t : public mailbox_read_callback_t {
    public:
        explicit read_impl_t(mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t, arg13_t) > *_parent) : parent(_parent) { }
        void read(read_stream_t *stream) {
            arg0_t arg0;
            int res = deserialize(stream, &arg0);
            if (res) { throw fake_archive_exc_t(); }
            arg1_t arg1;
            res = deserialize(stream, &arg1);
            if (res) { throw fake_archive_exc_t(); }
            arg2_t arg2;
            res = deserialize(stream, &arg2);
            if (res) { throw fake_archive_exc_t(); }
            arg3_t arg3;
            res = deserialize(stream, &arg3);
            if (res) { throw fake_archive_exc_t(); }
            arg4_t arg4;
            res = deserialize(stream, &arg4);
            if (res) { throw fake_archive_exc_t(); }
            arg5_t arg5;
            res = deserialize(stream, &arg5);
            if (res) { throw fake_archive_exc_t(); }
            arg6_t arg6;
            res = deserialize(stream, &arg6);
            if (res) { throw fake_archive_exc_t(); }
            arg7_t arg7;
            res = deserialize(stream, &arg7);
            if (res) { throw fake_archive_exc_t(); }
            arg8_t arg8;
            res = deserialize(stream, &arg8);
            if (res) { throw fake_archive_exc_t(); }
            arg9_t arg9;
            res = deserialize(stream, &arg9);
            if (res) { throw fake_archive_exc_t(); }
            arg10_t arg10;
            res = deserialize(stream, &arg10);
            if (res) { throw fake_archive_exc_t(); }
            arg11_t arg11;
            res = deserialize(stream, &arg11);
            if (res) { throw fake_archive_exc_t(); }
            arg12_t arg12;
            res = deserialize(stream, &arg12);
            if (res) { throw fake_archive_exc_t(); }
            arg13_t arg13;
            res = deserialize(stream, &arg13);
            if (res) { throw fake_archive_exc_t(); }
            parent->fun(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
        }
    private:
        mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t, arg13_t) > *parent;
    };

    read_impl_t reader;

public:
    typedef mailbox_addr_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t, arg13_t) > address_t;

    mailbox_t(mailbox_manager_t *manager,
              const boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t, arg13_t)> &f) :
        reader(this), fun(f), mailbox(manager, &reader)
        { }

    address_t get_address() const {
        address_t a;
        a.addr = mailbox.get_address();
        return a;
    }

private:
    template<class a0_t, class a1_t, class a2_t, class a3_t, class a4_t, class a5_t, class a6_t, class a7_t, class a8_t, class a9_t, class a10_t, class a11_t, class a12_t, class a13_t>
    friend void send(mailbox_manager_t*,
                     typename mailbox_t< void(a0_t, a1_t, a2_t, a3_t, a4_t, a5_t, a6_t, a7_t, a8_t, a9_t, a10_t, a11_t, a12_t, a13_t) >::address_t, const a0_t&, const a1_t&, const a2_t&, const a3_t&, const a4_t&, const a5_t&, const a6_t&, const a7_t&, const a8_t&, const a9_t&, const a10_t&, const a11_t&, const a12_t&, const a13_t&);

    boost::function< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t, arg13_t) > fun;
    raw_mailbox_t mailbox;
};

template<class arg0_t, class arg1_t, class arg2_t, class arg3_t, class arg4_t, class arg5_t, class arg6_t, class arg7_t, class arg8_t, class arg9_t, class arg10_t, class arg11_t, class arg12_t, class arg13_t>
void send(mailbox_manager_t *src,
          typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t, arg13_t) >::address_t dest, const arg0_t &arg0, const arg1_t &arg1, const arg2_t &arg2, const arg3_t &arg3, const arg4_t &arg4, const arg5_t &arg5, const arg6_t &arg6, const arg7_t &arg7, const arg8_t &arg8, const arg9_t &arg9, const arg10_t &arg10, const arg11_t &arg11, const arg12_t &arg12, const arg13_t &arg13) {
    typename mailbox_t< void(arg0_t, arg1_t, arg2_t, arg3_t, arg4_t, arg5_t, arg6_t, arg7_t, arg8_t, arg9_t, arg10_t, arg11_t, arg12_t, arg13_t) >::write_impl_t writer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    send(src, dest.addr, &writer);
}

#endif // RPC_MAILBOX_TYPED_HPP_
