private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__gthr_win32_once"
		size = 128
		refs = "003f __imp_Sleep"
	strings:
		$1 = { 56 53 48 83 EC 38 48 85 C9 74 05 48 85 D2 75 10 B8 16 00 00 00 48 83 C4 38 5B 5E C3 0F 1F 40 00 8B 01 85 C0 74 0A 31 C0 48 83 C4 38 5B 5E C3 90 48 89 CB F0 83 41 04 01 74 26 8B 11 48 8B 35 ?? ?? ?? ?? 85 D2 75 DF 66 0F 1F 84 00 00 00 00 00 31 C9 FF D6 8B 03 85 C0 74 F6 31 C0 EB CA 66 90 89 44 24 2C FF D2 C7 03 01 00 00 00 8B 44 24 2C EB A3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "__gthr_win32_key_create"
		size = 64
		refs = "000e __imp_TlsAlloc 0033 __imp_GetLastError 0025 __mingwthr_key_dtor"
	strings:
		$1 = { 56 53 48 83 EC 28 48 89 CE 48 89 D3 FF 15 ?? ?? ?? ?? 83 F8 FF 74 19 48 89 DA 89 C1 89 06 48 83 C4 28 5B 5E E9 ?? ?? ?? ?? 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 83 C4 28 5B 5E 48 FF E0 }
	condition:
		$1
}

rule file_0_2_0 {
	meta:
		name = "__gthr_win32_key_delete"
		size = 48
		refs = "0006 __imp_TlsFree 0018 __imp_GetLastError"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 74 07 31 C0 48 83 C4 28 C3 48 8B 05 ?? ?? ?? ?? 48 83 C4 28 48 FF E0 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_4_0 {
	meta:
		name = "__gthr_win32_setspecific"
		size = 48
		refs = "0006 __imp_TlsSetValue 0018 __imp_GetLastError"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 74 07 31 C0 48 83 C4 28 C3 48 8B 05 ?? ?? ?? ?? 48 83 C4 28 48 FF E0 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "__gthr_win32_getspecific"
		size = 48
		refs = "000a __imp_GetLastError 0014 __imp_TlsGetValue 001f __imp_SetLastError"
	strings:
		$1 = { 56 53 48 83 EC 28 89 CB FF 15 ?? ?? ?? ?? 89 D9 89 C6 FF 15 ?? ?? ?? ?? 48 89 C3 89 F1 FF 15 ?? ?? ?? ?? 48 89 D8 48 83 C4 28 5B 5E C3 0F 1F 00 }
	condition:
		$1
}

rule file_0_5_0 {
	meta:
		name = "__gthr_win32_mutex_init_function"
		size = 48
		refs = "001d __imp_CreateSemaphoreW"
	strings:
		$1 = { 53 48 83 EC 20 45 31 C9 41 B8 FF FF 00 00 31 D2 48 89 CB C7 01 FF FF FF FF 31 C9 FF 15 ?? ?? ?? ?? 48 89 43 08 48 83 C4 20 5B C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_0_7_0 {
	meta:
		name = "__gthr_win32_mutex_lock"
		size = 64
		refs = "0021 __imp_WaitForSingleObject"
	strings:
		$1 = { 53 48 83 EC 20 F0 83 01 01 75 08 31 C0 48 83 C4 20 5B C3 48 89 CB BA FF FF FF FF 48 8B 49 08 FF 15 ?? ?? ?? ?? 85 C0 74 E2 F0 83 2B 01 B8 01 00 00 00 48 83 C4 20 5B C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_8_0 {
	meta:
		name = "__gthr_win32_mutex_trylock"
		size = 32
	strings:
		$1 = { B8 FF FF FF FF 31 D2 F0 0F B1 11 F7 D0 C1 E8 1F C3 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_9_0 {
	meta:
		name = "__gthr_win32_mutex_unlock"
		size = 64
		refs = "0022 __imp_ReleaseSemaphore"
	strings:
		$1 = { 48 83 EC 28 BA FF FF FF FF F0 0F C1 11 31 C0 83 EA 01 78 1A 45 31 C0 48 8B 49 08 BA 01 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 94 C0 0F B6 C0 48 83 C4 28 C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_10_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_init_function"
		size = 64
		refs = "002b __imp_CreateSemaphoreW"
	strings:
		$1 = { 53 48 83 EC 20 45 31 C9 41 B8 FF FF 00 00 31 D2 48 89 CB C7 01 FF FF FF FF C7 41 04 00 00 00 00 C7 41 08 00 00 00 00 31 C9 FF 15 ?? ?? ?? ?? 48 89 43 10 48 83 C4 20 5B C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_0_11_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_lock"
		size = 128
		refs = "000b __imp_GetCurrentThreadId 0027 __imp_WaitForSingleObject"
	strings:
		$1 = { 56 53 48 83 EC 28 48 89 CB FF 15 ?? ?? ?? ?? 89 C6 F0 83 03 01 74 29 39 43 08 74 37 48 8B 4B 10 BA FF FF FF FF FF 15 ?? ?? ?? ?? 85 C0 75 35 C7 43 04 01 00 00 00 89 73 08 48 83 C4 28 5B 5E C3 89 43 08 31 C0 C7 43 04 01 00 00 00 48 83 C4 28 5B 5E C3 F0 83 2B 01 83 43 04 01 31 C0 48 83 C4 28 5B 5E C3 F0 83 2B 01 B8 01 00 00 00 48 83 C4 28 5B 5E C3 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_12_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_trylock"
		size = 96
		refs = "000a __imp_GetCurrentThreadId"
	strings:
		$1 = { 53 48 83 EC 20 48 89 CB FF 15 ?? ?? ?? ?? 31 C9 41 89 C0 B8 FF FF FF FF F0 0F B1 0B 85 C0 78 20 44 39 43 08 B8 01 00 00 00 75 06 83 43 04 01 30 C0 48 83 C4 20 5B C3 66 0F 1F 84 00 00 00 00 00 31 C0 C7 43 04 01 00 00 00 44 89 43 08 48 83 C4 20 5B C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_13_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_unlock"
		size = 80
		refs = "0034 __imp_ReleaseSemaphore"
	strings:
		$1 = { 48 83 EC 28 83 69 04 01 74 07 31 C0 48 83 C4 28 C3 C7 41 08 00 00 00 00 B8 FF FF FF FF F0 0F C1 01 83 E8 01 78 E4 45 31 C0 48 8B 49 10 BA 01 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 94 C0 0F B6 C0 48 83 C4 28 C3 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_0_14_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_destroy"
		size = 32
		refs = "000a __imp_CloseHandle"
	strings:
		$1 = { 48 83 EC 28 48 8B 49 10 FF 15 ?? ?? ?? ?? 31 C0 48 83 C4 28 C3 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "__dfp_set_round"
		size = 16
		refs = "0002 .bss"
	strings:
		$1 = { 89 0D ?? ?? ?? ?? C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "__dfp_get_round"
		size = 16
		refs = "0002 .bss"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "__dfp_clear_except"
		size = 16
		refs = "0002 .bss"
	strings:
		$1 = { 83 25 ?? ?? ?? ?? C0 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "__dfp_test_except"
		size = 96
		refs = "0002 .bss"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 41 B8 00 00 00 00 89 C8 83 E0 20 F6 C2 20 41 0F 44 C0 F6 C2 10 74 0A 41 89 C8 41 83 E0 10 44 09 C0 F6 C2 08 74 0A 41 89 C8 41 83 E0 08 44 09 C0 F6 C2 04 74 0A 41 89 C8 41 83 E0 04 44 09 C0 83 E2 01 74 05 83 E1 01 09 C8 F3 C3 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "__bid_fixunssddi"
		size = 48
		refs = "0005 __bid32_to_bid64 000d __bid64_to_uint64_xint"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 BA 00 00 00 00 00 00 00 80 48 39 D0 BA 00 00 00 00 48 0F 44 C2 48 83 C4 28 C3 90 90 90 90 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__lshrti3"
		size = 96
	strings:
		$1 = { 48 83 EC 18 48 8B 01 4C 8B 49 08 48 85 D2 74 27 41 BA 40 00 00 00 49 89 C0 4C 89 C8 49 29 D2 4D 85 D2 7E 2C 89 D1 49 D3 E9 44 89 D1 48 D3 E0 89 D1 49 D3 E8 4C 09 C0 48 89 04 24 4C 89 4C 24 08 66 0F 6F 04 24 48 83 C4 18 C3 66 0F 1F 44 00 00 44 89 D1 45 31 C9 F7 D9 48 D3 E8 EB DA 90 90 90 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__modti3"
		size = 496
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 48 8B 59 08 4C 8B 2A 48 8B 09 48 8B 6A 08 48 85 DB 0F 88 EE 00 00 00 48 89 CA 45 31 F6 48 89 D9 45 31 FF 31 DB 48 C7 04 24 00 00 00 00 48 89 E8 45 31 D2 48 89 54 24 18 48 C1 E8 3F 4C 89 D7 49 89 C8 48 89 C6 49 89 C1 49 89 D4 48 F7 DE 48 83 D7 00 49 31 F5 48 F7 DF 48 31 FD 4D 01 E9 49 89 CD 49 11 EA 4C 89 C8 4C 89 CD 4D 85 D2 4D 89 D3 75 41 49 39 C9 76 69 48 89 D0 48 89 CA 49 F7 F1 45 31 C0 48 8B 04 24 48 31 DA 4C 31 C0 49 01 D6 49 11 C7 4C 89 34 24 4C 89 7C 24 08 66 0F 6F 04 24 90 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 49 39 CA 77 CB 49 0F BD D2 48 83 F2 3F 85 D2 89 D5 75 6A 4D 39 E1 0F 86 01 01 00 00 49 39 CA 0F 82 F8 00 00 00 4C 89 E2 4D 89 E8 EB A3 4D 85 C9 75 0D B8 01 00 00 00 31 D2 49 F7 F1 48 89 C5 4C 89 C0 31 D2 48 F7 F5 4C 89 E0 48 F7 F5 E9 7B FF FF FF 48 F7 D9 41 BE 01 00 00 00 48 83 D3 00 48 89 CA 45 31 FF 48 F7 DB 48 89 D9 48 C7 C3 FF FF FF FF 48 89 1C 24 E9 FF FE FF FF 66 90 89 D1 41 B9 40 00 00 00 48 89 C7 49 D3 E3 48 63 CA 4D 89 C5 49 29 C9 44 89 C9 48 D3 EF 89 D1 49 09 FB 48 8B 7C 24 18 48 D3 E0 44 89 C9 49 89 C2 49 D3 ED 89 D1 49 D3 E0 48 89 F8 44 89 C9 48 D3 E8 89 D1 4C 89 EA 4C 09 C0 48 D3 E7 49 F7 F3 49 89 D5 49 F7 E2 49 39 D5 49 89 C0 48 89 D1 72 0A 48 39 C7 73 11 49 39 D5 75 0C 48 89 D1 49 89 C0 4D 29 D0 4C 19 D9 4C 29 C7 49 19 CD 89 E9 4C 89 E8 4D 89 E8 48 D3 EF 44 89 C9 48 D3 E0 48 89 FA 89 E9 48 09 C2 49 D3 E8 E9 B6 FE FF FF 0F 1F 00 4D 89 C5 4D 29 CC 4D 19 D5 E9 FA FE FF FF 90 90 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__bid_ltdd2"
		size = 32
		refs = "0005 __bid64_quiet_less"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? F7 D8 48 98 48 83 C4 28 C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__bid_floatdisd"
		size = 32
		refs = "0005 __bid64_from_int64 000d __bid64_to_bid32"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 C4 28 C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__bid_floatsisd"
		size = 32
		refs = "0005 __bid64_from_int32 000d __bid64_to_bid32"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 C4 28 C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__bid_floatunsdisd"
		size = 32
		refs = "0005 __bid64_from_uint64 000d __bid64_to_bid32"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 C4 28 C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__bid_floatunssisd"
		size = 32
		refs = "0005 __bid64_from_uint32 000d __bid64_to_bid32"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 C4 28 C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__bid_lesd2"
		size = 64
		refs = "0009 __bid32_to_bid64 001e __bid64_quiet_less_equal"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 83 F8 01 48 19 C0 83 E0 02 48 83 E8 01 48 83 C4 28 5B 5E C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__fixunstfsi"
		size = 272
		refs = "006f __sfp_handle_exceptions"
	strings:
		$1 = { 48 83 EC 48 66 0F 6F 01 C7 44 24 3C 00 00 00 00 0F 29 44 24 20 0F AE 5C 24 3C 48 B8 FF FF FF FF FF FF 00 00 48 8B 54 24 28 4C 8B 4C 24 20 48 89 D1 48 21 D0 48 C1 EA 3F 48 C1 E9 30 66 81 E1 FF 7F 44 0F B7 C1 49 81 F8 FE 3F 00 00 7F 32 4D 85 C0 0F 85 89 00 00 00 4C 09 C8 B8 00 00 00 00 74 16 41 B8 22 00 00 00 89 44 24 20 44 89 C1 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 48 C3 0F 1F 40 00 84 D2 74 1C 31 C0 41 B8 01 00 00 00 44 89 C1 89 44 24 20 E8 ?? ?? ?? ?? 8B 44 24 20 EB D9 66 90 49 81 F8 1E 40 00 00 7F 47 48 BA 00 00 00 00 00 00 01 00 48 09 D0 0F B7 D1 8D 8A 11 C0 FF FF 49 89 C2 49 D3 E2 4C 89 D1 4C 09 C9 74 33 B9 2F 40 00 00 41 B8 20 00 00 00 29 D1 48 D3 E8 EB AD 90 31 C0 41 B8 20 00 00 00 EB A2 66 0F 1F 44 00 00 B8 FF FF FF FF 41 B8 01 00 00 00 EB 8F 0F 1F 00 B9 2F 40 00 00 29 D1 48 D3 E8 E9 68 FF FF FF 90 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__bid_round64_2_18"
		size = 368
		refs = "0007 .refptr.__bid_midpoint64 001a .refptr.__bid_Kx64 0074 .refptr.__bid_Ex64m64 008b .refptr.__bid_mask64 0096 .refptr.__bid_half64 00ae .refptr.__bid_ten2mxtrunc64 00c5 .refptr.__bid_ten2k64"
	strings:
		$1 = { 55 57 56 53 48 8B 05 ?? ?? ?? ?? 8D 5A FF 89 CE 48 63 DB 4C 03 04 D8 48 8B 05 ?? ?? ?? ?? 48 8B 04 D8 4C 89 C1 45 89 C0 48 C1 E9 20 49 89 C2 48 89 CF 89 C0 49 C1 EA 20 48 0F AF F8 49 0F AF CA 49 0F AF C0 89 FD 48 C1 EF 20 49 89 CB 4D 0F AF D0 48 89 C1 89 C0 48 C1 E9 20 48 01 E9 4E 8D 04 11 49 89 FA 4D 01 DA 4D 89 C3 49 C1 E0 20 49 01 C0 48 8B 05 ?? ?? ?? ?? 49 C1 EB 20 4D 01 DA 8B 0C 98 4C 89 D0 48 D3 E8 48 8B 0D ?? ?? ?? ?? 4C 23 14 D9 48 8B 0D ?? ?? ?? ?? 4C 3B 14 D9 0F 87 8C 00 00 00 75 3F 4D 85 C0 74 3A 48 8B 0D ?? ?? ?? ?? 4C 3B 04 D9 77 78 4D 85 D2 74 45 0F 1F 00 29 D6 48 8B 15 ?? ?? ?? ?? 48 63 CE 48 39 04 CA 74 7E 48 8B 74 24 48 C7 06 00 00 00 00 49 89 01 5B 5E 5F 5D C3 48 8B 7C 24 68 C7 07 01 00 00 00 4D 85 D2 75 CB 48 8B 0D ?? ?? ?? ?? 4C 3B 04 D9 77 BE A8 01 75 3A 48 8B 4C 24 50 48 8B 5C 24 60 C7 01 01 00 00 00 C7 03 00 00 00 00 48 8B 5C 24 68 C7 03 00 00 00 00 EB 97 0F 1F 80 00 00 00 00 48 8B 7C 24 60 C7 07 01 00 00 00 EB B3 0F 1F 00 48 83 E8 01 48 8B 4C 24 58 EB C0 0F 1F 44 00 00 83 EE 01 48 63 F6 48 8B 04 F2 48 8B 54 24 48 C7 02 01 00 00 00 49 89 01 5B 5E 5F 5D C3 0F 1F 00 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "__bid_round128_19_38"
		size = 1360
		refs = "0039 .refptr.__bid_midpoint64 0065 .refptr.__bid_Kx128 01dc .refptr.__bid_Ex128m128 0203 .refptr.__bid_mask128 0214 .refptr.__bid_half128 0258 .refptr.__bid_ten2k64 02b6 .refptr.__bid_midpoint128 0318 .refptr.__bid_ten2mxtrunc128 03c1 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 49 8B 00 4D 8B 50 08 8D 72 FF 89 4C 24 70 41 89 D7 4C 89 8C 24 88 00 00 00 83 FE 12 89 74 24 0C 0F 8F 6A 02 00 00 48 8B 15 ?? ?? ?? ?? 48 63 F6 4D 8D 5A 01 48 03 04 F2 4D 0F 43 DA 48 89 F7 49 89 C4 89 C0 48 C1 E7 04 49 C1 EC 20 48 89 C3 48 89 FD 48 03 2D ?? ?? ?? ?? 4C 89 E2 48 89 7C 24 10 4D 89 E5 48 8B 4D 08 49 89 C8 89 C9 48 0F AF D9 49 C1 E8 20 48 0F AF D1 4D 0F AF E8 49 89 DA 89 DB 89 D7 49 C1 EA 20 48 C1 EA 20 49 01 FA 48 89 C7 49 01 D5 49 0F AF F8 4C 01 D7 48 89 FA 48 C1 E7 20 48 C1 EA 20 4C 01 EA 49 89 C5 48 89 14 24 48 8B 55 00 4C 89 E5 49 89 D2 89 D2 4C 0F AF EA 49 C1 EA 20 48 0F AF EA 49 0F AF C2 4D 89 E9 45 89 ED 49 C1 E9 20 41 89 EE 48 C1 ED 20 4D 0F AF E2 4D 01 CE 49 01 C6 49 01 EC 4C 89 F5 49 C1 E6 20 4F 8D 0C 2E 48 C1 ED 20 4C 8D 34 1F 49 01 EC 4C 89 DB 45 89 DB 4D 01 E6 48 83 14 24 00 48 C1 EB 20 48 89 D8 48 89 DF 4C 89 4C 24 18 48 0F AF C1 4C 8B 0C 24 49 0F AF CB 49 0F AF F8 41 89 C4 48 C1 E8 20 48 89 CD 89 C9 4D 0F AF C3 48 01 C7 48 C1 ED 20 48 89 D8 4C 01 E5 48 0F AF C2 49 0F AF D3 49 01 E8 4D 89 C5 49 C1 E0 20 4D 0F AF DA 49 C1 ED 20 89 C5 49 01 FD 48 C1 E8 20 48 89 D7 89 D2 48 C1 EF 20 49 0F AF DA 48 01 EF 49 01 FB 4D 89 DA 49 C1 E3 20 49 C1 EA 20 49 01 D3 4C 89 CA 48 01 C3 4C 01 D3 4D 8D 14 08 4C 01 D3 49 83 D5 00 31 C9 4D 01 F3 0F 92 C1 48 01 CB 48 01 DA 41 0F 92 C0 48 39 D9 0F 97 C0 44 09 C0 0F B6 C0 49 01 C5 83 7C 24 0C 12 48 8B 05 ?? ?? ?? ?? 8B 04 B0 0F 8F E7 00 00 00 B9 40 00 00 00 4D 89 E8 48 89 D3 29 C1 49 D3 E0 89 C1 48 D3 EB 89 C1 48 8B 05 ?? ?? ?? ?? 49 09 D8 49 D3 ED 48 23 14 F0 48 8B 05 ?? ?? ?? ?? 48 3B 14 F0 0F 86 4E 01 00 00 48 8B 84 24 A8 00 00 00 C7 00 01 00 00 00 31 C0 48 09 D0 0F 84 D6 00 00 00 0F 1F 44 00 00 8B 54 24 70 44 29 FA 83 FA 13 0F 8F 60 01 00 00 4D 85 ED 75 14 48 8B 05 ?? ?? ?? ?? 48 63 CA 4C 3B 04 C8 0F 84 F7 01 00 00 48 8B 84 24 90 00 00 00 C7 00 00 00 00 00 48 8B 84 24 88 00 00 00 4C 89 68 08 4C 89 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 84 00 00 00 00 00 8D 52 EC 4D 8D 5A 01 48 63 74 24 0C 48 63 D2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 03 02 4D 0F 43 DA 4C 03 5A 08 E9 82 FD FF FF 66 0F 1F 44 00 00 89 C1 4D 89 E8 48 8B 05 ?? ?? ?? ?? 49 D3 E8 48 8B 0D ?? ?? ?? ?? 4C 23 2C F0 4C 3B 2C F1 4C 89 E8 0F 86 99 00 00 00 48 8B 8C 24 A8 00 00 00 45 31 ED C7 01 01 00 00 00 48 09 D0 0F 85 2F FF FF FF 48 C1 E6 04 48 03 35 ?? ?? ?? ?? 4C 3B 5E 08 0F 83 DC 00 00 00 41 F6 C0 01 0F 84 50 01 00 00 48 8B 84 24 A0 00 00 00 49 83 E8 01 0F 1F 40 00 C7 00 01 00 00 00 48 8B 84 24 A8 00 00 00 C7 00 00 00 00 00 48 8B 84 24 B0 00 00 00 C7 00 00 00 00 00 E9 D9 FE FF FF 66 0F 1F 84 00 00 00 00 00 0F 84 1A 01 00 00 48 8B 84 24 B0 00 00 00 C7 00 01 00 00 00 31 C0 E9 7D FF FF FF 0F 1F 44 00 00 0F 84 4A 01 00 00 48 8B 8C 24 B0 00 00 00 45 31 ED C7 01 01 00 00 00 E9 5C FF FF FF 0F 1F 40 00 83 FA 14 74 6B 8D 42 EC 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 3B 68 08 0F 85 9A FE FF FF 4C 3B 00 0F 85 91 FE FF FF 8D 42 EB 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 8B 00 4C 8B 68 08 48 8B 84 24 90 00 00 00 C7 00 01 00 00 00 E9 75 FE FF FF 0F 85 38 FE FF FF 48 8B 44 24 18 48 3B 06 0F 86 10 FF FF FF E9 25 FE FF FF 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 4C 3B 68 08 0F 85 38 FE FF FF 4C 3B 00 0F 85 2F FE FF FF 48 8B 05 ?? ?? ?? ?? 45 31 ED 4C 8B 80 98 00 00 00 48 8B 84 24 90 00 00 00 C7 00 01 00 00 00 E9 19 FE FF FF 66 90 83 EA 01 48 63 D2 4C 8B 04 D0 48 8B 84 24 90 00 00 00 C7 00 01 00 00 00 E9 FA FD FF FF 0F 1F 00 48 8B 84 24 98 00 00 00 E9 B3 FE FF FF 0F 1F 00 48 8B 44 24 18 4C 09 D8 0F 84 D8 FE FF FF 48 8B 4C 24 10 48 03 0D ?? ?? ?? ?? 4C 3B 59 08 0F 87 6E FD FF FF B8 00 00 00 00 0F 85 49 FE FF FF 48 8B 5C 24 18 48 3B 19 0F 87 55 FD FF FF 48 09 C2 0F 84 50 FE FF FF E9 65 FD FF FF 0F 1F 44 00 00 48 85 D2 0F 95 C3 4D 85 DB 41 0F 95 C2 48 83 7C 24 18 00 0F 95 C1 41 08 CA 75 0D 84 DB 0F 84 93 FE FF FF E9 EF FD FF FF 84 DB 0F 85 E7 FD FF FF 48 8B 4C 24 10 48 03 0D ?? ?? ?? ?? 4C 3B 59 08 0F 87 D1 FD FF FF 41 BD 00 00 00 00 0F 85 D6 FD FF FF 48 8B 5C 24 18 48 3B 19 76 91 E9 B6 FD FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "__bid_round192_39_57"
		size = 2928
		refs = "0050 .refptr.__bid_midpoint64 0064 .refptr.__bid_Kx192 0489 .refptr.__bid_Ex192m192 04d3 .refptr.__bid_mask192 04de .refptr.__bid_half192 050b .refptr.__bid_ten2mxtrunc192 057a .refptr.__bid_ten2k64 0671 .refptr.__bid_midpoint128 06cd .refptr.__bid_midpoint192 0797 .refptr.__bid_ten2k256 07f2 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 78 49 8B 58 10 49 8B 00 89 94 24 C8 00 00 00 8B BC 24 C8 00 00 00 89 8C 24 C0 00 00 00 4C 89 8C 24 D8 00 00 00 49 8B 50 08 48 89 5C 24 30 83 EF 01 83 FF 12 89 7C 24 2C 0F 8F 13 06 00 00 48 8B 0D ?? ?? ?? ?? 4C 63 FF 4A 03 04 F9 0F 82 4F 06 00 00 4C 8B 05 ?? ?? ?? ?? 4B 8D 0C 7F 49 89 C3 89 C0 49 C1 EB 20 49 89 C4 49 8D 0C C8 4C 8B 01 44 89 C6 4C 89 C7 49 89 F0 48 89 F5 48 C1 EF 20 4C 0F AF C0 48 89 7C 24 10 49 89 FE 49 0F AF EB 48 89 74 24 18 4D 0F AF F3 4D 89 C1 45 89 C0 41 89 EA 49 C1 E9 20 48 C1 ED 20 4D 01 D1 49 89 FA 4C 01 F5 4C 0F AF D0 4D 01 CA 4D 89 D1 49 C1 EA 20 49 C1 E1 20 4C 01 D5 4B 8D 3C 01 4C 8B 41 08 48 8B 49 10 48 89 7C 24 68 4C 89 DF 4C 89 C6 45 89 C5 48 C1 EE 20 49 89 F1 48 89 74 24 20 4D 0F AF E5 4D 0F AF CB 49 0F AF FD 4D 89 E0 4C 89 4C 24 38 4D 89 E1 89 FB 49 C1 E9 20 49 01 D9 48 89 F3 4C 89 DE 48 0F AF D8 49 01 D9 44 89 C3 49 89 C0 4D 89 CC 49 C1 E4 20 4D 8D 24 1C 4C 89 64 24 40 49 89 CC 89 C9 49 C1 EC 20 4C 89 64 24 08 4C 0F AF C1 48 0F AF 44 24 08 48 0F AF F1 4D 0F AF DC 4D 89 C4 89 F3 49 C1 EC 20 45 89 C0 49 01 DC 48 8B 5C 24 10 49 01 C4 48 03 6C 24 40 4D 89 E2 0F 92 C0 48 C1 EF 20 48 03 7C 24 38 49 C1 E2 20 0F B6 C0 49 C1 E9 20 4D 01 D0 48 89 6C 24 40 49 01 C0 4C 01 CF 4C 01 C7 41 0F 92 C1 4C 39 C0 48 89 D8 41 0F 97 C6 48 C1 EE 20 49 C1 EC 20 45 09 F1 4C 01 DE 4C 8B 44 24 18 4C 01 E6 45 0F B6 C9 48 89 7C 24 48 4E 8D 34 0E 4C 89 C7 4C 89 74 24 38 49 89 D6 89 D2 49 C1 EE 20 49 0F AF C6 4C 89 F6 4D 89 F2 49 0F AF FE 49 0F AF F5 4C 0F AF 54 24 08 48 89 44 24 50 4C 89 C0 41 89 F9 48 C1 EF 20 48 03 7C 24 50 48 0F AF C2 49 89 C3 89 C0 49 C1 EB 20 4D 89 D8 4D 01 C8 49 89 D9 48 8B 5C 24 20 4C 0F AF CA 49 89 DC 4D 01 C1 4D 89 CB 49 C1 E9 20 49 C1 E3 20 4D 8D 1C 03 4D 0F AF E6 4C 89 5C 24 58 49 89 D3 4D 0F AF DD 4C 89 D8 41 89 F3 49 89 C0 49 C1 E8 20 4D 01 D8 49 89 DB 4C 0F AF DA 4D 01 D8 41 89 C3 4C 89 C3 48 C1 E3 20 49 01 DB 4C 89 F3 49 89 D6 4C 0F AF F1 48 0F AF 54 24 08 48 0F AF D9 4C 89 F0 48 89 C5 89 C0 41 89 DE 48 C1 ED 20 4C 01 F5 48 01 EA 4C 01 CF 49 89 FE 48 8B 7C 24 10 4D 01 DE 49 89 D3 41 0F 92 C1 48 C1 EE 20 49 C1 E3 20 4C 01 E6 49 C1 E8 20 45 0F B6 C9 4C 01 D8 4C 89 74 24 50 4E 8D 34 06 4C 01 C8 48 8B 74 24 30 4C 8B 64 24 20 49 01 C6 41 0F 92 C0 49 39 C1 0F 97 C0 48 C1 EB 20 48 C1 EA 20 41 09 C0 48 8B 44 24 18 4C 01 D3 41 89 F3 48 01 DA 48 89 F3 48 C1 EB 20 45 0F B6 C0 49 89 C2 4C 01 C2 49 89 D8 49 0F AF C3 48 89 54 24 60 4C 0F AF D3 48 89 FB 49 0F AF D8 48 89 C2 89 C0 45 89 D1 48 C1 EA 20 49 C1 EA 20 4C 01 CA 49 89 F9 4C 89 E7 4D 0F AF CB 49 01 DA 49 0F AF F8 4C 01 CA 49 89 D1 49 C1 E1 20 49 8D 34 01 48 89 74 24 10 4C 89 C6 49 0F AF F5 4D 0F AF EB 41 89 F1 4C 89 E8 48 C1 E8 20 4C 01 C8 4D 89 E1 4D 0F AF CB 4C 01 C8 45 89 E9 4D 89 C5 4C 0F AF E9 49 89 C4 4C 0F AF 44 24 08 49 0F AF CB 49 C1 E4 20 48 8B 5C 24 50 4C 0F AF 5C 24 08 4D 01 E1 4C 89 ED 45 89 ED 49 89 CC 89 C9 49 C1 EC 20 4D 01 EC 4D 01 DC 48 C1 EA 20 49 01 D2 31 D2 4D 01 D1 4D 89 E2 0F 92 C2 49 C1 E2 20 48 C1 EE 20 48 01 FE 48 C1 E8 20 4C 01 D1 48 01 D1 48 01 C6 48 8B 7C 24 48 48 01 CE 0F 92 C0 48 39 CA 0F 97 C2 48 C1 ED 20 49 C1 EC 20 09 D0 49 01 E8 31 C9 4D 01 E0 0F B6 C0 49 8D 14 00 48 8B 44 24 40 48 03 44 24 58 0F 92 C1 4C 8D 1C 19 4C 01 DF 0F 82 93 01 00 00 4C 39 D9 0F 87 8A 01 00 00 31 C9 4C 03 74 24 38 0F 92 C1 45 31 C0 48 03 4C 24 60 48 03 7C 24 10 41 0F 92 C0 4D 01 C1 4D 01 CE 0F 82 43 01 00 00 4D 39 C8 0F 87 3A 01 00 00 31 DB 48 01 CE 0F 92 C3 48 01 DA 83 7C 24 2C 12 48 8B 0D ?? ?? ?? ?? 46 8B 0C B9 0F 8F 5A 01 00 00 41 BA 40 00 00 00 48 89 D3 44 89 C9 45 29 CA 48 D3 EB 49 89 F5 44 89 D1 48 D3 E2 44 89 C9 49 D3 ED 44 89 D1 48 D3 E6 49 09 D5 44 89 C9 4C 89 F2 48 D3 EA 48 89 F1 48 09 D1 48 8B 15 ?? ?? ?? ?? 4E 23 34 FA 48 8B 15 ?? ?? ?? ?? 4E 3B 34 FA 0F 86 64 02 00 00 48 8B 94 24 F8 00 00 00 C7 02 01 00 00 00 BA 01 00 00 00 4D 85 F6 75 4D 84 D2 74 49 4C 8B 05 ?? ?? ?? ?? 4B 8D 14 7F 49 3B 7C D0 10 0F 83 96 03 00 00 F6 C1 01 0F 85 BA 04 00 00 48 8B 84 24 E8 00 00 00 C7 00 01 00 00 00 48 8B 84 24 F8 00 00 00 C7 00 00 00 00 00 48 8B 84 24 00 01 00 00 C7 00 00 00 00 00 44 8B 8C 24 C0 00 00 00 44 2B 8C 24 C8 00 00 00 41 83 F9 13 0F 8F 05 02 00 00 4C 89 E8 48 09 D8 0F 85 2E 02 00 00 48 8B 05 ?? ?? ?? ?? 49 63 D1 48 3B 0C D0 0F 85 1A 02 00 00 41 83 E9 01 31 DB 45 31 ED 4D 63 C9 4A 8B 0C C8 48 8B 84 24 E0 00 00 00 C7 00 01 00 00 00 E9 05 02 00 00 66 90 4C 8D 46 01 48 89 CE 4C 01 C6 0F 92 C3 4D 85 C0 0F 94 C1 09 CB 0F B6 DB E9 B1 FE FF FF 0F 1F 00 4D 8D 46 01 4C 8B 74 24 38 4D 01 C6 0F 92 C1 4D 85 C0 41 0F 94 C0 44 09 C1 0F B6 C9 E9 5F FE FF FF 83 7C 24 2C 25 0F 8F 05 01 00 00 49 89 D5 44 89 C9 48 89 F3 49 D3 ED B9 40 00 00 00 44 29 C9 48 D3 E2 44 89 C9 48 D3 EB 48 09 DA 48 89 D1 48 8B 15 ?? ?? ?? ?? 4A 23 34 FA 48 8B 15 ?? ?? ?? ?? 4A 3B 34 FA 0F 86 58 02 00 00 48 8B 94 24 F8 00 00 00 C7 02 01 00 00 00 48 85 F6 0F 94 C2 31 DB E9 A9 FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 83 7C 24 2C 25 7F 5C 8B 8C 24 C8 00 00 00 4C 8B 0D ?? ?? ?? ?? 83 E9 14 48 63 C9 49 89 C8 49 C1 E0 04 4D 01 C8 49 03 00 0F 83 A2 01 00 00 48 83 C2 01 0F 85 98 01 00 00 48 83 44 24 30 01 49 8B 50 08 4C 63 7C 24 2C E9 B5 F9 FF FF 0F 1F 40 00 48 83 C2 01 48 83 FA 01 48 83 54 24 30 00 E9 9E F9 FF FF 8B BC 24 C8 00 00 00 4C 8B 05 ?? ?? ?? ?? 8D 4F D9 48 63 C9 4C 8D 0C 49 4F 8D 0C C8 49 03 01 0F 83 68 01 00 00 48 83 C2 01 0F 85 5E 01 00 00 48 83 44 24 30 01 49 8B 51 08 E9 5E 01 00 00 4C 8B 05 ?? ?? ?? ?? 48 89 D3 44 89 C9 48 D3 EB 48 89 D9 4B 23 14 F8 4C 8B 05 ?? ?? ?? ?? 4B 3B 14 F8 0F 86 57 01 00 00 48 8B 9C 24 F8 00 00 00 48 09 F2 C7 03 01 00 00 00 0F 94 C2 45 31 ED 31 DB E9 B8 FD FF FF 66 0F 1F 84 00 00 00 00 00 0F 84 0A 02 00 00 48 8B 94 24 00 01 00 00 C7 02 01 00 00 00 BA 01 00 00 00 E9 91 FD FF FF 66 90 41 83 F9 14 0F 84 46 01 00 00 41 83 F9 26 7E 60 41 83 F9 27 0F 84 86 01 00 00 41 8D 41 D9 48 98 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 48 3B 58 10 0F 84 4D 02 00 00 48 8B 84 24 E0 00 00 00 C7 00 00 00 00 00 48 8B 84 24 D8 00 00 00 48 89 58 10 4C 89 68 08 48 89 08 48 83 C4 78 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 84 00 00 00 00 00 48 85 DB 75 C0 41 8D 41 EC 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 39 68 08 75 A9 48 3B 08 75 A4 41 8D 41 EB 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 08 4C 8B 68 08 48 8B 84 24 E0 00 00 00 C7 00 01 00 00 00 EB 8A 0F 1F 80 00 00 00 00 48 C1 E1 04 4C 63 7C 24 2C 49 03 54 09 08 0F 92 C1 0F B6 C9 48 01 4C 24 30 E9 13 F8 FF FF 66 90 4C 8D 0C 49 4B 03 54 C8 08 48 83 54 24 30 00 48 8D 0C 49 4C 63 7C 24 2C 49 8B 4C C8 10 48 01 4C 24 30 E9 EA F7 FF FF 66 0F 1F 84 00 00 00 00 00 0F 84 AE 01 00 00 48 8B 9C 24 00 01 00 00 E9 9E FE FF FF 0F 84 F7 01 00 00 48 8B 94 24 00 01 00 00 48 85 F6 C7 02 01 00 00 00 0F 94 C2 31 DB E9 4B FC FF FF 0F 85 97 FC FF FF E9 F7 00 00 00 90 48 85 DB 0F 85 DC FE FF FF 48 8B 05 ?? ?? ?? ?? 4C 39 68 08 0F 85 CB FE FF FF 48 3B 08 0F 85 C2 FE FF FF 48 8B 05 ?? ?? ?? ?? 45 31 ED 48 8B 88 98 00 00 00 48 8B 84 24 E0 00 00 00 C7 00 01 00 00 00 E9 AC FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 3B 58 10 0F 85 84 FE FF FF 4C 39 68 08 0F 85 7A FE FF FF 48 3B 08 0F 85 71 FE FF FF 48 8B 05 ?? ?? ?? ?? 31 DB 48 8B 88 20 01 00 00 4C 8B A8 28 01 00 00 48 8B 84 24 E0 00 00 00 C7 00 01 00 00 00 E9 55 FE FF FF 66 90 48 8B 54 24 68 48 09 C2 48 09 FA 0F 84 E5 FD FF FF 4C 8B 05 ?? ?? ?? ?? 4B 8D 14 7F 4D 8D 0C D0 49 3B 79 10 0F 87 62 FB FF FF BA 01 00 00 00 0F 85 6A FB FF FF 49 3B 41 08 0F 87 4D FB FF FF 0F 84 1F 01 00 00 4D 85 F6 0F 85 A3 FB FF FF 84 D2 0F 84 9B FB FF FF 4B 8D 14 7F 49 8D 14 D0 48 3B 42 08 0F 82 56 FB FF FF 0F 85 83 FB FF FF 48 8B 44 24 68 48 3B 02 0F 86 42 FB FF FF E9 70 FB FF FF 48 83 E9 01 48 8B 84 24 F0 00 00 00 E9 3D FB FF FF 4C 39 68 08 0F 85 A9 FD FF FF 48 3B 08 0F 85 A0 FD FF FF 41 8D 41 D8 48 98 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 48 8B 08 4C 8B 68 08 48 8B 58 10 48 8B 84 24 E0 00 00 00 C7 00 01 00 00 00 E9 7F FD FF FF 4C 8B 44 24 68 49 09 C0 49 09 F8 4D 09 F0 49 09 F0 0F 84 3B FE FF FF 48 85 F6 0F 85 D5 FC FF FF 4D 85 F6 0F 85 CC FC FF FF 4C 8B 05 ?? ?? ?? ?? 4F 8D 0C 7F 4F 8D 0C C8 49 3B 79 10 0F 87 B3 FC FF FF 74 5F 48 85 D2 0F 94 C2 45 31 ED 31 DB E9 77 FA FF FF 0F 1F 84 00 00 00 00 00 4D 85 F6 41 0F 95 C1 48 85 C0 41 0F 95 C0 48 83 7C 24 68 00 0F 95 C2 44 09 C2 48 85 FF 41 0F 95 C0 44 08 C2 75 55 45 84 C9 0F 84 DA FD FF FF E9 77 FB FF FF 48 8B 74 24 68 49 3B 31 0F 86 D3 FE FF FF E9 15 FA FF FF 49 3B 41 08 0F 87 48 FC FF FF 74 13 48 85 D2 0F 94 C2 45 31 F6 45 31 ED 31 DB E9 AF FE FF FF 4D 6B CF 18 48 8B 5C 24 68 4B 3B 1C 08 0F 87 20 FC FF FF EB D8 45 84 C9 0F 85 27 FB FF FF 4C 8B 05 ?? ?? ?? ?? 4B 8D 14 7F 49 8D 14 D0 48 3B 7A 10 0F 87 0E FB FF FF 0F 85 16 FB FF FF 48 3B 42 08 0F 87 FE FA FF FF 74 0D 48 85 F6 0F 94 C2 31 DB E9 59 FE FF FF 49 6B D7 18 48 8B 5C 24 68 49 3B 1C 10 0F 87 DC FA FF FF EB DE 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_10_3_0 {
	meta:
		name = "__bid_round256_58_76"
		size = 5248
		refs = "005c .refptr.__bid_midpoint64 0093 .refptr.__bid_Kx256 0822 .refptr.__bid_Ex256m256 086f .refptr.__bid_mask256 0883 .refptr.__bid_half256 08e7 .refptr.__bid_ten2k64 0946 .refptr.__bid_midpoint128 09d8 .refptr.__bid_midpoint192 0c11 .refptr.__bid_ten2mxtrunc256 0c6a .refptr.__bid_ten2k256 0d45 .refptr.__bid_ten2k128 0d76 .refptr.__bid_midpoint256"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC D8 00 00 00 49 8B 78 10 49 8B 00 89 94 24 28 01 00 00 8B B4 24 28 01 00 00 89 8C 24 20 01 00 00 4C 89 8C 24 38 01 00 00 48 89 7C 24 50 49 8B 78 18 83 EE 01 49 8B 50 08 83 FE 12 89 74 24 14 48 89 7C 24 58 0F 8F D8 08 00 00 48 8B 0D ?? ?? ?? ?? 48 63 F6 48 89 74 24 18 48 03 04 F1 0F 82 22 09 00 00 49 89 D3 89 D2 49 C1 EB 20 4C 8B 64 24 18 49 89 C2 89 C0 49 C1 EA 20 4C 89 D5 49 C1 E4 05 4C 03 25 ?? ?? ?? ?? 49 8B 0C 24 41 89 CF 48 89 CB 48 89 C1 49 0F AF CF 48 C1 EB 20 49 0F AF EF 48 89 DE 48 89 5C 24 20 49 0F AF F2 49 89 C8 89 C9 41 89 E9 49 C1 E8 20 4D 01 C8 49 89 D9 48 89 74 24 60 4C 0F AF C8 4D 01 C1 4D 89 C8 49 C1 E0 20 49 8D 3C 08 49 8B 4C 24 08 48 89 BC 24 C8 00 00 00 89 CB 48 89 CF 48 C1 EF 20 48 89 D9 48 89 DE 48 0F AF C8 48 89 5C 24 30 48 89 FB 49 0F AF F2 48 89 7C 24 28 49 0F AF DA 49 89 C8 89 C9 49 C1 E8 20 48 89 5C 24 68 89 F3 49 01 D8 48 89 FB 48 0F AF D8 49 01 D8 4D 89 C6 4C 89 44 24 70 49 C1 E6 20 4C 01 F1 48 89 4C 24 78 49 8B 4C 24 10 49 89 CE 89 C9 49 89 CD 48 89 4C 24 40 49 C1 EE 20 4D 0F AF EA 4D 89 F0 4C 89 74 24 38 48 0F AF C8 4D 0F AF F2 44 89 EF 49 C1 ED 20 48 89 CB 48 C1 E9 20 48 01 F9 4C 89 C7 4D 01 EE 48 0F AF F8 89 DB 48 01 CF 49 8B 4C 24 18 49 89 FD 49 C1 ED 20 4D 01 F5 49 89 CE 89 C9 49 C1 EE 20 49 89 CC 48 89 4C 24 48 4C 89 74 24 08 48 C1 ED 20 48 03 6C 24 60 48 0F AF C8 49 C1 E9 20 48 0F AF 44 24 08 4D 0F AF E2 4C 01 CD 49 89 C8 89 C9 49 C1 E8 20 4D 0F AF D6 45 89 E6 49 C1 EC 20 4D 01 C6 4C 8B 44 24 70 49 01 C6 4D 01 E2 4D 89 F4 49 C1 E6 20 49 C1 EC 20 49 01 CE 4D 01 E2 48 03 6C 24 78 0F 92 C0 48 C1 EE 20 48 03 74 24 68 48 C1 E7 20 49 C1 E8 20 0F B6 C0 48 01 DF 48 89 AC 24 88 00 00 00 48 01 C7 4C 01 C6 48 01 FE 48 89 B4 24 90 00 00 00 0F 82 CA 08 00 00 48 39 F8 0F 87 C1 08 00 00 4D 01 EE 0F 92 C0 4C 89 74 24 60 0F B6 C0 48 89 D7 4C 89 DD 48 8B 74 24 20 49 0F AF FF 4C 01 D0 48 8B 5C 24 28 49 0F AF EF 48 89 44 24 70 48 89 F0 49 89 DE 48 89 F9 41 89 E8 48 C1 E9 20 4C 01 C1 49 89 F0 4C 0F AF C2 49 0F AF C3 4D 0F AF F3 49 01 C8 4C 89 C1 48 89 44 24 68 89 F8 48 C1 E1 20 48 8B 7C 24 30 48 8D 34 01 48 89 B4 24 98 00 00 00 48 89 FE 48 0F AF FA 49 0F AF F3 48 89 F9 41 89 F1 48 C1 E9 20 4C 01 C9 49 89 D9 89 FB 4C 0F AF CA 4C 01 C9 49 89 C9 49 C1 E1 20 49 8D 3C 19 4C 8B 4C 24 40 48 8B 5C 24 38 48 89 7C 24 78 4D 89 CA 49 89 DC 4C 0F AF CA 4D 0F AF D3 4D 0F AF E3 4D 89 CD 45 89 C9 49 C1 ED 20 44 89 D7 49 C1 EA 20 4C 89 E8 4D 01 D4 48 01 F8 48 89 DF 48 8B 5C 24 48 48 0F AF FA 48 01 C7 49 89 FA 49 C1 EA 20 4D 01 E2 49 89 DC 48 0F AF DA 4D 0F AF E3 4C 0F AF 5C 24 08 48 89 D8 49 89 C5 44 89 E3 89 C0 49 C1 ED 20 49 01 DD 48 0F AF 54 24 08 48 C1 ED 20 48 03 6C 24 68 49 C1 EC 20 4D 01 E3 49 C1 E8 20 4C 01 C5 49 01 D5 4D 89 EC 49 C1 E5 20 49 C1 EC 20 49 01 C5 4D 01 E3 48 03 6C 24 78 0F 92 C2 48 C1 E7 20 48 C1 EE 20 4C 01 CF 4C 01 F6 48 C1 E9 20 0F B6 D2 48 01 CE 48 89 AC 24 A0 00 00 00 48 01 D7 48 01 FE 48 89 74 24 78 0F 82 7F 06 00 00 48 39 FA 0F 87 76 06 00 00 4D 01 D5 0F 92 C0 4C 89 6C 24 68 0F B6 C0 4C 01 D8 48 8B 5C 24 20 4C 8B 5C 24 28 48 89 84 24 A8 00 00 00 48 8B 44 24 50 48 89 DE 4D 89 DE 49 89 C1 89 C0 49 C1 E9 20 48 89 C2 49 0F AF D7 4C 89 CF 49 0F AF FF 49 0F AF F1 48 89 D1 89 D2 41 89 F8 48 C1 E9 20 4C 01 C1 49 89 D8 48 89 74 24 50 4C 0F AF C0 4D 0F AF F1 49 01 C8 4C 89 C1 48 C1 E1 20 48 8D 1C 11 48 8B 54 24 30 48 89 9C 24 B0 00 00 00 48 89 D3 48 0F AF D0 49 0F AF D9 48 89 D1 41 89 DA 48 C1 E9 20 4C 01 D1 4D 89 DA 41 89 D3 4C 0F AF D0 4C 01 D1 49 89 CA 49 C1 E2 20 4B 8D 14 1A 4C 8B 54 24 40 4C 8B 5C 24 38 48 89 94 24 80 00 00 00 4D 89 D4 4C 89 DD 4C 0F AF D0 4D 0F AF E1 49 0F AF E9 4C 89 D2 45 89 D2 44 89 E6 48 C1 EA 20 49 C1 EC 20 48 01 F2 4C 89 DE 4C 01 E5 48 0F AF F0 48 01 D6 48 8B 54 24 48 49 89 F4 49 C1 EC 20 49 01 EC 48 89 D5 48 0F AF D0 49 0F AF E9 4C 0F AF 4C 24 08 49 89 D5 89 D2 41 89 EB 49 C1 ED 20 4D 01 DD 48 C1 EF 20 48 03 7C 24 50 48 0F AF 44 24 08 48 C1 ED 20 49 C1 E8 20 49 01 E9 4C 01 C7 49 01 C5 4C 89 ED 49 C1 E5 20 48 C1 ED 20 49 01 D5 49 01 E9 48 03 BC 24 80 00 00 00 0F 92 C2 48 C1 E6 20 48 C1 EB 20 4C 01 D6 4C 01 F3 48 C1 E9 20 0F B6 D2 48 01 CB 48 89 BC 24 B8 00 00 00 48 01 D6 48 01 F3 48 89 9C 24 80 00 00 00 0F 82 7F 05 00 00 48 39 F2 0F 87 76 05 00 00 4D 01 E5 0F 92 C0 4C 89 6C 24 50 0F B6 C0 4C 01 C8 48 8B 74 24 20 48 89 84 24 C0 00 00 00 48 8B 44 24 58 49 89 C1 89 C1 48 89 F0 49 C1 E9 20 4C 89 CF 49 0F AF FF 4C 0F AF F9 49 0F AF C1 41 89 F8 4C 89 FA 48 C1 EA 20 48 89 44 24 20 44 89 F8 4C 01 C2 49 89 F0 4C 8B 7C 24 38 4C 0F AF C1 4C 01 C2 49 89 D0 49 C1 E0 20 49 8D 34 00 4C 8B 44 24 30 48 89 74 24 58 48 8B 74 24 28 4C 89 C3 4C 0F AF C1 49 0F AF D9 49 89 F6 4D 0F AF F1 4C 89 C0 45 89 C3 4D 89 F8 41 89 DA 48 C1 E8 20 4C 01 D0 49 89 F2 4C 0F AF D1 4D 0F AF C1 4C 01 D0 49 89 C2 49 C1 E2 20 4D 01 D3 4C 8B 54 24 40 4D 89 D5 4C 0F AF D1 4D 0F AF E9 4C 89 D6 45 89 D2 44 89 ED 48 C1 EE 20 49 C1 ED 20 48 01 EE 4C 89 FD 4D 01 E8 48 0F AF E9 48 01 EE 49 89 F5 49 C1 ED 20 4D 01 C5 4C 8B 44 24 48 4C 89 C5 4C 0F AF C1 49 0F AF E9 4C 0F AF 4C 24 08 4D 89 C4 45 89 C0 49 C1 EC 20 41 89 EF 48 C1 EF 20 48 0F AF 4C 24 08 48 03 7C 24 20 4D 01 FC 48 C1 ED 20 48 C1 EA 20 49 01 E9 48 01 D7 49 01 CC 31 C9 4C 89 E5 49 C1 E4 20 48 C1 ED 20 4D 01 C4 49 01 E9 49 01 FB 0F 92 C1 48 C1 EB 20 48 C1 E6 20 4C 01 F3 48 C1 E8 20 49 01 F2 4C 8D 3C 03 49 01 CA 4D 01 D7 0F 82 E3 03 00 00 4C 39 D1 0F 87 DA 03 00 00 4C 89 E7 31 C0 4C 01 EF 0F 92 C0 49 01 C1 4C 8B A4 24 88 00 00 00 31 C0 4C 03 A4 24 98 00 00 00 48 8B AC 24 A0 00 00 00 48 8B B4 24 90 00 00 00 0F 92 C0 48 01 C5 48 01 EE 0F 82 67 03 00 00 48 39 E8 0F 87 5E 03 00 00 31 D2 4C 8B 74 24 60 4C 03 74 24 78 0F 92 C2 48 8B 44 24 68 4C 8B 54 24 70 48 01 D0 49 01 C2 0F 92 C1 48 39 D0 0F 92 C0 09 C1 0F B6 C9 48 8B AC 24 A8 00 00 00 31 D2 48 8B 9C 24 B8 00 00 00 48 01 CD 48 03 B4 24 B0 00 00 00 0F 92 C2 48 01 D3 49 01 DE 0F 82 D8 02 00 00 48 39 DA 0F 87 CF 02 00 00 31 C9 4C 03 94 24 80 00 00 00 0F 92 C1 4C 8B 6C 24 50 49 01 CD 4C 01 ED 0F 92 C0 49 39 CD 0F 92 C2 09 D0 0F B6 D0 31 C0 48 03 94 24 C0 00 00 00 4C 03 74 24 58 0F 92 C0 49 01 C3 4D 01 DA 0F 82 47 02 00 00 4C 39 D8 0F 87 3E 02 00 00 31 DB 4C 01 FD 0F 92 C3 4C 8D 2C 3B 4C 01 EA 0F 92 C0 49 39 DD 41 0F 92 C3 44 09 D8 0F B6 C0 83 7C 24 14 12 4D 8D 1C 01 48 8B 7C 24 18 48 8B 05 ?? ?? ?? ?? 44 8B 04 B8 0F 8F 30 03 00 00 41 BF 40 00 00 00 4D 89 DD 44 89 C1 45 29 C7 49 D3 ED 48 89 D0 44 89 F9 49 D3 E3 44 89 C1 48 D3 E8 4C 09 D8 49 89 EB 49 D3 EB 44 89 F9 4D 89 D7 48 D3 E2 4C 89 DB 48 D3 E5 48 09 D3 48 8B 15 ?? ?? ?? ?? 44 89 C1 49 D3 EF 49 09 EF 4C 23 14 FA 48 8B 15 ?? ?? ?? ?? 4C 3B 14 FA 0F 87 4F 03 00 00 0F 84 C9 07 00 00 48 8B BC 24 60 01 00 00 BA 01 00 00 00 B9 01 00 00 00 84 CA C7 07 01 00 00 00 0F 85 49 03 00 00 66 0F 1F 84 00 00 00 00 00 8B 94 24 20 01 00 00 2B 94 24 28 01 00 00 83 FA 13 0F 8F 59 03 00 00 48 89 C6 4C 09 EE 75 19 48 85 DB 75 14 48 8B 0D ?? ?? ?? ?? 4C 63 C2 4E 3B 3C C1 0F 84 48 08 00 00 48 8B BC 24 40 01 00 00 C7 07 00 00 00 00 48 8B B4 24 38 01 00 00 4C 89 6E 18 48 89 46 10 48 89 5E 08 4C 89 3E 48 81 C4 D8 00 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 83 7C 24 14 25 0F 8F 84 00 00 00 8B 9C 24 28 01 00 00 4C 8B 0D ?? ?? ?? ?? 8D 4B EC 48 63 C9 49 89 C8 49 C1 E0 04 4D 01 C8 49 03 00 0F 82 8F 04 00 00 48 C1 E1 04 49 03 54 09 08 73 0E 48 83 44 24 50 01 75 06 48 83 44 24 58 01 48 63 5C 24 14 49 89 D3 89 D2 49 C1 EB 20 48 89 5C 24 18 E9 E7 F6 FF FF 48 83 C2 01 0F 85 D4 F6 FF FF 48 83 44 24 50 01 0F 85 46 06 00 00 48 83 44 24 58 01 31 D2 45 31 DB E9 C1 F6 FF FF 66 0F 1F 44 00 00 83 7C 24 14 39 8B B4 24 28 01 00 00 0F 8F 9E 03 00 00 8D 4E D9 4C 8B 05 ?? ?? ?? ?? 48 63 C9 4C 8D 0C 49 4F 8D 14 C8 49 03 02 73 0A 48 83 C2 01 0F 84 AA 04 00 00 4C 8D 0C 49 4F 8D 14 C8 4C 8B 4C 24 50 49 03 52 08 0F 83 AA 04 00 00 49 83 C1 01 0F 85 A0 04 00 00 49 8B 7A 10 48 83 44 24 58 01 48 89 7C 24 50 E9 AF 03 00 00 0F 1F 44 00 00 49 83 C7 01 4C 01 FD 0F 82 F7 00 00 00 4D 85 FF 0F 84 EE 00 00 00 31 C0 48 01 FA 0F 92 C0 E9 BE FD FF FF 49 83 C5 01 4D 01 EA 0F 92 C0 4D 85 ED 4C 89 54 24 68 41 0F 94 C4 44 09 E0 0F B6 C0 E9 77 F9 FF FF 48 8B 9C 24 80 00 00 00 48 83 C3 01 49 01 DA 0F 82 B7 00 00 00 48 85 DB 0F 84 AE 00 00 00 31 D2 48 03 6C 24 50 0F 92 C2 E9 2A FD FF FF 48 8B 4C 24 78 4C 8B 74 24 60 48 83 C1 01 49 01 CE 0F 82 98 00 00 00 48 85 C9 0F 84 8F 00 00 00 31 C9 4C 8B 54 24 68 4C 03 54 24 70 0F 92 C1 E9 9B FC FF FF 49 83 C4 01 4C 89 EF 4C 01 E7 0F 92 C0 4D 85 E4 40 0F 94 C5 09 E8 0F B6 C0 E9 13 FC FF FF 49 83 C5 01 4D 01 EC 0F 92 C0 4D 85 ED 4C 89 64 24 50 40 0F 94 C5 09 E8 0F B6 C0 E9 78 FA FF FF 49 83 C6 01 4D 01 F5 0F 92 C0 4D 85 F6 4C 89 6C 24 60 41 0F 94 C4 44 09 E0 0F B6 C0 E9 2C F7 FF FF BB 01 00 00 00 E9 BC FC FF FF 66 90 B9 01 00 00 00 E9 68 FC FF FF 66 0F 1F 44 00 00 BA 01 00 00 00 E9 F8 FB FF FF 66 0F 1F 44 00 00 83 7C 24 14 25 0F 8F 55 01 00 00 41 BD 40 00 00 00 4C 89 D8 44 89 C1 45 29 C5 48 D3 E8 48 89 D3 44 89 E9 48 8B 7C 24 18 49 D3 E3 44 89 C1 48 D3 EB 4C 09 DB 49 89 EB 49 D3 EB 44 89 E9 48 D3 E2 4D 89 DF 49 09 D7 48 8B 15 ?? ?? ?? ?? 48 23 2C FA 48 8B 15 ?? ?? ?? ?? 48 3B 2C FA 0F 86 5E 02 00 00 48 8B BC 24 58 01 00 00 48 85 ED C7 07 01 00 00 00 BA 01 00 00 00 0F 94 C1 45 31 ED EB 18 48 8B BC 24 58 01 00 00 BA 01 00 00 00 B9 01 00 00 00 C7 07 01 00 00 00 84 CA 0F 84 C0 FC FF FF 4D 85 D2 0F 85 B7 FC FF FF 48 8B 54 24 18 4C 8B 05 ?? ?? ?? ?? 48 C1 E2 05 4D 3B 74 10 18 0F 82 DC 04 00 00 0F 85 96 FC FF FF E9 9C 04 00 00 90 83 FA 14 0F 84 AA 02 00 00 83 FA 26 0F 8E EE 00 00 00 83 FA 27 0F 84 B5 03 00 00 83 FA 39 0F 8F 30 03 00 00 4D 85 ED 0F 85 F6 00 00 00 8D 4A D9 48 63 C9 48 C1 E1 05 48 03 0D ?? ?? ?? ?? 48 39 41 10 0F 85 DB 00 00 00 48 39 59 08 0F 85 D1 00 00 00 4C 3B 39 0F 85 C8 00 00 00 8D 42 D8 48 8B B4 24 40 01 00 00 48 98 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 4C 8B 38 48 8B 58 08 48 8B 40 10 C7 06 01 00 00 00 E9 4D FC FF FF 0F 1F 80 00 00 00 00 83 7C 24 14 38 0F 8F 68 01 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 7C 24 18 4C 89 DB 44 89 C1 49 89 D7 48 D3 EB B9 40 00 00 00 44 29 C1 48 23 14 F8 49 D3 E3 44 89 C1 49 D3 EF 4D 09 DF 48 8B 05 ?? ?? ?? ?? 48 8B 7C 24 18 48 8B 04 F8 48 39 D0 0F 82 4C 02 00 00 48 39 C2 0F 84 53 05 00 00 48 8B 84 24 60 01 00 00 E9 3E 02 00 00 66 0F 1F 44 00 00 48 89 C6 4C 09 EE 75 1B 8D 4A EC 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 39 59 08 0F 84 4D 04 00 00 48 8B B4 24 40 01 00 00 C7 06 00 00 00 00 E9 A0 FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 8D 4E C5 4C 8B 0D ?? ?? ?? ?? 48 63 C9 49 89 C8 49 C1 E0 05 4D 01 C8 49 03 00 73 0A 48 83 C2 01 0F 84 EA 03 00 00 49 89 C8 4C 8B 54 24 50 49 C1 E0 05 4D 01 C8 49 03 50 08 73 0A 49 83 C2 01 0F 84 AD 03 00 00 49 89 C8 49 C1 E0 05 4F 03 54 01 10 48 83 54 24 58 00 4C 89 54 24 50 48 C1 E1 05 49 8B 5C 09 18 48 01 5C 24 58 48 63 74 24 14 49 89 D3 89 D2 49 C1 EB 20 48 89 74 24 18 E9 89 F2 FF FF 48 83 C2 01 0F 85 67 FB FF FF 48 83 44 24 50 01 49 8B 50 08 48 8B 5C 24 50 48 83 FB 01 48 83 54 24 58 00 E9 62 FB FF FF 66 0F 1F 44 00 00 0F 84 EA 04 00 00 48 8B BC 24 60 01 00 00 E9 97 FD FF FF 83 7C 24 14 39 4D 89 DF 0F 84 94 04 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 5C 24 18 44 89 C1 49 D3 EF 4C 23 1C D8 48 8B 05 ?? ?? ?? ?? 4C 3B 1C D8 4D 89 D9 76 29 48 8B 84 24 58 01 00 00 48 85 ED C7 00 01 00 00 00 0F 94 C1 49 09 D1 0F 94 C2 31 DB 31 C0 45 31 ED E9 6B FD FF FF 0F 1F 00 0F 84 4A 03 00 00 48 8B 84 24 60 01 00 00 EB CF 4C 8B 4C 24 50 49 8B 52 08 49 83 C1 01 49 83 F9 01 48 83 54 24 58 00 48 8D 0C 49 4D 03 4C C8 10 4C 89 4C 24 50 0F 82 AB FA FF FF 48 63 7C 24 14 49 89 D3 89 D2 49 C1 EB 20 48 89 7C 24 18 E9 98 F1 FF FF 48 89 C6 4C 09 EE 0F 85 64 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 39 5A 08 0F 85 53 FE FF FF 4C 3B 3A 0F 85 4A FE FF FF 48 8B 05 ?? ?? ?? ?? 45 31 ED 31 DB 4C 8B B8 98 00 00 00 48 8B 84 24 40 01 00 00 C7 00 01 00 00 00 31 C0 E9 D5 F9 FF FF 4C 3B 60 08 77 29 0F 85 C6 04 00 00 48 8B 44 24 18 48 8B BC 24 C8 00 00 00 48 C1 E0 05 49 3B 3C 00 0F 86 AB 04 00 00 0F 1F 84 00 00 00 00 00 48 8B 84 24 58 01 00 00 48 85 ED C7 00 01 00 00 00 0F 94 C1 48 85 D2 0F 94 C2 31 C0 45 31 ED E9 74 FC FF FF 8D 4A D9 48 63 C9 48 C1 E1 05 48 03 0D ?? ?? ?? ?? 4C 39 69 18 0F 85 B4 FD FF FF 48 39 41 10 0F 85 AA FD FF FF 48 39 59 08 0F 85 A0 FD FF FF 4C 3B 39 0F 85 97 FD FF FF 83 EA 28 48 8B B4 24 40 01 00 00 48 63 D2 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 4C 8B 3A 48 8B 5A 08 48 8B 42 10 4C 8B 6A 18 C7 06 01 00 00 00 E9 17 F9 FF FF 90 31 D2 45 31 DB E9 81 F0 FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__addvti3"
		size = 96
		refs = "0031 abort"
	strings:
		$1 = { 53 48 83 EC 30 4C 8B 09 4C 8B 51 08 48 8B 0A 48 8B 5A 08 4C 89 C8 4C 89 D2 48 01 C8 48 11 DA 48 85 DB 78 11 4C 39 D2 7C 07 7F 16 4C 39 C8 73 11 E8 ?? ?? ?? ?? 4C 39 D2 7F F6 7C 05 4C 39 C8 77 EF 48 89 44 24 20 48 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 30 5B C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "__powisf2"
		size = 80
		refs = "0004 .rdata"
	strings:
		$1 = { F3 0F 10 0D ?? ?? ?? ?? 89 D1 C1 F9 1F 89 C8 31 D0 29 C8 A8 01 74 09 0F 28 C8 66 0F 1F 44 00 00 D1 E8 74 10 A8 01 F3 0F 59 C0 74 F4 D1 E8 F3 0F 59 C8 75 F0 85 D2 0F 28 C1 78 05 F3 C3 0F 1F 00 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5E C8 0F 28 C1 C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__fixtfsi"
		size = 304
		refs = "0062 __sfp_handle_exceptions"
	strings:
		$1 = { 48 83 EC 48 66 0F 6F 01 C7 44 24 3C 00 00 00 00 0F 29 44 24 20 0F AE 5C 24 3C 48 BA FF FF FF FF FF FF 00 00 48 8B 44 24 28 4C 8B 54 24 20 48 89 C1 48 21 C2 48 C1 E8 3F 48 C1 E9 30 49 89 D0 66 81 E1 FF 7F 44 0F B7 C9 49 81 F9 FE 3F 00 00 7F 1F 31 C0 4D 85 C9 74 59 B9 20 00 00 00 89 44 24 20 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 48 C3 90 49 81 F9 1D 40 00 00 7E 47 49 81 F9 1E 40 00 00 8D 90 FF FF FF 7F 0F 85 94 00 00 00 84 C0 0F 84 8C 00 00 00 4C 89 C0 48 C1 E8 11 48 85 C0 0F 85 7C 00 00 00 49 C1 E0 2F 89 D0 4D 09 D0 75 A9 EB B9 4D 09 D0 74 B4 B9 22 00 00 00 EB A0 0F 1F 00 48 BA 00 00 00 00 00 00 01 00 4C 09 C2 44 0F B7 C1 B9 2F 40 00 00 44 29 C1 49 89 D1 49 D3 E9 41 8D 88 11 C0 FF FF 48 D3 E2 4C 09 D2 74 16 0F B6 D0 B9 20 00 00 00 89 D0 F7 D8 44 31 C8 01 D0 E9 59 FF FF FF 0F B6 C0 89 C2 F7 DA 41 31 D1 44 01 C8 48 83 C4 48 C3 66 2E 0F 1F 84 00 00 00 00 00 89 D0 B9 01 00 00 00 E9 31 FF FF FF 90 90 90 90 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__bid128_to_int64_rnint"
		size = 1984
		refs = "009b .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 0210 .refptr.__bid_midpoint128 03c1 .refptr.__bid_midpoint64 043d .refptr.__bid_ten2mk128 05a0 .refptr.__bid_shiftright128 05c4 .refptr.__bid_maskhigh128 05f9 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 84 26 02 00 00 83 FB 13 0F 8F 3C 06 00 00 B8 14 00 00 00 4C 8B 15 ?? ?? ?? ?? 44 89 D9 29 D8 4C 89 DF 48 98 48 C1 EF 20 4D 8B 14 C2 4C 89 D0 45 89 D2 4C 89 D3 48 C1 E8 20 4C 0F AF D1 48 0F AF DF 48 0F AF C8 4C 89 D6 45 89 D2 89 DD 48 C1 EE 20 48 C1 EB 20 48 0F AF F8 48 01 EE 48 8D 04 0E 48 89 C1 48 C1 E0 20 48 8D 1C 3B 48 C1 E9 20 4C 01 D0 41 BA 05 00 00 00 48 01 CB B9 05 00 00 00 48 39 D9 72 16 0F 85 30 02 00 00 49 39 C2 0F 83 27 02 00 00 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 0B 02 00 00 48 85 D2 0F 84 DE 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 8B 18 85 DB 75 19 8B 58 18 48 8B 40 08 48 39 C2 0F 87 D7 01 00 00 48 39 C2 0F 84 B9 01 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 46 8D 14 03 41 83 FA 13 0F 8F 51 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 13 0F 84 9B FE FF FF 31 C0 45 85 D2 0F 88 7F FE FF FF 0F 85 49 01 00 00 8D 4B FF 83 F9 12 0F 8E B2 01 00 00 8D 4B EC 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 82 52 FE FF FF 0F 84 5B 05 00 00 49 83 F9 01 48 19 C0 83 E0 02 48 83 E8 01 E9 39 FE FF FF 66 0F 1F 84 00 00 00 00 00 31 C0 4D 85 DB 0F 84 25 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 32 01 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 8B 18 85 DB 0F 85 0E FF FF FF 8B 58 18 48 8B 40 08 E9 F9 FE FF FF 83 FB 13 0F 8F 80 03 00 00 B8 14 00 00 00 4C 8B 15 ?? ?? ?? ?? 44 89 D9 29 D8 4C 89 DF 48 98 48 C1 EF 20 4D 8B 14 C2 4C 89 D0 45 89 D2 4C 89 D3 48 C1 E8 20 4C 0F AF D1 48 0F AF DF 48 0F AF C8 4C 89 D6 45 89 D2 89 DD 48 C1 EE 20 48 C1 EB 20 48 0F AF F8 48 01 EE 48 8D 04 0E 48 C7 C6 FB FF FF FF 48 89 C1 48 C1 E0 20 48 8D 1C 3B 48 C1 E9 20 4C 01 D0 48 01 CB B9 04 00 00 00 48 39 D9 0F 82 EB FD FF FF 75 09 48 39 C6 0F 86 E0 FD FF FF 45 85 C0 0F 88 BA 00 00 00 0F 85 91 00 00 00 4C 89 D8 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 0C FD FF FF 31 C0 E9 05 FD FF FF 49 C1 E0 05 4F 39 5C 01 10 0F 87 38 FE FF FF 66 0F 1F 44 00 00 83 C3 01 E9 2A FE FF FF 0F 1F 84 00 00 00 00 00 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 D0 FE FF FF 48 85 D2 0F 85 66 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 63 C9 4C 39 1C CA 0F 83 9E FC FF FF E9 4D FE FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 C9 4D 63 C0 0F 84 39 02 00 00 48 8B 15 ?? ?? ?? ?? 49 F7 DB 4C 89 D8 4A 0F AF 04 C2 E9 6D FC FF FF 44 89 C0 F7 D8 83 F8 13 89 44 24 04 0F 8F 40 03 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C3 4C 89 D5 48 83 D2 00 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 45 89 D2 48 C1 ED 20 4C 89 D7 48 89 E8 49 89 ED 4D 89 D6 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F9 49 C1 EB 20 48 0F AF C1 4D 0F AF EB 49 89 FC 89 FF 89 C6 49 C1 EC 20 48 C1 E8 20 49 01 F4 4C 89 D6 4C 01 E8 49 0F AF F3 49 89 ED 49 01 F4 4C 89 E6 49 C1 E4 20 48 C1 EE 20 4C 01 E7 48 01 C6 48 8B 03 48 89 C3 89 C0 4C 0F AF E8 48 C1 EB 20 4C 0F AF F0 4C 0F AF D3 45 89 EF 49 C1 ED 20 4C 89 74 24 08 49 C1 EE 20 48 0F AF EB 4D 01 FE 4D 01 F2 4D 89 D7 49 C1 EF 20 49 01 ED 4D 01 EF 49 01 FF 48 89 D7 89 D2 48 83 D6 00 48 C1 EF 20 48 89 FD 49 89 FC 48 0F AF E9 48 0F AF CA 4D 0F AF E3 41 89 EE 48 C1 ED 20 49 89 CD 89 C9 4C 0F AF DA 49 C1 ED 20 4C 01 E5 4D 01 F5 4D 01 EB 4D 89 DC 49 C1 E3 20 49 C1 EC 20 4C 01 D9 4C 01 E5 49 89 FC 4C 0F AF E0 48 0F AF C2 48 0F AF D3 45 89 E6 49 C1 EC 20 49 89 C5 89 C0 48 0F AF FB 49 C1 ED 20 4D 01 F5 49 01 D5 4C 89 EA 49 C1 E5 20 4C 01 E7 48 C1 EA 20 49 01 C5 48 01 FA 48 01 CA 48 83 D5 00 31 C9 4D 01 EF 0F 92 C1 48 01 CA 48 01 D6 0F 92 C0 48 39 D1 0F 97 C2 09 D0 0F B6 C0 48 01 E8 83 7C 24 04 16 0F 8F 91 01 00 00 48 8B 15 ?? ?? ?? ?? 46 8B 1C 82 BA 40 00 00 00 44 29 DA 89 D1 48 89 F2 48 D3 E0 44 89 D9 48 D3 EA 48 09 D0 48 8B 15 ?? ?? ?? ?? 4A 23 34 C2 31 D2 48 09 D6 0F 85 7B FD FF FF 8B 54 24 08 49 C1 E2 20 4C 89 FE 49 8D 0C 12 48 09 CE 0F 84 63 FD FF FF 49 C1 E0 04 4C 89 C2 48 03 15 ?? ?? ?? ?? 4C 3B 7A 08 72 0F 0F 85 49 FD FF FF 48 3B 0A 0F 87 40 FD FF FF 48 89 C2 83 E2 01 48 83 FA 01 48 83 D0 FF E9 2D FD FF FF 48 8B 05 ?? ?? ?? ?? 4E 0F AF 1C C0 4C 89 D8 E9 37 FA FF FF 83 FB 14 0F 84 61 01 00 00 8D 43 EC 48 8B 0D ?? ?? ?? ?? 48 98 4C 8B 24 C1 4C 89 E5 44 89 E6 48 C1 ED 20 48 8D 0C B5 00 00 00 00 48 89 EF 48 8D 04 AD 00 00 00 00 48 C1 E7 20 48 89 FB 48 29 EF 48 29 C3 48 89 D8 48 89 F3 48 C1 E3 20 48 29 E8 49 89 DA 41 89 C5 48 29 F3 49 29 CA 48 C1 E8 20 49 29 F2 4C 89 D1 48 C1 E9 20 4C 01 E9 48 01 D9 44 89 D3 4E 8D 14 A7 48 89 CE 48 C1 E9 20 4C 01 D0 48 C1 E6 20 48 01 DE 48 01 C1 48 89 D3 4C 89 D8 E9 5D FC FF FF 83 FB 14 0F 84 B5 00 00 00 8D 43 EC 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 3C C1 48 89 F8 48 C1 E8 20 48 8D 34 80 89 F8 48 8D 1C 80 89 F0 48 C1 EE 20 48 89 D9 89 DB 48 C1 E9 20 48 01 C1 48 8D 04 BF 49 89 CA 48 C1 E9 20 48 01 C6 49 C1 E2 20 4C 89 D8 49 01 DA 48 01 F1 48 89 D3 E9 D7 F9 FF FF 48 8B 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 89 C7 42 8B 0C 81 4A 23 3C C2 83 E9 40 48 89 FA 48 D3 E8 E9 79 FE FF FF B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 AA FC FF FF 4C 39 19 0F 83 E8 F8 FF FF E9 97 FA FF FF 48 89 D3 4C 89 D8 B9 05 00 00 00 41 BA 05 00 00 00 E9 62 F9 FF FF 48 89 D3 4C 89 D8 B9 04 00 00 00 48 C7 C6 FB FF FF FF E9 72 FB FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "__bid128_to_int64_xrnint"
		size = 2352
		refs = "00a5 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 0212 .refptr.__bid_midpoint128 03c1 .refptr.__bid_midpoint64 0454 .refptr.__bid_ten2mk128 05be .refptr.__bid_maskhigh128 05df .refptr.__bid_shiftright128 0638 .refptr.__bid_ten2mk128trunc 07cb .refptr.__bid_onehalf128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 85 29 02 00 00 41 83 FA 13 0F 8F 02 06 00 00 B8 14 00 00 00 44 89 D9 4C 89 DF 44 29 D0 4C 8B 15 ?? ?? ?? ?? 48 C1 EF 20 48 98 4D 8B 14 C2 4C 89 D0 45 89 D2 4C 89 D3 48 C1 E8 20 4C 0F AF D1 48 0F AF DF 48 0F AF C8 4C 89 D6 45 89 D2 89 DD 48 C1 EE 20 48 C1 EB 20 48 0F AF F8 48 01 EE 48 8D 04 0E 48 C7 C6 FB FF FF FF 48 89 C1 48 C1 E0 20 48 8D 1C 3B 48 C1 E9 20 4C 01 D0 48 01 CB B9 04 00 00 00 48 39 D9 72 13 48 39 C6 0F 87 2A 02 00 00 48 39 D9 0F 85 21 02 00 00 90 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 0B 02 00 00 48 85 D2 0F 84 DE 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 75 1A 44 8B 50 18 48 8B 40 08 48 39 C2 0F 87 D4 01 00 00 48 39 C2 0F 84 B6 01 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 02 83 F8 13 0F 8F 4F FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 13 0F 84 9A FE FF FF 85 C0 0F 88 14 02 00 00 0F 85 4B 01 00 00 41 8D 42 FF 83 F8 12 0F 8E B3 01 00 00 41 8D 4A EC 31 C0 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 72 14 0F 84 08 06 00 00 49 83 F9 01 48 19 C0 83 E0 02 48 83 E8 01 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 31 FE FF FF 90 31 C0 4D 85 DB 0F 84 25 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 32 01 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 0F 85 0F FF FF FF 44 8B 50 18 48 8B 40 08 E9 F9 FE FF FF 41 83 FA 13 0F 8F 71 04 00 00 B0 14 44 89 D9 4C 89 DF 44 29 D0 4C 8B 15 ?? ?? ?? ?? 48 C1 EF 20 48 98 4D 8B 14 C2 4C 89 D0 45 89 D2 4C 89 D3 48 C1 E8 20 4C 0F AF D1 48 0F AF DF 48 0F AF C8 4C 89 D6 45 89 D2 89 DD 48 C1 EE 20 48 C1 EB 20 48 0F AF F8 48 01 EE 48 8D 04 0E 48 89 C1 48 C1 E0 20 48 8D 1C 3B 48 C1 E9 20 4C 01 D0 41 BA 05 00 00 00 48 01 CB B9 05 00 00 00 48 39 D9 0F 82 EA FD FF FF 49 39 C2 0F 82 D7 FD FF FF 90 45 85 C0 0F 88 CB 00 00 00 0F 85 91 00 00 00 4C 89 D8 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 0C FD FF FF 31 C0 E9 05 FD FF FF 49 C1 E0 05 4F 39 5C 01 10 0F 87 3B FE FF FF 66 0F 1F 44 00 00 41 83 C2 01 E9 2C FE FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 D0 FE FF FF 48 85 D2 0F 85 64 FE FF FF 48 8B 0D ?? ?? ?? ?? 48 63 D0 31 C0 4C 39 1C D1 0F 83 5C FE FF FF E9 49 FE FF FF 0F 1F 80 00 00 00 00 4D 85 C9 4D 63 C0 0F 84 96 02 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 4A 0F AF 04 C2 E9 6D FC FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 5C FC FF FF 44 89 C0 F7 D8 83 F8 13 89 44 24 0C 0F 8F DA 03 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 45 89 D2 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 EC 20 4C 89 D6 48 89 44 24 18 4C 89 E0 4C 89 E5 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF C1 49 0F AF EB 48 89 F7 89 F6 41 89 C5 48 C1 EF 20 48 C1 E8 20 4C 01 EF 4D 89 D5 48 01 E8 4D 0F AF EB 4C 01 EF 4D 89 D5 48 89 FD 48 C1 E7 20 48 C1 ED 20 48 01 FE 4C 8D 3C 28 48 8B 03 4C 89 E5 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF E8 4C 0F AF E3 48 0F AF E8 4C 89 64 24 10 4D 89 EC 45 89 ED 4C 0F AF D3 49 C1 EC 20 41 89 EE 4D 01 E6 4C 8B 64 24 10 48 C1 ED 20 4D 01 D6 49 01 EC 4D 89 F2 49 C1 E6 20 49 C1 EA 20 4D 01 EE 4D 01 D4 49 89 D2 89 D2 4C 01 E6 49 83 D7 00 49 C1 EA 20 4C 89 D5 4C 89 D7 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 ED 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 EC 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FD 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 EC 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 48 01 CA 48 83 D5 00 48 01 C6 0F 92 C0 0F B6 C0 48 01 C2 49 01 D7 0F 92 C1 48 39 D0 4D 89 FA 0F 97 C2 48 8B 05 ?? ?? ?? ?? 09 CA 0F B6 D2 48 01 D5 83 7C 24 0C 16 0F 8F E1 01 00 00 4D 89 FB 4E 23 1C C0 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 D3 E5 89 D1 49 D3 EA 4C 09 D5 83 7C 24 0C 03 0F 8F D7 02 00 00 48 B8 00 00 00 00 00 00 00 80 48 39 C6 77 0F 0F 85 8C 01 00 00 4D 85 F6 0F 84 83 01 00 00 4C 89 C0 48 BA 00 00 00 00 00 00 00 80 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 01 F2 48 3B 50 08 0F 87 5E 01 00 00 0F 84 32 02 00 00 4D 85 DB 75 26 48 89 F0 4C 09 F0 74 1E 49 C1 E0 04 4C 89 C0 48 03 05 ?? ?? ?? ?? 48 3B 70 08 0F 82 FA 01 00 00 0F 84 EB 01 00 00 48 89 E8 E9 D0 FC FF FF 48 8B 05 ?? ?? ?? ?? 4E 0F AF 1C C0 4C 89 D8 E9 DA F9 FF FF 41 83 FA 14 0F 84 98 01 00 00 41 8D 42 EC 48 8B 0D ?? ?? ?? ?? 48 98 4C 8B 24 C1 4C 89 E5 44 89 E6 48 C1 ED 20 48 8D 0C B5 00 00 00 00 48 89 EF 48 8D 04 AD 00 00 00 00 48 C1 E7 20 48 89 FB 48 29 EF 48 29 C3 48 89 D8 48 89 F3 48 C1 E3 20 48 29 E8 49 89 DA 41 89 C5 48 29 F3 49 29 CA 48 C1 E8 20 49 29 F2 4C 89 D1 48 C1 E9 20 4C 01 E9 48 01 D9 44 89 D3 4E 8D 14 A7 48 89 CE 48 C1 E9 20 4C 01 D0 48 C1 E6 20 48 01 DE 48 01 C1 48 89 D3 4C 89 D8 E9 DA F9 FF FF 41 83 FA 14 0F 84 17 01 00 00 41 8D 42 EC 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 3C C1 48 89 F8 48 C1 E8 20 48 8D 34 80 89 F8 48 8D 1C 80 89 F0 48 C1 EE 20 48 89 D9 89 DB 48 C1 E9 20 48 01 C1 48 8D 04 BF 49 89 CA 48 C1 E9 20 48 01 C6 49 C1 E2 20 4C 89 D8 49 01 DA 48 01 F1 48 89 D3 E9 9E FB FF FF 4C 89 DB 48 29 C3 49 39 DB 48 89 D8 48 19 D2 48 09 D0 0F 84 5C 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 E9 99 FE FF FF 48 89 EA 4A 23 14 C0 48 8B 05 ?? ?? ?? ?? 42 8B 0C 80 48 8B 05 ?? ?? ?? ?? 83 E9 40 48 D3 ED 4A 3B 14 C0 77 06 0F 84 AE 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 48 85 D2 0F 85 86 FE FF FF 4D 89 D3 E9 53 FE FF FF 0F 1F 40 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 10 FC FF FF 4C 39 19 0F 83 FD F9 FF FF E9 EA F9 FF FF 48 89 D3 4C 89 D8 B9 04 00 00 00 48 C7 C6 FB FF FF FF E9 B9 F8 FF FF 48 89 D3 4C 89 D8 B9 05 00 00 00 41 BA 05 00 00 00 E9 C8 FA FF FF 4C 3B 30 0F 87 0C FE FF FF 48 89 E8 83 E0 01 48 83 F8 01 48 83 D5 FF E9 F9 FD FF FF 4C 3B 30 0F 82 C5 FD FF FF E9 18 FF FF FF 4D 85 FF 0F 95 C0 48 85 F6 41 0F 95 C3 4D 85 F6 0F 95 C1 41 08 CB 0F 84 36 FF FF FF 84 C0 0F 85 2E FF FF FF 48 8B 44 24 18 48 03 05 ?? ?? ?? ?? 48 3B 70 08 0F 87 18 FF FF FF 0F 85 1C FF FF FF 4C 3B 30 0F 86 13 FF FF FF E9 04 FF FF FF 48 8B 05 ?? ?? ?? ?? 4A 8B 04 C0 49 39 C3 0F 87 9E FE FF FF 0F 85 B0 FE FF FF 48 89 F0 4C 09 F0 0F 84 A4 FE FF FF 4C 89 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 3B 70 08 0F 87 8C FE FF FF 0F 85 2E FD FF FF 4C 3B 30 0F 86 25 FD FF FF E9 78 FE FF FF 90 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "__bid128_to_int64_floor"
		size = 1664
		refs = "00ac .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 03dc .refptr.__bid_ten2mk128 055a .refptr.__bid_maskhigh128 0568 .refptr.__bid_shiftright128 059a .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 11 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 84 96 02 00 00 41 83 FB 13 0F 8F 82 05 00 00 BB 14 00 00 00 44 89 D0 4C 89 D6 44 29 DB 48 C1 EE 20 4C 63 DB 48 8B 1D ?? ?? ?? ?? 4A 8B 1C DB 49 89 C3 49 89 DC 89 DB 48 89 DD 49 C1 EC 20 48 0F AF D8 48 0F AF EE 4D 0F AF DC 48 89 DF 89 DB 89 E8 48 C1 EF 20 49 0F AF F4 48 01 C7 4A 8D 04 1F 49 89 EB 49 C1 EB 20 4C 01 DE 49 89 C3 48 C1 E0 20 49 C1 EB 20 48 01 D8 BB 05 00 00 00 49 01 F3 4C 39 DB 72 16 0F 85 DF 00 00 00 48 85 C0 0F 84 D6 00 00 00 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 37 01 00 00 48 85 D2 0F 84 B1 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 75 1A 44 8B 58 18 48 8B 40 08 48 39 C2 0F 87 04 01 00 00 48 39 C2 0F 84 E2 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 03 83 F8 13 0F 8F 4F FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 13 0F 84 9A FE FF FF 85 C0 0F 8E D1 00 00 00 45 85 C0 0F 88 BC 01 00 00 0F 85 D2 00 00 00 4C 89 D2 4C 89 D0 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 5D FE FF FF 31 C0 4D 85 D2 0F 84 52 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 C2 00 00 00 66 0F EF D2 4D 89 D0 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 0F 85 3C FF FF FF 44 8B 58 18 48 8B 40 08 E9 26 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 31 C0 E9 D9 FD FF FF 49 C1 E0 05 4F 39 54 01 10 0F 87 0F FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 C3 01 E9 FC FE FF FF 0F 1F 80 00 00 00 00 31 C0 4D 85 C9 0F 95 C0 48 F7 D8 E9 A0 FD FF FF 4D 85 C9 4D 63 C0 0F 84 C4 00 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D0 48 F7 D8 4A 0F AF 04 C2 E9 7D FD FF FF 66 0F EF C9 F2 49 0F 2A CA 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 40 FF FF FF 0F 1F 84 00 00 00 00 00 41 83 FB 13 0F 8F C9 02 00 00 B8 14 00 00 00 4C 89 D5 44 89 D6 44 29 D8 4C 8B 1D ?? ?? ?? ?? 48 C1 ED 20 48 98 49 8B 1C C3 49 89 F3 48 89 DF 89 DB 48 89 D8 48 C1 EF 20 48 0F AF C5 48 0F AF DE 4C 0F AF DF 41 89 C4 48 C1 E8 20 48 C1 EB 20 48 89 C6 48 0F AF EF 4C 01 E3 4A 8D 04 1B 41 BB 05 00 00 00 48 C1 E8 20 48 01 EE 48 8D 04 06 49 39 C3 0F 87 58 FE FF FF E9 84 FD FF FF 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 4E 0F AF 14 C0 4C 89 D0 E9 BC FC FF FF 44 89 C0 41 F7 D0 4D 89 D4 4D 63 C0 F7 D8 49 C1 EC 20 4C 89 C7 89 44 24 04 44 89 D0 48 C1 E7 04 89 C9 48 89 FD 48 03 2D ?? ?? ?? ?? 48 89 7C 24 18 4C 8B 5D 08 4C 89 DB 45 89 DB 4C 89 DF 4D 89 DA 48 C1 EB 20 48 0F AF F8 48 89 DE 4D 0F AF D4 49 0F AF F4 49 89 FD 89 FF 45 89 D6 49 C1 ED 20 49 C1 EA 20 4D 01 F5 49 89 DE 49 01 F2 4C 0F AF F0 4F 8D 7C 35 00 4C 89 FE 4C 89 7C 24 08 48 C1 EE 20 4D 8D 3C 32 4C 8B 55 00 4C 89 D6 45 89 D2 48 C1 EE 20 4C 89 D5 4D 89 D5 49 0F AF EC 4C 0F AF E8 4C 0F AF E6 41 89 EE 48 C1 ED 20 48 0F AF C6 4C 89 64 24 10 4D 89 EC 49 C1 EC 20 45 89 ED 4D 01 E6 4C 8B 64 24 10 49 01 C6 48 8B 44 24 08 49 01 EC 4C 89 F5 49 C1 E6 20 48 C1 ED 20 4D 01 F5 48 C1 E0 20 49 01 EC 48 01 C7 4C 01 E7 49 83 D7 00 48 C1 EA 20 48 89 D5 49 89 D4 49 0F AF EB 4C 0F AF D9 4C 0F AF E3 41 89 EE 48 C1 ED 20 4C 89 D8 45 89 DB 48 0F AF D9 48 C1 E8 20 4C 01 E5 48 01 D8 4C 01 F0 48 89 C3 48 C1 E0 20 48 C1 EB 20 4C 01 D8 48 01 EB 48 89 D5 49 0F AF EA 4C 0F AF D1 48 0F AF CE 41 89 EC 48 C1 ED 20 4D 89 D6 45 89 D2 48 0F AF D6 49 C1 EE 20 4C 01 F1 49 01 CC 4C 89 E1 49 C1 E4 20 48 C1 E9 20 48 01 EA 4D 01 E2 48 01 CA 48 01 C2 48 83 D3 00 31 C9 4C 01 D7 0F 92 C1 48 8D 04 11 49 01 C7 0F 92 C2 48 39 C1 0F 97 C0 09 D0 0F B6 C0 48 01 C3 83 7C 24 04 16 7F 69 48 8B 05 ?? ?? ?? ?? 4C 89 FE 4E 8B 1C C0 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 89 D8 48 D3 E0 89 D1 48 D3 EE 48 09 F0 83 7C 24 04 03 0F 8F D6 00 00 00 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 77 40 0F 84 B0 00 00 00 4D 85 C9 0F 84 BD FA FF FF 48 F7 D8 E9 B5 FA FF FF 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 42 8B 0C 80 48 89 D8 4A 23 1C C2 83 E9 40 48 D3 E8 4C 09 FB 74 AE 4D 85 C9 0F 84 83 FA FF FF 48 83 C0 01 EB C0 41 83 FB 14 74 43 41 8D 43 EC 4C 8B 1D ?? ?? ?? ?? 48 98 49 8B 04 C3 4C 8D 1C 80 48 89 D0 E9 78 FD FF FF 41 83 FB 14 74 2E 41 8D 43 EC 4C 8B 1D ?? ?? ?? ?? 48 98 49 8B 04 C3 49 89 D3 48 8D 1C 80 4C 89 D0 E9 C9 FA FF FF 48 89 D0 41 BB 05 00 00 00 E9 44 FD FF FF 49 89 D3 4C 89 D0 BB 05 00 00 00 E9 AB FA FF FF 4C 3B 2A 0F 86 47 FF FF FF E9 7C FF FF FF 4D 85 DF 0F 85 73 FF FF FF E9 1C FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "__bid128_to_int64_xfloor"
		size = 1680
		refs = "00a5 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 03ec .refptr.__bid_ten2mk128 0573 .refptr.__bid_maskhigh128 0581 .refptr.__bid_shiftright128 05b5 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 11 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 84 A6 02 00 00 41 83 FB 13 0F 8F A5 05 00 00 BB 14 00 00 00 44 89 D0 4C 89 D6 44 29 DB 4C 8B 1D ?? ?? ?? ?? 48 C1 EE 20 48 63 DB 49 8B 1C DB 49 89 C3 49 89 DC 89 DB 48 89 DD 49 C1 EC 20 48 0F AF D8 48 0F AF EE 4D 0F AF DC 48 89 DF 89 DB 89 E8 48 C1 EF 20 49 0F AF F4 48 01 C7 4A 8D 04 1F 49 89 EB 49 C1 EB 20 4C 01 DE 49 89 C3 48 C1 E0 20 49 C1 EB 20 48 01 D8 BB 05 00 00 00 49 01 F3 4C 39 DB 72 16 0F 85 DF 00 00 00 48 85 C0 0F 84 D6 00 00 00 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 37 01 00 00 48 85 D2 0F 84 B1 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 75 1A 44 8B 58 18 48 8B 40 08 48 39 C2 0F 87 04 01 00 00 48 39 C2 0F 84 E2 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 03 83 F8 13 0F 8F 4F FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 13 0F 84 9A FE FF FF 85 C0 0F 8E D1 00 00 00 45 85 C0 0F 88 CC 01 00 00 0F 85 E2 00 00 00 4C 89 D0 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 5D FE FF FF 31 C0 4D 85 D2 0F 84 52 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 D2 00 00 00 66 0F EF D2 4D 89 D0 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 0F 85 3C FF FF FF 44 8B 58 18 48 8B 40 08 E9 26 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 31 C0 E9 D9 FD FF FF 49 C1 E0 05 4F 39 54 01 10 0F 87 0F FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 C3 01 E9 FC FE FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 C9 0F 95 C0 48 F7 D8 E9 96 FD FF FF 66 0F 1F 44 00 00 4D 85 C9 4D 63 C0 0F 84 C4 00 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D0 48 F7 D8 4A 0F AF 04 C2 E9 6D FD FF FF 66 0F EF C9 F2 49 0F 2A CA 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 30 FF FF FF 0F 1F 84 00 00 00 00 00 41 83 FB 13 0F 8F DC 02 00 00 48 8B 05 ?? ?? ?? ?? BB 14 00 00 00 4D 89 D4 44 29 DB 49 C1 EC 20 44 89 D7 48 63 DB 49 89 FB 48 8B 1C D8 48 89 DD 89 DB 48 89 DE 48 C1 ED 20 49 0F AF F4 48 0F AF DF 4C 0F AF DD 89 F0 48 C1 EE 20 48 C1 EB 20 4C 0F AF E5 48 01 C3 4A 8D 04 1B 41 BB 05 00 00 00 48 C1 E8 20 4C 01 E6 48 01 F0 49 39 C3 0F 87 4C FE FF FF E9 78 FD FF FF 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 4E 0F AF 14 C0 4C 89 D0 E9 AC FC FF FF 44 89 C0 41 F7 D0 4D 89 D4 4D 63 C0 F7 D8 49 C1 EC 20 4C 89 C7 89 44 24 04 44 89 D0 48 C1 E7 04 89 C9 48 89 FD 48 03 2D ?? ?? ?? ?? 48 89 7C 24 18 4C 8B 5D 08 4C 89 DB 45 89 DB 4C 89 DF 4D 89 DA 48 C1 EB 20 48 0F AF F8 48 89 DE 4D 0F AF D4 49 0F AF F4 49 89 FD 89 FF 45 89 D6 49 C1 ED 20 49 C1 EA 20 4D 01 F5 49 89 DE 49 01 F2 4C 0F AF F0 4F 8D 7C 35 00 4C 89 FE 4C 89 7C 24 08 48 C1 EE 20 4D 8D 3C 32 4C 8B 55 00 4C 89 D6 45 89 D2 48 C1 EE 20 4C 89 D5 4D 89 D5 49 0F AF EC 4C 0F AF E8 4C 0F AF E6 41 89 EE 48 C1 ED 20 48 0F AF C6 4C 89 64 24 10 4D 89 EC 49 C1 EC 20 45 89 ED 4D 01 E6 4C 8B 64 24 10 49 01 C6 48 8B 44 24 08 49 01 EC 4C 89 F5 49 C1 E6 20 48 C1 ED 20 4D 01 F5 48 C1 E0 20 49 01 EC 48 01 C7 4C 01 E7 49 83 D7 00 48 C1 EA 20 48 89 D5 49 89 D4 49 0F AF EB 4C 0F AF D9 4C 0F AF E3 41 89 EE 48 C1 ED 20 4C 89 D8 45 89 DB 48 0F AF D9 48 C1 E8 20 4C 01 E5 48 01 D8 4C 01 F0 48 89 C3 48 C1 E0 20 48 C1 EB 20 4C 01 D8 48 01 EB 48 89 D5 49 0F AF EA 4C 0F AF D1 48 0F AF CE 41 89 EC 48 C1 ED 20 4D 89 D6 45 89 D2 48 0F AF D6 49 C1 EE 20 4C 01 F1 49 01 CC 4C 89 E1 49 C1 E4 20 48 C1 E9 20 48 01 EA 4D 01 E2 48 01 CA 48 01 C2 48 83 D3 00 31 C9 4C 01 D7 0F 92 C1 48 8D 04 11 4C 89 FA 48 01 C2 41 0F 92 C2 48 39 C1 0F 97 C0 44 09 D0 0F B6 C0 48 01 C3 83 7C 24 04 16 0F 8F 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 D6 4E 8B 14 C0 48 8B 05 ?? ?? ?? ?? 46 8B 04 80 B8 40 00 00 00 44 29 C0 89 C1 48 89 D8 48 D3 E0 44 89 C1 48 D3 EE 48 09 F0 83 7C 24 04 03 0F 8F D0 00 00 00 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 77 11 0F 85 3C FC FF FF 4C 3B 2A 0F 86 33 FC FF FF 66 90 48 8B 15 ?? ?? ?? ?? 49 83 F9 01 48 83 D8 FF 83 0A 20 E9 1A FC FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 42 8B 0C 80 48 89 D8 83 E9 40 48 D3 E8 48 8B 0D ?? ?? ?? ?? 4A 23 1C C1 48 09 D3 75 BC EB 97 41 83 FB 14 74 43 41 8D 43 EC 4C 8B 1D ?? ?? ?? ?? 48 98 49 8B 04 C3 4C 8D 1C 80 48 89 D0 E9 61 FD FF FF 41 83 FB 14 74 2E 41 8D 43 EC 4C 8B 1D ?? ?? ?? ?? 48 98 49 8B 04 C3 49 89 D3 48 8D 1C 80 4C 89 D0 E9 A6 FA FF FF 48 89 D0 41 BB 05 00 00 00 E9 2D FD FF FF 49 89 D3 4C 89 D0 BB 05 00 00 00 E9 88 FA FF FF 4C 85 D2 0F 85 4A FF FF FF E9 22 FF FF FF 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_15_4_0 {
	meta:
		name = "__bid128_to_int64_ceil"
		size = 1888
		refs = "00ac .refptr.__bid_ten2k64 0124 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 0408 .refptr.__bid_ten2mk128 0586 .refptr.__bid_maskhigh128 0594 .refptr.__bid_shiftright128 05c6 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 11 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F1 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 84 96 02 00 00 41 83 FB 13 0F 8F 11 06 00 00 BB 14 00 00 00 44 89 D0 4C 89 D7 44 29 DB 48 C1 EF 20 4C 63 DB 48 8B 1D ?? ?? ?? ?? 4A 8B 1C DB 49 89 C3 49 89 DC 89 DB 48 89 DE 49 C1 EC 20 48 0F AF D8 48 0F AF F7 4D 0F AF DC 48 89 DD 89 DB 89 F0 48 C1 ED 20 48 C1 EE 20 49 0F AF FC 48 01 C5 4A 8D 44 1D 00 49 89 C3 48 C1 E0 20 48 8D 34 3E 49 C1 EB 20 48 01 D8 BB 0A 00 00 00 4C 01 DE 41 BB 05 00 00 00 49 39 F3 72 12 48 39 C3 0F 87 D7 00 00 00 49 39 F3 0F 85 CE 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 36 FF FF FF 66 0F 1F 44 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 37 01 00 00 48 85 D2 0F 84 B1 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 75 1A 44 8B 58 18 48 8B 40 08 48 39 C2 0F 87 04 01 00 00 48 39 C2 0F 84 E2 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 03 83 F8 13 0F 8F 50 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 13 0F 84 9A FE FF FF 85 C0 0F 8E D1 00 00 00 45 85 C0 0F 88 E8 01 00 00 0F 85 D2 00 00 00 4C 89 D2 4C 89 D0 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 5D FE FF FF 31 C0 4D 85 D2 0F 84 52 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 C2 00 00 00 66 0F EF D2 4D 89 D0 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 0F 85 3C FF FF FF 44 8B 58 18 48 8B 40 08 E9 26 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 31 C0 E9 D9 FD FF FF 49 C1 E0 05 4F 39 54 01 10 0F 87 0F FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 C3 01 E9 FC FE FF FF 0F 1F 80 00 00 00 00 31 C0 4D 85 C9 0F 94 C0 E9 A3 FD FF FF 0F 1F 00 4D 85 C9 4D 63 C0 0F 84 E6 00 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D0 48 F7 D8 4A 0F AF 04 C2 E9 7D FD FF FF 66 0F EF C9 F2 49 0F 2A CA 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 40 FF FF FF 0F 1F 84 00 00 00 00 00 41 83 FB 13 0F 8F F8 02 00 00 BB 14 00 00 00 44 89 D0 4C 89 D6 44 29 DB 48 C1 EE 20 4C 63 DB 48 8B 1D ?? ?? ?? ?? 4A 8B 1C DB 49 89 C3 49 89 DC 89 DB 48 89 DF 49 C1 EC 20 48 0F AF D8 48 0F AF FE 4D 0F AF DC 48 89 DD 89 DB 89 F8 48 C1 ED 20 48 C1 EF 20 49 0F AF F4 48 01 C5 4A 8D 44 1D 00 49 89 C3 48 C1 E0 20 48 8D 3C 37 49 C1 EB 20 48 01 D8 48 C7 C6 F6 FF FF FF 4C 01 DF 41 BB 04 00 00 00 49 39 FB 0F 82 76 FD FF FF 48 39 C6 0F 83 3B FE FF FF 49 39 FB 0F 85 32 FE FF FF E9 5F FD FF FF 48 8B 05 ?? ?? ?? ?? 4E 0F AF 14 C0 4C 89 D0 E9 9A FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 44 89 C0 41 F7 D0 4D 89 D4 4D 63 C0 F7 D8 49 C1 EC 20 4C 89 C7 89 44 24 04 44 89 D0 48 C1 E7 04 89 C9 48 89 FD 48 03 2D ?? ?? ?? ?? 48 89 7C 24 18 4C 8B 5D 08 4C 89 DB 45 89 DB 4C 89 DF 4D 89 DA 48 C1 EB 20 48 0F AF F8 48 89 DE 4D 0F AF D4 49 0F AF F4 49 89 FD 89 FF 45 89 D6 49 C1 ED 20 49 C1 EA 20 4D 01 F5 49 89 DE 49 01 F2 4C 0F AF F0 4F 8D 7C 35 00 4C 89 FE 4C 89 7C 24 08 48 C1 EE 20 4D 8D 3C 32 4C 8B 55 00 4C 89 D6 45 89 D2 48 C1 EE 20 4C 89 D5 4D 89 D5 49 0F AF EC 4C 0F AF E8 4C 0F AF E6 41 89 EE 48 C1 ED 20 48 0F AF C6 4C 89 64 24 10 4D 89 EC 49 C1 EC 20 45 89 ED 4D 01 E6 4C 8B 64 24 10 49 01 C6 48 8B 44 24 08 49 01 EC 4C 89 F5 49 C1 E6 20 48 C1 ED 20 4D 01 F5 48 C1 E0 20 49 01 EC 48 01 C7 4C 01 E7 49 83 D7 00 48 C1 EA 20 48 89 D5 49 89 D4 49 0F AF EB 4C 0F AF D9 4C 0F AF E3 41 89 EE 48 C1 ED 20 4C 89 D8 45 89 DB 48 0F AF D9 48 C1 E8 20 4C 01 E5 48 01 D8 4C 01 F0 48 89 C3 48 C1 E0 20 48 C1 EB 20 4C 01 D8 48 01 EB 48 89 D5 49 0F AF EA 4C 0F AF D1 48 0F AF CE 41 89 EC 48 C1 ED 20 4D 89 D6 45 89 D2 48 0F AF D6 49 C1 EE 20 4C 01 F1 49 01 CC 4C 89 E1 49 C1 E4 20 48 C1 E9 20 48 01 EA 4D 01 E2 48 01 CA 48 01 C2 48 83 D3 00 31 C9 4C 01 D7 0F 92 C1 48 8D 04 11 49 01 C7 0F 92 C2 48 39 C1 0F 97 C0 09 D0 0F B6 C0 48 01 C3 83 7C 24 04 16 7F 6D 48 8B 05 ?? ?? ?? ?? 4C 89 FE 4E 8B 1C C0 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 89 D8 48 D3 E0 89 D1 48 D3 EE 48 09 F0 83 7C 24 04 03 0F 8F 87 01 00 00 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 77 44 0F 84 61 01 00 00 4D 85 C9 0F 84 91 FA FF FF 48 F7 D8 E9 89 FA FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 42 8B 0C 80 48 89 D8 4A 23 1C C2 83 E9 40 48 D3 E8 4C 09 FB 74 AA 4D 85 C9 75 C6 48 83 C0 01 E9 4E FA FF FF 41 83 FB 14 0F 84 DD 00 00 00 41 8D 43 EC 4C 8B 1D ?? ?? ?? ?? 48 98 49 8B 2C C3 B8 F6 FF FF FF 49 89 EC 89 EE 49 C1 EC 20 4C 89 E7 48 0F AF F8 48 0F AF C6 89 FB 49 89 C3 49 C1 EB 20 4C 01 DB 49 89 F3 49 C1 E3 20 49 29 F3 49 01 DB 89 C3 4C 89 E0 4C 89 DE 48 C1 E0 20 49 C1 EB 20 4C 29 E0 48 C1 E6 20 48 01 DE 48 8D 1C A8 48 89 F8 48 C1 E8 20 48 89 D7 48 01 D8 49 01 C3 4C 89 D0 E9 FD FC FF FF 41 83 FB 14 74 76 41 8D 43 EC 4C 8B 1D ?? ?? ?? ?? 48 98 49 8B 2C C3 48 89 E8 48 C1 E8 20 48 8D 34 80 89 E8 48 8D 3C 80 48 01 F6 48 01 FF 89 F0 48 C1 EE 20 49 89 FB 89 FF 49 C1 EB 20 49 01 C3 48 8D 44 AD 00 4C 89 DB 49 C1 EB 20 48 01 C6 48 C1 E3 20 4C 89 D0 49 01 F3 48 01 FB 48 89 D6 E9 01 FA FF FF 48 89 D7 4C 89 D0 41 BB 04 00 00 00 48 C7 C6 F6 FF FF FF E9 81 FC FF FF 48 89 D6 4C 89 D0 41 BB 05 00 00 00 BB 0A 00 00 00 E9 D3 F9 FF FF 4C 3B 2A 0F 86 96 FE FF FF E9 CF FE FF FF 4D 85 DF 0F 85 C6 FE FF FF E9 6B FE FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_15_5_0 {
	meta:
		name = "__bid128_to_int64_xceil"
		size = 1888
		refs = "00a5 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 040d .refptr.__bid_ten2mk128 0594 .refptr.__bid_maskhigh128 05a2 .refptr.__bid_shiftright128 05d6 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 11 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 84 A6 02 00 00 41 83 FB 13 0F 8F 25 06 00 00 BB 14 00 00 00 44 89 D0 4C 89 D5 44 29 DB 4C 8B 1D ?? ?? ?? ?? 48 C1 ED 20 48 63 DB 49 8B 1C DB 49 89 C3 49 89 DC 89 DB 48 89 DE 49 C1 EC 20 48 0F AF D8 48 0F AF F5 4D 0F AF DC 48 89 DF 89 DB 89 F0 48 C1 EF 20 48 C1 EE 20 49 0F AF EC 48 01 C7 4A 8D 04 1F BF 0A 00 00 00 49 89 C3 48 C1 E0 20 48 8D 34 2E 49 C1 EB 20 48 01 D8 4C 01 DE 41 BB 05 00 00 00 49 39 F3 72 12 48 39 C7 0F 87 D8 00 00 00 49 39 F3 0F 85 CF 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 37 01 00 00 48 85 D2 0F 84 B1 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 75 1A 44 8B 58 18 48 8B 40 08 48 39 C2 0F 87 04 01 00 00 48 39 C2 0F 84 E2 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 03 83 F8 13 0F 8F 4F FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 13 0F 84 9A FE FF FF 85 C0 0F 8E D1 00 00 00 45 85 C0 0F 88 ED 01 00 00 0F 85 E2 00 00 00 4C 89 D0 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 5D FE FF FF 31 C0 4D 85 D2 0F 84 52 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 D2 00 00 00 66 0F EF D2 4D 89 D0 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 0F 85 3C FF FF FF 44 8B 58 18 48 8B 40 08 E9 26 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 31 C0 E9 D9 FD FF FF 49 C1 E0 05 4F 39 54 01 10 0F 87 0F FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 C3 01 E9 FC FE FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 C9 0F 94 C0 E9 99 FD FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 C9 4D 63 C0 0F 84 E5 00 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D0 48 F7 D8 4A 0F AF 04 C2 E9 6D FD FF FF 66 0F EF C9 F2 49 0F 2A CA 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 30 FF FF FF 0F 1F 84 00 00 00 00 00 41 83 FB 13 0F 8F FC 02 00 00 BB 14 00 00 00 44 89 D0 4C 89 D5 44 29 DB 4C 8B 1D ?? ?? ?? ?? 48 C1 ED 20 48 63 DB 49 8B 1C DB 49 89 C3 49 89 DC 89 DB 48 89 DF 49 C1 EC 20 48 0F AF D8 48 0F AF FD 4D 0F AF DC 48 89 DE 89 DB 89 F8 48 C1 EE 20 48 C1 EF 20 49 0F AF EC 48 01 C6 4A 8D 04 1E 48 C7 C6 F6 FF FF FF 49 89 C3 48 C1 E0 20 48 8D 3C 2F 49 C1 EB 20 48 01 D8 4C 01 DF 41 BB 04 00 00 00 49 39 FB 0F 82 66 FD FF FF 48 39 C6 0F 83 2C FE FF FF 49 39 FB 0F 85 23 FE FF FF E9 4F FD FF FF 48 8B 05 ?? ?? ?? ?? 4E 0F AF 14 C0 4C 89 D0 E9 8B FC FF FF 44 89 C0 41 F7 D0 4D 89 D4 4D 63 C0 F7 D8 49 C1 EC 20 4C 89 C7 89 44 24 04 44 89 D0 48 C1 E7 04 89 C9 48 89 FD 48 03 2D ?? ?? ?? ?? 48 89 7C 24 18 4C 8B 5D 08 4C 89 DB 45 89 DB 4C 89 DF 4D 89 DA 48 C1 EB 20 48 0F AF F8 48 89 DE 4D 0F AF D4 49 0F AF F4 49 89 FD 89 FF 45 89 D6 49 C1 ED 20 49 C1 EA 20 4D 01 F5 49 89 DE 49 01 F2 4C 0F AF F0 4F 8D 7C 35 00 4C 89 FE 4C 89 7C 24 08 48 C1 EE 20 4D 8D 3C 32 4C 8B 55 00 4C 89 D6 45 89 D2 48 C1 EE 20 4C 89 D5 4D 89 D5 49 0F AF EC 4C 0F AF E8 4C 0F AF E6 41 89 EE 48 C1 ED 20 48 0F AF C6 4C 89 64 24 10 4D 89 EC 49 C1 EC 20 45 89 ED 4D 01 E6 4C 8B 64 24 10 49 01 C6 48 8B 44 24 08 49 01 EC 4C 89 F5 49 C1 E6 20 48 C1 ED 20 4D 01 F5 48 C1 E0 20 49 01 EC 48 01 C7 4C 01 E7 49 83 D7 00 48 C1 EA 20 48 89 D5 49 89 D4 49 0F AF EB 4C 0F AF D9 4C 0F AF E3 41 89 EE 48 C1 ED 20 4C 89 D8 45 89 DB 48 0F AF D9 48 C1 E8 20 4C 01 E5 48 01 D8 4C 01 F0 48 89 C3 48 C1 E0 20 48 C1 EB 20 4C 01 D8 48 01 EB 48 89 D5 49 0F AF EA 4C 0F AF D1 48 0F AF CE 41 89 EC 48 C1 ED 20 4D 89 D6 45 89 D2 48 0F AF D6 49 C1 EE 20 4C 01 F1 49 01 CC 4C 89 E1 49 C1 E4 20 48 C1 E9 20 48 01 EA 4D 01 E2 48 01 CA 48 01 C2 48 83 D3 00 31 C9 4C 01 D7 0F 92 C1 48 8D 04 11 4C 89 FA 48 01 C2 41 0F 92 C2 48 39 C1 0F 97 C0 44 09 D0 0F B6 C0 48 01 C3 83 7C 24 04 16 0F 8F 7F 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 D6 4E 8B 14 C0 48 8B 05 ?? ?? ?? ?? 46 8B 04 80 B8 40 00 00 00 44 29 C0 89 C1 48 89 D8 48 D3 E0 44 89 C1 48 D3 EE 48 09 F0 83 7C 24 04 03 0F 8F 7D 01 00 00 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 77 10 0F 85 1B FC FF FF 4C 3B 2A 0F 86 12 FC FF FF 90 48 8B 15 ?? ?? ?? ?? 49 83 F9 01 48 83 D0 00 83 0A 20 E9 FA FB FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 42 8B 0C 80 48 89 D8 83 E9 40 48 D3 E8 48 8B 0D ?? ?? ?? ?? 4A 23 1C C1 48 09 D3 75 BC EB 98 41 83 FB 14 0F 84 DD 00 00 00 41 8D 43 EC 4C 8B 1D ?? ?? ?? ?? 48 98 49 8B 2C C3 B8 F6 FF FF FF 49 89 EC 89 EE 49 C1 EC 20 4C 89 E7 48 0F AF F8 48 0F AF C6 89 FB 49 89 C3 49 C1 EB 20 4C 01 DB 49 89 F3 49 C1 E3 20 49 29 F3 49 01 DB 89 C3 4C 89 E0 4C 89 DE 48 C1 E0 20 49 C1 EB 20 4C 29 E0 48 C1 E6 20 48 01 DE 48 8D 1C A8 48 89 F8 48 C1 E8 20 48 89 D7 48 01 D8 49 01 C3 4C 89 D0 E9 F8 FC FF FF 41 83 FB 14 74 76 41 8D 43 EC 4C 8B 1D ?? ?? ?? ?? 48 98 49 8B 2C C3 48 89 E8 48 C1 E8 20 48 8D 1C 80 89 E8 48 8D 34 80 48 01 DB 48 01 F6 89 D8 48 C1 EB 20 49 89 F3 89 F6 49 C1 EB 20 49 01 C3 48 8D 44 AD 00 4C 89 DF 49 C1 EB 20 48 01 C3 48 C1 E7 20 4C 89 D0 48 01 F7 49 01 DB 48 89 D6 E9 EC F9 FF FF 48 89 D7 4C 89 D0 41 BB 04 00 00 00 48 C7 C6 F6 FF FF FF E9 7C FC FF FF 48 89 D6 4C 89 D0 41 BB 05 00 00 00 BF 0A 00 00 00 E9 BE F9 FF FF 4C 85 D2 0F 85 9C FE FF FF E9 75 FE FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_15_6_0 {
	meta:
		name = "__bid128_to_int64_int"
		size = 1552
		refs = "00a9 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 0333 .refptr.__bid_ten2mk128 049b .refptr.__bid_shiftright128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 11 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 84 4A 04 00 00 83 F8 13 0F 8F D3 04 00 00 41 B3 14 44 89 D3 4C 89 D5 41 29 C3 48 C1 ED 20 49 63 C3 4C 8B 1D ?? ?? ?? ?? 49 8B 04 C3 49 89 C3 89 C0 48 89 C6 49 C1 EB 20 48 0F AF C3 48 0F AF F5 49 0F AF DB 48 89 C7 89 C0 41 89 F4 48 C1 EF 20 48 C1 EE 20 49 0F AF EB 4C 01 E7 4C 8D 1C 1F 4C 89 DB 49 C1 E3 20 48 8D 34 2E 48 C1 EB 20 49 01 C3 B8 0A 00 00 00 48 01 DE BB 05 00 00 00 48 39 F3 72 18 4C 39 D8 0F 87 E2 00 00 00 48 39 F3 0F 85 D9 00 00 00 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 39 01 00 00 48 85 D2 0F 84 BE 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4D 89 C1 49 C1 E1 05 4D 01 D9 41 8B 01 85 C0 75 1A 41 8B 41 18 4D 8B 49 08 4C 39 CA 0F 87 05 01 00 00 4C 39 CA 0F 84 E5 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 46 8D 1C 00 41 83 FB 13 0F 8F 4F FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FB 13 0F 84 99 FE FF FF 31 C0 45 85 DB 0F 8E 7D FE FF FF 45 85 C0 0F 88 14 01 00 00 0F 85 BE 00 00 00 4C 89 D0 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 59 FE FF FF 66 0F 1F 84 00 00 00 00 00 31 C0 4D 85 D2 0F 84 45 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 A5 00 00 00 66 0F EF D2 4D 89 D0 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 1D ?? ?? ?? ?? 4D 89 C1 49 C1 E1 05 4D 01 D9 41 8B 01 85 C0 0F 85 2F FF FF FF 41 8B 41 18 4D 8B 49 08 E9 19 FF FF FF 31 C0 E9 D7 FD FF FF 49 C1 E0 05 4F 39 54 03 10 0F 87 0C FF FF FF 0F 1F 84 00 00 00 00 00 83 C0 01 E9 FC FE FF FF 0F 1F 84 00 00 00 00 00 4D 85 C9 4D 63 C0 0F 84 F4 01 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D0 48 F7 D8 4A 0F AF 04 C2 E9 8D FD FF FF 66 0F EF C9 F2 49 0F 2A CA 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 5D FF FF FF 0F 1F 84 00 00 00 00 00 44 89 C0 41 F7 D0 4D 89 D6 4D 63 C0 F7 D8 49 C1 EE 20 4D 89 C3 89 44 24 04 44 89 D0 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 4D 8B 53 08 4D 8B 1B 4C 89 D7 45 89 D2 4C 89 D5 4C 89 D6 48 C1 EF 20 48 0F AF E8 48 89 FB 49 0F AF F6 49 0F AF DE 49 89 EC 89 ED 41 89 F5 49 C1 EC 20 48 C1 EE 20 4D 01 EC 49 89 FD 48 01 DE 4C 0F AF E8 4D 01 EC 4C 89 E3 49 C1 E4 20 48 C1 EB 20 49 01 EC 48 01 DE 4C 89 DB 45 89 DB 48 C1 EB 20 4D 89 DD 4D 0F AF EE 4C 0F AF F3 45 89 EF 49 C1 ED 20 4C 89 74 24 08 4D 89 DE 4C 03 6C 24 08 4C 0F AF F0 48 0F AF C3 49 C1 EE 20 4D 01 FE 49 01 C6 49 C1 EE 20 4D 01 F5 4D 01 E5 41 89 CC 48 83 D6 00 48 C1 EA 20 48 89 D0 48 89 D1 49 0F AF C2 4D 0F AF D4 48 0F AF CF 41 89 C6 48 C1 E8 20 4C 89 D5 45 89 D2 49 0F AF FC 48 C1 ED 20 48 01 C8 48 01 EF 4A 8D 2C 37 48 89 EF 48 C1 E5 20 48 C1 EF 20 48 01 C7 48 89 D0 49 0F AF C3 4D 0F AF DC 48 0F AF D3 41 89 C6 48 C1 E8 20 4D 89 DF 45 89 DB 49 0F AF DC 49 C1 EF 20 48 01 C2 4C 01 FB 4A 8D 0C 33 48 89 C8 48 C1 E1 20 48 C1 E8 20 49 01 CB 48 01 D0 4A 8D 54 15 00 48 01 C2 48 83 D7 00 45 31 D2 4D 01 DD 41 0F 92 C2 48 89 D1 4C 01 D1 48 01 CE 0F 92 C0 49 39 CA 0F 97 C2 09 C2 83 7C 24 04 16 0F B6 D2 48 8D 04 17 0F 8F B8 00 00 00 48 8B 15 ?? ?? ?? ?? 46 8B 04 82 BA 40 00 00 00 44 29 C2 89 D1 48 D3 E0 44 89 C1 48 D3 EE 48 09 F0 E9 47 FD FF FF 66 90 48 8B 05 ?? ?? ?? ?? 4E 0F AF 14 C0 4C 89 D0 E9 9C FB FF FF 83 F8 13 0F 8F EB 00 00 00 BB 14 00 00 00 4C 89 D5 45 89 D3 29 C3 48 C1 ED 20 48 63 C3 48 8B 1D ?? ?? ?? ?? 48 8B 1C C3 48 89 DF 89 DB 48 89 DE 48 C1 EF 20 48 0F AF F5 49 0F AF DB 4C 0F AF DF 89 F0 48 C1 EE 20 48 C1 EB 20 48 0F AF EF 48 01 C3 4A 8D 04 1B 41 BB 05 00 00 00 48 C1 E8 20 48 01 EE 48 8D 04 06 49 39 C3 0F 87 B0 FC FF FF E9 D8 FB FF FF 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 83 E9 40 48 D3 E8 E9 9F FC FF FF 83 F8 14 74 7E 4C 8B 1D ?? ?? ?? ?? 83 E8 14 48 98 49 8B 3C C3 48 89 F8 48 C1 E8 20 4C 8D 1C 80 89 F8 48 8D 34 80 4D 01 DB 48 01 F6 44 89 D8 49 C1 EB 20 48 89 F3 89 F6 48 C1 EB 20 48 01 C3 48 89 D8 48 C1 EB 20 48 C1 E0 20 48 01 F0 48 8D 34 BF 49 01 F3 48 89 D6 4C 01 DB 4D 89 D3 E9 3B FB FF FF 83 F8 14 74 31 4C 8B 1D ?? ?? ?? ?? 83 E8 14 48 98 49 8B 04 C3 4C 8D 1C 80 48 89 D0 E9 51 FF FF FF 48 89 D6 4D 89 D3 BB 05 00 00 00 B8 0A 00 00 00 E9 05 FB FF FF 48 89 D0 41 BB 05 00 00 00 E9 2E FF FF FF 0F 1F 40 00 }
	condition:
		$1
}

rule file_15_7_0 {
	meta:
		name = "__bid128_to_int64_xint"
		size = 1712
		refs = "00a3 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 0338 .refptr.__bid_ten2mk128 04b7 .refptr.__bid_shiftright128 04cb .refptr.__bid_maskhigh128 04e0 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 11 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 84 9A 04 00 00 83 F8 13 0F 8F 8F 05 00 00 BB 14 00 00 00 44 89 D7 4C 89 D5 29 C3 48 8B 05 ?? ?? ?? ?? 48 C1 ED 20 48 63 DB 49 89 FB 48 8B 1C D8 48 89 D8 89 DB 48 89 DE 48 C1 E8 20 48 0F AF DF 48 0F AF F5 4C 0F AF D8 48 89 DF 89 DB 41 89 F4 48 C1 EF 20 48 C1 EE 20 48 0F AF E8 4C 01 E7 4A 8D 04 1F BF 0A 00 00 00 49 89 C3 48 C1 E0 20 48 8D 34 2E 49 C1 EB 20 48 01 D8 4C 01 DE 41 BB 05 00 00 00 49 39 F3 72 13 0F 85 DE 00 00 00 48 39 C7 0F 87 D5 00 00 00 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 37 01 00 00 48 85 D2 0F 84 B3 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4D 89 C1 49 C1 E1 05 4D 01 D9 41 8B 01 85 C0 75 1A 41 8B 41 18 4D 8B 49 08 4C 39 CA 0F 87 05 01 00 00 4C 39 CA 0F 84 E3 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 46 8D 1C 00 41 83 FB 13 0F 8F 4F FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FB 13 0F 84 99 FE FF FF 45 85 DB 0F 8E FF 03 00 00 45 85 C0 0F 88 16 01 00 00 0F 85 C0 00 00 00 4C 89 D0 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 5B FE FF FF 31 C0 4D 85 D2 0F 84 50 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 B0 00 00 00 66 0F EF D2 4D 89 D0 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 1D ?? ?? ?? ?? 4D 89 C1 49 C1 E1 05 4D 01 D9 41 8B 01 85 C0 0F 85 3A FF FF FF 41 8B 41 18 4D 8B 49 08 E9 24 FF FF FF 66 0F 1F 84 00 00 00 00 00 31 C0 E9 D9 FD FF FF 49 C1 E0 05 4F 39 54 03 10 0F 87 0E FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 83 C0 01 E9 FC FE FF FF 0F 1F 84 00 00 00 00 00 4D 85 C9 4D 63 C0 0F 84 44 02 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D0 48 F7 D8 4A 0F AF 04 C2 E9 8D FD FF FF 66 0F EF C9 F2 49 0F 2A CA 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 52 FF FF FF 0F 1F 84 00 00 00 00 00 44 89 C0 41 F7 D0 4D 89 D4 4D 63 C0 F7 D8 49 C1 EC 20 4C 89 C6 89 44 24 04 44 89 D0 48 C1 E6 04 89 C9 48 89 F5 48 03 2D ?? ?? ?? ?? 48 89 74 24 18 4C 8B 5D 08 4C 89 DB 45 89 DB 4D 89 DA 4C 89 DF 48 C1 EB 20 4D 0F AF D4 48 89 DE 48 0F AF F8 49 0F AF F4 45 89 D5 49 C1 EA 20 48 89 7C 24 08 48 C1 EF 20 4C 01 EF 49 89 DD 49 01 F2 4C 0F AF E8 4C 01 EF 48 89 FE 48 C1 E7 20 48 C1 EE 20 4D 8D 3C 32 4C 8B 55 00 4C 89 D6 45 89 D2 48 C1 EE 20 4C 89 D5 4D 89 D5 49 0F AF EC 4C 0F AF E8 4C 0F AF E6 41 89 EE 48 C1 ED 20 48 0F AF C6 4C 89 64 24 10 4D 89 EC 49 C1 EC 20 45 89 ED 4D 01 E6 4C 8B 64 24 10 49 01 C6 8B 44 24 08 49 01 EC 4C 89 F5 49 C1 E6 20 48 C1 ED 20 4D 01 F5 49 01 EC 48 01 C7 4C 01 E7 49 83 D7 00 48 C1 EA 20 48 89 D5 49 89 D4 49 0F AF EB 4C 0F AF D9 4C 0F AF E3 41 89 EE 48 C1 ED 20 4C 89 D8 45 89 DB 48 0F AF D9 48 C1 E8 20 4C 01 E5 48 01 D8 4C 01 F0 48 89 C3 48 C1 E0 20 48 C1 EB 20 4C 01 D8 48 01 EB 48 89 D5 49 0F AF EA 4C 0F AF D1 48 0F AF CE 41 89 EC 48 C1 ED 20 4D 89 D6 45 89 D2 48 0F AF D6 49 C1 EE 20 4C 01 F1 49 01 CC 4C 89 E1 49 C1 E4 20 48 C1 E9 20 48 01 EA 4D 01 E2 48 01 CA 48 01 C2 48 83 D3 00 31 C9 4C 01 D7 0F 92 C1 48 8D 04 11 4C 89 FA 48 01 C2 41 0F 92 C2 48 39 C1 0F 97 C0 44 09 D0 0F B6 C0 48 01 C3 83 7C 24 04 16 0F 8E EC 00 00 00 48 8B 05 ?? ?? ?? ?? 42 8B 0C 80 48 89 D8 83 E9 40 48 D3 E8 48 8B 0D ?? ?? ?? ?? 4A 23 1C C1 48 09 D3 75 28 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 77 16 0F 85 13 FD FF FF 4C 3B 2A 0F 86 0A FD FF FF 0F 1F 80 00 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 F4 FC FF FF 90 48 8B 05 ?? ?? ?? ?? 4E 0F AF 14 C0 4C 89 D0 E9 4C FB FF FF 83 F8 13 0F 8F D4 00 00 00 BB 14 00 00 00 4C 89 D5 45 89 D3 29 C3 48 8B 05 ?? ?? ?? ?? 48 C1 ED 20 48 63 DB 48 8B 1C D8 48 89 DF 89 DB 48 89 DE 48 C1 EF 20 48 0F AF F5 49 0F AF DB 4C 0F AF DF 89 F0 48 C1 EE 20 48 C1 EB 20 48 0F AF EF 48 01 C3 4A 8D 04 1B 41 BB 05 00 00 00 48 C1 E8 20 48 01 EE 48 01 F0 49 39 C3 0F 87 5F FC FF FF E9 89 FB FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 D6 4E 8B 14 C0 48 8B 05 ?? ?? ?? ?? 46 8B 04 80 B8 40 00 00 00 44 29 C0 89 C1 48 89 D8 48 D3 E0 44 89 C1 48 D3 EE 48 09 F0 83 7C 24 04 03 0F 8E FB FE FF FF 4C 85 D2 0F 85 1A FF FF FF E9 ED FE FF FF 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 6F FA FF FF 83 F8 14 74 7E 4C 8B 1D ?? ?? ?? ?? 83 E8 14 48 98 49 8B 04 C3 4C 8D 1C 80 48 89 D0 E9 67 FF FF FF 83 F8 14 74 6B 4C 8B 1D ?? ?? ?? ?? 83 E8 14 48 98 49 8B 2C C3 48 89 E8 48 C1 E8 20 48 8D 1C 80 89 E8 48 8D 34 80 48 01 DB 48 01 F6 89 D8 48 C1 EB 20 49 89 F3 89 F6 49 C1 EB 20 49 01 C3 48 8D 44 AD 00 4C 89 DF 49 C1 EB 20 48 01 C3 48 C1 E7 20 4C 89 D0 48 01 F7 49 01 DB 48 89 D6 E9 84 FA FF FF 48 89 D0 41 BB 05 00 00 00 E9 F7 FE FF FF 48 89 D6 4C 89 D0 41 BB 05 00 00 00 BF 0A 00 00 00 E9 60 FA FF FF 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_15_8_0 {
	meta:
		name = "__bid128_to_int64_rninta"
		size = 1904
		refs = "00a5 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 0212 .refptr.__bid_midpoint128 03cf .refptr.__bid_midpoint64 0447 .refptr.__bid_ten2mk128 05b2 .refptr.__bid_shiftright128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 41 08 48 BA 00 00 00 00 00 00 00 78 4C 8B 11 4C 89 C0 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 4C 21 C2 48 39 CA 77 22 0F 85 EC 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C0 0F 84 26 02 00 00 41 83 FB 13 0F 8F F2 05 00 00 B8 14 00 00 00 45 89 D1 4C 89 D7 44 29 D8 4C 8B 1D ?? ?? ?? ?? 48 C1 EF 20 48 98 4D 8B 1C C3 4C 89 D8 45 89 DB 4C 89 DB 48 C1 E8 20 4D 0F AF D9 48 0F AF DF 4C 0F AF C8 4C 89 DE 45 89 DB 89 DD 48 C1 EE 20 48 C1 EB 20 48 0F AF F8 48 01 EE 4A 8D 04 0E 49 89 C1 48 C1 E0 20 48 8D 1C 3B 49 C1 E9 20 4C 01 D8 41 BB 05 00 00 00 4C 01 CB 41 B9 05 00 00 00 49 39 D9 72 13 49 39 C3 0F 87 2D 02 00 00 49 39 D9 0F 85 24 02 00 00 90 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 4C 89 C1 48 21 C1 48 39 C1 0F 84 17 02 00 00 48 85 D2 0F 84 DE 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 BF 03 00 00 48 89 C8 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 75 1A 44 8B 58 18 48 8B 40 08 48 39 C2 0F 87 E6 01 00 00 48 39 C2 0F 84 C4 01 00 00 4B 8D 0C 00 48 C1 E9 32 81 E9 20 18 00 00 45 8D 0C 0B 41 83 F9 13 0F 8F 51 FF FF FF 48 B8 00 00 00 00 00 00 00 80 49 21 C0 41 83 F9 13 0F 84 9B FE FF FF 31 C0 45 85 C9 0F 88 7F FE FF FF 0F 85 4C 01 00 00 41 8D 4B FF 83 F9 12 0F 8E BF 01 00 00 41 8D 4B EC 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 82 50 FE FF FF 0F 84 FE 04 00 00 49 83 F8 01 48 19 C0 83 E0 02 48 83 E8 01 E9 37 FE FF FF 0F 1F 80 00 00 00 00 31 C0 4D 85 D2 0F 84 25 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 42 01 00 00 66 0F EF D2 4C 89 D1 48 C1 E9 20 F2 48 0F 2A D1 66 48 0F 7E D1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 DE 03 00 00 83 E9 01 4C 8B 0D ?? ?? ?? ?? 48 89 C8 48 C1 E0 05 4C 01 C8 44 8B 18 45 85 DB 0F 85 10 FF FF FF 44 8B 58 18 48 8B 40 08 E9 FA FE FF FF 41 83 FB 13 0F 8F 34 03 00 00 B8 14 00 00 00 45 89 D1 4C 89 D7 44 29 D8 4C 8B 1D ?? ?? ?? ?? 48 C1 EF 20 48 98 4D 8B 1C C3 4C 89 D8 45 89 DB 4C 89 DB 48 C1 E8 20 4D 0F AF D9 48 0F AF DF 4C 0F AF C8 4C 89 DE 89 DD 48 C1 EE 20 48 C1 EB 20 48 0F AF F8 48 01 EE 4A 8D 04 0E 48 C7 C6 FB FF FF FF 49 89 C1 48 C1 E0 20 48 8D 1C 3B 49 C1 E9 20 4C 01 CB 45 89 D9 4C 01 C8 41 B9 04 00 00 00 49 39 D9 0F 82 E8 FD FF FF 75 09 48 39 C6 0F 86 DD FD FF FF 85 C9 0F 88 C5 00 00 00 0F 85 94 00 00 00 4C 89 D0 48 89 C2 48 F7 DA 4D 85 C0 48 0F 45 C2 E9 0A FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 31 C0 E9 F9 FC FF FF 48 C1 E1 05 4D 39 54 09 10 0F 87 2D FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 C3 01 E9 1A FE FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A CA 66 48 0F 7E C9 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 FE 03 00 00 E9 C0 FE FF FF 48 85 D2 0F 85 5A FE FF FF 48 8B 15 ?? ?? ?? ?? 48 63 C9 4C 39 14 CA 0F 87 90 FC FF FF E9 41 FE FF FF 4D 85 C0 48 63 C9 0F 84 E9 01 00 00 48 8B 15 ?? ?? ?? ?? 49 F7 DA 4C 89 D0 48 0F AF 04 CA E9 68 FC FF FF 0F 1F 84 00 00 00 00 00 41 89 CE 41 F7 DE 41 83 FE 13 0F 8F DC 02 00 00 48 8B 05 ?? ?? ?? ?? F7 D1 4D 89 D1 48 63 C9 4C 03 0C C8 4D 39 D1 49 89 CB 4D 89 CD 48 83 D2 00 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 45 89 C9 49 C1 ED 20 4C 89 CF 4C 89 E8 4D 89 EC 4D 8B 53 08 4D 8B 1B 4C 89 D3 45 89 D2 49 0F AF FA 48 C1 EB 20 49 0F AF C2 4C 0F AF E3 48 89 FE 89 FF 89 C5 48 C1 EE 20 48 C1 E8 20 48 01 EE 4C 89 CD 4C 01 E0 48 0F AF EB 4D 89 EC 48 01 F5 48 89 EE 48 C1 E5 20 48 C1 EE 20 48 01 EF 89 D5 48 01 F0 4C 89 DE 45 89 DB 48 C1 EE 20 4C 0F AF EE 4D 0F AF E3 4C 89 6C 24 08 4D 89 CD 4D 0F AF EB 45 89 E7 49 C1 EC 20 4C 0F AF CE 4C 03 64 24 08 49 C1 ED 20 4D 01 FD 4D 01 E9 49 89 D5 49 C1 E9 20 4D 01 E1 49 01 F9 48 83 D0 00 49 C1 ED 20 4C 89 EA 4D 89 EF 49 0F AF D2 4C 0F AF D5 4C 0F AF FB 89 D7 48 C1 EA 20 4D 89 D4 49 C1 EA 20 48 0F AF DD 49 01 FA 4C 01 FA 4C 01 D3 4D 89 EA 4D 0F AF D3 48 89 DF 48 C1 E3 20 4C 0F AF DD 48 C1 EF 20 48 0F AF EE 48 01 D7 45 89 D7 49 C1 EA 20 4C 89 DA 45 89 DB 4C 0F AF EE 48 C1 EA 20 4C 01 FA 48 8D 34 2A 44 89 E2 48 01 D3 4D 01 EA 49 89 F5 48 C1 E6 20 49 C1 ED 20 4C 01 DE 4D 01 EA 49 01 DA 48 83 D7 00 45 31 DB 4C 01 CE 41 0F 92 C3 4D 01 DA 4C 01 D0 0F 92 C2 4D 39 D3 41 0F 97 C1 41 09 D1 41 83 FE 16 45 0F B6 C9 4A 8D 14 0F 0F 8F 38 01 00 00 4C 8B 0D ?? ?? ?? ?? 45 8B 14 89 41 B9 40 00 00 00 44 89 C9 44 29 D1 48 D3 E2 44 89 D1 48 D3 E8 48 09 C2 48 89 D0 E9 7A FD FF FF 48 8B 05 ?? ?? ?? ?? 4C 0F AF 14 C8 4C 89 D0 E9 82 FA FF FF 41 83 FB 14 0F 84 51 01 00 00 41 8D 43 EC 4C 8B 0D ?? ?? ?? ?? 48 98 4D 8B 24 C1 4C 89 E5 44 89 E6 48 C1 ED 20 4C 8D 0C B5 00 00 00 00 48 89 EF 48 8D 04 AD 00 00 00 00 48 C1 E7 20 48 89 FB 48 29 EF 48 29 C3 48 89 D8 48 89 F3 48 C1 E3 20 48 29 E8 49 89 DB 41 89 C5 48 29 F3 4D 29 CB 48 C1 E8 20 49 29 F3 4D 89 D9 49 C1 E9 20 4D 01 E9 49 01 D9 44 89 DB 4E 8D 1C A7 4C 89 CE 49 C1 E9 20 4C 01 D8 48 C1 E6 20 48 01 DE 49 01 C1 48 89 D3 4C 89 D0 E9 A9 FC FF FF 41 83 FB 14 0F 84 A2 00 00 00 41 8D 43 EC 4C 8B 0D ?? ?? ?? ?? 48 98 49 8B 3C C1 48 89 F8 48 C1 E8 20 48 8D 34 80 89 F8 48 8D 1C 80 89 F0 48 C1 EE 20 49 89 D9 89 DB 49 C1 E9 20 49 01 C1 48 8D 04 BF 4D 89 CB 49 C1 E9 20 48 01 C6 49 C1 E3 20 4C 89 D0 49 01 DB 49 01 F1 48 89 D3 E9 21 FA FF FF 48 8B 05 ?? ?? ?? ?? 8B 0C 88 83 E9 40 48 D3 EA E9 D6 FE FF FF B8 EC FF FF FF 4D 89 D1 29 C8 F7 D1 48 98 48 63 C9 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 08 48 03 50 08 E9 0F FD FF FF 4C 39 11 0F 87 43 F9 FF FF E9 F4 FA FF FF 48 89 D3 4C 89 D0 41 B9 05 00 00 00 41 BB 05 00 00 00 E9 BF F9 FF FF 48 89 D3 4C 89 D0 41 B9 04 00 00 00 48 C7 C6 FB FF FF FF E9 CE FB FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_15_9_0 {
	meta:
		name = "__bid128_to_int64_xrninta"
		size = 2240
		refs = "00a2 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 0212 .refptr.__bid_midpoint128 03d1 .refptr.__bid_midpoint64 0464 .refptr.__bid_ten2mk128 05ce .refptr.__bid_maskhigh128 05ed .refptr.__bid_shiftright128 0646 .refptr.__bid_ten2mk128trunc 07ba .refptr.__bid_onehalf128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 4D 85 C9 0F 84 29 02 00 00 41 83 FA 13 0F 8F 86 06 00 00 B0 14 44 89 D9 4C 89 DF 44 29 D0 4C 8B 15 ?? ?? ?? ?? 48 C1 EF 20 48 98 4D 8B 14 C2 4C 89 D0 45 89 D2 4C 89 D3 48 C1 E8 20 4C 0F AF D1 48 0F AF DF 48 0F AF C8 4C 89 D6 45 89 D2 89 DD 48 C1 EE 20 48 C1 EB 20 48 0F AF F8 48 01 EE 48 8D 04 0E 48 89 C1 48 C1 E0 20 48 8D 1C 3B 48 C1 E9 20 4C 01 D0 41 BA 05 00 00 00 48 01 CB B9 05 00 00 00 48 39 D9 72 17 0F 85 41 02 00 00 49 39 C2 0F 87 38 02 00 00 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 1B 02 00 00 48 85 D2 0F 84 DE 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 75 1A 44 8B 50 18 48 8B 40 08 48 39 C2 0F 87 E4 01 00 00 48 39 C2 0F 84 C6 01 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 02 83 F8 13 0F 8F 4F FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 13 0F 84 9A FE FF FF 85 C0 0F 88 24 02 00 00 0F 85 5B 01 00 00 41 8D 42 FF 83 F8 12 0F 8E C3 01 00 00 41 8D 4A EC 31 C0 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 72 14 0F 84 00 06 00 00 49 83 F9 01 48 19 C0 83 E0 02 48 83 E8 01 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 31 FE FF FF 90 31 C0 4D 85 DB 0F 84 25 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 42 01 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 0F 85 0F FF FF FF 44 8B 50 18 48 8B 40 08 E9 F9 FE FF FF 41 83 FA 13 0F 8F C5 03 00 00 B8 14 00 00 00 44 89 D9 4C 89 DF 44 29 D0 4C 8B 15 ?? ?? ?? ?? 48 C1 EF 20 48 98 4D 8B 14 C2 4C 89 D0 45 89 D2 4C 89 D3 48 C1 E8 20 4C 0F AF D1 48 0F AF DF 48 0F AF C8 4C 89 D6 45 89 D2 89 DD 48 C1 EE 20 48 C1 EB 20 48 0F AF F8 48 01 EE 48 8D 04 0E 48 C7 C6 FB FF FF FF 48 89 C1 48 C1 E0 20 48 8D 1C 3B 48 C1 E9 20 4C 01 D0 48 01 CB B9 04 00 00 00 48 39 D9 0F 82 E6 FD FF FF 48 39 C6 77 11 48 39 D9 0F 84 D8 FD FF FF 0F 1F 84 00 00 00 00 00 45 85 C0 0F 88 CB 00 00 00 0F 85 91 00 00 00 4C 89 D8 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 E9 FC FC FF FF 31 C0 E9 F5 FC FF FF 49 C1 E0 05 4F 39 5C 01 10 0F 87 2B FE FF FF 66 0F 1F 44 00 00 41 83 C2 01 E9 1C FE FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 C0 FE FF FF 48 85 D2 0F 85 54 FE FF FF 48 8B 0D ?? ?? ?? ?? 48 63 D0 31 C0 4C 39 1C D1 0F 87 4C FE FF FF E9 39 FE FF FF 0F 1F 80 00 00 00 00 4D 85 C9 4D 63 C0 0F 84 72 02 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 4A 0F AF 04 C2 E9 5D FC FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 4C FC FF FF 44 89 C0 F7 D8 83 F8 13 89 44 24 0C 0F 8F 45 03 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 45 89 D2 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 EC 20 4C 89 D6 48 89 44 24 18 4C 89 E0 4C 89 E5 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF C1 49 0F AF EB 48 89 F7 89 F6 41 89 C5 48 C1 EF 20 48 C1 E8 20 4C 01 EF 4D 89 D5 48 01 E8 4D 0F AF EB 4C 01 EF 4D 89 D5 48 89 FD 48 C1 E7 20 48 C1 ED 20 48 01 FE 4C 8D 3C 28 48 8B 03 4C 89 E5 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF E8 4C 0F AF E3 48 0F AF E8 4C 89 64 24 10 4D 89 EC 45 89 ED 4C 0F AF D3 49 C1 EC 20 41 89 EE 4D 01 E6 4C 8B 64 24 10 48 C1 ED 20 4D 01 D6 49 01 EC 4D 89 F2 49 C1 E6 20 49 C1 EA 20 4D 01 EE 4D 01 D4 49 89 D2 89 D2 4C 01 E6 49 83 D7 00 49 C1 EA 20 4C 89 D5 4C 89 D7 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 ED 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 EC 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FD 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 EC 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 48 01 CA 48 83 D5 00 31 C9 48 01 C6 0F 92 C1 48 01 CA 49 01 D7 41 0F 92 C3 48 39 D1 4D 89 FA 0F 97 C0 48 8B 15 ?? ?? ?? ?? 44 09 D8 0F B6 C0 48 01 E8 83 7C 24 0C 16 0F 8F BF 01 00 00 4A 8B 1C C2 48 8B 15 ?? ?? ?? ?? 46 8B 1C 82 BA 40 00 00 00 44 29 DA 89 D1 4C 89 FA 48 D3 E0 44 89 D9 48 D3 EA 48 09 D0 83 7C 24 0C 03 0F 8F 44 02 00 00 48 BA 00 00 00 00 00 00 00 80 48 39 D6 77 07 75 35 4D 85 F6 74 30 48 BA 00 00 00 00 00 00 00 80 49 C1 E0 04 48 01 D6 4C 89 C2 48 03 15 ?? ?? ?? ?? 48 3B 72 08 77 0F 0F 85 0C FD FF FF 4C 3B 32 0F 82 03 FD FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 F4 FC FF FF 48 8B 05 ?? ?? ?? ?? 4E 0F AF 1C C0 4C 89 D8 E9 EE F9 FF FF 41 83 FA 14 0F 84 A4 01 00 00 41 8D 42 EC 48 8B 0D ?? ?? ?? ?? 48 98 4C 8B 24 C1 4C 89 E5 44 89 E6 48 C1 ED 20 48 8D 0C B5 00 00 00 00 48 89 EF 48 8D 04 AD 00 00 00 00 48 C1 E7 20 48 89 FB 48 29 EF 48 29 C3 48 89 D8 48 89 F3 48 C1 E3 20 48 29 E8 49 89 DA 41 89 C5 48 29 F3 49 29 CA 48 C1 E8 20 49 29 F2 4C 89 D1 48 C1 E9 20 4C 01 E9 48 01 D9 44 89 D3 4E 8D 14 A7 48 89 CE 48 C1 E9 20 4C 01 D0 48 C1 E6 20 48 01 DE 48 01 C1 48 89 D3 4C 89 D8 E9 17 FC FF FF 41 83 FA 14 0F 84 23 01 00 00 41 8D 42 EC 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 3C C1 48 89 F8 48 C1 E8 20 48 8D 34 80 89 F8 48 8D 1C 80 89 F0 48 C1 EE 20 48 89 D9 89 DB 48 C1 E9 20 48 01 C1 48 8D 04 BF 49 89 CA 48 C1 E9 20 48 01 C6 49 C1 E2 20 4C 89 D8 49 01 DA 48 01 F1 48 89 D3 E9 89 F9 FF FF B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 A5 FC FF FF 49 89 C3 4E 23 1C C2 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 48 8B 15 ?? ?? ?? ?? 83 E9 40 48 D3 E8 4E 3B 1C C2 0F 87 91 FE FF FF 0F 85 8B FE FF FF 4D 85 FF 0F 95 C2 48 85 F6 41 0F 95 C0 4D 85 F6 0F 95 C1 41 08 C8 0F 84 6F FE FF FF 84 D2 0F 85 67 FE FF FF 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 87 51 FE FF FF 0F 85 4E FB FF FF 4C 3B 32 0F 86 45 FB FF FF E9 3D FE FF FF 4C 39 19 0F 87 05 FA FF FF E9 F2 F9 FF FF 48 89 D3 4C 89 D8 B9 04 00 00 00 48 C7 C6 FB FF FF FF E9 EA FA FF FF 48 89 D3 4C 89 D8 B9 05 00 00 00 41 BA 05 00 00 00 E9 A7 F8 FF FF 48 8B 15 ?? ?? ?? ?? 49 21 DA 4A 8B 14 C2 49 39 D2 77 2F 0F 85 E9 FD FF FF 48 89 F3 4C 09 F3 0F 84 DD FD FF FF 49 C1 E0 04 4C 89 C2 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 87 C5 FD FF FF E9 6F FF FF FF 4C 89 D3 48 29 D3 49 39 DA 48 89 DA 48 19 C9 48 09 CA 0F 85 A8 FD FF FF EB C9 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__powitf2"
		size = 240
		refs = "003a .rdata 0068 __multf3 00e2 __divtf3"
	strings:
		$1 = { 41 55 41 54 55 57 56 53 48 83 EC 78 0F 29 74 24 50 0F 29 7C 24 60 44 89 C0 49 89 CD 45 89 C4 C1 F8 1F 66 0F 6F 32 89 C3 44 31 C3 66 0F 6F FE 29 C3 F6 C3 01 75 08 66 0F 6F 3D ?? ?? ?? ?? 48 8D 6C 24 40 48 8D 7C 24 30 48 8D 74 24 20 0F 1F 00 D1 EB 74 45 49 89 F0 48 89 FA 48 89 E9 0F 29 74 24 30 0F 29 74 24 20 E8 ?? ?? ?? ?? F6 C3 01 66 0F 6F 74 24 40 74 D9 49 89 F0 48 89 FA 48 89 E9 0F 29 7C 24 30 0F 29 74 24 20 E8 ?? ?? ?? ?? D1 EB 66 0F 6F 7C 24 40 75 BB 45 85 E4 78 22 41 0F 29 7D 00 4C 89 E8 0F 28 74 24 50 0F 28 7C 24 60 48 83 C4 78 5B 5E 5F 5D 41 5C 41 5D C3 0F 1F 00 66 0F 6F 05 ?? ?? ?? ?? 48 8D 4C 24 40 48 8D 54 24 30 4C 8D 44 24 20 0F 29 7C 24 20 0F 29 44 24 30 E8 ?? ?? ?? ?? 66 0F 6F 7C 24 40 EB B0 90 90 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__powidf2"
		size = 96
		refs = "0004 .rdata"
	strings:
		$1 = { F2 0F 10 0D ?? ?? ?? ?? 89 D1 C1 F9 1F 89 C8 31 D0 29 C8 A8 01 74 09 66 0F 28 C8 0F 1F 44 00 00 D1 E8 74 10 A8 01 F2 0F 59 C0 74 F4 D1 E8 F2 0F 59 C8 75 F0 85 D2 66 0F 28 C1 78 04 F3 C3 66 90 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5E C8 66 0F 28 C1 C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__muldc3"
		size = 928
		refs = "01b3 .rdata"
	strings:
		$1 = { 48 83 EC 78 0F 29 34 24 0F 29 7C 24 10 44 0F 29 44 24 20 44 0F 29 4C 24 30 44 0F 29 54 24 40 44 0F 29 5C 24 50 44 0F 29 64 24 60 66 44 0F 28 C1 48 89 C8 F2 0F 10 A4 24 A0 00 00 00 F2 44 0F 59 C3 66 44 0F 28 D2 66 44 0F 28 C9 F2 44 0F 59 D4 66 44 0F 28 DA F2 44 0F 59 CC 66 41 0F 28 C0 F2 44 0F 59 DB F2 41 0F 5C C2 66 41 0F 28 E9 F2 41 0F 58 EB 66 0F 2E C0 7A 37 0F 28 34 24 0F 28 7C 24 10 44 0F 28 44 24 20 44 0F 28 4C 24 30 44 0F 28 54 24 40 44 0F 28 5C 24 50 44 0F 28 64 24 60 F2 0F 11 00 F2 0F 11 68 08 48 83 C4 78 C3 66 90 66 0F 2E ED 7B C3 66 0F 28 F1 F2 0F 5C F1 66 0F 2E F6 0F 8A 00 01 00 00 66 0F 28 F2 F2 0F 5C F2 66 0F 2E F6 0F 8A F5 01 00 00 45 31 C0 66 0F 28 F3 66 0F 2E DB F2 0F 5C F3 0F 9A C2 66 0F 2E F6 0F 8A 45 01 00 00 66 0F 28 F4 66 0F 2E E4 F2 0F 5C F4 0F 9A C1 66 0F 2E F6 0F 8A B1 01 00 00 45 84 C0 75 7F 66 41 0F 28 F0 F2 41 0F 5C F0 66 0F 2E F6 0F 8A DA 01 00 00 66 41 0F 28 F2 F2 41 0F 5C F2 66 0F 2E F6 0F 8A B6 01 00 00 66 41 0F 28 F1 F2 41 0F 5C F1 66 0F 2E F6 0F 8A C2 01 00 00 66 41 0F 28 F3 F2 41 0F 5C F3 66 0F 2E F6 0F 8B 15 FF FF FF 66 45 0F 2E DB 0F 8A 0A FF FF FF 66 0F 2E C9 0F 8A A9 01 00 00 66 0F 2E D2 0F 8A EF 01 00 00 84 D2 0F 85 DA 01 00 00 84 C9 0F 85 9C 01 00 00 66 0F 28 EA F2 0F 59 D3 66 0F 28 C1 F2 0F 59 EC F2 0F 59 C3 F2 0F 59 E1 F2 0F 5C C5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E2 F2 0F 59 C5 F2 0F 59 EC E9 B1 FE FF FF 66 0F 2E C9 0F 8A F6 FE FF FF 66 0F 28 F2 F2 0F 10 3D ?? ?? ?? ?? F2 0F 5C F2 66 0F 54 CF 66 0F 2E F6 66 0F 56 0D ?? ?? ?? ?? 0F 8A 56 01 00 00 66 0F EF F6 66 44 0F 28 E6 66 0F 28 F2 66 44 0F 54 25 ?? ?? ?? ?? 66 0F 2E DB 66 0F 54 F7 66 44 0F 56 E6 66 41 0F 28 D4 0F 8A 1F 01 00 00 66 0F 2E E4 0F 8A 0C 01 00 00 41 B8 01 00 00 00 E9 A2 FE FF FF 80 FA 01 0F 83 B2 FE FF FF 66 0F 28 F4 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C F4 66 44 0F 28 DB F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? 66 0F 54 C5 66 44 0F 54 DF 66 0F 2E F6 66 41 0F 56 C3 66 0F 28 D8 0F 8A 03 01 00 00 66 0F EF C0 66 0F 28 F4 66 0F 54 C5 66 0F 54 F7 66 0F 2E C9 66 0F 56 C6 66 0F 28 E0 0F 8A D8 00 00 00 66 0F 2E D2 0F 8B E2 FE FF FF 66 0F 54 D7 E9 D9 FE FF FF 66 0F 1F 44 00 00 80 F9 01 0F 83 46 FE FF FF 66 0F EF C0 EB 85 66 0F 2E D2 0F 8A 01 FE FF FF F2 0F 10 3D ?? ?? ?? ?? F2 0F 10 35 ?? ?? ?? ?? 66 0F 54 CF E9 0A FF FF FF 66 45 0F 2E D2 0F 8B 72 FE FF FF E9 3A FE FF FF 66 45 0F 2E C0 0F 8B 62 FE FF FF E9 16 FE FF FF 66 45 0F 2E C9 0F 8B 52 FE FF FF E9 2E FE FF FF 66 0F 54 0D ?? ?? ?? ?? E9 4A FE FF FF 66 0F 54 25 ?? ?? ?? ?? E9 57 FE FF FF 66 0F 54 E7 E9 EB FE FF FF 66 0F 54 DF E9 D8 FE FF FF 66 0F 2E D2 0F 8A A0 FE FF FF F2 0F 10 35 ?? ?? ?? ?? E9 97 FE FF FF 66 0F 54 1D ?? ?? ?? ?? E9 19 FE FF FF 66 0F 54 15 ?? ?? ?? ?? E9 04 FE FF FF 66 0F 54 CF E9 1F FF FF FF 66 0F 2E E4 0F 8A F3 FE FF FF F2 0F 10 05 ?? ?? ?? ?? E9 EA FE FF FF 90 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__fixdfti"
		size = 96
		refs = "0024 .rdata 002d __fixunsdfti"
	strings:
		$1 = { 48 83 EC 38 66 0F EF C9 66 0F 2E C8 77 12 48 83 C4 38 E9 ?? ?? ?? ?? 66 0F 1F 84 00 00 00 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 57 C1 E8 ?? ?? ?? ?? 0F 29 44 24 20 48 8B 44 24 20 48 8B 54 24 28 48 F7 D8 48 83 D2 00 48 89 44 24 20 48 F7 DA 48 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 38 C3 90 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__bid_fixsdsi"
		size = 32
		refs = "0005 __bid32_to_bid64 0011 __bid64_to_int32_xint"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 89 C1 48 83 C4 28 E9 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__bid_fixsddi"
		size = 32
		refs = "0005 __bid32_to_bid64 0011 __bid64_to_int64_xint"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 89 C1 48 83 C4 28 E9 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "isinfd32"
		size = 32
		refs = "0005 __bid32_to_bid64 0011 __bid64_isInf"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 89 C1 48 83 C4 28 E9 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__addvdi3"
		size = 48
		refs = "0029 abort"
	strings:
		$1 = { 48 83 EC 28 48 85 D2 48 8D 04 11 78 13 48 39 C8 0F 9C C2 84 D2 75 11 48 83 C4 28 C3 0F 1F 40 00 48 39 C8 0F 9F C2 EB EB E8 ?? ?? ?? ?? 90 66 90 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "__addvsi3"
		size = 48
		refs = "0028 abort"
	strings:
		$1 = { 48 83 EC 28 85 D2 8D 04 11 78 15 39 C8 0F 9C C2 84 D2 75 13 48 83 C4 28 C3 0F 1F 80 00 00 00 00 39 C8 0F 9F C2 EB E9 E8 ?? ?? ?? ?? 90 90 90 90 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__extendxftf2"
		size = 560
		refs = "0150 __sfp_handle_exceptions"
	strings:
		$1 = { 48 83 EC 68 0F 29 74 24 50 48 89 C8 DB 2A C7 44 24 3C 00 00 00 00 0F AE 5C 24 3C DB 7C 24 40 0F B7 54 24 48 44 0F B6 44 24 49 4C 8B 5C 24 40 81 E2 FF 7F 00 00 41 C0 E8 07 48 8D 4A 01 81 E1 FF 7F 00 00 48 83 F9 01 0F 8E 85 00 00 00 4D 89 DA 49 B9 FF FF FF FF FF FF 00 00 49 C1 E3 31 49 C1 EA 0F 4D 21 CA 48 C7 44 24 28 00 00 00 00 4C 8B 4C 24 28 48 B9 00 00 00 00 00 00 FF FF 81 E2 FF 7F 00 00 45 0F B6 C0 4C 89 5C 24 20 48 C1 E2 30 49 C1 E0 3F 49 21 C9 48 B9 FF FF FF FF FF FF 00 80 4D 09 D1 49 21 C9 48 B9 FF FF FF FF FF FF FF 7F 4C 09 CA 48 21 CA 4C 09 C2 48 89 54 24 28 66 0F 6F 74 24 20 0F 29 30 0F 28 74 24 50 48 83 C4 68 C3 48 85 D2 0F 85 95 00 00 00 4D 85 DB 0F 84 3D 01 00 00 4C 89 D9 48 C7 44 24 28 00 00 00 00 4D 01 DB 48 C1 E1 31 48 BA 00 00 00 00 00 00 FF FF 49 C1 EB 10 48 89 4C 24 20 48 8B 4C 24 28 45 0F B6 C0 49 C1 E0 3F 48 21 CA B9 02 00 00 00 49 09 D3 48 BA FF FF FF FF FF FF 00 80 49 21 D3 48 BA FF FF FF FF FF FF FF 7F 49 21 D3 4D 09 C3 4C 89 5C 24 28 66 0F 6F 74 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 0F 29 30 0F 28 74 24 50 48 83 C4 68 C3 66 2E 0F 1F 84 00 00 00 00 00 4D 85 DB 0F 84 9B 00 00 00 4C 89 D9 48 BA 00 00 00 00 00 80 00 00 49 B9 FF FF FF FF FF FF 00 00 48 C1 E1 31 48 C7 44 24 28 00 00 00 00 45 0F B6 C0 48 89 4C 24 20 4C 89 D9 49 C1 E0 3F 48 C1 E9 0F 48 09 CA 48 89 D1 48 BA 00 00 00 00 00 00 FF FF 4C 21 C9 4C 8B 4C 24 28 4C 21 CA 48 09 CA 48 B9 00 00 00 00 00 00 FF 7F 48 09 CA 48 B9 FF FF FF FF FF FF FF 7F 48 21 CA 4C 09 C2 48 89 54 24 28 48 BA 00 00 00 00 00 00 00 40 49 85 D3 66 0F 6F 74 24 20 0F 85 BB FE FF FF B9 01 00 00 00 E9 36 FF FF FF 45 31 D2 BA FF 7F 00 00 E9 44 FE FF FF 45 31 D2 4C 89 DA E9 39 FE FF FF 90 90 90 90 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__bid_gtsd2"
		size = 48
		refs = "0009 __bid32_to_bid64 001e __bid64_quiet_greater"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 48 98 48 83 C4 28 5B 5E C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__bid_nesd2"
		size = 48
		refs = "0009 __bid32_to_bid64 001e __bid64_quiet_not_equal"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 48 98 48 83 C4 28 5B 5E C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "__bid_unordsd2"
		size = 48
		refs = "0009 __bid32_to_bid64 001e __bid64_quiet_unordered"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 48 98 48 83 C4 28 5B 5E C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__bid_ltsd2"
		size = 48
		refs = "0009 __bid32_to_bid64 001e __bid64_quiet_less"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? F7 D8 48 98 48 83 C4 28 5B 5E C3 90 90 90 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "__sfp_handle_exceptions"
		size = 144
		refs = "0034 .rdata"
	strings:
		$1 = { 48 83 EC 38 F6 C1 01 74 0E 66 0F EF C0 F3 0F 5E C0 F3 0F 11 44 24 08 F6 C1 02 74 0F D9 74 24 10 66 83 4C 24 14 02 D9 64 24 10 9B F6 C1 04 74 16 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5E 05 ?? ?? ?? ?? F3 0F 11 44 24 0C F6 C1 08 74 0F D9 74 24 10 66 83 4C 24 14 08 D9 64 24 10 9B F6 C1 10 74 0F D9 74 24 10 66 83 4C 24 14 10 D9 64 24 10 9B 83 E1 20 74 16 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5E 05 ?? ?? ?? ?? F3 0F 11 44 24 10 48 83 C4 38 C3 90 90 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__bid64qq_mul"
		size = 528
		refs = "016c __bid64qqq_fma"
	strings:
		$1 = { 57 56 53 48 83 EC 50 4C 8B 41 08 4C 8B 11 4C 8B 0A 48 8B 4A 08 48 BA 00 00 00 00 00 00 00 78 4C 89 C0 48 21 D0 48 39 D0 0F 84 02 01 00 00 48 89 C8 48 21 D0 48 39 D0 0F 84 F3 00 00 00 48 B8 00 00 00 00 00 00 00 60 4C 89 C2 48 21 C2 48 39 C2 0F 84 5C 01 00 00 48 B8 FF FF FF FF FF FF 01 00 49 BB 00 00 00 00 00 00 FE 7F 48 BA C0 87 AD BE 09 ED 01 00 4C 21 C0 4D 21 C3 31 DB 48 39 D0 0F 86 FB 00 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 4C 89 CE 48 21 C2 48 39 C2 0F 84 2F 01 00 00 48 BA FF FF FF FF FF FF 01 00 48 B8 00 00 00 00 00 00 FE 7F 48 BF C0 87 AD BE 09 ED 01 00 48 21 CA 48 21 C8 48 39 FA 0F 86 C2 00 00 00 31 D2 31 F6 48 C1 E8 31 49 C1 EB 31 45 8D 9C 03 C0 CF FF FF 31 C0 41 81 FB 72 FE FF FF 7C 1E 41 81 FB 71 01 00 00 48 B8 00 00 00 00 00 00 E0 5F 7F 0B 41 8D 83 8E 01 00 00 48 C1 E0 35 48 85 DB 74 05 48 09 D6 75 1B 4C 31 C1 48 BA 00 00 00 00 00 00 00 80 48 21 D1 48 09 C8 48 83 C4 50 5B 5E 5F C3 48 89 4C 24 48 4C 89 44 24 38 48 8D 54 24 30 48 8D 4C 24 40 4C 8D 44 24 20 48 B8 00 00 00 00 00 00 FE 5F 4C 89 4C 24 40 4C 89 54 24 30 48 C7 44 24 20 00 00 00 00 48 89 44 24 28 E8 ?? ?? ?? ?? 48 83 C4 50 5B 5E 5F C3 0F 1F 84 00 00 00 00 00 74 6E 4C 09 D0 48 89 C3 E9 F8 FE FF FF 0F 1F 00 0F 85 3C FF FF FF 48 BF FF FF FF FF 63 8E 8D 37 31 F6 49 39 F9 48 0F 47 D6 49 0F 46 F1 E9 20 FF FF FF 4E 8D 1C 85 00 00 00 00 48 B8 00 00 00 00 00 00 FE 7F 31 DB 49 21 C3 E9 B7 FE FF FF 66 90 48 8D 14 8D 00 00 00 00 48 B8 00 00 00 00 00 00 FE 7F 31 F6 48 21 D0 31 D2 E9 E4 FE FF FF 66 90 48 BA FF FF FF FF 63 8E 8D 37 4C 09 D0 49 39 D2 48 0F 46 D8 E9 7C FE FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__bid64dq_mul"
		size = 64
		refs = "001a __bid64_to_bid128"
	strings:
		$1 = { 57 56 53 48 83 EC 40 48 8B 32 48 8B 7A 08 48 8D 5C 24 30 48 89 CA 48 89 D9 E8 ?? ?? ?? ?? 48 8D 54 24 20 48 89 D9 48 89 74 24 20 48 89 7C 24 28 E8 BB FD FF FF 48 83 C4 40 5B 5E 5F C3 0F 1F 00 }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "__bid64qd_mul"
		size = 80
		refs = "0017 __bid64_to_bid128"
	strings:
		$1 = { 57 56 53 48 83 EC 40 48 8B 31 48 8B 79 08 48 8D 5C 24 30 48 89 D9 E8 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 44 24 30 48 89 D9 48 89 74 24 30 48 89 7C 24 38 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 E8 6A FD FF FF 48 83 C4 40 5B 5E 5F C3 66 90 }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "__bid128_mul"
		size = 560
		refs = "0181 __bid128_fma"
	strings:
		$1 = { 55 57 56 53 48 83 EC 68 4C 8B 4A 08 48 B8 00 00 00 00 00 00 00 78 4C 8B 1A 48 89 CB 4D 8B 10 49 8B 50 08 4C 89 C9 48 21 C1 48 39 C1 0F 84 0E 01 00 00 48 89 D1 48 21 C1 48 39 C1 0F 84 FF 00 00 00 48 B8 00 00 00 00 00 00 00 60 4C 89 C9 48 21 C1 48 39 C1 0F 84 78 01 00 00 48 B8 FF FF FF FF FF FF 01 00 48 B9 00 00 00 00 00 00 FE 7F 49 B8 C0 87 AD BE 09 ED 01 00 4C 21 C8 4C 21 C9 31 F6 4C 39 C0 0F 86 19 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 D0 4C 89 D7 49 21 C0 49 39 C0 0F 84 4B 01 00 00 49 B8 FF FF FF FF FF FF 01 00 48 B8 00 00 00 00 00 00 FE 7F 48 BD C0 87 AD BE 09 ED 01 00 49 21 D0 48 21 D0 49 39 E8 0F 86 DE 00 00 00 45 31 C0 31 FF 48 C1 E9 31 48 C1 E8 31 8D 84 01 C0 CF FF FF 31 C9 3D E0 E7 FF FF 7C 1B 3D DF 17 00 00 48 B9 00 00 00 00 00 00 FE 5F 7F 0A 8D 88 20 18 00 00 48 C1 E1 31 48 85 F6 74 05 4C 09 C7 75 2C 4C 31 CA 48 B8 00 00 00 00 00 00 00 80 48 C7 03 00 00 00 00 48 21 D0 48 09 C1 48 89 D8 48 89 4B 08 48 83 C4 68 5B 5E 5F 5D C3 66 90 48 89 54 24 48 4C 89 4C 24 38 48 8D 4C 24 50 48 8D 54 24 40 4C 8D 4C 24 20 4C 8D 44 24 30 48 B8 00 00 00 00 00 00 FE 5F 4C 89 54 24 40 4C 89 5C 24 30 48 89 44 24 28 48 C7 44 24 20 00 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 89 03 48 8B 44 24 58 48 89 43 08 48 89 D8 48 83 C4 68 5B 5E 5F 5D C3 74 6C 4C 09 D8 48 89 C6 E9 DA FE FF FF 90 0F 85 21 FF FF FF 48 BD FF FF FF FF 63 8E 8D 37 31 FF 49 39 EA 4C 0F 47 C7 49 0F 46 FA E9 05 FF FF FF 4A 8D 0C 8D 00 00 00 00 48 B8 00 00 00 00 00 00 FE 7F 31 F6 48 21 C1 E9 9B FE FF FF 66 90 4C 8D 04 95 00 00 00 00 48 B8 00 00 00 00 00 00 FE 7F 31 FF 4C 21 C0 45 31 C0 E9 C8 FE FF FF 90 49 B8 FF FF FF FF 63 8E 8D 37 4C 09 D8 4D 39 C3 48 0F 46 F0 E9 60 FE FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_28_4_0 {
	meta:
		name = "__bid128dd_mul"
		size = 144
		refs = "001a __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 83 EC 50 48 8D 74 24 40 48 89 CB 4C 89 C7 48 89 F1 E8 ?? ?? ?? ?? 48 89 FA 48 89 F1 4C 8B 6C 24 40 4C 8B 74 24 48 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 30 4C 89 74 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 6D FD FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 50 5B 5E 5F 41 5D 41 5E C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_28_5_0 {
	meta:
		name = "__bid128dq_mul"
		size = 112
		refs = "001d __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 83 EC 58 4D 8B 28 4D 8B 70 08 48 8D 74 24 40 48 89 CB 48 89 F1 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 20 4C 89 74 24 28 48 89 54 24 38 48 8D 54 24 30 48 89 44 24 30 E8 EF FC FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 58 5B 5E 41 5D 41 5E C3 }
	condition:
		$1
}

rule file_28_6_0 {
	meta:
		name = "__bid128qd_mul"
		size = 128
		refs = "0020 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 83 EC 58 4C 8B 2A 4C 8B 72 08 48 8D 74 24 40 48 89 CB 4C 89 C2 48 89 F1 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 30 4C 89 74 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 7C FC FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 58 5B 5E 41 5D 41 5E C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__unordtf2"
		size = 240
		refs = "00d7 __sfp_handle_exceptions"
	strings:
		$1 = { 53 48 83 EC 50 66 0F 6F 01 C7 44 24 4C 00 00 00 00 66 0F 6F 0A 0F 29 44 24 20 0F 29 4C 24 30 0F AE 5C 24 4C 48 B9 FF FF FF FF FF FF 00 00 48 8B 44 24 28 4C 8B 5C 24 20 4C 8B 54 24 30 49 89 C1 48 C1 E8 30 25 FF 7F 00 00 49 21 C9 48 89 C2 48 8B 44 24 38 48 21 C1 48 C1 E8 30 25 FF 7F 00 00 48 81 FA FF 7F 00 00 49 89 C8 48 89 C1 74 11 31 C0 48 81 F9 FF 7F 00 00 74 37 48 83 C4 50 5B C3 4C 89 C8 4C 09 D8 74 E7 48 B8 00 00 00 00 00 80 00 00 49 85 C1 74 3A 48 81 F9 FF 7F 00 00 B8 01 00 00 00 75 D5 4D 09 C2 75 18 B8 01 00 00 00 EB C9 4C 89 C3 4C 09 D3 74 C1 48 81 FA FF 7F 00 00 74 20 48 B8 00 00 00 00 00 80 00 00 49 85 C0 75 D9 B9 01 00 00 00 E8 ?? ?? ?? ?? B8 01 00 00 00 EB 98 4D 09 CB 74 BE EB 9F 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__fixunstfdi"
		size = 336
		refs = "0061 __sfp_handle_exceptions"
	strings:
		$1 = { 48 83 EC 48 66 0F 6F 01 C7 44 24 3C 00 00 00 00 0F 29 44 24 20 0F AE 5C 24 3C 48 BA FF FF FF FF FF FF 00 00 48 8B 4C 24 28 4C 8B 54 24 20 49 89 C8 48 21 CA 48 C1 E9 3F 49 C1 E8 30 66 41 81 E0 FF 7F 45 0F B7 C8 49 81 F9 FE 3F 00 00 7F 21 31 C0 4D 85 C9 74 2A B9 20 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 48 C3 90 84 C9 74 1C 31 C0 B9 01 00 00 00 EB DE 0F 1F 00 4C 09 D2 74 E5 B9 22 00 00 00 EB CF 0F 1F 40 00 49 81 F9 3E 40 00 00 7F 67 48 B8 00 00 00 00 00 00 01 00 45 0F B7 C0 48 09 C2 B8 6F 40 00 00 4C 29 C8 48 83 F8 3F 7F 59 45 8D 98 D1 BF FF FF 4C 89 D0 45 31 C9 44 89 D9 48 D3 E0 48 85 C0 B8 6F 40 00 00 41 0F 95 C1 44 29 C0 89 C1 4C 89 D0 48 D3 E8 44 89 D9 48 D3 E2 48 09 D0 45 85 C9 0F 84 76 FF FF FF E9 5D FF FF FF 0F 1F 80 00 00 00 00 48 C7 C0 FF FF FF FF B9 01 00 00 00 E9 4A FF FF FF 48 83 F8 40 74 27 41 8D 88 11 C0 FF FF 48 89 D0 48 D3 E0 45 31 C9 B9 2F 40 00 00 4C 09 D0 41 0F 95 C1 48 89 D0 44 29 C1 48 D3 E8 EB AD 30 C0 EB E2 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "sub256"
		size = 160
	strings:
		$1 = { 57 56 53 48 8B 39 4C 8B 52 08 4C 8B 4A 10 48 8B 59 08 4C 8B 59 10 48 8B 41 18 48 89 FE 48 2B 32 48 39 FE 76 0A 48 83 EB 01 48 83 FB FF 74 51 48 89 DF 4C 29 D7 48 39 DF 49 89 FA 76 0A 49 83 EB 01 49 83 FB FF 74 29 4C 89 D9 4C 29 C9 49 39 CB 48 83 D8 00 48 2B 42 18 49 89 30 4D 89 50 08 49 89 48 10 49 89 40 18 5B 5E 5F C3 0F 1F 44 00 00 4C 89 C9 48 83 E8 01 48 F7 D1 EB D8 0F 1F 40 00 49 83 EB 01 31 C9 49 F7 D2 49 83 FB FF 0F 94 C1 48 29 C8 EB B2 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "nr_digits256"
		size = 272
		refs = "0012 .refptr.__bid_ten2k256 0026 .refptr.__bid_ten2k64 004c .refptr.__bid_ten2k128"
	strings:
		$1 = { 4C 8B 11 4C 8B 41 08 4C 8B 49 10 48 8B 49 18 48 8B 15 ?? ?? ?? ?? 48 85 C9 75 59 4C 89 C8 4C 09 C0 75 21 48 8B 15 ?? ?? ?? ?? B8 01 00 00 00 90 4C 39 52 08 77 25 83 C0 01 48 83 C2 08 83 F8 14 75 EE F3 C3 4D 85 C9 75 17 48 8B 15 ?? ?? ?? ?? B8 14 00 00 00 4C 39 42 08 76 59 F3 C3 0F 1F 00 48 8B 15 ?? ?? ?? ?? B8 27 00 00 00 4C 39 4A 10 77 E9 74 72 B8 01 00 00 00 EB 11 0F 1F 44 00 00 83 C0 01 48 83 C2 20 83 F8 1E 74 54 48 39 4A 38 77 1E 75 EC 4C 39 4A 30 77 16 75 E4 4C 39 42 28 77 0E 75 DC 4C 39 52 20 76 D6 66 0F 1F 44 00 00 83 C0 27 C3 74 47 B8 01 00 00 00 EB 0F 0F 1F 00 83 C0 01 48 83 C2 10 83 F8 13 74 17 4C 39 42 18 77 08 75 EC 4C 39 52 10 76 E6 83 C0 14 C3 66 90 B0 45 C3 B0 27 C3 4C 39 42 08 0F 87 6B FF FF FF 75 82 4C 39 12 0F 86 79 FF FF FF F3 C3 4C 39 12 76 B4 F3 C3 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "rounding_correction.constprop.1"
		size = 688
		refs = "002d .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 41 55 41 54 55 57 56 53 8B 6C 24 58 48 8B 74 24 68 45 89 CA 8B 7C 24 60 41 09 EA 48 8B 1E 4C 8B 66 08 45 09 C2 41 09 D2 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 20 8D 87 20 18 00 00 49 BB FF FF FF FF FF FF 01 00 49 BA 00 00 00 00 00 00 00 80 49 89 C5 4C 89 D8 49 C1 E5 31 4C 21 E0 4D 21 E2 74 70 83 F9 01 41 0F 94 C3 85 D2 74 05 45 84 DB 75 69 85 ED 74 0B 83 F9 04 0F 94 C2 44 08 DA 75 5A 45 09 C1 0F 85 C9 01 00 00 81 FF DF 17 00 00 0F 8E 4C 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 66 90 83 F9 04 0F 84 97 01 00 00 83 F9 01 0F 84 8E 01 00 00 48 B8 C0 87 AD BE 09 ED FF DF 48 BB FF FF FF FF 63 8E 8D 37 EB 6B 0F 1F 84 00 00 00 00 00 85 D2 74 7C 83 F9 02 75 77 48 83 C3 01 0F 85 0D 01 00 00 48 83 C0 01 81 FF DF 17 00 00 0F 8E ED 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 4D 85 D2 75 9E 83 E9 02 48 BA 00 00 00 00 00 00 00 78 48 B8 C0 87 AD BE 09 ED FF 5F 83 E1 FD BB 00 00 00 00 48 0F 44 C2 48 BA FF FF FF FF 63 8E 8D 37 48 0F 45 DA 4C 09 D0 48 89 1E 48 89 46 08 5B 5E 5F 5D 41 5C 41 5D C3 66 2E 0F 1F 84 00 00 00 00 00 85 ED 74 0C 8D 51 FE 83 E2 FD 0F 84 79 FF FF FF 45 09 C1 0F 84 F9 00 00 00 89 CA 83 E2 FD 83 FA 01 0F 85 EB 00 00 00 48 83 EB 01 48 83 FB FF 0F 84 FB 00 00 00 48 BA FF FF FF FF 09 5B C1 38 48 39 D3 0F 85 4F FF FF FF 49 BB 93 8D 44 C6 4D 31 00 00 4C 39 D8 0F 85 3C FF FF FF 4D 85 ED 0F 84 DC 00 00 00 8D 87 1F 18 00 00 48 BB FF FF FF FF 63 8E 8D 37 83 EF 01 49 89 C5 48 B8 C0 87 AD BE 09 ED 01 00 49 C1 E5 31 E9 0A FF FF FF 0F 1F 00 4C 09 E8 E9 4B FF FF FF 0F 1F 84 00 00 00 00 00 48 BA 00 00 00 00 64 8E 8D 37 48 39 D3 0F 85 E4 FE FF FF 48 BA C0 87 AD BE 09 ED 01 00 48 39 D0 0F 85 D1 FE FF FF 8D 87 21 18 00 00 48 BB 00 00 00 00 0A 5B C1 38 83 C7 01 49 89 C5 48 B8 93 8D 44 C6 4D 31 00 00 49 C1 E5 31 E9 A8 FE FF FF 90 48 B8 00 00 00 00 00 00 00 F8 31 DB E9 E2 FE FF FF 8D 51 FE 83 FA 01 0F 87 2B FE FF FF E9 15 FF FF FF 81 FF DF 17 00 00 0F 8E 72 FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 28 E9 85 FE FF FF 0F 1F 00 48 83 E8 01 E9 5E FE FF FF 0F 1F 80 00 00 00 00 45 09 C1 48 89 D3 4C 89 D8 0F 84 48 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 10 E9 39 FE FF FF 66 90 }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "add_and_round.constprop.0"
		size = 5920
		refs = "0293 .refptr.__bid_IDEC_glbflags 031c .refptr.__bid_ten2k64 048a .refptr.__bid_ten2k128 0908 __bid_round256_58_76 0a50 __bid_round128_19_38 0c8e __bid_round192_39_57 146f .refptr.__bid_midpoint128 1565 .refptr.__bid_midpoint64 1667 __bid_round64_2_18"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC A8 01 00 00 4C 8B 94 24 28 02 00 00 48 8B 84 24 20 02 00 00 44 29 CA 44 89 C3 C7 84 24 F4 00 00 00 00 00 00 00 29 CA C7 84 24 F8 00 00 00 00 00 00 00 C7 84 24 FC 00 00 00 00 00 00 00 4C 8B 28 4C 8B 70 08 49 8B 02 4D 8B 7A 08 4D 8B 5A 10 4D 8B 42 18 C7 84 24 00 01 00 00 00 00 00 00 C7 84 24 04 01 00 00 00 00 00 00 48 89 44 24 58 48 8B 84 24 58 02 00 00 48 8B 30 48 8B 78 08 48 89 B4 24 30 01 00 00 48 89 BC 24 38 01 00 00 0F 85 6E 02 00 00 48 C7 84 24 98 01 00 00 00 00 00 00 48 C7 84 24 90 01 00 00 00 00 00 00 4C 89 B4 24 88 01 00 00 4C 89 AC 24 80 01 00 00 48 8B 84 24 10 02 00 00 45 31 ED 48 39 84 24 18 02 00 00 0F 84 CD 0F 00 00 4D 39 E8 0F 84 C4 0A 00 00 48 8B 44 24 58 4D 89 42 18 48 8D B4 24 D0 00 00 00 4D 89 7A 08 4D 89 5A 10 48 8D 94 24 B0 00 00 00 48 89 F1 49 89 02 48 89 84 24 D0 00 00 00 48 8B 84 24 80 01 00 00 4C 89 84 24 E8 00 00 00 4C 8D 84 24 80 01 00 00 4C 89 BC 24 D8 00 00 00 4C 89 9C 24 E0 00 00 00 48 89 84 24 B0 00 00 00 48 8B 84 24 88 01 00 00 48 89 84 24 B8 00 00 00 48 8B 84 24 90 01 00 00 48 89 84 24 C0 00 00 00 48 8B 84 24 98 01 00 00 48 89 84 24 C8 00 00 00 E8 20 FA FF FF 48 83 BC 24 98 01 00 00 00 75 1A 48 83 BC 24 90 01 00 00 00 75 0F 48 83 BC 24 88 01 00 00 00 0F 84 FB 0C 00 00 48 8B 84 24 80 01 00 00 48 89 F1 48 89 84 24 D0 00 00 00 48 8B 84 24 88 01 00 00 48 89 84 24 D8 00 00 00 48 8B 84 24 90 01 00 00 48 89 84 24 E0 00 00 00 48 8B 84 24 98 01 00 00 48 89 84 24 E8 00 00 00 E8 53 FA FF FF 83 F8 22 0F 8F 6C 06 00 00 8D 14 03 31 F6 81 FA 02 E8 FF FF 8D 93 20 18 00 00 40 0F 9C C6 48 C1 E2 31 48 0B 94 24 88 01 00 00 48 0B 94 24 18 02 00 00 48 89 94 24 38 01 00 00 48 8B 94 24 80 01 00 00 48 89 94 24 30 01 00 00 44 8B BC 24 30 02 00 00 45 85 FF 0F 85 C8 05 00 00 8D 14 18 81 FA 01 18 00 00 0F 8F A9 0C 00 00 81 FB E0 E7 FF FF 0F 8C 00 05 00 00 44 8B 8C 24 F4 00 00 00 44 8B 94 24 F8 00 00 00 8B 94 24 FC 00 00 00 44 8B 84 24 00 01 00 00 45 85 C9 75 09 45 85 D2 0F 84 F0 06 00 00 48 8B 05 ?? ?? ?? ?? 8B 08 41 89 CB 41 83 CB 20 85 F6 44 89 18 74 05 83 C9 30 89 08 48 8B 84 24 38 02 00 00 44 89 08 48 8B 84 24 40 02 00 00 44 89 10 48 8B 84 24 48 02 00 00 89 10 48 8B 84 24 50 02 00 00 44 89 00 48 8B 9C 24 58 02 00 00 48 8B 84 24 30 01 00 00 48 8B 94 24 38 01 00 00 48 89 03 48 89 53 08 48 81 C4 A8 01 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 83 FA 13 0F 8F F7 00 00 00 48 8B 05 ?? ?? ?? ?? 48 63 D2 45 89 F1 48 C7 84 24 18 01 00 00 00 00 00 00 48 C7 84 24 98 01 00 00 00 00 00 00 48 8B 34 D0 4C 89 F2 48 C1 EA 20 48 89 F5 48 89 B4 24 10 01 00 00 89 F6 48 C1 ED 20 49 89 EC 48 89 E9 4D 0F AF E1 4C 0F AF CE 48 0F AF CA 44 89 E7 49 C1 EC 20 4C 89 C8 45 89 C9 48 0F AF D6 48 C1 E8 20 4C 01 E1 48 01 F8 48 89 EF 48 01 D0 4C 89 EA 49 89 C4 48 C1 EA 20 48 C1 E0 20 49 C1 EC 20 49 01 CC 44 89 E9 48 0F AF F9 48 0F AF CE 48 0F AF EA 41 89 FE 48 C1 EF 20 49 89 CD 89 C9 48 0F AF D6 49 C1 ED 20 48 01 FD 4D 01 F5 49 01 D5 4C 89 EA 49 C1 E5 20 48 C1 EA 20 49 01 CD 48 01 D5 4A 8D 14 08 4C 89 AC 24 80 01 00 00 48 01 D5 49 83 D4 00 48 89 AC 24 88 01 00 00 4C 89 A4 24 90 01 00 00 E9 C3 FC FF FF 66 0F 1F 84 00 00 00 00 00 83 FA 26 0F 8E A7 08 00 00 83 FA 39 0F 8F 9E 0D 00 00 48 8B 05 ?? ?? ?? ?? 83 EA 26 4D 89 E9 48 63 D2 49 C1 E9 20 48 8B 04 D0 44 89 F2 49 C1 EE 20 48 89 C5 89 C0 48 89 C7 48 C1 ED 20 48 0F AF FA 0F AF D5 48 89 F9 89 FF 48 C1 E9 20 48 8D 34 0A 44 89 E9 48 89 74 24 60 48 89 EE 48 0F AF F1 48 0F AF C8 41 89 F4 48 C1 EE 20 48 89 CA 48 01 F7 89 C9 48 C1 EA 20 48 8B 35 ?? ?? ?? ?? 4C 01 E2 49 89 C4 4D 0F AF E1 49 0F AF C6 4C 0F AF CD 48 03 44 24 60 4C 01 E2 49 89 D4 48 C1 EA 20 4C 01 CF 48 C1 E0 20 49 C1 E4 20 48 01 C7 4C 01 E1 4C 8D 24 17 48 89 8C 24 20 01 00 00 49 89 C9 49 C1 E9 20 89 C9 4C 89 A4 24 28 01 00 00 4C 8B AE 28 01 00 00 4C 89 C8 48 89 CA 4C 89 CF 4D 89 EE 45 89 ED 49 0F AF D5 49 C1 EE 20 49 0F AF C5 49 0F AF FE 48 89 54 24 68 48 C1 EA 20 89 C5 48 01 EA 48 89 CD 49 0F AF EE 48 01 D5 48 C1 E8 20 48 01 C7 48 89 E8 48 89 6C 24 70 48 C1 E8 20 48 01 C7 48 8B 86 20 01 00 00 4C 89 CE 48 89 7C 24 60 48 89 C5 89 C0 48 0F AF F0 48 C1 ED 20 4C 0F AF CD 48 89 F2 48 89 CE 48 0F AF F0 4C 89 4C 24 78 89 D7 48 0F AF CD 48 C1 EA 20 49 89 F1 89 F6 49 C1 E9 20 4C 01 CF 4C 8B 4C 24 78 48 01 F9 49 01 D1 48 89 CA 48 C1 E1 20 48 01 F1 48 8B 74 24 70 48 C1 EA 20 48 89 8C 24 80 01 00 00 8B 4C 24 68 49 01 D1 48 C1 E6 20 48 89 F2 44 89 E6 48 01 CA 4C 89 E1 4C 01 CA 48 83 54 24 60 00 48 C1 E9 20 49 89 C9 49 89 CC 48 89 54 24 68 4D 0F AF CD 4C 0F AF EE 4D 0F AF E6 4C 89 EF 45 89 ED 4C 0F AF F6 48 C1 EF 20 4C 89 E2 45 89 CC 49 C1 E9 20 49 01 FC 4C 01 CA 4D 01 F4 49 89 CE 4C 0F AF F0 4D 89 E1 49 C1 E4 20 48 0F AF C6 49 C1 E9 20 4D 01 EC 48 0F AF F5 49 01 D1 4C 89 F2 45 89 F6 48 89 C7 48 C1 EA 20 89 C0 48 0F AF CD 48 C1 EF 20 4C 01 F7 48 01 F7 48 89 FE 48 C1 E7 20 48 01 D1 48 C1 EE 20 48 8B 54 24 68 48 01 F1 48 01 F8 48 8B 7C 24 60 49 01 CC 49 83 D1 00 48 01 C2 48 39 D0 48 89 94 24 88 01 00 00 0F 97 C0 0F B6 C0 49 01 C4 4C 01 E7 48 89 BC 24 90 01 00 00 49 39 FC 41 0F 97 C5 4C 39 E0 0F 97 C0 41 09 C5 45 0F B6 ED 4D 01 CD 4C 89 AC 24 98 01 00 00 48 8B 84 24 10 02 00 00 48 39 84 24 18 02 00 00 0F 84 FF 09 00 00 4D 39 E8 0F 83 29 FA FF FF 48 8B 7C 24 58 48 8B 84 24 80 01 00 00 48 8D B4 24 D0 00 00 00 4D 89 42 18 4D 89 7A 08 48 8D 94 24 B0 00 00 00 4D 89 5A 10 48 89 F1 49 89 3A 48 89 84 24 D0 00 00 00 48 8B 84 24 88 01 00 00 4C 89 84 24 C8 00 00 00 4C 8D 84 24 80 01 00 00 48 89 BC 24 B0 00 00 00 4C 89 BC 24 B8 00 00 00 4C 89 9C 24 C0 00 00 00 48 89 84 24 D8 00 00 00 48 8B 84 24 90 01 00 00 48 89 84 24 E0 00 00 00 48 8B 84 24 98 01 00 00 48 89 84 24 E8 00 00 00 E8 52 F4 FF FF 48 8B 84 24 10 02 00 00 48 89 84 24 18 02 00 00 E9 1D FA FF FF BA E0 E7 FF FF 8B BC 24 00 01 00 00 8B AC 24 F4 00 00 00 29 DA 44 8B A4 24 F8 00 00 00 8B 9C 24 FC 00 00 00 39 D0 C7 84 24 FC 00 00 00 00 00 00 00 C7 84 24 00 01 00 00 00 00 00 00 C7 84 24 F4 00 00 00 00 00 00 00 C7 84 24 F8 00 00 00 00 00 00 00 0F 8D E5 01 00 00 48 8B 84 24 18 02 00 00 C7 84 24 FC 00 00 00 01 00 00 00 BA 01 00 00 00 48 C7 84 24 30 01 00 00 00 00 00 00 45 31 C0 45 31 C9 45 31 D2 48 89 84 24 38 01 00 00 8B 84 24 30 02 00 00 85 C0 0F 84 88 FA FF FF BB E0 E7 FF FF EB 35 66 2E 0F 1F 84 00 00 00 00 00 81 FB E0 E7 FF FF 0F 8C 47 FF FF FF 44 8B 94 24 F8 00 00 00 44 8B 8C 24 F4 00 00 00 44 8B 84 24 00 01 00 00 8B 94 24 FC 00 00 00 48 8D 84 24 30 01 00 00 8B 8C 24 30 02 00 00 89 5C 24 28 44 89 54 24 20 48 89 44 24 30 E8 F3 F4 FF FF E9 01 FA FF FF 83 F8 26 8D 78 DE 0F 8E E6 06 00 00 83 F8 39 0F 8E 79 03 00 00 48 8B 94 24 80 01 00 00 4C 8D 8C 24 80 01 00 00 89 C1 49 89 F0 48 89 94 24 D0 00 00 00 48 8B 94 24 88 01 00 00 48 89 94 24 D8 00 00 00 48 8B 94 24 90 01 00 00 48 89 94 24 E0 00 00 00 48 8B 94 24 98 01 00 00 48 89 94 24 E8 00 00 00 48 8D 94 24 00 01 00 00 48 89 54 24 40 48 8D 94 24 FC 00 00 00 48 89 54 24 38 48 8D 94 24 F8 00 00 00 48 89 54 24 30 48 8D 94 24 F4 00 00 00 48 89 54 24 28 48 8D 94 24 04 01 00 00 48 89 54 24 20 89 FA E8 ?? ?? ?? ?? 48 8B 8C 24 88 01 00 00 48 8B 94 24 80 01 00 00 48 89 8C 24 28 01 00 00 48 89 94 24 20 01 00 00 8B 84 24 30 02 00 00 01 FB 03 9C 24 04 01 00 00 85 C0 0F 85 BF 06 00 00 31 F6 81 FB E0 E7 FF FF 40 0F 9C C6 8D 83 20 18 00 00 48 89 94 24 30 01 00 00 48 C1 E0 31 48 0B 84 24 18 02 00 00 48 09 C8 48 89 84 24 38 01 00 00 B8 22 00 00 00 E9 B8 F8 FF FF 90 85 D2 0F 85 08 F9 FF FF 45 85 C0 0F 84 1B F9 FF FF E9 FA F8 FF FF 66 2E 0F 1F 84 00 00 00 00 00 0F 84 8A 0A 00 00 83 F8 12 0F 8E 61 0C 00 00 49 BE FF FF FF FF FF FF 01 00 4C 8D 84 24 A0 00 00 00 4C 89 F1 48 23 8C 24 38 01 00 00 48 89 8C 24 18 01 00 00 48 8B 8C 24 30 01 00 00 4C 8B 94 24 18 01 00 00 48 89 8C 24 10 01 00 00 48 8D 8C 24 00 01 00 00 4C 8B 8C 24 10 01 00 00 4C 89 94 24 A8 00 00 00 48 89 4C 24 40 48 8D 8C 24 FC 00 00 00 4C 89 8C 24 A0 00 00 00 4C 8D 8C 24 30 01 00 00 48 89 4C 24 38 48 8D 8C 24 F8 00 00 00 48 89 4C 24 30 48 8D 8C 24 F4 00 00 00 48 89 4C 24 28 48 8D 8C 24 04 01 00 00 48 89 4C 24 20 89 C1 E8 ?? ?? ?? ?? 4C 8B AC 24 38 01 00 00 4D 21 EE 4D 89 F0 44 8B B4 24 04 01 00 00 45 85 F6 0F 84 BA 00 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 8C 24 30 01 00 00 45 89 ED 4D 89 EA 4C 89 84 24 18 01 00 00 49 C1 E8 20 48 8B 40 08 49 89 CE 48 89 8C 24 10 01 00 00 89 C9 49 C1 EE 20 49 89 CB 49 89 C1 89 C0 4C 0F AF D0 49 C1 E9 20 48 0F AF C8 4D 0F AF D9 4C 89 D2 45 89 D2 48 C1 EA 20 45 0F AF E9 45 89 DF 49 C1 EB 20 4D 0F AF CE 49 01 D5 48 89 CA 89 C9 48 C1 EA 20 4C 01 FA 4D 89 F7 4D 01 CB 4C 0F AF F8 49 0F AF C0 49 B8 FF FF FF FF FF FF 01 00 4C 01 FA 49 89 D7 48 C1 EA 20 49 01 C5 49 01 D3 49 C1 E7 20 49 C1 E5 20 4D 01 DA 4C 01 F9 4D 01 EA 48 89 8C 24 30 01 00 00 4D 21 D0 4C 0B 84 24 18 02 00 00 09 EF 4C 89 84 24 38 01 00 00 0F 84 DB 05 00 00 44 8B 8C 24 F4 00 00 00 45 85 C9 0F 85 AA 09 00 00 44 89 E2 09 DA 0F 85 2F 0B 00 00 83 BC 24 F8 00 00 00 00 0F 84 30 0B 00 00 41 89 D1 C7 84 24 FC 00 00 00 01 00 00 00 C7 84 24 00 01 00 00 00 00 00 00 C7 84 24 F4 00 00 00 00 00 00 00 C7 84 24 F8 00 00 00 00 00 00 00 45 31 C0 45 31 D2 BA 01 00 00 00 E9 42 FC FF FF 66 90 4C 39 9C 24 90 01 00 00 0F 87 FC FA FF FF 0F 85 28 F5 FF FF 4C 39 BC 24 88 01 00 00 0F 87 E8 FA FF FF 0F 85 14 F5 FF FF 48 8B 44 24 58 48 39 84 24 80 01 00 00 0F 82 01 F5 FF FF E9 CA FA FF FF 48 8B 94 24 90 01 00 00 4C 8B 84 24 80 01 00 00 4C 8D 8C 24 60 01 00 00 48 8B 8C 24 88 01 00 00 48 89 94 24 50 01 00 00 48 89 94 24 90 00 00 00 48 8D 94 24 00 01 00 00 4C 89 84 24 40 01 00 00 4C 89 84 24 80 00 00 00 4C 8D 84 24 80 00 00 00 48 89 54 24 40 48 8D 94 24 FC 00 00 00 48 89 8C 24 48 01 00 00 48 89 8C 24 88 00 00 00 89 C1 48 89 54 24 38 48 8D 94 24 F8 00 00 00 48 89 54 24 30 48 8D 94 24 F4 00 00 00 48 89 54 24 28 48 8D 94 24 04 01 00 00 48 89 54 24 20 89 FA E8 ?? ?? ?? ?? 48 8B 8C 24 68 01 00 00 48 8B 94 24 60 01 00 00 48 89 8C 24 28 01 00 00 48 89 94 24 20 01 00 00 E9 75 FC FF FF 66 0F 1F 84 00 00 00 00 00 83 EA 14 45 89 F1 4C 89 F6 48 63 C2 4C 89 C9 4C 89 CF 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 C1 EE 20 48 89 F5 48 8B 10 48 8B 40 08 49 89 D4 89 D2 49 C1 EC 20 49 0F AF CC 48 0F AF FA 49 0F AF EC 41 89 CE 48 C1 E9 20 48 89 7C 24 70 48 C1 EF 20 4C 01 F7 49 89 F6 48 01 CD 4C 0F AF F2 4C 01 F7 48 89 F9 48 C1 E7 20 48 C1 E9 20 48 01 E9 48 89 4C 24 68 4C 89 E9 48 C1 E9 20 49 89 CE 44 89 E9 48 89 CD 49 89 CD 4C 89 74 24 60 49 0F AF EC 4C 0F AF EA 4D 0F AF E6 48 0F AF 54 24 60 41 89 EE 48 C1 ED 20 4C 89 64 24 78 4D 89 EC 45 89 ED 49 C1 EC 20 4D 01 E6 49 01 D6 48 8B 54 24 78 48 01 EA 49 89 D4 4C 89 F2 49 C1 E6 20 48 C1 EA 20 4D 01 EE 49 01 D4 8B 54 24 70 4C 89 B4 24 80 01 00 00 48 01 FA 48 89 C7 89 C0 4C 01 E2 48 83 54 24 68 00 48 C1 EF 20 49 89 FC 48 89 FD 48 89 54 24 70 4D 0F AF E1 4C 0F AF C8 48 0F AF EE 45 89 E5 4C 89 E2 4D 89 CC 48 C1 EA 20 45 89 C9 48 0F AF F0 49 C1 EC 20 48 01 D5 4D 01 EC 4C 01 E6 49 89 FC 4C 0F AF E1 49 89 F5 48 C1 E6 20 48 0F AF C8 49 C1 ED 20 49 01 F1 48 0F AF 44 24 60 48 0F AF 7C 24 60 49 01 ED 4C 89 E2 45 89 E4 48 89 CD 48 C1 EA 20 89 C9 48 C1 ED 20 4C 01 E5 48 01 C5 48 89 E8 48 01 D7 48 8B 54 24 70 48 C1 E8 20 48 C1 E5 20 48 01 C7 48 01 CD 48 8B 4C 24 68 4C 01 CF 49 83 D5 00 48 01 EA 48 39 D5 48 89 94 24 88 01 00 00 0F 97 C2 0F B6 D2 48 01 D7 48 8D 2C 39 48 39 EF 48 89 AC 24 90 01 00 00 41 0F 97 C1 48 39 FA 0F 97 C0 41 09 C1 45 0F B6 C9 4D 01 CD 4C 89 AC 24 98 01 00 00 E9 00 F8 FF FF 0F 1F 44 00 00 48 83 BC 24 80 01 00 00 00 0F 85 F6 F2 FF FF 83 BC 24 30 02 00 00 01 B8 00 00 00 00 48 BA 00 00 00 00 00 00 00 80 48 C7 84 24 30 01 00 00 00 00 00 00 48 0F 45 D0 81 FB E0 E7 FF FF B8 E0 E7 FF FF 0F 4D C3 8D 98 20 18 00 00 48 C1 E3 31 48 09 D3 48 89 9C 24 38 01 00 00 E9 D9 F3 FF FF 66 90 49 B8 00 00 00 00 00 00 00 78 4C 0B 84 24 18 02 00 00 48 8B 9C 24 58 02 00 00 48 C7 84 24 30 01 00 00 00 00 00 00 48 8B 84 24 30 01 00 00 4C 89 84 24 38 01 00 00 48 89 03 48 8B 94 24 38 01 00 00 48 8B 05 ?? ?? ?? ?? 48 89 53 08 83 08 28 E9 A2 F3 FF FF 48 8B 94 24 88 01 00 00 4C 8D 84 24 A0 00 00 00 89 C1 48 89 94 24 18 01 00 00 48 8B 94 24 80 01 00 00 4C 8B 94 24 18 01 00 00 48 89 94 24 10 01 00 00 48 8D 94 24 00 01 00 00 4C 8B 8C 24 10 01 00 00 4C 89 94 24 A8 00 00 00 48 89 54 24 40 48 8D 94 24 FC 00 00 00 4C 89 8C 24 A0 00 00 00 4C 8D 8C 24 20 01 00 00 48 89 54 24 38 48 8D 94 24 F8 00 00 00 48 89 54 24 30 48 8D 94 24 F4 00 00 00 48 89 54 24 28 48 8D 94 24 04 01 00 00 48 89 54 24 20 89 FA E8 ?? ?? ?? ?? 48 8B 8C 24 28 01 00 00 48 8B 94 24 20 01 00 00 E9 29 }
	condition:
		$1
}

rule file_33_4_0 {
	meta:
		name = "bid128_ext_fma"
		size = 33552
		refs = "0314 .refptr.__bid_IDEC_glbround 0495 .refptr.__bid_IDEC_glbflags 05be .refptr.__bid_nr_digits 07e1 .refptr.__bid_ten2k128 08e6 __bid_round192_39_57 0d66 .refptr.__bid_ten2k64 1c21 .refptr.__bid_ten2k256 1eed __bid_round64_2_18 2126 __bid_round256_58_76 22ae __bid_round128_19_38 36f7 .refptr.__bid_midpoint64 37d6 .refptr.__bid_midpoint192 40aa .refptr.__bid_midpoint128 67ac .refptr.__bid_midpoint256"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC 18 02 00 00 48 8B 84 24 90 02 00 00 48 BE DD BA DD BA DD BA DD BA 48 89 94 24 68 02 00 00 4C 89 84 24 70 02 00 00 49 89 CE 4C 8B 84 24 88 02 00 00 48 8B 94 24 98 02 00 00 48 8B 38 48 8B 40 08 4C 89 8C 24 78 02 00 00 48 89 B4 24 60 01 00 00 49 8B 48 08 48 8B 1A 4D 8B 08 48 8B 52 08 49 89 C0 48 89 B4 24 68 01 00 00 48 BE 00 00 00 00 00 00 00 7C 49 89 FA 49 21 F0 49 89 CC 49 89 C3 49 39 F0 49 89 DD 48 89 D5 C7 84 24 44 01 00 00 00 00 00 00 C7 84 24 48 01 00 00 00 00 00 00 C7 84 24 4C 01 00 00 00 00 00 00 C7 84 24 50 01 00 00 00 00 00 00 C7 84 24 54 01 00 00 00 00 00 00 0F 84 5E 02 00 00 49 89 D3 49 21 F3 49 39 F3 0F 84 3D 03 00 00 48 89 CD 48 21 F5 48 39 F5 0F 84 AF 03 00 00 48 BE FF FF FF FF FF FF 01 00 49 BC 00 00 00 00 00 00 00 78 45 31 ED 48 21 CE 4C 39 E5 74 3F 49 BC 00 00 00 00 00 00 00 60 49 89 CD 4D 21 E5 4D 39 E5 0F 84 26 04 00 00 49 BD 00 00 00 00 00 00 FE 7F 49 BC C0 87 AD BE 09 ED 01 00 49 21 CD 4C 39 E6 0F 87 E7 09 00 00 0F 84 70 0D 00 00 49 BC FF FF FF FF FF FF 01 00 49 BF 00 00 00 00 00 00 00 78 48 C7 44 24 78 00 00 00 00 49 21 C4 4D 39 F8 4C 89 64 24 70 74 46 49 BC 00 00 00 00 00 00 00 60 49 89 C7 4D 21 E7 4D 39 E7 0F 84 DD 03 00 00 49 BC 00 00 00 00 00 00 FE 7F 49 BF C0 87 AD BE 09 ED 01 00 49 21 C4 4C 39 7C 24 70 4C 89 64 24 78 0F 87 66 09 00 00 0F 84 20 0D 00 00 48 BF 00 00 00 00 00 00 00 80 48 21 D7 48 89 BC 24 90 00 00 00 48 BF FF FF FF FF FF FF 01 00 48 21 D7 49 89 FC 48 BF 00 00 00 00 00 00 00 78 49 39 FB 0F 84 88 08 00 00 48 BF 00 00 00 00 00 00 00 60 49 89 D7 49 21 FF 49 39 FF 0F 84 0F 03 00 00 48 BF 00 00 00 00 00 00 FE 7F 48 21 D7 48 89 BC 24 88 00 00 00 48 BF C0 87 AD BE 09 ED 01 00 49 39 FC 0F 87 D7 08 00 00 49 89 DF 0F 84 7E 15 00 00 48 31 C8 48 B9 00 00 00 00 00 00 00 80 48 21 C8 48 89 84 24 80 00 00 00 48 B8 00 00 00 00 00 00 00 78 48 39 C5 0F 84 27 08 00 00 49 39 C0 0F 84 5E 08 00 00 49 39 C3 0F 84 F1 14 00 00 48 8B 44 24 78 4C 89 ED 48 C7 44 24 78 00 00 00 00 48 C1 ED 31 48 C1 E8 31 48 89 84 24 A0 00 00 00 8D 84 05 C0 CF FF FF 3D E0 E7 FF FF 7C 0E 05 20 18 00 00 48 C1 E0 31 48 89 44 24 78 4C 89 C8 48 09 F0 48 89 84 24 98 00 00 00 0F 85 D0 02 00 00 4C 89 F8 4C 09 E0 0F 85 D2 02 00 00 48 8B 9C 24 88 00 00 00 48 8B 44 24 78 48 39 C3 48 89 C7 48 0F 46 FB 48 8B 9C 24 90 00 00 00 48 39 9C 24 80 00 00 00 48 89 BC 24 68 01 00 00 0F 84 2E 27 00 00 48 8B 05 ?? ?? ?? ?? 83 38 01 0F 84 6A 32 00 00 48 C7 84 24 60 01 00 00 00 00 00 00 E9 7E 00 00 00 49 B8 FF FF FF FF FF 3F 00 00 49 B9 93 8D 44 C6 4D 31 00 00 49 21 C0 4D 39 C8 0F 86 CE 09 00 00 49 BB 00 00 00 00 00 C0 FF FF 45 31 D2 49 21 C3 49 B8 00 00 00 00 00 00 00 7E 4C 89 D8 4C 21 C0 4C 39 C0 0F 84 C5 07 00 00 48 B8 FF FF FF FF FF 3F 00 FC 4C 21 C2 4C 89 94 24 60 01 00 00 49 21 C3 4C 39 C2 4C 89 9C 24 68 01 00 00 0F 84 EE 00 00 00 4C 21 C1 4C 39 C1 0F 84 E2 00 00 00 48 8B 84 24 68 02 00 00 C7 00 00 00 00 00 48 8B 84 24 70 02 00 00 C7 00 00 00 00 00 48 8B 84 24 78 02 00 00 48 8B 94 24 68 01 00 00 C7 00 00 00 00 00 48 8B 84 24 80 02 00 00 49 89 56 08 C7 00 00 00 00 00 48 8B 84 24 60 01 00 00 49 89 06 4C 89 F0 48 81 C4 18 02 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 2E 0F 1F 84 00 00 00 00 00 48 B8 FF FF FF FF FF 3F 00 00 49 B8 93 8D 44 C6 4D 31 00 00 48 21 D0 4C 39 C0 0F 86 00 09 00 00 48 BD 00 00 00 00 00 C0 FF FF 45 31 ED 48 21 D5 48 BA 00 00 00 00 00 00 00 7E 48 89 E8 48 21 D0 48 39 D0 0F 84 87 08 00 00 48 B8 FF FF FF FF FF 3F 00 FC 48 21 D1 4C 89 AC 24 60 01 00 00 48 21 C5 48 39 D1 48 89 AC 24 68 01 00 00 0F 85 1E FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 E9 0F FF FF FF 48 B8 FF FF FF FF FF 3F 00 00 48 BA 93 8D 44 C6 4D 31 00 00 48 21 C8 48 39 D0 77 13 75 21 48 B8 FF FF FF FF 09 5B C1 38 49 39 C1 76 12 66 90 49 BC 00 00 00 00 00 C0 FF FF 45 31 C9 49 21 CC 48 B8 00 00 00 00 00 00 00 7E 4C 89 E2 48 21 C2 48 39 C2 0F 84 98 12 00 00 48 B8 FF FF FF FF FF 3F 00 FC 4C 89 8C 24 60 01 00 00 49 21 C4 4C 89 A4 24 68 01 00 00 E9 95 FE FF FF 0F 1F 44 00 00 4C 8D 3C 95 00 00 00 00 48 BF 00 00 00 00 00 00 FE 7F 45 31 E4 49 21 FF 4C 89 BC 24 88 00 00 00 45 31 FF E9 FA FC FF FF 0F 1F 84 00 00 00 00 00 4C 8D 2C 8D 00 00 00 00 49 B9 00 00 00 00 00 00 FE 7F 31 F6 4D 21 CD 45 31 C9 E9 E1 FB FF FF 90 48 8D 3C 85 00 00 00 00 49 BA 00 00 00 00 00 00 FE 7F 48 C7 44 24 70 00 00 00 00 4C 21 D7 45 31 D2 48 89 7C 24 78 E9 25 FC FF FF 0F 1F 44 00 00 48 8B 44 24 70 4C 09 D0 0F 84 22 FD FF FF 48 85 F6 0F 84 E9 05 00 00 66 0F EF C0 48 8B 0D ?? ?? ?? ?? F2 48 0F 2A C6 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 48 98 49 89 C3 49 C1 E3 05 49 01 CB 45 8B 03 45 85 C0 0F 84 5E 04 00 00 48 83 7C 24 70 00 0F 84 82 06 00 00 66 0F EF C9 48 8B 0D ?? ?? ?? ?? F2 48 0F 2A 4C 24 70 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 48 98 48 89 C7 48 C1 E7 05 48 01 CF 44 8B 1F 45 85 DB 0F 84 D5 03 00 00 0F 1F 44 00 00 4D 85 E4 0F 84 C7 05 00 00 66 0F EF D2 48 8B 0D ?? ?? ?? ?? F2 49 0F 2A D4 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 48 98 48 89 C7 48 C1 E7 05 48 01 CF 44 8B 2F 45 85 ED 0F 84 5C 03 00 00 48 83 BC 24 98 00 00 00 00 74 0A 48 8B 44 24 70 4C 09 D0 75 79 48 8B 4C 24 78 48 39 8C 24 88 00 00 00 0F 86 E5 07 00 00 B8 22 00 00 00 44 29 E8 89 C1 48 8B 84 24 88 00 00 00 48 2B 44 24 78 48 C1 E8 31 39 C1 0F 4E C1 85 C0 0F 85 CA 13 00 00 48 89 9C 24 60 01 00 00 31 C0 48 8B BC 24 88 00 00 00 48 C1 E0 31 48 29 C7 48 B8 00 00 00 00 00 00 FE 7F 48 21 C7 48 0B BC 24 90 00 00 00 48 09 D7 48 89 BC 24 68 01 00 00 E9 9E FC FF FF 48 8B 84 24 88 00 00 00 43 8D 3C 18 48 C1 E8 31 2D 20 18 00 00 83 FF 13 89 84 24 A8 00 00 00 48 8B 84 24 A0 00 00 00 8D 84 28 C0 CF FF FF 89 84 24 98 00 00 00 0F 8E 13 06 00 00 83 FF 14 0F 84 23 16 00 00 83 FF 26 0F 8F BE 13 00 00 41 83 F8 13 0F 8F 4E 1B 00 00 44 89 C8 44 89 D2 4D 89 C8 49 C1 E8 20 48 89 D1 4D 89 D3 48 0F AF D0 49 C1 EB 20 49 0F AF C8 49 0F AF C3 4C 0F AF 4C 24 70 49 89 D2 89 D2 89 CB 49 C1 EA 20 49 01 DA 4C 01 D0 49 89 C2 4D 0F AF C3 49 C1 E2 20 49 8D 1C 12 48 89 9C 24 A0 00 00 00 4D 01 C8 48 C1 E9 20 48 C1 E8 20 4C 01 C1 48 01 C8 48 89 44 24 70 8D 47 EB 48 8B 5C 24 70 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 39 58 08 0F 87 71 19 00 00 0F 84 5A 19 00 00 89 FB 48 C7 84 24 B8 00 00 00 00 00 00 00 48 C7 84 24 B0 00 00 00 00 00 00 00 4C 89 F8 4C 09 E0 0F 85 D5 07 00 00 48 8B 2D ?? ?? ?? ?? 83 FB 22 44 8B 7D 00 C7 45 00 00 00 00 00 0F 8E 89 05 00 00 83 FB 26 8D 73 DE 0F 8E C6 30 00 00 83 FB 39 0F 8F 63 2D 00 00 48 8B 84 24 B0 00 00 00 48 8B 4C 24 70 4C 8D 8C 24 B0 01 00 00 48 8B BC 24 A0 00 00 00 4C 8D 84 24 10 01 00 00 89 F2 48 89 84 24 A0 01 00 00 48 89 84 24 20 01 00 00 48 8D 84 24 50 01 00 00 48 89 8C 24 98 01 00 00 48 89 8C 24 18 01 00 00 89 D9 48 89 44 24 40 48 8D 84 24 4C 01 00 00 48 89 BC 24 90 01 00 00 48 89 BC 24 10 01 00 00 48 89 44 24 38 48 8D 84 24 48 01 00 00 48 89 44 24 30 48 8D 84 24 44 01 00 00 48 89 44 24 28 48 8D 84 24 54 01 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 84 24 B0 01 00 00 48 89 84 24 60 01 00 00 48 8B 84 24 B8 01 00 00 48 89 84 24 68 01 00 00 8B 84 24 54 01 00 00 01 B4 24 98 00 00 00 85 C0 0F 85 5D 1F 00 00 8B 84 24 98 00 00 00 8B BC 24 4C 01 00 00 BB 22 00 00 00 83 C0 22 3D 01 18 00 00 0F 8E D4 14 00 00 48 8B 05 ?? ?? ?? ?? 8B 08 85 C9 0F 85 5D 2F 00 00 48 B8 00 00 00 00 00 00 00 78 48 0B 84 24 80 00 00 00 48 C7 84 24 60 01 00 00 00 00 00 00 48 89 84 24 68 01 00 00 8B 45 00 83 C8 28 41 09 C7 48 8B 9C 24 68 02 00 00 8B 84 24 44 01 00 00 44 89 7D 00 89 03 8B 84 24 48 01 00 00 48 8B 9C 24 70 02 00 00 89 03 48 8B 84 24 78 02 00 00 89 38 8B 84 24 50 01 00 00 48 8B 9C 24 80 02 00 00 48 8B 94 24 68 01 00 00 89 03 48 8B 84 24 60 01 00 00 49 89 56 08 49 89 06 E9 21 FA FF FF 66 90 44 8B 6F 18 48 8B 7F 08 4C 39 E7 72 18 4C 39 E7 0F 85 8E FC FF FF 48 C1 E0 05 4C 39 7C 01 10 0F 87 7F FC FF FF 41 83 C5 01 E9 76 FC FF FF 66 90 44 8B 5F 18 48 8B 7F 08 48 3B 7C 24 70 72 21 48 3B 7C 24 70 0F 85 16 FC FF FF 48 C1 E0 05 4C 39 54 01 10 0F 87 07 FC FF FF 0F 1F 80 00 00 00 00 41 83 C3 01 E9 F7 FB FF FF 0F 1F 80 00 00 00 00 45 8B 43 18 4D 8B 5B 08 49 39 F3 72 18 49 39 F3 0F 85 8C FB FF FF 48 C1 E0 05 4C 39 4C 01 10 0F 87 7D FB FF FF 41 83 C0 01 E9 74 FB FF FF 66 90 49 89 DF 48 C7 84 24 88 00 00 00 00 00 00 00 E9 AE F7 FF FF 49 39 E8 0F 84 D3 00 00 00 48 8B 44 24 70 4C 09 D0 74 3F 49 39 EB 0F 84 F0 04 00 00 48 8B 84 24 80 00 00 00 48 C7 84 24 60 01 00 00 00 00 00 00 48 09 E8 48 89 84 24 68 01 00 00 E9 DC F8 FF FF 4D 39 C3 0F 84 73 0C 00 00 49 09 F1 0F 85 93 00 00 00 48 B8 00 00 00 00 00 00 00 7C 48 C7 84 24 60 01 00 00 00 00 00 00 48 89 84 24 68 01 00 00 E9 89 F9 FF FF 0F 1F 80 00 00 00 00 45 31 E4 45 31 FF E9 27 F7 FF FF 0F 1F 44 00 00 48 C7 44 24 70 00 00 00 00 45 31 D2 E9 8F F6 FF FF 31 F6 45 31 C9 E9 15 F6 FF FF 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 4C 89 94 24 60 01 00 00 83 08 01 48 B8 FF FF FF FF FF 3F 00 FC 49 21 C3 4C 89 9C 24 68 01 00 00 E9 44 F8 FF FF 0F 1F 40 00 4D 39 C3 0F 84 27 04 00 00 48 8B 84 24 80 00 00 00 48 C7 84 24 60 01 00 00 00 00 00 00 4C 09 C0 48 89 84 24 68 01 00 00 E9 13 F8 FF FF 0F 1F 00 45 31 C0 4D 85 C9 0F 84 46 FA FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C1 0F 87 81 03 00 00 66 0F EF DB F2 49 0F 2A D9 66 48 0F 7E D8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 8B 0D ?? ?? ?? ?? 48 98 49 89 C3 49 C1 E3 05 49 01 CB 45 8B 03 45 85 C0 0F 85 F5 F9 FF FF 45 8B 43 18 4D 8B 5B 08 E9 53 FE FF FF 66 0F 1F 44 00 00 45 31 ED 4D 85 FF 0F 84 68 FA FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C7 0F 87 E1 02 00 00 66 0F EF ED F2 49 0F 2A EF 66 48 0F 7E E8 48 C1 E8 34 25 FF 07 00 00 2D FF 03 00 00 48 8B 0D ?? ?? ?? ?? 48 98 48 89 C7 48 C1 E7 05 48 01 CF 44 8B 2F 45 85 ED 0F 85 1A FA FF FF 44 8B 6F 18 48 8B 7F 08 E9 76 FD FF FF 66 0F 1F 84 00 00 00 00 00 45 31 DB 4D 85 D2 0F 84 B4 F9 FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 87 D1 02 00 00 66 0F EF E4 F2 49 0F 2A E2 66 48 0F 7E E0 48 C1 E8 34 25 FF 07 00 00 2D FF 03 00 00 48 8B 0D ?? ?? ?? ?? 48 98 48 89 C7 48 C1 E7 05 48 01 CF 44 8B 1F 45 85 DB 0F 85 66 F9 FF FF 44 8B 5F 18 48 8B 7F 08 E9 38 FD FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 4C 89 AC 24 60 01 00 00 83 08 01 48 B8 FF FF FF FF FF 3F 00 FC 48 21 C5 48 89 AC 24 68 01 00 00 E9 94 F6 FF FF 0F 1F 40 00 0F 85 3C F6 FF FF 49 B8 FF FF FF FF 09 5B C1 38 4C 39 C7 0F 87 19 F6 FF FF E9 24 F6 FF FF 66 90 0F 85 0A F7 FF FF 48 B8 FF FF FF FF 09 5B C1 38 48 39 C3 0F 87 E7 F6 FF FF E9 F2 F6 FF FF 66 90 8D 5F FF 48 8B 05 ?? ?? ?? ?? 48 C7 84 24 B8 00 00 00 00 00 00 00 4D 0F AF D1 48 C7 84 24 B0 00 00 00 00 00 00 00 48 C7 44 24 70 00 00 00 00 48 63 D3 4C 3B 14 D0 4C 89 F8 4C 89 94 24 A0 00 00 00 0F 43 DF 4C 09 E0 0F 85 43 02 00 00 48 8B 2D ?? ?? ?? ?? 44 8B 7D 00 C7 45 00 00 00 00 00 8B 8C 24 98 00 00 00 89 C8 01 D8 3D 01 18 00 00 0F 8F 22 14 00 00 81 F9 DF 17 00 00 0F 8E 16 14 00 00 83 FB 13 44 8D 99 21 E8 FF FF 0F 8F 7F 37 00 00 41 83 FB 13 0F 8F 9B 4B 00 00 48 8B 8C 24 A0 00 00 00 4C 8B 05 ?? ?? ?? ?? 89 CA 48 89 C8 49 63 CB 49 8B 0C C8 48 C1 E8 20 48 89 C6 49 89 C8 89 C9 49 C1 E8 20 48 0F AF F1 48 0F AF CA 49 0F AF C0 48 89 CF 89 C9 49 0F AF D0 49 89 C1 48 C1 EF 20 89 F0 48 C1 EE 20 48 01 F8 48 01 C2 4A 8D 04 0E 49 89 D0 49 C1 E8 20 4C 01 C0 48 89 84 24 68 01 00 00 48 89 D0 48 C1 E0 20 48 01 C8 48 89 84 24 60 01 00 00 44 01 DB 31 FF C7 84 24 98 00 00 00 DF 17 00 00 8D 83 DF 17 00 00 E9 A5 FA FF FF 48 8B BC 24 90 00 00 00 4C 89 BC 24 60 01 00 00 4C 09 E7 48 0B BC 24 88 00 00 00 48 89 BC 24 68 01 00 00 E9 F7 F4 FF FF 0F 1F 80 00 00 00 00 49 BF FF FF FF FF 63 8E 8D 37 45 31 E4 4D 39 F9 49 0F 47 F4 4D 0F 47 CC E9 73 F2 FF FF 0F 1F 00 4C 8B 64 24 70 49 BF FF FF FF FF 63 8E 8D 37 45 31 D2 4C 39 FF 4D 0F 47 E2 4C 0F 46 D7 4C 89 64 24 70 E9 B9 F2 FF FF 66 0F 1F 84 00 00 00 00 00 66 0F EF ED 4C 89 F8 48 C1 E8 20 F2 48 0F 2A E8 66 48 0F 7E E8 48 C1 E8 34 25 FF 07 00 00 2D DF 03 00 00 E9 13 FD FF FF 0F 1F 84 00 00 00 00 00 66 0F EF DB 4C 89 C8 48 C1 E8 20 F2 48 0F 2A D8 66 48 0F 7E D8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 73 FC FF FF 0F 1F 84 00 00 00 00 00 66 0F EF E4 4C 89 D0 48 C1 E8 20 F2 48 0F 2A E0 66 48 0F 7E E0 48 C1 E8 34 25 FF 07 00 00 2D DF 03 00 00 E9 23 FD FF FF 0F 1F 84 00 00 00 00 00 48 8B 9C 24 90 00 00 00 48 39 9C 24 80 00 00 00 0F 85 30 FB FF FF 49 09 DB 48 C7 84 24 60 01 00 00 00 00 00 00 4C 89 9C 24 68 01 00 00 E9 DE F3 FF FF 89 FB 48 C7 84 24 B0 00 00 00 00 00 00 00 48 C7 84 24 B8 00 00 00 00 00 00 00 0F 1F 40 00 8B 84 24 A8 00 00 00 44 01 E8 29 D8 2B 84 24 98 }
	condition:
		$1
}

rule file_33_5_0 {
	meta:
		name = "__bid128_fma"
		size = 160
	strings:
		$1 = { 53 48 81 EC 90 00 00 00 49 8B 01 66 0F 6F 1A 48 89 CB 48 8D 4C 24 70 49 8B 51 08 4C 8D 8C 24 88 00 00 00 66 41 0F 6F 08 4C 8D 84 24 84 00 00 00 48 89 44 24 40 48 8D 44 24 40 48 89 54 24 48 48 8D 94 24 80 00 00 00 48 89 44 24 38 48 8D 44 24 50 0F 29 5C 24 60 48 89 44 24 30 48 8D 44 24 60 0F 29 4C 24 50 48 89 44 24 28 48 8D 84 24 8C 00 00 00 48 89 44 24 20 E8 74 7C FF FF 48 8B 44 24 70 48 89 03 48 8B 44 24 78 48 89 43 08 48 89 D8 48 81 C4 90 00 00 00 5B C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_33_6_0 {
	meta:
		name = "__bid128ddd_fma"
		size = 288
		refs = "0054 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 81 EC A0 00 00 00 0F 29 BC 24 90 00 00 00 48 8D 5C 24 70 4D 89 C5 48 89 CE 4C 89 CF C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 48 89 D9 C7 84 24 88 00 00 00 00 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 4C 89 EA 48 89 D9 66 0F 6F 7C 24 70 E8 ?? ?? ?? ?? 48 89 FA 48 89 D9 4C 8B 6C 24 70 4C 8B 74 24 78 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 54 24 78 4C 8D 8C 24 88 00 00 00 4C 8D 84 24 84 00 00 00 48 89 D9 4C 89 6C 24 50 0F 29 7C 24 60 48 89 44 24 40 48 8D 44 24 40 48 89 54 24 48 48 8D 94 24 80 00 00 00 48 89 44 24 38 48 8D 44 24 50 4C 89 74 24 58 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 48 8D 84 24 8C 00 00 00 48 89 44 24 20 E8 64 7B FF FF 48 8B 44 24 70 0F 28 BC 24 90 00 00 00 48 89 06 48 8B 44 24 78 48 89 46 08 48 89 F0 48 81 C4 A0 00 00 00 5B 5E 5F 41 5D 41 5E C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_7_0 {
	meta:
		name = "__bid128ddq_fma"
		size = 272
		refs = "0058 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 81 EC A0 00 00 00 0F 29 BC 24 90 00 00 00 48 8D 74 24 70 48 89 CB 4C 89 C7 4D 8B 29 4D 8B 71 08 48 89 F1 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 FA 48 89 F1 66 0F 6F 7C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 54 24 78 4C 8D 8C 24 88 00 00 00 4C 8D 84 24 84 00 00 00 48 89 F1 4C 89 6C 24 40 0F 29 7C 24 60 48 89 44 24 50 48 8D 44 24 40 48 89 54 24 58 48 8D 94 24 80 00 00 00 48 89 44 24 38 48 8D 44 24 50 4C 89 74 24 48 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 48 8D 84 24 8C 00 00 00 48 89 44 24 20 E8 55 7A FF FF 48 8B 44 24 70 0F 28 BC 24 90 00 00 00 48 89 03 48 8B 44 24 78 48 89 43 08 48 89 D8 48 81 C4 A0 00 00 00 5B 5E 5F 41 5D 41 5E C3 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_8_0 {
	meta:
		name = "__bid128dqd_fma"
		size = 272
		refs = "0058 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 81 EC A0 00 00 00 0F 29 BC 24 90 00 00 00 48 8D 74 24 70 48 89 CB 4C 89 CF 4D 8B 28 4D 8B 70 08 48 89 F1 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 FA 48 89 F1 66 0F 6F 7C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 54 24 78 4C 8D 8C 24 88 00 00 00 4C 8D 84 24 84 00 00 00 48 89 F1 4C 89 6C 24 50 0F 29 7C 24 60 48 89 44 24 40 48 8D 44 24 40 48 89 54 24 48 48 8D 94 24 80 00 00 00 48 89 44 24 38 48 8D 44 24 50 4C 89 74 24 58 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 48 8D 84 24 8C 00 00 00 48 89 44 24 20 E8 45 79 FF FF 48 8B 44 24 70 0F 28 BC 24 90 00 00 00 48 89 03 48 8B 44 24 78 48 89 43 08 48 89 D8 48 81 C4 A0 00 00 00 5B 5E 5F 41 5D 41 5E C3 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_9_0 {
	meta:
		name = "__bid128dqq_fma"
		size = 256
		refs = "0059 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 81 EC A8 00 00 00 0F 29 BC 24 90 00 00 00 48 8D 74 24 70 48 89 CB 66 41 0F 6F 38 48 89 F1 4D 8B 29 4D 8B 71 08 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 54 24 78 4C 8D 8C 24 88 00 00 00 4C 8D 84 24 84 00 00 00 48 89 F1 4C 89 6C 24 40 0F 29 7C 24 50 48 89 44 24 60 48 8D 44 24 40 48 89 54 24 68 48 8D 94 24 80 00 00 00 48 89 44 24 38 48 8D 44 24 50 4C 89 74 24 48 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 48 8D 84 24 8C 00 00 00 48 89 44 24 20 E8 45 78 FF FF 48 8B 44 24 70 0F 28 BC 24 90 00 00 00 48 89 03 48 8B 44 24 78 48 89 43 08 48 89 D8 48 81 C4 A8 00 00 00 5B 5E 41 5D 41 5E C3 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_10_0 {
	meta:
		name = "__bid128qdd_fma"
		size = 272
		refs = "0058 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 81 EC A0 00 00 00 0F 29 BC 24 90 00 00 00 48 8D 74 24 70 48 89 CB 4C 89 CF 66 0F 6F 3A 4C 89 C2 48 89 F1 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 FA 48 89 F1 4C 8B 6C 24 70 4C 8B 74 24 78 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 54 24 78 4C 8D 8C 24 88 00 00 00 4C 8D 84 24 84 00 00 00 48 89 F1 4C 89 6C 24 50 0F 29 7C 24 60 48 89 44 24 40 48 8D 44 24 40 48 89 54 24 48 48 8D 94 24 80 00 00 00 48 89 44 24 38 48 8D 44 24 50 4C 89 74 24 58 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 48 8D 84 24 8C 00 00 00 48 89 44 24 20 E8 31 77 FF FF 48 8B 44 24 70 0F 28 BC 24 90 00 00 00 48 89 03 48 8B 44 24 78 48 89 43 08 48 89 D8 48 81 C4 A0 00 00 00 5B 5E 5F 41 5D 41 5E C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_33_11_0 {
	meta:
		name = "__bid128qdq_fma"
		size = 256
		refs = "005b __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 81 EC A8 00 00 00 0F 29 BC 24 90 00 00 00 48 8D 74 24 70 48 89 CB 66 0F 6F 3A 4C 89 C2 48 89 F1 4D 8B 29 4D 8B 71 08 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 54 24 78 4C 8D 8C 24 88 00 00 00 4C 8D 84 24 84 00 00 00 48 89 F1 4C 89 6C 24 40 0F 29 7C 24 60 48 89 44 24 50 48 8D 44 24 40 48 89 54 24 58 48 8D 94 24 80 00 00 00 48 89 44 24 38 48 8D 44 24 50 4C 89 74 24 48 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 48 8D 84 24 8C 00 00 00 48 89 44 24 20 E8 33 76 FF FF 48 8B 44 24 70 0F 28 BC 24 90 00 00 00 48 89 03 48 8B 44 24 78 48 89 43 08 48 89 D8 48 81 C4 A8 00 00 00 5B 5E 41 5D 41 5E C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_12_0 {
	meta:
		name = "__bid128qqd_fma"
		size = 256
		refs = "005b __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 81 EC A8 00 00 00 0F 29 BC 24 90 00 00 00 48 8D 74 24 70 48 89 CB 66 0F 6F 3A 4C 89 CA 48 89 F1 4D 8B 28 4D 8B 70 08 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 54 24 78 4C 8D 8C 24 88 00 00 00 4C 8D 84 24 84 00 00 00 48 89 F1 4C 89 6C 24 50 0F 29 7C 24 60 48 89 44 24 40 48 8D 44 24 40 48 89 54 24 48 48 8D 94 24 80 00 00 00 48 89 44 24 38 48 8D 44 24 50 4C 89 74 24 58 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 48 8D 84 24 8C 00 00 00 48 89 44 24 20 E8 33 75 FF FF 48 8B 44 24 70 0F 28 BC 24 90 00 00 00 48 89 03 48 8B 44 24 78 48 89 43 08 48 89 D8 48 81 C4 A8 00 00 00 5B 5E 41 5D 41 5E C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_13_0 {
	meta:
		name = "__bid64qqq_fma"
		size = 3360
		refs = "0016 .refptr.__bid_IDEC_glbflags 0125 .refptr.__bid_IDEC_glbround 01e1 .refptr.__bid_nr_digits 02a1 __bid_round128_19_38 02e4 __bid128_to_bid64 04ff .refptr.__bid_ten2k64 0860 __bid_round64_2_18 0bcb .refptr.__bid_midpoint64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC D8 00 00 00 48 8B 1D ?? ?? ?? ?? 49 8B 00 48 BE DD BA DD BA DD BA DD BA 4C 8B 61 08 4C 8B 0A 4C 8D AC 24 80 00 00 00 4C 8B 19 4C 8B 52 08 48 89 B4 24 C0 00 00 00 49 8B 50 08 4C 8D 84 24 98 00 00 00 48 89 B4 24 C8 00 00 00 48 89 B4 24 B8 00 00 00 4C 89 E9 8B 33 C7 03 00 00 00 00 48 89 44 24 50 48 8D 44 24 50 4C 89 4C 24 60 48 89 54 24 58 4C 8D 8C 24 9C 00 00 00 48 8D 94 24 94 00 00 00 48 89 44 24 38 48 8D 44 24 60 4C 89 64 24 78 C7 84 24 94 00 00 00 00 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 48 89 44 24 30 48 8D 44 24 70 C7 84 24 9C 00 00 00 00 00 00 00 C7 84 24 A0 00 00 00 00 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 48 89 44 24 28 48 8D 84 24 A0 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 C7 84 24 AC 00 00 00 00 00 00 00 C7 84 24 B0 00 00 00 00 00 00 00 48 89 44 24 20 4C 89 5C 24 70 4C 89 54 24 68 E8 DE 73 FF FF 4C 8B 25 ?? ?? ?? ?? 4C 8B 84 24 80 00 00 00 48 8B AC 24 88 00 00 00 45 8B 0C 24 41 8D 41 FF 83 F8 02 0F 86 86 01 00 00 49 BA 00 00 00 00 00 00 00 78 48 89 E8 4C 21 D0 4C 39 D0 0F 84 6D 01 00 00 48 B8 FF FF FF FF FF FF 01 00 48 8D 7C 2D 00 48 21 E8 48 89 C1 48 C1 EF 32 4C 09 C1 0F 84 4B 02 00 00 8D 97 90 E9 FF FF 81 FA 30 03 00 00 0F 87 39 02 00 00 41 83 F9 04 0F 84 4F 06 00 00 48 85 C0 0F 85 56 02 00 00 48 BA FF FF FF FF FF FF 1F 00 49 39 D0 0F 87 B3 06 00 00 66 0F EF C9 F2 49 0F 2A C8 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 4C 8B 0D ?? ?? ?? ?? 48 63 D2 48 89 D1 48 C1 E1 05 4C 01 C9 44 8B 31 45 85 F6 75 26 44 8B 71 18 48 8B 49 08 48 39 C8 75 19 48 C1 E2 05 4D 39 44 11 10 0F 86 39 02 00 00 66 2E 0F 1F 84 00 00 00 00 00 81 EF 20 18 00 00 41 83 FE 10 0F 8E 30 02 00 00 41 83 FE 12 45 8D 7E F0 0F 8E D2 05 00 00 48 89 84 24 88 00 00 00 48 8D 84 24 B0 00 00 00 4C 8D 8C 24 C0 00 00 00 4C 89 84 24 80 00 00 00 44 89 FA 4D 89 E8 48 89 44 24 40 48 8D 84 24 AC 00 00 00 44 89 F1 48 89 44 24 38 48 8D 84 24 A8 00 00 00 48 89 44 24 30 48 8D 84 24 A4 00 00 00 48 89 44 24 28 48 8D 84 24 B4 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 84 24 C0 00 00 00 48 89 84 24 B8 00 00 00 44 01 FF 83 BC 24 B4 00 00 00 01 41 BE 10 00 00 00 83 DF FF E9 9A 01 00 00 66 90 4C 89 E9 4C 89 84 24 80 00 00 00 48 89 AC 24 88 00 00 00 E8 ?? ?? ?? ?? 48 89 C2 48 89 84 24 B8 00 00 00 48 C1 EA 35 F7 C2 FF 03 00 00 0F 85 AD 00 00 00 48 BA 00 00 00 00 00 00 00 7C 48 89 C1 48 21 D1 48 39 D1 0F 84 94 00 00 00 48 BA FF FF FF FF FF FF 1F 00 48 B9 FF 7F C6 A4 7E 8D 03 00 48 21 C2 48 39 CA 77 78 44 8B AC 24 9C 00 00 00 45 85 ED 0F 85 A7 00 00 00 44 8B A4 24 A0 00 00 00 45 85 E4 0F 85 96 00 00 00 8B AC 24 94 00 00 00 85 ED 0F 85 87 00 00 00 8B BC 24 98 00 00 00 85 FF 75 7C 44 8B 8C 24 94 00 00 00 45 85 C9 75 11 44 8B 84 24 98 00 00 00 45 85 C0 0F 84 1E 06 00 00 8B 0B 83 C9 20 09 F1 89 0B 48 81 C4 D8 00 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 90 44 8B 9C 24 9C 00 00 00 45 85 DB 75 D5 44 8B 94 24 A0 00 00 00 45 85 D2 75 C8 EB A8 0F 1F 40 00 4C 89 E9 4C 89 84 24 80 00 00 00 48 89 AC 24 88 00 00 00 E8 ?? ?? ?? ?? 09 33 EB AF 0F 1F 40 00 8B 0B 83 C9 30 EB A0 66 0F 1F 84 00 00 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C0 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA BF 03 00 00 48 63 D2 48 89 D1 48 C1 E1 05 4C 01 C9 44 8B 31 45 85 F6 0F 85 E2 FD FF FF 44 8B 71 18 48 8B 49 08 48 39 C8 0F 86 B3 FD FF FF 41 83 C6 01 E9 C8 FD FF FF 0F 1F 84 00 00 00 00 00 4C 89 84 24 B8 00 00 00 8B 84 24 A0 00 00 00 85 C0 75 0F 8B 94 24 94 00 00 00 85 D2 0F 84 C0 00 00 00 44 8B BC 24 A4 00 00 00 45 85 FF 0F 84 AF 00 00 00 48 8B 84 24 B8 00 00 00 48 BA FF 7F C6 A4 7E 8D 03 00 C7 84 24 A4 00 00 00 00 00 00 00 C7 84 24 AC 00 00 00 01 00 00 00 48 83 E8 01 48 39 D0 48 89 84 24 B8 00 00 00 0F 84 E7 04 00 00 41 8D 14 3E 48 B8 00 00 00 00 00 00 00 80 48 21 C5 81 FA 81 01 00 00 49 89 ED 0F 8F 74 01 00 00 81 FF 71 01 00 00 0F 8E 08 01 00 00 48 8B 15 ?? ?? ?? ?? 81 EF 71 01 00 00 48 63 FF 48 8B 14 FA 48 0F AF 94 24 B8 00 00 00 41 81 FE 11 FD FF FF 49 89 D0 48 89 94 24 B8 00 00 00 0F 8D 6F 04 00 00 8B 94 24 AC 00 00 00 BF FF 02 00 00 E9 B6 03 00 00 8B 94 24 9C 00 00 00 85 D2 75 0D 44 8B AC 24 98 00 00 00 45 85 ED 74 57 44 8B 9C 24 A8 00 00 00 45 85 DB 0F 85 35 03 00 00 44 8B 9C 24 A4 00 00 00 45 85 DB 0F 84 E4 04 00 00 85 D2 74 70 C7 84 24 AC 00 00 00 00 00 00 00 C7 84 24 B0 00 00 00 01 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 E9 1F FF FF FF 8B 8C 24 A4 00 00 00 85 C9 0F 85 04 03 00 00 44 8B 94 24 A8 00 00 00 45 85 D2 0F 84 8F 04 00 00 85 C0 0F 85 18 04 00 00 8B 84 24 94 00 00 00 85 C0 0F 85 09 04 00 00 85 C9 0F 84 E0 FE FF FF 8B 84 24 98 00 00 00 85 C0 0F 84 D1 FE FF FF E9 7C FF FF FF 81 FA 82 FE FF FF 0F 8C B0 00 00 00 8D 8F 8E 01 00 00 4C 8B 84 24 B8 00 00 00 48 63 F9 8B 84 24 AC 00 00 00 85 C0 0F 84 30 03 00 00 83 0B 20 41 83 3C 24 04 0F 84 93 03 00 00 48 BA FF FF FF FF FF FF 1F 00 49 39 D0 77 35 4C 89 C2 48 89 F8 09 33 4C 09 EA 48 C1 E0 35 48 09 D0 E9 37 FD FF FF 0B 33 48 BA 00 00 00 00 00 00 00 78 48 89 E8 48 09 D0 89 F2 83 CA 28 89 13 E9 19 FD FF FF 48 BA 00 00 00 00 00 00 00 60 4C 89 E8 48 C1 E7 33 48 09 D0 48 B9 FF FF FF FF FF FF 07 00 4C 89 C2 48 09 C7 48 21 CA 09 33 48 89 F8 48 09 D0 E9 E5 FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 81 FF 72 FE FF FF 0F 8D 14 02 00 00 8B 94 24 AC 00 00 00 8B 8C 24 B0 00 00 00 BD 72 FE FF FF 29 FD C7 84 24 AC 00 00 00 00 00 00 00 C7 84 24 B0 00 00 00 00 00 00 00 41 39 EE 89 94 24 9C 00 00 00 8B 94 24 A4 00 00 00 89 8C 24 A0 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 89 94 24 94 00 00 00 8B 94 24 A8 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 89 94 24 98 00 00 00 0F 8F B9 03 00 00 44 39 F5 0F 84 7A 04 00 00 48 C7 84 24 B8 00 00 00 00 00 00 00 C7 84 24 AC 00 00 00 01 00 00 00 45 31 C0 85 C9 0F 85 B7 02 00 00 8B 84 24 94 00 00 00 85 C0 0F 85 A8 02 00 00 8B 94 24 9C 00 00 00 85 D2 0F 85 36 03 00 00 44 8B BC 24 98 00 00 00 45 85 FF 0F 85 25 03 00 00 44 8B 8C 24 A4 00 00 00 45 85 C9 0F 85 5A 04 00 00 8B AC 24 A8 00 00 00 85 ED 0F 84 C6 04 00 00 85 C9 0F 85 8B 04 00 00 44 8B 94 24 94 00 00 00 45 85 D2 0F 85 7A 04 00 00 45 85 C9 0F 85 38 04 00 00 8B 94 24 AC 00 00 00 31 FF E9 0E 01 00 00 66 0F 1F 44 00 00 8B 8C 24 A8 00 00 00 85 C9 0F 84 A2 F9 FF FF 48 83 AC 24 B8 00 00 00 01 E9 94 F9 FF FF 0F 1F 00 48 8D 84 24 B0 00 00 00 4C 8D 8C 24 B8 00 00 00 44 89 FA 44 89 F1 48 89 44 24 40 48 8D 84 24 AC 00 00 00 48 89 44 24 38 48 8D 84 24 A8 00 00 00 48 89 44 24 30 48 8D 84 24 A4 00 00 00 48 89 44 24 28 48 8D 84 24 B4 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? E9 4C FA FF FF 0F 1F 80 00 00 00 00 66 0F EF D2 4C 89 C2 48 C1 EA 20 F2 48 0F 2A D2 66 48 0F 7E D2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 41 F9 FF FF 66 0F 1F 44 00 00 48 83 84 24 B8 00 00 00 01 C7 84 24 A8 00 00 00 00 00 00 00 C7 84 24 B0 00 00 00 01 00 00 00 E9 0C FC FF FF 44 8B 94 24 A8 00 00 00 45 85 D2 0F 84 1B FD FF FF E9 F7 FC FF FF 66 0F 1F 44 00 00 8D 8F 8E 01 00 00 8B 94 24 AC 00 00 00 4C 8B 84 24 B8 00 00 00 48 63 F9 85 D2 75 54 8B 94 24 B0 00 00 00 85 D2 75 49 8B 84 24 A4 00 00 00 85 C0 75 3E 8B 84 24 A8 00 00 00 85 C0 75 33 8B 84 24 9C 00 00 00 85 C0 75 28 8B 84 24 A0 00 00 00 85 C0 75 1D 83 BC 24 94 00 00 00 00 75 13 83 BC 24 98 00 00 00 00 0F 84 F3 FC FF FF 0F 1F 44 00 00 83 0B 30 E9 DB FC FF FF 0F 1F 84 00 00 00 00 00 8B 84 24 B0 00 00 00 85 C0 0F 85 C1 FC FF FF 44 8B BC 24 A4 00 00 00 45 85 FF 0F 85 B0 FC FF FF 44 8B B4 24 A8 00 00 00 45 85 F6 0F 84 AD FC FF FF E9 9A FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 BF FF 02 00 00 E9 77 FC FF FF 66 0F 1F 44 00 00 8B 0B E9 E0 F9 FF FF 48 B8 FF FF C0 6F F2 86 23 00 83 EF 01 48 89 84 24 B8 00 00 00 E9 FF FA FF FF 8B AC 24 A8 00 00 00 85 ED 0F 84 5E FC FF FF 49 83 C0 01 4C 89 84 24 B8 00 00 00 E9 4D FC FF FF C7 84 24 AC 00 00 00 01 00 00 00 C7 84 24 B0 00 00 00 00 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 E9 AE FA FF FF 8B 84 24 A4 00 00 00 85 C0 0F 84 49 FD FF FF 49 83 E8 01 C7 84 24 A4 00 00 00 00 00 00 00 C7 84 24 AC 00 00 00 01 00 00 00 4C 89 84 24 B8 00 00 00 31 FF E9 F6 FE FF FF 66 0F 1F 44 00 00 44 8B 8C 24 AC 00 00 00 45 85 C9 0F 85 5F FA FF FF 44 8B 84 24 B0 00 00 00 45 85 C0 0F 85 4E FA FF FF 85 C0 75 0B 8B 8C 24 94 00 00 00 85 C9 74 0B C7 84 24 B0 00 00 00 01 00 00 00 85 D2 75 0F 8B 84 24 98 00 00 00 85 C0 0F 84 21 FA FF FF C7 84 24 AC 00 00 00 01 00 00 00 E9 11 FA FF FF 44 8B B4 24 A8 00 00 00 45 85 F6 0F 84 A7 00 00 00 49 83 C0 01 C7 84 24 A8 00 00 00 00 00 00 00 C7 84 24 B0 00 00 00 01 00 00 00 4C 89 84 24 B8 00 00 00 31 FF E9 57 FE FF FF 48 8D 94 24 B0 00 00 00 4C 8B 84 24 B8 00 00 00 4C 8D 8C 24 B8 00 00 00 44 89 F1 48 89 54 24 40 48 8D 94 24 AC 00 00 00 48 89 54 24 38 48 8D 94 24 A8 00 00 00 48 89 54 24 30 48 8D 94 24 A4 00 00 00 48 89 54 24 28 48 8D 94 24 B4 00 00 00 48 89 54 24 20 89 EA E8 ?? ?? ?? ?? 8B 84 24 B4 00 00 00 85 C0 0F 85 C5 00 00 00 8B 8C 24 A0 00 00 00 4C 8B 84 24 B8 00 00 00 E9 EC FB FF FF 44 8B 8C 24 A4 00 00 00 45 85 C9 0F 84 F8 00 00 00 85 D2 0F 84 84 00 00 00 C7 84 24 AC 00 00 00 00 00 00 00 C7 84 24 B0 00 00 00 01 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 31 FF E9 39 FD FF FF BA 71 FE FF FF 4C 8B 05 ?? ?? ?? ?? 48 8B 84 24 B8 00 00 00 29 FA 48 63 D2 49 39 04 D0 0F 86 F7 00 00 00 C7 84 24 AC 00 00 00 01 00 00 00 48 C7 84 24 B8 00 00 00 00 00 00 00 45 31 C0 E9 5E FB FF FF 8B 84 24 A8 00 00 00 85 C0 0F 85 A6 FB FF FF 8B 8C 24 98 00 00 00 85 C9 0F 85 6D FF FF FF E9 B4 FB FF FF 48 8B 0D ?? ?? ?? ?? 41 29 EE 49 63 D6 4C 8B 04 D1 8B 8C 24 A0 00 00 00 4C 89 84 24 B8 00 00 00 E9 16 FB FF FF C7 84 24 AC 00 00 00 01 00 00 00 C7 84 24 B0 00 00 00 00 00 00 00 31 FF C7 84 24 A4 00 00 00 00 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 E9 D0 FC FF FF 8B BC 24 AC 00 00 00 85 FF 0F 85 C4 FD FF FF 44 8B 9C 24 B0 00 00 00 45 85 DB 0F 85 1C FF FF FF 85 C9 75 0A 83 BC 24 94 00 00 00 00 74 0B C7 84 24 B0 00 00 00 01 00 00 00 85 D2 75 0E 83 BC 24 98 00 00 00 00 0F 84 F1 FE FF FF C7 84 24 AC 00 00 00 01 00 00 00 31 FF E9 73 FC FF FF 74 22 C7 84 24 B0 00 00 00 01 00 00 00 48 C7 84 24 B8 00 00 00 01 00 00 00 41 B8 01 00 00 00 E9 62 FA FF FF C7 84 24 A8 00 00 00 01 00 00 00 E9 E0 FE FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_14_0 {
	meta:
		name = "__bid64ddq_fma"
		size = 144
		refs = "0022 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 55 57 56 53 48 83 EC 58 49 8B 30 49 8B 78 08 48 8D 5C 24 40 48 89 D5 48 89 CA 48 89 D9 E8 ?? ?? ?? ?? 48 89 EA 48 89 D9 4C 8B 6C 24 40 4C 8B 74 24 48 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 D9 4C 89 6C 24 40 4C 89 74 24 48 48 89 74 24 20 48 89 7C 24 28 48 89 54 24 38 48 8D 54 24 30 48 89 44 24 30 E8 6B F2 FF FF 48 83 C4 58 5B 5E 5F 5D 41 5D 41 5E C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_15_0 {
	meta:
		name = "__bid64dqd_fma"
		size = 144
		refs = "0022 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 55 57 56 53 48 83 EC 58 48 8B 32 48 8B 7A 08 48 8D 5C 24 40 4C 89 C5 48 89 CA 48 89 D9 E8 ?? ?? ?? ?? 48 89 EA 48 89 D9 4C 8B 6C 24 40 4C 8B 74 24 48 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 D9 4C 89 6C 24 40 4C 89 74 24 48 48 89 74 24 30 48 89 7C 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 DB F1 FF FF 48 83 C4 58 5B 5E 5F 5D 41 5D 41 5E C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_16_0 {
	meta:
		name = "__bid64dqq_fma"
		size = 96
		refs = "0025 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 83 EC 50 4C 8B 2A 4C 8B 72 08 48 8D 5C 24 40 49 8B 30 49 8B 78 08 48 89 CA 48 89 D9 E8 ?? ?? ?? ?? 48 8D 54 24 30 4C 8D 44 24 20 48 89 D9 4C 89 6C 24 30 4C 89 74 24 38 48 89 74 24 20 48 89 7C 24 28 E8 71 F1 FF FF 48 83 C4 50 5B 5E 5F 41 5D 41 5E C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_33_17_0 {
	meta:
		name = "__bid64qdd_fma"
		size = 128
		refs = "001f __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 55 57 56 53 48 83 EC 58 4C 8B 29 4C 8B 71 08 48 8D 5C 24 40 4C 89 C5 48 89 D9 E8 ?? ?? ?? ?? 48 89 EA 48 89 D9 48 8B 74 24 40 48 8B 7C 24 48 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 D9 4C 89 6C 24 40 4C 89 74 24 48 48 89 74 24 30 48 89 7C 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 EE F0 FF FF 48 83 C4 58 5B 5E 5F 5D 41 5D 41 5E C3 90 }
	condition:
		$1
}

rule file_33_18_0 {
	meta:
		name = "__bid64qdq_fma"
		size = 112
		refs = "0022 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 83 EC 50 4C 8B 29 4C 8B 71 08 48 8D 5C 24 40 49 8B 30 49 8B 78 08 48 89 D9 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 D9 4C 89 6C 24 40 4C 89 74 24 48 48 89 74 24 20 48 89 7C 24 28 48 89 54 24 38 48 8D 54 24 30 48 89 44 24 30 E8 80 F0 FF FF 48 83 C4 50 5B 5E 5F 41 5D 41 5E C3 0F 1F 40 00 }
	condition:
		$1
}

rule file_33_19_0 {
	meta:
		name = "__bid64qqd_fma"
		size = 112
		refs = "0025 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 83 EC 50 4C 8B 29 4C 8B 71 08 48 8D 5C 24 40 48 8B 32 48 8B 7A 08 4C 89 C2 48 89 D9 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 D9 4C 89 6C 24 40 4C 89 74 24 48 48 89 74 24 30 48 89 7C 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 0D F0 FF FF 48 83 C4 50 5B 5E 5F 41 5D 41 5E C3 90 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__fixunsxfti"
		size = 528
		refs = "0016 .rdata 006c __floatuntixf"
	strings:
		$1 = { 57 56 48 83 EC 68 DB 29 D9 EE DF E9 0F 87 D3 01 00 00 D9 C0 D8 0D ?? ?? ?? ?? D9 05 ?? ?? ?? ?? D9 C9 DB E9 0F 83 B6 00 00 00 DD D9 D9 7C 24 3E 0F B7 44 24 3E 80 CC 0C 66 89 44 24 3C D9 6C 24 3C DF 7C 24 30 D9 6C 24 3E 48 8B 44 24 30 DB 7C 24 20 48 8D 4C 24 50 48 8D 54 24 40 31 F6 48 89 C7 48 89 74 24 40 48 89 44 24 48 E8 ?? ?? ?? ?? DB 6C 24 50 DB 6C 24 20 DE E1 D9 EE DF E9 0F 87 DC 00 00 00 D9 05 ?? ?? ?? ?? D9 C9 DB E9 0F 83 8C 00 00 00 DD D9 D9 7C 24 3E 0F B7 44 24 3E 80 CC 0C 66 89 44 24 3C D9 6C 24 3C DF 7C 24 30 D9 6C 24 3E 48 8B 44 24 30 49 89 C1 45 31 D2 49 01 F1 49 11 FA 4C 89 4C 24 20 4C 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 68 5E 5F C3 0F 1F 44 00 00 D9 7C 24 3E 0F B7 44 24 3E DE E1 48 BA 00 00 00 00 00 00 00 80 80 CC 0C 66 89 44 24 3C D9 6C 24 3C DF 7C 24 30 D9 6C 24 3E 48 8B 44 24 30 48 31 D0 E9 38 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 D9 7C 24 3E 0F B7 44 24 3E DE E1 48 BA 00 00 00 00 00 00 00 80 80 CC 0C 66 89 44 24 3C D9 6C 24 3C DF 7C 24 30 D9 6C 24 3E 48 8B 44 24 30 48 31 D0 E9 62 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 D9 E0 D9 05 ?? ?? ?? ?? D9 C9 DB E9 73 44 DD D9 D9 7C 24 3E 0F B7 44 24 3E 80 CC 0C 66 89 44 24 3C D9 6C 24 3C DF 7C 24 30 D9 6C 24 3E 48 8B 44 24 30 45 31 D2 48 29 C6 4C 19 D7 48 89 74 24 20 48 89 7C 24 28 66 0F 6F 44 24 20 48 83 C4 68 5E 5F C3 D9 7C 24 3E 0F B7 44 24 3E DE E1 48 BA 00 00 00 00 00 00 00 80 80 CC 0C 66 89 44 24 3C D9 6C 24 3C DF 7C 24 30 D9 6C 24 3E 48 8B 44 24 30 48 31 D0 EB AD DD D8 48 C7 44 24 20 00 00 00 00 48 C7 44 24 28 00 00 00 00 66 0F 6F 44 24 20 48 83 C4 68 5E 5F C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__addtf3"
		size = 4704
		refs = "0719 __sfp_handle_exceptions"
	strings:
		$1 = { 41 56 41 55 41 54 55 57 56 53 48 83 EC 60 0F 29 74 24 50 48 89 C8 66 0F 6F 02 C7 44 24 4C 00 00 00 00 66 41 0F 6F 08 0F 29 44 24 20 0F 29 4C 24 30 0F AE 5C 24 4C 48 BE FF FF FF FF FF FF 00 00 4C 8B 4C 24 28 4C 8B 74 24 38 48 8B 54 24 20 48 8B 7C 24 30 4D 89 CA 4D 89 C8 4D 89 F3 49 21 F2 49 C1 E8 30 4C 21 F6 4A 8D 0C D5 00 00 00 00 49 89 D2 49 C1 EB 30 49 C1 EA 3D 66 41 81 E0 FF 7F 49 C1 E9 3F 66 41 81 E3 FF 7F 49 09 CA 49 C1 EE 3F 48 8D 0C F5 00 00 00 00 48 89 FE 41 0F B7 E8 48 C1 EE 3D 44 89 CB 45 0F B7 EB 45 0F B6 C9 45 0F B6 E6 45 0F B7 C0 45 0F B7 DB 48 C1 E2 03 48 09 CE 48 C1 E7 03 45 29 D8 4D 39 E1 0F 84 6E 02 00 00 41 83 F8 00 0F 8E E4 04 00 00 4D 85 ED 75 21 48 89 F1 48 09 F9 0F 85 F3 02 00 00 48 81 FD FF 7F 00 00 0F 84 5B 03 00 00 45 31 DB E9 52 01 00 00 48 81 FD FF 7F 00 00 0F 84 46 03 00 00 48 B9 00 00 00 00 00 00 08 00 45 31 DB 48 09 CE 41 83 F8 74 0F 8F D7 05 00 00 41 83 F8 3F 0F 8F 0D 07 00 00 41 BC 40 00 00 00 48 89 F3 49 89 FE 45 29 C4 44 89 E1 48 D3 E3 44 89 C1 49 D3 EE 44 89 E1 48 D3 E7 4C 09 F3 31 C9 48 85 FF 0F 95 C1 48 09 CB 44 89 C1 48 D3 EE 48 29 DA 49 19 F2 48 B9 00 00 00 00 00 00 08 00 49 85 CA 0F 84 03 04 00 00 48 BB FF FF FF FF FF FF 07 00 4C 21 D3 48 85 DB 0F 84 39 05 00 00 4C 0F BD C3 41 83 F0 3F 41 8D 70 F4 83 FE 3F 0F 8F 3D 05 00 00 89 F1 48 89 D7 48 D3 E3 B9 4C 00 00 00 44 29 C1 49 89 DA 48 D3 EF 89 F1 49 09 FA 48 D3 E2 4C 63 C6 4C 39 C5 0F 8F 9E 03 00 00 29 EE 44 8D 46 01 41 83 F8 3F 0F 8F 1A 06 00 00 BB 40 00 00 00 48 89 D6 44 89 C1 44 29 C3 48 D3 EE 4C 89 D7 89 D9 48 D3 E7 89 D9 48 D3 E2 48 09 FE 44 89 C1 48 85 D2 0F 95 C2 49 D3 EA 31 ED 0F B6 D2 48 09 F2 48 89 D1 83 E1 07 48 85 C9 74 2E 8B 4C 24 4C 41 83 CB 20 81 E1 00 60 00 00 81 F9 00 20 00 00 0F 84 10 04 00 00 81 F9 00 40 00 00 0F 84 56 04 00 00 85 C9 0F 84 CC 03 00 00 48 B9 00 00 00 00 00 00 08 00 44 89 CB 4C 21 D1 83 E3 01 48 85 ED 0F 85 05 02 00 00 4C 89 D7 48 09 D7 74 11 41 F6 C3 20 75 07 F6 44 24 4D 08 74 04 41 83 CB 10 48 85 C9 0F 85 AE 02 00 00 4C 89 D1 48 C1 EA 03 49 C1 E2 0D 48 C1 E1 3D 49 C1 EA 10 45 31 C0 48 09 CA 0F 1F 44 00 00 48 C7 44 24 28 00 00 00 00 4D 89 D1 4C 8B 54 24 28 48 89 54 24 20 48 BA FF FF FF FF FF FF 00 00 41 81 E0 FF 7F 00 00 49 21 D1 48 BA 00 00 00 00 00 00 FF FF 49 C1 E0 30 49 21 D2 48 BA FF FF FF FF FF FF 00 80 0F B6 DB 4D 09 CA 48 B9 FF FF FF FF FF FF FF 7F 48 C1 E3 3F 4C 21 D2 4C 09 C2 48 21 CA 48 09 DA 45 85 DB 48 89 54 24 28 66 0F 6F 74 24 20 0F 85 E7 03 00 00 0F 29 30 0F 28 74 24 50 48 83 C4 60 5B 5E 5F 5D 41 5C 41 5D 41 5E C3 41 83 F8 00 0F 8E E6 03 00 00 4D 85 ED 0F 84 AD 00 00 00 48 81 FD FF 7F 00 00 0F 84 F5 00 00 00 48 B9 00 00 00 00 00 00 08 00 45 31 DB 48 09 CE 41 83 F8 74 0F 8E B6 05 00 00 31 DB 48 09 FE 0F 95 C3 31 F6 48 01 DA 49 11 F2 48 B9 00 00 00 00 00 00 08 00 49 85 CA 0F 84 E7 01 00 00 48 83 C5 01 48 81 FD FF 7F 00 00 0F 84 25 08 00 00 48 B9 FF FF FF FF FF FF F7 FF 49 21 CA 48 89 D1 48 D1 EA 83 E1 01 48 09 CA 4C 89 D1 49 D1 EA 48 C1 E1 3F 48 09 CA 48 89 D1 83 E1 07 E9 42 FE FF FF 90 41 83 E8 01 0F 85 C6 03 00 00 48 29 FA 49 19 F2 41 BB 02 00 00 00 E9 73 FD FF FF 0F 1F 44 00 00 48 89 F1 48 09 F9 0F 84 E1 FC FF FF 41 83 E8 01 0F 84 CA 05 00 00 48 81 FD FF 7F 00 00 41 BB 02 00 00 00 0F 85 47 FF FF FF 4C 89 D7 48 09 D7 0F 84 CA 00 00 00 48 B9 00 00 00 00 00 00 04 00 4C 21 D1 48 83 F9 01 45 19 DB 41 F7 D3 41 83 C3 03 E9 FF FD FF FF 4C 89 D7 48 09 D7 0F 84 2F 05 00 00 4D 89 D3 49 C1 EB 32 49 83 F3 01 41 83 E3 01 E9 DF FD FF FF 48 85 C9 0F 84 86 00 00 00 4C 8D 45 01 49 81 F8 FF 7F 00 00 0F 85 B7 00 00 00 8B 4C 24 4C 81 E1 00 60 00 00 0F 84 F1 02 00 00 81 F9 00 40 00 00 0F 84 58 06 00 00 81 F9 00 20 00 00 0F 84 3A 05 00 00 41 B8 FE 7F 00 00 48 C7 C2 FF FF FF FF 49 BA FF FF FF FF FF FF FF 1F BD FE 7F 00 00 E9 C8 02 00 00 49 81 FD FF 7F 00 00 41 BB 02 00 00 00 0F 85 AE 03 00 00 48 89 F3 48 09 FB 0F 85 33 0D 00 00 44 89 F3 BD FF 7F 00 00 45 31 D2 31 D2 4C 89 D1 48 C1 EA 03 41 89 E8 48 C1 E1 3D 49 C1 EA 03 66 41 81 E0 FF 7F 48 09 CA 48 81 FD FF 7F 00 00 74 68 49 B9 FF FF FF FF FF FF 00 00 4D 21 CA E9 76 FD FF FF 66 0F 1F 44 00 00 41 B8 01 00 00 00 49 B9 FF FF FF FF FF FF F7 FF 48 C1 EA 03 66 41 81 E0 FF 7F 4D 21 CA 4C 89 D1 49 C1 E2 0D 48 C1 E1 3D 49 C1 EA 10 48 09 CA E9 3C FD FF FF 48 B9 FF FF FF FF FF FF F7 FF 4C 29 C5 49 21 CA 48 89 D1 83 E1 07 E9 92 FC FF FF 90 48 89 D7 4C 09 D7 74 78 49 B9 00 00 00 00 00 80 00 00 48 B9 FF FF FF FF FF FF 00 00 4D 09 CA 49 21 CA E9 F9 FC FF FF 66 0F 1F 84 00 00 00 00 00 0F 85 AA 02 00 00 48 8D 4D 01 81 E1 FF 7F 00 00 48 83 F9 01 0F 8E 88 04 00 00 49 B8 00 00 00 00 00 00 08 00 4C 89 D3 48 89 D1 48 29 F9 48 19 F3 4C 85 C3 0F 84 07 03 00 00 48 89 F3 4D 89 E1 45 31 DB 48 29 D7 4C 19 D3 48 89 FA E9 7E FB FF FF 45 31 D2 31 D2 E9 96 FC FF FF 66 0F 1F 44 00 00 48 89 D1 83 E1 0F 48 83 F9 04 0F 84 24 FC FF FF 48 B9 00 00 00 00 00 00 08 00 44 89 CB 48 83 C2 04 49 83 D2 00 83 E3 01 4C 21 D1 E9 17 FC FF FF 4D 85 C9 0F 84 8A 01 00 00 48 83 C2 08 49 83 D2 00 E9 EE FB FF FF 81 FA 00 40 00 00 0F 84 E7 0A 00 00 81 FA 00 20 00 00 0F 84 4A 01 00 00 81 FA 00 40 00 00 41 BB 28 00 00 00 0F 85 03 FE FF FF 49 83 CA FF BD FE 7F 00 00 41 BB 28 00 00 00 4C 89 D2 4D 85 C9 0F 85 A9 FB FF FF 48 B9 00 00 00 00 00 00 08 00 31 DB 48 83 C2 08 49 83 D2 00 4C 21 D1 E9 A0 FB FF FF 66 0F 1F 84 00 00 00 00 00 4C 0F BD C2 49 83 F0 3F 41 83 C0 40 41 8D 70 F4 83 FE 3F 0F 8E C3 FA FF FF 41 8D 48 B4 48 D3 E2 49 89 D2 31 D2 E9 D0 FA FF FF 66 0F 1F 44 00 00 31 DB 48 09 FE 0F 95 C3 31 F6 E9 59 FA FF FF 90 44 89 D9 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 E9 02 FC FF FF 66 0F 1F 84 00 00 00 00 00 0F 85 9A 03 00 00 4C 8D 45 01 4C 89 C1 81 E1 FF 7F 00 00 48 83 F9 01 0F 8E E3 02 00 00 48 01 FA 49 11 F2 49 81 F8 FF 7F 00 00 0F 84 30 05 00 00 49 89 D3 4C 89 D1 83 E2 01 49 D1 EB 48 C1 E1 3F 49 D1 EA 4C 09 D9 4C 89 C5 45 31 DB 48 09 CA 48 89 D1 83 E1 07 E9 97 FA FF FF 66 0F 1F 44 00 00 41 B8 FF 7F 00 00 31 D2 45 31 D2 BD FF 7F 00 00 41 83 CB 28 E9 76 FD FF FF 0F 1F 80 00 00 00 00 48 81 FD FF 7F 00 00 41 BB 02 00 00 00 0F 85 5C F9 FF FF E9 61 FC FF FF 4D 85 C9 0F 85 33 0A 00 00 48 83 CA FF BD FE 7F 00 00 41 BB 28 00 00 00 49 89 D2 48 B9 00 00 00 00 00 00 08 00 31 DB 45 31 C9 4C 21 D1 E9 6D FA FF FF 66 0F 1F 44 00 00 41 8D 48 C0 4C 89 D3 48 D3 EB 31 C9 41 83 F8 40 74 0B B1 80 44 29 C1 49 D3 E2 4C 89 D1 48 09 D1 0F 95 C2 45 31 D2 31 ED 0F B6 D2 48 09 DA 48 89 D1 83 E1 07 E9 E8 F9 FF FF 0F 1F 80 00 00 00 00 41 8D 48 C0 48 89 F3 48 D3 EB 31 C9 41 83 F8 40 74 0B B1 80 44 29 C1 48 D3 E6 48 89 F1 48 09 F9 0F 95 C1 31 F6 0F B6 C9 48 09 CB E9 F8 F8 FF FF 48 85 ED 0F 84 27 01 00 00 49 81 FD FF 7F 00 00 0F 84 EE 00 00 00 48 B9 00 00 00 00 00 00 08 00 41 F7 D8 45 31 DB 49 09 CA 41 83 F8 74 0F 8F AD 03 00 00 41 83 F8 3F 0F 8F 43 05 00 00 BB 40 00 00 00 4D 89 D1 49 89 D6 44 29 C3 89 D9 49 D3 E1 44 89 C1 49 D3 EE 89 D9 48 D3 E2 4D 09 F1 44 89 C1 48 85 D2 0F 95 C2 49 D3 EA 0F B6 D2 4C 89 D1 49 09 D1 49 89 F2 48 89 FA 4C 89 ED 4C 29 CA 49 19 CA 4D 89 E1 E9 74 F8 FF FF 66 0F 1F 44 00 00 48 89 CF 48 09 DF 0F 85 C4 00 00 00 8B 54 24 4C 81 E2 00 60 00 00 81 FA 00 20 00 00 0F 94 C3 45 31 D2 45 31 DB 31 C9 31 D2 E9 42 F9 FF FF 66 90 41 83 F8 3F 0F 8F 66 01 00 00 41 BC 40 00 00 00 48 89 F3 49 89 FE 45 29 C4 44 89 E1 48 D3 E3 44 89 C1 49 D3 EE 44 89 E1 48 D3 E7 4C 09 F3 31 C9 48 85 FF 0F 95 C1 48 09 CB 44 89 C1 48 D3 EE E9 10 FA FF FF 48 89 F3 48 09 FB 0F 85 45 06 00 00 44 89 F3 BD FF 7F 00 00 0F 1F 84 00 00 00 00 00 45 31 D2 45 31 DB 31 D2 E9 67 FB FF FF 0F 1F 00 4C 89 D3 48 09 D3 0F 85 74 02 00 00 49 81 FD FF 7F 00 00 74 BF 49 89 F2 48 89 FA 4C 89 ED 4D 89 E1 45 31 DB E9 8B F8 FF FF 0F 1F 80 00 00 00 00 48 89 CA 45 31 DB E9 B3 F7 FF FF 0F 1F 44 00 00 48 01 FA 49 11 F2 41 BB 02 00 00 00 E9 99 F9 FF FF 49 83 F9 01 B9 00 00 00 00 49 BA FF FF FF FF FF FF FF 1F 45 19 C0 66 41 81 C0 FF 7F 49 83 F9 01 48 19 D2 4D 85 C9 4C 0F 45 D1 48 8D AA FF 7F 00 00 E9 79 FD FF FF 66 0F 1F 84 00 00 00 00 00 48 85 ED 0F 85 77 03 00 00 4C 89 D1 48 09 D1 0F 85 F8 04 00 00 48 89 F1 48 09 F9 0F 84 CE FE FF FF 49 89 F2 48 89 FA 41 BB 02 00 00 00 E9 F2 F7 FF FF 48 85 ED 0F 85 D5 00 00 00 4C 89 D3 48 09 D3 48 89 F3 0F 85 C4 02 00 00 48 09 FB 0F 84 89 FE FF FF 49 89 F2 48 89 FA 4D 89 E1 41 BB 02 00 00 00 E9 BD F7 FF FF 66 0F 1F 84 00 00 00 00 00 41 8D 48 C0 48 89 F3 48 D3 EB 31 C9 41 83 F8 40 74 0B B1 80 44 29 C1 48 D3 E6 48 89 F1 48 09 F9 0F 95 C1 31 F6 0F B6 C9 48 09 CB E9 B4 F8 FF FF 48 85 ED 0F 85 E7 01 00 00 4C 89 D1 48 09 D1 0F 85 CD 03 00 00 49 81 FD FF 7F 00 00 0F 84 D6 05 00 00 49 89 F2 48 89 FA 4C 89 ED 45 31 DB E9 51 F7 FF FF 45 89 C8 4C 89 CA B9 00 00 00 00 41 F7 D8 48 F7 DA 49 BA FF FF FF FF FF FF FF 1F 66 41 81 C0 FF 7F 4D 85 C9 48 8D AA FF 7F 00 00 4C 0F 44 D1 E9 69 FC FF FF 66 0F 1F 84 00 00 00 00 00 48 81 FD FF 7F 00 00 0F 84 0A 03 00 00 49 81 FD FF 7F 00 00 0F 84 C6 02 00 00 4C 89 D3 48 09 D3 0F 84 FB 00 00 00 45 31 DB 48 89 F3 48 09 FB 0F 84 31 02 00 00 4C 89 D1 48 C1 EA 03 49 C1 EA 03 48 C1 E1 3D 48 09 CA 48 89 F1 48 C1 E9 03 49 39 CA 77 24 48 C1 E6 3D 48 C1 EF 03 48 09 FE 49 39 CA 41 0F 94 C0 48 39 F2 0F 86 E2 05 00 00 45 84 C0 0F 84 D9 05 00 00 48 89 D1 49 C1 E2 03 48 C1 E2 03 48 C1 E9 3D BD FF 7F 00 00 49 09 CA E9 81 F6 FF FF 8B 4C 24 4C 81 E1 00 60 00 00 0F 84 A3 01 00 00 81 F9 00 40 00 00 0F 84 42 04 00 00 81 F9 00 20 00 00 0F 84 AA 04 00 00 B9 07 00 00 00 48 C7 C2 FF FF FF FF BD FE 7F 00 00 41 83 CB 28 49 89 D2 E9 09 F6 FF FF 0F 1F 84 00 00 00 00 00 41 83 F0 FF 0F 85 AE F8 FF FF 48 29 D7 4C 19 D6 4C 89 ED 48 89 FA 49 89 F2 4D 89 E1 41 BB 02 00 00 00 E9 27 F5 FF FF 66 0F 1F 84 00 00 00 00 00 45 31 C9 49 09 D2 41 0F 95 C1 31 C9 E9 82 FC FF FF 48 89 F2 48 09 FA 48 85 D2 0F 84 15 03 00 00 45 31 DB 49 89 F2 48 89 FA 4D 89 E1 BD FF 7F 00 00 E9 CE F5 FF FF 66 2E 0F 1F 84 00 00 00 00 00 8B 4C 24 4C 89 CA 81 E2 00 60 00 00 0F 85 C4 F9 FF FF BD FF 7F 00 00 45 31 D2 41 BB 28 00 00 00 31 D2 E9 4D F8 FF FF 66 0F 1F 84 00 00 00 00 00 49 81 FD FF 7F 00 00 0F 84 FB 03 00 00 48 B9 00 00 00 00 00 00 08 00 41 F7 D8 45 31 DB 49 09 CA 41 83 F8 74 0F 8F E9 01 00 00 41 83 F8 3F 0F 8F 81 03 00 00 BD 40 00 00 00 4C 89 D3 49 89 D6 44 29 C5 89 E9 48 D3 E3 44 89 C1 49 D3 EE 89 E9 48 D3 E2 4C 09 F3 44 89 C1 48 85 D2 0F 95 C2 49 D3 EA 0F B6 D2 4C 89 D1 48 09 D3 49 89 F2 48 89 FA 4C 89 ED 48 01 DA 49 11 CA E9 4C F6 FF FF 48 09 FB 0F 84 9E 00 00 00 48 B9 00 00 00 00 00 00 08 00 4D 89 D0 49 89 D3 49 29 FB 49 19 F0 49 85 C8 0F 84 EC 02 00 00 48 29 D7 4C 19 D6 48 89 F9 49 89 F2 48 89 FA 83 E1 07 4D 89 E1 41 BB 02 00 00 00 E9 9B F4 FF FF 31 C9 31 D2 E9 7D FE FF FF 48 89 F3 48 09 FB 0F 85 F0 03 00 00 4C 89 D3 48 09 D3 74 2F 45 31 DB BD FF 7F 00 00 E9 A4 F4 FF FF 48 81 FD FF 7F 00 00 0F 84 36 03 00 00 49 81 FD FF 7F 00 00 74 C9 4C 89 D3 48 09 D3 0F 85 10 01 00 00 49 89 F2 48 89 FA BD FF 7F 00 00 45 31 DB E9 6F F4 FF FF 41 BB 02 00 00 00 E9 64 F4 FF FF 41 8D 48 C0 4D 89 D1 49 D3 E9 31 C9 41 83 F8 40 74 0B B1 80 44 29 C1 49 D3 E2 4C 89 D1 48 09 D1 0F 95 C2 31 C9 0F B6 D2 49 09 D1 E9 C3 FA FF FF 48 89 F3 48 09 FB 0F 85 91 01 00 00 4C 89 D7 48 09 D7 0F 85 6B FF FF FF BD FF 7F 00 00 BB 01 00 00 00 49 BA 00 00 00 00 00 00 04 00 41 BB 01 00 00 00 E9 AB F6 FF FF 4C 89 D3 48 09 D3 0F 84 41 01 00 00 4D 89 D3 49 C1 EB 32 49 83 F3 01 41 83 E3 01 49 81 FD FF 7F 00 00 0F 85 EA FC FF FF 48 89 F3 48 09 FB 0F 84 1B FF FF FF 48 B9 00 00 00 00 00 00 04 00 4C 89 D3 48 85 CE B9 01 00 00 00 44 0F 44 D9 48 09 D3 0F 84 C6 FD FF FF E9 C3 FC FF FF 41 83 F0 FF 0F 85 2B 01 00 00 48 01 D7 49 11 F2 4C 89 ED 48 89 FA 41 BB 02 00 00 00 E9 B7 F4 FF FF 31 DB 49 09 D2 0F 95 C3 31 C9 E9 48 FE FF FF 45 31 DB 48 89 F3 48 09 FB 0F 84 B5 FE FF FF 4C 89 D1 49 89 F0 48 C1 EA 03 48 C1 E1 3D 49 C1 EA 03 49 C1 E8 03 48 09 CA 4D 39 C2 0F 87 A4 FC FF FF 48 C1 E6 3D 48 C1 EF 03 48 89 F1 48 09 F9 48 39 CA 76 0C 4D 39 C2 4D 89 C2 0F 84 85 FC FF FF 4D 89 C2 48 89 CA E9 7A FC FF FF 48 89 F3 48 09 FB 0F 84 9C FE FF FF 48 B9 00 00 00 00 00 00 08 00 48 01 FA 49 11 F2 49 85 CA 0F 84 7C 02 00 00 48 B9 FF FF FF FF FF FF F7 FF BD 01 00 00 00 41 BB 02 00 00 00 49 21 CA 48 89 D1 83 E1 07 E9 9C F2 FF FF BB 01 00 00 00 49 BA 00 00 00 00 00 00 04 00 BD FF 7F 00 00 41 BB 01 00 00 00 E9 5E F5 FF FF 49 81 FD FF 7F 00 00 0F 85 B0 FC FF FF 48 89 F3 48 09 FB 0F 84 80 FE FF FF 45 31 DB E9 C6 FE FF FF 49 89 F3 49 89 F2 48 89 FA 49 C1 EB 32 BD FF 7F 00 00 4D 89 E1 49 83 F3 01 41 83 E3 01 E9 6D F2 FF FF 49 81 FD FF 7F 00 00 41 BB 02 00 00 00 0F 85 E6 FC FF FF 48 89 F1 48 09 F9 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__netf2"
		size = 320
		refs = "00d3 __sfp_handle_exceptions"
	strings:
		$1 = { 56 53 48 83 EC 58 66 0F 6F 01 C7 44 24 4C 00 00 00 00 66 0F 6F 0A 0F 29 44 24 20 0F 29 4C 24 30 0F AE 5C 24 4C 49 B8 FF FF FF FF FF FF 00 00 4D 89 C2 48 8B 44 24 28 48 8B 5C 24 20 48 8B 74 24 30 49 89 C3 48 89 C2 48 C1 E8 3F 48 89 C1 48 8B 44 24 38 48 C1 EA 30 81 E2 FF 7F 00 00 4D 21 C3 49 89 C1 49 21 C2 48 C1 E8 3F 49 C1 E9 30 49 89 C0 41 81 E1 FF 7F 00 00 48 81 FA FF 7F 00 00 74 30 49 81 F9 FF 7F 00 00 74 59 4C 39 CA 0F 84 7D 00 00 00 48 81 FA FF 7F 00 00 74 1D 49 81 F9 FF 7F 00 00 B8 01 00 00 00 74 4A 48 83 C4 58 5B 5E C3 4C 89 D8 48 09 D8 74 C8 4C 09 DB 74 DE 48 B8 00 00 00 00 00 80 00 00 49 85 C3 75 CF B9 01 00 00 00 E8 ?? ?? ?? ?? B8 01 00 00 00 48 83 C4 58 5B 5E C3 4C 89 D0 48 09 F0 74 9F 48 81 FA FF 7F 00 00 74 C5 4C 09 D6 B8 01 00 00 00 74 AC 48 BA 00 00 00 00 00 80 00 00 49 85 D2 74 C0 EB 9B 90 4D 39 D3 0F 85 7A FF FF FF 48 39 F3 0F 85 71 FF FF FF 31 C0 44 38 C1 74 81 48 85 D2 0F 85 61 FF FF FF 31 C0 49 09 DB 0F 95 C0 E9 6B FF FF FF 90 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__bid_extendddtd2"
		size = 48
		refs = "000e __bid64_to_bid128"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 8B 54 24 28 48 89 03 48 89 D8 48 89 53 08 48 83 C4 30 5B C3 90 90 90 90 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "__bid_extenddftd"
		size = 48
		refs = "000e __binary64_to_bid128"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 8B 54 24 28 48 89 03 48 89 D8 48 89 53 08 48 83 C4 30 5B C3 90 90 90 90 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__bid_extendsdtd2"
		size = 48
		refs = "000e __bid32_to_bid128"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 8B 54 24 28 48 89 03 48 89 D8 48 89 53 08 48 83 C4 30 5B C3 90 90 90 90 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "__bid_extendsftd"
		size = 48
		refs = "000e __binary32_to_bid128"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 8B 54 24 28 48 89 03 48 89 D8 48 89 53 08 48 83 C4 30 5B C3 90 90 90 90 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__bid_floatditd"
		size = 48
		refs = "000e __bid128_from_int64"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 8B 54 24 28 48 89 03 48 89 D8 48 89 53 08 48 83 C4 30 5B C3 90 90 90 90 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__bid_floatsitd"
		size = 48
		refs = "000e __bid128_from_int32"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 8B 54 24 28 48 89 03 48 89 D8 48 89 53 08 48 83 C4 30 5B C3 90 90 90 90 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "__bid_floatunsditd"
		size = 48
		refs = "000e __bid128_from_uint64"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 8B 54 24 28 48 89 03 48 89 D8 48 89 53 08 48 83 C4 30 5B C3 90 90 90 90 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__bid_floatunssitd"
		size = 48
		refs = "000e __bid128_from_uint32"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 8B 54 24 28 48 89 03 48 89 D8 48 89 53 08 48 83 C4 30 5B C3 90 90 90 90 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__powixf2"
		size = 96
		refs = "0056 .rdata"
	strings:
		$1 = { 48 89 C8 44 89 C1 C1 F9 1F DB 2A 89 CA 44 31 C2 29 CA F6 C2 01 74 39 D9 C0 EB 07 0F 1F 44 00 00 D9 C9 D1 EA 74 1A D9 C9 F6 C2 01 D8 C8 74 F1 D1 EA DC C9 75 F3 DD D8 EB 09 0F 1F 80 00 00 00 00 DD D9 45 85 C0 78 0D DB 38 C3 66 0F 1F 44 00 00 D9 E8 EB CE D8 3D ?? ?? ?? ?? DB 38 C3 90 90 90 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__bid64_to_bid128"
		size = 528
		refs = "0100 .refptr.__bid_power10_table_128 01e5 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 80 48 89 C8 49 89 D1 48 B9 00 00 00 00 00 00 00 60 4D 89 C3 49 21 C9 49 21 D3 49 39 C9 0F 84 52 01 00 00 49 89 D1 49 BA FF FF FF FF FF FF 1F 00 49 C1 E9 35 49 21 D2 45 89 C8 41 81 E0 FF 03 00 00 4D 85 D2 74 7F 41 81 C0 92 16 00 00 4C 89 10 49 C1 E0 31 4D 09 D8 4C 89 40 08 5B 5E C3 0F 1F 80 00 00 00 00 48 B9 FF FF FF FF FF FF 03 00 49 BA FF FF FF FF FF FF 03 FE 49 B8 FF 7F C6 A4 7E 8D 03 00 48 21 D1 49 21 D2 4C 39 C1 76 0D 49 BA 00 00 00 00 00 00 00 FE 49 21 D2 48 B9 00 00 00 00 00 00 00 7C 49 B8 00 00 00 00 00 00 00 78 48 21 D1 4C 39 C1 0F 84 2B 01 00 00 45 31 C0 0F 1F 80 00 00 00 00 4C 8D 0C 12 48 B9 FF FF FF FF FF FF FF EF 49 39 C9 0F 86 6A FF FF FF 48 B9 00 00 00 00 00 00 00 7E 48 21 CA 48 39 CA 0F 84 E5 00 00 00 48 8B 15 ?? ?? ?? ?? 4D 89 D0 44 89 D6 49 C1 E0 0E 49 C1 E8 2E 48 8B 92 20 01 00 00 4C 89 C3 4D 89 C3 49 89 D1 89 D2 48 0F AF DA 49 C1 E9 20 48 0F AF D6 4D 0F AF D9 41 89 D8 48 C1 EB 20 48 89 D1 89 D2 4C 0F AF CE 48 C1 E9 20 49 01 C9 4B 8D 0C 01 49 89 C8 48 C1 E9 20 49 C1 E0 20 4C 01 C2 48 89 10 48 89 DA 4C 01 DA 48 01 D1 48 BA 00 00 00 00 00 00 00 FC 49 21 D2 4C 09 D1 48 89 48 08 5B 5E C3 48 B9 00 00 00 00 00 00 00 78 49 89 D0 49 21 C8 49 39 C8 0F 84 D7 FE FF FF 49 BA FF FF FF FF FF FF 07 00 49 89 D1 4C 89 D1 49 BA 00 00 00 00 00 00 20 00 48 21 D1 49 09 CA 48 B9 FF FF C0 6F F2 86 23 00 49 39 CA B9 00 00 00 00 4C 0F 47 D1 49 C1 E9 33 45 89 C8 41 81 E0 FF 03 00 00 E9 6A FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 01 E9 0C FF FF FF 49 BA 00 00 00 00 00 00 00 F8 45 31 C0 49 21 D2 E9 CA FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "__bid128_to_bid64"
		size = 3552
		refs = "0052 .refptr.__bid_power10_table_128 0103 .refptr.__bid_reciprocals10_128 027c .refptr.__bid_recip_scale 030e .refptr.__bid_IDEC_glbround 0375 .refptr.__bid_IDEC_glbflags 03d6 .rdata 03f0 .refptr.__bid_estimate_decimal_digits 0412 .refptr.__bid_power10_index_binexp_128 0475 .refptr.__bid_round_const_table_128 0831 .refptr.__bid_round_const_table"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 4C 8B 41 08 48 8B 11 48 B8 00 00 00 00 00 00 00 78 49 BA 00 00 00 00 00 00 00 80 49 B9 FF FF FF FF FF FF FF 5F 4C 89 C1 4D 21 C2 48 89 D3 48 21 C1 4C 39 C9 76 6A 48 39 C1 0F 85 65 09 00 00 48 8B 15 ?? ?? ?? ?? 48 B8 FF FF FF FF FF 3F 00 00 4C 21 C0 48 39 82 18 02 00 00 48 8B 8A 10 02 00 00 0F 83 99 0B 00 00 49 B9 00 00 00 00 00 00 00 FE 31 DB 4D 21 C1 48 B8 00 00 00 00 00 00 00 7C 48 BA 00 00 00 00 00 00 00 78 4C 21 C0 48 39 D0 0F 84 1E 0A 00 00 31 C0 EB 3F 66 0F 1F 44 00 00 4C 8B 0D ?? ?? ?? ?? 49 BB FF FF FF FF FF FF 01 00 4D 21 C3 4D 3B 99 28 02 00 00 49 8B 81 20 02 00 00 0F 86 F9 01 00 00 4C 89 C0 45 31 C9 31 DB 48 C1 E8 31 25 FF 3F 00 00 4B 8D 0C 00 48 BA FF FF FF FF FF FF FF EF 48 39 D1 0F 86 90 08 00 00 48 8B 05 ?? ?? ?? ?? 48 89 DD 41 89 DA 48 C1 ED 20 49 89 EC 48 8B 88 28 01 00 00 4C 8B A8 20 01 00 00 4C 89 D0 49 89 CB 89 C9 4C 89 EB 4C 0F AF E1 49 C1 EB 20 48 C1 EB 20 48 0F AF C1 45 89 ED 44 89 E2 48 89 44 24 08 48 C1 E8 20 48 01 D0 4C 89 D2 49 0F AF D3 48 8D 3C 10 4C 89 CA 44 89 C8 48 C1 E2 12 48 89 C6 48 89 7C 24 10 48 89 D7 48 89 C2 48 C1 EF 32 48 0F AF F3 49 89 FE 49 0F AF D5 4D 0F AF F5 41 89 F7 4D 01 FE 49 89 D7 89 D2 49 C1 EF 20 4D 01 F7 4D 89 FE 4C 89 7C 24 18 49 C1 E6 20 4C 01 F2 49 89 EE 48 89 54 24 20 48 89 EA 49 0F AF D5 4D 0F AF EA 4C 0F AF D3 41 89 D7 48 C1 EA 20 49 C1 ED 20 4D 01 FD 4D 01 D5 49 89 FA 4C 0F AF D1 49 C1 ED 20 48 0F AF C8 4C 0F AF F3 49 89 CF 89 C9 49 0F AF C3 49 01 D6 49 C1 EF 20 4B 8D 14 2E 49 89 FD 45 89 D6 4D 0F AF EB 4C 01 F8 49 C1 EA 20 49 C1 EC 20 49 01 C6 48 C1 EE 20 48 0F AF DF 48 8B 7C 24 10 4D 01 D5 4C 0F AF DD 4D 89 F2 49 C1 E6 20 4C 01 F1 4C 8B 74 24 18 49 C1 EA 20 4D 01 D5 44 8B 54 24 08 49 01 DC 4D 01 E3 49 C1 EE 20 49 01 F3 48 89 FE 48 C1 EE 20 49 01 F3 4B 8D 04 33 49 89 FE 49 C1 E6 20 4D 01 D6 4C 03 74 24 20 48 83 D0 00 49 01 D6 BA 40 00 00 00 48 83 D0 00 48 01 C1 48 8B 05 ?? ?? ?? ?? 49 89 CE 49 83 D5 00 8B 48 48 48 B8 00 00 00 00 00 00 00 FC 4C 21 C8 29 CA 49 D3 EE 89 D1 48 BA 00 00 00 00 00 00 00 7E 4C 09 F0 49 D3 E5 49 21 D0 4C 09 E8 49 39 D0 0F 84 46 07 00 00 0F 1F 00 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 84 5D 07 00 00 4C 89 C0 4C 89 DE 48 C1 E8 31 25 FF 3F 00 00 48 09 D6 0F 84 E1 0A 00 00 4D 85 DB 0F 85 C8 00 00 00 48 B9 FF FF C0 6F F2 86 23 00 48 39 CA 0F 87 BB 00 00 00 48 8B 15 ?? ?? ?? ?? 2D 92 16 00 00 44 8B 02 3D FF 02 00 00 0F 86 1D 07 00 00 85 C0 0F 88 D7 04 00 00 3D FF 02 00 00 7E 33 48 BA FF 7F C6 A4 7E 8D 03 00 48 39 D3 48 89 D1 76 11 EB 1F 0F 1F 84 00 00 00 00 00 3D FF 02 00 00 7E 10 48 8D 14 1B 83 E8 01 48 8D 1C DA 48 39 CB 76 E9 3D FF 02 00 00 0F 8E D0 06 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 48 B8 00 00 00 00 00 00 00 78 4C 09 D0 41 83 F8 02 0F 84 8E 09 00 00 41 83 F8 03 0F 84 C3 08 00 00 41 83 F8 01 0F 85 19 FF FF FF 4D 85 D2 48 BA FF FF C0 6F F2 86 FB 77 48 0F 44 C2 E9 03 FF FF FF 0F 1F 00 0F 88 4C 06 00 00 66 0F EF D2 F3 49 0F 2A D3 48 85 D2 F3 0F 59 15 ?? ?? ?? ?? 0F 88 50 07 00 00 66 0F EF C0 F3 48 0F 2A C2 F3 0F 58 D0 4C 8B 05 ?? ?? ?? ?? 4C 89 DE 66 0F 7E D1 C1 E9 17 0F B6 C9 83 E9 7F 48 63 C9 41 8B 1C 88 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 44 8D 43 F0 48 2B 71 08 48 83 FE 00 0F 8E B8 06 00 00 44 8D 43 F1 48 8B 0D ?? ?? ?? ?? 41 8D 3C 00 4D 85 D2 89 7C 24 08 8B 39 89 7C 24 18 41 89 FC 74 17 8D 4F FF 83 F9 01 77 0F 41 BC 03 00 00 00 41 29 FC 66 0F 1F 44 00 00 81 7C 24 08 91 16 00 00 0F 8E 62 05 00 00 8B 44 24 08 48 8B 35 ?? ?? ?? ?? 44 89 E3 C7 44 24 54 00 00 00 00 2D 92 16 00 00 48 8D 0C DB 49 63 F8 45 31 C9 48 89 7C 24 20 48 8D 0C 8F 48 C1 E1 04 48 01 F1 48 8B 35 ?? ?? ?? ?? 4C 03 59 08 48 03 11 48 89 F9 48 89 74 24 58 41 0F 92 C1 48 C1 E1 04 48 89 D5 48 01 F1 48 C1 ED 20 4D 01 CB 4C 8B 01 48 8B 49 08 48 89 EB 48 89 EE 89 D2 4D 89 DD 49 89 D7 45 89 DB 49 C1 ED 20 49 89 C9 89 C9 4D 89 C6 49 C1 E9 20 49 C1 EE 20 45 89 C0 49 0F AF D9 48 0F AF F1 4D 0F AF F9 48 89 5C 24 28 48 89 D3 48 89 74 24 10 8B 74 24 10 48 0F AF D9 48 89 5C 24 30 48 C1 EB 20 48 01 F3 4E 8D 3C 3B 4C 89 F3 4D 89 DE 4C 0F AF F3 4C 89 7C 24 38 4C 89 F6 4D 89 DE 4D 0F AF F0 41 89 F7 4C 89 F7 49 C1 EE 20 4D 01 FE 4D 89 EF 89 FF 4D 0F AF F8 4D 01 FE 4C 89 74 24 40 49 C1 E6 20 4D 8D 3C 3E 48 89 EF 49 0F AF F8 4C 0F AF C2 4C 89 7C 24 48 48 0F AF D3 41 89 FF 48 C1 EF 20 4D 89 C6 45 89 C0 48 0F AF EB 49 C1 EE 20 4D 01 FE 49 01 D6 4C 89 F2 49 C1 E6 20 48 01 FD 48 C1 EA 20 4C 89 EF 4C 8D 7C 15 00 4C 89 EA 4D 01 C6 48 0F AF D1 49 0F AF F9 48 C1 EE 20 49 0F AF CB 89 D5 48 C1 EA 20 48 01 D7 48 8B 54 24 10 4D 0F AF CB 49 89 C8 89 C9 49 C1 E8 20 49 01 E8 48 C1 EA 20 48 8B 6C 24 38 48 03 54 24 28 49 0F AF DD 4D 01 C8 4D 89 C3 49 C1 E0 20 4D 8D 0C 08 49 89 E8 49 C1 EB 20 49 C1 E8 20 49 01 FB 48 8B 4C 24 20 48 01 DA 4C 01 C2 4C 8B 44 24 40 48 01 F2 48 89 EE 48 C1 E6 20 48 89 F3 8B 74 24 30 49 C1 E8 20 49 01 D0 48 8B 15 ?? ?? ?? ?? 48 8D 2C 33 48 03 6C 24 48 49 83 D0 00 4C 01 FD 49 83 D0 00 4D 01 C8 44 8B 0C 8A 49 83 D3 00 41 83 F9 3F 0F 8E 14 04 00 00 41 8D 49 C0 4C 89 DB 48 D3 EB BE 80 00 00 00 44 29 CE 45 85 E4 75 4D F6 C3 01 74 48 83 FE 3F 0F 8E 9F 05 00 00 B9 40 00 00 00 4C 89 C2 44 29 C9 48 D3 E2 48 85 D2 0F 85 06 04 00 00 48 8B 54 24 20 48 C1 E2 04 48 03 54 24 58 48 3B 6A 08 72 07 75 12 4C 3B 32 73 0D 48 83 EB 01 66 0F 1F 84 00 00 00 00 00 83 FE 3F 0F 8F C7 03 00 00 89 F1 4C 89 DA 4D 89 C5 48 D3 E2 41 8D 49 C0 4C 89 C7 49 D3 ED 89 F1 48 D3 E7 4C 09 EA 41 83 FC 01 0F 84 85 04 00 00 0F 82 6A 05 00 00 41 83 FC 03 0F 84 75 04 00 00 41 83 FC 04 0F 84 56 05 00 00 48 8B 4C 24 20 45 31 DB 48 C1 E1 04 48 03 4C 24 58 4C 03 31 41 0F 92 C3 4C 01 DD 49 89 EF 4C 03 79 08 41 0F 92 C0 49 39 EB 0F 97 C1 41 09 C8 83 FE 3F 45 0F B6 C0 0F 8F 1A 04 00 00 41 8D 49 C0 49 89 D3 49 D3 E3 89 F1 48 D3 EF 48 89 F9 4C 89 DF 48 09 CF 89 F1 48 D3 EA 41 83 F9 3F 0F 8F D8 03 00 00 BE 01 00 00 00 B9 40 00 00 00 44 29 C9 49 89 F3 49 D3 EB 44 89 C9 48 D3 E6 4C 01 C7 48 83 D2 00 49 39 D3 72 24 75 0C 48 39 FE 76 1D 0F 1F 80 00 00 00 00 83 7C 24 54 01 48 8B 0D ?? ?? ?? ?? 19 D2 83 E2 F0 83 C2 30 09 11 48 BA FF FF C0 6F F2 86 23 00 44 8B 44 24 18 48 39 D3 0F 86 3C FB FF FF 8B 44 24 08 48 BB 00 80 C6 A4 7E 8D 03 00 2D 91 16 00 00 3D FF 02 00 00 0F 86 B9 02 00 00 85 C0 0F 89 63 FB FF FF 83 F8 F0 0F 8C B3 03 00 00 4D 85 D2 74 0D 41 8D 50 FF 83 FA 01 0F 86 A1 05 00 00 49 63 D0 F7 D8 48 8D 0C D2 48 98 48 8D 14 4A 48 8B 0D ?? ?? ?? ?? 48 01 C2 48 03 1C D1 48 89 C2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 49 89 DE 41 89 DD 48 8B 7A 08 49 C1 EE 20 4C 89 F6 4C 89 F5 4D 89 F4 41 89 F9 48 89 FB 49 0F AF F1 48 C1 EB 20 4D 0F AF CD 48 0F AF EB 41 89 F3 48 C1 EE 20 4C 89 C9 45 89 C9 49 0F AF DD 48 C1 E9 20 48 01 EE 48 8B 2A 49 01 CB 49 01 DB 89 EB 4C 89 D9 49 C1 E3 20 4C 0F AF E3 48 C1 E9 20 49 0F AF DD 48 01 CE 48 89 E9 48 C1 E9 20 45 89 E7 4C 0F AF E9 48 89 DA 89 DB 4C 0F AF F1 48 C1 EA 20 4C 89 E1 4C 01 FA 48 C1 E9 20 4C 01 EA 49 89 D4 4C 01 F1 48 C1 E2 20 49 C1 EC 20 48 01 DA 49 01 CC 4B 8D 0C 0B 4C 01 E1 49 89 C9 48 8B 0D ?? ?? ?? ?? 48 83 D6 00 44 8B 24 81 48 89 F0 44 89 E1 48 D3 E8 45 85 C0 0F 85 7A 03 00 00 A8 01 74 27 B9 40 00 00 00 49 C7 C0 FF FF FF FF 44 29 E1 49 D3 E8 4C 85 C6 75 10 4C 39 CF 77 07 75 09 48 39 D5 76 04 48 83 E8 01 48 8B 1D ?? ?? ?? ?? 44 8B 1B 41 F6 C3 20 0F 85 4F 03 00 00 B9 40 00 00 00 44 29 E1 48 D3 E6 48 B9 00 00 00 00 00 00 00 80 48 39 CE 0F 84 25 04 00 00 41 83 CB 30 44 89 1B 0F 1F 44 00 00 4C 09 D0 E9 38 F9 FF FF 0F 1F 84 00 00 00 00 00 2D 92 16 00 00 0F 88 65 02 00 00 3D FF 02 00 00 BA FF 02 00 00 0F 4F C2 48 C1 E0 35 4C 09 D0 E9 0C F9 FF FF 4C 89 C0 45 31 C9 31 DB 48 C1 E8 2F 25 FF 3F 00 00 E9 1F F7 FF FF 66 0F 1F 44 00 00 3D 6E 16 00 00 0F 8F 19 01 00 00 8B 44 24 08 C7 44 24 54 01 00 00 00 41 BC 03 00 00 00 BB 03 00 00 00 48 8B 35 ?? ?? ?? ?? 2D 92 16 00 00 E9 86 FA FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 01 E9 AE F8 FF FF 4C 89 D9 4D 89 D8 66 0F EF D2 48 D1 E9 41 83 E0 01 4C 09 C1 F3 48 0F 2A D1 F3 0F 58 D2 E9 9B F9 FF FF 48 39 D0 0F 86 9B F6 FF FF E9 95 F8 FF FF 48 BA FF FF FF FF FF FF 1F 00 48 39 D3 76 64 48 89 C2 48 B9 FF FF FF FF FF FF 07 00 48 B8 00 00 00 00 00 00 00 60 4C 09 D0 48 21 CB 48 C1 E2 33 48 09 D8 48 09 D0 E9 43 F8 FF FF 0F 1F 00 B9 40 00 00 00 4C 89 DA 4C 89 C3 44 29 C9 48 D3 E2 44 89 C9 48 D3 EB 48 09 D3 E9 D7 FB FF FF 90 B9 40 00 00 00 4C 89 C2 44 29 C9 48 D3 E2 31 FF E9 41 FC FF FF 48 C1 E0 35 49 09 DA 4C 09 D0 E9 FC F7 FF FF 49 B9 00 00 00 00 00 00 00 F8 31 C0 31 DB 4D 21 C1 E9 0F F6 FF FF 66 0F 1F 44 00 00 0F 85 46 F9 FF FF 48 39 11 0F 87 3D F9 FF FF E9 34 F9 FF FF 81 7C 24 08 91 16 00 00 0F 84 AF 01 00 00 48 8B 35 ?? ?? ?? ?? C7 44 24 54 01 00 00 00 44 89 E3 41 81 C0 92 16 00 00 31 C0 44 2B 44 24 08 C7 44 24 08 92 16 00 00 E9 5A F9 FF FF 90 48 89 D1 49 89 D0 66 0F EF C9 48 D1 E9 41 83 E0 01 4C 09 C1 F3 48 0F 2A C9 0F 28 C1 F3 0F 58 C1 E9 94 F8 FF FF 41 8D 49 C0 41 BB 01 00 00 00 31 F6 49 D3 E3 E9 2D FC FF FF 0F 1F 80 00 00 00 00 B9 40 00 00 00 48 89 D7 31 D2 44 29 C9 48 D3 EF E9 EE FB FF FF 48 09 D7 0F 85 22 FC FF FF 48 8B 54 24 20 48 C1 E2 04 48 03 54 24 58 48 3B 6A 08 0F 82 20 FC FF FF 0F 85 04 FC FF FF 4C 3B 32 0F 82 11 FC FF FF E9 F6 FB FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 30 41 83 F8 01 75 13 4D 85 D2 48 B8 01 00 00 00 00 00 00 80 0F 85 DD F6 FF FF 41 83 F8 02 75 17 4D 85 D2 B8 01 00 00 00 0F 84 C9 F6 FF FF 66 0F 1F 84 00 00 00 00 00 4C 89 D0 E9 B8 F6 FF FF 0F 1F 84 00 00 00 00 00 75 09 48 39 D9 0F 86 5C F4 FF FF 49 B9 FF FF FF FF FF 3F 00 FE 4D 21 C1 E9 59 F4 FF FF 0F 1F 00 89 F1 4C 89 DA 4D 89 C5 48 D3 E2 41 8D 49 C0 4C 89 C7 49 D3 ED 89 F1 48 D3 E7 48 89 F9 4C 09 E9 48 09 D1 0F 84 4F FA FF FF E9 95 FA FF FF 66 90 48 B8 FF FF C0 6F F2 86 FB 77 E9 11 FD FF FF 90 48 B9 00 00 00 00 00 00 00 80 48 39 CA 0F 85 2D FB FF FF 48 85 FF 0F 84 02 FF FF FF E9 1F FB FF FF 48 8B 1D ?? ?? ?? ?? 44 8B 1B 41 F6 C3 20 0F 84 92 00 00 00 41 83 CB 10 44 89 1B E9 CF FC FF FF 44 89 E3 49 63 C0 48 8B 35 ?? ?? ?? ?? 48 8D 0C DB 48 89 D7 C7 44 24 54 00 00 00 00 48 8D 04 88 4C 89 D9 48 C1 E0 04 48 01 F0 48 03 48 08 48 03 38 0F 92 C0 0F B6 C0 48 01 C1 41 8D 40 10 48 98 48 C1 E0 04 49 01 C1 49 3B 49 08 0F 87 12 FE FF FF C7 44 24 54 01 00 00 00 0F 85 04 FE FF FF 31 C0 49 3B 39 0F 92 C0 89 44 24 54 E9 F3 FD FF FF 4D 85 D2 48 BA FF FF C0 6F F2 86 FB F7 48 0F 45 C2 E9 89 F5 FF FF B9 40 00 00 00 44 29 E1 48 D3 E6 41 83 F8 03 74 48 41 83 F8 04 0F 84 0F FC FF FF 41 83 F8 01 74 38 45 31 C0 48 01 EA 41 0F 92 C0 48 D3 EE 4D 01 C1 4C 01 CF 0F 92 C2 4D 39 C8 0F 97 C1 09 CA 44 89 E1 0F B6 D2 48 01 F2 48 D3 EA 48 85 D2 0F 85 F5 FB FF FF E9 E4 FB FF FF 48 85 F6 0F 85 DB FB FF FF 4C 39 CF 0F 87 DE FB FF FF 0F 85 CC FB FF FF 48 39 D5 0F 87 CF FB FF FF E9 BE FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 BA 03 00 00 00 44 29 C2 41 89 D0 E9 4F FA FF FF 45 31 C9 31 DB E9 0F F3 FF FF 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__popcountdi2"
		size = 96
	strings:
		$1 = { 48 B8 55 55 55 55 55 55 55 55 48 89 CA 48 D1 EA 48 21 D0 48 BA 33 33 33 33 33 33 33 33 48 29 C1 48 89 C8 48 C1 E9 02 48 21 D0 48 21 D1 48 BA 01 01 01 01 01 01 01 01 48 01 C1 48 89 C8 48 C1 E8 04 48 01 C1 48 B8 0F 0F 0F 0F 0F 0F 0F 0F 48 21 C1 48 89 C8 48 0F AF C2 48 C1 E8 38 C3 90 90 90 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__popcountti2"
		size = 160
	strings:
		$1 = { 48 8B 01 48 8B 49 08 48 BA 55 55 55 55 55 55 55 55 49 89 C0 49 D1 E8 49 21 D0 4C 29 C0 49 89 C8 49 D1 E8 4C 21 C2 49 B8 33 33 33 33 33 33 33 33 48 29 D1 48 89 C2 48 C1 E8 02 4C 21 C2 4C 21 C0 48 01 D0 48 89 CA 48 C1 E9 02 4C 21 C2 4C 21 C1 49 B8 0F 0F 0F 0F 0F 0F 0F 0F 48 01 D1 48 89 C2 48 C1 EA 04 48 01 D0 4C 21 C0 48 89 C2 48 89 C8 48 C1 E8 04 48 01 C1 4C 21 C1 48 8D 04 11 48 BA 01 01 01 01 01 01 01 01 48 0F AF C2 48 C1 E8 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__floatuntixf"
		size = 96
		refs = "0026 .rdata"
	strings:
		$1 = { 48 83 EC 18 48 89 C8 48 8B 0A 48 8B 52 08 48 89 54 24 08 48 85 D2 DF 6C 24 08 78 24 48 89 4C 24 08 48 85 C9 D9 05 ?? ?? ?? ?? DC C9 DF 6C 24 08 78 1E DD D9 DE C1 DB 38 48 83 C4 18 C3 0F 1F 00 D8 05 ?? ?? ?? ?? EB D4 0F 1F 84 00 00 00 00 00 DE C1 DE C1 DB 38 48 83 C4 18 C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__bid128_quiet_equal"
		size = 1232
		refs = "0153 .refptr.__bid_IDEC_glbflags 0272 .refptr.__bid_ten2k128 0404 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 49 08 48 8B 19 4C 8B 1A 4C 8B 52 08 48 BA 00 00 00 00 00 00 00 7C 4C 89 C9 49 89 D8 48 21 D1 4C 89 DE 48 39 D1 0F 84 E6 00 00 00 4C 89 D1 48 21 D1 48 39 D1 0F 84 D7 00 00 00 49 39 DB 75 0E 4D 39 CA B8 01 00 00 00 0F 84 E0 00 00 00 48 BA 00 00 00 00 00 00 00 78 4C 89 C9 48 21 D1 48 39 D1 0F 84 3A 01 00 00 4C 89 D0 48 21 D0 48 39 D0 0F 84 4A 01 00 00 48 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 4C 21 C9 48 39 C1 0F 87 B9 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 48 39 C3 0F 87 A4 00 00 00 48 B8 00 00 00 00 00 00 00 60 4C 89 CA 4C 89 D7 48 21 C2 48 BD C0 87 AD BE 09 ED 01 00 48 39 C2 48 BA FF FF FF FF FF FF 01 00 0F 94 C0 48 C1 EF 31 4C 21 D2 81 E7 FF 3F 00 00 48 39 EA 77 19 0F 85 D7 00 00 00 48 BD FF FF FF FF 63 8E 8D 37 49 39 EB 0F 86 C4 00 00 00 84 C0 0F 84 D8 02 00 00 B8 01 00 00 00 EB 1C 48 BA 00 00 00 00 00 00 00 7E 49 21 D1 49 39 D1 74 1B 49 21 D2 31 C0 49 39 D2 74 11 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 EB E1 66 90 48 BA FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 4C 21 D2 48 39 CA 77 BE 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CB 77 AD 48 B8 00 00 00 00 00 00 00 60 49 21 C2 49 39 C2 0F 84 74 FF FF FF 31 C0 49 09 D3 0F 94 C0 EB 8D 4C 89 D2 31 C0 48 21 CA 48 39 CA 75 80 4C 89 C8 4C 31 D0 48 F7 D0 48 C1 E8 3F E9 6E FF FF FF 31 C0 E9 67 FF FF FF 48 BD 00 00 00 00 00 00 00 60 4D 89 D4 49 21 EC 49 39 EC 0F 84 23 FF FF FF 84 C0 75 B3 48 89 C8 48 09 D8 74 AB 49 89 D7 31 C0 4D 09 DF 0F 84 34 FF FF FF 4D 31 CA 0F 88 2B FF FF FF 49 C1 E9 31 41 81 E1 FF 3F 00 00 41 39 F9 7E 17 48 89 C8 48 89 D1 4D 89 D8 48 89 C2 44 89 C8 48 89 DE 41 89 F9 89 C7 44 29 CF 31 C0 83 FF 21 0F 8F F6 FE FF FF 83 FF 13 0F 8E AF 01 00 00 44 8D 4F EC 89 F0 48 89 F5 48 C1 ED 20 48 89 C7 4D 63 C9 48 89 EE 48 89 EB 49 C1 E1 04 4C 03 0D ?? ?? ?? ?? 49 89 EE 4D 8B 51 08 4D 8B 09 4D 89 D3 45 89 D2 49 0F AF FA 49 C1 EB 20 49 0F AF F2 49 0F AF DB 49 89 FC 41 89 F5 49 C1 EC 20 48 C1 EE 20 4D 01 EC 49 89 C5 48 01 DE 4D 0F AF EB 4D 01 E5 49 89 C4 4C 89 EB 49 C1 E5 20 48 C1 EB 20 48 01 DE 4C 89 CB 45 89 C9 48 C1 EB 20 4D 0F AF E1 48 0F AF EB 4D 0F AF F1 48 89 6C 24 08 4C 89 E5 48 0F AF C3 48 C1 ED 20 45 89 F7 49 01 EF 49 C1 EE 20 4C 03 74 24 08 49 01 C7 89 F8 4C 89 FD 49 8D 7C 05 00 49 C1 E7 20 48 C1 ED 20 49 89 D5 89 D2 4C 01 F5 45 89 E6 48 01 EF 4F 8D 24 37 48 83 D6 00 49 C1 ED 20 4C 89 ED 4C 89 E8 49 0F AF EA 4C 0F AF D2 49 0F AF C3 41 89 EF 48 C1 ED 20 4D 89 D6 45 89 D2 4C 0F AF DA 49 C1 EE 20 48 01 C5 4D 01 FE 4D 01 F3 4D 89 EE 4D 0F AF F1 4C 89 D8 49 C1 E3 20 4C 0F AF CA 48 C1 E8 20 4D 01 D3 48 01 C5 45 89 F7 49 C1 EE 20 4C 89 C8 45 89 C9 48 C1 E8 20 49 01 C7 48 89 D0 48 0F AF C3 4C 0F AF EB 49 8D 1C 07 4D 01 F5 48 89 DA 48 C1 E3 20 48 C1 EA 20 4C 01 CB 4C 01 EA 4C 01 DA 48 83 D5 00 45 31 C9 48 01 FB 41 0F 92 C1 4C 01 CA 48 39 CB 0F 94 C1 4D 39 C4 0F 94 C0 21 C8 48 01 D6 0F 92 C1 49 39 D1 0F 97 C2 45 31 C9 09 CA 0F B6 D2 48 01 D5 48 09 F5 41 0F 94 C1 44 21 C8 E9 4B FD FF FF 31 C0 48 09 D9 0F 94 C0 E9 3E FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 49 89 D2 89 D2 49 C1 EA 20 4C 8B 0C F8 4C 89 CD 45 89 C9 48 C1 ED 20 48 89 EB 49 89 EB 48 0F AF DA 49 0F AF D1 4D 0F AF DA 89 DF 48 C1 EB 20 48 89 D0 89 D2 4D 0F AF D1 48 C1 E8 20 4C 01 DB 48 01 F8 49 89 EB 48 89 F7 48 C1 EF 20 4C 01 D0 49 89 C2 48 C1 E0 20 49 C1 EA 20 48 01 D0 4C 01 D3 41 89 F2 4D 0F AF DA 4D 0F AF D1 4C 0F AF CF 45 89 DC 49 C1 EB 20 4C 89 D6 45 89 D2 48 0F AF EF 48 C1 EE 20 4C 01 E6 49 01 F1 4C 01 DD 4D 89 CB 49 C1 E1 20 49 C1 EB 20 4D 01 D1 49 01 EB 4C 01 D8 48 83 D3 00 48 39 C8 0F 94 C2 4D 39 C1 0F 94 C0 45 31 C9 21 D0 48 85 DB 41 0F 94 C1 44 21 C8 E9 6F FC FF FF }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "__bid128_quiet_greater"
		size = 2240
		refs = "0163 .refptr.__bid_IDEC_glbflags 02b7 .refptr.__bid_ten2k128 06cd .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 0A 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 F9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4D 39 D9 75 0B 31 C0 48 39 CA 0F 84 F6 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 61 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 42 01 00 00 49 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 CA 49 39 C2 0F 87 D2 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 BD 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 1B 0F 85 FC 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 D9 0F 86 E9 00 00 00 66 90 84 C0 0F 85 D8 00 00 00 4D 85 D2 75 07 31 C0 4D 85 DB 74 28 48 F7 D1 48 C1 E9 3F 48 89 C8 EB 1C 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 1E 4C 21 C2 31 C0 4C 39 C2 74 14 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 EB DE 66 90 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 49 21 D0 49 39 C8 77 BE 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 AD 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 3C 4D 85 C0 75 07 31 C0 4D 85 C9 74 8C 48 C1 EA 3F 48 89 D0 EB 83 0F 1F 80 00 00 00 00 48 85 C9 78 1B 49 89 D1 B8 01 00 00 00 48 C1 EA 3F 4D 21 C1 4D 39 C1 48 0F 44 C2 E9 5C FF FF FF 31 C0 E9 55 FF FF FF 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 00 FF FF FF 84 C0 75 A0 4D 85 D2 75 05 4D 85 DB 74 96 4D 85 C0 75 09 4D 85 C9 0F 84 F8 FE FF FF 48 89 C8 48 31 D0 78 8C 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 56 02 00 00 4D 39 C2 77 13 0F 94 C3 0F 85 25 02 00 00 4D 39 D9 0F 83 1C 02 00 00 90 39 C7 0F 8E BC FE FF FF 4D 39 C2 0F 82 B6 FE FF FF 4D 39 D9 76 09 4D 39 C2 0F 84 A8 FE FF FF 89 C3 29 FB 85 DB 0F 8E 35 02 00 00 83 FB 21 0F 8F 90 FE FF FF 83 FB 13 0F 8E 2D 04 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 D4 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF D7 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E2 48 C1 EF 20 4C 01 D9 49 01 FA 4C 8B 5C 24 08 49 01 C2 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 11 49 01 C3 41 0F 92 C2 48 39 C1 0F 97 C0 44 09 D0 0F B6 C0 48 01 C6 0F 85 97 02 00 00 44 8B 54 24 18 4C 89 F8 48 C1 E0 20 4C 01 D0 4C 39 C5 0F 94 C1 4C 39 C8 41 0F 94 C2 44 84 D1 74 09 4D 85 DB 0F 84 9D FD FF FF 4C 39 C5 0F 87 64 02 00 00 4D 85 DB 0F 85 5B 02 00 00 4C 39 C8 0F 97 C0 0F B6 C0 21 C8 48 C1 EA 3F 31 D0 E9 D1 FC FF FF 4D 39 C2 72 11 4D 39 D9 0F 86 F6 FD FF FF 84 DB 0F 84 EE FD FF FF 39 C7 0F 8C E6 FD FF FF E9 89 FC FF FF 4D 39 C2 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 D9 0F 96 C2 21 D0 48 C1 E9 3F 31 C8 E9 8C FC FF FF 29 C7 83 FF 21 0F 8F 5C FC FF FF 83 FF 13 0F 8E DD 02 00 00 8D 47 EC 4D 89 CE 45 89 C9 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DD 89 DB 49 89 DC 48 89 DE 48 C1 ED 20 4D 0F AF E1 48 89 EF 49 0F AF F6 49 0F AF FE 4D 89 E5 45 89 E4 41 89 F7 49 C1 ED 20 48 C1 EE 20 4D 01 FD 49 89 EF 48 01 FE 4D 0F AF F9 4D 01 EF 4C 89 FF 4C 89 7C 24 08 48 C1 EF 20 48 01 F7 48 89 C6 89 C0 48 C1 EE 20 49 89 C5 4D 0F AF EE 4C 0F AF F6 45 89 EF 4C 89 74 24 10 49 89 C6 4D 0F AF F1 4C 0F AF CE 4C 89 74 24 18 49 C1 EE 20 4D 01 FE 4F 8D 3C 0E 4D 89 E9 49 C1 E9 20 4C 03 4C 24 10 4D 89 FD 49 C1 ED 20 4D 01 E9 4C 8B 6C 24 08 49 C1 E5 20 4D 01 EC 4D 01 CC 48 83 D7 00 49 C1 E8 20 4C 89 64 24 08 4D 89 C6 4C 0F AF F3 48 0F AF DA 4D 89 F4 4D 89 C6 4C 0F AF F5 45 89 E1 49 89 DD 48 0F AF EA 49 C1 EC 20 49 C1 ED 20 89 DB 4D 01 F4 4D 89 C6 4C 0F AF F0 4C 01 ED 48 0F AF C2 49 01 E9 4C 89 CD 48 C1 ED 20 4C 01 E5 45 89 F5 4D 89 F4 48 0F AF D6 49 89 C6 49 C1 EC 20 4C 0F AF C6 49 C1 EE 20 89 C0 4C 01 F2 49 01 D5 4D 01 E0 4C 89 EA 49 C1 E5 20 48 C1 EA 20 49 01 D0 49 8D 54 05 00 4C 89 C8 48 C1 E0 20 48 01 D8 4C 01 C0 48 83 D5 00 45 31 C0 48 03 54 24 08 41 0F 92 C0 4C 01 C0 48 01 C7 41 0F 92 C1 49 39 C0 0F 97 C0 44 09 C8 0F B6 C0 48 01 C5 0F 85 3A 02 00 00 8B 44 24 18 49 C1 E7 20 4C 01 F8 49 39 D2 41 0F 94 C0 4C 39 D8 41 0F 94 C1 45 84 C8 74 09 48 85 FF 0F 84 61 FB FF FF 49 39 D2 0F 82 0A 02 00 00 48 85 FF 0F 85 01 02 00 00 4C 39 D8 0F 97 C0 0F B6 C0 44 21 C0 89 C2 48 89 C8 48 F7 D0 48 C1 E8 3F 31 D0 E9 8C FA FF FF B8 01 00 00 00 E9 A6 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 EA 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF EA 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF D7 4C 01 E1 48 01 E8 4C 01 D1 49 89 F2 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF D0 48 0F AF C7 49 0F AF FD 45 89 D3 49 C1 EA 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F2 49 01 C2 48 8D 04 19 49 01 C2 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C2 0F 94 C1 75 09 4D 39 CB 0F 84 5C FA FF FF 4D 39 C2 B8 01 00 00 00 0F 87 CE FC FF FF 31 C0 4D 39 CB 0F 97 C0 21 C8 E9 BF FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D3 49 C1 E8 20 48 8B 3C F8 48 89 F8 89 FF 48 C1 E8 20 48 89 C6 48 89 C5 48 0F AF F3 48 0F AF DF 49 0F AF E8 41 89 F4 48 C1 EE 20 48 89 D9 89 DB 4C 0F AF C7 48 C1 E9 20 48 01 EE 4C 01 E1 4C 89 CD 45 89 C9 48 C1 ED 20 4C 01 C1 49 89 C8 48 C1 E1 20 49 C1 E8 20 48 01 D9 4C 01 C6 49 89 C0 4D 0F AF C1 48 0F AF C5 4C 0F AF CF 45 89 C5 49 C1 E8 20 49 89 C4 48 0F AF FD 4C 89 C8 48 C1 E8 20 4C 01 E8 48 01 F8 4B 8D 3C 20 49 89 C0 49 C1 E8 20 49 01 F8 4C 01 C1 48 83 D6 00 48 85 F6 75 50 48 C1 E0 20 45 89 C9 49 39 CA 4E 8D 04 08 0F 94 C3 75 09 4D 39 D8 0F 84 78 F9 FF FF 49 39 CA 41 B9 01 00 00 00 72 0D 31 C0 4D 39 D8 0F 97 C0 21 D8 41 89 C1 48 89 D0 48 F7 D0 48 C1 E8 3F 44 31 C8 E9 AA F8 FF FF BA 01 00 00 00 E9 03 FE FF FF 41 B9 01 00 00 00 EB DC 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "__bid128_quiet_greater_equal"
		size = 2208
		refs = "0153 .refptr.__bid_IDEC_glbflags 02d7 .refptr.__bid_ten2k128 06a7 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 0A 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 E9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 DA 00 00 00 4D 39 D9 75 0E 48 39 CA B8 01 00 00 00 0F 84 E3 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 5E 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 39 01 00 00 49 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 CA 49 39 C2 0F 87 BF 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 AA 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 19 0F 85 FE 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 D9 0F 86 EB 00 00 00 84 C0 0F 84 27 01 00 00 B8 01 00 00 00 EB 1C 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 1E 4C 21 C2 31 C0 4C 39 C2 74 14 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 EB DE 66 90 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 49 21 D0 49 39 C8 77 BB 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 AA 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 0F 84 6E FF FF FF 4D 85 C0 75 0A 4D 85 C9 B8 01 00 00 00 74 82 48 C1 EA 3F 48 89 D0 E9 76 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 85 C9 B8 01 00 00 00 0F 89 5E FF FF FF 48 89 D1 30 C0 48 C1 EA 3F 4C 21 C1 4C 39 C1 48 89 C1 48 0F 44 CA 48 89 C8 E9 40 FF FF FF 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 FC FE FF FF 84 C0 75 92 4D 85 D2 75 05 4D 85 DB 74 88 4D 85 C0 75 2D 4D 85 C9 75 28 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 00 FF FF FF 0F 1F 40 00 4D 85 D2 75 E8 4D 85 DB B8 01 00 00 00 0F 84 E9 FE FF FF EB D8 48 89 C8 48 31 D0 0F 88 59 FF FF FF 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 F8 0F 84 2B 02 00 00 40 0F 9F C6 4D 39 C2 0F 93 C3 40 84 DE 74 05 4D 39 D9 76 A4 4D 39 C2 40 0F 96 C6 39 F8 0F 9C C3 40 84 DE 74 05 4D 39 D9 73 91 89 C3 29 FB 85 DB 0F 8E 19 02 00 00 83 FB 21 0F 8F 79 FF FF FF 83 FB 13 0F 8E E7 03 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 D4 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF D7 49 C1 EE 20 4C 01 F1 49 01 CD 4C 89 E9 49 C1 E5 20 4D 01 E2 48 C1 E9 20 4C 01 D1 4F 8D 54 1D 00 48 01 C1 48 83 D6 00 45 31 DB 4C 01 D5 41 0F 92 C3 4C 8B 54 24 08 49 8D 04 0B 49 01 C2 0F 92 C1 49 39 C3 0F 97 C0 09 C8 0F B6 C0 48 01 C6 0F 85 50 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 48 01 C1 4C 39 C5 41 0F 94 C3 4C 39 C9 0F 94 C0 41 84 C3 74 0E 4D 85 D2 B8 01 00 00 00 0F 84 C4 FC FF FF 4C 39 C5 0F 87 19 02 00 00 4D 85 D2 0F 85 10 02 00 00 31 C0 4C 39 C9 0F 97 C0 44 21 D8 48 C1 EA 3F 31 D0 E9 9C FC FF FF 4D 39 C2 BA 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 D9 0F 96 C2 21 C2 48 C1 E9 3F 89 D0 31 C8 E9 78 FC FF FF 29 C7 83 FF 21 0F 8F 61 FD FF FF 83 FF 13 0F 8E B5 02 00 00 8D 47 EC 4D 89 CE 45 89 C9 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 49 0F AF E9 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF F9 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF F9 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF CF 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 CE 4F 8D 4C 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 E9 4D 01 CF 48 83 54 24 08 00 49 C1 E8 20 4C 89 C5 4D 89 C4 48 0F AF EB 48 0F AF DA 4C 0F AF E6 41 89 E9 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F2 49 C1 ED 20 4C 01 E5 4C 01 EE 49 01 F1 4C 89 CE 49 C1 E1 20 48 C1 EE 20 48 01 EE 4C 89 C5 48 0F AF E8 48 0F AF C2 48 0F AF D7 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF C7 49 C1 ED 20 4C 01 EA 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 E8 48 C1 EA 20 4C 01 E0 4C 01 C2 4D 8D 04 19 4C 01 C2 48 83 D6 00 45 31 C0 49 01 C7 48 8B 44 24 08 41 0F 92 C0 4C 01 C2 48 01 D0 41 0F 92 C1 49 39 D0 0F 97 C2 44 09 CA 0F B6 D2 48 01 D6 75 30 8B 54 24 18 49 C1 E6 20 4D 39 FA 4D 8D 04 16 0F 94 C2 48 85 C0 0F 94 C0 4D 39 D8 41 0F 94 C1 44 84 CA 0F 84 EF 01 00 00 84 C0 0F 85 8C FA FF FF 31 C0 48 C1 E9 3F 31 C8 E9 A2 FA FF FF B8 01 00 00 00 E9 F1 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 EA 20 48 8B 3C D8 48 89 FD 89 FF 48 C1 ED 20 48 89 EB 48 89 EE 48 0F AF D9 48 0F AF CF 49 0F AF F2 41 89 DC 48 C1 EB 20 48 89 C8 89 C9 4C 0F AF D7 48 C1 E8 20 48 01 F3 4C 01 E0 4D 89 DC 45 89 DB 4C 89 DE 49 C1 EC 20 4C 01 D0 49 89 C2 48 C1 E0 20 49 C1 EA 20 48 01 C8 4C 01 D3 49 89 EA 48 0F AF F7 4D 0F AF D3 49 0F AF FC 49 89 F3 49 C1 EB 20 45 89 D5 49 C1 EA 20 49 0F AF EC 4D 01 DD 49 89 FB 4D 01 EB 49 8D 3C 2A 4D 89 DA 49 C1 EA 20 49 01 FA 49 01 C2 48 83 D3 00 48 85 DB 0F 85 44 FF FF FF 49 C1 E3 20 89 F6 B8 01 00 00 00 49 01 F3 4D 39 C2 0F 94 C1 75 09 4D 39 CB 0F 84 C7 F9 FF FF 4D 39 C2 0F 87 17 FD FF FF 31 C0 4D 39 CB 0F 97 C0 21 C8 E9 08 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4C 89 CD 45 89 C9 48 C1 ED 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C1 4C 0F AF CE 48 0F AF F5 45 89 C5 49 C1 E8 20 4D 89 CC 48 0F AF DD 49 C1 EC 20 4D 01 EC 4C 01 E6 4C 01 C3 49 89 F0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 39 48 C1 E6 20 44 89 C8 4D 39 C2 4C 8D 0C 06 0F 94 C1 B8 01 00 00 00 75 09 4D 39 D9 0F 84 E7 F8 FF FF 4D 39 C2 0F 87 37 FC FF FF 31 C0 4D 39 D9 0F 92 C0 21 C8 E9 28 FC FF FF 31 C0 E9 21 FC FF FF 84 C0 0F 84 11 FE FF FF 4D 39 FA B8 01 00 00 00 0F 87 05 FE FF FF 31 C0 4D 39 D8 0F 92 C0 21 D0 E9 F6 FD FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "__bid128_quiet_greater_unordered"
		size = 2192
		refs = "0163 .refptr.__bid_IDEC_glbflags 0226 .refptr.__bid_ten2k128 0693 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 0A 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 F9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4D 39 D9 75 0B 31 C0 48 39 CA 0F 84 F9 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 61 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 47 01 00 00 49 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 CA 49 39 C2 0F 87 D3 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 BE 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 1B 0F 85 DC 02 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 D9 0F 86 C9 02 00 00 66 90 84 C0 0F 85 B8 02 00 00 4D 85 D2 75 07 31 C0 4D 85 DB 74 2B 48 F7 D1 48 C1 E9 3F 48 89 C8 EB 1F 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 1E 4C 21 C2 B8 01 00 00 00 4C 39 C2 74 11 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 EB DE 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 49 21 D0 49 39 C8 77 C0 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 AF 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 0F 84 17 02 00 00 4D 85 C0 75 07 31 C0 4D 85 C9 74 8A 48 C1 EA 3F 48 89 D0 EB 81 66 90 48 85 C9 0F 88 F7 01 00 00 48 89 D1 B8 01 00 00 00 48 C1 EA 3F 4C 21 C1 4C 39 C1 48 89 C1 48 0F 44 CA 48 89 C8 E9 55 FF FF FF 29 C7 83 FF 21 0F 8F 22 FF FF FF 83 FF 13 0F 8E 6B 05 00 00 8D 47 EC 4D 89 CE 45 89 C9 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 49 0F AF E9 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF F9 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF F9 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF CF 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 CE 4F 8D 4C 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 E9 4D 01 CF 48 83 54 24 08 00 49 C1 E8 20 4C 89 C5 4D 89 C4 48 0F AF EB 48 0F AF DA 4C 0F AF E6 41 89 E9 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F2 49 C1 ED 20 4C 01 E5 4C 01 EE 49 01 F1 4C 89 CE 49 C1 E1 20 48 C1 EE 20 48 01 EE 4C 89 C5 48 0F AF E8 48 0F AF C2 48 0F AF D7 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF C7 49 C1 ED 20 4C 01 EA 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 E8 48 C1 EA 20 4C 01 E0 4C 01 C2 4D 8D 04 19 4C 01 C2 48 83 D6 00 45 31 C0 49 01 C7 48 8B 44 24 08 41 0F 92 C0 4C 01 C2 48 01 D0 41 0F 92 C1 49 39 D0 0F 97 C2 44 09 CA 0F B6 D2 48 01 D6 0F 85 E5 02 00 00 8B 54 24 18 49 C1 E6 20 4D 39 FA 4D 8D 04 16 0F 94 C2 48 85 C0 0F 94 C0 4D 39 D8 41 0F 94 C1 44 84 CA 0F 84 A1 04 00 00 84 C0 0F 84 B5 02 00 00 66 0F 1F 84 00 00 00 00 00 31 C0 E9 78 FD FF FF 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 20 FD FF FF 84 C0 0F 85 C1 FD FF FF 4D 85 D2 75 09 4D 85 DB 0F 84 B3 FD FF FF 4D 85 C0 75 09 4D 85 C9 0F 84 10 FD FF FF 48 89 C8 48 31 D0 0F 88 A5 FD FF FF 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 F8 0F 84 24 02 00 00 40 0F 9F C6 4D 39 C2 0F 93 C3 40 84 DE 74 09 4D 39 D9 0F 86 D8 FC FF FF 4D 39 C2 40 0F 96 C6 39 F8 0F 9C C3 40 84 DE 74 09 4D 39 D9 0F 83 C1 FC FF FF 89 C3 29 FB 85 DB 0F 8E 88 FD FF FF 83 FB 21 0F 8F A9 FC FF FF 83 FB 13 0F 8E 0C 02 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 D4 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF D7 49 C1 EE 20 4C 01 F1 49 01 CD 4C 89 E9 49 C1 E5 20 4D 01 E2 48 C1 E9 20 4C 01 D1 4F 8D 54 1D 00 48 01 C1 48 83 D6 00 45 31 DB 4C 01 D5 41 0F 92 C3 4C 8B 54 24 08 49 8D 04 0B 49 01 C2 0F 92 C1 49 39 C3 0F 97 C0 09 C8 0F B6 C0 48 01 C6 75 7C 8B 4C 24 18 4C 89 F8 48 C1 E0 20 48 01 C1 4C 39 C5 41 0F 94 C3 4C 39 C9 0F 94 C0 41 84 C3 74 0B 31 C0 4D 85 D2 0F 84 17 FB FF FF 4C 39 C5 77 4C 4D 85 D2 75 47 31 C0 4C 39 C9 0F 97 C0 44 21 D8 48 C1 EA 3F 31 D0 E9 F7 FA FF FF 4D 39 C2 BA 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 D9 0F 96 C2 21 C2 48 C1 E9 3F 89 D0 31 C8 E9 D3 FA FF FF 31 C0 48 C1 E9 3F 31 C8 E9 C6 FA FF FF B8 01 00 00 00 EB BD 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 EA 20 48 8B 3C D8 48 89 FD 89 FF 48 C1 ED 20 48 89 EB 48 89 EE 48 0F AF D9 48 0F AF CF 49 0F AF F2 41 89 DC 48 C1 EB 20 48 89 C8 89 C9 4C 0F AF D7 48 C1 E8 20 48 01 F3 4C 01 E0 4D 89 DC 45 89 DB 4C 89 DE 49 C1 EC 20 4C 01 D0 49 89 C2 48 C1 E0 20 49 C1 EA 20 48 01 C8 4C 01 D3 49 89 EA 48 0F AF F7 4D 0F AF D3 49 0F AF FC 49 89 F3 49 C1 EB 20 45 89 D5 49 C1 EA 20 49 0F AF EC 4D 01 DD 49 89 FB 4D 01 EB 49 8D 3C 2A 4D 89 DA 49 C1 EA 20 49 01 FA 49 01 C2 48 83 D3 00 48 85 DB 0F 85 47 FF FF FF 49 C1 E3 20 89 F6 49 01 F3 4D 39 C2 0F 94 C1 75 09 4D 39 CB 0F 84 74 FC FF FF 4D 39 C2 B8 01 00 00 00 0F 87 E3 FE FF FF 31 C0 4D 39 CB 0F 97 C0 21 C8 E9 D4 FE FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4C 89 CD 45 89 C9 48 C1 ED 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C1 4C 0F AF CE 48 0F AF F5 45 89 C5 49 C1 E8 20 4D 89 CC 48 0F AF DD 49 C1 EC 20 4D 01 EC 4C 01 E6 4C 01 C3 49 89 F0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 39 48 C1 E6 20 44 89 C8 4D 39 C2 4C 8D 0C 06 0F 94 C1 75 09 4D 39 D9 0F 84 94 FB FF FF 4D 39 C2 B8 01 00 00 00 0F 87 03 FE FF FF 31 C0 4D 39 D9 0F 92 C0 21 C8 E9 F4 FD FF FF 31 C0 E9 ED FD FF FF 84 C0 0F 84 14 FE FF FF 4D 39 FA B8 01 00 00 00 0F 87 08 FE FF FF 31 C0 4D 39 D8 0F 92 C0 21 D0 E9 F9 FD FF FF 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_4_0 {
	meta:
		name = "__bid128_quiet_less"
		size = 2208
		refs = "0163 .refptr.__bid_IDEC_glbflags 02c9 .refptr.__bid_ten2k128 06ba .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 0A 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 F9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4D 39 D9 75 0B 31 C0 48 39 CA 0F 84 F6 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 61 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 42 01 00 00 49 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 CA 49 39 C2 0F 87 D2 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 BD 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 1B 0F 85 FC 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 D9 0F 86 E9 00 00 00 66 90 84 C0 0F 85 D8 00 00 00 4D 85 D2 75 07 31 C0 4D 85 DB 74 28 48 C1 E9 3F 48 89 C8 EB 1F 0F 1F 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 1E 4C 21 C2 31 C0 4C 39 C2 74 14 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 EB DE 66 90 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 49 21 D0 49 39 C8 77 BE 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 AD 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 3C 4D 85 C0 75 07 31 C0 4D 85 C9 74 8C 48 F7 D2 48 C1 EA 3F 48 89 D0 EB 80 0F 1F 40 00 31 C0 48 85 C9 0F 89 71 FF FF FF 48 89 D1 B0 01 4C 21 C1 4C 39 C1 0F 85 60 FF FF FF EB D2 66 90 31 C0 E9 55 FF FF FF 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 00 FF FF FF 84 C0 75 A0 4D 85 D2 75 05 4D 85 DB 74 96 4D 85 C0 75 09 4D 85 C9 0F 84 F8 FE FF FF 48 89 C8 48 31 D0 78 8C 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 48 02 00 00 4D 39 C2 77 13 0F 94 C3 75 2D 4D 39 D9 73 28 66 0F 1F 84 00 00 00 00 00 39 C7 0F 8E BC FE FF FF 4D 39 C2 72 0A 4D 39 D9 76 1F 4D 39 C2 75 1A 48 F7 D1 E9 A5 FE FF FF 4D 39 C2 72 09 4D 39 D9 76 08 84 DB 74 04 39 C7 7D E6 89 C3 29 FB 85 DB 0F 8E 18 02 00 00 83 FB 21 0F 8F 7E FE FF FF 83 FB 13 0F 8E 08 04 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 D4 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF D7 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E2 48 C1 EF 20 4C 01 D9 49 01 FA 4C 8B 5C 24 08 49 01 C2 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 11 49 01 C3 41 0F 92 C2 48 39 C1 0F 97 C0 44 09 D0 0F B6 C0 48 01 C6 0F 85 72 02 00 00 44 8B 54 24 18 4C 89 F8 48 C1 E0 20 4C 01 D0 4C 39 C5 0F 94 C1 4C 39 C8 41 0F 94 C2 44 84 D1 74 09 4D 85 DB 0F 84 8B FD FF FF 4C 39 C5 0F 87 3F 02 00 00 4D 85 DB 0F 85 36 02 00 00 4C 39 C8 0F 97 C0 0F B6 C0 21 C8 48 F7 D2 48 C1 EA 3F 31 D0 E9 BC FC FF FF 4D 39 C2 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 D9 0F 96 C2 21 D0 48 F7 D1 48 C1 E9 3F 31 C8 E9 97 FC FF FF 29 C7 83 FF 21 0F 8F B7 FD FF FF 83 FF 13 0F 8E D5 02 00 00 8D 47 EC 4D 89 CE 45 89 C9 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DD 89 DB 49 89 DC 48 89 DE 48 C1 ED 20 4D 0F AF E1 48 89 EF 49 0F AF F6 49 0F AF FE 4D 89 E5 45 89 E4 41 89 F7 49 C1 ED 20 48 C1 EE 20 4D 01 FD 49 89 EF 48 01 FE 4D 0F AF F9 4D 01 EF 4C 89 FF 4C 89 7C 24 08 48 C1 EF 20 48 01 F7 48 89 C6 89 C0 48 C1 EE 20 49 89 C5 4D 0F AF EE 4C 0F AF F6 45 89 EF 4C 89 74 24 10 49 89 C6 4D 0F AF F1 4C 0F AF CE 4C 89 74 24 18 49 C1 EE 20 4D 01 FE 4F 8D 3C 0E 4D 89 E9 49 C1 E9 20 4C 03 4C 24 10 4D 89 FD 49 C1 ED 20 4D 01 E9 4C 8B 6C 24 08 49 C1 E5 20 4D 01 EC 4D 01 CC 48 83 D7 00 49 C1 E8 20 4C 89 64 24 08 4D 89 C6 4C 0F AF F3 48 0F AF DA 4D 89 F4 4D 89 C6 4C 0F AF F5 45 89 E1 49 89 DD 48 0F AF EA 49 C1 EC 20 49 C1 ED 20 89 DB 4D 01 F4 4D 89 C6 4C 0F AF F0 4C 01 ED 48 0F AF C2 49 01 E9 4C 89 CD 48 C1 ED 20 4C 01 E5 45 89 F5 4D 89 F4 48 0F AF D6 49 89 C6 49 C1 EC 20 4C 0F AF C6 49 C1 EE 20 89 C0 4C 01 F2 49 01 D5 4D 01 E0 4C 89 EA 49 C1 E5 20 48 C1 EA 20 49 01 D0 49 8D 54 05 00 4C 89 C8 48 C1 E0 20 48 01 D8 4C 01 C0 48 83 D5 00 45 31 C0 48 03 54 24 08 41 0F 92 C0 4C 01 C0 48 01 C7 41 0F 92 C1 49 39 C0 0F 97 C0 44 09 C8 0F B6 C0 48 01 C5 0F 85 29 02 00 00 8B 44 24 18 49 C1 E7 20 4C 01 F8 49 39 D2 41 0F 94 C0 4C 39 D8 41 0F 94 C1 45 84 C8 74 09 48 85 FF 0F 84 6C FB FF FF 49 39 D2 0F 82 F9 01 00 00 48 85 FF 0F 85 F0 01 00 00 4C 39 D8 0F 97 C0 0F B6 C0 44 21 C0 48 C1 E9 3F 31 C8 E9 9F FA FF FF B8 01 00 00 00 E9 CB FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 EA 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF EA 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF D7 4C 01 E1 48 01 E8 4C 01 D1 49 89 F2 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF D0 48 0F AF C7 49 0F AF FD 45 89 D3 49 C1 EA 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F2 49 01 C2 48 8D 04 19 49 01 C2 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C2 0F 94 C1 75 09 4D 39 CB 0F 84 6F FA FF FF 4D 39 C2 B8 01 00 00 00 0F 87 F3 FC FF FF 31 C0 4D 39 CB 0F 97 C0 21 C8 E9 E4 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D3 49 C1 E8 20 48 8B 3C F8 48 89 F8 89 FF 48 C1 E8 20 48 89 C6 48 89 C5 48 0F AF F3 48 0F AF DF 49 0F AF E8 41 89 F4 48 C1 EE 20 48 89 D9 89 DB 4C 0F AF C7 48 C1 E9 20 48 01 EE 4C 01 E1 4C 89 CD 45 89 C9 48 C1 ED 20 4C 01 C1 49 89 C8 48 C1 E1 20 49 C1 E8 20 48 01 D9 4C 01 C6 49 89 C0 4D 0F AF C1 48 0F AF C5 4C 0F AF CF 45 89 C5 49 C1 E8 20 49 89 C4 48 0F AF FD 4C 89 C8 48 C1 E8 20 4C 01 E8 48 01 F8 4B 8D 3C 20 49 89 C0 49 C1 E8 20 49 01 F8 4C 01 C1 48 83 D6 00 48 85 F6 75 47 48 C1 E0 20 45 89 C9 49 39 CA 4E 8D 04 08 41 0F 94 C1 75 09 4D 39 D8 0F 84 8A F9 FF FF 49 39 CA B8 01 00 00 00 72 0B 31 C0 4D 39 D8 0F 97 C0 44 21 C8 48 C1 EA 3F 31 D0 E9 C6 F8 FF FF B8 01 00 00 00 E9 12 FE FF FF B8 01 00 00 00 EB E4 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_5_0 {
	meta:
		name = "__bid128_quiet_less_equal"
		size = 2224
		refs = "0173 .refptr.__bid_IDEC_glbflags 02d9 .refptr.__bid_ten2k128 06ca .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 0A 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 09 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 FA 00 00 00 4D 39 D9 75 0E 48 39 CA B8 01 00 00 00 0F 84 03 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 73 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 55 01 00 00 49 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 CA 49 39 C2 0F 87 DF 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 CA 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 19 0F 85 0C 01 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 D9 0F 86 F9 00 00 00 84 C0 0F 85 E7 00 00 00 4D 85 D2 75 12 4D 85 DB B8 01 00 00 00 74 34 0F 1F 84 00 00 00 00 00 48 C1 E9 3F 48 89 C8 EB 23 0F 1F 80 00 00 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 1E 4C 21 C2 31 C0 4C 39 C2 74 14 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 EB DE 66 90 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 49 21 D0 49 39 C8 77 BB 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 AA 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 39 4D 85 C0 75 0A 4D 85 C9 B8 01 00 00 00 74 86 48 F7 D2 48 C1 EA 3F 48 89 D0 E9 77 FF FF FF 48 85 C9 78 16 48 89 D1 31 C0 4C 21 C1 4C 39 C1 0F 85 61 FF FF FF EB D9 0F 1F 00 B8 01 00 00 00 E9 52 FF FF FF 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 EE FE FF FF 84 C0 75 A0 4D 85 D2 75 05 4D 85 DB 74 96 4D 85 C0 75 09 4D 85 C9 0F 84 F1 FE FF FF 48 89 C8 48 31 D0 78 8F 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 45 02 00 00 4D 39 C2 77 10 0F 94 C3 75 2A 4D 39 D9 73 25 66 0F 1F 44 00 00 39 C7 0F 8E B8 FE FF FF 4D 39 C2 72 0A 4D 39 D9 76 1F 4D 39 C2 75 1A 48 F7 D1 E9 A1 FE FF FF 4D 39 C2 72 09 4D 39 D9 76 08 84 DB 74 04 39 C7 7D E6 89 C3 29 FB 85 DB 0F 8E 18 02 00 00 83 FB 21 0F 8F 7A FE FF FF 83 FB 13 0F 8E 08 04 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 D4 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF D7 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E2 48 C1 EF 20 4C 01 D9 49 01 FA 4C 8B 5C 24 08 49 01 C2 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 11 49 01 C3 41 0F 92 C2 48 39 C1 0F 97 C0 44 09 D0 0F B6 C0 48 01 C6 0F 85 72 02 00 00 44 8B 54 24 18 4C 89 F8 48 C1 E0 20 4C 01 D0 4C 39 C5 0F 94 C1 4C 39 C8 41 0F 94 C2 44 84 D1 74 09 4D 85 DB 0F 84 8B FD FF FF 4C 39 C5 0F 87 3F 02 00 00 4D 85 DB 0F 85 36 02 00 00 4C 39 C8 0F 97 C0 0F B6 C0 21 C8 48 F7 D2 48 C1 EA 3F 31 D0 E9 BC FC FF FF 4D 39 C2 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 D9 0F 96 C2 21 D0 48 F7 D1 48 C1 E9 3F 31 C8 E9 97 FC FF FF 29 C7 83 FF 21 0F 8F B7 FD FF FF 83 FF 13 0F 8E D5 02 00 00 8D 47 EC 4D 89 CE 45 89 C9 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DD 89 DB 49 89 DC 48 89 DE 48 C1 ED 20 4D 0F AF E1 48 89 EF 49 0F AF F6 49 0F AF FE 4D 89 E5 45 89 E4 41 89 F7 49 C1 ED 20 48 C1 EE 20 4D 01 FD 49 89 EF 48 01 FE 4D 0F AF F9 4D 01 EF 4C 89 FF 4C 89 7C 24 08 48 C1 EF 20 48 01 F7 48 89 C6 89 C0 48 C1 EE 20 49 89 C5 4D 0F AF EE 4C 0F AF F6 45 89 EF 4C 89 74 24 10 49 89 C6 4D 0F AF F1 4C 0F AF CE 4C 89 74 24 18 49 C1 EE 20 4D 01 FE 4F 8D 3C 0E 4D 89 E9 49 C1 E9 20 4C 03 4C 24 10 4D 89 FD 49 C1 ED 20 4D 01 E9 4C 8B 6C 24 08 49 C1 E5 20 4D 01 EC 4D 01 CC 48 83 D7 00 49 C1 E8 20 4C 89 64 24 08 4D 89 C6 4C 0F AF F3 48 0F AF DA 4D 89 F4 4D 89 C6 4C 0F AF F5 45 89 E1 49 89 DD 48 0F AF EA 49 C1 EC 20 49 C1 ED 20 89 DB 4D 01 F4 4D 89 C6 4C 0F AF F0 4C 01 ED 48 0F AF C2 49 01 E9 4C 89 CD 48 C1 ED 20 4C 01 E5 45 89 F5 4D 89 F4 48 0F AF D6 49 89 C6 49 C1 EC 20 4C 0F AF C6 49 C1 EE 20 89 C0 4C 01 F2 49 01 D5 4D 01 E0 4C 89 EA 49 C1 E5 20 48 C1 EA 20 49 01 D0 49 8D 54 05 00 4C 89 C8 48 C1 E0 20 48 01 D8 4C 01 C0 48 83 D5 00 45 31 C0 48 03 54 24 08 41 0F 92 C0 4C 01 C0 48 01 C7 41 0F 92 C1 49 39 C0 0F 97 C0 44 09 C8 0F B6 C0 48 01 C5 0F 85 29 02 00 00 8B 44 24 18 49 C1 E7 20 4C 01 F8 49 39 D2 41 0F 94 C0 4C 39 D8 41 0F 94 C1 45 84 C8 74 09 48 85 FF 0F 84 6C FB FF FF 49 39 D2 0F 82 F9 01 00 00 48 85 FF 0F 85 F0 01 00 00 4C 39 D8 0F 97 C0 0F B6 C0 44 21 C0 48 C1 E9 3F 31 C8 E9 9F FA FF FF B8 01 00 00 00 E9 CB FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 EA 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF EA 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF D7 4C 01 E1 48 01 E8 4C 01 D1 49 89 F2 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF D0 48 0F AF C7 49 0F AF FD 45 89 D3 49 C1 EA 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F2 49 01 C2 48 8D 04 19 49 01 C2 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 B8 01 00 00 00 4D 01 E3 4D 39 C2 0F 94 C1 75 09 4D 39 CB 0F 84 C6 F9 FF FF 4D 39 C2 0F 87 F3 FC FF FF 31 C0 4D 39 CB 0F 97 C0 21 C8 E9 E4 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D3 49 C1 E8 20 48 8B 3C F8 48 89 F8 89 FF 48 C1 E8 20 48 89 C6 48 89 C5 48 0F AF F3 48 0F AF DF 49 0F AF E8 41 89 F4 48 C1 EE 20 48 89 D9 89 DB 4C 0F AF C7 48 C1 E9 20 48 01 EE 4C 01 E1 4C 89 CD 45 89 C9 48 C1 ED 20 4C 01 C1 49 89 C8 48 C1 E1 20 49 C1 E8 20 48 01 D9 4C 01 C6 49 89 C0 4D 0F AF C1 48 0F AF C5 4C 0F AF CF 45 89 C5 49 C1 E8 20 49 89 C4 48 0F AF FD 4C 89 C8 48 C1 E8 20 4C 01 E8 48 01 F8 4B 8D 3C 20 49 89 C0 49 C1 E8 20 49 01 F8 4C 01 C1 48 83 D6 00 48 85 F6 75 47 48 C1 E0 20 45 89 C9 49 39 CA 4E 8D 04 08 B8 01 00 00 00 41 0F 94 C1 75 09 4D 39 D8 0F 84 E1 F8 FF FF 49 39 CA 72 0B 31 C0 4D 39 D8 0F 97 C0 44 21 C8 48 C1 EA 3F 31 D0 E9 C6 F8 FF FF B8 01 00 00 00 E9 12 FE FF FF B8 01 00 00 00 EB E4 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_6_0 {
	meta:
		name = "__bid128_quiet_less_unordered"
		size = 2208
		refs = "0163 .refptr.__bid_IDEC_glbflags 02c9 .refptr.__bid_ten2k128 06ba .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 0A 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 F9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4D 39 D9 75 0B 31 C0 48 39 CA 0F 84 F9 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 61 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 43 01 00 00 49 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 CA 49 39 C2 0F 87 D3 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 BE 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 1B 0F 85 FC 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 D9 0F 86 E9 00 00 00 66 90 84 C0 0F 85 D8 00 00 00 4D 85 D2 75 07 31 C0 4D 85 DB 74 2B 48 C1 E9 3F 48 89 C8 EB 22 0F 1F 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 1E 4C 21 C2 B8 01 00 00 00 4C 39 C2 74 11 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 EB DE 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 49 21 D0 49 39 C8 77 C0 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 AF 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 3B 4D 85 C0 75 07 31 C0 4D 85 C9 74 8E 48 F7 D2 48 C1 EA 3F 48 89 D0 EB 82 0F 1F 00 31 C0 48 85 C9 0F 89 74 FF FF FF 48 89 D1 B0 01 4C 21 C1 4C 39 C1 0F 85 63 FF FF FF EB D3 66 90 31 C0 E9 58 FF FF FF 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 00 FF FF FF 84 C0 75 A1 4D 85 D2 75 05 4D 85 DB 74 97 4D 85 C0 75 09 4D 85 C9 0F 84 F8 FE FF FF 48 89 C8 48 31 D0 78 8D 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 48 02 00 00 4D 39 C2 77 13 0F 94 C3 75 2D 4D 39 D9 73 28 66 0F 1F 84 00 00 00 00 00 39 C7 0F 8E BC FE FF FF 4D 39 C2 72 0A 4D 39 D9 76 1F 4D 39 C2 75 1A 48 F7 D1 E9 A5 FE FF FF 4D 39 C2 72 09 4D 39 D9 76 08 84 DB 74 04 39 C7 7D E6 89 C3 29 FB 85 DB 0F 8E 18 02 00 00 83 FB 21 0F 8F 7E FE FF FF 83 FB 13 0F 8E 08 04 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 D4 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF D7 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E2 48 C1 EF 20 4C 01 D9 49 01 FA 4C 8B 5C 24 08 49 01 C2 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 11 49 01 C3 41 0F 92 C2 48 39 C1 0F 97 C0 44 09 D0 0F B6 C0 48 01 C6 0F 85 72 02 00 00 44 8B 54 24 18 4C 89 F8 48 C1 E0 20 4C 01 D0 4C 39 C5 0F 94 C1 4C 39 C8 41 0F 94 C2 44 84 D1 74 09 4D 85 DB 0F 84 8B FD FF FF 4C 39 C5 0F 87 3F 02 00 00 4D 85 DB 0F 85 36 02 00 00 4C 39 C8 0F 97 C0 0F B6 C0 21 C8 48 F7 D2 48 C1 EA 3F 31 D0 E9 BF FC FF FF 4D 39 C2 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 D9 0F 96 C2 21 D0 48 F7 D1 48 C1 E9 3F 31 C8 E9 9A FC FF FF 29 C7 83 FF 21 0F 8F B7 FD FF FF 83 FF 13 0F 8E D5 02 00 00 8D 47 EC 4D 89 CE 45 89 C9 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DD 89 DB 49 89 DC 48 89 DE 48 C1 ED 20 4D 0F AF E1 48 89 EF 49 0F AF F6 49 0F AF FE 4D 89 E5 45 89 E4 41 89 F7 49 C1 ED 20 48 C1 EE 20 4D 01 FD 49 89 EF 48 01 FE 4D 0F AF F9 4D 01 EF 4C 89 FF 4C 89 7C 24 08 48 C1 EF 20 48 01 F7 48 89 C6 89 C0 48 C1 EE 20 49 89 C5 4D 0F AF EE 4C 0F AF F6 45 89 EF 4C 89 74 24 10 49 89 C6 4D 0F AF F1 4C 0F AF CE 4C 89 74 24 18 49 C1 EE 20 4D 01 FE 4F 8D 3C 0E 4D 89 E9 49 C1 E9 20 4C 03 4C 24 10 4D 89 FD 49 C1 ED 20 4D 01 E9 4C 8B 6C 24 08 49 C1 E5 20 4D 01 EC 4D 01 CC 48 83 D7 00 49 C1 E8 20 4C 89 64 24 08 4D 89 C6 4C 0F AF F3 48 0F AF DA 4D 89 F4 4D 89 C6 4C 0F AF F5 45 89 E1 49 89 DD 48 0F AF EA 49 C1 EC 20 49 C1 ED 20 89 DB 4D 01 F4 4D 89 C6 4C 0F AF F0 4C 01 ED 48 0F AF C2 49 01 E9 4C 89 CD 48 C1 ED 20 4C 01 E5 45 89 F5 4D 89 F4 48 0F AF D6 49 89 C6 49 C1 EC 20 4C 0F AF C6 49 C1 EE 20 89 C0 4C 01 F2 49 01 D5 4D 01 E0 4C 89 EA 49 C1 E5 20 48 C1 EA 20 49 01 D0 49 8D 54 05 00 4C 89 C8 48 C1 E0 20 48 01 D8 4C 01 C0 48 83 D5 00 45 31 C0 48 03 54 24 08 41 0F 92 C0 4C 01 C0 48 01 C7 41 0F 92 C1 49 39 C0 0F 97 C0 44 09 C8 0F B6 C0 48 01 C5 0F 85 29 02 00 00 8B 44 24 18 49 C1 E7 20 4C 01 F8 49 39 D2 41 0F 94 C0 4C 39 D8 41 0F 94 C1 45 84 C8 74 09 48 85 FF 0F 84 6C FB FF FF 49 39 D2 0F 82 F9 01 00 00 48 85 FF 0F 85 F0 01 00 00 4C 39 D8 0F 97 C0 0F B6 C0 44 21 C0 48 C1 E9 3F 31 C8 E9 A2 FA FF FF B8 01 00 00 00 E9 CB FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 EA 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF EA 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF D7 4C 01 E1 48 01 E8 4C 01 D1 49 89 F2 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF D0 48 0F AF C7 49 0F AF FD 45 89 D3 49 C1 EA 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F2 49 01 C2 48 8D 04 19 49 01 C2 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C2 0F 94 C1 75 09 4D 39 CB 0F 84 6F FA FF FF 4D 39 C2 B8 01 00 00 00 0F 87 F3 FC FF FF 31 C0 4D 39 CB 0F 97 C0 21 C8 E9 E4 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D3 49 C1 E8 20 48 8B 3C F8 48 89 F8 89 FF 48 C1 E8 20 48 89 C6 48 89 C5 48 0F AF F3 48 0F AF DF 49 0F AF E8 41 89 F4 48 C1 EE 20 48 89 D9 89 DB 4C 0F AF C7 48 C1 E9 20 48 01 EE 4C 01 E1 4C 89 CD 45 89 C9 48 C1 ED 20 4C 01 C1 49 89 C8 48 C1 E1 20 49 C1 E8 20 48 01 D9 4C 01 C6 49 89 C0 4D 0F AF C1 48 0F AF C5 4C 0F AF CF 45 89 C5 49 C1 E8 20 49 89 C4 48 0F AF FD 4C 89 C8 48 C1 E8 20 4C 01 E8 48 01 F8 4B 8D 3C 20 49 89 C0 49 C1 E8 20 49 01 F8 4C 01 C1 48 83 D6 00 48 85 F6 75 47 48 C1 E0 20 45 89 C9 49 39 CA 4E 8D 04 08 41 0F 94 C1 75 09 4D 39 D8 0F 84 8A F9 FF FF 49 39 CA B8 01 00 00 00 72 0B 31 C0 4D 39 D8 0F 97 C0 44 21 C8 48 C1 EA 3F 31 D0 E9 C9 F8 FF FF B8 01 00 00 00 E9 12 FE FF FF B8 01 00 00 00 EB E4 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_7_0 {
	meta:
		name = "__bid128_quiet_not_equal"
		size = 1248
		refs = "0153 .refptr.__bid_IDEC_glbflags 028d .refptr.__bid_ten2k128 0410 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 49 08 48 8B 19 4C 8B 1A 4C 8B 52 08 48 BA 00 00 00 00 00 00 00 7C 4C 89 C9 49 89 D8 48 21 D1 4C 89 DE 48 39 D1 0F 84 E3 00 00 00 4C 89 D1 48 21 D1 48 39 D1 0F 84 D4 00 00 00 49 39 DB 75 0B 31 C0 4D 39 CA 0F 84 E3 00 00 00 48 BA 00 00 00 00 00 00 00 78 4C 89 C9 48 21 D1 48 39 D1 0F 84 3B 01 00 00 4C 89 D0 48 21 D0 48 39 D0 0F 84 4F 01 00 00 48 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 4C 21 C9 48 39 C1 0F 87 BD 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 48 39 C3 0F 87 A8 00 00 00 48 B8 00 00 00 00 00 00 00 60 4C 89 CA 4C 89 D7 48 21 C2 48 BD C0 87 AD BE 09 ED 01 00 48 39 C2 48 BA FF FF FF FF FF FF 01 00 0F 94 C0 48 C1 EF 31 4C 21 D2 81 E7 FF 3F 00 00 48 39 EA 77 19 0F 85 EF 00 00 00 48 BD FF FF FF FF 63 8E 8D 37 49 39 EB 0F 86 DC 00 00 00 84 C0 0F 84 C7 00 00 00 31 C0 EB 22 0F 1F 00 48 BA 00 00 00 00 00 00 00 7E 49 21 D1 49 39 D1 74 1E 49 21 D2 B8 01 00 00 00 49 39 D2 74 11 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 EB DE 48 BA FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 4C 21 D2 48 39 CA 77 C0 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CB 77 AF 48 B8 00 00 00 00 00 00 00 60 49 21 C2 49 39 C2 0F 84 73 FF FF FF 31 C0 49 09 D3 0F 95 C0 EB 8F 4C 89 D2 B8 01 00 00 00 48 21 CA 48 39 CA 0F 85 7B FF FF FF 4D 31 D1 49 C1 E9 3F 4C 89 C8 E9 6C FF FF FF B8 01 00 00 00 E9 62 FF FF FF 0F 1F 00 31 C0 48 09 D9 0F 95 C0 E9 52 FF FF FF 48 BD 00 00 00 00 00 00 00 60 4D 89 D4 49 21 EC 49 39 EC 0F 84 0B FF FF FF 84 C0 75 9C 48 89 C8 48 09 D8 74 94 49 89 D7 B8 01 00 00 00 4D 09 DF 0F 84 1C FF FF FF 4D 31 CA 0F 88 13 FF FF FF 49 C1 E9 31 41 81 E1 FF 3F 00 00 41 39 F9 7E 17 48 89 C8 48 89 D1 4D 89 D8 48 89 C2 44 89 C8 48 89 DE 41 89 F9 89 C7 44 29 CF B8 01 00 00 00 83 FF 21 0F 8F DB FE FF FF 83 FF 13 0F 8E A0 01 00 00 44 8D 4F EC 89 F0 48 89 F5 48 C1 ED 20 48 89 C7 4D 63 C9 48 89 EE 48 89 EB 49 C1 E1 04 4C 03 0D ?? ?? ?? ?? 49 89 EE 4D 8B 51 08 4D 8B 09 4D 89 D3 45 89 D2 49 0F AF FA 49 C1 EB 20 49 0F AF F2 49 0F AF DB 49 89 FC 41 89 F5 49 C1 EC 20 48 C1 EE 20 4D 01 EC 49 89 C5 48 01 DE 4D 0F AF EB 4D 01 E5 49 89 C4 4C 89 EB 49 C1 E5 20 48 C1 EB 20 48 01 DE 4C 89 CB 45 89 C9 48 C1 EB 20 4D 0F AF E1 48 0F AF EB 4D 0F AF F1 48 89 6C 24 08 4C 89 E5 48 0F AF C3 48 C1 ED 20 45 89 F7 49 01 EF 49 C1 EE 20 4C 03 74 24 08 49 01 C7 89 F8 4C 89 FD 49 8D 7C 05 00 49 C1 E7 20 48 C1 ED 20 49 89 D5 89 D2 4C 01 F5 45 89 E6 48 01 EF 4F 8D 24 37 48 83 D6 00 49 C1 ED 20 4C 89 ED 4C 89 E8 49 0F AF EA 4C 0F AF D2 49 0F AF C3 41 89 EF 48 C1 ED 20 4D 89 D6 45 89 D2 4C 0F AF DA 49 C1 EE 20 48 01 C5 4D 01 FE 4D 01 F3 4D 89 EE 4D 0F AF F1 4C 89 D8 49 C1 E3 20 4C 0F AF CA 48 C1 E8 20 4D 01 D3 48 01 C5 45 89 F7 49 C1 EE 20 4C 89 C8 45 89 C9 48 C1 E8 20 49 01 C7 48 89 D0 48 0F AF C3 4C 0F AF EB 49 8D 1C 07 4D 01 F5 48 89 DA 48 C1 E3 20 48 C1 EA 20 4C 01 CB 4C 01 EA 4C 01 DA 48 83 D5 00 45 31 C9 48 01 FB 41 0F 92 C1 4C 01 CA 48 39 CB 0F 95 C1 4D 39 C4 0F 95 C0 09 C8 48 01 D6 0F 92 C1 49 39 D1 0F 97 C2 09 CA 0F B6 D2 48 01 D5 48 09 F5 0F 95 C2 09 D0 0F B6 C0 E9 32 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 49 89 D2 89 D2 49 C1 EA 20 4C 8B 0C F8 4C 89 CD 45 89 C9 48 C1 ED 20 48 89 EB 49 89 EB 48 0F AF DA 49 0F AF D1 4D 0F AF DA 89 DF 48 C1 EB 20 48 89 D0 89 D2 4D 0F AF D1 48 C1 E8 20 4C 01 DB 48 01 F8 49 89 EB 48 89 F7 48 C1 EF 20 4C 01 D0 49 89 C2 48 C1 E0 20 49 C1 EA 20 48 01 D0 4C 01 D3 41 89 F2 4D 0F AF DA 4D 0F AF D1 4C 0F AF CF 45 89 DC 49 C1 EB 20 4C 89 D6 45 89 D2 48 0F AF EF 48 C1 EE 20 4C 01 E6 49 01 F1 4C 01 DD 4D 89 CB 49 C1 E1 20 49 C1 EB 20 4D 01 D1 49 01 EB 4C 01 D8 48 83 D3 00 48 39 C8 0F 95 C2 4D 39 C1 0F 95 C0 09 D0 48 85 DB 0F 95 C2 09 D0 0F B6 C0 E9 65 FC FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_46_8_0 {
	meta:
		name = "__bid128_quiet_not_greater"
		size = 2240
		refs = "0173 .refptr.__bid_IDEC_glbflags 02e9 .refptr.__bid_ten2k128 06da .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 0A 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 09 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 FA 00 00 00 4D 39 D9 75 0E 48 39 CA B8 01 00 00 00 0F 84 06 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 7E 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 56 01 00 00 49 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 CA 49 39 C2 0F 87 E0 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 CB 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 19 0F 85 1C 01 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 D9 0F 86 09 01 00 00 84 C0 0F 85 F7 00 00 00 4D 85 D2 75 12 4D 85 DB B8 01 00 00 00 74 37 0F 1F 84 00 00 00 00 00 48 C1 E9 3F 48 89 C8 EB 26 0F 1F 80 00 00 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 1E 4C 21 C2 B8 01 00 00 00 4C 39 C2 74 11 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 EB DE 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 49 21 D0 49 39 C8 77 BD 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 AC 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 48 4D 85 C0 75 0A 4D 85 C9 B8 01 00 00 00 74 88 48 F7 D2 48 C1 EA 3F 48 89 D0 E9 79 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 85 C9 78 1B 48 89 D1 31 C0 4C 21 C1 4C 39 C1 0F 85 59 FF FF FF EB CF 0F 1F 84 00 00 00 00 00 B8 01 00 00 00 E9 45 FF FF FF 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 DE FE FF FF 84 C0 75 91 4D 85 D2 75 05 4D 85 DB 74 87 4D 85 C0 75 09 4D 85 C9 0F 84 E1 FE FF FF 48 89 C8 48 31 D0 78 80 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 45 02 00 00 4D 39 C2 77 10 0F 94 C3 75 2A 4D 39 D9 73 25 66 0F 1F 44 00 00 39 C7 0F 8E A8 FE FF FF 4D 39 C2 72 0A 4D 39 D9 76 1F 4D 39 C2 75 1A 48 F7 D1 E9 91 FE FF FF 4D 39 C2 72 09 4D 39 D9 76 08 84 DB 74 04 39 C7 7D E6 89 C3 29 FB 85 DB 0F 8E 18 02 00 00 83 FB 21 0F 8F 6A FE FF FF 83 FB 13 0F 8E 08 04 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 D4 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF D7 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E2 48 C1 EF 20 4C 01 D9 49 01 FA 4C 8B 5C 24 08 49 01 C2 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 11 49 01 C3 41 0F 92 C2 48 39 C1 0F 97 C0 44 09 D0 0F B6 C0 48 01 C6 0F 85 72 02 00 00 44 8B 54 24 18 4C 89 F8 48 C1 E0 20 4C 01 D0 4C 39 C5 0F 94 C1 4C 39 C8 41 0F 94 C2 44 84 D1 74 09 4D 85 DB 0F 84 8B FD FF FF 4C 39 C5 0F 87 3F 02 00 00 4D 85 DB 0F 85 36 02 00 00 4C 39 C8 0F 97 C0 0F B6 C0 21 C8 48 F7 D2 48 C1 EA 3F 31 D0 E9 AF FC FF FF 4D 39 C2 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 D9 0F 96 C2 21 D0 48 F7 D1 48 C1 E9 3F 31 C8 E9 8A FC FF FF 29 C7 83 FF 21 0F 8F B7 FD FF FF 83 FF 13 0F 8E D5 02 00 00 8D 47 EC 4D 89 CE 45 89 C9 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DD 89 DB 49 89 DC 48 89 DE 48 C1 ED 20 4D 0F AF E1 48 89 EF 49 0F AF F6 49 0F AF FE 4D 89 E5 45 89 E4 41 89 F7 49 C1 ED 20 48 C1 EE 20 4D 01 FD 49 89 EF 48 01 FE 4D 0F AF F9 4D 01 EF 4C 89 FF 4C 89 7C 24 08 48 C1 EF 20 48 01 F7 48 89 C6 89 C0 48 C1 EE 20 49 89 C5 4D 0F AF EE 4C 0F AF F6 45 89 EF 4C 89 74 24 10 49 89 C6 4D 0F AF F1 4C 0F AF CE 4C 89 74 24 18 49 C1 EE 20 4D 01 FE 4F 8D 3C 0E 4D 89 E9 49 C1 E9 20 4C 03 4C 24 10 4D 89 FD 49 C1 ED 20 4D 01 E9 4C 8B 6C 24 08 49 C1 E5 20 4D 01 EC 4D 01 CC 48 83 D7 00 49 C1 E8 20 4C 89 64 24 08 4D 89 C6 4C 0F AF F3 48 0F AF DA 4D 89 F4 4D 89 C6 4C 0F AF F5 45 89 E1 49 89 DD 48 0F AF EA 49 C1 EC 20 49 C1 ED 20 89 DB 4D 01 F4 4D 89 C6 4C 0F AF F0 4C 01 ED 48 0F AF C2 49 01 E9 4C 89 CD 48 C1 ED 20 4C 01 E5 45 89 F5 4D 89 F4 48 0F AF D6 49 89 C6 49 C1 EC 20 4C 0F AF C6 49 C1 EE 20 89 C0 4C 01 F2 49 01 D5 4D 01 E0 4C 89 EA 49 C1 E5 20 48 C1 EA 20 49 01 D0 49 8D 54 05 00 4C 89 C8 48 C1 E0 20 48 01 D8 4C 01 C0 48 83 D5 00 45 31 C0 48 03 54 24 08 41 0F 92 C0 4C 01 C0 48 01 C7 41 0F 92 C1 49 39 C0 0F 97 C0 44 09 C8 0F B6 C0 48 01 C5 0F 85 29 02 00 00 8B 44 24 18 49 C1 E7 20 4C 01 F8 49 39 D2 41 0F 94 C0 4C 39 D8 41 0F 94 C1 45 84 C8 74 09 48 85 FF 0F 84 6C FB FF FF 49 39 D2 0F 82 F9 01 00 00 48 85 FF 0F 85 F0 01 00 00 4C 39 D8 0F 97 C0 0F B6 C0 44 21 C0 48 C1 E9 3F 31 C8 E9 92 FA FF FF B8 01 00 00 00 E9 CB FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 EA 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF EA 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF D7 4C 01 E1 48 01 E8 4C 01 D1 49 89 F2 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF D0 48 0F AF C7 49 0F AF FD 45 89 D3 49 C1 EA 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F2 49 01 C2 48 8D 04 19 49 01 C2 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 B8 01 00 00 00 4D 01 E3 4D 39 C2 0F 94 C1 75 09 4D 39 CB 0F 84 B9 F9 FF FF 4D 39 C2 0F 87 F3 FC FF FF 31 C0 4D 39 CB 0F 97 C0 21 C8 E9 E4 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D3 49 C1 E8 20 48 8B 3C F8 48 89 F8 89 FF 48 C1 E8 20 48 89 C6 48 89 C5 48 0F AF F3 48 0F AF DF 49 0F AF E8 41 89 F4 48 C1 EE 20 48 89 D9 89 DB 4C 0F AF C7 48 C1 E9 20 48 01 EE 4C 01 E1 4C 89 CD 45 89 C9 48 C1 ED 20 4C 01 C1 49 89 C8 48 C1 E1 20 49 C1 E8 20 48 01 D9 4C 01 C6 49 89 C0 4D 0F AF C1 48 0F AF C5 4C 0F AF CF 45 89 C5 49 C1 E8 20 49 89 C4 48 0F AF FD 4C 89 C8 48 C1 E8 20 4C 01 E8 48 01 F8 4B 8D 3C 20 49 89 C0 49 C1 E8 20 49 01 F8 4C 01 C1 48 83 D6 00 48 85 F6 75 47 48 C1 E0 20 45 89 C9 49 39 CA 4E 8D 04 08 B8 01 00 00 00 41 0F 94 C1 75 09 4D 39 D8 0F 84 D4 F8 FF FF 49 39 CA 72 0B 31 C0 4D 39 D8 0F 97 C0 44 21 C8 48 C1 EA 3F 31 D0 E9 B9 F8 FF FF B8 01 00 00 00 E9 12 FE FF FF B8 01 00 00 00 EB E4 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_9_0 {
	meta:
		name = "__bid128_quiet_not_less"
		size = 2208
		refs = "0153 .refptr.__bid_IDEC_glbflags 02d7 .refptr.__bid_ten2k128 06a7 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 0A 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 E9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 DA 00 00 00 4D 39 D9 75 0E 48 39 CA B8 01 00 00 00 0F 84 E6 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 5E 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 3A 01 00 00 49 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 CA 49 39 C2 0F 87 C0 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 AB 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 19 0F 85 FE 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 D9 0F 86 EB 00 00 00 84 C0 0F 84 27 01 00 00 B8 01 00 00 00 EB 1F 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 1E 4C 21 C2 B8 01 00 00 00 4C 39 C2 74 11 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 EB DE 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 49 21 D0 49 39 C8 77 BD 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 AC 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 0F 84 6D FF FF FF 4D 85 C0 75 0A 4D 85 C9 B8 01 00 00 00 74 84 48 C1 EA 3F 48 89 D0 E9 78 FF FF FF 66 0F 1F 84 00 00 00 00 00 48 85 C9 B8 01 00 00 00 0F 89 61 FF FF FF 48 89 D1 30 C0 48 C1 EA 3F 4C 21 C1 4C 39 C1 48 89 C1 48 0F 44 CA 48 89 C8 E9 43 FF FF FF 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 FC FE FF FF 84 C0 75 93 4D 85 D2 75 05 4D 85 DB 74 89 4D 85 C0 75 2D 4D 85 C9 75 28 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 03 FF FF FF 0F 1F 40 00 4D 85 D2 75 E8 4D 85 DB B8 01 00 00 00 0F 84 EC FE FF FF EB D8 48 89 C8 48 31 D0 0F 88 5A FF FF FF 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 F8 0F 84 2B 02 00 00 40 0F 9F C6 4D 39 C2 0F 93 C3 40 84 DE 74 05 4D 39 D9 76 A4 4D 39 C2 40 0F 96 C6 39 F8 0F 9C C3 40 84 DE 74 05 4D 39 D9 73 91 89 C3 29 FB 85 DB 0F 8E 19 02 00 00 83 FB 21 0F 8F 79 FF FF FF 83 FB 13 0F 8E E7 03 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 D4 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF D7 49 C1 EE 20 4C 01 F1 49 01 CD 4C 89 E9 49 C1 E5 20 4D 01 E2 48 C1 E9 20 4C 01 D1 4F 8D 54 1D 00 48 01 C1 48 83 D6 00 45 31 DB 4C 01 D5 41 0F 92 C3 4C 8B 54 24 08 49 8D 04 0B 49 01 C2 0F 92 C1 49 39 C3 0F 97 C0 09 C8 0F B6 C0 48 01 C6 0F 85 50 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 48 01 C1 4C 39 C5 41 0F 94 C3 4C 39 C9 0F 94 C0 41 84 C3 74 0E 4D 85 D2 B8 01 00 00 00 0F 84 C7 FC FF FF 4C 39 C5 0F 87 19 02 00 00 4D 85 D2 0F 85 10 02 00 00 31 C0 4C 39 C9 0F 97 C0 44 21 D8 48 C1 EA 3F 31 D0 E9 9F FC FF FF 4D 39 C2 BA 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 D9 0F 96 C2 21 C2 48 C1 E9 3F 89 D0 31 C8 E9 7B FC FF FF 29 C7 83 FF 21 0F 8F 61 FD FF FF 83 FF 13 0F 8E B5 02 00 00 8D 47 EC 4D 89 CE 45 89 C9 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 49 0F AF E9 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF F9 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF F9 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF CF 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 CE 4F 8D 4C 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 E9 4D 01 CF 48 83 54 24 08 00 49 C1 E8 20 4C 89 C5 4D 89 C4 48 0F AF EB 48 0F AF DA 4C 0F AF E6 41 89 E9 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F2 49 C1 ED 20 4C 01 E5 4C 01 EE 49 01 F1 4C 89 CE 49 C1 E1 20 48 C1 EE 20 48 01 EE 4C 89 C5 48 0F AF E8 48 0F AF C2 48 0F AF D7 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF C7 49 C1 ED 20 4C 01 EA 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 E8 48 C1 EA 20 4C 01 E0 4C 01 C2 4D 8D 04 19 4C 01 C2 48 83 D6 00 45 31 C0 49 01 C7 48 8B 44 24 08 41 0F 92 C0 4C 01 C2 48 01 D0 41 0F 92 C1 49 39 D0 0F 97 C2 44 09 CA 0F B6 D2 48 01 D6 75 30 8B 54 24 18 49 C1 E6 20 4D 39 FA 4D 8D 04 16 0F 94 C2 48 85 C0 0F 94 C0 4D 39 D8 41 0F 94 C1 44 84 CA 0F 84 EF 01 00 00 84 C0 0F 85 8C FA FF FF 31 C0 48 C1 E9 3F 31 C8 E9 A5 FA FF FF B8 01 00 00 00 E9 F1 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 EA 20 48 8B 3C D8 48 89 FD 89 FF 48 C1 ED 20 48 89 EB 48 89 EE 48 0F AF D9 48 0F AF CF 49 0F AF F2 41 89 DC 48 C1 EB 20 48 89 C8 89 C9 4C 0F AF D7 48 C1 E8 20 48 01 F3 4C 01 E0 4D 89 DC 45 89 DB 4C 89 DE 49 C1 EC 20 4C 01 D0 49 89 C2 48 C1 E0 20 49 C1 EA 20 48 01 C8 4C 01 D3 49 89 EA 48 0F AF F7 4D 0F AF D3 49 0F AF FC 49 89 F3 49 C1 EB 20 45 89 D5 49 C1 EA 20 49 0F AF EC 4D 01 DD 49 89 FB 4D 01 EB 49 8D 3C 2A 4D 89 DA 49 C1 EA 20 49 01 FA 49 01 C2 48 83 D3 00 48 85 DB 0F 85 44 FF FF FF 49 C1 E3 20 89 F6 B8 01 00 00 00 49 01 F3 4D 39 C2 0F 94 C1 75 09 4D 39 CB 0F 84 CA F9 FF FF 4D 39 C2 0F 87 17 FD FF FF 31 C0 4D 39 CB 0F 97 C0 21 C8 E9 08 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4C 89 CD 45 89 C9 48 C1 ED 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C1 4C 0F AF CE 48 0F AF F5 45 89 C5 49 C1 E8 20 4D 89 CC 48 0F AF DD 49 C1 EC 20 4D 01 EC 4C 01 E6 4C 01 C3 49 89 F0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 39 48 C1 E6 20 44 89 C8 4D 39 C2 4C 8D 0C 06 0F 94 C1 B8 01 00 00 00 75 09 4D 39 D9 0F 84 EA F8 FF FF 4D 39 C2 0F 87 37 FC FF FF 31 C0 4D 39 D9 0F 92 C0 21 C8 E9 28 FC FF FF 31 C0 E9 21 FC FF FF 84 C0 0F 84 11 FE FF FF 4D 39 FA B8 01 00 00 00 0F 87 05 FE FF FF 31 C0 4D 39 D8 0F 92 C0 21 D0 E9 F6 FD FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_46_10_0 {
	meta:
		name = "__bid128_quiet_ordered"
		size = 96
		refs = "004f .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 48 8B 49 08 4C 8B 42 08 48 BA 00 00 00 00 00 00 00 7C 48 89 C8 48 21 D0 48 39 D0 74 13 4D 89 C1 B8 01 00 00 00 49 21 D1 49 39 D1 74 03 F3 C3 90 48 BA 00 00 00 00 00 00 00 7E 48 21 D1 48 39 D1 74 0A 49 21 D0 31 C0 49 39 D0 75 E1 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_46_11_0 {
	meta:
		name = "__bid128_quiet_unordered"
		size = 96
		refs = "0052 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 48 8B 49 08 4C 8B 42 08 48 BA 00 00 00 00 00 00 00 7C 48 89 C8 48 21 D0 48 39 D0 74 13 4D 89 C1 31 C0 49 21 D1 49 39 D1 74 06 F3 C3 0F 1F 40 00 48 BA 00 00 00 00 00 00 00 7E 48 21 D1 48 39 D1 74 0D 49 21 D0 B8 01 00 00 00 49 39 D0 75 DB 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 C3 90 }
	condition:
		$1
}

rule file_46_12_0 {
	meta:
		name = "__bid128_signaling_greater"
		size = 2176
		refs = "0133 .refptr.__bid_IDEC_glbflags 02a7 .refptr.__bid_ten2k128 06a3 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 12 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 F9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4D 39 DA 75 0B 31 C0 48 39 CA 0F 84 E6 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 41 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 22 01 00 00 49 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 C9 49 39 C1 0F 87 B2 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 9D 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 1B 0F 85 E5 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 DA 0F 86 D2 00 00 00 66 90 84 C0 0F 85 B8 00 00 00 4D 85 C9 75 07 31 C0 4D 85 DB 74 18 48 F7 D1 48 C1 E9 3F 48 89 C8 EB 0C 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 49 21 D0 49 39 C8 77 CE 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 77 BD 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 3C 4D 85 C0 75 07 31 C0 4D 85 D2 74 9C 48 C1 EA 3F 48 89 D0 EB 93 0F 1F 80 00 00 00 00 48 85 C9 78 1B 49 89 D1 B8 01 00 00 00 48 C1 EA 3F 4D 21 C1 4D 39 C1 48 0F 44 C2 E9 6C FF FF FF 31 C0 E9 65 FF FF FF 66 0F 1F 84 00 00 00 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 17 FF FF FF 84 C0 75 97 4D 85 C9 75 05 4D 85 DB 74 8D 4D 85 C0 75 09 4D 85 D2 0F 84 0F FF FF FF 48 89 C8 48 31 D0 78 83 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 5C 02 00 00 4D 39 C1 77 1A 0F 94 C3 0F 85 2B 02 00 00 4D 39 DA 0F 83 22 02 00 00 0F 1F 84 00 00 00 00 00 39 C7 0F 8E CC FE FF FF 4D 39 C1 0F 82 C6 FE FF FF 4D 39 DA 76 09 4D 39 C1 0F 84 B8 FE FF FF 89 C3 29 FB 85 DB 0F 8E 34 02 00 00 83 FB 21 0F 8F A0 FE FF FF 83 FB 13 0F 8E 13 04 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 C1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 09 49 01 C3 41 0F 92 C1 48 39 C1 0F 97 C0 44 09 C8 0F B6 C0 48 01 C6 0F 85 7D 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 4C 39 C5 4C 8D 0C 08 0F 94 C1 4D 39 D1 0F 94 C0 84 C1 74 0B 31 C0 4D 85 DB 0F 84 F9 FC FF FF 4C 39 C5 0F 87 4A 02 00 00 4D 85 DB 0F 85 41 02 00 00 31 C0 4D 39 D1 0F 97 C0 21 C8 48 C1 EA 3F 31 D0 E9 D2 FC FF FF 4D 39 C1 72 11 4D 39 DA 0F 86 F7 FD FF FF 84 DB 0F 84 EF FD FF FF 39 C7 0F 8C E7 FD FF FF E9 9A FC FF FF 4D 39 C1 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 DA 0F 96 C2 21 D0 48 C1 E9 3F 31 C8 E9 8D FC FF FF 29 C7 83 FF 21 0F 8F 6D FC FF FF 83 FF 13 0F 8E C4 02 00 00 8D 47 EC 4D 89 D6 45 89 D2 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 49 0F AF EA 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF FA 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF FA 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF D7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 D6 4F 8D 54 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 EA 4D 01 D7 48 83 54 24 08 00 49 C1 E8 20 4C 89 C5 4D 89 C4 48 0F AF EB 48 0F AF DA 4C 0F AF E6 41 89 EA 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F2 49 C1 ED 20 4C 01 E5 4C 01 EE 49 01 F2 4C 89 D6 49 C1 E2 20 48 C1 EE 20 48 01 EE 4C 89 C5 48 0F AF E8 48 0F AF C2 48 0F AF D7 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF C7 49 C1 ED 20 4C 01 EA 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 E8 48 C1 EA 20 4C 01 E0 4C 01 C2 4D 8D 04 1A 4C 01 C2 4C 8B 44 24 08 48 83 D6 00 49 01 C7 0F 92 C0 0F B6 C0 48 01 C2 49 01 D0 41 0F 92 C2 48 39 D0 0F 97 C2 44 09 D2 0F B6 D2 48 01 D6 0F 85 1B 02 00 00 8B 54 24 18 49 C1 E6 20 4C 01 F2 4D 39 F9 0F 94 C0 4C 39 DA 41 0F 94 C2 44 84 D0 74 09 4D 85 C0 0F 84 5F FB FF FF 4D 39 F9 0F 82 EC 01 00 00 4D 85 C0 0F 85 E3 01 00 00 4C 39 DA 0F 97 C2 0F B6 D2 21 D0 48 F7 D1 E9 0E FE FF FF B8 01 00 00 00 E9 BF FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 E9 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF E9 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF CF 4C 01 E1 48 01 E8 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF C8 48 0F AF C7 49 0F AF FD 45 89 CB 49 C1 E9 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F1 49 01 C1 48 8D 04 19 49 01 C1 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C1 0F 94 C1 75 09 4D 39 D3 0F 84 66 FA FF FF 4D 39 C1 B8 01 00 00 00 0F 87 E7 FC FF FF 31 C0 4D 39 D3 0F 97 C0 21 C8 E9 D8 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4C 89 D5 45 89 D2 48 C1 ED 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C2 4C 0F AF D6 48 0F AF F5 45 89 C5 49 C1 E8 20 4D 89 D4 48 0F AF DD 49 C1 EC 20 4D 01 EC 4C 01 E6 4C 01 C3 49 89 F0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 42 48 C1 E6 20 44 89 D0 4D 39 C1 4C 8D 14 06 0F 94 C1 75 09 4D 39 DA 0F 84 86 F9 FF FF 4D 39 C1 B8 01 00 00 00 72 0A 31 C0 4D 39 DA 0F 97 C0 21 C8 48 F7 D2 E9 F9 FB FF FF B8 01 00 00 00 E9 1E FE FF FF B8 01 00 00 00 EB E7 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_13_0 {
	meta:
		name = "__bid128_signaling_greater_equal"
		size = 2144
		refs = "0123 .refptr.__bid_IDEC_glbflags 02a3 .refptr.__bid_ten2k128 066d .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 12 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 E9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 DA 00 00 00 4D 39 DA 75 0E 48 39 CA B8 01 00 00 00 0F 84 D3 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 2E 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 15 01 00 00 49 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 C9 49 39 C1 0F 87 9F 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 8A 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 19 0F 85 D2 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 DA 0F 86 BF 00 00 00 84 C0 0F 84 F7 00 00 00 B8 01 00 00 00 EB 0C 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 49 21 D0 49 39 C8 77 CB 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 77 BA 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 92 4D 85 C0 75 0A 4D 85 D2 B8 01 00 00 00 74 96 48 C1 EA 3F 48 89 D0 EB 8D 90 48 85 C9 B8 01 00 00 00 79 82 49 89 D1 30 C0 48 C1 EA 3F 4D 21 C1 48 89 C1 4D 39 C1 48 0F 44 CA 48 89 C8 E9 64 FF FF FF 0F 1F 84 00 00 00 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 28 FF FF FF 84 C0 75 9A 4D 85 C9 75 05 4D 85 DB 74 90 4D 85 C0 75 29 4D 85 D2 75 24 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 1C FF FF FF 4D 85 C9 75 EC 4D 85 DB B8 01 00 00 00 0F 84 09 FF FF FF EB DC 48 89 C8 48 31 D0 0F 88 65 FF FF FF 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 F8 0F 84 26 02 00 00 40 0F 9F C6 4D 39 C1 0F 93 C3 40 84 DE 74 05 4D 39 DA 76 A8 4D 39 C1 40 0F 96 C6 39 F8 0F 9C C3 40 84 DE 74 05 4D 39 DA 73 95 89 C3 29 FB 85 DB 0F 8E 12 02 00 00 83 FB 21 7F 81 83 FB 13 0F 8E E1 03 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 C1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 09 49 01 C3 41 0F 92 C1 48 39 C1 0F 97 C0 44 09 C8 0F B6 C0 48 01 C6 0F 85 4B 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 4C 39 C5 4C 8D 0C 08 0F 94 C1 4D 39 D1 0F 94 C0 84 C1 74 0E 4D 85 DB B8 01 00 00 00 0F 84 EA FC FF FF 4C 39 C5 0F 87 15 02 00 00 4D 85 DB 0F 85 0C 02 00 00 31 C0 4D 39 D1 0F 97 C0 21 C1 48 C1 EA 3F 89 C8 31 D0 E9 C1 FC FF FF 4D 39 C1 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 DA 0F 96 C2 21 D0 48 C1 E9 3F 31 C8 E9 9F FC FF FF 29 C7 83 FF 21 0F 8F 6C FD FF FF 83 FF 13 0F 8E B2 02 00 00 8D 47 EC 4D 89 D6 45 89 D2 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 49 89 DC 48 89 DF 48 C1 EE 20 4D 0F AF E2 48 89 F5 49 0F AF FE 49 0F AF EE 4D 89 E5 45 89 E4 41 89 FF 49 C1 ED 20 48 C1 EF 20 4D 01 FD 49 89 F7 48 01 EF 4D 0F AF FA 4D 01 EF 4C 89 FD 49 C1 E7 20 48 C1 ED 20 4D 01 FC 48 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 4D 0F AF EE 4C 0F AF F7 44 89 ED 49 C1 ED 20 4C 89 74 24 10 49 89 C6 4D 0F AF F2 4C 0F AF D7 4C 89 74 24 18 49 C1 EE 20 49 01 EE 4D 01 F2 4C 8B 74 24 10 4D 01 EE 4D 89 D5 49 C1 ED 20 4D 01 F5 4D 01 EC 48 83 54 24 08 00 49 C1 E8 20 4D 89 C7 4D 89 C5 4C 89 E5 4C 0F AF FB 48 0F AF DA 4C 0F AF EE 45 89 FE 4D 89 FC 49 89 DF 49 C1 EC 20 89 DB 48 0F AF F2 49 C1 EF 20 4D 01 EC 4C 01 FE 4C 01 F6 49 89 F5 48 C1 E6 20 49 C1 ED 20 4D 01 EC 4D 89 C5 4C 0F AF E8 48 0F AF C2 48 0F AF D7 45 89 EE 49 C1 ED 20 49 89 C7 89 C0 4C 0F AF C7 49 C1 EF 20 4C 01 FA 49 01 D6 4C 89 F2 49 C1 E6 20 4D 01 E8 48 C1 EA 20 4C 01 F0 4C 01 C2 4C 8D 04 1E 48 89 EB 48 8B 6C 24 08 4C 01 C2 49 83 D4 00 48 01 C3 0F 92 C0 0F B6 C0 48 01 C2 48 01 D5 41 0F 92 C0 48 39 D0 0F 97 C2 44 09 C2 0F B6 D2 49 01 D4 75 30 8B 54 24 18 49 C1 E2 20 49 39 D9 4D 8D 04 12 0F 94 C2 48 85 ED 0F 94 C0 4D 39 D8 41 0F 94 C2 44 84 D2 0F 84 E6 01 00 00 84 C0 0F 85 C0 FA FF FF 31 C0 E9 22 FE FF FF B9 01 00 00 00 E9 F4 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 E9 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF E9 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF CF 4C 01 E1 48 01 E8 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF C8 48 0F AF C7 49 0F AF FD 45 89 CB 49 C1 E9 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F1 49 01 C1 48 8D 04 19 49 01 C1 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C1 0F 94 C3 75 09 4D 39 D3 0F 84 E5 F9 FF FF 4D 39 C1 B9 01 00 00 00 0F 87 1C FD FF FF 31 C0 4D 39 D3 0F 97 C0 21 D8 89 C1 E9 0B FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4D 89 D4 45 89 D2 49 C1 EC 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C2 4C 0F AF D6 49 0F AF F4 45 89 C5 49 C1 E8 20 4C 89 D5 49 C1 EA 20 49 0F AF DC 4D 01 EA 49 01 F2 4C 01 C3 4D 89 D0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 39 49 C1 E2 20 89 ED B8 01 00 00 00 49 01 EA 4D 39 C1 0F 94 C1 75 09 4D 39 DA 0F 84 13 F9 FF FF 4D 39 C1 77 0A 31 C0 4D 39 DA 0F 92 C0 21 C8 48 C1 EA 3F 31 D0 E9 F9 F8 FF FF 31 C0 EB F1 84 C0 0F 84 1A FE FF FF 49 39 D9 B8 01 00 00 00 0F 87 35 FC FF FF 31 C0 4D 39 D8 0F 92 C0 21 D0 E9 26 FC FF FF 0F 1F 40 00 }
	condition:
		$1
}

rule file_46_14_0 {
	meta:
		name = "__bid128_signaling_greater_unordered"
		size = 2144
		refs = "0133 .refptr.__bid_IDEC_glbflags 0206 .refptr.__bid_ten2k128 0670 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 12 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 F9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4D 39 DA 75 0B 31 C0 48 39 CA 0F 84 E9 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 41 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 26 01 00 00 49 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 C9 49 39 C1 0F 87 B2 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 9D 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 1B 0F 85 C5 02 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 DA 0F 86 B2 02 00 00 66 90 84 C0 0F 85 98 02 00 00 4D 85 C9 75 07 31 C0 4D 85 DB 74 1B 48 F7 D1 48 C1 E9 3F 48 89 C8 EB 0F 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 49 21 D0 49 39 C8 77 D1 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 77 C0 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 0F 84 18 02 00 00 4D 85 C0 75 07 31 C0 4D 85 D2 74 9B 48 C1 EA 3F 48 89 D0 EB 92 0F 1F 00 48 85 C9 0F 88 F7 01 00 00 49 89 D1 B8 01 00 00 00 48 C1 EA 3F 4D 21 C1 48 89 C1 4D 39 C1 48 0F 44 CA 48 89 C8 E9 65 FF FF FF 29 C7 83 FF 21 0F 8F 42 FF FF FF 83 FF 13 0F 8E 68 05 00 00 8D 47 EC 4D 89 D6 45 89 D2 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 49 89 DC 48 89 DF 48 C1 EE 20 4D 0F AF E2 48 89 F5 49 0F AF FE 49 0F AF EE 4D 89 E5 45 89 E4 41 89 FF 49 C1 ED 20 48 C1 EF 20 4D 01 FD 49 89 F7 48 01 EF 4D 0F AF FA 4D 01 EF 4C 89 FD 49 C1 E7 20 48 C1 ED 20 4D 01 FC 48 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 4D 0F AF EE 4C 0F AF F7 44 89 ED 49 C1 ED 20 4C 89 74 24 10 49 89 C6 4D 0F AF F2 4C 0F AF D7 4C 89 74 24 18 49 C1 EE 20 49 01 EE 4D 01 F2 4C 8B 74 24 10 4D 01 EE 4D 89 D5 49 C1 ED 20 4D 01 F5 4D 01 EC 48 83 54 24 08 00 49 C1 E8 20 4D 89 C7 4D 89 C5 4C 89 E5 4C 0F AF FB 48 0F AF DA 4C 0F AF EE 45 89 FE 4D 89 FC 49 89 DF 49 C1 EC 20 89 DB 48 0F AF F2 49 C1 EF 20 4D 01 EC 4C 01 FE 4C 01 F6 49 89 F5 48 C1 E6 20 49 C1 ED 20 4D 01 EC 4D 89 C5 4C 0F AF E8 48 0F AF C2 48 0F AF D7 45 89 EE 49 C1 ED 20 49 89 C7 89 C0 4C 0F AF C7 49 C1 EF 20 4C 01 FA 49 01 D6 4C 89 F2 49 C1 E6 20 4D 01 E8 48 C1 EA 20 4C 01 F0 4C 01 C2 4C 8D 04 1E 48 89 EB 48 8B 6C 24 08 4C 01 C2 49 83 D4 00 48 01 C3 0F 92 C0 0F B6 C0 48 01 C2 48 01 D5 41 0F 92 C0 48 39 D0 0F 97 C2 44 09 C2 0F B6 D2 49 01 D4 0F 85 E8 02 00 00 8B 54 24 18 49 C1 E2 20 49 39 D9 4D 8D 04 12 0F 94 C2 48 85 ED 0F 94 C0 4D 39 D8 41 0F 94 C2 44 84 D2 0F 84 98 04 00 00 84 C0 0F 84 B8 02 00 00 66 0F 1F 44 00 00 31 C0 E9 88 FD FF FF 66 0F 1F 84 00 00 00 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 37 FD FF FF 84 C0 0F 85 B7 FD FF FF 4D 85 C9 75 09 4D 85 DB 0F 84 A9 FD FF FF 4D 85 C0 75 09 4D 85 D2 0F 84 27 FD FF FF 48 89 C8 48 31 D0 0F 88 9B FD FF FF 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 F8 0F 84 23 02 00 00 40 0F 9F C6 4D 39 C1 0F 93 C3 40 84 DE 74 09 4D 39 DA 0F 86 EF FC FF FF 4D 39 C1 40 0F 96 C6 39 F8 0F 9C C3 40 84 DE 74 09 4D 39 DA 0F 83 D8 FC FF FF 89 C3 29 FB 85 DB 0F 8E 7F FD FF FF 83 FB 21 0F 8F C0 FC FF FF 83 FB 13 0F 8E 00 02 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 C1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 09 49 01 C3 41 0F 92 C1 48 39 C1 0F 97 C0 44 09 C8 0F B6 C0 48 01 C6 75 71 8B 4C 24 18 4C 89 F8 48 C1 E0 20 4C 39 C5 4C 8D 0C 08 0F 94 C1 4D 39 D1 0F 94 C0 84 C1 74 0B 31 C0 4D 85 DB 0F 84 20 FB FF FF 4C 39 C5 77 42 4D 85 DB 75 3D 31 C0 4D 39 D1 0F 97 C0 21 C1 48 C1 EA 3F 89 C8 31 D0 E9 FF FA FF FF 4D 39 C1 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 DA 0F 96 C2 21 D0 48 C1 E9 3F 31 C8 E9 DD FA FF FF 31 C0 EB F1 B9 01 00 00 00 EB C6 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 E9 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF E9 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF CF 4C 01 E1 48 01 E8 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF C8 48 0F AF C7 49 0F AF FD 45 89 CB 49 C1 E9 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F1 49 01 C1 48 8D 04 19 49 01 C1 48 83 D5 00 48 85 ED 0F 85 4A FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C1 0F 94 C3 75 09 4D 39 D3 0F 84 79 FC FF FF 4D 39 C1 B9 01 00 00 00 0F 87 EE FE FF FF 31 C0 4D 39 D3 0F 97 C0 21 D8 89 C1 E9 DD FE FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4D 89 D4 45 89 D2 49 C1 EC 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C2 4C 0F AF D6 49 0F AF F4 45 89 C5 49 C1 E8 20 4C 89 D5 49 C1 EA 20 49 0F AF DC 4D 01 EA 49 01 F2 4C 01 C3 4D 89 D0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 39 49 C1 E2 20 89 ED 49 01 EA 4D 39 C1 0F 94 C1 75 09 4D 39 DA 0F 84 99 FB FF FF 4D 39 C1 B8 01 00 00 00 77 0A 31 C0 4D 39 DA 0F 92 C0 21 C8 48 C1 EA 3F 31 D0 E9 09 F9 FF FF 31 C0 EB F1 84 C0 0F 84 20 FE FF FF 49 39 D9 B8 01 00 00 00 0F 87 07 FE FF FF 31 C0 4D 39 D8 0F 92 C0 21 D0 E9 F8 FD FF FF 90 }
	condition:
		$1
}

rule file_46_15_0 {
	meta:
		name = "__bid128_signaling_less"
		size = 2176
		refs = "0133 .refptr.__bid_IDEC_glbflags 02bc .refptr.__bid_ten2k128 06a0 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 12 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 F9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4D 39 DA 75 0B 31 C0 48 39 CA 0F 84 E6 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 E1 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 E6 00 00 00 49 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 C9 49 39 C1 0F 87 D2 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 BD 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 1B 0F 85 E5 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 DA 0F 86 D2 00 00 00 66 90 84 C0 0F 85 B8 00 00 00 4D 85 C9 75 07 31 C0 4D 85 DB 74 18 48 C1 E9 3F 48 89 C8 EB 0F 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 31 C0 48 85 C9 79 E5 48 89 D1 B0 01 4C 21 C1 4C 39 C1 75 D8 48 F7 D2 48 C1 EA 3F 48 89 D0 EB CC 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 49 21 D0 49 39 C8 77 AE 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 77 9D 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 1C 4D 85 C0 75 AB 31 C0 4D 85 D2 0F 84 78 FF FF FF EB 9E 66 2E 0F 1F 84 00 00 00 00 00 31 C0 E9 65 FF FF FF 66 0F 1F 84 00 00 00 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 17 FF FF FF 84 C0 75 B7 4D 85 C9 75 05 4D 85 DB 74 AD 4D 85 C0 75 09 4D 85 D2 0F 84 0F FF FF FF 48 89 C8 48 31 D0 0F 88 43 FF FF FF 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 4D 02 00 00 4D 39 C1 77 0A 0F 94 C3 75 29 4D 39 DA 73 24 39 C7 0F 8E D8 FE FF FF 4D 39 C1 72 0F 4D 39 DA 76 2E 4D 39 C1 75 29 0F 1F 44 00 00 48 F7 D1 E9 BC FE FF FF 4D 39 C1 72 13 4D 39 DA 76 12 84 DB 74 0E 66 2E 0F 1F 84 00 00 00 00 00 39 C7 7D DC 89 C3 29 FB 85 DB 0F 8E 19 02 00 00 83 FB 21 0F 8F 8B FE FF FF 83 FB 13 0F 8E FB 03 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 C1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 09 49 01 C3 41 0F 92 C1 48 39 C1 0F 97 C0 44 09 C8 0F B6 C0 48 01 C6 0F 85 65 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 4C 39 C5 4C 8D 0C 08 0F 94 C1 4D 39 D1 0F 94 C0 84 C1 74 0B 31 C0 4D 85 DB 0F 84 E4 FC FF FF 4C 39 C5 0F 87 32 02 00 00 4D 85 DB 0F 85 29 02 00 00 31 C0 4D 39 D1 0F 97 C0 21 C8 48 F7 D2 48 C1 EA 3F 31 D0 E9 BA FC FF FF 4D 39 C1 BA 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 DA 0F 96 C2 21 C2 48 F7 D1 89 D0 48 C1 E9 3F 31 C8 E9 93 FC FF FF 29 C7 83 FF 21 0F 8F AC FD FF FF 83 FF 13 0F 8E C7 02 00 00 8D 47 EC 4D 89 D6 45 89 D2 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 49 0F AF EA 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF FA 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF FA 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF D7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 D6 4F 8D 54 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 EA 4D 01 D7 48 83 54 24 08 00 49 C1 E8 20 4C 89 C5 4D 89 C4 48 0F AF EB 48 0F AF DA 4C 0F AF E6 41 89 EA 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F2 49 C1 ED 20 4C 01 E5 4C 01 EE 49 01 F2 4C 89 D6 49 C1 E2 20 48 C1 EE 20 48 01 EE 4C 89 C5 48 0F AF E8 48 0F AF C2 48 0F AF D7 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF C7 49 C1 ED 20 4C 01 EA 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 E8 48 C1 EA 20 4C 01 E0 4C 01 C2 4D 8D 04 1A 4C 01 C2 4C 8B 44 24 08 48 83 D6 00 49 01 C7 0F 92 C0 0F B6 C0 48 01 C2 49 01 D0 41 0F 92 C2 48 39 D0 0F 97 C2 44 09 D2 0F B6 D2 48 01 D6 0F 85 21 02 00 00 8B 54 24 18 49 C1 E6 20 4C 01 F2 4D 39 F9 0F 94 C0 4C 39 DA 41 0F 94 C2 44 84 D0 74 09 4D 85 C0 0F 84 65 FB FF FF 4D 39 F9 0F 82 F2 01 00 00 4D 85 C0 0F 85 E9 01 00 00 4C 39 DA 0F 97 C2 0F B6 D2 21 D0 48 C1 E9 3F 31 C8 E9 A9 FA FF FF B8 01 00 00 00 E9 D7 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 E9 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF E9 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF CF 4C 01 E1 48 01 E8 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF C8 48 0F AF C7 49 0F AF FD 45 89 CB 49 C1 E9 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F1 49 01 C1 48 8D 04 19 49 01 C1 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C1 0F 94 C1 75 09 4D 39 D3 0F 84 69 FA FF FF 4D 39 C1 B8 01 00 00 00 0F 87 FF FC FF FF 31 C0 4D 39 D3 0F 97 C0 21 C8 E9 F0 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4C 89 D5 45 89 D2 48 C1 ED 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C2 4C 0F AF D6 48 0F AF F5 45 89 C5 49 C1 E8 20 4D 89 D4 48 0F AF DD 49 C1 EC 20 4D 01 EC 4C 01 E6 4C 01 C3 49 89 F0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 45 48 C1 E6 20 44 89 D0 4D 39 C1 4C 8D 14 06 0F 94 C1 75 09 4D 39 DA 0F 84 89 F9 FF FF 4D 39 C1 B8 01 00 00 00 72 0A 31 C0 4D 39 DA 0F 97 C0 21 C8 48 C1 EA 3F 31 D0 E9 D6 F8 FF FF B8 01 00 00 00 E9 18 FE FF FF B8 01 00 00 00 EB E4 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_16_0 {
	meta:
		name = "__bid128_signaling_less_equal"
		size = 2192
		refs = "0143 .refptr.__bid_IDEC_glbflags 02cc .refptr.__bid_ten2k128 06b3 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 12 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 09 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 FA 00 00 00 4D 39 DA 75 0E 48 39 CA B8 01 00 00 00 0F 84 F3 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 50 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 35 01 00 00 49 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 C9 49 39 C1 0F 87 BF 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 AA 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 19 0F 85 F2 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 DA 0F 86 DF 00 00 00 84 C0 0F 85 C7 00 00 00 4D 85 C9 75 12 4D 85 DB B8 01 00 00 00 74 24 0F 1F 84 00 00 00 00 00 48 C1 E9 3F 48 89 C8 EB 13 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 49 21 D0 49 39 C8 77 CB 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 77 BA 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 39 4D 85 C0 75 0A 4D 85 D2 B8 01 00 00 00 74 96 48 F7 D2 48 C1 EA 3F 48 89 D0 EB 8A 48 85 C9 78 19 48 89 D1 31 C0 4C 21 C1 4C 39 C1 0F 85 74 FF FF FF EB DC 66 0F 1F 44 00 00 B8 01 00 00 00 E9 62 FF FF FF 66 0F 1F 44 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 08 FF FF FF 84 C0 75 9A 4D 85 C9 75 05 4D 85 DB 74 90 4D 85 C0 75 09 4D 85 D2 0F 84 0B FF FF FF 48 89 C8 48 31 D0 78 89 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 54 02 00 00 4D 39 C1 77 0A 0F 94 C3 75 2D 4D 39 DA 73 28 39 C7 0F 8E D8 FE FF FF 4D 39 C1 72 13 4D 39 DA 76 32 4D 39 C1 75 2D 66 0F 1F 84 00 00 00 00 00 48 F7 D1 E9 B8 FE FF FF 4D 39 C1 72 13 4D 39 DA 76 12 84 DB 74 0E 66 2E 0F 1F 84 00 00 00 00 00 39 C7 7D DC 89 C3 29 FB 85 DB 0F 8E 1C 02 00 00 83 FB 21 0F 8F 87 FE FF FF 83 FB 13 0F 8E FE 03 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 C1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 09 49 01 C3 41 0F 92 C1 48 39 C1 0F 97 C0 44 09 C8 0F B6 C0 48 01 C6 0F 85 68 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 4C 39 C5 4C 8D 0C 08 0F 94 C1 4D 39 D1 0F 94 C0 84 C1 74 0E 4D 85 DB B8 01 00 00 00 0F 84 E1 FC FF FF 4C 39 C5 0F 87 32 02 00 00 4D 85 DB 0F 85 29 02 00 00 31 C0 4D 39 D1 0F 97 C0 21 C8 48 F7 D2 48 C1 EA 3F 31 D0 E9 B7 FC FF FF 4D 39 C1 BA 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 DA 0F 96 C2 21 C2 48 F7 D1 89 D0 48 C1 E9 3F 31 C8 E9 90 FC FF FF 29 C7 83 FF 21 0F 8F A9 FD FF FF 83 FF 13 0F 8E C7 02 00 00 8D 47 EC 4D 89 D6 45 89 D2 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 49 0F AF EA 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF FA 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF FA 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF D7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 D6 4F 8D 54 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 EA 4D 01 D7 48 83 54 24 08 00 49 C1 E8 20 4C 89 C5 4D 89 C4 48 0F AF EB 48 0F AF DA 4C 0F AF E6 41 89 EA 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F2 49 C1 ED 20 4C 01 E5 4C 01 EE 49 01 F2 4C 89 D6 49 C1 E2 20 48 C1 EE 20 48 01 EE 4C 89 C5 48 0F AF E8 48 0F AF C2 48 0F AF D7 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF C7 49 C1 ED 20 4C 01 EA 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 E8 48 C1 EA 20 4C 01 E0 4C 01 C2 4D 8D 04 1A 4C 01 C2 4C 8B 44 24 08 48 83 D6 00 49 01 C7 0F 92 C0 0F B6 C0 48 01 C2 49 01 D0 41 0F 92 C2 48 39 D0 0F 97 C2 44 09 D2 0F B6 D2 48 01 D6 0F 85 21 02 00 00 8B 54 24 18 49 C1 E6 20 4C 01 F2 4D 39 F9 0F 94 C0 4C 39 DA 41 0F 94 C2 44 84 D0 74 09 4D 85 C0 0F 84 62 FB FF FF 4D 39 F9 0F 82 F2 01 00 00 4D 85 C0 0F 85 E9 01 00 00 4C 39 DA 0F 97 C2 0F B6 D2 21 D0 48 C1 E9 3F 31 C8 E9 A6 FA FF FF B8 01 00 00 00 E9 D7 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 E9 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF E9 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF CF 4C 01 E1 48 01 E8 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF C8 48 0F AF C7 49 0F AF FD 45 89 CB 49 C1 E9 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F1 49 01 C1 48 8D 04 19 49 01 C1 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 B8 01 00 00 00 4D 01 E3 4D 39 C1 0F 94 C1 75 09 4D 39 D3 0F 84 CD F9 FF FF 4D 39 C1 0F 87 FF FC FF FF 31 C0 4D 39 D3 0F 97 C0 21 C8 E9 F0 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4C 89 D5 45 89 D2 48 C1 ED 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C2 4C 0F AF D6 48 0F AF F5 45 89 C5 49 C1 E8 20 4D 89 D4 48 0F AF DD 49 C1 EC 20 4D 01 EC 4C 01 E6 4C 01 C3 49 89 F0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 45 48 C1 E6 20 44 89 D0 4D 39 C1 4C 8D 14 06 0F 94 C1 B8 01 00 00 00 75 09 4D 39 DA 0F 84 ED F8 FF FF 4D 39 C1 72 0A 31 C0 4D 39 DA 0F 97 C0 21 C8 48 C1 EA 3F 31 D0 E9 D3 F8 FF FF B8 01 00 00 00 E9 18 FE FF FF B8 01 00 00 00 EB E4 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_46_17_0 {
	meta:
		name = "__bid128_signaling_less_unordered"
		size = 2176
		refs = "0133 .refptr.__bid_IDEC_glbflags 02bc .refptr.__bid_ten2k128 06a0 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 12 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 F9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4D 39 DA 75 0B 31 C0 48 39 CA 0F 84 E9 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 E1 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 E6 00 00 00 49 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 C9 49 39 C1 0F 87 D2 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 BD 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 1B 0F 85 E5 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 DA 0F 86 D2 00 00 00 66 90 84 C0 0F 85 B8 00 00 00 4D 85 C9 75 07 31 C0 4D 85 DB 74 1B 48 C1 E9 3F 48 89 C8 EB 12 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 31 C0 48 85 C9 79 E8 48 89 D1 B0 01 4C 21 C1 4C 39 C1 75 DB 48 F7 D2 48 C1 EA 3F 48 89 D0 EB CF 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 49 21 D0 49 39 C8 77 B1 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 77 A0 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 1C 4D 85 C0 75 AB 31 C0 4D 85 D2 0F 84 7B FF FF FF EB 9E 66 2E 0F 1F 84 00 00 00 00 00 31 C0 E9 68 FF FF FF 66 0F 1F 84 00 00 00 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 17 FF FF FF 84 C0 75 B7 4D 85 C9 75 05 4D 85 DB 74 AD 4D 85 C0 75 09 4D 85 D2 0F 84 0F FF FF FF 48 89 C8 48 31 D0 0F 88 43 FF FF FF 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 4D 02 00 00 4D 39 C1 77 0A 0F 94 C3 75 29 4D 39 DA 73 24 39 C7 0F 8E D8 FE FF FF 4D 39 C1 72 0F 4D 39 DA 76 2E 4D 39 C1 75 29 0F 1F 44 00 00 48 F7 D1 E9 BC FE FF FF 4D 39 C1 72 13 4D 39 DA 76 12 84 DB 74 0E 66 2E 0F 1F 84 00 00 00 00 00 39 C7 7D DC 89 C3 29 FB 85 DB 0F 8E 19 02 00 00 83 FB 21 0F 8F 8B FE FF FF 83 FB 13 0F 8E FB 03 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 C1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 09 49 01 C3 41 0F 92 C1 48 39 C1 0F 97 C0 44 09 C8 0F B6 C0 48 01 C6 0F 85 65 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 4C 39 C5 4C 8D 0C 08 0F 94 C1 4D 39 D1 0F 94 C0 84 C1 74 0B 31 C0 4D 85 DB 0F 84 E7 FC FF FF 4C 39 C5 0F 87 32 02 00 00 4D 85 DB 0F 85 29 02 00 00 31 C0 4D 39 D1 0F 97 C0 21 C8 48 F7 D2 48 C1 EA 3F 31 D0 E9 BD FC FF FF 4D 39 C1 BA 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 DA 0F 96 C2 21 C2 48 F7 D1 89 D0 48 C1 E9 3F 31 C8 E9 96 FC FF FF 29 C7 83 FF 21 0F 8F AC FD FF FF 83 FF 13 0F 8E C7 02 00 00 8D 47 EC 4D 89 D6 45 89 D2 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 49 0F AF EA 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF FA 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF FA 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF D7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 D6 4F 8D 54 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 EA 4D 01 D7 48 83 54 24 08 00 49 C1 E8 20 4C 89 C5 4D 89 C4 48 0F AF EB 48 0F AF DA 4C 0F AF E6 41 89 EA 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F2 49 C1 ED 20 4C 01 E5 4C 01 EE 49 01 F2 4C 89 D6 49 C1 E2 20 48 C1 EE 20 48 01 EE 4C 89 C5 48 0F AF E8 48 0F AF C2 48 0F AF D7 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF C7 49 C1 ED 20 4C 01 EA 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 E8 48 C1 EA 20 4C 01 E0 4C 01 C2 4D 8D 04 1A 4C 01 C2 4C 8B 44 24 08 48 83 D6 00 49 01 C7 0F 92 C0 0F B6 C0 48 01 C2 49 01 D0 41 0F 92 C2 48 39 D0 0F 97 C2 44 09 D2 0F B6 D2 48 01 D6 0F 85 21 02 00 00 8B 54 24 18 49 C1 E6 20 4C 01 F2 4D 39 F9 0F 94 C0 4C 39 DA 41 0F 94 C2 44 84 D0 74 09 4D 85 C0 0F 84 65 FB FF FF 4D 39 F9 0F 82 F2 01 00 00 4D 85 C0 0F 85 E9 01 00 00 4C 39 DA 0F 97 C2 0F B6 D2 21 D0 48 C1 E9 3F 31 C8 E9 AC FA FF FF B8 01 00 00 00 E9 D7 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 E9 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF E9 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF CF 4C 01 E1 48 01 E8 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF C8 48 0F AF C7 49 0F AF FD 45 89 CB 49 C1 E9 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F1 49 01 C1 48 8D 04 19 49 01 C1 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C1 0F 94 C1 75 09 4D 39 D3 0F 84 69 FA FF FF 4D 39 C1 B8 01 00 00 00 0F 87 FF FC FF FF 31 C0 4D 39 D3 0F 97 C0 21 C8 E9 F0 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4C 89 D5 45 89 D2 48 C1 ED 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C2 4C 0F AF D6 48 0F AF F5 45 89 C5 49 C1 E8 20 4D 89 D4 48 0F AF DD 49 C1 EC 20 4D 01 EC 4C 01 E6 4C 01 C3 49 89 F0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 45 48 C1 E6 20 44 89 D0 4D 39 C1 4C 8D 14 06 0F 94 C1 75 09 4D 39 DA 0F 84 89 F9 FF FF 4D 39 C1 B8 01 00 00 00 72 0A 31 C0 4D 39 DA 0F 97 C0 21 C8 48 C1 EA 3F 31 D0 E9 D9 F8 FF FF B8 01 00 00 00 E9 18 FE FF FF B8 01 00 00 00 EB E4 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_46_18_0 {
	meta:
		name = "__bid128_signaling_not_greater"
		size = 2192
		refs = "0143 .refptr.__bid_IDEC_glbflags 02cc .refptr.__bid_ten2k128 06b3 .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 12 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 09 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 FA 00 00 00 4D 39 DA 75 0E 48 39 CA B8 01 00 00 00 0F 84 F6 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 50 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 35 01 00 00 49 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 C9 49 39 C1 0F 87 BF 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 AA 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 19 0F 85 F2 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 DA 0F 86 DF 00 00 00 84 C0 0F 85 C7 00 00 00 4D 85 C9 75 12 4D 85 DB B8 01 00 00 00 74 27 0F 1F 84 00 00 00 00 00 48 C1 E9 3F 48 89 C8 EB 16 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 49 21 D0 49 39 C8 77 CE 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 77 BD 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 39 4D 85 C0 75 0A 4D 85 D2 B8 01 00 00 00 74 99 48 F7 D2 48 C1 EA 3F 48 89 D0 EB 8D 48 85 C9 78 19 48 89 D1 31 C0 4C 21 C1 4C 39 C1 0F 85 77 FF FF FF EB DC 66 0F 1F 44 00 00 B8 01 00 00 00 E9 65 FF FF FF 66 0F 1F 44 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 08 FF FF FF 84 C0 75 9A 4D 85 C9 75 05 4D 85 DB 74 90 4D 85 C0 75 09 4D 85 D2 0F 84 0B FF FF FF 48 89 C8 48 31 D0 78 89 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 C7 0F 84 54 02 00 00 4D 39 C1 77 0A 0F 94 C3 75 2D 4D 39 DA 73 28 39 C7 0F 8E D8 FE FF FF 4D 39 C1 72 13 4D 39 DA 76 32 4D 39 C1 75 2D 66 0F 1F 84 00 00 00 00 00 48 F7 D1 E9 B8 FE FF FF 4D 39 C1 72 13 4D 39 DA 76 12 84 DB 74 0E 66 2E 0F 1F 84 00 00 00 00 00 39 C7 7D DC 89 C3 29 FB 85 DB 0F 8E 1C 02 00 00 83 FB 21 0F 8F 87 FE FF FF 83 FB 13 0F 8E FE 03 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 C1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 09 49 01 C3 41 0F 92 C1 48 39 C1 0F 97 C0 44 09 C8 0F B6 C0 48 01 C6 0F 85 68 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 4C 39 C5 4C 8D 0C 08 0F 94 C1 4D 39 D1 0F 94 C0 84 C1 74 0E 4D 85 DB B8 01 00 00 00 0F 84 E4 FC FF FF 4C 39 C5 0F 87 32 02 00 00 4D 85 DB 0F 85 29 02 00 00 31 C0 4D 39 D1 0F 97 C0 21 C8 48 F7 D2 48 C1 EA 3F 31 D0 E9 BA FC FF FF 4D 39 C1 BA 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 DA 0F 96 C2 21 C2 48 F7 D1 89 D0 48 C1 E9 3F 31 C8 E9 93 FC FF FF 29 C7 83 FF 21 0F 8F A9 FD FF FF 83 FF 13 0F 8E C7 02 00 00 8D 47 EC 4D 89 D6 45 89 D2 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 49 0F AF EA 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF FA 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF FA 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF D7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 D6 4F 8D 54 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 EA 4D 01 D7 48 83 54 24 08 00 49 C1 E8 20 4C 89 C5 4D 89 C4 48 0F AF EB 48 0F AF DA 4C 0F AF E6 41 89 EA 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F2 49 C1 ED 20 4C 01 E5 4C 01 EE 49 01 F2 4C 89 D6 49 C1 E2 20 48 C1 EE 20 48 01 EE 4C 89 C5 48 0F AF E8 48 0F AF C2 48 0F AF D7 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF C7 49 C1 ED 20 4C 01 EA 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 E8 48 C1 EA 20 4C 01 E0 4C 01 C2 4D 8D 04 1A 4C 01 C2 4C 8B 44 24 08 48 83 D6 00 49 01 C7 0F 92 C0 0F B6 C0 48 01 C2 49 01 D0 41 0F 92 C2 48 39 D0 0F 97 C2 44 09 D2 0F B6 D2 48 01 D6 0F 85 21 02 00 00 8B 54 24 18 49 C1 E6 20 4C 01 F2 4D 39 F9 0F 94 C0 4C 39 DA 41 0F 94 C2 44 84 D0 74 09 4D 85 C0 0F 84 62 FB FF FF 4D 39 F9 0F 82 F2 01 00 00 4D 85 C0 0F 85 E9 01 00 00 4C 39 DA 0F 97 C2 0F B6 D2 21 D0 48 C1 E9 3F 31 C8 E9 A9 FA FF FF B8 01 00 00 00 E9 D7 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 E9 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF E9 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF CF 4C 01 E1 48 01 E8 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF C8 48 0F AF C7 49 0F AF FD 45 89 CB 49 C1 E9 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F1 49 01 C1 48 8D 04 19 49 01 C1 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 B8 01 00 00 00 4D 01 E3 4D 39 C1 0F 94 C1 75 09 4D 39 D3 0F 84 D0 F9 FF FF 4D 39 C1 0F 87 FF FC FF FF 31 C0 4D 39 D3 0F 97 C0 21 C8 E9 F0 FC FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4C 89 D5 45 89 D2 48 C1 ED 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C2 4C 0F AF D6 48 0F AF F5 45 89 C5 49 C1 E8 20 4D 89 D4 48 0F AF DD 49 C1 EC 20 4D 01 EC 4C 01 E6 4C 01 C3 49 89 F0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 45 48 C1 E6 20 44 89 D0 4D 39 C1 4C 8D 14 06 0F 94 C1 B8 01 00 00 00 75 09 4D 39 DA 0F 84 F0 F8 FF FF 4D 39 C1 72 0A 31 C0 4D 39 DA 0F 97 C0 21 C8 48 C1 EA 3F 31 D0 E9 D6 F8 FF FF B8 01 00 00 00 E9 18 FE FF FF B8 01 00 00 00 EB E4 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_46_19_0 {
	meta:
		name = "__bid128_signaling_not_less"
		size = 2144
		refs = "0123 .refptr.__bid_IDEC_glbflags 02a3 .refptr.__bid_ten2k128 066d .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 12 48 8B 52 08 49 89 C8 49 21 C0 49 39 C0 0F 84 E9 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 DA 00 00 00 4D 39 DA 75 0E 48 39 CA B8 01 00 00 00 0F 84 D6 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 2E 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 15 01 00 00 49 B9 FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 49 21 C9 49 39 C1 0F 87 9F 00 00 00 75 13 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C3 0F 87 8A 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 BB C0 87 AD BE 09 ED 01 00 49 21 C0 49 39 C0 49 89 D0 0F 94 C0 49 C1 E8 31 44 89 C7 49 B8 FF FF FF FF FF FF 01 00 49 21 D0 81 E7 FF 3F 00 00 49 39 D8 77 19 0F 85 D2 00 00 00 48 BB FF FF FF FF 63 8E 8D 37 49 39 DA 0F 86 BF 00 00 00 84 C0 0F 84 F7 00 00 00 B8 01 00 00 00 EB 0F 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 49 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 49 21 D0 49 39 C8 77 CE 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 77 BD 48 B8 00 00 00 00 00 00 00 60 48 89 D1 48 21 C1 48 39 C1 74 92 4D 85 C0 75 0A 4D 85 D2 B8 01 00 00 00 74 99 48 C1 EA 3F 48 89 D0 EB 90 90 48 85 C9 B8 01 00 00 00 79 85 49 89 D1 30 C0 48 C1 EA 3F 4D 21 C1 48 89 C1 4D 39 C1 48 0F 44 CA 48 89 C8 E9 67 FF FF FF 0F 1F 84 00 00 00 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 28 FF FF FF 84 C0 75 9A 4D 85 C9 75 05 4D 85 DB 74 90 4D 85 C0 75 29 4D 85 D2 75 24 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 1F FF FF FF 4D 85 C9 75 EC 4D 85 DB B8 01 00 00 00 0F 84 0C FF FF FF EB DC 48 89 C8 48 31 D0 0F 88 65 FF FF FF 48 89 C8 48 C1 E8 31 25 FF 3F 00 00 39 F8 0F 84 26 02 00 00 40 0F 9F C6 4D 39 C1 0F 93 C3 40 84 DE 74 05 4D 39 DA 76 A8 4D 39 C1 40 0F 96 C6 39 F8 0F 9C C3 40 84 DE 74 05 4D 39 DA 73 95 89 C3 29 FB 85 DB 0F 8E 12 02 00 00 83 FB 21 7F 81 83 FB 13 0F 8E E1 03 00 00 44 89 D8 4D 89 DE 44 8D 5B EC 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 06 4C 8B 74 24 10 4B 8D 44 35 00 4D 89 FD 49 C1 ED 20 4C 01 E8 48 01 C5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E0 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F0 48 89 C6 48 C1 E0 20 48 C1 EE 20 48 01 D8 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 C1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 04 09 49 01 C3 41 0F 92 C1 48 39 C1 0F 97 C0 44 09 C8 0F B6 C0 48 01 C6 0F 85 4B 02 00 00 8B 4C 24 18 4C 89 F8 48 C1 E0 20 4C 39 C5 4C 8D 0C 08 0F 94 C1 4D 39 D1 0F 94 C0 84 C1 74 0E 4D 85 DB B8 01 00 00 00 0F 84 ED FC FF FF 4C 39 C5 0F 87 15 02 00 00 4D 85 DB 0F 85 0C 02 00 00 31 C0 4D 39 D1 0F 97 C0 21 C1 48 C1 EA 3F 89 C8 31 D0 E9 C4 FC FF FF 4D 39 C1 B8 01 00 00 00 77 0D 0F 94 C0 31 D2 4D 39 DA 0F 96 C2 21 D0 48 C1 E9 3F 31 C8 E9 A2 FC FF FF 29 C7 83 FF 21 0F 8F 6C FD FF FF 83 FF 13 0F 8E B2 02 00 00 8D 47 EC 4D 89 D6 45 89 D2 49 C1 EE 20 89 D2 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 49 89 DC 48 89 DF 48 C1 EE 20 4D 0F AF E2 48 89 F5 49 0F AF FE 49 0F AF EE 4D 89 E5 45 89 E4 41 89 FF 49 C1 ED 20 48 C1 EF 20 4D 01 FD 49 89 F7 48 01 EF 4D 0F AF FA 4D 01 EF 4C 89 FD 49 C1 E7 20 48 C1 ED 20 4D 01 FC 48 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 4D 0F AF EE 4C 0F AF F7 44 89 ED 49 C1 ED 20 4C 89 74 24 10 49 89 C6 4D 0F AF F2 4C 0F AF D7 4C 89 74 24 18 49 C1 EE 20 49 01 EE 4D 01 F2 4C 8B 74 24 10 4D 01 EE 4D 89 D5 49 C1 ED 20 4D 01 F5 4D 01 EC 48 83 54 24 08 00 49 C1 E8 20 4D 89 C7 4D 89 C5 4C 89 E5 4C 0F AF FB 48 0F AF DA 4C 0F AF EE 45 89 FE 4D 89 FC 49 89 DF 49 C1 EC 20 89 DB 48 0F AF F2 49 C1 EF 20 4D 01 EC 4C 01 FE 4C 01 F6 49 89 F5 48 C1 E6 20 49 C1 ED 20 4D 01 EC 4D 89 C5 4C 0F AF E8 48 0F AF C2 48 0F AF D7 45 89 EE 49 C1 ED 20 49 89 C7 89 C0 4C 0F AF C7 49 C1 EF 20 4C 01 FA 49 01 D6 4C 89 F2 49 C1 E6 20 4D 01 E8 48 C1 EA 20 4C 01 F0 4C 01 C2 4C 8D 04 1E 48 89 EB 48 8B 6C 24 08 4C 01 C2 49 83 D4 00 48 01 C3 0F 92 C0 0F B6 C0 48 01 C2 48 01 D5 41 0F 92 C0 48 39 D0 0F 97 C2 44 09 C2 0F B6 D2 49 01 D4 75 30 8B 54 24 18 49 C1 E2 20 49 39 D9 4D 8D 04 12 0F 94 C2 48 85 ED 0F 94 C0 4D 39 D8 41 0F 94 C2 44 84 D2 0F 84 E6 01 00 00 84 C0 0F 85 C0 FA FF FF 31 C0 E9 22 FE FF FF B9 01 00 00 00 E9 F4 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 DB 89 C9 49 C1 E9 20 4D 89 DD 49 C1 ED 20 48 8B 3C D8 48 89 CB 48 89 FE 89 FF 48 C1 EE 20 48 0F AF DF 48 89 F0 48 89 F5 48 0F AF C1 49 0F AF E9 48 89 D9 89 DB 41 89 C4 48 C1 E9 20 48 C1 E8 20 4C 0F AF CF 4C 01 E1 48 01 E8 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 C5 44 89 D8 4C 0F AF C8 48 0F AF C7 49 0F AF FD 45 89 CB 49 C1 E9 20 49 89 C4 48 C1 E8 20 49 0F AF F5 49 01 C3 49 01 FB 4C 89 D8 48 C1 E8 20 49 01 F1 49 01 C1 48 8D 04 19 49 01 C1 48 83 D5 00 48 85 ED 0F 85 47 FF FF FF 49 C1 E3 20 45 89 E4 4D 01 E3 4D 39 C1 0F 94 C3 75 09 4D 39 D3 0F 84 E5 F9 FF FF 4D 39 C1 B9 01 00 00 00 0F 87 1C FD FF FF 31 C0 4D 39 D3 0F 97 C0 21 D8 89 C1 E9 0B FD FF FF 48 8B 05 ?? ?? ?? ?? 48 63 FF 89 D1 49 C1 E8 20 48 8B 34 F8 48 89 F3 89 F6 48 C1 EB 20 48 89 DF 48 89 DD 48 0F AF F9 48 0F AF CE 49 0F AF E8 41 89 FC 48 C1 EF 20 48 89 C8 89 C9 4C 0F AF C6 48 C1 E8 20 48 01 EF 4C 01 E0 4D 89 D4 45 89 D2 49 C1 EC 20 4C 01 C0 49 89 C0 48 C1 E0 20 49 C1 E8 20 48 01 C8 4C 01 C7 49 89 D8 4D 0F AF C2 4C 0F AF D6 49 0F AF F4 45 89 C5 49 C1 E8 20 4C 89 D5 49 C1 EA 20 49 0F AF DC 4D 01 EA 49 01 F2 4C 01 C3 4D 89 D0 49 C1 E8 20 49 01 D8 49 01 C0 48 83 D7 00 48 85 FF 75 39 49 C1 E2 20 89 ED B8 01 00 00 00 49 01 EA 4D 39 C1 0F 94 C1 75 09 4D 39 DA 0F 84 16 F9 FF FF 4D 39 C1 77 0A 31 C0 4D 39 DA 0F 92 C0 21 C8 48 C1 EA 3F 31 D0 E9 FC F8 FF FF 31 C0 EB F1 84 C0 0F 84 1A FE FF FF 49 39 D9 B8 01 00 00 00 0F 87 35 FC FF FF 31 C0 4D 39 D8 0F 92 C0 21 D0 E9 26 FC FF FF 90 90 90 90 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__negti2"
		size = 64
	strings:
		$1 = { 48 83 EC 18 48 8B 11 48 8B 41 08 45 31 C9 48 F7 D8 48 85 D2 41 0F 95 C1 48 F7 DA 4C 29 C8 48 89 14 24 48 89 44 24 08 66 0F 6F 04 24 48 83 C4 18 C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__extendsftf2"
		size = 544
		refs = "0165 __sfp_handle_exceptions"
	strings:
		$1 = { 48 83 EC 58 0F 29 74 24 40 48 89 C8 66 41 0F 7E C9 C7 44 24 3C 00 00 00 00 0F AE 5C 24 3C 66 0F 7E C9 66 41 0F 7E C8 C1 E9 17 41 81 E0 FF FF 7F 00 0F B6 D1 66 0F 7E C9 C1 E9 1F 41 89 CA 48 8D 4A 01 0F B6 C9 48 83 F9 01 7E 75 49 C1 E0 19 66 81 C2 80 3F 48 C7 44 24 28 00 00 00 00 4C 8B 4C 24 28 48 B9 00 00 00 00 00 00 FF FF 48 C1 E2 30 45 0F B6 D2 48 C7 44 24 20 00 00 00 00 49 C1 E2 3F 4C 21 C9 49 09 C8 48 B9 FF FF FF FF FF FF 00 80 49 21 C8 48 B9 FF FF FF FF FF FF FF 7F 4C 09 C2 48 21 CA 4C 09 D2 48 89 54 24 28 66 0F 6F 74 24 20 0F 29 30 0F 28 74 24 40 48 83 C4 58 C3 90 48 85 D2 0F 85 B7 00 00 00 4D 85 C0 0F 84 3F 01 00 00 4D 0F BD C8 48 C7 44 24 28 00 00 00 00 48 BA FF FF FF FF FF FF 00 00 49 83 F1 3F 45 0F B6 D2 48 C7 44 24 20 00 00 00 00 41 8D 49 F1 49 C1 E2 3F 49 D3 E0 48 8B 4C 24 28 49 21 D0 48 BA 00 00 00 00 00 00 FF FF 48 21 CA 48 B9 FF FF FF FF FF FF 00 80 49 09 D0 BA A9 3F 00 00 44 29 CA 49 21 C8 B9 02 00 00 00 81 E2 FF 7F 00 00 48 C1 E2 30 49 09 D0 48 BA FF FF FF FF FF FF FF 7F 49 21 D0 4D 09 D0 4C 89 44 24 28 66 0F 6F 74 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 0F 29 30 0F 28 74 24 40 48 83 C4 58 C3 0F 1F 44 00 00 4D 85 C0 74 7F 48 C7 44 24 28 00 00 00 00 48 8B 4C 24 28 49 C1 E0 19 48 BA 00 00 00 00 00 80 00 00 45 0F B6 D2 48 C7 44 24 20 00 00 00 00 49 09 D0 48 BA 00 00 00 00 00 00 FF FF 49 C1 E2 3F 48 21 CA 49 09 D0 48 BA 00 00 00 00 00 00 FF 7F 49 09 D0 48 BA FF FF FF FF FF FF FF 7F 49 21 D0 4D 09 D0 41 81 E1 00 00 40 00 4C 89 44 24 28 66 0F 6F 74 24 20 0F 85 B8 FE FF FF B9 01 00 00 00 E9 5B FF FF FF BA FF 7F 00 00 45 31 C0 E9 43 FE FF FF 31 D2 45 31 C0 E9 39 FE FF FF 90 90 90 90 90 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__floattixf"
		size = 64
		refs = "0017 .rdata"
	strings:
		$1 = { 48 83 EC 18 DF 6A 08 48 89 C8 48 8B 0A 48 89 4C 24 08 48 85 C9 D9 05 ?? ?? ?? ?? DC C9 DF 6C 24 08 78 0D DD D9 DE C1 DB 38 48 83 C4 18 C3 66 90 DE C1 DE C1 DB 38 48 83 C4 18 C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__do_global_dtors"
		size = 64
		refs = "0007 .data"
	strings:
		$1 = { 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 8B 10 48 85 D2 74 1C 48 83 C0 08 48 89 05 ?? ?? ?? ?? FF D2 48 8B 05 ?? ?? ?? ?? 48 8B 10 48 85 D2 75 E4 48 83 C4 28 C3 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "__do_global_ctors"
		size = 96
		refs = "0009 .refptr.__CTOR_LIST__ 0038 atexit"
	strings:
		$1 = { 56 53 48 83 EC 28 48 8B 35 ?? ?? ?? ?? 48 8B 06 48 83 F8 FF 74 2A 85 C0 89 C3 74 0E 0F 1F 40 00 89 D8 FF 14 C6 83 EB 01 75 F6 48 8D 0D 8F FF FF FF 48 83 C4 28 5B 5E E9 ?? ?? ?? ?? 0F 1F 40 00 31 C0 EB 03 48 89 D0 48 8D 50 01 48 83 3C D6 00 75 F2 EB C2 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_52_2_0 {
	meta:
		name = "__main"
		size = 32
		refs = "0002 .bss"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 74 06 F3 C3 0F 1F 40 00 C7 05 ?? ?? ?? ?? 01 00 00 00 EB 84 90 90 90 90 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__floatditf"
		size = 288
	strings:
		$1 = { 48 83 EC 18 48 85 D2 48 89 C8 0F 84 00 01 00 00 49 89 D1 48 89 D1 41 BA 3E 40 00 00 49 C1 E9 3F 48 F7 D9 45 84 C9 48 0F 45 D1 48 0F BD CA 48 83 F1 3F 41 29 CA B9 6F 40 00 00 45 89 D0 4D 63 D2 4C 29 D1 48 83 F9 3F 0F 8E 93 00 00 00 B9 2F 40 00 00 45 31 D2 44 29 C1 66 41 81 E0 FF 7F 48 D3 E2 48 B9 FF FF FF FF FF FF 00 00 48 21 CA 48 C7 44 24 08 00 00 00 00 48 8B 4C 24 08 49 C1 E0 30 4C 89 14 24 49 BA FF FF FF FF FF FF 00 00 49 21 D2 48 BA 00 00 00 00 00 00 FF FF 48 21 CA 48 B9 FF FF FF FF FF FF 00 80 4C 09 D2 48 21 CA 48 B9 FF FF FF FF FF FF FF 7F 4C 09 C2 45 0F B6 C1 49 C1 E0 3F 48 21 CA 4C 09 C2 48 89 54 24 08 66 0F 6F 04 24 0F 29 00 48 83 C4 18 C3 0F 1F 44 00 00 B9 6F 40 00 00 49 89 D2 44 29 C1 49 D3 E2 41 8D 88 D1 BF FF FF 66 41 81 E0 FF 7F 48 D3 EA 48 B9 FF FF FF FF FF FF 00 00 48 21 CA E9 5E FF FF FF 45 31 C9 45 31 C0 31 D2 45 31 D2 E9 4E FF FF FF }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__floatsitf"
		size = 208
	strings:
		$1 = { 48 83 EC 18 85 D2 48 89 C8 0F 84 B3 00 00 00 41 89 D1 89 D1 41 B8 3E 40 00 00 41 C1 E9 1F F7 D9 45 84 C9 0F 45 D1 89 D2 48 0F BD CA 48 83 F1 3F 41 29 C8 B9 2F 40 00 00 44 29 C1 66 41 81 E0 FF 7F 48 D3 E2 48 B9 FF FF FF FF FF FF 00 00 48 21 CA 48 C7 44 24 08 00 00 00 00 4C 8B 54 24 08 48 B9 FF FF FF FF FF FF 00 00 48 21 D1 48 BA 00 00 00 00 00 00 FF FF 49 C1 E0 30 45 0F B6 C9 48 C7 04 24 00 00 00 00 4C 21 D2 49 C1 E1 3F 48 09 CA 48 B9 FF FF FF FF FF FF 00 80 48 21 CA 48 B9 FF FF FF FF FF FF FF 7F 4C 09 C2 48 21 CA 4C 09 CA 48 89 54 24 08 66 0F 6F 04 24 0F 29 00 48 83 C4 18 C3 45 31 C9 45 31 C0 31 D2 EB 85 90 90 90 90 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__bid32_to_bid64"
		size = 288
		refs = "0114 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 89 C8 41 89 C8 25 00 00 00 60 41 81 E0 00 00 00 80 3D 00 00 00 60 74 4C 89 CA 89 C8 C1 EA 17 25 FF FF 7F 00 0F B6 D2 75 37 41 89 C9 31 C0 41 81 E1 00 00 00 78 41 81 F9 00 00 00 78 0F 84 BD 00 00 00 81 C2 29 01 00 00 49 C1 E0 20 4C 09 C0 48 C1 E2 35 48 09 D0 F3 C3 0F 1F 84 00 00 00 00 00 89 C0 EB DE 89 C8 89 CA 25 00 00 00 78 3D 00 00 00 78 74 2C 81 E2 FF FF 1F 00 81 CA 00 00 80 00 81 FA 7F 96 98 00 89 D0 BA 00 00 00 00 48 0F 47 C2 C1 E9 15 0F B6 D1 EB A9 0F 1F 80 00 00 00 00 81 E2 FF FF 0F 00 89 C8 41 89 C8 25 00 00 00 FE 41 81 E0 FF FF 0F FE 81 FA 40 42 0F 00 89 CA 44 0F 43 C0 89 C8 81 E2 00 00 00 7C 25 00 00 00 F8 81 FA 00 00 00 78 44 0F 44 C0 48 B8 00 00 00 00 00 00 00 FC 4C 89 C2 41 81 E0 FF FF 0F 00 4D 69 C0 00 CA 9A 3B 48 C1 E2 20 48 21 D0 4C 09 C0 81 E1 00 00 00 7E 81 F9 00 00 00 7E 0F 85 45 FF FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 01 C3 0F 1F 40 00 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__bid64_to_bid32"
		size = 1872
		refs = "0068 .refptr.__bid_IDEC_glbround 00d1 .refptr.__bid_IDEC_glbflags 01f2 .refptr.__bid_estimate_decimal_digits 0216 .refptr.__bid_power10_index_binexp 025d .refptr.__bid_round_const_table 0280 .refptr.__bid_reciprocals10_64 02e5 .refptr.__bid_short_recip_scale 06bf .refptr.__bid_power10_table_128"
	strings:
		$1 = { 41 56 41 55 41 54 55 57 56 53 48 B8 00 00 00 00 00 00 00 60 49 BA 00 00 00 00 00 00 00 80 48 89 CA 49 21 CA 48 21 C2 48 39 C2 0F 84 60 01 00 00 49 89 C9 49 B8 FF FF FF FF FF FF 1F 00 49 C1 E9 35 41 81 E1 FF 03 00 00 49 21 C8 0F 84 BF 00 00 00 49 81 F8 7F 96 98 00 41 8D 89 D7 FE FF FF 0F 87 86 01 00 00 48 8B 05 ?? ?? ?? ?? 49 C1 EA 20 44 8B 18 44 89 D0 81 F9 BF 00 00 00 41 89 C9 0F 86 DC 00 00 00 85 C9 0F 88 E1 02 00 00 49 81 F8 3F 42 0F 00 76 12 EB 36 0F 1F 84 00 00 00 00 00 81 F9 BF 00 00 00 7E 14 4F 8D 0C 00 83 E9 01 4F 8D 04 C1 49 81 F8 3F 42 0F 00 76 E4 81 F9 BF 00 00 00 41 B9 BF 00 00 00 0F 84 93 00 00 00 48 8B 15 ?? ?? ?? ?? 89 C1 81 C9 00 00 00 78 83 0A 28 41 83 FB 02 0F 84 0B 06 00 00 0D 7F 96 F8 77 41 83 FB 03 74 61 41 83 FB 01 89 C8 75 59 4D 85 D2 B8 7F 96 F8 77 0F 45 C1 EB 4C 66 0F 1F 44 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 67 04 00 00 44 89 C9 45 31 DB 81 E9 29 01 00 00 78 15 89 C8 41 BB 00 00 80 5F C1 E0 17 81 F9 BF 00 00 00 44 0F 4E D8 4C 89 D0 48 C1 E8 20 44 09 D8 5B 5E 5F 5D 41 5C 41 5D 41 5E C3 49 81 F8 FF FF 7F 00 0F 86 8F 03 00 00 41 C1 E1 15 0D 00 00 00 60 41 81 E0 FF FF 1F 00 44 09 C8 44 09 C0 5B 5E 5F 5D 41 5C 41 5D 41 5E C3 90 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 87 03 00 00 49 B8 FF FF FF FF FF FF 07 00 48 B8 00 00 00 00 00 00 20 00 49 21 C8 48 C1 E9 33 49 09 C0 41 89 C9 48 B8 FF FF C0 6F F2 86 23 00 41 81 E1 FF 03 00 00 49 39 C0 41 8D 89 D7 FE FF FF 0F 87 3E FF FF FF 66 0F EF C0 48 8B 05 ?? ?? ?? ?? F3 49 0F 2A C0 66 41 0F 7E C1 41 C1 E9 17 45 0F B6 C9 41 83 E9 7F 4D 63 C9 46 8B 1C 88 48 8B 05 ?? ?? ?? ?? 41 8D 53 F9 41 83 EB 06 4E 39 04 C8 48 8B 05 ?? ?? ?? ?? 41 0F 46 D3 44 8B 18 4D 85 D2 44 89 DB 74 0D 41 8D 43 FF 83 F8 01 0F 86 E7 03 00 00 44 8D 0C 0A 41 8D 41 07 83 F8 06 0F 86 D8 00 00 00 48 8B 3D ?? ?? ?? ?? BE 20 00 00 00 48 63 EB 48 8D 44 ED 00 48 63 D2 48 8D 44 45 00 48 01 D0 4C 03 04 C7 48 8B 05 ?? ?? ?? ?? 48 8B 3C D0 4D 89 C6 45 89 C5 49 C1 EE 20 89 F9 4D 89 F0 48 89 F8 4C 0F AF C1 48 C1 E8 20 49 0F AF CD 4C 0F AF F0 49 89 CC 44 89 C1 49 C1 E8 20 4C 89 E5 4D 01 F0 48 C1 ED 20 48 01 CD 4C 89 E9 48 0F AF C8 48 8D 44 0D 00 44 89 E1 48 89 C5 48 C1 E0 20 48 C1 ED 20 4C 8D 24 08 4C 01 C5 4C 8B 05 ?? ?? ?? ?? 45 8B 2C 90 49 89 E8 44 89 E9 49 D3 E8 85 DB 0F 85 94 01 00 00 B9 40 00 00 00 44 29 E9 41 F6 C0 01 0F 84 C3 02 00 00 48 D3 E5 4C 39 E7 0F 97 C2 48 85 ED 0F 94 C0 20 D0 0F 84 B5 02 00 00 49 83 E8 01 89 C2 E9 AA 02 00 00 41 83 F9 FF 0F 84 56 03 00 00 48 8B 3D ?? ?? ?? ?? BE 30 00 00 00 48 63 EB 89 CA 45 31 C9 F7 DA E9 12 FF FF FF 66 0F 1F 84 00 00 00 00 00 85 C9 0F 89 66 FD FF FF 41 B8 40 42 0F 00 83 F9 F9 0F 8C 89 02 00 00 4D 85 D2 74 0D 41 8D 53 FF 83 FA 01 0F 86 95 03 00 00 49 63 D3 F7 D9 4C 8D 0C D2 48 63 C9 4A 8D 14 4A 4C 8B 0D ?? ?? ?? ?? 48 01 CA 4D 03 04 D1 4C 8B 0D ?? ?? ?? ?? 49 8B 1C C9 4C 89 C2 45 89 C0 48 C1 EA 20 41 89 DA 48 89 D7 49 89 D9 49 0F AF FA 49 C1 E9 20 48 89 D6 4D 0F AF D0 49 0F AF F1 89 FD 48 C1 EF 20 4C 89 D2 45 89 D2 4D 0F AF C8 48 C1 EA 20 49 89 F8 48 01 EA 49 01 F0 4C 01 CA 48 89 D6 48 C1 E2 20 48 C1 EE 20 4C 01 D2 4C 01 C6 4C 8B 05 ?? ?? ?? ?? 48 89 F7 45 8B 14 88 44 89 D1 48 D3 EF 45 85 DB 0F 85 AD 02 00 00 40 F6 C7 01 74 24 B9 40 00 00 00 49 C7 C0 FF FF FF FF 44 29 D1 49 D3 E8 48 39 D3 76 0D 4C 85 C6 0F 94 C1 80 F9 01 48 83 D7 FF 4C 8B 0D ?? ?? ?? ?? 45 8B 01 41 F6 C0 20 0F 85 83 02 00 00 B9 40 00 00 00 44 29 D1 48 D3 E6 48 B9 00 00 00 00 00 00 00 80 48 39 CE 0F 85 02 02 00 00 48 39 D3 0F 86 F9 01 00 00 09 F8 E9 C4 FC FF FF BA 40 00 00 00 44 29 EA 89 D1 48 D3 E5 83 FB 03 74 71 83 FB 04 0F 84 97 02 00 00 83 FB 01 74 63 31 C0 49 01 FC 0F 92 C0 48 D3 ED 44 89 E9 48 01 E8 48 D3 E8 48 85 C0 74 55 0F 1F 44 00 00 49 C1 EA 20 49 81 F8 7F 96 98 00 44 89 D0 0F 86 58 02 00 00 41 8D 49 01 41 B8 40 42 0F 00 81 F9 BF 00 00 00 41 89 C9 0F 87 63 FE FF FF 41 09 C0 41 C1 E1 17 44 89 C0 44 09 C8 5B 5E 5F 5D 41 5C 41 5D 41 5E C3 48 85 ED 75 06 4C 39 E7 77 B1 90 48 8B 05 ?? ?? ?? ?? 09 30 EB A5 0F 1F 44 00 00 48 B8 FF FF FF FF FF FF 03 00 49 B8 FF FF FF FF FF FF 03 FE 48 BA FF 7F C6 A4 7E 8D 03 00 48 21 C8 49 21 C8 48 39 D0 76 0D 49 B8 00 00 00 00 00 00 00 FE 49 21 C8 48 B8 00 00 00 00 00 00 00 7C 48 BA 00 00 00 00 00 00 00 78 48 21 C8 48 39 D0 75 0E 49 B8 00 00 00 00 00 00 00 F8 49 21 C8 90 44 89 C0 BA 83 4B 04 00 C1 E8 09 F7 E2 4C 89 C0 49 B8 00 00 00 00 00 00 00 7E 48 C1 E8 20 4C 21 C1 25 00 00 00 FC C1 EA 07 09 D0 4C 39 C1 0F 85 92 FB FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 01 E9 83 FB FF FF 4C 39 E7 0F 97 C2 48 D3 E5 48 B8 00 00 00 00 00 00 00 80 48 39 C5 0F 85 31 FF FF FF 84 D2 0F 85 D9 FE FF FF E9 24 FF FF FF 0F 1F 40 00 48 8B 15 ?? ?? ?? ?? 83 0A 30 85 C0 0F 84 F3 00 00 00 41 83 FB 01 0F 85 E9 00 00 00 B8 01 00 00 80 E9 30 FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 BB 03 00 00 00 44 29 DB E9 0C FC FF FF B9 40 00 00 00 44 29 D1 48 D3 E6 41 83 FB 03 0F 84 DC 00 00 00 41 83 FB 04 0F 84 13 FE FF FF 41 83 FB 01 0F 84 C8 00 00 00 48 01 DA 0F 92 C2 48 D3 EE 44 89 D1 0F B6 D2 48 01 F2 48 D3 EA 48 85 D2 0F 85 07 FE FF FF 41 83 C8 30 09 F8 45 89 01 E9 C4 FA FF FF 48 63 EB 48 8B 3D ?? ?? ?? ?? 48 63 C2 4C 8D 4C ED 00 4E 8D 4C 4D 00 4C 01 C8 4D 89 C1 4C 03 0C C7 8D 42 07 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 3B 08 19 F6 83 E6 10 83 C6 20 E9 78 FC FF FF 4C 8B 0D ?? ?? ?? ?? 45 8B 01 41 F6 C0 20 0F 84 56 FF FF FF 41 83 C8 10 09 F8 45 89 01 E9 61 FA FF FF 0D 7F 96 F8 77 4D 85 D2 0F 44 C1 E9 51 FA FF FF 85 C0 0F 85 49 FA FF FF 41 83 FB 02 BA 01 00 00 00 0F 44 C2 E9 38 FA FF FF BA 03 00 00 00 44 29 DA 41 89 D3 E9 5B FC FF FF 48 85 F6 0F 84 4B FD FF FF E9 48 FF FF FF 44 89 C9 E9 32 F9 FF FF 4C 39 E7 0F 97 C2 E9 8D FE FF FF 90 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "__enable_execute_stack"
		size = 80
		refs = "0015 __imp_VirtualQuery 0034 __imp_VirtualProtect 0040 abort"
	strings:
		$1 = { 53 48 83 EC 50 41 B8 30 00 00 00 48 8D 5C 24 20 48 89 DA FF 15 ?? ?? ?? ?? 48 85 C0 74 21 48 8B 54 24 38 48 8B 4C 24 20 4C 8D 4B 24 41 B8 40 00 00 00 FF 15 ?? ?? ?? ?? 90 48 83 C4 50 5B C3 E8 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__paritydi2"
		size = 64
	strings:
		$1 = { 48 89 C8 48 C1 E8 20 48 31 C1 48 89 C8 48 C1 E8 10 48 31 C1 48 89 C8 48 C1 E8 08 48 31 C1 48 89 C8 48 C1 E8 04 48 31 C1 B8 96 69 00 00 83 E1 0F D3 F8 83 E0 01 C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__divsc3"
		size = 784
		refs = "0017 .rdata"
	strings:
		$1 = { 48 83 EC 38 0F 29 34 24 0F 29 7C 24 10 44 0F 29 44 24 20 F3 0F 10 35 ?? ?? ?? ?? 0F 28 E2 0F 28 EB 0F 54 E6 0F 54 EE 0F 2E EC 76 69 0F 28 EA 0F 28 FA 0F 28 E0 F3 0F 5E EB F3 0F 59 FD F3 0F 59 E5 F3 0F 59 E9 F3 0F 58 FB F3 0F 58 E1 F3 0F 5C E8 F3 0F 5E E7 F3 0F 5E EF 0F 2E E4 7A 72 66 0F 7E E2 48 B9 00 00 00 00 FF FF FF FF 48 21 C8 0F 28 34 24 89 D2 48 09 D0 66 0F 7E EA 89 C0 0F 28 7C 24 10 48 C1 E2 20 44 0F 28 44 24 20 48 09 D0 48 83 C4 38 C3 0F 28 EB 0F 28 FB 0F 28 E1 F3 0F 5E EA 44 0F 28 C1 F3 0F 59 FD F3 0F 59 E5 F3 0F 59 E8 F3 0F 58 FA F3 0F 58 E0 F3 44 0F 5C C5 F3 0F 5E E7 41 0F 28 E8 F3 0F 5E EF 0F 2E E4 7B 8E 0F 2E ED 7B 89 BA 00 00 00 00 66 0F EF FF 0F 2E D7 0F 9B C0 0F 45 C2 84 C0 74 38 0F 2E DF 0F 9B C0 0F 44 D0 84 D2 74 2B 0F 2E C0 7A 21 0F 54 15 ?? ?? ?? ?? 0F 56 15 ?? ?? ?? ?? 0F 28 EA F3 0F 59 C5 F3 0F 59 E9 0F 28 E0 E9 40 FF FF FF 0F 2E C9 7B DA 44 0F 28 C0 F3 44 0F 5C C0 45 0F 2E C0 0F 9A C2 0F 2E C0 0F 9B C0 20 D0 0F 85 E7 00 00 00 44 0F 28 C1 F3 44 0F 5C C1 45 0F 2E C0 0F 8A CB 00 00 00 44 0F 28 C2 F3 44 0F 5C C2 45 0F 2E C0 0F 9A C1 0F 2E D2 0F 9B C0 20 C8 75 1E 44 0F 28 C3 F3 44 0F 5C C3 45 0F 2E C0 0F 8B DD FE FF FF 0F 2E DB 0F 8A D4 FE FF FF 31 C0 84 D2 0F 85 CA FE FF FF 44 0F 28 C1 F3 44 0F 5C C1 45 0F 2E C0 0F 8A B7 FE FF FF 84 C0 0F 85 2A 01 00 00 0F 28 E7 44 0F 28 C2 F3 0F 10 2D ?? ?? ?? ?? 0F 54 E6 44 0F 54 C5 41 0F 56 E0 0F 28 D4 0F 28 E3 F3 0F 5C E3 0F 2E E4 0F 8A E7 00 00 00 0F 28 E7 44 0F 28 C3 44 0F 54 C5 0F 55 EC 0F 28 E1 F3 0F 59 CA 41 0F 56 E8 0F 28 DD 0F 28 E8 F3 0F 59 E3 F3 0F 59 EA F3 0F 59 D8 F3 0F 58 E5 0F 28 E9 F3 0F 5C EB F3 0F 59 E7 F3 0F 59 EF E9 3F FE FF FF 0F 2E C9 0F 8A 2C FF FF FF 44 0F 28 C2 F3 44 0F 5C C2 45 0F 2E C0 0F 8A 22 FF FF FF 44 0F 28 C3 F3 44 0F 5C C3 45 0F 2E C0 0F 8A 29 FF FF FF 84 C0 0F 85 9F 00 00 00 44 0F 28 C7 0F 28 E0 F3 0F 10 2D ?? ?? ?? ?? 0F 28 C1 0F 54 E5 F3 0F 5C C1 44 0F 54 C6 44 0F 56 C4 0F 2E C0 7A 6A 0F 28 C1 41 0F 28 E0 0F 54 C5 0F 55 EF F3 0F 59 E2 0F 56 E8 0F 28 CD 0F 28 C1 F3 0F 59 CA F3 0F 59 C3 F3 41 0F 59 D8 0F 28 E9 F3 0F 58 E0 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5C EB F3 0F 59 E0 F3 0F 59 E8 E9 9B FD FF FF 0F 2E DB 0F 8A 10 FF FF FF F3 0F 10 25 ?? ?? ?? ?? E9 06 FF FF FF F3 0F 10 25 ?? ?? ?? ?? E9 CC FE FF FF 0F 2E C9 7A 91 F3 0F 10 3D ?? ?? ?? ?? EB 87 F3 44 0F 10 05 ?? ?? ?? ?? E9 57 FF FF FF 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__bid_unordtd2"
		size = 64
		refs = "0031 __bid128_quiet_unordered"
	strings:
		$1 = { 48 83 EC 48 48 8B 02 48 8B 52 08 4C 8B 09 4C 8B 51 08 48 8D 4C 24 30 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 4C 89 4C 24 30 4C 89 54 24 38 E8 ?? ?? ?? ?? 48 98 48 83 C4 48 C3 90 90 90 90 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__bid_gttd2"
		size = 64
		refs = "0031 __bid128_quiet_greater"
	strings:
		$1 = { 48 83 EC 48 48 8B 02 48 8B 52 08 4C 8B 09 4C 8B 51 08 48 8D 4C 24 30 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 4C 89 4C 24 30 4C 89 54 24 38 E8 ?? ?? ?? ?? 48 98 48 83 C4 48 C3 90 90 90 90 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "__bid_netd2"
		size = 64
		refs = "0031 __bid128_quiet_not_equal"
	strings:
		$1 = { 48 83 EC 48 48 8B 02 48 8B 52 08 4C 8B 09 4C 8B 51 08 48 8D 4C 24 30 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 4C 89 4C 24 30 4C 89 54 24 38 E8 ?? ?? ?? ?? 48 98 48 83 C4 48 C3 90 90 90 90 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__fixxfti"
		size = 96
		refs = "0016 __fixunsxfti"
	strings:
		$1 = { 48 83 EC 48 DB 29 D9 EE DF E9 77 14 DB 7C 24 30 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 48 C3 90 48 8D 4C 24 30 D9 E0 DB 7C 24 30 E8 ?? ?? ?? ?? 0F 29 44 24 20 48 8B 44 24 20 48 8B 54 24 28 48 F7 D8 48 83 D2 00 48 89 44 24 20 48 F7 DA 48 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 48 C3 90 90 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__gcc_bcmp"
		size = 80
	strings:
		$1 = { 4D 85 C0 74 34 44 0F B6 09 44 0F B6 12 49 83 E8 01 31 C0 45 38 D1 74 1C EB 26 66 0F 1F 44 00 00 44 0F B6 4C 01 01 48 83 C0 01 44 0F B6 14 02 45 38 D1 75 0C 4C 39 C0 75 E7 31 C0 C3 0F 1F 40 00 41 0F B6 C1 44 29 D0 C3 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "__bid_trunctdxf"
		size = 64
		refs = "0024 __bid128_to_binary80"
	strings:
		$1 = { 53 48 83 EC 40 48 8B 02 48 8B 52 08 48 89 CB 48 8D 4C 24 30 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? DB 6C 24 30 48 89 D8 DB 3B 48 83 C4 40 5B C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__bid64_quiet_equal"
		size = 608
		refs = "0101 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 53 48 B8 00 00 00 00 00 00 00 7C 49 89 C8 49 21 C0 49 39 C0 0F 84 C8 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 B9 00 00 00 48 39 D1 0F 84 DE 00 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 25 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 86 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 AD 00 00 00 48 8D 1C 09 49 BB FF FF FF FF FF FF 1F 00 45 31 C0 49 21 CB 48 C1 EB 36 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 EC 00 00 00 4C 8D 0C 12 49 C1 E9 36 4D 89 CA 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 4D 85 DB 0F 84 9B 00 00 00 45 84 C0 0F 85 92 00 00 00 31 C0 4D 85 C9 0F 85 0B 01 00 00 0F 1F 80 00 00 00 00 5B C3 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 0A 4C 21 C2 31 C0 4C 39 C2 75 E2 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B C3 0F 1F 40 00 B8 01 00 00 00 5B C3 66 0F 1F 84 00 00 00 00 00 49 BB FF FF FF FF FF FF 07 00 48 8D 1C CD 00 00 00 00 4C 89 D8 49 BB 00 00 00 00 00 00 20 00 48 21 C8 48 C1 EB 36 49 09 C3 48 B8 FF FF C0 6F F2 86 23 00 49 39 C3 41 0F 97 C0 E9 2C FF FF FF 90 31 C0 4D 85 C9 0F 94 C0 5B C3 66 0F 1F 44 00 00 49 89 D0 31 C0 4D 21 C8 4D 39 C8 0F 85 5F FF FF FF 48 89 C8 48 31 D0 48 F7 D0 48 C1 E8 3F 5B C3 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 87 90 00 00 00 4C 8D 14 D5 00 00 00 00 49 C1 EA 36 4D 85 DB 74 0F 45 84 C0 74 0E 66 2E 0F 1F 84 00 00 00 00 00 31 C0 5B C3 48 31 D1 78 F7 44 39 D3 7E 11 4C 89 D8 4D 89 CB 49 89 C1 89 D8 44 89 D3 41 89 C2 44 89 D2 31 C0 29 DA 83 FA 0F 0F 8F D1 FE FF FF 85 D2 7E 33 4F 8D 0C 89 49 B8 FF FF C0 6F F2 86 23 00 4D 01 C9 4D 39 C1 76 13 E9 B2 FE FF FF 66 90 4F 8D 0C 89 4D 01 C9 4D 39 C1 77 A4 83 C0 01 0F BE C8 39 CA 7F EA 31 C0 4D 39 D9 0F 94 C0 5B C3 4D 85 DB 0F 94 C0 41 09 C0 41 0F B6 C0 5B C3 90 }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "__bid64_quiet_greater"
		size = 848
		refs = "012e .rdata 01c5 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 56 53 48 B8 00 00 00 00 00 00 00 7C 49 89 C8 49 21 C0 49 39 C0 0F 84 88 01 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 79 01 00 00 48 39 D1 0F 84 DD 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 34 02 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 13 02 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 A1 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 29 01 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 0F 84 9A 01 00 00 45 84 D2 0F 85 91 01 00 00 4D 85 C0 0F 84 79 01 00 00 48 89 CE 48 31 D6 0F 88 87 01 00 00 45 39 CB 0F 9F C2 7E 09 4C 39 C0 0F 87 5C 01 00 00 45 39 CB 7D 09 4C 39 C0 0F 82 51 01 00 00 45 89 DA 45 29 CA 41 83 FA 0F 0F 8F 3E 01 00 00 45 29 D9 41 83 F9 0F 0F 8F 34 01 00 00 84 D2 0F 84 A1 01 00 00 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 48 89 C2 89 C0 48 C1 EA 20 4F 8B 0C D1 4C 89 CB 45 89 C9 4D 89 CA 48 C1 EB 20 4C 0F AF C8 4C 0F AF D2 48 0F AF C3 4D 89 CB 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF D3 49 01 F3 4C 01 D8 4C 01 D2 49 89 C2 49 C1 EA 20 4C 01 D2 0F 85 B9 01 00 00 48 C1 E0 20 45 89 C9 4C 01 C8 4C 39 C0 74 7B 0F 97 C0 0F B6 C0 48 C1 E9 3F 31 C8 EB 1C 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 0D 4C 21 C2 31 C0 4C 39 C2 74 03 5B 5E C3 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B 5E C3 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 0F 86 B2 00 00 00 48 85 C0 74 0D 45 84 D2 74 4C 0F 1F 84 00 00 00 00 00 31 C0 5B 5E C3 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 3B FE FF FF 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 5C FF FF FF 31 C0 4D 85 C0 0F 84 51 FF FF FF 48 C1 EA 3F 48 89 D0 5B 5E C3 0F 1F 84 00 00 00 00 00 48 85 C9 78 8B 49 89 D1 B8 01 00 00 00 48 C1 EA 3F 4D 21 C1 48 89 C1 4D 39 C1 48 0F 44 CA 48 89 C8 E9 19 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 74 AD 45 84 D2 0F 84 11 FE FF FF EB A2 48 8D 15 ?? ?? ?? ?? 4D 63 C9 4D 89 C2 45 89 C0 49 C1 EA 20 4E 8B 0C CA 4C 89 CA 45 89 C9 4D 89 CB 48 C1 EA 20 4D 0F AF C8 4D 0F AF DA 4C 0F AF D2 4C 89 CB 44 89 DE 48 C1 EB 20 49 C1 EB 20 49 0F AF D0 48 01 F3 4F 8D 04 13 48 01 DA 49 89 D2 49 C1 EA 20 4D 01 D0 75 24 48 C1 E2 20 45 89 C9 4C 01 CA 48 39 D0 0F 85 5D FE FF FF 31 C0 E9 D3 FE FF FF B8 01 00 00 00 E9 52 FE FF FF 31 C0 E9 4B FE FF FF }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "__bid64_quiet_greater_equal"
		size = 896
		refs = "0133 .refptr.__bid_IDEC_glbflags 027a .rdata"
	strings:
		$1 = { 56 53 48 B8 00 00 00 00 00 00 00 7C 49 89 C8 49 21 C0 49 39 C0 0F 84 F5 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 E6 00 00 00 48 39 D1 0F 84 4D 01 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 B4 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 94 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 1C 01 00 00 48 8D 04 09 49 B8 FF FF FF FF FF FF 1F 00 45 31 D2 49 21 C8 48 C1 E8 36 49 89 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 98 00 00 00 48 8D 04 12 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 48 C1 E8 36 4D 85 C0 0F 84 1B 01 00 00 45 84 D2 0F 85 12 01 00 00 4D 85 C9 0F 84 FA 00 00 00 48 89 CE 48 31 D6 0F 88 0B 01 00 00 41 39 C3 7C 09 4D 39 C8 0F 87 E0 00 00 00 41 39 C3 0F 8F 55 01 00 00 4D 39 C8 0F 83 4C 01 00 00 48 C1 E9 3F 48 89 C8 EB 1F 0F 1F 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 0E 4C 21 C2 31 C0 4C 39 C2 74 04 5B 5E C3 90 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B 5E C3 90 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 86 C0 00 00 00 4D 85 C0 74 0B 45 84 D2 74 58 66 0F 1F 44 00 00 B8 01 00 00 00 5B 5E C3 0F 1F 84 00 00 00 00 00 48 8D 04 CD 00 00 00 00 49 B8 FF FF FF FF FF FF 07 00 48 C1 E8 36 49 89 C3 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 48 B8 FF FF C0 6F F2 86 23 00 49 39 C0 41 0F 97 C2 E9 BD FE FF FF 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 4B FF FF FF 4D 85 C9 B8 01 00 00 00 0F 84 3D FF FF FF 48 C1 EA 3F 48 89 D0 5B 5E C3 0F 1F 80 00 00 00 00 48 85 C9 B8 01 00 00 00 0F 89 1E FF FF FF 48 89 D1 30 C0 48 C1 EA 3F 4C 21 C9 4C 39 C9 48 0F 44 C2 E9 06 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8D 04 D5 00 00 00 00 48 C1 E8 36 4D 85 C0 74 AE 45 84 D2 0F 84 8E FE FF FF EB A3 0F 1F 40 00 44 89 DA 29 C2 83 FA 0F 0F 8F 74 FF FF FF 41 89 C2 45 29 DA 41 83 FA 0F 0F 8F 96 FE FF FF 41 39 C3 0F 8E 82 00 00 00 48 8D 05 ?? ?? ?? ?? 48 63 D2 4D 89 C2 45 89 C0 49 C1 EA 20 4C 8B 1C D0 4C 89 DB 45 89 DB 4C 89 DA 48 C1 EB 20 4D 0F AF D8 49 0F AF D2 4C 0F AF C3 4C 89 D8 89 D6 48 C1 E8 20 48 C1 EA 20 4C 0F AF D3 48 01 F0 4C 01 C0 49 89 C0 49 C1 E8 20 4C 01 D2 4C 01 C2 0F 85 93 00 00 00 48 C1 E0 20 45 89 DB 4C 01 D8 4C 39 C8 0F 84 9B FE FF FF 0F 92 C0 0F B6 C0 48 F7 D1 48 C1 E9 3F 31 C8 E9 33 FE FF FF 44 89 C8 4C 89 CA 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 48 C1 EA 20 4F 8B 14 D1 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D0 4C 0F AF DA 48 0F AF C3 4D 89 D1 44 89 DE 49 C1 E9 20 49 C1 EB 20 48 0F AF D3 49 01 F1 4C 01 C8 49 89 C1 49 C1 E9 20 4C 01 DA 4C 01 CA 75 18 48 C1 E0 20 45 89 D2 4C 01 D0 49 39 C0 75 85 E9 1B FE FF FF 31 C0 EB 82 B8 01 00 00 00 E9 78 FF FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "__bid64_quiet_greater_unordered"
		size = 864
		refs = "0135 .refptr.__bid_IDEC_glbflags 0262 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 49 89 C9 4D 21 C1 4D 39 C1 0F 84 F5 00 00 00 49 89 D1 4D 21 C1 4D 39 C1 0F 84 E6 00 00 00 48 39 D1 0F 84 4D 01 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 A9 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 90 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 11 01 00 00 48 8D 04 09 49 B8 FF FF FF FF FF FF 1F 00 45 31 D2 49 21 C8 48 C1 E8 36 49 89 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 9C 00 00 00 48 8D 04 12 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 48 C1 E8 36 4D 85 C0 0F 84 1A 01 00 00 45 84 D2 0F 85 11 01 00 00 4D 85 C9 0F 84 F8 00 00 00 48 89 CE 48 31 D6 0F 88 07 01 00 00 41 39 C3 7C 09 4D 39 C8 0F 87 DE 00 00 00 41 39 C3 0F 8F 45 01 00 00 4D 39 C8 0F 83 3C 01 00 00 48 C1 E9 3F 48 89 C8 EB 22 0F 1F 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 10 4C 21 C2 B8 01 00 00 00 4C 39 C2 74 03 5B 5E C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B 5E C3 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 86 AC 00 00 00 4D 85 C0 74 07 45 84 D2 74 52 66 90 31 C0 5B 5E C3 48 8D 04 CD 00 00 00 00 49 B8 FF FF FF FF FF FF 07 00 48 C1 E8 36 49 89 C3 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 48 B8 FF FF C0 6F F2 86 23 00 49 39 C0 41 0F 97 C2 E9 C8 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 50 FF FF FF 90 31 C0 4D 85 C9 0F 84 44 FF FF FF 48 C1 EA 3F 48 89 D0 5B 5E C3 48 85 C9 78 86 49 89 D0 B8 01 00 00 00 48 C1 EA 3F 4D 21 C8 48 89 C1 4D 39 C8 48 0F 44 CA 48 89 C8 E9 14 FF FF FF 0F 1F 44 00 00 48 8D 04 D5 00 00 00 00 48 C1 E8 36 4D 85 C0 74 BA 45 84 D2 0F 84 9E FE FF FF EB AF 0F 1F 40 00 44 89 DA 29 C2 83 FA 0F 7F 86 41 89 C2 45 29 DA 41 83 FA 0F 0F 8F AA FE FF FF 41 39 C3 7E 7F 48 8D 05 ?? ?? ?? ?? 48 63 D2 4D 89 C2 45 89 C0 49 C1 EA 20 4C 8B 1C D0 4C 89 DB 45 89 DB 4C 89 DA 48 C1 EB 20 4D 0F AF D8 49 0F AF D2 4C 0F AF C3 4C 89 D8 89 D6 48 C1 E8 20 48 C1 EA 20 4C 0F AF D3 48 01 F0 4C 01 C0 49 89 C0 49 C1 E8 20 4C 01 D2 4C 01 C2 0F 85 92 00 00 00 48 C1 E0 20 45 89 DB 4C 01 D8 4C 39 C8 0F 84 B3 FE FF FF 0F 97 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 51 FE FF FF 44 89 C8 4C 89 CA 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 48 C1 EA 20 4F 8B 14 D1 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D0 4C 0F AF DA 48 0F AF C3 4D 89 D1 44 89 DE 49 C1 E9 20 49 C1 EB 20 48 0F AF D3 49 01 F1 4C 01 C8 49 89 C1 49 C1 E9 20 4C 01 DA 4C 01 CA 75 1D 48 C1 E0 20 45 89 D2 4C 01 D0 49 39 C0 75 88 31 C0 E9 36 FE FF FF B8 01 00 00 00 EB 80 31 C0 E9 79 FF FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_66_4_0 {
	meta:
		name = "__bid64_quiet_less"
		size = 848
		refs = "0133 .refptr.__bid_IDEC_glbflags 0256 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 49 89 C9 4D 21 C1 4D 39 C1 0F 84 F5 00 00 00 49 89 D1 4D 21 C1 4D 39 C1 0F 84 E6 00 00 00 48 39 D1 0F 84 4D 01 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 A4 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 80 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 11 01 00 00 48 8D 04 09 49 B8 FF FF FF FF FF FF 1F 00 45 31 D2 49 21 C8 48 C1 E8 36 49 89 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 98 00 00 00 48 8D 04 12 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 48 C1 E8 36 4D 85 C0 0F 84 0A 01 00 00 45 84 D2 0F 85 01 01 00 00 4D 85 C9 74 2C 48 89 CE 48 31 D6 0F 88 FB 00 00 00 41 39 C3 7C 05 4D 39 C8 77 16 41 39 C3 0F 8F 3D 01 00 00 4D 39 C8 0F 83 34 01 00 00 48 F7 D1 90 48 C1 E9 3F 48 89 C8 EB 23 0F 1F 80 00 00 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 0E 4C 21 C2 31 C0 4C 39 C2 74 04 5B 5E C3 90 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B 5E C3 90 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 86 A0 00 00 00 4D 85 C0 74 0B 45 84 D2 74 86 66 0F 1F 44 00 00 31 C0 5B 5E C3 48 8D 04 CD 00 00 00 00 49 B8 FF FF FF FF FF FF 07 00 48 C1 E8 36 49 89 C3 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 48 B8 FF FF C0 6F F2 86 23 00 49 39 C0 41 0F 97 C2 E9 C8 FE FF FF 66 0F 1F 84 00 00 00 00 00 31 C0 4D 85 C9 0F 84 51 FF FF FF 48 89 D0 48 F7 D0 48 C1 E8 3F 5B 5E C3 0F 1F 84 00 00 00 00 00 31 C0 48 85 C9 0F 89 31 FF FF FF 48 89 D1 B0 01 4C 21 C9 4C 39 C9 0F 85 20 FF FF FF EB CD 66 90 48 8D 04 D5 00 00 00 00 48 C1 E8 36 4D 85 C0 74 BA 45 84 D2 0F 84 AA FE FF FF EB AF 0F 1F 40 00 44 89 DA 29 C2 83 FA 0F 0F 8F C2 FE FF FF 41 89 C2 45 29 DA 41 83 FA 0F 0F 8F AE FE FF FF 41 39 C3 7E 7F 48 8D 05 ?? ?? ?? ?? 48 63 D2 4D 89 C2 45 89 C0 49 C1 EA 20 4C 8B 1C D0 4C 89 DB 45 89 DB 4C 89 DA 48 C1 EB 20 4D 0F AF D8 49 0F AF D2 4C 0F AF C3 4C 89 D8 89 D6 48 C1 E8 20 48 C1 EA 20 4C 0F AF D3 48 01 F0 4C 01 C0 49 89 C0 49 C1 E8 20 4C 01 D2 4C 01 C2 0F 85 92 00 00 00 48 C1 E0 20 45 89 DB 4C 01 D8 4C 39 C8 0F 84 BF FE FF FF 0F 92 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 5A FE FF FF 44 89 C8 4C 89 CA 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 48 C1 EA 20 4F 8B 14 D1 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D0 4C 0F AF DA 48 0F AF C3 4D 89 D1 44 89 DE 49 C1 E9 20 49 C1 EB 20 48 0F AF D3 49 01 F1 4C 01 C8 49 89 C1 49 C1 E9 20 4C 01 DA 4C 01 CA 75 1A 48 C1 E0 20 45 89 D2 4C 01 D0 49 39 C0 75 88 31 C0 E9 42 FE FF FF 31 C0 EB 83 B8 01 00 00 00 E9 79 FF FF FF 66 90 }
	condition:
		$1
}

rule file_66_5_0 {
	meta:
		name = "__bid64_quiet_less_equal"
		size = 848
		refs = "0133 .refptr.__bid_IDEC_glbflags 0256 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 49 89 C9 4D 21 C1 4D 39 C1 0F 84 F5 00 00 00 49 89 D1 4D 21 C1 4D 39 C1 0F 84 E6 00 00 00 48 39 D1 0F 84 4D 01 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 A4 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 85 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 1C 01 00 00 48 8D 04 09 49 B8 FF FF FF FF FF FF 1F 00 45 31 D2 49 21 C8 48 C1 E8 36 49 89 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 98 00 00 00 48 8D 04 12 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 48 C1 E8 36 4D 85 C0 0F 84 0C 01 00 00 45 84 D2 0F 85 03 01 00 00 4D 85 C9 74 2C 48 89 CE 48 31 D6 0F 88 00 01 00 00 41 39 C3 7C 05 4D 39 C8 77 16 41 39 C3 0F 8F 3D 01 00 00 4D 39 C8 0F 83 34 01 00 00 48 F7 D1 90 48 C1 E9 3F 48 89 C8 EB 23 0F 1F 80 00 00 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 0E 4C 21 C2 31 C0 4C 39 C2 74 04 5B 5E C3 90 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B 5E C3 90 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 86 A0 00 00 00 4D 85 C0 74 0B 45 84 D2 74 86 66 0F 1F 44 00 00 B8 01 00 00 00 5B 5E C3 0F 1F 84 00 00 00 00 00 48 8D 04 CD 00 00 00 00 49 B8 FF FF FF FF FF FF 07 00 48 C1 E8 36 49 89 C3 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 48 B8 FF FF C0 6F F2 86 23 00 49 39 C0 41 0F 97 C2 E9 BD FE FF FF 4D 85 C9 B8 01 00 00 00 0F 84 4C FF FF FF 48 F7 D2 48 89 D1 48 C1 E9 3F 48 89 C8 5B 5E C3 48 85 C9 78 8B 48 89 D1 31 C0 4C 21 C9 4C 39 C9 0F 85 26 FF FF FF EB D8 0F 1F 84 00 00 00 00 00 48 8D 04 D5 00 00 00 00 48 C1 E8 36 4D 85 C0 74 BF 45 84 D2 0F 84 AA FE FF FF EB B4 0F 1F 40 00 44 89 DA 29 C2 83 FA 0F 0F 8F C2 FE FF FF 41 89 C2 45 29 DA 41 83 FA 0F 0F 8F AE FE FF FF 41 39 C3 7E 7F 48 8D 05 ?? ?? ?? ?? 48 63 D2 4D 89 C2 45 89 C0 49 C1 EA 20 4C 8B 1C D0 4C 89 DB 45 89 DB 4C 89 DA 48 C1 EB 20 4D 0F AF D8 49 0F AF D2 4C 0F AF C3 4C 89 D8 89 D6 48 C1 E8 20 48 C1 EA 20 4C 0F AF D3 48 01 F0 4C 01 C0 49 89 C0 49 C1 E8 20 4C 01 D2 4C 01 C2 0F 85 90 00 00 00 48 C1 E0 20 45 89 DB 4C 01 D8 4C 39 C8 0F 84 BF FE FF FF 0F 92 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 5A FE FF FF 44 89 C8 4C 89 CA 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 48 C1 EA 20 4F 8B 14 D1 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D0 4C 0F AF DA 48 0F AF C3 4D 89 D1 44 89 DE 49 C1 E9 20 49 C1 EB 20 48 0F AF D3 49 01 F1 4C 01 C8 49 89 C1 49 C1 E9 20 4C 01 DA 4C 01 CA 75 18 48 C1 E0 20 45 89 D2 4C 01 D0 49 39 C0 75 88 E9 42 FE FF FF 31 C0 EB 85 B8 01 00 00 00 E9 7B FF FF FF 0F 1F 40 00 }
	condition:
		$1
}

rule file_66_6_0 {
	meta:
		name = "__bid64_quiet_less_unordered"
		size = 848
		refs = "0135 .refptr.__bid_IDEC_glbflags 0256 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 49 89 C9 4D 21 C1 4D 39 C1 0F 84 F5 00 00 00 49 89 D1 4D 21 C1 4D 39 C1 0F 84 E6 00 00 00 48 39 D1 0F 84 4D 01 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 A4 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 80 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 11 01 00 00 48 8D 04 09 49 B8 FF FF FF FF FF FF 1F 00 45 31 D2 49 21 C8 48 C1 E8 36 49 89 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 9C 00 00 00 48 8D 04 12 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 48 C1 E8 36 4D 85 C0 0F 84 0A 01 00 00 45 84 D2 0F 85 01 01 00 00 4D 85 C9 74 2C 48 89 CE 48 31 D6 0F 88 FB 00 00 00 41 39 C3 7C 05 4D 39 C8 77 16 41 39 C3 0F 8F 3D 01 00 00 4D 39 C8 0F 83 34 01 00 00 48 F7 D1 90 48 C1 E9 3F 48 89 C8 EB 26 0F 1F 80 00 00 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 10 4C 21 C2 B8 01 00 00 00 4C 39 C2 74 03 5B 5E C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B 5E C3 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 86 9C 00 00 00 4D 85 C0 74 07 45 84 D2 74 82 66 90 31 C0 5B 5E C3 48 8D 04 CD 00 00 00 00 49 B8 FF FF FF FF FF FF 07 00 48 C1 E8 36 49 89 C3 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 48 B8 FF FF C0 6F F2 86 23 00 49 39 C0 41 0F 97 C2 E9 C8 FE FF FF 66 0F 1F 84 00 00 00 00 00 31 C0 4D 85 C9 0F 84 54 FF FF FF 48 89 D0 48 F7 D0 48 C1 E8 3F 5B 5E C3 0F 1F 84 00 00 00 00 00 31 C0 48 85 C9 0F 89 34 FF FF FF 48 89 D1 B0 01 4C 21 C9 4C 39 C9 0F 85 23 FF FF FF EB CD 66 90 48 8D 04 D5 00 00 00 00 48 C1 E8 36 4D 85 C0 74 BA 45 84 D2 0F 84 AA FE FF FF EB AF 0F 1F 40 00 44 89 DA 29 C2 83 FA 0F 0F 8F C2 FE FF FF 41 89 C2 45 29 DA 41 83 FA 0F 0F 8F AE FE FF FF 41 39 C3 7E 7F 48 8D 05 ?? ?? ?? ?? 48 63 D2 4D 89 C2 45 89 C0 49 C1 EA 20 4C 8B 1C D0 4C 89 DB 45 89 DB 4C 89 DA 48 C1 EB 20 4D 0F AF D8 49 0F AF D2 4C 0F AF C3 4C 89 D8 89 D6 48 C1 E8 20 48 C1 EA 20 4C 0F AF D3 48 01 F0 4C 01 C0 49 89 C0 49 C1 E8 20 4C 01 D2 4C 01 C2 0F 85 92 00 00 00 48 C1 E0 20 45 89 DB 4C 01 D8 4C 39 C8 0F 84 BF FE FF FF 0F 92 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 5D FE FF FF 44 89 C8 4C 89 CA 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 48 C1 EA 20 4F 8B 14 D1 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D0 4C 0F AF DA 48 0F AF C3 4D 89 D1 44 89 DE 49 C1 E9 20 49 C1 EB 20 48 0F AF D3 49 01 F1 4C 01 C8 49 89 C1 49 C1 E9 20 4C 01 DA 4C 01 CA 75 1A 48 C1 E0 20 45 89 D2 4C 01 D0 49 39 C0 75 88 31 C0 E9 42 FE FF FF 31 C0 EB 83 B8 01 00 00 00 E9 79 FF FF FF 66 90 }
	condition:
		$1
}

rule file_66_7_0 {
	meta:
		name = "__bid64_quiet_not_equal"
		size = 640
		refs = "0104 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 53 49 B8 00 00 00 00 00 00 00 7C 49 89 C9 4D 21 C1 4D 39 C1 0F 84 C8 00 00 00 49 89 D1 4D 21 C1 4D 39 C1 0F 84 B9 00 00 00 48 39 D1 0F 84 E0 00 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 25 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 86 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 AD 00 00 00 48 8D 1C 09 49 BB FF FF FF FF FF FF 1F 00 45 31 C0 49 21 CB 48 C1 EB 36 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 EC 00 00 00 4C 8D 0C 12 49 C1 E9 36 4D 89 CA 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 4D 85 DB 0F 84 9B 00 00 00 45 84 C0 0F 85 92 00 00 00 4D 85 C9 B8 01 00 00 00 0F 85 0B 01 00 00 0F 1F 40 00 5B C3 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 0D 4C 21 C2 B8 01 00 00 00 4C 39 C2 75 DF 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B C3 31 C0 5B C3 66 2E 0F 1F 84 00 00 00 00 00 49 BB FF FF FF FF FF FF 07 00 48 8D 1C CD 00 00 00 00 4C 89 D8 49 BB 00 00 00 00 00 00 20 00 48 21 C8 48 C1 EB 36 49 09 C3 48 B8 FF FF C0 6F F2 86 23 00 49 39 C3 41 0F 97 C0 E9 2C FF FF FF 90 31 C0 4D 85 C9 0F 95 C0 5B C3 66 0F 1F 44 00 00 49 89 D0 B8 01 00 00 00 4D 21 C8 4D 39 C8 0F 85 5C FF FF FF 48 31 D1 48 C1 E9 3F 48 89 C8 5B C3 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 87 A0 00 00 00 4C 8D 14 D5 00 00 00 00 49 C1 EA 36 4D 85 DB 74 0F 45 84 C0 74 11 66 2E 0F 1F 84 00 00 00 00 00 B8 01 00 00 00 5B C3 48 31 D1 78 F4 44 39 D3 7E 11 4C 89 D8 4D 89 CB 49 89 C1 89 D8 44 89 D3 41 89 C2 44 89 D2 B8 01 00 00 00 29 DA 83 FA 0F 0F 8F CB FE FF FF 85 D2 7E 3D 4F 8D 0C 89 49 B8 FF FF C0 6F F2 86 23 00 4D 01 C9 4D 39 C1 0F 87 AD FE FF FF 31 C0 EB 15 66 0F 1F 84 00 00 00 00 00 4F 8D 0C 89 4D 01 C9 4D 39 C1 77 94 83 C0 01 0F BE C8 39 CA 7F EA 31 C0 4D 39 D9 0F 95 C0 5B C3 4D 85 DB 0F 94 C0 41 09 C0 41 83 F0 01 41 0F B6 C0 5B C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_66_8_0 {
	meta:
		name = "__bid64_quiet_not_greater"
		size = 848
		refs = "0135 .refptr.__bid_IDEC_glbflags 0256 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 49 89 C9 4D 21 C1 4D 39 C1 0F 84 F5 00 00 00 49 89 D1 4D 21 C1 4D 39 C1 0F 84 E6 00 00 00 48 39 D1 0F 84 4D 01 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 A4 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 85 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 1C 01 00 00 48 8D 04 09 49 B8 FF FF FF FF FF FF 1F 00 45 31 D2 49 21 C8 48 C1 E8 36 49 89 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 9C 00 00 00 48 8D 04 12 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 48 C1 E8 36 4D 85 C0 0F 84 0C 01 00 00 45 84 D2 0F 85 03 01 00 00 4D 85 C9 74 2C 48 89 CE 48 31 D6 0F 88 00 01 00 00 41 39 C3 7C 05 4D 39 C8 77 16 41 39 C3 0F 8F 3D 01 00 00 4D 39 C8 0F 83 34 01 00 00 48 F7 D1 90 48 C1 E9 3F 48 89 C8 EB 26 0F 1F 80 00 00 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 10 4C 21 C2 B8 01 00 00 00 4C 39 C2 74 03 5B 5E C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B 5E C3 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 86 9C 00 00 00 4D 85 C0 74 07 45 84 D2 74 82 66 90 B8 01 00 00 00 5B 5E C3 0F 1F 84 00 00 00 00 00 48 8D 04 CD 00 00 00 00 49 B8 FF FF FF FF FF FF 07 00 48 C1 E8 36 49 89 C3 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 48 B8 FF FF C0 6F F2 86 23 00 49 39 C0 41 0F 97 C2 E9 BD FE FF FF 4D 85 C9 B8 01 00 00 00 0F 84 4F FF FF FF 48 F7 D2 48 89 D1 48 C1 E9 3F 48 89 C8 5B 5E C3 48 85 C9 78 8B 48 89 D1 31 C0 4C 21 C9 4C 39 C9 0F 85 29 FF FF FF EB D8 0F 1F 84 00 00 00 00 00 48 8D 04 D5 00 00 00 00 48 C1 E8 36 4D 85 C0 74 BF 45 84 D2 0F 84 AA FE FF FF EB B4 0F 1F 40 00 44 89 DA 29 C2 83 FA 0F 0F 8F C2 FE FF FF 41 89 C2 45 29 DA 41 83 FA 0F 0F 8F AE FE FF FF 41 39 C3 7E 7F 48 8D 05 ?? ?? ?? ?? 48 63 D2 4D 89 C2 45 89 C0 49 C1 EA 20 4C 8B 1C D0 4C 89 DB 45 89 DB 4C 89 DA 48 C1 EB 20 4D 0F AF D8 49 0F AF D2 4C 0F AF C3 4C 89 D8 89 D6 48 C1 E8 20 48 C1 EA 20 4C 0F AF D3 48 01 F0 4C 01 C0 49 89 C0 49 C1 E8 20 4C 01 D2 4C 01 C2 0F 85 90 00 00 00 48 C1 E0 20 45 89 DB 4C 01 D8 4C 39 C8 0F 84 BF FE FF FF 0F 92 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 5D FE FF FF 44 89 C8 4C 89 CA 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 48 C1 EA 20 4F 8B 14 D1 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D0 4C 0F AF DA 48 0F AF C3 4D 89 D1 44 89 DE 49 C1 E9 20 49 C1 EB 20 48 0F AF D3 49 01 F1 4C 01 C8 49 89 C1 49 C1 E9 20 4C 01 DA 4C 01 CA 75 18 48 C1 E0 20 45 89 D2 4C 01 D0 49 39 C0 75 88 E9 42 FE FF FF 31 C0 EB 85 B8 01 00 00 00 E9 7B FF FF FF 0F 1F 40 00 }
	condition:
		$1
}

rule file_66_9_0 {
	meta:
		name = "__bid64_quiet_not_less"
		size = 896
		refs = "0135 .refptr.__bid_IDEC_glbflags 027a .rdata"
	strings:
		$1 = { 56 53 48 B8 00 00 00 00 00 00 00 7C 49 89 C8 49 21 C0 49 39 C0 0F 84 F5 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 E6 00 00 00 48 39 D1 0F 84 4D 01 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 B4 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 94 01 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 1C 01 00 00 48 8D 04 09 49 B8 FF FF FF FF FF FF 1F 00 45 31 D2 49 21 C8 48 C1 E8 36 49 89 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 9C 00 00 00 48 8D 04 12 49 B9 FF FF FF FF FF FF 1F 00 49 21 D1 48 C1 E8 36 4D 85 C0 0F 84 1B 01 00 00 45 84 D2 0F 85 12 01 00 00 4D 85 C9 0F 84 FA 00 00 00 48 89 CE 48 31 D6 0F 88 0B 01 00 00 41 39 C3 7C 09 4D 39 C8 0F 87 E0 00 00 00 41 39 C3 0F 8F 55 01 00 00 4D 39 C8 0F 83 4C 01 00 00 48 C1 E9 3F 48 89 C8 EB 22 0F 1F 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 10 4C 21 C2 B8 01 00 00 00 4C 39 C2 74 03 5B 5E C3 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B 5E C3 49 B9 FF FF FF FF FF FF 07 00 4C 89 C8 49 B9 00 00 00 00 00 00 20 00 48 21 D0 49 09 C1 48 B8 FF FF C0 6F F2 86 23 00 49 39 C1 0F 86 BC 00 00 00 4D 85 C0 74 07 45 84 D2 74 54 66 90 B8 01 00 00 00 5B 5E C3 0F 1F 84 00 00 00 00 00 48 8D 04 CD 00 00 00 00 49 B8 FF FF FF FF FF FF 07 00 48 C1 E8 36 49 89 C3 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 48 B8 FF FF C0 6F F2 86 23 00 49 39 C0 41 0F 97 C2 E9 BD FE FF FF 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 4E FF FF FF 4D 85 C9 B8 01 00 00 00 0F 84 40 FF FF FF 48 C1 EA 3F 48 89 D0 5B 5E C3 0F 1F 80 00 00 00 00 48 85 C9 B8 01 00 00 00 0F 89 21 FF FF FF 48 89 D1 30 C0 48 C1 EA 3F 4C 21 C9 4C 39 C9 48 0F 44 C2 E9 09 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8D 04 D5 00 00 00 00 48 C1 E8 36 4D 85 C0 74 AE 45 84 D2 0F 84 8E FE FF FF EB A3 0F 1F 40 00 44 89 DA 29 C2 83 FA 0F 0F 8F 74 FF FF FF 41 89 C2 45 29 DA 41 83 FA 0F 0F 8F 96 FE FF FF 41 39 C3 0F 8E 82 00 00 00 48 8D 05 ?? ?? ?? ?? 48 63 D2 4D 89 C2 45 89 C0 49 C1 EA 20 4C 8B 1C D0 4C 89 DB 45 89 DB 4C 89 DA 48 C1 EB 20 4D 0F AF D8 49 0F AF D2 4C 0F AF C3 4C 89 D8 89 D6 48 C1 E8 20 48 C1 EA 20 4C 0F AF D3 48 01 F0 4C 01 C0 49 89 C0 49 C1 E8 20 4C 01 D2 4C 01 C2 0F 85 93 00 00 00 48 C1 E0 20 45 89 DB 4C 01 D8 4C 39 C8 0F 84 9B FE FF FF 0F 92 C0 0F B6 C0 48 F7 D1 48 C1 E9 3F 31 C8 E9 36 FE FF FF 44 89 C8 4C 89 CA 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 48 C1 EA 20 4F 8B 14 D1 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D0 4C 0F AF DA 48 0F AF C3 4D 89 D1 44 89 DE 49 C1 E9 20 49 C1 EB 20 48 0F AF D3 49 01 F1 4C 01 C8 49 89 C1 49 C1 E9 20 4C 01 DA 4C 01 CA 75 18 48 C1 E0 20 45 89 D2 4C 01 D0 49 39 C0 75 85 E9 1B FE FF FF 31 C0 EB 82 B8 01 00 00 00 E9 78 FF FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_66_10_0 {
	meta:
		name = "__bid64_quiet_ordered"
		size = 96
		refs = "004f .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 74 1B 49 89 D1 B8 01 00 00 00 4D 21 C1 4D 39 C1 74 0B F3 C3 66 0F 1F 84 00 00 00 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 0A 4C 21 C2 31 C0 4C 39 C2 75 D9 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_66_11_0 {
	meta:
		name = "__bid64_quiet_unordered"
		size = 96
		refs = "0046 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 74 0F 49 89 D1 31 C0 4D 21 C1 4D 39 C1 74 02 F3 C3 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 74 0D 4C 21 C2 B8 01 00 00 00 4C 39 C2 75 DF 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_66_12_0 {
	meta:
		name = "__bid64_signaling_greater"
		size = 816
		refs = "0107 .refptr.__bid_IDEC_glbflags 0226 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 E9 00 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 DA 00 00 00 48 39 D1 0F 84 51 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 C7 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EC 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 1C 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 A9 00 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 74 7B 45 84 D2 75 76 4D 85 C0 0F 84 FD 00 00 00 48 89 CE 48 31 D6 78 6C 45 39 CB 7C 09 4C 39 C0 0F 87 E7 00 00 00 45 39 CB 0F 8F 11 01 00 00 4C 39 C0 0F 83 08 01 00 00 48 C1 E9 3F 48 89 C8 EB 0C 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B 5E C3 48 85 C9 78 6C 49 89 D1 B8 01 00 00 00 48 C1 EA 3F 4D 21 C1 48 89 C1 4D 39 C1 48 0F 44 CA 48 89 C8 5B 5E C3 66 0F 1F 84 00 00 00 00 00 31 C0 4D 85 C0 74 C9 48 C1 EA 3F 48 89 D0 5B 5E C3 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 76 66 48 85 C0 74 05 45 84 D2 74 4C 31 C0 5B 5E C3 0F 1F 80 00 00 00 00 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 C0 FE FF FF 90 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 31 FF FF FF 90 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 0F 84 52 FF FF FF 45 84 D2 0F 84 D5 FE FF FF E9 44 FF FF FF 44 89 DA 44 29 CA 83 FA 0F 7F C2 45 89 CA 45 29 DA 41 83 FA 0F 0F 8F DD FE FF FF 45 39 CB 7E 7E 4C 8D 15 ?? ?? ?? ?? 48 63 D2 49 89 C1 89 C0 49 C1 E9 20 4D 8B 14 D2 4C 89 D3 45 89 D2 4C 89 D2 48 C1 EB 20 4C 0F AF D0 49 0F AF D1 48 0F AF C3 4D 89 D3 89 D6 49 C1 EB 20 48 C1 EA 20 4C 0F AF CB 49 01 F3 4C 01 D8 4C 01 CA 49 89 C1 49 C1 E9 20 4C 01 CA 0F 85 93 00 00 00 48 C1 E0 20 45 89 D2 4C 01 D0 4C 39 C0 0F 84 F4 FE FF FF 0F 97 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 6F FE FF FF 44 89 C2 4D 89 C1 4C 8D 05 ?? ?? ?? ?? 4D 63 D2 49 C1 E9 20 4F 8B 14 D0 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D2 4D 0F AF D9 48 0F AF D3 4D 89 D0 44 89 DE 49 C1 E8 20 49 C1 EB 20 4C 0F AF CB 49 01 F0 4C 01 C2 4F 8D 04 0B 49 89 D1 49 C1 E9 20 4D 01 C8 75 20 48 C1 E2 20 45 89 D2 4C 01 D2 48 39 D0 75 87 31 C0 E9 76 FE FF FF B8 01 00 00 00 E9 7C FF FF FF 31 C0 E9 75 FF FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_66_13_0 {
	meta:
		name = "__bid64_signaling_greater_equal"
		size = 816
		refs = "0107 .refptr.__bid_IDEC_glbflags 022a .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 E9 00 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 DA 00 00 00 48 39 D1 0F 84 50 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 C7 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 E1 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 1C 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 A8 00 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 74 6D 45 84 D2 75 68 4D 85 C0 0F 84 FD 00 00 00 48 89 CE 48 31 D6 78 61 45 39 CB 7C 09 4C 39 C0 0F 87 E7 00 00 00 45 39 CB 0F 8F 11 01 00 00 4C 39 C0 0F 83 08 01 00 00 48 C1 E9 3F 48 89 C8 EB 0C 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B 5E C3 48 85 C9 B8 01 00 00 00 79 F3 48 89 D1 30 C0 48 C1 EA 3F 4C 21 C1 4C 39 C1 48 0F 44 C2 EB DE 4D 85 C0 B8 01 00 00 00 74 D4 48 C1 EA 3F 48 89 D0 5B 5E C3 66 2E 0F 1F 84 00 00 00 00 00 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 76 67 48 85 C0 74 05 45 84 D2 74 4D B8 01 00 00 00 5B 5E C3 0F 1F 44 00 00 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 C0 FE FF FF 90 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 31 FF FF FF 90 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 0F 84 47 FF FF FF 45 84 D2 0F 84 D5 FE FF FF E9 39 FF FF FF 44 89 DA 44 29 CA 83 FA 0F 7F C2 45 89 CA 45 29 DA 41 83 FA 0F 0F 8F DD FE FF FF 45 39 CB 0F 8E 81 00 00 00 4C 8D 15 ?? ?? ?? ?? 48 63 D2 49 89 C1 89 C0 49 C1 E9 20 4D 8B 14 D2 4C 89 D3 45 89 D2 4C 89 D2 48 C1 EB 20 4C 0F AF D0 49 0F AF D1 48 0F AF C3 4D 89 D3 89 D6 49 C1 EB 20 48 C1 EA 20 4C 0F AF CB 49 01 F3 4C 01 D8 4C 01 CA 49 89 C1 49 C1 E9 20 4C 01 CA 0F 85 94 00 00 00 48 C1 E0 20 45 89 D2 4C 01 D0 4C 39 C0 0F 84 EF FE FF FF 0F 92 C0 0F B6 C0 48 F7 D1 48 C1 E9 3F 31 C8 E9 68 FE FF FF 44 89 C2 4D 89 C1 4C 8D 05 ?? ?? ?? ?? 4D 63 D2 49 C1 E9 20 4F 8B 14 D0 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D2 4D 0F AF D9 48 0F AF D3 4D 89 D0 44 89 DE 49 C1 E8 20 49 C1 EB 20 4C 0F AF CB 49 01 F0 4C 01 C2 4F 8D 04 0B 49 89 D1 49 C1 E9 20 4D 01 C8 75 18 48 C1 E2 20 45 89 D2 4C 01 D2 48 39 D0 75 84 E9 6E FE FF FF 31 C0 EB 81 B8 01 00 00 00 E9 77 FF FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_66_14_0 {
	meta:
		name = "__bid64_signaling_greater_unordered"
		size = 816
		refs = "0107 .refptr.__bid_IDEC_glbflags 0233 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 E9 00 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 DA 00 00 00 48 39 D1 0F 84 5D 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 D4 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 F0 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 21 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 AD 00 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 74 7F 45 84 D2 75 7A 4D 85 C0 0F 84 01 01 00 00 48 89 CE 48 31 D6 78 70 45 39 CB 7C 09 4C 39 C0 0F 87 EB 00 00 00 45 39 CB 0F 8F 1E 01 00 00 4C 39 C0 0F 83 15 01 00 00 48 C1 E9 3F 48 89 C8 EB 0F 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B 5E C3 66 2E 0F 1F 84 00 00 00 00 00 48 85 C9 78 6B 49 89 D1 B8 01 00 00 00 48 C1 EA 3F 4D 21 C1 48 89 C1 4D 39 C1 48 0F 44 CA 48 89 C8 5B 5E C3 31 C0 4D 85 C0 74 C8 48 C1 EA 3F 48 89 D0 5B 5E C3 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 76 65 48 85 C0 74 0D 45 84 D2 74 4C 0F 1F 84 00 00 00 00 00 31 C0 5B 5E C3 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 BB FE FF FF 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 30 FF FF FF 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 0F 84 53 FF FF FF 45 84 D2 0F 84 D2 FE FF FF E9 45 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 44 89 DA 44 29 CA 83 FA 0F 7F B9 45 89 CA 45 29 DA 41 83 FA 0F 0F 8F D0 FE FF FF 45 39 CB 7E 7E 4C 8D 15 ?? ?? ?? ?? 48 63 D2 49 89 C1 89 C0 49 C1 E9 20 4D 8B 14 D2 4C 89 D3 45 89 D2 4C 89 D2 48 C1 EB 20 4C 0F AF D0 49 0F AF D1 48 0F AF C3 4D 89 D3 89 D6 49 C1 EB 20 48 C1 EA 20 4C 0F AF CB 49 01 F3 4C 01 D8 4C 01 CA 49 89 C1 49 C1 E9 20 4C 01 CA 0F 85 93 00 00 00 48 C1 E0 20 45 89 D2 4C 01 D0 4C 39 C0 0F 84 F3 FE FF FF 0F 97 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 65 FE FF FF 44 89 C2 4D 89 C1 4C 8D 05 ?? ?? ?? ?? 4D 63 D2 49 C1 E9 20 4F 8B 14 D0 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D2 4D 0F AF D9 48 0F AF D3 4D 89 D0 44 89 DE 49 C1 E8 20 49 C1 EB 20 4C 0F AF CB 49 01 F0 4C 01 C2 4F 8D 04 0B 49 89 D1 49 C1 E9 20 4D 01 C8 75 20 48 C1 E2 20 45 89 D2 4C 01 D2 48 39 D0 75 87 31 C0 E9 75 FE FF FF B8 01 00 00 00 E9 7C FF FF FF 31 C0 E9 75 FF FF FF 66 90 }
	condition:
		$1
}

rule file_66_15_0 {
	meta:
		name = "__bid64_signaling_less"
		size = 800
		refs = "0113 .refptr.__bid_IDEC_glbflags 0227 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 F5 00 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 E6 00 00 00 48 39 D1 0F 84 5D 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 D4 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EC 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 21 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 AC 00 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 74 7B 45 84 D2 75 76 4D 85 C0 74 31 48 89 CE 48 31 D6 78 70 45 39 CB 7C 05 4C 39 C0 77 1F 45 39 CB 0F 8F 16 01 00 00 4C 39 C0 0F 83 0D 01 00 00 48 F7 D1 66 2E 0F 1F 84 00 00 00 00 00 48 C1 E9 3F 48 89 C8 EB 13 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B 5E C3 90 31 C0 48 85 C9 79 F5 48 89 D1 B0 01 4C 21 C1 4C 39 C1 75 E8 EB 11 66 2E 0F 1F 84 00 00 00 00 00 31 C0 4D 85 C0 74 D5 48 F7 D2 48 C1 EA 3F 48 89 D0 5B 5E C3 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 76 57 48 85 C0 74 0E 45 84 D2 0F 84 75 FF FF FF 0F 1F 44 00 00 31 C0 5B 5E C3 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 BB FE FF FF 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 0F 84 5E FF FF FF 45 84 D2 0F 84 DD FE FF FF E9 50 FF FF FF 66 0F 1F 84 00 00 00 00 00 44 89 DA 44 29 CA 83 FA 0F 0F 8F F1 FE FF FF 45 89 CA 45 29 DA 41 83 FA 0F 0F 8F D4 FE FF FF 45 39 CB 7E 7E 4C 8D 15 ?? ?? ?? ?? 48 63 D2 49 89 C1 89 C0 49 C1 E9 20 4D 8B 14 D2 4C 89 D3 45 89 D2 4C 89 D2 48 C1 EB 20 4C 0F AF D0 49 0F AF D1 48 0F AF C3 4D 89 D3 89 D6 49 C1 EB 20 48 C1 EA 20 4C 0F AF CB 49 01 F3 4C 01 D8 4C 01 CA 49 89 C1 49 C1 E9 20 4C 01 CA 0F 85 93 00 00 00 48 C1 E0 20 45 89 D2 4C 01 D0 4C 39 C0 0F 84 FF FE FF FF 0F 92 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 7A FE FF FF 44 89 C2 4D 89 C1 4C 8D 05 ?? ?? ?? ?? 4D 63 D2 49 C1 E9 20 4F 8B 14 D0 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D2 4D 0F AF D9 48 0F AF D3 4D 89 D0 44 89 DE 49 C1 E8 20 49 C1 EB 20 4C 0F AF CB 49 01 F0 4C 01 C2 4F 8D 04 0B 49 89 D1 49 C1 E9 20 4D 01 C8 75 1A 48 C1 E2 20 45 89 D2 4C 01 D2 48 39 D0 75 87 31 C0 E9 81 FE FF FF 31 C0 EB 82 B8 01 00 00 00 E9 78 FF FF FF 90 }
	condition:
		$1
}

rule file_66_16_0 {
	meta:
		name = "__bid64_signaling_less_equal"
		size = 800
		refs = "0113 .refptr.__bid_IDEC_glbflags 022a .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 F5 00 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 E6 00 00 00 48 39 D1 0F 84 5D 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 D4 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 E3 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 2C 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 A8 00 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 74 6F 45 84 D2 75 6A 4D 85 C0 74 31 48 89 CE 48 31 D6 78 67 45 39 CB 7C 05 4C 39 C0 77 1F 45 39 CB 0F 8F 19 01 00 00 4C 39 C0 0F 83 10 01 00 00 48 F7 D1 66 2E 0F 1F 84 00 00 00 00 00 48 C1 E9 3F 48 89 C8 EB 13 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 31 C0 5B 5E C3 90 48 85 C9 78 6B 48 89 D1 31 C0 4C 21 C1 4C 39 C1 75 EA EB 0A 4D 85 C0 B8 01 00 00 00 74 DE 48 F7 D2 48 89 D1 48 C1 E9 3F 48 89 C8 5B 5E C3 66 90 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 76 67 48 85 C0 74 12 45 84 D2 0F 84 79 FF FF FF 66 0F 1F 84 00 00 00 00 00 B8 01 00 00 00 5B 5E C3 0F 1F 84 00 00 00 00 00 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 B0 FE FF FF 90 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 0F 84 49 FF FF FF 45 84 D2 0F 84 D1 FE FF FF E9 3B FF FF FF 44 89 DA 44 29 CA 83 FA 0F 0F 8F EE FE FF FF 45 89 CA 45 29 DA 41 83 FA 0F 0F 8F D1 FE FF FF 45 39 CB 7E 7E 4C 8D 15 ?? ?? ?? ?? 48 63 D2 49 89 C1 89 C0 49 C1 E9 20 4D 8B 14 D2 4C 89 D3 45 89 D2 4C 89 D2 48 C1 EB 20 4C 0F AF D0 49 0F AF D1 48 0F AF C3 4D 89 D3 89 D6 49 C1 EB 20 48 C1 EA 20 4C 0F AF CB 49 01 F3 4C 01 D8 4C 01 CA 49 89 C1 49 C1 E9 20 4C 01 CA 0F 85 91 00 00 00 48 C1 E0 20 45 89 D2 4C 01 D0 4C 39 C0 0F 84 FC FE FF FF 0F 92 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 77 FE FF FF 44 89 C2 4D 89 C1 4C 8D 05 ?? ?? ?? ?? 4D 63 D2 49 C1 E9 20 4F 8B 14 D0 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D2 4D 0F AF D9 48 0F AF D3 4D 89 D0 44 89 DE 49 C1 E8 20 49 C1 EB 20 4C 0F AF CB 49 01 F0 4C 01 C2 4F 8D 04 0B 49 89 D1 49 C1 E9 20 4D 01 C8 75 18 48 C1 E2 20 45 89 D2 4C 01 D2 48 39 D0 75 87 E9 7E FE FF FF 31 C0 EB 84 B8 01 00 00 00 E9 7A FF FF FF }
	condition:
		$1
}

rule file_66_17_0 {
	meta:
		name = "__bid64_signaling_less_unordered"
		size = 800
		refs = "0113 .refptr.__bid_IDEC_glbflags 0227 .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 F5 00 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 E6 00 00 00 48 39 D1 0F 84 5D 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 D6 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EC 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 21 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 AC 00 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 74 7B 45 84 D2 75 76 4D 85 C0 74 31 48 89 CE 48 31 D6 78 70 45 39 CB 7C 05 4C 39 C0 77 1F 45 39 CB 0F 8F 16 01 00 00 4C 39 C0 0F 83 0D 01 00 00 48 F7 D1 66 2E 0F 1F 84 00 00 00 00 00 48 C1 E9 3F 48 89 C8 EB 16 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B 5E C3 31 C0 48 85 C9 79 F6 48 89 D1 B0 01 4C 21 C1 4C 39 C1 75 E9 EB 0F 0F 1F 84 00 00 00 00 00 31 C0 4D 85 C0 74 D8 48 F7 D2 48 C1 EA 3F 48 89 D0 5B 5E C3 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 76 57 48 85 C0 74 0E 45 84 D2 0F 84 75 FF FF FF 0F 1F 44 00 00 31 C0 5B 5E C3 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 BB FE FF FF 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 0F 84 5E FF FF FF 45 84 D2 0F 84 DD FE FF FF E9 50 FF FF FF 66 0F 1F 84 00 00 00 00 00 44 89 DA 44 29 CA 83 FA 0F 0F 8F F1 FE FF FF 45 89 CA 45 29 DA 41 83 FA 0F 0F 8F D4 FE FF FF 45 39 CB 7E 7E 4C 8D 15 ?? ?? ?? ?? 48 63 D2 49 89 C1 89 C0 49 C1 E9 20 4D 8B 14 D2 4C 89 D3 45 89 D2 4C 89 D2 48 C1 EB 20 4C 0F AF D0 49 0F AF D1 48 0F AF C3 4D 89 D3 89 D6 49 C1 EB 20 48 C1 EA 20 4C 0F AF CB 49 01 F3 4C 01 D8 4C 01 CA 49 89 C1 49 C1 E9 20 4C 01 CA 0F 85 93 00 00 00 48 C1 E0 20 45 89 D2 4C 01 D0 4C 39 C0 0F 84 FF FE FF FF 0F 92 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 7D FE FF FF 44 89 C2 4D 89 C1 4C 8D 05 ?? ?? ?? ?? 4D 63 D2 49 C1 E9 20 4F 8B 14 D0 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D2 4D 0F AF D9 48 0F AF D3 4D 89 D0 44 89 DE 49 C1 E8 20 49 C1 EB 20 4C 0F AF CB 49 01 F0 4C 01 C2 4F 8D 04 0B 49 89 D1 49 C1 E9 20 4D 01 C8 75 1A 48 C1 E2 20 45 89 D2 4C 01 D2 48 39 D0 75 87 31 C0 E9 81 FE FF FF 31 C0 EB 82 B8 01 00 00 00 E9 78 FF FF FF 90 }
	condition:
		$1
}

rule file_66_18_0 {
	meta:
		name = "__bid64_signaling_not_greater"
		size = 816
		refs = "0113 .refptr.__bid_IDEC_glbflags 023a .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 F5 00 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 E6 00 00 00 48 39 D1 0F 84 6D 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 D6 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EF 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 3C 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 B8 00 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 74 7B 45 84 D2 75 76 4D 85 C0 74 31 48 89 CE 48 31 D6 78 73 45 39 CB 7C 05 4C 39 C0 77 1F 45 39 CB 0F 8F 29 01 00 00 4C 39 C0 0F 83 20 01 00 00 48 F7 D1 66 2E 0F 1F 84 00 00 00 00 00 48 C1 E9 3F 48 89 C8 EB 16 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B 5E C3 48 85 C9 78 79 48 89 D1 31 C0 4C 21 C1 4C 39 C1 75 EB EB 14 66 2E 0F 1F 84 00 00 00 00 00 4D 85 C0 B8 01 00 00 00 74 D5 48 F7 D2 48 89 D1 48 C1 E9 3F 48 89 C8 5B 5E C3 66 0F 1F 44 00 00 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 76 67 48 85 C0 74 12 45 84 D2 0F 84 69 FF FF FF 66 0F 1F 84 00 00 00 00 00 B8 01 00 00 00 5B 5E C3 0F 1F 84 00 00 00 00 00 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 A0 FE FF FF 90 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 0F 84 45 FF FF FF 45 84 D2 0F 84 C1 FE FF FF E9 37 FF FF FF 44 89 DA 44 29 CA 83 FA 0F 0F 8F DE FE FF FF 45 89 CA 45 29 DA 41 83 FA 0F 0F 8F C1 FE FF FF 45 39 CB 7E 7E 4C 8D 15 ?? ?? ?? ?? 48 63 D2 49 89 C1 89 C0 49 C1 E9 20 4D 8B 14 D2 4C 89 D3 45 89 D2 4C 89 D2 48 C1 EB 20 4C 0F AF D0 49 0F AF D1 48 0F AF C3 4D 89 D3 89 D6 49 C1 EB 20 48 C1 EA 20 4C 0F AF CB 49 01 F3 4C 01 D8 4C 01 CA 49 89 C1 49 C1 E9 20 4C 01 CA 0F 85 91 00 00 00 48 C1 E0 20 45 89 D2 4C 01 D0 4C 39 C0 0F 84 FC FE FF FF 0F 92 C0 0F B6 C0 48 C1 E9 3F 31 C8 E9 6A FE FF FF 44 89 C2 4D 89 C1 4C 8D 05 ?? ?? ?? ?? 4D 63 D2 49 C1 E9 20 4F 8B 14 D0 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D2 4D 0F AF D9 48 0F AF D3 4D 89 D0 44 89 DE 49 C1 E8 20 49 C1 EB 20 4C 0F AF CB 49 01 F0 4C 01 C2 4F 8D 04 0B 49 89 D1 49 C1 E9 20 4D 01 C8 75 18 48 C1 E2 20 45 89 D2 4C 01 D2 48 39 D0 75 87 E9 7E FE FF FF 31 C0 EB 84 B8 01 00 00 00 E9 7A FF FF FF }
	condition:
		$1
}

rule file_66_19_0 {
	meta:
		name = "__bid64_signaling_not_less"
		size = 832
		refs = "0107 .refptr.__bid_IDEC_glbflags 023a .rdata"
	strings:
		$1 = { 56 53 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 E9 00 00 00 48 89 D0 4C 21 C0 4C 39 C0 0F 84 DA 00 00 00 48 39 D1 0F 84 5D 01 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 D4 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 EF 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 2C 01 00 00 48 8D 04 09 45 31 D2 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 49 B8 00 00 00 00 00 00 00 60 49 89 D1 4D 21 C1 4D 39 C1 0F 84 AC 00 00 00 4C 8D 04 12 49 C1 E8 36 4D 89 C1 49 B8 FF FF FF FF FF FF 1F 00 49 21 D0 48 85 C0 74 7B 45 84 D2 75 76 4D 85 C0 0F 84 0D 01 00 00 48 89 CE 48 31 D6 78 6F 45 39 CB 7C 09 4C 39 C0 0F 87 F7 00 00 00 45 39 CB 0F 8F 21 01 00 00 4C 39 C0 0F 83 18 01 00 00 48 C1 E9 3F 48 89 C8 EB 0F 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 01 00 00 00 5B 5E C3 66 2E 0F 1F 84 00 00 00 00 00 48 85 C9 B8 01 00 00 00 79 E9 48 89 D1 30 C0 48 C1 EA 3F 4C 21 C1 4C 39 C1 48 0F 44 C2 EB D4 90 4D 85 C0 B8 01 00 00 00 74 C9 48 C1 EA 3F 48 89 D0 5B 5E C3 49 B8 FF FF FF FF FF FF 07 00 49 B9 00 00 00 00 00 00 20 00 49 21 D0 4D 09 C8 49 B9 FF FF C0 6F F2 86 23 00 4D 39 C8 76 73 48 85 C0 74 0E 45 84 D2 74 59 66 0F 1F 84 00 00 00 00 00 B8 01 00 00 00 5B 5E C3 0F 1F 84 00 00 00 00 00 48 8D 04 CD 00 00 00 00 49 B8 00 00 00 00 00 00 20 00 48 C1 E8 36 49 89 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 4C 09 C0 49 B8 FF FF C0 6F F2 86 23 00 4C 39 C0 41 0F 97 C2 E9 B0 FE FF FF 90 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 24 FF FF FF 90 4C 8D 0C D5 00 00 00 00 49 C1 E9 36 48 85 C0 0F 84 45 FF FF FF 45 84 D2 0F 84 C5 FE FF FF E9 37 FF FF FF 44 89 DA 44 29 CA 83 FA 0F 7F C2 45 89 CA 45 29 DA 41 83 FA 0F 0F 8F CD FE FF FF 45 39 CB 0F 8E 81 00 00 00 4C 8D 15 ?? ?? ?? ?? 48 63 D2 49 89 C1 89 C0 49 C1 E9 20 4D 8B 14 D2 4C 89 D3 45 89 D2 4C 89 D2 48 C1 EB 20 4C 0F AF D0 49 0F AF D1 48 0F AF C3 4D 89 D3 89 D6 49 C1 EB 20 48 C1 EA 20 4C 0F AF CB 49 01 F3 4C 01 D8 4C 01 CA 49 89 C1 49 C1 E9 20 4C 01 CA 0F 85 94 00 00 00 48 C1 E0 20 45 89 D2 4C 01 D0 4C 39 C0 0F 84 EC FE FF FF 0F 92 C0 0F B6 C0 48 F7 D1 48 C1 E9 3F 31 C8 E9 5B FE FF FF 44 89 C2 4D 89 C1 4C 8D 05 ?? ?? ?? ?? 4D 63 D2 49 C1 E9 20 4F 8B 14 D0 4C 89 D3 45 89 D2 4D 89 D3 48 C1 EB 20 4C 0F AF D2 4D 0F AF D9 48 0F AF D3 4D 89 D0 44 89 DE 49 C1 E8 20 49 C1 EB 20 4C 0F AF CB 49 01 F0 4C 01 C2 4F 8D 04 0B 49 89 D1 49 C1 E9 20 4D 01 C8 75 18 48 C1 E2 20 45 89 D2 4C 01 D2 48 39 D0 75 84 E9 6B FE FF FF 31 C0 EB 81 B8 01 00 00 00 E9 77 FF FF FF 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__bid128_isSigned"
		size = 16
	strings:
		$1 = { 48 8B 41 08 48 C1 E8 3F C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "__bid128_isNormal"
		size = 400
		refs = "00b6 .refptr.__bid_nr_digits"
	strings:
		$1 = { 4C 8B 01 48 8B 49 08 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 74 44 48 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 48 21 CA 48 39 C2 77 28 49 89 D3 4D 09 C3 74 20 48 39 C2 75 1E 49 B9 FF FF FF FF 63 8E 8D 37 31 C0 4D 39 C8 76 0D F3 C3 0F 1F 84 00 00 00 00 00 31 C0 C3 48 B8 00 00 00 00 00 00 00 60 49 89 C9 49 21 C1 49 39 C1 74 E8 48 85 D2 0F 85 8F 00 00 00 48 B8 FF FF FF FF FF FF 1F 00 49 39 C0 0F 87 CC 00 00 00 66 0F EF C9 F2 49 0F 2A C8 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 4C 8B 1D ?? ?? ?? ?? 48 98 49 89 C2 49 C1 E2 05 4D 01 DA 45 8B 0A 45 85 C9 75 26 45 8B 4A 18 4D 8B 52 08 66 2E 0F 1F 84 00 00 00 00 00 4C 39 D2 75 0F 48 C1 E0 05 4D 3B 44 03 10 72 04 41 83 C1 01 48 01 C9 48 C1 E9 32 41 8D 84 09 E0 E7 FF FF 3D 02 E8 FF FF 0F 9D C0 0F B6 C0 C3 90 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 48 98 49 89 C2 49 C1 E2 05 4D 01 DA 45 8B 0A 45 85 C9 75 AD 45 8B 4A 18 4D 8B 52 08 4C 39 D2 77 9C EB 8A 66 2E 0F 1F 84 00 00 00 00 00 66 0F EF D2 4C 89 C0 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 28 FF FF FF 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "__bid128_isSubnormal"
		size = 400
		refs = "00b6 .refptr.__bid_nr_digits"
	strings:
		$1 = { 4C 8B 01 48 8B 49 08 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 74 44 48 BA FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 48 21 CA 48 39 C2 77 28 49 89 D3 4D 09 C3 74 20 48 39 C2 75 1E 49 B9 FF FF FF FF 63 8E 8D 37 31 C0 4D 39 C8 76 0D F3 C3 0F 1F 84 00 00 00 00 00 31 C0 C3 48 B8 00 00 00 00 00 00 00 60 49 89 C9 49 21 C1 49 39 C1 74 E8 48 85 D2 0F 85 8F 00 00 00 48 B8 FF FF FF FF FF FF 1F 00 49 39 C0 0F 87 CC 00 00 00 66 0F EF C9 F2 49 0F 2A C8 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 4C 8B 1D ?? ?? ?? ?? 48 98 49 89 C2 49 C1 E2 05 4D 01 DA 45 8B 0A 45 85 C9 75 26 45 8B 4A 18 4D 8B 52 08 66 2E 0F 1F 84 00 00 00 00 00 4C 39 D2 75 0F 48 C1 E0 05 4D 3B 44 03 10 72 04 41 83 C1 01 48 01 C9 48 C1 E9 32 41 8D 84 09 E0 E7 FF FF 3D 02 E8 FF FF 0F 9C C0 0F B6 C0 C3 90 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 48 98 49 89 C2 49 C1 E2 05 4D 01 DA 45 8B 0A 45 85 C9 75 AD 45 8B 4A 18 4D 8B 52 08 4C 39 D2 77 9C EB 8A 66 2E 0F 1F 84 00 00 00 00 00 66 0F EF D2 4C 89 C0 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 28 FF FF FF 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_3_0 {
	meta:
		name = "__bid128_isFinite"
		size = 32
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 78 48 89 C2 48 23 51 08 48 39 C2 0F 95 C0 0F B6 C0 C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_67_4_0 {
	meta:
		name = "__bid128_isZero"
		size = 128
	strings:
		$1 = { 48 8B 51 08 48 B8 00 00 00 00 00 00 00 78 4C 8B 09 48 89 D1 48 21 C1 48 39 C1 74 56 48 B9 FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 B8 01 00 00 00 48 21 D1 4C 39 C1 77 13 75 13 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C1 76 04 66 90 F3 C3 49 B8 00 00 00 00 00 00 00 60 B8 01 00 00 00 4C 21 C2 4C 39 C2 74 E7 31 C0 4C 09 C9 0F 94 C0 C3 31 C0 C3 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_5_0 {
	meta:
		name = "__bid128_isInf"
		size = 64
	strings:
		$1 = { 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 31 C0 49 89 C8 49 21 D0 49 39 D0 74 05 F3 C3 0F 1F 00 48 B8 00 00 00 00 00 00 00 7C 48 21 C1 48 39 C1 0F 95 C0 0F B6 C0 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_6_0 {
	meta:
		name = "__bid128_isSignaling"
		size = 32
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 7E 48 89 C2 48 23 51 08 48 39 C2 0F 94 C0 0F B6 C0 C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_67_7_0 {
	meta:
		name = "__bid128_isCanonical"
		size = 272
	strings:
		$1 = { 48 8B 51 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 01 48 89 D1 48 21 C1 48 39 C1 74 56 48 B8 00 00 00 00 00 00 00 78 48 89 D1 48 21 C1 48 39 C1 0F 84 9B 00 00 00 48 B9 FF FF FF FF FF FF 01 00 49 B9 C0 87 AD BE 09 ED 01 00 31 C0 48 21 D1 4C 39 C9 77 1D 0F 85 97 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C8 0F 86 84 00 00 00 0F 1F 40 00 F3 C3 48 B9 00 00 00 00 00 C0 FF 01 31 C0 48 85 CA 75 ED 48 B8 FF FF FF FF FF 3F 00 00 48 B9 92 8D 44 C6 4D 31 00 00 48 21 C2 B8 01 00 00 00 48 39 CA 76 CC 48 B8 93 8D 44 C6 4D 31 00 00 48 39 C2 48 BA FF FF FF FF 09 5B C1 38 0F 94 C0 49 39 D0 0F 96 C2 0F B6 D2 21 D0 C3 66 0F 1F 44 00 00 48 B8 FF FF FF FF FF FF FF 03 48 85 C2 0F 95 C2 4D 85 C0 0F 95 C0 09 D0 83 F0 01 0F B6 C0 C3 90 48 B8 00 00 00 00 00 00 00 60 48 21 C2 48 39 C2 0F 95 C0 0F B6 C0 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_8_0 {
	meta:
		name = "__bid128_isNaN"
		size = 32
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 7C 48 89 C2 48 23 51 08 48 39 C2 0F 94 C0 0F B6 C0 C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_67_9_0 {
	meta:
		name = "__bid128_copy"
		size = 32
	strings:
		$1 = { 4C 8B 0A 4C 8B 52 08 48 89 C8 4C 89 09 4C 89 51 08 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_10_0 {
	meta:
		name = "__bid128_negate"
		size = 32
	strings:
		$1 = { 4C 8B 02 48 89 C8 48 B9 00 00 00 00 00 00 00 80 48 33 4A 08 4C 89 00 48 89 48 08 C3 0F 1F 40 00 }
	condition:
		$1
}

rule file_67_11_0 {
	meta:
		name = "__bid128_abs"
		size = 32
	strings:
		$1 = { 4C 8B 02 48 89 C8 48 B9 FF FF FF FF FF FF FF 7F 48 23 4A 08 4C 89 00 48 89 48 08 C3 0F 1F 40 00 }
	condition:
		$1
}

rule file_67_12_0 {
	meta:
		name = "__bid128_copySign"
		size = 48
	strings:
		$1 = { 4C 8B 0A 48 89 C8 48 B9 00 00 00 00 00 00 00 80 49 23 48 08 49 B8 FF FF FF FF FF FF FF 7F 4C 23 42 08 4C 89 08 4C 89 C2 48 09 CA 48 89 50 08 C3 }
	condition:
		$1
}

rule file_67_13_0 {
	meta:
		name = "__bid128_class"
		size = 992
		refs = "0107 .refptr.__bid_ten2k64 0218 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 8B 41 08 48 BA 00 00 00 00 00 00 00 7C 4C 8B 09 48 89 C1 48 21 D1 48 39 D1 74 48 48 BA 00 00 00 00 00 00 00 78 48 89 C1 48 21 D1 48 39 D1 74 56 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 48 21 C2 4C 39 C2 76 57 48 C1 F8 3F 83 C0 06 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 BA 00 00 00 00 00 00 00 7E 48 21 D0 48 39 D0 0F 95 C0 0F B6 C0 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 C1 F8 3F 83 E0 F9 83 C0 09 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 75 0F 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 77 98 48 B9 00 00 00 00 00 00 00 60 49 89 C0 49 21 C8 49 39 C8 74 83 48 89 D6 4C 09 CE 0F 84 77 FF FF FF 49 89 C0 49 C1 E8 31 41 81 E0 FF 3F 00 00 41 83 F8 20 0F 8F C6 02 00 00 41 83 F8 13 0F 8F FC 00 00 00 48 8B 0D ?? ?? ?? ?? 4D 63 C0 48 C1 EA 20 4E 8B 14 C1 41 89 C0 4C 89 D3 44 89 D6 48 C1 EB 20 49 89 DB 48 89 D9 4D 0F AF D8 4C 0F AF C6 48 0F AF CA 44 89 DF 49 C1 EB 20 4D 89 C2 45 89 C0 48 0F AF D6 49 C1 EA 20 49 01 CB 49 01 FA 4C 01 D2 4D 89 CA 48 89 D1 49 C1 EA 20 48 C1 E2 20 48 C1 E9 20 4C 01 C2 49 01 CB 44 89 C9 49 89 D9 4C 0F AF C9 48 0F AF CE 49 0F AF DA 44 89 CD 49 C1 E9 20 48 89 CF 4C 0F AF D6 48 C1 EF 20 4C 01 CB 48 01 EF 49 01 FA 4D 89 D1 49 C1 E9 20 49 01 D9 4C 01 CA 49 83 D3 00 4D 85 DB 0F 85 0E 02 00 00 49 B8 92 8D 44 C6 4D 31 00 00 4C 39 C2 76 2F 41 B0 93 4C 39 C2 0F 85 F3 01 00 00 49 C1 E2 20 89 C9 49 8D 14 0A 48 B9 FF FF FF FF 09 5B C1 38 48 39 CA 0F 87 D6 01 00 00 66 0F 1F 44 00 00 48 C1 F8 3F 83 E0 FD 83 C0 07 E9 61 FE FF FF 90 41 83 E8 14 45 89 CB 4C 89 CE 4D 63 C0 48 C1 EE 20 49 C1 E0 04 4C 03 05 ?? ?? ?? ?? 4D 8B 48 08 4D 8B 30 44 89 CD 4D 89 CD 4D 89 F0 49 89 E9 49 89 EA 49 C1 ED 20 4D 0F AF CB 4C 89 EB 45 89 F6 4C 0F AF D6 49 C1 E8 20 48 0F AF DE 4C 89 C9 45 89 C9 44 89 D7 48 C1 E9 20 49 C1 EA 20 48 01 F9 4C 89 EF 49 01 DA 49 0F AF FB 48 01 F9 48 89 CB 48 C1 E1 20 48 C1 EB 20 4C 01 C9 49 89 E9 49 01 DA 4C 89 F3 48 0F AF DE 49 0F AF F0 41 89 DF 48 C1 EB 20 48 89 F7 4C 89 F6 49 0F AF F3 48 01 DF 4D 0F AF D8 49 89 F4 49 C1 EC 20 4D 01 FC 41 89 C7 4D 01 E3 4C 89 DB 48 C1 EB 20 48 01 FB 48 01 CB 49 83 D2 00 48 C1 EA 20 4D 0F AF CF 48 89 D7 48 89 D1 49 0F AF CD 48 0F AF FD 4D 89 CC 45 89 C9 49 C1 EC 20 4D 0F AF EF 89 FD 48 C1 EF 20 48 01 CF 4D 01 E5 4D 8D 64 2D 00 49 89 D5 4D 0F AF EE 4C 89 E1 49 C1 E4 20 48 C1 E9 20 48 01 CF 4C 89 F1 49 0F AF CF 49 0F AF D0 4D 0F AF C7 49 89 CE 89 C9 49 C1 EE 20 48 89 D5 44 89 EA 4D 01 F0 49 C1 ED 20 49 01 D0 49 01 ED 4C 89 C2 49 C1 E0 20 48 C1 EA 20 4C 01 C1 49 8D 6C 15 00 4B 8D 14 0C 48 01 EA 48 83 D7 00 45 31 C0 48 01 D9 41 0F 92 C0 4C 01 C2 49 01 D2 41 0F 92 C1 49 39 D0 0F 97 C2 44 09 CA 0F B6 D2 48 01 D7 4C 09 D7 75 40 48 BA 92 8D 44 C6 4D 31 00 00 48 39 D1 0F 86 5D FE FF FF B2 93 48 39 D1 75 26 4C 89 DA 89 F6 48 B9 FF FF FF FF 09 5B C1 38 48 C1 E2 20 48 01 F2 48 39 CA 0F 86 37 FE FF FF 0F 1F 80 00 00 00 00 48 C1 F8 3F 83 E0 FB 83 C0 08 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_14_0 {
	meta:
		name = "__bid128_sameQuantum"
		size = 256
	strings:
		$1 = { 4C 8B 41 08 48 8B 4A 08 48 BA 00 00 00 00 00 00 00 7C 4C 89 C0 48 21 D0 48 39 D0 0F 84 BF 00 00 00 49 89 C9 31 C0 49 21 D1 49 39 D1 74 77 48 BA 00 00 00 00 00 00 00 78 4D 89 C1 49 21 D1 49 39 D1 74 6D 49 89 C9 49 21 D1 49 39 D1 0F 84 9E 00 00 00 48 B8 00 00 00 00 00 00 00 60 4D 89 C2 48 BA 00 00 00 00 00 00 FE 7F 49 21 C2 4D 89 C1 49 21 D1 49 39 C2 74 59 48 B8 00 00 00 00 00 00 00 60 49 89 CA 49 B8 00 00 00 00 00 00 FE 7F 49 21 C2 48 89 CA 4C 21 C2 49 39 C2 74 24 31 C0 49 39 D1 0F 94 C0 C3 F3 C3 66 0F 1F 84 00 00 00 00 00 4C 21 C9 31 C0 4C 39 C9 0F 94 C0 C3 0F 1F 40 00 48 C1 E1 02 4C 21 C1 48 89 CA EB D0 0F 1F 40 00 49 C1 E0 02 49 21 D0 4D 89 C1 EB 9B 0F 1F 40 00 48 21 C1 48 39 C1 0F 94 C0 0F B6 C0 C3 0F 1F 00 F3 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_15_0 {
	meta:
		name = "__bid128_totalOrder"
		size = 2752
		refs = "048d .refptr.__bid_ten2k128 089f .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 48 8B 31 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 02 48 8B 5A 08 48 89 CA 49 89 F2 48 21 C2 4D 89 C3 48 39 C2 0F 84 53 01 00 00 48 89 DA 48 21 C2 48 39 C2 0F 84 44 02 00 00 49 39 F0 75 0A 48 39 CB B8 01 00 00 00 74 17 49 89 C9 48 89 D8 49 C1 E9 3F 48 C1 E8 3F 41 38 C1 74 15 41 0F B6 C1 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 A4 01 00 00 48 89 DA 48 21 C2 48 39 C2 0F 84 E5 01 00 00 48 89 C8 49 BA FF FF FF FF FF FF 01 00 48 C1 E8 31 49 21 CA 89 C7 48 B8 C0 87 AD BE 09 ED 01 00 81 E7 FF 3F 00 00 49 39 C2 77 1A 0F 85 83 01 00 00 48 B8 FF FF FF FF 63 8E 8D 37 48 39 C6 0F 86 70 01 00 00 90 48 B8 00 00 00 00 00 00 00 60 48 89 CA BD 01 00 00 00 48 21 C2 48 39 C2 0F 84 C2 02 00 00 48 89 DA 49 BB FF FF FF FF FF FF 01 00 48 B8 C0 87 AD BE 09 ED 01 00 48 C1 EA 31 49 21 DB 81 E2 FF 3F 00 00 49 39 C3 77 19 0F 85 08 02 00 00 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C0 0F 86 F5 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 D9 48 21 C1 48 39 C1 0F 84 87 02 00 00 40 84 ED 41 0F B6 C1 0F 84 FC FE FF FF 39 D7 B8 01 00 00 00 0F 84 EF FE FF FF 0F 9E C0 41 31 C1 E9 E0 FE FF FF 66 90 49 89 D9 49 21 D1 48 85 C9 0F 88 01 01 00 00 31 C0 49 39 D1 0F 85 C8 FE FF FF 48 85 DB 0F 88 BF FE FF FF 48 BA FF FF FF FF FF 3F 00 00 48 89 CE 48 B8 93 8D 44 C6 4D 31 00 00 48 21 D6 48 21 DA 48 39 C6 0F 87 E7 01 00 00 0F 84 4C 04 00 00 48 B8 93 8D 44 C6 4D 31 00 00 48 39 C2 0F 87 22 02 00 00 0F 84 09 02 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 0F 94 C0 4C 21 C3 4C 39 C3 0F 95 C1 38 C1 74 3F 48 39 D6 B8 01 00 00 00 0F 82 4C FE FF FF 4D 39 DA 0F 96 C0 31 DB 48 39 D6 0F 94 C3 21 D8 E9 37 FE FF FF 0F 1F 44 00 00 45 84 C9 B8 01 00 00 00 0F 85 24 FE FF FF 48 21 D3 48 39 D3 0F 94 C0 0F B6 C0 E9 13 FE FF FF 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 58 01 00 00 4D 85 D2 40 0F 94 C5 48 85 F6 0F 94 C0 21 C5 E9 82 FE FF FF 0F 1F 40 00 48 F7 D3 48 C1 EB 3F 48 89 D8 E9 D3 FD FF FF 90 49 39 D1 B8 01 00 00 00 0F 85 C4 FD FF FF 48 85 DB 0F 89 BB FD FF FF 48 BA FF FF FF FF FF 3F 00 00 49 89 C9 48 B8 93 8D 44 C6 4D 31 00 00 49 21 D1 48 21 DA 49 39 C1 0F 87 5D 05 00 00 0F 84 84 07 00 00 48 B8 93 8D 44 C6 4D 31 00 00 48 39 C2 0F 87 3A 05 00 00 0F 84 53 05 00 00 48 B8 00 00 00 00 00 00 00 7E 48 21 C3 48 39 C3 41 0F 95 C0 48 21 C1 48 39 C1 0F 94 C0 41 38 C0 0F 84 62 05 00 00 49 39 D1 B8 01 00 00 00 0F 87 42 FD FF FF 49 39 D1 0F 94 C0 31 DB 4D 39 DA 0F 93 C3 21 D8 E9 2D FD FF FF 48 B8 00 00 00 00 00 00 00 60 49 89 DC 49 21 C4 49 39 C4 0F 84 92 00 00 00 4D 85 DB 75 09 4D 85 C0 0F 84 FD FD FF FF 40 84 ED 0F 85 1B FF FF FF 4D 39 DA 77 12 0F 94 C0 0F 85 BF 00 00 00 49 39 F0 0F 83 B6 00 00 00 39 D7 0F 8D DA FC FF FF 4D 39 DA 72 0F 0F 85 A8 02 00 00 49 39 F0 0F 86 9F 02 00 00 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 BB FC FF FF 66 0F 1F 84 00 00 00 00 00 31 F6 45 31 D2 E9 15 FE FF FF 66 0F 1F 44 00 00 48 89 C8 BD 01 00 00 00 48 C1 E8 2F 89 C7 81 E7 FF 3F 00 00 E9 25 FD FF FF 0F 1F 80 00 00 00 00 48 C1 EB 2F 89 DA 81 E2 FF 3F 00 00 E9 68 FD FF FF 48 B8 FF FF FF FF 09 5B C1 38 49 39 C0 0F 86 E4 FD FF FF 48 BA 00 00 00 00 00 00 00 7E 48 21 D1 48 39 D1 0F 94 C0 48 21 D3 48 39 D3 0F 95 C1 45 31 DB 31 D2 38 C1 0F 85 E9 FD FF FF E9 15 FE FF FF 4D 39 DA 72 11 49 39 F0 0F 86 F7 01 00 00 84 C0 0F 84 EF 01 00 00 39 D7 0F 8E 48 FF FF FF 89 F8 29 D0 83 F8 21 0F 8F 01 FC FF FF 83 F8 13 0F 8E 0F 05 00 00 83 E8 14 89 F2 49 89 F6 48 98 49 C1 EE 20 89 C9 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 58 08 48 8B 00 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF EA 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF FA 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 4D 0F AF EE 4C 0F AF F7 45 89 EF 49 C1 ED 20 4C 89 74 24 10 49 89 C6 4C 0F AF F2 48 0F AF D7 4C 89 74 24 18 49 C1 EE 20 4D 01 FE 4C 8B 7C 24 10 49 01 D6 4B 8D 54 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4C 01 EA 49 01 D7 48 83 54 24 08 00 49 C1 EA 20 4C 89 D5 4D 89 D4 48 0F AF EB 48 0F AF D9 4C 0F AF E6 89 EA 48 C1 ED 20 49 89 DD 89 DB 48 0F AF F1 49 C1 ED 20 4C 01 E5 4C 01 EE 48 01 F2 48 89 D6 48 C1 E2 20 48 C1 EE 20 48 01 DA 48 01 EE 4C 89 D5 48 0F AF E8 48 0F AF C1 48 0F AF CF 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF D7 49 C1 ED 20 4C 01 E9 49 01 CC 4C 89 E1 49 C1 E4 20 49 01 EA 48 C1 E9 20 4C 01 E0 4C 01 D1 48 01 D1 48 83 D6 00 31 D2 49 01 C7 48 8B 44 24 08 0F 92 C2 48 01 D1 48 01 C8 41 0F 92 C2 48 39 CA 0F 97 C1 44 09 D1 0F B6 C9 48 01 CE 75 2E 8B 4C 24 18 49 C1 E6 20 4D 39 FB 0F 94 C2 48 85 C0 0F 94 C0 4D 8D 14 0E 4D 39 C2 0F 94 C1 84 CA 0F 84 6A 04 00 00 84 C0 0F 85 4D FA FF FF 31 C0 44 31 C8 E9 47 FA FF FF 49 B9 FF FF FF FF 09 5B C1 38 31 C0 4D 39 CA 48 0F 47 F0 4C 0F 47 D0 E9 98 FB FF FF 39 D7 0F 8F 11 FE FF FF 29 FA 83 FA 21 0F 8F 4E FD FF FF 83 FA 13 0F 8E 39 02 00 00 8D 42 EC 4D 89 C6 45 89 C0 49 C1 EE 20 89 DB 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 50 08 48 8B 00 48 89 D1 89 D2 48 89 D5 48 89 D7 48 C1 E9 20 49 0F AF E8 49 89 CD 49 0F AF FE 4D 0F AF EE 49 89 EC 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 CF 4C 01 EF 4D 0F AF F8 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 EF 48 89 7C 24 08 48 89 C7 89 C0 48 C1 EF 20 49 89 C5 49 89 C7 4D 0F AF F8 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 4C 0F AF C7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4C 8B 7C 24 10 4D 01 C6 4F 8D 44 3D 00 4D 89 F5 41 89 EF 49 C1 ED 20 4D 01 E7 4D 01 E8 4D 01 C7 48 83 54 24 08 00 49 C1 EB 20 4D 89 D8 4C 89 DD 4C 0F AF C2 48 0F AF D3 48 0F AF E9 45 89 C4 49 C1 E8 20 49 89 D5 89 D2 48 0F AF CB 49 C1 ED 20 49 01 E8 4C 01 E9 4C 01 E1 48 89 CD 48 C1 ED 20 49 01 E8 4C 89 DD 48 0F AF E8 48 0F AF C3 48 0F AF DF 41 89 EC 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF DF 49 C1 ED 20 4C 01 EB 49 01 DC 4C 89 E3 49 C1 E4 20 48 C1 EB 20 49 01 EB 49 01 DB 49 8D 1C 04 48 89 C8 48 C1 E0 20 48 8B 4C 24 08 48 01 D0 4C 01 D8 49 83 D0 00 31 D2 49 01 DF 0F 92 C2 48 01 D0 48 01 C1 41 0F 92 C3 48 39 C2 0F 97 C0 44 09 D8 0F B6 C0 49 01 C0 0F 85 58 00 00 00 8B 44 24 18 49 C1 E6 20 4C 01 F0 4D 39 FA 0F 94 C2 48 39 F0 41 0F 94 C0 44 84 C2 74 09 48 85 C9 0F 84 95 02 00 00 48 85 C9 75 2D 4D 39 FA 72 28 48 39 F0 0F 97 C0 0F B6 C0 21 D0 E9 F6 FD FF FF 0F 1F 00 31 D2 45 31 DB E9 C2 FA FF FF 45 31 C9 45 31 D2 E9 9E FA FF FF B8 01 00 00 00 E9 D4 FD FF FF 48 B8 FF FF FF FF 09 5B C1 38 49 39 C0 77 D2 48 B8 00 00 00 00 00 00 00 7E 48 21 C3 48 39 C3 41 0F 95 C0 48 21 C1 48 39 C1 0F 94 C0 41 38 C0 0F 85 AC FA FF FF 48 B8 00 00 00 00 00 00 00 7E 48 39 C3 0F 94 C0 0F B6 C0 E9 D6 F7 FF FF 48 8B 05 ?? ?? ?? ?? 48 63 D2 49 C1 EB 20 48 8B 3C D0 89 DA 48 89 F9 89 FF 48 C1 E9 20 48 89 CD 49 89 CC 48 0F AF EA 48 0F AF D7 4D 0F AF E3 89 EB 48 C1 ED 20 48 89 D0 89 D2 4C 0F AF DF 48 C1 E8 20 4C 01 E5 48 01 D8 4D 89 C4 45 89 C0 4C 89 C3 49 C1 EC 20 4C 01 D8 49 89 C3 48 C1 E0 20 49 C1 EB 20 48 01 D0 49 01 EB 48 89 CD 48 0F AF DF 49 0F AF E8 49 0F AF FC 49 89 D8 41 89 ED 49 C1 E8 20 48 C1 ED 20 49 0F AF CC 4D 01 E8 49 01 F8 48 01 CD 4C 89 C1 48 C1 E9 20 48 01 E9 48 01 C1 49 83 D3 00 4D 85 DB 0F 85 FC FE FF FF 4C 89 C2 89 D8 48 C1 E2 20 48 01 C2 49 39 CA 41 0F 94 C0 75 09 48 39 D6 0F 84 41 01 00 00 49 39 CA B8 01 00 00 00 0F 82 AE FC FF FF 31 C0 48 39 D6 0F 92 C0 44 21 C0 E9 9E FC FF FF 48 8B 15 ?? ?? ?? ?? 48 98 89 C9 49 C1 EA 20 49 89 F5 49 C1 ED 20 48 8B 3C C2 48 89 FB 89 FF 48 C1 EB 20 48 89 DA 48 89 DD 48 0F AF D1 48 0F AF CF 49 0F AF EA 41 89 D4 48 C1 EA 20 48 89 C8 89 C9 4C 0F AF D7 48 C1 E8 20 48 01 EA 4C 01 E0 49 89 DC 49 0F AF DD 4C 01 D0 48 89 C5 48 C1 E0 20 48 C1 ED 20 48 01 C8 48 01 D5 89 F2 4C 0F AF E2 48 0F AF D7 49 0F AF FD 44 89 E6 49 C1 EC 20 49 89 D2 48 C1 EA 20 49 01 DC 48 01 D6 48 01 FE 48 89 F2 48 C1 EA 20 4C 01 E2 48 01 C2 48 83 D5 00 48 85 ED 0F 85 F3 FB FF FF 48 C1 E6 20 44 89 D0 49 39 D3 4C 8D 14 06 0F 94 C1 75 09 4D 39 C2 0F 84 24 F6 FF FF 49 39 D3 B8 01 00 00 00 0F 87 CB FB FF FF 31 C0 4D 39 C2 0F 92 C0 21 C8 E9 BC FB FF FF 48 BE FF FF FF FF 09 5B C1 38 31 C0 49 39 F2 4C 0F 47 C8 4C 0F 47 D0 E9 60 F8 FF FF 84 C0 0F 84 96 FB FF FF 4D 39 FB B8 01 00 00 00 0F 87 8A FB FF FF 31 C0 4D 39 C2 0F 92 C0 21 D0 E9 7B FB FF FF 44 89 C8 83 F0 01 0F B6 C0 E9 BC F5 FF FF 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_67_16_0 {
	meta:
		name = "__bid128_totalOrderMag"
		size = 2432
		refs = "030c .refptr.__bid_ten2k128 077a .refptr.__bid_ten2k64"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 48 8B 19 48 8B 49 08 48 B8 00 00 00 00 00 00 00 7C 4C 8B 02 4C 8B 5A 08 48 89 CA 49 89 D9 48 21 C2 4D 89 C2 48 39 C2 0F 84 C3 00 00 00 4C 89 DA 48 21 C2 48 39 C2 0F 84 D6 00 00 00 48 BA FF FF FF FF FF FF FF 7F 49 89 CA 49 21 D2 4C 21 DA 49 39 D2 75 0E 49 39 D8 B8 01 00 00 00 0F 84 9F 00 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 C9 49 21 C1 49 39 C1 0F 84 45 01 00 00 4D 89 D9 49 21 C1 49 39 C1 0F 84 88 00 00 00 4C 89 D0 49 B9 FF FF FF FF FF FF 01 00 48 C1 E8 31 49 21 C9 48 89 C6 48 B8 C0 87 AD BE 09 ED 01 00 49 39 C1 77 70 75 0F 48 B8 FF FF FF FF 63 8E 8D 37 48 39 C3 77 5F 48 B8 00 00 00 00 00 00 00 60 48 89 CF 48 21 C7 48 39 C7 0F 84 F6 03 00 00 4D 85 C9 40 0F 94 C5 48 85 DB 0F 94 C0 21 C5 EB 53 0F 1F 44 00 00 4C 89 DB 31 C0 48 21 D3 48 39 D3 0F 84 D0 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 B8 01 00 00 00 EB E8 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CF BD 01 00 00 00 48 21 C7 48 39 C7 0F 84 92 03 00 00 49 BA FF FF FF FF FF FF 01 00 48 89 D7 48 B8 C0 87 AD BE 09 ED 01 00 4D 21 DA 48 C1 EF 31 49 39 C2 41 89 FC 77 1C 0F 85 F6 00 00 00 48 B8 FF FF FF FF 63 8E 8D 37 49 39 C0 0F 86 E3 00 00 00 0F 1F 00 48 B8 00 00 00 00 00 00 00 60 49 21 C3 49 39 C3 0F 84 1F 03 00 00 31 C0 40 84 ED 0F 84 60 FF FF FF 31 D2 44 39 E6 B0 01 0F 9E C2 44 39 E6 0F 45 C2 E9 4B FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 4D 21 CB 4D 39 CB 0F 94 C0 0F B6 C0 E9 30 FF FF FF 48 BA FF FF FF FF FF 3F 00 00 48 89 CB 48 B8 93 8D 44 C6 4D 31 00 00 48 21 D3 4C 21 DA 48 39 C3 0F 87 39 03 00 00 0F 84 4E 05 00 00 48 B8 93 8D 44 C6 4D 31 00 00 48 39 C2 0F 87 F0 02 00 00 0F 84 D1 02 00 00 49 B8 00 00 00 00 00 00 00 7E 4C 21 C1 4C 39 C1 0F 94 C0 4D 21 C3 4D 39 C3 0F 95 C1 38 C1 74 93 48 39 D3 B8 01 00 00 00 0F 82 BD FE FF FF 48 39 D3 0F 94 C0 31 D2 4D 39 D1 0F 96 C2 21 D0 E9 A8 FE FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 4D 89 DD 49 21 C5 49 39 C5 0F 84 3C 02 00 00 4D 85 D2 75 09 4D 85 C0 0F 84 0F FF FF FF 40 84 ED B8 01 00 00 00 0F 85 6C FE FF FF 4D 39 D1 0F 86 A2 02 00 00 31 C0 39 FE 0F 8D 59 FE FF FF 4D 39 D1 B8 01 00 00 00 0F 82 4B FE FF FF 75 09 49 39 D8 0F 87 40 FE FF FF 39 FE 0F 8F A8 02 00 00 29 F7 B8 01 00 00 00 83 FF 21 0F 8F 28 FE FF FF 83 FF 13 0F 8E 85 04 00 00 8D 57 EC 4D 89 C6 45 89 C0 49 C1 EE 20 45 89 DB 48 63 D2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 8B 4A 08 48 8B 12 48 89 CE 89 C9 48 89 CD 48 89 CF 48 C1 EE 20 49 0F AF E8 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4D 0F AF F8 4D 01 FC 4D 89 F7 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 48 89 D7 89 D2 48 C1 EF 20 49 89 D5 4C 0F AF FF 4D 0F AF EE 4C 89 7C 24 10 49 89 D7 4D 0F AF F8 4C 0F AF C7 4D 89 FE 4C 89 7C 24 18 45 89 EF 49 C1 EE 20 49 C1 ED 20 4D 01 FE 4F 8D 3C 06 4C 8B 44 24 10 4F 8D 74 05 00 4D 89 F8 49 C1 E8 20 4D 01 F0 4C 01 C5 48 83 54 24 08 00 49 C1 EA 20 4D 89 D4 4D 89 D5 4C 0F AF E1 49 0F AF CB 4C 0F AF EE 45 89 E0 49 C1 EC 20 49 89 CE 89 C9 49 0F AF F3 49 C1 EE 20 4D 01 EC 4C 01 F6 49 01 F0 4C 89 C6 49 C1 E0 20 48 C1 EE 20 4C 01 E6 4D 89 D4 4C 0F AF E2 49 0F AF D3 4C 0F AF DF 45 89 E5 49 C1 EC 20 49 89 D6 89 D2 4C 0F AF D7 49 C1 EE 20 4D 01 F3 4D 01 EB 4C 89 DF 49 C1 E3 20 49 01 D3 4D 01 E2 49 8D 14 08 48 C1 EF 20 49 01 FA 4C 01 D2 4C 8B 54 24 08 48 83 D6 00 31 C9 4C 01 DD 0F 92 C1 48 01 CA 49 01 D2 41 0F 92 C0 48 39 D1 0F 97 C2 44 09 C2 0F B6 D2 48 01 D6 0F 85 93 FC FF FF 8B 54 24 18 49 C1 E7 20 4C 01 FA 49 39 E9 0F 94 C1 48 39 DA 41 0F 94 C0 44 84 C1 74 09 4D 85 D2 0F 84 6D FC FF FF 4D 85 D2 0F 85 75 FC FF FF 49 39 E9 0F 82 6C FC FF FF 31 C0 48 39 DA 0F 97 C0 21 C8 E9 4C FC FF FF 48 C1 EA 2F 41 89 D4 41 81 E4 FF 3F 00 00 E9 CE FC FF FF 0F 1F 84 00 00 00 00 00 4C 89 D6 BD 01 00 00 00 48 C1 EE 2F 81 E6 FF 3F 00 00 E9 57 FC FF FF 48 B8 FF FF FF FF 09 5B C1 38 49 39 C0 0F 86 1C FD FF FF 66 0F 1F 44 00 00 48 BA 00 00 00 00 00 00 00 7E 48 21 D1 48 39 D1 0F 94 C0 49 21 D3 49 39 D3 0F 95 C1 45 31 D2 31 D2 38 C1 0F 85 1B FD FF FF E9 9B FC FF FF 66 90 31 DB 45 31 C9 E9 C3 FC FF FF 66 0F 1F 44 00 00 0F 94 C0 75 09 49 39 D8 0F 82 50 FD FF FF 4D 39 D1 72 11 49 39 D8 0F 86 65 FD FF FF 84 C0 0F 84 5D FD FF FF 39 FE B8 01 00 00 00 0F 8E 90 FB FF FF 29 FE 31 C0 83 FE 21 0F 8F 83 FB FF FF 83 FE 13 0F 8E CE 02 00 00 44 8D 5E EC 89 DA 49 89 DE 49 C1 EE 20 89 C9 4D 63 DB 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 49 8B 5B 08 4D 8B 1B 48 89 DE 89 DB 48 89 DD 48 89 DF 48 C1 EE 20 48 0F AF EA 49 89 F5 49 0F AF FE 4D 0F AF EE 49 89 EC 89 ED 41 89 FF 49 C1 EC 20 48 C1 EF 20 4D 01 FC 49 89 F7 4C 01 EF 4C 0F AF FA 4D 01 FC 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4C 01 E5 4C 01 EF 48 89 7C 24 08 4C 89 DF 45 89 DB 48 C1 EF 20 4D 89 DD 4D 89 DF 4C 0F AF FA 4D 0F AF EE 4C 0F AF F7 4C 89 7C 24 18 48 0F AF D7 4C 89 74 24 10 4D 89 FE 49 C1 EE 20 45 89 EF 49 C1 ED 20 4D 01 FE 4D 8D 3C 16 4C 8B 74 24 10 4C 89 FA 4D 01 EE 48 C1 EA 20 4C 01 F2 48 01 D5 48 83 54 24 08 00 49 C1 E9 20 4D 89 CC 4D 89 CD 4C 0F AF E3 48 0F AF D9 4C 0F AF EE 44 89 E2 49 C1 EC 20 49 89 DE 89 DB 48 0F AF F1 49 C1 EE 20 4D 01 EC 4C 01 F6 48 01 F2 48 89 D6 48 C1 E2 20 48 C1 EE 20 48 01 DA 4C 01 E6 4D 89 CC 4D 0F AF E3 4C 0F AF D9 48 0F AF CF 45 89 E5 49 C1 EC 20 4D 89 DE 45 89 DB 4C 0F AF CF 49 C1 EE 20 4C 01 F1 4C 01 E9 48 89 CF 48 C1 E1 20 4D 01 E1 48 C1 EF 20 4C 01 D9 49 01 F9 4C 8B 5C 24 08 49 01 D1 48 83 D6 00 48 01 CD 0F 92 C1 0F B6 C9 4A 8D 14 09 49 01 D3 41 0F 92 C1 48 39 D1 0F 97 C2 44 09 CA 0F B6 D2 48 01 D6 0F 85 F1 F9 FF FF 44 8B 4C 24 18 4C 89 FA 48 C1 E2 20 4C 01 CA 49 39 EA 41 0F 94 C1 4D 85 DB 0F 94 C1 4C 39 C2 41 0F 94 C3 45 84 D9 0F 84 02 02 00 00 84 C9 0F 85 BD F9 FF FF 31 C0 E9 B6 F9 FF FF 48 BE FF FF FF FF 09 5B C1 38 31 C0 49 39 F1 48 0F 47 D8 4C 0F 47 C8 E9 96 FA FF FF 48 8B 15 ?? ?? ?? ?? 48 63 FF 44 89 D9 49 C1 EA 20 48 8B 34 FA 48 89 F2 89 F6 48 C1 EA 20 48 89 D7 49 89 D3 48 0F AF F9 48 0F AF CE 4D 0F AF DA 41 89 FC 48 C1 EF 20 48 89 CD 89 C9 4C 0F AF D6 48 C1 ED 20 4C 01 DF 4C 01 E5 4D 89 C4 45 89 C0 49 C1 EC 20 49 01 EA 48 89 D5 4D 89 D3 49 C1 E2 20 49 C1 EB 20 49 01 FB 4C 89 C7 48 0F AF FE 49 0F AF E8 49 0F AF F4 49 89 F8 41 89 ED 49 C1 E8 20 48 C1 ED 20 49 0F AF D4 4D 01 E8 4C 01 C6 48 01 D5 48 89 F2 48 C1 EA 20 4C 8D 44 15 00 49 8D 14 0A 4C 01 C2 49 83 D3 00 4D 85 DB 0F 85 E8 F8 FF FF 48 C1 E6 20 89 FF 48 89 F1 48 01 F9 49 39 D1 41 0F 94 C0 75 09 48 39 D9 0F 84 CA F8 FF FF 49 39 D1 B8 01 00 00 00 0F 82 BC F8 FF FF 31 C0 48 39 D9 0F 97 C0 44 21 C0 E9 AC F8 FF FF 48 8B 15 ?? ?? ?? ?? 48 63 F6 89 C9 49 C1 E9 20 49 89 DD 49 C1 ED 20 48 8B 3C F2 48 89 FE 89 FF 48 C1 EE 20 48 89 F2 48 89 F5 48 0F AF D1 48 0F AF CF 49 0F AF E9 41 89 D4 48 C1 EA 20 49 89 CB 48 C1 E9 20 4C 0F AF CF 4C 01 E1 48 01 EA 45 89 DB 4C 01 C9 49 89 F1 48 89 CD 48 C1 E1 20 48 C1 ED 20 48 01 D5 89 DA 4C 0F AF CA 48 0F AF D7 49 0F AF FD 44 89 CB 49 C1 E9 20 49 89 D4 48 C1 EA 20 49 0F AF F5 48 01 D3 48 01 FB 48 89 DA 48 C1 EA 20 49 01 F1 49 01 D1 4A 8D 14 19 4C 01 CA 48 83 D5 00 48 85 ED 0F 85 00 F8 FF FF 48 C1 E3 20 45 89 E4 48 89 D9 4C 01 E1 49 39 D2 41 0F 94 C1 75 09 4C 39 C1 0F 84 E1 F7 FF FF 49 39 D2 B8 01 00 00 00 0F 87 D3 F7 FF FF 31 C0 4C 39 C1 0F 92 C0 44 21 C8 E9 C3 F7 FF FF 84 C9 0F 84 FE FD FF FF 49 39 EA B8 01 00 00 00 0F 87 AD F7 FF FF 31 C0 4C 39 C2 0F 92 C0 44 21 C8 E9 9D F7 FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__multf3"
		size = 2704
		refs = "0138 .rdata 06e5 __sfp_handle_exceptions"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 78 0F 29 74 24 60 49 89 CC 66 0F 6F 02 C7 44 24 5C 00 00 00 00 66 41 0F 6F 08 0F 29 44 24 20 0F 29 4C 24 30 0F AE 5C 24 5C 48 B8 FF FF FF FF FF FF 00 00 4C 8B 44 24 28 4C 8B 5C 24 20 4C 21 C0 4D 89 C1 49 C1 E8 3F 49 C1 E9 30 41 0F B6 D8 4D 89 DA 48 89 5C 24 40 4C 89 CB 48 89 C6 81 E3 FF 7F 00 00 44 89 C7 0F 84 C5 01 00 00 48 81 FB FF 7F 00 00 0F 84 D8 00 00 00 48 B8 00 00 00 00 00 00 01 00 49 C1 E2 03 48 81 EB FF 3F 00 00 48 09 C6 4C 89 D8 48 C7 44 24 20 00 00 00 00 48 C1 E6 03 48 C1 E8 3D 45 31 F6 48 09 C6 45 31 ED 4C 8B 5C 24 38 48 8B 44 24 30 48 BA FF FF FF FF FF FF 00 00 4D 89 D9 4C 21 DA 49 C1 EB 3F 49 C1 E9 30 45 0F B6 FB 48 89 C1 41 81 E1 FF 7F 00 00 48 89 D5 4C 89 7C 24 30 0F 84 F5 01 00 00 49 81 F9 FF 7F 00 00 0F 84 B8 01 00 00 48 BA 00 00 00 00 00 00 01 00 48 C1 E1 03 49 81 E9 FF 3F 00 00 48 09 D5 48 89 C2 31 C0 48 C1 E5 03 48 C1 EA 3D 48 09 D5 4C 8B 7C 24 20 48 8D 15 ?? ?? ?? ?? 45 31 D8 49 01 D9 45 0F B6 C0 49 8D 59 01 49 09 C7 4E 63 3C BA 4C 01 FA FF E2 66 2E 0F 1F 84 00 00 00 00 00 4C 09 D8 0F 85 67 02 00 00 48 C7 44 24 20 08 00 00 00 31 F6 45 31 D2 41 BE 02 00 00 00 45 31 ED E9 38 FF FF FF 48 89 EE 49 89 CA 4C 89 44 24 40 49 89 C6 49 83 FE 02 0F 85 C6 01 00 00 0F B6 7C 24 40 B9 FF 7F 00 00 31 F6 45 31 D2 83 E7 01 49 B8 FF FF FF FF FF FF 00 00 48 C7 44 24 28 00 00 00 00 48 B8 00 00 00 00 00 00 FF FF 4C 21 C6 48 C1 E1 30 40 0F B6 FF 48 89 F5 48 8B 74 24 28 48 C1 E7 3F 4C 89 54 24 20 48 21 C6 48 B8 FF FF FF FF FF FF FF 7F 48 09 EE 48 BD FF FF FF FF FF FF 00 80 48 21 EE 48 09 CE 48 21 C6 48 09 FE 45 85 ED 48 89 74 24 28 66 0F 6F 74 24 20 0F 85 BF 04 00 00 41 0F 29 34 24 4C 89 E0 0F 28 74 24 60 48 83 C4 78 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 89 C1 4C 09 D9 0F 84 64 01 00 00 48 85 C0 0F 84 AC 04 00 00 48 0F BD E8 48 83 F5 3F 48 63 ED 48 8D 55 F1 48 83 FA 3C 0F 8F 82 04 00 00 44 8D 52 03 41 B9 3D 00 00 00 4C 89 DE 44 89 D1 48 D3 E0 44 89 C9 29 D1 48 D3 EE 44 89 D1 49 D3 E3 48 09 C6 4D 89 DA 49 C7 C1 11 C0 FF FF 48 C7 44 24 20 00 00 00 00 45 31 F6 4C 89 CB 41 BD 02 00 00 00 48 29 EB E9 04 FE FF FF 0F 1F 80 00 00 00 00 48 89 D0 48 09 C8 0F 84 D4 00 00 00 48 BA 00 00 00 00 00 80 00 00 B8 03 00 00 00 48 85 D5 0F 85 4C FE FF FF 41 83 CD 01 E9 43 FE FF FF 0F 1F 00 48 89 D1 48 09 C1 0F 84 94 00 00 00 48 85 D2 0F 84 2B 04 00 00 48 0F BD CA 48 83 F1 3F 48 63 C9 48 89 4C 24 48 48 8B 4C 24 48 4C 8D 49 F1 49 83 F9 3C 0F 8F ED 03 00 00 41 8D 49 03 48 89 C5 41 89 CF 48 D3 E2 B9 3D 00 00 00 44 29 C9 48 D3 ED 44 89 F9 48 D3 E0 48 09 D5 48 89 C1 49 C7 C1 11 C0 FF FF 41 83 CD 02 4C 2B 4C 24 48 31 C0 E9 CD FD FF FF 49 83 FE 03 0F 84 F3 06 00 00 49 83 FE 01 0F 85 F2 04 00 00 0F B6 7C 24 40 31 C9 31 F6 45 31 D2 83 E7 01 E9 24 FE FF FF 0F 1F 44 00 00 31 ED 31 C9 B8 01 00 00 00 E9 92 FD FF FF 66 90 31 ED 31 C9 B8 02 00 00 00 E9 82 FD FF FF 66 90 48 C7 44 24 20 04 00 00 00 31 F6 45 31 D2 41 BE 01 00 00 00 45 31 ED E9 F1 FC FF FF 0F 1F 40 00 49 89 F5 48 C7 44 24 20 0C 00 00 00 41 BE 03 00 00 00 49 C1 ED 2F 49 83 F5 01 41 83 E5 01 E9 CA FC FF FF 41 83 CD 01 BF 01 00 00 00 48 BE 00 00 00 00 00 80 00 00 45 31 D2 B9 FF 7F 00 00 E9 9C FD FF FF 4C 89 44 24 40 E9 76 FD FF FF 0F 1F 00 48 8B 7C 24 30 48 89 EE 49 89 CA 49 89 C6 48 89 7C 24 40 E9 5B FD FF FF 0F 1F 84 00 00 00 00 00 4C 89 D0 48 F7 E1 49 89 D3 49 89 C6 4C 89 D0 48 F7 E5 49 89 C2 49 89 D7 48 89 F0 48 F7 E1 48 89 D1 48 89 C7 48 89 F0 31 F6 48 F7 E5 4D 01 DA 40 0F 92 C6 4C 01 F8 4C 01 D7 48 8D 2C 06 41 0F 92 C2 45 0F B6 D2 48 39 EE 4C 8D 5C 0D 00 40 0F 97 C6 49 39 C7 4D 89 D7 0F 97 C0 09 C6 40 0F B6 F6 48 01 F2 4D 01 DF 40 0F 92 C6 4C 39 D9 0F 97 C0 45 31 D2 09 F0 0F B6 C0 48 8D 34 02 4C 89 F8 48 C1 E8 33 48 C1 E6 0D 48 09 C6 48 89 F8 48 C1 E0 0D 4C 09 F0 48 B8 00 00 00 00 00 00 10 00 41 0F 95 C2 48 C1 EF 33 49 C1 E7 0D 4C 09 D7 4D 89 FA 49 09 FA 48 85 C6 74 1C 4C 89 D2 48 89 F0 49 D1 EA 83 E2 01 48 C1 E0 3F 48 D1 EE 49 09 D2 49 89 D9 49 09 C2 49 8D 89 FF 3F 00 00 48 85 C9 0F 8E 7C 02 00 00 41 F6 C2 07 74 3B 8B 44 24 5C 41 83 CD 20 25 00 60 00 00 3D 00 20 00 00 0F 84 0E 02 00 00 3D 00 40 00 00 0F 84 B3 03 00 00 85 C0 75 14 4C 89 D0 83 E0 0F 48 83 F8 04 74 08 49 83 C2 04 48 83 D6 00 48 B8 00 00 00 00 00 00 10 00 48 85 C6 74 14 48 B8 FF FF FF FF FF FF EF FF 49 8D 89 00 40 00 00 48 21 C6 48 81 F9 FE 7F 00 00 0F 8F 8E 00 00 00 48 89 F0 49 C1 EA 03 48 C1 E6 0D 48 C1 E0 3D 44 89 C7 48 C1 EE 10 49 09 C2 66 81 E1 FF 7F 83 E7 01 E9 F4 FB FF FF 0F 1F 44 00 00 48 39 EE 77 3F 0F 94 C0 49 39 CA 76 04 84 C0 75 33 48 BE 00 00 00 00 00 80 00 00 48 09 EE 49 39 CA 0F 85 29 03 00 00 84 C0 0F 84 21 03 00 00 48 B8 FF FF FF FF FF FF 00 00 49 89 CA 48 21 C6 E9 05 FE FF FF 48 BD 00 00 00 00 00 80 00 00 48 B8 FF FF FF FF FF FF 00 00 48 09 EE 48 21 C6 E9 E6 FD FF FF 8B 44 24 5C 25 00 60 00 00 3D 00 20 00 00 0F 84 39 01 00 00 3D 00 40 00 00 0F 84 82 02 00 00 83 F8 01 BE 00 00 00 00 48 BA FF FF FF FF FF FF 00 00 19 C9 F7 D1 66 81 C1 FF 7F 85 C0 48 0F 45 F2 83 F8 01 4D 19 D2 49 F7 D2 41 83 CD 28 41 83 E0 01 48 BD FF FF FF FF FF FF 00 00 48 C7 44 24 28 00 00 00 00 48 B8 00 00 00 00 00 00 FF FF 48 21 F5 48 8B 74 24 28 81 E1 FF 7F 00 00 48 C1 E1 30 45 0F B6 C0 4C 89 54 24 20 49 C1 E0 3F 48 21 C6 48 B8 FF FF FF FF FF FF 00 80 48 09 EE 48 21 C6 48 B8 FF FF FF FF FF FF FF 7F 48 09 F1 48 21 C1 4C 09 C1 48 89 4C 24 28 66 0F 6F 74 24 20 44 89 E9 E8 ?? ?? ?? ?? E9 34 FB FF FF 66 90 8D 4A C3 4C 89 DE 45 31 D2 48 D3 E6 E9 94 FB FF FF 49 0F BD EB 48 83 F5 3F 48 63 ED 48 83 C5 40 E9 4B FB FF FF 41 8D 49 C3 48 D3 E0 31 C9 48 89 C5 E9 26 FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 0F BD C8 48 83 F1 3F 48 63 C9 48 83 C1 40 48 89 4C 24 48 E9 CC FB FF FF 0F 1F 80 00 00 00 00 4D 85 C0 0F 84 0C FE FF FF 49 83 C2 08 48 83 D6 00 E9 FF FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 49 83 F8 01 B8 00 00 00 00 48 BE FF FF FF FF FF FF 00 00 19 C9 66 81 C1 FF 7F 4D 85 C0 48 0F 45 F0 49 83 F8 01 4D 19 D2 E9 CF FE FF FF 0F 1F 00 48 C7 C0 02 C0 FF FF 4C 29 C8 48 83 F8 74 0F 8F CC 00 00 00 48 83 F8 3F 0F 8F 92 01 00 00 BA 40 00 00 00 49 89 F1 4C 89 D7 29 C2 89 D1 49 D3 E1 89 C1 48 D3 EF 89 D1 31 D2 49 D3 E2 49 09 F9 89 C1 4D 85 D2 0F 95 C2 48 D3 EE 49 09 D1 41 F6 C1 07 74 2B 8B 44 24 5C 41 83 CD 20 25 00 60 00 00 3D 00 20 00 00 0F 84 4A 02 00 00 3D 00 40 00 00 0F 84 27 02 00 00 85 C0 0F 84 9D 01 00 00 48 B8 00 00 00 00 00 00 08 00 48 85 C6 0F 85 FF 00 00 00 49 89 F2 48 C1 E6 0D 49 C1 E2 3D 48 C1 EE 10 49 C1 E9 03 4D 09 CA 41 F6 C5 20 0F 85 37 01 00 00 F6 44 24 5D 08 0F 85 2C 01 00 00 44 89 C7 31 C9 83 E7 01 E9 46 F9 FF FF 49 89 D9 4C 8B 44 24 40 E9 9E FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 4C 09 D6 74 2B 8B 44 24 5C 41 83 CD 20 25 00 60 00 00 3D 00 20 00 00 0F 84 91 01 00 00 3D 00 40 00 00 0F 84 56 01 00 00 85 C0 0F 84 28 01 00 00 31 F6 45 31 D2 41 83 CD 10 41 83 E0 01 31 C9 E9 B0 FD FF FF 49 83 F8 01 B8 00 00 00 00 48 BE FF FF FF FF FF FF 00 00 19 C9 F7 D1 66 81 C1 FF 7F 4D 85 C0 48 0F 44 F0 49 83 F8 01 4D 19 D2 49 F7 D2 E9 76 FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 4D 85 C0 0F 85 5C FC FF FF E9 4B FE FF FF 66 90 48 B8 FF FF FF FF FF FF 00 00 44 89 DF 49 89 CA 48 21 C6 E9 E1 FA FF FF 0F 1F 84 00 00 00 00 00 41 83 CD 20 31 F6 B9 01 00 00 00 45 31 D2 41 83 CD 10 41 83 E0 01 E9 29 FD FF FF 0F 1F 44 00 00 8D 48 C0 48 89 F2 48 D3 EA 31 C9 48 83 F8 40 74 0A B1 80 29 C1 48 D3 E6 48 89 F1 45 31 C9 4C 09 D1 41 0F 95 C1 49 09 D1 4D 89 CA 41 83 E2 07 75 0B 31 F6 E9 B8 FE FF FF 31 C9 EB B2 8B 44 24 5C 41 83 CD 20 25 00 60 00 00 3D 00 20 00 00 0F 84 AF 00 00 00 3D 00 40 00 00 0F 84 8C 00 00 00 31 F6 85 C0 0F 85 78 FE FF FF 31 F6 4C 89 C8 83 E0 0F 48 83 F8 04 0F 84 53 FE FF FF 49 83 C1 04 48 83 D6 00 E9 46 FE FF FF 48 BE FF FF FF FF FF FF 00 00 31 C0 41 BA 01 00 00 00 49 83 C2 04 48 83 D0 00 48 21 C6 49 C1 EA 03 E9 B7 FE FF FF 4D 85 C0 4C 89 C0 0F 85 A6 FE FF FF 48 BE FF FF FF FF FF FF 00 00 41 BA 01 00 00 00 49 83 C2 08 48 83 D0 00 48 21 C6 49 C1 EA 03 E9 87 FE FF FF 4D 85 C0 0F 84 79 FE FF FF 31 C0 EB CF 31 F6 4D 85 C0 0F 85 D8 FD FF FF 49 83 C1 08 48 83 D6 00 E9 CB FD FF FF 31 F6 4D 85 C0 0F 84 C0 FD FF FF EB E6 0F B6 7C 24 40 48 BD 00 00 00 00 00 80 00 00 48 B8 FF FF FF FF FF FF 00 00 48 09 EE 48 21 C6 83 E7 01 E9 82 F9 FF FF 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__bid_trunctdsd2"
		size = 48
		refs = "001b __bid128_to_bid32"
	strings:
		$1 = { 48 83 EC 38 48 8B 51 08 48 8B 01 48 8D 4C 24 20 48 89 44 24 20 48 89 54 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__bid_fixtddi"
		size = 48
		refs = "001b __bid128_to_int64_xint"
	strings:
		$1 = { 48 83 EC 38 48 8B 51 08 48 8B 01 48 8D 4C 24 20 48 89 44 24 20 48 89 54 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "__bid_fixtdsi"
		size = 48
		refs = "001b __bid128_to_int32_xint"
	strings:
		$1 = { 48 83 EC 38 48 8B 51 08 48 8B 01 48 8D 4C 24 20 48 89 44 24 20 48 89 54 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__bid_trunctddd2"
		size = 48
		refs = "001b __bid128_to_bid64"
	strings:
		$1 = { 48 83 EC 38 48 8B 51 08 48 8B 01 48 8D 4C 24 20 48 89 44 24 20 48 89 54 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "isinfd128"
		size = 48
		refs = "001b __bid128_isInf"
	strings:
		$1 = { 48 83 EC 38 48 8B 51 08 48 8B 01 48 8D 4C 24 20 48 89 44 24 20 48 89 54 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__fixsfti"
		size = 96
		refs = "0024 .rdata 002c __fixunssfti"
	strings:
		$1 = { 48 83 EC 38 66 0F EF C9 0F 2E C8 77 13 48 83 C4 38 E9 ?? ?? ?? ?? 66 2E 0F 1F 84 00 00 00 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 57 C1 E8 ?? ?? ?? ?? 0F 29 44 24 20 48 8B 44 24 20 48 8B 54 24 28 48 F7 D8 48 83 D2 00 48 89 44 24 20 48 F7 DA 48 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 38 C3 90 90 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__fixunssfti"
		size = 192
		refs = "0008 .rdata"
	strings:
		$1 = { 48 83 EC 18 F2 0F 10 0D ?? ?? ?? ?? F3 0F 5A C0 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 C8 66 0F 2E CA 73 3E F2 48 0F 2C D1 48 85 D2 78 4F 66 0F EF C9 F2 48 0F 2A CA F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C C1 66 0F 2E C2 73 59 F2 48 0F 2C C0 48 89 04 24 48 89 54 24 08 66 0F 6F 04 24 48 83 C4 18 C3 90 F2 0F 5C CA 48 B8 00 00 00 00 00 00 00 80 F2 48 0F 2C D1 48 31 C2 48 85 D2 79 B1 48 89 D0 48 89 D1 66 0F EF C9 48 D1 E8 83 E1 01 48 09 C8 F2 48 0F 2A C8 F2 0F 58 C9 EB 9C 0F 1F 80 00 00 00 00 F2 0F 5C C2 48 B9 00 00 00 00 00 00 00 80 F2 48 0F 2C C0 48 31 C8 EB 94 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__floatunditf"
		size = 256
	strings:
		$1 = { 48 83 EC 18 48 85 D2 48 89 C8 0F 84 E0 00 00 00 48 0F BD CA 41 B8 3E 40 00 00 48 83 F1 3F 41 29 C8 B9 6F 40 00 00 4D 63 C8 4C 29 C9 48 83 F9 3F 0F 8E 8A 00 00 00 B9 2F 40 00 00 44 29 C1 66 41 81 E0 FF 7F 48 D3 E2 49 89 D1 48 BA FF FF FF FF FF FF 00 00 49 21 D1 31 D2 48 C7 44 24 08 00 00 00 00 48 8B 4C 24 08 49 C1 E0 30 48 89 14 24 48 BA FF FF FF FF FF FF 00 00 49 21 D1 48 BA 00 00 00 00 00 00 FF FF 48 21 CA 48 B9 FF FF FF FF FF FF FF 7F 4C 09 CA 49 B9 FF FF FF FF FF FF 00 80 4C 21 CA 4C 09 C2 48 21 CA 48 89 54 24 08 66 0F 6F 04 24 0F 29 00 48 83 C4 18 C3 0F 1F 44 00 00 41 8D 88 D1 BF FF FF 49 89 D1 49 D3 E9 B9 6F 40 00 00 44 29 C1 66 41 81 E0 FF 7F 48 D3 E2 48 B9 FF FF FF FF FF FF 00 00 49 21 C9 E9 69 FF FF FF 45 31 C0 45 31 C9 E9 5E FF FF FF 90 90 90 90 90 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__bid64_add"
		size = 4160
		refs = "0142 .refptr.__bid_power10_table_128 014f .refptr.__bid_estimate_decimal_digits 019b .refptr.__bid_IDEC_glbflags 01a5 .refptr.__bid_IDEC_glbround 0298 .refptr.__bid_estimate_bin_expon 02e1 .refptr.__bid_reciprocals10_64 0347 .refptr.__bid_round_const_table 03e5 .refptr.__bid_short_recip_scale"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 58 48 B8 00 00 00 00 00 00 00 60 48 BD 00 00 00 00 00 00 00 80 49 89 C8 48 21 CD 49 21 C0 49 39 C0 0F 84 2F 06 00 00 49 89 CA 49 BB FF FF FF FF FF FF 1F 00 49 C1 EA 35 49 21 CB 41 81 E2 FF 03 00 00 4C 89 DB 48 B8 00 00 00 00 00 00 00 60 49 89 D0 49 B9 00 00 00 00 00 00 00 80 49 21 C0 49 21 D1 49 39 C0 0F 84 8B 05 00 00 48 89 D0 49 B8 FF FF FF FF FF FF 1F 00 48 C1 E8 35 49 21 D0 89 C7 81 E7 FF 03 00 00 48 85 DB 4C 89 C3 75 63 48 BE 00 00 00 00 00 00 00 7C 48 89 C8 48 21 F0 48 39 F0 0F 84 EB 06 00 00 49 BC 00 00 00 00 00 00 00 78 48 89 C8 4C 21 E0 4C 39 E0 0F 84 45 08 00 00 41 39 FA 40 0F 9D C6 4D 85 C0 0F 95 C0 40 84 C6 74 1F 48 89 D6 48 89 D0 4C 21 E6 4C 39 E6 74 11 48 83 C4 58 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 85 DB 0F 84 06 01 00 00 41 39 FA 0F 8D C9 05 00 00 89 F9 44 29 D1 4D 85 C0 0F 88 41 08 00 00 66 0F EF C9 F2 49 0F 2A C8 66 48 0F 7E CA 48 01 D2 48 C1 EA 35 83 F9 10 8D 82 01 FC FF FF 48 8B 15 ?? ?? ?? ?? 0F 8E 49 01 00 00 48 8B 1D ?? ?? ?? ?? 48 98 48 8B 15 ?? ?? ?? ?? 8B 1C 83 48 63 C3 48 C1 E0 04 4C 3B 04 02 B8 10 00 00 00 83 DB FF 29 D8 48 63 D8 29 C1 48 C1 E3 04 4C 0F AF 04 1A 83 F9 10 0F 8E E7 00 00 00 29 C7 4D 85 DB 89 F8 0F 84 D8 0A 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 48 8B 15 ?? ?? ?? ?? 44 8B 12 41 F6 C2 03 0F 84 EE 08 00 00 41 83 FA 01 0F 84 B2 0C 00 00 41 83 FA 02 0F 85 95 09 00 00 48 85 ED 0F 85 AD 09 00 00 4C 89 CA 48 C1 FA 3F 48 83 CA 01 49 01 D0 48 BA FF 7F C6 A4 7E 8D 03 00 49 39 D0 0F 86 E8 08 00 00 48 BA FF FF C0 6F F2 86 23 00 49 39 D0 0F 86 B2 0C 00 00 83 C0 01 E9 87 0A 00 00 90 48 B8 00 00 00 00 00 00 00 78 48 89 D3 48 21 C3 48 39 C3 0F 84 BB 06 00 00 4D 85 DB 0F 85 9E 04 00 00 4D 89 D0 48 89 F8 49 C1 E0 35 48 C1 E0 35 41 39 FA 49 0F 4E C0 4C 39 CD 0F 84 90 0C 00 00 48 8B 15 ?? ?? ?? ?? 83 3A 01 0F 85 90 FE FF FF 49 B9 00 00 00 00 00 00 00 80 4C 09 C8 E9 7E FE FF FF 4D 85 C0 0F 88 B7 0C 00 00 66 0F EF DB F2 49 0F 2A D8 66 48 0F 7E D8 48 01 C0 48 C1 E8 35 2D FF 03 00 00 48 8B 1D ?? ?? ?? ?? 48 63 F1 8B 3C B3 01 C7 83 FF 3B 0F 8E 53 04 00 00 48 8B 1D ?? ?? ?? ?? 4D 85 C9 8B 1B 89 5C 24 14 74 0C 8D 7B FF 83 FF 01 0F 86 95 0C 00 00 48 8B 3D ?? ?? ?? ?? 48 98 4C 31 CD 48 C1 FD 3F 41 89 DC 4C 8B 2D ?? ?? ?? ?? 44 8B 3C 87 BF 10 00 00 00 89 F8 29 C8 48 98 48 C1 E0 04 48 8B 04 02 49 89 C6 48 89 44 24 38 49 63 C7 48 C1 E0 04 4C 3B 04 02 4C 89 C0 41 83 DF FF 4C 29 F0 49 01 EB 44 29 FF 48 89 44 24 20 4B 8D 04 E4 29 F9 49 31 EB 89 7C 24 18 4D 89 DE 89 4C 24 10 4C 89 5C 24 30 49 8D 04 44 4C 63 D9 48 8B 0D ?? ?? ?? ?? 4C 01 D8 48 8B 0C C1 48 B8 00 00 C1 6F F2 86 23 00 4C 01 F0 48 89 CD 48 89 4C 24 40 4B 8B 4C DD 00 48 01 E8 48 89 C5 89 C0 89 CF 49 89 CE 48 C1 ED 20 49 C1 EE 20 48 89 F9 48 89 7C 24 48 48 0F AF CD 4C 89 74 24 28 49 0F AF EE 48 0F AF F8 48 0F AF 44 24 28 41 89 CE 48 C1 E9 20 48 89 6C 24 08 48 89 FD 89 FF 48 C1 ED 20 49 01 EE 48 8B 6C 24 08 49 01 C6 48 01 CD 4C 89 F1 49 C1 E6 20 48 C1 E9 20 48 01 CD 49 8D 0C 3E 48 8B 7C 24 20 48 89 E8 48 89 4C 24 08 48 8B 0D ?? ?? ?? ?? 46 8B 34 99 44 89 F1 48 D3 E8 48 63 4C 24 18 48 C1 E1 04 48 0F AF 3C 0A 48 B9 FE 7F FA CA 73 F9 1F 00 48 01 C7 48 B8 FF 7F 39 5B 81 72 FC FF 48 01 F8 48 39 C8 0F 86 2F 01 00 00 48 B8 FF FF C0 6F F2 86 23 00 48 39 C7 0F 86 A9 08 00 00 8B 44 24 18 85 C0 0F 85 3F 0B 00 00 4C 89 C5 44 89 C7 48 C1 E6 04 48 C1 ED 20 48 69 C5 34 33 33 33 48 69 CF 34 33 33 33 48 69 FF 33 33 33 33 41 89 C3 48 C1 E8 20 48 C1 E9 20 48 69 ED 33 33 33 33 4C 01 D9 48 01 F9 48 C1 E9 20 48 01 E8 48 8D 2C 08 48 D1 ED 48 8D 0C ED 00 00 00 00 48 89 E8 48 01 ED 48 2B 44 24 38 49 29 C8 49 29 E8 4C 0F AF 04 32 4C 01 44 24 30 83 44 24 10 01 4B 8D 14 E4 49 B8 00 00 8A 5D 78 45 63 01 8B 74 24 10 49 8D 14 54 4C 63 DE 48 8B 35 ?? ?? ?? ?? 4C 01 DA 4C 03 04 D6 4B 8B 54 DD 00 4C 03 44 24 30 48 89 D1 89 D2 48 C1 E9 20 4C 89 C6 45 89 C0 48 C1 EE 20 48 89 F5 48 0F AF EA 49 0F AF D0 48 0F AF F1 41 89 EC 48 C1 ED 20 48 89 D7 89 D2 49 0F AF C8 48 C1 EF 20 48 01 F5 4C 01 E7 4C 8D 3C 0F 4C 89 F9 49 C1 E7 20 49 8D 34 17 48 C1 E9 20 48 01 CD 48 89 74 24 08 48 8B 35 ?? ?? ?? ?? 48 89 EF 46 8B 34 9E 44 89 F1 48 D3 EF 48 01 C7 B9 40 00 00 00 44 29 F1 48 D3 E5 85 DB 0F 85 DA 02 00 00 40 F6 C7 01 74 09 48 85 ED 0F 84 5B 08 00 00 48 BA 00 00 00 00 00 00 00 80 B8 20 00 00 00 48 39 D5 0F 84 01 05 00 00 4C 8B 05 ?? ?? ?? ?? 41 0B 00 89 C2 41 89 00 8B 44 24 10 44 01 D0 3D FE 02 00 00 0F 86 3D 02 00 00 48 B9 00 00 C1 6F F2 86 23 00 48 39 CF 0F 85 1F 02 00 00 3D FF 02 00 00 0F 85 14 02 00 00 89 D0 8B 74 24 14 83 C8 28 41 89 00 48 B8 00 00 00 00 00 00 00 78 4C 09 C8 83 FE 02 0F 84 B3 08 00 00 83 FE 03 0F 84 D8 09 00 00 83 FE 01 0F 85 F0 FA FF FF E9 D5 05 00 00 48 B8 00 00 00 00 00 00 00 78 49 89 D0 49 21 C0 49 39 C0 0F 84 67 02 00 00 49 B8 FF FF FF FF FF FF 07 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 D0 49 09 C0 48 B8 FF FF C0 6F F2 86 23 00 49 39 C0 B8 00 00 00 00 4C 0F 47 C0 48 89 D0 48 C1 E8 33 89 C7 81 E7 FF 03 00 00 E9 31 FA FF FF 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 74 05 00 00 49 BB FF FF FF FF FF FF 07 00 49 89 CA 4C 89 D8 49 BB 00 00 00 00 00 00 20 00 48 21 C8 49 09 C3 48 B8 FF FF C0 6F F2 86 23 00 49 39 C3 B8 00 00 00 00 4C 0F 47 D8 49 C1 EA 33 41 81 E2 FF 03 00 00 4C 89 DB E9 8D F9 FF FF 66 0F 1F 84 00 00 00 00 00 41 39 FA 48 89 C8 0F 8E 14 FA FF FF 89 F8 44 89 D7 41 89 C2 4C 89 C0 4D 89 D8 49 89 C3 4C 89 C8 49 89 E9 48 89 C5 E9 18 FA FF FF 0F 1F 44 00 00 48 C1 FD 3F 48 C1 E6 04 4C 89 CB 49 01 EB 48 C1 FB 3F 4C 89 D9 4D 89 C3 4C 0F AF 1C 32 48 31 E9 49 01 DB 49 31 DB 49 01 CB 48 B9 00 00 00 00 00 00 00 80 4D 89 D9 49 C1 F9 3F 4D 01 CB 4C 89 DE 4C 31 CE 49 21 C9 48 3B B2 00 01 00 00 0F 83 52 02 00 00 48 8B 05 ?? ?? ?? ?? 83 38 01 0F 84 80 06 00 00 48 B8 FF FF FF FF FF FF 1F 00 48 39 C6 0F 86 82 06 00 00 4C 89 D0 48 BA 00 00 00 00 00 00 00 60 48 C1 E0 33 48 09 D0 49 09 C1 48 B8 FF FF FF FF FF FF 07 00 48 21 F0 4C 09 C8 E9 4E F9 FF FF 48 B8 00 00 00 00 00 00 00 7E 48 21 C1 48 39 C1 0F 84 A8 04 00 00 48 21 C2 48 39 C2 0F 84 9C 04 00 00 49 B9 FF FF FF FF FF FF FF FD 4C 89 D8 4C 21 C8 E9 17 F9 FF FF 0F 1F 80 00 00 00 00 3D FF 02 00 00 0F 85 FE 07 00 00 48 BA FF FF FF FF FF FF 1F 00 48 39 D7 0F 86 92 01 00 00 48 BA 00 00 C1 6F F2 86 23 00 48 39 D7 0F 84 FF 06 00 00 49 89 C2 48 BA FF FF FF FF FF FF 07 00 48 B8 00 00 00 00 00 00 00 60 49 09 C1 48 21 D7 49 C1 E2 33 49 09 F9 4C 89 C8 4C 09 D0 E9 B0 F8 FF FF 83 FB 03 0F 84 37 02 00 00 83 FB 04 0F 84 23 FD FF FF 83 FB 01 0F 84 25 02 00 00 48 8B 44 24 08 4B 03 44 DD 00 0F 92 C0 48 D3 ED 44 89 F1 0F B6 C0 48 01 C5 48 D3 ED 48 83 FD 01 19 C0 83 E0 20 E9 08 FD FF FF 48 BE FF FF FF FF FF FF 03 00 49 B8 00 00 00 00 00 00 00 FE 48 B8 FF 7F C6 A4 7E 8D 03 00 48 21 D6 49 21 D0 48 39 C6 77 0D 49 B8 FF FF FF FF FF FF 03 FE 49 21 D0 48 B8 00 00 00 00 00 00 00 7C 48 BE 00 00 00 00 00 00 00 78 48 21 D0 48 39 F0 0F 84 95 06 00 00 48 85 DB 0F 84 DE 04 00 00 48 B8 00 00 00 00 00 00 00 7E 48 21 C2 48 39 C2 75 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 49 B9 FF FF FF FF FF FF FF FD 4C 89 C0 4C 21 C8 E9 DB F7 FF FF 48 89 D1 48 21 F1 48 39 C1 0F 84 CC 05 00 00 48 39 F1 4C 89 D8 0F 85 C0 F7 FF FF 48 B9 00 00 00 00 00 00 00 7E 48 B8 FF FF FF FF FF FF FF FD 48 21 CA 4C 21 C0 48 39 CA 0F 85 9D F7 FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 01 E9 8E F7 FF FF 4C 89 C2 4C 89 C0 66 0F EF C0 48 D1 EA 83 E0 01 48 09 C2 F2 48 0F 2A C2 66 0F 28 D0 F2 0F 58 D0 66 48 0F 7E D2 E9 A3 F7 FF FF 0F 1F 40 00 49 89 C2 49 09 F9 49 C1 E2 35 4C 89 C8 4C 09 D0 E9 4B F7 FF FF 48 3B B2 10 01 00 00 C7 44 24 10 01 00 00 00 0F 83 07 03 00 00 48 8B 05 ?? ?? ?? ?? 4D 85 C9 8B 00 89 44 24 14 89 C3 74 12 83 E8 01 83 F8 01 77 0A BB 03 00 00 00 2B 5C 24 14 90 89 DA 4C 63 5C 24 10 4C 8B 2D ?? ?? ?? ?? 48 8D 04 D2 48 8D 14 42 48 8B 05 ?? ?? ?? ?? 4C 01 DA 48 03 34 D0 4B 8B 54 DD 00 48 89 D1 89 D2 49 89 F0 89 F0 48 C1 E9 20 49 C1 E8 20 4C 89 C5 48 0F AF EA 48 0F AF D0 48 0F AF C1 41 89 EF 48 C1 ED 20 48 89 D6 89 D2 48 C1 EE 20 49 01 F7 49 01 C7 4C 0F AF C1 4C 89 F9 49 C1 E7 20 49 8D 04 17 48 C1 E9 20 48 89 44 24 08 48 8B 05 ?? ?? ?? ?? 4C 01 C5 48 01 CD 46 8B 34 98 48 89 EF 44 89 F1 48 D3 EF E9 DC FA FF FF 66 0F 1F 84 00 00 00 00 00 48 85 ED B8 20 00 00 00 0F 85 FF FA FF FF 48 8B 44 24 08 4B 3B 44 DD 00 19 C0 F7 D0 83 E0 20 E9 E9 FA FF FF 83 F9 11 0F 85 D3 00 00 00 48 BA 00 80 C6 A4 7E 8D 03 00 49 39 D0 0F 85 C0 00 00 00 48 BA 00 80 E0 37 79 C3 11 00 49 39 D3 0F 86 C3 01 00 00 49 39 E9 0F 84 BA 01 00 00 83 E8 01 3D FE 02 00 00 0F 86 D6 04 00 00 3D FF 02 00 00 49 B8 FF FF C0 6F F2 86 23 00 74 3B 3D FF 02 00 00 0F 8F 9F 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 BA FF FF FF FF FF FF 1F 00 49 39 D0 0F 86 8F 01 00 00 48 BA 00 00 C1 6F F2 86 23 00 49 39 D0 0F 84 1A 03 00 00 48 BA FF FF FF FF FF FF 07 00 4C 21 C2 49 B8 00 00 00 00 00 00 00 60 48 C1 E0 33 4D 09 C8 49 09 D0 4C 09 C0 E9 91 F5 FF FF 49 39 E9 74 1C 49 83 E8 01 48 BA FF 7F C6 A4 7E 8D 03 00 49 39 D0 0F 86 61 FF FF FF 0F 1F 44 00 00 3D FE 02 00 00 76 89 48 BA 00 00 C1 6F F2 86 23 00 49 39 D0 0F 85 76 02 00 00 3D FF 02 00 00 0F 85 6B 02 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 48 B8 00 00 00 00 00 00 00 78 4C 09 C8 41 83 FA 02 0F 84 DB 02 00 00 41 83 FA 03 0F 84 FF 03 00 00 41 83 FA 01 0F 85 16 F5 FF FF 4D 85 C9 0F 85 0D F5 FF FF 48 B8 FF FF C0 6F F2 86 FB 77 E9 FE F4 FF FF 48 B8 FF FF FF FF FF FF 03 00 49 BB 00 00 00 00 00 00 00 FE 49 B8 FF 7F C6 A4 7E 8D 03 00 48 21 C8 49 21 CB 4C 39 C0 0F 86 91 01 00 00 48 B8 00 00 00 00 00 00 00 7C 49 B8 00 00 00 00 00 00 00 78 45 31 D2 48 21 C8 31 DB 4C 39 C0 0F 85 10 F4 FF FF 49 BB 00 00 00 00 00 00 00 F8 49 21 CB E9 FE F3 FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 E9 55 FB FF FF 90 48 8B 15 ?? ?? ?? ?? 83 F9 11 44 8B 12 0F 85 FD FE FF FF 48 BA 00 80 C6 A4 7E 8D 03 00 49 39 D0 0F 85 EA FE FF FF 3D FE 02 00 00 76 0B 3D FF 02 00 00 0F 85 7F 03 00 00 49 B8 00 80 C6 A4 7E 8D 03 00 48 C1 E0 35 4D 09 C1 4C 09 C8 E9 2F F4 FF FF 48 3B B2 20 01 00 00 19 C0 83 C0 03 89 44 24 10 E9 E4 FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 74 24 30 4C 8B 64 24 48 48 89 F0 48 01 C0 48 8D 0C F0 48 B8 00 00 8A 5D 78 45 63 01 4C 89 E6 48 01 C8 48 03 44 24 40 48 89 C1 41 89 C0 48 C1 E9 20 48 0F AF F1 48 0F AF 4C 24 28 4D 0F AF E0 4C 0F AF 44 24 28 4C 89 E0 48 C1 E8 20 48 89 4C 24 18 89 F1 48 C1 EE 20 48 01 C8 48 8B 4C 24 18 49 01 C0 4C 89 C0 48 01 F1 48 C1 E8 20 48 8D 34 01 44 89 F1 48 89 F0 48 D3 E8 48 89 C1 B8 11 00 00 00 44 29 F8 4C 8B 7C 24 20 48 98 48 C1 E0 04 4C 0F AF 3C 02 48 B8 FF FF C0 6F F2 86 23 00 4A 8D 14 39 48 39 C2 0F 87 C6 F7 FF FF 44 89 E7 49 C1 E0 20 41 83 EA 01 49 8D 04 38 48 89 F5 48 89 D7 48 89 44 24 08 E9 A7 F7 FF FF 0F 1F 40 00 49 BB FF FF FF FF FF FF 03 FE 49 21 CB E9 5D FE FF FF 31 FF E9 D5 F2 FF FF 0F 1F 80 00 00 00 00 48 8B 44 24 08 4B 3B 44 DD 00 48 83 DF 00 E9 92 F7 FF FF 48 85 F6 0F 85 77 F9 FF FF 48 39 EB 0F 84 6E F9 FF FF 49 89 C9 4C 89 D0 48 C1 E0 35 48 09 F0 4C 09 C8 E9 E6 F2 FF FF 66 0F 1F 44 00 00 3D FF 02 00 00 0F 84 F5 FC FF FF 48 B9 FF 7F C6 A4 7E 8D 03 00 49 39 C8 76 1A E9 CC FC FF FF 90 4B 8D 14 00 83 E8 01 4E 8D 04 C2 49 39 C8 0F 87 B7 FC FF FF 3D FF 02 00 00 7F E5 E9 AB FC FF FF 83 C0 01 48 89 C2 48 B8 00 80 C6 A4 7E 8D 03 00 49 09 C1 48 C1 E2 35 4C 89 C8 48 09 D0 E9 7E F2 FF FF 48 85 ED 0F 84 05 FD FF FF 4C 89 CA 48 C1 FA 3F 48 83 CA 01 49 29 D0 48 BA FF 7F C6 A4 7E 8D 03 00 49 39 D0 0F 87 58 F3 FF FF E9 3B FC FF FF 4D 85 C9 0F 84 46 F2 FF FF 48 B8 FF FF C0 6F F2 86 FB F7 E9 37 F2 FF FF 3D FE 02 00 00 0F 87 4C FF FF FF 48 BA FF FF FF FF FF FF 1F 00 49 39 D0 0F 87 5F FC FF FF E9 D6 FD FF FF 0F 1F 40 00 48 09 E8 E9 08 F2 FF FF 0F 1F 84 00 00 00 00 00 4C 39 CD 0F 84 E8 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 89 F0 E9 E5 F1 FF FF 0F 1F 44 00 00 83 C0 01 49 89 C2 48 B8 00 80 C6 A4 7E 8D 03 00 49 09 C1 49 C1 E2 35 4C 89 C8 4C 09 D0 E9 BE F1 FF FF 4C 89 C0 4C 89 C3 66 0F EF C0 48 D1 E8 83 E3 01 48 09 D8 F2 48 0F 2A C0 66 0F 28 E0 F2 0F 58 E0 66 48 0F 7E E0 E9 2D F3 FF FF 0F 1F 40 00 BB 03 00 00 00 2B 5C 24 14 E9 5D F3 FF FF 66 90 49 B8 00 00 00 00 00 00 00 F8 49 21 D0 E9 59 F9 FF FF 48 8B 44 24 38 48 8B 7C 24 20 48 8D 0C C5 00 00 00 00 48 29 C7 48 29 CF B9 0F 00 00 00 44 29 F9 48 89 F8 48 63 C9 48 C1 E1 04 48 0F AF 04 0A E9 F9 F4 FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 BA FF FF C0 6F F2 86 03 00 E9 74 FB FF FF 48 B8 FF FF C0 6F F2 86 FB 77 4C 09 C8 E9 0F F1 FF FF 4C 89 D8 E9 07 F1 FF FF 49 BA FF 7F C6 A4 7E 8D 03 00 4C 39 D7 76 18 EB 1D 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_75_1_0 {
	meta:
		name = "__bid64_sub"
		size = 48
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 7C 49 89 D0 49 21 C0 49 39 C0 74 0D 48 B8 00 00 00 00 00 00 00 80 48 31 C2 E9 99 EF FF FF 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__divtc3"
		size = 2528
		refs = "0088 .rdata 00b2 __lttf2 00dd __divtf3 00fd __multf3 011b __addtf3 01ba __subtf3 01f0 __netf2 023b __eqtf2"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC 08 01 00 00 0F 29 B4 24 80 00 00 00 0F 29 BC 24 90 00 00 00 44 0F 29 84 24 A0 00 00 00 44 0F 29 8C 24 B0 00 00 00 44 0F 29 94 24 C0 00 00 00 44 0F 29 9C 24 D0 00 00 00 44 0F 29 A4 24 E0 00 00 00 44 0F 29 AC 24 F0 00 00 00 48 8D 7C 24 70 48 8D 5C 24 60 49 89 CC 48 8B 84 24 70 01 00 00 48 8D 74 24 50 66 41 0F 6F 31 48 89 F9 66 0F 6F 38 66 0F 6F CE 66 44 0F 6F 1D ?? ?? ?? ?? 66 0F 6F C7 66 41 0F DB CB 66 41 0F DB C3 66 44 0F 6F 0A 48 89 DA 66 45 0F 6F 10 0F 29 4C 24 70 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 89 C1 04 00 00 49 89 F0 48 89 DA 48 89 F9 0F 29 74 24 60 48 8D 6C 24 40 4C 8D 6C 24 30 0F 29 7C 24 50 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 0F 29 74 24 60 66 44 0F 6F 64 24 70 44 0F 29 64 24 50 E8 ?? ?? ?? ?? 49 89 E8 48 89 F2 48 89 D9 0F 29 7C 24 40 66 0F 6F 44 24 70 0F 29 44 24 50 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 44 0F 29 64 24 50 66 44 0F 6F 6C 24 60 44 0F 29 4C 24 60 E8 ?? ?? ?? ?? 49 89 E8 48 89 F2 48 89 D9 44 0F 29 54 24 40 66 0F 6F 44 24 70 0F 29 44 24 50 E8 ?? ?? ?? ?? 4D 89 E8 48 89 EA 48 89 F1 44 0F 29 6C 24 30 66 0F 6F 44 24 60 0F 29 44 24 40 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 44 0F 29 54 24 60 66 44 0F 6F 44 24 50 44 0F 29 64 24 50 E8 ?? ?? ?? ?? 44 0F 29 4C 24 40 66 0F 6F 44 24 70 0F 29 44 24 50 49 89 E8 48 89 F2 48 89 D9 E8 ?? ?? ?? ?? 66 0F 6F 44 24 60 4D 89 E8 48 89 EA 48 89 F1 0F 29 44 24 40 44 0F 29 6C 24 30 E8 ?? ?? ?? ?? 48 89 DA 48 89 F9 44 0F 29 44 24 70 44 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 66 44 0F 6F 64 24 50 0F 84 0C 03 00 00 48 89 DA 48 89 F9 44 0F 29 64 24 70 44 0F 29 64 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 84 EC 02 00 00 66 45 0F EF ED 48 89 DA 48 89 F9 0F 29 74 24 70 44 0F 29 6C 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 84 38 04 00 00 49 89 F0 48 89 DA 48 89 F9 44 0F 29 4C 24 60 44 0F 29 4C 24 50 E8 ?? ?? ?? ?? 48 89 DA 48 89 F9 66 0F 6F 44 24 70 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 85 C0 48 89 F9 41 0F 95 C6 44 0F 29 4C 24 70 44 0F 29 4C 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 94 C0 44 20 F0 41 89 C7 75 59 49 89 F0 48 89 DA 48 89 F9 44 0F 29 54 24 60 44 0F 29 54 24 50 E8 ?? ?? ?? ?? 48 89 DA 48 89 F9 66 0F 6F 44 24 70 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 84 60 04 00 00 48 89 DA 48 89 F9 44 0F 29 54 24 70 44 0F 29 54 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 85 40 04 00 00 49 89 F0 48 89 DA 48 89 F9 0F 29 74 24 60 0F 29 74 24 50 E8 ?? ?? ?? ?? 48 89 DA 48 89 F9 66 0F 6F 44 24 70 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 85 09 04 00 00 49 89 F0 48 89 DA 48 89 F9 0F 29 7C 24 60 0F 29 7C 24 50 E8 ?? ?? ?? ?? 48 89 DA 48 89 F9 66 0F 6F 44 24 70 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 85 27 04 00 00 45 84 FF 0F 85 58 06 00 00 66 41 0F 6F C5 66 44 0F 6F 05 ?? ?? ?? ?? 49 89 F0 66 41 0F DB C3 48 89 DA 66 45 0F DB C8 48 89 F9 44 0F 29 54 24 60 66 41 0F EB C1 44 0F 29 54 24 50 66 44 0F 6F C8 E8 ?? ?? ?? ?? 66 0F 6F 44 24 70 48 89 DA 48 89 F9 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 74 25 48 89 DA 48 89 F9 44 0F 29 54 24 70 44 0F 29 54 24 60 E8 ?? ?? ?? ?? 48 85 C0 75 09 66 44 0F 6F 2D ?? ?? ?? ?? 66 45 0F DB D0 49 89 F0 66 45 0F DF C5 48 89 DA 48 89 F9 66 44 0F 6F 1D ?? ?? ?? ?? 4C 8D 74 24 20 66 45 0F EB C2 0F 29 74 24 50 66 45 0F 6F D0 44 0F 29 4C 24 60 E8 ?? ?? ?? ?? 49 89 E8 48 89 F2 48 89 D9 44 0F 29 54 24 50 0F 29 7C 24 40 66 44 0F 6F 44 24 70 E8 ?? ?? ?? ?? 66 0F 6F 44 24 60 4D 89 E8 48 89 EA 48 89 F1 44 0F 29 44 24 40 0F 29 44 24 30 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 EA 48 89 E9 44 0F 29 5C 24 30 66 0F 6F 44 24 50 0F 29 44 24 20 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 0F 29 74 24 50 44 0F 29 54 24 60 66 44 0F 6F 44 24 40 E8 ?? ?? ?? ?? 49 89 E8 48 89 F2 48 89 D9 66 0F 6F 74 24 70 44 0F 29 4C 24 50 0F 29 7C 24 40 E8 ?? ?? ?? ?? 4D 89 E8 48 89 EA 48 89 F1 0F 29 74 24 40 66 0F 6F 44 24 60 0F 29 44 24 30 E8 ?? ?? ?? ?? 44 0F 29 5C 24 30 66 0F 6F 44 24 50 0F 29 44 24 20 4D 89 F0 4C 89 EA 48 89 E9 E8 ?? ?? ?? ?? 66 44 0F 6F 64 24 40 0F 1F 40 00 45 0F 29 04 24 4C 89 E0 45 0F 29 64 24 10 0F 28 B4 24 80 00 00 00 0F 28 BC 24 90 00 00 00 44 0F 28 84 24 A0 00 00 00 44 0F 28 8C 24 B0 00 00 00 44 0F 28 94 24 C0 00 00 00 44 0F 28 9C 24 D0 00 00 00 44 0F 28 A4 24 E0 00 00 00 44 0F 28 AC 24 F0 00 00 00 48 81 C4 08 01 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 84 00 00 00 00 00 49 89 F0 48 89 DA 48 89 F9 0F 29 7C 24 60 48 8D 6C 24 40 4C 8D 6C 24 30 0F 29 74 24 50 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 0F 29 7C 24 60 66 44 0F 6F 64 24 70 44 0F 29 64 24 50 E8 ?? ?? ?? ?? 49 89 E8 48 89 F2 48 89 D9 0F 29 74 24 40 66 0F 6F 44 24 70 0F 29 44 24 50 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 44 0F 29 64 24 50 66 44 0F 6F 6C 24 60 44 0F 29 54 24 60 E8 ?? ?? ?? ?? 49 89 E8 48 89 F2 48 89 D9 44 0F 29 4C 24 40 66 0F 6F 44 24 70 0F 29 44 24 50 E8 ?? ?? ?? ?? 4D 89 E8 48 89 EA 48 89 F1 44 0F 29 6C 24 30 66 0F 6F 44 24 60 0F 29 44 24 40 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 44 0F 29 4C 24 60 66 44 0F 6F 44 24 50 44 0F 29 64 24 50 E8 ?? ?? ?? ?? 44 0F 29 54 24 50 66 0F 6F 44 24 70 0F 29 44 24 40 E9 3A FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 89 DA 48 89 F9 0F 29 7C 24 70 44 0F 29 6C 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 85 A9 FB FF FF 48 89 DA 48 89 F9 44 0F 29 4C 24 70 44 0F 29 4C 24 60 E8 ?? ?? ?? ?? 48 85 C0 74 20 48 89 DA 48 89 F9 44 0F 29 54 24 70 44 0F 29 54 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 85 6D FB FF FF 66 0F DB 35 ?? ?? ?? ?? 49 89 F0 66 0F 6F 05 ?? ?? ?? ?? 48 89 DA 48 89 F9 66 41 0F DB C3 44 0F 29 4C 24 50 66 0F EB C6 66 0F 6F F0 0F 29 44 24 60 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 44 0F 29 54 24 60 0F 29 74 24 50 66 44 0F 6F 44 24 70 E8 ?? ?? ?? ?? 66 44 0F 6F 64 24 70 E9 D3 FD FF FF 49 89 F0 48 89 DA 48 89 F9 0F 29 74 24 60 0F 29 74 24 50 E8 ?? ?? ?? ?? 48 89 DA 48 89 F9 66 0F 6F 44 24 70 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 85 C0 48 89 F9 41 0F 95 C7 0F 29 74 24 70 0F 29 74 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 94 C0 41 20 C7 75 58 49 89 F0 48 89 DA 48 89 F9 0F 29 7C 24 60 0F 29 7C 24 50 E8 ?? ?? ?? ?? 48 89 DA 48 89 F9 66 0F 6F 44 24 70 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 84 47 FD FF FF 48 89 DA 48 89 F9 0F 29 7C 24 70 0F 29 7C 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 85 29 FD FF FF 45 31 FF 45 84 F6 0F 85 1D FD FF FF 49 89 F0 48 89 DA 48 89 F9 44 0F 29 54 24 60 44 0F 29 54 24 50 E8 ?? ?? ?? ?? 48 89 DA 48 89 F9 66 0F 6F 44 24 70 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 85 E4 FC FF FF 45 84 FF 0F 85 8A 01 00 00 66 41 0F 6F C5 66 44 0F 6F 05 ?? ?? ?? ?? 49 89 F0 66 41 0F DB C3 48 89 DA 66 41 0F DB F0 48 89 F9 0F 29 7C 24 60 66 0F EB C6 0F 29 7C 24 50 66 0F 6F F0 E8 ?? ?? ?? ?? 66 0F 6F 44 24 70 48 89 DA 48 89 F9 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 84 29 01 00 00 48 89 DA 48 89 F9 0F 29 7C 24 70 0F 29 7C 24 60 E8 ?? ?? ?? ?? 48 85 C0 0F 85 0B 01 00 00 66 0F 6F 05 ?? ?? ?? ?? 66 41 0F DB F8 49 89 F0 66 44 0F DF C0 48 89 DA 48 89 F9 4C 8D 74 24 20 0F 29 74 24 50 66 44 0F EB C7 44 0F 29 4C 24 60 E8 ?? ?? ?? ?? 66 41 0F 6F F8 49 89 E8 48 89 F2 48 89 D9 66 44 0F 6F 44 24 70 44 0F 29 54 24 50 0F 29 7C 24 40 E8 ?? ?? ?? ?? 4D 89 E8 48 89 EA 48 89 F1 44 0F 29 44 24 40 66 0F 6F 44 24 60 0F 29 44 24 30 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 EA 48 89 E9 44 0F 29 6C 24 20 66 0F 6F 44 24 50 0F 29 44 24 30 E8 ?? ?? ?? ?? 49 89 F0 48 89 DA 48 89 F9 0F 29 74 24 50 44 0F 29 54 24 60 66 44 0F 6F 44 24 40 E8 ?? ?? ?? ?? 49 89 E8 48 89 F2 48 89 D9 66 0F 6F 74 24 70 44 0F 29 4C 24 50 0F 29 7C 24 40 E8 ?? ?? ?? ?? 4D 89 E8 48 89 EA 48 89 F1 0F 29 74 24 40 66 0F 6F 44 24 60 0F 29 44 24 30 E8 ?? ?? ?? ?? 44 0F 29 6C 24 20 66 0F 6F 44 24 50 0F 29 44 24 30 E9 42 FB FF FF 66 41 0F 6F C5 E9 F3 FE FF FF 66 0F 6F 05 ?? ?? ?? ?? E9 6E FE FF FF 66 0F 6F 05 ?? ?? ?? ?? E9 A0 F9 FF FF 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__bid_getd2"
		size = 80
		refs = "0031 __bid128_quiet_greater_equal"
	strings:
		$1 = { 48 83 EC 48 48 8B 02 48 8B 52 08 4C 8B 09 4C 8B 51 08 48 8D 4C 24 30 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 4C 89 4C 24 30 4C 89 54 24 38 E8 ?? ?? ?? ?? 48 98 48 C7 C2 FF FF FF FF 48 85 C0 48 0F 44 C2 48 83 C4 48 C3 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__udivti3"
		size = 336
	strings:
		$1 = { 57 56 53 48 83 EC 10 4C 8B 4A 08 4C 8B 01 4C 8B 1A 48 8B 49 08 4D 85 C9 4C 89 C3 49 89 CA 4C 89 DA 4C 89 DE 75 4A 49 39 CB 0F 87 E1 00 00 00 4D 85 DB 75 0D B8 01 00 00 00 31 D2 49 F7 F3 48 89 C6 48 89 C8 31 D2 48 F7 F6 48 89 C1 4C 89 C0 48 F7 F6 48 89 04 24 48 89 4C 24 08 66 0F 6F 04 24 90 48 83 C4 10 5B 5E 5F C3 0F 1F 80 00 00 00 00 49 39 C9 0F 87 87 00 00 00 49 0F BD C1 48 83 F0 3F 85 C0 41 89 C3 0F 84 94 00 00 00 89 C1 BE 40 00 00 00 48 89 D7 49 D3 E1 48 63 C8 4D 89 D0 48 29 CE 89 F1 48 D3 EF 89 C1 49 09 F9 48 89 D7 48 D3 E7 89 F1 49 D3 E8 89 C1 48 89 D8 49 D3 E2 89 F1 4C 89 C2 48 D3 E8 49 09 C2 4C 89 D0 49 F7 F1 49 89 D0 49 89 C2 48 F7 E7 49 39 D0 72 10 44 89 D9 48 D3 E3 48 39 C3 73 57 49 39 D0 75 52 49 8D 42 FF 31 C9 E9 59 FF FF FF 0F 1F 80 00 00 00 00 31 C9 31 C0 E9 49 FF FF FF 0F 1F 80 00 00 00 00 48 89 CA 4C 89 C0 31 C9 49 F7 F3 E9 32 FF FF FF 4C 39 C2 76 0D 31 C9 31 C0 4D 39 D1 0F 83 20 FF FF FF 31 C9 B8 01 00 00 00 E9 14 FF FF FF 66 90 4C 89 D0 31 C9 E9 08 FF FF FF 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__bid_trunctfsd"
		size = 32
		refs = "0013 __binary128_to_bid32"
	strings:
		$1 = { 48 83 EC 38 66 0F 6F 01 48 8D 4C 24 20 0F 29 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__bid_trunctfdd"
		size = 32
		refs = "0013 __binary128_to_bid64"
	strings:
		$1 = { 48 83 EC 38 66 0F 6F 01 48 8D 4C 24 20 0F 29 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__bid_extendtftd"
		size = 64
		refs = "001c __binary128_to_bid128"
	strings:
		$1 = { 53 48 83 EC 40 48 89 CB 66 0F 6F 02 48 8D 4C 24 30 48 8D 54 24 20 0F 29 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 54 24 38 48 89 03 48 89 D8 48 89 53 08 48 83 C4 40 5B C3 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__floattidf"
		size = 224
		refs = "00a4 .rdata"
	strings:
		$1 = { 4C 8B 09 4C 8B 51 08 4C 89 C8 48 99 4C 39 D2 0F 84 9B 00 00 00 4C 89 D0 48 99 48 31 D0 48 29 D0 48 0F BD C0 48 83 F0 3F 85 C0 74 74 48 98 41 B8 41 00 00 00 4C 89 D2 49 29 C0 4C 89 C8 44 89 C1 66 0F EF C9 4C 0F AD D0 48 D3 FA 41 F6 C0 40 B9 40 00 00 00 48 0F 45 C2 44 29 C1 48 89 C2 49 D3 E1 48 83 CA 01 4D 85 C9 48 0F 45 C2 49 83 F8 40 F2 48 0F 2A C8 74 49 49 83 F8 3F 74 53 66 0F EF C0 B8 01 00 00 00 44 89 C1 48 D3 E0 F2 48 0F 2A C0 F2 0F 59 C1 C3 66 2E 0F 1F 84 00 00 00 00 00 F2 0F 10 05 ?? ?? ?? ?? C3 0F 1F 80 00 00 00 00 66 0F EF C0 F2 49 0F 2A C1 C3 66 0F 1F 44 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C1 C3 0F 1F 00 F2 0F 10 05 ?? ?? ?? ?? EB B7 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "__floatuntidf"
		size = 256
		refs = "0094 .rdata"
	strings:
		$1 = { 4C 8B 51 08 4C 8B 09 4D 85 D2 4C 89 CA 0F 84 9D 00 00 00 49 0F BD C2 41 B8 40 00 00 00 4C 89 D2 48 83 F0 3F 48 98 49 29 C0 4C 89 C8 44 89 C1 4C 0F AD D0 48 D3 EA 41 F6 C0 40 B9 40 00 00 00 48 0F 45 C2 44 29 C1 48 89 C2 49 D3 E1 48 83 CA 01 4D 85 C9 48 0F 45 C2 48 85 C0 78 64 66 0F EF C0 F2 48 0F 2A C0 49 83 F8 40 74 25 49 83 F8 3F 74 2F 66 0F EF C9 44 89 C1 B8 01 00 00 00 48 D3 E0 F2 48 0F 2A C8 F2 0F 59 C1 C3 66 0F 1F 44 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C1 C3 0F 1F 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C1 C3 0F 1F 00 4D 85 C9 78 2B 66 0F EF C0 F2 49 0F 2A C1 C3 90 48 89 C2 66 0F EF C0 48 D1 EA 83 E0 01 48 09 C2 F2 48 0F 2A C2 F2 0F 58 C0 EB 8A 0F 1F 44 00 00 4C 89 C8 66 0F EF C0 48 D1 E8 83 E2 01 48 09 D0 F2 48 0F 2A C0 F2 0F 58 C0 C3 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__bid_eqsd2"
		size = 64
		refs = "0009 __bid32_to_bid64 001e __bid64_quiet_equal"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 0F B6 C0 48 83 C4 28 5B 5E C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__ashrti3"
		size = 96
	strings:
		$1 = { 48 83 EC 18 48 8B 01 4C 8B 49 08 48 85 D2 74 27 41 BA 40 00 00 00 49 89 C0 4C 89 C8 49 29 D2 4D 85 D2 7E 2C 89 D1 49 D3 F9 44 89 D1 48 D3 E0 89 D1 49 D3 E8 4C 09 C0 48 89 04 24 4C 89 4C 24 08 66 0F 6F 04 24 48 83 C4 18 C3 66 0F 1F 44 00 00 44 89 D1 49 C1 F9 3F F7 D9 48 D3 F8 EB D9 90 90 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "__bid_truncxfdd"
		size = 32
		refs = "0010 __binary80_to_bid64"
	strings:
		$1 = { 48 83 EC 38 DB 29 48 8D 4C 24 20 DB 7C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__bid_truncxfsd"
		size = 32
		refs = "0010 __binary80_to_bid32"
	strings:
		$1 = { 48 83 EC 38 DB 29 48 8D 4C 24 20 DB 7C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__mulxc3"
		size = 1056
		refs = "01b5 .rdata"
	strings:
		$1 = { 48 83 EC 48 48 8B 44 24 70 DB 2A 41 DB 28 41 DB 29 DB 28 D9 C3 D8 CA DB 3C 24 D9 C2 D8 C9 D9 C0 DB 7C 24 10 D9 C4 D8 CA D9 C0 DB 7C 24 20 D9 C4 D8 CC D9 C0 DB 7C 24 30 DB 2C 24 DE E3 DE C1 D9 C9 DB E8 7A 3B DD DC DD DC DD D8 DD D8 EB 21 90 DD DD DD DB DD D8 DD D8 EB 16 DD D8 DD D8 DD DB DD D8 DD DA EB 0A DD D8 DD DB DD D8 DD DA 66 90 DB 39 48 89 C8 DB 79 10 48 83 C4 48 C3 0F 1F 00 D9 C9 DB E8 7B CA D9 C5 D8 E6 DF E8 0F 8A 3A 01 00 00 EB 0C D9 CD 66 2E 0F 1F 84 00 00 00 00 00 D9 C4 D8 E5 DF E8 0F 8A 8E 01 00 00 EB 02 D9 CC D9 CB 31 C0 DB E8 D9 C0 0F 9A C2 D8 E1 DF E8 0F 8A AA 01 00 00 D9 CA EB 02 D9 CA DB E8 D9 C0 41 0F 9A C0 D8 E1 DB E8 0F 8A 25 02 00 00 DD D8 EB 02 DD D8 84 C0 0F 85 A4 00 00 00 DB 2C 24 D9 C0 D8 E0 DF E8 0F 8A 34 02 00 00 DD D8 DB 6C 24 10 D9 C0 D8 E1 DF E8 0F 8A 15 02 00 00 DD D8 DB 6C 24 20 D9 C0 D8 E1 DF E8 0F 8A 1D 02 00 00 DD D8 DB 6C 24 30 D9 C0 D8 E1 DF E8 0F 8B 2A FF FF FF DF E8 0F 8A 2E FF FF FF DD DB DD D8 D9 C9 D9 CB EB 1C DD DB DD D8 D9 C9 D9 CB EB 12 DD DB DD D8 D9 C9 D9 CB EB 08 DD DB DD D8 D9 C9 D9 CB DB E8 0F 8A E2 01 00 00 D9 CA EB 02 D9 CA DB E8 0F 8A 54 02 00 00 84 D2 0F 85 2C 02 00 00 EB 02 D9 C9 45 84 C0 0F 85 FB 01 00 00 D9 CA D9 CB EB 1A DD DB DD D8 D9 C9 EB 12 D9 CA D9 CB EB 0C D9 CA D9 CB EB 06 D9 CA D9 CB D9 CA D9 C3 D8 CA D9 C3 D8 CA DE E9 D9 05 ?? ?? ?? ?? DC C9 D9 CD DE CA D9 CB DE CA DE C1 DE CA E9 A4 FE FF FF D9 CD DB E8 0F 8A BE FE FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 E8 74 06 DD D8 D9 E8 D9 E0 D9 C4 D8 E5 DF E8 7A 70 EB 02 D9 CC D9 EE D9 CD D9 E5 DF E0 DD D8 D9 CC F6 C4 02 D9 E1 74 06 D9 E0 D9 CB EB 02 D9 CB DB E8 0F 8A E8 01 00 00 D9 CA EB 02 D9 CA DB E8 0F 8A BE 01 00 00 D9 CA D9 CB D9 CC D9 CD D9 CB B8 01 00 00 00 E9 7A FE FF FF D9 CC DB E8 0F 8A 6A FE FF FF D9 CD D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 06 DD D8 D9 EE D9 E0 D9 E8 D9 CD D9 CE EB 98 D9 CC DB E8 7A 8C D9 E8 D9 CD D9 C9 EB 8A 80 FA 01 0F 83 51 FE FF FF DD DB DD D8 D9 C9 D9 E8 D9 C2 D8 E3 D9 CA D9 E5 DF E0 DD D8 F6 C4 02 D9 E1 74 06 D9 E0 D9 C9 EB 02 D9 C9 DF E8 7A 55 EB 02 D9 C9 D9 EE D9 CA D9 E5 DF E0 DD D8 D9 C9 F6 C4 02 D9 E1 74 06 D9 E0 D9 CB EB 02 D9 CB DB E8 0F 8A A0 00 00 00 D9 CA EB 02 D9 CA DB E8 0F 8B C3 FE FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 B8 FE FF FF DD D8 D9 EE D9 E0 D9 CA D9 CB E9 B5 FE FF FF D9 C9 DB E8 7A A7 D9 E8 D9 CA D9 C9 EB A5 41 80 F8 01 0F 83 D5 FD FF FF DD DC DD D9 D9 C9 D9 CA D9 EE D9 C9 D9 CA D9 CB E9 65 FF FF FF DF E8 0F 8B 19 FE FF FF E9 E0 FD FF FF DF E8 0F 8B 16 FE FF FF E9 C1 FD FF FF DF E8 0F 8B 13 FE FF FF E9 D8 FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 11 FE FF FF DD D8 D9 EE D9 E0 D9 CA E9 06 FE FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 53 FF FF FF DD D8 D9 EE D9 E0 D9 CA E9 48 FF FF FF D9 CB D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 0C FE FF FF DD D8 D9 EE D9 E0 D9 CA D9 CB D9 CA E9 01 FE FF FF D9 C9 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 C3 FD FF FF DD D8 D9 EE D9 E0 D9 C9 E9 B8 FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 9B FD FF FF DD D8 D9 EE D9 E0 E9 90 FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 31 FE FF FF DD D8 D9 EE D9 E0 E9 26 FE FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 0B FE FF FF DD D8 D9 EE D9 E0 D9 CA E9 00 FE FF FF 90 90 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__bid64_to_int32_rnint"
		size = 928
		refs = "0095 .refptr.__bid_nr_digits 00e7 .refptr.__bid_midpoint64 0188 .refptr.__bid_ten2k64 01f6 .refptr.__bid_ten2mk64 024e .refptr.__bid_shiftright128 025c .refptr.__bid_maskhigh128 027e .refptr.__bid_ten2mk128trunc 0313 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 F5 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 DC 02 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 B6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 9E 00 00 00 66 0F EF C0 48 8D 14 09 48 89 D0 F2 49 0F 2A C0 48 C1 E8 36 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 44 8B 0A 45 85 C9 75 0C 4C 3B 42 10 44 8B 4A 18 41 83 D9 FF 8D 90 72 FE FF FF 41 8D 04 11 83 F8 0A 0F 8F 50 02 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 83 F8 0A 0F 84 9A 00 00 00 85 C0 0F 88 D2 01 00 00 0F 85 CC 00 00 00 48 8B 15 ?? ?? ?? ?? 41 83 E9 01 4D 63 C9 4E 3B 04 CA 0F 87 D4 00 00 00 0F 1F 40 00 5B 5E C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CF 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 89 D0 4C 89 C2 48 C1 EA 20 48 C1 E8 36 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 21 FF FF FF 66 0F 1F 44 00 00 4D 85 D2 0F 84 5C 01 00 00 41 83 F9 0B 0F 8F ED 01 00 00 B0 0B 48 8B 0D ?? ?? ?? ?? 4C 89 C3 44 29 C8 48 98 48 0F AF 1C C1 48 B8 05 00 00 00 05 00 00 00 48 39 C3 0F 87 64 01 00 00 0F 1F 40 00 85 D2 78 2C 0F 85 FB 00 00 00 44 89 C0 F7 D8 4D 85 D2 41 0F 44 C0 E9 35 FF FF FF 0F 1F 44 00 00 49 83 FA 01 19 C0 83 E0 02 83 E8 01 5B 5E C3 90 48 8B 05 ?? ?? ?? ?? F7 D2 4D 89 C1 48 63 D2 4C 03 0C D0 48 8B 05 ?? ?? ?? ?? 48 8B 04 D0 4D 89 CB 44 89 C9 49 C1 EB 20 49 89 C1 4C 89 DB 89 C0 49 C1 E9 20 48 0F AF D8 4D 0F AF D9 48 0F AF C1 89 DE 48 C1 EB 20 4D 89 D8 4C 0F AF C9 49 89 C3 89 C0 49 C1 EB 20 49 01 F3 4B 8D 0C 0B 4E 8D 1C 03 49 89 C8 48 C1 E1 20 48 01 C8 48 8B 0D ?? ?? ?? ?? 49 C1 E8 20 4D 01 C3 4C 8B 05 ?? ?? ?? ?? 4C 89 DE 8B 0C 91 48 D3 EE 4D 85 1C D0 48 89 F1 75 2E 48 85 C0 74 29 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 3B 42 08 77 18 48 89 F0 83 E0 01 48 83 F8 01 48 83 D1 FF 66 2E 0F 1F 84 00 00 00 00 00 89 C8 F7 D8 4D 85 D2 0F 44 C1 E9 51 FE FF FF 90 31 C0 5B 5E C3 4D 85 D2 48 63 D2 74 67 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 34 D0 41 0F AF F0 89 F0 E9 2B FE FF FF 41 83 F9 0B 7F 65 B8 0B 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 C6 44 29 C8 48 98 48 0F AF 34 C1 48 B8 FA FF FF FF 04 00 00 00 48 39 C6 0F 86 A9 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 DC FD FF FF 48 8B 05 ?? ?? ?? ?? 8B 34 D0 41 0F AF F0 89 F0 E9 C7 FD FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 41 83 E9 0B 4D 63 C9 4A 8B 04 C8 48 8D 0C 80 48 89 C8 48 C1 E0 20 48 29 C8 49 39 C0 0F 82 47 FE FF FF EB A5 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 41 83 E9 0B 4D 63 C9 4A 8B 04 C8 48 8D 0C 80 48 89 C8 48 C1 E0 20 48 01 C8 49 39 C0 0F 86 17 FE FF FF E9 72 FF FF FF 66 90 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "__bid64_to_int32_xrnint"
		size = 1136
		refs = "0096 .refptr.__bid_nr_digits 00e8 .refptr.__bid_midpoint64 0101 .refptr.__bid_IDEC_glbflags 01a2 .refptr.__bid_ten2k64 022c .refptr.__bid_ten2mk64 0284 .refptr.__bid_maskhigh128 0299 .refptr.__bid_shiftright128 02b0 .refptr.__bid_onehalf128 02d7 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 64 03 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 4B 03 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 14 10 41 83 FA 0A 0F 8F C1 02 00 00 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 0A 0F 84 AA 00 00 00 45 85 D2 0F 88 56 02 00 00 0F 85 DB 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 01 48 63 D0 31 C0 4C 3B 04 D1 0F 87 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 0F 1F 84 00 00 00 00 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 4D 85 C9 0F 84 BC 01 00 00 83 F8 0B 0F 8F 4E 02 00 00 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 05 00 00 00 05 00 00 00 48 39 C7 0F 87 C2 01 00 00 66 90 85 D2 78 4C 0F 84 5B 01 00 00 4D 85 C9 48 63 D2 0F 84 BE 01 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 3C D0 41 0F AF F8 89 F8 E9 22 FF FF FF 66 90 49 83 F9 01 48 8B 15 ?? ?? ?? ?? 19 C0 83 E0 02 83 E8 01 83 0A 20 E9 05 FF FF FF 0F 1F 44 00 00 41 89 D3 48 8B 05 ?? ?? ?? ?? 4D 89 C2 41 F7 D3 F7 DA 4D 63 DB 4E 03 14 D8 48 8B 05 ?? ?? ?? ?? 4A 8B 04 D8 4C 89 D3 44 89 D1 48 C1 EB 20 49 89 C2 48 89 DE 89 C0 49 C1 EA 20 48 0F AF F0 49 0F AF DA 48 0F AF C1 89 F7 48 C1 EE 20 49 89 D8 4C 0F AF D1 48 89 C3 89 C0 48 C1 EB 20 48 01 FB 4A 8D 0C 13 4A 8D 1C 06 49 89 C8 48 C1 E1 20 48 01 C8 48 8B 0D ?? ?? ?? ?? 49 C1 E8 20 49 01 D8 4D 89 C2 4E 23 14 D9 48 8B 0D ?? ?? ?? ?? 42 8B 0C 99 49 D3 E8 83 FA 03 0F 8E 63 01 00 00 48 8B 15 ?? ?? ?? ?? 48 85 C0 4A 8B 0C DA 0F 95 C2 49 39 CA 77 2D 49 39 CA 0F 94 C1 20 D1 74 23 4C 89 DA 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 3B 42 08 0F 86 79 01 00 00 89 CA 66 0F 1F 84 00 00 00 00 00 48 8B 0D ?? ?? ?? ?? 83 09 20 84 D2 74 27 4D 85 D2 75 22 49 C1 E3 04 4C 89 DA 48 03 15 ?? ?? ?? ?? 48 3B 42 08 77 0E 4C 89 C0 83 E0 01 48 83 F8 01 49 83 D0 FF 44 89 C0 F7 D8 4D 85 C9 41 0F 44 C0 5B 5E 5F C3 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 5B 5E 5F C3 83 F8 0B 7F 66 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 FA FF FF FF 04 00 00 00 48 39 C7 0F 86 4A FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 7C FD FF FF 48 8B 05 ?? ?? ?? ?? 8B 3C D0 41 0F AF F8 89 F8 E9 67 FD FF FF 0F 1F 80 00 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 20 48 29 C8 49 39 C0 0F 82 E9 FD FF FF EB A7 0F 1F 80 00 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 20 48 01 C8 49 39 C0 0F 86 B9 FD FF FF E9 74 FF FF FF 0F 1F 40 00 48 BA 00 00 00 00 00 00 00 80 48 39 D0 76 2A 4C 89 D9 48 01 C2 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 C4 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 B5 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 48 85 C0 0F 95 C2 E9 9C FE FF FF 4D 85 D2 0F 84 B0 FE FF FF E9 B9 FE FF FF 0F 1F 40 00 }
	condition:
		$1
}

rule file_89_2_0 {
	meta:
		name = "__bid64_to_int32_floor"
		size = 864
		refs = "0096 .refptr.__bid_nr_digits 00fc .refptr.__bid_ten2k64 01d3 .refptr.__bid_IDEC_glbflags 01f7 .refptr.__bid_ten2mk64 025c .refptr.__bid_maskhigh128 0267 .refptr.__bid_shiftright128 0299 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 B4 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 9B 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 0A 0F 8F 11 01 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 0A 0F 84 BA 00 00 00 45 85 C9 0F 8E 05 01 00 00 85 D2 0F 88 0B 01 00 00 0F 84 93 00 00 00 4D 85 D2 48 63 D2 0F 84 F7 01 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 3C D0 41 0F AF F8 89 F8 0F 1F 40 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 44 89 C0 F7 D8 4D 85 D2 41 0F 44 C0 5B 5E 5F C3 4D 85 D2 0F 84 1A 01 00 00 83 F8 0B 0F 8F 63 01 00 00 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 00 00 00 00 05 00 00 00 48 39 C7 0F 86 11 FF FF FF 66 90 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 2C FF FF FF 31 C0 4D 85 D2 0F 95 C0 F7 D8 5B 5E 5F C3 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C1 F7 DA 48 63 DB 49 C1 E9 20 48 8B 0C D9 4D 89 CB 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F1 4D 0F AF D8 49 89 C9 89 C9 89 F7 49 C1 E9 20 48 C1 EE 20 4C 0F AF C0 49 01 F9 4D 01 C8 4E 8D 0C 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C1 48 8B 05 ?? ?? ?? ?? 4C 8B 1C D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 4C 89 C8 48 D3 E8 83 FA 03 7E 19 4D 85 D9 74 14 4D 85 D2 0F 84 89 FE FF FF 48 83 C0 01 F7 D8 E9 7E FE FF FF 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 77 DB 4D 85 D2 0F 84 64 FE FF FF F7 D8 E9 5D FE FF FF 83 F8 0B 7F 78 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 FF FF FF FF 04 00 00 00 48 39 C7 0F 86 FB FD FF FF E9 E7 FE FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 8B 3C D0 41 0F AF F8 89 F8 E9 0B FE FF FF 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 04 80 48 C1 E0 20 49 39 C0 0F 86 B9 FD FF FF E9 A5 FE FF FF 0F 1F 44 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 04 80 48 C1 E0 20 49 39 C0 0F 82 8E FD FF FF E9 7A FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_89_3_0 {
	meta:
		name = "__bid64_to_int32_xfloor"
		size = 880
		refs = "0096 .refptr.__bid_nr_digits 00fc .refptr.__bid_ten2k64 01d3 .refptr.__bid_IDEC_glbflags 0205 .refptr.__bid_ten2mk64 026a .refptr.__bid_maskhigh128 0278 .refptr.__bid_shiftright128 02b7 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 B4 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 9B 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 0A 0F 8F 11 01 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 0A 0F 84 BA 00 00 00 45 85 C9 0F 8E 05 01 00 00 85 D2 0F 88 19 01 00 00 0F 84 93 00 00 00 4D 85 D2 48 63 D2 0F 84 07 02 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 3C D0 41 0F AF F8 89 F8 0F 1F 40 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 44 89 C0 F7 D8 4D 85 D2 41 0F 44 C0 5B 5E 5F C3 4D 85 D2 0F 84 2A 01 00 00 83 F8 0B 0F 8F 9E 01 00 00 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 00 00 00 00 05 00 00 00 48 39 C7 0F 86 11 FF FF FF 66 90 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 2C FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 D2 0F 95 C0 F7 D8 5B 5E 5F C3 0F 1F 40 00 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C1 F7 DA 48 63 DB 49 C1 E9 20 48 8B 0C D9 4D 89 CB 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F1 4D 0F AF D8 49 89 C9 89 C9 89 F7 49 C1 E9 20 48 C1 EE 20 4C 0F AF C0 49 01 F9 4D 01 C8 4E 8D 0C 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C1 48 8B 05 ?? ?? ?? ?? 4D 89 CB 48 8B 34 D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 49 D3 EB 83 FA 03 7E 29 49 85 F1 74 24 48 8B 05 ?? ?? ?? ?? 49 83 FA 01 49 83 DB FF 83 08 20 44 89 D8 F7 D8 4D 85 D2 41 0F 44 C3 5B 5E 5F C3 66 90 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 76 DD EB C9 83 F8 0B 7F 4D B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 FF FF FF FF 04 00 00 00 48 39 C7 0F 86 EB FD FF FF E9 D7 FE FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 8B 3C D0 41 0F AF F8 89 F8 E9 FB FD FF FF 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 04 80 48 C1 E0 20 49 39 C0 0F 82 A9 FD FF FF E9 95 FE FF FF 0F 1F 44 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 04 80 48 C1 E0 20 49 39 C0 0F 86 7E FD FF FF E9 6A FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_89_4_0 {
	meta:
		name = "__bid64_to_int32_ceil"
		size = 880
		refs = "0096 .refptr.__bid_nr_digits 00fc .refptr.__bid_ten2k64 01d3 .refptr.__bid_IDEC_glbflags 01f5 .refptr.__bid_ten2mk64 025a .refptr.__bid_maskhigh128 0265 .refptr.__bid_shiftright128 0297 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 B4 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 9B 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 0A 0F 8F 11 01 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 0A 0F 84 BA 00 00 00 45 85 C9 0F 8E 05 01 00 00 85 D2 0F 88 09 01 00 00 0F 84 93 00 00 00 4D 85 D2 48 63 D2 0F 84 F7 01 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 3C D0 41 0F AF F8 89 F8 0F 1F 40 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 44 89 C0 F7 D8 4D 85 D2 41 0F 44 C0 5B 5E 5F C3 4D 85 D2 0F 84 18 01 00 00 83 F8 0B 0F 8F 63 01 00 00 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 09 00 00 00 05 00 00 00 48 39 C7 0F 86 11 FF FF FF 66 90 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 2C FF FF FF 31 C0 4D 85 D2 0F 94 C0 5B 5E 5F C3 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C1 F7 DA 48 63 DB 49 C1 E9 20 48 8B 0C D9 4D 89 CB 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F1 4D 0F AF D8 49 89 C9 89 C9 89 F7 49 C1 E9 20 48 C1 EE 20 4C 0F AF C0 49 01 F9 4D 01 C8 4E 8D 0C 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C1 48 8B 05 ?? ?? ?? ?? 4C 8B 1C D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 4C 89 C8 48 D3 E8 83 FA 03 7E 19 4D 85 D9 74 14 4D 85 D2 75 29 48 83 C0 01 E9 86 FE FF FF 66 0F 1F 44 00 00 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 77 DB 4D 85 D2 0F 84 66 FE FF FF F7 D8 E9 5F FE FF FF 83 F8 0B 7F 7E B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 F6 FF FF FF 04 00 00 00 48 39 C7 0F 86 FD FD FF FF E9 E9 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 8B 3C D0 41 0F AF F8 89 F8 E9 0B FE FF FF 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 1F 48 01 C8 48 01 C0 49 39 C0 0F 82 B0 FD FF FF E9 9C FE FF FF 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 1F 48 29 C8 48 01 C0 49 39 C0 0F 86 81 FD FF FF E9 6D FE FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_89_5_0 {
	meta:
		name = "__bid64_to_int32_xceil"
		size = 896
		refs = "0096 .refptr.__bid_nr_digits 00fc .refptr.__bid_ten2k64 01d3 .refptr.__bid_IDEC_glbflags 0205 .refptr.__bid_ten2mk64 026a .refptr.__bid_maskhigh128 0278 .refptr.__bid_shiftright128 02b7 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 B4 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 9B 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 0A 0F 8F 11 01 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 0A 0F 84 BA 00 00 00 45 85 C9 0F 8E 05 01 00 00 85 D2 0F 88 19 01 00 00 0F 84 93 00 00 00 4D 85 D2 48 63 D2 0F 84 07 02 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 3C D0 41 0F AF F8 89 F8 0F 1F 40 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 44 89 C0 F7 D8 4D 85 D2 41 0F 44 C0 5B 5E 5F C3 4D 85 D2 0F 84 2A 01 00 00 83 F8 0B 0F 8F A2 01 00 00 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 09 00 00 00 05 00 00 00 48 39 C7 0F 86 11 FF FF FF 66 90 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 2C FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 D2 0F 94 C0 5B 5E 5F C3 66 0F 1F 44 00 00 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C1 F7 DA 48 63 DB 49 C1 E9 20 48 8B 0C D9 4D 89 CB 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F1 4D 0F AF D8 49 89 C9 89 C9 89 F7 49 C1 E9 20 48 C1 EE 20 4C 0F AF C0 49 01 F9 4D 01 C8 4E 8D 0C 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C1 48 8B 05 ?? ?? ?? ?? 4D 89 CB 48 8B 34 D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 49 D3 EB 83 FA 03 7E 29 49 85 F1 74 24 48 8B 05 ?? ?? ?? ?? 49 83 FA 01 49 83 D3 00 83 08 20 44 89 D8 F7 D8 4D 85 D2 41 0F 44 C3 5B 5E 5F C3 66 90 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 76 DD EB C9 83 F8 0B 7F 4D B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 F6 FF FF FF 04 00 00 00 48 39 C7 0F 86 EB FD FF FF E9 D7 FE FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 8B 3C D0 41 0F AF F8 89 F8 E9 FB FD FF FF 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 1F 48 29 C8 48 01 C0 49 39 C0 0F 86 A0 FD FF FF E9 8C FE FF FF 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 1F 48 01 C8 48 01 C0 49 39 C0 0F 82 71 FD FF FF E9 5D FE FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_89_6_0 {
	meta:
		name = "__bid64_to_int32_int"
		size = 768
		refs = "0094 .refptr.__bid_nr_digits 00f8 .refptr.__bid_ten2k64 01d3 .refptr.__bid_IDEC_glbflags 01e4 .refptr.__bid_ten2mk64 022a .refptr.__bid_shiftright128"
	strings:
		$1 = { 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 B6 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 9D 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AF 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 0A 0F 8F 13 01 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 0A 0F 84 BC 00 00 00 31 C0 45 85 C9 7E 35 85 D2 0F 88 FE 00 00 00 0F 84 97 00 00 00 4D 85 D2 48 63 D2 0F 84 5B 01 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 1C D0 41 0F AF D8 89 D8 0F 1F 84 00 00 00 00 00 5B C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 D0 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 80 00 00 00 00 44 89 C0 F7 D8 4D 85 D2 41 0F 44 C0 5B C3 66 90 4D 85 D2 0F 84 C9 00 00 00 83 F8 0B 0F 8F 2E 01 00 00 B9 0B 00 00 00 4C 89 C3 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 1C C1 48 B8 09 00 00 00 05 00 00 00 48 39 C3 0F 86 0D FF FF FF 66 90 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 5B C3 48 8B 05 ?? ?? ?? ?? F7 D2 4D 89 C1 48 63 D2 49 C1 E9 20 45 89 C0 48 8B 0C D0 49 89 CB 89 C9 48 89 C8 49 C1 EB 20 49 0F AF C1 49 0F AF C8 4D 0F AF C3 89 C3 48 C1 E8 20 48 C1 E9 20 48 01 D9 4D 0F AF CB 49 01 C8 48 8B 0D ?? ?? ?? ?? 49 C1 E8 20 8B 0C 91 4C 01 C8 4C 01 C0 48 D3 E8 48 89 C2 F7 D8 4D 85 D2 0F 44 C2 5B C3 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 8B 1C D0 41 0F AF D8 89 D8 5B C3 83 F8 0B 7F 39 B9 0B 00 00 00 4C 89 C3 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 1C C1 48 B8 FF FF FF FF 04 00 00 00 48 39 C3 0F 86 48 FE FF FF E9 38 FF FF FF 0F 1F 84 00 00 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 04 80 48 C1 E0 20 49 39 C0 0F 82 1A FE FF FF E9 0A FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 1F 48 01 C8 48 01 C0 49 39 C0 0F 82 E1 FD FF FF E9 D1 FE FF FF 90 }
	condition:
		$1
}

rule file_89_7_0 {
	meta:
		name = "__bid64_to_int32_xint"
		size = 880
		refs = "0096 .refptr.__bid_nr_digits 00fc .refptr.__bid_ten2k64 01d3 .refptr.__bid_IDEC_glbflags 01e9 .refptr.__bid_ten2mk64 024e .refptr.__bid_maskhigh128 0259 .refptr.__bid_shiftright128 029a .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 B4 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 9B 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 0A 0F 8F 11 01 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 0A 0F 84 BA 00 00 00 45 85 C9 0F 8E D1 01 00 00 85 D2 0F 88 FD 00 00 00 0F 84 93 00 00 00 4D 85 D2 48 63 D2 0F 84 C7 01 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 3C D0 41 0F AF F8 89 F8 0F 1F 40 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 44 89 C0 F7 D8 4D 85 D2 41 0F 44 C0 5B 5E 5F C3 4D 85 D2 0F 84 3C 01 00 00 83 F8 0B 0F 8F 9E 01 00 00 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 09 00 00 00 05 00 00 00 48 39 C7 0F 86 11 FF FF FF 66 90 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 2C FF FF FF 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C1 F7 DA 48 63 DB 49 C1 E9 20 48 8B 0C D9 4D 89 CB 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F1 4D 0F AF D8 49 89 C9 89 C9 89 F7 49 C1 E9 20 48 C1 EE 20 4C 0F AF C0 49 01 F9 4D 01 C8 4E 8D 0C 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C1 48 8B 05 ?? ?? ?? ?? 4C 8B 1C D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 4C 89 C8 48 D3 E8 83 FA 03 48 89 C1 7E 22 4D 85 D9 74 1D 48 8B 05 ?? ?? ?? ?? 83 08 20 89 C8 F7 D8 4D 85 D2 0F 44 C1 5B 5E 5F C3 0F 1F 44 00 00 48 89 D8 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 3B 40 08 76 D9 EB CD 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 5B 5E 5F C3 48 8B 05 ?? ?? ?? ?? 8B 3C D0 41 0F AF F8 89 F8 E9 3B FE FF FF 83 F8 0B 7F 36 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 FF FF FF FF 04 00 00 00 48 39 C7 0F 86 D9 FD FF FF E9 C5 FE FF FF 0F 1F 44 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 04 80 48 C1 E0 20 49 39 C0 0F 82 AE FD FF FF E9 9A FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 1F 48 01 C8 48 01 C0 49 39 C0 0F 82 75 FD FF FF E9 61 FE FF FF 90 }
	condition:
		$1
}

rule file_89_8_0 {
	meta:
		name = "__bid64_to_int32_rninta"
		size = 832
		refs = "0094 .refptr.__bid_nr_digits 00e6 .refptr.__bid_midpoint64 0188 .refptr.__bid_ten2k64 01f3 .refptr.__bid_ten2mk64 023c .refptr.__bid_shiftright128 02c3 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 A6 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 8D 02 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 B4 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 9A 00 00 00 66 0F EF C0 48 8D 14 09 48 89 D0 F2 49 0F 2A C0 48 C1 E8 36 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 44 8B 0A 45 85 C9 75 0C 4C 3B 42 10 44 8B 4A 18 41 83 D9 FF 8D 90 72 FE FF FF 41 8D 04 11 83 F8 0A 0F 8F 01 02 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 83 F8 0A 0F 84 9B 00 00 00 85 C0 0F 88 83 01 00 00 0F 85 CD 00 00 00 48 8B 15 ?? ?? ?? ?? 41 83 E9 01 4D 63 C9 4E 3B 04 CA 0F 83 D5 00 00 00 5B C3 0F 1F 00 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CD 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 89 D0 4C 89 C2 48 C1 EA 20 48 C1 E8 36 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 23 FF FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 D2 0F 84 08 01 00 00 41 83 F9 0B 0F 8F 60 01 00 00 B0 0B 48 8B 0D ?? ?? ?? ?? 4C 89 C3 44 29 C8 48 98 48 0F AF 1C C1 48 B8 04 00 00 00 05 00 00 00 48 39 C3 0F 87 14 01 00 00 0F 1F 40 00 85 D2 78 2C 0F 85 AA 00 00 00 44 89 C0 F7 D8 4D 85 D2 41 0F 44 C0 5B C3 0F 1F 84 00 00 00 00 00 49 83 FA 01 19 C0 83 E0 02 83 E8 01 5B C3 66 90 48 8B 05 ?? ?? ?? ?? F7 D2 48 63 D2 4C 03 04 D0 48 8B 05 ?? ?? ?? ?? 48 8B 0C D0 4D 89 C1 45 89 C0 49 C1 E9 20 48 89 C8 4C 89 CB 89 C9 48 0F AF D9 48 C1 E8 20 4D 89 CB 49 0F AF C8 4C 0F AF D8 41 89 D9 48 C1 EB 20 48 C1 E9 20 49 0F AF C0 4C 01 C9 4E 8D 0C 1B 48 01 C8 48 8B 0D ?? ?? ?? ?? 48 C1 E8 20 4C 01 C8 8B 0C 91 48 D3 E8 48 89 C2 F7 D8 4D 85 D2 0F 44 C2 5B C3 66 0F 1F 44 00 00 31 C0 5B C3 4D 85 D2 48 63 D2 74 65 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 1C D0 41 0F AF D8 89 D8 5B C3 41 83 F9 0B 0F 8F 85 00 00 00 B8 0B 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 C3 44 29 C8 48 98 48 0F AF 1C C1 48 B8 FA FF FF FF 04 00 00 00 48 39 C3 0F 86 F9 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 5B C3 48 8B 05 ?? ?? ?? ?? 8B 1C D0 41 0F AF D8 89 D8 5B C3 48 8B 05 ?? ?? ?? ?? 41 83 E9 0B 4D 63 C9 4A 8B 04 C8 48 8D 0C 80 48 89 C8 48 C1 E0 20 48 01 C8 49 39 C0 0F 82 A4 FE FF FF EB B2 66 90 48 8B 05 ?? ?? ?? ?? 41 83 E9 0B 4D 63 C9 4A 8B 04 C8 48 8D 0C 80 48 89 C8 48 C1 E0 20 48 29 C8 49 39 C0 0F 82 77 FE FF FF E9 82 FF FF FF 66 90 }
	condition:
		$1
}

rule file_89_9_0 {
	meta:
		name = "__bid64_to_int32_xrninta"
		size = 992
		refs = "0096 .refptr.__bid_nr_digits 00e8 .refptr.__bid_midpoint64 0101 .refptr.__bid_IDEC_glbflags 01a2 .refptr.__bid_ten2k64 022c .refptr.__bid_ten2mk64 0284 .refptr.__bid_maskhigh128 0299 .refptr.__bid_shiftright128 02b0 .refptr.__bid_onehalf128 02ce .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 17 03 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 FE 02 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 14 10 41 83 FA 0A 0F 8F 74 02 00 00 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 0A 0F 84 AA 00 00 00 45 85 D2 0F 88 13 02 00 00 0F 85 DB 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 01 48 63 D0 31 C0 4C 3B 04 D1 0F 83 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 0F 1F 84 00 00 00 00 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 4D 85 C9 0F 84 79 01 00 00 83 F8 0B 0F 8F FE 01 00 00 B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 04 00 00 00 05 00 00 00 48 39 C7 0F 87 75 01 00 00 66 90 85 D2 78 4C 0F 84 18 01 00 00 4D 85 C9 48 63 D2 0F 84 7A 01 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 8B 3C D0 41 0F AF F8 89 F8 E9 22 FF FF FF 66 90 49 83 F9 01 48 8B 15 ?? ?? ?? ?? 19 C0 83 E0 02 83 E8 01 83 0A 20 E9 05 FF FF FF 0F 1F 44 00 00 41 89 D3 48 8B 05 ?? ?? ?? ?? 4D 89 C2 41 F7 D3 F7 DA 4D 63 DB 4E 03 14 D8 48 8B 05 ?? ?? ?? ?? 4A 8B 04 D8 4C 89 D3 44 89 D1 48 C1 EB 20 49 89 C2 48 89 DE 89 C0 49 C1 EA 20 48 0F AF F0 49 0F AF DA 48 0F AF C1 89 F7 48 C1 EE 20 49 89 D8 4C 0F AF D1 48 89 C3 89 C0 48 C1 EB 20 48 01 FB 4A 8D 0C 13 4A 8D 1C 06 49 89 C8 48 C1 E1 20 48 01 C8 48 8B 0D ?? ?? ?? ?? 49 C1 E8 20 4C 01 C3 49 89 D8 4E 8B 14 D9 48 8B 0D ?? ?? ?? ?? 42 8B 0C 99 49 D3 E8 83 FA 03 0F 8E 13 01 00 00 48 8B 15 ?? ?? ?? ?? 4C 21 D3 4A 3B 1C DA 77 1B 75 19 48 85 C0 74 14 49 C1 E3 04 4C 89 DA 48 03 15 ?? ?? ?? ?? 48 3B 42 08 76 0A 48 8B 05 ?? ?? ?? ?? 83 08 20 44 89 C0 F7 D8 4D 85 C9 41 0F 44 C0 5B 5E 5F C3 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 5B 5E 5F C3 83 F8 0B 7F 5E B9 0B 00 00 00 4C 89 C7 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 FA FF FF FF 04 00 00 00 48 39 C7 0F 86 8D FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 C9 FD FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 8B 3C D0 41 0F AF F8 89 F8 E9 AB FD FF FF 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 20 48 29 C8 49 39 C0 0F 82 34 FE FF FF EB A5 66 90 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 8D 0C 80 48 89 C8 48 C1 E0 20 48 01 C8 49 39 C0 0F 82 09 FE FF FF E9 77 FF FF FF 0F 1F 40 00 48 BA 00 00 00 00 00 00 00 80 48 39 D0 0F 86 05 FF FF FF 48 01 D0 E9 E9 FE FF FF 90 90 90 90 90 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "__umodti3"
		size = 384
	strings:
		$1 = { 41 55 41 54 55 57 56 53 48 83 EC 18 48 8B 42 08 4C 8B 11 48 8B 79 08 48 8B 32 48 85 C0 4C 89 D2 49 89 C3 49 89 F8 48 89 F5 48 89 F1 4D 89 D1 49 89 FD 75 2D 48 39 FE 76 57 4C 89 D0 48 89 FA 48 F7 F6 45 31 C0 48 89 14 24 4C 89 44 24 08 66 0F 6F 04 24 90 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D C3 48 39 F8 77 4C 4C 0F BD E0 49 83 F4 3F 45 85 E4 44 89 E3 75 4A 4C 39 D6 0F 86 E1 00 00 00 48 39 F8 0F 82 D8 00 00 00 4C 89 CA 4D 89 E8 EB B5 48 85 F6 75 0D B8 01 00 00 00 31 D2 48 F7 F6 48 89 C1 48 89 F8 31 D2 48 F7 F1 4C 89 D0 48 F7 F1 EB 90 4C 89 D2 EB 8E 66 0F 1F 84 00 00 00 00 00 49 63 C4 41 B9 40 00 00 00 44 89 E1 49 29 C1 49 D3 E3 48 89 F0 44 89 C9 49 89 FA 49 89 D0 48 D3 E8 44 89 E1 48 D3 E5 44 89 C9 49 09 C3 49 D3 EA 48 89 F8 44 89 E1 48 D3 E0 44 89 C9 49 D3 E8 44 89 E1 48 D3 E2 4C 09 C0 48 89 D1 4C 89 D2 49 F7 F3 49 89 D0 48 F7 E5 49 39 D0 48 89 C6 49 89 D2 72 0A 48 39 C1 73 11 49 39 D0 75 0C 49 89 D2 48 89 C6 48 29 EE 4D 19 DA 48 89 CA 89 D9 48 29 F2 4D 19 D0 48 D3 EA 4C 89 C0 44 89 C9 48 D3 E0 89 D9 48 09 C2 49 D3 E8 E9 E9 FE FF FF 0F 1F 40 00 49 89 FD 4D 89 D1 49 29 F1 49 19 C5 E9 17 FF FF FF 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__udivmodti4"
		size = 512
	strings:
		$1 = { 41 56 41 55 41 54 55 57 56 53 48 83 EC 10 4C 8B 62 08 48 8B 32 4C 8B 19 4C 8B 49 08 4D 85 E4 48 89 F5 4C 89 E2 4C 89 D8 4D 89 CA 48 89 F3 4D 89 DD 4D 89 CE 75 2A 4C 39 CE 0F 86 A1 00 00 00 4C 89 CA 45 31 C9 48 F7 F6 4D 85 C0 74 0B 49 89 10 49 C7 40 08 00 00 00 00 48 89 C1 EB 1D 0F 1F 00 4D 39 CC 76 3B 4D 85 C0 0F 84 72 01 00 00 4D 89 48 08 4D 89 18 45 31 C9 31 C9 48 89 0C 24 4C 89 4C 24 08 66 0F 6F 04 24 90 48 83 C4 10 5B 5E 5F 5D 41 5C 41 5D 41 5E C3 0F 1F 84 00 00 00 00 00 49 0F BD FC 48 83 F7 3F 85 FF 89 FB 75 62 49 39 F3 0F 83 09 01 00 00 31 C9 4D 39 E1 0F 87 FE 00 00 00 4D 85 C0 0F 84 25 01 00 00 4D 89 28 4D 89 70 08 45 31 C9 EB A3 66 0F 1F 84 00 00 00 00 00 48 85 F6 75 0D B8 01 00 00 00 31 D2 48 F7 F6 48 89 C3 4C 89 C8 31 D2 48 F7 F3 49 89 C1 4C 89 D8 48 F7 F3 E9 40 FF FF FF 0F 1F 84 00 00 00 00 00 89 F9 BE 40 00 00 00 49 89 EB 48 D3 E2 48 63 CF 49 89 C6 48 29 CE 89 F1 49 D3 EB 89 F9 49 09 D3 48 D3 E5 4C 89 CA 89 F1 48 D3 EA 89 F9 49 D3 E2 89 F1 49 D3 EE 89 F9 48 D3 E0 4D 09 F2 48 89 C7 4C 89 D0 49 F7 F3 48 89 D1 49 89 C2 49 89 C1 48 F7 E5 48 39 D1 49 89 C5 49 89 D4 72 0A 48 39 F8 76 15 48 39 CA 75 10 4D 8D 4A FF 49 89 D4 49 89 C5 49 29 ED 4D 19 DC 4D 85 C0 74 28 48 89 CA 89 D9 48 89 F8 4C 29 E8 4C 19 E2 48 D3 E8 48 89 D7 89 F1 48 D3 E7 89 D9 48 09 F8 48 D3 EA 49 89 00 49 89 50 08 4C 89 C9 45 31 C9 E9 BB FE FF FF 90 4D 89 CE 4D 89 DD B9 01 00 00 00 49 29 F5 4D 19 E6 E9 EC FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 45 31 C9 31 C9 E9 90 FE FF FF 66 0F 1F 44 00 00 45 31 C9 E9 82 FE FF FF 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__bid128_to_uint64_rnint"
		size = 1904
		refs = "00af .refptr.__bid_ten2k64 0124 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 0202 .refptr.__bid_midpoint64 032f .refptr.__bid_midpoint128 0413 .refptr.__bid_ten2k128 04d8 .refptr.__bid_ten2mk128 0645 .refptr.__bid_shiftright128 0669 .refptr.__bid_maskhigh128 06a4 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 11 48 8B 49 08 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 F1 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 85 C9 0F 85 97 00 00 00 41 83 F9 01 0F 84 7C 03 00 00 41 83 F9 13 0F 8F B3 02 00 00 B9 15 00 00 00 44 89 D0 4D 89 D3 44 29 C9 4C 8B 0D ?? ?? ?? ?? 49 C1 EB 20 48 63 C9 4C 89 DE 49 8B 0C C9 48 89 CB 89 C9 49 89 C9 48 C1 EB 20 48 0F AF C8 4D 0F AF CB 48 0F AF C3 49 89 CB 44 89 CF 49 C1 EB 20 49 C1 E9 20 48 0F AF F3 49 01 FB 4C 01 D8 49 89 C3 49 C1 EB 20 49 01 F1 4D 01 D9 49 83 F9 09 77 1D 48 C1 E0 20 89 C9 48 01 C8 48 83 F8 FA 0F 86 E2 01 00 00 49 83 F9 09 0F 85 D8 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 36 FF FF FF 66 0F 1F 44 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 D7 00 00 00 48 85 D2 0F 84 DE 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 49 89 C0 49 C1 E0 05 4D 01 D8 45 8B 08 45 85 C9 75 1A 45 8B 48 18 4D 8B 40 08 4C 39 C2 0F 87 18 01 00 00 4C 39 C2 0F 84 FF 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 01 83 F8 14 0F 8F 54 FF FF FF 49 BB 00 00 00 00 00 00 00 80 4C 21 D9 83 F8 14 0F 84 9E FE FF FF 85 C0 78 49 0F 85 03 01 00 00 41 8D 41 FF 83 F8 12 0F 8F 25 01 00 00 48 85 D2 75 16 4C 8B 05 ?? ?? ?? ?? 48 63 D0 31 C0 4D 3B 14 D0 0F 86 5B FE FF FF 48 85 C9 B8 01 00 00 00 0F 84 4D FE FF FF E9 F9 FE FF FF 0F 1F 84 00 00 00 00 00 31 C0 E9 39 FE FF FF 66 0F 1F 84 00 00 00 00 00 31 C0 4D 85 D2 0F 84 25 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 76 76 66 0F EF D2 4C 89 D0 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 83 E8 01 4C 8B 1D ?? ?? ?? ?? 49 89 C0 49 C1 E0 05 4D 01 D8 45 8B 08 45 85 C9 0F 85 14 FF FF FF 45 8B 48 18 4D 8B 40 08 E9 FE FE FF FF 66 0F 1F 44 00 00 48 C1 E0 05 4D 39 54 03 10 0F 87 F2 FE FF FF 90 41 83 C1 01 E9 E8 FE FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A CA 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 EB 8F 66 90 48 85 C9 0F 85 28 FE FF FF 45 85 C0 0F 88 9E 01 00 00 4C 89 D0 0F 84 65 FD FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 51 FD FF FF 45 8D 41 EC 31 C0 4D 63 C0 49 C1 E0 04 4C 03 05 ?? ?? ?? ?? 49 3B 50 08 0F 82 33 FD FF FF 0F 85 D2 FE FF FF 4D 3B 10 0F 86 24 FD FF FF E9 C4 FE FF FF 41 83 F9 14 0F 84 75 03 00 00 41 83 F9 15 0F 84 EC 03 00 00 41 8D 41 EB 48 8B 0D ?? ?? ?? ?? 48 98 4C 8B 0C C1 4D 89 CB 44 89 CF 4F 8D 0C C9 49 C1 EB 20 48 89 FB 4C 89 D9 4A 8D 04 9D 00 00 00 00 48 C1 E3 20 48 C1 E1 20 49 89 DE 48 29 FB 48 89 CE 4C 29 D9 48 29 C6 4C 01 C9 48 89 F0 48 8D 34 BD 00 00 00 00 4C 29 D8 49 29 F6 41 89 C4 48 C1 E8 20 4C 89 F6 48 01 C8 48 29 FE 48 89 F5 48 C1 ED 20 4C 01 E5 48 01 EB 48 89 D9 48 C1 E9 20 48 01 C8 48 39 C2 0F 87 34 FD FF FF 0F 85 06 FF FF FF 48 89 D8 89 F6 48 C1 E0 20 48 01 F0 4C 39 D0 0F 86 19 FD FF FF E9 EC FE FF FF 0F 1F 00 48 8B 35 ?? ?? ?? ?? 44 89 D1 4D 89 D3 49 C1 EB 20 4C 8B 0E 4C 89 CF 45 89 C9 4C 89 C8 48 C1 EF 20 4C 0F AF C9 49 0F AF C3 48 0F AF CF 4C 89 CB 89 C5 48 C1 EB 20 48 C1 E8 20 48 01 EB 48 01 D9 4C 89 D3 48 0F AF 5E 08 4C 0F AF DF 49 01 DB 4C 01 D8 49 89 CB 49 C1 EB 20 4C 01 D8 48 83 F8 09 0F 87 AB FC FF FF 0F 85 7D FE FF FF 48 89 C8 45 89 C9 48 C1 E0 20 4C 01 C8 48 83 F8 FA 0F 87 8E FC FF FF E9 61 FE FF FF 0F 1F 84 00 00 00 00 00 45 89 C6 41 F7 DE 41 83 FE 13 0F 8F 77 02 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 D1 4D 63 C0 4E 03 0C C0 4D 39 D1 4D 89 C3 4C 89 CF 48 83 D2 00 49 C1 E3 04 4C 03 1D ?? ?? ?? ?? 45 89 C9 48 C1 EF 20 4C 89 CE 48 89 F8 48 89 FB 4D 89 CF 49 8B 4B 08 49 89 CA 89 C9 48 0F AF F1 49 C1 EA 20 48 0F AF C1 49 0F AF DA 48 89 F5 89 F6 41 89 C4 48 C1 ED 20 48 C1 E8 20 4C 01 E5 4D 89 CC 48 01 D8 4D 0F AF E2 4C 01 E5 49 89 FC 48 89 EB 48 C1 E5 20 48 C1 EB 20 48 01 EE 48 01 C3 49 8B 03 49 89 C3 89 C0 4C 0F AF F8 49 C1 EB 20 4C 0F AF E0 4D 0F AF CB 4D 89 FD 4C 89 7C 24 08 49 C1 ED 20 45 89 E7 49 C1 EC 20 49 0F AF FB 4D 01 FD 4D 01 E9 4D 89 CF 49 C1 EF 20 49 01 FC 4D 01 E7 49 01 F7 48 89 D6 89 D2 48 83 D3 00 48 C1 EE 20 48 89 F7 48 89 F5 48 0F AF F9 48 0F AF CA 49 0F AF EA 41 89 FD 48 C1 EF 20 49 89 CC 89 C9 4C 0F AF D2 49 C1 EC 20 48 01 EF 4D 01 EC 4D 01 E2 4C 89 D5 48 C1 ED 20 48 01 EF 48 89 F5 48 0F AF E8 48 0F AF C2 49 0F AF D3 41 89 ED 48 C1 ED 20 49 89 C4 49 C1 EC 20 49 0F AF F3 4D 01 EC 4C 01 E2 49 89 D3 48 C1 E2 20 49 89 D4 89 C2 4C 89 D0 48 01 EE 49 C1 EB 20 48 C1 E0 20 48 01 C8 4C 01 DE 4C 01 E2 48 01 F0 48 83 D7 00 49 01 D7 0F 92 C2 0F B6 D2 48 01 D0 48 01 C3 0F 92 C1 48 39 C2 0F 97 C0 09 C1 0F B6 C9 48 01 CF 41 83 FE 16 0F 8F BE 00 00 00 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 89 D8 48 D3 E7 89 D1 31 D2 48 D3 E8 48 09 C7 48 8B 05 ?? ?? ?? ?? 48 89 F9 4A 23 1C C0 48 09 D3 48 89 C8 0F 85 F0 F9 FF FF 8B 44 24 08 49 C1 E1 20 4C 89 FF 49 01 C1 48 89 C8 4C 09 CF 0F 84 D6 F9 FF FF 4C 89 C2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 4C 3B 7A 08 72 0F 0F 85 BC F9 FF FF 4C 3B 0A 0F 87 B3 F9 FF FF 48 89 C8 31 D2 80 E1 01 0F 95 C2 48 29 D0 E9 A0 F9 FF FF 4B 8D 0C 12 48 8D 04 12 4C 39 D1 48 83 D0 00 48 83 F8 01 0F 87 38 FA FF FF A8 01 0F 84 08 FC FF FF 48 83 C1 01 0F 84 26 FA FF FF E9 F9 FB FF FF 48 8B 05 ?? ?? ?? ?? 48 89 FA 4A 23 14 C0 48 8B 05 ?? ?? ?? ?? 42 8B 0C 80 83 E9 40 48 D3 EF 48 89 F9 E9 4D FF FF FF B8 EC FF FF FF 4D 89 D1 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 08 48 03 50 08 E9 73 FD FF FF 48 83 FA 09 0F 87 C6 F9 FF FF 0F 85 98 FB FF FF 49 83 FA FA 0F 87 B6 F9 FF FF E9 89 FB FF FF }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "__bid128_to_uint64_xrnint"
		size = 2240
		refs = "00af .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 02f2 .refptr.__bid_midpoint64 0339 .refptr.__bid_midpoint128 0413 .refptr.__bid_ten2k128 04dc .refptr.__bid_ten2mk128 0648 .refptr.__bid_maskhigh128 0665 .refptr.__bid_shiftright128 06bc .refptr.__bid_ten2mk128trunc 0725 .refptr.__bid_onehalf128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 11 48 8B 49 08 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 EC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 85 C9 0F 85 96 00 00 00 41 83 F9 01 0F 84 7C 03 00 00 41 83 F9 13 0F 8F B0 02 00 00 B9 15 00 00 00 44 89 D0 4D 89 D3 44 29 C9 4C 8B 0D ?? ?? ?? ?? 49 C1 EB 20 48 63 C9 4C 89 DE 49 8B 0C C9 48 89 CB 89 C9 49 89 C9 48 C1 EB 20 48 0F AF C8 4D 0F AF CB 48 0F AF C3 49 89 CB 44 89 CF 49 C1 EB 20 49 C1 E9 20 48 0F AF F3 49 01 FB 4C 01 D8 49 89 C3 49 C1 EB 20 49 01 F1 4D 01 D9 49 83 F9 09 77 1C 0F 85 F0 00 00 00 48 C1 E0 20 89 C9 48 01 C8 48 83 F8 FA 0F 86 DD 00 00 00 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 37 01 00 00 48 85 D2 0F 84 BE 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 49 89 C0 49 C1 E0 05 4D 01 D8 45 8B 08 45 85 C9 75 1A 45 8B 48 18 4D 8B 40 08 4C 39 C2 0F 87 08 01 00 00 4C 39 C2 0F 84 E6 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 01 83 F8 14 0F 8F 53 FF FF FF 49 BB 00 00 00 00 00 00 00 80 4C 21 D9 83 F8 14 0F 84 9E FE FF FF 85 C0 0F 88 30 01 00 00 0F 84 F0 00 00 00 48 85 C9 0F 85 26 FF FF FF 45 85 C0 0F 88 9D 02 00 00 4C 89 D0 0F 84 64 FE FF FF 48 8B 0D ?? ?? ?? ?? 49 63 D0 48 0F AF 04 D1 E9 50 FE FF FF 31 C0 4D 85 D2 0F 84 45 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 82 00 00 00 66 0F EF D2 4C 89 D0 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 83 E8 01 4C 8B 1D ?? ?? ?? ?? 49 89 C0 49 C1 E0 05 4D 01 D8 45 8B 08 45 85 C9 0F 85 30 FF FF FF 45 8B 48 18 4D 8B 40 08 E9 1A FF FF FF 66 90 31 C0 E9 D9 FD FF FF 48 C1 E0 05 4D 39 54 03 10 0F 87 0B FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 C1 01 E9 F8 FE FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A CA 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 E9 80 FF FF FF 41 8D 41 FF 83 F8 12 7F 42 48 85 D2 75 0F 48 8B 15 ?? ?? ?? ?? 48 98 4C 39 14 C2 73 4C 48 85 C9 B8 01 00 00 00 0F 85 14 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 55 FD FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 44 FD FF FF 41 8D 41 EC 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 3B 50 08 72 07 75 B9 4C 39 10 72 B4 31 C0 EB BE 41 83 F9 14 0F 84 1A 04 00 00 41 83 F9 15 0F 84 B8 04 00 00 41 8D 41 EB 48 8B 0D ?? ?? ?? ?? 48 98 4C 8B 0C C1 4D 89 CB 44 89 CF 4F 8D 0C C9 49 C1 EB 20 48 89 FB 4C 89 D9 4A 8D 04 9D 00 00 00 00 48 C1 E3 20 48 C1 E1 20 49 89 DF 48 29 FB 48 89 CE 4C 29 D9 48 29 C6 4C 01 C9 48 89 F0 48 8D 34 BD 00 00 00 00 4C 29 D8 49 29 F7 41 89 C4 48 C1 E8 20 4C 89 FE 48 01 C8 48 29 FE 48 89 F5 48 C1 ED 20 4C 01 E5 48 01 EB 48 89 D9 48 C1 E9 20 48 01 C8 48 39 C2 0F 87 36 FD FF FF 0F 85 0A FE FF FF 48 89 D8 89 F6 48 C1 E0 20 48 01 F0 4C 39 D0 0F 86 1B FD FF FF E9 F0 FD FF FF 66 0F 1F 44 00 00 48 8B 35 ?? ?? ?? ?? 44 89 D1 4D 89 D3 49 C1 EB 20 4C 8B 0E 4C 89 CF 45 89 C9 4C 89 C8 48 C1 EF 20 4C 0F AF C9 49 0F AF C3 48 0F AF CF 4C 89 CB 89 C5 48 C1 EB 20 48 C1 E8 20 48 01 EB 48 01 D9 4C 89 D3 48 0F AF 5E 08 4C 0F AF DF 49 01 DB 4C 01 D8 49 89 CB 49 C1 EB 20 4C 01 D8 48 83 F8 09 0F 87 AA FC FF FF 48 C1 E1 20 45 89 C9 4C 01 C9 48 83 F9 FA 0F 86 70 FD FF FF 48 83 F8 09 0F 84 8C FC FF FF E9 61 FD FF FF 0F 1F 80 00 00 00 00 44 89 C7 F7 DF 83 FF 13 0F 8F 42 03 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 D1 4D 63 C0 4E 03 0C C0 4D 39 D1 4C 89 C0 4D 89 CD 48 83 D2 00 48 C1 E0 04 45 89 C9 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 ED 20 4C 89 CD 48 89 44 24 08 4C 89 E8 4D 89 EA 4D 89 CF 48 8B 4B 08 49 89 CB 89 C9 48 0F AF E9 49 C1 EB 20 48 0F AF C1 4D 0F AF D3 48 89 EE 89 ED 41 89 C4 48 C1 EE 20 48 C1 E8 20 4C 01 E6 4D 89 CC 4C 01 D0 4D 0F AF E3 49 01 F4 4C 89 EE 4D 89 E2 49 C1 E4 20 49 C1 EA 20 49 01 EC 48 89 D5 49 01 C2 48 8B 03 89 D2 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF EB 4C 0F AF F8 48 0F AF F0 4C 89 2C 24 4D 89 FD 4C 0F AF CB 4D 89 EE 41 89 F7 49 C1 EE 20 48 C1 EE 20 48 03 34 24 4D 01 FE 45 89 ED 4D 01 F1 4D 89 CF 49 C1 E1 20 49 C1 EF 20 49 01 F7 4B 8D 34 29 4D 01 FC 49 83 D2 00 48 C1 ED 20 49 89 ED 49 89 EE 4C 0F AF E9 48 0F AF CA 4D 0F AF F3 45 89 EF 49 C1 ED 20 49 89 C9 89 C9 4C 0F AF DA 49 C1 E9 20 4D 01 F5 4D 01 F9 4D 01 D9 4D 89 CB 49 C1 EB 20 4D 01 EB 49 89 ED 4C 0F AF E8 48 0F AF C2 48 0F AF D3 45 89 EF 49 C1 ED 20 49 89 C6 49 C1 EE 20 48 0F AF EB 4D 01 FE 4C 01 F2 48 89 D3 48 C1 E2 20 49 89 D6 89 C2 4C 89 C8 4C 01 ED 48 C1 EB 20 48 C1 E0 20 48 01 C8 48 01 DD 4C 01 F2 48 01 E8 49 83 D3 00 31 C9 49 01 D4 0F 92 C1 48 01 C8 49 01 C2 0F 92 C2 48 39 C1 0F 97 C0 09 C2 48 8B 05 ?? ?? ?? ?? 0F B6 D2 4C 01 DA 83 FF 16 0F 8F 47 01 00 00 4D 89 D1 4E 23 0C C0 48 8B 05 ?? ?? ?? ?? 42 8B 1C 80 B8 40 00 00 00 29 D8 89 C1 48 D3 E2 89 D9 49 D3 EA 4C 09 D2 83 FF 03 0F 8F 98 00 00 00 48 B8 00 00 00 00 00 00 00 80 49 39 C4 77 0F 0F 85 C4 00 00 00 48 85 F6 0F 84 BB 00 00 00 4C 89 C0 48 B9 00 00 00 00 00 00 00 80 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 01 E1 48 3B 48 08 0F 87 96 00 00 00 0F 84 66 01 00 00 4D 85 C9 48 89 D0 0F 85 91 F9 FF FF 4C 89 E7 48 09 F7 0F 84 85 F9 FF FF 4C 89 C1 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 4C 3B 61 08 72 0F 0F 85 6B F9 FF FF 48 3B 31 0F 87 62 F9 FF FF 48 89 D0 80 E2 01 0F 95 C2 0F B6 D2 48 29 D0 E9 4E F9 FF FF 48 8B 05 ?? ?? ?? ?? 4A 8B 04 C0 49 39 C1 0F 87 11 01 00 00 75 2B 4C 89 E0 48 09 F0 74 23 4C 89 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 3B 60 08 77 0F 0F 85 79 FF FF FF 48 3B 30 0F 86 70 FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 E9 61 FF FF FF 4B 8D 0C 12 48 8D 04 12 4C 39 D1 48 83 D0 00 48 83 F8 01 0F 87 95 F9 FF FF A8 01 0F 84 67 FA FF FF 48 83 C1 01 0F 84 83 F9 FF FF E9 58 FA FF FF 49 89 D1 4E 23 0C C0 48 8B 05 ?? ?? ?? ?? 42 8B 0C 80 48 8B 05 ?? ?? ?? ?? 83 E9 40 48 D3 EA 4E 3B 0C C0 77 06 0F 84 97 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 4D 85 C9 48 89 D0 0F 85 8D F8 FF FF 4D 89 D1 E9 E8 FE FF FF 0F 1F 44 00 00 B8 EC FF FF FF 4D 89 D1 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 08 48 03 50 08 E9 A8 FC FF FF 48 83 FA 09 0F 87 FC F8 FF FF 0F 85 D0 F9 FF FF 49 83 FA FA 0F 87 EC F8 FF FF E9 C1 F9 FF FF 48 3B 30 0F 82 91 FE FF FF E9 1C FF FF FF 4C 89 CF 48 29 C7 49 39 F9 48 89 F8 48 19 C9 48 09 C8 0F 85 04 FF FF FF E9 DC FE FF FF 4D 85 D2 0F 95 C0 4D 85 E4 41 0F 95 C3 48 85 F6 0F 95 C1 41 08 CB 0F 84 4D FF FF FF 84 C0 0F 85 45 FF FF FF 48 8B 44 24 08 48 03 05 ?? ?? ?? ?? 4C 3B 60 08 0F 87 2F FF FF FF 0F 85 33 FF FF FF 48 3B 30 0F 86 2A FF FF FF E9 1B FF FF FF 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "__bid128_to_uint64_floor"
		size = 1232
		refs = "00a6 .refptr.__bid_ten2k64 0103 .refptr.__bid_IDEC_glbflags 0181 .refptr.__bid_nr_digits 0294 .refptr.__bid_ten2mk128 03f0 .refptr.__bid_shiftright128 0466 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 48 8B 51 08 4C 8B 09 48 B9 00 00 00 00 00 00 00 78 49 89 D0 49 21 C8 49 39 C8 0F 84 D0 00 00 00 48 B9 FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 D1 4C 39 C1 77 22 0F 85 CC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C1 0F 86 B9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 01 0F 84 D8 03 00 00 41 83 FA 13 0F 8F 7E 03 00 00 B8 15 00 00 00 4C 89 CB 45 89 CB 44 29 D0 4C 8B 15 ?? ?? ?? ?? 48 C1 EB 20 48 98 4D 8B 14 C2 4C 89 D8 4C 89 D6 45 89 D2 4C 89 D7 48 C1 EE 20 48 0F AF FB 4D 0F AF D3 48 0F AF DE 89 FD 48 C1 EF 20 49 C1 EA 20 4C 8D 1C 1F 49 01 EA 48 0F AF C6 4C 01 D0 48 C1 E8 20 4C 01 D8 48 83 F8 09 0F 86 D6 00 00 00 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 57 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 D0 49 21 C0 49 39 C0 0F 84 BC 00 00 00 48 85 C9 41 0F 94 C0 75 0B 31 C0 4D 85 C9 0F 84 23 FF FF FF 48 85 D2 78 AE 45 84 C0 0F 85 A5 00 00 00 66 0F EF C0 F2 48 0F 2A C1 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 10 45 85 D2 75 14 48 3B 48 08 44 8B 50 18 0F 87 A6 00 00 00 0F 84 96 00 00 00 4C 8D 04 12 49 C1 E8 32 41 81 E8 20 18 00 00 47 8D 1C 02 41 83 FB 14 0F 8F 42 FF FF FF 0F 84 BD FE FF FF 31 C0 45 85 DB 0F 8E A1 FE FF FF 45 85 C0 0F 88 99 00 00 00 4C 89 C8 0F 84 8F FE FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 7B FE FF FF 31 C0 E9 74 FE FF FF 0F 1F 40 00 48 B8 FF FF FF FF FF FF 1F 00 49 39 C1 76 41 66 0F EF D2 4C 89 C8 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 40 FF FF FF 4C 39 48 10 0F 87 60 FF FF FF 41 83 C2 01 E9 57 FF FF FF 66 0F 1F 44 00 00 66 0F EF C9 F2 49 0F 2A C9 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 E9 06 FF FF FF 44 89 C0 41 F7 D0 4D 89 CD 4D 63 C0 F7 D8 49 C1 ED 20 4C 89 C3 89 44 24 0C 44 89 C8 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 89 D2 4C 8B 4B 08 4C 89 CE 45 89 C9 4C 89 CF 4D 89 CA 48 C1 EE 20 48 0F AF F8 49 89 F3 4D 0F AF D5 4D 0F AF DD 48 89 FD 89 FF 45 89 D4 48 C1 ED 20 49 C1 EA 20 4C 01 E5 49 89 F4 4D 01 DA 4C 0F AF E0 4C 01 E5 49 89 EB 48 C1 E5 20 49 C1 EB 20 48 01 EF 4D 01 D3 4C 8B 13 4C 89 D3 45 89 D2 4D 89 D4 4D 89 D6 48 C1 EB 20 4D 0F AF E5 4C 0F AF F0 48 0F AF C3 45 89 E7 49 C1 EC 20 49 C1 EE 20 4C 0F AF EB 4D 01 FE 4C 01 F0 48 C1 E8 20 4D 01 E5 4C 01 E8 48 01 C7 49 83 D3 00 48 C1 E9 20 48 89 CD 49 89 CC 49 0F AF E9 4C 0F AF CA 4C 0F AF E6 41 89 ED 48 C1 ED 20 4C 89 C8 45 89 C9 48 0F AF F2 48 C1 E8 20 4C 01 E5 48 01 F0 4A 8D 34 28 48 89 F0 48 C1 E6 20 48 C1 E8 20 48 01 E8 48 89 CD 49 0F AF EA 4C 0F AF D2 48 0F AF CB 41 89 EC 48 C1 ED 20 4D 89 D5 45 89 D2 48 0F AF DA 49 C1 ED 20 48 01 E9 4C 01 EB 4C 01 E3 48 89 DA 48 C1 E3 20 48 C1 EA 20 49 01 DA 48 01 CA 4A 8D 0C 0E 48 89 FE 48 01 CA 48 83 D0 00 45 31 C9 4C 01 D6 41 0F 92 C1 49 8D 0C 11 49 01 CB 41 0F 92 C2 49 39 C9 0F 97 C2 44 09 D2 0F B6 D2 48 01 D0 83 7C 24 0C 16 7F 60 48 8B 15 ?? ?? ?? ?? 46 8B 04 82 BA 40 00 00 00 44 29 C2 89 D1 48 D3 E0 44 89 C1 49 D3 EB 4C 09 D8 E9 5D FC FF FF 41 83 FA 14 0F 84 94 00 00 00 41 83 FA 15 0F 84 98 00 00 00 41 8D 42 EB 4C 8B 15 ?? ?? ?? ?? 48 98 49 8B 04 C2 48 8D 04 80 48 01 C0 48 39 C1 0F 82 87 FD FF FF E9 B3 FC FF FF 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 83 E9 40 48 D3 E8 E9 0D FC FF FF 48 8B 3D ?? ?? ?? ?? 4D 89 CF 4C 89 CB 48 C1 EB 20 44 89 C8 4C 8B 17 4C 0F AF 7F 08 4C 89 D6 45 89 D2 4D 89 D3 48 C1 EE 20 4C 0F AF DB 4C 0F AF D0 48 0F AF DE 44 89 DD 49 C1 EB 20 49 C1 EA 20 4C 01 FB 49 01 EA 49 01 DB E9 30 FC FF FF 48 85 C9 0F 85 46 FC FF FF E9 10 FD FF FF 48 83 F9 09 0F 87 37 FC FF FF E9 01 FD FF FF 66 90 }
	condition:
		$1
}

rule file_92_3_0 {
	meta:
		name = "__bid128_to_uint64_xfloor"
		size = 1456
		refs = "00a6 .refptr.__bid_ten2k64 0103 .refptr.__bid_IDEC_glbflags 0181 .refptr.__bid_nr_digits 0299 .refptr.__bid_ten2mk128 0411 .refptr.__bid_maskhigh128 041c .refptr.__bid_shiftright128 044c .refptr.__bid_ten2mk128trunc 0520 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 48 8B 51 08 4C 8B 09 48 B9 00 00 00 00 00 00 00 78 49 89 D0 49 21 C8 49 39 C8 0F 84 D0 00 00 00 48 B9 FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 D1 4C 39 C1 77 22 0F 85 CC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C1 0F 86 B9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 01 0F 84 92 04 00 00 41 83 FA 13 0F 8F F6 03 00 00 B8 15 00 00 00 4C 89 CB 45 89 CB 44 29 D0 4C 8B 15 ?? ?? ?? ?? 48 C1 EB 20 48 98 4D 8B 14 C2 4C 89 D8 4C 89 D6 45 89 D2 4C 89 D7 48 C1 EE 20 48 0F AF FB 4D 0F AF D3 48 0F AF DE 89 FD 48 C1 EF 20 49 C1 EA 20 48 0F AF C6 49 01 EA 4C 8D 1C 1F 4C 01 D0 48 C1 E8 20 4C 01 D8 48 83 F8 09 0F 86 D2 00 00 00 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 57 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 D0 49 21 C0 49 39 C0 0F 84 B8 00 00 00 48 85 C9 41 0F 94 C0 75 0B 31 C0 4D 85 C9 0F 84 23 FF FF FF 48 85 D2 78 AE 45 84 C0 0F 85 A5 00 00 00 66 0F EF C0 F2 48 0F 2A C1 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 10 45 85 D2 75 14 48 3B 48 08 44 8B 50 18 0F 87 A6 00 00 00 0F 84 96 00 00 00 4C 8D 04 12 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 02 83 F8 14 0F 8F 43 FF FF FF 0F 84 BE FE FF FF 85 C0 0F 8E AF 02 00 00 45 85 C0 0F 88 9D 00 00 00 4C 89 C8 0F 84 93 FE FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 7F FE FF FF 31 C0 E9 78 FE FF FF 0F 1F 84 00 00 00 00 00 48 B8 FF FF FF FF FF FF 1F 00 49 39 C1 76 41 66 0F EF D2 4C 89 C8 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 40 FF FF FF 4C 39 48 10 0F 87 60 FF FF FF 41 83 C2 01 E9 57 FF FF FF 66 0F 1F 44 00 00 66 0F EF C9 F2 49 0F 2A C9 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 E9 06 FF FF FF 44 89 C0 41 F7 D0 4D 89 CD 4D 63 C0 F7 D8 49 C1 ED 20 4D 89 C7 89 44 24 14 44 89 C8 49 C1 E7 04 89 D2 4C 89 FB 48 03 1D ?? ?? ?? ?? 4C 8B 53 08 4D 89 D3 45 89 D2 4C 89 D7 4D 89 D1 49 C1 EB 20 48 0F AF F8 4C 89 DE 4D 0F AF CD 49 0F AF F5 48 89 FD 89 FF 45 89 CC 48 C1 ED 20 49 C1 E9 20 4C 01 E5 4D 89 DC 49 01 F1 4C 0F AF E0 4C 01 E5 48 89 EE 48 C1 E5 20 48 C1 EE 20 48 01 EF 4C 01 CE 4C 8B 0B 48 89 74 24 08 4C 89 CB 45 89 C9 48 C1 EB 20 4D 89 CC 4D 0F AF E5 4C 0F AF EB 45 89 E6 49 C1 EC 20 4C 89 6C 24 18 4D 89 CD 4C 03 64 24 18 4C 0F AF E8 48 0F AF C3 4C 89 EE 48 C1 EE 20 49 01 F6 4C 01 F0 49 89 C6 48 C1 E0 20 49 C1 EE 20 4D 01 E6 45 89 EC 49 01 C4 4C 01 F7 48 83 54 24 08 00 48 C1 E9 20 48 8B 74 24 08 48 89 CD 49 89 CD 49 0F AF EA 4C 0F AF D2 4D 0F AF EB 89 E8 48 C1 ED 20 4D 89 D6 45 89 D2 4C 0F AF DA 49 C1 EE 20 4C 01 ED 4D 01 F3 4C 01 D8 49 89 C3 48 C1 E0 20 49 C1 EB 20 4C 01 D0 49 01 EB 48 89 CD 49 0F AF E9 4C 0F AF CA 48 0F AF D3 41 89 ED 48 C1 ED 20 4D 89 CE 45 89 C9 48 0F AF CB 49 C1 EE 20 49 01 D6 4D 01 F5 4C 89 EA 49 C1 E5 20 48 01 E9 48 C1 EA 20 48 01 CA 4B 8D 4C 0D 00 48 01 D0 49 83 D3 00 31 D2 48 01 CF 0F 92 C2 48 01 D0 48 01 C6 0F 92 C1 48 39 C2 0F 97 C0 09 C8 0F B6 C0 49 01 C3 83 7C 24 14 16 0F 8F B7 00 00 00 48 8B 05 ?? ?? ?? ?? 4E 8B 0C C0 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 89 F0 49 D3 E3 89 D1 48 D3 E8 49 09 C3 83 7C 24 14 03 0F 8F 5B 01 00 00 4C 89 FA 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 77 12 4C 89 D8 0F 85 11 FC FF FF 4C 3B 22 0F 86 08 FC FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 4C 89 D8 E9 F6 FB FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 E5 FB FF FF 41 83 FA 14 0F 84 EF 00 00 00 41 83 FA 15 0F 84 F3 00 00 00 41 8D 42 EB 4C 8B 15 ?? ?? ?? ?? 48 98 49 8B 04 C2 48 8D 04 80 48 01 C0 48 39 C1 0F 82 0B FD FF FF E9 3B FC FF FF 48 8B 05 ?? ?? ?? ?? 4C 89 DA 42 8B 0C 80 48 8B 05 ?? ?? ?? ?? 4E 23 1C C0 83 E9 40 48 D3 EA 49 09 F3 75 22 4C 89 F9 48 03 0D ?? ?? ?? ?? 48 3B 79 08 77 12 48 89 D0 0F 85 6E FB FF FF 4C 3B 21 0F 86 65 FB FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 48 89 D0 E9 53 FB FF FF 48 8B 2D ?? ?? ?? ?? 4C 89 CE 45 89 CA 48 C1 EE 20 4C 8B 5D 00 4C 89 DF 45 89 DB 4C 89 DB 48 C1 EF 20 48 0F AF DE 4D 0F AF DA 48 0F AF F7 89 D8 48 C1 EB 20 49 C1 EB 20 49 01 C3 4C 89 C8 48 0F AF 45 08 4C 0F AF D7 48 01 C6 4B 8D 04 13 48 01 F3 48 C1 E8 20 48 01 D8 48 83 F8 09 0F 87 81 FB FF FF E9 47 FC FF FF 48 85 C9 0F 85 73 FB FF FF E9 39 FC FF FF 48 83 F9 09 0F 87 64 FB FF FF E9 2A FC FF FF 4C 85 CE 0F 85 BE FE FF FF E9 97 FE FF FF 90 }
	condition:
		$1
}

rule file_92_4_0 {
	meta:
		name = "__bid128_to_uint64_ceil"
		size = 1712
		refs = "00a6 .refptr.__bid_ten2k64 0113 .refptr.__bid_IDEC_glbflags 015e .refptr.__bid_nr_digits 03a9 .refptr.__bid_ten2mk128 0520 .refptr.__bid_maskhigh128 052b .refptr.__bid_shiftright128 055b .refptr.__bid_ten2mk128trunc 0575 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 48 8B 51 08 48 B8 00 00 00 00 00 00 00 78 4C 8B 09 48 89 D1 48 21 C1 48 39 C1 0F 84 E0 00 00 00 48 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 48 21 D0 48 39 C8 77 19 0F 85 E3 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 0F 86 D0 00 00 00 31 C0 E9 B8 00 00 00 0F 1F 40 00 4D 85 DB 0F 85 97 00 00 00 41 83 FA 01 0F 84 EF 04 00 00 41 83 FA 13 0F 8F 52 02 00 00 41 BB 15 00 00 00 44 89 C9 4C 89 CE 45 29 D3 48 C1 EE 20 4D 63 D3 4C 8B 1D ?? ?? ?? ?? 4F 8B 14 D3 4C 89 D7 45 89 D2 4D 89 D3 48 C1 EF 20 4C 0F AF D1 4C 0F AF DE 48 0F AF CF 4C 89 D3 44 89 DD 48 C1 EB 20 49 C1 EB 20 48 0F AF F7 48 01 EB 48 01 D9 48 89 CB 48 C1 EB 20 49 01 F3 49 01 DB 49 83 FB 09 77 1E 48 C1 E1 20 45 89 D2 4C 01 D1 48 83 F9 F6 0F 86 ED 00 00 00 49 83 FB 09 0F 85 E3 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 B9 00 00 00 00 00 00 00 60 49 89 D0 49 21 C8 49 39 C8 0F 84 17 FF FF FF 48 85 C0 0F 84 C9 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C0 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C1 48 C1 E1 05 4C 01 D9 44 8B 11 45 85 D2 75 20 44 8B 51 18 48 8B 49 08 48 39 C8 0F 87 FF 00 00 00 48 39 C8 0F 84 E6 00 00 00 66 0F 1F 44 00 00 4C 8D 04 12 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 0C 02 83 F9 14 0F 8F 44 FF FF FF 49 BB 00 00 00 00 00 00 00 80 49 21 D3 83 F9 14 0F 84 8E FE FF FF 85 C9 0F 8E E8 00 00 00 4D 85 DB 0F 85 1D FF FF FF 45 85 C0 0F 88 85 01 00 00 4C 89 C8 0F 84 1F FF FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 0B FF FF FF 0F 1F 80 00 00 00 00 4D 85 C9 0F 84 FB FE FF FF 48 B9 FF FF FF FF FF FF 1F 00 49 39 C9 76 78 66 0F EF D2 4D 89 C8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 1D ?? ?? ?? ?? 4C 89 C1 48 C1 E1 05 4C 01 D9 44 8B 11 45 85 D2 0F 85 30 FF FF FF 44 8B 51 18 48 8B 49 08 E9 14 FF FF FF 0F 1F 00 49 C1 E0 05 4F 39 4C 03 10 0F 87 11 FF FF FF 90 41 83 C2 01 E9 07 FF FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A C9 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 EB 8D 31 C0 4D 85 DB 0F 94 C0 E9 45 FE FF FF 41 83 FA 14 0F 84 7D 03 00 00 41 83 FA 15 0F 84 81 03 00 00 41 8D 4A EB 4C 8B 15 ?? ?? ?? ?? 48 63 C9 4D 8B 1C CA B9 F6 FF FF FF 4C 89 DF 44 89 DD 4F 8D 1C DB 48 C1 EF 20 49 89 FA 4C 0F AF D1 48 0F AF CD 44 89 D6 49 C1 EA 20 48 89 CB 48 C1 EB 20 48 01 DE 48 89 EB 48 C1 E3 20 48 29 EB 48 01 F3 48 89 FE 48 C1 E6 20 48 29 FE 49 01 F3 4D 01 DA 49 89 DB 49 C1 EB 20 4D 01 DA 4C 39 D0 0F 87 AC FD FF FF 0F 85 89 FE FF FF 48 C1 E3 20 89 C9 48 01 D9 4C 39 C9 0F 82 94 FD FF FF E9 72 FE FF FF 44 89 C7 41 F7 D0 44 89 C9 4D 63 C0 F7 DF 4D 89 CD 4D 89 C7 89 7C 24 14 49 C1 ED 20 49 C1 E7 04 89 D2 4C 89 FB 48 03 1D ?? ?? ?? ?? 4C 8B 53 08 4D 89 D3 45 89 D2 4C 89 D7 4D 89 D1 49 C1 EB 20 48 0F AF F9 4C 89 DE 4D 0F AF CD 49 0F AF F5 48 89 FD 89 FF 45 89 CC 48 C1 ED 20 49 C1 E9 20 4C 01 E5 4D 89 DC 49 01 F1 4C 0F AF E1 4C 01 E5 48 89 EE 48 C1 E5 20 48 C1 EE 20 48 01 EF 4C 01 CE 4C 8B 0B 48 89 74 24 08 4C 89 CB 45 89 C9 48 C1 EB 20 4D 89 CC 4D 0F AF E5 4C 0F AF EB 45 89 E6 49 C1 EC 20 4C 89 6C 24 18 4D 89 CD 4C 03 64 24 18 4C 0F AF E9 48 0F AF CB 4C 89 EE 48 C1 EE 20 49 01 F6 4C 01 F1 49 89 CE 48 C1 E1 20 49 C1 EE 20 4D 01 E6 45 89 EC 49 01 CC 4C 01 F7 48 83 54 24 08 00 48 C1 E8 20 48 8B 74 24 08 48 89 C5 49 89 C5 49 0F AF EA 4C 0F AF D2 4D 0F AF EB 89 E9 48 C1 ED 20 4D 89 D6 45 89 D2 4C 0F AF DA 49 C1 EE 20 4C 01 ED 4D 01 F3 4C 01 D9 49 89 CB 48 C1 E1 20 49 C1 EB 20 49 01 EB 48 89 C5 49 0F AF E9 4C 0F AF CA 48 0F AF D3 41 89 ED 48 C1 ED 20 4D 89 CE 45 89 C9 48 0F AF C3 49 C1 EE 20 49 01 D6 4D 01 F5 4C 89 EA 49 C1 E5 20 48 01 E8 48 C1 EA 20 4D 01 E9 48 01 C2 4A 8D 04 11 48 01 D0 49 83 D3 00 31 D2 4C 01 CF 0F 92 C2 48 01 D0 48 01 C6 0F 92 C1 48 39 C2 0F 97 C0 09 C8 0F B6 C0 49 01 C3 83 7C 24 14 16 0F 8F E3 00 00 00 48 8B 05 ?? ?? ?? ?? 4E 8B 0C C0 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 89 F0 49 D3 E3 89 D1 48 D3 E8 49 09 C3 83 7C 24 14 03 0F 8F 3E 01 00 00 4C 89 FA 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 0F 86 E6 00 00 00 49 8D 43 01 E9 B2 FB FF FF 48 8B 35 ?? ?? ?? ?? 4C 89 CB 45 89 CA 48 C1 EB 20 4C 8B 1E 4C 89 DF 45 89 DB 48 C1 EF 20 4C 89 D9 48 0F AF CB 4D 0F AF DA 48 0F AF DF 41 89 CC 48 C1 E9 20 4C 89 DD 4C 0F AF D7 4C 89 CF 48 C1 ED 20 48 0F AF 7E 08 4C 01 E5 49 01 EA 48 01 FB 48 01 D9 4C 89 D3 48 C1 EB 20 48 01 D9 48 83 F9 09 0F 87 37 FB FF FF 49 C1 E2 20 45 89 DB 4D 01 DA 49 83 FA F6 0F 86 06 FC FF FF 48 83 F9 09 0F 84 19 FB FF FF E9 F7 FB FF FF 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 4C 89 DA 42 8B 0C 80 48 8B 05 ?? ?? ?? ?? 4E 23 1C C0 83 E9 40 48 D3 EA 49 09 F3 75 22 4C 89 F9 48 03 0D ?? ?? ?? ?? 48 3B 79 08 77 12 48 89 D0 0F 85 E7 FA FF FF 4C 3B 21 0F 86 DE FA FF FF 48 8D 42 01 E9 D5 FA FF FF 4C 89 D8 0F 85 CC FA FF FF 4C 3B 22 0F 86 C3 FA FF FF E9 03 FF FF FF 48 85 C0 0F 85 A1 FA FF FF E9 7F FB FF FF 48 83 F8 09 0F 87 92 FA FF FF 0F 85 6F FB FF FF 49 83 F9 F6 0F 87 82 FA FF FF E9 60 FB FF FF 4C 85 CE 0F 85 CD FE FF FF E9 B4 FE FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_92_5_0 {
	meta:
		name = "__bid128_to_uint64_xceil"
		size = 1728
		refs = "00a6 .refptr.__bid_ten2k64 0113 .refptr.__bid_IDEC_glbflags 015e .refptr.__bid_nr_digits 03b8 .refptr.__bid_ten2mk128 052f .refptr.__bid_maskhigh128 053a .refptr.__bid_shiftright128 056a .refptr.__bid_ten2mk128trunc 058e .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 48 8B 51 08 48 B8 00 00 00 00 00 00 00 78 4C 8B 09 48 89 D1 48 21 C1 48 39 C1 0F 84 E0 00 00 00 48 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 48 21 D0 48 39 C8 77 19 0F 85 E3 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 0F 86 D0 00 00 00 31 C0 E9 B8 00 00 00 0F 1F 40 00 4D 85 DB 0F 85 97 00 00 00 41 83 FA 01 0F 84 08 05 00 00 41 83 FA 13 0F 8F 5C 02 00 00 41 BB 15 00 00 00 44 89 C9 4C 89 CE 45 29 D3 48 C1 EE 20 4D 63 D3 4C 8B 1D ?? ?? ?? ?? 4F 8B 14 D3 4C 89 D7 45 89 D2 4D 89 D3 48 C1 EF 20 4C 0F AF D1 4C 0F AF DE 48 0F AF CF 4C 89 D3 44 89 DD 48 C1 EB 20 49 C1 EB 20 48 0F AF F7 48 01 EB 48 01 D9 48 89 CB 48 C1 EB 20 49 01 F3 49 01 DB 49 83 FB 09 77 1E 48 C1 E1 20 45 89 D2 4C 01 D1 48 83 F9 F6 0F 86 ED 00 00 00 49 83 FB 09 0F 85 E3 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 B9 00 00 00 00 00 00 00 60 49 89 D0 49 21 C8 49 39 C8 0F 84 17 FF FF FF 48 85 C0 0F 84 C9 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C0 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C1 48 C1 E1 05 4C 01 D9 44 8B 11 45 85 D2 75 20 44 8B 51 18 48 8B 49 08 48 39 C8 0F 87 FF 00 00 00 48 39 C8 0F 84 E6 00 00 00 66 0F 1F 44 00 00 4C 8D 04 12 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 0C 02 83 F9 14 0F 8F 44 FF FF FF 49 BB 00 00 00 00 00 00 00 80 49 21 D3 83 F9 14 0F 84 8E FE FF FF 85 C9 0F 8E E8 00 00 00 4D 85 DB 0F 85 1D FF FF FF 45 85 C0 0F 88 94 01 00 00 4C 89 C8 0F 84 1F FF FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 0B FF FF FF 0F 1F 80 00 00 00 00 4D 85 C9 0F 84 FB FE FF FF 48 B9 FF FF FF FF FF FF 1F 00 49 39 C9 76 78 66 0F EF D2 4D 89 C8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 1D ?? ?? ?? ?? 4C 89 C1 48 C1 E1 05 4C 01 D9 44 8B 11 45 85 D2 0F 85 30 FF FF FF 44 8B 51 18 48 8B 49 08 E9 14 FF FF FF 0F 1F 00 49 C1 E0 05 4F 39 4C 03 10 0F 87 11 FF FF FF 90 41 83 C2 01 E9 07 FF FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A C9 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 EB 8D 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 DB 0F 94 C0 E9 3B FE FF FF 41 83 FA 14 0F 84 92 03 00 00 41 83 FA 15 0F 84 96 03 00 00 41 8D 4A EB 4C 8B 15 ?? ?? ?? ?? 48 63 C9 4D 8B 1C CA B9 F6 FF FF FF 4C 89 DF 44 89 DD 4F 8D 1C DB 48 C1 EF 20 49 89 FA 4C 0F AF D1 48 0F AF CD 44 89 D6 49 C1 EA 20 48 89 CB 48 C1 EB 20 48 01 DE 48 89 EB 48 C1 E3 20 48 29 EB 48 01 F3 48 89 FE 48 C1 E6 20 48 29 FE 49 01 F3 4D 01 DA 49 89 DB 49 C1 EB 20 4D 01 DA 4C 39 D0 0F 87 A2 FD FF FF 0F 85 7F FE FF FF 48 C1 E3 20 89 C9 48 01 D9 4C 39 C9 0F 82 8A FD FF FF E9 68 FE FF FF 0F 1F 44 00 00 44 89 C7 41 F7 D0 44 89 C9 4D 63 C0 F7 DF 4D 89 CD 4D 89 C7 89 7C 24 14 49 C1 ED 20 49 C1 E7 04 89 D2 4C 89 FB 48 03 1D ?? ?? ?? ?? 4C 8B 53 08 4D 89 D3 45 89 D2 4C 89 D7 4D 89 D1 49 C1 EB 20 48 0F AF F9 4C 89 DE 4D 0F AF CD 49 0F AF F5 48 89 FD 89 FF 45 89 CC 48 C1 ED 20 49 C1 E9 20 4C 01 E5 4D 89 DC 49 01 F1 4C 0F AF E1 4C 01 E5 48 89 EE 48 C1 E5 20 48 C1 EE 20 48 01 EF 4C 01 CE 4C 8B 0B 48 89 74 24 08 4C 89 CB 45 89 C9 48 C1 EB 20 4D 89 CC 4D 0F AF E5 4C 0F AF EB 45 89 E6 49 C1 EC 20 4C 89 6C 24 18 4D 89 CD 4C 03 64 24 18 4C 0F AF E9 48 0F AF CB 4C 89 EE 48 C1 EE 20 49 01 F6 4C 01 F1 49 89 CE 48 C1 E1 20 49 C1 EE 20 4D 01 E6 45 89 EC 49 01 CC 4C 01 F7 48 83 54 24 08 00 48 C1 E8 20 48 8B 74 24 08 48 89 C5 49 89 C5 49 0F AF EA 4C 0F AF D2 4D 0F AF EB 89 E9 48 C1 ED 20 4D 89 D6 45 89 D2 4C 0F AF DA 49 C1 EE 20 4C 01 ED 4D 01 F3 4C 01 D9 49 89 CB 48 C1 E1 20 49 C1 EB 20 49 01 EB 48 89 C5 49 0F AF E9 4C 0F AF CA 48 0F AF D3 41 89 ED 48 C1 ED 20 4D 89 CE 45 89 C9 48 0F AF C3 49 C1 EE 20 49 01 D6 4D 01 F5 4C 89 EA 49 C1 E5 20 48 01 E8 48 C1 EA 20 4D 01 E9 48 01 C2 4A 8D 04 11 48 01 D0 49 83 D3 00 31 D2 4C 01 CF 0F 92 C2 48 01 D0 48 01 C6 0F 92 C1 48 39 C2 0F 97 C0 09 C8 0F B6 C0 49 01 C3 83 7C 24 14 16 0F 8F E9 00 00 00 48 8B 05 ?? ?? ?? ?? 4E 8B 0C C0 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 89 F0 49 D3 E3 89 D1 48 D3 E8 49 09 C3 83 7C 24 14 03 0F 8F 4E 01 00 00 4C 89 FA 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 0F 86 F6 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 49 8D 43 01 E9 99 FB FF FF 48 8B 35 ?? ?? ?? ?? 4C 89 CB 45 89 CA 48 C1 EB 20 4C 8B 1E 4C 89 DF 45 89 DB 48 C1 EF 20 4C 89 D9 48 0F AF CB 4D 0F AF DA 48 0F AF DF 41 89 CC 48 C1 E9 20 4C 89 DD 4C 0F AF D7 4C 89 CF 48 C1 ED 20 48 0F AF 7E 08 4C 01 E5 49 01 EA 48 01 FB 48 01 D9 4C 89 D3 48 C1 EB 20 48 01 D9 48 83 F9 09 0F 87 1E FB FF FF 49 C1 E2 20 45 89 DB 4D 01 DA 49 83 FA F6 0F 86 ED FB FF FF 48 83 F9 09 0F 84 00 FB FF FF E9 DE FB FF FF 48 8B 05 ?? ?? ?? ?? 4C 89 DA 42 8B 0C 80 48 8B 05 ?? ?? ?? ?? 4E 23 1C C0 83 E9 40 48 D3 EA 49 09 F3 75 22 4C 89 F9 48 03 0D ?? ?? ?? ?? 48 3B 79 08 77 12 48 89 D0 0F 85 D2 FA FF FF 4C 3B 21 0F 86 C9 FA FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 48 8D 42 01 E9 B6 FA FF FF 4C 89 D8 0F 85 AD FA FF FF 4C 3B 22 0F 86 A4 FA FF FF E9 F3 FE FF FF 48 85 C0 0F 85 82 FA FF FF E9 60 FB FF FF 48 83 F8 09 0F 87 73 FA FF FF 0F 85 50 FB FF FF 49 83 F9 F6 0F 87 63 FA FF FF E9 41 FB FF FF 4C 85 CE 0F 85 BD FE FF FF E9 A4 FE FF FF }
	condition:
		$1
}

rule file_92_6_0 {
	meta:
		name = "__bid128_to_uint64_int"
		size = 1312
		refs = "00a1 .refptr.__bid_ten2k64 00f3 .refptr.__bid_IDEC_glbflags 013e .refptr.__bid_nr_digits 02d5 .refptr.__bid_ten2mk128 0436 .refptr.__bid_shiftright128 0497 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 48 8B 51 08 48 B8 00 00 00 00 00 00 00 78 4C 8B 09 48 89 D1 48 21 C1 48 39 C1 0F 84 C0 00 00 00 48 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 48 21 D0 48 39 C8 77 19 0F 85 C3 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 0F 86 B0 00 00 00 31 C0 E9 98 00 00 00 0F 1F 40 00 4D 85 DB 75 7B 41 83 FA 01 0F 84 15 04 00 00 41 83 FA 13 0F 8F D0 03 00 00 BB 15 00 00 00 4D 89 CB 44 89 C9 44 29 D3 49 C1 EB 20 4C 63 D3 48 8B 1D ?? ?? ?? ?? 4E 8B 14 D3 4C 89 D3 45 89 D2 4C 89 D6 48 C1 EB 20 49 0F AF F3 4C 0F AF D1 4C 0F AF DB 89 F7 48 C1 EE 20 49 C1 EA 20 48 0F AF CB 49 01 FA 49 01 F3 4C 01 D1 48 C1 E9 20 4C 01 D9 48 83 F9 09 0F 86 E9 00 00 00 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 B9 00 00 00 00 00 00 00 60 49 89 D0 49 21 C8 49 39 C8 0F 84 37 FF FF FF 48 85 C0 0F 84 C9 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C0 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C1 48 C1 E1 05 4C 01 D9 44 8B 11 45 85 D2 75 20 44 8B 51 18 48 8B 49 08 48 39 C8 0F 87 FF 00 00 00 48 39 C8 0F 84 E6 00 00 00 66 0F 1F 44 00 00 4C 8D 04 12 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 0C 02 83 F9 14 0F 8F 44 FF FF FF 49 BB 00 00 00 00 00 00 00 80 49 21 D3 83 F9 14 0F 84 AE FE FF FF 85 C9 0F 8E 9B FE FF FF 4D 85 DB 0F 85 1D FF FF FF 45 85 C0 0F 88 D6 00 00 00 4C 89 C8 0F 84 1F FF FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 0B FF FF FF 0F 1F 80 00 00 00 00 4D 85 C9 0F 84 FB FE FF FF 48 B9 FF FF FF FF FF FF 1F 00 49 39 C9 76 78 66 0F EF D2 4D 89 C8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 1D ?? ?? ?? ?? 4C 89 C1 48 C1 E1 05 4C 01 D9 44 8B 11 45 85 D2 0F 85 30 FF FF FF 44 8B 51 18 48 8B 49 08 E9 14 FF FF FF 0F 1F 00 49 C1 E0 05 4F 39 4C 03 10 0F 87 11 FF FF FF 90 41 83 C2 01 E9 07 FF FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A C9 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 EB 8D 44 89 C7 41 F7 D0 44 89 C9 4D 63 C0 4D 89 CD F7 DF 4D 89 C2 49 C1 ED 20 89 7C 24 0C 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 89 D2 4D 8B 4A 08 4D 8B 12 4C 89 CE 45 89 C9 4D 89 CF 4D 89 CB 48 C1 EE 20 4C 0F AF F9 48 89 F3 4D 0F AF DD 49 0F AF DD 4C 89 FD 4C 89 FF 45 89 DC 48 C1 ED 20 49 C1 EB 20 4C 01 E5 49 89 F4 49 01 DB 4C 0F AF E1 89 FF 4C 01 E5 48 89 EB 48 C1 E5 20 48 C1 EB 20 48 01 EF 49 01 DB 4C 89 D3 45 89 D2 4D 89 D4 4D 89 D6 48 C1 EB 20 4D 0F AF E5 4C 0F AF F1 48 0F AF CB 45 89 E7 49 C1 EC 20 49 C1 EE 20 4C 0F AF EB 4D 01 FE 4C 01 F1 48 C1 E9 20 4D 01 E5 4C 01 E9 48 01 F9 49 83 D3 00 48 C1 E8 20 48 89 C5 49 89 C4 49 0F AF E9 4C 0F AF CA 4C 0F AF E6 41 89 ED 48 C1 ED 20 4C 89 CF 49 C1 E9 20 48 0F AF F2 4C 01 E5 49 01 F1 4D 01 E9 4C 89 CE 48 C1 EE 20 48 01 EE 48 89 C5 49 0F AF EA 4C 0F AF D2 48 0F AF C3 41 89 EC 48 C1 ED 20 4D 89 D5 45 89 D2 48 0F AF DA 49 C1 ED 20 48 01 E8 4C 01 EB 4C 01 E3 48 89 DA 48 C1 E3 20 48 C1 EA 20 48 01 C2 4A 8D 04 13 4D 89 CA 49 C1 E2 20 41 89 F9 4D 01 D1 4C 01 CA 48 83 D6 00 45 31 C9 48 01 C1 41 0F 92 C1 49 8D 0C 11 49 01 CB 0F 92 C0 49 39 C9 0F 97 C2 09 C2 83 7C 24 0C 16 0F B6 D2 48 8D 04 16 0F 8F B3 00 00 00 48 8B 15 ?? ?? ?? ?? 46 8B 04 82 BA 40 00 00 00 44 29 C2 89 D1 48 D3 E0 44 89 C1 49 D3 EB 4C 09 D8 E9 AB FC FF FF 41 83 FA 14 0F 84 99 00 00 00 41 83 FA 15 0F 84 9D 00 00 00 41 8D 4A EB 4C 8B 15 ?? ?? ?? ?? 48 63 C9 49 8B 0C CA 48 8D 0C 89 48 01 C9 48 39 C8 0F 82 44 FD FF FF E9 5C FC FF FF 48 8B 3D ?? ?? ?? ?? 4D 89 CF 4C 89 CB 48 C1 EB 20 44 89 C9 4C 8B 17 4C 0F AF 7F 08 4C 89 D6 45 89 D2 48 C1 EE 20 4D 89 D3 4C 0F AF DB 4C 0F AF D1 48 0F AF DE 44 89 DD 49 C1 EB 20 49 C1 EA 20 4C 01 FB 49 01 EA 49 01 DB 48 0F AF CE E9 F0 FB FF FF 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 83 E9 40 48 D3 E8 E9 08 FC FF FF 48 85 C0 0F 85 EB FB FF FF E9 C9 FC FF FF 48 83 F8 09 0F 87 DC FB FF FF E9 BA FC FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_92_7_0 {
	meta:
		name = "__bid128_to_uint64_xint"
		size = 1520
		refs = "00a1 .refptr.__bid_ten2k64 00f3 .refptr.__bid_IDEC_glbflags 013e .refptr.__bid_nr_digits 02eb .refptr.__bid_ten2mk128 0462 .refptr.__bid_maskhigh128 046d .refptr.__bid_shiftright128 049d .refptr.__bid_ten2mk128trunc 0509 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 48 8B 51 08 48 B8 00 00 00 00 00 00 00 78 4C 8B 09 48 89 D1 48 21 C1 48 39 C1 0F 84 C0 00 00 00 48 B8 FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 48 21 D0 48 39 C8 77 19 0F 85 C3 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 0F 86 B0 00 00 00 31 C0 E9 98 00 00 00 0F 1F 40 00 4D 85 DB 75 7B 41 83 FA 01 0F 84 87 04 00 00 41 83 FA 13 0F 8F 42 04 00 00 BB 15 00 00 00 4D 89 CB 44 89 C9 44 29 D3 49 C1 EB 20 4C 63 D3 48 8B 1D ?? ?? ?? ?? 4E 8B 14 D3 4C 89 D3 45 89 D2 4C 89 D6 48 C1 EB 20 49 0F AF F3 4C 0F AF D1 48 0F AF CB 89 F7 48 C1 EE 20 49 C1 EA 20 4C 0F AF DB 49 01 FA 4C 01 D1 48 C1 E9 20 49 01 F3 4C 01 D9 48 83 F9 09 0F 86 E9 00 00 00 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 B9 00 00 00 00 00 00 00 60 49 89 D0 49 21 C8 49 39 C8 0F 84 37 FF FF FF 48 85 C0 0F 84 C9 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C0 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C1 48 C1 E1 05 4C 01 D9 44 8B 11 45 85 D2 75 20 44 8B 51 18 48 8B 49 08 48 39 C8 0F 87 FF 00 00 00 48 39 C8 0F 84 E6 00 00 00 66 0F 1F 44 00 00 4C 8D 04 12 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 0C 02 83 F9 14 0F 8F 44 FF FF FF 49 BB 00 00 00 00 00 00 00 80 49 21 D3 83 F9 14 0F 84 AE FE FF FF 85 C9 0F 8E E8 00 00 00 4D 85 DB 0F 85 1D FF FF FF 45 85 C0 0F 88 E7 00 00 00 4C 89 C8 0F 84 1F FF FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 0B FF FF FF 0F 1F 80 00 00 00 00 4D 85 C9 0F 84 FB FE FF FF 48 B9 FF FF FF FF FF FF 1F 00 49 39 C9 76 78 66 0F EF D2 4D 89 C8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 1D ?? ?? ?? ?? 4C 89 C1 48 C1 E1 05 4C 01 D9 44 8B 11 45 85 D2 0F 85 30 FF FF FF 44 8B 51 18 48 8B 49 08 E9 14 FF FF FF 0F 1F 00 49 C1 E0 05 4F 39 4C 03 10 0F 87 11 FF FF FF 90 41 83 C2 01 E9 07 FF FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A C9 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 EB 8D 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 41 FE FF FF 44 89 C7 41 F7 D0 44 89 C9 4D 63 C0 F7 DF 4D 89 CD 4D 89 C7 89 7C 24 14 49 C1 ED 20 49 C1 E7 04 89 D2 4C 89 FB 48 03 1D ?? ?? ?? ?? 4C 8B 53 08 4D 89 D3 45 89 D2 4C 89 D7 4D 89 D1 49 C1 EB 20 48 0F AF F9 4C 89 DE 4D 0F AF CD 49 0F AF F5 48 89 FD 89 FF 45 89 CC 48 C1 ED 20 49 C1 E9 20 4C 01 E5 4D 89 DC 49 01 F1 4C 0F AF E1 4C 01 E5 48 89 EE 48 C1 E5 20 48 C1 EE 20 48 01 EF 4C 01 CE 4C 8B 0B 48 89 74 24 08 4C 89 CB 45 89 C9 48 C1 EB 20 4D 89 CC 4D 0F AF E5 4C 0F AF EB 45 89 E6 49 C1 EC 20 4C 89 6C 24 18 4D 89 CD 4C 03 64 24 18 4C 0F AF E9 48 0F AF CB 4C 89 EE 48 C1 EE 20 49 01 F6 4C 01 F1 49 89 CE 48 C1 E1 20 49 C1 EE 20 4D 01 E6 45 89 EC 49 01 CC 4C 01 F7 48 83 54 24 08 00 48 C1 E8 20 48 8B 74 24 08 48 89 C5 49 89 C5 49 0F AF EA 4C 0F AF D2 4D 0F AF EB 89 E9 48 C1 ED 20 4D 89 D6 45 89 D2 4C 0F AF DA 49 C1 EE 20 4C 01 ED 4D 01 F3 4C 01 D9 49 89 CB 48 C1 E1 20 49 C1 EB 20 49 01 EB 48 89 C5 49 0F AF E9 4C 0F AF CA 48 0F AF D3 41 89 ED 48 C1 ED 20 4D 89 CE 45 89 C9 48 0F AF C3 49 C1 EE 20 49 01 D6 4D 01 F5 4C 89 EA 49 C1 E5 20 48 01 E8 48 C1 EA 20 4D 01 E9 48 01 C2 4A 8D 04 11 48 01 D0 49 83 D3 00 31 D2 4C 01 CF 0F 92 C2 48 01 D0 48 01 C6 0F 92 C1 48 39 C2 0F 97 C0 09 C8 0F B6 C0 49 01 C3 83 7C 24 14 16 0F 8F 0E 01 00 00 48 8B 05 ?? ?? ?? ?? 4E 8B 0C C0 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 89 F0 49 D3 E3 89 D1 48 D3 E8 49 09 C3 83 7C 24 14 03 0F 8F 4B 01 00 00 4C 89 FA 48 03 15 ?? ?? ?? ?? 48 3B 7A 08 77 12 4C 89 D8 0F 85 54 FC FF FF 4C 3B 22 0F 86 4B FC FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 4C 89 D8 E9 39 FC FF FF 41 83 FA 14 0F 84 F0 00 00 00 41 83 FA 15 0F 84 F4 00 00 00 41 8D 4A EB 4C 8B 15 ?? ?? ?? ?? 48 63 C9 49 8B 0C CA 48 8D 0C 89 48 01 C9 48 39 C8 0F 82 D2 FC FF FF E9 EA FB FF FF 48 8B 2D ?? ?? ?? ?? 4C 89 CE 45 89 CA 48 C1 EE 20 4C 8B 5D 00 4C 89 DF 45 89 DB 4C 89 DB 48 C1 EF 20 48 0F AF DE 4D 0F AF DA 48 0F AF F7 89 D9 48 C1 EB 20 49 C1 EB 20 49 01 CB 4C 89 C9 48 0F AF 4D 08 4C 0F AF D7 48 01 F1 48 01 CB 4B 8D 0C 13 48 C1 E9 20 48 01 D9 48 83 F9 09 0F 87 88 FB FF FF E9 66 FC FF FF 48 8B 05 ?? ?? ?? ?? 4C 89 DA 42 8B 0C 80 48 8B 05 ?? ?? ?? ?? 4E 23 1C C0 83 E9 40 48 D3 EA 49 09 F3 75 22 4C 89 F9 48 03 0D ?? ?? ?? ?? 48 3B 79 08 77 12 48 89 D0 0F 85 5A FB FF FF 4C 3B 21 0F 86 51 FB FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 48 89 D0 E9 3F FB FF FF 48 85 C0 0F 85 22 FB FF FF E9 00 FC FF FF 48 83 F8 09 0F 87 13 FB FF FF E9 F1 FB FF FF 4C 85 CE 0F 85 CE FE FF FF E9 A7 FE FF FF }
	condition:
		$1
}

rule file_92_8_0 {
	meta:
		name = "__bid128_to_uint64_rninta"
		size = 1776
		refs = "009e .refptr.__bid_ten2k64 0113 .refptr.__bid_IDEC_glbflags 015a .refptr.__bid_nr_digits 01f3 .refptr.__bid_midpoint64 031f .refptr.__bid_midpoint128 0403 .refptr.__bid_ten2k128 04c9 .refptr.__bid_ten2mk128 062d .refptr.__bid_shiftright128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 4C 8B 01 48 8B 49 08 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 E4 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B9 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 CA 77 19 0F 85 E1 00 00 00 49 B9 FF FF FF FF 63 8E 8D 37 4D 39 C8 0F 86 CE 00 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 85 C9 0F 85 97 00 00 00 41 83 FA 01 0F 84 7D 03 00 00 41 83 FA 13 0F 8F B4 02 00 00 B9 15 00 00 00 44 89 C0 4D 89 C3 44 29 D1 4C 8B 15 ?? ?? ?? ?? 49 C1 EB 20 48 63 C9 4C 89 DE 49 8B 0C CA 48 89 CB 89 C9 49 89 CA 48 C1 EB 20 48 0F AF C8 4D 0F AF D3 48 0F AF C3 49 89 CB 44 89 D7 49 C1 EB 20 49 C1 EA 20 48 0F AF F3 49 01 FB 4C 01 D8 49 89 C3 49 C1 EB 20 49 01 F2 4D 01 DA 49 83 FA 09 77 1D 0F 85 F0 01 00 00 48 C1 E0 20 89 C9 48 01 C8 48 83 F8 FA 0F 86 DD 01 00 00 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 B8 00 00 00 00 00 00 00 60 49 89 C9 49 21 C1 49 39 C1 0F 84 D6 00 00 00 48 85 D2 0F 84 DD 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 49 89 C1 49 C1 E1 05 4D 01 D9 45 8B 11 45 85 D2 75 1A 45 8B 51 18 4D 8B 49 08 4C 39 CA 0F 87 17 01 00 00 4C 39 CA 0F 84 FE 00 00 00 4C 8D 0C 09 49 C1 E9 32 41 81 E9 20 18 00 00 43 8D 04 0A 83 F8 14 0F 8F 52 FF FF FF 49 BB 00 00 00 00 00 00 00 80 4C 21 D9 83 F8 14 0F 84 9C FE FF FF 85 C0 78 48 0F 85 02 01 00 00 41 8D 42 FF 83 F8 12 0F 8F 24 01 00 00 48 85 D2 75 16 4C 8B 0D ?? ?? ?? ?? 48 63 D0 31 C0 4D 39 04 D1 0F 87 5D FE FF FF 48 85 C9 B8 01 00 00 00 0F 85 FC FE FF FF E9 4A FE FF FF 0F 1F 80 00 00 00 00 31 C0 E9 3C FE FF FF 66 0F 1F 84 00 00 00 00 00 31 C0 4D 85 C0 0F 84 28 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C0 76 76 66 0F EF D2 4C 89 C0 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 83 E8 01 4C 8B 1D ?? ?? ?? ?? 49 89 C1 49 C1 E1 05 4D 01 D9 45 8B 11 45 85 D2 0F 85 15 FF FF FF 45 8B 51 18 4D 8B 49 08 E9 FF FE FF FF 66 0F 1F 44 00 00 48 C1 E0 05 4D 39 44 03 10 0F 87 F3 FE FF FF 90 41 83 C2 01 E9 E9 FE FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A C8 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 EB 8F 66 90 48 85 C9 0F 85 27 FE FF FF 45 85 C9 0F 88 9E 01 00 00 4C 89 C0 0F 84 68 FD FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C9 4A 0F AF 04 CA E9 54 FD FF FF 45 8D 4A EC 31 C0 4D 63 C9 49 C1 E1 04 4C 03 0D ?? ?? ?? ?? 49 3B 51 08 0F 82 36 FD FF FF 0F 85 D3 FE FF FF 4D 39 01 0F 87 27 FD FF FF E9 C5 FE FF FF 41 83 FA 14 0F 84 05 03 00 00 41 83 FA 15 0F 84 6D 03 00 00 41 8D 42 EB 48 8B 0D ?? ?? ?? ?? 48 98 4C 8B 14 C1 4D 89 D3 44 89 D7 4F 8D 14 D2 49 C1 EB 20 48 89 FB 4C 89 D9 4A 8D 04 9D 00 00 00 00 48 C1 E3 20 48 C1 E1 20 49 89 DF 48 29 FB 48 89 CE 4C 29 D9 48 29 C6 4C 01 D1 48 89 F0 48 8D 34 BD 00 00 00 00 4C 29 D8 49 29 F7 41 89 C4 48 C1 E8 20 4C 89 FE 48 01 C8 48 29 FE 48 89 F5 48 C1 ED 20 4C 01 E5 48 01 EB 48 89 D9 48 C1 E9 20 48 01 C8 48 39 C2 0F 87 33 FD FF FF 48 C1 E3 20 89 F6 48 89 D9 48 01 F1 4C 39 C1 0F 87 F7 FE FF FF 48 39 C2 0F 84 15 FD FF FF E9 E9 FE FF FF 48 8B 35 ?? ?? ?? ?? 44 89 C1 4D 89 C3 49 C1 EB 20 4C 8B 16 4C 89 D7 45 89 D2 4C 89 D0 48 C1 EF 20 4C 0F AF D1 49 0F AF C3 48 0F AF CF 4C 89 D3 89 C5 48 C1 EB 20 48 C1 E8 20 48 01 EB 48 01 D9 4C 89 C3 48 0F AF 5E 08 4C 0F AF DF 49 01 DB 4C 01 D8 49 89 CB 49 C1 EB 20 4C 01 D8 48 83 F8 09 0F 87 AA FC FF FF 0F 85 7D FE FF FF 48 89 C8 45 89 D2 48 C1 E0 20 4C 01 D0 48 83 F8 FA 0F 87 8D FC FF FF E9 61 FE FF FF 0F 1F 84 00 00 00 00 00 44 89 C9 F7 D9 83 F9 13 0F 8F F8 01 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D1 4C 89 C7 4D 63 C9 4A 03 3C C8 48 89 F8 4C 39 C0 4C 89 CE 49 89 C4 48 83 D2 00 48 C1 E6 04 48 03 35 ?? ?? ?? ?? 89 C0 49 C1 EC 20 48 89 C3 4D 89 E3 4C 89 E7 4D 89 E6 4D 89 E7 49 89 C4 4C 8B 46 08 48 8B 36 4D 89 C2 45 89 C0 49 0F AF D8 49 C1 EA 20 4D 0F AF D8 49 0F AF FA 48 89 DD 89 DB 45 89 DD 48 C1 ED 20 49 C1 EB 20 4C 01 ED 49 89 C5 49 01 FB 4D 0F AF EA 4C 01 ED 48 89 EF 48 C1 E5 20 48 C1 EF 20 48 01 EB 48 89 D5 49 01 FB 48 89 F7 89 F6 4C 0F AF F6 48 C1 EF 20 89 D2 4C 0F AF E6 48 0F AF C7 45 89 F5 49 C1 EE 20 49 C1 EC 20 4C 0F AF FF 4D 01 E5 4D 89 F4 4C 01 E8 48 C1 E8 20 4D 01 FC 4C 01 E0 48 01 D8 49 83 D3 00 48 C1 ED 20 48 89 EB 49 89 EC 49 0F AF D8 4C 0F AF C2 4D 0F AF E2 41 89 DE 48 C1 EB 20 4D 89 C5 4C 0F AF D2 49 C1 ED 20 4C 01 E3 4D 01 F5 4D 01 EA 4D 89 D4 49 C1 EC 20 4C 01 E3 49 89 EC 4C 0F AF E6 48 0F AF F2 48 0F AF D7 45 89 E6 49 C1 EC 20 49 89 F5 89 F6 49 C1 ED 20 4D 01 F5 48 0F AF EF 4C 01 EA 48 89 D7 48 C1 E2 20 48 01 D6 4C 89 D2 45 89 C2 48 C1 E2 20 48 C1 EF 20 4E 8D 04 12 4C 01 E5 48 01 EF 49 01 F8 48 83 D3 00 45 31 D2 48 01 C6 41 0F 92 C2 4B 8D 14 02 49 01 D3 0F 92 C0 49 39 D2 0F 97 C2 09 D0 0F B6 C0 48 01 D8 83 F9 16 7F 56 48 8B 15 ?? ?? ?? ?? 46 8B 04 8A BA 40 00 00 00 89 D1 44 29 C1 48 D3 E0 44 89 C1 49 D3 EB 4C 09 D8 E9 13 FA FF FF 4B 8D 0C 00 48 8D 04 12 4C 39 C1 48 83 D0 00 48 83 F8 01 0F 87 A7 FA FF FF A8 01 0F 84 78 FC FF FF 48 83 C1 01 0F 84 95 FA FF FF E9 69 FC FF FF 48 8B 15 ?? ?? ?? ?? 42 8B 0C 8A 83 E9 40 48 D3 E8 E9 CD F9 FF FF 41 BA EC FF FF FF 4C 89 C0 45 29 CA 41 F7 D1 4D 63 D2 4D 63 C9 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 49 03 02 49 03 52 08 E9 F3 FD FF FF 48 83 FA 09 0F 87 44 FA FF FF 0F 85 17 FC FF FF 49 83 F8 FA 0F 87 34 FA FF FF E9 08 FC FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_92_9_0 {
	meta:
		name = "__bid128_to_uint64_xrninta"
		size = 2144
		refs = "00a1 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 0169 .refptr.__bid_nr_digits 02f2 .refptr.__bid_midpoint64 0339 .refptr.__bid_midpoint128 0413 .refptr.__bid_ten2k128 04dd .refptr.__bid_ten2mk128 0651 .refptr.__bid_maskhigh128 0662 .refptr.__bid_shiftright128 06a9 .refptr.__bid_ten2mk128trunc 075f .refptr.__bid_onehalf128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 01 48 8B 49 08 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B9 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 CA 77 22 0F 85 EC 00 00 00 49 B9 FF FF FF FF 63 8E 8D 37 4D 39 C8 0F 86 D9 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 85 C9 0F 85 96 00 00 00 41 83 FB 01 0F 84 7C 03 00 00 41 83 FB 13 0F 8F B0 02 00 00 4C 8B 0D ?? ?? ?? ?? B9 15 00 00 00 44 89 C0 44 29 D9 4C 89 C6 48 63 C9 48 C1 EE 20 49 8B 0C C9 48 89 CB 89 C9 49 89 C9 48 C1 EB 20 48 0F AF C8 4C 0F AF CE 48 0F AF C3 49 89 CB 44 89 CF 49 C1 EB 20 49 C1 E9 20 48 0F AF F3 49 01 FB 4C 01 D8 49 89 C3 49 C1 EB 20 49 01 F1 4D 01 D9 49 83 F9 09 77 1F 48 C1 E0 20 89 C9 48 01 C8 48 83 F8 FA 0F 86 E6 00 00 00 49 83 F9 09 0F 85 DC 00 00 00 66 90 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C9 49 21 C1 49 39 C1 0F 84 37 01 00 00 48 85 D2 0F 84 BE 00 00 00 66 0F EF C0 4C 8B 15 ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 49 89 C1 49 C1 E1 05 4D 01 D1 45 8B 19 45 85 DB 75 1A 45 8B 59 18 4D 8B 49 08 4C 39 CA 0F 87 08 01 00 00 4C 39 CA 0F 84 E6 00 00 00 4C 8D 14 09 49 C1 EA 32 41 81 EA 20 18 00 00 43 8D 04 13 83 F8 14 0F 8F 53 FF FF FF 49 B9 00 00 00 00 00 00 00 80 4C 21 C9 83 F8 14 0F 84 9E FE FF FF 85 C0 0F 88 30 01 00 00 0F 84 F0 00 00 00 48 85 C9 0F 85 26 FF FF FF 45 85 D2 0F 88 9D 02 00 00 4C 89 C0 0F 84 64 FE FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 D2 4A 0F AF 04 D2 E9 50 FE FF FF 31 C0 4D 85 C0 0F 84 45 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C0 0F 86 82 00 00 00 66 0F EF D2 4C 89 C0 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 83 E8 01 4C 8B 15 ?? ?? ?? ?? 49 89 C1 49 C1 E1 05 4D 01 D1 45 8B 19 45 85 DB 0F 85 30 FF FF FF 45 8B 59 18 4D 8B 49 08 E9 1A FF FF FF 66 90 31 C0 E9 D9 FD FF FF 48 C1 E0 05 4D 39 44 02 10 0F 87 0B FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 C3 01 E9 F8 FE FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A C8 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 E9 80 FF FF FF 41 8D 43 FF 83 F8 12 7F 42 48 85 D2 75 0F 48 8B 15 ?? ?? ?? ?? 48 98 4C 39 04 C2 77 4C 48 85 C9 B8 01 00 00 00 0F 85 14 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 55 FD FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 44 FD FF FF 41 8D 43 EC 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 3B 50 08 72 07 75 B9 4C 39 00 76 B4 31 C0 EB BE 41 83 FB 14 0F 84 8F 03 00 00 41 83 FB 15 0F 84 21 04 00 00 41 8D 43 EB 48 8B 0D ?? ?? ?? ?? 48 98 4C 8B 0C C1 4D 89 CB 44 89 CF 4F 8D 0C C9 49 C1 EB 20 48 89 FB 4C 89 D9 4A 8D 04 9D 00 00 00 00 48 C1 E3 20 48 C1 E1 20 49 89 DF 48 29 FB 48 89 CE 4C 29 D9 48 29 C6 4C 01 C9 48 89 F0 48 8D 34 BD 00 00 00 00 4C 29 D8 49 29 F7 41 89 C4 48 C1 E8 20 4C 89 FE 48 01 C8 48 29 FE 48 89 F5 48 C1 ED 20 4C 01 E5 48 01 EB 48 89 D9 48 C1 E9 20 48 01 C8 48 39 C2 0F 87 36 FD FF FF 48 C1 E3 20 89 F6 48 89 D9 48 01 F1 4C 39 C1 0F 87 FB FD FF FF 48 39 C2 0F 84 18 FD FF FF E9 ED FD FF FF 0F 1F 00 48 8B 35 ?? ?? ?? ?? 44 89 C1 4D 89 C3 49 C1 EB 20 4C 8B 0E 4C 89 CF 45 89 C9 4C 89 C8 48 C1 EF 20 4C 0F AF C9 49 0F AF C3 48 0F AF CF 4C 89 CB 89 C5 48 C1 EB 20 48 C1 E8 20 48 01 EB 48 01 D9 4C 89 C3 48 0F AF 5E 08 4C 0F AF DF 49 01 DB 4C 01 D8 49 89 CB 49 C1 EB 20 4C 01 D8 48 83 F8 09 0F 87 AA FC FF FF 48 C1 E1 20 45 89 C9 4C 01 C9 48 83 F9 FA 0F 86 70 FD FF FF 48 83 F8 09 0F 84 8C FC FF FF E9 61 FD FF FF 0F 1F 80 00 00 00 00 44 89 D7 F7 DF 83 FF 13 0F 8F 72 02 00 00 44 89 D0 48 8B 0D ?? ?? ?? ?? 4D 89 C1 F7 D0 48 98 4C 03 0C C1 4D 39 C1 48 89 C3 4D 89 CD 48 83 D2 00 48 C1 E3 04 45 89 C9 49 89 DB 4C 03 1D ?? ?? ?? ?? 49 C1 ED 20 4C 89 CD 4C 89 E9 48 89 5C 24 08 4C 89 EB 4D 89 CE 4D 8B 43 08 4D 89 C2 45 89 C0 49 0F AF E8 49 C1 EA 20 49 0F AF C8 49 0F AF DA 48 89 EE 89 ED 41 89 CC 48 C1 EE 20 48 C1 E9 20 4C 01 E6 4D 89 CC 48 01 D9 4D 0F AF E2 49 01 F4 4C 89 EE 4C 89 E3 49 C1 E4 20 48 C1 EB 20 49 01 EC 48 89 D5 48 01 CB 49 8B 0B 89 D2 49 89 CB 89 C9 49 C1 EB 20 48 0F AF F1 4C 0F AF F1 4D 0F AF EB 41 89 F7 48 C1 EE 20 4D 0F AF CB 4C 89 2C 24 4D 89 F5 49 C1 EE 20 48 03 34 24 45 89 ED 4D 01 FE 4D 01 F1 4D 89 CF 49 C1 E1 20 49 C1 EF 20 49 01 F7 4B 8D 34 29 4D 01 FC 48 83 D3 00 48 C1 ED 20 49 89 ED 49 89 EE 4D 0F AF E8 4C 0F AF C2 4D 0F AF F2 45 89 EF 49 C1 ED 20 4D 89 C1 45 89 C0 4C 0F AF D2 49 C1 E9 20 4D 01 F5 4D 01 F9 4D 01 D1 4D 89 CA 49 C1 EA 20 4D 01 EA 49 89 ED 4C 0F AF E9 48 0F AF CA 49 0F AF D3 45 89 EF 49 C1 ED 20 49 89 CE 89 C9 49 0F AF EB 49 C1 EE 20 4D 01 FE 49 01 D6 4C 89 F2 49 C1 E6 20 48 C1 EA 20 4C 01 ED 4C 01 F1 48 01 D5 4C 89 CA 48 C1 E2 20 4C 01 C2 48 01 EA 49 83 D2 00 49 01 CC 0F 92 C1 0F B6 C9 48 01 CA 48 01 D3 41 0F 92 C0 48 39 D1 0F 97 C2 44 09 C2 0F B6 D2 49 01 D2 83 FF 16 48 8B 15 ?? ?? ?? ?? 0F 8F F0 00 00 00 4C 8B 04 C2 48 8B 15 ?? ?? ?? ?? 44 8B 0C 82 BA 40 00 00 00 89 D1 48 89 DA 44 29 C9 49 D3 E2 44 89 C9 48 D3 EA 4C 09 D2 83 FF 03 0F 8F 56 01 00 00 48 B9 00 00 00 00 00 00 00 80 49 39 CC 77 07 75 38 48 85 F6 74 33 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 B9 00 00 00 00 00 00 00 80 49 01 CC 4C 3B 60 08 49 89 C0 77 12 48 89 D0 0F 85 A4 F9 FF FF 49 3B 30 0F 82 9B F9 FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 48 89 D0 E9 89 F9 FF FF 4B 8D 0C 00 48 8D 04 12 4C 39 C1 48 83 D0 00 48 83 F8 01 0F 87 20 FA FF FF A8 01 0F 84 F2 FA FF FF 48 83 C1 01 0F 84 0E FA FF FF E9 E3 FA FF FF 66 0F 1F 84 00 00 00 00 00 B8 EC FF FF FF 4D 89 C1 44 29 D0 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 08 48 03 50 08 44 89 D0 F7 D0 48 98 E9 78 FD FF FF 4D 89 D0 4C 23 04 C2 48 8B 15 ?? ?? ?? ?? 8B 0C 82 48 8B 15 ?? ?? ?? ?? 83 E9 40 49 D3 EA 4C 3B 04 C2 77 02 74 31 48 8B 05 ?? ?? ?? ?? 83 08 20 4C 89 D0 E9 ED F8 FF FF 48 83 FA 09 0F 87 93 F9 FF FF 0F 85 67 FA FF FF 49 83 F8 FA 0F 87 83 F9 FF FF E9 58 FA FF FF 48 85 DB 0F 95 C0 4D 85 E4 0F 95 C1 48 85 F6 0F 95 C2 08 D1 74 B9 84 C0 75 B5 48 8B 54 24 08 48 03 15 ?? ?? ?? ?? 4C 3B 62 08 77 A3 4C 89 D0 0F 85 99 F8 FF FF 48 3B 32 0F 86 90 F8 FF FF EB 8F 4C 21 C3 4C 8B 05 ?? ?? ?? ?? 48 89 D9 4D 8B 04 C0 4C 39 C3 77 41 0F 85 D7 FE FF FF 4C 89 E7 48 09 F7 0F 84 CB FE FF FF 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 3B 60 08 48 89 C1 0F 87 B3 FE FF FF 48 89 D0 0F 85 45 F8 FF FF 48 3B 31 0F 86 3C F8 FF FF E9 9C FE FF FF 48 89 CF 4C 29 C7 48 39 F9 49 89 F8 48 19 C9 49 09 C8 0F 85 84 FE FF FF EB B7 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__bid_extendsdtf"
		size = 48
		refs = "000e __bid32_to_binary128"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 66 0F 6F 44 24 20 48 89 D8 0F 29 03 48 83 C4 30 5B C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__bid_extendddtf"
		size = 48
		refs = "000e __bid64_to_binary128"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? 66 0F 6F 44 24 20 48 89 D8 0F 29 03 48 83 C4 30 5B C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__trunctfxf2"
		size = 1280
		refs = "040f __sfp_handle_exceptions"
	strings:
		$1 = { 55 57 56 53 48 83 EC 68 66 0F 6F 02 48 89 C8 C7 44 24 4C 00 00 00 00 0F 29 44 24 20 0F AE 5C 24 4C 49 B9 FF FF FF FF FF FF 00 00 48 8B 54 24 28 48 8B 6C 24 20 49 89 D0 49 21 D1 49 89 EA 49 C1 E8 30 49 C1 E1 03 49 C1 EA 3D 4C 89 C3 4C 89 CF 48 C1 EA 3F 81 E3 FF 7F 00 00 4C 09 D7 49 89 D3 48 8D 4B 01 0F B6 F2 4C 8D 14 ED 00 00 00 00 81 E1 FF 7F 00 00 48 83 F9 01 0F 8E 31 02 00 00 48 81 FB FF 7F 00 00 0F 84 14 01 00 00 48 85 DB 0F 84 0E 04 00 00 48 89 EA 49 89 F9 31 C9 48 C1 E2 12 49 C1 E1 0F 48 85 D2 0F 95 C1 49 C1 EA 31 48 C1 EF 31 4C 09 C9 4C 09 D1 49 89 FA 49 89 C9 31 C9 41 F6 C1 07 0F 84 35 01 00 00 8B 54 24 4C 83 C9 20 81 E2 00 60 00 00 81 FA 00 20 00 00 0F 84 17 03 00 00 81 FA 00 40 00 00 0F 84 A5 02 00 00 85 D2 0F 85 08 01 00 00 4C 89 CA 83 E2 0F 48 83 FA 04 74 08 49 83 C1 04 49 83 D2 00 48 85 DB 0F 85 EB 00 00 00 4C 89 D2 4C 89 D6 83 E2 04 4C 09 CE 74 03 83 C9 10 48 85 D2 0F 85 23 01 00 00 49 C1 E9 03 49 C1 E2 3D 48 BA FF FF FF FF FF FF FF 7F 4D 09 D1 45 31 C0 49 21 D1 66 0F 1F 44 00 00 4C 89 4C 24 50 44 0F B7 4C 24 58 66 41 81 E1 00 80 44 89 CA 44 09 C2 45 89 D8 66 89 54 24 58 66 C1 EA 08 41 C1 E0 07 83 E2 7F 44 09 C2 85 C9 88 54 24 59 DB 6C 24 50 0F 85 78 02 00 00 DB 38 48 83 C4 68 5B 5E 5F 5D C3 0F 1F 84 00 00 00 00 00 8B 54 24 4C 81 E2 00 60 00 00 0F 85 B0 01 00 00 B9 28 00 00 00 41 B8 FF 7F 00 00 31 D2 45 31 D2 49 09 D2 49 B9 00 00 00 00 00 00 00 80 74 81 49 B9 00 00 00 00 00 00 00 C0 49 09 D1 E9 6F FF FF FF 48 85 F6 75 CA 49 C7 C2 FF FF FF FF BB FE 7F 00 00 B9 28 00 00 00 4D 89 D1 66 0F 1F 44 00 00 41 F6 C2 04 74 7A 4C 8D 43 01 49 81 F8 FF 7F 00 00 75 45 8B 54 24 4C 81 E2 00 60 00 00 0F 84 20 02 00 00 81 FA 00 40 00 00 0F 84 01 02 00 00 45 84 DB 74 0C 81 FA 00 20 00 00 0F 84 03 02 00 00 41 B8 FE 7F 00 00 49 C7 C1 FF FF FF FF 83 C9 28 EB 1B 41 B8 01 00 00 00 49 83 E2 FB 49 C1 E9 03 66 41 81 E0 FF 7F 49 C1 E2 3D 4D 09 D1 49 BA 00 00 00 00 00 00 00 80 4D 09 D1 E9 D1 FE FF FF 90 4C 89 D2 49 C1 E9 03 41 89 D8 48 C1 E2 3D 49 C1 EA 03 66 41 81 E0 FF 7F 49 09 D1 48 81 FB FF 7F 00 00 75 C9 4C 89 CA E9 14 FF FF FF 0F 1F 40 00 48 85 DB 0F 85 F7 00 00 00 48 89 FB 4C 09 D3 0F 84 9B 01 00 00 48 89 EA 49 89 F9 B9 02 00 00 00 48 C1 E2 12 49 C1 E1 0F 48 85 D2 0F 95 C2 49 C1 EA 31 48 C1 EF 31 0F B6 D2 4C 09 CA 4D 89 D1 49 89 FA 49 09 D1 41 F6 C1 07 0F 84 E1 01 00 00 44 8B 44 24 4C 31 DB 83 C9 20 44 89 C2 81 E2 00 60 00 00 81 FA 00 20 00 00 0F 84 DD 00 00 00 81 FA 00 40 00 00 74 6F 85 D2 0F 84 CA FD FF FF 4C 89 D2 4C 89 D6 83 E2 04 4C 09 CE 0F 84 E6 FD FF FF F6 C1 20 0F 85 DA FD FF FF 41 81 E0 00 08 00 00 0F 84 D0 FD FF FF E9 C8 FD FF FF 0F 1F 44 00 00 81 FA 00 40 00 00 0F 84 04 01 00 00 81 FA 00 20 00 00 0F 84 69 FE FF FF 81 FA 00 40 00 00 0F 85 62 FE FF FF 49 83 C9 FF B9 28 00 00 00 BB FE 7F 00 00 4D 89 CA 48 85 F6 0F 85 6E FD FF FF 49 83 C1 08 49 83 D2 00 E9 61 FD FF FF 0F 1F 44 00 00 48 89 F9 4C 09 D1 B9 00 00 00 00 0F 84 F4 FD FF FF 48 81 FB FF 7F 00 00 0F 84 C2 00 00 00 49 89 F8 48 C1 E7 0F 49 C1 EA 31 48 89 FA 49 C1 E8 31 BB FF 7F 00 00 4C 09 D2 4D 89 C2 48 83 E2 F8 49 83 CA 02 49 89 D1 E9 C6 FC FF FF 48 85 F6 75 9E E9 07 FD FF FF DB 7C 24 20 48 89 44 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 38 DB 6C 24 20 DB 38 48 83 C4 68 5B 5E 5F 5D C3 66 0F 1F 84 00 00 00 00 00 48 85 F6 41 B0 FE 49 C7 C1 FF FF FF FF 0F 85 0A FE FF FF 41 B8 FF 7F 00 00 31 D2 45 31 D2 83 C9 28 E9 6A FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 31 C9 45 31 D2 45 31 C9 E9 C2 FC FF FF 0F 1F 00 48 85 F6 B9 28 00 00 00 0F 84 37 FD FF FF 49 C7 C1 FF FF FF FF B3 FE 4D 89 CA E9 71 FD FF FF 90 48 89 F9 48 C1 E9 32 48 83 F1 01 83 E1 01 E9 2B FF FF FF 48 89 EA 49 B9 00 00 00 00 00 00 08 00 48 C1 E2 11 4C 09 CF 45 31 C9 48 85 D2 41 0F 95 C1 49 C1 EA 32 31 C9 4D 09 CA 49 89 F9 48 C1 EF 32 49 C1 E1 0E 4D 09 D1 49 89 FA E9 15 FE FF FF 4C 89 D2 4C 89 D6 44 8B 44 24 4C 83 E2 04 4C 09 CE 0F 85 52 FE FF FF E9 2A FC FF FF 90 90 90 90 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__bid_letd2"
		size = 80
		refs = "0031 __bid128_quiet_less_equal"
	strings:
		$1 = { 48 83 EC 48 48 8B 02 48 8B 52 08 4C 8B 09 4C 8B 51 08 48 8D 4C 24 30 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 4C 89 4C 24 30 4C 89 54 24 38 E8 ?? ?? ?? ?? 83 F8 01 48 19 C0 83 E0 02 48 83 E8 01 48 83 C4 48 C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__bid32_to_bid128"
		size = 416
		refs = "00c8 .refptr.__bid_IDEC_glbflags 00d2 .refptr.__bid_power10_table_128"
	strings:
		$1 = { 53 48 89 C8 89 D1 41 89 D1 81 E1 00 00 00 60 41 81 E1 00 00 00 80 81 F9 00 00 00 60 74 52 41 89 D0 89 D1 41 C1 E8 17 81 E1 FF FF 7F 00 45 0F B6 C0 75 30 41 89 D2 31 C9 41 81 E2 00 00 00 78 41 81 FA 00 00 00 78 74 6A 41 81 C0 BB 17 00 00 49 C1 E1 20 48 89 08 49 C1 E0 31 4D 09 C8 4C 89 40 08 5B C3 89 C9 EB E1 66 0F 1F 84 00 00 00 00 00 89 D1 41 89 D0 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 84 B9 00 00 00 41 81 E0 FF FF 1F 00 41 81 C8 00 00 80 00 41 81 F8 7F 96 98 00 44 89 C1 41 B8 00 00 00 00 49 0F 47 C8 C1 EA 15 44 0F B6 C2 EB 96 45 31 C9 31 DB 81 E2 00 00 00 7E 81 FA 00 00 00 7E 75 0A 48 8B 15 ?? ?? ?? ?? 83 0A 01 48 8B 0D ?? ?? ?? ?? 4C 8B 81 B8 01 00 00 48 8B 89 B0 01 00 00 41 89 CB 48 C1 E9 20 45 89 C2 4C 0F AF DB 49 C1 E8 20 48 0F AF CB 4C 0F AF D3 4C 89 DA 45 89 DB 48 C1 EA 20 48 01 CA 48 89 D1 48 C1 EA 20 4C 0F AF C3 48 C1 E1 20 49 01 CB 4C 89 D1 45 89 D2 48 C1 E9 20 4C 89 18 49 01 C8 49 C1 E0 20 4C 01 C2 4C 01 D2 4C 09 CA 48 89 50 08 5B C3 41 81 E0 FF FF 0F 00 41 89 D1 89 D1 81 E1 FF FF 0F FE 41 81 E1 00 00 00 FE 41 81 F8 40 42 0F 00 41 89 D0 44 0F 42 C9 89 D1 41 81 E0 00 00 00 7C 81 E1 00 00 00 F8 41 81 F8 00 00 00 78 44 0F 44 C9 48 B9 00 00 00 00 00 00 00 FC 44 89 CB 49 C1 E1 20 81 E3 FF FF 0F 00 49 21 C9 E9 17 FF FF FF }
	condition:
		$1
}

rule file_97_1_0 {
	meta:
		name = "__bid128_to_bid32"
		size = 3296
		refs = "0052 .refptr.__bid_power10_table_128 0164 .refptr.__bid_IDEC_glbround 020a .rdata 0224 .refptr.__bid_estimate_decimal_digits 0245 .refptr.__bid_power10_index_binexp_128 02aa .refptr.__bid_round_const_table_128 02e6 .refptr.__bid_reciprocals10_128 0475 .refptr.__bid_recip_scale 05e8 .refptr.__bid_IDEC_glbflags 09b2 .refptr.__bid_round_const_table 09c0 .refptr.__bid_reciprocals10_64 0a1a .refptr.__bid_short_recip_scale"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 4C 8B 41 08 48 8B 39 48 B8 00 00 00 00 00 00 00 78 49 B9 00 00 00 00 00 00 00 80 48 BA FF FF FF FF FF FF FF 5F 4C 89 C1 4D 21 C1 48 89 FB 48 21 C1 48 39 D1 76 7A 48 39 C1 0F 85 E6 05 00 00 48 8B 15 ?? ?? ?? ?? 48 B8 FF FF FF FF FF 3F 00 00 4C 21 C0 48 39 82 18 02 00 00 4C 8B 92 10 02 00 00 0F 83 99 0A 00 00 49 BA 00 00 00 00 00 00 00 FE 31 DB 4D 21 C2 48 B8 00 00 00 00 00 00 00 7C 48 BA 00 00 00 00 00 00 00 78 4C 21 C0 48 39 D0 0F 85 B4 05 00 00 49 BA 00 00 00 00 00 00 00 F8 31 D2 4D 21 C2 E9 8B 05 00 00 66 0F 1F 44 00 00 48 8B 0D ?? ?? ?? ?? 49 BB FF FF FF FF FF FF 01 00 4D 21 C3 4C 3B 99 28 02 00 00 48 8B 81 20 02 00 00 76 4C 4C 89 C2 48 C1 EA 31 81 E2 FF 3F 00 00 31 C9 81 EA BB 17 00 00 78 13 89 D0 B9 00 00 80 5F C1 E0 17 81 FA BF 00 00 00 0F 4E C8 49 C1 E9 20 89 C8 44 09 C8 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 84 00 00 00 00 00 0F 84 3C 07 00 00 4C 89 C2 4C 89 D8 48 C1 EA 31 81 E2 FF 3F 00 00 48 09 F8 74 A6 4D 85 DB 0F 85 A0 00 00 00 48 81 FF 7F 96 98 00 0F 87 99 00 00 00 48 8B 05 ?? ?? ?? ?? 49 C1 E9 20 81 EA BB 17 00 00 8B 30 44 89 C8 81 FA BF 00 00 00 89 D1 76 4F 85 D2 0F 88 FC 07 00 00 48 81 FB 3F 42 0F 00 0F 87 27 07 00 00 81 FA BF 00 00 00 7F 0D E9 1A 07 00 00 81 FA BF 00 00 00 7E 14 48 8D 0C 1B 83 EA 01 48 8D 1C D9 48 81 FB 3F 42 0F 00 76 E4 81 FA BF 00 00 00 B9 BF 00 00 00 0F 85 ED 06 00 00 48 81 FB FF FF 7F 00 0F 86 4A 04 00 00 C1 E1 15 0D 00 00 00 60 81 E3 FF FF 1F 00 09 C8 09 D8 E9 23 FF FF FF 0F 88 56 06 00 00 66 0F EF D2 F3 49 0F 2A D3 48 85 FF F3 0F 59 15 ?? ?? ?? ?? 0F 88 3E 07 00 00 66 0F EF C0 F3 48 0F 2A C7 F3 0F 58 D0 4C 8B 05 ?? ?? ?? ?? 4C 89 DB 66 0F 7E D0 C1 E8 17 0F B6 C0 83 E8 7F 48 98 45 8B 14 80 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 45 8D 42 F9 48 2B 58 08 48 83 FB 00 0F 8E A6 06 00 00 45 8D 42 FA 41 8D 04 10 4D 85 C9 89 44 24 08 48 8B 05 ?? ?? ?? ?? 8B 30 89 74 24 10 74 17 8D 46 FF 83 F8 01 77 0F B8 03 00 00 00 29 F0 89 44 24 10 0F 1F 40 00 81 7C 24 08 BA 17 00 00 0F 8E 74 05 00 00 8B 44 24 08 44 8B 54 24 10 48 8B 1D ?? ?? ?? ?? C7 44 24 54 00 00 00 00 8D 90 45 E8 FF FF 49 63 C0 48 89 C1 4B 8D 04 D2 45 31 D2 49 89 C8 48 89 4C 24 20 48 8D 04 81 48 C1 E0 04 48 01 D8 4C 03 58 08 48 03 38 48 8B 05 ?? ?? ?? ?? 41 0F 92 C2 49 C1 E0 04 48 89 44 24 58 49 01 C0 49 89 FC 4D 01 D3 49 8B 00 4D 8B 40 08 49 C1 EC 20 4D 89 E7 89 F9 4C 89 E3 4D 89 C2 45 89 C0 49 89 C5 49 C1 EA 20 49 C1 ED 20 89 C0 4D 0F AF FA 49 0F AF D8 4C 89 7C 24 28 49 89 CF 4D 0F AF F8 48 89 5C 24 18 8B 7C 24 18 4D 89 FE 4C 89 7C 24 30 49 C1 EE 20 4C 89 F3 48 01 FB 48 89 CF 49 0F AF FA 48 8D 2C 3B 4C 89 EB 4D 89 DD 45 89 DB 49 C1 ED 20 4C 89 DF 4D 89 DE 48 89 6C 24 38 48 0F AF FB 4C 0F AF F0 41 89 FF 4C 89 F5 49 C1 EE 20 4D 01 FE 4D 89 EF 89 ED 4C 0F AF F8 4D 01 FE 4C 89 74 24 40 49 C1 E6 20 4C 01 F5 48 89 6C 24 48 4C 89 E5 48 0F AF E8 48 0F AF C1 48 0F AF CB 41 89 EF 48 C1 ED 20 49 89 C6 89 C0 4C 0F AF E3 49 C1 EE 20 4D 01 FE 49 01 CE 4C 89 F1 49 C1 E6 20 49 01 EC 48 C1 E9 20 49 01 C6 4C 89 E8 4D 8D 3C 0C 4D 89 EC 49 0F AF C0 48 C1 EF 20 4D 0F AF C3 4D 0F AF E2 4C 89 C1 45 89 C0 4D 0F AF D3 4C 89 E5 48 C1 E9 20 41 89 C4 48 C1 E8 20 4C 01 E1 48 01 C5 4C 01 D1 48 89 C8 48 C1 E1 20 4E 8D 14 01 48 8B 4C 24 18 48 C1 E8 20 49 0F AF DD 48 01 E8 48 8B 6C 24 38 48 C1 E9 20 48 03 4C 24 28 48 01 D9 48 89 EB 48 C1 EB 20 48 01 D9 48 8B 5C 24 40 48 01 F9 8B 7C 24 30 48 C1 EB 20 49 89 D8 48 89 EB 48 C1 E3 20 49 01 C8 48 8B 0D ?? ?? ?? ?? 4C 8D 24 3B 4C 03 64 24 48 48 8B 7C 24 20 49 83 D0 00 4D 01 FC 49 83 D0 00 4D 01 D0 44 8B 14 B9 48 83 D0 00 41 83 FA 3F 0F 8E D9 03 00 00 41 8D 4A C0 48 89 C3 48 D3 EB 41 BB 80 00 00 00 45 29 D3 85 F6 75 45 F6 C3 01 74 40 41 83 FB 3F 0F 8E 63 06 00 00 B9 40 00 00 00 4C 89 C7 44 29 D1 48 D3 E7 48 85 FF 0F 85 CA 03 00 00 48 8B 4C 24 20 48 C1 E1 04 48 03 4C 24 58 4C 3B 61 08 72 07 75 09 4C 3B 31 73 04 48 83 EB 01 41 83 FB 3F 0F 8F 93 03 00 00 44 89 D9 4D 89 C5 48 D3 E0 41 8D 4A C0 48 89 C7 49 D3 ED 44 89 D9 49 D3 E0 4C 89 C5 4C 09 EF 8B 44 24 10 83 F8 01 0F 84 9C 05 00 00 0F 82 A1 06 00 00 83 F8 03 0F 84 8D 05 00 00 83 F8 04 0F 84 8F 06 00 00 48 8B 44 24 20 31 C9 48 C1 E0 04 48 03 44 24 58 4C 03 30 0F 92 C1 49 01 CC 4D 89 E7 4C 03 78 08 41 0F 92 C0 4C 39 E1 0F 97 C0 44 09 C0 41 83 FB 3F 0F B6 C0 0F 8F 35 05 00 00 41 8D 4A C0 49 89 F8 49 D3 E0 44 89 D9 48 D3 ED 48 D3 EF 4C 09 C5 41 83 FA 3F 0F 8F F6 04 00 00 41 BB 01 00 00 00 B9 40 00 00 00 44 29 D1 4D 89 D8 49 D3 E8 44 89 D1 49 D3 E3 48 01 C5 48 83 D7 00 49 39 F8 72 25 75 0D 49 39 EB 76 1E 0F 1F 84 00 00 00 00 00 83 7C 24 54 01 48 8B 0D ?? ?? ?? ?? 19 C0 83 E0 F0 83 C0 30 09 01 49 C1 E9 20 48 81 FB 7F 96 98 00 44 89 C8 0F 86 6D FB FF FF 8B 54 24 08 BB 40 42 0F 00 81 EA BA 17 00 00 81 FA BF 00 00 00 89 D1 0F 87 8E 02 00 00 09 C3 C1 E1 17 89 D8 09 C8 E9 E2 FA FF FF 4C 89 C2 45 31 D2 48 C1 EA 2F 81 E2 FF 3F 00 00 48 B8 00 00 00 00 00 00 00 78 31 DB 48 39 C1 0F 85 97 FA FF FF 48 8B 05 ?? ?? ?? ?? 49 89 DD 89 DB 49 C1 ED 20 4D 89 D4 4D 89 EE 49 C1 E4 12 48 8B 90 B8 01 00 00 4C 8B 88 B0 01 00 00 48 89 D8 49 C1 EC 32 4D 89 E3 48 89 D6 89 D2 4C 0F AF F2 48 C1 EE 20 48 0F AF C2 44 89 F1 48 89 44 24 08 48 C1 E8 20 48 01 C8 48 89 D9 48 0F AF CE 48 8D 3C 08 44 89 D1 48 89 CD 49 89 CF 48 89 7C 24 10 4C 89 CF 45 89 C9 48 C1 EF 20 48 0F AF EF 4D 0F AF F9 4D 0F AF D9 4C 89 F8 41 89 EF 4D 01 FB 49 89 C7 89 C0 49 C1 EF 20 4D 01 DF 4D 89 FB 4C 89 7C 24 18 49 C1 E3 20 49 01 C3 4C 89 E8 4C 89 5C 24 20 4D 89 EB 4D 0F AF D9 4C 0F AF CB 48 0F AF DF 45 89 DF 49 C1 EB 20 49 C1 E9 20 4D 01 F9 49 01 D9 4C 89 E3 48 0F AF DA 49 C1 E9 20 48 0F AF D1 48 0F AF C7 49 89 D7 89 D2 48 0F AF CE 4C 01 D8 49 C1 EF 20 4E 8D 1C 08 4D 89 E1 48 89 D8 4C 0F AF CE 89 DB 4C 01 F9 49 C1 EE 20 48 C1 ED 20 48 01 D9 48 C1 E8 20 49 0F AF FC 48 89 CB 48 C1 E1 20 49 0F AF F5 48 01 D1 48 8B 54 24 10 49 01 C1 8B 44 24 08 48 C1 EB 20 49 01 D9 49 01 FE 49 89 D7 48 C1 E2 20 4C 01 F6 49 C1 EF 20 48 01 EE 48 01 D0 4C 01 FE 4C 8B 7C 24 18 49 C1 EF 20 49 01 F7 48 03 44 24 20 49 83 D7 00 4C 01 D8 48 8B 05 ?? ?? ?? ?? 49 83 D7 00 4C 01 F9 8B 48 6C 49 83 D1 00 4C 89 D0 48 C1 E8 20 25 00 00 00 FC 83 E9 40 49 D3 E9 48 B9 00 00 00 00 00 00 00 7E 49 21 C8 44 09 C8 49 39 C8 0F 85 14 F9 FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 01 E9 05 F9 FF FF 81 FA 97 17 00 00 0F 8F F7 00 00 00 8B 44 24 08 C7 44 24 10 03 00 00 00 41 BA 03 00 00 00 C7 44 24 54 01 00 00 00 48 8B 1D ?? ?? ?? ?? 8D 90 45 E8 FF FF E9 72 FA FF FF 66 0F 1F 44 00 00 4C 89 D8 4D 89 D8 66 0F EF D2 48 D1 E8 41 83 E0 01 4C 09 C0 F3 48 0F 2A D0 F3 0F 58 D2 E9 91 F9 FF FF 48 39 F8 0F 86 69 F8 FF FF E9 B6 F8 FF FF B9 40 00 00 00 49 89 C3 4C 89 C3 44 29 D1 49 D3 E3 44 89 D1 48 D3 EB 4C 09 DB E9 12 FC FF FF 90 B9 40 00 00 00 4C 89 C7 44 29 D1 48 D3 E7 31 ED E9 77 FC FF FF 85 D2 0F 88 C3 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 89 C2 81 CA 00 00 00 78 83 FE 02 0F 84 BB 03 00 00 0D 7F 96 F8 77 83 FE 03 0F 84 31 F8 FF FF 83 FE 01 89 D0 0F 85 26 F8 FF FF 4D 85 C9 B8 7F 96 F8 77 0F 45 C2 E9 16 F8 FF FF 0F 85 58 F9 FF FF 48 39 38 0F 87 4F F9 FF FF E9 46 F9 FF FF 81 7C 24 08 BA 17 00 00 0F 84 FE 02 00 00 44 8B 54 24 10 48 8B 1D ?? ?? ?? ?? C7 44 24 54 01 00 00 00 41 81 C0 BB 17 00 00 31 D2 44 2B 44 24 08 C7 44 24 08 BB 17 00 00 E9 6A F9 FF FF 48 89 F8 49 89 F8 66 0F EF C9 48 D1 E8 41 83 E0 01 4C 09 C0 F3 48 0F 2A C8 0F 28 C1 F3 0F 58 C1 E9 A6 F8 FF FF 66 0F 1F 84 00 00 00 00 00 BB 40 42 0F 00 83 FA F9 0F 8C D2 01 00 00 4D 85 C9 74 0C 8D 4E FF 83 F9 01 0F 86 1C 03 00 00 48 63 CE F7 DA 4C 8D 04 C9 48 63 D2 4A 8D 0C 41 4C 8B 05 ?? ?? ?? ?? 48 01 D1 49 03 1C C8 4C 8B 05 ?? ?? ?? ?? 4D 8B 14 D0 48 89 D9 89 DB 48 C1 E9 20 4D 89 D0 45 89 D1 48 89 CF 49 C1 E8 20 49 0F AF F9 49 0F AF C8 4C 0F AF CB 89 FD 48 C1 EF 20 49 89 CB 4C 0F AF C3 4C 89 C9 45 89 C9 48 C1 E9 20 48 01 E9 4C 01 C1 49 89 F8 4D 01 D8 49 89 CB 48 C1 E1 20 49 01 C9 48 8B 0D ?? ?? ?? ?? 49 C1 EB 20 4D 01 D8 4C 89 C7 8B 1C 91 89 D9 48 D3 EF 85 F6 0F 85 C9 01 00 00 40 F6 C7 01 74 23 B9 40 00 00 00 48 C7 C2 FF FF FF FF 29 D9 48 D3 EA 4D 39 CA 76 0D 49 85 D0 0F 94 C2 80 FA 01 48 83 D7 FF 4C 8B 1D ?? ?? ?? ?? 41 8B 13 F6 C2 20 0F 85 A0 01 00 00 B9 40 00 00 00 29 D9 49 D3 E0 48 B9 00 00 00 00 00 00 00 80 49 39 C8 0F 85 38 01 00 00 4D 39 CA 0F 86 2F 01 00 00 09 F8 E9 76 F6 FF FF 41 8D 4A C0 41 B8 01 00 00 00 45 31 DB 49 D3 E0 E9 0F FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 B9 40 00 00 00 44 29 D1 48 D3 EF 48 89 FD 31 FF E9 CC FA FF FF 48 09 FD 0F 85 02 FB FF FF 48 8B 44 24 20 48 C1 E0 04 48 03 44 24 58 4C 3B 60 08 0F 82 00 FB FF FF 0F 85 E4 FA FF FF 4C 3B 30 0F 82 F1 FA FF FF E9 D6 FA FF FF 66 0F 1F 44 00 00 75 09 49 39 FA 0F 86 5C F5 FF FF 49 BA FF FF FF FF FF 3F 00 FE 4D 21 C2 E9 59 F5 FF FF 0F 1F 00 44 89 D9 48 89 C7 4D 89 C5 48 D3 E7 41 8D 4A C0 4C 89 C5 49 D3 ED 44 89 D9 48 D3 E5 48 89 E9 4C 09 E9 48 09 F9 0F 84 89 F9 FF FF E9 C9 F9 FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 30 85 C0 0F 84 31 01 00 00 83 FE 01 0F 85 28 01 00 00 B8 01 00 00 80 E9 92 F5 FF FF B9 40 00 00 00 29 D9 49 D3 E0 83 FE 03 0F 84 31 01 00 00 83 FE 04 0F 84 DD FE FF FF 83 FE 01 0F 84 1F 01 00 00 4D 01 D1 41 0F 92 C1 49 D3 E8 89 D9 45 0F B6 C9 4D 01 C8 49 D3 E8 4D 85 C0 0F 85 D1 FE FF FF 83 CA 30 09 F8 41 89 13 E9 41 F5 FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 B8 00 00 00 00 00 00 00 80 48 39 C7 0F 85 ED F9 FF FF 48 85 ED 0F 84 E2 FE FF FF E9 DF F9 FF FF 4C 8B 1D ?? ?? ?? ?? 41 8B 13 F6 C2 20 0F 84 71 FF FF FF 83 CA 10 09 F8 41 89 13 E9 F6 F4 FF FF 44 8B 54 24 10 49 63 C0 48 8B 1D ?? ?? ?? ?? 48 89 FD C7 44 24 54 00 00 00 00 4B 8D 14 D2 48 8D 04 90 4C 89 DA 48 C1 E0 04 48 01 D8 48 03 50 08 48 03 28 0F 92 C0 0F B6 C0 48 01 C2 41 8D 40 07 48 98 48 C1 E0 04 48 01 C1 48 3B 51 08 0F 87 C3 FC FF FF C7 44 24 54 01 00 00 00 0F 85 B5 FC FF FF 31 C0 48 3B 29 0F 92 C0 89 44 24 54 E9 A4 FC FF FF 0D 7F 96 F8 77 4D 85 C9 0F 44 C2 E9 74 F4 FF FF 85 C0 0F 85 6C F4 FF FF 83 FE 02 BA 01 00 00 00 0F 44 C2 E9 5C F4 FF FF B9 03 00 00 00 29 F1 89 CE E9 D6 FC FF FF 4D 85 C0 0F 84 BF FD FF FF E9 F2 FE FF FF 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__trunctfdf2"
		size = 1328
		refs = "0359 __sfp_handle_exceptions"
	strings:
		$1 = { 53 48 83 EC 40 66 0F 6F 09 C7 44 24 3C 00 00 00 00 0F 29 4C 24 20 0F AE 5C 24 3C 48 B8 FF FF FF FF FF FF 00 00 4C 8B 4C 24 28 48 8B 4C 24 20 4D 89 CB 4C 21 C8 49 89 CA 49 C1 EB 30 48 C1 E0 03 49 C1 EA 3D 41 81 E3 FF 7F 00 00 49 C1 E9 3F 4C 09 D0 49 8D 53 01 45 0F B6 C1 48 8D 1C CD 00 00 00 00 81 E2 FF 7F 00 00 48 83 FA 01 0F 8E 3E 01 00 00 49 8D 93 00 C4 FF FF 48 81 FA FE 07 00 00 0F 8F BA 00 00 00 48 85 D2 0F 8E E1 02 00 00 48 C1 E1 07 48 C1 E0 04 45 31 D2 48 85 C9 41 0F 95 C2 48 C1 EB 3C 4C 09 D0 49 89 DA 49 09 C2 31 C0 41 F6 C2 07 0F 84 E6 00 00 00 44 8B 5C 24 3C B9 20 00 00 00 41 81 E3 00 60 00 00 41 81 FB 00 20 00 00 0F 84 2A 02 00 00 41 81 FB 00 40 00 00 0F 84 3B 01 00 00 45 85 DB 0F 84 83 01 00 00 4D 85 D2 74 07 84 C0 74 03 83 C9 10 49 BB 00 00 00 00 00 00 80 00 4D 21 D3 4D 85 DB 0F 84 C0 01 00 00 48 83 C2 01 48 81 FA FF 07 00 00 0F 84 6F 01 00 00 48 B8 FF FF FF FF FF FF 7F FF 49 21 C2 89 D0 49 C1 EA 03 66 25 FF 07 EB 2B 66 0F 1F 44 00 00 44 8B 5C 24 3C 41 81 E3 00 60 00 00 0F 85 8F 00 00 00 BA FF 07 00 00 B9 28 00 00 00 89 D0 45 31 D2 66 25 FF 07 48 89 C2 48 B8 FF FF FF FF FF FF 0F 00 49 C1 E0 3F 48 C1 E2 34 4C 21 D0 48 09 D0 4C 09 C0 85 C9 48 89 44 24 20 F2 0F 10 44 24 20 0F 85 BC 01 00 00 48 83 C4 40 5B C3 0F 1F 40 00 31 C9 E9 53 FF FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 DB 75 7B 48 09 D8 0F 84 52 02 00 00 44 8B 5C 24 3C B8 01 00 00 00 B9 22 00 00 00 41 BA 01 00 00 00 31 D2 41 81 E3 00 60 00 00 E9 EA FE FF FF 41 81 FB 00 40 00 00 0F 84 32 02 00 00 41 81 FB 00 20 00 00 0F 84 99 02 00 00 41 81 FB 00 40 00 00 0F 85 0E 03 00 00 31 C0 49 83 CA FF BA FE 07 00 00 B9 28 00 00 00 0F 1F 84 00 00 00 00 00 4D 8D 5A 08 4D 85 C0 4D 0F 44 D3 E9 BE FE FF FF 48 89 C1 48 09 D9 0F 84 C4 01 00 00 31 C9 49 81 FB FF 7F 00 00 0F 84 19 02 00 00 48 C1 E0 04 48 C1 EB 3C 49 BA 00 00 00 00 00 00 40 00 48 09 D8 BA FF 07 00 00 48 83 E0 F8 49 09 C2 E9 89 FE FF FF 4C 89 D3 4D 8D 5A 04 83 E3 0F 48 83 FB 04 4D 0F 45 D3 E9 66 FE FF FF 0F 1F 84 00 00 00 00 00 8B 44 24 3C 25 00 60 00 00 74 75 3D 00 40 00 00 0F 84 4A 02 00 00 3D 00 20 00 00 75 0D 45 31 D2 45 84 C9 B8 FF 07 00 00 75 5E B8 FE 07 00 00 49 BA FF FF FF FF FF FF FF 1F EB 4D 0F 1F 44 00 00 49 C1 EA 03 89 D0 66 25 FF 07 4D 85 D2 0F 84 82 FE FF FF 48 81 FA FF 07 00 00 0F 85 75 FE FF FF 48 BA 00 00 00 00 00 00 08 00 49 09 D2 E9 63 FE FF FF 4F 8D 14 C2 E9 E3 FD FF FF 0F 1F 44 00 00 B8 FF 07 00 00 45 31 D2 25 FF 07 00 00 4D 89 D1 83 C9 28 48 C1 E0 34 48 89 C2 48 B8 FF FF FF FF FF FF 0F 00 49 21 C1 4C 89 C0 4D 89 C8 48 C1 E0 3F 49 09 D0 49 09 C0 4C 89 44 24 20 F2 0F 10 44 24 20 F2 0F 11 44 24 20 E8 ?? ?? ?? ?? F2 0F 10 44 24 20 48 83 C4 40 5B C3 0F 1F 80 00 00 00 00 48 83 FA CC 0F 8C C7 00 00 00 B9 3D 3C 00 00 49 BA 00 00 00 00 00 00 08 00 4C 29 D9 4C 09 D0 48 83 F9 3F 49 89 CB 0F 8F 19 01 00 00 41 BA 3D 00 00 00 44 8D 5A 03 44 89 D1 49 89 DA 29 D1 49 D3 EA 44 89 D9 48 D3 E0 48 D3 E3 4C 09 D0 48 85 DB 41 0F 95 C2 31 D2 45 0F B6 D2 49 09 C2 B8 01 00 00 00 41 F6 C2 07 0F 85 DE FC FF FF 4D 85 D2 0F 84 BB FD FF FF F6 44 24 3D 08 0F 84 90 00 00 00 31 C9 E9 00 FD FF FF 66 0F 1F 84 00 00 00 00 00 BA FF 07 00 00 31 C9 E9 50 FD FF FF 0F 1F 40 00 31 D2 31 C9 E9 43 FD FF FF 0F 1F 80 00 00 00 00 4D 85 C0 0F 84 29 FD FF FF 31 C0 49 C7 C2 FF FF FF FF BA FE 07 00 00 B9 28 00 00 00 E9 AD FC FF FF 44 8B 5C 24 3C B8 01 00 00 00 B9 20 00 00 00 41 BA 01 00 00 00 31 D2 41 81 E3 00 60 00 00 E9 67 FC FF FF 48 89 C1 48 C1 E9 32 48 83 F1 01 83 E1 01 E9 D4 FD FF FF 66 0F 1F 84 00 00 00 00 00 49 BB 00 00 00 00 00 00 80 00 31 C9 4D 21 D3 E9 73 FC FF FF 4D 85 C0 0F 85 B5 FC FF FF 31 C0 B9 28 00 00 00 49 C7 C2 FF FF FF FF BA FE 07 00 00 E9 16 FC FF FF B9 FD FF FF FF 49 89 C2 29 D1 49 D3 EA 31 C9 49 83 FB 40 74 09 8D 4A 43 48 D3 E0 48 89 C1 31 C0 48 09 D9 0F 95 C0 31 D2 49 09 C2 B8 01 00 00 00 E9 E8 FE FF FF 66 0F 1F 44 00 00 44 89 C0 66 BA 00 00 49 B9 FF FF FF FF FF FF FF 1F F7 D8 66 05 FF 07 4D 85 C0 4C 0F 44 CA 4D 89 CA E9 02 FE FF FF BA FE 07 00 00 B9 28 00 00 00 49 83 CA FF E9 D1 FB FF FF 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__lttf2"
		size = 416
		refs = "010e __sfp_handle_exceptions"
	strings:
		$1 = { 57 56 53 48 83 EC 50 66 0F 6F 01 C7 44 24 4C 00 00 00 00 66 0F 6F 0A 0F 29 44 24 20 0F 29 4C 24 30 0F AE 5C 24 4C 48 B9 FF FF FF FF FF FF 00 00 48 8B 44 24 28 48 8B 5C 24 20 4C 8B 54 24 30 49 89 C3 49 89 C0 48 C1 E8 3F 48 89 C2 48 8B 44 24 38 49 C1 E8 30 41 81 E0 FF 7F 00 00 49 21 CB 49 89 C1 48 21 C1 48 C1 E8 3F 49 C1 E9 30 41 81 E1 FF 7F 00 00 49 81 F8 FF 7F 00 00 74 43 49 81 F9 FF 7F 00 00 74 7A 4D 85 C0 75 46 4C 89 DF 31 F6 48 09 DF 40 0F 94 C6 4D 85 C9 75 08 48 89 CF 4C 09 D7 74 7C 85 F6 74 38 48 83 F8 01 48 19 C0 48 83 C8 01 48 83 C4 50 5B 5E 5F C3 0F 1F 44 00 00 4C 89 DE 48 09 DE 75 40 49 81 F9 FF 7F 00 00 74 7F 4D 85 C9 75 0A 48 89 CE 4C 09 D6 74 07 66 90 48 39 C2 74 7B 48 83 FA 01 48 19 C0 83 E0 02 48 83 E8 01 48 83 C4 50 5B 5E 5F C3 0F 1F 44 00 00 48 89 CF 4C 09 D7 74 28 B9 01 00 00 00 E8 ?? ?? ?? ?? B8 02 00 00 00 48 83 C4 50 5B 5E 5F C3 90 85 F6 74 C1 31 C0 48 83 C4 50 5B 5E 5F C3 66 90 4D 85 C0 75 AB 4C 89 DF 31 F6 48 09 DF 40 0F 94 C6 E9 5E FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 89 CF 4C 09 D7 75 B0 EB 86 66 0F 1F 44 00 00 4D 39 C8 7F 80 7C 25 49 39 CB 0F 87 75 FF FF FF 0F 94 C0 75 09 4C 39 D3 0F 87 67 FF FF FF 49 39 CB 72 09 84 C0 74 9D 49 39 DA 76 98 48 83 FA 01 48 19 C0 48 83 C8 01 E9 17 FF FF FF 90 90 90 90 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__bid_addsd3"
		size = 64
		refs = "0009 __bid32_to_bid64 001e __bid64_add 0026 __bid64_to_bid32"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 C4 28 5B 5E C3 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "__bid_subsd3"
		size = 64
		refs = "0009 __bid32_to_bid64 001e __bid64_sub 0026 __bid64_to_bid32"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 C4 28 5B 5E C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__bid_divsd3"
		size = 64
		refs = "0009 __bid32_to_bid64 001e __bid64_div 0026 __bid64_to_bid32"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 C4 28 5B 5E C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__bid_mulsd3"
		size = 64
		refs = "0009 __bid32_to_bid64 001e __bid64_mul 0026 __bid64_to_bid32"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 C4 28 5B 5E C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__bid_trunctdsf"
		size = 48
		refs = "001b __bid128_to_binary32"
	strings:
		$1 = { 48 83 EC 38 48 8B 01 48 8B 51 08 48 8D 4C 24 20 48 89 44 24 20 48 89 54 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__bid_trunctddf"
		size = 48
		refs = "001b __bid128_to_binary64"
	strings:
		$1 = { 48 83 EC 38 48 8B 01 48 8B 51 08 48 8D 4C 24 20 48 89 44 24 20 48 89 54 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__bid128_to_int32_rnint"
		size = 2032
		refs = "0092 .refptr.__bid_ten2k64 00e7 .refptr.__bid_IDEC_glbflags 0129 .refptr.__bid_nr_digits 01d0 .refptr.__bid_midpoint128 0341 .refptr.__bid_midpoint64 03ea .refptr.__bid_ten2mk128 054e .refptr.__bid_shiftright128 0572 .refptr.__bid_maskhigh128 059f .refptr.__bid_ten2mk128trunc 06d4 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 B4 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 AC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 99 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 1E 0F 8F 3B 06 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 04 C1 89 C1 48 C1 E8 20 4C 8D 14 89 48 8D 04 80 4C 89 D3 45 89 D2 48 C1 EB 20 4A 8D 0C 13 48 01 C3 48 01 C1 48 89 C8 48 C1 E1 20 48 C1 E8 20 4A 8D 34 11 48 01 D8 48 39 C2 77 0F 0F 85 E5 01 00 00 49 39 F3 0F 86 DC 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 78 FF FF FF 0F 1F 84 00 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 57 01 00 00 48 85 D2 0F 84 D3 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 75 1A 44 8B 50 18 48 8B 40 08 48 39 C2 0F 87 97 01 00 00 48 39 C2 0F 84 7F 01 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 02 83 F8 0A 0F 8F 53 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 0A 0F 84 D9 00 00 00 85 C0 0F 88 C1 00 00 00 0F 85 0B 01 00 00 41 8D 4A FF 83 F9 12 0F 8E 73 01 00 00 41 8D 4A EC 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 82 92 FE FF FF 0F 84 D3 05 00 00 49 83 F9 01 19 C0 83 E0 02 83 E8 01 E9 7B FE FF FF 31 C0 4D 85 DB 0F 84 70 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 FD 00 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 0F 85 1A FF FF FF 44 8B 50 18 48 8B 40 08 E9 04 FF FF FF 0F 1F 84 00 00 00 00 00 31 C0 E9 F9 FD FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 C9 0F 84 E8 00 00 00 41 83 FA 0B 0F 8F EE FD FF FF B0 0B 48 8B 0D ?? ?? ?? ?? 4C 89 DF 44 29 D0 48 98 48 0F AF 3C C1 48 B8 05 00 00 00 05 00 00 00 48 39 C7 0F 87 28 FE FF FF 0F 1F 40 00 45 85 C0 0F 88 E7 00 00 00 0F 84 91 00 00 00 4D 85 C9 4D 63 C0 0F 84 E7 02 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 DB 42 8B 3C C0 41 0F AF FB 89 F8 E9 7C FD FF FF 49 C1 E0 05 4F 39 5C 01 10 0F 87 72 FE FF FF 41 83 C2 01 E9 69 FE FF FF 0F 1F 40 00 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 05 FF FF FF 48 85 D2 0F 85 A6 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 63 C9 4C 39 1C CA 0F 83 1E FD FF FF E9 8D FE FF FF 66 0F 1F 84 00 00 00 00 00 44 89 D8 F7 D8 4D 85 C9 41 0F 44 C3 E9 FF FC FF FF 41 83 FA 0B 0F 8F 5D 02 00 00 B8 0B 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 FA FF FF FF 04 00 00 00 48 39 C6 0F 86 19 FF FF FF E9 38 FD FF FF 0F 1F 40 00 44 89 C0 F7 D8 83 F8 13 89 44 24 04 0F 8F DA 02 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4C 89 D5 48 83 D2 00 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 45 89 D2 48 C1 ED 20 4C 89 D7 48 89 EB 49 89 ED 4D 89 D6 48 8B 48 08 48 8B 00 49 89 CB 89 C9 48 0F AF F9 49 C1 EB 20 48 0F AF D9 4D 0F AF EB 49 89 FC 89 FF 89 DE 49 C1 EC 20 48 C1 EB 20 49 01 F4 4C 89 D6 4C 01 EB 49 0F AF F3 49 89 ED 49 01 F4 4C 89 E6 49 C1 E4 20 48 C1 EE 20 4C 01 E7 48 01 DE 48 89 C3 89 C0 4C 0F AF E8 48 C1 EB 20 4C 0F AF F0 4C 0F AF D3 45 89 EF 49 C1 ED 20 4C 89 74 24 08 49 C1 EE 20 48 0F AF EB 4D 01 FE 4D 01 F2 4D 89 D7 49 C1 EF 20 49 01 ED 4D 01 EF 49 01 FF 48 89 D7 89 D2 48 83 D6 00 48 C1 EF 20 48 89 FD 49 89 FC 48 0F AF E9 48 0F AF CA 4D 0F AF E3 41 89 EE 48 C1 ED 20 49 89 CD 89 C9 4C 0F AF DA 49 C1 ED 20 4C 01 E5 4D 01 F5 4D 01 EB 4D 89 DC 49 C1 E3 20 49 C1 EC 20 4C 01 D9 4C 01 E5 49 89 FC 4C 0F AF E0 48 0F AF C2 48 0F AF D3 45 89 E6 49 C1 EC 20 49 89 C5 89 C0 48 0F AF FB 49 C1 ED 20 4D 01 F5 49 01 D5 4C 89 EA 49 C1 E5 20 4C 01 E7 48 C1 EA 20 4C 01 E8 48 01 FA 48 01 CA 48 83 D5 00 49 01 C7 0F 92 C0 0F B6 C0 48 01 C2 48 01 D6 0F 92 C1 48 39 D0 0F 97 C2 09 CA 0F B6 D2 48 01 D5 83 7C 24 04 16 0F 8F 2A 01 00 00 48 8B 05 ?? ?? ?? ?? 46 8B 1C 80 B8 40 00 00 00 44 29 D8 89 C1 48 89 F0 48 D3 E5 44 89 D9 48 D3 E8 48 09 C5 48 8B 05 ?? ?? ?? ?? 4A 23 34 C0 31 C0 48 09 C6 75 32 8B 44 24 08 49 C1 E2 20 49 8D 14 02 4C 89 F8 48 09 D0 74 1E 49 C1 E0 04 4C 89 C0 48 03 05 ?? ?? ?? ?? 4C 3B 78 08 0F 82 21 02 00 00 0F 84 12 02 00 00 89 E8 F7 D8 4D 85 C9 0F 44 C5 E9 AE FA FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 34 C0 41 0F AF F3 89 F0 E9 98 FA FF FF 41 83 FA 1E 0F 8F 47 01 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 04 C1 48 89 C5 89 C0 48 8D 34 85 00 00 00 00 49 89 C2 48 C1 ED 20 49 C1 E2 20 48 8D 1C AD 00 00 00 00 49 29 F2 89 F1 49 29 C2 4C 89 D0 45 89 D2 48 C1 E8 20 48 8D 3C 01 48 89 E9 48 C1 E1 20 48 29 D9 48 89 C8 48 29 E8 48 8D 0C 07 48 89 F0 48 C1 E8 20 48 01 C3 48 89 C8 48 C1 E1 20 48 C1 E8 20 4C 01 D1 48 01 D8 48 39 C2 0F 87 83 FA FF FF 0F 85 59 FC FF FF 49 39 CB 0F 82 50 FC FF FF E9 6F FA FF FF 48 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 EF 42 8B 0C 82 4A 23 3C C0 83 E9 40 48 89 F8 48 D3 ED E9 E0 FE FF FF B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 10 FD FF FF 41 8D 4A E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 8B 01 48 8B 49 08 41 89 C2 48 C1 E8 20 4B 8D 1C 92 48 8D 2C 80 48 89 DF 89 DB 48 C1 EF 20 48 8D 04 1F 48 01 E8 49 89 C2 48 C1 E8 20 49 C1 E2 20 49 8D 34 1A 4C 8D 14 89 4C 89 D3 48 C1 E3 20 49 01 DA 49 01 EA 49 01 FA 4C 01 D0 E9 A7 F9 FF FF 41 8D 42 E1 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 18 48 89 C7 49 89 DC 89 DB 4C 8D 14 9D 00 00 00 00 48 89 D9 49 C1 EC 20 48 C1 E1 20 4A 8D 2C A5 00 00 00 00 4C 89 E6 4C 29 D1 48 C1 E6 20 48 29 D9 48 29 EE 44 89 D3 48 89 C8 4C 29 E6 89 C9 48 C1 E8 20 49 C1 EA 20 48 01 D8 48 01 F0 48 89 C3 48 C1 E8 20 48 C1 E3 20 48 01 D9 48 8B 5F 08 48 8D 34 9B 48 89 F3 48 C1 E3 20 48 29 F3 48 01 EB 49 01 DA 4C 01 D0 E9 A1 FE FF FF 4C 39 19 0F 83 B0 F8 FF FF E9 1F FA FF FF 48 3B 10 0F 87 E5 FD FF FF 48 89 E8 83 E0 01 48 83 F8 01 48 83 D5 FF E9 D2 FD FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "__bid128_to_int32_xrnint"
		size = 2400
		refs = "008d .refptr.__bid_ten2k64 00e5 .refptr.__bid_IDEC_glbflags 0129 .refptr.__bid_nr_digits 01d2 .refptr.__bid_midpoint128 0341 .refptr.__bid_midpoint64 0401 .refptr.__bid_ten2mk128 0579 .refptr.__bid_maskhigh128 058d .refptr.__bid_shiftright128 05e8 .refptr.__bid_ten2mk128trunc 072c .refptr.__bid_onehalf128 0797 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 B2 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 AC 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 99 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 83 F8 1E 0F 8F 00 07 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 89 C1 48 C1 E8 20 4C 8D 14 89 48 8D 04 80 4C 89 D3 45 89 D2 48 C1 EB 20 4A 8D 0C 13 48 01 C3 48 01 C1 48 89 C8 48 C1 E1 20 48 C1 E8 20 4A 8D 34 11 48 01 D8 48 39 C2 77 0F 0F 85 D7 01 00 00 49 39 F3 0F 86 CE 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 7A FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 C9 01 00 00 48 85 D2 0F 84 DE 00 00 00 66 0F EF C0 4C 8B 15 ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4D 89 C1 49 C1 E1 05 4D 01 D1 41 8B 01 85 C0 75 1A 41 8B 41 18 4D 8B 49 08 4C 39 CA 0F 87 95 01 00 00 4C 39 CA 0F 84 75 01 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 46 8D 14 00 41 83 FA 0A 0F 8F 51 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 0A 0F 84 CA 00 00 00 45 85 D2 0F 88 FF 01 00 00 0F 85 F9 00 00 00 8D 48 FF 83 F9 12 0F 8E 72 01 00 00 8D 48 EC 31 C0 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 72 12 0F 84 97 06 00 00 49 83 F9 01 19 C0 83 E0 02 83 E8 01 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 73 FE FF FF 0F 1F 00 31 C0 4D 85 DB 0F 84 65 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 F2 00 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 15 ?? ?? ?? ?? 4D 89 C1 49 C1 E1 05 4D 01 D1 41 8B 01 85 C0 0F 85 0F FF FF FF 41 8B 41 18 4D 8B 49 08 E9 F9 FE FF FF 4D 85 C9 0F 84 F6 00 00 00 83 F8 0B 0F 8F FD FD FF FF B9 0B 00 00 00 4C 89 DE 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 34 C1 48 B8 05 00 00 00 05 00 00 00 48 39 C6 0F 87 32 FE FF FF 45 85 C0 0F 88 08 01 00 00 0F 84 A1 00 00 00 4D 85 C9 4D 63 C0 0F 84 6E 03 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 42 0F AF 04 C2 E9 8E FD FF FF 31 C0 E9 87 FD FF FF 49 C1 E0 05 4F 39 5C 02 10 0F 87 7C FE FF FF 0F 1F 84 00 00 00 00 00 83 C0 01 E9 6C FE FF FF 0F 1F 84 00 00 00 00 00 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 10 FF FF FF 48 85 D2 0F 85 A4 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 63 C9 31 C0 4C 39 1C CA 0F 83 9A FE FF FF E9 89 FE FF FF 0F 1F 80 00 00 00 00 44 89 D8 F7 D8 4D 85 C9 41 0F 44 C3 E9 FF FC FF FF 83 F8 0B 0F 8F D5 02 00 00 B9 0B 00 00 00 4C 89 DE 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 34 C1 48 B8 FA FF FF FF 04 00 00 00 48 39 C6 0F 86 0A FF FF FF E9 37 FD FF FF 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 AF FC FF FF 44 89 C0 F7 D8 83 F8 13 89 44 24 0C 0F 8F 8D 03 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 45 89 D2 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 EC 20 4C 89 D6 48 89 44 24 18 4C 89 E0 4C 89 E5 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF C1 49 0F AF EB 48 89 F7 89 F6 41 89 C5 48 C1 EF 20 48 C1 E8 20 4C 01 EF 4D 89 D5 48 01 E8 4D 0F AF EB 4C 01 EF 4D 89 D5 48 89 FD 48 C1 E7 20 48 C1 ED 20 48 01 FE 4C 8D 3C 28 48 8B 03 4C 89 E5 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF E8 4C 0F AF E3 48 0F AF E8 4C 89 64 24 10 4D 89 EC 45 89 ED 4C 0F AF D3 49 C1 EC 20 41 89 EE 4D 01 E6 4C 8B 64 24 10 48 C1 ED 20 4D 01 D6 49 01 EC 4D 89 F2 49 C1 E6 20 49 C1 EA 20 4D 01 EE 4D 01 D4 49 89 D2 89 D2 4C 01 E6 49 83 D7 00 49 C1 EA 20 4C 89 D5 4C 89 D7 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 ED 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 EC 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FD 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 EC 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 48 01 CA 48 83 D5 00 31 C9 48 01 C6 0F 92 C1 4C 89 F8 48 01 CA 48 01 D0 41 0F 92 C2 48 39 D1 0F 97 C2 44 09 D2 0F B6 D2 48 01 D5 83 7C 24 0C 16 48 8B 15 ?? ?? ?? ?? 0F 8F 94 01 00 00 49 89 C3 4E 23 1C C2 48 8B 15 ?? ?? ?? ?? 46 8B 14 82 BA 40 00 00 00 44 29 D2 89 D1 48 D3 E5 44 89 D1 48 D3 E8 48 09 C5 83 7C 24 0C 03 0F 8F 49 03 00 00 48 B8 00 00 00 00 00 00 00 80 48 39 C6 77 0F 0F 85 3D 01 00 00 4D 85 F6 0F 84 34 01 00 00 4C 89 C0 48 BA 00 00 00 00 00 00 00 80 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 01 F2 48 3B 50 08 0F 87 0F 01 00 00 0F 84 A4 02 00 00 4D 85 DB 75 26 48 89 F0 4C 09 F0 74 1E 49 C1 E0 04 4C 89 C0 48 03 05 ?? ?? ?? ?? 48 3B 70 08 0F 82 6C 02 00 00 0F 84 5D 02 00 00 89 E8 F7 D8 4D 85 C9 0F 44 C5 E9 37 FA FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 34 C0 41 0F AF F3 89 F0 E9 21 FA FF FF 83 F8 1E 0F 8F 94 01 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 89 C5 89 C0 48 8D 34 85 00 00 00 00 49 89 C2 48 C1 ED 20 49 C1 E2 20 48 8D 1C AD 00 00 00 00 49 29 F2 89 F1 49 29 C2 4C 89 D0 45 89 D2 48 C1 E8 20 48 8D 3C 01 48 89 E9 48 C1 E1 20 48 29 D9 48 89 C8 48 29 E8 48 8D 0C 07 48 89 F0 48 C1 E8 20 48 01 C3 48 89 C8 48 C1 E1 20 48 C1 E8 20 4C 01 D1 48 01 D8 48 39 C2 0F 87 0C FA FF FF 49 39 CB 0F 82 D1 FB FF FF 48 39 C2 0F 85 C8 FB FF FF E9 F5 F9 FF FF 0F 1F 00 4C 89 DB 48 29 C3 49 39 DB 48 89 D8 48 19 D2 48 09 D0 0F 84 1D 02 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 E9 E8 FE FF FF 49 89 EA 4E 23 14 C2 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 48 8B 15 ?? ?? ?? ?? 83 E9 40 48 D3 ED 4E 3B 14 C2 77 06 0F 84 6F 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 4D 85 D2 0F 85 D5 FE FF FF 49 89 C3 E9 A2 FE FF FF 0F 1F 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 5D FC FF FF 8D 48 E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 8B 01 48 8B 49 08 41 89 C2 48 C1 E8 20 4B 8D 1C 92 48 8D 2C 80 48 89 DF 89 DB 48 C1 EF 20 48 8D 04 1F 48 01 E8 49 89 C2 48 C1 E8 20 49 C1 E2 20 49 8D 34 1A 4C 8D 14 89 4C 89 D3 48 C1 E3 20 49 01 DA 49 01 EA 49 01 FA 4C 01 D0 E9 E2 F8 FF FF 83 E8 1F 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 18 48 89 C7 49 89 DC 89 DB 4C 8D 14 9D 00 00 00 00 48 89 D9 49 C1 EC 20 48 C1 E1 20 4A 8D 2C A5 00 00 00 00 4C 89 E6 4C 29 D1 48 C1 E6 20 48 29 D9 48 29 EE 44 89 D3 48 89 C8 4C 29 E6 89 C9 48 C1 E8 20 49 C1 EA 20 48 01 D8 48 01 F0 48 89 C3 48 C1 E8 20 48 C1 E3 20 48 01 D9 48 8B 5F 08 48 8D 34 9B 48 89 F3 48 C1 E3 20 48 29 F3 48 01 EB 49 01 DA 4C 01 D0 E9 54 FE FF FF 4C 39 19 0F 83 6C F9 FF FF E9 5B F9 FF FF 4C 3B 30 0F 87 9A FD FF FF 48 89 E8 83 E0 01 48 83 F8 01 48 83 D5 FF E9 87 FD FF FF 4C 3B 30 0F 82 53 FD FF FF E9 57 FE FF FF 48 85 C0 0F 95 C2 48 85 F6 41 0F 95 C3 4D 85 F6 0F 95 C1 41 08 CB 0F 84 75 FE FF FF 84 D2 0F 85 6D FE FF FF 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 87 57 FE FF FF 0F 85 5B FE FF FF 4C 3B 32 0F 86 52 FE FF FF E9 43 FE FF FF 48 8B 05 ?? ?? ?? ?? 4A 8B 04 C0 49 39 C3 0F 87 DD FD FF FF 0F 85 EF FD FF FF 48 89 F0 4C 09 F0 0F 84 E3 FD FF FF 4C 89 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 3B 70 08 0F 87 CB FD FF FF 0F 85 BC FC FF FF 4C 3B 30 0F 86 B3 FC FF FF E9 B7 FD FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_2_0 {
	meta:
		name = "__bid128_to_int32_floor"
		size = 2192
		refs = "0085 .refptr.__bid_ten2k64 00c5 .refptr.__bid_IDEC_glbflags 00fc .refptr.__bid_nr_digits 0355 .refptr.__bid_midpoint64 0380 .refptr.__bid_ten2mk128 04f8 .refptr.__bid_maskhigh128 050c .refptr.__bid_shiftright128 0567 .refptr.__bid_ten2mk128trunc 05fa .refptr.__bid_midpoint128 0625 .refptr.__bid_onehalf128 072c .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 92 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 15 0F 85 7F 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 76 70 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 1E 0F 8F E6 06 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 0C C1 89 C8 48 C1 E9 20 4C 8D 14 80 48 8D 04 89 4C 89 D3 48 C1 EB 20 48 01 D8 4C 89 D3 48 C1 E3 20 48 39 C2 77 0F 0F 85 D1 00 00 00 49 39 DB 0F 86 C8 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 EB 90 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 37 01 00 00 48 85 D2 0F 84 BB 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 75 22 44 8B 50 18 48 8B 40 08 48 39 C2 0F 87 01 01 00 00 48 39 C2 0F 84 E2 00 00 00 0F 1F 84 00 00 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 02 83 F8 0A 0F 8F 56 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 0A 0F 84 CE 00 00 00 85 C0 0F 8E 07 01 00 00 45 85 C0 0F 88 AD 01 00 00 0F 85 07 01 00 00 44 89 DA 44 89 D8 F7 DA 4D 85 C9 0F 45 C2 E9 B7 FE FF FF 0F 1F 40 00 31 C0 4D 85 DB 0F 84 A8 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 F2 00 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 0F 85 3A FF FF FF 44 8B 50 18 48 8B 40 08 E9 1C FF FF FF 31 C0 E9 39 FE FF FF 49 C1 E0 05 4F 39 5C 01 10 0F 87 17 FF FF FF 0F 1F 80 00 00 00 00 41 83 C2 01 E9 07 FF FF FF 0F 1F 80 00 00 00 00 4D 85 C9 0F 84 8C 00 00 00 41 83 FA 0B 0F 8F 11 FE FF FF B0 0B 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 00 00 00 00 05 00 00 00 48 39 C6 0F 86 FE FE FF FF E9 31 FE FF FF 31 C0 4D 85 C9 0F 95 C0 F7 D8 E9 C3 FD FF FF 4D 85 C9 4D 63 C0 74 78 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 42 0F AF 04 C2 E9 A4 FD FF FF 90 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 10 FF FF FF 41 83 FA 0B 0F 8F 80 03 00 00 B8 0B 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 FF FF FF FF 04 00 00 00 48 39 C6 0F 86 6F FE FF FF E9 A2 FD FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 34 C0 41 0F AF F3 89 F0 E9 2D FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 44 89 C0 F7 D8 83 F8 13 89 44 24 0C 0F 8F 8E 02 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 45 89 D2 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 EC 20 4C 89 D6 48 89 44 24 18 4C 89 E0 4C 89 E5 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF C1 49 0F AF EB 48 89 F7 89 F6 41 89 C5 48 C1 EF 20 48 C1 E8 20 4C 01 EF 4D 89 D5 48 01 E8 4D 0F AF EB 4C 01 EF 4D 89 D5 48 89 FD 48 C1 E7 20 48 C1 ED 20 48 01 FE 4C 8D 3C 28 48 8B 03 4C 89 E5 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF E8 4C 0F AF E3 48 0F AF E8 4C 89 64 24 10 4D 89 EC 45 89 ED 4C 0F AF D3 49 C1 EC 20 41 89 EE 4D 01 E6 4C 8B 64 24 10 48 C1 ED 20 4D 01 D6 49 01 EC 4D 89 F2 49 C1 E6 20 49 C1 EA 20 4D 01 EE 4D 01 D4 49 89 D2 89 D2 4C 01 E6 49 83 D7 00 49 C1 EA 20 4C 89 D5 4C 89 D7 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 ED 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 EC 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FD 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 EC 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 48 01 CA 48 83 D5 00 31 C9 48 01 C6 0F 92 C1 48 01 CA 49 01 D7 0F 92 C0 48 39 D1 4D 89 FA 0F 97 C2 09 C2 83 7C 24 0C 16 0F B6 D2 48 8D 44 15 00 48 8B 15 ?? ?? ?? ?? 0F 8F 0E 01 00 00 4C 89 FB 4A 23 1C C2 48 8B 15 ?? ?? ?? ?? 46 8B 1C 82 BA 40 00 00 00 44 29 DA 89 D1 48 D3 E0 44 89 D9 49 D3 EA 4C 09 D0 83 7C 24 0C 03 0F 8F BD 02 00 00 48 BA 00 00 00 00 00 00 00 80 48 39 D6 77 0F 0F 85 9C 02 00 00 4D 85 F6 0F 84 93 02 00 00 4D 89 C2 48 BA 00 00 00 00 00 00 00 80 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 48 01 F2 49 3B 52 08 0F 87 9A 01 00 00 BA 00 00 00 00 B9 00 00 00 00 0F 84 51 02 00 00 0F 1F 84 00 00 00 00 00 48 85 DB 75 2B 48 89 F3 4C 09 F3 74 23 49 C1 E0 04 4C 03 05 ?? ?? ?? ?? 49 3B 70 08 0F 82 01 02 00 00 0F 84 F2 01 00 00 0F 1F 84 00 00 00 00 00 4D 85 C9 0F 85 97 00 00 00 85 D2 0F 84 92 FA FF FF 48 83 E8 01 E9 89 FA FF FF 66 0F 1F 44 00 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 5C FD FF FF 66 0F 1F 44 00 00 49 89 C3 4E 23 1C C2 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 48 8B 15 ?? ?? ?? ?? 83 E9 40 48 D3 E8 4E 3B 1C C2 0F 87 B5 00 00 00 BA 01 00 00 00 B9 00 00 00 00 0F 84 80 00 00 00 4D 85 DB 0F 85 6E FF FF FF 4C 89 D3 E9 36 FF FF FF 66 0F 1F 44 00 00 85 C9 74 04 48 83 C0 01 F7 D8 E9 F4 F9 FF FF 41 83 FA 1E 0F 8F A5 00 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 0C C1 89 C8 48 C1 E9 20 4C 8D 14 80 48 8D 04 89 4C 89 D3 48 C1 EB 20 48 01 D8 4C 89 D3 48 C1 E3 20 48 39 C2 0F 87 10 FA FF FF 49 39 DB 0F 82 CF FA FF FF 48 39 C2 0F 85 C6 FA FF FF E9 F9 F9 FF FF 4D 85 FF 0F 95 C3 48 85 F6 40 0F 95 C5 4D 85 F6 40 0F 95 C7 40 08 FD 0F 85 6B 01 00 00 84 DB 0F 84 5B FF FF FF 31 D2 B9 01 00 00 00 E9 4F FF FF FF 48 89 DF 48 29 D7 48 39 FB 48 89 FA 48 19 C9 48 09 CA 0F 84 0C 01 00 00 31 D2 B9 01 00 00 00 E9 72 FE FF FF 41 8D 4A E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 4C 8B 11 44 89 D0 49 C1 EA 20 4B 8D 34 92 4C 8B 51 08 48 8D 04 80 48 89 C3 48 C1 E8 20 4B 8D 0C 92 48 C1 E3 20 48 C1 E1 20 48 01 F1 48 01 C8 E9 45 FF FF FF 41 8D 4A E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 4C 8B 11 44 89 D0 49 C1 EA 20 4B 8D 34 92 4C 8B 51 08 48 8D 04 80 48 89 C3 48 C1 E8 20 4B 8D 0C 92 48 C1 E3 20 48 C1 E1 20 48 01 F1 48 01 C8 E9 04 F9 FF FF 4D 3B 30 0F 87 0D FE FF FF A8 01 74 12 48 83 E8 01 4D 85 C9 0F 85 A0 FE FF FF E9 9A F8 FF FF 4D 85 C9 0F 84 FF FD FF FF F7 D8 E9 8A F8 FF FF 31 C9 4D 3B 32 0F 93 C1 E9 AA FD FF FF BA 01 00 00 00 31 C9 E9 9E FD FF FF 48 8B 15 ?? ?? ?? ?? 4A 8B 14 C2 48 39 D3 0F 87 F4 FE FF FF BA 01 00 00 00 B9 00 00 00 00 0F 85 7A FD FF FF 48 89 F7 4C 09 F7 74 AB 4C 89 C2 B9 01 00 00 00 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 3B 72 08 77 04 B1 00 74 07 31 D2 E9 4E FD FF FF 31 C9 4C 3B 32 0F 97 C1 31 D2 E9 3F FD FF FF 84 DB 0F 85 95 FE FF FF 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 87 7F FE FF FF 74 07 31 D2 E9 D1 FD FF FF 31 C9 4C 3B 32 0F 97 C1 31 D2 E9 C2 FD FF FF 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_3_0 {
	meta:
		name = "__bid128_to_int32_xfloor"
		size = 2224
		refs = "0085 .refptr.__bid_ten2k64 00c8 .refptr.__bid_IDEC_glbflags 0109 .refptr.__bid_nr_digits 0365 .refptr.__bid_midpoint64 0390 .refptr.__bid_ten2mk128 0508 .refptr.__bid_maskhigh128 051c .refptr.__bid_shiftright128 0577 .refptr.__bid_ten2mk128trunc 060a .refptr.__bid_midpoint128 0635 .refptr.__bid_onehalf128 06f5 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 95 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 15 0F 85 8C 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 76 7D 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 1E 0F 8F 69 06 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 0C C1 89 C8 48 C1 E9 20 4C 8D 14 80 48 8D 04 89 4C 89 D3 48 C1 EB 20 48 01 D8 4C 89 D3 48 C1 E3 20 48 39 C2 77 12 49 39 DB 0F 82 D3 00 00 00 48 39 C2 0F 85 CA 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 EB 8D 66 2E 0F 1F 84 00 00 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 2B 01 00 00 48 85 D2 0F 84 AF 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 75 1A 44 8B 50 18 48 8B 40 08 48 39 C2 0F 87 F4 00 00 00 48 39 C2 0F 84 D6 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 02 83 F8 0A 0F 8F 54 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 0A 0F 84 C9 00 00 00 85 C0 0F 8E 02 01 00 00 45 85 C0 0F 88 B8 01 00 00 0F 85 12 01 00 00 44 89 DA 44 89 D8 F7 DA 4D 85 C9 0F 45 C2 E9 B2 FE FF FF 31 C0 4D 85 DB 0F 84 A7 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 01 01 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 0F 85 3E FF FF FF 44 8B 50 18 48 8B 40 08 E9 28 FF FF FF 31 C0 E9 38 FE FF FF 49 C1 E0 05 4F 39 5C 01 10 0F 87 1B FF FF FF 66 0F 1F 44 00 00 41 83 C2 01 E9 0C FF FF FF 0F 1F 80 00 00 00 00 4D 85 C9 0F 84 9C 00 00 00 41 83 FA 0B 0F 8F 1D 04 00 00 B0 0B 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 00 00 00 00 05 00 00 00 48 39 C6 0F 86 03 FF FF FF E9 34 FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 C9 0F 95 C0 F7 D8 E9 B9 FD FF FF 66 0F 1F 44 00 00 4D 85 C9 4D 63 C0 74 78 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 42 0F AF 04 C2 E9 94 FD FF FF 90 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 01 FF FF FF 41 83 FA 0B 0F 8F 75 FD FF FF B8 0B 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 FF FF FF FF 04 00 00 00 48 39 C6 0F 86 64 FE FF FF E9 95 FD FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 34 C0 41 0F AF F3 89 F0 E9 1D FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 44 89 C0 F7 D8 83 F8 13 89 44 24 0C 0F 8F 8E 02 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 45 89 D2 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 EC 20 4C 89 D6 48 89 44 24 18 4C 89 E0 4C 89 E5 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF C1 49 0F AF EB 48 89 F7 89 F6 41 89 C5 48 C1 EF 20 48 C1 E8 20 4C 01 EF 4D 89 D5 48 01 E8 4D 0F AF EB 4C 01 EF 4D 89 D5 48 89 FD 48 C1 E7 20 48 C1 ED 20 48 01 FE 4C 8D 3C 28 48 8B 03 4C 89 E5 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF E8 4C 0F AF E3 48 0F AF E8 4C 89 64 24 10 4D 89 EC 45 89 ED 4C 0F AF D3 49 C1 EC 20 41 89 EE 4D 01 E6 4C 8B 64 24 10 48 C1 ED 20 4D 01 D6 49 01 EC 4D 89 F2 49 C1 E6 20 49 C1 EA 20 4D 01 EE 4D 01 D4 49 89 D2 89 D2 4C 01 E6 49 83 D7 00 49 C1 EA 20 4C 89 D5 4C 89 D7 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 ED 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 EC 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FD 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 EC 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 48 01 CA 48 83 D5 00 31 C9 48 01 C6 0F 92 C1 48 01 CA 49 01 D7 0F 92 C0 48 39 D1 4D 89 FA 0F 97 C2 09 C2 83 7C 24 0C 16 0F B6 D2 48 8D 44 15 00 48 8B 15 ?? ?? ?? ?? 0F 8F 0E 01 00 00 4C 89 FB 4A 23 1C C2 48 8B 15 ?? ?? ?? ?? 46 8B 1C 82 BA 40 00 00 00 44 29 DA 89 D1 48 D3 E0 44 89 D9 49 D3 EA 4C 09 D0 83 7C 24 0C 03 0F 8F BB 02 00 00 48 BA 00 00 00 00 00 00 00 80 48 39 D6 77 0F 0F 85 77 01 00 00 4D 85 F6 0F 84 6E 01 00 00 4D 89 C2 48 BA 00 00 00 00 00 00 00 80 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 48 01 F2 49 3B 52 08 0F 87 F4 01 00 00 B9 00 00 00 00 BA 00 00 00 00 0F 84 DB 01 00 00 0F 1F 84 00 00 00 00 00 48 85 DB 75 2B 48 89 F3 4C 09 F3 74 23 49 C1 E0 04 4C 03 05 ?? ?? ?? ?? 49 3B 70 08 0F 82 F8 01 00 00 0F 84 E9 01 00 00 0F 1F 84 00 00 00 00 00 4D 85 C9 0F 85 98 00 00 00 85 C9 0F 84 82 FA FF FF 48 83 E8 01 E9 79 FA FF FF 66 0F 1F 44 00 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 5C FD FF FF 66 0F 1F 44 00 00 49 89 C3 4E 23 1C C2 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 48 8B 15 ?? ?? ?? ?? 83 E9 40 48 D3 E8 4E 3B 1C C2 0F 87 52 01 00 00 0F 84 91 01 00 00 48 8B 15 ?? ?? ?? ?? B9 01 00 00 00 83 0A 20 31 D2 4D 85 DB 0F 85 67 FF FF FF 4C 89 D3 E9 2F FF FF FF 85 D2 74 04 48 83 C0 01 F7 D8 E9 E3 F9 FF FF 41 83 FA 1E 0F 8F A3 00 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 0C C1 89 C8 48 C1 E9 20 4C 8D 14 80 48 8D 04 89 4C 89 D3 48 C1 EB 20 48 01 D8 4C 89 D3 48 C1 E3 20 48 39 C2 0F 87 02 FA FF FF 49 39 DB 0F 87 F0 F9 FF FF E9 BE FA FF FF 48 8B 15 ?? ?? ?? ?? B9 01 00 00 00 83 0A 20 31 D2 E9 B9 FE FF FF 41 8D 4A E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 4C 8B 11 44 89 D0 49 C1 EA 20 4B 8D 34 92 4C 8B 51 08 48 8D 04 80 48 89 C3 48 C1 E8 20 4B 8D 0C 92 48 C1 E3 20 48 C1 E1 20 48 01 F1 48 01 C8 E9 81 F9 FF FF 41 8D 4A E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 4C 8B 11 44 89 D0 49 C1 EA 20 4B 8D 34 92 4C 8B 51 08 48 8D 04 80 48 89 C3 48 C1 E8 20 4B 8D 0C 92 48 C1 E3 20 48 C1 E1 20 48 01 F1 48 01 C8 E9 47 FF FF FF 4D 3B 32 0F 82 24 FE FF FF 48 8B 15 ?? ?? ?? ?? 31 C9 83 0A 20 BA 01 00 00 00 E9 0E FE FF FF 4C 3B 32 0F 86 FE 00 00 00 48 8B 15 ?? ?? ?? ?? 31 C9 83 0A 20 BA 01 00 00 00 E9 AF FE FF FF 4D 3B 30 0F 87 16 FE FF FF A8 01 74 12 48 83 E8 01 4D 85 C9 0F 85 AA FE FF FF E9 93 F8 FF FF 4D 85 C9 0F 84 08 FE FF FF F7 D8 E9 83 F8 FF FF 4D 85 FF 0F 95 C2 48 85 F6 0F 95 C3 4D 85 F6 0F 95 C1 08 CB 75 7F 84 D2 0F 84 51 FE FF FF EB 9B 48 8B 15 ?? ?? ?? ?? 4A 8B 14 C2 48 39 D3 77 4F 0F 85 BB FE FF FF 48 89 F7 4C 09 F7 0F 84 AF FE FF FF 4C 89 C1 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 71 08 77 13 BA 00 00 00 00 74 07 31 C9 E9 5C FD FF FF 4C 3B 31 76 F4 48 8B 15 ?? ?? ?? ?? 31 C9 83 0A 20 BA 01 00 00 00 E9 41 FD FF FF 48 89 DF 48 29 D7 48 39 FB 48 89 FA 48 19 C9 48 09 CA 75 D6 EB AD 84 D2 0F 85 1E FF FF FF 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 87 08 FF FF FF 0F 84 F9 FE FF FF 31 C9 31 D2 E9 BE FD FF FF 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_4_0 {
	meta:
		name = "__bid128_to_int32_ceil"
		size = 2384
		refs = "0092 .refptr.__bid_ten2k64 0103 .refptr.__bid_IDEC_glbflags 013d .refptr.__bid_nr_digits 0395 .refptr.__bid_midpoint64 03c0 .refptr.__bid_ten2mk128 0538 .refptr.__bid_maskhigh128 054c .refptr.__bid_shiftright128 05a7 .refptr.__bid_ten2mk128trunc 063a .refptr.__bid_midpoint128 0665 .refptr.__bid_onehalf128 0787 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 D0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 C0 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 AD 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 1E 0F 8F EA 06 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 0C C1 B8 F6 FF FF FF 48 89 CE 89 C9 48 8D 1C 8D 00 00 00 00 48 C1 EE 20 48 0F AF C8 48 0F AF C6 89 DF 48 C1 EB 20 48 8D 1C B3 49 89 CA 48 C1 E9 20 48 01 F9 45 89 D2 48 01 C1 48 89 C8 48 C1 E1 20 48 C1 E8 20 4C 01 D1 48 01 D8 48 39 C2 77 16 49 39 CB 0F 86 D7 00 00 00 48 39 C2 0F 85 CE 00 00 00 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 5C FF FF FF 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 36 01 00 00 48 85 D2 0F 84 BA 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 75 21 44 8B 50 18 48 8B 40 08 48 39 C2 0F 87 00 01 00 00 48 39 C2 0F 84 E1 00 00 00 0F 1F 80 00 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 02 83 F8 0A 0F 8F 54 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 0A 0F 84 CE 00 00 00 85 C0 0F 8E 07 01 00 00 45 85 C0 0F 88 AD 01 00 00 0F 85 07 01 00 00 44 89 DA 44 89 D8 F7 DA 4D 85 C9 0F 45 C2 E9 84 FE FF FF 0F 1F 40 00 31 C0 4D 85 DB 0F 84 75 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 F2 00 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 0F 85 3A FF FF FF 44 8B 50 18 48 8B 40 08 E9 1D FF FF FF 31 C0 E9 06 FE FF FF 49 C1 E0 05 4F 39 5C 01 10 0F 87 17 FF FF FF 0F 1F 80 00 00 00 00 41 83 C2 01 E9 07 FF FF FF 0F 1F 80 00 00 00 00 4D 85 C9 0F 84 8C 00 00 00 41 83 FA 0B 0F 8F 0C 04 00 00 B0 0B 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 09 00 00 00 05 00 00 00 48 39 C6 0F 86 FE FE FF FF E9 2F FE FF FF 31 C0 4D 85 C9 0F 94 C0 E9 92 FD FF FF 66 90 4D 85 C9 4D 63 C0 74 78 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 42 0F AF 04 C2 E9 71 FD FF FF 90 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 10 FF FF FF 41 83 FA 0B 0F 8F 52 FD FF FF B8 0B 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 F6 FF FF FF 04 00 00 00 48 39 C6 0F 86 6F FE FF FF E9 A0 FD FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 34 C0 41 0F AF F3 89 F0 E9 FA FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 44 89 C0 F7 D8 83 F8 13 89 44 24 0C 0F 8F 8E 02 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 45 89 D2 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 EC 20 4C 89 D6 48 89 44 24 18 4C 89 E0 4C 89 E5 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF C1 49 0F AF EB 48 89 F7 89 F6 41 89 C5 48 C1 EF 20 48 C1 E8 20 4C 01 EF 4D 89 D5 48 01 E8 4D 0F AF EB 4C 01 EF 4D 89 D5 48 89 FD 48 C1 E7 20 48 C1 ED 20 48 01 FE 4C 8D 3C 28 48 8B 03 4C 89 E5 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF E8 4C 0F AF E3 48 0F AF E8 4C 89 64 24 10 4D 89 EC 45 89 ED 4C 0F AF D3 49 C1 EC 20 41 89 EE 4D 01 E6 4C 8B 64 24 10 48 C1 ED 20 4D 01 D6 49 01 EC 4D 89 F2 49 C1 E6 20 49 C1 EA 20 4D 01 EE 4D 01 D4 49 89 D2 89 D2 4C 01 E6 49 83 D7 00 49 C1 EA 20 4C 89 D5 4C 89 D7 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 ED 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 EC 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FD 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 EC 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 48 01 CA 48 83 D5 00 31 C9 48 01 C6 0F 92 C1 48 01 CA 49 01 D7 0F 92 C0 48 39 D1 4D 89 FA 0F 97 C2 09 C2 83 7C 24 0C 16 0F B6 D2 48 8D 44 15 00 48 8B 15 ?? ?? ?? ?? 0F 8F 0E 01 00 00 4C 89 FB 4A 23 1C C2 48 8B 15 ?? ?? ?? ?? 46 8B 1C 82 BA 40 00 00 00 44 29 DA 89 D1 48 D3 E0 44 89 D9 49 D3 EA 4C 09 D0 83 7C 24 0C 03 0F 8F 38 03 00 00 48 BA 00 00 00 00 00 00 00 80 48 39 D6 77 0F 0F 85 17 03 00 00 4D 85 F6 0F 84 0E 03 00 00 4D 89 C2 48 BA 00 00 00 00 00 00 00 80 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 48 01 F2 49 3B 52 08 0F 87 B1 01 00 00 BA 00 00 00 00 B9 00 00 00 00 0F 84 CC 02 00 00 0F 1F 84 00 00 00 00 00 48 85 DB 75 2B 48 89 F3 4C 09 F3 74 23 49 C1 E0 04 4C 03 05 ?? ?? ?? ?? 49 3B 70 08 0F 82 7C 02 00 00 0F 84 6D 02 00 00 0F 1F 84 00 00 00 00 00 4D 85 C9 0F 85 97 00 00 00 85 C9 0F 84 5F FA FF FF 48 83 C0 01 E9 56 FA FF FF 66 0F 1F 44 00 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 5C FD FF FF 66 0F 1F 44 00 00 49 89 C3 4E 23 1C C2 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 48 8B 15 ?? ?? ?? ?? 83 E9 40 48 D3 E8 4E 3B 1C C2 0F 87 CC 00 00 00 BA 01 00 00 00 B9 00 00 00 00 0F 84 97 00 00 00 4D 85 DB 0F 85 6E FF FF FF 4C 89 D3 E9 36 FF FF FF 66 0F 1F 44 00 00 85 D2 74 04 48 83 E8 01 F7 D8 E9 C1 F9 FF FF 41 83 FA 1E 0F 8F 39 01 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 04 C1 48 89 C1 89 C0 48 8D 04 80 48 C1 E9 20 48 8D 1C 89 48 8D 0C 00 89 C6 48 C1 E8 20 49 89 CA 89 C9 49 C1 EA 20 49 01 F2 4D 8D 14 5A 48 01 C3 4C 89 D0 49 C1 E2 20 48 C1 E8 20 49 01 CA 48 01 D8 48 39 C2 0F 87 EE F9 FF FF 4D 39 D3 0F 83 D8 F9 FF FF E9 AA FA FF FF 4D 85 FF 0F 95 C3 48 85 F6 40 0F 95 C5 4D 85 F6 40 0F 95 C7 40 08 FD 0F 85 CF 01 00 00 84 DB 0F 84 44 FF FF FF 31 D2 B9 01 00 00 00 E9 38 FF FF FF 48 89 DF 48 29 D7 48 39 FB 48 89 FA 48 19 C9 48 09 CA 0F 84 70 01 00 00 31 D2 B9 01 00 00 00 E9 5B FE FF FF 41 8D 42 E1 BB F6 FF FF FF 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 08 48 89 C7 48 89 CE 89 C9 4C 8D 14 8D 00 00 00 00 48 C1 EE 20 48 0F AF CB 48 0F AF DE 44 89 D5 49 C1 EA 20 48 89 C8 89 C9 48 C1 E8 20 48 01 E8 48 01 D8 48 89 C3 48 C1 E8 20 48 C1 E3 20 48 01 D9 48 8B 5F 08 48 8D 3C 9B 48 89 FB 48 C1 E3 1F 48 29 FB 48 01 DB 48 8D 1C B3 49 01 DA 4C 01 D0 E9 F3 F8 FF FF 41 8D 4A E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 8B 01 48 8B 49 08 48 89 C6 89 C0 48 8D 1C 80 48 C1 EE 20 48 8D 34 B6 4C 8D 14 1B 89 DF 48 C1 EB 20 4C 89 D0 45 89 D2 48 C1 E8 20 48 01 F8 48 8D 04 70 48 89 C7 48 C1 E8 20 48 C1 E7 20 49 01 FA 48 8D 3C 89 48 89 F9 48 C1 E1 1F 48 01 F9 48 8D 34 4E 48 89 D9 48 01 F1 48 01 C8 E9 A4 FE FF FF 4D 3B 30 0F 87 92 FD FF FF A8 01 74 14 48 83 E8 01 4D 85 C9 0F 84 92 FD FF FF F7 D8 E9 EA F7 FF FF 4D 85 C9 0F 85 15 FE FF FF E9 DC F7 FF FF 31 C9 4D 3B 32 0F 93 C1 E9 2F FD FF FF BA 01 00 00 00 31 C9 E9 23 FD FF FF 48 8B 15 ?? ?? ?? ?? 4A 8B 14 C2 48 39 D3 0F 87 90 FE FF FF BA 01 00 00 00 B9 00 00 00 00 0F 85 FF FC FF FF 48 89 F7 4C 09 F7 74 AD 4C 89 C2 B9 01 00 00 00 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 3B 72 08 77 04 B1 00 74 07 31 D2 E9 D3 FC FF FF 31 C9 4C 3B 32 0F 97 C1 31 D2 E9 C4 FC FF FF 84 DB 0F 85 31 FE FF FF 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 87 1B FE FF FF 74 07 31 D2 E9 56 FD FF FF 31 C9 4C 3B 32 0F 97 C1 31 D2 E9 47 FD FF FF 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_5_0 {
	meta:
		name = "__bid128_to_int32_xceil"
		size = 2416
		refs = "0092 .refptr.__bid_ten2k64 0103 .refptr.__bid_IDEC_glbflags 013d .refptr.__bid_nr_digits 03a5 .refptr.__bid_midpoint64 03d0 .refptr.__bid_ten2mk128 0548 .refptr.__bid_maskhigh128 055c .refptr.__bid_shiftright128 05b7 .refptr.__bid_ten2mk128trunc 064a .refptr.__bid_midpoint128 0675 .refptr.__bid_onehalf128 0759 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 D0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 C0 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 AD 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 1E 0F 8F BC 06 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 0C C1 B8 F6 FF FF FF 48 89 CE 89 C9 48 8D 1C 8D 00 00 00 00 48 C1 EE 20 48 0F AF C8 48 0F AF C6 89 DF 48 C1 EB 20 48 8D 1C B3 49 89 CA 48 C1 E9 20 48 01 F9 45 89 D2 48 01 C1 48 89 C8 48 C1 E1 20 48 C1 E8 20 4C 01 D1 48 01 D8 48 39 C2 77 16 49 39 CB 0F 86 D7 00 00 00 48 39 C2 0F 85 CE 00 00 00 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 5C FF FF FF 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 36 01 00 00 48 85 D2 0F 84 BA 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 75 21 44 8B 50 18 48 8B 40 08 48 39 C2 0F 87 00 01 00 00 48 39 C2 0F 84 E1 00 00 00 0F 1F 80 00 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 43 8D 04 02 83 F8 0A 0F 8F 54 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 83 F8 0A 0F 84 CE 00 00 00 85 C0 0F 8E 07 01 00 00 45 85 C0 0F 88 BD 01 00 00 0F 85 17 01 00 00 44 89 DA 44 89 D8 F7 DA 4D 85 C9 0F 45 C2 E9 84 FE FF FF 0F 1F 40 00 31 C0 4D 85 DB 0F 84 75 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 02 01 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 0D ?? ?? ?? ?? 4C 89 C0 48 C1 E0 05 4C 01 C8 44 8B 10 45 85 D2 0F 85 3A FF FF FF 44 8B 50 18 48 8B 40 08 E9 1D FF FF FF 31 C0 E9 06 FE FF FF 49 C1 E0 05 4F 39 5C 01 10 0F 87 17 FF FF FF 0F 1F 80 00 00 00 00 41 83 C2 01 E9 07 FF FF FF 0F 1F 80 00 00 00 00 4D 85 C9 0F 84 9C 00 00 00 41 83 FA 0B 0F 8F 1D 04 00 00 B0 0B 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 09 00 00 00 05 00 00 00 48 39 C6 0F 86 FE FE FF FF E9 2F FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 C9 0F 94 C0 E9 88 FD FF FF 0F 1F 84 00 00 00 00 00 4D 85 C9 4D 63 C0 74 78 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 42 0F AF 04 C2 E9 61 FD FF FF 90 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 00 FF FF FF 41 83 FA 0B 0F 8F 42 FD FF FF B8 0B 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 DE 44 29 D0 48 98 48 0F AF 34 C1 48 B8 F6 FF FF FF 04 00 00 00 48 39 C6 0F 86 5F FE FF FF E9 90 FD FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 34 C0 41 0F AF F3 89 F0 E9 EA FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 44 89 C0 F7 D8 83 F8 13 89 44 24 0C 0F 8F 8E 02 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 45 89 D2 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 EC 20 4C 89 D6 48 89 44 24 18 4C 89 E0 4C 89 E5 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF C1 49 0F AF EB 48 89 F7 89 F6 41 89 C5 48 C1 EF 20 48 C1 E8 20 4C 01 EF 4D 89 D5 48 01 E8 4D 0F AF EB 4C 01 EF 4D 89 D5 48 89 FD 48 C1 E7 20 48 C1 ED 20 48 01 FE 4C 8D 3C 28 48 8B 03 4C 89 E5 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF E8 4C 0F AF E3 48 0F AF E8 4C 89 64 24 10 4D 89 EC 45 89 ED 4C 0F AF D3 49 C1 EC 20 41 89 EE 4D 01 E6 4C 8B 64 24 10 48 C1 ED 20 4D 01 D6 49 01 EC 4D 89 F2 49 C1 E6 20 49 C1 EA 20 4D 01 EE 4D 01 D4 49 89 D2 89 D2 4C 01 E6 49 83 D7 00 49 C1 EA 20 4C 89 D5 4C 89 D7 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 ED 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 EC 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FD 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 EC 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 48 01 CA 48 83 D5 00 31 C9 48 01 C6 0F 92 C1 48 01 CA 49 01 D7 0F 92 C0 48 39 D1 4D 89 FA 0F 97 C2 09 C2 83 7C 24 0C 16 0F B6 D2 48 8D 44 15 00 48 8B 15 ?? ?? ?? ?? 0F 8F 0E 01 00 00 4C 89 FB 4A 23 1C C2 48 8B 15 ?? ?? ?? ?? 46 8B 1C 82 BA 40 00 00 00 44 29 DA 89 D1 48 D3 E0 44 89 D9 49 D3 EA 4C 09 D0 83 7C 24 0C 03 0F 8F 3F 03 00 00 48 BA 00 00 00 00 00 00 00 80 48 39 D6 77 0F 0F 85 97 01 00 00 4D 85 F6 0F 84 8E 01 00 00 4D 89 C2 48 BA 00 00 00 00 00 00 00 80 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 48 01 F2 49 3B 52 08 0F 87 78 02 00 00 BA 00 00 00 00 B9 00 00 00 00 0F 84 5F 02 00 00 0F 1F 84 00 00 00 00 00 48 85 DB 75 2B 48 89 F3 4C 09 F3 74 23 49 C1 E0 04 4C 03 05 ?? ?? ?? ?? 49 3B 70 08 0F 82 7C 02 00 00 0F 84 6D 02 00 00 0F 1F 84 00 00 00 00 00 4D 85 C9 0F 85 98 00 00 00 85 C9 0F 84 4F FA FF FF 48 83 C0 01 E9 46 FA FF FF 66 0F 1F 44 00 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 5C FD FF FF 66 0F 1F 44 00 00 49 89 C3 4E 23 1C C2 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 48 8B 15 ?? ?? ?? ?? 83 E9 40 48 D3 E8 4E 3B 1C C2 0F 87 D6 01 00 00 0F 84 15 02 00 00 48 8B 15 ?? ?? ?? ?? 31 C9 83 0A 20 BA 01 00 00 00 4D 85 DB 0F 85 67 FF FF FF 4C 89 D3 E9 2F FF FF FF 85 D2 74 04 48 83 E8 01 F7 D8 E9 B0 F9 FF FF 41 83 FA 1E 0F 8F FA 00 00 00 41 8D 42 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 04 C1 48 89 C1 89 C0 48 8D 04 80 48 C1 E9 20 48 8D 1C 89 48 8D 0C 00 89 C6 48 C1 E8 20 49 89 CA 89 C9 49 C1 EA 20 49 01 F2 4D 8D 14 5A 48 01 C3 4C 89 D0 49 C1 E2 20 48 C1 E8 20 49 01 CA 48 01 D8 48 39 C2 0F 87 DD F9 FF FF 4D 39 D3 0F 83 C7 F9 FF FF E9 99 FA FF FF 48 8B 15 ?? ?? ?? ?? 31 C9 83 0A 20 BA 01 00 00 00 E9 99 FE FF FF 41 8D 42 E1 BB F6 FF FF FF 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 08 48 89 C7 48 89 CE 89 C9 4C 8D 14 8D 00 00 00 00 48 C1 EE 20 48 0F AF CB 48 0F AF DE 44 89 D5 49 C1 EA 20 48 89 C8 89 C9 48 C1 E8 20 48 01 E8 48 01 D8 48 89 C3 48 C1 E8 20 48 C1 E3 20 48 01 D9 48 8B 5F 08 48 8D 3C 9B 48 89 FB 48 C1 E3 1F 48 29 FB 48 01 DB 48 8D 1C B3 49 01 DA 4C 01 D0 E9 21 F9 FF FF 41 8D 4A E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 8B 01 48 8B 49 08 48 89 C6 89 C0 48 8D 1C 80 48 C1 EE 20 48 8D 34 B6 4C 8D 14 1B 89 DF 48 C1 EB 20 4C 89 D0 45 89 D2 48 C1 E8 20 48 01 F8 48 8D 04 70 48 89 C7 48 C1 E8 20 48 C1 E7 20 49 01 FA 48 8D 3C 89 48 89 F9 48 C1 E1 1F 48 01 F9 48 8D 34 4E 48 89 D9 48 01 F1 48 01 C8 E9 E3 FE FF FF 4D 3B 32 0F 82 A0 FD FF FF 48 8B 15 ?? ?? ?? ?? B9 01 00 00 00 83 0A 20 31 D2 E9 8A FD FF FF 4C 3B 32 0F 86 FE 00 00 00 48 8B 15 ?? ?? ?? ?? B9 01 00 00 00 83 0A 20 31 D2 E9 2B FE FF FF 4D 3B 30 0F 87 92 FD FF FF A8 01 74 14 48 83 E8 01 4D 85 C9 0F 84 92 FD FF FF F7 D8 E9 DA F7 FF FF 4D 85 C9 0F 85 16 FE FF FF E9 CC F7 FF FF 4D 85 FF 0F 95 C2 48 85 F6 0F 95 C3 4D 85 F6 0F 95 C1 08 CB 75 7F 84 D2 0F 84 CD FD FF FF EB 9B 48 8B 15 ?? ?? ?? ?? 4A 8B 14 C2 48 39 D3 77 4F 0F 85 57 FE FF FF 48 89 F7 4C 09 F7 0F 84 4B FE FF FF 4C 89 C2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 3B 72 08 77 13 B9 00 00 00 00 74 07 31 D2 E9 D8 FC FF FF 4C 3B 32 76 F4 48 8B 15 ?? ?? ?? ?? B9 01 00 00 00 83 0A 20 31 D2 E9 BD FC FF FF 48 89 DF 48 29 D7 48 39 FB 48 89 FA 48 19 C9 48 09 CA 75 D6 EB AD 84 D2 0F 85 1E FF FF FF 48 8B 54 24 18 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 87 08 FF FF FF 0F 84 F9 FE FF FF 31 D2 31 C9 E9 3A FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_6_0 {
	meta:
		name = "__bid128_to_int32_int"
		size = 2000
		refs = "008d .refptr.__bid_ten2k64 00f3 .refptr.__bid_IDEC_glbflags 012d .refptr.__bid_nr_digits 0341 .refptr.__bid_midpoint128 0360 .refptr.__bid_ten2mk128 04d3 .refptr.__bid_maskhigh128 04e7 .refptr.__bid_shiftright128 0547 .refptr.__bid_ten2mk128trunc 05d3 .refptr.__bid_midpoint64 060e .refptr.__bid_onehalf128 06d2 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 C0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 B0 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 9D 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 83 F8 1E 0F 8F 3B 06 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 89 C1 89 C0 48 8D 04 80 48 C1 E9 20 48 8D 1C 89 48 8D 0C 00 89 C6 48 C1 E8 20 49 89 CA 89 C9 49 C1 EA 20 49 01 F2 4D 8D 14 5A 48 01 C3 4C 89 D0 49 C1 E2 20 48 C1 E8 20 49 01 CA 48 01 D8 48 39 C2 77 12 4D 39 D3 0F 82 D8 00 00 00 48 39 C2 0F 85 CF 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 6C FF FF FF 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 36 01 00 00 48 85 D2 0F 84 BB 00 00 00 66 0F EF C0 4C 8B 15 ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4D 89 C1 49 C1 E1 05 4D 01 D1 41 8B 01 85 C0 75 22 41 8B 41 18 4D 8B 49 08 4C 39 CA 0F 87 01 01 00 00 4C 39 CA 0F 84 E2 00 00 00 0F 1F 84 00 00 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 46 8D 14 00 41 83 FA 0A 0F 8F 53 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 0A 0F 84 EF 00 00 00 31 C0 45 85 D2 0F 8E B1 FE FF FF 45 85 C0 0F 88 4D 01 00 00 0F 85 B2 00 00 00 44 89 DA 44 89 D8 F7 DA 4D 85 C9 0F 45 C2 E9 8F FE FF FF 31 C0 4D 85 DB 0F 84 84 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 F1 00 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 15 ?? ?? ?? ?? 4D 89 C1 49 C1 E1 05 4D 01 D1 41 8B 01 85 C0 0F 85 3A FF FF FF 41 8B 41 18 4D 8B 49 08 E9 1C FF FF FF 31 C0 E9 16 FE FF FF 49 C1 E0 05 4F 39 5C 02 10 0F 87 17 FF FF FF 0F 1F 80 00 00 00 00 83 C0 01 E9 08 FF FF FF 0F 1F 84 00 00 00 00 00 4D 85 C9 4D 63 C0 0F 84 E4 02 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 42 0F AF 04 C2 E9 CD FD FF FF 4D 85 C9 0F 84 E4 02 00 00 83 F8 0B 0F 8F CC FD FF FF B9 0B 00 00 00 4C 89 DF 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 3C C1 48 B8 09 00 00 00 05 00 00 00 48 39 C7 0F 86 DE FE FF FF E9 0A FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 11 FF FF FF 44 89 C0 F7 D8 83 F8 13 89 44 24 04 0F 8E A9 02 00 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 45 89 D2 49 C1 EC 20 4C 89 D7 4C 89 E6 4C 89 E3 4D 89 D7 48 8B 48 08 48 8B 00 49 89 CB 89 C9 48 0F AF F9 49 C1 EB 20 48 0F AF F1 49 0F AF DB 48 89 FD 89 FF 41 89 F5 48 C1 ED 20 48 C1 EE 20 4C 01 ED 4D 89 D5 48 01 DE 4D 0F AF EB 4C 01 ED 4D 89 E5 48 89 EB 48 C1 E5 20 48 C1 EB 20 48 01 EF 48 01 DE 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF F8 4C 0F AF E3 4C 0F AF E8 4C 89 64 24 08 4D 89 FC 4C 0F AF D3 4D 89 E6 45 89 EF 49 C1 EE 20 49 C1 ED 20 4C 03 6C 24 08 4D 01 FE 45 89 E4 4F 8D 3C 16 4D 89 FA 49 C1 E7 20 49 C1 EA 20 4D 01 E7 4D 01 D5 49 89 D2 89 D2 4C 01 EF 48 83 D6 00 49 C1 EA 20 4D 89 D4 4C 89 D5 4C 0F AF E1 48 0F AF CA 49 0F AF EB 45 89 E6 49 C1 EC 20 49 89 CD 89 C9 4C 0F AF DA 49 C1 ED 20 49 01 EC 4D 01 F5 4D 01 EB 4C 89 DD 49 C1 E3 20 48 C1 ED 20 4C 01 D9 49 01 EC 4C 89 D5 48 0F AF E8 48 0F AF C2 48 0F AF D3 41 89 EE 48 C1 ED 20 49 89 C5 89 C0 4C 0F AF D3 49 C1 ED 20 4D 01 F5 49 01 D5 4C 89 EA 49 C1 E5 20 49 01 EA 48 C1 EA 20 4C 01 E8 4C 01 D2 48 01 CA 49 83 D4 00 31 C9 48 01 F8 0F 92 C1 48 01 CA 48 01 D6 41 0F 92 C2 48 39 D1 0F 97 C2 44 09 D2 0F B6 D2 49 01 D4 83 7C 24 04 16 48 8B 15 ?? ?? ?? ?? 0F 8F 13 01 00 00 49 89 F3 4E 23 1C C2 48 8B 15 ?? ?? ?? ?? 46 8B 14 82 BA 40 00 00 00 44 29 D2 89 D1 49 D3 E4 44 89 D1 48 D3 EE 49 09 F4 83 7C 24 04 03 0F 8F 82 02 00 00 48 BA 00 00 00 00 00 00 00 80 48 39 D0 77 0F 0F 85 57 02 00 00 4D 85 FF 0F 84 4E 02 00 00 4D 85 DB 75 2C 48 89 C7 4C 09 FF 74 24 31 D2 49 C1 E0 04 4C 89 C1 48 03 0D ?? ?? ?? ?? 48 3B 41 08 72 0A 0F 84 2D 02 00 00 85 D2 74 04 49 83 EC 01 44 89 E0 F7 D8 4D 85 C9 41 0F 44 C4 E9 00 FB FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 3C C0 41 0F AF FB 89 F8 E9 EA FA FF FF 66 2E 0F 1F 84 00 00 00 00 00 83 F8 0B 0F 8F D7 00 00 00 B9 0B 00 00 00 4C 89 DE 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 34 C1 48 B8 FF FF FF FF 04 00 00 00 48 39 C6 0F 86 FA FB FF FF E9 26 FB FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 E9 63 FD FF FF 0F 1F 80 00 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 E7 4A 23 3C C2 42 8B 0C 81 48 89 FA 83 E9 40 49 D3 EC 48 8B 0D ?? ?? ?? ?? 4A 3B 3C C1 77 41 74 28 48 85 D2 0F 85 38 FF FF FF 48 85 F6 0F 85 2F FF FF FF 48 89 C7 4C 09 FF 0F 84 23 FF FF FF BA 01 00 00 00 E9 FB FE FF FF 48 85 C0 41 0F 95 C2 4D 85 FF 0F 95 C1 41 08 CA 75 05 48 85 F6 74 C1 48 85 D2 0F 85 FD FE FF FF 49 89 F3 E9 C4 FE FF FF 66 0F 1F 44 00 00 83 F8 1E 0F 8F BE 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 0C C1 89 C8 48 C1 E9 20 4C 8D 14 80 48 8D 04 89 4C 89 D3 48 C1 EB 20 48 01 D8 4C 89 D3 48 C1 E3 20 48 39 C2 0F 87 3F FA FF FF 0F 85 08 FB FF FF 49 39 DB 0F 82 FF FA FF FF E9 2B FA FF FF 8D 48 E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 8B 01 48 8B 49 08 48 89 C6 89 C0 48 8D 1C 80 48 C1 EE 20 48 8D 34 B6 4C 8D 14 1B 89 DF 48 C1 EB 20 4C 89 D0 45 89 D2 48 C1 E8 20 48 01 F8 48 8D 04 70 48 89 C7 48 C1 E8 20 48 C1 E7 20 49 01 FA 48 8D 3C 89 48 89 F9 48 C1 E1 1F 48 01 F9 48 8D 34 4E 48 89 D9 48 01 F1 48 01 C8 E9 A2 F9 FF FF 8D 48 E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 4C 8B 11 44 89 D0 49 C1 EA 20 4B 8D 34 92 4C 8B 51 08 48 8D 04 80 48 89 C3 48 C1 E8 20 4B 8D 0C 92 48 C1 E3 20 48 C1 E1 20 48 01 F1 48 01 C8 E9 2C FF FF FF 4C 89 DE E9 9F FE FF FF 4C 3B 39 0F 86 CE FD FF FF E9 C5 FD FF FF 48 8B 15 ?? ?? ?? ?? 4A 8B 14 C2 49 39 D3 0F 87 88 FD FF FF 49 39 D3 4C 89 DE 0F 85 71 FE FF FF 48 89 C7 4C 09 FF 0F 85 70 FD FF FF E9 60 FE FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_7_0 {
	meta:
		name = "__bid128_to_int32_xint"
		size = 2224
		refs = "008d .refptr.__bid_ten2k64 00f3 .refptr.__bid_IDEC_glbflags 012d .refptr.__bid_nr_digits 0341 .refptr.__bid_midpoint128 0366 .refptr.__bid_ten2mk128 04d4 .refptr.__bid_maskhigh128 04f3 .refptr.__bid_shiftright128 054c .refptr.__bid_ten2mk128trunc 0603 .refptr.__bid_midpoint64 0646 .refptr.__bid_onehalf128 0733 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 28 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 C0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 B0 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 9D 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 28 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 83 F8 1E 0F 8F E1 06 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 89 C1 89 C0 48 8D 04 80 48 C1 E9 20 48 8D 1C 89 48 8D 0C 00 89 C6 48 C1 E8 20 49 89 CA 89 C9 49 C1 EA 20 49 01 F2 4D 8D 14 5A 48 01 C3 4C 89 D0 49 C1 E2 20 48 C1 E8 20 49 01 CA 48 01 D8 48 39 C2 77 12 0F 85 D9 00 00 00 4D 39 D3 0F 82 D0 00 00 00 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 6C FF FF FF 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 35 01 00 00 48 85 D2 0F 84 BA 00 00 00 66 0F EF C0 4C 8B 15 ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4D 89 C1 49 C1 E1 05 4D 01 D1 41 8B 01 85 C0 75 22 41 8B 41 18 4D 8B 49 08 4C 39 CA 0F 87 01 01 00 00 4C 39 CA 0F 84 E1 00 00 00 0F 1F 84 00 00 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 46 8D 14 00 41 83 FA 0A 0F 8F 53 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 0A 0F 84 EF 00 00 00 45 85 D2 0F 8E 63 04 00 00 45 85 C0 0F 88 4F 01 00 00 0F 85 B4 00 00 00 44 89 DA 44 89 D8 F7 DA 4D 85 C9 0F 45 C2 E9 91 FE FF FF 90 31 C0 4D 85 DB 0F 84 85 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 F2 00 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 15 ?? ?? ?? ?? 4D 89 C1 49 C1 E1 05 4D 01 D1 41 8B 01 85 C0 0F 85 3B FF FF FF 41 8B 41 18 4D 8B 49 08 E9 1D FF FF FF 31 C0 E9 17 FE FF FF 49 C1 E0 05 4F 39 5C 02 10 0F 87 18 FF FF FF 0F 1F 84 00 00 00 00 00 83 C0 01 E9 08 FF FF FF 0F 1F 84 00 00 00 00 00 4D 85 C9 4D 63 C0 0F 84 17 03 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 42 0F AF 04 C2 E9 CD FD FF FF 4D 85 C9 0F 84 14 03 00 00 83 F8 0B 0F 8F CC FD FF FF B9 0B 00 00 00 4C 89 DB 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 1C C1 48 B8 09 00 00 00 05 00 00 00 48 39 C3 0F 86 DC FE FF FF E9 0A FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 10 FF FF FF 44 89 C0 F7 D8 83 F8 13 89 44 24 0C 0F 8E D9 02 00 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 4D 39 DA 4C 89 C0 4D 89 D4 48 83 D2 00 48 C1 E0 04 45 89 D2 48 89 C3 48 03 1D ?? ?? ?? ?? 49 C1 EC 20 4C 89 D6 48 89 44 24 18 4C 89 E0 4C 89 E5 48 8B 4B 08 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF C1 49 0F AF EB 48 89 F7 89 F6 41 89 C5 48 C1 EF 20 48 C1 E8 20 4C 01 EF 4D 89 D5 48 01 E8 4D 0F AF EB 4C 01 EF 4D 89 D5 48 89 FD 48 C1 E7 20 48 C1 ED 20 48 01 FE 4C 8D 3C 28 48 8B 03 4C 89 E5 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF E8 4C 0F AF E3 48 0F AF E8 4C 89 64 24 10 4D 89 EC 45 89 ED 4C 0F AF D3 49 C1 EC 20 41 89 EE 4D 01 E6 4C 8B 64 24 10 48 C1 ED 20 4D 01 D6 49 01 EC 4D 89 F2 49 C1 E6 20 49 C1 EA 20 4D 01 EE 4D 01 D4 49 89 D2 89 D2 4C 01 E6 49 83 D7 00 49 C1 EA 20 4C 89 D5 4C 89 D7 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 ED 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 EC 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FD 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 EC 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 48 01 CA 48 83 D5 00 48 01 C6 0F 92 C0 0F B6 C0 48 01 C2 49 01 D7 0F 92 C1 48 39 D0 4D 89 FA 0F 97 C0 89 CA 09 C2 48 8B 05 ?? ?? ?? ?? 0F B6 D2 48 01 D5 83 7C 24 0C 16 0F 8F 48 01 00 00 4D 89 FB 4E 23 1C C0 48 8B 05 ?? ?? ?? ?? 42 8B 14 80 B8 40 00 00 00 29 D0 89 C1 48 D3 E5 89 D1 49 D3 EA 4C 09 D5 83 7C 24 0C 03 0F 8F 39 03 00 00 48 B8 00 00 00 00 00 00 00 80 48 39 C6 77 0F 0F 85 E8 01 00 00 4D 85 F6 0F 84 DF 01 00 00 4C 89 C0 48 BA 00 00 00 00 00 00 00 80 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 01 F2 48 3B 50 08 0F 87 AB 01 00 00 0F 84 B2 02 00 00 4D 85 DB 75 2C 48 89 F0 4C 09 F0 74 24 31 C0 49 C1 E0 04 4C 89 C2 48 03 15 ?? ?? ?? ?? 48 3B 72 08 72 0A 0F 84 97 02 00 00 85 C0 74 04 48 83 ED 01 89 E8 F7 D8 4D 85 C9 0F 44 C5 E9 CD FA FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 34 C0 41 0F AF F3 89 F0 E9 B7 FA FF FF 0F 1F 80 00 00 00 00 83 F8 0B 0F 8F CC 00 00 00 B9 0B 00 00 00 4C 89 DB 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 1C C1 48 B8 FF FF FF FF 04 00 00 00 48 39 C3 0F 86 C8 FB FF FF E9 F6 FA FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 E9 33 FD FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 3F FA FF FF 48 89 EA 4A 23 14 C0 48 8B 05 ?? ?? ?? ?? 42 8B 0C 80 48 8B 05 ?? ?? ?? ?? 83 E9 40 48 D3 ED 4A 3B 14 C0 0F 87 A0 01 00 00 0F 84 D1 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 48 85 D2 0F 85 1D FF FF FF 4D 89 D3 4D 85 DB 0F 85 11 FF FF FF 48 89 F0 4C 09 F0 0F 84 05 FF FF FF B8 01 00 00 00 E9 DD FE FF FF 83 F8 1E 0F 8F 88 00 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 0C C1 89 C8 48 C1 E9 20 4C 8D 14 80 48 8D 04 89 4C 89 D3 48 C1 EB 20 48 01 D8 4C 89 D3 48 C1 E3 20 48 39 C2 0F 87 1A FA FF FF 49 39 DB 0F 82 DE FA FF FF 48 39 C2 0F 85 D5 FA FF FF E9 03 FA FF FF 0F 1F 00 4C 89 DB 48 29 C3 49 39 DB 48 89 D8 48 19 D2 48 09 D0 0F 84 71 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 E9 4C FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 E9 50 FF FF FF 8D 48 E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 4C 8B 11 44 89 D0 49 C1 EA 20 4B 8D 34 92 4C 8B 51 08 48 8D 04 80 48 89 C3 48 C1 E8 20 4B 8D 0C 92 48 C1 E3 20 48 C1 E1 20 48 01 F1 48 01 C8 E9 62 FF FF FF 8D 48 E1 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 8B 01 48 8B 49 08 48 89 C6 89 C0 48 8D 1C 80 48 C1 EE 20 48 8D 34 B6 4C 8D 14 1B 89 DF 48 C1 EB 20 4C 89 D0 45 89 D2 48 C1 E8 20 48 01 F8 48 8D 04 70 48 89 C7 48 C1 E8 20 48 C1 E7 20 49 01 FA 48 8D 3C 89 48 89 F9 48 C1 E1 1F 48 01 F9 48 8D 34 4E 48 89 D9 48 01 F1 48 01 C8 E9 FC F8 FF FF 84 C0 75 19 48 8B 44 24 18 48 03 05 ?? ?? ?? ?? 48 3B 70 08 77 07 75 0F 4C 3B 30 76 0A 48 8B 05 ?? ?? ?? ?? 83 08 20 48 85 D2 0F 85 87 FD FF FF 4D 89 D3 E9 4E FD FF FF 4C 3B 30 0F 82 45 FD FF FF E9 E5 FE FF FF 4C 3B 32 0F 86 64 FD FF FF E9 5B FD FF FF 4D 85 FF 0F 95 C0 48 85 F6 41 0F 95 C3 4D 85 F6 0F 95 C1 41 08 CB 75 94 84 C0 0F 84 0F FE FF FF EB A7 48 8B 05 ?? ?? ?? ?? 4A 8B 04 C0 49 39 C3 0F 87 89 FE FF FF 0F 85 AA FE FF FF 48 89 F0 4C 09 F0 0F 84 9E FE FF FF 4C 89 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 3B 70 08 0F 87 77 FE FF FF 0F 85 CC FC FF FF 4C 3B 30 0F 86 C3 FC FF FF E9 63 FE FF FF 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_8_0 {
	meta:
		name = "__bid128_to_int32_rninta"
		size = 1920
		refs = "0092 .refptr.__bid_ten2k64 00f3 .refptr.__bid_IDEC_glbflags 012d .refptr.__bid_nr_digits 01da .refptr.__bid_midpoint128 033f .refptr.__bid_midpoint64 03ea .refptr.__bid_ten2mk128 0551 .refptr.__bid_shiftright128 0682 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 41 08 48 BA 00 00 00 00 00 00 00 78 4C 8B 09 4C 89 C0 48 21 D0 48 39 D0 0F 84 C0 00 00 00 48 BA FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 31 C0 4C 21 C2 48 39 CA 77 22 0F 85 B0 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 0F 86 9D 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 1E 0F 8F E9 05 00 00 41 8D 42 F5 4C 8B 15 ?? ?? ?? ?? 48 98 49 8B 04 C2 41 89 C2 48 C1 E8 20 4F 8D 1C 92 48 8D 04 80 4C 89 DB 45 89 DB 48 C1 EB 20 4E 8D 14 1B 48 01 C3 49 01 C2 4C 89 D0 49 C1 E2 20 48 C1 E8 20 4B 8D 34 1A 48 01 D8 48 39 C2 77 1A 49 39 F1 0F 82 E1 01 00 00 48 39 C2 0F 85 D8 01 00 00 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 6C FF FF FF 48 B8 00 00 00 00 00 00 00 60 4C 89 C1 48 21 C1 48 39 C1 0F 84 53 01 00 00 48 85 D2 0F 84 DA 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 BF 03 00 00 48 89 C8 48 C1 E0 05 4C 01 D8 44 8B 10 45 85 D2 75 23 44 8B 50 18 48 8B 40 08 48 39 C2 0F 87 93 01 00 00 48 39 C2 0F 84 7B 01 00 00 66 0F 1F 84 00 00 00 00 00 4B 8D 0C 00 48 C1 E9 32 81 E9 20 18 00 00 41 8D 04 0A 83 F8 0A 0F 8F 55 FF FF FF 49 BB 00 00 00 00 00 00 00 80 4D 21 D8 83 F8 0A 0F 84 CF 00 00 00 85 C0 0F 88 B7 00 00 00 0F 85 01 01 00 00 41 8D 4A FF 83 F9 12 0F 8E 67 01 00 00 41 8D 4A EC 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 82 88 FE FF FF 0F 84 78 05 00 00 49 83 F8 01 19 C0 83 E0 02 83 E8 01 E9 71 FE FF FF 90 31 C0 4D 85 C9 0F 84 65 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C1 0F 86 F2 00 00 00 66 0F EF D2 4C 89 C9 48 C1 E9 20 F2 48 0F 2A D1 66 48 0F 7E D1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 DE 03 00 00 83 E9 01 4C 8B 1D ?? ?? ?? ?? 48 89 C8 48 C1 E0 05 4C 01 D8 44 8B 10 45 85 D2 0F 85 1D FF FF FF 44 8B 50 18 48 8B 40 08 E9 FE FE FF FF 31 C0 E9 F9 FD FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 C0 0F 84 E7 00 00 00 41 83 FA 0B 0F 8F EE FD FF FF B0 0B 4C 89 CF 44 29 D0 4C 8B 15 ?? ?? ?? ?? 48 98 49 0F AF 3C C2 48 B8 04 00 00 00 05 00 00 00 48 39 C7 0F 87 34 FE FF FF 0F 1F 40 00 85 C9 0F 88 E8 00 00 00 0F 84 87 00 00 00 4D 85 C0 48 63 C9 0F 84 A4 02 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D9 8B 3C C8 41 0F AF F9 89 F8 E9 7E FD FF FF 48 C1 E1 05 4D 39 4C 0B 10 0F 87 7F FE FF FF 41 83 C2 01 E9 76 FE FF FF 66 0F 1F 44 00 00 66 0F EF C9 F2 49 0F 2A C9 66 48 0F 7E C9 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 FE 03 00 00 E9 10 FF FF FF 48 85 D2 0F 85 B2 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 63 C9 4C 39 0C CA 0F 87 20 FD FF FF E9 99 FE FF FF 44 89 C8 F7 D8 4D 85 C0 41 0F 44 C1 E9 0A FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 FA 0B 0F 8F 19 02 00 00 B8 0B 00 00 00 4C 89 CE 44 29 D0 4C 8B 15 ?? ?? ?? ?? 48 98 49 0F AF 34 C2 48 B8 FA FF FF FF 04 00 00 00 48 39 C6 0F 86 1A FF FF FF E9 45 FD FF FF 0F 1F 44 00 00 41 89 CE 41 F7 DE 41 83 FE 13 0F 8F 89 02 00 00 48 8B 05 ?? ?? ?? ?? F7 D1 4C 89 CF 48 63 C9 48 03 3C C8 48 89 F8 4C 39 C8 49 89 CA 49 89 C5 48 83 D2 00 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 89 C0 49 C1 ED 20 48 89 C7 4C 89 EB 4D 89 EC 4D 8B 4A 08 4D 8B 12 4D 89 CB 45 89 C9 49 0F AF F9 49 C1 EB 20 49 0F AF D9 4D 0F AF E3 48 89 FD 89 FF 89 DE 48 C1 ED 20 48 C1 EB 20 48 01 F5 48 89 C6 4C 01 E3 49 0F AF F3 4D 89 EC 48 01 F5 48 89 EE 48 C1 E5 20 48 C1 EE 20 48 01 EF 48 01 DE 4C 89 D3 45 89 D2 48 C1 EB 20 4C 0F AF EB 4D 0F AF E2 4C 89 6C 24 08 49 89 C5 4D 0F AF EA 45 89 E7 49 C1 EC 20 48 0F AF C3 4C 03 64 24 08 49 C1 ED 20 4D 01 FD 4C 01 E8 48 C1 E8 20 4C 01 E0 49 89 D4 89 D2 48 01 F8 48 83 D6 00 49 C1 EC 20 4C 89 E7 4C 89 E5 49 0F AF F9 4C 0F AF CA 49 0F AF EB 41 89 FF 48 C1 EF 20 4D 89 CD 45 89 C9 4C 0F AF DA 49 C1 ED 20 48 01 EF 4D 01 FD 4D 01 EB 4D 89 E5 4D 0F AF EA 4C 89 DD 49 C1 E3 20 4C 0F AF D2 48 C1 ED 20 4D 01 CB 48 0F AF D3 48 01 EF 45 89 EF 49 C1 ED 20 4C 89 D5 45 89 D2 48 C1 ED 20 4C 0F AF E3 49 01 EF 49 8D 1C 17 48 89 DA 48 C1 E3 20 4D 01 EC 48 C1 EA 20 4C 01 D3 4C 01 E2 4C 01 DA 48 83 D7 00 45 31 C9 48 01 C3 41 0F 92 C1 4C 01 CA 48 01 D6 0F 92 C0 49 39 D1 0F 97 C2 09 D0 0F B6 C0 48 01 F8 41 83 FE 16 0F 8F E3 00 00 00 48 8B 15 ?? ?? ?? ?? 44 8B 0C 8A BA 40 00 00 00 44 29 CA 89 D1 48 D3 E0 44 89 C9 48 D3 EE 48 09 C6 89 F0 F7 D8 4D 85 C0 0F 44 C6 E9 F2 FA FF FF 48 8B 05 ?? ?? ?? ?? 8B 34 C8 41 0F AF F1 89 F0 E9 DD FA FF FF 41 83 FA 1E 0F 8F 3A 01 00 00 41 8D 42 F5 4C 8B 15 ?? ?? ?? ?? 48 98 49 8B 04 C2 48 89 C5 89 C0 48 8D 34 85 00 00 00 00 49 89 C3 48 C1 ED 20 49 C1 E3 20 48 8D 1C AD 00 00 00 00 49 29 F3 41 89 F2 49 29 C3 4C 89 D8 45 89 DB 48 C1 E8 20 49 8D 3C 02 49 89 EA 49 C1 E2 20 49 29 DA 4C 89 D0 48 29 E8 4C 8D 14 07 48 89 F0 48 C1 E8 20 48 01 C3 4C 89 D0 49 C1 E2 20 48 C1 E8 20 4D 01 DA 48 01 D8 48 39 C2 0F 87 D3 FA FF FF 0F 85 9D FC FF FF 4D 39 D1 0F 82 94 FC FF FF E9 BF FA FF FF 48 8B 15 ?? ?? ?? ?? 8B 0C 8A 83 E9 40 48 D3 E8 48 89 C6 E9 26 FF FF FF 41 BA EC FF FF FF 4C 89 C8 41 29 CA F7 D1 4D 63 D2 48 63 C9 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 49 03 02 49 03 52 08 E9 62 FD FF FF 41 83 EA 1F 4D 63 D2 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 49 8B 02 4D 8B 52 08 41 89 C3 48 C1 E8 20 4B 8D 1C 9B 48 8D 2C 80 48 89 DF 89 DB 48 C1 EF 20 48 8D 04 1F 48 01 E8 49 89 C3 48 C1 E8 20 49 C1 E3 20 49 8D 34 1B 4F 8D 1C 92 4C 89 DB 48 C1 E3 20 49 01 DB 49 01 EB 49 01 FB 4C 01 D8 E9 FA F9 FF FF 41 8D 42 E1 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 18 48 89 C7 49 89 DC 89 DB 4C 8D 1C 9D 00 00 00 00 49 89 DA 49 C1 EC 20 49 C1 E2 20 4A 8D 2C A5 00 00 00 00 4C 89 E6 4D 29 DA 48 C1 E6 20 49 29 DA 48 29 EE 44 89 DB 4C 89 D0 4C 29 E6 45 89 D2 48 C1 E8 20 49 C1 EB 20 48 01 D8 48 01 F0 48 89 C3 48 C1 E8 20 48 C1 E3 20 49 01 DA 48 8B 5F 08 48 8D 34 9B 48 89 F3 48 C1 E3 20 48 29 F3 48 01 EB 49 01 DB 4C 01 D8 E9 AE FE FF FF 4C 39 09 0F 87 01 F9 FF FF E9 7A FA FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_9_0 {
	meta:
		name = "__bid128_to_int32_xrninta"
		size = 2288
		refs = "008d .refptr.__bid_ten2k64 00e4 .refptr.__bid_IDEC_glbflags 011e .refptr.__bid_nr_digits 01ce .refptr.__bid_midpoint128 0341 .refptr.__bid_midpoint64 03f9 .refptr.__bid_ten2mk128 057c .refptr.__bid_shiftright128 05a3 .refptr.__bid_maskhigh128 05ec .refptr.__bid_ten2mk128trunc 0701 .refptr.__bid_onehalf128 0793 .refptr.__bid_ten2k128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 19 48 8B 49 08 48 BA 00 00 00 00 00 00 00 78 48 89 C8 48 21 D0 48 39 D0 0F 84 B1 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 A1 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C3 0F 86 8E 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 83 F8 1E 0F 8F FB 06 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 89 C1 48 C1 E8 20 4C 8D 14 89 48 8D 04 80 4C 89 D3 45 89 D2 48 C1 EB 20 4A 8D 0C 13 48 01 C3 48 01 C1 48 89 C8 48 C1 E1 20 48 C1 E8 20 4C 01 D1 48 01 D8 48 39 C2 77 0F 0F 85 D8 01 00 00 49 39 CB 0F 82 CF 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 7B FF FF FF 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 D4 01 00 00 48 85 D2 0F 84 E9 00 00 00 66 0F EF C0 4C 8B 15 ?? ?? ?? ?? F2 48 0F 2A C2 66 49 0F 7E C0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4D 89 C1 49 C1 E1 05 4D 01 D1 41 8B 01 85 C0 75 21 41 8B 41 18 4D 8B 49 08 4C 39 CA 0F 87 A0 01 00 00 4C 39 CA 0F 84 80 01 00 00 0F 1F 80 00 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 46 8D 14 00 41 83 FA 0A 0F 8F 54 FF FF FF 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 0A 0F 84 CE 00 00 00 45 85 D2 0F 88 03 02 00 00 0F 85 FD 00 00 00 8D 48 FF 83 F9 12 0F 8E 76 01 00 00 8D 48 EC 31 C0 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 72 12 0F 84 95 06 00 00 49 83 F9 01 19 C0 83 E0 02 83 E8 01 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 77 FE FF FF 0F 1F 80 00 00 00 00 31 C0 4D 85 DB 0F 84 65 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 F2 00 00 00 66 0F EF D2 4D 89 D8 49 C1 E8 20 F2 49 0F 2A D0 66 49 0F 7E D0 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DE 03 00 00 41 83 E8 01 4C 8B 15 ?? ?? ?? ?? 4D 89 C1 49 C1 E1 05 4D 01 D1 41 8B 01 85 C0 0F 85 0B FF FF FF 41 8B 41 18 4D 8B 49 08 E9 EE FE FF FF 4D 85 C9 0F 84 F6 00 00 00 83 F8 0B 0F 8F FD FD FF FF B9 0B 00 00 00 4C 89 DE 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 34 C1 48 B8 04 00 00 00 05 00 00 00 48 39 C6 0F 87 31 FE FF FF 45 85 C0 0F 88 08 01 00 00 0F 84 A1 00 00 00 4D 85 C9 4D 63 C0 0F 84 4D 03 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 D8 48 F7 D8 42 0F AF 04 C2 E9 8E FD FF FF 31 C0 E9 87 FD FF FF 49 C1 E0 05 4F 39 5C 02 10 0F 87 78 FE FF FF 0F 1F 84 00 00 00 00 00 83 C0 01 E9 68 FE FF FF 0F 1F 84 00 00 00 00 00 66 0F EF C9 F2 49 0F 2A CB 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FE 03 00 00 E9 10 FF FF FF 48 85 D2 0F 85 A0 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 63 C9 31 C0 4C 39 1C CA 0F 87 96 FE FF FF E9 85 FE FF FF 0F 1F 80 00 00 00 00 44 89 D8 F7 D8 4D 85 C9 41 0F 44 C3 E9 FF FC FF FF 83 F8 0B 0F 8F B4 02 00 00 B9 0B 00 00 00 4C 89 DE 29 C1 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 0F AF 34 C1 48 B8 FA FF FF FF 04 00 00 00 48 39 C6 0F 86 0A FF FF FF E9 36 FD FF FF 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 AF FC FF FF 45 89 C5 41 F7 DD 41 83 FD 13 0F 8F FF 02 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 DA 4D 63 C0 4E 03 14 C0 4D 39 DA 4C 89 C0 4C 89 D5 48 83 D2 00 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 45 89 D2 48 C1 ED 20 4C 89 D6 48 89 EB 49 89 EC 4D 89 D7 48 8B 48 08 48 8B 00 49 89 CB 89 C9 48 0F AF F1 49 C1 EB 20 48 0F AF D9 4D 0F AF E3 48 89 F7 89 F6 41 89 DE 48 C1 EF 20 48 C1 EB 20 4C 01 F7 4D 89 D6 4C 01 E3 4D 0F AF F3 4C 01 F7 49 89 FC 48 C1 E7 20 49 C1 EC 20 48 01 FE 4C 01 E3 49 89 EC 48 89 1C 24 48 89 C3 89 C0 48 C1 EB 20 4C 0F AF F8 48 0F AF EB 4C 0F AF E0 48 89 6C 24 08 4C 89 FD 4C 0F AF D3 49 89 EE 45 89 E7 49 C1 EE 20 49 C1 EC 20 4C 03 64 24 08 4D 01 FE 89 ED 4F 8D 3C 16 49 89 D6 89 D2 4D 89 FA 49 C1 E7 20 49 C1 EA 20 49 01 EF 4D 01 D4 4C 01 E6 48 83 14 24 00 49 C1 EE 20 4C 89 F5 4C 89 F7 4D 89 F2 48 0F AF E9 48 0F AF CA 49 0F AF FB 41 89 EE 48 C1 ED 20 49 89 CC 89 C9 4C 0F AF DA 49 C1 EC 20 48 01 FD 4D 01 F4 4D 01 E3 4C 89 DF 49 C1 E3 20 48 C1 EF 20 4C 01 D9 48 01 FD 4C 89 D7 48 0F AF F8 48 0F AF C2 48 0F AF D3 41 89 FE 48 C1 EF 20 49 89 C4 89 C0 4C 0F AF D3 49 C1 EC 20 4D 01 F4 49 01 D4 4C 89 E2 49 C1 E4 20 49 01 FA 48 C1 EA 20 4C 01 E0 4C 01 D2 4C 8B 14 24 48 01 CA 48 83 D5 00 31 C9 48 01 F0 0F 92 C1 48 01 CA 49 01 D2 41 0F 92 C3 48 39 D1 0F 97 C2 44 09 DA 0F B6 D2 48 01 D5 41 83 FD 16 0F 8F E8 01 00 00 48 8B 15 ?? ?? ?? ?? 46 8B 1C 82 BA 40 00 00 00 44 29 DA 89 D1 4C 89 D2 48 D3 E5 44 89 D9 45 31 DB 48 D3 EA 48 09 D5 48 8B 15 ?? ?? ?? ?? 4E 23 14 C2 89 EA F7 DA 4D 85 C9 0F 45 EA 41 83 FD 03 0F 8F 3B 01 00 00 48 BA 00 00 00 00 00 00 00 80 48 39 D0 77 07 75 37 4D 85 FF 74 32 48 BA 00 00 00 00 00 00 00 80 49 C1 E0 04 48 01 D0 4C 89 C2 48 03 15 ?? ?? ?? ?? 48 3B 42 08 77 11 89 E8 0F 85 72 FA FF FF 4C 3B 3A 0F 82 69 FA FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 89 E8 E9 58 FA FF FF 48 8B 05 ?? ?? ?? ?? 42 8B 34 C0 41 0F AF F3 89 F0 E9 42 FA FF FF 83 F8 1E 0F 8F AF 01 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 0B 48 98 48 8B 04 C1 48 89 C5 89 C0 48 8D 34 85 00 00 00 00 49 89 C2 48 C1 ED 20 49 C1 E2 20 48 8D 1C AD 00 00 00 00 49 29 F2 89 F1 49 29 C2 4C 89 D0 45 89 D2 48 C1 E8 20 48 8D 3C 01 48 89 E9 48 C1 E1 20 48 29 D9 48 89 C8 48 29 E8 48 8D 0C 07 48 89 F0 48 C1 E8 20 48 01 C3 48 89 C8 48 C1 E1 20 48 C1 E8 20 4C 01 D1 48 01 D8 48 39 C2 0F 87 2C FA FF FF 49 39 CB 0F 82 F2 FB FF FF 48 39 C2 0F 85 E9 FB FF FF E9 15 FA FF FF 0F 1F 40 00 B8 EC FF FF FF 4D 89 DA 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 10 48 03 50 08 E9 EB FC FF FF 41 83 FD 16 48 8B 15 ?? ?? ?? ?? 0F 8F 76 01 00 00 4D 85 DB 4A 8B 14 C2 0F 85 BA 01 00 00 49 39 D2 0F 87 B1 01 00 00 0F 85 E0 FE FF FF 48 89 C6 4C 09 FE 0F 84 D4 FE FF FF 49 C1 E0 04 4C 89 C2 48 03 15 ?? ?? ?? ?? 48 3B 42 08 0F 87 BC FE FF FF 89 E8 0F 85 1D F9 FF FF 4C 3B 3A 0F 86 14 F9 FF FF E9 A6 FE FF FF 48 8B 15 ?? ?? ?? ?? 49 89 EB 4E 23 1C C2 48 8B 15 ?? ?? ?? ?? 42 8B 0C 82 83 E9 40 48 D3 ED E9 26 FE FF FF 44 8D 50 E1 4D 63 D2 49 C1 E2 04 4C 03 15 ?? ?? ?? ?? 49 8B 02 4D 8B 52 08 89 C1 48 C1 E8 20 4F 8D 14 92 48 8D 0C 89 48 8D 3C 80 48 89 CE 89 C9 48 C1 EE 20 48 8D 04 0E 48 01 F8 48 89 C3 48 C1 E8 20 48 C1 E3 20 48 01 D9 4C 89 D3 48 C1 E3 20 49 01 DA 49 01 FA 49 01 F2 4C 01 D0 E9 E7 F8 FF FF 83 E8 1F 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 08 48 89 C7 48 89 CB 89 C9 4C 8D 14 8D 00 00 00 00 48 89 C8 48 C1 EB 20 48 C1 E0 20 48 8D 2C 9D 00 00 00 00 4C 29 D0 44 89 D6 49 C1 EA 20 48 29 C8 48 89 C1 48 C1 E8 20 48 01 F0 48 89 DE 89 C9 48 C1 E6 20 48 29 EE 48 29 DE 48 01 F0 48 89 C3 48 C1 E8 20 48 C1 E3 20 48 01 D9 48 8B 5F 08 48 8D 34 9B 48 89 F3 48 C1 E3 20 48 29 F3 48 01 EB 49 01 DA 4C 01 D0 E9 39 FE FF FF 4C 39 19 0F 87 6E F9 FF FF E9 5D F9 FF FF 4E 3B 1C C2 0F 87 7C FD FF FF 0F 85 76 FD FF FF 4D 85 D2 0F 95 C2 48 85 C0 41 0F 95 C1 4D 85 FF 0F 95 C1 41 08 C9 0F 84 5A FD FF FF 84 D2 0F 85 52 FD FF FF 4C 89 C2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 3B 42 08 0F 87 3A FD FF FF E9 79 FE FF FF 4C 89 D6 48 29 D6 49 39 F2 49 83 DB 00 49 09 F3 0F 85 1F FD FF FF E9 46 FE FF FF 90 90 90 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__subtf3"
		size = 4704
		refs = "074b __sfp_handle_exceptions"
	strings:
		$1 = { 41 55 41 54 55 57 56 53 48 83 EC 68 0F 29 74 24 50 48 89 C8 66 0F 6F 02 C7 44 24 4C 00 00 00 00 66 41 0F 6F 08 0F 29 44 24 20 0F 29 4C 24 30 0F AE 5C 24 4C 48 B9 FF FF FF FF FF FF 00 00 4C 8B 4C 24 28 48 8B 54 24 20 4C 8B 6C 24 30 4C 89 CF 4D 89 C8 49 C1 E9 3F 48 21 CF 45 89 CB 45 0F B6 D1 4C 8D 0C FD 00 00 00 00 48 89 D7 4D 89 EC 48 C1 EF 3D 49 C1 E8 30 49 C1 EC 3D 4C 09 CF 4C 8B 4C 24 38 66 41 81 E0 FF 7F 48 C1 E2 03 49 C1 E5 03 41 0F B7 F0 4C 89 CB 4C 21 C9 49 C1 E9 3F 48 C1 EB 30 48 C1 E1 03 66 81 E3 FF 7F 49 09 CC 0F B7 EB 48 81 FD FF 7F 00 00 0F 84 42 03 00 00 49 83 F1 01 45 0F B7 C0 0F B7 DB 41 29 D8 4D 39 CA 0F 84 8A 02 00 00 41 83 F8 00 0F 8E 20 05 00 00 48 85 ED 75 2B 4C 89 E3 4C 09 EB 0F 84 2F 03 00 00 41 83 E8 01 0F 85 E5 06 00 00 4C 29 EA 4C 19 E7 BB 02 00 00 00 EB 76 0F 1F 84 00 00 00 00 00 48 81 FE FF 7F 00 00 0F 84 63 03 00 00 48 B9 00 00 00 00 00 00 08 00 31 DB 49 09 CC 41 83 F8 74 0F 8F FC 05 00 00 41 83 F8 3F 0F 8F 30 07 00 00 41 BB 40 00 00 00 4D 89 E1 4C 89 ED 45 29 C3 44 89 D9 49 D3 E1 44 89 C1 48 D3 ED 44 89 D9 49 D3 E5 49 09 E9 31 C9 4D 85 ED 0F 95 C1 49 09 C9 44 89 C1 49 D3 EC 4C 89 E1 4C 29 CA 48 19 CF 48 B9 00 00 00 00 00 00 08 00 48 85 CF 0F 84 33 04 00 00 49 BB FF FF FF FF FF FF 07 00 49 21 FB 4D 85 DB 0F 84 7A 05 00 00 4D 0F BD C3 41 83 F0 3F 41 8D 68 F4 83 FD 3F 0F 8F 54 05 00 00 89 E9 4C 89 DF 49 89 D1 48 D3 E7 B9 4C 00 00 00 44 29 C1 49 D3 E9 89 E9 4C 09 CF 48 D3 E2 4C 63 C5 4C 39 C6 0F 8F CE 03 00 00 89 E9 29 F1 44 8D 41 01 41 83 F8 3F 0F 8F 38 06 00 00 41 B9 40 00 00 00 44 89 C1 49 89 D3 45 29 C1 49 D3 EB 48 89 FE 44 89 C9 48 D3 E6 44 89 C9 48 D3 E2 49 09 F3 44 89 C1 48 85 D2 0F 95 C2 48 D3 EF 31 F6 0F B6 D2 4C 09 DA 49 89 D0 41 83 E0 07 66 0F 1F 84 00 00 00 00 00 4D 85 C0 74 2D 8B 4C 24 4C 83 CB 20 81 E1 00 60 00 00 81 F9 00 20 00 00 0F 84 33 04 00 00 81 F9 00 40 00 00 0F 84 77 04 00 00 85 C9 0F 84 EE 03 00 00 48 B9 00 00 00 00 00 00 08 00 45 89 D3 48 21 F9 41 83 E3 01 48 85 F6 0F 85 11 02 00 00 48 89 FE 48 09 D6 74 0F F6 C3 20 75 07 F6 44 24 4D 08 74 03 83 CB 10 48 85 C9 0F 85 D1 02 00 00 48 89 F9 48 C1 E7 0D 48 C1 EA 03 48 C1 E1 3D 49 89 F9 45 31 C0 48 09 CA 49 C1 E9 10 0F 1F 44 00 00 48 C7 44 24 28 00 00 00 00 48 8B 4C 24 28 49 BA FF FF FF FF FF FF 00 00 48 89 54 24 20 48 BA 00 00 00 00 00 00 FF FF 4D 21 D1 41 81 E0 FF 7F 00 00 45 0F B6 DB 48 21 CA 48 B9 FF FF FF FF FF FF 00 80 49 C1 E0 30 4C 09 CA 49 C1 E3 3F 48 21 CA 48 B9 FF FF FF FF FF FF FF 7F 4C 09 C2 48 21 CA 4C 09 DA 85 DB 48 89 54 24 28 66 0F 6F 74 24 20 0F 85 FD 03 00 00 0F 29 30 0F 28 74 24 50 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D C3 0F 1F 44 00 00 41 83 F8 00 0F 8E F6 03 00 00 48 85 ED 0F 84 BD 00 00 00 48 81 FE FF 7F 00 00 0F 84 00 01 00 00 48 B9 00 00 00 00 00 00 08 00 31 DB 49 09 CC 41 83 F8 74 0F 8E C7 05 00 00 45 31 C9 4D 09 EC 41 0F 95 C1 31 C9 4C 01 CA 48 11 CF 48 B9 00 00 00 00 00 00 08 00 48 85 CF 0F 84 06 02 00 00 48 83 C6 01 48 81 FE FF 7F 00 00 0F 84 42 08 00 00 48 B9 FF FF FF FF FF FF F7 FF 48 21 CF 48 89 D1 48 D1 EA 83 E1 01 48 09 CA 48 89 F9 48 D1 EF 48 C1 E1 3F 48 09 CA 49 89 D0 41 83 E0 07 E9 3F FE FF FF 4C 89 E1 4C 09 E9 0F 84 B2 FC FF FF 45 0F B6 C9 E9 AD FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 81 FE FF 7F 00 00 74 57 31 DB E9 42 FE FF FF 4C 89 E3 4C 09 EB 74 E8 41 83 E8 01 0F 84 DE 05 00 00 48 81 FE FF 7F 00 00 BB 02 00 00 00 0F 85 3B FF FF FF 48 89 F9 48 09 D1 0F 84 ED 09 00 00 48 B9 00 00 00 00 00 00 04 00 48 21 F9 48 83 F9 01 19 DB F7 D3 83 C3 03 E9 F5 FD FF FF 0F 1F 00 48 89 FB 48 09 D3 0F 84 44 05 00 00 48 89 FB 48 C1 EB 32 48 83 F3 01 83 E3 01 E9 D3 FD FF FF 90 48 85 C9 0F 84 97 00 00 00 4C 8D 46 01 49 81 F8 FF 7F 00 00 0F 85 CC 00 00 00 8B 4C 24 4C 81 E1 00 60 00 00 0F 84 F6 02 00 00 81 F9 00 40 00 00 0F 84 6A 06 00 00 81 F9 00 20 00 00 0F 84 4E 05 00 00 41 B8 FE 7F 00 00 48 C7 C2 FF FF FF FF 48 BF FF FF FF FF FF FF FF 1F BE FE 7F 00 00 E9 CC 02 00 00 4C 89 E6 4C 09 EE 0F 85 D6 0A 00 00 48 89 FE 48 09 D6 0F 85 BE 08 00 00 BE FF 7F 00 00 41 BB 01 00 00 00 48 BF 00 00 00 00 00 00 04 00 BB 01 00 00 00 31 D2 66 0F 1F 84 00 00 00 00 00 48 89 F9 48 C1 EA 03 41 89 F0 48 C1 E1 3D 48 C1 EF 03 66 41 81 E0 FF 7F 48 09 CA 48 81 FE FF 7F 00 00 74 6C 49 B9 FF FF FF FF FF FF 00 00 49 21 F9 E9 5A FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 B8 01 00 00 00 49 B9 FF FF FF FF FF FF F7 FF 48 C1 EA 03 66 41 81 E0 FF 7F 49 21 F9 4C 89 C9 49 C1 E1 0D 48 C1 E1 3D 49 C1 E9 10 48 09 CA E9 1C FD FF FF 49 B9 FF FF FF FF FF FF F7 FF 4C 29 C6 4C 21 CF 49 89 D0 41 83 E0 07 E9 70 FC FF FF 48 89 FE 48 09 D6 74 78 49 B9 00 00 00 00 00 80 00 00 48 B9 FF FF FF FF FF FF 00 00 49 09 F9 49 21 C9 E9 D9 FC FF FF 66 0F 1F 84 00 00 00 00 00 0F 85 9A 02 00 00 48 8D 4E 01 81 E1 FF 7F 00 00 48 83 F9 01 0F 8E 87 04 00 00 49 B8 00 00 00 00 00 00 08 00 49 89 FB 48 89 D1 4C 29 E9 4D 19 E3 4D 85 C3 0F 84 F7 02 00 00 4D 89 E3 4D 89 CA 31 DB 49 29 D5 49 19 FB 4C 89 EA E9 4F FB FF FF 90 45 31 C9 31 D2 E9 76 FC FF FF 66 0F 1F 44 00 00 48 89 D1 83 E1 0F 48 83 F9 04 0F 84 02 FC FF FF 48 B9 00 00 00 00 00 00 08 00 45 89 D3 48 83 C2 04 48 83 D7 00 41 83 E3 01 48 21 F9 E9 F5 FB FF FF 4D 85 D2 0F 84 77 01 00 00 48 83 C2 08 48 83 D7 00 E9 CB FB FF FF 81 FA 00 40 00 00 0F 84 CD 0A 00 00 81 FA 00 20 00 00 0F 84 38 01 00 00 81 FA 00 40 00 00 BB 28 00 00 00 0F 85 EE FD FF FF 48 83 CF FF BE FE 7F 00 00 BB 28 00 00 00 48 89 FA 4D 85 D2 0F 85 88 FB FF FF 48 B9 00 00 00 00 00 00 08 00 45 31 DB 48 83 C2 08 48 83 D7 00 48 21 F9 E9 7F FB FF FF 66 0F 1F 84 00 00 00 00 00 41 8D 48 B4 48 89 D7 31 D2 48 D3 E7 E9 B9 FA FF FF 4C 0F BD C2 49 83 F0 3F 41 83 C0 40 E9 7D FA FF FF 45 31 C9 4D 09 EC 41 0F 95 C1 31 C9 E9 35 FA FF FF 89 D9 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 E9 ED FB FF FF 0F 1F 80 00 00 00 00 0F 85 9F 03 00 00 4C 8D 4E 01 4C 89 C9 81 E1 FF 7F 00 00 48 83 F9 01 0F 8E F3 02 00 00 48 89 D1 4C 01 E9 4C 11 E7 49 81 F9 FF 7F 00 00 0F 84 32 05 00 00 48 89 FA 49 89 C8 48 D1 EF 48 C1 E2 3F 49 D1 E8 4C 89 CE 49 09 D0 48 89 CA 31 DB 83 E2 01 4C 09 C2 49 89 D0 41 83 E0 07 E9 80 FA FF FF 41 B8 FF 7F 00 00 31 D2 31 FF BE FF 7F 00 00 83 CB 28 E9 84 FD FF FF 66 0F 1F 84 00 00 00 00 00 48 81 FE FF 7F 00 00 BB 02 00 00 00 0F 85 3A F9 FF FF E9 5D FC FF FF 4D 85 D2 0F 85 1E 0A 00 00 48 83 CF FF BE FE 7F 00 00 BB 28 00 00 00 48 89 FA 48 B9 00 00 00 00 00 00 08 00 45 31 DB 45 31 D2 48 21 F9 E9 5D FA FF FF 0F 1F 80 00 00 00 00 41 8D 48 C0 49 89 F9 49 D3 E9 31 C9 41 83 F8 40 74 0B B1 80 44 29 C1 48 D3 E7 48 89 F9 48 09 D1 0F 95 C2 31 FF 31 F6 0F B6 D2 4C 09 CA 49 89 D0 41 83 E0 07 E9 D7 F9 FF FF 0F 1F 80 00 00 00 00 41 8D 48 C0 4D 89 E1 49 D3 E9 31 C9 41 83 F8 40 74 0B B1 80 44 29 C1 49 D3 E4 4C 89 E1 4C 09 E9 0F 95 C1 0F B6 C9 49 09 C9 31 C9 E9 D8 F8 FF FF 48 85 F6 0F 84 37 01 00 00 48 81 FD FF 7F 00 00 0F 84 FA 00 00 00 48 B9 00 00 00 00 00 00 08 00 41 F7 D8 31 DB 48 09 CF 41 83 F8 74 0F 8F BE 03 00 00 41 83 F8 3F 0F 8F 78 05 00 00 41 BB 40 00 00 00 49 89 FA 48 89 D6 45 29 C3 44 89 D9 49 D3 E2 44 89 C1 48 D3 EE 44 89 D9 48 D3 E2 49 09 F2 44 89 C1 48 85 D2 0F 95 C2 48 D3 EF 0F B6 D2 48 89 F9 49 09 D2 4C 89 E7 4C 89 EA 48 89 EE 4C 29 D2 48 19 CF 4D 89 CA E9 52 F8 FF FF 0F 1F 40 00 48 89 CB 4C 09 DB 0F 85 D4 00 00 00 8B 54 24 4C 81 E2 00 60 00 00 81 FA 00 20 00 00 41 0F 94 C3 31 FF 31 DB 31 C9 31 D2 E9 32 F9 FF FF 0F 1F 00 41 83 F8 3F 0F 8F 6B 01 00 00 41 BB 40 00 00 00 4D 89 E1 4C 89 ED 45 29 C3 44 89 D9 49 D3 E1 44 89 C1 48 D3 ED 44 89 D9 49 D3 E5 49 09 E9 31 C9 4D 85 ED 0F 95 C1 49 09 C9 44 89 C1 49 D3 EC 4C 89 E1 E9 FE F9 FF FF 66 0F 1F 84 00 00 00 00 00 4C 89 E6 4C 09 EE 0F 85 30 06 00 00 45 89 CB 41 83 E3 01 BE FF 7F 00 00 0F 1F 84 00 00 00 00 00 31 FF 31 DB 31 D2 E9 65 FB FF FF 0F 1F 44 00 00 48 89 FE 48 09 D6 0F 85 74 02 00 00 48 81 FD FF 7F 00 00 74 BB 4C 89 E7 4C 89 EA 48 89 EE 4D 89 CA 31 DB E9 6A F8 FF FF 0F 1F 84 00 00 00 00 00 48 89 CA 31 DB E9 84 F7 FF FF 66 0F 1F 44 00 00 4C 01 EA 4C 11 E7 BB 02 00 00 00 E9 7B F9 FF FF 49 83 FA 01 B9 00 00 00 00 48 BF FF FF FF FF FF FF FF 1F 45 19 C0 66 41 81 C0 FF 7F 49 83 FA 01 48 19 D2 4D 85 D2 48 0F 45 F9 48 8D B2 FF 7F 00 00 E9 69 FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 85 F6 0F 85 6C 03 00 00 48 89 FB 48 09 D3 4C 89 E3 0F 85 E0 04 00 00 4C 09 EB 0F 84 BF FE FF FF 4C 89 E7 4C 89 EA BB 02 00 00 00 E9 D1 F7 FF FF 48 85 F6 0F 85 D6 00 00 00 48 89 FB 48 09 D3 4C 89 E3 0F 85 B7 02 00 00 4C 09 EB 0F 84 7A FE FF FF 4C 89 E7 4C 89 EA 4D 89 CA BB 02 00 00 00 E9 9D F7 FF FF 41 8D 48 C0 4D 89 E1 49 D3 E9 31 C9 41 83 F8 40 74 0B B1 80 44 29 C1 49 D3 E4 4C 89 E1 4C 09 E9 0F 95 C1 0F B6 C9 49 09 C9 31 C9 E9 A0 F8 FF FF 48 85 F6 0F 85 E2 01 00 00 48 89 FE 48 09 D6 0F 85 C3 03 00 00 48 81 FD FF 7F 00 00 0F 84 CB 05 00 00 4C 89 E7 4C 89 EA 48 89 EE 31 DB E9 3B F7 FF FF 66 0F 1F 84 00 00 00 00 00 49 83 FA 01 B9 00 00 00 00 48 BF FF FF FF FF FF FF FF 1F 45 19 C0 41 F7 D0 66 41 81 C0 FF 7F 49 83 FA 01 48 19 D2 4D 85 D2 48 F7 D2 48 0F 44 F9 48 8D B2 FF 7F 00 00 E9 53 FC FF FF 0F 1F 40 00 48 81 FE FF 7F 00 00 0F 84 F7 02 00 00 48 81 FD FF 7F 00 00 0F 84 69 F9 FF FF 48 89 FE 48 09 D6 0F 84 FB 00 00 00 31 DB 4C 89 E6 4C 09 EE 0F 84 27 02 00 00 48 89 F9 4D 89 E0 48 C1 EA 03 48 C1 E1 3D 48 C1 EF 03 49 C1 E8 03 48 09 CA 4C 39 C7 77 23 4C 89 E1 49 C1 ED 03 48 C1 E1 3D 4C 09 E9 48 39 CA 0F 86 CC 05 00 00 4C 39 C7 4C 89 C7 0F 85 C0 05 00 00 48 89 D1 48 C1 E7 03 48 C1 E2 03 48 C1 E9 3D BE FF 7F 00 00 48 09 CF E9 61 F6 FF FF 8B 4C 24 4C 81 E1 00 60 00 00 0F 84 9A 01 00 00 81 F9 00 40 00 00 0F 84 26 04 00 00 81 F9 00 20 00 00 0F 84 96 04 00 00 41 B8 07 00 00 00 48 C7 C2 FF FF FF FF BE FE 7F 00 00 83 CB 28 48 89 D7 E9 EA F5 FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 F0 FF 0F 85 B9 01 00 00 49 29 D5 49 19 FC 48 89 EE 4C 89 EA 4C 89 E7 4D 89 CA BB 02 00 00 00 E9 F8 F4 FF FF 66 2E 0F 1F 84 00 00 00 00 00 45 31 D2 48 09 D7 41 0F 95 C2 31 C9 E9 74 FC FF FF 4C 89 E2 4C 09 EA 48 85 D2 0F 84 FD 02 00 00 31 DB 4C 89 E7 4C 89 EA 4D 89 CA BE FF 7F 00 00 E9 AD F5 FF FF 8B 4C 24 4C 89 CA 81 E2 00 60 00 00 0F 85 D0 F9 FF FF BE FF 7F 00 00 31 FF BB 28 00 00 00 31 D2 E9 56 F8 FF FF 66 0F 1F 44 00 00 48 81 FD FF 7F 00 00 0F 84 F5 03 00 00 48 B9 00 00 00 00 00 00 08 00 41 F7 D8 31 DB 48 09 CF 41 83 F8 74 0F 8F E4 01 00 00 41 83 F8 3F 0F 8F 7C 03 00 00 41 BB 40 00 00 00 49 89 F9 48 89 D6 45 29 C3 44 89 D9 49 D3 E1 44 89 C1 48 D3 EE 44 89 D9 48 D3 E2 49 09 F1 44 89 C1 48 85 D2 0F 95 C2 48 D3 EF 0F B6 D2 48 89 F9 49 09 D1 4C 89 E7 4C 89 EA 48 89 EE 4C 01 CA 48 11 CF E9 3B F6 FF FF 4C 09 EB 0F 84 A0 00 00 00 49 B8 00 00 00 00 00 00 08 00 48 89 F9 49 89 D3 4D 29 EB 4C 19 E1 4C 85 C1 0F 84 E4 02 00 00 4C 89 E1 4D 89 CA BB 02 00 00 00 49 29 D5 48 19 F9 4D 89 E8 48 89 CF 4C 89 EA 41 83 E0 07 E9 85 F4 FF FF 45 31 C0 31 D2 E9 86 FE FF FF 4C 89 E6 4C 09 EE 0F 85 E0 03 00 00 48 89 FE 48 09 D6 74 2E 31 DB BE FF 7F 00 00 E9 8D F4 FF FF 48 81 FE FF 7F 00 00 0F 84 2A 03 00 00 48 81 FD FF 7F 00 00 74 CA 48 89 FE 48 09 D6 0F 85 07 01 00 00 4C 89 E7 4C 89 EA BE FF 7F 00 00 31 DB E9 59 F4 FF FF BB 02 00 00 00 E9 4F F4 FF FF 48 81 FD FF 7F 00 00 BB 02 00 00 00 0F 85 93 FA FF FF 4C 89 E6 4C 09 EE 0F 85 F4 03 00 00 45 89 CB 41 83 E3 01 BE FF 7F 00 00 31 FF E9 E1 F6 FF FF 41 8D 48 C0 49 89 FA 49 D3 EA 31 C9 41 83 F8 40 74 0B B1 80 44 29 C1 48 D3 E7 48 89 F9 48 09 D1 0F 95 C2 31 C9 0F B6 D2 49 09 D2 E9 91 FA FF FF 48 89 FB 48 09 D3 0F 84 3C 01 00 00 48 89 FB 48 C1 EB 32 48 83 F3 01 83 E3 01 48 81 FD FF 7F 00 00 0F 85 FD FC FF FF 4C 89 E6 4C 09 EE 0F 84 24 FF FF FF 48 B9 00 00 00 00 00 00 04 00 48 89 FE 49 85 CC B9 01 00 00 00 0F 44 D9 48 09 D6 0F 84 DA FD FF FF E9 D7 FC FF FF 41 83 F0 FF 0F 85 26 01 00 00 49 01 D5 4C 11 E7 48 89 EE 4C 89 EA BB 02 00 00 00 E9 AE F4 FF FF 45 31 C9 48 09 D7 41 0F 95 C1 31 C9 E9 4E FE FF FF 31 DB 4C 89 E6 4C 09 EE 0F 84 BF FE FF FF 48 89 F9 4D 89 E0 48 C1 EA 03 48 C1 E1 3D 48 C1 EF 03 49 C1 E8 03 48 09 CA 4C 39 C7 0F 87 B7 FC FF FF 4C 89 E1 49 C1 ED 03 48 C1 E1 3D 4C 09 E9 48 39 CA 76 0C 4C 39 C7 4C 89 C7 0F 84 98 FC FF FF 4C 89 C7 48 89 CA E9 8D FC FF FF 4C 09 EB 0F 84 A8 FE FF FF 48 B9 00 00 00 00 00 00 08 00 4C 01 EA 4C 11 E7 48 85 CF 0F 84 6F 02 00 00 48 B9 FF FF FF FF FF FF F7 FF 49 89 D0 BE 01 00 00 00 48 21 CF 41 83 E0 07 BB 02 00 00 00 E9 93 F2 FF FF 41 BB 01 00 00 00 48 BF 00 00 00 00 00 00 04 00 BE FF 7F 00 00 BB 01 00 00 00 E9 69 F5 FF FF 48 81 FD FF 7F 00 00 0F 85 C8 FC FF FF 4C 89 E3 4C 09 EB 0F 84 3B F5 FF FF 31 DB E9 CB FE FF FF 4C 89 E3 4C 89 E7 4C 89 EA 48 C1 EB 32 BE FF 7F 00 00 4D 89 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__clzti2"
		size = 48
	strings:
		$1 = { 48 8B 41 08 4C 8B 01 31 C9 48 85 C0 48 89 C2 75 08 4C 89 C2 B9 40 00 00 00 48 0F BD C2 48 83 F0 3F 01 C8 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__subvdi3"
		size = 48
		refs = "0029 abort"
	strings:
		$1 = { 48 83 EC 28 48 89 C8 48 29 D0 48 85 D2 78 11 48 39 C8 0F 9F C2 84 D2 75 0F 48 83 C4 28 C3 66 90 48 39 C8 0F 9C C2 EB ED E8 ?? ?? ?? ?? 90 66 90 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__subvsi3"
		size = 48
		refs = "0028 abort"
	strings:
		$1 = { 48 83 EC 28 89 C8 29 D0 85 D2 78 14 39 C8 0F 9F C2 84 D2 75 12 48 83 C4 28 C3 66 0F 1F 44 00 00 39 C8 0F 9C C2 EB EA E8 ?? ?? ?? ?? 90 90 90 90 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "__floattisf"
		size = 224
		refs = "00a4 .rdata"
	strings:
		$1 = { 4C 8B 09 4C 8B 51 08 4C 89 C8 48 99 4C 39 D2 0F 84 9B 00 00 00 4C 89 D0 48 99 48 31 D0 48 29 D0 48 0F BD C0 48 83 F0 3F 85 C0 74 74 48 98 41 B8 41 00 00 00 4C 89 D2 49 29 C0 4C 89 C8 44 89 C1 66 0F EF C9 4C 0F AD D0 48 D3 FA 41 F6 C0 40 B9 40 00 00 00 48 0F 45 C2 44 29 C1 48 89 C2 49 D3 E1 48 83 CA 01 4D 85 C9 48 0F 45 C2 49 83 F8 40 F3 48 0F 2A C8 74 49 49 83 F8 3F 74 53 66 0F EF C0 B8 01 00 00 00 44 89 C1 48 D3 E0 F3 48 0F 2A C0 F3 0F 59 C1 C3 66 2E 0F 1F 84 00 00 00 00 00 F3 0F 10 05 ?? ?? ?? ?? C3 0F 1F 80 00 00 00 00 66 0F EF C0 F3 49 0F 2A C1 C3 66 0F 1F 44 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C1 C3 0F 1F 00 F3 0F 10 05 ?? ?? ?? ?? EB B7 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__fixunsxfdi"
		size = 128
		refs = "0008 .rdata"
	strings:
		$1 = { 48 83 EC 18 DB 29 D9 05 ?? ?? ?? ?? D9 C9 DB E9 73 2E DD D9 D9 7C 24 0E 0F B7 44 24 0E 80 CC 0C 66 89 44 24 0C D9 6C 24 0C DF 3C 24 D9 6C 24 0E 48 8B 04 24 48 83 C4 18 C3 0F 1F 80 00 00 00 00 D9 7C 24 0E 0F B7 44 24 0E DE E1 48 BA 00 00 00 00 00 00 00 80 80 CC 0C 66 89 44 24 0C D9 6C 24 0C DF 3C 24 D9 6C 24 0E 48 8B 04 24 48 01 D0 48 83 C4 18 C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__bid_lttd2"
		size = 64
		refs = "0031 __bid128_quiet_less"
	strings:
		$1 = { 48 83 EC 48 48 8B 02 48 8B 52 08 4C 8B 09 4C 8B 51 08 48 8D 4C 24 30 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 4C 89 4C 24 30 4C 89 54 24 38 E8 ?? ?? ?? ?? F7 D8 48 98 48 83 C4 48 C3 90 90 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "__bid_fixunsddsi"
		size = 32
		refs = "0005 __bid64_to_uint32_xint"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? BA 00 00 00 00 3D 00 00 00 80 0F 44 C2 48 83 C4 28 C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__bid_fixunstdsi"
		size = 64
		refs = "001b __bid128_to_uint32_xint"
	strings:
		$1 = { 48 83 EC 38 48 8B 51 08 48 8B 01 48 8D 4C 24 20 48 89 54 24 28 48 89 44 24 20 E8 ?? ?? ?? ?? BA 00 00 00 00 3D 00 00 00 80 0F 44 C2 48 83 C4 38 C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "fprintf"
		size = 48
		refs = "0019 __mingw_vfprintf"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 50 4C 8D 44 24 50 4C 89 4C 24 58 4C 89 44 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_118_1_0 {
	meta:
		name = "__eprintf"
		size = 80
		refs = "000d __imp___iob_func 003d fflush 0042 abort"
	strings:
		$1 = { 41 54 55 57 56 53 48 83 EC 30 48 8B 1D ?? ?? ?? ?? 48 89 CE 48 89 D7 44 89 C5 4D 89 CC FF D3 48 8D 48 60 41 89 E9 49 89 F8 48 89 F2 4C 89 64 24 20 E8 9A FF FF FF FF D3 48 8D 48 60 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__floatunsitf"
		size = 192
	strings:
		$1 = { 48 83 EC 18 85 D2 48 89 C8 0F 84 A1 00 00 00 41 89 D0 BA 3E 40 00 00 49 0F BD C8 48 83 F1 3F 29 CA B9 2F 40 00 00 29 D1 66 81 E2 FF 7F 49 D3 E0 48 B9 FF FF FF FF FF FF 00 00 49 21 C8 49 B9 FF FF FF FF FF FF 00 00 48 C7 44 24 08 00 00 00 00 48 B9 00 00 00 00 00 00 FF FF 4D 21 C8 4C 8B 4C 24 08 48 C7 04 24 00 00 00 00 49 21 C9 48 B9 FF FF FF FF FF FF FF 7F 4D 09 C1 49 89 D0 48 BA FF FF FF FF FF FF 00 80 49 C1 E0 30 4C 21 CA 4C 09 C2 48 21 CA 48 89 54 24 08 66 0F 6F 04 24 0F 29 00 48 83 C4 18 C3 66 2E 0F 1F 84 00 00 00 00 00 31 D2 45 31 C0 EB 86 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__fixunsdfdi"
		size = 48
		refs = "0004 .rdata"
	strings:
		$1 = { F2 0F 10 0D ?? ?? ?? ?? 66 0F 2E C1 73 06 F2 48 0F 2C C0 C3 F2 0F 5C C1 48 BA 00 00 00 00 00 00 00 80 F2 48 0F 2C C0 48 01 D0 C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "__divxc3"
		size = 752
		refs = "010e .rdata"
	strings:
		$1 = { 48 8B 44 24 28 DB 2A 41 DB 28 41 DB 29 DB 28 D9 C1 D9 E1 D9 C1 D9 E1 DF E9 DD D8 0F 86 7F 00 00 00 D9 C1 D8 F1 D9 C2 D8 C9 D8 C2 D9 C5 D8 CA D8 C5 D8 F1 D9 CA D8 CD D8 E6 DE F1 D9 C9 DB E8 0F 8A 7F 00 00 00 DD DC DD DC DD D8 DD D8 EB 41 90 DD DC DD DC DD D8 DD D8 EB 36 66 0F 1F 44 00 00 DD DD DD DB DD D8 DD D8 EB 26 DD D8 DD DB DD D8 DD D8 EB 1C DD D8 DD DB DD D8 DD D8 EB 12 DD D8 DD DB DD D8 DD D8 EB 08 DD D8 DD DB DD D8 DD D8 DB 39 48 89 C8 DB 79 10 C3 0F 1F 80 00 00 00 00 D9 C0 D8 F2 D9 C1 D8 C9 D8 C3 D9 C4 D8 CA D8 C6 D8 F1 D9 CA D8 CE D8 ED DE F1 D9 C9 DB E8 7B 90 D9 C9 EB 02 D9 C9 DB E8 7B 96 D9 EE BA 00 00 00 00 DB EC 0F 9B C0 0F 45 C2 84 C0 74 54 DF EB 0F 9B C0 0F 44 D0 84 D2 74 4A D9 CD DB E8 7A 36 DD DD DD D8 DD D8 D9 C9 D9 CA D9 C9 EB 06 DD DD DD D8 DD D8 D9 E5 DF E0 DD D8 F6 C4 02 D9 05 ?? ?? ?? ?? 74 08 DD D8 D9 05 ?? ?? ?? ?? DC C9 DE CA E9 6B FF FF FF D9 CC DB E8 7B D2 D9 CC D9 CD EB 02 DD D8 D9 C5 D8 E6 DF E8 D9 CD 0F 9A C2 DB E8 0F 9B C0 20 D0 0F 85 DD 00 00 00 D9 C4 D8 E5 DF E8 0F 8A C5 00 00 00 EB 02 D9 CC D9 C3 D8 E4 DF E8 D9 CB 41 0F 9A C0 DB E8 0F 9B C0 44 20 C0 75 22 D9 C2 D8 E3 EB 06 D9 C9 D9 CC D9 C9 DF E8 0F 8B E5 FE FF FF D9 CA DB E8 0F 8A E5 FE FF FF 31 C0 EB 02 D9 CA 84 D2 0F 85 E1 FE FF FF D9 C4 D8 E5 DF E8 0F 8A DF FE FF FF DD DD DD D8 D9 C9 D9 CA D9 CB 84 C0 0F 85 11 01 00 00 D9 EE D9 CA D9 E5 DF E0 DD D8 D9 C9 D9 E1 F6 C4 02 D9 C0 D9 E0 DA C9 DD D9 D9 C1 D8 E2 DF E8 0F 8A D7 00 00 00 EB 02 D9 C9 D9 EE D9 CA D9 E5 DF E0 DD D8 D9 C9 D9 E1 F6 C4 02 D9 C0 D9 E0 DA C9 DD D9 D9 C2 D8 CA D9 C4 D8 CA DE C1 D9 EE DC C9 D9 CD DE CB D9 CB DE C9 DE E9 DE CA E9 74 FE FF FF D9 CC DB E8 0F 8A 33 FF FF FF D9 CC D9 C3 D8 E4 DB E8 0F 8A 2B FF FF FF DD D8 D9 C2 D8 E3 DB E8 0F 8A 35 FF FF FF DD D8 DD DD DD D8 D9 C9 D9 CA D9 CB 84 C0 0F 85 8D 00 00 00 D9 EE D9 C9 D9 E5 DF E0 DD D8 F6 C4 02 D9 E1 D9 C0 D9 E0 DA C9 DD D9 D9 C3 D8 E4 DF E8 7A 60 EB 02 D9 CB D9 EE D9 CC D9 E5 DF E0 DD D8 D9 CB D9 E1 F6 C4 02 D9 C0 D9 E0 DA C9 DD D9 D9 C3 D8 CB D9 C1 D8 CB DE C1 D9 05 ?? ?? ?? ?? DC C9 D9 CC DE CA D9 CC DE CA DE E1 DE C9 D9 C9 E9 D9 FD FF FF D9 C9 DB E8 0F 8A 21 FF FF FF D9 E8 D9 CA D9 C9 E9 1C FF FF FF D9 E8 D9 CA E9 EA FE FF FF D9 CB DB E8 7A 9C D9 E8 D9 CC D9 C9 EB 9A D9 E8 D9 C9 E9 6E FF FF FF 90 90 90 90 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__mulvti3"
		size = 512
		refs = "0181 abort"
	strings:
		$1 = { 41 54 55 57 56 53 48 83 EC 30 4C 8B 09 4C 8B 51 08 48 8B 5A 08 48 8B 0A 4C 89 CA 4D 89 CB 4C 89 D7 48 C1 FA 3F 49 89 DC 4C 89 CE 49 39 D2 75 31 48 89 CA 48 C1 FA 3F 48 39 D3 0F 85 81 00 00 00 4C 89 C8 48 F7 E9 48 89 44 24 20 48 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 30 5B 5E 5F 5D 41 5C C3 48 89 CA 48 C1 FA 3F 48 39 D3 0F 85 DA 00 00 00 4C 89 C8 48 F7 E1 48 89 C6 4C 89 D0 48 89 D5 48 F7 E1 4D 85 D2 49 89 C3 49 89 D4 48 89 D3 78 7F 48 85 C9 0F 88 A6 00 00 00 48 89 E8 31 D2 4C 01 D8 49 89 C0 4C 11 E2 49 C1 F8 3F 49 39 D0 0F 85 CB 00 00 00 48 89 74 24 20 48 89 44 24 28 EB 8F 48 89 C8 49 F7 E1 48 89 C7 48 89 D8 48 89 D5 49 F7 E1 48 85 DB 49 89 C1 49 89 D2 49 89 D3 78 4F 48 85 F6 78 3A 48 89 E8 31 D2 4C 01 C8 49 89 C0 4C 11 D2 49 C1 F8 3F 49 39 D0 0F 85 7F 00 00 00 48 89 7C 24 20 48 89 44 24 28 E9 40 FF FF FF 48 29 CB 49 89 DC E9 76 FF FF FF 0F 1F 44 00 00 49 29 C9 49 19 DA EB BE 0F 1F 84 00 00 00 00 00 49 29 F3 4D 89 DA EB A9 0F 1F 84 00 00 00 00 00 4D 29 CB 4D 19 D4 E9 4F FF FF FF 4D 85 D2 78 35 48 85 DB 78 5A 4D 09 D4 75 26 4C 89 C8 48 F7 E1 48 89 54 24 28 48 83 7C 24 28 00 48 89 44 24 20 0F 89 DA FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? 48 85 DB 78 40 75 F4 49 83 FA FF 75 EE 4C 89 C8 48 F7 E1 48 29 CA 49 89 C1 79 E0 4C 89 4C 24 20 48 89 54 24 28 E9 A1 FE FF FF 48 83 FB FF 75 CB 4D 85 D2 75 C6 48 89 C8 49 F7 E1 4C 29 DA 49 89 C1 78 D8 EB B6 48 83 C7 01 75 B0 49 83 C4 01 75 AA 48 89 C8 49 F7 E1 49 89 C1 48 89 D0 4C 29 D8 48 29 C8 78 96 4C 89 4C 24 20 48 89 44 24 28 E9 57 FE FF FF 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__bid64dq_add"
		size = 112
		refs = "001a __bid64_to_bid128 0062 __bid64qqq_fma"
	strings:
		$1 = { 57 56 53 48 83 EC 50 48 8B 32 48 8B 7A 08 48 8D 5C 24 40 48 89 CA 48 89 D9 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 48 B9 00 00 00 00 00 00 40 30 4C 8D 44 24 20 48 89 4C 24 48 48 89 D9 48 C7 44 24 40 01 00 00 00 48 89 74 24 20 48 89 54 24 38 48 8D 54 24 30 48 89 44 24 30 48 89 7C 24 28 E8 ?? ?? ?? ?? 48 83 C4 50 5B 5E 5F C3 66 90 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "__bid64qd_add"
		size = 112
		refs = "0017 __bid64_to_bid128 005f __bid64qqq_fma"
	strings:
		$1 = { 57 56 53 48 83 EC 50 48 8B 31 48 8B 79 08 48 8D 5C 24 40 48 89 D9 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 48 B9 00 00 00 00 00 00 40 30 4C 8D 44 24 20 48 89 4C 24 48 48 89 D9 48 C7 44 24 40 01 00 00 00 48 89 74 24 30 48 89 54 24 28 48 8D 54 24 30 48 89 7C 24 38 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 50 5B 5E 5F C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_127_2_0 {
	meta:
		name = "__bid64qq_add"
		size = 96
		refs = "004e __bid64qqq_fma"
	strings:
		$1 = { 48 83 EC 58 48 8B 02 48 8B 52 08 4C 8B 09 4C 8B 51 08 48 B9 00 00 00 00 00 00 40 30 48 89 4C 24 48 4C 8D 44 24 20 48 8D 4C 24 40 48 89 54 24 28 48 8D 54 24 30 48 C7 44 24 40 01 00 00 00 4C 89 4C 24 30 4C 89 54 24 38 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 58 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_3_0 {
	meta:
		name = "__bid64qq_sub"
		size = 144
		refs = "0075 __bid64qqq_fma"
	strings:
		$1 = { 48 83 EC 58 48 8B 42 08 4C 8B 09 4C 8B 51 08 48 8B 0A 48 BA 00 00 00 00 00 00 00 7C 49 89 C0 49 21 D0 49 39 D0 74 12 48 BA 00 00 00 00 00 00 00 80 48 85 D0 75 4A 48 09 D0 48 BA 00 00 00 00 00 00 40 30 48 89 4C 24 20 4C 8D 44 24 20 48 89 54 24 48 48 8D 4C 24 40 48 8D 54 24 30 48 C7 44 24 40 01 00 00 00 4C 89 4C 24 30 4C 89 54 24 38 48 89 44 24 28 E8 ?? ?? ?? ?? 48 83 C4 58 C3 66 90 48 BA FF FF FF FF FF FF FF 7F 48 21 D0 EB AA 90 }
	condition:
		$1
}

rule file_127_4_0 {
	meta:
		name = "__bid64dq_sub"
		size = 64
		refs = "001a __bid64_to_bid128"
	strings:
		$1 = { 57 56 53 48 83 EC 40 48 8B 32 48 8B 7A 08 48 8D 5C 24 30 48 89 CA 48 89 D9 E8 ?? ?? ?? ?? 48 8D 54 24 20 48 89 D9 48 89 74 24 20 48 89 7C 24 28 E8 3B FF FF FF 48 83 C4 40 5B 5E 5F C3 0F 1F 00 }
	condition:
		$1
}

rule file_127_5_0 {
	meta:
		name = "__bid64qd_sub"
		size = 80
		refs = "0017 __bid64_to_bid128"
	strings:
		$1 = { 57 56 53 48 83 EC 40 48 8B 31 48 8B 79 08 48 8D 5C 24 30 48 89 D9 E8 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 44 24 30 48 89 D9 48 89 74 24 30 48 89 7C 24 38 48 89 54 24 28 48 8D 54 24 20 48 89 44 24 20 E8 EA FE FF FF 48 83 C4 40 5B 5E 5F C3 66 90 }
	condition:
		$1
}

rule file_127_6_0 {
	meta:
		name = "__bid128_add"
		size = 19792
		refs = "021a .refptr.__bid_nr_digits 02ab .refptr.__bid_ten2k64 03ad .refptr.__bid_IDEC_glbflags 03d3 .refptr.__bid_IDEC_glbround 0788 .refptr.__bid_ten2k128 07af .refptr.__bid_midpoint64 0d64 .refptr.__bid_midpoint128 0f92 .refptr.__bid_ten2mk128trunc 1075 .refptr.__bid_ten2mk128 11eb .refptr.__bid_maskhigh128 1201 .refptr.__bid_shiftright128 1238 .refptr.__bid_onehalf128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC A8 00 00 00 4C 8B 5A 08 48 8B 1A 48 B8 00 00 00 00 00 00 00 80 49 8B 50 08 4D 8B 08 49 89 CE 4C 89 DF 4C 89 DE 49 89 DA 48 21 C7 48 21 D0 4C 89 D9 48 89 44 24 10 48 B8 00 00 00 00 00 00 00 78 4C 89 CD 48 21 C6 49 89 D0 48 89 7C 24 08 48 39 C6 0F 84 FF 00 00 00 48 89 D6 48 21 C6 48 39 C6 0F 84 F0 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 21 C3 49 39 C3 0F 84 D5 02 00 00 48 B8 FF FF FF FF FF FF 01 00 49 BB C0 87 AD BE 09 ED 01 00 48 21 C8 48 89 C7 48 89 44 24 18 48 B8 00 00 00 00 00 00 FE 7F 48 21 C8 4C 39 DF 0F 86 70 02 00 00 45 31 DB 48 C7 44 24 20 00 00 00 00 48 C7 44 24 18 00 00 00 00 48 BB 00 00 00 00 00 00 00 60 48 89 D6 48 21 DE 48 39 DE 0F 84 42 04 00 00 48 BB FF FF FF FF FF FF 01 00 49 BD 00 00 00 00 00 00 FE 7F 48 21 D3 4C 21 EA 48 89 54 24 30 48 BA C0 87 AD BE 09 ED 01 00 48 89 5C 24 28 48 39 D3 0F 86 AB 00 00 00 4D 85 DB 0F 85 D0 02 00 00 48 8B 7C 24 30 48 39 C7 49 89 F8 4C 0F 47 C0 48 83 7C 24 10 00 0F 84 77 02 00 00 48 8B 44 24 08 48 85 C0 0F 84 69 02 00 00 49 09 C0 31 ED 49 89 2E 4D 89 46 08 EB 4E 48 B8 00 00 00 00 00 00 00 7C 4C 89 DE 48 21 C6 48 39 C6 0F 84 D2 03 00 00 48 89 D1 48 21 C1 48 39 C1 0F 84 A3 07 00 00 4C 8B 4C 24 10 49 B8 00 00 00 00 00 00 00 78 4D 09 C1 4C 39 C6 0F 84 E8 01 00 00 49 C7 06 00 00 00 00 4D 89 4E 08 4C 89 F0 48 81 C4 A8 00 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 75 13 48 BA FF FF FF FF 63 8E 8D 37 49 39 D1 0F 87 40 FF FF FF 4D 85 DB 0F 85 02 02 00 00 48 8B 74 24 28 4C 09 CE 0F 84 32 FF FF FF 48 3B 44 24 30 0F 83 55 FF FF FF 48 83 7C 24 28 00 0F 84 DD 09 00 00 66 0F EF D2 48 8B 15 ?? ?? ?? ?? F2 48 0F 2A 54 24 28 66 48 0F 7E D1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 BF 03 00 00 48 63 C9 49 89 CB 49 C1 E3 05 49 01 D3 45 8B 13 45 85 D2 75 21 45 8B 53 18 4D 8B 5B 08 4C 39 5C 24 28 0F 87 4E 15 00 00 4C 39 5C 24 28 0F 84 2C 15 00 00 0F 1F 00 48 8B 5C 24 30 BA 22 00 00 00 44 29 D2 48 29 C3 48 89 D8 48 C1 E8 31 39 C2 0F 4E C2 31 D2 85 C0 74 7E 41 83 FA 13 0F 8F 68 15 00 00 83 F8 13 0F 8F BC 1D 00 00 48 63 D0 48 8B 05 ?? ?? ?? ?? 4D 89 CA 45 89 C9 49 C1 EA 20 4C 89 D3 48 8B 0C D0 49 89 CB 89 C9 49 89 C8 49 C1 EB 20 49 0F AF C9 4D 0F AF C2 4D 0F AF CB 49 89 CA 89 C9 44 89 C0 49 C1 EA 20 49 C1 E8 20 49 0F AF DB 4C 01 D0 4C 01 C8 49 89 C1 48 C1 E0 20 49 C1 E9 20 48 8D 2C 08 49 01 D8 4D 01 C8 66 0F 1F 84 00 00 00 00 00 4C 8B 6C 24 30 48 C1 E2 31 49 29 D5 4C 0B 6C 24 10 4D 09 E8 E9 33 FE FF FF 0F 1F 80 00 00 00 00 75 13 49 BB FF FF FF FF 63 8E 8D 37 4C 39 DB 0F 87 7B FD FF FF 4C 8B 5C 24 18 48 89 5C 24 20 49 09 DB E9 7E FD FF FF 66 0F 1F 84 00 00 00 00 00 4C 8D 1C 8D 00 00 00 00 48 B8 00 00 00 00 00 00 FE 7F 48 C7 44 24 20 00 00 00 00 48 C7 44 24 18 00 00 00 00 4C 21 D8 45 31 DB E9 46 FD FF FF 90 4C 8B 4C 24 08 49 09 F1 48 39 F1 0F 85 07 FE FF FF 49 31 D3 0F 89 FE FD FF FF 48 8B 15 ?? ?? ?? ?? 49 89 C1 83 0A 01 E9 EC FD FF FF 0F 1F 40 00 48 8B 7C 24 10 48 39 7C 24 08 0F 84 2F 0B 00 00 48 8B 05 ?? ?? ?? ?? 83 38 01 0F 85 1F 0B 00 00 48 B8 00 00 00 00 00 00 00 80 E9 68 FD FF FF 90 48 8B 7C 24 28 4C 09 CF 0F 85 D3 01 00 00 48 3B 44 24 30 0F 86 16 01 00 00 48 83 7C 24 18 00 0F 84 6B 07 00 00 66 0F EF DB 48 8B 15 ?? ?? ?? ?? F2 48 0F 2A 5C 24 18 66 49 0F 7E D8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4D 63 C0 4D 89 C3 49 C1 E3 05 49 01 D3 45 8B 0B 45 85 C9 75 1E 45 8B 4B 18 4D 8B 5B 08 4C 39 5C 24 18 0F 87 2A 13 00 00 4C 39 5C 24 18 0F 84 07 13 00 00 48 89 C2 48 2B 54 24 30 41 B8 22 00 00 00 45 29 C8 48 C1 EA 31 41 39 D0 41 0F 4E D0 45 31 C0 85 D2 74 7C 41 83 F9 13 0F 8F 23 14 00 00 83 FA 13 0F 8F 36 1B 00 00 4C 63 C2 48 8B 15 ?? ?? ?? ?? 48 8B 5C 24 20 4A 8B 14 C2 49 89 D9 89 D9 49 C1 E9 20 49 89 D2 89 D2 49 C1 EA 20 48 89 D3 49 0F AF D9 48 0F AF D1 4D 0F AF CA 89 DE 48 C1 EB 20 49 0F AF CA 4D 89 CB 49 89 D1 49 C1 E9 20 89 D2 49 01 F1 4D 8D 14 09 48 89 D9 4C 01 D9 4D 89 D1 49 C1 E2 20 49 C1 E9 20 49 01 D2 4C 01 C9 90 49 C1 E0 31 4C 29 C0 48 0B 44 24 08 48 09 C1 4D 89 16 49 89 4E 08 E9 88 FC FF FF 0F 1F 44 00 00 48 C1 E2 02 49 B8 00 00 00 00 00 00 FE 7F 4C 21 C2 48 89 54 24 30 E9 DA FB FF FF 0F 1F 44 00 00 48 B8 FF FF FF FF FF 3F 00 00 49 B8 93 8D 44 C6 4D 31 00 00 4C 21 D8 4C 39 C0 77 14 75 22 48 B8 FF FF FF FF 09 5B C1 38 48 39 C3 76 13 0F 1F 00 48 B9 00 00 00 00 00 C0 FF FF 45 31 D2 4C 21 D9 48 B8 00 00 00 00 00 00 00 7E 49 89 C8 49 21 C0 49 39 C0 0F 84 67 09 00 00 49 B8 FF FF FF FF FF 3F 00 FC 48 21 C2 4C 21 C1 48 39 C2 0F 85 5D FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 E9 4E FF FF FF 48 3B 44 24 30 73 42 48 8B 54 24 20 48 8B 7C 24 28 4C 89 4C 24 20 48 89 D5 48 8B 54 24 18 48 89 7C 24 18 48 8B 7C 24 10 48 89 54 24 28 48 89 C2 48 8B 44 24 30 48 89 54 24 30 48 8B 54 24 08 48 89 7C 24 08 48 89 54 24 10 48 83 7C 24 18 00 0F 85 6E 03 00 00 48 BA FF FF FF FF FF FF 1F 00 48 39 54 24 20 0F 87 95 07 00 00 66 0F EF E4 F2 48 0F 2A 64 24 20 66 48 0F 7E E1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 FF 03 00 00 48 8B 15 ?? ?? ?? ?? 48 63 C9 49 89 C8 49 C1 E0 05 49 01 D0 41 8B 18 85 DB 89 5C 24 50 75 36 41 8B 58 18 4D 8B 40 08 89 5C 24 50 66 2E 0F 1F 84 00 00 00 00 00 4C 39 44 24 18 75 19 48 C1 E1 05 48 8B 74 24 20 48 3B 74 0A 10 0F 83 43 03 00 00 0F 1F 44 00 00 48 83 7C 24 28 00 0F 85 44 03 00 00 48 B9 FF FF FF FF FF FF 1F 00 48 39 CD 0F 87 D1 06 00 00 66 0F EF ED F2 48 0F 2A ED 66 49 0F 7E E8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 FF 03 00 00 4D 63 C0 4D 89 C1 49 C1 E1 05 49 01 D1 41 8B 09 85 C9 75 2D 41 8B 49 18 4D 8B 49 08 0F 1F 44 00 00 4C 39 4C 24 28 75 19 49 C1 E0 05 4A 3B 6C 02 10 0F 83 27 03 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 89 C2 4C 8B 44 24 30 48 C1 EA 31 03 54 24 50 49 C1 E8 31 29 CA 44 29 C2 83 FA 21 0F 8E 03 03 00 00 83 FA 22 0F 85 FA 04 00 00 48 8B 5C 24 10 48 39 5C 24 08 74 39 83 7C 24 50 14 0F 8E 4F 14 00 00 8B 5C 24 50 48 8B 74 24 18 8D 53 EB 48 63 D2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 39 72 08 0F 84 1D 2F 00 00 66 2E 0F 1F 84 00 00 00 00 00 83 F9 13 0F 8F 2E 12 00 00 8D 51 FF 48 8B 0D ?? ?? ?? ?? 48 63 D2 48 8B 14 D1 48 39 D5 0F 83 F9 1C 00 00 83 7C 24 50 21 0F 8F 97 00 00 00 8B 5C 24 50 BA 22 00 00 00 29 DA 83 FB 13 0F 8F 2A 32 00 00 83 FA 13 0F 8F C0 39 00 00 48 8B 0D ?? ?? ?? ?? 48 63 D2 48 8B 74 24 20 48 8B 0C D1 41 89 F1 49 89 F0 49 C1 E8 20 49 89 CB 89 C9 49 C1 EB 20 4C 89 DB 49 0F AF D9 4C 0F AF C9 4D 0F AF D8 89 DE 48 C1 EB 20 4D 89 CA 45 89 C9 4C 0F AF C1 49 C1 EA 20 49 01 F2 4B 8D 0C 02 49 89 D8 4D 01 D8 49 89 CA 48 C1 E1 20 49 C1 EA 20 4A 8D 3C 09 4B 8D 1C 10 48 89 7C 24 20 48 89 5C 24 18 48 C1 E2 31 48 29 D0 48 8B 15 ?? ?? ?? ?? 8B 0A 48 8B 15 ?? ?? ?? ?? 85 C9 0F 84 94 00 00 00 83 F9 01 0F 84 A4 37 00 00 83 F9 02 0F 84 A9 39 00 00 48 8B 74 24 10 48 39 74 24 08 74 76 83 F9 03 75 71 48 83 6C 24 20 01 48 8B 5C 24 20 48 83 FB FF 0F 84 52 1D 00 00 48 BA FF FF FF FF 09 5B C1 38 48 39 54 24 20 0F 85 C1 04 00 00 48 BA 93 8D 44 C6 4D 31 00 00 48 39 54 24 18 0F 85 AC 04 00 00 48 BA 00 00 00 00 00 00 FE FF 48 BE FF FF FF FF 63 8E 8D 37 48 BB C0 87 AD BE 09 ED 01 00 48 01 D0 48 8B 15 ?? ?? ?? ?? 48 89 74 24 20 48 89 5C 24 18 48 0B 44 24 18 83 0A 20 48 0B 44 24 08 48 8B 7C 24 20 49 89 46 08 49 89 3E E9 84 F8 FF FF 90 48 B8 FF FF FF FF FF 3F 00 00 48 B9 93 8D 44 C6 4D 31 00 00 48 21 D0 48 39 C8 0F 86 10 02 00 00 49 B8 00 00 00 00 00 C0 FF FF 31 ED 49 21 D0 48 BA 00 00 00 00 00 00 00 7E 4C 89 C1 48 B8 FF FF FF FF FF 3F 00 FC 48 21 D1 49 21 C0 48 39 D1 0F 85 D7 F7 FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 E9 C8 F7 FF FF 66 0F EF C0 48 8B 15 ?? ?? ?? ?? F2 48 0F 2A 44 24 18 66 48 0F 7E C1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 BF 03 00 00 48 63 C9 49 89 C8 49 C1 E0 05 49 01 D0 41 8B 38 85 FF 89 7C 24 50 0F 85 D9 FC FF FF 41 8B 78 18 4D 8B 40 08 4C 39 44 24 18 89 7C 24 50 0F 86 A2 FC FF FF 83 44 24 50 01 E9 B8 FC FF FF 0F 1F 84 00 00 00 00 00 66 0F EF C9 F2 48 0F 2A 4C 24 28 66 49 0F 7E C8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 BF 03 00 00 4D 63 C0 4D 89 C1 49 C1 E1 05 49 01 D1 41 8B 09 85 C9 0F 85 F6 FC FF FF 41 8B 49 18 4D 8B 49 08 4C 39 4C 24 28 0F 86 C3 FC FF FF 83 C1 01 E9 DB FC FF FF 85 D2 0F 88 9F 03 00 00 41 B8 21 00 00 00 41 29 C8 44 39 C2 0F 8F C1 04 00 00 2B 54 24 50 01 D1 83 F9 13 0F 8E BE 10 00 00 44 8D 49 EC 48 8B 7C 24 20 4D 63 C9 49 C1 E1 04 4C 03 0D ?? ?? ?? ?? 48 89 FB 48 C1 EB 20 89 F9 49 89 DA 49 8B 11 49 89 D3 89 D2 4C 0F AF D2 49 C1 EB 20 48 0F AF D1 49 0F AF CB 44 89 D6 49 C1 EA 20 49 89 D0 89 D2 49 C1 E8 20 49 01 F0 4C 01 C1 49 89 C8 48 C1 E9 20 49 C1 E0 20 49 01 D0 48 89 FA 49 0F AF 51 08 4C 0F AF DB 49 01 D3 4B 8D 14 13 48 8D 34 0A 48 89 74 24 18 48 8B 7C 24 10 48 39 7C 24 08 0F 84 98 19 00 00 4C 8B 4C 24 18 4C 2B 4C 24 28 4C 89 C6 48 29 EE 49 39 F0 48 89 74 24 20 49 83 D9 00 4C 09 CE 0F 85 35 16 00 00 48 8B 7C 24 30 48 8B 15 ?? ?? ?? ?? 48 39 C7 48 0F 46 C7 83 3A 01 0F 84 A3 03 00 00 49 C7 06 00 00 00 00 49 89 46 08 E9 59 F6 FF FF 66 0F 1F 44 00 00 0F 85 F9 FD FF FF 48 B8 FF FF FF FF 09 5B C1 38 49 39 C1 0F 87 D7 FD FF FF E9 E1 FD FF FF 66 90 48 BA FF FF FF FF FF FF 1F 00 48 39 54 24 20 0F 86 05 0D 00 00 4C 8B 44 24 20 66 0F EF ED 49 C1 E8 20 F2 49 0F 2A E8 66 49 0F 7E E8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DF 03 00 00 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4D 89 C3 49 C1 E3 05 49 01 D3 45 8B 0B 45 85 C9 0F 85 93 F8 FF FF 45 8B 4B 18 4D 8B 5B 08 E9 7B F8 FF FF 0F 1F 44 00 00 48 BA FF FF FF FF FF FF 1F 00 49 39 D1 0F 86 74 0C 00 00 66 0F EF E4 4C 89 C9 48 C1 E9 20 F2 48 0F 2A E1 66 48 0F 7E E1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 DF 03 00 00 48 8B 15 ?? ?? ?? ?? 48 63 C9 49 89 CB 49 C1 E3 05 49 01 D3 45 8B 13 45 85 D2 0F 85 28 F6 FF FF 45 8B 53 18 4D 8B 5B 08 E9 0D F6 FF FF 83 7C 24 50 21 0F 8F 97 00 00 00 8B 74 24 50 41 B8 22 00 00 00 41 29 F0 83 FE 13 0F 8F 61 15 00 00 41 83 F8 13 0F 8F B6 1D 00 00 4C 8B 0D ?? ?? ?? ?? 4D 63 C0 48 8B 74 24 20 4B 8B 1C C1 41 89 F2 49 89 F1 49 C1 E9 20 49 89 DB 89 DB 49 C1 EB 20 4C 89 DE 49 0F AF F2 4C 0F AF D3 4D 0F AF D9 41 89 F4 48 C1 EE 20 4C 89 D7 45 89 D2 4C 0F AF CB 48 C1 EF 20 4C 01 DE 4C 01 E7 49 01 F9 4D 89 CB 49 C1 E1 20 49 C1 EB 20 4A 8D 1C 1E 48 89 5C 24 18 4B 8D 1C 11 48 89 5C 24 20 49 C1 E0 31 4C 29 C0 4C 8B 05 ?? ?? ?? ?? 45 8B 00 41 F7 C0 FB FF FF FF 0F 85 25 0C 00 00 49 B9 93 8D 44 C6 4D 31 00 00 4C 39 4C 24 18 75 63 83 FA 23 75 5E 49 BA 00 00 00 00 0A 5B C1 38 4C 39 54 24 20 0F 85 E9 1C 00 00 48 8B 7C 24 10 48 39 7C 24 08 0F 84 D9 1C 00 00 83 F9 13 0F 8E BE 25 00 00 8D 51 EC 48 8B 5C 24 28 48 63 D2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 3B 5A 08 0F 87 C9 25 00 00 4C 89 54 24 20 4C 89 4C 24 18 0F 84 B0 25 00 00 45 85 C0 0F 85 A8 0B 00 00 48 8B 15 ?? ?? ?? ?? E9 7A FB FF FF 66 0F 1F 84 00 00 00 00 00 66 0F EF DB 49 89 E8 49 C1 E8 20 F2 49 0F 2A D8 66 49 0F 7E D8 49 C1 E8 34 41 81 E0 FF 07 00 00 41 81 E8 DF 03 00 00 E9 23 F9 FF FF 0F 1F 40 00 48 8B 4C 24 20 66 0F EF D2 48 C1 E9 20 F2 48 0F 2A D1 66 48 0F 7E D1 48 C1 E9 34 81 E1 FF 07 00 00 81 E9 DF 03 00 00 E9 5F F8 FF FF 2B 54 24 50 01 D1 83 F9 13 0F 8E CD 12 00 00 8D 51 EC 48 8B 7C 24 20 48 63 D2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 89 FB 48 C1 EB 20 41 89 F8 49 89 D9 48 8B 0A 49 89 CA 89 C9 49 C1 EA 20 4C 0F AF C9 49 0F AF C8 4D 0F AF C2 44 89 CE 49 C1 E9 20 49 89 CB 89 C9 4C 0F AF D3 48 89 FB 49 C1 EB 20 48 0F AF 5A 08 49 01 F3 4D 01 D8 49 01 DA 4B 8D 14 0A 4D 89 C1 49 C1 E8 20 49 C1 E1 20 49 8D 34 09 4A 8D 3C 02 48 89 74 24 20 48 89 7C 24 18 48 8B 74 24 10 48 39 74 24 08 0F 84 A0 17 00 00 48 89 EE 48 2B 74 24 20 48 8B 54 24 28 48 2B 54 24 18 48 39 F5 48 89 74 24 20 48 83 DA 00 48 85 D2 0F 88 CF 1C 00 00 48 8B 74 24 20 48 09 D6 0F 85 48 17 00 00 48 8B 5C 24 30 48 8B 15 ?? ?? ?? ?? 48 39 C3 48 0F 46 C3 83 3A 01 0F 85 5D FC FF FF 48 BA 00 00 00 00 00 00 00 80 48 09 D0 E9 4B FC FF FF 31 ED E9 56 F2 FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 FF FF FF FF FF 3F 00 FC 48 21 C1 E9 F3 F5 FF FF 0F 1F 40 00 41 B8 22 00 00 00 45 89 C1 41 29 C9 41 39 D1 0F 84 7A 14 00 00 8D 04 0A 2B 54 24 50 48 89 6C 24 70 4C 89 B4 24 F0 00 00 00 8D 70 DE 41 29 C0 01 D1 89 74 24 40 48 8B 74 24 20 41 8D 04 08 89 44 24 38 48 8B 05 ?? ?? ?? ?? 48 C1 EE 20 83 7C 24 38 13 48 89 74 24 78 48 89 84 24 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 84 24 88 00 00 00 48 89 84 24 98 00 00 00 48 89 84 24 90 00 00 00 0F 8E E8 03 00 00 8B 44 24 38 48 8B 5C 24 20 48 8B 7C 24 78 8D 48 EC 89 D8 49 89 F8 48 63 C9 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 8B 11 49 89 D1 89 D2 4C 0F AF C2 49 C1 E9 20 48 0F AF D0 49 0F AF C1 45 89 C3 49 C1 E8 20 49 89 D2 89 D2 49 C1 EA 20 }
	condition:
		$1
}

rule file_127_7_0 {
	meta:
		name = "__bid128dd_add"
		size = 144
		refs = "001a __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 83 EC 50 48 8D 74 24 40 48 89 CB 4C 89 C7 48 89 F1 E8 ?? ?? ?? ?? 48 89 FA 48 89 F1 4C 8B 6C 24 40 4C 8B 74 24 48 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 30 4C 89 74 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 4D B2 FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 50 5B 5E 5F 41 5D 41 5E C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_8_0 {
	meta:
		name = "__bid128dq_add"
		size = 112
		refs = "001d __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 83 EC 58 4D 8B 28 4D 8B 70 08 48 8D 74 24 40 48 89 CB 48 89 F1 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 20 4C 89 74 24 28 48 89 54 24 38 48 8D 54 24 30 48 89 44 24 30 E8 CF B1 FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 58 5B 5E 41 5D 41 5E C3 }
	condition:
		$1
}

rule file_127_9_0 {
	meta:
		name = "__bid128qd_add"
		size = 128
		refs = "0020 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 83 EC 58 4C 8B 2A 4C 8B 72 08 48 8D 74 24 40 48 89 CB 4C 89 C2 48 89 F1 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 30 4C 89 74 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 5C B1 FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 58 5B 5E 41 5D 41 5E C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_10_0 {
	meta:
		name = "__bid128_sub"
		size = 128
	strings:
		$1 = { 53 48 83 EC 40 4C 8B 0A 4C 8B 52 08 48 B8 00 00 00 00 00 00 00 7C 49 8B 50 08 48 89 CB 49 8B 08 49 89 D0 49 21 C0 49 39 C0 74 12 48 B8 00 00 00 00 00 00 00 80 48 85 C2 75 36 48 09 C2 48 89 54 24 28 4C 8D 44 24 20 48 8D 54 24 30 48 89 4C 24 20 48 89 D9 4C 89 4C 24 30 4C 89 54 24 38 E8 CD B0 FF FF 48 89 D8 48 83 C4 40 5B C3 0F 1F 40 00 48 B8 FF FF FF FF FF FF FF 7F 48 21 C2 EB BE 90 }
	condition:
		$1
}

rule file_127_11_0 {
	meta:
		name = "__bid128dd_sub"
		size = 144
		refs = "001a __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 57 56 53 48 83 EC 50 48 8D 74 24 40 48 89 CB 4C 89 C7 48 89 F1 E8 ?? ?? ?? ?? 48 89 FA 48 89 F1 4C 8B 6C 24 40 4C 8B 74 24 48 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 30 4C 89 74 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 1D FF FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 50 5B 5E 5F 41 5D 41 5E C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_12_0 {
	meta:
		name = "__bid128dq_sub"
		size = 112
		refs = "001d __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 83 EC 58 4D 8B 28 4D 8B 70 08 48 8D 74 24 40 48 89 CB 48 89 F1 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 20 4C 89 74 24 28 48 89 54 24 38 48 8D 54 24 30 48 89 44 24 30 E8 9F FE FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 58 5B 5E 41 5D 41 5E C3 }
	condition:
		$1
}

rule file_127_13_0 {
	meta:
		name = "__bid128qd_sub"
		size = 128
		refs = "0020 __bid64_to_bid128"
	strings:
		$1 = { 41 56 41 55 56 53 48 83 EC 58 4C 8B 2A 4C 8B 72 08 48 8D 74 24 40 48 89 CB 4C 89 C2 48 89 F1 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 44 24 40 4C 8D 44 24 20 48 89 F1 4C 89 6C 24 30 4C 89 74 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 2C FE FF FF 48 8B 44 24 40 48 89 03 48 8B 44 24 48 48 89 43 08 48 89 D8 48 83 C4 58 5B 5E 41 5D 41 5E C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__bid_gedd2"
		size = 32
		refs = "0005 __bid64_quiet_greater_equal"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 98 48 C7 C2 FF FF FF FF 48 85 C0 48 0F 44 C2 48 83 C4 28 C3 90 90 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "__ucmpti2"
		size = 64
	strings:
		$1 = { 48 8B 41 08 4C 8B 0A 48 8B 52 08 4C 8B 01 48 89 C1 31 C0 48 39 D1 72 04 B0 02 76 04 F3 C3 66 90 30 C0 4D 39 C8 72 F5 4D 39 C1 48 19 C0 48 F7 D0 48 83 C0 02 C3 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__floatuntitf"
		size = 880
		refs = "0269 __sfp_handle_exceptions"
	strings:
		$1 = { 57 56 53 48 83 EC 50 0F 29 74 24 40 48 89 C8 4C 8B 0A 4C 8B 52 08 C7 44 24 3C 00 00 00 00 0F AE 5C 24 3C 4C 89 D7 4C 09 CF 0F 84 91 00 00 00 4D 85 D2 4D 89 D0 4C 89 D2 0F 85 02 01 00 00 49 0F BD D9 48 83 F3 3F 83 C3 40 41 BB 7E 40 00 00 41 29 DB 41 81 FB 6F 40 00 00 49 63 DB 0F 8F EE 00 00 00 BA 6F 40 00 00 48 29 DA 0F 84 70 02 00 00 48 83 FA 3F 0F 8F 86 02 00 00 41 BA 6F 40 00 00 4C 89 CA 45 29 DA 44 89 D1 49 D3 E0 41 8D 8B D1 BF FF FF 48 D3 EA 44 89 D1 45 89 DA 49 09 D0 49 D3 E1 48 B9 FF FF FF FF FF FF 00 00 4C 89 C2 66 41 81 E2 FF 7F 48 21 CA EB 0E 66 0F 1F 44 00 00 31 D2 45 31 D2 45 31 C9 48 C7 44 24 28 00 00 00 00 48 8B 4C 24 28 49 B8 FF FF FF FF FF FF 00 00 49 21 D0 48 BA 00 00 00 00 00 00 FF FF 4C 89 4C 24 20 48 21 CA 48 B9 FF FF FF FF FF FF 00 80 4C 09 C2 4D 89 D0 48 21 CA 49 C1 E0 30 48 B9 FF FF FF FF FF FF FF 7F 4C 09 C2 48 21 CA 48 89 54 24 28 66 0F 6F 74 24 20 0F 29 30 0F 28 74 24 40 48 83 C4 50 5B 5E 5F C3 66 0F 1F 84 00 00 00 00 00 49 0F BD DA 83 F3 3F E9 FD FE FF FF 0F 1F 40 00 41 81 FB 72 40 00 00 0F 8F 25 01 00 00 48 81 FB 72 40 00 00 74 25 41 BA 72 40 00 00 4C 89 CA 45 29 DA 44 89 D1 49 D3 E0 41 8D 8B CE BF FF FF 48 D3 EA 44 89 D1 4C 09 C2 49 D3 E1 48 B9 FF FF FF FF FF FF F7 FF 48 21 CA 31 C9 41 F6 C1 07 74 30 8B 4C 24 3C 81 E1 00 60 00 00 0F 84 90 01 00 00 81 F9 00 40 00 00 0F 85 74 01 00 00 B9 20 00 00 00 49 83 C1 08 48 83 D2 00 0F 1F 80 00 00 00 00 49 B8 00 00 00 00 00 00 08 00 4C 85 C2 74 11 49 B8 FF FF FF FF FF FF F7 FF 48 83 C3 01 4C 21 C2 49 89 D0 49 C1 E9 03 48 C7 44 24 28 00 00 00 00 49 C1 E0 3D 48 C1 E2 0D 81 E3 FF 7F 00 00 4D 09 C8 4C 8B 4C 24 28 48 C1 EA 10 4C 89 44 24 20 49 B8 00 00 00 00 00 00 FF FF 48 C1 E3 30 4D 21 C8 4C 09 C2 49 B8 FF FF FF FF FF FF 00 80 4C 21 C2 49 B8 FF FF FF FF FF FF FF 7F 48 09 DA 4C 21 C2 85 C9 48 89 54 24 28 66 0F 6F 74 24 20 0F 84 C4 FE FF FF 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 0F 29 30 0F 28 74 24 40 48 83 C4 50 5B 5E 5F C3 41 8D 8B 8E BF FF FF 4C 89 CE 4C 89 D7 31 D2 4C 0F AD D6 48 D3 EF F6 C1 40 B9 F2 40 00 00 48 0F 45 F7 48 0F 45 FA 44 29 D9 4D 0F A5 CA 45 31 C0 49 D3 E1 F6 C1 40 4D 0F 45 D1 4D 0F 45 C8 48 89 FA 4C 89 C9 45 31 C9 4C 09 D1 41 0F 95 C1 49 09 F1 E9 B3 FE FF FF 0F 1F 84 00 00 00 00 00 45 89 DA 48 BA FF FF FF FF FF FF 00 00 66 41 81 E2 FF 7F 4C 21 C2 E9 CD FD FF FF 0F 1F 44 00 00 B9 2F 40 00 00 4C 89 CA 45 89 DA 44 29 D9 66 41 81 E2 FF 7F 45 31 C9 48 D3 E2 48 B9 FF FF FF FF FF FF 00 00 48 21 CA E9 9C FD FF FF 0F 1F 40 00 B9 20 00 00 00 E9 96 FE FF FF 66 0F 1F 44 00 00 4D 89 C8 B9 20 00 00 00 41 83 E0 0F 49 83 F8 04 0F 84 7A FE FF FF 49 83 C1 04 48 83 D2 00 E9 6D FE FF FF 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "get_available_features"
		size = 288
		refs = "0112 __cpu_model"
	strings:
		$1 = { 41 89 D1 41 C1 E9 0F 41 83 E1 01 44 89 C8 83 C8 02 F7 C2 00 00 80 00 44 0F 45 C8 44 89 C8 83 C8 08 F7 C2 00 00 00 02 44 0F 45 C8 44 89 C8 83 C8 10 81 E2 00 00 00 04 44 0F 45 C8 44 89 C8 83 C8 04 F7 C1 00 00 80 00 44 0F 45 C8 44 89 C8 83 C8 20 F6 C1 01 44 0F 45 C8 44 89 C8 83 C8 40 F6 C5 02 44 0F 45 C8 44 89 C8 0C 80 F7 C1 00 00 08 00 44 0F 45 C8 44 89 C8 80 CC 01 F7 C1 00 00 10 00 44 0F 45 C8 44 89 C8 80 CC 02 F7 C1 00 00 00 10 44 0F 45 C8 44 89 C8 80 CC 40 80 E5 10 44 0F 45 C8 41 83 F8 06 7E 1D 31 C9 B8 07 00 00 00 49 87 D8 0F A2 49 87 D8 44 89 C8 80 CC 04 41 80 E0 20 44 0F 45 C8 B8 00 00 00 80 49 87 D8 0F A2 49 87 D8 3D 00 00 00 80 76 37 B8 01 00 00 80 49 87 D8 0F A2 49 87 D8 44 89 C8 80 CC 08 F6 C1 40 44 0F 45 C8 44 89 C8 80 CC 10 F7 C1 00 00 01 00 44 0F 45 C8 44 89 C8 80 CC 20 80 E5 08 44 0F 45 C8 44 89 0D ?? ?? ?? ?? C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_131_1_0 {
	meta:
		name = "__get_cpuid_output"
		size = 80
	strings:
		$1 = { 56 53 41 89 CA 41 89 CB 48 89 D3 41 81 E2 00 00 00 80 44 89 D0 48 87 DE 0F A2 48 87 DE 41 89 C2 31 C0 45 39 D3 77 1F 44 89 D8 49 87 DA 0F A2 49 87 DA 89 03 48 8B 44 24 38 45 89 10 41 89 09 89 10 B8 01 00 00 00 5B 5E C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_131_2_0 {
	meta:
		name = "__cpu_indicator_init"
		size = 736
		refs = "0010 __cpu_model 0129 .rdata"
	strings:
		$1 = { 41 56 41 55 41 54 55 57 56 53 48 83 EC 40 8B 05 ?? ?? ?? ?? 31 DB 85 C0 74 11 89 D8 48 83 C4 40 5B 5E 5F 5D 41 5C 41 5D 41 5E C3 4C 8D 6C 24 38 4C 8D 64 24 34 48 8D 6C 24 30 4C 8D 74 24 3C 31 C9 4D 89 E9 4D 89 E0 48 89 EA 4C 89 74 24 20 E8 5C FF FF FF 85 C0 0F 84 E1 01 00 00 8B 74 24 30 8B 7C 24 34 85 F6 0F 8E D1 01 00 00 4C 89 74 24 20 4D 89 E9 4D 89 E0 48 89 EA B9 01 00 00 00 E8 2C FF FF FF 85 C0 0F 84 B1 01 00 00 8B 54 24 30 44 8B 4C 24 34 89 D0 89 D1 41 89 D0 C1 E8 04 C1 E9 08 41 C1 E8 0C C1 EA 14 83 E0 0F 83 E1 0F 41 81 E0 F0 00 00 00 81 FF 47 65 6E 75 0F B6 D2 74 41 81 FF 41 75 74 68 74 0F C7 05 ?? ?? ?? ?? 03 00 00 00 E9 42 FF FF FF 83 F9 0F 0F 84 8A 00 00 00 8B 54 24 3C 8B 4C 24 38 41 89 F0 31 DB E8 9D FD FF FF C7 05 ?? ?? ?? ?? 02 00 00 00 E9 18 FF FF FF 83 F9 0F 45 0F B6 C9 0F 84 40 01 00 00 83 F9 06 74 4D 45 85 C9 75 27 83 F9 06 75 22 83 E8 0F 83 F8 3E 77 1A 48 8D 15 ?? ?? ?? ?? 48 63 04 82 48 01 C2 FF E2 C7 05 ?? ?? ?? ?? 02 00 00 00 8B 54 24 3C 8B 4C 24 38 41 89 F0 31 DB E8 3E FD FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 E9 B9 FE FF FF 44 01 C0 45 85 C9 74 B5 EB D5 41 C1 E0 04 83 C2 0F 44 01 C0 83 FA 14 0F 84 FE 00 00 00 0F 86 07 01 00 00 83 FA 15 0F 84 CD 00 00 00 83 FA 16 0F 85 4B FF FF FF C7 05 ?? ?? ?? ?? 08 00 00 00 E9 3C FF FF FF C7 05 ?? ?? ?? ?? 03 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 85 C7 05 ?? ?? ?? ?? 06 00 00 00 E9 76 FF FF FF C7 05 ?? ?? ?? ?? 03 00 00 00 C7 05 ?? ?? ?? ?? 03 00 00 00 E9 5D FF FF FF C7 05 ?? ?? ?? ?? 03 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 E9 44 FF FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 E9 35 FF FF FF C7 05 ?? ?? ?? ?? 03 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 E9 1C FF FF FF C7 05 ?? ?? ?? ?? 03 00 00 00 C7 05 ?? ?? ?? ?? 0B 00 00 00 E9 03 FF FF FF C7 05 ?? ?? ?? ?? 03 00 00 00 83 CB FF E9 CB FD FF FF 8D 4A 0F 44 01 C0 E9 BA FE FF FF 83 F8 0F C7 05 ?? ?? ?? ?? 05 00 00 00 0F 87 74 FE FF FF C7 05 ?? ?? ?? ?? 07 00 00 00 E9 65 FE FF FF C7 05 ?? ?? ?? ?? 07 00 00 00 E9 56 FE FF FF 83 FA 10 0F 85 4D FE FF FF 83 F8 04 C7 05 ?? ?? ?? ?? 04 00 00 00 74 1D 83 F8 08 74 27 83 F8 02 0F 85 30 FE FF FF C7 05 ?? ?? ?? ?? 04 00 00 00 E9 21 FE FF FF C7 05 ?? ?? ?? ?? 05 00 00 00 E9 12 FE FF FF C7 05 ?? ?? ?? ?? 06 00 00 00 E9 03 FE FF FF 90 90 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "__floattitf"
		size = 928
		refs = "0290 __sfp_handle_exceptions"
	strings:
		$1 = { 41 56 41 55 56 53 48 83 EC 58 0F 29 74 24 40 48 89 C8 4C 8B 0A 4C 8B 52 08 C7 44 24 3C 00 00 00 00 0F AE 5C 24 3C 4C 89 D6 4C 09 CE 0F 84 A0 00 00 00 4C 89 D2 48 C1 EA 3F 84 D2 74 0A 49 F7 D9 49 83 D2 00 49 F7 DA 4D 85 D2 4C 89 D6 4D 89 D0 0F 85 0A 01 00 00 49 0F BD D9 48 83 F3 3F 83 C3 40 41 BB 7E 40 00 00 41 29 DB 41 81 FB 6F 40 00 00 49 63 DB 0F 8F F6 00 00 00 B9 6F 40 00 00 48 29 D9 0F 84 78 02 00 00 48 83 F9 3F 0F 8F 8E 02 00 00 41 BA 6F 40 00 00 4D 89 C8 45 29 DA 44 89 D1 48 D3 E6 41 8D 8B D1 BF FF FF 49 D3 E8 44 89 D1 45 89 DA 4C 09 C6 49 D3 E1 48 B9 FF FF FF FF FF FF 00 00 48 21 CE 66 41 81 E2 FF 7F 49 89 F0 EB 0B 31 D2 45 31 C0 45 31 D2 45 31 C9 4C 89 4C 24 20 49 B9 FF FF FF FF FF FF 00 00 48 C7 44 24 28 00 00 00 00 4D 21 C1 4C 8B 44 24 28 48 B9 00 00 00 00 00 00 FF FF 0F B6 D2 48 C1 E2 3F 49 21 C8 48 B9 FF FF FF FF FF FF 00 80 4D 09 C8 4D 89 D1 49 21 C8 49 C1 E1 30 48 B9 FF FF FF FF FF FF FF 7F 4D 09 C8 49 21 C8 49 09 D0 4C 89 44 24 28 66 0F 6F 74 24 20 0F 29 30 0F 28 74 24 40 48 83 C4 58 5B 5E 41 5D 41 5E C3 0F 1F 80 00 00 00 00 49 0F BD DA 83 F3 3F E9 F5 FE FF FF 0F 1F 40 00 41 81 FB 72 40 00 00 0F 8F 23 01 00 00 48 81 FB 72 40 00 00 74 25 41 BA 72 40 00 00 4D 89 C8 45 29 DA 44 89 D1 48 D3 E6 41 8D 8B CE BF FF FF 49 D3 E8 44 89 D1 49 09 F0 49 D3 E1 48 B9 FF FF FF FF FF FF F7 FF 49 21 C8 31 C9 41 F6 C1 07 74 2F 8B 4C 24 3C 81 E1 00 60 00 00 81 F9 00 20 00 00 0F 84 BA 01 00 00 81 F9 00 40 00 00 0F 84 8E 01 00 00 85 C9 0F 84 66 01 00 00 B9 20 00 00 00 49 BA 00 00 00 00 00 00 08 00 4D 85 D0 74 12 49 BA FF FF FF FF FF FF F7 FF 48 83 C3 01 4D 21 D0 90 4D 89 C2 49 C1 E9 03 48 C7 44 24 28 00 00 00 00 49 C1 E2 3D 49 C1 E0 0D 81 E3 FF 7F 00 00 4D 09 CA 49 B9 00 00 00 00 00 00 FF FF 49 C1 E8 10 4C 89 54 24 20 4C 8B 54 24 28 48 C1 E3 30 48 C1 E2 3F 4D 21 D1 4D 09 C8 49 B9 FF FF FF FF FF FF 00 80 4D 21 C8 49 B9 FF FF FF FF FF FF FF 7F 49 09 D8 4D 21 C8 49 09 D0 85 C9 4C 89 44 24 28 66 0F 6F 74 24 20 0F 84 BC FE FF FF 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 E9 A8 FE FF FF 66 90 41 8D 8B 8E BF FF FF 4D 89 CD 4D 89 D6 45 31 C0 4D 0F AD D5 49 D3 EE F6 C1 40 B9 F2 40 00 00 4D 0F 45 EE 4D 0F 45 F0 44 29 D9 4D 0F A5 CA 45 31 DB 49 D3 E1 F6 C1 40 4D 0F 45 D1 4D 0F 45 CB 4D 89 F0 4C 89 CE 45 31 C9 4C 09 D6 41 0F 95 C1 4D 09 E9 E9 B4 FE FF FF 66 0F 1F 84 00 00 00 00 00 45 89 DA 49 B8 FF FF FF FF FF FF 00 00 66 41 81 E2 FF 7F 49 21 F0 E9 C2 FD FF FF 0F 1F 44 00 00 B9 2F 40 00 00 45 89 DA 44 29 D9 66 41 81 E2 FF 7F 49 D3 E1 48 B9 FF FF FF FF FF FF 00 00 4D 89 C8 45 31 C9 49 21 C8 E9 91 FD FF FF 0F 1F 40 00 4D 89 CA B1 20 41 83 E2 0F 49 83 FA 04 0F 84 8C FE FF FF 49 83 C1 04 49 83 D0 00 E9 7F FE FF FF 84 D2 B9 20 00 00 00 0F 85 72 FE FF FF 49 83 C1 08 49 83 D0 00 E9 65 FE FF FF 66 0F 1F 44 00 00 84 D2 B9 20 00 00 00 0F 84 52 FE FF FF EB DE 90 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "__mulsc3"
		size = 864
		refs = "0192 .rdata"
	strings:
		$1 = { 48 83 EC 78 0F 29 34 24 0F 29 7C 24 10 44 0F 29 44 24 20 44 0F 29 4C 24 30 44 0F 29 54 24 40 44 0F 29 5C 24 50 44 0F 29 64 24 60 44 0F 28 C0 44 0F 28 D1 44 0F 28 C8 F3 44 0F 59 C2 44 0F 28 D9 F3 44 0F 59 D3 F3 44 0F 59 CB F3 44 0F 59 DA 41 0F 28 E0 F3 41 0F 5C E2 41 0F 28 E9 F3 41 0F 58 EB 0F 2E E4 7A 4F 66 0F 7E E2 48 B9 00 00 00 00 FF FF FF FF 48 21 C8 0F 28 34 24 89 D2 48 09 D0 66 0F 7E EA 89 C0 0F 28 7C 24 10 48 C1 E2 20 44 0F 28 44 24 20 48 09 D0 44 0F 28 4C 24 30 44 0F 28 54 24 40 44 0F 28 5C 24 50 44 0F 28 64 24 60 48 83 C4 78 C3 0F 2E ED 7B AC 0F 28 F0 F3 0F 5C F0 0F 2E F6 0F 8A EF 00 00 00 0F 28 F1 F3 0F 5C F1 0F 2E F6 0F 8A 44 01 00 00 31 C9 0F 28 F2 0F 2E D2 F3 0F 5C F2 0F 9A C0 0F 2E F6 0F 8A 4A 01 00 00 0F 28 F3 0F 2E DB F3 0F 5C F3 0F 9A C2 0F 2E F6 0F 8A A8 01 00 00 84 C9 75 74 41 0F 28 F0 F3 41 0F 5C F0 0F 2E F6 0F 8A B0 01 00 00 41 0F 28 F2 F3 41 0F 5C F2 0F 2E F6 0F 8A 8F 01 00 00 41 0F 28 F1 F3 41 0F 5C F1 0F 2E F6 0F 8A 9B 01 00 00 41 0F 28 F3 F3 41 0F 5C F3 0F 2E F6 0F 8B 12 FF FF FF 45 0F 2E DB 0F 8A 08 FF FF FF 0F 2E C0 0F 8A 85 01 00 00 0F 2E C9 0F 8A 94 01 00 00 84 C0 0F 85 80 01 00 00 84 D2 0F 85 90 01 00 00 0F 28 E9 F3 0F 59 CA 0F 28 E0 F3 0F 59 EB F3 0F 10 35 ?? ?? ?? ?? F3 0F 59 D8 F3 0F 59 E2 F3 0F 58 D9 F3 0F 5C E5 0F 28 C3 F3 0F 59 E6 F3 0F 59 C6 0F 28 E8 E9 AD FE FF FF 0F 2E C0 0F 8A 08 FF FF FF 0F 28 F1 F3 0F 10 3D ?? ?? ?? ?? F3 0F 5C F1 0F 54 C7 0F 56 05 ?? ?? ?? ?? 0F 2E F6 0F 8A 48 01 00 00 66 0F EF F6 44 0F 28 E6 0F 28 F1 44 0F 54 25 ?? ?? ?? ?? 0F 2E D2 0F 54 F7 44 0F 56 E6 41 0F 28 CC 0F 8A 19 01 00 00 0F 2E DB 0F 8A 08 01 00 00 B9 01 00 00 00 E9 BE FE FF FF 0F 2E C9 0F 8A B3 FE FF FF F3 0F 10 3D ?? ?? ?? ?? F3 0F 10 35 ?? ?? ?? ?? 0F 54 C7 EB AC 3C 01 0F 83 AE FE FF FF 0F 28 F3 F3 0F 10 25 ?? ?? ?? ?? F3 0F 5C F3 44 0F 28 DA F3 0F 10 2D ?? ?? ?? ?? F3 0F 10 3D ?? ?? ?? ?? 0F 54 E5 44 0F 54 DF 0F 2E F6 41 0F 56 E3 0F 28 D4 0F 8A CC 00 00 00 66 0F EF E4 0F 28 F3 0F 54 E5 0F 54 F7 0F 2E C0 0F 56 E6 0F 28 DC 0F 8A A8 00 00 00 0F 2E C9 0F 8B DD FE FF FF 0F 54 CF E9 D5 FE FF FF 0F 1F 44 00 00 80 FA 01 0F 83 4F FE FF FF 66 0F EF E4 EB 94 45 0F 2E D2 0F 8B 95 FE FF FF E9 62 FE FF FF 45 0F 2E C0 0F 8B 86 FE FF FF E9 41 FE FF FF 45 0F 2E C9 0F 8B 77 FE FF FF E9 56 FE FF FF 0F 54 05 ?? ?? ?? ?? E9 6F FE FF FF 0F 54 15 ?? ?? ?? ?? E9 74 FE FF FF 0F 54 0D ?? ?? ?? ?? E9 60 FE FF FF 0F 54 1D ?? ?? ?? ?? E9 64 FE FF FF 0F 54 DF E9 F0 FE FF FF 0F 54 D7 E9 DF FE FF FF 0F 2E C9 0F 8A AF FE FF FF F3 0F 10 35 ?? ?? ?? ?? E9 A6 FE FF FF 0F 54 C7 E9 50 FF FF FF 0F 2E DB 0F 8A 2B FF FF FF F3 0F 10 25 ?? ?? ?? ?? E9 22 FF FF FF }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__floatuntisf"
		size = 256
		refs = "0094 .rdata"
	strings:
		$1 = { 4C 8B 51 08 4C 8B 09 4D 85 D2 4C 89 CA 0F 84 9D 00 00 00 49 0F BD C2 41 B8 40 00 00 00 4C 89 D2 48 83 F0 3F 48 98 49 29 C0 4C 89 C8 44 89 C1 4C 0F AD D0 48 D3 EA 41 F6 C0 40 B9 40 00 00 00 48 0F 45 C2 44 29 C1 48 89 C2 49 D3 E1 48 83 CA 01 4D 85 C9 48 0F 45 C2 48 85 C0 78 64 66 0F EF C0 F3 48 0F 2A C0 49 83 F8 40 74 25 49 83 F8 3F 74 2F 66 0F EF C9 44 89 C1 B8 01 00 00 00 48 D3 E0 F3 48 0F 2A C8 F3 0F 59 C1 C3 66 0F 1F 44 00 00 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 C1 C3 0F 1F 00 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 C1 C3 0F 1F 00 4D 85 C9 78 2B 66 0F EF C0 F3 49 0F 2A C1 C3 90 48 89 C2 66 0F EF C0 48 D1 EA 83 E0 01 48 09 C2 F3 48 0F 2A C2 F3 0F 58 C0 EB 8A 0F 1F 44 00 00 4C 89 C8 66 0F EF C0 48 D1 E8 83 E2 01 48 09 D0 F3 48 0F 2A C0 F3 0F 58 C0 C3 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__bid64_isSigned"
		size = 16
	strings:
		$1 = { 48 89 C8 48 C1 E8 3F C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_1_0 {
	meta:
		name = "__bid64_isNormal"
		size = 288
		refs = "005b .rdata"
	strings:
		$1 = { 48 BA 00 00 00 00 00 00 00 78 31 C0 49 89 C8 49 21 D0 49 39 D0 0F 84 BA 00 00 00 48 BA 00 00 00 00 00 00 00 60 49 89 C8 49 21 D0 49 39 D0 0F 84 AC 00 00 00 48 BA FF FF FF FF FF FF 1F 00 48 21 CA 0F 84 8E 00 00 00 48 01 C9 48 C1 E9 36 83 F9 0E B8 01 00 00 00 77 7D 4C 8D 05 ?? ?? ?? ?? 89 C9 48 89 D0 48 C1 E8 20 89 D2 49 8B 0C C8 49 89 CA 89 C9 49 C1 EA 20 49 89 C9 4C 0F AF C8 48 0F AF CA 49 0F AF C2 45 89 CB 49 C1 E9 20 49 0F AF D2 49 89 C0 48 89 C8 48 C1 E8 20 89 C9 4C 01 D8 48 01 C2 4B 8D 04 01 49 89 D0 49 C1 E8 20 4C 01 C0 48 B8 FF 7F C6 A4 7E 8D 03 00 41 0F 94 C0 48 C1 E2 20 48 01 CA 48 39 C2 0F 96 C0 44 21 C0 83 F0 01 0F B6 C0 F3 C3 66 0F 1F 84 00 00 00 00 00 48 BA FF FF FF FF FF FF 07 00 48 21 CA 49 89 D0 48 BA 00 00 00 00 00 00 20 00 4C 09 C2 49 B8 FE FF C0 6F F2 86 23 00 4C 8D 4A FF 4D 39 C1 77 C5 48 C1 E1 03 48 C1 E9 36 E9 31 FF FF FF 0F 1F 00 }
	condition:
		$1
}

rule file_137_2_0 {
	meta:
		name = "__bid64_isSubnormal"
		size = 272
		refs = "0058 .rdata"
	strings:
		$1 = { 48 BA 00 00 00 00 00 00 00 78 31 C0 49 89 C8 49 21 D0 49 39 D0 0F 84 B2 00 00 00 48 BA 00 00 00 00 00 00 00 60 49 89 C8 49 21 D0 49 39 D0 0F 84 9C 00 00 00 48 BA FF FF FF FF FF FF 1F 00 48 21 CA 0F 84 86 00 00 00 48 01 C9 48 C1 E9 36 31 C0 83 F9 0E 77 78 4C 8D 05 ?? ?? ?? ?? 89 C9 48 89 D0 48 C1 E8 20 89 D2 49 8B 0C C8 49 89 CA 89 C9 49 C1 EA 20 49 89 C9 4C 0F AF C8 48 0F AF CA 49 0F AF C2 45 89 CB 49 C1 E9 20 49 0F AF D2 49 89 C0 48 89 C8 48 C1 E8 20 89 C9 4C 01 D8 48 01 C2 4B 8D 04 01 49 89 D0 49 C1 E8 20 4C 01 C0 0F 94 C0 48 C1 E2 20 48 01 CA 48 B9 FF 7F C6 A4 7E 8D 03 00 48 39 CA 0F 96 C2 0F B6 D2 21 D0 F3 C3 90 48 BA FF FF FF FF FF FF 07 00 48 21 CA 49 89 D0 48 BA 00 00 00 00 00 00 20 00 4C 09 C2 49 B8 FE FF C0 6F F2 86 23 00 4C 8D 4A FF 4D 39 C1 77 CD 48 C1 E1 03 48 C1 E9 36 E9 41 FF FF FF 0F 1F 00 }
	condition:
		$1
}

rule file_137_3_0 {
	meta:
		name = "__bid64_isFinite"
		size = 32
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 78 48 21 C1 48 39 C1 0F 95 C0 0F B6 C0 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_4_0 {
	meta:
		name = "__bid64_isZero"
		size = 128
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 74 2B 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 74 19 48 B8 FF FF FF FF FF FF 1F 00 48 85 C1 0F 94 C0 0F B6 C0 C3 66 90 31 C0 C3 48 B8 FF FF FF FF FF FF 07 00 48 21 C1 48 B8 00 00 00 00 00 00 20 00 48 09 C1 48 B8 FF FF C0 6F F2 86 23 00 48 39 C1 0F 97 C0 0F B6 C0 C3 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_5_0 {
	meta:
		name = "__bid64_isInf"
		size = 64
	strings:
		$1 = { 48 BA 00 00 00 00 00 00 00 78 31 C0 49 89 C8 49 21 D0 49 39 D0 74 09 F3 C3 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 7C 48 21 C1 48 39 C1 0F 95 C0 0F B6 C0 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_6_0 {
	meta:
		name = "__bid64_isSignaling"
		size = 32
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 7E 48 21 C1 48 39 C1 0F 94 C0 0F B6 C0 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_7_0 {
	meta:
		name = "__bid64_isCanonical"
		size = 208
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 74 3B 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 74 58 48 BA 00 00 00 00 00 00 00 60 49 89 C8 B8 01 00 00 00 49 21 D0 49 39 D0 74 5C F3 C3 66 2E 0F 1F 84 00 00 00 00 00 48 BA 00 00 00 00 00 00 FC 01 31 C0 48 85 D1 75 E3 48 B8 FF FF FF FF FF FF 03 00 48 21 C1 48 B8 FF 7F C6 A4 7E 8D 03 00 48 39 C1 0F 96 C0 0F B6 C0 C3 48 B8 FF FF FF FF FF FF FF 03 48 85 C1 0F 94 C0 0F B6 C0 C3 66 2E 0F 1F 84 00 00 00 00 00 48 B8 FF FF FF FF FF FF 07 00 48 21 C1 48 B8 00 00 00 00 00 00 20 00 48 09 C1 48 B8 FF FF C0 6F F2 86 23 00 48 39 C1 0F 96 C0 0F B6 C0 C3 66 90 }
	condition:
		$1
}

rule file_137_8_0 {
	meta:
		name = "__bid64_isNaN"
		size = 32
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 00 7C 48 21 C1 48 39 C1 0F 94 C0 0F B6 C0 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_9_0 {
	meta:
		name = "__bid64_copy"
		size = 16
		altNames = "_decode_pointer"
	strings:
		$1 = { 48 89 C8 C3 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_12_0 {
	meta:
		name = "__bid64_copySign"
		size = 48
	strings:
		$1 = { 49 B8 FF FF FF FF FF FF FF 7F 48 89 C8 4C 21 C0 49 B8 00 00 00 00 00 00 00 80 4C 21 C2 48 09 D0 C3 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_13_0 {
	meta:
		name = "__bid64_class"
		size = 400
		refs = "0073 .rdata"
	strings:
		$1 = { 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 F6 00 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 FD 00 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 F4 00 00 00 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 0F 84 A1 00 00 00 48 8D 14 09 48 C1 EA 36 83 FA 0E 0F 8F 11 01 00 00 4C 8D 0D ?? ?? ?? ?? 48 63 D2 49 89 C0 89 C0 49 C1 E8 20 49 8B 14 D1 4D 89 C1 49 89 D3 89 D2 49 89 D2 49 C1 EB 20 48 0F AF D0 4D 0F AF D0 49 0F AF C3 49 89 D0 44 89 D3 49 C1 E8 20 49 C1 EA 20 4D 0F AF CB 49 01 D8 4C 01 C0 4F 8D 04 0A 49 89 C1 49 C1 E9 20 4D 01 C8 0F 85 B3 00 00 00 48 C1 E0 20 89 D2 48 01 D0 48 BA FF 7F C6 A4 7E 8D 03 00 48 39 D0 0F 87 97 00 00 00 48 C1 F9 3F 83 E1 FD 8D 41 07 5B C3 66 2E 0F 1F 84 00 00 00 00 00 48 C1 F9 3F 8D 41 06 5B C3 0F 1F 80 00 00 00 00 48 B8 00 00 00 00 00 00 00 7E 48 21 C1 48 39 C1 0F 95 C0 0F B6 C0 5B C3 0F 1F 84 00 00 00 00 00 48 C1 F9 3F 83 E1 F9 8D 41 09 5B C3 0F 1F 40 00 48 B8 FF FF FF FF FF FF 07 00 48 21 C8 48 89 C2 48 B8 00 00 00 00 00 00 20 00 48 09 D0 48 BA FE FF C0 6F F2 86 23 00 4C 8D 40 FF 49 39 D0 77 90 48 8D 14 CD 00 00 00 00 48 C1 EA 36 E9 E6 FE FF FF 48 C1 F9 3F 83 E1 FB 8D 41 08 5B C3 0F 1F 00 }
	condition:
		$1
}

rule file_137_14_0 {
	meta:
		name = "__bid64_sameQuantum"
		size = 224
	strings:
		$1 = { 49 B8 00 00 00 00 00 00 00 7C 48 89 C8 4C 21 C0 4C 39 C0 0F 84 A7 00 00 00 49 89 D1 31 C0 4D 21 C1 4D 39 C1 74 6A 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 74 57 49 89 D1 4D 21 C1 4D 39 C1 0F 84 86 00 00 00 48 B8 00 00 00 00 00 00 00 60 49 89 C9 4C 8D 04 09 49 21 C1 49 C1 E8 36 49 39 C1 74 49 48 B9 00 00 00 00 00 00 00 60 49 89 D1 48 8D 04 12 49 21 C9 48 C1 E8 36 49 39 C9 74 1C 41 39 C0 0F 94 C0 0F B6 C0 C3 66 90 F3 C3 4C 21 CA 31 C0 4C 39 CA 0F 94 C0 C3 66 90 48 8D 04 D5 00 00 00 00 48 C1 E8 36 EB D6 66 90 4C 8D 04 CD 00 00 00 00 49 C1 E8 36 EB A9 66 90 48 21 C2 48 39 C2 0F 94 C0 0F B6 C0 C3 0F 1F 00 F3 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_137_15_0 {
	meta:
		name = "__bid64_totalOrder"
		size = 1136
		refs = "0349 .rdata"
	strings:
		$1 = { 57 56 53 49 B8 00 00 00 00 00 00 00 7C 49 89 C9 4D 21 C1 4D 39 C1 74 38 48 89 D0 4C 21 C0 4C 39 C0 0F 84 59 01 00 00 48 39 D1 0F 84 B0 00 00 00 49 89 CA 49 89 D0 49 C1 EA 3F 49 C1 E8 3F 45 38 C2 0F 84 A9 00 00 00 41 0F B6 C2 5B 5E 5F C3 90 49 89 D0 4D 21 C8 48 85 C9 0F 88 A1 01 00 00 31 C0 4D 39 C8 75 E5 48 85 D2 78 E0 49 B8 00 00 00 00 00 00 00 7E 48 89 D0 49 89 C9 4C 21 C0 4C 39 C0 0F 95 C0 4D 21 C1 4D 39 C1 41 0F 94 C0 44 38 C0 0F 84 40 02 00 00 49 B8 FF FF FF FF FF FF 03 00 49 B9 FE 7F C6 A4 7E 8D 03 00 B8 01 00 00 00 4C 21 C1 4C 8D 51 FF 4D 39 CA 77 8F 4C 21 C2 30 C0 4C 8D 42 FF 4D 39 C8 0F 87 7D FF FF FF 31 C0 48 39 D1 0F 96 C0 E9 70 FF FF FF 0F 1F 44 00 00 B8 01 00 00 00 5B 5E 5F C3 0F 1F 80 00 00 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 B7 01 00 00 48 89 D0 4C 21 C0 4C 39 C0 74 6C 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 B3 01 00 00 4C 8D 0C 09 48 B8 FF FF FF FF FF FF 1F 00 49 C1 E9 36 48 21 C8 49 89 C0 0F 94 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D3 49 21 C3 49 39 C3 74 33 4C 8D 1C 12 48 B8 FF FF FF FF FF FF 1F 00 49 C1 EB 36 48 21 D0 74 55 84 DB 0F 84 14 01 00 00 0F 1F 40 00 48 F7 D2 48 C1 EA 3F 48 89 D0 5B 5E 5F C3 66 90 48 B8 FF FF FF FF FF FF 07 00 48 BE 00 00 00 00 00 00 20 00 4C 8D 1C D5 00 00 00 00 48 21 D0 48 09 F0 48 BE FE FF C0 6F F2 86 23 00 49 C1 EB 36 48 8D 78 FF 48 39 F7 76 AB 84 DB 0F 84 76 FE FF FF 48 F7 D1 48 C1 E9 3F 41 38 CA 0F 84 66 FE FF FF 45 39 D9 B8 01 00 00 00 0F 84 5C FE FF FF 0F 9E C0 41 31 C2 E9 4D FE FF FF 66 0F 1F 44 00 00 4D 39 C8 B8 01 00 00 00 0F 85 3D FE FF FF 48 85 D2 0F 89 34 FE FF FF 49 B8 00 00 00 00 00 00 00 7E 49 89 D1 49 89 CA 4D 21 C1 4D 39 C1 41 0F 95 C3 4D 21 C2 4D 39 C2 41 0F 94 C2 45 38 D3 0F 84 80 01 00 00 49 B8 FF FF FF FF FF FF 03 00 49 B9 FE 7F C6 A4 7E 8D 03 00 4C 21 C2 4C 8D 52 FF 4D 39 CA 0F 87 E3 FD FF FF 4C 21 C1 30 C0 4C 8D 41 FF 4D 39 C8 0F 87 D1 FD FF FF 31 C0 48 39 D1 0F 93 C0 E9 C4 FD FF FF 66 0F 1F 84 00 00 00 00 00 45 39 D9 7C 09 49 39 C0 0F 87 A9 FD FF FF 45 39 D9 40 0F 9E C6 7F 78 49 39 C0 73 73 48 F7 D1 48 C1 E9 3F 48 89 C8 E9 90 FD FF FF 0F 1F 44 00 00 45 84 D2 B8 01 00 00 00 0F 85 7D FD FF FF 4C 21 CA 4C 39 CA 0F 94 C0 0F B6 C0 E9 6C FD FF FF 90 48 B8 FF FF FF FF FF FF 07 00 49 B8 00 00 00 00 00 00 20 00 4C 8D 0C CD 00 00 00 00 48 21 C8 49 09 C0 48 B8 FE FF C0 6F F2 86 23 00 49 C1 E9 36 4D 8D 58 FF 49 39 C3 0F 97 C3 E9 29 FE FF FF 44 89 CA 44 29 DA 83 FA 0F 0F 8F 19 FD FF FF 44 89 DB 44 29 CB 83 FB 0F 0F 8F 94 00 00 00 45 39 D9 0F 8E 9A 00 00 00 48 8D 0D ?? ?? ?? ?? 48 63 D2 4D 89 C1 45 89 C0 49 C1 E9 20 48 8B 14 D1 48 89 D7 89 D2 49 89 D3 48 C1 EF 20 49 0F AF D0 4D 0F AF D9 4C 0F AF C7 48 89 D3 44 89 D9 48 C1 EB 20 49 C1 EB 20 4C 0F AF CF 48 01 D9 4C 01 C1 4D 89 D8 4D 01 C8 49 89 C9 49 C1 E9 20 4D 01 C8 0F 85 BE 00 00 00 48 C1 E1 20 89 D2 48 01 D1 48 39 C1 0F 84 95 00 00 00 0F 92 C0 0F B6 C0 44 31 D0 E9 87 FC FF FF 31 C0 4D 39 C1 0F 94 C0 E9 7A FC FF FF 48 89 C8 48 F7 D0 48 C1 E8 3F E9 6B FC FF FF 48 8D 15 ?? ?? ?? ?? 48 63 DB 49 89 C1 89 C0 49 C1 E9 20 48 8B 14 DA 48 89 D7 89 D2 49 89 D3 48 C1 EF 20 48 0F AF D0 4D 0F AF D9 48 0F AF C7 48 89 D3 48 C1 EB 20 44 89 D9 4C 0F AF CF 48 01 D9 48 01 C1 4C 89 D8 48 C1 E8 20 4C 01 C8 49 89 C9 49 C1 E9 20 4C 01 C8 75 1F 48 C1 E1 20 89 D2 48 01 D1 49 39 C8 0F 85 6B FF FF FF 89 F0 44 31 D0 0F B6 C0 E9 F3 FB FF FF B8 01 00 00 00 E9 5A FF FF FF 31 C0 E9 53 FF FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_137_16_0 {
	meta:
		name = "__bid64_totalOrderMag"
		size = 864
		refs = "0265 .rdata"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 49 89 C8 49 21 C0 49 39 C0 0F 84 D4 00 00 00 49 89 D0 49 21 C0 49 39 C0 0F 84 85 01 00 00 49 89 C9 49 B8 FF FF FF FF FF FF FF 7F B8 01 00 00 00 49 31 D1 4D 85 C1 0F 84 9C 00 00 00 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 0F 84 82 02 00 00 49 89 D1 4D 21 C1 4D 39 C1 74 78 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 EA 00 00 00 4C 8D 04 09 48 B8 FF FF FF FF FF FF 1F 00 49 C1 E8 36 48 21 C1 41 0F 94 C3 48 B8 00 00 00 00 00 00 00 60 49 89 D1 49 21 C1 49 39 C1 0F 84 08 01 00 00 48 8D 04 12 48 C1 E8 36 48 89 C3 48 B8 FF FF FF FF FF FF 1F 00 48 21 C2 0F 85 2A 01 00 00 31 C0 45 84 DB 74 08 31 C0 41 39 D8 0F 9E C0 5B 5E 5F C3 0F 1F 80 00 00 00 00 49 89 D1 31 C0 4D 21 C1 4D 39 C1 75 E8 49 B8 00 00 00 00 00 00 00 7E 48 89 D0 49 89 C9 4C 21 C0 4C 39 C0 0F 95 C0 4D 21 C1 4D 39 C1 41 0F 94 C0 44 38 C0 0F 84 C4 01 00 00 49 B8 FF FF FF FF FF FF 03 00 49 B9 FE 7F C6 A4 7E 8D 03 00 B8 01 00 00 00 4C 21 C1 4C 8D 51 FF 4D 39 CA 77 97 4C 21 C2 30 C0 4C 8D 42 FF 4D 39 C8 77 89 31 C0 48 39 D1 0F 96 C0 E9 7C FF FF FF 0F 1F 80 00 00 00 00 48 B8 FF FF FF FF FF FF 07 00 4C 8D 04 CD 00 00 00 00 48 21 C1 48 B8 00 00 00 00 00 00 20 00 48 09 C1 48 B8 FE FF C0 6F F2 86 23 00 49 C1 E8 36 4C 8D 49 FF 49 39 C1 41 0F 97 C3 E9 EF FE FF FF B8 01 00 00 00 5B 5E 5F C3 0F 1F 80 00 00 00 00 49 B9 FF FF FF FF FF FF 07 00 48 8D 04 D5 00 00 00 00 4C 21 CA 49 B9 00 00 00 00 00 00 20 00 4C 09 CA 49 B9 FE FF C0 6F F2 86 23 00 48 C1 E8 36 4C 8D 52 FF 48 89 C3 4D 39 CA 0F 87 D6 FE FF FF 45 84 DB B8 01 00 00 00 0F 85 D7 FE FF FF 41 39 D8 7C 0B 31 C0 48 39 D1 0F 87 C7 FE FF FF 41 39 D8 41 0F 9E C3 7F 0E 48 39 D1 B8 01 00 00 00 0F 82 B0 FE FF FF 45 89 C1 31 C0 41 29 D9 41 83 F9 0F 0F 8F 9E FE FF FF 41 89 DA B0 01 45 29 C2 41 83 FA 0F 0F 8F 8C FE FF FF 41 39 D8 0F 8E 93 00 00 00 4C 8D 05 ?? ?? ?? ?? 4D 63 C9 48 89 C8 89 C9 48 C1 E8 20 4F 8B 0C C8 4C 89 CB 45 89 C9 4D 89 C8 48 C1 EB 20 4C 0F AF C9 4C 0F AF C0 48 0F AF CB 4D 89 CA 44 89 C6 49 C1 EA 20 49 C1 E8 20 48 0F AF C3 49 01 F2 4C 01 D1 49 89 CA 49 C1 EA 20 49 01 C0 31 C0 4D 01 D0 0F 85 26 FE FF FF 48 C1 E1 20 45 89 C9 4C 01 C9 48 39 D1 41 0F B6 C3 41 0F 92 C0 48 39 D1 45 0F B6 C0 41 0F 45 C0 E9 01 FE FF FF 4C 21 CA 4C 39 CA 0F 94 C0 0F B6 C0 E9 F0 FD FF FF 4C 8D 0D ?? ?? ?? ?? 4D 63 D2 49 89 D0 89 D2 49 C1 E8 20 4F 8B 0C D1 4C 89 CE 45 89 C9 4D 89 CA 48 C1 EE 20 4C 0F AF CA 4D 0F AF D0 48 0F AF D6 4C 89 CB 44 89 D7 48 C1 EB 20 49 C1 EA 20 4C 0F AF C6 48 01 FB 48 01 DA 4D 01 D0 49 89 D2 49 C1 EA 20 4D 01 D0 0F 85 95 FD FF FF 48 C1 E2 20 45 89 C9 4C 01 CA E9 6A FF FF FF 90 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__fixtfdi"
		size = 432
		refs = "0067 __sfp_handle_exceptions"
	strings:
		$1 = { 53 48 83 EC 40 66 0F 6F 01 C7 44 24 3C 00 00 00 00 0F 29 44 24 20 0F AE 5C 24 3C 48 BA FF FF FF FF FF FF 00 00 48 8B 44 24 28 4C 8B 5C 24 20 48 89 C1 48 21 C2 48 C1 E8 3F 48 C1 E9 30 49 89 D0 49 89 C1 66 81 E1 FF 7F 44 0F B7 D1 49 81 FA FE 3F 00 00 7F 2B 31 C0 4D 85 D2 74 74 B9 20 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 40 5B C3 66 2E 0F 1F 84 00 00 00 00 00 49 81 FA 3D 40 00 00 7E 57 48 BA FF FF FF FF FF FF FF 7F 49 81 FA 3E 40 00 00 48 8D 04 10 0F 85 DC 00 00 00 45 84 C9 0F 84 D3 00 00 00 4C 89 C2 4C 89 D9 48 C1 E2 0F 48 C1 E9 31 48 09 CA 0F 85 BC 00 00 00 49 C1 E3 0F 4D 85 DB 74 A3 EB 8D 90 4D 09 D8 74 9B B9 22 00 00 00 EB 85 0F 1F 40 00 BB 6F 40 00 00 48 BA 00 00 00 00 00 00 01 00 4C 29 D3 4C 09 C2 44 0F B7 C1 48 83 FB 3F 7F 51 41 8D 98 D1 BF FF FF 4C 89 D8 45 31 D2 89 D9 48 D3 E0 48 85 C0 B8 6F 40 00 00 41 0F 95 C2 44 29 C0 89 C1 4C 89 D8 48 D3 E8 89 D9 48 D3 E2 48 09 D0 45 85 D2 74 5B 41 0F B6 D1 B9 20 00 00 00 49 89 D3 49 F7 DB 4C 31 D8 48 01 D0 E9 12 FF FF FF 90 31 C0 48 83 FB 40 74 0D 41 8D 88 11 C0 FF FF 48 89 D0 48 D3 E0 45 31 D2 B9 2F 40 00 00 4C 09 D8 41 0F 95 C2 48 89 D0 44 29 C1 48 D3 E8 EB B1 90 B9 01 00 00 00 E9 D7 FE FF FF 66 0F 1F 44 00 00 45 0F B6 C9 4C 89 CA 48 F7 DA 48 31 D0 4C 01 C8 48 83 C4 40 5B C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__bid_multd3"
		size = 96
		refs = "003a __bid128_mul"
	strings:
		$1 = { 53 48 83 EC 50 4C 8B 0A 4C 8B 52 08 49 8B 50 08 49 8B 00 48 89 CB 4C 8D 44 24 20 48 8D 4C 24 40 4C 89 4C 24 30 4C 89 54 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 54 24 48 48 89 03 48 89 D8 48 89 53 08 48 83 C4 50 5B C3 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__bid_divtd3"
		size = 96
		refs = "003a __bid128_div"
	strings:
		$1 = { 53 48 83 EC 50 4C 8B 0A 4C 8B 52 08 49 8B 50 08 49 8B 00 48 89 CB 4C 8D 44 24 20 48 8D 4C 24 40 4C 89 4C 24 30 4C 89 54 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 54 24 48 48 89 03 48 89 D8 48 89 53 08 48 83 C4 50 5B C3 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "__bid_subtd3"
		size = 96
		refs = "003a __bid128_sub"
	strings:
		$1 = { 53 48 83 EC 50 4C 8B 0A 4C 8B 52 08 49 8B 50 08 49 8B 00 48 89 CB 4C 8D 44 24 20 48 8D 4C 24 40 4C 89 4C 24 30 4C 89 54 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 54 24 48 48 89 03 48 89 D8 48 89 53 08 48 83 C4 50 5B C3 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__absvti2"
		size = 64
		refs = "0035 abort"
	strings:
		$1 = { 48 83 EC 38 48 8B 51 08 48 8B 01 48 85 D2 78 15 48 89 44 24 20 48 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 38 C3 48 F7 D8 48 83 D2 00 48 F7 DA 48 85 D2 79 DC E8 ?? ?? ?? ?? 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__fixtfti"
		size = 576
		refs = "006b __sfp_handle_exceptions"
	strings:
		$1 = { 57 56 53 48 83 EC 40 66 0F 6F 09 C7 44 24 3C 00 00 00 00 0F 29 4C 24 20 0F AE 5C 24 3C 48 BA FF FF FF FF FF FF 00 00 48 89 D3 48 8B 44 24 28 4C 8B 5C 24 20 48 89 C1 48 21 C3 48 C1 E8 3F 48 C1 E9 30 66 81 E1 FF 7F 0F B7 D1 48 81 FA FE 3F 00 00 7F 2D 48 85 D2 66 0F EF C0 0F 84 80 00 00 00 B9 20 00 00 00 0F 29 44 24 20 E8 ?? ?? ?? ?? 66 0F 6F 44 24 20 48 83 C4 40 5B 5E 5F C3 0F 1F 00 48 81 FA 7D 40 00 00 44 0F B6 C0 7E 63 B9 01 00 00 00 45 31 C9 49 BA 00 00 00 00 00 00 00 80 4C 29 C1 48 89 CE 48 C1 F9 3F 49 29 F1 49 19 CA 4C 89 4C 24 20 48 81 FA 7E 40 00 00 4C 89 54 24 28 66 0F 6F 44 24 20 75 09 84 C0 74 05 4C 09 DB 74 A4 B9 01 00 00 00 EB 8D 0F 1F 84 00 00 00 00 00 4C 09 DB 74 90 B9 22 00 00 00 E9 76 FF FF FF 90 48 B8 00 00 00 00 00 00 01 00 48 09 C3 48 81 FA 6E 40 00 00 0F 8F 88 00 00 00 B8 6F 40 00 00 48 29 D0 48 83 F8 3F 0F 8F E4 00 00 00 44 0F B7 C9 4C 89 DA 31 F6 41 8D 81 D1 BF FF FF 48 89 DF 89 C1 48 D3 E2 48 85 D2 BA 6F 40 00 00 40 0F 95 C6 44 29 CA 45 31 C9 89 D1 49 D3 EB 89 C1 48 D3 E7 89 D1 48 D3 EB 49 09 FB 49 89 DA 85 F6 0F 84 82 00 00 00 4C 89 D8 31 D2 4C 01 C8 4C 11 D2 4D 85 C0 74 0A 48 F7 D8 48 83 D2 00 48 F7 DA 48 89 44 24 20 48 89 54 24 28 66 0F 6F 44 24 20 E9 CE FE FF FF 45 31 C9 4C 89 D8 31 D2 0F B7 C9 4C 01 C8 48 11 DA 81 E9 6F 40 00 00 45 31 C9 48 0F A5 C2 48 D3 E0 F6 C1 40 48 0F 45 D0 49 0F 45 C1 4D 85 C0 74 0A 48 F7 D8 48 83 D2 00 48 F7 DA 48 89 44 24 20 48 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 40 5B 5E 5F C3 4C 89 D8 31 D2 4C 01 C8 4C 11 D2 4D 85 C0 74 D8 EB CC 66 0F 1F 84 00 00 00 00 00 48 83 F8 40 0F B7 C1 74 2D 8D 88 11 C0 FF FF 48 89 DA 48 D3 E2 31 F6 B9 2F 40 00 00 4C 09 DA 40 0F 95 C6 29 C1 45 31 C9 48 D3 EB 45 31 D2 49 89 DB E9 25 FF FF FF 31 D2 EB DB 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "__clrsbti2"
		size = 96
	strings:
		$1 = { 48 8B 51 08 48 8B 01 48 85 D2 75 14 48 89 C2 48 85 D2 B8 7F 00 00 00 75 27 F3 C3 0F 1F 44 00 00 48 83 FA FF 74 2A 48 89 D1 48 C1 F9 3F 48 31 CA 31 C9 48 0F BD C2 48 83 F0 3F 8D 44 01 FF C3 90 B9 40 00 00 00 EB EB 66 0F 1F 84 00 00 00 00 00 48 89 C2 48 F7 D2 EB B7 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__multc3"
		size = 2336
		refs = "00ae __multf3 013d __subtf3 0160 __addtf3 0182 __netf2 023e __eqtf2 024f .rdata"
	strings:
		$1 = { 41 56 41 55 41 54 55 57 56 53 48 81 EC 30 01 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 A0 00 00 00 44 0F 29 84 24 B0 00 00 00 44 0F 29 8C 24 C0 00 00 00 44 0F 29 94 24 D0 00 00 00 44 0F 29 9C 24 E0 00 00 00 44 0F 29 A4 24 F0 00 00 00 44 0F 29 AC 24 00 01 00 00 44 0F 29 B4 24 10 01 00 00 44 0F 29 BC 24 20 01 00 00 48 8D B4 24 80 00 00 00 48 8D 5C 24 70 48 8D 7C 24 60 48 8B 84 24 90 01 00 00 48 89 CD 66 45 0F 6F 01 48 89 F1 66 0F 6F 3A 48 89 DA 66 44 0F 6F 08 66 45 0F 6F 10 49 89 F8 0F 29 7C 24 70 44 0F 29 44 24 60 E8 ?? ?? ?? ?? 49 89 F8 48 89 DA 48 89 F1 44 0F 29 54 24 70 44 0F 29 4C 24 60 66 44 0F 6F A4 24 80 00 00 00 E8 ?? ?? ?? ?? 49 89 F8 48 89 DA 48 89 F1 66 44 0F 6F B4 24 80 00 00 00 0F 29 7C 24 70 44 0F 29 4C 24 60 E8 ?? ?? ?? ?? 49 89 F8 48 89 DA 48 89 F1 44 0F 29 54 24 70 44 0F 29 44 24 60 66 44 0F 6F AC 24 80 00 00 00 E8 ?? ?? ?? ?? 66 44 0F 6F BC 24 80 00 00 00 49 89 F8 48 89 DA 48 89 F1 44 0F 29 64 24 70 44 0F 29 74 24 60 E8 ?? ?? ?? ?? 49 89 F8 48 89 DA 48 89 F1 44 0F 29 6C 24 70 44 0F 29 7C 24 60 66 0F 6F B4 24 80 00 00 00 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 44 0F 6F 9C 24 80 00 00 00 0F 29 74 24 70 0F 29 B4 24 80 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 E1 03 00 00 48 89 DA 48 89 F1 44 0F 29 9C 24 80 00 00 00 44 0F 29 5C 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 84 BE 03 00 00 49 89 F8 48 89 DA 48 89 F1 0F 29 7C 24 70 0F 29 7C 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 0F 6F 84 24 80 00 00 00 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 85 04 04 00 00 49 89 F8 48 89 DA 48 89 F1 44 0F 29 54 24 70 44 0F 29 54 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 0F 6F 84 24 80 00 00 00 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 84 6E 04 00 00 48 89 DA 48 89 F1 44 0F 29 94 24 80 00 00 00 44 0F 29 54 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 85 4B 04 00 00 66 0F 6F 15 ?? ?? ?? ?? 0F 29 54 24 20 66 0F DB FA 66 0F 6F 05 ?? ?? ?? ?? 66 0F 6F 64 24 20 48 89 DA 66 0F DB 05 ?? ?? ?? ?? 48 89 F1 44 0F 29 84 24 80 00 00 00 66 41 0F DB E2 44 0F 29 44 24 70 66 0F EB C4 66 44 0F 6F D0 E8 ?? ?? ?? ?? 48 85 C0 0F 85 39 06 00 00 48 89 DA 48 89 F1 41 BD 01 00 00 00 44 0F 29 8C 24 80 00 00 00 44 0F 29 4C 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 85 F6 05 00 00 48 89 DA 48 89 F1 44 0F 29 84 24 80 00 00 00 44 0F 29 44 24 70 E8 ?? ?? ?? ?? 49 89 F8 48 85 C0 48 89 DA 48 89 F1 41 0F 95 C4 44 0F 29 44 24 70 44 0F 29 44 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 0F 6F 84 24 80 00 00 00 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 74 0A 41 80 FC 01 0F 82 89 04 00 00 48 89 DA 48 89 F1 44 0F 29 8C 24 80 00 00 00 44 0F 29 4C 24 70 E8 ?? ?? ?? ?? 49 89 F8 48 85 C0 48 89 DA 48 89 F1 41 0F 95 C6 44 0F 29 4C 24 70 44 0F 29 4C 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 0F 6F 84 24 80 00 00 00 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 74 0E 41 80 FE 01 66 0F EF C0 0F 82 2A 04 00 00 45 84 ED 0F 85 B5 00 00 00 49 89 F8 48 89 DA 48 89 F1 44 0F 29 64 24 70 44 0F 29 64 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 0F 6F 84 24 80 00 00 00 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 84 C3 02 00 00 48 89 DA 48 89 F1 44 0F 29 A4 24 80 00 00 00 44 0F 29 64 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 85 A0 02 00 00 48 89 DA 48 89 F1 0F 29 BC 24 80 00 00 00 0F 29 7C 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 85 C9 04 00 00 48 89 DA 48 89 F1 44 0F 29 94 24 80 00 00 00 44 0F 29 54 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 85 C1 04 00 00 45 84 E4 0F 85 AA 04 00 00 45 84 F6 0F 85 60 04 00 00 4C 8D 64 24 50 49 89 F8 48 89 DA 48 89 F1 66 44 0F 6F 1D ?? ?? ?? ?? 4C 8D 6C 24 40 4C 8D 74 24 30 0F 29 7C 24 70 44 0F 29 44 24 60 E8 ?? ?? ?? ?? 4D 89 E0 48 89 FA 48 89 D9 44 0F 29 54 24 60 44 0F 29 4C 24 50 66 0F 6F B4 24 80 00 00 00 E8 ?? ?? ?? ?? 66 0F 6F 44 24 70 4D 89 E8 4C 89 E2 48 89 F9 0F 29 74 24 50 0F 29 44 24 40 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 EA 4C 89 E1 44 0F 29 5C 24 40 66 0F 6F 44 24 60 0F 29 44 24 30 E8 ?? ?? ?? ?? 49 89 F8 48 89 DA 48 89 F1 0F 29 7C 24 70 44 0F 29 4C 24 60 66 0F 6F 74 24 50 E8 ?? ?? ?? ?? 4D 89 E0 48 89 FA 48 89 D9 66 0F 6F BC 24 80 00 00 00 44 0F 29 54 24 60 44 0F 29 44 24 50 E8 ?? ?? ?? ?? 4D 89 E8 4C 89 E2 48 89 F9 0F 29 7C 24 50 66 0F 6F 44 24 70 0F 29 44 24 40 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 EA 4C 89 E1 44 0F 29 5C 24 40 66 0F 6F 44 24 60 0F 29 44 24 30 E8 ?? ?? ?? ?? 66 44 0F 6F 5C 24 50 0F 1F 44 00 00 0F 29 75 00 48 89 E8 44 0F 29 5D 10 0F 28 B4 24 90 00 00 00 0F 28 BC 24 A0 00 00 00 44 0F 28 84 24 B0 00 00 00 44 0F 28 8C 24 C0 00 00 00 44 0F 28 94 24 D0 00 00 00 44 0F 28 9C 24 E0 00 00 00 44 0F 28 A4 24 F0 00 00 00 44 0F 28 AC 24 00 01 00 00 44 0F 28 B4 24 10 01 00 00 44 0F 28 BC 24 20 01 00 00 48 81 C4 30 01 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E C3 66 2E 0F 1F 84 00 00 00 00 00 48 89 DA 48 89 F1 0F 29 BC 24 80 00 00 00 0F 29 7C 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 85 DB FB FF FF 66 0F 6F 0D ?? ?? ?? ?? 49 89 F8 48 89 DA 48 89 F1 66 0F DB F9 0F 29 4C 24 20 44 0F 29 54 24 70 44 0F 29 54 24 60 66 0F EB 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 84 24 80 00 00 00 48 89 DA 48 89 F1 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 74 2B 48 89 DA 48 89 F1 44 0F 29 94 24 80 00 00 00 44 0F 29 54 24 70 E8 ?? ?? ?? ?? 48 85 C0 66 0F 6F 05 ?? ?? ?? ?? 0F 84 D7 FB FF FF 66 0F EF C0 E9 CE FB FF FF 45 31 ED E9 2E FC FF FF 49 89 F8 48 89 DA 48 89 F1 44 0F 29 74 24 70 44 0F 29 74 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 0F 6F 84 24 80 00 00 00 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 74 23 48 89 DA 48 89 F1 44 0F 29 B4 24 80 00 00 00 44 0F 29 74 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 84 05 FD FF FF 49 89 F8 48 89 DA 48 89 F1 44 0F 29 6C 24 70 44 0F 29 6C 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 0F 6F 84 24 80 00 00 00 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 74 23 48 89 DA 48 89 F1 44 0F 29 AC 24 80 00 00 00 44 0F 29 6C 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 84 AA FC FF FF 49 89 F8 48 89 DA 48 89 F1 44 0F 29 7C 24 70 44 0F 29 7C 24 60 E8 ?? ?? ?? ?? 48 89 DA 48 89 F1 66 0F 6F 84 24 80 00 00 00 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 84 E0 FD FF FF 48 89 DA 48 89 F1 44 0F 29 BC 24 80 00 00 00 44 0F 29 7C 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 85 BD FD FF FF E9 46 FC FF FF 66 0F 6F 05 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 49 89 F8 48 89 DA 48 89 F1 66 0F 6F 35 ?? ?? ?? ?? 0F 29 5C 24 20 66 0F DB C6 66 41 0F DB D8 44 0F 29 4C 24 70 66 0F EB C3 44 0F 29 4C 24 60 66 44 0F 6F C0 E8 ?? ?? ?? ?? 66 0F 6F 84 24 80 00 00 00 48 89 DA 48 89 F1 0F 29 44 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 84 8B 00 00 00 48 89 DA 48 89 F1 44 0F 29 8C 24 80 00 00 00 44 0F 29 4C 24 70 E8 ?? ?? ?? ?? 48 85 C0 75 6C 66 0F 6F 05 ?? ?? ?? ?? 66 0F 6F 6C 24 20 48 89 DA 66 0F DB C6 48 89 F1 66 41 0F DB E9 0F 29 BC 24 80 00 00 00 66 0F EB C5 0F 29 7C 24 70 66 44 0F 6F C8 E8 ?? ?? ?? ?? 48 85 C0 75 55 48 89 DA 48 89 F1 44 0F 29 94 24 80 00 00 00 44 0F 29 54 24 70 E8 ?? ?? ?? ?? 48 85 C0 0F 84 B2 FB FF FF 66 44 0F DB 54 24 20 E9 A6 FB FF FF 66 0F EF C0 EB 96 66 44 0F DB 0D ?? ?? ?? ?? E9 92 FB FF FF 66 44 0F DB 4C 24 20 41 BD 01 00 00 00 E9 F8 F9 FF FF 66 0F DB 7C 24 20 EB A3 66 44 0F DB 44 24 20 E9 BB F9 FF FF 66 0F DB 3D ?? ?? ?? ?? E9 2A FB FF FF 66 44 0F DB 05 ?? ?? ?? ?? E9 48 FB FF FF 66 44 0F DB 15 ?? ?? ?? ?? E9 31 FB FF FF 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__bid_extendsdxf"
		size = 48
		refs = "000e __bid32_to_binary80"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? DB 6C 24 20 48 89 D8 DB 3B 48 83 C4 30 5B C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__bid_extendddxf"
		size = 48
		refs = "000e __bid64_to_binary80"
	strings:
		$1 = { 53 48 83 EC 30 48 89 CB 48 8D 4C 24 20 E8 ?? ?? ?? ?? DB 6C 24 20 48 89 D8 DB 3B 48 83 C4 30 5B C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__cmpti2"
		size = 64
	strings:
		$1 = { 48 8B 41 08 4C 8B 0A 48 8B 52 08 4C 8B 01 48 89 C1 31 C0 48 39 D1 7C 04 B0 02 7E 04 F3 C3 66 90 30 C0 4D 39 C8 72 F5 4D 39 C1 48 19 C0 48 F7 D0 48 83 C0 02 C3 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "__clrsbdi2"
		size = 32
	strings:
		$1 = { B8 3F 00 00 00 48 89 CA 48 C1 FA 3F 48 31 D1 75 02 F3 C3 48 0F BD C9 48 83 F1 3F 8D 41 FF C3 90 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__fixunstfti"
		size = 528
		refs = "006f __sfp_handle_exceptions"
	strings:
		$1 = { 53 48 83 EC 40 66 0F 6F 09 C7 44 24 3C 00 00 00 00 0F 29 4C 24 20 0F AE 5C 24 3C 48 BA FF FF FF FF FF FF 00 00 48 89 D1 48 8B 44 24 28 4C 8B 5C 24 20 48 89 C2 48 21 C1 48 C1 E8 3F 48 C1 EA 30 66 81 E2 FF 7F 44 0F B7 C2 49 81 F8 FE 3F 00 00 7F 2E 4D 85 C0 66 0F EF C0 0F 85 A1 00 00 00 4C 09 D9 74 15 B9 22 00 00 00 0F 29 44 24 20 E8 ?? ?? ?? ?? 66 0F 6F 44 24 20 48 83 C4 40 5B C3 90 84 C0 74 1C 66 0F EF C0 B9 01 00 00 00 0F 29 44 24 20 E8 ?? ?? ?? ?? 66 0F 6F 44 24 20 EB DA 90 49 81 F8 7E 40 00 00 7F 67 48 B8 00 00 00 00 00 00 01 00 48 09 C8 49 81 F8 6E 40 00 00 7E 73 31 C9 4D 89 D9 0F B7 D2 45 31 D2 49 01 C9 8D 8A 91 BF FF FF 49 11 C2 31 C0 4D 0F A5 CA 49 D3 E1 F6 C1 40 4D 0F 45 D1 4C 0F 45 C8 4C 89 4C 24 20 4C 89 54 24 28 66 0F 6F 44 24 20 E9 7A FF FF FF 90 B9 20 00 00 00 EB 86 66 0F 1F 84 00 00 00 00 00 48 C7 44 24 20 FF FF FF FF 48 C7 44 24 28 FF FF FF FF B9 01 00 00 00 66 0F 6F 44 24 20 E9 5B FF FF FF B9 6F 40 00 00 4C 29 C1 48 83 F9 3F 7E 63 48 83 F9 40 0F B7 D2 0F 84 9A 00 00 00 8D 8A 11 C0 FF FF 48 89 C3 48 D3 E3 48 89 D9 45 31 C0 4C 09 D9 B9 2F 40 00 00 41 0F 95 C0 29 D1 45 31 C9 48 D3 E8 45 31 D2 49 89 C3 45 85 C0 74 70 4C 89 D8 31 D2 B9 20 00 00 00 4C 01 C8 4C 11 D2 48 89 44 24 20 48 89 54 24 28 66 0F 6F 44 24 20 E9 EA FE FF FF 44 0F B7 D2 4C 89 DA 45 31 C0 45 8D 8A D1 BF FF FF 48 89 C3 44 89 C9 48 D3 E2 48 85 D2 BA 6F 40 00 00 41 0F 95 C0 44 29 D2 89 D1 49 D3 EB 44 89 C9 45 31 C9 48 D3 E3 89 D1 48 D3 E8 49 09 DB 49 89 C2 EB 92 30 C9 E9 6E FF FF FF 4C 89 D8 31 D2 4C 01 C8 4C 11 D2 48 89 44 24 20 48 89 54 24 28 66 0F 6F 44 24 20 E9 6B FE FF FF 90 90 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "__parityti2"
		size = 64
	strings:
		$1 = { 48 8B 01 48 8B 49 08 48 31 C1 48 89 C8 48 C1 E8 20 48 31 C1 48 89 C8 48 C1 E8 10 48 31 C1 48 89 C8 48 C1 E8 08 48 31 C1 48 89 C8 48 C1 E8 04 48 31 C1 B8 96 69 00 00 83 E1 0F D3 F8 83 E0 01 C3 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "__divtf3"
		size = 2912
		refs = "0129 .rdata 0531 __sfp_handle_exceptions"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 0F 29 74 24 50 49 89 CC 66 0F 6F 02 C7 44 24 4C 00 00 00 00 66 41 0F 6F 08 0F 29 44 24 20 0F 29 4C 24 30 0F AE 5C 24 4C 48 BB FF FF FF FF FF FF 00 00 4C 8B 44 24 28 48 8B 44 24 20 4D 89 C1 4C 21 C3 49 C1 E8 3F 49 C1 E9 30 41 0F B6 F8 49 89 C3 41 81 E1 FF 7F 00 00 48 89 DE 48 89 7C 24 20 0F 84 CA 01 00 00 49 81 F9 FF 7F 00 00 0F 84 CD 00 00 00 48 BB 00 00 00 00 00 00 01 00 49 C1 E3 03 49 81 E9 FF 3F 00 00 48 09 DE 48 89 C3 45 31 F6 48 C1 E6 03 48 C1 EB 3D 31 C0 48 09 DE 31 ED 4C 8B 54 24 38 4C 8B 6C 24 30 48 BA FF FF FF FF FF FF 00 00 4D 89 D7 4C 21 D2 49 C1 EA 3F 49 C1 EF 30 41 0F B6 CA 4C 89 EF 41 81 E7 FF 7F 00 00 48 89 D3 48 89 4C 24 30 0F 84 F2 01 00 00 49 81 FF FF 7F 00 00 0F 84 B5 01 00 00 48 BA 00 00 00 00 00 00 01 00 48 C1 E7 03 49 81 EF FF 3F 00 00 48 09 D3 4C 89 EA 31 C9 48 C1 E3 03 48 C1 EA 3D 48 09 D3 4D 29 F9 4C 8D 3D ?? ?? ?? ?? 48 09 C8 44 89 D2 49 63 04 87 44 31 C2 0F B6 D2 49 89 D5 49 01 C7 41 FF E7 66 2E 0F 1F 84 00 00 00 00 00 48 89 D8 4C 09 D8 0F 85 24 02 00 00 B8 08 00 00 00 31 F6 45 31 DB 41 BE 02 00 00 00 31 ED E9 3D FF FF FF 48 8B 44 24 30 48 89 DE 49 89 FB 49 89 CE 48 89 44 24 20 49 83 FE 02 0F 84 0E 02 00 00 49 83 FE 03 0F 84 93 09 00 00 49 83 FE 01 0F 85 17 07 00 00 48 8B 54 24 20 31 C0 31 DB 45 31 DB 48 C7 44 24 28 00 00 00 00 48 89 DE 48 8B 5C 24 28 48 B9 FF FF FF FF FF FF 00 00 48 C1 E0 30 48 C1 E2 3F 48 21 CE 48 B9 00 00 00 00 00 00 FF FF 4C 89 5C 24 20 48 21 CB 48 09 F3 48 BE FF FF FF FF FF FF 00 80 48 21 F3 48 09 C3 48 B8 FF FF FF FF FF FF FF 7F 48 21 C3 48 09 D3 85 ED 48 89 5C 24 28 66 0F 6F 74 24 20 0F 85 10 03 00 00 41 0F 29 34 24 4C 89 E0 0F 28 74 24 50 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 40 00 48 89 DF 48 09 C7 0F 84 14 01 00 00 48 85 DB 0F 84 8B 03 00 00 48 0F BD D3 48 83 F2 3F 48 63 D2 4C 8D 4A F1 49 83 F9 3C 0F 8F 32 03 00 00 45 8D 59 03 41 BA 3D 00 00 00 48 89 C6 44 89 D9 48 D3 E3 44 89 D1 44 29 C9 48 D3 EE 44 89 D9 48 D3 E0 48 09 DE 49 89 C3 49 C7 C1 11 C0 FF FF 31 C0 45 31 F6 49 29 D1 BD 02 00 00 00 E9 01 FE FF FF 90 48 89 D1 4C 09 E9 0F 84 94 00 00 00 48 BA 00 00 00 00 00 80 00 00 B9 03 00 00 00 48 85 D3 0F 85 4F FE FF FF 83 CD 01 E9 47 FE FF FF 0F 1F 40 00 48 89 D7 4C 09 EF 74 59 48 85 D2 0F 84 D1 02 00 00 4C 0F BD FA 49 83 F7 3F 4D 63 FF 49 8D 5F F1 48 83 FB 3C 0F 8F A8 02 00 00 8D 7B 03 89 F9 48 D3 E2 B9 3D 00 00 00 29 D9 4C 89 EB 48 D3 EB 89 F9 49 D3 E5 48 09 D3 4C 89 EF 48 C7 C2 11 C0 FF FF 83 CD 02 31 C9 4C 29 FA 49 89 D7 E9 E2 FD FF FF 31 DB 31 FF B9 01 00 00 00 E9 D4 FD FF FF 90 31 DB 31 FF B9 02 00 00 00 E9 C5 FD FF FF 66 90 B8 04 00 00 00 31 F6 45 31 DB 41 BE 01 00 00 00 31 ED E9 39 FD FF FF 66 0F 1F 84 00 00 00 00 00 48 89 DD B8 0C 00 00 00 41 BE 03 00 00 00 48 C1 ED 2F 48 83 F5 01 83 E5 01 E9 12 FD FF FF 4C 8B 6C 24 20 B8 FF 7F 00 00 31 DB 45 31 DB 4C 89 EA 83 E2 01 E9 F8 FD FF FF 0F 1F 84 00 00 00 00 00 83 CD 01 BA 01 00 00 00 48 BB 00 00 00 00 00 80 00 00 45 31 DB B8 FF 7F 00 00 0F B6 D2 E9 CE FD FF FF 83 CD 04 EB BC 66 0F 1F 84 00 00 00 00 00 48 39 DE 0F 87 47 01 00 00 49 39 FB 72 09 48 39 DE 0F 84 39 01 00 00 4C 89 D9 49 83 E9 01 49 89 F6 45 31 DB E9 3E 01 00 00 0F 1F 80 00 00 00 00 31 C0 31 DB 45 31 DB E9 84 FD FF FF 0F 1F 40 00 48 39 DE 0F 87 67 03 00 00 49 39 FB 0F 86 80 03 00 00 48 39 DE 0F 85 77 03 00 00 48 BE 00 00 00 00 00 80 00 00 48 B8 FF FF FF FF FF FF 00 00 44 89 C2 48 09 F3 48 21 C3 E9 68 FF FF FF 0F 1F 00 8B 54 24 4C 81 E2 00 60 00 00 81 FA 00 20 00 00 0F 84 CD 04 00 00 81 FA 00 40 00 00 0F 84 90 04 00 00 83 FA 01 BB 00 00 00 00 48 B9 FF FF FF FF FF FF 00 00 19 C0 F7 D0 66 05 FF 7F 85 D2 48 0F 45 D9 83 FA 01 4D 19 DB 49 F7 D3 83 CD 28 41 83 E5 01 48 BE FF FF FF FF FF FF 00 00 48 C7 44 24 28 00 00 00 00 48 BA 00 00 00 00 00 00 FF FF 48 21 DE 48 8B 5C 24 28 25 FF 7F 00 00 48 C1 E0 30 45 0F B6 ED 4C 89 5C 24 20 49 C1 E5 3F 48 21 D3 48 BA FF FF FF FF FF FF 00 80 48 09 F3 48 21 D3 48 BA FF FF FF FF FF FF FF 7F 48 09 D8 48 21 D0 4C 09 E8 48 89 44 24 28 66 0F 6F 74 24 20 89 E9 E8 ?? ?? ?? ?? E9 E4 FC FF FF 66 0F 1F 44 00 00 4C 89 D9 49 89 F6 48 C1 E6 3F 48 D1 E9 49 D1 EE 49 C1 E3 3F 48 09 F1 48 89 F8 48 C1 E3 0C 4C 89 F2 48 C1 E8 34 48 C1 E7 0C 48 09 C3 48 89 C8 48 F7 F3 49 89 D6 48 89 C1 49 89 D0 48 F7 E7 49 39 D6 49 89 D2 72 6E 49 39 C3 73 05 4C 39 F2 74 64 48 89 CE E9 89 00 00 00 0F 1F 84 00 00 00 00 00 41 8D 49 C3 45 31 DB 48 D3 E0 48 89 C6 E9 E4 FC FF FF 8D 4B C3 4C 89 EB 31 FF 48 D3 E3 E9 68 FD FF FF 4D 0F BD FD 49 83 F7 3F 4D 63 FF 49 83 C7 40 E9 26 FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 0F BD D0 48 83 F2 3F 48 63 D2 48 83 C2 40 E9 6C FC FF FF 48 89 DA 49 89 FF 48 8D 71 FF 4D 01 DF 4C 11 F2 48 39 D3 49 89 D0 4D 89 FB 0F 82 5D 01 00 00 49 39 FF 72 09 48 39 DA 0F 84 4F 01 00 00 49 29 C3 4D 19 D0 49 39 D8 0F 84 D0 04 00 00 4C 89 D8 4C 89 C2 48 F7 F3 49 89 D6 48 89 C1 49 89 C3 49 89 D0 48 F7 E7 49 39 D6 72 0E 48 85 C0 41 0F 95 C2 74 5B 4C 39 F2 75 56 49 89 DA 49 89 FF 4C 8D 59 FF 49 83 C7 00 4D 11 F2 4C 39 D3 4D 89 D0 72 12 49 39 FF 0F 82 53 02 00 00 49 39 DA 0F 85 4A 02 00 00 4C 39 D2 77 12 4C 39 F8 0F 86 3C 02 00 00 4C 39 D2 0F 85 33 02 00 00 49 89 D8 4C 8D 59 FE 4C 01 FF 4D 11 D0 48 39 F8 41 0F 95 C2 49 39 D0 0F 85 0B 02 00 00 45 84 D2 0F 85 02 02 00 00 49 8D 81 FF 3F 00 00 48 85 C0 0F 8E 1D 01 00 00 41 F6 C3 07 74 37 8B 54 24 4C 83 CD 20 81 E2 00 60 00 00 81 FA 00 20 00 00 0F 84 C0 02 00 00 81 FA 00 40 00 00 0F 84 A2 02 00 00 85 D2 0F 84 7A 02 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 BA 00 00 00 00 00 00 10 00 48 85 D6 74 14 48 B8 FF FF FF FF FF FF EF FF 48 21 C6 49 8D 81 00 40 00 00 48 3D FE 7F 00 00 0F 8F 31 FD FF FF 48 89 F2 49 C1 EB 03 48 C1 E6 0D 48 C1 E2 3D 48 C1 EE 10 66 25 FF 7F 49 09 D3 4C 89 EA 48 89 F3 83 E2 01 E9 49 FA FF FF 66 0F 1F 84 00 00 00 00 00 49 39 D2 77 12 4C 39 F8 0F 86 A3 FE FF FF 49 39 D2 0F 85 9A FE FF FF 49 89 D8 49 89 FB 48 8D 71 FE 4D 01 FB 49 11 D0 E9 85 FE FF FF 0F 1F 40 00 48 BB 00 00 00 00 00 80 00 00 48 B8 FF FF FF FF FF FF 00 00 44 89 C2 48 09 F3 48 21 C3 E9 13 FC FF FF 48 BE 00 00 00 00 00 80 00 00 48 B8 FF FF FF FF FF FF 00 00 44 89 D2 48 09 F3 49 89 FB 48 21 C3 E9 EE FB FF FF 66 0F 1F 84 00 00 00 00 00 48 C7 C0 02 C0 FF FF 4C 29 C8 48 83 F8 74 0F 8F DC 00 00 00 48 83 F8 3F 0F 8F C2 01 00 00 41 B8 40 00 00 00 49 89 F1 4C 89 DA 41 29 C0 44 89 C1 49 D3 E1 89 C1 48 D3 EA 44 89 C1 49 D3 E3 49 09 D1 31 D2 4D 85 DB 89 C1 0F 95 C2 48 D3 EE 4C 09 CA F6 C2 07 74 2A 8B 44 24 4C 83 CD 20 25 00 60 00 00 3D 00 20 00 00 0F 84 98 02 00 00 3D 00 40 00 00 0F 84 75 02 00 00 85 C0 0F 84 EB 01 00 00 48 B8 00 00 00 00 00 00 08 00 48 85 C6 0F 85 8D 01 00 00 49 89 F3 48 C1 E6 0D 48 C1 EE 10 49 C1 E3 3D 48 89 F3 48 C1 EA 03 31 C0 49 09 D3 40 F6 C5 20 75 0B F6 44 24 4D 08 0F 84 FE FA FF FF 83 CD 10 41 83 E5 01 E9 07 FC FF FF 4C 8B 6C 24 20 E9 FE FD FF FF 49 83 CB 01 E9 F5 FD FF FF 66 90 4C 39 F8 41 0F 95 C2 E9 D5 FD FF FF 0F 1F 40 00 49 09 F3 74 2A 8B 44 24 4C 83 CD 20 25 00 60 00 00 3D 00 20 00 00 0F 84 AC 01 00 00 3D 00 40 00 00 0F 84 71 01 00 00 85 C0 0F 84 A6 01 00 00 31 DB 45 31 DB 83 CD 10 41 83 E5 01 31 C0 E9 A0 FB FF FF 49 83 FD 01 BA 00 00 00 00 48 BB FF FF FF FF FF FF 00 00 19 C0 F7 D0 66 05 FF 7F 4D 85 ED 48 0F 44 DA 49 83 FD 01 4D 19 DB 49 F7 D3 E9 68 FB FF FF 49 83 FD 01 BA 00 00 00 00 48 BB FF FF FF FF FF FF 00 00 19 C0 66 05 FF 7F 4D 85 ED 48 0F 45 DA 49 83 FD 01 4D 19 DB E9 3C FB FF FF 90 4C 89 DA 83 E2 0F 48 83 FA 04 0F 84 80 FD FF FF 49 83 C3 04 48 83 D6 00 E9 73 FD FF FF 0F 1F 00 4D 85 ED 75 7D 49 83 C3 08 48 83 D6 00 E9 5E FD FF FF 4D 85 ED 0F 84 55 FD FF FF 49 83 C3 08 48 83 D6 00 41 BD 01 00 00 00 E9 42 FD FF FF 66 90 8D 48 C0 48 89 F2 48 D3 EA 31 C9 48 83 F8 40 74 0A B1 80 29 C1 48 D3 E6 48 89 F1 4C 09 D9 41 0F 95 C3 45 0F B6 DB 4C 09 DA 49 89 D3 41 83 E3 07 75 2B 31 DB E9 8C FE FF FF 0F 1F 80 00 00 00 00 83 CD 20 31 DB B8 01 00 00 00 45 31 DB E9 8D FE FF FF 41 BD 01 00 00 00 E9 E3 FC FF FF 8B 44 24 4C 83 CD 20 25 00 60 00 00 3D 00 20 00 00 0F 84 AF 00 00 00 3D 00 40 00 00 0F 84 8C 00 00 00 31 F6 85 C0 0F 85 2A FE FF FF 31 F6 48 89 D0 83 E0 0F 48 83 F8 04 0F 84 05 FE FF FF 48 83 C2 04 48 83 D6 00 E9 F8 FD FF FF 4D 85 ED 4C 89 E8 0F 85 8B FE FF FF 48 BB FF FF FF FF FF FF 00 00 41 BB 01 00 00 00 49 83 C3 08 48 83 D0 00 48 21 C3 49 C1 EB 03 E9 6C FE FF FF 4D 85 ED 0F 84 5E FE FF FF 31 C0 EB CF 48 BB FF FF FF FF FF FF 00 00 31 C0 41 BB 01 00 00 00 49 83 C3 04 48 83 D0 00 48 21 C3 49 C1 EB 03 E9 39 FE FF FF 31 F6 4D 85 ED 0F 85 8A FD FF FF 48 83 C2 08 48 83 D6 00 E9 7D FD FF FF 31 F6 4D 85 ED 0F 84 72 FD FF FF EB E6 49 8D 81 FF 3F 00 00 49 83 CB FF 48 85 C0 0F 8F C5 FB FF FF 48 C7 C0 02 C0 FF FF 4C 29 C8 48 83 F8 74 0F 8E DC FC FF FF E9 B8 FD FF FF 0F B6 54 24 20 48 BB 00 00 00 00 00 80 00 00 48 B8 FF FF FF FF FF FF 00 00 48 09 F3 48 21 C3 83 E2 01 E9 81 F8 FF FF 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "__negvdi2"
		size = 48
		refs = "0026 abort"
	strings:
		$1 = { 48 83 EC 28 48 89 C8 48 F7 D8 48 89 C2 48 C1 EA 3F 48 85 C9 78 06 48 85 C0 0F 9F C2 84 D2 75 05 48 83 C4 28 C3 E8 ?? ?? ?? ?? 90 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_158_1_0 {
	meta:
		name = "__negvsi2"
		size = 48
		refs = "0020 abort"
	strings:
		$1 = { 48 83 EC 28 89 C8 F7 D8 89 C2 C1 EA 1F 85 C9 78 05 85 C0 0F 9F C2 84 D2 75 05 48 83 C4 28 C3 E8 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "__divdc3"
		size = 848
		refs = "0024 .rdata"
	strings:
		$1 = { 48 83 EC 38 0F 29 34 24 0F 29 7C 24 10 44 0F 29 44 24 20 66 0F 28 C3 48 89 C8 F2 0F 10 6C 24 60 F2 0F 10 35 ?? ?? ?? ?? 66 0F 28 E5 66 0F 54 C6 66 0F 54 E6 66 0F 2E E0 76 56 66 0F 28 E3 66 0F 28 FB 66 0F 28 C1 F2 0F 5E E5 F2 0F 59 FC F2 0F 59 C4 F2 0F 59 E2 F2 0F 58 FD F2 0F 58 C2 F2 0F 5C E1 F2 0F 5E C7 F2 0F 5E E7 66 0F 2E C0 7A 61 0F 28 34 24 0F 28 7C 24 10 44 0F 28 44 24 20 F2 0F 11 00 F2 0F 11 60 08 48 83 C4 38 C3 0F 1F 00 66 0F 28 E5 66 0F 28 FD 66 0F 28 C2 F2 0F 5E E3 66 44 0F 28 C2 F2 0F 59 FC F2 0F 59 C4 F2 0F 59 E1 F2 0F 58 FB F2 0F 58 C1 F2 44 0F 5C C4 F2 0F 5E C7 66 41 0F 28 E0 F2 0F 5E E7 66 0F 2E C0 7B 9F 66 0F 2E E4 7B 99 B9 00 00 00 00 66 0F EF FF 66 0F 2E DF 0F 9B C2 0F 45 D1 84 D2 74 42 66 0F 2E EF 0F 9B C2 0F 44 CA 84 C9 74 34 66 0F 2E C9 7A 25 66 0F 54 1D ?? ?? ?? ?? 66 0F 56 1D ?? ?? ?? ?? 66 0F 28 E3 F2 0F 59 CC F2 0F 59 E2 66 0F 28 C1 E9 49 FF FF FF 66 0F 2E D2 7B D5 0F 1F 00 66 44 0F 28 C1 F2 44 0F 5C C1 66 45 0F 2E C0 0F 9A C1 66 0F 2E C9 0F 9B C2 20 CA 0F 85 05 01 00 00 66 44 0F 28 C2 F2 44 0F 5C C2 66 45 0F 2E C0 0F 8A E6 00 00 00 66 44 0F 28 C3 F2 44 0F 5C C3 66 45 0F 2E C0 41 0F 9A C0 66 0F 2E DB 0F 9B C2 44 20 C2 75 21 66 44 0F 28 C5 F2 44 0F 5C C5 66 45 0F 2E C0 0F 8B D6 FE FF FF 66 0F 2E ED 0F 8A CC FE FF FF 31 D2 84 C9 0F 85 C2 FE FF FF 66 44 0F 28 C2 F2 44 0F 5C C2 66 45 0F 2E C0 0F 8A AD FE FF FF 84 D2 0F 85 50 01 00 00 66 0F 28 C7 66 44 0F 28 C3 F2 0F 10 25 ?? ?? ?? ?? 66 0F 54 C6 66 44 0F 54 C4 66 41 0F 56 C0 66 0F 28 D8 66 0F 28 C5 F2 0F 5C C5 66 0F 2E C0 0F 8A 04 01 00 00 66 0F 28 C7 66 44 0F 28 C5 66 44 0F 54 C4 66 0F 55 E0 66 0F 28 C2 F2 0F 59 D3 66 41 0F 56 E0 66 0F 28 EC 66 0F 28 E1 F2 0F 59 C5 F2 0F 59 E3 F2 0F 59 E9 F2 0F 58 C4 66 0F 28 E2 F2 0F 5C E5 F2 0F 59 C7 F2 0F 59 E7 E9 24 FE FF FF 66 0F 2E D2 0F 8A 10 FF FF FF 66 44 0F 28 C3 F2 44 0F 5C C3 66 45 0F 2E C0 0F 8A 05 FF FF FF 66 44 0F 28 C5 F2 44 0F 5C C5 66 45 0F 2E C0 0F 8A 0F FF FF FF 84 D2 0F 85 B3 00 00 00 66 44 0F 28 C7 F2 0F 10 25 ?? ?? ?? ?? 66 0F 28 C1 66 44 0F 54 C6 66 0F 54 C4 66 44 0F 56 C0 66 0F 28 C2 F2 0F 5C C2 66 0F 2E C0 7A 73 66 0F 28 CA 66 0F 54 CC 66 0F 55 E7 66 0F 56 E1 66 41 0F 28 C8 66 0F 28 D4 F2 0F 59 CB 66 0F 28 C2 F2 0F 59 D3 F2 0F 59 C5 F2 41 0F 59 E8 66 0F 28 E2 F2 0F 58 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C E5 F2 0F 59 C1 F2 0F 59 E1 E9 6C FD FF FF 66 0F 2E ED 0F 8A F2 FE FF FF F2 0F 10 05 ?? ?? ?? ?? E9 E9 FE FF FF F2 0F 10 05 ?? ?? ?? ?? E9 A7 FE FF FF 66 0F 2E D2 7A 87 F2 0F 10 3D ?? ?? ?? ?? E9 7A FF FF FF F2 44 0F 10 05 ?? ?? ?? ?? E9 44 FF FF FF 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__bid64_to_int64_rnint"
		size = 896
		refs = "0096 .refptr.__bid_nr_digits 00e9 .refptr.__bid_midpoint64 0181 .refptr.__bid_ten2k64 0245 .refptr.__bid_ten2mk64 02a5 .refptr.__bid_shiftright128 02b5 .refptr.__bid_maskhigh128 02d3 .refptr.__bid_ten2mk128trunc 0343 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 24 03 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 0B 03 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 B6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 9D 00 00 00 66 0F EF C0 48 8D 14 09 48 89 D0 F2 49 0F 2A C0 48 C1 E8 36 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 44 8B 0A 45 85 C9 75 0C 4C 3B 42 10 44 8B 4A 18 41 83 D9 FF 8D 90 72 FE FF FF 45 8D 14 11 41 83 FA 13 0F 8F 7E 02 00 00 49 BB 00 00 00 00 00 00 00 80 49 21 CB 41 83 FA 13 0F 84 97 00 00 00 31 C0 45 85 D2 78 20 0F 85 1A 01 00 00 48 8B 15 ?? ?? ?? ?? 41 83 E9 01 4D 63 C9 4E 3B 04 CA 0F 87 22 01 00 00 66 90 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 89 D0 4C 89 C2 48 C1 EA 20 48 C1 E8 36 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 21 FF FF FF 0F 1F 44 00 00 B9 14 00 00 00 44 89 C0 4D 89 C2 44 29 C9 4C 8B 0D ?? ?? ?? ?? 49 C1 EA 20 48 63 C9 4C 89 D6 49 8B 0C C9 48 89 CB 89 C9 49 89 C9 48 C1 EB 20 48 0F AF C8 4D 0F AF CA 48 0F AF C3 49 89 CA 44 89 CF 49 C1 EA 20 49 C1 E9 20 48 0F AF F3 49 01 FA 4C 01 D0 49 89 C2 49 C1 EA 20 49 01 F1 4D 01 D1 4D 85 DB 0F 84 3A 01 00 00 49 83 F9 05 0F 87 5D 01 00 00 48 C1 E0 20 89 C9 48 01 C8 48 83 F8 05 76 0E 49 83 F9 05 0F 84 44 01 00 00 0F 1F 40 00 85 D2 78 2E 0F 85 EA 00 00 00 4C 89 C0 48 89 C2 48 F7 DA 4D 85 DB 48 0F 45 C2 5B 5E 5F C3 66 90 49 83 FB 01 48 19 C0 83 E0 02 48 83 E8 01 5B 5E 5F C3 48 8B 05 ?? ?? ?? ?? F7 D2 48 63 D2 4C 03 04 D0 48 8B 05 ?? ?? ?? ?? 48 8B 04 D0 4D 89 C2 44 89 C1 49 C1 EA 20 49 89 C1 4C 89 D3 89 C0 48 0F AF D8 49 C1 E9 20 4D 89 D0 48 0F AF C1 4D 0F AF C1 89 DE 48 C1 EB 20 49 89 C2 89 C0 4C 0F AF C9 49 C1 EA 20 49 01 F2 4B 8D 0C 0A 4E 8D 14 03 49 89 C8 48 C1 E1 20 49 C1 E8 20 4D 01 C2 4C 8D 04 01 48 8B 05 ?? ?? ?? ?? 8B 0C 90 4C 89 D0 48 D3 E8 48 8B 0D ?? ?? ?? ?? 4C 85 14 D1 0F 85 4A FF FF FF 4D 85 C0 0F 84 41 FF FF FF 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 4C 3B 42 08 0F 87 2C FF FF FF 48 89 C2 83 E2 01 48 83 FA 01 48 83 D0 FF E9 19 FF FF FF 4D 85 DB 48 63 D2 74 64 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 E9 ED FD FF FF 49 83 F9 04 77 27 48 C1 E0 20 89 C9 48 01 C8 48 83 F8 FA 0F 86 D4 FE FF FF 49 83 F9 04 0F 85 CA FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 A7 FD FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 8C FD FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_162_1_0 {
	meta:
		name = "__bid64_to_int64_xrnint"
		size = 1200
		refs = "0096 .refptr.__bid_nr_digits 00e8 .refptr.__bid_midpoint64 0101 .refptr.__bid_IDEC_glbflags 01a2 .refptr.__bid_ten2k64 0267 .refptr.__bid_ten2mk64 02c2 .refptr.__bid_maskhigh128 02d7 .refptr.__bid_shiftright128 02ed .refptr.__bid_onehalf128 0314 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 08 04 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 EF 03 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 13 0F 8F 65 03 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 13 0F 84 AA 00 00 00 45 85 C9 0F 88 91 02 00 00 0F 85 2C 01 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 01 48 63 D0 31 C0 4C 3B 04 D1 0F 87 32 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 0F 1F 84 00 00 00 00 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 4D 89 C3 44 89 C1 49 C1 EB 20 4D 85 D2 0F 84 10 02 00 00 41 B1 14 4C 89 DE 41 29 C1 49 63 C1 4C 8B 0D ?? ?? ?? ?? 4D 8B 0C C1 48 89 C8 4C 89 CB 45 89 C9 4C 89 CF 48 C1 EB 20 4C 0F AF C9 49 0F AF FB 48 0F AF C3 4D 89 CB 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 05 0F 87 2D 02 00 00 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 05 76 0A 48 83 F9 05 0F 84 13 02 00 00 85 D2 78 3B 0F 85 65 01 00 00 4C 89 C0 48 89 C2 48 F7 DA 4D 85 D2 48 0F 45 C2 5B 5E 5F C3 90 49 83 FA 01 48 8B 15 ?? ?? ?? ?? 48 19 C0 83 E0 02 48 83 E8 01 83 0A 20 E9 C3 FE FF FF 0F 1F 00 89 D3 48 8B 05 ?? ?? ?? ?? F7 DA F7 D3 48 63 DB 4C 03 04 D8 48 8B 05 ?? ?? ?? ?? 48 8B 0C D8 4D 89 C1 45 89 C0 49 C1 E9 20 48 89 C8 89 C9 4C 89 CF 48 89 CE 48 C1 E8 20 4D 89 CB 49 0F AF F0 48 0F AF F9 4C 0F AF D8 48 89 F1 89 F6 41 89 F9 48 C1 E9 20 48 C1 EF 20 49 0F AF C0 4C 01 C9 4E 8D 0C 1F 48 01 C1 48 89 C8 48 C1 E1 20 48 01 CE 48 8B 0D ?? ?? ?? ?? 48 C1 E8 20 4C 01 C8 49 89 C0 4C 23 04 D9 48 8B 0D ?? ?? ?? ?? 8B 0C 99 48 D3 E8 83 FA 03 0F 8E 6A 01 00 00 48 8B 15 ?? ?? ?? ?? 48 85 F6 48 8B 0C DA 0F 95 C2 49 39 C8 77 24 49 39 C8 0F 94 C1 20 D1 74 1A 48 89 DA 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 86 80 01 00 00 89 CA 48 8B 0D ?? ?? ?? ?? 83 09 20 84 D2 0F 84 E8 FE FF FF 4D 85 C0 0F 85 DF FE FF FF 48 C1 E3 04 48 89 DA 48 03 15 ?? ?? ?? ?? 48 3B 72 08 0F 87 C7 FE FF FF 48 89 C2 83 E2 01 48 83 FA 01 48 83 D0 FF E9 B4 FE FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 5B 5E 5F C3 4D 85 D2 48 63 D2 0F 84 B4 00 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 E9 6D FD FF FF 41 B9 14 00 00 00 4C 89 DE 41 29 C1 49 63 C1 4C 8B 0D ?? ?? ?? ?? 4D 8B 0C C1 48 89 C8 4C 89 CB 45 89 C9 4C 89 CF 48 C1 EB 20 4C 0F AF C9 49 0F AF FB 48 0F AF C3 4D 89 CB 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 04 77 1E 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 FA 0F 86 F7 FD FF FF 48 83 F9 04 0F 85 ED FD FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 D3 FC FF FF 0F 1F 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 BC FC FF FF 48 BA 00 00 00 00 00 00 00 80 48 39 D6 76 2A 48 89 D9 48 01 F2 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 B8 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 A9 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 48 85 F6 0F 95 C2 E9 8C FE FF FF 4D 85 C0 0F 84 AC FE FF FF E9 6E FD FF FF }
	condition:
		$1
}

rule file_162_2_0 {
	meta:
		name = "__bid64_to_int64_floor"
		size = 928
		refs = "0096 .refptr.__bid_nr_digits 00fc .refptr.__bid_ten2k64 0224 .refptr.__bid_IDEC_glbflags 0255 .refptr.__bid_ten2mk64 02ba .refptr.__bid_maskhigh128 02c5 .refptr.__bid_shiftright128 02f7 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 05 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 EC 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 14 10 41 83 FA 13 0F 8F 62 01 00 00 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 13 0F 84 BE 00 00 00 45 85 D2 0F 8E 61 01 00 00 85 D2 0F 88 69 01 00 00 0F 84 93 00 00 00 4D 85 C9 48 63 D2 0F 84 87 02 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 0F 1F 44 00 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 4C 89 C2 4C 89 C0 48 F7 DA 4D 85 C9 48 0F 45 C2 5B 5E 5F C3 4D 85 C9 0F 84 75 01 00 00 41 B2 14 44 89 C1 4D 89 C3 41 29 C2 49 C1 EB 20 49 63 C2 4C 8B 15 ?? ?? ?? ?? 4C 89 DE 4D 8B 14 C2 48 89 C8 4C 89 D3 45 89 D2 4C 89 D7 48 C1 EB 20 4C 0F AF D1 49 0F AF FB 48 0F AF C3 4D 89 D3 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 05 77 1A 48 C1 E0 20 45 89 D2 4C 01 D0 0F 84 C8 FE FF FF 48 83 F9 05 0F 85 BE FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 D6 FE FF FF 66 0F 1F 44 00 00 31 C0 4D 85 C9 0F 95 C0 48 F7 D8 5B 5E 5F C3 90 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C2 F7 DA 48 63 DB 49 C1 EA 20 48 8B 0C D9 4D 89 D3 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F2 4D 0F AF D8 49 89 CA 89 C9 89 F7 49 C1 EA 20 48 C1 EE 20 4C 0F AF C0 49 01 FA 4D 01 D0 4E 8D 14 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C2 48 8B 05 ?? ?? ?? ?? 4C 8B 1C D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 4C 89 D0 48 D3 E8 83 FA 03 7E 19 4D 85 DA 74 14 4D 85 C9 0F 84 2B FE FF FF 48 83 C0 01 EB 1F 0F 1F 44 00 00 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 77 DB 4D 85 C9 0F 84 06 FE FF FF 48 F7 D8 E9 FE FD FF FF B9 14 00 00 00 4C 89 C3 45 89 C2 29 C1 48 C1 EB 20 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 89 DE 4C 8B 1C C1 4C 89 D9 45 89 DB 4C 89 DF 48 C1 E9 20 48 0F AF FB 4D 0F AF DA 48 0F AF F1 89 FB 48 C1 EF 20 49 C1 EB 20 49 0F AF CA 49 01 DB 48 8D 1C 37 49 8D 04 0B 48 C1 E8 20 48 01 D8 48 83 F8 04 0F 86 68 FD FF FF E9 A5 FE FF FF 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 7C FD FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_162_3_0 {
	meta:
		name = "__bid64_to_int64_xfloor"
		size = 944
		refs = "0096 .refptr.__bid_nr_digits 017f .refptr.__bid_ten2k64 0223 .refptr.__bid_IDEC_glbflags 0265 .refptr.__bid_ten2mk64 02ca .refptr.__bid_maskhigh128 02d5 .refptr.__bid_shiftright128 030a .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 04 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 EB 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 B3 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 9A 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 14 10 41 83 FA 13 0F 8F 61 01 00 00 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 13 0F 84 BD 00 00 00 45 85 D2 0F 8E 61 01 00 00 85 D2 0F 88 79 01 00 00 0F 85 83 00 00 00 4C 89 C0 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 24 FF FF FF 0F 1F 84 00 00 00 00 00 4D 85 C9 48 63 D2 0F 84 14 02 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 E9 6A FF FF FF 4D 85 C9 0F 84 84 01 00 00 41 B2 14 44 89 C1 4D 89 C3 41 29 C2 49 C1 EB 20 49 63 C2 4C 8B 15 ?? ?? ?? ?? 4C 89 DE 4D 8B 14 C2 48 89 C8 4C 89 D3 45 89 D2 4C 89 D7 48 C1 EB 20 4C 0F AF D1 49 0F AF FB 48 0F AF C3 4D 89 D3 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 05 77 1A 48 C1 E0 20 45 89 D2 4C 01 D0 0F 84 C9 FE FF FF 48 83 F9 05 0F 85 BF FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 C4 FE FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 C9 0F 95 C0 48 F7 D8 5B 5E 5F C3 0F 1F 80 00 00 00 00 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C2 F7 DA 48 63 DB 49 C1 EA 20 48 8B 0C D9 4D 89 D3 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F2 4D 0F AF D8 49 89 CA 89 C9 89 F7 49 C1 EA 20 48 C1 EE 20 4C 0F AF C0 49 01 FA 4D 01 D0 4E 8D 14 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C2 48 8B 05 ?? ?? ?? ?? 4C 8B 1C D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 4C 89 D0 48 D3 E8 83 FA 03 7E 1C 4D 85 DA 74 17 48 8B 15 ?? ?? ?? ?? 49 83 F9 01 48 83 D8 FF 83 0A 20 E9 ED FD FF FF 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 0F 86 D8 FD FF FF EB D2 66 0F 1F 44 00 00 B9 14 00 00 00 4C 89 C3 45 89 C2 29 C1 48 C1 EB 20 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 89 DE 4C 8B 1C C1 4C 89 D9 45 89 DB 4C 89 DF 48 C1 E9 20 48 0F AF FB 4D 0F AF DA 48 0F AF F1 89 FB 48 C1 EF 20 49 C1 EB 20 49 0F AF CA 49 01 DB 48 8D 1C 37 49 8D 04 0B 48 C1 E8 20 48 01 D8 48 83 F8 04 0F 86 5A FD FF FF E9 96 FE FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 59 FD FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_162_4_0 {
	meta:
		name = "__bid64_to_int64_ceil"
		size = 960
		refs = "0096 .refptr.__bid_nr_digits 00fc .refptr.__bid_ten2k64 0228 .refptr.__bid_IDEC_glbflags 0255 .refptr.__bid_ten2mk64 02ba .refptr.__bid_maskhigh128 02c5 .refptr.__bid_shiftright128 02f7 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 09 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 F0 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 14 10 41 83 FA 13 0F 8F 66 01 00 00 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 13 0F 84 BE 00 00 00 45 85 D2 0F 8E 61 01 00 00 85 D2 0F 88 69 01 00 00 0F 84 93 00 00 00 4D 85 C9 48 63 D2 0F 84 A7 02 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 0F 1F 44 00 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 4C 89 C2 4C 89 C0 48 F7 DA 4D 85 C9 48 0F 45 C2 5B 5E 5F C3 4D 89 C3 44 89 C1 49 C1 EB 20 4D 85 C9 0F 84 6B 01 00 00 41 B2 14 4C 89 DE 41 29 C2 49 63 C2 4C 8B 15 ?? ?? ?? ?? 4D 8B 14 C2 48 89 C8 4C 89 D3 45 89 D2 4C 89 D7 48 C1 EB 20 4C 0F AF D1 49 0F AF FB 48 0F AF C3 4D 89 D3 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 05 77 1E 48 C1 E0 20 45 89 D2 4C 01 D0 48 83 F8 09 0F 86 C4 FE FF FF 48 83 F9 05 0F 85 BA FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 D2 FE FF FF 66 90 31 C0 4D 85 C9 0F 94 C0 5B 5E 5F C3 0F 1F 40 00 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C2 F7 DA 48 63 DB 49 C1 EA 20 48 8B 0C D9 4D 89 D3 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F2 4D 0F AF D8 49 89 CA 89 C9 89 F7 49 C1 EA 20 48 C1 EE 20 4C 0F AF C0 49 01 FA 4D 01 D0 4E 8D 14 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C2 48 8B 05 ?? ?? ?? ?? 4C 8B 1C D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 4C 89 D0 48 D3 E8 83 FA 03 7E 19 4D 85 DA 74 14 4D 85 C9 75 29 48 83 C0 01 E9 26 FE FF FF 66 0F 1F 44 00 00 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 77 DB 4D 85 C9 0F 84 06 FE FF FF 48 F7 D8 E9 FE FD FF FF 41 BA 14 00 00 00 4C 89 DE 41 29 C2 49 63 C2 4C 8B 15 ?? ?? ?? ?? 4D 8B 14 C2 48 89 C8 4C 89 D3 45 89 D2 4C 89 D7 48 C1 EB 20 4C 0F AF D1 49 0F AF FB 48 0F AF C3 4D 89 D3 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 04 0F 87 AC FE FF FF 48 C1 E0 20 45 89 D2 4C 01 D0 48 83 F8 F6 0F 86 52 FD FF FF 48 83 F9 04 0F 85 48 FD FF FF E9 89 FE FF FF 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 5C FD FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_162_5_0 {
	meta:
		name = "__bid64_to_int64_xceil"
		size = 976
		refs = "0096 .refptr.__bid_nr_digits 017f .refptr.__bid_ten2k64 0227 .refptr.__bid_IDEC_glbflags 0265 .refptr.__bid_ten2mk64 02ca .refptr.__bid_maskhigh128 02d5 .refptr.__bid_shiftright128 030a .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 08 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 EF 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 B3 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 9A 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 14 10 41 83 FA 13 0F 8F 65 01 00 00 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 13 0F 84 BD 00 00 00 45 85 D2 0F 8E 61 01 00 00 85 D2 0F 88 79 01 00 00 0F 85 83 00 00 00 4C 89 C0 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 24 FF FF FF 0F 1F 84 00 00 00 00 00 4D 85 C9 48 63 D2 0F 84 34 02 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 E9 6A FF FF FF 4D 89 C3 44 89 C1 49 C1 EB 20 4D 85 C9 0F 84 7A 01 00 00 41 B2 14 4C 89 DE 41 29 C2 49 63 C2 4C 8B 15 ?? ?? ?? ?? 4D 8B 14 C2 48 89 C8 4C 89 D3 45 89 D2 4C 89 D7 48 C1 EB 20 4C 0F AF D1 49 0F AF FB 48 0F AF C3 4D 89 D3 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 05 77 1E 48 C1 E0 20 45 89 D2 4C 01 D0 48 83 F8 09 0F 86 C5 FE FF FF 48 83 F9 05 0F 85 BB FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 C0 FE FF FF 0F 1F 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 4D 85 C9 0F 94 C0 5B 5E 5F C3 66 2E 0F 1F 84 00 00 00 00 00 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C2 F7 DA 48 63 DB 49 C1 EA 20 48 8B 0C D9 4D 89 D3 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F2 4D 0F AF D8 49 89 CA 89 C9 89 F7 49 C1 EA 20 48 C1 EE 20 4C 0F AF C0 49 01 FA 4D 01 D0 4E 8D 14 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C2 48 8B 05 ?? ?? ?? ?? 4C 8B 1C D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 4C 89 D0 48 D3 E8 83 FA 03 7E 1C 4D 85 DA 74 17 48 8B 15 ?? ?? ?? ?? 49 83 F9 01 48 83 D0 00 83 0A 20 E9 ED FD FF FF 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 0F 86 D8 FD FF FF EB D2 66 0F 1F 44 00 00 41 BA 14 00 00 00 4C 89 DE 41 29 C2 49 63 C2 4C 8B 15 ?? ?? ?? ?? 4D 8B 14 C2 48 89 C8 4C 89 D3 45 89 D2 4C 89 D7 48 C1 EB 20 4C 0F AF D1 49 0F AF FB 48 0F AF C3 4D 89 D3 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 04 0F 87 9D FE FF FF 48 C1 E0 20 45 89 D2 4C 01 D0 48 83 F8 F6 0F 86 44 FD FF FF 48 83 F9 04 0F 85 3A FD FF FF E9 7A FE FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 39 FD FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_162_6_0 {
	meta:
		name = "__bid64_to_int64_int"
		size = 816
		refs = "0096 .refptr.__bid_nr_digits 017f .refptr.__bid_ten2k64 0227 .refptr.__bid_IDEC_glbflags 0243 .refptr.__bid_ten2mk64 028e .refptr.__bid_shiftright128"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 08 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 EF 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 B2 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 98 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 13 0F 8F 65 01 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 13 0F 84 BD 00 00 00 31 C0 45 85 C9 7E 1E 85 D2 0F 88 5B 01 00 00 0F 85 85 00 00 00 4C 89 C0 48 89 C2 48 F7 DA 4D 85 D2 48 0F 45 C2 5B 5E 5F C3 90 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CD 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 25 FF FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 D2 48 63 D2 0F 84 34 01 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 E9 68 FF FF FF 4D 85 D2 0F 84 28 01 00 00 41 B1 14 44 89 C1 4D 89 C3 41 29 C1 49 C1 EB 20 49 63 C1 4C 8B 0D ?? ?? ?? ?? 4C 89 DE 4D 8B 0C C1 48 89 C8 4C 89 CB 45 89 C9 4C 89 CF 48 C1 EB 20 4C 0F AF C9 49 0F AF FB 48 0F AF C3 4D 89 CB 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 05 77 1E 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 09 0F 86 C3 FE FF FF 48 83 F9 05 0F 85 B9 FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 BE FE FF FF 0F 1F 00 48 8B 05 ?? ?? ?? ?? F7 D2 4D 89 C1 48 63 D2 49 C1 E9 20 45 89 C0 4D 89 CB 48 8B 0C D0 48 89 C8 89 C9 48 89 CB 48 C1 E8 20 49 0F AF D9 49 0F AF C8 4C 0F AF C0 41 89 D9 48 C1 EB 20 48 C1 E9 20 4C 0F AF D8 4C 01 C9 4A 8D 04 01 48 8B 0D ?? ?? ?? ?? 48 C1 E8 20 4E 8D 0C 1B 8B 0C 91 49 8D 04 01 48 D3 E8 E9 45 FE FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 37 FE FF FF B9 14 00 00 00 4C 89 C3 45 89 C1 29 C1 48 C1 EB 20 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 89 DE 4C 8B 1C C1 4C 89 D9 45 89 DB 4C 89 DF 48 C1 E9 20 48 0F AF FB 4D 0F AF D9 48 0F AF F1 89 FB 48 C1 EF 20 49 C1 EB 20 49 0F AF C9 49 01 DB 48 8D 1C 37 49 8D 04 0B 48 C1 E8 20 48 01 D8 48 83 F8 04 0F 86 B4 FD FF FF E9 F6 FE FF FF 66 90 }
	condition:
		$1
}

rule file_162_7_0 {
	meta:
		name = "__bid64_to_int64_xint"
		size = 912
		refs = "0096 .refptr.__bid_nr_digits 017f .refptr.__bid_ten2k64 0227 .refptr.__bid_IDEC_glbflags 0245 .refptr.__bid_ten2mk64 02aa .refptr.__bid_maskhigh128 02b5 .refptr.__bid_shiftright128 02e7 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 08 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 EF 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 B3 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 9A 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 14 10 41 83 FA 13 0F 8F 65 01 00 00 49 B9 00 00 00 00 00 00 00 80 49 21 C9 41 83 FA 13 0F 84 BD 00 00 00 45 85 D2 0F 8E 21 02 00 00 85 D2 0F 88 59 01 00 00 0F 85 83 00 00 00 4C 89 C0 48 89 C2 48 F7 DA 4D 85 C9 48 0F 45 C2 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 24 FF FF FF 0F 1F 84 00 00 00 00 00 4D 85 C9 48 63 D2 0F 84 94 01 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 E9 6A FF FF FF 4D 85 C9 0F 84 88 01 00 00 41 B2 14 44 89 C1 4D 89 C3 41 29 C2 49 C1 EB 20 49 63 C2 4C 8B 15 ?? ?? ?? ?? 4C 89 DE 4D 8B 14 C2 48 89 C8 4C 89 D3 45 89 D2 4C 89 D7 48 C1 EB 20 4C 0F AF D1 49 0F AF FB 48 0F AF C3 4D 89 D3 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 05 77 1E 48 C1 E0 20 45 89 D2 4C 01 D0 48 83 F8 09 0F 86 C5 FE FF FF 48 83 F9 05 0F 85 BB FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 C0 FE FF FF 0F 1F 00 89 D3 48 8B 0D ?? ?? ?? ?? 44 89 C0 F7 D3 4D 89 C2 F7 DA 48 63 DB 49 C1 EA 20 48 8B 0C D9 4D 89 D3 49 89 C8 89 C9 48 89 CE 49 C1 E8 20 48 0F AF C8 49 0F AF F2 4D 0F AF D8 49 89 CA 89 C9 89 F7 49 C1 EA 20 48 C1 EE 20 4C 0F AF C0 49 01 FA 4D 01 D0 4E 8D 14 1E 4C 89 C0 49 C1 E0 20 48 C1 E8 20 49 01 C8 49 01 C2 48 8B 05 ?? ?? ?? ?? 4C 8B 1C D8 48 8B 05 ?? ?? ?? ?? 8B 0C 98 4C 89 D0 48 D3 E8 83 FA 03 7E 19 4D 85 DA 74 14 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 15 FE FF FF 0F 1F 44 00 00 48 C1 E3 04 48 03 1D ?? ?? ?? ?? 4C 3B 43 08 0F 86 FB FD FF FF EB D5 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 5B 5E 5F C3 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 D9 FD FF FF B9 14 00 00 00 4C 89 C3 45 89 C2 29 C1 48 C1 EB 20 48 63 C1 48 8B 0D ?? ?? ?? ?? 48 89 DE 4C 8B 1C C1 4C 89 D9 45 89 DB 4C 89 DF 48 C1 E9 20 48 0F AF FB 4D 0F AF DA 48 0F AF F1 89 FB 48 C1 EF 20 49 C1 EB 20 49 0F AF CA 49 01 DB 48 8D 1C 37 49 8D 04 0B 48 C1 E8 20 48 01 D8 48 83 F8 04 0F 86 56 FD FF FF E9 96 FE FF FF 66 90 }
	condition:
		$1
}

rule file_162_8_0 {
	meta:
		name = "__bid64_to_int64_rninta"
		size = 816
		refs = "0096 .refptr.__bid_nr_digits 00e9 .refptr.__bid_midpoint64 0181 .refptr.__bid_ten2k64 0248 .refptr.__bid_ten2mk64 0291 .refptr.__bid_shiftright128 02f6 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 D7 02 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 BE 02 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 B6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 9D 00 00 00 66 0F EF C0 48 8D 14 09 48 89 D0 F2 49 0F 2A C0 48 C1 E8 36 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 44 8B 0A 45 85 C9 75 0C 4C 3B 42 10 44 8B 4A 18 41 83 D9 FF 8D 90 72 FE FF FF 45 8D 14 11 41 83 FA 13 0F 8F 31 02 00 00 49 BB 00 00 00 00 00 00 00 80 49 21 CB 41 83 FA 13 0F 84 97 00 00 00 31 C0 45 85 D2 78 20 0F 85 1A 01 00 00 48 8B 15 ?? ?? ?? ?? 41 83 E9 01 4D 63 C9 4E 3B 04 CA 0F 83 22 01 00 00 66 90 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 89 D0 4C 89 C2 48 C1 EA 20 48 C1 E8 36 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 21 FF FF FF 0F 1F 44 00 00 B9 14 00 00 00 44 89 C0 4D 89 C2 44 29 C9 4C 8B 0D ?? ?? ?? ?? 49 C1 EA 20 48 63 C9 4C 89 D6 49 8B 0C C9 48 89 CB 89 C9 49 89 C9 48 C1 EB 20 48 0F AF C8 4D 0F AF CA 48 0F AF C3 49 89 CA 44 89 CF 49 C1 EA 20 49 C1 E9 20 48 0F AF F3 49 01 FA 4C 01 D0 49 89 C2 49 C1 EA 20 49 01 F1 4D 01 D1 4D 85 DB 0F 84 F7 00 00 00 49 83 F9 05 0F 87 10 01 00 00 48 C1 E0 20 89 C9 48 01 C8 48 83 F8 04 76 0E 49 83 F9 05 0F 84 F7 00 00 00 0F 1F 40 00 85 D2 78 2E 0F 85 A6 00 00 00 4C 89 C0 48 89 C2 48 F7 DA 4D 85 DB 48 0F 45 C2 5B 5E 5F C3 66 90 49 83 FB 01 48 19 C0 83 E0 02 48 83 E8 01 5B 5E 5F C3 48 8B 05 ?? ?? ?? ?? F7 D2 4C 63 D2 4C 89 C2 4A 03 14 D0 48 8B 05 ?? ?? ?? ?? 4A 8B 0C D0 49 89 D1 89 D3 49 C1 E9 20 48 89 CA 4C 89 C8 89 C9 48 0F AF C1 48 C1 EA 20 4D 89 C8 48 0F AF CB 4C 0F AF C2 41 89 C1 48 C1 E8 20 48 C1 E9 20 48 0F AF D3 4C 01 C9 4E 8D 0C 00 48 8D 04 11 48 8B 15 ?? ?? ?? ?? 48 C1 E8 20 42 8B 0C 92 4C 01 C8 48 D3 E8 E9 65 FF FF FF 0F 1F 84 00 00 00 00 00 4D 85 DB 48 63 D2 74 58 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 E9 31 FE FF FF 90 49 83 F9 04 77 1D 48 C1 E0 20 89 C9 48 01 C8 48 83 F8 FA 0F 86 17 FF FF FF 49 83 F9 04 0F 85 0D FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 F4 FD FF FF 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 DC FD FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_162_9_0 {
	meta:
		name = "__bid64_to_int64_xrninta"
		size = 1104
		refs = "0096 .refptr.__bid_nr_digits 00e8 .refptr.__bid_midpoint64 0101 .refptr.__bid_IDEC_glbflags 01a2 .refptr.__bid_ten2k64 0269 .refptr.__bid_ten2mk64 02c9 .refptr.__bid_maskhigh128 02d4 .refptr.__bid_shiftright128 02ee .refptr.__bid_onehalf128 030c .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 C8 03 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 AF 03 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 C6 00 00 00 49 B8 FF FF FF FF FF FF 1F 00 31 C0 49 21 C8 0F 84 AD 00 00 00 66 0F EF C0 48 8D 14 09 48 C1 EA 36 F2 49 0F 2A C0 49 89 D1 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 02 85 C0 75 0A 4C 3B 42 10 8B 42 18 83 D8 FF 41 8D 91 72 FE FF FF 44 8D 0C 10 41 83 F9 13 0F 8F 25 03 00 00 49 BA 00 00 00 00 00 00 00 80 49 21 CA 41 83 F9 13 0F 84 AA 00 00 00 45 85 C9 0F 88 51 02 00 00 0F 85 2C 01 00 00 48 8B 0D ?? ?? ?? ?? 83 E8 01 48 63 D0 31 C0 4C 3B 04 D1 0F 83 32 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 0F 1F 84 00 00 00 00 00 5B 5E 5F C3 49 B8 FF FF FF FF FF FF 07 00 48 BA FF FF C0 6F F2 86 23 00 4C 89 C0 49 B8 00 00 00 00 00 00 20 00 48 21 C8 49 09 C0 31 C0 49 39 D0 77 CE 48 8D 14 CD 00 00 00 00 66 0F EF C9 48 C1 EA 36 49 89 D1 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 E9 11 FF FF FF 0F 1F 44 00 00 4D 89 C3 44 89 C1 49 C1 EB 20 4D 85 D2 0F 84 D0 01 00 00 41 B1 14 4C 89 DE 41 29 C1 49 63 C1 4C 8B 0D ?? ?? ?? ?? 4D 8B 0C C1 48 89 C8 4C 89 CB 45 89 C9 4C 89 CF 48 C1 EB 20 4C 0F AF C9 49 0F AF FB 48 0F AF C3 4D 89 CB 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 05 0F 87 ED 01 00 00 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 04 76 0A 48 83 F9 05 0F 84 D3 01 00 00 85 D2 78 3B 0F 85 25 01 00 00 4C 89 C0 48 89 C2 48 F7 DA 4D 85 D2 48 0F 45 C2 5B 5E 5F C3 90 49 83 FA 01 48 8B 15 ?? ?? ?? ?? 48 19 C0 83 E0 02 48 83 E8 01 83 0A 20 E9 C3 FE FF FF 0F 1F 00 41 89 D3 48 8B 05 ?? ?? ?? ?? F7 DA 41 F7 D3 4D 63 DB 4E 03 04 D8 48 8B 05 ?? ?? ?? ?? 4A 8B 04 D8 4C 89 C3 44 89 C1 48 C1 EB 20 49 89 C1 48 89 DE 89 C0 49 C1 E9 20 48 0F AF F0 49 0F AF D9 48 0F AF C1 89 F7 48 C1 EE 20 49 89 D8 4C 0F AF C9 48 89 C3 89 C0 48 C1 EB 20 48 01 FB 4A 8D 0C 0B 4A 8D 1C 06 49 89 C8 48 C1 E1 20 49 C1 E8 20 4C 01 C3 4C 8D 04 01 48 8B 05 ?? ?? ?? ?? 4E 8B 0C D8 48 8B 05 ?? ?? ?? ?? 42 8B 0C 98 48 89 D8 48 D3 E8 83 FA 03 0F 8E 29 01 00 00 48 8B 15 ?? ?? ?? ?? 4C 21 CB 4A 3B 1C DA 77 25 75 23 4D 85 C0 74 1E 49 C1 E3 04 4C 89 DA 48 03 15 ?? ?? ?? ?? 4C 3B 42 08 0F 86 04 FF FF FF 66 0F 1F 44 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 EF FE FF FF 90 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 5B 5E 5F C3 4D 85 D2 48 63 D2 0F 84 B4 00 00 00 48 8B 05 ?? ?? ?? ?? 49 F7 D8 4C 0F AF 04 D0 4C 89 C0 E9 AD FD FF FF 41 B9 14 00 00 00 4C 89 DE 41 29 C1 49 63 C1 4C 8B 0D ?? ?? ?? ?? 4D 8B 0C C1 48 89 C8 4C 89 CB 45 89 C9 4C 89 CF 48 C1 EB 20 4C 0F AF C9 49 0F AF FB 48 0F AF C3 4D 89 CB 89 F9 49 C1 EB 20 48 C1 EF 20 48 0F AF F3 49 01 CB 48 89 F9 4C 01 D8 49 89 C3 49 C1 EB 20 48 01 F1 4C 01 D9 48 83 F9 04 77 1E 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 FA 0F 86 37 FE FF FF 48 83 F9 04 0F 85 2D FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 E9 13 FD FF FF 0F 1F 00 48 8B 05 ?? ?? ?? ?? 4C 0F AF 04 D0 4C 89 C0 E9 FC FC FF FF 48 BA 00 00 00 00 00 00 00 80 49 39 D0 0F 86 F9 FE FF FF 49 C1 E3 04 4C 01 C2 4C 89 D9 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 DC FD FF FF E9 D9 FE FF FF 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__bid64_to_uint64_rnint"
		size = 928
		refs = "0091 .refptr.__bid_nr_digits 00e0 .refptr.__bid_midpoint64 0103 .refptr.__bid_IDEC_glbflags 01ad .refptr.__bid_ten2k64 026b .refptr.__bid_ten2mk64 02bc .refptr.__bid_shiftright128 02d4 .refptr.__bid_maskhigh128 02f5 .refptr.__bid_ten2mk128trunc 0315 .refptr.__bid_ten2k128"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 E4 00 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 CB 00 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 D2 00 00 00 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 0F 84 B1 00 00 00 66 0F EF C0 4C 8D 04 09 49 C1 E8 36 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 08 45 85 C9 75 0C 48 3B 50 10 44 8B 48 18 41 83 D9 FF 41 81 E8 8E 01 00 00 43 8D 04 01 83 F8 14 7F 47 49 BA 00 00 00 00 00 00 00 80 4C 21 D1 83 F8 14 0F 84 B3 00 00 00 85 C0 0F 88 74 01 00 00 0F 85 63 01 00 00 4C 8B 05 ?? ?? ?? ?? 41 83 E9 01 31 C0 4D 63 C9 4B 3B 14 C8 76 21 48 85 C9 B0 01 74 1A 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E 5F C3 0F 1F 84 00 00 00 00 00 48 BA FF FF FF FF FF FF 07 00 49 B8 FF FF C0 6F F2 86 23 00 48 89 D0 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 C6 66 0F EF C9 48 89 D0 48 C1 E8 20 4C 8D 04 CD 00 00 00 00 F2 48 0F 2A C8 49 C1 E8 36 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 05 FF FF FF 48 85 C9 0F 85 75 FF FF FF 41 83 F9 01 0F 84 7D 01 00 00 41 BA 15 00 00 00 89 D0 48 89 D1 45 29 CA 48 C1 E9 20 4D 63 CA 4C 8B 15 ?? ?? ?? ?? 4F 8B 0C CA 4C 89 CB 45 89 C9 4D 89 CA 48 C1 EB 20 4C 0F AF C8 4C 0F AF D1 48 0F AF C3 4D 89 CB 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 D8 4C 01 D1 49 89 C2 49 C1 EA 20 4C 01 D1 48 83 F9 09 0F 87 03 FF FF FF 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 FA 76 0A 48 83 F9 09 0F 84 E9 FE FF FF 45 85 C0 78 36 48 89 D0 0F 84 EF FE FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 DB FE FF FF 0F 1F 80 00 00 00 00 48 85 C9 0F 85 B7 FE FF FF EB CC 31 C0 E9 C2 FE FF FF 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 63 D0 4A 03 14 D0 89 D0 49 89 D1 48 8B 15 ?? ?? ?? ?? 49 C1 E9 20 4E 8B 04 D2 4C 89 CA 4C 89 C1 45 89 C0 49 0F AF D0 48 C1 E9 20 4C 0F AF C0 4C 0F AF C9 89 D3 48 C1 EA 20 4D 89 C3 45 89 C0 48 0F AF C8 49 C1 EB 20 49 01 DB 49 8D 04 0B 4A 8D 0C 0A 48 89 C2 48 C1 E0 20 49 01 C0 48 8B 05 ?? ?? ?? ?? 48 C1 EA 20 48 01 CA 42 8B 0C 90 48 89 D0 48 D3 E8 48 8B 0D ?? ?? ?? ?? 4A 85 14 D1 0F 85 32 FE FF FF 4D 85 C0 0F 84 29 FE FF FF 4C 89 D2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 4C 3B 42 08 0F 87 11 FE FF FF 31 D2 A8 01 0F 95 C2 48 29 D0 E9 02 FE FF FF 48 8B 1D ?? ?? ?? ?? 48 89 D6 89 D1 48 C1 EE 20 49 89 F1 4C 8B 13 4D 89 D3 45 89 D2 4D 0F AF CA 49 C1 EB 20 4C 0F AF D1 49 0F AF CB 44 89 CF 49 C1 E9 20 4C 89 D0 48 C1 E8 20 48 01 F8 48 01 C8 48 89 D1 48 0F AF 4B 08 4C 0F AF DE 49 01 CB 48 89 C1 4D 01 D9 48 C1 E9 20 49 01 C9 49 83 F9 09 0F 87 88 FD FF FF 0F 85 99 FE FF FF 48 C1 E0 20 44 89 D1 48 01 C8 48 83 F8 FA 0F 87 6E FD FF FF E9 80 FE FF FF 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "__bid64_to_uint64_xrnint"
		size = 1056
		refs = "0091 .refptr.__bid_nr_digits 00e4 .refptr.__bid_midpoint64 010a .refptr.__bid_IDEC_glbflags 0119 .refptr.__bid_ten2k128 023d .refptr.__bid_ten2k64 0304 .refptr.__bid_ten2mk64 0364 .refptr.__bid_maskhigh128 0372 .refptr.__bid_shiftright128 039e .refptr.__bid_ten2mk128trunc 03ee .refptr.__bid_onehalf128"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 78 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 5F 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 62 01 00 00 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 0F 84 45 01 00 00 66 0F EF C0 4C 8D 04 09 49 C1 E8 36 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 08 45 85 C9 75 0C 48 3B 50 10 44 8B 48 18 41 83 D9 FF 41 81 E8 8E 01 00 00 43 8D 04 01 83 F8 14 0F 8F D7 00 00 00 49 BA 00 00 00 00 00 00 00 80 4C 21 D1 83 F8 14 0F 84 3F 01 00 00 85 C0 0F 88 00 02 00 00 0F 85 E8 01 00 00 48 8B 05 ?? ?? ?? ?? 41 83 E9 01 4D 63 C9 4A 3B 14 C8 0F 86 DB 01 00 00 48 85 C9 B8 01 00 00 00 0F 85 8D 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 92 00 00 00 48 8B 1D ?? ?? ?? ?? 48 89 D6 41 89 D1 48 C1 EE 20 49 89 F2 48 8B 03 49 89 C3 89 C0 4C 0F AF D0 49 C1 EB 20 49 0F AF C1 4D 0F AF CB 44 89 D7 49 C1 EA 20 48 89 C1 48 C1 E9 20 48 01 F9 4C 01 C9 49 89 D1 4C 0F AF 4B 08 4C 0F AF DE 4D 01 CB 4D 89 D1 49 89 CA 4D 01 D9 49 C1 EA 20 4D 01 D1 49 83 F9 09 77 19 0F 85 26 01 00 00 48 C1 E1 20 89 C0 48 01 C1 48 83 F9 FA 0F 86 13 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E 5F C3 0F 1F 40 00 48 BA FF FF FF FF FF FF 07 00 49 B8 FF FF C0 6F F2 86 23 00 48 89 D0 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 CA 66 0F EF C9 48 89 D0 48 C1 E8 20 4C 8D 04 CD 00 00 00 00 F2 48 0F 2A C8 49 C1 E8 36 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 75 FE FF FF 48 85 C9 0F 85 79 FF FF FF 41 83 F9 01 0F 84 F1 FE FF FF 41 BA 15 00 00 00 89 D0 48 89 D1 45 29 CA 48 C1 E9 20 4D 63 CA 4C 8B 15 ?? ?? ?? ?? 4F 8B 0C CA 4C 89 CB 45 89 C9 4D 89 CA 48 C1 EB 20 4C 0F AF C8 4C 0F AF D1 48 0F AF C3 4D 89 CB 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 D8 4C 01 D1 49 89 C2 49 C1 EA 20 4C 01 D1 48 83 F9 09 0F 87 07 FF FF FF 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 FA 76 0A 48 83 F9 09 0F 84 ED FE FF FF 45 85 C0 78 40 48 89 D0 0F 84 F3 FE FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 DF FE FF FF 48 85 C9 0F 85 C2 FE FF FF EB D3 31 C0 E9 2C FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 BC FE FF FF 44 89 C0 48 8B 0D ?? ?? ?? ?? 41 F7 D8 F7 D0 48 98 48 03 14 C1 48 8B 0D ?? ?? ?? ?? 4C 8B 14 C1 49 89 D1 89 D2 49 C1 E9 20 4C 89 D1 4D 89 CB 45 89 D2 4D 0F AF DA 48 C1 E9 20 4C 0F AF D2 4C 0F AF C9 44 89 DE 4C 89 D3 45 89 D2 48 0F AF CA 48 C1 EB 20 48 01 F3 48 8D 14 0B 4C 89 D9 48 C1 E9 20 4C 01 C9 49 89 D1 48 C1 E2 20 49 C1 E9 20 4C 01 D2 49 01 C9 48 8B 0D ?? ?? ?? ?? 4D 89 CA 4C 23 14 C1 48 8B 0D ?? ?? ?? ?? 8B 0C 81 49 D3 E9 41 83 F8 03 7F 69 48 B9 00 00 00 00 00 00 00 80 48 39 CA 76 17 49 89 C0 48 01 D1 49 C1 E0 04 4C 03 05 ?? ?? ?? ?? 49 3B 48 08 76 0A 48 8B 0D ?? ?? ?? ?? 83 09 20 4D 85 D2 75 61 48 85 D2 74 5C 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 89 C1 4C 89 C8 48 3B 51 08 0F 87 D1 FD FF FF 4C 89 C8 31 D2 41 80 E1 01 0F 95 C2 48 29 D0 E9 BD FD FF FF 48 8B 0D ?? ?? ?? ?? 4C 3B 14 C1 77 B0 75 AE 48 85 D2 74 A9 48 89 C1 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 77 95 4D 85 D2 74 BF 4C 89 C8 E9 88 FD FF FF }
	condition:
		$1
}

rule file_164_2_0 {
	meta:
		name = "__bid64_to_uint64_floor"
		size = 688
		refs = "0073 .refptr.__bid_IDEC_glbflags 0128 .refptr.__bid_nr_digits 0171 .refptr.__bid_ten2k64 0200 .refptr.__bid_ten2mk64 0240 .refptr.__bid_shiftright128 025a .refptr.__bid_ten2k128"
	strings:
		$1 = { 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 74 59 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 74 44 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 74 4F 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 49 89 D0 74 2F 48 8D 04 09 48 C1 E8 36 48 85 C9 0F 89 9A 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E C3 66 0F 1F 84 00 00 00 00 00 48 B8 FF FF FF FF FF FF 07 00 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 D0 48 BA FF FF C0 6F F2 86 23 00 49 89 C0 31 C0 49 39 D0 77 C6 48 8D 04 CD 00 00 00 00 48 C1 E8 36 48 85 C9 78 A1 66 0F EF C9 4C 89 C2 48 C1 EA 20 F2 48 0F 2A CA 66 48 0F 7E CA 48 C1 EA 34 81 E2 FF 07 00 00 81 EA DE 03 00 00 EB 28 66 2E 0F 1F 84 00 00 00 00 00 66 0F EF C0 F2 48 0F 2A C2 66 48 0F 7E C2 48 C1 EA 34 81 E2 FF 07 00 00 81 EA FE 03 00 00 83 EA 01 48 C1 E2 05 48 03 15 ?? ?? ?? ?? 8B 0A 85 C9 75 0A 4C 3B 42 10 8B 4A 18 83 D9 FF 8D 90 72 FE FF FF 44 8D 0C 11 41 83 F9 14 0F 8F 20 FF FF FF 74 30 31 C0 45 85 C9 0F 8E 27 FF FF FF 85 D2 0F 88 8D 00 00 00 4C 89 C0 0F 84 16 FF FF FF 48 8B 0D ?? ?? ?? ?? 48 63 D2 48 0F AF 04 D1 E9 02 FF FF FF 83 F9 01 0F 84 CC 00 00 00 41 BA 15 00 00 00 4D 89 C1 44 89 C0 41 29 CA 49 C1 E9 20 49 63 CA 4C 8B 15 ?? ?? ?? ?? 49 8B 0C CA 49 89 CB 89 C9 49 89 CA 49 C1 EB 20 4D 0F AF D1 48 0F AF C8 4D 0F AF CB 44 89 D3 49 C1 EA 20 48 C1 E9 20 49 0F AF C3 48 01 D9 4D 01 D1 48 01 C8 48 C1 E8 20 4C 01 C8 48 83 F8 09 0F 87 83 FE FF FF E9 6B FF FF FF F7 D2 4D 89 C1 44 89 C0 4C 63 D2 48 8B 15 ?? ?? ?? ?? 49 C1 E9 20 4A 8B 0C D2 48 89 CA 89 C9 49 89 C8 48 C1 EA 20 4D 0F AF C1 48 0F AF C8 4C 0F AF CA 45 89 C3 49 C1 E8 20 48 C1 E9 20 48 0F AF D0 4C 01 D9 4D 01 C8 48 8D 04 11 48 8B 15 ?? ?? ?? ?? 48 C1 E8 20 42 8B 0C 92 4C 01 C0 48 D3 E8 E9 2D FE FF FF 48 8B 1D ?? ?? ?? ?? 4D 89 C3 45 89 C2 49 C1 EB 20 4D 89 D9 48 8B 03 48 89 C1 89 C0 4C 0F AF C8 48 C1 E9 20 49 0F AF C2 4C 0F AF D9 44 89 CE 49 C1 E9 20 48 C1 E8 20 48 01 F0 4C 89 C6 48 0F AF 73 08 49 0F AF CA 49 01 F3 4D 01 D9 E9 31 FF FF FF 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_3_0 {
	meta:
		name = "__bid64_to_uint64_xfloor"
		size = 832
		refs = "0073 .refptr.__bid_IDEC_glbflags 0126 .refptr.__bid_nr_digits 016d .refptr.__bid_ten2k64 01f3 .refptr.__bid_ten2mk64 024f .refptr.__bid_maskhigh128 0264 .refptr.__bid_shiftright128 0282 .refptr.__bid_ten2mk128trunc 02e5 .refptr.__bid_ten2k128"
	strings:
		$1 = { 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 74 59 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 74 44 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 74 4F 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 74 32 48 8D 04 09 48 C1 E8 36 48 85 C9 49 89 C0 0F 89 9A 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E C3 66 0F 1F 84 00 00 00 00 00 48 BA FF FF FF FF FF FF 07 00 49 B8 FF FF C0 6F F2 86 23 00 48 89 D0 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 C6 48 8D 04 CD 00 00 00 00 48 C1 E8 36 48 85 C9 49 89 C0 78 9E 66 0F EF C9 48 89 D0 48 C1 E8 20 F2 48 0F 2A C8 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 EB 25 66 0F 1F 84 00 00 00 00 00 66 0F EF C0 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 8B 08 85 C9 75 0A 48 3B 50 10 8B 48 18 83 D9 FF 41 81 E8 8E 01 00 00 42 8D 04 01 83 F8 14 0F 8F 22 FF FF FF 74 2E 85 C0 0F 8E 47 01 00 00 45 85 C0 0F 88 8C 00 00 00 48 89 D0 0F 84 1A FF FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 06 FF FF FF 83 F9 01 0F 84 5B 01 00 00 41 BA 15 00 00 00 49 89 D1 89 D0 41 29 CA 49 C1 E9 20 49 63 CA 4C 8B 15 ?? ?? ?? ?? 49 8B 0C CA 49 89 CB 89 C9 49 89 CA 49 C1 EB 20 4D 0F AF D1 48 0F AF C8 4D 0F AF CB 44 89 D3 49 C1 EA 20 48 C1 E9 20 49 0F AF C3 48 01 D9 4D 01 D1 48 01 C8 48 C1 E8 20 4C 01 C8 48 83 F8 09 0F 87 88 FE FF FF E9 6B FF FF FF 45 89 C1 48 8B 05 ?? ?? ?? ?? 48 89 D1 41 F7 D1 89 D2 48 C1 E9 20 4D 63 C9 41 F7 D8 4A 8B 04 C8 48 89 C3 89 C0 49 89 C2 48 C1 EB 20 48 0F AF C2 4C 0F AF D1 48 0F AF D3 49 89 C3 89 C0 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 DA 4C 01 D1 49 89 D2 48 C1 E2 20 48 01 C2 48 8B 05 ?? ?? ?? ?? 49 C1 EA 20 49 01 CA 4D 89 D3 4A 8B 1C C8 48 8B 05 ?? ?? ?? ?? 42 8B 0C 88 49 D3 EB 41 83 F8 03 7F 3B 4C 89 C9 4C 89 D8 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 F4 FD FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 E5 FD FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 D4 FD FF FF 49 85 DA 75 1B 4C 89 C9 4C 89 D8 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 B4 FD FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 4C 89 D8 E9 A2 FD FF FF 48 8B 1D ?? ?? ?? ?? 49 89 D3 41 89 D2 49 C1 EB 20 4D 89 D9 48 8B 03 48 89 C1 89 C0 4C 0F AF C8 48 C1 E9 20 49 0F AF C2 4C 0F AF D9 44 89 CE 49 C1 E9 20 48 C1 E8 20 48 01 F0 48 89 D6 48 0F AF 73 08 49 0F AF CA 49 01 F3 4D 01 D9 E9 A1 FE FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_4_0 {
	meta:
		name = "__bid64_to_uint64_ceil"
		size = 912
		refs = "0091 .refptr.__bid_nr_digits 00f5 .refptr.__bid_ten2k64 01a8 .refptr.__bid_IDEC_glbflags 0232 .refptr.__bid_ten2mk64 028e .refptr.__bid_maskhigh128 02a3 .refptr.__bid_shiftright128 02c5 .refptr.__bid_ten2mk128trunc 02d9 .refptr.__bid_ten2k128"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 89 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 70 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 72 01 00 00 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 0F 84 56 01 00 00 66 0F EF C0 4C 8D 04 09 49 C1 E8 36 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 08 45 85 C9 75 0C 48 3B 50 10 44 8B 48 18 41 83 D9 FF 41 81 E8 8E 01 00 00 43 8D 04 01 83 F8 14 0F 8F E8 00 00 00 49 BA 00 00 00 00 00 00 00 80 4C 21 D1 83 F8 14 74 41 85 C0 0F 8E 4B 01 00 00 48 85 C9 0F 85 C5 00 00 00 45 85 C0 0F 88 43 01 00 00 48 89 D0 0F 84 C7 00 00 00 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 B3 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 85 C9 0F 85 8C 00 00 00 41 83 F9 01 0F 84 B3 01 00 00 41 BA 15 00 00 00 89 D0 48 89 D1 45 29 CA 48 C1 E9 20 4D 63 CA 4C 8B 15 ?? ?? ?? ?? 4F 8B 0C CA 4C 89 CB 45 89 C9 4D 89 CA 48 C1 EB 20 4C 0F AF C8 4C 0F AF D1 48 0F AF C3 4D 89 CB 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 D8 4C 01 D1 49 89 C2 49 C1 EA 20 4C 01 D1 48 83 F9 09 77 1E 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 F6 0F 86 45 FF FF FF 48 83 F9 09 0F 85 3B FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E 5F C3 0F 1F 00 48 BA FF FF FF FF FF FF 07 00 49 B8 FF FF C0 6F F2 86 23 00 48 89 D0 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 CB 66 0F EF C9 48 89 D0 48 C1 E8 20 4C 8D 04 CD 00 00 00 00 F2 48 0F 2A C8 49 C1 E8 36 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 65 FE FF FF 31 C0 48 85 C9 0F 94 C0 EB 8D 45 89 C1 48 8B 05 ?? ?? ?? ?? 48 89 D1 41 F7 D1 89 D2 48 C1 E9 20 4D 63 C9 41 F7 D8 4A 8B 04 C8 48 89 C3 89 C0 49 89 C2 48 C1 EB 20 48 0F AF C2 4C 0F AF D1 48 0F AF D3 49 89 C3 89 C0 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 DA 4C 01 D1 49 89 D2 48 C1 E2 20 48 01 C2 48 8B 05 ?? ?? ?? ?? 49 C1 EA 20 49 01 CA 4D 89 D3 4A 8B 1C C8 48 8B 05 ?? ?? ?? ?? 42 8B 0C 88 49 D3 EB 41 83 F8 03 0F 8F A8 00 00 00 4C 89 C9 4C 89 D8 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 39 51 08 48 83 D0 00 E9 E3 FE FF FF 48 8B 1D ?? ?? ?? ?? 48 89 D6 41 89 D1 48 C1 EE 20 49 89 F2 48 8B 03 49 89 C3 89 C0 4C 0F AF D0 49 C1 EB 20 49 0F AF C1 4D 0F AF CB 44 89 D7 49 C1 EA 20 48 89 C1 48 C1 E9 20 48 01 F9 4C 01 C9 49 89 D1 4C 0F AF 4B 08 4C 0F AF DE 4D 01 CB 4F 8D 0C 13 49 89 CA 49 C1 EA 20 4D 01 D1 49 83 F9 09 0F 87 68 FE FF FF 0F 85 9D FD FF FF 48 C1 E1 20 89 C0 48 01 C1 48 83 F9 F6 0F 87 4F FE FF FF E9 85 FD FF FF 0F 1F 44 00 00 49 85 DA 75 1B 4C 89 C9 4C 89 D8 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 39 FE FF FF 49 8D 43 01 E9 30 FE FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_164_5_0 {
	meta:
		name = "__bid64_to_uint64_xceil"
		size = 960
		refs = "0091 .refptr.__bid_nr_digits 00f5 .refptr.__bid_ten2k64 01a8 .refptr.__bid_IDEC_glbflags 023f .refptr.__bid_ten2mk64 029b .refptr.__bid_maskhigh128 02b0 .refptr.__bid_shiftright128 02d2 .refptr.__bid_ten2mk128trunc 02f6 .refptr.__bid_ten2k128"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 89 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 70 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 72 01 00 00 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 0F 84 56 01 00 00 66 0F EF C0 4C 8D 04 09 49 C1 E8 36 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 08 45 85 C9 75 0C 48 3B 50 10 44 8B 48 18 41 83 D9 FF 41 81 E8 8E 01 00 00 43 8D 04 01 83 F8 14 0F 8F E8 00 00 00 49 BA 00 00 00 00 00 00 00 80 4C 21 D1 83 F8 14 74 41 85 C0 0F 8E 4B 01 00 00 48 85 C9 0F 85 C5 00 00 00 45 85 C0 0F 88 50 01 00 00 48 89 D0 0F 84 C7 00 00 00 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 B3 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 85 C9 0F 85 8C 00 00 00 41 83 F9 01 0F 84 D0 01 00 00 41 BA 15 00 00 00 89 D0 48 89 D1 45 29 CA 48 C1 E9 20 4D 63 CA 4C 8B 15 ?? ?? ?? ?? 4F 8B 0C CA 4C 89 CB 45 89 C9 4D 89 CA 48 C1 EB 20 4C 0F AF C8 4C 0F AF D1 48 0F AF C3 4D 89 CB 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 D8 4C 01 D1 49 89 C2 49 C1 EA 20 4C 01 D1 48 83 F9 09 77 1E 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 F6 0F 86 45 FF FF FF 48 83 F9 09 0F 85 3B FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E 5F C3 0F 1F 00 48 BA FF FF FF FF FF FF 07 00 49 B8 FF FF C0 6F F2 86 23 00 48 89 D0 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 CB 66 0F EF C9 48 89 D0 48 C1 E8 20 4C 8D 04 CD 00 00 00 00 F2 48 0F 2A C8 49 C1 E8 36 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 65 FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 48 85 C9 0F 94 C0 E9 80 FF FF FF 45 89 C1 48 8B 05 ?? ?? ?? ?? 48 89 D1 41 F7 D1 89 D2 48 C1 E9 20 4D 63 C9 41 F7 D8 4A 8B 04 C8 48 89 C3 89 C0 49 89 C2 48 C1 EB 20 48 0F AF C2 4C 0F AF D1 48 0F AF D3 49 89 C3 89 C0 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 DA 4C 01 D1 49 89 D2 48 C1 E2 20 48 01 C2 48 8B 05 ?? ?? ?? ?? 49 C1 EA 20 49 01 CA 4D 89 D3 4A 8B 1C C8 48 8B 05 ?? ?? ?? ?? 42 8B 0C 88 49 D3 EB 41 83 F8 03 0F 8F BB 00 00 00 4C 89 C9 4C 89 D8 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 D9 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 83 C0 01 83 0A 20 E9 C6 FE FF FF 48 8B 1D ?? ?? ?? ?? 48 89 D6 41 89 D1 48 C1 EE 20 49 89 F2 48 8B 03 49 89 C3 89 C0 4C 0F AF D0 49 C1 EB 20 49 0F AF C1 4D 0F AF CB 44 89 D7 49 C1 EA 20 48 89 C1 48 C1 E9 20 48 01 F9 4C 01 C9 49 89 D1 4C 0F AF 4B 08 4C 0F AF DE 4D 01 CB 4F 8D 0C 13 49 89 CA 49 C1 EA 20 4D 01 D1 49 83 F9 09 0F 87 4B FE FF FF 0F 85 80 FD FF FF 48 C1 E1 20 89 C0 48 01 C1 48 83 F9 F6 0F 87 32 FE FF FF E9 68 FD FF FF 0F 1F 84 00 00 00 00 00 49 85 DA 75 1B 4C 89 C9 4C 89 D8 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 19 FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 49 8D 43 01 E9 06 FE FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_6_0 {
	meta:
		name = "__bid64_to_uint64_int"
		size = 688
		refs = "0090 .refptr.__bid_nr_digits 00f4 .refptr.__bid_ten2k64 0177 .refptr.__bid_IDEC_glbflags 01fb .refptr.__bid_ten2mk64 0241 .refptr.__bid_shiftright128 025b .refptr.__bid_ten2k128"
	strings:
		$1 = { 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 59 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 40 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 43 01 00 00 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 0F 84 26 01 00 00 66 0F EF C0 4C 8D 04 09 49 C1 E8 36 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 08 45 85 C9 75 0C 48 3B 50 10 44 8B 48 18 41 83 D9 FF 41 81 E8 8E 01 00 00 43 8D 04 01 83 F8 14 0F 8F B8 00 00 00 49 BA 00 00 00 00 00 00 00 80 4C 21 D1 83 F8 14 74 37 85 C0 0F 8E 19 01 00 00 48 85 C9 0F 85 95 00 00 00 45 85 C0 0F 88 0B 01 00 00 48 89 D0 0F 84 97 00 00 00 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 83 00 00 00 48 85 C9 75 6A 41 83 F9 01 0F 84 44 01 00 00 B9 15 00 00 00 49 89 D2 89 D0 44 29 C9 4C 8B 0D ?? ?? ?? ?? 49 C1 EA 20 48 63 C9 49 8B 0C C9 49 89 CB 89 C9 49 89 C9 49 C1 EB 20 4D 0F AF CA 48 0F AF C8 4D 0F AF D3 44 89 CB 49 C1 E9 20 48 C1 E9 20 49 0F AF C3 48 01 D9 4D 01 D1 48 01 C8 48 C1 E8 20 4C 01 C8 48 83 F8 09 0F 86 6B FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E C3 0F 1F 44 00 00 48 B8 FF FF FF FF FF FF 07 00 48 BA 00 00 00 00 00 00 20 00 49 B8 FF FF C0 6F F2 86 23 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 CD 66 0F EF C9 48 89 D0 48 C1 E8 20 4C 8D 04 CD 00 00 00 00 F2 48 0F 2A C8 49 C1 E8 36 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 97 FE FF FF 31 C0 EB 95 89 D0 49 89 D1 48 8B 15 ?? ?? ?? ?? 41 F7 D0 49 C1 E9 20 4D 63 D0 4A 8B 0C D2 48 89 CA 89 C9 49 89 C8 48 C1 EA 20 4D 0F AF C1 48 0F AF C8 4C 0F AF CA 45 89 C3 49 C1 E8 20 48 C1 E9 20 48 0F AF D0 4C 01 D9 4D 01 C8 48 8D 04 11 48 8B 15 ?? ?? ?? ?? 48 C1 E8 20 42 8B 0C 92 4C 01 C0 48 D3 E8 E9 30 FF FF FF 48 8B 1D ?? ?? ?? ?? 49 89 D3 41 89 D2 49 C1 EB 20 4D 89 D9 48 8B 03 48 89 C1 89 C0 4C 0F AF C8 48 C1 E9 20 49 0F AF C2 4C 0F AF D9 44 89 CE 49 C1 E9 20 48 C1 E8 20 48 01 F0 48 89 D6 48 0F AF 73 08 49 0F AF CA 49 01 F3 4D 01 D9 E9 B7 FE FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_164_7_0 {
	meta:
		name = "__bid64_to_uint64_xint"
		size = 832
		refs = "0090 .refptr.__bid_nr_digits 00f4 .refptr.__bid_ten2k64 0177 .refptr.__bid_IDEC_glbflags 0206 .refptr.__bid_ten2mk64 0262 .refptr.__bid_maskhigh128 0277 .refptr.__bid_shiftright128 0295 .refptr.__bid_ten2mk128trunc 02e7 .refptr.__bid_ten2k128"
	strings:
		$1 = { 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 59 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 40 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 43 01 00 00 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 0F 84 26 01 00 00 66 0F EF C0 4C 8D 04 09 49 C1 E8 36 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 08 45 85 C9 75 0C 48 3B 50 10 44 8B 48 18 41 83 D9 FF 41 81 E8 8E 01 00 00 43 8D 04 01 83 F8 14 0F 8F B8 00 00 00 49 BA 00 00 00 00 00 00 00 80 4C 21 D1 83 F8 14 74 37 85 C0 0F 8E 1C 01 00 00 48 85 C9 0F 85 95 00 00 00 45 85 C0 0F 88 18 01 00 00 48 89 D0 0F 84 97 00 00 00 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 83 00 00 00 48 85 C9 75 6A 41 83 F9 01 0F 84 D0 01 00 00 B9 15 00 00 00 49 89 D2 89 D0 44 29 C9 4C 8B 0D ?? ?? ?? ?? 49 C1 EA 20 48 63 C9 49 8B 0C C9 49 89 CB 89 C9 49 89 C9 49 C1 EB 20 4D 0F AF CA 48 0F AF C8 4D 0F AF D3 44 89 CB 49 C1 E9 20 48 C1 E9 20 49 0F AF C3 48 01 D9 4D 01 D1 48 01 C8 48 C1 E8 20 4C 01 C8 48 83 F8 09 0F 86 6B FF FF FF 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E C3 0F 1F 44 00 00 48 BA FF FF FF FF FF FF 07 00 49 B8 FF FF C0 6F F2 86 23 00 48 89 D0 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 CA 66 0F EF C9 48 89 D0 48 C1 E8 20 4C 8D 04 CD 00 00 00 00 F2 48 0F 2A C8 49 C1 E8 36 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 94 FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 EB 88 45 89 C1 48 8B 05 ?? ?? ?? ?? 48 89 D1 41 F7 D1 89 D2 48 C1 E9 20 4D 63 C9 41 F7 D8 4A 8B 04 C8 48 89 C3 89 C0 49 89 C2 48 C1 EB 20 48 0F AF C2 4C 0F AF D1 48 0F AF D3 49 89 C3 89 C0 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 DA 4C 01 D1 49 89 D2 48 C1 E2 20 48 01 C2 48 8B 05 ?? ?? ?? ?? 49 C1 EA 20 49 01 CA 4D 89 D3 4A 8B 1C C8 48 8B 05 ?? ?? ?? ?? 42 8B 0C 88 49 D3 EB 41 83 F8 03 7F 2A 4C 89 C9 4C 89 D8 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 E5 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 D6 FE FF FF 49 85 DA 75 1B 4C 89 C9 4C 89 D8 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 48 3B 51 08 0F 86 B6 FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 4C 89 D8 E9 A4 FE FF FF 48 8B 1D ?? ?? ?? ?? 49 89 D3 41 89 D2 49 C1 EB 20 4D 89 D9 48 8B 03 48 89 C1 89 C0 4C 0F AF C8 48 C1 E9 20 49 0F AF C2 4C 0F AF D9 44 89 CE 49 C1 E9 20 48 C1 E8 20 48 01 F0 48 89 D6 48 0F AF 73 08 49 0F AF CA 49 01 F3 4D 01 D9 E9 2B FE FF FF 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_8_0 {
	meta:
		name = "__bid64_to_uint64_rninta"
		size = 848
		refs = "0091 .refptr.__bid_nr_digits 00e0 .refptr.__bid_midpoint64 0103 .refptr.__bid_IDEC_glbflags 01ad .refptr.__bid_ten2k64 0266 .refptr.__bid_ten2mk64 02a8 .refptr.__bid_shiftright128 02c5 .refptr.__bid_ten2k128"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 E4 00 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 CB 00 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 D2 00 00 00 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 0F 84 B1 00 00 00 66 0F EF C0 4C 8D 04 09 49 C1 E8 36 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 08 45 85 C9 75 0C 48 3B 50 10 44 8B 48 18 41 83 D9 FF 41 81 E8 8E 01 00 00 43 8D 04 01 83 F8 14 7F 47 49 BA 00 00 00 00 00 00 00 80 4C 21 D1 83 F8 14 0F 84 B3 00 00 00 85 C0 0F 88 74 01 00 00 0F 85 63 01 00 00 4C 8B 05 ?? ?? ?? ?? 41 83 E9 01 31 C0 4D 63 C9 4B 3B 14 C8 72 21 48 85 C9 B0 01 74 1A 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E 5F C3 0F 1F 84 00 00 00 00 00 48 BA FF FF FF FF FF FF 07 00 49 B8 FF FF C0 6F F2 86 23 00 48 89 D0 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 C6 66 0F EF C9 48 89 D0 48 C1 E8 20 4C 8D 04 CD 00 00 00 00 F2 48 0F 2A C8 49 C1 E8 36 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 05 FF FF FF 48 85 C9 0F 85 75 FF FF FF 41 83 F9 01 0F 84 2D 01 00 00 41 BA 15 00 00 00 89 D0 48 89 D1 45 29 CA 48 C1 E9 20 4D 63 CA 4C 8B 15 ?? ?? ?? ?? 4F 8B 0C CA 4C 89 CB 45 89 C9 4D 89 CA 48 C1 EB 20 4C 0F AF C8 4C 0F AF D1 48 0F AF C3 4D 89 CB 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 D8 4C 01 D1 49 89 C2 49 C1 EA 20 4C 01 D1 48 83 F9 09 0F 87 03 FF FF FF 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 FA 76 0A 48 83 F9 09 0F 84 E9 FE FF FF 45 85 C0 78 36 48 89 D0 0F 84 EF FE FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 DB FE FF FF 0F 1F 80 00 00 00 00 48 85 C9 0F 85 B7 FE FF FF EB CC 31 C0 E9 C2 FE FF FF 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 63 C8 4A 03 14 C8 48 8B 05 ?? ?? ?? ?? 4A 8B 0C C8 49 89 D0 89 D2 49 C1 E8 20 48 89 C8 4D 89 C2 89 C9 4C 0F AF D1 48 C1 E8 20 48 0F AF CA 48 0F AF D0 45 89 D3 49 C1 EA 20 48 C1 E9 20 4C 01 D9 4C 0F AF C0 48 8D 04 11 48 8B 15 ?? ?? ?? ?? 48 C1 E8 20 42 8B 0C 8A 4D 01 D0 4C 01 C0 48 D3 E8 E9 52 FE FF FF 48 8B 1D ?? ?? ?? ?? 48 89 D6 41 89 D1 48 C1 EE 20 49 89 F2 48 8B 03 49 89 C3 89 C0 4C 0F AF D0 49 C1 EB 20 49 0F AF C1 4D 0F AF CB 44 89 D7 49 C1 EA 20 48 89 C1 48 C1 E9 20 48 01 F9 4C 01 C9 49 89 D1 4C 0F AF 4B 08 4C 0F AF DE 4D 01 CB 4F 8D 0C 13 49 89 CA 49 C1 EA 20 4D 01 D1 49 83 F9 09 0F 87 D7 FD FF FF 0F 85 E8 FE FF FF 48 C1 E1 20 89 C0 48 01 C1 48 83 F9 FA 0F 87 BE FD FF FF E9 D0 FE FF FF 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_9_0 {
	meta:
		name = "__bid64_to_uint64_xrninta"
		size = 1056
		refs = "0091 .refptr.__bid_nr_digits 00e4 .refptr.__bid_midpoint64 010a .refptr.__bid_IDEC_glbflags 0119 .refptr.__bid_ten2k128 024d .refptr.__bid_ten2k64 0320 .refptr.__bid_ten2mk64 037a .refptr.__bid_shiftright128 0381 .refptr.__bid_maskhigh128 03b1 .refptr.__bid_ten2mk128trunc 03d0 .refptr.__bid_onehalf128"
	strings:
		$1 = { 57 56 53 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 84 84 01 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 6B 01 00 00 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 21 C2 48 39 C2 0F 84 72 01 00 00 48 BA FF FF FF FF FF FF 1F 00 31 C0 48 21 CA 0F 84 51 01 00 00 66 0F EF C0 4C 8D 04 09 49 C1 E8 36 F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 48 C1 E0 05 48 03 05 ?? ?? ?? ?? 44 8B 08 45 85 C9 75 0C 48 3B 50 10 44 8B 48 18 41 83 D9 FF 41 81 E8 8E 01 00 00 43 8D 04 01 83 F8 14 0F 8F E3 00 00 00 49 BA 00 00 00 00 00 00 00 80 4C 21 D1 83 F8 14 0F 84 4F 01 00 00 85 C0 0F 88 17 02 00 00 0F 85 FF 01 00 00 48 8B 05 ?? ?? ?? ?? 41 83 E9 01 4D 63 C9 4A 3B 14 C8 0F 82 F2 01 00 00 48 85 C9 B8 01 00 00 00 0F 85 99 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 9E 00 00 00 48 8B 1D ?? ?? ?? ?? 48 89 D6 41 89 D1 48 C1 EE 20 49 89 F2 48 8B 03 49 89 C3 89 C0 4C 0F AF D0 49 C1 EB 20 49 0F AF C1 4D 0F AF CB 44 89 D7 49 C1 EA 20 48 89 C1 48 C1 E9 20 48 01 F9 4C 01 C9 49 89 D1 4C 0F AF 4B 08 4C 0F AF DE 4D 01 CB 4D 89 D1 49 89 CA 4D 01 D9 49 C1 EA 20 4D 01 D1 49 83 F9 09 77 25 48 C1 E1 20 89 C0 48 01 C1 48 83 F9 FA 0F 86 29 01 00 00 49 83 F9 09 0F 85 1F 01 00 00 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 00 00 00 00 00 00 00 80 5B 5E 5F C3 0F 1F 84 00 00 00 00 00 48 BA FF FF FF FF FF FF 07 00 49 B8 FF FF C0 6F F2 86 23 00 48 89 D0 48 BA 00 00 00 00 00 00 20 00 48 21 C8 48 09 C2 31 C0 4C 39 C2 77 C6 66 0F EF C9 48 89 D0 48 C1 E8 20 4C 8D 04 CD 00 00 00 00 F2 48 0F 2A C8 49 C1 E8 36 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 E9 65 FE FF FF 48 85 C9 0F 85 75 FF FF FF 41 83 F9 01 0F 84 E1 FE FF FF 41 BA 15 00 00 00 89 D0 48 89 D1 45 29 CA 48 C1 E9 20 4D 63 CA 4C 8B 15 ?? ?? ?? ?? 4F 8B 0C CA 4C 89 CB 45 89 C9 4D 89 CA 48 C1 EB 20 4C 0F AF C8 4C 0F AF D1 48 0F AF C3 4D 89 CB 44 89 D6 49 C1 EB 20 49 C1 EA 20 48 0F AF CB 49 01 F3 4C 01 D8 4C 01 D1 49 89 C2 49 C1 EA 20 4C 01 D1 48 83 F9 09 0F 87 03 FF FF FF 48 C1 E0 20 45 89 C9 4C 01 C8 48 83 F8 FA 76 0A 48 83 F9 09 0F 84 E9 FE FF FF 45 85 C0 78 47 48 89 D0 0F 84 EF FE FF FF 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4A 0F AF 04 C2 E9 DB FE FF FF 0F 1F 80 00 00 00 00 48 85 C9 0F 85 B7 FE FF FF EB CC 31 C0 E9 15 FE FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 B1 FE FF FF 44 89 C0 48 8B 0D ?? ?? ?? ?? 41 F7 D8 F7 D0 48 98 48 03 14 C1 89 D1 49 89 D2 48 8B 15 ?? ?? ?? ?? 49 C1 EA 20 4D 89 D3 48 8B 14 C2 49 89 D1 89 D2 4C 0F AF DA 49 C1 E9 20 48 0F AF D1 4D 0F AF D1 44 89 DE 49 C1 EB 20 48 89 D3 89 D2 4C 0F AF C9 48 C1 EB 20 48 01 F3 4A 8D 0C 0B 4D 89 D9 4D 01 D1 49 89 CA 48 C1 E1 20 49 C1 EA 20 4D 01 CA 4C 8D 0C 11 48 8B 0D ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 4C 89 D7 8B 0C 81 48 8B 14 C2 48 D3 EF 41 83 F8 03 48 89 F9 7F 32 48 BA 00 00 00 00 00 00 00 80 49 39 D1 76 55 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 01 CA 49 89 C0 48 89 F8 49 3B 50 08 0F 86 EC FD FF FF E9 3A FD FF FF 4C 8B 05 ?? ?? ?? ?? 4C 21 D2 49 3B 14 C0 77 22 75 20 4D 85 C9 74 1B 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 89 C2 48 89 F8 4C 3B 4A 08 0F 86 B5 FD FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 48 89 C8 E9 A3 FD FF FF 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__bid_gesd2"
		size = 64
		refs = "0009 __bid32_to_bid64 001e __bid64_quiet_greater_equal"
	strings:
		$1 = { 56 53 48 83 EC 28 89 D6 E8 ?? ?? ?? ?? 89 F1 48 89 C3 E8 ?? ?? ?? ?? 48 89 D9 48 89 C2 E8 ?? ?? ?? ?? 48 98 48 C7 C2 FF FF FF FF 48 85 C0 48 0F 44 C2 48 83 C4 28 5B 5E C3 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__subvti3"
		size = 96
		refs = "0031 abort"
	strings:
		$1 = { 53 48 83 EC 30 4C 8B 09 4C 8B 51 08 48 8B 0A 48 8B 5A 08 4C 89 C8 4C 89 D2 48 29 C8 48 19 DA 48 85 DB 78 11 4C 39 D2 7F 07 7C 16 4C 39 C8 76 11 E8 ?? ?? ?? ?? 4C 39 D2 7C F6 7F 05 4C 39 C8 72 EF 48 89 44 24 20 48 89 54 24 28 66 0F 6F 44 24 20 48 83 C4 30 5B C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__divti3"
		size = 432
	strings:
		$1 = { 57 56 53 48 83 EC 10 4C 8B 19 48 8B 49 08 48 8B 42 08 4C 8B 02 4D 89 D9 45 31 DB 48 85 C9 48 89 C2 49 89 CA 0F 88 E8 00 00 00 48 85 D2 4C 89 C1 48 89 C3 0F 88 C7 00 00 00 48 85 DB 4D 89 D0 4C 89 CE 48 89 CF 49 89 DA 75 16 4C 39 C1 0F 86 82 00 00 00 4C 89 C8 4C 89 C2 48 F7 F1 31 D2 EB 09 4C 39 C3 76 4B 31 D2 31 C0 4D 85 DB 0F 95 C1 31 DB 0F B6 C9 48 89 DF 48 89 CE 48 F7 DE 48 83 D7 00 48 31 F0 48 F7 DF 49 89 C1 48 89 F8 48 31 D0 49 01 C9 49 89 C2 4C 89 0C 24 49 11 DA 4C 89 54 24 08 66 0F 6F 04 24 90 48 83 C4 10 5B 5E 5F C3 48 0F BD C3 48 83 F0 3F 85 C0 89 C3 75 72 4C 39 C9 76 09 31 D2 31 C0 4D 39 C2 73 9D 31 D2 B8 01 00 00 00 EB 94 48 85 C9 75 0D B8 01 00 00 00 31 D2 48 F7 F1 48 89 C1 4C 89 C0 31 D2 48 F7 F1 49 89 C0 4C 89 C8 48 F7 F1 4C 89 C2 E9 69 FF FF FF 48 F7 D9 49 F7 D3 48 83 D3 00 48 F7 DB E9 27 FF FF FF 49 F7 D9 49 C7 C3 FF FF FF FF 49 83 D2 00 49 F7 DA E9 02 FF FF FF 0F 1F 84 00 00 00 00 00 89 C1 BA 40 00 00 00 49 89 F9 49 D3 E2 48 63 C8 48 29 CA 89 D1 49 D3 E9 89 C1 4D 09 CA 48 D3 E7 4D 89 C1 89 D1 49 D3 E9 89 C1 48 89 F0 49 D3 E0 89 D1 4C 89 CA 48 D3 E8 49 09 C0 4C 89 C0 49 F7 F2 49 89 D1 49 89 C0 48 F7 E7 49 39 D1 72 21 89 D9 48 D3 E6 48 39 C6 73 05 49 39 D1 74 12 4C 89 C0 31 D2 E9 D1 FE FF FF 0F 1F 84 00 00 00 00 00 49 8D 40 FF 31 D2 E9 BE FE FF FF 90 90 90 90 90 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__bid_addtd3"
		size = 96
		refs = "003a __bid128_add"
	strings:
		$1 = { 53 48 83 EC 50 4C 8B 0A 4C 8B 52 08 49 8B 50 08 49 8B 00 48 89 CB 4C 8D 44 24 20 48 8D 4C 24 40 4C 89 4C 24 30 4C 89 54 24 38 48 89 54 24 28 48 8D 54 24 30 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 54 24 48 48 89 03 48 89 D8 48 89 53 08 48 83 C4 50 5B C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__bid32_to_binary32"
		size = 1568
		refs = "0105 .refptr.__bid_IDEC_glbflags 010f .refptr.__bid_IDEC_glbround 0170 .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 38 89 CA 89 C8 81 E2 00 00 00 60 C1 E8 1F 81 FA 00 00 00 60 89 CA 0F 84 95 03 00 00 81 E2 FF FF 7F 00 0F 84 1A 01 00 00 41 89 C8 44 0F B7 C9 89 D2 41 81 E0 00 00 7F 00 45 39 C1 41 89 C9 41 89 C8 45 19 D2 41 81 E1 FF 00 7F 00 41 81 E0 00 FF 00 00 41 F7 D2 41 83 E2 10 45 39 C1 41 89 C9 45 19 C0 41 81 E1 0F 0F 0F 00 41 F7 D0 41 83 E0 08 45 01 C2 41 89 C8 41 81 E0 F0 F0 70 00 45 39 C1 41 89 C9 45 19 C0 41 81 E1 33 33 33 00 41 F7 D0 41 83 E0 04 45 01 C2 41 89 C8 41 81 E0 CC CC 4C 00 45 39 C1 41 89 C8 45 19 C9 41 C1 E8 17 41 F7 D1 45 0F B6 C0 41 83 E1 02 41 83 E8 65 45 01 CA 41 89 C9 81 E1 AA AA 2A 00 41 81 E1 55 55 55 00 41 39 C9 41 0F 93 C1 45 0F B6 C9 45 01 D1 41 8D 49 F8 48 D3 E2 41 8D 49 51 48 C1 E2 19 41 83 F8 26 7E 5E 48 8B 15 ?? ?? ?? ?? 83 0A 28 48 8B 15 ?? ?? ?? ?? 8B 0A 83 F9 03 0F 84 82 02 00 00 83 F8 01 19 D2 83 C2 02 39 CA 0F 84 72 02 00 00 C1 E0 1F 05 00 00 80 7F 89 44 24 08 F3 0F 10 44 24 08 48 83 C4 38 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 C1 E0 1F 89 44 24 08 F3 0F 10 44 24 08 EB E0 41 83 F8 B1 0F 8C 99 02 00 00 4D 63 C0 4C 8D 0D ?? ?? ?? ?? 49 83 C0 50 4D 89 C2 49 C1 E2 04 4D 01 D1 4C 8D 15 ?? ?? ?? ?? 4F 8D 14 82 49 C1 E0 05 41 8B 32 29 CE 49 39 51 08 0F 83 F3 02 00 00 48 8D 0D ?? ?? ?? ?? 83 C6 01 4C 01 C1 4C 8B 09 4C 8B 59 08 4C 8B 41 10 48 8B 49 18 4C 89 CB 49 89 D2 45 89 C9 49 C1 EA 20 89 D2 4C 89 CF 49 0F AF FA 4C 89 DD 45 89 DB 4C 0F AF CA 48 C1 ED 20 4D 89 DD 4C 0F AF DA 48 C1 EB 20 4D 89 C6 45 89 C0 49 89 DF 49 C1 EE 20 41 89 FC 4C 89 7C 24 08 48 89 CB 49 C1 E9 20 89 C9 48 C1 EB 20 4D 01 E1 4C 89 4C 24 20 49 89 E9 4D 0F AF CA 4D 0F AF EA 48 0F AF EA 4C 89 4C 24 18 4D 89 D9 45 89 DB 45 89 EC 49 C1 E9 20 4D 01 E1 4D 89 F4 49 01 E9 4C 89 CD 48 C1 E5 20 49 01 EB 4C 89 C5 4C 0F AF C2 4C 89 5C 24 28 4D 0F AF FA 49 0F AF EA 4D 89 C3 45 89 C0 4C 89 7C 24 10 49 C1 EB 20 4C 0F AF F2 41 89 EF 48 C1 ED 20 4D 0F AF E2 4D 01 FB 4D 01 F3 49 01 EC 4C 89 DD 48 C1 ED 20 49 01 EC 48 89 CD 48 0F AF CA 49 0F AF EA 4C 0F AF D3 49 89 CE 89 C9 49 C1 EE 20 41 89 EF 48 C1 ED 20 48 0F AF DA 4D 01 FE 49 01 EA 48 C1 EF 20 49 01 DE 4C 89 F5 49 C1 E6 20 49 01 CE 48 8B 4C 24 10 48 C1 ED 20 49 01 EA 48 01 F9 48 8B 7C 24 08 48 0F AF FA 31 D2 48 03 7C 24 20 48 C1 EF 20 48 01 CF 48 8B 4C 24 28 48 01 F9 0F 92 C2 49 C1 ED 20 4C 03 6C 24 18 49 C1 E3 20 49 C1 E9 20 4D 01 D8 49 01 D0 4D 01 E9 4D 01 C1 0F 82 14 01 00 00 4C 39 C2 0F 87 0B 01 00 00 31 D2 4D 01 E6 0F 92 C2 49 01 D2 85 F6 0F 8E 0F 01 00 00 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 4D 89 D0 41 83 E0 01 8B 0A 8D 14 8D 00 00 00 00 8D 14 42 4C 01 C2 4C 8D 05 ?? ?? ?? ?? 48 C1 E2 04 4C 01 C2 4C 3B 72 08 0F 87 4B 01 00 00 0F 84 36 01 00 00 81 FE FE 00 00 00 0F 8E BB 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 83 F9 03 0F 85 84 FD FF FF 66 0F 1F 44 00 00 C1 E0 1F 05 FF FF 7F 7F 89 44 24 08 F3 0F 10 44 24 08 E9 89 FD FF FF 66 0F 1F 84 00 00 00 00 00 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 84 A2 01 00 00 41 89 C8 81 E1 FF FF 1F 00 41 C1 E8 15 48 8D 91 00 00 80 00 45 0F B6 C0 41 83 E8 65 48 81 FA 7F 96 98 00 76 29 B9 59 00 00 00 31 D2 E9 F9 FC FF FF 45 31 C0 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? E9 78 FD FF FF 0F 1F 80 00 00 00 00 48 C1 E2 19 B9 59 00 00 00 E9 CE FC FF FF 66 90 49 83 C6 01 31 D2 4D 01 E6 0F 92 C2 49 01 D2 85 F6 0F 8F F9 FE FF FF BA 01 00 00 00 B9 1A 00 00 00 41 B8 40 00 00 00 29 F2 4C 89 F6 4D 89 D4 83 FA 1A 0F 4F D1 41 29 D0 89 D1 49 D3 E9 44 89 C1 48 D3 E6 89 D1 49 D3 EE 44 89 C1 49 01 F1 49 D3 E4 89 D1 BE 01 00 00 00 4D 01 E6 49 D3 EA E9 AD FE FF FF 48 8D 0D ?? ?? ?? ?? 4C 01 C1 4C 8B 09 4C 8B 59 08 4C 8B 41 10 48 8B 49 18 E9 0B FD FF FF 4C 3B 0A 0F 86 C1 FE FF FF 66 0F 1F 44 00 00 49 83 C2 01 49 81 FA 00 00 00 01 0F 84 EF 00 00 00 49 81 FA 00 00 80 00 0F 85 9D FE FF FF 83 FE 01 0F 85 94 FE FF FF 48 BA FF FF FF FF FF FF FF BF 49 39 D6 0F 87 F6 00 00 00 F6 C1 03 0F 85 ED 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 10 45 31 D2 BE 01 00 00 00 4D 85 F6 0F 84 C2 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 20 C1 E6 17 44 01 D6 C1 E0 1F 01 F0 89 44 24 08 F3 0F 10 44 24 08 E9 FE FB FF FF 49 81 FA FF FF 7F 00 0F 87 BA 00 00 00 4D 85 F6 75 05 4D 85 C9 74 17 48 8B 0D ?? ?? ?? ?? 8B 11 83 CA 30 89 11 66 0F 1F 84 00 00 00 00 00 31 F6 EB B7 89 CA 81 E2 00 00 00 7C 81 FA 00 00 00 7C 0F 85 A6 FB FF FF F7 C1 00 00 00 02 74 0A 48 8B 15 ?? ?? ?? ?? 83 0A 01 48 C1 E1 2C C1 E0 1F 48 C1 E9 2A 8D 84 08 00 00 C0 7F 89 44 24 08 F3 0F 10 44 24 08 E9 85 FB FF FF 0F 1F 44 00 00 83 C6 01 45 31 D2 81 FE FE 00 00 00 0F 8F B5 FD FF FF E9 3E FF FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 C9 0F 85 35 FF FF FF E9 3A FF FF FF 66 90 01 C1 83 F9 02 0F 85 12 FF FF FF 4D 85 F6 0F 89 FF FE FF FF E9 04 FF FF FF 41 81 E2 FF FF 7F 00 E9 00 FF FF FF 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_1_0 {
	meta:
		name = "__bid64_to_binary32"
		size = 2192
		refs = "0158 .refptr.__bid_IDEC_glbflags 0162 .refptr.__bid_IDEC_glbround 01c2 .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 58 48 B8 00 00 00 00 00 00 00 60 48 89 CA 48 89 CB 48 21 C2 48 C1 EB 3F 48 39 C2 0F 84 00 02 00 00 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 48 89 C2 0F 84 5F 01 00 00 48 B8 00 00 00 00 FF FF 1F 00 41 89 C8 49 B9 FF FF 00 00 FF FF 00 00 48 21 C8 49 BA AA AA AA AA AA AA 0A 00 49 39 C0 48 B8 00 00 FF FF 00 00 1F 00 45 19 C0 48 21 C8 49 21 C9 41 F7 D0 41 83 E0 20 49 39 C1 49 B9 FF 00 FF 00 FF 00 1F 00 19 C0 49 21 C9 F7 D0 83 E0 10 41 01 C0 48 B8 00 FF 00 FF 00 FF 00 00 48 21 C8 49 39 C1 49 B9 0F 0F 0F 0F 0F 0F 0F 00 19 C0 49 21 C9 F7 D0 83 E0 08 41 01 C0 48 B8 F0 F0 F0 F0 F0 F0 10 00 48 21 C8 49 39 C1 19 C0 F7 D0 83 E0 04 45 8D 0C 00 48 B8 CC CC CC CC CC CC 0C 00 49 B8 33 33 33 33 33 33 13 00 48 21 C8 49 21 C8 49 39 C0 48 89 C8 45 19 C0 48 C1 E8 35 49 21 CA 41 F7 D0 25 FF 03 00 00 41 83 E0 02 2D 8E 01 00 00 45 01 C8 49 B9 55 55 55 55 55 55 15 00 4C 21 C9 49 39 CA 0F 96 C1 0F B6 C9 41 01 C8 41 8D 48 F6 41 83 C0 31 48 D3 E2 48 89 D1 48 C1 EA 05 48 C1 E1 3B 83 F8 26 7E 5F 48 8B 05 ?? ?? ?? ?? 83 08 28 48 8B 05 ?? ?? ?? ?? 8B 10 83 FA 03 0F 84 5F 04 00 00 83 FB 01 19 C0 83 C0 02 39 D0 0F 84 4F 04 00 00 C1 E3 1F 81 C3 00 00 80 7F 89 5C 24 04 F3 0F 10 44 24 04 48 83 C4 58 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 C1 E3 1F 89 5C 24 04 F3 0F 10 44 24 04 EB E0 83 F8 B1 0F 8C 33 04 00 00 48 98 4C 8D 0D ?? ?? ?? ?? 48 83 C0 50 49 89 C2 49 C1 E2 04 4D 01 D1 4C 8D 15 ?? ?? ?? ?? 4D 8D 14 82 48 C1 E0 05 45 8B 12 4D 8B 19 45 29 C2 49 39 51 08 44 89 54 24 04 77 19 0F 85 A3 00 00 00 49 39 CB 0F 82 9A 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 4C 8D 05 ?? ?? ?? ?? 4C 01 C0 4C 8B 00 4C 8B 48 08 4C 8B 50 10 4C 8B 68 18 E9 90 00 00 00 66 90 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 6C 05 00 00 48 89 C8 48 BA FF FF FF FF FF FF 07 00 48 21 D1 48 C1 E8 33 48 BA 00 00 00 00 00 00 20 00 25 FF 03 00 00 48 01 D1 48 BA FF FF C0 6F F2 86 23 00 2D 8E 01 00 00 48 39 D1 0F 86 7E 03 00 00 41 B8 3B 00 00 00 31 C9 31 D2 E9 BA FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 4C 8D 05 ?? ?? ?? ?? 83 44 24 04 01 4C 01 C0 4C 8B 00 4C 8B 48 08 4C 8B 50 10 4C 8B 68 18 4D 89 CE 45 89 C9 48 C1 E9 20 4D 89 CC 49 C1 EE 20 4C 89 C0 4C 0F AF E1 4C 89 F6 48 C1 E8 20 48 0F AF F1 45 89 C0 49 89 C7 4C 0F AF F9 4C 89 E7 48 C1 E7 20 48 89 74 24 18 48 89 7C 24 20 4C 89 D7 48 C1 EF 20 48 89 FD 48 89 7C 24 28 44 89 D7 49 89 FB 49 89 EA 4C 0F AF D9 4C 0F AF D1 4C 89 DD 48 C1 ED 20 4A 8D 74 15 00 4D 89 EA 45 89 ED 49 C1 EA 20 4C 89 D5 4C 89 54 24 08 4D 89 EA 4C 0F AF D1 48 89 74 24 10 48 0F AF E9 49 0F AF C8 4C 89 D6 49 C1 E2 20 48 C1 EE 20 48 C1 E9 20 48 01 F5 4C 01 F9 48 03 4C 24 20 48 89 4C 24 20 0F 92 C1 49 C1 EC 20 4C 03 64 24 18 49 C1 E3 20 0F B6 C9 49 01 CB 4D 01 DC 4C 89 64 24 30 0F 82 8F 02 00 00 4C 39 D9 0F 87 86 02 00 00 4C 03 54 24 10 4D 89 C3 41 0F 92 C7 4C 89 54 24 10 49 89 D2 45 0F B6 FF 89 D2 49 C1 EA 20 4A 8D 74 3D 00 49 89 FF 4C 0F AF C2 48 89 74 24 18 48 89 C6 4D 0F AF DA 49 0F AF F2 4C 89 C1 45 89 C0 48 C1 E9 20 48 0F AF C2 48 89 74 24 38 44 89 DE 48 01 F1 4C 89 CE 48 01 C8 48 89 C1 48 C1 E1 20 4C 01 C1 48 89 4C 24 40 4C 89 F1 49 0F AF CA 4C 0F AF CA 49 0F AF F2 48 89 4C 24 48 4C 89 C9 45 89 C9 4C 0F AF F2 41 89 F0 48 C1 E9 20 4D 0F AF FA 4C 01 C1 48 0F AF FA 4C 01 F1 49 89 C8 49 C1 E0 20 4F 8D 34 08 4D 89 F9 4C 8B 7C 24 28 45 89 CC 49 89 F8 48 C1 EF 20 4C 01 E7 49 C1 E9 20 45 89 C0 4C 89 FD 4D 89 FC 49 0F AF EA 4C 0F AF E2 4C 01 CD 4D 89 E9 4C 0F AF EA 4C 01 E7 4D 0F AF CA 49 89 FF 49 C1 EF 20 49 01 EF 4C 89 ED 45 89 ED 45 89 CC 48 C1 ED 20 4C 0F AF 54 24 08 4C 01 E5 49 C1 EB 20 4C 03 5C 24 38 48 0F AF 54 24 08 49 C1 E9 20 48 C1 E8 20 49 01 C3 31 C0 4D 01 CA 48 01 EA 49 89 D1 48 C1 E2 20 49 C1 E9 20 4C 01 EA 4D 01 CA 4D 01 DE 0F 92 C0 48 C1 EE 20 48 03 74 24 48 48 C1 E7 20 48 C1 E9 20 4C 01 C7 48 01 C7 48 01 CE 48 01 FE 0F 82 69 01 00 00 48 39 F8 0F 87 60 01 00 00 31 FF 49 01 D7 40 0F 92 C7 48 8B 44 24 40 4C 01 D7 48 03 44 24 20 48 8B 54 24 30 0F 92 C0 0F B6 C0 49 01 C6 4C 01 F2 0F 82 03 01 00 00 4C 39 F0 0F 87 FA 00 00 00 4C 8B 54 24 10 31 C0 49 01 F2 0F 92 C0 4C 8B 6C 24 18 49 01 C7 4D 01 FD 41 0F 92 C0 49 39 C7 0F 92 C0 41 09 C0 45 0F B6 C0 8B 44 24 04 4E 8D 0C 07 85 C0 0F 8E F1 01 00 00 48 8B 05 ?? ?? ?? ?? 4C 89 C9 83 E1 01 8B 10 8D 04 95 00 00 00 00 8D 04 58 48 01 C8 48 8D 0D ?? ?? ?? ?? 48 C1 E0 04 48 01 C8 4C 3B 68 08 0F 87 ED 00 00 00 0F 84 D7 00 00 00 81 7C 24 04 FE 00 00 00 0F 8E 79 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 83 FA 03 0F 85 A7 FB FF FF 66 0F 1F 44 00 00 C1 E3 1F 81 C3 FF FF 7F 7F 89 5C 24 04 F3 0F 10 44 24 04 E9 AC FB FF FF 0F 1F 84 00 00 00 00 00 31 C0 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? E9 DE FB FF FF 48 89 CA 41 B8 3B 00 00 00 48 C1 E1 3B 48 C1 EA 05 E9 35 FB FF FF 0F 1F 44 00 00 49 83 C2 01 E9 71 FD FF FF 0F 1F 80 00 00 00 00 4C 8B 54 24 10 48 83 C6 01 49 01 F2 0F 82 DE 00 00 00 48 85 F6 0F 84 D5 00 00 00 4C 8B 6C 24 18 45 31 C0 4D 01 FD 41 0F 92 C0 E9 00 FF FF FF 90 48 83 C2 01 49 01 D7 40 0F 92 C7 48 85 D2 0F 94 C0 09 C7 40 0F B6 FF E9 8D FE FF FF 0F 1F 40 00 4C 3B 10 0F 86 20 FF FF FF 0F 1F 80 00 00 00 00 49 83 C1 01 49 81 F9 00 00 00 01 0F 84 8F 01 00 00 49 81 F9 00 00 80 00 0F 85 FB FE FF FF 83 7C 24 04 01 0F 85 F0 FE FF FF 48 B8 FF FF FF FF FF FF FF BF 49 39 C5 89 D8 0F 87 82 01 00 00 F6 C2 03 0F 85 79 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 10 45 31 C9 C7 44 24 04 01 00 00 00 4D 85 ED 75 05 4D 85 D2 74 0A 48 8B 15 ?? ?? ?? ?? 83 0A 20 8B 54 24 04 C1 E2 17 44 01 CA C1 E0 1F 01 D0 89 44 24 04 F3 0F 10 44 24 04 E9 76 FA FF FF 66 90 B8 01 00 00 00 E9 19 FE FF FF 66 0F 1F 44 00 00 49 81 F9 FF FF 7F 00 0F 87 3C 01 00 00 4D 85 ED 75 09 4D 85 D2 0F 84 25 01 00 00 48 8B 0D ?? ?? ?? ?? 89 D8 8B 11 83 CA 30 89 11 31 D2 EB A8 90 B8 01 00 00 00 2B 44 24 04 BA 1A 00 00 00 41 B8 40 00 00 00 4C 89 D6 4D 89 CF C7 44 24 04 01 00 00 00 83 F8 1A 0F 4F C2 4C 89 EA 41 29 C0 89 C1 48 D3 EE 44 89 C1 48 D3 E2 89 C1 49 D3 ED 44 89 C1 4C 8D 14 16 49 D3 E7 89 C1 4D 01 FD 49 D3 E9 E9 BA FD FF FF 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 85 B3 F9 FF FF 48 B8 00 00 00 00 00 00 00 02 48 85 C1 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 48 BA FF FF FF FF FF FF 03 00 49 B8 FF 7F C6 A4 7E 8D 03 00 C1 E3 1F 48 21 CA B8 00 00 40 00 4C 39 C2 77 0E 48 C1 E1 0E 48 C1 E9 2A 8D 81 00 00 40 00 8D 84 18 00 00 80 7F 89 44 24 04 F3 0F 10 44 24 04 E9 65 F9 FF FF 90 83 44 24 04 01 8B 44 24 04 3D FE 00 00 00 0F 8F 73 FD FF FF 89 D8 45 31 C9 E9 9E FE FF FF 66 90 01 D3 83 FB 02 0F 85 86 FE FF FF 4D 85 ED 0F 89 73 FE FF FF E9 78 FE FF FF 0F 1F 80 00 00 00 00 89 D8 31 D2 E9 8E FE FF FF 41 81 E1 FF FF 7F 00 89 D8 E9 65 FE FF FF 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_2_0 {
	meta:
		name = "__bid128_to_binary32"
		size = 2816
		refs = "017b .refptr.__bid_IDEC_glbflags 0185 .refptr.__bid_IDEC_glbround 02c1 .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 4C 8B 09 48 8B 49 08 48 89 C8 49 89 C8 4C 89 CA 48 C1 E8 3F 48 89 04 24 48 B8 00 00 00 00 00 00 00 60 49 21 C0 49 39 C0 0F 84 82 01 00 00 49 89 C8 48 B8 FF FF FF FF FF FF 01 00 49 BA C0 87 AD BE 09 ED 01 00 49 C1 E8 31 48 21 C8 41 81 E0 FF 3F 00 00 41 81 E8 20 18 00 00 4C 39 D0 0F 87 62 01 00 00 0F 84 27 08 00 00 48 85 C0 0F 84 76 09 00 00 49 BA 00 00 00 00 FF FF 01 00 41 89 CB 49 BC 00 00 FF FF 00 00 01 00 49 21 CA 49 BD FF FF 00 00 FF FF 00 00 48 BF 00 FF 00 FF 00 FF 00 00 48 BD FF 00 FF 00 FF 00 01 00 48 BB F0 F0 F0 F0 F0 F0 00 00 48 BE 0F 0F 0F 0F 0F 0F 01 00 49 21 CC 49 21 CD 48 21 CF 48 21 CD 48 21 CB 48 21 CE 4D 39 DA 49 BA CC CC CC CC CC CC 00 00 0F 86 01 01 00 00 49 BE 55 55 55 55 55 55 01 00 49 BB 33 33 33 33 33 33 01 00 49 BF AA AA AA AA AA AA 00 00 49 21 CA 49 21 CB 49 21 CF 4C 21 F1 45 31 F6 49 39 CF 41 0F 96 C6 31 C9 4D 39 E5 45 19 E4 41 F7 D4 41 83 E4 10 41 01 CC 48 39 FD 19 C9 F7 D1 83 E1 08 48 39 DE 41 8D 3C 0C 19 C9 F7 D1 83 E1 04 4D 39 D3 8D 1C 0F 19 C9 F7 D1 83 E1 02 01 D9 45 8D 54 0E F1 45 85 D2 0F 85 E2 06 00 00 41 83 F8 26 0F 8E 39 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 48 8B 05 ?? ?? ?? ?? 8B 10 83 FA 03 0F 84 91 05 00 00 83 3C 24 01 19 C0 83 C0 02 39 D0 0F 84 80 05 00 00 8B 04 24 C1 E0 1F 05 00 00 80 7F 89 04 24 F3 0F 10 04 24 EB 29 66 0F 1F 44 00 00 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 74 5D 8B 04 24 C1 E0 1F 89 04 24 F3 0F 10 04 24 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 49 BE 55 55 55 55 55 55 01 00 49 BB 33 33 33 33 33 33 01 00 49 BF AA AA AA AA AA AA 00 00 49 21 CA 49 21 CB 49 21 CF 4C 21 F1 45 31 F6 49 39 CF B9 20 00 00 00 41 0F 96 C6 E9 F7 FE FF FF 48 B8 00 00 00 00 00 00 00 7C 48 89 CA 48 21 C2 48 39 C2 0F 85 5A FF FF FF 48 B8 00 00 00 00 00 00 00 02 48 85 C1 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 48 B8 FF FF FF FF FF 3F 00 00 48 BA 93 8D 44 C6 4D 31 00 00 48 21 C8 48 39 D0 77 19 0F 85 38 07 00 00 48 B8 FF FF FF FF 09 5B C1 38 49 39 C1 0F 86 25 07 00 00 8B 04 24 C1 E0 1F 05 00 00 C0 7F 89 04 24 F3 0F 10 04 24 E9 32 FF FF FF 41 83 F8 B1 0F 8C C5 05 00 00 4D 63 C0 48 8D 0D ?? ?? ?? ?? 49 83 C0 50 4D 89 C1 49 C1 E1 04 4C 01 C9 4C 8D 0D ?? ?? ?? ?? 4F 8D 0C 81 49 C1 E0 05 45 8B 09 4C 8B 19 45 29 D1 48 39 41 08 44 89 4C 24 0C 77 0A 75 28 49 39 D3 72 23 0F 1F 00 48 8D 0D ?? ?? ?? ?? 49 01 C8 4D 8B 10 4D 8B 78 08 4D 8B 48 10 49 8B 48 18 EB 23 0F 1F 44 00 00 48 8D 0D ?? ?? ?? ?? 83 44 24 0C 01 49 01 C8 4D 8B 10 4D 8B 78 08 4D 8B 48 10 49 8B 48 18 4D 89 D0 48 89 D3 45 89 D2 49 C1 E8 20 48 C1 EB 20 89 D2 4C 89 D5 4C 89 C6 4D 89 D3 48 0F AF EB 48 0F AF F3 4C 0F AF DA 48 89 74 24 28 89 EE 49 C1 EB 20 4A 8D 3C 1E 4C 89 FE 45 89 FF 48 C1 EE 20 4D 89 FB 48 89 7C 24 40 4C 89 FF 49 89 F6 48 0F AF FB 48 89 74 24 30 4C 0F AF DA 49 89 FD 48 89 F7 48 0F AF FB 4C 89 6C 24 18 4D 89 DC 49 C1 EC 20 45 89 DB 4C 89 E6 48 89 7C 24 38 8B 7C 24 18 48 01 FE 4C 89 F7 48 0F AF FA 4C 8D 34 3E 4D 89 F4 4C 89 74 24 48 4D 89 CE 49 C1 E4 20 45 89 C9 49 C1 EE 20 4D 01 E3 4C 89 CF 4D 89 F4 4C 89 5C 24 50 4D 89 CB 4C 89 74 24 58 4C 0F AF DB 48 0F AF FA 4C 0F AF E3 45 89 DD 49 C1 EB 20 48 89 FE 48 C1 EF 20 4C 01 EF 4D 89 F5 4D 01 DC 4C 0F AF EA 49 89 CE 89 C9 49 C1 EE 20 89 F6 4C 89 74 24 10 4C 01 EF 49 89 FB 49 C1 EB 20 4F 8D 2C 1C 49 89 CB 4C 0F AF DA 4C 89 6C 24 20 49 89 CD 4C 0F AF EB 4D 89 DC 45 89 DB 49 C1 EC 20 49 0F AF DE 45 89 EE 4D 01 E6 4C 8B 64 24 10 4C 0F AF E2 4D 01 F4 48 C1 ED 20 48 03 6C 24 28 49 0F AF D0 49 C1 ED 20 48 03 54 24 40 4C 01 EB 4D 89 E5 49 C1 ED 20 49 C1 E4 20 49 01 DD 4D 01 DC 4C 8B 5C 24 18 48 8B 5C 24 48 48 C1 EA 20 48 01 D5 48 03 6C 24 50 0F 92 C2 49 C1 EB 20 4C 03 5C 24 38 48 C1 E7 20 48 C1 EB 20 0F B6 D2 48 01 F7 48 89 6C 24 28 48 01 D7 49 01 DB 49 01 FB 4C 89 5C 24 38 0F 82 AC 02 00 00 48 39 FA 0F 87 A3 02 00 00 4C 8B 74 24 20 31 D2 4D 01 E6 0F 92 C2 66 0F 1F 44 00 00 49 8D 74 15 00 49 89 C3 89 C0 49 C1 EB 20 4C 89 C3 48 8B 6C 24 30 48 89 74 24 18 4C 89 D6 4C 8B 6C 24 58 4C 0F AF D0 49 0F AF F3 49 0F AF DB 4C 89 D2 45 89 D2 48 C1 EA 20 4C 0F AF C0 48 89 5C 24 20 89 F3 48 01 DA 49 01 D0 4C 89 C2 48 C1 E2 20 4A 8D 3C 12 4D 89 FA 4C 0F AF F8 4D 0F AF D3 48 89 7C 24 40 48 89 EF 49 0F AF FB 4C 89 FA 45 89 FF 44 89 D3 48 C1 EA 20 48 01 DA 48 89 EB 48 89 7C 24 30 48 0F AF D8 4C 89 ED 49 0F AF EB 48 01 DA 48 89 D3 48 C1 E3 20 49 01 DF 4C 89 CB 4C 0F AF C8 49 0F AF DB 4C 89 CF 45 89 C9 41 89 DC 48 C1 EF 20 48 C1 EB 20 4C 01 E7 4D 89 EC 48 01 DD 4C 0F AF E0 4C 01 E7 48 89 FB 48 C1 EB 20 48 01 EB 48 89 CD 48 0F AF C8 49 0F AF EB 4C 0F AF 5C 24 10 49 89 CC 89 C9 41 89 ED 49 C1 EC 20 4D 01 EC 48 C1 EE 20 48 03 74 24 20 48 0F AF 44 24 10 48 C1 ED 20 49 C1 E8 20 49 01 EB 4C 01 C6 4C 01 E0 48 89 C5 48 C1 E0 20 48 C1 ED 20 48 01 C8 31 C9 49 01 EB 49 01 F7 0F 92 C1 49 C1 EA 20 4C 03 54 24 30 48 C1 E7 20 48 C1 EA 20 4C 01 CF 48 01 CF 49 01 D2 49 01 FA 0F 82 22 01 00 00 48 39 F9 0F 87 19 01 00 00 31 ED 48 01 C3 40 0F 92 C5 48 8B 44 24 28 49 01 EB 48 03 44 24 40 48 8B 74 24 38 0F 92 C0 0F B6 C0 49 01 C7 4C 01 FE 0F 82 BC 00 00 00 4C 39 F8 0F 87 B3 00 00 00 4D 01 D6 0F 92 C0 4D 89 F4 0F B6 C0 4C 8B 6C 24 18 48 01 C3 49 01 DD 41 0F 92 C0 48 39 C3 0F 92 C0 41 09 C0 45 0F B6 C0 8B 44 24 0C 4B 8D 2C 03 85 C0 0F 8E 5E 02 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 34 24 8B 10 48 89 E8 83 E0 01 8D 0C 95 00 00 00 00 44 8D 04 71 49 01 C0 48 8D 05 ?? ?? ?? ?? 49 C1 E0 04 49 01 C0 4D 3B 68 08 0F 87 C2 00 00 00 0F 84 AD 00 00 00 81 7C 24 0C FE 00 00 00 0F 8E DE 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 83 FA 03 0F 85 6F FA FF FF 8B 04 24 C1 E0 1F 05 FF FF 7F 7F 89 04 24 F3 0F 10 04 24 E9 A6 FA FF FF 0F 1F 00 49 83 C2 01 4D 01 D6 4D 89 F4 0F 82 25 01 00 00 4D 85 D2 0F 84 1C 01 00 00 4C 8B 6C 24 18 45 31 C0 49 01 DD 41 0F 92 C0 E9 48 FF FF FF 0F 1F 00 48 83 C0 01 48 01 C3 40 0F 92 C5 48 85 C0 0F 94 C0 09 C5 40 0F B6 ED E9 D4 FE FF FF 0F 1F 40 00 4C 8B 74 24 20 49 83 C4 01 4D 01 E6 0F 92 C2 4D 85 E4 41 0F 94 C3 44 09 DA 0F B6 D2 E9 4F FD FF FF 4D 3B 20 0F 86 4A FF FF FF 66 0F 1F 44 00 00 48 83 C5 01 48 81 FD 00 00 00 01 0F 84 CF 01 00 00 48 81 FD 00 00 80 00 0F 85 26 FF FF FF 83 7C 24 0C 01 0F 85 1B FF FF FF 48 B8 FF FF FF FF FF FF FF BF 49 39 C5 0F 87 84 01 00 00 F6 C2 03 8B 04 24 0F 85 78 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 10 31 ED C7 44 24 0C 01 00 00 00 4D 85 ED 75 05 4D 85 E4 74 0A 48 8B 15 ?? ?? ?? ?? 83 0A 20 8B 54 24 0C C1 E2 17 01 EA C1 E0 1F 01 D0 89 04 24 F3 0F 10 04 24 E9 98 F9 FF FF 0F 1F 44 00 00 44 89 D1 4C 89 CA 48 D3 E0 B9 40 00 00 00 44 29 D1 48 D3 EA 44 89 D1 48 01 D0 4C 89 CA 48 D3 E2 E9 F9 F8 FF FF B8 01 00 00 00 E9 1A FE FF FF 90 45 31 C0 4C 8D 0D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E9 4C FA FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 49 39 C9 0F 87 22 F9 FF FF 41 BE 01 00 00 00 49 BB 00 03 21 32 01 21 01 00 49 BA C0 84 8C 8C 08 CC 00 00 48 BE 00 07 0D 0E 09 0D 01 00 48 BB C0 80 A0 B0 00 E0 00 00 45 31 E4 B9 08 00 00 00 E9 55 F8 FF FF 66 90 48 81 FD FF FF 7F 00 0F 87 ED 00 00 00 4D 85 ED 75 09 4D 85 E4 0F 84 D5 00 00 00 48 8B 0D ?? ?? ?? ?? 8B 04 24 8B 11 83 CA 30 89 11 31 D2 E9 14 FF FF FF 41 B8 01 00 00 00 44 2B 44 24 0C B8 1A 00 00 00 41 B9 40 00 00 00 4D 89 E2 C7 44 24 0C 01 00 00 00 41 83 F8 1A 44 0F 4F C0 4C 89 E8 45 29 C1 44 89 C1 49 D3 EA 44 89 C9 48 D3 E0 44 89 C1 49 D3 ED 4D 8D 24 02 44 89 C9 48 89 E8 48 D3 E0 44 89 C1 49 01 C5 48 D3 ED E9 46 FD FF FF 90 48 8B 34 24 01 F2 89 F0 83 FA 02 0F 85 81 FE FF FF 4D 85 ED 0F 89 6E FE FF FF E9 73 FE FF FF 90 83 44 24 0C 01 8B 44 24 0C 3D FE 00 00 00 0F 8F 5E FD FF FF 8B 04 24 31 ED E9 5E FE FF FF 8B 04 24 48 C1 E1 12 48 C1 E9 2A C1 E0 1F 8D 84 08 00 00 C0 7F 89 04 24 F3 0F 10 04 24 E9 03 F8 FF FF 8B 04 24 31 D2 E9 4D FE FF FF 81 E5 FF FF 7F 00 8B 04 24 E9 24 FE FF FF 4D 85 C9 0F 84 D4 F7 FF FF 48 B9 00 00 00 00 FF FF FF FF 45 89 CA 49 BB FF FF 00 00 FF FF 00 00 4C 21 C9 49 39 CA 48 B9 00 00 FF FF 00 00 FF FF 45 19 D2 4C 21 C9 4D 21 CB 41 F7 D2 41 83 E2 20 49 39 CB 49 BB FF 00 FF 00 FF 00 FF 00 19 C9 4D 21 CB F7 D1 83 E1 10 41 01 CA 48 B9 00 FF 00 FF 00 FF 00 FF 4C 21 C9 49 39 CB 49 BB 0F 0F 0F 0F 0F 0F 0F 0F 19 C9 4D 21 CB F7 D1 83 E1 08 41 01 CA 48 B9 F0 F0 F0 F0 F0 F0 F0 F0 4C 21 C9 49 39 CB 49 BB 33 33 33 33 33 33 33 33 19 C9 4D 21 CB F7 D1 83 E1 04 41 01 CA 48 B9 CC CC CC CC CC CC CC CC 4C 21 C9 49 39 CB 49 BB AA AA AA AA AA AA AA AA 19 C9 4D 21 CB F7 D1 83 E1 02 44 01 D1 49 BA 55 55 55 55 55 55 55 55 4D 21 CA 4D 39 D3 41 0F 96 C2 45 0F B6 D2 44 01 D1 44 8D 51 31 41 83 FA 3F 0F 8E 60 FD FF FF 83 E9 0F 4C 89 C8 31 D2 48 D3 E0 E9 6E F6 FF FF }
	condition:
		$1
}

rule file_174_3_0 {
	meta:
		name = "__bid32_to_binary64"
		size = 1456
		refs = "00fb .rdata 02d3 .refptr.__bid_IDEC_glbround 032c .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 38 89 CA 89 C8 81 E2 00 00 00 60 C1 E8 1F 81 FA 00 00 00 60 89 CA 0F 84 D5 03 00 00 81 E2 FF FF 7F 00 0F 84 39 03 00 00 41 89 C8 44 0F B7 C9 89 D2 41 81 E0 00 00 7F 00 45 39 C1 41 89 C9 41 89 C8 45 19 D2 41 81 E1 FF 00 7F 00 41 81 E0 00 FF 00 00 41 F7 D2 41 83 E2 10 45 39 C1 41 89 C9 45 19 C0 41 81 E1 0F 0F 0F 00 41 F7 D0 41 83 E0 08 45 01 C2 41 89 C8 41 81 E0 F0 F0 70 00 45 39 C1 41 89 C9 45 19 C0 41 81 E1 33 33 33 00 41 F7 D0 41 83 E0 04 45 01 C2 41 89 C8 41 81 E0 CC CC 4C 00 45 39 C1 41 89 C8 45 19 C9 41 C1 E8 17 41 F7 D1 45 0F B6 C0 41 83 E1 02 41 83 E8 65 45 01 CA 41 89 C9 81 E1 AA AA 2A 00 41 81 E1 55 55 55 00 41 39 C9 41 0F 93 C1 45 0F B6 C9 45 01 D1 41 8D 49 F8 48 D3 E2 41 8D 49 51 4C 8D 0D ?? ?? ?? ?? 4D 63 C0 48 C1 E2 1F 49 81 C0 66 01 00 00 47 8B 14 81 4C 8D 0D ?? ?? ?? ?? 41 29 CA 4C 89 C1 48 C1 E1 04 49 3B 54 09 08 0F 86 D8 03 00 00 48 8D 0D ?? ?? ?? ?? 49 C1 E0 05 49 89 D3 41 83 C2 01 49 C1 EB 20 89 D2 4C 01 C1 4C 8B 09 48 8B 59 08 4C 8B 41 10 48 8B 49 18 4C 89 CE 45 89 C9 48 89 DD 4C 89 CF 48 C1 ED 20 89 DB 49 0F AF FB 49 89 DD 48 C1 EE 20 4C 0F AF CA 4D 89 C6 45 89 C0 48 0F AF DA 49 89 F7 49 C1 EE 20 4C 89 7C 24 08 48 89 CE 89 C9 41 89 FC 48 C1 EE 20 49 C1 E9 20 4D 01 E1 4C 89 4C 24 20 49 89 E9 4D 0F AF CB 4D 0F AF EB 48 0F AF EA 4C 89 4C 24 18 49 89 D9 89 DB 45 89 EC 49 C1 E9 20 4D 01 E1 4D 89 F4 49 01 E9 4C 89 CD 48 C1 E5 20 48 01 EB 4C 89 C5 4C 0F AF C2 48 89 5C 24 28 4D 0F AF FB 49 0F AF EB 4C 89 C3 45 89 C0 4C 89 7C 24 10 48 C1 EB 20 4C 0F AF F2 41 89 EF 48 C1 ED 20 4D 0F AF E3 4C 01 FB 4C 01 F3 49 01 EC 48 89 DD 48 C1 ED 20 49 01 EC 48 89 CD 48 0F AF CA 49 0F AF EB 4C 0F AF DE 49 89 CE 89 C9 41 89 EF 49 C1 EE 20 4D 01 FE 48 C1 ED 20 48 C1 EF 20 48 0F AF F2 49 01 EB 49 01 F6 4C 89 F5 49 C1 E6 20 49 01 CE 48 8B 4C 24 10 48 C1 ED 20 49 01 EB 48 01 F9 48 8B 7C 24 08 48 0F AF FA 31 D2 48 03 7C 24 20 48 C1 EF 20 48 01 CF 48 8B 4C 24 28 48 01 F9 0F 92 C2 49 C1 ED 20 4C 03 6C 24 18 48 C1 E3 20 49 C1 E9 20 49 01 D8 49 01 D0 4D 01 E9 4D 01 C1 0F 82 E6 00 00 00 4C 39 C2 0F 87 DD 00 00 00 31 D2 4D 01 E6 0F 92 C2 49 01 D3 45 85 D2 0F 8E E1 00 00 00 0F 1F 80 00 00 00 00 48 8B 15 ?? ?? ?? ?? 4D 89 D8 41 83 E0 01 8B 0A 8D 14 8D 00 00 00 00 8D 14 42 4C 01 C2 4C 8D 05 ?? ?? ?? ?? 48 C1 E2 04 4C 01 C2 4C 3B 72 08 0F 86 7B 01 00 00 49 83 C3 01 48 BA 00 00 00 00 00 00 20 00 49 39 D3 0F 84 77 02 00 00 41 81 FA FE 07 00 00 0F 8E 6B 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 83 F9 03 0F 84 34 02 00 00 83 F8 01 19 D2 83 C2 02 39 CA 0F 84 24 02 00 00 48 98 48 BA 00 00 00 00 00 00 F0 7F 48 C1 E0 3F 48 01 D0 48 89 44 24 08 F2 0F 10 44 24 08 EB 15 0F 1F 40 00 48 98 48 C1 E0 3F 48 89 44 24 08 F2 0F 10 44 24 08 48 83 C4 38 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 49 83 C6 01 31 D2 4D 01 E6 0F 92 C2 49 01 D3 45 85 D2 0F 8F 26 FF FF FF BA 01 00 00 00 B9 37 00 00 00 41 B8 40 00 00 00 44 29 D2 4C 89 F6 4D 89 DC 83 FA 37 41 BA 01 00 00 00 0F 4F D1 41 29 D0 89 D1 49 D3 E9 44 89 C1 48 D3 E6 89 D1 49 D3 EE 44 89 C1 49 01 F1 49 D3 E4 89 D1 4D 01 E6 49 D3 EB E9 D8 FE FF FF 0F 1F 84 00 00 00 00 00 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 84 01 01 00 00 41 89 C8 81 E1 FF FF 1F 00 41 C1 E8 15 48 8D 91 00 00 80 00 B9 59 00 00 00 45 0F B6 C0 41 83 E8 65 48 81 FA 7F 96 98 00 0F 86 B8 FC FF FF 48 8D 15 ?? ?? ?? ?? 4D 63 C0 45 31 DB 49 81 C0 66 01 00 00 46 8B 14 82 31 D2 41 83 EA 59 48 8D 0D ?? ?? ?? ?? 49 C1 E0 05 4C 01 C1 4C 8B 09 48 8B 59 08 4C 8B 41 10 48 8B 49 18 E9 D7 FC FF FF 0F 85 96 FE FF FF 4C 3B 0A 0F 86 8D FE FF FF E9 71 FE FF FF 48 BA FF FF FF FF FF FF 0F 00 49 39 D3 76 3D 49 21 D3 4D 85 F6 74 2A 48 8B 15 ?? ?? ?? ?? 83 0A 20 49 C1 E2 34 48 98 4D 01 D3 48 C1 E0 3F 4C 01 D8 48 89 44 24 08 F2 0F 10 44 24 08 E9 AC FE FF FF 4D 85 C9 75 D1 EB D9 0F 1F 40 00 4D 85 F6 75 05 4D 85 C9 74 16 48 8B 0D ?? ?? ?? ?? 8B 11 83 CA 30 89 11 0F 1F 84 00 00 00 00 00 45 31 D2 EB B4 49 89 D3 89 D2 49 C1 EB 20 E9 4B FF FF FF 89 CA 81 E2 00 00 00 7C 81 FA 00 00 00 7C 0F 85 25 FE FF FF F7 C1 00 00 00 02 74 0A 48 8B 15 ?? ?? ?? ?? 83 0A 01 48 C1 E1 2C 49 B8 00 00 00 00 00 00 F8 7F 48 98 48 C1 E9 0D 48 C1 E0 3F 4A 8D 14 01 48 01 D0 48 89 44 24 08 F2 0F 10 44 24 08 E9 19 FE FF FF 0F 1F 84 00 00 00 00 00 48 98 48 BA FF FF FF FF FF FF EF 7F 48 C1 E0 3F 48 01 D0 48 89 44 24 08 F2 0F 10 44 24 08 E9 EE FD FF FF 41 83 C2 01 45 31 DB 41 81 FA FE 07 00 00 0F 8E FF FE FF FF E9 7D FD FF FF 0F 1F 40 00 }
	condition:
		$1
}

rule file_174_4_0 {
	meta:
		name = "__bid64_to_binary64"
		size = 1776
		refs = "015e .refptr.__bid_IDEC_glbflags 0168 .refptr.__bid_IDEC_glbround 01d8 .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 38 48 B8 00 00 00 00 00 00 00 60 49 89 C8 48 89 CA 49 21 C0 48 C1 EA 3F 49 39 C0 0F 84 F1 03 00 00 48 B8 FF FF FF FF FF FF 1F 00 48 21 C8 0F 84 71 01 00 00 49 B8 00 00 00 00 FF FF 1F 00 41 89 C9 49 BA FF FF 00 00 FF FF 00 00 49 21 C8 49 BB AA AA AA AA AA AA 0A 00 4D 39 C1 49 B8 00 00 FF FF 00 00 1F 00 45 19 C9 49 21 C8 49 21 CA 41 F7 D1 41 83 E1 20 4D 39 C2 49 BA FF 00 FF 00 FF 00 1F 00 45 19 C0 49 21 CA 41 F7 D0 41 83 E0 10 45 01 C1 49 B8 00 FF 00 FF 00 FF 00 00 49 21 C8 4D 39 C2 49 BA 0F 0F 0F 0F 0F 0F 0F 00 45 19 C0 49 21 CA 41 F7 D0 41 83 E0 08 45 01 C1 49 B8 F0 F0 F0 F0 F0 F0 10 00 49 21 C8 4D 39 C2 45 19 C0 41 F7 D0 41 83 E0 04 47 8D 14 01 49 B8 CC CC CC CC CC CC 0C 00 49 B9 33 33 33 33 33 33 13 00 49 21 C8 49 21 C9 4D 39 C1 49 89 C8 45 19 C9 49 C1 E8 35 49 21 CB 41 F7 D1 41 81 E0 FF 03 00 00 41 83 E1 02 41 81 E8 8E 01 00 00 45 01 D1 49 BA 55 55 55 55 55 55 15 00 4C 21 D1 49 39 CB 0F 96 C1 0F B6 C9 41 01 C9 41 8D 49 F6 48 D3 E0 41 8D 49 31 48 01 C0 41 81 F8 34 01 00 00 7E 6A 48 8B 05 ?? ?? ?? ?? 83 08 28 48 8B 05 ?? ?? ?? ?? 8B 08 83 F9 03 0F 84 89 02 00 00 83 FA 01 19 C0 83 C0 02 39 C8 0F 84 79 02 00 00 48 C1 E2 3F 48 B8 00 00 00 00 00 00 F0 7F 48 01 C2 48 89 54 24 08 F2 0F 10 44 24 08 48 83 C4 38 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 48 C1 E2 3F 48 89 54 24 08 F2 0F 10 44 24 08 EB DE 41 81 F8 9B FE FF FF 0F 8C B2 02 00 00 4D 63 C0 4C 8D 0D ?? ?? ?? ?? 49 81 C0 66 01 00 00 4D 89 C2 49 C1 E2 04 4D 01 D1 4C 8D 15 ?? ?? ?? ?? 4F 8D 14 82 49 C1 E0 05 41 8B 32 29 CE 49 39 41 08 0F 83 08 03 00 00 48 8D 0D ?? ?? ?? ?? 83 C6 01 4C 01 C1 4C 8B 09 4C 8B 59 08 4C 8B 41 10 48 8B 49 18 4C 89 CB 49 89 C2 45 89 C9 49 C1 EA 20 89 C0 4C 89 CF 49 0F AF FA 4C 89 DD 45 89 DB 4C 0F AF C8 48 C1 ED 20 4D 89 DD 4C 0F AF D8 48 C1 EB 20 4D 89 C6 45 89 C0 49 89 DF 49 C1 EE 20 41 89 FC 4C 89 7C 24 08 48 89 CB 49 C1 E9 20 89 C9 48 C1 EB 20 4D 01 E1 4C 89 4C 24 20 49 89 E9 4D 0F AF CA 4D 0F AF EA 48 0F AF E8 4C 89 4C 24 18 4D 89 D9 45 89 DB 45 89 EC 49 C1 E9 20 4D 01 E1 4D 89 F4 49 01 E9 4C 89 CD 48 C1 E5 20 49 01 EB 4C 89 C5 4C 0F AF C0 4C 89 5C 24 28 4D 0F AF FA 49 0F AF EA 4D 89 C3 45 89 C0 4C 89 7C 24 10 49 C1 EB 20 4C 0F AF F0 41 89 EF 48 C1 ED 20 4D 0F AF E2 4D 01 FB 4D 01 F3 49 01 EC 4C 89 DD 48 C1 ED 20 49 01 EC 48 89 CD 48 0F AF C8 49 0F AF EA 4C 0F AF D3 49 89 CE 89 C9 49 C1 EE 20 41 89 EF 48 C1 ED 20 48 0F AF D8 4D 01 FE 49 01 EA 48 C1 EF 20 49 01 DE 4C 89 F5 49 C1 E6 20 49 01 CE 48 8B 4C 24 10 48 C1 ED 20 49 01 EA 48 01 F9 48 8B 7C 24 08 48 0F AF F8 48 8B 44 24 28 48 03 7C 24 20 48 C1 EF 20 48 01 CF 48 01 F8 0F 92 C0 49 C1 ED 20 4C 03 6C 24 18 49 C1 E3 20 49 C1 E9 20 0F B6 C0 4D 01 D8 49 01 C0 4D 01 E9 4D 01 C1 0F 82 28 01 00 00 4C 39 C0 0F 87 1F 01 00 00 31 C0 4D 01 E6 0F 92 C0 49 01 C2 85 F6 0F 8E 23 01 00 00 48 8B 05 ?? ?? ?? ?? 4D 89 D0 41 83 E0 01 8B 08 8D 04 8D 00 00 00 00 8D 04 50 4C 01 C0 4C 8D 05 ?? ?? ?? ?? 48 C1 E0 04 4C 01 C0 4C 3B 70 08 0F 87 67 01 00 00 0F 84 52 01 00 00 81 FE FE 07 00 00 0F 8E E7 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 83 F9 03 0F 85 79 FD FF FF 66 90 48 C1 E2 3F 48 B8 FF FF FF FF FF FF EF 7F 48 01 C2 48 89 54 24 08 F2 0F 10 44 24 08 E9 82 FD FF FF 48 B8 00 00 00 00 00 00 00 78 49 89 C8 49 21 C0 49 39 C0 0F 84 CA 01 00 00 49 89 C8 48 B8 FF FF FF FF FF FF 07 00 48 21 C1 49 C1 E8 33 48 B8 00 00 00 00 00 00 20 00 41 81 E0 FF 03 00 00 48 01 C8 48 B9 FF FF C0 6F F2 86 23 00 41 81 E8 8E 01 00 00 48 39 C8 76 28 B9 3B 00 00 00 31 C0 E9 CE FC FF FF 45 31 C0 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? E9 62 FD FF FF 66 0F 1F 44 00 00 48 01 C0 B9 3B 00 00 00 E9 A5 FC FF FF 0F 1F 00 49 83 C6 01 31 C0 4D 01 E6 0F 92 C0 49 01 C2 85 F6 0F 8F DD FE FF FF B8 01 00 00 00 B9 37 00 00 00 41 B8 40 00 00 00 29 F0 4C 89 F6 4D 89 D4 83 F8 37 0F 4F C1 41 29 C0 89 C1 49 D3 E9 44 89 C1 48 D3 E6 89 C1 49 D3 EE 44 89 C1 49 01 F1 49 D3 E4 89 C1 BE 01 00 00 00 4D 01 E6 49 D3 EA E9 91 FE FF FF 48 8D 0D ?? ?? ?? ?? 4C 01 C1 4C 8B 09 4C 8B 59 08 4C 8B 41 10 48 8B 49 18 E9 F6 FC FF FF 4C 3B 08 0F 86 A5 FE FF FF 66 0F 1F 44 00 00 49 83 C2 01 48 B8 00 00 00 00 00 00 20 00 49 39 C2 0F 84 39 01 00 00 48 B8 00 00 00 00 00 00 10 00 49 39 C2 0F 85 75 FE FF FF 83 FE 01 0F 85 6C FE FF FF 48 B8 FF FF FF FF FF FF FF BF 49 39 C6 0F 87 3A 01 00 00 F6 C1 03 0F 85 31 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 10 45 31 D2 BE 01 00 00 00 4D 85 F6 0F 84 06 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 20 48 C1 E6 34 49 01 F2 48 C1 E2 3F 4C 01 D2 48 89 54 24 08 F2 0F 10 44 24 08 E9 D1 FB FF FF 48 B8 FF FF FF FF FF FF 0F 00 49 39 C2 0F 87 F4 00 00 00 4D 85 F6 75 05 4D 85 C9 74 11 48 8B 0D ?? ?? ?? ?? 8B 01 83 C8 30 89 01 0F 1F 00 31 F6 EB B4 48 B8 00 00 00 00 00 00 00 7C 49 89 C8 49 21 C0 49 39 C0 0F 85 6A FB FF FF 48 B8 00 00 00 00 00 00 00 02 48 85 C1 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 49 B8 FF FF FF FF FF FF 03 00 49 B9 FF 7F C6 A4 7E 8D 03 00 48 C1 E2 3F 49 21 C8 48 B8 00 00 00 00 00 00 08 00 4D 39 C8 77 0B 48 C1 E1 0E 48 C1 E9 0D 48 01 C8 48 B9 00 00 00 00 00 00 F0 7F 48 01 CA 48 01 D0 48 89 44 24 08 F2 0F 10 44 24 08 E9 18 FB FF FF 0F 1F 44 00 00 83 C6 01 45 31 D2 81 FE FE 07 00 00 0F 8F 49 FD FF FF E9 FA FE FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 C9 0F 85 F1 FE FF FF E9 F6 FE FF FF 66 90 01 D1 83 F9 02 0F 85 CE FE FF FF 4D 85 F6 0F 89 BB FE FF FF E9 C0 FE FF FF 49 21 C2 E9 C0 FE FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_5_0 {
	meta:
		name = "__bid128_to_binary64"
		size = 2896
		refs = "017f .refptr.__bid_IDEC_glbflags 0189 .refptr.__bid_IDEC_glbround 02e3 .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 78 48 8B 01 48 8B 49 08 49 B8 00 00 00 00 00 00 00 60 49 89 C9 48 89 CA 4D 21 C1 48 C1 EA 3F 4D 39 C1 0F 84 8D 01 00 00 49 89 C8 48 BB FF FF FF FF FF FF 01 00 49 B9 C0 87 AD BE 09 ED 01 00 49 C1 E8 31 48 21 CB 41 81 E0 FF 3F 00 00 41 81 E8 20 18 00 00 4C 39 CB 0F 87 6D 01 00 00 0F 84 7E 08 00 00 48 85 DB 0F 84 C8 09 00 00 49 B9 00 00 00 00 FF FF 01 00 41 89 CA 49 BE 00 00 FF FF 00 00 01 00 49 21 C9 49 BF FF FF 00 00 FF FF 00 00 49 BC 00 FF 00 FF 00 FF 00 00 49 BD FF 00 FF 00 FF 00 01 00 48 BF F0 F0 F0 F0 F0 F0 00 00 48 BD 0F 0F 0F 0F 0F 0F 01 00 49 21 CE 49 21 CF 49 21 CC 49 21 CD 48 21 CF 48 21 CD 4D 39 D1 49 BA CC CC CC CC CC CC 00 00 0F 86 14 01 00 00 48 BE 55 55 55 55 55 55 01 00 49 BB 33 33 33 33 33 33 01 00 49 B9 AA AA AA AA AA AA 00 00 49 21 C9 49 21 CA 49 21 CB 48 21 F1 31 F6 49 39 C9 40 0F 96 C6 45 31 C9 4D 39 F7 19 C9 F7 D1 83 E1 10 41 01 C9 4D 39 E5 19 C9 F7 D1 83 E1 08 41 01 C9 48 39 FD 19 C9 F7 D1 83 E1 04 41 01 C9 4D 39 D3 19 C9 F7 D1 83 E1 02 44 01 C9 44 8D 4C 0E F1 45 85 C9 0F 85 3C 07 00 00 49 89 C2 48 C1 E0 06 49 C1 EA 3A 41 81 F8 34 01 00 00 0F 8E 54 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 48 8B 05 ?? ?? ?? ?? 8B 08 83 F9 03 0F 84 D8 05 00 00 83 FA 01 19 C0 83 C0 02 39 C8 0F 84 C8 05 00 00 48 C1 E2 3F 48 B8 00 00 00 00 00 00 F0 7F 48 01 C2 48 89 14 24 F2 0F 10 04 24 EB 22 49 B8 00 00 00 00 00 00 00 78 49 89 C9 4D 21 C1 4D 39 C1 74 67 48 C1 E2 3F 48 89 14 24 F2 0F 10 04 24 48 83 C4 78 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 84 00 00 00 00 00 48 BE 55 55 55 55 55 55 01 00 49 BB 33 33 33 33 33 33 01 00 49 B9 AA AA AA AA AA AA 00 00 49 21 C9 49 21 CA 49 21 CB 48 21 F1 31 F6 49 39 C9 41 B9 20 00 00 00 40 0F 96 C6 E9 E4 FE FF FF 66 90 49 B8 00 00 00 00 00 00 00 7C 49 89 C9 4D 21 C1 4D 39 C1 0F 85 4F FF FF FF 49 B8 00 00 00 00 00 00 00 02 4C 85 C1 74 0B 4C 8B 05 ?? ?? ?? ?? 41 83 08 01 49 B8 FF FF FF FF FF 3F 00 00 49 B9 93 8D 44 C6 4D 31 00 00 49 21 C8 4D 39 C8 77 19 0F 85 75 07 00 00 49 B8 FF FF FF FF 09 5B C1 38 4C 39 C0 0F 86 62 07 00 00 48 C1 E2 3F 48 B8 00 00 00 00 00 00 F8 7F 48 01 C2 48 89 14 24 F2 0F 10 04 24 E9 1F FF FF FF 66 0F 1F 84 00 00 00 00 00 41 81 F8 9B FE FF FF 0F 8C F3 05 00 00 4D 63 C0 48 8D 0D ?? ?? ?? ?? 49 81 C0 66 01 00 00 4D 89 C3 49 C1 E3 04 4C 01 D9 4C 8D 1D ?? ?? ?? ?? 4F 8D 1C 83 49 C1 E0 05 48 C1 E3 06 4A 8D 34 13 48 8B 19 45 8B 13 48 8B 49 08 48 89 74 24 30 45 29 CA 48 39 CE 44 89 14 24 72 0A 48 39 C3 72 21 48 39 CE 75 1C 48 8D 0D ?? ?? ?? ?? 49 01 C8 4D 8B 18 4D 8B 50 08 4D 8B 48 10 49 8B 48 18 EB 1E 90 48 8D 0D ?? ?? ?? ?? 83 04 24 01 49 01 C8 4D 8B 18 4D 8B 50 08 4D 8B 48 10 49 8B 48 18 4D 89 D8 48 89 C6 45 89 DB 49 C1 E8 20 48 C1 EE 20 89 C0 4D 89 DC 4C 89 C7 4C 89 DB 4C 0F AF E6 48 0F AF FE 48 0F AF D8 48 89 7C 24 38 44 89 E7 48 C1 EB 20 48 01 FB 4C 89 D7 45 89 D2 48 89 5C 24 50 4C 89 D3 48 C1 EF 20 48 0F AF DE 49 89 FF 48 89 7C 24 40 49 89 DE 48 89 FB 48 0F AF DE 4C 89 74 24 20 8B 6C 24 20 48 89 5C 24 48 4C 89 D3 48 0F AF D8 49 89 DD 89 DB 49 C1 ED 20 4C 89 EF 48 01 EF 4C 89 FD 48 0F AF E8 4C 8D 3C 2F 4C 89 FD 4C 89 7C 24 58 4D 89 CF 48 C1 E5 20 45 89 C9 49 C1 EF 20 4C 8D 6C 1D 00 4D 89 CE 4C 89 7C 24 68 4C 0F AF F0 4C 89 6C 24 60 4D 89 CD 4C 0F AF EE 4C 89 F7 48 89 FD 89 FF 4C 89 EB 48 C1 ED 20 4D 89 FD 41 89 DE 48 C1 EB 20 4C 01 F5 4D 89 FE 4C 0F AF F0 4C 0F AF EE 4C 01 F5 49 89 EF 49 01 DD 49 C1 EF 20 4F 8D 74 3D 00 49 89 CF 89 C9 49 89 CD 49 C1 EF 20 4C 89 74 24 28 49 89 CE 4C 89 7C 24 18 4C 0F AF F6 4C 0F AF E8 49 0F AF F7 45 89 F7 4C 89 EB 49 C1 ED 20 4D 01 EF 4C 8B 6C 24 18 89 DB 4C 0F AF E8 4D 01 FD 49 C1 EC 20 4C 03 64 24 38 49 0F AF C0 49 C1 EE 20 48 03 44 24 50 4C 01 F6 4D 89 EE 49 C1 EE 20 49 C1 E5 20 49 01 DD 4C 01 F6 48 8B 5C 24 20 48 C1 E8 20 49 01 C4 4C 03 64 24 60 0F 92 C0 48 C1 E5 20 48 C1 EB 20 48 01 FD 48 03 5C 24 48 48 8B 7C 24 58 0F B6 C0 4C 89 64 24 38 48 01 C5 48 C1 EF 20 48 01 FB 48 01 EB 48 89 5C 24 48 0F 82 C6 02 00 00 48 39 E8 0F 87 BD 02 00 00 4C 8B 7C 24 28 45 31 F6 4C 89 DD 4D 01 EF 41 0F 92 C6 4A 8D 04 36 4C 8B 74 24 40 48 89 44 24 20 48 8B 44 24 30 48 89 C7 89 C3 4C 89 C0 48 C1 EF 20 48 0F AF C7 4C 0F AF DB 48 0F AF EF 48 89 44 24 28 4C 89 D8 45 89 DB 4C 0F AF C3 89 EE 48 C1 E8 20 48 01 F0 49 01 C0 4C 89 C0 48 C1 E0 20 4A 8D 34 18 4D 89 D3 4C 89 F0 4C 0F AF D3 4C 0F AF DF 48 89 74 24 30 48 0F AF C7 4D 89 D4 45 89 D2 49 C1 EC 20 44 89 DE 48 89 44 24 40 4C 89 E0 48 01 F0 4C 89 F6 48 0F AF F3 48 01 F0 48 89 C6 48 C1 E6 20 4C 01 D6 4C 8B 54 24 68 48 89 74 24 50 4C 89 CE 4C 0F AF CB 48 0F AF F7 4D 89 D5 4C 0F AF EF 4D 89 CC 45 89 C9 41 89 F6 49 C1 EC 20 48 C1 EE 20 4D 01 F4 4D 89 D6 49 01 F5 4C 0F AF F3 4D 01 F4 4C 89 E6 48 C1 EE 20 4C 01 EE 49 89 CD 48 0F AF CB 4C 0F AF EF 48 0F AF 7C 24 18 49 89 CE 89 C9 45 89 EA 49 C1 EE 20 4D 01 D6 48 C1 ED 20 48 03 6C 24 28 48 0F AF 5C 24 18 49 C1 ED 20 4C 8B 54 24 50 49 C1 E8 20 4C 01 EF 4C 01 C5 49 01 DE 4D 89 F5 49 C1 E6 20 49 C1 ED 20 49 01 CE 31 C9 4C 01 EF 49 01 EA 0F 92 C1 49 C1 EB 20 4C 03 5C 24 40 49 C1 E4 20 48 C1 E8 20 4D 01 CC 49 01 CC 49 01 C3 4D 01 E3 0F 82 2F 01 00 00 4C 39 E1 0F 87 26 01 00 00 45 31 ED 4C 01 F6 41 0F 92 C5 48 8B 44 24 38 4C 01 EF 48 03 44 24 30 48 8B 5C 24 48 0F 92 C0 0F B6 C0 49 01 C2 4C 01 D3 0F 82 C8 00 00 00 4C 39 D0 0F 87 BF 00 00 00 4D 01 DF 0F 92 C0 4D 89 FD 0F B6 C0 4C 8D 34 30 48 8B 74 24 20 4C 01 F6 41 0F 92 C0 49 39 C6 0F 92 C0 41 09 C0 45 0F B6 C0 8B 04 24 4C 01 C7 85 C0 0F 8E 6A 02 00 00 48 8B 05 ?? ?? ?? ?? 48 89 F9 83 E1 01 8B 00 44 8D 04 85 00 00 00 00 45 8D 04 50 49 01 C8 48 8D 0D ?? ?? ?? ?? 49 C1 E0 04 49 01 C8 49 3B 70 08 0F 87 C2 00 00 00 0F 84 AC 00 00 00 81 3C 24 FE 07 00 00 0F 8E EF 01 00 00 48 8B 0D ?? ?? ?? ?? 83 09 28 83 F8 03 74 10 83 FA 01 19 C9 83 C1 02 39 C1 0F 85 38 FA FF FF 48 C1 E2 3F 48 B8 FF FF FF FF FF FF EF 7F 48 01 C2 48 89 14 24 F2 0F 10 04 24 E9 57 FA FF FF 90 49 83 C3 01 4D 01 DF 4D 89 FD 0F 82 22 01 00 00 4D 85 DB 0F 84 19 01 00 00 45 31 C0 48 03 74 24 20 41 0F 92 C0 E9 40 FF FF FF 66 0F 1F 44 00 00 49 83 C6 01 4C 01 F6 41 0F 92 C5 4D 85 F6 0F 94 C0 41 09 C5 45 0F B6 ED E9 C7 FE FF FF 0F 1F 00 49 83 C5 01 E9 3A FD FF FF 0F 1F 80 00 00 00 00 4D 3B 28 0F 86 4B FF FF FF 0F 1F 80 00 00 00 00 48 83 C7 01 48 B9 00 00 00 00 00 00 20 00 48 39 CF 0F 84 D9 01 00 00 48 B9 00 00 00 00 00 00 10 00 48 39 CF 0F 85 1A FF FF FF 83 3C 24 01 0F 85 10 FF FF FF 48 B9 FF FF FF FF FF FF FF BF 48 39 CE 0F 87 89 01 00 00 A8 03 0F 85 81 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 10 31 FF C7 04 24 01 00 00 00 48 85 F6 75 05 4D 85 ED 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 20 48 8B 04 24 48 C1 E0 34 48 01 C7 48 C1 E2 3F 48 01 FA 48 89 14 24 F2 0F 10 04 24 E9 50 F9 FF FF 66 2E 0F 1F 84 00 00 00 00 00 44 89 C9 48 89 C7 48 D3 E3 B9 40 00 00 00 44 29 C9 48 D3 EF 44 89 C9 48 01 FB 48 D3 E0 E9 A2 F8 FF FF B8 01 00 00 00 E9 11 FE FF FF 0F 1F 40 00 45 31 C0 4C 8D 1D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E9 21 FA FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 B9 FF FF FF FF 63 8E 8D 37 48 39 C8 0F 87 D6 F8 FF FF BE 01 00 00 00 49 BB 00 03 21 32 01 21 01 00 49 BA C0 84 8C 8C 08 CC 00 00 48 BD 00 07 0D 0E 09 0D 01 00 48 BF C0 80 A0 B0 00 E0 00 00 45 31 C9 B9 08 00 00 00 E9 FC F7 FF FF 0F 1F 00 48 B8 FF FF FF FF FF FF 0F 00 48 39 C7 0F 87 E8 00 00 00 48 85 F6 75 05 4D 85 ED 74 0E 48 8B 0D ?? ?? ?? ?? 8B 01 83 C8 30 89 01 31 C0 E9 0C FF FF FF 41 B8 01 00 00 00 44 2B 04 24 B8 37 00 00 00 41 B9 40 00 00 00 4D 89 EB 49 89 FE C7 04 24 01 00 00 00 41 83 F8 37 44 0F 4F C0 48 89 F0 45 29 C1 44 89 C1 49 D3 EB 44 89 C9 48 D3 E0 44 89 C1 48 D3 EE 44 89 C9 4D 8D 2C 03 49 D3 E6 44 89 C1 4C 01 F6 48 D3 EF E9 3C FD FF FF 0F 1F 40 00 01 D0 83 F8 02 0F 85 7E FE FF FF 48 85 F6 0F 89 6B FE FF FF E9 70 FE FF FF 0F 1F 80 00 00 00 00 83 04 24 01 8B 3C 24 81 FF FE 07 00 00 0F 8F 4E FD FF FF 31 FF E9 58 FE FF FF 48 C1 E1 12 48 C1 E8 2E 48 C1 E2 3F 48 01 C8 48 B9 00 00 00 00 00 00 F8 7F 48 C1 E8 0D 48 01 C8 48 01 C2 48 89 14 24 F2 0F 10 04 24 E9 AB F7 FF FF 48 21 C7 E9 1F FE FF FF 48 85 C0 0F 84 8D F7 FF FF 48 B9 00 00 00 00 FF FF FF FF 41 89 C1 49 BA FF FF 00 00 FF FF 00 00 48 21 C1 49 39 C9 48 B9 00 00 FF FF 00 00 FF FF 45 19 C9 48 21 C1 49 21 C2 41 F7 D1 41 83 E1 20 49 39 CA 49 BA FF 00 FF 00 FF 00 FF 00 19 C9 49 21 C2 F7 D1 83 E1 10 41 01 C9 48 B9 00 FF 00 FF 00 FF 00 FF 48 21 C1 49 39 CA 49 BA 0F 0F 0F 0F 0F 0F 0F 0F 19 C9 49 21 C2 F7 D1 83 E1 08 41 01 C9 48 B9 F0 F0 F0 F0 F0 F0 F0 F0 48 21 C1 49 39 CA 49 BA 33 33 33 33 33 33 33 33 19 C9 49 21 C2 F7 D1 83 E1 04 41 01 C9 48 B9 CC CC CC CC CC CC CC CC 48 21 C1 49 39 CA 49 BA AA AA AA AA AA AA AA AA 19 C9 49 21 C2 F7 D1 83 E1 02 44 01 C9 49 B9 55 55 55 55 55 55 55 55 49 21 C1 4D 39 CA 41 0F 96 C1 45 0F B6 C9 44 01 C9 44 8D 49 31 41 83 F9 3F 0F 8E 65 FD FF FF 83 E9 0F 45 31 D2 48 D3 E0 48 89 C3 31 C0 E9 21 F6 FF FF 66 90 }
	condition:
		$1
}

rule file_174_6_0 {
	meta:
		name = "__bid32_to_binary80"
		size = 1872
		refs = "00ed .rdata 02f2 .refptr.__bid_IDEC_glbround 0335 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 48 48 89 C8 89 D1 41 89 D2 81 E1 00 00 00 60 41 C1 EA 1F 81 F9 00 00 00 60 0F 84 E2 03 00 00 41 89 D3 41 81 E3 FF FF 7F 00 0F 84 66 03 00 00 89 D1 44 0F B7 C2 81 E1 00 00 7F 00 41 39 C8 41 89 D0 89 D1 45 19 C9 41 81 E0 FF 00 7F 00 81 E1 00 FF 00 00 41 F7 D1 41 83 E1 10 41 39 C8 41 89 D0 19 C9 41 81 E0 0F 0F 0F 00 F7 D1 83 E1 08 41 01 C9 89 D1 81 E1 F0 F0 70 00 41 39 C8 41 89 D0 19 C9 41 81 E0 33 33 33 00 F7 D1 83 E1 04 41 01 C9 89 D1 81 E1 CC CC 4C 00 41 39 C8 41 89 D0 19 C9 41 C1 E8 17 F7 D1 45 0F B6 C0 83 E1 02 41 83 E8 65 41 01 C9 89 D1 81 E2 AA AA 2A 00 81 E1 55 55 55 00 39 D1 44 89 DA 0F 93 C1 0F B6 C9 41 01 C9 41 8D 49 F8 48 D3 E2 41 8D 49 51 4C 8D 0D ?? ?? ?? ?? 4D 63 C0 48 C1 E2 19 49 81 C0 79 13 00 00 47 8B 1C 81 4C 8D 0D ?? ?? ?? ?? 41 29 CB 4C 89 C1 48 C1 E1 04 49 3B 54 09 08 0F 86 A1 04 00 00 48 8D 0D ?? ?? ?? ?? 49 C1 E0 05 41 83 C3 01 89 D7 49 01 C8 48 89 D1 49 8B 30 49 8B 58 08 48 C1 E9 20 4D 8B 48 10 4D 8B 60 18 41 89 F0 48 89 F2 4C 89 E6 4D 89 C5 48 C1 EA 20 48 89 DD 4C 0F AF E9 49 89 D7 44 89 E2 4C 0F AF C7 89 DB 48 C1 ED 20 4D 89 CE 45 89 C9 4C 89 7C 24 08 49 C1 EE 20 48 C1 EE 20 4C 89 2C 24 44 8B 24 24 49 C1 E8 20 4C 0F AF F9 4D 01 E0 4C 89 44 24 20 49 89 D8 4C 0F AF C1 4C 89 7C 24 10 48 0F AF DF 4D 89 C5 49 89 E8 4C 0F AF C1 45 89 EC 48 0F AF EF 4C 89 44 24 18 49 89 D8 89 DB 49 C1 E8 20 4D 01 E0 4D 89 F4 49 01 E8 4C 89 C5 48 C1 E5 20 48 01 EB 4C 89 CD 4C 0F AF CF 48 89 5C 24 28 48 0F AF E9 4C 0F AF F7 4C 89 CB 45 89 C9 41 89 EF 48 C1 EB 20 48 C1 ED 20 4C 0F AF E1 4C 01 FB 4C 01 F3 49 01 EC 48 89 DD 48 C1 ED 20 49 01 EC 48 89 D5 48 0F AF D7 48 0F AF E9 48 0F AF CE 49 89 D6 89 D2 41 89 EF 49 C1 EE 20 4D 01 FE 48 C1 ED 20 48 0F AF F7 48 01 E9 48 0F AF 7C 24 08 49 01 F6 31 F6 4C 89 F5 49 C1 E6 20 48 03 7C 24 20 49 01 D6 48 8B 14 24 48 C1 ED 20 48 01 E9 48 C1 EA 20 48 03 54 24 10 48 C1 EF 20 48 01 FA 48 03 54 24 28 40 0F 92 C6 49 C1 ED 20 4C 03 6C 24 18 48 C1 E3 20 49 C1 E8 20 4C 01 CB 48 01 F3 4D 01 E8 49 01 D8 0F 82 5D 01 00 00 48 39 DE 0F 87 54 01 00 00 45 31 C9 4C 89 C3 4D 01 E6 41 0F 92 C1 48 C1 EA 2F 48 C1 E3 11 48 01 D3 4C 01 C9 4C 89 F2 48 C1 E2 11 49 C1 E8 2F 48 C1 E1 11 49 C1 EE 2F 49 01 D0 49 01 CE 45 85 DB 0F 8E 87 02 00 00 4C 89 F6 83 E6 01 48 8B 15 ?? ?? ?? ?? 8B 12 44 8D 0C 95 00 00 00 00 43 8D 0C 51 4C 8D 0D ?? ?? ?? ?? 48 01 F1 48 C1 E1 04 4C 01 C9 4C 3B 41 08 0F 87 81 01 00 00 0F 84 6C 01 00 00 41 81 FB FE 7F 00 00 0F 8E EE 01 00 00 48 8B 0D ?? ?? ?? ?? 45 31 ED 83 09 28 83 FA 03 C7 44 24 3C 00 00 00 00 66 44 89 6C 24 3A 0F 84 AA 02 00 00 41 83 FA 01 19 C9 83 C1 02 39 D1 0F 84 99 02 00 00 45 31 C0 45 31 C9 45 31 DB BB 00 80 FF FF 66 44 89 44 24 30 66 44 89 4C 24 32 66 44 89 5C 24 34 66 89 5C 24 36 41 C1 E2 0F 66 41 81 C2 FF 7F 66 44 89 54 24 38 DB 6C 24 30 DB 38 EB 41 45 31 F6 45 31 FF 31 D2 31 C9 45 31 C0 41 C1 E2 0F C7 44 24 3C 00 00 00 00 66 44 89 74 24 3A 66 44 89 7C 24 30 66 89 54 24 32 66 89 4C 24 34 66 44 89 44 24 36 66 44 89 54 24 38 DB 6C 24 30 DB 38 48 83 C4 48 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 2E 0F 1F 84 00 00 00 00 00 49 83 C6 01 E9 A3 FE FF FF 0F 1F 80 00 00 00 00 89 D1 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 84 AC 01 00 00 41 89 D0 81 E2 FF FF 1F 00 B9 59 00 00 00 41 C1 E8 15 48 81 C2 00 00 80 00 45 0F B6 C0 41 83 E8 65 48 81 FA 7F 96 98 00 0F 86 98 FC FF FF 4D 63 C0 48 8D 15 ?? ?? ?? ?? 31 C9 49 81 C0 79 13 00 00 31 FF 46 8B 1C 82 41 83 EB 59 48 8D 15 ?? ?? ?? ?? 49 C1 E0 05 49 01 D0 49 8B 30 49 8B 58 08 4D 8B 48 10 4D 8B 60 18 E9 B8 FC FF FF 48 3B 19 0F 86 8B FE FF FF 66 0F 1F 44 00 00 49 83 C6 01 0F 85 7B FE FF FF 41 83 C3 01 41 81 FB FE 7F 00 00 0F 8F 77 FE FF FF 41 BE 00 80 FF FF 31 D2 45 31 C9 31 F6 4D 85 C0 75 05 48 85 DB 74 0A 48 8B 0D ?? ?? ?? ?? 83 09 20 41 C1 E2 0F 31 C9 C7 44 24 3C 00 00 00 00 45 01 D3 66 89 4C 24 3A 66 89 74 24 30 66 44 89 4C 24 32 66 89 54 24 34 66 44 89 74 24 36 66 44 89 5C 24 38 DB 6C 24 30 DB 38 E9 CC FE FF FF 0F 1F 80 00 00 00 00 4D 85 F6 0F 88 E9 01 00 00 4D 85 C0 0F 84 13 01 00 00 4C 8B 05 ?? ?? ?? ?? 4D 89 F1 4C 89 F2 41 81 E1 00 00 FF FF 48 C1 E2 10 44 89 F6 49 C1 E9 10 48 C1 EA 30 49 C1 EE 30 41 8B 08 45 31 DB 83 C9 30 41 89 08 E9 72 FF FF FF 66 0F 1F 44 00 00 41 B9 01 00 00 00 45 29 D9 41 83 F9 42 0F 8E FD 00 00 00 BF 3E 00 00 00 41 B9 02 00 00 00 4D 89 F3 31 F6 45 31 F6 45 31 ED 4C 89 DB 89 F9 48 D3 E3 44 89 C9 49 D3 E8 49 D3 EB 4C 01 C3 4F 8D 04 2B 41 BB 01 00 00 00 E9 33 FD FF FF 0F 1F 40 00 89 D7 48 C1 EA 20 48 89 D1 E9 A1 FE FF FF 66 90 89 D1 81 E1 00 00 00 7C 81 F9 00 00 00 7C 0F 84 CC 00 00 00 31 F6 C7 44 24 3C 00 00 00 00 66 89 74 24 3A E9 6F FD FF FF 0F 1F 84 00 00 00 00 00 41 C1 E2 0F BE FF FF FF FF BF FF FF FF FF BD FF FF FF FF 41 BC FF FF FF FF 66 41 81 C2 FE 7F 66 89 74 24 30 66 89 7C 24 32 66 89 6C 24 34 66 44 89 64 24 36 66 44 89 54 24 38 DB 6C 24 30 DB 38 E9 A0 FD FF FF 48 85 DB 0F 85 E4 FE FF FF 4D 89 F1 4C 89 F2 44 89 F6 41 81 E1 00 00 FF FF 48 C1 E2 10 49 C1 EE 30 49 C1 E9 10 48 C1 EA 30 45 31 DB E9 66 FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 F9 3F 0F 8F AD 00 00 00 41 8D 7B 3F 4D 89 F5 4D 89 C3 49 89 D8 89 F9 49 D3 E5 44 89 C9 49 D3 EE 4C 89 F6 83 E6 01 E9 EC FE FF FF 0F 1F 00 F7 C2 00 00 00 02 74 0A 48 8B 0D ?? ?? ?? ?? 83 09 01 48 C1 E2 2C 48 B9 00 00 00 00 00 00 00 C0 45 31 C9 48 C1 EA 02 45 31 DB 31 DB 48 01 CA C7 44 24 3C 00 00 00 00 48 89 D1 48 C1 EA 30 66 44 89 4C 24 3A 48 C1 E9 20 66 44 89 5C 24 30 66 89 5C 24 32 66 89 4C 24 34 66 89 54 24 36 E9 7A FC FF FF 4D 89 F1 4C 89 F2 44 89 F6 41 81 E1 00 00 FF FF 48 C1 E2 10 49 C1 EE 30 49 C1 E9 10 48 C1 EA 30 E9 91 FD FF FF 41 B9 C1 FF FF FF 41 8D 7B 7F 45 29 D9 E9 45 FE FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_174_7_0 {
	meta:
		name = "__bid64_to_binary80"
		size = 2576
		refs = "0177 .rdata 05ea .refptr.__bid_IDEC_glbround 0633 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 78 48 89 C8 49 89 D0 48 B9 00 00 00 00 00 00 00 60 48 89 D6 49 21 C8 48 C1 EE 3F 49 39 C8 48 89 74 24 08 0F 84 08 02 00 00 48 B9 FF FF FF FF FF FF 1F 00 48 21 D1 49 89 C8 0F 84 95 01 00 00 48 B9 00 00 00 00 FF FF 1F 00 41 89 D1 49 BA FF FF 00 00 FF FF 00 00 48 21 D1 49 39 C9 48 B9 00 00 FF FF 00 00 1F 00 45 19 C9 48 21 D1 49 21 D2 41 F7 D1 41 83 E1 20 49 39 CA 49 BA FF 00 FF 00 FF 00 1F 00 19 C9 49 21 D2 F7 D1 83 E1 10 41 01 C9 48 B9 00 FF 00 FF 00 FF 00 00 48 21 D1 49 39 CA 49 BA 0F 0F 0F 0F 0F 0F 0F 00 19 C9 49 21 D2 F7 D1 83 E1 08 41 01 C9 48 B9 F0 F0 F0 F0 F0 F0 10 00 48 21 D1 49 39 CA 19 C9 F7 D1 83 E1 04 45 8D 1C 09 48 B9 CC CC CC CC CC CC 0C 00 49 B9 33 33 33 33 33 33 13 00 48 21 D1 49 21 D1 49 39 C9 48 89 D1 45 19 C9 48 C1 E9 35 41 F7 D1 81 E1 FF 03 00 00 41 83 E1 02 44 8D 91 72 FE FF FF 48 B9 55 55 55 55 55 55 15 00 45 01 D9 49 BB AA AA AA AA AA AA 0A 00 49 21 D3 48 21 CA 49 39 D3 4C 89 C2 41 0F 96 C3 45 0F B6 DB 45 01 D9 41 8D 49 F6 45 8D 59 31 48 D3 E2 48 89 D6 48 89 D3 48 C1 EA 25 48 C1 E6 3B 48 C1 EB 05 49 89 F1 41 89 D8 49 C1 E9 20 49 63 CA 4C 8D 15 ?? ?? ?? ?? 48 81 C1 79 13 00 00 48 89 CF 48 C1 E7 04 49 01 FA 48 8D 3D ?? ?? ?? ?? 49 8B 2A 8B 3C 8F 44 29 DF 49 39 5A 08 89 7C 24 14 0F 87 16 00 00 00 0F 85 30 01 00 00 48 39 F5 0F 82 27 01 00 00 0F 1F 80 00 00 00 00 4C 8D 15 ?? ?? ?? ?? 48 C1 E1 05 4A 8D 1C 11 4C 8B 13 4C 8B 5B 08 48 8B 4B 10 4C 8B 6B 18 E9 1F 01 00 00 0F B7 54 24 08 45 31 C9 45 31 D2 45 31 DB 31 DB 31 F6 C7 44 24 6C 00 00 00 00 66 44 89 4C 24 6A 66 44 89 54 24 60 66 44 89 5C 24 62 C1 E2 0F 66 89 5C 24 64 66 89 74 24 66 66 89 54 24 68 DB 6C 24 60 DB 38 48 83 C4 78 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 84 00 00 00 00 00 48 B9 00 00 00 00 00 00 00 78 49 89 D0 49 21 C8 49 39 C8 0F 84 F7 05 00 00 48 89 D1 48 C1 E9 33 81 E1 FF 03 00 00 44 8D 91 72 FE FF FF 48 B9 FF FF FF FF FF FF 07 00 48 21 CA 48 B9 00 00 00 00 00 00 20 00 48 01 CA 48 B9 FF FF C0 6F F2 86 23 00 48 39 CA 76 1A 45 31 C0 31 D2 45 31 C9 41 BB 3B 00 00 00 31 F6 31 DB E9 C4 FE FF FF 0F 1F 00 48 89 D6 48 89 D3 41 BB 3B 00 00 00 48 C1 E6 3B 48 C1 EB 05 48 C1 EA 25 49 89 F1 41 89 D8 49 C1 E9 20 E9 9A FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8D 1D ?? ?? ?? ?? 48 C1 E1 05 83 44 24 14 01 48 01 CB 4C 8B 13 4C 8B 5B 08 48 8B 4B 10 4C 8B 6B 18 4D 89 DE 45 89 DB 4C 89 D6 49 C1 EE 20 4D 89 DC 48 C1 EE 20 4D 0F AF E1 4C 89 F3 48 89 F5 49 0F AF D9 45 89 D2 49 0F AF E9 4C 89 E7 48 89 5C 24 30 48 C1 E7 20 48 89 CB 48 C1 EB 20 48 89 7C 24 38 89 CF 49 89 DF 48 89 5C 24 40 48 89 FB 49 0F AF D9 4C 89 F9 48 89 6C 24 28 49 0F AF C9 49 89 DF 49 C1 EF 20 4C 01 F9 48 89 4C 24 20 4C 89 E9 45 89 ED 48 C1 E9 20 49 89 CF 48 89 4C 24 18 4C 89 E9 49 0F AF C9 4D 0F AF F9 4D 0F AF CA 48 89 CD 48 C1 E1 20 48 C1 ED 20 49 01 EF 48 8B 6C 24 28 49 C1 E9 20 4C 89 7C 24 48 4C 01 CD 48 03 6C 24 38 41 0F 92 C1 49 C1 EC 20 4C 03 64 24 30 48 C1 E3 20 45 0F B6 C9 48 89 6C 24 38 4C 01 CB 49 01 DC 4C 89 64 24 30 0F 82 C3 02 00 00 49 39 D9 0F 87 BA 02 00 00 48 03 4C 24 20 4D 89 D1 48 89 F3 41 0F 92 C7 48 89 4C 24 20 4D 0F AF D0 45 0F B6 FF 4C 03 7C 24 48 4C 0F AF CA 49 0F AF F0 4C 89 D1 45 89 D2 4C 89 7C 24 28 48 C1 E9 20 45 89 CC 4C 8B 7C 24 40 49 01 CC 49 01 F4 48 0F AF DA 4C 89 E1 4C 89 FE 48 C1 E1 20 4C 01 D1 48 89 4C 24 50 4C 89 F1 48 0F AF CA 48 89 5C 24 48 4C 89 DB 4D 0F AF D8 48 0F AF DA 48 89 4C 24 58 4C 89 D9 45 89 DB 4D 0F AF F0 41 89 DA 48 C1 E9 20 4C 01 D1 48 0F AF F2 4C 01 F1 49 89 CA 49 C1 E2 20 4F 8D 34 1A 49 89 FB 4C 0F AF DA 49 0F AF F8 44 89 DD 49 C1 EB 20 49 89 FA 48 C1 EF 20 4C 01 DE 48 01 EF 4C 89 FD 4D 89 EB 49 0F AF E8 45 89 D2 4D 0F AF E8 4C 0F AF DA 48 0F AF 54 24 18 48 01 EF 49 89 FF 49 C1 EF 20 44 89 DD 49 01 F7 4C 89 EE 45 89 ED 48 C1 EE 20 48 01 EE 49 C1 E9 20 4C 03 4C 24 48 4C 0F AF 44 24 18 49 C1 EB 20 49 C1 EC 20 4C 01 DA 4D 01 E1 4C 01 C6 45 31 C0 49 89 F3 48 C1 E6 20 49 C1 EB 20 49 01 F5 4C 01 DA 4D 01 CE 41 0F 92 C0 48 C1 EB 20 48 03 5C 24 58 48 C1 E7 20 48 C1 E9 20 4C 01 D7 4C 01 C7 48 01 CB 48 01 FB 0F 82 A5 01 00 00 49 39 F8 0F 87 9C 01 00 00 45 31 DB 4D 01 EF 41 0F 92 C3 31 C9 4C 01 DA 48 8B 74 24 50 48 03 74 24 38 4C 8B 64 24 30 0F 92 C1 49 01 CE 4D 01 F4 0F 82 3F 01 00 00 4C 39 F1 0F 87 36 01 00 00 48 8B 4C 24 20 45 31 C0 48 01 D9 41 0F 92 C0 4F 8D 2C 38 4C 8B 7C 24 28 4D 01 EF 41 0F 92 C1 4D 39 C5 41 0F 92 C2 45 09 D1 45 0F B6 C9 49 89 C8 49 C1 EC 2F 48 C1 E9 2F 49 C1 E0 11 4C 01 CA 4D 01 C4 4D 89 F8 48 C1 E2 11 49 C1 E0 11 49 C1 EF 2F 4A 8D 1C 01 44 8B 44 24 14 4C 01 FA 45 85 C0 0F 8E 20 02 00 00 49 89 D3 41 83 E3 01 48 8B 0D ?? ?? ?? ?? 48 8B 74 24 08 8B 09 44 8D 0C 8D 00 00 00 00 45 8D 04 71 4C 8D 0D ?? ?? ?? ?? 4D 01 D8 49 C1 E0 04 4D 01 C8 49 3B 58 08 0F 87 F4 00 00 00 0F 84 DE 00 00 00 81 7C 24 14 FE 7F 00 00 0F 8E 80 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 83 F9 03 0F 84 AE 02 00 00 83 7C 24 08 01 19 D2 83 C2 02 39 CA 0F 84 9C 02 00 00 31 DB 31 F6 31 FF 31 ED 41 BC 00 80 FF FF C7 44 24 6C 00 00 00 00 66 89 5C 24 6A 66 89 74 24 60 66 89 7C 24 62 66 89 6C 24 64 66 44 89 64 24 66 0F B7 54 24 08 C1 E2 0F 66 81 C2 FF 7F 66 89 54 24 68 DB 6C 24 60 DB 38 E9 85 FB FF FF 48 83 C1 01 E9 3D FD FF FF 0F 1F 44 00 00 48 8B 4C 24 20 48 83 C3 01 48 01 D9 0F 82 DE 00 00 00 48 85 DB 0F 84 D5 00 00 00 45 31 C9 4C 03 7C 24 28 41 0F 92 C1 E9 CB FE FF FF 0F 1F 40 00 49 83 C5 01 4D 01 EF 41 0F 92 C3 4D 85 ED 0F 94 C1 41 09 CB 45 0F B6 DB E9 51 FE FF FF 0F 1F 00 4D 3B 20 0F 86 19 FF FF FF 0F 1F 80 00 00 00 00 48 83 C2 01 0F 85 08 FF FF FF 83 44 24 14 01 8B 74 24 14 81 FE FE 7F 00 00 0F 8F 01 FF FF FF BA 00 80 FF FF 45 31 C0 45 31 C9 45 31 D2 48 85 DB 75 05 4D 85 E4 74 0A 48 8B 0D ?? ?? ?? ?? 83 09 20 0F B7 4C 24 14 66 89 54 24 66 45 31 DB 0F B7 54 24 08 C7 44 24 6C 00 00 00 00 66 44 89 5C 24 6A 66 44 89 54 24 60 66 44 89 4C 24 62 66 44 89 44 24 64 C1 E2 0F 01 D1 66 89 4C 24 68 DB 6C 24 60 DB 38 E9 8F FA FF FF 0F 1F 84 00 00 00 00 00 41 B8 01 00 00 00 E9 DE FD FF FF 0F 1F 44 00 00 48 85 D2 0F 88 F7 01 00 00 48 85 DB 0F 84 8E 01 00 00 4C 8B 1D ?? ?? ?? ?? 49 89 D1 49 89 D0 41 81 E1 00 00 FF FF 49 C1 E0 10 41 89 D2 49 C1 E9 10 49 C1 E8 30 48 C1 EA 30 41 8B 0B 83 C9 30 41 89 0B 31 C9 E9 5D FF FF FF 0F 1F 80 00 00 00 00 41 BA 01 00 00 00 44 2B 54 24 14 41 83 FA 42 0F 8E 6B 01 00 00 BE 3E 00 00 00 41 BA 02 00 00 00 49 89 D0 45 31 DB 31 D2 31 FF 4D 89 C1 89 F1 C7 44 24 14 01 00 00 00 49 D3 E1 44 89 D1 48 D3 EB 49 D3 E8 4E 8D 24 0B 49 8D 1C 38 E9 97 FD FF FF 48 B9 00 00 00 00 00 00 00 7C 49 89 D0 49 21 C8 49 39 C8 0F 85 EC FD FF FF 48 B9 00 00 00 00 00 00 00 02 48 85 CA 74 0A 48 8B 0D ?? ?? ?? ?? 83 09 01 48 B9 FF FF FF FF FF FF 03 00 49 B8 FF 7F C6 A4 7E 8D 03 00 31 FF 48 21 D1 C7 44 24 6C 00 00 00 00 4C 39 C1 66 89 7C 24 6A 0F 87 24 01 00 00 48 C1 E2 0E 48 B9 00 00 00 00 00 00 00 C0 48 C1 EA 02 66 89 54 24 60 48 01 CA 48 89 D1 48 C1 E9 10 66 89 4C 24 62 48 89 D1 48 C1 EA 30 48 C1 E9 20 66 89 4C 24 64 66 89 54 24 66 E9 94 FD FF FF BA FF FF FF FF 45 31 ED 41 BE FF FF FF FF 66 89 54 24 64 0F B7 54 24 08 41 BF FF FF FF FF B9 FF FF FF FF C7 44 24 6C 00 00 00 00 66 44 89 6C 24 6A 66 44 89 74 24 60 66 44 89 7C 24 62 66 89 4C 24 66 C1 E2 0F 66 81 C2 FE 7F 66 89 54 24 68 DB 6C 24 60 DB 38 E9 DC F8 FF FF 0F 1F 44 00 00 4D 85 E4 0F 85 69 FE FF FF 49 89 D1 49 89 D0 41 89 D2 41 81 E1 00 00 FF FF 49 C1 E0 10 48 C1 EA 30 49 C1 E9 10 49 C1 E8 30 31 C9 E9 D6 FD FF FF 41 83 FA 3F 7F 70 8B 74 24 14 48 89 D7 49 89 D8 4C 89 E3 83 C6 3F 89 F1 48 D3 E7 44 89 D1 48 D3 EA 49 89 D3 41 83 E3 01 E9 7D FE FF FF 0F 1F 00 49 89 D1 49 89 D0 41 89 D2 41 81 E1 00 00 FF FF 49 C1 E0 10 48 C1 EA 30 49 C1 E9 10 49 C1 E8 30 E9 68 FD FF FF 31 D2 31 C9 45 31 C0 66 89 54 24 60 66 89 4C 24 62 BA 00 C0 FF FF 66 44 89 44 24 64 E9 F1 FE FF FF 8B 7C 24 14 41 BA C1 FF FF FF 89 FE 41 29 FA 83 C6 7F E9 13 FE FF FF 0F 1F 00 }
	condition:
		$1
}

rule file_174_8_0 {
	meta:
		name = "__bid128_to_binary80"
		size = 3424
		refs = "0190 .refptr.__bid_IDEC_glbflags 019a .refptr.__bid_IDEC_glbround 0373 .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC 88 00 00 00 4C 8B 42 08 4C 8B 12 48 89 C8 48 B9 00 00 00 00 00 00 00 60 4D 89 C1 4C 89 C7 4C 89 D2 49 21 C9 48 C1 EF 3F 49 39 C9 48 89 7C 24 08 0F 84 C0 01 00 00 4D 89 C1 48 B9 FF FF FF FF FF FF 01 00 4C 21 C1 49 C1 E9 31 41 81 E1 FF 3F 00 00 48 89 CE 48 89 4C 24 10 48 B9 C0 87 AD BE 09 ED 01 00 41 81 E9 20 18 00 00 48 39 CE 0F 87 9C 01 00 00 0F 84 9D 09 00 00 48 83 7C 24 10 00 0F 84 7E 0B 00 00 48 B9 00 00 00 00 FF FF 01 00 45 89 C3 49 BC 00 00 FF FF 00 00 01 00 4C 21 C1 49 BD FF FF 00 00 FF FF 00 00 48 BF 00 FF 00 FF 00 FF 00 00 48 BD FF 00 FF 00 FF 00 01 00 48 BB F0 F0 F0 F0 F0 F0 00 00 48 BE 0F 0F 0F 0F 0F 0F 01 00 4D 21 C4 4D 21 C5 4C 21 C7 4C 21 C5 4C 21 C3 4C 21 C6 4C 39 D9 48 B9 CC CC CC CC CC CC 00 00 0F 86 7B 01 00 00 49 BE 55 55 55 55 55 55 01 00 49 BB 33 33 33 33 33 33 01 00 49 BF AA AA AA AA AA AA 00 00 4C 21 C1 4D 21 C3 4D 21 C7 4D 21 F0 4D 39 C7 41 0F 96 C0 45 31 F6 45 0F B6 C0 4D 39 E5 45 19 E4 41 F7 D4 41 83 E4 10 45 01 E6 48 39 FD 19 FF F7 D7 83 E7 08 44 01 F7 48 39 DE 19 DB F7 D3 83 E3 04 01 FB 49 39 CB 19 C9 F7 D1 83 E1 02 01 D9 45 8D 44 08 F1 45 85 C0 0F 85 C1 07 00 00 41 81 F9 44 13 00 00 0F 8E D3 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 48 8B 15 ?? ?? ?? ?? 8B 0A 83 F9 03 0F 84 87 06 00 00 83 7C 24 08 01 19 D2 83 C2 02 39 CA 0F 84 75 06 00 00 45 31 DB 31 DB 31 F6 31 FF BD 00 80 FF FF C7 44 24 7C 00 00 00 00 66 44 89 5C 24 7A 66 89 5C 24 70 66 89 74 24 72 66 89 7C 24 74 66 89 6C 24 76 0F B7 54 24 08 C1 E2 0F 66 81 C2 FF 7F 66 89 54 24 78 DB 6C 24 70 DB 38 EB 5F 48 BA 00 00 00 00 00 00 00 78 4C 89 C1 48 21 D1 48 39 D1 0F 84 A2 00 00 00 0F B7 54 24 08 45 31 C0 45 31 C9 45 31 D2 45 31 DB 31 DB C7 44 24 7C 00 00 00 00 66 44 89 44 24 7A 66 44 89 4C 24 70 66 44 89 54 24 72 C1 E2 0F 66 44 89 5C 24 74 66 89 5C 24 76 66 89 54 24 78 DB 6C 24 70 DB 38 48 81 C4 88 00 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 84 00 00 00 00 00 49 BE 55 55 55 55 55 55 01 00 49 BB 33 33 33 33 33 33 01 00 49 BF AA AA AA AA AA AA 00 00 4C 21 C1 4D 21 C3 4D 21 C7 4D 21 F0 41 BE 20 00 00 00 4D 39 C7 41 0F 96 C0 45 0F B6 C0 E9 7D FE FF FF 48 BA 00 00 00 00 00 00 00 7C 4C 89 C1 48 21 D1 48 39 D1 0F 85 E2 FE FF FF 48 BA 00 00 00 00 00 00 00 02 49 85 D0 74 0A 48 8B 15 ?? ?? ?? ?? 83 0A 01 48 BA FF FF FF FF FF 3F 00 00 48 B9 93 8D 44 C6 4D 31 00 00 4C 21 C2 48 39 CA 77 19 0F 85 A7 08 00 00 48 BA FF FF FF FF 09 5B C1 38 49 39 D2 0F 86 94 08 00 00 31 FF 31 ED 45 31 E4 45 31 ED 41 BE 00 C0 FF FF C7 44 24 7C 00 00 00 00 66 89 7C 24 7A 66 89 6C 24 70 66 44 89 64 24 72 66 44 89 6C 24 74 66 44 89 74 24 76 E9 8B FE FF FF 41 81 F9 88 EC FF FF 0F 8C 13 06 00 00 4D 63 C9 48 8D 0D ?? ?? ?? ?? 49 81 C1 79 13 00 00 4D 89 CA 49 C1 E2 04 4C 01 D1 4C 8D 15 ?? ?? ?? ?? 4F 8D 14 8A 49 C1 E1 05 45 8B 12 4C 8B 19 48 8B 49 08 45 29 C2 48 3B 4C 24 10 44 89 54 24 1C 77 10 49 39 D3 72 2B 48 3B 4C 24 10 75 24 0F 1F 40 00 48 8D 0D ?? ?? ?? ?? 4C 01 C9 4C 8B 09 4C 8B 79 08 4C 8B 41 10 48 8B 49 18 EB 23 0F 1F 44 00 00 48 8D 0D ?? ?? ?? ?? 83 44 24 1C 01 4C 01 C9 4C 8B 09 4C 8B 79 08 4C 8B 41 10 48 8B 49 18 4D 89 CE 49 89 D3 45 89 C9 49 C1 EE 20 49 C1 EB 20 89 D2 4C 89 CF 4C 89 F3 4D 89 CA 49 0F AF FB 49 0F AF DB 4C 0F AF D2 48 89 5C 24 38 89 FB 49 C1 EA 20 4A 8D 34 13 4C 89 FB 45 89 FF 48 C1 EB 20 4D 89 FA 48 89 74 24 50 4C 89 FE 48 89 DD 49 0F AF F3 48 89 5C 24 40 4C 0F AF D2 49 89 F5 48 89 DE 49 0F AF F3 4C 89 6C 24 28 4D 89 D4 49 C1 EC 20 45 89 D2 4C 89 E3 48 89 74 24 48 8B 74 24 28 48 01 F3 48 89 EE 48 0F AF F2 48 8D 2C 33 49 89 EC 48 89 6C 24 58 49 C1 E4 20 4B 8D 2C 14 4D 89 C2 45 89 C0 49 C1 EA 20 4C 89 C6 4D 89 D5 4C 89 54 24 68 4D 89 C2 4D 0F AF D3 48 89 6C 24 60 4C 89 ED 48 0F AF F2 49 0F AF EB 45 89 D4 49 C1 EA 20 48 89 F3 48 C1 EE 20 4C 01 E6 4D 89 EC 4C 01 D5 4C 0F AF E2 89 DB 4C 01 E6 49 89 F2 49 C1 EA 20 49 01 EA 4C 89 54 24 30 49 89 CA 89 C9 48 89 CD 49 C1 EA 20 49 0F AF EB 4C 89 54 24 20 4D 0F AF DA 49 89 EC 48 89 CD 48 0F AF EA 45 89 E5 49 89 EA 48 C1 ED 20 49 01 ED 48 8B 6C 24 20 45 89 D2 48 0F AF EA 4C 01 ED 48 C1 EF 20 48 03 7C 24 38 49 0F AF D6 49 C1 EC 20 48 03 54 24 50 4D 01 E3 49 89 EC 49 C1 EC 20 48 C1 E5 20 4D 01 DC 4C 01 D5 4C 8B 54 24 28 4C 8B 5C 24 58 48 C1 EA 20 48 01 D7 48 03 7C 24 60 0F 92 C2 49 C1 EA 20 4C 03 54 24 48 48 C1 E6 20 49 C1 EB 20 0F B6 D2 48 01 DE 48 89 7C 24 38 48 01 D6 4D 01 DA 49 01 F2 4C 89 54 24 48 0F 82 36 03 00 00 48 39 F2 0F 87 2D 03 00 00 4C 8B 6C 24 30 31 D2 49 01 ED 0F 92 C2 48 8B 7C 24 10 49 8D 1C 14 4C 89 CE 48 8B 6C 24 40 48 89 5C 24 28 41 89 FA 48 89 FB 4C 89 F7 48 C1 EB 20 4D 0F AF CA 48 0F AF F3 4D 0F AF F2 4C 89 CA 45 89 C9 41 89 F3 48 C1 EA 20 4C 01 DA 49 01 D6 4C 89 F2 48 C1 E2 20 4C 01 CA 4D 89 F9 4D 0F AF FA 48 89 54 24 30 4C 0F AF CB 48 0F AF FB 4C 89 FA 45 89 FF 45 89 CB 48 C1 EA 20 4C 01 DA 49 89 EB 48 89 7C 24 10 4D 0F AF DA 48 89 EF 48 0F AF FB 4C 01 DA 49 89 D3 48 89 7C 24 40 49 C1 E3 20 4D 01 DF 4D 89 C3 4D 0F AF C2 4C 89 7C 24 50 4C 8B 7C 24 68 4C 0F AF DB 4C 89 FD 4C 89 C7 45 89 C0 45 89 DC 48 C1 EF 20 49 C1 EB 20 4C 01 E7 4D 89 FC 4D 0F AF E2 48 0F AF EB 4C 01 E7 4C 01 DD 49 89 FB 49 C1 EB 20 49 01 EB 48 89 CD 49 0F AF CA 48 0F AF EB 48 0F AF 5C 24 20 49 89 CF 89 C9 49 C1 EF 20 41 89 EC 48 C1 EE 20 4C 0F AF 54 24 20 48 03 74 24 10 4D 01 FC 48 C1 ED 20 4C 8B 7C 24 50 49 C1 EE 20 48 01 EB 4C 01 F6 4D 01 D4 4C 89 E5 49 C1 E4 20 48 C1 ED 20 49 01 CC 31 C9 48 01 EB 49 01 F7 0F 92 C1 49 C1 E9 20 4C 03 4C 24 40 48 C1 E7 20 48 C1 EA 20 4C 01 C7 48 01 CF 49 01 D1 49 01 F9 0F 82 A3 01 00 00 48 39 F9 0F 87 9A 01 00 00 31 ED 4D 01 DC 40 0F 92 C5 90 31 D2 48 01 EB 48 8B 7C 24 38 48 03 7C 24 30 4C 8B 54 24 48 0F 92 C2 49 01 D7 4D 01 FA 0F 82 3D 01 00 00 4C 39 FA 0F 87 34 01 00 00 4C 89 ED 31 D2 4C 01 CD 0F 92 C2 4A 8D 0C 22 4C 8B 64 24 28 49 01 CC 41 0F 92 C0 48 39 D1 40 0F 92 C6 41 09 F0 45 0F B6 C0 4C 89 E1 48 89 EF 48 C1 ED 2F 48 C1 E1 11 4C 01 C3 48 C1 E7 11 48 01 CD 8B 4C 24 1C 49 C1 EA 2F 48 C1 E3 11 49 C1 EC 2F 4C 01 D7 4C 01 E3 85 C9 0F 8E 35 03 00 00 49 89 DD 41 83 E5 01 48 8B 15 ?? ?? ?? ?? 48 8B 74 24 08 8B 12 8D 0C 95 00 00 00 00 8D 34 71 48 8D 0D ?? ?? ?? ?? 4C 01 EE 48 C1 E6 04 48 01 CE 48 3B 6E 08 0F 87 1B 01 00 00 0F 84 06 01 00 00 81 7C 24 1C FE 7F 00 00 0F 8E 97 01 00 00 48 8B 0D ?? ?? ?? ?? 83 09 28 83 FA 03 74 18 83 7C 24 08 01 19 C9 83 C1 02 39 D1 0F 85 91 F9 FF FF 66 0F 1F 44 00 00 BA FF FF FF FF 45 31 E4 41 BD FF FF FF FF 66 89 54 24 76 0F B7 54 24 08 41 BE FF FF FF FF 41 BF FF FF FF FF C7 44 24 7C 00 00 00 00 66 44 89 64 24 7A 66 44 89 6C 24 70 66 44 89 74 24 72 66 44 89 7C 24 74 C1 E2 0F 66 81 C2 FE 7F 66 89 54 24 78 DB 6C 24 70 DB 38 E9 D8 F9 FF FF 0F 1F 40 00 49 83 C1 01 4C 89 ED 4C 01 CD 0F 82 D1 00 00 00 4D 85 C9 0F 84 C8 00 00 00 45 31 C0 4C 03 64 24 28 41 0F 92 C0 E9 CB FE FF FF 66 0F 1F 44 00 00 49 8D 4C 24 01 49 01 CB 40 0F 92 C5 48 85 C9 4D 89 DC 0F 94 C2 09 D5 40 0F B6 ED E9 50 FE FF FF 4C 8B 6C 24 30 48 83 C5 01 49 01 ED 0F 92 C2 48 85 ED 41 0F 94 C2 44 09 D2 0F B6 D2 E9 BF FC FF FF 48 3B 3E 0F 86 F1 FE FF FF 66 0F 1F 44 00 00 48 83 C3 01 0F 85 59 01 00 00 83 44 24 1C 01 8B 5C 24 1C 81 FB FE 7F 00 00 0F 8F DA FE FF FF BB 00 80 FF FF 31 C9 45 31 C0 45 31 C9 E9 8B 01 00 00 48 8B 54 24 10 44 89 C1 4C 89 D3 48 D3 E2 B9 40 00 00 00 44 29 C1 48 D3 EB 44 89 C1 48 8D 3C 13 4C 89 D2 48 D3 E2 48 89 7C 24 10 E9 0F F8 FF FF BA 01 00 00 00 E9 EC FD FF FF 0F 1F 44 00 00 45 31 C9 4C 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E9 01 FA FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 85 DB 0F 88 87 03 00 00 48 85 ED 0F 84 9E 01 00 00 4C 8B 15 ?? ?? ?? ?? 49 89 D8 48 89 D9 41 81 E0 00 00 FF FF 48 C1 E1 10 41 89 D9 49 C1 E8 10 48 C1 E9 30 48 C1 EB 30 41 8B 12 83 CA 30 41 89 12 31 D2 66 89 4C 24 74 0F B7 4C 24 08 45 31 D2 C7 44 24 7C 00 00 00 00 66 44 89 54 24 7A 66 44 89 4C 24 70 66 44 89 44 24 72 66 89 5C 24 76 C1 E1 0F 01 CA 66 89 54 24 78 DB 6C 24 70 DB 38 E9 3F F8 FF FF 48 B9 FF FF FF FF 63 8E 8D 37 49 39 CA 0F 87 E6 F7 FF FF 41 B8 01 00 00 00 49 BB 00 03 21 32 01 21 01 00 48 B9 C0 84 8C 8C 08 CC 00 00 48 BE 00 07 0D 0E 09 0D 01 00 48 BB C0 80 A0 B0 00 E0 00 00 45 31 F6 BF 08 00 00 00 E9 E4 F6 FF FF 48 B9 00 00 00 00 00 00 00 80 48 39 CB 0F 85 75 FD FF FF 83 7C 24 1C 01 0F 85 6A FD FF FF 48 B9 FF FF FF FF FF FF FF BF 48 39 CD 0F 87 FC 00 00 00 F6 C2 03 0F 85 F3 00 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 10 BB 00 80 FF FF 31 C9 45 31 C0 45 31 C9 C7 44 24 1C 01 00 00 00 48 85 ED 75 05 48 85 FF 74 0A 48 8B 15 ?? ?? ?? ?? 83 0A 20 0F B7 54 24 1C E9 FA FE FF FF 66 0F 1F 44 00 00 BA 01 00 00 00 2B 54 24 1C 83 FA 42 0F 8F 7E 00 00 00 83 FA 3F 0F 8F 11 02 00 00 44 8B 4C 24 1C 48 89 DE 41 83 C1 3F 44 89 C9 48 D3 E6 89 D1 48 D3 EB 49 89 DD 41 83 E5 01 49 89 E8 44 89 C9 C7 44 24 1C 01 00 00 00 49 D3 E0 89 D1 48 D3 EF 48 D3 ED 4C 01 C7 48 01 F5 E9 75 FC FF FF 0F 1F 00 48 85 FF 0F 85 59 FE FF FF 49 89 D8 48 89 D9 41 89 D9 41 81 E0 00 00 FF FF 48 C1 E1 10 48 C1 EB 30 49 C1 E8 10 48 C1 E9 30 31 D2 E9 64 FE FF FF 41 B9 3E 00 00 00 BA 02 00 00 00 48 89 EF 45 31 ED 48 89 DD 31 F6 31 DB EB 8F 66 0F 1F 44 00 00 03 54 24 08 83 FA 02 0F 85 0A FF FF FF 48 85 ED 0F 89 F7 FE FF FF E9 FC FE FF FF 49 C1 EA 2E 49 C1 E0 12 48 B9 00 00 00 00 00 00 00 C0 4B 8D 14 02 31 F6 C7 44 24 7C 00 00 00 00 66 89 74 24 7A 48 C1 EA 02 66 89 54 24 70 48 01 CA 48 89 D1 48 C1 E9 10 66 89 4C 24 72 48 89 D1 48 C1 EA 30 48 C1 E9 20 66 89 54 24 76 66 89 4C 24 74 E9 D9 F5 FF FF 4D 85 D2 0F 84 03 F6 FF FF 48 B9 00 00 00 00 FF FF FF FF 45 89 D0 49 BB FF FF 00 00 FF FF 00 00 4C 21 D1 49 39 C8 48 B9 00 00 FF FF 00 00 FF FF 45 19 C0 4C 21 D1 4D 21 D3 41 F7 D0 41 83 E0 20 49 39 CB 49 BB FF 00 FF 00 FF 00 FF 00 19 C9 4D 21 D3 F7 D1 83 E1 10 41 01 C8 48 B9 00 FF 00 FF 00 FF 00 FF 4C 21 D1 49 39 CB 49 BB 0F 0F 0F 0F 0F 0F 0F 0F 19 C9 4D 21 D3 F7 D1 83 E1 08 41 01 C8 48 B9 F0 F0 F0 F0 F0 F0 F0 F0 4C 21 D1 49 39 CB 49 BB 33 33 33 33 33 33 33 33 19 C9 4D 21 D3 F7 D1 83 E1 04 41 01 C8 48 B9 CC CC CC CC CC CC CC CC 4C 21 D1 49 39 CB 49 BB AA AA AA AA AA AA AA AA 19 C9 4D 21 D3 F7 D1 83 E1 02 44 01 C1 49 B8 55 55 55 55 55 55 55 55 4D 21 D0 4D 39 C3 41 0F 96 C0 45 0F B6 C0 44 01 C1 44 8D 41 31 41 83 F8 3F 0F 8E 37 FC FF FF 83 E9 0F 48 D3 E2 48 89 54 24 10 31 D2 E9 64 F4 FF FF 8B 7C 24 1C BA C1 FF FF FF 44 8D 4F 7F 29 FA E9 5B FE FF FF 49 89 D8 48 89 D9 41 89 D9 41 81 E0 00 00 FF FF 48 C1 E1 10 48 C1 EB 30 49 C1 E8 10 48 C1 E9 30 E9 77 FD FF FF 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_9_0 {
	meta:
		name = "__bid32_to_binary128"
		size = 1568
		refs = "00ed .rdata 02c8 .refptr.__bid_IDEC_glbround 0328 .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 38 48 89 C8 89 D1 41 89 D3 81 E1 00 00 00 60 41 C1 EB 1F 81 F9 00 00 00 60 0F 84 D7 03 00 00 41 89 D0 41 81 E0 FF FF 7F 00 0F 84 32 03 00 00 89 D1 44 0F B7 CA 45 89 C0 81 E1 00 00 7F 00 41 39 C9 41 89 D1 89 D1 45 19 D2 41 81 E1 FF 00 7F 00 81 E1 00 FF 00 00 41 F7 D2 41 83 E2 10 41 39 C9 41 89 D1 19 C9 41 81 E1 0F 0F 0F 00 F7 D1 83 E1 08 41 01 CA 89 D1 81 E1 F0 F0 70 00 41 39 C9 41 89 D1 19 C9 41 81 E1 33 33 33 00 F7 D1 83 E1 04 41 01 CA 89 D1 81 E1 CC CC 4C 00 41 39 C9 41 89 D1 19 C9 41 C1 E9 17 F7 D1 45 0F B6 C9 83 E1 02 41 83 E9 65 44 01 D1 41 89 D2 81 E2 AA AA 2A 00 41 81 E2 55 55 55 00 41 39 D2 0F 93 C2 0F B6 D2 01 CA 8D 4A F8 83 C2 51 49 D3 E0 48 8D 0D ?? ?? ?? ?? 4D 63 C9 49 C1 E0 1B 49 81 C1 88 13 00 00 42 8B 1C 89 48 8D 0D ?? ?? ?? ?? 29 D3 4C 89 CA 48 C1 E2 04 4C 3B 44 11 08 0F 86 F6 03 00 00 48 8D 15 ?? ?? ?? ?? 49 C1 E1 05 4C 89 C1 83 C3 01 48 C1 E9 20 45 89 C0 49 01 D1 49 8B 39 49 8B 71 08 4D 8B 51 10 49 8B 51 18 41 89 F9 49 89 FF 48 89 F5 4D 89 CD 49 C1 EF 20 89 F6 4C 0F AF E9 48 C1 ED 20 4D 89 D6 4D 0F AF C8 49 C1 EE 20 45 89 D2 4C 89 7C 24 08 48 89 D7 89 D2 48 C1 EF 20 4D 89 EC 4D 89 FD 4C 89 24 24 44 8B 24 24 49 C1 E9 20 4C 0F AF E9 4D 01 E1 4C 89 4C 24 20 49 89 F1 4C 89 6C 24 10 4C 0F AF C9 49 0F AF F0 4D 89 CD 49 89 E9 4C 0F AF C9 45 89 EC 49 0F AF E8 4C 89 4C 24 18 49 89 F1 89 F6 49 C1 E9 20 4D 01 E1 49 01 E9 4C 89 CD 48 C1 E5 20 48 01 EE 4C 89 D5 48 89 74 24 28 4C 89 F6 48 0F AF F1 4D 0F AF D0 48 0F AF E9 49 89 F4 4C 89 D6 45 89 D2 4D 0F AF F0 41 89 EF 48 C1 EE 20 4C 01 FE 48 C1 ED 20 49 01 EC 4C 01 F6 48 89 F5 48 C1 ED 20 49 01 EC 48 89 D5 49 0F AF D0 48 0F AF E9 48 0F AF CF 49 89 D6 89 D2 41 89 EF 49 C1 EE 20 4D 01 FE 48 C1 ED 20 49 0F AF F8 48 01 E9 4C 0F AF 44 24 08 49 01 FE 4C 89 F5 49 C1 E6 20 4C 03 44 24 20 49 01 D6 48 8B 14 24 48 C1 ED 20 48 01 E9 48 C1 EA 20 48 03 54 24 10 49 C1 E8 20 4C 01 C2 45 31 C0 48 03 54 24 28 41 0F 92 C0 49 C1 ED 20 4C 03 6C 24 18 48 C1 E6 20 49 C1 E9 20 49 01 F2 4D 01 C2 4D 01 E9 4D 01 D1 0F 82 EB 00 00 00 4D 39 D0 0F 87 E2 00 00 00 31 ED 4D 01 F4 40 0F 92 C5 48 01 CD 85 DB 0F 8E E6 00 00 00 48 8B 0D ?? ?? ?? ?? 4D 89 E2 41 83 E2 01 8B 09 44 8D 04 8D 00 00 00 00 47 8D 04 58 4D 01 D0 4C 8D 15 ?? ?? ?? ?? 49 C1 E0 04 4D 01 D0 4D 39 48 08 0F 83 94 01 00 00 49 83 C4 01 75 17 48 83 C5 01 49 B8 00 00 00 00 00 00 02 00 4C 39 C5 0F 84 D8 02 00 00 81 FB FE 7F 00 00 0F 8E 7F 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 83 F9 03 0F 84 28 02 00 00 41 83 FB 01 19 D2 83 C2 02 39 CA 0F 84 17 02 00 00 4D 63 DB 48 BA 00 00 00 00 00 00 FF 7F 48 C7 00 00 00 00 00 49 C1 E3 3F 49 01 D3 4C 89 58 08 EB 18 66 0F 1F 44 00 00 4D 63 DB 48 C7 00 00 00 00 00 49 C1 E3 3F 4C 89 58 08 48 83 C4 38 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 49 83 C6 01 31 ED 4D 01 F4 40 0F 92 C5 48 01 CD 85 DB 0F 8F 1A FF FF FF 41 B8 01 00 00 00 41 29 D8 41 83 F8 73 0F 8E C6 01 00 00 BF 0D 00 00 00 41 B8 33 00 00 00 49 89 EA 31 DB 31 ED 4C 89 E6 89 F9 48 D3 E6 44 89 C1 49 D3 E9 89 F9 49 8D 14 31 4C 89 D6 48 D3 E6 44 89 C1 49 D3 EC 49 D3 EA 4D 8D 0C 34 4D 8D 24 1A BB 01 00 00 00 E9 C0 FE FF FF 89 D1 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 84 0A 01 00 00 41 89 D1 81 E2 FF FF 1F 00 41 C1 E9 15 4C 8D 82 00 00 80 00 BA 59 00 00 00 45 0F B6 C9 41 83 E9 65 49 81 F8 7F 96 98 00 0F 86 A3 FC FF FF 4D 63 C9 48 8D 15 ?? ?? ?? ?? 45 31 C0 49 81 C1 88 13 00 00 31 C9 42 8B 1C 8A 83 EB 59 48 8D 15 ?? ?? ?? ?? 49 C1 E1 05 49 01 D1 49 8B 39 49 8B 71 08 4D 8B 51 10 49 8B 51 18 E9 C2 FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 0F 85 83 FE FF FF 49 39 10 0F 83 7A FE FF FF E9 58 FE FF FF 48 B9 FF FF FF FF FF FF 00 00 48 39 CD 76 3D 48 21 CD 4D 85 C9 74 27 48 8B 15 ?? ?? ?? ?? 83 0A 20 48 C1 E3 30 4D 63 DB 48 01 EB 4C 89 20 49 C1 E3 3F 4C 01 DB 48 89 58 08 E9 A0 FE FF FF 48 85 D2 75 D4 EB DC 0F 1F 80 00 00 00 00 4D 85 C9 75 05 48 85 D2 74 16 48 8B 0D ?? ?? ?? ?? 8B 11 83 CA 30 89 11 0F 1F 84 00 00 00 00 00 31 DB EB B5 4C 89 C1 45 89 C0 48 C1 E9 20 E9 41 FF FF FF 89 D1 81 E1 00 00 00 7C 81 F9 00 00 00 7C 74 7D 4D 63 DB 48 B9 00 00 00 00 00 00 FF 7F 48 C7 00 00 00 00 00 49 C1 E3 3F 49 8D 14 0B 48 89 50 08 E9 2A FE FF FF 0F 1F 84 00 00 00 00 00 4D 63 DB 48 BA FF FF FF FF FF FF FE 7F 48 C7 00 FF FF FF FF 49 C1 E3 3F 49 01 D3 4C 89 58 08 E9 FE FD FF FF 41 83 F8 3F 7F 7D 8D 7B 3F 48 89 EB 4D 89 E2 4D 89 CC 49 89 D1 89 F9 48 D3 E3 44 89 C1 48 D3 ED E9 27 FE FF FF 0F 1F 80 00 00 00 00 F7 C2 00 00 00 02 74 0A 48 8B 0D ?? ?? ?? ?? 83 09 01 48 C1 E2 2C 48 B9 00 00 00 00 00 80 FF 7F 4D 63 DB 48 C1 EA 11 49 C1 E3 3F 48 C7 00 00 00 00 00 48 01 CA 4C 01 DA 48 89 50 08 E9 91 FD FF FF 83 C3 01 31 ED 81 FB FE 7F 00 00 0F 8E B4 FE FF FF E9 1E FD FF FF 41 B8 C1 FF FF FF 8D 7B 7F 41 29 D8 E9 B1 FD FF FF 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_10_0 {
	meta:
		name = "__bid64_to_binary128"
		size = 2336
		refs = "0174 .rdata 0580 .refptr.__bid_IDEC_glbround 05cf .refptr.__bid_IDEC_glbflags"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 48 89 C8 49 89 D0 48 B9 00 00 00 00 00 00 00 60 48 89 D6 49 21 C8 48 C1 EE 3F 49 39 C8 48 89 74 24 10 0F 84 D8 01 00 00 48 B9 FF FF FF FF FF FF 1F 00 48 21 D1 49 89 C8 0F 84 95 01 00 00 48 B9 00 00 00 00 FF FF 1F 00 41 89 D1 49 BA 55 55 55 55 55 55 15 00 48 21 D1 49 39 C9 48 B9 00 00 FF FF 00 00 1F 00 49 B9 FF FF 00 00 FF FF 00 00 45 19 DB 48 21 D1 49 21 D1 41 F7 D3 41 83 E3 20 49 39 C9 49 B9 FF 00 FF 00 FF 00 1F 00 19 C9 49 21 D1 F7 D1 83 E1 10 41 01 CB 48 B9 00 FF 00 FF 00 FF 00 00 48 21 D1 49 39 C9 49 B9 0F 0F 0F 0F 0F 0F 0F 00 19 C9 49 21 D1 F7 D1 83 E1 08 41 01 CB 48 B9 F0 F0 F0 F0 F0 F0 10 00 48 21 D1 49 39 C9 49 B9 33 33 33 33 33 33 13 00 19 C9 49 21 D1 F7 D1 83 E1 04 41 01 CB 48 B9 CC CC CC CC CC CC 0C 00 48 21 D1 49 39 C9 49 89 D1 19 C9 49 C1 E9 35 F7 D1 41 81 E1 FF 03 00 00 83 E1 02 41 81 E9 8E 01 00 00 44 01 D9 49 BB AA AA AA AA AA AA 0A 00 49 21 D3 4C 21 D2 49 39 D3 4C 89 C2 41 0F 96 C3 45 0F B6 DB 41 01 CB 41 8D 4B F6 41 83 C3 31 48 D3 E2 48 89 D6 48 89 D3 48 C1 EA 23 48 C1 E6 3D 48 C1 EB 03 48 89 F1 41 89 D8 48 C1 E9 20 4D 63 C9 4C 8D 15 ?? ?? ?? ?? 49 81 C1 88 13 00 00 4C 89 CF 48 C1 E7 04 49 01 FA 48 8D 3D ?? ?? ?? ?? 49 8B 2A 4D 8B 52 08 42 8B 3C 8F 44 29 DF 49 39 DA 89 3C 24 0F 87 16 00 00 00 48 39 F5 0F 82 FD 00 00 00 49 39 DA 0F 85 F4 00 00 00 0F 1F 40 00 4C 8D 15 ?? ?? ?? ?? 49 C1 E1 05 4B 8D 1C 11 4C 8B 0B 4C 8B 53 08 4C 8B 5B 10 4C 8B 6B 18 E9 EE 00 00 00 48 8B 54 24 10 48 C7 00 00 00 00 00 48 C1 E2 3F 48 89 50 08 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 84 00 00 00 00 00 48 B9 00 00 00 00 00 00 00 78 49 89 D0 49 21 C8 49 39 C8 0F 84 A7 05 00 00 49 89 D1 48 B9 FF FF FF FF FF FF 07 00 48 21 CA 49 C1 E9 33 48 B9 00 00 00 00 00 00 20 00 41 81 E1 FF 03 00 00 48 01 CA 48 B9 FF FF C0 6F F2 86 23 00 41 81 E9 8E 01 00 00 48 39 CA 76 19 45 31 C0 31 D2 31 C9 41 BB 3B 00 00 00 31 F6 31 DB E9 F1 FE FF FF 0F 1F 00 48 89 D6 48 89 D3 41 BB 3B 00 00 00 48 C1 E6 3D 48 C1 EB 03 48 C1 EA 23 48 89 F1 41 89 D8 48 C1 E9 20 E9 C7 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8D 1D ?? ?? ?? ?? 49 C1 E1 05 83 04 24 01 4C 01 CB 4C 8B 0B 4C 8B 53 08 4C 8B 5B 10 4C 8B 6B 18 4D 89 D6 45 89 D2 4C 89 CE 49 C1 EE 20 4D 89 D4 48 C1 EE 20 4C 0F AF E1 4C 89 F3 48 89 F5 48 0F AF D9 45 89 C9 48 0F AF E9 4C 89 E7 48 89 5C 24 30 48 C1 E7 20 4C 89 DB 48 C1 EB 20 48 89 7C 24 38 44 89 DF 49 89 DF 48 89 5C 24 40 48 89 FB 48 0F AF D9 4D 89 FB 48 89 6C 24 28 4C 0F AF D9 49 89 DF 49 C1 EF 20 4D 01 FB 4D 89 EF 45 89 ED 4C 89 5C 24 20 4D 89 EB 49 C1 EF 20 4C 0F AF D9 4C 89 7C 24 18 4C 0F AF F9 49 0F AF C9 4C 89 DD 49 C1 E3 20 48 C1 ED 20 49 01 EF 48 8B 6C 24 28 48 C1 E9 20 4C 89 7C 24 48 48 01 CD 48 03 6C 24 38 0F 92 C1 49 C1 EC 20 4C 03 64 24 30 48 C1 E3 20 0F B6 C9 48 89 6C 24 38 48 01 CB 49 01 DC 4C 89 64 24 30 0F 82 76 02 00 00 48 39 D9 0F 87 6D 02 00 00 4C 03 5C 24 20 48 89 F3 41 0F 92 C7 4C 89 5C 24 20 4D 89 CB 4D 0F AF C8 45 0F B6 FF 4C 03 7C 24 48 4C 0F AF DA 49 0F AF F0 4C 89 C9 45 89 C9 4C 89 7C 24 28 48 C1 E9 20 45 89 DC 4C 8B 7C 24 40 49 01 CC 49 01 F4 48 0F AF DA 4C 89 E1 4C 89 FE 48 C1 E1 20 4C 01 C9 48 89 4C 24 50 4C 89 F1 48 0F AF CA 48 89 5C 24 48 4C 89 D3 4D 0F AF D0 48 0F AF DA 48 89 4C 24 58 4C 89 D1 45 89 D2 4D 0F AF F0 41 89 D9 48 C1 E9 20 4C 01 C9 48 0F AF F2 4C 01 F1 49 89 C9 49 C1 E1 20 4F 8D 34 11 49 89 FA 4C 0F AF D2 49 0F AF F8 44 89 D5 49 C1 EA 20 49 89 F9 48 C1 EF 20 4C 01 D6 48 01 EF 4C 89 FD 4D 89 EA 49 0F AF E8 45 89 C9 4D 0F AF E8 4C 0F AF D2 48 0F AF 54 24 18 48 01 EF 49 89 FF 49 C1 EF 20 44 89 D5 49 01 F7 4C 89 EE 45 89 ED 48 C1 EE 20 48 01 EE 49 C1 EB 20 4C 03 5C 24 48 4C 0F AF 44 24 18 49 C1 EA 20 49 C1 EC 20 4C 01 D2 4D 01 E3 4C 01 C6 45 31 C0 49 89 F2 48 C1 E6 20 49 C1 EA 20 49 01 F5 4C 01 D2 4D 01 DE 41 0F 92 C0 48 C1 EB 20 48 03 5C 24 58 48 C1 E7 20 48 C1 E9 20 4C 01 CF 4C 01 C7 48 01 CB 48 01 FB 0F 82 5A 01 00 00 49 39 F8 0F 87 51 01 00 00 45 31 D2 4D 01 EF 41 0F 92 C2 31 C9 4C 01 D2 48 8B 74 24 50 48 03 74 24 38 4C 8B 64 24 30 0F 92 C1 49 01 CE 4D 01 F4 0F 82 F4 00 00 00 4C 39 F1 0F 87 EB 00 00 00 4C 8B 5C 24 20 31 C9 49 01 DB 0F 92 C1 4E 8D 2C 39 4C 8B 7C 24 28 4D 01 EF 41 0F 92 C1 49 39 CD 0F 92 C1 41 09 C9 45 0F B6 C9 8B 0C 24 4C 01 CA 85 C9 0F 8E C3 01 00 00 48 8B 0D ?? ?? ?? ?? 48 8B 5C 24 10 4D 89 F8 41 83 E0 01 8B 09 44 8D 0C 8D 00 00 00 00 45 8D 0C 59 4D 01 C1 4C 8D 05 ?? ?? ?? ?? 49 C1 E1 04 4D 01 C1 4D 39 59 08 0F 82 D7 00 00 00 0F 84 C1 00 00 00 81 3C 24 FE 7F 00 00 0F 8E 14 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 83 F9 03 0F 84 31 02 00 00 83 7C 24 10 01 19 D2 83 C2 02 39 CA 0F 84 1F 02 00 00 48 8B 4C 24 10 48 BA 00 00 00 00 00 00 FF 7F 48 C7 00 00 00 00 00 48 C1 E1 3F 48 01 CA 48 89 50 08 E9 E0 FB FF FF 66 0F 1F 84 00 00 00 00 00 49 83 C3 01 E9 8A FD FF FF 0F 1F 80 00 00 00 00 4C 8B 5C 24 20 48 83 C3 01 49 01 DB 0F 82 8E 00 00 00 48 85 DB 0F 84 85 00 00 00 45 31 C9 4C 03 7C 24 28 41 0F 92 C1 E9 13 FF FF FF 0F 1F 40 00 49 83 C5 01 4D 01 EF 41 0F 92 C2 4D 85 ED 0F 94 C1 41 09 CA 45 0F B6 D2 E9 9C FE FF FF 0F 1F 00 4D 39 21 0F 83 36 FF FF FF 0F 1F 80 00 00 00 00 49 83 C7 01 0F 85 25 FF FF FF 48 83 C2 01 49 B8 00 00 00 00 00 00 02 00 4C 39 C2 0F 85 0E FF FF FF 83 04 24 01 31 D2 8B 34 24 81 FE FE 7F 00 00 7E 34 E9 05 FF FF FF 66 0F 1F 84 00 00 00 00 00 B9 01 00 00 00 E9 78 FE FF FF 66 0F 1F 44 00 00 48 B9 FF FF FF FF FF FF 00 00 48 39 CA 0F 86 AD 00 00 00 48 21 CA 4D 85 DB 74 35 48 8B 0D ?? ?? ?? ?? 83 09 20 4C 8B 0C 24 49 C1 E1 30 4C 01 CA 4C 8B 4C 24 10 4C 89 38 49 C1 E1 3F 4C 01 CA 48 89 50 08 E9 CF FA FF FF 0F 1F 84 00 00 00 00 00 4D 85 E4 75 C6 EB CE 66 0F 1F 84 00 00 00 00 00 41 B8 01 00 00 00 44 2B 04 24 41 83 F8 73 0F 8E EC 00 00 00 41 BA 0D 00 00 00 41 B8 33 00 00 00 49 89 D1 31 ED 31 D2 4C 89 FE 44 89 D1 4C 89 CB 48 D3 E6 44 89 C1 C7 04 24 01 00 00 00 49 D3 EB 44 89 D1 48 D3 E3 44 89 C1 4D 8D 24 33 49 D3 EF 49 D3 E9 4D 8D 1C 1F 4D 8D 3C 29 E9 DD FD FF FF 4D 85 DB 75 05 4D 85 E4 74 16 4C 8B 05 ?? ?? ?? ?? 41 8B 08 83 C9 30 41 89 08 66 0F 1F 44 00 00 45 31 C9 E9 45 FF FF FF 0F 1F 84 00 00 00 00 00 48 B9 00 00 00 00 00 00 00 7C 49 89 D0 49 21 C8 49 39 C8 0F 84 87 00 00 00 48 89 F1 48 BA 00 00 00 00 00 00 FF 7F 48 C7 00 00 00 00 00 48 C1 E1 3F 48 01 CA 48 89 50 08 E9 EA F9 FF FF 0F 1F 00 48 8B 4C 24 10 48 BA FF FF FF FF FF FF FE 7F 48 C7 00 FF FF FF FF 48 C1 E1 3F 48 01 CA 48 89 50 08 E9 C1 F9 FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 83 F8 3F 0F 8F B4 00 00 00 44 8B 14 24 48 89 D5 4D 89 F9 4D 89 DF 4D 89 E3 41 83 C2 3F 44 89 D1 48 D3 E5 44 89 C1 48 D3 EA E9 F8 FE FF FF 90 48 B9 00 00 00 00 00 00 00 02 48 85 CA 74 0A 48 8B 0D ?? ?? ?? ?? 83 09 01 48 B9 FF FF FF FF FF FF 03 00 49 B8 FF 7F C6 A4 7E 8D 03 00 48 21 D1 4C 39 C1 77 41 48 8B 4C 24 10 49 89 D1 48 C1 E2 0E 48 C1 EA 11 49 B8 00 00 00 00 00 80 00 00 49 C1 E1 3D 4C 01 C2 48 C1 E1 3F 48 01 D1 48 BA 00 00 00 00 00 00 FF 7F 4C 89 08 48 01 CA 48 89 50 08 E9 11 F9 FF FF 48 8B 4C 24 10 45 31 C9 48 BA 00 00 00 00 00 80 00 00 48 C1 E1 3F EB CC 8B 1C 24 41 B8 C1 FF FF FF 44 8D 53 7F 41 29 D8 E9 4D FE FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_11_0 {
	meta:
		name = "__bid128_to_binary128"
		size = 3056
		refs = "0189 .refptr.__bid_IDEC_glbflags 0193 .refptr.__bid_IDEC_glbround 02b3 .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 78 4C 8B 02 48 8B 52 08 48 89 C8 48 B9 00 00 00 00 00 00 00 60 49 89 D1 48 89 D7 49 21 C9 48 C1 EF 3F 49 39 C9 48 89 7C 24 10 0F 84 A1 01 00 00 49 89 D1 49 BA FF FF FF FF FF FF 01 00 48 B9 C0 87 AD BE 09 ED 01 00 49 C1 E9 31 49 21 D2 41 81 E1 FF 3F 00 00 41 81 E9 20 18 00 00 49 39 CA 0F 87 81 01 00 00 0F 84 88 08 00 00 4D 85 D2 0F 84 4B 0A 00 00 48 B9 00 00 00 00 FF FF 01 00 41 89 D3 49 BC 00 00 FF FF 00 00 01 00 48 21 D1 49 BD FF FF 00 00 FF FF 00 00 48 BF 00 FF 00 FF 00 FF 00 00 48 BD FF 00 FF 00 FF 00 01 00 48 BB F0 F0 F0 F0 F0 F0 00 00 48 BE 0F 0F 0F 0F 0F 0F 01 00 49 21 D4 49 21 D5 48 21 D7 48 21 D5 48 21 D3 48 21 D6 4C 39 D9 48 B9 CC CC CC CC CC CC 00 00 0F 86 2C 01 00 00 49 BE 55 55 55 55 55 55 01 00 49 BB 33 33 33 33 33 33 01 00 49 BF AA AA AA AA AA AA 00 00 48 21 D1 49 21 D3 49 21 D7 4C 21 F2 45 31 F6 49 39 D7 41 0F 96 C6 31 D2 4D 39 E5 45 19 E4 41 F7 D4 41 83 E4 10 41 01 D4 48 39 FD 19 D2 F7 D2 83 E2 08 48 39 DE 41 8D 3C 14 19 D2 F7 D2 83 E2 04 49 39 CB 8D 1C 17 19 D2 F7 D2 83 E2 02 01 DA 41 8D 54 16 F1 85 D2 0F 85 16 07 00 00 4D 89 C3 49 C1 E0 02 49 C1 EB 3E 41 81 F9 44 13 00 00 0F 8E 1A 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 48 8B 15 ?? ?? ?? ?? 8B 0A 83 F9 03 0F 84 9F 05 00 00 83 7C 24 10 01 19 D2 83 C2 02 39 CA 0F 84 8D 05 00 00 48 8B 4C 24 10 48 BA 00 00 00 00 00 00 FF 7F 48 C7 00 00 00 00 00 48 C1 E1 3F 48 01 CA 48 89 50 08 EB 32 66 0F 1F 84 00 00 00 00 00 48 B9 00 00 00 00 00 00 00 78 49 89 D1 49 21 C9 49 39 C9 74 6B 48 8B 54 24 10 48 C7 00 00 00 00 00 48 C1 E2 3F 48 89 50 08 48 83 C4 78 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 49 BE 55 55 55 55 55 55 01 00 49 BB 33 33 33 33 33 33 01 00 49 BF AA AA AA AA AA AA 00 00 48 21 D1 49 21 D3 49 21 D7 4C 21 F2 45 31 F6 49 39 D7 BA 20 00 00 00 41 0F 96 C6 E9 CC FE FF FF 66 90 48 B9 00 00 00 00 00 00 00 7C 49 89 D1 49 21 C9 49 39 C9 0F 84 67 07 00 00 48 89 F9 48 BA 00 00 00 00 00 00 FF 7F 48 C7 00 00 00 00 00 48 C1 E1 3F 48 01 CA 48 89 50 08 E9 6C FF FF FF 0F 1F 00 41 81 F9 79 EC FF FF 0F 8C 03 06 00 00 4D 63 C9 48 8D 0D ?? ?? ?? ?? 49 81 C1 88 13 00 00 4C 89 CB 48 C1 E3 04 48 01 D9 48 8D 1D ?? ?? ?? ?? 4A 8D 1C 8B 49 C1 E1 05 4B 8D 3C 93 44 8B 13 4C 8B 19 48 89 7C 24 40 41 29 D2 48 3B 79 08 44 89 14 24 72 0D 75 2B 4D 39 C3 72 26 66 0F 1F 44 00 00 48 8D 15 ?? ?? ?? ?? 4C 01 CA 4C 8B 0A 4C 8B 52 08 48 8B 4A 10 48 8B 52 18 EB 22 0F 1F 44 00 00 48 8D 15 ?? ?? ?? ?? 83 04 24 01 4C 01 CA 4C 8B 0A 4C 8B 52 08 48 8B 4A 10 48 8B 52 18 4D 89 CF 4C 89 C3 45 89 C9 49 C1 EF 20 48 C1 EB 20 45 89 C0 4C 89 CD 4C 89 FE 4D 89 CB 48 0F AF EB 4D 89 D6 45 89 D2 48 0F AF F3 49 C1 EE 20 4D 0F AF D8 4D 89 F5 48 89 74 24 48 89 EE 49 C1 EB 20 4A 8D 3C 1E 4D 89 F3 4C 0F AF DB 48 89 7C 24 58 4C 89 D7 48 0F AF FB 4C 89 5C 24 50 4D 89 D3 4D 0F AF D8 48 89 7C 24 20 8B 7C 24 20 4D 0F AF E8 4C 89 DE 45 89 DB 48 C1 EE 20 48 01 FE 4C 01 EE 48 89 74 24 60 48 C1 E6 20 4E 8D 2C 1E 48 89 CE 89 C9 48 C1 EE 20 4C 89 6C 24 68 49 89 CD 48 89 74 24 28 4C 0F AF EB 49 89 F4 4C 0F AF E3 4D 89 EB 49 89 CD 4D 0F AF E8 4C 89 EE 45 89 DD 49 C1 EB 20 48 89 F7 4D 01 DC 49 89 D3 48 C1 EF 20 89 D2 49 C1 EB 20 4C 01 EF 4C 8B 6C 24 28 4C 89 5C 24 18 89 F6 4D 0F AF E8 4C 01 EF 49 89 FD 49 C1 ED 20 4D 01 EC 49 89 D5 4C 89 64 24 38 49 89 D4 4C 0F AF EB 4D 0F AF E0 49 0F AF DB 4C 89 6C 24 30 4D 89 E3 44 8B 64 24 30 4D 89 DD 45 89 DB 49 C1 ED 20 4D 01 EC 4D 89 E5 4C 8B 64 24 18 4D 0F AF E0 48 C1 ED 20 48 03 6C 24 48 4D 0F AF C7 4C 03 44 24 58 4D 01 EC 4C 8B 6C 24 30 49 C1 E8 20 49 C1 ED 20 4C 01 C5 4C 01 EB 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4D 01 DC 49 89 E8 49 01 DD 4C 03 44 24 68 4C 8B 5C 24 20 48 8B 5C 24 60 4C 89 44 24 48 41 0F 92 C0 49 C1 EB 20 4C 03 5C 24 50 48 C1 E7 20 48 C1 EB 20 48 01 F7 45 0F B6 C0 4C 01 C7 49 01 DB 49 01 FB 4C 89 5C 24 50 0F 82 D0 02 00 00 49 39 F8 0F 87 C7 02 00 00 4C 03 64 24 38 48 8B 7C 24 40 41 89 FB 0F 92 C3 4C 89 64 24 20 0F B6 DB 49 8D 74 1D 00 4C 89 FB 4C 8B 6C 24 28 4D 0F AF FB 48 89 74 24 30 48 89 FE 4C 89 CF 48 C1 EE 20 4D 0F AF CB 48 0F AF FE 48 0F AF DE 4D 89 C8 45 89 C9 49 C1 E8 20 48 89 5C 24 38 89 FB 49 01 D8 4D 01 C7 4D 89 F8 49 C1 E0 20 4D 01 C8 4D 89 D1 4C 89 44 24 40 4D 89 F0 4C 0F AF C6 4D 0F AF D3 4C 0F AF CE 4C 89 44 24 58 4D 89 D0 45 89 D2 4D 0F AF F3 44 89 CB 49 C1 E8 20 49 01 D8 4D 01 F0 4C 89 C3 48 C1 E3 20 4E 8D 34 13 48 89 CB 4D 89 EA 49 0F AF CB 48 0F AF DE 4C 0F AF D6 48 89 CD 89 C9 41 89 DC 48 C1 ED 20 48 C1 EB 20 4C 01 E5 4D 89 EC 49 01 DA 4D 0F AF E3 4C 01 E5 48 89 EB 48 C1 EB 20 4C 01 D3 49 89 D2 49 0F AF D3 4C 0F AF D6 48 0F AF 74 24 18 49 89 D4 89 D2 45 89 D5 49 C1 EC 20 4D 01 EC 48 C1 EF 20 48 03 7C 24 38 4C 0F AF 5C 24 18 49 C1 EA 20 49 C1 EF 20 4C 01 D6 4C 01 FF 4D 01 DC 4D 89 E2 49 C1 E4 20 49 C1 EA 20 4C 01 E2 4C 01 D6 45 31 D2 49 01 FE 41 0F 92 C2 49 C1 E9 20 4C 03 4C 24 58 48 C1 E5 20 49 C1 E8 20 48 01 CD 4C 01 D5 4D 01 C1 49 01 E9 0F 82 4A 01 00 00 49 39 EA 0F 87 41 01 00 00 45 31 D2 48 01 D3 41 0F 92 C2 0F 1F 80 00 00 00 00 49 01 F2 31 D2 48 8B 74 24 48 48 03 74 24 40 4C 8B 5C 24 50 0F 92 C2 49 01 D6 4D 01 F3 0F 82 DD 00 00 00 4C 39 F2 0F 87 D4 00 00 00 4C 8B 64 24 20 31 D2 4D 01 CC 0F 92 C2 4C 8B 6C 24 30 48 01 D3 49 01 DD 0F 92 C1 48 39 D3 0F 92 C2 09 D1 0F B6 C9 8B 14 24 48 63 F1 4C 01 D6 85 D2 0F 8E 7D 02 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 7C 24 10 4D 89 E8 41 83 E0 01 8B 12 8D 0C 95 00 00 00 00 8D 0C 79 4C 01 C1 4C 8D 05 ?? ?? ?? ?? 48 C1 E1 04 4C 01 C1 4C 39 61 08 0F 82 D3 00 00 00 0F 84 BD 00 00 00 81 3C 24 FE 7F 00 00 0F 8E B0 01 00 00 48 8B 0D ?? ?? ?? ?? 83 09 28 83 FA 03 74 12 83 7C 24 10 01 19 C9 83 C1 02 39 D1 0F 85 73 FA FF FF 48 8B 4C 24 10 48 BA FF FF FF FF FF FF FE 7F 48 C7 00 FF FF FF FF 48 C1 E1 3F 48 01 CA 48 89 50 08 E9 A2 FA FF FF 66 0F 1F 84 00 00 00 00 00 4C 8B 64 24 20 49 83 C1 01 4D 01 CC 0F 82 21 01 00 00 4D 85 C9 0F 84 18 01 00 00 4C 8B 6C 24 30 31 C9 49 01 DD 0F 92 C1 E9 25 FF FF FF 0F 1F 00 48 83 C2 01 48 01 D3 41 0F 92 C2 48 85 D2 0F 94 C2 41 09 D2 45 0F B6 D2 E9 B3 FE FF FF 0F 1F 00 49 83 C4 01 E9 30 FD FF FF 0F 1F 80 00 00 00 00 4C 39 19 0F 83 3A FF FF FF 0F 1F 80 00 00 00 00 49 83 C5 01 0F 85 29 FF FF FF 48 83 C6 01 48 B9 00 00 00 00 00 00 02 00 48 39 CE 0F 84 4F 02 00 00 48 B9 00 00 00 00 00 00 01 00 48 39 CE 0F 85 FF FE FF FF 83 3C 24 01 0F 85 F5 FE FF FF 48 B9 FF FF FF FF FF FF FF BF 49 39 CC 0F 87 39 02 00 00 F6 C2 03 0F 85 30 02 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 10 31 F6 C7 04 24 01 00 00 00 4D 85 E4 75 05 4D 85 DB 74 0A 48 8B 15 ?? ?? ?? ?? 83 0A 20 48 8B 14 24 48 C1 E2 30 48 01 D6 48 8B 54 24 10 4C 89 28 48 C1 E2 3F 48 01 D6 48 89 70 08 E9 85 F9 FF FF 89 D1 4C 89 C6 49 D3 E2 B9 40 00 00 00 29 D1 48 D3 EE 89 D1 49 01 F2 49 D3 E0 E9 CB F8 FF FF BA 01 00 00 00 E9 FC FD FF FF 0F 1F 00 45 31 C9 48 8D 1D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E9 11 FA FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 BA FF FF FF FF FF FF 00 00 48 39 D6 0F 87 ED 00 00 00 4D 85 E4 75 05 4D 85 DB 74 0E 48 8B 0D ?? ?? ?? ?? 8B 11 83 CA 30 89 11 31 D2 E9 67 FF FF FF 48 BA FF FF FF FF 63 8E 8D 37 49 39 D0 0F 87 E0 F8 FF FF 41 BE 01 00 00 00 49 BB 00 03 21 32 01 21 01 00 48 B9 C0 84 8C 8C 08 CC 00 00 48 BE 00 07 0D 0E 09 0D 01 00 48 BB C0 80 A0 B0 00 E0 00 00 45 31 E4 BA 08 00 00 00 E9 F4 F7 FF FF BA 01 00 00 00 2B 14 24 83 FA 73 7F 53 83 FA 3F 0F 8F 68 02 00 00 44 8B 04 24 49 89 F2 41 83 C0 3F 44 89 C1 49 D3 E2 89 D1 48 D3 EE 4D 89 E1 44 89 C1 4C 89 EB 49 D3 E1 89 D1 C7 04 24 01 00 00 00 49 D3 EB 44 89 C1 48 D3 E3 89 D1 4D 01 CB 49 D3 EC 49 D3 ED 49 01 DC 4D 01 D5 E9 23 FD FF FF 41 B8 0D 00 00 00 BA 33 00 00 00 4D 89 E3 45 31 D2 4D 89 EC 49 89 F5 31 F6 EB B1 0F 1F 44 00 00 48 21 D6 E9 75 FE FF FF 0F 1F 84 00 00 00 00 00 48 B9 00 00 00 00 00 00 00 02 48 85 CA 74 0A 48 8B 0D ?? ?? ?? ?? 83 09 01 48 B9 FF FF FF FF FF 3F 00 00 49 B9 93 8D 44 C6 4D 31 00 00 48 21 D1 4C 39 C9 77 11 75 6E 48 B9 FF FF FF FF 09 5B C1 38 49 39 C8 76 5F 48 8B 4C 24 10 48 BA 00 00 00 00 00 80 FF 7F 48 C7 00 00 00 00 00 48 C1 E1 3F 48 01 CA 48 89 50 08 E9 BD F7 FF FF 0F 1F 40 00 83 04 24 01 8B 34 24 81 FE FE 7F 00 00 0F 8F BD FC FF FF 31 F6 E9 E3 FD FF FF 03 54 24 10 83 FA 02 0F 85 CD FD FF FF 4D 85 E4 0F 89 BA FD FF FF E9 BF FD FF FF 4C 89 C1 48 C1 E2 12 49 C1 E0 12 48 C1 E9 2E 49 C1 E8 11 48 01 CA 48 89 D1 48 C1 EA 11 48 C1 E1 2F 4C 01 C1 48 89 08 48 B9 00 00 00 00 00 80 FF 7F 48 01 CA 48 8B 4C 24 10 48 C1 E1 3F 48 01 CA 48 89 50 08 E9 3B F7 FF FF 4D 85 C0 0F 84 1E F7 FF FF 48 BA 00 00 00 00 FF FF FF FF 44 89 C1 49 BB FF FF 00 00 FF FF 00 00 4C 21 C2 48 39 D1 48 BA 00 00 FF FF 00 00 FF FF 19 C9 4C 21 C2 4D 21 C3 F7 D1 83 E1 20 49 39 D3 49 BB FF 00 FF 00 FF 00 FF 00 19 D2 4D 21 C3 F7 D2 83 E2 10 01 D1 48 BA 00 FF 00 FF 00 FF 00 FF 4C 21 C2 49 39 D3 49 BB 0F 0F 0F 0F 0F 0F 0F 0F 19 D2 4D 21 C3 F7 D2 83 E2 08 01 D1 48 BA F0 F0 F0 F0 F0 F0 F0 F0 4C 21 C2 49 39 D3 49 BB 33 33 33 33 33 33 33 33 19 D2 4D 21 C3 F7 D2 83 E2 04 01 D1 48 BA CC CC CC CC CC CC CC CC 4C 21 C2 49 39 D3 49 BB AA AA AA AA AA AA AA AA 19 D2 4D 21 C3 F7 D2 83 E2 02 01 CA 48 B9 55 55 55 55 55 55 55 55 4C 21 C1 49 39 CB 0F 96 C1 0F B6 C9 01 D1 8D 51 31 83 FA 3F 0F 8E CA FC FF FF 4D 89 C2 83 E9 0F 45 31 C0 49 D3 E2 45 31 DB E9 AB F5 FF FF 8B 3C 24 BA C1 FF FF FF 44 8D 47 7F 29 FA E9 DA FD FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_12_0 {
	meta:
		name = "__binary32_to_bid32"
		size = 1680
		refs = "0101 .refptr.__bid_IDEC_glbflags 013a .rdata 0429 .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 38 66 0F 7E C1 66 41 0F 7E C1 41 89 C8 41 81 E1 FF FF 7F 00 4C 89 C0 49 C1 E8 1F 44 89 CA 48 C1 E8 17 0F B6 C0 85 C0 0F 85 94 01 00 00 45 85 C9 0F 84 7B 04 00 00 66 0F 7E C0 44 0F B7 C9 66 41 0F 7E C2 25 00 00 7F 00 41 39 C1 66 0F 7E C0 45 19 C9 41 81 E2 FF 00 7F 00 25 00 FF 00 00 41 F7 D1 41 83 E1 10 41 39 C2 66 41 0F 7E C2 19 C0 F7 D0 41 81 E2 0F 0F 0F 00 83 E0 08 41 01 C1 66 0F 7E C0 25 F0 F0 70 00 41 39 C2 66 41 0F 7E C2 19 C0 F7 D0 41 81 E2 33 33 33 00 83 E0 04 41 01 C1 66 0F 7E C0 25 CC CC 4C 00 41 39 C2 41 BA 59 00 00 00 19 C0 81 E1 AA AA 2A 00 F7 D0 83 E0 02 44 01 C8 66 41 0F 7E C1 41 81 E1 55 55 55 00 41 39 C9 41 0F 93 C1 45 0F B6 C9 41 01 C1 B8 73 FF FF FF 41 8D 49 F8 44 29 C8 44 8D 48 A7 48 D3 E2 48 8B 0D ?? ?? ?? ?? 48 C1 E2 19 83 09 02 31 C9 45 85 C9 0F 8F 4E 01 00 00 47 8D 1C 11 45 89 DA 41 F7 DA 45 85 D2 0F 8E C6 04 00 00 41 83 FA 30 0F 8F 31 01 00 00 4D 63 D2 48 8D 05 ?? ?? ?? ?? 83 C1 19 4C 89 D3 48 89 D6 48 C1 E3 04 48 D3 EE 48 01 D8 48 89 F1 48 3B 30 76 0B 48 83 78 08 00 0F 84 01 01 00 00 48 8D 05 ?? ?? ?? ?? 49 C1 E2 04 4A 8B 04 10 41 89 CA 48 C1 E9 20 4C 89 D2 41 89 C1 48 C1 E8 20 49 0F AF D1 49 0F AF C2 41 0F AF C9 49 89 D1 89 D2 49 C1 E9 20 4C 01 C9 48 01 C8 48 C1 E0 20 4C 8D 14 10 41 81 FA FF FF 7F 00 0F 87 99 04 00 00 41 8D 43 65 41 C1 E0 1F C1 E0 17 44 01 C0 44 01 D0 E9 01 03 00 00 66 0F 1F 44 00 00 3D FF 00 00 00 0F 84 15 03 00 00 48 81 C2 00 00 80 00 49 89 D1 49 F7 D9 49 21 D1 41 0F B7 C9 48 83 F9 01 4C 89 C9 45 19 D2 81 E1 FF 00 FF 00 41 83 E2 10 48 83 F9 01 19 C9 83 E1 08 41 01 CA 4C 89 C9 81 E1 0F 0F 0F 0F 48 83 F9 01 19 C9 83 E1 04 41 01 CA 4C 89 C9 81 E1 33 33 33 33 48 83 F9 01 19 C9 83 E1 02 44 01 D1 41 F7 C1 55 55 55 01 41 0F 94 C1 2D 96 00 00 00 48 C1 E2 19 45 0F B6 C9 44 01 C9 44 8D 48 A7 44 8D 51 59 45 85 C9 0F 8E B2 FE FF FF 48 8D 05 ?? ?? ?? ?? 4D 63 C9 48 8D 0D ?? ?? ?? ?? 49 81 C1 C2 01 00 00 46 8B 14 88 4C 89 C8 49 C1 E1 05 48 C1 E0 04 48 3B 54 01 08 0F 86 C9 02 00 00 48 8D 0D ?? ?? ?? ?? 41 83 C2 01 4C 01 C9 48 8B 01 48 8B 59 08 4C 8B 49 10 48 8B 49 18 48 89 C6 49 89 D3 89 C0 49 C1 EB 20 89 D2 48 89 C7 49 0F AF FB 48 89 DD 89 DB 48 0F AF C2 48 C1 ED 20 49 89 DD 48 0F AF DA 48 C1 EE 20 4D 89 CE 45 89 C9 49 89 F7 49 C1 EE 20 41 89 FC 4C 89 7C 24 08 48 89 CE 48 C1 E8 20 89 C9 48 C1 EE 20 4C 01 E0 48 89 44 24 20 48 89 E8 49 0F AF C3 4D 0F AF EB 48 0F AF EA 48 89 44 24 18 48 89 D8 89 DB 45 89 EC 48 C1 E8 20 4C 01 E0 4D 89 F4 48 01 E8 48 89 C5 48 C1 E5 20 48 01 EB 4C 89 CD 4C 0F AF CA 48 89 5C 24 28 4D 0F AF FB 49 0F AF EB 4C 89 CB 45 89 C9 4C 89 7C 24 10 48 C1 EB 20 4C 0F AF F2 41 89 EF 48 C1 ED 20 4D 0F AF E3 4C 01 FB 4C 01 F3 49 01 EC 48 89 DD 48 C1 ED 20 49 01 EC 48 89 CD 48 0F AF CA 49 0F AF EB 4C 0F AF DE 49 89 CE 89 C9 49 C1 EE 20 41 89 EF 48 C1 ED 20 48 0F AF F2 4D 01 FE 49 01 EB 48 C1 EF 20 49 01 F6 4C 89 F5 49 C1 E6 20 49 01 CE 48 8B 4C 24 10 48 C1 ED 20 49 01 EB 48 01 F9 48 8B 7C 24 08 48 0F AF FA 48 8B 54 24 28 48 03 7C 24 20 48 C1 EF 20 48 01 CF 48 01 FA 0F 92 C2 49 C1 ED 20 4C 03 6C 24 18 48 C1 E3 20 48 C1 E8 20 0F B6 D2 49 01 D9 49 01 D1 4C 01 E8 4C 01 C8 0F 82 9F 00 00 00 4C 39 CA 0F 87 96 00 00 00 31 D2 4D 01 E6 0F 92 C2 49 01 D3 48 8B 15 ?? ?? ?? ?? 4D 89 D9 41 83 E1 01 8B 0A 8D 14 8D 00 00 00 00 42 8D 14 42 4C 01 CA 4C 8D 0D ?? ?? ?? ?? 48 C1 E2 04 4C 01 CA 4C 8B 4A 08 4D 39 F1 0F 83 81 00 00 00 49 83 C3 01 49 81 FB 80 96 98 00 0F 84 70 01 00 00 41 81 FA BF 00 00 00 0F 8F 03 01 00 00 4D 85 F6 0F 85 AA 00 00 00 48 85 C0 0F 85 A1 00 00 00 41 C1 E0 1F 41 81 FB FF FF 7F 00 0F 86 20 01 00 00 43 8D 84 18 00 00 80 5F 41 C1 E2 15 44 01 D0 EB 1A 49 83 C6 01 E9 61 FF FF FF 66 0F 1F 44 00 00 41 C1 E0 1F 41 8D 80 00 00 80 32 48 83 C4 38 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 40 00 4D 39 CE 75 8B 48 3B 02 76 86 E9 70 FF FF FF 90 45 85 C9 0F 84 D7 00 00 00 81 E1 00 00 40 00 75 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 48 C1 E2 2A 41 C1 E0 1F B8 00 00 00 00 48 C1 EA 2C 48 81 FA 3F 42 0F 00 0F 47 D0 42 8D 84 02 00 00 00 7C EB 9B 48 8B 05 ?? ?? ?? ?? 8B 10 89 D1 83 C9 20 49 81 FB 3F 42 0F 00 89 08 0F 87 42 FF FF FF 83 CA 30 89 10 E9 38 FF FF FF 66 0F 1F 84 00 00 00 00 00 48 8D 0D ?? ?? ?? ?? 4C 01 C9 48 8B 01 48 8B 59 08 4C 8B 49 10 48 8B 49 18 E9 36 FD FF FF 66 90 48 8B 05 ?? ?? ?? ?? 83 08 28 83 F9 03 74 1C 49 83 F8 01 44 89 C0 19 D2 C1 E0 1F 83 C2 02 05 00 00 00 78 39 CA 0F 85 20 FF FF FF 41 C1 E0 1F 41 8D 80 7F 96 F8 77 E9 10 FF FF FF 0F 1F 44 00 00 45 01 C3 41 C1 E2 17 43 8D 04 13 E9 FB FE FF FF 41 C1 E0 1F 41 8D 80 00 00 00 78 E9 EB FE FF FF 41 83 C2 01 41 BB 40 42 0F 00 E9 81 FE FF FF 90 45 85 C9 74 3C 44 89 C9 F7 D9 83 F9 3F 7E 6A B9 19 00 00 00 29 C1 48 89 D0 48 D3 E8 48 3D 7F 96 98 00 0F 87 4D FC FF FF 48 3D FF FF 7F 00 76 1C 41 C1 E0 1F 41 8D 84 00 00 00 20 6C E9 9A FE FF FF 48 85 D2 0F 85 2B FC FF FF 31 C0 41 C1 E0 1F 41 8D 84 00 00 00 80 32 E9 7E FE FF FF 41 83 C3 65 41 C1 E0 1F 41 C1 E3 15 43 8D 84 18 00 00 80 5F 44 01 D0 E9 62 FE FF FF 48 89 D6 48 D3 EE 48 85 F6 0F 85 ED FB FF FF 8D 48 E7 48 89 D0 48 D3 E0 EB 89 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_13_0 {
	meta:
		name = "__binary64_to_bid32"
		size = 2576
		refs = "013f .refptr.__bid_IDEC_glbflags 0170 .rdata 0468 .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 58 48 BA FF FF FF FF FF FF 0F 00 66 48 0F 7E C1 66 48 0F 7E C0 66 49 0F 7E C3 48 C1 E9 34 48 21 C2 49 C1 EB 3F 81 E1 FF 07 00 00 0F 85 C1 04 00 00 48 85 D2 0F 84 C7 05 00 00 48 B9 00 00 00 00 FF FF 0F 00 41 89 C0 49 B9 FF FF 00 00 FF FF 00 00 48 21 C1 BB 3C 00 00 00 49 39 C8 48 B9 00 00 FF FF 00 00 0F 00 45 19 C0 48 21 C1 49 21 C1 41 F7 D0 41 83 E0 20 49 39 C9 49 B9 FF 00 FF 00 FF 00 0F 00 19 C9 49 21 C1 F7 D1 83 E1 10 41 01 C8 48 B9 00 FF 00 FF 00 FF 00 00 48 21 C1 49 39 C9 49 B9 0F 0F 0F 0F 0F 0F 0F 00 19 C9 49 21 C1 F7 D1 83 E1 08 41 01 C8 48 B9 F0 F0 F0 F0 F0 F0 00 00 48 21 C1 49 39 C9 49 B9 33 33 33 33 33 33 03 00 19 C9 49 21 C1 F7 D1 83 E1 04 41 01 C8 48 B9 CC CC CC CC CC CC 0C 00 48 21 C1 49 39 C9 49 B9 AA AA AA AA AA AA 0A 00 19 C9 49 21 C1 F7 D1 83 E1 02 44 01 C1 49 B8 55 55 55 55 55 55 05 00 4C 21 C0 49 39 C1 0F 96 C0 45 31 C9 0F B6 C0 01 C8 8D 48 F5 48 D3 E2 B9 D9 FB FF FF 29 C1 48 8B 05 ?? ?? ?? ?? 41 89 CA 83 08 02 41 8D 42 C4 3D D2 00 00 00 0F 8F 6F 04 00 00 49 89 D0 48 C1 E2 3C 49 C1 E8 04 85 C0 0F 8E 55 06 00 00 48 98 48 8D 0D ?? ?? ?? ?? 48 05 C2 01 00 00 49 89 C1 49 C1 E1 04 4C 01 C9 4C 8D 0D ?? ?? ?? ?? 4D 8D 0C 81 48 C1 E0 05 4C 3B 41 08 41 8B 31 4C 8B 11 89 74 24 04 0F 83 1B 07 00 00 48 8D 0D ?? ?? ?? ?? 48 01 C8 4C 8B 10 4C 8B 48 08 48 8B 58 10 4C 8B 68 18 4C 89 CD 45 89 C9 48 C1 EA 20 4D 89 CC 89 DF 48 C1 ED 20 4C 0F AF E2 48 89 EE 4C 89 D1 48 0F AF F2 48 C1 E9 20 45 89 D2 49 89 CF 4C 89 E0 48 C1 E0 20 48 89 74 24 18 48 89 44 24 20 48 89 D8 48 89 FB 48 0F AF DA 48 C1 E8 20 48 89 44 24 28 48 0F AF C2 49 89 DE 49 C1 EE 20 49 8D 34 06 4C 89 E8 45 89 EE 48 C1 E8 20 48 89 74 24 10 48 89 44 24 08 48 89 C6 4C 89 F0 49 89 F5 48 0F AF C2 4C 0F AF FA 4C 0F AF EA 48 89 C6 48 C1 E0 20 48 C1 EE 20 49 0F AF D2 49 01 F5 48 C1 EA 20 4C 01 FA 48 03 54 24 20 48 89 54 24 20 0F 92 C2 49 C1 EC 20 4C 03 64 24 18 48 C1 E3 20 0F B6 D2 48 01 D3 49 01 DC 4C 89 64 24 30 0F 82 32 04 00 00 48 39 DA 0F 87 29 04 00 00 48 03 44 24 10 4C 89 C2 45 89 C0 4C 89 D3 41 0F 92 C7 48 89 44 24 10 48 C1 EA 20 45 0F B6 FF 4B 8D 44 3D 00 49 89 EF 4D 0F AF D0 48 89 44 24 18 48 89 C8 48 0F AF C2 48 0F AF DA 49 0F AF C8 48 89 44 24 38 4C 89 D0 48 C1 E8 20 45 89 D2 89 DE 48 01 F0 48 01 C1 48 89 C8 48 C1 E0 20 4A 8D 34 10 4C 0F AF FA 48 89 74 24 40 4C 89 CE 4D 0F AF C8 48 0F AF F2 4C 89 7C 24 48 4C 8B 7C 24 28 4C 89 C8 45 89 C9 48 C1 E8 20 4D 89 FC 41 89 F2 4C 01 D0 49 89 EA 48 89 FD 4D 0F AF D0 48 0F AF EA 49 0F AF F8 4C 01 D0 49 89 C2 41 89 ED 48 C1 ED 20 49 C1 E2 20 4D 01 D1 49 89 FA 48 C1 EF 20 4C 01 EF 4D 89 FD 45 89 D2 4D 0F AF E8 4C 0F AF E2 4C 01 EF 4D 89 F5 49 01 EC 4C 89 F5 49 89 FF 4D 0F AF E8 49 C1 EF 20 48 0F AF EA 4D 01 E7 48 0F AF 54 24 08 4D 89 EC 45 89 ED 41 89 EE 49 C1 EC 20 4D 01 F4 48 C1 EB 20 48 03 5C 24 38 4C 0F AF 44 24 08 48 C1 ED 20 48 C1 E9 20 48 01 EA 48 01 CB 31 C9 4D 01 E0 4C 89 C5 49 C1 E0 20 48 C1 ED 20 4D 01 E8 48 01 EA 49 01 D9 0F 92 C1 48 C1 EE 20 48 03 74 24 48 48 C1 E7 20 48 C1 E8 20 4C 01 D7 48 01 CF 48 01 F0 48 01 F8 0F 82 A9 02 00 00 48 39 F9 0F 87 A0 02 00 00 31 C9 4D 01 C7 0F 92 C1 0F 1F 84 00 00 00 00 00 48 01 CA 48 8B 7C 24 40 31 C9 48 03 7C 24 20 48 8B 7C 24 30 0F 92 C1 49 01 C9 4C 01 CF 0F 82 3D 02 00 00 4C 39 C9 0F 87 34 02 00 00 45 31 C0 48 03 44 24 10 41 0F 92 C0 4C 8B 6C 24 18 4D 01 C7 4D 01 FD 41 0F 92 C1 4D 39 C7 41 0F 92 C2 45 09 D1 45 0F B6 C9 48 8B 0D ?? ?? ?? ?? 4C 01 CA 44 8B 01 48 89 D1 83 E1 01 46 8D 0C 85 00 00 00 00 47 8D 0C 59 49 01 C9 48 8D 0D ?? ?? ?? ?? 49 C1 E1 04 49 01 C9 49 8B 49 08 4C 39 E9 0F 82 3E 02 00 00 49 39 CD 0F 84 25 02 00 00 81 7C 24 04 BF 00 00 00 0F 8E B7 02 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 41 83 F8 03 0F 84 2E 01 00 00 49 83 FB 01 44 89 D8 19 D2 C1 E0 1F 83 C2 02 05 00 00 00 78 44 39 C2 0F 84 11 01 00 00 66 0F 1F 44 00 00 48 83 C4 58 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 81 F9 FF 07 00 00 0F 84 13 01 00 00 48 B8 00 00 00 00 00 00 10 00 44 8D 91 CD FB FF FF 48 01 C2 49 89 D1 49 F7 D9 49 21 D1 44 89 C8 48 83 F8 01 48 B8 FF FF 00 00 FF FF 00 00 45 19 C0 4C 21 C8 41 83 E0 20 48 83 F8 01 19 C0 83 E0 10 41 01 C0 48 B8 FF 00 FF 00 FF 00 FF 00 4C 21 C8 48 83 F8 01 19 C0 83 E0 08 41 01 C0 48 B8 0F 0F 0F 0F 0F 0F 0F 0F 4C 21 C8 48 83 F8 01 19 C0 83 E0 04 41 01 C0 48 B8 33 33 33 33 33 33 33 33 4C 21 C8 48 83 F8 01 19 C0 83 E0 02 44 01 C0 49 B8 55 55 55 55 55 55 55 55 4D 85 C1 41 0F 94 C1 45 0F B6 C9 41 01 C1 41 8D 42 C4 41 8D 59 3C 3D D2 00 00 00 0F 8E 91 FB FF FF 48 8B 05 ?? ?? ?? ?? 83 08 28 48 8B 05 ?? ?? ?? ?? 8B 08 83 F9 03 74 1C 49 83 FB 01 44 89 D8 19 D2 C1 E0 1F 83 C2 02 05 00 00 00 78 39 CA 0F 85 F5 FE FF FF 41 C1 E3 1F 41 8D 83 7F 96 F8 77 E9 E5 FE FF FF 0F 1F 44 00 00 41 C1 E3 1F 41 8D 83 00 00 80 32 E9 D0 FE FF FF 48 85 D2 0F 84 89 02 00 00 48 B9 00 00 00 00 00 00 08 00 48 85 C8 75 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 48 C1 E2 0D 41 C1 E3 1F B8 00 00 00 00 48 C1 EA 2C 48 81 FA 3F 42 0F 00 0F 47 D0 42 8D 84 1A 00 00 00 7C E9 86 FE FF FF 66 0F 1F 44 00 00 48 8D 70 01 48 8B 44 24 10 48 01 F0 0F 82 DE 00 00 00 48 85 F6 0F 84 D5 00 00 00 4C 8B 6C 24 18 45 31 C9 4D 01 FD 41 0F 92 C1 E9 C6 FD FF FF 90 49 83 C0 01 4D 01 C7 40 0F 92 C5 4D 85 C0 0F 94 C1 09 E9 0F B6 C9 E9 55 FD FF FF 0F 1F 44 00 00 48 83 C0 01 E9 CE FB FF FF 0F 1F 80 00 00 00 00 49 39 01 0F 83 D2 FD FF FF 0F 1F 80 00 00 00 00 48 83 C2 01 48 81 FA 80 96 98 00 0F 84 24 02 00 00 48 81 FA 40 42 0F 00 0F 85 AD FD FF FF 8B 4C 24 04 85 C9 0F 85 A1 FD FF FF 48 BA 33 33 33 33 33 33 33 F3 45 89 DA 49 39 D5 0F 87 D0 01 00 00 41 F6 C0 03 0F 85 C6 01 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 10 4C 09 E8 0F 84 E7 01 00 00 48 8B 05 ?? ?? ?? ?? 31 C9 41 B9 40 42 0F 00 BA 40 42 0F 00 44 8B 00 41 83 C8 20 44 89 00 EB 3C 0F 1F 00 41 B8 01 00 00 00 E9 DD FC FF FF 0F 1F 44 00 00 4C 09 E8 41 89 D1 8B 4C 24 04 45 89 DA 74 1A 48 8B 05 ?? ?? ?? ?? 48 81 FA 3F 42 0F 00 44 8B 00 77 C2 41 83 C8 30 44 89 00 41 81 F9 FF FF 7F 00 0F 86 FA 00 00 00 41 C1 E2 1F C1 E1 15 43 8D 84 11 00 00 80 5F 01 C8 E9 34 FD FF FF 0F 1F 40 00 8D 34 18 89 F1 F7 D9 85 C9 0F 8E 61 01 00 00 83 F9 30 0F 8F A8 00 00 00 4C 63 D1 48 8D 0D ?? ?? ?? ?? 4C 89 D7 48 C1 E7 04 48 01 F9 83 FB 3F 48 8B 29 48 8B 79 08 0F 8E BD 01 00 00 41 8D 49 FC 4D 89 C1 49 D3 E9 31 C9 48 39 CF 77 0A 4C 39 CD 72 6E 48 39 CF 75 69 4C 89 D1 48 8D 05 ?? ?? ?? ?? 45 89 C8 48 C1 E1 04 49 C1 E9 20 48 8B 04 08 4C 89 C1 89 C2 48 C1 E8 20 48 0F AF CA 49 0F AF C0 44 0F AF CA 48 89 CA 89 C9 48 C1 EA 20 49 01 D1 4C 01 C8 48 C1 E0 20 48 8D 14 08 81 FA FF FF 7F 00 0F 87 38 01 00 00 8D 46 65 41 C1 E3 1F C1 E0 17 44 01 D8 01 D0 E9 74 FC FF FF 0F 1F 40 00 3D 3F FE FF FF 0F 8D E0 F8 FF FF 31 C0 4C 8D 0D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E9 F3 F8 FF FF C1 E1 17 01 D1 41 C1 E2 1F 42 8D 04 11 E9 3E FC FF FF 41 C1 E3 1F 41 8D 83 00 00 00 78 E9 2E FC FF FF 75 09 4C 39 D2 0F 86 DA F8 FF FF 48 8D 0D ?? ?? ?? ?? 83 44 24 04 01 48 01 C8 4C 8B 10 4C 8B 48 08 48 8B 58 10 4C 8B 68 18 E9 D0 F8 FF FF 45 01 C3 41 83 FB 02 0F 85 37 FE FF FF 48 BA 66 66 66 66 66 66 66 E6 49 39 D5 0F 87 24 FE FF FF E9 15 FE FF FF 83 44 24 04 01 BA 40 42 0F 00 E9 87 FB FF FF BA 40 42 0F 00 31 C9 E9 73 FF FF FF 85 C0 74 51 89 C1 F7 D9 83 F9 3F 0F 8E A2 00 00 00 B9 FC FF FF FF 4C 89 C6 44 29 D1 48 D3 EE 48 89 F1 48 81 F9 7F 96 98 00 0F 87 21 FF FF FF 41 C1 E3 1F 48 81 F9 FF FF 7F 00 41 8D 84 0B 00 00 80 32 0F 86 78 FB FF FF 41 8D 84 0B 00 00 20 6C E9 6B FB FF FF 4D 85 C0 0F 85 DD F7 FF FF 48 81 FA 7F 96 98 00 0F 87 D0 F7 FF FF 48 89 D1 EB BF 83 C6 65 41 C1 E3 1F C1 E6 15 41 8D 84 33 00 00 80 5F 01 D0 E9 37 FB FF FF 89 D9 49 89 D4 4D 89 C6 49 D3 EC B9 04 00 00 00 44 29 C9 49 D3 E6 89 D9 4F 8D 0C 34 4D 89 C6 49 D3 EE 4C 89 F1 E9 25 FE FF FF 4D 89 C1 49 D3 E9 4D 85 C9 0F 85 8E FE FF FF 49 89 D1 4C 89 C6 49 D3 E9 41 8D 4A 04 48 D3 E6 48 89 F1 4C 01 C9 E9 45 FF FF FF 0F 1F 00 }
	condition:
		$1
}

rule file_174_14_0 {
	meta:
		name = "__binary80_to_bid32"
		size = 2608
		refs = "0149 .refptr.__bid_IDEC_glbflags 016e .refptr.__bid_IDEC_glbround 01f1 .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 DB 29 DB 7C 24 50 0F B7 44 24 52 0F B7 4C 24 58 48 C1 E0 10 44 0F B7 C9 48 89 C2 0F B7 44 24 54 41 C1 F9 0F 48 C1 E0 20 48 01 D0 0F B7 54 24 50 48 01 D0 0F B7 54 24 56 48 C1 E2 30 48 01 C2 66 81 E1 FF 7F 0F 85 4B 01 00 00 48 85 D2 0F 84 EE 01 00 00 48 B8 00 00 00 00 FF FF FF FF 89 D1 49 B8 FF FF 00 00 FF FF 00 00 48 21 D0 41 BA C3 BF FF FF BE 31 00 00 00 48 39 C1 48 B8 00 00 FF FF 00 00 FF FF 19 C9 48 21 D0 49 21 D0 F7 D1 83 E1 20 49 39 C0 49 B8 FF 00 FF 00 FF 00 FF 00 19 C0 49 21 D0 F7 D0 83 E0 10 01 C1 48 B8 00 FF 00 FF 00 FF 00 FF 48 21 D0 49 39 C0 49 B8 0F 0F 0F 0F 0F 0F 0F 0F 19 C0 49 21 D0 F7 D0 83 E0 08 01 C1 48 B8 F0 F0 F0 F0 F0 F0 F0 F0 48 21 D0 49 39 C0 49 B8 33 33 33 33 33 33 33 33 19 C0 49 21 D0 F7 D0 83 E0 04 01 C1 48 B8 CC CC CC CC CC CC CC CC 48 21 D0 49 39 C0 49 B8 AA AA AA AA AA AA AA AA 19 C0 49 21 D0 F7 D0 83 E0 02 01 C8 48 B9 55 55 55 55 55 55 55 55 48 21 D1 49 39 C8 0F 96 C1 31 DB 0F B6 C9 01 C1 48 8B 05 ?? ?? ?? ?? 41 29 CA 48 D3 E2 83 08 02 41 8D 42 CF 3D D2 00 00 00 7E 78 48 8B 05 ?? ?? ?? ?? 83 08 28 48 8B 05 ?? ?? ?? ?? 8B 08 83 F9 03 74 1C 41 83 F9 01 44 89 C8 19 D2 C1 E0 1F 83 C2 02 05 00 00 00 78 39 CA 0F 85 C7 00 00 00 41 C1 E1 1F 41 8D 81 7F 96 F8 77 E9 B7 00 00 00 66 81 F9 FF 7F 44 0F B7 D1 0F 84 5C 01 00 00 48 85 D2 0F 85 B3 00 00 00 BE 71 00 00 00 BB 40 00 00 00 41 81 EA 3E 40 00 00 41 8D 42 CF 3D D2 00 00 00 7F 88 49 89 D0 48 C1 E2 31 49 C1 E8 0F 85 C0 0F 8E E4 05 00 00 48 98 48 8D 0D ?? ?? ?? ?? 48 05 C2 01 00 00 49 89 C2 49 C1 E2 04 4C 01 D1 4C 8D 15 ?? ?? ?? ?? 4D 8D 14 82 48 C1 E0 05 4C 3B 41 08 41 8B 3A 4C 8B 19 89 7C 24 04 72 0F 0F 85 09 01 00 00 4C 39 DA 0F 87 00 01 00 00 48 8D 0D ?? ?? ?? ?? 48 01 C8 4C 8B 10 48 8B 58 08 4C 8B 58 10 4C 8B 68 18 E9 00 01 00 00 41 C1 E1 1F 41 8D 81 00 00 80 32 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 89 D0 48 F7 D8 48 21 D0 89 C1 48 83 F9 01 48 B9 FF FF 00 00 FF FF 00 00 45 19 C0 48 21 C1 41 83 E0 20 48 83 F9 01 19 C9 83 E1 10 41 01 C8 48 B9 FF 00 FF 00 FF 00 FF 00 48 21 C1 48 83 F9 01 19 C9 83 E1 08 41 01 C8 48 B9 0F 0F 0F 0F 0F 0F 0F 0F 48 21 C1 48 83 F9 01 19 C9 83 E1 04 41 01 C8 48 B9 33 33 33 33 33 33 33 33 48 21 C1 48 83 F9 01 19 C9 83 E1 02 44 01 C1 49 B8 55 55 55 55 55 55 55 55 4C 85 C0 0F 94 C0 0F B6 C0 8D 1C 01 8D 73 31 E9 BF FE FF FF 0F 1F 84 00 00 00 00 00 48 B8 FF FF FF FF FF FF FF 7F 48 85 C2 0F 85 8D 05 00 00 41 C1 E1 1F 41 8D 81 00 00 00 78 E9 29 FF FF FF 48 8D 0D ?? ?? ?? ?? 83 44 24 04 01 48 01 C1 4C 8B 11 48 8B 59 08 4C 8B 59 10 4C 8B 69 18 89 D8 48 C1 EA 20 48 89 DD 49 89 C4 4C 89 DB 48 C1 ED 20 4C 0F AF E2 48 C1 EB 20 48 89 EE 49 89 DE 48 89 5C 24 28 4C 89 D1 48 0F AF F2 48 C1 E9 20 45 89 D2 49 89 CF 4C 89 E7 48 C1 E7 20 48 89 7C 24 20 44 89 DF 4D 89 F3 48 89 FB 48 89 74 24 18 48 0F AF DA 4C 0F AF DA 4C 0F AF FA 49 89 DE 49 C1 EE 20 4B 8D 34 1E 4D 89 EE 49 C1 EE 20 48 89 74 24 10 4C 89 74 24 08 4C 89 F6 45 89 EE 49 89 F5 4D 89 F3 4C 0F AF DA 4C 0F AF EA 49 0F AF D2 4C 89 DE 49 C1 E3 20 48 C1 EE 20 48 C1 EA 20 49 01 F5 4C 01 FA 48 03 54 24 20 48 89 54 24 20 0F 92 C2 49 C1 EC 20 4C 03 64 24 18 48 C1 E3 20 0F B6 D2 48 01 D3 49 01 DC 4C 89 64 24 30 0F 82 5B 02 00 00 48 39 DA 0F 87 52 02 00 00 4C 03 5C 24 10 48 89 CE 41 0F 92 C7 4C 89 5C 24 10 4D 89 C3 45 0F B6 FF 45 89 C0 49 C1 EB 20 4B 8D 5C 3D 00 4C 8B 7C 24 28 49 0F AF F3 48 89 5C 24 18 4C 89 D3 4D 0F AF D0 4D 89 FC 49 0F AF DB 48 89 74 24 38 49 0F AF C8 4C 89 D2 45 89 D2 48 C1 EA 20 89 DE 48 01 F2 48 89 C6 48 01 D1 48 89 CA 48 C1 E2 20 4C 01 D2 48 89 54 24 40 48 89 EA 49 0F AF D3 49 0F AF C0 49 0F AF F3 48 89 54 24 48 48 89 C2 89 C0 41 89 F2 48 C1 EA 20 4C 01 D2 49 89 EA 48 89 FD 4D 0F AF D0 49 0F AF EB 49 0F AF F8 4C 01 D2 49 89 D2 41 89 ED 48 C1 ED 20 49 C1 E2 20 4C 01 D0 49 89 FA 48 C1 EF 20 4C 01 EF 4D 89 FD 45 89 D2 4D 0F AF E8 4D 0F AF E3 4C 01 EF 4D 89 F5 4D 0F AF E8 49 89 FF 49 01 EC 49 C1 EF 20 4C 89 F5 4D 01 E7 4D 89 EC 45 89 ED 49 0F AF EB 4C 0F AF 5C 24 08 49 C1 EC 20 48 C1 EB 20 48 03 5C 24 38 4C 0F AF 44 24 08 41 89 EE 48 C1 ED 20 48 C1 E9 20 4D 01 F4 48 01 CB 31 C9 49 01 EB 4D 01 E0 4C 89 C5 49 C1 E0 20 48 C1 ED 20 4D 01 E8 49 01 EB 48 01 D8 0F 92 C1 48 C1 EE 20 48 03 74 24 48 48 C1 E7 20 48 C1 EA 20 4C 01 D7 48 01 CF 48 01 D6 48 01 FE 0F 82 34 01 00 00 48 39 F9 0F 87 2B 01 00 00 31 D2 4D 01 C7 0F 92 C2 48 8B 7C 24 40 31 C9 4C 01 DA 48 03 7C 24 20 48 8B 7C 24 30 0F 92 C1 48 01 C8 48 01 C7 0F 82 D0 00 00 00 48 39 C1 0F 87 C7 00 00 00 4C 8B 5C 24 10 45 31 C0 49 01 F3 41 0F 92 C0 4C 8B 6C 24 18 4D 01 C7 4D 01 FD 0F 92 C0 4D 39 C7 0F 92 C1 09 C1 0F B6 C9 48 8D 04 0A 48 8B 15 ?? ?? ?? ?? 49 89 C0 8B 12 41 83 E0 01 8D 0C 95 00 00 00 00 42 8D 0C 49 4C 01 C1 4C 8D 05 ?? ?? ?? ?? 48 C1 E1 04 4C 01 C1 4C 8B 41 08 4D 39 E8 0F 82 C2 00 00 00 4D 39 C5 0F 84 A9 00 00 00 81 7C 24 04 BF 00 00 00 0F 8E 2B 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 83 FA 03 0F 84 3D FB FF FF 41 83 F9 01 44 89 C8 19 C9 C1 E0 1F 83 C1 02 05 00 00 00 78 39 D1 0F 85 E8 FB FF FF E9 1C FB FF FF 0F 1F 80 00 00 00 00 49 83 C3 01 E9 A5 FD FF FF 0F 1F 80 00 00 00 00 4C 8B 5C 24 10 48 83 C6 01 49 01 F3 0F 82 1E 01 00 00 48 85 F6 0F 84 15 01 00 00 4C 8B 6C 24 18 31 C9 4D 01 FD 0F 92 C1 E9 34 FF FF FF 0F 1F 00 49 83 C0 01 4D 01 C7 40 0F 92 C5 4D 85 C0 0F 94 C2 09 EA 0F B6 D2 E9 C2 FE FF FF 0F 1F 44 00 00 4C 39 19 0F 83 4E FF FF FF 0F 1F 80 00 00 00 00 48 83 C0 01 48 3D 80 96 98 00 0F 84 30 02 00 00 48 3D 40 42 0F 00 0F 85 2B FF FF FF 8B 4C 24 04 85 C9 0F 85 1F FF FF FF 48 B8 33 33 33 33 33 33 33 F3 49 39 C5 0F 87 D8 01 00 00 F6 C2 03 0F 85 CF 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 10 4D 09 EB 0F 84 F9 01 00 00 4C 8B 15 ?? ?? ?? ?? 31 D2 41 B8 40 42 0F 00 B8 40 42 0F 00 41 8B 0A 66 90 83 C9 20 41 89 0A EB 2C 0F 1F 84 00 00 00 00 00 4D 09 EB 41 89 C0 8B 54 24 04 74 18 4C 8B 15 ?? ?? ?? ?? 48 3D 3F 42 0F 00 41 8B 0A 77 D2 83 C9 30 41 89 0A 41 81 F8 FF FF 7F 00 0F 86 50 01 00 00 41 C1 E1 1F C1 E2 15 47 8D 8C 08 00 00 80 5F 41 8D 04 11 E9 A3 FA FF FF 0F 1F 80 00 00 00 00 41 B8 01 00 00 00 E9 0D FE FF FF 0F 1F 44 00 00 8D 3C 30 41 89 FB 41 F7 DB 45 85 DB 0F 8E 6E 01 00 00 41 83 FB 30 0F 8F A4 00 00 00 4D 63 DB 48 8D 0D ?? ?? ?? ?? 4D 89 DA 49 C1 E2 04 4C 01 D1 83 FE 3F 4C 8B 21 48 8B 69 08 0F 8E C9 01 00 00 8D 4B F1 4D 89 C2 49 D3 EA 31 C9 48 39 CD 77 0A 4D 39 D4 72 6B 48 39 CD 75 66 48 8D 05 ?? ?? ?? ?? 49 C1 E3 04 45 89 D0 4C 89 C2 49 C1 EA 20 4A 8B 04 18 89 C1 48 C1 E8 20 48 0F AF D1 49 0F AF C0 44 0F AF D1 48 89 D1 89 D2 48 C1 E9 20 49 01 CA 4C 01 D0 48 C1 E0 20 48 01 C2 81 FA FF FF 7F 00 0F 87 49 01 00 00 8D 47 65 41 C1 E1 1F C1 E0 17 44 01 C8 01 D0 E9 D1 F9 FF FF 0F 1F 44 00 00 3D 3F FE FF FF 0F 8D 51 F9 FF FF 31 C0 4C 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E9 64 F9 FF FF 48 B8 00 00 00 00 00 00 00 40 48 85 C2 75 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 48 C1 E2 02 41 C1 E1 1F B8 00 00 00 00 48 C1 EA 2C 48 81 FA 3F 42 0F 00 0F 47 D0 42 8D 84 0A 00 00 00 7C E9 6B F9 FF FF C1 E2 17 01 C2 41 C1 E1 1F 42 8D 04 0A E9 59 F9 FF FF 44 01 CA 83 FA 02 0F 85 2F FE FF FF 48 B8 66 66 66 66 66 66 66 E6 49 39 C5 0F 87 1C FE FF FF E9 0D FE FF FF 66 0F 1F 84 00 00 00 00 00 83 44 24 04 01 B8 40 42 0F 00 E9 F8 FC FF FF 90 B8 40 42 0F 00 31 D2 EB AB 0F 1F 80 00 00 00 00 85 C0 74 51 89 C1 F7 D9 83 F9 3F 0F 8E A0 00 00 00 B9 F1 FF FF FF 4C 89 C7 44 29 D1 48 D3 EF 48 89 F9 48 81 F9 7F 96 98 00 0F 87 11 FF FF FF 41 C1 E1 1F 48 81 F9 FF FF 7F 00 41 8D 84 09 00 00 80 32 0F 86 C4 F8 FF FF 41 8D 84 09 00 00 20 6C E9 B7 F8 FF FF 4D 85 C0 0F 85 3E F8 FF FF 48 81 FA 7F 96 98 00 0F 87 31 F8 FF FF 48 89 D1 EB BF 83 C7 65 41 C1 E1 1F C1 E7 15 41 8D 84 39 00 00 80 5F 01 D0 E9 83 F8 FF FF 89 F1 49 89 D2 49 D3 EA B9 0F 00 00 00 29 D9 4C 89 C3 48 D3 E3 89 F1 49 01 DA 4C 89 C3 48 D3 EB 48 89 D9 E9 1A FE FF FF 4D 89 C3 49 D3 EB 4D 85 DB 0F 85 80 FE FF FF 49 89 D3 4C 89 C7 49 D3 EB 41 8D 4A 0F 48 D3 E7 48 89 F9 4C 01 D9 E9 47 FF FF FF 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_174_15_0 {
	meta:
		name = "__binary128_to_bid32"
		size = 3360
		refs = "0138 .refptr.__bid_IDEC_glbflags 014f .rdata 043c .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 4C 8B 01 48 8B 49 08 48 BA FF FF FF FF FF FF 00 00 48 89 C8 48 89 CD 48 21 CA 48 C1 E8 30 48 C1 ED 3F 4D 89 C1 25 FF 7F 00 00 0F 85 25 03 00 00 48 85 D2 0F 84 37 04 00 00 48 B8 00 00 00 00 FF FF 00 00 41 89 CA 49 89 CB 48 21 C8 49 39 C2 48 B8 FF FF 00 00 FF FF 00 00 45 19 D2 48 21 C8 41 81 E3 00 00 FF FF 41 F7 D2 41 83 E2 20 4C 39 D8 49 BB FF 00 FF 00 FF 00 00 00 19 C0 49 21 CB F7 D0 83 E0 10 41 01 C2 48 B8 00 FF 00 FF 00 FF 00 00 48 21 C8 49 39 C3 49 BB 0F 0F 0F 0F 0F 0F 00 00 19 C0 49 21 CB F7 D0 83 E0 08 41 01 C2 48 B8 F0 F0 F0 F0 F0 F0 00 00 48 21 C8 49 39 C3 49 BB 33 33 33 33 33 33 00 00 19 C0 49 21 CB F7 D0 83 E0 04 41 01 C2 48 B8 CC CC CC CC CC CC 00 00 48 21 C8 49 39 C3 49 BB AA AA AA AA AA AA 00 00 19 C0 49 21 CB F7 D0 83 E0 02 44 01 D0 49 BA 55 55 55 55 55 55 00 00 4C 21 D1 49 39 CB 0F 96 C1 0F B6 C9 44 8D 54 08 F1 45 85 D2 0F 85 40 04 00 00 B8 92 BF FF FF 48 8B 0D ?? ?? ?? ?? 45 31 C0 83 09 02 85 C0 0F 8E 36 09 00 00 48 98 48 8D 0D ?? ?? ?? ?? 48 05 C2 01 00 00 49 89 C0 49 C1 E0 04 4C 01 C1 4C 8D 05 ?? ?? ?? ?? 4D 8D 04 80 48 C1 E0 05 48 39 51 08 41 8B 38 4C 8B 11 89 7C 24 0C 0F 86 2A 0A 00 00 48 8D 0D ?? ?? ?? ?? 48 01 C8 4C 8B 18 48 8B 58 08 4C 8B 50 10 4C 8B 40 18 44 89 C9 4C 89 CE 4D 89 D9 49 C1 E9 20 48 C1 EE 20 45 89 DB 4C 89 C8 4D 89 DC 48 0F AF C6 4C 0F AF E6 48 89 44 24 20 4C 89 D8 48 0F AF C1 44 89 E7 48 C1 E8 20 48 01 C7 48 89 D8 48 C1 E8 20 48 89 7C 24 40 49 89 C7 48 89 44 24 28 89 D8 48 89 C7 48 89 44 24 30 48 0F AF FE 48 0F AF C1 48 89 FB 4C 89 FF 48 0F AF FE 48 89 5C 24 10 49 89 C6 49 C1 EE 20 89 C0 4C 89 F3 48 89 7C 24 38 8B 7C 24 10 48 01 FB 4C 89 FF 48 0F AF F9 4C 8D 34 3B 4D 89 F7 4C 89 74 24 48 49 C1 E7 20 4D 8D 34 07 4D 89 D7 45 89 D2 49 C1 EF 20 4C 89 74 24 50 4D 89 D6 4D 89 FD 4C 0F AF F6 4C 89 7C 24 58 4C 0F AF EE 4C 89 F3 4D 89 D6 4C 0F AF F1 4C 89 F7 41 89 DE 48 C1 EB 20 48 89 F8 49 01 DD 89 FF 48 C1 E8 20 4C 01 F0 4D 89 FE 4D 89 C7 4C 0F AF F1 45 89 C0 49 C1 EF 20 4C 89 C3 4C 89 3C 24 48 0F AF D9 4C 01 F0 49 89 C6 49 C1 EE 20 4D 01 F5 4D 89 C6 4C 0F AF F6 4C 89 6C 24 18 49 89 DD 49 0F AF F7 49 C1 ED 20 89 DB 45 89 F7 4D 01 EF 4C 8B 2C 24 4C 0F AF E9 49 C1 EC 20 4C 03 64 24 20 49 0F AF C9 49 C1 EE 20 48 03 4C 24 40 4C 01 F6 4D 01 FD 4D 89 EE 49 C1 E5 20 48 C1 E9 20 49 C1 EE 20 49 01 DD 49 01 F6 49 01 CC 4C 03 64 24 50 48 8B 5C 24 10 48 8B 74 24 48 0F 92 C1 48 C1 EB 20 48 03 5C 24 38 48 C1 E0 20 48 C1 EE 20 0F B6 C9 48 01 F8 4C 89 64 24 20 48 01 C8 48 01 F3 48 01 C3 48 89 5C 24 38 0F 82 56 02 00 00 48 39 C1 0F 87 4D 02 00 00 4C 8B 7C 24 18 31 C0 4D 01 EF 0F 92 C0 E9 55 02 00 00 3D FF 7F 00 00 0F 84 90 05 00 00 48 B9 00 00 00 00 00 00 01 00 48 01 CA 4D 85 C0 0F 84 DA 04 00 00 4C 89 C1 48 F7 D9 4C 21 C1 41 89 C8 49 83 F8 01 49 B8 FF FF 00 00 FF FF 00 00 45 19 D2 49 21 C8 41 83 E2 20 49 83 F8 01 45 19 C0 41 83 E0 10 45 01 C2 49 B8 FF 00 FF 00 FF 00 FF 00 49 21 C8 49 83 F8 01 45 19 C0 41 83 E0 08 45 01 C2 49 B8 0F 0F 0F 0F 0F 0F 0F 0F 49 21 C8 49 83 F8 01 45 19 C0 41 83 E0 04 45 01 C2 49 B8 33 33 33 33 33 33 33 33 49 21 C8 49 83 F8 01 45 19 C0 41 83 E0 02 45 01 D0 49 BA 55 55 55 55 55 55 55 55 4C 85 D1 0F 94 C1 0F B6 C9 41 01 C8 2D 6F 40 00 00 3D D2 00 00 00 0F 8E 13 FD FF FF 48 8B 05 ?? ?? ?? ?? 83 08 28 48 8B 05 ?? ?? ?? ?? 8B 08 83 F9 03 0F 84 D5 03 00 00 83 FD 01 89 E8 19 D2 C1 E0 1F 83 C2 02 05 00 00 00 78 39 CA 0F 84 BB 03 00 00 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 2E 0F 1F 84 00 00 00 00 00 4D 85 C0 0F 84 C7 04 00 00 48 B8 00 00 00 00 FF FF FF FF 44 89 C1 49 BA FF FF 00 00 FF FF 00 00 4C 21 C0 48 39 C1 48 B8 00 00 FF FF 00 00 FF FF 19 C9 4C 21 C0 4D 21 C2 F7 D1 83 E1 20 49 39 C2 49 BA FF 00 FF 00 FF 00 FF 00 19 C0 4D 21 C2 F7 D0 83 E0 10 01 C1 48 B8 00 FF 00 FF 00 FF 00 FF 4C 21 C0 49 39 C2 49 BA 0F 0F 0F 0F 0F 0F 0F 0F 19 C0 4D 21 C2 F7 D0 83 E0 08 01 C1 48 B8 F0 F0 F0 F0 F0 F0 F0 F0 4C 21 C0 49 39 C2 49 BA 33 33 33 33 33 33 33 33 19 C0 4D 21 C2 F7 D0 83 E0 04 01 C1 48 B8 CC CC CC CC CC CC CC CC 4C 21 C0 49 39 C2 49 BA AA AA AA AA AA AA AA AA 19 C0 4D 21 C2 45 31 DB F7 D0 83 E0 02 01 C8 48 B9 55 55 55 55 55 55 55 55 4C 21 C1 49 39 CA 41 0F 96 C3 41 01 C3 45 8D 53 31 41 83 FA 3F 0F 8F F2 05 00 00 44 89 D1 4C 89 C0 4D 89 C1 48 D3 E2 B9 40 00 00 00 44 29 D1 48 D3 E8 44 89 D1 48 01 C2 B8 92 BF FF FF 49 D3 E1 44 29 D0 E9 98 FB FF FF 0F 1F 00 4C 8B 7C 24 18 49 83 C5 01 4D 01 EF 0F 92 C0 4D 85 ED 0F 94 C1 09 C8 0F B6 C0 4C 01 F0 48 89 D1 89 D2 48 C1 E9 20 48 89 44 24 10 4C 89 C8 48 0F AF C1 4C 89 DB 4C 8B 74 24 28 4C 0F AF DA 48 0F AF D9 48 89 44 24 18 4C 89 D8 45 89 DB 4C 0F AF CA 89 DE 48 C1 E8 20 48 01 F0 48 8B 74 24 30 49 01 C1 4C 89 C8 48 C1 E0 20 4A 8D 3C 18 4C 89 F0 48 0F AF C1 48 89 7C 24 40 48 89 F7 48 0F AF F2 48 0F AF F9 48 89 44 24 28 49 89 F4 49 C1 EC 20 41 89 FB 4C 89 E0 4C 01 D8 4D 89 F3 4C 0F AF DA 4C 01 D8 41 89 F3 49 89 C4 49 C1 E4 20 4B 8D 34 1C 4C 8B 5C 24 58 48 89 74 24 30 4C 89 D6 4C 0F AF D2 4D 89 DD 48 0F AF F1 4C 0F AF E9 4D 89 D4 45 89 D2 41 89 F6 49 C1 EC 20 48 C1 EE 20 4D 01 F4 4D 89 DE 49 01 F5 4C 0F AF F2 4D 01 F4 4C 89 E6 48 C1 EE 20 4C 01 EE 4D 89 C5 4C 0F AF C2 4C 0F AF E9 48 0F AF 0C 24 4D 89 C6 45 89 C0 45 89 EB 49 C1 EE 20 4D 01 DE 48 C1 EB 20 48 03 5C 24 18 48 0F AF 14 24 49 C1 ED 20 4C 8B 5C 24 30 49 C1 E9 20 4C 01 E9 4C 01 CB 4C 01 F2 49 89 D5 48 C1 E2 20 49 C1 ED 20 4C 01 C2 45 31 C0 4C 01 E9 49 01 DB 41 0F 92 C0 48 C1 EF 20 48 03 7C 24 28 49 C1 E4 20 48 C1 E8 20 4D 01 D4 4D 01 C4 48 01 C7 4C 01 E7 0F 82 16 00 00 00 4D 39 E0 77 11 45 31 ED 48 01 D6 41 0F 92 C5 EB 1D 0F 1F 44 00 00 48 83 C2 01 48 01 D6 41 0F 92 C5 48 85 D2 0F 94 C0 41 09 C5 45 0F B6 ED 48 8B 44 24 20 4C 01 E9 48 03 44 24 40 48 8B 54 24 38 0F 92 C0 0F B6 C0 49 01 C3 4C 01 DA 0F 82 C4 00 00 00 4C 39 D8 0F 87 BB 00 00 00 49 01 FF 41 0F 92 C0 4D 89 FD 45 0F B6 C0 4C 8B 74 24 10 49 8D 04 30 49 01 C6 41 0F 92 C1 4C 39 C0 41 0F 92 C2 45 09 D1 45 0F B6 C9 48 8B 05 ?? ?? ?? ?? 4C 01 C9 8B 10 48 89 C8 83 E0 01 44 8D 04 95 00 00 00 00 45 8D 0C 68 49 01 C1 48 8D 05 ?? ?? ?? ?? 49 C1 E1 04 49 01 C1 49 8B 41 08 4C 39 F0 0F 82 A3 01 00 00 49 39 C6 0F 84 8A 01 00 00 81 7C 24 0C BF 00 00 00 0F 8E 3C 02 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 83 FA 03 74 1D 83 FD 01 89 E8 19 C9 C1 E0 1F 83 C1 02 05 00 00 00 78 39 D1 0F 85 48 FC FF FF 0F 1F 00 C1 E5 1F 8D 85 7F 96 F8 77 E9 37 FC FF FF 66 90 48 83 C7 01 49 01 FF 4D 89 FD 0F 82 20 01 00 00 48 85 FF 0F 84 17 01 00 00 4C 8B 74 24 10 45 31 C9 49 01 F6 41 0F 92 C1 E9 44 FF FF FF 0F 1F 00 48 89 D1 48 F7 D9 48 21 D1 41 89 C8 49 83 F8 01 49 B8 FF FF 00 00 FF FF 00 00 45 19 D2 49 21 C8 41 83 E2 20 49 83 F8 01 45 19 C0 41 83 E0 10 45 01 C2 49 B8 FF 00 FF 00 FF 00 FF 00 49 21 C8 49 83 F8 01 45 19 C0 41 83 E0 08 45 01 C2 49 B8 0F 0F 0F 0F 0F 0F 0F 0F 49 21 C8 49 83 F8 01 45 19 C0 41 83 E0 04 45 01 C2 49 B8 33 33 33 33 33 33 33 33 49 21 C8 49 83 F8 01 45 19 C0 41 83 E0 02 45 01 D0 49 BA 55 55 55 55 55 55 55 55 4C 85 D1 0F 94 C1 0F B6 C9 45 8D 44 08 40 E9 1F FB FF FF 49 09 D0 0F 84 D7 02 00 00 48 B8 00 00 00 00 00 80 00 00 48 85 C1 75 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 48 C1 E2 11 C1 E5 1F B8 00 00 00 00 48 C1 EA 2C 48 81 FA 3F 42 0F 00 0F 47 D0 8D 84 2A 00 00 00 7C E9 1D FB FF FF 0F 1F 84 00 00 00 00 00 C1 E5 1F 8D 85 00 00 80 32 E9 07 FB FF FF 66 90 41 B8 01 00 00 00 E9 18 FE FF FF 0F 1F 44 00 00 4D 39 29 0F 83 6D FE FF FF 0F 1F 80 00 00 00 00 48 83 C1 01 48 81 F9 80 96 98 00 0F 84 02 02 00 00 48 81 F9 40 42 0F 00 0F 85 48 FE FF FF 8B 44 24 0C 85 C0 0F 85 3C FE FF FF F6 C2 03 75 41 48 B8 32 33 33 33 33 33 33 F3 49 39 C6 76 22 48 B8 33 33 33 33 33 33 33 33 49 39 C5 77 23 48 B8 33 33 33 33 33 33 33 F3 49 39 C6 75 14 0F 1F 40 00 89 E8 E9 39 02 00 00 66 0F 1F 84 00 00 00 00 00 01 EA 89 E8 83 FA 02 0F 84 F1 01 00 00 4D 09 F5 0F 84 9C 01 00 00 4C 8B 15 ?? ?? ?? ?? 31 D2 41 B9 40 42 0F 00 B9 40 42 0F 00 45 8B 02 0F 1F 00 41 83 C8 20 45 89 02 EB 2F 0F 1F 80 00 00 00 00 4D 09 F5 41 89 C9 8B 54 24 0C 89 E8 74 1A 4C 8B 15 ?? ?? ?? ?? 48 81 F9 3F 42 0F 00 45 8B 02 77 CF 41 83 C8 30 45 89 02 41 81 F9 FF FF 7F 00 0F 86 1B 01 00 00 C1 E0 1F C1 E2 15 41 8D 84 01 00 00 80 5F 01 D0 E9 EB F9 FF FF 66 0F 1F 44 00 00 46 8D 1C 00 44 89 D9 F7 D9 85 C9 0F 8E 9F 01 00 00 83 F9 30 0F 8F A8 00 00 00 4C 63 D1 48 8D 0D ?? ?? ?? ?? 4C 89 D3 48 C1 E3 04 48 01 D9 45 85 C0 48 8B 39 48 8B 71 08 0F 84 C3 01 00 00 41 83 F8 3F 0F 8E F9 01 00 00 41 8D 48 C0 48 89 D3 48 D3 EB 31 C9 48 39 CE 77 07 75 67 48 39 DF 72 62 4C 89 D1 48 8D 05 ?? ?? ?? ?? 41 89 D8 48 C1 E1 04 4C 89 C2 48 C1 EB 20 48 8B 04 08 89 C1 48 C1 E8 20 48 0F AF D1 49 0F AF C0 0F AF D9 48 89 D1 89 D2 48 C1 E9 20 48 01 CB 48 01 D8 48 C1 E0 20 48 01 C2 81 FA FF FF 7F 00 0F 87 78 01 00 00 41 8D 43 65 C1 E5 1F C1 E0 17 01 E8 01 D0 E9 23 F9 FF FF 3D 3F FE FF FF 0F 8D FD F5 FF FF 31 C0 4C 8D 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E9 10 F6 FF FF 41 8D 4B F1 4C 89 C2 B8 61 BF FF FF 44 29 D8 45 31 C9 48 D3 E2 E9 B9 F5 FF FF 0F 1F 40 00 C1 E2 17 41 89 C9 44 01 CA C1 E0 1F 01 D0 E9 D2 F8 FF FF 83 44 24 0C 01 B9 40 42 0F 00 E9 44 FC FF FF 41 B9 40 42 0F 00 31 D2 EB DA 0F 1F 40 00 75 09 4D 39 CA 0F 83 CB F5 FF FF 48 8D 0D ?? ?? ?? ?? 83 44 24 0C 01 48 01 C8 4C 8B 18 48 8B 58 08 4C 8B 50 10 4C 8B 40 18 E9 C1 F5 FF FF 66 90 C1 E5 1F 8D 85 00 00 00 78 E9 77 F8 FF FF 48 BA 65 66 66 66 66 66 66 E6 49 39 D6 76 23 B2 66 49 39 D6 0F 85 F5 FD FF FF 48 BA 66 66 66 66 66 66 66 66 49 39 D5 0F 87 E2 FD FF FF 0F 1F 44 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 10 E9 CE FD FF FF 90 85 C0 74 58 89 C1 F7 D9 83 F9 3F 0F 8E AB 00 00 00 B9 C0 FF FF FF 48 89 D7 29 C1 48 D3 EF 48 89 F9 48 81 F9 7F 96 98 00 0F 87 E4 FE FF FF C1 E5 1F 48 81 F9 FF FF 7F 00 8D 84 0D 00 00 80 32 0F 86 F0 F7 FF FF 8D 84 0D 00 00 20 6C E9 E4 F7 FF FF 48 89 D1 4C 89 CB E9 48 FE FF FF 48 85 D2 0F 85 B5 F4 FF FF 49 81 F9 7F 96 98 00 0F 87 A8 F4 FF FF 4C 89 C9 EB B7 41 83 C3 65 C1 E5 1F 41 C1 E3 15 42 8D 84 1D 00 00 80 5F 01 D0 E9 A4 F7 FF FF 44 89 C1 4C 89 CB 49 89 D7 48 D3 EB B9 40 00 00 00 44 29 C1 49 D3 E7 44 89 C1 4C 01 FB 49 89 D7 49 D3 EF 4C 89 F9 E9 E8 FD FF FF 49 89 D0 49 D3 E8 4D 85 C0 0F 85 47 FE FF FF 4D 89 C8 48 89 D7 49 D3 E8 8D 48 40 48 D3 E7 48 89 F9 4C 01 C1 E9 3C FF FF FF 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_16_0 {
	meta:
		name = "__binary32_to_bid64"
		size = 1600
		refs = "00ed .refptr.__bid_IDEC_glbflags 012e .rdata 0353 .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 55 41 54 55 57 56 53 66 0F 7E C1 66 41 0F 7E C2 89 C8 41 81 E2 FF FF 7F 00 49 89 C1 48 C1 E8 1F 44 89 D2 49 C1 E9 17 49 89 C0 45 0F B6 C9 45 85 C9 0F 85 98 01 00 00 45 85 D2 0F 84 BF 03 00 00 66 0F 7E C0 44 0F B7 C9 66 41 0F 7E C2 25 00 00 7F 00 41 39 C1 66 0F 7E C0 45 19 C9 41 81 E2 FF 00 7F 00 25 00 FF 00 00 41 F7 D1 41 83 E1 10 41 39 C2 66 41 0F 7E C2 19 C0 F7 D0 41 81 E2 0F 0F 0F 00 83 E0 08 41 01 C1 66 0F 7E C0 25 F0 F0 70 00 41 39 C2 66 41 0F 7E C2 19 C0 F7 D0 41 81 E2 33 33 33 00 83 E0 04 41 01 C1 66 0F 7E C0 25 CC CC 4C 00 41 39 C2 19 C0 81 E1 AA AA 2A 00 F7 D0 83 E0 02 44 01 C8 66 41 0F 7E C1 41 81 E1 55 55 55 00 41 39 C9 41 B9 73 FF FF FF 0F 93 C1 0F B6 C9 01 C8 8D 48 F8 41 29 C1 48 8B 05 ?? ?? ?? ?? 45 8D 51 A7 48 D3 E2 31 C9 83 08 02 48 C1 E2 21 45 85 D2 B8 59 00 00 00 0F 8F 52 01 00 00 45 8D 1C 02 44 89 D8 F7 D8 85 C0 0F 8E 52 04 00 00 83 F8 30 0F 8F 38 01 00 00 48 98 4C 8D 0D ?? ?? ?? ?? 83 C1 21 48 89 C3 48 C1 E3 04 49 01 D9 48 89 D3 48 D3 EB 49 3B 19 76 0B 49 83 79 08 00 0F 84 0C 01 00 00 48 8D 15 ?? ?? ?? ?? 48 C1 E0 04 41 89 D9 4C 89 C9 48 C1 EB 20 48 8B 04 02 89 C2 48 C1 E8 20 48 0F AF CA 49 0F AF C1 0F AF DA 48 89 CA 89 C9 48 C1 EA 20 48 01 D3 48 01 D8 48 C1 E0 20 48 8D 14 08 48 B8 FF FF FF FF FF FF 1F 00 48 39 C2 0F 87 25 04 00 00 41 8D 83 8E 01 00 00 49 89 C3 4C 89 C0 49 C1 E3 35 48 C1 E0 3F 4C 01 D8 48 01 D0 E9 48 02 00 00 0F 1F 80 00 00 00 00 41 81 F9 FF 00 00 00 0F 84 63 02 00 00 48 81 C2 00 00 80 00 49 89 D2 49 F7 DA 49 21 D2 41 0F B7 C2 48 83 F8 01 4C 89 D0 45 19 DB 25 FF 00 FF 00 41 83 E3 10 48 83 F8 01 4C 89 D0 19 C9 25 0F 0F 0F 0F 83 E1 08 41 01 CB 48 83 F8 01 4C 89 D0 19 C9 25 33 33 33 33 83 E1 04 41 01 CB 48 83 F8 01 19 C9 31 C0 83 E1 02 44 01 D9 41 F7 C2 55 55 55 01 0F 94 C0 41 81 E9 96 00 00 00 48 C1 E2 21 45 8D 51 A7 01 C1 8D 41 59 45 85 D2 0F 8E AE FE FF FF 48 8D 05 ?? ?? ?? ?? 4D 63 D2 4C 8D 0D ?? ?? ?? ?? 49 81 C2 9D 05 00 00 42 8B 0C 90 4C 89 D0 49 C1 E2 05 48 C1 E0 04 49 3B 54 01 08 0F 86 4F 02 00 00 48 8D 05 ?? ?? ?? ?? 83 C1 01 49 01 C2 4D 8B 22 49 8B 42 08 49 8B 5A 10 4D 8B 5A 18 48 C1 EA 20 89 C6 48 C1 E8 20 48 0F AF C2 4C 89 E7 45 89 E4 48 C1 EF 20 48 0F AF F2 49 89 C2 89 D8 48 C1 EB 20 48 0F AF C2 48 89 F5 48 0F AF DA 48 C1 E5 20 48 0F AF FA 49 89 D9 48 89 C3 48 C1 EB 20 4C 01 CB 45 89 D9 49 C1 EB 20 4C 0F AF CA 4C 0F AF DA 49 0F AF D4 4D 89 CD 49 C1 E1 20 49 C1 ED 20 48 C1 EA 20 4D 01 EB 48 01 FA 48 01 EA 0F 92 C2 48 C1 E0 20 48 C1 EE 20 0F B6 D2 49 01 F2 48 01 D0 49 01 C2 0F 82 B5 00 00 00 48 39 C2 0F 87 AC 00 00 00 31 C0 49 01 D9 0F 92 C0 49 01 C3 48 8B 05 ?? ?? ?? ?? 4C 89 DB 83 E3 01 8B 00 8D 14 85 00 00 00 00 42 8D 14 42 48 01 DA 48 8D 1D ?? ?? ?? ?? 48 C1 E2 04 48 01 DA 48 8B 5A 08 4C 39 CB 0F 83 98 00 00 00 49 83 C3 01 48 BA 00 00 C1 6F F2 86 23 00 49 39 D3 0F 84 C1 01 00 00 81 F9 FF 02 00 00 0F 8F 55 01 00 00 4D 85 C9 0F 85 EC 00 00 00 4D 85 D2 0F 85 E3 00 00 00 48 B8 FF FF FF FF FF FF 1F 00 49 39 C3 0F 86 FB 00 00 00 4C 89 C0 48 BA 00 00 00 00 00 00 E0 5F 48 C1 E1 33 48 C1 E0 3F 48 01 D0 49 01 C3 49 8D 04 0B EB 20 49 83 C1 01 E9 4B FF FF FF 66 0F 1F 44 00 00 48 C1 E0 3F 48 BA 00 00 00 00 00 00 C0 31 48 01 D0 5B 5E 5F 5D 41 5C 41 5D C3 66 0F 1F 44 00 00 49 39 D9 0F 85 76 FF FF FF 4C 3B 12 0F 86 6D FF FF FF E9 51 FF FF FF 66 0F 1F 84 00 00 00 00 00 45 85 D2 0F 84 D3 00 00 00 81 E1 00 00 40 00 75 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 48 89 D0 49 C1 E0 3F 48 B9 00 00 00 00 00 00 00 7C 48 C1 E0 2A 48 C1 E8 0E 48 89 C2 48 B8 FF 7F C6 A4 7E 8D 03 00 48 39 C2 B8 00 00 00 00 48 0F 47 D0 49 8D 04 08 48 01 D0 E9 78 FF FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 8B 10 41 89 D1 41 83 C9 20 44 89 08 49 B9 FF 7F C6 A4 7E 8D 03 00 4D 39 CB 0F 87 F7 FE FF FF 83 CA 30 89 10 4C 89 C0 48 C1 E1 35 48 C1 E0 3F 49 01 C3 49 8D 04 0B E9 2F FF FF FF 48 8D 05 ?? ?? ?? ?? 49 01 C2 4D 8B 22 49 8B 42 08 49 8B 5A 10 4D 8B 5A 18 E9 AF FD FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 28 83 F8 03 74 31 49 83 F8 01 19 D2 83 C2 02 39 C2 74 24 4C 89 C0 48 BA 00 00 00 00 00 00 00 78 48 C1 E0 3F 48 01 D0 5B 5E 5F 5D 41 5C 41 5D C3 0F 1F 80 00 00 00 00 4C 89 C0 48 BA FF FF C0 6F F2 86 FB 77 48 C1 E0 3F 48 01 D0 E9 B8 FE FF FF 0F 1F 80 00 00 00 00 83 C1 01 49 BB 00 80 C6 A4 7E 8D 03 00 E9 2D FE FF FF B9 61 00 00 00 44 29 C9 83 F9 3F 7E 79 B9 21 00 00 00 48 89 D0 44 29 C9 48 D3 E8 48 89 C1 48 B8 FF FF C0 6F F2 86 23 00 48 39 C1 0F 87 BE FC FF FF 48 B8 FF FF FF FF FF FF 1F 00 48 39 C1 4C 89 C0 77 64 48 C1 E0 3F 48 BA 00 00 00 00 00 00 C0 31 48 01 D0 48 01 C8 E9 43 FE FF FF 4C 89 C0 48 B9 00 00 00 00 00 00 E0 5F 48 C1 E0 3F 48 01 C1 41 8D 83 8E 01 00 00 48 C1 E0 33 48 01 C8 48 01 D0 E9 19 FE FF FF 48 89 D0 48 D3 E8 48 85 C0 0F 85 5A FC FF FF 41 8D 49 DF 48 89 D0 48 D3 E0 48 89 C1 E9 77 FF FF FF 48 C1 E0 3F 48 BA 00 00 00 00 00 00 50 6C 48 01 D0 48 01 C8 E9 DF FD FF FF 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_17_0 {
	meta:
		name = "__binary64_to_bid64"
		size = 1904
		refs = "0146 .refptr.__bid_IDEC_glbflags 0183 .rdata 04b7 .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 38 49 B8 FF FF FF FF FF FF 0F 00 66 49 0F 7E C1 66 48 0F 7E C2 66 48 0F 7E C0 49 C1 E9 34 49 21 D0 48 C1 E8 3F 41 81 E1 FF 07 00 00 0F 85 DF 01 00 00 4D 85 C0 0F 84 16 05 00 00 48 B9 00 00 00 00 FF FF 0F 00 41 89 D1 49 BA FF FF 00 00 FF FF 00 00 48 21 D1 49 39 C9 48 B9 00 00 FF FF 00 00 0F 00 45 19 C9 48 21 D1 49 21 D2 41 F7 D1 41 83 E1 20 49 39 CA 49 BA FF 00 FF 00 FF 00 0F 00 19 C9 49 21 D2 F7 D1 83 E1 10 41 01 C9 48 B9 00 FF 00 FF 00 FF 00 00 48 21 D1 49 39 CA 49 BA 0F 0F 0F 0F 0F 0F 0F 00 19 C9 49 21 D2 F7 D1 83 E1 08 41 01 C9 48 B9 F0 F0 F0 F0 F0 F0 00 00 48 21 D1 49 39 CA 49 BA 33 33 33 33 33 33 03 00 19 C9 49 21 D2 F7 D1 83 E1 04 41 01 C9 48 B9 CC CC CC CC CC CC 0C 00 48 21 D1 49 39 CA 49 BA AA AA AA AA AA AA 0A 00 19 C9 49 21 D2 F7 D1 83 E1 02 44 01 C9 49 B9 55 55 55 55 55 55 05 00 4C 21 CA 45 31 C9 49 39 D2 BA D9 FB FF FF 41 0F 96 C1 45 31 DB 41 01 C9 41 8D 49 F5 44 29 CA 44 8D 4A C4 49 D3 E0 4C 89 C1 4C 8B 05 ?? ?? ?? ?? 48 C1 E1 04 49 89 CA 41 83 08 02 45 85 C9 41 B8 3C 00 00 00 0F 8F 8C 01 00 00 45 01 C8 44 89 C1 F7 D9 85 C9 0F 8E 4E 05 00 00 83 F9 30 0F 8F 73 01 00 00 48 63 D1 48 8D 0D ?? ?? ?? ?? 48 89 D3 48 C1 E3 04 48 01 CB 41 8D 4B 04 4D 89 D3 48 8B 33 49 D3 EB 48 83 7B 08 00 75 09 49 39 F3 0F 87 42 01 00 00 48 C1 E2 04 45 89 DA 49 C1 EB 20 48 89 D1 48 8D 15 ?? ?? ?? ?? 48 8B 14 0A 4C 89 D1 41 89 D1 48 C1 EA 20 49 0F AF C9 49 0F AF D2 45 0F AF D9 49 89 C9 89 C9 49 C1 E9 20 4D 01 CB 4C 01 DA 48 C1 E2 20 48 01 CA 48 B9 FF FF FF FF FF FF 1F 00 48 39 CA 0F 87 10 05 00 00 41 81 C0 8E 01 00 00 48 C1 E0 3F 49 C1 E0 35 4C 01 C0 48 01 D0 E9 51 03 00 00 41 81 F9 FF 07 00 00 0F 84 73 03 00 00 48 B9 00 00 00 00 00 00 10 00 4C 01 C1 48 89 CA 48 F7 DA 48 21 CA 41 89 D0 49 83 F8 01 49 B8 FF FF 00 00 FF FF 00 00 19 DB 49 21 D0 83 E3 20 49 83 F8 01 49 B8 FF 00 FF 00 FF 00 FF 00 45 19 DB 49 21 D0 41 83 E3 10 44 01 DB 49 83 F8 01 49 B8 0F 0F 0F 0F 0F 0F 0F 0F 45 19 DB 49 21 D0 41 83 E3 08 44 01 DB 49 83 F8 01 49 B8 33 33 33 33 33 33 33 33 45 19 DB 49 21 D0 41 83 E3 04 44 01 DB 49 83 F8 01 49 B8 55 55 55 55 55 55 55 55 45 19 DB 41 83 E3 02 41 01 DB 4C 85 C2 0F 94 C2 48 C1 E1 04 0F B6 D2 49 89 CA 41 01 D3 41 8D 91 CD FB FF FF 45 8D 43 3C 44 8D 4A C4 45 85 C9 0F 8E 74 FE FF FF 4D 63 C9 48 8D 15 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 49 81 C1 9D 05 00 00 4C 89 C9 42 8B 14 8A 49 C1 E1 05 48 C1 E1 04 4D 3B 54 08 08 0F 86 1F 03 00 00 48 8D 0D ?? ?? ?? ?? 83 C2 01 4C 01 C9 4C 8B 21 48 8B 59 08 4C 8B 49 10 4C 8B 41 18 4C 89 E6 4D 89 D3 45 89 E4 44 89 D1 49 C1 EB 20 4C 89 E7 49 0F AF FB 48 89 DD 89 DB 4C 0F AF E1 48 C1 ED 20 49 89 DD 48 0F AF D9 48 C1 EE 20 4D 89 CE 45 89 C9 49 89 F7 49 C1 EE 20 41 89 FA 4C 89 7C 24 08 4C 89 C6 49 C1 EC 20 45 89 C0 48 C1 EE 20 4D 01 E2 4C 89 54 24 20 49 89 EA 4D 0F AF D3 4D 0F AF EB 48 0F AF E9 4C 89 54 24 18 49 89 DA 89 DB 45 89 EC 49 C1 EA 20 4D 01 E2 4D 89 F4 49 01 EA 4C 89 D5 48 C1 E5 20 48 01 EB 4C 89 CD 4C 0F AF C9 48 89 5C 24 28 4D 0F AF FB 49 0F AF EB 4C 89 CB 45 89 C9 4C 89 7C 24 10 48 C1 EB 20 4C 0F AF F1 41 89 EF 48 C1 ED 20 4D 0F AF E3 4C 01 FB 4C 01 F3 49 01 EC 48 89 DD 48 C1 ED 20 49 01 EC 4C 89 C5 4C 0F AF C1 49 0F AF EB 4C 0F AF DE 4D 89 C6 45 89 C0 49 C1 EE 20 41 89 EF 48 C1 ED 20 48 0F AF F1 4D 01 FE 49 01 EB 48 C1 EF 20 49 01 F6 4C 89 F5 49 C1 E6 20 4D 01 C6 4C 8B 44 24 10 48 C1 ED 20 49 01 EB 49 01 F8 48 8B 7C 24 08 48 0F AF F9 48 8B 4C 24 28 48 03 7C 24 20 48 C1 EF 20 4C 01 C7 48 01 F9 0F 92 C1 49 C1 ED 20 4C 03 6C 24 18 48 C1 E3 20 49 C1 EA 20 0F B6 C9 49 01 D9 49 01 C9 4D 01 EA 4D 01 CA 0F 82 B0 00 00 00 4C 39 C9 0F 87 A7 00 00 00 31 C9 4D 01 E6 0F 92 C1 49 01 CB 48 8B 0D ?? ?? ?? ?? 4D 89 D9 41 83 E1 01 44 8B 01 42 8D 0C 85 00 00 00 00 8D 0C 41 4C 01 C9 4C 8D 0D ?? ?? ?? ?? 48 C1 E1 04 4C 01 C9 4C 3B 71 08 0F 86 97 00 00 00 49 83 C3 01 48 B9 00 00 C1 6F F2 86 23 00 49 39 CB 0F 84 AE 01 00 00 81 FA FF 02 00 00 0F 8F 52 01 00 00 4D 85 F6 0F 85 E9 00 00 00 4D 85 D2 0F 85 E0 00 00 00 48 B9 FF FF FF FF FF FF 1F 00 49 39 CB 0F 86 FB 00 00 00 48 C1 E0 3F 48 B9 00 00 00 00 00 00 E0 5F 48 C1 E2 33 48 01 C8 4C 01 D8 48 01 D0 EB 21 49 83 C6 01 E9 50 FF FF FF 0F 1F 80 00 00 00 00 48 C1 E0 3F 48 B9 00 00 00 00 00 00 C0 31 48 01 C8 48 83 C4 38 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 85 7A FF FF FF 4C 3B 11 0F 86 71 FF FF FF E9 55 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 4D 85 C0 0F 84 D5 00 00 00 48 B9 00 00 00 00 00 00 08 00 48 85 CA 75 0A 48 8B 15 ?? ?? ?? ?? 83 0A 01 49 C1 E0 0D 48 BA FF 7F C6 A4 7E 8D 03 00 48 C1 E0 3F 49 C1 E8 0E 48 B9 00 00 00 00 00 00 00 7C 49 39 D0 BA 00 00 00 00 4C 0F 47 C2 48 01 C8 4C 01 C0 E9 78 FF FF FF 0F 1F 80 00 00 00 00 48 8B 0D ?? ?? ?? ?? 44 8B 01 45 89 C1 41 83 C9 20 44 89 09 49 B9 FF 7F C6 A4 7E 8D 03 00 4D 39 CB 0F 87 F9 FE FF FF 41 83 C8 30 44 89 01 48 C1 E0 3F 48 C1 E2 35 4C 01 D8 48 01 D0 E9 30 FF FF FF 48 8D 0D ?? ?? ?? ?? 4C 01 C9 4C 8B 21 48 8B 59 08 4C 8B 49 10 4C 8B 41 18 E9 DF FC FF FF 90 48 8B 15 ?? ?? ?? ?? 83 0A 28 41 83 F8 03 74 24 48 83 F8 01 19 D2 83 C2 02 44 39 C2 74 16 48 C1 E0 3F 48 B9 00 00 00 00 00 00 00 78 48 01 C8 E9 DD FE FF FF 48 C1 E0 3F 48 B9 FF FF C0 6F F2 86 FB 77 48 01 C8 E9 C7 FE FF FF 66 0F 1F 44 00 00 83 C2 01 49 BB 00 80 C6 A4 7E 8D 03 00 E9 40 FE FF FF B9 44 00 00 00 29 D1 83 F9 3F 7E 6F B9 04 00 00 00 29 D1 4C 89 D2 48 D3 EA 48 B9 FF FF C0 6F F2 86 23 00 48 39 CA 0F 87 02 FC FF FF 48 B9 FF FF FF FF FF FF 1F 00 48 C1 E0 3F 48 39 CA 77 56 48 B9 00 00 00 00 00 00 C0 31 48 01 C8 48 01 D0 E9 5B FE FF FF 48 C1 E0 3F 48 B9 00 00 00 00 00 00 E0 5F 41 81 C0 8E 01 00 00 48 01 C8 49 C1 E0 33 4C 01 C0 48 01 D0 E9 34 FE FF FF 4C 89 D6 48 D3 EE 48 85 F6 0F 85 A4 FB FF FF 8D 4A FC 4C 89 D2 48 D3 E2 EB 84 48 B9 00 00 00 00 00 00 50 6C 48 01 C8 48 01 D0 E9 05 FE FF FF 0F 1F 40 00 }
	condition:
		$1
}

rule file_174_18_0 {
	meta:
		name = "__binary80_to_bid64"
		size = 2736
		refs = "0142 .refptr.__bid_IDEC_glbflags 0173 .refptr.__bid_IDEC_glbround 01fd .rdata"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 DB 29 DB 7C 24 50 0F B7 44 24 52 48 C1 E0 10 49 89 C0 0F B7 44 24 54 48 C1 E0 20 4C 01 C0 44 0F B7 44 24 50 4C 01 C0 44 0F B7 44 24 56 49 C1 E0 30 49 01 C0 0F B7 44 24 58 0F B7 D0 C1 FA 0F 66 25 FF 7F 0F 85 57 01 00 00 4D 85 C0 0F 84 01 02 00 00 48 B8 00 00 00 00 FF FF FF FF 44 89 C1 49 B9 FF FF 00 00 FF FF 00 00 4C 21 C0 48 39 C1 48 B8 00 00 FF FF 00 00 FF FF 19 C9 4C 21 C0 4D 21 C1 F7 D1 83 E1 20 49 39 C1 49 B9 FF 00 FF 00 FF 00 FF 00 19 C0 4D 21 C1 F7 D0 83 E0 10 01 C1 48 B8 00 FF 00 FF 00 FF 00 FF 4C 21 C0 49 39 C1 49 B9 0F 0F 0F 0F 0F 0F 0F 0F 19 C0 4D 21 C1 F7 D0 83 E0 08 01 C1 48 B8 F0 F0 F0 F0 F0 F0 F0 F0 4C 21 C0 49 39 C1 49 B9 33 33 33 33 33 33 33 33 19 C0 4D 21 C1 F7 D0 83 E0 04 01 C1 48 B8 CC CC CC CC CC CC CC CC 4C 21 C0 49 39 C1 49 B9 AA AA AA AA AA AA AA AA 19 C0 4D 21 C1 F7 D0 83 E0 02 01 C8 48 B9 55 55 55 55 55 55 55 55 4C 21 C1 49 39 C9 41 B9 C3 BF FF FF 0F 96 C1 0F B6 C9 01 C1 48 8B 05 ?? ?? ?? ?? 41 29 C9 49 D3 E0 B9 31 00 00 00 41 8D 71 CF 83 08 02 31 C0 81 FE 8F 04 00 00 0F 8E 7E 00 00 00 48 8B 05 ?? ?? ?? ?? 83 08 28 48 8B 05 ?? ?? ?? ?? 8B 08 83 F9 03 0F 84 50 05 00 00 83 FA 01 19 C0 83 C0 02 39 C8 0F 84 40 05 00 00 48 63 C2 48 B9 00 00 00 00 00 00 00 78 48 C1 E0 3F 48 8D 04 08 E9 CC 00 00 00 0F 1F 40 00 66 3D FF 7F 44 0F B7 C8 0F 84 72 01 00 00 4D 85 C0 0F 85 C9 00 00 00 B9 71 00 00 00 B8 40 00 00 00 41 81 E9 3E 40 00 00 41 8D 71 CF 81 FE 8F 04 00 00 7F 82 4C 89 C3 49 C1 E8 07 48 C1 E3 39 85 F6 0F 8E 7A 06 00 00 48 63 C6 48 8D 0D ?? ?? ?? ?? 48 05 9D 05 00 00 49 89 C1 49 C1 E1 04 4C 01 C9 4C 8D 0D ?? ?? ?? ?? 4D 8D 0C 81 48 C1 E0 05 4C 8B 11 48 8B 49 08 41 8B 39 49 39 C8 89 7C 24 04 72 12 4C 39 D3 0F 87 5A 01 00 00 49 39 C8 0F 85 51 01 00 00 48 8D 0D ?? ?? ?? ?? 48 01 C8 4C 8B 10 4C 8B 48 08 4C 8B 58 10 4C 8B 68 18 E9 51 01 00 00 48 63 C2 48 B9 00 00 00 00 00 00 C0 31 48 C1 E0 3F 48 8D 04 08 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 4C 89 C0 48 F7 D8 4C 21 C0 89 C1 48 83 F9 01 48 B9 FF FF 00 00 FF FF 00 00 45 19 D2 48 21 C1 41 83 E2 20 48 83 F9 01 19 C9 83 E1 10 41 01 CA 48 B9 FF 00 FF 00 FF 00 FF 00 48 21 C1 48 83 F9 01 19 C9 83 E1 08 41 01 CA 48 B9 0F 0F 0F 0F 0F 0F 0F 0F 48 21 C1 48 83 F9 01 19 C9 83 E1 04 41 01 CA 48 B9 33 33 33 33 33 33 33 33 48 21 C1 48 83 F9 01 19 C9 83 E1 02 44 01 D1 49 BA 55 55 55 55 55 55 55 55 4C 85 D0 0F 94 C0 0F B6 C0 01 C8 8D 48 31 E9 AA FE FF FF 66 0F 1F 84 00 00 00 00 00 48 B8 FF FF FF FF FF FF FF 7F 49 85 C0 0F 84 4F FE FF FF 48 B8 00 00 00 00 00 00 00 40 49 85 C0 75 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 49 C1 E0 02 48 63 C2 48 BA FF 7F C6 A4 7E 8D 03 00 49 C1 E8 0E 48 C1 E0 3F 48 B9 00 00 00 00 00 00 00 7C 49 39 D0 BA 00 00 00 00 4C 0F 47 C2 48 01 C8 4C 01 C0 E9 E2 FE FF FF 48 8D 0D ?? ?? ?? ?? 83 44 24 04 01 48 01 C8 4C 8B 10 4C 8B 48 08 4C 8B 58 10 4C 8B 68 18 4C 89 CD 45 89 C9 48 C1 EB 20 4D 89 CC 4C 89 D0 48 C1 ED 20 4C 0F AF E3 48 C1 E8 20 48 89 EE 49 89 C7 48 89 D9 45 89 D2 48 0F AF F3 4C 89 E7 48 C1 E7 20 4C 0F AF FB 4C 89 DB 48 89 7C 24 20 48 C1 EB 20 44 89 DF 48 89 74 24 18 49 89 DE 48 89 5C 24 28 48 89 FB 4D 89 F3 48 0F AF D9 4C 0F AF D9 49 89 DE 49 C1 EE 20 4B 8D 34 1E 4D 89 EE 49 C1 EE 20 48 89 74 24 10 4C 89 74 24 08 4C 89 F6 45 89 EE 49 89 F5 4D 89 F3 4C 0F AF D9 4C 0F AF E9 49 0F AF CA 4C 89 DE 49 C1 E3 20 48 C1 EE 20 48 C1 E9 20 49 01 F5 4C 01 F9 48 03 4C 24 20 48 89 4C 24 20 0F 92 C1 49 C1 EC 20 4C 03 64 24 18 48 C1 E3 20 0F B6 C9 48 01 CB 49 01 DC 4C 89 64 24 30 0F 82 B4 02 00 00 48 39 D9 0F 87 AB 02 00 00 4C 03 5C 24 10 48 89 C6 41 0F 92 C7 4C 89 5C 24 10 4D 89 C3 45 0F B6 FF 45 89 C0 49 C1 EB 20 4B 8D 5C 3D 00 4C 8B 7C 24 28 49 0F AF F3 48 89 5C 24 18 4C 89 D3 4D 0F AF D0 4D 89 FC 49 0F AF DB 48 89 74 24 38 49 0F AF C0 4C 89 D1 45 89 D2 48 C1 E9 20 89 DE 48 01 F1 4C 89 CE 48 01 C8 48 89 C1 48 C1 E1 20 4C 01 D1 48 89 4C 24 40 48 89 E9 49 0F AF CB 4D 0F AF C8 49 0F AF F3 48 89 4C 24 48 4C 89 C9 45 89 C9 41 89 F2 48 C1 E9 20 4C 01 D1 49 89 EA 48 89 FD 4D 0F AF D0 49 0F AF EB 49 0F AF F8 4C 01 D1 49 89 CA 41 89 ED 48 C1 ED 20 49 C1 E2 20 4D 01 D1 49 89 FA 48 C1 EF 20 4C 01 EF 4D 89 FD 45 89 D2 4D 0F AF E8 4D 0F AF E3 4C 01 EF 4D 89 F5 4D 0F AF E8 49 89 FF 49 01 EC 49 C1 EF 20 4C 89 F5 4D 01 E7 4D 89 EC 45 89 ED 49 0F AF EB 4C 0F AF 5C 24 08 49 C1 EC 20 48 C1 EB 20 48 03 5C 24 38 4C 0F AF 44 24 08 41 89 EE 48 C1 ED 20 48 C1 E8 20 4D 01 F4 48 01 C3 31 C0 49 01 EB 4D 01 E0 4C 89 C5 49 C1 E0 20 48 C1 ED 20 4D 01 E8 49 01 EB 49 01 D9 0F 92 C0 48 C1 EE 20 48 03 74 24 48 48 C1 E7 20 48 C1 E9 20 4C 01 D7 48 01 C7 48 01 CE 48 01 FE 0F 82 2C 01 00 00 48 39 F8 0F 87 23 01 00 00 31 C9 4D 01 C7 0F 92 C1 48 8B 44 24 40 48 03 44 24 20 4D 8D 14 0B 48 8B 7C 24 30 0F 92 C0 0F B6 C0 49 01 C1 4C 01 CF 0F 82 C6 00 00 00 4C 39 C8 0F 87 BD 00 00 00 4C 8B 5C 24 10 45 31 C0 49 01 F3 41 0F 92 C0 4C 8B 6C 24 18 4D 01 C7 4D 01 FD 41 0F 92 C1 4D 39 C7 0F 92 C0 41 09 C1 45 0F B6 C9 48 8B 05 ?? ?? ?? ?? 4B 8D 0C 0A 49 89 C8 8B 00 41 83 E0 01 44 8D 0C 85 00 00 00 00 45 8D 0C 51 4D 01 C1 4C 8D 05 ?? ?? ?? ?? 49 C1 E1 04 4D 01 C1 4D 8B 41 08 4D 39 E8 0F 82 C4 00 00 00 4D 39 C5 0F 84 AB 00 00 00 81 7C 24 04 FF 02 00 00 0F 8E 7D 01 00 00 48 8B 0D ?? ?? ?? ?? 83 09 28 83 F8 03 74 10 83 FA 01 19 C9 83 C1 02 39 C1 0F 85 C0 FA FF FF 48 63 C2 48 B9 FF FF C0 6F F2 86 FB 77 48 C1 E0 3F 48 8D 04 08 E9 8C FB FF FF 0F 1F 40 00 4C 8B 5C 24 10 48 83 C6 01 49 01 F3 0F 82 1E 01 00 00 48 85 F6 0F 84 15 01 00 00 4C 8B 6C 24 18 45 31 C9 4D 01 FD 41 0F 92 C1 E9 3F FF FF FF 90 49 83 C0 01 4D 01 C7 0F 92 C1 4D 85 C0 0F 94 C0 09 C1 0F B6 C9 E9 CB FE FF FF 66 0F 1F 44 00 00 49 83 C3 01 E9 4C FD FF FF 0F 1F 80 00 00 00 00 4D 39 19 0F 83 4C FF FF FF 0F 1F 80 00 00 00 00 48 83 C1 01 49 B8 00 00 C1 6F F2 86 23 00 4C 39 C1 0F 84 0D 02 00 00 49 B8 00 80 C6 A4 7E 8D 03 00 4C 39 C1 0F 85 1B FF FF FF 44 8B 44 24 04 45 85 C0 0F 85 0D FF FF FF 48 B9 33 33 33 33 33 33 33 F3 49 39 CD 0F 87 B6 01 00 00 A8 03 0F 85 AE 01 00 00 48 8B 05 ?? ?? ?? ?? 83 08 10 4C 89 D8 4C 09 E8 0F 84 D7 01 00 00 4C 8B 0D ?? ?? ?? ?? 31 C0 48 B9 00 80 C6 A4 7E 8D 03 00 45 8B 01 90 41 83 C8 20 45 89 01 49 B8 FF FF FF FF FF FF 1F 00 4C 39 C1 0F 86 AC 02 00 00 48 63 D2 49 B8 00 00 00 00 00 00 E0 5F 48 C1 E0 33 48 C1 E2 3F 4C 01 C2 48 01 D1 48 01 C8 E9 5B FA FF FF 0F 1F 00 41 B8 01 00 00 00 E9 17 FE FF FF 0F 1F 44 00 00 4D 09 EB 48 63 44 24 04 74 AD 4C 8B 0D ?? ?? ?? ?? 49 BA FF 7F C6 A4 7E 8D 03 00 4C 39 D1 45 8B 01 77 8D 41 83 C8 30 48 C1 E0 35 45 89 01 48 01 C1 48 63 C2 48 C1 E0 3F 48 8D 04 01 E9 07 FA FF FF 44 8D 1C 0E 45 89 DA 41 F7 DA 45 85 D2 0F 8E 2C 01 00 00 41 83 FA 30 0F 8F B2 00 00 00 4D 63 D2 4C 8D 0D ?? ?? ?? ?? 4C 89 D7 48 C1 E7 04 49 01 F9 83 F9 37 49 8B 29 49 8B 79 08 0F 8E 5F 01 00 00 8D 48 F9 4D 89 C1 31 C0 49 D3 E9 48 39 C7 77 07 75 7C 4C 39 CD 72 77 48 8D 05 ?? ?? ?? ?? 49 C1 E2 04 44 89 CB 49 89 D8 4C 89 C9 4A 8B 04 10 48 C1 E9 20 41 89 C2 48 C1 E8 20 4D 0F AF C2 48 0F AF C3 41 0F AF CA 4D 89 C2 45 89 C0 49 C1 EA 20 4C 01 D1 48 01 C8 48 B9 FF FF FF FF FF FF 1F 00 48 C1 E0 20 4C 01 C0 48 39 C8 0F 87 1E 01 00 00 41 81 C3 8E 01 00 00 48 63 D2 49 C1 E3 35 48 C1 E2 3F 4C 01 DA 48 01 D0 E9 39 F9 FF FF 90 81 FE 64 FA FF FF 0F 8D AB F8 FF FF 31 C0 4C 8D 0D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E9 BF F8 FF FF 01 D0 83 F8 02 0F 85 51 FE FF FF 48 B8 66 66 66 66 66 66 66 E6 49 39 C5 0F 87 3E FE FF FF E9 2F FE FF FF 83 44 24 04 01 48 B9 00 80 C6 A4 7E 8D 03 00 E9 0D FD FF FF 0F 1F 84 00 00 00 00 00 48 B9 00 80 C6 A4 7E 8D 03 00 E9 AF FE FF FF 90 B9 39 00 00 00 44 29 C9 83 F9 3F 0F 8E A9 00 00 00 B9 F9 FF FF FF 4C 89 C0 44 29 C9 48 D3 E8 48 B9 FF FF C0 6F F2 86 23 00 48 39 C8 0F 87 5E FF FF FF 48 B9 FF FF FF FF FF FF 1F 00 48 63 D2 48 C1 E2 3F 48 39 C8 0F 87 95 00 00 00 48 B9 00 00 00 00 00 00 C0 31 48 01 CA 48 01 D0 E9 67 F8 FF FF 44 8D 68 39 49 89 D9 41 BC 07 00 00 00 44 89 E9 49 D3 E9 44 89 E1 29 C1 4C 89 C0 48 D3 E0 44 89 E9 49 01 C1 4C 89 C0 48 D3 E8 E9 7D FE FF FF 48 63 D2 48 B9 00 00 00 00 00 00 E0 5F 48 C1 E2 3F 48 01 D1 41 8D 93 8E 01 00 00 48 C1 E2 33 48 01 CA 48 01 D0 E9 0E F8 FF FF 4C 89 C0 48 D3 E8 48 85 C0 0F 85 C7 FE FF FF 49 89 DA 4C 89 C0 49 D3 EA 41 8D 49 07 48 D3 E0 4C 01 D0 E9 3E FF FF FF 48 B9 00 00 00 00 00 00 50 6C 48 01 CA 48 01 D0 E9 D2 F7 FF FF 48 C1 E0 35 E9 AF FD FF FF 90 }
	condition:
		$1
}

rule file_174_19_0 {
	meta:
		name = "__binary128_to_bid64"
		size = 3472
		refs = "014f .refptr.__bid_IDEC_glbflags 0186 .rdata 0319 .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 68 48 8B 11 48 8B 49 08 49 B9 FF FF FF FF FF FF 00 00 49 89 C8 48 89 C8 49 21 C9 49 C1 E8 30 48 C1 E8 3F 41 81 E0 FF 7F 00 00 0F 85 03 02 00 00 4D 85 C9 0F 84 18 03 00 00 49 B8 00 00 00 00 FF FF 00 00 41 89 CA 49 89 CB 49 21 C8 4D 39 C2 49 B8 FF FF 00 00 FF FF 00 00 45 19 D2 49 21 C8 41 81 E3 00 00 FF FF 41 F7 D2 41 83 E2 20 4D 39 D8 49 BB FF 00 FF 00 FF 00 00 00 45 19 C0 49 21 CB 41 F7 D0 41 83 E0 10 45 01 C2 49 B8 00 FF 00 FF 00 FF 00 00 49 21 C8 4D 39 C3 49 BB 0F 0F 0F 0F 0F 0F 00 00 45 19 C0 49 21 CB 41 F7 D0 41 83 E0 08 45 01 C2 49 B8 F0 F0 F0 F0 F0 F0 00 00 49 21 C8 4D 39 C3 49 BB 33 33 33 33 33 33 00 00 45 19 C0 49 21 CB 41 F7 D0 41 83 E0 04 45 01 C2 49 B8 CC CC CC CC CC CC 00 00 49 21 C8 4D 39 C3 49 BB AA AA AA AA AA AA 00 00 45 19 C0 49 21 CB 41 F7 D0 41 83 E0 02 45 01 D0 49 BA 55 55 55 55 55 55 00 00 4C 21 D1 49 39 CB 0F 96 C1 0F B6 C9 45 8D 54 08 F1 45 85 D2 0F 85 1C 03 00 00 49 89 D3 41 B8 92 BF FF FF 48 C1 E2 08 49 C1 EB 38 48 8B 0D ?? ?? ?? ?? 49 C1 E1 08 45 31 D2 4B 8D 3C 19 83 09 02 48 89 7C 24 08 47 8D 1C 10 44 89 D9 F7 D9 85 C9 0F 8E 09 0B 00 00 83 F9 30 0F 8F 30 04 00 00 4C 63 C9 48 8D 0D ?? ?? ?? ?? 4C 89 CB 48 C1 E3 04 48 01 D9 41 83 FA 37 48 8B 39 48 8B 59 08 0F 8E 3E 0B 00 00 41 8D 4A C8 4C 8B 54 24 08 49 D3 EA 31 C9 48 39 CB 77 18 0F 85 F2 03 00 00 4C 39 D7 0F 82 E9 03 00 00 66 0F 1F 84 00 00 00 00 00 4C 89 C9 48 8D 15 ?? ?? ?? ?? 45 89 D1 48 C1 E1 04 49 C1 EA 20 48 8B 0C 0A 4C 89 CA 41 89 C8 48 C1 E9 20 49 0F AF D0 49 0F AF C9 45 0F AF D0 49 89 D0 89 D2 49 C1 E8 20 4D 01 C2 4C 01 D1 48 C1 E1 20 48 01 CA 48 B9 FF FF FF FF FF FF 1F 00 48 39 CA 0F 87 F0 0A 00 00 41 81 C3 8E 01 00 00 48 C1 E0 3F 49 C1 E3 35 4C 01 D8 48 01 D0 E9 07 01 00 00 41 81 F8 FF 7F 00 00 0F 84 E1 02 00 00 48 B9 00 00 00 00 00 00 01 00 49 01 C9 48 85 D2 0F 84 2B 02 00 00 49 89 D3 49 F7 DB 49 21 D3 44 89 D9 48 83 F9 01 48 B9 FF FF 00 00 FF FF 00 00 45 19 D2 4C 21 D9 41 83 E2 20 48 83 F9 01 19 C9 83 E1 10 41 01 CA 48 B9 FF 00 FF 00 FF 00 FF 00 4C 21 D9 48 83 F9 01 19 C9 83 E1 08 41 01 CA 48 B9 0F 0F 0F 0F 0F 0F 0F 0F 4C 21 D9 48 83 F9 01 19 C9 83 E1 04 41 01 CA 48 B9 33 33 33 33 33 33 33 33 4C 21 D9 48 83 F9 01 19 C9 83 E1 02 44 01 D1 49 BA 55 55 55 55 55 55 55 55 4D 85 D3 41 0F 94 C2 45 0F B6 D2 41 01 CA 41 81 E8 6F 40 00 00 41 81 F8 8F 04 00 00 0F 8E 8F 08 00 00 48 8B 15 ?? ?? ?? ?? 83 0A 28 48 8B 15 ?? ?? ?? ?? 8B 0A 83 F9 03 0F 84 18 07 00 00 83 F8 01 19 D2 83 C2 02 39 CA 0F 84 08 07 00 00 48 C1 E0 3F 48 BA 00 00 00 00 00 00 00 78 48 01 D0 48 83 C4 68 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 48 85 D2 0F 84 2A 02 00 00 48 B9 00 00 00 00 FF FF FF FF 41 89 D0 49 BA FF FF 00 00 FF FF 00 00 48 21 D1 49 39 C8 48 B9 00 00 FF FF 00 00 FF FF 45 19 C0 48 21 D1 49 21 D2 41 F7 D0 41 83 E0 20 49 39 CA 49 BA FF 00 FF 00 FF 00 FF 00 19 C9 49 21 D2 F7 D1 83 E1 10 41 01 C8 48 B9 00 FF 00 FF 00 FF 00 FF 48 21 D1 49 39 CA 49 BA 0F 0F 0F 0F 0F 0F 0F 0F 19 C9 49 21 D2 F7 D1 83 E1 08 41 01 C8 48 B9 F0 F0 F0 F0 F0 F0 F0 F0 48 21 D1 49 39 CA 49 BA 33 33 33 33 33 33 33 33 19 C9 49 21 D2 F7 D1 83 E1 04 41 01 C8 48 B9 CC CC CC CC CC CC CC CC 48 21 D1 49 39 CA 49 BA AA AA AA AA AA AA AA AA 19 C9 49 21 D2 45 31 DB F7 D1 83 E1 02 44 01 C1 49 B8 55 55 55 55 55 55 55 55 49 21 D0 4D 39 C2 41 0F 96 C3 41 01 CB 45 8D 53 31 41 83 FA 3F 0F 8F EB 07 00 00 44 89 D1 48 89 D6 41 B8 92 BF FF FF 49 D3 E1 B9 40 00 00 00 45 29 D0 44 29 D1 48 D3 EE 44 89 D1 48 D3 E2 49 01 F1 49 89 D3 48 C1 E2 08 49 C1 EB 38 E9 BF FC FF FF 0F 1F 00 4C 89 C9 48 F7 D9 4C 21 C9 41 89 CA 49 83 FA 01 49 BA FF FF 00 00 FF FF 00 00 45 19 DB 49 21 CA 41 83 E3 20 49 83 FA 01 45 19 D2 41 83 E2 10 45 01 D3 49 BA FF 00 FF 00 FF 00 FF 00 49 21 CA 49 83 FA 01 45 19 D2 41 83 E2 08 45 01 D3 49 BA 0F 0F 0F 0F 0F 0F 0F 0F 49 21 CA 49 83 FA 01 45 19 D2 41 83 E2 04 45 01 D3 49 BA 33 33 33 33 33 33 33 33 49 21 CA 49 83 FA 01 45 19 D2 41 83 E2 02 45 01 DA 49 BB 55 55 55 55 55 55 55 55 4C 85 D9 0F 94 C1 0F B6 C9 45 8D 54 0A 40 E9 C8 FD FF FF 4C 89 CF 48 09 D7 0F 84 FC FD FF FF 49 B8 00 00 00 00 00 80 00 00 4C 85 C1 75 0A 48 8B 0D ?? ?? ?? ?? 83 09 01 49 C1 E1 11 48 C1 EA 2F 48 B9 FF 7F C6 A4 7E 8D 03 00 4C 01 CA 48 C1 E0 3F 48 C1 EA 0E 48 39 CA B9 00 00 00 00 48 0F 47 D1 48 B9 00 00 00 00 00 00 00 7C 48 01 C8 48 01 D0 E9 B6 FD FF FF 48 C1 E0 3F 48 BA 00 00 00 00 00 00 C0 31 48 01 D0 E9 A0 FD FF FF 0F 1F 80 00 00 00 00 41 81 F8 64 FA FF FF 0F 8D FF 05 00 00 4C 8D 0D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 45 31 C0 4C 8B 11 48 8B 49 08 48 3B 4C 24 08 41 8B 39 89 7C 24 14 77 0D 49 39 D2 72 28 48 3B 4C 24 08 75 21 90 48 8D 0D ?? ?? ?? ?? 49 01 C8 4D 8B 18 4D 8B 50 08 4D 8B 48 10 49 8B 48 18 EB 23 0F 1F 44 00 00 48 8D 0D ?? ?? ?? ?? 83 44 24 14 01 49 01 C8 4D 8B 18 4D 8B 50 08 4D 8B 48 10 49 8B 48 18 4D 89 D8 48 89 D6 45 89 DB 49 C1 E8 20 48 C1 EE 20 89 D2 4C 89 C3 4D 89 DC 48 0F AF DE 4C 0F AF E6 48 89 5C 24 28 4C 89 DB 48 0F AF DA 44 89 E7 48 C1 EB 20 48 01 DF 48 89 7C 24 40 4C 89 D7 45 89 D2 4C 89 D3 48 C1 EF 20 4C 89 D5 48 0F AF DE 49 89 FF 48 89 7C 24 30 48 0F AF EA 49 89 DE 48 89 FB 48 0F AF DE 4C 89 74 24 18 48 89 5C 24 38 48 89 EB 8B 6C 24 18 49 89 DD 89 DB 49 C1 ED 20 4C 89 EF 48 01 EF 4C 89 FD 48 0F AF EA 4C 8D 3C 2F 4C 89 FD 4C 89 7C 24 48 4D 89 CF 48 C1 E5 20 45 89 C9 49 C1 EF 20 4C 8D 6C 1D 00 4D 89 CE 4C 89 7C 24 58 4C 0F AF F2 4C 89 6C 24 50 4D 89 CD 4C 0F AF EE 4C 89 F7 48 89 FD 89 FF 4C 89 EB 48 C1 ED 20 4D 89 FD 41 89 DE 48 C1 EB 20 4C 01 F5 4D 89 FE 4C 0F AF F2 4C 0F AF EE 4C 01 F5 49 89 EF 49 01 DD 49 C1 EF 20 4F 8D 74 3D 00 49 89 CF 89 C9 49 89 CD 49 C1 EF 20 4C 89 74 24 20 49 89 CE 4C 89 3C 24 4C 0F AF F6 4C 0F AF EA 49 0F AF F7 45 89 F7 4C 89 EB 49 C1 ED 20 4D 01 EF 4C 8B 2C 24 89 DB 4C 0F AF EA 4D 01 FD 49 C1 EC 20 4C 03 64 24 28 49 0F AF D0 49 C1 EE 20 48 03 54 24 40 4C 01 F6 4D 89 EE 49 C1 EE 20 49 C1 E5 20 49 01 DD 4C 01 F6 48 8B 5C 24 18 48 C1 EA 20 49 01 D4 4C 03 64 24 50 0F 92 C2 48 C1 E5 20 48 C1 EB 20 48 01 FD 48 03 5C 24 38 48 8B 7C 24 48 0F B6 D2 4C 89 64 24 28 48 01 D5 48 C1 EF 20 48 01 FB 48 01 EB 48 89 5C 24 38 0F 82 D4 02 00 00 48 39 EA 0F 87 CB 02 00 00 4C 8B 7C 24 20 45 31 F6 4C 89 DD 4D 01 EF 41 0F 92 C6 4A 8D 1C 36 48 8B 74 24 08 4C 8B 74 24 30 48 89 5C 24 18 48 89 F7 89 F3 4C 89 C6 48 C1 EF 20 4C 0F AF DB 48 0F AF EF 48 0F AF F7 4C 89 DA 45 89 DB 48 C1 EA 20 4C 0F AF C3 48 89 74 24 08 89 EE 48 01 F2 4C 89 F6 48 0F AF F7 49 01 D0 4C 89 C2 48 C1 E2 20 48 89 74 24 30 4C 01 DA 4D 89 D3 4C 0F AF D3 48 89 54 24 20 4C 0F AF DF 4C 89 D2 45 89 D2 44 89 DE 48 C1 EA 20 48 01 F2 4C 89 F6 48 0F AF F3 48 01 F2 49 89 D6 49 C1 E6 20 4D 01 F2 4D 89 CE 4C 0F AF CB 4C 89 54 24 40 4C 8B 54 24 58 4C 0F AF F7 4D 89 D5 4D 89 CC 45 89 C9 4C 89 F6 49 C1 EC 20 45 89 F6 4D 01 F4 4D 89 D6 48 C1 EE 20 4C 0F AF F3 4C 0F AF EF 4D 01 F4 4D 89 E6 49 01 F5 49 C1 EE 20 4C 89 F6 4C 01 EE 49 89 CD 48 0F AF CB 4C 0F AF EF 48 0F AF 3C 24 49 89 CE 89 C9 49 C1 EE 20 45 89 EA 48 C1 ED 20 48 0F AF 1C 24 48 03 6C 24 08 4D 01 D6 49 C1 ED 20 4C 8B 54 24 40 49 C1 E8 20 4C 01 EF 4C 01 C5 49 01 DE 4D 89 F5 49 C1 E6 20 49 C1 ED 20 49 01 CE 31 C9 4C 01 EF 49 01 EA 0F 92 C1 49 C1 EB 20 4C 03 5C 24 30 49 C1 E4 20 48 C1 EA 20 4D 01 CC 49 01 CC 49 01 D3 4D 01 E3 0F 82 3D 01 00 00 4C 39 E1 0F 87 34 01 00 00 45 31 ED 4C 01 F6 41 0F 92 C5 66 2E 0F 1F 84 00 00 00 00 00 48 8B 5C 24 28 31 D2 4C 01 EF 48 03 5C 24 20 48 8B 5C 24 38 0F 92 C2 49 01 D2 4C 01 D3 0F 82 CD 00 00 00 4C 39 D2 0F 87 C4 00 00 00 4D 01 DF 0F 92 C1 4D 89 FD 0F B6 C9 4C 8D 34 31 48 8B 74 24 18 4C 01 F6 41 0F 92 C0 49 39 CE 0F 92 C2 44 09 C2 0F B6 D2 48 01 D7 48 8B 15 ?? ?? ?? ?? 48 89 F9 83 E1 01 8B 12 44 8D 04 95 00 00 00 00 45 8D 04 40 49 01 C8 48 8D 0D ?? ?? ?? ?? 49 C1 E0 04 49 01 C8 49 8B 48 08 48 39 F1 0F 82 D0 00 00 00 48 39 CE 0F 84 B7 00 00 00 81 7C 24 14 FF 02 00 00 0F 8E E9 01 00 00 48 8B 0D ?? ?? ?? ?? 83 09 28 83 FA 03 74 1A 83 F8 01 19 C9 83 C1 02 39 D1 0F 85 02 F9 FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 C1 E0 3F 48 BA FF FF C0 6F F2 86 FB 77 48 01 D0 E9 F3 F8 FF FF 66 2E 0F 1F 84 00 00 00 00 00 49 83 C3 01 4D 01 DF 4D 89 FD 0F 82 80 01 00 00 4D 85 DB 0F 84 77 01 00 00 31 D2 48 03 74 24 18 0F 92 C2 E9 3C FF FF FF 0F 1F 84 00 00 00 00 00 49 83 C6 01 4C 01 F6 41 0F 92 C5 4D 85 F6 0F 94 C2 41 09 D5 45 0F B6 ED E9 C3 FE FF FF 0F 1F 00 49 83 C5 01 E9 2C FD FF FF 0F 1F 80 00 00 00 00 4D 39 28 0F 83 40 FF FF FF 0F 1F 80 00 00 00 00 48 83 C7 01 48 B9 00 00 C1 6F F2 86 23 00 48 39 CF 0F 84 79 01 00 00 48 B9 00 80 C6 A4 7E 8D 03 00 48 39 CF 0F 85 0F FF FF FF 8B 4C 24 14 85 C9 0F 85 03 FF FF FF 48 B9 33 33 33 33 33 33 33 F3 48 39 CE 77 6B F6 C2 03 75 66 48 8B 15 ?? ?? ?? ?? 83 0A 10 4C 09 EE 0F 84 47 01 00 00 48 8B 0D ?? ?? ?? ?? 31 F6 48 BF 00 80 C6 A4 7E 8D 03 00 8B 11 83 CA 20 89 11 48 BA FF FF FF FF FF FF 1F 00 48 39 D7 0F 86 28 02 00 00 48 C1 E0 3F 48 BA 00 00 00 00 00 00 E0 5F 48 C1 E6 33 48 01 D0 48 01 F8 48 01 F0 E9 CF F7 FF FF 66 0F 1F 44 00 00 01 C2 83 FA 02 75 9D 48 BA 66 66 66 66 66 66 66 E6 48 39 D6 77 8E E9 7F FF FF FF 48 89 D1 49 C1 E1 08 48 C1 E2 08 48 C1 E9 38 45 85 C0 49 8D 3C 09 48 89 7C 24 08 0F 8E AA F5 FF FF 4D 63 C0 48 8D 0D ?? ?? ?? ?? 49 81 C0 9D 05 00 00 4D 89 C1 49 C1 E1 04 4C 01 C9 4C 8D 0D ?? ?? ?? ?? 4F 8D 0C 81 49 C1 E0 05 E9 E3 F9 FF FF 0F 1F 44 00 00 B9 01 00 00 00 E9 AE FD FF FF 66 0F 1F 44 00 00 4C 09 EE 48 63 74 24 14 0F 84 39 FF FF FF 48 8B 0D ?? ?? ?? ?? 49 B8 FF 7F C6 A4 7E 8D 03 00 4C 39 C7 8B 11 0F 87 18 FF FF FF 83 CA 30 48 C1 E6 35 89 11 48 01 FE 48 C1 E0 3F 48 01 F0 E9 07 F7 FF FF 41 8D 4B F1 41 B8 61 BF FF FF 45 29 D8 45 31 DB 48 D3 E2 49 89 D1 31 D2 E9 ED F4 FF FF 90 83 44 24 14 01 48 BF 00 80 C6 A4 7E 8D 03 00 E9 95 FD FF FF 48 BF 00 80 C6 A4 7E 8D 03 00 EB B3 B9 08 00 00 00 44 29 C1 83 F9 3F 0F 8E AE 00 00 00 48 8B 7C 24 08 B9 C8 FF FF FF 44 29 C1 48 D3 EF 48 89 F9 49 B9 FF FF C0 6F F2 86 23 00 4C 39 C9 0F 87 F9 F8 FF FF 48 BA FF FF FF FF FF FF 1F 00 48 C1 E0 3F 48 39 D1 0F 87 9F 00 00 00 48 BA 00 00 00 00 00 00 C0 31 48 01 D0 48 01 C8 E9 66 F6 FF FF 41 8D 6A 08 4C 8B 7C 24 08 BE 38 00 00 00 44 29 D6 49 89 D4 89 E9 49 D3 EC 89 F1 4C 89 FE 48 D3 E6 89 E9 4D 8D 14 34 4C 89 FE 48 D3 EE 48 89 F1 E9 9B F4 FF FF 48 C1 E0 3F 48 B9 00 00 00 00 00 00 E0 5F 41 81 C3 8E 01 00 00 48 01 C8 49 C1 E3 33 4C 01 D8 48 01 D0 E9 0A F6 FF FF 4C 8B 4C 24 08 49 D3 E9 4D 85 C9 0F 85 60 F8 FF FF 49 89 D1 48 8B 7C 24 08 49 D3 E9 41 8D 48 38 48 D3 E7 48 89 F9 4C 01 C9 E9 37 FF FF FF 48 BA 00 00 00 00 00 00 50 6C 48 01 D0 48 01 C8 E9 C7 F5 FF FF 48 C1 E6 35 E9 A8 FE FF FF 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_174_20_0 {
	meta:
		name = "__binary32_to_bid128"
		size = 4064
		refs = "00f5 .refptr.__bid_IDEC_glbflags 01db .rdata 0a8f .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC C8 00 00 00 66 0F 7E C8 49 89 CF 89 C2 49 89 D0 48 C1 EA 1F 49 C1 E8 17 48 89 54 24 08 66 0F 7E CA 45 0F B6 C0 81 E2 FF FF 7F 00 45 85 C0 89 D3 0F 85 CB 00 00 00 85 D2 0F 84 43 0D 00 00 66 0F 7E CA 0F B7 C8 66 41 0F 7E C8 81 E2 00 00 7F 00 39 D1 66 0F 7E CA 19 C9 41 81 E0 FF 00 7F 00 81 E2 00 FF 00 00 F7 D1 83 E1 10 41 39 D0 66 41 0F 7E C8 19 D2 F7 D2 41 81 E0 0F 0F 0F 00 83 E2 08 01 D1 66 0F 7E CA 81 E2 F0 F0 70 00 41 39 D0 66 41 0F 7E C8 19 D2 F7 D2 41 81 E0 33 33 33 00 83 E2 04 01 D1 66 0F 7E CA 81 E2 CC CC 4C 00 41 39 D0 19 D2 25 AA AA 2A 00 F7 D2 83 E2 02 01 CA 66 0F 7E C9 81 E1 55 55 55 00 39 C1 0F 93 C0 0F B6 C0 01 C2 B8 73 FF FF FF 29 D0 8D 4A F8 31 D2 89 44 24 14 48 8B 05 ?? ?? ?? ?? 48 D3 E3 B9 59 00 00 00 83 08 02 E9 86 00 00 00 0F 1F 80 00 00 00 00 41 81 F8 FF 00 00 00 0F 84 B3 0C 00 00 48 81 C3 00 00 80 00 48 89 D8 48 F7 D8 48 21 D8 0F B7 D0 48 83 FA 01 48 89 C2 19 C9 81 E2 FF 00 FF 00 83 E1 10 48 83 FA 01 19 D2 83 E2 08 01 D1 48 89 C2 81 E2 0F 0F 0F 0F 48 83 FA 01 19 D2 83 E2 04 01 D1 48 89 C2 81 E2 33 33 33 33 48 83 FA 01 19 D2 83 E2 02 01 CA 31 C9 A9 55 55 55 01 0F 94 C1 41 8D 80 6A FF FF FF 01 CA 8D 4A 59 89 44 24 14 8B 44 24 14 48 C1 E3 28 48 89 5C 24 30 83 E8 59 85 C0 0F 8E 89 0C 00 00 8B 44 24 14 B9 50 45 00 00 05 4F A4 00 00 69 D0 10 4D 00 00 69 C0 43 4D 00 00 C1 F8 10 01 D0 C1 F8 10 29 C1 8D B8 90 E6 FF FF 89 44 24 6C 41 89 C9 48 8D 05 ?? ?? ?? ?? C1 F9 07 41 83 E1 7F 89 7C 24 20 4D 89 C8 49 C1 E0 05 49 01 C0 83 F9 27 49 8B 78 18 49 8B 10 49 8B 40 08 4D 8B 70 10 4C 8D 05 ?? ?? ?? ?? 43 8B 1C 88 48 89 7C 24 18 89 5C 24 68 0F 84 4F 07 00 00 49 89 D1 89 D2 81 C3 AA 01 00 00 49 C1 E9 20 89 5C 24 68 BD 6C 33 6F C6 49 69 F9 E7 F7 40 3F 41 BC DF 8C E9 80 48 69 CA E7 F7 40 3F 49 69 D9 4E C5 C3 0B 41 89 F8 48 C1 E9 20 49 8D 34 08 48 89 5C 24 38 48 69 CA 39 DD 08 7B 49 69 D9 39 DD 08 7B 48 89 74 24 48 4D 69 D9 FD F3 34 02 49 89 C8 41 89 DA 49 C1 E8 20 4D 01 D0 4C 89 5C 24 40 41 89 CB 4C 69 D2 FD F3 34 02 4D 69 E9 37 01 B1 36 49 0F AF E9 4D 01 D0 4D 89 C2 44 89 EE 49 C1 ED 20 49 C1 E2 20 4C 01 ED 4D 01 DA 4C 89 54 24 50 4C 69 D2 37 01 B1 36 4D 0F AF E1 4C 89 D1 45 89 D2 48 C1 E9 20 45 89 E3 48 01 F1 BE 6C 33 6F C6 48 0F AF F2 48 01 CE B9 DF 8C E9 80 48 0F AF CA 49 89 F5 49 C1 ED 20 49 01 ED BD C9 47 BA 93 4C 0F AF CD 48 89 CD 89 C9 48 C1 ED 20 49 01 EB BD C9 47 BA 93 48 0F AF EA 4C 01 DD 49 C1 EC 20 48 C1 EF 20 48 69 D2 4E C5 C3 0B 48 03 7C 24 38 4D 01 E1 48 03 54 24 48 49 89 EC 48 C1 E5 20 49 C1 EC 20 48 01 CD 4D 01 E1 48 C1 EA 20 48 01 D7 48 03 7C 24 50 0F 92 C2 48 C1 EB 20 48 03 5C 24 40 48 C1 E6 20 49 C1 E8 20 0F B6 D2 4C 01 D6 48 89 7C 24 70 48 01 D6 49 01 D8 49 01 F0 4C 89 44 24 78 0F 82 99 07 00 00 48 39 F2 0F 87 90 07 00 00 4C 01 ED 0F 92 C2 48 89 6C 24 38 0F B6 D2 49 8D 3C 11 49 89 C1 89 C0 49 C1 E9 20 BD 6C 33 6F C6 41 BD C9 47 BA 93 48 69 D0 E7 F7 40 3F 48 89 7C 24 50 49 69 F9 E7 F7 40 3F 49 69 D9 4E C5 C3 0B 48 89 D1 89 D2 41 89 F8 48 C1 E9 20 4C 01 C1 48 89 5C 24 40 4C 69 C0 4E C5 C3 0B 49 69 D9 39 DD 08 7B 4D 69 E1 37 01 B1 36 49 01 C8 4C 89 C1 41 89 DA 48 C1 E1 20 48 8D 34 11 48 69 D0 39 DD 08 7B 48 89 B4 24 80 00 00 00 49 69 F1 FD F3 34 02 48 89 D1 41 89 D3 48 C1 E9 20 4C 01 D1 48 89 74 24 48 44 89 E6 4C 69 D0 FD F3 34 02 49 C1 EC 20 49 0F AF E9 4C 01 D1 49 89 CA 4C 01 E5 49 C1 E2 20 4D 01 D3 4C 69 D0 37 01 B1 36 4C 89 5C 24 58 4C 89 D2 45 89 D2 48 C1 EA 20 48 01 F2 BE 6C 33 6F C6 48 0F AF F0 48 01 D6 BA DF 8C E9 80 49 89 F4 49 C1 EC 20 48 0F AF D0 49 01 EC BD DF 8C E9 80 49 0F AF E9 4D 0F AF CD 49 89 D5 89 D2 41 89 EB 49 C1 ED 20 4D 01 DD 41 BB C9 47 BA 93 48 C1 EF 20 49 0F AF C3 48 03 7C 24 40 48 C1 ED 20 49 01 E9 49 C1 E8 20 4C 01 E8 4C 01 C7 48 89 C5 48 C1 E0 20 48 C1 ED 20 48 01 D0 49 01 E9 48 03 7C 24 58 0F 92 C2 48 C1 EB 20 48 03 5C 24 48 48 C1 E6 20 48 C1 E9 20 0F B6 D2 4C 01 D6 48 89 BC 24 88 00 00 00 48 01 D6 48 01 D9 48 01 F1 48 89 4C 24 58 0F 82 4A 06 00 00 48 39 F2 0F 87 41 06 00 00 4C 01 E0 0F 92 C2 48 89 44 24 40 0F B6 D2 49 8D 04 11 4D 89 F2 44 89 F2 49 C1 EA 20 41 BC 6C 33 6F C6 48 89 84 24 90 00 00 00 49 69 C2 4E C5 C3 0B 49 69 EA E7 F7 40 3F 49 69 F2 39 DD 08 7B 48 89 44 24 48 41 89 E9 48 69 C2 E7 F7 40 3F 41 89 F0 4C 69 DA 37 01 B1 36 4D 0F AF E2 48 89 C1 89 C0 48 C1 E9 20 4C 01 C9 4C 69 CA 4E C5 C3 0B 4D 69 F2 FD F3 34 02 49 01 C9 4C 89 C9 48 C1 E1 20 48 8D 3C 01 48 69 C2 39 DD 08 7B 48 89 BC 24 98 00 00 00 48 89 C1 89 C3 48 C1 E9 20 4C 01 C1 4C 69 C2 FD F3 34 02 49 69 C2 37 01 B1 36 49 01 C8 4C 89 C1 48 C1 E1 20 48 8D 3C 19 4C 89 D9 45 89 DB 48 C1 E9 20 48 89 7C 24 60 89 C7 48 C1 E8 20 48 01 F9 BF 6C 33 6F C6 49 01 C4 48 0F AF FA 48 01 CF B9 C9 47 BA 93 48 89 F8 48 C1 E8 20 4C 01 E0 41 BC DF 8C E9 80 4D 0F AF E2 4C 0F AF D1 B9 DF 8C E9 80 48 0F AF CA 44 89 E3 49 89 CD 89 C9 49 C1 ED 20 49 01 DD BB C9 47 BA 93 48 0F AF D3 48 C1 ED 20 48 03 6C 24 48 49 C1 EC 20 49 C1 E9 20 4D 01 E2 49 01 D5 4C 01 CD 4D 89 EC 49 C1 E5 20 49 C1 EC 20 49 01 CD 4D 01 E2 48 03 6C 24 60 0F 92 C1 48 C1 E7 20 48 C1 EE 20 4C 01 DF 4C 01 F6 49 C1 E8 20 0F B6 C9 4C 01 C6 48 89 AC 24 A0 00 00 00 48 01 CF 48 01 FE 48 89 74 24 60 0F 82 9C 04 00 00 48 39 F9 0F 87 93 04 00 00 49 01 C5 0F 92 C0 4C 89 6C 24 48 0F B6 C0 4C 01 D0 BD 6C 33 6F C6 41 BD C9 47 BA 93 48 89 84 24 A8 00 00 00 48 8B 44 24 18 49 89 C2 41 89 C0 49 C1 EA 20 49 69 C2 4E C5 C3 0B 49 69 FA E7 F7 40 3F 4D 69 C8 39 DD 08 7B 48 89 44 24 18 89 F9 49 69 C0 E7 F7 40 3F 4D 69 E2 37 01 B1 36 49 0F AF EA 48 89 C2 89 C0 48 C1 EA 20 44 89 E6 49 C1 EC 20 48 01 CA 4C 01 E5 49 69 C8 4E C5 C3 0B 4D 69 F2 FD F3 34 02 48 01 D1 48 89 CA 48 C1 E2 20 48 8D 1C 02 4C 89 CA 49 69 C2 39 DD 08 7B 48 C1 EA 20 48 89 9C 24 B0 00 00 00 44 89 CB 41 89 C3 4C 01 DA 4D 69 D8 FD F3 34 02 4C 01 DA 49 89 D3 49 C1 E3 20 4C 01 DB 4D 69 D8 37 01 B1 36 48 89 9C 24 B8 00 00 00 4D 89 D9 45 89 DB 49 C1 E9 20 49 01 F1 BE 6C 33 6F C6 49 0F AF F0 4C 01 CE 41 B9 DF 8C E9 80 49 89 F4 49 C1 EC 20 4D 0F AF C8 49 01 EC BD DF 8C E9 80 49 0F AF EA 4D 0F AF D5 4D 89 CD 45 89 C9 49 C1 ED 20 89 EB 48 C1 EF 20 49 01 DD BB C9 47 BA 93 48 03 7C 24 18 4C 0F AF C3 48 C1 ED 20 48 8B 9C 24 B8 00 00 00 49 01 EA 48 C1 E9 20 48 01 CF 31 C9 4D 01 C5 4C 89 ED 49 C1 E5 20 48 C1 ED 20 4D 01 CD 49 01 EA 48 01 FB 0F 92 C1 48 C1 E6 20 48 C1 E8 20 4C 01 F0 49 01 F3 48 C1 EA 20 49 01 CB 48 01 D0 4C 01 D8 49 89 C6 0F 82 EC 03 00 00 4C 39 D9 0F 87 E3 03 00 00 31 C0 4D 01 EC 0F 92 C0 49 01 C2 48 8B 44 24 70 48 03 84 24 80 00 00 00 48 8B BC 24 88 00 00 00 4C 8B 44 24 78 0F 92 C0 0F B6 C0 48 01 C7 49 01 F8 0F 82 6C 03 00 00 48 39 F8 0F 87 63 03 00 00 45 31 C9 48 8B 4C 24 38 48 03 4C 24 58 41 0F 92 C1 48 8B 44 24 40 48 8B 54 24 50 4C 01 C8 48 01 C2 41 0F 92 C3 4C 39 C8 0F 92 C0 41 09 C3 45 0F B6 DB 48 8B 84 24 98 00 00 00 4C 03 9C 24 90 00 00 00 4C 8B 8C 24 A0 00 00 00 4C 01 C0 0F 92 C0 0F B6 C0 49 01 C1 4C 01 C9 0F 82 D4 02 00 00 4C 39 C8 0F 87 CB 02 00 00 45 31 C0 48 03 54 24 60 41 0F 92 C0 4C 8B 6C 24 48 4D 01 C5 4D 01 EB 0F 92 C0 4D 39 C5 41 0F 92 C0 44 09 C0 0F B6 C0 48 8B B4 24 A8 00 00 00 48 01 C6 48 8B 84 24 B0 00 00 00 48 01 C8 0F 92 C0 0F B6 C0 48 01 C3 48 01 DA 0F 82 4F 02 00 00 48 39 D8 0F 87 46 02 00 00 4C 89 D8 31 C9 4C 01 F0 0F 92 C1 49 01 CC 4C 01 E6 41 0F 92 C0 49 39 CC 49 89 F6 0F 92 C1 41 09 C8 45 0F B6 C0 4B 8D 3C 02 48 83 C2 01 48 89 7C 24 18 48 8B 5C 24 30 4C 89 F6 45 89 F1 48 C1 EE 20 4C 8B 44 24 18 49 89 D3 89 C7 89 D2 49 C1 EB 20 48 C1 EB 20 48 C1 E8 20 4C 0F AF CB 48 0F AF F3 48 0F AF FB 48 89 F1 4C 89 CE 48 C1 EE 20 48 89 FD 48 01 CE 44 89 C1 49 C1 E8 20 48 0F AF CB 48 C1 E5 20 48 0F AF D3 4C 0F AF DB 49 89 CA 48 C1 E1 20 48 C1 EA 20 49 C1 EA 20 4C 0F AF C3 4C 01 DA 48 0F AF C3 4D 01 D0 48 01 D5 0F 92 C2 49 C1 E1 20 48 C1 EF 20 0F B6 D2 48 01 F8 49 01 D1 4C 01 C8 0F 82 0A 01 00 00 4C 39 CA 0F 87 01 01 00 00 45 31 D2 48 01 CE 41 B9 68 FF FF FF 41 0F 92 C2 44 2B 4C 24 14 48 89 C2 44 2B 4C 24 68 4D 01 D0 41 BA 40 00 00 00 45 29 CA 44 89 D1 48 D3 E2 44 89 C9 48 D3 ED 44 89 D1 48 01 D5 48 89 F2 48 D3 E2 44 89 C9 48 D3 E8 44 89 D1 48 01 D0 4C 89 C2 48 D3 E2 44 89 C9 48 D3 EE 49 D3 E8 48 01 D6 48 BA 92 8D 44 C6 4D 31 00 00 49 39 D0 0F 86 32 02 00 00 B2 93 49 39 D0 0F 84 14 02 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 7C 24 08 49 89 F1 41 83 E1 01 8B 12 C1 E2 02 8D 0C 7A 48 8D 15 ?? ?? ?? ?? 4C 01 C9 48 C1 E1 04 48 01 D1 48 3B 41 08 0F 87 8E 01 00 00 0F 84 78 01 00 00 48 09 C5 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 20 4C 8B 54 24 08 48 8B 44 24 20 49 89 37 49 C1 E2 3F 48 C1 E0 31 4D 01 D0 49 01 C0 4D 89 47 08 4C 89 F8 48 81 C4 C8 00 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 83 C1 01 E9 F6 FE FF FF 0F 1F 80 00 00 00 00 48 83 C5 01 49 01 ED 0F 92 C2 48 85 ED 4C 89 6C 24 38 41 0F 94 C4 44 09 E2 0F B6 D2 E9 5D F8 FF FF 49 83 C5 01 4C 01 E8 48 89 44 24 48 0F 92 C0 4D 85 ED 41 0F 94 C4 44 09 E0 0F B6 C0 E9 5A FB FF FF 48 83 C0 01 49 01 C4 0F 92 C2 48 85 C0 4C 89 64 24 40 41 0F 94 C3 44 09 DA 0F B6 D2 E9 AC F9 FF FF 49 83 C6 01 4C 89 D8 4C 01 F0 0F 82 CD 01 00 00 4D 85 F6 0F 84 C4 01 00 00 4C 01 E6 41 0F 92 C0 49 89 F6 45 0F B6 C0 E9 B3 FD FF FF 90 4C 8B 44 24 60 49 83 C0 01 4C 01 C2 0F 82 AE 01 00 00 4D 85 C0 0F 84 A5 01 00 00 31 C0 4C 03 5C 24 48 0F 92 C0 E9 32 FD FF FF 66 0F 1F 44 00 00 48 8B 6C 24 58 48 8B 4C 24 38 48 83 C5 01 48 01 E9 0F 82 89 01 00 00 48 85 ED 0F 84 80 01 00 00 45 31 DB 48 8B 54 24 40 48 03 54 24 50 41 0F 92 C3 E9 99 FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 49 83 C5 01 4D 01 EC 0F 92 C0 4D 85 ED 40 0F 94 C5 09 E8 0F B6 C0 E9 0A FC FF FF 0F 1F 44 00 00 48 3B 29 0F 86 7F FE FF FF 0F 1F 80 00 00 00 00 48 83 C6 01 0F 84 66 01 00 00 48 BA 00 00 00 00 64 8E 8D 37 48 39 D6 0F 85 5B FE FF FF 48 BA C0 87 AD BE 09 ED 01 00 49 39 D0 0F 85 48 FE FF FF 83 44 24 20 01 48 BE 00 00 00 00 0A 5B C1 38 49 B8 93 8D 44 C6 4D 31 00 00 E9 2A FE FF FF 66 90 48 BA FF FF FF FF 09 5B C1 38 48 39 D6 0F 87 D9 FD FF FF 48 89 EA 8B 5C 24 6C 48 C1 EA 02 48 01 EA 48 19 C9 49 89 D2 83 E5 03 48 C1 E2 03 83 E1 08 49 C1 EA 3D 48 8D 2C 6A 48 89 C2 48 C1 EA 02 48 01 C2 4D 19 C9 83 E0 03 49 89 D3 48 01 C0 49 C1 EB 3D 41 83 E1 08 48 8D 14 D0 4D 01 D9 4A 8D 04 12 48 01 C8 48 39 D0 48 89 F2 49 83 D1 00 48 C1 EA 02 48 01 F2 48 19 C9 83 E6 03 49 89 D3 48 01 F6 83 E1 08 49 C1 EB 3D 48 8D 34 D6 49 01 CB 4C 89 C2 4C 01 CE 49 83 D3 00 48 C1 EA 02 81 EB 71 19 00 00 4C 01 C2 41 83 E0 03 89 5C 24 20 4D 01 C0 4D 8D 04 D0 4D 01 D8 E9 2E FD FF FF 66 90 B9 01 00 00 00 E9 DE FB FF FF 66 0F 1F 44 00 00 41 B8 01 00 00 00 E9 76 FB FF FF 0F 1F 44 00 00 41 B9 01 00 00 00 E9 03 FB FF FF 0F 1F 44 00 00 48 8B 54 24 08 48 B8 00 00 00 00 00 00 40 30 48 C7 01 00 00 00 00 48 C1 E2 3F 48 01 D0 48 89 41 08 E9 40 FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 49 83 C0 01 E9 FF FC FF FF 0F 1F 80 00 00 00 00 85 D2 0F 84 38 01 00 00 A9 00 00 40 00 75 0A 48 8B 05 ?? ?? ?? ?? 83 08 01 48 8B 54 24 08 48 C1 E3 2A 48 B8 93 8D 44 C6 4D 31 00 00 48 C1 EB 12 49 C7 07 00 00 00 00 48 C1 E2 3F 48 39 C3 48 B8 00 00 00 00 00 00 00 7C 0F 86 22 01 00 00 48 01 D0 49 89 47 08 E9 CC FC FF FF 66 0F 1F 44 00 00 01 C8 89 C1 F7 D9 85 C9 0F 8E 12 01 00 00 83 F9 30 0F 8F 60 F3 FF FF 4C 63 C1 48 8D 0D ?? ?? ?? ?? 4C 8B 4C 24 30 4D 89 C2 49 C1 E2 04 49 01 CA 8D 4A 28 49 D3 E9 4D 3B 0A 76 0B 49 83 7A 08 00 0F 84 31 F3 FF FF 4C 89 C1 4C 8D 05 ?? ?? ?? ?? 4C 89 CE 48 C1 E1 04 48 C1 EE 20 05 20 18 00 00 4C 01 C1 49 89 F3 45 89 C8 48 8B 11 48 C1 E0 31 4C 0F AF 49 08 48 8B 4C 24 08 48 89 D3 89 D2 48 C1 EB 20 4C 0F AF DA 48 C1 E1 3F 49 0F AF D0 4C 0F AF C3 49 01 C9 44 89 DF 49 C1 EB 20 49 89 D2 89 D2 48 0F AF DE 49 C1 EA 20 49 01 FA 4D 01 C2 4C 89 D1 49 C1 E2 20 49 01 D9 48 C1 E9 20 4C 01 D2 4D 01 CB 49 89 17 4C 01 D8 48 01 C8 49 89 47 08 E9 F0 FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 54 24 08 48 B8 00 00 00 00 00 00 00 78 48 C7 01 00 00 00 00 48 C1 E2 3F 48 01 D0 48 89 41 08 E9 C0 FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 01 D0 48 01 C3 49 89 5F 08 E9 A7 FB FF FF 90 B8 68 00 00 00 2B 44 24 14 83 F8 3F 7E 2F B9 28 00 00 00 2B 4C 24 14 48 89 DA 31 C0 48 D3 EA 48 8B 4C 24 08 49 89 17 48 BA 00 00 00 00 00 00 40 30 48 C1 E1 3F 48 01 CA E9 91 FE FF FF 8B 7C 24 14 8D 4F D8 48 8B 7C 24 30 48 89 FA 48 D3 E2 89 C1 48 D3 EF 48 B9 BF 87 AD BE 09 ED 01 00 48 39 CF 48 89 F8 76 B9 B1 C0 48 39 CF 0F 85 E6 F1 FF FF 48 B8 FF FF FF FF 63 8E 8D 37 48 39 C2 0F 87 D3 F1 FF FF 48 89 C8 EB 96 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_174_21_0 {
	meta:
		name = "__binary64_to_bid128"
		size = 4688
		refs = "0151 .refptr.__bid_IDEC_glbflags 026c .rdata 0c70 .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC E8 00 00 00 48 BA FF FF FF FF FF FF 0F 00 66 49 0F 7E C8 66 48 0F 7E C8 48 89 8C 24 30 01 00 00 66 48 0F 7E CB 49 C1 E8 34 48 21 C2 48 C1 EB 3F 41 81 E0 FF 07 00 00 48 89 5C 24 08 0F 85 12 01 00 00 48 85 D2 0F 84 26 0F 00 00 48 B9 00 00 00 00 FF FF 0F 00 41 89 C0 49 B9 FF FF 00 00 FF FF 00 00 48 21 C1 49 39 C8 48 B9 00 00 FF FF 00 00 0F 00 45 19 C0 48 21 C1 49 21 C1 41 F7 D0 41 83 E0 20 49 39 C9 49 B9 FF 00 FF 00 FF 00 0F 00 19 C9 49 21 C1 F7 D1 83 E1 10 41 01 C8 48 B9 00 FF 00 FF 00 FF 00 00 48 21 C1 49 39 C9 49 B9 0F 0F 0F 0F 0F 0F 0F 00 19 C9 49 21 C1 F7 D1 83 E1 08 41 01 C8 48 B9 F0 F0 F0 F0 F0 F0 00 00 48 21 C1 49 39 C9 49 B9 33 33 33 33 33 33 03 00 19 C9 49 21 C1 F7 D1 83 E1 04 41 01 C8 48 B9 CC CC CC CC CC CC 0C 00 48 21 C1 49 39 C9 49 B9 AA AA AA AA AA AA 0A 00 19 C9 49 21 C1 F7 D1 83 E1 02 44 01 C1 49 B8 55 55 55 55 55 55 05 00 4C 21 C0 41 B8 3C 00 00 00 49 39 C1 0F 96 C0 0F B6 C0 01 C8 8D 48 F5 48 D3 E2 48 89 D1 BA D9 FB FF FF 29 C2 48 8B 05 ?? ?? ?? ?? 89 54 24 14 83 08 02 31 C0 E9 B8 00 00 00 41 81 F8 FF 07 00 00 0F 84 40 0E 00 00 48 B9 00 00 00 00 00 00 10 00 41 8D 98 CD FB FF FF 48 01 D1 48 89 CA 89 5C 24 14 48 F7 DA 48 21 CA 89 D0 48 83 F8 01 48 B8 FF FF 00 00 FF FF 00 00 45 19 C9 48 21 D0 41 83 E1 20 48 83 F8 01 19 C0 83 E0 10 41 01 C1 48 B8 FF 00 FF 00 FF 00 FF 00 48 21 D0 48 83 F8 01 19 C0 83 E0 08 41 01 C1 48 B8 0F 0F 0F 0F 0F 0F 0F 0F 48 21 D0 48 83 F8 01 19 C0 83 E0 04 41 01 C1 48 B8 33 33 33 33 33 33 33 33 48 21 D0 48 83 F8 01 19 C0 83 E0 02 44 01 C8 49 B9 55 55 55 55 55 55 55 55 4C 85 CA 0F 94 C2 0F B6 D2 01 D0 44 8D 40 3C 8B 5C 24 14 48 C1 E1 0B 48 89 4C 24 60 8D 53 C4 85 D2 0F 8E F1 0D 00 00 8B 44 24 14 B9 50 45 00 00 05 6C A4 00 00 69 D0 10 4D 00 00 69 C0 43 4D 00 00 C1 F8 10 01 D0 C1 F8 10 29 C1 8D 98 90 E6 FF FF 89 84 24 9C 00 00 00 89 CA 83 E1 7F 48 8D 05 ?? ?? ?? ?? 49 89 C8 89 5C 24 50 C1 FA 07 49 C1 E0 05 49 01 C0 83 FA 27 49 8B 58 18 49 8B 00 4D 8B 58 08 4D 8B 78 10 4C 8D 05 ?? ?? ?? ?? 48 89 5C 24 20 41 8B 1C 88 89 DF 89 9C 24 98 00 00 00 0F 84 E4 07 00 00 48 63 D2 48 8D 0D ?? ?? ?? ?? 41 89 C1 49 89 D0 49 C1 E0 05 4C 01 C1 4C 8B 01 4C 8B 51 10 48 8B 59 08 4C 8B 61 18 48 8D 0D ?? ?? ?? ?? 45 89 C6 8B 14 91 48 89 C1 4C 89 F6 48 C1 E9 20 4C 89 F5 49 0F AF F1 4C 89 C0 48 0F AF E9 8D BC 17 00 01 00 00 48 C1 E8 20 48 89 44 24 18 89 BC 24 98 00 00 00 48 89 C7 48 89 F0 89 EA 48 C1 E8 20 48 8D 34 02 48 89 D8 89 DB 48 89 DA 48 C1 E8 20 48 89 5C 24 30 48 89 74 24 78 48 89 DE 48 89 44 24 28 48 0F AF F9 48 89 C3 48 0F AF F1 49 0F AF D1 48 89 7C 24 68 48 89 C7 41 89 F0 48 89 D0 48 C1 EA 20 4C 01 C2 49 89 F8 4C 89 D7 4D 0F AF C1 48 C1 EF 20 48 0F AF D9 49 89 FD 48 89 7C 24 38 4C 0F AF E9 49 01 D0 4C 89 C2 48 89 5C 24 70 89 C3 48 C1 E2 20 48 01 DA 48 89 FB 48 89 94 24 80 00 00 00 44 89 D2 49 89 D2 48 89 54 24 40 4D 0F AF D1 48 0F AF D1 4C 89 D0 45 89 D2 89 D7 48 C1 E8 20 48 C1 EA 20 48 01 F8 48 89 DF 49 01 D5 49 0F AF F9 48 01 C7 48 89 FA 48 C1 EA 20 4C 01 EA 4D 89 E5 45 89 E4 49 C1 ED 20 4C 89 E0 4C 89 64 24 48 4C 89 EB 4D 89 E5 4C 0F AF E9 48 89 1C 24 48 0F AF CB 49 0F AF C1 48 C1 ED 20 48 03 6C 24 68 44 89 EB 49 C1 ED 20 4C 01 E9 49 89 C4 89 C0 49 C1 EC 20 4C 01 E3 4C 8B 24 24 4D 0F AF E1 4C 0F AF 4C 24 18 49 01 DC 4C 03 4C 24 78 4D 89 E5 49 C1 E4 20 49 C1 ED 20 49 01 C4 4C 01 E9 49 C1 E9 20 4C 01 CD 48 03 AC 24 80 00 00 00 0F 92 C0 48 C1 EE 20 48 03 74 24 70 48 C1 E7 20 49 C1 E8 20 0F B6 C0 4C 01 D7 48 89 AC 24 A0 00 00 00 48 01 C7 4C 01 C6 48 01 FE 48 89 B4 24 A8 00 00 00 0F 82 7A 08 00 00 48 39 F8 0F 87 71 08 00 00 49 01 D4 0F 92 C0 4C 89 64 24 70 0F B6 C0 4D 89 D8 45 89 DB 48 8B 5C 24 18 49 C1 E8 20 4C 89 DE 48 01 C8 49 0F AF F6 4C 89 C7 48 89 84 24 80 00 00 00 49 0F AF FE 48 89 D8 4C 8B 54 24 28 49 0F AF C0 48 89 F2 89 F9 48 C1 EA 20 48 01 CA 48 89 D9 48 89 44 24 68 49 0F AF CB 89 F0 48 8B 74 24 30 48 01 D1 48 89 CA 48 C1 E2 20 48 8D 1C 02 4C 89 D2 49 0F AF D0 48 89 9C 24 B0 00 00 00 48 89 F3 49 0F AF F3 49 0F AF D8 48 89 54 24 78 48 89 F0 48 C1 EE 20 48 89 F2 41 89 D9 4C 01 CA 4D 89 D1 41 89 C2 4D 0F AF CB 4C 01 CA 49 89 D1 49 C1 E1 20 4B 8D 34 11 4C 8B 4C 24 40 4C 8B 54 24 38 48 89 B4 24 88 00 00 00 4D 89 CC 4C 89 D5 4D 0F AF CB 4D 0F AF E0 49 0F AF E8 4D 89 CD 45 89 C9 49 C1 ED 20 44 89 E6 49 C1 EC 20 4C 89 E8 4C 01 E5 48 01 F0 4C 89 D6 4C 8B 54 24 48 49 0F AF F3 48 01 C6 49 89 F4 49 C1 EC 20 49 01 EC 4C 89 D5 4D 0F AF D3 49 0F AF E8 4C 0F AF 04 24 4C 89 D0 49 89 C5 41 89 EA 89 C0 49 C1 ED 20 4D 01 D5 48 C1 EF 20 48 03 7C 24 68 4C 0F AF 1C 24 48 C1 ED 20 48 C1 E9 20 49 01 E8 48 01 CF 4D 01 DD 4C 89 ED 49 C1 E5 20 48 C1 ED 20 49 01 C5 49 01 E8 48 03 BC 24 88 00 00 00 0F 92 C1 48 C1 EB 20 48 03 5C 24 78 48 C1 E6 20 48 C1 EA 20 0F B6 C9 4C 01 CE 48 89 BC 24 B8 00 00 00 48 01 CE 48 01 D3 48 01 F3 48 89 9C 24 88 00 00 00 0F 82 13 07 00 00 48 39 F1 0F 87 0A 07 00 00 4D 01 E5 0F 92 C0 4C 89 6C 24 78 0F B6 C0 45 89 F9 4C 01 C0 4D 89 F8 49 C1 E8 20 4C 89 CF 48 8B 5C 24 18 49 0F AF FE 4C 89 C5 48 89 84 24 C0 00 00 00 49 0F AF EE 4C 8B 7C 24 28 48 89 D8 48 89 FA 89 E9 48 C1 EA 20 48 01 CA 48 89 D9 49 0F AF C9 49 0F AF C0 48 01 D1 48 89 CA 48 89 44 24 68 89 F8 48 C1 E2 20 4C 89 FF 48 8D 1C 02 49 0F AF F8 48 89 9C 24 C8 00 00 00 48 8B 5C 24 30 48 89 DE 48 89 BC 24 90 00 00 00 49 0F AF D9 49 0F AF F0 48 89 DA 89 DB 41 89 F2 48 C1 EA 20 4C 01 D2 4D 89 FA 4C 8B 7C 24 38 4D 0F AF D1 4D 89 FC 4C 01 D2 49 89 D2 49 C1 E2 20 4C 01 D3 4C 8B 54 24 40 4D 0F AF E0 4D 89 D3 4D 0F AF D1 4D 0F AF D8 4D 89 D5 45 89 D2 49 C1 ED 20 44 89 DF 49 C1 EB 20 4C 89 E8 4D 01 DC 48 01 F8 4C 89 FF 4C 8B 7C 24 48 49 0F AF F9 48 01 C7 49 89 FB 49 C1 EB 20 4D 01 E3 4D 89 FC 4D 0F AF F9 4D 0F AF E0 4C 0F AF 04 24 4C 89 F8 49 89 C5 45 89 E7 89 C0 49 C1 ED 20 48 C1 ED 20 48 03 6C 24 68 4C 0F AF 0C 24 4D 01 FD 49 C1 EC 20 48 C1 E9 20 4D 01 E0 48 01 CD 4D 01 CD 4D 89 EC 49 C1 E5 20 49 C1 EC 20 49 01 C5 4D 01 E0 48 01 DD 0F 92 C3 48 C1 EE 20 48 03 B4 24 90 00 00 00 48 C1 E7 20 48 C1 EA 20 0F B6 DB 4C 01 D7 48 89 AC 24 D0 00 00 00 48 01 DF 48 01 D6 48 01 FE 48 89 B4 24 90 00 00 00 0F 82 55 05 00 00 48 39 FB 0F 87 4C 05 00 00 4D 01 DD 0F 92 C0 4C 89 6C 24 68 0F B6 C0 4C 01 C0 48 8B 5C 24 18 4C 8B 54 24 40 48 89 84 24 D8 00 00 00 48 8B 44 24 20 4C 8B 7C 24 38 49 89 C0 89 C2 48 89 D8 49 C1 E8 20 4D 89 FC 4C 89 C5 49 0F AF EE 49 0F AF C0 4C 0F AF F2 41 89 E9 48 89 44 24 18 4C 89 F0 44 89 F1 48 C1 E8 20 4C 01 C8 49 89 D9 48 8B 5C 24 30 4C 0F AF CA 4D 0F AF E0 48 89 DE 4C 01 C8 49 89 C1 48 0F AF DA 49 C1 E1 20 49 8D 3C 09 49 0F AF F0 48 89 7C 24 20 48 8B 7C 24 28 49 89 D9 89 DB 49 C1 E9 20 41 89 F3 49 89 FE 4D 01 D9 49 89 FB 4C 0F AF DA 4D 0F AF F0 4D 01 CB 4D 89 D9 49 C1 E1 20 4C 01 CB 4D 89 D1 4C 0F AF D2 4D 0F AF C8 4C 89 D1 45 89 D2 44 89 CF 48 C1 E9 20 49 C1 E9 20 48 01 F9 4C 89 FF 4D 01 CC 48 0F AF FA 48 01 CF 48 8B 4C 24 48 49 89 F9 49 C1 E9 20 4D 01 E1 49 89 CC 48 0F AF CA 4D 0F AF E0 4C 0F AF 04 24 49 89 CD 89 C9 49 C1 ED 20 45 89 E7 48 C1 ED 20 48 0F AF 14 24 48 03 6C 24 18 4D 01 FD 49 C1 EC 20 48 C1 E8 20 4D 01 E0 48 01 C5 49 01 D5 31 D2 4D 89 EC 49 C1 E5 20 49 C1 EC 20 49 01 CD 4D 01 E0 48 01 EB 0F 92 C2 48 C1 EE 20 48 C1 E7 20 4C 01 F6 49 C1 EB 20 49 01 FA 49 01 F3 49 01 D2 4D 89 DF 4D 01 D7 0F 82 B8 04 00 00 4C 39 D2 0F 87 AF 04 00 00 4D 89 EE 31 FF 4D 01 CE 40 0F 92 C7 48 8B 84 24 A0 00 00 00 4C 01 C7 48 03 84 24 B0 00 00 00 48 8B 8C 24 B8 00 00 00 48 8B B4 24 A8 00 00 00 0F 92 C0 0F B6 C0 48 01 C1 48 01 CE 0F 82 2E 04 00 00 48 39 C8 0F 87 25 04 00 00 31 D2 4C 8B 64 24 70 4C 03 A4 24 88 00 00 00 0F 92 C2 48 8B 44 24 78 4C 8B 94 24 80 00 00 00 48 01 D0 49 01 C2 0F 92 C1 48 39 D0 41 0F 92 C3 44 09 D9 44 0F B6 D9 48 8B 84 24 C8 00 00 00 48 8B AC 24 D0 00 00 00 31 C9 4C 03 9C 24 C0 00 00 00 48 01 F0 0F 92 C1 48 01 CD 49 01 EC 0F 82 93 03 00 00 48 39 E9 0F 87 8A 03 00 00 31 D2 4C 03 94 24 90 00 00 00 0F 92 C2 4C 8B 6C 24 68 49 01 D5 4D 01 EB 0F 92 C0 49 39 D5 0F 92 C2 09 D0 0F B6 C0 4C 63 C8 48 8B 44 24 20 31 D2 4C 03 8C 24 D8 00 00 00 4C 01 E0 0F 92 C2 48 01 D3 49 01 DA 0F 82 12 03 00 00 48 39 DA 0F 87 09 03 00 00 31 C0 4D 01 FB 0F 92 C0 4E 8D 2C 30 4D 89 CF 4D 01 EF 0F 92 C2 49 39 C5 0F 92 C0 09 C2 0F B6 D2 48 8D 04 17 48 89 44 24 20 49 8D 42 01 48 8B 7C 24 20 49 89 C5 89 C0 49 89 C4 4C 89 DE 45 89 DB 48 C1 EE 20 4C 89 DD 49 C1 ED 20 89 FA 48 89 FB 48 8B 7C 24 60 45 89 F9 4D 89 FE 48 C1 EB 20 49 C1 EE 20 49 89 FA 89 F9 4C 89 EF 49 C1 EA 20 4D 0F AF E2 48 0F AF C1 4C 0F AF D9 45 89 E0 48 C1 E8 20 4C 01 C0 48 89 44 24 20 48 89 F0 49 0F AF C2 49 0F AF EA 48 0F AF F1 48 89 44 24 18 4C 89 D8 41 89 E8 48 C1 E8 20 4C 01 C0 49 89 F0 49 01 C0 44 89 D8 4C 89 C6 49 0F AF FA 48 C1 E6 20 48 01 F0 4C 89 CE 4C 0F AF C9 49 0F AF F2 48 89 3C 24 4C 89 F7 4C 0F AF F1 4D 89 CB 45 89 C9 49 C1 EB 20 49 0F AF FA 41 89 F7 48 C1 EE 20 4D 01 FB 4D 01 F3 48 01 F7 4C 89 DE 48 C1 EE 20 48 01 F7 48 89 D6 48 0F AF D1 49 0F AF F2 4C 0F AF D3 49 89 D6 89 D2 49 C1 EE 20 41 89 F7 49 C1 EC 20 48 0F AF D9 4C 03 24 24 4D 01 FE 49 0F AF CD 48 C1 EE 20 48 03 4C 24 20 49 01 F2 49 01 DE 4C 89 F6 49 C1 E6 20 48 C1 E9 20 48 C1 EE 20 49 01 D6 49 01 CC 31 D2 49 01 F2 4C 01 E0 0F 92 C2 48 C1 ED 20 48 03 6C 24 18 49 C1 E3 20 49 C1 E8 20 4D 01 CB 49 01 D3 49 01 E8 4D 01 D8 0F 82 1A 01 00 00 4C 39 DA 0F 87 11 01 00 00 31 F6 49 01 FE 41 B9 4B FF FF FF 40 0F 92 C6 44 2B 4C 24 14 BA 40 00 00 00 44 2B 8C 24 98 00 00 00 4D 89 C4 4D 89 F3 49 01 F2 4C 89 D7 44 29 CA 89 D1 49 D3 E4 44 89 C9 48 D3 E8 89 D1 49 D3 E3 44 89 C9 4C 01 E0 49 D3 E8 89 D1 48 BA 92 8D 44 C6 4D 31 00 00 48 D3 E7 44 89 C9 4D 01 D8 49 D3 EE 49 D3 EA 49 01 FE 49 39 D2 0F 86 41 02 00 00 B2 93 49 39 D2 0F 84 23 02 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 5C 24 08 4D 89 F1 41 83 E1 01 8B 0A C1 E1 02 8D 14 59 48 8D 0D ?? ?? ?? ?? 4C 01 CA 48 C1 E2 04 48 01 CA 4C 3B 42 08 0F 87 9D 01 00 00 0F 84 87 01 00 00 4C 09 C0 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 20 48 8B 84 24 30 01 00 00 48 8B 74 24 08 4C 89 30 48 8B 44 24 50 48 C1 E6 3F 49 01 F2 48 C1 E0 31 49 01 C2 48 8B 84 24 30 01 00 00 4C 89 50 08 48 8B 84 24 30 01 00 00 48 81 C4 E8 00 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 49 83 C6 01 E9 E6 FE FF FF 0F 1F 40 00 49 83 C4 01 4C 01 E2 0F 92 C0 4D 85 E4 48 89 54 24 70 41 0F 94 C5 44 09 E8 0F B6 C0 E9 7C F7 FF FF 49 83 C5 01 4D 01 EB 0F 92 C0 4D 85 ED 4C 89 5C 24 68 41 0F 94 C4 44 09 E0 0F B6 C0 E9 A1 FA FF FF 49 83 C5 01 4D 01 EC 0F 92 C0 4D 85 ED 4C 89 64 24 78 40 0F 94 C5 09 E8 0F B6 C0 E9 E4 F8 FF FF 49 83 C7 01 4D 01 FB 0F 82 D5 01 00 00 4D 85 FF 0F 84 CC 01 00 00 4D 89 CF 31 D2 4D 01 F7 0F 92 C2 E9 F1 FC FF FF 0F 1F 84 00 00 00 00 00 48 8B B4 24 90 00 00 00 48 83 C6 01 49 01 F2 0F 82 AB 01 00 00 48 85 F6 0F 84 A2 01 00 00 31 C0 4C 03 5C 24 68 0F 92 C0 E9 6F FC FF FF 0F 1F 00 48 8B 94 24 88 00 00 00 4C 8B 64 24 70 48 83 C2 01 49 01 D4 0F 82 86 01 00 00 48 85 D2 0F 84 7D 01 00 00 45 31 DB 4C 8B 54 24 78 4C 03 94 24 80 00 00 00 41 0F 92 C3 E9 D5 FB FF FF 0F 1F 40 00 49 83 C5 01 4D 89 CE 4D 01 EE 0F 92 C0 4D 85 ED 40 0F 94 C7 09 F8 0F B6 F8 E9 3F FB FF FF 66 90 48 3B 02 0F 86 70 FE FF FF 0F 1F 80 00 00 00 00 49 83 C6 01 0F 84 5A 01 00 00 48 BA 00 00 00 00 64 8E 8D 37 49 39 D6 0F 85 4C FE FF FF 48 BA C0 87 AD BE 09 ED 01 00 49 39 D2 0F 85 39 FE FF FF 83 44 24 50 01 49 BE 00 00 00 00 0A 5B C1 38 49 BA 93 8D 44 C6 4D 31 00 00 E9 1B FE FF FF 66 90 48 BA FF FF FF FF 09 5B C1 38 49 39 D6 0F 87 CA FD FF FF 48 89 C2 48 C1 EA 02 48 01 C2 4D 19 C9 49 89 D3 83 E0 03 48 C1 E2 03 41 83 E1 08 49 C1 EB 3D 48 8D 04 42 4C 89 C2 48 C1 EA 02 4C 01 C2 48 19 C9 41 83 E0 03 48 89 D3 4D 01 C0 48 C1 EB 3D 83 E1 08 49 8D 14 D0 48 01 D9 8B 9C 24 9C 00 00 00 4E 8D 04 1A 4D 01 C8 49 39 D0 4C 89 F2 48 83 D1 00 48 C1 EA 02 4C 01 F2 4D 19 C9 41 83 E6 03 49 89 D3 4D 01 F6 41 83 E1 08 49 C1 EB 3D 4D 8D 34 D6 4D 01 D9 4C 89 D2 49 01 CE 49 83 D1 00 48 C1 EA 02 81 EB 71 19 00 00 4C 01 D2 41 83 E2 03 89 5C 24 50 4D 01 D2 4D 8D 14 D2 4D 01 CA E9 19 FD FF FF B8 01 00 00 00 E9 13 FB FF FF 66 90 BA 01 00 00 00 E9 B9 FA FF FF 66 0F 1F 44 00 00 BA 01 00 00 00 E9 43 FA FF FF 66 0F 1F 44 00 00 49 89 DA 48 B8 00 00 00 00 00 00 40 30 48 C7 01 00 00 00 00 49 C1 E2 3F 4C 01 D0 48 89 41 08 E9 43 FD FF FF 49 83 C2 01 E9 FC FC FF FF 0F 1F 00 48 85 D2 0F 84 4A 01 00 00 48 B9 00 00 00 00 00 00 08 00 48 85 C8 0F 84 74 01 00 00 48 89 D0 49 B8 93 8D 44 C6 4D 31 00 00 48 C1 E0 0D 48 C1 E8 12 4C 39 C0 0F 87 87 01 00 00 48 C1 E2 3B 4C 39 C0 0F 84 67 01 00 00 48 8B BC 24 30 01 00 00 48 }
	condition:
		$1
}

rule file_174_22_0 {
	meta:
		name = "__binary80_to_bid128"
		size = 4736
		refs = "017c .refptr.__bid_IDEC_glbflags 01cf .rdata 0bb4 .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC F8 00 00 00 DB 2A 48 89 8C 24 40 01 00 00 DB BC 24 E0 00 00 00 0F B7 84 24 E2 00 00 00 48 C1 E0 10 48 89 C2 0F B7 84 24 E4 00 00 00 48 C1 E0 20 48 01 D0 0F B7 94 24 E0 00 00 00 48 01 D0 0F B7 94 24 E6 00 00 00 48 C1 E2 30 48 01 D0 48 89 04 24 0F B7 84 24 E8 00 00 00 0F B7 D0 C1 FA 0F 66 25 FF 7F 89 94 24 98 00 00 00 0F 85 B6 0B 00 00 48 83 3C 24 00 0F 84 46 0D 00 00 48 8B 1C 24 48 B8 00 00 00 00 FF FF FF FF 48 21 D8 89 DA 48 39 C2 48 B8 00 00 FF FF 00 00 FF FF 48 BA FF FF 00 00 FF FF 00 00 19 C9 48 21 D8 48 21 DA F7 D1 83 E1 20 48 39 C2 48 BA FF 00 FF 00 FF 00 FF 00 19 C0 48 21 DA F7 D0 83 E0 10 01 C1 48 B8 00 FF 00 FF 00 FF 00 FF 48 21 D8 48 39 C2 48 BA 0F 0F 0F 0F 0F 0F 0F 0F 19 C0 48 21 DA F7 D0 83 E0 08 01 C1 48 B8 F0 F0 F0 F0 F0 F0 F0 F0 48 21 D8 48 39 C2 48 BA 33 33 33 33 33 33 33 33 19 C0 48 21 DA F7 D0 83 E0 04 01 C1 48 B8 CC CC CC CC CC CC CC CC 48 21 D8 48 39 C2 48 BA 55 55 55 55 55 55 55 55 19 C0 48 21 DA F7 D0 83 E0 02 01 C8 48 B9 AA AA AA AA AA AA AA AA 48 21 D9 48 39 D1 BA 31 00 00 00 0F 96 C1 0F B6 C9 01 C1 B8 C3 BF FF FF 29 C8 48 D3 E3 31 C9 89 44 24 60 48 8B 05 ?? ?? ?? ?? 48 89 1C 24 83 08 02 8B 44 24 60 83 E8 31 85 C0 0F 8E 63 0B 00 00 8B 44 24 60 B9 50 45 00 00 05 77 A4 00 00 69 D0 10 4D 00 00 69 C0 43 4D 00 00 C1 F8 10 01 D0 C1 F8 10 29 C1 8D 98 90 E6 FF FF 89 84 24 9C 00 00 00 89 CA 83 E1 7F 48 8D 05 ?? ?? ?? ?? 49 89 C8 89 5C 24 50 C1 FA 07 49 C1 E0 05 49 01 C0 83 FA 27 49 8B 58 18 49 8B 00 4D 8B 58 08 4D 8B 78 10 4C 8D 05 ?? ?? ?? ?? 48 89 5C 24 18 41 8B 1C 88 89 DF 89 5C 24 64 0F 84 C8 07 00 00 48 63 D2 48 8D 0D ?? ?? ?? ?? 49 89 D0 49 C1 E0 05 4C 01 C1 4C 8B 01 48 8B 59 08 4C 8B 51 10 48 8B 69 18 48 8D 0D ?? ?? ?? ?? 8B 14 91 89 C1 8D BC 17 00 01 00 00 48 89 C2 4C 89 C0 48 C1 EA 20 48 C1 E8 20 89 7C 24 64 44 89 C7 48 89 44 24 10 49 89 F9 48 89 7C 24 20 48 89 C6 4C 0F AF C9 48 0F AF FA 48 0F AF F2 4C 89 C8 48 C1 E8 20 41 89 F8 49 01 C0 48 89 D8 89 DB 49 89 D9 4C 89 44 24 78 49 89 D8 4C 0F AF CA 48 89 74 24 68 48 C1 E8 20 49 89 C6 48 89 44 24 28 48 89 5C 24 30 48 89 C3 4C 89 CE 4D 89 C1 4C 0F AF C9 48 0F AF DA 4C 89 C8 41 89 F1 49 89 C0 48 89 5C 24 70 89 C3 49 C1 E8 20 4D 01 C8 4D 89 F1 4D 89 D6 4C 0F AF C9 45 89 D2 49 C1 EE 20 4D 89 D5 4C 89 54 24 40 4D 89 F4 4C 0F AF EA 4C 89 74 24 38 4D 01 C8 4D 89 C1 49 C1 E1 20 4C 01 CB 4D 89 D1 45 89 EA 4C 0F AF C9 49 C1 ED 20 4C 0F AF E2 4C 89 C8 45 89 C9 48 C1 E8 20 4D 01 EC 4C 01 D0 4D 89 F2 4C 0F AF D1 49 01 C2 4D 89 D5 49 C1 ED 20 4D 01 E5 49 89 EC 89 ED 49 C1 EC 20 48 89 E8 48 89 6C 24 48 4D 89 E6 49 89 EC 4C 0F AF E2 4C 89 74 24 08 49 0F AF D6 48 C1 EF 20 48 03 7C 24 68 48 0F AF C1 45 89 E6 49 C1 EC 20 4C 01 E2 48 89 C5 89 C0 48 C1 ED 20 49 01 EE 48 8B 6C 24 08 48 0F AF E9 48 0F AF 4C 24 10 4C 01 F5 48 03 4C 24 78 49 89 EC 48 C1 E5 20 49 C1 EC 20 48 01 C5 4C 01 E2 48 C1 E9 20 48 01 CF 48 01 DF 0F 92 C0 48 C1 EE 20 48 03 74 24 70 49 C1 E2 20 49 C1 E8 20 0F B6 C0 4D 01 CA 48 89 BC 24 A0 00 00 00 49 01 C2 4C 01 C6 4C 01 D6 48 89 B4 24 A8 00 00 00 0F 82 9F 0B 00 00 4C 39 D0 0F 87 96 0B 00 00 4C 01 ED 0F 92 C0 48 89 6C 24 70 0F B6 C0 48 01 D0 4D 89 D8 45 89 DB 48 89 84 24 80 00 00 00 48 8B 44 24 20 49 C1 E8 20 48 8B 5C 24 10 4C 8B 54 24 28 48 89 C7 49 0F AF C3 49 89 DE 4C 89 D6 49 0F AF F8 49 0F AF F0 48 89 C2 89 C0 89 F9 48 C1 EA 20 48 01 CA 48 89 D9 48 89 74 24 68 49 0F AF CB 4D 0F AF F0 48 01 D1 48 89 CA 48 C1 E2 20 48 01 D0 48 89 84 24 B0 00 00 00 48 8B 44 24 30 48 89 C3 49 0F AF C3 49 0F AF D8 48 89 C2 41 89 D9 48 C1 EA 20 4C 01 CA 4D 89 D1 41 89 C2 4D 0F AF CB 4C 01 CA 49 89 D1 49 C1 E1 20 4D 01 CA 4C 8B 4C 24 40 4C 89 54 24 78 4C 8B 54 24 38 4D 89 CC 4D 0F AF CB 4C 89 D5 4D 0F AF E0 49 0F AF E8 4C 89 C8 45 89 C9 44 89 E6 48 C1 E8 20 49 C1 EC 20 48 01 F0 4C 89 D6 4C 01 E5 49 0F AF F3 48 01 C6 48 8B 44 24 48 49 89 F4 49 C1 EC 20 49 01 EC 48 89 C5 49 0F AF E8 4C 0F AF 44 24 08 49 0F AF C3 48 C1 EF 20 48 C1 E9 20 4C 0F AF 5C 24 08 41 89 EA 48 C1 ED 20 4C 01 F7 48 01 CF 49 89 C5 89 C0 49 C1 ED 20 4D 01 D5 49 01 E8 4D 01 DD 4C 89 ED 49 C1 E5 20 48 C1 ED 20 49 01 C5 49 01 E8 48 03 7C 24 78 0F 92 C1 48 C1 EB 20 48 03 5C 24 68 48 C1 E6 20 48 C1 EA 20 0F B6 C9 4C 01 CE 48 89 BC 24 B8 00 00 00 48 01 CE 48 01 D3 48 01 F3 48 89 9C 24 88 00 00 00 0F 82 C9 09 00 00 48 39 F1 0F 87 C0 09 00 00 4D 01 E5 0F 92 C0 4C 89 6C 24 78 0F B6 C0 4C 01 C0 45 89 F9 4D 89 F8 48 89 84 24 C0 00 00 00 48 8B 44 24 20 49 C1 E8 20 48 8B 5C 24 10 48 8B 7C 24 28 4C 8B 7C 24 38 48 89 C5 49 0F AF C1 49 89 DE 49 0F AF E8 4D 89 FC 4D 0F AF E0 48 89 C2 89 C0 89 E9 48 C1 EA 20 48 01 CA 48 89 D9 48 89 FB 49 0F AF C9 49 0F AF D8 4D 0F AF F0 48 01 D1 48 89 CA 48 89 5C 24 68 48 C1 E2 20 48 01 D0 48 89 84 24 C8 00 00 00 48 8B 44 24 30 48 89 C6 49 0F AF C1 49 0F AF F0 48 89 C2 89 C3 41 89 F2 48 C1 EA 20 4C 01 D2 49 89 FA 4D 0F AF D1 4C 01 D2 49 89 D2 49 C1 E2 20 4C 01 D3 4C 8B 54 24 40 4D 89 D3 4D 0F AF D1 4D 0F AF D8 4C 89 D0 45 89 D2 44 89 DF 48 C1 E8 20 49 C1 EB 20 48 01 F8 4C 89 FF 4D 01 DC 49 0F AF F9 48 01 C7 48 8B 44 24 48 49 89 FB 49 C1 EB 20 4D 01 E3 49 89 C4 4D 0F AF E0 4C 0F AF 44 24 08 49 0F AF C1 48 C1 ED 20 48 C1 E9 20 4C 0F AF 4C 24 08 45 89 E7 49 C1 EC 20 4C 01 F5 48 01 CD 49 89 C5 89 C0 49 C1 ED 20 4D 01 FD 4D 01 E0 4D 01 CD 4D 89 EC 49 C1 E5 20 49 C1 EC 20 49 01 C5 4D 01 E0 48 01 DD 41 0F 92 C1 48 C1 EE 20 48 03 74 24 68 48 C1 E7 20 48 C1 EA 20 45 0F B6 C9 4C 01 D7 48 89 AC 24 D0 00 00 00 4C 01 CF 48 01 D6 48 01 FE 48 89 B4 24 90 00 00 00 0F 82 5A 08 00 00 49 39 F9 0F 87 51 08 00 00 4D 01 DD 0F 92 C0 4C 89 6C 24 68 0F B6 C0 4C 01 C0 48 8B 54 24 20 48 8B 5C 24 10 48 89 84 24 D8 00 00 00 48 8B 44 24 18 48 8B 7C 24 28 4C 8B 54 24 40 48 89 D5 49 89 DE 4C 8B 7C 24 38 89 C1 49 89 C0 49 C1 E8 20 48 0F AF D1 4D 89 FC 49 0F AF E8 4D 0F AF E0 48 89 D0 89 D2 41 89 E9 48 C1 E8 20 4C 01 C8 49 89 D9 4C 0F AF C9 4D 0F AF F0 4C 01 C8 49 89 C1 49 C1 E1 20 49 8D 1C 11 48 8B 54 24 30 48 89 5C 24 10 48 89 FB 48 89 D6 48 0F AF D1 49 0F AF F0 49 0F AF D8 49 89 D1 41 89 F3 49 C1 E9 20 4D 01 D9 49 89 FB 48 89 5C 24 18 4C 0F AF D9 89 D3 4D 01 CB 4D 89 D9 49 C1 E1 20 4C 01 CB 4D 89 D1 4C 0F AF D1 4D 0F AF C8 4C 89 D2 45 89 D2 44 89 CF 48 C1 EA 20 49 C1 E9 20 48 01 FA 4C 89 FF 4D 01 CC 48 0F AF F9 48 01 D7 48 8B 54 24 48 49 89 F9 49 C1 E9 20 4D 01 E1 49 89 D4 48 0F AF D1 4D 0F AF E0 4C 0F AF 44 24 08 49 89 D5 89 D2 49 C1 ED 20 45 89 E7 48 C1 ED 20 48 0F AF 4C 24 08 4D 01 FD 49 C1 EC 20 4C 01 F5 48 C1 E8 20 4D 01 E0 48 01 C5 49 01 CD 4D 89 EC 49 C1 E5 20 49 C1 EC 20 49 01 D5 31 D2 4D 01 E0 48 01 EB 0F 92 C2 48 C1 EE 20 48 03 74 24 18 48 C1 E7 20 49 C1 EB 20 49 01 FA 49 01 D2 49 01 F3 4D 89 DF 4D 01 D7 0F 82 28 06 00 00 4C 39 D2 0F 87 1F 06 00 00 4D 89 EA 45 31 F6 4D 01 CA 41 0F 92 C6 48 8B 84 24 A0 00 00 00 4D 01 C6 48 03 84 24 B0 00 00 00 48 8B BC 24 B8 00 00 00 48 8B B4 24 A8 00 00 00 0F 92 C0 0F B6 C0 48 01 C7 48 01 FE 0F 82 2D 06 00 00 48 39 F8 0F 87 24 06 00 00 31 D2 48 8B 6C 24 70 48 03 AC 24 88 00 00 00 0F 92 C2 48 8B 44 24 78 4C 8B A4 24 80 00 00 00 48 01 D0 49 01 C4 0F 92 C1 48 39 D0 0F 92 C0 09 C1 0F B6 C9 48 8B 84 24 C8 00 00 00 4C 63 D9 48 8B 8C 24 D0 00 00 00 45 31 C0 4C 03 9C 24 C0 00 00 00 48 01 F0 41 0F 92 C0 4C 01 C1 48 01 CD 0F 82 90 05 00 00 49 39 C8 0F 87 87 05 00 00 31 D2 4C 03 A4 24 90 00 00 00 0F 92 C2 4C 8B 6C 24 68 49 01 D5 4D 01 EB 0F 92 C0 49 39 D5 0F 92 C2 09 D0 0F B6 C0 4C 63 C8 48 8B 44 24 10 31 D2 4C 03 8C 24 D8 00 00 00 48 01 E8 0F 92 C2 48 01 D3 49 01 DC 0F 82 ED 04 00 00 48 39 DA 0F 87 E4 04 00 00 31 C0 4D 01 FB 0F 92 C0 4E 8D 2C 10 4D 89 CF 4D 01 EF 0F 92 C1 49 39 C5 0F 92 C0 09 C1 0F B6 C9 49 8D 04 0E 48 89 44 24 18 49 8D 44 24 01 48 8B 7C 24 18 49 89 C5 89 C0 49 89 C4 4C 89 DE 45 89 DB 48 C1 EE 20 4C 89 DD 49 C1 ED 20 89 F9 48 89 FB 48 8B 3C 24 45 89 F9 4D 89 FE 48 C1 EB 20 49 C1 EE 20 49 89 FA 89 FA 4C 89 EF 49 C1 EA 20 4D 0F AF E2 48 0F AF C2 4C 0F AF DA 45 89 E0 48 C1 E8 20 4C 01 C0 48 89 44 24 10 48 89 F0 49 0F AF C2 49 0F AF EA 48 0F AF F2 48 89 44 24 08 4C 89 D8 41 89 E8 48 C1 E8 20 4C 01 C0 49 89 F0 49 01 C0 44 89 D8 4C 89 C6 49 0F AF FA 48 C1 E6 20 48 01 F0 4C 89 CE 4C 0F AF CA 49 0F AF F2 48 89 3C 24 4C 89 F7 4C 0F AF F2 4D 89 CB 45 89 C9 49 C1 EB 20 49 0F AF FA 41 89 F7 48 C1 EE 20 4D 01 FB 4D 01 F3 48 01 F7 4C 89 DE 48 C1 EE 20 48 01 F7 48 89 CE 48 0F AF CA 49 0F AF F2 4C 0F AF D3 49 89 CE 89 C9 49 C1 EE 20 41 89 F7 49 C1 EC 20 48 0F AF DA 4C 03 24 24 4D 01 FE 49 0F AF D5 48 C1 EE 20 48 03 54 24 10 49 01 F2 49 01 DE 4C 89 F6 49 C1 E6 20 48 C1 EA 20 48 C1 EE 20 49 01 CE 49 01 D4 49 01 F2 31 D2 4C 01 E0 0F 92 C2 48 C1 ED 20 48 03 6C 24 08 49 C1 E3 20 49 C1 E8 20 4D 01 CB 49 01 D3 49 01 E8 4D 01 D8 0F 82 44 03 00 00 4C 39 DA 0F 87 3B 03 00 00 31 F6 4C 01 F7 40 0F 92 C6 41 B9 40 FF FF FF 44 2B 4C 24 60 41 BB 40 00 00 00 44 2B 4C 24 64 4C 89 C2 49 01 F2 4D 89 D6 45 29 CB 44 89 D9 48 D3 E2 44 89 C9 48 D3 E8 44 89 D9 48 01 D0 48 89 FA 48 D3 E2 44 89 C9 49 D3 E8 44 89 D9 49 D3 E6 44 89 C9 49 01 D0 48 D3 EF 49 D3 EA 48 BA 92 8D 44 C6 4D 31 00 00 4C 01 F7 49 39 D2 0F 86 4A 04 00 00 B2 93 49 39 D2 0F 84 22 04 00 00 48 8B 15 ?? ?? ?? ?? 8B 9C 24 98 00 00 00 49 89 F9 41 83 E1 01 8B 12 C1 E2 02 8D 0C 5A 48 8D 15 ?? ?? ?? ?? 4C 01 C9 48 C1 E1 04 48 01 D1 4C 3B 41 08 0F 87 D7 03 00 00 0F 84 C3 03 00 00 4C 09 C0 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 20 48 8B 84 24 40 01 00 00 48 63 B4 24 98 00 00 00 48 89 38 48 8B 44 24 50 48 C1 E6 3F 49 01 F2 48 C1 E0 31 49 01 C2 48 8B 84 24 40 01 00 00 4C 89 50 08 E9 BA 01 00 00 66 3D FF 7F 44 0F B7 C0 0F 84 DD 01 00 00 48 83 3C 24 00 0F 84 C2 01 00 00 48 8B 1C 24 48 89 D8 48 F7 D8 48 21 D8 89 C2 48 83 FA 01 48 BA FF FF 00 00 FF FF 00 00 19 C9 48 21 C2 83 E1 20 48 83 FA 01 19 D2 83 E2 10 01 D1 48 BA FF 00 FF 00 FF 00 FF 00 48 21 C2 48 83 FA 01 19 D2 83 E2 08 01 D1 48 BA 0F 0F 0F 0F 0F 0F 0F 0F 48 21 C2 48 83 FA 01 19 D2 83 E2 04 01 D1 48 BA 33 33 33 33 33 33 33 33 48 21 C2 48 83 FA 01 19 D2 83 E2 02 01 CA 48 B9 55 55 55 55 55 55 55 55 48 85 C8 0F 94 C0 0F B6 C0 8D 0C 02 8D 51 31 41 8D 80 C2 BF FF FF 89 44 24 60 8B 44 24 60 83 E8 31 85 C0 0F 8F 9D F4 FF FF 01 D0 89 C2 F7 DA 85 D2 0F 8E D9 04 00 00 83 FA 30 0F 8F 86 F4 FF FF 48 63 D2 4C 8D 05 ?? ?? ?? ?? 4C 8B 1C 24 49 89 D1 49 C1 E1 04 4D 01 C8 49 D3 EB 49 83 78 08 00 4D 8B 08 0F 84 97 04 00 00 48 8D 0D ?? ?? ?? ?? 48 C1 E2 04 4C 89 DB 48 C1 EB 20 44 89 DE 05 20 18 00 00 48 01 CA 49 89 D9 48 C1 E0 31 48 8B 0A 4C 0F AF 5A 08 48 63 94 24 98 00 00 00 49 89 CA 89 C9 49 C1 EA 20 4C 0F AF C9 48 0F AF CE 48 C1 E2 3F 49 0F AF F2 49 01 D3 44 89 CF 49 C1 E9 20 49 89 C8 89 C9 4C 0F AF D3 49 C1 E8 20 48 8B 9C 24 40 01 00 00 49 01 F8 49 01 F0 4C 89 C2 49 C1 E0 20 4D 01 DA 48 C1 EA 20 4C 01 C1 4D 01 D1 48 89 0B 4C 01 C8 48 01 D0 48 89 43 08 EB 21 66 90 48 63 C2 48 BA 00 00 00 00 00 00 40 30 48 C7 01 00 00 00 00 48 C1 E0 3F 48 01 D0 48 89 41 08 48 8B 84 24 40 01 00 00 48 81 C4 F8 00 00 00 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 BA 71 00 00 00 B9 40 00 00 00 E9 C0 FE FF FF 90 48 B8 FF FF FF FF FF FF FF 7F 48 85 04 24 0F 85 E0 02 00 00 48 8B 84 24 40 01 00 00 48 8B 9C 24 40 01 00 00 48 BA 00 00 00 00 00 00 00 78 48 C7 00 00 00 00 00 48 63 84 24 98 00 00 00 48 C1 E0 3F 48 01 D0 48 89 43 08 EB 85 66 0F 1F 44 00 00 49 83 C6 01 4C 01 F7 40 0F 92 C6 4D 85 F6 0F 94 C2 09 D6 40 0F B6 F6 E9 B2 FC FF FF 0F 1F 40 00 49 83 C7 01 4D 01 FB 0F 82 13 02 00 00 4D 85 FF 0F 84 0A 02 00 00 4D 89 CF 31 C9 4D 01 D7 0F 92 C1 E9 16 FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 49 83 C5 01 4D 89 CA 4D 01 EA 0F 92 C0 4D 85 ED 41 0F 94 C6 44 09 F0 44 0F B6 F0 E9 CE F9 FF FF 48 8B B4 24 90 00 00 00 48 83 C6 01 49 01 F4 0F 82 AE 01 00 00 48 85 F6 0F 84 A5 01 00 00 31 C0 4C 03 5C 24 68 0F 92 C0 E9 72 FA FF FF 0F 1F 00 48 8B 94 24 88 00 00 00 48 8B 6C 24 70 48 83 C2 01 48 01 D5 0F 82 96 01 00 00 48 85 D2 0F 84 8D 01 00 00 31 C9 4C 8B 64 24 78 4C 03 A4 24 80 00 00 00 0F 92 C1 E9 D5 F9 FF FF 66 0F 1F 44 00 00 49 83 C5 01 4D 01 EC 0F 92 C0 4D 85 ED 4C 89 64 24 78 40 0F 94 C5 09 E8 0F B6 C0 E9 2E F6 FF FF 49 83 C5 01 4D 01 EB 0F 92 C0 4D 85 ED 4C 89 5C 24 68 41 0F 94 C4 44 09 E0 0F B6 C0 E9 9C F7 FF FF 48 83 C5 01 49 01 ED 0F 92 C0 48 85 ED 4C 89 6C 24 70 41 0F 94 C4 44 09 E0 0F B6 C0 E9 57 F4 FF FF 48 3B 01 0F 86 34 FC FF FF 0F 1F 44 00 00 48 83 C7 01 0F 85 06 01 00 00 49 83 C2 01 E9 1C FC FF FF 48 BA FF FF FF FF 09 5B C1 38 48 39 D7 0F 87 CB FB FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 89 C2 48 C1 EA 02 48 01 C2 4D 19 C9 49 89 D3 }
	condition:
		$1
}

rule file_174_23_0 {
	meta:
		name = "__binary128_to_bid128"
		size = 5984
		refs = "014e .refptr.__bid_IDEC_glbflags 0187 .rdata 0fb1 .refptr.__bid_IDEC_glbround"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 81 EC F8 00 00 00 4C 8B 0A 48 8B 52 08 49 B8 FF FF FF FF FF FF 00 00 48 89 8C 24 40 01 00 00 48 89 D0 48 89 D6 49 21 D0 48 C1 E8 30 48 C1 EE 3F 25 FF 7F 00 00 48 89 74 24 08 0F 85 43 02 00 00 4D 85 C0 0F 84 EE 0F 00 00 48 B8 00 00 00 00 FF FF 00 00 89 D1 49 89 D2 48 21 D0 48 39 C1 48 B8 FF FF 00 00 FF FF 00 00 19 C9 48 21 D0 41 81 E2 00 00 FF FF F7 D1 83 E1 20 4C 39 D0 49 BA FF 00 FF 00 FF 00 00 00 19 C0 49 21 D2 F7 D0 83 E0 10 01 C1 48 B8 00 FF 00 FF 00 FF 00 00 48 21 D0 49 39 C2 49 BA 0F 0F 0F 0F 0F 0F 00 00 19 C0 49 21 D2 F7 D0 83 E0 08 01 C1 48 B8 F0 F0 F0 F0 F0 F0 00 00 48 21 D0 49 39 C2 49 BA 33 33 33 33 33 33 00 00 19 C0 49 21 D2 F7 D0 83 E0 04 01 C1 48 B8 CC CC CC CC CC CC 00 00 48 21 D0 49 39 C2 49 BA AA AA AA AA AA AA 00 00 19 C0 49 21 D2 F7 D0 83 E0 02 01 C8 48 B9 55 55 55 55 55 55 00 00 48 21 CA 49 39 D2 0F 96 C2 0F B6 D2 8D 44 10 F1 85 C0 0F 85 FD 0F 00 00 4C 89 CA 49 C1 E1 0F C7 44 24 60 92 BF FF FF 48 C1 EA 31 4C 89 4C 24 70 48 8B 05 ?? ?? ?? ?? 49 C1 E0 0F 83 08 02 49 8D 04 10 31 D2 48 89 44 24 68 8B 44 24 60 44 8D 04 10 44 89 C0 F7 D8 85 C0 0F 8E D7 14 00 00 83 F8 30 0F 8F E7 01 00 00 48 98 48 8D 0D ?? ?? ?? ?? 49 89 C1 49 C1 E1 04 4C 01 C9 83 FA 30 4C 8B 11 4C 8B 49 08 0F 8F FD 14 00 00 41 BB 31 00 00 00 48 8B 7C 24 68 8D 5A 0F 44 89 D9 29 D1 48 8B 54 24 70 49 89 FB 49 D3 E3 89 D9 48 D3 EA 4C 01 DA 49 89 FB 49 D3 EB 4C 89 DB 49 39 D9 77 17 49 39 D2 0F 82 87 01 00 00 49 39 D9 0F 85 7E 01 00 00 0F 1F 44 00 00 48 8D 0D ?? ?? ?? ?? 48 C1 E0 04 48 89 D6 48 C1 EE 20 89 D5 41 81 C0 20 18 00 00 48 01 C8 49 89 F2 49 C1 E0 31 48 8B 38 48 0F AF 50 08 89 F9 49 89 FB 49 C1 EB 20 4C 0F AF D1 48 0F AF CD 49 0F AF EB 45 89 D4 49 C1 EA 20 49 89 C9 89 C9 49 C1 E9 20 4D 01 E1 49 01 E9 48 8B 6C 24 08 48 0F AF DF 4C 89 C8 49 C1 E1 20 4C 0F AF DE 48 C1 E8 20 49 01 C9 48 C1 E5 3F 49 01 E8 49 01 D8 4C 01 C2 4C 01 DA 49 01 D2 49 01 C2 48 8B 84 24 40 01 00 00 4C 89 08 4C 89 50 08 E9 9B 0D 00 00 0F 1F 00 3D FF 7F 00 00 0F 84 75 0F 00 00 48 BA 00 00 00 00 00 00 01 00 49 01 D0 4D 85 C9 0F 84 BF 0E 00 00 4D 89 CA 49 F7 DA 4D 21 CA 44 89 D2 48 83 FA 01 48 BA FF FF 00 00 FF FF 00 00 19 C9 4C 21 D2 83 E1 20 48 83 FA 01 19 D2 83 E2 10 01 D1 48 BA FF 00 FF 00 FF 00 FF 00 4C 21 D2 48 83 FA 01 19 D2 83 E2 08 01 D1 48 BA 0F 0F 0F 0F 0F 0F 0F 0F 4C 21 D2 48 83 FA 01 19 D2 83 E2 04 01 D1 48 BA 33 33 33 33 33 33 33 33 4C 21 D2 48 83 FA 01 19 D2 83 E2 02 01 CA 48 B9 55 55 55 55 55 55 55 55 49 85 CA 0F 94 C1 0F B6 C9 01 CA 4C 89 CB 49 C1 E0 0F 49 C1 E9 31 48 C1 E3 0F 2D 6F 40 00 00 48 89 5C 24 70 4B 8D 1C 08 85 C0 89 44 24 60 48 89 5C 24 68 0F 8E FB FD FF FF 8B 44 24 60 B9 50 45 00 00 05 A8 A4 00 00 69 D0 10 4D 00 00 69 C0 43 4D 00 00 C1 F8 10 01 D0 C1 F8 10 29 C1 8D 98 90 E6 FF FF 89 84 24 AC 00 00 00 41 89 C9 83 E1 7F 48 8D 05 ?? ?? ?? ?? 49 89 C8 89 5C 24 50 41 C1 F9 07 49 C1 E0 05 49 01 C0 41 83 F9 27 49 8B 58 18 49 8B 10 49 8B 40 08 4D 8B 78 10 4C 8D 05 ?? ?? ?? ?? 41 8B 34 88 48 89 5C 24 18 89 74 24 64 0F 84 EB 07 00 00 4D 63 C9 48 8D 0D ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? 4D 89 C8 49 C1 E0 05 47 8B 0C 8A 49 89 D2 49 01 C8 49 C1 EA 20 89 D2 49 8B 08 49 8B 58 08 42 8D B4 0E 00 01 00 00 4D 8B 58 10 4D 8B 40 18 89 CF 89 74 24 64 48 89 CE 48 89 FD 48 89 F9 48 C1 EE 20 49 0F AF EA 48 89 74 24 10 48 89 7C 24 20 48 0F AF CA 48 89 F7 49 0F AF FA 41 89 E9 48 C1 E9 20 49 8D 34 09 48 89 7C 24 78 48 89 B4 24 88 00 00 00 48 89 DE 48 C1 EE 20 49 89 F6 48 89 74 24 28 89 DE 48 89 F1 48 89 74 24 30 4C 89 F7 48 0F AF CA 49 0F AF F2 49 0F AF FA 49 89 C9 89 F3 49 C1 E9 20 49 01 D9 4C 89 F3 48 89 BC 24 80 00 00 00 48 0F AF DA 49 01 D9 89 CB 4C 89 D9 48 C1 E9 20 4D 89 CC 49 89 CE 48 89 4C 24 38 44 89 D9 49 89 CB 48 89 4C 24 40 49 C1 E4 20 4C 0F AF DA 4C 01 E3 4D 89 F4 49 0F AF CA 4D 0F AF E2 4C 89 DF 45 89 DB 41 89 CD 48 C1 EF 20 48 C1 E9 20 4C 01 EF 4D 89 F5 49 01 CC 4C 0F AF EA 4C 01 EF 48 89 F9 48 C1 E9 20 4C 01 E1 4D 89 C4 45 89 C0 49 C1 EC 20 4D 89 C5 4C 89 44 24 48 4D 0F AF EA 4C 89 24 24 4D 0F AF D4 4C 0F AF C2 48 C1 ED 20 48 03 6C 24 78 45 89 EE 49 C1 ED 20 4D 01 EA 4D 89 C4 45 89 C0 49 C1 EC 20 4D 01 E6 4C 8B 24 24 4C 0F AF E2 48 0F AF 54 24 10 4D 01 F4 48 03 94 24 88 00 00 00 4D 89 E5 49 C1 E4 20 49 C1 ED 20 4D 01 C4 4D 01 EA 48 C1 EA 20 48 01 D5 48 01 DD 0F 92 C2 48 C1 EE 20 48 03 B4 24 80 00 00 00 48 C1 E7 20 49 C1 E9 20 0F B6 D2 4C 01 DF 48 89 AC 24 B0 00 00 00 48 01 D7 4C 01 CE 48 01 FE 48 89 B4 24 B8 00 00 00 0F 82 6F 0E 00 00 48 39 FA 0F 87 66 0E 00 00 49 01 CC 0F 92 C2 4C 89 64 24 78 0F B6 D2 0F 1F 84 00 00 00 00 00 49 8D 1C 12 48 8B 54 24 20 49 89 C1 89 C0 49 C1 E9 20 48 8B 74 24 10 48 89 9C 24 90 00 00 00 4C 8B 5C 24 28 48 89 D7 48 0F AF D0 49 89 F6 49 0F AF F9 4D 0F AF F1 48 89 D1 89 D2 41 89 F8 48 C1 E9 20 4C 01 C1 49 89 F0 4C 89 DE 4C 0F AF C0 49 0F AF F1 49 01 C8 4C 89 C1 48 89 B4 24 80 00 00 00 48 C1 E1 20 48 8D 1C 11 48 8B 54 24 30 48 89 9C 24 C0 00 00 00 48 89 D3 48 0F AF D0 49 0F AF D9 48 89 D1 41 89 DA 48 C1 E9 20 4C 01 D1 4D 89 DA 41 89 D3 4C 0F AF D0 4C 01 D1 49 89 CA 49 C1 E2 20 4B 8D 14 1A 4C 8B 54 24 40 4C 8B 5C 24 38 48 89 94 24 88 00 00 00 4D 89 D4 4C 89 DD 4C 0F AF D0 4D 0F AF E1 49 0F AF E9 4C 89 D2 45 89 D2 44 89 E6 48 C1 EA 20 49 C1 EC 20 48 01 F2 4C 89 DE 4C 01 E5 48 0F AF F0 48 01 D6 48 8B 54 24 48 49 89 F4 49 C1 EC 20 49 01 EC 48 89 D5 48 0F AF D0 49 0F AF E9 4C 0F AF 0C 24 49 89 D5 89 D2 41 89 EB 49 C1 ED 20 4D 01 DD 48 0F AF 04 24 48 C1 ED 20 48 C1 EF 20 49 C1 E8 20 49 01 E9 4C 01 F7 4C 01 C7 49 01 C5 48 89 F8 4C 89 ED 49 C1 E5 20 48 C1 ED 20 49 01 D5 49 01 E9 48 03 84 24 88 00 00 00 48 89 84 24 C8 00 00 00 0F 92 C0 48 C1 EB 20 48 03 9C 24 80 00 00 00 48 C1 E6 20 48 C1 E9 20 4C 01 D6 0F B6 C0 48 01 C6 48 01 CB 48 01 F3 48 89 9C 24 98 00 00 00 0F 82 72 0C 00 00 48 39 F0 0F 87 69 0C 00 00 4D 01 E5 0F 92 C0 4C 89 AC 24 80 00 00 00 0F B6 C0 0F 1F 84 00 00 00 00 00 4C 01 C8 45 89 FA 4D 89 F9 48 89 84 24 D0 00 00 00 48 8B 44 24 20 49 C1 E9 20 48 8B 7C 24 10 4C 8B 7C 24 28 4C 8B 5C 24 40 48 89 C5 49 0F AF C2 49 89 FE 49 0F AF E9 4D 0F AF F1 48 89 C2 89 C0 41 89 E8 48 C1 EA 20 4C 01 C2 49 89 F8 4C 89 FF 4D 0F AF C2 49 0F AF F9 49 01 D0 4C 89 C2 48 89 BC 24 88 00 00 00 48 C1 E2 20 48 01 D0 48 89 84 24 D8 00 00 00 48 8B 44 24 30 48 89 C6 49 0F AF C2 49 0F AF F1 48 89 C2 89 C3 4C 89 D8 89 F1 48 C1 EA 20 48 01 CA 4C 89 F9 4C 8B 7C 24 38 49 0F AF CA 4D 0F AF DA 49 0F AF C1 4D 89 FC 48 01 D1 48 89 CA 48 C1 E2 20 89 C7 48 C1 E8 20 48 01 D3 4C 89 DA 45 89 DB 48 C1 EA 20 48 01 FA 4C 89 FF 49 0F AF FA 4D 0F AF E1 48 01 D7 48 8B 54 24 48 49 01 C4 48 89 F8 48 C1 E8 20 4C 01 E0 49 89 D4 4D 0F AF E1 4C 0F AF 0C 24 49 0F AF D2 48 C1 ED 20 49 C1 E8 20 4C 0F AF 14 24 45 89 E7 49 C1 EC 20 4C 01 F5 4C 01 C5 49 89 D5 89 D2 49 C1 ED 20 4D 01 FD 4D 01 E1 4D 01 D5 4D 89 EC 49 C1 E5 20 49 C1 EC 20 49 01 D5 4D 01 E1 48 01 DD 41 0F 92 C0 48 C1 EE 20 48 03 B4 24 88 00 00 00 48 C1 E7 20 48 C1 E9 20 45 0F B6 C0 4C 01 DF 48 89 AC 24 E0 00 00 00 4C 01 C7 48 01 CE 48 01 FE 48 89 B4 24 A0 00 00 00 0F 82 F8 0A 00 00 49 39 F8 0F 87 EF 0A 00 00 49 01 C5 0F 92 C0 4C 89 AC 24 88 00 00 00 0F B6 C0 4C 01 C8 48 8B 74 24 10 48 8B 5C 24 28 48 89 84 24 E8 00 00 00 48 8B 44 24 18 4C 8B 5C 24 40 4C 8B 7C 24 38 49 89 F6 89 C1 49 89 C1 48 8B 44 24 20 49 C1 E9 20 4D 0F AF F1 48 89 C5 48 0F AF C1 49 0F AF E9 48 89 C2 89 C0 48 C1 EA 20 41 89 E8 4C 01 C2 49 89 F0 4C 0F AF C1 4C 01 C2 49 89 D0 49 C1 E0 20 4C 01 C0 4C 8B 44 24 30 48 89 44 24 10 48 89 D8 49 0F AF C1 4C 89 C6 4C 0F AF C1 49 0F AF F1 48 89 44 24 18 4C 89 C0 48 C1 E8 20 41 89 F2 4C 01 D0 49 89 DA 44 89 C3 4C 0F AF D1 4D 89 F8 4D 0F AF C1 4C 01 D0 49 89 C2 49 C1 E2 20 4C 01 D3 4D 89 DA 4C 0F AF D9 4D 0F AF D1 4C 89 DF 45 89 DB 45 89 D4 48 C1 EF 20 49 C1 EA 20 4C 01 E7 4D 89 FC 4D 01 D0 4C 0F AF E1 4C 01 E7 49 89 FA 49 C1 EA 20 4D 01 C2 4C 8B 44 24 48 4D 89 C4 4D 0F AF E1 4C 0F AF 0C 24 4C 0F AF C1 48 C1 ED 20 48 C1 EA 20 48 0F AF 0C 24 45 89 E7 49 C1 EC 20 4C 01 F5 48 01 D5 31 D2 4D 89 C5 45 89 C0 49 C1 ED 20 4D 01 FD 4D 01 E1 49 01 CD 4D 89 EC 49 C1 E5 20 49 C1 EC 20 4D 01 C5 4D 01 E1 48 01 EB 0F 92 C2 48 C1 EE 20 48 03 74 24 18 48 C1 E7 20 48 C1 E8 20 49 01 FB 49 01 D3 48 01 F0 4C 01 D8 49 89 C7 0F 82 C1 08 00 00 4C 39 DA 0F 87 B8 08 00 00 4C 89 EF 45 31 F6 4C 01 D7 41 0F 92 C6 48 8B 84 24 B0 00 00 00 4D 01 CE 48 03 84 24 C0 00 00 00 4C 8B 84 24 C8 00 00 00 48 8B B4 24 B8 00 00 00 0F 92 C0 0F B6 C0 49 01 C0 4C 01 C6 0F 82 C6 08 00 00 4C 39 C0 0F 87 BD 08 00 00 31 C0 4C 8B 64 24 78 4C 03 A4 24 98 00 00 00 0F 92 C0 4C 8B AC 24 80 00 00 00 4C 8B 9C 24 90 00 00 00 49 01 C5 4D 01 EB 0F 92 C2 49 39 C5 0F 92 C0 09 C2 0F B6 C2 48 8B 8C 24 D8 00 00 00 48 8B AC 24 E0 00 00 00 31 D2 48 03 84 24 D0 00 00 00 48 01 F1 0F 92 C2 48 01 D5 49 01 EC 0F 82 2B 08 00 00 48 39 EA 0F 87 22 08 00 00 31 C9 4C 03 9C 24 A0 00 00 00 0F 92 C1 4C 8B AC 24 88 00 00 00 49 01 CD 4C 01 E8 0F 92 C2 49 39 CD 0F 92 C1 09 CA 0F B6 D2 48 8B 74 24 10 31 C9 4C 63 D2 4C 03 94 24 E8 00 00 00 4C 01 E6 0F 92 C1 48 01 CB 49 01 DB 0F 82 85 07 00 00 48 39 D9 0F 87 7C 07 00 00 31 D2 4C 01 F8 0F 92 C2 4C 8D 2C 3A 4D 89 D7 4D 01 EF 0F 92 C1 49 39 D5 0F 92 C2 09 D1 0F B6 C9 49 8D 1C 0E 49 8D 53 01 48 89 5C 24 18 48 8B 74 24 70 49 89 D0 89 D2 49 C1 E8 20 49 89 D4 48 89 D1 48 89 F3 41 89 F1 4C 89 C6 48 C1 EB 20 48 0F AF F3 4C 0F AF E3 49 0F AF C9 48 89 74 24 20 48 89 C6 89 C0 48 C1 EE 20 45 89 E2 48 C1 E9 20 48 89 74 24 28 49 8D 3C 0A 48 89 F1 48 0F AF CB 48 89 7C 24 38 48 89 C7 48 0F AF FB 48 89 4C 24 30 48 89 C1 49 0F AF C9 41 89 FB 49 89 CA 89 C9 49 C1 EA 20 4D 01 DA 49 89 F3 4D 0F AF D9 4F 8D 34 1A 4D 89 F2 4C 89 74 24 40 49 C1 E2 20 4D 8D 34 0A 45 89 FA 4C 89 D1 4C 89 74 24 48 4D 89 FE 49 C1 EE 20 4D 89 F7 4D 89 F5 4C 89 74 24 70 4D 89 D6 4D 0F AF F1 48 0F AF CB 4C 0F AF EB 4C 89 F6 49 C1 EE 20 89 CD 4D 89 F3 48 C1 E9 20 49 01 EB 4C 89 FD 49 01 CD 49 0F AF E9 89 F6 4C 01 DD 49 89 EE 49 C1 EE 20 4D 01 F5 4C 8B 74 24 18 4C 89 6C 24 10 44 89 F1 4D 89 F7 49 89 CB 49 89 CE 49 C1 EF 20 4D 0F AF D9 4C 89 3C 24 4C 0F AF F3 49 0F AF DF 4D 89 DD 45 89 DB 49 C1 ED 20 45 89 F7 4D 01 EF 4C 8B 2C 24 4D 0F AF E9 4D 01 FD 49 C1 EC 20 4C 03 64 24 20 4D 0F AF C8 49 C1 EE 20 4C 03 4C 24 38 4C 01 F3 4D 89 EE 49 C1 EE 20 49 C1 E5 20 4D 01 DD 4C 01 F3 4C 8B 5C 24 40 49 C1 E9 20 4D 01 CC 4C 03 64 24 48 41 0F 92 C1 48 C1 EF 20 48 03 7C 24 30 48 C1 E5 20 49 C1 EB 20 45 0F B6 C9 48 01 F5 4C 89 64 24 18 4C 01 CD 4C 01 DF 48 01 EF 48 89 7C 24 20 0F 82 6E 05 00 00 49 39 E9 0F 87 65 05 00 00 4C 8B 7C 24 10 48 8B 74 24 68 45 31 F6 4D 01 EF 49 89 F3 41 89 F1 41 0F 92 C6 49 C1 EB 20 48 89 D6 4C 01 F3 4C 8B 74 24 28 48 89 5C 24 10 4C 89 C3 49 0F AF DB 49 0F AF D1 49 0F AF F3 48 89 5C 24 30 48 89 D3 89 D2 4D 0F AF C1 89 F7 48 C1 EB 20 48 01 FB 49 01 D8 4C 89 F3 4C 89 C7 48 C1 E7 20 48 8D 3C 17 49 0F AF DB 48 89 7C 24 38 48 89 C7 49 0F AF C1 49 0F AF FB 48 89 5C 24 28 48 89 C2 89 C0 48 C1 EA 20 89 FB 48 01 DA 4C 89 F3 4C 8B 74 24 70 49 0F AF D9 4D 89 F4 48 01 DA 48 89 D5 48 C1 E5 20 48 01 E8 4C 89 D5 49 0F AF EB 4D 0F AF D1 4D 0F AF E3 41 89 ED 48 89 EB 4C 89 D5 48 C1 EB 20 45 89 D2 48 C1 ED 20 49 01 DC 4C 01 ED 4D 89 F5 4D 0F AF E9 4C 01 ED 49 89 ED 49 C1 ED 20 4C 89 EB 4C 01 E3 49 89 CC 49 0F AF C9 4D 0F AF E3 4C 0F AF 1C 24 49 89 CD 89 C9 49 C1 ED 20 45 89 E6 48 C1 EE 20 4C 0F AF 0C 24 48 03 74 24 30 4D 01 F5 49 C1 EC 20 49 C1 E8 20 4D 01 E3 4C 01 C6 45 31 C0 4D 01 CD 4D 89 EC 49 C1 E5 20 49 C1 EC 20 4C 01 E9 4D 01 E3 48 01 F0 41 0F 92 C0 48 C1 EF 20 48 03 7C 24 28 48 C1 E5 20 48 C1 EA 20 4C 01 D5 4C 01 C5 48 01 D7 48 01 EF 0F 82 E5 03 00 00 49 39 E8 0F 87 DC 03 00 00 31 D2 48 01 CB 0F 92 C2 4D 8D 24 13 48 8B 74 24 18 31 D2 48 03 74 24 38 4C 8B 44 24 20 0F 92 C2 48 01 D0 49 01 C0 0F 82 DC 03 00 00 48 39 C2 0F 87 D3 03 00 00 49 01 FF 0F 92 C0 4D 89 FD 0F B6 C0 48 8D 0C 18 48 8B 5C 24 10 48 01 CB 0F 92 C2 48 39 C1 0F 92 C0 09 C2 0F B6 D2 B8 0F FF FF FF 2B 44 24 60 41 B9 40 00 00 00 2B 44 24 64 4D 89 EA 4C 01 E2 4C 89 EF 48 89 D6 41 29 C1 44 89 C9 49 D3 E2 89 C1 49 D3 E8 48 D3 EF 44 89 C9 4D 01 D0 49 89 DA 48 D3 E6 49 D3 E2 89 C1 48 B8 92 8D 44 C6 4D 31 00 00 48 D3 EB 48 D3 EA 4C 01 D7 48 01 F3 48 39 C2 0F 86 ED 04 00 00 B0 93 48 39 C2 0F 84 C5 04 00 00 48 8B 05 ?? ?? ?? ?? 49 89 D9 41 83 E1 01 8B 08 48 8B 44 24 08 C1 E1 02 8D 04 41 48 8D 0D ?? ?? ?? ?? 4C 01 C8 48 C1 E0 04 48 01 C8 48 3B 78 08 0F 87 7C 04 00 00 0F 84 67 04 00 00 49 09 F8 74 0A 48 8B 05 ?? ?? ?? ?? 83 08 20 48 8B 84 24 40 01 00 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "__bid_extendxftd"
		size = 64
		refs = "0019 __binary80_to_bid128"
	strings:
		$1 = { 53 48 83 EC 40 DB 2A 48 89 CB 48 8D 54 24 20 48 8D 4C 24 30 DB 7C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 54 24 38 48 89 03 48 89 D8 48 89 53 08 48 83 C4 40 5B C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__bid128_to_uint32_rnint"
		size = 1696
		refs = "0092 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 015d .refptr.__bid_nr_digits 0200 .refptr.__bid_midpoint64 034f .refptr.__bid_midpoint128 0397 .refptr.__bid_ten2k128 045b .refptr.__bid_ten2mk128 05c9 .refptr.__bid_shiftright128 05de .refptr.__bid_maskhigh128 0621 .refptr.__bid_ten2mk128trunc"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 11 48 8B 49 08 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B8 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 C2 77 22 0F 85 E0 00 00 00 49 B8 FF FF FF FF 63 8E 8D 37 4D 39 C2 0F 86 CD 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FB 1E 0F 8F FF 02 00 00 41 8D 43 F5 48 8B 0D ?? ?? ?? ?? 48 98 48 8B 04 C1 49 89 C3 89 C0 48 8D 0C 85 00 00 00 00 49 89 C1 48 8D 1C C0 49 C1 E1 20 49 C1 EB 20 49 29 C9 89 D9 4A 8D 3C 9D 00 00 00 00 49 29 C1 4B 8D 34 DB 4C 89 C8 45 89 C9 48 C1 E8 20 48 01 C1 4C 89 D8 48 C1 E0 20 48 29 F8 4C 29 D8 48 01 C1 48 89 D8 48 C1 E8 20 4C 8D 1C 30 48 89 C8 48 C1 E1 20 48 C1 E8 20 49 01 C9 4C 01 D8 48 39 C2 77 16 4D 39 CA 0F 82 D6 01 00 00 48 39 C2 0F 85 CD 01 00 00 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 3C FF FF FF 48 B8 00 00 00 00 00 00 00 60 49 89 C8 49 21 C0 49 39 C0 0F 84 45 01 00 00 48 85 D2 0F 84 CE 00 00 00 66 0F EF C0 4C 8B 0D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 49 89 C0 49 C1 E0 05 4D 01 C8 45 8B 18 45 85 DB 75 1A 45 8B 58 18 4D 8B 40 08 4C 39 C2 0F 87 14 01 00 00 4C 39 C2 0F 84 F4 00 00 00 4C 8D 04 09 49 C1 E8 32 41 81 E8 20 18 00 00 47 8D 0C 03 41 83 F9 0A 0F 8F 5E FF FF FF 48 B8 00 00 00 00 00 00 00 80 48 21 C1 41 83 F9 0A 0F 84 27 01 00 00 31 C0 45 85 C9 0F 88 8C FE FF FF 0F 85 F6 00 00 00 45 8D 43 FF 41 83 F8 12 0F 8F 49 01 00 00 48 85 D2 75 14 48 8B 15 ?? ?? ?? ?? 4D 63 C0 4E 3B 14 C2 0F 86 5F FE FF FF 48 85 C9 B8 01 00 00 00 0F 84 51 FE FF FF E9 FC FE FF FF 31 C0 4D 85 D2 0F 84 41 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C2 0F 86 7E 00 00 00 66 0F EF D2 4C 89 D0 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 83 E8 01 4C 8B 0D ?? ?? ?? ?? 49 89 C0 49 C1 E0 05 4D 01 C8 45 8B 18 45 85 DB 0F 85 20 FF FF FF 45 8B 58 18 4D 8B 40 08 E9 0A FF FF FF 31 C0 E9 D7 FD FF FF 48 C1 E0 05 4D 39 54 01 10 0F 87 FD FE FF FF 0F 1F 84 00 00 00 00 00 41 83 C3 01 E9 EC FE FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A CA 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 EB 87 66 90 48 85 C9 0F 85 37 FE FF FF 45 85 C0 0F 88 31 01 00 00 75 7D 44 89 D0 E9 74 FD FF FF 0F 1F 40 00 48 85 C9 0F 85 17 FE FF FF 41 83 FB 0B 0F 8F 6E FD FF FF B8 0B 00 00 00 48 8B 0D ?? ?? ?? ?? 4C 89 D3 44 29 D8 48 98 48 0F AF 1C C1 48 B8 FA FF FF FF 09 00 00 00 48 39 C3 0F 87 E1 FD FF FF EB A8 45 8D 43 EC 4D 63 C0 49 C1 E0 04 4C 03 05 ?? ?? ?? ?? 49 3B 50 08 0F 82 13 FD FF FF 0F 85 AE FE FF FF 4D 3B 10 0F 86 04 FD FF FF E9 A0 FE FF FF 48 8B 05 ?? ?? ?? ?? 4D 63 C0 42 8B 3C C0 41 0F AF FA 89 F8 E9 E6 FC FF FF 41 8D 43 E1 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 89 C6 48 8B 00 48 8B 76 08 49 89 C3 89 C0 48 8D 0C 85 00 00 00 00 49 89 C1 48 8D 1C C0 49 C1 E1 20 49 C1 EB 20 48 8D 34 B6 49 29 C9 89 D9 4A 8D 3C 9D 00 00 00 00 49 29 C1 4C 89 C8 45 89 C9 48 C1 E8 20 48 01 C8 4C 89 D9 48 C1 E1 20 48 29 F9 4C 29 D9 48 01 C1 48 89 C8 48 C1 E9 20 48 C1 E0 20 49 01 C1 4B 8D 04 DB 49 89 F3 49 C1 E3 21 49 29 F3 49 01 C3 48 89 D8 48 C1 E8 20 4C 01 D8 48 01 C8 E9 E2 FC FF FF 45 89 C6 41 F7 DE 41 83 FE 13 0F 8F 3E 02 00 00 48 8B 05 ?? ?? ?? ?? 41 F7 D0 4D 89 D1 4D 63 C0 4E 03 0C C0 4D 39 D1 4D 89 C4 4C 89 CF 48 83 D2 00 49 C1 E4 04 4C 03 25 ?? ?? ?? ?? 45 89 C9 48 C1 EF 20 4C 89 CE 48 89 F8 48 89 FB 4D 89 CF 49 8B 4C 24 08 49 89 CA 89 C9 48 0F AF F1 49 C1 EA 20 48 0F AF C1 49 0F AF DA 49 89 F3 89 F6 89 C5 49 C1 EB 20 48 C1 E8 20 49 01 EB 4C 89 CD 48 01 D8 49 0F AF EA 4C 01 DD 48 89 EB 48 C1 E5 20 48 C1 EB 20 48 01 EE 48 01 C3 49 8B 04 24 49 89 FC 49 89 C3 89 C0 4C 0F AF F8 49 C1 EB 20 4C 0F AF E0 4D 0F AF CB 4D 89 FD 4C 89 7C 24 08 49 C1 ED 20 45 89 E7 49 C1 EC 20 49 0F AF FB 4D 01 FD 4D 01 E9 4D 89 CF 49 C1 EF 20 49 01 FC 4D 01 E7 49 01 F7 48 89 D6 89 D2 48 83 D3 00 48 C1 EE 20 48 89 F7 48 89 F5 48 0F AF F9 48 0F AF CA 49 0F AF EA 41 89 FD 48 C1 EF 20 49 89 CC 89 C9 4C 0F AF D2 49 C1 EC 20 48 01 EF 4D 01 EC 4D 01 E2 4C 89 D5 48 C1 ED 20 48 01 EF 48 89 F5 48 0F AF E8 48 0F AF C2 49 0F AF D3 41 89 ED 48 C1 ED 20 49 89 C4 49 C1 EC 20 49 0F AF F3 4D 01 EC 4C 01 E2 49 89 D3 48 C1 E2 20 49 89 D4 89 C2 4C 89 D0 48 01 EE 49 C1 EB 20 48 C1 E0 20 48 01 C8 4C 01 DE 4C 01 E2 48 01 F0 48 83 D7 00 49 01 D7 0F 92 C2 0F B6 D2 48 01 D0 48 01 C3 0F 92 C1 48 39 C2 0F 97 C0 09 C8 0F B6 C0 48 01 F8 41 83 FE 16 0F 8F 87 00 00 00 48 8B 15 ?? ?? ?? ?? 48 89 DF 46 8B 14 82 BA 40 00 00 00 89 D1 48 8B 15 ?? ?? ?? ?? 44 29 D1 48 D3 E0 44 89 D1 4A 23 1C C2 48 D3 EF 31 D2 48 09 F8 48 09 D3 0F 85 70 FA FF FF 8B 54 24 08 49 C1 E1 20 4C 89 FB 4C 01 CA 48 09 D3 0F 84 59 FA FF FF 4C 89 C1 48 C1 E1 04 48 03 0D ?? ?? ?? ?? 4C 3B 79 08 72 0F 0F 85 3F FA FF FF 48 3B 11 0F 87 36 FA FF FF 48 89 C2 83 E2 01 48 83 FA 01 48 83 D0 FF E9 23 FA FF FF 48 8B 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 89 C7 42 8B 0C 81 4A 23 3C C2 83 E9 40 48 89 FA 48 D3 E8 EB 86 B8 EC FF FF FF 4D 89 D1 44 29 C0 41 F7 D0 48 98 4D 63 C0 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 4C 03 08 48 03 50 08 E9 AC FD FF FF 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_176_1_0 {
	meta:
		name = "__bid128_to_uint32_xrnint"
		size = 2048
		refs = "0092 .refptr.__bid_ten2k64 0123 .refptr.__bid_IDEC_glbflags 015d .refptr.__bid_nr_digits 02d1 .refptr.__bid_midpoint64 0318 .refptr.__bid_midpoint128 039a .refptr.__bid_ten2k128 045a .refptr.__bid_ten2mk128 05c2 .refptr.__bid_maskhigh128 05e5 .refptr.__bid_shiftright128 0624 .refptr.__bid_ten2mk128trunc 067b .refptr.__bid_onehalf128"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 57 56 53 48 83 EC 18 4C 8B 01 48 8B 49 08 48 B8 00 00 00 00 00 00 00 78 48 89 CA 48 21 C2 48 39 C2 0F 84 F0 00 00 00 48 BA FF FF FF FF FF FF 01 00 49 B9 C0 87 AD BE 09 ED 01 00 31 C0 48 21 CA 4C 39 CA 77 22 0F 85 E0 00 00 00 49 B9 FF FF FF FF 63 8E 8D 37 4D 39 C8 0F 86 CD 00 00 00 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 5B 5E 5F 5D 41 5C 41 5D 41 5E 41 5F C3 41 83 FA 1E 0F 8F FE 02 00 00 41 8D 4A F5 4C 8B 0D ?? ?? ?? ?? 48 63 C9 49 8B 0C C9 49 89 CB 89 C9 4C 8D 0C 8D 00 00 00 00 49 89 CA 48 8D 1C C9 49 C1 E2 20 49 C1 EB 20 4D 29 CA 41 89 D9 4A 8D 3C 9D 00 00 00 00 49 29 CA 4B 8D 34 DB 48 C1 EB 20 4C 89 D1 45 89 D2 48 C1 E9 20 49 01 C9 4C 89 D9 48 C1 E1 20 48 29 F9 4C 29 D9 4C 8D 1C 33 49 01 C9 4C 89 C9 49 C1 E1 20 48 C1 E9 20 4D 01 D1 4C 01 D9 48 39 CA 77 17 4D 39 C8 0F 82 DD 00 00 00 48 39 CA 0F 85 D4 00 00 00 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 83 08 01 B8 00 00 00 80 E9 3C FF FF FF 48 B8 00 00 00 00 00 00 00 60 49 89 C9 49 21 C1 49 39 C1 0F 84 26 01 00 00 48 85 D2 0F 84 AF 00 00 00 66 0F EF C0 4C 8B 1D ?? ?? ?? ?? F2 48 0F 2A C2 66 48 0F 7E C0 48 C1 E8 34 25 FF 07 00 00 2D BF 03 00 00 49 89 C1 49 C1 E1 05 4D 01 D9 45 8B 11 45 85 D2 75 1A 45 8B 51 18 4D 8B 49 08 4C 39 CA 0F 87 F4 00 00 00 4C 39 CA 0F 84 D5 00 00 00 48 8D 04 09 48 C1 E8 32 2D 20 18 00 00 45 8D 0C 02 41 83 F9 0A 0F 8F 60 FF FF FF 49 BB 00 00 00 00 00 00 00 80 4C 21 D9 41 83 F9 0A 0F 84 59 01 00 00 45 85 C9 0F 88 1A 01 00 00 0F 84 DA 00 00 00 48 85 C9 0F 85 31 FF FF FF 85 C0 0F 88 2A 02 00 00 0F 85 75 01 00 00 44 89 C0 E9 6B FE FF FF 31 C0 4D 85 C0 0F 84 60 FE FF FF 48 B8 FF FF FF FF FF FF 1F 00 49 39 C0 0F 86 7D 00 00 00 66 0F EF D2 4C 89 C0 48 C1 E8 20 F2 48 0F 2A D0 66 48 0F 7E D0 48 C1 E8 34 25 FF 07 00 00 2D DE 03 00 00 83 E8 01 4C 8B 1D ?? ?? ?? ?? 49 89 C1 49 C1 E1 05 4D 01 D9 45 8B 11 45 85 D2 0F 85 3F FF FF FF 45 8B 51 18 4D 8B 49 08 E9 29 FF FF FF 31 C0 E9 F6 FD FF FF 48 C1 E0 05 4D 39 44 03 10 0F 87 1C FF FF FF 0F 1F 80 00 00 00 00 41 83 C2 01 E9 0C FF FF FF 0F 1F 80 00 00 00 00 66 0F EF C9 F2 49 0F 2A C8 66 48 0F 7E C8 48 C1 E8 34 25 FF 07 00 00 2D FE 03 00 00 EB 88 66 90 41 8D 42 FF 83 F8 12 7F 42 48 85 D2 75 0F 48 8B 15 ?? ?? ?? ?? 48 98 4C 39 04 C2 73 4C 48 85 C9 B8 01 00 00 00 0F 85 35 FE FF FF 48 8B 15 ?? ?? ?? ?? 83 0A 20 E9 76 FD FF FF 48 8B 05 ?? ?? ?? ?? 83 08 20 31 C0 E9 65 FD FF FF 41 8D 42 EC 48 98 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 3B 50 08 72 07 75 B9 4C 39 00 72 B4 31 C0 EB BE 0F 1F 00 48 85 C9 0F 85 E7 FD FF FF 41 83 FA 0B 0F 8F 3E FD FF FF B1 0B 4C 8B 0D ?? ?? ?? ?? 4C 89 C7 44 29 D1 48 63 C9 49 0F AF 3C C9 48 B9 FA FF FF FF 09 00 00 00 48 39 CF 0F 87 B3 FD FF FF E9 7D FE FF FF 48 8B 15 ?? ?? ?? ?? 48 98 8B 3C C2 41 0F AF F8 89 F8 E9 E7 FC FF FF 41 8D 4A E1 48 63 C9 48 C1 E1 04 48 89 CB 48 03 1D ?? ?? ?? ?? 48 8B 0B 48 8B 5B 08 48 89 CE 89 C9 48 8D 1C 9B 4C 8D 1C 8D 00 00 00 00 49 89 C9 4C 8D 14 C9 49 C1 E1 20 48 C1 EE 20 4D 29 D9 45 89 D3 48 8D 3C B5 00 00 00 00 49 29 C9 49 C1 EA 20 4C 89 C9 45 89 C9 48 C1 E9 20 4C 01 D9 49 89 F3 49 C1 E3 20 49 29 FB 49 29 F3 48 8D 34 F6 4C 01 D9 49 89 CB 48 C1 E9 20 49 C1 E3 20 4D 01 D9 49 89 DB 49 C1 E3 21 49 29 DB 49 01 F3 4D 01 DA 4C 01 D1 E9 E3 FC FF FF 89 C7 F7 DF 83 FF 13 0F 8F B0 02 00 00 48 8B 0D ?? ?? ?? ?? F7 D0 4D 89 C1 48 98 4C 03 0C C1 4D 39 C1 48 89 C3 4D 89 CD 48 83 D2 00 48 C1 E3 04 45 89 C9 48 89 DE 48 03 35 ?? ?? ?? ?? 49 C1 ED 20 4C 89 CD 4C 89 E9 48 89 5C 24 08 4D 89 EA 4D 89 CF 4C 8B 46 08 4D 89 C3 45 89 C0 49 0F AF E8 49 C1 EB 20 49 0F AF C8 4D 0F AF D3 48 89 EB 89 ED 41 89 CC 48 C1 EB 20 48 C1 E9 20 4C 01 E3 4D 89 CC 4C 01 D1 4D 0F AF E3 49 01 DC 4D 89 E2 49 C1 E4 20 49 C1 EA 20 49 01 EC 48 89 D5 49 01 CA 48 8B 0E 4C 89 EE 89 D2 48 89 CB 89 C9 48 C1 EB 20 4C 0F AF EB 4C 0F AF F9 48 0F AF F1 4C 89 2C 24 4D 89 FD 4C 0F AF CB 4D 89 EE 41 89 F7 49 C1 EE 20 48 C1 EE 20 48 03 34 24 4D 01 FE 45 89 ED 4D 01 F1 4D 89 CF 49 C1 E1 20 49 C1 EF 20 49 01 F7 4B 8D 34 29 4D 01 FC 49 83 D2 00 48 C1 ED 20 49 89 ED 49 89 EE 4D 0F AF E8 4C 0F AF C2 4D 0F AF F3 45 89 EF 49 C1 ED 20 4D 89 C1 45 89 C0 4C 0F AF DA 49 C1 E9 20 4D 01 F5 4D 01 F9 4D 01 D9 4D 89 CB 49 C1 EB 20 4D 01 EB 49 89 ED 4C 0F AF E9 48 0F AF CA 48 0F AF D3 45