private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_0_2_0 {
	meta:
		name = "??$assemble_floating_point_infinity@M@__crt_strtox@@YAX_NAEAM@Z"
		size = 18
	strings:
		$1 = { 33 C0 84 C9 0F 95 C0 C1 E0 1F 0D 00 00 80 7F 89 02 C3 }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAEAN@Z"
		size = 28
	strings:
		$1 = { 33 C0 84 C9 48 B9 00 00 00 00 00 00 F0 7F 0F 95 C0 48 C1 E0 3F 48 0B C1 48 89 02 C3 }
	condition:
		$1
}

rule file_0_4_0 {
	meta:
		name = "??$assemble_floating_point_qnan@M@__crt_strtox@@YAX_NAEAM@Z"
		size = 18
	strings:
		$1 = { 33 C0 84 C9 0F 95 C0 C1 E0 1F 0D FF FF FF 7F 89 02 C3 }
	condition:
		$1
}

rule file_0_5_0 {
	meta:
		name = "??$assemble_floating_point_qnan@N@__crt_strtox@@YAX_NAEAN@Z"
		size = 28
	strings:
		$1 = { 33 C0 84 C9 48 B9 FF FF FF FF FF FF FF 7F 0F 95 C0 48 C1 E0 3F 48 0B C1 48 89 02 C3 }
	condition:
		$1
}

rule file_0_6_0 {
	meta:
		name = "??$assemble_floating_point_snan@M@__crt_strtox@@YAX_NAEAM@Z"
		size = 18
	strings:
		$1 = { 33 C0 84 C9 0F 95 C0 C1 E0 1F 0D 01 00 80 7F 89 02 C3 }
	condition:
		$1
}

rule file_0_7_0 {
	meta:
		name = "??$assemble_floating_point_snan@N@__crt_strtox@@YAX_NAEAN@Z"
		size = 28
	strings:
		$1 = { 33 C0 84 C9 48 B9 01 00 00 00 00 00 F0 7F 0F 95 C0 48 C1 E0 3F 48 0B C1 48 89 02 C3 }
	condition:
		$1
}

rule file_0_8_0 {
	meta:
		name = "??$assemble_floating_point_value_t@M@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAEAM@Z"
		size = 36
	strings:
		$1 = { 83 C2 7F 0F B6 C1 C1 E2 17 41 81 E0 FF FF 7F 00 81 E2 00 00 80 7F C1 E0 1F 0B D0 33 C0 41 0B D0 41 89 11 C3 }
	condition:
		$1
}

rule file_0_9_0 {
	meta:
		name = "??$assemble_floating_point_value_t@N@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAEAN@Z"
		size = 50
	strings:
		$1 = { 44 8D 92 FF 03 00 00 0F B6 C1 41 81 E2 FF 07 00 00 48 C1 E0 0B 4C 0B D0 48 B8 FF FF FF FF FF FF 0F 00 4C 23 C0 49 C1 E2 34 4D 0B D0 33 C0 4D 89 11 C3 }
	condition:
		$1
}

rule file_0_12_0 {
	meta:
		name = "??$common_atodbl_l@MD@@YAHQEAMQEBDQEAU__crt_locale_pointers@@@Z"
		size = 143
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 0033 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0043 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0053 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAM@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 50 48 8B FA 48 8B D9 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8D 43 01 EB 5A 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 45 33 C0 48 8D 4C 24 20 48 8B D7 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 38 4C 8B C3 E8 ?? ?? ?? ?? 83 E8 02 74 10 83 F8 01 74 04 33 C0 EB 0C B8 03 00 00 00 EB 05 B8 04 00 00 00 80 7C 24 48 00 74 0C 48 8B 4C 24 30 83 A1 A8 03 00 00 FD 48 8B 5C 24 60 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_0_13_0 {
	meta:
		name = "??$common_atodbl_l@ND@@YAHQEANQEBDQEAU__crt_locale_pointers@@@Z"
		size = 143
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 0033 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0043 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0053 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAN@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 50 48 8B FA 48 8B D9 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8D 43 01 EB 5A 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 45 33 C0 48 8D 4C 24 20 48 8B D7 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 38 4C 8B C3 E8 ?? ?? ?? ?? 83 E8 02 74 10 83 F8 01 74 04 33 C0 EB 0C B8 03 00 00 00 EB 05 B8 04 00 00 00 80 7C 24 48 00 74 0C 48 8B 4C 24 30 83 A1 A8 03 00 00 FD 48 8B 5C 24 60 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_0_14_0 {
	meta:
		name = "??$common_atof_l@D@@YANQEBDQEAU__crt_locale_pointers@@@Z"
		size = 119
		refs = "000f _errno 001a _invalid_parameter_noinfo 0029 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0042 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0054 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAN@Z"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B D9 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 0F 57 C0 EB 4E 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F 57 C0 48 8D 4C 24 20 45 33 C0 F2 0F 11 44 24 60 48 8B D3 E8 ?? ?? ?? ?? 48 8B D0 4C 8D 44 24 60 48 8D 4C 24 38 E8 ?? ?? ?? ?? 80 7C 24 48 00 F2 0F 10 44 24 60 74 0C 48 8B 44 24 30 83 A0 A8 03 00 00 FD 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_0_15_0 {
	meta:
		name = "??$common_atof_l@_W@@YANQEB_WQEAU__crt_locale_pointers@@@Z"
		size = 119
		refs = "000f _errno 001a _invalid_parameter_noinfo 0029 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0042 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0054 ??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAN@Z"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B D9 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 0F 57 C0 EB 4E 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F 57 C0 48 8D 4C 24 20 45 33 C0 F2 0F 11 44 24 60 48 8B D3 E8 ?? ?? ?? ?? 48 8B D0 4C 8D 44 24 60 48 8D 4C 24 38 E8 ?? ?? ?? ?? 80 7C 24 48 00 F2 0F 10 44 24 60 74 0C 48 8B 44 24 30 83 A0 A8 03 00 00 FD 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_0_16_0 {
	meta:
		name = "??$convert_decimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAM@Z"
		size = 29
		refs = "0014 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { 48 83 EC 38 48 89 54 24 20 48 8D 54 24 20 C6 44 24 28 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_18_0 {
	meta:
		name = "??$convert_hexadecimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAM@Z"
		size = 29
		refs = "0014 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { 48 83 EC 38 48 89 54 24 20 48 8D 54 24 20 C6 44 24 28 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_17_0 {
	meta:
		name = "??$convert_decimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAN@Z"
		size = 29
		refs = "0014 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { 48 83 EC 38 48 89 54 24 20 48 8D 54 24 20 C6 44 24 28 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_19_0 {
	meta:
		name = "??$convert_hexadecimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAN@Z"
		size = 29
		refs = "0014 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { 48 83 EC 38 48 89 54 24 20 48 8D 54 24 20 C6 44 24 28 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_20_0 {
	meta:
		name = "??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z"
		size = 19
		altNames = "??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z ??0?$c_string_character_source@D@__crt_strtox@@QEAA@QEBDQEAPEBD@Z ??0?$c_string_character_source@_W@__crt_strtox@@QEAA@QEB_WQEAPEB_W@Z"
	strings:
		$1 = { 48 89 11 4C 89 41 08 4D 85 C0 74 03 49 89 10 48 8B C1 C3 }
	condition:
		$1
}

rule file_0_22_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAM@Z"
		size = 158
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005b ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 006a ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0089 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 26 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 08 48 85 C9 74 06 48 8B 03 48 89 01 B8 01 00 00 00 EB 2D 48 85 C9 74 D5 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 53 08 48 85 D2 74 06 48 8B 0B 48 89 0A 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_0_23_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAN@Z"
		size = 158
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005b ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 006a ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0089 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 26 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 08 48 85 C9 74 06 48 8B 03 48 89 01 B8 01 00 00 00 EB 2D 48 85 C9 74 D5 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 53 08 48 85 D2 74 06 48 8B 0B 48 89 0A 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_345_5_4 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAU_LDBL12@@@Z"
		size = 158
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005b ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 006a ??$parse_floating_point_write_result@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAU_LDBL12@@@Z 0089 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 26 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 08 48 85 C9 74 06 48 8B 03 48 89 01 B8 01 00 00 00 EB 2D 48 85 C9 74 D5 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 53 08 48 85 D2 74 06 48 8B 0B 48 89 0A 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_40_24_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAM@Z"
		size = 158
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005b ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@_W@0@AEAUfloating_point_string@0@@Z 006a ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0089 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 26 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 08 48 85 C9 74 06 48 8B 03 48 89 01 B8 01 00 00 00 EB 2D 48 85 C9 74 D5 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 53 08 48 85 D2 74 06 48 8B 0B 48 89 0A 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_40_25_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAN@Z"
		size = 158
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005b ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@_W@0@AEAUfloating_point_string@0@@Z 006a ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0089 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 26 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 08 48 85 C9 74 06 48 8B 03 48 89 01 B8 01 00 00 00 EB 2D 48 85 C9 74 D5 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 53 08 48 85 D2 74 06 48 8B 0B 48 89 0A 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_0_25_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z"
		size = 1220
		refs = "002d _errno 0039 _invalid_parameter_noinfo 006f _isctype_l 0082 __pctype_func 0499 ??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z 04ab ??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z"
	strings:
		$1 = { 48 89 5C 24 08 4C 89 44 24 18 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 20 4C 8B 32 33 F6 4D 8B E0 48 8B FA 4C 8B F9 4D 85 F6 75 19 E8 ?? ?? ?? ?? 45 8D 6E 16 44 89 28 E8 ?? ?? ?? ?? 8D 46 07 E9 6A 04 00 00 41 8A 1E 49 8D 46 01 48 89 02 88 5C 24 68 0F B6 EB 4D 85 FF 74 26 49 8B 07 83 78 08 01 7E 11 4D 8B C7 BA 08 00 00 00 8B CD E8 ?? ?? ?? ?? EB 18 48 8B 00 48 63 CD 0F B7 04 48 EB 09 E8 ?? ?? ?? ?? 0F B7 04 68 83 E0 08 85 C0 74 0D 48 8B 07 8A 18 48 FF C0 48 89 07 EB B1 49 81 C4 08 03 00 00 80 FB 2D 0F 94 C0 41 88 04 24 8D 43 D5 A8 FD 75 0F 48 8B 07 8A 18 48 FF C0 48 89 07 88 5C 24 68 8D 43 B7 41 B2 DF 41 84 C2 0F 84 CB 03 00 00 8D 43 B2 41 84 C2 0F 84 AD 03 00 00 40 88 74 24 68 44 8A CE 41 BD 16 00 00 00 80 FB 30 75 49 4C 8B 07 41 8A 10 49 8D 48 01 48 89 0F 8D 42 A8 41 84 C2 74 20 48 FF C9 48 89 0F 84 D2 74 2A 38 11 74 26 E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 44 8A CE EB 14 8A 19 48 8D 41 01 41 B1 01 48 89 07 44 88 4C 24 68 4D 8B F0 4C 8B 54 24 70 44 8B DE 49 83 C2 08 40 8A D6 49 8B EA 80 FB 30 75 12 48 8B 07 B2 01 8A 18 48 FF C0 48 89 07 80 FB 30 74 F3 41 8A C1 F6 D8 45 1B C0 41 83 E0 06 41 83 C0 09 8D 43 D0 3C 09 77 08 0F BE C3 83 E8 30 EB 21 8D 43 9F 3C 19 77 08 0F BE C3 83 E8 57 EB 12 8D 43 BF 3C 19 77 08 0F BE C3 83 E8 37 EB 03 83 C8 FF 41 3B C0 77 1D B2 01 49 3B EC 74 06 88 45 00 48 FF C5 48 8B 07 41 FF C3 8A 18 48 FF C0 48 89 07 EB AE 49 8B 07 44 89 5C 24 78 48 8B 88 F8 00 00 00 48 8B 01 3A 18 75 7B 48 8B 07 8A 18 48 FF C0 48 89 07 49 3B EA 75 1C 80 FB 30 75 17 B2 01 8A 18 41 FF CB 48 FF C0 48 89 07 80 FB 30 74 F0 44 89 5C 24 78 8D 43 D0 3C 09 77 08 0F BE C3 83 E8 30 EB 21 8D 43 9F 3C 19 77 08 0F BE C3 83 E8 57 EB 12 8D 43 BF 3C 19 77 08 0F BE C3 83 E8 37 EB 03 83 C8 FF 41 3B C0 77 1A B2 01 49 3B EC 74 06 88 45 00 48 FF C5 48 8B 07 8A 18 48 FF C0 48 89 07 EB B1 48 FF 0F 48 8B 07 84 D2 75 2D 84 DB 74 16 38 18 74 12 E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 44 8A 4C 24 68 41 F6 D9 4C 89 37 1B C0 83 E0 FB 83 C0 07 E9 20 02 00 00 84 DB 74 16 38 18 74 12 E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 44 8A 4C 24 68 4C 8B 37 40 8A C6 41 8A 0E 4D 8D 7E 01 4C 89 3F 80 F9 45 74 14 80 F9 50 74 0A 80 F9 65 74 0A 80 F9 70 75 0B 41 8A C1 EB 06 45 84 C9 0F 94 C0 8B DE 41 BC 50 14 00 00 84 C0 0F 84 0D 01 00 00 41 8A 0F 49 8D 57 01 80 F9 2D 48 89 17 41 0F 94 C1 8D 41 D5 A8 FD 75 09 8A 0A 48 8D 42 01 48 89 07 41 BA 30 00 00 00 44 8A C6 41 3A CA 75 13 48 8B 07 41 B0 01 8A 08 48 FF C0 48 89 07 41 3A CA 74 F3 8A C1 41 2A C2 3C 09 77 08 0F BE D1 41 2B D2 EB 21 8D 41 9F 3C 19 77 08 0F BE D1 83 EA 57 EB 12 8D 41 BF 3C 19 77 08 0F BE D1 83 EA 37 EB 03 83 CA FF 83 FA 0A 73 20 8D 04 9B 41 B0 01 8D 1C 42 41 3B DC 7F 0D 48 8B 07 8A 08 48 FF C0 48 89 07 EB AE BB 51 14 00 00 8A C1 41 2A C2 3C 09 77 08 0F BE C1 41 2B C2 EB 21 8D 41 9F 3C 19 77 08 0F BE C1 83 E8 57 EB 12 8D 41 BF 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 0D 48 8B 07 8A 08 48 FF C0 48 89 07 EB BC 45 84 C9 74 02 F7 DB 45 84 C0 75 24 48 FF 0F 48 8B 07 84 C9 74 11 38 08 74 0D E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 4C 89 37 41 8A 0E 4C 89 3F 48 FF 0F 48 8B 07 84 C9 74 11 38 08 74 0D E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 4C 8B 4C 24 70 4D 8D 41 08 49 3B E8 74 68 48 8D 45 FF 40 38 30 75 08 48 8B E8 49 3B C0 75 EF 49 3B E8 74 52 41 3B DC 7E 07 B8 09 00 00 00 EB 6F 41 BA B0 EB FF FF 41 3B DA 7D 07 B8 08 00 00 00 EB 5D 8A 54 24 68 8A C2 F6 D8 1B C9 83 E1 03 FF C1 0F AF 4C 24 78 03 D9 41 3B DC 7F CC 41 3B DA 7C D9 41 2B E8 41 89 19 84 D2 41 89 69 04 40 0F 95 C6 8B C6 EB 29 B8 02 00 00 00 EB 22 4D 8B C6 48 8D 4C 24 68 48 8B D7 E8 ?? ?? ?? ?? EB 10 4D 8B C6 48 8D 4C 24 68 48 8B D7 E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_0_26_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@_W@0@AEAUfloating_point_string@0@@Z"
		size = 3726
		refs = "0033 _errno 003f _invalid_parameter_noinfo 007a iswctype 0e61 ??$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$c_string_character_source@_W@0@PEB_W@Z 0e76 ??$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$c_string_character_source@_W@0@PEB_W@Z"
	strings:
		$1 = { 48 8B C4 4C 89 40 18 48 89 48 08 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC B8 00 00 00 4C 8B 32 33 ED 4C 89 70 A0 4D 8B E0 48 8B F2 4D 85 F6 75 19 E8 ?? ?? ?? ?? 45 8D 6E 16 44 89 28 E8 ?? ?? ?? ?? 8D 45 07 E9 2F 0E 00 00 41 0F B7 1E 49 8D 46 02 48 89 02 41 BF 08 00 00 00 EB 0D 48 8B 06 0F B7 18 48 83 C0 02 48 89 06 41 8B D7 66 89 9C 24 08 01 00 00 0F B7 CB E8 ?? ?? ?? ?? 85 C0 75 DC 66 83 FB 2D 4D 8D BC 24 08 03 00 00 B9 FD FF 00 00 0F 94 C0 41 88 07 8D 43 D5 66 85 C1 75 15 48 8B 06 0F B7 18 48 83 C0 02 48 89 06 66 89 9C 24 08 01 00 00 8D 43 B7 41 BA DF FF 00 00 66 41 85 C2 0F 84 9E 0D 00 00 8D 43 B2 66 41 85 C2 0F 84 7C 0D 00 00 B9 30 00 00 00 40 88 AC 24 08 01 00 00 44 8A CD 44 8D 69 E6 66 3B D9 75 5C 4C 8B 06 41 0F B7 10 49 8D 48 02 48 89 0E 8D 42 A8 66 41 85 C2 74 23 48 83 C1 FE 48 89 0E 66 85 D2 74 34 66 39 11 74 2F E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 44 8A CD EB 1D 0F B7 19 48 8D 41 02 41 B1 01 48 89 06 44 88 8C 24 08 01 00 00 4C 89 84 24 98 00 00 00 B9 30 00 00 00 4D 8D 54 24 08 44 8B DD 4C 89 94 24 A0 00 00 00 4D 8B E2 4C 89 94 24 88 00 00 00 40 8A D5 66 3B D9 75 14 B2 01 48 8B 06 0F B7 18 48 83 C0 02 48 89 06 66 3B D9 74 EE 41 8A C1 C7 84 24 18 01 00 00 6A 06 00 00 F6 D8 C7 44 24 28 FA 06 00 00 41 B9 10 FF 00 00 C7 44 24 24 70 09 00 00 45 1B C0 C7 84 24 90 00 00 00 F0 09 00 00 41 83 E0 06 C7 84 24 88 00 00 00 70 0A 00 00 41 83 C0 09 C7 44 24 38 F0 0A 00 00 41 BD 60 06 00 00 C7 44 24 2C 66 0B 00 00 BD F0 06 00 00 C7 44 24 3C 70 0B 00 00 BF 66 09 00 00 C7 44 24 30 66 0C 00 00 41 BA E6 09 00 00 C7 44 24 40 70 0C 00 00 41 BE 66 0A 00 00 C7 44 24 34 E6 0C 00 00 C7 44 24 44 F0 0C 00 00 C7 44 24 48 66 0D 00 00 C7 44 24 4C 70 0D 00 00 C7 44 24 50 50 0E 00 00 C7 44 24 54 5A 0E 00 00 C7 44 24 58 D0 0E 00 00 C7 44 24 5C DA 0E 00 00 C7 44 24 60 20 0F 00 00 C7 44 24 64 2A 0F 00 00 C7 44 24 68 40 10 00 00 C7 44 24 6C 4A 10 00 00 C7 44 24 70 E0 17 00 00 C7 44 24 74 EA 17 00 00 C7 44 24 78 10 18 00 00 C7 44 24 7C 1A 18 00 00 C7 84 24 80 00 00 00 1A FF 00 00 B8 E6 0A 00 00 66 3B D9 0F 82 F9 01 00 00 66 83 FB 3A 73 0A 0F B7 C3 2B C1 E9 E4 01 00 00 66 41 3B D9 0F 83 C5 01 00 00 66 41 3B DD 0F 82 D5 01 00 00 66 3B 9C 24 18 01 00 00 73 0B 0F B7 C3 41 2B C5 E9 BB 01 00 00 66 3B DD 0F 82 B7 01 00 00 66 3B 5C 24 28 73 0A 0F B7 C3 2B C5 E9 A1 01 00 00 66 3B DF 0F 82 9D 01 00 00 66 3B 5C 24 24 73 0A 0F B7 C3 2B C7 E9 87 01 00 00 66 41 3B DA 0F 82 82 01 00 00 66 3B 9C 24 90 00 00 00 73 0B 0F B7 C3 41 2B C2 E9 68 01 00 00 66 41 3B DE 0F 82 63 01 00 00 66 3B 9C 24 88 00 00 00 73 0B 0F B7 C3 41 2B C6 E9 49 01 00 00 66 3B D8 0F 82 45 01 00 00 66 3B 5C 24 38 73 0D 0F B7 C3 2D E6 0A 00 00 E9 2C 01 00 00 66 3B 5C 24 2C 0F 82 26 01 00 00 66 3B 5C 24 3C 73 0D 0F B7 C3 2D 66 0B 00 00 E9 0D 01 00 00 66 3B 5C 24 30 0F 82 07 01 00 00 66 3B 5C 24 40 73 0D 0F B7 C3 2D 66 0C 00 00 E9 EE 00 00 00 66 3B 5C 24 34 0F 82 E8 00 00 00 66 3B 5C 24 44 73 0D 0F B7 C3 2D E6 0C 00 00 E9 CF 00 00 00 66 3B 5C 24 48 0F 82 C9 00 00 00 66 3B 5C 24 4C 73 0D 0F B7 C3 2D 66 0D 00 00 E9 B0 00 00 00 66 3B 5C 24 50 0F 82 AA 00 00 00 66 3B 5C 24 54 73 0D 0F B7 C3 2D 50 0E 00 00 E9 91 00 00 00 66 3B 5C 24 58 0F 82 8B 00 00 00 66 3B 5C 24 5C 73 0A 0F B7 C3 2D D0 0E 00 00 EB 75 66 3B 5C 24 60 72 73 66 3B 5C 24 64 73 0A 0F B7 C3 2D 20 0F 00 00 EB 5D 66 3B 5C 24 68 72 5B 66 3B 5C 24 6C 73 0A 0F B7 C3 2D 40 10 00 00 EB 45 66 3B 5C 24 70 72 43 66 3B 5C 24 74 73 0A 0F B7 C3 2D E0 17 00 00 EB 2D 66 3B 5C 24 78 72 2B 66 3B 5C 24 7C 73 24 0F B7 C3 2D 10 18 00 00 EB 15 66 3B 9C 24 80 00 00 00 73 08 0F B7 C3 41 2B C1 EB 03 83 C8 FF 83 F8 FF 75 29 8D 43 BF 66 83 F8 19 76 0E 8D 43 9F 66 83 F8 19 76 05 83 C8 FF EB 12 8D 43 9F 66 83 F8 19 0F B7 C3 77 03 83 E8 20 83 C0 C9 41 3B C0 77 23 B2 01 4D 3B E7 74 07 41 88 04 24 49 FF C4 48 8B 06 41 FF C3 0F B7 18 48 83 C0 02 48 89 06 E9 A8 FD FF FF 48 8B BC 24 00 01 00 00 BD 00 00 00 00 4C 8B B4 24 98 00 00 00 44 8A 8C 24 08 01 00 00 4C 8B 94 24 A0 00 00 00 48 8B 07 44 8D 6D 16 44 89 5C 24 28 4C 89 A4 24 88 00 00 00 48 8B 88 F8 00 00 00 48 8B 01 0F BE 08 0F B7 C3 3B C1 0F 85 CC 02 00 00 48 8B 06 8D 4D 30 0F B7 18 48 83 C0 02 48 89 06 4D 3B E2 75 1E 66 3B D9 75 19 B2 01 0F B7 18 41 FF CB 48 83 C0 02 48 89 06 66 3B D9 74 EE 44 89 5C 24 28 BD E6 0A 00 00 BF F0 06 00 00 41 BB 10 FF 00 00 41 BA 60 06 00 00 41 B9 66 09 00 00 41 BD E6 09 00 00 44 8D 75 80 66 3B D9 0F 82 FE 01 00 00 66 83 FB 3A 73 0A 0F B7 C3 2B C1 E9 E9 01 00 00 66 41 3B DB 0F 83 CA 01 00 00 66 41 3B DA 0F 82 DA 01 00 00 B8 6A 06 00 00 66 3B D8 73 0B 0F B7 C3 41 2B C2 E9 C0 01 00 00 66 3B DF 0F 82 BC 01 00 00 B8 FA 06 00 00 66 3B D8 73 0A 0F B7 C3 2B C7 E9 A3 01 00 00 66 41 3B D9 0F 82 9E 01 00 00 B8 70 09 00 00 66 3B D8 73 0B 0F B7 C3 41 2B C1 E9 84 01 00 00 66 41 3B DD 0F 82 7F 01 00 00 B8 F0 09 00 00 66 3B D8 73 0B 0F B7 C3 41 2B C5 E9 65 01 00 00 66 41 3B DE 0F 82 60 01 00 00 B8 70 0A 00 00 66 3B D8 73 0B 0F B7 C3 41 2B C6 E9 46 01 00 00 66 3B DD 0F 82 42 01 00 00 66 3B 5C 24 38 73 0A 0F B7 C3 2B C5 E9 2C 01 00 00 66 3B 5C 24 2C 0F 82 26 01 00 00 66 3B 5C 24 3C 73 0D 0F B7 C3 2D 66 0B 00 00 E9 0D 01 00 00 66 3B 5C 24 30 0F 82 07 01 00 00 66 3B 5C 24 40 73 0D 0F B7 C3 2D 66 0C 00 00 E9 EE 00 00 00 66 3B 5C 24 34 0F 82 E8 00 00 00 66 3B 5C 24 44 73 0D 0F B7 C3 2D E6 0C 00 00 E9 CF 00 00 00 66 3B 5C 24 48 0F 82 C9 00 00 00 66 3B 5C 24 4C 73 0D 0F B7 C3 2D 66 0D 00 00 E9 B0 00 00 00 66 3B 5C 24 50 0F 82 AA 00 00 00 66 3B 5C 24 54 73 0D 0F B7 C3 2D 50 0E 00 00 E9 91 00 00 00 66 3B 5C 24 58 0F 82 8B 00 00 00 66 3B 5C 24 5C 73 0A 0F B7 C3 2D D0 0E 00 00 EB 75 66 3B 5C 24 60 72 73 66 3B 5C 24 64 73 0A 0F B7 C3 2D 20 0F 00 00 EB 5D 66 3B 5C 24 68 72 5B 66 3B 5C 24 6C 73 0A 0F B7 C3 2D 40 10 00 00 EB 45 66 3B 5C 24 70 72 43 66 3B 5C 24 74 73 0A 0F B7 C3 2D E0 17 00 00 EB 2D 66 3B 5C 24 78 72 2B 66 3B 5C 24 7C 73 24 0F B7 C3 2D 10 18 00 00 EB 15 66 3B 9C 24 80 00 00 00 73 08 0F B7 C3 41 2B C3 EB 03 83 C8 FF 83 F8 FF 75 29 8D 43 BF 66 83 F8 19 76 0E 8D 43 9F 66 83 F8 19 76 05 83 C8 FF EB 12 8D 43 9F 66 83 F8 19 0F B7 C3 77 03 83 E8 20 83 C0 C9 41 3B C0 77 20 B2 01 4D 3B E7 74 07 41 88 04 24 49 FF C4 48 8B 06 0F B7 18 48 83 C0 02 48 89 06 E9 AB FD FF FF 4C 8B B4 24 98 00 00 00 33 ED 44 8A 8C 24 08 01 00 00 4C 89 A4 24 88 00 00 00 44 8D 6D 16 48 83 06 FE 48 8B 06 84 D2 75 32 66 85 DB 74 1A 66 39 18 74 15 E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 44 8A 8C 24 08 01 00 00 41 F6 D9 4C 89 36 1B C0 83 E0 FB 83 C0 07 E9 30 06 00 00 66 85 DB 74 1A 66 39 18 74 15 E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 44 8A 8C 24 08 01 00 00 48 8B 3E 40 8A D5 48 89 BC 24 A0 00 00 00 0F B7 0F 4C 8D 77 02 4C 89 36 8B C1 83 F9 45 74 14 83 F8 50 74 0A 83 F8 65 74 0A 83 F8 70 75 0B 41 8A D1 EB 06 45 84 C9 0F 94 C2 8B DD 41 BF 50 14 00 00 89 5C 24 24 84 D2 0F 84 FA 04 00 00 41 0F B7 0E 49 8D 56 02 66 83 F9 2D 48 89 16 41 B8 FD FF 00 00 41 0F 94 C1 8D 41 D5 44 88 4C 24 20 66 41 85 C0 75 0A 0F B7 0A 48 8D 42 02 48 89 06 41 BA 30 00 00 00 40 88 AC 24 18 01 00 00 66 41 3B CA 75 1F C6 84 24 18 01 00 00 01 48 8B 06 0F B7 08 48 83 C0 02 48 89 06 66 41 3B CA 74 ED 66 41 3B CA 0F 82 99 01 00 00 66 83 F9 3A 73 0B 0F B7 D1 41 2B D2 E9 83 01 00 00 B8 10 FF 00 00 66 3B C8 0F 83 64 01 00 00 B8 60 06 00 00 66 3B C8 0F 82 6C 01 00 00 8D 50 0A 66 3B CA 73 0A 0F B7 D1 2B D0 E9 55 01 00 00 B8 F0 06 00 00 66 3B C8 0F 82 4C 01 00 00 8D 50 0A 66 3B CA 72 E0 B8 66 09 00 00 66 3B C8 0F 82 36 01 00 00 8D 50 0A 66 3B CA 72 CA 8D 42 76 66 3B C8 0F 82 22 01 00 00 8D 50 0A 66 3B CA 72 B6 8D 42 76 66 3B C8 0F 82 0E 01 00 00 8D 50 0A 66 3B CA 72 A2 8D 42 76 66 3B C8 0F 82 FA 00 00 00 66 3B 4C 24 38 72 8F 8B 44 24 2C 66 3B C8 0F 82 E6 00 00 00 66 3B 4C 24 3C 0F 82 77 FF FF FF 8B 44 24 30 66 3B C8 0F 82 CE 00 00 00 66 3B 4C 24 40 0F 82 5F FF FF FF 8B 44 24 34 66 3B C8 0F 82 B6 00 00 00 66 3B 4C 24 44 0F 82 47 FF FF FF 8B 44 24 48 66 3B C8 0F 82 9E 00 00 00 66 3B 4C 24 4C 0F 82 2F FF FF FF 8B 44 24 50 66 3B C8 0F 82 86 00 00 00 66 3B 4C 24 54 0F 82 17 FF FF FF 8B 44 24 58 66 3B C8 72 72 66 3B 4C 24 5C 0F 82 03 FF FF FF 8B 44 24 60 66 3B C8 72 5E 66 3B 4C 24 64 0F 82 EF FE FF FF 8B 44 24 68 66 3B C8 72 4A 66 3B 4C 24 6C 0F 82 DB FE FF FF 8B 44 24 70 66 3B C8 72 36 66 3B 4C 24 74 0F 82 C7 FE FF FF 8B 44 24 78 66 3B C8 72 22 66 3B 4C 24 7C 73 1B E9 B2 FE FF FF 66 3B 8C 24 80 00 00 00 0F 82 A4 FE FF FF 83 CA FF 83 FA FF 75 29 8D 41 BF 66 83 F8 19 76 0E 8D 41 9F 66 83 F8 19 76 05 83 CA FF EB 12 8D 41 9F 0F B7 D1 66 83 F8 19 77 03 83 EA 20 83 C2 C9 83 FA 0A 73 32 8D 04 9B C6 84 24 18 01 00 00 01 8D 1C 42 89 5C 24 24 41 3B DF 7F 12 48 8B 06 0F B7 08 48 83 C0 02 48 89 06 E9 06 FE FF FF BB 51 14 00 00 89 5C 24 24 44 8B 44 24 2C BF E6 09 00 00 8B 5C 24 30 BD E6 0A 00 00 44 8B 64 24 34 41 BB 10 FF 00 00 41 BF 60 06 00 00 41 BE F0 06 00 00 44 8D 6F 80 44 8D 4D 80 66 41 3B CA 0F 82 B7 01 00 00 66 83 F9 3A 73 0B 0F B7 C1 41 2B C2 E9 A1 01 00 00 66 41 3B CB 0F 83 82 01 00 00 66 41 3B CF 0F 82 92 01 00 00 B8 6A 06 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C7 E9 78 01 00 00 66 41 3B CE 0F 82 73 01 00 00 B8 FA 06 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C6 E9 59 01 00 00 66 41 3B CD 0F 82 54 01 00 00 B8 70 09 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C5 E9 3A 01 00 00 66 3B CF 0F 82 36 01 00 00 B8 F0 09 00 00 66 3B C8 73 0A 0F B7 C1 2B C7 E9 1D 01 00 00 66 41 3B C9 0F 82 18 01 00 00 B8 70 0A 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C1 E9 FE 00 00 00 66 3B CD 0F 82 FA 00 00 00 66 3B 4C 24 38 73 0A 0F B7 C1 2B C5 E9 E4 00 00 00 66 41 3B C8 0F 82 DF 00 00 00 66 3B 4C 24 3C 73 0B 0F B7 C1 41 2B C0 E9 C8 00 00 00 66 3B CB 0F 82 C4 00 00 00 66 3B 4C 24 40 73 0A 0F B7 C1 2B C3 E9 AE 00 00 00 66 41 3B CC 0F 82 A9 00 00 00 66 3B 4C 24 44 73 0B 0F B7 C1 41 2B C4 E9 92 00 00 00 8B 54 24 48 66 3B CA 0F 82 8A 00 00 00 66 3B 4C 24 4C 73 07 0F B7 C1 2B C2 EB 77 8B 54 24 50 66 3B CA 72 73 66 3B 4C 24 54 72 E9 8B 54 24 58 66 3B CA 72 63 66 3B 4C 24 5C 72 D9 8B 54 24 60 66 3B CA 72 53 66 3B 4C 24 64 72 C9 8B 54 24 68 66 3B CA 72 43 66 3B 4C 24 6C 72 B9 8B 54 24 70 66 3B CA 72 33 66 3B 4C 24 74 72 A9 8B 54 24 78 66 3B CA 72 23 66 3B 4C 24 7C 73 1C EB 97 66 3B 8C 24 80 00 00 00 73 08 0F B7 C1 41 2B C3 EB 03 83 C8 FF 83 F8 FF 75 29 8D 41 BF 66 83 F8 19 76 0E 8D 41 9F 66 83 F8 19 76 05 83 C8 FF EB 12 8D 41 9F 66 83 F8 19 0F B7 C1 77 03 83 E8 20 83 C0 C9 83 F8 0A 73 12 48 8B 06 0F B7 08 48 83 C0 02 48 89 06 E9 FF FD FF FF 48 8B BC 24 A0 00 00 00 33 ED 44 8A 4C 24 20 41 BF 50 14 00 00 8B 5C 24 24 44 8A 84 24 18 01 00 00 4C 8B A4 24 88 00 00 00 4C 8D 77 02 44 8D 6D 16 45 84 C9 74 02 F7 DB 45 84 C0 75 27 48 83 06 FE 48 8B 06 66 85 C9 74 12 66 39 08 74 0D E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 48 89 3E 0F B7 0F 4C 89 36 48 83 06 FE 48 8B 06 66 85 C9 74 12 66 39 08 74 0D E8 ?? ?? ?? ?? 44 89 28 E8 ?? ?? ?? ?? 4C 8B 8C 24 10 01 00 00 4D 8D 41 08 4D 3B E0 74 6C 49 8D 44 24 FF 40 38 28 75 08 4C 8B E0 49 3B C0 75 EE 4D 3B E0 74 55 41 3B DF 7E 07 B8 09 00 00 00 EB 78 41 BA B0 EB FF FF 41 3B DA 7D 07 B8 08 00 00 00 EB 66 8A 94 24 08 01 00 00 8A C2 F6 D8 1B C9 83 E1 03 FF C1 0F AF 4C 24 28 03 D9 41 3B DF 7F C9 41 3B DA 7C D6 45 2B E0 41 89 19 84 D2 45 89 61 04 40 0F 95 C5 8B C5 EB 2F B8 02 00 00 00 EB 28 4D 8B C6 48 8D 8C 24 08 01 00 00 48 8B D6 E8 ?? ?? ?? ?? EB 13 4D 8B C6 48 8D 8C 24 08 01 00 00 48 8B D6 E8 ?? ?? ?? ?? 48 81 C4 B8 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_0_27_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z"
		size = 322
		refs = "001f __ImageBase 0034 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 003e ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 006c _errno 0077 _invalid_parameter_noinfo 0092 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 009c ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 20 48 8B F9 4C 8D 3D ?? ?? ?? ?? 33 C9 4D 8B F0 48 8B DA 8D 69 03 8A 07 42 3A 84 39 ?? ?? ?? ?? 74 0E 42 3A 84 39 ?? ?? ?? ?? 0F 85 AB 00 00 00 48 8B 03 48 FF C1 8A 10 48 FF C0 48 89 03 88 17 48 3B CD 75 D1 48 FF 0B 48 8B 03 84 D2 74 14 38 10 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 4C 8B 33 33 D2 41 8A 0E 49 8D 46 01 48 89 03 88 0F 8A 07 42 3A 84 3A ?? ?? ?? ?? 74 0A 42 3A 84 3A ?? ?? ?? ?? 75 78 48 8B 03 48 FF C2 8A 08 48 FF C0 48 89 03 88 0F 48 83 FA 05 75 D4 48 FF 0B 48 8B 03 84 C9 74 14 38 08 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 5C 24 30 8B C5 48 8B 6C 24 38 48 8B 7C 24 40 4C 8B 74 24 48 48 83 C4 20 41 5F C3 8A 07 48 FF 0B 48 8B 0B 84 C0 74 14 38 01 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BD 07 00 00 00 EB 20 8A 07 48 FF 0B 48 8B 0B 84 C0 74 14 38 01 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? C6 07 00 4C 89 33 EB 94 }
	condition:
		$1
}

rule file_0_28_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$c_string_character_source@_W@0@PEB_W@Z"
		size = 365
		refs = "001e __ImageBase 0035 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 0040 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 0076 _errno 0081 _invalid_parameter_noinfo 00a1 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 00ac ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 20 33 ED 4C 8D 3D ?? ?? ?? ?? 48 8B F9 4D 8B F0 8B CD 48 8B DA 0F B7 07 66 42 3B 84 39 ?? ?? ?? ?? 74 0F 66 42 3B 84 39 ?? ?? ?? ?? 0F 85 C7 00 00 00 48 8B 03 48 83 C1 02 0F B7 10 48 83 C0 02 48 89 03 66 89 17 48 83 F9 06 75 C9 48 83 03 FE 48 8B 03 66 85 D2 74 15 66 39 10 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 4C 8B 33 48 8B D5 41 0F B7 0E 49 8D 46 02 48 89 03 66 89 0F 0F B7 07 66 42 3B 84 3A ?? ?? ?? ?? 74 0F 66 42 3B 84 3A ?? ?? ?? ?? 0F 85 86 00 00 00 48 8B 03 48 83 C2 02 0F B7 08 48 83 C0 02 48 89 03 66 89 0F 48 83 FA 0A 75 C9 48 83 03 FE 48 8B 03 66 85 C9 74 15 66 39 08 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 03 00 00 00 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 7C 24 40 4C 8B 74 24 48 48 83 C4 20 41 5F C3 0F B7 07 48 83 03 FE 48 8B 0B 66 85 C0 74 15 66 39 01 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 07 00 00 00 EB 29 0F B7 07 48 83 03 FE 48 8B 0B 66 85 C0 74 15 66 39 01 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 03 00 00 00 66 89 2F 4C 89 33 EB 89 }
	condition:
		$1
}

rule file_0_29_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z"
		size = 448
		refs = "0020 __ImageBase 002d ?uppercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 0037 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 0065 _errno 006c _invalid_parameter_noinfo 00d8 ??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z 010d ??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 4D 8B F0 48 8B F9 33 C9 4C 8D 05 ?? ?? ?? ?? 48 8B DA 8A 07 42 3A 84 01 ?? ?? ?? ?? 74 0A 42 3A 84 01 ?? ?? ?? ?? 75 5C 48 8B 03 48 FF C1 8A 10 48 FF C0 48 89 03 88 17 48 83 F9 03 75 D4 48 FF 0B 8D 71 13 48 8B 03 84 D2 74 10 38 10 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 4C 8B 33 41 8A 0E 49 8D 46 01 48 89 03 88 0F 80 F9 28 74 40 48 FF 0B 48 8B 03 84 C9 0F 84 02 01 00 00 38 08 E9 ED 00 00 00 8A 07 48 FF 0B 48 8B 0B 84 C0 74 15 38 01 74 11 E8 ?? ?? ?? ?? BE 16 00 00 00 89 30 E8 ?? ?? ?? ?? B8 07 00 00 00 E9 D5 00 00 00 48 8B 03 48 8B D3 8A 08 48 FF C0 48 89 03 88 0F 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 26 8A 07 48 FF 0B 48 8B 0B 84 C0 74 10 38 01 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? B8 05 00 00 00 E9 A4 00 00 00 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 23 8A 07 48 FF 0B 48 8B 0B 84 C0 74 10 38 01 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? B8 06 00 00 00 EB 72 B2 29 38 17 74 67 80 3F 00 74 31 0F BE 0F 8D 41 D0 83 F8 09 76 15 8D 41 9F 83 F8 19 76 0D 8D 41 BF 83 F8 19 76 05 83 F9 5F 75 3E 48 8B 03 8A 08 48 FF C0 48 89 03 88 0F 3A CA 75 CA 8A 07 3A C2 74 2B 48 FF 0B 48 8B 0B 84 C0 74 10 38 01 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? B8 04 00 00 00 C6 07 00 4C 89 33 EB 09 8A 07 EB D5 B8 04 00 00 00 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_0_30_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$c_string_character_source@_W@0@PEB_W@Z"
		size = 502
		refs = "0024 __ImageBase 0035 ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 0040 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 0075 _errno 007c _invalid_parameter_noinfo 00f5 ??$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@0@@Z 012e ??$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@0@@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 ED 4D 8B F0 48 8B F9 4C 8D 05 ?? ?? ?? ?? 8B CD 48 8B DA 0F B7 07 66 42 3B 84 01 ?? ?? ?? ?? 74 0B 66 42 3B 84 01 ?? ?? ?? ?? 75 69 48 8B 03 48 83 C1 02 0F B7 10 48 83 C0 02 48 89 03 66 89 17 48 83 F9 06 75 CD 48 83 03 FE 8D 71 10 48 8B 03 66 85 D2 74 11 66 39 10 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 4C 8B 33 41 0F B7 0E 49 8D 46 02 48 89 03 66 89 0F 66 83 F9 28 74 47 48 83 03 FE 48 8B 03 66 85 C9 0F 84 1D 01 00 00 66 39 08 E9 07 01 00 00 0F B7 07 48 83 03 FE 48 8B 0B 66 85 C0 74 16 66 39 01 74 11 E8 ?? ?? ?? ?? BE 16 00 00 00 89 30 E8 ?? ?? ?? ?? B8 07 00 00 00 E9 EB 00 00 00 48 8B 03 48 8B D3 0F B7 08 48 83 C0 02 48 89 03 66 89 0F 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 2A 0F B7 07 48 83 03 FE 48 8B 0B 66 85 C0 74 11 66 39 01 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? B8 05 00 00 00 E9 B4 00 00 00 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 27 0F B7 0F 48 83 03 FE 48 8B 13 66 85 C9 74 11 66 39 0A 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? B8 06 00 00 00 EB 7E 66 83 3F 29 74 73 66 39 2F 74 36 0F B7 0F 8D 41 D0 83 F8 09 76 15 8D 41 9F 83 F8 19 76 0D 8D 41 BF 83 F8 19 76 05 83 F9 5F 75 49 48 8B 03 0F B7 08 48 83 C0 02 48 89 03 66 89 0F 66 83 F9 29 75 C5 0F B7 07 66 83 F8 29 74 2F 48 83 03 FE 48 8B 0B 66 85 C0 74 11 66 39 01 74 0C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? B8 04 00 00 00 66 89 2F 4C 89 33 EB 0A 0F B7 07 EB D1 B8 04 00 00 00 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_0_31_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 69
		refs = "0006 __ImageBase 0017 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB 0021 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB"
	strings:
		$1 = { 45 33 C0 4C 8D 1D ?? ?? ?? ?? 45 8B C8 4C 8B D1 41 8A 02 43 3A 84 19 ?? ?? ?? ?? 74 0A 43 3A 84 19 ?? ?? ?? ?? 75 1A 48 8B 02 49 FF C1 8A 08 48 FF C0 48 89 02 41 88 0A 49 83 F9 04 75 D2 41 B0 01 41 8A C0 C3 }
	condition:
		$1
}

rule file_0_32_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@0@@Z"
		size = 76
		refs = "0006 __ImageBase 0019 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@1@@Z@4QB_WB 0024 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@1@@Z@4QB_WB"
	strings:
		$1 = { 45 33 C0 4C 8D 1D ?? ?? ?? ?? 45 8B C8 4C 8B D1 41 0F B7 02 66 43 3B 84 19 ?? ?? ?? ?? 74 0B 66 43 3B 84 19 ?? ?? ?? ?? 75 1E 48 8B 02 49 83 C1 02 0F B7 08 48 83 C0 02 48 89 02 66 41 89 0A 49 83 F9 08 75 CB 41 B0 01 41 8A C0 C3 }
	condition:
		$1
}

rule file_0_33_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 69
		refs = "0006 __ImageBase 0017 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB 0021 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB"
	strings:
		$1 = { 45 33 C0 4C 8D 1D ?? ?? ?? ?? 45 8B C8 4C 8B D1 41 8A 02 43 3A 84 19 ?? ?? ?? ?? 74 0A 43 3A 84 19 ?? ?? ?? ?? 75 1A 48 8B 02 49 FF C1 8A 08 48 FF C0 48 89 02 41 88 0A 49 83 F9 05 75 D2 41 B0 01 41 8A C0 C3 }
	condition:
		$1
}

rule file_0_34_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@0@@Z"
		size = 76
		refs = "0006 __ImageBase 0019 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@1@@Z@4QB_WB 0024 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@1@@Z@4QB_WB"
	strings:
		$1 = { 45 33 C0 4C 8D 1D ?? ?? ?? ?? 45 8B C8 4C 8B D1 41 0F B7 02 66 43 3B 84 19 ?? ?? ?? ?? 74 0B 66 43 3B 84 19 ?? ?? ?? ?? 75 1E 48 8B 02 49 83 C1 02 0F B7 08 48 83 C0 02 48 89 02 66 41 89 0A 49 83 F9 0A 75 CB 41 B0 01 41 8A C0 C3 }
	condition:
		$1
}

rule file_0_35_0 {
	meta:
		name = "??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z"
		size = 279
		refs = "0080 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z 009b ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { 48 83 EC 38 4C 8B CA 83 F9 05 0F 8F A6 00 00 00 0F 84 8B 00 00 00 33 C0 85 C9 74 6D 83 E9 01 74 4D 83 E9 01 74 3A 83 E9 01 74 22 83 F9 01 0F 85 CE 00 00 00 38 82 08 03 00 00 0F 95 C0 C1 E0 1F 0D FF FF FF 7F 41 89 00 E9 C3 00 00 00 38 82 08 03 00 00 0F 95 C0 C1 E0 1F 0D 00 00 80 7F EB E5 38 82 08 03 00 00 0F 95 C0 C1 E0 1F EB D7 48 8D 54 24 20 4C 89 44 24 20 49 8B C9 88 44 24 28 E8 ?? ?? ?? ?? E9 89 00 00 00 48 8D 54 24 20 4C 89 44 24 20 49 8B C9 88 44 24 28 E8 ?? ?? ?? ?? EB 71 33 C0 38 82 08 03 00 00 0F 95 C0 C1 E0 1F 0D 01 00 80 7F EB 8F 83 E9 06 74 4E 83 E9 01 74 3D 83 E9 01 74 20 83 F9 01 75 38 33 C0 38 82 08 03 00 00 0F 95 C0 C1 E0 1F 0D 00 00 80 7F 41 89 00 8D 41 02 EB 2D 33 C0 38 82 08 03 00 00 0F 95 C0 C1 E0 1F 41 89 00 B8 02 00 00 00 EB 15 33 C0 41 89 00 B8 01 00 00 00 EB 09 41 C7 00 00 00 C0 FF 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_36_0 {
	meta:
		name = "??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z"
		size = 295
		refs = "0084 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z 00a0 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { 48 83 EC 38 4C 8B CA 83 F9 05 0F 8F A4 00 00 00 0F 84 90 00 00 00 33 C0 85 C9 74 71 83 E9 01 74 50 83 E9 01 74 39 83 E9 01 74 28 83 F9 01 0F 85 D8 00 00 00 48 B9 FF FF FF FF FF FF FF 7F 38 82 08 03 00 00 0F 95 C0 48 C1 E0 3F 48 0B C1 E9 CA 00 00 00 48 B9 00 00 00 00 00 00 F0 7F EB DF 38 82 08 03 00 00 0F 95 C0 48 C1 E0 3F E9 AC 00 00 00 48 8D 54 24 20 4C 89 44 24 20 49 8B C9 C6 44 24 28 01 E8 ?? ?? ?? ?? E9 95 00 00 00 48 8D 54 24 20 4C 89 44 24 20 49 8B C9 C6 44 24 28 01 E8 ?? ?? ?? ?? EB 7C 33 C0 48 B9 01 00 00 00 00 00 F0 7F EB 8A 83 E9 06 74 5A 83 E9 01 74 49 83 E9 01 74 2B 83 F9 01 75 44 33 C0 48 B9 00 00 00 00 00 00 F0 7F 38 82 08 03 00 00 0F 95 C0 48 C1 E0 3F 48 0B C1 49 89 00 B8 03 00 00 00 EB 34 33 C0 38 82 08 03 00 00 0F 95 C0 48 C1 E0 3F 49 89 00 B8 02 00 00 00 EB 1B 33 C0 49 89 00 B8 01 00 00 00 EB 0F 48 B8 00 00 00 00 00 00 F8 FF 49 89 00 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_37_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 78
	strings:
		$1 = { 48 89 5C 24 08 4C 8B D1 4D 85 C0 74 35 48 8B 5C 24 28 4C 2B D2 4C 8B DA 49 F7 DB 41 8A 01 41 3A 04 12 74 04 3A 02 75 22 48 8B 03 48 FF C2 8A 08 48 FF C0 48 89 03 49 8D 04 13 41 88 09 49 3B C0 75 D9 B0 01 48 8B 5C 24 08 C3 32 C0 EB F6 }
	condition:
		$1
}

rule file_0_38_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$c_string_character_source@_W@0@@Z"
		size = 81
	strings:
		$1 = { 48 89 5C 24 08 45 33 D2 4C 8B D9 4D 85 C0 74 35 48 8B 5C 24 28 4C 2B DA 41 0F B7 01 66 41 3B 04 13 74 05 66 3B 02 75 25 48 8B 03 49 FF C2 48 83 C2 02 0F B7 08 48 83 C0 02 48 89 03 66 41 89 09 4D 3B D0 75 D3 B0 01 48 8B 5C 24 08 C3 32 C0 EB F6 }
	condition:
		$1
}

rule file_0_47_0 {
	meta:
		name = "??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
		size = 143
		refs = "001d __acrt_locale_changed_data 0027 __acrt_initial_locale_pointers 0033 __acrt_getptd 0057 __acrt_update_locale_info 0063 __acrt_update_multibyte_info"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 C6 41 18 00 48 8B F9 48 85 D2 74 05 0F 10 02 EB 10 83 3D ?? ?? ?? ?? 00 75 0E 0F 10 05 ?? ?? ?? ?? F3 0F 7F 41 08 EB 4F E8 ?? ?? ?? ?? 48 89 07 48 8D 57 08 48 8B 88 90 00 00 00 48 89 0A 48 8B 88 88 00 00 00 48 89 4F 10 48 8B C8 E8 ?? ?? ?? ?? 48 8B 0F 48 8D 57 10 E8 ?? ?? ?? ?? 48 8B 0F 8B 81 A8 03 00 00 A8 02 75 0D 83 C8 02 89 81 A8 03 00 00 C6 47 18 01 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_0_48_0 {
	meta:
		name = "??0big_integer@__crt_strtox@@QEAA@AEBU01@@Z"
		size = 47
		refs = "0022 memcpy_s"
		altNames = "??4big_integer@__crt_strtox@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 02 4C 8D 42 04 89 01 48 8B D9 44 8B 0A 48 83 C1 04 49 C1 E1 02 BA CC 01 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_52_0 {
	meta:
		name = "??1?$c_string_character_source@D@__crt_strtox@@QEAA@XZ"
		size = 16
		altNames = "??1?$c_string_character_source@_W@__crt_strtox@@QEAA@XZ"
	strings:
		$1 = { 48 8B 51 08 48 85 D2 74 06 48 8B 01 48 89 02 C3 }
	condition:
		$1
}

rule file_0_54_0 {
	meta:
		name = "??1_LocaleUpdate@@QEAA@XZ"
		size = 17
	strings:
		$1 = { 80 79 18 00 74 0A 48 8B 01 83 A0 A8 03 00 00 FD C3 }
	condition:
		$1
}

rule file_0_56_0 {
	meta:
		name = "??M__crt_strtox@@YA_NAEBUbig_integer@0@0@Z"
		size = 83
	strings:
		$1 = { 8B 01 4C 8B C9 8B 0A 4C 8B C2 3B C1 77 2D 73 03 B0 01 C3 FF C8 83 F8 FF 74 21 66 0F 1F 44 00 00 48 8D 14 85 00 00 00 00 42 8B 4C 02 04 42 39 4C 0A 04 75 0A FF C8 83 F8 FF 75 E5 32 C0 C3 83 F8 FF 74 F8 8B C8 41 8B 44 80 04 41 39 44 89 04 0F 96 C0 C3 }
	condition:
		$1
}

rule file_0_64_0 {
	meta:
		name = "?accumulate_decimal_digits_into_big_integer@__crt_strtox@@YAXQEBE0AEAUbig_integer@1@@Z"
		size = 1464
		refs = "0032 __security_cookie 012e __ImageBase 0162 ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 018a memset 01a4 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 01ba memcpy 0276 _errno 02b3 _invalid_parameter_noinfo 04da ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 0593 __security_check_cookie"
	strings:
		$1 = { 48 3B CA 0F 84 AE 05 00 00 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 20 55 41 54 41 55 41 56 41 57 48 8D A8 E8 FC FF FF 48 81 EC F0 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 E0 02 00 00 33 F6 4D 8B F0 44 8B FE 44 8B EE 48 8B DA 4C 8B C9 41 83 FD 09 0F 85 A2 00 00 00 45 8B 1E 45 85 DB 74 4A 44 8B C6 44 8B D6 41 8B D2 41 FF C2 41 8B 44 96 04 48 69 C8 00 CA 9A 3B 41 8B C0 48 03 C8 4C 8B C1 41 89 4C 96 04 49 C1 E8 20 45 3B D3 75 D7 45 85 C0 74 16 41 83 3E 73 73 0D 41 8B 06 45 89 44 86 04 41 FF 06 EB 03 41 89 36 45 85 FF 74 45 44 8B C6 41 39 36 74 22 41 8B D0 41 FF C0 41 8B C7 41 8B 4C 96 04 48 03 C8 4C 8B F9 41 89 4C 96 04 49 C1 EF 20 45 3B 06 75 DE 45 85 FF 74 16 41 83 3E 73 73 0D 41 8B 06 45 89 7C 86 04 41 FF 06 EB 03 41 89 36 44 8B FE 44 8B EE 41 0F B6 01 43 8D 0C BF 41 FF C5 49 FF C1 44 8D 3C 48 4C 3B CB 0F 85 39 FF FF FF 45 85 ED 0F 84 67 04 00 00 B8 CD CC CC CC 41 F7 E5 8B C2 48 8D 15 ?? ?? ?? ?? C1 E8 03 89 44 24 2C 44 8B E0 89 44 24 24 85 C0 0F 84 81 03 00 00 41 8B C4 B9 26 00 00 00 44 3B E1 0F 47 C1 89 44 24 28 FF C8 8B F8 0F B6 8C 82 ?? ?? ?? ?? 0F B6 B4 82 ?? ?? ?? ?? 8B D9 48 C1 E3 02 33 D2 4C 8B C3 8D 04 0E 48 8D 8D 14 01 00 00 89 85 10 01 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 C1 E6 02 0F B7 84 B9 ?? ?? ?? ?? 48 8D 91 ?? ?? ?? ?? 48 8D 8D 14 01 00 00 4C 8B C6 48 03 CB 48 8D 14 82 E8 ?? ?? ?? ?? 8B B5 10 01 00 00 83 FE 01 0F 87 82 00 00 00 8B 85 14 01 00 00 33 F6 85 C0 75 08 41 89 36 E9 C3 02 00 00 83 F8 01 0F 84 BA 02 00 00 45 8B 16 45 85 D2 0F 84 AE 02 00 00 44 8B C6 44 8B CE 4C 8B D8 41 8B D1 41 FF C1 41 8B C0 41 8B 4C 96 04 49 0F AF CB 48 03 C8 4C 8B C1 41 89 4C 96 04 49 C1 E8 20 45 3B CA 75 DA 45 85 C0 0F 84 76 02 00 00 41 83 3E 73 73 10 41 8B 06 45 89 44 86 04 41 FF 06 E9 60 02 00 00 41 89 36 40 8A C6 E9 57 02 00 00 41 83 3E 01 0F 87 AB 00 00 00 4C 8B C6 49 8D 5E 04 8B 3B 41 89 36 33 F6 49 C1 E0 02 4D 85 C0 74 47 48 85 DB 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 30 B8 CC 01 00 00 48 8B CB 4C 3B C0 77 0E 48 8D 95 14 01 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 85 FF 0F 84 1A FF FF FF 83 FF 01 0F 84 DC 01 00 00 45 8B 16 45 85 D2 0F 84 D0 01 00 00 44 8B C6 44 8B CE 4C 8B DF 41 8B D1 41 FF C1 41 8B C0 8B 0C 93 49 0F AF CB 48 03 C8 4C 8B C1 89 0C 93 49 C1 E8 20 45 3B CA 75 DE E9 21 FF FF FF 41 3B 36 49 8D 7E 04 45 8B 06 48 8D 95 14 01 00 00 0F 92 C0 48 8D 8D 14 01 00 00 84 C0 44 0F 45 C6 48 0F 44 D7 41 0F 45 36 48 0F 45 CF 33 C0 48 89 54 24 38 45 33 D2 48 89 4C 24 30 44 89 44 24 20 89 44 24 40 45 85 C0 0F 84 FC 00 00 00 46 8B 24 92 45 85 E4 75 1B 44 3B D0 0F 85 D9 00 00 00 46 21 64 94 44 41 8D 42 01 89 44 24 40 E9 C7 00 00 00 33 DB 45 8B CA 85 F6 0F 84 AB 00 00 00 45 8B DA 41 F7 DB 41 83 F9 73 74 56 44 3B C8 75 16 41 8B C1 41 8D 4B 01 83 64 84 44 00 43 8D 04 11 03 C8 89 4C 24 40 48 8B 44 24 30 43 8D 0C 19 45 8B C1 41 FF C1 8B 14 88 42 8B 44 84 44 49 0F AF D4 48 03 D0 8B C3 48 03 D0 43 8D 04 19 48 8B DA 42 89 54 84 44 48 C1 EB 20 3B C6 8B 44 24 40 75 A4 85 DB 74 40 41 83 F9 73 0F 84 43 01 00 00 44 3B C8 75 10 41 8B C1 83 64 84 44 00 41 8D 41 01 89 44 24 40 41 8B C9 41 FF C1 8B C3 8B 54 8C 44 48 03 D0 89 54 8C 44 8B 44 24 40 48 C1 EA 20 8B DA 85 D2 75 C0 44 8B 44 24 20 41 83 F9 73 0F 84 FE 00 00 00 48 8B 54 24 38 41 FF C2 45 3B D0 0F 85 09 FF FF FF 44 8B 64 24 24 44 8B C0 33 F6 49 C1 E0 02 41 89 06 4D 85 C0 74 45 48 85 FF 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 2E B8 CC 01 00 00 48 8B CF 4C 3B C0 77 0C 48 8D 54 24 44 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? B0 01 84 C0 0F 84 8D 00 00 00 44 2B 64 24 28 48 8D 15 ?? ?? ?? ?? 44 89 64 24 24 0F 85 83 FC FF FF 8B 44 24 2C 8D 04 80 03 C0 44 2B E8 74 6B 41 8D 45 FF 8B 84 82 ?? ?? ?? ?? 85 C0 74 59 83 F8 01 74 57 45 8B 16 45 85 D2 74 4F 44 8B C6 44 8B CE 44 8B D8 41 8B D1 41 FF C1 41 8B C0 41 8B 4C 96 04 49 0F AF CB 48 03 C8 4C 8B C1 41 89 4C 96 04 49 C1 E8 20 45 3B CA 75 DA 45 85 C0 74 1B 41 83 3E 73 73 12 41 8B 06 45 89 44 86 04 41 FF 06 EB 08 33 F6 41 89 36 41 89 36 45 85 FF 74 45 44 8B C6 41 39 36 74 22 41 8B C8 41 FF C0 41 8B D7 41 8B 44 8E 04 48 03 D0 41 89 54 8E 04 48 C1 EA 20 44 8B FA 45 3B 06 75 DE 45 85 FF 74 16 41 83 3E 73 73 0D 41 8B 06 45 89 7C 86 04 41 FF 06 EB 03 41 89 36 48 8B 8D E0 02 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 F0 03 00 00 49 8B 5B 30 49 8B 73 38 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_0_65_0 {
	meta:
		name = "?add@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
		size = 139
		refs = "007d memcpy_s"
	strings:
		$1 = { 48 81 EC F8 01 00 00 44 8B CA 4C 8B C1 85 D2 74 48 45 33 DB 45 8B D3 44 39 19 74 28 0F 1F 40 00 41 8B C2 41 FF C2 41 8B 54 80 04 49 8D 0C 80 41 8B C1 48 03 D0 4C 8B CA 89 51 04 49 C1 E9 20 45 3B 10 75 DC 45 85 C9 74 10 41 8B 00 83 F8 73 73 12 45 89 4C 80 04 41 FF 00 B0 01 48 81 C4 F8 01 00 00 C3 45 89 18 49 8D 48 04 4C 8D 44 24 24 44 89 5C 24 20 45 33 C9 BA CC 01 00 00 E8 ?? ?? ?? ?? 32 C0 48 81 C4 F8 01 00 00 C3 }
	condition:
		$1
}

rule file_0_66_0 {
	meta:
		name = "?add_carry@__crt_strtox@@YAIAEAIII@Z"
		size = 20
	strings:
		$1 = { 8B 01 8B D2 48 03 C2 41 8B D0 48 03 C2 89 01 48 C1 E8 20 C3 }
	condition:
		$1
}

rule file_0_67_0 {
	meta:
		name = "?add_multiply_carry@__crt_strtox@@YAIAEAIIII@Z"
		size = 34
	strings:
		$1 = { 41 8B C0 44 8B D2 4C 0F AF D0 8B 01 4C 03 D0 41 8B C1 4C 03 D0 4C 89 54 24 08 8B 44 24 0C 44 89 11 C3 }
	condition:
		$1
}

rule file_0_68_0 {
	meta:
		name = "?as_double@floating_point_value@__crt_strtox@@QEBAAEANXZ"
		size = 57
		refs = "001b ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0028 ??_C@_1FM@FELNCOBF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA_?$AAv?$AAa?$AAl@ 002f ??_C@_1BG@GEMHBGAF@?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$AA@ 0034 _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 80 79 08 00 74 08 48 8B 01 48 83 C4 38 C3 48 83 64 24 20 00 4C 8D 05 ?? ?? ?? ?? 41 B9 9F 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_0_69_0 {
	meta:
		name = "?as_float@floating_point_value@__crt_strtox@@QEBAAEAMXZ"
		size = 57
		refs = "001b ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0028 ??_C@_1FK@JOJELFFO@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA_?$AAv?$AAa?$AAl@ 002f ??_C@_1BI@BANMPGJI@?$AA?$CB?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$AA@ 0034 _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 80 79 08 00 75 08 48 8B 01 48 83 C4 38 C3 48 83 64 24 20 00 4C 8D 05 ?? ?? ?? ?? 41 B9 A5 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_0_70_0 {
	meta:
		name = "?assemble_floating_point_infinity@__crt_strtox@@YAX_NAEBVfloating_point_value@1@@Z"
		size = 60
	strings:
		$1 = { 48 8B 02 45 33 C0 44 38 42 08 74 1B 84 C9 48 B9 00 00 00 00 00 00 F0 7F 41 0F 95 C0 49 C1 E0 3F 4C 0B C1 4C 89 00 C3 84 C9 41 0F 95 C0 41 C1 E0 1F 41 81 C8 00 00 80 7F 44 89 00 C3 }
	condition:
		$1
}

rule file_0_71_0 {
	meta:
		name = "?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1AEBVfloating_point_value@1@@Z"
		size = 947
		refs = "0163 fegetround"
	strings:
		$1 = { 48 89 5C 24 18 89 54 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 33 DB B8 FF FF FF FF 89 5C 24 70 45 8A D1 41 8A E8 44 8B DA 48 8B F9 48 3B C8 76 17 48 8B C1 48 C1 E8 20 0F BD C8 74 04 FF C1 EB 02 8B CB 83 C1 20 EB 0B 0F BD C9 74 04 FF C1 EB 02 8B CB 4C 8B B4 24 90 00 00 00 41 8B F3 41 8A 56 08 8A C2 F6 D8 8A C2 45 1B ED 41 83 E5 1D 41 83 C5 18 44 2B E9 41 2B F5 F6 D8 45 1B C0 41 81 E0 80 03 00 00 41 83 C0 7F 41 3B F0 7E 3E 49 8B 06 84 D2 74 1C 40 84 ED 48 B9 00 00 00 00 00 00 F0 7F 0F 95 C3 48 C1 E3 3F 48 0B D9 48 89 18 EB 11 40 84 ED 0F 95 C3 C1 E3 1F 81 CB 00 00 80 7F 89 18 B8 03 00 00 00 E9 CC 02 00 00 8A C2 49 BC 00 00 80 FF FF FF 0F 00 F6 D8 1B C9 81 E1 80 FC FF FF 83 C1 82 3B F1 0F 8D 44 01 00 00 41 8D 04 30 41 8B F0 45 8D 4D FF F7 DE 44 03 C8 44 89 4C 24 20 41 8B C9 45 85 C9 0F 89 1B 02 00 00 F7 D9 89 4C 24 24 83 F9 40 0F 83 E7 00 00 00 8B C1 41 BF 01 00 00 00 48 0F A3 C7 41 8B C7 FF C9 0F 92 44 24 70 48 D3 E0 48 85 C7 0F 95 C1 88 8C 24 90 00 00 00 45 84 D2 74 0B 48 FF C8 44 8A E3 48 85 C7 74 03 45 8A E7 84 C9 75 05 45 84 E4 74 5B E8 ?? ?? ?? ?? 85 C0 74 25 3D 00 01 00 00 74 19 44 8B 4C 24 20 44 8B 5C 24 78 3D 00 02 00 00 75 3A 40 84 ED 0F 94 C0 EB 34 40 8A C5 EB 17 38 9C 24 90 00 00 00 74 1A 45 84 E4 75 06 38 5C 24 70 74 0F 41 8A C7 44 8B 4C 24 20 44 8B 5C 24 78 EB 0C 44 8B 4C 24 20 44 8B 5C 24 78 8A C3 8B 4C 24 24 48 D3 EF 0F B6 C0 48 03 F8 74 39 41 8A 56 08 49 BC 00 00 80 FF FF FF 0F 00 8A C2 F6 D8 48 1B C9 49 23 CC 48 81 C1 FF FF 7F 00 48 3B F9 0F 86 39 01 00 00 41 8B F3 41 2B F1 41 2B F5 41 2B F7 E9 28 01 00 00 49 8B 06 41 38 5E 08 74 0F 40 84 ED 0F 95 C3 48 C1 E3 3F 48 89 18 EB 0B 40 84 ED 0F 95 C3 C1 E3 1F 89 18 B8 02 00 00 00 E9 67 01 00 00 45 85 ED 0F 89 EA 00 00 00 41 F7 DD 41 83 FD 40 72 08 48 8B FB E9 98 00 00 00 41 8B C5 41 8D 4D FF 48 0F A3 C7 41 BF 01 00 00 00 41 8B C7 0F 92 84 24 90 00 00 00 48 D3 E0 48 85 C7 0F 95 C1 88 4C 24 78 45 84 D2 74 0B 48 FF C8 44 8A E3 48 85 C7 74 03 45 8A E7 84 C9 75 05 45 84 E4 74 39 E8 ?? ?? ?? ?? 85 C0 74 1C 3D 00 01 00 00 74 10 3D 00 02 00 00 75 22 40 84 ED 41 0F 94 C7 EB 1C 44 8A FD EB 17 38 5C 24 78 74 0E 45 84 E4 75 0C 38 9C 24 90 00 00 00 75 03 44 8A FB 41 8B CD 41 0F B6 C7 48 D3 EF 49 BC 00 00 80 FF FF FF 0F 00 48 03 F8 41 8A 56 08 8A C2 F6 D8 48 B8 00 00 00 FF FF FF 1F 00 48 1B C9 48 23 C8 48 81 C1 FF FF FF 00 48 3B F9 76 25 48 D1 EF 8A C2 FF C6 F6 D8 1B C9 81 E1 80 03 00 00 83 C1 7F 3B F1 7E 0D E9 6A FD FF FF 7E 06 41 8B CD 48 D3 E7 8A C2 F6 D8 48 1B C9 49 23 CC 48 81 C1 FF FF 7F 00 48 23 F9 84 D2 49 8B 16 74 30 8D 8E FF 03 00 00 40 0F B6 C5 81 E1 FF 07 00 00 48 C1 E0 0B 48 0B C8 48 B8 FF FF FF FF FF FF 0F 00 48 23 F8 48 C1 E1 34 48 0B CF 48 89 0A EB 1F 8D 4E 7F 40 0F B6 C5 C1 E1 17 81 E7 FF FF 7F 00 81 E1 00 00 80 7F C1 E0 1F 0B C8 0B CF 89 0A 33 C0 48 8B 9C 24 80 00 00 00 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_0_72_0 {
	meta:
		name = "?assemble_floating_point_value_from_big_integer@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUbig_integer@1@I_N1AEBVfloating_point_value@1@@Z"
		size = 380
		refs = "0178 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 8B 74 24 50 44 8B DA 41 BC 01 00 00 00 45 8A F1 41 8A E8 4C 8B D1 8A 46 08 F6 D8 41 8D 5C 24 3F 1B D2 83 E2 1D 83 C2 18 41 2B D4 44 3B DB 77 32 83 39 00 76 06 44 8B 41 04 EB 03 45 33 C0 44 39 21 76 05 8B 41 08 EB 02 33 C0 45 84 F6 8B C8 41 8B C0 41 0F 94 C1 48 C1 E1 20 48 03 C8 E9 DC 00 00 00 45 8B CB 41 C1 EB 05 45 8D 7B FF 45 8D 43 FE 41 83 E1 1F 75 46 42 8B 7C B9 04 41 8B D8 42 8B 4C 81 04 C1 E3 05 48 C1 E7 20 03 DA 48 03 F9 45 84 F6 41 0F 94 C1 45 33 DB 45 85 C0 74 14 43 83 7C 9A 04 00 0F 94 C0 45 03 DC 44 22 C8 45 3B D8 75 EC 8B D3 48 8B CF E9 81 00 00 00 47 8B 7C BA 04 41 8B FC 47 8B 6C 82 04 41 2B D9 41 8B C9 D3 E7 41 2B FC 45 8B E0 41 C1 E4 05 8D 4B E0 49 D3 E7 45 03 E1 44 03 E2 8B C7 43 8B 54 9A 04 8B CB 48 23 D0 48 D3 E2 41 8B C9 4C 03 FA 8B D7 F7 D2 49 23 D5 48 D3 EA 4C 03 FA 45 84 F6 75 0A 44 85 EF 75 05 41 B1 01 EB 03 45 32 C9 45 33 DB 45 85 C0 74 14 43 83 7C 9A 04 00 0F 94 C0 41 FF C3 44 22 C8 45 3B D8 75 EC 41 8B D4 49 8B CF 44 8A C5 48 89 74 24 50 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 41 5F 41 5E 41 5D 41 5C 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_73_0 {
	meta:
		name = "?assemble_floating_point_zero@__crt_strtox@@YAX_NAEBVfloating_point_value@1@@Z"
		size = 40
	strings:
		$1 = { 48 8B 02 45 33 C0 44 38 42 08 74 0E 84 C9 41 0F 95 C0 49 C1 E0 3F 4C 89 00 C3 84 C9 41 0F 95 C0 41 C1 E0 1F 44 89 00 C3 }
	condition:
		$1
}

rule file_0_74_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAIAEBUbig_integer@1@@Z"
		size = 35
	strings:
		$1 = { 4C 8B C1 8B 09 85 C9 75 03 33 C0 C3 FF C9 33 D2 45 0F BD 4C 88 04 74 04 41 8D 51 01 C1 E1 05 8D 04 0A C3 }
	condition:
		$1
}

rule file_0_75_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAII@Z"
		size = 19
	strings:
		$1 = { 0F BD C1 C7 44 24 10 00 00 00 00 74 03 FF C0 C3 33 C0 C3 }
	condition:
		$1
}

rule file_0_76_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAI_K@Z"
		size = 39
	strings:
		$1 = { B8 FF FF FF FF 48 3B C8 76 12 48 C1 E9 20 33 C0 0F BD D1 74 03 8D 42 01 83 C0 20 C3 33 C0 0F BD D1 74 03 8D 42 01 C3 }
	condition:
		$1
}

rule file_0_77_0 {
	meta:
		name = "?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
		size = 7587
		refs = "0022 __security_cookie 0036 __ImageBase 020d ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 0234 memset 024e ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 0264 memcpy 036c _errno 0377 _invalid_parameter_noinfo 05e4 ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 0d02 memcpy_s 1898 ?as_double@floating_point_value@__crt_strtox@@QEBAAEANXZ 18ac ?as_float@floating_point_value@__crt_strtox@@QEBAAEAMXZ 1c81 ?divide@__crt_strtox@@YA_KAEAUbig_integer@1@AEBU21@@Z 1d48 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1AEBVfloating_point_value@1@@Z 1d75 ?assemble_floating_point_value_from_big_integer@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUbig_integer@1@I_N1AEBVfloating_point_value@1@@Z 1d84 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 90 F5 FF FF 48 81 EC 70 0B 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 0A 00 00 44 8B 11 4C 8D 1D ?? ?? ?? ?? 8A 42 08 F6 D8 48 89 4C 24 58 48 89 54 24 60 48 8B D1 8B 49 04 1B C0 83 E0 1D 45 33 F6 83 C0 19 44 89 B5 50 01 00 00 45 85 D2 89 44 24 54 8B C1 4C 8D 4A 08 45 0F 48 D6 41 8D 5E 26 44 3B D1 45 8B FE 45 8B E6 45 8B EE 41 0F 42 C2 44 2B D0 4C 03 C8 48 8D 42 08 44 89 54 24 50 48 03 C1 4C 89 4C 24 78 8B C8 48 89 44 24 70 41 2B C9 4C 8D 52 08 89 4C 24 34 4D 3B D1 0F 84 3A 06 00 00 41 83 FD 09 0F 85 F2 00 00 00 45 85 FF 74 7A 45 8B C6 45 8B CE 41 8B D1 41 FF C1 8B 84 95 54 01 00 00 48 69 C8 00 CA 9A 3B 41 8B C0 48 03 C8 4C 8B C1 89 8C 95 54 01 00 00 49 C1 E8 20 45 3B CF 75 D3 4C 8B 4C 24 78 45 85 C0 74 36 83 BD 50 01 00 00 73 73 21 8B 85 50 01 00 00 44 89 84 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 44 89 BD 50 01 00 00 EB 13 45 8B FE 44 89 B5 50 01 00 00 EB 07 44 8B BD 50 01 00 00 45 85 E4 74 68 45 8B C6 45 85 FF 74 2D 41 8B D0 41 FF C0 41 8B C4 8B 8C 95 54 01 00 00 48 03 C8 4C 8B E1 89 8C 95 54 01 00 00 44 8B BD 50 01 00 00 49 C1 EC 20 45 3B C7 75 D3 45 85 E4 74 2E 41 83 FF 73 73 1E 41 8B C7 44 89 A4 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 44 89 BD 50 01 00 00 EB 0A 45 8B FE 44 89 B5 50 01 00 00 45 8B E6 45 8B EE 41 0F B6 02 43 8D 0C A4 41 FF C5 49 FF C2 44 8D 24 48 4D 3B D1 0F 85 E9 FE FF FF 45 85 ED 0F 84 1A 05 00 00 B8 CD CC CC CC 41 F7 E5 8B C2 C1 E8 03 89 44 24 38 8B C8 89 44 24 3C 85 C0 0F 84 D7 03 00 00 3B CB 8B C1 0F 47 C3 33 D2 89 44 24 44 FF C8 8B F8 41 0F B6 8C 83 ?? ?? ?? ?? 41 0F B6 B4 83 ?? ?? ?? ?? 8B D9 48 C1 E3 02 4C 8B C3 8D 04 0E 48 8D 8D C4 06 00 00 89 85 C0 06 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 C1 E6 02 0F B7 84 B9 ?? ?? ?? ?? 48 8D 91 ?? ?? ?? ?? 48 8D 8D C4 06 00 00 4C 8B C6 48 03 CB 48 8D 14 82 E8 ?? ?? ?? ?? 8B BD C0 06 00 00 83 FF 01 0F 87 A6 00 00 00 8B 85 C4 06 00 00 85 C0 75 0F 45 8B FE 44 89 B5 50 01 00 00 E9 15 03 00 00 83 F8 01 0F 84 0C 03 00 00 45 85 FF 0F 84 03 03 00 00 45 8B C6 45 8B CE 4C 8B D0 41 8B D1 41 FF C1 41 8B C0 8B 8C 95 54 01 00 00 49 0F AF CA 48 03 C8 4C 8B C1 89 8C 95 54 01 00 00 49 C1 E8 20 45 3B CF 75 D6 45 85 C0 0F 84 C0 02 00 00 83 BD 50 01 00 00 73 73 24 8B 85 50 01 00 00 44 89 84 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 44 89 BD 50 01 00 00 E9 9A 02 00 00 45 8B FE 44 89 B5 50 01 00 00 41 8A C6 E9 8A 02 00 00 41 83 FF 01 0F 87 AD 00 00 00 8B 9D 54 01 00 00 4C 8B C7 49 C1 E0 02 44 8B FF 89 BD 50 01 00 00 4D 85 C0 74 40 B8 CC 01 00 00 48 8D 8D 54 01 00 00 4C 3B C0 77 0E 48 8D 95 C4 06 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 50 01 00 00 85 DB 0F 84 F7 FE FF FF 83 FB 01 0F 84 12 02 00 00 45 85 FF 0F 84 09 02 00 00 45 8B C6 45 8B CE 4C 8B D3 41 8B D1 41 FF C1 41 8B C0 8B 8C 95 54 01 00 00 49 0F AF CA 48 03 C8 4C 8B C1 89 8C 95 54 01 00 00 49 C1 E8 20 45 3B CF 75 D6 E9 01 FF FF FF 41 3B FF 44 89 B5 F0 04 00 00 48 8D 95 54 01 00 00 45 8B D6 0F 92 C0 4C 8D 85 C4 06 00 00 84 C0 48 8D 8D C4 06 00 00 48 0F 44 CA 48 8D 95 54 01 00 00 49 0F 44 D0 48 89 4C 24 68 45 8B C7 48 89 54 24 48 44 0F 45 C7 41 0F 45 FF 44 89 44 24 40 45 8B FE 45 85 C0 0F 84 22 01 00 00 41 8B C2 8B 34 81 85 F6 75 21 45 3B D7 0F 85 03 01 00 00 45 8D 7A 01 44 89 B4 85 F4 04 00 00 44 89 BD F0 04 00 00 E9 EB 00 00 00 41 8B DE 45 8B CA 85 FF 0F 84 C9 00 00 00 45 8B DA 41 F7 DB 41 83 F9 73 74 66 45 3B CF 75 1B 41 8B C1 41 8D 4A 01 44 89 B4 85 F4 04 00 00 43 8D 04 0B 03 C8 89 8D F0 04 00 00 43 8D 04 0B 45 8B C1 8B 14 82 41 FF C1 8B C3 48 0F AF D6 48 03 D0 42 8B 84 85 F4 04 00 00 48 03 D0 43 8D 04 0B 48 8B DA 42 89 94 85 F4 04 00 00 44 8B BD F0 04 00 00 48 C1 EB 20 3B C7 74 07 48 8B 54 24 48 EB 94 85 DB 74 4E 41 83 F9 73 0F 84 03 01 00 00 45 3B CF 75 15 41 8B C1 44 89 B4 85 F4 04 00 00 41 8D 41 01 89 85 F0 04 00 00 41 8B C9 41 FF C1 8B D3 8B 84 8D F4 04 00 00 48 03 D0 89 94 8D F4 04 00 00 44 8B BD F0 04 00 00 48 C1 EA 20 8B DA 85 D2 75 B2 44 8B 44 24 40 41 83 F9 73 0F 84 B0 00 00 00 48 8B 4C 24 68 48 8B 54 24 48 41 FF C2 45 3B D0 0F 85 DE FE FF FF 45 8B C7 49 C1 E0 02 44 89 BD 50 01 00 00 4D 85 C0 74 40 B8 CC 01 00 00 48 8D 8D 54 01 00 00 4C 3B C0 77 0E 48 8D 95 F4 04 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 50 01 00 00 B0 01 84 C0 74 41 8B 4C 24 3C 4C 8D 1D ?? ?? ?? ?? 2B 4C 24 44 89 4C 24 3C 74 0A BB 26 00 00 00 E9 2D FC FF FF 8B 44 24 38 8D 04 80 03 C0 44 2B E8 0F 84 8F 00 00 00 41 8D 45 FF 41 8B 84 83 ?? ?? ?? ?? 85 C0 75 0C 45 8B FE 44 89 B5 50 01 00 00 EB 73 83 F8 01 74 6E 45 85 FF 74 69 45 8B C6 45 8B CE 4C 8B D0 41 8B D1 41 FF C1 41 8B C0 8B 8C 95 54 01 00 00 49 0F AF CA 48 03 C8 4C 8B C1 89 8C 95 54 01 00 00 49 C1 E8 20 45 3B CF 75 D6 45 85 C0 74 2A 83 BD 50 01 00 00 73 73 A9 8B 85 50 01 00 00 44 89 84 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 44 89 BD 50 01 00 00 EB 07 44 8B BD 50 01 00 00 45 85 E4 74 76 45 8B C6 45 85 FF 74 2D 41 8B C8 41 FF C0 41 8B C4 8B 94 8D 54 01 00 00 48 03 D0 89 94 8D 54 01 00 00 44 8B BD 50 01 00 00 48 C1 EA 20 44 8B E2 45 3B C7 75 D3 45 85 E4 74 3C 4C 8D 1D ?? ?? ?? ?? BB 26 00 00 00 41 83 FF 73 73 1E 41 8B C7 44 89 A4 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 44 89 BD 50 01 00 00 EB 18 45 8B FE 44 89 B5 50 01 00 00 EB 0C BB 26 00 00 00 4C 8D 1D ?? ?? ?? ?? 8B 4C 24 50 85 C9 0F 84 02 05 00 00 B8 CD CC CC CC F7 E1 8B C2 C1 E8 03 89 44 24 44 44 8B E0 89 44 24 40 85 C0 0F 84 E4 03 00 00 EB 07 4C 8D 1D ?? ?? ?? ?? 44 3B E3 45 8B EC 44 0F 47 EB 33 D2 44 89 6C 24 38 41 8D 45 FF 41 0F B6 8C 83 ?? ?? ?? ?? 41 0F B6 B4 83 ?? ?? ?? ?? 8B D9 8B F8 48 C1 E3 02 4C 8B C3 8D 04 0E 48 8D 8D C4 06 00 00 89 85 C0 06 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 C1 E6 02 0F B7 84 B9 ?? ?? ?? ?? 48 8D 91 ?? ?? ?? ?? 48 8D 8D C4 06 00 00 4C 8B C6 48 03 CB 48 8D 14 82 E8 ?? ?? ?? ?? 8B BD C0 06 00 00 83 FF 01 0F 87 AE 00 00 00 8B 85 C4 06 00 00 85 C0 75 0F 45 8B FE 44 89 B5 50 01 00 00 E9 17 03 00 00 83 F8 01 0F 84 0E 03 00 00 45 85 FF 0F 84 05 03 00 00 45 8B C6 45 8B CE 4C 8B D0 41 8B D1 41 FF C1 41 8B C0 8B 8C 95 54 01 00 00 49 0F AF CA 48 03 C8 4C 8B C1 89 8C 95 54 01 00 00 49 C1 E8 20 45 3B CF 75 D6 45 85 C0 74 3F 83 BD 50 01 00 00 73 73 24 8B 85 50 01 00 00 44 89 84 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 44 89 BD 50 01 00 00 E9 A0 02 00 00 45 8B FE 44 89 B5 50 01 00 00 41 8A C6 E9 90 02 00 00 44 8B BD 50 01 00 00 E9 82 02 00 00 41 83 FF 01 0F 87 AD 00 00 00 8B 9D 54 01 00 00 4C 8B C7 49 C1 E0 02 44 8B FF 89 BD 50 01 00 00 4D 85 C0 74 40 B8 CC 01 00 00 48 8D 8D 54 01 00 00 4C 3B C0 77 0E 48 8D 95 C4 06 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 50 01 00 00 85 DB 0F 84 EF FE FF FF 83 FB 01 0F 84 0C 02 00 00 45 85 FF 0F 84 03 02 00 00 45 8B C6 45 8B CE 4C 8B D3 41 8B D1 41 FF C1 41 8B C0 8B 8C 95 54 01 00 00 49 0F AF CA 48 03 C8 4C 8B C1 89 8C 95 54 01 00 00 49 C1 E8 20 45 3B CF 75 D6 E9 F9 FE FF FF 41 3B FF 44 89 B5 F0 04 00 00 48 8D 8D 54 01 00 00 45 8B E7 0F 92 C0 4C 8D AD C4 06 00 00 84 C0 48 8D 95 54 01 00 00 45 8B D6 4C 0F 44 E9 44 0F 45 E7 41 0F 45 FF 48 8D 8D C4 06 00 00 48 0F 44 D1 45 8B FE 48 89 54 24 48 45 85 E4 0F 84 1C 01 00 00 41 8B C2 41 8B 74 85 00 85 F6 75 21 45 3B D7 0F 85 FB 00 00 00 45 8D 7A 01 44 89 B4 85 F4 04 00 00 44 89 BD F0 04 00 00 E9 E3 00 00 00 41 8B DE 45 8B CA 85 FF 0F 84 C6 00 00 00 45 8B DA 41 F7 DB 41 83 F9 73 74 68 45 3B CF 75 1B 41 8B C1 41 8D 4B 01 44 89 B4 85 F4 04 00 00 43 8D 04 11 03 C8 89 8D F0 04 00 00 43 8D 04 19 45 8B C1 8B 14 82 41 FF C1 48 0F AF D6 8B C8 8B C3 48 03 D0 42 8B 84 85 F4 04 00 00 48 03 D0 43 8D 04 19 48 8B DA 42 89 94 85 F4 04 00 00 44 8B BD F0 04 00 00 48 C1 EB 20 3B C7 74 07 48 8B 54 24 48 EB 92 85 DB 74 4E 41 83 F9 73 0F 84 85 01 00 00 45 3B CF 75 15 41 8B C1 44 89 B4 85 F4 04 00 00 41 8D 41 01 89 85 F0 04 00 00 41 8B C9 41 FF C1 8B D3 8B 84 8D F4 04 00 00 48 03 D0 89 94 8D F4 04 00 00 44 8B BD F0 04 00 00 48 C1 EA 20 8B DA 85 D2 75 B2 41 83 F9 73 0F 84 37 01 00 00 48 8B 54 24 48 41 FF C2 45 3B D4 0F 85 E4 FE FF FF 45 8B C7 49 C1 E0 02 44 89 BD 50 01 00 00 4D 85 C0 74 40 B8 CC 01 00 00 48 8D 8D 54 01 00 00 4C 3B C0 77 0E 48 8D 95 F4 04 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 50 01 00 00 44 8B 64 24 40 44 8B 6C 24 38 B0 01 84 C0 0F 84 BF 00 00 00 45 2B E5 BB 26 00 00 00 44 89 64 24 40 0F 85 26 FC FF FF 8B 44 24 44 8B 4C 24 50 8D 04 80 03 C0 2B C8 0F 84 F2 00 00 00 FF C9 48 8D 05 ?? ?? ?? ?? 8B 84 88 ?? ?? ?? ?? 85 C0 75 0F 45 8B FE 44 89 B5 50 01 00 00 E9 D4 00 00 00 83 F8 01 0F 84 C6 00 00 00 45 85 FF 0F 84 C2 00 00 00 45 8B C6 45 8B CE 4C 8B D0 41 8B D1 41 FF C1 41 8B C0 8B 8C 95 54 01 00 00 49 0F AF CA 48 03 C8 4C 8B C1 89 8C 95 54 01 00 00 49 C1 E8 20 45 3B CF 75 D6 45 85 C0 74 7E 83 BD 50 01 00 00 73 73 21 8B 85 50 01 00 00 44 89 84 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 44 89 BD 50 01 00 00 EB 5B 48 8B 44 24 60 4C 8B 44 24 58 44 38 70 08 48 8B 00 41 8A 88 08 03 00 00 74 1C 84 C9 48 B9 00 00 00 00 00 00 F0 7F 41 0F 95 C6 49 C1 E6 3F 4C 0B F1 4C 89 30 EB 14 84 C9 41 0F 95 C6 41 C1 E6 1F 41 81 CE 00 00 80 7F 44 89 30 B8 03 00 00 00 E9 80 11 00 00 44 8B BD 50 01 00 00 45 85 FF 75 05 41 8B CE EB 1F 41 8D 4F FF 44 89 74 24 48 0F BD 84 8D 54 01 00 00 74 04 FF C0 EB 03 41 8B C6 C1 E1 05 03 C8 44 8B 4C 24 34 89 4C 24 40 3B 4C 24 54 0F 83 12 11 00 00 45 85 C9 0F 84 0C 11 00 00 48 8B 5C 24 78 45 8B EE 48 8B 7C 24 70 45 8B E6 44 89 B5 20 03 00 00 45 8B C6 48 3B DF 0F 84 8F 06 00 00 41 83 F8 09 0F 85 34 01 00 00 45 85 ED 0F 84 92 00 00 00 45 8B C6 45 8B CE 41 8B D1 41 FF C1 8B 84 95 24 03 00 00 48 69 C8 00 CA 9A 3B 41 8B C0 48 03 C8 4C 8B C1 89 8C 95 24 03 00 00 49 C1 E8 20 45 3B CD 75 D3 45 85 C0 74 53 83 BD 20 03 00 00 73 73 21 8B 85 20 03 00 00 44 89 84 85 24 03 00 00 44 8B AD 20 03 00 00 41 FF C5 44 89 AD 20 03 00 00 EB 30 45 33 C9 44 89 B5 90 08 00 00 4C 8D 85 94 08 00 00 44 89 B5 20 03 00 00 BA CC 01 00 00 48 8D 8D 24 03 00 00 E8 ?? ?? ?? ?? 44 8B AD 20 03 00 00 45 85 E4 0F 84 8A 00 00 00 41 8B D6 45 85 ED 74 29 8B CA FF C2 45 8B E4 8B 84 8D 24 03 00 00 4C 03 E0 44 89 A4 8D 24 03 00 00 44 8B AD 20 03 00 00 49 C1 EC 20 41 3B D5 75 D7 45 85 E4 74 54 41 83 FD 73 73 1E 41 8B C5 44 89 A4 85 24 03 00 00 44 8B AD 20 03 00 00 41 FF C5 44 89 AD 20 03 00 00 EB 30 45 33 C9 44 89 B5 90 08 00 00 4C 8D 85 94 08 00 00 44 89 B5 20 03 00 00 BA CC 01 00 00 48 8D 8D 24 03 00 00 E8 ?? ?? ?? ?? 44 8B AD 20 03 00 00 45 8B E6 45 8B C6 0F B6 03 43 8D 0C A4 41 FF C0 48 FF C3 44 8D 24 48 48 3B DF 0F 85 A8 FE FF FF 44 89 44 24 44 45 85 C0 0F 84 24 05 00 00 B8 CD CC CC CC 41 F7 E0 8B C2 C1 E8 03 89 44 24 48 8B C8 89 44 24 50 85 C0 0F 84 66 03 00 00 8B C1 BA 26 00 00 00 3B CA 0F 47 C2 33 D2 89 44 24 38 8D 78 FF 48 8D 05 ?? ?? ?? ?? 0F B6 8C B8 ?? ?? ?? ?? 0F B6 B4 B8 ?? ?? ?? ?? 8B D9 48 C1 E3 02 4C 8B C3 8D 04 0E 48 8D 8D C4 06 00 00 89 85 C0 06 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 C1 E6 02 0F B7 84 B9 ?? ?? ?? ?? 48 8D 91 ?? ?? ?? ?? 48 8D 8D C4 06 00 00 4C 8B C6 48 03 CB 48 8D 14 82 E8 ?? ?? ?? ?? 8B BD C0 06 00 00 83 FF 01 0F 87 A6 00 00 00 8B 85 C4 06 00 00 85 C0 75 1D 44 89 B5 90 08 00 00 4C 8D 85 94 08 00 00 44 89 B5 20 03 00 00 45 33 C9 E9 79 02 00 00 83 F8 01 0F 84 88 02 00 00 45 85 ED 0F 84 7F 02 00 00 45 8B C6 45 8B CE 4C 8B D0 41 8B D1 41 FF C1 41 8B C0 8B 8C 95 24 03 00 00 49 0F AF CA 48 03 C8 4C 8B C1 89 8C 95 24 03 00 00 49 C1 E8 20 45 3B CD 75 D6 45 85 C0 0F 84 3C 02 00 00 83 BD 20 03 00 00 73 0F 83 FB 02 00 00 8B 85 20 03 00 00 44 89 84 85 24 03 00 00 44 8B AD 20 03 00 00 41 FF C5 44 89 AD 20 03 00 00 E9 12 02 00 00 4C 8D 85 C4 06 00 00 48 8D 8D 24 03 00 00 41 83 FD 01 77 76 8B 9D 24 03 00 00 4C 8B CF 49 C1 E1 02 BA CC 01 00 00 89 BD 20 03 00 00 E8 ?? ?? ?? ?? 85 DB 0F 84 2B FF FF FF 44 8B AD 20 03 00 00 83 FB 01 0F 84 C9 01 00 00 45 85 ED 0F 84 C0 01 00 00 45 8B C6 45 8B CE 44 8B D3 41 8B D1 41 FF C1 41 8B C0 8B 8C 95 24 03 00 00 49 0F AF CA 48 03 C8 4C 8B C1 89 8C 95 24 03 00 00 49 C1 E8 20 45 3B CD 75 D6 E9 3C FF FF FF 41 3B FD 48 8D 95 C4 06 00 00 45 8B D6 0F 92 C0 84 C0 41 8B C6 89 85 F0 04 00 00 48 0F 44 D1 48 8D 8D 24 03 00 00 49 0F 44 C8 48 89 54 24 68 45 8B C5 44 0F 45 C7 41 0F 45 FD 44 89 44 24 3C 45 85 C0 0F 84 14 01 00 00 4C 8B E9 41 8B CA 8B 34 8A 85 F6 75 20 44 3B D0 0F 85 }
	condition:
		$1
}

rule file_0_78_0 {
	meta:
		name = "?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
		size = 175
		refs = "00a0 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 44 8A 4A 08 4C 8B D9 41 8A C1 33 C9 F6 D8 48 8B FA 41 8B 1B 4D 8D 53 08 41 8B 43 04 49 8D 53 08 45 1B C0 FF CB 41 83 E0 1D 4C 03 D0 41 83 C0 18 41 03 D8 49 3B D2 74 34 41 F6 D9 48 B8 00 00 00 FF FF FF 1F 00 4D 1B C0 4C 23 C0 49 81 C0 FF FF FF 00 49 3B C8 77 15 0F B6 02 83 EB 04 48 C1 E1 04 48 FF C2 48 03 C8 49 3B D2 75 E6 41 B1 01 EB 11 45 84 C9 74 11 8A 02 48 FF C2 84 C0 74 ED 45 32 C9 49 3B D2 75 EA 45 8A 83 08 03 00 00 8B D3 48 89 7C 24 20 E8 ?? ?? ?? ?? 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_0_79_0 {
	meta:
		name = "?count_sequential_high_zeroes@__crt_strtox@@YAII@Z"
		size = 19
	strings:
		$1 = { 0F BD D1 74 08 B8 1F 00 00 00 2B C2 C3 B8 20 00 00 00 C3 }
	condition:
		$1
}

rule file_0_80_0 {
	meta:
		name = "?denormal_mantissa_mask@floating_point_value@__crt_strtox@@QEBA_KXZ"
		size = 28
	strings:
		$1 = { 8A 41 08 48 B9 00 00 80 FF FF FF 0F 00 F6 D8 48 1B C0 48 23 C1 48 05 FF FF 7F 00 C3 }
	condition:
		$1
}

rule file_0_81_0 {
	meta:
		name = "?divide@__crt_strtox@@YA_KAEAUbig_integer@1@AEBU21@@Z"
		size = 1229
		refs = "008c memcpy_s"
	strings:
		$1 = { 48 89 54 24 10 56 57 48 81 EC 48 02 00 00 44 8B 09 48 8B FA 48 8B F1 45 85 C9 75 0C 33 C0 48 81 C4 48 02 00 00 5F 5E C3 8B 02 85 C0 74 EE 48 89 9C 24 40 02 00 00 41 FF C9 48 89 AC 24 38 02 00 00 4C 89 A4 24 30 02 00 00 4C 89 B4 24 20 02 00 00 4C 89 BC 24 18 02 00 00 83 E8 01 0F 85 F2 00 00 00 44 8B 7A 04 45 33 F6 41 83 FF 01 75 28 8B 59 04 4C 8D 44 24 44 48 83 C1 04 44 89 36 45 33 C9 44 89 74 24 40 BA CC 01 00 00 E8 ?? ?? ?? ?? 8B C3 E9 04 04 00 00 45 85 C9 75 39 8B 59 04 4C 8D 44 24 44 44 89 31 45 33 C9 48 83 C1 04 44 89 74 24 40 BA CC 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B C3 41 F7 F7 85 D2 89 56 04 41 0F 95 C6 44 89 36 E9 C6 03 00 00 41 BC FF FF FF FF 49 8B FE 49 8B EE 45 3B CC 74 2F 49 8B CF 0F 1F 80 00 00 00 00 42 8B 44 8E 04 33 D2 48 C1 E5 20 45 03 CC 48 0B C5 48 C1 E7 20 48 F7 F1 8B C0 48 8B EA 48 03 F8 45 3B CC 75 DB 45 33 C9 44 89 74 24 40 4C 8D 44 24 44 44 89 36 BA CC 01 00 00 48 8D 4E 04 E8 ?? ?? ?? ?? 48 8B CD 89 6E 04 48 C1 E9 20 48 8B C7 85 C9 89 4E 08 41 0F 95 C6 41 FF C6 44 89 36 E9 47 03 00 00 41 3B C1 76 07 33 C0 E9 3B 03 00 00 45 8B C1 49 63 D1 44 2B C0 4C 89 AC 24 28 02 00 00 49 63 D8 44 8D 68 01 45 8B D1 48 3B D3 7C 4F 48 83 C1 04 48 8D 04 9D 00 00 00 00 4C 8B DF 4C 2B D8 4C 2B DE 48 8D 0C 91 0F 1F 80 00 00 00 00 8B 01 41 39 04 0B 75 11 41 FF CA 48 FF CA 48 83 E9 04 48 3B D3 7D E9 EB 16 41 8B C2 41 2B C0 48 63 D0 49 63 C2 8B 4C 86 04 39 4C 97 04 73 03 41 FF C0 45 85 C0 75 07 33 C0 E9 B5 02 00 00 41 8D 45 FF 41 BB 20 00 00 00 44 8B 54 87 04 41 8D 45 FE 8B 5C 87 04 41 0F BD C2 89 9C 24 78 02 00 00 74 09 BA 1F 00 00 00 2B D0 EB 03 41 8B D3 44 2B DA 89 94 24 70 02 00 00 44 89 5C 24 20 85 D2 74 40 41 8B C2 8B D3 41 8B CB D3 EA 8B 8C 24 70 02 00 00 44 8B D2 D3 E0 8B D1 D3 E3 44 0B D0 89 9C 24 78 02 00 00 41 83 FD 02 76 16 41 8D 45 FD 41 8B CB 8B 44 87 04 D3 E8 0B D8 89 9C 24 78 02 00 00 45 33 F6 41 8D 58 FF 89 9C 24 60 02 00 00 45 8B FE 41 BC FF FF FF FF 85 DB 0F 88 D6 01 00 00 41 8B C3 42 8D 3C 2B 45 8B DA 4C 89 5C 24 30 48 89 44 24 38 41 3B F9 77 06 8B 6C BE 04 EB 03 41 8B EE 8D 47 FF 8B 4C 86 04 8D 47 FE 44 8B 54 86 04 48 89 4C 24 28 89 6C 24 2C 85 D2 74 32 48 8B 4C 24 38 45 8B C2 48 8B 44 24 28 49 D3 E8 8B CA 48 D3 E0 4C 0B C0 41 D3 E2 83 FF 03 72 17 8B 4C 24 20 8D 47 FD 8B 44 86 04 D3 E8 44 0B D0 EB 05 4C 8B 44 24 28 33 D2 49 8B C0 49 F7 F3 8B CA 4C 8B C0 49 3B C4 76 17 48 B8 01 00 00 00 FF FF FF FF 49 03 C0 4D 8B C4 49 0F AF C3 48 03 C8 49 3B CC 77 41 48 8B 5C 24 30 45 8B DA 44 8B 94 24 78 02 00 00 41 8B D2 49 0F AF D0 49 F7 DA 0F 1F 00 48 8B C1 48 C1 E0 20 49 0B C3 48 3B D0 76 0E 49 FF C8 49 03 D2 48 03 CB 49 3B CC 76 E3 8B 9C 24 60 02 00 00 4D 85 C0 0F 84 C0 00 00 00 49 8B CE 45 85 ED 74 58 4C 8B 8C 24 68 02 00 00 8B D3 49 83 C1 04 41 8B DD 66 66 0F 1F 84 00 00 00 00 00 41 8B 01 49 0F AF C0 48 03 C8 8B C2 44 8B D1 48 C1 E9 20 4C 8D 1C 86 8B 44 86 04 41 3B C2 73 03 48 FF C1 41 2B C2 FF C2 49 83 C1 04 41 89 43 04 48 83 EB 01 75 CA 8B 9C 24 60 02 00 00 8B C5 48 3B C1 73 4E 45 8B CE 45 85 ED 74 43 4C 8B 9C 24 68 02 00 00 44 8B D3 49 83 C3 04 41 8B DD 66 90 41 8B C2 4D 8D 5B 04 8B 54 86 04 48 8D 0C 86 41 8B 43 FC 41 FF C2 48 03 D0 41 8B C1 48 03 D0 4C 8B CA 89 51 04 49 C1 E9 20 48 83 EB 01 75 D1 49 FF C8 8B 9C 24 60 02 00 00 44 8D 4F FF 4C 8B 5C 24 30 FF CB 8B 94 24 70 02 00 00 FF CF 49 C1 E7 20 41 8B C0 4C 03 F8 89 9C 24 60 02 00 00 85 DB 0F 89 3E FE FF FF 41 FF C1 41 8B C9 44 3B 0E 73 0D 8B C1 FF C1 44 89 74 86 04 3B 0E 72 F3 44 89 0E 45 85 C9 74 1A 66 66 0F 1F 84 00 00 00 00 00 8B 0E FF C9 44 39 74 8E 04 75 05 44 01 26 75 F0 49 8B C7 4C 8B AC 24 28 02 00 00 4C 8B B4 24 20 02 00 00 4C 8B A4 24 30 02 00 00 48 8B AC 24 38 02 00 00 48 8B 9C 24 40 02 00 00 4C 8B BC 24 18 02 00 00 48 81 C4 48 02 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_0_82_0 {
	meta:
		name = "?exponent_bias@floating_point_value@__crt_strtox@@QEBAHXZ"
		size = 16
		altNames = "?maximum_binary_exponent@floating_point_value@__crt_strtox@@QEBAHXZ"
	strings:
		$1 = { 8A 41 08 F6 D8 1B C0 25 80 03 00 00 83 C0 7F C3 }
	condition:
		$1
}

rule file_0_85_0 {
	meta:
		name = "?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
		size = 34
	strings:
		$1 = { 8D 41 D0 83 F8 09 77 03 B0 01 C3 8D 41 9F 83 F8 19 76 F5 8D 41 BF 83 F8 19 76 ED 83 F9 5F 0F 94 C0 C3 }
	condition:
		$1
}

rule file_0_87_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_NDQEAU__crt_locale_pointers@@@Z"
		size = 84
		refs = "0026 _isctype_l 0039 __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 0F B6 F9 48 85 D2 74 26 48 8B 02 83 78 08 01 7E 11 4C 8B C2 8B CF BA 08 00 00 00 E8 ?? ?? ?? ?? EB 18 48 8B 00 48 63 CF 0F B7 04 48 EB 09 E8 ?? ?? ?? ?? 0F B7 04 78 83 E0 08 48 8B 5C 24 30 85 C0 0F 95 C0 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_0_88_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_N_WPEAU__crt_locale_pointers@@@Z"
		size = 24
		refs = "000a iswctype"
	strings:
		$1 = { 48 83 EC 28 BA 08 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_0_89_0 {
	meta:
		name = "?make_big_integer@__crt_strtox@@YA?AUbig_integer@1@_K@Z"
		size = 25
	strings:
		$1 = { 33 C0 89 51 04 48 C1 EA 20 85 D2 89 51 08 0F 95 C0 FF C0 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_0_92_0 {
	meta:
		name = "?minimum_binary_exponent@floating_point_value@__crt_strtox@@QEBAHXZ"
		size = 16
	strings:
		$1 = { 8A 41 08 F6 D8 1B C0 25 80 FC FF FF 83 C0 82 C3 }
	condition:
		$1
}

rule file_0_93_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAEAUbig_integer@1@AEBU21@@Z"
		size = 876
		refs = "000e __security_cookie 004f memcpy_s 0356 __security_check_cookie"
	strings:
		$1 = { 40 53 56 57 48 81 EC 20 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 F0 01 00 00 48 8B F1 8B 0A 83 F9 01 0F 87 B8 00 00 00 8B 42 04 85 C0 75 28 45 33 D2 48 8D 4E 04 45 33 C9 44 89 54 24 20 4C 8D 44 24 24 44 89 16 BA CC 01 00 00 E8 ?? ?? ?? ?? B0 01 E9 F0 02 00 00 83 F8 01 74 F4 44 8B 1E 45 85 DB 74 EC 45 33 D2 48 8D 5E 04 45 8B C2 45 8B CA 48 8B F8 66 0F 1F 84 00 00 00 00 00 41 8B C1 41 FF C1 8B 14 83 48 8D 0C 83 41 8B C0 48 0F AF D7 48 03 D0 4C 8B C2 89 11 49 C1 E8 20 45 3B CB 75 DB 45 85 C0 74 A9 8B 06 83 F8 73 73 0E 44 89 44 86 04 B0 01 FF 06 E9 8B 02 00 00 45 33 C9 44 89 54 24 20 4C 8D 44 24 24 44 89 16 BA CC 01 00 00 48 8B CB E8 ?? ?? ?? ?? 32 C0 E9 67 02 00 00 4C 89 B4 24 08 02 00 00 44 8B 36 41 83 FE 01 0F 87 CB 00 00 00 8B 7E 04 48 8D 5E 04 89 0E 4C 8D 42 04 44 8B 0A 48 8B CB 49 C1 E1 02 BA CC 01 00 00 E8 ?? ?? ?? ?? 85 FF 75 27 45 33 D2 4C 8D 44 24 24 45 33 C9 44 89 54 24 20 BA CC 01 00 00 44 89 16 48 8B CB E8 ?? ?? ?? ?? B0 01 E9 FE 01 00 00 83 FF 01 74 F4 44 8B 1E 45 85 DB 74 EC 45 33 D2 45 8B C2 45 8B CA 66 0F 1F 44 00 00 41 8B C1 41 FF C1 8B 14 83 48 8D 0C 83 41 8B C0 48 0F AF D7 48 03 D0 4C 8B C2 89 11 49 C1 E8 20 45 3B CB 75 DB 45 85 C0 74 B3 8B 06 83 F8 73 73 0E 44 89 44 86 04 B0 01 FF 06 E9 A3 01 00 00 45 33 C9 44 89 54 24 20 4C 8D 44 24 24 44 89 16 BA CC 01 00 00 48 8B CB E8 ?? ?? ?? ?? 32 C0 E9 7F 01 00 00 41 3B CE 4C 89 A4 24 18 02 00 00 4C 89 AC 24 10 02 00 00 0F 92 C0 4C 89 BC 24 00 02 00 00 84 C0 48 8D 46 04 74 0C 4C 8D 6A 04 4C 8B F8 44 8B E1 EB 0D 45 8B E6 4C 8D 7A 04 44 8B F1 4C 8B E8 45 33 D2 48 89 AC 24 50 02 00 00 41 8B CA 41 8B DA 89 4C 24 20 45 85 E4 0F 84 E4 00 00 00 8B C3 41 8B 6C 85 00 85 ED 75 19 3B D9 0F 85 C6 00 00 00 8D 4B 01 44 89 54 84 24 89 4C 24 20 E9 B5 00 00 00 45 8B DA 8B C3 45 85 F6 0F 84 A2 00 00 00 8B FB F7 DF 83 F8 73 74 51 3B C1 75 13 8B C8 8D 53 01 44 89 54 8C 24 8D 0C 07 03 D1 89 54 24 20 8B C8 4C 8D 4C 24 24 4D 8D 0C 89 8D 0C 07 FF C0 45 8B 04 8F 41 8B CB 4C 0F AF C5 4C 03 C1 41 8B 09 4C 03 C1 8D 0C 07 4D 8B D8 45 89 01 49 C1 EB 20 41 3B CE 8B 4C 24 20 75 AA 45 85 DB 74 43 83 F8 73 0F 84 AB 00 00 00 3B C1 75 0E 8B C8 44 89 54 8C 24 8D 48 01 89 4C 24 20 8B C8 48 8D 54 24 24 48 8D 14 8A 45 8B C3 8B 0A FF C0 4C 03 C1 44 89 02 8B 4C 24 20 49 C1 E8 20 45 8B D8 45 85 C0 75 BD 83 F8 73 74 6C FF C3 41 3B DC 0F 85 1C FF FF FF 44 8B C9 4C 8D 44 24 24 89 0E BA CC 01 00 00 49 C1 E1 02 48 8D 4E 04 E8 ?? ?? ?? ?? B0 01 48 8B AC 24 50 02 00 00 4C 8B AC 24 10 02 00 00 4C 8B A4 24 18 02 00 00 4C 8B BC 24 00 02 00 00 4C 8B B4 24 08 02 00 00 48 8B 8C 24 F0 01 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 20 02 00 00 5F 5E 5B C3 44 89 16 32 C0 EB B6 }
	condition:
		$1
}

rule file_0_94_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
		size = 253
		refs = "002b memcpy_s"
	strings:
		$1 = { 48 81 EC F8 01 00 00 4C 8B C1 85 D2 75 2B 45 33 D2 4C 8D 44 24 24 44 89 11 45 33 C9 48 83 C1 04 44 89 54 24 20 BA CC 01 00 00 E8 ?? ?? ?? ?? B0 01 48 81 C4 F8 01 00 00 C3 83 FA 01 74 F1 48 89 9C 24 00 02 00 00 8B 19 85 DB 75 12 B0 01 48 8B 9C 24 00 02 00 00 48 81 C4 F8 01 00 00 C3 48 89 B4 24 08 02 00 00 45 33 D2 48 89 BC 24 F0 01 00 00 45 8B CA 48 8D 79 04 8B F2 45 8B DA 0F 1F 00 41 8B C3 41 FF C3 8B 14 87 48 8D 0C 87 41 8B C1 48 0F AF D6 48 03 D0 4C 8B CA 89 11 49 C1 E9 20 44 3B DB 75 DB 48 8B B4 24 08 02 00 00 45 85 C9 74 10 41 8B 00 83 F8 73 73 22 45 89 4C 80 04 41 FF 00 B0 01 48 8B BC 24 F0 01 00 00 48 8B 9C 24 00 02 00 00 48 81 C4 F8 01 00 00 C3 45 89 10 45 33 C9 4C 8D 44 24 24 44 89 54 24 20 BA CC 01 00 00 48 8B CF E8 ?? ?? ?? ?? 32 C0 EB C7 }
	condition:
		$1
}

rule file_0_96_0 {
	meta:
		name = "?multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
		size = 1462
		refs = "0022 __security_cookie 003f __ImageBase 008a ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 00b2 memset 00ce ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 00d6 memcpy 017c memcpy_s 01b0 _errno 01ed _invalid_parameter_noinfo 04bb ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 04ee __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 10 FD FF FF 48 81 EC F0 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 E0 02 00 00 B8 CD CC CC CC 89 54 24 2C 44 8B C2 4C 8D 25 ?? ?? ?? ?? F7 E2 45 33 C9 4C 8B F1 8B C2 C1 E8 03 89 44 24 28 44 8B F8 89 44 24 20 85 C0 0F 84 46 04 00 00 B8 26 00 00 00 0F 1F 84 00 00 00 00 00 41 83 FF 26 45 8B EF 44 0F 47 E8 33 D2 44 89 6C 24 24 41 8D 45 FF 48 8D 3C 85 ?? ?? ?? ?? 42 0F B6 4C 27 02 42 0F B6 74 27 03 48 8D 1C 8D 00 00 00 00 8D 04 0E 4C 8B C3 48 8D 4C 24 44 89 44 24 40 E8 ?? ?? ?? ?? 42 0F B7 04 27 48 8D 4C 24 44 48 C1 E6 02 48 03 CB 4C 8B C6 48 8D 14 85 ?? ?? ?? ?? 49 03 D4 E8 ?? ?? ?? ?? 8B 4C 24 40 83 F9 01 0F 87 A0 00 00 00 8B 44 24 44 85 C0 75 0A 33 F6 41 89 36 E9 87 03 00 00 83 F8 01 0F 84 7E 03 00 00 45 8B 16 45 85 D2 0F 84 72 03 00 00 33 F6 4D 8D 5E 04 44 8B C6 44 8B CE 48 8B D8 0F 1F 00 41 8B C1 41 FF C1 41 8B 14 83 49 8D 0C 83 41 8B C0 48 0F AF D3 48 03 D0 4C 8B C2 89 11 49 C1 E8 20 45 3B CA 75 DA 45 85 C0 0F 84 31 03 00 00 41 8B 06 83 F8 73 73 0D 45 89 44 86 04 41 FF 06 E9 1C 03 00 00 45 33 C9 89 74 24 40 4C 8D 44 24 44 41 89 36 BA CC 01 00 00 49 8B CB E8 ?? ?? ?? ?? 32 C0 E9 FB 02 00 00 41 8B 36 83 FE 01 0F 87 13 01 00 00 41 8B 7E 04 49 8D 5E 04 4C 8B C1 41 89 0E 49 C1 E0 02 4D 85 C0 74 47 48 85 DB 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 30 48 8B CB 49 81 F8 CC 01 00 00 77 0C 48 8D 54 24 44 E8 ?? ?? ?? ?? EB 1D 33 D2 41 B8 CC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 85 FF 75 23 33 F6 4C 8D 44 24 44 45 33 C9 89 74 24 40 BA CC 01 00 00 41 89 36 48 8B CB E8 ?? ?? ?? ?? E9 68 02 00 00 83 FF 01 0F 84 5F 02 00 00 45 8B 16 45 85 D2 0F 84 53 02 00 00 33 F6 4C 8B DF 44 8B C6 44 8B CE 0F 1F 84 00 00 00 00 00 41 8B C1 41 FF C1 8B 14 83 48 8D 0C 83 41 8B C0 49 0F AF D3 48 03 D0 4C 8B C2 89 11 49 C1 E8 20 45 3B CA 75 DB 45 85 C0 0F 84 12 02 00 00 41 8B 06 83 F8 73 73 0D 45 89 44 86 04 41 FF 06 E9 FD 01 00 00 45 33 C9 89 74 24 40 4C 8D 44 24 44 41 89 36 BA CC 01 00 00 48 8B CB E8 ?? ?? ?? ?? 32 C0 E9 DC 01 00 00 3B CE 4D 8D 6E 04 0F 92 C0 84 C0 74 0D 48 8D 54 24 44 4D 8B FD 44 8B E1 EB 0D 44 8B E6 4C 8D 7C 24 44 8B F1 49 8B D5 45 33 C9 48 89 54 24 30 41 8B C9 41 8B D9 89 8D 10 01 00 00 45 85 E4 0F 84 15 01 00 00 66 0F 1F 44 00 00 8B C3 8B 3C 82 85 FF 75 1E 3B D9 0F 85 F3 00 00 00 8D 4B 01 44 89 8C 85 14 01 00 00 89 8D 10 01 00 00 E9 DD 00 00 00 45 8B D1 8B C3 85 F6 0F 84 C6 00 00 00 44 8B DB 41 F7 DB 66 0F 1F 44 00 00 83 F8 73 74 5F 3B C1 75 19 8B C8 8D 53 01 44 89 8C 8D 14 01 00 00 41 8D 0C 03 03 D1 89 95 10 01 00 00 8B C8 4C 8D 8D 14 01 00 00 4D 8D 0C 89 41 8D 0C 03 FF C0 45 8B 04 8F 41 8B 09 4C 0F AF C7 4C 03 C1 41 8B CA 4C 03 C1 41 8D 0C 03 45 89 01 4D 8B D0 49 C1 EA 20 45 33 C9 3B CE 8B 8D 10 01 00 00 75 9C 45 85 D2 74 51 0F 1F 80 00 00 00 00 83 F8 73 74 7B 3B C1 75 13 8B C8 44 89 8C 8D 14 01 00 00 8D 48 01 89 8D 10 01 00 00 8B C8 48 8D 95 14 01 00 00 44 8B 04 8A 48 8D 14 8A 41 8B CA FF C0 4C 03 C1 44 89 02 8B 8D 10 01 00 00 49 C1 E8 20 45 8B D0 45 85 C0 75 B6 83 F8 73 74 31 48 8B 54 24 30 FF C3 41 3B DC 0F 85 F1 FE FF FF 44 8B C1 49 C1 E0 02 41 89 0E 4D 85 C0 74 61 4D 85 ED 75 25 E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 4A 44 8B 7C 24 20 4C 8D 25 ?? ?? ?? ?? 44 8B 6C 24 24 32 C0 45 89 0E EB 4D 49 8B CD 49 81 F8 CC 01 00 00 77 0E 48 8D 95 14 01 00 00 E8 ?? ?? ?? ?? EB 1D 33 D2 41 B8 CC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B 7C 24 20 4C 8D 25 ?? ?? ?? ?? 44 8B 6C 24 24 B0 01 45 33 C9 84 C0 0F 84 80 00 00 00 45 2B FD B8 26 00 00 00 44 89 7C 24 20 0F 85 D0 FB FF FF 8B 44 24 28 44 8B 44 24 2C 8D 04 80 03 C0 44 2B C0 74 2E 41 8D 40 FF 41 8B 84 84 ?? ?? ?? ?? 85 C0 75 6C 44 89 4C 24 40 49 8D 4E 04 45 89 0E 4C 8D 44 24 44 45 33 C9 BA CC 01 00 00 E8 ?? ?? ?? ?? B0 01 48 8B 8D E0 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 40 04 00 00 48 81 C4 F0 03 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 44 89 4C 24 40 49 8D 4E 04 45 89 0E 4C 8D 44 24 44 45 33 C9 BA CC 01 00 00 E8 ?? ?? ?? ?? 32 C0 EB B4 83 F8 01 74 AD 45 8B 16 45 85 D2 74 A5 4D 8D 5E 04 45 8B C1 48 8B D8 66 66 0F 1F 84 00 00 00 00 00 43 8B 14 8B 4B 8D 0C 8B 41 8B C0 41 FF C1 48 0F AF D3 48 03 D0 4C 8B C2 89 11 49 C1 E8 20 45 3B CA 75 DD 45 85 C0 0F 84 65 FF FF FF 41 8B 06 83 F8 73 73 0D 45 89 44 86 04 41 FF 06 E9 50 FF FF FF 33 F6 4C 8D 44 24 44 45 33 C9 89 74 24 40 BA CC 01 00 00 41 89 36 49 8B CB E8 ?? ?? ?? ?? 32 C0 E9 2D FF FF FF }
	condition:
		$1
}

rule file_0_97_0 {
	meta:
		name = "?multiply_core@__crt_strtox@@YAIQEAIII@Z"
		size = 73
	strings:
		$1 = { 48 89 5C 24 08 33 C0 44 8B D2 48 8B D9 44 8B C8 85 D2 74 2F 45 8B D8 66 0F 1F 84 00 00 00 00 00 45 8B C1 41 FF C1 8B C8 42 8B 14 83 49 0F AF D3 48 03 D1 48 8B C2 42 89 14 83 48 C1 E8 20 45 3B CA 75 DD 48 8B 5C 24 08 C3 }
	condition:
		$1
}

rule file_0_98_0 {
	meta:
		name = "?normal_mantissa_mask@floating_point_value@__crt_strtox@@QEBA_KXZ"
		size = 28
	strings:
		$1 = { 8A 41 08 48 B9 00 00 00 FF FF FF 1F 00 F6 D8 48 1B C0 48 23 C1 48 05 FF FF FF 00 C3 }
	condition:
		$1
}

rule file_0_99_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAID@Z"
		size = 46
	strings:
		$1 = { 8D 41 D0 3C 09 77 07 0F BE C1 83 E8 30 C3 8D 41 9F 3C 19 77 07 0F BE C1 83 E8 57 C3 8D 41 BF 3C 19 77 07 0F BE C1 83 E8 37 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_0_100_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAI_W@Z"
		size = 470
	strings:
		$1 = { BA 30 00 00 00 66 3B CA 0F 82 9F 01 00 00 66 83 F9 3A 73 0A 0F B7 C1 2B C2 E9 8A 01 00 00 BA 10 FF 00 00 66 3B CA 0F 83 6B 01 00 00 BA 60 06 00 00 66 3B CA 0F 82 73 01 00 00 8D 42 0A 66 3B C8 72 D2 BA F0 06 00 00 66 3B CA 0F 82 5D 01 00 00 8D 42 0A 66 3B C8 72 BC BA 66 09 00 00 66 3B CA 0F 82 47 01 00 00 8D 42 0A 66 3B C8 72 A6 8D 50 76 66 3B CA 0F 82 33 01 00 00 8D 42 0A 66 3B C8 72 92 8D 50 76 66 3B CA 0F 82 1F 01 00 00 8D 42 0A 66 3B C8 0F 82 7A FF FF FF 8D 50 76 66 3B CA 0F 82 07 01 00 00 8D 42 0A 66 3B C8 0F 82 62 FF FF FF 8D 50 76 66 3B CA 0F 82 EF 00 00 00 8D 42 0A 66 3B C8 0F 82 4A FF FF FF BA 66 0C 00 00 66 3B CA 0F 82 D5 00 00 00 8D 42 0A 66 3B C8 0F 82 30 FF FF FF 8D 50 76 66 3B CA 0F 82 BD 00 00 00 8D 42 0A 66 3B C8 0F 82 18 FF FF FF 8D 50 76 66 3B CA 0F 82 A5 00 00 00 8D 42 0A 66 3B C8 0F 82 00 FF FF FF BA 50 0E 00 00 66 3B CA 0F 82 8B 00 00 00 8D 42 0A 66 3B C8 0F 82 E6 FE FF FF 8D 50 76 66 3B CA 72 77 8D 42 0A 66 3B C8 0F 82 D2 FE FF FF 8D 50 46 66 3B CA 72 63 8D 42 0A 66 3B C8 0F 82 BE FE FF FF BA 40 10 00 00 66 3B CA 72 4D 8D 42 0A 66 3B C8 0F 82 A8 FE FF FF BA E0 17 00 00 66 3B CA 72 37 8D 42 0A 66 3B C8 0F 82 92 FE FF FF 8D 50 26 66 3B CA 72 23 8D 42 0A 66 3B C8 73 1B E9 7D FE FF FF B8 1A FF 00 00 66 3B C8 0F 82 6F FE FF FF 83 C8 FF 83 F8 FF 75 28 8D 41 BF 66 83 F8 19 76 0D 8D 41 9F 66 83 F8 19 76 04 83 C8 FF C3 8D 41 9F 66 83 F8 19 0F B7 C1 77 03 83 E8 20 83 C0 C9 C3 }
	condition:
		$1
}

rule file_0_103_0 {
	meta:
		name = "?right_shift_with_rounding@__crt_strtox@@YA_K_N_KI0@Z"
		size = 202
		refs = "006b fegetround"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 20 45 8B F0 48 8B FA 40 8A E9 41 83 F8 40 72 04 33 C0 EB 7B 4C 0F A3 F2 B8 01 00 00 00 41 8D 4E FF 41 0F 92 C4 48 D3 E0 48 85 C2 41 0F 95 C7 33 DB 45 84 C9 74 0B 48 FF C8 40 8A F3 48 85 C2 74 03 40 B6 01 45 84 FF 75 05 40 84 F6 74 35 E8 ?? ?? ?? ?? 85 C0 74 1B 3D 00 01 00 00 74 0F 3D 00 02 00 00 75 1E 40 84 ED 0F 94 C3 EB 16 40 8A DD EB 11 45 84 FF 74 0C 40 84 F6 75 05 45 84 E4 74 02 B3 01 41 8B CE 0F B6 C3 48 D3 EF 48 03 C7 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_0_106_0 {
	meta:
		name = "?shift_left@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
		size = 364
		refs = "014e memcpy_s"
	strings:
		$1 = { 48 89 6C 24 18 56 57 41 54 41 56 41 57 48 81 EC F0 01 00 00 4C 8B C1 8B FA 83 E7 1F 44 8B DA 41 B9 20 00 00 00 41 C1 EB 05 45 8B F1 BE 01 00 00 00 41 8B 10 44 2B F7 41 8B CE 45 33 E4 48 D3 E6 FF CE 8D 42 FF 44 8B FE 8B C8 41 F7 D7 41 0F BD 44 80 04 74 04 FF C0 EB 03 41 8B C4 44 2B C8 42 8D 04 1A 41 3B F9 40 0F 97 C5 83 F8 73 0F 97 C2 83 F8 73 75 09 40 84 ED 74 04 B1 01 EB 02 32 C9 84 D2 0F 85 AC 00 00 00 84 C9 0F 85 A4 00 00 00 48 89 9C 24 20 02 00 00 BB 72 00 00 00 3B C3 0F 42 D8 44 8B D3 83 FB FF 74 57 66 0F 1F 44 00 00 45 3B D3 72 4C 41 8B 10 41 8B C2 41 2B C3 8D 48 FF 3B C2 73 07 45 8B 4C 80 04 EB 03 45 8B CC 3B CA 73 07 41 8B 54 88 04 EB 03 41 8B D4 41 23 D7 41 8B C2 41 8B CE 44 23 CE D3 EA 41 FF CA 8B CF 41 D3 E1 41 0B D1 41 89 54 80 04 41 83 FA FF 75 AF 41 8B C4 45 85 DB 74 15 0F 1F 80 00 00 00 00 8B C8 FF C0 45 89 64 88 04 41 3B C3 75 F2 40 84 ED 74 02 FF C3 41 89 18 B0 01 48 8B 9C 24 20 02 00 00 EB 20 45 89 20 49 8D 48 04 4C 8D 44 24 24 44 89 64 24 20 45 33 C9 BA CC 01 00 00 E8 ?? ?? ?? ?? 32 C0 48 8B AC 24 30 02 00 00 48 81 C4 F0 01 00 00 41 5F 41 5E 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_0_107_0 {
	meta:
		name = "?should_round_up@__crt_strtox@@YA_N_N000@Z"
		size = 138
		refs = "0036 fegetround"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 DB 41 8A F1 41 8A E8 44 8A F2 40 8A F9 45 84 C0 75 09 45 84 C9 75 04 32 C0 EB 3A E8 ?? ?? ?? ?? 85 C0 74 1B 3D 00 01 00 00 74 0F 3D 00 02 00 00 75 21 40 84 FF 0F 94 C0 EB 1B 40 8A C7 EB 16 40 84 ED 74 0F 40 84 F6 75 05 45 84 F6 74 05 BB 01 00 00 00 8A C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_0_108_0 {
	meta:
		name = "?unget@?$c_string_character_source@D@__crt_strtox@@QEAAXD@Z"
		size = 39
		refs = "0013 _errno 001e _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 FF 09 48 8B 01 84 D2 74 14 38 10 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_0_109_0 {
	meta:
		name = "?unget@?$c_string_character_source@_W@__crt_strtox@@QEAAX_W@Z"
		size = 42
		refs = "0016 _errno 0021 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 01 FE 48 8B 01 66 85 D2 74 15 66 39 10 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_0_110_0 {
	meta:
		name = "?validate@?$c_string_character_source@D@__crt_strtox@@QEBA_NXZ"
		size = 37
		refs = "000b _errno 0016 _invalid_parameter_noinfo"
		altNames = "?validate@?$c_string_character_source@_W@__crt_strtox@@QEBA_NXZ ?validate@?$stream_input_adapter@_W@__crt_stdio_input@@QEBA_NXZ ?validate@?$stream_output_adapter@_W@__crt_stdio_output@@QEBA_NXZ ?validate@?$string_output_adapter@D@__crt_stdio_output@@QEBA_NXZ ?validate@?$string_output_adapter@_W@__crt_stdio_output@@QEBA_NXZ"
	strings:
		$1 = { 48 83 EC 28 48 83 39 00 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_0_112_0 {
	meta:
		name = "?wide_character_to_digit@__crt_strtox@@YAH_W@Z"
		size = 405
	strings:
		$1 = { BA 30 00 00 00 66 3B CA 0F 82 83 01 00 00 66 83 F9 3A 73 06 0F B7 C1 2B C2 C3 BA 10 FF 00 00 66 3B CA 0F 83 5B 01 00 00 BA 60 06 00 00 66 3B CA 0F 82 5B 01 00 00 8D 42 0A 66 3B C8 72 D6 BA F0 06 00 00 66 3B CA 0F 82 45 01 00 00 8D 42 0A 66 3B C8 72 C0 BA 66 09 00 00 66 3B CA 0F 82 2F 01 00 00 8D 42 0A 66 3B C8 72 AA 8D 50 76 66 3B CA 0F 82 1B 01 00 00 8D 42 0A 66 3B C8 72 96 8D 50 76 66 3B CA 0F 82 07 01 00 00 8D 42 0A 66 3B C8 72 82 8D 50 76 66 3B CA 0F 82 F3 00 00 00 8D 42 0A 66 3B C8 0F 82 6A FF FF FF 8D 50 76 66 3B CA 0F 82 DB 00 00 00 8D 42 0A 66 3B C8 0F 82 52 FF FF FF BA 66 0C 00 00 66 3B CA 0F 82 C1 00 00 00 8D 42 0A 66 3B C8 0F 82 38 FF FF FF 8D 50 76 66 3B CA 0F 82 A9 00 00 00 8D 42 0A 66 3B C8 0F 82 20 FF FF FF 8D 50 76 66 3B CA 0F 82 91 00 00 00 8D 42 0A 66 3B C8 0F 82 08 FF FF FF BA 50 0E 00 00 66 3B CA 72 7B 8D 42 0A 66 3B C8 0F 82 F2 FE FF FF 8D 50 76 66 3B CA 72 67 8D 42 0A 66 3B C8 0F 82 DE FE FF FF 8D 50 46 66 3B CA 72 53 8D 42 0A 66 3B C8 0F 82 CA FE FF FF BA 40 10 00 00 66 3B CA 72 3D 8D 42 0A 66 3B C8 0F 82 B4 FE FF FF BA E0 17 00 00 66 3B CA 72 27 8D 42 0A 66 3B C8 0F 82 9E FE FF FF 8D 50 26 66 3B CA 72 13 8D 42 0A EB 05 B8 1A FF 00 00 66 3B C8 0F 82 83 FE FF FF 83 C8 FF C3 }
	condition:
		$1
}

rule file_0_120_0 {
	meta:
		name = "_chvalidchk_l"
		size = 56
		refs = "0023 __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 63 F9 8B DA 4D 85 C0 74 0E 49 8B 00 48 8B 08 0F B7 04 79 23 C2 EB 0B E8 ?? ?? ?? ?? 0F B7 04 78 23 C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_0_121_0 {
	meta:
		name = "_ischartype_l"
		size = 71
		refs = "0020 _isctype_l 0032 __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 63 F9 8B DA 4D 85 C0 74 1D 49 8B 00 83 78 08 01 7E 09 8B CF E8 ?? ?? ?? ?? EB 16 48 8B 00 0F B7 04 78 23 C2 EB 0B E8 ?? ?? ?? ?? 0F B7 04 78 23 C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_0_125_0 {
	meta:
		name = "memcpy_s"
		size = 135
		refs = "0027 _errno 0033 _invalid_parameter_noinfo 004c memcpy 0058 memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B D9 49 8B F0 48 8B FA 4D 85 C9 75 04 33 C0 EB 56 48 85 C9 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 3C 4D 85 C0 74 12 48 3B D3 72 0D 4C 8B C3 48 8B D6 E8 ?? ?? ?? ?? EB CB 4C 8B C2 33 D2 E8 ?? ?? ?? ?? 48 85 F6 74 C5 48 3B FB 73 0C E8 ?? ?? ?? ?? BB 22 00 00 00 EB BE B8 16 00 00 00 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "??$__crt_time_elapsed_leap_years@H@@YAHH@Z"
		size = 75
		altNames = "??$__crt_time_elapsed_leap_years@J@@YAJJ@Z"
	strings:
		$1 = { 44 8D 41 FF 41 BA 1F 85 EB 51 81 C1 2B 01 00 00 41 8B C2 F7 E9 41 8B C2 44 8B CA 41 F7 E8 41 C1 F9 07 41 8B C0 C1 FA 05 41 8B C9 C1 E9 1F 44 03 C9 8B CA C1 E9 1F 03 D1 44 2B CA 99 83 E2 03 03 C2 C1 F8 02 83 C0 EF 41 03 C1 C3 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "??$__crt_time_is_leap_year@H@@YA_NH@Z"
		size = 90
		altNames = "??$__crt_time_is_leap_year@J@@YA_NJ@Z"
	strings:
		$1 = { 8B C1 44 8B C1 25 03 00 00 80 7D 07 FF C8 83 C8 FC FF C0 41 B9 1F 85 EB 51 85 C0 75 1B 41 8B C1 41 F7 E8 C1 FA 05 8B CA C1 E9 1F 03 D1 6B D2 64 44 3B C2 74 03 B0 01 C3 41 8D 88 6C 07 00 00 41 8B C1 F7 E9 C1 FA 07 8B C2 C1 E8 1F 03 D0 69 C2 90 01 00 00 3B C8 0F 94 C0 C3 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "??$common_gmtime@J@@YAPEAUtm@@QEBJ@Z"
		size = 69
		refs = "0013 __getgmtimebuf 0028 ??$common_gmtime_s@J@@YAHQEAUtm@@QEBJ@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 74 14 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "??$common_gmtime@_J@@YAPEAUtm@@QEB_J@Z"
		size = 69
		refs = "0013 __getgmtimebuf 0028 ??$common_gmtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 74 14 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "??$common_localtime@J@@YAPEAUtm@@QEBJ@Z"
		size = 69
		refs = "0013 __getgmtimebuf 0028 ??$common_localtime_s@J@@YAHQEAUtm@@QEBJ@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 74 14 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_29_1_0 {
	meta:
		name = "??$common_localtime@_J@@YAPEAUtm@@QEB_J@Z"
		size = 69
		refs = "0013 __getgmtimebuf 0028 ??$common_localtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 74 14 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "??$common_gmtime_s@J@@YAHQEAUtm@@QEBJ@Z"
		size = 422
		refs = "0016 _errno 0022 _invalid_parameter_noinfo 0039 memset 00cb _days 00f6 _lpdays"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B FA 48 8B D9 48 85 C9 75 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 6E 01 00 00 BA FF 00 00 00 41 B8 24 00 00 00 E8 ?? ?? ?? ?? 48 85 FF 74 D3 4C 63 07 41 81 F8 40 57 FF FF 7D 0E E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 EB CA 48 B9 CF E1 58 93 07 00 00 00 4C 3B C1 7F E3 B8 79 2D 03 11 32 C9 41 F7 E8 41 BB 01 00 00 00 C1 FA 17 8B C2 C1 E8 1F 03 D0 69 C2 80 E0 79 F8 8D 14 95 46 00 00 00 44 03 C0 B8 80 33 E1 01 44 3B C0 7C 26 41 03 D3 44 2B C0 44 3B C0 7C 1B 44 2B C0 41 03 D3 B8 00 85 E2 01 44 3B C0 7C 08 41 03 D3 44 2B C0 EB 03 41 8A CB 89 53 14 4C 8D 15 ?? ?? ?? ?? B8 07 45 2E C2 45 8B CB 41 F7 E8 41 03 D0 C1 FA 10 8B C2 C1 E8 1F 03 D0 69 C2 80 AE FE FF 89 53 1C 44 03 C0 48 8D 05 ?? ?? ?? ?? 84 C9 4C 0F 45 D0 49 8D 4A 04 EB 07 45 03 CB 48 8D 49 04 39 11 7C F5 45 2B CB B8 07 45 2E C2 44 89 4B 10 49 63 C9 41 2B 14 8A 89 53 0C F7 2F B8 93 24 49 92 03 17 83 63 20 00 C1 FA 10 8B CA 83 C2 04 C1 E9 1F 03 CA F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 B8 C5 B3 A2 91 41 F7 E8 89 4B 18 41 03 D0 C1 FA 0B 8B C2 C1 E8 1F 03 D0 69 C2 F0 F1 FF FF 89 53 08 44 03 C0 B8 89 88 88 88 41 F7 E8 41 03 D0 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B C2 3C 89 53 04 44 2B C0 44 89 03 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "??$common_gmtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
		size = 403
		refs = "0016 _errno 0022 _invalid_parameter_noinfo 0039 memset 007f ?compute_year@@YAHAEA_JAEA_N@Z 008b _days 00c3 _lpdays"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 48 8B FA 48 8B D9 48 85 C9 75 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 5B 01 00 00 BA FF 00 00 00 41 B8 24 00 00 00 E8 ?? ?? ?? ?? 48 85 FF 74 D3 48 8B 07 48 89 44 24 40 48 3D 40 57 FF FF 7D 0E E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 EB C6 48 B9 CF E1 58 93 07 00 00 00 48 3B C1 7F E3 48 8D 54 24 30 C6 44 24 30 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 44 24 40 4C 8D 15 ?? ?? ?? ?? 89 43 14 49 BB 57 29 51 CE A0 C8 45 18 49 8B C3 41 B9 01 00 00 00 49 F7 E8 48 C1 FA 0D 48 8B C2 48 C1 E8 3F 48 03 D0 48 63 C2 48 69 C8 80 AE FE FF 48 8D 05 ?? ?? ?? ?? 89 53 1C 4C 03 C1 80 7C 24 30 00 4C 0F 45 D0 49 8D 4A 04 EB 07 41 FF C1 48 8D 49 04 39 11 7C F5 41 FF C9 49 8B C3 49 63 C9 44 89 4B 10 41 2B 14 8A 89 53 0C 48 F7 2F 83 63 20 00 48 8B CA 48 C1 F9 0D 48 8B C1 48 C1 E8 3F 48 03 C8 B8 93 24 49 92 83 C1 04 F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 48 B8 05 7C F3 6A E2 59 D1 48 49 F7 E8 89 4B 18 48 C1 FA 0A 48 8B C2 48 C1 E8 3F 48 03 D0 48 63 C2 48 69 C8 F0 F1 FF FF 89 53 08 48 B8 89 88 88 88 88 88 88 88 4C 03 C1 49 F7 E8 49 03 D0 48 C1 FA 05 48 8B C2 48 C1 E8 3F 48 03 D0 6B C2 3C 89 53 04 44 2B C0 44 89 03 33 C0 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 27
		refs = "000d _free_base"
		altNames = "??1?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$scanset_buffer@_W@__crt_stdio_input@@QEAA@XZ ??1?$scanset_storage@$01@__crt_stdio_input@@QEAA@XZ ?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_50_10_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAA@XZ"
		size = 27
		refs = "000d free"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_50_11_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAA@XZ"
		size = 27
		refs = "000d free"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_517_71_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAXXZ"
		size = 27
		refs = "000d free"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_571_25_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAAXXZ"
		size = 27
		refs = "000d free"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "?compute_year@@YAHAEAJAEA_N@Z"
		size = 104
	strings:
		$1 = { 44 8B 01 4C 8B CA B8 79 2D 03 11 41 BA 80 33 E1 01 41 F7 E8 C1 FA 17 8B C2 C1 E8 1F 03 D0 69 C2 80 1F 86 07 8D 14 95 46 00 00 00 44 2B C0 44 89 01 45 3B C2 7C 2F 41 8D 80 80 CC 1E FE FF C2 89 01 41 3B C2 7C 1F 05 80 CC 1E FE FF C2 89 01 3D 00 85 E2 01 7C 0B FF C2 05 00 7B 1D FE 89 01 EB 04 41 C6 01 01 8B C2 C3 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "?compute_year@@YAHAEA_JAEA_N@Z"
		size = 226
		refs = "00b1 ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 48 8B F2 41 BA 1F 85 EB 51 48 B8 B9 70 12 CB F5 48 31 88 48 F7 29 48 8B DA 48 03 19 48 C1 FB 18 48 8B C3 48 C1 E8 3F 48 03 D8 41 8B C2 83 C3 46 8D 8B 2B 01 00 00 F7 E9 41 8B C2 44 8D 4B FF 44 8B C2 41 F7 E9 41 C1 F8 07 C1 FA 05 41 8B C8 8B C2 C1 E9 1F C1 E8 1F 44 03 C1 03 D0 41 8B C1 44 2B C2 99 83 E2 03 8D 0C 02 C1 F9 02 8D 43 BA 83 C1 EF 41 03 C8 48 63 D1 48 63 C8 48 69 C1 93 FE FF FF 48 2B C2 48 69 C0 80 51 01 00 48 01 07 79 1F 48 81 07 80 33 E1 01 41 8B C9 41 8B D9 E8 ?? ?? ?? ?? 84 C0 74 17 48 81 07 80 51 01 00 EB 0B 8B CB E8 ?? ?? ?? ?? 84 C0 74 03 C6 06 01 48 8B 74 24 38 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_13_0 {
	meta:
		name = "__getgmtimebuf"
		size = 75
		refs = "0007 __acrt_getptd_noexit 0020 _malloc_base 002b _free_base 0039 _errno"
	strings:
		$1 = { 40 53 48 83 EC 20 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 25 48 8B 40 68 48 85 C0 75 29 8D 48 24 E8 ?? ?? ?? ?? 33 C9 48 89 43 68 E8 ?? ?? ?? ?? 48 8B 43 68 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1_14_0 {
	meta:
		name = "_gmtime32"
		size = 72
		refs = "0013 __getgmtimebuf 0028 ??$common_gmtime_s@J@@YAHQEAUtm@@QEBJ@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 E8 ?? ?? ?? ?? 33 DB 48 8B F8 48 85 C0 74 14 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 FB 48 8B DF 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1_16_0 {
	meta:
		name = "_gmtime64"
		size = 72
		refs = "0013 __getgmtimebuf 0028 ??$common_gmtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 E8 ?? ?? ?? ?? 33 DB 48 8B F8 48 85 C0 74 14 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 FB 48 8B DF 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_29_11_0 {
	meta:
		name = "_localtime32"
		size = 72
		refs = "0013 __getgmtimebuf 0028 ??$common_localtime_s@J@@YAHQEAUtm@@QEBJ@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 E8 ?? ?? ?? ?? 33 DB 48 8B F8 48 85 C0 74 14 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 FB 48 8B DF 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_29_13_0 {
	meta:
		name = "_localtime64"
		size = 72
		refs = "0013 __getgmtimebuf 0028 ??$common_localtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 E8 ?? ?? ?? ?? 33 DB 48 8B F8 48 85 C0 74 14 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 FB 48 8B DF 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_3_5_0 {
	meta:
		name = "_mbsspn_l"
		size = 217
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0030 strspn 0044 _errno 004f _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B FA 48 8B D9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 30 41 83 78 08 00 75 10 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 EB 7F 48 85 DB 74 05 48 85 FF 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 D2 EB 61 80 3B 00 48 8B D3 74 56 80 3F 00 48 8B CF 74 2E 0F B6 01 42 F6 44 00 19 04 74 17 3A 02 75 08 8A 42 01 38 41 01 74 17 80 79 01 00 74 11 48 FF C1 EB 04 3A 02 74 08 48 FF C1 80 39 00 75 D2 80 39 00 74 1B 0F B6 02 42 F6 44 00 19 04 74 08 48 FF C2 80 3A 00 74 08 48 FF C2 80 3A 00 75 AA 48 2B D3 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B C2 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "_lsearch"
		size = 178
		refs = "002b _errno 0036 _invalid_parameter_noinfo 0070 __guard_dispatch_icall_fptr 008a memcpy"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 41 8B F1 4D 8B F0 48 8B DA 48 8B E9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 59 4D 85 C0 74 E7 48 85 D2 74 E2 45 85 C9 74 DD 48 83 7C 24 50 00 74 D5 41 8B 38 0F AF FE 48 03 FA 48 3B D7 74 1D 48 8B 44 24 50 48 8B D3 48 8B CD FF 15 ?? ?? ?? ?? 85 C0 74 1C 48 03 DE 48 3B DF 75 E3 4C 8B C6 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 41 FF 06 48 8B DF 48 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "lrint"
		size = 123
		refs = "0015 _dtest 002c nearbyint 0043 _fperrraise 004b __real@c1e0000000000000 0055 __real@41dfffffffc00000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 0F 29 74 24 20 E8 ?? ?? ?? ?? 98 85 C0 74 51 FF C8 83 F8 01 76 40 F2 0F 10 44 24 40 E8 ?? ?? ?? ?? 66 0F 2E 44 24 40 0F 28 F0 7A 02 74 0A B9 20 00 00 00 E8 ?? ?? ?? ?? 66 0F 2F 35 ?? ?? ?? ?? 72 14 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C6 72 06 F2 0F 2C C6 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "lrintl"
		size = 123
		refs = "0015 _ldtest 002c nearbyintl 0043 _fperrraise 004b __real@c1e0000000000000 0055 __real@41dfffffffc00000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 0F 29 74 24 20 E8 ?? ?? ?? ?? 98 85 C0 74 51 FF C8 83 F8 01 76 40 F2 0F 10 44 24 40 E8 ?? ?? ?? ?? 66 0F 2E 44 24 40 0F 28 F0 7A 02 74 0A B9 20 00 00 00 E8 ?? ?? ?? ?? 66 0F 2F 35 ?? ?? ?? ?? 72 14 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C6 72 06 F2 0F 2C C6 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "_mbscoll_l"
		size = 201
		refs = "0021 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0030 _errno 003b _invalid_parameter_noinfo 0056 _strcoll_l 0089 __acrt_CompareStringA"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 60 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 40 49 8B F0 E8 ?? ?? ?? ?? 48 85 FF 74 05 48 85 DB 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 5B 48 8B 54 24 50 83 7A 08 00 75 10 4C 8B C6 48 8B D3 48 8B CF E8 ?? ?? ?? ?? EB 4A 8B 42 04 48 8D 4C 24 48 48 8B 92 20 02 00 00 4C 8B CF 89 44 24 38 41 B8 00 10 00 00 83 C8 FF 89 44 24 30 48 89 5C 24 28 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 C0 FE 80 7C 24 58 00 74 0C 48 8B 4C 24 40 83 A1 A8 03 00 00 FD 48 8B 5C 24 70 48 8B 74 24 78 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_7_5_0 {
	meta:
		name = "_mbcjistojms_l"
		size = 151
		refs = "000e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0070 _errno"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 30 81 78 04 A4 03 00 00 75 5C 8B C3 0F B6 CB C1 E8 08 0F B6 D0 8D 42 DF 83 F8 5D 77 3C 8D 41 DF 83 F8 5D 77 34 F6 C2 01 74 0F 83 F9 5F 77 05 83 C1 1F EB 08 83 C1 20 EB 03 83 C1 7E 8D 5A DF D1 EB 81 C3 81 00 00 00 81 FB 9F 00 00 00 76 03 83 C3 40 C1 E3 08 0B D9 EB 0D E8 ?? ?? ?? ?? 33 DB C7 00 2A 00 00 00 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_7_7_0 {
	meta:
		name = "_mbcjmstojis_l"
		size = 193
		refs = "000e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 009a _errno"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 30 41 81 78 04 A4 03 00 00 0F 85 81 00 00 00 8B C3 0F B6 D3 C1 E8 08 0F B6 C8 42 F6 44 01 19 04 74 61 42 F6 44 02 19 08 74 59 81 F9 A0 00 00 00 1B C0 83 E0 C0 05 C1 00 00 00 2B C8 81 FA 9F 00 00 00 72 0D 8D 59 11 C1 E3 09 8D 42 82 0B D8 EB 1A 33 C0 8B DA 83 FA 7E 0F 97 C0 C1 E1 09 83 C0 1F 81 C1 00 21 00 00 2B D8 0B D9 8D 83 DF DE FF FF 3D 5D 5D 00 00 77 0B 0F B6 C3 83 E8 21 83 F8 5D 76 0D E8 ?? ?? ?? ?? 33 DB C7 00 2A 00 00 00 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 8B C3 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_8_9_0 {
	meta:
		name = "_putch"
		size = 58
		refs = "0031 ??$?RV<lambda_964a5dbffd41b5aa0d45fdb7180ac8f3>@@AEAV<lambda_76b7ce3881063c72d9d9c3f590a24f96>@@V<lambda_c561a53cc468f5ddf59968495e70c67a>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_964a5dbffd41b5aa0d45fdb7180ac8f3>@@AEAV<lambda_76b7ce3881063c72d9d9c3f590a24f96>@@$$QEAV<lambda_c561a53cc468f5ddf59968495e70c67a>@@@Z"
	strings:
		$1 = { 89 4C 24 08 4C 8B DC 48 83 EC 38 49 8D 43 08 49 89 43 E8 4D 8D 4B 18 B8 09 00 00 00 4D 8D 43 E8 49 8D 53 20 89 44 24 50 49 8D 4B 10 89 44 24 58 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_8_10_0 {
	meta:
		name = "_putch_nolock"
		size = 182
		refs = "0015 __acrt_getptd 0048 __pctype_func 007a mbtowc 0089 _putwch_nolock"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 56 48 83 EC 20 8B F9 E8 ?? ?? ?? ?? 41 BE 01 00 00 00 48 8B D8 48 8D B0 AC 03 00 00 66 44 39 B0 B2 03 00 00 75 06 40 88 7E 01 EB 03 40 88 3E 33 ED 66 39 A8 B2 03 00 00 75 1D E8 ?? ?? ?? ?? 0F B6 0E BA 00 80 00 00 66 85 14 48 74 0A 66 44 89 B3 B2 03 00 00 EB 3D 0F B7 83 B2 03 00 00 48 8D 4C 24 40 41 03 C6 48 8B D6 4C 63 C0 E8 ?? ?? ?? ?? 83 F8 FF 74 14 0F B7 4C 24 40 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 03 83 CF FF 66 89 AB B2 03 00 00 48 8B 5C 24 48 8B C7 48 8B 6C 24 50 48 83 C4 20 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_9_26_0 {
	meta:
		name = "??0__crt_scoped_get_last_error_reset@@QEAA@XZ"
		size = 26
		refs = "000b __imp_GetLastError"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 FF 15 ?? ?? ?? ?? 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_42_0 {
	meta:
		name = "?construct_ptd@@YAXQEAU__acrt_ptd@@QEAPEAU__crt_locale_data@@@Z"
		size = 197
		refs = "0029 __acrt_exception_action_table 0033 __acrt_initial_multibyte_data 008b ??$?RV<lambda_0ae27a3a962d80f24befdcbee591983d>@@AEAV<lambda_8d0ee55de4b1038c4002e0adecdf1839>@@V<lambda_dc504788e8f1664fe9b84e20bfb512f2>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_0ae27a3a962d80f24befdcbee591983d>@@AEAV<lambda_8d0ee55de4b1038c4002e0adecdf1839>@@$$QEAV<lambda_dc504788e8f1664fe9b84e20bfb512f2>@@@Z 00bb ??$?RV<lambda_aa87e3671a710a21b5dc78c0bdf72e11>@@AEAV<lambda_92619d2358a28f41a33ba319515a20b9>@@V<lambda_6992ecaafeb10aed2b74cb1fae11a551>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_aa87e3671a710a21b5dc78c0bdf72e11>@@AEAV<lambda_92619d2358a28f41a33ba319515a20b9>@@$$QEAV<lambda_6992ecaafeb10aed2b74cb1fae11a551>@@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 55 48 8B EC 48 83 EC 40 BA 01 00 00 00 4C 8D 4D 28 89 51 28 4C 8D 45 E8 48 8B 45 10 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8D 0D ?? ?? ?? ?? 48 8B 45 10 89 90 A8 03 00 00 48 8B 45 10 48 89 88 88 00 00 00 8D 4A 42 48 8B 45 10 66 89 88 BC 00 00 00 48 8B 45 10 66 89 88 C2 01 00 00 48 8D 4D 20 48 8B 45 10 48 83 A0 A0 03 00 00 00 48 8D 45 10 48 89 45 E8 8D 42 04 48 8D 55 E0 89 45 28 89 45 E0 E8 ?? ?? ?? ?? 48 8D 45 10 48 89 45 E8 4C 8D 4D 28 48 8D 45 18 48 89 45 F0 4C 8D 45 E8 B8 04 00 00 00 48 8D 55 E0 48 8D 4D 20 89 45 28 89 45 E0 E8 ?? ?? ?? ?? 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_9_43_0 {
	meta:
		name = "?construct_ptd_array@@YAXQEAU__acrt_ptd@@@Z"
		size = 205
		refs = "004b __acrt_current_locale_data 0059 __acrt_exception_action_table 0067 __acrt_initial_multibyte_data 00ae ??$?RV<lambda_0ae27a3a962d80f24befdcbee591983d>@@AEAV<lambda_8d0ee55de4b1038c4002e0adecdf1839>@@V<lambda_dc504788e8f1664fe9b84e20bfb512f2>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_0ae27a3a962d80f24befdcbee591983d>@@AEAV<lambda_8d0ee55de4b1038c4002e0adecdf1839>@@$$QEAV<lambda_dc504788e8f1664fe9b84e20bfb512f2>@@@Z 00c3 ??$?RV<lambda_aa87e3671a710a21b5dc78c0bdf72e11>@@AEAV<lambda_92619d2358a28f41a33ba319515a20b9>@@V<lambda_6992ecaafeb10aed2b74cb1fae11a551>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_aa87e3671a710a21b5dc78c0bdf72e11>@@AEAV<lambda_92619d2358a28f41a33ba319515a20b9>@@$$QEAV<lambda_6992ecaafeb10aed2b74cb1fae11a551>@@@Z"
	strings:
		$1 = { 40 55 48 8B EC 48 83 EC 50 48 89 4D D8 48 8D 45 D8 48 89 45 E8 4C 8D 4D 20 BA 01 00 00 00 4C 8D 45 E8 B8 05 00 00 00 89 45 20 89 45 28 48 8D 45 D8 48 89 45 F0 48 8D 45 E0 48 89 45 F8 B8 04 00 00 00 89 45 D0 89 45 D4 48 8D 05 ?? ?? ?? ?? 48 89 45 E0 89 51 28 48 8D 0D ?? ?? ?? ?? 48 8B 45 D8 48 89 08 48 8D 0D ?? ?? ?? ?? 48 8B 45 D8 89 90 A8 03 00 00 48 8B 45 D8 48 89 88 88 00 00 00 8D 4A 42 48 8B 45 D8 48 8D 55 28 66 89 88 BC 00 00 00 48 8B 45 D8 66 89 88 C2 01 00 00 48 8D 4D 18 48 8B 45 D8 48 83 A0 A0 03 00 00 00 E8 ?? ?? ?? ?? 4C 8D 4D D0 4C 8D 45 F0 48 8D 55 D4 48 8D 4D 18 E8 ?? ?? ?? ?? 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_9_45_0 {
	meta:
		name = "?destroy_fls@@YAXPEAX@Z"
		size = 32
		refs = "000e ?destroy_ptd_array@@YAXQEAU__acrt_ptd@@@Z 0016 _free_base"
	strings:
		$1 = { 48 85 C9 74 1A 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_46_0 {
	meta:
		name = "?destroy_ptd@@YAXQEAU__acrt_ptd@@@Z"
		size = 245
		refs = "0013 __acrt_exception_action_table 0020 _free_base 00c3 ??$?RV<lambda_f2e299630e499de9f9a165e60fcd3db5>@@AEAV<lambda_2ae9d31cdba2644fcbeaf08da7c24588>@@V<lambda_40d01ff24d0e7b3814fdbdcee8eab3c7>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_f2e299630e499de9f9a165e60fcd3db5>@@AEAV<lambda_2ae9d31cdba2644fcbeaf08da7c24588>@@$$QEAV<lambda_40d01ff24d0e7b3814fdbdcee8eab3c7>@@@Z 00eb ??$?RV<lambda_2d41944a1d46af3157314b8a01080d33>@@AEAV<lambda_8f455de75cd7d7f24b4096f044d8b9e6>@@V<lambda_aa500f224e6afead328df44964fe2772>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_2d41944a1d46af3157314b8a01080d33>@@AEAV<lambda_8f455de75cd7d7f24b4096f044d8b9e6>@@$$QEAV<lambda_aa500f224e6afead328df44964fe2772>@@@Z"
	strings:
		$1 = { 48 89 4C 24 08 55 48 8B EC 48 83 EC 30 48 8B 01 48 8D 15 ?? ?? ?? ?? 48 3B C2 74 0C 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 49 70 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 49 58 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 49 60 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 49 68 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 49 48 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 49 50 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 49 78 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 89 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D 10 48 8B 89 C0 03 00 00 E8 ?? ?? ?? ?? 48 8D 45 10 48 89 45 F0 4C 8D 4D 20 B8 05 00 00 00 4C 8D 45 F0 48 8D 55 28 89 45 20 48 8D 4D 18 89 45 28 E8 ?? ?? ?? ?? 48 8D 45 10 48 89 45 F0 4C 8D 4D 20 B8 04 00 00 00 4C 8D 45 F0 48 8D 55 28 89 45 20 48 8D 4D 18 89 45 28 E8 ?? ?? ?? ?? 48 83 C4 30 5D C3 }
	condition:
		$1
}

rule file_9_47_0 {
	meta:
		name = "?destroy_ptd_array@@YAXQEAU__acrt_ptd@@@Z"
		size = 245
		refs = "0018 __acrt_exception_action_table 0046 _free_base 00d6 ??$?RV<lambda_f2e299630e499de9f9a165e60fcd3db5>@@AEAV<lambda_2ae9d31cdba2644fcbeaf08da7c24588>@@V<lambda_40d01ff24d0e7b3814fdbdcee8eab3c7>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_f2e299630e499de9f9a165e60fcd3db5>@@AEAV<lambda_2ae9d31cdba2644fcbeaf08da7c24588>@@$$QEAV<lambda_40d01ff24d0e7b3814fdbdcee8eab3c7>@@@Z 00eb ??$?RV<lambda_2d41944a1d46af3157314b8a01080d33>@@AEAV<lambda_8f455de75cd7d7f24b4096f044d8b9e6>@@V<lambda_aa500f224e6afead328df44964fe2772>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_2d41944a1d46af3157314b8a01080d33>@@AEAV<lambda_8f455de75cd7d7f24b4096f044d8b9e6>@@$$QEAV<lambda_aa500f224e6afead328df44964fe2772>@@@Z"
	strings:
		$1 = { 40 55 48 8B EC 48 83 EC 40 48 8D 45 E8 48 89 4D E8 48 89 45 F0 48 8D 15 ?? ?? ?? ?? B8 05 00 00 00 89 45 20 89 45 28 48 8D 45 E8 48 89 45 F8 B8 04 00 00 00 89 45 E0 89 45 E4 48 8B 01 48 3B C2 74 0C 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 49 70 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 49 58 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 49 60 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 49 68 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 49 48 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 49 50 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 49 78 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 89 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D E8 48 8B 89 C0 03 00 00 E8 ?? ?? ?? ?? 4C 8D 4D 20 4C 8D 45 F0 48 8D 55 28 48 8D 4D 18 E8 ?? ?? ?? ?? 4C 8D 4D E0 4C 8D 45 F8 48 8D 55 E4 48 8D 4D 18 E8 ?? ?? ?? ?? 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_9_51_0 {
	meta:
		name = "?internal_get_ptd_head@@YAPEAU__acrt_ptd@@XZ"
		size = 161
		refs = "000c ?__acrt_flsindex@@3KA 0018 __acrt_FlsGetValue 0036 __acrt_FlsSetValue 004d _calloc_base 007e ?construct_ptd_array@@YAXQEAU__acrt_ptd@@@Z 008f _free_base"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 0D ?? ?? ?? ?? 33 FF 83 F9 FF 74 1A E8 ?? ?? ?? ?? 48 85 C0 74 0A 48 83 F8 FF 48 0F 44 C7 EB 6B 8B 0D ?? ?? ?? ?? 48 83 CA FF E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 54 BA C8 03 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 48 8B D8 48 85 C0 74 12 48 8B D0 E8 ?? ?? ?? ?? 85 C0 75 0F 8B 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? EB 11 48 8B CB E8 ?? ?? ?? ?? 48 8B CB 48 8B DF 48 8B F9 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_9_52_0 {
	meta:
		name = "?internal_getptd_noexit@@YAPEAU__acrt_ptd@@XZ"
		size = 188
		refs = "000c __imp_GetLastError 0012 ?__acrt_flsindex@@3KA 001e __acrt_FlsGetValue 003d __acrt_FlsSetValue 0050 _calloc_base 006c _free_base 0094 ?construct_ptd_array@@YAXQEAU__acrt_ptd@@@Z 00aa __imp_SetLastError"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B D8 83 F9 FF 74 1B E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 08 48 83 F8 FF 74 74 EB 6D 8B 0D ?? ?? ?? ?? 48 83 CA FF E8 ?? ?? ?? ?? 85 C0 74 5F BA C8 03 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 48 8B F8 48 85 C0 75 10 33 D2 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? EB 32 48 8B D0 E8 ?? ?? ?? ?? 85 C0 75 12 8B 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 48 8B CF EB DB 48 8B CF E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 48 85 FF 75 02 33 FF 8B CB FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_9_55_0 {
	meta:
		name = "?replace_current_thread_locale_nolock@@YAXQEAU__acrt_ptd@@QEAU__crt_locale_data@@@Z"
		size = 103
		refs = "001d __acrt_release_locale_ref 002b __acrt_current_locale_data 0034 __acrt_initial_locale_data 0044 __acrt_free_locale 0058 __acrt_add_locale_ref"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B DA 48 8B 89 90 00 00 00 48 85 C9 74 2C E8 ?? ?? ?? ?? 48 8B 8F 90 00 00 00 48 3B 0D ?? ?? ?? ?? 74 17 48 8D 05 ?? ?? ?? ?? 48 3B C8 74 0B 83 79 10 00 75 05 E8 ?? ?? ?? ?? 48 89 9F 90 00 00 00 48 85 DB 74 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_9_56_0 {
	meta:
		name = "?try_get_ptd_head@@YAPEAU__acrt_ptd@@XZ"
		size = 19
		refs = "0002 ?__acrt_flsindex@@3KA 000f __acrt_FlsGetValue"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 83 F9 FF 75 03 33 C0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_58_0 {
	meta:
		name = "__acrt_freeptd"
		size = 65
		refs = "0008 ?__acrt_flsindex@@3KA 0012 __acrt_FlsGetValue 0027 __acrt_FlsSetValue 002f ?destroy_ptd_array@@YAXQEAU__acrt_ptd@@@Z 0037 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 0D ?? ?? ?? ?? 83 F9 FF 74 2A E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 1D 8B 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_59_0 {
	meta:
		name = "__acrt_getptd"
		size = 203
		refs = "000c __imp_GetLastError 0012 ?__acrt_flsindex@@3KA 001e __acrt_FlsGetValue 0040 __acrt_FlsSetValue 0053 _calloc_base 006f _free_base 0097 ?construct_ptd_array@@YAXQEAU__acrt_ptd@@@Z 00ab __imp_SetLastError 00c6 abort"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B D8 83 F9 FF 74 1E E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0B 48 83 F8 FF 75 72 E9 88 00 00 00 8B 0D ?? ?? ?? ?? 48 83 CA FF E8 ?? ?? ?? ?? 85 C0 74 75 BA C8 03 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 48 8B F8 48 85 C0 75 10 33 D2 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? EB 48 48 8B D0 E8 ?? ?? ?? ?? 85 C0 75 12 8B 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 48 8B CF EB DB 48 8B CF E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 48 85 FF 74 16 8B CB FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C7 48 83 C4 20 5F C3 8B CB FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_9_60_0 {
	meta:
		name = "__acrt_getptd_head"
		size = 167
		refs = "0008 ?__acrt_flsindex@@3KA 0012 __acrt_FlsGetValue 0031 __acrt_FlsSetValue 0044 _calloc_base 0060 _free_base 0088 ?construct_ptd_array@@YAXQEAU__acrt_ptd@@@Z 00a2 abort"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 0D ?? ?? ?? ?? 83 F9 FF 74 1B E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 08 48 83 F8 FF 75 6F EB 7B 8B 0D ?? ?? ?? ?? 48 83 CA FF E8 ?? ?? ?? ?? 85 C0 74 68 BA C8 03 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 48 8B D8 48 85 C0 75 10 33 D2 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? EB 3B 48 8B D0 E8 ?? ?? ?? ?? 85 C0 75 12 8B 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 48 8B CB EB DB 48 8B CB E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 48 85 DB 74 09 48 8B C3 48 83 C4 20 5B C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_9_61_0 {
	meta:
		name = "__acrt_getptd_noexit"
		size = 207
		refs = "000c __imp_GetLastError 0012 ?__acrt_flsindex@@3KA 001e __acrt_FlsGetValue 0038 __imp_SetLastError 0057 __acrt_FlsSetValue 006a _calloc_base 0086 _free_base 00ae ?construct_ptd_array@@YAXQEAU__acrt_ptd@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B D8 83 F9 FF 74 35 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 22 48 83 F8 FF 0F 85 85 00 00 00 8B CB FF 15 ?? ?? ?? ?? 33 FF 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 8B 0D ?? ?? ?? ?? 48 83 CA FF E8 ?? ?? ?? ?? 85 C0 74 D5 BA C8 03 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 48 8B F8 48 85 C0 75 10 33 D2 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? EB A8 48 8B D0 E8 ?? ?? ?? ?? 85 C0 75 12 8B 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 48 8B CF EB DB 48 8B CF E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 48 85 FF 0F 84 72 FF FF FF 8B CB FF 15 ?? ?? ?? ?? E9 6F FF FF FF }
	condition:
		$1
}

rule file_9_62_0 {
	meta:
		name = "__acrt_initialize_ptd"
		size = 57
		refs = "0007 ?destroy_fls@@YAXPEAX@Z 000c __acrt_FlsAlloc 0012 ?__acrt_flsindex@@3KA 0020 __acrt_getptd_noexit 002c __acrt_uninitialize_ptd"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 83 F8 FF 75 04 32 C0 EB 15 E8 ?? ?? ?? ?? 48 85 C0 75 09 33 C9 E8 ?? ?? ?? ?? EB E9 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_9_63_0 {
	meta:
		name = "__acrt_uninitialize_ptd"
		size = 34
		refs = "0006 ?__acrt_flsindex@@3KA 0010 __acrt_FlsFree"
	strings:
		$1 = { 48 83 EC 28 8B 0D ?? ?? ?? ?? 83 F9 FF 74 0C E8 ?? ?? ?? ?? 83 0D ?? ?? ?? ?? FF B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_8_0 {
	meta:
		name = "?set_flags@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 30
	strings:
		$1 = { 4C 8B 01 41 0F 0D 48 14 41 8B 40 14 8B C8 0B CA F0 41 0F B1 48 14 75 F4 85 C2 0F 95 C0 C3 }
	condition:
		$1
}

rule file_10_9_0 {
	meta:
		name = "?unset_flags@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 37
	strings:
		$1 = { 4C 8B 01 44 8B CA 41 F7 D1 41 0F 0D 48 14 41 8B 40 14 8B C8 41 23 C9 F0 41 0F B1 48 14 75 F3 85 C2 0F 95 C0 C3 }
	condition:
		$1
}

rule file_10_10_0 {
	meta:
		name = "_ungetc_nolock"
		size = 269
		refs = "001d _fileno 0027 __badioinfo 002e __pioinfo 0082 _errno 008d _invalid_parameter_noinfo 00b8 __acrt_stdio_allocate_buffer_nolock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 42 14 48 8B DA 8B F9 C1 E8 0C A8 01 75 7D 48 8B CA E8 ?? ?? ?? ?? 4C 63 C8 48 8D 15 ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? 41 8D 49 02 83 F9 01 76 18 4D 8B C1 49 8B C9 41 83 E0 3F 48 C1 F9 06 49 C1 E0 06 4D 03 04 CA EB 03 4C 8B C2 41 80 78 39 00 75 24 41 8D 41 02 83 F8 01 76 15 49 8B D1 49 8B C1 83 E2 3F 48 C1 F8 06 48 C1 E2 06 49 03 14 C2 F6 42 3D 01 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 6C 83 FF FF 74 F6 8B 43 14 8B 4B 14 A8 01 75 08 83 E1 06 80 F9 06 75 E4 48 83 7B 08 00 75 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 03 48 3B 43 08 75 0C 83 7B 10 00 75 C6 48 FF C0 48 89 03 8B 43 14 48 FF 0B C1 E8 0C A8 01 48 8B 03 74 0D 40 38 38 74 0B 48 FF C0 48 89 03 EB A3 40 88 38 FF 43 10 F0 83 63 14 F7 F0 83 4B 14 01 40 0F B6 C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_10_11_0 {
	meta:
		name = "ungetc"
		size = 95
		refs = "0021 _errno 002c _invalid_parameter_noinfo 0039 _lock_file 0044 _ungetc_nolock 004e _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 54 24 10 57 48 83 EC 20 48 8B DA 8B F9 33 C0 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 1F 48 8B CA E8 ?? ?? ?? ?? 90 48 8B D3 8B CF E8 ?? ?? ?? ?? 8B F8 48 8B CB E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_10_12_0 {
	meta:
		name = "ungetc$fin$0"
		size = 24
		refs = "0013 _unlock_file"
		altNames = "fputwc$fin$0 ungetwc$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 38 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "_wrename"
		size = 45
		refs = "000c __imp_MoveFileExW 0016 __imp_GetLastError 001d __acrt_errno_map_os_error"
	strings:
		$1 = { 48 83 EC 28 41 B8 02 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 83 C8 FF EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "??$common_tcsncpy_s@_W@@YAHQEA_W_KQEB_W1@Z"
		size = 217
		refs = "003f _errno 004b _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 FF 4C 8B D2 4D 85 C9 75 0E 48 85 C9 75 0E 48 85 D2 75 20 33 C0 EB 2F 48 85 C9 74 17 48 85 D2 74 12 4D 85 C9 75 05 66 89 39 EB E8 4D 85 C0 75 21 66 89 39 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 4C 2B C1 48 8B D1 4D 8B DA 49 8B D9 49 83 F9 FF 75 19 41 0F B7 04 10 66 89 02 48 8D 52 02 66 85 C0 74 2D 49 83 EB 01 75 E9 EB 25 41 0F B7 04 10 66 89 02 48 8D 52 02 66 85 C0 74 0C 49 83 EB 01 74 06 48 83 EB 01 75 E3 48 85 DB 75 03 66 89 3A 4D 85 DB 0F 85 69 FF FF FF 49 83 F9 FF 75 0C 66 42 89 7C 51 FE 41 8D 43 50 EB 8A 66 89 39 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 6F FF FF FF }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "wcsncpy_s"
		size = 227
		refs = "0020 _errno 002c _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 45 33 D2 4C 8B DA 4D 85 C9 75 2C 48 85 C9 75 2C 48 85 D2 74 14 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 44 8B D3 41 8B C2 48 8B 5C 24 30 48 83 C4 20 5F C3 48 85 C9 74 D9 48 85 D2 74 D4 4D 85 C9 75 06 66 44 89 11 EB DD 4D 85 C0 75 06 66 44 89 11 EB BE 4C 2B C1 48 8B D1 49 8B DB 49 8B F9 49 83 F9 FF 75 19 41 0F B7 04 10 66 89 02 48 8D 52 02 66 85 C0 74 2E 48 83 EB 01 75 E9 EB 26 41 0F B7 04 10 66 89 02 48 8D 52 02 66 85 C0 74 0C 48 83 EB 01 74 06 48 83 EF 01 75 E3 48 85 FF 75 04 66 44 89 12 48 85 DB 0F 85 78 FF FF FF 49 83 F9 FF 75 0F 66 46 89 54 59 FE 44 8D 53 50 E9 63 FF FF FF 66 44 89 11 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 46 FF FF FF }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "ctanf"
		size = 106
		refs = "000f crealf 001c cimagf 0023 __xmm@80000000800000008000000080000000 002b _FCbuild 0033 ctanhf"
	strings:
		$1 = { 48 83 EC 48 0F 29 74 24 30 48 89 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 0F 57 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "casinf"
		size = 106
		refs = "000f crealf 001c cimagf 0023 __xmm@80000000800000008000000080000000 002b _FCbuild 0033 casinhf"
	strings:
		$1 = { 48 83 EC 48 0F 29 74 24 30 48 89 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 0F 57 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_589_0_0 {
	meta:
		name = "catanf"
		size = 106
		refs = "000f crealf 001c cimagf 0023 __xmm@80000000800000008000000080000000 002b _FCbuild 0033 catanhf"
	strings:
		$1 = { 48 83 EC 48 0F 29 74 24 30 48 89 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 0F 57 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_597_0_0 {
	meta:
		name = "csinf"
		size = 106
		refs = "000f crealf 001c cimagf 0023 __xmm@80000000800000008000000080000000 002b _FCbuild 0033 csinhf"
	strings:
		$1 = { 48 83 EC 48 0F 29 74 24 30 48 89 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 0F 57 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "wcsncmp"
		size = 44
	strings:
		$1 = { 4D 85 C0 75 18 33 C0 C3 0F B7 01 66 85 C0 74 13 66 3B 02 75 0E 48 83 C1 02 48 83 C2 02 49 83 E8 01 75 E5 0F B7 01 0F B7 0A 2B C1 C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "??$common_strtime@D@@YAPEADQEAD@Z"
		size = 36
		refs = "000f ??$common_strtime_s@D@@YAHQEAD_K@Z"
		altNames = "_strtime"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 09 00 00 00 48 8B D9 E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 45 D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "??$common_strdate@D@@YAPEADQEAD@Z"
		size = 36
		refs = "000f ??$common_strdate_s@D@@YAHQEAD_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 09 00 00 00 48 8B D9 E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 45 D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_19_1_3 {
	meta:
		name = "??$common_strdate@_W@@YAPEA_WQEA_W@Z"
		size = 36
		refs = "000f ??$common_strdate_s@_W@@YAHQEA_W_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 09 00 00 00 48 8B D9 E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 45 D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "??$common_strtime@_W@@YAPEA_WQEA_W@Z"
		size = 36
		refs = "000f ??$common_strtime_s@_W@@YAHQEA_W_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 09 00 00 00 48 8B D9 E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 45 D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_19_4_2 {
	meta:
		name = "_strdate"
		size = 36
		refs = "000f ??$common_strdate_s@D@@YAHQEAD_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 09 00 00 00 48 8B D9 E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 45 D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_19_6_4 {
	meta:
		name = "_wstrdate"
		size = 36
		refs = "000f ??$common_strdate_s@_W@@YAHQEA_W_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 09 00 00 00 48 8B D9 E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 45 D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_15_6_3 {
	meta:
		name = "_wstrtime"
		size = 36
		refs = "000f ??$common_strtime_s@_W@@YAHQEA_W_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 09 00 00 00 48 8B D9 E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 45 D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "??$common_strtime_s@D@@YAHQEAD_K@Z"
		size = 279
		refs = "0009 __security_cookie 0034 _errno 0049 __imp_GetLocalTime 00fe _invalid_parameter_noinfo 010d __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 48 8B D9 48 85 C9 0F 84 D0 00 00 00 48 85 D2 0F 84 C7 00 00 00 C6 01 00 48 83 FA 09 73 0F E8 ?? ?? ?? ?? BB 22 00 00 00 E9 B9 00 00 00 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 0F B7 4C 24 28 41 B3 30 44 0F B7 44 24 2A 41 BA 67 66 66 66 44 0F B7 4C 24 2C 41 8B C2 F7 E9 C6 43 02 3A C1 FA 02 8B C2 C6 43 05 3A C1 E8 1F 03 D0 C6 43 08 00 41 8D 04 13 88 03 8A C2 C0 E2 02 02 C2 02 C0 2A C8 41 8B C2 41 F7 E8 41 02 CB C1 FA 02 8B C2 88 4B 01 C1 E8 1F 03 D0 41 8B C2 41 8D 0C 13 88 4B 03 8A CA C0 E2 02 02 CA 41 F7 E9 02 C9 C1 FA 02 44 2A C1 8B C2 45 02 C3 C1 E8 1F 03 D0 44 88 43 04 41 8D 04 13 88 43 06 8A C2 C0 E2 02 02 C2 02 C0 44 2A C8 45 02 CB 44 88 4B 07 33 C0 EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "??$common_strtime_s@_W@@YAHQEA_W_K@Z"
		size = 316
		refs = "000d __security_cookie 003a _errno 004d __imp_GetLocalTime 011e _invalid_parameter_noinfo 012d __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 56 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 33 F6 48 8B D9 48 85 C9 0F 84 EA 00 00 00 48 85 D2 0F 84 E1 00 00 00 66 89 31 48 83 FA 09 73 0D E8 ?? ?? ?? ?? 8D 5E 22 E9 D5 00 00 00 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 0F B7 4C 24 28 41 BB 67 66 66 66 44 0F B7 44 24 2A 41 8B C3 44 0F B7 4C 24 2C 41 BA 3A 00 00 00 F7 E9 66 44 89 53 04 C1 FA 02 8B C2 66 44 89 53 0A C1 E8 1F 03 D0 66 89 73 10 8D 42 30 66 89 03 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 2B C8 41 8B C3 41 F7 E8 66 83 C1 30 C1 FA 02 8B C2 66 89 4B 02 C1 E8 1F 03 D0 0F B7 CA 8D 42 30 66 C1 E2 02 66 89 43 06 66 03 CA 66 03 C9 41 8B C3 41 F7 E9 66 44 2B C1 C1 FA 02 66 41 83 C0 30 8B C2 66 44 89 43 08 C1 E8 1F 03 D0 8D 42 30 66 89 43 0C 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 44 2B C8 66 41 83 C1 30 66 44 89 4B 0E 33 C0 EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 83 C4 40 5E C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "floorf"
		size = 130
		refs = "002a _handle_nanf 0042 __real@bf800000 007d __real@3f800000"
	strings:
		$1 = { 45 33 C0 F3 0F 11 44 24 08 8B 54 24 08 8B C2 0F BA F0 1F 3B D0 41 0F 95 C0 3D 00 00 80 4B 72 0E 3D 00 00 80 7F 76 5A 8B CA E9 ?? ?? ?? ?? 3D 00 00 80 3F 73 18 85 C0 74 48 45 85 C0 74 0A F3 0F 10 05 ?? ?? ?? ?? EB 39 0F 57 C0 EB 34 8B C2 B9 96 00 00 00 C1 E8 17 2B C8 B8 01 00 00 00 D3 E0 FF C8 F7 D0 23 C2 89 44 24 08 F3 0F 10 44 24 08 45 85 C0 74 0C 3B D0 74 08 F3 0F 5C 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "_cputs"
		size = 120
		refs = "001c __doserrno 0023 _errno 002e _invalid_parameter_noinfo 003d __acrt_lock 004f _putch_nolock 0067 __acrt_unlock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 48 8B F9 33 DB 8B C3 48 85 C9 0F 95 C0 85 C0 75 1C E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 36 B9 09 00 00 00 E8 ?? ?? ?? ?? 90 48 89 7C 24 20 38 1F 74 16 0F BE 0F E8 ?? ?? ?? ?? 83 F8 FF 75 04 0B D8 EB 05 48 FF C7 EB E1 B9 09 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "_cputs$fin$0"
		size = 25
		refs = "0014 __acrt_unlock"
		altNames = "_cgets_s$fin$0 _getch$fin$0 _getche$fin$0 _getwch$fin$0 _getwche$fin$0 _kbhit$fin$0 _ungetch$fin$0 _ungetwch$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 09 00 00 00 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_18_5_0 {
	meta:
		name = "_mbsnbcnt_l"
		size = 147
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0033 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 85 FF 75 19 48 85 DB 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 D2 EB 37 48 8B D7 48 85 DB 74 2C 48 8B 4C 24 30 48 FF CB 80 3A 00 74 1F 0F B6 02 F6 44 08 19 04 74 08 48 FF C2 80 3A 00 74 0A 48 FF C2 48 85 DB 74 05 EB DC 48 FF CA 48 2B D7 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B C2 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_19_2_0 {
	meta:
		name = "??$common_strdate_s@D@@YAHQEAD_K@Z"
		size = 303
		refs = "0009 __security_cookie 0034 _errno 0049 __imp_GetLocalTime 0116 _invalid_parameter_noinfo 0125 __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 48 8B D9 48 85 C9 0F 84 E8 00 00 00 48 85 D2 0F 84 DF 00 00 00 C6 01 00 48 83 FA 09 73 0F E8 ?? ?? ?? ?? BB 22 00 00 00 E9 D1 00 00 00 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 0F B7 4C 24 22 41 B3 30 44 0F B7 4C 24 20 41 BA 67 66 66 66 44 0F B7 44 24 26 B8 1F 85 EB 51 41 F7 E9 C6 43 02 2F C1 FA 05 8B C2 C6 43 05 2F C1 E8 1F 03 D0 C6 43 08 00 6B C2 64 44 2B C8 41 8B C2 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 41 8D 04 13 88 03 8A C2 C0 E2 02 02 C2 02 C0 2A C8 41 8B C2 41 F7 E8 41 02 CB C1 FA 02 8B C2 88 4B 01 C1 E8 1F 03 D0 41 8B C2 41 8D 0C 13 88 4B 03 8A CA C0 E2 02 02 CA 41 F7 E9 02 C9 C1 FA 02 44 2A C1 8B C2 45 02 C3 C1 E8 1F 03 D0 44 88 43 04 41 8D 04 13 88 43 06 8A C2 C0 E2 02 02 C2 02 C0 44 2A C8 45 02 CB 44 88 4B 07 33 C0 EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_19_3_0 {
	meta:
		name = "??$common_strdate_s@_W@@YAHQEA_W_K@Z"
		size = 340
		refs = "000d __security_cookie 003a _errno 004d __imp_GetLocalTime 0136 _invalid_parameter_noinfo 0145 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 56 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 33 F6 48 8B D9 48 85 C9 0F 84 02 01 00 00 48 85 D2 0F 84 F9 00 00 00 66 89 31 48 83 FA 09 73 0D E8 ?? ?? ?? ?? 8D 5E 22 E9 ED 00 00 00 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 44 0F B7 4C 24 20 41 BB 67 66 66 66 0F B7 4C 24 22 B8 1F 85 EB 51 44 0F B7 44 24 26 41 BA 2F 00 00 00 41 F7 E9 66 44 89 53 04 C1 FA 05 8B C2 66 44 89 53 0A C1 E8 1F 03 D0 66 89 73 10 6B C2 64 44 2B C8 41 8B C3 F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 42 30 66 89 03 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 2B C8 41 8B C3 41 F7 E8 66 83 C1 30 C1 FA 02 8B C2 66 89 4B 02 C1 E8 1F 03 D0 0F B7 CA 8D 42 30 66 C1 E2 02 66 89 43 06 66 03 CA 66 03 C9 41 8B C3 41 F7 E9 66 44 2B C1 C1 FA 02 66 41 83 C0 30 8B C2 66 44 89 43 08 C1 E8 1F 03 D0 8D 42 30 66 89 43 0C 0F B7 C2 66 C1 E2 02 66 03 C2 66 03 C0 66 44 2B C8 66 41 83 C1 30 66 44 89 4B 0E 33 C0 EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 83 C4 40 5E C3 }
	condition:
		$1
}

rule file_20_3_0 {
	meta:
		name = "??1?$__crt_scoped_stack_ptr@_W@@QEAA@XZ"
		size = 34
		refs = "0019 _free_base"
		altNames = "??1?$__crt_scoped_stack_ptr@D@@QEAA@XZ ??1?$__crt_scoped_stack_ptr@U_INPUT_RECORD@@@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8B 09 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_9_0 {
	meta:
		name = "__acrt_GetStringTypeA"
		size = 433
		refs = "0022 __security_cookie 003e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0075 __imp_MultiByteToWideChar 00d6 __chkstk 00f9 _malloc_base 0121 memset 0158 __imp_GetStringTypeW 0174 _free_base 0193 __security_check_cookie"
	strings:
		$1 = { 40 55 41 54 41 55 41 56 41 57 48 83 EC 60 48 8D 6C 24 30 48 89 5D 60 48 89 75 68 48 89 7D 70 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 20 44 8B EA 45 8B F9 48 8B D1 4D 8B E0 48 8D 4D 00 E8 ?? ?? ?? ?? 8B B5 88 00 00 00 85 F6 75 07 48 8B 45 08 8B 70 0C F7 9D 90 00 00 00 45 8B CF 4D 8B C4 8B CE 1B D2 83 64 24 28 00 48 83 64 24 20 00 83 E2 08 FF C2 FF 15 ?? ?? ?? ?? 4C 63 F0 85 C0 75 07 33 FF E9 F1 00 00 00 49 8B FE 48 03 FF 48 8D 4F 10 48 3B F9 48 1B C0 48 85 C1 74 75 48 8D 4F 10 48 3B F9 48 1B C0 48 23 C1 48 3D 00 04 00 00 48 8D 47 10 77 3A 48 3B F8 48 1B C9 48 23 C8 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 5C 24 30 48 85 DB 74 79 C7 03 CC CC 00 00 EB 1C 48 3B F8 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0E C7 00 DD DD 00 00 48 83 C3 10 EB 02 33 DB 48 85 DB 74 48 4C 8B C7 33 D2 48 8B CB E8 ?? ?? ?? ?? 45 8B CF 44 89 74 24 28 4D 8B C4 48 89 5C 24 20 BA 01 00 00 00 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 1A 4C 8B 8D 80 00 00 00 44 8B C0 48 8B D3 41 8B CD FF 15 ?? ?? ?? ?? 8B F8 EB 02 33 FF 48 85 DB 74 11 48 8D 4B F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 80 7D 18 00 74 0B 48 8B 45 00 83 A0 A8 03 00 00 FD 8B C7 48 8B 4D 20 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 60 48 8B 75 68 48 8B 7D 70 48 8D 65 30 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_20_11_0 {
	meta:
		name = "_freea_crt"
		size = 31
		refs = "0016 _free_base"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "wcscspn"
		size = 63
	strings:
		$1 = { 45 33 D2 4C 8B CA 66 44 39 11 48 8B C1 74 29 4D 8B C1 66 45 39 11 74 16 41 0F B7 11 66 39 10 74 17 49 83 C0 02 41 0F B7 10 66 85 D2 75 EE 48 83 C0 02 66 44 39 10 EB D5 48 2B C1 48 D1 F8 C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_FHypot"
		size = 482
		refs = "002b _fdunscale 008b __xmm@80000000800000008000000080000000 0115 _fdscale 0159 __real@3f800000 015e sqrtf 017d __real@40000000 0199 __real@3fb504f3 01a5 __real@376389f3 01b6 __real@401a8241 01cc _FInf_C"
	strings:
		$1 = { 48 8B C4 F3 0F 11 48 10 F3 0F 11 40 08 55 53 57 48 8B EC 48 83 EC 40 0F 29 70 D8 48 8D 55 20 48 8D 4D 30 0F 29 78 C8 49 8B F8 E8 ?? ?? ?? ?? 48 8D 55 28 0F B7 D8 48 8D 4D 38 E8 ?? ?? ?? ?? 83 27 00 66 83 FB 01 0F 84 7C 01 00 00 66 83 F8 01 0F 84 72 01 00 00 41 B8 02 00 00 00 66 41 3B D8 75 0A F3 0F 10 45 20 E9 64 01 00 00 66 41 3B C0 75 0A F3 0F 10 45 28 E9 54 01 00 00 F3 0F 10 4D 20 0F 57 C0 0F 2F C1 F3 0F 10 1D ?? ?? ?? ?? 76 08 0F 57 CB F3 0F 11 4D 20 F3 0F 10 55 28 0F 2F C2 76 08 0F 57 D3 F3 0F 11 55 28 0F 2E D0 7A 13 75 11 0F 2E C8 7A 06 0F 84 13 01 00 00 0F B7 4D 30 EB 33 0F 2E C8 0F B7 4D 30 0F B7 55 38 7A 02 74 0C 66 3B CA 7C 07 75 1D 0F 2F D1 76 18 0F B7 C1 F3 0F 11 55 20 66 89 45 38 0F B7 CA F3 0F 11 4D 28 66 89 55 30 0F BF C9 8B C1 99 83 E2 03 03 C2 C1 F8 02 03 C0 41 0F 44 C0 2B C8 89 07 8B D1 48 8D 4D 20 E8 ?? ?? ?? ?? 0F BF 55 38 48 8D 4D 28 2B 17 E8 ?? ?? ?? ?? F3 0F 10 7D 20 F3 0F 5C 7D 28 0F 2E 7D 20 7A 06 0F 84 85 00 00 00 0F 2F 7D 28 76 2D F3 0F 10 75 20 F3 0F 5E 75 28 0F 28 C6 F3 0F 59 C6 F3 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F3 0F 10 7D 28 F3 0F 58 C6 F3 0F 5E F8 EB 4D F3 0F 5E 7D 28 0F 28 F7 F3 0F 58 35 ?? ?? ?? ?? F3 0F 59 F7 0F 28 C6 F3 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 5E F0 F3 0F 58 35 ?? ?? ?? ?? F3 0F 58 F7 F3 0F 10 7D 28 F3 0F 58 35 ?? ?? ?? ?? F3 0F 5E FE F3 0F 58 7D 20 0F 28 C7 EB 08 F3 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 40 5F 5B 5D C3 }
	condition:
		$1
}

rule file_22_1_0 {
	meta:
		name = "csqrtf"
		size = 443
		refs = "0015 crealf 0023 cimagf 0031 _fdtest 006d _FHypot 0092 __xmm@7fffffff7fffffff7fffffff7fffffff 009c ldexp 00ac __real@40000000 00b5 sqrtf 0113 __xmm@80000000800000008000000080000000 0176 _FInf_C 0193 _FZero_C 01aa _FCbuild"
	strings:
		$1 = { 40 55 53 57 48 8B EC 48 83 EC 40 0F 29 74 24 30 48 89 4D E0 E8 ?? ?? ?? ?? 48 8B 4D E0 F3 0F 11 45 30 E8 ?? ?? ?? ?? 48 8D 4D 28 F3 0F 11 45 28 E8 ?? ?? ?? ?? BF 01 00 00 00 0F B7 D8 66 3B C7 75 0A F3 0F 10 4D 28 E9 55 01 00 00 48 8D 4D 30 E8 ?? ?? ?? ?? 66 3B C7 0F 84 E8 00 00 00 F3 0F 10 4D 28 4C 8D 45 38 F3 0F 10 45 30 E8 ?? ?? ?? ?? 8B 5D 38 0F 28 F0 85 DB 75 0D 0F 28 C8 F3 0F 59 4D 28 E9 21 01 00 00 F3 0F 10 45 30 8B D3 0F 54 05 ?? ?? ?? ?? F7 DA 0F 5A C0 E8 ?? ?? ?? ?? F2 0F 5A C0 F3 0F 58 C6 F3 0F 10 35 ?? ?? ?? ?? F3 0F 59 C6 E8 ?? ?? ?? ?? 8B C3 99 2B C2 D1 F8 2B C7 F3 0F 5A C0 8B D0 E8 ?? ?? ?? ?? F3 0F 10 4D 30 0F 57 D2 0F 2F CA 0F 57 DB F2 0F 5A D8 72 18 F3 0F 10 4D 28 0F 28 D3 F3 0F 59 D6 0F 28 C3 F3 0F 5E CA E9 B0 00 00 00 F3 0F 10 45 28 B8 00 80 00 00 66 85 45 2A 74 1E 0F 28 CB F3 0F 59 DE 0F 57 0D ?? ?? ?? ?? F3 0F 5E C3 0F 57 05 ?? ?? ?? ?? E9 82 00 00 00 0F 2E C2 7A 0A 75 08 0F 28 CB 0F 28 C2 EB 73 0F 28 CB F3 0F 59 CE F3 0F 5E C1 0F 28 CB EB 63 0F 57 C0 66 83 FB 02 75 18 0F 2F 45 30 76 0C F3 0F 10 4D 30 F3 0F 10 45 28 EB 48 48 8B 45 E0 EB 47 0F 2F 45 30 B8 00 80 00 00 76 17 F3 0F 10 0D ?? ?? ?? ?? 66 85 45 2A 74 29 0F 57 0D ?? ?? ?? ?? EB 20 66 85 45 2A 74 0F F3 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 0F 28 C8 F3 0F 10 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 40 5F 5B 5D C3 }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "ldexpf"
		size = 22
		refs = "0009 ldexp"
	strings:
		$1 = { 48 83 EC 28 F3 0F 5A C0 E8 ?? ?? ?? ?? F2 0F 5A C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "??$common_tox_l@$1?internal_islower_l@@YA_NHQEAU__crt_locale_pointers@@@Z$1?internal_map_upper@@YAHH0@Z@@YAHHKQEAU__crt_locale_pointers@@@Z"
		size = 317
		refs = "001e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0031 ?internal_islower_l@@YA_NHQEAU__crt_locale_pointers@@@Z 0086 _isleadbyte_l 00a2 _errno 00fd __acrt_LCMapStringA"
	strings:
		$1 = { 48 89 74 24 10 55 57 41 56 48 8B EC 48 83 EC 70 44 8B F2 48 63 F9 49 8B D0 48 8D 4D E0 E8 ?? ?? ?? ?? 81 FF 00 01 00 00 73 3B 48 8D 55 E8 8B CF E8 ?? ?? ?? ?? 84 C0 74 14 48 8B 45 E8 48 8B 88 18 01 00 00 0F B6 04 39 E9 CE 00 00 00 80 7D F8 00 74 0B 48 8B 45 E0 83 A0 A8 03 00 00 FD 8B C7 E9 C7 00 00 00 33 C0 66 89 45 20 88 45 22 48 8B 45 E8 83 78 08 01 7E 29 8B F7 48 8D 55 E8 C1 FE 08 40 0F B6 CE E8 ?? ?? ?? ?? 85 C0 74 13 40 88 75 20 B9 02 00 00 00 40 88 7D 21 C6 45 22 00 EB 18 E8 ?? ?? ?? ?? B9 01 00 00 00 C7 00 2A 00 00 00 40 88 7D 20 C6 45 21 00 48 8B 55 E8 4C 8D 4D 20 33 C0 C7 44 24 40 01 00 00 00 66 89 45 38 45 8B C6 88 45 3A 8B 42 0C 48 8B 92 38 01 00 00 89 44 24 38 48 8D 45 38 C7 44 24 30 03 00 00 00 48 89 44 24 28 89 4C 24 20 48 8D 4D E8 E8 ?? ?? ?? ?? 85 C0 0F 84 44 FF FF FF 83 F8 01 0F B6 45 38 74 09 0F B6 4D 39 C1 E0 08 0B C1 80 7D F8 00 74 0B 48 8B 4D E0 83 A1 A8 03 00 00 FD 48 8B B4 24 98 00 00 00 48 83 C4 70 41 5E 5F 5D C3 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "??$common_tox_l@$1?internal_isupper_l@@YA_NHQEAU__crt_locale_pointers@@@Z$1?internal_map_lower@@YAHH0@Z@@YAHHKQEAU__crt_locale_pointers@@@Z"
		size = 317
		refs = "001e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0031 ?internal_isupper_l@@YA_NHQEAU__crt_locale_pointers@@@Z 0086 _isleadbyte_l 00a2 _errno 00fd __acrt_LCMapStringA"
	strings:
		$1 = { 48 89 74 24 10 55 57 41 56 48 8B EC 48 83 EC 70 44 8B F2 48 63 F9 49 8B D0 48 8D 4D E0 E8 ?? ?? ?? ?? 81 FF 00 01 00 00 73 3B 48 8D 55 E8 8B CF E8 ?? ?? ?? ?? 84 C0 74 14 48 8B 45 E8 48 8B 88 10 01 00 00 0F B6 04 39 E9 CE 00 00 00 80 7D F8 00 74 0B 48 8B 45 E0 83 A0 A8 03 00 00 FD 8B C7 E9 C7 00 00 00 33 C0 66 89 45 20 88 45 22 48 8B 45 E8 83 78 08 01 7E 29 8B F7 48 8D 55 E8 C1 FE 08 40 0F B6 CE E8 ?? ?? ?? ?? 85 C0 74 13 40 88 75 20 B9 02 00 00 00 40 88 7D 21 C6 45 22 00 EB 18 E8 ?? ?? ?? ?? B9 01 00 00 00 C7 00 2A 00 00 00 40 88 7D 20 C6 45 21 00 48 8B 55 E8 4C 8D 4D 20 33 C0 C7 44 24 40 01 00 00 00 66 89 45 38 45 8B C6 88 45 3A 8B 42 0C 48 8B 92 38 01 00 00 89 44 24 38 48 8D 45 38 C7 44 24 30 03 00 00 00 48 89 44 24 28 89 4C 24 20 48 8D 4D E8 E8 ?? ?? ?? ?? 85 C0 0F 84 44 FF FF FF 83 F8 01 0F B6 45 38 74 09 0F B6 4D 39 C1 E0 08 0B C1 80 7D F8 00 74 0B 48 8B 4D E0 83 A1 A8 03 00 00 FD 48 8B B4 24 98 00 00 00 48 83 C4 70 41 5E 5F 5D C3 }
	condition:
		$1
}

rule file_23_5_0 {
	meta:
		name = "?internal_islower_l@@YA_NHQEAU__crt_locale_pointers@@@Z"
		size = 77
		refs = "0026 _isctype_l 0032 __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 63 F9 48 85 D2 74 1F 48 8B 02 83 78 08 01 7E 11 4C 8B C2 8B CF BA 02 00 00 00 E8 ?? ?? ?? ?? EB 11 48 8B 00 EB 05 E8 ?? ?? ?? ?? 0F B7 04 78 83 E0 02 48 8B 5C 24 30 85 C0 0F 95 C0 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_23_6_0 {
	meta:
		name = "?internal_isupper_l@@YA_NHQEAU__crt_locale_pointers@@@Z"
		size = 77
		refs = "0026 _isctype_l 0032 __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 63 F9 48 85 D2 74 1F 48 8B 02 83 78 08 01 7E 11 4C 8B C2 8B CF BA 01 00 00 00 E8 ?? ?? ?? ?? EB 11 48 8B 00 EB 05 E8 ?? ?? ?? ?? 0F B7 04 78 83 E0 01 48 8B 5C 24 30 85 C0 0F 95 C0 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_23_7_0 {
	meta:
		name = "?internal_map_lower@@YAHHQEAU__crt_locale_pointers@@@Z"
		size = 18
	strings:
		$1 = { 48 8B 02 48 63 C9 48 8B 80 10 01 00 00 0F B6 04 08 C3 }
	condition:
		$1
}

rule file_23_8_0 {
	meta:
		name = "?internal_map_upper@@YAHHQEAU__crt_locale_pointers@@@Z"
		size = 18
	strings:
		$1 = { 48 8B 02 48 63 C9 48 8B 80 18 01 00 00 0F B6 04 08 C3 }
	condition:
		$1
}

rule file_23_14_0 {
	meta:
		name = "_tolower_l"
		size = 318
		refs = "001a ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002d ?internal_isupper_l@@YA_NHQEAU__crt_locale_pointers@@@Z 007f _isleadbyte_l 009a _errno 00f7 __acrt_LCMapStringA"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 20 55 48 8B EC 48 83 EC 70 48 63 D9 48 8D 4D E0 E8 ?? ?? ?? ?? 81 FB 00 01 00 00 73 38 48 8D 55 E8 8B CB E8 ?? ?? ?? ?? 84 C0 74 0F 48 8B 45 E8 48 8B 88 10 01 00 00 0F B6 1C 19 80 7D F8 00 0F 84 DC 00 00 00 48 8B 45 E0 83 A0 A8 03 00 00 FD E9 CC 00 00 00 33 C0 66 89 45 10 88 45 12 48 8B 45 E8 83 78 08 01 7E 28 8B F3 48 8D 55 E8 C1 FE 08 40 0F B6 CE E8 ?? ?? ?? ?? 85 C0 74 12 40 88 75 10 B9 02 00 00 00 88 5D 11 C6 45 12 00 EB 17 E8 ?? ?? ?? ?? B9 01 00 00 00 C7 00 2A 00 00 00 88 5D 10 C6 45 11 00 48 8B 55 E8 4C 8D 4D 10 33 C0 C7 44 24 40 01 00 00 00 66 89 45 20 41 B8 00 01 00 00 88 45 22 8B 42 0C 48 8B 92 38 01 00 00 89 44 24 38 48 8D 45 20 C7 44 24 30 03 00 00 00 48 89 44 24 28 89 4C 24 20 48 8D 4D E8 E8 ?? ?? ?? ?? 85 C0 0F 84 41 FF FF FF 0F B6 5D 20 83 F8 01 0F 84 34 FF FF FF 0F B6 4D 21 C1 E3 08 0B D9 80 7D F8 00 74 0B 48 8B 4D E0 83 A1 A8 03 00 00 FD 4C 8D 5C 24 70 8B C3 49 8B 5B 18 49 8B 73 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_23_16_0 {
	meta:
		name = "_toupper_l"
		size = 318
		refs = "001a ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002d ?internal_islower_l@@YA_NHQEAU__crt_locale_pointers@@@Z 007f _isleadbyte_l 009a _errno 00f7 __acrt_LCMapStringA"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 20 55 48 8B EC 48 83 EC 70 48 63 D9 48 8D 4D E0 E8 ?? ?? ?? ?? 81 FB 00 01 00 00 73 38 48 8D 55 E8 8B CB E8 ?? ?? ?? ?? 84 C0 74 0F 48 8B 45 E8 48 8B 88 18 01 00 00 0F B6 1C 19 80 7D F8 00 0F 84 DC 00 00 00 48 8B 45 E0 83 A0 A8 03 00 00 FD E9 CC 00 00 00 33 C0 66 89 45 10 88 45 12 48 8B 45 E8 83 78 08 01 7E 28 8B F3 48 8D 55 E8 C1 FE 08 40 0F B6 CE E8 ?? ?? ?? ?? 85 C0 74 12 40 88 75 10 B9 02 00 00 00 88 5D 11 C6 45 12 00 EB 17 E8 ?? ?? ?? ?? B9 01 00 00 00 C7 00 2A 00 00 00 88 5D 10 C6 45 11 00 48 8B 55 E8 4C 8D 4D 10 33 C0 C7 44 24 40 01 00 00 00 66 89 45 20 41 B8 00 02 00 00 88 45 22 8B 42 0C 48 8B 92 38 01 00 00 89 44 24 38 48 8D 45 20 C7 44 24 30 03 00 00 00 48 89 44 24 28 89 4C 24 20 48 8D 4D E8 E8 ?? ?? ?? ?? 85 C0 0F 84 41 FF FF FF 0F B6 5D 20 83 F8 01 0F 84 34 FF FF FF 0F B6 4D 21 C1 E3 08 0B D9 80 7D F8 00 74 0B 48 8B 4D E0 83 A1 A8 03 00 00 FD 4C 8D 5C 24 70 8B C3 49 8B 5B 18 49 8B 73 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_23_17_0 {
	meta:
		name = "tolower"
		size = 42
		refs = "0006 __acrt_locale_changed_data 0010 _tolower_l"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? 00 74 0B 33 D2 E8 ?? ?? ?? ?? 8B C8 EB 0B 8D 41 BF 83 F8 19 77 03 83 C1 20 8B C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_18_0 {
	meta:
		name = "toupper"
		size = 42
		refs = "0006 __acrt_locale_changed_data 0010 _toupper_l"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? 00 74 0B 33 D2 E8 ?? ?? ?? ?? 8B C8 EB 0B 8D 41 9F 83 F8 19 77 03 83 C1 E0 8B C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "_cos_special"
		size = 18
		refs = "0009 ??_C@_03LALBNOCG@cos?$AA@ 000e _sincos_special"
	strings:
		$1 = { 41 B8 12 00 00 00 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_1_0 {
	meta:
		name = "_cosf_special"
		size = 18
		refs = "0009 ??_C@_04OBBKPIAC@cosf?$AA@ 000e _sincosf_special"
	strings:
		$1 = { 41 B8 12 00 00 00 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_2_0 {
	meta:
		name = "_sin_special"
		size = 18
		refs = "0009 ??_C@_03BLEJJJBH@sin?$AA@ 000e _sincos_special"
	strings:
		$1 = { 41 B8 1E 00 00 00 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_5_0 {
	meta:
		name = "_sinf_special"
		size = 18
		refs = "0009 ??_C@_04LAGPAAHP@sinf?$AA@ 000e _sincosf_special"
	strings:
		$1 = { 41 B8 1E 00 00 00 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_3_0 {
	meta:
		name = "_sincos_special"
		size = 162
		refs = "007f _handle_error"
	strings:
		$1 = { 48 83 EC 58 F2 0F 11 44 24 60 4C 8B DA 48 8B 44 24 60 48 BA 00 00 00 00 00 00 F0 7F 48 8B C8 45 8B D0 48 23 CA 0F 28 C8 48 3B CA 75 6A 48 B9 FF FF FF FF FF FF 0F 00 48 85 C1 75 49 48 B8 00 00 00 00 00 00 F8 FF 41 B9 01 00 00 00 44 89 4C 24 40 0F 57 C0 F2 0F 11 44 24 38 4C 8B C0 F2 0F 11 4C 24 30 41 8B D2 C7 44 24 28 21 00 00 00 49 8B CB C7 44 24 20 08 00 00 00 48 89 44 24 60 E8 ?? ?? ?? ?? EB 12 48 B9 00 00 00 00 00 00 08 00 48 0B C1 48 89 44 24 60 F2 0F 10 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_24_4_0 {
	meta:
		name = "_sincosf_special"
		size = 137
		refs = "0070 _handle_errorf"
	strings:
		$1 = { 48 83 EC 58 48 83 64 24 78 00 0F 28 C8 F3 0F 11 4C 24 78 4C 8B DA 8B 4C 24 78 BA 00 00 80 7F 8B C1 45 8B D0 23 C2 3B C2 75 54 F7 C1 FF FF 7F 00 75 44 41 B9 01 00 00 00 C7 44 24 78 00 00 C0 FF 4C 8B 44 24 78 0F 57 C0 44 89 4C 24 40 41 8B D2 F3 0F 11 44 24 38 49 8B CB F3 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 E8 ?? ?? ?? ?? EB 08 0F BA E9 16 89 4C 24 78 F3 0F 10 44 24 78 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_24_6_0 {
	meta:
		name = "_tan_special"
		size = 18
		refs = "0009 ??_C@_03IIINPABG@tan?$AA@ 000e _sincos_special"
	strings:
		$1 = { 41 B8 20 00 00 00 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_7_0 {
	meta:
		name = "_tanf_special"
		size = 18
		refs = "0009 ??_C@_04MHPLPEIA@tanf?$AA@ 000e _sincosf_special"
	strings:
		$1 = { 41 B8 20 00 00 00 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_31_0 {
	meta:
		name = "?__acrt_stdio_reset_buffer@@YAXV__crt_stdio_stream@@@Z"
		size = 22
	strings:
		$1 = { 48 89 4C 24 08 48 8B 41 08 48 89 01 48 8B 44 24 08 83 60 10 00 C3 }
	condition:
		$1
}

rule file_25_33_0 {
	meta:
		name = "?common_flush_all@@YAH_N@Z"
		size = 93
		refs = "0048 ??$?RV<lambda_886d6c58226a84441f68b9f2b8217b83>@@AEAV<lambda_ab61a845afdef5b7c387490eaf3616ee>@@V<lambda_f7f22ab5edc0698d5f6905b0d3f44752>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_886d6c58226a84441f68b9f2b8217b83>@@AEAV<lambda_ab61a845afdef5b7c387490eaf3616ee>@@$$QEAV<lambda_f7f22ab5edc0698d5f6905b0d3f44752>@@@Z"
	strings:
		$1 = { 88 4C 24 08 55 48 8B EC 48 83 EC 40 83 65 28 00 48 8D 45 28 83 65 20 00 4C 8D 4D E0 48 89 45 E8 4C 8D 45 E8 48 8D 45 10 48 89 45 F0 48 8D 55 E4 48 8D 45 20 48 89 45 F8 48 8D 4D 18 B8 08 00 00 00 89 45 E0 89 45 E4 E8 ?? ?? ?? ?? 80 7D 10 00 8B 45 20 0F 45 45 28 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_25_34_0 {
	meta:
		name = "?common_flush_all_should_try_to_flush_stream@@YA_NV__crt_stdio_stream@@QEAH@Z"
		size = 50
	strings:
		$1 = { 4C 8B C2 48 85 C9 75 03 32 C0 C3 8B 51 14 8B C2 C1 E8 0D A8 01 74 F1 8B C2 24 03 3C 02 75 05 F6 C2 C0 75 0B 0F BA E2 0B 72 05 41 FF 00 EB D9 B0 01 C3 }
	condition:
		$1
}

rule file_25_38_0 {
	meta:
		name = "?is_stream_flushable@@YA_NJ@Z"
		size = 18
	strings:
		$1 = { 8B C1 24 03 3C 02 74 03 32 C0 C3 F6 C1 C0 0F 95 C0 C3 }
	condition:
		$1
}

rule file_25_39_0 {
	meta:
		name = "?is_stream_flushable_or_commitable@@YA_NJ@Z"
		size = 25
	strings:
		$1 = { 8B C1 24 03 3C 02 75 08 F6 C1 C0 74 03 B0 01 C3 C1 E9 0B 80 E1 01 8A C1 C3 }
	condition:
		$1
}

rule file_25_44_0 {
	meta:
		name = "__acrt_stdio_flush_nolock"
		size = 122
		refs = "003a _fileno 0047 _write"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B D9 8B 49 14 8B C1 24 03 3C 02 75 4B F6 C1 C0 74 46 8B 3B 2B 7B 08 83 63 10 00 48 8B 73 08 48 89 33 85 FF 7E 32 48 8B CB E8 ?? ?? ?? ?? 8B C8 44 8B C7 48 8B D6 E8 ?? ?? ?? ?? 3B F8 74 0A F0 83 4B 14 10 83 C8 FF EB 11 8B 43 14 C1 E8 02 A8 01 74 05 F0 83 63 14 FD 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_25_45_0 {
	meta:
		name = "_fflush_nolock"
		size = 75
		refs = "0014 ?common_flush_all@@YAH_N@Z 0019 __acrt_stdio_flush_nolock 0034 _fileno 003b _commit"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 C9 75 0A 48 83 C4 20 5B E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 05 83 C8 FF EB 1F 8B 43 14 C1 E8 0B A8 01 74 13 48 8B CB E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 85 C0 75 DE 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_25_47_0 {
	meta:
		name = "fflush"
		size = 102
		refs = "000f ?common_flush_all@@YAH_N@Z 005d ??$?RV<lambda_c376a267cfb53b6959b3b692ec76b120>@@AEAV<lambda_9a32fed5bf61b6b509b2d3f6003082a1>@@V<lambda_572fbb9fa0ab338edf41edfd4b5fcc8d>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_c376a267cfb53b6959b3b692ec76b120>@@AEAV<lambda_9a32fed5bf61b6b509b2d3f6003082a1>@@$$QEAV<lambda_572fbb9fa0ab338edf41edfd4b5fcc8d>@@@Z"
	strings:
		$1 = { 48 83 EC 38 48 89 4C 24 48 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 4C 8B 51 14 8B C2 24 03 3C 02 75 05 F6 C2 C0 75 0A 0F BA E2 0B 72 04 33 C0 EB 32 48 8D 44 24 48 48 89 44 24 58 4C 8D 4C 24 50 48 8B 44 24 48 4C 8D 44 24 58 48 8D 54 24 20 48 89 44 24 50 48 8D 4C 24 40 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@P6AHPEAU_exception@@@Z@@YAP6AHPEAU_exception@@@ZQ6AH0@Z@Z"
		size = 22
		refs = "0003 __security_cookie"
		altNames = "??$__crt_fast_decode_pointer@P6AHPEA_WK_J@Z@@YAP6AHPEA_WK_J@ZQ6AH0K1@Z@Z ??$__crt_fast_decode_pointer@P6AH_K@Z@@YAP6AH_K@ZQ6AH0@Z@Z ??$__crt_fast_decode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z ??$__crt_fast_decode_pointer@P6AXPEAXK0@Z@@YAP6AXPEAXK0@ZQ6AX0K0@Z@Z ??$__crt_fast_decode_pointer@P6AXPEB_W00I_K@Z@@YAP6AXPEB_W00I_K@ZQ6AX000I1@Z@Z ??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z ??$__crt_fast_decode_pointer@PEAX@@YAPEAXQEAX@Z"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8B D1 8B C8 48 33 C2 83 E1 3F 48 D3 C8 C3 }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@P6AHPEAU_exception@@@Z@@YAP6AHPEAU_exception@@@ZQ6AH0@Z@Z"
		size = 30
		refs = "0003 __security_cookie"
		altNames = "??$__crt_fast_encode_pointer@P6AHPEA_WK_J@Z@@YAP6AHPEA_WK_J@ZQ6AH0K1@Z@Z ??$__crt_fast_encode_pointer@P6AHXZ@@YAP6AHXZQ6AHXZ@Z ??$__crt_fast_encode_pointer@P6AH_K@Z@@YAP6AH_K@ZQ6AH0@Z@Z ??$__crt_fast_encode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z ??$__crt_fast_encode_pointer@P6AXPEAXK0@Z@@YAP6AXPEAXK0@ZQ6AX0K0@Z@Z ??$__crt_fast_encode_pointer@P6AXPEB_W00I_K@Z@@YAP6AXPEB_W00I_K@ZQ6AX000I1@Z@Z ??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z ??$__crt_fast_encode_pointer@PEAX@@YAPEAXQEAX@Z"
	strings:
		$1 = { 4C 8B 05 ?? ?? ?? ?? 48 8B C1 41 8B D0 B9 40 00 00 00 83 E2 3F 2B CA 48 D3 C8 49 33 C0 C3 }
	condition:
		$1
}

rule file_26_4_0 {
	meta:
		name = "?initialize@?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@QEAAXQ6AHPEAU_exception@@@Z@Z"
		size = 49
		altNames = "?initialize@?$dual_state_global@P6AH_K@Z@__crt_state_management@@QEAAXQ6AH_K@Z@Z ?initialize@?$dual_state_global@P6AXH@Z@__crt_state_management@@QEAAXQ6AXH@Z@Z ?initialize@?$dual_state_global@PEAPEAD@__crt_state_management@@QEAAXQEAPEAD@Z ?initialize@?$dual_state_global@PEAPEA_W@__crt_state_management@@QEAAXQEAPEA_W@Z ?initialize@?$dual_state_global@PEAU__crt_locale_data@@@__crt_state_management@@QEAAXQEAU__crt_locale_data@@@Z ?initialize@?$dual_state_global@PEAU__crt_multibyte_data@@@__crt_state_management@@QEAAXQEAU__crt_multibyte_data@@@Z"
	strings:
		$1 = { 45 33 C0 48 8D 41 08 4C 8B C8 4C 2B C9 49 83 C1 07 49 C1 E9 03 48 3B C8 4D 0F 47 C8 4D 85 C9 74 0F 49 FF C0 48 89 11 48 8D 49 08 4D 3B C1 75 F1 C3 }
	condition:
		$1
}

rule file_26_6_0 {
	meta:
		name = "__acrt_has_user_matherr"
		size = 29
		refs = "0003 __security_cookie 000c ?user_matherr@@3V?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@A"
	strings:
		$1 = { 48 8B 15 ?? ?? ?? ?? 8B CA 48 33 15 ?? ?? ?? ?? 83 E1 3F 48 D3 CA 48 85 D2 0F 95 C0 C3 }
	condition:
		$1
}

rule file_26_8_0 {
	meta:
		name = "__acrt_invoke_user_matherr"
		size = 46
		refs = "0003 __security_cookie 000f ?user_matherr@@3V?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@A 002a __guard_dispatch_icall_fptr"
	strings:
		$1 = { 48 8B 15 ?? ?? ?? ?? 4C 8B C1 8B CA 48 33 15 ?? ?? ?? ?? 83 E1 3F 48 D3 CA 48 85 D2 75 03 33 C0 C3 49 8B C8 48 8B C2 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_9_0 {
	meta:
		name = "__setusermatherr"
		size = 37
		refs = "0003 __security_cookie 0020 ?user_matherr@@3V?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@A"
	strings:
		$1 = { 4C 8B 05 ?? ?? ?? ?? 4C 8B C9 41 8B D0 B9 40 00 00 00 83 E2 3F 2B CA 49 D3 C9 4D 33 C8 4C 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_27_7_0 {
	meta:
		name = "?_isindst_nolock@@YAHQEAUtm@@@Z"
		size = 799
		refs = "0029 _get_daylight 0069 ?dststart@@3Utransitiondate@?A0x7639d0b4@@A 0071 ?dstend@@3Utransitiondate@?A0x7639d0b4@@A 007d ?tz_api_used@@3HA 008a ?tz_info@@3U_TIME_ZONE_INFORMATION@@A 00eb ?cvtdate@@YAXW4transition_type@?A0x7639d0b4@@W4date_type@2@HHHHHHHHH@Z 011e ??$__crt_time_is_leap_year@H@@YA_NH@Z 012d __ImageBase 0136 _lpdays 013f _days 031a _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 18 48 89 70 20 57 41 54 41 55 41 56 41 57 48 83 EC 60 48 8B F1 33 FF 48 8D 48 10 89 78 10 E8 ?? ?? ?? ?? 85 C0 0F 85 D5 02 00 00 39 BC 24 98 00 00 00 75 20 33 C0 4C 8D 5C 24 60 49 8B 5B 30 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 8B 6E 14 41 BF 01 00 00 00 3B 2D ?? ?? ?? ?? 75 0C 3B 2D ?? ?? ?? ?? 0F 84 09 02 00 00 39 3D ?? ?? ?? ?? 0F 84 78 01 00 00 66 39 3D ?? ?? ?? ?? 75 64 0F B7 0D ?? ?? ?? ?? 44 8B C5 0F B7 15 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 44 0F B7 15 ?? ?? ?? ?? 44 0F B7 1D ?? ?? ?? ?? 0F B7 1D ?? ?? ?? ?? 44 0F B7 0D ?? ?? ?? ?? 89 44 24 50 89 4C 24 48 33 C9 89 54 24 40 41 8B D7 44 89 54 24 38 89 7C 24 30 44 89 5C 24 28 89 5C 24 20 E8 ?? ?? ?? ?? E9 86 00 00 00 44 0F B7 35 ?? ?? ?? ?? 8B CD 44 0F B7 3D ?? ?? ?? ?? 44 0F B7 25 ?? ?? ?? ?? 44 0F B7 2D ?? ?? ?? ?? 0F B7 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 8D 43 FF 48 63 C8 48 8D 05 ?? ?? ?? ?? 74 09 8B 94 88 ?? ?? ?? ?? EB 07 8B 94 88 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 03 C2 89 2D ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 41 6B C5 3C 41 03 C4 6B C8 3C 41 03 CF 41 BF 01 00 00 00 69 C1 E8 03 00 00 41 03 C6 89 05 ?? ?? ?? ?? 66 39 3D ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 44 0F B7 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 44 0F B7 0D ?? ?? ?? ?? 89 44 24 50 89 4C 24 48 41 8B CF 89 54 24 40 44 89 44 24 38 44 8B 46 14 75 23 44 0F B7 15 ?? ?? ?? ?? 44 0F B7 1D ?? ?? ?? ?? 89 7C 24 30 44 89 54 24 28 44 89 5C 24 20 E9 99 00 00 00 44 0F B7 15 ?? ?? ?? ?? 33 D2 44 89 54 24 30 89 7C 24 28 89 7C 24 20 E9 80 00 00 00 41 B9 03 00 00 00 45 8B F7 45 8D 61 FF 41 8D 59 08 41 8B C4 83 FD 6B 7D 12 45 8D 4C 24 02 41 8B C7 41 8D 5C 24 08 45 8D 74 24 03 89 7C 24 50 44 8B C5 89 7C 24 48 41 8B D7 89 7C 24 40 33 C9 44 89 64 24 38 89 7C 24 30 89 7C 24 28 89 44 24 20 E8 ?? ?? ?? ?? 44 8B 46 14 44 8B CB 89 7C 24 50 41 8B CF 89 7C 24 48 89 7C 24 40 44 89 64 24 38 89 7C 24 30 89 7C 24 28 44 89 74 24 20 41 8B D7 E8 ?? ?? ?? ?? 44 8B 0D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 44 8B 46 1C 44 3B C9 7D 24 45 3B C1 0F 8C 9B FD FF FF 44 3B C1 0F 8F 92 FD FF FF 45 3B C1 7E 25 44 3B C1 7D 20 41 8B C7 E9 82 FD FF FF 44 3B C1 7C F3 45 3B C1 7F EE 44 3B C1 7E 09 45 3B C1 0F 8C 68 FD FF FF 6B 4E 08 3C 03 4E 04 6B D1 3C 03 16 69 C2 E8 03 00 00 45 3B C1 75 11 3B 05 ?? ?? ?? ?? 40 0F 9D C7 8B C7 E9 42 FD FF FF 3B 05 ?? ?? ?? ?? 40 0F 9C C7 EB ED 45 33 C9 48 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_27_8_0 {
	meta:
		name = "?_set_daylight@@YAXH@Z"
		size = 21
		refs = "0009 __daylight"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 89 18 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_9_0 {
	meta:
		name = "?_set_dstbias@@YAXJ@Z"
		size = 21
		refs = "0009 __dstbias"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 89 18 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_10_0 {
	meta:
		name = "?_set_timezone@@YAXJ@Z"
		size = 21
		refs = "0009 __timezone"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 89 18 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_11_0 {
	meta:
		name = "?cvtdate@@YAXW4transition_type@?A0x7639d0b4@@W4date_type@2@HHHHHHHHH@Z"
		size = 517
		refs = "002d ??$__crt_time_is_leap_year@H@@YA_NH@Z 0034 __ImageBase 0049 _lpdays 0059 _days 016e ?dststart@@3Utransitiondate@?A0x7639d0b4@@A 019b ?dstend@@3Utransitiondate@?A0x7639d0b4@@A 01a6 _get_dstbias 0200 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 57 48 83 EC 30 83 60 08 00 8B E9 49 63 D9 41 8B F8 41 8B C8 83 FA 01 0F 85 EB 00 00 00 E8 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 40 8A F0 84 C0 74 10 8D 53 FF 48 63 CA 45 8B 94 8B ?? ?? ?? ?? EB 0E 8D 43 FF 48 63 C8 45 8B 94 8B ?? ?? ?? ?? 44 8D 47 FF B8 1F 85 EB 51 8D 8F 2B 01 00 00 41 FF C2 F7 E9 B8 1F 85 EB 51 44 8B CA 41 F7 E8 41 8B C0 41 C1 F9 07 C1 FA 05 41 8B C9 C1 E9 1F 44 03 C9 8B CA C1 E9 1F 03 D1 69 CF 6D 01 00 00 44 2B CA 99 83 E2 03 81 C1 25 9C FF FF 44 8D 04 02 B8 93 24 49 92 41 C1 F8 02 45 03 C2 45 03 C1 44 03 C1 8B 4C 24 60 41 F7 E8 41 03 D0 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 8B 54 24 68 44 2B C0 6B C1 07 41 2B C0 44 3B C2 7F 03 83 C0 F9 03 C2 44 03 D0 40 84 F6 74 0A 41 8B 94 9B ?? ?? ?? ?? EB 08 41 8B 94 9B ?? ?? ?? ?? 83 F9 05 75 38 44 3B D2 7E 33 41 83 EA 07 EB 2D E8 ?? ?? ?? ?? 84 C0 4C 8D 1D ?? ?? ?? ?? 8D 43 FF 48 63 C8 74 0A 45 8B 94 8B ?? ?? ?? ?? EB 08 45 8B 94 8B ?? ?? ?? ?? 44 03 54 24 70 6B 44 24 78 3C 03 84 24 80 00 00 00 6B C8 3C 03 8C 24 88 00 00 00 69 C1 E8 03 00 00 03 84 24 90 00 00 00 85 ED 75 28 44 89 15 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 48 8B 5C 24 48 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 30 5F C3 48 8D 4C 24 40 44 89 15 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 41 69 44 24 40 E8 03 00 00 8B 0D ?? ?? ?? ?? 03 C8 B8 00 5C 26 05 89 0D ?? ?? ?? ?? 79 0A 03 C8 FF 0D ?? ?? ?? ?? EB 0C 3B C8 7C 0E 2B C8 FF 05 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 8F 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_27_14_0 {
	meta:
		name = "?get_tz_environment_variable@@YAPEADAEAY0BAA@D@Z"
		size = 135
		refs = "0010 ??_C@_02CLFPBFFP@TZ?$AA@ 0023 getenv_s 003f _malloc_base 0075 _free_base"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 4C 8D 0D ?? ?? ?? ?? 48 8B D1 41 B8 00 01 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 85 C0 75 05 48 8B C3 EB 4C 83 F8 22 74 04 33 C0 EB 43 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 24 4C 8B 44 24 38 4C 8D 0D ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 07 48 8B FB 33 DB EB 02 33 FF 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_27_16_0 {
	meta:
		name = "?tzset_from_environment_nolock@@YAXPEAD@Z"
		size = 590
		refs = "0017 __tzname 002e _get_timezone 003f _get_daylight 004e ?last_tz@@3PEADEA 007e _free_base 0096 _malloc_base 00c9 strcpy_s 00e9 strncpy_s 0116 atol 01c4 __timezone 01ce __daylight 01f5 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 55 41 56 48 8B EC 48 83 EC 30 48 8B D9 E8 ?? ?? ?? ?? 45 33 F6 48 8D 4D 38 44 89 75 38 48 8B F0 44 89 75 40 E8 ?? ?? ?? ?? 85 C0 0F 85 FF 01 00 00 48 8D 4D 40 E8 ?? ?? ?? ?? 85 C0 0F 85 D9 01 00 00 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 26 4C 8B C1 48 8B C3 4C 2B C3 0F B6 10 46 0F B6 0C 00 41 2B D1 75 08 48 FF C0 45 85 C9 75 EB 85 D2 0F 84 57 01 00 00 E8 ?? ?? ?? ?? 48 83 CF FF 48 8B CF 48 FF C1 44 38 34 0B 75 F7 48 FF C1 E8 ?? ?? ?? ?? 33 C9 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 85 C9 0F 84 1C 01 00 00 48 FF C7 44 38 34 3B 75 F7 48 8D 57 01 4C 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 85 3A 01 00 00 48 8B 0E 44 8D 68 03 45 8B CD 8D 50 40 4C 8B C3 41 8B FD E8 ?? ?? ?? ?? 85 C0 0F 85 05 01 00 00 44 38 33 74 09 48 FF C3 48 83 EF 01 75 F2 80 3B 2D 40 0F 94 C7 40 84 FF 74 03 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 69 D0 10 0E 00 00 89 55 38 8A 03 3C 2B 74 06 2C 30 3C 09 77 05 48 FF C3 EB EF 80 3B 3A 75 4C 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 8B 55 38 6B C8 3C 03 D1 89 55 38 EB 07 3C 39 7F 09 48 FF C3 8A 03 3C 30 7D F3 80 3B 3A 75 22 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 8B 55 38 03 D0 89 55 38 EB 07 3C 39 7F 09 48 FF C3 8A 03 3C 30 7D F3 40 84 FF 74 05 F7 DA 89 55 38 44 38 33 41 8B C6 0F 95 C0 89 45 40 85 C0 74 1A 48 8B 4E 08 4D 8B CD 4C 8B C3 BA 40 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 09 EB 2C 48 8B 46 08 44 88 30 8B 5D 38 E8 ?? ?? ?? ?? 89 18 8B 5D 40 E8 ?? ?? ?? ?? 89 18 48 8B 5C 24 60 48 83 C4 30 41 5E 41 5D 5F 5E 5D C3 45 33 C9 4C 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_27_17_0 {
	meta:
		name = "?tzset_from_system_nolock@@YAXXZ"
		size = 468
		refs = "000d __tzname 0024 _get_timezone 0035 _get_daylight 0046 _get_dstbias 0055 ?last_tz@@3PEADEA 005a _free_base 0061 ?tz_info@@3U_TIME_ZONE_INFORMATION@@A 006e __imp_GetTimeZoneInformation 0096 ?tz_api_used@@3HA 00cf ___lc_codepage_func 0104 __imp_WideCharToMultiByte 0172 __timezone 017c __daylight 0186 __dstbias 01a5 _invoke_watson"
	strings:
		$1 = { 40 55 53 56 57 48 8B EC 48 83 EC 48 E8 ?? ?? ?? ?? 33 F6 48 8D 4D 28 89 75 28 48 8B D8 89 75 30 89 75 38 E8 ?? ?? ?? ?? 85 C0 0F 85 8F 01 00 00 48 8D 4D 30 E8 ?? ?? ?? ?? 85 C0 0F 85 69 01 00 00 48 8D 4D 38 E8 ?? ?? ?? ?? 85 C0 0F 85 43 01 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 FF 0F 84 F3 00 00 00 6B 0D ?? ?? ?? ?? 3C 44 8D 46 01 66 39 35 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 44 89 05 ?? ?? ?? ?? 89 4D 28 74 08 6B C2 3C 03 C8 89 4D 28 66 39 35 ?? ?? ?? ?? 74 18 8B 05 ?? ?? ?? ?? 85 C0 74 0E 2B C2 44 89 45 30 6B C0 3C 89 45 38 EB 06 89 75 30 89 75 38 E8 ?? ?? ?? ?? 48 8B 0B 4C 8D 05 ?? ?? ?? ?? 8B F8 41 83 C9 FF 48 8D 45 40 33 D2 48 89 44 24 38 48 89 74 24 30 C7 44 24 28 3F 00 00 00 48 89 4C 24 20 8B CF FF 15 ?? ?? ?? ?? 85 C0 74 0E 39 75 40 75 09 48 8B 03 40 88 70 3F EB 06 48 8B 03 40 88 30 48 8D 45 40 41 83 C9 FF 48 89 44 24 38 4C 8D 05 ?? ?? ?? ?? 48 8B 43 08 33 D2 48 89 74 24 30 8B CF C7 44 24 28 3F 00 00 00 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 0F 39 75 40 75 0A 48 8B 43 08 40 88 70 3F EB 07 48 8B 43 08 40 88 30 8B 5D 28 E8 ?? ?? ?? ?? 89 18 8B 5D 30 E8 ?? ?? ?? ?? 89 18 8B 5D 38 E8 ?? ?? ?? ?? 89 18 48 83 C4 48 5F 5E 5B 5D C3 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_27_18_0 {
	meta:
		name = "?tzset_nolock@@YAXXZ"
		size = 261
		refs = "0015 __security_cookie 002a ??_C@_02CLFPBFFP@TZ?$AA@ 0032 ?dstend@@3Utransitiondate@?A0x7639d0b4@@A 003e ?tz_api_used@@3HA 0049 ?dststart@@3Utransitiondate@?A0x7639d0b4@@A 0053 getenv_s 0072 _malloc_base 0081 _free_base 00cd ?tzset_from_environment_nolock@@YAXPEAD@Z 00d4 ?tzset_from_system_nolock@@YAXXZ 00ec __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 81 EC 40 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 01 00 00 83 C8 FF 4C 8D 0D ?? ?? ?? ?? 33 F6 89 05 ?? ?? ?? ?? 41 B8 00 01 00 00 89 35 ?? ?? ?? ?? 48 8D 54 24 30 89 05 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 85 C0 75 07 48 8D 7C 24 30 EB 4E 83 F8 22 74 05 48 8B FE EB 44 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 09 33 C9 E8 ?? ?? ?? ?? EB E0 4C 8B 44 24 20 4C 8D 0D ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 85 C0 74 05 48 8B CF EB D7 33 C9 E8 ?? ?? ?? ?? 48 8D 44 24 30 48 8B DF 48 3B F8 48 0F 44 DE 48 85 FF 74 0F 40 38 37 74 0A 48 8B CF E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B 8C 24 30 01 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 40 01 00 00 49 8B 5B 10 49 8B 73 18 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_27_19_0 {
	meta:
		name = "__tzset"
		size = 60
		refs = "0006 ?first_time@?1??__tzset@@9@4JA 0012 __acrt_lock 0022 ?tzset_nolock@@YAXXZ 0033 __acrt_unlock"
	strings:
		$1 = { 48 83 EC 28 8B 05 ?? ?? ?? ?? 85 C0 75 29 8D 48 06 E8 ?? ?? ?? ?? 90 8B 05 ?? ?? ?? ?? 85 C0 75 0C E8 ?? ?? ?? ?? F0 FF 05 ?? ?? ?? ?? B9 06 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_20_0 {
	meta:
		name = "__tzset$fin$0"
		size = 25
		refs = "0014 __acrt_unlock"
		altNames = "_isindst$fin$0 _tzset$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 06 00 00 00 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_27_21_0 {
	meta:
		name = "_invoke_watson_if_error"
		size = 49
		refs = "002c _invoke_watson"
	strings:
		$1 = { 85 C9 75 01 C3 53 48 83 EC 30 48 8B 44 24 68 4D 8B D1 44 8B 4C 24 60 4D 8B D8 48 8B DA 48 89 44 24 20 4D 8B C2 49 8B D3 48 8B CB E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_27_22_0 {
	meta:
		name = "_isindst"
		size = 48
		refs = "000f __acrt_lock 0018 ?_isindst_nolock@@YAHQEAUtm@@@Z 0024 __acrt_unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 B9 06 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 8B D8 B9 06 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_24_0 {
	meta:
		name = "_tzset"
		size = 36
		refs = "000a __acrt_lock 0010 ?tzset_nolock@@YAXXZ 001b __acrt_unlock"
	strings:
		$1 = { 48 83 EC 28 B9 06 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 90 B9 06 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "_controlfp_s"
		size = 99
		refs = "0027 _control87 002e _errno 003a _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 41 0F BA F0 13 8B C2 41 23 C0 44 8B CA 48 8B D9 A9 E0 FC F0 FC 74 25 48 85 C9 74 0B 33 D2 33 C9 E8 ?? ?? ?? ?? 89 03 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 1B 48 85 C9 41 8B D0 41 8B C9 74 09 E8 ?? ?? ?? ?? 89 03 EB 05 E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_29_2_0 {
	meta:
		name = "??$common_localtime_s@J@@YAHQEAUtm@@QEBJ@Z"
		size = 730
		refs = "0017 _errno 0023 _invalid_parameter_noinfo 003d memset 0062 __tzset 0077 _get_daylight 0088 _get_dstbias 0099 _get_timezone 00c2 _gmtime32_s 00db _isindst 02a9 _invoke_watson"
	strings:
		$1 = { 40 55 53 57 48 8B EC 48 83 EC 40 48 8B FA 48 8B D9 48 85 C9 75 1B E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 40 5F 5B 5D C3 BA FF 00 00 00 41 B8 24 00 00 00 E8 ?? ?? ?? ?? 48 85 FF 74 D0 83 3F 00 7D 0E E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 EB CE 81 3F 7F D2 FF 7F 7F EA E8 ?? ?? ?? ?? 83 65 38 00 48 8D 4D 38 83 65 F0 00 83 65 30 00 E8 ?? ?? ?? ?? 85 C0 0F 85 41 02 00 00 48 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 0F 85 1A 02 00 00 48 8D 4D 30 E8 ?? ?? ?? ?? 85 C0 0F 85 F3 01 00 00 8B 0F 8D 81 7F 0B FC FF 3D 7D E9 F7 7F 77 59 2B 4D 30 48 8D 55 20 89 4D 20 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 5B FF FF FF 39 45 38 0F 84 6D 01 00 00 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 84 5D 01 00 00 8B 45 F0 48 8D 55 20 29 45 20 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 28 FF FF FF C7 43 20 01 00 00 00 E9 37 01 00 00 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 09 FF FF FF 8B 3B 39 45 38 74 1D 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 11 8B 4D F0 03 4D 30 2B F9 C7 43 20 01 00 00 00 EB 03 2B 7D 30 41 B8 89 88 88 88 8B CF 41 8B C0 F7 EF 03 D7 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B C2 3C 2B C8 89 0B 79 08 8D 41 3C 83 EF 3C 89 03 41 8B C0 F7 EF 44 8D 0C 17 41 C1 F9 05 41 8B C1 C1 E8 1F 44 03 C8 41 8B C0 44 03 4B 04 41 F7 E9 41 03 D1 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B CA 3C 41 8B D1 2B D1 89 53 04 79 0A 8D 4A 3C 41 83 E9 3C 89 4B 04 41 8B C0 41 F7 E9 45 8D 04 11 41 B9 AB AA AA 2A 41 C1 F8 05 41 8B C0 C1 E8 1F 44 03 C0 41 8B C1 44 03 43 08 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 0C 52 41 8B D0 C1 E1 03 2B D1 89 53 08 79 0A 8D 4A 18 41 83 E8 18 89 4B 08 41 8B C1 41 F7 E8 44 8B C2 41 C1 F8 02 41 8B C0 C1 E8 1F 44 03 C0 45 85 C0 7E 30 8B 4B 18 B8 93 24 49 92 41 03 C8 F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 44 01 43 0C 89 4B 18 44 01 43 1C 33 C0 E9 DE FD FF FF 79 F7 8B 4B 18 B8 93 24 49 92 44 01 43 0C 83 C1 07 41 03 C8 F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 8B 43 0C 89 4B 18 85 C0 7F C4 83 C0 1F C7 43 10 0B 00 00 00 89 43 0C 41 8D 80 6D 01 00 00 01 43 1C FF 4B 14 EB AC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_29_3_0 {
	meta:
		name = "??$common_localtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
		size = 793
		refs = "0017 _errno 0023 _invalid_parameter_noinfo 003d memset 006a __tzset 007f _get_daylight 0090 _get_dstbias 00a1 _get_timezone 00d9 _gmtime64_s 00f2 _isindst 02e8 _invoke_watson"
	strings:
		$1 = { 40 55 53 57 48 8B EC 48 83 EC 40 48 8B FA 48 8B D9 48 85 C9 75 1B E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 40 5F 5B 5D C3 BA FF 00 00 00 41 B8 24 00 00 00 E8 ?? ?? ?? ?? 48 85 FF 74 D0 48 83 3F 00 7D 0E E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 EB CD 48 B8 FF 2A 58 93 07 00 00 00 48 39 07 7F E3 E8 ?? ?? ?? ?? 83 65 30 00 48 8D 4D 30 83 65 38 00 83 65 20 00 E8 ?? ?? ?? ?? 85 C0 0F 85 78 02 00 00 48 8D 4D 38 E8 ?? ?? ?? ?? 85 C0 0F 85 51 02 00 00 48 8D 4D 20 E8 ?? ?? ?? ?? 85 C0 0F 85 2A 02 00 00 48 8B 0F 48 BA FD 41 50 93 07 00 00 00 48 8D 81 7F 0B FC FF 48 3B C2 77 60 48 63 45 20 48 8D 55 F0 48 2B C8 48 89 4D F0 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 44 FF FF FF 39 45 30 0F 84 95 01 00 00 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 84 85 01 00 00 48 63 45 38 48 8D 55 F0 48 29 45 F0 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 0F FF FF FF C7 43 20 01 00 00 00 E9 5D 01 00 00 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 F0 FE FF FF 48 63 3B 39 45 30 74 1D 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 11 8B 45 20 03 45 38 48 98 C7 43 20 01 00 00 00 EB 04 48 63 45 20 48 2B F8 49 B8 89 88 88 88 88 88 88 88 49 8B C0 8B CF 48 F7 EF 48 03 D7 48 C1 FA 05 48 8B C2 48 C1 E8 3F 48 03 D0 6B C2 3C 2B C8 89 0B 79 09 8D 41 3C 48 83 EF 3C 89 03 49 8B C0 48 F7 EF 4C 8D 0C 17 49 C1 F9 05 49 8B C1 48 C1 E8 3F 4C 03 C8 48 63 43 04 4C 03 C8 49 8B C0 49 F7 E9 49 03 D1 48 C1 FA 05 48 8B C2 48 C1 E8 3F 48 03 D0 6B CA 3C 41 8B D1 2B D1 89 53 04 79 0A 8D 4A 3C 49 83 E9 3C 89 4B 04 49 8B C0 49 F7 E9 4D 8D 04 11 49 B9 AB AA AA AA AA AA AA 2A 49 C1 F8 05 49 8B C0 48 C1 E8 3F 4C 03 C0 48 63 43 08 4C 03 C0 49 8B C1 49 F7 E8 48 C1 FA 02 48 8B C2 48 C1 E8 3F 48 03 D0 8D 0C 52 41 8B D0 C1 E1 03 2B D1 89 53 08 79 0A 8D 4A 18 49 83 E8 18 89 4B 08 49 8B C1 49 F7 E8 4C 8B C2 49 C1 F8 02 49 8B C0 48 C1 E8 3F 4C 03 C0 4D 85 C0 7E 30 8B 4B 18 B8 93 24 49 92 41 03 C8 F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 44 01 43 0C 89 4B 18 44 01 43 1C 33 C0 E9 9F FD FF FF 79 F7 8B 4B 18 B8 93 24 49 92 44 01 43 0C 83 C1 07 41 03 C8 F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 8B 43 0C 89 4B 18 85 C0 7F C4 83 C0 1F C7 43 10 0B 00 00 00 89 43 0C 41 8D 80 6D 01 00 00 01 43 1C FF 4B 14 EB AC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "sqrt"
		size = 211
		refs = "0041 _handle_nan 005d ??_C@_04EIAKFFMI@sqrt?$AA@ 009a _handle_error"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 58 48 B9 00 00 00 00 00 00 F0 7F F2 0F 11 44 24 68 48 8B 54 24 68 48 8B C2 48 23 C1 48 3B C1 75 76 48 B8 FF FF FF FF FF FF 0F 00 48 85 D0 74 0C 48 8B CA 48 83 C4 58 E9 ?? ?? ?? ?? 48 B8 00 00 00 00 00 00 00 80 48 85 D0 74 4C F2 0F 10 4C 24 60 48 8D 0D ?? ?? ?? ?? 41 B9 01 00 00 00 0F 57 C0 44 89 4C 24 40 49 B8 00 00 00 00 00 00 F8 FF F2 0F 11 44 24 38 F2 0F 11 4C 24 30 C7 44 24 28 21 00 00 00 41 8D 51 04 C7 44 24 20 08 00 00 00 E8 ?? ?? ?? ?? EB 2E 48 B8 FF FF FF FF FF FF FF 7F 48 85 D0 0F 95 C1 48 0F BA E2 3F 0F 92 C0 84 C8 75 98 F2 0F 51 54 24 60 F2 0F 11 54 24 70 F2 0F 10 44 24 70 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "??$common_wincmdln@D@@YAPEADXZ"
		size = 112
		refs = "000b __acrt_initialize_multibyte 0012 _acmdln 0019 ?empty_string@?1???$common_wincmdln@D@@YAPEADXZ@4PADA 0045 _ismbblead"
		altNames = "_get_narrow_winmain_command_line"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8D 1D ?? ?? ?? ?? 48 85 C0 48 0F 45 D8 40 32 FF 8A 03 3C 20 7F 09 84 C0 74 31 40 84 FF 74 26 3C 22 75 07 40 84 FF 40 0F 94 C7 0F BE C8 E8 ?? ?? ?? ?? 85 C0 74 03 48 FF C3 48 FF C3 EB D2 3C 20 7F 09 48 FF C3 8A 03 84 C0 75 F3 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "??$common_wincmdln@_W@@YAPEA_WXZ"
		size = 79
		refs = "0003 _wcmdln 000a ?empty_string@?1???$common_wincmdln@_W@@YAPEA_WXZ@4PA_WA"
		altNames = "_get_wide_winmain_command_line"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 33 D2 48 85 C0 48 0F 45 C8 8A C2 66 83 39 20 77 09 66 39 11 74 27 84 C0 74 1B 66 83 39 22 75 05 84 C0 0F 94 C0 48 83 C1 02 EB E0 66 83 F8 20 77 0C 48 83 C1 02 0F B7 01 66 85 C0 75 EE 48 8B C1 C3 }
	condition:
		$1
}

rule file_31_6_0 {
	meta:
		name = "?should_copy_another_character@@YA_ND@Z"
		size = 22
		refs = "0008 _ismbblead"
		altNames = "?is_lead_byte@@YA_ND@Z"
	strings:
		$1 = { 48 83 EC 28 0F BE C9 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "_mbsnlen_l"
		size = 152
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0030 strnlen"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B FA 48 8B D9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 30 41 83 78 08 00 75 10 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 EB 3E 33 D2 33 C9 48 85 FF 74 2E 80 3B 00 74 29 0F B6 03 42 F6 44 00 19 04 74 10 48 FF C1 48 3B CF 73 19 48 FF C3 80 3B 00 74 0E 48 FF C2 48 FF C3 48 FF C1 48 3B CF 72 D2 48 3B CF 48 0F 43 D7 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 48 8B C2 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "ceil"
		size = 194
		refs = "0047 _handle_nan 007f __real@3ff0000000000000"
	strings:
		$1 = { 45 33 C0 F2 0F 11 44 24 08 48 8B 54 24 08 48 B9 FF FF FF FF FF FF FF 7F 48 8B C2 48 23 C1 48 B9 00 00 00 00 00 00 40 43 48 3B D0 41 0F 95 C0 48 3B C1 72 17 48 B9 00 00 00 00 00 00 F0 7F 48 3B C1 76 7E 48 8B CA E9 ?? ?? ?? ?? 48 B9 00 00 00 00 00 00 F0 3F 48 3B C1 73 2B 48 85 C0 74 62 4D 85 C0 74 17 48 B8 00 00 00 00 00 00 00 80 48 89 44 24 08 F2 0F 10 44 24 08 EB 46 F2 0F 10 05 ?? ?? ?? ?? EB 3C 48 8B C2 B9 33 00 00 00 48 C1 E8 34 2A C8 B8 01 00 00 00 48 D3 E0 48 FF C8 48 F7 D0 48 23 C2 48 89 44 24 08 F2 0F 10 44 24 08 4D 85 C0 75 0D 48 3B C2 74 08 F2 0F 58 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "??$common_show_message_box@D@@YAHQEBD0I@Z"
		size = 168
		refs = "001e __acrt_get_developer_information_policy 002b __imp_IsDebuggerPresent 003d __imp_OutputDebugStringA 0053 __acrt_can_show_message_box 005c __acrt_is_interactive 0074 __acrt_MessageBoxA 007b __acrt_get_parent_window"
		altNames = "__acrt_show_narrow_message_box"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 41 8B F0 48 8B EA 48 8B D9 E8 ?? ?? ?? ?? 83 F8 02 40 0F 94 C7 FF 15 ?? ?? ?? ?? 85 C0 74 1A 48 85 DB 74 09 48 8B CB FF 15 ?? ?? ?? ?? 40 84 FF 74 3E B8 04 00 00 00 EB 46 40 84 FF 74 32 E8 ?? ?? ?? ?? 84 C0 74 29 E8 ?? ?? ?? ?? 84 C0 75 16 0F BA EE 15 33 C9 48 8B D3 4C 8B C5 44 8B CE E8 ?? ?? ?? ?? EB 19 E8 ?? ?? ?? ?? 48 8B C8 EB E6 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 83 C0 03 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_1_0 {
	meta:
		name = "??$common_show_message_box@_W@@YAHQEB_W0I@Z"
		size = 168
		refs = "001e __acrt_get_developer_information_policy 002b __imp_IsDebuggerPresent 003d __imp_OutputDebugStringW 0053 __acrt_can_show_message_box 005c __acrt_is_interactive 0074 __acrt_MessageBoxW 007b __acrt_get_parent_window"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 41 8B F0 48 8B EA 48 8B D9 E8 ?? ?? ?? ?? 83 F8 02 40 0F 94 C7 FF 15 ?? ?? ?? ?? 85 C0 74 1A 48 85 DB 74 09 48 8B CB FF 15 ?? ?? ?? ?? 40 84 FF 74 3E B8 04 00 00 00 EB 46 40 84 FF 74 32 E8 ?? ?? ?? ?? 84 C0 74 29 E8 ?? ?? ?? ?? 84 C0 75 16 0F BA EE 15 33 C9 48 8B D3 4C 8B C5 44 8B CE E8 ?? ?? ?? ?? EB 19 E8 ?? ?? ?? ?? 48 8B C8 EB E6 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 83 C0 03 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_9_0 {
	meta:
		name = "__acrt_show_wide_message_box"
		size = 168
		refs = "001e __acrt_get_developer_information_policy 002b __imp_IsDebuggerPresent 003d __imp_OutputDebugStringW 0053 __acrt_can_show_message_box 005c __acrt_is_interactive 0074 __acrt_MessageBoxW 007b __acrt_get_parent_window"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 41 8B F0 48 8B EA 48 8B D9 E8 ?? ?? ?? ?? 83 F8 02 40 0F 94 C7 FF 15 ?? ?? ?? ?? 85 C0 74 1A 48 85 DB 74 09 48 8B CB FF 15 ?? ?? ?? ?? 40 84 FF 74 3E B8 04 00 00 00 EB 46 40 84 FF 74 32 E8 ?? ?? ?? ?? 84 C0 74 29 E8 ?? ?? ?? ?? 84 C0 75 16 0F BA EE 15 33 C9 48 8B D3 4C 8B C5 44 8B CE E8 ?? ?? ?? ?? EB 19 E8 ?? ?? ?? ?? 48 8B C8 EB E6 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 83 C0 03 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_2_0 {
	meta:
		name = "??$message_box@$$TAEBQEBDAEBQEBDK@?$__crt_char_traits@D@@SAH$$QEA$$TAEBQEBD1$$QEAK@Z"
		size = 17
		refs = "000d __acrt_MessageBoxA"
		altNames = "??$message_box@PEAUHWND__@@AEBQEBDAEBQEBDAEBI@?$__crt_char_traits@D@@SAH$$QEAPEAUHWND__@@AEBQEBD1AEBI@Z"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_3_0 {
	meta:
		name = "??$message_box@$$TAEBQEB_WAEBQEB_WK@?$__crt_char_traits@_W@@SAH$$QEA$$TAEBQEB_W1$$QEAK@Z"
		size = 17
		refs = "000d __acrt_MessageBoxW"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_5_0 {
	meta:
		name = "??$message_box@PEAUHWND__@@AEBQEB_WAEBQEB_WAEBI@?$__crt_char_traits@_W@@SAH$$QEAPEAUHWND__@@AEBQEB_W1AEBI@Z"
		size = 17
		refs = "000d __acrt_MessageBoxW"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_30_0 {
	meta:
		name = "??$ulltot_s@AEB_KAEBQEADAEB_KH@?$__crt_char_traits@D@@SAHAEB_KAEBQEAD0$$QEAH@Z"
		size = 17
		refs = "000d _ui64toa_s"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_31_0 {
	meta:
		name = "??$ulltot_s@AEB_KAEBQEA_WAEB_KH@?$__crt_char_traits@_W@@SAHAEB_KAEBQEA_W0$$QEAH@Z"
		size = 17
		refs = "000d _ui64tow_s"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_4_0 {
	meta:
		name = "_mbsncat_s_l"
		size = 584
		refs = "005a _errno 0066 _invalid_parameter_noinfo 0099 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00b5 strncat_s"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 45 33 FF 49 8B E9 49 8B D8 48 8B F2 48 8B F9 45 8B F7 4D 85 C9 75 0E 48 85 C9 75 0E 48 85 D2 75 1B 33 C0 EB 2A 48 85 C9 74 12 48 85 D2 74 0D 4D 85 C9 74 3A 48 85 DB 75 35 44 88 39 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 8B 7C 24 78 48 83 C4 40 41 5F 41 5E 41 5C C3 48 8B 94 24 80 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 54 24 30 48 8B D6 48 8B CF 45 39 7A 08 75 12 4C 8B CD 4C 8B C3 E8 ?? ?? ?? ?? 8B D8 E9 6C 01 00 00 41 BC 01 00 00 00 44 38 39 74 08 49 03 CC 49 2B D4 75 F3 48 85 D2 75 12 44 88 3F E8 ?? ?? ?? ?? BB 16 00 00 00 E9 23 01 00 00 48 3B D6 73 37 4C 8D 49 FF 4D 8B C1 4C 3B CF 72 14 41 0F B6 00 42 F6 44 10 19 04 74 08 4D 2B C4 4C 3B C7 73 EC 41 8B C1 41 2B C0 41 84 C4 74 0C 49 8B C9 45 88 39 49 03 D4 45 8B F4 48 83 FD FF 75 16 48 2B CB 8A 03 88 04 19 49 03 DC 84 C0 74 65 49 2B D4 75 EF EB 5E 48 85 ED 74 56 0F B6 03 42 F6 44 10 19 04 74 23 48 FF C3 44 38 3B 74 38 48 83 FA 02 76 2D 88 01 49 03 CC 8A 03 49 03 DC 88 01 49 03 CC 48 83 EA 02 EB 11 88 01 49 03 DC 49 03 CC 84 C0 74 17 49 2B D4 74 12 49 2B EC 74 0D EB BA 49 8B D7 EB 06 44 88 39 45 8B F4 48 85 ED 75 03 44 88 39 48 85 D2 75 71 48 83 FD FF 75 55 45 85 F6 74 0F E8 ?? ?? ?? ?? 8D 5D 2B 89 18 4C 8B 54 24 30 49 3B F4 76 30 48 8D 56 FE 48 03 D7 48 8B CA 48 3B D7 72 13 0F B6 01 42 F6 44 10 19 04 74 08 49 2B CC 48 3B CF 73 ED 8B C2 2B C1 41 84 C4 74 05 44 88 3A EB 05 44 88 7C 37 FF BB 50 00 00 00 EB 2C 44 88 3F E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? EB 16 45 85 F6 74 0E E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 EB 03 41 8B DF 44 38 7C 24 38 0F 84 33 FE FF FF 48 8B 4C 24 20 83 A1 A8 03 00 00 FD E9 22 FE FF FF }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "??$translate_text_mode_nolock@D@@YAHHQEAD_K@Z"
		size = 402
		refs = "0020 __pioinfo 00d0 __imp_ReadFile 0126 _lseeki64_nolock"
	strings:
		$1 = { 48 89 5C 24 20 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 4C 63 E9 4C 8B F2 49 8B FD 48 8D 15 ?? ?? ?? ?? 83 E7 3F 4D 8B FD 49 C1 FF 06 48 C1 E7 06 4A 8B 04 FA 48 8B 4C 38 28 48 89 8C 24 80 00 00 00 4D 85 C0 74 0D 41 80 3E 0A 75 07 80 4C 38 38 04 EB 05 80 64 38 38 FB 4F 8D 24 06 49 8B F6 49 8B DE 4D 3B F4 0F 83 08 01 00 00 49 8D 6E 01 8A 06 3C 1A 0F 84 DF 00 00 00 3C 0D 74 10 88 03 48 FF C3 48 FF C6 48 FF C5 E9 C0 00 00 00 49 3B EC 73 1E 80 7D 00 0A 75 13 48 83 C6 02 C6 03 0A 48 83 C5 02 48 FF C3 E9 A2 00 00 00 C6 03 0D EB CF 48 83 64 24 20 00 4C 8D 4C 24 78 41 B8 01 00 00 00 48 8D 54 24 70 48 FF C6 48 FF C5 FF 15 ?? ?? ?? ?? 85 C0 74 62 83 7C 24 78 00 74 5B 48 8D 15 ?? ?? ?? ?? 4A 8B 04 FA F6 44 38 38 48 74 1B 8A 4C 24 70 80 F9 0A 75 05 C6 03 0A EB 45 C6 03 0D 4A 8B 04 FA 88 4C 38 3A EB 38 80 7C 24 70 0A 75 05 49 3B DE 74 E2 41 B8 01 00 00 00 48 83 CA FF 41 8B CD E8 ?? ?? ?? ?? 80 7C 24 70 0A 48 8D 15 ?? ?? ?? ?? 74 0F EB 07 48 8D 15 ?? ?? ?? ?? C6 03 0D 48 FF C3 48 8B 8C 24 80 00 00 00 49 3B F4 0F 82 19 FF FF FF EB 1B 4A 8B 0C FA 8A 44 39 38 A8 40 75 08 0C 02 88 44 39 38 EB 07 8A 0E 88 0B 48 FF C3 49 2B DE 8B C3 48 8B 9C 24 88 00 00 00 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "??$translate_text_mode_nolock@_W@@YAHHQEA_W_K@Z"
		size = 558
		refs = "0017 __pioinfo 00eb __imp_ReadFile 01a9 _lseeki64_nolock"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 38 4C 63 E9 4C 8D 15 ?? ?? ?? ?? 49 8B FD 4D 8B FD 49 C1 FF 06 83 E7 3F 48 C1 E7 06 4C 8B F2 41 B9 0A 00 00 00 4B 8B 04 FA 48 8B 4C 38 28 48 89 8C 24 98 00 00 00 4D 85 C0 74 0D 66 44 39 0A 75 07 80 4C 38 38 04 EB 05 80 64 38 38 FB 4E 8D 24 42 48 8B F2 48 8B DA 49 3B D4 0F 83 A3 01 00 00 48 8D 6A 02 BA 0D 00 00 00 0F B7 06 66 83 F8 1A 0F 84 6F 01 00 00 66 3B C2 74 14 66 89 03 48 83 C3 02 48 83 C6 02 48 83 C5 02 E9 A1 00 00 00 49 3B EC 73 21 66 44 39 4D 00 75 15 48 83 C6 04 66 44 89 0B 48 83 C5 04 48 83 C3 02 E9 80 00 00 00 66 89 13 EB C9 48 83 64 24 20 00 4C 8D 8C 24 90 00 00 00 41 B8 02 00 00 00 48 8D 94 24 80 00 00 00 48 83 C6 02 48 83 C5 02 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E2 00 00 00 83 BC 24 90 00 00 00 00 0F 84 D4 00 00 00 4C 8D 15 ?? ?? ?? ?? 41 B9 0A 00 00 00 4B 8B 04 FA F6 44 38 38 48 74 6D 0F B7 84 24 80 00 00 00 66 41 3B C1 75 23 66 44 89 0B 48 83 C3 02 BA 0D 00 00 00 48 8B 8C 24 98 00 00 00 49 3B F4 0F 82 30 FF FF FF E9 C5 00 00 00 B9 0D 00 00 00 66 89 84 24 88 00 00 00 66 89 0B 48 83 C3 02 33 D2 4B 8B 0C FA 8A 84 14 88 00 00 00 48 03 CF 88 44 11 3A 48 FF C2 48 83 FA 02 7C E5 4B 8B 04 FA 44 88 4C 38 3C EB A9 66 44 39 8C 24 80 00 00 00 75 05 49 3B DE 74 91 48 C7 C2 FE FF FF FF 41 8B CD 44 8D 42 03 E8 ?? ?? ?? ?? 41 B9 0A 00 00 00 4C 8D 15 ?? ?? ?? ?? 66 44 39 8C 24 80 00 00 00 0F 84 6A FF FF FF 41 8D 51 03 66 89 13 48 83 C3 02 E9 5F FF FF FF BA 0D 00 00 00 4C 8D 15 ?? ?? ?? ?? 66 89 13 48 83 C3 02 44 8D 4A FD E9 43 FF FF FF 4B 8B 0C FA 8A 44 39 38 A8 40 75 08 0C 02 88 44 39 38 EB 0A 0F B7 0E 66 89 0B 48 83 C3 02 49 2B DE 48 D1 FB 48 8D 04 1B 48 83 C4 38 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z"
		size = 52
		refs = "0014 _free_base"
		altNames = "??4?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B DA 48 8B 09 E8 ?? ?? ?? ?? 48 83 27 00 48 8B 03 48 89 07 48 8B C7 48 83 23 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_8_0 {
	meta:
		name = "?store_lookahead@@YAXHD@Z"
		size = 35
		refs = "0006 __pioinfo"
	strings:
		$1 = { 4C 63 C1 48 8D 0D ?? ?? ?? ?? 49 8B C0 41 83 E0 3F 48 C1 F8 06 49 C1 E0 06 48 8B 04 C1 42 88 54 00 3A C3 }
	condition:
		$1
}

rule file_36_9_0 {
	meta:
		name = "?store_lookahead@@YAXH_W@Z"
		size = 67
		refs = "0006 __pioinfo"
	strings:
		$1 = { 4C 63 C1 4C 8D 15 ?? ?? ?? ?? 4D 8B C8 66 89 54 24 10 49 C1 F9 06 33 D2 41 83 E0 3F 49 C1 E0 06 4B 8B 0C CA 8A 44 14 10 49 03 C8 88 44 11 3A 48 FF C2 48 83 FA 02 7C E8 4B 8B 04 CA 42 C6 44 00 3C 0A C3 }
	condition:
		$1
}

rule file_36_10_0 {
	meta:
		name = "?translate_ansi_or_utf8_nolock@@YAHHQEAD_KQEA_W1@Z"
		size = 761
		refs = "001f __ImageBase 003e __pioinfo 00d9 __imp_ReadFile 0143 _lseeki64_nolock 01f7 _lookuptrailbytes 0210 _errno 02a6 __imp_MultiByteToWideChar 02b2 __imp_GetLastError 02b9 __acrt_errno_map_os_error"
	strings:
		$1 = { 4C 89 4C 24 20 89 4C 24 08 53 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 38 49 8B E9 4C 8D 15 ?? ?? ?? ?? 4C 63 C9 4C 8B F2 49 8B F9 4D 8B F9 49 C1 FF 06 83 E7 3F 48 C1 E7 06 4B 8B 84 FA ?? ?? ?? ?? 4C 8B 6C 38 28 4D 85 C0 74 0C 80 3A 0A 75 07 80 4C 38 38 04 EB 05 80 64 38 38 FB 4E 8D 24 02 48 8B F2 48 8B DA 49 3B D4 0F 83 31 01 00 00 48 8D 6A 01 8A 06 3C 1A 0F 84 F4 00 00 00 3C 0D 74 10 88 03 48 FF C3 48 FF C6 48 FF C5 E9 D5 00 00 00 49 3B EC 73 1B 80 7D 00 0A 75 10 48 83 C6 02 48 83 C5 02 C6 03 0A E9 B7 00 00 00 C6 03 0D EB D2 48 83 64 24 20 00 4C 8D 8C 24 90 00 00 00 41 B8 01 00 00 00 48 8D 94 24 88 00 00 00 49 8B CD 48 FF C6 48 FF C5 FF 15 ?? ?? ?? ?? 85 C0 74 79 83 BC 24 90 00 00 00 00 74 6F 4C 8D 15 ?? ?? ?? ?? 4B 8B 84 FA ?? ?? ?? ?? F6 44 38 38 48 74 1D 8A 8C 24 88 00 00 00 80 F9 0A 74 98 C6 03 0D 4B 8B 84 FA ?? ?? ?? ?? 88 4C 38 3A EB 46 80 BC 24 88 00 00 00 0A 75 09 49 3B DE 0F 84 74 FF FF FF 8B 8C 24 80 00 00 00 41 B8 01 00 00 00 48 83 CA FF E8 ?? ?? ?? ?? 80 BC 24 88 00 00 00 0A 4C 8D 15 ?? ?? ?? ?? 74 0F EB 07 4C 8D 15 ?? ?? ?? ?? C6 03 0D 48 FF C3 49 3B F4 0F 82 04 FF FF FF EB 1F 4B 8B 8C FA ?? ?? ?? ?? 8A 44 39 38 A8 40 75 08 0C 02 88 44 39 38 EB 07 8A 06 88 03 48 FF C3 44 8B 8C 24 80 00 00 00 48 8B AC 24 98 00 00 00 41 2B DE 75 07 33 C0 E9 3B 01 00 00 4B 8B 8C FA ?? ?? ?? ?? 80 7C 39 39 00 75 07 8B C3 E9 25 01 00 00 48 63 C3 49 8D 5E FF 48 03 D8 F6 03 80 75 08 48 FF C3 E9 AA 00 00 00 BA 01 00 00 00 EB 0F 83 FA 04 77 18 49 3B DE 72 13 48 FF CB FF C2 0F B6 03 42 80 BC 10 ?? ?? ?? ?? 00 74 E3 44 0F B6 03 43 0F BE 84 10 ?? ?? ?? ?? 85 C0 75 13 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 C8 FF E9 C6 00 00 00 FF C0 3B C2 75 07 8B C2 48 03 D8 EB 55 F6 44 39 38 48 74 3B 48 FF C3 44 88 44 39 3A 83 FA 02 72 11 8A 03 48 FF C3 4B 8B 8C FA ?? ?? ?? ?? 88 44 39 3B 83 FA 03 75 11 8A 03 48 FF C3 4B 8B 8C FA ?? ?? ?? ?? 88 44 39 3C 8B C2 48 2B D8 EB 13 F7 DA 41 B8 01 00 00 00 48 63 D2 41 8B C9 E8 ?? ?? ?? ?? 8B 84 24 A0 00 00 00 41 2B DE 89 44 24 28 44 8B CB 4D 8B C6 48 89 6C 24 20 33 D2 B9 E9 FD 00 00 FF 15 ?? ?? ?? ?? 8B D0 85 C0 75 12 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 58 FF FF FF 48 8D 0D ?? ?? ?? ?? 4A 8B 8C F9 ?? ?? ?? ?? 80 64 39 3D FD 3B C3 0F 95 C0 24 01 02 C0 08 44 39 3D 8B C2 48 03 C0 48 83 C4 38 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_36_11_0 {
	meta:
		name = "?translate_utf16_from_console_nolock@@YAHHQEA_W_K@Z"
		size = 148
		refs = "006a __pioinfo"
	strings:
		$1 = { 48 89 5C 24 08 4E 8D 14 42 4C 63 D9 4C 8B CA 4C 8B C2 48 8B C2 49 3B D2 73 6B 48 83 C2 02 BB 0A 00 00 00 41 0F B7 08 66 83 F9 1A 74 37 66 83 F9 0D 75 1B 49 3B D2 73 16 66 39 1A 75 11 49 83 C0 04 66 89 18 48 83 C2 04 48 83 C0 02 EB 0F 66 89 08 49 83 C0 02 48 83 C0 02 48 83 C2 02 4D 3B C2 72 C1 EB 21 49 8B D3 4C 8D 05 ?? ?? ?? ?? 83 E2 3F 49 8B CB 48 C1 F9 06 48 C1 E2 06 49 8B 0C C8 80 4C 11 38 02 48 8B 5C 24 08 49 2B C1 48 D1 F8 48 03 C0 C3 }
	condition:
		$1
}

rule file_36_12_0 {
	meta:
		name = "_read"
		size = 279
		refs = "0025 __doserrno 002d _errno 0046 _nhandle 005d __pioinfo 00a0 __acrt_lowio_lock_fh 00d8 _read_nolock 00e1 __acrt_lowio_unlock_fh 00fd _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 10 89 4C 24 08 56 41 54 41 55 41 56 41 57 48 83 EC 20 45 8B F8 4C 8B EA 48 63 F1 83 FE FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 C5 00 00 00 85 C9 0F 88 A5 00 00 00 3B 35 ?? ?? ?? ?? 0F 83 99 00 00 00 4C 8B F6 4C 8B E6 49 C1 FC 06 48 8D 05 ?? ?? ?? ?? 41 83 E6 3F 49 C1 E6 06 4A 8B 04 E0 42 0F B6 4C 30 38 83 E1 01 74 71 33 C0 41 81 F8 FF FF FF 7F 0F 96 C0 85 C0 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 5F 8B CE E8 ?? ?? ?? ?? 83 CB FF 48 8D 05 ?? ?? ?? ?? 4A 8B 04 E0 42 F6 44 30 38 01 75 15 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 EB 0F 45 8B C7 49 8B D5 8B CE E8 ?? ?? ?? ?? 8B D8 8B CE E8 ?? ?? ?? ?? 8B C3 EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 58 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5E C3 }
	condition:
		$1
}

rule file_36_13_0 {
	meta:
		name = "_read$fin$0"
		size = 23
		refs = "0012 __acrt_lowio_unlock_fh"
		altNames = "?fin$0@?0???$common_filelength@J@@YAJH@Z@4HA ?fin$0@?0???$common_filelength@_J@@YA_JH@Z@4HA ?fin$0@?0???$common_lseek@J@@YAJHJH@Z@4HA ?fin$0@?0???$common_lseek@_J@@YA_JH_JH@Z@4HA _locking$fin$0 _setmode$fin$0 _write$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 4D 50 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_36_14_0 {
	meta:
		name = "_read_nolock"
		size = 1125
		refs = "0029 __doserrno 0032 _errno 004e _nhandle 0075 __pioinfo 0125 _invalid_parameter_noinfo 013f _malloc_base 0149 _free_base 0181 _lseeki64_nolock 0241 _isatty 0270 __imp_GetConsoleMode 029f __imp_ReadConsoleW 02a9 __imp_GetLastError 02b0 __acrt_errno_map_os_error 02f1 __imp_ReadFile 0350 ?translate_ansi_or_utf8_nolock@@YAHHQEAD_KQEA_W1@Z 03f0 ??$translate_text_mode_nolock@_W@@YAHHQEA_W_K@Z"
	strings:
		$1 = { 48 89 5C 24 18 48 89 54 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 60 4C 63 E9 4C 8B CA 45 8B E0 41 83 FD FE 75 19 E8 ?? ?? ?? ?? 33 F6 89 30 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 09 04 00 00 33 F6 85 C9 0F 88 E8 03 00 00 44 3B 2D ?? ?? ?? ?? 0F 83 DB 03 00 00 49 8B ED 44 8D 46 01 83 E5 3F 4C 89 44 24 48 49 8B D5 48 C1 E5 06 48 C1 FA 06 4C 8D 1D ?? ?? ?? ?? 48 89 54 24 40 49 8B 04 D3 44 84 44 28 38 0F 84 A6 03 00 00 41 81 FC FF FF FF 7F 76 17 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 98 03 00 00 45 85 E4 0F 84 79 03 00 00 F6 44 28 38 02 0F 85 6E 03 00 00 4D 85 C9 74 D0 48 8B 4C 28 28 48 8B DE 44 0F BE 54 28 39 BF 04 00 00 00 48 89 4C 24 38 41 8B CA 44 88 94 24 A0 00 00 00 41 2B C8 74 1A 41 2B C8 75 0A 41 8B C4 F7 D0 41 84 C0 74 15 45 8B F4 4D 8B F9 E9 A0 00 00 00 41 8B C4 F7 D0 41 84 C0 75 1C E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 86 01 00 00 45 8B F4 41 D1 EE 44 3B F7 44 0F 42 F7 41 8B CE E8 ?? ?? ?? ?? 33 C9 48 8B D8 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 4C 8B FB 48 85 DB 75 1B E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 E9 3D 01 00 00 33 D2 41 8B CD 44 8D 42 01 E8 ?? ?? ?? ?? 48 8B 54 24 40 4C 8D 1D ?? ?? ?? ?? 44 8A 94 24 A0 00 00 00 41 B8 01 00 00 00 49 8B 0C D3 48 89 44 29 30 49 8B 04 D3 8B FE 4C 89 7C 24 50 41 B9 0A 00 00 00 F6 44 28 38 48 74 7D 8A 4C 28 3A 41 3A C9 74 74 45 85 F6 74 6F 41 88 0F 41 FF CE 49 8B 04 D3 4D 03 F8 41 8B F8 44 88 4C 28 3A 45 84 D2 74 55 49 8B 04 D3 8A 4C 28 3B 41 3A C9 74 48 45 85 F6 74 43 41 88 0F 41 8D 79 F8 49 8B 04 D3 4D 03 F8 41 FF CE 44 88 4C 28 3B 45 3A D0 75 28 49 8B 04 D3 8A 4C 28 3C 41 3A C9 74 1B 45 85 F6 74 16 41 88 0F 41 8D 79 F9 49 8B 04 D3 4D 03 F8 41 FF CE 44 88 4C 28 3C 41 8B CD E8 ?? ?? ?? ?? 85 C0 0F 84 85 00 00 00 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 F6 44 28 38 80 74 6E 48 8B 4C 24 38 48 8D 54 24 30 FF 15 ?? ?? ?? ?? 85 C0 74 5A 80 BC 24 A0 00 00 00 02 75 55 48 8B 4C 24 38 4C 8D 8C 24 B8 00 00 00 41 D1 EE 49 8B D7 45 8B C6 48 89 74 24 20 FF 15 ?? ?? ?? ?? 85 C0 75 1F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 83 CF FF 48 8B CB E8 ?? ?? ?? ?? 8B C7 E9 87 01 00 00 8B 84 24 B8 00 00 00 8D 3C 47 EB 40 40 88 74 24 48 48 8B 4C 24 38 4C 8D 8C 24 B8 00 00 00 45 8B C6 48 89 74 24 20 49 8B D7 FF 15 ?? ?? ?? ?? 85 C0 0F 84 FC 00 00 00 44 39 A4 24 B8 00 00 00 0F 87 EE 00 00 00 03 BC 24 B8 00 00 00 48 8B 54 24 40 4C 8D 1D ?? ?? ?? ?? 49 8B 04 D3 F6 44 28 38 80 74 8E 80 BC 24 A0 00 00 00 02 74 28 4C 8B 8C 24 A8 00 00 00 49 8B C4 48 D1 E8 49 8B D7 4C 63 C7 41 8B CD 48 89 44 24 20 E8 ?? ?? ?? ?? 8B F8 E9 5C FF FF FF 48 8B 44 24 48 84 C0 74 7D 4C 8B 44 24 50 48 63 C7 49 8B C8 48 D1 E8 49 8B F8 4D 8D 14 40 4D 3B C2 73 56 49 8D 40 02 BE 0A 00 00 00 44 0F B7 09 66 41 83 F9 1A 74 39 66 41 83 F9 0D 75 1B 49 3B C2 73 16 66 39 30 75 11 48 83 C1 04 66 89 37 48 83 C0 04 48 83 C7 02 EB 10 66 44 89 0F 48 83 C1 02 48 83 C7 02 48 83 C0 02 49 3B CA 72 BE EB 09 49 8B 04 D3 80 4C 28 38 02 49 2B F8 48 D1 FF 03 FF E9 D6 FE FF FF 48 8B 54 24 50 41 8B CD 4C 63 C7 49 D1 E8 E8 ?? ?? ?? ?? E9 5B FF FF FF FF 15 ?? ?? ?? ?? 83 F8 05 75 1B E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E9 95 FE FF FF 83 F8 6D 0F 85 85 FE FF FF 8B FE E9 88 FE FF FF 33 C0 EB 1A E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 9C 24 B0 00 00 00 48 83 C4 60 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "??$common_tcsncpy_s@D@@YAHQEAD_KQEBD1@Z"
		size = 193
		refs = "0039 _errno 0045 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B D2 4D 85 C9 75 0E 48 85 C9 75 0E 48 85 D2 75 20 33 C0 EB 2F 48 85 C9 74 17 48 85 D2 74 12 4D 85 C9 75 05 44 88 09 EB E8 4D 85 C0 75 1C 44 88 01 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 4C 2B C1 48 8B D1 4D 8B DA 49 8B D9 49 83 F9 FF 75 15 41 8A 04 10 88 02 48 FF C2 84 C0 74 28 49 83 EB 01 75 ED EB 20 41 8A 04 10 88 02 48 FF C2 84 C0 74 0C 49 83 EB 01 74 06 48 83 EB 01 75 E7 48 85 DB 75 02 88 1A 4D 85 DB 0F 85 77 FF FF FF 49 83 F9 FF 75 0B 46 88 5C 11 FF 41 8D 43 50 EB 99 C6 01 00 E8 ?? ?? ?? ?? BB 22 00 00 00 EB 81 }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "strncpy_s"
		size = 210
		refs = "0020 _errno 002c _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 45 33 D2 4C 8B DA 4D 85 C9 75 2C 48 85 C9 75 2C 48 85 D2 74 14 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 44 8B D3 41 8B C2 48 8B 5C 24 30 48 83 C4 20 5F C3 48 85 C9 74 D9 48 85 D2 74 D4 4D 85 C9 75 05 44 88 11 EB DE 4D 85 C0 75 05 44 88 11 EB C0 4C 2B C1 48 8B D1 49 8B DB 49 8B F9 49 83 F9 FF 75 15 41 8A 04 10 88 02 48 FF C2 84 C0 74 29 48 83 EB 01 75 ED EB 21 41 8A 04 10 88 02 48 FF C2 84 C0 74 0C 48 83 EB 01 74 06 48 83 EF 01 75 E7 48 85 FF 75 03 44 88 12 48 85 DB 75 87 49 83 F9 FF 75 0E 46 88 54 19 FF 44 8D 53 50 E9 73 FF FF FF 44 88 11 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 57 FF FF FF }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "wmemmove_s"
		size = 82
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0046 memmove"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 4D 85 C9 74 3C 48 85 C9 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 24 48 85 C0 74 E6 49 3B D1 73 0C E8 ?? ?? ?? ?? BB 22 00 00 00 EB DF 4F 8D 04 09 48 8B D0 E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEAA@XZ"
		size = 34
		refs = "0014 __imp_CloseHandle"
		altNames = "?close@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 39 FF 48 8B D9 74 0D 48 8B 09 FF 15 ?? ?? ?? ?? 48 83 0B FF 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_641_37_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QEAA@XZ"
		size = 34
		refs = "0014 __imp_FindClose"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 39 FF 48 8B D9 74 0D 48 8B 09 FF 15 ?? ?? ?? ?? 48 83 0B FF 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_641_58_0 {
	meta:
		name = "?close@?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QEAAXXZ"
		size = 34
		refs = "0014 __imp_FindClose"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 39 FF 48 8B D9 74 0D 48 8B 09 FF 15 ?? ?? ?? ?? 48 83 0B FF 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "?close@__crt_handle_traits@@SA_NPEAX@Z"
		size = 20
		refs = "0006 __imp_CloseHandle"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_641_59_0 {
	meta:
		name = "?close@__crt_findfile_traits@@SA_NPEAX@Z"
		size = 20
		refs = "0006 __imp_FindClose"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_661_23_0 {
	meta:
		name = "?close@__crt_hmodule_traits@@SA_NPEAUHINSTANCE__@@@Z"
		size = 20
		refs = "0006 __imp_FreeLibrary"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "_cwait"
		size = 182
		refs = "0032 __imp_WaitForSingleObject 0044 __imp_GetExitCodeProcess 005e __imp_GetLastError 0068 _errno 0073 __doserrno 0082 __acrt_errno_map_os_error 0092 __imp_CloseHandle"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 48 83 EC 20 48 83 CF FF 48 8B F2 48 8B D9 48 85 C9 74 02 89 39 48 8D 42 02 48 83 F8 01 76 6E 83 CA FF 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 75 22 48 8D 54 24 30 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 10 48 85 DB 74 06 8B 44 24 30 89 03 48 8B FE EB 31 FF 15 ?? ?? ?? ?? 83 F8 06 75 18 E8 ?? ?? ?? ?? C7 00 0A 00 00 00 E8 ?? ?? ?? ?? C7 00 06 00 00 00 EB 07 8B C8 E8 ?? ?? ?? ?? 48 85 DB 74 02 89 3B 48 8B CE FF 15 ?? ?? ?? ?? EB 0B E8 ?? ?? ?? ?? C7 00 0A 00 00 00 48 8B 5C 24 38 48 8B C7 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_40_12_0 {
	meta:
		name = "??$common_strtod_l@MD@@YAMQEBDQEAPEADQEAU__crt_locale_pointers@@@Z"
		size = 161
		refs = "001e _errno 0029 _invalid_parameter_noinfo 003b ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0054 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 0066 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAM@Z"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 50 48 8B FA 48 8B D9 48 85 D2 74 03 48 89 0A 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 0F 57 C0 EB 64 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F 57 C0 48 8D 4C 24 20 4C 8B C7 F3 0F 11 44 24 60 48 8B D3 E8 ?? ?? ?? ?? 48 8B D0 4C 8D 44 24 60 48 8D 4C 24 38 E8 ?? ?? ?? ?? 83 C0 FE 83 F8 01 77 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 80 7C 24 48 00 F3 0F 10 44 24 60 74 0C 48 8B 44 24 30 83 A0 A8 03 00 00 FD 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_40_13_0 {
	meta:
		name = "??$common_strtod_l@M_W@@YAMQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
		size = 161
		refs = "001e _errno 0029 _invalid_parameter_noinfo 003b ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0054 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 0066 ??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAM@Z"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 50 48 8B FA 48 8B D9 48 85 D2 74 03 48 89 0A 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 0F 57 C0 EB 64 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F 57 C0 48 8D 4C 24 20 4C 8B C7 F3 0F 11 44 24 60 48 8B D3 E8 ?? ?? ?? ?? 48 8B D0 4C 8D 44 24 60 48 8D 4C 24 38 E8 ?? ?? ?? ?? 83 C0 FE 83 F8 01 77 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 80 7C 24 48 00 F3 0F 10 44 24 60 74 0C 48 8B 44 24 30 83 A0 A8 03 00 00 FD 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_40_14_0 {
	meta:
		name = "??$common_strtod_l@ND@@YANQEBDQEAPEADQEAU__crt_locale_pointers@@@Z"
		size = 161
		refs = "001e _errno 0029 _invalid_parameter_noinfo 003b ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0054 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 0066 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAN@Z"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 50 48 8B FA 48 8B D9 48 85 D2 74 03 48 89 0A 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 0F 57 C0 EB 64 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F 57 C0 48 8D 4C 24 20 4C 8B C7 F2 0F 11 44 24 60 48 8B D3 E8 ?? ?? ?? ?? 48 8B D0 4C 8D 44 24 60 48 8D 4C 24 38 E8 ?? ?? ?? ?? 83 C0 FE 83 F8 01 77 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 80 7C 24 48 00 F2 0F 10 44 24 60 74 0C 48 8B 44 24 30 83 A0 A8 03 00 00 FD 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_40_15_0 {
	meta:
		name = "??$common_strtod_l@N_W@@YANQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
		size = 161
		refs = "001e _errno 0029 _invalid_parameter_noinfo 003b ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0054 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 0066 ??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAN@Z"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 50 48 8B FA 48 8B D9 48 85 D2 74 03 48 89 0A 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 0F 57 C0 EB 64 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F 57 C0 48 8D 4C 24 20 4C 8B C7 F2 0F 11 44 24 60 48 8B D3 E8 ?? ?? ?? ?? 48 8B D0 4C 8D 44 24 60 48 8D 4C 24 38 E8 ?? ?? ?? ?? 83 C0 FE 83 F8 01 77 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 80 7C 24 48 00 F2 0F 10 44 24 60 74 0C 48 8B 44 24 30 83 A0 A8 03 00 00 FD 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "powf"
		size = 3782
		refs = "0012 __use_fma3_lib 0073 L__xexp_bits_xmantissa_bits 0098 L__1_by_2 00aa L__1023 00b5 __log_F_inv_qword 00ca L__1_by_3 00ea L__log2 00f1 L__log_256_table 0106 L__max_exp_arg 0114 L__min_exp_arg 0126 L__real_64_by_log2 0136 L__real_log2_by_64 014a L__1_by_6 0172 __two_to_jby64_table 0201 L__neg_zero 020e L__real_one 021f L__real_threshold 022d L__real_ca42 023d L__real_two 026a L__real_ca31 032e __flag_x_zero_z_inf 0337 _powf_special 050c __flag_x_nan 0583 __flag_y_nan 069a __flag_x_nan_y_nan 06ea __flag_z_zero 071f __flag_z_inf 074c __flag_x_neg_y_notint"
	strings:
		$1 = { 48 83 EC 68 66 0F 7F 74 24 20 66 0F 7F 7C 24 30 83 3D ?? ?? ?? ?? 00 0F 85 49 07 00 00 66 0F 62 C8 66 0F EF ED 66 0F 7E C8 66 0F 7E C1 44 8B C9 0F BA F0 1F 0F BA F1 1F 3D 00 00 80 7F 0F 83 CD 03 00 00 3D 00 00 80 3F 0F 8E 72 04 00 00 81 F9 00 00 80 7F 0F 83 F6 02 00 00 0F 5A C1 41 81 F9 00 00 88 3F 0F 8C 46 01 00 00 66 0F 70 D0 EE 66 0F DB 15 ?? ?? ?? ?? 66 48 0F 7E D1 48 C1 E9 2C 83 D1 00 8B C1 81 C9 00 FE 03 00 48 C1 E1 2C 66 48 0F 6E C9 66 0F EB 15 ?? ?? ?? ?? 66 0F 70 DA EE 66 0F 73 D3 34 66 0F FB 1D ?? ?? ?? ?? F3 0F E6 DB 48 8D 0D ?? ?? ?? ?? F2 0F 5C CA F2 0F 59 0C C1 66 0F 28 D1 F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 59 CA F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 CA F2 0F 59 1D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 0F 58 1C C1 F2 0F 5C D9 F2 0F 59 C3 66 0F 2E 05 ?? ?? ?? ?? 0F 87 00 06 00 00 66 0F 2E 05 ?? ?? ?? ?? 0F 86 C2 05 00 00 66 0F 28 D8 66 0F 59 1D ?? ?? ?? ?? F2 0F E6 E3 F3 0F E6 D4 F2 0F 59 15 ?? ?? ?? ?? 66 0F 7E E1 F2 0F 5C C2 66 0F 28 C8 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 C1 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 C1 48 C7 C0 3F 00 00 00 23 C1 48 8D 0D ?? ?? ?? ?? F2 0F 59 04 C1 F2 0F 58 04 C1 66 0F 72 E4 06 66 0F 73 F4 34 66 0F D4 E0 F2 0F 5A C4 0F 56 C5 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 66 0F 1F 84 00 00 00 00 00 41 83 F9 00 7F 4F 83 F9 00 0F 84 E1 00 00 00 25 00 00 80 7F 3D 00 00 00 4B 7F 3A 0F AE 5C 24 40 8B 54 24 40 81 CA 80 1F 00 00 89 54 24 50 0F AE 54 24 50 F3 0F 2D D1 F3 0F 2A D2 0F AE 54 24 40 0F 2E D1 0F 85 47 05 00 00 D1 DA 73 08 F3 0F 10 2D ?? ?? ?? ?? 66 0F 70 D8 EE F2 0F 5C 1D ?? ?? ?? ?? 66 48 0F 7E DA 48 0F BA F2 3F 48 3B 15 ?? ?? ?? ?? 0F 83 41 FE FF FF 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 CB 66 0F 28 F3 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E F1 66 0F 28 D6 F2 0F 59 F3 F2 0F 58 D2 66 0F 28 CA F2 0F 59 CA 66 0F 70 E1 44 66 0F 59 E7 F2 0F 59 D1 66 0F 58 25 ?? ?? ?? ?? F2 0F 59 C9 F2 0F 59 CA 66 0F 14 D1 66 0F 59 D4 66 0F 70 CA EE F2 0F 58 D1 F2 0F 5C D6 F2 0F 58 DA E9 6A FE FF FF 66 66 66 66 0F 1F 84 00 00 00 00 00 44 8B C0 66 0F 7E CA B8 00 00 00 00 41 BA 00 00 00 00 B9 00 00 80 7F 83 FA 00 0F 4C D1 44 0F 4C D1 0F 4F D0 B9 00 00 00 80 41 81 E0 00 00 80 7F 41 81 F8 00 00 00 4B 0F 4F C8 7F 43 0F AE 5C 24 40 44 8B 44 24 40 41 81 C8 80 1F 00 00 44 89 44 24 50 0F AE 54 24 50 F3 44 0F 2D C1 F3 41 0F 2A D0 0F AE 54 24 40 0F 2E D1 0F 45 C8 75 11 41 D1 D8 0F 43 C8 73 09 41 8B C9 81 E1 00 00 00 80 0B CA 66 0F 6E C1 41 83 FA 00 74 10 44 8B 0D ?? ?? ?? ?? 66 0F 6F D0 E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 0F 1F 40 00 83 F8 00 0F 84 47 02 00 00 66 0F 7E C1 66 0F 7E CA 81 F9 00 00 80 7F 74 17 81 F9 00 00 80 FF 74 1F E9 AA 02 00 00 66 66 0F 1F 84 00 00 00 00 00 83 FA 00 0F 8C 57 02 00 00 E9 72 02 00 00 66 90 44 8B C0 B8 00 00 00 00 B9 00 00 80 7F 83 FA 00 0F 4C D0 0F 4F D1 B9 00 00 00 80 41 81 E0 00 00 80 7F 41 81 F8 00 00 00 4B 0F 4F C8 7F 38 0F AE 5C 24 40 44 8B 44 24 40 41 81 C8 80 1F 00 00 44 89 44 24 50 0F AE 54 24 50 F3 44 0F 2D C1 F3 41 0F 2A D0 0F AE 54 24 40 0F 2E D1 0F 45 C8 75 06 41 D1 D8 0F 43 C8 0B CA 66 0F 6E C1 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 0F 1F 00 0F 87 8A 00 00 00 81 F9 00 00 80 7F 0F 87 FE 01 00 00 81 F9 00 00 80 3F 0F 84 92 01 00 00 66 0F 7E C8 0F BA E0 1F 72 18 81 F9 00 00 80 3F 0F 82 9C 01 00 00 E9 B7 01 00 00 0F 1F 80 00 00 00 00 BA 01 00 00 00 B8 00 00 00 00 41 B8 00 00 80 7F 83 F9 00 0F 84 97 01 00 00 0F 45 D0 81 F9 00 00 80 3F 41 0F 42 C0 66 0F 6E C0 83 FA 00 74 10 66 0F 6F D0 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 81 F9 00 00 80 7F 0F 87 D4 01 00 00 41 81 F9 00 00 80 3F 0F 84 B7 00 00 00 E9 92 01 00 00 66 90 83 F8 00 74 6B 66 0F 7E CA 81 FA 00 00 80 3F 0F 85 79 FB FF FF 66 41 0F 7E C1 41 81 E1 FF FF FF 7F 41 81 F9 00 00 80 7F 77 11 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 0F 7E C2 81 CA 00 00 40 00 66 0F 6E D2 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 66 0F 1F 84 00 00 00 00 00 81 F9 00 00 80 7F 76 68 81 F9 00 00 C0 7F 73 60 8B D1 81 CA 00 00 40 00 66 0F 6E D2 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 0F 1F 80 00 00 00 00 3D 00 00 C0 7F 73 29 BA 00 00 80 3F 66 0F 6E D2 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 0F 1F 00 BA 00 00 80 3F 66 0F 6E C2 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 BA 00 00 80 3F 66 0F 6E C2 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 66 0F EF C0 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 66 66 0F 1F 84 00 00 00 00 00 BA 00 00 80 7F 66 0F 6E C2 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 66 0F 7E C1 81 C9 00 00 40 00 66 0F 6E D1 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 0F 1F 44 00 00 66 0F 7E C8 0D 00 00 40 00 66 0F 6E D0 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 41 81 F9 00 00 C0 FF 74 2B 66 0F 7E C1 81 C9 00 00 40 00 66 0F 6E D1 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 0F 7E C8 0D 00 00 40 00 66 0F 6E D0 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 90 66 0F EF D2 0F 56 D5 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 BA 00 00 80 7F 66 0F 6E D2 0F 56 D5 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 0F 1F 80 00 00 00 00 BA 00 00 C0 FF 66 0F 6E D2 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 C5 F1 62 C8 C5 D1 EF ED C5 F9 7E C8 C5 F9 7E C1 44 8B C9 25 FF FF FF 7F 81 E1 FF FF FF 7F 3D 00 00 80 7F 0F 83 E1 03 00 00 3D 00 00 80 3F 0F 8E 76 04 00 00 81 F9 00 00 80 7F 0F 83 0A 03 00 00 C5 F8 5A C1 41 81 F9 00 00 88 3F 0F 8C 49 01 00 00 C5 F9 70 D0 EE C5 E9 DB 15 ?? ?? ?? ?? C4 E1 F9 7E D1 48 C1 E9 2C 83 D1 00 8B C1 81 C9 00 FE 03 00 48 C1 E1 2C C4 E1 F9 6E C9 C5 E9 EB 15 ?? ?? ?? ?? C5 F9 70 DA EE C5 E1 73 D3 34 C5 E1 FB 1D ?? ?? ?? ?? C5 FA E6 DB 48 8D 0D ?? ?? ?? ?? C5 F3 5C CA C5 F3 59 0C C1 C5 F9 28 D1 C5 FB 10 25 ?? ?? ?? ?? C4 E2 F1 A9 25 ?? ?? ?? ?? C4 E2 F1 A9 25 ?? ?? ?? ?? C5 F3 59 CC C5 E3 59 1D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? C5 E3 58 1C C1 C5 E3 5C D9 C5 FB 59 C3 C5 F9 2E 05 ?? ?? ?? ?? 0F 87 15 06 00 00 C5 F9 2E 05 ?? ?? ?? ?? 0F 86 D7 05 00 00 C5 F9 59 1D ?? ?? ?? ?? C5 FB E6 E3 C5 FA E6 D4 C5 F9 7E E1 C4 E2 E9 BD 05 ?? ?? ?? ?? C5 F9 28 C8 C5 FB 10 1D ?? ?? ?? ?? C4 E2 F9 A9 1D ?? ?? ?? ?? C4 E2 F9 A9 1D ?? ?? ?? ?? C5 FB 59 C3 48 C7 C0 3F 00 00 00 23 C1 48 8D 0D ?? ?? ?? ?? C5 FB 10 1C C1 C4 E2 E1 A9 C3 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 C5 D9 72 E4 06 C5 D9 73 F4 34 C5 D9 D4 E0 C5 FB 5A C4 C5 F8 56 C5 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 84 00 00 00 00 00 41 83 F9 00 7F 53 83 F9 00 0F 84 E1 00 00 00 25 00 00 80 7F 3D 00 00 00 4B 7F 3E C5 F8 AE 5C 24 40 8B 54 24 40 81 CA 80 1F 00 00 89 54 24 50 C5 F8 AE 54 24 50 C5 FA 2D D1 C5 EA 2A D2 C5 F8 AE 54 24 40 C5 F8 2E D1 0F 85 53 05 00 00 D1 DA 73 08 C5 FA 10 2D ?? ?? ?? ?? C5 F9 70 D8 EE C5 E3 5C 1D ?? ?? ?? ?? C4 E1 F9 7E DA 48 0F BA F2 3F 48 3B 15 ?? ?? ?? ?? 0F 83 3A FE FF FF C5 F9 70 ED 44 C5 F9 28 CB C5 D3 10 EB C5 F3 58 0D ?? ?? ?? ?? C5 D3 5E E9 C5 F9 28 D5 C5 D3 59 EB C5 EB 58 D2 C5 F9 28 CA C5 F3 59 CA C5 F9 70 E1 44 C5 D9 59 25 ?? ?? ?? ?? C5 EB 59 D1 C5 D9 58 25 ?? ?? ?? ?? C5 F3 59 C9 C5 F3 59 CA C5 E9 14 D1 C5 E9 59 D4 C5 F9 70 CA EE C5 F3 58 D2 C5 EB 5C D5 C5 F9 70 ED EE C5 E3 58 DA E9 10 F7 FF FF 66 90 44 8B C0 C5 F9 7E CA B8 00 00 00 00 41 BA 00 00 00 00 B9 00 00 80 7F 83 FA 00 0F 4C D1 44 0F 4C D1 0F 4F D0 B9 00 00 00 80 41 81 E0 00 00 80 7F 41 81 F8 00 00 00 4B 0F 4F C8 7F 46 C5 F8 AE 5C 24 40 44 8B 44 24 40 41 81 C8 80 1F 00 00 44 89 44 24 50 C5 F8 AE 54 24 50 C5 7A 2D C1 C4 C1 6A 2A D0 C5 F8 AE 54 24 40 C5 F8 2E D1 0F 45 C8 75 11 41 D1 D8 0F 43 C8 73 09 41 8B C9 81 E1 00 00 00 80 0B CA C5 F9 6E C1 41 83 FA 00 0F 84 B9 F8 FF FF 44 8B 0D ?? ?? ?? ?? C5 F9 6F D0 E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 66 66 66 66 0F 1F 84 00 00 00 00 00 83 F8 00 0F 84 27 02 00 00 C5 F9 7E C1 C5 F9 7E CA 81 F9 00 00 80 7F 74 17 81 F9 00 00 80 FF 74 1F E9 AA 02 00 00 66 66 0F 1F 84 00 00 00 00 00 83 FA 00 0F 8C 37 02 00 00 E9 52 02 00 00 66 90 44 8B C0 B8 00 00 00 00 B9 00 00 80 7F 83 FA 00 0F 4C D0 0F 4F D1 B9 00 00 00 80 41 81 E0 00 00 80 7F 41 81 F8 00 00 00 4B 0F 4F C8 7F 3B C5 F8 AE 5C 24 40 44 8B 44 24 40 41 81 C8 80 1F 00 00 44 89 44 24 50 C5 F8 AE 54 24 50 C5 7A 2D C1 C4 C1 6A 2A D0 C5 F8 AE 54 24 40 C5 F8 2E D1 0F 45 C8 75 06 41 D1 D8 0F 43 C8 0B CA C5 F9 6E C1 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 77 6E 81 F9 00 00 80 7F 0F 87 02 02 00 00 81 F9 00 00 80 3F 0F 84 76 01 00 00 C5 F9 7E C8 0F BA E0 1F 72 1C 81 F9 00 00 80 3F 0F 82 80 01 00 00 E9 9B 01 00 00 66 66 66 0F 1F 84 00 00 00 00 00 B8 00 00 00 00 41 B8 00 00 80 7F 81 F9 00 00 80 3F 41 0F 42 C0 C5 F9 6E C0 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 81 F9 00 00 80 7F 0F 87 F4 01 00 00 41 81 F9 00 00 80 3F 0F 84 B7 00 00 00 C5 F9 6F C1 E9 AE 01 00 00 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 83 F8 00 74 5B C5 F9 7E CA 81 FA 00 00 80 3F 0F 85 75 FB FF FF 81 F9 00 00 80 7F 77 11 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 C5 F9 7E C2 81 CA 00 00 40 00 C5 F9 6E D2 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 0F 6F 7C 24 30 66 0F 6F 74 24 20 48 83 C4 68 C3 0F 1F 80 00 00 00 00 81 F9 00 00 80 7F 76 68 81 F9 00 00 C0 7F 73 60 8B D1 81 CA 00 00 40 00 C5 F9 6E D2 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 0F 1F 80 00 00 00 00 3D 00 00 C0 7F 73 29 BA 00 00 80 3F C5 F9 6E D2 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 0F 1F 00 BA 00 00 80 3F C5 F9 6E C2 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 BA 00 00 80 3F C5 F9 6E C2 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 C5 F9 EF C0 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 66 66 0F 1F 84 00 00 00 00 00 BA 00 00 80 7F C5 F9 6E C2 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 C5 FA 58 C0 C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 66 66 0F 1F 84 00 00 00 00 00 C5 F9 7E C1 81 C9 00 00 40 00 C5 F9 6E D1 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 0F 1F 44 00 00 C5 F9 7E C8 0D 00 00 40 00 C5 F9 6E D0 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 41 81 F9 00 00 C0 FF 74 2B C5 F9 7E C1 81 C9 00 00 40 00 C5 F9 6E D1 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 C5 F9 7E C8 0D 00 00 40 00 C5 F9 6E D0 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 90 C5 E9 EF D2 C5 E8 56 D5 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 66 66 0F 1F 84 00 00 00 00 00 BA 00 00 80 7F C5 F9 6E D2 C5 E8 56 D5 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 66 0F 1F 44 00 00 BA 00 00 C0 FF C5 F9 6E D2 44 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C5 F9 6F 7C 24 30 C5 F9 6F 74 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "catanhf"
		size = 803
		refs = "0032 crealf 0040 cimagf 004e _fdtest 008b __real@bfc90fdb 00c7 _FZero_C 00ce __xmm@80000000800000008000000080000000 0111 __real@3fc90fdb 0166 __real@5e7fe80a 0173 __real@3f800000 01f8 _fperrraise 0205 _FInf_C 021b __real@40800000 0220 sqrtf 023d logf 0245 __real@40000000 0251 atan2f 0265 __real@3f000000 029e log1pf 02c3 __real@3e800000 02f2 _FCbuild"
	strings:
		$1 = { 48 8B C4 55 53 57 48 8D 68 A1 48 81 EC 90 00 00 00 0F 29 70 D8 0F 29 78 C8 44 0F 29 40 B8 44 0F 29 48 A8 44 0F 29 50 98 44 0F 29 58 88 48 89 4D D7 E8 ?? ?? ?? ?? 48 8B 4D D7 F3 0F 11 45 77 E8 ?? ?? ?? ?? 48 8D 4D 77 F3 0F 11 45 6F E8 ?? ?? ?? ?? 48 8D 4D 6F 0F B7 F8 E8 ?? ?? ?? ?? 66 83 FF 02 75 3D 66 3B C7 75 07 F3 0F 10 7D 77 EB 67 BB 01 00 00 00 66 3B C3 75 1A 0F 57 FF 0F 2F 7D 6F 0F 86 86 00 00 00 F3 0F 10 05 ?? ?? ?? ?? E9 57 02 00 00 F3 0F 10 7D 77 0F 28 C7 E9 4A 02 00 00 BB 01 00 00 00 66 83 F8 02 75 35 66 3B FB 76 07 F3 0F 10 7D 6F EB E1 B8 00 80 00 00 66 85 45 79 74 11 F3 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? EB 03 0F 57 FF F3 0F 10 45 6F E9 0A 02 00 00 66 3B FB 75 34 0F 57 FF 0F 2F 7D 77 76 0F F3 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? B8 00 80 00 00 66 85 45 71 0F 85 7A FF FF FF F3 0F 10 05 ?? ?? ?? ?? E9 D1 01 00 00 F3 44 0F 10 45 6F B8 00 80 00 00 45 0F 28 D0 F3 44 0F 10 0D ?? ?? ?? ?? 66 85 45 71 74 04 45 0F 57 D1 F3 0F 10 55 77 45 0F 57 DB 44 0F 2F DA 76 0B 41 0F 57 D1 F3 0F 11 55 77 EB 0C 45 0F 57 C1 33 DB F3 44 0F 11 45 6F F3 0F 10 05 ?? ?? ?? ?? 0F 2F D0 76 36 F3 0F 10 05 ?? ?? ?? ?? 41 0F 28 C8 F3 0F 5E CA 0F 28 F8 F3 0F 5E FA F3 0F 59 C9 F3 0F 58 C8 F3 0F 5E F9 45 0F 2F D8 76 32 F3 0F 10 05 ?? ?? ?? ?? E9 38 01 00 00 44 0F 2F D0 76 2C F3 41 0F 5E D0 0F 28 FA F3 0F 59 D2 F3 41 0F 5E F8 F3 0F 58 15 ?? ?? ?? ?? F3 0F 5E FA EB C8 F3 0F 10 05 ?? ?? ?? ?? E9 06 01 00 00 0F 2E 15 ?? ?? ?? ?? 0F 8A 8D 00 00 00 0F 85 87 00 00 00 45 0F 2E C3 7A 1E 75 1C B9 04 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 45 6F F3 0F 10 3D ?? ?? ?? ?? E9 CF 00 00 00 41 0F 28 C0 F3 41 0F 59 C0 F3 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 F0 41 0F 28 C2 E8 ?? ?? ?? ?? F3 0F 5E F0 0F 28 C6 E8 ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? 0F 28 F8 41 0F 28 C2 E8 ?? ?? ?? ?? 45 0F 2F D8 F3 0F 58 05 ?? ?? ?? ?? F3 0F 59 05 ?? ?? ?? ?? 76 72 41 0F 57 C1 EB 6C F3 0F 10 35 ?? ?? ?? ?? F3 0F 5C F2 F3 45 0F 59 D2 F3 0F 59 15 ?? ?? ?? ?? 0F 28 CE F3 0F 59 CE F3 41 0F 58 CA F3 0F 5E D1 0F 28 C2 E8 ?? ?? ?? ?? F3 0F 10 4D 77 0F 28 F8 F3 0F 58 0D ?? ?? ?? ?? F3 0F 10 45 6F F3 0F 59 05 ?? ?? ?? ?? F3 0F 59 3D ?? ?? ?? ?? F3 0F 59 CE F3 41 0F 5C CA E8 ?? ?? ?? ?? F3 0F 59 05 ?? ?? ?? ?? 85 DB 74 06 41 0F 57 F9 EB 04 41 0F 57 C1 0F 28 C8 0F 28 C7 E8 ?? ?? ?? ?? 0F 28 7C 24 70 4C 8D 9C 24 90 00 00 00 41 0F 28 73 F0 45 0F 28 43 D0 45 0F 28 4B C0 45 0F 28 53 B0 45 0F 28 5B A0 49 8B E3 5F 5B 5D C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__dcrt_lowio_initialize_console_input"
		size = 59
		refs = "000d ??_C@_1O@PNMIMBDD@?$AAC?$AAO?$AAN?$AAI?$AAN?$AA$?$AA?$AA@ 002b __imp_CreateFileW 0032 __dcrt_lowio_console_input_handle"
	strings:
		$1 = { 48 83 EC 48 48 83 64 24 30 00 48 8D 0D ?? ?? ?? ?? 83 64 24 28 00 41 B8 03 00 00 00 45 33 C9 44 89 44 24 20 BA 00 00 00 C0 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "__dcrt_terminate_console_input"
		size = 32
		refs = "0007 __dcrt_lowio_console_input_handle 0017 __imp_CloseHandle"
	strings:
		$1 = { 48 83 EC 28 48 8B 0D ?? ?? ?? ?? 48 8D 41 02 48 83 F8 01 76 06 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_197_1_0 {
	meta:
		name = "__dcrt_terminate_console_output"
		size = 32
		refs = "0007 __dcrt_lowio_console_output_handle 0017 __imp_CloseHandle"
	strings:
		$1 = { 48 83 EC 28 48 8B 0D ?? ?? ?? ?? 48 8D 41 02 48 83 F8 01 76 06 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_45_4_0 {
	meta:
		name = "_towupper_l"
		size = 201
		refs = "0020 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 005b iswctype 009f __acrt_LCMapStringW"
	strings:
		$1 = { 66 89 4C 24 08 55 48 8B EC 48 83 EC 50 B8 FF FF 00 00 66 3B C8 0F 84 A8 00 00 00 48 8D 4D E0 E8 ?? ?? ?? ?? 48 8B 45 E8 4C 8B 90 38 01 00 00 4D 85 D2 75 13 0F B7 55 10 8D 42 9F 66 83 F8 19 77 6E 66 83 EA 20 EB 68 0F B7 4D 10 B8 00 01 00 00 66 3B C8 73 29 BA 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 06 0F B7 55 10 EB 46 48 8B 45 E8 0F B7 55 10 48 8B 88 18 01 00 00 0F B6 14 11 EB 31 41 B9 01 00 00 00 48 8D 45 20 44 89 4C 24 28 4C 8D 45 10 BA 00 02 00 00 48 89 44 24 20 49 8B CA E8 ?? ?? ?? ?? 0F B7 55 10 85 C0 74 04 0F B7 55 20 80 7D F8 00 74 0B 48 8B 4D E0 83 A1 A8 03 00 00 FD 0F B7 C2 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__acrt_wcstok_s_novalidation"
		size = 141
	strings:
		$1 = { 33 C0 4D 8B D8 4C 8B D2 48 85 C9 75 30 49 8B 08 EB 2B 4D 8B C2 66 41 39 02 74 18 45 0F B7 0A 66 44 3B CA 74 0E 49 83 C0 02 45 0F B7 08 66 45 85 C9 75 EC 66 41 39 00 74 0C 48 83 C1 02 0F B7 11 66 85 D2 75 CD 4C 8B C9 EB 2A 49 8B D2 66 41 39 02 74 18 45 0F B7 02 66 44 3B 01 74 0E 48 83 C2 02 44 0F B7 02 66 45 85 C0 75 EC 66 39 02 75 0B 48 83 C1 02 66 39 01 75 D1 EB 07 66 89 01 48 83 C1 02 49 3B C9 49 89 0B 49 0F 45 C1 C3 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "wcstok_s"
		size = 56
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0034 __acrt_wcstok_s_novalidation"
	strings:
		$1 = { 48 83 EC 28 4D 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 48 85 D2 74 E4 48 85 C9 75 05 49 39 08 74 DA 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_514_1_0 {
	meta:
		name = "strtok_s"
		size = 56
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0034 __acrt_strtok_s_novalidation"
	strings:
		$1 = { 48 83 EC 28 4D 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 48 85 D2 74 E4 48 85 C9 75 05 49 39 08 74 DA 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_5_0 {
	meta:
		name = "_ismbclegal_l"
		size = 82
		refs = "000e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B C3 C1 E8 08 0F B6 D0 F6 44 0A 19 04 74 11 0F B6 C3 F6 44 08 19 08 74 07 B8 01 00 00 00 EB 02 33 C0 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_49_5_0 {
	meta:
		name = "_mbsicoll_l"
		size = 201
		refs = "0021 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0030 _errno 003b _invalid_parameter_noinfo 0056 _stricoll_l 0089 __acrt_CompareStringA"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 60 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 40 49 8B F0 E8 ?? ?? ?? ?? 48 85 FF 74 05 48 85 DB 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 5B 48 8B 54 24 50 83 7A 08 00 75 10 4C 8B C6 48 8B D3 48 8B CF E8 ?? ?? ?? ?? EB 4A 8B 42 04 48 8D 4C 24 48 48 8B 92 20 02 00 00 4C 8B CF 89 44 24 38 41 B8 01 10 00 00 83 C8 FF 89 44 24 30 48 89 5C 24 28 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 C0 FE 80 7C 24 58 00 74 0C 48 8B 4C 24 40 83 A1 A8 03 00 00 FD 48 8B 5C 24 70 48 8B 74 24 78 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_50_2_0 {
	meta:
		name = "??$common_getdcwd@D@@YAPEADHQEADHHQEBDH@Z"
		size = 323
		refs = "0024 _errno 002f _invalid_parameter_noinfo 003f ?is_valid_drive@@YAHI@Z 0048 __doserrno 0060 _getdrive 009e ??$common_getdcwd_user_buffer@D@@YAPEADQEAD0I@Z 00b6 __imp_GetFullPathNameA 00c2 __imp_GetLastError 00c9 __acrt_errno_map_os_error 00dc calloc 0101 free"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 20 57 48 83 EC 20 33 FF 41 8B E8 48 8B F2 8B D9 45 85 C0 79 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 F4 00 00 00 85 C9 74 21 E8 ?? ?? ?? ?? 85 C0 75 1F E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB CF E8 ?? ?? ?? ?? 8B D8 85 DB 74 15 80 C3 40 66 C7 44 24 41 3A 2E 88 5C 24 40 40 88 7C 24 43 EB 07 66 C7 44 24 40 2E 00 48 85 F6 74 1C 85 ED 7E 94 44 8B C5 40 88 3E 48 8B D6 48 8D 4C 24 40 E8 ?? ?? ?? ?? E9 87 00 00 00 45 33 C9 48 8D 4C 24 40 45 33 C0 33 D2 FF 15 ?? ?? ?? ?? 8B F0 85 C0 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 5C 3B E8 BA 01 00 00 00 0F 47 F5 8B CE E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 1F E8 ?? ?? ?? ?? C7 00 08 00 00 00 E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? EB 24 44 8B C6 48 8D 4C 24 40 48 8B D0 E8 ?? ?? ?? ?? 48 85 C0 75 05 48 8B CB EB DF 33 C9 E8 ?? ?? ?? ?? 48 8B FB 48 8B C7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 48 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_50_3_0 {
	meta:
		name = "??$common_getdcwd@_W@@YAPEA_WHQEA_WHHQEBDH@Z"
		size = 339
		refs = "000f __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 0046 ?is_valid_drive@@YAHI@Z 004f __doserrno 0067 _getdrive 00a9 ??$common_getdcwd_user_buffer@_W@@YAPEA_WQEA_W0I@Z 00c1 __imp_GetFullPathNameW 00cd __imp_GetLastError 00d4 __acrt_errno_map_os_error 00e7 calloc 010c free 0142 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 55 56 57 48 83 EC 30 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 28 33 FF 41 8B E8 48 8B F2 8B D9 45 85 C0 79 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 F8 00 00 00 85 C9 74 21 E8 ?? ?? ?? ?? 85 C0 75 1F E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB CF E8 ?? ?? ?? ?? 8B D8 85 DB 74 18 66 83 C3 40 C7 44 24 22 3A 00 2E 00 66 89 5C 24 20 66 89 7C 24 26 EB 08 C7 44 24 20 2E 00 00 00 48 85 F6 74 1C 85 ED 7E 90 44 8B C5 66 89 3E 48 8B D6 48 8D 4C 24 20 E8 ?? ?? ?? ?? E9 87 00 00 00 45 33 C9 48 8D 4C 24 20 45 33 C0 33 D2 FF 15 ?? ?? ?? ?? 8B F0 85 C0 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 5C 3B E8 BA 02 00 00 00 0F 47 F5 8B CE E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 1F E8 ?? ?? ?? ?? C7 00 08 00 00 00 E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? EB 24 44 8B C6 48 8D 4C 24 20 48 8B D0 E8 ?? ?? ?? ?? 48 85 C0 75 05 48 8B CB EB DF 33 C9 E8 ?? ?? ?? ?? 48 8B FB 48 8B C7 48 8B 4C 24 28 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 83 C4 30 5F 5E 5D C3 }
	condition:
		$1
}

rule file_50_4_0 {
	meta:
		name = "??$common_getdcwd_dynamic_buffer@D@@YAPEADQEADIHQEBDH@Z"
		size = 173
		refs = "0023 __imp_GetFullPathNameA 0031 __imp_GetLastError 0038 __acrt_errno_map_os_error 004d calloc 005a __doserrno 0065 _errno 007b ??$common_getdcwd_user_buffer@D@@YAPEADQEAD0I@Z 0091 free"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 8B DA 45 33 C9 33 D2 45 33 C0 48 8B E9 FF 15 ?? ?? ?? ?? 33 FF 8B F0 85 C0 75 11 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 EB 58 3B D8 BA 01 00 00 00 0F 47 F3 8B CE E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 08 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 1C 44 8B C6 48 8B D0 48 8B CD E8 ?? ?? ?? ?? 48 85 C0 74 09 48 8B CB 48 8B DF 48 8B F9 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_50_5_0 {
	meta:
		name = "??$common_getdcwd_dynamic_buffer@_W@@YAPEA_WQEA_WIHQEBDH@Z"
		size = 173
		refs = "0023 __imp_GetFullPathNameW 0031 __imp_GetLastError 0038 __acrt_errno_map_os_error 004d calloc 005a __doserrno 0065 _errno 007b ??$common_getdcwd_user_buffer@_W@@YAPEA_WQEA_W0I@Z 0091 free"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 8B DA 45 33 C9 33 D2 45 33 C0 48 8B E9 FF 15 ?? ?? ?? ?? 33 FF 8B F0 85 C0 75 11 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 EB 58 3B D8 BA 02 00 00 00 0F 47 F3 8B CE E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 08 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 1C 44 8B C6 48 8B D0 48 8B CD E8 ?? ?? ?? ?? 48 85 C0 74 09 48 8B CB 48 8B DF 48 8B F9 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_50_6_0 {
	meta:
		name = "??$common_getdcwd_user_buffer@D@@YAPEADQEAD0I@Z"
		size = 105
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 0033 __imp_GetFullPathNameA 004e __imp_GetLastError 0055 __acrt_errno_map_os_error"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 41 8B F8 48 8B DA 45 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 35 4C 8B C2 45 33 C9 8B D7 FF 15 ?? ?? ?? ?? 3B C7 72 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB DD 85 C0 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB CA 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_50_7_0 {
	meta:
		name = "??$common_getdcwd_user_buffer@_W@@YAPEA_WQEA_W0I@Z"
		size = 105
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 0033 __imp_GetFullPathNameW 004e __imp_GetLastError 0055 __acrt_errno_map_os_error"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 41 8B F8 48 8B DA 45 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 35 4C 8B C2 45 33 C9 8B D7 FF 15 ?? ?? ?? ?? 3B C7 72 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB DD 85 C0 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB CA 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_50_16_0 {
	meta:
		name = "?get_full_path_name@@YAIQEADQEBDI@Z"
		size = 24
		refs = "0014 __imp_GetFullPathNameA"
	strings:
		$1 = { 41 8B C0 4C 8B D2 4C 8B C1 8B D0 49 8B CA 45 33 C9 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_17_0 {
	meta:
		name = "?get_full_path_name@@YAIQEA_WQEB_WI@Z"
		size = 24
		refs = "0014 __imp_GetFullPathNameW"
	strings:
		$1 = { 41 8B C0 4C 8B D2 4C 8B C1 8B D0 49 8B CA 45 33 C9 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_18_0 {
	meta:
		name = "?is_valid_drive@@YAHI@Z"
		size = 128
		refs = "0009 __security_cookie 001b __doserrno 0026 _errno 0031 _invalid_parameter_noinfo 0061 __imp_GetDriveTypeW 0076 __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 28 83 F9 1A 76 1F E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 34 33 DB 85 C9 75 05 8D 43 01 EB 29 66 83 C1 40 C7 44 24 22 3A 00 5C 00 66 89 4C 24 20 48 8D 4C 24 20 66 89 5C 24 26 FF 15 ?? ?? ?? ?? 83 F8 02 0F 93 C3 8B C3 48 8B 4C 24 28 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_50_21_0 {
	meta:
		name = "_getcwd"
		size = 39
		refs = "001e ??$common_getdcwd@D@@YAPEADHQEADHHQEBDH@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 28 00 44 8B C2 48 83 64 24 20 00 48 8B D1 33 C9 41 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_50_23_0 {
	meta:
		name = "_wgetcwd"
		size = 39
		refs = "001e ??$common_getdcwd@_W@@YAPEA_WHQEA_WHHQEBDH@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 28 00 44 8B C2 48 83 64 24 20 00 48 8B D1 33 C9 41 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_50_22_0 {
	meta:
		name = "_getdcwd"
		size = 31
		refs = "0016 ??$common_getdcwd@D@@YAPEADHQEADHHQEBDH@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 28 00 41 B9 01 00 00 00 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_156_32_0 {
	meta:
		name = "_dupenv_s"
		size = 31
		refs = "0016 ??$common_dupenv_s@D@@YAHQEAPEADQEA_KQEBDH2H@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 28 00 41 B9 01 00 00 00 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_156_34_0 {
	meta:
		name = "_wdupenv_s"
		size = 31
		refs = "0016 ??$common_dupenv_s@_W@@YAHQEAPEA_WQEA_KQEB_WHQEBDH@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 28 00 41 B9 01 00 00 00 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_50_24_0 {
	meta:
		name = "_wgetdcwd"
		size = 31
		refs = "0016 ??$common_getdcwd@_W@@YAPEA_WHQEA_WHHQEBDH@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 28 00 41 B9 01 00 00 00 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_51_6_0 {
	meta:
		name = "_access"
		size = 18
		refs = "0005 _access_s"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? F7 D8 1B C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "_waccess"
		size = 18
		refs = "0005 _waccess_s"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? F7 D8 1B C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_51_7_0 {
	meta:
		name = "_access_s"
		size = 77
		refs = "000e _waccess_s 0020 __acrt_copy_path_to_wide_string 0041 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 8B DA 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 33 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0E 48 8B 4C 24 30 8B D3 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_493_6_0 {
	meta:
		name = "_chmod"
		size = 77
		refs = "000e _wchmod 0020 __acrt_copy_path_to_wide_string 0041 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 8B DA 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 33 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0E 48 8B 4C 24 30 8B D3 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_dpoly"
		size = 28
		altNames = "_ldpoly"
	strings:
		$1 = { 0F 28 C8 F2 0F 10 02 EB 0C F2 0F 59 C1 48 83 C2 08 F2 0F 58 02 41 83 E8 01 79 EE C3 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "erfc"
		size = 633
		refs = "0022 _dtest 0049 __real@3fde861fbb24c00a 005c erf 0064 __real@3ff0000000000000 0078 __real@3ff85e353f7ced91 009d __real@bfe8000000000000 00a5 __real@3f2ae308ebe29ba9 00ac s00 00c5 __real@becfb31f5ac7b849 00cc c00 00f3 __real@bff4800000000000 00fb __real@3ee0332f18362059 0102 s01 011b __real@3f215bbcc2cdf4ec 0122 c01 0141 approx 0167 _fperrraise 01e9 _d_int 0207 exp 0223 __xmm@80000000000000008000000000000000 0230 _dexp 0255 __real@4000000000000000"
	strings:
		$1 = { 48 8B C4 F2 0F 11 40 08 55 48 8B EC 48 83 EC 50 0F 29 70 E8 48 8D 4D 10 0F 29 78 D8 44 0F 29 40 C8 E8 ?? ?? ?? ?? 0F BF C8 33 D2 85 C9 0F 84 28 02 00 00 83 E9 01 0F 84 06 02 00 00 83 F9 01 0F 84 F6 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 55 10 66 0F 2F CA 76 1C 0F 28 C2 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C C8 0F 28 C1 E9 EF 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C2 0F 86 B8 00 00 00 F2 0F 10 05 ?? ?? ?? ?? B8 07 00 00 00 66 0F 2F C2 76 56 F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C1 08 F2 0F 59 C2 83 E8 01 F2 0F 58 01 79 EF F2 0F 10 0D ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? B9 08 00 00 00 48 83 C0 08 F2 0F 59 CA 83 E9 01 F2 0F 58 08 79 EF F2 0F 5E C1 E9 74 01 00 00 F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C1 08 F2 0F 59 C2 83 E8 01 F2 0F 58 01 79 EF F2 0F 10 0D ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? B9 08 00 00 00 48 83 C0 08 F2 0F 59 CA 83 E9 01 F2 0F 58 08 79 EF EB A8 4C 8D 05 ?? ?? ?? ?? 49 8B C8 F2 0F 10 01 66 0F 2F C2 77 21 FF C2 48 83 C1 30 48 63 C2 48 83 F8 06 72 E7 B9 10 00 00 00 E8 ?? ?? ?? ?? 0F 57 C0 E9 F0 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 48 63 C2 F2 0F 5E C2 48 8D 0C 40 48 03 C9 49 8B 44 C8 10 41 8B 54 C8 18 F2 41 0F 5C 44 C8 08 F2 0F 11 45 18 F2 44 0F 10 00 EB 0E F2 44 0F 59 C0 48 83 C0 08 F2 44 0F 58 00 83 EA 01 79 ED 49 8B 44 C8 20 41 8B 4C C8 28 F2 0F 10 38 EB 0C F2 0F 59 F8 48 83 C0 08 F2 0F 58 38 83 E9 01 79 EF BA 11 00 00 00 F2 0F 11 55 18 48 8D 4D 18 E8 ?? ?? ?? ?? F2 0F 10 75 18 0F 28 CE 0F 28 C6 F2 0F 5C 45 10 F2 0F 58 4D 10 F2 0F 59 C1 E8 ?? ?? ?? ?? F2 44 0F 5E C7 48 8D 4D 18 45 33 C0 F2 0F 59 F6 F2 41 0F 59 C0 0F 57 35 ?? ?? ?? ?? F2 0F 11 75 18 0F 28 C8 E8 ?? ?? ?? ?? F2 0F 10 45 18 EB 28 F2 0F 10 45 10 EB 21 B8 00 80 00 00 66 85 45 16 0F 84 1A FF FF FF F2 0F 10 05 ?? ?? ?? ?? EB 08 F2 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 40 0F 28 7C 24 30 44 0F 28 44 24 20 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "llround"
		size = 97
		refs = "0010 _dtest 0027 round 002f __real@c3e0000000000000 003f __real@43e0000000000000 0056 _fperrraise"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 98 85 C0 74 41 FF C8 83 F8 01 76 30 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? F2 0F 11 44 24 30 72 15 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 72 07 F2 48 0F 2C C0 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "llroundl"
		size = 97
		refs = "0010 _ldtest 0027 roundl 002f __real@c3e0000000000000 003f __real@43e0000000000000 0056 _fperrraise"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 98 85 C0 74 41 FF C8 83 F8 01 76 30 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? F2 0F 11 44 24 30 72 15 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 72 07 F2 48 0F 2C C0 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "nearbyintl"
		size = 44
		refs = "0010 _ldtest 0023 _ldrint"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 0F BF C8 83 F9 02 76 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "nearbyint"
		size = 44
		refs = "0010 _dtest 0023 _drint"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 0F BF C8 83 F9 02 76 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "?dup_nolock@@YAHH@Z"
		size = 393
		refs = "0027 __pioinfo 0049 _alloc_osfhnd 005a _errno 0065 __doserrno 0078 __imp_GetCurrentProcess 0082 _get_osfhandle 00b7 __imp_DuplicateHandle 00c1 __imp_GetLastError 00c8 __acrt_errno_map_os_error 00e0 __acrt_lowio_set_os_handle 0169 __acrt_lowio_unlock_fh"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 50 48 63 D9 4C 8B F3 4C 8B FB 49 C1 FF 06 4C 8D 2D ?? ?? ?? ?? 41 83 E6 3F 49 C1 E6 06 4B 8B 44 FD 00 42 F6 44 30 38 01 75 08 83 C8 FF E9 27 01 00 00 E8 ?? ?? ?? ?? 48 63 F0 89 74 24 44 83 FE FF 75 15 E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? 83 20 00 EB D2 45 32 E4 44 88 64 24 40 FF 15 ?? ?? ?? ?? 48 8B F8 8B CB E8 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? 48 8B C8 C7 44 24 30 02 00 00 00 C7 44 24 28 01 00 00 00 83 64 24 20 00 4C 8D 8C 24 88 00 00 00 4C 8B C7 48 8B D3 FF 15 ?? ?? ?? ?? 85 C0 75 16 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 83 CE FF 89 74 24 44 EB 71 48 8B 94 24 88 00 00 00 8B CE E8 ?? ?? ?? ?? 4C 8B C6 48 8B D6 48 C1 FA 06 41 83 E0 3F 49 C1 E0 06 4B 8B 44 FD 00 42 0F B6 4C 30 38 83 E1 EF 49 8B 44 D5 00 41 88 4C 00 38 4B 8B 44 FD 00 49 8B 4C D5 00 42 8A 44 30 39 41 88 44 08 39 49 8B 54 D5 00 4B 8B 44 FD 00 42 8A 4C 30 3D 41 32 4C 10 3D 80 E1 01 41 30 4C 10 3D 41 B4 01 44 88 64 24 40 45 84 E4 75 1B 48 63 CE 48 8B C1 48 C1 F8 06 83 E1 3F 48 C1 E1 06 49 8B 44 C5 00 80 64 08 38 FE 8B CE E8 ?? ?? ?? ?? 8B C6 4C 8D 5C 24 50 49 8B 5B 30 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "?fin$0@?0??dup_nolock@@YAHH@Z@4HA"
		size = 65
		refs = "001d __pioinfo 0035 __acrt_lowio_unlock_fh"
	strings:
		$1 = { 40 55 48 83 EC 40 48 8B EA 80 7D 40 00 75 22 48 63 4D 44 48 8B C1 48 C1 F8 06 48 8D 15 ?? ?? ?? ?? 83 E1 3F 48 C1 E1 06 48 8B 04 C2 80 64 08 38 FE 8B 4D 44 E8 ?? ?? ?? ?? 90 48 83 C4 40 5D C3 CC }
	condition:
		$1
}

rule file_55_2_0 {
	meta:
		name = "_dup"
		size = 214
		refs = "0020 __doserrno 0028 _errno 003d _nhandle 0050 __pioinfo 006c __acrt_lowio_lock_fh 0081 ?dup_nolock@@YAHH@Z 009f __acrt_lowio_unlock_fh 00bb _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 89 4C 24 08 57 41 56 41 57 48 83 EC 20 48 63 D9 83 FB FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 88 00 00 00 85 C9 78 6C 3B 1D ?? ?? ?? ?? 73 64 48 8B F3 4C 8B F3 49 C1 FE 06 4C 8D 3D ?? ?? ?? ?? 83 E6 3F 48 C1 E6 06 4B 8B 04 F7 0F B6 4C 30 38 83 E1 01 74 3E 8B CB E8 ?? ?? ?? ?? 83 CF FF 4B 8B 04 F7 F6 44 30 38 01 74 0B 8B CB E8 ?? ?? ?? ?? 8B F8 EB 13 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 8B CB E8 ?? ?? ?? ?? 8B C7 EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_55_3_0 {
	meta:
		name = "_dup$fin$0"
		size = 23
		refs = "0012 __acrt_lowio_unlock_fh"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 4D 40 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_56_7_0 {
	meta:
		name = "?_strlwr_s_l_stat@@YAHQEAD_KQEAU__crt_locale_pointers@@@Z"
		size = 549
		refs = "001e __security_cookie 0038 _errno 0044 _invalid_parameter_noinfo 004e strnlen 0097 __acrt_LCMapStringA 013a __chkstk 015d _malloc_base 01d7 strcpy_s 01fd _free_base 020b __security_check_cookie"
	strings:
		$1 = { 40 55 41 56 41 57 48 83 EC 60 48 8D 6C 24 50 48 89 5D 30 48 89 75 38 48 89 7D 40 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 00 4D 8B F0 48 8B F2 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? E9 B4 01 00 00 E8 ?? ?? ?? ?? 48 3B C6 72 05 C6 03 00 EB DB 49 8B 06 48 8B 90 38 01 00 00 48 85 D2 74 60 8B 40 0C 4C 8B CB C7 44 24 40 01 00 00 00 41 B8 00 01 00 00 89 44 24 38 49 8B CE 83 64 24 30 00 48 83 64 24 28 00 83 4C 24 20 FF E8 ?? ?? ?? ?? 4C 63 F8 85 C0 75 35 E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 E8 ?? ?? ?? ?? 8B 00 E9 49 01 00 00 8A 0B 8D 41 BF 3C 19 77 05 80 C1 20 88 0B 48 FF C3 80 3B 00 75 EA 33 C0 E9 2C 01 00 00 49 8B D7 49 3B F7 73 12 C6 03 00 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 50 FF FF FF 49 8D 4F 10 48 3B D1 48 1B C0 48 85 C1 74 75 49 8D 4F 10 48 3B D1 48 1B C0 48 23 C1 48 3D 00 04 00 00 49 8D 47 10 77 3A 48 3B D0 48 1B C9 48 23 C8 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 7C 24 50 48 85 FF 74 31 C7 07 CC CC 00 00 EB 1C 48 3B D0 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0E C7 00 DD DD 00 00 48 83 C7 10 EB 02 33 FF 48 85 FF 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 18 EB 5B 49 8B 16 4C 8B CB C7 44 24 40 01 00 00 00 41 B8 00 01 00 00 49 8B CE 8B 42 0C 48 8B 92 38 01 00 00 89 44 24 38 44 89 7C 24 30 48 89 7C 24 28 83 4C 24 20 FF E8 ?? ?? ?? ?? 85 C0 74 12 4C 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 8B D8 EB 0C E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 48 85 FF 74 11 48 8D 4F F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 4D 00 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 30 48 8B 75 38 48 8B 7D 40 48 8D 65 10 41 5F 41 5E 5D C3 }
	condition:
		$1
}

rule file_56_13_0 {
	meta:
		name = "_strlwr"
		size = 88
		refs = "000f __acrt_locale_changed_data 001b _errno 0026 _invalid_parameter_noinfo 004b _strlwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 45 33 C0 48 8B D9 44 39 05 ?? ?? ?? ?? 75 31 48 85 C9 75 25 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 24 8A 11 8D 42 BF 3C 19 77 05 80 C2 20 88 11 48 FF C1 44 38 01 75 EA EB 09 48 83 CA FF E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_56_14_0 {
	meta:
		name = "_strlwr_l"
		size = 30
		refs = "0011 _strlwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 8B D9 48 83 CA FF E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_654_14_0 {
	meta:
		name = "_strupr_l"
		size = 30
		refs = "0011 _strupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 8B D9 48 83 CA FF E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_453_14_0 {
	meta:
		name = "_wcslwr_l"
		size = 30
		refs = "0011 _wcslwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 8B D9 48 83 CA FF E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_97_13_0 {
	meta:
		name = "_wcsupr_l"
		size = 30
		refs = "0011 _wcsupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 8B D9 48 83 CA FF E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_56_16_0 {
	meta:
		name = "_strlwr_s_l"
		size = 75
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0029 ?_strlwr_s_l_stat@@YAHQEAD_KQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8D 44 24 28 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_654_16_0 {
	meta:
		name = "_strupr_s_l"
		size = 75
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0029 ?_strupr_s_l_stat@@YAHQEAD_KQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8D 44 24 28 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_453_16_0 {
	meta:
		name = "_wcslwr_s_l"
		size = 75
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0029 ?_wcslwr_s_l_stat@@YAHPEA_W_KPEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8D 44 24 28 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_97_15_0 {
	meta:
		name = "_wcsupr_s_l"
		size = 75
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0029 ?_wcsupr_s_l_stat@@YAHQEA_W_KQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8D 44 24 28 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "_lsearch_s"
		size = 184
		refs = "002b _errno 0036 _invalid_parameter_noinfo 0076 __guard_dispatch_icall_fptr 0090 memcpy"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 49 8B F1 49 8B E8 48 8B DA 4C 8B F1 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 5F 4D 85 C0 74 E7 48 85 D2 74 E2 4D 85 C9 74 DD 48 83 7C 24 50 00 74 D5 41 8B 38 48 0F AF FE 48 03 FA 48 3B D7 74 22 48 8B 4C 24 58 4C 8B C3 48 8B 44 24 50 49 8B D6 FF 15 ?? ?? ?? ?? 85 C0 74 1C 48 03 DE 48 3B DF 75 DE 4C 8B C6 49 8B D6 48 8B CF E8 ?? ?? ?? ?? FF 45 00 48 8B DF 48 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_58_5_0 {
	meta:
		name = "_mbsstr_l"
		size = 249
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0030 strstr 0042 _errno 004d _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B FA 48 8B D9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 4C 24 30 41 83 79 08 00 75 13 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B D8 E9 9C 00 00 00 48 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 80 00 00 00 80 3F 00 74 7D 48 85 DB 74 E1 48 83 C8 FF 48 8B C8 48 FF C1 80 3C 0F 00 75 F7 4C 8B C3 4C 2B C1 48 FF C0 80 3C 03 00 75 F7 4C 03 C0 80 3B 00 74 4F 48 8B D3 48 2B D7 49 3B D8 77 44 80 3B 00 48 8B C7 74 14 8A 08 84 C9 74 38 38 0C 02 75 09 48 FF C0 80 3C 02 00 75 EC 80 38 00 74 25 0F B6 03 48 FF C2 48 FF C3 42 8A 4C 08 19 80 E1 04 74 0B 80 3B 00 74 0B 48 FF C3 48 FF C2 80 3B 00 75 B7 33 DB 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B C3 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "??$?B$$A6AXXZ@__crt_fast_encoded_nullptr_t@@QEBAP6AXXZXZ"
		size = 28
		refs = "0003 __security_cookie"
		altNames = "??$?B$$A6AHPEA_WK_J@Z@__crt_fast_encoded_nullptr_t@@QEBAP6AHPEA_WK_J@ZXZ ??$?B$$A6AH_K@Z@__crt_fast_encoded_nullptr_t@@QEBAP6AH_K@ZXZ ??$?B$$A6AXH@Z@__crt_fast_encoded_nullptr_t@@QEBAP6AXH@ZXZ ??$?B$$A6AXPEAXK0@Z@__crt_fast_encoded_nullptr_t@@QEBAP6AXPEAXK0@ZXZ ??$?BP6AXXZ@__crt_fast_encoded_nullptr_t@@QEBAPEAP6AXXZXZ ??$?BX@__crt_fast_encoded_nullptr_t@@QEBAPEAXXZ"
	strings:
		$1 = { 48 8B 15 ?? ?? ?? ?? B9 40 00 00 00 8B C2 83 E0 3F 2B C8 33 C0 48 D3 C8 48 33 C2 C3 }
	condition:
		$1
}

rule file_59_36_0 {
	meta:
		name = "_execute_onexit_table"
		size = 58
		refs = "0031 ??$?RV<lambda_7777bce6b2f8c936911f934f8298dc43>@@AEAV<lambda_f03950bc5685219e0bcd2087efbe011e>@@V<lambda_3883c3dff614d5e0c5f61bb1ac94921c>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_7777bce6b2f8c936911f934f8298dc43>@@AEAV<lambda_f03950bc5685219e0bcd2087efbe011e>@@$$QEAV<lambda_3883c3dff614d5e0c5f61bb1ac94921c>@@@Z"
	strings:
		$1 = { 4C 8B DC 49 89 4B 08 48 83 EC 38 49 8D 43 08 49 89 43 E8 4D 8D 4B 18 B8 02 00 00 00 4D 8D 43 E8 49 8D 53 20 89 44 24 50 49 8D 4B 10 89 44 24 58 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_59_37_0 {
	meta:
		name = "_initialize_onexit_table"
		size = 63
		refs = "001b __security_cookie"
	strings:
		$1 = { 45 33 C9 4C 8B C1 48 85 C9 75 04 83 C8 FF C3 48 8B 41 10 48 39 01 75 24 48 8B 15 ?? ?? ?? ?? B9 40 00 00 00 8B C2 83 E0 3F 2B C8 49 D3 C9 4C 33 CA 4D 89 08 4D 89 48 08 4D 89 48 10 33 C0 C3 }
	condition:
		$1
}

rule file_59_38_0 {
	meta:
		name = "_register_onexit_function"
		size = 72
		refs = "003e ??$?RV<lambda_638799b9deba96c50f710eeac98168cd>@@AEAV<lambda_22ebabd17bc4fa466a2aca6d8deb888d>@@V<lambda_a6f7d7db0129f75315ebf26d50c089f1>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_638799b9deba96c50f710eeac98168cd>@@AEAV<lambda_22ebabd17bc4fa466a2aca6d8deb888d>@@$$QEAV<lambda_a6f7d7db0129f75315ebf26d50c089f1>@@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 55 48 8B EC 48 83 EC 40 48 8D 45 10 48 89 45 E8 4C 8D 4D 28 48 8D 45 18 48 89 45 F0 4C 8D 45 E8 B8 02 00 00 00 48 8D 55 E0 48 8D 4D 20 89 45 28 89 45 E0 E8 ?? ?? ?? ?? 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "scalblnl"
		size = 95
		refs = "001c _ldtest 002d _ldscale 004a _fperrraise"
		altNames = "scalbnl"
	strings:
		$1 = { 48 89 5C 24 10 F2 0F 11 44 24 08 57 48 83 EC 20 8B DA 85 D2 74 38 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 79 29 8B D3 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0C 83 F9 01 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "scalbln"
		size = 95
		refs = "001c _dtest 002d _dscale 004a _fperrraise"
	strings:
		$1 = { 48 89 5C 24 10 F2 0F 11 44 24 08 57 48 83 EC 20 8B DA 85 D2 74 38 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 79 29 8B D3 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0C 83 F9 01 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "scalbn"
		size = 95
		refs = "001c _dtest 002d _dscale 004a _fperrraise"
	strings:
		$1 = { 48 89 5C 24 10 F2 0F 11 44 24 08 57 48 83 EC 20 8B DA 85 D2 74 38 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 79 29 8B D3 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0C 83 F9 01 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "lround"
		size = 96
		refs = "0010 _dtest 0027 round 002f __real@c1e0000000000000 003f __real@41dfffffffc00000 0055 _fperrraise"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 98 85 C0 74 40 FF C8 83 F8 01 76 2F F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? F2 0F 11 44 24 30 72 14 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 72 06 F2 0F 2C C0 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "lroundl"
		size = 96
		refs = "0010 _ldtest 0027 roundl 002f __real@c1e0000000000000 003f __real@41dfffffffc00000 0055 _fperrraise"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 98 85 C0 74 40 FF C8 83 F8 01 76 2F F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? F2 0F 11 44 24 30 72 14 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 72 06 F2 0F 2C C0 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "_dscale"
		size = 649
		refs = "006b _dnorm 008c _Inf_C 009e __xmm@80000000000000008000000000000000"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 48 8B D9 BD FF 07 00 00 0F B7 49 06 8B F2 66 C1 E9 04 66 23 CD 66 3B CD 75 2E F6 43 06 0F 75 19 33 FF 66 39 7B 04 75 11 66 39 7B 02 75 0B 66 39 3B 75 06 44 8D 57 01 EB 06 41 BA 02 00 00 00 41 0F B7 C2 E9 10 02 00 00 33 FF 66 85 C9 75 14 48 8B CB E8 ?? ?? ?? ?? 0F B7 C8 66 3B F8 0F 8C F2 01 00 00 85 F6 7E 31 0F BF C1 2B E8 3B EE 7F 28 F2 0F 10 05 ?? ?? ?? ?? BD 00 80 00 00 66 85 6B 06 74 07 0F 57 05 ?? ?? ?? ?? F2 0F 11 03 B8 01 00 00 00 E9 C0 01 00 00 0F BF D1 8B C2 F7 D8 3B C6 7D 1C 66 03 F1 B8 0F 80 00 00 66 21 43 06 66 C1 E6 04 66 09 73 06 83 C8 FF E9 99 01 00 00 0F B7 4B 06 44 8D 5E FF 44 0F B7 F1 44 03 DA 66 83 E1 0F BD 00 80 00 00 41 BF 10 00 00 00 66 44 23 F5 66 41 0B CF 41 8D 43 35 66 89 4B 06 83 F8 34 0F 87 54 01 00 00 45 8D 57 F1 0F B7 F7 66 41 83 FB F0 7F 59 0F B7 53 02 B8 F0 FF 00 00 66 41 2B C3 44 0F B7 C9 0F B7 4B 04 66 C1 E8 04 66 41 03 C2 44 0F B7 C0 41 0F B7 C0 66 C1 E0 04 66 44 03 D8 66 85 F6 8B C7 0F 95 C0 0F B7 F0 66 0B 33 66 89 13 0F B7 D1 41 0F B7 C9 44 8B CF 4D 2B C2 75 E0 66 89 7B 06 66 89 4B 04 66 89 53 02 66 41 F7 DB 0F 84 85 00 00 00 44 0F B7 03 8B C7 41 0F B7 D0 45 0F BF CB 45 2B F9 41 8B CF 66 D3 E2 41 0F B7 CB 66 85 F6 0F B7 F2 0F B7 53 02 0F 95 C0 66 41 D3 E8 66 0B F0 41 8B CF 0F B7 C2 66 D3 E0 41 0F B7 CB 66 44 0B C0 66 D3 EA 66 44 89 03 41 8B CF 44 0F B7 43 04 41 0F B7 C0 66 D3 E0 41 0F B7 CB 66 0B D0 66 41 D3 E8 66 89 53 02 41 8B CF 0F B7 53 06 0F B7 C2 66 D3 E0 41 8B C9 66 44 0B C0 66 D3 EA 66 89 53 06 66 44 89 43 04 66 44 09 73 06 0F B7 43 06 66 3B EE 72 07 75 26 44 84 13 74 21 66 44 01 13 75 1B 66 44 01 53 02 75 14 66 44 01 53 04 75 0D 66 41 03 C2 66 89 43 06 E9 95 FE FF FF 66 41 3B C6 0F 85 8B FE FF FF 66 39 7B 04 0F 85 81 FE FF FF 66 39 7B 02 0F 85 77 FE FF FF 66 39 3B 74 10 E9 6D FE FF FF 66 44 89 73 06 89 7B 02 66 89 3B 0F B7 C7 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_63_1_0 {
	meta:
		name = "_fdscale"
		size = 470
		refs = "005c _fdnorm 007d _FInf_C 0091 __xmm@80000000800000008000000080000000"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 48 8B D9 BD FF 00 00 00 0F B7 49 02 8B F2 66 C1 E9 07 66 23 CD 66 3B CD 75 1E F6 43 02 7F 75 0E 33 FF 8D 47 01 66 39 3B 0F 84 74 01 00 00 B8 02 00 00 00 E9 6A 01 00 00 33 FF 66 85 C9 75 14 48 8B CB E8 ?? ?? ?? ?? 0F B7 C8 66 3B F8 0F 8C 4C 01 00 00 85 F6 7E 33 0F BF C1 2B E8 3B EE 7F 2A F3 0F 10 05 ?? ?? ?? ?? 41 BB 00 80 00 00 66 44 85 5B 02 74 07 0F 57 05 ?? ?? ?? ?? F3 0F 11 03 B8 01 00 00 00 E9 18 01 00 00 0F BF D1 8B C2 F7 D8 3B C6 7D 23 66 03 F1 B8 7F 80 00 00 66 21 43 02 B8 80 00 00 00 0F B7 CE 0F AF C8 66 09 4B 02 83 C8 FF E9 EA 00 00 00 0F B7 4B 02 44 8D 56 FF 0F B7 E9 44 03 D2 66 83 E1 7F B8 80 00 00 00 66 0B C8 41 BB 00 80 00 00 66 41 23 EB 66 89 4B 02 41 8D 42 18 83 F8 17 0F 87 AB 00 00 00 0F B7 F7 41 BE 10 00 00 00 66 41 83 FA F0 7F 0E 0F B7 33 66 45 03 D6 66 89 0B 66 89 7B 02 66 41 F7 DA 74 4A 44 0F B7 03 8B C7 41 0F B7 D0 45 0F BF CA 45 2B F1 41 8B CE 66 D3 E2 41 0F B7 CA 66 85 F6 0F B7 F2 0F B7 53 02 0F 95 C0 66 41 D3 E8 66 0B F0 41 8B CE 0F B7 C2 66 D3 E0 41 8B C9 66 44 0B C0 66 D3 EA 66 89 53 02 66 44 89 03 66 09 6B 02 B8 01 00 00 00 0F B7 4B 02 66 44 3B DE 72 06 75 15 84 03 74 11 66 01 03 75 0C 66 03 C8 66 89 4B 02 E9 2B FF FF FF 66 3B CD 0F 85 22 FF FF FF 66 39 3B 74 0C E9 18 FF FF FF 66 89 6B 02 66 89 3B 0F B7 C7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_64_13_0 {
	meta:
		name = "?ctrlevent_capture@@YAHK@Z"
		size = 163
		refs = "0012 __acrt_lock 001a __security_cookie 002f ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0044 ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0075 __acrt_unlock 008f __guard_dispatch_icall_fptr"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B D9 B9 03 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 15 ?? ?? ?? ?? 8B C2 83 E0 3F 8B C8 85 DB 48 8B DA 75 15 4C 8D 05 ?? ?? ?? ?? 48 33 1D ?? ?? ?? ?? BF 02 00 00 00 EB 13 4C 8D 05 ?? ?? ?? ?? 48 33 1D ?? ?? ?? ?? BF 15 00 00 00 48 D3 CB 48 83 FB 02 72 12 B9 40 00 00 00 2B C8 33 C0 48 D3 C8 48 33 C2 49 89 00 B9 03 00 00 00 E8 ?? ?? ?? ?? 48 85 DB 75 04 33 C0 EB 16 48 83 FB 01 74 0B 8B CF 48 8B C3 FF 15 ?? ?? ?? ?? B8 01 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_64_14_0 {
	meta:
		name = "?fin$0@?0??ctrlevent_capture@@YAHK@Z@4HA"
		size = 25
		refs = "0014 __acrt_unlock"
		altNames = "signal$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 03 00 00 00 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_64_16_0 {
	meta:
		name = "?get_global_action_nolock@@YAPEAP6AXH@ZH@Z"
		size = 60
		refs = "001f ?abort_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0027 ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 002f ?term_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0037 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A"
	strings:
		$1 = { 83 E9 02 74 2F 83 E9 04 74 12 83 E9 09 74 1D 83 E9 06 74 10 83 F9 01 74 03 33 C0 C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_64_18_0 {
	meta:
		name = "?siglookup@@YAPEAU__crt_signal_action_t@@HQEAU1@@Z"
		size = 37
		refs = "0003 __acrt_signal_action_table_count"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 C1 E0 04 48 03 C2 EB 09 39 4A 04 74 0C 48 83 C2 10 48 3B D0 75 F2 33 C0 C3 48 8B C2 C3 }
	condition:
		$1
}

rule file_64_19_0 {
	meta:
		name = "?signal_failed@@YAP6AXH@ZH@Z"
		size = 39
		refs = "0014 _errno"
	strings:
		$1 = { 48 83 EC 28 83 F9 11 77 0A B8 0A 20 03 00 0F A3 C8 72 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 83 C8 FF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_21_0 {
	meta:
		name = "__acrt_get_sigabrt_handler"
		size = 46
		refs = "0025 ??$?RV<lambda_450d765d439847d4c735a33c368b5fc0>@@AEAV<lambda_44731a7d0e6d81c3e6aa82d741081786>@@V<lambda_601a2a7da3b7a96e9554ac7215c4b07c>@@@?$__crt_seh_guarded_call@P6AXH@Z@@QEAAP6AXH@Z$$QEAV<lambda_450d765d439847d4c735a33c368b5fc0>@@AEAV<lambda_44731a7d0e6d81c3e6aa82d741081786>@@$$QEAV<lambda_601a2a7da3b7a96e9554ac7215c4b07c>@@@Z"
	strings:
		$1 = { 4C 8B DC 48 83 EC 28 B8 03 00 00 00 4D 8D 4B 10 4D 8D 43 08 89 44 24 38 49 8D 53 18 89 44 24 40 49 8D 4B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_22_0 {
	meta:
		name = "__acrt_initialize_signal_handlers"
		size = 29
		refs = "0003 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 000a ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0011 ?abort_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0018 ?term_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A"
	strings:
		$1 = { 48 89 0D ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_64_23_0 {
	meta:
		name = "__fpecode"
		size = 18
		refs = "0005 __acrt_getptd"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C0 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_24_0 {
	meta:
		name = "__pxcptinfoptrs"
		size = 18
		refs = "0005 __acrt_getptd"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C0 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_25_0 {
	meta:
		name = "raise"
		size = 658
		refs = "0055 __acrt_getptd_noexit 006f __acrt_signal_action_table_count 0099 _errno 00a4 _invalid_parameter_noinfo 00db ?abort_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 00e4 ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 00ed ?term_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 00f6 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 010e __acrt_lock 011b __security_cookie 0158 __acrt_unlock 0162 _exit 0193 __acrt_getptd 01b9 __acrt_signal_action_first_fpe_index 01c8 __acrt_signal_action_fpe_count 0240 __guard_dispatch_icall_fptr"
	strings:
		$1 = { 48 8B C4 53 56 57 41 54 41 55 41 57 48 83 EC 48 8B D9 45 33 ED 44 21 68 18 40 B6 01 40 88 B4 24 80 00 00 00 83 F9 02 0F 84 8E 00 00 00 83 F9 04 74 22 83 F9 06 0F 84 80 00 00 00 83 F9 08 74 14 83 F9 0B 74 0F 83 F9 0F 74 71 8D 41 EB 83 F8 01 76 69 EB 44 E8 ?? ?? ?? ?? 4C 8B E8 48 85 C0 75 08 83 C8 FF E9 1B 02 00 00 48 8B 08 48 8B 15 ?? ?? ?? ?? 48 C1 E2 04 48 03 D1 EB 09 39 59 04 74 0B 48 83 C1 10 48 3B CA 75 F2 33 C9 33 C0 48 85 C9 0F 95 C0 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB B7 48 8D 79 08 40 32 F6 40 88 B4 24 80 00 00 00 EB 3F 83 E9 02 74 33 83 E9 04 74 13 83 E9 09 74 20 83 E9 06 74 12 83 F9 01 74 04 33 FF EB 22 48 8D 3D ?? ?? ?? ?? EB 19 48 8D 3D ?? ?? ?? ?? EB 10 48 8D 3D ?? ?? ?? ?? EB 07 48 8D 3D ?? ?? ?? ?? 48 83 A4 24 98 00 00 00 00 40 84 F6 74 0B B9 03 00 00 00 E8 ?? ?? ?? ?? 90 40 84 F6 74 17 48 8B 15 ?? ?? ?? ?? 8B CA 83 E1 3F 48 33 17 48 D3 CA 4C 8B E2 EB 03 4C 8B 27 49 83 FC 01 0F 94 C0 88 84 24 88 00 00 00 84 C0 0F 85 C0 00 00 00 4D 85 E4 75 19 40 84 F6 74 0A 41 8D 4C 24 03 E8 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 41 BF 10 09 00 00 83 FB 0B 77 40 41 0F A3 DF 73 3A 49 8B 45 08 48 89 84 24 98 00 00 00 48 89 44 24 30 49 83 65 08 00 83 FB 08 75 56 E8 ?? ?? ?? ?? 8B 40 10 89 84 24 90 00 00 00 89 44 24 20 E8 ?? ?? ?? ?? C7 40 10 8C 00 00 00 83 FB 08 75 32 48 8B 05 ?? ?? ?? ?? 48 C1 E0 04 49 03 45 00 48 8B 0D ?? ?? ?? ?? 48 C1 E1 04 48 03 C8 48 89 44 24 28 48 3B C1 74 31 48 83 60 08 00 48 83 C0 10 EB EB 48 8B 15 ?? ?? ?? ?? 8B C2 83 E0 3F B9 40 00 00 00 2B C8 33 C0 48 D3 C8 48 33 C2 48 89 07 EB 06 41 BF 10 09 00 00 40 84 F6 74 0A B9 03 00 00 00 E8 ?? ?? ?? ?? 80 BC 24 88 00 00 00 00 74 04 33 C0 EB 59 83 FB 08 75 19 E8 ?? ?? ?? ?? 8B 50 10 8B CB 49 8B C4 4C 8B 05 ?? ?? ?? ?? 41 FF D0 EB 0E 8B CB 49 8B C4 48 8B 15 ?? ?? ?? ?? FF D2 83 FB 0B 77 CB 41 0F A3 DF 73 C5 48 8B 84 24 98 00 00 00 49 89 45 08 83 FB 08 75 B4 E8 ?? ?? ?? ?? 8B 8C 24 90 00 00 00 89 48 10 EB A3 48 83 C4 48 41 5F 41 5D 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_64_26_0 {
	meta:
		name = "raise$fin$0"
		size = 36
		refs = "0018 __acrt_unlock"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 80 BD 80 00 00 00 00 74 0B B9 03 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_64_27_0 {
	meta:
		name = "signal"
		size = 489
		refs = "0049 __acrt_lock 005a ?console_ctrl_handler_installed@@3_NA 0069 ?ctrlevent_capture@@YAHK@Z 006f __imp_SetConsoleCtrlHandler 0081 __doserrno 008a __imp_GetLastError 0095 ?get_global_action_nolock@@YAPEAP6AXH@ZH@Z 00a1 __security_cookie 00d7 __acrt_unlock 0115 __acrt_getptd_noexit 0124 __acrt_exception_action_table 0130 __acrt_signal_action_table_size 0135 _malloc_base 014f memcpy 015c __acrt_signal_action_table_count 01c5 _errno"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 4C 89 74 24 18 41 57 48 83 EC 30 4C 8B F2 8B F9 48 8D 42 FD 48 83 F8 01 0F 86 8D 01 00 00 83 F9 16 0F 87 CC 00 00 00 B8 44 80 60 00 0F A3 C8 0F 83 BE 00 00 00 32 DB 45 33 FF 41 8D 4F 03 E8 ?? ?? ?? ?? 90 83 FF 02 74 05 83 FF 15 75 3A 80 3D ?? ?? ?? ?? 00 75 31 BA 01 00 00 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 09 C6 05 ?? ?? ?? ?? 01 EB 12 E8 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? 89 03 B3 01 8B CF E8 ?? ?? ?? ?? 48 85 C0 74 33 4C 8B 05 ?? ?? ?? ?? 41 8B D0 83 E2 3F 4D 8B F8 4C 33 38 8B CA 49 D3 CF 4C 89 7C 24 20 49 83 FE 02 74 10 B9 40 00 00 00 2B CA 49 D3 CE 4D 33 F0 4C 89 30 B9 03 00 00 00 E8 ?? ?? ?? ?? 84 DB 74 16 83 FF 11 0F 87 DC 00 00 00 B8 0A 20 03 00 0F A3 F8 E9 CD 00 00 00 49 8B C7 E9 D6 00 00 00 83 F9 0B 0F 87 AF 00 00 00 B8 10 09 00 00 0F A3 C8 0F 83 A1 00 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 BE 4C 8D 3D ?? ?? ?? ?? 4C 39 38 75 26 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 9E 4C 8B 05 ?? ?? ?? ?? 49 8B D7 48 8B C8 E8 ?? ?? ?? ?? 48 8B 0B 48 8B C1 4C 8B 05 ?? ?? ?? ?? 4D 03 C0 4A 8D 14 C1 48 3B CA 74 0E 39 78 04 74 0B 48 83 C0 10 48 3B C2 75 F2 33 C0 48 85 C0 0F 84 5A FF FF FF 48 8D 50 08 4C 8B 12 49 83 FE 02 74 1E 4E 8D 0C C1 49 3B C1 74 15 39 7A FC 75 10 4C 89 32 48 83 C2 10 48 8D 4A F8 49 3B C9 75 EB 49 8B C2 EB 1E 83 F9 11 77 0A B8 0A 20 03 00 0F A3 C8 72 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 83 C8 FF 48 8B 5C 24 40 48 8B 7C 24 48 4C 8B 74 24 50 48 83 C4 30 41 5F C3 }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "_mbscpy_s_l"
		size = 310
		refs = "002b _errno 0037 _invalid_parameter_noinfo 0056 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0070 strcpy_s"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 49 8B F8 48 8B F2 48 8B D9 48 85 C9 74 0D 48 85 D2 74 08 4D 85 C0 75 26 44 88 01 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 48 8B 74 24 58 8B C3 48 8B 5C 24 50 48 83 C4 40 5F C3 49 8B D1 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 30 48 8B CB 41 83 78 08 00 75 12 4C 8B C7 48 8B D6 E8 ?? ?? ?? ?? 8B D8 E9 9F 00 00 00 8A 07 48 FF C7 88 01 48 FF C1 84 C0 74 06 48 83 EE 01 75 EC 48 85 F6 75 47 40 38 37 75 2C 48 8D 51 FF 48 8B CA 48 3B D3 72 13 0F B6 01 42 F6 44 00 19 04 74 08 48 FF C9 48 3B CB 73 ED 8B C2 2B C1 A8 01 74 05 C6 02 00 EB 45 C6 03 00 E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? EB 3F 48 83 C1 FE 48 8B D1 48 3B CB 72 13 0F B6 02 42 F6 44 00 19 04 74 08 48 FF CA 48 3B D3 73 ED 8B C1 2B C2 A8 01 74 16 48 3B CB 72 11 C6 01 00 E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 EB 02 33 DB 80 7C 24 38 00 0F 84 16 FF FF FF 48 8B 4C 24 20 83 A1 A8 03 00 00 FD E9 05 FF FF FF }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "_ldlog"
		size = 451
		refs = "0018 _ldunscale 0057 _fperrraise 005f _LNan_C 006c __real@3fe6a09e667f3bcd 0090 __real@3ff0000000000000 00b9 __real@3fc2f8d8bf29def7 00c1 __real@3fc3991accfeb3f4 00cd __real@3fc7466fd968cb62 00d9 __real@3fcc71c4da12c9c6 00e5 __real@3fd24924948ae94a 00f1 __real@3fd9999999975ff7 00fd __real@3fe55555555555bc 011b __real@3fe62e42c0000000 0123 __real@3e7f7d1cf79abc9e 013a __real@3e5526e50e32a6ab 0145 __real@3e7427de7fbcc47c 014d __real@3fdbcb7b1526e50e 0155 __real@3fd3441300000000 0164 __real@3fdbcb7b00000000 0179 __real@3ff71547652b82fe 0184 __real@3e54ae0bf85ddf44 018c __real@3ff7154760000000 01b2 _LInf_C 01b9 __xmm@80000000000000008000000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 53 48 83 EC 20 8B DA 48 8D 4C 24 40 48 8D 54 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 7D 01 00 00 B8 00 80 00 00 83 E9 01 74 10 83 F9 01 75 14 F2 0F 10 44 24 30 E9 7C 01 00 00 66 85 44 24 36 75 09 EB EC 66 85 44 24 36 74 17 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? E9 55 01 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 4C 24 30 66 0F 2F C1 0F B7 44 24 40 76 07 F2 0F 58 C9 66 FF C8 98 0F 28 D1 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? 66 0F 6E E0 F3 0F E6 E4 0F 28 DA F2 0F 5E D9 0F 28 C3 F2 0F 59 C3 0F 28 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C2 F2 0F 5C C1 F2 0F 59 D8 85 DB 75 1D 0F 28 C4 F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C D8 F2 0F 5C D3 EB 6A 0F 28 CA 7E 3F F2 0F 59 0D ?? ?? ?? ?? 0F 28 C4 F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C D8 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C CB 0F 28 D1 F2 0F 58 D0 EB 26 F2 0F 59 1D ?? ?? ?? ?? 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C C3 0F 28 D0 F2 0F 58 D1 F2 0F 58 D4 0F 28 C2 EB 19 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_468_0_0 {
	meta:
		name = "_dlog"
		size = 451
		refs = "0018 _dunscale 0057 _fperrraise 005f _Nan_C 006c __real@3fe6a09e667f3bcd 0090 __real@3ff0000000000000 00b9 __real@3fc2f8d8bf29def7 00c1 __real@3fc3991accfeb3f4 00cd __real@3fc7466fd968cb62 00d9 __real@3fcc71c4da12c9c6 00e5 __real@3fd24924948ae94a 00f1 __real@3fd9999999975ff7 00fd __real@3fe55555555555bc 011b __real@3fe62e42c0000000 0123 __real@3e7f7d1cf79abc9e 013a __real@3e5526e50e32a6ab 0145 __real@3e7427de7fbcc47c 014d __real@3fdbcb7b1526e50e 0155 __real@3fd3441300000000 0164 __real@3fdbcb7b00000000 0179 __real@3ff71547652b82fe 0184 __real@3e54ae0bf85ddf44 018c __real@3ff7154760000000 01b2 _Inf_C 01b9 __xmm@80000000000000008000000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 53 48 83 EC 20 8B DA 48 8D 4C 24 40 48 8D 54 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 7D 01 00 00 B8 00 80 00 00 83 E9 01 74 10 83 F9 01 75 14 F2 0F 10 44 24 30 E9 7C 01 00 00 66 85 44 24 36 75 09 EB EC 66 85 44 24 36 74 17 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? E9 55 01 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 4C 24 30 66 0F 2F C1 0F B7 44 24 40 76 07 F2 0F 58 C9 66 FF C8 98 0F 28 D1 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? 66 0F 6E E0 F3 0F E6 E4 0F 28 DA F2 0F 5E D9 0F 28 C3 F2 0F 59 C3 0F 28 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C2 F2 0F 5C C1 F2 0F 59 D8 85 DB 75 1D 0F 28 C4 F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C D8 F2 0F 5C D3 EB 6A 0F 28 CA 7E 3F F2 0F 59 0D ?? ?? ?? ?? 0F 28 C4 F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C D8 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C CB 0F 28 D1 F2 0F 58 D0 EB 26 F2 0F 59 1D ?? ?? ?? ?? 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C C3 0F 28 D0 F2 0F 58 D1 F2 0F 58 D4 0F 28 C2 EB 19 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "_ldlogpoly"
		size = 83
		refs = "0007 __real@3fc2f8d8bf29def7 000f __real@3fc3991accfeb3f4 001b __real@3fc7466fd968cb62 0027 __real@3fcc71c4da12c9c6 0033 __real@3fd24924948ae94a 003f __real@3fd9999999975ff7 004b __real@3fe55555555555bc"
		altNames = "_dlogpoly"
	strings:
		$1 = { 0F 28 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? 0F 28 C1 C3 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "cprojf"
		size = 135
		refs = "000c crealf 001c cimagf 002c _fdtest 0061 _FZero_C 0068 __xmm@80000000800000008000000080000000 0075 _FInf_C"
	strings:
		$1 = { 40 53 48 83 EC 30 48 89 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 F3 0F 11 44 24 50 E8 ?? ?? ?? ?? 48 8D 4C 24 50 F3 0F 11 44 24 48 E8 ?? ?? ?? ?? 48 8D 4C 24 48 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 01 74 0E 66 83 F8 01 74 08 F2 0F 10 44 24 20 EB 2B B8 00 80 00 00 66 85 44 24 4A 74 11 F3 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? EB 03 0F 57 C9 F3 0F 10 05 ?? ?? ?? ?? 0F 14 C1 66 48 0F 7E C0 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_68_5_0 {
	meta:
		name = "_mbsnbicmp_l"
		size = 445
		refs = "0025 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0049 _strnicmp 005d _errno 0068 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 40 48 8B FA 48 8B F1 49 8B D1 48 8D 48 D8 49 8B D8 E8 ?? ?? ?? ?? 33 ED 48 85 DB 0F 84 56 01 00 00 4C 8B 44 24 30 41 39 68 08 75 13 4C 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? E9 43 01 00 00 48 85 F6 74 05 48 85 FF 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 1F 01 00 00 41 B1 04 0F B6 0E 48 FF CB 48 FF C6 46 84 4C 01 19 74 5E 48 85 DB 75 18 0F B6 07 8B CD 46 84 4C 00 19 0F 85 EC 00 00 00 0F B7 D0 E9 D1 00 00 00 40 38 2E 75 05 0F B7 CD EB 52 0F B6 06 48 FF C6 66 C1 E1 08 66 0B C8 66 41 3B 48 0C 72 0E 66 41 3B 48 0E 77 07 66 41 03 48 10 EB 30 66 41 3B 48 12 72 29 66 41 3B 48 14 77 22 66 41 03 48 16 EB 1B 0F B7 C1 FF C0 48 98 42 F6 44 00 18 10 74 0C 0F B7 C1 42 0F B6 8C 00 19 01 00 00 0F B6 17 48 FF C7 46 84 4C 02 19 74 4D 48 85 DB 75 04 8B D5 EB 5F 48 FF CB 40 38 2F 75 05 0F B7 D5 EB 52 0F B6 07 48 FF C7 66 C1 E2 08 66 0B D0 66 41 3B 50 0C 72 0E 66 41 3B 50 0E 77 07 66 41 03 50 10 EB 30 66 41 3B 50 12 72 29 66 41 3B 50 14 77 22 66 41 03 50 16 EB 1B 0F B7 C2 FF C0 48 98 42 F6 44 00 18 10 74 0C 0F B7 C2 42 0F B6 94 00 19 01 00 00 66 3B D1 75 12 66 85 C9 74 09 48 85 DB 0F 85 EF FE FF FF 8B C5 EB 07 1B C0 83 E0 02 FF C8 40 38 6C 24 38 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "_mbccpy"
		size = 30
		refs = "0015 _mbccpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 45 33 C0 4C 8B CA 41 8D 50 02 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "_mbccpy_l"
		size = 29
		refs = "0014 _mbccpy_s_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B CA 45 33 C0 41 8D 50 02 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "memmove_s"
		size = 81
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0045 memmove"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 4D 85 C9 74 3B 48 85 C9 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 23 48 85 C0 74 E6 49 3B D1 73 0C E8 ?? ?? ?? ?? BB 22 00 00 00 EB DF 4D 8B C1 48 8B D0 E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "clogl"
		size = 592
		refs = "002f creall 0045 cimagl 0053 _ldtest 00b9 atan2 00e1 __xmm@80000000000000008000000000000000 0123 _fperrraise 012b _LInf_C 0147 __real@3feccccccccccccd 0159 __real@3fd999999999999a 0179 _ld_int 01c8 __real@3ff0000000000000 01dc log1pl 01e4 __real@3fe0000000000000 01f8 log 0229 _LCbuild"
	strings:
		$1 = { 40 55 53 56 57 48 8B EC 48 83 EC 68 0F 10 02 48 8B F9 48 8D 4D B8 0F 29 74 24 50 48 8B DA 0F 29 7C 24 40 F3 0F 7F 45 B8 44 0F 29 4C 24 30 E8 ?? ?? ?? ?? F2 0F 11 45 30 48 8D 4D B8 0F 10 03 F3 0F 7F 45 B8 E8 ?? ?? ?? ?? 48 8D 4D 30 F2 0F 11 45 28 E8 ?? ?? ?? ?? 48 8D 4D 28 0F B7 F0 E8 ?? ?? ?? ?? 0F B7 D8 66 83 FE 02 75 1B F2 0F 10 55 30 48 8D 4D B8 66 83 F8 01 0F 84 A1 01 00 00 0F 28 CA E9 A1 01 00 00 66 83 FB 02 75 1B F2 0F 10 55 28 48 8D 4D B8 66 83 FE 01 0F 84 80 01 00 00 0F 28 CA E9 80 01 00 00 F2 0F 10 75 30 F2 0F 10 7D 28 0F 28 CE 0F 28 C7 E8 ?? ?? ?? ?? 44 0F 28 C8 66 83 FE 01 0F 84 4E 01 00 00 66 83 FB 01 0F 84 44 01 00 00 0F 57 C9 66 0F 2F CE 76 0C 0F 57 35 ?? ?? ?? ?? F2 0F 11 75 30 66 0F 2F CF 76 0C 0F 57 3D ?? ?? ?? ?? F2 0F 11 7D 28 66 0F 2F FE 76 13 0F 28 C6 F2 0F 11 7D 30 0F 28 F7 F2 0F 11 45 28 0F 28 F8 66 0F 2E F1 7A 28 75 26 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? 41 0F 28 D1 48 8D 4D B8 E9 E5 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C6 0F 82 9B 00 00 00 66 0F 2F 3D ?? ?? ?? ?? 0F 82 8D 00 00 00 BB 1A 00 00 00 F2 0F 11 75 40 8B D3 F2 0F 11 7D 38 48 8D 4D 40 E8 ?? ?? ?? ?? 8B D3 48 8D 4D 38 E8 ?? ?? ?? ?? F2 0F 10 5D 38 F2 0F 10 55 40 0F 28 C3 F2 0F 58 45 28 F2 0F 10 65 28 F2 0F 10 4D 30 F2 0F 5C E3 F2 0F 5C CA F2 0F 59 DB F2 0F 59 E0 0F 28 C2 F2 0F 58 45 30 F2 0F 59 D2 F2 0F 59 C8 F2 0F 5C 15 ?? ?? ?? ?? F2 0F 58 E1 F2 0F 58 D3 F2 0F 58 E2 0F 28 C4 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 0F 28 C8 E9 46 FF FF FF 0F 28 C6 F2 0F 5E FE E8 ?? ?? ?? ?? 0F 28 F0 F2 0F 59 FF 0F 28 C7 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 C6 EB CF 0F 28 D0 48 8D 4D B8 F2 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 74 24 50 0F 28 7C 24 40 44 0F 28 4C 24 30 0F 10 00 48 8B C7 F3 0F 7F 07 48 83 C4 68 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_72_2_0 {
	meta:
		name = "??$common_tmpnam@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@QEAPEAD@Z"
		size = 162
		refs = "002b __acrt_lock 0031 _errno 0042 ??$common_tmpnam_nolock@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@@Z 0060 __acrt_getptd_noexit 0081 __acrt_unlock"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 20 4D 8B F1 41 8B F8 48 8B F2 48 8B D9 B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 44 8B 38 44 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 8B F0 33 FF 85 C0 74 0C 49 89 1E E8 ?? ?? ?? ?? 89 30 EB 21 48 85 DB 75 11 E8 ?? ?? ?? ?? 48 85 C0 74 04 48 8D 78 48 48 8B 1F 49 89 1E E8 ?? ?? ?? ?? 44 89 38 B9 0C 00 00 00 E8 ?? ?? ?? ?? 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 4C 8B 74 24 48 48 83 C4 20 41 5F C3 }
	condition:
		$1
}

rule file_72_3_0 {
	meta:
		name = "?fin$0@?0???$common_tmpnam@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@QEAPEAD@Z@4HA"
		size = 25
		refs = "0014 __acrt_unlock"
		altNames = "?fin$0@?0???$common_tmpnam@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@QEAPEA_W@Z@4HA ?fin$0@?0??common_tmpfile@@YAHQEAPEAU_iobuf@@H@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 0C 00 00 00 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_72_4_0 {
	meta:
		name = "??$common_tmpnam@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@QEAPEA_W@Z"
		size = 162
		refs = "002b __acrt_lock 0031 _errno 0042 ??$common_tmpnam_nolock@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@@Z 0060 __acrt_getptd_noexit 0081 __acrt_unlock"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 20 4D 8B F1 41 8B F8 48 8B F2 48 8B D9 B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 44 8B 38 44 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 8B F0 33 FF 85 C0 74 0C 49 89 1E E8 ?? ?? ?? ?? 89 30 EB 21 48 85 DB 75 11 E8 ?? ?? ?? ?? 48 85 C0 74 04 48 8D 78 50 48 8B 1F 49 89 1E E8 ?? ?? ?? ?? 44 89 38 B9 0C 00 00 00 E8 ?? ?? ?? ?? 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 4C 8B 74 24 48 48 83 C4 20 41 5F C3 }
	condition:
		$1
}

rule file_72_6_0 {
	meta:
		name = "??$common_tmpnam_nolock@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@@Z"
		size = 331
		refs = "0026 ??$get_tmpfile_buffer_nolock@D@@YAPEADW4buffer_id@?A0x5b9a7937@@@Z 0044 ??$initialize_tmpfile_buffer_nolock@D@@YA_NW4buffer_id@?A0x5b9a7937@@@Z 0060 ??$generate_tmpfile_file_name@D@@YA_NQEAD_K@Z 006e _access_s 00aa strcpy_s 00b7 __acrt_getptd_noexit 00d8 _calloc_base 00e2 _free_base 0130 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 57 48 83 EC 30 48 8B F1 41 8B F8 41 8B C8 48 8B EA E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 C9 00 00 00 80 38 00 41 BF 04 01 00 00 75 09 8B CF E8 ?? ?? ?? ?? EB 1E 48 8B C8 EB 0D B8 02 00 00 00 E9 AB 00 00 00 48 8B CB 49 8B D7 E8 ?? ?? ?? ?? 84 C0 74 E7 33 D2 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 E3 48 85 F6 74 3B 85 FF 74 21 48 83 C8 FF 48 FF C0 80 3C 03 00 75 F7 48 3B C5 72 0F 48 85 ED 74 03 C6 06 00 B8 22 00 00 00 EB 64 4C 8B C3 48 8B D5 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 6D 33 C0 EB 4E E8 ?? ?? ?? ?? 48 85 C0 74 3F 48 8D 78 48 48 85 FF 74 36 48 8B 0F 48 85 C9 75 1D 8D 51 01 49 8B CF E8 ?? ?? ?? ?? 33 C9 48 89 07 E8 ?? ?? ?? ?? 48 8B 0F 48 85 C9 74 11 4C 8B C3 49 8B D7 E8 ?? ?? ?? ?? 85 C0 74 B5 EB 36 B8 0C 00 00 00 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5F C3 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_72_7_0 {
	meta:
		name = "??$common_tmpnam_nolock@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@@Z"
		size = 367
		refs = "0022 ?wide_tmpfile_buffer_pointers@@3PAPEA_WA 0048 _calloc_base 0053 _free_base 006d ??$initialize_tmpfile_buffer_nolock@_W@@YA_NW4buffer_id@?A0x5b9a7937@@@Z 0082 ??$generate_tmpfile_file_name@_W@@YA_NQEA_W_K@Z 0090 _waccess_s 00ce wcscpy_s 00db __acrt_getptd_noexit 0155 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 30 49 63 E8 4C 8D 25 ?? ?? ?? ?? 45 33 F6 48 8B FA 48 8B F1 41 BF 02 00 00 00 41 BD 04 01 00 00 4D 39 34 EC 75 16 41 8B D7 41 8B CD E8 ?? ?? ?? ?? 33 C9 49 89 04 EC E8 ?? ?? ?? ?? 49 8B 1C EC 48 85 DB 0F 84 BF 00 00 00 66 44 39 33 75 11 8B CD E8 ?? ?? ?? ?? EB 17 41 8B C7 E9 AD 00 00 00 49 8B D5 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 E9 33 D2 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 E3 48 85 F6 74 3D 85 ED 74 23 48 83 C8 FF 48 FF C0 66 44 39 34 43 75 F6 48 3B C7 72 10 48 85 FF 74 04 66 44 89 36 B8 22 00 00 00 EB 64 4C 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 6F 33 C0 EB 4E E8 ?? ?? ?? ?? 48 85 C0 74 3F 48 8D 78 50 48 85 FF 74 36 48 8B 0F 48 85 C9 75 1D 49 8B D7 49 8B CD E8 ?? ?? ?? ?? 33 C9 48 89 07 E8 ?? ?? ?? ?? 48 8B 0F 48 85 C9 74 11 4C 8B C3 49 8B D5 E8 ?? ?? ?? ?? 85 C0 74 B5 EB 37 B8 0C 00 00 00 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 45 33 C9 4C 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_72_8_0 {
	meta:
		name = "??$generate_tmpfile_file_name@D@@YA_NQEAD_K@Z"
		size = 153
		refs = "001b strrchr 0028 _invalid_parameter_noinfo 0059 strtoull 0077 _ui64toa_s 0094 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 48 8B FA 48 8B D9 BA 2E 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 75 17 E8 ?? ?? ?? ?? 32 C0 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 48 3B C3 72 E4 48 2B C3 48 3B F8 76 DC 33 D2 48 8D 71 01 48 8B CE 44 8D 42 24 E8 ?? ?? ?? ?? 48 83 C0 01 74 C9 48 2B DE 41 B9 24 00 00 00 48 8B D6 48 8B C8 4C 8D 04 1F E8 ?? ?? ?? ?? 85 C0 75 04 B0 01 EB AB 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_72_9_0 {
	meta:
		name = "??$generate_tmpfile_file_name@_W@@YA_NQEA_W_K@Z"
		size = 164
		refs = "001b wcsrchr 0028 _invalid_parameter_noinfo 005c wcstoull 0082 _ui64tow_s 009f _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 48 8B FA 48 8B D9 BA 2E 00 00 00 E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 75 17 E8 ?? ?? ?? ?? 32 C0 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 48 3B C3 72 E4 48 2B C3 48 D1 F8 48 3B F8 76 D9 49 8D 70 02 33 D2 48 8B CE 44 8D 42 24 E8 ?? ?? ?? ?? 48 83 C0 01 74 C6 4C 8B C6 41 B9 24 00 00 00 4C 2B C3 48 8B D6 49 D1 F8 48 8B C8 49 2B F8 4C 8B C7 E8 ?? ?? ?? ?? 85 C0 75 04 B0 01 EB A0 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_72_12_0 {
	meta:
		name = "??$get_tmpfile_buffer_nolock@D@@YAPEADW4buffer_id@?A0x5b9a7937@@@Z"
		size = 68
		refs = "0010 ?narrow_tmpfile_buffer_pointers@@3PAPEADA 0026 _calloc_base 0031 _free_base"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 63 D9 48 8D 3D ?? ?? ?? ?? 48 83 3C DF 00 75 1A BA 01 00 00 00 B9 04 01 00 00 E8 ?? ?? ?? ?? 33 C9 48 89 04 DF E8 ?? ?? ?? ?? 48 8B 04 DF 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_72_13_0 {
	meta:
		name = "??$get_tmpfile_buffer_nolock@_W@@YAPEA_WW4buffer_id@?A0x5b9a7937@@@Z"
		size = 68
		refs = "0010 ?wide_tmpfile_buffer_pointers@@3PAPEA_WA 0026 _calloc_base 0031 _free_base"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 63 D9 48 8D 3D ?? ?? ?? ?? 48 83 3C DF 00 75 1A BA 02 00 00 00 B9 04 01 00 00 E8 ?? ?? ?? ?? 33 C9 48 89 04 DF E8 ?? ?? ?? ?? 48 8B 04 DF 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_72_14_0 {
	meta:
		name = "??$initialize_tmpfile_buffer_nolock@D@@YA_NW4buffer_id@?A0x5b9a7937@@@Z"
		size = 196
		refs = "0012 ??$get_tmpfile_buffer_nolock@D@@YAPEADW4buffer_id@?A0x5b9a7937@@@Z 0027 __acrt_GetTempPathA 005e __imp_GetCurrentProcessId 0075 _ui64toa_s 00bf _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 8B F9 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 7E 48 8B D0 B9 04 01 00 00 E8 ?? ?? ?? ?? 8D 48 FF 81 F9 ED 00 00 00 77 63 8B D8 48 03 DE 85 FF 74 14 83 EF 01 74 0A 83 FF 01 75 10 C6 03 75 EB 08 C6 03 74 EB 03 C6 03 73 48 FF C3 48 2B F3 FF 15 ?? ?? ?? ?? 8B C8 41 B9 24 00 00 00 4C 8D 86 04 01 00 00 48 8B D3 E8 ?? ?? ?? ?? 85 C0 75 31 48 83 C9 FF 48 FF C1 80 3C 0B 00 75 F7 66 C7 04 0B 2E 30 B0 01 C6 44 0B 02 00 EB 05 C6 06 00 32 C0 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_72_15_0 {
	meta:
		name = "??$initialize_tmpfile_buffer_nolock@_W@@YA_NW4buffer_id@?A0x5b9a7937@@@Z"
		size = 281
		refs = "001f ?wide_tmpfile_buffer_pointers@@3PAPEA_WA 0038 _calloc_base 0043 _free_base 005b __imp_GetTempPathW 00a4 __imp_GetCurrentProcessId 00b7 _ui64tow_s 0114 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 30 48 63 F9 48 8D 1D ?? ?? ?? ?? 45 33 F6 BD 04 01 00 00 4C 39 34 FB 75 16 41 8D 56 02 8B CD E8 ?? ?? ?? ?? 33 C9 48 89 04 FB E8 ?? ?? ?? ?? 48 8B 34 FB 48 85 F6 0F 84 93 00 00 00 48 8B D6 8B CD FF 15 ?? ?? ?? ?? 8D 48 FF 81 F9 ED 00 00 00 77 79 8B C0 48 8D 1C 46 85 FF 74 16 83 EF 01 74 0A 83 FF 01 75 18 8D 47 77 EB 0C B8 77 00 00 00 EB 05 B8 76 00 00 00 66 89 03 48 83 C3 02 48 8B C3 48 2B C6 48 D1 F8 48 2B E8 FF 15 ?? ?? ?? ?? 8B C8 41 B9 24 00 00 00 4C 8B C5 48 8B D3 E8 ?? ?? ?? ?? 85 C0 75 45 48 83 C8 FF 48 FF C0 66 44 39 34 43 75 F6 48 8D 04 43 C7 00 2E 00 30 00 48 83 C0 04 66 44 89 30 B0 01 EB 06 66 44 89 36 32 C0 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5E C3 45 33 C9 4C 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_72_22_0 {
	meta:
		name = "??$tcslen@AEAPEAD@?$__crt_char_traits@D@@SA_KAEAPEAD@Z"
		size = 17
		altNames = "??$tcslen@AEAPEBD@?$__crt_char_traits@D@@SA_KAEAPEBD@Z ??$tcslen@AEBQEAD@?$__crt_char_traits@D@@SA_KAEBQEAD@Z ??$tcslen@AEBQEBD@?$__crt_char_traits@D@@SA_KAEBQEBD@Z ??$tcslen@PEAD@?$__crt_char_traits@D@@SA_K$$QEAPEAD@Z"
	strings:
		$1 = { 48 8B 11 48 83 C8 FF 48 FF C0 80 3C 02 00 75 F7 C3 }
	condition:
		$1
}

rule file_72_23_0 {
	meta:
		name = "??$tcslen@AEAPEA_W@?$__crt_char_traits@_W@@SA_KAEAPEA_W@Z"
		size = 18
		altNames = "??$tcslen@AEAPEB_W@?$__crt_char_traits@_W@@SA_KAEAPEB_W@Z ??$tcslen@AEBQEA_W@?$__crt_char_traits@_W@@SA_KAEBQEA_W@Z ??$tcslen@AEBQEB_W@?$__crt_char_traits@_W@@SA_KAEBQEB_W@Z ??$tcslen@PEA_W@?$__crt_char_traits@_W@@SA_K$$QEAPEA_W@Z"
	strings:
		$1 = { 48 8B 11 48 83 C8 FF 48 FF C0 66 83 3C 42 00 75 F6 C3 }
	condition:
		$1
}

rule file_72_32_0 {
	meta:
		name = "??$ulltot_s@KAEAPEAD_KH@?$__crt_char_traits@D@@SAH$$QEAKAEAPEAD$$QEA_K$$QEAH@Z"
		size = 16
		refs = "000c _ui64toa_s"
	strings:
		$1 = { 8B 09 45 8B 09 4D 8B 00 48 8B 12 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_33_0 {
	meta:
		name = "??$ulltot_s@KAEAPEA_W_KH@?$__crt_char_traits@_W@@SAH$$QEAKAEAPEA_W$$QEA_K$$QEAH@Z"
		size = 16
		refs = "000c _ui64tow_s"
	strings:
		$1 = { 8B 09 45 8B 09 4D 8B 00 48 8B 12 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_43_0 {
	meta:
		name = "?common_tmpfile@@YAHQEAPEAU_iobuf@@H@Z"
		size = 109
		refs = "001c _errno 0028 _invalid_parameter_noinfo 003a __acrt_lock 0045 ?common_tmpfile_nolock@@YAHQEAPEAU_iobuf@@H@Z 005c __acrt_unlock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B FA 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 32 48 83 21 00 B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 8B D7 48 8B CB E8 ?? ?? ?? ?? 8B D8 85 C0 74 07 E8 ?? ?? ?? ?? 89 18 B9 0C 00 00 00 E8 ?? ?? ?? ?? EB CA 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_72_45_0 {
	meta:
		name = "?common_tmpfile_nolock@@YAHQEAPEAU_iobuf@@H@Z"
		size = 387
		refs = "0021 ??$get_tmpfile_buffer_nolock@D@@YAPEADW4buffer_id@?A0x5b9a7937@@@Z 003d ??$initialize_tmpfile_buffer_nolock@D@@YA_NW4buffer_id@?A0x5b9a7937@@@Z 0058 ??$generate_tmpfile_file_name@D@@YA_NQEAD_K@Z 0064 ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 007b _errno 00a8 _sopen_s 00f0 _strdup 0109 _close 012d _commode 015f ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 0169 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 41 56 41 57 48 83 EC 40 44 8B F2 4C 8B F9 BB 01 00 00 00 8B CB E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 08 8D 43 0B E9 3A 01 00 00 80 38 00 75 15 8B CB E8 ?? ?? ?? ?? 84 C0 75 19 B8 16 00 00 00 E9 20 01 00 00 BA 04 01 00 00 48 8B C8 E8 ?? ?? ?? ?? EB E3 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 7C 24 30 00 75 0A B8 18 00 00 00 E9 F5 00 00 00 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 83 20 00 83 64 24 70 00 C7 44 24 20 80 01 00 00 45 8B CE 41 B8 42 85 00 00 48 8B D7 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B D8 89 44 24 78 83 F8 11 75 13 BA 04 01 00 00 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 02 EB C4 E8 ?? ?? ?? ?? 83 38 00 75 07 E8 ?? ?? ?? ?? 89 30 83 7C 24 70 FF 74 71 48 8B 5C 24 30 48 89 5C 24 38 48 8B CF E8 ?? ?? ?? ?? 48 89 43 28 48 8B 44 24 30 48 83 78 28 00 75 10 8B 4C 24 70 E8 ?? ?? ?? ?? BB 0C 00 00 00 EB 3F 83 60 10 00 48 8B 44 24 30 48 83 60 08 00 48 8B 44 24 30 48 83 20 00 8B 0D ?? ?? ?? ?? 83 C9 04 48 8B 44 24 30 F0 09 48 14 8B 4C 24 70 48 8B 44 24 30 89 48 18 48 8B 44 24 30 49 89 07 33 DB 48 8B 4C 24 30 83 79 18 FF 75 05 E8 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 40 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_72_46_0 {
	meta:
		name = "?fin$0@?0??common_tmpfile_nolock@@YAHQEAPEAU_iobuf@@H@Z@4HA"
		size = 41
		refs = "0014 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 001d _unlock_file"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 30 83 79 18 FF 75 09 E8 ?? ?? ?? ?? 48 8B 4D 30 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_72_51_0 {
	meta:
		name = "?get_tmpnam_ptd_buffer@@YAPEAPEADD@Z"
		size = 23
		refs = "0005 __acrt_getptd_noexit"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 74 04 48 83 C0 48 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_72_52_0 {
	meta:
		name = "?get_tmpnam_ptd_buffer@@YAPEAPEA_W_W@Z"
		size = 23
		refs = "0005 __acrt_getptd_noexit"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 74 04 48 83 C0 50 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_72_62_0 {
	meta:
		name = "__acrt_stdio_free_tmpfile_name_buffers_nolock"
		size = 96
		refs = "0017 ?narrow_tmpfile_buffer_pointers@@3PAPEADA 0021 _free_base 0036 ?wide_tmpfile_buffer_pointers@@3PAPEA_WA"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 BF 03 00 00 00 48 8D 1D ?? ?? ?? ?? 8B F7 48 8B 0B E8 ?? ?? ?? ?? 48 83 23 00 48 8D 5B 08 48 83 EE 01 75 EA 48 8D 1D ?? ?? ?? ?? 48 8B 0B E8 ?? ?? ?? ?? 48 83 23 00 48 8D 5B 08 48 83 EF 01 75 EA 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_72_64_0 {
	meta:
		name = "_wtmpnam"
		size = 38
		refs = "0018 ??$common_tmpnam@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@QEAPEA_W@Z"
	strings:
		$1 = { 48 83 EC 28 48 83 64 24 38 00 4C 8D 4C 24 38 45 33 C0 BA 04 01 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_72_68_0 {
	meta:
		name = "tmpnam"
		size = 38
		refs = "0018 ??$common_tmpnam@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@QEAPEAD@Z"
	strings:
		$1 = { 48 83 EC 28 48 83 64 24 38 00 4C 8D 4C 24 38 45 33 C0 BA 04 01 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_72_65_0 {
	meta:
		name = "_wtmpnam_s"
		size = 53
		refs = "000a _errno 0015 _invalid_parameter_noinfo 002c ??$common_tmpnam@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@QEAPEA_W@Z"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 10 4C 8D 4C 24 30 41 B8 02 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_72_69_0 {
	meta:
		name = "tmpnam_s"
		size = 53
		refs = "000a _errno 0015 _invalid_parameter_noinfo 002c ??$common_tmpnam@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@QEAPEAD@Z"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 10 4C 8D 4C 24 30 41 B8 02 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_72_66_0 {
	meta:
		name = "tmpfile"
		size = 35
		refs = "0015 ?common_tmpfile@@YAHQEAPEAU_iobuf@@H@Z"
	strings:
		$1 = { 48 83 EC 28 48 83 64 24 30 00 48 8D 4C 24 30 BA 40 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_73_5_0 {
	meta:
		name = "_ismbchira_l"
		size = 77
		refs = "000e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 30 81 78 04 A4 03 00 00 75 12 8D 83 61 7D FF FF 83 F8 52 77 07 B8 01 00 00 00 EB 02 33 C0 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_73_7_0 {
	meta:
		name = "_ismbckata_l"
		size = 85
		refs = "000e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 30 81 78 04 A4 03 00 00 75 1A 8D 83 C0 7C FF FF 83 F8 56 77 0F 81 FB 7F 83 00 00 74 07 B8 01 00 00 00 EB 02 33 C0 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_73_9_0 {
	meta:
		name = "_ismbcsymbol_l"
		size = 85
		refs = "000e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 30 81 78 04 A4 03 00 00 75 1A 8D 83 BF 7E FF FF 83 F8 6B 77 0F 81 FB 7F 81 00 00 74 07 B8 01 00 00 00 EB 02 33 C0 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "raise_fpsw_flags"
		size = 49
		refs = "002d _set_statfp"
	strings:
		$1 = { 33 C0 F6 C1 01 8D 50 08 0F 45 C2 F6 C1 02 74 03 83 C8 10 F6 C1 04 74 03 83 C8 04 84 CA 74 03 83 C8 01 F6 C1 10 74 03 83 C8 20 8B C8 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_74_1_0 {
	meta:
		name = "scaleDouble_2"
		size = 72
	strings:
		$1 = { 8B C2 44 8B C2 99 0F 28 D0 2B C2 BA FF 03 00 00 D1 F8 48 63 C8 44 2B C0 48 03 CA 49 63 C0 48 C1 E1 34 48 03 C2 48 89 4C 24 08 F2 0F 10 44 24 08 F2 0F 59 C2 48 C1 E0 34 48 89 44 24 08 F2 0F 10 4C 24 08 F2 0F 59 C1 C3 }
	condition:
		$1
}

rule file_74_2_0 {
	meta:
		name = "splitexp"
		size = 295
		refs = "0008 __real@3fe0000000000000 0030 __real@0000000000000000 0048 __ImageBase 0063 ?two_to_jby32_lead_table@?1??splitexp@@9@9 006c ?two_to_jby32_trail_table@?1??splitexp@@9@9 00ce __real@3f56c1728d739765 00d6 __real@3f811115b7aa905e 00e2 __real@3fa5555555545d4e 00ee __real@3fc5555555548f7c"
	strings:
		$1 = { 48 83 EC 38 F2 0F 10 2D ?? ?? ?? ?? 0F 28 E0 0F 29 74 24 20 0F 28 F0 0F 29 7C 24 10 0F 28 F9 F2 0F 59 E2 44 0F 29 04 24 44 0F 28 C3 66 0F 2F 25 ?? ?? ?? ?? 76 06 F2 0F 58 E5 EB 04 F2 0F 5C E5 F2 44 0F 2C C4 48 8D 15 ?? ?? ?? ?? 41 8B C8 83 E1 1F 48 63 C1 66 41 0F 6E C0 F3 0F E6 C0 F2 0F 10 9C C2 ?? ?? ?? ?? F2 0F 10 A4 C2 ?? ?? ?? ?? 41 8B C0 2B C1 F2 41 0F 59 C0 48 8B 4C 24 68 99 44 0F 28 04 24 83 E2 1F 03 C2 C1 F8 05 F2 0F 5C F0 89 01 48 8B 44 24 70 41 F7 D8 F2 0F 59 F1 66 41 0F 6E C8 F3 0F E6 C9 F2 0F 11 18 F2 0F 59 4C 24 60 48 8B 44 24 78 F2 0F 59 CF 0F 28 7C 24 10 0F 28 C1 F2 0F 58 C6 0F 28 D0 F2 0F 59 15 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 59 C0 F2 0F 58 D5 F2 0F 59 D0 0F 28 C4 F2 0F 58 C3 F2 0F 58 D1 F2 0F 58 D6 0F 28 74 24 20 F2 0F 59 D0 F2 0F 58 D4 F2 0F 11 10 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_74_3_0 {
	meta:
		name = "tanh"
		size = 654
		refs = "0057 _set_statfp 0074 _handle_nan 0090 __xmm@80000000000000008000000000000000 0099 __real@4034000000000000 00a1 __real@3ff0000000000000 00ba __real@3feccccccccccccd 00d8 __real@3f2b68b3cecad284 00e0 __real@3e4e82d10d09af81 00e8 __real@bf2a387bfaf479c9 00f0 __real@3f94a3d4cc7a88a9 0104 __real@3fd86cd01c4ab94c 010c __real@3f920629b90302ae 011c __real@3fea4e925c00b304 0124 __real@3fd189b6e8007758 012e __real@3f26af77f334e750 0136 __real@3e48cc5a847e6cec 013e __real@bf25b483c69835dd 0146 __real@3f912335baec487f 015a __real@3fd44d1459bcc5f6 0162 __real@3f8defad6e212118 0172 __real@3fe5de431d442afd 017a __real@3fcd28597c5ae288 019c __real@3dcf473de6af278e 01ac __real@4000000000000000 01b7 __real@3f962e42fe000000 01bf __real@40471547652b82fe 01f2 splitexp"
	strings:
		$1 = { 48 83 EC 78 48 BA FF FF FF FF FF FF FF 7F 0F 29 74 24 60 F2 0F 11 84 24 88 00 00 00 48 8B 8C 24 88 00 00 00 48 8B C1 0F 29 7C 24 50 48 23 C2 44 0F 29 44 24 40 48 BA 00 00 00 00 00 00 30 3E 44 0F 28 C0 48 3B C2 73 1C 48 85 C0 0F 84 28 02 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 41 0F 28 C0 E9 15 02 00 00 48 BA 00 00 00 00 00 00 F0 7F 48 3B C2 76 0A E8 ?? ?? ?? ?? E9 FC 01 00 00 45 33 D2 48 3B C1 41 0F 95 C2 4D 85 D2 74 08 44 0F 57 05 ?? ?? ?? ?? 66 44 0F 2F 05 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? 0F 87 BF 01 00 00 66 41 0F 2F F8 0F 82 E2 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 41 0F 28 D0 F2 41 0F 59 D0 66 41 0F 2F C0 0F 28 CA 0F 28 C2 76 56 F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C F8 F2 0F 59 CA F2 0F 59 FA F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C 3D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 FA F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C 3D ?? ?? ?? ?? EB 54 F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C F8 F2 0F 59 CA F2 0F 59 FA F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C 3D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 FA F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C 3D ?? ?? ?? ?? 0F 28 C2 F2 41 0F 59 C0 F2 0F 59 F8 F2 0F 5E F9 F2 41 0F 58 F8 E9 D2 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 48 8D 84 24 98 00 00 00 F2 0F 10 35 ?? ?? ?? ?? 0F 28 CF F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 89 44 24 38 48 8D 84 24 90 00 00 00 48 89 44 24 30 48 8D 84 24 80 00 00 00 48 89 44 24 28 F2 0F 11 44 24 20 F2 44 0F 59 C6 41 0F 28 C0 E8 ?? ?? ?? ?? 44 8B 8C 24 80 00 00 00 41 8B C1 99 2B C2 BA FF 03 00 00 D1 F8 48 63 C8 44 2B C8 48 03 CA 49 63 C1 48 C1 E1 34 48 03 C2 48 89 8C 24 88 00 00 00 F2 0F 10 94 24 88 00 00 00 48 C1 E0 34 48 89 84 24 88 00 00 00 F2 0F 10 84 24 88 00 00 00 F2 0F 10 8C 24 90 00 00 00 F2 0F 58 8C 24 98 00 00 00 F2 0F 59 CA F2 0F 59 C8 F2 0F 58 CF F2 0F 5E F1 F2 0F 5C FE 4D 85 D2 74 07 0F 57 3D ?? ?? ?? ?? 0F 28 C7 0F 28 74 24 60 0F 28 7C 24 50 44 0F 28 44 24 40 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_74_4_0 {
	meta:
		name = "val_with_flags"
		size = 74
		refs = "0039 _set_statfp"
		altNames = "valf_with_flags"
	strings:
		$1 = { 48 83 EC 38 33 C0 0F 29 74 24 20 F6 C2 01 0F 28 F0 8D 48 08 0F 45 C1 F6 C2 02 74 03 83 C8 10 F6 C2 04 74 03 83 C8 04 84 D1 74 03 83 C8 01 F6 C2 10 74 03 83 C8 20 8B C8 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_75_10_0 {
	meta:
		name = "__acrt_locale_free_monetary"
		size = 266
		refs = "0018 __acrt_lconv_c 001f _free_base"
	strings:
		$1 = { 48 85 C9 0F 84 00 01 00 00 53 48 83 EC 20 48 8B D9 48 8B 49 18 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 20 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 28 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 30 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 38 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 40 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 48 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 68 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 70 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 78 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 8B 80 00 00 00 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 8B 88 00 00 00 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 8B 90 00 00 00 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_75_11_0 {
	meta:
		name = "__acrt_locale_initialize_monetary"
		size = 1336
		refs = "0047 __acrt_lconv_c 005f _calloc_base 0069 _free_base 00f7 __acrt_GetLocaleInfoA 038d __acrt_locale_free_monetary"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 40 33 DB 48 89 4D F0 48 8B F1 44 8B FB 48 89 5D F8 48 39 99 40 01 00 00 75 18 48 39 99 48 01 00 00 75 0F 44 8B E3 4C 8D 35 ?? ?? ?? ?? E9 74 04 00 00 41 BD 01 00 00 00 BA 98 00 00 00 41 8B CD E8 ?? ?? ?? ?? 33 C9 4C 8B F0 E8 ?? ?? ?? ?? 4D 85 F6 75 08 41 8B C5 E9 A0 04 00 00 BF 04 00 00 00 49 8B CD 8B D7 E8 ?? ?? ?? ?? 33 C9 4C 8B E0 E8 ?? ?? ?? ?? 4D 85 E4 75 0A 49 8B CE E8 ?? ?? ?? ?? EB D0 48 39 9E 40 01 00 00 0F 84 52 03 00 00 48 8B D7 49 8B CD E8 ?? ?? ?? ?? 33 C9 4C 8B F8 E8 ?? ?? ?? ?? 4D 85 FF 75 0D 49 8B CE E8 ?? ?? ?? ?? 49 8B CC EB C5 48 8B BE 40 01 00 00 49 8D 46 18 4C 8B C7 48 89 44 24 20 41 B9 15 00 00 00 48 8D 4D F0 41 8B D5 E8 ?? ?? ?? ?? 49 8D 4E 20 41 B9 14 00 00 00 48 89 4C 24 20 4C 8B C7 48 8D 4D F0 41 8B D5 8B D8 E8 ?? ?? ?? ?? 49 8D 4E 28 41 B9 16 00 00 00 48 89 4C 24 20 4C 8B C7 48 8D 4D F0 41 8B D5 0B D8 E8 ?? ?? ?? ?? 0B D8 48 8D 4D F0 49 8D 46 30 41 B9 17 00 00 00 4C 8B C7 48 89 44 24 20 41 8B D5 E8 ?? ?? ?? ?? 41 B9 18 00 00 00 4D 8D 6E 38 4C 8B C7 4C 89 6C 24 20 48 8D 4D F0 0B D8 41 8D 51 E9 E8 ?? ?? ?? ?? 41 B9 50 00 00 00 48 8D 4D F0 0B D8 4C 8B C7 49 8D 46 40 48 89 44 24 20 41 8D 51 B1 E8 ?? ?? ?? ?? 41 B9 51 00 00 00 48 8D 4D F0 0B D8 4C 8B C7 49 8D 46 48 48 89 44 24 20 41 8D 51 B0 E8 ?? ?? ?? ?? 0B D8 48 8D 4D F0 49 8D 46 50 41 B9 1A 00 00 00 4C 8B C7 48 89 44 24 20 33 D2 E8 ?? ?? ?? ?? 0B D8 48 8D 4D F0 49 8D 46 51 41 B9 19 00 00 00 4C 8B C7 48 89 44 24 20 33 D2 E8 ?? ?? ?? ?? 0B D8 48 8D 4D F0 49 8D 46 52 41 B9 54 00 00 00 4C 8B C7 48 89 44 24 20 33 D2 E8 ?? ?? ?? ?? 0B D8 49 8D 46 53 41 B9 55 00 00 00 4C 8B C7 48 89 44 24 20 33 D2 48 8D 4D F0 E8 ?? ?? ?? ?? 0B D8 48 8D 4D F0 49 8D 46 54 41 B9 56 00 00 00 4C 8B C7 48 89 44 24 20 33 D2 E8 ?? ?? ?? ?? 0B D8 48 8D 4D F0 49 8D 46 55 41 B9 57 00 00 00 4C 8B C7 48 89 44 24 20 33 D2 E8 ?? ?? ?? ?? 0B D8 48 8D 4D F0 49 8D 46 56 41 B9 52 00 00 00 4C 8B C7 48 89 44 24 20 33 D2 E8 ?? ?? ?? ?? 0B D8 48 8D 4D F0 49 8D 46 57 41 B9 53 00 00 00 4C 8B C7 48 89 44 24 20 33 D2 E8 ?? ?? ?? ?? 41 B9 15 00 00 00 48 8D 4D F0 0B D8 4C 8B C7 49 8D 46 68 48 89 44 24 20 41 8D 51 ED E8 ?? ?? ?? ?? 41 B9 14 00 00 00 48 8D 4D F0 0B D8 4C 8B C7 49 8D 46 70 48 89 44 24 20 41 8D 51 EE E8 ?? ?? ?? ?? 41 B9 16 00 00 00 48 8D 4D F0 0B D8 4C 8B C7 49 8D 46 78 48 89 44 24 20 41 8D 51 EC E8 ?? ?? ?? ?? 41 B9 17 00 00 00 48 8D 4D F0 0B D8 4C 8B C7 49 8D 86 80 00 00 00 48 89 44 24 20 41 8D 51 EB E8 ?? ?? ?? ?? 41 B9 50 00 00 00 48 8D 4D F0 0B D8 4C 8B C7 49 8D 86 88 00 00 00 48 89 44 24 20 41 8D 51 B2 E8 ?? ?? ?? ?? 0B D8 49 8D 86 90 00 00 00 41 B9 51 00 00 00 48 89 44 24 20 4C 8B C7 48 8D 4D F0 41 8D 51 B1 E8 ?? ?? ?? ?? 0B C3 74 2A 49 8B CE E8 ?? ?? ?? ?? 49 8B CE E8 ?? ?? ?? ?? 49 8B CC E8 ?? ?? ?? ?? 49 8B CF E8 ?? ?? ?? ?? B8 01 00 00 00 E9 67 01 00 00 49 8B 55 00 33 DB 38 1A 0F 84 A8 00 00 00 8A 0A 8D 41 D0 3C 09 77 17 80 E9 30 88 0A 41 BD 01 00 00 00 49 03 D5 38 1A 75 E5 E9 8E 00 00 00 80 F9 3B 75 E9 4C 8B C2 49 8D 48 01 8A 01 41 88 00 4C 8B C1 84 C0 75 F0 41 BD 01 00 00 00 EB D7 48 8D 05 ?? ?? ?? ?? BA 80 00 00 00 0F 10 00 41 0F 11 06 0F 10 48 10 41 0F 11 4E 10 0F 10 40 20 41 0F 11 46 20 0F 10 48 30 41 0F 11 4E 30 0F 10 40 40 41 0F 11 46 40 0F 10 48 50 41 0F 11 4E 50 0F 10 40 60 41 0F 11 46 60 0F 10 40 70 41 0F 11 44 16 F0 0F 10 0C 10 41 0F 11 0C 16 48 8B 44 10 10 49 89 44 16 10 EB 06 41 BD 01 00 00 00 48 8B 86 F8 00 00 00 48 8B 08 49 89 0E 48 8B 86 F8 00 00 00 48 8B 48 08 49 89 4E 08 48 8B 86 F8 00 00 00 48 8B 48 10 49 89 4E 10 48 8B 86 F8 00 00 00 48 8B 48 58 49 89 4E 58 48 8B 86 F8 00 00 00 48 8B 48 60 49 89 4E 60 45 89 2C 24 4D 85 FF 74 03 45 89 2F 48 8B 86 F0 00 00 00 48 85 C0 74 03 F0 FF 08 48 8B 8E E0 00 00 00 48 85 C9 74 24 83 C8 FF F0 0F C1 01 83 F8 01 75 18 48 8B 8E F8 00 00 00 E8 ?? ?? ?? ?? 48 8B 8E E0 00 00 00 E8 ?? ?? ?? ?? 4C 89 BE F0 00 00 00 33 C0 4C 89 A6 E0 00 00 00 4C 89 B6 F8 00 00 00 4C 8D 5C 24 40 49 8B 5B 30 49 8B 73 38 49 8B 7B 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_75_12_0 {
	meta:
		name = "fix_grouping"
		size = 60
	strings:
		$1 = { 45 33 C9 48 8B D1 44 38 09 74 16 8A 0A 8D 41 D0 3C 09 77 0E 80 E9 30 88 0A 48 FF C2 44 38 0A 75 EA C3 80 F9 3B 75 F2 4C 8B C2 49 8D 48 01 8A 01 41 88 00 4C 8B C1 84 C0 75 F0 EB E0 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "imaxdiv"
		size = 29
	strings:
		$1 = { 4C 8B CA 48 8B C2 48 99 49 F7 F8 48 89 01 49 0F AF C0 4C 2B C8 48 8B C1 4C 89 49 08 C3 }
	condition:
		$1
}

rule file_77_4_0 {
	meta:
		name = "?capture_current_context@@YAXQEAU_CONTEXT@@@Z"
		size = 109
		refs = "000f __imp_RtlCaptureContext 0027 __imp_RtlLookupFunctionEntry 005e __imp_RtlVirtualUnwind"
	strings:
		$1 = { 48 89 5C 24 20 57 48 83 EC 40 48 8B D9 FF 15 ?? ?? ?? ?? 48 8B BB F8 00 00 00 48 8D 54 24 50 48 8B CF 45 33 C0 FF 15 ?? ?? ?? ?? 48 85 C0 74 32 48 83 64 24 38 00 48 8D 4C 24 58 48 8B 54 24 50 4C 8B C8 48 89 4C 24 30 4C 8B C7 48 8D 4C 24 60 48 89 4C 24 28 33 C9 48 89 5C 24 20 FF 15 ?? ?? ?? ?? 48 8B 5C 24 68 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_77_8_0 {
	meta:
		name = "__acrt_call_reportfault"
		size = 347
		refs = "0020 __security_cookie 003b __crt_debugger_hook 004d memset 007b __imp_RtlCaptureContext 0093 __imp_RtlLookupFunctionEntry 00ce __imp_RtlVirtualUnwind 0107 __imp_IsDebuggerPresent 0111 __imp_SetUnhandledExceptionFilter 011c __imp_UnhandledExceptionFilter 013f __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 55 57 41 56 48 8D AC 24 10 FB FF FF 48 81 EC F0 05 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 E0 04 00 00 41 8B F8 8B F2 8B D9 83 F9 FF 74 05 E8 ?? ?? ?? ?? 33 D2 48 8D 4C 24 70 41 B8 98 00 00 00 E8 ?? ?? ?? ?? 33 D2 48 8D 4D 10 41 B8 D0 04 00 00 E8 ?? ?? ?? ?? 48 8D 44 24 70 48 89 44 24 48 48 8D 4D 10 48 8D 45 10 48 89 44 24 50 FF 15 ?? ?? ?? ?? 4C 8B B5 08 01 00 00 48 8D 54 24 40 49 8B CE 45 33 C0 FF 15 ?? ?? ?? ?? 48 85 C0 74 36 48 83 64 24 38 00 48 8D 4C 24 58 48 8B 54 24 40 4C 8B C8 48 89 4C 24 30 4D 8B C6 48 8D 4C 24 60 48 89 4C 24 28 48 8D 4D 10 48 89 4C 24 20 33 C9 FF 15 ?? ?? ?? ?? 48 8B 85 08 05 00 00 48 89 85 08 01 00 00 48 8D 85 08 05 00 00 48 83 C0 08 89 74 24 70 48 89 85 A8 00 00 00 48 8B 85 08 05 00 00 48 89 45 80 89 7C 24 74 FF 15 ?? ?? ?? ?? 33 C9 8B F8 FF 15 ?? ?? ?? ?? 48 8D 4C 24 48 FF 15 ?? ?? ?? ?? 85 C0 75 10 85 FF 75 0C 83 FB FF 74 07 8B CB E8 ?? ?? ?? ?? 48 8B 8D E0 04 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 F0 05 00 00 49 8B 5B 28 49 8B 73 30 49 8B E3 41 5E 5F 5D C3 }
	condition:
		$1
}

rule file_77_10_0 {
	meta:
		name = "_get_invalid_parameter_handler"
		size = 23
		refs = "0003 __security_cookie 000c ?__acrt_invalid_parameter_handler@@3V?$dual_state_global@P6AXPEB_W00I_K@Z@__crt_state_management@@A"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 8B C8 48 33 05 ?? ?? ?? ?? 83 E1 3F 48 D3 C8 C3 }
	condition:
		$1
}

rule file_77_11_0 {
	meta:
		name = "_get_thread_local_invalid_parameter_handler"
		size = 26
		refs = "0005 __acrt_getptd_noexit"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 74 07 48 8B 80 B8 03 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_77_12_0 {
	meta:
		name = "_invalid_parameter"
		size = 174
		refs = "0021 __acrt_getptd_noexit 004e __guard_dispatch_icall_fptr 006a __security_cookie 007a ?__acrt_invalid_parameter_handler@@3V?$dual_state_global@P6AXPEB_W00I_K@Z@__crt_state_management@@A 00a9 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 41 8B D9 49 8B F8 48 8B F2 48 8B E9 E8 ?? ?? ?? ?? 48 85 C0 74 3D 48 8B 80 B8 03 00 00 48 85 C0 74 31 48 8B 54 24 60 44 8B CB 48 89 54 24 20 4C 8B C7 48 8B D6 48 8B CD FF 15 ?? ?? ?? ?? 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 4C 8B 15 ?? ?? ?? ?? 44 8B CB 41 8B CA 4C 8B C7 4C 33 15 ?? ?? ?? ?? 83 E1 3F 49 D3 CA 48 8B D6 4D 85 D2 74 0F 48 8B 4C 24 60 49 8B C2 48 89 4C 24 20 EB AE 48 8B 44 24 60 48 8B CD 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_77_13_0 {
	meta:
		name = "_invalid_parameter_noinfo"
		size = 30
		refs = "0015 _invalid_parameter"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_77_14_0 {
	meta:
		name = "_invalid_parameter_noinfo_noreturn"
		size = 47
		refs = "0015 _invalid_parameter 002a _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_77_15_0 {
	meta:
		name = "_invoke_watson"
		size = 70
		refs = "000a IsProcessorFeaturePresent 0029 __acrt_call_reportfault 002f __imp_GetCurrentProcess 0042 __imp_TerminateProcess"
	strings:
		$1 = { 48 83 EC 28 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 B9 05 00 00 00 CD 29 41 B8 01 00 00 00 BA 17 04 00 C0 41 8D 48 01 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 BA 17 04 00 C0 48 83 C4 28 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_16_0 {
	meta:
		name = "_set_invalid_parameter_handler"
		size = 52
		refs = "0003 __security_cookie 001b ?__acrt_invalid_parameter_handler@@3V?$dual_state_global@P6AXPEB_W00I_K@Z@__crt_state_management@@A"
	strings:
		$1 = { 4C 8B 05 ?? ?? ?? ?? 4C 8B C9 41 8B D0 B9 40 00 00 00 83 E2 3F 49 8B C0 48 33 05 ?? ?? ?? ?? 2B CA 49 D3 C9 8B CA 4D 33 C8 48 D3 C8 4C 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_77_17_0 {
	meta:
		name = "_set_thread_local_invalid_parameter_handler"
		size = 37
		refs = "000a __acrt_getptd"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B D0 48 8B 80 B8 03 00 00 48 89 9A B8 03 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "fmodf"
		size = 580
		refs = "00d0 __xmm@80000000000000008000000000000000 01f1 _handle_nanf 020a ??_C@_05OOAOEJGP@fmodf?$AA@ 023b _handle_errorf"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 58 48 B8 FF FF FF FF FF FF FF 7F 0F 28 E1 0F 28 C8 0F 57 D2 F3 0F 5A D1 0F 57 DB F2 0F 11 54 24 70 4C 8B 44 24 70 F3 0F 5A DC 4D 8B C8 49 8B C8 4C 23 C8 48 C1 E9 34 F2 0F 11 5C 24 70 4C 8B 5C 24 70 4D 8B D3 49 8B D3 4C 23 D0 48 C1 EA 34 B8 FF 07 00 00 23 C8 23 D0 83 F9 01 0F 8C 42 01 00 00 81 F9 FE 07 00 00 0F 8F 3E 01 00 00 8D 42 FF 3D FD 07 00 00 0F 87 28 01 00 00 4D 3B CA 75 21 48 B8 00 00 00 00 00 00 00 80 4C 23 C0 4C 89 44 24 70 F2 0F 10 44 24 70 66 0F 5A C0 E9 95 01 00 00 4C 89 4C 24 70 F2 0F 10 54 24 70 4C 89 54 24 70 F2 0F 10 5C 24 70 4D 3B CA 73 1B 0F 57 C0 0F 2F C1 76 07 0F 57 15 ?? ?? ?? ?? 0F 57 C0 F2 0F 5A C2 E9 5F 01 00 00 0F AE 5C 24 68 44 8B 44 24 68 3B CA 7E 76 2B CA B8 AB AA AA 2A F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 52 8D 04 C5 FF 03 00 00 48 63 C8 48 B8 00 00 00 00 00 00 70 3E 48 C1 E1 34 48 89 4C 24 70 F2 0F 10 44 24 70 F2 0F 59 C3 48 89 44 24 70 F2 0F 10 64 24 70 0F 28 D8 85 D2 7E 27 8B CA 0F 28 C2 F2 0F 5E C3 F2 0F 2C C0 66 0F 6E C8 F3 0F E6 C9 F2 0F 59 CB F2 0F 59 DC F2 0F 5C D1 48 83 E9 01 75 DB 0F 28 C2 44 89 44 24 68 F2 0F 5E C3 F2 0F 2C C0 66 0F 6E C8 F3 0F E6 C9 F2 0F 59 CB F2 0F 5C D1 F2 0F 11 54 24 70 0F AE 54 24 68 0F 57 C0 0F 2F 44 24 60 0F 28 C2 76 07 0F 57 05 ?? ?? ?? ?? F2 0F 5A C0 E9 93 00 00 00 81 F9 FE 07 00 00 7E 17 48 B8 FF FF FF FF FF FF 0F 00 4C 85 C0 74 3C F3 0F 11 4C 24 60 EB 1D 81 FA FE 07 00 00 7E 22 48 B8 FF FF FF FF FF FF 0F 00 4C 85 D8 74 5D F3 0F 11 64 24 60 8B 4C 24 60 48 83 C4 58 E9 ?? ?? ?? ?? 83 F9 01 7D 05 83 FA 01 7D 40 C7 44 24 40 02 00 00 00 48 8D 0D ?? ?? ?? ?? F3 0F 11 64 24 38 41 B9 01 00 00 00 F3 0F 11 4C 24 30 41 B8 00 00 C0 FF C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 41 8D 51 15 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "cabs"
		size = 66
		refs = "0020 cimag 002d creal 003e hypot"
	strings:
		$1 = { 48 8B C4 48 83 EC 58 0F 10 01 48 8D 48 C8 0F 29 70 E8 0F 10 C8 F3 0F 7F 48 D8 F3 0F 7F 40 C8 E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE 0F 28 74 24 40 48 83 C4 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "cabsl"
		size = 66
		refs = "0020 cimagl 002d creall 003e _hypot"
	strings:
		$1 = { 48 8B C4 48 83 EC 58 0F 10 01 48 8D 48 C8 0F 29 70 E8 0F 10 C8 F3 0F 7F 48 D8 F3 0F 7F 40 C8 E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE 0F 28 74 24 40 48 83 C4 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "cargl"
		size = 66
		refs = "0020 creall 002d cimagl 003e atan2"
	strings:
		$1 = { 48 8B C4 48 83 EC 58 0F 10 01 48 8D 48 C8 0F 29 70 E8 0F 10 C8 F3 0F 7F 48 D8 F3 0F 7F 40 C8 E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE 0F 28 74 24 40 48 83 C4 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "cacosf"
		size = 706
		refs = "0034 crealf 0042 cimagf 0050 _fdtest 009a _FInf_C 00ac __real@3fc90fdb 00d7 __real@4016cbe4 00e1 __real@3f490fdb 00f4 __real@40490fdb 0109 __xmm@80000000800000008000000080000000 014f __real@3f800000 015f _FCbuild 0167 csqrtf 01d3 conjf 01e6 atan2f 01f1 __real@5e7fe80a 01fd __real@40000000 0259 asinhf 0261 __real@00000000 0271 logf"
	strings:
		$1 = { 48 8B C4 48 89 58 20 55 48 8D 68 A1 48 81 EC 90 00 00 00 0F 29 70 E8 0F 29 78 D8 44 0F 29 40 C8 44 0F 29 48 B8 44 0F 29 50 A8 44 0F 29 58 98 48 89 4D E7 E8 ?? ?? ?? ?? 48 8B 4D E7 F3 0F 11 45 77 E8 ?? ?? ?? ?? 48 8D 4D 77 F3 0F 11 45 6F E8 ?? ?? ?? ?? 48 8D 4D 6F 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 02 75 1F F3 0F 10 7D 77 66 3B C3 75 0A F3 0F 10 75 6F E9 0E 02 00 00 66 83 F8 01 75 37 E9 AB 00 00 00 66 83 F8 02 75 34 66 83 FB 01 75 12 F3 0F 10 7D 6F F3 0F 10 35 ?? ?? ?? ?? E9 E5 01 00 00 66 85 DB 75 0A F3 0F 10 3D ?? ?? ?? ?? EB BE F3 0F 10 7D 6F 0F 28 F7 E9 C9 01 00 00 66 83 FB 01 75 5D 66 3B C3 75 1D 0F 57 C0 0F 2F 45 77 76 0A F3 0F 10 3D ?? ?? ?? ?? EB 1B F3 0F 10 3D ?? ?? ?? ?? EB 11 0F 57 FF 0F 2F 7D 77 76 08 F3 0F 10 3D ?? ?? ?? ?? F3 0F 10 35 ?? ?? ?? ?? B8 00 80 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 57 F0 66 85 45 71 0F 84 6E 01 00 00 0F 57 F0 E9 66 01 00 00 66 83 F8 01 75 19 F3 0F 10 3D ?? ?? ?? ?? F3 0F 10 75 6F 0F 57 35 ?? ?? ?? ?? E9 47 01 00 00 F3 0F 10 45 77 F3 0F 10 4D 6F F3 0F 10 35 ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? F3 0F 58 C6 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? F3 0F 5C 75 77 F3 0F 10 4D 6F 0F 57 0D ?? ?? ?? ?? 66 48 0F 6E F8 0F 28 C6 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 66 48 0F 7E F9 66 48 0F 6E F0 E8 ?? ?? ?? ?? 66 48 0F 7E F9 44 0F 28 D8 E8 ?? ?? ?? ?? 66 48 0F 7E F1 44 0F 28 D0 E8 ?? ?? ?? ?? 66 48 0F 7E F1 44 0F 28 C0 E8 ?? ?? ?? ?? 66 48 0F 7E F9 0F 28 F0 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 0F 28 C8 0F 28 C6 E8 ?? ?? ?? ?? 0F 28 F8 F3 0F 10 05 ?? ?? ?? ?? 44 0F 2F D8 F3 0F 59 3D ?? ?? ?? ?? 76 0B 45 0F 28 CB F3 41 0F 5E F3 EB 3D 44 0F 2F D0 45 0F 28 CA 76 07 F3 45 0F 5E C2 EB 13 44 0F 57 0D ?? ?? ?? ?? 44 0F 2F C8 76 15 F3 45 0F 5E C1 F3 45 0F 59 C3 F3 44 0F 58 C6 41 0F 28 F0 EB 13 45 0F 57 C9 F3 45 0F 59 C3 F3 41 0F 59 F2 F3 41 0F 58 F0 0F 28 C6 E8 ?? ?? ?? ?? 44 0F 2E 0D ?? ?? ?? ?? 0F 28 F0 7A 02 74 1C 41 0F 28 C1 E8 ?? ?? ?? ?? 0F 2F 3D ?? ?? ?? ?? 72 06 F3 0F 58 F0 EB 04 F3 0F 5C F0 0F 28 CE 0F 28 C7 E8 ?? ?? ?? ?? 0F 28 7C 24 70 4C 8D 9C 24 90 00 00 00 49 8B 5B 28 41 0F 28 73 F0 45 0F 28 43 D0 45 0F 28 4B C0 45 0F 28 53 B0 45 0F 28 5B A0 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "cproj"
		size = 186
		refs = "0023 creal 003c cimag 004c _dtest 0079 _Zero_C 0080 __xmm@80000000000000008000000000000000 008d _Inf_C"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 18 57 48 83 EC 50 0F 10 02 48 8B F1 48 8B FA 48 8D 48 D8 F3 0F 7F 40 D8 E8 ?? ?? ?? ?? F2 0F 11 44 24 40 48 8D 4C 24 30 0F 10 07 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 40 F2 0F 11 44 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 01 74 06 66 83 F8 01 75 37 B8 00 80 00 00 66 85 44 24 26 74 11 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? EB 03 0F 57 C9 F2 0F 10 05 ?? ?? ?? ?? 48 8D 7C 24 30 66 0F 14 C1 66 0F 7F 44 24 30 0F 10 07 48 8B 5C 24 60 48 8B C6 F3 0F 7F 06 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_451_1_0 {
	meta:
		name = "cprojl"
		size = 186
		refs = "0023 creall 003c cimagl 004c _ldtest 0079 _LZero_C 0080 __xmm@80000000000000008000000000000000 008d _LInf_C"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 18 57 48 83 EC 50 0F 10 02 48 8B F1 48 8B FA 48 8D 48 D8 F3 0F 7F 40 D8 E8 ?? ?? ?? ?? F2 0F 11 44 24 40 48 8D 4C 24 30 0F 10 07 F3 0F 7F 44 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 40 F2 0F 11 44 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 01 74 06 66 83 F8 01 75 37 B8 00 80 00 00 66 85 44 24 26 74 11 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? EB 03 0F 57 C9 F2 0F 10 05 ?? ?? ?? ?? 48 8D 7C 24 30 66 0F 14 C1 66 0F 7F 44 24 30 0F 10 07 48 8B 5C 24 60 48 8B C6 F3 0F 7F 06 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "cexpf"
		size = 475
		refs = "0019 crealf 0027 cimagf 0035 _fdtest 00c8 _FZero_C 00cf __xmm@80000000800000008000000080000000 00de cosf 00f4 sinf 0107 _fperrraise 0114 _FNan_C 0198 _fdexp 01c6 _FCbuild"
	strings:
		$1 = { 40 55 53 48 8B EC 48 83 EC 58 0F 29 74 24 40 0F 29 7C 24 30 48 89 4D D0 E8 ?? ?? ?? ?? 48 8B 4D D0 F3 0F 11 45 C8 E8 ?? ?? ?? ?? 48 8D 4D C8 F3 0F 11 45 30 E8 ?? ?? ?? ?? 48 8D 4D 30 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 02 75 1D F3 0F 10 7D C8 F3 0F 11 7D 28 66 85 C0 0F 85 0C 01 00 00 F3 0F 10 75 30 E9 05 01 00 00 B9 01 00 00 00 66 83 F8 02 75 28 66 3B D9 75 19 0F 57 FF 0F 2F 7D C8 0F 87 E0 00 00 00 F3 0F 10 7D C8 F3 0F 11 7D 28 EB CD F3 0F 10 7D 30 E9 CA 00 00 00 66 3B D9 0F 85 AF 00 00 00 0F 57 F6 0F 2F 75 C8 76 54 66 3B C1 75 26 0F 2F 75 30 0F 28 FE F3 0F 11 7D 28 0F 86 A9 00 00 00 F3 0F 10 35 ?? ?? ?? ?? 0F 57 35 ?? ?? ?? ?? E9 95 00 00 00 F3 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 F8 F3 0F 10 45 30 F3 0F 59 FE F3 0F 11 7D 28 E8 ?? ?? ?? ?? F3 0F 59 C6 0F 28 F0 EB 6C 66 3B C1 75 19 E8 ?? ?? ?? ?? F3 0F 10 7D C8 F3 0F 10 35 ?? ?? ?? ?? F3 0F 11 7D 28 EB 4E 66 85 C0 0F 84 5D FF FF FF F3 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 F8 F3 0F 10 45 30 F3 0F 59 7D C8 F3 0F 11 7D 28 E8 ?? ?? ?? ?? 0F 28 F0 F3 0F 59 75 C8 EB 1A 66 3B C1 75 1C E8 ?? ?? ?? ?? F3 0F 10 3D ?? ?? ?? ?? F3 0F 11 7D 28 0F 28 F7 F3 0F 11 75 20 EB 4B F3 0F 10 45 C8 F3 0F 11 45 28 F3 0F 11 45 20 F3 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 C8 48 8D 4D 28 45 33 C0 E8 ?? ?? ?? ?? F3 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 C8 48 8D 4D 20 45 33 C0 E8 ?? ?? ?? ?? F3 0F 10 7D 28 F3 0F 10 75 20 0F 28 CE 0F 28 C7 E8 ?? ?? ?? ?? 0F 28 74 24 40 0F 28 7C 24 30 48 83 C4 58 5B 5D C3 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "fmax"
		size = 110
		refs = "0016 _dtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 38 EB 41 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 30 EB 29 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 77 17 66 0F 2E C8 7A 0E 75 0C B8 00 80 00 00 66 85 44 24 36 75 03 0F 28 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "fmaxl"
		size = 110
		refs = "0016 _ldtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 38 EB 41 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 30 EB 29 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 77 17 66 0F 2E C8 7A 0E 75 0C B8 00 80 00 00 66 85 44 24 36 75 03 0F 28 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "coshf"
		size = 657
		refs = "0008 __real@3ff0000000000000 0049 __real@3f800000 0059 __real@7e37e43c8800759c 0069 _set_statfp 008f _handle_nanf 00b5 __xmm@80000000000000008000000000000000 00bd __real@40565a9f84f82e63 00ce ??_C@_05NHNGJKPP@coshf?$AA@ 0101 _handle_errorf 010e __real@40420fd21b95825f 011c __real@3dcf473de6af278e 0129 __real@3f962e42fe000000 0156 __real@40471547652b82fe 015b splitexp 01a7 __ImageBase 01c4 __real@3d6b4125921ea08b 01d0 __real@3de611cb2bdcb7be 01dc __real@3e5ae6460fbe61c0 01e8 __real@3ec71de3a4e13e7d 01f4 __real@3f2a01a01a01ee80 0200 __real@3f811111111110fd 020c __real@3fc5555555555555 021b __real@3da9984b7f63fcd7 0227 __real@3e21ee56385b7b20 0230 ?sinh_lead@?1??coshf@@9@9 023c __real@3e927e5069f1cb55 0248 __real@3efa01a019079011 0254 __real@3f56c16c16c212e5 0260 __real@3fa5555555555502 026c __real@3fe0000000000000 027d ?cosh_lead@?1??coshf@@9@9"
	strings:
		$1 = { 48 83 EC 58 F2 0F 10 2D ?? ?? ?? ?? 48 BA FF FF FF FF FF FF FF 7F 0F 28 C8 0F 57 E4 F3 0F 5A E1 F2 0F 11 64 24 68 48 8B 4C 24 68 48 8B C1 48 23 C2 48 BA 00 00 00 00 00 00 10 3F 48 3B C2 73 2F 48 85 C0 75 0D F3 0F 10 05 ?? ?? ?? ?? E9 3A 02 00 00 0F 28 C4 F2 0F 58 05 ?? ?? ?? ?? 66 0F 2F C5 76 4A B9 20 00 00 00 E8 ?? ?? ?? ?? EB D6 48 BA 00 00 00 00 00 00 F0 7F 48 3B C2 72 2F 76 13 F3 0F 11 4C 24 68 8B 4C 24 68 48 83 C4 58 E9 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? C7 44 24 68 00 00 80 7F F3 0F 10 44 24 68 E9 DF 01 00 00 48 3B C1 74 07 0F 57 25 ?? ?? ?? ?? 66 0F 2F 25 ?? ?? ?? ?? 72 47 C7 44 24 40 01 00 00 00 48 8D 0D ?? ?? ?? ?? BA 13 00 00 00 0F 57 C0 F3 0F 11 44 24 38 41 B8 00 00 80 7F F3 0F 11 4C 24 30 C7 44 24 28 22 00 00 00 44 8D 4A F0 C7 44 24 20 11 00 00 00 E8 ?? ?? ?? ?? E9 82 01 00 00 66 0F 2F 25 ?? ?? ?? ?? 0F 82 81 00 00 00 F2 0F 10 15 ?? ?? ?? ?? 48 8D 44 24 78 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CD 48 89 44 24 38 0F 28 C4 48 8D 44 24 70 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 F2 0F 11 54 24 20 F2 0F 10 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B 4C 24 60 41 FF C9 49 63 C1 48 05 FF 03 00 00 44 89 4C 24 60 48 C1 E0 34 48 89 44 24 68 F2 0F 10 44 24 68 F2 0F 10 54 24 70 F2 0F 58 54 24 78 F2 0F 59 D0 E9 EC 00 00 00 F2 0F 2C C4 48 63 C8 66 0F 6E C0 48 8D 05 ?? ?? ?? ?? F3 0F E6 C0 F2 0F 5C E0 0F 28 CC F2 0F 59 CC 0F 28 D1 0F 28 C1 F2 0F 59 15 ?? ?? ?? ?? F2 0F 59 C4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 0F 28 C1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 D4 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 94 C8 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 C5 F2 0F 59 84 C8 ?? ?? ?? ?? F2 0F 58 D0 0F 57 C0 F2 0F 5A C2 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "infinityf_with_flags"
		size = 72
		refs = "0031 _set_statfp"
	strings:
		$1 = { 48 83 EC 28 33 C0 F6 C1 01 8D 50 08 0F 45 C2 F6 C1 02 74 03 83 C8 10 F6 C1 04 74 03 83 C8 04 84 CA 74 03 83 C8 01 F6 C1 10 74 03 83 C8 20 8B C8 E8 ?? ?? ?? ?? C7 44 24 30 00 00 80 7F F3 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_3_0 {
	meta:
		name = "scaleDouble_1"
		size = 32
	strings:
		$1 = { 0F 28 C8 48 63 C2 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 08 F2 0F 10 44 24 08 F2 0F 59 C1 C3 }
	condition:
		$1
}

rule file_85_5_0 {
	meta:
		name = "_mbsrchr_l"
		size = 185
		refs = "001f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0029 _errno 0034 _invalid_parameter_noinfo 004b strrchr"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 8B F2 48 8B D9 49 8B D0 48 8D 4C 24 20 33 FF E8 ?? ?? ?? ?? 48 85 DB 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 59 4C 8B 44 24 30 41 39 78 08 75 0F 8B D6 48 8B CB E8 ?? ?? ?? ?? 48 8B F8 EB 3F 0F B6 13 8B CA 42 F6 44 02 19 04 74 25 48 FF C3 8A 13 84 D2 74 12 C1 E1 08 0F B6 C2 0B C8 3B F1 75 16 48 8D 7B FF EB 10 48 85 FF 75 0B 48 8B FB EB 06 3B F2 48 0F 44 FB 48 FF C3 84 D2 75 C1 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B 5C 24 50 48 8B C7 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "??$common_time@J@@YAJQEAJ@Z"
		size = 57
		refs = "0019 ??$common_timespec_get@U_timespec32@@@@YAHQEAU_timespec32@@H@Z"
		altNames = "_time32"
	strings:
		$1 = { 40 53 48 83 EC 20 33 C0 48 8B D9 48 8D 4C 24 30 48 89 44 24 30 8D 50 01 E8 ?? ?? ?? ?? 8B 54 24 30 83 C9 FF 83 F8 01 0F 45 D1 48 85 DB 74 02 89 13 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "??$common_time@_J@@YA_JQEA_J@Z"
		size = 62
		refs = "0019 ??$common_timespec_get@U_timespec64@@@@YAHQEAU_timespec64@@H@Z"
		altNames = "_time64"
	strings:
		$1 = { 40 53 48 83 EC 30 33 C0 48 8B D9 48 8D 4C 24 20 48 89 44 24 20 8D 50 01 E8 ?? ?? ?? ?? 48 8B 54 24 20 48 83 C9 FF 83 F8 01 48 0F 45 D1 48 85 DB 74 03 48 89 13 48 8B C2 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "??$common_timespec_get@U_timespec32@@@@YAHQEAU_timespec32@@H@Z"
		size = 142
		refs = "000f _errno 001a _invalid_parameter_noinfo 0034 __acrt_GetSystemTimePreciseAsFileTime"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 66 83 FA 01 75 F7 33 C0 48 8D 4C 24 30 48 89 44 24 30 E8 ?? ?? ?? ?? 4C 8B 44 24 30 48 B9 00 80 C1 2A 21 4E 62 FE 4C 03 C1 48 B8 BD 42 7A E5 D5 94 BF D6 49 F7 E8 49 03 D0 48 C1 FA 17 48 8B C2 48 C1 E8 3F 48 03 D0 48 81 FA 7F D2 FF 7F 7F AD 69 CA 80 96 98 00 B8 01 00 00 00 89 13 44 2B C1 41 6B C8 64 89 4B 04 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "??$common_timespec_get@U_timespec64@@@@YAHQEAU_timespec64@@H@Z"
		size = 149
		refs = "000f _errno 001a _invalid_parameter_noinfo 0034 __acrt_GetSystemTimePreciseAsFileTime"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 6D 83 FA 01 75 F7 33 C0 48 8D 4C 24 30 48 89 44 24 30 E8 ?? ?? ?? ?? 4C 8B 44 24 30 48 B9 00 80 C1 2A 21 4E 62 FE 4C 03 C1 48 B8 BD 42 7A E5 D5 94 BF D6 49 F7 E8 49 03 D0 48 C1 FA 17 48 8B C2 48 C1 E8 3F 48 03 D0 48 B8 FF 2A 58 93 07 00 00 00 48 3B D0 7F A7 69 CA 80 96 98 00 B8 01 00 00 00 48 89 13 44 2B C1 41 6B C8 64 89 4B 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "normf"
		size = 54
		refs = "000f crealf 001c cimagf"
	strings:
		$1 = { 48 83 EC 48 0F 29 74 24 30 48 89 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 E8 ?? ?? ?? ?? F3 0F 59 F6 F3 0F 59 C0 F3 0F 58 C6 0F 28 74 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_88_9_0 {
	meta:
		name = "?ungetwc_binary_mode_nolock@@YAGGV__crt_stdio_stream@@@Z"
		size = 115
	strings:
		$1 = { 48 89 54 24 10 4C 8B 42 08 49 83 C0 02 4C 39 02 73 1E 83 7A 10 00 74 06 B8 FF FF 00 00 C3 48 63 42 20 48 83 F8 02 72 F0 4C 89 02 48 8B 54 24 10 8B 42 14 48 83 02 FE C1 E8 0C A8 01 48 8B 02 74 0E 66 39 08 74 0C 48 83 C0 02 48 89 02 EB C9 66 89 08 48 8B 44 24 10 83 40 10 02 48 8B 44 24 10 F0 83 60 14 F7 48 8B 44 24 10 F0 83 48 14 01 0F B7 C1 C3 }
	condition:
		$1
}

rule file_88_10_0 {
	meta:
		name = "?ungetwc_text_mode_nolock@@YAGGV__crt_stdio_stream@@@Z"
		size = 347
		refs = "001d __security_cookie 0033 _fileno 005c __pioinfo 007f __badioinfo 00a8 wctomb_s 0144 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 48 89 54 24 10 55 57 41 56 48 8B EC 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 0F B7 F1 66 89 4D E0 48 8B CA E8 ?? ?? ?? ?? 83 F8 FF 74 40 48 8B 4D 28 E8 ?? ?? ?? ?? 83 F8 FE 74 32 48 8B 5D 28 48 8B CB E8 ?? ?? ?? ?? 48 63 F8 4C 8D 35 ?? ?? ?? ?? 48 8B CB 48 C1 FF 06 E8 ?? ?? ?? ?? 49 8B 14 FE 83 E0 3F 48 C1 E0 06 48 03 D0 EB 07 48 8D 15 ?? ?? ?? ?? 8A 42 39 33 DB 33 C9 89 5D E8 88 5D EC 89 4D ED 84 C0 75 29 44 0F B7 CE 44 8D 43 05 48 8D 55 EC 48 8D 4D E8 E8 ?? ?? ?? ?? 85 C0 74 0A B8 FF FF 00 00 E9 82 00 00 00 44 8B 45 E8 EB 14 8A 45 E1 41 B8 02 00 00 00 88 45 ED 44 89 45 E8 40 88 75 EC 48 8B 45 28 49 63 D0 4C 8B 48 08 4C 03 CA 4C 39 08 73 16 39 58 10 75 C4 44 3B 40 20 7F BE 4C 89 08 48 8B 45 28 44 8B 45 E8 41 8D 48 FF 48 63 D1 85 C9 78 1A 48 FF 08 48 8B 08 8A 44 15 EC 48 83 EA 01 88 01 48 8B 45 28 79 EA 44 8B 45 E8 44 01 40 10 48 8B 45 28 F0 83 60 14 F7 48 8B 45 28 F0 83 48 14 01 0F B7 45 E0 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 70 48 8B 74 24 78 48 83 C4 40 41 5E 5F 5D C3 }
	condition:
		$1
}

rule file_88_12_0 {
	meta:
		name = "_ungetwc_nolock"
		size = 327
		refs = "005c __acrt_stdio_allocate_buffer_nolock 006e _fileno 0092 __pioinfo 00b5 __badioinfo 00c6 ?ungetwc_text_mode_nolock@@YAGGV__crt_stdio_stream@@@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 BE FF FF 00 00 48 8B FA 0F B7 E9 66 3B CE 0F 84 FC 00 00 00 8B 42 14 8B 52 14 8B 4F 14 A8 01 75 17 C1 EA 02 F6 C2 01 0F 84 E3 00 00 00 D1 E9 F6 C1 01 0F 85 D8 00 00 00 48 83 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 8B 47 14 C1 E8 0C A8 01 75 62 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 74 3B 48 8B CF E8 ?? ?? ?? ?? 83 F8 FE 74 2E 48 8B CF E8 ?? ?? ?? ?? 48 63 D8 4C 8D 35 ?? ?? ?? ?? 48 8B CF 48 C1 FB 06 E8 ?? ?? ?? ?? 49 8B 14 DE 83 E0 3F 48 C1 E0 06 48 03 D0 EB 07 48 8D 15 ?? ?? ?? ?? F6 42 38 80 74 0D 48 8B D7 0F B7 CD E8 ?? ?? ?? ?? EB 60 48 8B 47 08 48 8D 48 02 48 39 0F 73 13 83 7F 10 00 75 4A 48 63 47 20 48 83 F8 02 72 40 48 89 0F 8B 47 14 C1 E8 0C A8 01 48 8B 07 74 15 48 83 E8 02 48 89 07 66 39 28 74 13 48 83 C0 02 48 89 07 EB 1B 48 83 E8 02 48 89 07 66 89 28 83 47 10 02 F0 83 67 14 F7 F0 83 4F 14 01 0F B7 F5 0F B7 C6 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_88_13_0 {
	meta:
		name = "ungetwc"
		size = 101
		refs = "0022 _errno 002d _invalid_parameter_noinfo 003c _lock_file 0048 _ungetwc_nolock 0053 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 54 24 10 57 48 83 EC 20 48 8B DA 0F B7 F9 33 C0 48 85 D2 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF 00 00 EB 22 48 8B CA E8 ?? ?? ?? ?? 90 48 8B D3 0F B7 CF E8 ?? ?? ?? ?? 0F B7 F8 48 8B CB E8 ?? ?? ?? ?? 0F B7 C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_313_11_0 {
	meta:
		name = "fputwc"
		size = 101
		refs = "0022 _errno 002d _invalid_parameter_noinfo 003c _lock_file 0048 _fputwc_nolock 0053 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 54 24 10 57 48 83 EC 20 48 8B DA 0F B7 F9 33 C0 48 85 D2 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF 00 00 EB 22 48 8B CA E8 ?? ?? ?? ?? 90 48 8B D3 0F B7 CF E8 ?? ?? ?? ?? 0F B7 F8 48 8B CB E8 ?? ?? ?? ?? 0F B7 C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "logb"
		size = 109
		refs = "0015 _dunscale 0049 _Inf_C 0055 _fperrraise 0064 __xmm@80000000000000008000000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 54 24 30 48 8D 4C 24 38 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 2F 83 E9 01 74 20 83 F9 01 74 13 0F B7 44 24 38 66 FF C8 98 66 0F 6E C0 F3 0F E6 C0 EB 2B F2 0F 10 44 24 30 EB 23 F2 0F 10 05 ?? ?? ?? ?? EB 19 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_668_0_0 {
	meta:
		name = "logbl"
		size = 109
		refs = "0015 _ldunscale 0049 _LInf_C 0055 _fperrraise 0064 __xmm@80000000000000008000000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 54 24 30 48 8D 4C 24 38 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 2F 83 E9 01 74 20 83 F9 01 74 13 0F B7 44 24 38 66 FF C8 98 66 0F 6E C0 F3 0F E6 C0 EB 2B F2 0F 10 44 24 30 EB 23 F2 0F 10 05 ?? ?? ?? ?? EB 19 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_3_0 {
	meta:
		name = "??$common_assert@D@@YAXQEBD0IQEAX@Z"
		size = 128
		refs = "0026 _set_error_mode 0034 _query_app_type 005e ??$common_assert_to_message_box@D@@YAXQEBD0IQEAX@Z 006c ??$common_assert_to_stderr@D@@YAXQEBD0I@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F1 49 8B E9 B9 03 00 00 00 41 8B D8 48 8B FA E8 ?? ?? ?? ?? 83 F8 01 74 33 85 C0 75 0A E8 ?? ?? ?? ?? 83 F8 01 74 34 4C 8B CD 44 8B C3 48 8B D7 48 8B CE 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? 44 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? CC 44 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_4_0 {
	meta:
		name = "??$common_assert@_W@@YAXQEB_W0IQEAX@Z"
		size = 128
		refs = "0026 _set_error_mode 0034 _query_app_type 005e ??$common_assert_to_message_box@_W@@YAXQEB_W0IQEAX@Z 006c ??$common_assert_to_stderr@_W@@YAXQEB_W0I@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F1 49 8B E9 B9 03 00 00 00 41 8B D8 48 8B FA E8 ?? ?? ?? ?? 83 F8 01 74 33 85 C0 75 0A E8 ?? ?? ?? ?? 83 F8 01 74 34 4C 8B CD 44 8B C3 48 8B D7 48 8B CE 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? 44 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? CC 44 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_5_0 {
	meta:
		name = "??$common_assert_to_message_box@D@@YAXQEBD0IQEAX@Z"
		size = 196
		refs = "0012 __security_cookie 003b memset 0059 ??$common_assert_to_message_box_build_string@D@@YAXQEAD_KQEBD2IQEAX@Z 0066 ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 0070 __acrt_show_narrow_message_box 0092 __security_check_cookie 00aa abort 00b5 raise 00bf _exit"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 48 81 EC 80 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 70 02 00 00 41 8B D8 48 8B F2 48 8B F9 33 D2 41 B8 40 02 00 00 48 8D 4C 24 30 49 8B E9 E8 ?? ?? ?? ?? 4C 8B CE 48 89 6C 24 28 4C 8B C7 89 5C 24 20 BA 40 02 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 41 B8 12 20 01 00 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 83 E8 03 74 36 83 E8 01 74 07 83 F8 01 74 03 EB 24 CC 48 8B 8C 24 70 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B0 02 00 00 48 81 C4 80 02 00 00 5F 5E 5D C3 E8 ?? ?? ?? ?? CC B9 16 00 00 00 E8 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_6_0 {
	meta:
		name = "??$common_assert_to_message_box@_W@@YAXQEB_W0IQEAX@Z"
		size = 196
		refs = "0012 __security_cookie 003b memset 0059 ??$common_assert_to_message_box_build_string@_W@@YAXQEA_W_KQEB_W2IQEAX@Z 0066 ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0070 __acrt_show_wide_message_box 0092 __security_check_cookie 00aa abort 00b5 raise 00bf _exit"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 48 81 EC C0 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 B0 04 00 00 41 8B D8 48 8B F2 48 8B F9 33 D2 41 B8 80 04 00 00 48 8D 4C 24 30 49 8B E9 E8 ?? ?? ?? ?? 4C 8B CE 48 89 6C 24 28 4C 8B C7 89 5C 24 20 BA 40 02 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 41 B8 12 20 01 00 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 83 E8 03 74 36 83 E8 01 74 07 83 F8 01 74 03 EB 24 CC 48 8B 8C 24 B0 04 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 F0 04 00 00 48 81 C4 C0 04 00 00 5F 5E 5D C3 E8 ?? ?? ?? ?? CC B9 16 00 00 00 E8 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_7_0 {
	meta:
		name = "??$common_assert_to_message_box_build_string@D@@YAXQEAD_KQEBD2IQEAX@Z"
		size = 1958
		refs = "001c __security_cookie 0034 ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@ 0042 strcpy_s 0054 ??_C@_02PHMGELLB@?6?6?$AA@ 005f strcat_s 006e ??_C@_09KLGCKDOD@Program?3?5?$AA@ 0096 memset 00ae __imp_GetModuleHandleExW 00cb __imp_GetModuleFileNameA 00d6 ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 0125 _errno 0141 ??_C@_03KHICJKCI@?4?4?4?$AA@ 016a ??_C@_01EEMJAFIK@?6?$AA@ 0184 ??_C@_06IGPBOHMJ@File?3?5?$AA@ 0211 strncat_s 0375 ??_C@_06FIEBOLOH@Line?3?5?$AA@ 03bb _itoa_s 03e7 ??_C@_0N@MEECIJGN@Expression?3?5?$AA@ 0482 ??_C@_0HA@OJHAGA@For?5information?5on?5how?5your?5prog@ 04b2 ??_C@_0DN@EBBNMLME@?$CIPress?5Retry?5to?5debug?5the?5applic@ 04d1 __security_check_cookie 04f9 _invoke_watson 0526 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 98 48 81 EC 68 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 50 4C 8B B5 D8 00 00 00 4D 8B E8 4C 8D 05 ?? ?? ?? ?? 49 8B F1 48 8B FA 48 8B D9 E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 85 40 07 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 11 07 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 E2 06 00 00 41 BF 05 01 00 00 48 8D 4C 24 40 45 8B C7 33 D2 E8 ?? ?? ?? ?? 4C 8D 44 24 30 4C 89 64 24 30 49 8B D6 41 8D 4C 24 06 FF 15 ?? ?? ?? ?? 45 8B C7 48 8D 54 24 40 F7 D8 48 1B C9 48 23 4C 24 30 48 89 4C 24 30 FF 15 ?? ?? ?? ?? 85 C0 75 1C 4C 8D 05 ?? ?? ?? ?? 41 8B D7 48 8D 4C 24 40 E8 ?? ?? ?? ?? 85 C0 0F 85 FA 03 00 00 49 83 CE FF 48 8D 4C 24 40 49 8B D6 48 8D 44 24 40 48 FF C2 44 38 24 10 75 F7 48 8D 42 0B 48 83 F8 40 76 3E 48 8D 4C 14 0B 4C 8D 45 45 4C 2B C1 48 85 C9 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 F1 03 00 00 49 83 F8 03 0F 82 D5 03 00 00 0F B7 05 ?? ?? ?? ?? 66 89 01 8A 05 ?? ?? ?? ?? 88 41 02 4C 8B C1 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 EB 05 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 BC 05 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 8D 05 00 00 49 8B C6 48 FF C0 44 38 24 06 75 F7 48 83 C0 08 48 83 F8 40 0F 86 8D 01 00 00 4D 8B FE 49 FF C7 46 38 24 3E 75 F7 42 8A 44 3E FF 41 BC 01 00 00 00 3C 5C 74 1C 48 8D 4E FF 49 03 CF 3C 2F 74 11 4D 3B E7 73 0C 48 FF C9 49 FF C4 8A 01 3C 5C 75 EB 49 8B C7 49 2B C4 48 83 F8 26 76 65 49 83 FC 12 73 5B 41 B9 35 00 00 00 4C 8B C6 4D 2B CC 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 38 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 08 03 00 00 49 2B F4 48 8B D7 48 8B CB 4D 8D 04 37 E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 84 04 01 00 00 E9 A5 02 00 00 48 83 F8 26 4C 8B C6 48 8B D7 48 8B CB 73 55 49 D1 EC 41 B9 35 00 00 00 4D 2B CC E8 ?? ?? ?? ?? 85 C0 0F 85 15 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 E5 02 00 00 49 2B F4 48 8B D7 48 8B CB 4D 8D 04 37 E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 84 A0 00 00 00 E9 AE 02 00 00 41 B9 23 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 31 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 01 03 00 00 4C 8B C6 44 8D 48 08 4D 2B C4 48 8B D7 4D 03 C7 48 8B CB E8 ?? ?? ?? ?? 45 33 E4 85 C0 0F 85 C9 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 9A 02 00 00 4C 8D 46 F9 48 8B D7 4D 03 C7 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 1B E9 6A 02 00 00 4C 8B C6 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 BB 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 8C 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 5D 03 00 00 49 8B C6 48 FF C0 44 38 24 03 75 F7 49 8B CE 48 FF C1 44 38 24 0B 75 F7 48 8D 14 0B 4C 8B C7 8B 8D D0 00 00 00 4C 2B C0 41 B9 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 0D 03 00 00 48 8D 35 ?? ?? ?? ?? 48 8B D7 4C 8B C6 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 DB 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 AC 02 00 00 49 8B C6 48 FF C0 44 38 24 03 75 F7 48 05 B0 00 00 00 49 FF C6 47 38 24 2E 75 F7 4C 03 F0 4D 8B C5 48 8B D7 48 8B CB 4C 3B F7 76 32 4C 8B CF 4C 2B C8 49 83 E9 03 E8 ?? ?? ?? ?? 85 C0 0F 85 EB 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 12 E9 BB 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 2C 02 00 00 4C 8B C6 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 01 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 D2 01 00 00 4C 8B C6 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 A7 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 78 01 00 00 48 8B 4D 50 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 68 01 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_8_0 {
	meta:
		name = "??$common_assert_to_message_box_build_string@_W@@YAXQEA_W_KQEB_W2IQEAX@Z"
		size = 2004
		refs = "001f __security_cookie 0042 ??_C@_1CE@OJBNHDMO@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CB?$AA?$AA@ 004d wcscpy_s 005f ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@ 006a wcscat_s 0079 ??_C@_1BE@PHKBBGE@?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@ 009e memset 00b5 __imp_GetModuleHandleExW 00d7 __imp_GetModuleFileNameW 00e2 ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 013e _errno 0159 ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@ 0183 ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@ 019d ??_C@_1O@HEMHKNDC@?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 0237 wcsncat_s 039b ??_C@_1O@KCAFKHJE@?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@ 03e3 _itow_s 040f ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@ 04ac ??_C@_1OA@EGMLFBHJ@?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr?$AAo?$AAg@ 04dc ??_C@_1HK@POCJMFGK@?$AA?$CI?$AAP?$AAr?$AAe?$AAs?$AAs?$AA?5?$AAR?$AAe?$AAt?$AAr?$AAy?$AA?5?$AAt?$AAo?$AA?5?$AAd?$AAe?$AAb?$AAu?$AAg?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAa?$AAp?$AAp?$AAl?$AAi?$AAc@ 04fe __security_check_cookie 0526 _invoke_watson 0556 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 98 FE FF FF 48 81 EC 68 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 50 01 00 00 48 8B B5 D8 01 00 00 4D 8B F8 4C 89 44 24 38 4D 8B E1 4C 8D 05 ?? ?? ?? ?? 48 8B FA 48 8B D9 E8 ?? ?? ?? ?? 45 33 ED 85 C0 0F 85 63 07 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 34 07 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 05 07 00 00 33 D2 48 8D 4C 24 40 41 B8 0A 02 00 00 E8 ?? ?? ?? ?? 4C 8D 44 24 30 4C 89 6C 24 30 48 8B D6 41 8D 4D 06 FF 15 ?? ?? ?? ?? BE 05 01 00 00 48 8D 54 24 40 F7 D8 44 8B C6 48 1B C9 48 23 4C 24 30 48 89 4C 24 30 FF 15 ?? ?? ?? ?? 85 C0 75 1B 4C 8D 05 ?? ?? ?? ?? 8B D6 48 8D 4C 24 40 E8 ?? ?? ?? ?? 85 C0 0F 85 1C 04 00 00 49 83 CE FF 48 8D 4C 24 40 49 8B D6 48 8D 44 24 40 48 FF C2 66 44 39 2C 50 75 F6 48 8D 42 0B 48 83 F8 40 76 4B 48 8D 4C 54 D6 48 8B C1 48 8D 54 24 40 48 2B C2 48 D1 F8 48 2B F0 48 03 F6 48 85 C9 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 08 04 00 00 48 83 FE 06 0F 82 E9 03 00 00 8B 05 ?? ?? ?? ?? 89 01 0F B7 05 ?? ?? ?? ?? 66 89 41 04 4C 8B C1 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 00 06 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 D1 05 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 A2 05 00 00 49 8B C6 48 FF C0 66 45 39 2C 44 75 F6 48 83 C0 08 48 83 F8 40 0F 86 93 01 00 00 49 8B F6 48 FF C6 66 45 39 2C 74 75 F6 41 0F B7 44 74 FE 41 BF 01 00 00 00 66 83 F8 5C 74 24 49 8D 4C 24 FE 48 8D 0C 71 66 83 F8 2F 74 15 4C 3B FE 73 10 48 83 E9 02 49 FF C7 0F B7 01 66 83 F8 5C 75 E5 4C 8B EE 4D 2B EF 49 83 FD 26 76 62 49 83 FF 12 73 58 41 B9 35 00 00 00 4D 8B C4 4D 2B CF 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 42 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 12 03 00 00 4F 8D 04 6C 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 45 33 ED 85 C0 0F 84 02 01 00 00 E9 AF 02 00 00 49 83 FD 26 4D 8B C4 48 8B D7 48 8B CB 73 55 49 D1 EF 41 B9 35 00 00 00 4D 2B CF E8 ?? ?? ?? ?? 45 33 ED 85 C0 0F 85 1E 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 EF 02 00 00 49 2B F7 48 8B D7 48 8B CB 4D 8D 04 74 E8 ?? ?? ?? ?? 85 C0 0F 84 9E 00 00 00 E9 BB 02 00 00 41 B9 23 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 3C 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 0C 03 00 00 4F 8D 04 6C 48 8B D7 44 8D 48 08 48 8B CB E8 ?? ?? ?? ?? 45 33 ED 85 C0 0F 85 D9 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 AA 02 00 00 4D 8D 44 24 F2 48 8B D7 4D 8D 04 70 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 1C E9 78 02 00 00 4D 8B C4 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 0A E9 CC 02 00 00 4C 8B 7C 24 38 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 A9 03 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 7A 03 00 00 49 8B C6 48 FF C0 66 44 39 2C 43 75 F6 49 8B CE 48 FF C1 66 44 39 2C 4B 75 F6 48 8D 14 4B 4C 8B C7 8B 8D D0 01 00 00 4C 2B C0 41 B9 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 28 03 00 00 48 8D 35 ?? ?? ?? ?? 48 8B D7 4C 8B C6 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 F6 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 C7 02 00 00 49 8B C6 48 FF C0 66 44 39 2C 43 75 F6 48 05 B0 00 00 00 49 FF C6 66 47 39 2C 77 75 F6 4C 03 F0 4D 8B C7 48 8B D7 48 8B CB 4C 3B F7 76 32 4C 8B CF 4C 2B C8 49 83 E9 03 E8 ?? ?? ?? ?? 85 C0 0F 85 04 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 12 E9 D4 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 45 02 00 00 4C 8B C6 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 1A 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 EB 01 00 00 4C 8B C6 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 C0 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 91 01 00 00 48 8B 8D 50 01 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 68 02 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 4C 8B C6 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_9_0 {
	meta:
		name = "??$common_assert_to_stderr@D@@YAXQEBD0I@Z"
		size = 153
		refs = "0019 __acrt_iob_func 003f setvbuf 0046 ?get_assert_format@@YAPEBDD@Z 007d ??$ftprintf@PEAU_iobuf@@PEBDAEBQEBDAEBQEBDAEBI@?$__crt_char_traits@D@@SAH$$QEAPEAU_iobuf@@$$QEAPEBDAEBQEBD2AEBI@Z 008f fflush 0094 abort"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 B9 02 00 00 00 E8 ?? ?? ?? ?? 8B 48 14 F7 C1 C0 04 00 00 75 1B B9 02 00 00 00 E8 ?? ?? ?? ?? 45 33 C9 48 8B C8 33 D2 45 8D 41 04 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? B9 02 00 00 00 48 89 44 24 68 E8 ?? ?? ?? ?? 48 89 44 24 30 4C 8D 4C 24 58 48 8D 44 24 60 4C 8D 44 24 50 48 89 44 24 20 48 8D 54 24 68 48 8D 4C 24 30 E8 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_10_0 {
	meta:
		name = "??$common_assert_to_stderr@_W@@YAXQEB_W0I@Z"
		size = 335
		refs = "0019 __security_cookie 0046 __imp_GetStdHandle 005c __imp_GetFileType 006d ??_C@_1FE@LHBLIKM@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0@ 0084 swprintf 00bb __imp_WriteConsoleW 00c4 abort 00cf __acrt_iob_func 00f5 setvbuf 00fc ?get_assert_format@@YAPEB_W_W@Z 0133 ??$ftprintf@PEAU_iobuf@@PEB_WAEBQEB_WAEBQEB_WAEBI@?$__crt_char_traits@_W@@SAH$$QEAPEAU_iobuf@@$$QEAPEB_WAEBQEB_W2AEBI@Z 0145 fflush"
	strings:
		$1 = { 40 55 53 56 57 41 56 48 8D AC 24 10 FC FF FF 48 81 EC F0 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 E0 03 00 00 48 8B F9 48 89 4C 24 48 B9 F4 FF FF FF 48 89 54 24 40 45 8B F0 44 89 44 24 38 48 8B F2 FF 15 ?? ?? ?? ?? 48 8B D8 48 8D 48 FF 48 83 F9 FD 77 72 48 8B C8 FF 15 ?? ?? ?? ?? 83 F8 02 75 64 44 89 74 24 28 4C 8D 05 ?? ?? ?? ?? 4C 8B CF 48 89 74 24 20 BA 40 02 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 33 FF 85 C0 78 3B 48 8D 4C 24 60 48 83 C8 FF 48 FF C0 66 39 3C 41 75 F7 4C 8D 4C 24 30 89 7C 24 30 44 8B C0 48 89 7C 24 20 48 8D 54 24 60 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 74 06 E8 ?? ?? ?? ?? CC B9 02 00 00 00 E8 ?? ?? ?? ?? 8B 48 14 F7 C1 C0 04 00 00 75 1B B9 02 00 00 00 E8 ?? ?? ?? ?? 45 33 C9 48 8B C8 33 D2 45 8D 41 04 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? B9 02 00 00 00 48 89 44 24 50 E8 ?? ?? ?? ?? 48 89 44 24 58 4C 8D 4C 24 40 48 8D 44 24 38 4C 8D 44 24 48 48 89 44 24 20 48 8D 54 24 50 48 8D 4C 24 58 E8 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_11_0 {
	meta:
		name = "??$ftprintf@PEAU_iobuf@@PEBDAEBQEBDAEBQEBDAEBI@?$__crt_char_traits@D@@SAH$$QEAPEAU_iobuf@@$$QEAPEBDAEBQEBD2AEBI@Z"
		size = 30
		refs = "001a fprintf"
	strings:
		$1 = { 48 8B 44 24 28 4D 8B 09 4D 8B 00 48 8B 12 44 8B 10 48 8B 09 44 89 54 24 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_12_0 {
	meta:
		name = "??$ftprintf@PEAU_iobuf@@PEB_WAEBQEB_WAEBQEB_WAEBI@?$__crt_char_traits@_W@@SAH$$QEAPEAU_iobuf@@$$QEAPEB_WAEBQEB_W2AEBI@Z"
		size = 30
		refs = "001a fwprintf"
	strings:
		$1 = { 48 8B 44 24 28 4D 8B 09 4D 8B 00 48 8B 12 44 8B 10 48 8B 09 44 89 54 24 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_15_0 {
	meta:
		name = "??$itot_s@AEBIPEAD_KH@?$__crt_char_traits@D@@SAHAEBI$$QEAPEAD$$QEA_K$$QEAH@Z"
		size = 16
		refs = "000c _itoa_s"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_16_0 {
	meta:
		name = "??$itot_s@AEBIPEA_W_KH@?$__crt_char_traits@_W@@SAHAEBI$$QEAPEA_W$$QEA_K$$QEAH@Z"
		size = 16
		refs = "000c _itow_s"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_517_36_0 {
	meta:
		name = "??$ultot_s@AEAIAEBQEADAEB_KH@?$__crt_char_traits@D@@SAHAEAIAEBQEADAEB_K$$QEAH@Z"
		size = 16
		refs = "000c _ultoa_s"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_517_37_0 {
	meta:
		name = "??$ultot_s@AEAIAEBQEA_WAEB_KH@?$__crt_char_traits@_W@@SAHAEAIAEBQEA_WAEB_K$$QEAH@Z"
		size = 16
		refs = "000c _ultow_s"
	strings:
		$1 = { 45 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_35_0 {
	meta:
		name = "??$tcsncat_s@AEBQEADAEB_KAEAPEBD_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEAPEBD$$QEA_K@Z"
		size = 17
		refs = "000d strncat_s"
		altNames = "??$tcsncat_s@AEAPEADAEB_KAEBQEBD_K@?$__crt_char_traits@D@@SAHAEAPEADAEB_KAEBQEBD$$QEA_K@Z ??$tcsncat_s@AEBQEADAEB_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEBQEBD1@Z ??$tcsncat_s@AEBQEADAEB_KPEBD_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEBD$$QEA_K@Z"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_568_12_2 {
	meta:
		name = "??$pack_command_line_and_environment@AEBQEBQEBDAEBQEBQEBDPEAPEADPEAPEAD@?$__crt_char_traits@D@@SAHAEBQEBQEBD0$$QEAPEAPEAD1@Z"
		size = 17
		refs = "000d __acrt_pack_narrow_command_line_and_environment"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_568_13_4 {
	meta:
		name = "??$pack_command_line_and_environment@AEBQEBQEB_WAEBQEBQEB_WPEAPEA_WPEAPEA_W@?$__crt_char_traits@_W@@SAHAEBQEBQEB_W0$$QEAPEAPEA_W1@Z"
		size = 17
		refs = "000d __acrt_pack_wide_command_line_and_environment"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_266_21_0 {
	meta:
		name = "??$tcsncat_s@AEAPEA_WAEB_KAEBQEB_W_K@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_KAEBQEB_W$$QEA_K@Z"
		size = 17
		refs = "000d wcsncat_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_38_4 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KAEAPEB_W_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEAPEB_W$$QEA_K@Z"
		size = 17
		refs = "000d wcsncat_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_39_3 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEBQEB_W1@Z"
		size = 17
		refs = "000d wcsncat_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_40_4 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KPEB_W_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEB_W$$QEA_K@Z"
		size = 17
		refs = "000d wcsncat_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_641_21_2 {
	meta:
		name = "??$tcsncpy_s@AEAPEAD_KAEAPEADAEB_K@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_K0AEB_K@Z"
		size = 17
		refs = "000d strncpy_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_647_12_2 {
	meta:
		name = "??$tcsncpy_s@AEAPEAD_KAEAPEBDAEB_K@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_KAEAPEBDAEB_K@Z"
		size = 17
		refs = "000d strncpy_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_641_22_4 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEA_WAEB_K@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_K0AEB_K@Z"
		size = 17
		refs = "000d wcsncpy_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_647_14_4 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEB_WAEB_K@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_KAEAPEB_WAEB_K@Z"
		size = 17
		refs = "000d wcsncpy_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_641_23_2 {
	meta:
		name = "??$tcsncpy_s@PEADAEB_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEBQEBD1@Z"
		size = 17
		refs = "000d strncpy_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_641_24_0 {
	meta:
		name = "??$tcsncpy_s@PEAD_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAH$$QEAPEAD$$QEA_KAEBQEBDAEB_K@Z"
		size = 17
		refs = "000d strncpy_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_641_25_0 {
	meta:
		name = "??$tcsncpy_s@PEA_WAEB_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEBQEB_W1@Z"
		size = 17
		refs = "000d wcsncpy_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_641_26_0 {
	meta:
		name = "??$tcsncpy_s@PEA_W_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAH$$QEAPEA_W$$QEA_KAEBQEB_WAEB_K@Z"
		size = 17
		refs = "000d wcsncpy_s"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_44_0 {
	meta:
		name = "?common_assert_to_stderr_direct@@YAXQEB_W0I@Z"
		size = 214
		refs = "0012 __security_cookie 0031 __imp_GetStdHandle 0047 __imp_GetFileType 0057 ??_C@_1FE@LHBLIKM@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0@ 006e swprintf 00a5 __imp_WriteConsoleW 00b9 __security_check_cookie 00d1 abort"
	strings:
		$1 = { 48 89 5C 24 20 55 56 57 48 81 EC D0 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 C0 04 00 00 48 8B F9 41 8B E8 B9 F4 FF FF FF 48 8B F2 FF 15 ?? ?? ?? ?? 48 8B D8 48 8D 48 FF 48 83 F9 FD 77 6B 48 8B C8 FF 15 ?? ?? ?? ?? 83 F8 02 75 5D 89 6C 24 28 4C 8D 05 ?? ?? ?? ?? 4C 8B CF 48 89 74 24 20 BA 40 02 00 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 33 FF 85 C0 78 35 48 8D 4C 24 40 48 83 C8 FF 48 FF C0 66 39 3C 41 75 F7 4C 8D 4C 24 30 89 7C 24 30 44 8B C0 48 89 7C 24 20 48 8D 54 24 40 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 75 23 48 8B 8C 24 C0 04 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 08 05 00 00 48 81 C4 D0 04 00 00 5F 5E 5D C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_72_0 {
	meta:
		name = "?has_any_buffer@__crt_stdio_stream@@QEBA_NXZ"
		size = 16
	strings:
		$1 = { 48 8B 01 8B 48 14 F7 C1 C0 04 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule file_90_75_0 {
	meta:
		name = "_assert"
		size = 130
		refs = "0028 _set_error_mode 0036 _query_app_type 0060 ??$common_assert_to_message_box@D@@YAXQEBD0IQEAX@Z 006e ??$common_assert_to_stderr@D@@YAXQEBD0I@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 6C 24 28 48 8B F1 B9 03 00 00 00 41 8B D8 48 8B FA E8 ?? ?? ?? ?? 83 F8 01 74 33 85 C0 75 0A E8 ?? ?? ?? ?? 83 F8 01 74 34 4C 8B CD 44 8B C3 48 8B D7 48 8B CE 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? 44 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? CC 44 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_80_0 {
	meta:
		name = "_wassert"
		size = 130
		refs = "0028 _set_error_mode 0036 _query_app_type 0060 ??$common_assert_to_message_box@_W@@YAXQEB_W0IQEAX@Z 006e ??$common_assert_to_stderr@_W@@YAXQEB_W0I@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 6C 24 28 48 8B F1 B9 03 00 00 00 41 8B D8 48 8B FA E8 ?? ?? ?? ?? 83 F8 01 74 33 85 C0 75 0A E8 ?? ?? ?? ?? 83 F8 01 74 34 4C 8B CD 44 8B C3 48 8B D7 48 8B CE 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? 44 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? CC 44 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_90_77_0 {
	meta:
		name = "_vfprintf_l"
		size = 80
		refs = "0021 __local_stdio_printf_options 0037 __stdio_common_vfprintf"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 49 8B D9 49 8B F8 48 8B F2 48 8B E9 E8 ?? ?? ?? ?? 4C 8B CF 48 89 5C 24 20 4C 8B C6 48 8B D5 48 8B 08 E8 ?? ?? ?? ?? 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_90_78_0 {
	meta:
		name = "_vfwprintf_l"
		size = 80
		refs = "0021 __local_stdio_printf_options 0037 __stdio_common_vfwprintf"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 49 8B D9 49 8B F8 48 8B F2 48 8B E9 E8 ?? ?? ?? ?? 4C 8B CF 48 89 5C 24 20 4C 8B C6 48 8B D5 48 8B 08 E8 ?? ?? ?? ?? 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_90_79_0 {
	meta:
		name = "_vswprintf_c_l"
		size = 98
		refs = "0021 __local_stdio_printf_options 0041 __stdio_common_vswprintf"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 49 8B D9 49 8B F8 48 8B F2 48 8B E9 E8 ?? ?? ?? ?? 4C 8B 54 24 60 4C 8B CF 4C 89 54 24 28 4C 8B C6 48 8B D5 48 89 5C 24 20 48 8B 08 E8 ?? ?? ?? ?? 48 8B 5C 24 40 83 C9 FF 48 8B 6C 24 48 85 C0 48 8B 74 24 50 0F 48 C1 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_90_81_0 {
	meta:
		name = "fprintf"
		size = 67
		refs = "0021 __local_stdio_printf_options 0037 __stdio_common_vfprintf"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 53 56 57 48 83 EC 30 48 8B FA 48 8D 70 18 48 8B D9 E8 ?? ?? ?? ?? 45 33 C9 48 89 74 24 20 4C 8B C7 48 8B D3 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 30 5F 5E 5B C3 }
	condition:
		$1
}

rule file_90_82_0 {
	meta:
		name = "fwprintf"
		size = 67
		refs = "0021 __local_stdio_printf_options 0037 __stdio_common_vfwprintf"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 53 56 57 48 83 EC 30 48 8B FA 48 8D 70 18 48 8B D9 E8 ?? ?? ?? ?? 45 33 C9 48 89 74 24 20 4C 8B C7 48 8B D3 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 30 5F 5E 5B C3 }
	condition:
		$1
}

rule file_90_84_0 {
	meta:
		name = "swprintf"
		size = 82
		refs = "0021 __local_stdio_printf_options 003d __stdio_common_vswprintf"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 53 55 56 57 48 83 EC 38 49 8B F0 48 8D 6C 24 78 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 89 6C 24 28 4C 8B CE 48 83 64 24 20 00 4C 8B C3 48 8B D7 48 8B 08 E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "fminf"
		size = 108
		refs = "0016 _fdtest"
	strings:
		$1 = { F3 0F 11 4C 24 10 F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F3 0F 10 44 24 38 EB 3F 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F3 0F 10 44 24 30 EB 27 F3 0F 10 44 24 38 F3 0F 10 4C 24 30 0F 2F C1 77 13 0F 2E C8 7A 11 75 0F B8 00 80 00 00 66 85 44 24 32 74 03 0F 28 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "_ldclass"
		size = 25
		refs = "0010 _ldtest"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_dclass"
		size = 25
		refs = "0010 _dtest"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "_ldpcomp"
		size = 99
		refs = "0017 _ldtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? BB 02 00 00 00 66 3B C3 74 36 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 3B C3 74 27 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 76 05 8D 43 FF EB 12 B8 04 00 00 00 66 0F 2F C8 0F 47 D8 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_265_1_0 {
	meta:
		name = "_dpcomp"
		size = 99
		refs = "0017 _dtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? BB 02 00 00 00 66 3B C3 74 36 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 3B C3 74 27 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 76 05 8D 43 FF EB 12 B8 04 00 00 00 66 0F 2F C8 0F 47 D8 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "_ldsign"
		size = 21
		altNames = "_dsign"
	strings:
		$1 = { F2 0F 11 44 24 08 48 8B 44 24 08 48 C1 E8 30 25 00 80 00 00 C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "_fdlog"
		size = 401
		refs = "0018 _fdunscale 0057 _fperrraise 005f _FNan_C 006c __real@3f3504f3 008f __real@3f800000 00b7 __real@3e990215 00bf __real@3eccae11 00cb __real@3f2aaac0 00e9 __real@3f317216 00f1 __real@33fbe8e8 0108 __real@32a93728 0113 __real@33a13ef4 011b __real@3ede5bd9 0123 __real@3e9a2098 0132 __real@3ede5bd8 0147 __real@3fb8aa3b 0152 __real@32a57060 0180 _FInf_C 0187 __xmm@80000000800000008000000080000000"
	strings:
		$1 = { F3 0F 11 44 24 08 53 48 83 EC 20 8B DA 48 8D 4C 24 40 48 8D 54 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 4B 01 00 00 B8 00 80 00 00 83 E9 01 74 10 83 F9 01 75 14 F3 0F 10 44 24 30 E9 4A 01 00 00 66 85 44 24 32 75 09 EB EC 66 85 44 24 32 74 17 B9 01 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? E9 23 01 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 10 4C 24 30 0F 2F C1 0F B7 44 24 40 76 07 F3 0F 58 C9 66 FF C8 98 0F 28 D9 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 1D ?? ?? ?? ?? 66 0F 6E E8 0F 5B ED 0F 28 E3 F3 0F 5E E1 0F 28 C4 F3 0F 59 C4 0F 28 C8 F3 0F 59 0D ?? ?? ?? ?? F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 C8 F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 C8 0F 28 C3 F3 0F 5C C1 F3 0F 59 E0 85 DB 75 1D 0F 28 C5 F3 0F 59 2D ?? ?? ?? ?? F3 0F 59 05 ?? ?? ?? ?? F3 0F 5C E0 F3 0F 5C DC EB 6A 0F 28 CB 7E 3F F3 0F 59 0D ?? ?? ?? ?? 0F 28 C5 F3 0F 59 05 ?? ?? ?? ?? F3 0F 59 25 ?? ?? ?? ?? F3 0F 59 2D ?? ?? ?? ?? F3 0F 5C E0 0F 28 C3 F3 0F 59 05 ?? ?? ?? ?? F3 0F 5C CC 0F 28 D9 F3 0F 58 D8 EB 26 F3 0F 59 25 ?? ?? ?? ?? 0F 28 D3 F3 0F 59 15 ?? ?? ?? ?? F3 0F 59 0D ?? ?? ?? ?? F3 0F 5C D4 0F 28 DA F3 0F 58 D9 F3 0F 58 DD 0F 28 C3 EB 19 B9 04 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "_fdlogpoly"
		size = 35
		refs = "0007 __real@3e990215 000f __real@3eccae11 001b __real@3f2aaac0"
	strings:
		$1 = { 0F 28 C8 F3 0F 59 0D ?? ?? ?? ?? F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 C8 F3 0F 58 0D ?? ?? ?? ?? 0F 28 C1 C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "__acrt_CompareStringW"
		size = 189
		refs = "0030 wcsnlen 0085 __acrt_CompareStringEx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 50 49 63 D9 49 8B F0 8B EA 4C 8B F1 45 85 C9 7E 0E 48 8B D3 49 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 63 84 24 88 00 00 00 48 8B BC 24 80 00 00 00 85 C0 7E 0B 48 8B D0 48 8B CF E8 ?? ?? ?? ?? 85 DB 74 31 85 C0 74 2D 48 83 64 24 40 00 44 8B CB 48 83 64 24 38 00 4C 8B C6 48 83 64 24 30 00 8B D5 89 44 24 28 49 8B CE 48 89 7C 24 20 E8 ?? ?? ?? ?? EB 17 2B D8 B8 03 00 00 00 8D 48 FE 0F 48 C1 85 DB B9 02 00 00 00 0F 44 C1 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 8B 7C 24 78 48 83 C4 50 41 5E C3 }
	condition:
		$1
}

rule file_95_10_0 {
	meta:
		name = "?__crt_get_2digit_year@@YAHH@Z"
		size = 35
	strings:
		$1 = { 44 8D 81 6C 07 00 00 B8 1F 85 EB 51 41 F7 E8 C1 FA 05 8B CA C1 E9 1F 03 D1 6B CA 64 44 2B C1 41 8B C0 C3 }
	condition:
		$1
}

rule file_95_11_0 {
	meta:
		name = "?__crt_get_century@@YAHH@Z"
		size = 24
	strings:
		$1 = { 81 C1 6C 07 00 00 B8 1F 85 EB 51 F7 E9 C1 FA 05 8B C2 C1 E8 1F 03 C2 C3 }
	condition:
		$1
}

rule file_95_12_0 {
	meta:
		name = "?compute_iso_week@@YAHHHH@Z"
		size = 100
		refs = "0017 ?compute_iso_week_internal@@YAHHHH@Z 0026 ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 41 8B F0 8B FA 8B D9 E8 ?? ?? ?? ?? 44 8B C8 85 C0 75 26 8D 4B FF E8 ?? ?? ?? ?? F6 D8 8D 4B FF 45 1B C0 2B FE 41 F7 D8 41 81 C0 6D 01 00 00 8D 57 07 E8 ?? ?? ?? ?? EB 0C 45 85 C9 B8 01 00 00 00 41 0F 4F C1 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_95_13_0 {
	meta:
		name = "?compute_iso_week_internal@@YAHHHH@Z"
		size = 242
		refs = "0057 ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 44 8D 4A 06 8B F2 44 8B D1 B8 93 24 49 92 41 F7 E9 41 8B C8 41 8B D8 41 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 44 2B C8 B8 93 24 49 92 41 2B C9 83 C1 07 F7 E9 8D 3C 11 41 8B CA C1 FF 02 8B C7 C1 E8 1F 03 F8 E8 ?? ?? ?? ?? 44 0F B6 C0 2B F3 81 C6 73 01 00 00 B8 93 24 49 92 F7 EE B8 93 24 49 92 44 8B CB 03 D6 45 2B C8 C1 FA 02 8B CA C1 E9 1F 03 D1 6B CA 07 2B F1 41 8D 88 6D 01 00 00 03 CE F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 41 81 F9 6C 01 00 00 7C 05 83 F9 02 74 1C 41 81 F9 6B 01 00 00 7C 05 83 F9 03 74 0E 41 81 F9 6A 01 00 00 7C 0A 83 F9 04 75 05 83 C8 FF EB 0D 8D 4E FE 8B C7 83 F9 02 77 03 8D 47 01 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_95_14_0 {
	meta:
		name = "?compute_iso_year@@YAHHHH@Z"
		size = 35
		refs = "0009 ?compute_iso_week_internal@@YAHHHH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 85 C0 75 05 8D 43 FF EB 07 8B C3 7F 03 8D 43 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_95_15_0 {
	meta:
		name = "?compute_week_of_year@@YAHHHH@Z"
		size = 68
	strings:
		$1 = { 44 8B CA 41 BA 93 24 49 92 44 2B C9 41 8B C2 41 83 C1 07 41 F7 E9 41 8B C2 41 03 D1 C1 FA 02 8B CA C1 E9 1F 03 D1 6B CA 07 44 2B C9 45 2B C1 41 83 C0 07 41 F7 E8 41 03 D0 C1 FA 02 8B C2 C1 E8 1F 03 C2 C3 }
	condition:
		$1
}

rule file_95_17_0 {
	meta:
		name = "?expand_time@@YA_NPEAU__crt_locale_pointers@@_WPEBUtm@@PEAPEA_WPEA_KPEBU__crt_lc_time_data@@_N@Z"
		size = 3999
		refs = "0107 ?compute_iso_week_internal@@YAHHHH@Z 018e __lc_time_c 01c2 ?expand_time@@YA_NPEAU__crt_locale_pointers@@_WPEBUtm@@PEAPEA_WPEA_KPEBU__crt_lc_time_data@@_N@Z 01cb _errno 01e1 ??_C@_13HOIJIPNN@?$AA?5?$AA?$AA@ 036c ?store_winword@@YA_NQEAU__crt_locale_pointers@@HQEBUtm@@QEAPEA_WQEA_KQEBU__crt_lc_time_data@@@Z 0426 _invalid_parameter_noinfo 0481 ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@ 04f6 __tzset 0504 _get_timezone 051d _get_dstbias 0567 ??_C@_13IMODFHAA@?$AA?9?$AA?$AA@ 0589 ??_C@_13KJIIAINM@?$AA?$CL?$AA?$AA@ 05d1 ?store_number@@YAXHHQEAPEA_WQEA_K_W@Z 068d ??_C@_13KDLDGPGJ@?$AA?7?$AA?$AA@ 070e ??_C@_13EBCNDICG@?$AA?3?$AA?$AA@ 0a72 ??_C@_13CGOKJPIL@?$AA?1?$AA?$AA@ 0c0d ??_C@_13EJFHHPOP@?$AA?$CF?$AA?$AA@ 0d10 ??$__crt_time_is_leap_year@H@@YA_NH@Z 0f19 __tzname 0f47 _mbstowcs_s_l 0f9a _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 48 89 4C 24 08 55 56 57 48 8B EC 48 83 EC 50 49 8B F0 49 8B F9 44 0F B7 C2 41 8B D0 41 83 F8 5A 0F 8E 55 08 00 00 41 B9 62 00 00 00 83 FA 6E 0F 8F 73 04 00 00 0F 84 3A 04 00 00 83 EA 61 0F 84 CB 03 00 00 83 EA 01 0F 84 7C 03 00 00 83 EA 01 0F 84 2C 01 00 00 83 EA 01 0F 84 FB 00 00 00 83 EA 01 0F 84 D5 00 00 00 83 EA 02 74 72 83 EA 01 75 08 45 8B C1 41 8B D1 EB B2 83 EA 02 74 2C 83 FA 03 0F 85 9D 03 00 00 8B 56 10 83 FA 0B 0F 87 81 03 00 00 8A 45 50 F6 D8 1A C9 F6 D1 80 E1 30 0F BE C1 8D 4A 01 E9 CD 00 00 00 8B 56 1C 81 FA 6D 01 00 00 0F 87 5B 03 00 00 8A 45 50 4C 8B 4D 40 F6 D8 1A C9 F6 D1 80 E1 30 0F BE C1 8D 4A 01 66 89 44 24 20 BA 03 00 00 00 E9 73 0A 00 00 8B 46 14 89 45 28 05 6C 07 00 00 3D 0F 27 00 00 0F 87 20 03 00 00 44 8B 46 1C 8B 56 18 8B 75 28 8B CE E8 ?? ?? ?? ?? 85 C0 75 04 FF CE EB 04 7F 02 FF C6 8D 8E 6C 07 00 00 B8 1F 85 EB 51 F7 E9 BE 30 00 00 00 C1 FA 05 8B C2 66 89 74 24 20 C1 E8 1F 03 D0 6B C2 64 2B C8 E9 0C 0A 00 00 8B 4E 0C 8D 41 FF 83 F8 1E 0F 87 C9 02 00 00 8A 45 50 F6 D8 1A D2 F6 D2 80 E2 20 EB 1B 8B 4E 0C 8D 41 FF 83 F8 1E 0F 87 AC 02 00 00 8A 45 50 F6 D8 1A D2 F6 D2 80 E2 30 0F BE C2 66 89 44 24 20 E9 C7 09 00 00 48 8B 45 48 4C 8D 0D ?? ?? ?? ?? 33 DB 49 3B C1 0F 85 B2 01 00 00 38 5D 50 0F 85 A9 01 00 00 88 5C 24 30 8D 53 61 48 89 44 24 28 4C 8B CF 48 8B 45 40 4C 8B C6 48 89 44 24 20 E8 ?? ?? ?? ?? 84 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 50 02 00 00 48 8B 4D 40 4C 8D 05 ?? ?? ?? ?? 48 39 19 74 1F 45 0F B7 08 66 45 85 C9 74 15 48 8B 07 49 83 C0 02 66 44 89 08 48 83 07 02 48 83 29 01 75 E1 48 8B 45 48 BA 62 00 00 00 88 5C 24 30 4C 8B CF 48 89 44 24 28 4C 8B C6 48 89 4C 24 20 48 8B 4D 20 E8 ?? ?? ?? ?? 84 C0 74 97 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 48 39 19 74 1F 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 48 8B 45 48 BA 65 00 00 00 88 5C 24 30 4C 8B CF 48 89 44 24 28 4C 8B C6 48 89 4C 24 20 48 8B 4D 20 E8 ?? ?? ?? ?? 84 C0 0F 84 3A FF FF FF 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 48 39 19 74 1F 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 48 8B 45 48 BA 54 00 00 00 88 5C 24 30 4C 8B CF 48 89 44 24 28 4C 8B C6 48 89 4C 24 20 48 8B 4D 20 E8 ?? ?? ?? ?? 84 C0 0F 84 DD FE FF FF 48 8B 4D 40 48 39 19 74 26 48 8D 15 ?? ?? ?? ?? 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 BA 59 00 00 00 88 5C 24 30 48 8B 45 48 48 89 44 24 28 48 89 4C 24 20 48 8B 4D 20 4C 8B CF 4C 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 85 2C 01 00 00 E9 7B FE FF FF 38 5D 50 8B D3 48 89 44 24 28 4C 8B CF 48 8B 45 40 0F 95 C2 4C 8B C6 48 89 44 24 20 E8 ?? ?? ?? ?? 84 C0 0F 84 52 FE FF FF 48 8B 55 40 48 8D 0D ?? ?? ?? ?? 48 39 1A 74 1F 44 0F B7 01 66 45 85 C0 74 15 48 8B 07 48 83 C1 02 66 44 89 00 48 83 07 02 48 83 2A 01 75 E1 48 8B 45 48 48 8B 4D 20 48 89 44 24 28 48 89 54 24 20 BA 02 00 00 00 4C 8B CF 4C 8B C6 E8 ?? ?? ?? ?? E9 74 FF FF FF 83 7E 10 0B 77 46 48 63 4E 10 33 DB 48 8B 45 48 48 8B 94 C8 D0 01 00 00 48 8B 4D 40 48 39 19 0F 84 83 00 00 00 44 0F B7 02 66 45 85 C0 74 79 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 EB 62 83 7E 18 06 76 22 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 48 8B 9C 24 80 00 00 00 48 83 C4 50 5F 5E 5D C3 48 63 4E 18 33 DB 48 8B 45 48 48 8B 94 C8 60 01 00 00 48 8B 4D 40 48 39 19 74 1F 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 B0 01 EB B2 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 33 DB 48 39 19 74 EA 44 0F B7 02 66 45 85 C0 74 E0 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 EB C9 83 EA 70 0F 84 6F 03 00 00 83 EA 02 0F 84 05 02 00 00 83 EA 02 0F 84 BE 01 00 00 83 EA 01 0F 84 77 01 00 00 83 EA 02 0F 84 6E 01 00 00 83 EA 01 0F 84 44 01 00 00 83 EA 01 0F 84 F6 00 00 00 83 FA 01 0F 85 35 FF FF FF E8 ?? ?? ?? ?? 33 DB 48 8D 4D 28 89 5D 28 E8 ?? ?? ?? ?? 85 C0 0F 85 0A FF FF FF 39 5E 20 74 22 48 8D 4D F0 89 5D F0 E8 ?? ?? ?? ?? 85 C0 0F 85 F1 FE FF FF 44 8B 45 28 44 03 45 F0 44 89 45 28 EB 04 44 8B 45 28 41 BA 89 88 88 88 41 8B C0 99 8B C8 41 8B C2 33 CA 2B CA F7 E9 41 8B C2 44 8D 0C 11 41 C1 F9 05 41 8B C9 C1 E9 1F 44 03 C9 48 8D 0D ?? ?? ?? ?? 41 F7 E9 45 8D 14 11 41 C1 FA 05 41 8B C2 C1 E8 1F 44 03 D0 41 6B C2 3C 44 2B C8 48 8D 05 ?? ?? ?? ?? 45 85 C0 44 89 4D F0 4C 8B 4D 40 48 0F 48 C8 49 39 19 74 1C 0F B7 11 66 85 D2 74 14 48 8B 07 48 83 C1 02 66 89 10 48 83 07 02 49 83 29 01 75 E4 BE 30 00 00 00 4C 8B C7 41 8B CA 66 89 74 24 20 8D 56 D2 E8 ?? ?? ?? ?? 8B 4D F0 66 89 74 24 20 E9 70 05 00 00 8B 56 14 8D 82 6C 07 00 00 3D 0F 27 00 00 0F 87 24 FE FF FF 8A 45 50 F6 D8 B8 1F 85 EB 51 1A C9 F6 D1 80 E1 30 44 0F BE C1 8D 8A 6C 07 00 00 F7 E9 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B C2 64 2B C8 E9 21 05 00 00 48 8B 45 48 33 DB 38 5D 50 8B D3 48 89 44 24 28 48 8B 45 40 0F 95 C2 48 89 44 24 20 E9 76 FD FF FF 8B 4E 18 83 F9 06 0F 87 C6 FD FF FF 85 C9 75 0C 66 41 83 F8 75 75 05 B9 07 00 00 00 8A 45 50 4C 8B 4D 40 F6 D8 1A D2 F6 D2 80 E2 30 0F BE C2 BA 01 00 00 00 66 89 44 24 20 E9 D1 04 00 00 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 33 DB 48 39 19 0F 84 DA FD FF FF 44 0F B7 02 66 45 85 C0 0F 84 CC FD FF FF 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 DD E9 B2 FD FF FF 4C 8B 45 48 4C 8D 0D ?? ?? ?? ?? 8A 45 50 4D 3B C1 88 44 24 30 4C 8B CF 4C 89 44 24 28 0F 85 2B 01 00 00 4C 8B 45 40 BA 49 00 00 00 4C 89 44 24 20 4C 8B C6 E8 ?? ?? ?? ?? 33 DB 84 C0 0F 84 C3 FA FF FF 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 48 39 19 74 1F 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 8A 45 50 BA 4D 00 00 00 88 44 24 30 4C 8B CF 48 8B 45 48 4C 8B C6 48 89 44 24 28 48 89 4C 24 20 48 8B 4D 20 E8 ?? ?? ?? ?? 84 C0 0F 84 63 FA FF FF 4C 8B 45 40 49 39 18 74 23 48 8D 0D ?? ?? ?? ?? 0F B7 11 66 85 D2 74 14 48 8B 07 48 83 C1 02 66 89 10 48 83 07 02 49 83 28 01 75 E4 8A 45 50 BA 53 00 00 00 48 8B 4D 20 4C 8B CF 88 44 24 30 48 8B 45 48 48 89 44 24 28 4C 89 44 24 20 4C 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 06 FA FF FF 4C 8B 45 40 48 8D 0D ?? ?? ?? ?? 49 39 18 74 1F 44 0F B7 09 66 45 85 C9 74 15 48 8B 07 48 83 C1 02 66 44 89 08 48 83 07 02 49 83 28 01 75 E1 BA 70 00 00 00 8A 45 50 88 44 24 30 48 8B 45 48 48 89 44 24 28 4C 89 44 24 20 E9 21 FB FF FF 48 8B 45 40 BA 58 00 00 00 48 89 44 24 20 E9 15 FB FF FF 83 7E 08 17 0F 87 EB FB FF FF 83 7E 08 0B 48 8B 45 48 7F 09 48 8B 88 90 02 00 00 EB 07 48 8B 88 98 02 00 00 48 8B 55 40 33 DB 48 39 1A 0F 84 1E FC FF FF 44 0F B7 01 66 45 85 C0 0F 84 10 FC FF FF 48 8B 07 48 83 C1 02 66 44 89 00 48 83 07 02 48 83 2A 01 75 DD E9 F6 FB FF FF 83 FA 5A 0F 84 84 06 00 00 83 FA 4D 0F 8F C3 03 00 00 0F 84 AC 03 00 00 83 EA 25 0F 84 65 03 00 00 83 EA 1C 0F 84 0B 03 00 00 83 EA 01 0F 84 B1 02 00 00 83 EA 01 0F 84 4F 02 00 00 83 EA 01 0F 84 76 01 00 00 83 EA 02 0F 84 A4 00 00 00 83 EA 01 74 4A 83 EA 01 74 3A 83 FA 01 0F 85 49 FB FF FF 8B 4E 08 83 F9 17 0F 87 2D FB FF FF B8 AB AA AA 2A F7 E9 D1 FA 8B C2 C1 E8 1F 03 D0 8D 04 52 C1 E0 02 2B C8 B8 0C 00 00 00 0F 44 C8 E9 5C F8 FF FF 8B 4E 08 83 F9 17 E9 4B F8 FF FF 8B 4E 14 89 4D 28 8D 81 6C 07 00 00 3D 0F 27 00 00 0F 87 E6 FA FF FF 44 8B 46 1C 8B 56 18 8B F1 E8 ?? ?? ?? ?? 85 C0 75 04 FF CE EB 04 7F 05 FF C6 89 75 28 8B 4D 28 BE 30 00 00 00 81 C1 6C 07 00 00 66 89 74 24 20 4C 8B 4D 40 BA 04 00 00 00 E9 E5 01 00 00 8A 45 50 BA 59 00 00 00 88 44 24 30 4C 8B C6 48 8B 45 48 48 89 44 24 28 48 8B 45 40 48 89 44 24 20 E8 ?? ?? ?? ?? 33 DB 84 C0 0F 84 28 F8 FF FF 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 48 39 19 74 1F 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 8A 45 50 BA 6D 00 00 00 88 44 24 30 4C 8B CF 48 8B 45 48 4C 8B C6 48 89 44 24 28 48 89 4C 24 20 48 8B 4D 20 E8 ?? ?? ?? ?? 84 C0 0F 84 C8 F7 FF FF 48 8B 4D 40 48 39 19 74 26 48 8D 15 ?? ?? ?? ?? 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 BA 64 00 00 00 E9 C4 00 00 00 8A 45 50 BA 6D 00 00 00 88 44 24 30 4C 8B C6 48 8B 45 48 48 89 44 24 28 48 8B 45 40 48 89 44 24 20 E8 ?? ?? ?? ?? 33 DB 84 C0 0F 84 5F F7 FF FF 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 48 39 19 74 1F 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 8A 45 50 BA 64 00 00 00 88 44 24 30 4C 8B CF 48 8B 45 48 4C 8B C6 48 89 44 24 28 48 89 4C 24 20 48 8B 4D 20 E8 ?? ?? ?? ?? 84 C0 0F 84 FF F6 FF FF 48 8B 4D 40 48 39 19 74 26 48 8D 15 ?? ?? ?? ?? 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 BA 79 00 00 00 8A 45 50 88 44 24 30 E9 1A F8 FF FF 8B 56 14 8D 82 6C 07 00 00 3D 0F 27 00 00 0F 87 FB F8 FF FF 8A 45 50 F6 D8 B8 1F 85 EB 51 1A C9 F6 D1 80 E1 30 44 0F BE C1 8D 8A 6C 07 00 00 F7 E9 8B CA C1 F9 05 8B C1 C1 E8 1F 03 C8 66 44 89 44 24 20 4C 8B 4D 40 BA 02 00 00 00 4C 8B C7 E8 ?? ?? ?? ?? E9 12 F9 FF FF 83 7E 10 0B 0F 87 AC F8 FF FF 48 63 4E 10 33 DB 48 8B 45 48 48 8B 94 C8 30 02 00 00 48 8B 4D 40 48 39 19 0F 84 E9 F8 FF FF 44 0F B7 02 66 45 85 C0 0F 84 DB F8 FF FF 49 8B 01 48 83 C2 02 66 44 89 00 49 83 01 02 48 83 29 01 75 DD E9 C1 F8 FF FF 83 7E 18 06 0F 87 5B F8 FF FF 48 63 4E 18 33 DB 48 8B 45 48 48 8B 94 C8 98 01 00 00 48 8B 4D 40 48 39 19 0F 84 98 F8 FF FF 44 0F B7 02 66 45 85 C0 0F 84 8A F8 FF FF 49 8B 01 48 83 C2 02 66 44 89 00 49 83 01 02 48 83 29 01 75 DD E9 70 F8 FF FF 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 33 DB 48 39 19 0F 84 5A F8 FF FF 44 0F B7 02 66 45 85 C0 0F 84 4C F8 FF FF 49 8B 01 48 83 C2 02 66 44 89 00 49 83 01 02 48 83 29 01 75 DD E9 32 F8 FF FF 8B 4E 04 83 F9 3B 0F 86 1E F5 FF FF E9 C5 F7 FF FF 83 EA 52 0F 84 49 02 00 00 83 EA 01 0F 84 36 02 00 00 83 EA 01 0F 84 67 01 00 00 83 EA 01 0F 84 E9 00 00 00 83 EA 01 74 66 83 EA 01 0F 84 DB 00 00 00 83 EA 01 74 3C 83 FA 01 0F 85 95 F7 FF FF 8B 56 14 8D 82 6C 07 00 00 3D 0F 27 00 00 0F 87 71 F7 FF FF 8A 45 50 F6 D8 1A C9 F6 D1 80 E1 30 0F BE C1 8D 8A 6C 07 00 00 66 89 44 24 20 E9 9C FC FF FF 48 8B 45 48 BA 02 00 00 00 48 89 44 24 28 48 8B 45 40 48 89 44 24 20 E9 DD F6 FF FF 8B 4E 1C 44 8B C1 8B 46 18 89 45 28 8B 46 14 8B 75 28 8B D6 89 4D F8 8B C8 89 45 F0 E8 ?? ?? ?? ?? 85 C0 75 31 8B 5D F0 8D 4B FF E8 ?? ?? ?? ?? F6 D8 8D 4B FF BA 07 00 00 00 45 1B C0 2B 75 F8 41 F7 D8 03 D6 41 81 C0 6D 01 00 00 E8 ?? ?? ?? ?? 44 8B D0 EB 0C 85 C0 41 BA 01 00 00 00 44 0F 4F D0 8A 45 50 F6 D8 1A C9 F6 D1 80 E1 30 0F BE C1 41 8B CA 66 89 44 24 20 E9 EC FD FF FF 8B 4E 18 83 F9 06 0F 87 AC F6 FF FF 33 DB 66 41 83 F8 57 75 0B 85 C9 75 05 8D 4B 06 EB 02 FF C9 44 8B 46 1C 41 81 F8 6D 01 00 00 0F 87 87 F6 FF FF 44 3B C1 7C 24 B8 93 24 49 92 41 F7 E8 41 03 D0 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 8B DA 44 2B C0 44 3B C1 7C 02 FF C3 8A 45 50 8B CB F6 D8 1A D2 F6 D2 80 E2 30 0F BE C2 66 89 44 24 20 E9 77 FD FF FF 8A 45 50 BA 48 00 00 00 4C 8B 45 40 88 44 24 30 48 8B 45 48 48 89 44 24 28 4C 89 44 24 20 4C 8B C6 E8 ?? ?? ?? ?? 33 DB 84 C0 0F 84 C3 F3 FF FF 48 8B 4D 40 48 8D 15 ?? ?? ?? ?? 48 39 19 74 1F 44 0F B7 02 66 45 85 C0 74 15 48 8B 07 48 83 C2 02 66 44 89 00 48 83 07 02 48 83 29 01 75 E1 8A 45 50 BA 4D 00 00 00 88 44 24 30 4C 8B CF 48 8B 45 48 4C 8B C6 48 89 44 24 28 48 89 4C 24 20 48 8B 4D 20 E8 ?? ?? ?? ?? 84 C0 0F 84 63 F3 FF FF 4C 8B 45 40 49 39 18 74 23 48 8D 0D ?? ?? ?? ?? 0F B7 11 66 85 D2 74 14 48 8B 07 48 83 C1 02 66 89 10 48 83 07 02 49 83 28 01 75 E4 BA 53 00 00 00 E9 5B F9 FF FF 8B 0E 83 F9 3C E9 A3 FD FF FF 8A 45 50 BA 48 00 00 00 88 44 24 30 4C 8B C6 48 8B 45 48 48 89 44 24 28 48 8B 45 40 48 89 44 24 20 E8 ?? ?? ?? ?? 33 DB 84 C0 0F 84 F3 F2 FF FF 4C 8B 45 40 48 8D 0D ?? ?? ?? ?? 49 39 18 74 1C 0F B7 11 66 85 D2 74 14 48 8B 07 48 83 C1 02 66 89 10 48 83 07 02 49 83 28 01 75 E4 BA 4D 00 00 00 E9 EB F8 FF FF E8 ?? ?? ?? ?? 33 DB 48 89 5D F8 E8 ?? ?? ?? ?? 39 5E 20 8B CB 4C 8B 55 20 48 8B 75 40 0F 95 C1 48 8B 17 4C 89 54 24 28 48 83 4C 24 20 FF 4C 8B 0C C8 48 8D 4D F8 4C 8B 06 E8 ?? ?? ?? ?? 83 F8 16 74 3A 83 F8 22 74 35 83 F8 50 75 11 48 8B 06 48 03 C0 48 01 07 48 89 1E E9 0B F5 FF FF 48 8B 4D F8 B8 01 00 00 00 48 2B C1 48 01 06 48 8D 04 4D FE FF FF FF 48 01 07 E9 EC F4 FF FF 45 33 C9 48 89 5C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_95_21_0 {
	meta:
		name = "?store_number@@YAXHHQEAPEA_WQEA_K_W@Z"
		size = 336
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 0F B7 74 24 28 33 ED 4D 8B D0 44 8B C1 66 85 F6 0F 85 96 00 00 00 49 8B 01 4D 8B 1A 48 83 F8 01 76 69 B8 67 66 66 66 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 0F B7 C2 66 C1 E0 02 8D 0C 10 66 03 C9 66 44 2B C1 66 41 83 C0 30 66 45 89 03 49 83 C3 02 49 FF 09 44 8B C2 85 D2 7E 06 49 83 39 01 77 C0 49 8B 12 4D 8D 43 FE 4D 89 1A EB 16 0F B7 02 41 0F B7 08 66 41 89 00 49 83 E8 02 66 89 0A 48 83 C2 02 49 3B D0 72 E5 EB 0C 48 03 C0 4C 2B D8 4D 89 1A 49 89 29 48 8B 5C 24 08 48 8B 6C 24 10 48 8B 74 24 18 48 8B 7C 24 20 C3 48 63 C2 49 3B 01 73 E0 FF CA 8B DD 44 8D 5A 01 45 85 DB 74 6A 48 63 C2 48 8D 3C 00 45 85 C0 74 33 B8 67 66 66 66 41 0F B7 C8 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 0F B7 C2 66 C1 E0 02 66 03 D0 49 8B 02 66 03 D2 66 2B CA 66 83 C1 30 66 89 0C 07 EB 07 49 8B 02 66 89 34 07 B8 67 66 66 66 FF C3 41 F7 E8 48 83 EF 02 44 8B C2 41 C1 F8 02 41 8B C0 C1 E8 1F 44 03 C0 41 83 EB 01 75 9D 48 63 CB 48 8D 04 09 49 01 02 49 29 09 E9 5A FF FF FF }
	condition:
		$1
}

rule file_95_22_0 {
	meta:
		name = "?store_number_without_lead_zeroes@@YAXHQEAPEA_WQEA_K@Z"
		size = 136
	strings:
		$1 = { 49 8B 00 4C 8B D2 4C 8B 0A 44 8B D9 48 83 F8 01 76 68 B8 67 66 66 66 41 F7 EB C1 FA 02 8B C2 C1 E8 1F 03 D0 0F B7 C2 66 C1 E0 02 8D 0C 10 66 03 C9 66 44 2B D9 66 41 83 C3 30 66 45 89 19 49 83 C1 02 49 FF 08 44 8B DA 85 D2 7E 06 49 83 38 01 77 C0 49 8B 12 4D 8D 41 FE 4D 89 0A EB 16 0F B7 02 41 0F B7 08 66 41 89 00 49 83 E8 02 66 89 0A 48 83 C2 02 49 3B D0 72 E5 C3 48 03 C0 4C 2B C8 4C 89 0A 49 83 20 00 C3 }
	condition:
		$1
}

rule file_95_23_0 {
	meta:
		name = "?store_string@@YAXPEB_WQEAPEA_WQEA_K@Z"
		size = 40
	strings:
		$1 = { 45 33 D2 4D 39 10 74 1F 44 0F B7 09 66 45 85 C9 74 15 48 8B 02 48 83 C1 02 66 44 89 08 48 83 02 02 49 83 28 01 75 E1 C3 }
	condition:
		$1
}

rule file_95_24_0 {
	meta:
		name = "?store_winword@@YA_NQEAU__crt_locale_pointers@@HQEBUtm@@QEAPEA_WQEA_KQEBU__crt_lc_time_data@@@Z"
		size = 1383
		refs = "001c __security_cookie 00eb __acrt_GetTimeFormatEx 0105 __acrt_GetDateFormatEx 0165 __chkstk 018c _malloc_base 022a _free_base 02c1 ??_C@_1M@PBPMMENC@?$AAa?$AAm?$AA?1?$AAp?$AAm?$AA?$AA@ 02c9 _wcsicmp 032c ??_C@_17BLFJJHMM@?$AAa?$AA?1?$AAp?$AA?$AA@ 050c ?expand_time@@YA_NPEAU__crt_locale_pointers@@_WPEBUtm@@PEAPEA_WPEA_KPEBU__crt_lc_time_data@@_N@Z 0540 __security_check_cookie 0559 _errno"
	strings:
		$1 = { 40 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 70 48 8D 6C 24 40 48 89 5D 78 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 20 4C 8B BD 90 00 00 00 4D 8B D8 4C 8B AD 98 00 00 00 4D 8B E1 4C 89 45 00 4C 8B F1 45 33 C0 48 89 4D 08 85 D2 74 17 83 FA 01 74 09 49 8B BD B0 02 00 00 EB 10 49 8B BD A8 02 00 00 EB 07 49 8B BD A0 02 00 00 41 BA 01 00 00 00 45 39 95 58 01 00 00 0F 84 C5 01 00 00 41 0F B7 43 14 83 FA 02 B9 6C 07 00 00 66 44 89 45 1E 41 0F 94 C6 4C 8B CF 66 03 C1 33 D2 49 8B 8D B8 02 00 00 66 89 45 10 41 0F B7 43 10 66 41 03 C2 66 89 45 12 41 0F B7 43 0C 66 89 45 16 41 0F B7 43 08 66 89 45 18 41 0F B7 43 04 66 89 45 1A 41 0F B7 03 66 89 45 1C 45 84 F6 74 15 44 89 44 24 28 4C 89 44 24 20 4C 8D 45 10 E8 ?? ?? ?? ?? EB 18 4C 89 44 24 30 44 89 44 24 28 4C 89 44 24 20 4C 8D 45 10 E8 ?? ?? ?? ?? 45 33 C0 8B F0 85 C0 0F 84 1F 01 00 00 48 63 D0 48 03 D2 48 8D 4A 10 48 3B D1 48 1B C0 48 85 C1 74 7C 48 8D 4A 10 48 3B D1 48 1B C0 48 23 C1 48 3D 00 04 00 00 48 8D 42 10 77 3E 48 3B D0 48 1B C9 48 23 C8 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 5C 24 40 48 85 DB 0F 84 BB 00 00 00 C7 03 CC CC 00 00 EB 1F 48 3B D0 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 45 33 C0 48 8B D8 48 85 C0 74 0F C7 00 DD DD 00 00 48 83 C3 10 EB 03 49 8B D8 48 85 DB 0F 84 82 00 00 00 49 8B 8D B8 02 00 00 33 D2 4C 8B CF 45 84 F6 74 14 89 74 24 28 4C 8D 45 10 48 89 5C 24 20 E8 ?? ?? ?? ?? EB 17 4C 89 44 24 30 4C 8D 45 10 89 74 24 28 48 89 5C 24 20 E8 ?? ?? ?? ?? 8B D0 4C 8B C3 FF CA 45 33 C9 EB 1E 4D 39 0F 76 1D 41 0F B7 00 49 83 C0 02 49 8B 0C 24 66 89 01 49 83 04 24 02 49 FF 0F FF CA 85 D2 7F DE 48 8D 4B F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? B0 01 E9 03 03 00 00 4C 8B 75 08 41 BA 01 00 00 00 4C 8B 5D 00 44 0F B7 0F 66 45 85 C9 0F 84 E4 02 00 00 B8 64 00 00 00 4D 39 07 0F 84 D6 02 00 00 41 8A D8 41 8B C8 48 8B F7 48 83 C6 02 41 03 CA 4D 03 C2 66 44 39 0E 74 F0 41 0F B7 D1 3B D0 0F 8F 68 01 00 00 0F 84 2B 01 00 00 41 BB 27 00 00 00 41 3B D3 0F 84 B1 00 00 00 41 8D 43 1A 3B D0 74 1D 45 8D 43 21 41 3B D0 74 64 41 8D 43 26 3B D0 74 25 41 8D 43 3A 3B D0 0F 85 11 02 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 58 48 8D 77 0A EB 69 83 E9 01 74 25 83 E9 01 74 23 83 E9 01 74 11 83 F9 01 0F 85 E0 01 00 00 8D 41 41 E9 F9 01 00 00 B8 62 00 00 00 E9 EF 01 00 00 41 8A DA B8 6D 00 00 00 E9 E2 01 00 00 83 E9 01 74 0A 83 F9 01 74 08 E9 B2 01 00 00 41 8A DA 41 0F B7 C0 E9 C7 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 04 48 8D 77 06 B8 70 00 00 00 E9 A6 01 00 00 8B C1 25 01 00 00 80 7D 09 41 2B C2 83 C8 FE 41 03 C2 85 C0 75 0F 48 63 C1 48 8D 3C 47 45 33 C0 E9 AF 01 00 00 4A 8D 3C 47 45 33 C0 0F B7 0F 66 85 C9 0F 84 B3 01 00 00 4D 39 07 0F 84 93 01 00 00 48 83 C7 02 66 41 3B CB 0F 84 85 01 00 00 49 8B 04 24 66 89 08 49 83 04 24 02 49 FF 0F 0F B7 0F 66 85 C9 75 D2 E9 69 01 00 00 83 E9 01 74 25 83 E9 01 74 23 83 E9 01 74 11 83 F9 01 0F 85 02 01 00 00 8D 41 40 E9 1B 01 00 00 B8 61 00 00 00 E9 11 01 00 00 41 8A DA B8 64 00 00 00 E9 04 01 00 00 83 EA 68 0F 84 D0 00 00 00 83 EA 05 0F 84 B1 00 00 00 83 EA 06 0F 84 92 00 00 00 83 EA 01 74 29 83 FA 05 0F 85 BA 00 00 00 83 F9 02 74 11 83 F9 04 0F 85 AC 00 00 00 8D 42 54 E9 C5 00 00 00 B8 79 00 00 00 E9 BB 00 00 00 41 83 7B 08 0B 7F 09 49 8B 95 90 02 00 00 EB 07 49 8B 95 98 02 00 00 45 33 C0 41 3B CA 75 38 4D 39 07 76 33 49 8B 0C 24 0F B7 02 66 89 01 49 83 04 24 02 49 FF 0F E9 AB 00 00 00 4D 39 07 0F 86 A2 00 00 00 49 8B 04 24 48 83 C2 02 66 89 08 49 83 04 24 02 49 FF 0F 0F B7 0A 66 85 C9 75 DC E9 82 00 00 00 83 E9 01 74 07 83 F9 01 74 05 EB 2A 41 8A DA B8 53 00 00 00 EB 41 83 E9 01 74 07 83 F9 01 74 05 EB 14 41 8A DA B8 4D 00 00 00 EB 2B 83 E9 01 74 1E 83 F9 01 74 1C 49 8B 04 24 48 83 C7 02 66 44 89 08 49 83 04 24 02 49 FF 0F E9 7F FE FF FF 41 8A DA B8 49 00 00 00 4C 8B 45 00 4D 8B CC 88 5C 24 30 0F B7 D0 4C 89 6C 24 28 49 8B CE 4C 89 7C 24 20 E8 ?? ?? ?? ?? 45 33 C0 84 C0 74 41 45 8D 50 01 48 8B FE 44 0F B7 0F B8 64 00 00 00 4C 8B 5D 00 66 45 85 C9 0F 85 21 FD FF FF 41 8A C2 48 8B 4D 20 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 78 48 8D 65 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 E8 ?? ?? ?? ?? C7 00 16 00 00 00 32 C0 EB D1 }
	condition:
		$1
}

rule file_95_27_0 {
	meta:
		name = "_W_Getdays"
		size = 416
		refs = "0023 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0086 _malloc_base 00cf wcscpy_s 013e _free_base 0186 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 41 54 41 55 41 56 41 57 48 83 EC 50 33 D2 48 8D 48 B8 E8 ?? ?? ?? ?? 48 8B 44 24 38 45 33 FF 41 8B F7 49 83 CC FF 4C 8B B0 20 01 00 00 45 8D 47 07 49 8D 96 60 01 00 00 48 8B 42 38 49 8B CC 48 FF C1 66 44 39 3C 48 75 F6 4C 8B 0A 49 8B C4 48 FF C0 66 45 39 3C 41 75 F6 48 03 C6 48 83 C2 08 48 8D 71 02 48 03 F0 49 83 E8 01 75 CB 48 8D 0C 75 02 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 08 49 8B FF E9 A1 00 00 00 48 8B D8 49 8B EF 49 81 C6 98 01 00 00 41 BD 3A 00 00 00 66 44 89 2B 48 8B D6 4D 8B 46 C8 48 83 C3 02 48 8B C3 48 8B CB 48 2B C7 48 D1 F8 48 2B D0 48 FF C2 E8 ?? ?? ?? ?? 85 C0 0F 85 B0 00 00 00 49 8B C4 48 FF C0 66 44 39 3C 43 75 F6 48 8D 1C 43 48 8B D6 66 44 89 2B 48 83 C3 02 4D 8B 06 48 8B C3 48 2B C7 48 8B CB 48 D1 F8 48 2B D0 48 FF C2 E8 ?? ?? ?? ?? 85 C0 75 61 49 8B C4 48 FF C0 66 44 39 3C 43 75 F6 48 FF C5 48 8D 1C 43 49 83 C6 08 48 83 FD 07 0F 82 76 FF FF FF 66 44 89 3B 33 C9 E8 ?? ?? ?? ?? 44 38 7C 24 48 74 0C 48 8B 4C 24 30 83 A1 A8 03 00 00 FD 4C 8D 5C 24 50 48 8B C7 49 8B 5B 30 49 8B 6B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 45 33 C9 4C 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_95_28_0 {
	meta:
		name = "_W_Getmonths"
		size = 416
		refs = "0023 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0086 _malloc_base 00cf wcscpy_s 013e _free_base 0186 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 41 54 41 55 41 56 41 57 48 83 EC 50 33 D2 48 8D 48 B8 E8 ?? ?? ?? ?? 48 8B 44 24 38 45 33 FF 41 8B F7 49 83 CC FF 4C 8B B0 20 01 00 00 45 8D 47 0C 49 8D 96 D0 01 00 00 48 8B 42 60 49 8B CC 48 FF C1 66 44 39 3C 48 75 F6 4C 8B 0A 49 8B C4 48 FF C0 66 45 39 3C 41 75 F6 48 03 C6 48 83 C2 08 48 8D 71 02 48 03 F0 49 83 E8 01 75 CB 48 8D 0C 75 02 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 08 49 8B FF E9 A1 00 00 00 48 8B D8 49 8B EF 49 81 C6 30 02 00 00 41 BD 3A 00 00 00 66 44 89 2B 48 8B D6 4D 8B 46 A0 48 83 C3 02 48 8B C3 48 8B CB 48 2B C7 48 D1 F8 48 2B D0 48 FF C2 E8 ?? ?? ?? ?? 85 C0 0F 85 B0 00 00 00 49 8B C4 48 FF C0 66 44 39 3C 43 75 F6 48 8D 1C 43 48 8B D6 66 44 89 2B 48 83 C3 02 4D 8B 06 48 8B C3 48 2B C7 48 8B CB 48 D1 F8 48 2B D0 48 FF C2 E8 ?? ?? ?? ?? 85 C0 75 61 49 8B C4 48 FF C0 66 44 39 3C 43 75 F6 48 FF C5 48 8D 1C 43 49 83 C6 08 48 83 FD 0C 0F 82 76 FF FF FF 66 44 89 3B 33 C9 E8 ?? ?? ?? ?? 44 38 7C 24 48 74 0C 48 8B 4C 24 30 83 A1 A8 03 00 00 FD 4C 8D 5C 24 50 48 8B C7 49 8B 5B 30 49 8B 6B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 45 33 C9 4C 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_95_29_0 {
	meta:
		name = "_W_Gettnames"
		size = 2134
		refs = "0023 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0052 _malloc_base 006b memset 00b2 strcpy_s 036f wcscpy_s 0721 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 57 41 54 41 55 41 56 41 57 48 83 EC 50 33 D2 48 8D 48 B8 E8 ?? ?? ?? ?? 48 8B 44 24 38 33 D2 48 89 94 24 80 00 00 00 BB C0 02 00 00 44 8B F2 44 8B E2 48 8B A8 20 01 00 00 41 83 FC 01 75 35 48 8B CB E8 ?? ?? ?? ?? 33 D2 4C 8B F0 48 85 C0 0F 84 AA 06 00 00 4C 8B C3 48 8B C8 E8 ?? ?? ?? ?? 48 8B C3 48 89 9C 24 80 00 00 00 BB C0 02 00 00 33 D2 EB 08 48 8B 84 24 80 00 00 00 4D 8B EE 4D 63 FC 4C 2B ED 48 8B F2 48 8B FD 49 83 FF 01 75 20 49 8D 0C 1E 48 8B D0 4A 89 0C 2F 48 2B D3 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 53 06 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 38 14 01 75 F8 48 FF C0 48 FF C6 48 03 D8 48 83 C7 08 48 8B 84 24 80 00 00 00 48 83 FE 07 72 B0 48 8B F2 48 8D 7D 38 49 83 FF 01 75 25 48 8B 94 24 80 00 00 00 49 8D 0C 1E 4A 89 0C 2F 48 2B D3 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 0A 06 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 38 14 01 75 F8 48 FF C3 48 FF C6 48 03 D8 48 83 C7 08 48 83 FE 07 72 B3 48 8B F2 48 8D 7D 70 49 83 FF 01 75 25 48 8B 94 24 80 00 00 00 49 8D 0C 1E 4A 89 0C 2F 48 2B D3 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 C9 05 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 38 14 01 75 F8 48 FF C3 48 FF C6 48 03 D8 48 83 C7 08 48 83 FE 0C 72 B3 48 8B F2 48 8D BD D0 00 00 00 49 83 FF 01 75 25 48 8B 94 24 80 00 00 00 49 8D 0C 1E 4A 89 0C 2F 48 2B D3 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 85 05 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 38 14 01 75 F8 48 FF C3 48 FF C6 48 03 D8 48 83 C7 08 48 83 FE 0C 72 B3 48 8B F2 48 8D BD 30 01 00 00 49 83 FF 01 75 25 48 8B 94 24 80 00 00 00 49 8D 0C 1E 4A 89 0C 2F 48 2B D3 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 41 05 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 38 14 01 75 F8 48 FF C3 48 FF C6 48 03 D8 48 83 C7 08 48 83 FE 02 72 B3 48 8B BC 24 80 00 00 00 41 83 FC 01 75 27 49 8D 0C 1E 48 8B D7 49 89 8E 40 01 00 00 48 2B D3 4C 8B 85 40 01 00 00 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 FD 04 00 00 48 8B 8D 40 01 00 00 48 83 CE FF 48 8B C6 48 FF C0 38 14 01 75 F8 48 FF C3 48 03 D8 41 83 FC 01 75 27 49 8D 0C 1E 48 8B D7 49 89 8E 48 01 00 00 48 2B D3 4C 8B 85 48 01 00 00 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 C7 04 00 00 48 8B 8D 48 01 00 00 48 8B C6 48 FF C0 38 14 01 75 F8 48 FF C3 48 03 D8 41 83 FC 01 75 27 49 8D 0C 1E 48 8B D7 49 89 8E 50 01 00 00 48 2B D3 4C 8B 85 50 01 00 00 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 95 04 00 00 48 8B 8D 50 01 00 00 48 8B C6 48 FF C0 38 14 01 75 F8 48 FF C3 48 03 D8 41 83 FC 01 75 14 8B 85 58 01 00 00 41 89 86 58 01 00 00 41 89 96 5C 01 00 00 48 8B F2 48 8D BD 60 01 00 00 EB 03 48 FF C3 F6 C3 01 75 F8 49 83 FF 01 75 2E 48 8B 94 24 80 00 00 00 48 8B C3 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 4A 89 0C 2F 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 2E 04 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 48 FF C6 48 83 C3 02 48 83 C7 08 48 83 FE 07 72 A2 48 8B F2 48 8D BD 98 01 00 00 EB 03 48 FF C3 F6 C3 01 75 F8 49 83 FF 01 75 2E 48 8B 94 24 80 00 00 00 48 8B C3 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 4A 89 0C 2F 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 D4 03 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 48 FF C6 48 83 C3 02 48 83 C7 08 48 83 FE 07 72 A2 48 8B F2 48 8D BD D0 01 00 00 EB 03 48 FF C3 F6 C3 01 75 F8 49 83 FF 01 75 2E 48 8B 94 24 80 00 00 00 48 8B C3 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 4A 89 0C 2F 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 7A 03 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 48 FF C6 48 83 C3 02 48 83 C7 08 48 83 FE 0C 72 A2 48 8B F2 48 8D BD 30 02 00 00 EB 03 48 FF C3 F6 C3 01 75 F8 49 83 FF 01 75 2E 48 8B 94 24 80 00 00 00 48 8B C3 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 4A 89 0C 2F 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 20 03 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 48 FF C6 48 83 C3 02 48 83 C7 08 48 83 FE 0C 72 A2 48 8B F2 48 8D BD 90 02 00 00 EB 03 48 FF C3 F6 C3 01 75 F8 49 83 FF 01 75 2E 48 8B 94 24 80 00 00 00 48 8B C3 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 4A 89 0C 2F 4C 8B 07 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 C6 02 00 00 48 8B 0F 48 83 C8 FF 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 48 FF C6 48 83 C3 02 48 83 C7 08 48 83 FE 02 72 A2 EB 03 48 FF C3 F6 C3 01 75 F8 48 8B BC 24 80 00 00 00 41 83 FC 01 75 30 48 8B C3 48 8B D7 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 49 89 8E A0 02 00 00 4C 8B 85 A0 02 00 00 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 6C 02 00 00 48 8B 8D A0 02 00 00 48 83 CE FF 48 8B C6 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 48 83 C3 02 EB 03 48 FF C3 F6 C3 01 75 F8 41 83 FC 01 75 30 48 8B C3 48 8B D7 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 49 89 8E A8 02 00 00 4C 8B 85 A8 02 00 00 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 20 02 00 00 48 8B 8D A8 02 00 00 48 8B C6 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 48 83 C3 02 EB 03 48 FF C3 F6 C3 01 75 F8 41 83 FC 01 75 30 48 8B C3 48 8B D7 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 49 89 8E B0 02 00 00 4C 8B 85 B0 02 00 00 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 D8 01 00 00 48 8B 8D B0 02 00 00 48 8B C6 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 48 83 C3 02 EB 03 48 FF C3 F6 C3 01 75 F8 41 83 FC 01 75 30 48 8B C3 48 8B D7 48 D1 E8 48 2B D3 48 D1 EA 49 8D 0C 46 49 89 8E B8 02 00 00 4C 8B 85 B8 02 00 00 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 90 01 00 00 48 8B 8D B8 02 00 00 48 8B C6 48 FF C0 66 39 14 41 75 F7 48 8D 1C 43 41 FF C4 48 83 C3 02 41 83 FC 02 0F 8C 6D F9 FF FF 38 54 24 48 74 0C 48 8B 4C 24 30 83 A1 A8 03 00 00 FD 4C 8D 5C 24 50 49 8B C6 49 8B 5B 38 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 4C 8B F2 EB C8 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_95_30_0 {
	meta:
		name = "_Wcsftime"
		size = 30
		refs = "0015 _Wcsftime_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 83 64 24 28 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_635_19_0 {
	meta:
		name = "_Strftime"
		size = 30
		refs = "0015 _Strftime_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 83 64 24 28 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_346_8_0 {
	meta:
		name = "mbstowcs_s"
		size = 30
		refs = "0015 _mbstowcs_s_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 83 64 24 28 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_188_9_0 {
	meta:
		name = "wcstombs_s"
		size = 30
		refs = "0015 _wcstombs_s_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 83 64 24 28 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_95_31_0 {
	meta:
		name = "_Wcsftime_l"
		size = 420
		refs = "0034 _errno 003f _invalid_parameter_noinfo 0061 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0110 ?expand_time@@YA_NPEAU__crt_locale_pointers@@_WPEBUtm@@PEAPEA_WPEA_KPEBU__crt_lc_time_data@@_N@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 70 45 33 ED 4D 8B E1 49 8B D8 48 8B FA 48 8B F1 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 3C 01 00 00 48 85 D2 74 E4 66 44 89 29 48 85 DB 74 DB 48 8B 55 58 48 8D 4D D8 E8 ?? ?? ?? ?? 4C 8B 75 50 4D 85 F6 75 0B 48 8B 45 E0 4C 8B B0 20 01 00 00 48 8B CE 48 8B C7 48 89 4D D0 45 8A FD 48 89 45 30 48 85 FF 0F 84 B1 00 00 00 0F B7 13 85 D2 0F 84 8F 00 00 00 83 FA 25 74 20 66 89 11 48 83 C3 02 48 8B 4D D0 48 8B 45 30 48 83 C1 02 48 FF C8 48 89 4D D0 48 89 45 30 EB 61 4D 85 E4 0F 84 93 00 00 00 48 83 C3 02 41 8A C5 66 83 3B 23 75 06 B0 01 48 83 C3 02 66 83 3B 45 74 06 66 83 3B 4F 75 04 48 83 C3 02 0F B7 13 4C 8D 4D D0 88 44 24 30 48 8D 4D E0 48 8D 45 30 4C 89 74 24 28 4D 8B C4 48 89 44 24 20 E8 ?? ?? ?? ?? 84 C0 48 8B 45 30 74 20 48 8B 4D D0 48 83 C3 02 48 85 C0 0F 85 66 FF FF FF 48 85 C0 74 12 66 44 89 29 48 2B 7D 30 EB 36 48 85 C0 74 03 41 B7 01 66 44 89 2E 45 84 FF 75 12 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 49 8B FD 44 38 6D F0 74 0B 48 8B 4D D8 83 A1 A8 03 00 00 FD 48 8B C7 4C 8D 5C 24 70 49 8B 5B 38 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_95_35_0 {
	meta:
		name = "_invoke_watson_if_oneof"
		size = 61
		refs = "0038 _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 4D 8B D1 85 C9 74 09 3B CA 74 0C 41 3B C8 74 07 8B C1 48 83 C4 38 C3 48 8B 44 24 78 49 8B CA 44 8B 4C 24 70 4C 8B 44 24 68 48 8B 54 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_95_36_0 {
	meta:
		name = "_wcsftime_l"
		size = 30
		refs = "0015 _Wcsftime_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_635_23_0 {
	meta:
		name = "_strftime_l"
		size = 30
		refs = "0015 _Strftime_l"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_95_37_0 {
	meta:
		name = "wcsftime"
		size = 26
		refs = "0011 _Wcsftime_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 28 00 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_635_24_0 {
	meta:
		name = "strftime"
		size = 26
		refs = "0011 _Strftime_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 28 00 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_96_6_0 {
	meta:
		name = "_mkdir"
		size = 73
		refs = "000c _wmkdir 001e __acrt_copy_path_to_wide_string 003d _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 31 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_150_6_0 {
	meta:
		name = "_rmdir"
		size = 73
		refs = "000c _wrmdir 001e __acrt_copy_path_to_wide_string 003d _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 31 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_605_7_0 {
	meta:
		name = "remove"
		size = 73
		refs = "000c _wremove 001e __acrt_copy_path_to_wide_string 003d _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 31 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_97_6_0 {
	meta:
		name = "?_wcsupr_s_l_stat@@YAHQEA_W_KQEAU__crt_locale_pointers@@@Z"
		size = 532
		refs = "0022 __security_cookie 003f _errno 004b _invalid_parameter_noinfo 0055 wcsnlen 008a __acrt_LCMapStringW 0138 __chkstk 015b _malloc_base 01c2 wcscpy_s 01e8 _free_base 01f6 __security_check_cookie"
	strings:
		$1 = { 40 55 41 56 41 57 48 83 EC 40 48 8D 6C 24 30 48 89 5D 30 48 89 75 38 48 89 7D 40 4C 89 65 48 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 00 45 33 E4 4D 8B F8 48 8B F2 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? E9 98 01 00 00 E8 ?? ?? ?? ?? 48 3B C6 72 06 66 44 89 23 EB DA 49 8B 07 48 8B 88 38 01 00 00 48 85 C9 74 51 44 89 64 24 28 41 83 C9 FF 4C 8B C3 4C 89 64 24 20 BA 00 02 00 00 E8 ?? ?? ?? ?? 4C 63 F0 85 C0 75 3C E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 E8 ?? ?? ?? ?? 8B 00 E9 41 01 00 00 0F B7 0B 8D 41 9F 66 83 F8 19 77 07 66 83 E9 20 66 89 0B 48 83 C3 02 66 44 39 23 75 E3 33 C0 E9 1D 01 00 00 49 8B D6 49 3B F6 73 13 66 44 89 23 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 5C FF FF FF 48 03 D2 48 8D 4A 10 48 3B D1 48 1B C0 48 85 C1 74 75 48 8D 4A 10 48 3B D1 48 1B C0 48 23 C1 48 3D 00 04 00 00 48 8D 42 10 77 3A 48 3B D0 48 1B C9 48 23 C8 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 7C 24 30 48 85 FF 74 32 C7 07 CC CC 00 00 EB 1C 48 3B D0 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0F C7 00 DD DD 00 00 48 83 C7 10 EB 03 49 8B FC 48 85 FF 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 18 EB 47 49 8B 0F 41 83 C9 FF 44 89 74 24 28 4C 8B C3 BA 00 02 00 00 48 89 7C 24 20 48 8B 89 38 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 12 4C 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 8B D8 EB 0C E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 48 85 FF 74 11 48 8D 4F F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 4D 00 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 30 48 8B 75 38 48 8B 7D 40 4C 8B 65 48 48 8D 65 10 41 5F 41 5E 5D C3 }
	condition:
		$1
}

rule file_97_12_0 {
	meta:
		name = "_wcsupr"
		size = 95
		refs = "000f __acrt_locale_changed_data 001b _errno 0026 _invalid_parameter_noinfo 0052 _wcsupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 45 33 C0 48 8B D9 44 39 05 ?? ?? ?? ?? 75 38 48 85 C9 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 2B 0F B7 11 8D 42 9F 66 83 F8 19 77 07 66 83 EA 20 66 89 11 48 83 C1 02 66 44 39 01 75 E3 EB 09 48 83 CA FF E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_98_4_0 {
	meta:
		name = "_wcsicoll"
		size = 132
		refs = "000d __acrt_locale_changed_data 001c _errno 0027 _invalid_parameter_noinfo 0080 _wcsicoll_l"
	strings:
		$1 = { 48 83 EC 28 45 33 C0 4C 8B CA 44 39 05 ?? ?? ?? ?? 4C 8B D1 75 65 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 4C 2B D2 43 0F B7 14 0A 8D 42 BF 66 83 F8 19 77 04 66 83 C2 20 41 0F B7 09 8D 41 BF 66 83 F8 19 77 04 66 83 C1 20 49 83 C1 02 66 85 D2 74 05 66 3B D1 74 CF 0F B7 C9 0F B7 C2 2B C1 48 83 C4 28 C3 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_488_4_0 {
	meta:
		name = "_wcsicmp"
		size = 132
		refs = "000d __acrt_locale_changed_data 001c _errno 0027 _invalid_parameter_noinfo 0080 _wcsicmp_l"
	strings:
		$1 = { 48 83 EC 28 45 33 C0 4C 8B CA 44 39 05 ?? ?? ?? ?? 4C 8B D1 75 65 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 4C 2B D2 43 0F B7 14 0A 8D 42 BF 66 83 F8 19 77 04 66 83 C2 20 41 0F B7 09 8D 41 BF 66 83 F8 19 77 04 66 83 C1 20 49 83 C1 02 66 85 D2 74 05 66 3B D1 74 CF 0F B7 C9 0F B7 C2 2B C1 48 83 C4 28 C3 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_5_0 {
	meta:
		name = "_wcsicoll_l"
		size = 230
		refs = "001e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002f _errno 003a _invalid_parameter_noinfo 00a4 __acrt_CompareStringW"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 50 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 33 F6 48 85 FF 74 05 48 85 DB 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 77 48 8B 44 24 38 48 8B 88 30 01 00 00 48 85 C9 75 3C 48 2B FB 0F B7 0C 1F 8D 41 BF 66 83 F8 19 77 04 66 83 C1 20 0F B7 13 8D 42 BF 66 83 F8 19 77 04 66 83 C2 20 48 83 C3 02 66 85 C9 74 05 66 3B CA 74 D1 0F B7 C2 0F B7 D1 2B D0 EB 34 41 83 C9 FF 4C 8B C7 44 89 4C 24 28 BA 01 10 00 00 48 89 5C 24 20 E8 ?? ?? ?? ?? 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 BA FF FF FF 7F EB 03 8D 50 FE 40 38 74 24 48 74 0C 48 8B 4C 24 30 83 A1 A8 03 00 00 FD 48 8B 5C 24 60 8B C2 48 8B 74 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "_calloc_base"
		size = 117
		refs = "0032 _query_new_mode 003e _callnewh 0049 __acrt_heap 0057 __imp_HeapAlloc 0063 _errno"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 48 8B D9 48 85 C9 74 0E 33 D2 48 8D 42 E0 48 F7 F3 49 3B C0 72 43 49 0F AF D8 B8 01 00 00 00 48 85 DB 48 0F 44 D8 EB 15 E8 ?? ?? ?? ?? 85 C0 74 28 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 1C 48 8B 0D ?? ?? ?? ?? 4C 8B C3 BA 08 00 00 00 FF 15 ?? ?? ?? ?? 48 85 C0 74 D1 EB 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__acrt_initialize_locks"
		size = 72
		refs = "000b ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 0020 __acrt_InitializeCriticalSectionEx 002a ?__acrt_locks_initialized@@3IA 003c __acrt_uninitialize_locks"
	strings:
		$1 = { 40 53 48 83 EC 20 33 DB 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0C 9B 48 8D 0C CA BA A0 0F 00 00 E8 ?? ?? ?? ?? 85 C0 74 11 FF 05 ?? ?? ?? ?? FF C3 83 FB 0E 72 D3 B0 01 EB 09 33 C9 E8 ?? ?? ?? ?? 32 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "__acrt_lock"
		size = 25
		refs = "000a ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 0015 __imp_EnterCriticalSection"
	strings:
		$1 = { 48 63 C1 48 8D 0C 80 48 8D 05 ?? ?? ?? ?? 48 8D 0C C8 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_3_0 {
	meta:
		name = "__acrt_unlock"
		size = 25
		refs = "000a ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 0015 __imp_LeaveCriticalSection"
	strings:
		$1 = { 48 63 C1 48 8D 0C 80 48 8D 05 ?? ?? ?? ?? 48 8D 0C C8 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_2_0 {
	meta:
		name = "__acrt_uninitialize_locks"
		size = 55
		refs = "0008 ?__acrt_locks_initialized@@3IA 0011 ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 0021 __imp_DeleteCriticalSection"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 1D ?? ?? ?? ?? EB 1D 48 8D 05 ?? ?? ?? ?? FF CB 48 8D 0C 9B 48 8D 0C C8 FF 15 ?? ?? ?? ?? FF 0D ?? ?? ?? ?? 85 DB 75 DF B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "_add_exp"
		size = 78
	strings:
		$1 = { F2 0F 11 44 24 08 B8 FF 07 00 00 48 8B 4C 24 08 48 C1 E9 30 66 C1 E9 04 66 23 C8 F2 0F 11 44 24 20 48 8B 44 24 20 66 03 CA F2 0F 11 44 24 18 BA 0F 80 00 00 48 C1 E8 30 66 23 C2 66 C1 E1 04 66 0B C8 66 89 4C 24 1E F2 0F 10 44 24 18 C3 }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "_decomp"
		size = 308
	strings:
		$1 = { 0F 28 C8 F2 0F 11 44 24 08 0F 57 C0 4C 8B D2 66 0F 2E C8 7A 09 75 07 33 C9 E9 12 01 00 00 48 8B 44 24 08 B9 F0 7F 00 00 4C 8B C0 49 C1 E8 30 66 44 85 C1 0F 85 AD 00 00 00 8B 54 24 08 48 C1 E8 20 A9 FF FF 0F 00 75 08 85 D2 0F 84 96 00 00 00 45 33 C9 B9 03 FC FF FF 66 0F 2F C1 41 0F 97 C1 41 F6 C0 10 75 24 8B 44 24 0C 03 C0 89 44 24 0C 85 D2 79 07 83 C8 01 89 44 24 0C 03 D2 FF C9 F6 44 24 0E 10 74 E4 89 54 24 08 0F B7 44 24 0E BA EF FF 00 00 66 23 C2 66 89 44 24 0E 45 85 C9 74 0D BA 00 80 00 00 66 0B C2 66 89 44 24 0E F2 0F 10 44 24 08 BA EF BF 00 00 F2 0F 11 44 24 10 48 8B 44 24 10 48 C1 E8 30 66 23 C2 F2 0F 11 44 24 08 BA E0 3F 00 00 66 0B C2 66 89 44 24 0E F2 0F 10 44 24 08 EB 4A BA EF BF 00 00 F2 0F 11 4C 24 10 B9 FF 07 00 00 F2 0F 11 4C 24 18 48 8B 44 24 18 48 C1 E8 30 66 23 C2 BA E0 3F 00 00 66 0B C2 66 89 44 24 16 0F B7 44 24 0E F2 0F 10 44 24 10 66 C1 E8 04 66 23 C1 0F BF C8 81 E9 FE 03 00 00 41 89 0A C3 }
	condition:
		$1
}

rule file_101_2_0 {
	meta:
		name = "_get_exp"
		size = 37
	strings:
		$1 = { B9 FF 07 00 00 F2 0F 11 44 24 08 48 8B 44 24 08 48 C1 E8 30 66 C1 E8 04 66 23 C1 B9 FE 03 00 00 66 2B C1 98 C3 }
	condition:
		$1
}

rule file_101_3_0 {
	meta:
		name = "_set_bexp"
		size = 48
	strings:
		$1 = { F2 0F 11 44 24 08 B9 0F 80 00 00 48 8B 44 24 08 48 C1 E8 30 F2 0F 11 44 24 18 66 23 C1 66 C1 E2 04 66 0B C2 66 89 44 24 1E F2 0F 10 44 24 18 C3 }
	condition:
		$1
}

rule file_101_4_0 {
	meta:
		name = "_set_exp"
		size = 56
	strings:
		$1 = { F2 0F 11 44 24 08 B9 0F 80 00 00 48 8B 44 24 08 48 C1 E8 30 66 23 C1 F2 0F 11 44 24 18 B9 FE 03 00 00 66 03 D1 66 C1 E2 04 66 0B C2 66 89 44 24 1E F2 0F 10 44 24 18 C3 }
	condition:
		$1
}

rule file_101_5_0 {
	meta:
		name = "_sptype"
		size = 116
	strings:
		$1 = { F2 0F 11 44 24 08 48 8B 44 24 08 48 8B C8 48 C1 E9 20 81 F9 00 00 F0 7F 75 0A 85 C0 75 06 B8 01 00 00 00 C3 81 F9 00 00 F0 FF 75 0A 85 C0 75 06 B8 02 00 00 00 C3 41 B8 F8 7F 00 00 48 8B D0 48 C1 EA 30 66 41 23 D0 66 41 3B D0 75 06 B8 03 00 00 00 C3 41 B8 F0 7F 00 00 66 41 3B D0 75 12 F7 C1 FF FF 07 00 75 04 85 C0 74 06 B8 04 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "_cputws"
		size = 220
		refs = "001e __doserrno 0025 _errno 0030 _invalid_parameter_noinfo 003f __dcrt_lowio_console_output_handle 004a __dcrt_lowio_initialize_console_output 006e __acrt_lock 00a1 __imp_WriteConsoleW 00ca __acrt_unlock"
	strings:
		$1 = { 40 53 56 57 41 54 41 56 48 83 EC 30 48 8B F1 33 DB 8B C3 48 85 C9 0F 95 C0 85 C0 75 1F E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 94 00 00 00 48 8B 05 ?? ?? ?? ?? 48 83 F8 FE 75 0C E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 83 F8 FF 74 D9 48 83 CF FF 48 FF C7 66 39 1C 7E 75 F7 B9 09 00 00 00 E8 ?? ?? ?? ?? 90 41 BC FF 7F 00 00 48 85 FF 7E 46 44 8B F7 49 3B FC 45 0F 47 F4 48 89 5C 24 20 4C 8D 4C 24 68 45 8B C6 48 8B D6 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 16 41 8B C6 4A 8D 34 76 48 89 74 24 60 48 2B F8 48 89 7C 24 70 EB B5 B9 09 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 30 41 5E 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "_cputws$fin$0"
		size = 25
		refs = "0014 __acrt_unlock"
		altNames = "_cgetws_s$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 09 00 00 00 48 83 C4 30 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "conjf"
		size = 60
		refs = "000f crealf 001c cimagf 0023 __xmm@80000000800000008000000080000000"
	strings:
		$1 = { 48 83 EC 48 0F 29 74 24 30 48 89 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 0F 28 F0 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 0F 28 CE 0F 28 74 24 30 0F 14 C8 66 48 0F 7E C8 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "llroundf"
		size = 95
		refs = "0010 _fdtest 0027 roundf 002e __real@df000000 003e __real@5f000000 0054 _fperrraise"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 98 85 C0 74 3F FF C8 83 F8 01 76 2E F3 0F 10 44 24 30 E8 ?? ?? ?? ?? 0F 2F 05 ?? ?? ?? ?? F3 0F 11 44 24 30 72 14 F3 0F 10 0D ?? ?? ?? ?? 0F 2F C8 72 07 F3 48 0F 2C C0 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "tanf"
		size = 1651
		refs = "0006 __use_fma3_lib 0018 L_inf_mask_32 0039 L_piby4 0046 L_mask_3f2 004f L_mask_3e4 005d L_near_one_f 0065 L_two_to_32 0084 L_point_333 00b0 L_tanf 00fd L_large_x_sse2 010b L_sign_mask 0113 L_twobypi 011f L_point_five 012f L_int_three 013f L_piby2_1 014b L_piby2_1tail 016b __L_2_by_pi_bits 02c2 L_piby2_lead 0323 L_n_one 0333 L_signbit 035a _tanf_special 042c L_large_x_fma3 05ea L_int_one"
	strings:
		$1 = { 48 83 EC 38 83 3D ?? ?? ?? ?? 00 0F 85 5F 03 00 00 66 0F 7E C0 44 8B 05 ?? ?? ?? ?? 41 23 C0 41 3B C0 0F 84 31 03 00 00 F3 0F 5A E8 66 49 0F 7E E9 49 0F BA F1 3F 4C 3B 0D ?? ?? ?? ?? 0F 8F B2 00 00 00 4C 3B 0D ?? ?? ?? ?? 7D 54 4C 3B 0D ?? ?? ?? ?? 7D 1B F3 0F 10 C8 F3 0F 59 0D ?? ?? ?? ?? F3 0F 58 0D ?? ?? ?? ?? 48 83 C4 38 C3 66 90 66 0F 28 D5 F2 0F 59 D2 66 0F 28 C2 F2 0F 59 C5 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 C5 E9 BF 02 00 00 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 66 0F 28 C5 66 0F 28 C8 F2 0F 59 C8 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 1D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 5E DA F2 0F 59 C8 F2 0F 59 CB F2 0F 58 C1 E9 5B 02 00 00 66 49 0F 6E C1 4C 3B 0D ?? ?? ?? ?? 7D 65 66 0F 28 C8 66 0F 54 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? 66 0F E6 E2 F3 0F E6 CC 66 0F 54 25 ?? ?? ?? ?? 66 0F 28 D0 66 0F 28 D9 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C D1 F2 0F 59 1D ?? ?? ?? ?? 66 0F 28 C2 F2 0F 5C C3 F2 0F 5C D0 66 0F 28 CA F2 0F 5C CB E9 5E 01 00 00 4C 8D 0D ?? ?? ?? ?? 66 49 0F 7E C3 49 8B CB 49 C1 EB 34 49 81 EB FF 03 00 00 4D 8B D3 49 C1 EA 03 49 81 EA 86 00 00 00 49 F7 DA 4B 8B 04 0A 48 C1 E1 0C 48 C1 E9 0C 48 0F BA E9 34 49 83 C2 08 F3 43 0F 6F 04 0A 48 F7 E1 4C 8B C0 4C 8B D2 66 48 0F 7E C0 48 F7 E1 49 83 E3 07 66 0F 73 D8 08 49 03 C2 48 83 D2 00 4C 8B C8 4C 8B D2 66 48 0F 7E C0 48 F7 E1 4C 03 D0 48 C7 C1 36 00 00 00 49 8B C2 49 2B CB 48 33 D2 48 D3 E8 73 1B 49 F7 D2 49 F7 D1 49 F7 D0 48 BA 00 00 00 00 00 00 00 80 0F 1F 84 00 00 00 00 00 48 83 D0 00 48 83 E0 03 66 0F 6E E0 49 8B CB 48 83 C1 0A 49 D3 E2 49 D3 EA 48 83 E9 40 4C 8B D9 49 0F BD CA 75 1A 4D 8B D1 4D 8B C8 49 C7 C0 00 00 00 00 49 0F BD CA 49 83 EB 40 0F 1F 44 00 00 4C 03 D9 48 83 E9 34 48 83 F9 00 7C 23 74 41 4D 8B C2 49 D3 EA 49 D3 E9 48 83 E9 40 48 F7 D9 49 D3 E0 4D 0B C8 EB 29 66 0F 1F 84 00 00 00 00 00 48 F7 D9 49 8B C1 49 D3 E2 49 D3 E1 48 83 E9 40 48 F7 D9 48 D3 E8 4C 0B D0 49 D3 E8 4D 0B C8 90 49 81 C3 FF 03 00 00 49 0F BA F2 34 49 8B CB 4C 0B D2 48 C1 E1 34 4C 0B D1 66 49 0F 6E C2 F2 0F 59 05 ?? ?? ?? ?? 66 0F 7E E0 83 E0 01 66 0F 28 C8 F2 0F 59 C8 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 1D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 5E DA F2 0F 59 C8 F2 0F 59 CB F2 0F 58 C1 83 F8 01 75 11 66 48 0F 6E 1D ?? ?? ?? ?? F2 0F 5E D8 F2 0F 10 C3 66 0F 54 2D ?? ?? ?? ?? 66 0F 57 C5 F2 0F 5A C0 48 83 C4 38 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 5A C0 48 83 C4 38 C3 E8 ?? ?? ?? ?? 48 83 C4 38 C3 66 66 66 66 66 0F 1F 84 00 00 00 00 00 C5 F9 7E C0 44 8B 05 ?? ?? ?? ?? 41 23 C0 41 3B C0 0F 84 E2 02 00 00 C5 FA 5A E8 C4 C1 F9 7E E9 49 0F BA F1 3F 4C 3B 0D ?? ?? ?? ?? 0F 8F 82 00 00 00 4C 3B 0D ?? ?? ?? ?? 7D 34 4C 3B 0D ?? ?? ?? ?? 7D 15 C5 FA 59 0D ?? ?? ?? ?? C5 F2 58 0D ?? ?? ?? ?? 48 83 C4 38 C3 C5 D3 59 D5 C5 EB 59 C5 C4 E2 D1 99 05 ?? ?? ?? ?? E9 81 02 00 00 C5 D3 10 C5 C5 FB 59 C8 C5 FB 10 1D ?? ?? ?? ?? C4 E2 F1 A9 1D ?? ?? ?? ?? C5 FB 10 15 ?? ?? ?? ?? C4 E2 F1 A9 15 ?? ?? ?? ?? C4 E2 F1 A9 15 ?? ?? ?? ?? C5 E3 5E DA C5 F3 59 C8 C4 E2 F1 B9 C3 E9 3C 02 00 00 C4 C1 F9 6E C1 4C 3B 0D ?? ?? ?? ?? 7D 59 C5 F9 54 0D ?? ?? ?? ?? C5 F9 28 15 ?? ?? ?? ?? C4 E2 F1 A9 15 ?? ?? ?? ?? C5 F9 E6 D2 C4 E2 79 25 CA C5 F1 54 25 ?? ?? ?? ?? C5 F0 C6 C9 08 C5 FA E6 C9 C5 F9 6F D0 C4 E2 F1 BD 15 ?? ?? ?? ?? C5 F3 59 1D ?? ?? ?? ?? C5 EB 5C C3 C5 EB 5C D0 C5 EB 5C CB E9 5B 01 00 00 4C 8D 0D ?? ?? ?? ?? C4 C1 F9 7E C3 49 8B CB 49 C1 EB 34 49 81 EB FF 03 00 00 4D 8B D3 49 C1 EA 03 49 81 EA 86 00 00 00 49 F7 DA 4B 8B 04 0A 48 C1 E1 0C 48 C1 E9 0C 48 0F BA E9 34 49 83 C2 08 C4 81 7A 6F 04 0A 48 F7 E1 4C 8B C0 4C 8B D2 C4 E1 F9 7E C0 48 F7 E1 49 83 E3 07 C5 F9 73 D8 08 49 03 C2 48 83 D2 00 4C 8B C8 4C 8B D2 C4 E1 F9 7E C0 48 F7 E1 4C 03 D0 48 C7 C1 36 00 00 00 49 8B C2 49 2B CB 48 33 D2 48 D3 E8 73 18 49 F7 D2 49 F7 D1 49 F7 D0 48 BA 00 00 00 00 00 00 00 80 0F 1F 44 00 00 48 83 D0 00 48 83 E0 03 C5 F9 6E E0 49 8B CB 48 83 C1 0A 49 D3 E2 49 D3 EA 48 83 E9 40 4C 8B D9 49 0F BD CA 75 1A 4D 8B D1 4D 8B C8 49 C7 C0 00 00 00 00 49 0F BD CA 49 83 EB 40 0F 1F 44 00 00 4C 03 D9 48 83 E9 34 48 83 F9 00 7C 23 74 41 4D 8B C2 49 D3 EA 49 D3 E9 48 83 E9 40 48 F7 D9 49 D3 E0 4D 0B C8 EB 29 66 0F 1F 84 00 00 00 00 00 48 F7 D9 49 8B C1 49 D3 E2 49 D3 E1 48 83 E9 40 48 F7 D9 48 D3 E8 4C 0B D0 49 D3 E8 4D 0B C8 90 49 81 C3 FF 03 00 00 49 0F BA F2 34 49 8B CB 4C 0B D2 48 C1 E1 34 4C 0B D1 C4 C1 F9 6E C2 C5 FB 59 05 ?? ?? ?? ?? C5 D9 54 15 ?? ?? ?? ?? C5 F9 7E D0 C5 FB 59 C8 C5 FB 10 1D ?? ?? ?? ?? C4 E2 F1 A9 1D ?? ?? ?? ?? C5 FB 10 15 ?? ?? ?? ?? C4 E2 F1 A9 15 ?? ?? ?? ?? C4 E2 F1 A9 15 ?? ?? ?? ?? C5 E3 5E DA C5 F3 59 C8 C4 E2 F1 B9 C3 83 F8 01 75 0D C4 E1 F9 6E 1D ?? ?? ?? ?? C5 E3 5E C0 C5 D1 54 2D ?? ?? ?? ?? C5 F9 57 C5 C5 FB 5A C0 48 83 C4 38 C3 66 66 66 0F 1F 84 00 00 00 00 00 C5 FB 5A C0 48 83 C4 38 C3 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "fmin"
		size = 110
		refs = "0016 _dtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 38 EB 41 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 30 EB 29 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 77 14 66 0F 2E C8 7A 11 75 0F B8 00 80 00 00 66 85 44 24 36 74 03 0F 28 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_565_0_0 {
	meta:
		name = "fminl"
		size = 110
		refs = "0016 _ldtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 38 EB 41 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 30 EB 29 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 77 14 66 0F 2E C8 7A 11 75 0F B8 00 80 00 00 66 85 44 24 36 74 03 0F 28 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_109_4_0 {
	meta:
		name = "_strnicoll"
		size = 21
		refs = "0002 __acrt_locale_changed_data 0009 _strnicmp 0011 _strnicoll_l"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 45 33 C9 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_5_0 {
	meta:
		name = "_strnicoll_l"
		size = 256
		refs = "0025 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0040 _errno 004b _invalid_parameter_noinfo 0092 _strnicmp_l 00bd __acrt_CompareStringA"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 60 48 8B F2 48 8B E9 49 8B D1 48 8D 48 D8 49 8B F8 E8 ?? ?? ?? ?? 48 85 FF 75 07 33 DB E9 A0 00 00 00 48 85 ED 74 05 48 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BB FF FF FF 7F EB 7F BB FF FF FF 7F 48 3B FB 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 63 48 8B 44 24 48 48 8B 90 30 01 00 00 48 85 D2 75 17 4C 8D 4C 24 48 4C 8B C7 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 8B D8 EB 3B 8B 40 14 48 8D 4C 24 48 89 44 24 38 4C 8B CD 89 7C 24 30 41 B8 01 10 00 00 48 89 74 24 28 89 7C 24 20 E8 ?? ?? ?? ?? 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 58 FE 80 7C 24 58 00 74 0C 48 8B 44 24 40 83 A0 A8 03 00 00 FD 4C 8D 5C 24 60 8B C3 49 8B 5B 10 49 8B 6B 18 49 8B 73 20 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "_fdpow"
		size = 1569
		refs = "003a __security_cookie 006b _fdunscale 007a _fd_int 00c2 __real@3f000000 00d3 __real@bf000000 00df __real@3f800000 0111 _fperrraise 0119 _FNan_C 0134 __xmm@80000000800000008000000080000000 015d __real@3f3504f3 016a __real@40000000 01a1 _fdlogpoly 01b3 __real@3f317218 01f7 __real@c7000000 0212 __real@c1400000 021c __real@41400000 0229 __real@c2200000 0233 __real@42200000 0286 __real@47000000 029f _fdxp_setw 02c5 _fdxp_addx 02ea log2e 02fa _fdxp_mulh 035b _fdxp_addh 0418 _fdxp_getw 044c _fdexp 046b _FInf_C 0516 __security_check_cookie 056e _FZero_C"
	strings:
		$1 = { 48 8B C4 48 89 58 20 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC E0 00 00 00 0F 29 70 B8 0F 29 78 A8 44 0F 29 40 98 44 0F 29 48 88 44 0F 29 A0 78 FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 C7 44 0F 28 C9 F3 0F 11 44 24 20 48 8D 54 24 20 F3 44 0F 11 4C 24 38 48 8D 4C 24 28 F3 44 0F 11 4C 24 30 4D 8B E0 E8 ?? ?? ?? ?? 33 D2 48 8D 4C 24 30 0F B7 F8 E8 ?? ?? ?? ?? 45 33 FF 0F B7 F0 4D 85 E4 74 05 66 45 89 3C 24 45 0F 57 C0 66 85 F6 75 08 45 0F 2E C8 7A 02 74 3C 0F B7 44 24 28 41 BE 01 00 00 00 F3 0F 10 4C 24 20 66 85 FF 0F 89 E7 03 00 00 66 41 3B C6 75 29 0F 2E 0D ?? ?? ?? ?? 7A 02 74 11 66 41 3B F6 75 18 0F 2E 0D ?? ?? ?? ?? 7A 0F 75 0D F3 0F 10 05 ?? ?? ?? ?? E9 26 04 00 00 66 44 3B FF 0F 8E AE 03 00 00 66 44 3B FE 0F 8C A4 03 00 00 BB 00 80 00 00 66 85 5C 24 22 74 1A 66 85 F6 79 15 41 8B CE E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? E9 EC 03 00 00 83 CF FF 41 0F 2F C8 76 06 45 0F B7 EF EB 28 0F 57 0D ?? ?? ?? ?? 48 8D 4C 24 30 8B D7 F3 0F 11 4C 24 20 E8 ?? ?? ?? ?? F3 0F 10 4C 24 20 44 0F B7 E8 0F B7 44 24 28 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C1 76 10 F3 0F 59 0D ?? ?? ?? ?? 66 03 C7 66 89 44 24 28 0F 28 C1 F3 0F 5C 05 ?? ?? ?? ?? F3 0F 58 0D ?? ?? ?? ?? 0F 28 F8 F3 0F 11 44 24 20 F3 0F 5E F9 0F 28 F7 F3 0F 59 F7 0F 28 C6 E8 ?? ?? ?? ?? F3 0F 10 64 24 20 44 0F 28 E0 F3 0F 10 2D ?? ?? ?? ?? 0F 28 DC 0F BF 44 24 28 41 0F 28 C9 F3 44 0F 59 E6 66 0F 6E D0 F3 44 0F 5C E4 0F 5B D2 F3 44 0F 59 E7 F3 41 0F 58 DC 0F 28 C3 F3 0F 5E C5 F3 0F 58 C2 F3 0F 59 C8 F3 0F 11 44 24 30 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C1 F3 0F 11 4C 24 2C 76 09 45 0F B7 F7 E9 4B 02 00 00 0F 2F 0D ?? ?? ?? ?? 72 6B F3 0F 10 05 ?? ?? ?? ?? 0F 2F C1 72 5E 44 0F 2F 0D ?? ?? ?? ?? 76 54 F3 0F 10 05 ?? ?? ?? ?? 41 0F 2F C1 76 46 44 0F 2F C1 76 0A F3 0F 5C 0D ?? ?? ?? ?? EB 08 F3 0F 58 0D ?? ?? ?? ?? F3 41 0F 59 D1 F3 44 0F 2C C1 F3 41 0F 59 D9 66 41 0F 6E C0 0F 5B C0 F3 0F 5C D0 F3 0F 59 D5 F3 0F 58 DA F3 0F 11 5C 24 2C E9 AE 01 00 00 0F 2F 0D ?? ?? ?? ?? 0F 87 CA 01 00 00 BF 04 00 00 00 48 8D 4D 97 8B D7 0F 28 D4 E8 ?? ?? ?? ?? 8D 5F FE 41 0F 28 D4 8B D3 48 8D 4C 24 38 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 44 24 38 8B D7 48 8D 4D 97 E8 ?? ?? ?? ?? F3 0F 10 55 97 41 0F 2E D0 7A 13 75 11 41 0F 28 D0 48 8D 4D A7 8B D7 E8 ?? ?? ?? ?? EB 61 0F 10 05 ?? ?? ?? ?? 8B D7 48 8D 4D A7 F3 0F 7F 45 A7 E8 ?? ?? ?? ?? 45 8B FE 48 8D 75 9B F3 0F 10 16 41 0F 2E D0 7A 02 74 34 0F 10 05 ?? ?? ?? ?? 8B D7 48 8D 4D B7 F3 0F 7F 45 B7 E8 ?? ?? ?? ?? 44 8B CF 4C 8D 45 B7 8B D7 48 8D 4D A7 E8 ?? ?? ?? ?? 45 03 FE 48 03 F7 44 3B FF 7C C0 45 33 FF 0F BF 44 24 28 48 8D 4D A7 8B D7 66 0F 6E D0 0F 5B D2 E8 ?? ?? ?? ?? 41 0F 28 D1 48 8D 4D 97 8B D3 E8 ?? ?? ?? ?? 0F 28 45 A7 48 8D 4D 87 F3 0F 10 55 97 8B D7 66 0F 7F 45 87 E8 ?? ?? ?? ?? F3 0F 10 55 9B 41 0F 2E D0 7A 02 74 26 0F 28 45 A7 48 8D 4D B7 8B D7 66 0F 7F 45 B7 E8 ?? ?? ?? ?? 44 8B CF 4C 8D 45 B7 8B D7 48 8D 4D 87 E8 ?? ?? ?? ?? F3 0F 10 4D 87 41 0F 2E C8 F3 0F 11 4C 24 20 7A 02 74 20 F3 0F 10 55 8B 41 0F 2E D0 7A 02 74 13 F3 0F 10 45 8F F3 0F 58 C2 F3 0F 58 C1 F3 0F 11 44 24 20 33 D2 48 8D 4C 24 20 E8 ?? ?? ?? ?? F3 0F 10 54 24 20 48 8D 4D 87 0F 57 15 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B D7 48 8D 4D 87 E8 ?? ?? ?? ?? F3 0F 59 05 ?? ?? ?? ?? F3 44 0F 2C 44 24 20 F3 0F 11 44 24 2C 4D 85 E4 74 08 66 45 89 04 24 45 8B C7 F3 0F 10 0D ?? ?? ?? ?? 48 8D 4C 24 2C E8 ?? ?? ?? ?? F3 0F 10 4C 24 2C 44 0F B7 F0 41 0F BF CE 85 C9 74 1A 83 F9 01 75 2A F3 0F 10 05 ?? ?? ?? ?? B9 08 00 00 00 F3 0F 11 44 24 2C EB 0A 83 64 24 2C 00 B9 10 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 4C 24 2C 66 45 85 ED 74 13 0F 57 0D ?? ?? ?? ?? EB 0A BB 02 00 00 00 66 3B FB 75 05 0F 28 C1 EB 5F 66 3B F3 75 06 41 0F 28 C1 EB 54 BB 00 80 00 00 66 41 3B FE 0F 85 B6 00 00 00 66 85 5C 24 22 75 15 66 85 5D 81 75 09 F3 44 0F 10 05 ?? ?? ?? ?? 41 0F 28 C0 EB 29 66 85 5D 81 75 63 66 85 F6 75 16 83 CA FF 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 0F 88 07 01 00 00 F3 0F 10 05 ?? ?? ?? ?? 48 8B 4D C7 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 E0 00 00 00 49 8B 5B 58 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 45 0F 28 4B C0 45 0F 28 63 B0 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 66 85 F6 75 8C 83 CA FF 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 0F 89 76 FF FF FF F3 44 0F 10 05 ?? ?? ?? ?? 44 0F 57 05 ?? ?? ?? ?? E9 60 FF FF FF 66 41 3B F6 75 22 66 85 5D 81 75 0E 66 85 C0 0F 8E 4B FF FF FF E9 3D FF FF FF 66 85 C0 0F 8F 3D FF FF FF E9 2F FF FF FF 66 85 5D 81 75 2C 66 85 F6 0F 85 29 FF FF FF 83 CA FF 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 0F 89 13 FF FF FF 66 85 5C 24 22 0F 84 08 FF FF FF EB 90 B9 04 00 00 00 E8 ?? ?? ?? ?? 66 85 F6 0F 85 1A FF FF FF 83 CA FF 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 0F 89 04 FF FF FF 66 85 5C 24 22 0F 84 F9 FE FF FF F3 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? E9 ED FE FF FF }
	condition:
		$1
}

rule file_111_1_0 {
	meta:
		name = "_fdtgamma"
		size = 379
		refs = "0018 __real@41f80000 001f stirling 002c __real@bf000000 0039 __real@3f000000 004f __real@3f800000 0066 __real@bf800000 0097 __real@3fc00000 00b1 __real@40200000 00c6 __real@c0000000 0104 _fdunscale 0119 __real@3d11e52b 0124 __real@3c590091 012c __real@3e452ca6 0134 __real@3c1aa374 0144 __real@3c9153c0 014c __real@3edbc710 015c __real@3f8314b3 0164 __real@3eddacfc"
	strings:
		$1 = { 40 53 48 83 EC 30 0F 29 74 24 20 48 8B C2 F3 0F 10 31 48 8B D9 0F 2F 35 ?? ?? ?? ?? 72 0A E8 ?? ?? ?? ?? E9 48 01 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 76 3A F3 0F 10 0D ?? ?? ?? ?? 0F 28 C6 0F 2F F1 F3 0F 11 44 24 40 77 17 F3 0F 58 35 ?? ?? ?? ?? 0F 2F F1 F3 0F 59 C6 76 EF F3 0F 11 44 24 40 F3 0F 58 35 ?? ?? ?? ?? E9 8C 00 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 76 17 0F 28 C6 F3 0F 58 05 ?? ?? ?? ?? F3 0F 59 C6 F3 0F 11 44 24 40 EB 68 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 76 0D 0F 28 C6 F3 0F 58 35 ?? ?? ?? ?? EB 1D F3 0F 10 0D ?? ?? ?? ?? 0F 2F CE F3 0F 10 05 ?? ?? ?? ?? 76 0F F3 0F 58 35 ?? ?? ?? ?? 33 C9 66 89 0A EB 3D 0F 2F F1 F3 0F 11 44 24 40 76 17 F3 0F 58 35 ?? ?? ?? ?? 0F 2F F1 F3 0F 5E C6 77 EF F3 0F 11 44 24 40 F3 0F 58 35 ?? ?? ?? ?? 48 8D 54 24 40 48 8B C8 E8 ?? ?? ?? ?? F3 0F 10 44 24 40 F3 0F 11 03 0F 28 CE F3 0F 59 0D ?? ?? ?? ?? 0F 28 C6 F3 0F 59 05 ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 59 CE F3 0F 59 C6 F3 0F 58 0D ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 59 CE F3 0F 59 C6 F3 0F 58 0D ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 5E C1 F3 0F 59 C6 0F 28 74 24 20 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_111_2_0 {
	meta:
		name = "stirling"
		size = 214
		refs = "0038 __real@3f000000 003d _fdpow 0045 __real@3f800000 0064 approx0 006c __real@3cc5aaec 0074 _fdpoly 0094 __xmm@80000000800000008000000080000000 00a1 expf"
	strings:
		$1 = { 48 8B C4 48 89 58 08 57 48 83 EC 60 0F 29 70 E8 4C 8B C2 0F 29 78 D8 48 8B DA 44 0F 29 40 C8 48 8B F9 44 0F 29 48 B8 F3 44 0F 10 09 41 0F 28 C9 41 0F 28 C1 F3 0F 5C 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? F3 0F 10 35 ?? ?? ?? ?? 44 0F 28 C0 0F B7 03 41 B8 01 00 00 00 F3 41 0F 5E F1 66 F7 D8 66 89 03 48 8B 15 ?? ?? ?? ?? F3 0F 5C 35 ?? ?? ?? ?? 0F 28 C6 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 0F 28 F8 0F 28 C6 41 B8 07 00 00 00 E8 ?? ?? ?? ?? 44 0F 57 0D ?? ?? ?? ?? F3 0F 5E F8 41 0F 28 C1 E8 ?? ?? ?? ?? 48 8B 5C 24 70 0F 28 74 24 50 44 0F 28 4C 24 20 F3 41 0F 59 C0 44 0F 28 44 24 30 F3 0F 5E F8 0F 57 C0 F3 0F 11 3F 0F 28 7C 24 40 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_111_3_0 {
	meta:
		name = "tgammaf"
		size = 581
		refs = "001f _fd_int 0057 _fperrraise 005f _FNan_C 007d _FInf_C 0093 __xmm@80000000800000008000000080000000 00a5 __real@c2180000 00c4 _fdgamma_big 00f4 __real@3f800000 010e __real@bf800000 0132 __real@40490fdb 0139 _fdsin 0172 _fdtgamma 019a _fdscale 01c6 __real@42180000"
	strings:
		$1 = { F3 0F 11 44 24 08 55 48 8B EC 48 83 EC 40 33 D2 F3 0F 11 45 28 48 8D 4D 28 0F 29 74 24 30 E8 ?? ?? ?? ?? F3 0F 10 55 10 0F 57 F6 0F BF C8 85 C9 74 36 83 E9 01 74 0F 83 F9 01 75 65 F3 0F 10 45 10 E9 F4 01 00 00 B8 00 80 00 00 66 85 45 12 74 EB B9 01 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? E9 D2 01 00 00 0F 2E D6 7A 2F 75 2D B9 04 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? B8 00 80 00 00 66 85 45 12 0F 84 AA 01 00 00 0F 57 05 ?? ?? ?? ?? E9 9E 01 00 00 0F 2F F2 77 B0 F3 0F 10 0D ?? ?? ?? ?? 0F 2F CA 72 12 B9 10 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 E9 7A 01 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 10 35 ?? ?? ?? ?? 0F 57 C6 0F 2F C2 0F 86 E6 00 00 00 0F 28 C2 F3 0F 11 55 20 F3 0F 5C 55 28 0F 57 C6 48 8D 4D 20 F3 0F 5C 05 ?? ?? ?? ?? 83 CA FF F3 0F 11 55 28 F3 0F 11 45 E0 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 10 4D 10 F3 0F 5C 4D 20 0F 2F C1 F3 0F 10 45 28 76 08 0F 57 C6 F3 0F 11 45 28 F3 0F 59 05 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? F3 0F 10 4D 10 48 8D 55 18 F3 0F 59 C1 48 8D 4D E0 0F 57 CE F3 0F 5C 0D ?? ?? ?? ?? F3 0F 59 C8 F3 0F 10 05 ?? ?? ?? ?? 0F 57 CE F3 0F 5E C1 F3 0F 11 45 20 E8 ?? ?? ?? ?? F3 0F 10 4D 20 48 8D 4D 20 F3 0F 58 05 ?? ?? ?? ?? 0F BF 55 18 F3 0F 5E C8 F3 0F 59 4D E0 F3 0F 11 4D 20 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0C 83 F9 01 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 45 20 EB 78 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C2 72 59 48 8D 55 18 48 8D 4D 10 E8 ?? ?? ?? ?? 0F BF 55 18 48 8D 4D 10 F3 0F 11 45 28 F7 DA F3 0F 58 05 ?? ?? ?? ?? F3 0F 5E 45 10 F3 0F 11 45 10 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 10 83 F9 01 0F 85 2A FE FF FF B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? E9 14 FE FF FF B9 08 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "CountryEnumProc"
		size = 236
		refs = "001a __security_cookie 002d __acrt_getptd 0044 LcidFromHexString 006f __imp_GetLocaleInfoW 008d _wcsicmp 0098 __rglangidNotDefault 00cf __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 48 81 EC 20 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 10 01 00 00 48 8B D9 E8 ?? ?? ?? ?? 48 8B E8 E8 ?? ?? ?? ?? 48 8B CB 48 8B B8 A0 03 00 00 E8 ?? ?? ?? ?? 8B 8D B4 00 00 00 4C 8D 44 24 20 F7 D9 41 B9 78 00 00 00 8B C8 8B F0 1B D2 81 E2 05 F0 FF FF 81 C2 02 10 00 00 FF 15 ?? ?? ?? ?? 33 DB 85 C0 75 07 89 1F 8D 43 01 EB 43 48 8B 8D A0 00 00 00 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 75 24 48 8D 0D ?? ?? ?? ?? 66 3B 31 74 18 FF C3 48 83 C1 02 48 63 C3 48 83 F8 0A 72 EC 83 0F 04 89 77 08 89 77 04 8B 07 C1 E8 02 F7 D0 83 E0 01 48 8B 8C 24 10 01 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 20 01 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_112_1_0 {
	meta:
		name = "GetLcidFromCountry"
		size = 95
		refs = "000e __acrt_getptd 0032 CountryEnumProc 0049 __imp_EnumSystemLocalesW"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 83 CA FF 4C 8B C0 33 FF 48 8B 80 A0 00 00 00 48 FF C2 66 39 3C 50 75 F7 48 83 FA 03 48 8D 0D ?? ?? ?? ?? 8B C7 BA 01 00 00 00 0F 94 C0 41 89 80 B4 00 00 00 FF 15 ?? ?? ?? ?? F6 03 04 75 02 89 3B 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_112_2_0 {
	meta:
		name = "GetLcidFromDefault"
		size = 33
		refs = "0011 __imp_GetUserDefaultLCID"
	strings:
		$1 = { 40 53 48 83 EC 20 81 09 04 01 00 00 48 8B D9 FF 15 ?? ?? ?? ?? 89 43 08 89 43 04 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_112_3_0 {
	meta:
		name = "GetLcidFromLangCountry"
		size = 205
		refs = "000e __acrt_getptd 0095 LangCountryEnumProc 00a0 __imp_EnumSystemLocalesW"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 49 83 C8 FF 4D 8B C8 33 FF 48 8D 90 98 00 00 00 48 8B 02 49 FF C1 66 42 39 3C 48 75 F6 8B C7 49 83 F9 03 0F 94 C0 89 42 18 48 8B 42 08 49 FF C0 66 42 39 3C 40 75 F6 49 83 F8 03 8B C7 41 B8 02 00 00 00 0F 94 C0 89 42 1C 89 7B 04 39 7A 18 75 2B 48 8B 0A 44 8B D7 44 0F B7 09 49 03 C8 41 8D 41 BF 66 83 F8 19 76 0C 66 41 83 E9 61 66 41 83 F9 19 77 05 41 FF C2 EB DE 45 8B C2 44 89 42 14 48 8D 0D ?? ?? ?? ?? BA 01 00 00 00 FF 15 ?? ?? ?? ?? 8B 0B F6 C1 07 0F 95 C2 0F BA E1 09 0F 92 C0 22 D0 0F BA E1 08 0F 92 C0 84 D0 75 02 89 3B 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_112_4_0 {
	meta:
		name = "GetLcidFromLanguage"
		size = 152
		refs = "000e __acrt_getptd 007c LanguageEnumProc 0082 __imp_EnumSystemLocalesW"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 49 83 C8 FF 4C 8B D0 33 FF 48 8B 90 98 00 00 00 49 FF C0 66 42 39 3C 42 75 F6 8B C7 49 83 F8 03 B9 02 00 00 00 0F 94 C0 41 89 82 B0 00 00 00 85 C0 75 28 44 8B CF 44 0F B7 02 48 03 D1 41 8D 40 BF 66 83 F8 19 76 0C 66 41 83 E8 61 66 41 83 F8 19 77 05 41 FF C1 EB DE 41 8B C9 41 89 8A AC 00 00 00 BA 01 00 00 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F6 03 04 75 02 89 3B 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_112_5_0 {
	meta:
		name = "GetPrimaryLen"
		size = 38
	strings:
		$1 = { 45 33 C0 0F B7 11 48 83 C1 02 8D 42 BF 66 83 F8 19 76 0A 66 83 EA 61 66 83 FA 19 77 05 41 FF C0 EB E1 41 8B C0 C3 }
	condition:
		$1
}

rule file_112_6_0 {
	meta:
		name = "LangCountryEnumProc"
		size = 580
		refs = "0019 __security_cookie 002c __acrt_getptd 0047 LcidFromHexString 006f __imp_GetLocaleInfoW 0091 _wcsicmp 00fd _wcsnicmp 0132 __rglangidNotDefault 01fc TestDefaultLanguage 0227 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 41 56 41 57 48 81 EC 20 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 10 01 00 00 48 8B D9 E8 ?? ?? ?? ?? 48 8D B0 98 00 00 00 E8 ?? ?? ?? ?? 48 8B CB 48 8B B8 A0 03 00 00 E8 ?? ?? ?? ?? 8B 4E 1C 4C 8D 44 24 20 F7 D9 41 B9 78 00 00 00 8B C8 8B D8 1B D2 81 E2 05 F0 FF FF 81 C2 02 10 00 00 FF 15 ?? ?? ?? ?? 45 33 FF 85 C0 75 0D 44 89 3F B8 01 00 00 00 E9 94 01 00 00 48 8B 4E 08 48 8D 54 24 20 E8 ?? ?? ?? ?? 49 83 CE FF 85 C0 0F 85 B2 00 00 00 8B 46 18 45 8D 4E 79 F7 D8 4C 8D 44 24 20 8B CB 1B D2 81 E2 02 F0 FF FF 81 C2 01 10 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 B1 48 8B 0E 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 75 0B 81 0F 04 03 00 00 89 5F 04 EB 6B F6 07 02 75 69 44 39 7E 14 74 35 4C 63 46 14 48 8D 54 24 20 48 8B 0E E8 ?? ?? ?? ?? 85 C0 75 20 83 0F 02 49 8B C6 89 5F 08 48 8B 0E 48 FF C0 66 44 39 3C 41 75 F6 3B 46 14 75 33 89 5F 04 EB 2E 8B 0F F6 C1 01 75 27 45 8B C7 48 8D 15 ?? ?? ?? ?? 66 3B 1A 74 18 41 FF C0 48 83 C2 02 49 63 C0 48 83 F8 0A 72 EB 83 C9 01 89 0F 89 5F 08 8B 07 B9 00 03 00 00 23 C1 3B C1 0F 84 AD 00 00 00 8B 46 18 4C 8D 44 24 20 F7 D8 41 B9 78 00 00 00 8B CB 1B D2 81 E2 02 F0 FF FF 81 C2 01 10 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E8 FE FF FF 48 8B 0E 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 75 34 0F BA 2F 09 8B 07 44 39 7E 18 74 08 0F BA E8 08 89 07 EB 51 44 39 7E 14 74 F2 48 8B 0E 49 FF C6 66 46 39 3C 71 75 F6 44 3B 76 14 75 DF BA 01 00 00 00 EB 1F 44 39 7E 18 75 34 44 39 7E 14 74 2E 48 8B 0E 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 75 1D 33 D2 4C 8B C7 8B CB E8 ?? ?? ?? ?? 85 C0 74 0D 0F BA 2F 08 44 39 7F 04 75 03 89 5F 04 8B 07 C1 E8 02 F7 D0 83 E0 01 48 8B 8C 24 10 01 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 20 01 00 00 49 8B 5B 28 49 8B 73 30 49 8B E3 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_112_7_0 {
	meta:
		name = "LanguageEnumProc"
		size = 252
		refs = "0015 __security_cookie 0028 __acrt_getptd 0043 LcidFromHexString 006b __imp_GetLocaleInfoW 0085 _wcsicmp 00bc TestDefaultLanguage 00e3 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 48 81 EC 20 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 10 01 00 00 48 8B D9 E8 ?? ?? ?? ?? 48 8D B0 98 00 00 00 E8 ?? ?? ?? ?? 48 8B CB 48 8B B8 A0 03 00 00 E8 ?? ?? ?? ?? 8B 4E 18 4C 8D 44 24 20 F7 D9 41 B9 78 00 00 00 8B C8 8B D8 1B D2 81 E2 02 F0 FF FF 81 C2 01 10 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 09 21 07 B8 01 00 00 00 EB 5B 48 8B 0E 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 75 0A 39 46 18 75 32 8D 50 01 EB 1F 83 7E 18 00 75 30 83 7E 14 00 74 2A 48 8B 0E 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 75 19 33 D2 4C 8B C7 8B CB E8 ?? ?? ?? ?? 85 C0 74 09 83 0F 04 89 5F 04 89 5F 08 8B 07 C1 E8 02 F7 D0 83 E0 01 48 8B 8C 24 10 01 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 20 01 00 00 49 8B 5B 18 49 8B 73 20 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_112_8_0 {
	meta:
		name = "LcidFromHexString"
		size = 78
	strings:
		$1 = { 0F B7 11 45 33 D2 45 8B C2 4C 8B C9 EB 37 8D 42 9F 4D 8D 49 02 66 83 F8 05 77 07 B8 D9 FF 00 00 EB 0E 8D 42 BF 66 83 F8 05 77 08 B8 F9 FF 00 00 66 03 D0 41 C1 E0 04 0F B7 CA 41 83 C0 D0 41 0F B7 11 44 03 C1 66 85 D2 75 C4 41 8B C0 C3 }
	condition:
		$1
}

rule file_112_9_0 {
	meta:
		name = "ProcessCodePage"
		size = 174
		refs = "0024 ??_C@_17DNCLJFIF@?$AAA?$AAC?$AAP?$AA?$AA@ 0029 wcscmp 0034 ??_C@_17CIKBIHLH@?$AAO?$AAC?$AAP?$AA?$AA@ 0057 __imp_GetLocaleInfoW 0069 _wtol 009a __imp_GetACP"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 48 83 EC 20 33 F6 48 8B FA 48 8B D9 48 85 C9 74 53 66 39 31 74 4E 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 3E 48 8D 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 21 8B 4F 08 44 8D 4E 02 4C 8D 44 24 30 BA 0B 00 00 20 FF 15 ?? ?? ?? ?? 85 C0 74 2D 8B 44 24 30 EB 39 48 8B CB E8 ?? ?? ?? ?? EB 2F 8B 4F 08 4C 8D 44 24 30 41 B9 02 00 00 00 BA 04 10 00 20 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 0E 8B 44 24 30 85 C0 75 06 FF 15 ?? ?? ?? ?? 48 8B 5C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_112_10_0 {
	meta:
		name = "TestDefaultCountry"
		size = 40
		refs = "0006 __rglangidNotDefault"
	strings:
		$1 = { 45 33 C9 4C 8D 05 ?? ?? ?? ?? 41 8D 41 01 66 41 3B 08 74 11 44 03 C8 49 83 C0 02 49 63 D1 48 83 FA 0A 72 EA C3 33 C0 C3 }
	condition:
		$1
}

rule file_112_11_0 {
	meta:
		name = "TestDefaultLanguage"
		size = 171
		refs = "0014 __acrt_getptd 0039 __imp_GetLocaleInfoW"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 48 83 EC 20 8B F2 8B D9 E8 ?? ?? ?? ?? 8B CB 4C 8D 44 24 30 81 E1 FF 03 00 00 41 B9 02 00 00 00 0F BA E9 0A BA 01 00 00 20 48 8B F8 FF 15 ?? ?? ?? ?? 45 33 D2 85 C0 75 04 33 C0 EB 53 3B 5C 24 30 74 48 85 F6 74 44 4C 8B 8F 98 00 00 00 45 8B C2 41 0F B7 11 49 8D 49 02 8D 42 BF 66 83 F8 19 76 0A 66 83 EA 61 66 83 FA 19 77 0C 0F B7 11 41 FF C0 48 83 C1 02 EB E1 48 83 C8 FF 48 FF C0 66 45 39 14 41 75 F6 44 3B C0 74 AE B8 01 00 00 00 48 8B 5C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_112_12_0 {
	meta:
		name = "TranslateName"
		size = 137
		refs = "0041 _wcsicmp"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 F6 4D 8B F0 8B DA 48 8B E9 85 D2 78 30 49 8B 0E 8D 04 1E 99 2B C2 D1 F8 48 63 F8 48 8B D7 48 03 D2 48 8B 54 D5 00 E8 ?? ?? ?? ?? 85 C0 74 2B 79 05 8D 5F FF EB 03 8D 77 01 3B F3 7E D0 32 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 48 8B C7 48 C1 E0 04 48 83 C0 08 48 03 C5 49 89 06 B0 01 EB D0 }
	condition:
		$1
}

rule file_112_13_0 {
	meta:
		name = "__acrt_get_qualified_locale_downlevel"
		size = 653
		refs = "0015 __security_cookie 002a __acrt_getptd 0072 __acrt_rg_country_count 0079 __acrt_rg_country 0083 TranslateName 00b0 GetLcidFromLangCountry 00bb GetLcidFromLanguage 00cb __acrt_rg_language_count 00db __acrt_rg_language 0145 CountryEnumProc 0159 __imp_EnumSystemLocalesW 0172 __imp_GetUserDefaultLCID 019b ProcessCodePage 01bd __imp_IsValidCodePage 01d3 __imp_IsValidLocale 01fc __acrt_LCIDToLocaleName 022f __imp_GetLocaleInfoW 0265 _itow_s 027a __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 56 41 57 48 8B EC 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 49 8B F8 4C 8B FA 4C 8B F1 E8 ?? ?? ?? ?? 48 8B F0 33 C0 48 89 45 E0 89 45 E8 E8 ?? ?? ?? ?? 48 8D 4D E0 45 33 E4 48 8D 9E A0 00 00 00 48 89 88 A0 03 00 00 49 8D 86 80 00 00 00 4C 89 B6 98 00 00 00 48 89 03 48 85 C0 74 1D 66 44 39 20 74 17 8B 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF CA 4C 8B C3 E8 ?? ?? ?? ?? 44 89 65 E0 48 8B 86 98 00 00 00 48 85 C0 74 79 66 44 39 20 74 73 48 8B 03 48 85 C0 74 11 66 44 39 20 74 0B 48 8D 4D E0 E8 ?? ?? ?? ?? EB 09 48 8D 4D E0 E8 ?? ?? ?? ?? 44 39 65 E0 0F 85 BD 00 00 00 8B 15 ?? ?? ?? ?? 4C 8D 86 98 00 00 00 FF CA 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 90 00 00 00 48 8B 03 48 85 C0 74 11 66 44 39 20 74 0B 48 8D 4D E0 E8 ?? ?? ?? ?? EB 77 48 8D 4D E0 E8 ?? ?? ?? ?? EB 6C 48 8B 03 48 85 C0 74 51 66 44 39 20 74 4B E8 ?? ?? ?? ?? 48 8B D0 48 83 C9 FF 48 8B 80 A0 00 00 00 48 FF C1 66 44 39 24 48 75 F6 48 83 F9 03 41 8B C4 48 8D 0D ?? ?? ?? ?? 0F 94 C0 89 82 B4 00 00 00 BA 01 00 00 00 FF 15 ?? ?? ?? ?? F6 45 E0 04 75 19 44 89 65 E0 EB 13 C7 45 E0 04 01 00 00 FF 15 ?? ?? ?? ?? 89 45 E8 89 45 E4 44 39 65 E0 0F 84 EA 00 00 00 49 8D 86 00 01 00 00 49 F7 DE 48 8D 55 E0 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 8B D8 85 C0 0F 84 C7 00 00 00 8D 88 18 02 FF FF 83 F9 01 0F 86 B8 00 00 00 0F B7 C8 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A7 00 00 00 8B 4D E4 BA 01 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 91 00 00 00 4D 85 FF 74 03 41 89 1F 8B 4D E4 48 8D 96 F0 02 00 00 45 33 C9 41 8D 71 55 44 8B C6 E8 ?? ?? ?? ?? 48 85 FF 74 64 8B 4D E4 48 8D 97 20 01 00 00 45 33 C9 44 8B C6 E8 ?? ?? ?? ?? 8B 4D E4 BE 40 00 00 00 44 8B CE 4C 8B C7 BA 01 10 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 39 8B 4D E8 4C 8D 87 80 00 00 00 44 8B CE BA 02 10 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 1D 48 8D 97 00 01 00 00 8B CB 44 8D 4E CA 44 8D 46 D0 E8 ?? ?? ?? ?? B8 01 00 00 00 EB 02 33 C0 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 40 41 5F 41 5E 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_113_1_0 {
	meta:
		name = "_waccess_s"
		size = 170
		refs = "0009 __security_cookie 001d __doserrno 0025 _errno 0031 _invalid_parameter_noinfo 004a __imp_GetFileAttributesExW 0054 __imp_GetLastError 005b __acrt_errno_map_os_error 00a0 __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 48 8B DA 48 85 C9 75 1D E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 5E F7 C2 F9 FF FF FF 75 DB 4C 8D 44 24 20 33 D2 FF 15 ?? ?? ?? ?? 85 C0 75 16 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 EB 2F F6 44 24 20 10 75 26 F6 44 24 20 01 74 1F D1 EB F6 C3 01 74 18 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB CA 33 C0 48 8B 4C 24 48 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_114_1_0 {
	meta:
		name = "catanhl"
		size = 857
		refs = "0044 creall 005a cimagl 0068 _ldtest 00a6 __real@bff921fb54442d18 00e2 _LZero_C 00e9 __xmm@80000000000000008000000000000000 012d __real@3ff921fb54442d18 0183 __real@5fcffb3abd82527b 0191 __real@3ff0000000000000 021b _fperrraise 0228 _LInf_C 023e __real@4010000000000000 0243 sqrt 0260 log 0268 __real@4000000000000000 0274 atan2 0289 __real@3fe0000000000000 02c2 log1pl 02e7 __real@3fd0000000000000 031a _LCbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 48 8D 68 A1 48 81 EC 90 00 00 00 0F 10 02 48 8B F1 48 8D 4D D7 0F 29 70 D8 48 8B DA 0F 29 78 C8 44 0F 29 40 B8 44 0F 29 48 A8 44 0F 29 50 98 44 0F 29 58 88 F3 0F 7F 45 D7 E8 ?? ?? ?? ?? F2 0F 11 45 6F 48 8D 4D D7 0F 10 03 F3 0F 7F 45 D7 E8 ?? ?? ?? ?? 48 8D 4D 6F F2 0F 11 45 67 E8 ?? ?? ?? ?? 48 8D 4D 67 0F B7 F8 E8 ?? ?? ?? ?? 66 83 FF 02 75 3E 66 3B C7 75 07 F2 0F 10 7D 6F EB 68 BB 01 00 00 00 66 3B C3 75 1B 0F 57 FF 66 0F 2F 7D 67 0F 86 87 00 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 60 02 00 00 F2 0F 10 7D 6F 0F 28 C7 E9 53 02 00 00 BB 01 00 00 00 66 83 F8 02 75 35 66 3B FB 76 07 F2 0F 10 7D 67 EB E1 B8 00 80 00 00 66 85 45 75 74 11 F2 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? EB 03 0F 57 FF F2 0F 10 45 67 E9 13 02 00 00 66 3B FB 75 35 0F 57 FF 66 0F 2F 7D 6F 76 0F F2 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? B8 00 80 00 00 66 85 45 6D 0F 85 79 FF FF FF F2 0F 10 05 ?? ?? ?? ?? E9 D9 01 00 00 F2 44 0F 10 45 67 B8 00 80 00 00 45 0F 28 D0 F2 44 0F 10 0D ?? ?? ?? ?? 66 85 45 6D 74 04 45 0F 57 D1 F2 0F 10 55 6F 45 0F 57 DB 66 44 0F 2F DA 76 0B 41 0F 57 D1 F2 0F 11 55 6F EB 0C 45 0F 57 C1 33 DB F2 44 0F 11 45 67 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D0 76 38 F2 0F 10 3D ?? ?? ?? ?? 41 0F 28 C8 F2 0F 5E CA F2 0F 5E FA F2 0F 59 C9 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E F9 66 45 0F 2F D8 76 33 F2 0F 10 05 ?? ?? ?? ?? E9 3C 01 00 00 66 44 0F 2F D0 76 2C F2 41 0F 5E D0 0F 28 FA F2 0F 59 D2 F2 41 0F 5E F8 F2 0F 58 15 ?? ?? ?? ?? F2 0F 5E FA EB C6 F2 0F 10 05 ?? ?? ?? ?? E9 09 01 00 00 66 0F 2E 15 ?? ?? ?? ?? 0F 8A 8F 00 00 00 0F 85 89 00 00 00 66 45 0F 2E C3 7A 1E 75 1C B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 45 67 F2 0F 10 3D ?? ?? ?? ?? E9 D0 00 00 00 41 0F 28 C0 F2 41 0F 59 C0 F2 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 F0 41 0F 28 C2 E8 ?? ?? ?? ?? F2 0F 5E F0 0F 28 C6 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 28 F8 41 0F 28 C2 E8 ?? ?? ?? ?? 66 45 0F 2F D8 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 76 72 41 0F 57 C1 EB 6C F2 0F 10 35 ?? ?? ?? ?? F2 0F 5C F2 F2 45 0F 59 D2 F2 0F 59 15 ?? ?? ?? ?? 0F 28 CE F2 0F 59 CE F2 41 0F 58 CA F2 0F 5E D1 0F 28 C2 E8 ?? ?? ?? ?? F2 0F 10 4D 6F 0F 28 F8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 10 45 67 F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 3D ?? ?? ?? ?? F2 0F 59 CE F2 41 0F 5C CA E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 85 DB 74 06 41 0F 57 F9 EB 04 41 0F 57 C1 0F 28 D0 48 8D 4D D7 0F 28 CF E8 ?? ?? ?? ?? 0F 28 7C 24 70 4C 8D 9C 24 90 00 00 00 49 8B 5B 30 41 0F 28 73 F0 0F 10 00 48 8B C6 45 0F 28 43 D0 45 0F 28 4B C0 45 0F 28 53 B0 45 0F 28 5B A0 F3 0F 7F 06 49 8B E3 5F 5E 5D C3 }
	condition:
		$1
}

rule file_689_0_0 {
	meta:
		name = "catanh"
		size = 857
		refs = "0044 creal 005a cimag 0068 _dtest 00a6 __real@bff921fb54442d18 00e2 _Zero_C 00e9 __xmm@80000000000000008000000000000000 012d __real@3ff921fb54442d18 0183 __real@5fcffb3abd82527b 0191 __real@3ff0000000000000 021b _fperrraise 0228 _Inf_C 023e __real@4010000000000000 0243 sqrt 0260 log 0268 __real@4000000000000000 0274 atan2 0289 __real@3fe0000000000000 02c2 log1p 02e7 __real@3fd0000000000000 031a _Cbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 48 8D 68 A1 48 81 EC 90 00 00 00 0F 10 02 48 8B F1 48 8D 4D D7 0F 29 70 D8 48 8B DA 0F 29 78 C8 44 0F 29 40 B8 44 0F 29 48 A8 44 0F 29 50 98 44 0F 29 58 88 F3 0F 7F 45 D7 E8 ?? ?? ?? ?? F2 0F 11 45 6F 48 8D 4D D7 0F 10 03 F3 0F 7F 45 D7 E8 ?? ?? ?? ?? 48 8D 4D 6F F2 0F 11 45 67 E8 ?? ?? ?? ?? 48 8D 4D 67 0F B7 F8 E8 ?? ?? ?? ?? 66 83 FF 02 75 3E 66 3B C7 75 07 F2 0F 10 7D 6F EB 68 BB 01 00 00 00 66 3B C3 75 1B 0F 57 FF 66 0F 2F 7D 67 0F 86 87 00 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 60 02 00 00 F2 0F 10 7D 6F 0F 28 C7 E9 53 02 00 00 BB 01 00 00 00 66 83 F8 02 75 35 66 3B FB 76 07 F2 0F 10 7D 67 EB E1 B8 00 80 00 00 66 85 45 75 74 11 F2 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? EB 03 0F 57 FF F2 0F 10 45 67 E9 13 02 00 00 66 3B FB 75 35 0F 57 FF 66 0F 2F 7D 6F 76 0F F2 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? B8 00 80 00 00 66 85 45 6D 0F 85 79 FF FF FF F2 0F 10 05 ?? ?? ?? ?? E9 D9 01 00 00 F2 44 0F 10 45 67 B8 00 80 00 00 45 0F 28 D0 F2 44 0F 10 0D ?? ?? ?? ?? 66 85 45 6D 74 04 45 0F 57 D1 F2 0F 10 55 6F 45 0F 57 DB 66 44 0F 2F DA 76 0B 41 0F 57 D1 F2 0F 11 55 6F EB 0C 45 0F 57 C1 33 DB F2 44 0F 11 45 67 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D0 76 38 F2 0F 10 3D ?? ?? ?? ?? 41 0F 28 C8 F2 0F 5E CA F2 0F 5E FA F2 0F 59 C9 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E F9 66 45 0F 2F D8 76 33 F2 0F 10 05 ?? ?? ?? ?? E9 3C 01 00 00 66 44 0F 2F D0 76 2C F2 41 0F 5E D0 0F 28 FA F2 0F 59 D2 F2 41 0F 5E F8 F2 0F 58 15 ?? ?? ?? ?? F2 0F 5E FA EB C6 F2 0F 10 05 ?? ?? ?? ?? E9 09 01 00 00 66 0F 2E 15 ?? ?? ?? ?? 0F 8A 8F 00 00 00 0F 85 89 00 00 00 66 45 0F 2E C3 7A 1E 75 1C B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 45 67 F2 0F 10 3D ?? ?? ?? ?? E9 D0 00 00 00 41 0F 28 C0 F2 41 0F 59 C0 F2 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 F0 41 0F 28 C2 E8 ?? ?? ?? ?? F2 0F 5E F0 0F 28 C6 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 28 F8 41 0F 28 C2 E8 ?? ?? ?? ?? 66 45 0F 2F D8 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 76 72 41 0F 57 C1 EB 6C F2 0F 10 35 ?? ?? ?? ?? F2 0F 5C F2 F2 45 0F 59 D2 F2 0F 59 15 ?? ?? ?? ?? 0F 28 CE F2 0F 59 CE F2 41 0F 58 CA F2 0F 5E D1 0F 28 C2 E8 ?? ?? ?? ?? F2 0F 10 4D 6F 0F 28 F8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 10 45 67 F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 3D ?? ?? ?? ?? F2 0F 59 CE F2 41 0F 5C CA E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 85 DB 74 06 41 0F 57 F9 EB 04 41 0F 57 C1 0F 28 D0 48 8D 4D D7 0F 28 CF E8 ?? ?? ?? ?? 0F 28 7C 24 70 4C 8D 9C 24 90 00 00 00 49 8B 5B 30 41 0F 28 73 F0 0F 10 00 48 8B C6 45 0F 28 43 D0 45 0F 28 4B C0 45 0F 28 53 B0 45 0F 28 5B A0 F3 0F 7F 06 49 8B E3 5F 5E 5D C3 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "trunc"
		size = 33
		refs = "0012 _d_int"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_690_0_0 {
	meta:
		name = "truncl"
		size = 33
		refs = "0012 _ld_int"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "fsetpos"
		size = 53
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0031 _fseeki64"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 28 C3 48 85 D2 74 E3 48 8B 12 45 33 C0 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "_getwch"
		size = 44
		refs = "000c __acrt_lock 0012 _getwch_nolock 001f __acrt_unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 09 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 0F B7 D8 B9 09 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_117_4_0 {
	meta:
		name = "_getwche"
		size = 44
		refs = "000c __acrt_lock 0012 _getwche_nolock 001f __acrt_unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 09 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 0F B7 D8 B9 09 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_117_2_0 {
	meta:
		name = "_getwch_nolock"
		size = 286
		refs = "0018 __security_cookie 002c ?wchbuf@@3GA 0044 __dcrt_lowio_console_input_handle 004f __dcrt_lowio_initialize_console_input 0077 __imp_GetConsoleMode 0082 __imp_SetConsoleMode 009f __imp_ReadConsoleInputW 00d0 _getextendedkeycode 0104 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 48 BB FF FF 00 00 0F B7 05 ?? ?? ?? ?? 66 3B C3 74 0C 66 89 1D ?? ?? ?? ?? E9 BA 00 00 00 48 8B 3D ?? ?? ?? ?? 48 83 FF FE 75 0C E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 83 FF FF 75 08 0F B7 C3 E9 93 00 00 00 48 89 7C 24 28 48 8D 54 24 20 48 8B CF FF 15 ?? ?? ?? ?? 33 D2 48 8B CF FF 15 ?? ?? ?? ?? 90 33 F6 44 8D 76 01 4C 8D 4C 24 24 45 8B C6 48 8D 54 24 30 48 8B CF FF 15 ?? ?? ?? ?? 85 C0 74 40 39 74 24 24 74 3A 66 44 39 74 24 30 75 44 39 74 24 34 74 3E 0F B7 44 24 3E 66 85 C0 74 05 0F B7 D8 EB 1D 48 8D 4C 24 34 E8 ?? ?? ?? ?? 48 85 C0 74 20 0F B6 48 01 66 89 0D ?? ?? ?? ?? 0F B6 18 8B 54 24 20 48 8B CF FF 15 ?? ?? ?? ?? E9 67 FF FF FF EB 92 48 8B 4C 24 48 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 8B 74 24 68 48 8B 7C 24 70 48 83 C4 50 41 5E C3 }
	condition:
		$1
}

rule file_117_3_0 {
	meta:
		name = "_getwch_nolock$fin$0"
		size = 30
		refs = "0012 __imp_SetConsoleMode"
		altNames = "_getch_nolock$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 55 20 48 8B 4D 28 FF 15 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_117_6_0 {
	meta:
		name = "_getwche_nolock"
		size = 84
		refs = "000d ?wchbuf@@3GA 0025 _getwch_nolock 003a _putwch_nolock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 0F B7 05 ?? ?? ?? ?? BF FF FF 00 00 66 3B C7 74 09 66 89 3D ?? ?? ?? ?? EB 25 E8 ?? ?? ?? ?? 0F B7 D8 66 3B C7 75 05 0F B7 C7 EB 13 0F B7 CB E8 ?? ?? ?? ?? 66 3B C7 0F B7 C7 74 03 0F B7 C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_117_7_0 {
	meta:
		name = "_ungetwch"
		size = 50
		refs = "000f __acrt_lock 0018 _ungetwch_nolock 0025 __acrt_unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 0F B7 D9 B9 09 00 00 00 E8 ?? ?? ?? ?? 90 0F B7 CB E8 ?? ?? ?? ?? 0F B7 D8 B9 09 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_117_9_0 {
	meta:
		name = "_ungetwch_nolock"
		size = 38
		refs = "000d ?wchbuf@@3GA"
	strings:
		$1 = { B8 FF FF 00 00 66 3B C8 74 1B 66 39 05 ?? ?? ?? ?? 75 12 B8 FF 00 00 00 66 23 C8 66 89 0D ?? ?? ?? ?? 0F B7 C1 C3 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "asinhf"
		size = 209
		refs = "001b _fdtest 0046 __xmm@80000000800000008000000080000000 005e __real@40000000 0066 _FEps_C 0080 __real@3f800000 0085 sqrtf 009e log1pf 00a9 logf 00b1 __real@3f317218"
	strings:
		$1 = { 48 8B C4 F3 0F 11 40 08 53 48 83 EC 40 0F 29 78 E8 48 8D 48 08 44 0F 29 40 D8 E8 ?? ?? ?? ?? 0F BF C8 83 F9 02 77 0B F3 0F 10 44 24 50 E9 8E 00 00 00 F3 44 0F 10 44 24 50 0F 57 C0 41 0F 2F C0 76 16 44 0F 57 05 ?? ?? ?? ?? BB 01 00 00 00 F3 44 0F 11 44 24 50 EB 02 33 DB F3 0F 10 05 ?? ?? ?? ?? F3 0F 5E 05 ?? ?? ?? ?? 41 0F 2F C0 76 34 41 0F 28 F8 F3 41 0F 59 F8 0F 28 C7 F3 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 5E F8 F3 41 0F 58 F8 0F 28 C7 E8 ?? ?? ?? ?? EB 11 41 0F 28 C0 E8 ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? 85 DB 74 07 0F 57 05 ?? ?? ?? ?? 0F 28 7C 24 30 44 0F 28 44 24 20 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "??$convert_to_fos_high_precision@N@@YAXNIQEAHQEAD_K@Z"
		size = 4487
		refs = "001f __security_cookie 00a8 log10 00ad ceil 0477 memset 04cc memcpy 05ca _errno 05d5 _invalid_parameter_noinfo 05f6 __ImageBase 062c ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 0670 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 09f8 ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 0f81 memcpy_s 0f92 ?divide@__crt_strtox@@YA_KAEAUbig_integer@1@AEBU21@@Z 116f __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 48 F9 FF FF 48 81 EC B8 07 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 A0 06 00 00 48 8B 85 20 07 00 00 41 BF 01 00 00 00 48 89 44 24 58 4C 89 44 24 50 89 54 24 38 F2 0F 11 44 24 48 48 8B 54 24 48 4C 8B C2 4C 89 4C 24 40 49 C1 E8 34 41 B9 FF 07 00 00 4D 85 C1 0F 94 C1 8A C1 F6 D8 48 B8 00 00 00 00 00 00 10 00 48 1B FF 48 F7 D7 48 23 F8 48 B8 FF FF FF FF FF FF 0F 00 48 23 D0 48 03 FA F6 D9 1B C0 45 23 C1 F7 D8 41 03 C7 41 8D 98 CC FB FF FF 03 D8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 2C C8 89 7C 24 64 45 8D 6F 72 8D 81 01 00 00 80 83 E0 FE F7 D8 45 1B E4 48 C1 EF 20 44 23 E1 89 7C 24 68 8B C7 44 89 64 24 20 F7 D8 1B D2 45 33 F6 F7 DA 41 03 D7 89 54 24 60 85 DB 0F 88 A0 02 00 00 33 C0 C7 85 08 03 00 00 00 00 10 00 89 85 04 03 00 00 8D 70 02 89 B5 00 03 00 00 3B D6 0F 85 4A 01 00 00 45 8B C6 41 8B C8 8B 44 8C 64 39 84 8D 04 03 00 00 0F 85 33 01 00 00 45 03 C7 44 3B C6 75 E4 44 8D 5B 02 44 89 74 24 28 49 8B DF 45 8B CB 41 83 E3 1F 41 C1 E9 05 41 B8 20 00 00 00 41 8B F0 41 2B F3 8B CE 48 D3 E3 41 2B DF 0F BD C7 44 8B FB 41 F7 D7 74 04 FF C0 EB 03 41 8B C6 44 2B C0 41 8D 41 02 45 3B D8 40 0F 97 C7 41 3B C5 41 0F 97 C0 41 3B C5 75 07 B1 01 40 84 FF 75 03 41 8A CE 41 83 CD FF 45 84 C0 0F 85 8B 00 00 00 84 C9 0F 85 83 00 00 00 41 BE 72 00 00 00 41 3B C6 44 0F 42 F0 45 8B D6 45 3B F5 74 50 45 3B D1 72 4B 41 8B C2 41 2B C1 8D 48 FF 3B C2 73 07 44 8B 44 84 64 EB 03 45 33 C0 3B CA 73 06 8B 54 8C 64 EB 02 33 D2 41 23 D7 41 8B C2 8B CE 44 23 C3 D3 EA 45 03 D5 41 8B CB 41 D3 E0 41 0B D0 89 54 84 64 45 3B D5 74 06 8B 54 24 60 EB B0 33 C9 45 85 C9 74 0C 83 64 8C 64 00 FF C1 41 3B C9 75 F4 40 84 FF 41 8D 46 01 44 0F 45 F0 83 A5 08 03 00 00 00 41 BF 01 00 00 00 44 89 BD 30 01 00 00 44 89 74 24 60 C7 85 00 03 00 00 01 00 00 00 C7 85 34 01 00 00 04 00 00 00 E9 7E 03 00 00 44 8D 5B 01 44 89 74 24 28 45 8B CB 8D 42 FF 41 83 E3 1F 41 C1 E9 05 41 B8 20 00 00 00 49 8B DF 41 8B F8 41 2B FB 8B CF 48 D3 E3 41 2B DF 8B C8 0F BD 44 84 64 44 8B E3 41 F7 D4 74 04 FF C0 EB 03 41 8B C6 44 2B C0 42 8D 04 0A 45 3B D8 41 0F 97 C7 41 3B C5 41 0F 97 C0 41 3B C5 75 07 B1 01 45 84 FF 75 03 41 8A CE 41 83 CD FF 45 84 C0 0F 85 8B 00 00 00 84 C9 0F 85 83 00 00 00 41 BE 72 00 00 00 41 3B C6 44 0F 42 F0 45 8B D6 45 3B F5 74 50 45 3B D1 72 4B 41 8B C2 41 2B C1 8D 48 FF 3B C2 73 07 44 8B 44 84 64 EB 03 45 33 C0 3B CA 73 06 8B 54 8C 64 EB 02 33 D2 41 23 D4 41 8B C2 8B CF 44 23 C3 D3 EA 45 03 D5 41 8B CB 41 D3 E0 41 0B D0 89 54 84 64 45 3B D5 74 06 8B 54 24 60 EB B0 33 C9 45 85 C9 74 0C 83 64 8C 64 00 FF C1 41 3B C9 75 F4 45 84 FF 41 8D 46 01 44 0F 45 F0 83 A5 08 03 00 00 00 41 BF 01 00 00 00 44 8B 64 24 20 44 89 BD 30 01 00 00 44 89 74 24 60 C7 85 00 03 00 00 01 00 00 00 89 B5 34 01 00 00 E9 4B 02 00 00 81 FB 02 FC FF FF 0F 84 34 01 00 00 33 C0 C7 85 08 03 00 00 00 00 10 00 89 85 04 03 00 00 8D 70 02 89 B5 00 03 00 00 3B D6 0F 85 11 01 00 00 45 8B C6 41 8B C8 8B 44 8C 64 39 84 8D 04 03 00 00 0F 85 FA 00 00 00 45 03 C7 44 3B C6 75 E4 0F BD C7 44 89 74 24 28 74 04 FF C0 EB 03 41 8B C6 41 B8 20 00 00 00 8B CE 44 2B C0 44 3B C6 41 0F 92 C2 41 83 CD FF 44 8D 41 FF 3B CA 73 09 8B C1 44 8B 4C 84 64 EB 03 45 8B CE 44 3B C2 73 07 42 8B 54 84 64 EB 03 41 8B D6 41 8B C1 C1 EA 1E C1 E0 02 33 D0 8B C1 41 03 CD 89 54 84 64 41 3B CD 74 06 8B 54 24 60 EB BE 41 F6 DA 48 8D 8D 04 03 00 00 45 1B F6 33 D2 41 F7 DE 44 03 F6 2B F3 8B FE 44 89 74 24 60 C1 EF 05 8B DF 48 C1 E3 02 4C 8B C3 E8 ?? ?? ?? ?? 83 E6 1F 41 8B C7 40 8A CE 44 8D 7F 01 D3 E0 89 84 1D 04 03 00 00 45 8B C7 49 C1 E0 02 44 89 BD 00 03 00 00 44 89 BD 30 01 00 00 4D 85 C0 0F 84 31 01 00 00 BB CC 01 00 00 48 8D 8D 34 01 00 00 4C 3B C3 0F 87 FB 00 00 00 48 8D 95 04 03 00 00 E8 ?? ?? ?? ?? E9 04 01 00 00 8D 42 FF 44 89 74 24 28 8B C8 0F BD 44 84 64 74 04 FF C0 EB 03 41 8B C6 41 B8 20 00 00 00 44 2B C0 45 3B C7 41 0F 92 C2 41 3B D5 0F 97 C1 41 3B D5 75 08 41 8A C7 45 84 D2 75 03 41 8A C6 41 83 CD FF 84 C9 75 63 84 C0 75 5F 41 BE 72 00 00 00 41 3B D6 44 0F 42 F2 41 8B CE 45 3B F5 74 3F 44 8D 41 FF 3B CA 73 09 8B C1 44 8B 4C 84 64 EB 03 45 33 C9 44 3B C2 73 07 42 8B 54 84 64 EB 02 33 D2 C1 EA 1F 43 8D 04 09 33 D0 8B C1 41 03 CD 89 54 84 64 41 3B CD 74 06 8B 54 24 60 EB C1 45 84 D2 41 8D 46 01 44 0F 45 F0 41 8B FF 44 89 74 24 60 2B FB 48 8D 8D 04 03 00 00 8B F7 33 D2 C1 EE 05 8B DE 48 C1 E3 02 4C 8B C3 E8 ?? ?? ?? ?? 83 E7 1F 41 8B C7 40 8A CF 44 8D 7E 01 D3 E0 89 84 1D 04 03 00 00 E9 D2 FE FF FF 4C 8B C3 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 30 01 00 00 B8 CD CC CC CC 45 85 E4 0F 88 A8 04 00 00 41 F7 E4 8B C2 48 8D 15 ?? ?? ?? ?? C1 E8 03 89 44 24 34 44 8B E0 89 44 24 24 85 C0 0F 84 CF 03 00 00 B8 26 00 00 00 45 8B EC 44 3B E0 44 0F 47 E8 44 89 6C 24 30 41 8D 45 FF 0F B6 8C 82 ?? ?? ?? ?? 0F B6 B4 82 ?? ?? ?? ?? 8B D9 8B F8 33 D2 48 C1 E3 02 4C 8B C3 8D 04 0E 48 8D 8D 04 03 00 00 89 85 00 03 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 C1 E6 02 0F B7 84 B9 ?? ?? ?? ?? 48 8D 91 ?? ?? ?? ?? 48 8D 8D 04 03 00 00 4C 8B C6 48 03 CB 48 8D 14 82 E8 ?? ?? ?? ?? 44 8B 9D 00 03 00 00 41 83 FB 01 0F 87 A2 00 00 00 8B 85 04 03 00 00 85 C0 75 0F 45 33 FF 44 89 BD 30 01 00 00 E9 08 03 00 00 83 F8 01 0F 84 FF 02 00 00 45 85 FF 0F 84 F6 02 00 00 45 33 C0 4C 8B D0 45 33 C9 42 8B 8C 8D 34 01 00 00 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 8C 8D 34 01 00 00 49 C1 E8 20 41 FF C1 45 3B CF 75 D7 45 85 C0 74 34 83 BD 30 01 00 00 73 73 1A 8B 85 30 01 00 00 44 89 84 85 34 01 00 00 44 8B BD 30 01 00 00 41 FF C7 EB 88 45 33 FF 44 89 BD 30 01 00 00 32 C0 E9 8D 02 00 00 44 8B BD 30 01 00 00 E9 7F 02 00 00 41 83 FF 01 0F 87 AD 00 00 00 8B 9D 34 01 00 00 4D 8B C3 49 C1 E0 02 45 8B FB 44 89 9D 30 01 00 00 4D 85 C0 74 40 B8 CC 01 00 00 48 8D 8D 34 01 00 00 4C 3B C0 77 0E 48 8D 95 04 03 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 30 01 00 00 85 DB 0F 84 FA FE FF FF 83 FB 01 0F 84 08 02 00 00 45 85 FF 0F 84 FF 01 00 00 45 33 C0 4C 8B D3 45 33 C9 42 8B 8C 8D 34 01 00 00 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 8C 8D 34 01 00 00 49 C1 E8 20 41 FF C1 45 3B CF 75 D7 E9 04 FF FF FF 45 3B DF 48 8D 8D 34 01 00 00 45 8B E7 4C 8D AD 04 03 00 00 0F 92 C0 48 8D 95 34 01 00 00 84 C0 4C 0F 44 E9 45 0F 45 E3 45 0F 45 DF 48 8D 8D 04 03 00 00 48 0F 44 D1 45 33 FF 45 33 D2 48 89 54 24 28 44 89 BD D0 04 00 00 45 85 E4 0F 84 19 01 00 00 43 8B 74 95 00 41 8B C2 85 F6 75 21 45 3B D7 0F 85 F8 00 00 00 42 21 B4 95 D4 04 00 00 45 8D 7A 01 44 89 BD D0 04 00 00 E9 E0 00 00 00 33 DB 45 8B CA 45 85 DB 0F 84 C3 00 00 00 41 8B FA F7 DF 41 83 F9 73 74 66 45 3B CF 75 1A 41 8B C1 8D 4F 01 83 A4 85 D4 04 00 00 00 43 8D 04 11 03 C8 89 8D D0 04 00 00 41 8D 04 39 45 8B C1 8B 14 82 41 FF C1 8B C3 48 0F AF D6 48 03 D0 42 8B 84 85 D4 04 00 00 48 03 D0 41 8D 04 39 48 8B DA 42 89 94 85 D4 04 00 00 44 8B BD D0 04 00 00 48 C1 EB 20 41 3B C3 74 07 48 8B 54 24 28 EB 94 85 DB 74 4E 41 83 F9 73 0F 84 6C 01 00 00 45 3B CF 75 15 41 8B C1 83 A4 85 D4 04 00 00 00 41 8D 41 01 89 85 D0 04 00 00 41 8B C9 41 FF C1 8B D3 8B 84 8D D4 04 00 00 48 03 D0 89 94 8D D4 04 00 00 44 8B BD D0 04 00 00 48 C1 EA 20 8B DA 85 D2 75 B2 41 83 F9 73 0F 84 1E 01 00 00 48 8B 54 24 28 41 FF C2 45 3B D4 0F 85 E7 FE FF FF 45 8B C7 49 C1 E0 02 44 89 BD 30 01 00 00 4D 85 C0 74 40 B8 CC 01 00 00 48 8D 8D 34 01 00 00 4C 3B C0 77 0E 48 8D 95 D4 04 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 30 01 00 00 44 8B 64 24 24 44 8B 6C 24 30 B0 01 84 C0 0F 84 A6 00 00 00 45 2B E5 48 8D 15 ?? ?? ?? ?? 44 89 64 24 24 0F 85 35 FC FF FF 8B 44 24 34 8B 7C 24 20 8D 04 80 03 C0 8B CF 2B C8 0F 84 1F 05 00 00 8D 41 FF 8B 84 82 ?? ?? ?? ?? 85 C0 74 7B 83 F8 01 0F 84 08 05 00 00 45 85 FF 0F 84 FF 04 00 00 45 33 C0 44 8B D0 45 33 C9 42 8B 8C 8D 34 01 00 00 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 8C 8D 34 01 00 00 49 C1 E8 20 41 FF C1 45 3B CF 75 D7 45 85 C0 74 41 83 BD 30 01 00 00 73 73 29 8B 85 30 01 00 00 44 89 84 85 34 01 00 00 44 8B BD 30 01 00 00 41 FF C7 EB 12 45 33 FF 44 89 BD 30 01 00 00 E9 92 04 00 00 45 33 FF 44 89 BD 30 01 00 00 E9 87 04 00 00 44 8B BD 30 01 00 00 E9 7B 04 00 00 41 8B CC F7 D9 F7 E1 89 4C 24 30 8B C2 48 8D 15 ?? ?? ?? ?? C1 E8 03 89 44 24 28 44 8B E0 89 44 24 24 85 C0 0F 84 A6 03 00 00 B8 26 00 00 00 45 8B EC 44 3B E0 44 0F 47 E8 44 89 6C 24 34 41 8D 45 FF 0F B6 8C 82 ?? ?? ?? ?? 0F B6 B4 82 ?? ?? ?? ?? 8B D9 8B F8 33 D2 48 C1 E3 02 4C 8B C3 8D 04 0E 48 8D 8D 04 03 00 00 89 85 00 03 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 C1 E6 02 0F B7 84 B9 ?? ?? ?? ?? 48 8D 91 ?? ?? ?? ?? 48 8D 8D 04 03 00 00 4C 8B C6 48 03 CB 48 8D 14 82 E8 ?? ?? ?? ?? 44 8B 9D 00 03 00 00 41 83 FB 01 0F 87 8D 00 00 00 8B 85 04 03 00 00 85 C0 75 0D 45 33 F6 44 89 74 24 60 E9 DD 02 00 00 83 F8 01 0F 84 D4 02 00 00 45 85 F6 0F 84 CB 02 00 00 45 33 C0 4C 8B D0 45 33 C9 42 8B 4C 8C 64 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 4C 8C 64 49 C1 E8 20 41 FF C1 45 3B CE 75 DD 45 85 C0 74 29 83 7C 24 60 73 73 13 8B 44 24 60 44 89 44 84 64 44 8B 74 24 60 41 FF C6 EB 99 45 33 F6 44 89 74 24 60 32 C0 E9 73 02 00 00 44 8B 74 24 60 E9 67 02 00 00 41 83 FE 01 0F 87 9F 00 00 00 8B 5C 24 64 4D 8B C3 49 C1 E0 02 45 8B F3 44 89 5C 24 60 4D 85 C0 74 3C B8 CC 01 00 00 48 8D 4C 24 64 4C 3B C0 77 0E 48 8D 95 04 03 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B 74 24 60 85 DB 0F 84 17 FF FF FF 83 FB 01 0F 84 F8 01 00 00 45 85 F6 0F 84 EF 01 00 00 45 33 C0 4C 8B D3 45 33 C9 42 8B 4C 8C 64 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 4C 8C 64 49 C1 E8 20 41 FF C1 45 3B CE 75 DD E9 1F FF FF FF 45 3B DE 48 8D 4C 24 64 45 8B E6 4C 8D AD 04 03 00 00 0F 92 C0 48 8D 54 24 64 84 C0 4C 0F 44 E9 45 0F 45 E3 45 0F 45 DE 48 8D 8D 04 03 00 00 48 0F 44 D1 45 33 F6 45 33 D2 48 89 54 24 48 44 89 B5 D0 04 00 00 45 85 E4 0F 84 19 01 00 00 43 8B 74 95 00 41 8B C2 85 F6 75 21 45 3B D6 0F 85 F8 00 00 00 42 21 B4 95 D4 04 00 00 45 8D 72 01 44 89 B5 D0 04 00 00 E9 E0 00 00 00 33 DB 45 8B CA 45 85 DB 0F 84 C3 00 00 00 41 8B FA F7 DF 41 83 F9 73 74 66 45 3B CE 75 1A 41 8B C1 8D 4F 01 83 A4 85 D4 04 00 00 00 43 8D 04 11 03 C8 89 8D D0 04 00 00 41 8D 04 39 45 8B C1 8B 14 82 41 FF C1 8B C3 48 0F AF D6 48 03 D0 42 8B 84 85 D4 04 00 00 48 03 D0 41 8D 04 39 48 8B DA 42 89 94 85 D4 04 00 00 44 8B B5 D0 04 00 00 48 C1 EB 20 41 3B C3 74 07 48 8B 54 24 48 EB 94 85 DB 74 4E 41 83 F9 73 0F 84 5A 01 00 00 45 3B CE 75 15 41 8B C1 83 A4 85 D4 04 00 00 00 41 8D 41 01 89 85 D0 04 00 00 41 8B C9 41 FF C1 8B D3 8B 84 8D D4 04 00 00 48 03 D0 89 94 8D D4 04 00 00 44 8B B5 D0 04 00 00 48 C1 EA 20 8B DA 85 D2 75 B2 41 83 F9 73 0F 84 0C 01 00 00 48 8B 54 24 48 41 FF C2 45 3B D4 0F 85 E7 FE FF FF 45 8B C6 49 C1 E0 02 44 89 74 24 60 4D 85 C0 74 3C B8 CC 01 00 00 48 8D 4C 24 64 4C 3B C0 77 0E 48 8D 95 D4 04 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B 74 24 60 44 8B 64 24 24 44 8B 6C 24 34 B0 01 84 C0 0F 84 9A 00 00 00 45 2B E5 48 8D 15 ?? ?? ?? ?? 44 89 64 24 24 0F 85 62 FC FF FF 8B 4C 24 30 8B 44 24 28 8D 04 80 03 C0 2B C8 0F 84 9A 00 00 00 8D 41 FF 8B 84 82 ?? ?? ?? ?? 85 C0 74 62 83 F8 01 0F 84 83 00 00 00 45 85 F6 74 7E 45 33 C0 44 8B D0 45 33 C9 42 8B 4C 8C 64 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 4C 8C 64 49 C1 E8 20 41 FF C1 45 3B CE 75 DD 45 85 C0 74 48 83 7C 24 60 73 8B 7C 24 20 73 2E 8B 44 24 60 44 89 44 84 64 44 8B 74 24 60 41 FF C6 44 89 74 24 60 EB 2E 48 8B 74 24 40 83 64 24 60 00 48 8B DE 8B 7C 24 20 E9 8C 00 00 00 48 8B 74 24 40 83 64 24 60 00 48 8B DE EB 7D 44 8B 74 24 60 8B 7C 24 20 48 8B 74 24 40 48 8B DE 45 85 F6 74 67 45 33 C0 45 33 C9 42 8B 44 8C 64 48 8D 0C 80 41 8B C0 4C 8D 04 48 46 89 44 8C 64 41 FF C1 49 C1 E8 20 45 3B CE 75 DF 45 85 C0 74 3B 83 7C 24 60 73 73 0F 8B 44 24 60 44 89 44 84 64 FF 44 24 60 EB 25 83 A5 00 03 00 00 00 4C 8D 85 04 03 00 00 83 64 24 60 00 48 8D 4C 24 64 45 33 C9 BA CC 01 00 00 E8 ?? ?? ?? ?? 48 8D 95 30 01 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 83 F8 0A 0F 85 8E 00 00 00 FF C7 C6 06 31 48 8D 5E 01 45 85 FF 0F 84 8C 00 00 00 45 33 C0 45 33 C9 42 8B 84 8D 34 01 00 00 48 8D 0C 80 41 8B C0 4C 8D 04 48 46 89 84 8D 34 01 00 00 41 FF C1 49 C1 E8 20 45 3B CF 75 D9 45 85 C0 74 5A 83 BD 30 01 00 00 73 73 16 8B 85 30 01 00 00 44 89 84 85 34 01 00 00 FF 85 30 01 00 00 }
	condition:
		$1
}

rule file_119_3_0 {
	meta:
		name = "??0scoped_fp_state_reset@?A0x71ca7cfb@@QEAA@XZ"
		size = 50
		refs = "000a fegetenv 0021 feholdexcept"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 8B 03 83 E0 1F 3C 1F 75 06 C6 43 08 00 EB 0C 48 8B CB E8 ?? ?? ?? ?? C6 43 08 01 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_119_4_0 {
	meta:
		name = "??1scoped_fp_state_reset@?A0x71ca7cfb@@QEAA@XZ"
		size = 20
		refs = "000b fesetenv"
	strings:
		$1 = { 48 83 EC 28 80 79 08 00 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_6_0 {
	meta:
		name = "??8__crt_strtox@@YA_NAEBUbig_integer@0@0@Z"
		size = 62
	strings:
		$1 = { 44 8B 01 4C 8B CA 4C 8B D1 44 3B 02 74 03 32 C0 C3 33 C0 45 85 C0 74 23 0F 1F 84 00 00 00 00 00 48 8D 14 85 00 00 00 00 42 8B 4C 0A 04 42 39 4C 12 04 75 DA FF C0 41 3B C0 75 E5 B0 01 C3 }
	condition:
		$1
}

rule file_119_7_0 {
	meta:
		name = "??9__crt_strtox@@YA_NAEBUbig_integer@0@0@Z"
		size = 70
	strings:
		$1 = { 44 8B 02 45 33 DB 4C 8B CA 4C 8B D1 44 3B 01 74 08 32 C0 84 C0 0F 94 C0 C3 41 8B C3 45 85 C0 74 1D 8B C8 48 8D 14 8D 00 00 00 00 42 8B 4C 12 04 42 39 4C 0A 04 75 DA FF C0 41 3B C0 75 E3 B0 01 84 C0 0F 94 C0 C3 }
	condition:
		$1
}

rule file_119_8_0 {
	meta:
		name = "?__acrt_fp_classify@@YA?AW4__acrt_fp_class@@AEBN@Z"
		size = 101
	strings:
		$1 = { 48 8B 11 B9 FF 07 00 00 48 8B C2 48 C1 E8 34 48 23 C1 48 3B C1 74 03 33 C0 C3 48 B9 FF FF FF FF FF FF 0F 00 48 8B C2 48 23 C1 75 06 B8 01 00 00 00 C3 48 B9 00 00 00 00 00 00 00 80 48 85 D1 74 15 48 B9 00 00 00 00 00 00 08 00 48 3B C1 75 06 B8 04 00 00 00 C3 48 C1 EA 33 F7 D2 83 E2 01 83 CA 02 8B C2 C3 }
	condition:
		$1
}

rule file_119_16_0 {
	meta:
		name = "?make_big_integer_power_of_two@__crt_strtox@@YA?AUbig_integer@1@I@Z"
		size = 103
		refs = "0031 memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 8B F2 8B FA 4C 8B F1 C1 EE 05 48 83 C1 04 33 D2 48 8D 1C B5 00 00 00 00 4C 8B C3 E8 ?? ?? ?? ?? 83 E7 1F B8 01 00 00 00 40 0F B6 CF 48 8B 7C 24 40 D3 E0 42 89 44 33 04 8D 46 01 48 8B 5C 24 30 48 8B 74 24 38 41 89 06 49 8B C6 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_119_23_0 {
	meta:
		name = "__acrt_fltout"
		size = 4893
		refs = "001f __security_cookie 004a fegetenv 006c feholdexcept 00c8 ??_C@_01GBGANLPD@0?$AA@ 00d5 strcpy_s 00ec ?__acrt_fp_classify@@YA?AW4__acrt_fp_class@@AEBN@Z 018b log10 0190 ceil 054a memset 059f memcpy 069a _errno 06a5 _invalid_parameter_noinfo 06c8 __ImageBase 06fe ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 0742 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 0acd ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 1019 memcpy_s 1029 ?divide@__crt_strtox@@YA_KAEAUbig_integer@1@AEBU21@@Z 120a ??_C@_05PHHOCPM@1?$CDIND?$AA@ 1229 ??_C@_06PGGFOGJG@1?$CDSNAN?$AA@ 1248 ??_C@_06IMKFLFPG@1?$CDQNAN?$AA@ 1267 ??_C@_05DNEBIAHO@1?$CDINF?$AA@ 1288 fesetenv 1297 __security_check_cookie 12c0 _invoke_watson"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 28 F9 FF FF 48 81 EC D8 07 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 C0 06 00 00 48 89 4C 24 30 4D 8B E9 48 8D 4C 24 60 4C 89 4C 24 50 4D 8B F0 4C 89 44 24 70 8B F2 E8 ?? ?? ?? ?? 8B 44 24 60 41 BF 01 00 00 00 83 E0 1F 3C 1F 75 07 C6 44 24 68 00 EB 0F 48 8D 4C 24 60 E8 ?? ?? ?? ?? 44 88 7C 24 68 48 8B 5C 24 30 48 B9 00 00 00 00 00 00 00 80 48 8B C3 4D 89 6E 08 48 23 C1 BF 20 00 00 00 48 F7 D8 49 BC FF FF FF FF FF FF 0F 00 48 B8 00 00 00 00 00 00 F0 7F 1B C9 83 E1 0D 03 CF 41 89 0E 48 85 D8 75 2D 49 85 DC 75 28 48 8B 95 40 07 00 00 4C 8D 05 ?? ?? ?? ?? 41 83 66 04 00 49 8B CD E8 ?? ?? ?? ?? 85 C0 0F 84 9A 11 00 00 E9 C9 11 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 04 45 89 7E 04 41 2B C7 0F 84 5C 11 00 00 41 2B C7 0F 84 34 11 00 00 41 2B C7 0F 84 0C 11 00 00 41 3B C7 0F 84 E4 10 00 00 48 B8 FF FF FF FF FF FF FF 7F 41 B9 FF 07 00 00 48 23 D8 FF C6 48 89 5C 24 30 F2 0F 10 44 24 30 F2 0F 11 44 24 58 48 8B 54 24 58 4C 8B C2 89 74 24 48 49 C1 E8 34 4D 85 C1 0F 94 C1 8A C1 F6 D8 48 B8 00 00 00 00 00 00 10 00 4D 1B F6 49 23 D4 49 F7 D6 4C 23 F0 4C 03 F2 F6 D9 1B C0 45 23 C1 F7 D8 41 03 C7 41 8D 98 CC FB FF FF 03 D8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 2C C8 44 89 75 84 8D 81 01 00 00 80 83 E0 FE F7 D8 1B C0 49 C1 EE 20 23 C1 44 89 75 88 89 44 24 38 41 8B C6 F7 D8 1B D2 45 33 D2 F7 DA 41 03 D7 89 55 80 85 DB 0F 88 A1 02 00 00 33 C0 C7 85 28 03 00 00 00 00 10 00 89 85 24 03 00 00 8D 70 02 89 B5 20 03 00 00 3B D6 0F 85 46 01 00 00 45 8B C2 41 8B C8 8B 44 8D 84 39 84 8D 24 03 00 00 0F 85 2F 01 00 00 45 03 C7 44 3B C6 75 E4 44 8D 5B 02 44 89 54 24 30 49 8B DF 45 8B C3 41 83 E3 1F 41 C1 E8 05 8B F7 41 2B F3 8B CE 48 D3 E3 41 2B DF 41 0F BD C6 44 8B FB 41 F7 D7 74 04 FF C0 EB 03 41 8B C2 2B F8 41 8D 40 02 44 3B DF 40 0F 97 C7 83 F8 73 41 0F 97 C1 83 F8 73 75 07 B1 01 40 84 FF 75 03 41 8A CA 41 83 CC FF 45 84 C9 0F 85 8C 00 00 00 84 C9 0F 85 84 00 00 00 41 BE 72 00 00 00 41 3B C6 44 0F 42 F0 45 8B D6 45 3B F4 74 4F 45 3B D0 72 4A 41 8B C2 41 2B C0 8D 48 FF 3B C2 73 07 44 8B 4C 85 84 EB 03 45 33 C9 3B CA 73 06 8B 54 8D 84 EB 02 33 D2 41 23 D7 41 8B C2 8B CE 44 23 CB D3 EA 45 03 D4 41 8B CB 41 D3 E1 41 0B D1 89 54 85 84 45 3B D4 74 05 8B 55 80 EB B1 33 C9 45 85 C0 74 0C 83 64 8D 84 00 FF C1 41 3B C8 75 F4 40 84 FF 41 8D 46 01 44 0F 45 F0 EB 03 45 33 F6 83 A5 28 03 00 00 00 41 BF 01 00 00 00 44 89 BD 50 01 00 00 44 89 75 80 C7 85 20 03 00 00 01 00 00 00 C7 85 54 01 00 00 04 00 00 00 E9 76 03 00 00 44 8D 5B 01 44 89 54 24 30 45 8B CB 8D 42 FF 41 83 E3 1F 41 C1 E9 05 44 8B FF BB 01 00 00 00 45 2B FB 41 8B CF 48 D3 E3 FF CB 8B C8 0F BD 44 85 84 44 8B E3 41 F7 D4 74 04 FF C0 EB 03 41 8B C2 2B F8 42 8D 04 0A 44 3B DF 40 0F 97 C7 83 F8 73 41 0F 97 C0 83 F8 73 75 07 B1 01 40 84 FF 75 03 41 8A CA 45 84 C0 0F 85 9C 00 00 00 84 C9 0F 85 94 00 00 00 41 BE 72 00 00 00 41 3B C6 44 0F 42 F0 45 8B D6 41 83 FE FF 74 54 45 3B D1 72 4F 41 8B C2 41 2B C1 8D 48 FF 3B C2 73 07 44 8B 44 85 84 EB 03 45 33 C0 3B CA 73 06 8B 54 8D 84 EB 02 33 D2 44 23 C3 41 8B C2 41 8B CB 41 23 D4 41 D3 E0 41 8B CF D3 EA 44 0B C2 44 89 44 85 84 83 C8 FF 44 03 D0 44 3B D0 74 05 8B 55 80 EB AC 45 33 D2 41 8B CA 45 85 C9 74 0E 8B C1 FF C1 44 89 54 85 84 41 3B C9 75 F2 40 84 FF 41 8D 46 01 44 0F 45 F0 44 89 75 80 EB 07 45 8B F2 44 89 55 80 41 BF 01 00 00 00 44 89 95 28 03 00 00 44 89 BD 50 01 00 00 C7 85 20 03 00 00 01 00 00 00 89 B5 54 01 00 00 E9 3E 02 00 00 81 FB 02 FC FF FF 0F 84 2A 01 00 00 33 C0 C7 85 28 03 00 00 00 00 10 00 89 85 24 03 00 00 8D 70 02 89 B5 20 03 00 00 3B D6 0F 85 07 01 00 00 45 8B C2 41 8B C8 8B 44 8D 84 39 84 8D 24 03 00 00 0F 85 F0 00 00 00 45 03 C7 44 3B C6 75 E4 41 0F BD C6 44 89 54 24 30 74 04 FF C0 EB 03 41 8B C2 2B F8 8B CE 3B FE 41 0F 92 C2 41 83 CC FF 44 8D 41 FF 3B CA 73 09 8B C1 44 8B 4C 85 84 EB 03 45 33 C9 44 3B C2 73 07 42 8B 54 85 84 EB 02 33 D2 41 8B C1 C1 EA 1E C1 E0 02 33 D0 8B C1 41 03 CC 89 54 85 84 41 3B CC 74 05 8B 55 80 EB C0 41 F6 DA 48 8D 8D 24 03 00 00 45 1B F6 33 D2 41 F7 DE 44 03 F6 2B F3 8B FE 44 89 75 80 C1 EF 05 8B DF 48 C1 E3 02 4C 8B C3 E8 ?? ?? ?? ?? 83 E6 1F 41 8B C7 40 8A CE 44 8D 7F 01 D3 E0 89 84 1D 24 03 00 00 45 8B C7 49 C1 E0 02 44 89 BD 20 03 00 00 44 89 BD 50 01 00 00 4D 85 C0 0F 84 2E 01 00 00 BB CC 01 00 00 48 8D 8D 54 01 00 00 4C 3B C3 0F 87 F8 00 00 00 48 8D 95 24 03 00 00 E8 ?? ?? ?? ?? E9 01 01 00 00 8D 42 FF 44 89 54 24 30 8B C8 0F BD 44 85 84 74 04 FF C0 EB 03 41 8B C2 2B F8 41 3B FF 41 0F 92 C2 83 FA 73 0F 97 C1 83 FA 73 75 0A 45 84 D2 74 05 41 8A C7 EB 02 32 C0 41 83 CC FF 84 C9 75 64 84 C0 75 60 41 BE 72 00 00 00 41 3B D6 44 0F 42 F2 41 8B CE 45 3B F4 74 3E 44 8D 41 FF 3B CA 73 09 8B C1 44 8B 4C 85 84 EB 03 45 33 C9 44 3B C2 73 07 42 8B 54 85 84 EB 02 33 D2 C1 EA 1F 43 8D 04 09 33 D0 8B C1 41 03 CC 89 54 85 84 41 3B CC 74 05 8B 55 80 EB C2 45 84 D2 41 8D 46 01 44 0F 45 F0 EB 03 45 33 F6 41 8B FF 44 89 75 80 2B FB 48 8D 8D 24 03 00 00 8B F7 33 D2 C1 EE 05 8B DE 48 C1 E3 02 4C 8B C3 E8 ?? ?? ?? ?? 83 E7 1F 41 8B C7 40 8A CF 44 8D 7E 01 D3 E0 89 84 1D 24 03 00 00 E9 D5 FE FF FF 4C 8B C3 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 50 01 00 00 8B 4C 24 38 B8 CD CC CC CC 85 C9 0F 88 B3 04 00 00 F7 E1 8B C2 48 8D 15 ?? ?? ?? ?? C1 E8 03 89 44 24 44 44 8B E0 89 44 24 3C 85 C0 0F 84 D8 03 00 00 B8 26 00 00 00 45 8B EC 44 3B E0 44 0F 47 E8 44 89 6C 24 40 41 8D 45 FF 0F B6 8C 82 ?? ?? ?? ?? 0F B6 B4 82 ?? ?? ?? ?? 8B D9 8B F8 33 D2 48 C1 E3 02 4C 8B C3 8D 04 0E 48 8D 8D 24 03 00 00 89 85 20 03 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 C1 E6 02 0F B7 84 B9 ?? ?? ?? ?? 48 8D 91 ?? ?? ?? ?? 48 8D 8D 24 03 00 00 4C 8B C6 48 03 CB 48 8D 14 82 E8 ?? ?? ?? ?? 44 8B 9D 20 03 00 00 41 83 FB 01 0F 87 A2 00 00 00 8B 85 24 03 00 00 85 C0 75 0F 45 33 FF 44 89 BD 50 01 00 00 E9 08 03 00 00 83 F8 01 0F 84 FF 02 00 00 45 85 FF 0F 84 F6 02 00 00 45 33 C0 4C 8B D0 45 33 C9 42 8B 8C 8D 54 01 00 00 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 8C 8D 54 01 00 00 49 C1 E8 20 41 FF C1 45 3B CF 75 D7 45 85 C0 74 34 83 BD 50 01 00 00 73 73 1A 8B 85 50 01 00 00 44 89 84 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 EB 88 45 33 FF 44 89 BD 50 01 00 00 32 C0 E9 8D 02 00 00 44 8B BD 50 01 00 00 E9 7F 02 00 00 41 83 FF 01 0F 87 AD 00 00 00 8B 9D 54 01 00 00 4D 8B C3 49 C1 E0 02 45 8B FB 44 89 9D 50 01 00 00 4D 85 C0 74 40 B8 CC 01 00 00 48 8D 8D 54 01 00 00 4C 3B C0 77 0E 48 8D 95 24 03 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 50 01 00 00 85 DB 0F 84 FA FE FF FF 83 FB 01 0F 84 08 02 00 00 45 85 FF 0F 84 FF 01 00 00 45 33 C0 4C 8B D3 45 33 C9 42 8B 8C 8D 54 01 00 00 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 8C 8D 54 01 00 00 49 C1 E8 20 41 FF C1 45 3B CF 75 D7 E9 04 FF FF FF 45 3B DF 48 8D 8D 54 01 00 00 45 8B E7 4C 8D AD 24 03 00 00 0F 92 C0 48 8D 95 54 01 00 00 84 C0 4C 0F 44 E9 45 0F 45 E3 45 0F 45 DF 48 8D 8D 24 03 00 00 48 0F 44 D1 45 33 FF 45 33 D2 48 89 54 24 30 44 89 BD F0 04 00 00 45 85 E4 0F 84 19 01 00 00 43 8B 74 95 00 41 8B C2 85 F6 75 21 45 3B D7 0F 85 F8 00 00 00 42 21 B4 95 F4 04 00 00 45 8D 7A 01 44 89 BD F0 04 00 00 E9 E0 00 00 00 33 DB 45 8B CA 45 85 DB 0F 84 C3 00 00 00 41 8B FA F7 DF 41 83 F9 73 74 66 45 3B CF 75 1A 41 8B C1 8D 4F 01 83 A4 85 F4 04 00 00 00 43 8D 04 11 03 C8 89 8D F0 04 00 00 41 8D 04 39 45 8B C1 8B 14 82 41 FF C1 8B C3 48 0F AF D6 48 03 D0 42 8B 84 85 F4 04 00 00 48 03 D0 41 8D 04 39 48 8B DA 42 89 94 85 F4 04 00 00 44 8B BD F0 04 00 00 48 C1 EB 20 41 3B C3 74 07 48 8B 54 24 30 EB 94 85 DB 74 4E 41 83 F9 73 0F 84 73 01 00 00 45 3B CF 75 15 41 8B C1 83 A4 85 F4 04 00 00 00 41 8D 41 01 89 85 F0 04 00 00 41 8B C9 41 FF C1 8B D3 8B 84 8D F4 04 00 00 48 03 D0 89 94 8D F4 04 00 00 44 8B BD F0 04 00 00 48 C1 EA 20 8B DA 85 D2 75 B2 41 83 F9 73 0F 84 25 01 00 00 48 8B 54 24 30 41 FF C2 45 3B D4 0F 85 E7 FE FF FF 45 8B C7 49 C1 E0 02 44 89 BD 50 01 00 00 4D 85 C0 74 40 B8 CC 01 00 00 48 8D 8D 54 01 00 00 4C 3B C0 77 0E 48 8D 95 F4 04 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B BD 50 01 00 00 44 8B 64 24 3C 44 8B 6C 24 40 B0 01 84 C0 0F 84 AD 00 00 00 45 2B E5 48 8D 15 ?? ?? ?? ?? 44 89 64 24 3C 0F 85 35 FC FF FF 8B 44 24 44 4C 8B 6C 24 50 8B 4C 24 38 8D 04 80 03 C0 2B C8 0F 84 EC 04 00 00 8D 41 FF 8B 84 82 ?? ?? ?? ?? 85 C0 0F 84 80 00 00 00 83 F8 01 0F 84 D1 04 00 00 45 85 FF 0F 84 C8 04 00 00 45 33 C0 44 8B D0 45 33 C9 42 8B 8C 8D 54 01 00 00 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 8C 8D 54 01 00 00 49 C1 E8 20 41 FF C1 45 3B CF 75 D7 45 85 C0 74 46 83 BD 50 01 00 00 73 73 2E 8B 85 50 01 00 00 44 89 84 85 54 01 00 00 44 8B BD 50 01 00 00 41 FF C7 EB 17 4C 8B 6C 24 50 45 33 FF 44 89 BD 50 01 00 00 E9 5A 04 00 00 45 33 FF 44 89 BD 50 01 00 00 E9 4B 04 00 00 44 8B BD 50 01 00 00 E9 3F 04 00 00 F7 D9 F7 E1 89 4C 24 40 8B C2 48 8D 15 ?? ?? ?? ?? C1 E8 03 89 44 24 30 44 8B E0 89 44 24 3C 85 C0 0F 84 99 03 00 00 B8 26 00 00 00 45 8B EC 44 3B E0 44 0F 47 E8 44 89 6C 24 44 41 8D 45 FF 0F B6 8C 82 ?? ?? ?? ?? 0F B6 B4 82 ?? ?? ?? ?? 8B D9 8B F8 33 D2 48 C1 E3 02 4C 8B C3 8D 04 0E 48 8D 8D 24 03 00 00 89 85 20 03 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 C1 E6 02 0F B7 84 B9 ?? ?? ?? ?? 48 8D 91 ?? ?? ?? ?? 48 8D 8D 24 03 00 00 4C 8B C6 48 03 CB 48 8D 14 82 E8 ?? ?? ?? ?? 8B BD 20 03 00 00 83 FF 01 0F 87 87 00 00 00 8B 85 24 03 00 00 85 C0 75 0C 45 33 F6 44 89 75 80 E9 CE 02 00 00 83 F8 01 0F 84 C5 02 00 00 45 85 F6 0F 84 BC 02 00 00 45 33 C0 4C 8B D0 45 33 C9 42 8B 4C 8D 84 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 4C 8D 84 49 C1 E8 20 41 FF C1 45 3B CE 75 DD 45 85 C0 74 25 83 7D 80 73 73 11 8B 45 80 44 89 44 85 84 44 8B 75 80 41 FF C6 EB 9D 45 33 F6 44 89 75 80 32 C0 E9 68 02 00 00 44 8B 75 80 E9 5D 02 00 00 41 83 FE 01 0F 87 9A 00 00 00 8B 5D 84 4C 8B C7 49 C1 E0 02 44 8B F7 89 7D 80 4D 85 C0 74 3A B8 CC 01 00 00 48 8D 4D 84 4C 3B C0 77 0E 48 8D 95 24 03 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B 75 80 85 DB 0F 84 22 FF FF FF 83 FB 01 0F 84 F3 01 00 00 45 85 F6 0F 84 EA 01 00 00 45 33 C0 4C 8B D3 45 33 C9 42 8B 4C 8D 84 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 4C 8D 84 49 C1 E8 20 41 FF C1 45 3B CE 75 DD E9 29 FF FF FF 41 3B FE 48 8D 4D 84 45 8B E6 4C 8D AD 24 03 00 00 0F 92 C0 48 8D 55 84 84 C0 4C 0F 44 E9 44 0F 45 E7 41 0F 45 FE 48 8D 8D 24 03 00 00 48 0F 44 D1 45 33 F6 45 33 D2 48 89 54 24 58 44 89 B5 F0 04 00 00 45 85 E4 0F 84 19 01 00 00 43 8B 74 95 00 41 8B C2 85 F6 75 21 45 3B D6 0F 85 F8 00 00 00 42 21 B4 95 F4 04 00 00 45 8D 72 01 44 89 B5 F0 04 00 00 E9 E0 00 00 00 33 DB 45 8B CA 85 FF 0F 84 C4 00 00 00 45 8B DA 41 F7 DB 41 83 F9 73 74 66 45 3B CE 75 1B 41 8B C1 41 8D 49 01 83 A4 85 F4 04 00 00 00 43 8D 04 1A 03 C8 89 8D F0 04 00 00 43 8D 04 0B 45 8B C1 8B 14 82 41 FF C1 48 0F AF D6 42 8B 84 85 F4 04 00 00 48 03 D0 8B C3 48 03 D0 43 8D 04 0B 48 8B DA 42 89 94 85 F4 04 00 00 44 8B B5 F0 04 00 00 48 C1 EB 20 3B C7 74 07 48 8B 54 24 58 EB 94 85 DB 74 4E 41 83 F9 73 0F 84 4C 01 00 00 45 3B CE 75 15 41 8B C1 83 A4 85 F4 04 00 00 00 41 8D 41 01 89 85 F0 04 00 00 41 8B C9 41 FF C1 8B C3 8B 94 8D F4 04 00 00 48 03 D0 89 94 8D F4 04 00 00 44 8B B5 F0 04 00 00 48 C1 EA 20 8B DA 85 D2 75 B2 41 83 F9 73 0F 84 FE 00 00 00 48 8B 54 24 58 41 FF C2 45 3B D4 0F 85 E7 FE FF FF 45 8B C6 49 C1 E0 02 44 89 75 80 4D 85 C0 74 3A B8 CC 01 00 00 48 8D 4D 84 4C 3B C0 77 0E 48 8D 95 F4 04 00 00 E8 ?? ?? ?? ?? EB 1A 4C 8B C0 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 44 8B 75 80 44 8B 64 24 3C 44 8B 6C 24 44 B0 01 84 C0 0F 84 8F 00 00 00 45 2B E5 48 8D 15 ?? ?? ?? ?? 44 89 64 24 3C 0F 85 74 FC FF FF 8B 4C 24 40 8B 44 24 30 4C 8B 6C 24 50 8D 04 80 03 C0 2B C8 74 76 8D 41 FF 8B 84 82 ?? ?? ?? ?? 85 C0 74 5B 83 F8 01 74 63 45 85 F6 74 5E 45 33 C0 44 8B D0 45 33 C9 42 8B 4C 8D 84 41 8B C0 49 0F AF CA 48 03 C8 4C 8B C1 42 89 4C 8D 84 49 C1 E8 20 41 FF C1 45 3B CE 75 DD 45 85 C0 74 29 83 7D 80 73 73 1A 8B 45 80 44 89 44 85 84 44 8B 75 80 41 FF C6 44 89 75 80 EB 12 4C 8B 6C 24 50 83 65 80 00 49 8B DD EB 6E 44 8B 75 80 49 8B DD 45 85 F6 74 62 45 33 C0 45 33 C9 42 8B 44 8D 84 48 8D 0C 80 41 8B C0 4C 8D 04 48 46 89 44 8D 84 41 FF C1 49 C1 E8 20 45 3B CE 75 DF 45 85 C0 74 36 83 7D 80 73 73 0D 8B 45 80 44 89 44 85 84 FF 45 80 EB 23 83 A5 20 03 00 00 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__acrt_errno_from_os_error"
		size = 69
		refs = "0005 ?errtable@@3QBUerrentry@?A0x31fdb9ec@@B"
	strings:
		$1 = { 33 C0 4C 8D 0D ?? ?? ?? ?? 49 8B D1 44 8D 40 08 3B 0A 74 2B FF C0 49 03 D0 83 F8 2C 72 F2 8D 41 ED 83 F8 11 77 06 B8 0D 00 00 00 C3 81 C1 44 FF FF FF B8 16 00 00 00 83 F9 0E 41 0F 46 C0 C3 41 8B 44 C1 04 C3 }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "__acrt_errno_map_os_error"
		size = 78
		refs = "000d __acrt_getptd_noexit 0019 ?doserrno_no_memory@@3KA 002d ?errno_no_memory@@3HA 003d __acrt_errno_from_os_error"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B F9 E8 ?? ?? ?? ?? 48 85 C0 75 09 48 8D 05 ?? ?? ?? ?? EB 04 48 83 C0 24 89 38 E8 ?? ?? ?? ?? 48 8D 1D ?? ?? ?? ?? 48 85 C0 74 04 48 8D 58 20 8B CF E8 ?? ?? ?? ?? 89 03 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "__doserrno"
		size = 32
		refs = "0005 __acrt_getptd_noexit 0011 ?doserrno_no_memory@@3KA"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 75 09 48 8D 05 ?? ?? ?? ?? EB 04 48 83 C0 24 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "_errno"
		size = 32
		refs = "0005 __acrt_getptd_noexit 0011 ?errno_no_memory@@3HA"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 75 09 48 8D 05 ?? ?? ?? ?? EB 04 48 83 C0 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "_get_doserrno"
		size = 59
		refs = "000f _invalid_parameter_noinfo 0019 __acrt_getptd_noexit 0025 ?doserrno_no_memory@@3KA"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 C9 75 0A E8 ?? ?? ?? ?? 8D 43 16 EB 1D E8 ?? ?? ?? ?? 48 85 C0 75 09 48 8D 05 ?? ?? ?? ?? EB 04 48 83 C0 24 8B 00 89 03 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "_get_errno"
		size = 59
		refs = "000f _invalid_parameter_noinfo 0019 __acrt_getptd_noexit 0025 ?errno_no_memory@@3HA"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 C9 75 0A E8 ?? ?? ?? ?? 8D 43 16 EB 1D E8 ?? ?? ?? ?? 48 85 C0 75 09 48 8D 05 ?? ?? ?? ?? EB 04 48 83 C0 20 8B 00 89 03 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_120_6_0 {
	meta:
		name = "_set_doserrno"
		size = 58
		refs = "0009 __acrt_getptd_noexit 0026 ?doserrno_no_memory@@3KA"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 48 85 C0 75 07 B8 0C 00 00 00 EB 1B E8 ?? ?? ?? ?? 48 85 C0 75 09 48 8D 05 ?? ?? ?? ?? EB 04 48 83 C0 24 89 18 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_120_7_0 {
	meta:
		name = "_set_errno"
		size = 58
		refs = "0009 __acrt_getptd_noexit 0026 ?errno_no_memory@@3HA"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 48 85 C0 75 07 B8 0C 00 00 00 EB 1B E8 ?? ?? ?? ?? 48 85 C0 75 09 48 8D 05 ?? ?? ?? ?? EB 04 48 83 C0 20 89 18 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "modf"
		size = 223
		refs = "00d2 __real@8000000000000000"
	strings:
		$1 = { 48 B9 FF FF FF FF FF FF FF 7F F2 0F 11 44 24 08 4C 8B 44 24 08 0F 28 C8 49 8B C0 48 23 C1 48 B9 00 00 00 00 00 00 40 43 48 3B C1 72 35 48 B9 00 00 00 00 00 00 F0 7F F2 0F 11 02 48 3B C1 76 09 F2 0F 58 C9 E9 92 00 00 00 48 B8 00 00 00 00 00 00 00 80 4C 23 C0 4C 89 44 24 08 F2 0F 10 44 24 08 C3 48 B9 00 00 00 00 00 00 F0 3F 48 3B C1 73 1E 48 B8 00 00 00 00 00 00 00 80 4C 23 C0 4C 89 44 24 08 F2 0F 10 44 24 08 F2 0F 11 02 EB 4C 49 8B C0 B9 33 00 00 00 48 C1 E8 34 2A C8 B8 01 00 00 00 48 D3 E0 48 FF C8 48 F7 D0 49 23 C0 48 89 44 24 08 F2 0F 10 54 24 08 66 0F 2E C2 F2 0F 11 12 7A 14 75 12 0F 57 C0 66 0F 2F C1 76 09 F2 0F 10 05 ?? ?? ?? ?? C3 F2 0F 5C CA 0F 28 C1 C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "wmemcpy"
		size = 26
		refs = "000d memcpy"
	strings:
		$1 = { 40 53 48 83 EC 20 4D 03 C0 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_123_1_0 {
	meta:
		name = "wmemcpy_s"
		size = 122
		refs = "001b _errno 0027 _invalid_parameter_noinfo 0041 memcpy"
	strings:
		$1 = { 40 57 48 83 EC 20 4D 8B D0 45 33 C0 4D 85 C9 75 04 33 C0 EB 5F 48 85 C9 75 15 E8 ?? ?? ?? ?? BF 16 00 00 00 89 38 E8 ?? ?? ?? ?? 8B C7 EB 45 4D 85 D2 74 13 49 3B D1 72 0E 4F 8D 04 09 49 8B D2 E8 ?? ?? ?? ?? EB CA 48 85 D2 74 0D 48 8B F9 41 0F B7 C0 48 8B CA 66 F3 AB 4D 85 D2 74 BC 49 3B D1 73 0C E8 ?? ?? ?? ?? BF 22 00 00 00 EB B5 B8 16 00 00 00 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_123_2_0 {
	meta:
		name = "wmemset"
		size = 34
	strings:
		$1 = { 48 89 7C 24 08 4C 8B C9 4D 85 C0 74 0C 48 8B F9 0F B7 C2 49 8B C8 66 F3 AB 48 8B 7C 24 08 49 8B C1 C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "_log10_special"
		size = 32
		refs = "0007 ??_C@_05HGHHAHAP@log10?$AA@ 0017 _log_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1B 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_124_1_0 {
	meta:
		name = "_log10f_special"
		size = 32
		refs = "0007 ??_C@_06KDGOKGLH@log10f?$AA@ 0017 _logf_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1B 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_124_2_0 {
	meta:
		name = "_log_special"
		size = 32
		refs = "0007 ??_C@_03MGHMBJCF@log?$AA@ 0017 _log_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1A 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_124_4_0 {
	meta:
		name = "_logf_special"
		size = 32
		refs = "0007 ??_C@_04HIGFGEHP@logf?$AA@ 0017 _logf_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1A 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_124_3_0 {
	meta:
		name = "_log_special_common"
		size = 150
		refs = "0085 _handle_error"
	strings:
		$1 = { 48 8B C4 48 83 EC 68 0F 29 70 E8 0F 28 F1 41 8B D1 0F 28 D8 41 83 E8 01 74 2A 41 83 F8 01 75 69 44 89 40 D8 0F 57 D2 F2 0F 11 50 D0 45 8B C8 F2 0F 11 40 C8 C7 40 C0 21 00 00 00 C7 40 B8 08 00 00 00 EB 2D C7 44 24 40 01 00 00 00 0F 57 C0 F2 0F 11 44 24 38 41 B9 02 00 00 00 F2 0F 11 5C 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 48 8B 8C 24 90 00 00 00 F2 0F 11 4C 24 78 4C 8B 44 24 78 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_124_5_0 {
	meta:
		name = "_logf_special_common"
		size = 156
		refs = "008b _handle_errorf"
	strings:
		$1 = { 48 8B C4 48 83 EC 78 0F 29 70 E8 0F 28 F1 41 8B D1 0F 28 D0 41 83 E8 01 74 2A 41 83 F8 01 75 6F 44 89 40 C8 0F 57 C9 F3 0F 11 48 C0 45 8B C8 F3 0F 11 50 B8 C7 40 B0 21 00 00 00 C7 40 A8 08 00 00 00 EB 2D C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 41 B9 02 00 00 00 F3 0F 11 54 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 48 83 64 24 50 00 48 8B 8C 24 A0 00 00 00 F3 0F 11 74 24 50 4C 8B 44 24 50 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 60 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "atanhf"
		size = 186
		refs = "0011 _fdtest 003a __xmm@80000000800000008000000080000000 004e __real@3f800000 0058 _fperrraise 0060 _FNan_C 007b _FInf_C 0097 __real@40000000 00a0 log1pf 00a8 __real@3f000000"
	strings:
		$1 = { F3 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 F7 C1 FD FF FF FF 0F 84 8A 00 00 00 F3 0F 10 4C 24 30 0F 57 C0 0F 2F C1 B9 01 00 00 00 76 11 0F 57 0D ?? ?? ?? ?? 8B D9 F3 0F 11 4C 24 30 EB 02 33 DB F3 0F 10 15 ?? ?? ?? ?? 0F 2F CA 76 0F E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? EB 4E 0F 2E CA 7A 21 75 1F B9 04 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 85 DB 74 31 0F 57 05 ?? ?? ?? ?? EB 28 0F 28 C1 F3 0F 5C D1 F3 0F 59 05 ?? ?? ?? ?? F3 0F 5E C2 E8 ?? ?? ?? ?? F3 0F 59 05 ?? ?? ?? ?? EB D1 F3 0F 10 44 24 30 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "strcmp"
		size = 103
	strings:
		$1 = { 48 2B D1 F6 C1 07 74 14 0F B6 01 3A 04 11 75 4F 48 FF C1 84 C0 74 45 F6 C1 07 75 EC 49 BB 80 80 80 80 80 80 80 80 49 BA FF FE FE FE FE FE FE FE 67 8D 04 11 25 FF 0F 00 00 3D F8 0F 00 00 77 C8 48 8B 01 48 3B 04 11 75 BF 4D 8D 0C 02 48 F7 D0 48 83 C1 08 49 23 C1 49 85 C3 74 D4 33 C0 C3 48 1B C0 48 83 C8 01 C3 }
	condition:
		$1
}

rule file_127_4_0 {
	meta:
		name = "??$common_capture_argv@D@@YAPEAPEADQEAPEADQEBD0_K@Z"
		size = 401
		refs = "0066 _calloc_base 0071 _free_base 00a1 memcpy 00b4 _recalloc_base 0100 memset 010a _errno 0178 _invalid_parameter_noinfo 018c _invoke_watson"
		altNames = "??$common_capture_argv@_W@@YAPEAPEA_WQEAPEADQEB_WQEAPEA_W_K@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 48 89 48 08 57 41 54 41 55 41 56 41 57 48 83 EC 30 33 FF 49 8B E9 8B DF 44 8B E7 4D 8B F8 4C 8B EA 48 8B C1 49 8B F0 4D 8B F1 4D 3B E6 0F 82 94 00 00 00 48 B8 FF FF FF FF FF FF FF 7F 4C 3B F0 0F 83 DC 00 00 00 4D 03 F6 49 3B F7 75 4A BA 08 00 00 00 49 8B CE E8 ?? ?? ?? ?? 48 8B CB 48 8B F0 E8 ?? ?? ?? ?? 33 C9 48 8B DE E8 ?? ?? ?? ?? 48 85 F6 0F 84 A9 00 00 00 48 85 ED 74 44 4D 85 FF 74 65 4C 3B F5 72 60 4C 8B C5 49 8B D7 48 8B CE E8 ?? ?? ?? ?? EB 2A 41 B8 08 00 00 00 49 8B D6 48 8B CB E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 5D 33 C9 E8 ?? ?? ?? ?? 33 C9 48 8B DE E8 ?? ?? ?? ?? 48 8B 44 24 60 4E 89 2C E6 49 FF C4 4D 85 ED 74 5C 48 83 00 08 48 8B 00 4C 8B 68 F8 48 8B 44 24 60 E9 42 FF FF FF 4D 8B C6 33 D2 48 8B CE E8 ?? ?? ?? ?? 4D 85 FF 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 61 4C 3B F5 73 61 EB 4F E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? EB 13 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 06 48 8B DF 48 8B FE 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 8B C7 48 8B 6C 24 70 48 8B 74 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 45 33 C9 48 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_6_0 {
	meta:
		name = "??$common_pack_argv_and_envp@D@@YAHQEBQEBD0QEAPEAD1@Z"
		size = 332
		refs = "0065 _calloc_base 0075 __acrt_errno_map_os_error 007a _errno 00a3 strcpy_s 00d8 _free_base 00ec ??$construct_environment_block@D@@YAHQEBQEBDQEAPEAD@Z 0147 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 48 89 54 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 33 DB 4C 8B F1 4C 8B D9 8B F3 48 8B 09 44 8B D3 48 83 CD FF 4D 8B E1 4D 8B E8 EB 18 48 8B C5 48 FF C0 38 1C 01 75 F8 49 FF C2 4C 03 D0 49 83 C3 08 49 8B 0B 48 85 C9 75 E3 8D 41 01 4C 3B D0 44 8B F8 8B D0 4D 0F 47 FA 49 8B CF E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 1A 8D 48 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 E9 85 00 00 00 48 8B F0 49 39 1E 74 42 4D 8B 06 48 8B D7 48 2B D6 48 8B CE 49 03 D7 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 49 8B 0E 48 8B C5 48 FF C0 38 1C 01 75 F8 48 03 F0 49 83 C6 08 C6 06 20 48 FF C6 49 39 1E 75 C4 88 5E FF 48 8B F7 33 C9 E8 ?? ?? ?? ?? 48 8B 4C 24 78 48 8D 54 24 70 48 89 5C 24 70 E8 ?? ?? ?? ?? 85 C0 74 07 48 8B 5C 24 70 EB 12 48 8B 44 24 70 48 8B F3 49 89 7D 00 8B EB 49 89 04 24 48 8B CB E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 8B 9C 24 80 00 00 00 8B C5 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 45 33 C9 48 89 5C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_7_0 {
	meta:
		name = "??$common_pack_argv_and_envp@_W@@YAHQEBQEB_W0QEAPEA_W1@Z"
		size = 347
		refs = "0065 _calloc_base 0075 __acrt_errno_map_os_error 007a _errno 00a9 wcscpy_s 00e7 _free_base 00fb ??$construct_environment_block@_W@@YAHQEBQEB_WQEAPEA_W@Z 0156 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 48 89 54 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 33 DB 4C 8B F1 4C 8B D1 8B F3 48 8B 09 44 8B DB 48 83 CD FF 4D 8B E1 4D 8B E8 EB 19 48 8B C5 48 FF C0 66 39 1C 41 75 F7 49 FF C3 4C 03 D8 49 83 C2 08 49 8B 0A 48 85 C9 75 E2 44 8D 79 01 4D 3B DF 8D 51 02 4D 0F 47 FB 49 8B CF E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 1A 8D 48 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 E9 94 00 00 00 48 8B F0 49 39 1E 74 51 4D 8B 06 48 8B C6 48 2B C7 49 8B D7 48 D1 F8 48 8B CE 48 2B D0 E8 ?? ?? ?? ?? 85 C0 0F 85 91 00 00 00 49 8B 0E 48 8B C5 48 FF C0 66 39 1C 41 75 F7 48 8D 34 46 49 83 C6 08 B8 20 00 00 00 66 89 06 48 83 C6 02 49 39 1E 75 B6 66 89 5E FE 48 8B F7 33 C9 E8 ?? ?? ?? ?? 48 8B 4C 24 78 48 8D 54 24 70 48 89 5C 24 70 E8 ?? ?? ?? ?? 85 C0 74 07 48 8B 5C 24 70 EB 12 48 8B 44 24 70 48 8B F3 49 89 7D 00 8B EB 49 89 04 24 48 8B CB E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 8B 9C 24 80 00 00 00 8B C5 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 45 33 C9 48 89 5C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_8_0 {
	meta:
		name = "??$construct_command_line@D@@YAHQEBQEBDQEAPEAD@Z"
		size = 259
		refs = "005e _calloc_base 006e __acrt_errno_map_os_error 0073 _errno 009b strcpy_s 00cf _free_base 00fe _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 30 33 FF 4C 8B F1 48 89 3A 4C 8B C9 48 8B 09 4C 8B FA 44 8B C7 EB 1A 48 83 C8 FF 48 FF C0 40 38 3C 01 75 F7 49 FF C0 4C 03 C0 49 83 C1 08 49 8B 09 48 85 C9 75 E1 8D 69 01 4C 3B C5 8D 51 01 49 0F 47 E8 48 8B CD E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 14 8D 48 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 7B 0C 89 38 EB 4E 48 8B F0 49 39 3E 75 05 49 89 07 EB 41 4D 8B 06 48 8B D3 48 2B D6 48 8B CE 48 03 D5 E8 ?? ?? ?? ?? 85 C0 75 4B 49 8B 0E 48 83 C8 FF 48 FF C0 40 38 3C 01 75 F7 48 03 F0 49 83 C6 08 C6 06 20 48 FF C6 49 39 3E 75 C6 40 88 7E FF 49 89 1F 33 C9 E8 ?? ?? ?? ?? 48 8B 5C 24 50 8B C7 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 30 41 5F 41 5E 5F C3 45 33 C9 48 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_9_0 {
	meta:
		name = "??$construct_command_line@_W@@YAHQEBQEB_WQEAPEA_W@Z"
		size = 272
		refs = "005e _calloc_base 006e __acrt_errno_map_os_error 0073 _errno 00a1 wcscpy_s 00dc _free_base 010b _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 30 33 FF 4C 8B F1 48 89 3A 4C 8B C9 48 8B 09 4C 8B FA 44 8B C7 EB 1A 48 83 C8 FF 48 FF C0 66 39 3C 41 75 F7 49 FF C0 4C 03 C0 49 83 C1 08 49 8B 09 48 85 C9 75 E1 8D 69 01 4C 3B C5 8D 51 02 49 0F 47 E8 48 8B CD E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 14 8D 48 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 7B 0C 89 38 EB 5B 48 8B F0 49 39 3E 75 05 49 89 07 EB 4E 4D 8B 06 48 8B C6 48 2B C3 48 8B D5 48 D1 F8 48 8B CE 48 2B D0 E8 ?? ?? ?? ?? 85 C0 75 52 49 8B 0E 48 83 C8 FF 48 FF C0 66 39 3C 41 75 F7 48 8D 34 46 49 83 C6 08 B8 20 00 00 00 66 89 06 48 83 C6 02 49 39 3E 75 B9 66 89 7E FE 49 89 1F 33 C9 E8 ?? ?? ?? ?? 48 8B 5C 24 50 8B C7 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 30 41 5F 41 5E 5F C3 45 33 C9 48 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_10_0 {
	meta:
		name = "??$construct_environment_block@D@@YAHQEBQEBDQEAPEAD@Z"
		size = 816
		refs = "001a __security_cookie 0063 _dupenv_s 0079 _errno 00d8 __dcrt_get_narrow_environment_from_os 0169 _strnicmp 0197 _calloc_base 01a7 __acrt_errno_map_os_error 01d2 memcpy 01ec strcpy_s 023e ?equal_sign@?BD@???$construct_environment_block@D@@YAHQEBQEBDQEAPEAD@Z@4QBDB 0249 strcat_s 028b _free_base 02aa __security_check_cookie 02d7 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 70 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 33 DB 48 89 55 D8 48 89 1A 4C 8B F9 48 85 C9 75 07 33 C0 E9 65 02 00 00 4C 8D 45 E0 C7 45 E0 53 79 73 74 33 D2 C7 45 E4 65 6D 52 6F 48 8D 4D C8 66 C7 45 E8 6F 74 88 5D EA 48 89 5D C8 E8 ?? ?? ?? ?? 85 C0 74 19 BB 16 00 00 00 3B C3 0F 84 4E 02 00 00 E8 ?? ?? ?? ?? 8B 18 E9 13 02 00 00 48 8B 45 C8 49 83 CE FF 48 85 C0 74 10 49 8B CE 48 FF C1 38 1C 08 75 F8 48 FF C1 EB 03 48 8B CB 49 8B 07 48 8D 71 0B 48 89 75 D0 41 BD 02 00 00 00 49 8B D7 EB 18 49 8B CE 48 FF C1 38 1C 08 75 F8 49 FF C5 4C 03 E9 48 83 C2 08 48 8B 02 48 85 C0 75 E3 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 08 8D 58 16 E9 A3 01 00 00 B1 3D 4C 8B E0 38 08 74 18 49 8B C6 48 FF C0 41 38 1C 04 75 F7 49 FF C4 4C 03 E0 41 38 0C 24 75 E8 4D 8B F4 41 38 0C 24 75 2D 41 38 5E 01 74 27 41 80 7E 02 3A 75 20 41 38 4E 03 75 1A 48 83 C8 FF 48 FF C0 41 38 5C 06 04 75 F6 49 83 C6 05 4C 03 F0 41 38 0E 74 D3 4D 2B F4 49 8B DF 49 83 3F 00 74 2C 48 8D 45 E0 49 83 C8 FF 49 FF C0 42 80 3C 00 00 75 F6 48 8B 0B 48 8D 55 E0 E8 ?? ?? ?? ?? 85 C0 74 4B 48 83 C3 08 48 83 3B 00 75 D4 32 C9 4B 8D 04 2E 88 4D C0 84 C9 4C 8D 2C 30 BA 01 00 00 00 4C 0F 45 E8 49 8B CD E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 1D 8D 48 0E E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BB 0C 00 00 00 89 18 E9 CC 00 00 00 B1 01 EB BD 48 8B F0 4D 85 F6 74 15 4D 8B C6 49 8B D4 48 8B C8 E8 ?? ?? ?? ?? 4D 2B EE 4A 8D 34 33 45 33 E4 EB 33 4D 8B 07 49 8B D5 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 F9 00 00 00 49 8B 0F 48 83 C8 FF 48 FF C0 44 38 24 01 75 F7 48 FF C0 48 03 F0 4C 2B E8 49 83 C7 08 4D 39 27 75 C8 44 38 65 C0 75 50 4C 8B 75 D0 4C 8D 45 E0 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 E0 00 00 00 4C 8D 05 ?? ?? ?? ?? 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 B1 00 00 00 4C 8B 45 C8 4D 85 C0 74 0F 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 6F 49 03 F6 48 3B F3 75 06 44 88 26 48 FF C6 48 8B 45 D8 44 88 26 48 89 18 41 8B DC 33 C9 E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 8B 4D C8 E8 ?? ?? ?? ?? 8B C3 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 C0 00 00 00 48 83 C4 70 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_11_0 {
	meta:
		name = "??$construct_environment_block@_W@@YAHQEBQEB_WQEAPEA_W@Z"
		size = 859
		refs = "001a __security_cookie 0073 _wdupenv_s 0089 _errno 00ea __dcrt_get_wide_environment_from_os 018d _wcsnicmp 01be _calloc_base 01ce __acrt_errno_map_os_error 01f9 memcpy 0212 wcscpy_s 0266 ?equal_sign@?BD@???$construct_environment_block@_W@@YAHQEBQEB_WQEAPEA_W@Z@4QB_WB 0271 wcscat_s 02b7 _free_base 02d6 __security_check_cookie 0302 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 70 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 33 DB 48 89 55 D8 48 89 1A 4C 8B F9 48 85 C9 75 07 33 C0 E9 91 02 00 00 4C 8D 45 E0 C7 45 E0 53 00 79 00 33 D2 C7 45 E4 73 00 74 00 48 8D 4D C8 C7 45 E8 65 00 6D 00 C7 45 EC 52 00 6F 00 C7 45 F0 6F 00 74 00 66 89 5D F4 48 89 5D C8 E8 ?? ?? ?? ?? 85 C0 74 19 BB 16 00 00 00 3B C3 0F 84 6A 02 00 00 E8 ?? ?? ?? ?? 8B 18 E9 2F 02 00 00 48 8B 45 C8 49 83 CE FF 48 85 C0 74 11 49 8B CE 48 FF C1 66 39 1C 48 75 F7 48 FF C1 EB 03 48 8B CB 49 8B 07 48 8D 71 0B 48 89 75 D0 41 BD 02 00 00 00 49 8B D7 EB 19 49 8B CE 48 FF C1 66 39 1C 48 75 F7 49 FF C5 4C 03 E9 48 83 C2 08 48 8B 02 48 85 C0 75 E2 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 08 8D 58 16 E9 BD 01 00 00 66 B9 3D 00 4C 8B E0 66 39 08 74 1C 49 8B C6 48 FF C0 66 41 39 1C 44 75 F6 4D 8D 24 44 49 83 C4 02 66 41 39 0C 24 75 E4 4D 8B F4 66 41 39 0C 24 75 33 66 41 39 5E 02 74 2C 66 41 83 7E 04 3A 75 24 66 41 39 4E 06 75 1D 48 83 C8 FF 48 FF C0 66 41 39 5C 46 08 75 F5 4D 8D 34 46 49 83 C6 0A 66 41 39 0E 74 CD 4D 2B F4 33 C9 49 D1 FE 49 8B DF 49 39 0F 74 31 48 8D 45 E0 49 83 C8 FF 49 FF C0 66 42 39 0C 40 75 F6 48 8B 0B 48 8D 55 E0 E8 ?? ?? ?? ?? 33 C9 85 C0 74 0B 48 83 C3 08 48 39 0B 75 D3 EB 02 B1 01 4B 8D 04 2E 88 4D C0 84 C9 4C 8D 2C 30 BA 02 00 00 00 4C 0F 45 E8 49 8B CD E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 19 8D 48 0E E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BB 0C 00 00 00 89 18 E9 D1 00 00 00 48 8B F3 4D 85 F6 74 18 4B 8D 34 36 49 8B D4 4C 8B C6 48 8B CB E8 ?? ?? ?? ?? 48 03 F3 4D 2B EE 45 33 E4 EB 35 4D 8B 07 49 8B D5 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 FE 00 00 00 49 8B 0F 48 83 C8 FF 48 FF C0 66 44 39 24 41 75 F6 48 FF C0 4C 2B E8 49 83 C7 08 48 8D 34 46 4D 39 27 75 C6 44 38 65 C0 75 51 4C 8B 75 D0 4C 8D 45 E0 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 E3 00 00 00 4C 8D 05 ?? ?? ?? ?? 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 B4 00 00 00 4C 8B 45 C8 4D 85 C0 74 0F 49 8B D6 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 72 4A 8D 34 76 48 3B F3 75 08 66 44 89 26 48 83 C6 02 48 8B 45 D8 66 44 89 26 48 89 18 41 8B DC 33 C9 E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 8B 4D C8 E8 ?? ?? ?? ?? 8B C3 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 C0 00 00 00 48 83 C4 70 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 33 D2 45 33 C9 45 33 C0 48 89 54 24 20 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 4C 89 64 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_68_0 {
	meta:
		name = "?attach@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAXQEAPEAD@Z"
		size = 38
		refs = "0014 _free_base"
		altNames = "?attach@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAXQEAPEA_W@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 48 8B FA 48 8B 09 E8 ?? ?? ?? ?? 48 89 3B 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_127_86_0 {
	meta:
		name = "__acrt_capture_narrow_argv"
		size = 420
		refs = "0066 _calloc_base 0071 _free_base 00a1 memcpy 00b4 _recalloc_base 0100 memset 010a _errno 018b _invalid_parameter_noinfo 019f _invoke_watson"
		altNames = "__acrt_capture_wide_argv"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 48 89 48 08 57 41 54 41 55 41 56 41 57 48 83 EC 30 33 FF 49 8B E9 8B DF 44 8B E7 4D 8B F8 4C 8B EA 48 8B C1 49 8B F0 4D 8B F1 4D 3B E6 0F 82 94 00 00 00 48 B8 FF FF FF FF FF FF FF 7F 4C 3B F0 0F 83 EB 00 00 00 4D 03 F6 49 3B F7 75 4A BA 08 00 00 00 49 8B CE E8 ?? ?? ?? ?? 48 8B CB 48 8B F0 E8 ?? ?? ?? ?? 33 C9 48 8B DE E8 ?? ?? ?? ?? 48 85 F6 0F 84 95 00 00 00 48 85 ED 74 44 4D 85 FF 74 65 4C 3B F5 72 60 4C 8B C5 49 8B D7 48 8B CE E8 ?? ?? ?? ?? EB 2A 41 B8 08 00 00 00 49 8B D6 48 8B CB E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 6C 33 C9 E8 ?? ?? ?? ?? 33 C9 48 8B DE E8 ?? ?? ?? ?? 48 8B 44 24 60 4E 89 2C E6 49 FF C4 4D 85 ED 74 73 48 83 00 08 48 8B 00 4C 8B 68 F8 48 8B 44 24 60 E9 42 FF FF FF 4D 8B C6 33 D2 48 8B CE E8 ?? ?? ?? ?? 4D 85 FF 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 74 4C 3B F5 73 74 EB 62 E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 EB 22 E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? EB 0B E8 ?? ?? ?? ?? C7 00 0C 00 00 00 48 8B CB E8 ?? ?? ?? ?? EB 0A 33 C9 E8 ?? ?? ?? ?? 48 8B FE 48 8B 5C 24 68 48 8B C7 48 8B 6C 24 70 48 8B 74 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 45 33 C9 48 89 7C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_88_0 {
	meta:
		name = "__acrt_pack_narrow_command_line_and_environment"
		size = 353
		refs = "0067 _calloc_base 0077 __acrt_errno_map_os_error 007c _errno 0089 _free_base 00b2 strcpy_s 00f9 ??$construct_environment_block@D@@YAHQEBQEBDQEAPEAD@Z 015c _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 33 D2 4C 8B F1 4C 8B D9 48 83 CF FF 48 8B 09 4D 8B F9 4D 8B E0 4C 8B EA EB 19 48 8B C7 48 FF C0 80 3C 01 00 75 F7 49 FF C2 4C 03 D0 49 83 C3 08 49 8B 0B 48 85 C9 75 E2 8D 41 01 4C 3B D0 8B E8 8B D0 49 0F 47 EA 48 8B CD E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 26 8D 48 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? E9 96 00 00 00 49 83 3E 00 48 8B F0 74 41 4D 8B 06 48 8B D3 48 2B D6 48 8B CE 48 03 D5 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 8E 00 00 00 49 8B 0E 48 8B C7 48 FF C0 38 14 01 75 F8 48 03 F0 49 83 C6 08 C6 06 20 48 FF C6 49 39 16 75 C2 88 56 FF 33 C9 E8 ?? ?? ?? ?? 48 83 64 24 60 00 48 8D 54 24 60 49 8B CD E8 ?? ?? ?? ?? 85 C0 74 12 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B CB E9 7C FF FF FF 48 8B 44 24 60 33 C9 49 89 1C 24 49 89 07 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 33 FF 48 8B 5C 24 68 8B C7 48 8B 6C 24 70 48 8B 74 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_89_0 {
	meta:
		name = "__acrt_pack_wide_command_line_and_environment"
		size = 370
		refs = "0068 _calloc_base 0078 __acrt_errno_map_os_error 007d _errno 008a _free_base 00b9 wcscpy_s 010a ??$construct_environment_block@_W@@YAHQEBQEB_WQEAPEA_W@Z 016d _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 83 EC 30 33 F6 4C 8B F1 4C 8B D9 44 8B D6 48 8B 09 48 83 CF FF 4D 8B F9 4D 8B E0 4C 8B EA EB 19 48 8B C7 48 FF C0 66 39 34 41 75 F7 49 FF C2 4C 03 D0 49 83 C3 08 49 8B 0B 48 85 C9 75 E2 8D 69 01 4C 3B D5 8D 51 02 49 0F 47 EA 48 8B CD E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 26 8D 48 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? E9 A6 00 00 00 49 83 3E 00 48 8B F0 74 50 4D 8B 06 48 8B C6 48 2B C3 48 8B D5 48 D1 F8 48 8B CE 48 2B D0 E8 ?? ?? ?? ?? 33 D2 85 C0 0F 85 98 00 00 00 49 8B 0E 48 8B C7 48 FF C0 66 39 14 41 75 F7 48 8D 34 46 49 83 C6 08 B8 20 00 00 00 66 89 06 48 83 C6 02 49 39 16 75 B4 66 89 56 FE 33 C9 E8 ?? ?? ?? ?? 33 F6 48 8D 54 24 60 49 8B CD 48 89 74 24 60 E8 ?? ?? ?? ?? 85 C0 74 12 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B CB E9 6C FF FF FF 48 8B 44 24 60 33 C9 49 89 1C 24 49 89 07 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 8B FE 48 8B 5C 24 68 8B C7 48 8B 6C 24 70 48 8B 74 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 45 33 C9 48 89 54 24 20 45 33 C0 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "nexttowardf"
		size = 311
		refs = "0022 _fdtest 003d _ldtest 00e8 _fperrraise"
	strings:
		$1 = { 48 8B C4 48 89 58 18 48 89 78 20 F2 0F 11 48 10 F3 0F 11 40 08 55 48 8B EC 48 83 EC 20 48 8D 4D 10 E8 ?? ?? ?? ?? 0F B7 D8 BF 80 7F 00 00 66 83 F8 02 0F 84 DA 00 00 00 48 8D 4D 18 E8 ?? ?? ?? ?? F2 0F 10 55 18 66 83 F8 02 0F 84 B9 00 00 00 F3 0F 10 4D 10 0F 5A C1 66 0F 2E C2 7A 06 0F 84 A5 00 00 00 B9 01 00 00 00 66 3B D9 75 1B 0F B7 45 12 B9 7F FF 00 00 66 23 C1 B9 7F 7F 00 00 66 0B C1 B9 FF FF 00 00 EB 17 33 D2 0F 5A C1 66 85 DB 75 17 66 0F 2F D0 B8 00 80 00 00 66 0F 47 C2 66 89 45 12 66 89 4D 10 EB 68 66 0F 2F D0 0F 57 DB 76 05 0F 2F CB 77 0E 0F 5A C1 66 0F 2F C2 76 2D 0F 2F D9 76 28 66 01 4D 10 75 46 0F B7 45 12 66 03 C1 0F B7 C8 0F BA F1 0F 66 89 45 12 3B CF 75 30 B9 08 00 00 00 E8 ?? ?? ?? ?? EB 24 0F B7 45 10 B9 FF FF 00 00 66 03 C1 66 89 45 10 66 3B C1 75 0F 66 01 4D 12 EB 09 66 0F 5A C2 F3 0F 11 45 10 66 85 7D 12 75 0A B9 10 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 45 10 48 8B 5C 24 40 48 8B 7C 24 48 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__p___mb_cur_max"
		size = 48
		refs = "0005 __acrt_getptd 001e __acrt_update_locale_info"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8D 54 24 30 48 8B 88 90 00 00 00 48 89 4C 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "norm"
		size = 78
		refs = "001d creal 0033 cimag"
	strings:
		$1 = { 40 53 48 83 EC 40 0F 10 01 48 8B D9 48 8D 4C 24 20 0F 29 74 24 30 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 0F 10 0B 48 8D 4C 24 20 0F 28 F0 F3 0F 7F 4C 24 20 E8 ?? ?? ?? ?? F2 0F 59 F6 F2 0F 59 C0 F2 0F 58 C6 0F 28 74 24 30 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "norml"
		size = 78
		refs = "001d creall 0033 cimagl"
	strings:
		$1 = { 40 53 48 83 EC 40 0F 10 01 48 8B D9 48 8D 4C 24 20 0F 29 74 24 30 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 0F 10 0B 48 8D 4C 24 20 0F 28 F0 F3 0F 7F 4C 24 20 E8 ?? ?? ?? ?? F2 0F 59 F6 F2 0F 59 C0 F2 0F 58 C6 0F 28 74 24 30 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_132_1_0 {
	meta:
		name = "?should_write_error_to_console@@YA_NXZ"
		size = 43
		refs = "000a _set_error_mode 001d ?__acrt_app_type@@3W4_crt_app_type@@A"
	strings:
		$1 = { 48 83 EC 28 B9 03 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 04 B0 01 EB 0F 85 C0 75 09 83 3D ?? ?? ?? ?? 01 74 EF 32 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_132_2_0 {
	meta:
		name = "?write_string_to_console@@YAXQEB_W@Z"
		size = 168
		refs = "000c __security_cookie 0025 __imp_GetStdHandle 008b __imp_WriteFile 009b __security_check_cookie"
	strings:
		$1 = { 40 53 48 81 EC 50 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 02 00 00 48 8B D9 B9 F4 FF FF FF FF 15 ?? ?? ?? ?? 4C 8B D0 48 8D 50 FF 48 83 FA FD 77 59 4C 8D 4C 24 40 45 33 C0 48 8D 54 24 40 8A 0B 48 8D 84 24 34 02 00 00 88 0A 48 FF C2 48 3B D0 74 0C 0F B7 03 48 83 C3 02 66 85 C0 75 E0 41 2B D1 44 88 84 24 33 02 00 00 44 89 44 24 30 4C 8D 4C 24 30 4C 89 44 24 20 49 8B CA 44 8D 42 FF 48 8D 54 24 40 FF 15 ?? ?? ?? ?? 48 8B 8C 24 40 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 50 02 00 00 5B C3 }
	condition:
		$1
}

rule file_132_3_0 {
	meta:
		name = "__acrt_report_runtime_error"
		size = 443
		refs = "0021 _set_error_mode 0036 ?__acrt_app_type@@3W4_crt_app_type@@A 004a ?outmsg@?9??__acrt_report_runtime_error@@9@4PA_WA 0054 ??_C@_1DE@JNGNBFGO@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?$CB?$AA?6?$AA?6?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@ 005c wcscpy_s 0083 __imp_GetModuleFileNameW 0092 ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 00d4 ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@ 00e8 wcsncpy_s 00f3 ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@ 00fe wcscat_s 0125 ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 012d __acrt_show_wide_message_box 0137 ?write_string_to_console@@YAXQEB_W@Z 0164 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 30 48 8B D9 B9 03 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 0F 84 05 01 00 00 33 F6 85 C0 75 0D 83 3D ?? ?? ?? ?? 01 0F 84 F2 00 00 00 41 BF 14 03 00 00 48 8D 2D ?? ?? ?? ?? 41 8B D7 4C 8D 05 ?? ?? ?? ?? 48 8B CD E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 3E 01 00 00 4C 8D 35 ?? ?? ?? ?? 66 89 35 ?? ?? ?? ?? 49 8B D6 41 B8 04 01 00 00 FF 15 ?? ?? ?? ?? 41 8D 7F E7 85 C0 75 19 4C 8D 05 ?? ?? ?? ?? 8B D7 49 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 AC 00 00 00 48 83 C9 FF 48 FF C1 66 41 39 34 4E 75 F6 48 8D 41 01 48 83 F8 3C 76 30 48 8D 0C 4D BC FF FF FF 41 B9 03 00 00 00 48 03 CD 4C 8D 05 ?? ?? ?? ?? 48 8B C1 49 2B C6 48 D1 F8 48 2B F8 48 8B D7 E8 ?? ?? ?? ?? 85 C0 75 79 4C 8D 05 ?? ?? ?? ?? 49 8B D7 48 8B CD E8 ?? ?? ?? ?? 85 C0 0F 85 89 00 00 00 4C 8B C3 49 8B D7 48 8B CD E8 ?? ?? ?? ?? 85 C0 75 62 41 B8 10 20 01 00 48 8D 15 ?? ?? ?? ?? 48 8B CD E8 ?? ?? ?? ?? EB 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 30 41 5F 41 5E 5F C3 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "_fdxp_addh"
		size = 836
		refs = "003c _fdunscale 004f _fdtest 007c _fperrraise 0084 _FNan_C 01fb _fd_int 0208 _fdscale"
	strings:
		$1 = { F3 0F 11 54 24 18 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 33 F6 F3 0F 11 55 60 0F 29 74 24 30 48 8B F9 4C 63 F2 85 D2 0F 84 F8 02 00 00 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 66 3B F0 7D 67 66 83 F8 02 74 53 48 8B CF E8 ?? ?? ?? ?? 66 85 C0 7E 46 66 83 F8 02 0F 84 C9 02 00 00 0F B7 47 02 B9 00 80 00 00 66 33 45 5A 66 85 C1 0F 84 B3 02 00 00 8D 4E 01 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 07 41 83 FE 01 0F 8E 95 02 00 00 89 77 04 E9 8D 02 00 00 F3 0F 10 45 58 F3 0F 11 07 E9 7F 02 00 00 66 85 C0 0F 89 76 02 00 00 41 BD 00 01 00 00 8B DE 4D 8B FE 45 85 F6 0F 8E 62 02 00 00 4C 8D 67 FC 0F 57 F6 F3 0F 10 04 B7 48 8D 55 D8 48 8D 4D 50 F3 0F 11 45 D8 E8 ?? ?? ?? ?? 33 C9 66 3B C8 0F 8C 39 02 00 00 66 85 C0 0F 84 16 02 00 00 0F BF 55 50 0F BF 45 48 8B CA F3 0F 10 4D 58 2B C8 83 F9 F4 7F 5A 0F 2E CE 7A 02 74 53 8B CB 48 8B C6 FF C1 48 FF C0 49 3B C7 7D 0C F3 0F 10 04 87 0F 2E C6 7A EC 75 EA 41 8D 46 FF 3B C8 7D 04 FF C1 EB 07 41 3B CE 75 02 FF C9 48 63 D1 48 3B F2 7D 0F 8B 44 97 FC 89 04 97 48 FF CA 48 3B D6 7F F1 83 65 58 00 F3 0F 11 0C B7 E9 9B 01 00 00 B8 0C 00 00 00 3B C8 7C 11 0F 2E CE 7A 02 74 0A 44 8B EA FF C3 E9 7A 01 00 00 F3 0F 58 0C B7 0F 2E CE F3 0F 11 0C B7 7A 38 75 36 48 8B C6 48 FF C0 49 3B C7 7D 12 F3 0F 10 04 87 0F 2E C6 F3 0F 11 44 87 FC 7A E8 75 E6 42 83 64 BF FC 00 F3 0F 10 04 B7 0F 2E C6 0F 28 C8 7A 06 0F 84 5F 01 00 00 48 8D 55 58 F3 0F 11 4D 58 48 8D 4D 48 E8 ?? ?? ?? ?? 0F BF 55 48 41 8D 4D F4 3B CA 0F 8D 90 00 00 00 66 41 2B D5 48 8D 4D 58 66 83 C2 0C E8 ?? ?? ?? ?? 0F BF 55 48 48 8D 4D 58 E8 ?? ?? ?? ?? F3 0F 10 04 B7 F3 0F 5C 45 58 0F 2E C6 F3 0F 11 04 B7 7A 25 75 23 48 8B C6 48 FF C0 49 3B C7 7D 12 F3 0F 10 04 87 0F 2E C6 F3 0F 11 44 87 FC 7A E8 75 E6 42 83 64 BF FC 00 48 FF CE 49 83 EC 04 83 EB 01 75 0B 41 BD 00 01 00 00 E9 AA 00 00 00 F3 41 0F 10 04 24 48 8D 55 60 48 8D 4D 50 F3 0F 11 45 60 E8 ?? ?? ?? ?? 44 0F BF 6D 50 E9 88 00 00 00 44 8D 7B 01 45 3B FE 0F 84 A0 00 00 00 F3 0F 10 04 B7 48 8D 4D 50 48 63 C3 F3 0F 11 45 58 48 8D 1C 87 48 8B D3 E8 ?? ?? ?? ?? BA 0C 00 00 00 48 8B CB E8 ?? ?? ?? ?? 0F BF 55 50 48 8B CB E8 ?? ?? ?? ?? F3 0F 10 45 58 F3 0F 10 0C B7 44 0F BF 6D 50 F3 0F 5C C1 0F 2E C6 F3 0F 11 45 58 7A 09 75 07 F3 0F 11 4D 60 EB 05 F3 0F 11 45 60 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 41 8B DF 4D 8B FE 48 FF C6 49 83 C4 04 41 3B DE 0F 8C C1 FD FF FF EB 1A F3 0F 10 45 58 48 63 C3 FF C3 F3 0F 11 04 87 41 3B DE 7D 06 48 63 C3 89 0C 87 48 8B C7 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "_fdxp_addx"
		size = 110
		refs = "0033 __real@00000000 0042 _fdxp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 24 F3 0F 10 16 0F 2E 15 ?? ?? ?? ?? 7A 02 74 15 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 04 3B FD 7C DC 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "_fdxp_getw"
		size = 78
	strings:
		$1 = { 85 D2 75 04 0F 57 C0 C3 83 FA 01 74 3C F3 0F 10 11 0F 57 C0 0F 2E D0 7A 02 74 2E 83 FA 01 7E 0C F3 0F 10 49 04 0F 2E C8 7A 02 74 1D 83 FA 02 75 09 F3 0F 58 51 04 0F 28 C2 C3 F3 0F 10 41 08 F3 0F 58 41 04 F3 0F 58 C2 C3 F3 0F 10 01 C3 }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "_fdxp_invx"
		size = 329
		refs = "0035 _fdtest 005a _FInf_C 0084 memcpy 008c __real@bf800000 0096 _fdxp_mulh 00ac __real@3f800000 00ba _fdxp_setw 00e1 _fdxp_mulx 00f3 _fdxp_addh 0118 _fdxp_addx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 33 ED 0F 29 70 D8 48 63 FA 4D 8B F8 48 8B D9 85 D2 0F 84 EE 00 00 00 E8 ?? ?? ?? ?? 66 3B E8 7F 29 8D 75 01 66 3B C6 75 07 89 2B E9 D5 00 00 00 66 85 C0 0F 85 CC 00 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 03 E9 BB 00 00 00 F3 0F 10 33 4C 8B F7 49 C1 E6 02 48 8B D3 4D 8B C6 4B 8D 2C 3E 48 8B CD 4D 8D 24 2E E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? BE 01 00 00 00 3B FE 7E 05 F3 0F 58 73 04 F3 0F 10 15 ?? ?? ?? ?? 8B D7 F3 0F 5E D6 48 8B CB E8 ?? ?? ?? ?? 3B FE 7E 60 4D 8B C6 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C5 8B D7 49 8B CF E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C3 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4D 8B C7 8B D7 48 8B CB E8 ?? ?? ?? ?? 03 F6 3B F7 7C A0 48 8B 6C 24 68 48 8B C3 48 8B 5C 24 60 48 8B 74 24 70 48 8B 7C 24 78 0F 28 74 24 30 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_133_4_0 {
	meta:
		name = "_fdxp_ldexpx"
		size = 119
		refs = "0035 ldexp 0043 __real@00000000"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 DB 45 8B F0 8B EA 48 8B F1 85 D2 7E 32 48 8B F9 F3 0F 10 07 41 8B D6 0F 5A C0 E8 ?? ?? ?? ?? 0F 57 C9 F2 0F 5A C8 0F 2E 0D ?? ?? ?? ?? F3 0F 11 0F 7A 02 74 0A FF C3 48 83 C7 04 3B DD 7C D1 48 8B 5C 24 30 48 8B C6 48 8B 74 24 40 48 8B 6C 24 38 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_133_5_0 {
	meta:
		name = "_fdxp_movx"
		size = 36
		refs = "0017 memcpy"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 48 8B D9 4C 63 C2 48 8B D0 49 C1 E0 02 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_133_6_0 {
	meta:
		name = "_fdxp_mulh"
		size = 481
		refs = "0024 __security_cookie 0050 _fdtest 006b _fperrraise 012b _fdunscale 0139 _fd_int 0146 _fdscale 0156 _fdxp_addh 01bb __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 70 0F 29 74 24 60 0F 29 7C 24 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 D0 45 33 E4 4C 63 FA 0F 28 FA 48 8B F9 85 D2 7E 58 0F 28 C2 F3 0F 59 01 48 8D 4D C0 F3 0F 11 45 C0 E8 ?? ?? ?? ?? 0F B7 F0 66 44 3B E0 7F 37 41 8D 5C 24 01 66 83 F8 02 75 07 8B CB E8 ?? ?? ?? ?? F3 0F 10 45 C0 F3 0F 11 07 66 44 3B E6 0F 8D 2E 01 00 00 44 3B FB 0F 8E 25 01 00 00 44 89 67 04 E9 1C 01 00 00 44 89 27 BB 01 00 00 00 41 8B C4 89 45 B8 44 8B F3 4D 8B EC 45 85 FF 0F 8E FF 00 00 00 4C 8D 65 C0 8B F3 4C 2B E7 0F 57 F6 48 83 FE 04 7D 4A 42 8D 14 30 4A 8D 04 2E 48 8D 0C 87 41 3B D7 7D 2C F3 0F 10 01 0F 2E C6 7A 02 74 21 83 21 00 44 03 F3 F3 0F 59 C7 03 D3 48 03 F3 F3 41 0F 11 04 0C 48 83 C1 04 48 83 FE 04 7C D1 EB 0D 83 64 B5 C0 00 BE 08 00 00 00 44 8B F6 F3 0F 10 45 C0 0F 2E C6 7A 06 0F 84 93 00 00 00 48 8D 55 B0 F3 0F 11 45 B0 48 8D 4D B4 E8 ?? ?? ?? ?? BA 0C 00 00 00 48 8D 4D B0 E8 ?? ?? ?? ?? 0F BF 55 B4 48 8D 4D B0 E8 ?? ?? ?? ?? F3 0F 10 55 B0 41 8B D7 48 8B CF E8 ?? ?? ?? ?? F3 0F 10 55 C0 41 8B D7 F3 0F 5C 55 B0 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 3B DE 7D 1B F3 0F 10 44 85 C0 0F 2E C6 F3 0F 11 44 85 BC 7A 02 74 08 48 03 C3 48 3B C6 7C E5 8B 45 B8 4C 03 EB 03 C3 49 83 EC 04 44 2B F3 89 45 B8 48 2B F3 4D 3B EF 0F 8C 0D FF FF FF 48 8B C7 48 8B 4D D0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 C0 00 00 00 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 70 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_133_7_0 {
	meta:
		name = "_fdxp_mulx"
		size = 254
		refs = "0041 __real@00000000 005d _fdxp_mulh 007d memcpy 00d2 _fdxp_addx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 63 E9 49 8B D8 48 63 FA 48 8B F1 85 D2 0F 84 AE 00 00 00 45 85 C9 0F 84 A5 00 00 00 F3 41 0F 10 10 0F 2E 15 ?? ?? ?? ?? 7A 02 74 11 F3 41 0F 10 40 04 0F 2E 05 ?? ?? ?? ?? 7A 0B 75 09 8B D7 E8 ?? ?? ?? ?? EB 7B 4C 8B 64 24 70 48 8B D1 4C 8B FF 49 8B CC 49 C1 E7 02 4D 8B C7 4F 8D 2C 27 E8 ?? ?? ?? ?? F3 0F 10 13 8B D7 48 8B CE E8 ?? ?? ?? ?? 41 BE 01 00 00 00 EB 42 F3 42 0F 10 04 B3 0F 2E 05 ?? ?? ?? ?? 7A 02 74 36 4D 8B C7 49 8B D4 49 8B CD E8 ?? ?? ?? ?? F3 42 0F 10 14 B3 8B D7 49 8B CD E8 ?? ?? ?? ?? 44 8B CF 4D 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 49 FF C6 4C 3B F5 7C B9 48 8B 5C 24 50 48 8B C6 48 8B 74 24 60 48 8B 6C 24 58 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_133_8_0 {
	meta:
		name = "_fdxp_setw"
		size = 175
		refs = "0035 _fdunscale 005d _fd_int 006c _fdscale"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 20 57 48 83 EC 30 0F 29 70 E8 33 F6 0F 28 F2 8B FA F3 0F 11 70 18 48 8B D9 85 D2 7E 70 83 FA 01 74 67 48 8D 50 18 48 8D 48 10 E8 ?? ?? ?? ?? 66 85 C0 74 4F 66 3B F0 7D 0F F3 0F 10 44 24 50 F3 0F 11 03 89 73 04 EB 45 BA 0C 00 00 00 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F BF 54 24 48 48 8D 4C 24 50 E8 ?? ?? ?? ?? F3 0F 10 44 24 50 F3 0F 11 03 F3 0F 5C F0 F3 0F 11 73 04 83 FF 02 7E 0F 89 73 08 EB 0A F3 0F 10 74 24 50 F3 0F 11 33 48 8B 74 24 58 48 8B C3 48 8B 5C 24 40 0F 28 74 24 20 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_133_9_0 {
	meta:
		name = "_fdxp_sqrtx"
		size = 349
		refs = "0031 _fdtest 006b sqrtf 0073 __real@3f800000 0081 _fdxp_setw 009a memcpy 00a2 __real@bf000000 00ac _fdxp_mulh 00c1 _fdxp_mulx 00de __real@3fc00000 00e8 _fdxp_addh 012b _fperrraise 0133 _FNan_C"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 33 F6 48 63 FA 49 8B E8 48 8B D9 85 D2 0F 84 0B 01 00 00 E8 ?? ?? ?? ?? 0F 57 C0 66 3B F0 0F 8E DF 00 00 00 F3 0F 10 0B 0F 2F C1 0F 87 D7 00 00 00 4C 8B F7 49 C1 E6 02 49 8D 34 2E 4D 8D 3C 36 83 FF 01 7E 05 F3 0F 58 4B 04 0F 28 C1 E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 F3 0F 5E D0 48 8B CE E8 ?? ?? ?? ?? 41 BC 02 00 00 00 41 3B FC 7E 79 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C3 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CD E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 45 03 E4 44 3B E7 7C 87 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 1B 0F 2F 03 76 16 B9 01 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 03 48 8B 6C 24 58 48 8B C3 48 8B 5C 24 50 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_133_10_0 {
	meta:
		name = "_fdxp_subx"
		size = 117
		refs = "0033 __real@00000000 003e __xmm@80000000800000008000000080000000 0049 _fdxp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 2B F3 0F 10 16 0F 2E 15 ?? ?? ?? ?? 7A 02 74 1C 0F 57 15 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 04 3B FD 7C D5 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_133_11_0 {
	meta:
		name = "fmaf"
		size = 688
		refs = "0024 __security_cookie 0036 __fma3_is_available 0098 _fdunscale 016d _fdscale 017d _fdxp_setw 01af _fdxp_mulh 01ee _fdxp_addx 0277 _fperrraise 027f _FNan_C 028b __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 48 8D 68 A1 48 81 EC B0 00 00 00 0F 29 70 C8 0F 29 78 B8 44 0F 29 40 A8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F7 33 F6 0F 28 FA 39 35 ?? ?? ?? ?? 0F 28 F1 44 0F 28 C0 F3 0F 11 75 C7 F3 44 0F 11 45 AF F3 0F 11 7D D7 74 2C F3 0F 11 7D D7 F3 0F 10 45 D7 0F 28 D8 F3 0F 11 75 C7 F3 0F 10 4D C7 F3 44 0F 11 45 AF F3 0F 10 45 AF C4 E2 71 A9 C3 E9 04 02 00 00 48 8D 55 BF F3 44 0F 11 45 BF 48 8D 4D BB F3 0F 11 75 CF F3 0F 11 7D A7 E8 ?? ?? ?? ?? 41 BE 02 00 00 00 0F B7 D8 66 41 3B C6 75 09 41 0F 28 C0 E9 CF 01 00 00 48 8D 55 CF 48 8D 4D B7 E8 ?? ?? ?? ?? 0F B7 F8 66 41 3B C6 75 08 0F 28 C6 E9 B1 01 00 00 48 8D 55 A7 48 8D 4D AB E8 ?? ?? ?? ?? 66 41 3B C6 75 08 0F 28 C7 E9 96 01 00 00 B9 01 00 00 00 66 3B D9 0F 84 48 01 00 00 66 3B F9 0F 84 3F 01 00 00 66 3B C1 74 DC 66 85 DB 0F 84 56 01 00 00 66 85 FF 0F 84 4D 01 00 00 66 85 C0 0F 84 44 01 00 00 0F BF 45 BB BA 00 80 00 00 0F B7 4D AB 0F BF 5D B7 03 D8 0F B7 45 B1 66 33 45 C9 66 2B CB 66 33 45 D9 66 89 4D AB 66 85 C2 0F 84 15 01 00 00 41 8D 04 0E BF 04 00 00 00 66 3B C7 0F 87 03 01 00 00 0F BF D1 48 8D 4D A7 E8 ?? ?? ?? ?? F3 0F 10 55 BF 48 8D 4D E7 8B D7 E8 ?? ?? ?? ?? F3 0F 10 55 CF 48 8D 4D D7 41 8B D6 E8 ?? ?? ?? ?? F3 0F 10 55 A7 48 8D 4D C7 41 8B D6 E8 ?? ?? ?? ?? F3 0F 10 55 D7 48 8D 4D E7 8B D7 E8 ?? ?? ?? ?? F3 0F 10 7D DB 0F 57 F6 0F 2E FE 7A 02 74 30 F3 0F 10 55 BF 48 8D 4D D7 8B D7 E8 ?? ?? ?? ?? 0F 28 D7 48 8D 4D D7 8B D7 E8 ?? ?? ?? ?? 44 8B CF 4C 8D 45 D7 8B D7 48 8D 4D E7 E8 ?? ?? ?? ?? 45 8B CE 4C 8D 45 C7 8B D7 48 8D 4D E7 E8 ?? ?? ?? ?? F3 0F 10 4D E7 0F 2E CE 7A 02 74 1C F3 0F 10 55 EB 0F 2E D6 7A 02 74 10 F3 0F 10 45 EF F3 0F 58 C2 F3 0F 58 C1 0F 28 C8 8B D3 F3 0F 11 4D A7 48 8D 4D A7 E8 ?? ?? ?? ?? F3 0F 10 45 A7 EB 40 66 85 DB 74 2E 66 85 FF 74 29 66 3B C1 75 16 0F B7 45 B1 BA 00 80 00 00 66 33 45 C9 66 33 45 D9 66 85 C2 75 0E F3 41 0F 59 F0 F3 0F 58 F7 E9 54 FE FF FF E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 48 8B 4D F7 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 B0 00 00 00 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 49 8B E3 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_133_12_0 {
	meta:
		name = "intrinsic_fma"
		size = 48
	strings:
		$1 = { 48 8B C4 F3 0F 11 40 08 F3 0F 11 48 10 F3 0F 10 40 10 F3 0F 11 50 18 0F 28 D0 F3 0F 10 48 18 0F 28 D9 F3 0F 10 48 08 0F 28 C1 C4 E2 69 A9 C3 C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "clog10"
		size = 81
		refs = "001d clog 0025 __real@3fdbcb7b1526e50e 003d _Cmulcr"
	strings:
		$1 = { 40 53 48 83 EC 50 0F 10 02 48 8B D9 48 8D 54 24 20 48 8D 4C 24 30 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 54 24 20 48 8D 4C 24 40 0F 10 00 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 0F 10 00 48 8B C3 F3 0F 7F 03 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_678_0_0 {
	meta:
		name = "clog10l"
		size = 81
		refs = "001d clogl 0025 __real@3fdbcb7b1526e50e 003d _LCmulcr"
	strings:
		$1 = { 40 53 48 83 EC 50 0F 10 02 48 8B D9 48 8D 54 24 20 48 8D 4C 24 30 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 54 24 20 48 8D 4C 24 40 0F 10 00 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 0F 10 00 48 8B C3 F3 0F 7F 03 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "??$common_configure_argv@D@@YAHW4_crt_argv_mode@@@Z"
		size = 374
		refs = "002c _errno 0038 _invalid_parameter_noinfo 0044 __acrt_initialize_multibyte 004b ?program_name@?1???$common_configure_argv@D@@YAHW4_crt_argv_mode@@@Z@4PADA 005c __imp_GetModuleFileNameA 0063 _acmdln 006a _pgmptr 0099 ??$parse_command_line@D@@YAXPEADPEAPEAD0PEA_K2@Z 00af __acrt_allocate_buffer_for_argv 00f0 __argc 00fa __argv 0111 __acrt_expand_narrow_argv_wildcards 0153 _free_base"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 56 41 57 48 8B EC 48 83 EC 30 33 FF 44 8B F1 85 C9 75 07 33 C0 E9 42 01 00 00 8D 41 FF 83 F8 01 76 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 22 01 00 00 E8 ?? ?? ?? ?? 48 8D 1D ?? ?? ?? ?? 41 B8 04 01 00 00 48 8B D3 33 C9 FF 15 ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? 48 85 F6 74 05 40 38 3E 75 03 48 8B F3 48 8D 45 48 48 89 7D 40 4C 8D 4D 40 48 89 44 24 20 45 33 C0 48 89 7D 48 33 D2 48 8B CE E8 ?? ?? ?? ?? 4C 8B 7D 40 41 B8 01 00 00 00 48 8B 55 48 49 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 0C E8 ?? ?? ?? ?? 8D 7B 0C 89 38 EB 3A 4E 8D 04 F8 48 8B D3 48 8D 45 48 48 8B CE 4C 8D 4D 40 48 89 44 24 20 E8 ?? ?? ?? ?? 41 83 FE 01 75 1C 8B 45 40 FF C8 89 05 ?? ?? ?? ?? 48 8B C3 48 89 05 ?? ?? ?? ?? 48 8B DF 8B F7 EB 56 48 8D 55 38 48 89 7D 38 48 8B CB E8 ?? ?? ?? ?? 8B F0 85 C0 74 06 48 8B 4D 38 EB 31 48 8B 55 38 48 8B CF 48 8B C2 48 39 3A 74 0C 48 8D 40 08 48 FF C1 48 39 38 75 F4 89 0D ?? ?? ?? ?? 8B F7 48 8B CF 48 89 15 ?? ?? ?? ?? 48 89 4D 38 E8 ?? ?? ?? ?? 48 89 7D 38 48 8B CB E8 ?? ?? ?? ?? 8B C6 48 8B 5C 24 60 48 83 C4 30 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_135_4_0 {
	meta:
		name = "??$common_configure_argv@_W@@YAHW4_crt_argv_mode@@@Z"
		size = 369
		refs = "002c _errno 0038 _invalid_parameter_noinfo 0046 ?program_name@?1???$common_configure_argv@_W@@YAHW4_crt_argv_mode@@@Z@4PA_WA 0057 __imp_GetModuleFileNameW 005e _wcmdln 0065 _wpgmptr 0094 ??$parse_command_line@_W@@YAXPEA_WPEAPEA_W0PEA_K2@Z 00aa __acrt_allocate_buffer_for_argv 00eb __argc 00f5 __wargv 010c __acrt_expand_wide_argv_wildcards 014e _free_base"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 56 41 57 48 8B EC 48 83 EC 30 33 FF 44 8B F1 85 C9 75 07 33 C0 E9 3D 01 00 00 8D 41 FF 83 F8 01 76 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 1D 01 00 00 48 8D 1D ?? ?? ?? ?? 41 B8 04 01 00 00 48 8B D3 33 C9 FF 15 ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? 48 85 F6 74 05 66 39 3E 75 03 48 8B F3 48 8D 45 48 48 89 7D 40 4C 8D 4D 40 48 89 44 24 20 45 33 C0 48 89 7D 48 33 D2 48 8B CE E8 ?? ?? ?? ?? 4C 8B 7D 40 41 B8 02 00 00 00 48 8B 55 48 49 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 0C E8 ?? ?? ?? ?? 8D 7B 0C 89 38 EB 3A 4E 8D 04 F8 48 8B D3 48 8D 45 48 48 8B CE 4C 8D 4D 40 48 89 44 24 20 E8 ?? ?? ?? ?? 41 83 FE 01 75 1C 8B 45 40 FF C8 89 05 ?? ?? ?? ?? 48 8B C3 48 89 05 ?? ?? ?? ?? 48 8B DF 8B F7 EB 56 48 8D 55 38 48 89 7D 38 48 8B CB E8 ?? ?? ?? ?? 8B F0 85 C0 74 06 48 8B 4D 38 EB 31 48 8B 55 38 48 8B CF 48 8B C2 48 39 3A 74 0C 48 8D 40 08 48 FF C1 48 39 38 75 F4 89 0D ?? ?? ?? ?? 8B F7 48 8B CF 48 89 15 ?? ?? ?? ?? 48 89 4D 38 E8 ?? ?? ?? ?? 48 89 7D 38 48 8B CB E8 ?? ?? ?? ?? 8B C6 48 8B 5C 24 60 48 83 C4 30 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_135_7_0 {
	meta:
		name = "??$parse_command_line@D@@YAXPEADPEAPEAD0PEA_K2@Z"
		size = 444
		refs = "0074 _ismbblead"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 20 4C 8B 7C 24 60 4D 8B E1 49 8B F8 4C 8B F2 48 8B D9 49 83 27 00 49 C7 01 01 00 00 00 48 85 D2 74 07 4C 89 02 49 83 C6 08 40 32 ED 80 3B 22 75 0F 40 84 ED 40 B6 22 40 0F 94 C5 48 FF C3 EB 37 49 FF 07 48 85 FF 74 07 8A 03 88 07 48 FF C7 0F BE 33 48 FF C3 8B CE E8 ?? ?? ?? ?? 85 C0 74 12 49 FF 07 48 85 FF 74 07 8A 03 88 07 48 FF C7 48 FF C3 40 84 F6 74 1C 40 84 ED 75 B0 40 80 FE 20 74 06 40 80 FE 09 75 A4 48 85 FF 74 09 C6 47 FF 00 EB 03 48 FF CB 40 32 F6 80 3B 00 0F 84 D2 00 00 00 80 3B 20 74 05 80 3B 09 75 05 48 FF C3 EB F1 80 3B 00 0F 84 BA 00 00 00 4D 85 F6 74 07 49 89 3E 49 83 C6 08 49 FF 04 24 BA 01 00 00 00 33 C0 EB 05 48 FF C3 FF C0 80 3B 5C 74 F6 80 3B 22 75 31 84 C2 75 19 40 84 F6 74 0B 80 7B 01 22 75 05 48 FF C3 EB 09 33 D2 40 84 F6 40 0F 94 C6 D1 E8 EB 10 FF C8 48 85 FF 74 06 C6 07 5C 48 FF C7 49 FF 07 85 C0 75 EC 8A 03 84 C0 74 44 40 84 F6 75 08 3C 20 74 3B 3C 09 74 37 85 D2 74 2B 48 85 FF 74 05 88 07 48 FF C7 0F BE 0B E8 ?? ?? ?? ?? 85 C0 74 12 49 FF 07 48 FF C3 48 85 FF 74 07 8A 03 88 07 48 FF C7 49 FF 07 48 FF C3 E9 69 FF FF FF 48 85 FF 74 06 C6 07 00 48 FF C7 49 FF 07 E9 25 FF FF FF 4D 85 F6 74 04 49 83 26 00 49 FF 04 24 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_135_8_0 {
	meta:
		name = "??$parse_command_line@_W@@YAXPEA_WPEAPEA_W0PEA_K2@Z"
		size = 406
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 60 20 41 57 4C 8B 54 24 30 33 F6 49 8B D9 49 89 32 49 C7 01 01 00 00 00 48 85 D2 74 07 4C 89 02 48 83 C2 08 44 8A CE 41 BC 22 00 00 00 66 44 39 21 75 11 45 84 C9 41 0F B7 C4 41 0F 94 C1 48 83 C1 02 EB 1F 49 FF 02 4D 85 C0 74 0B 0F B7 01 66 41 89 00 49 83 C0 02 0F B7 01 48 83 C1 02 66 85 C0 74 1D 45 84 C9 75 C5 66 83 F8 20 74 06 66 83 F8 09 75 B9 4D 85 C0 74 0B 66 41 89 70 FE EB 04 48 83 E9 02 40 8A FE 41 BF 5C 00 00 00 66 39 31 0F 84 CD 00 00 00 66 83 39 20 74 06 66 83 39 09 75 06 48 83 C1 02 EB EE 66 39 31 0F 84 B2 00 00 00 48 85 D2 74 07 4C 89 02 48 83 C2 08 48 FF 03 41 BB 01 00 00 00 8B C6 EB 06 48 83 C1 02 FF C0 66 44 39 39 74 F4 66 44 39 21 75 37 41 84 C3 75 1C 40 84 FF 74 0D 66 44 39 61 02 75 06 48 83 C1 02 EB 0A 40 84 FF 44 8B DE 40 0F 94 C7 D1 E8 EB 12 FF C8 4D 85 C0 74 08 66 45 89 38 49 83 C0 02 49 FF 02 85 C0 75 EA 0F B7 01 66 85 C0 74 2F 40 84 FF 75 0C 66 83 F8 20 74 24 66 83 F8 09 74 1E 45 85 DB 74 10 4D 85 C0 74 08 66 41 89 00 49 83 C0 02 49 FF 02 48 83 C1 02 E9 72 FF FF FF 4D 85 C0 74 08 66 41 89 30 49 83 C0 02 49 FF 02 E9 2A FF FF FF 48 85 D2 74 03 48 89 32 48 FF 03 48 8B 5C 24 10 48 8B 74 24 18 48 8B 7C 24 20 4C 8B 64 24 28 41 5F C3 }
	condition:
		$1
}

rule file_135_44_0 {
	meta:
		name = "__acrt_allocate_buffer_for_argv"
		size = 97
		refs = "004a _calloc_base 0054 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 B8 FF FF FF FF FF FF FF 1F 4C 8B CA 4C 8B D1 48 3B C8 72 04 33 C0 EB 3C 48 83 C9 FF 33 D2 48 8B C1 49 F7 F0 4C 3B C8 73 EB 49 C1 E2 03 4D 0F AF C8 49 2B CA 49 3B C9 76 DB 4B 8D 0C 11 BA 01 00 00 00 E8 ?? ?? ?? ?? 33 C9 48 8B D8 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_135_45_0 {
	meta:
		name = "_configure_narrow_argv"
		size = 391
		refs = "0029 _errno 0033 _invalid_parameter_noinfo 003f __acrt_initialize_multibyte 0046 ?program_name@?1???$common_configure_argv@D@@YAHW4_crt_argv_mode@@@Z@4PADA 0057 __imp_GetModuleFileNameA 005e _acmdln 0065 _pgmptr 0094 ??$parse_command_line@D@@YAXPEADPEAPEAD0PEA_K2@Z 00aa __acrt_allocate_buffer_for_argv 00c5 _free_base 00f8 __argv 00fe __argc 0112 __acrt_expand_narrow_argv_wildcards"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 56 41 57 48 8B EC 48 83 EC 30 33 FF 44 8B F1 85 C9 0F 84 54 01 00 00 8D 41 FF 83 F8 01 76 16 E8 ?? ?? ?? ?? 8D 5F 16 89 18 E8 ?? ?? ?? ?? 8B FB E9 36 01 00 00 E8 ?? ?? ?? ?? 48 8D 1D ?? ?? ?? ?? 41 B8 04 01 00 00 48 8B D3 33 C9 FF 15 ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? 48 85 F6 74 05 40 38 3E 75 03 48 8B F3 48 8D 45 48 48 89 7D 40 4C 8D 4D 40 48 89 44 24 20 45 33 C0 48 89 7D 48 33 D2 48 8B CE E8 ?? ?? ?? ?? 4C 8B 7D 40 41 B8 01 00 00 00 48 8B 55 48 49 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 18 E8 ?? ?? ?? ?? BB 0C 00 00 00 33 C9 89 18 E8 ?? ?? ?? ?? E9 69 FF FF FF 4E 8D 04 F8 48 8B D3 48 8D 45 48 48 8B CE 4C 8D 4D 40 48 89 44 24 20 E8 ?? ?? ?? ?? 41 83 FE 01 75 16 8B 45 40 FF C8 48 89 1D ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 33 C9 EB 69 48 8D 55 38 48 89 7D 38 48 8B CB E8 ?? ?? ?? ?? 8B F0 85 C0 74 19 48 8B 4D 38 E8 ?? ?? ?? ?? 48 8B CB 48 89 7D 38 E8 ?? ?? ?? ?? 8B FE EB 3F 48 8B 55 38 48 8B CF 48 8B C2 48 39 3A 74 0C 48 8D 40 08 48 FF C1 48 39 38 75 F4 89 0D ?? ?? ?? ?? 33 C9 48 89 7D 38 48 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 89 7D 38 E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 60 48 83 C4 30 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_135_46_0 {
	meta:
		name = "_configure_wide_argv"
		size = 386
		refs = "0029 _errno 0033 _invalid_parameter_noinfo 0041 ?program_name@?1???$common_configure_argv@_W@@YAHW4_crt_argv_mode@@@Z@4PA_WA 0052 __imp_GetModuleFileNameW 0059 _wcmdln 0060 _wpgmptr 008f ??$parse_command_line@_W@@YAXPEA_WPEAPEA_W0PEA_K2@Z 00a5 __acrt_allocate_buffer_for_argv 00c0 _free_base 00f3 __wargv 00f9 __argc 010d __acrt_expand_wide_argv_wildcards"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 56 41 57 48 8B EC 48 83 EC 30 33 FF 44 8B F1 85 C9 0F 84 4F 01 00 00 8D 41 FF 83 F8 01 76 16 E8 ?? ?? ?? ?? 8D 5F 16 89 18 E8 ?? ?? ?? ?? 8B FB E9 31 01 00 00 48 8D 1D ?? ?? ?? ?? 41 B8 04 01 00 00 48 8B D3 33 C9 FF 15 ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? 48 85 F6 74 05 66 39 3E 75 03 48 8B F3 48 8D 45 48 48 89 7D 40 4C 8D 4D 40 48 89 44 24 20 45 33 C0 48 89 7D 48 33 D2 48 8B CE E8 ?? ?? ?? ?? 4C 8B 7D 40 41 B8 02 00 00 00 48 8B 55 48 49 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 18 E8 ?? ?? ?? ?? BB 0C 00 00 00 33 C9 89 18 E8 ?? ?? ?? ?? E9 6E FF FF FF 4E 8D 04 F8 48 8B D3 48 8D 45 48 48 8B CE 4C 8D 4D 40 48 89 44 24 20 E8 ?? ?? ?? ?? 41 83 FE 01 75 16 8B 45 40 FF C8 48 89 1D ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 33 C9 EB 69 48 8D 55 38 48 89 7D 38 48 8B CB E8 ?? ?? ?? ?? 8B F0 85 C0 74 19 48 8B 4D 38 E8 ?? ?? ?? ?? 48 8B CB 48 89 7D 38 E8 ?? ?? ?? ?? 8B FE EB 3F 48 8B 55 38 48 8B CF 48 8B C2 48 39 3A 74 0C 48 8D 40 08 48 FF C1 48 39 38 75 F4 89 0D ?? ?? ?? ?? 33 C9 48 89 7D 38 48 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 89 7D 38 E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 60 48 83 C4 30 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_136_5_0 {
	meta:
		name = "_mbsicmp_l"
		size = 520
		refs = "0027 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0039 _errno 0044 _invalid_parameter_noinfo 0062 _stricmp_l 00c9 __acrt_LCMapStringA"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 55 57 41 54 41 55 41 56 48 8B EC 48 83 EC 70 48 8B F2 48 8B F9 49 8B D0 48 8D 4D E0 E8 ?? ?? ?? ?? 45 33 F6 48 85 FF 74 05 48 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 83 01 00 00 48 8B 4D F0 44 39 71 08 75 14 4C 8D 45 E8 48 8B D6 48 8B CF E8 ?? ?? ?? ?? E9 73 01 00 00 41 BC 02 00 00 00 41 BD 00 01 00 00 0F B6 1F 48 FF C7 F6 44 0B 19 04 74 7B 44 38 37 75 08 41 8B DE E9 87 00 00 00 8B 41 04 4C 8D 4F FF 48 8B 91 20 02 00 00 41 B8 00 02 00 00 C7 44 24 40 01 00 00 00 48 8D 4D E8 89 44 24 38 48 8D 45 30 44 89 64 24 30 48 89 44 24 28 44 89 64 24 20 E8 ?? ?? ?? ?? 83 F8 01 75 06 0F B6 5D 30 EB 1E 41 3B C4 0F 85 E4 00 00 00 0F B6 55 30 0F B6 45 31 41 0F B7 CD 0F AF D1 66 03 D0 0F B7 DA 48 8B 4D F0 48 FF C7 EB 19 0F B7 C3 FF C0 48 98 F6 44 08 18 10 74 0B 0F B7 C3 0F B6 9C 08 19 01 00 00 0F B6 16 48 FF C6 F6 44 0A 19 04 74 74 44 38 36 75 08 41 8B D6 E9 80 00 00 00 8B 41 04 4C 8D 4E FF 48 8B 91 20 02 00 00 41 B8 00 02 00 00 C7 44 24 40 01 00 00 00 48 8D 4D E8 89 44 24 38 48 8D 45 30 44 89 64 24 30 48 89 44 24 28 44 89 64 24 20 E8 ?? ?? ?? ?? 83 F8 01 75 06 0F B6 55 30 EB 17 41 3B C4 75 47 0F B6 55 30 0F B6 45 31 41 0F B7 CD 0F AF D1 66 03 D0 48 8B 4D F0 48 FF C6 EB 19 0F B7 C2 FF C0 48 98 F6 44 08 18 10 74 0B 0F B7 C2 0F B6 94 08 19 01 00 00 66 3B D3 75 20 66 85 DB 0F 85 B7 FE FF FF 41 8B C6 EB 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 07 1B C0 41 23 C4 FF C8 44 38 75 F8 74 0B 48 8B 4D E0 83 A1 A8 03 00 00 FD 4C 8D 5C 24 70 49 8B 5B 38 49 8B 73 40 49 8B E3 41 5E 41 5D 41 5C 5F 5D C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "expm1"
		size = 289
		refs = "0010 _dtest 003b __real@bfe62e42fefa39ef 0049 __real@3fd9f323ecbf984c 005b __real@3f43d31708605728 0066 __real@3ec5ca73dff66ede 0071 __real@3ef26c937b07e563 0079 __real@3f1da2e7e515ea71 008d __real@3f51de97c5b063b2 0095 __real@3f83945deb77150f 00a5 __real@3f9c8391e0c43166 00ad __real@3fb5d013b98b14b0 00bd __real@3fa41a22f5c5081f 00c5 __real@3fdb0d4f9f784ed1 00d5 __real@3fed9093fe30efd3 00f2 exp 00fa __real@3ff0000000000000 0110 __real@bff0000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 F7 00 00 00 83 E9 01 0F 84 D8 00 00 00 83 F9 01 0F 84 E5 00 00 00 F2 0F 10 64 24 30 66 0F 2F 25 ?? ?? ?? ?? 0F 86 A9 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 97 00 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 DC F2 0F 59 1D ?? ?? ?? ?? 0F 28 C4 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C C8 F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E D9 F2 0F 59 DC 0F 28 C3 EB 2E 0F 28 C4 E8 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? EB 1C B8 00 80 00 00 66 85 44 24 36 74 0A F2 0F 10 05 ?? ?? ?? ?? EB 06 F2 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_602_1_0 {
	meta:
		name = "expm1l"
		size = 289
		refs = "0010 _ldtest 003b __real@bfe62e42fefa39ef 0049 __real@3fd9f323ecbf984c 005b __real@3f43d31708605728 0066 __real@3ec5ca73dff66ede 0071 __real@3ef26c937b07e563 0079 __real@3f1da2e7e515ea71 008d __real@3f51de97c5b063b2 0095 __real@3f83945deb77150f 00a5 __real@3f9c8391e0c43166 00ad __real@3fb5d013b98b14b0 00bd __real@3fa41a22f5c5081f 00c5 __real@3fdb0d4f9f784ed1 00d5 __real@3fed9093fe30efd3 00f2 exp 00fa __real@3ff0000000000000 0110 __real@bff0000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 F7 00 00 00 83 E9 01 0F 84 D8 00 00 00 83 F9 01 0F 84 E5 00 00 00 F2 0F 10 64 24 30 66 0F 2F 25 ?? ?? ?? ?? 0F 86 A9 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 97 00 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 DC F2 0F 59 1D ?? ?? ?? ?? 0F 28 C4 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C C8 F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E D9 F2 0F 59 DC 0F 28 C3 EB 2E 0F 28 C4 E8 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? EB 1C B8 00 80 00 00 66 85 44 24 36 74 0A F2 0F 10 05 ?? ?? ?? ?? EB 06 F2 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "??$common_tcsncat_s@D@@YAHQEAD_KQEBD1@Z"
		size = 219
		refs = "0037 _errno 0043 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B DA 4C 8B D1 4D 85 C9 75 0E 48 85 C9 75 0E 48 85 D2 75 1B 33 C0 EB 2A 48 85 C9 74 12 48 85 D2 74 0D 4D 85 C9 74 21 4D 85 C0 75 1C 44 88 01 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 49 8B D9 80 39 00 74 09 48 FF C1 48 83 EA 01 75 F2 48 85 D2 75 05 41 88 12 EB CC 49 83 F9 FF 75 18 4C 2B C1 41 8A 04 08 88 01 48 FF C1 84 C0 74 2F 48 83 EA 01 75 ED EB 27 4D 85 C9 74 1B 41 8A 00 49 FF C0 88 01 48 FF C1 84 C0 74 0C 48 83 EA 01 74 06 48 83 EB 01 75 E5 48 85 DB 75 02 88 19 48 85 D2 0F 85 63 FF FF FF 49 83 F9 FF 75 0A 43 88 54 1A FF 8D 42 50 EB 81 41 C6 02 00 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 65 FF FF FF }
	condition:
		$1
}

rule file_139_1_0 {
	meta:
		name = "strncat_s"
		size = 237
		refs = "0023 _errno 002f _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 45 33 D2 48 8B DA 4C 8B D9 4D 85 C9 75 2C 48 85 C9 75 2C 48 85 D2 74 14 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 44 8B D3 41 8B C2 48 8B 5C 24 30 48 83 C4 20 5F C3 48 85 C9 74 D9 48 85 D2 74 D4 4D 85 C9 74 0A 4D 85 C0 75 05 44 88 11 EB C5 49 8B F9 44 38 11 74 09 48 FF C1 48 83 EA 01 75 F2 48 85 D2 75 05 45 88 13 EB AA 49 83 F9 FF 75 18 4C 2B C1 41 8A 04 08 88 01 48 FF C1 84 C0 74 30 48 83 EA 01 75 ED EB 28 4D 85 C9 74 1B 41 8A 00 49 FF C0 88 01 48 FF C1 84 C0 74 0C 48 83 EA 01 74 06 48 83 EF 01 75 E5 48 85 FF 75 03 44 88 11 48 85 D2 0F 85 6F FF FF FF 49 83 F9 FF 75 0E 45 88 54 1B FF 44 8D 52 50 E9 5B FF FF FF 45 88 13 E8 ?? ?? ?? ?? BB 22 00 00 00 E9 3F FF FF FF }
	condition:
		$1
}

rule file_140_5_0 {
	meta:
		name = "_mbscspn_l"
		size = 217
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0030 strcspn 0044 _errno 004f _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B FA 48 8B D9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 30 41 83 78 08 00 75 10 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 EB 7F 48 85 DB 74 05 48 85 FF 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 D2 EB 61 80 3B 00 48 8B D3 74 56 80 3F 00 48 8B CF 74 2E 0F B6 01 42 F6 44 00 19 04 74 17 3A 02 75 08 8A 42 01 38 41 01 74 17 80 79 01 00 74 11 48 FF C1 EB 04 3A 02 74 08 48 FF C1 80 39 00 75 D2 80 39 00 75 1B 0F B6 02 42 F6 44 00 19 04 74 08 48 FF C2 80 3A 00 74 08 48 FF C2 80 3A 00 75 AA 48 2B D3 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B C2 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_141_4_0 {
	meta:
		name = "_mblen_l"
		size = 230
		refs = "0039 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0046 _isleadbyte_l 0085 __imp_MultiByteToWideChar"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 50 48 8B F2 48 8B F9 48 85 C9 0F 84 B6 00 00 00 80 39 00 0F 84 AD 00 00 00 48 85 D2 0F 84 A4 00 00 00 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F B6 0F 48 8D 54 24 38 E8 ?? ?? ?? ?? 85 C0 BB 01 00 00 00 48 8B 44 24 38 74 3F 44 8B 48 08 44 3B CB 7E 59 48 81 FE FF FF FF 7F 77 50 41 3B F1 7C 4B 83 64 24 28 00 8D 53 08 8B 48 0C 4C 8B C7 48 83 64 24 20 00 FF 15 ?? ?? ?? ?? 85 C0 74 2D 48 8B 44 24 38 8B 58 08 EB 26 83 64 24 28 00 44 8B CB 8B 48 0C 4C 8B C7 48 83 64 24 20 00 BA 09 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 03 83 CB FF 80 7C 24 48 00 74 0C 48 8B 4C 24 30 83 A1 A8 03 00 00 FD 8B C3 EB 02 33 C0 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_141_5_0 {
	meta:
		name = "mblen"
		size = 26
		refs = "0002 __acrt_locale_changed_data 000c __acrt_initial_locale_pointers 0016 _mblen_l"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 09 4C 8D 05 ?? ?? ?? ?? EB 03 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "ceilf"
		size = 141
		refs = "002a _handle_nanf 0052 __real@3f800000"
	strings:
		$1 = { 45 33 C0 F3 0F 11 44 24 08 8B 54 24 08 8B C2 0F BA F0 1F 3B D0 41 0F 95 C0 3D 00 00 80 4B 72 0E 3D 00 00 80 7F 76 65 8B CA E9 ?? ?? ?? ?? 3D 00 00 80 3F 73 23 85 C0 74 53 45 85 C0 74 10 C7 44 24 08 00 00 00 80 F3 0F 10 44 24 08 EB 3E F3 0F 10 05 ?? ?? ?? ?? EB 34 8B C2 B9 96 00 00 00 C1 E8 17 2B C8 B8 01 00 00 00 D3 E0 FF C8 F7 D0 23 C2 89 44 24 08 F3 0F 10 44 24 08 45 85 C0 75 0C 3B D0 74 08 F3 0F 58 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "_unloaddll"
		size = 32
		refs = "0006 __imp_FreeLibrary 0015 __imp_GetLastError"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 75 0B 48 83 C4 28 48 FF 25 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "feholdexcept"
		size = 80
		refs = "0019 fegetenv 003b fesetenv 0044 _clearfp"
	strings:
		$1 = { 40 53 48 83 EC 20 83 64 24 38 00 48 8B D9 83 64 24 3C 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 85 C0 74 07 B8 01 00 00 00 EB 22 48 8B 44 24 38 48 8D 4C 24 38 83 4C 24 38 1F 48 89 03 E8 ?? ?? ?? ?? 85 C0 75 DE E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "cexpl"
		size = 529
		refs = "0028 creall 003e cimagl 004c _ldtest 00e2 _LZero_C 00e9 __xmm@80000000000000008000000000000000 00f8 cos 010e sin 0129 _fperrraise 0136 _LNan_C 01bf _ldexp 01f1 _LCbuild"
	strings:
		$1 = { 40 55 53 57 48 8B EC 48 83 EC 50 0F 10 02 48 8B F9 48 8D 4D D0 0F 29 74 24 40 48 8B DA F3 0F 7F 45 D0 0F 29 7C 24 30 E8 ?? ?? ?? ?? F2 0F 11 45 38 48 8D 4D D0 0F 10 03 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 48 8D 4D 38 F2 0F 11 45 30 E8 ?? ?? ?? ?? 48 8D 4D 30 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 02 75 1D F2 0F 10 7D 38 F2 0F 11 7D 28 66 85 C0 0F 85 1C 01 00 00 F2 0F 10 75 30 E9 F4 00 00 00 B9 01 00 00 00 66 83 F8 02 75 29 66 3B D9 75 1A 0F 57 FF 66 0F 2F 7D 38 0F 87 EF 00 00 00 F2 0F 10 7D 38 F2 0F 11 7D 28 EB CC F2 0F 10 7D 30 E9 D9 00 00 00 66 3B D9 0F 85 BE 00 00 00 0F 57 F6 66 0F 2F 75 38 76 5D 66 3B C1 75 27 66 0F 2F 75 30 F2 0F 11 75 28 0F 28 FE 0F 86 95 00 00 00 F2 0F 10 35 ?? ?? ?? ?? 0F 57 35 ?? ?? ?? ?? E9 81 00 00 00 F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 F8 F2 0F 10 45 30 F2 0F 59 FE F2 0F 11 7D 28 E8 ?? ?? ?? ?? F2 0F 59 C6 F2 0F 11 45 20 0F 28 F0 E9 C3 00 00 00 66 3B C1 75 19 E8 ?? ?? ?? ?? F2 0F 10 7D 38 F2 0F 10 35 ?? ?? ?? ?? F2 0F 11 7D 28 EB 32 66 85 C0 0F 84 53 FF FF FF F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 F8 F2 0F 10 45 30 F2 0F 59 7D 38 F2 0F 11 7D 28 E8 ?? ?? ?? ?? 0F 28 F0 F2 0F 59 75 38 F2 0F 11 75 20 EB 6C 66 3B C1 75 1C E8 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 7D 28 F2 0F 11 7D 20 0F 28 F7 EB 4B F2 0F 10 45 38 F2 0F 11 45 28 F2 0F 11 45 20 F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 C8 48 8D 4D 28 45 33 C0 E8 ?? ?? ?? ?? F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 C8 48 8D 4D 20 45 33 C0 E8 ?? ?? ?? ?? F2 0F 10 7D 28 F2 0F 10 75 20 0F 28 D6 48 8D 4D D0 0F 28 CF E8 ?? ?? ?? ?? 0F 28 74 24 40 0F 28 7C 24 30 0F 10 00 48 8B C7 F3 0F 7F 07 48 83 C4 50 5F 5B 5D C3 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "cexp"
		size = 529
		refs = "0028 creal 003e cimag 004c _dtest 00e2 _Zero_C 00e9 __xmm@80000000000000008000000000000000 00f8 cos 010e sin 0129 _fperrraise 0136 _Nan_C 01bf _dexp 01f1 _Cbuild"
	strings:
		$1 = { 40 55 53 57 48 8B EC 48 83 EC 50 0F 10 02 48 8B F9 48 8D 4D D0 0F 29 74 24 40 48 8B DA F3 0F 7F 45 D0 0F 29 7C 24 30 E8 ?? ?? ?? ?? F2 0F 11 45 38 48 8D 4D D0 0F 10 03 F3 0F 7F 45 D0 E8 ?? ?? ?? ?? 48 8D 4D 38 F2 0F 11 45 30 E8 ?? ?? ?? ?? 48 8D 4D 30 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 02 75 1D F2 0F 10 7D 38 F2 0F 11 7D 28 66 85 C0 0F 85 1C 01 00 00 F2 0F 10 75 30 E9 F4 00 00 00 B9 01 00 00 00 66 83 F8 02 75 29 66 3B D9 75 1A 0F 57 FF 66 0F 2F 7D 38 0F 87 EF 00 00 00 F2 0F 10 7D 38 F2 0F 11 7D 28 EB CC F2 0F 10 7D 30 E9 D9 00 00 00 66 3B D9 0F 85 BE 00 00 00 0F 57 F6 66 0F 2F 75 38 76 5D 66 3B C1 75 27 66 0F 2F 75 30 F2 0F 11 75 28 0F 28 FE 0F 86 95 00 00 00 F2 0F 10 35 ?? ?? ?? ?? 0F 57 35 ?? ?? ?? ?? E9 81 00 00 00 F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 F8 F2 0F 10 45 30 F2 0F 59 FE F2 0F 11 7D 28 E8 ?? ?? ?? ?? F2 0F 59 C6 F2 0F 11 45 20 0F 28 F0 E9 C3 00 00 00 66 3B C1 75 19 E8 ?? ?? ?? ?? F2 0F 10 7D 38 F2 0F 10 35 ?? ?? ?? ?? F2 0F 11 7D 28 EB 32 66 85 C0 0F 84 53 FF FF FF F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 F8 F2 0F 10 45 30 F2 0F 59 7D 38 F2 0F 11 7D 28 E8 ?? ?? ?? ?? 0F 28 F0 F2 0F 59 75 38 F2 0F 11 75 20 EB 6C 66 3B C1 75 1C E8 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 7D 28 F2 0F 11 7D 20 0F 28 F7 EB 4B F2 0F 10 45 38 F2 0F 11 45 28 F2 0F 11 45 20 F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 C8 48 8D 4D 28 45 33 C0 E8 ?? ?? ?? ?? F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 C8 48 8D 4D 20 45 33 C0 E8 ?? ?? ?? ?? F2 0F 10 7D 28 F2 0F 10 75 20 0F 28 D6 48 8D 4D D0 0F 28 CF E8 ?? ?? ?? ?? 0F 28 74 24 40 0F 28 7C 24 30 0F 10 00 48 8B C7 F3 0F 7F 07 48 83 C4 50 5F 5B 5D C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "lrintf"
		size = 120
		refs = "0015 _fdtest 002c nearbyintf 0042 _fperrraise 0049 __real@cf000000 0053 __real@4f000000"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 0F 29 74 24 20 E8 ?? ?? ?? ?? 98 85 C0 74 4E FF C8 83 F8 01 76 3D F3 0F 10 44 24 40 E8 ?? ?? ?? ?? 0F 28 F0 0F 2E 74 24 40 7A 02 74 0A B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 2F 35 ?? ?? ?? ?? 72 13 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 72 06 F3 0F 2C C6 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "setbuf"
		size = 28
		refs = "0018 setvbuf"
	strings:
		$1 = { 48 85 D2 75 09 45 33 C9 44 8D 42 04 EB 09 41 B9 00 02 00 00 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "asinf"
		size = 565
		refs = "0052 _handle_nanf 0062 __real@3f800000 006e __real@3fc90fdb 0077 __real@bf800000 0083 __real@bfc90fdb 008d _set_statfp 00a2 ??_C@_05ECHIKDO@asinf?$AA@ 00d2 _handle_errorf 00e3 __xmm@80000000800000008000000080000000 0103 __real@3f000000 013b __real@bc5b3fe1 0146 __real@3b81ce6b 0152 __real@3f8d6fa5 015e __real@3d678bdd 016a __real@3e3c94dc 0176 __real@3f561f0d 019e __real@40000000 01d6 __real@33a22168 01f3 __real@3f490fda"
	strings:
		$1 = { 48 83 EC 68 83 64 24 70 00 0F 57 C9 0F 29 74 24 50 0F 28 F0 F3 0F 11 B4 24 80 00 00 00 8B 94 24 80 00 00 00 8B C2 44 8B C2 C1 E8 17 41 81 E0 00 00 00 80 0F B6 C8 8B C2 0F BA F0 1F 83 E9 7F 3D 00 00 80 7F 76 10 8B CA 0F 28 74 24 50 48 83 C4 68 E9 ?? ?? ?? ?? 83 F9 F2 7C 2C 85 C9 78 7C 0F 2E 35 ?? ?? ?? ?? 7A 0C 75 0A F3 0F 10 35 ?? ?? ?? ?? EB 13 0F 2E 35 ?? ?? ?? ?? 7A 1C 75 1A F3 0F 10 35 ?? ?? ?? ?? B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 E9 92 01 00 00 41 B9 01 00 00 00 48 8D 0D ?? ?? ?? ?? 44 89 4C 24 40 41 B8 00 00 C0 FF F3 0F 11 4C 24 38 F3 0F 11 74 24 30 C7 44 24 28 21 00 00 00 41 8D 51 0D C7 44 24 20 08 00 00 00 E8 ?? ?? ?? ?? E9 50 01 00 00 45 85 C0 74 07 0F 57 35 ?? ?? ?? ?? 33 C0 83 F9 FF 0F 9D C0 85 C0 74 31 F3 0F 10 15 ?? ?? ?? ?? F3 0F 5C D6 F3 0F 59 15 ?? ?? ?? ?? F3 0F 11 54 24 78 F3 0F 51 4C 24 78 F3 0F 11 4C 24 70 F3 0F 10 5C 24 70 0F 28 F3 EB 13 F3 0F 10 5C 24 70 0F 28 D6 F3 0F 59 D6 F3 0F 11 54 24 78 F3 0F 10 0D ?? ?? ?? ?? 0F 28 C2 F3 0F 59 05 ?? ?? ?? ?? F3 0F 5C C8 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 CA F3 0F 5C 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 59 15 ?? ?? ?? ?? F3 0F 5C C2 F3 0F 5E C8 85 C0 0F 84 8A 00 00 00 F3 0F 11 9C 24 80 00 00 00 8B 84 24 80 00 00 00 F3 0F 10 1D ?? ?? ?? ?? 25 00 00 FF FF 89 84 24 80 00 00 00 F3 0F 10 A4 24 80 00 00 00 F3 0F 10 6C 24 70 0F 28 C4 F3 0F 10 54 24 78 F3 0F 59 C4 F3 0F 59 EB F3 0F 5C D0 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 E9 0F 28 CC F3 0F 58 4C 24 70 F3 0F 59 E3 F3 0F 5E D1 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 D3 F3 0F 5C C2 F3 0F 5C E8 0F 28 C1 F3 0F 5C C4 F3 0F 5C E8 F3 0F 5C CD EB 08 F3 0F 59 CE F3 0F 58 CE 45 85 C0 74 07 0F 57 0D ?? ?? ?? ?? 0F 28 C1 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "atanh"
		size = 189
		refs = "0011 _dtest 003b __xmm@80000000000000008000000000000000 004f __real@3ff0000000000000 005a _fperrraise 0062 _Nan_C 007e _Inf_C 009a __real@4000000000000000 00a3 log1p 00ab __real@3fe0000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 F7 C1 FD FF FF FF 0F 84 8D 00 00 00 F2 0F 10 4C 24 30 0F 57 C0 66 0F 2F C1 B9 01 00 00 00 76 11 0F 57 0D ?? ?? ?? ?? 8B D9 F2 0F 11 4C 24 30 EB 02 33 DB F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F CA 76 0F E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? EB 4F 66 0F 2E CA 7A 21 75 1F B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 85 DB 74 31 0F 57 05 ?? ?? ?? ?? EB 28 0F 28 C1 F2 0F 5C D1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5E C2 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? EB D1 F2 0F 10 44 24 30 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "atanhl"
		size = 189
		refs = "0011 _ldtest 003b __xmm@80000000000000008000000000000000 004f __real@3ff0000000000000 005a _fperrraise 0062 _LNan_C 007e _LInf_C 009a __real@4000000000000000 00a3 log1pl 00ab __real@3fe0000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 F7 C1 FD FF FF FF 0F 84 8D 00 00 00 F2 0F 10 4C 24 30 0F 57 C0 66 0F 2F C1 B9 01 00 00 00 76 11 0F 57 0D ?? ?? ?? ?? 8B D9 F2 0F 11 4C 24 30 EB 02 33 DB F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F CA 76 0F E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? EB 4F 66 0F 2E CA 7A 21 75 1F B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 85 DB 74 31 0F 57 05 ?? ?? ?? ?? EB 28 0F 28 C1 F2 0F 5C D1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5E C2 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? EB D1 F2 0F 10 44 24 30 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "ctanh"
		size = 436
		refs = "0033 creal 0049 cimag 0057 _dtest 007f _Zero_C 0086 __xmm@80000000000000008000000000000000 009a __real@bff0000000000000 00a7 __real@3ff0000000000000 00d2 __real@0000000000000000 00f3 _Nan_C 0105 tan 0112 sinh 0140 _Inf_C 016d sqrt 0185 _Cbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 18 48 89 78 20 55 48 8B EC 48 83 EC 60 0F 10 02 48 8B F9 48 8D 4D C0 0F 29 70 E8 48 8B DA 0F 29 78 D8 F3 0F 7F 45 C0 44 0F 29 40 C8 E8 ?? ?? ?? ?? F2 0F 11 45 18 48 8D 4D C0 0F 10 03 F3 0F 7F 45 C0 E8 ?? ?? ?? ?? 48 8D 4D 18 F2 0F 11 45 10 E8 ?? ?? ?? ?? 48 8D 4D 10 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 01 75 43 B8 00 80 00 00 0F 57 C0 66 85 45 16 74 11 F2 0F 10 15 ?? ?? ?? ?? 0F 57 15 ?? ?? ?? ?? EB 03 0F 28 D0 66 0F 2F 45 18 76 0D F2 0F 10 0D ?? ?? ?? ?? E9 DD 00 00 00 F2 0F 10 0D ?? ?? ?? ?? E9 D0 00 00 00 66 83 F8 02 75 0D F2 0F 10 55 10 0F 28 CA E9 BD 00 00 00 66 83 FB 02 75 20 F2 0F 10 55 10 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 05 F2 0F 10 55 18 F2 0F 10 4D 18 E9 97 00 00 00 66 83 F8 01 75 10 F2 0F 10 0D ?? ?? ?? ?? 0F 28 D1 E9 81 00 00 00 F2 0F 10 45 10 E8 ?? ?? ?? ?? 0F 28 F8 F2 0F 10 45 18 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 28 F7 F2 0F 59 F7 F2 0F 58 F1 F2 0F 59 F0 44 0F 28 C6 F2 44 0F 59 C0 F2 44 0F 58 C1 66 44 0F 2E 05 ?? ?? ?? ?? 7A 19 75 17 0F 57 D2 66 0F 2F D0 76 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 FA EB 1E F2 0F 59 C0 F2 41 0F 5E F8 F2 0F 58 C1 E8 ?? ?? ?? ?? F2 0F 59 C6 F2 41 0F 5E C0 0F 28 C8 0F 28 D7 48 8D 4D C0 E8 ?? ?? ?? ?? 0F 28 74 24 50 4C 8D 5C 24 60 49 8B 5B 20 0F 28 7C 24 40 0F 10 00 48 8B C7 45 0F 28 43 D0 F3 0F 7F 07 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "ctanhl"
		size = 436
		refs = "0033 creall 0049 cimagl 0057 _ldtest 007f _LZero_C 0086 __xmm@80000000000000008000000000000000 009a __real@bff0000000000000 00a7 __real@3ff0000000000000 00d2 __real@0000000000000000 00f3 _LNan_C 0105 tan 0112 sinh 0140 _LInf_C 016d sqrt 0185 _LCbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 18 48 89 78 20 55 48 8B EC 48 83 EC 60 0F 10 02 48 8B F9 48 8D 4D C0 0F 29 70 E8 48 8B DA 0F 29 78 D8 F3 0F 7F 45 C0 44 0F 29 40 C8 E8 ?? ?? ?? ?? F2 0F 11 45 18 48 8D 4D C0 0F 10 03 F3 0F 7F 45 C0 E8 ?? ?? ?? ?? 48 8D 4D 18 F2 0F 11 45 10 E8 ?? ?? ?? ?? 48 8D 4D 10 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 01 75 43 B8 00 80 00 00 0F 57 C0 66 85 45 16 74 11 F2 0F 10 15 ?? ?? ?? ?? 0F 57 15 ?? ?? ?? ?? EB 03 0F 28 D0 66 0F 2F 45 18 76 0D F2 0F 10 0D ?? ?? ?? ?? E9 DD 00 00 00 F2 0F 10 0D ?? ?? ?? ?? E9 D0 00 00 00 66 83 F8 02 75 0D F2 0F 10 55 10 0F 28 CA E9 BD 00 00 00 66 83 FB 02 75 20 F2 0F 10 55 10 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 05 F2 0F 10 55 18 F2 0F 10 4D 18 E9 97 00 00 00 66 83 F8 01 75 10 F2 0F 10 0D ?? ?? ?? ?? 0F 28 D1 E9 81 00 00 00 F2 0F 10 45 10 E8 ?? ?? ?? ?? 0F 28 F8 F2 0F 10 45 18 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 28 F7 F2 0F 59 F7 F2 0F 58 F1 F2 0F 59 F0 44 0F 28 C6 F2 44 0F 59 C0 F2 44 0F 58 C1 66 44 0F 2E 05 ?? ?? ?? ?? 7A 19 75 17 0F 57 D2 66 0F 2F D0 76 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 FA EB 1E F2 0F 59 C0 F2 41 0F 5E F8 F2 0F 58 C1 E8 ?? ?? ?? ?? F2 0F 59 C6 F2 41 0F 5E C0 0F 28 C8 0F 28 D7 48 8D 4D C0 E8 ?? ?? ?? ?? 0F 28 74 24 50 4C 8D 5C 24 60 49 8B 5B 20 0F 28 7C 24 40 0F 10 00 48 8B C7 45 0F 28 43 D0 F3 0F 7F 07 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_154_5_0 {
	meta:
		name = "_mbsnccnt_l"
		size = 152
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0033 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B DA 48 8B F9 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 85 FF 75 19 48 85 DB 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 D2 EB 3C 33 D2 48 85 DB 74 35 48 8B 4C 24 30 48 FF CB 80 3F 00 74 28 0F B6 07 F6 44 08 19 04 74 13 48 8B C3 48 FF CB 48 85 C0 74 13 48 FF C7 80 3F 00 74 0B 48 FF C2 48 FF C7 48 85 DB 75 D0 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B C2 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "lldiv"
		size = 19
	strings:
		$1 = { 48 8B C2 48 99 49 F7 F8 48 89 01 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "??$common_dupenv_s@D@@YAHQEAPEADQEA_KQEBDH2H@Z"
		size = 257
		refs = "0028 __acrt_lock 003c _errno 0048 _invalid_parameter_noinfo 0069 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 008d calloc 00b3 strcpy_s 00c9 __acrt_unlock 00e1 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 30 49 8B F8 48 8B F2 4C 8B F9 B9 0B 00 00 00 E8 ?? ?? ?? ?? 90 33 DB 8B C3 4D 85 FF 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 75 49 89 1F 48 85 F6 74 03 48 89 1E 8B C3 48 85 FF 0F 95 C0 85 C0 74 D6 48 8B CF E8 ?? ?? ?? ?? 4C 8B F0 48 85 C0 74 4E 48 83 CF FF 48 FF C7 38 1C 38 75 F8 BA 01 00 00 00 48 03 FA 48 8B CF E8 ?? ?? ?? ?? 49 89 07 48 85 C0 75 10 E8 ?? ?? ?? ?? B9 0C 00 00 00 89 08 8B D9 EB 1A 4D 8B C6 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 16 48 85 F6 74 03 48 89 3E B9 0B 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 15 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 74 24 58 48 83 C4 30 41 5F C3 }
	condition:
		$1
}

rule file_156_1_0 {
	meta:
		name = "?fin$0@?0???$common_dupenv_s@D@@YAHQEAPEADQEA_KQEBDH2H@Z@4HA"
		size = 25
		refs = "0014 __acrt_unlock"
		altNames = "?fin$0@?0???$common_dupenv_s@_W@@YAHQEAPEA_WQEA_KQEB_WHQEBDH@Z@4HA ?fin$0@?0???$common_getenv_s@D@@YAHQEA_KQEAD_KQEBD@Z@4HA ?fin$0@?0???$common_getenv_s@_W@@YAHQEA_KQEA_W_KQEB_W@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 0B 00 00 00 48 83 C4 30 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_156_2_0 {
	meta:
		name = "??$common_dupenv_s@_W@@YAHQEAPEA_WQEA_KQEB_WHQEBDH@Z"
		size = 258
		refs = "0028 __acrt_lock 003c _errno 0048 _invalid_parameter_noinfo 0069 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 008e calloc 00b4 wcscpy_s 00ca __acrt_unlock 00e2 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 30 49 8B F8 48 8B F2 4C 8B F9 B9 0B 00 00 00 E8 ?? ?? ?? ?? 90 33 DB 8B C3 4D 85 FF 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 76 49 89 1F 48 85 F6 74 03 48 89 1E 8B C3 48 85 FF 0F 95 C0 85 C0 74 D6 48 8B CF E8 ?? ?? ?? ?? 4C 8B F0 48 85 C0 74 4F 48 83 CF FF 48 FF C7 66 39 1C 78 75 F7 48 FF C7 BA 02 00 00 00 48 8B CF E8 ?? ?? ?? ?? 49 89 07 48 85 C0 75 10 E8 ?? ?? ?? ?? B9 0C 00 00 00 89 08 8B D9 EB 1A 4D 8B C6 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 16 48 85 F6 74 03 48 89 3E B9 0B 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 15 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 74 24 58 48 83 C4 30 41 5F C3 }
	condition:
		$1
}

rule file_156_4_0 {
	meta:
		name = "??$common_dupenv_s_nolock@D@@YAHQEAPEADQEA_KQEBDH2H@Z"
		size = 214
		refs = "0021 _errno 002d _invalid_parameter_noinfo 005f ??$common_getenv_nolock@D@@YAPEADQEBD@Z 0088 calloc 00ae strcpy_s 00d1 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 30 48 8B FA 4C 8B F1 48 85 C9 75 29 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 48 83 C4 30 41 5E C3 48 83 21 00 48 85 D2 74 04 48 83 22 00 4D 85 C0 74 C5 49 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 04 33 C0 EB C4 48 83 CB FF 48 FF C3 80 3C 18 00 75 F7 BA 01 00 00 00 48 03 DA 48 8B CB E8 ?? ?? ?? ?? 49 89 06 48 85 C0 75 10 E8 ?? ?? ?? ?? B9 0C 00 00 00 89 08 8B C1 EB 8F 4C 8B C6 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 0A 48 85 FF 74 B0 48 89 1F EB AB 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_156_5_0 {
	meta:
		name = "??$common_dupenv_s_nolock@_W@@YAHQEAPEA_WQEA_KQEB_WHQEBDH@Z"
		size = 222
		refs = "0027 _errno 0033 _invalid_parameter_noinfo 0068 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 0091 calloc 00b7 wcscpy_s 00d9 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 30 33 ED 48 8B FA 4C 8B F1 48 85 C9 75 2E E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5E C3 48 89 29 48 85 D2 74 03 48 89 2A 4D 85 C0 74 C2 49 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 04 33 C0 EB C1 48 83 CB FF 48 FF C3 66 39 2C 58 75 F7 48 FF C3 BA 02 00 00 00 48 8B CB E8 ?? ?? ?? ?? 49 89 06 48 85 C0 75 10 E8 ?? ?? ?? ?? B9 0C 00 00 00 89 08 8B C1 EB 8C 4C 8B C6 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 0A 48 85 FF 74 B0 48 89 1F EB AB 45 33 C9 48 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_156_6_0 {
	meta:
		name = "??$common_getenv@D@@YAPEADQEBD@Z"
		size = 107
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 002f strnlen 0048 __acrt_lock 0051 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 005e __acrt_unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C BA FF 7F 00 00 E8 ?? ?? ?? ?? 33 C9 48 3D FF 7F 00 00 0F 92 C1 85 C9 74 D3 B9 0B 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B D8 B9 0B 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_156_8_0 {
	meta:
		name = "??$common_getenv@_W@@YAPEA_WQEB_W@Z"
		size = 107
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 002f wcsnlen 0048 __acrt_lock 0051 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 005e __acrt_unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C BA FF 7F 00 00 E8 ?? ?? ?? ?? 33 C9 48 3D FF 7F 00 00 0F 92 C1 85 C9 74 D3 B9 0B 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B D8 B9 0B 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_156_7_0 {
	meta:
		name = "?fin$0@?0???$common_getenv@D@@YAPEADQEBD@Z@4HA"
		size = 25
		refs = "0014 __acrt_unlock"
		altNames = "?fin$0@?0???$common_getenv@_W@@YAPEA_WQEB_W@Z@4HA ?fin$0@?0???$common_putenv@D@@YAHQEBD0@Z@4HA ?fin$0@?0???$common_putenv@_W@@YAHQEB_W0@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 0B 00 00 00 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_156_10_0 {
	meta:
		name = "??$common_getenv_nolock@D@@YAPEADQEBD@Z"
		size = 136
		refs = "0013 __dcrt_get_or_create_narrow_environment_nolock 0059 _strnicoll"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 57 48 85 F6 74 52 48 83 CF FF 48 FF C7 80 3C 3E 00 75 F7 48 83 38 00 74 3F 48 8B 0B 48 83 C8 FF 48 FF C0 80 3C 01 00 75 F7 48 3B C7 76 15 80 3C 39 3D 75 0F 4C 8B C7 48 8B D6 E8 ?? ?? ?? ?? 85 C0 74 0A 48 83 C3 08 48 83 3B 00 EB CA 48 8B 03 48 FF C0 48 03 C7 EB 02 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_156_11_0 {
	meta:
		name = "??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z"
		size = 149
		refs = "0018 __dcrt_get_or_create_wide_environment_nolock 0060 _wcsnicoll"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F1 E8 ?? ?? ?? ?? 33 ED 48 8B D8 48 85 C0 74 58 48 85 F6 74 53 48 83 CF FF 48 FF C7 66 39 2C 7E 75 F7 48 39 28 74 41 48 8B 0B 48 83 C8 FF 48 FF C0 66 39 2C 41 75 F7 48 3B C7 76 16 66 83 3C 79 3D 75 0F 4C 8B C7 48 8B D6 E8 ?? ?? ?? ?? 85 C0 74 09 48 83 C3 08 48 39 2B EB CA 48 8B 03 48 8D 04 78 48 83 C0 02 EB 02 33 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_156_12_0 {
	meta:
		name = "??$common_getenv_s@D@@YAHQEA_KQEAD_KQEBD@Z"
		size = 253
		refs = "002b __acrt_lock 003f _errno 004b _invalid_parameter_noinfo 0080 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 00b7 strcpy_s 00c5 __acrt_unlock 00dd _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 30 4D 8B F9 49 8B F0 48 8B FA 4C 8B F1 B9 0B 00 00 00 E8 ?? ?? ?? ?? 90 33 DB 8B C3 4D 85 F6 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 6E 49 89 1E 48 85 FF 74 0A 48 85 F6 75 0A 48 85 FF 75 0C 48 85 F6 75 07 B8 01 00 00 00 EB 02 8B C3 85 C0 74 C9 48 85 FF 74 02 88 1F 49 8B CF E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 74 33 48 83 C8 FF 48 FF C0 41 38 1C 00 75 F7 48 FF C0 49 89 06 48 85 F6 74 1B 48 3B C6 76 07 BB 22 00 00 00 EB 0F 48 8B D6 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 0E B9 0B 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 15 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 74 24 58 48 83 C4 30 41 5F C3 }
	condition:
		$1
}

rule file_156_14_0 {
	meta:
		name = "??$common_getenv_s@_W@@YAHQEA_KQEA_W_KQEB_W@Z"
		size = 255
		refs = "002b __acrt_lock 003f _errno 004b _invalid_parameter_noinfo 0081 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 00b9 wcscpy_s 00c7 __acrt_unlock 00df _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 30 4D 8B F9 49 8B F0 48 8B FA 4C 8B F1 B9 0B 00 00 00 E8 ?? ?? ?? ?? 90 33 DB 8B C3 4D 85 F6 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 70 49 89 1E 48 85 FF 74 0A 48 85 F6 75 0A 48 85 FF 75 0C 48 85 F6 75 07 B8 01 00 00 00 EB 02 8B C3 85 C0 74 C9 48 85 FF 74 03 66 89 1F 49 8B CF E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 74 34 48 83 C8 FF 48 FF C0 66 41 39 1C 40 75 F6 48 FF C0 49 89 06 48 85 F6 74 1B 48 3B C6 76 07 BB 22 00 00 00 EB 0F 48 8B D6 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 0E B9 0B 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 15 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 74 24 58 48 83 C4 30 41 5F C3 }
	condition:
		$1
}

rule file_156_16_0 {
	meta:
		name = "??$common_getenv_s_nolock@D@@YAHQEA_KQEAD_KQEBD@Z"
		size = 187
		refs = "001e _errno 002a _invalid_parameter_noinfo 0061 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 009d strcpy_s 00b6 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 49 8B D8 48 8B FA 48 8B F1 48 85 C9 75 23 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 48 83 21 00 48 85 D2 74 07 48 85 DB 75 07 EB CD 48 85 DB 75 C8 48 85 D2 74 03 C6 02 00 49 8B C9 E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 75 04 33 C0 EB BF 48 83 C8 FF 48 FF C0 41 80 3C 00 00 75 F6 48 FF C0 48 89 06 48 85 DB 74 E3 48 3B C3 76 07 B8 22 00 00 00 EB 9A 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 C8 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_156_17_0 {
	meta:
		name = "??$common_getenv_s_nolock@_W@@YAHQEA_KQEA_W_KQEB_W@Z"
		size = 197
		refs = "0025 _errno 0031 _invalid_parameter_noinfo 006c ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 00a8 wcscpy_s 00c0 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 33 ED 49 8B D8 48 8B FA 48 8B F1 48 85 C9 75 28 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 48 89 29 48 85 D2 74 07 48 85 DB 75 07 EB C9 48 85 DB 75 C4 48 85 D2 74 03 66 89 2A 49 8B C9 E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 75 04 33 C0 EB BB 48 83 C8 FF 48 FF C0 66 41 39 2C 40 75 F6 48 FF C0 48 89 06 48 85 DB 74 E3 48 3B C3 76 07 B8 22 00 00 00 EB 96 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 C8 45 33 C9 48 89 6C 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_158_20_0 {
	meta:
		name = "??$common_vfscanf@D@@YAH_KQEAU_iobuf@@QEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 133
		refs = "0021 _errno 002c _invalid_parameter_noinfo 007b ??$?RV<lambda_082dd7c0feb7dbdaf245f261e54a6583>@@AEAV<lambda_f3caf1ecae5fe01a9a1a6239afa44510>@@V<lambda_c640b76c0755ae85b317b35c67c61e6b>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_082dd7c0feb7dbdaf245f261e54a6583>@@AEAV<lambda_f3caf1ecae5fe01a9a1a6239afa44510>@@$$QEAV<lambda_c640b76c0755ae85b317b35c67c61e6b>@@@Z"
	strings:
		$1 = { 48 8B C4 4C 89 48 20 4C 89 40 18 48 89 50 10 48 89 48 08 55 48 8B EC 48 83 EC 60 48 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4A 4D 85 C0 74 E6 48 8D 45 28 48 89 55 C8 48 89 45 D8 4C 8D 4D C8 48 8D 45 18 48 89 55 D0 48 89 45 E0 4C 8D 45 D8 48 8D 45 10 48 89 45 E8 48 8D 55 D0 48 8D 45 20 48 89 45 F0 48 8D 4D C0 48 8D 45 30 48 89 45 F8 E8 ?? ?? ?? ?? 48 83 C4 60 5D C3 }
	condition:
		$1
}

rule file_158_21_0 {
	meta:
		name = "??$common_vfscanf@_W@@YAH_KQEAU_iobuf@@QEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 133
		refs = "0021 _errno 002c _invalid_parameter_noinfo 007b ??$?RV<lambda_1c23a5dd5e46d7c5fbe45428cfdcd388>@@AEAV<lambda_ad9c22e73f4850e44729a5f831ae9ec1>@@V<lambda_13a597834fd3cef18bd4341e137232db>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_1c23a5dd5e46d7c5fbe45428cfdcd388>@@AEAV<lambda_ad9c22e73f4850e44729a5f831ae9ec1>@@$$QEAV<lambda_13a597834fd3cef18bd4341e137232db>@@@Z"
	strings:
		$1 = { 48 8B C4 4C 89 48 20 4C 89 40 18 48 89 50 10 48 89 48 08 55 48 8B EC 48 83 EC 60 48 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4A 4D 85 C0 74 E6 48 8D 45 28 48 89 55 C8 48 89 45 D8 4C 8D 4D C8 48 8D 45 18 48 89 55 D0 48 89 45 E0 4C 8D 45 D8 48 8D 45 10 48 89 45 E8 48 8D 55 D0 48 8D 45 20 48 89 45 F0 48 8D 4D C0 48 8D 45 30 48 89 45 F8 E8 ?? ?? ?? ?? 48 83 C4 60 5D C3 }
	condition:
		$1
}

rule file_158_22_0 {
	meta:
		name = "??$common_vsscanf@D@@YAH_KQEBD01QEAU__crt_locale_pointers@@QEAD@Z"
		size = 303
		refs = "001b __security_cookie 0038 _errno 0043 _invalid_parameter_noinfo 005b strnlen 006c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00b5 memset 00f5 ?process@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QEAAHXZ 0114 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 56 41 57 48 8D 6C 24 F0 48 81 EC 10 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 00 45 33 FF 49 8B F1 48 8B FA 4C 8B F1 48 85 D2 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 BD 00 00 00 4D 85 C9 74 E3 49 8B D0 48 8B CF E8 ?? ?? ?? ?? 48 8B 55 60 48 8D 4C 24 38 48 8B D8 E8 ?? ?? ?? ?? 48 8D 04 1F 48 89 7C 24 20 33 D2 48 89 44 24 28 0F 10 44 24 20 48 89 7C 24 30 48 8D 4D B4 F2 0F 10 4C 24 30 44 8D 42 20 4C 89 74 24 60 0F 11 44 24 68 4C 89 75 80 F2 0F 11 4C 24 78 48 89 75 88 44 89 7D 90 E8 ?? ?? ?? ?? 48 8D 44 24 40 44 89 7D 94 48 89 45 D8 48 8D 4C 24 60 48 8B 45 68 48 89 45 E0 66 44 89 7D 98 44 88 7D 9A 4C 89 7D A0 44 89 7D A8 44 88 7D AC 44 89 7D B0 4C 89 7D E8 4C 89 7D F0 E8 ?? ?? ?? ?? 44 38 7C 24 50 74 0C 48 8B 4C 24 38 83 A1 A8 03 00 00 FD 48 8B 4D 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 40 01 00 00 48 81 C4 10 01 00 00 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_23_0 {
	meta:
		name = "??$common_vsscanf@_W@@YAH_KQEB_W01QEAU__crt_locale_pointers@@QEAD@Z"
		size = 281
		refs = "0031 _errno 003c _invalid_parameter_noinfo 0054 wcsnlen 0064 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00d6 ?process@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QEAAHXZ 00e1 _free_base"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 55 41 56 41 57 48 8D 68 B1 48 81 EC E0 00 00 00 45 33 FF 49 8B F1 48 8B FA 4C 8B F1 48 85 D2 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B4 00 00 00 4D 85 C9 74 E3 49 8B D0 48 8B CF E8 ?? ?? ?? ?? 48 8B 55 77 48 8D 4D 17 48 8B D8 E8 ?? ?? ?? ?? 48 8D 04 5F 48 89 7C 24 20 48 89 44 24 28 48 8D 4D 97 0F 10 44 24 20 48 8D 45 1F 48 89 7D 87 F2 0F 10 4D 87 48 89 45 F7 48 8B 45 7F 48 89 45 FF 4C 89 75 97 0F 11 45 9F 4C 89 75 B7 F2 0F 11 4D AF 48 89 75 BF 4C 89 7D C7 4C 89 7D EF 44 89 7D CF 44 88 7D D3 4C 89 7D D7 44 89 7D DF 44 88 7D E3 44 89 7D E7 4C 89 7D 07 4C 89 7D 0F E8 ?? ?? ?? ?? 48 8B 4D EF 8B D8 E8 ?? ?? ?? ?? 4C 89 7D EF 44 38 7D 2F 74 0B 48 8B 4D 17 83 A1 A8 03 00 00 FD 8B C3 4C 8D 9C 24 E0 00 00 00 49 8B 5B 20 49 8B 73 28 49 8B 7B 30 49 8B E3 41 5F 41 5E 5D C3 }
	condition:
		$1
}

rule file_158_38_0 {
	meta:
		name = "??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
		size = 55
	strings:
		$1 = { F6 C1 04 74 03 B0 01 C3 F6 C1 01 74 27 83 E1 02 74 0F 48 B8 00 00 00 00 00 00 00 80 48 3B D0 77 E4 85 C9 75 0F 48 B8 FF FF FF FF FF FF FF 7F 48 3B D0 77 D1 32 C0 C3 }
	condition:
		$1
}

rule file_158_41_0 {
	meta:
		name = "??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAV?$stream_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z"
		size = 29
		altNames = "??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QEAV?$console_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z ??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$console_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z ??$make_input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAV?$string_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z ??$make_input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$string_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z ??0?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@QEAV?$console_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z ??0?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@QEAV?$console_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z ??0?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@QEAV?$stream_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z ??0?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@QEAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z ??0?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@QEAV?$string_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z ??0?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@QEAV?$string_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z"
	strings:
		$1 = { 48 83 61 10 00 48 89 11 4C 89 41 08 4C 89 49 18 4D 85 C9 74 04 41 C6 01 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_158_45_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAM@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_686_30_2 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QEAM@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_686_31_2 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QEAN@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_686_32_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QEAM@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_686_33_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QEAN@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_158_46_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAN@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_158_47_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAM@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_158_48_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAN@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_158_49_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAM@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_158_50_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAN@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_158_51_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAM@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_158_52_4 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAN@Z"
		size = 166
		refs = "0010 __security_cookie 002b _errno 0036 _invalid_parameter_noinfo 005f ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 006e ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0091 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 40 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 03 00 00 49 8B F8 48 8B DA 4D 85 C0 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 0A 48 83 7B 10 00 75 03 C6 00 00 B8 01 00 00 00 EB 31 48 85 C9 74 D1 4C 8D 44 24 20 E8 ?? ?? ?? ?? 4C 8B C7 48 8D 54 24 20 8B C8 E8 ?? ?? ?? ?? 48 8B 4B 18 48 85 C9 74 0A 48 83 7B 10 00 75 03 C6 01 00 48 8B 8C 24 30 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 68 03 00 00 48 81 C4 40 03 00 00 5F C3 }
	condition:
		$1
}

rule file_158_53_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z"
		size = 2116
		refs = "0036 _errno 0041 _invalid_parameter_noinfo 006f _getc_nolock 00a2 _isctype_l 00b8 __pctype_func 021f _ungetc_nolock 0817 ??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0828 ??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 4C 89 44 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 40 48 8B 32 33 FF 4D 8B E0 48 8B DA 4C 8B F9 48 85 F6 74 06 48 39 7A 18 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 07 00 00 00 E9 DD 07 00 00 4C 8B 6A 10 4C 89 6D F0 49 8D 45 01 48 89 42 10 48 39 7A 08 74 06 48 3B 42 08 77 15 48 8B 0E E8 ?? ?? ?? ?? 8B D0 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A D7 88 55 48 0F B6 F2 4D 85 FF 74 29 49 8B 07 83 78 08 01 7E 11 4D 8B C7 BA 08 00 00 00 8B CE E8 ?? ?? ?? ?? EB 1B 48 8B 00 48 63 CE 0F B7 04 48 83 E0 08 EB 0F E8 ?? ?? ?? ?? 0F B7 04 70 83 E0 08 8A 55 48 85 C0 74 34 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 8A D0 88 45 48 EB 88 80 FA 2D 49 8D 8C 24 08 03 00 00 48 89 4D F8 0F 94 C0 88 01 8D 42 D5 A8 FD 75 32 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 8A D0 88 45 48 8D 42 B7 A8 DF 0F 84 C7 06 00 00 8D 42 B2 A8 DF 0F 84 AB 06 00 00 40 88 7D 58 44 8A F7 80 FA 30 0F 85 B8 00 00 00 4C 8B 73 10 49 8D 46 01 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 65 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 8B C8 83 F8 FF 74 50 48 FF 46 08 83 C0 A8 A8 DF 75 40 48 FF 43 10 48 8B 43 10 C6 45 58 01 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 4C 89 75 F0 8A D0 44 8A 75 58 88 45 48 EB 43 8A 55 48 EB 06 8A 55 48 40 8A CF 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 21 8D 41 01 3C 01 76 1A 48 8B 03 0F BE C9 83 F9 FF 74 0F 48 FF 48 08 48 8B 10 E8 ?? ?? ?? ?? 8A 55 48 44 8A F7 89 7D E0 49 8D 44 24 08 48 89 45 E8 48 8B C8 44 8B C7 44 8A E7 80 FA 30 75 43 41 B4 01 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1F 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 0F 48 FF 46 08 8A D0 88 45 48 3C 30 75 08 EB CD 40 8A D7 88 55 48 48 8B 4D E8 44 8B C7 4C 8B 6D F8 41 8A C6 F6 D8 45 1B F6 41 83 E6 06 41 83 C6 09 8D 42 D0 3C 09 77 08 0F BE C2 83 E8 30 EB 21 8D 42 9F 3C 19 77 08 0F BE C2 83 E8 57 EB 12 8D 42 BF 3C 19 77 08 0F BE C2 83 E8 37 EB 03 83 C8 FF 41 3B C6 77 57 41 B4 01 49 3B CD 74 09 88 01 48 FF C1 48 89 4D E8 48 FF 43 10 41 FF C0 48 8B 43 10 44 89 45 E0 48 39 7B 08 74 06 48 3B 43 08 77 1E 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 48 8B 4D E8 44 8B 45 E0 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 8A D0 88 45 48 E9 74 FF FF FF 49 8B 07 4C 8B 6D F0 48 8B 88 F8 00 00 00 48 8B 01 3A 10 0F 85 09 01 00 00 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 48 8B 4D 50 8A D0 4C 8B 7D E8 48 83 C1 08 88 45 48 4C 3B F9 75 43 3C 30 75 3F 41 B4 01 48 FF 43 10 FF 4D E0 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1F 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 0F 48 FF 46 08 8A D0 88 45 48 3C 30 75 08 EB CA 40 8A D7 88 55 48 4C 8B 6D F8 8D 42 D0 3C 09 77 08 0F BE C2 83 E8 30 EB 21 8D 42 9F 3C 19 77 08 0F BE C2 83 E8 57 EB 12 8D 42 BF 3C 19 77 08 0F BE C2 83 E8 37 EB 03 83 C8 FF 41 3B C6 77 42 41 B4 01 4D 3B FD 74 06 41 88 07 49 FF C7 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 8A D0 88 45 48 EB 89 4C 8B 6D F0 4C 89 7D E8 48 FF 4B 10 48 8B 43 10 45 84 E4 75 4C 48 39 7B 08 74 06 48 3B 43 08 77 1E 8D 42 01 3C 01 76 17 0F BE CA 48 8B 13 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 4C 3B 6B 10 74 0C 48 8B 43 18 40 88 38 E9 B4 FB FF FF F6 5D 58 1B C0 83 E0 FB 83 C0 07 E9 8B 03 00 00 48 39 7B 08 74 06 48 3B 43 08 77 1E 8D 42 01 3C 01 76 17 0F BE CA 48 8B 13 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 4C 8B 6B 10 49 8D 45 01 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 18 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 8B C8 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A CF 88 4D 48 40 8A C7 80 F9 45 74 14 80 F9 50 74 0A 80 F9 65 74 0A 80 F9 70 75 0C 8A 45 58 EB 07 40 38 7D 58 0F 94 C0 44 8B F7 84 C0 0F 84 21 02 00 00 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 3C 2D 88 45 48 8A C8 41 0F 94 C4 2C 2B A8 FD 75 32 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 8A C8 88 45 48 44 8A FF 80 F9 30 75 3C 41 B7 01 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1F 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 0F 48 FF 46 08 8A C8 88 45 48 3C 30 75 08 EB CD 40 8A CF 88 4D 48 8D 41 D0 3C 09 77 08 0F BE D1 83 EA 30 EB 21 8D 41 9F 3C 19 77 08 0F BE D1 83 EA 57 EB 12 8D 41 BF 3C 19 77 08 0F BE D1 83 EA 37 EB 03 83 CA FF 83 FA 0A 73 4E 43 8D 04 B6 41 B7 01 44 8D 34 42 41 81 FE 50 14 00 00 7F 34 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 8A C8 88 45 48 EB 83 41 BE 51 14 00 00 8D 41 D0 3C 09 77 08 0F BE C1 83 E8 30 EB 21 8D 41 9F 3C 19 77 08 0F BE C1 83 E8 57 EB 12 8D 41 BF 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 34 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 8A C8 88 45 48 EB 97 45 84 E4 74 03 41 F7 DE 45 84 FF 75 74 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 48 8B 43 10 40 88 7D 48 4C 3B E8 0F 85 66 FD FF FF 48 FF C0 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 03 40 8A C7 8A C8 88 45 48 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 4C 8B 55 50 48 8B 55 E8 4D 8D 42 08 49 3B D0 74 72 48 8D 42 FF 40 38 38 75 08 48 8B D0 49 3B C0 75 EF 49 3B D0 74 5C 41 81 FE 50 14 00 00 7E 07 B8 09 00 00 00 EB 73 41 BB B0 EB FF FF 45 3B F3 7D 07 B8 08 00 00 00 EB 61 44 8A 4D 58 41 8A C1 F6 D8 1B C9 83 E1 03 FF C1 0F AF 4D E0 44 03 F1 41 81 FE 50 14 00 00 7F C7 45 3B F3 7C D4 41 2B D0 45 89 32 45 84 C9 41 89 52 04 40 0F 95 C7 8B C7 EB 27 B8 02 00 00 00 EB 20 4D 8B C5 48 8D 4D 48 48 8B D3 E8 ?? ?? ?? ?? EB 0F 4D 8B C5 48 8D 4D 48 48 8B D3 E8 ?? ?? ?? ?? 48 8B 9C 24 80 00 00 00 48 83 C4 40 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_54_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z"
		size = 4615
		refs = "0035 _errno 0040 _invalid_parameter_noinfo 0079 _getwc_nolock 009d iswctype 027c _ungetwc_nolock 11e1 ??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 11f2 ??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 4C 24 08 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 58 48 8B 3A 45 33 F6 4D 8B E0 48 8B DA 48 85 FF 74 06 4C 39 72 18 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 07 00 00 00 E9 A8 11 00 00 BE 01 00 00 00 4C 8B 6A 10 4C 89 6D D8 49 8D 45 01 48 89 42 10 4C 39 72 08 74 0C 48 3B 42 08 76 06 41 0F B7 C6 EB 1B 48 8B 0F E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 06 48 01 77 08 EB 03 41 8B C6 BA 08 00 00 00 66 89 45 CC 0F B7 C8 E8 ?? ?? ?? ?? 85 C0 74 4F 41 BF FF FF 00 00 48 01 73 10 48 8B 43 10 4C 39 73 08 74 0C 48 3B 43 08 76 06 41 0F B7 C6 EB 1A 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 66 41 3B C7 74 06 48 01 77 08 EB 03 41 8B C6 BA 08 00 00 00 66 89 45 CC 0F B7 C8 E8 ?? ?? ?? ?? 85 C0 75 B7 44 0F B7 45 CC 49 8D 8C 24 08 03 00 00 66 41 83 F8 2D 48 89 4D E8 0F 94 C0 88 01 41 8D 40 D5 B9 FD FF 00 00 66 85 C1 75 41 48 01 73 10 48 8B 43 10 4C 39 73 08 74 0B 48 3B 43 08 76 05 45 8B C6 EB 23 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 0A 48 01 77 08 44 0F B7 C0 EB 04 45 0F B7 C6 66 44 89 45 CC 41 8D 40 B7 B9 DF FF 00 00 66 85 C1 0F 84 77 10 00 00 41 8D 40 B2 66 85 C1 0F 84 59 10 00 00 B8 30 00 00 00 44 88 75 50 45 8A E6 66 44 3B C0 0F 85 F2 00 00 00 48 8B 73 10 48 8D 46 01 48 89 43 10 4C 39 73 08 74 0F 48 3B 43 08 76 09 41 0F B7 CE E9 92 00 00 00 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 0F B7 C8 B8 FF FF 00 00 66 3B C8 74 72 41 B9 01 00 00 00 8D 41 A8 4C 01 4F 08 BA DF FF 00 00 66 85 C2 75 54 4C 01 4B 10 45 8A E1 48 8B 43 10 44 88 4D 50 4C 39 73 08 74 0C 48 3B 43 08 76 06 45 0F B7 C6 EB 28 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 44 0F B7 C0 B8 FF FF 00 00 66 44 3B C0 74 0B BA 01 00 00 00 48 01 57 08 EB 03 45 8B C6 66 44 89 45 CC 48 89 75 D8 EB 4E 44 0F B7 45 CC EB 0E 44 0F B7 45 CC 41 8B CE 41 B9 01 00 00 00 48 FF 4B 10 48 8B 43 10 4C 39 73 08 74 06 48 3B 43 08 77 25 0F B7 C1 BA FD FF 00 00 66 41 2B C1 66 3B C2 77 14 48 8B 13 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 44 0F B7 45 CC 48 8B 45 58 41 BA 30 00 00 00 48 83 C0 08 41 8B D6 48 89 45 E0 48 8B C8 89 55 D0 41 8A F6 45 8D 4A D1 66 45 3B C2 75 5A 41 8A F1 4C 01 4B 10 48 8B 43 10 4C 39 73 08 74 06 48 3B 43 08 77 33 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 41 B9 01 00 00 00 B9 FF FF 00 00 45 8D 51 2F 66 3B C1 74 14 4C 01 4F 08 44 0F B7 C0 66 89 45 CC 66 41 3B C2 75 0B EB B9 45 0F B7 C6 66 44 89 75 CC 48 8B 4D E0 41 8B D6 4C 8B 6D E8 41 8A C4 F6 D8 C7 45 60 6A 06 00 00 BF 60 06 00 00 41 BB 10 FF 00 00 45 1B E4 41 BF FF FF 00 00 41 83 E4 06 41 83 C4 09 B8 F0 06 00 00 66 45 3B C2 0F 82 90 02 00 00 66 41 83 F8 3A 73 0C 41 0F B7 C0 41 2B C2 E9 78 02 00 00 66 45 3B C3 0F 83 57 02 00 00 66 44 3B C7 0F 82 69 02 00 00 66 44 3B 45 60 73 0B 41 0F B7 C0 2B C7 E9 52 02 00 00 66 44 3B C0 0F 82 4D 02 00 00 B8 FA 06 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D F0 06 00 00 E9 2F 02 00 00 B8 66 09 00 00 66 44 3B C0 0F 82 25 02 00 00 B8 70 09 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D 66 09 00 00 E9 07 02 00 00 B8 E6 09 00 00 66 44 3B C0 0F 82 FD 01 00 00 B8 F0 09 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D E6 09 00 00 E9 DF 01 00 00 B8 66 0A 00 00 66 44 3B C0 0F 82 D5 01 00 00 B8 70 0A 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D 66 0A 00 00 E9 B7 01 00 00 B8 E6 0A 00 00 66 44 3B C0 0F 82 AD 01 00 00 B8 F0 0A 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D E6 0A 00 00 E9 8F 01 00 00 B8 66 0B 00 00 66 44 3B C0 0F 82 85 01 00 00 B8 70 0B 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D 66 0B 00 00 E9 67 01 00 00 B8 66 0C 00 00 66 44 3B C0 0F 82 5D 01 00 00 B8 70 0C 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D 66 0C 00 00 E9 3F 01 00 00 B8 E6 0C 00 00 66 44 3B C0 0F 82 35 01 00 00 B8 F0 0C 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D E6 0C 00 00 E9 17 01 00 00 B8 66 0D 00 00 66 44 3B C0 0F 82 0D 01 00 00 B8 70 0D 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D 66 0D 00 00 E9 EF 00 00 00 B8 50 0E 00 00 66 44 3B C0 0F 82 E5 00 00 00 B8 5A 0E 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D 50 0E 00 00 E9 C7 00 00 00 B8 D0 0E 00 00 66 44 3B C0 0F 82 BD 00 00 00 B8 DA 0E 00 00 66 44 3B C0 73 0E 41 0F B7 C0 2D D0 0E 00 00 E9 9F 00 00 00 B8 20 0F 00 00 66 44 3B C0 0F 82 95 00 00 00 B8 2A 0F 00 00 66 44 3B C0 73 0B 41 0F B7 C0 2D 20 0F 00 00 EB 7A B8 40 10 00 00 66 44 3B C0 72 74 B8 4A 10 00 00 66 44 3B C0 73 0B 41 0F B7 C0 2D 40 10 00 00 EB 59 B8 E0 17 00 00 66 44 3B C0 72 53 B8 EA 17 00 00 66 44 3B C0 73 0B 41 0F B7 C0 2D E0 17 00 00 EB 38 B8 10 18 00 00 66 44 3B C0 72 32 B8 1A 18 00 00 66 44 3B C0 73 27 41 0F B7 C0 2D 10 18 00 00 EB 17 B8 1A FF 00 00 66 44 3B C0 73 09 41 0F B7 C0 41 2B C3 EB 03 83 C8 FF 83 F8 FF 75 2D 41 8D 40 BF 66 83 F8 19 76 0F 41 8D 40 9F 66 83 F8 19 76 05 83 C8 FF EB 14 41 8D 40 9F 66 83 F8 19 41 0F B7 C0 77 03 83 E8 20 83 C0 C9 41 3B C4 77 75 41 8A F1 49 3B CD 74 09 88 01 49 03 C9 48 89 4D E0 4C 01 4B 10 41 03 D1 48 8B 43 10 89 55 D0 4C 39 73 08 74 0C 48 3B 43 08 76 06 45 0F B7 C6 EB 3A 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 48 8B 4D E0 41 B9 01 00 00 00 8B 55 D0 44 0F B7 C0 41 BB 10 FF 00 00 45 8D 51 2F 66 41 3B C7 74 06 4C 01 4F 08 EB 03 45 8B C6 BF 60 06 00 00 66 44 89 45 CC E9 BA FC FF FF 4C 8B 7D 48 4C 8B 6D D8 49 8B 07 48 8B 88 F8 00 00 00 48 8B 01 0F BE 08 41 0F B7 C0 3B C1 0F 85 2A 03 00 00 4C 01 4B 10 48 8B 43 10 4C 39 73 08 74 0C 48 3B 43 08 76 06 41 0F B7 C6 EB 28 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 41 B9 01 00 00 00 B9 FF FF 00 00 45 8D 51 2F 66 3B C1 74 06 4C 01 4F 08 EB 03 41 8B C6 48 8B 55 58 44 0F B7 C0 4C 8B 7D E0 66 89 45 CC 48 8D 4A 08 4C 3B F9 75 5C 66 41 3B C2 75 56 41 8A F1 4C 01 4B 10 44 29 4D D0 48 8B 43 10 4C 39 73 08 74 06 48 3B 43 08 77 32 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 1D 41 B9 01 00 00 00 44 0F B7 C0 4C 01 4F 08 66 89 45 CC 41 8D 49 2F 66 3B C1 75 0B EB B6 66 44 89 75 CC 45 0F B7 C6 4C 8B 6D E8 B9 30 00 00 00 66 44 3B C1 0F 82 C7 01 00 00 66 41 83 F8 3A 73 0B 41 0F B7 C0 2B C1 E9 B0 01 00 00 B9 10 FF 00 00 66 44 3B C1 0F 83 8F 01 00 00 B9 60 06 00 00 66 44 3B C1 0F 82 97 01 00 00 8D 41 0A 66 44 3B C0 72 CE B9 F0 06 00 00 66 44 3B C1 0F 82 7F 01 00 00 8D 41 0A 66 44 3B C0 72 B6 B9 66 09 00 00 66 44 3B C1 0F 82 67 01 00 00 8D 41 0A 66 44 3B C0 72 9E 8D 48 76 66 44 3B C1 0F 82 51 01 00 00 8D 41 0A 66 44 3B C0 72 88 8D 48 76 66 44 3B C1 0F 82 3B 01 00 00 8D 41 0A 66 44 3B C0 0F 82 6E FF FF FF 8D 48 76 66 44 3B C1 0F 82 21 01 00 00 8D 41 0A 66 44 3B C0 0F 82 54 FF FF FF 8D 48 76 66 44 3B C1 0F 82 07 01 00 00 8D 41 0A 66 44 3B C0 0F 82 3A FF FF FF B9 66 0C 00 00 66 44 3B C1 0F 82 EB 00 00 00 8D 41 0A 66 44 3B C0 0F 82 1E FF FF FF 8D 48 76 66 44 3B C1 0F 82 D1 00 00 00 8D 41 0A 66 44 3B C0 0F 82 04 FF FF FF 8D 48 76 66 44 3B C1 0F 82 B7 00 00 00 8D 41 0A 66 44 3B C0 0F 82 EA FE FF FF B9 50 0E 00 00 66 44 3B C1 0F 82 9B 00 00 00 8D 41 0A 66 44 3B C0 0F 82 CE FE FF FF 8D 48 76 66 44 3B C1 0F 82 81 00 00 00 8D 41 0A 66 44 3B C0 0F 82 B4 FE FF FF 8D 48 46 66 44 3B C1 72 6B 8D 41 0A 66 44 3B C0 0F 82 9E FE FF FF B9 40 10 00 00 66 44 3B C1 72 53 8D 41 0A 66 44 3B C0 0F 82 86 FE FF FF B9 E0 17 00 00 66 44 3B C1 72 3B 8D 41 0A 66 44 3B C0 0F 82 6E FE FF FF 8D 48 26 66 44 3B C1 72 25 8D 41 0A 66 44 3B C0 73 1C E9 57 FE FF FF B8 1A FF 00 00 66 44 3B C0 0F 82 48 FE FF FF 83 C8 FF 83 F8 FF 75 2D 41 8D 40 BF 66 83 F8 19 76 0F 41 8D 40 9F 66 83 F8 19 76 05 83 C8 FF EB 14 41 8D 40 9F 66 83 F8 19 41 0F B7 C0 77 03 83 E8 20 83 C0 C9 41 3B C4 77 5F B9 01 00 00 00 40 8A F1 4D 3B FD 74 06 41 88 07 4C 03 F9 48 01 4B 10 48 8B 43 10 4C 39 73 08 74 0C 48 3B 43 08 76 06 45 0F B7 C6 EB 28 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 44 0F B7 C0 B8 FF FF 00 00 66 44 3B C0 74 0B BA 01 00 00 00 48 01 57 08 EB 03 45 8B C6 66 44 89 45 CC E9 99 FD FF FF 4C 8B 6D D8 4C 89 7D E0 48 FF 4B 10 48 8B 43 10 40 84 F6 75 4F 4C 39 73 08 74 06 48 3B 43 08 77 21 41 8D 40 FF B9 FD FF 00 00 66 3B C1 77 13 48 8B 13 41 0F B7 C8 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 4C 3B 6B 10 74 0C 48 8B 43 18 44 88 30 E9 31 F6 FF FF F6 5D 50 1B C0 83 E0 FB 83 C0 07 E9 D3 07 00 00 4C 39 73 08 74 06 48 3B 43 08 77 2D 41 0F B7 C0 41 BF 01 00 00 00 66 41 2B C7 B9 FD FF 00 00 66 3B C1 77 1B 48 8B 13 41 0F B7 C8 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? EB 06 41 BF 01 00 00 00 4C 8B 6B 10 4C 89 6D E8 49 8D 45 01 48 89 43 10 4C 39 73 08 74 12 48 3B 43 08 76 0C 41 0F B7 CE 41 BC FF FF 00 00 EB 23 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 41 BC FF FF 00 00 0F B7 C8 66 41 3B C4 74 06 4C 01 7F 08 EB 03 41 8B CE 0F B7 C1 41 8A D6 66 89 4D CC 83 F8 45 74 14 83 F8 50 74 0A 83 F8 65 74 0A 83 F8 70 75 0C 8A 55 50 EB 07 44 38 75 50 0F 94 C2 44 89 75 D8 41 8B F6 84 D2 0F 84 29 06 00 00 4C 01 7B 10 48 8B 43 10 4C 39 73 08 74 0C 48 3B 43 08 76 06 41 0F B7 C6 EB 1A 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 66 41 3B C4 74 06 4C 01 7F 08 EB 03 41 8B C6 66 83 F8 2D 66 89 45 CC 0F B7 C8 BA FD FF 00 00 41 0F 94 C4 66 83 E8 2B 44 88 65 C8 66 85 C2 75 3F 4C 01 7B 10 48 8B 43 10 4C 39 73 08 74 0C 48 3B 43 08 76 06 41 0F B7 CE EB 21 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 0F B7 C8 B8 FF FF 00 00 66 3B C8 74 06 4C 01 7F 08 EB 03 41 8B CE 66 89 4D CC 41 B9 30 00 00 00 44 88 75 60 45 8D 41 D1 66 41 3B C9 75 56 44 88 45 60 4C 01 43 10 48 8B 43 10 4C 39 73 08 74 06 48 3B 43 08 77 32 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 41 B8 01 00 00 00 B9 FF FF 00 00 45 8D 48 2F 66 3B C1 74 13 4C 01 47 08 0F B7 C8 66 89 45 CC 66 41 3B C1 75 0A EB BA 41 0F B7 CE 66 89 4D CC 66 41 3B C9 0F 82 A2 01 00 00 66 83 F9 3A 73 0B 0F B7 D1 41 2B D1 E9 8C 01 00 00 B8 10 FF 00 00 66 3B C8 0F 83 6D 01 00 00 B8 60 06 00 00 66 3B C8 0F 82 75 01 00 00 8D 50 0A 66 3B CA 73 0A 0F B7 D1 2B D0 E9 5E 01 00 00 B8 F0 06 00 00 66 3B C8 0F 82 55 01 00 00 8D 50 0A 66 3B CA 72 E0 B8 66 09 00 00 66 3B C8 0F 82 3F 01 00 00 8D 50 0A 66 3B CA 72 CA 8D 42 76 66 3B C8 0F 82 2B 01 00 00 8D 50 0A 66 3B CA 72 B6 8D 42 76 66 3B C8 0F 82 17 01 00 00 8D 50 0A 66 3B CA 72 A2 8D 42 76 66 3B C8 0F 82 03 01 00 00 8D 50 0A 66 3B CA 72 8E 8D 42 76 66 3B C8 0F 82 EF 00 00 00 8D 50 0A 66 3B CA 0F 82 76 FF FF FF B8 66 0C 00 00 66 3B C8 0F 82 D5 00 00 00 8D 50 0A 66 3B CA 0F 82 5C FF FF FF 8D 42 76 66 3B C8 0F 82 BD 00 00 00 8D 50 0A 66 3B CA 0F 82 44 FF FF FF 8D 42 76 66 3B C8 0F 82 A5 00 00 00 8D 50 0A 66 3B CA 0F 82 2C FF FF FF B8 50 0E 00 00 66 3B C8 0F 82 8B 00 00 00 8D 50 0A 66 3B CA 0F 82 12 FF FF FF 8D 42 76 66 3B C8 72 77 8D 50 0A 66 3B CA 0F 82 FE FE FF FF 8D 42 46 66 3B C8 72 63 8D 50 0A 66 3B CA 0F 82 EA FE FF FF B8 40 10 00 00 66 3B C8 72 4D 8D 50 0A 66 3B CA 0F 82 D4 FE FF FF B8 E0 17 00 00 66 3B C8 72 37 8D 50 0A 66 3B CA 0F 82 BE FE FF FF 8D 42 26 66 3B C8 72 23 8D 50 0A 66 3B CA 73 1B E9 A9 FE FF FF BA 1A FF 00 00 66 3B CA 0F 82 9B FE FF FF 83 CA FF 83 FA FF 75 29 8D 41 BF 66 83 F8 19 76 0E 8D 41 9F 66 83 F8 19 76 05 83 CA FF EB 12 8D 41 9F 0F B7 D1 66 83 F8 19 77 03 83 EA 20 83 C2 C9 83 FA 0A 73 68 8D 04 B6 44 88 45 60 8D 34 42 89 75 D8 81 FE 50 14 00 00 7F 4B 4C 01 43 10 48 8B 43 10 4C 39 73 08 74 0A 48 3B 43 08 0F 87 F1 FD FF FF 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 0F B7 C8 41 B8 01 00 00 00 B8 FF FF 00 00 45 8D 48 2F 66 3B C8 74 09 4C 01 47 08 E9 CA FD FF FF 41 8B CE E9 C2 FD FF FF BE 51 14 00 00 89 75 D8 BE F0 06 00 00 41 BD FF FF 00 00 41 BC 10 FF 00 00 41 BF 60 06 00 00 66 41 3B C9 0F 82 AC 01 00 00 66 83 F9 3A 73 0B 0F B7 C1 41 2B C1 E9 96 01 00 00 66 41 3B CC 0F 83 77 01 00 00 66 41 3B CF 0F 82 87 01 00 00 B8 6A 06 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C7 E9 6D 01 00 00 66 3B CE 0F 82 69 01 00 00 B8 FA 06 00 00 66 3B C8 73 0A 0F B7 C1 2B C6 E9 50 01 00 00 BA 66 09 00 00 66 3B CA 0F 82 47 01 00 00 8D 42 0A 66 3B C8 73 0A 0F B7 C1 2B C2 E9 30 01 00 00 BA E6 09 00 00 66 3B CA 0F 82 27 01 00 00 8D 42 0A 66 3B C8 72 E0 8D 50 76 66 3B CA 0F 82 13 01 00 00 8D 42 0A 66 3B C8 72 CC 8D 50 76 66 3B CA 0F 82 FF 00 00 00 8D 42 0A 66 3B C8 72 B8 8D 50 76 66 3B CA 0F 82 EB 00 00 00 8D 42 0A 66 3B C8 72 A4 BA 66 0C 00 00 66 3B CA 0F 82 D5 00 00 00 8D 42 0A 66 3B C8 72 8E 8D 50 76 66 3B CA 0F 82 C1 00 00 00 8D 42 0A 66 3B C8 0F 82 76 FF FF FF 8D 50 76 66 3B CA 0F 82 A9 00 00 00 8D 42 0A 66 3B C8 0F 82 5E FF FF FF BA 50 0E 00 00 66 3B CA 0F 82 8F 00 00 00 8D 42 0A 66 3B C8 0F 82 44 FF FF FF 8D 50 76 66 3B CA 72 7B 8D 42 0A 66 3B C8 0F 82 30 FF FF FF 8D 50 46 66 3B CA 72 67 8D 42 0A 66 3B C8 0F 82 1C FF FF FF BA 40 10 00 00 66 3B CA 72 51 8D 42 0A 66 3B C8 0F 82 06 FF FF FF BA E0 17 00 00 66 3B CA 72 3B 8D 42 0A 66 3B C8 0F 82 F0 FE FF FF 8D 50 26 66 3B CA 72 27 8D 42 0A 66 3B C8 73 1F E9 DB FE FF FF B8 1A FF 00 00 66 3B C8 73 08 0F B7 C1 41 2B C4 EB 03 83 C8 FF 83 F8 FF 75 29 8D 41 BF 66 83 F8 19 76 0E 8D 41 9F 66 83 F8 19 76 }
	condition:
		$1
}

rule file_158_55_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z"
		size = 2054
		refs = "0033 _errno 003e _invalid_parameter_noinfo 00a2 _isctype_l 00b5 __pctype_func 07db ??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z 07ed ??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 4C 89 44 24 18 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 20 48 8B DA 33 FF 48 8B 12 4D 8B E0 4C 8B F1 48 85 D2 74 06 48 39 7B 18 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 07 00 00 00 E9 A5 07 00 00 4C 8B 7B 10 49 8D 47 01 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 19 48 8B 42 10 48 3B 42 08 74 0F 0F B6 30 48 FF C0 48 89 42 10 83 FE FF 75 03 40 8A F7 40 88 74 24 68 40 0F B6 EE 4D 85 F6 74 26 49 8B 06 83 78 08 01 7E 11 4D 8B C6 BA 08 00 00 00 8B CD E8 ?? ?? ?? ?? EB 1B 48 8B 00 48 63 CD 0F B7 04 48 EB 0C E8 ?? ?? ?? ?? 48 8B C8 0F B7 04 68 83 E0 08 85 C0 74 2D 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 A2 48 8B 0B 48 8B 41 10 48 3B 41 08 74 95 0F B6 30 48 FF C0 48 89 41 10 EB 84 40 80 FE 2D 4D 8D 94 24 08 03 00 00 0F 94 C0 41 88 02 8D 46 D5 A8 FD 75 38 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 0B 48 8B 41 10 48 3B 41 08 74 0F 0F B6 30 48 FF C0 48 89 41 10 83 FE FF 75 03 40 8A F7 40 88 74 24 68 8D 46 B7 41 B1 DF 41 84 C1 0F 84 8D 06 00 00 8D 46 B2 41 84 C1 0F 84 6F 06 00 00 44 8A EF 40 80 FE 30 0F 85 A8 00 00 00 4C 8B 43 10 49 8D 40 01 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 5F 48 8B 13 48 8B 42 10 48 3B 42 08 74 52 0F B6 08 48 FF C0 48 89 42 10 83 F9 FF 74 43 8D 41 A8 41 84 C1 75 3E 48 FF 43 10 41 B5 01 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 0B 48 8B 41 10 48 3B 41 08 74 0F 0F B6 30 48 FF C0 48 89 41 10 83 FE FF 75 03 40 8A F7 4D 8B F8 EB 31 40 8A CF 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1A FE C1 80 F9 01 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 49 83 C4 08 44 8B DF 49 8B EC 44 8A CF 40 80 FE 30 75 40 41 B1 01 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 26 48 8B 13 48 8B 42 10 48 3B 42 08 74 19 0F B6 08 48 FF C0 48 89 42 10 83 F9 FF 74 0A 40 8A F1 80 F9 30 75 05 EB C6 40 8A F7 41 8A C5 F6 D8 45 1B C0 41 83 E0 06 41 83 C0 09 8D 46 D0 3C 09 77 09 40 0F BE C6 83 E8 30 EB 23 8D 46 9F 3C 19 77 09 40 0F BE C6 83 E8 57 EB 13 8D 46 BF 3C 19 77 09 40 0F BE C6 83 E8 37 EB 03 83 C8 FF 41 3B C0 77 46 41 B1 01 49 3B EA 74 06 88 45 00 48 FF C5 48 FF 43 10 41 FF C3 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 0B 48 8B 41 10 48 3B 41 08 74 0F 0F B6 30 48 FF C0 48 89 41 10 83 FE FF 75 87 40 8A F7 EB 82 49 8B 06 41 BE 01 00 00 00 44 89 5C 24 68 48 8B 88 F8 00 00 00 48 8B 01 40 3A 30 0F 85 00 01 00 00 4C 01 73 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 13 48 8B 42 10 48 3B 42 08 74 0F 0F B6 08 48 FF C0 48 89 42 10 83 F9 FF 75 03 40 8A CF 40 8A F1 49 3B EC 75 4D 80 F9 30 75 48 45 8A CE 4C 01 73 10 45 2B DE 48 8B 43 10 44 89 5C 24 68 48 39 7B 08 74 06 48 3B 43 08 77 26 48 8B 13 48 8B 42 10 48 3B 42 08 74 19 0F B6 08 48 FF C0 48 89 42 10 83 F9 FF 74 0A 40 8A F1 80 F9 30 75 05 EB BE 40 8A F7 8D 46 D0 3C 09 77 09 40 0F BE C6 83 E8 30 EB 23 8D 46 9F 3C 19 77 09 40 0F BE C6 83 E8 57 EB 13 8D 46 BF 3C 19 77 09 40 0F BE C6 83 E8 37 EB 03 83 C8 FF 41 3B C0 77 40 45 8A CE 49 3B EA 74 06 88 45 00 49 03 EE 4C 01 73 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 A3 48 8B 0B 48 8B 41 10 48 3B 41 08 74 96 0F B6 30 48 FF C0 48 89 41 10 83 FE FF 75 8A EB 85 45 84 C9 75 51 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1B 41 02 F6 41 3A F6 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 4C 3B 7B 10 74 0C 48 8B 43 18 40 88 38 E9 E5 FB FF FF 41 F6 DD 1B C0 83 E0 FB 83 C0 07 E9 84 03 00 00 49 83 CF FF 4C 01 7B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1B 41 02 F6 41 3A F6 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 4C 8B 5B 10 49 8D 43 01 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 13 48 8B 42 10 48 3B 42 08 74 0F 0F B6 08 48 FF C0 48 89 42 10 41 3B CF 75 03 40 8A CF 40 8A C7 80 F9 45 74 14 80 F9 50 74 0A 80 F9 65 74 0A 80 F9 70 75 0B 41 8A C5 EB 06 45 84 ED 0F 94 C0 44 8B C7 BE 50 14 00 00 84 C0 0F 84 20 02 00 00 4C 01 73 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 0B 48 8B 41 10 48 3B 41 08 74 0F 0F B6 10 48 FF C0 48 89 41 10 41 3B D7 75 03 40 8A D7 80 FA 2D 8A CA 41 0F 94 C2 80 EA 2B F6 C2 FD 75 33 4C 01 73 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 13 48 8B 42 10 48 3B 42 08 74 0F 0F B6 08 48 FF C0 48 89 42 10 41 3B CF 75 03 40 8A CF 44 8A CF 80 F9 30 75 3F 45 8A CE 4C 01 73 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 25 48 8B 0B 48 8B 41 10 48 3B 41 08 74 18 0F B6 10 48 FF C0 48 89 41 10 41 3B D7 74 09 8A CA 80 FA 30 75 05 EB C7 40 8A CF 8D 41 D0 3C 09 77 08 0F BE D1 83 EA 30 EB 21 8D 41 9F 3C 19 77 08 0F BE D1 83 EA 57 EB 12 8D 41 BF 3C 19 77 08 0F BE D1 83 EA 37 EB 03 83 CA FF 83 FA 0A 73 48 43 8D 04 80 45 8A CE 44 8D 04 42 44 3B C6 7F 32 4C 01 73 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 A4 48 8B 13 48 8B 42 10 48 3B 42 08 74 97 0F B6 08 48 FF C0 48 89 42 10 41 3B CF 75 8B EB 86 41 B8 51 14 00 00 8D 41 D0 3C 09 77 08 0F BE C1 83 E8 30 EB 21 8D 41 9F 3C 19 77 08 0F BE C1 83 E8 57 EB 12 8D 41 BF 3C 19 77 08 0F BE C1 83 E8 37 EB 03 83 C8 FF 83 F8 0A 73 35 4C 01 73 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 13 48 8B 42 10 48 3B 42 08 74 0F 0F B6 08 48 FF C0 48 89 42 10 41 3B CF 75 9B 40 8A CF EB 96 45 84 D2 74 03 41 F7 D8 45 84 C9 75 6E 4C 01 7B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1B 41 02 CE 41 3A CE 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 48 8B 43 10 4C 3B D8 0F 85 5A FD FF FF 48 FF C0 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 13 48 8B 42 10 48 3B 42 08 74 0F 0F B6 08 48 FF C0 48 89 42 10 41 3B CF 75 03 40 8A CF 4C 01 7B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1B 41 02 CE 41 3A CE 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 49 3B EC 74 6B 48 8D 45 FF 40 38 38 75 08 48 8B E8 49 3B C4 75 EF 49 3B EC 74 55 44 3B C6 7E 07 B8 09 00 00 00 EB 72 BA B0 EB FF FF 44 3B C2 7D 07 B8 08 00 00 00 EB 61 41 8A C5 F6 D8 1B C9 83 E1 03 41 03 CE 0F AF 4C 24 68 44 03 C1 44 3B C6 7F CE 44 3B C2 7C DA 48 8B 44 24 70 41 2B EC 45 84 ED 40 0F 95 C7 44 89 00 89 68 04 8B C7 EB 29 B8 02 00 00 00 EB 22 4D 8B C7 48 8D 4C 24 68 48 8B D3 E8 ?? ?? ?? ?? EB 10 4D 8B C7 48 8D 4C 24 68 48 8B D3 E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_56_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z"
		size = 4528
		refs = "0031 _errno 003c _invalid_parameter_noinfo 00a4 iswctype 1186 ??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 119b ??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 4C 24 08 53 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 58 48 8B FA 33 F6 48 8B 12 4D 8B F8 48 85 D2 74 06 48 39 77 18 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 07 00 00 00 E9 55 11 00 00 41 BC FF FF 00 00 48 8B 6F 10 48 89 6C 24 28 48 8D 45 01 48 89 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 DE EB 1D 48 8B 42 10 48 3B 42 08 74 11 0F B7 18 48 83 C0 02 48 89 42 10 66 41 3B DC 75 02 8B DE 41 BD 08 00 00 00 66 89 9C 24 A8 00 00 00 41 8B D5 0F B7 CB E8 ?? ?? ?? ?? 45 8D 5D F9 85 C0 74 5F 45 8B FB 4C 01 7F 10 48 8B 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 CE EB 20 48 8B 17 48 8B 42 10 48 3B 42 08 74 11 0F B7 08 48 83 C0 02 48 89 42 10 66 41 3B CC 75 02 8B CE 41 8B D5 66 89 8C 24 A8 00 00 00 0F B7 D9 E8 ?? ?? ?? ?? 85 C0 75 B0 4C 8B BC 24 B0 00 00 00 44 8D 58 01 66 83 FB 2D 4D 8D 97 08 03 00 00 B9 FD FF 00 00 0F 94 C0 41 88 02 8D 43 D5 66 85 C1 75 41 4C 01 5F 10 48 8B 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 DE EB 20 48 8B 0F 48 8B 41 10 48 3B 41 08 74 11 0F B7 18 48 83 C0 02 48 89 41 10 66 41 3B DC 75 02 8B DE 66 89 9C 24 A8 00 00 00 8D 43 B7 41 B9 DF FF 00 00 66 41 85 C1 0F 84 0B 10 00 00 8D 43 B2 66 41 85 C1 0F 84 E9 0F 00 00 BA 30 00 00 00 40 88 B4 24 A8 00 00 00 44 8A EE 66 3B DA 0F 85 C7 00 00 00 4C 8B 47 10 49 8D 40 01 48 89 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 CE EB 74 48 8B 17 48 8B 42 10 48 3B 42 08 74 65 0F B7 08 48 83 C0 02 48 89 42 10 66 41 3B CC 74 54 8D 41 A8 66 41 85 C1 75 4D 4C 01 5F 10 45 8A EB 48 8B 47 10 44 88 9C 24 A8 00 00 00 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 DE EB 20 48 8B 0F 48 8B 41 10 48 3B 41 08 74 11 0F B7 18 48 83 C0 02 48 89 41 10 66 41 3B DC 75 02 8B DE 4C 89 44 24 28 EB 38 8B CE 48 FF 4F 10 48 8B 47 10 48 39 77 08 74 06 48 3B 47 08 77 22 66 41 2B CB B8 FD FF 00 00 66 3B C8 77 14 48 8B 0F 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 4D 8D 67 08 B9 30 00 00 00 66 3B D9 4C 89 64 24 40 B9 01 00 00 00 4C 89 64 24 38 4D 8B FC 44 8B DE 44 8A C6 75 55 44 8A C1 41 B9 FF FF 00 00 48 01 4F 10 48 8B 47 10 48 39 77 08 74 06 48 3B 47 08 77 35 48 8B 0F 48 8B 41 10 48 3B 41 08 74 23 0F B7 10 48 83 C0 02 48 89 41 10 66 41 3B D1 74 12 B8 30 00 00 00 0F B7 DA 8D 48 D1 66 3B D0 75 0A EB BC B9 01 00 00 00 0F B7 DE 41 8A C5 C7 84 24 B8 00 00 00 6A 06 00 00 F6 D8 C7 44 24 30 FA 06 00 00 BD 60 06 00 00 41 BE 10 FF 00 00 45 1B C9 41 BD F0 06 00 00 41 83 E1 06 BA 30 00 00 00 41 83 C1 09 41 BC FF FF 00 00 B8 66 09 00 00 66 3B DA 0F 82 56 02 00 00 66 83 FB 3A 73 0A 0F B7 C3 2B C2 E9 41 02 00 00 66 41 3B DE 0F 83 22 02 00 00 66 3B DD 0F 82 33 02 00 00 66 3B 9C 24 B8 00 00 00 73 0A 0F B7 C3 2B C5 E9 1A 02 00 00 66 41 3B DD 0F 82 15 02 00 00 66 3B 5C 24 30 73 0B 0F B7 C3 41 2B C5 E9 FE 01 00 00 66 3B D8 0F 82 FA 01 00 00 B8 70 09 00 00 66 3B D8 73 0D 0F B7 C3 2D 66 09 00 00 E9 DE 01 00 00 B8 E6 09 00 00 66 3B D8 0F 82 D5 01 00 00 B8 F0 09 00 00 66 3B D8 73 0D 0F B7 C3 2D E6 09 00 00 E9 B9 01 00 00 B8 66 0A 00 00 66 3B D8 0F 82 B0 01 00 00 B8 70 0A 00 00 66 3B D8 73 0D 0F B7 C3 2D 66 0A 00 00 E9 94 01 00 00 B8 E6 0A 00 00 66 3B D8 0F 82 8B 01 00 00 B8 F0 0A 00 00 66 3B D8 73 0D 0F B7 C3 2D E6 0A 00 00 E9 6F 01 00 00 B8 66 0B 00 00 66 3B D8 0F 82 66 01 00 00 B8 70 0B 00 00 66 3B D8 73 0D 0F B7 C3 2D 66 0B 00 00 E9 4A 01 00 00 B8 66 0C 00 00 66 3B D8 0F 82 41 01 00 00 B8 70 0C 00 00 66 3B D8 73 0D 0F B7 C3 2D 66 0C 00 00 E9 25 01 00 00 B8 E6 0C 00 00 66 3B D8 0F 82 1C 01 00 00 B8 F0 0C 00 00 66 3B D8 73 0D 0F B7 C3 2D E6 0C 00 00 E9 00 01 00 00 B8 66 0D 00 00 66 3B D8 0F 82 F7 00 00 00 B8 70 0D 00 00 66 3B D8 73 0D 0F B7 C3 2D 66 0D 00 00 E9 DB 00 00 00 B8 50 0E 00 00 66 3B D8 0F 82 D2 00 00 00 B8 5A 0E 00 00 66 3B D8 73 0D 0F B7 C3 2D 50 0E 00 00 E9 B6 00 00 00 B8 D0 0E 00 00 66 3B D8 0F 82 AD 00 00 00 B8 DA 0E 00 00 66 3B D8 73 0D 0F B7 C3 2D D0 0E 00 00 E9 91 00 00 00 B8 20 0F 00 00 66 3B D8 0F 82 88 00 00 00 B8 2A 0F 00 00 66 3B D8 73 0A 0F B7 C3 2D 20 0F 00 00 EB 6F B8 40 10 00 00 66 3B D8 72 6A B8 4A 10 00 00 66 3B D8 73 0A 0F B7 C3 2D 40 10 00 00 EB 51 B8 E0 17 00 00 66 3B D8 72 4C B8 EA 17 00 00 66 3B D8 73 0A 0F B7 C3 2D E0 17 00 00 EB 33 B8 10 18 00 00 66 3B D8 72 2E B8 1A 18 00 00 66 3B D8 73 24 0F B7 C3 2D 10 18 00 00 EB 15 B8 1A FF 00 00 66 3B D8 73 08 0F B7 C3 41 2B C6 EB 03 83 C8 FF 83 F8 FF 75 29 8D 43 BF 66 83 F8 19 76 0E 8D 43 9F 66 83 F8 19 76 05 83 C8 FF EB 12 8D 43 9F 66 83 F8 19 0F B7 C3 77 03 83 E8 20 83 C0 C9 41 3B C1 77 57 44 8A C1 4D 3B FA 74 06 41 88 07 4C 03 F9 48 01 4F 10 44 03 D9 48 8B 47 10 48 39 77 08 74 0E 48 3B 47 08 76 08 0F B7 DE E9 41 FD FF FF 48 8B 0F 48 8B 41 10 48 3B 41 08 74 11 0F B7 18 48 83 C0 02 48 89 41 10 66 41 3B DC 75 02 8B DE B9 01 00 00 00 E9 17 FD FF FF 4C 8B B4 24 A0 00 00 00 48 8B 6C 24 28 4C 8B 64 24 40 44 8A AC 24 A8 00 00 00 49 8B 06 41 BE 01 00 00 00 44 89 5C 24 30 4C 89 7C 24 38 48 8B 88 F8 00 00 00 48 8B 01 0F BE 08 0F B7 C3 3B C1 0F 85 02 03 00 00 4C 01 77 10 48 8B 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 CE EB 29 48 8B 17 48 8B 42 10 48 3B 42 08 74 15 0F B7 08 48 83 C0 02 48 89 42 10 B8 FF FF 00 00 66 3B C8 75 02 8B CE BA 30 00 00 00 0F B7 D9 4D 3B FC 75 58 66 3B CA 75 53 45 8A C6 4C 01 77 10 45 2B DE 48 8B 47 10 44 89 5C 24 30 48 39 77 08 74 06 48 3B 47 08 77 31 48 8B 0F 48 8B 41 10 48 3B 41 08 74 24 0F B7 10 48 83 C0 02 48 89 41 10 B8 FF FF 00 00 66 3B D0 74 0F B8 30 00 00 00 0F B7 DA 66 3B D0 75 0A EB B3 0F B7 DE B8 30 00 00 00 BD 10 FF 00 00 41 BC FF FF 00 00 41 BD 60 06 00 00 66 3B D8 0F 82 AB 01 00 00 66 83 FB 3A 73 0F B9 30 00 00 00 0F B7 C3 2B C1 E9 91 01 00 00 66 3B DD 0F 83 74 01 00 00 66 41 3B DD 0F 82 83 01 00 00 B8 6A 06 00 00 66 3B D8 73 0B 0F B7 C3 41 2B C5 E9 69 01 00 00 B9 F0 06 00 00 66 3B D9 0F 82 60 01 00 00 8D 41 0A 66 3B D8 72 B8 B9 66 09 00 00 66 3B D9 0F 82 4A 01 00 00 8D 41 0A 66 3B D8 72 A2 8D 48 76 66 3B D9 0F 82 36 01 00 00 8D 41 0A 66 3B D8 72 8E 8D 48 76 66 3B D9 0F 82 22 01 00 00 8D 41 0A 66 3B D8 0F 82 76 FF FF FF 8D 48 76 66 3B D9 0F 82 0A 01 00 00 8D 41 0A 66 3B D8 0F 82 5E FF FF FF 8D 48 76 66 3B D9 0F 82 F2 00 00 00 8D 41 0A 66 3B D8 0F 82 46 FF FF FF B9 66 0C 00 00 66 3B D9 0F 82 D8 00 00 00 8D 41 0A 66 3B D8 0F 82 2C FF FF FF 8D 48 76 66 3B D9 0F 82 C0 00 00 00 8D 41 0A 66 3B D8 0F 82 14 FF FF FF 8D 48 76 66 3B D9 0F 82 A8 00 00 00 8D 41 0A 66 3B D8 0F 82 FC FE FF FF B9 50 0E 00 00 66 3B D9 0F 82 8E 00 00 00 8D 41 0A 66 3B D8 0F 82 E2 FE FF FF 8D 48 76 66 3B D9 72 7A 8D 41 0A 66 3B D8 0F 82 CE FE FF FF 8D 48 46 66 3B D9 72 66 8D 41 0A 66 3B D8 0F 82 BA FE FF FF B9 40 10 00 00 66 3B D9 72 50 8D 41 0A 66 3B D8 0F 82 A4 FE FF FF B9 E0 17 00 00 66 3B D9 72 3A 8D 41 0A 66 3B D8 0F 82 8E FE FF FF 8D 48 26 66 3B D9 72 26 8D 41 0A 66 3B D8 73 1E E9 79 FE FF FF B8 1A FF 00 00 66 3B D8 73 07 0F B7 C3 2B C5 EB 03 83 C8 FF 83 F8 FF 75 29 8D 43 BF 66 83 F8 19 76 0E 8D 43 9F 66 83 F8 19 76 05 83 C8 FF EB 12 8D 43 9F 66 83 F8 19 0F B7 C3 77 03 83 E8 20 83 C0 C9 41 3B C1 77 51 45 8A C6 4D 3B FA 74 06 41 88 07 4D 03 FE 4C 01 77 10 48 8B 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 DE EB 20 48 8B 0F 48 8B 41 10 48 3B 41 08 74 11 0F B7 18 48 83 C0 02 48 89 41 10 66 41 3B DC 75 02 8B DE B8 30 00 00 00 E9 CD FD FF FF 48 8B 6C 24 28 4C 8B 64 24 40 44 8A AC 24 A8 00 00 00 4C 89 7C 24 38 48 FF 4F 10 48 8B 47 10 45 84 C0 75 50 48 39 77 08 74 06 48 3B 47 08 77 22 66 41 2B DE B8 FD FF 00 00 66 3B D8 77 14 48 8B 0F 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 48 3B 6F 10 74 0C 48 8B 47 18 40 88 30 E9 9B F6 FF FF 41 F6 DD 1B C0 83 E0 FB 83 C0 07 E9 EA 07 00 00 48 39 77 08 74 06 48 3B 47 08 77 26 66 41 2B DE 41 B9 FD FF 00 00 66 41 3B D9 77 1C 48 8B 0F 48 8B 41 10 48 3B 01 74 10 48 83 C0 FE 48 89 41 10 EB 06 41 B9 FD FF 00 00 4C 8B 5F 10 4C 89 5C 24 48 49 8D 43 01 48 89 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 CE EB 24 48 8B 17 48 8B 42 10 48 3B 42 08 74 15 0F B7 08 48 83 C0 02 48 89 42 10 B8 FF FF 00 00 66 3B C8 75 02 8B CE 0F B7 C1 40 8A D6 83 F8 45 74 14 83 F8 50 74 0A 83 F8 65 74 0A 83 F8 70 75 0B 41 8A D5 EB 06 45 84 ED 0F 94 C2 89 74 24 28 44 8B C6 BB 50 14 00 00 84 D2 0F 84 5A 06 00 00 4C 01 77 10 48 8B 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 D6 EB 24 48 8B 0F 48 8B 41 10 48 3B 41 08 74 15 0F B7 10 48 83 C0 02 48 89 41 10 B8 FF FF 00 00 66 3B D0 75 02 8B D6 66 83 FA 2D 0F B7 CA 41 0F 94 C2 66 83 EA 2B 44 88 54 24 20 66 41 85 D1 75 3D 4C 01 77 10 48 8B 47 10 48 39 77 08 74 0B 48 3B 47 08 76 05 0F B7 CE EB 24 48 8B 17 48 8B 42 10 48 3B 42 08 74 15 0F B7 08 48 83 C0 02 48 89 42 10 B8 FF FF 00 00 66 3B C8 75 02 8B CE BD 30 00 00 00 40 88 B4 24 B8 00 00 00 66 3B CD 75 4E 44 88 B4 24 B8 00 00 00 4C 01 77 10 48 8B 47 10 48 39 77 08 74 06 48 3B 47 08 77 2C 48 8B 0F 48 8B 41 10 48 3B 41 08 74 1F 0F B7 10 48 83 C0 02 48 89 41 10 B8 FF FF 00 00 66 3B D0 74 0A 0F B7 CA 66 3B D5 75 05 EB C0 0F B7 CE 66 3B CD 0F 82 A1 01 00 00 66 83 F9 3A 73 0A 0F B7 D1 2B D5 E9 8C 01 00 00 B8 10 FF 00 00 66 3B C8 0F 83 6D 01 00 00 B8 60 06 00 00 66 3B C8 0F 82 75 01 00 00 8D 50 0A 66 3B CA 73 0A 0F B7 D1 2B D0 E9 5E 01 00 00 B8 F0 06 00 00 66 3B C8 0F 82 55 01 00 00 8D 50 0A 66 3B CA 72 E0 B8 66 09 00 00 66 3B C8 0F 82 3F 01 00 00 8D 50 0A 66 3B CA 72 CA 8D 42 76 66 3B C8 0F 82 2B 01 00 00 8D 50 0A 66 3B CA 72 B6 8D 42 76 66 3B C8 0F 82 17 01 00 00 8D 50 0A 66 3B CA 72 A2 8D 42 76 66 3B C8 0F 82 03 01 00 00 8D 50 0A 66 3B CA 72 8E 8D 42 76 66 3B C8 0F 82 EF 00 00 00 8D 50 0A 66 3B CA 0F 82 76 FF FF FF B8 66 0C 00 00 66 3B C8 0F 82 D5 00 00 00 8D 50 0A 66 3B CA 0F 82 5C FF FF FF 8D 42 76 66 3B C8 0F 82 BD 00 00 00 8D 50 0A 66 3B CA 0F 82 44 FF FF FF 8D 42 76 66 3B C8 0F 82 A5 00 00 00 8D 50 0A 66 3B CA 0F 82 2C FF FF FF B8 50 0E 00 00 66 3B C8 0F 82 8B 00 00 00 8D 50 0A 66 3B CA 0F 82 12 FF FF FF 8D 42 76 66 3B C8 72 77 8D 50 0A 66 3B CA 0F 82 FE FE FF FF 8D 42 46 66 3B C8 72 63 8D 50 0A 66 3B CA 0F 82 EA FE FF FF B8 40 10 00 00 66 3B C8 72 4D 8D 50 0A 66 3B CA 0F 82 D4 FE FF FF B8 E0 17 00 00 66 3B C8 72 37 8D 50 0A 66 3B CA 0F 82 BE FE FF FF 8D 42 26 66 3B C8 72 23 8D 50 0A 66 3B CA 73 1B E9 A9 FE FF FF BA 1A FF 00 00 66 3B CA 0F 82 9B FE FF FF 83 CA FF 83 FA FF 75 29 8D 41 BF 66 83 F8 19 76 0E 8D 41 9F 66 83 F8 19 76 05 83 CA FF EB 12 8D 41 9F 0F B7 D1 66 83 F8 19 77 03 83 EA 20 83 C2 C9 83 FA 0A 73 6A 43 8D 04 80 44 88 B4 24 B8 00 00 00 44 8D 04 42 44 89 44 24 28 44 3B C3 7F 45 4C 01 77 10 48 8B 47 10 48 39 77 08 74 0A 48 3B 47 08 0F 87 F3 FD FF FF 48 8B 17 48 8B 42 10 48 3B 42 08 74 19 0F B7 08 48 83 C0 02 48 89 42 10 B8 FF FF 00 00 66 3B C8 0F 85 D0 FD FF FF 8B CE E9 C9 FD FF FF 41 B8 51 14 00 00 44 89 44 24 28 BB FF FF 00 00 41 BC 10 FF 00 00 41 BD 60 06 00 00 41 BB F0 06 00 00 41 BA 66 09 00 00 41 B9 E6 09 00 00 41 B8 66 0A 00 00 41 BF E6 0A 00 00 66 3B CD 0F 82 C3 01 00 00 66 83 F9 3A 73 0A 0F B7 C1 2B C5 E9 AE 01 00 00 66 41 3B CC 0F 83 8F 01 00 00 66 41 3B CD 0F 82 9F 01 00 00 B8 6A 06 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C5 E9 85 01 00 00 66 41 3B CB 0F 82 80 01 00 00 B8 FA 06 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C3 E9 66 01 00 00 66 41 3B CA 0F 82 61 01 00 00 B8 70 09 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C2 E9 47 01 00 00 66 41 3B C9 0F 82 42 01 00 00 B8 F0 09 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C1 E9 28 01 00 00 66 41 3B C8 0F 82 23 01 00 00 B8 70 0A 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C0 E9 09 01 00 00 66 41 3B CF 0F 82 04 01 00 00 B8 F0 0A 00 00 66 3B C8 73 0B 0F B7 C1 41 2B C7 E9 EA 00 00 00 BA 66 0B 00 00 66 3B CA 0F 82 E1 00 00 00 8D 42 0A 66 3B C8 73 0A 0F B7 C1 2B C2 E9 CA 00 00 00 BA 66 0C 00 00 66 3B CA 0F 82 C1 00 00 00 8D 42 0A 66 3B C8 72 E0 8D 50 76 66 3B CA 0F 82 AD 00 00 00 8D 42 0A 66 3B C8 72 CC 8D 50 76 66 3B CA 0F 82 99 00 00 00 8D 42 0A 66 3B C8 72 B8 BA 50 0E 00 00 66 3B CA 0F 82 83 00 00 00 8D 42 0A 66 3B C8 72 A2 8D 50 76 66 3B CA 72 73 8D 42 0A 66 3B C8 72 92 8D 50 46 66 3B CA 72 63 8D 42 0A 66 3B C8 72 82 BA 40 10 00 00 66 3B CA 72 51 8D 42 0A 66 3B C8 0F 82 6C FF FF FF BA E0 17 00 00 66 3B CA 72 3B 8D 42 0A 66 3B C8 0F 82 56 FF FF FF 8D 50 26 66 3B CA 72 27 8D 42 0A 66 3B C8 73 1F E9 41 FF FF FF B8 1A FF 00 00 66 3B C8 73 08 0F B7 C1 41 2B C4 EB 03 83 C8 FF 83 F8 FF 75 29 8D 41 BF 66 83 F8 19 76 0E 8D 41 9F 66 83 F8 19 76 05 83 C8 FF EB 12 8D 41 9F 66 83 F8 19 0F B7 C1 77 03 83 E8 20 83 C0 C9 83 F8 0A 73 44 4C 01 77 10 48 8B 47 10 48 39 77 08 74 0E 48 3B 47 08 76 08 0F B7 CE E9 EA FD FF FF 48 8B 17 48 8B 42 10 48 3B 42 08 74 14 0F B7 08 48 83 C0 02 48 89 42 10 66 3B CB 0F }
	condition:
		$1
}

rule file_158_57_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 595
		refs = "001d __ImageBase 0033 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 003d ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0062 _getc_nolock 00be _ungetc_nolock 014f ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0159 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 33 FF 4C 8D 3D ?? ?? ?? ?? 8B F7 49 8B E8 48 8B DA 4C 8B F1 41 8A 06 42 3A 84 3E ?? ?? ?? ?? 74 0E 42 3A 84 3E ?? ?? ?? ?? 0F 85 A9 00 00 00 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 26 4C 8B 3B 49 8B 0F E8 ?? ?? ?? ?? 8B C8 83 F8 FF 74 0D 49 FF 47 08 4C 8D 3D ?? ?? ?? ?? EB 0A 4C 8D 3D ?? ?? ?? ?? 40 8A CF 48 FF C6 41 88 0E 48 83 FE 03 75 9C 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 48 8B 6B 10 48 8D 45 01 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 65 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 55 48 FF 46 08 EB 52 41 8A 0E 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 41 88 3E 48 3B 6B 10 74 07 48 8B 43 18 40 88 38 B8 07 00 00 00 E9 A4 00 00 00 40 8A C7 41 88 06 48 8B F7 41 8A 06 42 3A 84 3E ?? ?? ?? ?? 74 0E 42 3A 84 3E ?? ?? ?? ?? 0F 85 99 00 00 00 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 26 4C 8B 3B 49 8B 0F E8 ?? ?? ?? ?? 8B C8 83 F8 FF 74 0D 49 FF 47 08 4C 8D 3D ?? ?? ?? ?? EB 0A 4C 8D 3D ?? ?? ?? ?? 40 8A CF 48 FF C6 41 88 0E 48 83 FE 05 75 9C 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? B8 03 00 00 00 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 41 8A 0E 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 41 88 3E 48 3B 6B 10 74 09 48 8B 43 18 40 88 38 EB 03 40 B7 01 40 F6 DF 1B C0 83 E0 FC 83 C0 07 EB 90 }
	condition:
		$1
}

rule file_158_58_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 534
		refs = "0010 __ImageBase 0024 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 002e ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 00e9 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 00f3 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 45 33 C9 48 8D 35 ?? ?? ?? ?? 45 8B D1 49 8B D8 4C 8B D9 41 8A 03 41 3A 84 32 ?? ?? ?? ?? 74 0E 41 3A 84 32 ?? ?? ?? ?? 0F 85 42 01 00 00 48 FF 42 10 48 8B 42 10 4C 39 4A 08 74 06 48 3B 42 08 77 1C 4C 8B 02 49 8B 40 10 49 3B 40 08 74 0F 0F B6 08 48 FF C0 49 89 40 10 83 F9 FF 75 03 41 8A C9 49 FF C2 41 88 0B 49 83 FA 03 75 A6 48 FF 4A 10 48 8B 42 10 4C 39 4A 08 74 06 48 3B 42 08 77 1A FE C1 80 F9 01 76 13 48 8B 0A 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 48 8B 5A 10 48 8D 43 01 48 89 42 10 4C 39 4A 08 74 06 48 3B 42 08 77 1C 4C 8B 02 49 8B 40 10 49 3B 40 08 74 0F 0F B6 08 48 FF C0 49 89 40 10 83 F9 FF 75 03 41 8A C9 41 88 0B 4D 8B C1 41 8A 03 41 3A 84 30 ?? ?? ?? ?? 74 0E 41 3A 84 30 ?? ?? ?? ?? 0F 85 C4 00 00 00 48 FF 42 10 48 8B 42 10 4C 39 4A 08 74 06 48 3B 42 08 77 1C 4C 8B 12 49 8B 42 10 49 3B 42 08 74 0F 0F B6 08 48 FF C0 49 89 42 10 83 F9 FF 75 03 41 8A C9 49 FF C0 41 88 0B 49 83 F8 05 75 A6 48 FF 4A 10 48 8B 42 10 4C 39 4A 08 74 06 48 3B 42 08 77 1A FE C1 80 F9 01 76 13 4C 8B 02 49 8B 48 10 49 3B 08 74 07 48 FF C9 49 89 48 10 B8 03 00 00 00 48 8B 5C 24 08 48 8B 74 24 10 C3 41 8A 03 48 FF 4A 10 48 8B 4A 10 4C 39 4A 08 74 06 48 3B 4A 08 77 19 FE C0 3C 01 76 13 48 8B 0A 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 45 88 0B 48 3B 5A 10 74 07 48 8B 42 18 44 88 08 B8 07 00 00 00 EB AE 41 8A 03 48 FF 4A 10 48 8B 4A 10 4C 39 4A 08 74 06 48 3B 4A 08 77 19 FE C0 3C 01 76 13 48 8B 0A 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 45 88 0B 48 3B 5A 10 74 09 48 8B 42 18 44 88 08 EB 03 41 B1 01 41 F6 D9 1B C0 83 E0 FC 83 C0 07 E9 59 FF FF FF }
	condition:
		$1
}

rule file_158_59_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 654
		refs = "0039 __ImageBase 0041 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 004b ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0075 _getwc_nolock 00d5 _ungetwc_nolock 017d ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0188 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 33 FF 4D 8B E0 48 8B DA 4C 8B F1 8B F7 BD FF FF 00 00 44 8D 7F 01 41 0F B7 06 48 8D 0D ?? ?? ?? ?? 66 3B 84 0E ?? ?? ?? ?? 74 0E 66 3B 84 0E ?? ?? ?? ?? 0F 85 A1 00 00 00 4C 01 7B 10 48 8B 43 10 48 39 7B 08 74 0B 48 3B 43 08 76 05 0F B7 CF EB 29 4C 8B 3B 49 8B 0F E8 ?? ?? ?? ?? 0F B7 C8 66 3B C5 74 0E B8 01 00 00 00 49 01 47 08 44 8B F8 EB 08 8B CF 41 BF 01 00 00 00 48 83 C6 02 66 41 89 0E 48 83 FE 06 75 8D 48 FF 4B 10 BD FD FF 00 00 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1B 0F B7 C1 66 41 2B C7 66 3B C5 77 0F 48 8B 13 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 4C 8B 6B 10 49 8D 45 01 48 89 43 10 48 39 7B 08 74 5E 48 3B 43 08 76 58 0F B7 C7 EB 70 41 0F B7 0E 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 20 0F B7 C1 BD FD FF 00 00 66 41 2B C7 66 3B C5 77 0F 48 8B 13 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 66 41 89 3E 4C 3B 63 10 74 07 48 8B 43 18 40 88 38 B8 07 00 00 00 E9 D2 00 00 00 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 06 4C 01 7E 08 EB 02 8B C7 66 41 89 06 4C 8D 25 ?? ?? ?? ?? 48 8B F7 41 0F B7 06 66 42 3B 84 26 ?? ?? ?? ?? 74 0F 66 42 3B 84 26 ?? ?? ?? ?? 0F 85 A6 00 00 00 4C 01 7B 10 48 8B 43 10 48 39 7B 08 74 0B 48 3B 43 08 76 05 0F B7 CF EB 2E 4C 8B 3B 49 8B 0F E8 ?? ?? ?? ?? 0F B7 C8 B8 FF FF 00 00 66 3B C8 74 0E B8 01 00 00 00 49 01 47 08 44 8B F8 EB 08 8B CF 41 BF 01 00 00 00 48 83 C6 02 66 41 89 0E 48 83 FE 0A 75 8D 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1B 0F B7 C1 66 41 2B C7 66 3B C5 77 0F 48 8B 13 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? B8 03 00 00 00 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 41 0F B7 0E 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1B 0F B7 C1 66 41 2B C7 66 3B C5 77 0F 48 8B 13 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 66 41 89 3E 4C 3B 6B 10 74 09 48 8B 43 18 40 88 38 EB 03 41 8A FF 40 F6 DF 1B C0 83 E0 FC 83 C0 07 EB 8D }
	condition:
		$1
}

rule file_158_60_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 626
		refs = "001b __ImageBase 003b ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0046 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0171 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 017c ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 45 33 C9 48 8D 2D ?? ?? ?? ?? 49 8B F8 4C 8B D9 45 8B D1 41 BE FF FF 00 00 41 8D 71 01 41 0F B7 03 66 41 3B 84 2A ?? ?? ?? ?? 74 0F 66 41 3B 84 2A ?? ?? ?? ?? 0F 85 9C 00 00 00 48 01 72 10 48 8B 42 10 4C 39 4A 08 74 0C 48 3B 42 08 76 06 41 0F B7 C9 EB 21 4C 8B 02 49 8B 40 10 49 3B 40 08 74 11 0F B7 08 48 83 C0 02 49 89 40 10 66 41 3B CE 75 03 41 8B C9 49 83 C2 02 66 41 89 0B 49 83 FA 06 75 99 48 FF 4A 10 BB FD FF 00 00 48 8B 42 10 4C 39 4A 08 74 06 48 3B 42 08 77 1C 66 2B CE 66 3B CB 77 14 48 8B 0A 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 48 8B 7A 10 48 8D 47 01 48 89 42 10 4C 39 4A 08 74 60 48 3B 42 08 76 5A 41 0F B7 C9 EB 75 41 0F B7 03 48 FF 4A 10 48 8B 4A 10 4C 39 4A 08 74 06 48 3B 4A 08 77 21 66 2B C6 BB FD FF 00 00 66 3B C3 77 14 48 8B 0A 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 66 45 89 0B 48 3B 7A 10 74 07 48 8B 42 18 44 88 08 B8 07 00 00 00 E9 C4 00 00 00 4C 8B 02 49 8B 40 10 49 3B 40 08 74 11 0F B7 08 48 83 C0 02 49 89 40 10 66 41 3B CE 75 03 41 8B C9 66 41 89 0B 4D 8B C1 41 0F B7 03 66 41 3B 84 28 ?? ?? ?? ?? 74 0F 66 41 3B 84 28 ?? ?? ?? ?? 0F 85 95 00 00 00 48 01 72 10 48 8B 42 10 4C 39 4A 08 74 0C 48 3B 42 08 76 06 41 0F B7 C9 EB 21 4C 8B 12 49 8B 42 10 49 3B 42 08 74 11 0F B7 08 48 83 C0 02 49 89 42 10 66 41 3B CE 75 03 41 8B C9 49 83 C0 02 66 41 89 0B 49 83 F8 0A 75 99 48 FF 4A 10 48 8B 42 10 4C 39 4A 08 74 06 48 3B 42 08 77 1C 66 2B CE 66 3B CB 77 14 48 8B 0A 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 B8 03 00 00 00 48 8B 5C 24 10 48 8B 6C 24 18 48 8B 74 24 20 48 8B 7C 24 28 41 5E C3 41 0F B7 03 48 FF 4A 10 48 8B 4A 10 4C 39 4A 08 74 06 48 3B 4A 08 77 1C 66 2B C6 66 3B C3 77 14 48 8B 0A 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 66 45 89 0B 48 3B 7A 10 74 09 48 8B 42 18 44 88 08 EB 03 44 8A CE 41 F6 D9 1B C0 83 E0 FC 83 C0 07 EB 92 }
	condition:
		$1
}

rule file_158_61_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 629
		refs = "0027 __ImageBase 003d ?uppercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0047 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 006d _getc_nolock 00ba _ungetc_nolock 00f7 ??R<lambda_156378f40168adef48d7ddfcff3a1264>@@QEBA_NXZ 015c ??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z 01aa ??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 4C 8B DC 49 89 5B 08 49 89 73 10 4D 89 43 18 57 41 55 41 56 48 83 EC 40 49 8D 43 18 49 89 53 C8 49 89 43 D8 4C 8D 2D ?? ?? ?? ?? 48 8B DA 49 89 4B D0 48 8B F9 33 F6 8A 07 42 3A 84 2E ?? ?? ?? ?? 74 0E 42 3A 84 2E ?? ?? ?? ?? 0F 85 A0 00 00 00 48 FF 43 10 48 83 7B 08 00 48 8B 43 10 74 06 48 3B 43 08 77 18 4C 8B 33 49 8B 0E E8 ?? ?? ?? ?? 8B C8 83 F8 FF 74 06 49 FF 46 08 EB 02 32 C9 48 FF C6 88 0F 48 83 FE 03 75 AC 48 FF 4B 10 48 83 7B 08 00 48 8B 43 10 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 48 8B 43 10 48 89 44 24 70 48 FF C0 48 83 7B 08 00 48 89 43 10 74 06 48 3B 43 08 77 2A 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 1A 48 FF 46 08 EB 16 48 8D 4C 24 20 E8 ?? ?? ?? ?? B8 07 00 00 00 E9 5C 01 00 00 32 C0 88 07 3C 28 74 19 48 8D 4C 24 20 E8 ?? ?? ?? ?? F6 D8 1B C0 83 E0 FD 83 C0 07 E9 3B 01 00 00 48 FF 43 10 48 83 7B 08 00 48 8B 43 10 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 02 32 C0 48 8B D3 88 07 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 3F 8A 0F 48 FF 4B 10 48 83 7B 08 00 48 8B 43 10 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? B8 05 00 00 00 E9 BE 00 00 00 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 3C 8A 0F 48 FF 4B 10 48 83 7B 08 00 48 8B 43 10 74 06 48 3B 43 08 77 1E 8D 41 01 3C 01 76 17 48 8B 13 0F BE C9 83 F9 FF 74 0C 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? B8 06 00 00 00 EB 73 41 B6 29 44 38 37 74 66 80 3F 00 74 58 0F BE 0F 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 EE FE FF FF 48 FF 43 10 48 83 7B 08 00 48 8B 43 10 74 06 48 3B 43 08 77 16 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 02 32 C0 88 07 41 3A C6 75 A3 44 38 37 0F 85 B1 FE FF FF B8 04 00 00 00 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 40 41 5E 41 5D 5F C3 }
	condition:
		$1
}

rule file_158_62_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 761
		refs = "0019 __ImageBase 002e ?uppercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0038 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 01c8 ??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z 0210 ??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 FF 4C 8D 15 ?? ?? ?? ?? 48 8B DA 4D 8B C8 8B D7 48 8B F1 8A 06 42 3A 84 12 ?? ?? ?? ?? 74 0E 42 3A 84 12 ?? ?? ?? ?? 0F 85 EE 00 00 00 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 4C 8B 03 49 8B 40 10 49 3B 40 08 74 0F 0F B6 08 48 FF C0 49 89 40 10 83 F9 FF 75 03 40 8A CF 48 FF C2 88 0E 48 83 FA 03 75 A8 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1A FE C1 80 F9 01 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 48 8B 6B 10 48 8D 45 01 48 89 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 13 48 8B 42 10 48 3B 42 08 74 0F 0F B6 08 48 FF C0 48 89 42 10 83 F9 FF 75 03 40 8A CF 88 0E 80 F9 28 0F 84 9C 00 00 00 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1A FE C1 80 F9 01 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 40 88 3E 48 3B 6B 10 74 52 48 8B 43 18 40 88 38 EB 4C 8A 06 48 FF 4B 10 48 8B 4B 10 48 39 7B 08 74 06 48 3B 4B 08 77 19 FE C0 3C 01 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 40 88 3E 4C 3B 4B 10 74 07 48 8B 43 18 40 88 38 B8 07 00 00 00 E9 48 01 00 00 40 B7 01 40 F6 DF 1B C0 83 E0 FD 83 C0 07 E9 35 01 00 00 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 13 48 8B 42 10 48 3B 42 08 74 0F 0F B6 08 48 FF C0 48 89 42 10 83 F9 FF 75 03 40 8A CF 88 0E 48 8B D3 48 8B CE E8 ?? ?? ?? ?? 84 C0 74 39 8A 06 48 FF 4B 10 48 8B 4B 10 48 39 7B 08 74 06 48 3B 4B 08 77 19 FE C0 3C 01 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 B8 05 00 00 00 E9 B8 00 00 00 48 8B D3 48 8B CE E8 ?? ?? ?? ?? 84 C0 74 36 8A 06 48 FF 4B 10 48 8B 4B 10 48 39 7B 08 74 06 48 3B 4B 08 77 19 FE C0 3C 01 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 B8 06 00 00 00 EB 73 41 B0 29 44 38 06 74 66 40 38 3E 74 5A 0F BE 0E 8D 41 D0 83 F8 09 76 15 8D 41 9F 83 F8 19 76 0D 8D 41 BF 83 F8 19 76 05 83 F9 5F 75 5B 48 FF 43 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1C 48 8B 13 48 8B 42 10 48 3B 42 08 74 0F 0F B6 08 48 FF C0 48 89 42 10 83 F9 FF 75 03 40 8A CF 88 0E 41 3A C8 75 A1 8A 06 41 3A C0 75 1C B8 04 00 00 00 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 8A 06 48 FF 4B 10 48 8B 4B 10 48 39 7B 08 74 0A 48 3B 4B 08 0F 87 2E FE FF FF FE C0 3C 01 E9 10 FE FF FF }
	condition:
		$1
}

rule file_158_63_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 692
		refs = "003b __ImageBase 0053 ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 005e ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0088 _getwc_nolock 00dc _ungetwc_nolock 010a ??R<lambda_6c6d19daa7c7d45df7f17119b7c25976>@@QEBA_NXZ 018f ??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z 01db ??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 4C 8B DC 49 89 5B 08 49 89 6B 10 49 89 73 20 4D 89 43 18 57 41 54 41 55 41 56 41 57 48 83 EC 40 33 ED 49 89 53 B8 49 8D 43 18 49 89 4B C0 48 8B DA 49 89 43 C8 48 8B F9 4C 8D 25 ?? ?? ?? ?? 44 8D 7D 01 8B F5 41 BD FF FF 00 00 0F B7 07 66 42 3B 84 26 ?? ?? ?? ?? 74 0F 66 42 3B 84 26 ?? ?? ?? ?? 0F 85 9C 00 00 00 4C 01 7B 10 48 8B 43 10 48 39 6B 08 74 0B 48 3B 43 08 76 05 0F B7 CD EB 1C 4C 8B 33 49 8B 0E E8 ?? ?? ?? ?? 0F B7 C8 66 41 3B C5 74 06 4D 01 7E 08 EB 02 8B CD 48 83 C6 02 66 89 0F 48 83 FE 06 75 A1 48 FF 4B 10 41 BE FD FF 00 00 48 8B 43 10 48 39 6B 08 74 06 48 3B 43 08 77 1C 0F B7 C1 66 41 2B C7 66 41 3B C6 77 0F 48 8B 13 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 48 8B 43 10 48 89 84 24 80 00 00 00 48 FF C0 48 89 43 10 48 39 6B 08 74 1F 48 3B 43 08 76 19 0F B7 C5 EB 2D 48 8D 4C 24 20 E8 ?? ?? ?? ?? B8 07 00 00 00 E9 7E 01 00 00 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 66 41 3B C5 74 06 4C 01 7E 08 EB 02 8B C5 66 89 07 66 83 F8 28 74 19 48 8D 4C 24 20 E8 ?? ?? ?? ?? F6 D8 1B C0 83 E0 FD 83 C0 07 E9 43 01 00 00 4C 01 7B 10 48 8B 43 10 48 39 6B 08 74 0B 48 3B 43 08 76 05 0F B7 C5 EB 19 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 66 41 3B C5 74 06 4C 01 7E 08 EB 02 8B C5 48 8B D3 66 89 07 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 3D 0F B7 0F 48 FF 4B 10 48 8B 43 10 48 39 6B 08 74 06 48 3B 43 08 77 1C 0F B7 C1 66 41 2B C7 66 41 3B C6 77 0F 48 8B 13 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? B8 05 00 00 00 E9 C2 00 00 00 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 3A 0F B7 0F 48 FF 4B 10 48 8B 43 10 48 39 6B 08 74 06 48 3B 43 08 77 1C 0F B7 D1 66 41 2B D7 66 41 3B D6 77 0F 48 8B 13 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? B8 06 00 00 00 EB 79 66 83 3F 29 74 6E 66 39 2F 74 5F 0F B7 0F 8D 41 D0 83 F8 09 76 19 8D 41 9F 83 F8 19 76 11 8D 41 BF 83 F8 19 76 09 83 F9 5F 0F 85 EE FE FF FF 4C 01 7B 10 48 8B 43 10 48 39 6B 08 74 0B 48 3B 43 08 76 05 0F B7 C5 EB 19 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 66 41 3B C5 74 06 4C 01 7E 08 EB 02 8B C5 66 89 07 66 83 F8 29 75 9C 66 83 3F 29 0F 85 A9 FE FF FF B8 04 00 00 00 4C 8D 5C 24 40 49 8B 5B 30 49 8B 6B 38 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_158_64_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 855
		refs = "0022 __ImageBase 0043 ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 004e ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0206 ??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z 0253 ??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 20 33 FF 4C 8D 15 ?? ?? ?? ?? 48 8B DA 4D 8B C8 48 8B F1 8B D7 41 BC FF FF 00 00 44 8D 7F 01 0F B7 06 66 42 3B 84 12 ?? ?? ?? ?? 74 0F 66 42 3B 84 12 ?? ?? ?? ?? 0F 85 99 00 00 00 4C 01 7B 10 48 8B 43 10 48 39 7B 08 74 0B 48 3B 43 08 76 05 0F B7 CF EB 20 4C 8B 03 49 8B 40 10 49 3B 40 08 74 11 0F B7 08 48 83 C0 02 49 89 40 10 66 41 3B CC 75 02 8B CF 48 83 C2 02 66 89 0E 48 83 FA 06 75 9D 48 FF 4B 10 BD FD FF 00 00 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1D 66 41 2B CF 66 3B CD 77 14 48 8B 0B 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 4C 8B 73 10 49 8D 46 01 48 89 43 10 48 39 7B 08 74 5E 48 3B 43 08 76 58 0F B7 CF EB 73 0F B7 06 48 FF 4B 10 48 8B 4B 10 48 39 7B 08 74 06 48 3B 4B 08 77 22 66 41 2B C7 BD FD FF 00 00 66 3B C5 77 14 48 8B 0B 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 66 89 3E 4C 3B 4B 10 74 07 48 8B 43 18 40 88 38 B8 07 00 00 00 E9 CD 01 00 00 48 8B 13 48 8B 42 10 48 3B 42 08 74 11 0F B7 08 48 83 C0 02 48 89 42 10 66 41 3B CC 75 02 8B CF 66 89 0E 66 83 F9 28 74 56 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1D 66 41 2B CF 66 3B CD 77 14 48 8B 0B 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 66 89 3E 4C 3B 73 10 74 09 48 8B 43 18 40 88 38 EB 03 41 8A FF 40 F6 DF 1B C0 83 E0 FD 83 C0 07 E9 4E 01 00 00 4C 01 7B 10 48 8B 43 10 48 39 7B 08 74 0B 48 3B 43 08 76 05 0F B7 CF EB 20 48 8B 13 48 8B 42 10 48 3B 42 08 74 11 0F B7 08 48 83 C0 02 48 89 42 10 66 41 3B CC 75 02 8B CF 66 89 0E 48 8B D3 48 8B CE E8 ?? ?? ?? ?? 84 C0 74 3E 0F B7 06 48 FF 4B 10 48 8B 4B 10 48 39 7B 08 74 06 48 3B 4B 08 77 1D 66 41 2B C7 66 3B C5 77 14 48 8B 0B 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 B8 05 00 00 00 E9 C5 00 00 00 48 8B D3 48 8B CE E8 ?? ?? ?? ?? 84 C0 74 3B 0F B7 0E 48 FF 4B 10 48 8B 43 10 48 39 7B 08 74 06 48 3B 43 08 77 1D 66 41 2B CF 66 3B CD 77 14 48 8B 13 48 8B 4A 10 48 3B 0A 74 08 48 83 C1 FE 48 89 4A 10 B8 06 00 00 00 EB 7B 66 83 3E 29 74 70 66 39 3E 74 62 0F B7 0E 8D 41 D0 83 F8 09 76 15 8D 41 9F 83 F8 19 76 0D 8D 41 BF 83 F8 19 76 05 83 F9 5F 75 6F 4C 01 7B 10 48 8B 43 10 48 39 7B 08 74 0B 48 3B 43 08 76 05 0F B7 CF EB 20 48 8B 13 48 8B 42 10 48 3B 42 08 74 11 0F B7 08 48 83 C0 02 48 89 42 10 66 41 3B CC 75 02 8B CF 66 89 0E 66 83 F9 29 75 99 0F B7 06 66 83 F8 29 75 27 B8 04 00 00 00 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5C C3 0F B7 06 48 FF 4B 10 48 8B 4B 10 48 39 7B 08 74 0A 48 3B 4B 08 0F 87 53 FE FF FF 66 41 2B C7 66 3B C5 E9 31 FE FF FF }
	condition:
		$1
}

rule file_158_65_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 147
		refs = "001d __ImageBase 002f ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0059 _getc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 33 DB 48 8D 2D ?? ?? ?? ?? 8B FB 48 8B F2 4C 8B F9 41 8A 07 3A 84 2F ?? ?? ?? ?? 74 09 3A 84 2F ?? ?? ?? ?? 75 3A 48 FF 46 10 48 8B 46 10 48 39 5E 08 74 06 48 3B 46 08 77 16 4C 8B 36 49 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 49 FF 46 08 EB 02 8A C3 48 FF C7 41 88 07 48 83 FF 04 75 B3 B3 01 48 8B 6C 24 48 8A C3 48 8B 5C 24 40 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_158_66_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 119
		refs = "000b __ImageBase 001c ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0026 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB"
	strings:
		$1 = { 48 89 5C 24 08 45 33 C0 48 8D 1D ?? ?? ?? ?? 45 8B C8 4C 8B D9 41 8A 03 41 3A 84 19 ?? ?? ?? ?? 74 0A 41 3A 84 19 ?? ?? ?? ?? 75 42 48 FF 42 10 48 8B 42 10 4C 39 42 08 74 06 48 3B 42 08 77 1C 4C 8B 12 49 8B 42 10 49 3B 42 08 74 0F 0F B6 08 48 FF C0 49 89 42 10 83 F9 FF 75 03 41 8A C8 49 FF C1 41 88 0B 49 83 F9 04 75 AA 41 B0 01 48 8B 5C 24 08 41 8A C0 C3 }
	condition:
		$1
}

rule file_158_67_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 162
		refs = "001d __ImageBase 0031 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 003b ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0061 _getwc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 33 DB 48 8D 2D ?? ?? ?? ?? 8B FB 48 8B F2 4C 8B F9 41 0F B7 07 66 3B 84 2F ?? ?? ?? ?? 74 0A 66 3B 84 2F ?? ?? ?? ?? 75 46 48 FF 46 10 48 8B 46 10 48 39 5E 08 74 0B 48 3B 46 08 76 05 0F B7 C3 EB 1D 4C 8B 36 49 8B 0E E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 06 49 FF 46 08 EB 02 8B C3 48 83 C7 02 66 41 89 07 48 83 FF 08 75 A4 B3 01 48 8B 6C 24 48 8A C3 48 8B 5C 24 40 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_158_68_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 136
		refs = "000b __ImageBase 001e ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0029 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB"
	strings:
		$1 = { 48 89 5C 24 08 45 33 C0 48 8D 1D ?? ?? ?? ?? 45 8B C8 4C 8B D9 41 0F B7 03 66 41 3B 84 19 ?? ?? ?? ?? 74 0B 66 41 3B 84 19 ?? ?? ?? ?? 75 50 48 FF 42 10 48 8B 42 10 4C 39 42 08 74 0C 48 3B 42 08 76 06 41 0F B7 C8 EB 25 4C 8B 12 49 8B 42 10 49 3B 42 08 74 15 0F B7 08 48 83 C0 02 49 89 42 10 B8 FF FF 00 00 66 3B C8 75 03 41 8B C8 49 83 C1 02 66 41 89 0B 49 83 F9 08 75 99 41 B0 01 48 8B 5C 24 08 41 8A C0 C3 }
	condition:
		$1
}

rule file_158_69_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 147
		refs = "001d __ImageBase 002f ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0059 _getc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 33 DB 48 8D 2D ?? ?? ?? ?? 8B FB 48 8B F2 4C 8B F9 41 8A 07 3A 84 2F ?? ?? ?? ?? 74 09 3A 84 2F ?? ?? ?? ?? 75 3A 48 FF 46 10 48 8B 46 10 48 39 5E 08 74 06 48 3B 46 08 77 16 4C 8B 36 49 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 49 FF 46 08 EB 02 8A C3 48 FF C7 41 88 07 48 83 FF 05 75 B3 B3 01 48 8B 6C 24 48 8A C3 48 8B 5C 24 40 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_158_70_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 119
		refs = "000b __ImageBase 001c ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0026 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB"
	strings:
		$1 = { 48 89 5C 24 08 45 33 C0 48 8D 1D ?? ?? ?? ?? 45 8B C8 4C 8B D9 41 8A 03 41 3A 84 19 ?? ?? ?? ?? 74 0A 41 3A 84 19 ?? ?? ?? ?? 75 42 48 FF 42 10 48 8B 42 10 4C 39 42 08 74 06 48 3B 42 08 77 1C 4C 8B 12 49 8B 42 10 49 3B 42 08 74 0F 0F B6 08 48 FF C0 49 89 42 10 83 F9 FF 75 03 41 8A C8 49 FF C1 41 88 0B 49 83 F9 05 75 AA 41 B0 01 48 8B 5C 24 08 41 8A C0 C3 }
	condition:
		$1
}

rule file_158_71_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 162
		refs = "001d __ImageBase 0031 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 003b ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0061 _getwc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 33 DB 48 8D 2D ?? ?? ?? ?? 8B FB 48 8B F2 4C 8B F9 41 0F B7 07 66 3B 84 2F ?? ?? ?? ?? 74 0A 66 3B 84 2F ?? ?? ?? ?? 75 46 48 FF 46 10 48 8B 46 10 48 39 5E 08 74 0B 48 3B 46 08 76 05 0F B7 C3 EB 1D 4C 8B 36 49 8B 0E E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 06 49 FF 46 08 EB 02 8B C3 48 83 C7 02 66 41 89 07 48 83 FF 0A 75 A4 B3 01 48 8B 6C 24 48 8A C3 48 8B 5C 24 40 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_158_72_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 136
		refs = "000b __ImageBase 001e ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0029 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB"
	strings:
		$1 = { 48 89 5C 24 08 45 33 C0 48 8D 1D ?? ?? ?? ?? 45 8B C8 4C 8B D9 41 0F B7 03 66 41 3B 84 19 ?? ?? ?? ?? 74 0B 66 41 3B 84 19 ?? ?? ?? ?? 75 50 48 FF 42 10 48 8B 42 10 4C 39 42 08 74 0C 48 3B 42 08 76 06 41 0F B7 C8 EB 25 4C 8B 12 49 8B 42 10 49 3B 42 08 74 15 0F B7 08 48 83 C0 02 49 89 42 10 B8 FF FF 00 00 66 3B C8 75 03 41 8B C8 49 83 C1 02 66 41 89 0B 49 83 F9 0A 75 99 41 B0 01 48 8B 5C 24 08 41 8A C0 C3 }
	condition:
		$1
}

rule file_158_75_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@H_N@Z"
		size = 1181
		refs = "0037 _errno 0042 _invalid_parameter_noinfo 0075 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 009b _getc_nolock 00cb _isctype_l 027b _ungetc_nolock 03ce ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 50 45 33 E4 45 8A F9 45 8B E8 48 8B DA 4C 39 22 74 06 4C 39 62 18 75 29 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 09 4C 39 63 10 75 03 44 88 20 33 C0 E9 20 04 00 00 45 85 C0 74 09 41 8D 40 FE 83 F8 22 77 C9 48 8B D1 48 8D 4D D8 E8 ?? ?? ?? ?? 48 8B 43 10 48 89 45 D0 48 FF C0 48 89 43 10 4C 39 63 08 74 06 48 3B 43 08 77 18 48 8B 33 48 8B 0E E8 ?? ?? ?? ?? 8B F8 83 F8 FF 74 06 48 FF 46 08 EB 03 41 8A FC 41 BE 08 00 00 00 48 8B 45 E0 40 0F B6 CF 83 78 08 01 7E 0E 4C 8D 45 E0 41 8B D6 E8 ?? ?? ?? ?? EB 11 48 8B 45 E0 48 8B D1 48 8B 08 0F B7 04 51 41 23 C6 85 C0 74 32 48 FF 43 10 48 8B 43 10 4C 39 63 08 74 0B 48 3B 43 08 76 05 41 8A FC EB B6 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 83 F8 FF 74 EB 48 FF 47 08 40 8A F8 EB 9D 45 84 FF 41 8B F4 40 0F 95 C6 40 80 FF 2D 75 05 83 CE 02 EB 06 40 80 FF 2B 75 30 48 FF 43 10 48 8B 43 10 4C 39 63 08 74 06 48 3B 43 08 77 19 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 83 F8 FF 74 09 48 FF 47 08 40 8A F8 EB 03 41 8A FC 4D 8B F4 41 F7 C5 EF FF FF FF 0F 85 0C 01 00 00 8D 47 D0 3C 09 77 09 40 0F BE C7 83 C0 D0 EB 23 8D 47 9F 3C 19 77 09 40 0F BE C7 83 C0 A9 EB 13 8D 47 BF 3C 19 77 09 40 0F BE C7 83 C0 C9 EB 03 83 C8 FF 85 C0 74 18 41 B9 08 00 00 00 45 85 ED 0F 85 CC 00 00 00 45 8D 69 02 E9 C3 00 00 00 48 FF 43 10 48 8B 43 10 4C 39 63 08 74 06 48 3B 43 08 77 67 4C 8B 3B 49 8B 0F E8 ?? ?? ?? ?? 8B D0 83 F8 FF 74 55 49 FF 47 08 8D 48 A8 F6 C1 DF 75 4C 45 85 ED B8 10 00 00 00 44 0F 44 E8 48 FF 43 10 48 8B 43 10 4C 39 63 08 74 0B 48 3B 43 08 76 05 41 8A FC EB 66 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 41 B9 08 00 00 00 83 F8 FF 74 09 48 FF 47 08 40 8A F8 EB 4D 41 8A FC EB 48 41 8A D4 45 85 ED 41 B9 08 00 00 00 45 0F 44 E9 48 FF 4B 10 48 8B 43 10 4C 39 63 08 74 06 48 3B 43 08 77 24 8D 42 01 3C 01 76 1D 0F BE CA 48 8B 13 83 F9 FF 74 12 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 41 B9 08 00 00 00 4D 63 E5 33 D2 48 83 C8 FF 49 F7 F4 48 89 55 38 4C 8B F8 8D 4F D0 80 F9 09 77 0A 44 0F BE C7 41 83 C0 D0 EB 26 8D 47 9F 3C 19 77 0A 44 0F BE C7 41 83 C0 A9 EB 15 8D 47 BF 3C 19 77 0A 44 0F BE C7 41 83 C0 C9 EB 04 41 83 C8 FF 41 83 F8 FF 74 71 45 3B C5 73 6C 41 0B F1 4D 3B F7 72 0F 75 08 41 8B C0 48 3B C2 76 05 83 CE 04 EB 0D 49 8B CC 49 0F AF CE 45 8B F0 4C 03 F1 48 FF 43 10 48 83 7B 08 00 48 8B 43 10 74 0E 48 3B 43 08 76 08 40 32 FF E9 7C FF FF FF 48 8B 3B 48 8B 0F E8 ?? ?? ?? ?? 83 F8 FF 74 16 48 FF 47 08 40 8A F8 48 8B 55 38 41 B9 08 00 00 00 E9 56 FF FF FF 40 32 FF EB EC 49 83 CC FF 45 33 FF 4C 01 63 10 48 8B 43 10 4C 39 7B 08 74 06 48 3B 43 08 77 1F 8D 47 01 3C 01 76 18 48 8B 13 40 0F BE CF 41 3B CC 74 0C 4C 01 62 08 48 8B 12 E8 ?? ?? ?? ?? 40 F6 C6 08 75 41 48 8B 45 D0 48 3B 43 10 74 07 48 8B 43 18 44 88 38 44 38 7D F0 74 0B 48 8B 45 D8 83 A0 A8 03 00 00 FD 48 8B 43 18 48 85 C0 0F 84 A2 FC FF FF 4C 39 7B 10 0F 85 98 FC FF FF 44 88 38 E9 90 FC FF FF 49 8B D6 8B CE E8 ?? ?? ?? ?? 84 C0 74 7A E8 ?? ?? ?? ?? C7 00 22 00 00 00 40 F6 C6 01 75 05 4D 8B F4 EB 6D 40 F6 C6 02 74 2F 44 38 7D F0 74 0B 48 8B 45 D8 83 A0 A8 03 00 00 FD 48 8B 43 18 48 85 C0 74 09 4C 39 7B 10 75 03 44 88 38 48 B8 00 00 00 00 00 00 00 80 EB 5E 44 38 7D F0 74 0B 48 8B 45 D8 83 A0 A8 03 00 00 FD 48 8B 43 18 48 85 C0 74 09 4C 39 7B 10 75 03 44 88 38 48 B8 FF FF FF FF FF FF FF 7F EB 2F 40 F6 C6 02 74 03 49 F7 DE 44 38 7D F0 74 0B 48 8B 4D D8 83 A1 A8 03 00 00 FD 48 8B 4B 18 48 85 C9 74 09 4C 39 7B 10 75 03 44 88 39 49 8B C6 4C 8D 5C 24 50 49 8B 5B 30 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_158_76_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z"
		size = 2424
		refs = "0037 _errno 0042 _invalid_parameter_noinfo 0079 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00b1 _getwc_nolock 0110 iswctype 0571 _ungetwc_nolock 0885 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 81 EC B0 00 00 00 45 33 F6 41 8A E9 45 8B E8 48 8B FA 4C 39 32 74 06 4C 39 72 18 75 29 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 47 18 48 85 C0 74 09 4C 39 77 10 75 03 44 88 30 33 C0 E9 F8 08 00 00 45 85 C0 74 09 41 8D 40 FE 83 F8 22 77 C9 48 8B D1 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 47 10 4D 8B E6 48 89 84 24 A0 00 00 00 BE 01 00 00 00 48 FF C0 41 BF FF FF 00 00 48 89 47 10 4C 39 77 08 74 06 48 3B 47 08 77 59 48 8B 37 48 8B 0E E8 ?? ?? ?? ?? 0F B7 D8 66 41 3B C7 74 0D B8 01 00 00 00 48 01 46 08 8B F0 EB 3C 41 8B DE BE 01 00 00 00 EB 32 48 01 77 10 48 8B 47 10 4C 39 77 08 74 06 48 3B 47 08 77 1A 48 8B 1F 48 8B 0B E8 ?? ?? ?? ?? 66 41 3B C7 74 09 48 01 73 08 0F B7 D8 EB 04 41 0F B7 DE BA 08 00 00 00 0F B7 CB E8 ?? ?? ?? ?? 85 C0 75 BD 40 84 ED 45 8B FE 41 0F 95 C7 66 83 FB 2D 75 06 41 83 CF 02 EB 06 66 83 FB 2B 75 20 48 01 77 10 48 8B 47 10 4C 39 77 08 0F 84 21 01 00 00 48 3B 47 08 0F 86 17 01 00 00 41 0F B7 DE BD FF FF 00 00 C7 84 24 E8 00 00 00 70 0A 00 00 B8 66 0A 00 00 C7 44 24 20 E6 0A 00 00 B9 30 00 00 00 C7 44 24 24 F0 0A 00 00 BA 10 FF 00 00 C7 44 24 28 66 0B 00 00 41 B8 60 06 00 00 C7 44 24 2C 70 0B 00 00 44 8D 58 80 C7 44 24 30 66 0C 00 00 41 B9 F0 06 00 00 C7 44 24 34 70 0C 00 00 41 BA 66 09 00 00 C7 44 24 38 E6 0C 00 00 C7 44 24 3C F0 0C 00 00 C7 44 24 40 66 0D 00 00 C7 44 24 44 70 0D 00 00 C7 44 24 48 50 0E 00 00 C7 44 24 4C 5A 0E 00 00 C7 44 24 50 D0 0E 00 00 C7 44 24 54 DA 0E 00 00 C7 44 24 58 20 0F 00 00 C7 44 24 5C 2A 0F 00 00 C7 44 24 60 40 10 00 00 C7 44 24 64 4A 10 00 00 C7 44 24 68 E0 17 00 00 C7 44 24 6C EA 17 00 00 C7 44 24 70 10 18 00 00 C7 44 24 74 1A 18 00 00 C7 44 24 78 1A FF 00 00 41 F7 C5 EF FF FF FF 0F 85 27 03 00 00 66 3B D9 0F 82 EA 01 00 00 66 83 FB 3A 73 34 0F B7 C3 2B C1 E9 D5 01 00 00 48 8B 1F 48 8B 0B E8 ?? ?? ?? ?? BD FF FF 00 00 66 3B C5 74 0C 48 01 73 08 0F B7 D8 E9 D1 FE FF FF 41 0F B7 DE E9 C8 FE FF FF 66 3B DA 0F 83 91 01 00 00 66 41 3B D8 0F 82 9D 01 00 00 B9 6A 06 00 00 66 3B D9 73 0B 0F B7 C3 41 2B C0 E9 83 01 00 00 66 41 3B D9 0F 82 7E 01 00 00 B9 FA 06 00 00 66 3B D9 73 0B 0F B7 C3 41 2B C1 E9 64 01 00 00 66 41 3B DA 0F 82 5F 01 00 00 B9 70 09 00 00 66 3B D9 73 0B 0F B7 C3 41 2B C2 E9 45 01 00 00 66 41 3B DB 0F 82 40 01 00 00 B9 F0 09 00 00 66 3B D9 73 0B 0F B7 C3 41 2B C3 E9 26 01 00 00 66 3B D8 0F 82 22 01 00 00 66 3B 9C 24 E8 00 00 00 73 0D 0F B7 C3 2D 66 0A 00 00 E9 06 01 00 00 8B 4C 24 20 66 3B D9 0F 82 FE 00 00 00 66 3B 5C 24 24 0F 82 0F FF FF FF 8B 4C 24 28 66 3B D9 0F 82 E6 00 00 00 66 3B 5C 24 2C 0F 82 F7 FE FF FF 8B 4C 24 30 66 3B D9 0F 82 CE 00 00 00 66 3B 5C 24 34 0F 82 DF FE FF FF 8B 4C 24 38 66 3B D9 0F 82 B6 00 00 00 66 3B 5C 24 3C 0F 82 C7 FE FF FF 8B 4C 24 40 66 3B D9 0F 82 9E 00 00 00 66 3B 5C 24 44 0F 82 AF FE FF FF 8B 4C 24 48 66 3B D9 0F 82 86 00 00 00 66 3B 5C 24 4C 0F 82 97 FE FF FF 8B 4C 24 50 66 3B D9 72 72 66 3B 5C 24 54 0F 82 83 FE FF FF 8B 4C 24 58 66 3B D9 72 5E 66 3B 5C 24 5C 0F 82 6F FE FF FF 8B 4C 24 60 66 3B D9 72 4A 66 3B 5C 24 64 0F 82 5B FE FF FF 8B 4C 24 68 66 3B D9 72 36 66 3B 5C 24 6C 0F 82 47 FE FF FF 8B 4C 24 70 66 3B D9 72 22 66 3B 5C 24 74 73 1B E9 32 FE FF FF 66 3B 5C 24 78 73 07 0F B7 C3 2B C2 EB 03 83 C8 FF 83 F8 FF 75 29 8D 43 BF 66 83 F8 19 76 0E 8D 43 9F 66 83 F8 19 76 05 83 C8 FF EB 12 8D 43 9F 66 83 F8 19 0F B7 C3 77 03 83 E8 20 83 C0 C9 85 C0 74 1C 41 B9 01 00 00 00 45 8D 51 07 45 85 ED 0F 85 00 01 00 00 45 8D 69 09 E9 F7 00 00 00 48 01 77 10 48 8B 47 10 4C 39 77 08 74 0F 48 3B 47 08 76 09 41 0F B7 CE E9 8C 00 00 00 48 8B 37 48 8B 0E E8 ?? ?? ?? ?? 0F B7 C8 66 3B C5 74 6C 41 B9 01 00 00 00 8D 41 A8 4C 01 4E 08 BA DF FF 00 00 66 85 C2 75 5F 45 85 ED 41 8D 41 0F 44 0F 44 E8 4C 01 4F 10 48 8B 47 10 4C 39 77 08 74 13 48 3B 47 08 76 0D 41 0F B7 DE 45 8D 51 07 E9 84 00 00 00 48 8B 1F 48 8B 0B E8 ?? ?? ?? ?? 41 B9 01 00 00 00 45 8D 51 07 66 3B C5 74 09 4C 01 4B 08 0F B7 D8 EB 61 41 0F B7 DE EB 5B 41 8B CE BE 01 00 00 00 EB 03 49 8B F1 45 85 ED 41 BA 08 00 00 00 45 0F 44 EA 48 FF 4F 10 48 8B 47 10 4C 39 77 08 74 06 48 3B 47 08 77 27 0F B7 C1 41 BB FD FF 00 00 66 2B C6 66 41 3B C3 77 15 48 8B 17 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 41 BA 08 00 00 00 41 B9 01 00 00 00 33 D2 49 63 ED 48 83 C8 FF 48 F7 F5 33 C9 4C 8B F2 48 8B F0 B8 30 00 00 00 66 3B D8 0F 82 9A 01 00 00 66 83 FB 3A 73 0C 44 0F B7 C3 44 2B C0 E9 82 01 00 00 B8 10 FF 00 00 66 3B D8 0F 83 65 01 00 00 B8 60 06 00 00 66 3B D8 0F 82 6C 01 00 00 8D 50 0A 66 3B DA 72 D0 B8 F0 06 00 00 66 3B D8 0F 82 56 01 00 00 8D 50 0A 66 3B DA 72 BA B8 66 09 00 00 66 3B D8 0F 82 40 01 00 00 8D 50 0A 66 3B DA 72 A4 8D 42 76 66 3B D8 0F 82 2C 01 00 00 8D 50 0A 66 3B DA 72 90 8D 42 76 66 3B D8 0F 82 18 01 00 00 66 3B 9C 24 E8 00 00 00 0F 82 76 FF FF FF 8B 44 24 20 66 3B D8 0F 82 FD 00 00 00 66 3B 5C 24 24 0F 82 5E FF FF FF 8B 44 24 28 66 3B D8 0F 82 E5 00 00 00 66 3B 5C 24 2C 0F 82 46 FF FF FF 8B 44 24 30 66 3B D8 0F 82 CD 00 00 00 66 3B 5C 24 34 0F 82 2E FF FF FF 8B 44 24 38 66 3B D8 0F 82 B5 00 00 00 66 3B 5C 24 3C 0F 82 16 FF FF FF 8B 44 24 40 66 3B D8 0F 82 9D 00 00 00 66 3B 5C 24 44 0F 82 FE FE FF FF 8B 44 24 48 66 3B D8 0F 82 85 00 00 00 66 3B 5C 24 4C 0F 82 E6 FE FF FF 8B 44 24 50 66 3B D8 72 71 66 3B 5C 24 54 0F 82 D2 FE FF FF 8B 44 24 58 66 3B D8 72 5D 66 3B 5C 24 5C 0F 82 BE FE FF FF 8B 44 24 60 66 3B D8 72 49 66 3B 5C 24 64 0F 82 AA FE FF FF 8B 44 24 68 66 3B D8 72 35 66 3B 5C 24 6C 0F 82 96 FE FF FF 8B 44 24 70 66 3B D8 72 21 66 3B 5C 24 74 73 1A E9 81 FE FF FF 66 3B 5C 24 78 0F 82 76 FE FF FF 41 83 C8 FF 41 83 F8 FF 75 2D 8D 43 BF 66 83 F8 19 76 0F 8D 43 9F 66 83 F8 19 76 06 41 83 C8 FF EB 15 8D 43 9F 44 0F B7 C3 66 83 F8 19 77 04 41 83 E8 20 41 83 C0 C9 41 83 F8 FF 74 7E 45 3B C5 73 79 45 0B FA 4C 3B E6 72 10 75 08 41 8B C0 49 3B C6 76 06 41 83 CF 04 EB 0F 48 8B CD 49 0F AF CC 45 8B E0 4C 03 E1 33 C9 4C 01 4F 10 48 8B 47 10 48 39 4F 08 74 0E 48 3B 47 08 76 08 0F B7 D9 E9 DD FD FF FF 48 8B 1F 48 8B 0B E8 ?? ?? ?? ?? B9 FF FF 00 00 41 B9 01 00 00 00 66 3B C1 74 14 4C 01 4B 08 0F B7 D8 33 C9 41 BA 08 00 00 00 E9 AE FD FF FF 33 C9 0F B7 D9 EB EE 48 FF 4F 10 33 F6 48 8B 47 10 48 39 77 08 74 06 48 3B 47 08 77 23 0F B7 C3 B9 FD FF 00 00 66 41 2B C1 66 3B C1 77 12 48 8B 17 0F B7 CB 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? B8 08 00 00 00 44 84 F8 75 4D 48 8B 84 24 A0 00 00 00 48 3B 47 10 74 07 48 8B 47 18 40 88 30 40 38 B4 24 98 00 00 00 74 0F 48 8B 84 24 80 00 00 00 83 A0 A8 03 00 00 FD 48 8B 47 18 48 85 C0 0F 84 EC F7 FF FF 48 39 77 10 0F 85 E2 F7 FF FF 40 88 30 E9 DA F7 FF FF 49 8B D4 41 8B CF E8 ?? ?? ?? ?? 84 C0 0F 84 8F 00 00 00 E8 ?? ?? ?? ?? C7 00 22 00 00 00 B8 01 00 00 00 44 84 F8 75 06 49 83 CC FF EB 7D 41 F6 C7 02 74 37 40 38 B4 24 98 00 00 00 74 0F 48 8B 84 24 80 00 00 00 83 A0 A8 03 00 00 FD 48 8B 47 18 48 85 C0 74 09 48 39 77 10 75 03 40 88 30 48 B8 00 00 00 00 00 00 00 80 EB 6E 40 38 B4 24 98 00 00 00 74 0F 48 8B 84 24 80 00 00 00 83 A0 A8 03 00 00 FD 48 8B 47 18 48 85 C0 74 09 48 39 77 10 75 03 40 88 30 48 B8 FF FF FF FF FF FF FF 7F EB 37 41 F6 C7 02 74 03 49 F7 DC 40 38 B4 24 98 00 00 00 74 0F 48 8B 8C 24 80 00 00 00 83 A1 A8 03 00 00 FD 48 8B 4F 18 48 85 C9 74 09 48 39 77 10 75 03 40 88 31 49 8B C4 4C 8D 9C 24 B0 00 00 00 49 8B 5B 30 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_158_77_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@H_N@Z"
		size = 1169
		refs = "0036 _errno 0041 _invalid_parameter_noinfo 0074 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00d2 _isctype_l 03c1 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 40 33 F6 45 8A E1 45 8B F8 48 8B DA 48 39 32 74 06 48 39 72 18 75 29 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 74 09 48 39 73 10 75 03 40 88 30 33 C0 E9 15 04 00 00 45 85 C0 74 09 41 8D 40 FE 83 F8 22 77 C9 48 8B D1 48 8D 4D E0 E8 ?? ?? ?? ?? 4C 8B F6 4C 8B 6B 10 4C 89 6D 38 49 8D 45 01 48 89 43 10 48 39 73 08 74 06 48 3B 43 08 77 1C 48 8B 0B 48 8B 41 10 48 3B 41 08 74 0F 0F B6 38 48 FF C0 48 89 41 10 83 FF FF 75 03 40 8A FE 41 BD 08 00 00 00 48 8B 45 E8 40 0F B6 CF 83 78 08 01 7E 0E 4C 8D 45 E8 41 8B D5 E8 ?? ?? ?? ?? EB 11 48 8B 45 E8 48 8B D1 48 8B 08 0F B7 04 51 41 23 C5 85 C0 74 37 48 FF 43 10 48 8B 43 10 48 39 73 08 74 0B 48 3B 43 08 76 05 40 8A FE EB B6 48 8B 0B 48 8B 41 10 48 3B 41 08 74 EE 0F B6 38 48 FF C0 48 89 41 10 83 FF FF 74 DF EB 98 45 84 E4 40 0F 95 C6 40 80 FF 2D 75 05 83 CE 02 EB 06 40 80 FF 2B 75 3A 48 FF 43 10 45 33 E4 48 8B 43 10 4C 39 63 08 74 0B 48 3B 43 08 76 05 41 8A FC EB 21 48 8B 0B 48 8B 41 10 48 3B 41 08 74 EE 0F B6 38 48 FF C0 48 89 41 10 83 FF FF 75 05 EB DD 45 33 E4 41 B3 19 41 F7 C7 EF FF FF FF 0F 85 02 01 00 00 8D 47 D0 3C 09 77 09 40 0F BE C7 83 C0 D0 EB 25 8D 47 9F 41 3A C3 77 09 40 0F BE C7 83 C0 A9 EB 14 8D 47 BF 41 3A C3 77 09 40 0F BE C7 83 C0 C9 EB 03 83 C8 FF 85 C0 74 14 45 85 FF 0F 85 C0 00 00 00 41 BF 0A 00 00 00 E9 B5 00 00 00 48 FF 43 10 48 8B 43 10 4C 39 63 08 74 06 48 3B 43 08 77 66 48 8B 13 48 8B 42 10 48 3B 42 08 74 59 0F B6 08 48 FF C0 48 89 42 10 83 F9 FF 74 4A 8D 41 A8 A8 DF 75 46 45 85 FF B8 10 00 00 00 44 0F 44 F8 48 FF 43 10 48 8B 43 10 4C 39 63 08 74 0B 48 3B 43 08 76 05 41 8A FC EB 59 48 8B 0B 48 8B 41 10 48 3B 41 08 74 EE 0F B6 38 48 FF C0 48 89 41 10 83 FF FF 75 3D EB DD 41 8A CC 45 85 FF 41 8B C5 44 0F 44 F8 48 FF 4B 10 48 8B 43 10 4C 39 63 08 74 06 48 3B 43 08 77 1A FE C1 80 F9 01 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 4D 63 D7 33 D2 48 83 C8 FF 49 F7 F2 4C 8B C8 8D 4F D0 80 F9 09 77 0A 44 0F BE C7 41 83 C0 D0 EB 28 8D 47 9F 41 3A C3 77 0A 44 0F BE C7 41 83 C0 A9 EB 16 8D 47 BF 41 3A C3 77 0A 44 0F BE C7 41 83 C0 C9 EB 04 41 83 C8 FF 41 83 F8 FF 74 66 45 3B C7 73 61 41 0B F5 4D 3B F1 72 0F 75 08 41 8B C0 48 3B C2 76 05 83 CE 04 EB 0D 49 8B CA 49 0F AF CE 45 8B F0 4C 03 F1 48 FF 43 10 48 8B 43 10 4C 39 63 08 74 0E 48 3B 43 08 76 08 41 8A FC E9 7B FF FF FF 48 8B 0B 48 8B 41 10 48 3B 41 08 74 EB 0F B6 38 48 FF C0 48 89 41 10 83 FF FF 74 DC E9 5A FF FF FF 48 FF 4B 10 48 8B 43 10 4C 8B 6D 38 4C 39 63 08 74 06 48 3B 43 08 77 1C 40 FE C7 40 80 FF 01 76 13 48 8B 0B 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 B8 08 00 00 00 40 84 F0 75 3D 4C 3B 6B 10 74 07 48 8B 43 18 44 88 20 44 38 65 F8 74 0B 48 8B 45 E0 83 A0 A8 03 00 00 FD 48 8B 43 18 48 85 C0 0F 84 AE FC FF FF 4C 39 63 10 0F 85 A4 FC FF FF 44 88 20 E9 9C FC FF FF 49 8B D6 8B CE E8 ?? ?? ?? ?? 84 C0 74 7B E8 ?? ?? ?? ?? C7 00 22 00 00 00 40 F6 C6 01 75 06 49 83 CE FF EB 6D 40 F6 C6 02 74 2F 44 38 65 F8 74 0B 48 8B 45 E0 83 A0 A8 03 00 00 FD 48 8B 43 18 48 85 C0 74 09 4C 39 63 10 75 03 44 88 20 48 B8 00 00 00 00 00 00 00 80 EB 5E 44 38 65 F8 74 0B 48 8B 45 E0 83 A0 A8 03 00 00 FD 48 8B 43 18 48 85 C0 74 09 4C 39 63 10 75 03 44 88 20 48 B8 FF FF FF FF FF FF FF 7F EB 2F 40 F6 C6 02 74 03 49 F7 DE 44 38 65 F8 74 0B 48 8B 4D E0 83 A1 A8 03 00 00 FD 48 8B 4B 18 48 85 C9 74 09 4C 39 63 10 75 03 44 88 21 49 8B C6 4C 8D 5C 24 40 49 8B 5B 30 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_158_78_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z"
		size = 2379
		refs = "0037 _errno 0042 _invalid_parameter_noinfo 0079 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00d4 iswctype 085d ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 81 EC B0 00 00 00 45 33 E4 41 8A F1 45 8B F8 48 8B FA 4C 39 22 74 06 4C 39 62 18 75 29 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 8B 47 18 48 85 C0 74 09 4C 39 67 10 75 03 44 88 20 33 C0 E9 CB 08 00 00 45 85 C0 74 09 41 8D 40 FE 83 F8 22 77 C9 48 8B D1 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 4D 8B F4 4C 8B 6F 10 BD FF FF 00 00 4C 89 AC 24 80 00 00 00 49 8D 45 01 48 89 47 10 4C 39 67 08 74 0C 48 3B 47 08 76 06 41 0F B7 DC EB 20 48 8B 0F 48 8B 41 10 48 3B 41 08 74 10 0F B7 18 48 83 C0 02 48 89 41 10 66 3B DD 75 03 41 8B DC BA 08 00 00 00 0F B7 CB E8 ?? ?? ?? ?? 85 C0 74 4F 41 BD 01 00 00 00 4C 01 6F 10 48 8B 47 10 4C 39 67 08 74 06 48 3B 47 08 77 20 48 8B 0F 48 8B 41 10 48 3B 41 08 74 13 0F B7 10 48 83 C0 02 48 89 41 10 0F B7 DA 66 3B D5 75 04 41 0F B7 DC BA 08 00 00 00 0F B7 CB E8 ?? ?? ?? ?? 85 C0 75 B7 40 84 F6 41 8B EC 40 0F 95 C5 66 83 FB 2D 75 05 83 CD 02 EB 06 66 83 FB 2B 75 46 BE 01 00 00 00 48 01 77 10 48 8B 47 10 4C 39 67 08 74 0C 48 3B 47 08 76 06 41 0F B7 DC EB 2C 48 8B 0F 48 8B 41 10 48 3B 41 08 74 ED 0F B7 10 48 83 C0 02 48 89 41 10 B8 FF FF 00 00 66 3B D0 74 D8 0F B7 DA EB 05 BE 01 00 00 00 C7 84 24 E8 00 00 00 70 0A 00 00 B8 66 0A 00 00 C7 44 24 20 E6 0A 00 00 B9 30 00 00 00 C7 44 24 24 F0 0A 00 00 BA 60 06 00 00 C7 44 24 28 66 0B 00 00 41 B8 10 FF 00 00 C7 44 24 2C 70 0B 00 00 44 8D 58 80 C7 44 24 30 66 0C 00 00 41 B9 F0 06 00 00 C7 44 24 34 70 0C 00 00 41 BA 66 09 00 00 C7 44 24 38 E6 0C 00 00 C7 44 24 3C F0 0C 00 00 C7 44 24 40 66 0D 00 00 C7 44 24 44 70 0D 00 00 C7 44 24 48 50 0E 00 00 C7 44 24 4C 5A 0E 00 00 C7 44 24 50 D0 0E 00 00 C7 44 24 54 DA 0E 00 00 C7 44 24 58 20 0F 00 00 C7 44 24 5C 2A 0F 00 00 C7 44 24 60 40 10 00 00 C7 44 24 64 4A 10 00 00 C7 44 24 68 E0 17 00 00 C7 44 24 6C EA 17 00 00 C7 44 24 70 10 18 00 00 C7 44 24 74 1A 18 00 00 C7 44 24 78 1A FF 00 00 41 F7 C7 EF FF FF FF 0F 85 E7 02 00 00 66 3B D9 0F 82 C0 01 00 00 66 83 FB 3A 73 0A 0F B7 C3 2B C1 E9 AB 01 00 00 66 41 3B D8 0F 83 8F 01 00 00 66 3B DA 0F 82 9D 01 00 00 B9 6A 06 00 00 66 3B D9 73 0A 0F B7 C3 2B C2 E9 84 01 00 00 66 41 3B D9 0F 82 7F 01 00 00 B9 FA 06 00 00 66 3B D9 73 0B 0F B7 C3 41 2B C1 E9 65 01 00 00 66 41 3B DA 0F 82 60 01 00 00 B9 70 09 00 00 66 3B D9 73 0B 0F B7 C3 41 2B C2 E9 46 01 00 00 66 41 3B DB 0F 82 41 01 00 00 B9 F0 09 00 00 66 3B D9 73 0B 0F B7 C3 41 2B C3 E9 27 01 00 00 66 3B D8 0F 82 23 01 00 00 66 3B 9C 24 E8 00 00 00 73 0D 0F B7 C3 2D 66 0A 00 00 E9 07 01 00 00 8B 4C 24 20 66 3B D9 0F 82 FF 00 00 00 66 3B 5C 24 24 0F 82 3A FF FF FF 8B 4C 24 28 66 3B D9 0F 82 E7 00 00 00 66 3B 5C 24 2C 0F 82 22 FF FF FF 8B 4C 24 30 66 3B D9 0F 82 CF 00 00 00 66 3B 5C 24 34 0F 82 0A FF FF FF 8B 4C 24 38 66 3B D9 0F 82 B7 00 00 00 66 3B 5C 24 3C 0F 82 F2 FE FF FF 8B 4C 24 40 66 3B D9 0F 82 9F 00 00 00 66 3B 5C 24 44 0F 82 DA FE FF FF 8B 4C 24 48 66 3B D9 0F 82 87 00 00 00 66 3B 5C 24 4C 0F 82 C2 FE FF FF 8B 4C 24 50 66 3B D9 72 73 66 3B 5C 24 54 0F 82 AE FE FF FF 8B 4C 24 58 66 3B D9 72 5F 66 3B 5C 24 5C 0F 82 9A FE FF FF 8B 4C 24 60 66 3B D9 72 4B 66 3B 5C 24 64 0F 82 86 FE FF FF 8B 4C 24 68 66 3B D9 72 37 66 3B 5C 24 6C 0F 82 72 FE FF FF 8B 4C 24 70 66 3B D9 72 23 66 3B 5C 24 74 73 1C E9 5D FE FF FF 66 3B 5C 24 78 73 08 0F B7 C3 41 2B C0 EB 03 83 C8 FF 83 F8 FF 75 29 8D 43 BF 66 83 F8 19 76 0E 8D 43 9F 66 83 F8 19 76 05 83 C8 FF EB 12 8D 43 9F 66 83 F8 19 0F B7 C3 77 03 83 E8 20 83 C0 C9 85 C0 74 14 45 85 FF 0F 85 E8 00 00 00 41 BF 0A 00 00 00 E9 DD 00 00 00 48 01 77 10 48 8B 47 10 4C 39 67 08 74 0C 48 3B 47 08 76 06 41 0F B7 CC EB 7C 48 8B 17 48 8B 42 10 48 3B 42 08 74 6C 0F B7 08 41 B8 FF FF 00 00 48 83 C0 02 48 89 42 10 66 41 3B C8 74 55 8D 41 A8 41 8D 50 E0 66 85 C2 75 4C 45 85 FF B8 10 00 00 00 44 0F 44 F8 48 01 77 10 48 8B 47 10 4C 39 67 08 74 0C 48 3B 47 08 76 06 41 0F B7 DC EB 67 48 8B 0F 48 8B 41 10 48 3B 41 08 74 ED 0F B7 10 48 83 C0 02 48 89 41 10 66 41 3B D0 74 DC 0F B7 DA EB 44 41 8B CC 45 85 FF B8 08 00 00 00 44 0F 44 F8 48 FF 4F 10 48 8B 47 10 4C 39 67 08 74 06 48 3B 47 08 77 21 66 2B CE B8 FD FF 00 00 66 3B C8 77 14 48 8B 0F 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 41 B8 10 FF 00 00 33 D2 4D 63 D7 48 83 C8 FF 49 F7 F2 4C 8B DA 4C 8B C8 BA 08 00 00 00 44 8D 6A 28 66 41 3B DD 0F 82 A3 01 00 00 66 83 FB 3A 73 0C 44 0F B7 C3 45 2B C5 E9 8B 01 00 00 66 41 3B D8 0F 83 69 01 00 00 B8 60 06 00 00 66 3B D8 0F 82 79 01 00 00 8D 48 0A 66 3B D9 73 0C 44 0F B7 C3 44 2B C0 E9 5F 01 00 00 B8 F0 06 00 00 66 3B D8 0F 82 57 01 00 00 8D 48 0A 66 3B D9 72 DE B8 66 09 00 00 66 3B D8 0F 82 41 01 00 00 8D 48 0A 66 3B D9 72 C8 8D 41 76 66 3B D8 0F 82 2D 01 00 00 8D 48 0A 66 3B D9 72 B4 8D 41 76 66 3B D8 0F 82 19 01 00 00 66 3B 9C 24 E8 00 00 00 72 9E 8B 44 24 20 66 3B D8 0F 82 02 01 00 00 66 3B 5C 24 24 72 8A 8B 44 24 28 66 3B D8 0F 82 EE 00 00 00 66 3B 5C 24 2C 0F 82 72 FF FF FF 8B 44 24 30 66 3B D8 0F 82 D6 00 00 00 66 3B 5C 24 34 0F 82 5A FF FF FF 8B 44 24 38 66 3B D8 0F 82 BE 00 00 00 66 3B 5C 24 3C 0F 82 42 FF FF FF 8B 44 24 40 66 3B D8 0F 82 A6 00 00 00 66 3B 5C 24 44 0F 82 2A FF FF FF 8B 44 24 48 66 3B D8 0F 82 8E 00 00 00 66 3B 5C 24 4C 0F 82 12 FF FF FF 8B 44 24 50 66 3B D8 72 7A 66 3B 5C 24 54 0F 82 FE FE FF FF 8B 44 24 58 66 3B D8 72 66 66 3B 5C 24 5C 0F 82 EA FE FF FF 8B 44 24 60 66 3B D8 72 52 66 3B 5C 24 64 0F 82 D6 FE FF FF 8B 44 24 68 66 3B D8 72 3E 66 3B 5C 24 6C 0F 82 C2 FE FF FF 8B 44 24 70 66 3B D8 72 2A 66 3B 5C 24 74 73 23 E9 AD FE FF FF 66 3B 5C 24 78 73 0D 44 0F B7 C3 41 81 E8 10 FF 00 00 EB 04 41 83 C8 FF 41 83 F8 FF 75 2D 8D 43 BF 66 83 F8 19 76 0F 8D 43 9F 66 83 F8 19 76 06 41 83 C8 FF EB 15 8D 43 9F 44 0F B7 C3 66 83 F8 19 77 04 41 83 E8 20 41 83 C0 C9 41 83 F8 FF 74 7E 45 3B C7 73 79 0B EA 4D 3B F1 72 0F 75 08 41 8B C0 49 3B C3 76 05 83 CD 04 EB 0D 49 8B CA 49 0F AF CE 45 8B F0 4C 03 F1 48 01 77 10 48 8B 47 10 4C 39 67 08 74 0C 48 3B 47 08 76 06 41 0F B7 DC EB 2A 48 8B 0F 48 8B 41 10 48 3B 41 08 74 ED 0F B7 10 48 83 C0 02 48 89 41 10 B8 FF FF 00 00 66 3B D0 74 13 0F B7 DA BA 08 00 00 00 41 B8 10 FF 00 00 E9 A9 FD FF FF BA 08 00 00 00 EB BE 48 FF 4F 10 48 8B 47 10 4C 8B AC 24 80 00 00 00 4C 39 67 08 74 06 48 3B 47 08 77 21 66 2B DE B8 FD FF 00 00 66 3B D8 77 14 48 8B 0F 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 40 84 EA 75 2F 4C 3B 6F 10 74 07 48 8B 47 18 44 88 20 44 38 A4 24 A0 00 00 00 0F 84 03 F8 FF FF 48 8B 84 24 88 00 00 00 83 A0 A8 03 00 00 FD E9 EF F7 FF FF 49 8B D6 8B CD E8 ?? ?? ?? ?? 84 C0 0F 84 8A 00 00 00 E8 ?? ?? ?? ?? C7 00 22 00 00 00 40 84 EE 75 06 49 83 CE FF EB 7D 40 F6 C5 02 74 37 44 38 A4 24 A0 00 00 00 74 0F 48 8B 84 24 88 00 00 00 83 A0 A8 03 00 00 FD 48 8B 47 18 48 85 C0 74 09 4C 39 67 10 75 03 44 88 20 48 B8 00 00 00 00 00 00 00 80 EB 6E 44 38 A4 24 A0 00 00 00 74 0F 48 8B 84 24 88 00 00 00 83 A0 A8 03 00 00 FD 48 8B 47 18 48 85 C0 74 09 4C 39 67 10 75 03 44 88 20 48 B8 FF FF FF FF FF FF FF 7F EB 37 40 F6 C5 02 74 03 49 F7 DE 44 38 A4 24 A0 00 00 00 74 0F 48 8B 8C 24 88 00 00 00 83 A1 A8 03 00 00 FD 48 8B 4F 18 48 85 C9 74 09 4C 39 67 10 75 03 44 88 21 49 8B C6 4C 8D 9C 24 B0 00 00 00 49 8B 5B 30 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_158_79_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 169
		refs = "0064 _getc_nolock"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 20 4D 8B F9 4D 8B E0 48 8B DA 48 8B E9 4D 85 C0 74 56 48 8B 7C 24 60 48 2B EA 4C 8B F2 49 F7 DE 41 8A 07 3A 04 2B 74 04 3A 03 75 5D 48 FF 47 10 48 83 7F 08 00 48 8B 47 10 74 06 48 3B 47 08 77 16 48 8B 37 48 8B 0E E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 46 08 EB 02 32 C0 48 FF C3 41 88 07 49 8D 04 1E 49 3B C4 75 B8 B0 01 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5C C3 32 C0 EB DD }
	condition:
		$1
}

rule file_158_80_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 134
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 4D 8B D9 49 8B F8 4C 8B D1 4D 85 C0 74 5D 4C 8B 4C 24 28 4C 2B D2 48 8B DA 48 F7 DB 41 8A 03 41 3A 04 12 74 04 3A 02 75 4F 49 FF 41 10 49 83 79 08 00 49 8B 41 10 74 06 49 3B 41 08 77 1C 4D 8B 01 49 8B 40 10 49 3B 40 08 74 0F 0F B6 08 48 FF C0 49 89 40 10 83 F9 FF 75 02 32 C9 48 FF C2 41 88 0B 48 8D 04 13 48 3B C7 75 B1 B0 01 48 8B 5C 24 08 48 8B 7C 24 10 C3 32 C0 EB F1 }
	condition:
		$1
}

rule file_158_81_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 181
		refs = "006b _getwc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 45 33 ED 4D 8B F9 4D 8B E0 48 8B DA 48 8B E9 41 8B F5 4D 85 C0 74 5F 48 8B 7C 24 70 48 2B EA 41 0F B7 07 66 3B 04 2B 74 05 66 3B 03 75 67 48 FF 47 10 48 8B 47 10 4C 39 6F 08 74 0C 48 3B 47 08 76 06 41 0F B7 C5 EB 1E 4C 8B 37 49 8B 0E E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 06 49 FF 46 08 EB 03 41 8B C5 48 FF C6 66 41 89 07 48 83 C3 02 49 3B F4 75 A9 B0 01 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 32 C0 EB DF }
	condition:
		$1
}

rule file_158_82_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 155
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 33 F6 49 8B D9 49 8B F8 4C 8B D9 44 8B D6 4D 85 C0 74 63 4C 8B 4C 24 28 4C 2B DA 0F B7 03 66 41 3B 04 13 74 05 66 3B 02 75 5E 49 FF 41 10 49 8B 41 10 49 39 71 08 74 0B 49 3B 41 08 76 05 0F B7 CE EB 24 4D 8B 01 49 8B 40 10 49 3B 40 08 74 15 0F B7 08 48 83 C0 02 49 89 40 10 B8 FF FF 00 00 66 3B C8 75 02 8B CE 49 FF C2 66 89 0B 48 83 C2 02 4C 3B D7 75 A5 B0 01 48 8B 5C 24 08 48 8B 74 24 10 48 8B 7C 24 18 C3 32 C0 EB EC }
	condition:
		$1
}

rule file_158_83_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 159
		refs = "002e ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAV?$stream_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z 003f ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAM@Z 006c _errno 0077 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 18 57 48 83 EC 40 4C 8B 41 38 48 8D 51 08 48 8B D9 4C 8D 48 08 0F 57 C0 48 8D 48 D8 33 FF F3 0F 11 40 10 40 88 78 08 E8 ?? ?? ?? ?? 48 8B 4B 70 4C 8D 44 24 58 48 8B D0 E8 ?? ?? ?? ?? 40 38 7C 24 50 74 48 83 F8 01 74 43 40 38 7B 32 74 04 B0 01 EB 3B 48 83 43 78 08 48 8B 43 78 48 8B 48 F8 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 10 48 FF 83 80 00 00 00 40 B7 01 8B 44 24 58 89 01 40 8A C7 EB 02 32 C0 48 8B 5C 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_84_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 165
		refs = "002e ??$make_input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAV?$string_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z 003f ??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAM@Z 0072 _errno 007d _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 18 57 48 83 EC 40 4C 8B 41 40 48 8D 51 08 48 8B D9 4C 8D 48 08 0F 57 C0 48 8D 48 D8 33 FF F3 0F 11 40 10 40 88 78 08 E8 ?? ?? ?? ?? 48 8B 4B 78 4C 8D 44 24 58 48 8B D0 E8 ?? ?? ?? ?? 40 38 7C 24 50 74 4E 83 F8 01 74 49 40 38 7B 3A 74 04 B0 01 EB 41 48 83 83 80 00 00 00 08 48 8B 83 80 00 00 00 48 8B 48 F8 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 10 48 FF 83 88 00 00 00 40 B7 01 8B 44 24 58 89 01 40 8A C7 EB 02 32 C0 48 8B 5C 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_85_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 156
		refs = "002e ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z 003f ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAM@Z 006c _errno 0077 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 18 57 48 83 EC 40 4C 8B 41 38 48 8D 51 08 48 8B D9 4C 8D 48 08 0F 57 C0 48 8D 48 D8 33 FF F3 0F 11 40 10 40 88 78 08 E8 ?? ?? ?? ?? 48 8B 4B 58 4C 8D 44 24 58 48 8B D0 E8 ?? ?? ?? ?? 40 38 7C 24 50 74 45 83 F8 01 74 40 40 38 7B 34 74 04 B0 01 EB 38 48 83 43 60 08 48 8B 43 60 48 8B 48 F8 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 0D 48 FF 43 68 40 B7 01 8B 44 24 58 89 01 40 8A C7 EB 02 32 C0 48 8B 5C 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_86_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 156
		refs = "002e ??$make_input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$string_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z 003f ??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAM@Z 006c _errno 0077 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 18 57 48 83 EC 40 4C 8B 41 40 48 8D 51 08 48 8B D9 4C 8D 48 08 0F 57 C0 48 8D 48 D8 33 FF F3 0F 11 40 10 40 88 78 08 E8 ?? ?? ?? ?? 48 8B 4B 60 4C 8D 44 24 58 48 8B D0 E8 ?? ?? ?? ?? 40 38 7C 24 50 74 45 83 F8 01 74 40 40 38 7B 3C 74 04 B0 01 EB 38 48 83 43 68 08 48 8B 43 68 48 8B 48 F8 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 0D 48 FF 43 70 40 B7 01 8B 44 24 58 89 01 40 8A C7 EB 02 32 C0 48 8B 5C 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_87_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 161
		refs = "002e ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAV?$stream_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z 003f ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAN@Z 006c _errno 0077 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 18 57 48 83 EC 40 4C 8B 41 38 48 8D 51 08 48 8B D9 4C 8D 48 08 0F 57 C0 48 8D 48 D8 33 FF F2 0F 11 40 10 40 88 78 08 E8 ?? ?? ?? ?? 48 8B 4B 70 4C 8D 44 24 58 48 8B D0 E8 ?? ?? ?? ?? 40 38 7C 24 50 74 4A 83 F8 01 74 45 40 38 7B 32 74 04 B0 01 EB 3D 48 83 43 78 08 48 8B 43 78 48 8B 48 F8 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 12 48 8B 44 24 58 40 B7 01 48 FF 83 80 00 00 00 48 89 01 40 8A C7 EB 02 32 C0 48 8B 5C 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_88_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 167
		refs = "002e ??$make_input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAV?$string_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z 003f ??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAN@Z 0072 _errno 007d _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 18 57 48 83 EC 40 4C 8B 41 40 48 8D 51 08 48 8B D9 4C 8D 48 08 0F 57 C0 48 8D 48 D8 33 FF F2 0F 11 40 10 40 88 78 08 E8 ?? ?? ?? ?? 48 8B 4B 78 4C 8D 44 24 58 48 8B D0 E8 ?? ?? ?? ?? 40 38 7C 24 50 74 50 83 F8 01 74 4B 40 38 7B 3A 74 04 B0 01 EB 43 48 83 83 80 00 00 00 08 48 8B 83 80 00 00 00 48 8B 48 F8 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 12 48 8B 44 24 58 40 B7 01 48 FF 83 88 00 00 00 48 89 01 40 8A C7 EB 02 32 C0 48 8B 5C 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_89_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 158
		refs = "002e ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z 003f ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAN@Z 006c _errno 0077 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 18 57 48 83 EC 40 4C 8B 41 38 48 8D 51 08 48 8B D9 4C 8D 48 08 0F 57 C0 48 8D 48 D8 33 FF F2 0F 11 40 10 40 88 78 08 E8 ?? ?? ?? ?? 48 8B 4B 58 4C 8D 44 24 58 48 8B D0 E8 ?? ?? ?? ?? 40 38 7C 24 50 74 47 83 F8 01 74 42 40 38 7B 34 74 04 B0 01 EB 3A 48 83 43 60 08 48 8B 43 60 48 8B 48 F8 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 0F 48 8B 44 24 58 40 B7 01 48 FF 43 68 48 89 01 40 8A C7 EB 02 32 C0 48 8B 5C 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_90_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 158
		refs = "002e ??$make_input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$string_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z 003f ??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAN@Z 006c _errno 0077 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 18 57 48 83 EC 40 4C 8B 41 40 48 8D 51 08 48 8B D9 4C 8D 48 08 0F 57 C0 48 8D 48 D8 33 FF F2 0F 11 40 10 40 88 78 08 E8 ?? ?? ?? ?? 48 8B 4B 60 4C 8D 44 24 58 48 8B D0 E8 ?? ?? ?? ?? 40 38 7C 24 50 74 47 83 F8 01 74 42 40 38 7B 3C 74 04 B0 01 EB 3A 48 83 43 68 08 48 8B 43 68 48 8B 48 F8 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 0F 48 8B 44 24 58 40 B7 01 48 FF 43 70 48 89 01 40 8A C7 EB 02 32 C0 48 8B 5C 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_91_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z"
		size = 432
		refs = "003d _errno 0048 _invalid_parameter_noinfo 0078 _getc_nolock 015a _ungetc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 33 F6 44 8B F2 48 8B D9 40 38 71 32 75 3B 48 83 41 78 08 48 8B 41 78 48 8B 70 F8 48 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 40 01 00 00 F6 01 01 74 0D 48 83 C0 08 48 89 41 78 8B 78 F8 EB 04 48 83 CF FF 48 85 FF 75 27 F6 01 04 74 15 48 8B 49 08 E8 ?? ?? ?? ?? 83 F8 FF 74 04 48 FF 43 10 C6 06 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B7 4C 8B 69 38 4C 8B E6 4C 8B FF 85 D2 74 0A 48 83 FF FF 74 04 4C 8D 7F FF 33 ED 4D 85 ED 74 09 49 3B ED 0F 84 A1 00 00 00 48 8B 4B 08 E8 ?? ?? ?? ?? 44 8B C0 83 F8 FF 74 7A 48 FF 43 10 41 8B CE 45 85 F6 74 42 83 E9 01 74 2E 83 F9 07 75 64 41 0F B6 C0 25 07 00 00 80 7D 07 FF C8 83 C8 F8 FF C0 8A C8 BA 01 00 00 00 41 0F B6 C0 48 C1 E8 03 D3 E2 84 54 18 4C EB 0D 41 8D 40 F7 83 F8 04 76 32 41 83 F8 20 74 2C 80 7B 32 00 75 0F 4D 85 FF 74 12 45 88 04 24 49 FF C4 49 FF CF 48 FF C5 E9 76 FF FF FF 48 83 FF FF 0F 84 45 FF FF FF E9 3D FF FF FF 41 83 F8 FF 74 10 48 FF 4B 10 41 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? 48 85 ED 0F 84 E5 FE FF FF 45 85 F6 75 0E 49 3B ED 74 09 F6 03 04 0F 84 D2 FE FF FF 80 7B 32 00 75 11 45 85 F6 74 05 41 C6 04 24 00 48 FF 83 80 00 00 00 B0 01 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_158_92_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z"
		size = 454
		refs = "0040 _errno 004b _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 45 33 DB 8B FA 4C 8B C1 44 38 59 3A 75 45 48 83 81 80 00 00 00 08 48 8B 81 80 00 00 00 4C 8B 58 F8 4D 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 55 01 00 00 F6 01 01 74 11 48 83 C0 08 48 89 81 80 00 00 00 44 8B 48 F8 EB 04 49 83 C9 FF 4D 85 C9 75 27 F6 01 04 74 15 48 8B 41 18 48 3B 41 10 74 07 48 FF C0 48 89 41 18 41 C6 03 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B3 48 8B 69 40 4D 8B F3 49 8B F1 85 D2 74 0A 49 83 F9 FF 74 04 49 8D 71 FF 33 DB 48 85 ED 74 09 48 3B DD 0F 84 B3 00 00 00 49 8B 40 18 49 3B 40 10 0F 84 84 00 00 00 44 0F B6 10 48 FF C0 49 89 40 18 41 83 FA FF 74 77 8B CF 85 FF 74 41 83 E9 01 74 2D 83 F9 07 75 67 41 8B C2 25 07 00 00 80 7D 07 FF C8 83 C8 F8 FF C0 8A C8 BA 01 00 00 00 49 8B C2 D3 E2 48 C1 E8 03 42 84 54 00 54 EB 0D 41 8D 42 F7 83 F8 04 76 36 41 83 FA 20 74 30 41 80 78 3A 00 75 0E 48 85 F6 74 11 45 88 16 49 FF C6 48 FF CE 48 FF C3 E9 6F FF FF FF 49 83 F9 FF 0F 84 3E FF FF FF E9 35 FF FF FF 41 83 CA FF 49 8B 40 18 49 3B 40 08 74 13 49 3B 40 10 75 06 41 83 FA FF 74 07 48 FF C8 49 89 40 18 48 85 DB 0F 84 CF FE FF FF 85 FF 75 0F 48 3B DD 74 0A 41 F6 00 04 0F 84 BC FE FF FF 41 80 78 3A 00 75 0F 85 FF 74 04 41 C6 06 00 49 FF 80 88 00 00 00 B0 01 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_158_93_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z"
		size = 499
		refs = "0035 _errno 0040 _invalid_parameter_noinfo 0070 _getwc_nolock 0112 ?test@?$scanset_buffer@_W@__crt_stdio_input@@QEBA_N_W@Z 0158 ?write_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEAD_KAEAPEADAEA_K_W@Z 019a _ungetwc_nolock"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 40 33 F6 44 8B E2 48 8B D9 40 38 71 34 75 3B 48 83 41 60 08 48 8B 41 60 48 8B 70 F8 48 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 90 01 00 00 F6 01 01 74 0D 48 83 C0 08 48 89 41 60 8B 78 F8 EB 04 48 83 CF FF 48 85 FF 75 2E F6 01 04 74 1C 48 8B 49 08 E8 ?? ?? ?? ?? 41 BD FF FF 00 00 66 41 3B C5 74 04 48 FF 43 10 C6 06 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B0 48 8B 41 38 48 8B EF 48 89 84 24 80 00 00 00 48 89 74 24 30 48 89 BC 24 98 00 00 00 85 D2 74 12 48 83 FF FF 74 0C 48 8D 6F FF 48 89 AC 24 98 00 00 00 45 33 FF 41 BD FF FF 00 00 48 85 C0 74 09 4C 3B F8 0F 84 C9 00 00 00 48 8B 4B 08 E8 ?? ?? ?? ?? 44 0F B7 F0 66 41 3B C5 0F 84 93 00 00 00 48 FF 43 10 41 8B CC 45 85 E4 74 2B 83 E9 01 74 15 83 F9 07 75 7D 48 8D 4B 50 0F B7 D0 E8 ?? ?? ?? ?? 84 C0 EB 0F 41 8D 46 F7 66 83 F8 04 76 63 66 41 83 FE 20 74 5C 80 7B 34 00 75 37 48 85 ED 74 42 48 8D 84 24 98 00 00 00 66 44 89 74 24 28 4C 8D 4C 24 30 48 89 44 24 20 4C 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 3E 48 8B AC 24 98 00 00 00 48 8B 84 24 80 00 00 00 49 FF C7 E9 57 FF FF FF 48 83 FF FF 0F 84 05 FF FF FF E9 FD FE FF FF 66 45 3B F5 74 11 48 FF 4B 10 41 0F B7 CE 48 8B 53 08 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 4D 85 FF 0F 84 95 FE FF FF 45 85 E4 75 0E 4C 3B F8 74 09 F6 03 04 0F 84 82 FE FF FF 80 7B 34 00 75 11 45 85 E4 74 08 48 8B 44 24 30 C6 00 00 48 FF 43 68 B0 01 48 8B 9C 24 88 00 00 00 48 83 C4 40 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_94_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z"
		size = 480
		refs = "0035 _errno 0040 _invalid_parameter_noinfo 0106 ?test@?$scanset_buffer@_W@__crt_stdio_input@@QEBA_N_W@Z 0149 ?write_character@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEAD_KAEAPEADAEA_K_W@Z"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 33 F6 44 8B E2 48 8B D9 40 38 71 3C 75 3B 48 83 41 68 08 48 8B 41 68 48 8B 70 F8 48 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 80 01 00 00 F6 01 01 74 0D 48 83 C0 08 48 89 41 68 8B 78 F8 EB 04 48 83 CF FF 48 85 FF 75 27 F6 01 04 74 15 48 8B 41 18 48 3B 41 10 74 08 48 83 C0 02 48 89 41 18 C6 06 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B7 4C 8B 69 40 4C 8B F7 48 89 B4 24 88 00 00 00 48 89 7C 24 70 85 D2 74 0F 48 83 FF FF 74 09 4C 8D 77 FF 4C 89 74 24 70 45 33 FF B9 FF FF 00 00 4D 85 ED 74 09 4D 3B FD 0F 84 C9 00 00 00 48 8B 43 18 48 3B 43 10 0F 84 95 00 00 00 0F B7 28 48 83 C0 02 48 89 43 18 66 3B E9 0F 84 8A 00 00 00 41 8B CC 45 85 E4 74 29 83 E9 01 74 15 83 F9 07 75 73 48 8D 4B 58 0F B7 D5 E8 ?? ?? ?? ?? 84 C0 EB 0D 8D 45 F7 66 83 F8 04 76 5A 66 83 FD 20 74 54 80 7B 3C 00 75 33 4D 85 F6 74 36 48 8D 44 24 70 66 89 6C 24 28 4C 8D 8C 24 88 00 00 00 48 89 44 24 20 4C 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 42 4C 8B 74 24 70 49 FF C7 E9 59 FF FF FF 48 83 FF FF 0F 84 18 FF FF FF E9 10 FF FF FF 8B E9 EB 05 B9 FF FF 00 00 48 8B 43 18 48 3B 43 08 74 13 48 3B 43 10 75 05 66 3B E9 74 08 48 83 C0 FE 48 89 43 18 4D 85 FF 0F 84 A8 FE FF FF 45 85 E4 75 0E 4D 3B FD 74 09 F6 03 04 0F 84 95 FE FF FF 80 7B 3C 00 75 14 45 85 E4 74 0B 48 8B 84 24 88 00 00 00 C6 00 00 48 FF 43 70 B0 01 48 8B 5C 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_95_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z"
		size = 488
		refs = "0039 _errno 0044 _invalid_parameter_noinfo 0074 _getc_nolock 015d ?write_character@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEFA_W_KAEAPEFA_WAEA_KD@Z 0193 _ungetc_nolock"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 33 ED 44 8B FA 48 8B D9 41 8B F5 44 38 69 32 75 3B 48 83 41 78 08 48 8B 41 78 48 8B 70 F8 48 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 84 01 00 00 F6 01 01 74 0D 48 83 C0 08 48 89 41 78 8B 78 F8 EB 04 48 83 CF FF 48 85 FF 75 28 F6 01 04 74 16 48 8B 49 08 E8 ?? ?? ?? ?? 83 F8 FF 74 04 48 FF 43 10 66 44 89 2E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B6 4C 8B 61 38 48 8B EF 48 89 B4 24 88 00 00 00 48 89 7C 24 70 85 D2 74 0F 48 83 FF FF 74 09 48 8D 6F FF 48 89 6C 24 70 4D 8B F5 4D 85 E4 74 09 4D 3B F4 0F 84 CD 00 00 00 48 8B 4B 08 E8 ?? ?? ?? ?? 44 8B C0 83 F8 FF 0F 84 A2 00 00 00 48 FF 43 10 41 8B CF 45 85 FF 74 46 83 E9 01 74 32 83 F9 07 0F 85 88 00 00 00 41 0F B6 C0 25 07 00 00 80 7D 07 FF C8 83 C8 F8 FF C0 8A C8 BA 01 00 00 00 41 0F B6 C0 48 C1 E8 03 D3 E2 84 54 18 4C EB 0D 41 8D 40 F7 83 F8 04 76 56 41 83 F8 20 74 50 44 38 6B 32 75 33 48 85 ED 74 36 44 88 44 24 28 48 8D 44 24 70 4C 8B C7 48 89 44 24 20 4C 8D 8C 24 88 00 00 00 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 32 48 8B 6C 24 70 49 FF C6 E9 4A FF FF FF 48 83 FF FF 0F 84 09 FF FF FF E9 00 FF FF FF 41 83 F8 FF 74 10 48 FF 4B 10 41 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? 4D 85 F6 0F 84 A8 FE FF FF 45 85 FF 75 0E 4D 3B F4 74 09 F6 03 04 0F 84 95 FE FF FF 44 38 6B 32 75 18 45 85 FF 74 0C 48 8B 84 24 88 00 00 00 66 44 89 28 48 FF 83 80 00 00 00 B0 01 48 8B 5C 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_96_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z"
		size = 510
		refs = "0041 _errno 004c _invalid_parameter_noinfo 0169 ?write_character@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEFA_W_KAEAPEFA_WAEA_KD@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 54 41 56 41 57 48 83 EC 30 45 33 E4 44 8B F2 48 8B D9 41 8B F4 44 38 61 3A 75 44 48 83 81 80 00 00 00 08 48 8B 81 80 00 00 00 48 8B 70 F8 48 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 90 01 00 00 F6 01 01 74 10 48 83 C0 08 48 89 81 80 00 00 00 8B 78 F8 EB 04 48 83 CF FF 48 85 FF 75 27 F6 01 04 74 15 48 8B 41 18 48 3B 41 10 74 07 48 FF C0 48 89 41 18 66 44 89 26 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B4 4C 8B 79 40 4C 8B CF 48 89 74 24 78 48 89 7C 24 60 85 D2 74 0F 48 83 FF FF 74 09 4C 8D 4F FF 4C 89 4C 24 60 49 8B EC 4D 85 FF 74 09 49 3B EF 0F 84 DD 00 00 00 48 8B 43 18 48 3B 43 10 0F 84 AE 00 00 00 44 0F B6 00 48 FF C0 48 89 43 18 41 83 F8 FF 0F 84 9D 00 00 00 41 8B CE 45 85 F6 74 44 83 E9 01 74 30 83 F9 07 0F 85 87 00 00 00 41 8B C0 25 07 00 00 80 7D 07 FF C8 83 C8 F8 FF C0 8A C8 BA 01 00 00 00 49 8B C0 D3 E2 48 C1 E8 03 84 54 18 54 EB 0D 41 8D 40 F7 83 F8 04 76 57 41 83 F8 20 74 51 44 38 63 3A 75 30 4D 85 C9 74 33 44 88 44 24 28 48 8D 44 24 60 4C 8B C7 48 89 44 24 20 4C 8D 4C 24 78 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 3D 4C 8B 4C 24 60 48 FF C5 E9 45 FF FF FF 48 83 FF FF 0F 84 07 FF FF FF E9 FE FE FF FF 41 83 C8 FF 48 8B 43 18 48 3B 43 08 74 13 48 3B 43 10 75 06 41 83 F8 FF 74 07 48 FF C8 48 89 43 18 48 85 ED 0F 84 99 FE FF FF 45 85 F6 75 0E 49 3B EF 74 09 F6 03 04 0F 84 86 FE FF FF 44 38 63 3A 75 15 45 85 F6 74 09 48 8B 44 24 78 66 44 89 20 48 FF 83 88 00 00 00 B0 01 48 8B 5C 24 68 48 8B 6C 24 70 48 83 C4 30 41 5F 41 5E 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_158_97_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z"
		size = 454
		refs = "0036 _errno 0041 _invalid_parameter_noinfo 0071 _getwc_nolock 0103 ?test@?$scanset_buffer@_W@__crt_stdio_input@@QEBA_N_W@Z 0172 _ungetwc_nolock"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 20 44 8B FA 48 8B D9 33 D2 8B F2 38 51 34 75 3B 48 83 41 60 08 48 8B 41 60 48 8B 70 F8 48 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 65 01 00 00 F6 01 01 74 0D 48 83 C0 08 48 89 41 60 8B 78 F8 EB 04 48 83 CF FF 48 85 FF 75 30 F6 01 04 74 1E 48 8B 49 08 E8 ?? ?? ?? ?? 41 BD FF FF 00 00 66 41 3B C5 74 04 48 FF 43 10 33 C0 66 89 06 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB AE 48 8B 49 38 48 8B C6 48 89 4C 24 78 4C 8B E7 48 89 44 24 60 45 85 FF 74 0A 48 83 FF FF 74 04 4C 8D 67 FF 4C 8B F2 41 BD FF FF 00 00 48 85 C9 74 09 4C 3B F1 0F 84 B1 00 00 00 48 8B 4B 08 E8 ?? ?? ?? ?? 33 D2 0F B7 E8 66 41 3B C5 74 7B 48 FF 43 10 41 8B CF 45 85 FF 74 2B 83 E9 01 74 17 83 F9 07 75 65 48 8D 4B 50 0F B7 D0 E8 ?? ?? ?? ?? 33 D2 84 C0 EB 0D 8D 45 F7 66 83 F8 04 76 4A 66 83 FD 20 74 44 38 53 34 75 1B 4D 85 E4 74 28 48 8B 44 24 60 66 89 28 48 83 C0 02 48 89 44 24 60 49 FF CC EB 05 48 8B 44 24 60 48 8B 4C 24 78 49 FF C6 E9 75 FF FF FF 48 83 FF FF 0F 84 32 FF FF FF 66 89 16 E9 2A FF FF FF 66 41 3B ED 74 12 48 8B 53 08 0F B7 CD 48 FF 4B 10 E8 ?? ?? ?? ?? 33 D2 48 8B 4C 24 78 48 8B 44 24 60 4D 85 F6 0F 84 BA FE FF FF 45 85 FF 75 0E 4C 3B F1 74 09 F6 03 04 0F 84 A7 FE FF FF 38 53 34 75 0C 45 85 FF 74 03 66 89 10 48 FF 43 68 B0 01 48 8B 5C 24 68 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_98_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z"
		size = 447
		refs = "003e _errno 0049 _invalid_parameter_noinfo 00fe ?test@?$scanset_buffer@_W@__crt_stdio_input@@QEBA_N_W@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 83 EC 20 44 8B FA 48 8B D9 33 D2 8B F2 38 51 3C 75 3B 48 83 41 68 08 48 8B 41 68 48 8B 70 F8 48 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 E9 4E 01 00 00 F6 01 01 74 0D 48 83 C0 08 48 89 41 68 8B 78 F8 EB 04 48 83 CF FF 48 85 FF 75 27 F6 01 04 74 15 48 8B 41 18 48 3B 41 10 74 08 48 83 C0 02 48 89 41 18 66 89 16 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B7 48 8B 41 40 4C 8B EE 48 89 44 24 50 4C 8B E7 45 85 FF 74 0A 48 83 FF FF 74 04 4C 8D 67 FF 4C 8B F2 B9 FF FF 00 00 48 85 C0 74 09 4C 3B F0 0F 84 A7 00 00 00 48 8B 43 18 48 3B 43 10 74 72 0F B7 28 48 83 C0 02 48 89 43 18 66 3B E9 74 6B 41 8B CF 45 85 FF 74 2B 83 E9 01 74 17 83 F9 07 75 54 48 8D 4B 58 0F B7 D5 E8 ?? ?? ?? ?? 33 D2 84 C0 EB 0D 8D 45 F7 66 83 F8 04 76 39 66 83 FD 20 74 33 38 53 3C 75 11 4D 85 E4 74 16 66 41 89 6D 00 49 83 C5 02 49 FF CC 48 8B 44 24 50 49 FF C6 EB 80 48 83 FF FF 0F 84 48 FF FF FF E9 40 FF FF FF 8B E9 EB 05 B9 FF FF 00 00 48 8B 43 18 48 3B 43 08 74 13 48 3B 43 10 75 05 66 3B E9 74 08 48 83 C0 FE 48 89 43 18 48 8B 44 24 50 4D 85 F6 0F 84 D3 FE FF FF 45 85 FF 75 0E 4C 3B F0 74 09 F6 03 04 0F 84 C0 FE FF FF 38 53 3C 75 0E 45 85 FF 74 05 66 41 89 55 00 48 FF 43 70 B0 01 48 8B 5C 24 58 48 8B 6C 24 60 48 8B 74 24 68 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_158_107_0 {
	meta:
		name = "??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$stream_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z"
		size = 130
		refs = "001e _getc_nolock 0049 _isctype_l 005c __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F2 48 8B F9 48 8B 0F E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 42 48 FF 47 08 0F B6 EB 48 85 F6 74 26 48 8B 06 83 78 08 01 7E 11 4C 8B C6 BA 08 00 00 00 8B CD E8 ?? ?? ?? ?? EB 18 48 8B 00 48 63 CD 0F B7 04 48 EB 09 E8 ?? ?? ?? ?? 0F B7 04 68 83 E0 08 85 C0 75 AF 48 8B 6C 24 38 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_108_0 {
	meta:
		name = "??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$stream_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z"
		size = 69
		refs = "0011 _getwc_nolock 002f iswctype"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 0F E8 ?? ?? ?? ?? 0F B7 D8 B8 FF FF 00 00 66 3B D8 74 15 48 FF 47 08 BA 08 00 00 00 0F B7 CB E8 ?? ?? ?? ?? 85 C0 75 D6 0F B7 C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_109_0 {
	meta:
		name = "??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$string_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z"
		size = 138
		refs = "004c _isctype_l 005f __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B F2 48 8B F9 48 8B 47 10 48 3B 47 08 74 4C 0F B6 18 48 FF C0 48 89 47 10 83 FB FF 74 40 48 85 F6 74 26 48 8B 06 83 78 08 01 7E 11 4C 8B C6 BA 08 00 00 00 8B CB E8 ?? ?? ?? ?? EB 18 48 8B 00 48 63 CB 0F B7 04 48 EB 09 E8 ?? ?? ?? ?? 0F B7 04 58 83 E0 08 85 C0 74 05 EB AA 83 CB FF 48 8B 6C 24 38 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_110_0 {
	meta:
		name = "??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$string_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z"
		size = 89
		refs = "003a iswctype"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 BE FF FF 00 00 48 8B 47 10 48 3B 47 08 74 23 0F B7 18 48 83 C0 02 48 89 47 10 66 3B DE 74 15 BA 08 00 00 00 0F B7 CB E8 ?? ?? ?? ?? 85 C0 74 04 EB D3 8B DE 48 8B 74 24 38 0F B7 C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_117_0 {
	meta:
		name = "??$write_floating_point@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NAEBM@Z"
		size = 61
		refs = "0017 _errno 0022 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 41 78 08 48 8B 41 78 4C 8B 40 F8 4D 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0E 48 FF 81 80 00 00 00 B0 01 8B 0A 41 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_118_0 {
	meta:
		name = "??$write_floating_point@M@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NAEBM@Z"
		size = 67
		refs = "001d _errno 0028 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 81 80 00 00 00 08 48 8B 81 80 00 00 00 4C 8B 40 F8 4D 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0E 48 FF 81 88 00 00 00 B0 01 8B 0A 41 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_119_0 {
	meta:
		name = "??$write_floating_point@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NAEBM@Z"
		size = 58
		refs = "0017 _errno 0022 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 41 60 08 48 8B 41 60 4C 8B 40 F8 4D 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0B 48 FF 41 68 B0 01 8B 0A 41 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_120_0 {
	meta:
		name = "??$write_floating_point@M@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NAEBM@Z"
		size = 58
		refs = "0017 _errno 0022 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 41 68 08 48 8B 41 68 4C 8B 40 F8 4D 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0B 48 FF 41 70 B0 01 8B 0A 41 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_121_0 {
	meta:
		name = "??$write_floating_point@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NAEBN@Z"
		size = 62
		refs = "0017 _errno 0022 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 41 78 08 48 8B 41 78 4C 8B 40 F8 4D 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0F 48 FF 81 80 00 00 00 B0 01 48 8B 0A 49 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_122_0 {
	meta:
		name = "??$write_floating_point@N@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NAEBN@Z"
		size = 68
		refs = "001d _errno 0028 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 81 80 00 00 00 08 48 8B 81 80 00 00 00 4C 8B 40 F8 4D 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0F 48 FF 81 88 00 00 00 B0 01 48 8B 0A 49 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_123_0 {
	meta:
		name = "??$write_floating_point@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NAEBN@Z"
		size = 59
		refs = "0017 _errno 0022 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 41 60 08 48 8B 41 60 4C 8B 40 F8 4D 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0C 48 FF 41 68 B0 01 48 8B 0A 49 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_124_0 {
	meta:
		name = "??$write_floating_point@N@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NAEBN@Z"
		size = 59
		refs = "0017 _errno 0022 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 83 41 68 08 48 8B 41 68 4C 8B 40 F8 4D 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 0C 48 FF 41 70 B0 01 48 8B 0A 49 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_144_0 {
	meta:
		name = "??0?$format_string_parser@D@__crt_stdio_input@@QEAA@_KQEBE@Z"
		size = 74
		refs = "001f memset"
	strings:
		$1 = { 40 53 48 83 EC 20 83 61 10 00 48 8B D9 48 89 11 33 D2 4C 89 41 08 48 83 C1 34 44 8D 42 20 E8 ?? ?? ?? ?? 83 63 14 00 48 8B C3 66 83 63 18 00 48 83 63 20 00 83 63 28 00 83 63 30 00 C6 43 1A 00 C6 43 2C 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_145_0 {
	meta:
		name = "??0?$format_string_parser@_W@__crt_stdio_input@@QEAA@_KQEB_W@Z"
		size = 40
	strings:
		$1 = { 33 C0 48 89 11 48 89 41 10 4C 89 41 08 48 89 41 38 89 41 18 88 41 1C 48 89 41 20 89 41 28 88 41 2C 89 41 30 48 8B C1 C3 }
	condition:
		$1
}

rule file_158_150_0 {
	meta:
		name = "??0?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QEAA@AEBV?$stream_input_adapter@D@1@_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 120
		refs = "002b memset"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 89 01 48 8B D9 0F 10 02 33 D2 F3 0F 7F 41 08 83 61 28 00 4C 89 41 18 44 8D 42 20 4C 89 49 20 48 83 C1 4C E8 ?? ?? ?? ?? 83 63 2C 00 66 83 63 30 00 48 83 63 38 00 83 63 40 00 83 63 48 00 48 8B 44 24 50 C6 43 32 00 C6 43 44 00 48 83 A3 80 00 00 00 00 48 83 A3 88 00 00 00 00 48 89 43 70 48 8B 44 24 58 48 89 43 78 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_151_0 {
	meta:
		name = "??0?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QEAA@AEBV?$string_input_adapter@D@1@_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 132
		refs = "0034 memset"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 89 01 48 8B D9 0F 10 02 0F 11 41 08 F2 0F 10 4A 10 33 D2 F2 0F 11 49 18 83 61 30 00 4C 89 41 20 4C 89 49 28 44 8D 42 20 48 83 C1 54 E8 ?? ?? ?? ?? 83 63 34 00 66 83 63 38 00 48 83 63 40 00 83 63 48 00 83 63 50 00 48 8B 44 24 50 C6 43 3A 00 C6 43 4C 00 48 83 A3 88 00 00 00 00 48 83 A3 90 00 00 00 00 48 89 43 78 48 8B 44 24 58 48 89 83 80 00 00 00 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_152_0 {
	meta:
		name = "??0?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QEAA@AEBV?$stream_input_adapter@_W@1@_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 78
	strings:
		$1 = { 48 8B 44 24 28 4C 89 01 0F 10 02 33 D2 F3 0F 7F 41 08 4C 89 41 18 4C 89 49 20 48 89 51 28 48 89 51 50 89 51 30 88 51 34 48 89 51 38 89 51 40 88 51 44 89 51 48 48 89 41 58 48 8B 44 24 30 48 89 41 60 48 8B C1 48 89 51 68 48 89 51 70 C3 }
	condition:
		$1
}

rule file_158_153_0 {
	meta:
		name = "??0?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QEAA@AEBV?$string_input_adapter@_W@1@_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 87
	strings:
		$1 = { 48 8B 44 24 28 4C 89 01 0F 10 02 0F 11 41 08 F2 0F 10 4A 10 33 D2 F2 0F 11 49 18 4C 89 41 20 4C 89 49 28 48 89 51 30 48 89 51 58 89 51 38 88 51 3C 48 89 51 40 89 51 48 88 51 4C 89 51 50 48 89 41 60 48 8B 44 24 30 48 89 41 68 48 8B C1 48 89 51 70 48 89 51 78 C3 }
	condition:
		$1
}

rule file_158_154_0 {
	meta:
		name = "??0?$scanset_buffer@E@__crt_stdio_input@@QEAA@XZ"
		size = 29
		refs = "0010 memset"
		altNames = "??0?$scanset_storage@$00@__crt_stdio_input@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 33 D2 48 8B D9 44 8D 42 20 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_160_0 {
	meta:
		name = "??0?$string_input_adapter@D@__crt_stdio_input@@QEAA@QEBD_K@Z"
		size = 19
	strings:
		$1 = { 4A 8D 04 02 48 89 11 48 89 41 08 48 8B C1 48 89 51 10 C3 }
	condition:
		$1
}

rule file_158_161_0 {
	meta:
		name = "??0?$string_input_adapter@_W@__crt_stdio_input@@QEAA@QEB_W_K@Z"
		size = 19
	strings:
		$1 = { 4A 8D 04 42 48 89 11 48 89 41 08 48 8B C1 48 89 51 10 C3 }
	condition:
		$1
}

rule file_158_169_0 {
	meta:
		name = "??1?$format_string_parser@_W@__crt_stdio_input@@QEAA@XZ"
		size = 29
		refs = "000e _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 38 E8 ?? ?? ?? ?? 48 83 63 38 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_170_0 {
	meta:
		name = "??1?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ"
		size = 20
		altNames = "??1?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ ??1?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ ??1?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ ??1?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ ??1?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ"
	strings:
		$1 = { 48 8B 41 18 48 85 C0 74 0A 48 83 79 10 00 75 03 C6 00 00 C3 }
	condition:
		$1
}

rule file_158_174_0 {
	meta:
		name = "??1?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QEAA@XZ"
		size = 29
		refs = "000e _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 50 E8 ?? ?? ?? ?? 48 83 63 50 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_175_0 {
	meta:
		name = "??1?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QEAA@XZ"
		size = 29
		refs = "000e _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 58 E8 ?? ?? ?? ?? 48 83 63 58 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_207_0 {
	meta:
		name = "?advance@?$format_string_parser@D@__crt_stdio_input@@QEAA_NXZ"
		size = 464
		refs = "0050 isspace 00c9 ?scan_optional_field_width@?$format_string_parser@D@__crt_stdio_input@@AEAA_NXZ 00d9 ?scan_optional_length_modifier@?$format_string_parser@D@__crt_stdio_input@@AEAAXXZ 00ff ?scan_conversion_specifier@?$format_string_parser@D@__crt_stdio_input@@AEAA_NXZ 011e ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA 0173 __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 8B D9 39 71 10 74 07 32 C0 E9 A0 01 00 00 48 8B 41 08 89 71 14 66 89 71 18 40 88 71 1A 48 89 71 20 89 71 28 40 88 71 2C 89 71 30 40 38 30 75 0A BF 01 00 00 00 89 79 14 EB CD 0F B6 08 E8 ?? ?? ?? ?? 85 C0 74 33 48 8B 43 08 C7 43 14 02 00 00 00 0F B6 08 E8 ?? ?? ?? ?? BF 01 00 00 00 EB 10 48 01 7B 08 48 8B 4B 08 0F B6 09 E8 ?? ?? ?? ?? 85 C0 75 EC E9 32 01 00 00 48 8B 4B 08 B2 25 38 11 0F 85 B6 00 00 00 48 8D 41 01 38 10 0F 84 AA 00 00 00 C7 43 14 04 00 00 00 BF 01 00 00 00 48 89 43 08 80 38 2A 75 0B 48 FF C0 40 88 7B 1A 48 89 43 08 48 8B CB E8 ?? ?? ?? ?? 84 C0 0F 84 44 FF FF FF 48 8B CB E8 ?? ?? ?? ?? 48 8B 4B 08 8A 01 3C 77 75 0A 48 8D 41 01 48 89 43 08 EB 06 2C 43 A8 EF 75 04 40 88 7B 2C 48 8B CB E8 ?? ?? ?? ?? 84 C0 0F 84 0E FF FF FF 48 63 43 30 48 8D 0C 40 48 63 43 28 48 8D 14 88 48 8D 05 ?? ?? ?? ?? 40 38 34 02 0F 85 91 00 00 00 48 C7 43 10 16 00 00 00 66 89 73 18 40 88 73 1A 48 89 73 20 89 73 28 40 88 73 2C 89 73 30 E9 CA FE FF FF C7 43 14 03 00 00 00 BF 01 00 00 00 8A 01 88 43 18 48 8B C6 38 11 0F 94 C0 48 03 C7 48 03 C1 48 89 43 08 E8 ?? ?? ?? ?? 0F B6 4B 18 BA 00 80 00 00 66 85 14 48 74 37 48 8B 43 08 8A 08 84 C9 75 23 48 C7 43 10 2A 00 00 00 40 8A FE 66 89 73 18 40 88 73 1A 48 89 73 20 89 73 28 40 88 73 2C 89 73 30 EB 0A 48 FF C0 88 4B 19 48 89 43 08 40 8A C7 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_208_0 {
	meta:
		name = "?advance@?$format_string_parser@_W@__crt_stdio_input@@QEAA_NXZ"
		size = 392
		refs = "004c iswctype 00b9 ?scan_optional_field_width@?$format_string_parser@_W@__crt_stdio_input@@AEAA_NXZ 00c9 ?scan_optional_length_modifier@?$format_string_parser@_W@__crt_stdio_input@@AEAAXXZ 010f ?scan_conversion_specifier@?$format_string_parser@_W@__crt_stdio_input@@AEAA_NXZ 012e ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 FF 48 8B D9 39 79 10 74 07 32 C0 E9 62 01 00 00 48 8B 41 08 48 89 79 14 40 88 79 1C 48 89 79 20 89 79 28 40 88 79 2C 89 79 30 66 39 38 75 09 C7 41 14 01 00 00 00 EB D1 0F B7 08 BA 08 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 28 C7 43 14 02 00 00 00 EB 05 48 83 43 08 02 48 8B 43 08 BA 08 00 00 00 0F B7 08 E8 ?? ?? ?? ?? 85 C0 75 E6 E9 FF 00 00 00 48 8B 4B 08 66 83 39 25 0F 85 D0 00 00 00 48 8D 41 02 66 83 38 25 0F 84 C2 00 00 00 C7 43 14 04 00 00 00 48 89 43 08 66 83 38 2A 75 0C 48 83 C0 02 C6 43 1C 01 48 89 43 08 48 8B CB E8 ?? ?? ?? ?? 84 C0 0F 84 4F FF FF FF 48 8B CB E8 ?? ?? ?? ?? 48 8B 4B 08 0F B7 01 66 83 F8 77 75 0A 48 8D 41 02 48 89 43 08 EB 23 66 83 E8 43 B9 EF FF 00 00 66 85 C1 74 0E 83 7B 28 0B 74 0F 8A 03 D0 E8 24 01 EB 03 40 8A C7 84 C0 74 04 C6 43 2C 01 48 8B CB E8 ?? ?? ?? ?? 84 C0 0F 84 F9 FE FF FF 48 63 43 30 48 8D 0C 40 48 63 43 28 48 8D 14 88 48 8D 05 ?? ?? ?? ?? 40 38 3C 02 75 43 48 C7 43 10 16 00 00 00 89 7B 18 40 88 7B 1C 48 89 7B 20 89 7B 28 40 88 7B 2C 89 7B 30 E9 BA FE FF FF C7 43 14 03 00 00 00 0F B7 01 66 89 43 18 66 83 39 25 40 0F 94 C7 48 FF C7 48 8D 04 79 48 89 43 08 B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_226_0 {
	meta:
		name = "?data@?$scanset_storage@$01@__crt_stdio_input@@QEBAPEAEXZ"
		size = 69
		refs = "001e _calloc_base 0029 _free_base"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 39 00 48 8B F9 75 24 BA 01 00 00 00 B9 00 20 00 00 E8 ?? ?? ?? ?? 48 8B 0F 48 8B D8 E8 ?? ?? ?? ?? 33 C9 48 89 1F E8 ?? ?? ?? ?? 48 8B 07 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_233_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ"
		size = 57
		refs = "0022 _getc_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 FF 41 10 48 83 79 08 00 48 8B 41 10 74 06 48 3B 41 08 77 16 48 8B 19 48 8B 0B E8 ?? ?? ?? ?? 83 F8 FF 74 06 48 FF 43 08 EB 02 32 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_234_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ"
		size = 73
		refs = "0027 _getwc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 FF 41 10 33 FF 48 8B 51 10 48 39 79 08 74 06 48 3B 51 08 77 1B 48 8B 19 48 8B 0B E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 06 48 FF 43 08 EB 03 0F B7 C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_235_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ"
		size = 52
	strings:
		$1 = { 48 FF 41 10 48 83 79 08 00 48 8B 41 10 74 06 48 3B 41 08 77 1C 48 8B 11 48 8B 4A 10 48 3B 4A 08 74 0F 0F B6 01 48 FF C1 48 89 4A 10 83 F8 FF 75 02 32 C0 C3 }
	condition:
		$1
}

rule file_158_236_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ"
		size = 62
	strings:
		$1 = { 48 FF 41 10 45 33 C0 48 8B 51 10 4C 39 41 08 74 06 48 3B 51 08 77 22 48 8B 11 48 8B 4A 10 48 3B 4A 08 74 15 0F B7 01 48 83 C1 02 48 89 4A 10 B9 FF FF 00 00 66 3B C1 75 04 41 0F B7 C0 C3 }
	condition:
		$1
}

rule file_158_237_0 {
	meta:
		name = "?get@?$stream_input_adapter@D@__crt_stdio_input@@QEAAHXZ"
		size = 32
		refs = "000d _getc_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 83 F8 FF 74 04 48 FF 43 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_238_0 {
	meta:
		name = "?get@?$stream_input_adapter@_W@__crt_stdio_input@@QEAAGXZ"
		size = 37
		refs = "000d _getwc_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 04 48 FF 43 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_239_0 {
	meta:
		name = "?get@?$string_input_adapter@D@__crt_stdio_input@@QEAAHXZ"
		size = 28
	strings:
		$1 = { 48 8B D1 48 8B 49 10 48 3B 4A 08 75 04 83 C8 FF C3 0F B6 01 48 FF C1 48 89 4A 10 C3 }
	condition:
		$1
}

rule file_158_240_0 {
	meta:
		name = "?get@?$string_input_adapter@_W@__crt_stdio_input@@QEAAGXZ"
		size = 31
	strings:
		$1 = { 48 8B D1 48 8B 49 10 48 3B 4A 08 75 06 B8 FF FF 00 00 C3 0F B7 01 48 83 C1 02 48 89 4A 10 C3 }
	condition:
		$1
}

rule file_158_242_0 {
	meta:
		name = "?invert@?$scanset_buffer@E@__crt_stdio_input@@QEAAXXZ"
		size = 45
	strings:
		$1 = { 33 D2 48 8D 41 20 4C 8B C0 4C 2B C1 48 3B C8 4C 0F 47 C2 4D 85 C0 74 14 48 8B D1 48 F7 DA F6 11 48 FF C1 48 8D 04 0A 49 3B C0 75 F2 C3 }
	condition:
		$1
}

rule file_158_243_0 {
	meta:
		name = "?invert@?$scanset_buffer@_W@__crt_stdio_input@@QEAAXXZ"
		size = 123
		refs = "0022 _calloc_base 002d _free_base"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 8B F9 48 39 31 75 22 8D 56 01 B9 00 20 00 00 E8 ?? ?? ?? ?? 48 8B 0F 48 8B D8 E8 ?? ?? ?? ?? 33 C9 48 89 1F E8 ?? ?? ?? ?? 48 8B 0F 48 8D 81 00 20 00 00 4C 8B C0 4C 2B C1 48 3B C8 4C 0F 47 C6 4D 85 C0 74 14 48 8B D1 48 F7 DA F6 11 48 FF C1 48 8D 04 0A 49 3B C0 75 F2 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_244_0 {
	meta:
		name = "?is_character_allowed_in_string@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEBA_NW4conversion_mode@2@H@Z"
		size = 91
	strings:
		$1 = { 4C 8B C9 41 83 F8 FF 75 03 32 C0 C3 85 D2 74 45 83 EA 01 74 2F 83 FA 07 75 EF 41 0F B6 C0 BA 01 00 00 00 25 07 00 00 80 7D 07 2B C2 83 C8 F8 03 C2 8A C8 41 0F B6 C0 48 C1 E8 03 D2 E2 42 84 54 08 4C EB 0D 41 8D 40 F7 83 F8 04 76 BC 41 83 F8 20 0F 95 C0 C3 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_158_245_0 {
	meta:
		name = "?is_character_allowed_in_string@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEBA_NW4conversion_mode@2@H@Z"
		size = 91
	strings:
		$1 = { 4C 8B C9 41 83 F8 FF 75 03 32 C0 C3 85 D2 74 45 83 EA 01 74 2F 83 FA 07 75 EF 41 0F B6 C0 BA 01 00 00 00 25 07 00 00 80 7D 07 2B C2 83 C8 F8 03 C2 8A C8 41 0F B6 C0 48 C1 E8 03 D2 E2 42 84 54 08 54 EB 0D 41 8D 40 F7 83 F8 04 76 BC 41 83 F8 20 0F 95 C0 C3 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_158_246_0 {
	meta:
		name = "?is_character_allowed_in_string@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEBA_NW4conversion_mode@2@G@Z"
		size = 77
		refs = "002a ?test@?$scanset_buffer@_W@__crt_stdio_input@@QEBA_N_W@Z"
	strings:
		$1 = { 48 83 EC 28 B8 FF FF 00 00 66 44 3B C0 75 04 32 C0 EB 35 85 D2 74 2F 83 EA 01 74 16 83 FA 07 75 EE 48 83 C1 50 41 0F B7 D0 E8 ?? ?? ?? ?? 84 C0 EB 0F 41 8D 40 F7 66 83 F8 04 76 D3 66 41 83 F8 20 0F 95 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_247_0 {
	meta:
		name = "?is_character_allowed_in_string@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEBA_NW4conversion_mode@2@G@Z"
		size = 77
		refs = "002a ?test@?$scanset_buffer@_W@__crt_stdio_input@@QEBA_N_W@Z"
	strings:
		$1 = { 48 83 EC 28 B8 FF FF 00 00 66 44 3B C0 75 04 32 C0 EB 35 85 D2 74 2F 83 EA 01 74 16 83 FA 07 75 EE 48 83 C1 58 41 0F B7 D0 E8 ?? ?? ?? ?? 84 C0 EB 0F 41 8D 40 F7 66 83 F8 04 76 D3 66 41 83 F8 20 0F 95 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_250_0 {
	meta:
		name = "?is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@1@W4length_modifier@1@@Z"
		size = 30
		refs = "0013 ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA"
	strings:
		$1 = { 48 63 C1 48 8D 0C 40 48 63 C2 48 8D 14 88 33 C0 48 8D 0D ?? ?? ?? ?? 38 04 0A 0F 95 C0 C3 }
	condition:
		$1
}

rule file_158_255_0 {
	meta:
		name = "?is_usable@?$scanset_buffer@_W@__crt_stdio_input@@QEAA_NXZ"
		size = 81
		refs = "0022 _calloc_base 002d _free_base"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 FF 48 8B F1 48 39 39 75 22 8D 57 01 B9 00 20 00 00 E8 ?? ?? ?? ?? 48 8B 0E 48 8B D8 E8 ?? ?? ?? ?? 33 C9 48 89 1E E8 ?? ?? ?? ?? 48 39 3E 48 8B 5C 24 30 48 8B 74 24 38 0F 95 C0 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_259_0 {
	meta:
		name = "?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ"
		size = 153
		altNames = "?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ"
	strings:
		$1 = { 8B 41 30 45 33 C0 85 C0 78 1C 83 F8 01 7E 7B 41 8D 50 08 83 F8 06 7E 25 83 F8 07 74 0C 3B C2 74 69 83 F8 09 74 17 33 C0 C3 8B 41 28 85 C0 74 51 83 F8 03 74 51 3B C2 49 0F 45 D0 EB 49 8B 49 28 83 F9 05 7F 2D 74 3F 85 C9 74 36 83 E9 01 74 1B 83 E9 01 74 0F 83 E9 01 74 27 83 F9 01 74 27 49 8B D0 EB 22 BA 02 00 00 00 EB 1B BA 01 00 00 00 EB 14 83 E9 06 74 0F 83 E9 01 74 0A 83 E9 02 EB D7 BA 04 00 00 00 48 8B C2 C3 8A 41 2C F6 D8 48 1B C0 48 F7 D8 48 FF C0 C3 }
	condition:
		$1
}

rule file_158_280_0 {
	meta:
		name = "?process@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QEAAHXZ"
		size = 220
		refs = "001c _errno 0027 _invalid_parameter_noinfo 002e ?validate_stream_is_ansi_if_required@?$__acrt_stdio_char_traits@D@@SA_NQEAU_iobuf@@@Z 005b ?process_state@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0068 ?advance@?$format_string_parser@D@__crt_stdio_input@@QEAA_NXZ 0085 _getc_nolock 00a8 _ungetc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B D9 48 8B 49 08 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 09 E8 ?? ?? ?? ?? 84 C0 75 09 48 83 C8 FF E9 8D 00 00 00 48 83 7B 20 00 75 1D E8 ?? ?? ?? ?? 48 83 CF FF C7 00 16 00 00 00 EB 6A 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 0D 48 8D 4B 18 E8 ?? ?? ?? ?? 84 C0 75 E7 48 83 BB 88 00 00 00 00 8B B3 80 00 00 00 75 2C 48 8B 4B 08 E8 ?? ?? ?? ?? 48 83 CF FF 3B C7 74 06 48 FF 43 10 EB 02 8B F7 3B C7 74 0F 48 01 7B 10 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? F6 03 01 74 19 8B 5B 28 85 DB 74 12 E8 ?? ?? ?? ?? 8B FE 89 18 E8 ?? ?? ?? ?? 8B C7 EB 02 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_281_0 {
	meta:
		name = "?process@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QEAAHXZ"
		size = 238
		refs = "0022 _errno 002d _invalid_parameter_noinfo 005d ?process_state@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 006a ?advance@?$format_string_parser@D@__crt_stdio_input@@QEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 41 18 48 8B D9 48 85 C0 74 06 48 3B 41 10 76 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 A5 00 00 00 48 83 79 28 00 75 13 E8 ?? ?? ?? ?? 83 CF FF C7 00 16 00 00 00 E9 80 00 00 00 48 83 C1 20 EB 10 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 0D 48 8D 4B 20 E8 ?? ?? ?? ?? 84 C0 75 E7 48 83 BB 90 00 00 00 00 8B B3 88 00 00 00 75 3C 48 8B 43 18 83 CF FF 48 3B 43 10 75 04 8B CF EB 0E 0F B6 08 48 FF C0 48 89 43 18 3B CF 75 02 8B F7 48 8B 43 18 48 3B 43 08 74 11 48 3B 43 10 75 04 3B CF 74 07 48 FF C8 48 89 43 18 F6 03 01 74 19 8B 5B 30 85 DB 74 12 E8 ?? ?? ?? ?? 8B FE 89 18 E8 ?? ?? ?? ?? 8B C7 EB 02 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_282_0 {
	meta:
		name = "?process@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QEAAHXZ"
		size = 215
		refs = "001a _errno 0025 _invalid_parameter_noinfo 0054 ?process_state@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0061 ?advance@?$format_string_parser@_W@__crt_stdio_input@@QEAA_NXZ 0078 _getwc_nolock 00a3 _ungetwc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 83 79 08 00 48 8B D9 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF E9 95 00 00 00 48 83 79 20 00 75 11 E8 ?? ?? ?? ?? 48 83 CF FF C7 00 16 00 00 00 EB 72 48 83 C1 18 EB 10 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 0D 48 8D 4B 18 E8 ?? ?? ?? ?? 84 C0 75 E7 48 83 7B 70 00 8B 73 68 75 34 48 8B 4B 08 E8 ?? ?? ?? ?? B9 FF FF 00 00 48 83 CF FF 66 3B C1 74 06 48 FF 43 10 EB 02 8B F7 66 3B C1 74 10 48 01 7B 10 0F B7 C8 48 8B 53 08 E8 ?? ?? ?? ?? F6 03 01 74 19 8B 5B 28 85 DB 74 12 E8 ?? ?? ?? ?? 8B FE 89 18 E8 ?? ?? ?? ?? 8B C7 EB 02 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_283_0 {
	meta:
		name = "?process@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QEAAHXZ"
		size = 229
		refs = "001d _errno 0028 _invalid_parameter_noinfo 0058 ?process_state@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0065 ?advance@?$format_string_parser@_W@__crt_stdio_input@@QEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 41 18 48 8B D9 48 85 C0 74 06 48 3B 41 10 76 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 A6 00 00 00 48 83 79 28 00 75 13 E8 ?? ?? ?? ?? 83 CF FF C7 00 16 00 00 00 E9 85 00 00 00 48 83 C1 20 EB 10 48 8B CB E8 ?? ?? ?? ?? 84 C0 74 0D 48 8D 4B 20 E8 ?? ?? ?? ?? 84 C0 75 E7 48 83 7B 78 00 8B 7B 70 75 49 48 8B 43 18 48 3B 43 10 75 0A B8 FF FF 00 00 0F B7 D0 EB 15 0F B7 10 48 83 C0 02 48 89 43 18 B8 FF FF 00 00 66 3B D0 75 03 83 CF FF 48 8B 4B 18 48 3B 4B 08 74 13 48 3B 4B 10 75 05 66 3B D0 74 08 48 8D 41 FE 48 89 43 18 F6 03 01 74 13 8B 5B 30 85 DB 74 0C E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_284_0 {
	meta:
		name = "?process_character_count_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 21
		refs = "0011 ?write_integer@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
	strings:
		$1 = { 80 79 32 00 74 03 B0 01 C3 48 8B 51 10 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_285_0 {
	meta:
		name = "?process_character_count_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 25
		refs = "0015 ?write_integer@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
	strings:
		$1 = { 80 79 3A 00 74 03 B0 01 C3 48 8B 51 18 45 33 C0 48 2B 51 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_286_0 {
	meta:
		name = "?process_character_count_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 21
		refs = "0011 ?write_integer@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
	strings:
		$1 = { 80 79 34 00 74 03 B0 01 C3 48 8B 51 10 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_287_0 {
	meta:
		name = "?process_character_count_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 28
		refs = "0018 ?write_integer@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
	strings:
		$1 = { 80 79 3C 00 74 03 B0 01 C3 48 8B 51 18 45 33 C0 48 2B 51 08 48 D1 FA E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_288_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 285
		refs = "0057 ?process_string_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@2@@Z 0065 ?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ 007e ??$process_string_specifier_tchar@_W@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z 008d ??$process_string_specifier_tchar@D@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z 00cd ?write_integer@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z 00ff ?process_floating_point_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 010e ?process_integer_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NI_N@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 51 48 48 8B D9 83 FA 05 0F 8F 87 00 00 00 74 7E 33 FF 85 D2 74 3F 83 EA 01 74 2B 83 EA 01 74 22 83 EA 01 74 0D 83 FA 01 75 7F 8D 57 08 E9 CD 00 00 00 BA 0A 00 00 00 41 B8 01 00 00 00 E9 C0 00 00 00 33 D2 EB F1 BA 01 00 00 00 E8 ?? ?? ?? ?? E9 B2 00 00 00 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 E8 01 74 15 48 83 E8 01 75 1F 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? EB 0D 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? 40 8A F8 40 8A C7 EB 79 BA 0A 00 00 00 EB 6A 83 EA 06 74 60 83 EA 01 74 54 83 EA 01 74 24 83 FA 01 74 04 32 C0 EB 5A 33 FF 40 38 79 32 74 05 8D 47 01 EB 4D 48 8B 51 10 45 33 C0 E8 ?? ?? ?? ?? EB 3F 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 E8 01 74 13 48 83 E8 01 74 04 33 FF EB A8 45 33 C0 41 8D 50 08 EB 85 45 33 C0 41 8D 50 08 EB 8B E8 ?? ?? ?? ?? EB 0D BA 10 00 00 00 45 33 C0 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_289_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 289
		refs = "0057 ?process_string_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@2@@Z 0065 ?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ 007e ??$process_string_specifier_tchar@_W@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z 008d ??$process_string_specifier_tchar@D@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z 00d1 ?write_integer@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z 0103 ?process_floating_point_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0112 ?process_integer_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NI_N@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 51 50 48 8B D9 83 FA 05 0F 8F 87 00 00 00 74 7E 33 FF 85 D2 74 3F 83 EA 01 74 2B 83 EA 01 74 22 83 EA 01 74 0D 83 FA 01 75 7F 8D 57 08 E9 D1 00 00 00 BA 0A 00 00 00 41 B8 01 00 00 00 E9 C4 00 00 00 33 D2 EB F1 BA 01 00 00 00 E8 ?? ?? ?? ?? E9 B6 00 00 00 48 83 C1 20 E8 ?? ?? ?? ?? 48 83 E8 01 74 15 48 83 E8 01 75 1F 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? EB 0D 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? 40 8A F8 40 8A C7 EB 7D BA 0A 00 00 00 EB 6E 83 EA 06 74 64 83 EA 01 74 58 83 EA 01 74 28 83 FA 01 74 04 32 C0 EB 5E 33 FF 40 38 79 3A 74 05 8D 47 01 EB 51 48 8B 51 18 45 33 C0 48 2B 51 08 E8 ?? ?? ?? ?? EB 3F 48 83 C1 20 E8 ?? ?? ?? ?? 48 83 E8 01 74 13 48 83 E8 01 74 04 33 FF EB A4 45 33 C0 41 8D 50 08 EB 81 45 33 C0 41 8D 50 08 EB 87 E8 ?? ?? ?? ?? EB 0D BA 10 00 00 00 45 33 C0 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_290_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 285
		refs = "0057 ?process_string_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@2@@Z 0065 ?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ 007e ??$process_string_specifier_tchar@_W@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z 008d ??$process_string_specifier_tchar@D@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z 00cd ?write_integer@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z 00ff ?process_floating_point_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 010e ?process_integer_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NI_N@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 51 48 48 8B D9 83 FA 05 0F 8F 87 00 00 00 74 7E 33 FF 85 D2 74 3F 83 EA 01 74 2B 83 EA 01 74 22 83 EA 01 74 0D 83 FA 01 75 7F 8D 57 08 E9 CD 00 00 00 BA 0A 00 00 00 41 B8 01 00 00 00 E9 C0 00 00 00 33 D2 EB F1 BA 01 00 00 00 E8 ?? ?? ?? ?? E9 B2 00 00 00 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 E8 01 74 15 48 83 E8 01 75 1F 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? EB 0D 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? 40 8A F8 40 8A C7 EB 79 BA 0A 00 00 00 EB 6A 83 EA 06 74 60 83 EA 01 74 54 83 EA 01 74 24 83 FA 01 74 04 32 C0 EB 5A 33 FF 40 38 79 34 74 05 8D 47 01 EB 4D 48 8B 51 10 45 33 C0 E8 ?? ?? ?? ?? EB 3F 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 E8 01 74 13 48 83 E8 01 74 04 33 FF EB A8 45 33 C0 41 8D 50 08 EB 85 45 33 C0 41 8D 50 08 EB 8B E8 ?? ?? ?? ?? EB 0D BA 10 00 00 00 45 33 C0 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_291_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 309
		refs = "005f ?process_string_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@2@@Z 006d ?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ 0086 ??$process_string_specifier_tchar@_W@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z 0095 ??$process_string_specifier_tchar@D@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z 00df ?write_integer@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z 0117 ?process_floating_point_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0126 ?process_integer_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NI_N@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 51 50 48 8B D9 83 FA 05 0F 8F 92 00 00 00 0F 84 85 00 00 00 33 FF 85 D2 74 43 83 EA 01 74 2F 83 EA 01 74 26 83 EA 01 74 11 83 FA 01 0F 85 82 00 00 00 8D 57 08 E9 DD 00 00 00 BA 0A 00 00 00 41 B8 01 00 00 00 E9 D0 00 00 00 33 D2 EB F1 BA 01 00 00 00 E8 ?? ?? ?? ?? E9 C2 00 00 00 48 83 C1 20 E8 ?? ?? ?? ?? 48 83 E8 01 74 15 48 83 E8 01 75 1F 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? EB 0D 45 33 C0 33 D2 48 8B CB E8 ?? ?? ?? ?? 40 8A F8 40 8A C7 E9 86 00 00 00 BA 0A 00 00 00 EB 77 83 EA 06 74 6D 83 EA 01 74 61 83 EA 01 74 2B 83 FA 01 74 04 32 C0 EB 67 33 FF 40 38 79 3C 74 05 8D 47 01 EB 5A 48 8B 51 18 45 33 C0 48 2B 51 08 48 D1 FA E8 ?? ?? ?? ?? EB 45 48 83 C1 20 E8 ?? ?? ?? ?? 48 83 E8 01 74 16 48 83 E8 01 74 04 33 FF EB 9E 45 33 C0 41 8D 50 08 E9 78 FF FF FF 45 33 C0 41 8D 50 08 E9 7B FF FF FF E8 ?? ?? ?? ?? EB 0D BA 10 00 00 00 45 33 C0 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_292_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 100
		refs = "0016 ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$stream_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z 002a _ungetc_nolock 0033 ?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ 004b ??$process_floating_point_specifier_t@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0055 ??$process_floating_point_specifier_t@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 51 70 48 8B D9 48 83 C1 08 E8 ?? ?? ?? ?? 83 F8 FF 74 0F 48 FF 4B 10 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? 48 8D 4B 18 E8 ?? ?? ?? ?? 48 83 F8 04 74 14 48 83 F8 08 74 04 32 C0 EB 12 48 8B CB E8 ?? ?? ?? ?? EB 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_293_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 110
		refs = "0016 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$string_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z 003d ?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ 0055 ??$process_floating_point_specifier_t@N@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 005f ??$process_floating_point_specifier_t@M@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 51 78 48 8B D9 48 83 C1 08 E8 ?? ?? ?? ?? 8B C8 48 8B 43 18 48 3B 43 08 74 12 48 3B 43 10 75 05 83 F9 FF 74 07 48 FF C8 48 89 43 18 48 8D 4B 20 E8 ?? ?? ?? ?? 48 83 F8 04 74 14 48 83 F8 08 74 04 32 C0 EB 12 48 8B CB E8 ?? ?? ?? ?? EB 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_294_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 106
		refs = "0016 ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$stream_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z 0030 _ungetwc_nolock 0039 ?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ 0051 ??$process_floating_point_specifier_t@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 005b ??$process_floating_point_specifier_t@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 51 58 48 8B D9 48 83 C1 08 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 10 48 FF 4B 10 0F B7 C8 48 8B 53 08 E8 ?? ?? ?? ?? 48 8D 4B 18 E8 ?? ?? ?? ?? 48 83 F8 04 74 14 48 83 F8 08 74 04 32 C0 EB 12 48 8B CB E8 ?? ?? ?? ?? EB 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_295_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 117
		refs = "0016 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$string_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z 0044 ?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ 005c ??$process_floating_point_specifier_t@N@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0066 ??$process_floating_point_specifier_t@M@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 51 60 48 8B D9 48 83 C1 08 E8 ?? ?? ?? ?? 0F B7 C8 48 8B 43 18 48 3B 43 08 74 18 48 3B 43 10 75 0A BA FF FF 00 00 66 3B CA 74 08 48 83 C0 FE 48 89 43 18 48 8D 4B 20 E8 ?? ?? ?? ?? 48 83 F8 04 74 14 48 83 F8 08 74 04 32 C0 EB 12 48 8B CB E8 ?? ?? ?? ?? EB 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_296_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NI_N@Z"
		size = 164
		refs = "0028 ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$stream_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z 003b _ungetc_nolock 0056 ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAV?$stream_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z 0068 ??$parse_integer@_KV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@H_N@Z 008b ?write_integer@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 40 8B EA 48 8D 79 08 48 8B 51 70 48 8B D9 48 8B CF 41 8A F0 E8 ?? ?? ?? ?? 83 F8 FF 74 0E 48 FF 4F 08 8B C8 48 8B 17 E8 ?? ?? ?? ?? 4C 8B 43 38 4C 8D 4C 24 50 48 8B D7 C6 44 24 50 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4B 70 48 8B D0 44 8A CE 44 8B C5 E8 ?? ?? ?? ?? 80 7C 24 50 00 75 04 32 C0 EB 18 80 7B 32 00 74 04 B0 01 EB 0E 41 B0 01 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 8B 6C 24 60 48 8B 74 24 68 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_297_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NI_N@Z"
		size = 174
		refs = "0028 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$string_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z 0060 ??$make_input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAV?$string_input_adapter@D@__crt_stdio_input@@_KQEA_N@Z 0072 ??$parse_integer@_KV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@H_N@Z 0095 ?write_integer@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 40 8B EA 48 8D 79 08 48 8B 51 78 48 8B D9 48 8B CF 41 8A F0 E8 ?? ?? ?? ?? 8B C8 48 8B 47 10 48 3B 07 74 12 48 3B 47 08 75 05 83 F9 FF 74 07 48 FF C8 48 89 47 10 4C 8B 43 40 4C 8D 4C 24 50 48 8B D7 C6 44 24 50 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4B 78 48 8B D0 44 8A CE 44 8B C5 E8 ?? ?? ?? ?? 80 7C 24 50 00 75 04 32 C0 EB 18 80 7B 3A 00 74 04 B0 01 EB 0E 41 B0 01 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 8B 6C 24 60 48 8B 74 24 68 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_298_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NI_N@Z"
		size = 170
		refs = "0028 ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$stream_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z 0041 _ungetwc_nolock 005c ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z 006e ??$parse_integer@_KV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z 0091 ?write_integer@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 40 8B EA 48 8D 79 08 48 8B 51 58 48 8B D9 48 8B CF 41 8A F0 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 0F 48 FF 4F 08 0F B7 C8 48 8B 17 E8 ?? ?? ?? ?? 4C 8B 43 38 4C 8D 4C 24 50 48 8B D7 C6 44 24 50 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4B 58 48 8B D0 44 8A CE 44 8B C5 E8 ?? ?? ?? ?? 80 7C 24 50 00 75 04 32 C0 EB 18 80 7B 34 00 74 04 B0 01 EB 0E 41 B0 01 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 8B 6C 24 60 48 8B 74 24 68 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_299_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NI_N@Z"
		size = 181
		refs = "0028 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$string_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z 0067 ??$make_input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAV?$string_input_adapter@_W@__crt_stdio_input@@_KQEA_N@Z 0079 ??$parse_integer@_KV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z 009c ?write_integer@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 40 8B EA 48 8D 79 08 48 8B 51 60 48 8B D9 48 8B CF 41 8A F0 E8 ?? ?? ?? ?? 0F B7 C8 48 8B 47 10 48 3B 07 74 18 48 3B 47 08 75 0A BA FF FF 00 00 66 3B CA 74 08 48 83 C0 FE 48 89 47 10 4C 8B 43 40 4C 8D 4C 24 50 48 8B D7 C6 44 24 50 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4B 60 48 8B D0 44 8A CE 44 8B C5 E8 ?? ?? ?? ?? 80 7C 24 50 00 75 04 32 C0 EB 18 80 7B 3C 00 74 04 B0 01 EB 0E 41 B0 01 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 8B 6C 24 60 48 8B 74 24 68 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_158_300_0 {
	meta:
		name = "?process_literal_character@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 73
		refs = "000e _getc_nolock 002e _ungetc_nolock 0045 ?process_literal_character_tchar@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_ND@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 08 E8 ?? ?? ?? ?? 83 F8 FF 74 1B 48 FF 43 10 0F B6 53 30 3B C2 74 17 48 FF 4B 10 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? 32 C0 48 83 C4 20 5B C3 8A D0 48 8B CB 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_301_0 {
	meta:
		name = "?process_literal_character@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 58
		refs = "0036 ?process_literal_character_tchar@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_ND@Z"
	strings:
		$1 = { 48 8B 41 18 48 3B 41 10 74 28 0F B6 10 48 FF C0 48 89 41 18 83 FA FF 74 19 0F B6 41 38 3B D0 74 14 48 8B 41 18 48 3B 41 08 74 07 48 FF C8 48 89 41 18 32 C0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_302_0 {
	meta:
		name = "?process_literal_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 66
		refs = "000e _getwc_nolock 0032 _ungetwc_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 08 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 1A 48 FF 43 10 66 3B 43 30 74 18 48 FF 4B 10 0F B7 C8 48 8B 53 08 E8 ?? ?? ?? ?? 32 C0 48 83 C4 20 5B C3 B0 01 EB F6 }
	condition:
		$1
}

rule file_158_303_0 {
	meta:
		name = "?process_literal_character@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 61
	strings:
		$1 = { 48 8B 41 18 48 3B 41 10 74 2D 0F B7 10 48 83 C0 02 48 89 41 18 B8 FF FF 00 00 66 3B D0 74 18 66 3B 51 38 74 15 48 8B 41 18 48 3B 41 08 74 08 48 83 C0 FE 48 89 41 18 32 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule file_158_304_0 {
	meta:
		name = "?process_literal_character_tchar@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_ND@Z"
		size = 117
		refs = "0011 __pctype_func 0025 _getc_nolock 004a _ungetc_nolock"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 0F B6 FA 48 8B D9 E8 ?? ?? ?? ?? B9 00 80 00 00 66 85 0C 78 74 48 48 8B 4B 08 E8 ?? ?? ?? ?? 83 F8 FF 74 04 48 FF 43 10 0F B6 4B 31 3B C1 74 2E 83 F8 FF 74 0F 48 FF 4B 10 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? 40 0F BE CF 83 F9 FF 74 0D 48 FF 4B 10 48 8B 53 08 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_305_0 {
	meta:
		name = "?process_literal_character_tchar@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_ND@Z"
		size = 139
		refs = "0011 __pctype_func"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 0F B6 FA 48 8B D9 E8 ?? ?? ?? ?? B9 00 80 00 00 66 85 0C 78 74 5E 48 8B 43 18 48 3B 43 10 75 05 83 C9 FF EB 0A 0F B6 08 48 FF C0 48 89 43 18 0F B6 43 39 3B C8 74 3D 48 8B 43 18 48 3B 43 08 74 12 48 3B 43 10 75 05 83 F9 FF 74 07 48 FF C8 48 89 43 18 48 8B 43 18 48 3B 43 08 74 13 48 3B 43 10 75 06 40 80 FF FF 74 07 48 FF C8 48 89 43 18 32 C0 EB 02 B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_308_0 {
	meta:
		name = "?process_state@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 161
		refs = "0023 ?process_conversion_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 003f _getc_nolock 005f _ungetc_nolock 006d ?process_literal_character_tchar@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_ND@Z 007c ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$stream_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 8B 49 2C 83 E9 02 74 5E 83 E9 01 74 20 83 F9 01 75 44 48 8B CB E8 ?? ?? ?? ?? 8A C8 32 C0 84 C9 74 07 48 FF 83 88 00 00 00 8A C1 EB 5C 48 8B 4B 08 E8 ?? ?? ?? ?? 83 F8 FF 74 1B 48 FF 43 10 0F B6 4B 30 3B C1 74 13 48 FF 4B 10 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? 32 C0 EB 2F 8A D0 48 8B CB E8 ?? ?? ?? ?? EB 23 48 8B 53 70 48 8D 4B 08 E8 ?? ?? ?? ?? 83 F8 FF 74 0F 48 FF 4B 10 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_309_0 {
	meta:
		name = "?process_state@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 180
		refs = "0023 ?process_conversion_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0076 ?process_literal_character_tchar@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_ND@Z 0085 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$string_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 8B 49 34 83 E9 02 74 67 83 E9 01 74 20 83 F9 01 75 4D 48 8B CB E8 ?? ?? ?? ?? 8A C8 32 C0 84 C9 74 07 48 FF 83 90 00 00 00 8A C1 EB 6F 48 8B 43 18 48 3B 43 10 74 28 0F B6 08 48 FF C0 48 89 43 18 83 F9 FF 74 19 0F B6 43 38 3B C8 74 15 48 8B 43 18 48 3B 43 08 74 07 48 FF C8 48 89 43 18 32 C0 EB 39 8A D1 48 8B CB E8 ?? ?? ?? ?? EB 2D 48 8B 53 78 48 8D 4B 08 E8 ?? ?? ?? ?? 8B C8 48 8B 43 18 48 3B 43 08 74 12 48 3B 43 10 75 05 83 F9 FF 74 07 48 FF C8 48 89 43 18 B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_310_0 {
	meta:
		name = "?process_state@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 169
		refs = "0023 ?process_conversion_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 0041 _getwc_nolock 006a _ungetwc_nolock 007b ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$stream_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 8B 49 2C 83 E9 02 74 5D 83 E9 01 74 22 83 F9 01 75 4F 48 8B CB E8 ?? ?? ?? ?? 8A C8 32 C0 84 C9 74 09 B8 01 00 00 00 48 01 43 70 8A C1 EB 62 48 8B 4B 08 E8 ?? ?? ?? ?? 0F B7 C8 B8 FF FF 00 00 66 3B C8 74 1C B8 01 00 00 00 48 01 43 10 66 3B 4B 30 74 3D 48 FF 4B 10 48 8B 53 08 E8 ?? ?? ?? ?? 32 C0 EB 2C 48 8B 53 58 48 8D 4B 08 E8 ?? ?? ?? ?? 0F B7 C8 B8 FF FF 00 00 66 3B C8 74 0D 48 FF 4B 10 48 8B 53 08 E8 ?? ?? ?? ?? B8 01 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_311_0 {
	meta:
		name = "?process_state@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 181
		refs = "0023 ?process_conversion_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ 007c ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$string_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 8B 49 34 83 E9 02 74 5E 83 E9 01 74 22 83 F9 01 75 50 48 8B CB E8 ?? ?? ?? ?? 8A C8 32 C0 84 C9 74 09 B8 01 00 00 00 48 01 43 78 8A C1 EB 6E 48 8B 43 18 48 3B 43 10 74 29 0F B7 10 B9 FF FF 00 00 48 83 C0 02 48 89 43 18 66 3B D1 74 14 66 3B 53 38 74 44 48 3B 43 08 74 08 48 83 C0 FE 48 89 43 18 32 C0 EB 37 48 8B 53 60 48 8D 4B 08 E8 ?? ?? ?? ?? 0F B7 D0 48 8B 43 18 48 3B 43 08 74 18 48 3B 43 10 75 0A B9 FF FF 00 00 66 3B D1 74 08 48 83 C0 FE 48 89 43 18 B8 01 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_312_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@2@@Z"
		size = 127
		refs = "0022 ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$stream_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z 0036 _ungetc_nolock 003f ?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ 005c ??$process_string_specifier_tchar@_W@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z 006b ??$process_string_specifier_tchar@D@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B FA 48 8B D9 83 FA 01 75 21 48 8B 51 70 48 83 C1 08 E8 ?? ?? ?? ?? 83 F8 FF 74 0F 48 FF 4B 10 8B C8 48 8B 53 08 E8 ?? ?? ?? ?? 48 8D 4B 18 E8 ?? ?? ?? ?? 48 83 E8 01 74 19 48 83 E8 01 74 04 32 C0 EB 1C 45 33 C0 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 0D 45 33 C0 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_313_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@2@@Z"
		size = 137
		refs = "0022 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$string_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z 0049 ?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ 0066 ??$process_string_specifier_tchar@_W@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z 0075 ??$process_string_specifier_tchar@D@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B F2 48 8B D9 83 FA 01 75 2B 48 8B 51 78 48 83 C1 08 E8 ?? ?? ?? ?? 8B C8 48 8B 43 18 48 3B 43 08 74 12 48 3B 43 10 75 05 83 F9 FF 74 07 48 FF C8 48 89 43 18 48 8D 4B 20 E8 ?? ?? ?? ?? 48 83 E8 01 74 19 48 83 E8 01 74 04 32 C0 EB 1C 45 33 C0 8B D6 48 8B CB E8 ?? ?? ?? ?? EB 0D 45 33 C0 8B D6 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_314_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@2@@Z"
		size = 133
		refs = "0022 ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$stream_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z 003c _ungetwc_nolock 0045 ?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ 0062 ??$process_string_specifier_tchar@_W@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z 0071 ??$process_string_specifier_tchar@D@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B FA 48 8B D9 83 FA 01 75 27 48 8B 51 58 48 83 C1 08 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 10 48 FF 4B 10 0F B7 C8 48 8B 53 08 E8 ?? ?? ?? ?? 48 8D 4B 18 E8 ?? ?? ?? ?? 48 83 E8 01 74 19 48 83 E8 01 74 04 32 C0 EB 1C 45 33 C0 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 0D 45 33 C0 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_315_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@2@@Z"
		size = 144
		refs = "0022 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$string_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z 0050 ?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ 006d ??$process_string_specifier_tchar@_W@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@_W@Z 007c ??$process_string_specifier_tchar@D@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B F2 48 8B D9 83 FA 01 75 32 48 8B 51 60 48 83 C1 08 E8 ?? ?? ?? ?? 0F B7 C8 48 8B 43 18 48 3B 43 08 74 18 48 3B 43 10 75 0A BA FF FF 00 00 66 3B CA 74 08 48 83 C0 FE 48 89 43 18 48 8D 4B 20 E8 ?? ?? ?? ?? 48 83 E8 01 74 19 48 83 E8 01 74 04 32 C0 EB 1C 45 33 C0 8B D6 48 8B CB E8 ?? ?? ?? ?? EB 0D 45 33 C0 8B D6 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_316_0 {
	meta:
		name = "?process_whitespace@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 49
		refs = "0012 ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$stream_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z 0025 _ungetc_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 51 70 48 8D 59 08 48 8B CB E8 ?? ?? ?? ?? 83 F8 FF 74 0E 48 FF 4B 08 8B C8 48 8B 13 E8 ?? ?? ?? ?? B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_317_0 {
	meta:
		name = "?process_whitespace@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 59
		refs = "0012 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAEAV?$string_input_adapter@D@0@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 51 78 48 8D 59 08 48 8B CB E8 ?? ?? ?? ?? 8B C8 48 8B 43 10 48 3B 03 74 12 48 3B 43 08 75 05 83 F9 FF 74 07 48 FF C8 48 89 43 10 B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_318_0 {
	meta:
		name = "?process_whitespace@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 55
		refs = "0012 ??$skip_whitespace@Vstream_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$stream_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z 002b _ungetwc_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 51 58 48 8D 59 08 48 8B CB E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 0F 48 FF 4B 08 0F B7 C8 48 8B 13 E8 ?? ?? ?? ?? B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_319_0 {
	meta:
		name = "?process_whitespace@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NXZ"
		size = 66
		refs = "0012 ??$skip_whitespace@Vstring_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAEAV?$string_input_adapter@_W@0@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 51 60 48 8D 59 08 48 8B CB E8 ?? ?? ?? ?? 0F B7 C8 48 8B 43 10 48 3B 03 74 18 48 3B 43 08 75 0A BA FF FF 00 00 66 3B CA 74 08 48 83 C0 FE 48 89 43 10 B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_322_0 {
	meta:
		name = "?reset@?$scanset_buffer@E@__crt_stdio_input@@QEAAXXZ"
		size = 25
		refs = "0010 memset"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 0B 33 D2 44 8D 42 20 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_323_0 {
	meta:
		name = "?reset@?$scanset_buffer@_W@__crt_stdio_input@@QEAAXXZ"
		size = 87
		refs = "001e _calloc_base 0029 _free_base 0048 memset"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 39 00 48 8B F9 75 24 BA 01 00 00 00 B9 00 20 00 00 E8 ?? ?? ?? ?? 48 8B 0F 48 8B D8 E8 ?? ?? ?? ?? 33 C9 48 89 1F E8 ?? ?? ?? ?? 48 8B 0F 48 85 C9 74 0D 33 D2 41 B8 00 20 00 00 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_324_0 {
	meta:
		name = "?reset_token_state@?$format_string_parser@D@__crt_stdio_input@@AEAAXXZ"
		size = 26
	strings:
		$1 = { 33 C0 89 41 14 66 89 41 18 88 41 1A 48 89 41 20 89 41 28 88 41 2C 89 41 30 C3 }
	condition:
		$1
}

rule file_158_325_0 {
	meta:
		name = "?reset_token_state@?$format_string_parser@_W@__crt_stdio_input@@AEAAXXZ"
		size = 23
	strings:
		$1 = { 33 C0 48 89 41 14 88 41 1C 48 89 41 20 89 41 28 88 41 2C 89 41 30 C3 }
	condition:
		$1
}

rule file_158_326_0 {
	meta:
		name = "?reset_token_state_for_error@?$format_string_parser@D@__crt_stdio_input@@AEAAXH@Z"
		size = 29
	strings:
		$1 = { 33 C0 89 51 10 89 41 14 66 89 41 18 88 41 1A 48 89 41 20 89 41 28 88 41 2C 89 41 30 C3 }
	condition:
		$1
}

rule file_158_327_0 {
	meta:
		name = "?reset_token_state_for_error@?$format_string_parser@_W@__crt_stdio_input@@AEAAXH@Z"
		size = 26
	strings:
		$1 = { 33 C0 89 51 10 48 89 41 14 88 41 1C 48 89 41 20 89 41 28 88 41 2C 89 41 30 C3 }
	condition:
		$1
}

rule file_158_328_0 {
	meta:
		name = "?restore_state@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA_N_K@Z"
		size = 19
		altNames = "?restore_state@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA_N_K@Z ?restore_state@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_N_K@Z ?restore_state@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_N_K@Z ?restore_state@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA_N_K@Z ?restore_state@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_N_K@Z"
	strings:
		$1 = { 48 3B 51 10 74 0A 48 8B 41 18 C6 00 00 32 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule file_158_337_0 {
	meta:
		name = "?scan_conversion_specifier@?$format_string_parser@D@__crt_stdio_input@@AEAA_NXZ"
		size = 444
		refs = "00ff ?scan_scanset_range@?$format_string_parser@D@__crt_stdio_input@@AEAA_NXZ"
	strings:
		$1 = { 4C 8B 41 08 48 8B D1 41 0F B6 00 83 F8 64 0F 8F FB 00 00 00 0F 84 E9 00 00 00 83 F8 53 7F 4E 0F 84 30 01 00 00 83 F8 41 0F 84 7C 01 00 00 83 F8 43 74 56 83 F8 44 7E 12 83 F8 47 0F 8E 69 01 00 00 83 F8 49 0F 84 57 01 00 00 33 C0 48 C7 41 10 16 00 00 00 66 89 41 18 88 41 1A 48 89 41 20 89 41 28 88 41 2C 89 41 30 E9 4E 01 00 00 83 F8 58 0F 84 CD 00 00 00 83 F8 5B 74 51 83 F8 61 0F 84 26 01 00 00 83 F8 63 75 C1 33 C0 48 39 41 20 75 08 48 C7 41 20 01 00 00 00 44 8B 49 28 41 83 F9 02 75 03 88 41 2C 41 8D 49 FD F7 C1 FA FF FF FF 75 0A 41 83 F9 07 74 04 C6 42 2C 01 49 8D 48 01 89 42 30 48 89 4A 08 E9 ED 00 00 00 8B 49 28 83 F9 02 75 05 33 C0 88 42 2C 8D 41 FD A9 FA FF FF FF 75 09 83 F9 07 74 04 C6 42 2C 01 49 8D 40 01 C7 42 30 08 00 00 00 48 8B CA 48 89 42 08 E9 ?? ?? ?? ?? C7 41 30 03 00 00 00 E9 A2 00 00 00 83 F8 67 0F 8E 92 00 00 00 83 F8 69 0F 84 80 00 00 00 83 F8 6E 74 72 83 F8 6F 74 64 83 F8 70 74 56 83 F8 73 74 20 83 F8 75 74 12 83 F8 78 0F 85 07 FF FF FF C7 41 30 06 00 00 00 EB 65 C7 41 30 05 00 00 00 EB 5C 8B 49 28 83 F9 02 75 05 33 C0 88 42 2C 8D 41 FD A9 FA FF FF FF 75 09 83 F9 07 74 04 C6 42 2C 01 49 8D 40 01 C7 42 30 01 00 00 00 48 89 42 08 EB 33 C7 41 28 0A 00 00 00 EB B4 C7 41 30 04 00 00 00 EB 19 C7 41 30 09 00 00 00 EB 10 C7 41 30 02 00 00 00 EB 07 C7 41 30 07 00 00 00 49 8D 40 01 48 89 41 08 B0 01 C3 }
	condition:
		$1
}

rule file_158_338_0 {
	meta:
		name = "?scan_conversion_specifier@?$format_string_parser@_W@__crt_stdio_input@@AEAA_NXZ"
		size = 443
		refs = "00fe ?scan_scanset_range@?$format_string_parser@_W@__crt_stdio_input@@AEAA_NXZ"
	strings:
		$1 = { 4C 8B 41 08 48 8B D1 41 0F B7 00 83 F8 64 0F 8F FA 00 00 00 0F 84 E8 00 00 00 83 F8 53 7F 4D 0F 84 2F 01 00 00 83 F8 41 0F 84 7B 01 00 00 83 F8 43 74 55 83 F8 44 7E 12 83 F8 47 0F 8E 68 01 00 00 83 F8 49 0F 84 56 01 00 00 33 C0 48 C7 41 10 16 00 00 00 89 41 18 88 41 1C 48 89 41 20 89 41 28 88 41 2C 89 41 30 E9 4E 01 00 00 83 F8 58 0F 84 CD 00 00 00 83 F8 5B 74 51 83 F8 61 0F 84 26 01 00 00 83 F8 63 75 C2 33 C0 48 39 41 20 75 08 48 C7 41 20 01 00 00 00 44 8B 49 28 41 83 F9 02 75 03 88 41 2C 41 8D 49 FD F7 C1 FA FF FF FF 75 0A 41 83 F9 07 74 04 C6 42 2C 01 49 8D 48 02 89 42 30 48 89 4A 08 E9 ED 00 00 00 8B 49 28 83 F9 02 75 05 33 C0 88 42 2C 8D 41 FD A9 FA FF FF FF 75 09 83 F9 07 74 04 C6 42 2C 01 49 8D 40 02 C7 42 30 08 00 00 00 48 8B CA 48 89 42 08 E9 ?? ?? ?? ?? C7 41 30 03 00 00 00 E9 A2 00 00 00 83 F8 67 0F 8E 92 00 00 00 83 F8 69 0F 84 80 00 00 00 83 F8 6E 74 72 83 F8 6F 74 64 83 F8 70 74 56 83 F8 73 74 20 83 F8 75 74 12 83 F8 78 0F 85 08 FF FF FF C7 41 30 06 00 00 00 EB 65 C7 41 30 05 00 00 00 EB 5C 8B 49 28 83 F9 02 75 05 33 C0 88 42 2C 8D 41 FD A9 FA FF FF FF 75 09 83 F9 07 74 04 C6 42 2C 01 49 8D 40 02 C7 42 30 01 00 00 00 48 89 42 08 EB 33 C7 41 28 0A 00 00 00 EB B4 C7 41 30 04 00 00 00 EB 19 C7 41 30 09 00 00 00 EB 10 C7 41 30 02 00 00 00 EB 07 C7 41 30 07 00 00 00 49 8D 40 02 48 89 41 08 B0 01 C3 }
	condition:
		$1
}

rule file_158_339_0 {
	meta:
		name = "?scan_optional_assignment_suppressor@?$format_string_parser@D@__crt_stdio_input@@AEAAXXZ"
		size = 21
	strings:
		$1 = { 48 8B 41 08 80 38 2A 75 0B 48 FF C0 C6 41 1A 01 48 89 41 08 C3 }
	condition:
		$1
}

rule file_158_340_0 {
	meta:
		name = "?scan_optional_assignment_suppressor@?$format_string_parser@_W@__crt_stdio_input@@AEAAXXZ"
		size = 23
	strings:
		$1 = { 48 8B 41 08 66 83 38 2A 75 0C 48 83 C0 02 C6 41 1C 01 48 89 41 08 C3 }
	condition:
		$1
}

rule file_158_341_0 {
	meta:
		name = "?scan_optional_field_width@?$format_string_parser@D@__crt_stdio_input@@AEAA_NXZ"
		size = 166
		refs = "005b strtoull"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 08 8A 01 2C 30 3C 09 77 08 0F BE 01 83 C0 D0 EB 23 8A 01 2C 61 3C 19 77 08 0F BE 01 83 C0 A9 EB 13 8A 01 2C 41 3C 19 77 08 0F BE 01 83 C0 C9 EB 03 83 C8 FF 83 F8 09 76 04 B0 01 EB 57 48 83 64 24 30 00 48 8D 54 24 30 41 B8 0A 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 15 48 8B 4C 24 30 48 3B 4B 08 74 0A 48 89 43 20 48 89 4B 08 EB CC 83 63 14 00 66 83 63 18 00 48 83 63 20 00 83 63 28 00 83 63 30 00 32 C0 C6 43 1A 00 C6 43 2C 00 C7 43 10 16 00 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_342_0 {
	meta:
		name = "?scan_optional_field_width@?$format_string_parser@_W@__crt_stdio_input@@AEAA_NXZ"
		size = 597
		refs = "020d wcstoull"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 48 8B D9 BA 30 00 00 00 48 8B 49 08 66 39 11 0F 82 9F 01 00 00 66 83 39 3A 73 0A 0F B7 01 2B C2 E9 8A 01 00 00 BA 10 FF 00 00 66 39 11 0F 83 6B 01 00 00 BA 60 06 00 00 66 39 11 0F 82 73 01 00 00 8D 42 0A 66 39 01 72 D2 BA F0 06 00 00 66 39 11 0F 82 5D 01 00 00 8D 42 0A 66 39 01 72 BC BA 66 09 00 00 66 39 11 0F 82 47 01 00 00 8D 42 0A 66 39 01 72 A6 8D 50 76 66 39 11 0F 82 33 01 00 00 8D 42 0A 66 39 01 72 92 8D 50 76 66 39 11 0F 82 1F 01 00 00 8D 42 0A 66 39 01 0F 82 7A FF FF FF 8D 50 76 66 39 11 0F 82 07 01 00 00 8D 42 0A 66 39 01 0F 82 62 FF FF FF 8D 50 76 66 39 11 0F 82 EF 00 00 00 8D 42 0A 66 39 01 0F 82 4A FF FF FF BA 66 0C 00 00 66 39 11 0F 82 D5 00 00 00 8D 42 0A 66 39 01 0F 82 30 FF FF FF 8D 50 76 66 39 11 0F 82 BD 00 00 00 8D 42 0A 66 39 01 0F 82 18 FF FF FF 8D 50 76 66 39 11 0F 82 A5 00 00 00 8D 42 0A 66 39 01 0F 82 00 FF FF FF BA 50 0E 00 00 66 39 11 0F 82 8B 00 00 00 8D 42 0A 66 39 01 0F 82 E6 FE FF FF 8D 50 76 66 39 11 72 77 8D 42 0A 66 39 01 0F 82 D2 FE FF FF 8D 50 46 66 39 11 72 63 8D 42 0A 66 39 01 0F 82 BE FE FF FF BA 40 10 00 00 66 39 11 72 4D 8D 42 0A 66 39 01 0F 82 A8 FE FF FF BA E0 17 00 00 66 39 11 72 37 8D 42 0A 66 39 01 0F 82 92 FE FF FF 8D 50 26 66 39 11 72 23 8D 42 0A 66 39 01 73 1B E9 7D FE FF FF B8 1A FF 00 00 66 39 01 0F 82 6F FE FF FF 83 C8 FF 83 F8 FF 75 35 0F B7 01 66 83 E8 41 66 83 F8 19 76 12 0F B7 01 66 83 E8 61 66 83 F8 19 76 05 83 C8 FF EB 16 0F B7 01 66 83 E8 61 66 83 F8 19 0F B7 01 77 03 83 E8 20 83 C0 C9 83 F8 09 76 04 B0 01 EB 4E 33 FF 48 8D 54 24 30 48 89 7C 24 30 44 8D 47 0A E8 ?? ?? ?? ?? 48 85 C0 74 15 48 8B 4C 24 30 48 3B 4B 08 74 0A 48 89 43 20 48 89 4B 08 EB CD 48 C7 43 10 16 00 00 00 32 C0 89 7B 18 40 88 7B 1C 48 89 7B 20 89 7B 28 40 88 7B 2C 89 7B 30 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_343_0 {
	meta:
		name = "?scan_optional_length_modifier@?$format_string_parser@D@__crt_stdio_input@@AEAAXXZ"
		size = 300
	strings:
		$1 = { 48 8B 41 08 80 38 49 0F 84 C4 00 00 00 80 38 4C 0F 84 AC 00 00 00 80 38 54 0F 84 94 00 00 00 80 38 68 74 6A 80 38 6A 74 56 80 38 6C 74 2C 80 38 74 74 18 80 38 7A 0F 85 EF 00 00 00 48 FF C0 C7 41 28 06 00 00 00 48 89 41 08 C3 48 FF C0 C7 41 28 07 00 00 00 48 89 41 08 C3 48 8D 50 01 80 3A 6C 75 10 48 83 C0 02 C7 41 28 04 00 00 00 48 89 41 08 C3 48 89 51 08 C7 41 28 03 00 00 00 C3 48 FF C0 C7 41 28 05 00 00 00 48 89 41 08 C3 48 8D 50 01 80 3A 68 75 10 48 83 C0 02 C7 41 28 01 00 00 00 48 89 41 08 C3 48 89 51 08 C7 41 28 02 00 00 00 C3 48 FF C0 C7 41 28 0B 00 00 00 48 89 41 08 C3 48 FF C0 C7 41 28 08 00 00 00 48 89 41 08 C3 4C 8D 40 01 41 8A 10 80 FA 33 75 16 80 78 02 32 75 10 48 83 C0 03 C7 41 28 09 00 00 00 48 89 41 08 C3 80 FA 36 75 10 80 78 02 34 75 0A 48 83 C0 03 48 89 41 08 EB 1C 80 EA 58 80 FA 20 77 1B 48 B8 01 10 82 20 01 00 00 00 48 0F A3 D0 73 0B 4C 89 41 08 C7 41 28 0A 00 00 00 C3 }
	condition:
		$1
}

rule file_158_344_0 {
	meta:
		name = "?scan_optional_length_modifier@?$format_string_parser@_W@__crt_stdio_input@@AEAAXXZ"
		size = 329
	strings:
		$1 = { 48 8B 41 08 0F B7 10 83 FA 49 0F 84 D7 00 00 00 83 FA 4C 0F 84 BE 00 00 00 83 FA 54 0F 84 A5 00 00 00 41 B8 68 00 00 00 41 3B D0 74 74 83 FA 6A 74 5F 41 B8 6C 00 00 00 41 3B D0 74 2E 83 FA 74 74 19 83 FA 7A 0F 85 FD 00 00 00 48 83 C0 02 C7 41 28 06 00 00 00 48 89 41 08 C3 48 83 C0 02 C7 41 28 07 00 00 00 48 89 41 08 C3 48 8D 50 02 66 44 39 02 75 10 48 83 C0 04 C7 41 28 04 00 00 00 48 89 41 08 C3 48 89 51 08 C7 41 28 03 00 00 00 C3 48 83 C0 02 C7 41 28 05 00 00 00 48 89 41 08 C3 48 8D 50 02 66 44 39 02 75 10 48 83 C0 04 C7 41 28 01 00 00 00 48 89 41 08 C3 48 89 51 08 C7 41 28 02 00 00 00 C3 48 83 C0 02 C7 41 28 0B 00 00 00 48 89 41 08 C3 48 83 C0 02 C7 41 28 08 00 00 00 48 89 41 08 C3 4C 8D 40 02 41 0F B7 10 66 83 FA 33 75 17 66 83 78 04 32 75 10 48 83 C0 06 C7 41 28 09 00 00 00 48 89 41 08 C3 66 83 FA 36 75 11 66 83 78 04 34 75 0A 48 83 C0 06 48 89 41 08 EB 1E 66 83 EA 58 66 83 FA 20 77 1B 48 B8 01 10 82 20 01 00 00 00 48 0F A3 D0 73 0B 4C 89 41 08 C7 41 28 0A 00 00 00 C3 }
	condition:
		$1
}

rule file_158_345_0 {
	meta:
		name = "?scan_optional_literal_character_trail_bytes_tchar@?$format_string_parser@D@__crt_stdio_input@@AEAA_ND@Z"
		size = 91
		refs = "000a __pctype_func"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 0F B6 53 18 B9 00 80 00 00 66 85 0C 50 74 36 48 8B 43 08 33 D2 8A 08 84 C9 75 20 48 C7 43 10 2A 00 00 00 32 C0 66 89 53 18 88 53 1A 48 89 53 20 89 53 28 88 53 2C 89 53 30 EB 0C 48 FF C0 88 4B 19 48 89 43 08 B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_158_347_0 {
	meta:
		name = "?scan_optional_wide_modifier@?$format_string_parser@D@__crt_stdio_input@@AEAAXXZ"
		size = 31
	strings:
		$1 = { 48 8B 51 08 8A 02 3C 77 75 0A 48 8D 42 01 48 89 41 08 EB 06 2C 43 A8 EF 75 04 C6 41 2C 01 C3 }
	condition:
		$1
}

rule file_158_348_0 {
	meta:
		name = "?scan_optional_wide_modifier@?$format_string_parser@_W@__crt_stdio_input@@AEAAXXZ"
		size = 62
	strings:
		$1 = { 48 8B 51 08 0F B7 02 66 83 F8 77 75 0A 48 8D 42 02 48 89 41 08 EB 22 66 83 E8 43 BA EF FF 00 00 66 85 C2 74 0E 83 79 28 0B 74 0E 8A 01 D0 E8 24 01 EB 02 32 C0 84 C0 74 04 C6 41 2C 01 C3 }
	condition:
		$1
}

rule file_158_349_0 {
	meta:
		name = "?scan_scanset_range@?$format_string_parser@D@__crt_stdio_input@@AEAA_NXZ"
		size = 404
		refs = "004c memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8D 79 34 33 F6 48 8B D9 48 85 FF 75 25 48 C7 41 10 0C 00 00 00 66 89 71 18 40 88 71 1A 48 89 71 20 89 71 28 40 88 71 2C 89 71 30 32 C0 E9 42 01 00 00 33 D2 48 8B CF 44 8D 42 20 E8 ?? ?? ?? ?? 48 8B 43 08 80 38 5E 41 0F 94 C3 45 84 DB 74 07 48 FF C0 48 89 43 08 48 8B 43 08 80 38 5D 75 0B 48 FF C0 48 89 43 08 80 4B 3F 20 4C 8B 53 08 41 80 3A 5D 0F 84 9A 00 00 00 48 8B 43 08 40 38 30 0F 84 8D 00 00 00 80 38 2D 75 4F 49 3B C2 74 4A 80 78 01 5D 74 44 8A 48 FF 8A 50 01 3A CA 76 06 8A C1 8A CA 8A D0 FE C2 EB 2A 44 0F B6 C1 49 C1 E8 03 0F B6 C1 45 0F B6 4C 18 34 25 07 00 00 80 7D 07 FF C8 83 C8 F8 FF C0 41 0F AB C1 45 88 4C 18 34 FE C1 3A CA 75 D2 EB 28 0F B6 10 0F B6 08 48 C1 EA 03 44 0F B6 44 1A 34 81 E1 07 00 00 80 7D 07 FF C9 83 C9 F8 FF C1 41 0F AB C8 44 88 44 1A 34 48 FF 43 08 48 8B 43 08 80 38 5D 0F 85 66 FF FF FF 48 8B 43 08 40 38 30 75 23 48 C7 43 10 16 00 00 00 66 89 73 18 40 88 73 1A 48 89 73 20 89 73 28 40 88 73 2C 89 73 30 E9 EC FE FF FF 45 84 DB 74 2A 48 8D 47 20 48 8B D0 48 2B D7 48 3B F8 48 0F 47 D6 48 85 D2 74 14 4C 8B C7 49 F7 D8 F6 17 48 FF C7 49 8D 0C 38 48 3B CA 75 F2 48 FF 43 08 B0 01 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_350_0 {
	meta:
		name = "?scan_scanset_range@?$format_string_parser@_W@__crt_stdio_input@@AEAA_NXZ"
		size = 476
		refs = "003a _calloc_base 0045 _free_base 00b6 memset 00f7 ?set@?$scanset_buffer@_W@__crt_stdio_input@@QEAAX_W@Z 01b1 ?invert@?$scanset_buffer@_W@__crt_stdio_input@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 83 EC 20 48 8D 71 38 45 33 E4 48 8B F9 B8 01 00 00 00 BD 00 20 00 00 4C 39 26 75 73 8B D0 8B CD E8 ?? ?? ?? ?? 48 8B 0E 48 8B D8 E8 ?? ?? ?? ?? 33 C9 48 89 1E E8 ?? ?? ?? ?? 4C 39 26 75 27 48 C7 47 10 0C 00 00 00 44 89 67 18 44 88 67 1C 32 C0 4C 89 67 20 44 89 67 28 44 88 67 2C 44 89 67 30 E9 40 01 00 00 B8 01 00 00 00 4C 39 26 75 1F 8B D0 48 8B CD E8 ?? ?? ?? ?? 48 8B 0E 48 8B D8 E8 ?? ?? ?? ?? 33 C9 48 89 1E E8 ?? ?? ?? ?? 48 8B 0E 48 85 C9 74 0A 4C 8B C5 33 D2 E8 ?? ?? ?? ?? 48 8B 47 08 66 83 38 5E 41 0F 94 C6 44 88 74 24 50 45 84 F6 74 08 48 83 C0 02 48 89 47 08 48 8B 47 08 41 BD 5D 00 00 00 66 44 39 28 75 13 48 83 C0 02 41 8B D5 48 8B CE 48 89 47 08 E8 ?? ?? ?? ?? 4C 8B 7F 08 66 45 39 2F 0F 84 84 00 00 00 41 BE 01 00 00 00 48 8B 47 08 66 44 39 20 74 6F 66 83 38 2D 75 4F 49 3B C7 74 4A 66 44 39 68 02 74 43 0F B7 58 FE 0F B7 68 02 66 3B DD 76 09 0F B7 C3 0F B7 DD 0F B7 E8 66 41 03 EE 66 3B DD 74 2F 41 BC 01 00 00 00 0F B7 D3 48 8B CE E8 ?? ?? ?? ?? 66 41 03 DC 66 3B DD 75 EC 45 33 E4 45 8D 74 24 01 EB 0B 0F B7 10 48 8B CE E8 ?? ?? ?? ?? 48 83 47 08 02 48 8B 47 08 66 44 39 28 75 87 44 8A 74 24 50 48 8B 47 08 66 44 39 20 75 11 83 67 18 00 48 C7 47 10 16 00 00 00 E9 BC FE FF FF 45 84 F6 74 08 48 8B CE E8 ?? ?? ?? ?? 48 83 47 08 02 B8 01 00 00 00 48 8B 5C 24 58 48 8B 6C 24 60 48 8B 74 24 68 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_158_357_0 {
	meta:
		name = "?set@?$scanset_buffer@E@__crt_stdio_input@@QEAAXE@Z"
		size = 39
	strings:
		$1 = { 44 0F B6 CA 49 C1 E9 03 0F B6 C2 45 0F B6 04 09 25 07 00 00 80 7D 07 FF C8 83 C8 F8 FF C0 41 0F AB C0 45 88 04 09 C3 }
	condition:
		$1
}

rule file_158_358_0 {
	meta:
		name = "?set@?$scanset_buffer@_W@__crt_stdio_input@@QEAAX_W@Z"
		size = 118
		refs = "0026 _calloc_base 0031 _free_base"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 83 39 00 0F B7 F2 48 8B F9 75 24 BA 01 00 00 00 B9 00 20 00 00 E8 ?? ?? ?? ?? 48 8B 0F 48 8B D8 E8 ?? ?? ?? ?? 33 C9 48 89 1F E8 ?? ?? ?? ?? 4C 8B 07 0F B7 D6 48 C1 EA 03 0F B7 C6 42 0F B6 0C 02 25 07 00 00 80 7D 07 FF C8 83 C8 F8 FF C0 48 8B 5C 24 30 0F AB C1 48 8B 74 24 38 42 88 0C 02 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_359_0 {
	meta:
		name = "?set_wide_for_c_s_or_scanset@?$format_string_parser@D@__crt_stdio_input@@AEAAXXZ"
		size = 32
		altNames = "?set_wide_for_c_s_or_scanset@?$format_string_parser@_W@__crt_stdio_input@@AEAAXXZ"
	strings:
		$1 = { 8B 51 28 83 FA 02 75 04 C6 41 2C 00 8D 42 FD A9 FA FF FF FF 75 09 83 FA 07 74 04 C6 41 2C 01 C3 }
	condition:
		$1
}

rule file_158_363_0 {
	meta:
		name = "?should_default_to_wide@?$format_string_parser@_W@__crt_stdio_input@@AEAA_N_W@Z"
		size = 35
	strings:
		$1 = { 66 83 EA 43 B8 EF FF 00 00 66 85 D0 74 12 83 79 28 0B 75 03 B0 01 C3 8B 01 48 D1 E8 83 E0 01 C3 32 C0 C3 }
	condition:
		$1
}

rule file_158_369_0 {
	meta:
		name = "?test@?$scanset_buffer@E@__crt_stdio_input@@QEBA_NE@Z"
		size = 48
	strings:
		$1 = { 0F B6 C2 4C 8B C9 41 B8 01 00 00 00 25 07 00 00 80 7D 09 41 2B C0 83 C8 F8 41 03 C0 8A C8 0F B6 C2 48 C1 E8 03 41 D3 E0 46 84 04 08 0F 95 C0 C3 }
	condition:
		$1
}

rule file_158_370_0 {
	meta:
		name = "?test@?$scanset_buffer@_W@__crt_stdio_input@@QEBA_N_W@Z"
		size = 145
		refs = "0034 _calloc_base 003f _free_base"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 ED 44 0F B7 F2 48 8B F1 BF 01 00 00 00 48 39 29 75 21 8B D7 B9 00 20 00 00 E8 ?? ?? ?? ?? 48 8B 0E 48 8B D8 E8 ?? ?? ?? ?? 33 C9 48 89 1E E8 ?? ?? ?? ?? 41 0F B7 CE 81 E1 07 00 00 80 7D 07 2B CF 83 C9 F8 03 CF 48 8B 5C 24 30 48 8B 6C 24 38 D3 E7 48 8B 0E 48 8B 74 24 40 41 0F B7 D6 48 C1 EA 03 8A 14 0A 40 84 FA 48 8B 7C 24 48 0F 95 C0 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_158_371_0 {
	meta:
		name = "?to_floating_point_length@__crt_stdio_input@@YA_KW4length_modifier@1@@Z"
		size = 26
	strings:
		$1 = { 33 D2 85 C9 74 0E 8D 42 08 83 F9 03 74 0B 3B C8 0F 45 C2 C3 B8 04 00 00 00 C3 }
	condition:
		$1
}

rule file_158_372_0 {
	meta:
		name = "?to_integer_length@__crt_stdio_input@@YA_KW4length_modifier@1@@Z"
		size = 73
	strings:
		$1 = { 83 F9 05 7F 32 74 18 85 C9 74 1A 83 E9 01 74 21 83 E9 01 74 16 83 E9 01 74 0B 83 F9 01 75 27 B8 08 00 00 00 C3 B8 04 00 00 00 C3 B8 02 00 00 00 C3 B8 01 00 00 00 C3 83 E9 06 74 E3 83 E9 01 74 DE 83 E9 02 EB D2 33 C0 C3 }
	condition:
		$1
}

rule file_158_373_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAAXD@Z"
		size = 62
		refs = "0035 _ungetc_nolock"
	strings:
		$1 = { 48 83 EC 28 48 FF 49 10 48 83 79 08 00 48 8B 41 10 74 06 48 3B 41 08 77 20 8D 42 01 3C 01 76 19 0F BE C2 48 8B 11 83 F8 FF 74 0E 48 FF 4A 08 8B C8 48 8B 12 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_374_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAAX_W@Z"
		size = 67
		refs = "003a _ungetwc_nolock"
	strings:
		$1 = { 48 83 EC 28 48 FF 49 10 44 0F B7 C2 48 83 79 08 00 48 8B 41 10 74 06 48 3B 41 08 77 21 41 8D 40 FF BA FD FF 00 00 66 3B C2 77 13 48 8B 11 41 0F B7 C8 48 FF 4A 08 48 8B 12 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_375_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAAXD@Z"
		size = 48
	strings:
		$1 = { 48 FF 49 10 48 83 79 08 00 48 8B 41 10 74 06 48 3B 41 08 77 1A FE C2 80 FA 01 76 13 48 8B 09 48 8B 41 10 48 3B 01 74 07 48 FF C8 48 89 41 10 C3 }
	condition:
		$1
}

rule file_158_376_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAAX_W@Z"
		size = 55
	strings:
		$1 = { 48 FF 49 10 48 83 79 08 00 48 8B 41 10 74 06 48 3B 41 08 77 21 66 FF CA B8 FD FF 00 00 66 3B D0 77 14 48 8B 09 48 8B 41 10 48 3B 01 74 08 48 83 C0 FE 48 89 41 10 C3 }
	condition:
		$1
}

rule file_158_377_0 {
	meta:
		name = "?unget@?$stream_input_adapter@D@__crt_stdio_input@@QEAAXH@Z"
		size = 30
		refs = "0015 _ungetc_nolock"
	strings:
		$1 = { 48 83 EC 28 8B C2 83 FA FF 74 0E 48 FF 49 08 48 8B 11 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_378_0 {
	meta:
		name = "?unget@?$stream_input_adapter@_W@__crt_stdio_input@@QEAAXG@Z"
		size = 37
		refs = "001c _ungetwc_nolock"
	strings:
		$1 = { 48 83 EC 28 0F B7 C2 BA FF FF 00 00 66 3B C2 74 0F 48 FF 49 08 48 8B 11 0F B7 C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_379_0 {
	meta:
		name = "?unget@?$string_input_adapter@D@__crt_stdio_input@@QEAAXH@Z"
		size = 28
	strings:
		$1 = { 48 8B 41 10 48 3B 01 74 12 48 3B 41 08 75 05 83 FA FF 74 07 48 FF C8 48 89 41 10 C3 }
	condition:
		$1
}

rule file_158_380_0 {
	meta:
		name = "?unget@?$string_input_adapter@_W@__crt_stdio_input@@QEAAXG@Z"
		size = 36
	strings:
		$1 = { 48 8B 41 10 48 3B 01 74 1A 48 3B 41 08 75 0C 41 B8 FF FF 00 00 66 41 3B D0 74 08 48 83 C0 FE 48 89 41 10 C3 }
	condition:
		$1
}

rule file_158_382_0 {
	meta:
		name = "?validate@?$format_string_parser@D@__crt_stdio_input@@QEBA_NXZ"
		size = 38
		refs = "000c _errno 0017 _invalid_parameter_noinfo"
		altNames = "?validate@?$format_string_parser@_W@__crt_stdio_input@@QEBA_NXZ"
	strings:
		$1 = { 48 83 EC 28 48 83 79 08 00 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_384_0 {
	meta:
		name = "?validate@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ"
		size = 44
		refs = "000b _errno 0016 _invalid_parameter_noinfo"
		altNames = "?validate@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ ?validate@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ ?validate@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ ?validate@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ ?validate@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ"
	strings:
		$1 = { 48 83 EC 28 48 83 39 00 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 09 48 83 79 18 00 74 E5 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_388_0 {
	meta:
		name = "?validate@?$stream_input_adapter@D@__crt_stdio_input@@QEBA_NXZ"
		size = 44
		refs = "000d _errno 0018 _invalid_parameter_noinfo 0028 ?validate_stream_is_ansi_if_required@?$__acrt_stdio_char_traits@D@@SA_NQEAU_iobuf@@@Z"
		altNames = "?validate@?$stream_output_adapter@D@__crt_stdio_output@@QEBA_NXZ"
	strings:
		$1 = { 48 83 EC 28 48 8B 09 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 48 83 C4 28 C3 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_390_0 {
	meta:
		name = "?validate@?$string_input_adapter@D@__crt_stdio_input@@QEAA_NXZ"
		size = 46
		refs = "000e _errno 0019 _invalid_parameter_noinfo"
		altNames = "?validate@?$string_input_adapter@_W@__crt_stdio_input@@QEAA_NXZ"
	strings:
		$1 = { 48 83 EC 28 48 8B 41 10 48 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 08 48 3B 41 08 77 E6 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_392_0 {
	meta:
		name = "?validate_stream_is_ansi_if_required@?$__acrt_stdio_char_traits@D@@SA_NQEAU_iobuf@@@Z"
		size = 140
		refs = "000f _fileno 0019 __badioinfo 0020 __pioinfo 0072 _errno 007d _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 8B 41 14 C1 E8 0C A8 01 75 77 E8 ?? ?? ?? ?? 4C 63 C0 48 8D 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 41 8D 40 02 83 F8 01 76 17 49 8B D0 49 8B C0 83 E2 3F 48 C1 F8 06 48 C1 E2 06 49 03 14 C1 EB 03 48 8B D1 80 7A 39 00 75 24 41 8D 40 02 83 F8 01 76 15 49 8B C8 49 8B C0 83 E1 3F 48 C1 F8 06 48 C1 E1 06 49 03 0C C1 F6 41 3D 01 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_158_397_0 {
	meta:
		name = "?write_character@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEAD_KAEAPEADAEA_KD@Z"
		size = 23
		altNames = "?write_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEAD_KAEAPEADAEA_KD@Z ?write_character@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEAD_KAEAPEADAEA_KD@Z"
	strings:
		$1 = { 49 8B 09 8A 44 24 30 88 01 B0 01 48 8B 4C 24 28 49 FF 01 48 FF 09 C3 }
	condition:
		$1
}

rule file_158_398_0 {
	meta:
		name = "?write_character@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEFA_W_KAEAPEFA_WAEA_KD@Z"
		size = 149
		refs = "0024 __pctype_func 0038 _getc_nolock 0069 _mbtowc_l"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 57 48 83 EC 20 0F B6 7C 24 58 49 8B F1 40 88 78 30 48 8B D9 C6 40 31 00 E8 ?? ?? ?? ?? B9 00 80 00 00 66 85 0C 78 74 16 48 8B 4B 08 E8 ?? ?? ?? ?? 83 F8 FF 74 04 48 FF 43 10 88 44 24 59 4C 8B 4B 70 48 8D 54 24 58 B9 3F 00 00 00 66 89 4C 24 30 49 8B 09 4C 63 41 08 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 0E B0 01 48 8B 5C 24 38 40 0F BE D7 66 89 11 48 83 06 02 48 8B 4C 24 50 48 8B 74 24 40 48 FF 09 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_400_0 {
	meta:
		name = "?write_character@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEFA_W_KAEAPEFA_WAEA_KD@Z"
		size = 156
		refs = "0024 __pctype_func 0070 _mbtowc_l"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 57 48 83 EC 20 0F B6 7C 24 58 49 8B F1 40 88 78 30 48 8B D9 C6 40 31 00 E8 ?? ?? ?? ?? B9 00 80 00 00 66 85 0C 78 74 1D 48 8B 43 18 48 3B 43 10 75 05 83 C9 FF EB 0A 0F B6 08 48 FF C0 48 89 43 18 88 4C 24 59 4C 8B 4B 78 48 8D 54 24 58 B8 3F 00 00 00 48 8D 4C 24 30 66 89 44 24 30 49 8B 01 4C 63 40 08 E8 ?? ?? ?? ?? 48 8B 06 48 8B 5C 24 38 40 0F BE CF 66 89 08 48 8B 44 24 50 48 83 06 02 48 8B 74 24 40 48 FF 08 B0 01 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_401_0 {
	meta:
		name = "?write_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEAD_KAEAPEADAEA_K_W@Z"
		size = 170
		refs = "0034 wctomb_s 00a5 _invoke_watson"
		altNames = "?write_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEAD_KAEAPEADAEA_K_W@Z ?write_character@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEAD_KAEAPEADAEA_K_W@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 57 48 83 EC 30 83 60 18 00 48 8D 48 18 49 8B D9 44 0F B7 4C 24 68 48 8B F2 48 8B 13 49 83 F8 FF 75 2D 41 B8 05 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 0C 83 F8 16 74 53 83 F8 22 75 3C EB 4C 48 63 4C 24 50 48 8B 44 24 60 48 01 0B 48 29 08 EB 28 48 8B 7C 24 60 4C 8B 07 E8 ?? ?? ?? ?? 83 F8 22 75 07 C6 06 00 32 C0 EB 11 48 63 44 24 50 85 C0 7E 06 48 01 03 48 29 07 B0 01 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_158_402_0 {
	meta:
		name = "?write_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEFA_W_KAEAPEFA_WAEA_K_W@Z"
		size = 26
		altNames = "?write_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEFA_W_KAEAPEFA_WAEA_K_W@Z ?write_character@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_NQEFA_W_KAEAPEFA_WAEA_K_W@Z"
	strings:
		$1 = { 49 8B 09 0F B7 44 24 30 66 89 01 48 8B 44 24 28 49 83 01 02 48 FF 08 B0 01 C3 }
	condition:
		$1
}

rule file_158_405_0 {
	meta:
		name = "?write_integer@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
		size = 126
		refs = "0020 _errno 002b _invalid_parameter_noinfo 0044 ?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 41 78 08 48 8B FA 48 8B 41 78 48 8B 58 F8 48 85 DB 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 40 45 84 C0 74 07 48 FF 81 80 00 00 00 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 E8 01 74 20 48 83 E8 01 74 15 48 83 E8 02 74 0B 48 83 E8 04 75 CF 48 89 3B EB 0C 89 3B EB 08 66 89 3B EB 03 40 88 3B B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_406_0 {
	meta:
		name = "?write_integer@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
		size = 132
		refs = "0026 _errno 0031 _invalid_parameter_noinfo 004a ?length@?$format_string_parser@D@__crt_stdio_input@@QEBA_KXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 81 80 00 00 00 08 48 8B FA 48 8B 81 80 00 00 00 48 8B 58 F8 48 85 DB 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 40 45 84 C0 74 07 48 FF 81 88 00 00 00 48 83 C1 20 E8 ?? ?? ?? ?? 48 83 E8 01 74 20 48 83 E8 01 74 15 48 83 E8 02 74 0B 48 83 E8 04 75 CF 48 89 3B EB 0C 89 3B EB 08 66 89 3B EB 03 40 88 3B B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_407_0 {
	meta:
		name = "?write_integer@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
		size = 123
		refs = "0020 _errno 002b _invalid_parameter_noinfo 0041 ?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 41 60 08 48 8B FA 48 8B 41 60 48 8B 58 F8 48 85 DB 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 3D 45 84 C0 74 04 48 FF 41 68 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 E8 01 74 20 48 83 E8 01 74 15 48 83 E8 02 74 0B 48 83 E8 04 75 D2 48 89 3B EB 0C 89 3B EB 08 66 89 3B EB 03 40 88 3B B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_408_0 {
	meta:
		name = "?write_integer@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AEAA_N_K_N@Z"
		size = 123
		refs = "0020 _errno 002b _invalid_parameter_noinfo 0041 ?length@?$format_string_parser@_W@__crt_stdio_input@@QEBA_KXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 41 68 08 48 8B FA 48 8B 41 68 48 8B 58 F8 48 85 DB 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 3D 45 84 C0 74 04 48 FF 41 70 48 83 C1 20 E8 ?? ?? ?? ?? 48 83 E8 01 74 20 48 83 E8 01 74 15 48 83 E8 02 74 0B 48 83 E8 04 75 D2 48 89 3B EB 0C 89 3B EB 08 66 89 3B EB 03 40 88 3B B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_411_0 {
	meta:
		name = "__stdio_common_vfscanf"
		size = 139
		refs = "0027 _errno 0032 _invalid_parameter_noinfo 0081 ??$?RV<lambda_082dd7c0feb7dbdaf245f261e54a6583>@@AEAV<lambda_f3caf1ecae5fe01a9a1a6239afa44510>@@V<lambda_c640b76c0755ae85b317b35c67c61e6b>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_082dd7c0feb7dbdaf245f261e54a6583>@@AEAV<lambda_f3caf1ecae5fe01a9a1a6239afa44510>@@$$QEAV<lambda_c640b76c0755ae85b317b35c67c61e6b>@@@Z"
	strings:
		$1 = { 40 55 48 8B EC 48 83 EC 60 48 8B 45 30 48 89 45 C0 4C 89 4D 10 4C 89 45 28 48 89 55 18 48 89 4D 20 48 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4A 4D 85 C0 74 E6 48 8D 45 10 48 89 55 C8 48 89 45 D8 4C 8D 4D C8 48 8D 45 18 48 89 55 D0 48 89 45 E0 4C 8D 45 D8 48 8D 45 20 48 89 45 E8 48 8D 55 D0 48 8D 45 28 48 89 45 F0 48 8D 4D 30 48 8D 45 C0 48 89 45 F8 E8 ?? ?? ?? ?? 48 83 C4 60 5D C3 }
	condition:
		$1
}

rule file_158_412_0 {
	meta:
		name = "__stdio_common_vfwscanf"
		size = 139
		refs = "0027 _errno 0032 _invalid_parameter_noinfo 0081 ??$?RV<lambda_1c23a5dd5e46d7c5fbe45428cfdcd388>@@AEAV<lambda_ad9c22e73f4850e44729a5f831ae9ec1>@@V<lambda_13a597834fd3cef18bd4341e137232db>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_1c23a5dd5e46d7c5fbe45428cfdcd388>@@AEAV<lambda_ad9c22e73f4850e44729a5f831ae9ec1>@@$$QEAV<lambda_13a597834fd3cef18bd4341e137232db>@@@Z"
	strings:
		$1 = { 40 55 48 8B EC 48 83 EC 60 48 8B 45 30 48 89 45 C0 4C 89 4D 10 4C 89 45 28 48 89 55 18 48 89 4D 20 48 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4A 4D 85 C0 74 E6 48 8D 45 10 48 89 55 C8 48 89 45 D8 4C 8D 4D C8 48 8D 45 18 48 89 55 D0 48 89 45 E0 4C 8D 45 D8 48 8D 45 20 48 89 45 E8 48 8D 55 D0 48 8D 45 28 48 89 45 F0 48 8D 4D 30 48 8D 45 C0 48 89 45 F8 E8 ?? ?? ?? ?? 48 83 C4 60 5D C3 }
	condition:
		$1
}

rule file_158_413_0 {
	meta:
		name = "__stdio_common_vsscanf"
		size = 303
		refs = "001b __security_cookie 0038 _errno 0043 _invalid_parameter_noinfo 005b strnlen 006c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00b5 memset 00f5 ?process@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QEAAHXZ 0114 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 56 41 57 48 8D 6C 24 F0 48 81 EC 10 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 00 45 33 FF 49 8B F1 48 8B FA 4C 8B F1 48 85 D2 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 BD 00 00 00 4D 85 C9 74 E3 49 8B D0 48 8B CF E8 ?? ?? ?? ?? 48 8B 55 60 48 8D 4C 24 38 48 8B D8 E8 ?? ?? ?? ?? 48 8D 04 3B 48 89 7C 24 20 33 D2 48 89 44 24 28 0F 10 44 24 20 48 89 7C 24 30 48 8D 4D B4 F2 0F 10 4C 24 30 44 8D 42 20 4C 89 74 24 60 0F 11 44 24 68 4C 89 75 80 F2 0F 11 4C 24 78 48 89 75 88 44 89 7D 90 E8 ?? ?? ?? ?? 48 8D 44 24 40 44 89 7D 94 48 89 45 D8 48 8D 4C 24 60 48 8B 45 68 48 89 45 E0 66 44 89 7D 98 44 88 7D 9A 4C 89 7D A0 44 89 7D A8 44 88 7D AC 44 89 7D B0 4C 89 7D E8 4C 89 7D F0 E8 ?? ?? ?? ?? 44 38 7C 24 50 74 0C 48 8B 4C 24 38 83 A1 A8 03 00 00 FD 48 8B 4D 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 40 01 00 00 48 81 C4 10 01 00 00 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_414_0 {
	meta:
		name = "__stdio_common_vswscanf"
		size = 281
		refs = "0031 _errno 003c _invalid_parameter_noinfo 0054 wcsnlen 0064 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00d6 ?process@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QEAAHXZ 00e1 _free_base"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 55 41 56 41 57 48 8D 68 B1 48 81 EC E0 00 00 00 45 33 FF 49 8B F1 48 8B FA 4C 8B F1 48 85 D2 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 CB FF E9 B2 00 00 00 4D 85 C9 74 E3 49 8B D0 48 8B CF E8 ?? ?? ?? ?? 48 8B 55 77 48 8D 4D 17 48 8B D8 E8 ?? ?? ?? ?? 48 8D 04 5F 48 89 7C 24 20 48 89 44 24 28 48 8D 4D 97 0F 10 44 24 20 48 8D 45 1F 48 89 7D 87 F2 0F 10 4D 87 48 89 45 F7 48 8B 45 7F 48 89 45 FF 4C 89 75 97 0F 11 45 9F 4C 89 75 B7 F2 0F 11 4D AF 48 89 75 BF 4C 89 7D C7 4C 89 7D EF 44 89 7D CF 44 88 7D D3 4C 89 7D D7 44 89 7D DF 44 88 7D E3 44 89 7D E7 4C 89 7D 07 4C 89 7D 0F E8 ?? ?? ?? ?? 48 8B 4D EF 8B D8 E8 ?? ?? ?? ?? 4C 89 7D EF 44 38 7D 2F 74 0B 48 8B 4D 17 83 A1 A8 03 00 00 FD 4C 8D 9C 24 E0 00 00 00 8B C3 49 8B 5B 20 49 8B 73 28 49 8B 7B 30 49 8B E3 41 5F 41 5E 5D C3 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "_umask"
		size = 34
		refs = "0015 _umask_s"
	strings:
		$1 = { 48 83 EC 28 83 64 24 30 00 48 8D 54 24 30 81 E1 80 01 00 00 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "_umask_s"
		size = 61
		refs = "000a _errno 0015 _invalid_parameter_noinfo 0022 _umaskval"
	strings:
		$1 = { 48 83 EC 28 48 85 D2 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 18 8B 05 ?? ?? ?? ?? 89 02 F7 C1 7F FE FF FF 75 D9 89 0D ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_161_4_0 {
	meta:
		name = "__dcrt_multibyte_check_type"
		size = 145
		refs = "0062 __acrt_GetStringTypeA"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 57 48 83 EC 50 4C 8B D2 33 DB 41 8A F9 41 0F B7 F0 8B D1 49 8B 42 08 39 58 08 75 04 33 C0 EB 57 8B 48 04 4C 8D 44 24 68 8B C2 88 54 24 69 C1 E8 08 88 44 24 68 33 C0 89 44 24 40 8D 50 01 89 54 24 30 48 8D 44 24 40 89 4C 24 28 44 8D 4A 01 49 8B CA 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 74 BC 66 39 5C 24 42 75 B5 66 85 74 24 40 0F 95 C1 40 3A CF 0F 94 C3 8B C3 48 8B 5C 24 60 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_161_6_0 {
	meta:
		name = "_ismbcalnum_l"
		size = 124
		refs = "000e ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 005b __dcrt_multibyte_check_type"
	strings:
		$1 = { 40 53 48 83 EC 40 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 81 FB FF 00 00 00 77 2D 48 8B 44 24 28 BA 01 00 00 00 44 0F B6 C3 48 8B 08 B8 07 01 00 00 66 42 85 04 41 75 2A 48 8B 44 24 30 41 84 54 00 19 75 1E 33 D2 EB 1A 41 B8 07 01 00 00 48 8D 54 24 28 41 B9 01 00 00 00 8B CB E8 ?? ?? ?? ?? 8B D0 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 8B C2 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "_ldxp_addh"
		size = 850
		refs = "003c _ldunscale 004f _ldtest 007c _fperrraise 0084 _LNan_C 0205 _ld_int 0212 _ldscale"
	strings:
		$1 = { F2 0F 11 54 24 18 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 33 F6 F2 0F 11 55 60 0F 29 74 24 30 48 8B F9 4C 63 F2 85 D2 0F 84 06 03 00 00 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 66 3B F0 7D 68 66 83 F8 02 74 54 48 8B CF E8 ?? ?? ?? ?? 66 85 C0 7E 47 66 83 F8 02 0F 84 D7 02 00 00 0F B7 47 06 B9 00 80 00 00 66 33 45 5E 66 85 C1 0F 84 C1 02 00 00 8D 4E 01 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 07 41 83 FE 01 0F 8E A3 02 00 00 48 89 77 08 E9 9A 02 00 00 F2 0F 10 45 58 F2 0F 11 07 E9 8C 02 00 00 66 85 C0 0F 89 83 02 00 00 41 BD 00 08 00 00 8B DE 4D 8B FE 45 85 F6 0F 8E 6F 02 00 00 4C 8D 67 F8 0F 57 F6 F2 0F 10 04 F7 48 8D 55 D8 48 8D 4D 50 F2 0F 11 45 D8 E8 ?? ?? ?? ?? 33 C9 66 3B C8 0F 8C 46 02 00 00 66 85 C0 0F 84 22 02 00 00 0F BF 55 50 0F BF 45 48 8B CA F2 0F 10 4D 58 2B C8 83 F9 E6 7F 5F 66 0F 2E CE 7A 02 74 57 8B CB 48 8B C6 FF C1 48 FF C0 49 3B C7 7D 0D F2 0F 10 04 C7 66 0F 2E C6 7A EB 75 E9 41 8D 46 FF 3B C8 7D 04 FF C1 EB 07 41 3B CE 75 02 FF C9 48 63 D1 48 3B F2 7D 11 48 8B 44 D7 F8 48 89 04 D7 48 FF CA 48 3B D6 7F EF F2 0F 11 0C F7 F2 0F 11 75 58 E9 A2 01 00 00 B8 1A 00 00 00 3B C8 7C 12 66 0F 2E CE 7A 02 74 0A 44 8B EA FF C3 E9 80 01 00 00 F2 0F 58 0C F7 66 0F 2E CE F2 0F 11 0C F7 7A 3A 75 38 48 8B C6 48 FF C0 49 3B C7 7D 13 F2 0F 10 04 C7 66 0F 2E C6 F2 0F 11 44 C7 F8 7A E7 75 E5 4A 83 64 FF F8 00 F2 0F 10 04 F7 66 0F 2E C6 0F 28 C8 7A 06 0F 84 63 01 00 00 48 8D 55 58 F2 0F 11 4D 58 48 8D 4D 48 E8 ?? ?? ?? ?? 0F BF 55 48 41 8D 4D E6 3B CA 0F 8D 92 00 00 00 66 41 2B D5 48 8D 4D 58 66 83 C2 1A E8 ?? ?? ?? ?? 0F BF 55 48 48 8D 4D 58 E8 ?? ?? ?? ?? F2 0F 10 04 F7 F2 0F 5C 45 58 66 0F 2E C6 F2 0F 11 04 F7 7A 26 75 24 48 8B C6 48 FF C0 49 3B C7 7D 13 F2 0F 10 04 C7 66 0F 2E C6 F2 0F 11 44 C7 F8 7A E7 75 E5 4A 83 64 FF F8 00 48 FF CE 49 83 EC 08 83 EB 01 75 0B 41 BD 00 08 00 00 E9 AB 00 00 00 F2 41 0F 10 04 24 48 8D 55 60 48 8D 4D 50 F2 0F 11 45 60 E8 ?? ?? ?? ?? 44 0F BF 6D 50 E9 89 00 00 00 44 8D 7B 01 45 3B FE 0F 84 A2 00 00 00 F2 0F 10 04 F7 48 8D 4D 50 48 63 C3 F2 0F 11 45 58 48 8D 1C C7 48 8B D3 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8B CB E8 ?? ?? ?? ?? 0F BF 55 50 48 8B CB E8 ?? ?? ?? ?? F2 0F 10 45 58 F2 0F 10 0C F7 44 0F BF 6D 50 F2 0F 5C C1 66 0F 2E C6 F2 0F 11 45 58 7A 09 75 07 F2 0F 11 4D 60 EB 05 F2 0F 11 45 60 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 41 8B DF 4D 8B FE 48 FF C6 49 83 C4 08 41 3B DE 0F 8C B5 FD FF FF EB 1B F2 0F 10 45 58 48 63 C3 FF C3 F2 0F 11 04 C7 41 3B DE 7D 07 48 63 C3 48 89 0C C7 48 8B C7 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "_dxp_addh"
		size = 850
		refs = "003c _dunscale 004f _dtest 007c _fperrraise 0084 _Nan_C 0205 _d_int 0212 _dscale"
	strings:
		$1 = { F2 0F 11 54 24 18 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 33 F6 F2 0F 11 55 60 0F 29 74 24 30 48 8B F9 4C 63 F2 85 D2 0F 84 06 03 00 00 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 66 3B F0 7D 68 66 83 F8 02 74 54 48 8B CF E8 ?? ?? ?? ?? 66 85 C0 7E 47 66 83 F8 02 0F 84 D7 02 00 00 0F B7 47 06 B9 00 80 00 00 66 33 45 5E 66 85 C1 0F 84 C1 02 00 00 8D 4E 01 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 07 41 83 FE 01 0F 8E A3 02 00 00 48 89 77 08 E9 9A 02 00 00 F2 0F 10 45 58 F2 0F 11 07 E9 8C 02 00 00 66 85 C0 0F 89 83 02 00 00 41 BD 00 08 00 00 8B DE 4D 8B FE 45 85 F6 0F 8E 6F 02 00 00 4C 8D 67 F8 0F 57 F6 F2 0F 10 04 F7 48 8D 55 D8 48 8D 4D 50 F2 0F 11 45 D8 E8 ?? ?? ?? ?? 33 C9 66 3B C8 0F 8C 46 02 00 00 66 85 C0 0F 84 22 02 00 00 0F BF 55 50 0F BF 45 48 8B CA F2 0F 10 4D 58 2B C8 83 F9 E6 7F 5F 66 0F 2E CE 7A 02 74 57 8B CB 48 8B C6 FF C1 48 FF C0 49 3B C7 7D 0D F2 0F 10 04 C7 66 0F 2E C6 7A EB 75 E9 41 8D 46 FF 3B C8 7D 04 FF C1 EB 07 41 3B CE 75 02 FF C9 48 63 D1 48 3B F2 7D 11 48 8B 44 D7 F8 48 89 04 D7 48 FF CA 48 3B D6 7F EF F2 0F 11 0C F7 F2 0F 11 75 58 E9 A2 01 00 00 B8 1A 00 00 00 3B C8 7C 12 66 0F 2E CE 7A 02 74 0A 44 8B EA FF C3 E9 80 01 00 00 F2 0F 58 0C F7 66 0F 2E CE F2 0F 11 0C F7 7A 3A 75 38 48 8B C6 48 FF C0 49 3B C7 7D 13 F2 0F 10 04 C7 66 0F 2E C6 F2 0F 11 44 C7 F8 7A E7 75 E5 4A 83 64 FF F8 00 F2 0F 10 04 F7 66 0F 2E C6 0F 28 C8 7A 06 0F 84 63 01 00 00 48 8D 55 58 F2 0F 11 4D 58 48 8D 4D 48 E8 ?? ?? ?? ?? 0F BF 55 48 41 8D 4D E6 3B CA 0F 8D 92 00 00 00 66 41 2B D5 48 8D 4D 58 66 83 C2 1A E8 ?? ?? ?? ?? 0F BF 55 48 48 8D 4D 58 E8 ?? ?? ?? ?? F2 0F 10 04 F7 F2 0F 5C 45 58 66 0F 2E C6 F2 0F 11 04 F7 7A 26 75 24 48 8B C6 48 FF C0 49 3B C7 7D 13 F2 0F 10 04 C7 66 0F 2E C6 F2 0F 11 44 C7 F8 7A E7 75 E5 4A 83 64 FF F8 00 48 FF CE 49 83 EC 08 83 EB 01 75 0B 41 BD 00 08 00 00 E9 AB 00 00 00 F2 41 0F 10 04 24 48 8D 55 60 48 8D 4D 50 F2 0F 11 45 60 E8 ?? ?? ?? ?? 44 0F BF 6D 50 E9 89 00 00 00 44 8D 7B 01 45 3B FE 0F 84 A2 00 00 00 F2 0F 10 04 F7 48 8D 4D 50 48 63 C3 F2 0F 11 45 58 48 8D 1C C7 48 8B D3 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8B CB E8 ?? ?? ?? ?? 0F BF 55 50 48 8B CB E8 ?? ?? ?? ?? F2 0F 10 45 58 F2 0F 10 0C F7 44 0F BF 6D 50 F2 0F 5C C1 66 0F 2E C6 F2 0F 11 45 58 7A 09 75 07 F2 0F 11 4D 60 EB 05 F2 0F 11 45 60 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 41 8B DF 4D 8B FE 48 FF C6 49 83 C4 08 41 3B DE 0F 8C B5 FD FF FF EB 1B F2 0F 10 45 58 48 63 C3 FF C3 F2 0F 11 04 C7 41 3B DE 7D 07 48 63 C3 48 89 0C C7 48 8B C7 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_162_1_0 {
	meta:
		name = "_ldxp_addx"
		size = 111
		refs = "0034 __real@0000000000000000 0043 _ldxp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 25 F2 0F 10 16 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 15 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 08 3B FD 7C DB 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_229_1_0 {
	meta:
		name = "_dxp_addx"
		size = 111
		refs = "0034 __real@0000000000000000 0043 _dxp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 25 F2 0F 10 16 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 15 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 08 3B FD 7C DB 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_162_2_0 {
	meta:
		name = "_ldxp_getw"
		size = 80
		altNames = "_dxp_getw"
	strings:
		$1 = { 85 D2 75 04 0F 57 C0 C3 83 FA 01 74 3E F2 0F 10 11 0F 57 C0 66 0F 2E D0 7A 02 74 2F 83 FA 01 7E 0D F2 0F 10 49 08 66 0F 2E C8 7A 02 74 1D 83 FA 02 75 09 F2 0F 58 51 08 0F 28 C2 C3 F2 0F 10 41 10 F2 0F 58 41 08 F2 0F 58 C2 C3 F2 0F 10 01 C3 }
	condition:
		$1
}

rule file_162_3_0 {
	meta:
		name = "_ldxp_invx"
		size = 330
		refs = "0035 _ldtest 005b _LInf_C 0085 memcpy 008d __real@bff0000000000000 0097 _ldxp_mulh 00ad __real@3ff0000000000000 00bb _ldxp_setw 00e2 _ldxp_mulx 00f4 _ldxp_addh 0119 _ldxp_addx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 33 ED 0F 29 70 D8 48 63 FA 4D 8B F8 48 8B D9 85 D2 0F 84 EF 00 00 00 E8 ?? ?? ?? ?? 66 3B E8 7F 2A 8D 75 01 66 3B C6 75 08 48 89 2B E9 D5 00 00 00 66 85 C0 0F 85 CC 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 E9 BB 00 00 00 F2 0F 10 33 4C 8B F7 49 C1 E6 03 48 8B D3 4D 8B C6 4B 8D 2C 3E 48 8B CD 4D 8D 24 2E E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? BE 01 00 00 00 3B FE 7E 05 F2 0F 58 73 08 F2 0F 10 15 ?? ?? ?? ?? 8B D7 F2 0F 5E D6 48 8B CB E8 ?? ?? ?? ?? 3B FE 7E 60 4D 8B C6 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C5 8B D7 49 8B CF E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C3 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4D 8B C7 8B D7 48 8B CB E8 ?? ?? ?? ?? 03 F6 3B F7 7C A0 48 8B 6C 24 68 48 8B C3 48 8B 5C 24 60 48 8B 74 24 70 48 8B 7C 24 78 0F 28 74 24 30 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_229_3_0 {
	meta:
		name = "_dxp_invx"
		size = 330
		refs = "0035 _dtest 005b _Inf_C 0085 memcpy 008d __real@bff0000000000000 0097 _dxp_mulh 00ad __real@3ff0000000000000 00bb _dxp_setw 00e2 _dxp_mulx 00f4 _dxp_addh 0119 _dxp_addx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 33 ED 0F 29 70 D8 48 63 FA 4D 8B F8 48 8B D9 85 D2 0F 84 EF 00 00 00 E8 ?? ?? ?? ?? 66 3B E8 7F 2A 8D 75 01 66 3B C6 75 08 48 89 2B E9 D5 00 00 00 66 85 C0 0F 85 CC 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 E9 BB 00 00 00 F2 0F 10 33 4C 8B F7 49 C1 E6 03 48 8B D3 4D 8B C6 4B 8D 2C 3E 48 8B CD 4D 8D 24 2E E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? BE 01 00 00 00 3B FE 7E 05 F2 0F 58 73 08 F2 0F 10 15 ?? ?? ?? ?? 8B D7 F2 0F 5E D6 48 8B CB E8 ?? ?? ?? ?? 3B FE 7E 60 4D 8B C6 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C5 8B D7 49 8B CF E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C3 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4D 8B C7 8B D7 48 8B CB E8 ?? ?? ?? ?? 03 F6 3B F7 7C A0 48 8B 6C 24 68 48 8B C3 48 8B 5C 24 60 48 8B 74 24 70 48 8B 7C 24 78 0F 28 74 24 30 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_162_4_0 {
	meta:
		name = "_ldxp_ldexpx"
		size = 110
		refs = "0032 ldexp 003a __real@0000000000000000"
		altNames = "_dxp_ldexpx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 DB 45 8B F0 8B EA 48 8B F1 85 D2 7E 29 48 8B F9 F2 0F 10 07 41 8B D6 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? F2 0F 11 07 7A 02 74 0A FF C3 48 83 C7 08 3B DD 7C DA 48 8B 5C 24 30 48 8B C6 48 8B 74 24 40 48 8B 6C 24 38 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_162_5_0 {
	meta:
		name = "_ldxp_movx"
		size = 36
		refs = "0017 memcpy"
		altNames = "_dxp_movx"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 48 8B D9 4C 63 C2 48 8B D0 49 C1 E0 03 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_162_6_0 {
	meta:
		name = "_ldxp_mulh"
		size = 492
		refs = "0027 __security_cookie 0053 _ldtest 006e _fperrraise 0132 _ldunscale 0140 _ld_int 014d _ldscale 015d _ldxp_addh 01c3 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 0F 29 74 24 70 0F 29 7C 24 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 D0 45 33 E4 4C 63 FA 0F 28 FA 48 8B F9 85 D2 7E 58 0F 28 C2 F2 0F 59 01 48 8D 4D B0 F2 0F 11 45 B0 E8 ?? ?? ?? ?? 0F B7 F0 66 44 3B E0 7F 37 41 8D 5C 24 01 66 83 F8 02 75 07 8B CB E8 ?? ?? ?? ?? F2 0F 10 45 B0 F2 0F 11 07 66 44 3B E6 0F 8D 33 01 00 00 44 3B FB 0F 8E 2A 01 00 00 4C 89 67 08 E9 21 01 00 00 4C 89 27 BB 01 00 00 00 41 8B C4 89 45 A4 44 8B F3 4D 8B EC 45 85 FF 0F 8E 04 01 00 00 4C 8D 65 B0 8B F3 4C 2B E7 0F 57 F6 48 83 FE 04 7D 4D 42 8D 14 30 4A 8D 04 2E 48 8D 0C C7 41 3B D7 7D 2E F2 0F 10 01 66 0F 2E C6 7A 02 74 22 48 83 21 00 44 03 F3 F2 0F 59 C7 03 D3 48 03 F3 F2 41 0F 11 04 0C 48 83 C1 08 48 83 FE 04 7C CF EB 0E 48 83 64 F5 B0 00 BE 08 00 00 00 44 8B F6 F2 0F 10 45 B0 66 0F 2E C6 7A 06 0F 84 94 00 00 00 48 8D 55 A8 F2 0F 11 45 A8 48 8D 4D A0 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8D 4D A8 E8 ?? ?? ?? ?? 0F BF 55 A0 48 8D 4D A8 E8 ?? ?? ?? ?? F2 0F 10 55 A8 41 8B D7 48 8B CF E8 ?? ?? ?? ?? F2 0F 10 55 B0 41 8B D7 F2 0F 5C 55 A8 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 3B DE 7D 1C F2 0F 10 44 C5 B0 66 0F 2E C6 F2 0F 11 44 C5 A8 7A 02 74 08 48 03 C3 48 3B C6 7C E4 8B 45 A4 4C 03 EB 03 C3 49 83 EC 08 44 2B F3 89 45 A4 48 2B F3 4D 3B EF 0F 8C 08 FF FF FF 48 8B C7 48 8B 4D D0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 D0 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 80 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_229_6_0 {
	meta:
		name = "_dxp_mulh"
		size = 492
		refs = "0027 __security_cookie 0053 _dtest 006e _fperrraise 0132 _dunscale 0140 _d_int 014d _dscale 015d _dxp_addh 01c3 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 0F 29 74 24 70 0F 29 7C 24 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 D0 45 33 E4 4C 63 FA 0F 28 FA 48 8B F9 85 D2 7E 58 0F 28 C2 F2 0F 59 01 48 8D 4D B0 F2 0F 11 45 B0 E8 ?? ?? ?? ?? 0F B7 F0 66 44 3B E0 7F 37 41 8D 5C 24 01 66 83 F8 02 75 07 8B CB E8 ?? ?? ?? ?? F2 0F 10 45 B0 F2 0F 11 07 66 44 3B E6 0F 8D 33 01 00 00 44 3B FB 0F 8E 2A 01 00 00 4C 89 67 08 E9 21 01 00 00 4C 89 27 BB 01 00 00 00 41 8B C4 89 45 A4 44 8B F3 4D 8B EC 45 85 FF 0F 8E 04 01 00 00 4C 8D 65 B0 8B F3 4C 2B E7 0F 57 F6 48 83 FE 04 7D 4D 42 8D 14 30 4A 8D 04 2E 48 8D 0C C7 41 3B D7 7D 2E F2 0F 10 01 66 0F 2E C6 7A 02 74 22 48 83 21 00 44 03 F3 F2 0F 59 C7 03 D3 48 03 F3 F2 41 0F 11 04 0C 48 83 C1 08 48 83 FE 04 7C CF EB 0E 48 83 64 F5 B0 00 BE 08 00 00 00 44 8B F6 F2 0F 10 45 B0 66 0F 2E C6 7A 06 0F 84 94 00 00 00 48 8D 55 A8 F2 0F 11 45 A8 48 8D 4D A0 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8D 4D A8 E8 ?? ?? ?? ?? 0F BF 55 A0 48 8D 4D A8 E8 ?? ?? ?? ?? F2 0F 10 55 A8 41 8B D7 48 8B CF E8 ?? ?? ?? ?? F2 0F 10 55 B0 41 8B D7 F2 0F 5C 55 A8 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 3B DE 7D 1C F2 0F 10 44 C5 B0 66 0F 2E C6 F2 0F 11 44 C5 A8 7A 02 74 08 48 03 C3 48 3B C6 7C E4 8B 45 A4 4C 03 EB 03 C3 49 83 EC 08 44 2B F3 89 45 A4 48 2B F3 4D 3B EF 0F 8C 08 FF FF FF 48 8B C7 48 8B 4D D0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 D0 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 80 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_162_7_0 {
	meta:
		name = "_ldxp_mulx"
		size = 257
		refs = "0042 __real@0000000000000000 005f _ldxp_mulh 007f memcpy 00d5 _ldxp_addx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 63 E9 49 8B D8 48 63 FA 48 8B F1 85 D2 0F 84 B1 00 00 00 45 85 C9 0F 84 A8 00 00 00 F2 41 0F 10 10 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 12 F2 41 0F 10 40 08 66 0F 2E 05 ?? ?? ?? ?? 7A 0B 75 09 8B D7 E8 ?? ?? ?? ?? EB 7C 4C 8B 64 24 70 48 8B D1 4C 8B FF 49 8B CC 49 C1 E7 03 4D 8B C7 4F 8D 2C 27 E8 ?? ?? ?? ?? F2 0F 10 13 8B D7 48 8B CE E8 ?? ?? ?? ?? 41 BE 01 00 00 00 EB 43 F2 42 0F 10 04 F3 66 0F 2E 05 ?? ?? ?? ?? 7A 02 74 36 4D 8B C7 49 8B D4 49 8B CD E8 ?? ?? ?? ?? F2 42 0F 10 14 F3 8B D7 49 8B CD E8 ?? ?? ?? ?? 44 8B CF 4D 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 49 FF C6 4C 3B F5 7C B8 48 8B 5C 24 50 48 8B C6 48 8B 74 24 60 48 8B 6C 24 58 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_229_7_0 {
	meta:
		name = "_dxp_mulx"
		size = 257
		refs = "0042 __real@0000000000000000 005f _dxp_mulh 007f memcpy 00d5 _dxp_addx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 63 E9 49 8B D8 48 63 FA 48 8B F1 85 D2 0F 84 B1 00 00 00 45 85 C9 0F 84 A8 00 00 00 F2 41 0F 10 10 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 12 F2 41 0F 10 40 08 66 0F 2E 05 ?? ?? ?? ?? 7A 0B 75 09 8B D7 E8 ?? ?? ?? ?? EB 7C 4C 8B 64 24 70 48 8B D1 4C 8B FF 49 8B CC 49 C1 E7 03 4D 8B C7 4F 8D 2C 27 E8 ?? ?? ?? ?? F2 0F 10 13 8B D7 48 8B CE E8 ?? ?? ?? ?? 41 BE 01 00 00 00 EB 43 F2 42 0F 10 04 F3 66 0F 2E 05 ?? ?? ?? ?? 7A 02 74 36 4D 8B C7 49 8B D4 49 8B CD E8 ?? ?? ?? ?? F2 42 0F 10 14 F3 8B D7 49 8B CD E8 ?? ?? ?? ?? 44 8B CF 4D 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 49 FF C6 4C 3B F5 7C B8 48 8B 5C 24 50 48 8B C6 48 8B 74 24 60 48 8B 6C 24 58 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_162_8_0 {
	meta:
		name = "_ldxp_setw"
		size = 273
		refs = "003b _ldunscale 006b _ld_int 007a _ldscale 009d __real@0000000000000000"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 48 83 EC 30 33 ED 0F 29 70 D8 F2 0F 11 50 08 0F 28 F2 8B FA 48 8B D9 85 D2 0F 8E D3 00 00 00 83 FA 01 0F 84 C6 00 00 00 48 8D 50 08 48 8D 48 10 E8 ?? ?? ?? ?? 66 85 C0 0F 84 AA 00 00 00 66 3B E8 7D 13 F2 0F 10 44 24 50 F2 0F 11 03 48 89 6B 08 E9 9C 00 00 00 BA 1A 00 00 00 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F BF 54 24 58 48 8D 4C 24 50 E8 ?? ?? ?? ?? F2 0F 10 44 24 50 48 8D 73 08 F2 0F 11 03 F2 0F 5C F0 F2 0F 11 36 83 FF 02 7E 63 66 0F 2E 35 ?? ?? ?? ?? 7A 08 75 06 48 89 6B 10 EB 51 48 8B D6 48 8D 4C 24 58 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8B CE E8 ?? ?? ?? ?? 0F BF 54 24 58 48 8B CE E8 ?? ?? ?? ?? F2 0F 5C 36 F2 0F 11 73 10 83 FF 03 7E 1C 66 0F 2E 35 ?? ?? ?? ?? 7A 02 74 10 48 89 6B 18 EB 0A F2 0F 10 74 24 50 F2 0F 11 33 0F 28 74 24 20 48 8B C3 48 8B 5C 24 60 48 83 C4 30 5F 5E 5D C3 }
	condition:
		$1
}

rule file_229_8_0 {
	meta:
		name = "_dxp_setw"
		size = 273
		refs = "003b _dunscale 006b _d_int 007a _dscale 009d __real@0000000000000000"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 48 83 EC 30 33 ED 0F 29 70 D8 F2 0F 11 50 08 0F 28 F2 8B FA 48 8B D9 85 D2 0F 8E D3 00 00 00 83 FA 01 0F 84 C6 00 00 00 48 8D 50 08 48 8D 48 10 E8 ?? ?? ?? ?? 66 85 C0 0F 84 AA 00 00 00 66 3B E8 7D 13 F2 0F 10 44 24 50 F2 0F 11 03 48 89 6B 08 E9 9C 00 00 00 BA 1A 00 00 00 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F BF 54 24 58 48 8D 4C 24 50 E8 ?? ?? ?? ?? F2 0F 10 44 24 50 48 8D 73 08 F2 0F 11 03 F2 0F 5C F0 F2 0F 11 36 83 FF 02 7E 63 66 0F 2E 35 ?? ?? ?? ?? 7A 08 75 06 48 89 6B 10 EB 51 48 8B D6 48 8D 4C 24 58 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8B CE E8 ?? ?? ?? ?? 0F BF 54 24 58 48 8B CE E8 ?? ?? ?? ?? F2 0F 5C 36 F2 0F 11 73 10 83 FF 03 7E 1C 66 0F 2E 35 ?? ?? ?? ?? 7A 02 74 10 48 89 6B 18 EB 0A F2 0F 10 74 24 50 F2 0F 11 33 0F 28 74 24 20 48 8B C3 48 8B 5C 24 60 48 83 C4 30 5F 5E 5D C3 }
	condition:
		$1
}

rule file_162_9_0 {
	meta:
		name = "_ldxp_sqrtx"
		size = 351
		refs = "0031 _ldtest 006c sqrt 0074 __real@3ff0000000000000 0082 _ldxp_setw 009b memcpy 00a3 __real@bfe0000000000000 00ad _ldxp_mulh 00c2 _ldxp_mulx 00df __real@3ff8000000000000 00e9 _ldxp_addh 012d _fperrraise 0135 _LNan_C"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 33 F6 48 63 FA 49 8B E8 48 8B D9 85 D2 0F 84 0D 01 00 00 E8 ?? ?? ?? ?? 0F 57 C0 66 3B F0 0F 8E E0 00 00 00 F2 0F 10 0B 66 0F 2F C1 0F 87 D8 00 00 00 4C 8B F7 49 C1 E6 03 49 8D 34 2E 4D 8D 3C 36 83 FF 01 7E 05 F2 0F 58 4B 08 0F 28 C1 E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 F2 0F 5E D0 48 8B CE E8 ?? ?? ?? ?? 41 BC 02 00 00 00 41 3B FC 7E 79 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C3 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CD E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 45 03 E4 44 3B E7 7C 87 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 1C 66 0F 2F 03 76 16 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 48 8B 6C 24 58 48 8B C3 48 8B 5C 24 50 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_229_9_0 {
	meta:
		name = "_dxp_sqrtx"
		size = 351
		refs = "0031 _dtest 006c sqrt 0074 __real@3ff0000000000000 0082 _dxp_setw 009b memcpy 00a3 __real@bfe0000000000000 00ad _dxp_mulh 00c2 _dxp_mulx 00df __real@3ff8000000000000 00e9 _dxp_addh 012d _fperrraise 0135 _Nan_C"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 33 F6 48 63 FA 49 8B E8 48 8B D9 85 D2 0F 84 0D 01 00 00 E8 ?? ?? ?? ?? 0F 57 C0 66 3B F0 0F 8E E0 00 00 00 F2 0F 10 0B 66 0F 2F C1 0F 87 D8 00 00 00 4C 8B F7 49 C1 E6 03 49 8D 34 2E 4D 8D 3C 36 83 FF 01 7E 05 F2 0F 58 4B 08 0F 28 C1 E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 F2 0F 5E D0 48 8B CE E8 ?? ?? ?? ?? 41 BC 02 00 00 00 41 3B FC 7E 79 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C3 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CD E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 45 03 E4 44 3B E7 7C 87 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 1C 66 0F 2F 03 76 16 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 48 8B 6C 24 58 48 8B C3 48 8B 5C 24 50 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_162_10_0 {
	meta:
		name = "_ldxp_subx"
		size = 118
		refs = "0034 __real@0000000000000000 003f __xmm@80000000000000008000000000000000 004a _ldxp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 2C F2 0F 10 16 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 1C 0F 57 15 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 08 3B FD 7C D4 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_229_10_0 {
	meta:
		name = "_dxp_subx"
		size = 118
		refs = "0034 __real@0000000000000000 003f __xmm@80000000000000008000000000000000 004a _dxp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 2C F2 0F 10 16 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 1C 0F 57 15 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 08 3B FD 7C D4 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_162_11_0 {
	meta:
		name = "fmal"
		size = 677
		refs = "0024 __security_cookie 0039 __fma3_is_available 009a _ldunscale 0177 _ldscale 0187 _ldxp_setw 01ba _ldxp_mulh 01c7 __real@0000000000000000 01fd _ldxp_addx 021a _ldxp_getw 026c _fperrraise 0274 _LNan_C 0280 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 48 8D 68 A1 48 81 EC F0 00 00 00 0F 29 70 C8 0F 29 78 B8 44 0F 29 40 A8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F7 33 F6 F2 0F 11 44 24 38 39 35 ?? ?? ?? ?? 0F 28 FA F2 0F 11 4D 9F 0F 28 F1 F2 0F 11 55 87 44 0F 28 C0 74 2D F2 0F 11 44 24 38 F2 0F 11 55 87 F2 0F 10 45 87 0F 28 D8 F2 0F 11 4D 9F F2 0F 10 44 24 38 F2 0F 10 4D 9F C4 E2 F1 A9 C3 E9 F8 01 00 00 48 8D 55 97 F2 0F 11 45 97 48 8D 4C 24 28 F2 0F 11 4D AF F2 0F 11 54 24 30 E8 ?? ?? ?? ?? 41 BE 02 00 00 00 0F B7 D8 66 41 3B C6 75 09 41 0F 28 C0 E9 C2 01 00 00 48 8D 55 AF 48 8D 4C 24 24 E8 ?? ?? ?? ?? 0F B7 F8 66 41 3B C6 75 08 0F 28 C6 E9 A3 01 00 00 48 8D 54 24 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 66 41 3B C6 75 08 0F 28 C7 E9 86 01 00 00 B9 01 00 00 00 66 3B D9 0F 84 38 01 00 00 66 3B F9 0F 84 2F 01 00 00 66 3B C1 74 DC 66 85 DB 0F 84 46 01 00 00 66 85 FF 0F 84 3D 01 00 00 66 85 C0 0F 84 34 01 00 00 0F BF 44 24 28 BA 00 80 00 00 0F B7 4C 24 20 0F BF 5C 24 24 03 D8 0F B7 45 85 66 33 45 A5 66 2B CB 66 33 45 8D 66 89 4C 24 20 66 85 C2 0F 84 01 01 00 00 41 8D 04 0E BF 04 00 00 00 66 3B C7 0F 87 EF 00 00 00 0F BF D1 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 55 97 48 8D 4D B7 8B D7 E8 ?? ?? ?? ?? F2 0F 10 55 AF 48 8D 4D 87 41 8B D6 E8 ?? ?? ?? ?? F2 0F 10 54 24 30 48 8D 4D 9F 41 8B D6 E8 ?? ?? ?? ?? F2 0F 10 55 87 48 8D 4D B7 8B D7 E8 ?? ?? ?? ?? F2 0F 10 45 8F 66 0F 2E 05 ?? ?? ?? ?? 7A 02 74 32 F2 0F 10 55 97 48 8D 4D D7 8B D7 E8 ?? ?? ?? ?? F2 0F 10 55 8F 48 8D 4D D7 8B D7 E8 ?? ?? ?? ?? 44 8B CF 4C 8D 45 D7 8B D7 48 8D 4D B7 E8 ?? ?? ?? ?? 45 8B CE 4C 8D 45 9F 8B D7 48 8D 4D B7 E8 ?? ?? ?? ?? 8B D7 48 8D 4D B7 E8 ?? ?? ?? ?? 8B D3 F2 0F 11 44 24 30 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 EB 40 66 85 DB 74 2E 66 85 FF 74 29 66 3B C1 75 16 0F B7 45 85 BA 00 80 00 00 66 33 45 A5 66 33 45 8D 66 85 C2 75 0E F2 41 0F 59 F0 F2 0F 58 F7 E9 62 FE FF FF E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 48 8B 4D F7 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 F0 00 00 00 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 49 8B E3 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_229_11_0 {
	meta:
		name = "fma"
		size = 677
		refs = "0024 __security_cookie 0039 __fma3_is_available 009a _dunscale 0177 _dscale 0187 _dxp_setw 01ba _dxp_mulh 01c7 __real@0000000000000000 01fd _dxp_addx 021a _dxp_getw 026c _fperrraise 0274 _Nan_C 0280 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 48 8D 68 A1 48 81 EC F0 00 00 00 0F 29 70 C8 0F 29 78 B8 44 0F 29 40 A8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F7 33 F6 F2 0F 11 44 24 38 39 35 ?? ?? ?? ?? 0F 28 FA F2 0F 11 4D 9F 0F 28 F1 F2 0F 11 55 87 44 0F 28 C0 74 2D F2 0F 11 44 24 38 F2 0F 11 55 87 F2 0F 10 45 87 0F 28 D8 F2 0F 11 4D 9F F2 0F 10 44 24 38 F2 0F 10 4D 9F C4 E2 F1 A9 C3 E9 F8 01 00 00 48 8D 55 97 F2 0F 11 45 97 48 8D 4C 24 28 F2 0F 11 4D AF F2 0F 11 54 24 30 E8 ?? ?? ?? ?? 41 BE 02 00 00 00 0F B7 D8 66 41 3B C6 75 09 41 0F 28 C0 E9 C2 01 00 00 48 8D 55 AF 48 8D 4C 24 24 E8 ?? ?? ?? ?? 0F B7 F8 66 41 3B C6 75 08 0F 28 C6 E9 A3 01 00 00 48 8D 54 24 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 66 41 3B C6 75 08 0F 28 C7 E9 86 01 00 00 B9 01 00 00 00 66 3B D9 0F 84 38 01 00 00 66 3B F9 0F 84 2F 01 00 00 66 3B C1 74 DC 66 85 DB 0F 84 46 01 00 00 66 85 FF 0F 84 3D 01 00 00 66 85 C0 0F 84 34 01 00 00 0F BF 44 24 28 BA 00 80 00 00 0F B7 4C 24 20 0F BF 5C 24 24 03 D8 0F B7 45 85 66 33 45 A5 66 2B CB 66 33 45 8D 66 89 4C 24 20 66 85 C2 0F 84 01 01 00 00 41 8D 04 0E BF 04 00 00 00 66 3B C7 0F 87 EF 00 00 00 0F BF D1 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 55 97 48 8D 4D B7 8B D7 E8 ?? ?? ?? ?? F2 0F 10 55 AF 48 8D 4D 87 41 8B D6 E8 ?? ?? ?? ?? F2 0F 10 54 24 30 48 8D 4D 9F 41 8B D6 E8 ?? ?? ?? ?? F2 0F 10 55 87 48 8D 4D B7 8B D7 E8 ?? ?? ?? ?? F2 0F 10 45 8F 66 0F 2E 05 ?? ?? ?? ?? 7A 02 74 32 F2 0F 10 55 97 48 8D 4D D7 8B D7 E8 ?? ?? ?? ?? F2 0F 10 55 8F 48 8D 4D D7 8B D7 E8 ?? ?? ?? ?? 44 8B CF 4C 8D 45 D7 8B D7 48 8D 4D B7 E8 ?? ?? ?? ?? 45 8B CE 4C 8D 45 9F 8B D7 48 8D 4D B7 E8 ?? ?? ?? ?? 8B D7 48 8D 4D B7 E8 ?? ?? ?? ?? 8B D3 F2 0F 11 44 24 30 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 EB 40 66 85 DB 74 2E 66 85 FF 74 29 66 3B C1 75 16 0F B7 45 85 BA 00 80 00 00 66 33 45 A5 66 33 45 8D 66 85 C2 75 0E F2 41 0F 59 F0 F2 0F 58 F7 E9 62 FE FF FF E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 48 8B 4D F7 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 F0 00 00 00 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 49 8B E3 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_162_12_0 {
	meta:
		name = "intrinsic_fma"
		size = 48
	strings:
		$1 = { 48 8B C4 F2 0F 11 40 08 F2 0F 11 48 10 F2 0F 10 40 10 F2 0F 11 50 18 0F 28 D0 F2 0F 10 48 18 0F 28 D9 F2 0F 10 48 08 0F 28 C1 C4 E2 E9 A9 C3 C3 }
	condition:
		$1
}

rule file_163_4_0 {
	meta:
		name = "_wcsnicoll"
		size = 147
		refs = "000d __acrt_locale_changed_data 001c _errno 0027 _invalid_parameter_noinfo 008f _wcsnicoll_l"
	strings:
		$1 = { 48 83 EC 28 45 33 C9 4C 8B D2 44 39 0D ?? ?? ?? ?? 4C 8B D9 75 74 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 49 81 F8 FF FF FF 7F 77 D8 4C 2B DA 43 0F B7 14 13 8D 42 BF 66 83 F8 19 77 04 66 83 C2 20 41 0F B7 0A 8D 41 BF 66 83 F8 19 77 04 66 83 C1 20 49 83 C2 02 49 83 E8 01 74 0A 66 85 D2 74 05 66 3B D1 74 C9 0F B7 C9 0F B7 C2 2B C1 48 83 C4 28 C3 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_5_0 {
	meta:
		name = "_wcsnicoll_l"
		size = 305
		refs = "0036 _errno 0041 _invalid_parameter_noinfo 007c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00e9 __acrt_CompareStringW"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 50 33 ED 49 8B F0 48 8B FA 4C 8B F1 4D 85 C0 75 07 33 C0 E9 E6 00 00 00 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 C7 00 00 00 48 85 D2 74 E1 BB FF FF FF 7F 4C 3B C3 76 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 A1 00 00 00 49 8B D1 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 8B 88 30 01 00 00 48 85 C9 75 43 4C 2B F7 41 0F B7 0C 3E 8D 41 BF 66 83 F8 19 77 04 66 83 C1 20 0F B7 17 8D 42 BF 66 83 F8 19 77 04 66 83 C2 20 48 83 C7 02 48 83 EE 01 74 0A 66 85 C9 74 05 66 3B CA 74 CA 0F B7 C2 0F B7 D9 2B D8 EB 2D 89 74 24 28 44 8B CE 4D 8B C6 48 89 7C 24 20 BA 01 10 00 00 E8 ?? ?? ?? ?? 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 58 FE 40 38 6C 24 48 74 0C 48 8B 44 24 30 83 A0 A8 03 00 00 FD 8B C3 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 8B 7C 24 78 48 83 C4 50 41 5E C3 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "_copysign"
		size = 55
	strings:
		$1 = { F2 0F 11 44 24 08 48 BA 00 00 00 00 00 00 00 80 48 8B 4C 24 08 F2 0F 11 4C 24 08 48 8B 44 24 08 48 33 C1 48 85 C2 74 0E 48 33 CA 48 89 4C 24 08 F2 0F 10 44 24 08 C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "_Hypot"
		size = 490
		refs = "002b _dunscale 008c __xmm@80000000000000008000000000000000 011b _dscale 0161 __real@3ff0000000000000 0166 sqrt 0185 __real@4000000000000000 01a1 __real@3ff6a09e667f3bcd 01ad __real@3eec713e5d623e2b 01be __real@4003504816f0068e 01d4 _Inf_C"
	strings:
		$1 = { 48 8B C4 F2 0F 11 48 10 F2 0F 11 40 08 55 53 57 48 8B EC 48 83 EC 40 0F 29 70 D8 48 8D 55 20 48 8D 4D 30 0F 29 78 C8 49 8B F8 E8 ?? ?? ?? ?? 48 8D 55 28 0F B7 D8 48 8D 4D 38 E8 ?? ?? ?? ?? 83 27 00 66 83 FB 01 0F 84 84 01 00 00 66 83 F8 01 0F 84 7A 01 00 00 41 B8 02 00 00 00 66 41 3B D8 75 0A F2 0F 10 45 20 E9 6C 01 00 00 66 41 3B C0 75 0A F2 0F 10 45 28 E9 5C 01 00 00 F2 0F 10 4D 20 0F 57 C0 66 0F 2F C1 F2 0F 10 1D ?? ?? ?? ?? 76 08 0F 57 CB F2 0F 11 4D 20 F2 0F 10 55 28 66 0F 2F C2 76 08 0F 57 D3 F2 0F 11 55 28 66 0F 2E D0 7A 14 75 12 66 0F 2E C8 7A 06 0F 84 17 01 00 00 0F B7 4D 30 EB 35 66 0F 2E C8 0F B7 4D 30 0F B7 55 38 7A 02 74 0D 66 3B CA 7C 08 75 1E 66 0F 2F D1 76 18 0F B7 C1 F2 0F 11 55 20 66 89 45 38 0F B7 CA F2 0F 11 4D 28 66 89 55 30 0F BF C9 8B C1 99 83 E2 03 03 C2 C1 F8 02 03 C0 41 0F 44 C0 2B C8 89 07 8B D1 48 8D 4D 20 E8 ?? ?? ?? ?? 0F BF 55 38 48 8D 4D 28 2B 17 E8 ?? ?? ?? ?? F2 0F 10 7D 20 F2 0F 5C 7D 28 66 0F 2E 7D 20 7A 06 0F 84 86 00 00 00 66 0F 2F 7D 28 76 2D F2 0F 10 75 20 F2 0F 5E 75 28 0F 28 C6 F2 0F 59 C6 F2 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 10 7D 28 F2 0F 58 C6 F2 0F 5E F8 EB 4D F2 0F 5E 7D 28 0F 28 F7 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F7 0F 28 C6 F2 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 5E F0 F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 F7 F2 0F 10 7D 28 F2 0F 58 35 ?? ?? ?? ?? F2 0F 5E FE F2 0F 58 7D 20 0F 28 C7 EB 08 F2 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 40 5F 5B 5D C3 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "_LHypot"
		size = 490
		refs = "002b _ldunscale 008c __xmm@80000000000000008000000000000000 011b _ldscale 0161 __real@3ff0000000000000 0166 sqrt 0185 __real@4000000000000000 01a1 __real@3ff6a09e667f3bcd 01ad __real@3eec713e5d623e2b 01be __real@4003504816f0068e 01d4 _LInf_C"
	strings:
		$1 = { 48 8B C4 F2 0F 11 48 10 F2 0F 11 40 08 55 53 57 48 8B EC 48 83 EC 40 0F 29 70 D8 48 8D 55 20 48 8D 4D 30 0F 29 78 C8 49 8B F8 E8 ?? ?? ?? ?? 48 8D 55 28 0F B7 D8 48 8D 4D 38 E8 ?? ?? ?? ?? 83 27 00 66 83 FB 01 0F 84 84 01 00 00 66 83 F8 01 0F 84 7A 01 00 00 41 B8 02 00 00 00 66 41 3B D8 75 0A F2 0F 10 45 20 E9 6C 01 00 00 66 41 3B C0 75 0A F2 0F 10 45 28 E9 5C 01 00 00 F2 0F 10 4D 20 0F 57 C0 66 0F 2F C1 F2 0F 10 1D ?? ?? ?? ?? 76 08 0F 57 CB F2 0F 11 4D 20 F2 0F 10 55 28 66 0F 2F C2 76 08 0F 57 D3 F2 0F 11 55 28 66 0F 2E D0 7A 14 75 12 66 0F 2E C8 7A 06 0F 84 17 01 00 00 0F B7 4D 30 EB 35 66 0F 2E C8 0F B7 4D 30 0F B7 55 38 7A 02 74 0D 66 3B CA 7C 08 75 1E 66 0F 2F D1 76 18 0F B7 C1 F2 0F 11 55 20 66 89 45 38 0F B7 CA F2 0F 11 4D 28 66 89 55 30 0F BF C9 8B C1 99 83 E2 03 03 C2 C1 F8 02 03 C0 41 0F 44 C0 2B C8 89 07 8B D1 48 8D 4D 20 E8 ?? ?? ?? ?? 0F BF 55 38 48 8D 4D 28 2B 17 E8 ?? ?? ?? ?? F2 0F 10 7D 20 F2 0F 5C 7D 28 66 0F 2E 7D 20 7A 06 0F 84 86 00 00 00 66 0F 2F 7D 28 76 2D F2 0F 10 75 20 F2 0F 5E 75 28 0F 28 C6 F2 0F 59 C6 F2 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 10 7D 28 F2 0F 58 C6 F2 0F 5E F8 EB 4D F2 0F 5E 7D 28 0F 28 F7 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F7 0F 28 C6 F2 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 5E F0 F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 F7 F2 0F 10 7D 28 F2 0F 58 35 ?? ?? ?? ?? F2 0F 5E FE F2 0F 58 7D 20 0F 28 C7 EB 08 F2 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 40 5F 5B 5D C3 }
	condition:
		$1
}

rule file_165_1_0 {
	meta:
		name = "csqrt"
		size = 489
		refs = "0026 creal 003c cimag 004a _dtest 0089 _Hypot 00b1 __xmm@7fffffffffffffff7fffffffffffffff 00b8 ldexp 00c6 __real@4000000000000000 00d9 sqrt 0127 __xmm@80000000000000008000000000000000 018c _Inf_C 01b0 _Zero_C 01cb _Cbuild"
	strings:
		$1 = { 40 55 53 56 57 41 56 48 8B EC 48 83 EC 40 0F 10 02 48 8B F9 48 8D 4D E0 0F 29 74 24 30 48 8B DA F3 0F 7F 45 E0 E8 ?? ?? ?? ?? F2 0F 11 45 40 48 8D 4D E0 0F 10 03 F3 0F 7F 45 E0 E8 ?? ?? ?? ?? 48 8D 4D 38 F2 0F 11 45 38 E8 ?? ?? ?? ?? 41 BE 01 00 00 00 0F B7 F0 66 41 3B C6 75 0A F2 0F 10 55 38 E9 57 01 00 00 48 8D 4D 40 E8 ?? ?? ?? ?? 66 41 3B C6 0F 84 E1 00 00 00 F2 0F 10 4D 38 4C 8D 45 30 F2 0F 10 45 40 E8 ?? ?? ?? ?? 8B 5D 30 0F 28 F0 85 DB 75 10 0F 28 D0 F2 0F 59 55 38 0F 28 C8 E9 1F 01 00 00 F2 0F 10 45 40 8B D3 0F 54 05 ?? ?? ?? ?? F7 DA E8 ?? ?? ?? ?? 8B C3 F2 0F 58 C6 F2 0F 10 35 ?? ?? ?? ?? 99 2B C2 D1 F8 8B D8 F2 0F 59 C6 41 2B DE E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? F2 0F 10 4D 40 0F 28 D8 0F 57 C0 66 0F 2F C8 72 18 F2 0F 10 55 38 0F 28 CB F2 0F 59 CE F2 0F 5E D1 0F 28 CB E9 B9 00 00 00 F2 0F 10 4D 38 B8 00 80 00 00 66 85 45 3E 74 1E 0F 28 D3 F2 0F 59 DE 0F 57 15 ?? ?? ?? ?? F2 0F 5E CB 0F 57 0D ?? ?? ?? ?? E9 8B 00 00 00 66 0F 2E C8 7A 0A 75 08 0F 28 D3 E9 54 FF FF FF 0F 28 C3 0F 28 D3 F2 0F 59 C6 F2 0F 5E C8 EB 6B 0F 57 C0 66 83 FE 02 75 18 66 0F 2F 45 40 76 0C F2 0F 10 55 40 F2 0F 10 4D 38 EB 4F 0F 10 03 EB 56 66 0F 2F 45 40 B8 00 80 00 00 76 1E F2 0F 10 15 ?? ?? ?? ?? 66 85 45 3E 0F 84 05 FF FF FF 0F 57 15 ?? ?? ?? ?? E9 F9 FE FF FF 66 85 45 3E 74 0F F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 0F 28 D0 F2 0F 10 0D ?? ?? ?? ?? 48 8D 4D E0 E8 ?? ?? ?? ?? 0F 10 00 0F 28 74 24 30 48 8B C7 F3 0F 7F 07 48 83 C4 40 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "__acrt_initialize_heap"
		size = 28
		refs = "0006 __imp_GetProcessHeap 0010 __acrt_heap"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "bsearch"
		size = 248
		refs = "0036 _errno 0041 _invalid_parameter_noinfo 0090 __guard_dispatch_icall_fptr"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 55 41 56 41 57 48 83 EC 20 4C 8B E9 4D 8B F1 33 C9 49 8B F0 48 8B EA 48 85 D2 75 19 4D 85 C0 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 6D 4D 85 C9 74 E7 48 39 4C 24 60 74 E0 49 8D 58 FF 49 0F AF DE 48 03 DA 48 3B D3 77 4B 4C 8B FE 49 D1 EF 74 68 48 8B 44 24 60 40 F6 C6 01 49 8D 77 FF 49 8B CD 49 0F 45 F7 48 8B FE 49 0F AF FE 48 03 FD 48 8B D7 FF 15 ?? ?? ?? ?? 33 C9 85 C0 74 19 79 08 48 8B DF 49 2B DE EB 07 4A 8D 2C 37 49 8B F7 48 3B EB 76 B5 48 8B F9 48 8B C7 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5D C3 48 85 F6 74 D6 48 8B 44 24 60 48 8B D5 49 8B CD FF 15 ?? ?? ?? ?? 33 C9 48 8B FD 85 C0 48 0F 45 F9 EB BB }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "_fdpoly"
		size = 28
	strings:
		$1 = { 0F 28 C8 F3 0F 10 02 EB 0C 48 83 C2 04 F3 0F 59 C1 F3 0F 58 02 41 83 E8 01 79 EE C3 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "erfcf"
		size = 618
		refs = "0022 _fdtest 0049 __real@3ef430fe 005b erff 0063 __real@3f800000 0077 __real@3fc2f1aa 009c __real@bf400000 00a4 __real@3ca92ef9 00ab s00 00c4 __real@3d56d16c 00cb c00 00ed __real@bfa40000 00f5 __real@3c8c2154 00fc s01 0115 __real@3d370146 011c c01 0136 approx 015b _fperrraise 01da _fd_int 01f8 expf 0214 __xmm@80000000800000008000000080000000 0221 _fdexp 0246 __real@40000000"
	strings:
		$1 = { 48 8B C4 F3 0F 11 40 08 55 48 8B EC 48 83 EC 50 0F 29 70 E8 48 8D 4D 10 0F 29 78 D8 44 0F 29 40 C8 E8 ?? ?? ?? ?? 0F BF C8 33 D2 85 C9 0F 84 19 02 00 00 83 E9 01 0F 84 F7 01 00 00 83 F9 01 0F 84 E7 01 00 00 F3 0F 10 0D ?? ?? ?? ?? F3 0F 10 55 10 0F 2F CA 76 1C 0F 28 C2 E8 ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C C8 0F 28 C1 E9 E1 01 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C2 0F 86 AF 00 00 00 F3 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 0F 2F C2 8B D0 76 51 F3 0F 58 15 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C1 04 F3 0F 59 C2 83 EA 01 F3 0F 58 01 79 EF F3 0F 10 0D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C1 04 F3 0F 59 CA 83 E8 01 F3 0F 58 09 79 EF F3 0F 5E C1 E9 6B 01 00 00 F3 0F 58 15 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C1 04 F3 0F 59 C2 83 EA 01 F3 0F 58 01 79 EF F3 0F 10 0D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C1 04 F3 0F 59 CA 83 E8 01 F3 0F 58 09 79 EF EB AD 4C 8D 05 ?? ?? ?? ?? 49 8B C8 F3 0F 10 01 0F 2F C2 77 21 FF C2 48 83 C1 28 48 63 C2 48 83 F8 08 72 E8 B9 10 00 00 00 E8 ?? ?? ?? ?? 0F 57 C0 E9 ED 00 00 00 F3 0F 10 05 ?? ?? ?? ?? 48 63 C2 F3 0F 5E C2 48 8D 14 80 49 8B 44 D0 08 41 8B 4C D0 10 F3 41 0F 5C 44 D0 04 F3 0F 11 45 18 F3 44 0F 10 00 EB 0E 48 83 C0 04 F3 44 0F 59 C0 F3 44 0F 58 00 83 E9 01 79 ED 49 8B 44 D0 18 41 8B 4C D0 20 F3 0F 10 38 EB 0C 48 83 C0 04 F3 0F 59 F8 F3 0F 58 38 83 E9 01 79 EF BA 08 00 00 00 F3 0F 11 55 18 48 8D 4D 18 E8 ?? ?? ?? ?? F3 0F 10 75 18 0F 28 C6 0F 28 CE F3 0F 5C 45 10 F3 0F 58 4D 10 F3 0F 59 C1 E8 ?? ?? ?? ?? F3 44 0F 5E C7 48 8D 4D 18 45 33 C0 F3 0F 59 F6 F3 41 0F 59 C0 0F 57 35 ?? ?? ?? ?? F3 0F 11 75 18 0F 28 C8 E8 ?? ?? ?? ?? F3 0F 10 45 18 EB 28 F3 0F 10 45 10 EB 21 B8 00 80 00 00 66 85 45 12 0F 84 1D FF FF FF F3 0F 10 05 ?? ?? ?? ?? EB 08 F3 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 40 0F 28 7C 24 30 44 0F 28 44 24 20 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_169_1_0 {
	meta:
		name = "??$common_refill_and_read_nolock@D@@YAHV__crt_stdio_stream@@@Z"
		size = 425
		refs = "0021 _errno 002c _invalid_parameter_noinfo 0093 __acrt_stdio_allocate_buffer_nolock 00aa _fileno 00bd _read 0124 __pioinfo 0147 __badioinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 48 89 78 20 48 89 48 08 55 48 8B EC 48 83 EC 20 48 85 C9 75 28 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 5D C3 8B 41 14 C1 E8 0D A8 01 74 DE 48 8B 45 10 8B 48 14 C1 E9 0C F6 C1 01 75 CF 48 8B 45 10 8B 48 14 48 8B 45 10 D1 E9 F6 C1 01 74 07 F0 83 48 14 10 EB B6 F0 83 48 14 01 48 8B 45 10 8B 48 14 F7 C1 C0 04 00 00 75 09 48 8B 4D 10 E8 ?? ?? ?? ?? 48 8B 45 10 48 8B 48 08 48 89 08 48 8B 5D 10 48 8B CB E8 ?? ?? ?? ?? 48 8B 55 10 8B C8 44 8B 42 20 48 8B 52 08 E8 ?? ?? ?? ?? 89 43 10 48 8B 45 10 8B 50 10 8D 4A 01 83 F9 01 77 1B F7 DA 1B C9 83 E1 08 83 C1 08 F0 09 48 14 48 8B 45 10 83 60 10 00 E9 42 FF FF FF 8B 48 14 F6 C1 06 75 67 48 8B 4D 10 E8 ?? ?? ?? ?? 83 F8 FF 74 40 48 8B 4D 10 E8 ?? ?? ?? ?? 83 F8 FE 74 32 48 8B 5D 10 48 8B CB E8 ?? ?? ?? ?? 48 63 F8 48 8D 35 ?? ?? ?? ?? 48 8B CB 48 C1 FF 06 E8 ?? ?? ?? ?? 48 8B 14 FE 83 E0 3F 48 C1 E0 06 48 03 D0 EB 07 48 8D 15 ?? ?? ?? ?? 8A 42 38 24 82 3C 82 75 09 48 8B 45 10 F0 83 48 14 20 48 8B 45 10 81 78 20 00 02 00 00 75 29 8B 48 14 C1 E9 06 F6 C1 01 74 1A 48 8B 45 10 8B 48 14 C1 E9 08 F6 C1 01 75 0B 48 8B 45 10 C7 40 20 00 10 00 00 48 8B 45 10 FF 48 10 48 8B 08 0F B6 11 48 FF C1 48 89 08 8B C2 E9 8A FE FF FF }
	condition:
		$1
}

rule file_169_2_0 {
	meta:
		name = "??$common_refill_and_read_nolock@_W@@YAHV__crt_stdio_stream@@@Z"
		size = 485
		refs = "0025 _errno 0030 _invalid_parameter_noinfo 009d __acrt_stdio_allocate_buffer_nolock 00cb _fileno 00de _read 0145 __pioinfo 0168 __badioinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 48 89 78 20 48 89 48 08 55 41 56 41 57 48 8B EC 48 83 EC 20 48 85 C9 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF 00 00 48 8B 5C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 5D C3 8B 41 14 C1 E8 0D A8 01 74 D8 48 8B 45 20 8B 48 14 C1 E9 0C F6 C1 01 75 C9 48 8B 45 20 8B 48 14 48 8B 45 20 D1 E9 F6 C1 01 74 07 F0 83 48 14 10 EB B0 F0 83 48 14 01 48 8B 45 20 8B 48 14 F7 C1 C0 04 00 00 75 09 48 8B 4D 20 E8 ?? ?? ?? ?? 48 8B 45 20 83 78 10 01 75 0B 48 8B 08 40 B6 01 44 8A 31 EB 06 40 32 F6 45 32 F6 48 8B 48 08 48 89 08 48 8B 5D 20 48 8B CB E8 ?? ?? ?? ?? 48 8B 55 20 8B C8 44 8B 42 20 48 8B 52 08 E8 ?? ?? ?? ?? 89 43 10 48 8B 45 20 8B 50 10 8D 4A 01 83 F9 02 77 1B F7 DA 1B C9 83 E1 08 83 C1 08 F0 09 48 14 48 8B 45 20 83 60 10 00 E9 25 FF FF FF 8B 48 14 F6 C1 06 75 67 48 8B 4D 20 E8 ?? ?? ?? ?? 83 F8 FF 74 40 48 8B 4D 20 E8 ?? ?? ?? ?? 83 F8 FE 74 32 48 8B 5D 20 48 8B CB E8 ?? ?? ?? ?? 48 63 F8 4C 8D 3D ?? ?? ?? ?? 48 8B CB 48 C1 FF 06 E8 ?? ?? ?? ?? 49 8B 14 FF 83 E0 3F 48 C1 E0 06 48 03 D0 EB 07 48 8D 15 ?? ?? ?? ?? 8A 42 38 24 82 3C 82 75 09 48 8B 45 20 F0 83 48 14 20 48 8B 45 20 81 78 20 00 02 00 00 75 29 8B 48 14 C1 E9 06 F6 C1 01 74 1A 48 8B 45 20 8B 48 14 C1 E9 08 F6 C1 01 75 0B 48 8B 45 20 C7 40 20 00 10 00 00 48 8B 45 20 48 8B 08 40 84 F6 74 16 0F B6 11 FF 48 10 66 C1 E2 08 41 0F B6 CE 66 0B D1 48 FF 00 EB 0B 0F B7 11 83 40 10 FE 48 83 00 02 0F B7 C2 E9 54 FE FF FF }
	condition:
		$1
}

rule file_169_6_0 {
	meta:
		name = "?get_context_nolock@@YA?AUfilwbuf_context@?A0x763516dc@@V__crt_stdio_stream@@_W@Z"
		size = 34
	strings:
		$1 = { 83 79 10 01 75 10 48 8B 01 C6 44 24 18 01 8A 08 88 4C 24 19 EB 06 66 83 64 24 18 00 0F B7 44 24 18 C3 }
	condition:
		$1
}

rule file_169_18_0 {
	meta:
		name = "?read_character_nolock@@YAEV__crt_stdio_stream@@HD@Z"
		size = 25
	strings:
		$1 = { 48 89 4C 24 08 FF 49 10 48 8B 4C 24 08 48 8B 11 8A 02 48 FF C2 48 89 11 C3 }
	condition:
		$1
}

rule file_169_19_0 {
	meta:
		name = "?read_character_nolock@@YA_WV__crt_stdio_stream@@Ufilwbuf_context@?A0x763516dc@@_W@Z"
		size = 55
	strings:
		$1 = { 48 89 4C 24 08 48 8B 01 84 D2 74 1A 0F B6 00 FF 49 10 48 8B 4C 24 08 66 C1 E0 08 66 C1 EA 08 66 0B C2 48 FF 01 C3 0F B7 00 83 41 10 FE 48 8B 4C 24 08 48 83 01 02 C3 }
	condition:
		$1
}

rule file_170_4_0 {
	meta:
		name = "_gcvt"
		size = 44
		refs = "0017 _gcvt_s"
	strings:
		$1 = { 40 53 48 83 EC 20 44 8B CA 0F 28 D0 48 83 CA FF 49 8B C8 49 8B D8 E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 45 D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_170_5_0 {
	meta:
		name = "_gcvt_s"
		size = 420
		refs = "001b __security_cookie 003e _errno 004a _invalid_parameter_noinfo 0076 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00b8 __acrt_fltout 0121 __acrt_fp_format 0190 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 56 48 8D AC 24 98 FD FF FF 48 81 EC 68 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 50 02 00 00 F2 0F 11 54 24 50 48 8B F2 49 63 F9 48 8B D9 48 85 C9 75 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 30 01 00 00 48 85 D2 74 E3 C6 01 00 48 3B FA 72 0C E8 ?? ?? ?? ?? BB 22 00 00 00 EB D9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 44 24 70 4C 8D 8D F0 00 00 00 41 BC 5E 01 00 00 4C 8D 44 24 58 41 8B D4 4C 89 64 24 20 48 8B 88 F8 00 00 00 48 8B 01 48 8B 4C 24 50 44 8A 30 33 C0 48 89 44 24 58 48 89 44 24 60 E8 ?? ?? ?? ?? 8B 54 24 5C 8D 4A FF 83 F9 FF 7C 26 8D 47 FF 3B C8 7F 1F 2B FA 48 83 64 24 40 00 48 C7 44 24 38 10 00 00 00 89 7C 24 30 C7 44 24 28 66 00 00 00 EB 1E 48 83 64 24 40 00 8D 47 FF 48 C7 44 24 38 10 00 00 00 89 44 24 30 C7 44 24 28 65 00 00 00 4C 8D 4D 90 4C 89 64 24 20 4C 8B C6 48 8D 4C 24 50 48 8B D3 E8 ?? ?? ?? ?? 8B F8 85 C0 74 11 E8 ?? ?? ?? ?? 89 38 EB 3D 41 3A C6 74 09 48 FF C3 8A 03 84 C0 75 F2 80 3B 00 74 28 EB 04 3C 65 74 09 48 FF C3 8A 03 84 C0 75 F3 48 8B CB 48 FF CB 80 3B 30 74 F8 8A 01 48 FF C3 48 FF C1 88 03 84 C0 75 F2 33 FF 80 7D 80 00 74 0C 48 8B 4C 24 68 83 A1 A8 03 00 00 FD 8B C7 48 8B 8D 50 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 68 03 00 00 41 5E 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_172_2_0 {
	meta:
		name = "??$common_searchenv_s@D@@YAHQEBD0QEAD_K@Z"
		size = 925
		refs = "0017 __security_cookie 003f _errno 004a _invalid_parameter_noinfo 0081 _access_s 009c _fullpath 00cb _dupenv_s 0130 _calloc_base 013a _free_base 019a __acrt_getpath 027e strcpy_s 0346 __security_check_cookie 036e _invoke_watson"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 70 01 00 00 33 F6 4C 89 4C 24 50 4D 8B F9 4D 8B F0 48 8B EA 4C 8B E9 4D 85 C0 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 E9 E2 02 00 00 4D 85 C9 74 E1 48 85 C9 75 05 41 88 30 EB D7 40 38 31 75 08 41 88 30 E9 B8 02 00 00 E8 ?? ?? ?? ?? 33 D2 49 8B CD 8B 38 E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 89 38 85 DB 75 29 4D 8B C7 49 8B D5 49 8B CE E8 ?? ?? ?? ?? 48 85 C0 75 0F 41 88 36 E8 ?? ?? ?? ?? 8B 00 E9 86 02 00 00 33 C0 E9 7F 02 00 00 4C 8B C5 48 89 74 24 30 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 0E 83 F8 16 0F 85 4D 02 00 00 E9 7D 02 00 00 48 8B 5C 24 30 48 85 DB 0F 84 3A 02 00 00 48 83 C8 FF 4C 8B E0 49 FF C4 43 38 34 2C 75 F7 48 C7 44 24 38 08 01 00 00 48 8D 6C 24 60 4D 3B E7 72 43 48 FF C0 40 38 34 03 75 F7 48 83 C0 02 BA 01 00 00 00 49 03 C4 48 8B C8 48 89 44 24 38 E8 ?? ?? ?? ?? 33 C9 48 8B E8 E8 ?? ?? ?? ?? 48 85 ED 75 12 41 88 36 E8 ?? ?? ?? ?? 8D 75 0C 89 30 E9 C8 01 00 00 48 8D 44 24 60 48 8B FD 48 3B E8 48 0F 44 FE E8 ?? ?? ?? ?? 8B 00 89 44 24 40 48 8B 44 24 30 41 BF 22 00 00 00 48 89 44 24 48 48 85 C0 0F 84 7C 01 00 00 4C 8B 44 24 38 48 8B D5 4D 2B C4 48 8B C8 49 FF C8 E8 ?? ?? ?? ?? 48 89 44 24 30 48 85 C0 0F 85 89 00 00 00 48 8D 44 24 60 48 3B E8 0F 85 35 01 00 00 E8 ?? ?? ?? ?? 44 39 38 75 63 4C 8B 7C 24 48 48 83 C8 FF 48 FF C0 41 38 34 07 75 F7 48 83 C0 02 BA 01 00 00 00 49 03 C4 48 8B C8 48 89 44 24 38 E8 ?? ?? ?? ?? 48 8B CF 48 8B E8 E8 ?? ?? ?? ?? 33 C9 48 8B FD E8 ?? ?? ?? ?? 48 85 ED 0F 84 AF 00 00 00 4C 8B 44 24 38 48 8B D5 4D 2B C4 49 8B CF E8 ?? ?? ?? ?? 48 89 44 24 30 EB 05 48 8B 44 24 30 48 85 C0 0F 84 BA 00 00 00 40 38 75 00 0F 84 B0 00 00 00 49 83 CF FF 49 FF C7 41 38 34 2F 75 F7 49 8D 0C 2F 8A 41 FF 2C 2F 3C 2D 77 10 48 BA 01 08 00 00 00 20 00 00 48 0F A3 C2 72 09 C6 01 5C 48 FF C1 49 FF C7 48 8B 54 24 38 4D 8B C5 49 2B D7 E8 ?? ?? ?? ?? 85 C0 0F 85 FE 00 00 00 33 D2 48 8B CD E8 ?? ?? ?? ?? 85 C0 0F 85 D3 FE FF FF 49 8D 47 01 4C 8B 7C 24 50 49 03 C4 49 3B C7 76 20 41 88 36 E8 ?? ?? ?? ?? B9 22 00 00 00 EB 55 41 88 36 E8 ?? ?? ?? ?? BE 0C 00 00 00 89 30 EB 33 E8 ?? ?? ?? ?? 8B 4C 24 40 4C 8B C5 49 8B D7 89 08 49 8B CE E8 ?? ?? ?? ?? 85 C0 74 2B E9 84 00 00 00 41 88 36 E8 ?? ?? ?? ?? B9 02 00 00 00 8B F1 89 08 8B CE EB 0F 41 88 36 E8 ?? ?? ?? ?? B9 02 00 00 00 89 08 8B F1 48 8B CF E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 8B C6 EB 11 41 88 36 E8 ?? ?? ?? ?? B9 02 00 00 00 89 08 8B C1 48 8B 8C 24 70 01 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 01 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_172_3_0 {
	meta:
		name = "??$common_searchenv_s@_W@@YAHQEB_W0QEA_W_K@Z"
		size = 946
		refs = "0017 __security_cookie 0044 _errno 004f _invalid_parameter_noinfo 0088 _waccess_s 00a3 _wfullpath 00d3 _wdupenv_s 013c _calloc_base 0146 _free_base 01a8 __acrt_wgetpath 0297 wcscpy_s 035b __security_check_cookie 0383 _invoke_watson"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 70 02 00 00 33 F6 4C 89 4C 24 58 48 89 4C 24 50 4D 8B E1 4D 8B F0 4C 8B FA 48 8B E9 4D 85 C0 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 E9 F2 02 00 00 4D 85 C9 74 E1 48 85 C9 75 06 66 41 89 30 EB D6 66 39 31 75 09 66 41 89 30 E9 C6 02 00 00 E8 ?? ?? ?? ?? 33 D2 48 8B CD 8B 38 E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 89 38 85 DB 75 2A 4D 8B C4 48 8B D5 49 8B CE E8 ?? ?? ?? ?? 48 85 C0 75 10 66 41 89 36 E8 ?? ?? ?? ?? 8B 00 E9 93 02 00 00 33 C0 E9 8C 02 00 00 4D 8B C7 48 89 74 24 30 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 0E 83 F8 16 0F 85 59 02 00 00 E9 8A 02 00 00 48 8B 5C 24 30 48 85 DB 0F 84 46 02 00 00 48 83 C8 FF 4C 8B E8 49 FF C5 66 42 39 74 6D 00 75 F5 48 C7 44 24 38 08 01 00 00 4C 8D 7C 24 60 BD 02 00 00 00 4D 3B EC 72 42 48 FF C0 66 39 34 43 75 F7 48 03 C5 48 8B D5 49 03 C5 48 8B C8 48 89 44 24 38 E8 ?? ?? ?? ?? 33 C9 4C 8B F8 E8 ?? ?? ?? ?? 4D 85 FF 75 14 66 41 89 36 E8 ?? ?? ?? ?? 41 8D 77 0C 89 30 E9 CE 01 00 00 48 8D 44 24 60 49 8B FF 4C 3B F8 48 0F 44 FE E8 ?? ?? ?? ?? 8B 00 89 44 24 40 48 8B 44 24 30 41 BC 22 00 00 00 48 89 44 24 48 48 85 C0 0F 84 86 01 00 00 4C 8B 44 24 38 49 8B D7 4D 2B C5 48 8B C8 49 FF C8 E8 ?? ?? ?? ?? 48 89 44 24 30 48 85 C0 0F 85 87 00 00 00 48 8D 44 24 60 4C 3B F8 0F 85 41 01 00 00 E8 ?? ?? ?? ?? 44 39 20 75 61 4C 8B 64 24 48 48 83 C8 FF 48 FF C0 66 41 39 34 44 75 F6 48 03 C5 48 8B D5 49 03 C5 48 8B C8 48 89 44 24 38 E8 ?? ?? ?? ?? 48 8B CF 4C 8B F8 E8 ?? ?? ?? ?? 33 C9 49 8B FF E8 ?? ?? ?? ?? 4D 85 FF 0F 84 BF 00 00 00 4C 8B 44 24 38 49 8B D7 4D 2B C5 49 8B CC E8 ?? ?? ?? ?? 48 89 44 24 30 EB 05 48 8B 44 24 30 48 85 C0 0F 84 C8 00 00 00 66 41 39 37 0F 84 BE 00 00 00 49 83 CC FF 49 FF C4 66 43 39 34 67 75 F6 4B 8D 0C 67 0F B7 41 FE 66 83 E8 2F 66 83 F8 2D 77 10 48 BA 01 08 00 00 00 20 00 00 48 0F A3 C2 72 0E B8 5C 00 00 00 66 89 01 48 03 CD 49 FF C4 48 8B 54 24 38 4C 8B 44 24 50 49 2B D4 E8 ?? ?? ?? ?? 85 C0 0F 85 FA 00 00 00 33 D2 49 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 C8 FE FF FF 48 8B 6C 24 58 49 8D 45 01 49 03 C4 48 3B C5 76 24 66 41 89 36 E8 ?? ?? ?? ?? B9 22 00 00 00 89 08 EB 40 66 41 89 36 E8 ?? ?? ?? ?? BE 0C 00 00 00 89 30 EB 2C E8 ?? ?? ?? ?? 8B 4C 24 40 4D 8B C7 48 8B D5 89 08 49 8B CE E8 ?? ?? ?? ?? 85 C0 74 22 EB 7F 66 41 89 36 E8 ?? ?? ?? ?? 8B F5 89 28 8B CE 8B F1 EB 0D 66 41 89 36 E8 ?? ?? ?? ?? 8B F5 89 28 48 8B CF E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 8B C6 EB 12 66 41 89 36 E8 ?? ?? ?? ?? BD 02 00 00 00 89 28 8B C5 48 8B 8C 24 70 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 02 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 48 89 74 24 20 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "cosf"
		size = 1279
		refs = "0006 __use_fma3_lib 0068 L_one_half 0088 L_large_x_sse2 009a L_2bypi 00bd L_piby2_1 00c9 L_piby2_1tail 00ed L_piby2_2 00fa L_piby2_2tail 015d L_one_sixth 0184 L_real_one 01cb __remainder_piby2d2f_forAsm 0201 __Lsinfarray 0254 __Lcosfarray 02ca _cosf_special 02e7 L_inf_mask_32 0308 L_piby2 0315 L_two_to_neg_7 031e L_two_to_neg_13 0328 L_two_to_32_float 0330 L_one_float 03c8 L_large_x_fma3 03d2 L_sign_mask 03f4 L__int_three 043f __remainder_piby2_fma3_bdl 0451 __remainder_piby2_fma3"
	strings:
		$1 = { 48 83 EC 68 83 3D ?? ?? ?? ?? 00 0F 85 CF 02 00 00 66 0F 57 D2 66 0F 7E C2 B8 00 00 80 7F 44 8B D0 44 23 D2 44 3B D0 0F 84 9C 02 00 00 F3 0F 5A C0 66 48 0F 7E C2 4C 8B D2 49 0F BA F2 3F 41 B8 01 00 00 00 66 0F 28 C8 48 B8 18 2D 44 54 FB 21 E9 3F 4C 3B D0 7F 29 66 0F 28 D0 F2 0F 59 D2 33 C0 49 8B D2 F2 0F 10 2D ?? ?? ?? ?? E9 7F 01 00 00 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 66 49 0F 6E C2 4C 3B 15 ?? ?? ?? ?? 0F 83 2E 01 00 00 66 0F 28 D0 F2 0F 10 1D ?? ?? ?? ?? 66 0F 28 E0 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 D3 4D 8B CA 49 C1 E9 34 F2 0F 58 D5 F2 0F 10 1D ?? ?? ?? ?? 66 0F E6 C2 F2 0F 10 0D ?? ?? ?? ?? F3 0F E6 D0 F2 0F 59 DA F2 0F 5C E3 F2 0F 59 CA 66 0F 7E C0 66 0F 28 C4 F2 0F 5C C1 F2 0F 10 1D ?? ?? ?? ?? 66 48 0F 7E C1 F2 0F 10 2D ?? ?? ?? ?? 48 D1 E1 48 C1 E9 35 4C 2B C9 49 83 F9 0F 7E 28 66 0F 28 CC F2 0F 59 DA F2 0F 59 EA F2 0F 5C E3 F2 0F 5C CC F2 0F 5C CB F2 0F 5C E9 66 0F 28 C4 66 0F 28 CD F2 0F 5C C5 48 81 F9 F2 03 00 00 0F 8D AD 00 00 00 48 81 F9 DE 03 00 00 7E 54 66 0F 28 D0 F2 0F 59 D0 44 23 C0 74 27 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 DA F2 0F 5C C3 E9 32 01 00 00 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C C2 E9 0B 01 00 00 0F 1F 80 00 00 00 00 44 23 C0 0F 85 FB 00 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 EE 00 00 00 66 66 0F 1F 84 00 00 00 00 00 48 89 54 24 20 4C 89 54 24 30 E8 ?? ?? ?? ?? 48 8B 54 24 20 4C 8B 54 24 30 41 B8 01 00 00 00 66 0F 28 C8 F2 0F 10 2D ?? ?? ?? ?? EB 03 0F 1F 00 66 0F 28 D0 F2 0F 59 D0 44 23 C0 74 53 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 10 E2 F2 0F 59 E2 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EA F2 0F 10 D8 F2 0F 59 DA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 CD F2 0F 59 CB F2 0F 58 C1 EB 5D 66 0F 1F 84 00 00 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 E2 F2 0F 59 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 E2 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 C2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 CB F2 0F 59 CC F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 C1 83 C0 01 83 E0 02 74 14 66 0F 57 D2 F2 0F 5C D0 66 0F 28 C2 0F 1F 84 00 00 00 00 00 F2 0F 5A C0 48 83 C4 68 C3 E8 ?? ?? ?? ?? 48 83 C4 68 C3 66 66 66 66 66 0F 1F 84 00 00 00 00 00 C5 F9 7E C0 44 8B 05 ?? ?? ?? ?? 41 23 C0 41 3B C0 0F 84 FE 01 00 00 C5 FA 5A E8 C4 C1 F9 7E E9 49 0F BA F1 3F 4C 3B 0D ?? ?? ?? ?? 0F 8F AE 00 00 00 4C 3B 0D ?? ?? ?? ?? 7D 45 4C 3B 0D ?? ?? ?? ?? 7D 1C C5 FA 58 0D ?? ?? ?? ?? C5 F9 6E 05 ?? ?? ?? ?? 48 83 C4 68 C3 0F 1F 80 00 00 00 00 C5 D3 59 05 ?? ?? ?? ?? C4 E2 D1 AD 05 ?? ?? ?? ?? C5 FB 5A C0 48 83 C4 68 C3 66 0F 1F 44 00 00 F2 0F 10 C5 C5 F9 28 15 ?? ?? ?? ?? C5 FB 59 D8 C5 E3 59 0D ?? ?? ?? ?? C5 EB 5C D1 C5 FB 10 0D ?? ?? ?? ?? C4 E2 E1 B9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C5 E3 59 DB C5 F9 6F C2 C4 E2 F1 B9 C3 C5 FB 5A C0 48 83 C4 68 C3 66 66 66 0F 1F 84 00 00 00 00 00 C4 C1 F9 6E C1 4C 3B 0D ?? ?? ?? ?? 7D 62 C5 F9 54 0D ?? ?? ?? ?? C5 F9 28 15 ?? ?? ?? ?? C4 E2 F1 A9 15 ?? ?? ?? ?? C5 F9 E6 D2 C4 E2 79 25 CA C5 F1 54 25 ?? ?? ?? ?? C5 F0 C6 C9 08 C5 FA E6 C9 C5 F9 6F D0 C4 E2 F1 BD 15 ?? ?? ?? ?? C5 F3 59 1D ?? ?? ?? ?? C5 EB 5C C3 C5 EB 5C D0 C5 EB 5C CB C4 E1 F9 7E E0 EB 2C 0F 1F 80 00 00 00 00 C4 C1 F9 6E C1 4C 3B 0D ?? ?? ?? ?? 7D 12 E8 ?? ?? ?? ?? EB 10 66 66 66 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? 48 0F BA E0 00 73 34 C5 FB 10 0D ?? ?? ?? ?? C5 FB 59 D8 C4 E2 E1 B9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C5 FB 59 DB C4 E2 F1 B9 C3 EB 4A 66 90 C5 F9 28 15 ?? ?? ?? ?? C5 FB 59 D8 C5 E3 59 0D ?? ?? ?? ?? C5 EB 5C D1 C5 FB 10 0D ?? ?? ?? ?? C4 E2 E1 B9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C5 E3 59 DB C5 F9 6F C2 C4 E2 F1 B9 C3 48 83 C0 01 48 D1 E8 48 C1 E0 3F C4 E1 F9 6E D8 C5 F9 57 C3 C5 FB 5A C0 48 83 C4 68 C3 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_174_4_0 {
	meta:
		name = "_mbsnset_s_l"
		size = 546
		refs = "006c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0088 _strnset_s 01b3 _errno 01bf _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 45 33 E4 41 8B E8 49 8B F1 48 8B DA 4C 8B F1 45 8B FC 41 8B FC 4D 85 C9 75 15 48 85 C9 75 19 48 85 D2 0F 85 AB 01 00 00 33 C0 E9 B7 01 00 00 48 85 C9 0F 84 9B 01 00 00 48 85 D2 0F 84 92 01 00 00 48 8B 94 24 80 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 54 24 30 44 8B C5 49 8B CE 44 39 62 08 75 12 4C 8B CE 48 8B D3 E8 ?? ?? ?? ?? 8B D8 E9 48 01 00 00 41 C1 E8 08 41 BA 01 00 00 00 45 84 C0 0F 84 87 00 00 00 40 84 ED 0F 84 89 00 00 00 41 0F B6 C0 F6 44 10 19 04 74 7E 45 38 26 0F 84 AE 00 00 00 48 85 F6 0F 84 AA 00 00 00 49 2B DA 0F 84 9C 00 00 00 4C 8D 49 01 45 38 21 74 44 85 FF 74 05 41 8B FC EB 0B 0F B6 01 0F B6 7C 10 19 83 E7 04 44 88 01 49 8B C9 49 2B DA 74 74 85 FF 74 05 41 8B FC EB 0C 41 0F B6 01 0F B6 7C 10 19 83 E7 04 49 03 CA 41 88 29 49 2B F2 44 38 21 75 A3 EB 4F 44 88 21 49 03 DA 45 8B FA EB 44 40 0F B6 C5 F6 44 10 19 04 74 08 45 88 26 E9 8A 00 00 00 45 38 26 74 2C 48 85 F6 74 2C 49 2B DA 74 22 85 FF 74 05 41 8B FC EB 0B 0F B6 01 0F B6 7C 10 19 83 E7 04 40 88 29 49 2B F2 49 03 CA 44 38 21 75 D4 48 85 F6 75 34 85 FF 74 2B 44 38 21 74 2B 49 2B DA 74 21 45 8B FA 44 38 61 01 75 08 44 88 21 49 03 DA EB 10 C6 01 20 48 FF C1 EB 08 49 2B DA 74 08 49 03 CA 44 38 21 75 F3 48 85 DB 75 16 45 88 26 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 16 45 85 FF 74 0E E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 EB 03 41 8B DC 44 38 64 24 38 74 1F 48 8B 4C 24 20 83 A1 A8 03 00 00 FD EB 11 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 8B 7C 24 78 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_175_4_0 {
	meta:
		name = "??$capture_argv@PEAPEADAEBQEBDPEAPEADH@?$__crt_char_traits@D@@SAPEAPEAD$$QEAPEAPEADAEBQEBD0$$QEAH@Z"
		size = 17
		refs = "000d __acrt_capture_narrow_argv"
	strings:
		$1 = { 4D 63 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_5_0 {
	meta:
		name = "??$capture_argv@PEAPEADAEBQEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SAPEAPEA_W$$QEAPEAPEADAEBQEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 17
		refs = "000d __acrt_capture_wide_argv"
	strings:
		$1 = { 4D 63 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_647_13_0 {
	meta:
		name = "??$tcsncpy_s@AEAPEAD_KAEAPEBDH@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_KAEAPEBD$$QEAH@Z"
		size = 17
		refs = "000d strncpy_s"
	strings:
		$1 = { 4D 63 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_647_15_0 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEB_WH@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_KAEAPEB_W$$QEAH@Z"
		size = 17
		refs = "000d wcsncpy_s"
	strings:
		$1 = { 4D 63 09 4D 8B 00 48 8B 12 48 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_6_0 {
	meta:
		name = "??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
		size = 242
		refs = "0011 __security_cookie 0041 _errno 004c _invalid_parameter_noinfo 0079 __acrt_capture_narrow_argv 00c2 _spawnvpe 00cd _free_base 00e0 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 56 48 81 EC 40 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8B 84 24 90 02 00 00 33 FF 48 89 44 24 20 4D 8B D1 49 8B F0 44 8B F2 40 8A E9 4D 85 C0 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 7E 41 38 38 74 E5 4D 85 C9 74 E0 41 38 39 74 DB 41 B9 40 00 00 00 4C 8D 44 24 30 49 8B D2 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB BE 48 8B D8 48 8D 44 24 30 4C 3B C0 48 0F 44 DF 40 84 ED 74 12 48 8B 44 24 20 48 83 C0 08 48 89 44 24 20 48 8B 78 F8 4C 8B CF 48 8B D6 41 8B CE E8 ?? ?? ?? ?? 48 8B CB 48 8B F8 E8 ?? ?? ?? ?? 48 8B C7 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 40 02 00 00 41 5E 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_648_6_0 {
	meta:
		name = "??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
		size = 242
		refs = "0011 __security_cookie 0041 _errno 004c _invalid_parameter_noinfo 0079 __acrt_capture_narrow_argv 00c2 _spawnve 00cd _free_base 00e0 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 56 48 81 EC 40 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8B 84 24 90 02 00 00 33 FF 48 89 44 24 20 4D 8B D1 49 8B F0 44 8B F2 40 8A E9 4D 85 C0 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 7E 41 38 38 74 E5 4D 85 C9 74 E0 41 38 39 74 DB 41 B9 40 00 00 00 4C 8D 44 24 30 49 8B D2 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB BE 48 8B D8 48 8D 44 24 30 4C 3B C0 48 0F 44 DF 40 84 ED 74 12 48 8B 44 24 20 48 83 C0 08 48 89 44 24 20 48 8B 78 F8 4C 8B CF 48 8B D6 41 8B CE E8 ?? ?? ?? ?? 48 8B CB 48 8B F8 E8 ?? ?? ?? ?? 48 8B C7 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 40 02 00 00 41 5E 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_175_7_0 {
	meta:
		name = "??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
		size = 247
		refs = "0011 __security_cookie 0041 _errno 004c _invalid_parameter_noinfo 007e __acrt_capture_wide_argv 00c7 _wspawnvpe 00d2 _free_base 00e5 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 56 48 81 EC 40 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8B 84 24 90 02 00 00 33 FF 48 89 44 24 20 4D 8B D1 49 8B F0 44 8B F2 40 8A E9 4D 85 C0 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF E9 80 00 00 00 66 41 39 38 74 E1 4D 85 C9 74 DC 66 41 39 39 74 D6 41 B9 40 00 00 00 4C 8D 44 24 30 49 8B D2 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B9 48 8B D8 48 8D 44 24 30 4C 3B C0 48 0F 44 DF 40 84 ED 74 12 48 8B 44 24 20 48 83 C0 08 48 89 44 24 20 48 8B 78 F8 4C 8B CF 48 8B D6 41 8B CE E8 ?? ?? ?? ?? 48 8B CB 48 8B F8 E8 ?? ?? ?? ?? 48 8B C7 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 40 02 00 00 41 5E 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_648_7_0 {
	meta:
		name = "??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
		size = 247
		refs = "0011 __security_cookie 0041 _errno 004c _invalid_parameter_noinfo 007e __acrt_capture_wide_argv 00c7 _wspawnve 00d2 _free_base 00e5 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 56 48 81 EC 40 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8B 84 24 90 02 00 00 33 FF 48 89 44 24 20 4D 8B D1 49 8B F0 44 8B F2 40 8A E9 4D 85 C0 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF E9 80 00 00 00 66 41 39 38 74 E1 4D 85 C9 74 DC 66 41 39 39 74 D6 41 B9 40 00 00 00 4C 8D 44 24 30 49 8B D2 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B C0 48 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB B9 48 8B D8 48 8D 44 24 30 4C 3B C0 48 0F 44 DF 40 84 ED 74 12 48 8B 44 24 20 48 83 C0 08 48 89 44 24 20 48 8B 78 F8 4C 8B CF 48 8B D6 41 8B CE E8 ?? ?? ?? ?? 48 8B CB 48 8B F8 E8 ?? ?? ?? ?? 48 8B C7 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 40 02 00 00 41 5E 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_175_8_0 {
	meta:
		name = "??$tspawnvpe@AEBHAEBQEBDAEBQEAPEADAEBQEBQEBD@?$__crt_char_traits@D@@SA_JAEBHAEBQEBDAEBQEAPEADAEBQEBQEBD@Z"
		size = 16
		refs = "000c _spawnvpe"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_704_24_3 {
	meta:
		name = "??$tspawnve@AEBHAEAPEADAEBQEBQEBDAEBQEBQEBD@?$__crt_char_traits@D@@SA_JAEBHAEAPEADAEBQEBQEBD2@Z"
		size = 16
		refs = "000c _spawnve"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_704_25_3 {
	meta:
		name = "??$tspawnve@AEBHAEAPEA_WAEBQEBQEB_WAEBQEBQEB_W@?$__crt_char_traits@_W@@SA_JAEBHAEAPEA_WAEBQEBQEB_W2@Z"
		size = 16
		refs = "000c _wspawnve"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_648_8_4 {
	meta:
		name = "??$tspawnve@AEBHAEBQEBDAEBQEAPEADAEBQEBQEBD@?$__crt_char_traits@D@@SA_JAEBHAEBQEBDAEBQEAPEADAEBQEBQEBD@Z"
		size = 16
		refs = "000c _spawnve"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_704_26_2 {
	meta:
		name = "??$tspawnve@AEBHAEBQEBDAEBQEBQEBDAEBQEBQEBD@?$__crt_char_traits@D@@SA_JAEBHAEBQEBDAEBQEBQEBD2@Z"
		size = 16
		refs = "000c _spawnve"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_648_9_2 {
	meta:
		name = "??$tspawnve@AEBHAEBQEB_WAEBQEAPEA_WAEBQEBQEB_W@?$__crt_char_traits@_W@@SA_JAEBHAEBQEB_WAEBQEAPEA_WAEBQEBQEB_W@Z"
		size = 16
		refs = "000c _wspawnve"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_704_27_4 {
	meta:
		name = "??$tspawnve@AEBHAEBQEB_WAEBQEBQEB_WAEBQEBQEB_W@?$__crt_char_traits@_W@@SA_JAEBHAEBQEB_WAEBQEBQEB_W2@Z"
		size = 16
		refs = "000c _wspawnve"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_9_4 {
	meta:
		name = "??$tspawnvpe@AEBHAEBQEB_WAEBQEAPEA_WAEBQEBQEB_W@?$__crt_char_traits@_W@@SA_JAEBHAEBQEB_WAEBQEAPEA_WAEBQEBQEB_W@Z"
		size = 16
		refs = "000c _wspawnvpe"
	strings:
		$1 = { 4D 8B 09 4D 8B 00 48 8B 12 8B 09 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_16_0 {
	meta:
		name = "_execlp"
		size = 50
		refs = "0029 ??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 18 4C 8B CA 4C 8B C1 49 89 43 E8 BA 02 00 00 00 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_648_16_0 {
	meta:
		name = "_execl"
		size = 50
		refs = "0029 ??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 18 4C 8B CA 4C 8B C1 49 89 43 E8 BA 02 00 00 00 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_648_20_0 {
	meta:
		name = "_wexecl"
		size = 50
		refs = "0029 ??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 18 4C 8B CA 4C 8B C1 49 89 43 E8 BA 02 00 00 00 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_175_20_0 {
	meta:
		name = "_wexeclp"
		size = 50
		refs = "0029 ??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 18 4C 8B CA 4C 8B C1 49 89 43 E8 BA 02 00 00 00 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_175_17_0 {
	meta:
		name = "_execlpe"
		size = 50
		refs = "0029 ??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 18 4C 8B CA 4C 8B C1 49 89 43 E8 BA 02 00 00 00 B1 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_648_17_0 {
	meta:
		name = "_execle"
		size = 50
		refs = "0029 ??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 18 4C 8B CA 4C 8B C1 49 89 43 E8 BA 02 00 00 00 B1 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_648_21_0 {
	meta:
		name = "_wexecle"
		size = 50
		refs = "0029 ??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 18 4C 8B CA 4C 8B C1 49 89 43 E8 BA 02 00 00 00 B1 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_175_21_0 {
	meta:
		name = "_wexeclpe"
		size = 50
		refs = "0029 ??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 49 8D 43 18 4C 8B CA 4C 8B C1 49 89 43 E8 BA 02 00 00 00 B1 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_175_18_0 {
	meta:
		name = "_spawnlp"
		size = 43
		refs = "0022 ??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 49 89 43 E8 8B D1 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_648_18_0 {
	meta:
		name = "_spawnl"
		size = 43
		refs = "0022 ??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 49 89 43 E8 8B D1 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_648_22_0 {
	meta:
		name = "_wspawnl"
		size = 43
		refs = "0022 ??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 49 89 43 E8 8B D1 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_175_22_0 {
	meta:
		name = "_wspawnlp"
		size = 43
		refs = "0022 ??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 49 89 43 E8 8B D1 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_175_19_0 {
	meta:
		name = "_spawnlpe"
		size = 43
		refs = "0022 ??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 49 89 43 E8 8B D1 B1 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_648_19_0 {
	meta:
		name = "_spawnle"
		size = 43
		refs = "0022 ??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 49 89 43 E8 8B D1 B1 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_648_23_0 {
	meta:
		name = "_wspawnle"
		size = 43
		refs = "0022 ??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 49 89 43 E8 8B D1 B1 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_175_23_0 {
	meta:
		name = "_wspawnlpe"
		size = 43
		refs = "0022 ??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 49 89 43 E8 8B D1 B1 01 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "strncmp"
		size = 125
	strings:
		$1 = { 48 2B D1 4D 85 C0 74 6A F7 C1 07 00 00 00 74 1D 0F B6 01 3A 04 11 75 5D 48 FF C1 49 FF C8 74 52 84 C0 74 4E 48 F7 C1 07 00 00 00 75 E3 49 BB 80 80 80 80 80 80 80 80 49 BA FF FE FE FE FE FE FE FE 8D 04 11 25 FF 0F 00 00 3D F8 0F 00 00 77 C0 48 8B 01 48 3B 04 11 75 B7 48 83 C1 08 49 83 E8 08 76 0F 4E 8D 0C 10 48 F7 D0 49 23 C1 49 85 C3 74 CF 33 C0 C3 48 1B C0 48 83 C8 01 C3 }
	condition:
		$1
}

rule file_178_5_0 {
	meta:
		name = "_mbsnicmp_l"
		size = 401
		refs = "0034 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 004c _strnicmp 0060 _errno 006b _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 40 33 ED 49 8B F0 48 8B FA 48 8B D9 4D 85 C0 75 07 33 C0 E9 51 01 00 00 49 8B D1 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 54 24 30 39 6A 08 75 13 4C 8B C6 48 8B D7 48 8B CB E8 ?? ?? ?? ?? E9 14 01 00 00 48 85 DB 74 05 48 85 FF 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 F0 00 00 00 0F B6 0B 48 FF CE 48 FF C3 F6 44 11 19 04 74 3A 40 38 2B 75 04 8B CD EB 4A 0F B6 03 48 FF C3 66 C1 E1 08 66 0B C8 66 3B 4A 0C 72 0C 66 3B 4A 0E 77 06 66 03 4A 10 EB 2B 66 3B 4A 12 72 25 66 3B 4A 14 77 1F 66 03 4A 16 EB 19 0F B7 C1 FF C0 48 98 F6 44 10 18 10 74 0B 0F B7 C1 0F B6 8C 10 19 01 00 00 44 0F B6 07 48 FF C7 41 F6 44 10 19 04 74 43 40 38 2F 75 05 44 8B C5 EB 55 0F B6 07 48 FF C7 66 41 C1 E0 08 66 44 0B C0 66 44 3B 42 0C 72 0E 66 44 3B 42 0E 77 07 66 44 03 42 10 EB 31 66 44 3B 42 12 72 2A 66 44 3B 42 14 77 23 66 44 03 42 16 EB 1C 41 0F B7 C0 FF C0 48 98 F6 44 10 18 10 74 0D 41 0F B7 C0 44 0F B6 84 10 19 01 00 00 66 44 3B C1 75 12 66 85 C9 74 09 48 85 F6 0F 85 1B FF FF FF 8B C5 EB 07 1B C0 83 E0 02 FF C8 40 38 6C 24 38 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "_realloc_base"
		size = 130
		refs = "0019 _malloc_base 0025 _free_base 003a _query_new_mode 0046 _callnewh 0057 __acrt_heap 005f __imp_HeapReAlloc 006b _errno"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 48 85 C9 75 0A 48 8B CA E8 ?? ?? ?? ?? EB 58 48 85 D2 75 07 E8 ?? ?? ?? ?? EB 4A 48 83 FA E0 77 39 4C 8B CA 4C 8B C1 EB 1B E8 ?? ?? ?? ?? 85 C0 74 28 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 1C 4C 8B CB 4C 8B C7 48 8B 0D ?? ?? ?? ?? 33 D2 FF 15 ?? ?? ?? ?? 48 85 C0 74 D1 EB 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "_strset"
		size = 16
	strings:
		$1 = { 48 8B C1 EB 05 88 11 48 FF C1 80 39 00 75 F6 C3 }
	condition:
		$1
}

rule file_182_7_0 {
	meta:
		name = "__acrt_initialize_stdio"
		size = 287
		refs = "001b _nstream 0045 _calloc_base 004e __piob 0053 _free_base 0095 _iob 00ad __acrt_InitializeCriticalSectionEx 00bb __pioinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 8B 05 ?? ?? ?? ?? 33 DB BF 03 00 00 00 85 C0 75 07 B8 00 02 00 00 EB 05 3B C7 0F 4C C7 48 63 C8 BA 08 00 00 00 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 2F BA 08 00 00 00 89 3D ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 33 C9 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 05 83 C8 FF EB 75 4C 8B F3 48 8D 35 ?? ?? ?? ?? 48 8D 2D ?? ?? ?? ?? 48 8D 4D 30 45 33 C0 BA A0 0F 00 00 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 83 E1 3F 48 C1 E1 06 49 89 2C 06 48 8B C3 48 C1 F8 06 48 8B 04 C2 48 8B 4C 08 28 48 83 C1 02 48 83 F9 02 77 06 C7 06 FE FF FF FF 48 FF C3 48 83 C5 58 49 83 C6 08 48 83 C6 58 48 83 EF 01 75 9E 33 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_182_8_0 {
	meta:
		name = "__acrt_iob_func"
		size = 17
		refs = "0005 _iob"
	strings:
		$1 = { 8B C1 48 8D 0D ?? ?? ?? ?? 48 6B C0 58 48 03 C1 C3 }
	condition:
		$1
}

rule file_182_9_0 {
	meta:
		name = "__acrt_uninitialize_stdio"
		size = 91
		refs = "0007 _flushall 000c _fcloseall 0015 __piob 001e __acrt_stdio_free_buffer_nolock 0033 __imp_DeleteCriticalSection 0049 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 48 8B 0D ?? ?? ?? ?? 48 8B 0C 0B E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8B 0C 03 48 83 C1 30 FF 15 ?? ?? ?? ?? 48 83 C3 08 48 83 FB 18 75 D1 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_182_10_0 {
	meta:
		name = "_get_stream_buffer_pointers"
		size = 71
		refs = "000a _errno 0015 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 22 48 85 D2 74 07 48 8D 41 08 48 89 02 4D 85 C0 74 03 49 89 08 4D 85 C9 74 07 48 8D 41 10 49 89 01 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_183_7_0 {
	meta:
		name = "??0__acrt_stdio_temporary_buffering_guard@@QEAA@QEAU_iobuf@@@Z"
		size = 32
		refs = "0010 __acrt_stdio_begin_temporary_buffering_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 88 43 08 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_183_22_0 {
	meta:
		name = "_fwrite_nolock"
		size = 407
		refs = "0038 _errno 0043 _invalid_parameter_noinfo 00d1 memcpy 00f9 __acrt_stdio_flush_nolock 0125 _fileno 0132 _write 0169 __acrt_stdio_flush_and_write_narrow_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 8B F1 4D 8B E8 4C 8B F2 4C 8B F9 48 85 D2 74 1A 4D 85 C0 74 15 4D 85 C9 75 2F E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 48 85 C9 74 CC 33 D2 48 83 C8 FF 49 F7 F6 4C 3B C0 77 BE 41 8B 41 14 A9 C0 04 00 00 74 06 45 8B 61 20 EB 06 41 BC 00 10 00 00 49 8B FE 49 0F AF FD 48 8B EF 48 85 FF 0F 84 EC 00 00 00 B9 FE FF FF FF 8B 46 14 A8 C0 74 37 48 63 46 10 85 C0 74 2F 0F 88 8F 00 00 00 48 8B 0E 48 3B E8 48 8B D8 49 8B D7 48 0F 42 DD 4C 8B C3 E8 ?? ?? ?? ?? 29 5E 10 48 2B EB 48 01 1E 4C 03 FB E9 A1 00 00 00 41 8B DC 48 3B EB 72 73 8B 46 14 A8 C0 74 11 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 50 B9 FE FF FF FF 48 8B C5 45 85 E4 74 0B 33 D2 48 F7 F3 48 8B C5 48 2B C2 48 3B C1 8B D9 48 8B CE 0F 42 D8 E8 ?? ?? ?? ?? 8B C8 44 8B C3 49 8B D7 E8 ?? ?? ?? ?? 83 F8 FF 74 11 8B C8 3B C3 0F 47 CB 48 2B E9 4C 03 F9 3B C3 73 3B F0 83 4E 14 10 48 2B FD 33 D2 48 8B C7 49 F7 F6 E9 E8 FE FF FF 41 0F BE 0F 48 8B D6 E8 ?? ?? ?? ?? 83 F8 FF 74 DF 49 FF C7 48 FF CD 83 7E 20 00 41 BC 01 00 00 00 44 0F 4F 66 20 48 85 ED E9 0E FF FF FF 49 8B C5 E9 B2 FE FF FF }
	condition:
		$1
}

rule file_183_23_0 {
	meta:
		name = "fwrite"
		size = 129
		refs = "002b _errno 0036 _invalid_parameter_noinfo 007b ??$?RV<lambda_bdbcead8b570fa3d5ec6d9679862a6e5>@@AEAV<lambda_96f4279ff90247a4c5c5d9824f56f8c1>@@V<lambda_4606be27f17b5e5579e09050fab91818>@@@?$__crt_seh_guarded_call@_K@@QEAA_K$$QEAV<lambda_bdbcead8b570fa3d5ec6d9679862a6e5>@@AEAV<lambda_96f4279ff90247a4c5c5d9824f56f8c1>@@$$QEAV<lambda_4606be27f17b5e5579e09050fab91818>@@@Z"
	strings:
		$1 = { 48 8B C4 4C 89 48 20 4C 89 40 18 48 89 50 10 48 89 48 08 55 48 8B EC 48 83 EC 60 48 85 D2 74 1A 4D 85 C0 74 15 4D 85 C9 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 60 5D C3 48 8D 45 28 4C 89 4D C8 48 89 45 D8 4C 8D 45 D8 48 8D 45 10 4C 89 4D D0 48 89 45 E0 4C 8D 4D C8 48 8D 45 18 48 89 45 E8 48 8D 55 D0 48 8D 45 20 48 8D 4D C0 48 89 45 F0 E8 ?? ?? ?? ?? EB BB }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "_swab"
		size = 89
		refs = "000d _errno 001c _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 4C 8B C9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 83 C4 28 E9 ?? ?? ?? ?? 48 85 D2 74 E7 45 85 C0 78 E2 41 83 F8 01 7E 24 41 83 C0 FE 41 D1 E8 41 FF C0 41 8A 41 01 41 8A 09 4D 8D 49 02 88 02 88 4A 01 48 8D 52 02 49 83 E8 01 75 E6 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "_fpieee_flt"
		size = 27
		refs = "0017 _fpieee_flt_simd"
	strings:
		$1 = { 8D 81 72 FF FF 3F 83 F8 03 76 0B 81 F9 93 00 00 C0 74 03 33 C0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_mbsnbcpy_s"
		size = 20
		refs = "000b _mbsnbcpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_478_14_0 {
	meta:
		name = "_aligned_recalloc"
		size = 20
		refs = "000b _aligned_offset_recalloc_base"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_478_15_3 {
	meta:
		name = "_aligned_recalloc_base"
		size = 20
		refs = "000b _aligned_offset_recalloc_base"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_646_0_3 {
	meta:
		name = "_mbccpy_s"
		size = 20
		refs = "000b _mbccpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_653_0_3 {
	meta:
		name = "_mbsnbcat_s"
		size = 20
		refs = "000b _mbsnbcat_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_309_0_2 {
	meta:
		name = "_mbsnbset_s"
		size = 20
		refs = "000b _mbsnbset_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_574_0_2 {
	meta:
		name = "_mbsncat_s"
		size = 20
		refs = "000b _mbsncat_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_363_0_4 {
	meta:
		name = "_mbsncpy_s"
		size = 20
		refs = "000b _mbsncpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_415_0_3 {
	meta:
		name = "_mbsnset_s"
		size = 20
		refs = "000b _mbsnset_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_675_7_3 {
	meta:
		name = "wctomb_s"
		size = 20
		refs = "000b _wctomb_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "??$common_getpath@D@@YAPEADQEBDQEAD_K@Z"
		size = 172
		refs = "000d _errno"
	strings:
		$1 = { 48 83 EC 28 45 33 DB 48 85 D2 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 89 00 00 00 4D 85 C0 74 03 44 88 1A 49 83 F8 01 76 E0 EB 03 48 FF C1 80 39 3B 74 F8 4D 8D 48 FF 4C 8B D1 4C 03 CA 8A 01 84 C0 74 4F 3C 3B 74 48 48 FF C1 3C 22 75 27 8A 01 84 C0 74 3E 3C 22 74 13 88 02 48 FF C1 48 FF C2 49 3B D1 74 1A 8A 01 84 C0 75 E9 44 38 19 74 22 48 FF C1 EB C8 88 02 48 FF C2 49 3B D1 75 BE 44 88 1A E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 85 48 FF C1 80 39 3B 74 F8 49 3B CA 44 88 1A 49 0F 44 CB 48 8B C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "??$common_getpath@_W@@YAPEA_WQEB_WQEA_W_K@Z"
		size = 215
		refs = "000f _errno"
	strings:
		$1 = { 40 57 48 83 EC 20 45 33 DB 48 85 D2 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 B1 00 00 00 4D 85 C0 74 04 66 44 89 1A 49 83 F8 01 76 DF EB 04 48 83 C1 02 66 83 39 3B 74 F6 0F B7 01 4D 8D 48 FF 4E 8D 0C 4A 4C 8B D1 66 85 C0 74 6F BF 22 00 00 00 66 83 F8 3B 74 60 48 83 C1 02 66 3B C7 75 31 0F B7 01 66 85 C0 74 53 66 3B C7 74 18 66 89 02 48 83 C1 02 48 83 C2 02 49 3B D1 74 2A 0F B7 01 66 85 C0 75 E3 66 44 39 19 74 30 48 83 C1 02 EB 0C 66 89 02 48 83 C2 02 49 3B D1 74 0A 0F B7 01 66 85 C0 74 16 EB AA 66 44 89 1A E8 ?? ?? ?? ?? 89 38 E9 60 FF FF FF 48 83 C1 02 66 83 39 3B 74 F6 49 3B CA 66 44 89 1A 49 0F 44 CB 48 8B C1 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_187_2_0 {
	meta:
		name = "__acrt_getpath"
		size = 175
		refs = "000e _errno"
	strings:
		$1 = { 40 53 48 83 EC 20 33 DB 48 85 D2 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 89 00 00 00 4D 85 C0 74 02 88 1A 49 83 F8 01 76 E3 41 B3 3B EB 03 48 FF C1 44 38 19 74 F8 4D 8D 48 FF 4C 8B D1 4C 03 CA 8A 01 84 C0 74 4E 41 3A C3 74 46 48 FF C1 3C 22 75 26 8A 01 84 C0 74 3C 3C 22 74 13 88 02 48 FF C1 48 FF C2 49 3B D1 74 19 8A 01 84 C0 75 E9 38 19 74 21 48 FF C1 EB C8 88 02 48 FF C2 49 3B D1 75 BE 88 1A E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 14 48 FF C1 44 38 19 74 F8 49 3B CA 88 1A 48 0F 44 CB 48 8B D9 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_187_3_0 {
	meta:
		name = "__acrt_wgetpath"
		size = 222
		refs = "0012 _errno"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 DB 48 85 D2 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 AF 00 00 00 4D 85 C0 74 03 66 89 1A 49 83 F8 01 76 E2 66 41 BB 3B 00 EB 04 48 83 C1 02 66 44 39 19 74 F6 0F B7 01 4D 8D 48 FF 4E 8D 0C 4A 4C 8B D1 66 85 C0 74 6A BF 22 00 00 00 66 41 3B C3 74 5B 48 83 C1 02 66 3B C7 75 30 0F B7 01 66 85 C0 74 4E 66 3B C7 74 18 66 89 02 48 83 C1 02 48 83 C2 02 49 3B D1 74 29 0F B7 01 66 85 C0 75 E3 66 39 19 74 2C 48 83 C1 02 EB 0C 66 89 02 48 83 C2 02 49 3B D1 74 0A 0F B7 01 66 85 C0 74 12 EB AB 66 89 1A E8 ?? ?? ?? ?? 89 38 EB 17 48 83 C1 02 66 44 39 19 74 F6 49 3B CA 66 89 1A 48 0F 44 CB 48 8B D9 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_188_3_0 {
	meta:
		name = "?_wcstombs_l_helper@@YA_KPEADPEB_W_KPEAU__crt_locale_pointers@@@Z"
		size = 818
		refs = "001d __security_cookie 0052 _errno 005d _invalid_parameter_noinfo 0072 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 012f __imp_WideCharToMultiByte 01a5 __imp_GetLastError 0313 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 45 33 E4 49 8B F0 44 89 65 C0 4C 8B F2 4C 8B F9 41 8B DC 48 85 C9 74 0C 4D 85 C0 75 07 33 C0 E9 BF 02 00 00 48 85 D2 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF E9 A1 02 00 00 49 8B D1 48 8D 4D C8 E8 ?? ?? ?? ?? 4D 85 FF 0F 84 E5 01 00 00 48 8B 4D D0 4C 39 A1 38 01 00 00 75 47 48 85 F6 0F 84 5F 02 00 00 B9 FF 00 00 00 66 41 39 0E 77 25 41 8A 06 41 88 04 1F 41 0F B7 06 49 83 C6 02 66 85 C0 0F 84 3C 02 00 00 48 FF C3 48 3B DE 72 DA E9 2F 02 00 00 E8 ?? ?? ?? ?? 48 83 CB FF E9 1B 02 00 00 83 79 08 01 75 7A 48 85 F6 74 2D 49 8B C6 48 8B D6 66 44 39 20 74 0A 48 83 C0 02 48 83 EA 01 75 F0 48 85 D2 74 12 66 44 39 20 75 0C 48 8B F0 49 2B F6 48 D1 FE 48 FF C6 8B 49 0C 48 8D 45 C0 48 89 44 24 38 44 8B CE 4C 89 64 24 30 4D 8B C6 89 74 24 28 33 D2 4C 89 7C 24 20 FF 15 ?? ?? ?? ?? 48 63 D8 85 C0 74 8B 44 39 65 C0 75 85 45 38 64 1F FF 0F 85 A9 01 00 00 48 FF CB E9 A1 01 00 00 8B 49 0C 48 8D 45 C0 48 89 44 24 38 48 83 CB FF 4C 89 64 24 30 44 8B CB 89 74 24 28 4D 8B C6 33 D2 4C 89 7C 24 20 FF 15 ?? ?? ?? ?? 48 63 F8 85 C0 74 13 44 39 65 C0 0F 85 59 01 00 00 48 8D 5F FF E9 5B 01 00 00 44 39 65 C0 0F 85 46 01 00 00 FF 15 ?? ?? ?? ?? 83 F8 7A 0F 85 37 01 00 00 48 85 F6 0F 84 3C 01 00 00 44 8D 68 8B 48 8B 4D D0 48 8D 55 C0 48 89 54 24 38 41 B9 01 00 00 00 4C 89 64 24 30 4D 8B C6 8B 41 08 41 3B C5 8B 49 0C 41 0F 4F C5 33 D2 89 44 24 28 48 8D 45 E8 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E5 00 00 00 44 39 65 C0 0F 85 DB 00 00 00 85 C0 0F 88 D3 00 00 00 48 63 D0 49 3B D5 0F 87 C7 00 00 00 48 8D 04 3A 48 3B C6 0F 87 C8 00 00 00 49 8B CC 48 85 D2 7E 1B 8A 44 0D E8 41 88 04 3F 84 C0 0F 84 B0 00 00 00 48 FF C1 48 FF C7 48 3B CA 7C E5 49 83 C6 02 48 3B FE 0F 83 98 00 00 00 E9 5B FF FF FF 48 8B 45 D0 4C 39 A0 38 01 00 00 75 39 41 0F B7 06 49 8B FC 66 85 C0 74 7A B9 FF 00 00 00 66 3B C1 77 12 49 83 C6 02 48 FF C7 41 0F B7 06 66 85 C0 75 EB EB 5E E8 ?? ?? ?? ?? 48 83 CF FF C7 00 2A 00 00 00 EB 4D 48 8D 4D C0 48 83 CB FF 48 89 4C 24 38 44 8B CB 8B 48 0C 4D 8B C6 4C 89 64 24 30 33 D2 44 89 64 24 28 4C 89 64 24 20 FF 15 ?? ?? ?? ?? 48 63 F8 85 C0 74 0B 44 39 65 C0 75 05 48 FF CF EB 0E E8 ?? ?? ?? ?? C7 00 2A 00 00 00 48 8B FB 44 38 65 E0 74 0B 48 8B 4D C8 83 A1 A8 03 00 00 FD 48 8B C7 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 D8 00 00 00 48 81 C4 80 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_188_4_0 {
	meta:
		name = "?wcsncnt@@YA_KPEB_W_K@Z"
		size = 55
	strings:
		$1 = { 45 33 C9 48 8B C1 4C 8B C2 48 85 D2 74 25 66 44 39 08 74 0A 48 83 C0 02 49 83 E8 01 75 F0 4D 85 C0 74 10 66 44 39 08 75 0A 48 2B C1 48 D1 F8 48 FF C0 C3 48 8B C2 C3 }
	condition:
		$1
}

rule file_188_7_0 {
	meta:
		name = "_wcstombs_s_l"
		size = 236
		refs = "005f ?_wcstombs_l_helper@@YA_KPEADPEB_W_KPEAU__crt_locale_pointers@@@Z 0072 _errno 008c _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 45 33 F6 49 8B C1 49 8B F8 48 8B DA 48 8B F1 48 85 D2 74 51 4D 85 C0 74 51 48 85 D2 74 03 44 88 32 48 85 C9 74 03 4C 21 31 4C 8B 44 24 50 4C 3B C7 4C 0F 47 C7 49 81 F8 FF FF FF 7F 77 2C 4C 8B 4C 24 58 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 83 F8 FF 75 2B 48 85 DB 74 03 44 88 33 E8 ?? ?? ?? ?? 8B 00 EB 5C 4D 85 C0 74 AF E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 42 48 FF C0 48 85 DB 74 2F 48 3B C7 76 25 48 83 7C 24 50 FF 74 14 44 88 33 48 3B F8 77 0C E8 ?? ?? ?? ?? BB 22 00 00 00 EB CC 48 8B C7 41 BE 50 00 00 00 C6 44 18 FF 00 48 85 F6 74 03 48 89 06 41 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "nearbyintf"
		size = 44
		refs = "0010 _fdtest 0023 _fdrint"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? F3 0F 10 44 24 30 0F BF C8 83 F9 02 76 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_190_17_0 {
	meta:
		name = "puts"
		size = 260
		refs = "0013 _errno 001e _invalid_parameter_noinfo 0031 __acrt_iob_func 0048 _fileno 0052 __badioinfo 0059 __pioinfo 00fa ??$?RV<lambda_047e091329b3cc2dd92c1150cfbc4be8>@@AEAV<lambda_3126a0d026c48c72336a1719c85146ae>@@V<lambda_8e8daf2dfdb49c56842017fc8f5e8e6a>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_047e091329b3cc2dd92c1150cfbc4be8>@@AEAV<lambda_3126a0d026c48c72336a1719c85146ae>@@$$QEAV<lambda_8e8daf2dfdb49c56842017fc8f5e8e6a>@@@Z"
	strings:
		$1 = { 48 89 4C 24 08 55 48 8B EC 48 83 EC 50 48 85 C9 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF E9 D3 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 89 45 20 8B 48 14 C1 E9 0C F6 C1 01 75 6C 48 8B C8 E8 ?? ?? ?? ?? 4C 63 C8 48 8D 15 ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? 41 8D 49 02 83 F9 01 76 18 4D 8B C1 49 8B C9 41 83 E0 3F 48 C1 F9 06 49 C1 E0 06 4D 03 04 CA EB 03 4C 8B C2 41 80 78 39 00 75 8A 41 8D 41 02 83 F8 01 76 15 49 8B D1 49 8B C1 83 E2 3F 48 C1 F8 06 48 C1 E2 06 49 03 14 C2 F6 42 3D 01 0F 85 62 FF FF FF 48 8B 4D 10 48 83 C8 FF 48 FF C0 80 3C 01 00 75 F7 48 89 45 28 4C 8D 4D D0 48 8D 45 20 48 89 45 E0 4C 8D 45 E0 48 8D 45 10 48 89 45 E8 48 8D 55 D8 48 8D 45 28 48 89 45 F0 48 8D 4D 18 48 8B 45 20 48 89 45 D0 48 89 45 D8 E8 ?? ?? ?? ?? 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_mbsninc"
		size = 35
		refs = "0014 _mbsnbcnt_l"
	strings:
		$1 = { 40 53 48 83 EC 20 33 C0 48 8B D9 48 85 C9 74 0D 45 33 C0 E8 ?? ?? ?? ?? 8B C0 48 03 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_191_1_0 {
	meta:
		name = "_mbsninc_l"
		size = 34
		refs = "0013 _mbsnbcnt_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 C9 75 04 33 C0 EB 0A E8 ?? ?? ?? ?? 8B C0 48 03 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "wctrans"
		size = 103
		refs = "0008 ?tab@@3QBUwctab@@B"
		altNames = "wctype"
	strings:
		$1 = { 48 89 5C 24 08 48 8B 05 ?? ?? ?? ?? 45 33 DB 4C 8B D1 41 8B D3 48 85 C0 74 36 48 8D 1D ?? ?? ?? ?? 4D 8B CA 4C 2B C8 0F B6 08 46 0F B6 04 08 41 2B C8 75 08 48 FF C0 45 85 C0 75 EB 85 C9 74 1A FF C2 8B C2 48 03 C0 48 8B 04 C3 48 85 C0 75 D1 41 0F B7 C3 48 8B 5C 24 08 C3 8B C2 48 C1 E0 04 0F B7 44 18 08 EB ED }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "_finitef"
		size = 23
	strings:
		$1 = { F3 0F 11 44 24 08 8B 44 24 08 0F BA F0 1F 2D 00 00 80 7F C1 E8 1F C3 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "??$common_tcsset_s@D@@YAHQEAD_KD@Z"
		size = 80
		refs = "0033 _errno 003e _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 45 33 C9 48 85 C9 74 26 48 85 D2 74 21 48 8B C1 44 38 09 74 11 48 83 EA 01 74 0B 44 88 00 48 FF C0 44 38 08 75 EF 48 85 D2 75 1D 44 88 09 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 48 83 C4 28 C3 33 C0 EB F7 }
	condition:
		$1
}

rule file_194_1_0 {
	meta:
		name = "_strset_s"
		size = 73
		refs = "0031 _errno 003d _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 33 DB 48 85 C9 74 23 48 85 D2 74 1E 48 8B C1 38 19 74 10 48 83 EA 01 74 0A 44 88 00 48 FF C0 38 18 75 F0 48 85 D2 75 13 88 19 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_195_1_0 {
	meta:
		name = "_mbctokata_l"
		size = 41
		refs = "0009 _ismbchira_l"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 85 C0 74 10 81 C3 A1 00 00 00 81 FB 7F 83 00 00 72 02 FF C3 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_196_5_0 {
	meta:
		name = "_ismbslead_l"
		size = 148
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 0037 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B FA 48 8B D9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 60 48 85 D2 74 E7 49 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 30 83 79 08 00 74 2E 48 3B DF 77 29 80 3B 00 74 24 0F B6 03 F6 44 08 19 04 74 10 48 8B C3 48 FF C3 48 3B C7 74 0A 80 3B 00 74 0A 48 FF C3 EB D7 83 C8 FF EB 02 33 C0 80 7C 24 38 00 74 0C 48 8B 4C 24 20 83 A1 A8 03 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "__dcrt_lowio_initialize_console_output"
		size = 59
		refs = "000d ??_C@_1BA@BALFACEM@?$AAC?$AAO?$AAN?$AAO?$AAU?$AAT?$AA$?$AA?$AA@ 002b __imp_CreateFileW 0032 __dcrt_lowio_console_output_handle"
	strings:
		$1 = { 48 83 EC 48 48 83 64 24 30 00 48 8D 0D ?? ?? ?? ?? 83 64 24 28 00 41 B8 03 00 00 00 45 33 C9 44 89 44 24 20 BA 00 00 00 40 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "_wchmod"
		size = 155
		refs = "000d __security_cookie 0024 __doserrno 002b _errno 0036 _invalid_parameter_noinfo 0048 __imp_GetFileAttributesExW 0052 __imp_GetLastError 0059 __acrt_errno_map_os_error 0079 __imp_SetFileAttributesW 008c __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 48 8B FA 48 8B D9 48 85 C9 75 1C E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 44 4C 8D 44 24 20 33 D2 FF 15 ?? ?? ?? ?? 85 C0 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB DB 8B 54 24 20 40 84 FF 79 05 83 E2 FE EB 03 83 CA 01 48 8B CB 89 54 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 CF 33 C0 48 8B 4C 24 48 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_199_14_0 {
	meta:
		name = "??$common_fstat@U_stat32@@@@YAHHQEAU_stat32@@@Z"
		size = 241
		refs = "001b __doserrno 0022 _errno 003c memset 0079 _nhandle 0085 __pioinfo 00c9 ??$?RV<lambda_96b0dce3ad2a93c5c9ed548730f377b6>@@AEAV<lambda_400f06e00cd32245fa85628833e911d2>@@V<lambda_da1c5379cfd7439e775ba9665cd8bf87>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_96b0dce3ad2a93c5c9ed548730f377b6>@@AEAV<lambda_400f06e00cd32245fa85628833e911d2>@@$$QEAV<lambda_da1c5379cfd7439e775ba9665cd8bf87>@@@Z 00e3 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 55 53 48 8B EC 48 83 EC 68 48 8B DA 48 85 D2 75 17 E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 B1 00 00 00 33 D2 48 8D 4D D0 44 8D 42 24 E8 ?? ?? ?? ?? 0F 10 45 D0 8B 45 F0 0F 10 4D E0 0F 11 03 0F 11 4B 10 89 43 20 48 63 55 18 83 FA FE 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 74 85 D2 78 58 3B 15 ?? ?? ?? ?? 7D 50 48 8B CA 4C 8D 05 ?? ?? ?? ?? 83 E1 3F 48 8B C2 48 C1 F8 06 48 C1 E1 06 49 8B 04 C0 F6 44 08 38 01 74 2D 48 8D 45 18 89 55 30 48 89 45 C0 4C 8D 4D 30 48 8D 45 20 89 55 B8 4C 8D 45 C0 48 89 45 C8 48 8D 55 B8 48 8D 4D 28 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 68 5B 5D C3 }
	condition:
		$1
}

rule file_199_15_0 {
	meta:
		name = "??$common_fstat@U_stat32i64@@@@YAHHQEAU_stat32i64@@@Z"
		size = 243
		refs = "001b __doserrno 0022 _errno 003c memset 007b _nhandle 0087 __pioinfo 00cb ??$?RV<lambda_a59c9183952f290e1f88b0789726fa45>@@AEAV<lambda_6fd52f3c2fb1c47a481b23175379f22a>@@V<lambda_4a930275767fc0415fefcffa3cf2c69f>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_a59c9183952f290e1f88b0789726fa45>@@AEAV<lambda_6fd52f3c2fb1c47a481b23175379f22a>@@$$QEAV<lambda_4a930275767fc0415fefcffa3cf2c69f>@@@Z 00e5 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 55 53 48 8B EC 48 83 EC 78 48 8B DA 48 85 D2 75 17 E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 B3 00 00 00 33 D2 48 8D 4D C0 44 8D 42 30 E8 ?? ?? ?? ?? 0F 10 45 C0 0F 10 4D D0 0F 11 03 0F 10 45 E0 0F 11 4B 10 0F 11 43 20 48 63 55 18 83 FA FE 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 74 85 D2 78 58 3B 15 ?? ?? ?? ?? 7D 50 48 8B CA 4C 8D 05 ?? ?? ?? ?? 83 E1 3F 48 8B C2 48 C1 F8 06 48 C1 E1 06 49 8B 04 C0 F6 44 08 38 01 74 2D 48 8D 45 18 89 55 30 48 89 45 B0 4C 8D 4D 30 48 8D 45 20 89 55 A8 4C 8D 45 B0 48 89 45 B8 48 8D 55 A8 48 8D 4D 28 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 78 5B 5D C3 }
	condition:
		$1
}

rule file_199_17_0 {
	meta:
		name = "??$common_fstat@U_stat64i32@@@@YAHHQEAU_stat64i32@@@Z"
		size = 243
		refs = "001b __doserrno 0022 _errno 003c memset 007b _nhandle 0087 __pioinfo 00cb ??$?RV<lambda_3a04bfe258a31910a526c90b4d849d20>@@AEAV<lambda_1b3ad63c02abf531fe15530b52bade31>@@V<lambda_1755787d260f86bf828f8bf7552b2658>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_3a04bfe258a31910a526c90b4d849d20>@@AEAV<lambda_1b3ad63c02abf531fe15530b52bade31>@@$$QEAV<lambda_1755787d260f86bf828f8bf7552b2658>@@@Z 00e5 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 55 53 48 8B EC 48 83 EC 78 48 8B DA 48 85 D2 75 17 E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 B3 00 00 00 33 D2 48 8D 4D C0 44 8D 42 30 E8 ?? ?? ?? ?? 0F 10 45 C0 0F 10 4D D0 0F 11 03 0F 10 45 E0 0F 11 4B 10 0F 11 43 20 48 63 55 18 83 FA FE 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 74 85 D2 78 58 3B 15 ?? ?? ?? ?? 7D 50 48 8B CA 4C 8D 05 ?? ?? ?? ?? 83 E1 3F 48 8B C2 48 C1 F8 06 48 C1 E1 06 49 8B 04 C0 F6 44 08 38 01 74 2D 48 8D 45 18 89 55 30 48 89 45 B0 4C 8D 4D 30 48 8D 45 20 89 55 A8 4C 8D 45 B0 48 89 45 B8 48 8D 55 A8 48 8D 4D 28 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 78 5B 5D C3 }
	condition:
		$1
}

rule file_199_16_0 {
	meta:
		name = "??$common_fstat@U_stat64@@@@YAHHQEAU_stat64@@@Z"
		size = 253
		refs = "001b __doserrno 0022 _errno 003c memset 0085 _nhandle 0091 __pioinfo 00d5 ??$?RV<lambda_d6a03b27cb314eb65d447ab85fffcbf2>@@AEAV<lambda_3e61fc1153d2eec3991e8733eecb5419>@@V<lambda_8d9723598c44aced2bc47669cc68e4e1>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_d6a03b27cb314eb65d447ab85fffcbf2>@@AEAV<lambda_3e61fc1153d2eec3991e8733eecb5419>@@$$QEAV<lambda_8d9723598c44aced2bc47669cc68e4e1>@@@Z 00ef _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 55 53 48 8B EC 48 83 EC 78 48 8B DA 48 85 D2 75 17 E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 BD 00 00 00 33 D2 48 8D 4D C0 44 8D 42 38 E8 ?? ?? ?? ?? 0F 10 45 C0 0F 10 4D D0 0F 11 03 0F 10 45 E0 0F 11 4B 10 F2 0F 10 4D F0 0F 11 43 20 F2 0F 11 4B 30 48 63 55 18 83 FA FE 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 74 85 D2 78 58 3B 15 ?? ?? ?? ?? 7D 50 48 8B CA 4C 8D 05 ?? ?? ?? ?? 83 E1 3F 48 8B C2 48 C1 F8 06 48 C1 E1 06 49 8B 04 C0 F6 44 08 38 01 74 2D 48 8D 45 18 89 55 30 48 89 45 B0 4C 8D 4D 30 48 8D 45 20 89 55 A8 4C 8D 45 B0 48 89 45 B8 48 8D 55 A8 48 8D 4D 28 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 78 5B 5D C3 }
	condition:
		$1
}

rule file_199_18_0 {
	meta:
		name = "??$common_stat@U_stat32@@@@YAHQEBDQEAU_stat32@@@Z"
		size = 79
		refs = "000f ??$common_stat@U_stat32@@@@YAHQEB_WQEAU_stat32@@@Z 0021 __acrt_copy_path_to_wide_string 0043 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 34 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0F 48 8B 4C 24 30 48 8B D3 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_20_0 {
	meta:
		name = "??$common_stat@U_stat32i64@@@@YAHQEBDQEAU_stat32i64@@@Z"
		size = 79
		refs = "000f ??$common_stat@U_stat32i64@@@@YAHQEB_WQEAU_stat32i64@@@Z 0021 __acrt_copy_path_to_wide_string 0043 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 34 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0F 48 8B 4C 24 30 48 8B D3 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_22_0 {
	meta:
		name = "??$common_stat@U_stat64@@@@YAHQEBDQEAU_stat64@@@Z"
		size = 79
		refs = "000f ??$common_stat@U_stat64@@@@YAHQEB_WQEAU_stat64@@@Z 0021 __acrt_copy_path_to_wide_string 0043 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 34 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0F 48 8B 4C 24 30 48 8B D3 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_24_0 {
	meta:
		name = "??$common_stat@U_stat64i32@@@@YAHQEBDQEAU_stat64i32@@@Z"
		size = 79
		refs = "000f ??$common_stat@U_stat64i32@@@@YAHQEB_WQEAU_stat64i32@@@Z 0021 __acrt_copy_path_to_wide_string 0043 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 85 C9 75 07 E8 ?? ?? ?? ?? EB 34 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 CB FF EB 0F 48 8B 4C 24 30 48 8B D3 E8 ?? ?? ?? ?? 8B D8 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_19_0 {
	meta:
		name = "??$common_stat@U_stat32@@@@YAHQEB_WQEAU_stat32@@@Z"
		size = 391
		refs = "0027 __doserrno 002e _errno 0039 _invalid_parameter_noinfo 0055 memset 0098 __imp_CreateFileW 00b2 ??$common_stat_handle_file_opened@U_stat32@@@@YA_NQEB_WHQEAXAEAU_stat32@@@Z 00eb __imp_CloseHandle 010b ?is_usable_drive_or_unc_root@@YA_NQEB_W@Z 0119 __acrt_errno_map_os_error 0128 ?convert_to_stat_mode@@YAGHQEB_W@Z 0146 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0178 __loctotime32_t"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 55 57 41 54 41 56 41 57 48 8B EC 48 83 EC 70 33 F6 48 8B FA 4C 8B F1 48 85 D2 75 1F E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 AC 00 00 00 41 BF 24 00 00 00 48 8D 4D D0 45 8B C7 33 D2 E8 ?? ?? ?? ?? 8B 45 F0 0F 10 45 D0 0F 10 4D E0 0F 11 07 0F 11 4F 10 89 47 20 4D 85 F6 74 B3 48 89 74 24 30 41 8D 57 5C C7 44 24 28 00 00 00 02 45 8D 47 E3 45 33 C9 C7 44 24 20 03 00 00 00 49 8B CE FF 15 ?? ?? ?? ?? 48 8B D8 49 8B CE 48 83 F8 FF 74 62 4C 8B CF 4C 8B C0 83 CA FF E8 ?? ?? ?? ?? 84 C0 75 26 4D 8B C7 48 8D 4D D0 33 D2 E8 ?? ?? ?? ?? 0F 10 45 D0 8B 45 F0 83 CE FF 0F 10 4D E0 0F 11 07 0F 11 4F 10 89 47 20 48 83 FB FF 74 09 48 8B CB FF 15 ?? ?? ?? ?? 8B C6 4C 8D 5C 24 70 49 8B 5B 30 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5C 5F 5D C3 E8 ?? ?? ?? ?? 84 C0 75 0C B9 02 00 00 00 E8 ?? ?? ?? ?? EB 9B 49 8B D6 B9 10 00 00 00 E8 ?? ?? ?? ?? 41 BC 01 00 00 00 66 89 47 06 48 8D 55 38 66 44 89 67 08 49 8B CE 89 75 38 E8 ?? ?? ?? ?? 84 C0 0F 84 68 FF FF FF 83 4C 24 30 FF 45 33 C9 8B 45 38 45 8B C4 FF C8 89 74 24 28 41 8B D4 89 47 10 B9 BC 07 00 00 89 07 89 74 24 20 E8 ?? ?? ?? ?? 89 47 1C 89 47 18 E9 56 FF FF FF }
	condition:
		$1
}

rule file_199_21_0 {
	meta:
		name = "??$common_stat@U_stat32i64@@@@YAHQEB_WQEAU_stat32i64@@@Z"
		size = 398
		refs = "0027 __doserrno 002e _errno 0039 _invalid_parameter_noinfo 0055 memset 009a __imp_CreateFileW 00b4 ??$common_stat_handle_file_opened@U_stat32i64@@@@YA_NQEB_WHQEAXAEAU_stat32i64@@@Z 00ef __imp_CloseHandle 010f ?is_usable_drive_or_unc_root@@YA_NQEB_W@Z 011d __acrt_errno_map_os_error 012c ?convert_to_stat_mode@@YAGHQEB_W@Z 014a ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 017c __loctotime32_t"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 55 57 41 54 41 56 41 57 48 8B EC 48 83 EC 70 33 F6 48 8B FA 4C 8B F1 48 85 D2 75 1F E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B0 00 00 00 41 BF 30 00 00 00 48 8D 4D D0 45 8B C7 33 D2 E8 ?? ?? ?? ?? 0F 10 45 D0 0F 10 4D E0 0F 11 07 0F 10 45 F0 0F 11 4F 10 0F 11 47 20 4D 85 F6 74 B1 48 89 74 24 30 41 8D 57 50 C7 44 24 28 00 00 00 02 45 8D 47 D7 45 33 C9 C7 44 24 20 03 00 00 00 49 8B CE FF 15 ?? ?? ?? ?? 48 8B D8 49 8B CE 48 83 F8 FF 74 64 4C 8B CF 4C 8B C0 83 CA FF E8 ?? ?? ?? ?? 84 C0 75 28 4D 8B C7 48 8D 4D D0 33 D2 E8 ?? ?? ?? ?? 0F 10 45 D0 83 CE FF 0F 10 4D E0 0F 11 07 0F 10 45 F0 0F 11 4F 10 0F 11 47 20 48 83 FB FF 74 09 48 8B CB FF 15 ?? ?? ?? ?? 8B C6 4C 8D 5C 24 70 49 8B 5B 30 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5C 5F 5D C3 E8 ?? ?? ?? ?? 84 C0 75 0C B9 02 00 00 00 E8 ?? ?? ?? ?? EB 99 49 8B D6 B9 10 00 00 00 E8 ?? ?? ?? ?? 41 BC 01 00 00 00 66 89 47 06 48 8D 55 38 66 44 89 67 08 49 8B CE 89 75 38 E8 ?? ?? ?? ?? 84 C0 0F 84 66 FF FF FF 83 4C 24 30 FF 45 33 C9 8B 45 38 45 8B C4 FF C8 89 74 24 28 41 8B D4 89 47 10 B9 BC 07 00 00 89 07 89 74 24 20 E8 ?? ?? ?? ?? 89 47 24 89 47 20 89 47 28 E9 56 FF FF FF }
	condition:
		$1
}

rule file_199_23_0 {
	meta:
		name = "??$common_stat@U_stat64@@@@YAHQEB_WQEAU_stat64@@@Z"
		size = 427
		refs = "002a __doserrno 0031 _errno 003c _invalid_parameter_noinfo 0058 memset 00a7 __imp_CreateFileW 00c1 ??$common_stat_handle_file_opened@U_stat64@@@@YA_NQEB_WHQEAXAEAU_stat64@@@Z 0106 __imp_CloseHandle 0129 ?is_usable_drive_or_unc_root@@YA_NQEB_W@Z 0137 __acrt_errno_map_os_error 0146 ?convert_to_stat_mode@@YAGHQEB_W@Z 0164 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0196 __loctotime64_t"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 55 57 41 54 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 33 F6 48 8B FA 4C 8B F1 48 85 D2 75 1F E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 C4 00 00 00 41 BF 38 00 00 00 48 8D 4D C0 45 8B C7 33 D2 E8 ?? ?? ?? ?? 0F 10 45 C0 0F 10 4D D0 0F 11 07 0F 10 45 E0 0F 11 4F 10 F2 0F 10 4D F0 0F 11 47 20 F2 0F 11 4F 30 4D 85 F6 74 A7 48 89 74 24 30 41 8D 57 48 C7 44 24 28 00 00 00 02 45 8D 47 CF 45 33 C9 C7 44 24 20 03 00 00 00 49 8B CE FF 15 ?? ?? ?? ?? 48 8B D8 49 8B CE 48 83 F8 FF 74 71 4C 8B CF 4C 8B C0 83 CA FF E8 ?? ?? ?? ?? 84 C0 75 32 4D 8B C7 48 8D 4D C0 33 D2 E8 ?? ?? ?? ?? 0F 10 45 C0 83 CE FF 0F 10 4D D0 0F 11 07 0F 10 45 E0 0F 11 4F 10 F2 0F 10 4D F0 0F 11 47 20 F2 0F 11 4F 30 48 83 FB FF 74 09 48 8B CB FF 15 ?? ?? ?? ?? 8B C6 4C 8D 9C 24 80 00 00 00 49 8B 5B 30 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5C 5F 5D C3 E8 ?? ?? ?? ?? 84 C0 75 0C B9 02 00 00 00 E8 ?? ?? ?? ?? EB 8C 49 8B D6 B9 10 00 00 00 E8 ?? ?? ?? ?? 41 BC 01 00 00 00 66 89 47 06 48 8D 55 38 66 44 89 67 08 49 8B CE 89 75 38 E8 ?? ?? ?? ?? 84 C0 0F 84 59 FF FF FF 83 4C 24 30 FF 45 33 C9 8B 45 38 45 8B C4 FF C8 89 74 24 28 41 8B D4 89 47 10 B9 BC 07 00 00 89 07 89 74 24 20 E8 ?? ?? ?? ?? 48 89 47 28 48 89 47 20 48 89 47 30 E9 50 FF FF FF }
	condition:
		$1
}

rule file_199_25_0 {
	meta:
		name = "??$common_stat@U_stat64i32@@@@YAHQEB_WQEAU_stat64i32@@@Z"
		size = 401
		refs = "0027 __doserrno 002e _errno 0039 _invalid_parameter_noinfo 0055 memset 009a __imp_CreateFileW 00b4 ??$common_stat_handle_file_opened@U_stat64i32@@@@YA_NQEB_WHQEAXAEAU_stat64i32@@@Z 00ef __imp_CloseHandle 010f ?is_usable_drive_or_unc_root@@YA_NQEB_W@Z 011d __acrt_errno_map_os_error 012c ?convert_to_stat_mode@@YAGHQEB_W@Z 014a ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 017c __loctotime64_t"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 55 57 41 54 41 56 41 57 48 8B EC 48 83 EC 70 33 F6 48 8B FA 4C 8B F1 48 85 D2 75 1F E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B0 00 00 00 41 BF 30 00 00 00 48 8D 4D D0 45 8B C7 33 D2 E8 ?? ?? ?? ?? 0F 10 45 D0 0F 10 4D E0 0F 11 07 0F 10 45 F0 0F 11 4F 10 0F 11 47 20 4D 85 F6 74 B1 48 89 74 24 30 41 8D 57 50 C7 44 24 28 00 00 00 02 45 8D 47 D7 45 33 C9 C7 44 24 20 03 00 00 00 49 8B CE FF 15 ?? ?? ?? ?? 48 8B D8 49 8B CE 48 83 F8 FF 74 64 4C 8B CF 4C 8B C0 83 CA FF E8 ?? ?? ?? ?? 84 C0 75 28 4D 8B C7 48 8D 4D D0 33 D2 E8 ?? ?? ?? ?? 0F 10 45 D0 83 CE FF 0F 10 4D E0 0F 11 07 0F 10 45 F0 0F 11 4F 10 0F 11 47 20 48 83 FB FF 74 09 48 8B CB FF 15 ?? ?? ?? ?? 8B C6 4C 8D 5C 24 70 49 8B 5B 30 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5C 5F 5D C3 E8 ?? ?? ?? ?? 84 C0 75 0C B9 02 00 00 00 E8 ?? ?? ?? ?? EB 99 49 8B D6 B9 10 00 00 00 E8 ?? ?? ?? ?? 41 BC 01 00 00 00 66 89 47 06 48 8D 55 38 66 44 89 67 08 49 8B CE 89 75 38 E8 ?? ?? ?? ?? 84 C0 0F 84 66 FF FF FF 83 4C 24 30 FF 45 33 C9 8B 45 38 45 8B C4 FF C8 89 74 24 28 41 8B D4 89 47 10 B9 BC 07 00 00 89 07 89 74 24 20 E8 ?? ?? ?? ?? 48 89 47 20 48 89 47 18 48 89 47 28 E9 53 FF FF FF }
	condition:
		$1
}

rule file_199_26_0 {
	meta:
		name = "??$common_stat_handle_file_not_opened@U_stat32@@@@YA_NQEB_WAEAU_stat32@@@Z"
		size = 164
		refs = "0016 ?is_usable_drive_or_unc_root@@YA_NQEB_W@Z 0024 __acrt_errno_map_os_error 0035 ?convert_to_stat_mode@@YAGHQEB_W@Z 0054 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0084 __loctotime32_t"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 57 48 83 EC 40 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 84 C0 75 0E B9 02 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 68 48 8B D7 B9 10 00 00 00 E8 ?? ?? ?? ?? 83 64 24 60 00 48 8D 54 24 60 BD 01 00 00 00 66 89 43 06 48 8B CF 66 89 6B 08 E8 ?? ?? ?? ?? 84 C0 74 CC 83 4C 24 30 FF 45 33 C9 8B 44 24 60 44 8B C5 83 64 24 28 00 FF C8 83 64 24 20 00 8B D5 B9 BC 07 00 00 89 43 10 89 03 E8 ?? ?? ?? ?? 89 43 1C 89 43 18 89 43 20 40 8A C5 48 8B 5C 24 50 48 8B 6C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_199_27_0 {
	meta:
		name = "??$common_stat_handle_file_not_opened@U_stat32i64@@@@YA_NQEB_WAEAU_stat32i64@@@Z"
		size = 164
		refs = "0016 ?is_usable_drive_or_unc_root@@YA_NQEB_W@Z 0024 __acrt_errno_map_os_error 0035 ?convert_to_stat_mode@@YAGHQEB_W@Z 0054 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0084 __loctotime32_t"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 57 48 83 EC 40 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 84 C0 75 0E B9 02 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 68 48 8B D7 B9 10 00 00 00 E8 ?? ?? ?? ?? 83 64 24 60 00 48 8D 54 24 60 BD 01 00 00 00 66 89 43 06 48 8B CF 66 89 6B 08 E8 ?? ?? ?? ?? 84 C0 74 CC 83 4C 24 30 FF 45 33 C9 8B 44 24 60 44 8B C5 83 64 24 28 00 FF C8 83 64 24 20 00 8B D5 B9 BC 07 00 00 89 43 10 89 03 E8 ?? ?? ?? ?? 89 43 24 89 43 20 89 43 28 40 8A C5 48 8B 5C 24 50 48 8B 6C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_199_28_0 {
	meta:
		name = "??$common_stat_handle_file_not_opened@U_stat64@@@@YA_NQEB_WAEAU_stat64@@@Z"
		size = 167
		refs = "0016 ?is_usable_drive_or_unc_root@@YA_NQEB_W@Z 0024 __acrt_errno_map_os_error 0035 ?convert_to_stat_mode@@YAGHQEB_W@Z 0054 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0084 __loctotime64_t"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 57 48 83 EC 40 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 84 C0 75 0E B9 02 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 6B 48 8B D7 B9 10 00 00 00 E8 ?? ?? ?? ?? 83 64 24 60 00 48 8D 54 24 60 BD 01 00 00 00 66 89 43 06 48 8B CF 66 89 6B 08 E8 ?? ?? ?? ?? 84 C0 74 CC 83 4C 24 30 FF 45 33 C9 8B 44 24 60 44 8B C5 83 64 24 28 00 FF C8 83 64 24 20 00 8B D5 B9 BC 07 00 00 89 43 10 89 03 E8 ?? ?? ?? ?? 48 89 43 28 48 89 43 20 48 89 43 30 40 8A C5 48 8B 5C 24 50 48 8B 6C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_199_29_0 {
	meta:
		name = "??$common_stat_handle_file_not_opened@U_stat64i32@@@@YA_NQEB_WAEAU_stat64i32@@@Z"
		size = 167
		refs = "0016 ?is_usable_drive_or_unc_root@@YA_NQEB_W@Z 0024 __acrt_errno_map_os_error 0035 ?convert_to_stat_mode@@YAGHQEB_W@Z 0054 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0084 __loctotime64_t"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 57 48 83 EC 40 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 84 C0 75 0E B9 02 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 6B 48 8B D7 B9 10 00 00 00 E8 ?? ?? ?? ?? 83 64 24 60 00 48 8D 54 24 60 BD 01 00 00 00 66 89 43 06 48 8B CF 66 89 6B 08 E8 ?? ?? ?? ?? 84 C0 74 CC 83 4C 24 30 FF 45 33 C9 8B 44 24 60 44 8B C5 83 64 24 28 00 FF C8 83 64 24 20 00 8B D5 B9 BC 07 00 00 89 43 10 89 03 E8 ?? ?? ?? ?? 48 89 43 20 48 89 43 18 48 89 43 28 40 8A C5 48 8B 5C 24 50 48 8B 6C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_199_30_0 {
	meta:
		name = "??$common_stat_handle_file_opened@U_stat32@@@@YA_NQEB_WHQEAXAEAU_stat32@@@Z"
		size = 411
		refs = "0019 __security_cookie 0035 __imp_GetFileType 0064 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0085 memset 0092 __imp_GetFileInformationByHandle 00a1 ?convert_to_stat_mode@@YAGHQEB_W@Z 00b0 ??$convert_filetime_to_time_t@J@@YAJU_FILETIME@@J@Z 00f2 _errno 011b __imp_GetLastError 0122 __acrt_errno_map_os_error 0167 __imp_PeekNamedPipe 0180 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 48 8B F9 49 8B D9 49 8B C8 49 8B F0 44 8B F2 FF 15 ?? ?? ?? ?? 8B C8 41 BF 01 00 00 00 0F BA F1 0F 41 3B CF 0F 85 B0 00 00 00 66 44 89 7B 08 48 85 FF 74 22 83 65 B0 00 48 8D 55 B0 48 8B CF E8 ?? ?? ?? ?? 84 C0 0F 84 A5 00 00 00 8B 45 B0 FF C8 89 43 10 89 03 33 D2 48 8D 4D B8 44 8D 42 34 E8 ?? ?? ?? ?? 48 8D 55 B8 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 7F 8B 4D B8 48 8B D7 E8 ?? ?? ?? ?? 48 8B 4D CC 33 D2 66 89 43 06 E8 ?? ?? ?? ?? 48 8B 4D C4 8B D0 89 43 1C E8 ?? ?? ?? ?? 8B 53 1C 48 8B 4D BC 89 43 18 E8 ?? ?? ?? ?? 89 43 20 83 63 14 00 83 7D D8 00 75 13 8B 4D DC 81 F9 FF FF FF 7F 77 08 89 4B 14 E9 84 00 00 00 E8 ?? ?? ?? ?? C7 00 84 00 00 00 EB 17 8D 41 FE 41 3B C7 76 22 85 C9 75 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 32 C0 EB 5F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB ED 83 F9 02 66 44 89 7B 08 B8 00 10 00 00 44 89 73 10 BA 00 20 00 00 44 89 33 66 0F 44 C2 66 89 43 06 74 2A 48 83 64 24 28 00 48 8D 45 B0 45 33 C9 48 89 44 24 20 45 33 C0 33 D2 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 06 8B 45 B0 89 43 14 41 8A C7 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B8 00 00 00 48 81 C4 80 00 00 00 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_199_31_0 {
	meta:
		name = "??$common_stat_handle_file_opened@U_stat32i64@@@@YA_NQEB_WHQEAXAEAU_stat32i64@@@Z"
		size = 421
		refs = "0019 __security_cookie 0035 __imp_GetFileType 0064 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0085 memset 0092 __imp_GetFileInformationByHandle 00a5 ?convert_to_stat_mode@@YAGHQEB_W@Z 00b4 ??$convert_filetime_to_time_t@J@@YAJU_FILETIME@@J@Z 00e7 _errno 0123 __imp_GetLastError 012a __acrt_errno_map_os_error 016f __imp_PeekNamedPipe 018a __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 48 8B F9 49 8B D9 49 8B C8 49 8B F0 44 8B F2 FF 15 ?? ?? ?? ?? 8B C8 41 BF 01 00 00 00 0F BA F1 0F 41 3B CF 0F 85 B8 00 00 00 66 44 89 7B 08 48 85 FF 74 22 83 65 B0 00 48 8D 55 B0 48 8B CF E8 ?? ?? ?? ?? 84 C0 0F 84 AD 00 00 00 8B 45 B0 FF C8 89 43 10 89 03 33 D2 48 8D 4D B8 44 8D 42 34 E8 ?? ?? ?? ?? 48 8D 55 B8 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 0F 84 83 00 00 00 8B 4D B8 48 8B D7 E8 ?? ?? ?? ?? 48 8B 4D CC 33 D2 66 89 43 06 E8 ?? ?? ?? ?? 48 8B 4D C4 8B D0 89 43 24 E8 ?? ?? ?? ?? 8B 53 24 48 8B 4D BC 89 43 20 E8 ?? ?? ?? ?? 89 43 28 48 83 63 18 00 81 7D D8 FF FF FF 7F 76 0D E8 ?? ?? ?? ?? C7 00 84 00 00 00 EB 2A 8B 55 D8 8B 4D DC 48 C1 E2 20 48 03 D1 48 89 53 18 EB 79 8D 41 FE 41 3B C7 76 22 85 C9 75 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 32 C0 EB 61 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB ED 83 F9 02 66 44 89 7B 08 B8 00 10 00 00 44 89 73 10 BA 00 20 00 00 44 89 33 66 0F 44 C2 66 89 43 06 74 2C 48 83 64 24 28 00 48 8D 45 B0 45 33 C9 48 89 44 24 20 45 33 C0 33 D2 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 08 48 63 45 B0 48 89 43 18 41 8A C7 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B8 00 00 00 48 81 C4 80 00 00 00 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_199_32_0 {
	meta:
		name = "??$common_stat_handle_file_opened@U_stat64@@@@YA_NQEB_WHQEAXAEAU_stat64@@@Z"
		size = 426
		refs = "0019 __security_cookie 0035 __imp_GetFileType 0064 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0085 memset 0092 __imp_GetFileInformationByHandle 00a5 ?convert_to_stat_mode@@YAGHQEB_W@Z 00b4 ??$convert_filetime_to_time_t@_J@@YA_JU_FILETIME@@_J@Z 00ec _errno 0128 __imp_GetLastError 012f __acrt_errno_map_os_error 0174 __imp_PeekNamedPipe 018f __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 48 8B F9 49 8B D9 49 8B C8 49 8B F0 44 8B F2 FF 15 ?? ?? ?? ?? 8B C8 41 BF 01 00 00 00 0F BA F1 0F 41 3B CF 0F 85 BD 00 00 00 66 44 89 7B 08 48 85 FF 74 22 83 65 B0 00 48 8D 55 B0 48 8B CF E8 ?? ?? ?? ?? 84 C0 0F 84 B2 00 00 00 8B 45 B0 FF C8 89 43 10 89 03 33 D2 48 8D 4D B8 44 8D 42 34 E8 ?? ?? ?? ?? 48 8D 55 B8 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 0F 84 88 00 00 00 8B 4D B8 48 8B D7 E8 ?? ?? ?? ?? 48 8B 4D CC 33 D2 66 89 43 06 E8 ?? ?? ?? ?? 48 8B 4D C4 48 8B D0 48 89 43 28 E8 ?? ?? ?? ?? 48 8B 53 28 48 8B 4D BC 48 89 43 20 E8 ?? ?? ?? ?? 48 89 43 30 48 83 63 18 00 81 7D D8 FF FF FF 7F 76 0D E8 ?? ?? ?? ?? C7 00 84 00 00 00 EB 2A 8B 55 D8 8B 4D DC 48 C1 E2 20 48 03 D1 48 89 53 18 EB 79 8D 41 FE 41 3B C7 76 22 85 C9 75 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 32 C0 EB 61 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB ED 83 F9 02 66 44 89 7B 08 B8 00 10 00 00 44 89 73 10 BA 00 20 00 00 44 89 33 66 0F 44 C2 66 89 43 06 74 2C 48 83 64 24 28 00 48 8D 45 B0 45 33 C9 48 89 44 24 20 45 33 C0 33 D2 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 08 48 63 45 B0 48 89 43 18 41 8A C7 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B8 00 00 00 48 81 C4 80 00 00 00 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_199_33_0 {
	meta:
		name = "??$common_stat_handle_file_opened@U_stat64i32@@@@YA_NQEB_WHQEAXAEAU_stat64i32@@@Z"
		size = 420
		refs = "0019 __security_cookie 0035 __imp_GetFileType 0064 ?get_drive_number_from_path@@YA_NQEB_WAEAH@Z 0085 memset 0092 __imp_GetFileInformationByHandle 00a5 ?convert_to_stat_mode@@YAGHQEB_W@Z 00b4 ??$convert_filetime_to_time_t@_J@@YA_JU_FILETIME@@_J@Z 00fb _errno 0124 __imp_GetLastError 012b __acrt_errno_map_os_error 0170 __imp_PeekNamedPipe 0189 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 48 8B F9 49 8B D9 49 8B C8 49 8B F0 44 8B F2 FF 15 ?? ?? ?? ?? 8B C8 41 BF 01 00 00 00 0F BA F1 0F 41 3B CF 0F 85 B9 00 00 00 66 44 89 7B 08 48 85 FF 74 22 83 65 B0 00 48 8D 55 B0 48 8B CF E8 ?? ?? ?? ?? 84 C0 0F 84 AE 00 00 00 8B 45 B0 FF C8 89 43 10 89 03 33 D2 48 8D 4D B8 44 8D 42 34 E8 ?? ?? ?? ?? 48 8D 55 B8 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 0F 84 84 00 00 00 8B 4D B8 48 8B D7 E8 ?? ?? ?? ?? 48 8B 4D CC 33 D2 66 89 43 06 E8 ?? ?? ?? ?? 48 8B 4D C4 48 8B D0 48 89 43 20 E8 ?? ?? ?? ?? 48 8B 53 20 48 8B 4D BC 48 89 43 18 E8 ?? ?? ?? ?? 48 89 43 28 83 63 14 00 83 7D D8 00 75 13 8B 4D DC 81 F9 FF FF FF 7F 77 08 89 4B 14 E9 84 00 00 00 E8 ?? ?? ?? ?? C7 00 84 00 00 00 EB 17 8D 41 FE 41 3B C7 76 22 85 C9 75 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 32 C0 EB 5F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB ED 83 F9 02 66 44 89 7B 08 B8 00 10 00 00 44 89 73 10 BA 00 20 00 00 44 89 33 66 0F 44 C2 66 89 43 06 74 2A 48 83 64 24 28 00 48 8D 45 B0 45 33 C9 48 89 44 24 20 45 33 C0 33 D2 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 06 8B 45 B0 89 43 14 41 8A C7 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B8 00 00 00 48 81 C4 80 00 00 00 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_199_34_0 {
	meta:
		name = "??$convert_filetime_to_time_t@J@@YAJU_FILETIME@@J@Z"
		size = 150
		refs = "000c __security_cookie 0035 __imp_FileTimeToSystemTime 0049 __imp_SystemTimeToTzSpecificLocalTime 007b __loctotime32_t 008c __security_check_cookie"
	strings:
		$1 = { 40 55 48 8B EC 48 83 EC 70 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 48 89 4D D0 85 C9 75 0C 48 C1 E9 20 85 C9 75 04 8B C2 EB 59 48 8D 55 E8 48 8D 4D D0 FF 15 ?? ?? ?? ?? 85 C0 74 44 4C 8D 45 D8 33 C9 48 8D 55 E8 FF 15 ?? ?? ?? ?? 85 C0 74 30 83 4C 24 30 FF 0F B7 45 E4 44 0F B7 55 E2 44 0F B7 4D E0 44 0F B7 45 DE 0F B7 55 DA 0F B7 4D D8 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? EB 03 83 C8 FF 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 70 5D C3 }
	condition:
		$1
}

rule file_199_35_0 {
	meta:
		name = "??$convert_filetime_to_time_t@_J@@YA_JU_FILETIME@@_J@Z"
		size = 152
		refs = "000c __security_cookie 0036 __imp_FileTimeToSystemTime 004a __imp_SystemTimeToTzSpecificLocalTime 007c __loctotime64_t 008e __security_check_cookie"
	strings:
		$1 = { 40 55 48 8B EC 48 83 EC 70 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 48 89 4D D0 85 C9 75 0D 48 C1 E9 20 85 C9 75 05 48 8B C2 EB 5A 48 8D 55 E8 48 8D 4D D0 FF 15 ?? ?? ?? ?? 85 C0 74 44 4C 8D 45 D8 33 C9 48 8D 55 E8 FF 15 ?? ?? ?? ?? 85 C0 74 30 83 4C 24 30 FF 0F B7 45 E4 44 0F B7 55 E2 44 0F B7 4D E0 44 0F B7 45 DE 0F B7 55 DA 0F B7 4D D8 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? EB 04 48 83 C8 FF 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 70 5D C3 }
	condition:
		$1
}

rule file_199_36_0 {
	meta:
		name = "??$loctotime@AEAGAEAGAEAGAEAGAEAGAEAGH@?$__crt_integer_traits@J@@SAJAEAG00000$$QEAH@Z"
		size = 61
		refs = "0039 __loctotime32_t"
	strings:
		$1 = { 40 53 48 8B 44 24 38 45 0F B7 09 45 0F B7 00 0F B7 12 0F B7 18 48 8B 44 24 30 0F B7 09 44 0F B7 18 48 8B 44 24 40 44 8B 10 44 89 54 24 40 89 5C 24 38 44 89 5C 24 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_37_0 {
	meta:
		name = "??$loctotime@AEAGAEAGAEAGAEAGAEAGAEAGH@?$__crt_integer_traits@_J@@SA_JAEAG00000$$QEAH@Z"
		size = 61
		refs = "0039 __loctotime64_t"
	strings:
		$1 = { 40 53 48 8B 44 24 38 45 0F B7 09 45 0F B7 00 0F B7 12 0F B7 18 48 8B 44 24 30 0F B7 09 44 0F B7 18 48 8B 44 24 40 44 8B 10 44 89 54 24 40 89 5C 24 38 44 89 5C 24 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_38_0 {
	meta:
		name = "??$loctotime@HHHHHHH@?$__crt_integer_traits@J@@SAJ$$QEAH000000@Z"
		size = 54
		refs = "0032 __loctotime32_t"
	strings:
		$1 = { 48 8B 44 24 38 45 8B 09 45 8B 00 8B 12 44 8B 10 48 8B 44 24 30 8B 09 44 89 54 24 38 44 8B 10 48 8B 44 24 28 44 89 54 24 30 44 8B 10 44 89 54 24 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_39_0 {
	meta:
		name = "??$loctotime@HHHHHHH@?$__crt_integer_traits@_J@@SA_J$$QEAH000000@Z"
		size = 54
		refs = "0032 __loctotime64_t"
	strings:
		$1 = { 48 8B 44 24 38 45 8B 09 45 8B 00 8B 12 44 8B 10 48 8B 44 24 30 8B 09 44 89 54 24 38 44 8B 10 48 8B 44 24 28 44 89 54 24 30 44 8B 10 44 89 54 24 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_71_0 {
	meta:
		name = "?call_wfullpath@@YAPEA_WQEA_WQEB_W_KQEAPEA_W@Z"
		size = 150
		refs = "0026 _errno 003e _wfullpath"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 4D 8B F1 49 8B D8 48 8B EA 48 8B F9 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 4C 8B C3 48 8B D5 48 8B CF 83 20 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0C E8 ?? ?? ?? ?? 89 30 48 8B C3 EB 25 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 17 E8 ?? ?? ?? ?? 45 33 C0 48 8B D5 33 C9 89 30 E8 ?? ?? ?? ?? 49 89 06 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_199_74_0 {
	meta:
		name = "?compute_size@@YA_NAEBU_BY_HANDLE_FILE_INFORMATION@@AEAJ@Z"
		size = 47
		refs = "001e _errno"
	strings:
		$1 = { 48 83 EC 28 83 22 00 83 79 20 00 75 10 8B 41 24 3D FF FF FF 7F 77 06 89 02 B0 01 EB 0D E8 ?? ?? ?? ?? C7 00 84 00 00 00 32 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_199_75_0 {
	meta:
		name = "?compute_size@@YA_NAEBU_BY_HANDLE_FILE_INFORMATION@@AEA_J@Z"
		size = 58
		refs = "0015 _errno"
	strings:
		$1 = { 48 83 EC 28 48 83 22 00 48 8B C1 81 79 20 FF FF FF 7F 76 0F E8 ?? ?? ?? ?? C7 00 84 00 00 00 32 C0 EB 12 8B 49 20 8B 40 24 48 C1 E1 20 48 03 C8 B0 01 48 89 0A 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_199_76_0 {
	meta:
		name = "?convert_to_stat_mode@@YAGHQEB_W@Z"
		size = 300
		refs = "00a4 wcsrchr 00b3 ??_C@_19DOGDICKI@?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 00bb _wcsicmp 00c6 ??_C@_19BDKLHPGC@?$AA?4?$AAc?$AAm?$AAd?$AA?$AA@ 00d9 ??_C@_19PINKOIBI@?$AA?4?$AAb?$AAa?$AAt?$AA?$AA@ 00ec ??_C@_19CDGLJBOD@?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 4C 8B C2 33 F6 0F B6 D1 41 B1 01 8B C2 C1 E8 04 41 84 C1 75 53 4D 85 C0 74 47 41 0F B7 08 8D 41 BF 66 83 F8 19 76 0A 66 83 E9 61 66 83 F9 19 77 08 66 41 83 78 02 3A 74 03 44 8A CE 45 84 C9 49 8D 40 04 49 8B C8 48 0F 45 C8 66 39 31 74 19 66 83 39 5C 74 06 66 83 39 2F 75 06 66 39 71 02 74 07 BB 00 80 00 00 EB 05 BB 40 40 00 00 66 C1 E2 07 B8 80 00 00 00 66 F7 D2 66 23 D0 B8 00 01 00 00 66 0B D0 66 0B DA 4D 85 C0 74 65 BA 2E 00 00 00 49 8B C8 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 50 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 39 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 26 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 13 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 04 66 83 CB 40 48 8B 74 24 38 0F B7 C3 66 C1 E8 03 66 83 E0 38 66 0B D8 0F B7 C3 66 C1 E8 06 66 83 E0 07 66 0B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_199_81_0 {
	meta:
		name = "?get_drive_number_from_path@@YA_NQEB_WAEAH@Z"
		size = 105
		refs = "003a __acrt_errno_map_os_error 005b _getdrive"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 33 D2 89 13 0F B7 01 66 83 E8 41 66 83 F8 19 76 0D 0F B7 01 66 83 E8 61 66 83 F8 19 77 3A 66 83 79 02 3A 75 2C 66 39 51 04 75 0E B9 02 00 00 00 E8 ?? ?? ?? ?? 32 C0 EB 21 0F B7 01 66 83 E8 41 66 83 F8 19 0F B7 01 77 03 83 C0 20 83 C0 A0 89 03 E8 ?? ?? ?? ?? 89 03 B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_83_0 {
	meta:
		name = "?has_executable_extension@@YA_NQEB_W@Z"
		size = 117
		refs = "0015 wcsrchr 0024 ??_C@_19DOGDICKI@?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 002c _wcsicmp 0037 ??_C@_19BDKLHPGC@?$AA?4?$AAc?$AAm?$AAd?$AA?$AA@ 004a ??_C@_19PINKOIBI@?$AA?4?$AAb?$AAa?$AAt?$AA?$AA@ 005d ??_C@_19CDGLJBOD@?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 85 C9 75 04 32 C0 EB 60 BA 2E 00 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 EA 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 39 48 8D 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 26 48 8D 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 13 48 8D 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 9E B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_84_0 {
	meta:
		name = "?is_root_or_empty@@YA_NQEB_W@Z"
		size = 86
	strings:
		$1 = { 45 33 C0 48 8B D1 48 85 C9 74 48 0F B7 09 8D 41 BF 66 83 F8 19 76 0A 66 83 E9 61 66 83 F9 19 77 09 66 83 7A 02 3A B0 01 74 03 41 8A C0 84 C0 48 8D 4A 04 48 0F 45 D1 66 44 39 02 75 03 B0 01 C3 66 83 3A 5C 74 06 66 83 3A 2F 75 07 66 44 39 42 02 74 EA 32 C0 C3 }
	condition:
		$1
}

rule file_199_85_0 {
	meta:
		name = "?is_root_unc_name@@YA_NQEB_W@Z"
		size = 162
	strings:
		$1 = { 48 83 C8 FF 33 D2 48 FF C0 66 39 14 41 75 F7 48 83 F8 05 0F 82 86 00 00 00 66 41 B9 5C 00 66 41 B8 2F 00 66 44 39 09 74 06 66 44 39 01 75 70 66 44 39 49 02 74 07 66 44 39 41 02 75 62 66 44 39 41 04 74 5B 66 44 39 49 04 74 54 48 8D 41 06 0F B7 08 66 85 C9 74 48 66 41 3B C9 74 0C 66 41 3B C8 74 06 48 83 C0 02 EB E6 66 39 10 74 31 48 83 C0 02 66 39 10 74 28 0F B7 08 66 85 C9 74 1D 66 41 3B C9 74 0C 66 41 3B C8 74 06 48 83 C0 02 EB E6 66 39 10 74 06 66 39 50 02 75 03 B0 01 C3 32 C0 C3 }
	condition:
		$1
}

rule file_199_86_0 {
	meta:
		name = "?is_slash@@YA_N_W@Z"
		size = 21
	strings:
		$1 = { 66 83 F9 5C 74 09 66 83 F9 2F 74 03 33 C0 C3 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_199_87_0 {
	meta:
		name = "?is_usable_drive_or_unc_root@@YA_NQEB_W@Z"
		size = 265
		refs = "0018 __security_cookie 002a ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 0032 wcspbrk 0046 _errno 0063 _wfullpath 00b9 ?is_root_unc_name@@YA_NQEB_W@Z 00c6 __imp_GetDriveTypeW 00da free 00ed __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 56 48 81 EC 40 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8D 15 ?? ?? ?? ?? 48 8B F1 E8 ?? ?? ?? ?? 45 33 F6 48 85 C0 0F 84 9F 00 00 00 49 8B DE E8 ?? ?? ?? ?? 8B 28 E8 ?? ?? ?? ?? 41 B8 04 01 00 00 48 8D 4C 24 20 48 8B D6 44 89 30 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 09 E8 ?? ?? ?? ?? 89 28 EB 24 E8 ?? ?? ?? ?? 83 38 22 75 51 E8 ?? ?? ?? ?? 45 33 C0 48 8B D6 33 C9 89 28 E8 ?? ?? ?? ?? 48 8B D8 48 8B F8 48 85 FF 74 32 48 83 C8 FF 48 FF C0 66 44 39 34 47 75 F6 48 83 F8 03 74 0C 48 8B CF E8 ?? ?? ?? ?? 84 C0 74 12 48 8B CE FF 15 ?? ?? ?? ?? BF 01 00 00 00 3B C7 77 03 41 8A FE 48 8B CB E8 ?? ?? ?? ?? 40 8A C7 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 40 02 00 00 49 8B 5B 28 49 8B 6B 30 49 8B E3 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_199_91_0 {
	meta:
		name = "_fstat32"
		size = 240
		refs = "001a __doserrno 0021 _errno 003b memset 0078 _nhandle 0084 __pioinfo 00c8 ??$?RV<lambda_96b0dce3ad2a93c5c9ed548730f377b6>@@AEAV<lambda_400f06e00cd32245fa85628833e911d2>@@V<lambda_da1c5379cfd7439e775ba9665cd8bf87>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_96b0dce3ad2a93c5c9ed548730f377b6>@@AEAV<lambda_400f06e00cd32245fa85628833e911d2>@@$$QEAV<lambda_da1c5379cfd7439e775ba9665cd8bf87>@@@Z 00e2 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 55 53 48 8B EC 48 83 EC 68 48 89 55 B8 48 8B DA 89 4D 20 48 85 D2 75 17 E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 B1 00 00 00 33 D2 48 8D 4D D0 44 8D 42 24 E8 ?? ?? ?? ?? 0F 10 45 D0 8B 45 F0 0F 10 4D E0 0F 11 03 0F 11 4B 10 89 43 20 48 63 55 20 83 FA FE 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 74 85 D2 78 58 3B 15 ?? ?? ?? ?? 7D 50 48 8B CA 4C 8D 05 ?? ?? ?? ?? 83 E1 3F 48 8B C2 48 C1 F8 06 48 C1 E1 06 49 8B 04 C0 F6 44 08 38 01 74 2D 48 8D 45 20 89 55 28 48 89 45 C0 4C 8D 4D 28 48 8D 45 B8 89 55 30 4C 8D 45 C0 48 89 45 C8 48 8D 55 30 48 8D 4D 18 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 68 5B 5D C3 }
	condition:
		$1
}

rule file_199_92_0 {
	meta:
		name = "_fstat32i64"
		size = 242
		refs = "001a __doserrno 0021 _errno 003b memset 007a _nhandle 0086 __pioinfo 00ca ??$?RV<lambda_a59c9183952f290e1f88b0789726fa45>@@AEAV<lambda_6fd52f3c2fb1c47a481b23175379f22a>@@V<lambda_4a930275767fc0415fefcffa3cf2c69f>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_a59c9183952f290e1f88b0789726fa45>@@AEAV<lambda_6fd52f3c2fb1c47a481b23175379f22a>@@$$QEAV<lambda_4a930275767fc0415fefcffa3cf2c69f>@@@Z 00e4 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 55 53 48 8B EC 48 83 EC 78 48 89 55 A8 48 8B DA 89 4D 20 48 85 D2 75 17 E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 B3 00 00 00 33 D2 48 8D 4D C0 44 8D 42 30 E8 ?? ?? ?? ?? 0F 10 45 C0 0F 10 4D D0 0F 11 03 0F 10 45 E0 0F 11 4B 10 0F 11 43 20 48 63 55 20 83 FA FE 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 74 85 D2 78 58 3B 15 ?? ?? ?? ?? 7D 50 48 8B CA 4C 8D 05 ?? ?? ?? ?? 83 E1 3F 48 8B C2 48 C1 F8 06 48 C1 E1 06 49 8B 04 C0 F6 44 08 38 01 74 2D 48 8D 45 20 89 55 28 48 89 45 B0 4C 8D 4D 28 48 8D 45 A8 89 55 30 4C 8D 45 B0 48 89 45 B8 48 8D 55 30 48 8D 4D 18 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 78 5B 5D C3 }
	condition:
		$1
}

rule file_199_94_0 {
	meta:
		name = "_fstat64i32"
		size = 242
		refs = "001a __doserrno 0021 _errno 003b memset 007a _nhandle 0086 __pioinfo 00ca ??$?RV<lambda_3a04bfe258a31910a526c90b4d849d20>@@AEAV<lambda_1b3ad63c02abf531fe15530b52bade31>@@V<lambda_1755787d260f86bf828f8bf7552b2658>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_3a04bfe258a31910a526c90b4d849d20>@@AEAV<lambda_1b3ad63c02abf531fe15530b52bade31>@@$$QEAV<lambda_1755787d260f86bf828f8bf7552b2658>@@@Z 00e4 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 55 53 48 8B EC 48 83 EC 78 48 89 55 A8 48 8B DA 89 4D 20 48 85 D2 75 17 E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 B3 00 00 00 33 D2 48 8D 4D C0 44 8D 42 30 E8 ?? ?? ?? ?? 0F 10 45 C0 0F 10 4D D0 0F 11 03 0F 10 45 E0 0F 11 4B 10 0F 11 43 20 48 63 55 20 83 FA FE 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 74 85 D2 78 58 3B 15 ?? ?? ?? ?? 7D 50 48 8B CA 4C 8D 05 ?? ?? ?? ?? 83 E1 3F 48 8B C2 48 C1 F8 06 48 C1 E1 06 49 8B 04 C0 F6 44 08 38 01 74 2D 48 8D 45 20 89 55 28 48 89 45 B0 4C 8D 4D 28 48 8D 45 A8 89 55 30 4C 8D 45 B0 48 89 45 B8 48 8D 55 30 48 8D 4D 18 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 78 5B 5D C3 }
	condition:
		$1
}

rule file_199_93_0 {
	meta:
		name = "_fstat64"
		size = 252
		refs = "001a __doserrno 0021 _errno 003b memset 0084 _nhandle 0090 __pioinfo 00d4 ??$?RV<lambda_d6a03b27cb314eb65d447ab85fffcbf2>@@AEAV<lambda_3e61fc1153d2eec3991e8733eecb5419>@@V<lambda_8d9723598c44aced2bc47669cc68e4e1>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_d6a03b27cb314eb65d447ab85fffcbf2>@@AEAV<lambda_3e61fc1153d2eec3991e8733eecb5419>@@$$QEAV<lambda_8d9723598c44aced2bc47669cc68e4e1>@@@Z 00ee _invalid_parameter_noinfo"
	strings:
		$1 = { 40 55 53 48 8B EC 48 83 EC 78 48 89 55 A8 48 8B DA 89 4D 20 48 85 D2 75 17 E8 ?? ?? ?? ?? 21 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 BD 00 00 00 33 D2 48 8D 4D C0 44 8D 42 38 E8 ?? ?? ?? ?? 0F 10 45 C0 0F 10 4D D0 0F 11 03 0F 10 45 E0 0F 11 4B 10 F2 0F 10 4D F0 0F 11 43 20 F2 0F 11 4B 30 48 63 55 20 83 FA FE 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 74 85 D2 78 58 3B 15 ?? ?? ?? ?? 7D 50 48 8B CA 4C 8D 05 ?? ?? ?? ?? 83 E1 3F 48 8B C2 48 C1 F8 06 48 C1 E1 06 49 8B 04 C0 F6 44 08 38 01 74 2D 48 8D 45 20 89 55 28 48 89 45 B0 4C 8D 4D 28 48 8D 45 A8 89 55 30 4C 8D 45 B0 48 89 45 B8 48 8D 55 30 48 8D 4D 18 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 78 5B 5D C3 }
	condition:
		$1
}

rule file_199_95_0 {
	meta:
		name = "_stat32"
		size = 86
		refs = "000f ??$common_stat@U_stat32@@@@YAHQEB_WQEAU_stat32@@@Z 0023 __acrt_copy_path_to_wide_string 0031 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 85 C9 75 09 E8 ?? ?? ?? ?? 8B D8 EB 37 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 85 C0 75 0A E8 ?? ?? ?? ?? 83 CB FF EB 14 48 8B D3 E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_96_0 {
	meta:
		name = "_stat32i64"
		size = 86
		refs = "000f ??$common_stat@U_stat32i64@@@@YAHQEB_WQEAU_stat32i64@@@Z 0023 __acrt_copy_path_to_wide_string 0031 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 85 C9 75 09 E8 ?? ?? ?? ?? 8B D8 EB 37 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 85 C0 75 0A E8 ?? ?? ?? ?? 83 CB FF EB 14 48 8B D3 E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_97_0 {
	meta:
		name = "_stat64"
		size = 86
		refs = "000f ??$common_stat@U_stat64@@@@YAHQEB_WQEAU_stat64@@@Z 0023 __acrt_copy_path_to_wide_string 0031 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 85 C9 75 09 E8 ?? ?? ?? ?? 8B D8 EB 37 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 85 C0 75 0A E8 ?? ?? ?? ?? 83 CB FF EB 14 48 8B D3 E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_98_0 {
	meta:
		name = "_stat64i32"
		size = 86
		refs = "000f ??$common_stat@U_stat64i32@@@@YAHQEB_WQEAU_stat64i32@@@Z 0023 __acrt_copy_path_to_wide_string 0031 _free_base"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 85 C9 75 09 E8 ?? ?? ?? ?? 8B D8 EB 37 48 83 64 24 30 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 85 C0 75 0A E8 ?? ?? ?? ?? 83 CB FF EB 14 48 8B D3 E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_200_5_0 {
	meta:
		name = "__acrt_locale_free_numeric"
		size = 108
		refs = "0013 __acrt_lconv_c 001a _free_base"
	strings:
		$1 = { 48 85 C9 74 66 53 48 83 EC 20 48 8B D9 48 8B 09 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 08 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 10 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 58 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 4B 60 48 3B 0D ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_200_6_0 {
	meta:
		name = "__acrt_locale_initialize_numeric"
		size = 734
		refs = "0041 __acrt_lconv_c 005a _calloc_base 00d9 _malloc_base 00e3 _free_base 0145 __acrt_GetLocaleInfoA 01d5 __acrt_locale_free_numeric"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 41 54 41 55 41 56 41 57 48 83 EC 40 33 DB 48 89 48 C8 48 8B F1 48 89 58 D0 48 39 99 48 01 00 00 75 1B 48 39 99 40 01 00 00 75 12 44 8B FB 4C 8D 35 ?? ?? ?? ?? 44 8B E3 E9 1D 02 00 00 BD 01 00 00 00 BA 98 00 00 00 8B CD E8 ?? ?? ?? ?? 4C 8B F0 48 85 C0 75 07 8B C5 E9 53 02 00 00 48 8B 86 F8 00 00 00 BA 80 00 00 00 0F 10 00 8D 7A 84 8B CF 41 0F 11 06 0F 10 48 10 41 0F 11 4E 10 0F 10 40 20 41 0F 11 46 20 0F 10 48 30 41 0F 11 4E 30 0F 10 40 40 41 0F 11 46 40 0F 10 48 50 41 0F 11 4E 50 0F 10 40 60 41 0F 11 46 60 0F 10 40 70 41 0F 11 44 16 F0 0F 10 0C 10 41 0F 11 0C 16 48 8B 44 10 10 49 89 44 16 10 E8 ?? ?? ?? ?? 33 C9 4C 8B E0 E8 ?? ?? ?? ?? 4D 85 E4 75 0D 49 8B CE E8 ?? ?? ?? ?? E9 6D FF FF FF 41 89 1C 24 48 39 9E 48 01 00 00 0F 84 1B 01 00 00 48 8B CF E8 ?? ?? ?? ?? 33 C9 4C 8B F8 E8 ?? ?? ?? ?? 4D 85 FF 0F 84 B7 00 00 00 41 89 1F 48 8D 4C 24 30 48 8B BE 48 01 00 00 41 B9 0E 00 00 00 4C 8B C7 4C 89 74 24 20 8B D5 E8 ?? ?? ?? ?? 49 8D 4E 08 41 B9 0F 00 00 00 48 89 4C 24 20 4C 8B C7 48 8D 4C 24 30 8B D5 8B D8 E8 ?? ?? ?? ?? 4D 8D 6E 10 41 B9 10 00 00 00 4C 8B C7 4C 89 6C 24 20 8B D5 48 8D 4C 24 30 0B D8 E8 ?? ?? ?? ?? 41 B9 0E 00 00 00 48 8D 4C 24 30 0B D8 4C 8B C7 49 8D 46 58 48 89 44 24 20 41 8D 51 F4 E8 ?? ?? ?? ?? 41 B9 0F 00 00 00 48 8D 4C 24 30 0B D8 4C 8B C7 49 8D 46 60 48 89 44 24 20 41 8D 51 F3 E8 ?? ?? ?? ?? 0B C3 74 1B 49 8B CE E8 ?? ?? ?? ?? 83 CD FF 49 8B CE E8 ?? ?? ?? ?? 49 8B CC E9 03 FF FF FF 49 8B 55 00 33 DB EB 11 8A 0A 8D 41 D0 3C 09 77 0E 80 E9 30 88 0A 48 03 D5 38 1A 75 EB EB 53 80 F9 3B 75 F2 4C 8B C2 49 8D 48 01 8A 01 41 88 00 4C 8B C1 84 C0 75 F0 EB E0 48 8B 05 ?? ?? ?? ?? 4C 8B FB 49 89 06 48 8B 05 ?? ?? ?? ?? 49 89 46 08 48 8B 05 ?? ?? ?? ?? 49 89 46 10 48 8B 05 ?? ?? ?? ?? 49 89 46 58 48 8B 05 ?? ?? ?? ?? 49 89 46 60 41 89 2C 24 4D 85 FF 74 03 41 89 2F 48 8B 86 E8 00 00 00 48 85 C0 74 03 F0 FF 08 48 8B 8E E0 00 00 00 48 85 C9 74 24 83 C8 FF F0 0F C1 01 83 F8 01 75 18 48 8B 8E E0 00 00 00 E8 ?? ?? ?? ?? 48 8B 8E F8 00 00 00 E8 ?? ?? ?? ?? 4C 89 BE E8 00 00 00 33 C0 4C 89 A6 E0 00 00 00 4C 89 B6 F8 00 00 00 4C 8D 5C 24 40 49 8B 5B 30 49 8B 6B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_201_1_0 {
	meta:
		name = "remainderf"
		size = 646
		refs = "00cc __real@3fe0000000000000 00e5 __xmm@80000000000000008000000000000000 0233 _handle_nanf 024c ??_C@_0L@JMNNGNHM@remainderf?$AA@ 027d _handle_errorf"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 58 48 B8 FF FF FF FF FF FF FF 7F 0F 28 E1 0F 28 C8 0F 57 D2 F3 0F 5A D1 0F 57 DB F2 0F 11 54 24 70 4C 8B 44 24 70 F3 0F 5A DC 4D 8B C8 49 8B C8 4C 23 C8 48 C1 E9 34 F2 0F 11 5C 24 70 4C 8B 5C 24 70 4D 8B D3 49 8B D3 4C 23 D0 48 C1 EA 34 B8 FF 07 00 00 23 C8 23 D0 83 F9 01 0F 8C 84 01 00 00 81 F9 FE 07 00 00 0F 8F 80 01 00 00 8D 42 FF 3D FD 07 00 00 0F 87 6A 01 00 00 4D 3B CA 75 21 48 B8 00 00 00 00 00 00 00 80 4C 23 C0 4C 89 44 24 70 F2 0F 10 44 24 70 66 0F 5A C0 E9 D7 01 00 00 4C 89 4C 24 70 F2 0F 10 54 24 70 4C 89 54 24 70 F2 0F 10 5C 24 70 4D 3B CA 73 30 0F 28 C3 F2 0F 59 05 ?? ?? ?? ?? 66 0F 2F D0 76 04 F2 0F 5C D3 0F 57 C0 0F 2F C1 76 07 0F 57 15 ?? ?? ?? ?? 0F 57 C0 F2 0F 5A C2 E9 8C 01 00 00 0F AE 5C 24 68 44 8B 44 24 68 3B CA 7E 76 2B CA B8 AB AA AA 2A F7 E9 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 04 52 8D 04 C5 FF 03 00 00 48 63 C8 48 B8 00 00 00 00 00 00 70 3E 48 C1 E1 34 48 89 4C 24 70 F2 0F 10 44 24 70 F2 0F 59 C3 48 89 44 24 70 F2 0F 10 64 24 70 0F 28 D8 85 D2 7E 27 8B CA 0F 28 C2 F2 0F 5E C3 F2 0F 2C C0 66 0F 6E C8 F3 0F E6 C9 F2 0F 59 CB F2 0F 59 DC F2 0F 5C D1 48 83 E9 01 75 DB 0F 28 C2 F2 0F 5E C3 F2 0F 2C C0 0F 28 C3 F2 0F 59 05 ?? ?? ?? ?? 66 0F 6E C8 83 E0 01 F3 0F E6 C9 F2 0F 59 CB F2 0F 5C D1 66 0F 2F D0 F2 0F 11 54 24 70 77 0C 66 0F 2E D0 7A 10 75 0E 85 C0 74 0A F2 0F 5C D3 F2 0F 11 54 24 70 44 89 44 24 68 0F AE 54 24 68 0F 57 C0 0F 2F 44 24 60 F2 0F 10 44 24 70 76 07 0F 57 05 ?? ?? ?? ?? F2 0F 5A C0 E9 93 00 00 00 81 F9 FE 07 00 00 7E 17 48 B8 FF FF FF FF FF FF 0F 00 4C 85 C0 74 3C F3 0F 11 4C 24 60 EB 1D 81 FA FE 07 00 00 7E 22 48 B8 FF FF FF FF FF FF 0F 00 4C 85 D8 74 5D F3 0F 11 64 24 60 8B 4C 24 60 48 83 C4 58 E9 ?? ?? ?? ?? 83 F9 01 7D 05 83 FA 01 7D 40 C7 44 24 40 02 00 00 00 48 8D 0D ?? ?? ?? ?? F3 0F 11 64 24 38 41 B9 01 00 00 00 F3 0F 11 4C 24 30 41 B8 00 00 C0 FF C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 41 8D 51 05 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "atan2f"
		size = 1085
		refs = "00ca _handle_nanf 00fb __real@c0490fdb 0105 __real@40490fdb 010f _set_statfp 0133 __real@bfc90fdb 016f __real@3fc90fdb 019a __real@80000000 02bc __real@c016cbe4 02c9 __real@4016cbe4 02db __real@bf490fdb 02e8 __real@3f490fdb 02f5 __xmm@80000000000000008000000000000000 032a __real@3fb0000000000000 0334 __real@4070000000000000 034a __real@3fe0000000000000 035f ?atan_jby256@?1??atan2f@@9@9 0395 __real@3fd5555555550877 039f __real@3f1a36e2eb1c432d 03ad __real@3fc99999999643a3 03bf __real@3fc2492482bd6be1 03cb __real@3fd5555555555538 03eb __real@3ff921fb54442d18 03ff __real@400921fb54442d18"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 20 57 41 54 41 55 41 56 41 57 48 83 EC 40 33 DB 0F 29 70 C8 0F 29 78 B8 49 BD 00 00 00 00 00 00 F0 7F 49 BB FF FF FF FF FF FF FF 7F 49 BA 00 00 00 00 00 00 00 80 0F 57 FF 41 B9 FF 07 00 00 F3 0F 5A F9 44 8B C3 44 8B FB 44 8B E3 0F 57 F6 F2 0F 11 BC 24 80 00 00 00 48 8B 84 24 80 00 00 00 48 8B E8 48 8B C8 49 23 EA F3 0F 5A F0 F2 0F 11 B4 24 80 00 00 00 4C 8B B4 24 80 00 00 00 49 8B D6 49 8B FE 49 23 D3 49 23 FA 49 23 CB 41 0F 94 C0 49 3B CD 41 0F 94 C7 49 3B D5 41 0F 94 C4 49 C1 EE 34 48 C1 E8 34 45 23 F1 41 23 C1 44 2B F0 49 3B CD 76 14 F3 0F 11 4C 24 70 8B 4C 24 70 E8 ?? ?? ?? ?? E9 46 03 00 00 49 3B D5 76 08 F3 0F 11 44 24 70 EB E5 48 85 D2 75 36 48 85 ED 0F 85 A8 01 00 00 66 0F 5A C6 E9 22 03 00 00 F3 0F 10 35 ?? ?? ?? ?? EB 08 F3 0F 10 35 ?? ?? ?? ?? B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 E9 FE 02 00 00 45 85 C0 74 36 B9 20 00 00 00 E8 ?? ?? ?? ?? 48 85 FF 74 0D F3 0F 10 05 ?? ?? ?? ?? E9 DD 02 00 00 41 B9 FF 07 00 00 49 BA 00 00 00 00 00 00 00 80 49 BB FF FF FF FF FF FF FF 7F 41 83 FE 1A 7E 19 48 85 FF 74 0A F3 0F 10 35 ?? ?? ?? ?? EB 9E F3 0F 10 35 ?? ?? ?? ?? EB 94 41 83 FE F3 0F 8D 0C 01 00 00 48 85 ED 0F 85 03 01 00 00 41 81 FE 6A FF FF FF 7D 1C 48 85 FF 74 0A F3 0F 10 35 ?? ?? ?? ?? EB 03 0F 57 F6 B9 30 00 00 00 E9 61 FF FF FF 41 83 FE 82 0F 8D CB 00 00 00 48 B8 00 00 00 00 00 00 30 46 48 89 84 24 80 00 00 00 F2 0F 10 84 24 80 00 00 00 F2 0F 59 C6 F2 0F 5E C7 F2 0F 11 84 24 80 00 00 00 48 8B 84 24 80 00 00 00 4C 8B C0 49 23 C3 48 8B C8 4D 23 C2 48 C1 E9 34 41 23 C9 83 E9 64 85 C9 7E 19 48 63 D9 48 B9 FF FF FF FF FF FF 0F 80 48 23 C1 48 C1 E3 34 48 0B D8 EB 38 48 BA FF FF FF FF FF FF 1F 80 48 23 C2 48 BA 00 00 00 00 00 00 10 00 48 0B C2 BA 01 00 00 00 2B D1 83 FA 36 7F 12 8D 4A FF 48 D3 E8 48 8B D8 83 E0 01 48 D1 EB 48 03 D8 49 0B D8 48 89 9C 24 80 00 00 00 F2 0F 10 B4 24 80 00 00 00 49 85 DD 0F 85 7B FE FF FF B9 30 00 00 00 E8 ?? ?? ?? ?? E9 6C FE FF FF F2 0F 5E F7 E9 63 FE FF FF 41 83 FE E6 7D 13 48 85 ED 74 0E 48 85 FF 0F 85 58 FE FF FF E9 5D FE FF FF 45 85 E4 74 48 45 85 FF 74 43 48 85 ED 74 1F 48 85 FF 74 0D F3 0F 10 35 ?? ?? ?? ?? E9 44 FE FF FF F3 0F 10 35 ?? ?? ?? ?? E9 37 FE FF FF 48 85 FF 74 0D F3 0F 10 35 ?? ?? ?? ?? E9 25 FE FF FF F3 0F 10 35 ?? ?? ?? ?? E9 18 FE FF FF F2 0F 10 2D ?? ?? ?? ?? 48 85 ED 74 03 0F 57 FD 48 85 FF 74 03 0F 57 F5 66 0F 2F F7 8B D3 0F 97 C2 85 D2 74 09 0F 28 C7 0F 28 FE 0F 28 F0 0F 28 E6 F2 0F 5E E7 66 0F 2F 25 ?? ?? ?? ?? 76 6B F2 0F 10 15 ?? ?? ?? ?? 0F 57 C9 F2 0F 59 E2 0F 28 DE F2 0F 59 DA F2 0F 58 25 ?? ?? ?? ?? F2 0F 2C CC 8B C1 83 C1 F0 F2 48 0F 2A C8 48 8D 05 ?? ?? ?? ?? 0F 28 C1 F2 0F 59 CE F2 0F 59 C7 F2 0F 59 FA F2 0F 5C D8 F2 0F 58 CF F2 0F 5E D9 0F 28 C3 0F 28 E3 F2 0F 58 24 C8 F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 05 ?? ?? ?? ?? EB 44 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C4 77 3A F2 0F 10 0D ?? ?? ?? ?? 0F 28 D4 F2 0F 59 D4 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C C8 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D4 F2 0F 5C C1 F2 0F 59 C2 F2 0F 5C E0 85 D2 74 0F F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C C4 0F 28 E0 48 85 ED 74 0F F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C C4 0F 28 E0 48 85 FF 74 03 0F 57 E5 0F 57 C0 F2 0F 5A C4 0F 28 74 24 30 4C 8D 5C 24 40 49 8B 5B 38 49 8B 6B 48 0F 28 7C 24 20 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "scaleDownDouble"
		size = 142
	strings:
		$1 = { 4C 8B D1 4C 8B C9 48 B8 00 00 00 00 00 00 00 80 4C 23 D0 48 B8 FF FF FF FF FF FF FF 7F 4C 23 C8 33 C0 49 8B C9 48 C1 E9 34 81 E1 FF 07 00 00 2B CA 85 C9 7E 19 48 63 C1 48 B9 FF FF FF FF FF FF 0F 80 4C 23 C9 48 C1 E0 34 49 0B C1 EB 39 48 BA FF FF FF FF FF FF 1F 80 4C 23 CA 48 BA 00 00 00 00 00 00 10 00 4C 0B CA BA 01 00 00 00 2B D1 83 FA 36 7F 13 8D 4A FF 49 D3 E9 49 8B C1 41 83 E1 01 48 D1 E8 49 03 C1 49 0B C2 49 89 00 C3 }
	condition:
		$1
}

rule file_204_4_0 {
	meta:
		name = "_wcscoll_l"
		size = 188
		refs = "0019 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0033 _invalid_parameter_noinfo 0081 __acrt_CompareStringW"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 50 48 8B FA 48 8B D9 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 85 DB 74 05 48 85 FF 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 5B 48 8B 44 24 38 48 8B 88 30 01 00 00 48 85 C9 75 20 48 2B FB 0F B7 03 66 3B 04 3B 75 0D 48 83 C3 02 66 85 C0 75 EE 33 C0 EB 3B 1B C0 83 C8 01 EB 34 41 83 C9 FF 4C 8B C3 44 89 4C 24 28 BA 00 10 00 00 48 89 7C 24 20 E8 ?? ?? ?? ?? 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 C0 FE 80 7C 24 48 00 74 0C 48 8B 4C 24 30 83 A1 A8 03 00 00 FD 48 8B 5C 24 60 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_204_5_0 {
	meta:
		name = "wcscoll"
		size = 101
		refs = "0008 __acrt_locale_changed_data 0014 _errno 001f _invalid_parameter_noinfo 0061 _wcscoll_l"
	strings:
		$1 = { 48 83 EC 28 33 C0 39 05 ?? ?? ?? ?? 75 4B 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 48 83 C4 28 C3 48 85 D2 74 E1 48 2B D1 44 0F B7 01 66 44 3B 04 11 75 0F 48 83 C1 02 66 45 85 C0 75 EB 48 83 C4 28 C3 1B C0 83 C8 01 48 83 C4 28 C3 45 33 C0 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "_get_printf_count_output"
		size = 24
		refs = "0003 __security_cookie 0010 ?enable_percent_n@@3_KA"
	strings:
		$1 = { 48 8B 0D ?? ?? ?? ?? 33 C0 48 83 C9 01 48 39 0D ?? ?? ?? ?? 0F 94 C0 C3 }
	condition:
		$1
}

rule file_205_1_0 {
	meta:
		name = "_set_printf_count_output"
		size = 39
		refs = "0003 __security_cookie 0010 ?enable_percent_n@@3_KA"
	strings:
		$1 = { 48 8B 15 ?? ?? ?? ?? 33 C0 48 83 CA 01 48 39 15 ?? ?? ?? ?? 0F 94 C0 F7 D9 48 1B C9 48 23 CA 48 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_207_3_0 {
	meta:
		name = "?fast_check@@YAHHH@Z"
		size = 18
		refs = "0003 __acrt_initial_locale_data"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 63 C1 42 0F B7 04 40 23 C2 C3 }
	condition:
		$1
}

rule file_207_7_0 {
	meta:
		name = "__iscsym"
		size = 40
		refs = "000c isalnum"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 0F B6 C9 E8 ?? ?? ?? ?? 33 D2 85 C0 75 05 80 FB 5F 75 05 BA 01 00 00 00 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_207_8_0 {
	meta:
		name = "__iscsymf"
		size = 37
		refs = "0009 isalpha"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 33 D2 85 C0 75 05 83 FB 5F 75 05 BA 01 00 00 00 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_207_11_0 {
	meta:
		name = "_isalnum_l"
		size = 91
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 07 01 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0D 48 8B 00 0F B7 0C 58 81 E1 07 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_12_0 {
	meta:
		name = "_isalpha_l"
		size = 91
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 03 01 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0D 48 8B 00 0F B7 0C 58 81 E1 03 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_13_0 {
	meta:
		name = "_isblank_l"
		size = 102
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0035 _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 83 FB 09 75 05 8D 4B 37 EB 2E 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 40 00 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0E 48 8B 00 B9 40 00 00 00 0F B7 14 58 23 CA 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_15_0 {
	meta:
		name = "_iscntrl_l"
		size = 88
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 20 00 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0A 48 8B 00 0F B7 0C 58 83 E1 20 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_16_0 {
	meta:
		name = "_iscsym_l"
		size = 106
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 07 01 00 00 8B CB E8 ?? ?? ?? ?? 8B D0 EB 0D 48 8B 00 0F B7 14 58 81 E2 07 01 00 00 33 C9 38 4C 24 38 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 85 D2 75 05 83 FB 5F 75 05 B9 01 00 00 00 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_17_0 {
	meta:
		name = "_iscsymf_l"
		size = 106
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 03 01 00 00 8B CB E8 ?? ?? ?? ?? 8B D0 EB 0D 48 8B 00 0F B7 14 58 81 E2 03 01 00 00 33 C9 38 4C 24 38 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 85 D2 75 05 83 FB 5F 75 05 B9 01 00 00 00 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_18_0 {
	meta:
		name = "_isdigit_l"
		size = 88
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 04 00 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0A 48 8B 00 0F B7 0C 58 83 E1 04 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_19_0 {
	meta:
		name = "_isgraph_l"
		size = 91
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 17 01 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0D 48 8B 00 0F B7 0C 58 81 E1 17 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_20_0 {
	meta:
		name = "_islower_l"
		size = 88
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 02 00 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0A 48 8B 00 0F B7 0C 58 83 E1 02 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_21_0 {
	meta:
		name = "_isprint_l"
		size = 91
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 57 01 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0D 48 8B 00 0F B7 0C 58 81 E1 57 01 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_22_0 {
	meta:
		name = "_ispunct_l"
		size = 88
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 10 00 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0A 48 8B 00 0F B7 0C 58 83 E1 10 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_23_0 {
	meta:
		name = "_isspace_l"
		size = 88
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 08 00 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0A 48 8B 00 0F B7 0C 58 83 E1 08 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_24_0 {
	meta:
		name = "_isupper_l"
		size = 88
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 01 00 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0A 48 8B 00 0F B7 0C 58 83 E1 01 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_25_0 {
	meta:
		name = "_isxdigit_l"
		size = 91
		refs = "000f ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002b _isctype_l"
	strings:
		$1 = { 40 53 48 83 EC 40 48 63 D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 80 00 00 00 8B CB E8 ?? ?? ?? ?? 8B C8 EB 0D 48 8B 00 0F B7 0C 58 81 E1 80 00 00 00 80 7C 24 38 00 74 0C 48 8B 44 24 20 83 A0 A8 03 00 00 FD 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_26_0 {
	meta:
		name = "isalnum"
		size = 121
		refs = "0008 __acrt_locale_changed_data 001a ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0036 _isctype_l 0063 __acrt_initial_locale_data"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 74 4E 33 D2 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 07 01 00 00 8B CB E8 ?? ?? ?? ?? 8B D0 EB 0D 48 8B 00 0F B7 14 58 81 E2 07 01 00 00 80 7C 24 38 00 74 1F 48 8B 44 24 20 83 A0 A8 03 00 00 FD EB 11 48 8B 05 ?? ?? ?? ?? 0F B7 14 58 81 E2 07 01 00 00 8B C2 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_27_0 {
	meta:
		name = "isalpha"
		size = 121
		refs = "0008 __acrt_locale_changed_data 001a ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0036 _isctype_l 0063 __acrt_initial_locale_data"
	strings:
		$1 = { 40 53 48 83 EC 40 83 3D ?? ?? ?? ?? 00 48 63 D9 74 4E 33 D2 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 01 7E 15 4C 8D 44 24 28 BA 03 01 00 00 8B CB E8 ?? ?? ?? ?? 8B D0 EB 0D 48 8B 00 0F B7 14 58 81 E2 03 01 00 00 80 7C 24 38 00 74 1F 48 8B 44 24 20 83 A0 A8 03 00 00 FD EB 11 48 8B 05 ?? ?? ?? ?? 0F B7 14 58 81 E2 03 01 00 00 8B C2 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_207_28_0 {
	meta:
		name = "isblank"
		size = 138
		refs = "0008 __acrt_locale_changed_data 001a ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_point