private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_9_0_0 {
	meta:
		name = "??0bad_alloc@std@@AAA@QBD@Z"
		size = 28
		refs = "0018 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 02 4B C0 E9 00 31 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_0_3 {
	meta:
		name = "??0__non_rtti_object@std@@AAA@QBDH@Z"
		size = 28
		refs = "0018 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 02 4B C0 E9 00 31 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_2_3 {
	meta:
		name = "??0bad_cast@std@@AAA@QBDH@Z"
		size = 28
		refs = "0018 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 02 4B C0 E9 00 31 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_4_3 {
	meta:
		name = "??0bad_typeid@std@@AAA@QBDH@Z"
		size = 28
		refs = "0018 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 02 4B C0 E9 00 31 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_21_3 {
	meta:
		name = "?__construct_from_string_literal@__non_rtti_object@std@@SA?AV12@QBD@Z"
		size = 28
		refs = "0018 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 02 4B C0 E9 00 31 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_22_3 {
	meta:
		name = "?__construct_from_string_literal@bad_cast@std@@SA?AV12@QBD@Z"
		size = 28
		refs = "0018 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 02 4B C0 E9 00 31 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_23_3 {
	meta:
		name = "?__construct_from_string_literal@bad_typeid@std@@SA?AV12@QBD@Z"
		size = 28
		refs = "0018 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 02 4B C0 E9 00 31 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "??0bad_alloc@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7bad_alloc@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_1_3 {
	meta:
		name = "??0__non_rtti_object@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7__non_rtti_object@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_3_6 {
	meta:
		name = "??0bad_array_new_length@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7bad_array_new_length@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_87_1 {
	meta:
		name = "??0bad_cast@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7bad_cast@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_55_1 {
	meta:
		name = "??0bad_exception@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7bad_exception@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_2_2 {
	meta:
		name = "??0bad_function_call@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7bad_function_call@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_5_3 {
	meta:
		name = "??0bad_typeid@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7bad_typeid@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_8_2 {
	meta:
		name = "??0invalid_argument@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7invalid_argument@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_10_2 {
	meta:
		name = "??0length_error@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7length_error@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_12_2 {
	meta:
		name = "??0logic_error@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7logic_error@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_14_1 {
	meta:
		name = "??0out_of_range@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7out_of_range@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_16_2 {
	meta:
		name = "??0overflow_error@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7overflow_error@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_57_1 {
	meta:
		name = "??0runtime_error@std@@QAA@ABV01@@Z"
		size = 48
		refs = "0018 __std_exception_copy 0028 ??_7runtime_error@std@@6B@ 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_2_0 {
	meta:
		name = "??0bad_alloc@std@@QAA@XZ"
		size = 32
		refs = "0018 ??_7bad_alloc@std@@6B@ 001c ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 03 4B 43 60 01 4B 03 60 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_4_6 {
	meta:
		name = "??0bad_array_new_length@std@@QAA@XZ"
		size = 32
		refs = "0018 ??_7bad_array_new_length@std@@6B@ 001c ??_C@_0BF@KINCDENJ@bad?5array?5new?5length?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 03 4B 43 60 01 4B 03 60 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_68_2 {
	meta:
		name = "??0bad_cast@std@@QAA@XZ"
		size = 32
		refs = "0018 ??_7bad_cast@std@@6B@ 001c ??_C@_08EPJLHIJG@bad?5cast?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 03 4B 43 60 01 4B 03 60 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_56_2 {
	meta:
		name = "??0bad_exception@std@@QAA@XZ"
		size = 32
		refs = "0018 ??_7bad_exception@std@@6B@ 001c ??_C@_0O@DPKOEFFH@bad?5exception?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 01 33 03 4B 43 60 01 4B 03 60 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_5_0 {
	meta:
		name = "??0exception@std@@QAA@ABV01@@Z"
		size = 40
		refs = "0018 __std_exception_copy 0024 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 06 4B 04 46 08 1D 23 60 00 23 C4 E9 01 33 21 1D ?? ?? ?? ?? 20 46 BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_6_0 {
	meta:
		name = "??0exception@std@@QAA@QBDH@Z"
		size = 28
		refs = "0018 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 03 60 00 23 C0 E9 01 33 41 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_7_0 {
	meta:
		name = "??1bad_alloc@std@@UAA@XZ"
		size = 24
		refs = "0010 __std_exception_destroy 0014 ??_7exception@std@@6B@"
		altNames = "??1_System_error@std@@UAA@XZ ??1__non_rtti_object@std@@UAA@XZ ??1bad_array_new_length@std@@UAA@XZ ??1bad_cast@std@@UAA@XZ ??1bad_exception@std@@UAA@XZ ??1bad_function_call@std@@UAA@XZ ??1bad_typeid@std@@UAA@XZ ??1exception@std@@UAA@XZ ??1failure@ios_base@std@@UAA@XZ ??1future_error@std@@UAA@XZ ??1invalid_argument@std@@UAA@XZ ??1length_error@std@@UAA@XZ ??1logic_error@std@@UAA@XZ ??1out_of_range@std@@UAA@XZ ??1overflow_error@std@@UAA@XZ ??1regex_error@std@@UAA@XZ ??1runtime_error@std@@UAA@XZ ??1system_error@std@@UAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 40 F8 04 3B BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_10_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAAPAXI@Z"
		size = 48
		refs = "0012 __std_exception_destroy 0020 ??3@YAXPAXI@Z 002c ??_7exception@std@@6B@"
		altNames = "??_G__non_rtti_object@std@@UAAPAXI@Z ??_Gbad_array_new_length@std@@UAAPAXI@Z ??_Gbad_cast@std@@UAAPAXI@Z ??_Gbad_exception@std@@UAAPAXI@Z ??_Gbad_function_call@std@@UAAPAXI@Z ??_Gbad_typeid@std@@UAAPAXI@Z ??_Gexception@std@@UAAPAXI@Z ??_Ginvalid_argument@std@@UAAPAXI@Z ??_Glength_error@std@@UAAPAXI@Z ??_Glogic_error@std@@UAAPAXI@Z ??_Gout_of_range@std@@UAAPAXI@Z ??_Goverflow_error@std@@UAAPAXI@Z ??_Gruntime_error@std@@UAAPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 08 4B 05 46 28 1D 2B 60 0C 46 ?? ?? ?? ?? 14 F0 01 0F 03 D0 0C 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_13_0 {
	meta:
		name = "?__scrt_throw_std_bad_alloc@@YAXXZ"
		size = 28
		refs = "000a ??0bad_alloc@std@@QAA@XZ 0012 _CxxThrowException 0018 _TI2?AVbad_alloc@std@@"
		altNames = "?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_44_1 {
	meta:
		name = "?_Xbad_function_call@std@@YAXXZ"
		size = 28
		refs = "000a ??0bad_function_call@std@@QAA@XZ 0012 _CxxThrowException 0018 _TI2?AVbad_function_call@std@@"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_14_0 {
	meta:
		name = "?__scrt_throw_std_bad_array_new_length@@YAXXZ"
		size = 28
		refs = "000a ??0bad_array_new_length@std@@QAA@XZ 0012 _CxxThrowException 0018 _TI3?AVbad_array_new_length@std@@"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_15_0 {
	meta:
		name = "?what@exception@std@@UBAPBDXZ"
		size = 20
		refs = "0010 ??_C@_0BC@EOODALEL@Unknown?5exception?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 68 00 B9 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_0_3 {
	meta:
		name = "?get_unexpected_or_default@@YAP6AXXZQBU__vcrt_ptd@@@Z"
		size = 20
		refs = "0010 terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 68 00 B9 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "?dllmain_crt_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
		size = 70
		refs = "001c __scrt_dllmain_crt_thread_detach 0024 __scrt_dllmain_crt_thread_attach 002e ?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z 003e ?dllmain_crt_process_detach@@YAH_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 A1 B1 01 29 0D D0 02 29 07 D0 03 29 01 D0 01 20 14 E0 BD E8 00 48 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? 11 46 BD E8 00 48 ?? ?? ?? ?? 0A B1 01 20 00 E0 00 20 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z"
		size = 212
		refs = "000e __scrt_initialize_crt 0018 __scrt_acquire_startup_lock 002a __scrt_fastfail 0032 __scrt_dllmain_before_initialize_c 0038 _RTC_Initialize 003e atexit 0042 ?__scrt_initialize_type_info@@YAXXZ 004c __scrt_initialize_default_local_stdio_options 0054 _initterm_e 005a __scrt_dllmain_after_initialize_c 0064 _initterm 0072 __scrt_release_startup_lock 007c __scrt_get_dyn_tls_init_callback 0086 __scrt_is_nonwritable_in_current_image 0090 _guard_check_icall 00b4 ?__proc_attached@@3HA 00b8 __xc_a 00bc __xc_z 00c0 __xi_a 00c4 __xi_z 00c8 ?__scrt_uninitialize_type_info@@YAXXZ 00cc _RTC_Terminate 00d0 __scrt_current_native_startup_state"
	strings:
		$1 = { 03 B4 2D E9 9C 48 0D F1 10 0B 6F 46 00 20 ?? ?? ?? ?? 08 B9 00 23 46 E0 ?? ?? ?? ?? 38 70 01 23 7B 70 2B 4C 23 68 13 B1 07 20 ?? ?? ?? ?? 01 23 23 60 ?? ?? ?? ?? D8 B1 ?? ?? ?? ?? 23 48 ?? ?? ?? ?? ?? ?? ?? ?? 20 48 ?? ?? ?? ?? ?? ?? ?? ?? 1C 49 1B 48 ?? ?? ?? ?? 50 B9 ?? ?? ?? ?? 38 B1 16 49 15 48 ?? ?? ?? ?? 02 23 23 60 00 23 7B 70 38 78 ?? ?? ?? ?? 7B 78 00 2B CB D1 ?? ?? ?? ?? 04 46 23 68 53 B1 ?? ?? ?? ?? 38 B1 24 68 20 46 ?? ?? ?? ?? B8 69 02 21 FA 69 A0 47 05 4A 13 68 5B 1C 13 60 01 23 7B 60 78 68 BD E8 9C 08 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_3_0 {
	meta:
		name = "?dllmain_crt_process_detach@@YAH_N@Z"
		size = 100
		refs = "001c __scrt_acquire_startup_lock 002c __scrt_fastfail 0030 __scrt_dllmain_uninitialize_c 0038 __scrt_dllmain_uninitialize_critical 003e __scrt_release_startup_lock 0046 __scrt_uninitialize_crt 005c __scrt_current_native_startup_state 0060 ?__proc_attached@@3HA"
	strings:
		$1 = { 03 B4 2D E9 9C 48 0D F1 10 0B 6F 46 14 4A 13 68 00 2B 01 DC 00 23 1B E0 5B 1E 13 60 ?? ?? ?? ?? 38 70 0E 4C 23 68 02 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 23 60 ?? ?? ?? ?? 38 78 ?? ?? ?? ?? 00 21 38 7E ?? ?? ?? ?? 00 28 E2 D0 01 23 7B 60 78 68 BD E8 9C 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_5_0 {
	meta:
		name = "?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
		size = 264
		refs = "004a _guard_check_icall 0064 ?dllmain_crt_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z 0074 DllMain 0098 ?dllmain_crt_process_detach@@YAH_N@Z 0100 _pRawDllMain 0104 ?__proc_attached@@3HA"
	strings:
		$1 = { 0F B4 2D E9 FE 4F 0D F1 28 0B 6F 46 82 B0 91 46 BA 63 0E 46 7E 63 82 46 38 63 2E B9 39 4B 1B 68 00 2B 01 DC 00 25 64 E0 01 2E 04 D0 02 2E 02 D0 DF F8 CC 80 1B E0 DF F8 C8 80 D8 F8 00 30 0B B9 01 25 09 E0 D8 F8 00 40 20 46 ?? ?? ?? ?? 50 46 31 46 4A 46 A0 47 05 46 3D 60 00 2D 44 D0 4A 46 31 46 50 46 ?? ?? ?? ?? 05 46 3D 60 E5 B3 4A 46 31 46 50 46 ?? ?? ?? ?? 05 46 3D 60 01 2E 18 D1 BD B9 4A 46 00 21 50 46 ?? ?? ?? ?? B9 F1 00 0F 01 D0 01 20 00 E0 00 20 ?? ?? ?? ?? D8 F8 00 30 3B B1 1C 46 18 46 ?? ?? ?? ?? 50 46 00 21 4A 46 A0 47 0E B1 03 2E 17 D1 4A 46 31 46 50 46 ?? ?? ?? ?? 05 46 3D 60 7D B1 D8 F8 00 30 0B B9 01 25 09 E0 D8 F8 00 40 20 46 ?? ?? ?? ?? 50 46 31 46 4A 46 A0 47 05 46 3D 60 03 E0 00 25 3D 60 00 E0 7D 68 28 46 05 B0 BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_6_0 {
	meta:
		name = "?filt$0@?0??dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z@4HA"
		size = 28
		refs = "0012 __scrt_dllmain_exception_filter 0018 ?dllmain_crt_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
	strings:
		$1 = { 1C B5 03 68 1B 68 01 90 00 93 03 4B BA 6B 79 6B 38 6B ?? ?? ?? ?? 1C BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_7_0 {
	meta:
		name = "?dllmain_raw@@YAHQAUHINSTANCE__@@KQAX@Z"
		size = 48
		refs = "001c _guard_check_icall 002c _pRawDllMain"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 08 4C 15 46 0E 46 23 68 07 46 0B B9 01 20 07 E0 24 68 20 46 ?? ?? ?? ?? 38 46 31 46 2A 46 A0 47 BD E8 F0 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_9_0 {
	meta:
		name = "_DllMainCRTStartup"
		size = 36
		refs = "0012 __security_init_cookie 001c ?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 46 01 2C 15 46 06 46 01 D1 ?? ?? ?? ?? 2A 46 21 46 30 46 ?? ?? ?? ?? BD E8 78 88 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__scrt_is_user_matherr_present"
		size = 28
		refs = "0018 __scrt_default_matherr"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 0B B9 01 20 00 E0 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "?__scrt_initialize_thread_safe_statics@@YAHXZ"
		size = 128
		refs = "0048 atexit 0054 ?__scrt_uninitialize_thread_safe_statics@@YAXXZ 0058 ?encoded_wake_all_condition_variable@@3P6AXPAU_RTL_CONDITION_VARIABLE@@@ZA 005c __imp_WakeAllConditionVariable 0060 __imp_SleepConditionVariableCS 0064 ?encoded_sleep_condition_variable_cs@@3P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZA 0068 __security_cookie 006c __imp_InitializeConditionVariable 0070 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0074 ?_Tss_event@@3PAXA 0078 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 007c __imp_InitializeCriticalSectionEx"
	strings:
		$1 = { 2D E9 00 48 EB 46 1D 4B 1B 48 00 22 1B 68 4F F4 7A 61 98 47 17 4B 00 22 15 48 1A 60 13 4B 1B 68 98 47 11 4B 0F 4A 18 68 00 F0 1F 03 C3 F1 20 01 0B 4B 1B 68 CB 41 43 40 13 60 08 4B 06 4A 1B 68 CB 41 43 40 03 48 13 60 ?? ?? ?? ?? 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z"
		size = 28
		refs = "0018 __security_cookie"
		altNames = "??$__crt_fast_decode_pointer@P6AXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z ??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 03 F0 1F 02 43 40 63 FA 02 F0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_3_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z"
		size = 36
		refs = "0020 __security_cookie"
		altNames = "??$__crt_fast_encode_pointer@P6AXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z ??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 1A 68 02 F0 1F 03 C3 F1 20 03 60 FA 03 F3 83 EA 02 00 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_6_0 {
	meta:
		name = "?__scrt_uninitialize_thread_safe_statics@@YAXXZ"
		size = 48
		refs = "0020 __imp_CloseHandle 0024 ?_Tss_event@@3PAXA 0028 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 002c __imp_DeleteCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 4B 07 48 1B 68 98 47 05 4B 18 68 10 B1 02 4B 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_7_0 {
	meta:
		name = "_Init_thread_abort"
		size = 30
		refs = "000a _Init_thread_lock 0012 _Init_thread_unlock 001a _Init_thread_notify"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 00 23 23 60 ?? ?? ?? ?? BD E8 18 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_8_0 {
	meta:
		name = "_Init_thread_footer"
		size = 68
		refs = "000a _Init_thread_lock 002c _Init_thread_unlock 0034 _Init_thread_notify 0038 _Init_thread_epoch 003c _tls_index 0040 _Init_global_epoch"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 0C 48 03 68 5B 1C 03 60 23 60 08 4B 1A 68 1D EE 50 3F DB 6A 53 F8 22 10 04 4A 03 68 8B 50 ?? ?? ?? ?? BD E8 18 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_9_0 {
	meta:
		name = "_Init_thread_header"
		size = 92
		refs = "000a _Init_thread_lock 0022 _Init_thread_wait 0044 _Init_thread_unlock 0050 _Init_thread_epoch 0054 _Init_global_epoch 0058 _tls_index"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 23 68 1B B9 6F F0 00 03 23 60 14 E0 6F F0 00 05 04 E0 64 20 ?? ?? ?? ?? 23 68 83 B1 AB 42 F8 D0 0A 4B 1A 68 1D EE 50 3F DB 6A 53 F8 22 10 05 4B 04 4A 1B 68 8B 50 ?? ?? ?? ?? BD E8 30 88 25 60 F9 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_10_0 {
	meta:
		name = "_Init_thread_lock"
		size = 28
		refs = "0014 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0018 __imp_EnterCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 02 48 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "?__scrt_initialize_type_info@@YAXXZ"
		size = 28
		refs = "0014 ?__type_info_root_node@@3U__type_info_node@@A 0018 __imp_InitializeSListHead"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 02 48 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_12_0 {
	meta:
		name = "_Init_thread_unlock"
		size = 28
		refs = "0014 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0018 __imp_LeaveCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 02 48 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_4_0 {
	meta:
		name = "__scrt_set_unhandled_exception_filter"
		size = 28
		refs = "0014 __scrt_unhandled_exception_filter 0018 __imp_SetUnhandledExceptionFilter"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 02 48 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_11_0 {
	meta:
		name = "_Init_thread_notify"
		size = 88
		refs = "0022 _guard_check_icall 0040 __imp_ResetEvent 0044 __imp_SetEvent 0048 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 004c ?encoded_wake_all_condition_variable@@3P6AXPAU_RTL_CONDITION_VARIABLE@@@ZA 0050 __security_cookie 0054 ?_Tss_event@@3PAXA"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 12 4C 20 68 70 B9 10 4B 19 68 0E 4B 01 F0 1F 02 1B 68 4B 40 63 FA 02 F4 20 46 ?? ?? ?? ?? 08 48 A0 47 06 E0 05 4B 1B 68 98 47 03 4B 20 68 1B 68 98 47 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_13_0 {
	meta:
		name = "_Init_thread_wait"
		size = 112
		refs = "0024 _guard_check_icall 0038 _Init_thread_unlock 004a _Init_thread_lock 0058 __imp_WaitForSingleObjectEx 005c ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0060 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0064 ?encoded_sleep_condition_variable_cs@@3P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZA 0068 __security_cookie 006c ?_Tss_event@@3PAXA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 18 4C 05 46 23 68 9B B9 15 4B 19 68 13 4B 01 F0 1F 02 1B 68 4B 40 63 FA 02 F4 20 46 ?? ?? ?? ?? 0D 48 0C 49 2A 46 A0 47 78 B9 00 20 BD E8 30 88 ?? ?? ?? ?? 06 4B 20 68 00 22 1B 68 29 46 98 47 04 46 ?? ?? ?? ?? 00 2C EF D1 01 20 EE E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_3_0 {
	meta:
		name = "?configure_argv@__scrt_narrow_argv_policy@@SAHXZ"
		size = 18
		refs = "0006 _get_startup_argv_mode 000e _configure_narrow_argv"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_61_2 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@std@@QAA@XZ"
		size = 22
		refs = "000e ?_Decref@_Ref_count_base@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 68 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_81_4_2 {
	meta:
		name = "??1GlobalCore@details@Concurrency@@QAA@XZ"
		size = 18
		refs = "000e ??3@YAXPAXI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 6A 08 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_4_2 {
	meta:
		name = "??1_Lockit@std@@QAA@XZ"
		size = 48
		refs = "000e _unlock_locales 0024 _Mtxunlock 002c ?mtx@std@@3PAU_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 1B B9 BD E8 00 48 ?? ?? ?? ?? 08 2B 08 DA 03 EB 43 02 04 4B 03 EB C2 00 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_19_3 {
	meta:
		name = "??2@YAPAXIAAV_HeapManager@@H@Z"
		size = 24
		refs = "000e ?getMemory@_HeapManager@@QAAPAXIH@Z 0014 ?heap@@3V_HeapManager@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 46 02 48 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_7_3 {
	meta:
		name = "??8type_info@@QBA_NABV0@@Z"
		size = 26
		refs = "000a __std_type_info_compare"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 1D 00 1D ?? ?? ?? ?? 08 B9 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_34_392_2 {
	meta:
		name = "??Y?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV01@G@Z"
		size = 18
		refs = "000e ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 46 01 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_451_1 {
	meta:
		name = "??Y?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV01@_W@Z"
		size = 18
		refs = "000e ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 46 01 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_2_6 {
	meta:
		name = "??__E?C0@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?C0@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F3 04 35 3F }
	condition:
		$1
}

rule file_98_3_0 {
	meta:
		name = "??__E?C0@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?C0@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CD 3B 7F 66 9E A0 E6 3F }
	condition:
		$1
}

rule file_199_2_0 {
	meta:
		name = "??__E?C1@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?C1@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 30 E6 3F }
	condition:
		$1
}

rule file_180_5_6 {
	meta:
		name = "??__E?C1@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?C1@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 30 E6 3F }
	condition:
		$1
}

rule file_199_3_0 {
	meta:
		name = "??__E?C2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?C2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 83 80 5E B9 }
	condition:
		$1
}

rule file_330_4_6 {
	meta:
		name = "??__E?C2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?C2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A8 0C 61 5C 10 D0 2B BF }
	condition:
		$1
}

rule file_98_6_0 {
	meta:
		name = "??__E?C2@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?C2@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 83 80 5E B9 }
	condition:
		$1
}

rule file_180_7_6 {
	meta:
		name = "??__E?C2@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?C2@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A8 0C 61 5C 10 D0 2B BF }
	condition:
		$1
}

rule file_180_9_6 {
	meta:
		name = "??__E?C3@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?C3@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 48 04 49 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7B CB DB 3F 0E E5 26 15 }
	condition:
		$1
}

rule file_236_7_6 {
	meta:
		name = "??__E?K@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?K@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? ED A8 E2 3E }
	condition:
		$1
}

rule file_236_8_6 {
	meta:
		name = "??__E?K@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?K@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F8 0B AE 94 1D 55 DC 3F }
	condition:
		$1
}

rule file_180_10_6 {
	meta:
		name = "??__E?a0@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?a0@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 3D 7E 0D BF }
	condition:
		$1
}

rule file_180_11_6 {
	meta:
		name = "??__E?a0@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?a0@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9A B5 B3 12 FF 07 50 C0 }
	condition:
		$1
}

rule file_180_12_6 {
	meta:
		name = "??__E?a1@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?a1@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_180_13_6 {
	meta:
		name = "??__E?a1@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?a1@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? ED AF 16 20 4A 62 30 40 }
	condition:
		$1
}

rule file_180_14_6 {
	meta:
		name = "??__E?a2@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?a2@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_98_15_0 {
	meta:
		name = "??__E?a2@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?a2@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 29 BD 56 B3 15 44 E9 BF }
	condition:
		$1
}

rule file_98_16_0 {
	meta:
		name = "??__E?b0@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?b0@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 3A 3F D4 C0 }
	condition:
		$1
}

rule file_98_17_0 {
	meta:
		name = "??__E?b0@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?b0@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 77 90 0D 9C FE 0B 88 C0 }
	condition:
		$1
}

rule file_98_18_0 {
	meta:
		name = "??__E?b1@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?b1@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_19_0 {
	meta:
		name = "??__E?b1@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?b1@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7E 26 15 FA 83 80 73 40 }
	condition:
		$1
}

rule file_98_20_0 {
	meta:
		name = "??__E?b2@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?b2@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_180_21_6 {
	meta:
		name = "??__E?b2@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?b2@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 0F CE 67 4B 80 D5 41 C0 }
	condition:
		$1
}

rule file_98_22_0 {
	meta:
		name = "??__E?b3@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?b3@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_180_23_6 {
	meta:
		name = "??__E?b3@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?b3@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_330_5_6 {
	meta:
		name = "??__E?bigx@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?bigx@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 18 72 B1 42 }
	condition:
		$1
}

rule file_330_6_6 {
	meta:
		name = "??__E?bigx@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?bigx@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE 42 2E 86 40 }
	condition:
		$1
}

rule file_236_9_6 {
	meta:
		name = "??__E?bigx@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?bigx@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 18 52 B1 44 }
	condition:
		$1
}

rule file_134_10_0 {
	meta:
		name = "??__E?bigx@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?bigx@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE C2 2D C6 40 }
	condition:
		$1
}

rule file_268_1_6 {
	meta:
		name = "??__E?c1@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?c1@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 22 09 40 }
	condition:
		$1
}

rule file_149_3_0 {
	meta:
		name = "??__E?c1@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?c1@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 22 F9 3F }
	condition:
		$1
}

rule file_154_2_0 {
	meta:
		name = "??__E?c2@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?c2@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7A 77 15 B7 }
	condition:
		$1
}

rule file_268_3_6 {
	meta:
		name = "??__E?c2@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?c2@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9E E5 9E 4B EF AE E2 BE }
	condition:
		$1
}

rule file_260_4_6 {
	meta:
		name = "??__E?c2@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?c2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 22 AA FD 39 }
	condition:
		$1
}

rule file_260_5_6 {
	meta:
		name = "??__E?c2@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?c2@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9E E5 9E 4B EF AE D2 BE }
	condition:
		$1
}

rule file_260_6_6 {
	meta:
		name = "??__E?eps1@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps1@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 00 }
	condition:
		$1
}

rule file_260_7_6 {
	meta:
		name = "??__E?eps1@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps1@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 6F 28 F4 18 66 1C 73 C0 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "??__E?eps@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_102_1_6 {
	meta:
		name = "??__E?eps@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_178_1_6 {
	meta:
		name = "??__E?eps@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_178_2_6 {
	meta:
		name = "??__E?eps@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_330_7_6 {
	meta:
		name = "??__E?eps@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 33 }
	condition:
		$1
}

rule file_330_8_6 {
	meta:
		name = "??__E?eps@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 90 3C }
	condition:
		$1
}

rule file_154_4_0 {
	meta:
		name = "??__E?eps@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_268_5_6 {
	meta:
		name = "??__E?eps@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CD 3B 7F 66 9E A0 46 3E }
	condition:
		$1
}

rule file_147_3_6 {
	meta:
		name = "??__E?eps@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_81_4_0 {
	meta:
		name = "??__E?eps@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_260_8_6 {
	meta:
		name = "??__E?eps@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_260_9_6 {
	meta:
		name = "??__E?eps@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_120_0_6 {
	meta:
		name = "??__E?eps@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_120_1_6 {
	meta:
		name = "??__E?eps@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_330_10_6 {
	meta:
		name = "??__E?exponentBias@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@I@Z 0018 ?exponentBias@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 F2 FE 30 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_4_0 {
	meta:
		name = "??__E?exponentMask@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 FF 40 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_260_13_6 {
	meta:
		name = "??__E?exponentMask@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?exponentMask@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 F0 7F }
	condition:
		$1
}

rule file_268_10_6 {
	meta:
		name = "??__E?half@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?half@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B6 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_11_6 {
	meta:
		name = "??__E?half@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?half@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B6 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_8_0 {
	meta:
		name = "??__E?ind@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?ind@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 F8 FF }
	condition:
		$1
}

rule file_154_14_0 {
	meta:
		name = "??__E?inf@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?inf@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 FF 40 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_15_6 {
	meta:
		name = "??__E?inf@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?inf@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 F0 7F }
	condition:
		$1
}

rule file_199_17_0 {
	meta:
		name = "??__E?inv_ln2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?inv_ln2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 3B AA B8 3F }
	condition:
		$1
}

rule file_199_18_0 {
	meta:
		name = "??__E?inv_ln2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?inv_ln2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? FE 82 2B 65 47 15 F7 3F }
	condition:
		$1
}

rule file_199_19_0 {
	meta:
		name = "??__E?ln2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?ln2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 18 72 31 3F }
	condition:
		$1
}

rule file_199_20_0 {
	meta:
		name = "??__E?ln2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?ln2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE 42 2E E6 3F }
	condition:
		$1
}

rule file_81_14_0 {
	meta:
		name = "??__E?ln_v@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?ln_v@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 60 2E E6 3F }
	condition:
		$1
}

rule file_134_20_0 {
	meta:
		name = "??__E?lsb_mask@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?lsb_mask@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 01 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_22_0 {
	meta:
		name = "??__E?neginf@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?neginf@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 F0 FF }
	condition:
		$1
}

rule file_149_20_0 {
	meta:
		name = "??__E?notExponentMask@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?notExponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 FF 40 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_20_0 {
	meta:
		name = "??__E?one@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?one@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_21_6 {
	meta:
		name = "??__E?one@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?one@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_19_0 {
	meta:
		name = "??__E?one_over_v_squared@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?one_over_v_squared@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 30 FE 7F 3E }
	condition:
		$1
}

rule file_81_20_0 {
	meta:
		name = "??__E?one_over_v_squared@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?one_over_v_squared@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 74 07 29 FE C5 FF CF 3F }
	condition:
		$1
}

rule file_95_15_0 {
	meta:
		name = "??__E?p0@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F6 10 F1 BE }
	condition:
		$1
}

rule file_95_16_0 {
	meta:
		name = "??__E?p0@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? E2 1C 06 51 A6 60 2B C0 }
	condition:
		$1
}

rule file_330_25_6 {
	meta:
		name = "??__E?p0@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B5 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_26_0 {
	meta:
		name = "??__E?p0@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 82 25 B6 FE FF FF CF 3F }
	condition:
		$1
}

rule file_81_21_0 {
	meta:
		name = "??__E?p0@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F0 69 E4 C0 }
	condition:
		$1
}

rule file_81_22_0 {
	meta:
		name = "??__E?p0@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 19 34 53 56 13 79 15 C1 }
	condition:
		$1
}

rule file_260_22_6 {
	meta:
		name = "??__E?p0@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_23_0 {
	meta:
		name = "??__E?p0@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_14_0 {
	meta:
		name = "??__E?p0@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? C6 E2 52 BF }
	condition:
		$1
}

rule file_120_15_6 {
	meta:
		name = "??__E?p0@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1F B2 B0 C9 A5 35 99 C0 }
	condition:
		$1
}

rule file_102_14_6 {
	meta:
		name = "??__E?p1@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 6B 16 6F 3F }
	condition:
		$1
}

rule file_102_15_6 {
	meta:
		name = "??__E?p1@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 62 0A 3A A8 55 5E 3B C0 }
	condition:
		$1
}

rule file_95_17_0 {
	meta:
		name = "??__E?p1@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 91 86 50 BD }
	condition:
		$1
}

rule file_178_18_6 {
	meta:
		name = "??__E?p1@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CB BC E2 B9 7F 81 34 C0 }
	condition:
		$1
}

rule file_330_27_6 {
	meta:
		name = "??__E?p1@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 08 53 88 3B }
	condition:
		$1
}

rule file_199_28_0 {
	meta:
		name = "??__E?p1@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? E0 F6 B3 6F E4 70 7C 3F }
	condition:
		$1
}

rule file_134_25_0 {
	meta:
		name = "??__E?p1@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 5C B7 AA 3D }
	condition:
		$1
}

rule file_236_26_6 {
	meta:
		name = "??__E?p1@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 4D 55 55 55 55 55 B5 3F }
	condition:
		$1
}

rule file_81_23_0 {
	meta:
		name = "??__E?p1@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? C2 E6 42 BE }
	condition:
		$1
}

rule file_147_24_6 {
	meta:
		name = "??__E?p1@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 90 14 94 B6 C2 95 C6 C0 }
	condition:
		$1
}

rule file_260_24_6 {
	meta:
		name = "??__E?p1@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B8 33 C4 BD }
	condition:
		$1
}

rule file_260_25_6 {
	meta:
		name = "??__E?p1@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 09 4D E5 B5 12 C1 BF }
	condition:
		$1
}

rule file_120_16_6 {
	meta:
		name = "??__E?p1@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B2 11 7B BB }
	condition:
		$1
}

rule file_120_17_6 {
	meta:
		name = "??__E?p1@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CC 5C BA A1 75 CE 58 C0 }
	condition:
		$1
}

rule file_53_16_0 {
	meta:
		name = "??__E?p2@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 65 20 01 BF }
	condition:
		$1
}

rule file_102_17_6 {
	meta:
		name = "??__E?p2@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 8A D4 0A 36 A7 9A 4C 40 }
	condition:
		$1
}

rule file_178_19_6 {
	meta:
		name = "??__E?p2@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_95_20_0 {
	meta:
		name = "??__E?p2@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 63 6A 8D 5C 3F FD 20 C0 }
	condition:
		$1
}

rule file_330_29_6 {
	meta:
		name = "??__E?p2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_199_30_0 {
	meta:
		name = "??__E?p2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1C DC 58 6F A4 52 F1 3E }
	condition:
		$1
}

rule file_236_27_6 {
	meta:
		name = "??__E?p2@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_236_28_6 {
	meta:
		name = "??__E?p2@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 0E 08 9E 99 99 99 89 3F }
	condition:
		$1
}

rule file_81_25_0 {
	meta:
		name = "??__E?p2@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_81_26_0 {
	meta:
		name = "??__E?p2@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 4A BE 85 63 41 78 64 C0 }
	condition:
		$1
}

rule file_149_26_0 {
	meta:
		name = "??__E?p2@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_260_27_6 {
	meta:
		name = "??__E?p2@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? DF AA 3B A6 82 0E 6C 3F }
	condition:
		$1
}

rule file_63_18_0 {
	meta:
		name = "??__E?p2@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_63_19_0 {
	meta:
		name = "??__E?p2@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7F A7 FB CE 28 DC EE BF }
	condition:
		$1
}

rule file_53_18_0 {
	meta:
		name = "??__E?p3@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_53_19_0 {
	meta:
		name = "??__E?p3@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9F DA A6 A9 2C D8 43 C0 }
	condition:
		$1
}

rule file_95_21_0 {
	meta:
		name = "??__E?p3@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_178_22_6 {
	meta:
		name = "??__E?p3@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? BD 87 B1 D9 7A CD EA BF }
	condition:
		$1
}

rule file_134_29_0 {
	meta:
		name = "??__E?p3@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_134_30_0 {
	meta:
		name = "??__E?p3@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? AC 8D 27 2E 24 49 62 3F }
	condition:
		$1
}

rule file_81_27_0 {
	meta:
		name = "??__E?p3@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_81_28_0 {
	meta:
		name = "??__E?p3@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1B C8 6F B8 E7 44 E9 BF }
	condition:
		$1
}

rule file_260_28_6 {
	meta:
		name = "??__E?p3@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_149_29_0 {
	meta:
		name = "??__E?p3@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 24 C7 A2 2E B7 BA F2 BE }
	condition:
		$1
}

rule file_53_20_0 {
	meta:
		name = "??__E?p4@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p4@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_21_6 {
	meta:
		name = "??__E?p4@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p4@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 27 39 EC 64 17 4E 24 40 }
	condition:
		$1
}

rule file_134_31_0 {
	meta:
		name = "??__E?p4@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p4@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_236_32_6 {
	meta:
		name = "??__E?p4@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p4@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 28 FC 4A DB FD 78 3C 3F }
	condition:
		$1
}

rule file_53_22_0 {
	meta:
		name = "??__E?p5@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p5@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_23_6 {
	meta:
		name = "??__E?p5@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p5@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 65 1E E6 B5 BD 4B E6 BF }
	condition:
		$1
}

rule file_53_24_0 {
	meta:
		name = "??__E?q0@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F0 50 B3 40 }
	condition:
		$1
}

rule file_53_25_0 {
	meta:
		name = "??__E?q0@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CC 87 2B 3E C0 86 64 C0 }
	condition:
		$1
}

rule file_178_23_6 {
	meta:
		name = "??__E?q0@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D3 CC B4 3F }
	condition:
		$1
}

rule file_178_24_6 {
	meta:
		name = "??__E?q0@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A9 95 C4 BC 7C 88 44 40 }
	condition:
		$1
}

rule file_330_31_6 {
	meta:
		name = "??__E?q0@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B6 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_330_32_6 {
	meta:
		name = "??__E?q0@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B6 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_29_0 {
	meta:
		name = "??__E?q0@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 93 4F 2B C2 }
	condition:
		$1
}

rule file_81_30_0 {
	meta:
		name = "??__E?q0@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 13 67 BE 80 CE 1A 40 C1 }
	condition:
		$1
}

rule file_149_30_0 {
	meta:
		name = "??__E?q0@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_260_31_6 {
	meta:
		name = "??__E?q0@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_20_6 {
	meta:
		name = "??__E?q0@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1A 2A 1E 40 }
	condition:
		$1
}

rule file_120_21_6 {
	meta:
		name = "??__E?q0@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 93 96 4E 57 3C E8 B2 40 }
	condition:
		$1
}

rule file_53_26_0 {
	meta:
		name = "??__E?q1@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 0B 8D B1 C0 }
	condition:
		$1
}

rule file_53_27_0 {
	meta:
		name = "??__E?q1@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 43 B8 1E 10 4F 12 7A 40 }
	condition:
		$1
}

rule file_178_25_6 {
	meta:
		name = "??__E?q1@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_26_6 {
	meta:
		name = "??__E?q1@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A5 6D 0B 04 12 8A 55 40 }
	condition:
		$1
}

rule file_199_33_0 {
	meta:
		name = "??__E?q1@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 5B BF 4C 3D }
	condition:
		$1
}

rule file_330_34_6 {
	meta:
		name = "??__E?q1@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B3 51 42 71 8E 71 AC 3F }
	condition:
		$1
}

rule file_236_33_6 {
	meta:
		name = "??__E?q1@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 11 72 31 3F }
	condition:
		$1
}

rule file_134_34_0 {
	meta:
		name = "??__E?q1@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE 42 2E E6 3F }
	condition:
		$1
}

rule file_81_31_0 {
	meta:
		name = "??__E?q1@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_147_32_6 {
	meta:
		name = "??__E?q1@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? C7 5E B6 23 57 A8 E1 40 }
	condition:
		$1
}

rule file_260_32_6 {
	meta:
		name = "??__E?q1@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? AF B7 DB BE }
	condition:
		$1
}

rule file_260_33_6 {
	meta:
		name = "??__E?q1@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D5 D9 FB 47 B0 DE DD BF }
	condition:
		$1
}

rule file_120_22_6 {
	meta:
		name = "??__E?q1@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_23_6 {
	meta:
		name = "??__E?q1@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F3 F0 01 4D 8B 73 A1 40 }
	condition:
		$1
}

rule file_53_28_0 {
	meta:
		name = "??__E?q2@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_29_6 {
	meta:
		name = "??__E?q2@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 48 A8 56 FC CE DD 77 C0 }
	condition:
		$1
}

rule file_95_27_0 {
	meta:
		name = "??__E?q2@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_95_28_0 {
	meta:
		name = "??__E?q2@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D7 A3 0D 32 0A CA 4D 40 }
	condition:
		$1
}

rule file_199_35_0 {
	meta:
		name = "??__E?q2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_330_36_6 {
	meta:
		name = "??__E?q2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 09 38 DE 6F 99 3F 40 3F }
	condition:
		$1
}

rule file_236_35_6 {
	meta:
		name = "??__E?q2@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 15 F3 75 3E }
	condition:
		$1
}

rule file_134_36_0 {
	meta:
		name = "??__E?q2@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CE C4 82 FF BD BF CE 3F }
	condition:
		$1
}

rule file_81_33_0 {
	meta:
		name = "??__E?q2@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_147_34_6 {
	meta:
		name = "??__E?q2@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F2 7F C9 81 C3 5B 71 C0 }
	condition:
		$1
}

rule file_149_34_0 {
	meta:
		name = "??__E?q2@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 75 33 1F 3C }
	condition:
		$1
}

rule file_260_35_6 {
	meta:
		name = "??__E?q2@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 59 21 7E A1 9E 47 9A 3F }
	condition:
		$1
}

rule file_63_24_0 {
	meta:
		name = "??__E?q2@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_63_25_0 {
	meta:
		name = "??__E?q2@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? FA F7 EB E1 A9 2F 5C 40 }
	condition:
		$1
}

rule file_102_30_6 {
	meta:
		name = "??__E?q3@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_53_31_0 {
	meta:
		name = "??__E?q3@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 70 1C 59 96 7C DE 62 40 }
	condition:
		$1
}

rule file_178_29_6 {
	meta:
		name = "??__E?q3@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_95_30_0 {
	meta:
		name = "??__E?q3@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 10 C7 4A E1 49 0C 2E 40 }
	condition:
		$1
}

rule file_236_37_6 {
	meta:
		name = "??__E?q3@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? FE A8 5E 3D }
	condition:
		$1
}

rule file_236_38_6 {
	meta:
		name = "??__E?q3@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 6D 02 03 D7 08 6B AC 3F }
	condition:
		$1
}

rule file_81_35_0 {
	meta:
		name = "??__E?q3@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_81_36_0 {
	meta:
		name = "??__E?q3@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_260_36_6 {
	meta:
		name = "??__E?q3@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_260_37_6 {
	meta:
		name = "??__E?q3@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 41 48 09 99 64 6F 34 BF }
	condition:
		$1
}

rule file_120_26_6 {
	meta:
		name = "??__E?q3@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_63_27_0 {
	meta:
		name = "??__E?q3@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_32_0 {
	meta:
		name = "??__E?q4@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q4@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_53_33_0 {
	meta:
		name = "??__E?q4@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q4@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1F 86 F9 6E E8 D2 37 C0 }
	condition:
		$1
}

rule file_95_31_0 {
	meta:
		name = "??__E?q4@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q4@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_178_32_6 {
	meta:
		name = "??__E?q4@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q4@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_39_0 {
	meta:
		name = "??__E?q4@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q4@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_134_40_0 {
	meta:
		name = "??__E?q4@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q4@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 98 1D 13 6E AB B2 83 3F }
	condition:
		$1
}

rule file_260_38_6 {
	meta:
		name = "??__E?q4@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q4@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_260_39_6 {
	meta:
		name = "??__E?q4@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q4@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? E9 78 76 F0 74 B7 A0 3E }
	condition:
		$1
}

rule file_53_34_0 {
	meta:
		name = "??__E?q5@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q5@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_53_35_0 {
	meta:
		name = "??__E?q5@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q5@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_41_0 {
	meta:
		name = "??__E?q5@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q5@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_236_42_6 {
	meta:
		name = "??__E?q5@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q5@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9F CD D7 18 7E D8 55 3F }
	condition:
		$1
}

rule file_236_43_6 {
	meta:
		name = "??__E?q6@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q6@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_134_44_0 {
	meta:
		name = "??__E?q6@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q6@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 74 4C 38 E0 7A 2F 24 3F }
	condition:
		$1
}

rule file_134_45_0 {
	meta:
		name = "??__E?q7@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q7@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_134_46_0 {
	meta:
		name = "??__E?q7@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q7@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 80 CC 92 E3 DD 4E EF 3E }
	condition:
		$1
}

rule file_154_22_0 {
	meta:
		name = "??__E?r1@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r1@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A4 AA 2A BE }
	condition:
		$1
}

rule file_268_23_6 {
	meta:
		name = "??__E?r1@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r1@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 55 55 55 55 55 55 C5 BF }
	condition:
		$1
}

rule file_154_24_0 {
	meta:
		name = "??__E?r2@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r2@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 3E 87 08 3C }
	condition:
		$1
}

rule file_268_25_6 {
	meta:
		name = "??__E?r2@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r2@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B0 10 11 11 11 11 81 3F }
	condition:
		$1
}

rule file_154_26_0 {
	meta:
		name = "??__E?r3@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r3@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 22 B2 4F B9 }
	condition:
		$1
}

rule file_154_27_0 {
	meta:
		name = "??__E?r3@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r3@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1A 3E 01 1A A0 01 2A BF }
	condition:
		$1
}

rule file_154_28_0 {
	meta:
		name = "??__E?r4@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r4@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 5B 9C 2E 36 }
	condition:
		$1
}

rule file_268_29_6 {
	meta:
		name = "??__E?r4@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r4@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 63 F0 24 A5 E3 1D C7 3E }
	condition:
		$1
}

rule file_154_30_0 {
	meta:
		name = "??__E?r5@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r5@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_268_31_6 {
	meta:
		name = "??__E?r5@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r5@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? AB C0 5D 4B 45 E6 5A BE }
	condition:
		$1
}

rule file_268_32_6 {
	meta:
		name = "??__E?r6@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r6@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_268_33_6 {
	meta:
		name = "??__E?r6@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r6@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 30 D4 6A 68 3C 12 E6 3D }
	condition:
		$1
}

rule file_268_34_6 {
	meta:
		name = "??__E?r7@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r7@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_154_35_0 {
	meta:
		name = "??__E?r7@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r7@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9C 49 08 DC 20 E4 6A BD }
	condition:
		$1
}

rule file_154_36_0 {
	meta:
		name = "??__E?r8@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r8@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_154_37_0 {
	meta:
		name = "??__E?r8@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r8@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 95 DF 93 69 FF 80 E8 3C }
	condition:
		$1
}

rule file_154_38_0 {
	meta:
		name = "??__E?sign_mask@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?sign_mask@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 00 40 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_330_37_6 {
	meta:
		name = "??__E?smallx@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?smallx@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 50 AC AE C2 }
	condition:
		$1
}

rule file_199_38_0 {
	meta:
		name = "??__E?smallx@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?smallx@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D2 BC 7A DD 2B 23 86 C0 }
	condition:
		$1
}

rule file_236_47_6 {
	meta:
		name = "??__E?smallx@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?smallx@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 50 8C AE C4 }
	condition:
		$1
}

rule file_236_48_6 {
	meta:
		name = "??__E?smallx@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?smallx@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D2 BC 7A DD AB 22 C6 C0 }
	condition:
		$1
}

rule file_95_34_0 {
	meta:
		name = "??__E?sqrt_three@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?sqrt_three@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 48 04 49 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7A B6 FB 3F AA 4C 58 E8 }
	condition:
		$1
}

rule file_95_36_0 {
	meta:
		name = "??__E?two_minus_sqrt_three@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?two_minus_sqrt_three@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 48 04 49 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 14 26 D1 3F 56 CD 9E 5E }
	condition:
		$1
}

rule file_81_37_0 {
	meta:
		name = "??__E?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 97 08 68 37 }
	condition:
		$1
}

rule file_81_38_0 {
	meta:
		name = "??__E?v_over_two_minus_1@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?v_over_two_minus_1@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D6 02 02 EB 12 01 ED 3E }
	condition:
		$1
}

rule file_81_39_0 {
	meta:
		name = "??__E?wmax@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?wmax@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7A 70 B1 42 }
	condition:
		$1
}

rule file_81_40_0 {
	meta:
		name = "??__E?wmax@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?wmax@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B1 BF EC 9E 3C 2E 86 40 }
	condition:
		$1
}

rule file_120_28_6 {
	meta:
		name = "??__E?xbig@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?xbig@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B3 2C 10 41 }
	condition:
		$1
}

rule file_120_29_6 {
	meta:
		name = "??__E?xbig@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?xbig@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 A0 C1 0F 33 40 }
	condition:
		$1
}

rule file_81_41_0 {
	meta:
		name = "??__E?ybar@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?ybar@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 18 72 B1 42 }
	condition:
		$1
}

rule file_81_42_0 {
	meta:
		name = "??__E?ybar@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?ybar@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE 42 2E 86 40 }
	condition:
		$1
}

rule file_268_40_6 {
	meta:
		name = "??__E?ymax@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?ymax@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? DB 0F 49 46 }
	condition:
		$1
}

rule file_154_41_0 {
	meta:
		name = "??__E?ymax@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?ymax@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? E1 62 DD 1A 83 C5 B1 41 }
	condition:
		$1
}

rule file_260_40_6 {
	meta:
		name = "??__E?ymax@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?ymax@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 08 C9 45 }
	condition:
		$1
}

rule file_149_41_0 {
	meta:
		name = "??__E?ymax@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?ymax@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 54 FB 21 99 41 }
	condition:
		$1
}

rule file_47_98_2 {
	meta:
		name = "?_Decref@?$_Ptr_base@V__ExceptionPtr@@@std@@QAAXXZ"
		size = 22
		refs = "000e ?_Decref@_Ref_count_base@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 68 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_51_45_1 {
	meta:
		name = "?_Inc_atomic_counter_explicit@std@@YAKAAKW4memory_order@1@@Z"
		size = 20
		refs = "000a ?_Atomic_fetch_add_4@std@@YAKPCKKW4memory_order@1@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 46 01 21 ?? ?? ?? ?? 40 1C BD E8 00 88 }
	condition:
		$1
}

rule file_27_246_1 {
	meta:
		name = "?_Lock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAAXXZ"
		size = 22
		refs = "000e _lock_file"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 6C 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_89_248_1 {
	meta:
		name = "?_Lock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAAXXZ"
		size = 22
		refs = "000e _lock_file"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 6C 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_102_220_2 {
	meta:
		name = "?_Lock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAAXXZ"
		size = 22
		refs = "000e _lock_file"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 6C 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_19_26_1 {
	meta:
		name = "?_ReportUnobservedException@details@Concurrency@@YAXXZ"
		size = 16
		refs = "000a terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 20 FB DE ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_95_269_1 {
	meta:
		name = "?_Unlock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAAXXZ"
		size = 22
		refs = "000e _unlock_file"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 6C 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_102_270_1 {
	meta:
		name = "?_Unlock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAAXXZ"
		size = 22
		refs = "000e _unlock_file"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 6C 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_68_239_2 {
	meta:
		name = "?_Unlock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAAXXZ"
		size = 22
		refs = "000e _unlock_file"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 6C 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_98_133_1 {
	meta:
		name = "?__ExceptionPtrDestroy@@YAXPAX@Z"
		size = 22
		refs = "000e ?_Decref@_Ref_count_base@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 68 18 B1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_47_134_2 {
	meta:
		name = "?__ExceptionPtrRethrow@@YAXPBX@Z"
		size = 16
		refs = "0006 ??C?$shared_ptr@V__ExceptionPtr@@@std@@QBAPAV__ExceptionPtr@@XZ 000a ?_RethrowException@__ExceptionPtr@@QBAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_218_3_6 {
	meta:
		name = "?__scrt_common_main@@YAHXZ"
		size = 18
		refs = "0006 __security_init_cookie 000e ?__scrt_common_main_seh@@YAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_6_6 {
	meta:
		name = "?configure_argv@__scrt_wide_argv_policy@@SAHXZ"
		size = 18
		refs = "0006 _get_startup_argv_mode 000e _configure_wide_argv"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_269_2 {
	meta:
		name = "?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
		size = 18
		refs = "000a memcpy"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 B1 52 00 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_94_269_2 {
	meta:
		name = "?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 18
		refs = "000a memcpy"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 B1 52 00 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_34_1193_2 {
	meta:
		name = "?move@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
		size = 18
		refs = "000a memmove"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 B1 52 00 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_17_1288_1 {
	meta:
		name = "?move@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 18
		refs = "000a memmove"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 B1 52 00 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_352_2_6 {
	meta:
		name = "?pre_cpp_initialization@@YAXXZ"
		size = 22
		refs = "0006 __scrt_set_unhandled_exception_filter 000a _get_startup_new_mode 0012 _set_new_mode"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_31_2 {
	meta:
		name = "?wait@stl_condition_variable_concrt@details@Concurrency@@UAAXPAVstl_critical_section_interface@23@@Z"
		size = 18
		refs = "000e ?wait@_Condition_variable@details@Concurrency@@QAAXAAVcritical_section@3@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 1D 00 1D BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_34_2 {
	meta:
		name = "?wait_for@stl_condition_variable_concrt@details@Concurrency@@UAA_NPAVstl_critical_section_interface@23@I@Z"
		size = 18
		refs = "000e ?wait_for@_Condition_variable@details@Concurrency@@QAA_NAAVcritical_section@3@I@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 1D 00 1D BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_10_6 {
	meta:
		name = "WinMainCRTStartup"
		size = 18
		refs = "0006 __security_init_cookie 000e ?__scrt_common_main_seh@@YAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_13_3 {
	meta:
		name = "_MoveContext"
		size = 18
		refs = "000e memmove"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F4 D0 72 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_360_11_6 {
	meta:
		name = "__scrt_dllmain_crt_thread_detach"
		size = 20
		refs = "0006 __acrt_thread_detach 000a __vcrt_thread_detach"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? ?? ?? ?? ?? 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_5_3_3 {
	meta:
		name = "__vcrt_uninitialize"
		size = 28
		refs = "0008 __vcrt_uninitialize_ptd 000c __vcrt_uninitialize_locks 0012 __vcrt_uninitialize_winapi_thunks"
	strings:
		$1 = { 2D E9 00 48 EB 46 30 B9 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_12_407_1 {
	meta:
		name = "ldexpf"
		size = 22
		refs = "000a ldexp"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE C0 0A ?? ?? ?? ?? B7 EE C0 0B BD E8 00 88 }
	condition:
		$1
}

rule file_158_10_0 {
	meta:
		name = "mainCRTStartup"
		size = 18
		refs = "0006 __security_init_cookie 000e ?__scrt_common_main_seh@@YAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_10_0 {
	meta:
		name = "wWinMainCRTStartup"
		size = 18
		refs = "0006 __security_init_cookie 000e ?__scrt_common_main_seh@@YAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_10_0 {
	meta:
		name = "wmainCRTStartup"
		size = 18
		refs = "0006 __security_init_cookie 000e ?__scrt_common_main_seh@@YAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_4_0 {
	meta:
		name = "?find_pe_section@@YAPAU_IMAGE_SECTION_HEADER@@QAEI@Z"
		size = 58
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B C3 6B 1A 18 93 8A 13 44 03 F1 18 00 D3 88 03 EB 83 03 00 EB C3 04 07 E0 C2 68 91 42 03 D3 83 68 13 44 99 42 03 D3 28 30 A0 42 F5 D1 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_18_5_0 {
	meta:
		name = "?is_potentially_valid_image_base@@YA_NQAX@Z"
		size = 52
	strings:
		$1 = { 2D E9 00 48 EB 46 08 B9 00 20 11 E0 02 88 45 F6 4D 23 9A 42 F8 D1 C3 6B 1A 58 19 18 44 F2 50 53 9A 42 F1 D1 0A 8B 40 F2 0B 13 9A 42 EC D1 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_18_7_0 {
	meta:
		name = "__scrt_acquire_startup_lock"
		size = 84
		refs = "0006 __scrt_is_ucrt_dll_in_use 0050 __scrt_native_startup_lock"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? E0 B1 1D EE 50 3F 59 68 BF F3 5B 8F 0E 48 50 E8 00 2F 1A B9 40 E8 00 13 00 2B F8 D1 0A E0 91 42 0F D0 BF F3 5B 8F 50 E8 00 2F 1A B9 40 E8 00 13 00 2B F8 D1 BF F3 5B 8F 00 2A F0 D1 00 20 BD E8 00 88 01 20 FB E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_8_0 {
	meta:
		name = "__scrt_dllmain_after_initialize_c"
		size = 42
		refs = "0006 __scrt_is_ucrt_dll_in_use 000c __isa_available_init 0012 _get_startup_argv_mode 0016 _configure_narrow_argv 0020 _initialize_narrow_environment"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 10 B1 ?? ?? ?? ?? 08 E0 ?? ?? ?? ?? ?? ?? ?? ?? 08 B1 00 20 02 E0 ?? ?? ?? ?? 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_44_271_1 {
	meta:
		name = "?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
		size = 20
		refs = "0008 ?_Xlength_error@std@@YAXPBD@Z 0010 ??_C@_0BA@JFNIOLAK@string?5too?5long?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_917_1 {
	meta:
		name = "?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
		size = 20
		refs = "0008 ?_Xlength_error@std@@YAXPBD@Z 0010 ??_C@_0BA@JFNIOLAK@string?5too?5long?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_66_2 {
	meta:
		name = "?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
		size = 20
		refs = "0008 ?_Xlength_error@std@@YAXPBD@Z 0010 ??_C@_0BA@JFNIOLAK@string?5too?5long?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_242_2 {
	meta:
		name = "?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
		size = 20
		refs = "0008 ?_Xout_of_range@std@@YAXPBD@Z 0010 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_841_2 {
	meta:
		name = "?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
		size = 20
		refs = "0008 ?_Xout_of_range@std@@YAXPBD@Z 0010 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_842_2 {
	meta:
		name = "?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
		size = 20
		refs = "0008 ?_Xout_of_range@std@@YAXPBD@Z 0010 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_969_1 {
	meta:
		name = "?copy@?$char_traits@D@std@@SAPADPADPBDI@Z"
		size = 16
		refs = "0008 memcpy"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A B1 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_103_439_2 {
	meta:
		name = "?move@?$char_traits@D@std@@SAPADPADPBDI@Z"
		size = 16
		refs = "0008 memmove"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A B1 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_18_14_0 {
	meta:
		name = "__scrt_dllmain_uninitialize_critical"
		size = 20
		refs = "0008 __acrt_uninitialize_critical 0010 __vcrt_uninitialize_critical"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_9_0 {
	meta:
		name = "__scrt_dllmain_before_initialize_c"
		size = 24
		refs = "0008 __scrt_initialize_onexit_tables"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 ?? ?? ?? ?? 08 B9 00 20 00 E0 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_18_10_0 {
	meta:
		name = "__scrt_dllmain_crt_thread_attach"
		size = 34
		refs = "0006 __vcrt_thread_attach 0010 __acrt_thread_attach 0016 __vcrt_thread_detach"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 08 B9 00 20 06 E0 ?? ?? ?? ?? 10 B9 ?? ?? ?? ?? F7 E7 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_18_12_0 {
	meta:
		name = "__scrt_dllmain_exception_filter"
		size = 52
		refs = "0010 __scrt_is_ucrt_dll_in_use 001c _guard_check_icall 0030 _seh_filter_dll"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 1C 46 16 46 0D 46 07 46 ?? ?? ?? ?? 40 B9 01 2D 06 D1 20 46 ?? ?? ?? ?? 38 46 00 21 32 46 A0 47 07 99 06 98 BD E8 F0 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_13_0 {
	meta:
		name = "__scrt_dllmain_uninitialize_c"
		size = 44
		refs = "0006 __scrt_is_ucrt_dll_in_use 0012 _execute_onexit_table 0016 _is_c_termination_complete 0020 _cexit 0028 ?module_local_atexit_table@@3U_onexit_table_t@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 20 B1 06 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? 18 B9 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_15_0 {
	meta:
		name = "__scrt_initialize_crt"
		size = 52
		refs = "000e __isa_available_init 0012 __vcrt_initialize 001c __acrt_initialize 0024 __vcrt_uninitialize 0030 ?is_initialized_as_dll@@3_NA"
	strings:
		$1 = { 2D E9 00 48 EB 46 10 B9 09 4B 01 22 1A 70 ?? ?? ?? ?? ?? ?? ?? ?? 08 B9 00 20 07 E0 ?? ?? ?? ?? 18 B9 00 20 ?? ?? ?? ?? F6 E7 01 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_16_0 {
	meta:
		name = "__scrt_initialize_onexit_tables"
		size = 124
		refs = "0010 __scrt_is_ucrt_dll_in_use 001c _initialize_onexit_table 006e __scrt_fastfail 0074 ?module_local_atexit_table@@3U_onexit_table_t@@A 0078 __security_cookie"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 04 46 0C B1 01 2C 2D D1 ?? ?? ?? ?? 68 B1 64 B9 16 4C 20 46 ?? ?? ?? ?? 08 B1 00 20 1F E0 04 F1 0C 00 ?? ?? ?? ?? C8 B1 F7 E7 11 4B 6F F0 00 01 0E 4D 1A 68 68 46 02 F0 1F 03 C3 F1 20 03 61 FA 03 F3 83 EA 02 04 CD E9 00 44 02 94 0E C8 68 46 0E C5 CD E9 00 44 02 94 0E C8 0E C5 01 20 04 B0 BD E8 30 88 05 20 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_17_0 {
	meta:
		name = "__scrt_is_nonwritable_in_current_image"
		size = 136
		refs = "0084 __ImageBase"
	strings:
		$1 = { 2D E9 9C 48 0D F1 10 0B 6F 46 45 F6 4D 22 1D 49 0B 88 93 42 2E D1 CB 6B 5C 18 5A 58 44 F2 50 53 9A 42 27 D1 22 8B 40 F2 0B 13 9A 42 22 D1 40 1A A3 8A 23 44 03 F1 18 02 E3 88 03 EB 83 03 02 EB C3 04 A2 42 08 D0 D1 68 88 42 03 D3 93 68 0B 44 98 42 02 D3 28 32 F4 E7 00 22 12 B9 00 20 38 70 0E E0 53 6A 00 2B 02 DA 00 20 38 70 08 E0 01 20 38 70 05 E0 00 20 38 70 02 E0 00 20 00 E0 38 78 BD E8 9C 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_18_0 {
	meta:
		name = "__scrt_is_nonwritable_in_current_image$filt$0"
		size = 24
		altNames = "_IsNonwritableInCurrentImage$filt$0 __RTCastToVoid$filt$0 __RTtypeid$filt$0"
	strings:
		$1 = { 03 68 1A 68 03 4B 9A 42 01 D1 01 20 00 E0 00 20 70 47 FE DE 05 00 00 C0 }
	condition:
		$1
}

rule file_18_19_0 {
	meta:
		name = "__scrt_release_startup_lock"
		size = 52
		refs = "000a __scrt_is_ucrt_dll_in_use 0030 __scrt_native_startup_lock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 60 B1 5C B9 BF F3 5B 8F 06 4A 00 20 52 E8 00 1F 42 E8 00 03 00 2B F9 D1 BF F3 5B 8F BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_20_0 {
	meta:
		name = "__scrt_uninitialize_crt"
		size = 40
		refs = "0014 __acrt_uninitialize 001a __vcrt_uninitialize 0024 ?is_initialized_as_dll@@3_NA"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 06 4B 04 46 1B 78 03 B1 29 B9 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 01 20 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_21_0 {
	meta:
		name = "_onexit"
		size = 64
		refs = "0022 _crt_atexit 002a _register_onexit_function 0038 ?module_local_atexit_table@@3U_onexit_table_t@@A 003c __security_cookie"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 4B 04 46 0A 48 19 68 03 68 01 F0 1F 02 4B 40 D3 41 B3 F1 FF 3F 03 D1 20 46 ?? ?? ?? ?? 02 E0 21 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_22_0 {
	meta:
		name = "at_quick_exit"
		size = 56
		refs = "001e _crt_at_quick_exit 0028 _register_onexit_function 0030 ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 0034 __security_cookie"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 09 4C 19 68 23 68 01 F0 1F 02 4B 40 D3 41 B3 F1 FF 3F 02 D1 ?? ?? ?? ?? 03 E0 01 46 20 46 ?? ?? ?? ?? BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_23_0 {
	meta:
		name = "atexit"
		size = 24
		refs = "0006 _onexit"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 00 28 6F F0 00 00 18 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 136
		refs = "000a _set_app_type 000e _get_startup_file_mode 0012 _set_fmode 0016 _get_startup_commit_mode 001c __p__commode 0024 __scrt_initialize_onexit_tables 002a _RTC_Initialize 0030 atexit 0034 _get_startup_argv_mode 0038 _configure_wide_argv 003e ?__scrt_initialize_type_info@@YAXXZ 0042 __scrt_is_user_matherr_present 004a __setusermatherr 004e _initialize_invalid_parameter_handler 0052 _initialize_denormal_control 0056 _get_startup_thread_locale_mode 005a _configthreadlocale 005e _should_initialize_environment 0064 _initialize_wide_environment 0068 __scrt_initialize_winrt 0074 __scrt_fastfail 0080 _matherr 0084 _RTC_Terminate"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 02 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 04 60 01 20 ?? ?? ?? ?? 18 B3 ?? ?? ?? ?? 15 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 B9 ?? ?? ?? ?? ?? ?? ?? ?? 10 B1 0D 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 B1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 BD E8 18 88 07 20 ?? ?? ?? ?? 07 20 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 136
		refs = "000a _set_app_type 000e _get_startup_file_mode 0012 _set_fmode 0016 _get_startup_commit_mode 001c __p__commode 0024 __scrt_initialize_onexit_tables 002a _RTC_Initialize 0030 atexit 0034 _get_startup_argv_mode 0038 _configure_narrow_argv 003e ?__scrt_initialize_type_info@@YAXXZ 0042 __scrt_is_user_matherr_present 004a __setusermatherr 004e _initialize_invalid_parameter_handler 0052 _initialize_denormal_control 0056 _get_startup_thread_locale_mode 005a _configthreadlocale 005e _should_initialize_environment 0064 _initialize_narrow_environment 0068 __scrt_initialize_winrt 0074 __scrt_fastfail 0080 _matherr 0084 _RTC_Terminate"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 02 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 04 60 01 20 ?? ?? ?? ?? 18 B3 ?? ?? ?? ?? 15 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 B9 ?? ?? ?? ?? ?? ?? ?? ?? 10 B1 0D 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 B1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 BD E8 18 88 07 20 ?? ?? ?? ?? 07 20 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_3_3 {
	meta:
		name = "unexpected"
		size = 30
		refs = "0008 __vcrt_getptd 0012 _guard_check_icall 0018 terminate"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B ?? ?? ?? ?? 44 68 1C B1 20 46 ?? ?? ?? ?? A0 47 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_20_1_0 {
	meta:
		name = "?post_pgo_initialization@@YAHXZ"
		size = 16
		refs = "0006 __scrt_initialize_default_local_stdio_options"
		altNames = "?isPtrRef@DName@@QBAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_154_39_0 {
	meta:
		name = "??__E?sign_mask@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000c ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 001c ?sign_mask@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 00 61 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 260
		refs = "000c __scrt_initialize_crt 0014 __scrt_fastfail 001c __scrt_acquire_startup_lock 003a _initterm_e 004a _initterm 005a __scrt_release_startup_lock 005e __scrt_get_dyn_tls_init_callback 0068 __scrt_is_nonwritable_in_current_image 0072 _guard_check_icall 007e __scrt_get_dyn_tls_dtor_callback 0090 _register_thread_local_exe_atexit_callback 0094 __scrt_get_show_window_mode 009a _get_wide_winmain_command_line 00a6 wWinMain 00ac __scrt_is_managed_app 00b4 exit 00ba _cexit 00c2 __scrt_uninitialize_crt 00d4 _exit 00dc _c_exit 00ec __ImageBase 00f0 __xc_a 00f4 __xc_z 00f8 __xi_a 00fc __xi_z 0100 __scrt_current_native_startup_state"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 01 20 ?? ?? ?? ?? 10 B9 07 20 ?? ?? ?? ?? 00 25 3D 70 ?? ?? ?? ?? 06 46 37 4C 23 68 01 2B 02 D1 07 20 ?? ?? ?? ?? 83 B9 01 23 23 60 31 49 2F 48 ?? ?? ?? ?? 10 B1 FF 24 7C 60 4E E0 2B 49 29 48 ?? ?? ?? ?? 02 23 23 60 01 E0 01 25 3D 70 30 46 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 23 68 53 B1 ?? ?? ?? ?? 38 B1 24 68 20 46 ?? ?? ?? ?? 00 20 02 21 00 22 A0 47 ?? ?? ?? ?? 04 46 23 68 2B B1 ?? ?? ?? ?? 10 B1 20 68 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 02 46 12 48 23 46 00 21 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 10 B9 20 46 ?? ?? ?? ?? 0D B9 ?? ?? ?? ?? 00 21 01 20 ?? ?? ?? ?? 7C 60 0C E0 04 46 ?? ?? ?? ?? 10 B9 20 46 ?? ?? ?? ?? 3B 78 1B B9 ?? ?? ?? ?? 00 E0 7C 68 20 46 BD E8 FC 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 260
		refs = "000c __scrt_initialize_crt 0014 __scrt_fastfail 001c __scrt_acquire_startup_lock 003a _initterm_e 004a _initterm 005a __scrt_release_startup_lock 005e __scrt_get_dyn_tls_init_callback 0068 __scrt_is_nonwritable_in_current_image 0072 _guard_check_icall 007e __scrt_get_dyn_tls_dtor_callback 0090 _register_thread_local_exe_atexit_callback 0094 __scrt_get_show_window_mode 009a _get_narrow_winmain_command_line 00a6 WinMain 00ac __scrt_is_managed_app 00b4 exit 00ba _cexit 00c2 __scrt_uninitialize_crt 00d4 _exit 00dc _c_exit 00ec __ImageBase 00f0 __xc_a 00f4 __xc_z 00f8 __xi_a 00fc __xi_z 0100 __scrt_current_native_startup_state"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 01 20 ?? ?? ?? ?? 10 B9 07 20 ?? ?? ?? ?? 00 25 3D 70 ?? ?? ?? ?? 06 46 37 4C 23 68 01 2B 02 D1 07 20 ?? ?? ?? ?? 83 B9 01 23 23 60 31 49 2F 48 ?? ?? ?? ?? 10 B1 FF 24 7C 60 4E E0 2B 49 29 48 ?? ?? ?? ?? 02 23 23 60 01 E0 01 25 3D 70 30 46 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 23 68 53 B1 ?? ?? ?? ?? 38 B1 24 68 20 46 ?? ?? ?? ?? 00 20 02 21 00 22 A0 47 ?? ?? ?? ?? 04 46 23 68 2B B1 ?? ?? ?? ?? 10 B1 20 68 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 02 46 12 48 23 46 00 21 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 10 B9 20 46 ?? ?? ?? ?? 0D B9 ?? ?? ?? ?? 00 21 01 20 ?? ?? ?? ?? 7C 60 0C E0 04 46 ?? ?? ?? ?? 10 B9 20 46 ?? ?? ?? ?? 3B 78 1B B9 ?? ?? ?? ?? 00 E0 7C 68 20 46 BD E8 FC 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 40
		refs = "0008 __scrt_get_show_window_mode 000e _get_wide_winmain_command_line 001a wWinMain 0024 __ImageBase"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 02 46 03 48 23 46 00 21 ?? ?? ?? ?? BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 40
		refs = "0008 __scrt_get_show_window_mode 000e _get_narrow_winmain_command_line 001a WinMain 0024 __ImageBase"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 02 46 03 48 23 46 00 21 ?? ?? ?? ?? BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_1_0 {
	meta:
		name = "__scrt_get_show_window_mode"
		size = 52
		refs = "000e memset 0030 __imp_GetStartupInfoW"
	strings:
		$1 = { 2D E9 00 48 EB 46 92 B0 68 46 44 22 00 21 ?? ?? ?? ?? 07 4B 68 46 1B 68 98 47 0B 9B 13 F0 01 0F 02 D0 BD F8 30 00 00 E0 0A 20 12 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_3_0 {
	meta:
		name = "__scrt_is_managed_app"
		size = 80
		refs = "004c __imp_GetModuleHandleW"
	strings:
		$1 = { 2D E9 00 48 EB 46 11 4B 00 20 1B 68 98 47 08 B9 00 20 18 E0 02 88 45 F6 4D 23 9A 42 F8 D1 C3 6B 1A 58 19 18 44 F2 50 53 9A 42 F1 D1 0A 8B 40 F2 0B 13 9A 42 EC D1 4B 6F 0E 2B E9 D9 D1 F8 E8 30 00 2B E5 D0 01 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_5_0 {
	meta:
		name = "__scrt_unhandled_exception_filter"
		size = 80
		refs = "0036 terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 68 10 4B 0A 68 9A 42 0F D1 0B 69 04 2B 0C D1 4A 69 0B 4B 9A 42 0B D0 09 4B 9A 42 08 D0 06 4B 9A 42 05 D0 04 4B 9A 42 02 D0 00 20 BD E8 00 88 ?? ?? ?? ?? FE DE 00 40 99 01 22 05 93 19 21 05 93 19 20 05 93 19 63 73 6D E0 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "??__C@YAXPAX0IHP6AX00@ZP6AX0@Z@Z"
		size = 18
		refs = "000e ??__C@YAXPAX0IIP6AX00@ZP6AX0@Z@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_22_1 {
	meta:
		name = "??$_LStrcoll@D@std@@YAHPBD000PBU_Collvec@@@Z"
		size = 18
		refs = "000e _Strcoll"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_57_1 {
	meta:
		name = "??$_LStrcoll@_W@std@@YAHPB_W000PBU_Collvec@@@Z"
		size = 18
		refs = "000e _Wcscoll"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_23_1 {
	meta:
		name = "??$_LStrxfrm@D@std@@YAIPAD0PBD1PBU_Collvec@@@Z"
		size = 18
		refs = "000e _Strxfrm"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_59_1 {
	meta:
		name = "??$_LStrxfrm@_W@std@@YAIPA_W0PB_W1PBU_Collvec@@@Z"
		size = 18
		refs = "000e _Wcsxfrm"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "??_L@YAXPAXIHP6AX0@Z1@Z"
		size = 18
		refs = "000e ??_L@YAXPAXIIP6AX0@Z1@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "??_N@YAXPAXIHP6AX0@Z1@Z"
		size = 18
		refs = "000e ??_N@YAXPAXIIP6AX0@Z1@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "??__D@YAXPAX0IHP6AX00@ZP6AX0@Z@Z"
		size = 18
		refs = "000e ??__D@YAXPAX0IIP6AX00@ZP6AX0@Z@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_1_0 {
	meta:
		name = "??__C@YAXPAX0IIP6AX00@ZP6AX0@Z@Z"
		size = 94
		refs = "0028 _guard_check_icall 0052 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 FE 4F 0D F1 28 0B 6F 46 9A 46 91 46 BA 63 88 46 06 46 3E 63 00 24 7C 60 00 23 3B 70 3D 6C 54 45 0D D0 28 46 ?? ?? ?? ?? 30 46 41 46 A8 47 4E 44 3E 63 C8 44 C7 F8 34 80 64 1C 7C 60 EF E7 01 23 3B 70 3B 78 2B B9 7B 6C 7A 68 B9 6B 38 6B ?? ?? ?? ?? BD E8 FE 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_24_2_0 {
	meta:
		name = "?fin$0@?0???__C@YAXPAX0IIP6AX00@ZP6AX0@Z@Z@4HA"
		size = 20
		refs = "000e ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
		altNames = "?fin$0@?0???__D@YAXPAX0IIP6AX00@ZP6AX0@Z@Z@4HA"
	strings:
		$1 = { 10 B5 3B 78 2B B9 7B 6C 7A 68 B9 6B 38 6B ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__guard_check_icall_thunk"
		size = 20
		refs = "0004 __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 0F 50 ?? ?? ?? ?? C0 F2 00 01 09 68 88 47 BD E8 0F 90 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__rt_ursh"
		size = 58
	strings:
		$1 = { 00 2A 08 BF 70 47 20 2A 0C DB 40 2A 03 DB 4F EA 11 01 08 46 70 47 02 F0 1F 02 21 FA 02 F0 4F F0 00 01 70 47 20 FA 02 F0 C2 F1 20 03 01 FA 03 F3 40 EA 03 00 21 FA 02 F1 70 47 }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "??_L@YAXPAXIIP6AX0@Z1@Z"
		size = 84
		refs = "0026 _guard_check_icall 0048 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 FC 4B 0D F1 20 0B 6F 46 1E 46 90 46 89 46 F9 62 05 46 BD 62 00 24 7C 60 00 23 3B 70 44 45 09 D0 30 46 ?? ?? ?? ?? 28 46 B0 47 4D 44 BD 62 64 1C 7C 60 F3 E7 01 23 3B 70 3B 78 2B B9 BB 6B 7A 68 F9 6A B8 6A ?? ?? ?? ?? BD E8 FC 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "?fin$0@?0???_L@YAXPAXIIP6AX0@Z1@Z@4HA"
		size = 20
		refs = "000e ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
		altNames = "?fin$0@?0???_N@YAXPAXIIP6AX0@Z1@Z@4HA"
	strings:
		$1 = { 10 B5 3B 78 2B B9 BB 6B 7A 68 F9 6A B8 6A ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 30
		refs = "0012 ??2@YAPAXI@Z"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 ?? ?? ?? ?? 00 E0 00 20 BD E8 8E 88 }
	condition:
		$1
}

rule file_43_97_2 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAA@XZ"
		size = 36
		refs = "0016 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0020 ??_7ios_base@std@@6B@"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 03 4B 03 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_119_1 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 36
		refs = "0016 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0020 ??_7ios_base@std@@6B@"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 03 4B 03 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_96_2 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 36
		refs = "0016 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0020 ??_7ios_base@std@@6B@"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 03 4B 03 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_117_2 {
	meta:
		name = "??1ios_base@std@@UAA@XZ"
		size = 36
		refs = "0016 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0020 ??_7ios_base@std@@6B@"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 03 4B 03 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z"
		size = 20
		refs = "0010 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_44_1 {
	meta:
		name = "?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ"
		size = 20
		refs = "0010 global_locale"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z"
		size = 20
		refs = "0010 ?_RTC_ErrorReportFuncW@@3P6AHHPB_WH00ZZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "_RTC_GetErrDesc"
		size = 28
		refs = "0018 ?_RTC_errlist@@3QBQBDB"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 28 03 D8 03 4B 53 F8 20 00 00 E0 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_4_0 {
	meta:
		name = "_RTC_SetErrorFunc"
		size = 28
		refs = "0018 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4A 03 46 10 68 13 60 00 23 53 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_5_0 {
	meta:
		name = "_RTC_SetErrorFuncW"
		size = 28
		refs = "0018 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4A 03 46 50 68 53 60 00 23 13 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_6_0 {
	meta:
		name = "_RTC_SetErrorType"
		size = 36
		refs = "0020 ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 46 04 2A 05 D8 04 4B 53 F8 20 00 43 F8 22 10 01 E0 6F F0 00 00 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__vdecl_fmodf4"
		size = 142
		refs = "0022 fmodf"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 08 8B 22 EF 52 81 18 EE 10 3B 20 EF 50 A1 00 EE 90 3A 1A EE 10 3B 00 EE 10 3A ?? ?? ?? ?? 10 EE 10 3A 0A EE 10 3B 38 EE 10 3B 00 EE 90 3A 3A EE 10 3B 00 EE 10 3A ?? ?? ?? ?? 10 EE 10 3A 2A EE 10 3B 19 EE 10 3B 00 EE 90 3A 1B EE 10 3B 00 EE 10 3A ?? ?? ?? ?? 10 EE 10 3A 0B EE 10 3B 39 EE 10 3B 00 EE 90 3A 3B EE 10 3B 00 EE 10 3A ?? ?? ?? ?? 10 EE 10 3A 2B EE 10 3B 2A EF 5A 01 BD EC 08 8B BD E8 00 88 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__scrt_get_dyn_tls_init_callback"
		size = 16
		refs = "000c __dyn_tls_init_callback"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_85_2 {
	meta:
		name = "?_BadAllocException@__ExceptionPtr@@SAABV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 16
		refs = "000c ?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_604_2 {
	meta:
		name = "?_Getfalse@_Locinfo@std@@QBAPBDXZ"
		size = 16
		refs = "000c ??_C@_05LAPONLG@false?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_213_1 {
	meta:
		name = "?_Gettrue@_Locinfo@std@@QBAPBDXZ"
		size = 16
		refs = "000c ??_C@_04LOAJBDKD@true?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_116_1 {
	meta:
		name = "?_Init_cnt_func@Init@ios_base@std@@CAAAHXZ"
		size = 16
		refs = "000c ?_Init_cnt@Init@ios_base@std@@0HA"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_165_2 {
	meta:
		name = "?name@_Generic_error_category@std@@UBAPBDXZ"
		size = 16
		refs = "000c ??_C@_07DCLBNMLN@generic?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_362_1 {
	meta:
		name = "?name@_Iostream_error_category@std@@UBAPBDXZ"
		size = 16
		refs = "000c ??_C@_08LLGCOLLL@iostream?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_194_1 {
	meta:
		name = "?name@_System_error_category@std@@UBAPBDXZ"
		size = 16
		refs = "000c ??_C@_06FHFOAHML@system?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_51_2 {
	meta:
		name = "?what@bad_function_call@std@@UBAPBDXZ"
		size = 16
		refs = "000c ??_C@_0BC@DPJNKNAF@bad?5function?5call?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_467_2 {
	meta:
		name = "__local_stdio_printf_options"
		size = 16
		refs = "000c ?_OptionsStorage@?1??__local_stdio_printf_options@@9@4_KA"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_1_6 {
	meta:
		name = "__local_stdio_scanf_options"
		size = 16
		refs = "000c ?_OptionsStorage@?1??__local_stdio_scanf_options@@9@4_KA"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_0_6 {
	meta:
		name = "__scrt_get_dyn_tls_dtor_callback"
		size = 16
		refs = "000c __dyn_tls_dtor_callback"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__dyn_tls_dtor"
		size = 104
		refs = "0038 _guard_check_icall 004c _free_base 0060 dtor_list 0064 _tls_index"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 03 29 00 D0 29 BB 15 4B 1A 68 1D EE 50 3F DB 6A DF F8 44 90 53 F8 22 80 58 F8 09 50 CD B1 2B 68 5C 1E 00 2C 0B DB 05 EB 84 06 B7 68 1F B1 38 46 ?? ?? ?? ?? B8 47 64 1E 36 1F 00 2C F5 DA 6C 68 14 B1 28 46 ?? ?? ?? ?? 48 F8 09 40 25 46 00 2C E5 D1 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "??$?RUTlsDtorNode@@@__crt_internal_free_policy@@QBAXQBUTlsDtorNode@@@Z"
		size = 16
		refs = "000c _free_base"
		altNames = "??$?RD@__crt_internal_free_policy@@QBAXQBD@Z ??$?RU__vcrt_ptd@@@__crt_internal_free_policy@@QBAXQBU__vcrt_ptd@@@Z ??$?RX@__crt_internal_free_policy@@QBAXQBX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_0_3 {
	meta:
		name = "??$?RD@__crt_public_free_policy@@QBAXQBD@Z"
		size = 16
		refs = "000c free"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_171_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPADI@Z"
		size = 16
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_895_2 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAXPAGI@Z"
		size = 16
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_305_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAAXPAU_Container_proxy@2@I@Z"
		size = 16
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_81_2 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAXPA_WI@Z"
		size = 16
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_897_2 {
	meta:
		name = "?deallocate@?$allocator@D@std@@QAAXPADI@Z"
		size = 16
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_981_1 {
	meta:
		name = "?deallocate@?$allocator@G@std@@QAAXPAGI@Z"
		size = 16
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_307_1 {
	meta:
		name = "?deallocate@?$allocator@U_Container_proxy@std@@@std@@QAAXPAU_Container_proxy@2@I@Z"
		size = 16
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_56_2 {
	meta:
		name = "?deallocate@?$allocator@_W@std@@QAAXPA_WI@Z"
		size = 16
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_3_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAA@XZ"
		size = 24
		refs = "000c _free_base"
		altNames = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAA@XZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_33_60_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@XZ"
		size = 24
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_17_333_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@XZ"
		size = 24
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_35_34_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@XZ"
		size = 24
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_1_2_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAA@XZ"
		size = 24
		refs = "000c free"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_99_257_1 {
	meta:
		name = "?_Free_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAXXZ"
		size = 24
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_17_565_1 {
	meta:
		name = "?_Free_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAXXZ"
		size = 24
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_79_75_1 {
	meta:
		name = "?_Free_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAXXZ"
		size = 24
		refs = "000c ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_1_7_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAAXXZ"
		size = 24
		refs = "000c free"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_51_4_0 {
	meta:
		name = "?detach@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAAPAUTlsDtorNode@@XZ"
		size = 18
		altNames = "?detach@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAAPADXZ ?detach@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAAPAU__vcrt_ptd@@XZ ?detach@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAAPAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 18 68 00 22 1A 60 BD E8 00 88 }
	condition:
		$1
}

rule file_51_6_0 {
	meta:
		name = "__tlregdtor"
		size = 116
		refs = "0032 _malloc_base 003a _free_base 0068 dtor_list_head 006c dtor_list 0070 _tls_index"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 19 4B 07 46 1A 68 1D EE 50 3F DB 6A 15 4E 53 F8 22 40 A3 59 2B B9 12 4B 23 44 00 22 1A 60 A3 51 12 E0 1B 68 1E 2B 0F D1 80 20 ?? ?? ?? ?? 05 46 00 20 ?? ?? ?? ?? 15 B9 6F F0 00 00 0D E0 A3 59 A5 51 6B 60 00 23 2B 60 A2 59 13 68 02 EB 83 03 9F 60 13 68 5B 1C 13 60 00 20 BD E8 F0 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_2_0 {
	meta:
		name = "??__E?exponentBias@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?exponentBias@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 7E 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_6_0 {
	meta:
		name = "??__E?ind@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?ind@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 C0 FF }
	condition:
		$1
}

rule file_53_10_0 {
	meta:
		name = "??__E?neginf@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?neginf@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 80 FF }
	condition:
		$1
}

rule file_53_13_0 {
	meta:
		name = "??__E?notExponentMask@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 36
		refs = "000c ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 001c ?notExponentMask@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 49 6F F0 00 00 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? FF FF 0F 80 }
	condition:
		$1
}

rule file_53_36_0 {
	meta:
		name = "?A@?$VASin@M@@CA?AT__n128@@T2@@Z"
		size = 84
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 87 B0 00 23 00 93 10 4B 10 EE 10 2B 30 EE 10 1B 01 93 6B 46 11 EE 10 0B 53 F8 22 30 31 EE 10 4B 02 93 6B 46 53 F8 21 30 03 93 6B 46 53 F8 20 30 04 93 6B 46 53 F8 24 30 05 93 0D F1 08 0C 9C EC 04 0B 07 B0 BD E8 10 88 DA 0F 49 3F }
	condition:
		$1
}

rule file_53_37_0 {
	meta:
		name = "?B@?$VASin@M@@CA?AT__n128@@T2@@Z"
		size = 88
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 87 B0 12 4B 10 EE 10 2B 30 EE 10 1B 00 93 0E 4B 11 EE 10 0B 31 EE 10 4B 01 93 6B 46 53 F8 22 30 02 93 6B 46 53 F8 21 30 03 93 6B 46 53 F8 20 30 04 93 6B 46 53 F8 24 30 05 93 0D F1 08 0C 9C EC 04 0B 07 B0 BD E8 10 88 DA 0F 49 3F DA 0F C9 3F }
	condition:
		$1
}

rule file_53_40_0 {
	meta:
		name = "?acos@?$VASin@M@@SA?AT__n128@@T2@@Z"
		size = 512
		refs = "001e ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0030 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 01dc ?ind@?$VectorOp@M@@2T__n128@@B 01e4 ?eps@?$VASin@M@@0T__n128@@B 01e8 ?q0@?$VASin@M@@0T__n128@@B 01ec ?q1@?$VASin@M@@0T__n128@@B 01f0 ?p1@?$VASin@M@@0T__n128@@B 01f8 ?p2@?$VASin@M@@0T__n128@@B"
		altNames = "__vdecl_acosf4"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 10 8B 94 B0 20 EF 50 E1 9F ED 7A 0A 0D F1 40 0C 8C EC 04 EB ?? ?? ?? ?? 60 EF 50 01 01 20 0D F1 30 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A ?? ?? ?? ?? 20 EF 50 C1 B7 EE 00 0A 8D ED 00 0A ?? ?? ?? ?? 01 20 20 EF 50 81 B9 FF 4E E7 ?? ?? ?? ?? 6E FF 4C AE 60 FF 4A 08 6A EF FA C1 50 FF DA C1 68 EF 4E 0D 61 4B 4E FF 5E 2D 5E 4A 40 FF DC 0D 6A EF FA 81 50 FF F2 81 03 92 1C EE 90 1B FB FF E8 25 3C EE 90 0B 42 FF F2 0D 1D EE 90 4B 68 EF F0 0F 3D EE 90 5B 42 FF F0 2D 42 FF F2 0D 68 EF F0 0F 42 FF F0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D F9 FF E0 07 40 EF E0 0D 50 FF DE A1 D3 EC 04 0B 45 4B 40 FF F8 2D D3 EC 04 0B 42 4B 42 EF E0 0D 40 FF F8 6D D3 EC 04 0B 3D 4B 48 EF E0 0D 40 FF F8 2D D3 EC 04 0B 39 4B 42 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4A FF F0 0D 4A EF E0 2D D3 EC 04 0B 2D 4B 60 FF CE 6E 02 93 02 AB 53 F8 21 30 5A FF F2 61 04 93 02 AB 53 F8 20 30 0D F1 40 0C 9C EC 04 AB 9D ED 00 0A 05 93 02 AB 53 F8 24 30 06 93 02 AB 53 F8 25 30 03 92 07 93 00 23 02 93 02 AB 53 F8 21 30 0D F1 10 0C DC EC 04 2B 08 93 02 AB 53 F8 20 30 42 EF E6 0D 09 93 02 AB 53 F8 24 30 40 EF E2 4D 0A 93 02 AB 53 F8 25 30 0B 93 0D F1 20 0C DC EC 04 2B 62 EF E6 0D 40 EF E2 0D 0D F1 30 0C DC EC 04 2B 22 FF CA 8E 14 FF F0 81 ?? ?? ?? ?? 08 4B 6A FF 50 2E 0A EF 4A 0E D3 EC 04 0B 50 FF D8 21 12 FF DA 01 14 B0 BD EC 10 8B BD E8 30 88 FE DE ?? ?? ?? ?? DA 0F C9 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DA 0F 49 3F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_53_42_0 {
	meta:
		name = "?asin@?$VASin@M@@SA?AT__n128@@T2@@Z"
		size = 456
		refs = "001e ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0030 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 01a8 ?ind@?$VectorOp@M@@2T__n128@@B 01b0 ?eps@?$VASin@M@@0T__n128@@B 01b4 ?q0@?$VASin@M@@0T__n128@@B 01b8 ?q1@?$VASin@M@@0T__n128@@B 01bc ?p1@?$VASin@M@@0T__n128@@B 01c0 ?p2@?$VASin@M@@0T__n128@@B"
		altNames = "__vdecl_asinf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 91 B0 20 EF 50 E1 9F ED 6C 0A 0D F1 30 0C 8C EC 04 EB ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 20 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A ?? ?? ?? ?? 20 EF 50 C1 B7 EE 00 0A 8D ED 00 0A ?? ?? ?? ?? 01 20 20 EF 50 81 B9 FF 4E E7 ?? ?? ?? ?? 6E FF 4C AE 60 FF 4A 08 6A EF FA C1 50 FF DA C1 68 EF 4E 0D 53 4B 4E FF 5E 2D 40 FF DC 0D 6A EF FA 81 50 FF F2 81 1C EE 90 2B FB FF E8 25 3C EE 90 1B 42 FF F2 0D 1D EE 90 0B 68 EF F0 0F 3D EE 90 4B 42 FF F0 2D 42 FF F2 0D 68 EF F0 0F 42 FF F0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D F9 FF E0 07 40 EF E0 0D 50 FF DE A1 D3 EC 04 0B 39 4B 40 FF F8 2D D3 EC 04 0B 36 4B 42 EF E0 0D 40 FF F8 6D D3 EC 04 0B 31 4B 48 EF E0 0D 40 FF F8 2D D3 EC 04 0B 2D 4B 42 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4A FF F0 0D 4A EF E0 2D D3 EC 04 0B 00 23 02 93 20 4B 60 FF CE 0E 03 93 02 AB 53 F8 22 30 5A FF F2 01 04 93 02 AB 53 F8 21 30 0D F1 20 0C DC EC 04 4B 0D F1 30 0C 9C EC 04 AB 05 93 02 AB 53 F8 20 30 9D ED 00 0A 24 FF CA 8E 06 93 02 AB 53 F8 24 30 07 93 0D F1 10 0C DC EC 04 2B 42 EF E0 0D 40 EF E2 2D F9 FF E2 07 10 FF F2 81 ?? ?? ?? ?? 07 4B 6A FF 50 2E 0A EF 4A 0E D3 EC 04 0B 50 FF D8 21 12 FF DA 01 11 B0 BD EC 10 8B BD E8 10 88 ?? ?? ?? ?? DA 0F 49 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_53_43_0 {
	meta:
		name = "?asin_check_special_case@?$VASin@M@@CA?AT__n128@@T2@T2@@Z"
		size = 60
		refs = "0016 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0038 ?ind@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 08 8B 20 EF 50 A1 B7 EE 00 0A 22 EF 52 81 ?? ?? ?? ?? 07 4B 6A FF 50 2E 0A EF 4A 0E D3 EC 04 0B 50 FF D8 21 12 FF DA 01 BD EC 08 8B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_44_0 {
	meta:
		name = "?asin_impl@?$VASin@M@@CA?AT__n128@@T2@AAT2@@Z"
		size = 280
		refs = "0016 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0034 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0104 ?eps@?$VASin@M@@0T__n128@@B 0108 ?q0@?$VASin@M@@0T__n128@@B 010c ?q1@?$VASin@M@@0T__n128@@B 0110 ?p1@?$VASin@M@@0T__n128@@B 0114 ?p2@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 2D ED 10 8B 20 EF 50 81 B6 EE 00 0A 04 46 ?? ?? ?? ?? 20 EF 50 C1 B7 EE 00 0A ?? ?? ?? ?? B9 FF 48 87 01 20 28 FF 4C EE 20 EF 50 A1 ?? ?? ?? ?? 6E EF 5E 21 D4 EC 04 4B 6E EF 5E 81 60 FF 64 08 32 4B 50 FF F4 21 6A EF 48 0D C4 EC 04 2B 48 FF 58 2D 40 FF DC 0D 50 FF F2 81 FB FF E8 25 42 FF F2 0D 68 EF F0 0F 42 FF F0 2D 42 FF F2 0D 68 EF F0 0F 42 FF F0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D F9 FF E0 07 40 EF E0 0D 10 FF D8 E1 D3 EC 04 0B 1B 4B 40 FF F8 2D D3 EC 04 0B 17 4B 42 EF E0 0D 40 FF F8 6D D3 EC 04 0B 13 4B 48 EF E0 0D 40 FF F8 2D D3 EC 04 0B 0E 4B 42 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4E FF 70 0D 4E EF 60 2D D3 EC 04 0B 20 FF C8 0E 1E FF 72 01 BD EC 10 8B BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_49_0 {
	meta:
		name = "?create@?$VectorOp@M@@SA?AT__n128@@I@Z"
		size = 42
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 A0 EE 10 0B 87 EC 04 0B 06 E0 97 EC 04 0B 03 E0 07 F1 10 0C 9C EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_53_50_0 {
	meta:
		name = "?filt$0@?0??create@?$VectorOp@M@@SA?AT__n128@@I@Z@4HA"
		size = 24
		altNames = "?filt$0@?0??create@?$VectorOp@M@@SA?AT__n128@@M@Z@4HA ?filt$0@?0??create@?$VectorOp@N@@SA?AT__n128@@I@Z@4HA ?filt$0@?0??create@?$VectorOp@N@@SA?AT__n128@@N@Z@4HA ?filt$0@?0??create@?$VectorOp@N@@SA?AT__n128@@_K@Z@4HA"
	strings:
		$1 = { 03 68 1A 68 03 4B 9A 42 01 D1 01 20 00 E0 00 20 70 47 FE DE 1D 00 00 C0 }
	condition:
		$1
}

rule file_53_51_0 {
	meta:
		name = "?create@?$VectorOp@M@@SA?AT__n128@@IIII@Z"
		size = 24
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B CD E9 00 01 CD E9 02 23 9D EC 04 0B BD E8 0F 88 }
	condition:
		$1
}

rule file_53_52_0 {
	meta:
		name = "?create@?$VectorOp@M@@SA?AT__n128@@M@Z"
		size = 42
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 B4 FF 40 0C 87 EC 04 0B 06 E0 97 EC 04 0B 03 E0 07 F1 10 0C 9C EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_53_54_0 {
	meta:
		name = "?create@?$VectorOp@N@@SA?AT__n128@@I@Z"
		size = 48
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 00 23 43 EC 10 0B 20 EF 10 11 87 EC 04 0B 06 E0 97 EC 04 0B 03 E0 07 F1 10 0C 9C EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_53_56_0 {
	meta:
		name = "?create@?$VectorOp@N@@SA?AT__n128@@N@Z"
		size = 58
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 87 ED 00 0B 7A 68 3B 68 42 EC 10 3B 20 EF 10 11 07 F1 10 0C 8C EC 04 0B 06 E0 07 F1 10 0C 9C EC 04 0B 01 E0 97 EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_53_58_0 {
	meta:
		name = "?create@?$VectorOp@N@@SA?AT__n128@@_K@Z"
		size = 46
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 41 EC 10 0B 20 EF 10 11 87 EC 04 0B 06 E0 97 EC 04 0B 03 E0 07 F1 10 0C 9C EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_53_60_0 {
	meta:
		name = "?div@?$VectorOp@M@@SA?AT__n128@@T2@0@Z"
		size = 34
	strings:
		$1 = { 2D E9 00 48 EB 46 FB FF 42 25 42 EF 72 0F 42 FF F0 2D 42 EF 72 0F 42 FF F0 0D 00 FF 70 0D BD E8 00 88 }
	condition:
		$1
}

rule file_53_64_0 {
	meta:
		name = "?recip@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 FB FF 40 25 40 EF 72 0F 42 FF F0 2D 40 EF 72 0F 02 FF F0 0D BD E8 00 88 }
	condition:
		$1
}

rule file_53_65_0 {
	meta:
		name = "?sqrt@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 58
	strings:
		$1 = { 2D E9 00 48 EB 46 FB FF C0 25 42 FF F2 0D 60 EF 70 0F 42 FF F0 2D 42 FF F2 0D 60 EF 70 0F 42 FF F0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 02 FF F0 0D BD E8 00 88 }
	condition:
		$1
}

rule file_53_67_0 {
	meta:
		name = "?unpack@?$VectorOp@M@@SAXT__n128@@AAI111@Z"
		size = 36
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 10 EE 10 4B 04 60 30 EE 10 0B 08 60 11 EE 10 1B 11 60 31 EE 10 2B 1A 60 BD E8 18 88 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__rt_udiv"
		size = 360
		refs = "001e _lc009_002361_"
	strings:
		$1 = { 80 B1 02 46 B0 FA 80 F0 B1 FA 81 F3 C0 1A 0F F2 4D 13 A3 EB C0 03 A3 EB 40 03 4F F0 00 00 ?? ?? ?? ?? 18 47 F9 DE B1 EB C2 73 28 BF 19 46 40 41 B1 EB 82 73 28 BF 19 46 40 41 B1 EB 42 73 28 BF 19 46 40 41 B1 EB 02 73 28 BF 19 46 40 41 B1 EB C2 63 28 BF 19 46 40 41 B1 EB 82 63 28 BF 19 46 40 41 B1 EB 42 63 28 BF 19 46 40 41 B1 EB 02 63 28 BF 19 46 40 41 B1 EB C2 53 28 BF 19 46 40 41 B1 EB 82 53 28 BF 19 46 40 41 B1 EB 42 53 28 BF 19 46 40 41 B1 EB 02 53 28 BF 19 46 40 41 B1 EB C2 43 28 BF 19 46 40 41 B1 EB 82 43 28 BF 19 46 40 41 B1 EB 42 43 28 BF 19 46 40 41 B1 EB 02 43 28 BF 19 46 40 41 B1 EB C2 33 28 BF 19 46 40 41 B1 EB 82 33 28 BF 19 46 40 41 B1 EB 42 33 28 BF 19 46 40 41 B1 EB 02 33 28 BF 19 46 40 41 B1 EB C2 23 28 BF 19 46 40 41 B1 EB 82 23 28 BF 19 46 40 41 B1 EB 42 23 28 BF 19 46 40 41 B1 EB 02 23 28 BF 19 46 40 41 B1 EB C2 13 28 BF 19 46 40 41 B1 EB 82 13 28 BF 19 46 40 41 B1 EB 42 13 28 BF 19 46 40 41 B1 EB 02 13 28 BF 19 46 40 41 B1 EB C2 03 28 BF 19 46 40 41 B1 EB 82 03 28 BF 19 46 40 41 B1 EB 42 03 28 BF 19 46 40 41 8B 1A 28 BF 19 46 40 41 70 47 00 00 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "__rt_sdiv"
		size = 388
		refs = "002e _lc009_002745_"
	strings:
		$1 = { 10 F0 00 43 48 BF 40 42 93 EA 21 0C 28 BF 49 42 80 B1 02 46 B0 FA 80 F0 B1 FA 81 F3 C0 1A 0F F2 4D 13 A3 EB C0 03 A3 EB 40 03 4F F0 00 00 ?? ?? ?? ?? 18 47 F9 DE B1 EB C2 73 28 BF 19 46 40 41 B1 EB 82 73 28 BF 19 46 40 41 B1 EB 42 73 28 BF 19 46 40 41 B1 EB 02 73 28 BF 19 46 40 41 B1 EB C2 63 28 BF 19 46 40 41 B1 EB 82 63 28 BF 19 46 40 41 B1 EB 42 63 28 BF 19 46 40 41 B1 EB 02 63 28 BF 19 46 40 41 B1 EB C2 53 28 BF 19 46 40 41 B1 EB 82 53 28 BF 19 46 40 41 B1 EB 42 53 28 BF 19 46 40 41 B1 EB 02 53 28 BF 19 46 40 41 B1 EB C2 43 28 BF 19 46 40 41 B1 EB 82 43 28 BF 19 46 40 41 B1 EB 42 43 28 BF 19 46 40 41 B1 EB 02 43 28 BF 19 46 40 41 B1 EB C2 33 28 BF 19 46 40 41 B1 EB 82 33 28 BF 19 46 40 41 B1 EB 42 33 28 BF 19 46 40 41 B1 EB 02 33 28 BF 19 46 40 41 B1 EB C2 23 28 BF 19 46 40 41 B1 EB 82 23 28 BF 19 46 40 41 B1 EB 42 23 28 BF 19 46 40 41 B1 EB 02 23 28 BF 19 46 40 41 B1 EB C2 13 28 BF 19 46 40 41 B1 EB 82 13 28 BF 19 46 40 41 B1 EB 42 13 28 BF 19 46 40 41 B1 EB 02 13 28 BF 19 46 40 41 B1 EB C2 03 28 BF 19 46 40 41 B1 EB 82 03 28 BF 19 46 40 41 B1 EB 42 03 28 BF 19 46 40 41 8B 1A 28 BF 19 46 40 41 5F EA 4C 0C 28 BF 40 42 48 BF 49 42 70 47 00 00 }
	condition:
		$1
}

rule file_54_2_0 {
	meta:
		name = "__rt_udiv64"
		size = 160
		refs = "008a __rt_udiv"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 50 EA 01 04 26 D0 51 EA 03 04 39 D0 06 46 8C 46 B3 FA 83 F1 13 B9 B2 FA 82 F1 20 31 BC F1 00 0F BC FA 8C F0 02 D1 B6 FA 86 F0 20 30 40 1A 2E DB 20 28 65 46 34 46 01 D3 35 46 00 24 10 F0 1F 00 85 40 D0 F1 20 01 34 FA 01 F1 84 40 0D 43 00 20 00 21 06 E0 F9 DE 64 08 00 18 44 EA C5 74 49 41 6D 08 9D 42 07 D8 01 D3 94 42 04 D8 12 1B AB 41 40 1C 51 F1 00 01 B4 42 ED D1 65 45 EB D1 08 E0 11 46 ?? ?? ?? ?? 0A 46 00 21 00 23 01 E0 00 21 00 20 BD E8 F0 88 00 00 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__GSHandlerCheck"
		size = 36
		refs = "001a __security_check_cookie"
	strings:
		$1 = { 2D E9 00 48 EB 46 DB 69 1B 68 23 F0 03 02 50 58 13 F0 01 0F 01 D0 13 1A 58 18 ?? ?? ?? ?? 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "__GSHandlerCheckCommon"
		size = 34
		refs = "001e __security_check_cookie"
	strings:
		$1 = { 2D E9 00 48 EB 46 13 68 01 46 23 F0 03 02 50 58 13 F0 01 0F 01 D0 13 1A 58 18 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_53_0 {
	meta:
		name = "?signof@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 34
		refs = "0012 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 4F F0 00 40 20 EF 50 81 ?? ?? ?? ?? 00 EF 58 01 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_63_55_0 {
	meta:
		name = "?tanh@?$VTanh@M@@SA?AT__n128@@T2@@Z"
		size = 336
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0054 __vdecl_expf4 00fe ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0130 ?inf@?$VectorOp@M@@2T__n128@@B 0134 ?eps@?$VTanh@M@@0T__n128@@B 0138 ?xbig@?$VTanh@M@@0T__n128@@B 013c ?q0@?$VTanh@M@@0T__n128@@B 0140 ?p0@?$VTanh@M@@0T__n128@@B 0144 ?p1@?$VTanh@M@@0T__n128@@B"
		altNames = "__vdecl_tanhf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 88 B0 20 EF 50 E1 9F ED 4E 0A 0D F1 10 0C 8C EC 04 EB ?? ?? ?? ?? 20 EF 50 C1 B7 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 B6 EE 00 0A CD EC 04 0B ?? ?? ?? ?? 20 EF 50 81 9F ED 41 0A ?? ?? ?? ?? B9 FF 4E E7 20 EF 50 A1 0E EF 4E 0D ?? ?? ?? ?? DD EC 04 AB 39 4B 4F F0 00 40 40 EF 6A 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 4E FF 5E 4D 42 FF F0 0D 68 EF 60 0D 40 EF E0 8D D3 EC 04 0B 2D 4B 40 FF F4 2D D3 EC 04 0B 29 4B 42 EF E0 0D 40 FF F4 6D D3 EC 04 0B 25 4B 44 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 6E FF 4A 2E 46 FF F0 0D 0D F1 10 0C 9C EC 04 AB 2C FF 4A 8E 4E FF 70 0D 4E EF 60 0D 58 FF F0 21 D3 EC 04 0B 14 4B 6E FF 60 4E D3 EC 04 0B 5A FF F2 41 60 FF CE 2E 5E FF 74 21 F9 FF E2 07 10 FF F2 81 ?? ?? ?? ?? DD EC 04 2B 0A 4B 40 EF 5A 01 0A EF 4A 0E 60 EF F2 21 D3 EC 04 0B 4E EF 60 0E 52 FF D8 01 10 FF DA 01 08 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 54 9F 0C 3F 00 00 00 00 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__scrt_is_ucrt_dll_in_use"
		size = 28
		refs = "0018 __scrt_ucrt_dll_is_in_use"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 0B B1 01 20 00 E0 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "_RTC_AllocaHelper"
		size = 44
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 70 B1 69 B1 62 B1 39 B1 CC 25 03 46 21 B1 44 18 03 F8 01 5B A3 42 FB D1 13 68 C1 60 43 60 10 60 BD E8 30 88 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "_RTC_CheckStackVars"
		size = 78
		refs = "003c ?_RTC_StackFailure@@YAXPAXPBD@Z"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0E 46 33 68 00 24 80 46 00 2B 1A DD 00 25 6F F0 33 37 73 68 E9 58 EA 18 01 EB 08 03 53 F8 04 3C BB 42 05 D1 53 68 0B 44 53 F8 08 30 BB 42 03 D0 91 68 07 98 ?? ?? ?? ?? 33 68 64 1C 0C 35 9C 42 E7 DB BD E8 F8 89 }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "_RTC_CheckStackVars2"
		size = 166
		refs = "0042 ?_RTC_StackFailure@@YAXPAXPBD@Z 0080 ?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 0D 46 14 46 81 46 6F F0 33 36 F5 B1 2B 68 00 27 00 2B 1A DD B8 46 6B 68 08 EB 03 02 11 68 01 EB 09 03 53 F8 04 3C B3 42 05 D1 53 68 0B 44 53 F8 09 30 B3 42 03 D0 91 68 07 98 ?? ?? ?? ?? 2B 68 7F 1C 08 F1 0C 08 9F 42 E5 DB 00 25 23 46 24 B3 5B 68 6D 1C 00 2B FB D1 1D E0 23 68 B3 42 08 D1 63 69 B3 42 05 D1 A3 69 B3 42 02 D1 E3 69 B3 42 04 D0 07 98 2A 46 21 46 ?? ?? ?? ?? E3 68 23 44 53 F8 04 3C B3 42 04 D0 07 98 2A 46 21 46 ?? ?? ?? ?? 64 68 6D 1E 00 2C DF D1 BD E8 F0 8B }
	condition:
		$1
}

rule file_72_2_0 {
	meta:
		name = "__scrt_initialize_default_local_stdio_options"
		size = 42
		refs = "0006 __local_stdio_printf_options 0016 __local_stdio_scanf_options"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? D0 E9 00 32 43 F0 04 03 C0 E9 00 32 ?? ?? ?? ?? D0 E9 00 32 43 F0 02 03 C0 E9 00 32 BD E8 00 88 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__GSHandlerCheck_SEH"
		size = 64
		refs = "002c __GSHandlerCheckCommon 0038 __C_specific_handler"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 1E 46 F3 69 90 46 0F 46 1C 68 81 46 00 2C 03 DA 24 F0 00 45 74 68 2B 19 1C 68 31 46 38 46 03 EB 04 14 22 1D ?? ?? ?? ?? 33 46 42 46 39 46 48 46 ?? ?? ?? ?? BD E8 F0 8B }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "??$cosh_impl@$00@?$VSinh@M@@CA?AT__n128@@T1@@Z"
		size = 168
		refs = "0026 __vdecl_expf4 0046 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0094 ?inf@?$VectorOp@M@@2T__n128@@B 0098 ?wmax@?$VSinh@M@@0T__n128@@B 009c ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B 00a0 ?ln_v@?$VSinh@M@@0T__n128@@B 00a4 ?ybar@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 26 4B 20 EF 50 81 D3 EC 04 0B 22 4B 28 FF 60 EE D3 EC 04 0B 28 EF 60 CD 2C EF 5C 01 ?? ?? ?? ?? 1C 4B D3 EC 04 0B 40 FF D0 0D 00 EF 60 AD 28 EF 58 01 ?? ?? ?? ?? 01 20 20 EF 50 81 ?? ?? ?? ?? FB FF 48 25 12 4B 48 EF 72 0F 42 FF F0 2D 48 EF 72 0F 42 FF F0 0D 48 EF 60 2D F7 EF 50 05 62 FF E0 08 6E EF 5E 21 5A FF 70 21 D3 EC 04 0B 06 4B 6C FF 60 0E 0E EF 70 01 D3 EC 04 0B 10 FF F2 01 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "??$cosh_impl@$0A@@?$VSinh@M@@CA?AT__n128@@T1@@Z"
		size = 168
		refs = "0026 __vdecl_expf4 0046 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0094 ?inf@?$VectorOp@M@@2T__n128@@B 0098 ?wmax@?$VSinh@M@@0T__n128@@B 009c ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B 00a0 ?ln_v@?$VSinh@M@@0T__n128@@B 00a4 ?ybar@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 26 4B 20 EF 50 81 D3 EC 04 0B 22 4B 28 FF 60 EE D3 EC 04 0B 28 EF 60 CD 2C EF 5C 01 ?? ?? ?? ?? 1C 4B D3 EC 04 0B 40 FF D0 0D 00 EF 60 AD 28 EF 58 01 ?? ?? ?? ?? 01 20 20 EF 50 81 ?? ?? ?? ?? FB FF 48 25 12 4B 48 EF 72 0F 42 FF F0 2D 48 EF 72 0F 42 FF F0 0D 68 EF 60 2D F7 EF 50 05 62 FF E0 08 6E EF 5E 21 5A FF 70 21 D3 EC 04 0B 06 4B 6C FF 60 0E 0E EF 70 01 D3 EC 04 0B 10 FF F2 01 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_13_0 {
	meta:
		name = "??__E?ln_v@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?ln_v@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 73 31 3F }
	condition:
		$1
}

rule file_81_50_0 {
	meta:
		name = "?cosh@?$VSinh@M@@SA?AT__n128@@T2@@Z"
		size = 204
		refs = "0030 __vdecl_expf4 0050 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 00b8 ?inf@?$VectorOp@M@@2T__n128@@B 00bc ?wmax@?$VSinh@M@@0T__n128@@B 00c0 ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B 00c4 ?ln_v@?$VSinh@M@@0T__n128@@B 00c8 ?ybar@?$VSinh@M@@0T__n128@@B"
		altNames = "__vdecl_coshf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 84 B0 2E 4B 60 EF 50 01 CD EC 04 0B B9 FF 60 87 D3 EC 04 0B 29 4B 28 FF 60 EE D3 EC 04 0B 28 EF 60 CD 2C EF 5C 01 ?? ?? ?? ?? 22 4B D3 EC 04 0B 40 FF D0 0D 00 EF 60 AD 28 EF 58 01 ?? ?? ?? ?? 01 20 20 EF 50 81 ?? ?? ?? ?? FB FF 48 25 18 4B 6E EF 5E 61 48 EF 72 0F 42 FF F0 2D 48 EF 72 0F 42 FF F0 0D 48 EF 60 2D F7 EF 50 05 62 FF E0 08 5A FF 70 61 D3 EC 04 0B 0D 4B 6C FF 60 0E D3 EC 04 4B 4E EF 70 21 54 FF F6 21 DD EC 04 6B 46 EF E6 0E 52 FF F6 01 F9 FF 66 27 02 EF E4 0E 14 FF F0 01 04 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_67_0 {
	meta:
		name = "?sdx@?$VectorOp@M@@SA?AT__n128@@T2@0@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 F7 EF 52 05 20 FF 60 08 BD E8 00 88 }
	condition:
		$1
}

rule file_81_68_0 {
	meta:
		name = "?sinh@?$VSinh@M@@SA?AT__n128@@T2@@Z"
		size = 384
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0058 __vdecl_expf4 0078 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0158 ?eps@?$VSinh@M@@0T__n128@@B 015c ?q0@?$VSinh@M@@0T__n128@@B 0160 ?p0@?$VSinh@M@@0T__n128@@B 0164 ?p1@?$VSinh@M@@0T__n128@@B 0168 ?inf@?$VectorOp@M@@2T__n128@@B 016c ?wmax@?$VSinh@M@@0T__n128@@B 0170 ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B 0174 ?ln_v@?$VSinh@M@@0T__n128@@B 0178 ?ybar@?$VSinh@M@@0T__n128@@B"
		altNames = "__vdecl_sinhf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 8C B0 20 EF 50 81 9F ED 5A 0A 0D F1 10 0C 8C EC 04 8B ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A CD EC 04 0B ?? ?? ?? ?? 51 4B 60 EF 50 01 0D F1 20 0C CC EC 04 0B D3 EC 04 0B 4C 4B B9 FF 48 87 28 FF 60 EE D3 EC 04 0B 28 EF 60 CD 2C EF 5C 01 ?? ?? ?? ?? 44 4B D3 EC 04 0B 40 FF D0 0D 00 EF 60 AD 28 EF 58 01 ?? ?? ?? ?? 01 20 20 EF 50 81 ?? ?? ?? ?? FB FF 48 25 3A 4B 6E EF 5E 41 48 EF 72 0F 0D F1 10 0C DC EC 04 EB 42 FF F0 2D 4E FF FE 8D 48 EF 72 0F 42 FF F0 0D 68 EF 60 2D F7 EF 50 05 62 FF E0 08 5A FF 70 41 D3 EC 04 0B 2C 4B 6C FF 60 0E D3 EC 04 CB 28 4B 4E EF 70 21 5C FF F4 21 DD EC 04 4B F9 FF E2 07 64 FF EE AE 50 FF F2 A1 D3 EC 04 0B 20 4B 40 FF F8 2D D3 EC 04 0B 1C 4B 42 EF E0 6D D3 EC 04 0B 19 4B 48 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F F9 FF 6E 47 42 FF F0 0D 04 EF EC 0E 46 FF F0 0D 48 FF F0 0D 4E FF F0 0D 4E EF E0 2D D3 EC 04 0B 60 FF E4 0E 5E FF F2 01 0D F1 20 0C DC EC 04 2B 64 FF E2 2E 5A FF F0 21 4E EF EE 0E 52 FF FE 01 1E FF F0 01 0C B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "__stoi64"
		size = 248
		refs = "00a8 __fptoi64_exception_helper"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B B5 EE 40 0A F1 EE 10 FA 10 EE 10 0A 2A D0 C0 F3 C7 52 01 02 00 20 41 F0 00 41 4F F0 BE 03 D2 1A 23 DC 52 42 40 2A 4E DA 00 25 20 2A 03 DB 20 3A 05 46 08 46 00 21 D2 F1 20 03 10 FA 03 F4 25 43 D0 40 11 FA 03 F4 20 43 D1 40 B1 F1 00 4F 18 D8 29 D0 F1 EE 10 FA 02 DA 40 42 61 EB 41 01 35 BB BD E8 30 88 00 20 00 21 FA E7 20 2A 02 DB 20 3A 01 46 00 20 D2 F1 20 03 91 40 30 FA 03 F4 21 43 90 40 F1 EE 10 FA 02 DA 40 42 61 EB 41 01 F1 EE 10 3A 43 F0 04 03 03 EA 13 22 D2 06 E0 D0 11 4A ?? ?? ?? ?? DC E7 F1 EE 10 FA F0 DA D1 E7 F1 EE 10 3A 43 F0 01 03 03 EA 13 22 D2 06 D0 D0 0A 4A ?? ?? ?? ?? CC E7 00 20 00 21 F1 EE 10 3A 43 F0 02 03 03 EA 13 22 D2 06 C2 D0 04 4A ?? ?? ?? ?? BE E7 00 00 04 08 00 06 01 08 00 06 02 08 00 06 }
	condition:
		$1
}

rule file_86_4_0 {
	meta:
		name = "__stou64"
		size = 232
		refs = "00a2 __fptoi64_exception_helper"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B B5 EE 40 0A F1 EE 10 FA 10 EE 10 0A 27 D0 C0 F3 C7 52 01 02 00 20 41 F0 00 41 4F F0 BE 03 D2 1A 20 DC 52 42 40 2A 47 DA 00 25 20 2A 03 DB 20 3A 05 46 08 46 00 21 D2 F1 20 03 10 FA 03 F4 25 43 D0 40 11 FA 03 F4 20 43 D1 40 F1 EE 10 FA 03 DA 40 42 61 EB 41 01 17 E0 15 BB BD E8 30 88 00 20 00 21 FA E7 20 2A 02 DB 20 3A 01 46 00 20 D2 F1 20 03 91 40 30 FA 03 F4 21 43 90 40 F1 EE 10 FA 02 DA 40 42 61 EB 41 01 F1 EE 10 3A 43 F0 04 03 03 EA 13 22 D2 06 E0 D0 0E 4A ?? ?? ?? ?? DC E7 F1 EE 10 3A 43 F0 01 03 03 EA 13 22 D2 06 D4 D0 09 4A ?? ?? ?? ?? D0 E7 00 20 00 21 F1 EE 10 3A 43 F0 02 03 03 EA 13 22 D2 06 C6 D0 03 4A ?? ?? ?? ?? C2 E7 04 08 00 09 01 08 00 09 02 08 00 09 }
	condition:
		$1
}

rule file_86_5_0 {
	meta:
		name = "__fptoi64_exception_helper"
		size = 44
		refs = "0022 __fphelper_raise_exception"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 E1 EE 10 3A 8D ED 00 0B CD E9 02 01 D0 B2 C2 F3 07 21 C2 F3 07 63 C2 F3 07 42 ?? ?? ?? ?? 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_95_33_0 {
	meta:
		name = "??__E?sqrt_three@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?sqrt_three@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? D7 B3 DD 3F }
	condition:
		$1
}

rule file_95_35_0 {
	meta:
		name = "??__E?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? A2 30 89 3E }
	condition:
		$1
}

rule file_95_37_0 {
	meta:
		name = "?A@?$VATan@M@@CA?AT__n128@@T2@@Z"
		size = 124
		refs = "0008 __security_push_cookie 0064 __security_pop_cookie"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 88 B0 9F ED 1A 2A 10 EE 10 2B 04 AB 30 EE 10 1B 8D ED 04 2A 9F ED 14 2A 11 EE 10 0B 31 EE 10 4B 8D ED 05 2A 9F ED 0F 2A 8D ED 06 2A 9F ED 0C 2A 8D ED 07 2A 53 F8 22 30 00 93 04 AB 53 F8 21 30 01 93 04 AB 53 F8 20 30 02 93 04 AB 53 F8 24 30 03 93 9D EC 04 0B 08 B0 ?? ?? ?? ?? BD E8 10 88 92 0A 86 3F DB 0F C9 3F 92 0A 06 3F 00 00 00 00 }
	condition:
		$1
}

rule file_95_38_0 {
	meta:
		name = "?A@?$VATan@N@@CA?AT__n128@@T2@@Z"
		size = 144
		refs = "0006 __security_push_cookie 0066 __security_pop_cookie"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 8F B0 9F ED 1E 2B 9F ED 1B 3B 9F ED 18 4B 9F ED 15 5B 50 EC 11 2B 06 AB 03 EB C2 03 8D ED 06 2B 8D ED 08 3B 8D ED 0A 4B 8D ED 0C 5B 93 ED 00 2B 51 EC 10 2B 06 AB 03 EB C2 03 8D ED 00 2B 03 91 93 ED 00 0B DD E9 00 32 CD E9 03 03 05 92 8D ED 02 0B 0D F1 08 0C 9C EC 04 0B 0F B0 ?? ?? ?? ?? BD E8 00 88 FE DE 66 73 2D 38 52 C1 F0 3F 18 2D 44 54 FB 21 F9 3F 66 73 2D 38 52 C1 E0 3F 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_95_43_0 {
	meta:
		name = "?atan2@?$VATan@M@@SA?AT__n128@@T2@0@Z"
		size = 996
		refs = "002a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00a0 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 021c ?A@?$VATan@M@@CA?AT__n128@@T2@@Z 03a4 ?neginf@?$VectorOp@M@@2T__n128@@B 03a8 ?exponentBias@?$VectorOp@M@@2T__n128@@B 03ac ?exponentMask@?$VectorOp@M@@2T__n128@@B 03b0 ?inf@?$VectorOp@M@@2T__n128@@B 03b4 ?eps@?$VATan@M@@0T__n128@@B 03b8 ?q0@?$VATan@M@@0T__n128@@B 03bc ?p0@?$VATan@M@@0T__n128@@B 03c0 ?p1@?$VATan@M@@0T__n128@@B 03c4 ?sqrt_three@?$VATan@M@@0T__n128@@B 03c8 ?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B"
		altNames = "__vdecl_atan2f4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B B5 B0 20 EF 50 A1 9F ED F3 0A 22 EF 52 E1 0D F1 30 0C 8C EC 04 EB 0D F1 10 0C 8C EC 04 AB ?? ?? ?? ?? 0D F1 20 0C 8C EC 04 0B 9F ED E9 0A ?? ?? ?? ?? 60 EF 50 01 9F ED E5 0A 0D F1 A0 0C CC EC 04 0B ?? ?? ?? ?? 9F ED E0 8A 60 EF 50 01 0D F1 60 0C CC EC 04 0B B0 EE 48 0A ?? ?? ?? ?? 60 EF 50 01 9F ED D8 0A 0D F1 90 0C CC EC 04 0B ?? ?? ?? ?? 60 EF 50 01 9F ED D2 0A 0D F1 C0 0C CC EC 04 0B ?? ?? ?? ?? 60 EF 50 01 7D 20 0D F1 B0 0C CC EC 04 0B ?? ?? ?? ?? 60 EF 50 01 6F F0 79 00 0D F1 70 0C CC EC 04 0B ?? ?? ?? ?? FB FF 4E 25 60 EF 50 01 B6 EE 00 0A 0D F1 80 0C CC EC 04 0B 4E EF 72 0F 42 FF F0 2D 4E EF 72 0F 42 FF F0 0D 4A FF 70 0D B9 FF 60 A7 ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A CD EC 04 0B ?? ?? ?? ?? 20 EF 50 E1 B0 EE 48 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 50 0C CC EC 04 0B ?? ?? ?? ?? FB FF 4A 25 2A FF 4E CE 4A EF 72 0F 02 20 42 FF F0 2D 0D F1 40 0C 8C EC 04 CB 20 EF 50 81 4A EF 72 0F 42 FF F0 0D 10 FF DA C1 ?? ?? ?? ?? A0 4B 0D F1 40 0C 9C EC 04 AB DD EC 04 2B D3 EC 04 0B 9B 4B 10 FF 58 A1 2C FF 60 8E D3 EC 04 0B 40 EF CC 6D 60 EF CE 0D 40 FF DC 0D 60 EF E2 0D 60 EF E2 0D 40 EF CC 4D FB FF 66 25 28 EF 58 E1 46 EF F2 0F 01 20 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 10 FF DC E1 ?? ?? ?? ?? 87 4B 6A EF 40 08 4E FF 5E 4D 10 FF DA 81 01 20 D3 EC 04 0B 81 4B 40 FF F4 2D 8D EC 04 8B D3 EC 04 0B 7C 4B 42 EF E0 0D 40 FF F4 6D D3 EC 04 0B 78 4B 44 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4E FF 70 0D 4E EF 60 2D D3 EC 04 0B 20 FF DE CE 1E FF 72 C1 B9 FF CC 87 ?? ?? ?? ?? DD EC 04 0B 20 EF C0 A3 20 EF F0 01 18 FF 5C A1 ?? ?? ?? ?? 40 EF 4A 2D 62 4C 0D F1 20 0C 9C EC 04 0B 0D F1 30 0C 9C EC 04 4B D4 EC 04 0B 5C 4B 20 FF 44 AE 4E EF 60 4E 0D F1 50 0C DC EC 04 0B 0D F1 60 0C 9C EC 04 EB 0D F1 10 0C 9C EC 04 2B 50 FF F2 41 6A EF 5A 21 6E EF 64 0D 60 FF 42 EE 50 FF F4 21 44 EF 40 CE D3 EC 04 4B 4B 4B F9 FF E2 07 44 EF 74 81 D3 EC 04 AB 50 FF F2 E1 E9 FF 78 00 42 EF 74 41 60 FF EA 28 E9 FF 74 00 02 EF 40 CE 60 FF EA 08 60 FF E2 08 0D F1 70 0C DC EC 04 2B 60 EF F2 63 E9 FF 78 00 60 FF EA 28 E9 FF 74 00 60 FF EA 08 60 FF E2 08 0D F1 80 0C DC EC 04 2B 4F F0 00 40 62 EF F0 43 0D F1 90 0C DC EC 04 2B 6C EF F6 01 52 FF FE 01 42 EF 42 2E 50 FF 70 41 44 EF 44 0E 00 EF F2 81 14 FF D4 81 ?? ?? ?? ?? 0D F1 10 0C DC EC 04 CB 4C EF 5A 41 40 EF 7C A1 0D F1 20 0C 9C EC 04 0B 23 4B 6A EF DE 61 0D F1 30 0C 9C EC 04 EB 6A EF D0 81 6E FF 40 0E 56 FF D8 41 4C EF 70 21 0D F1 A0 0C DC EC 04 0B 6E FF 70 08 58 FF F4 21 4C EF 70 41 6E FF 50 08 56 FF F2 41 4C EF 70 61 F9 FF 6C 07 58 FF F4 61 D4 EC 04 4B 40 EF E4 8E 0D F1 B0 0C DC EC 04 0B 6A EF F0 21 4E EF 64 0E 48 EF F0 41 0D F1 C0 0C DC EC 04 0B 52 FF F6 41 6A EF F0 21 D3 EC 04 0B 4E EF 60 0E 08 EF F0 01 12 FF F4 01 35 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E4 CB 16 40 DB 0F 49 3F DB 0F C9 3F DB 0F 49 40 00 00 00 80 00 00 00 00 }
	condition:
		$1
}

rule file_95_44_0 {
	meta:
		name = "?atan@?$VATan@M@@SA?AT__n128@@T2@@Z"
		size = 484
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0066 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0174 ?A@?$VATan@M@@CA?AT__n128@@T2@@Z 01c0 ?inf@?$VectorOp@M@@2T__n128@@B 01c4 ?eps@?$VATan@M@@0T__n128@@B 01c8 ?q0@?$VATan@M@@0T__n128@@B 01cc ?p0@?$VATan@M@@0T__n128@@B 01d0 ?p1@?$VATan@M@@0T__n128@@B 01d4 ?sqrt_three@?$VATan@M@@0T__n128@@B 01d8 ?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B"
		altNames = "__vdecl_atanf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 94 B0 20 EF 50 81 9F ED 73 0A 0D F1 40 0C 8C EC 04 8B ?? ?? ?? ?? 60 EF 50 01 B6 EE 00 0A 0D F1 30 0C CC EC 04 0B B9 FF 48 A7 ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A 0D F1 10 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 E1 9F ED 62 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 20 0C CC EC 04 0B ?? ?? ?? ?? FB FF 4A 25 2A FF 4E CE 4A EF 72 0F 02 20 42 FF F0 2D 8D EC 04 CB 20 EF 50 81 4A EF 72 0F 42 FF F0 0D 10 FF DA C1 ?? ?? ?? ?? 50 4B 9D EC 04 AB 0D F1 10 0C DC EC 04 2B D3 EC 04 0B 4B 4B 10 FF 58 A1 2C FF 60 8E D3 EC 04 0B 01 20 40 EF CC 6D 60 EF CE 0D 28 EF 58 E1 40 FF DC 0D 60 EF E2 0D 60 EF E2 0D FB FF 66 25 40 EF CC 4D 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 10 FF DC E1 ?? ?? ?? ?? 37 4B 6A EF 40 08 4E FF 5E 4D 10 FF DA 81 D3 EC 04 0B 31 4B 40 FF F4 2D D3 EC 04 0B 2E 4B 0D F1 10 0C 8C EC 04 8B 42 EF E0 0D 40 FF F4 6D D3 EC 04 0B 27 4B 44 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4E FF 70 0D 4E EF 60 2D D3 EC 04 0B 20 FF DE CE 1E FF 72 C1 01 20 B9 FF CC 87 ?? ?? ?? ?? 0D F1 10 0C DC EC 04 0B 20 EF C0 A3 20 EF F0 01 18 FF 5C A1 ?? ?? ?? ?? 40 EF 4A 2D 10 4B 0D F1 40 0C DC EC 04 6B D3 EC 04 0B 06 EF E6 0E 4E EF 60 4E 0D F1 20 0C DC EC 04 0B 50 FF F2 41 0D F1 30 0C DC EC 04 2B F9 FF E4 07 62 FF E6 2E 50 FF F4 21 12 FF F6 01 14 B0 BD EC 10 8B BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DB 0F C9 3F 00 00 00 00 }
	condition:
		$1
}

rule file_95_45_0 {
	meta:
		name = "?atan_impl@?$VATan@M@@CA?AT__n128@@T2@@Z"
		size = 412
		refs = "0014 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0046 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0154 ?A@?$VATan@M@@CA?AT__n128@@T2@@Z 017c ?inf@?$VectorOp@M@@2T__n128@@B 0180 ?eps@?$VATan@M@@0T__n128@@B 0184 ?q0@?$VATan@M@@0T__n128@@B 0188 ?p0@?$VATan@M@@0T__n128@@B 018c ?p1@?$VATan@M@@0T__n128@@B 0190 ?sqrt_three@?$VATan@M@@0T__n128@@B 0194 ?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 8C B0 20 EF 50 A1 B6 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A 0D F1 10 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 E1 9F ED 59 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 20 0C CC EC 04 0B ?? ?? ?? ?? FB FF 4A 25 2A FF 4E CE 4A EF 72 0F 02 20 42 FF F0 2D 8D EC 04 CB 20 EF 50 81 4A EF 72 0F 42 FF F0 0D 10 FF DA C1 ?? ?? ?? ?? 47 4B 9D EC 04 AB 0D F1 10 0C DC EC 04 2B D3 EC 04 0B 42 4B 10 FF 58 A1 2C FF 60 8E D3 EC 04 0B 01 20 40 EF CC 6D 60 EF CE 0D 28 EF 58 E1 40 FF DC 0D 60 EF E2 0D 60 EF E2 0D FB FF 66 25 40 EF CC 4D 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 10 FF DC E1 ?? ?? ?? ?? 2E 4B 6A EF 40 08 4E FF 5E 4D 10 FF DA 81 01 20 D3 EC 04 0B 28 4B 40 FF F4 2D 0D F1 10 0C 8C EC 04 8B D3 EC 04 0B 22 4B 42 EF E0 0D 40 FF F4 6D D3 EC 04 0B 1E 4B 44 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4E FF 70 0D 4E EF 60 2D D3 EC 04 0B 20 FF DE CE 1E FF 72 C1 B9 FF CC 87 ?? ?? ?? ?? 0D F1 10 0C DC EC 04 0B 20 EF C0 A3 18 FF 5C A1 20 EF F0 01 ?? ?? ?? ?? 08 4B 40 EF 4A 2D D3 EC 04 0B 0E EF 60 0E 0D F1 20 0C DC EC 04 0B 10 FF F2 01 0C B0 BD EC 10 8B BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DB 0F C9 3F }
	condition:
		$1
}

rule file_95_54_0 {
	meta:
		name = "?create@?$VectorOp@M@@SA?AT__n128@@MMMM@Z"
		size = 32
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B CD ED 01 0A 8D ED 00 0A 8D ED 02 1A CD ED 03 1A 9D EC 04 0B BD E8 0F 88 }
	condition:
		$1
}

rule file_95_59_0 {
	meta:
		name = "?create@?$VectorOp@N@@SA?AT__n128@@NN@Z"
		size = 46
	strings:
		$1 = { 2D E9 00 48 EB 46 88 B0 8D ED 00 0B 8D ED 02 1B 00 9B 04 93 01 9B 05 93 02 9B 06 93 03 9B 07 93 0D F1 10 0C 9C EC 04 0B 08 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_95_68_0 {
	meta:
		name = "?intxp@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 44
		refs = "0024 ?exponentBias@?$VectorOp@M@@2T__n128@@B 0028 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 4B D3 EC 04 0B 05 4B 40 EF 70 01 E9 FF 70 20 D3 EC 04 0B 22 FF E0 08 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_77_0 {
	meta:
		name = "?unpack@?$VectorOp@N@@SAXT__n128@@AA_K1@Z"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 52 EC 10 3B C0 E9 00 32 52 EC 11 3B C1 E9 00 32 BD E8 00 88 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__security_check_cookie"
		size = 20
		refs = "0010 __security_cookie"
	strings:
		$1 = { DF F8 0C C0 DC F8 00 C0 60 45 03 D1 70 47 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_4_0 {
	meta:
		name = "??__E?C1@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?C1@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 80 31 3F }
	condition:
		$1
}

rule file_199_1_0 {
	meta:
		name = "??__E?C1@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?C1@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 80 31 3F }
	condition:
		$1
}

rule file_98_8_0 {
	meta:
		name = "??__E?C3@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?C3@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? D8 5B DE 3E }
	condition:
		$1
}

rule file_98_57_0 {
	meta:
		name = "?log10@?$VLog@M@@SA?AT__n128@@T2@@Z"
		size = 420
		refs = "001a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 003c ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0170 ?inf@?$VectorOp@M@@2T__n128@@B 0174 ?ind@?$VectorOp@M@@2T__n128@@B 0178 ?neginf@?$VectorOp@M@@2T__n128@@B 017c ?C3@?$VLog@M@@0T__n128@@B 0180 ?C2@?$VLog@M@@0T__n128@@B 0184 ?C1@?$VLog@M@@0T__n128@@B 0188 ?a0@?$VLog@M@@0T__n128@@B 0190 ?b0@?$VLog@M@@0T__n128@@B 0194 ?C0@?$VLog@M@@0T__n128@@B 0198 ?notExponentMask@?$VectorOp@M@@2T__n128@@B 019c ?exponentBias@?$VectorOp@M@@2T__n128@@B 01a0 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
		altNames = "__vdecl_log10f4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 85 B0 20 EF 50 81 B6 EE 00 0A 8D EC 04 8B ?? ?? ?? ?? 60 4B 5E 4C 00 20 D3 EC 04 0B 20 EF 50 E1 48 EF 70 01 E9 FF 70 20 D4 EC 04 0B 22 FF E0 A8 ?? ?? ?? ?? D4 EC 04 0B 54 4B 01 20 60 EF 60 08 F7 EF 70 25 D3 EC 04 0B 4F 4B 48 EF 70 01 20 EF F2 81 D3 EC 04 0B 28 FF 60 CE ?? ?? ?? ?? 6A FF 40 08 68 EF 4E 2D 6C EF 5C A1 5A FF 70 A1 62 EF CE 0D 44 4B 6C EF 5C 41 50 FF F2 41 9F ED 40 0A 44 FF DE 0D 40 EF CE 2D 48 FF 5E 0D 40 EF CE 0D 10 FF F2 C1 FB FF 4C 25 4C EF 72 0F 42 FF F0 2D 4C EF 72 0F 42 FF F0 0D 44 FF F0 8D D3 EC 04 0B 32 4B 48 FF F8 2D 42 EF E0 6D D3 EC 04 0B 2E 4B 42 FF F0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D FB FF 6A 46 48 FF F0 0D 48 EF E0 6D D3 EC 04 0B 21 4B 44 FF F0 2D D3 EC 04 0B 1E 4B 44 FF F0 0D 40 EF E6 0D 40 EF E2 2D D3 EC 04 0B 02 FF F0 8D ?? ?? ?? ?? 20 EF 50 A1 B7 EE 00 0A ?? ?? ?? ?? DD EC 04 6B 12 4B 46 EF C0 2E 46 EF CA 4E 5A FF 58 21 D3 EC 04 0B 0D 4B 06 EF E6 0E 50 FF F2 41 D3 EC 04 0B 08 4B 6A FF 66 2E 50 FF F4 21 D3 EC 04 0B 46 EF E0 0E 56 FF F2 01 10 FF F6 01 05 B0 BD EC 10 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_58_0 {
	meta:
		name = "?log@?$VLog@M@@SA?AT__n128@@T2@@Z"
		size = 408
		refs = "001a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 003c ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0168 ?inf@?$VectorOp@M@@2T__n128@@B 016c ?ind@?$VectorOp@M@@2T__n128@@B 0170 ?neginf@?$VectorOp@M@@2T__n128@@B 0174 ?C2@?$VLog@M@@0T__n128@@B 0178 ?C1@?$VLog@M@@0T__n128@@B 017c ?a0@?$VLog@M@@0T__n128@@B 0184 ?b0@?$VLog@M@@0T__n128@@B 0188 ?C0@?$VLog@M@@0T__n128@@B 018c ?notExponentMask@?$VectorOp@M@@2T__n128@@B 0190 ?exponentBias@?$VectorOp@M@@2T__n128@@B 0194 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
		altNames = "__vdecl_logf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 85 B0 20 EF 50 81 B6 EE 00 0A 8D EC 04 8B ?? ?? ?? ?? 5D 4B 5B 4C 00 20 D3 EC 04 0B 20 EF 50 E1 48 EF 70 01 E9 FF 70 20 D4 EC 04 0B 22 FF E0 A8 ?? ?? ?? ?? D4 EC 04 0B 51 4B 01 20 60 EF 60 08 F7 EF 70 25 D3 EC 04 0B 4C 4B 48 EF 70 01 20 EF F2 81 D3 EC 04 0B 28 FF 60 CE ?? ?? ?? ?? 6A FF 40 08 68 EF 4E 2D 6C EF 5C A1 5A FF 70 A1 62 EF CE 0D 41 4B 6C EF 5C 41 50 FF F2 41 9F ED 3D 0A 44 FF DE 0D 40 EF CE 2D 48 FF 5E 0D 40 EF CE 0D 10 FF F2 C1 FB FF 4C 25 4C EF 72 0F 42 FF F0 2D 4C EF 72 0F 42 FF F0 0D 44 FF F0 8D D3 EC 04 0B 2F 4B 48 FF F8 2D 42 EF E0 6D D3 EC 04 0B 2B 4B 42 FF F0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D FB FF 6A 46 48 FF F0 0D 48 EF E0 6D D3 EC 04 0B 1E 4B 44 FF F0 2D D3 EC 04 0B 44 FF F0 0D 40 EF E6 0D 00 EF E2 8D ?? ?? ?? ?? 20 EF 50 A1 B7 EE 00 0A ?? ?? ?? ?? DD EC 04 6B 13 4B 46 EF C0 2E D3 EC 04 0B 46 EF CA 4E 5A FF 58 21 50 FF F2 41 6A FF 66 2E 0B 4B 06 EF E6 0E D3 EC 04 0B 08 4B 50 FF F4 21 D3 EC 04 0B 46 EF E0 0E 56 FF F2 01 10 FF F6 01 05 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_59_0 {
	meta:
		name = "?log_check_special_case@?$VLog@M@@CA?AT__n128@@T2@0@Z"
		size = 120
		refs = "0016 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0068 ?inf@?$VectorOp@M@@2T__n128@@B 006c ?ind@?$VectorOp@M@@2T__n128@@B 0070 ?neginf@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 0C 8B 20 EF 50 C1 9F ED 19 0A 22 EF 52 81 ?? ?? ?? ?? 20 EF 50 A1 B7 EE 00 0A ?? ?? ?? ?? 12 4B 4C EF 40 2E 4C EF 4A 4E D3 EC 04 0B 0D 4B 5A FF 58 21 0C EF 4C 0E 50 FF F2 41 6A FF 4C 2E D3 EC 04 0B 07 4B 50 FF F4 21 D3 EC 04 0B 4C EF 60 0E 5C FF 72 01 10 FF DC 01 BD EC 0C 8B BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_98_60_0 {
	meta:
		name = "?log_impl@?$VLog@M@@CA?AT__n128@@T2@@Z"
		size = 300
		refs = "0014 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0036 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 010c ?C2@?$VLog@M@@0T__n128@@B 0110 ?C1@?$VLog@M@@0T__n128@@B 0114 ?a0@?$VLog@M@@0T__n128@@B 0118 ?b0@?$VLog@M@@0T__n128@@B 011c ?C0@?$VLog@M@@0T__n128@@B 0120 ?notExponentMask@?$VectorOp@M@@2T__n128@@B 0124 ?exponentBias@?$VectorOp@M@@2T__n128@@B 0128 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 2D ED 10 8B 20 EF 50 81 B6 EE 00 0A ?? ?? ?? ?? 43 4B 42 4C 00 20 D3 EC 04 0B 20 EF 50 E1 48 EF 70 01 E9 FF 70 20 D4 EC 04 0B 22 FF E0 A8 ?? ?? ?? ?? D4 EC 04 0B 38 4B 01 20 60 EF 60 08 F7 EF 70 25 D3 EC 04 0B 33 4B 48 EF 70 01 20 EF F2 81 D3 EC 04 0B 28 FF 60 CE ?? ?? ?? ?? 6A FF 40 08 68 EF 4E 2D 6C EF 5C A1 5A FF 70 A1 62 EF CE 0D 27 4B 6C EF 5C 41 50 FF F2 41 44 FF DE 0D 40 EF CE 2D 48 FF 5E 0D 40 EF CE 0D 10 FF F2 C1 FB FF 4C 25 4C EF 72 0F 42 FF F0 2D 4C EF 72 0F 42 FF F0 0D 44 FF F0 8D D3 EC 04 0B 18 4B 48 FF F8 2D 42 EF E0 6D D3 EC 04 0B 13 4B 42 FF F0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D FB FF 6A 46 48 FF F0 0D 48 EF E0 6D D3 EC 04 0B 07 4B 44 FF F0 2D D3 EC 04 0B 44 FF F0 0D 40 EF E6 0D 00 EF E2 0D BD EC 10 8B BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_64_0 {
	meta:
		name = "?setxp@?$VectorOp@M@@SA?AT__n128@@T2@0@Z"
		size = 48
		refs = "0028 ?notExponentMask@?$VectorOp@M@@2T__n128@@B 002c ?exponentBias@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 4B D3 EC 04 0B 06 4B 62 EF 60 08 F7 EF 70 25 D3 EC 04 0B 40 EF 70 01 20 EF F2 01 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "_RTC_Check_2_to_1"
		size = 36
		refs = "001a ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 10 F4 7F 43 06 D0 B3 F5 7F 4F 03 D0 03 98 01 21 ?? ?? ?? ?? 60 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_103_1_0 {
	meta:
		name = "_RTC_Check_4_to_1"
		size = 36
		refs = "001a ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 30 F0 FF 03 06 D0 13 F5 80 7F 03 D0 03 98 01 21 ?? ?? ?? ?? 60 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_103_2_0 {
	meta:
		name = "_RTC_Check_4_to_2"
		size = 38
		refs = "001c ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 03 46 6F F3 0F 03 04 46 33 B1 13 F5 80 3F 03 D0 03 98 01 21 ?? ?? ?? ?? 20 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_103_3_0 {
	meta:
		name = "_RTC_Check_8_to_1"
		size = 46
		refs = "0024 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 20 F0 FF 02 52 EA 01 03 04 46 09 D0 12 F5 80 7F 02 D1 B1 F1 FF 3F 03 D0 03 98 01 21 ?? ?? ?? ?? 60 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_103_4_0 {
	meta:
		name = "_RTC_Check_8_to_2"
		size = 48
		refs = "0026 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 02 46 6F F3 0F 02 52 EA 01 03 04 46 09 D0 12 F5 80 3F 02 D1 B1 F1 FF 3F 03 D0 03 98 01 21 ?? ?? ?? ?? 20 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_103_5_0 {
	meta:
		name = "_RTC_Check_8_to_4"
		size = 34
		refs = "0018 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 0B 00 06 D0 B1 F1 FF 3F 03 D0 03 98 01 21 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_108_1_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 64
		refs = "0038 __imp_RaiseException"
	strings:
		$1 = { 2D E9 90 48 0D F1 08 0B 88 B0 6F 46 00 23 3B 70 41 F2 01 03 BB 60 F8 60 3B 46 3B 61 17 F1 08 03 06 22 00 21 05 48 04 4C 24 68 A0 47 38 78 00 E0 78 68 08 B0 BD E8 90 88 ?? ?? ?? ?? 88 13 6D 40 }
	condition:
		$1
}

rule file_108_2_0 {
	meta:
		name = "?filt$0@?0??DebuggerProbe@@YAHK@Z@4HA"
		size = 24
		altNames = "?filt$0@?0??DebuggerRuntime@@YAHKHPAXPB_W@Z@4HA"
	strings:
		$1 = { 03 68 1A 68 03 4B 9A 42 01 D1 01 20 00 E0 00 20 70 47 FE DE 88 13 6D 40 }
	condition:
		$1
}

rule file_108_3_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 72
		refs = "0040 __imp_RaiseException"
	strings:
		$1 = { 2D E9 90 48 0D F1 08 0B 88 B0 6F 46 00 24 3C 70 41 F2 02 04 BC 60 F8 60 39 61 7A 61 3A 46 BA 61 FB 61 17 F1 08 03 06 22 00 21 06 48 04 4C 24 68 A0 47 38 78 00 E0 78 68 08 B0 BD E8 90 88 FE DE ?? ?? ?? ?? 88 13 6D 40 }
	condition:
		$1
}

rule file_108_5_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
		size = 292
		refs = "0008 __security_push_cookie 004c sprintf_s 00e6 ?failwithmessage@@YAXPAXHHPBD@Z 00ec __security_pop_cookie 00f4 ??_C@_02LLMPMKNF@?$DO?5?$AA@ 00f8 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 00fc ??_C@_01EEMJAFIK@?6?$AA@ 0100 ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 0104 ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 0108 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 010c ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 0110 ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 0114 ??_C@_0BC@HHMKLAND@?$CFs?$CFs?$CFp?$CFs?$CFzd?$CFs?$CFd?$CFs?$AA@ 0118 ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 011c ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 0120 ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? DC B0 44 4B 07 46 1E 69 0C 46 CD E9 08 67 B6 F1 FF 3F 64 D0 0C B9 3E 4B 5C E0 3C 4B 05 92 3A 4A 06 93 38 4B 1E A8 F4 21 04 93 E3 68 24 3B 03 93 33 4B 02 93 04 F1 20 03 01 93 30 4B 00 93 2E 4B ?? ?? ?? ?? E3 68 00 25 0D F1 28 09 A3 F1 24 08 0A AB 0D F1 40 0A 31 27 E6 1A B8 F1 10 0F 43 46 28 BF 10 23 9D 42 10 D2 06 EB 09 03 93 F8 20 40 20 4A 39 46 23 46 50 46 ?? ?? ?? ?? 6D 1C FF 1E 09 F8 01 4B 0A F1 03 0A E7 E7 0A AB 00 21 E9 54 10 AB 05 EB 45 02 DD E9 08 67 D1 54 1E AA 92 F9 00 30 02 F1 01 04 22 46 00 2B F8 D1 1E AA 10 46 12 F9 01 3B 00 2B FA D1 0D 4B 0C 4A 0D F2 6D 11 02 93 10 AB 01 93 08 4B 09 1B 00 93 0A AB ?? ?? ?? ?? 1E AB 04 22 31 46 38 46 ?? ?? ?? ?? 5C B0 ?? ?? ?? ?? BD E8 F0 8F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_6_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 60
		refs = "002c ?failwithmessage@@YAXPAXHHPBD@Z 0034 ?_RTC_ErrorMessages@@3QBQBDB 0038 ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 29 06 D8 0A 4B 53 F8 21 40 08 4B 53 F8 21 30 03 E0 06 4B 01 24 05 21 5B 69 B4 F1 FF 3F 03 D0 0A 46 21 46 ?? ?? ?? ?? BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_7_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 128
		refs = "0008 __security_push_cookie 0040 strcpy 0048 strcat 0062 ?failwithmessage@@YAXPAXHHPBD@Z 006a __security_pop_cookie 0074 ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 0078 ?stack_premsg@@3QBDB 007c ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? AD F5 80 6D 1A 4B 0D 46 80 46 9F 68 B7 F1 FF 3F 23 D0 91 F9 00 30 CB B1 0A 46 12 F9 01 3B 00 2B FB D1 53 1B 2C 33 B3 F5 80 6F 0F D8 0F 4C 68 46 6E 46 21 46 ?? ?? ?? ?? 68 46 29 46 ?? ?? ?? ?? 68 46 04 F1 1C 01 ?? ?? ?? ?? 00 E0 06 4E 33 46 02 22 39 46 40 46 ?? ?? ?? ?? 0D F5 80 6D ?? ?? ?? ?? BD E8 F0 89 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_8_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPAD00I@Z"
		size = 100
		refs = "0036 sprintf_s 0060 ??_C@_05MKKEDADM@?$CF?42X?5?$AA@"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 1F 46 00 25 13 1A CD E9 00 30 1E 46 02 91 81 46 8A 46 4F F0 31 08 10 2F 3A 46 28 BF 10 22 95 42 0F D2 16 F8 09 40 0C 4A 41 46 23 46 50 46 ?? ?? ?? ?? 09 F8 01 4B 6D 1C A8 F1 03 08 0A F1 03 0A E9 E7 DD E9 01 68 00 22 05 EB 45 03 AA 55 03 F8 08 20 BD E8 FE 8F FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_9_0 {
	meta:
		name = "?_strlen_priv@@YAIPBD@Z"
		size = 24
	strings:
		$1 = { 2D E9 00 48 EB 46 02 46 12 F9 01 3B 00 2B FB D1 13 1A 58 1E BD E8 00 88 }
	condition:
		$1
}

rule file_108_10_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 380
		refs = "0008 __security_push_cookie 001c ?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z 0026 ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 0070 ?DebuggerProbe@@YAHK@Z 0082 ?DebuggerRuntime@@YAHKHPAXPB_W@Z 00b2 ?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z 00c4 _guard_check_icall 014e __security_pop_cookie 0158 ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 015c ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 0160 __imp_WideCharToMultiByte 0164 ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 0168 ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 016c __imp_IsDebuggerPresent 0170 ?_RTC_NoFalsePositives@@3QBHB 0174 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 0178 __imp_MultiByteToWideChar"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? AD F6 48 6D 9A 46 91 46 88 46 05 91 06 46 00 27 ?? ?? ?? ?? 05 46 1D B9 30 46 ?? ?? ?? ?? 07 46 52 4C 00 23 01 93 24 68 00 93 DB 43 52 46 00 21 4F F6 E9 50 A0 47 B0 F5 00 7F 10 D2 4B 4C 0D F6 48 23 01 90 24 68 00 93 6F F0 00 03 52 46 00 21 4F F6 E9 50 A0 47 10 B1 0D F6 48 24 00 E0 42 4C 41 F2 02 00 ?? ?? ?? ?? 58 B1 3E 4B 32 46 48 46 53 F8 29 10 23 46 ?? ?? ?? ?? 00 28 5F D1 00 23 00 E0 01 23 0F B9 00 2D 58 D0 23 B1 34 4B 1B 68 98 47 00 28 52 D1 88 AB 00 93 4F F4 82 72 04 AB 06 A9 30 1F 01 92 ?? ?? ?? ?? 6D B1 2B 4B 28 46 02 94 00 93 CD F8 04 90 ?? ?? ?? ?? 04 9A 06 A9 40 46 88 AB A8 47 37 E0 22 4C 00 23 0D F5 85 62 24 68 21 4E 03 93 02 93 40 F2 0A 38 00 92 DB 43 06 AA 00 21 4F F6 E9 50 CD F8 04 80 A0 47 08 B1 0D F5 85 66 17 4C 00 23 0D F5 E7 62 24 68 14 4D 03 93 02 93 00 92 DB 43 88 AA 00 21 4F F6 E9 50 CD F8 04 80 A0 47 08 B1 0D F5 E7 65 0B 4A 38 46 CD F8 08 A0 00 92 CD F8 04 90 ?? ?? ?? ?? DD E9 04 20 31 46 2B 46 B8 47 01 28 00 D1 FE DE 0D F6 48 6D ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_11_0 {
	meta:
		name = "_RTC_UninitUse"
		size = 124
		refs = "0008 __security_push_cookie 003a strcpy 0042 strcat 005e ?failwithmessage@@YAXPAXHHPBD@Z 0066 __security_pop_cookie 0070 ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 0074 ?uninit_premsg@@3QBDB 0078 ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? AD F2 04 4D 19 4B 05 46 DF 68 B7 F1 FF 3F 22 D0 CD B1 02 46 12 F9 01 3B 00 2B FB D1 53 1B 39 33 B3 F5 80 6F 0F D8 10 4C 68 46 6E 46 21 46 ?? ?? ?? ?? 68 46 29 46 ?? ?? ?? ?? 68 46 04 F1 10 01 ?? ?? ?? ?? 00 E0 07 4E DD F8 1C 04 33 46 03 22 39 46 ?? ?? ?? ?? 0D F2 04 4D ?? ?? ?? ?? BD E8 F0 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_13_0 {
	meta:
		name = "_vsprintf_s_l"
		size = 56
		refs = "0010 __local_stdio_printf_options 0026 __stdio_common_vsprintf_s"
	strings:
		$1 = { 2D E9 FF 4B 0D F1 28 0B 1E 46 17 46 88 46 81 46 ?? ?? ?? ?? 0C 9C 05 46 D5 E9 00 01 43 46 4A 46 02 94 01 96 00 97 ?? ?? ?? ?? 00 28 01 DA 6F F0 00 00 04 B0 BD E8 F0 8B }
	condition:
		$1
}

rule file_108_14_0 {
	meta:
		name = "sprintf_s"
		size = 64
		refs = "0012 __local_stdio_printf_options 002a __stdio_common_vsprintf_s"
	strings:
		$1 = { 0F B4 2D E9 FF 48 0D F1 20 0B 15 46 0C 95 0E 46 07 46 ?? ?? ?? ?? 0D AB 02 93 04 46 D4 E9 00 01 00 23 01 93 33 46 3A 46 00 95 ?? ?? ?? ?? 00 28 01 DA 6F F0 00 00 04 B0 BD E8 F0 08 5D F8 14 FB }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__chkstk"
		size = 28
	strings:
		$1 = { BD EB 84 0C 1D EE 50 4F A4 68 04 D3 A4 45 05 D3 AD EB 0C 04 70 47 5F F0 00 0C F7 E7 }
	condition:
		$1
}

rule file_110_1_0 {
	meta:
		name = "__chkstk_probe"
		size = 26
	strings:
		$1 = { 60 B4 66 46 6F F3 0B 06 A4 F5 80 54 25 68 B4 42 FA D1 60 BC AD EB 0C 04 70 47 }
	condition:
		$1
}

rule file_111_1_0 {
	meta:
		name = "?__scrt_uninitialize_type_info@@YAXXZ"
		size = 20
		refs = "000c __std_type_info_destroy_list 0010 ?__type_info_root_node@@3U__type_info_node@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_992_6_5 {
	meta:
		name = "??__E_Fac_tidy_reg@std@@YAXXZ"
		size = 20
		refs = "000c atexit 0010 ??__F_Fac_tidy_reg@std@@YAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_29_2 {
	meta:
		name = "??__Eclassic_locale@std@@YAXXZ"
		size = 20
		refs = "000c atexit 0010 ??__Fclassic_locale@std@@YAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_1_2 {
	meta:
		name = "??__Einit_atexit@@YAXXZ"
		size = 20
		refs = "000c atexit 0010 ??__Finit_atexit@@YAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_184_1 {
	meta:
		name = "??__Einit_cout@std@@YAXXZ"
		size = 20
		refs = "000c ??0_Init_cout@std@@QAA@XZ 0010 ?init_cout@std@@3U_Init_cout@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_181_1 {
	meta:
		name = "??__Einit_ushcout@std@@YAXXZ"
		size = 20
		refs = "000c ??0_Init_ushcout@std@@QAA@XZ 0010 ?init_ushcout@std@@3U_Init_ushcout@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_156_2 {
	meta:
		name = "??__Einit_wcout@std@@YAXXZ"
		size = 20
		refs = "000c ??0_Init_wcout@std@@QAA@XZ 0010 ?init_wcout@std@@3U_Init_wcout@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_992_7_5 {
	meta:
		name = "??__F_Fac_tidy_reg@std@@YAXXZ"
		size = 20
		refs = "000c ??1_Fac_tidy_reg_t@std@@QAA@XZ 0010 ?_Fac_tidy_reg@std@@3U_Fac_tidy_reg_t@1@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_164_2 {
	meta:
		name = "??__Fferr@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 0010 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_164_2 {
	meta:
		name = "??__Ffin@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 0010 ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_164_2 {
	meta:
		name = "??__Fflog@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 0010 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_189_1 {
	meta:
		name = "??__Ffout@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 0010 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_3_2 {
	meta:
		name = "??__Finit_atexit@@YAXXZ"
		size = 20
		refs = "000c ??1_Init_atexit@@QAA@XZ 0010 ?init_atexit@@3U_Init_atexit@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_161_2 {
	meta:
		name = "??__Finitlocks@@YAXXZ"
		size = 20
		refs = "000c ??1_Init_locks@std@@QAA@XZ 0010 ?initlocks@@3V_Init_locks@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_4_2 {
	meta:
		name = "??__Finitlocks@std@@YAXXZ"
		size = 20
		refs = "000c ??1_Init_locks@std@@QAA@XZ 0010 ?initlocks@std@@3V_Init_locks@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_189_1 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_189_1 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_164_2 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_164_2 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_164_2 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_189_1 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_189_1 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_164_2 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_164_2 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_189_1 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_164_2 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 20
		refs = "000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_9_1 {
	meta:
		name = "?_Lockit_ctor@_Lockit@std@@CAXPAV12@@Z"
		size = 20
		refs = "000c _Mtxlock 0010 ?mtx@std@@3PAU_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1_0 {
	meta:
		name = "??_N@YAXPAXIIP6AX0@Z1@Z"
		size = 86
		refs = "0026 _guard_check_icall 004a ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 FC 4B 0D F1 20 0B 6F 46 1E 46 90 46 89 46 F9 62 05 46 BD 62 00 24 7C 60 00 23 3B 70 44 45 0A D0 30 46 ?? ?? ?? ?? 28 46 01 21 B0 47 4D 44 BD 62 64 1C 7C 60 F2 E7 01 23 3B 70 3B 78 2B B9 BB 6B 7A 68 F9 6A B8 6A ?? ?? ?? ?? BD E8 FC 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__GSHandlerCheck_EH"
		size = 44
		refs = "0018 __GSHandlerCheckCommon 0024 __CxxFrameHandler3"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 1D 46 EC 69 0F 46 16 46 80 46 22 1D 19 46 38 46 ?? ?? ?? ?? 2B 46 32 46 39 46 40 46 ?? ?? ?? ?? BD E8 F8 89 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__isa_available_init"
		size = 32
		refs = "0008 IsProcessorFeaturePresent 001c __isa_available"
	strings:
		$1 = { 2D E9 00 48 EB 46 13 20 ?? ?? ?? ?? 10 B1 03 4B 01 22 1A 60 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "??_M@YAXPAXIIP6AX0@Z@Z"
		size = 90
		refs = "0034 _guard_check_icall 004e ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 F8 49 0D F1 18 0B 6F 46 1E 46 FE 62 14 46 BC 62 88 46 79 62 00 23 3B 70 01 FB 02 05 3D 62 00 2C A4 F1 01 04 BC 62 08 D0 A5 EB 08 05 3D 62 30 46 ?? ?? ?? ?? 28 46 B0 47 F1 E7 01 23 3B 70 3B 78 2B B9 FB 6A BA 6A 79 6A 38 6A ?? ?? ?? ?? BD E8 F8 09 5D F8 14 FB }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "?fin$0@?0???_M@YAXPAXIIP6AX0@Z@Z@4HA"
		size = 20
		refs = "000e ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 10 B5 3B 78 2B B9 FB 6A BA 6A 79 6A 38 6A ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 32
		refs = "0016 terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 1A 68 04 4B 9A 42 02 D0 00 20 BD E8 00 88 ?? ?? ?? ?? FE DE 63 73 6D E0 }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
		size = 56
		refs = "0024 _guard_check_icall"
	strings:
		$1 = { 0F B4 2D E9 FF 4B 0D F1 28 0B 6F 46 1E 46 90 46 89 46 05 46 3D 63 00 24 44 45 09 D0 A5 EB 09 05 3D 63 30 46 ?? ?? ?? ?? 28 46 B0 47 64 1C F3 E7 BD E8 FF 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "?filt$0@?0??__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z@4HA"
		size = 40
		refs = "001e terminate"
	strings:
		$1 = { 10 B5 F8 60 38 60 3B 68 1B 68 7B 60 7B 68 1A 68 04 4B 9A 42 03 D0 00 23 BB 60 B8 68 01 E0 ?? ?? ?? ?? 10 BD 63 73 6D E0 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "__rt_srsh"
		size = 58
	strings:
		$1 = { 00 2A 08 BF 70 47 20 2A 0C DB 40 2A 03 DB 4F EA 21 01 08 46 70 47 02 F0 1F 02 41 FA 02 F0 4F EA 21 01 70 47 20 FA 02 F0 C2 F1 20 03 01 FA 03 F3 40 EA 03 00 41 FA 02 F1 70 47 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "?GetPdbDll@@YAPAUHINSTANCE__@@XZ"
		size = 36
		refs = "0018 ?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ 0020 ?alreadyTried@?1??GetPdbDll@@YAPAUHINSTANCE__@@XZ@4_NA"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4A 13 78 0B B1 00 20 05 E0 01 23 13 70 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_128_1_0 {
	meta:
		name = "?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ"
		size = 372
		refs = "0008 __security_push_cookie 0018 __vcrt_LoadLibraryExW 0086 _guard_check_icall 0140 __security_pop_cookie 0148 ?mspdbName@@3QB_WB 014c __imp_FreeLibrary 0150 ??_C@_1BG@EABPBLLF@?$AAP?$AAr?$AAo?$AAd?$AAu?$AAc?$AAt?$AAD?$AAi?$AAr?$AA?$AA@ 0154 ??_C@_1HE@EBEAGLFB@?$AAS?$AAO?$AAF?$AAT?$AAW?$AAA?$AAR?$AAE?$AA?2?$AAW?$AAo?$AAw?$AA6?$AA4?$AA3?$AA2?$AAN?$AAo?$AAd?$AAe?$AA?2?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?2?$AAV@ 0158 ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 015c __imp_GetProcAddress 0160 ??_C@_0BB@GLNAEDBD@RegQueryValueExW?$AA@ 0164 ??_C@_0O@COHOBMLB@RegOpenKeyExW?$AA@ 0168 ??_C@_1BK@JHLNAEJL@?$AAa?$AAd?$AAv?$AAa?$AAp?$AAi?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 016c __imp_GetLastError 0170 ??_C@_1EI@MLPKHBGE@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AAw?$AAi?$AAn?$AA?9?$AAc?$AAo?$AAr?$AAe?$AA?9?$AAr?$AAe?$AAg?$AAi?$AAs?$AAt?$AAr?$AAy?$AA?9?$AAl?$AA1?$AA?9?$AA1?$AA?9?$AA0?$AA?4@"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? AD F5 08 7D 57 48 4F F4 00 62 00 21 ?? ?? ?? ?? 05 46 AD B9 51 48 4F F4 00 62 00 21 ?? ?? ?? ?? 05 46 6D B9 4E 4B 1B 68 98 47 57 28 06 D1 4B 48 00 22 00 21 ?? ?? ?? ?? 05 46 0D B9 00 20 77 E0 43 4B 45 49 28 46 1B 68 98 47 06 46 00 2E F5 D0 3F 4B 40 49 28 46 1B 68 98 47 07 46 00 2F ED D0 3B 4B 3A 49 28 46 1B 68 98 47 80 46 00 28 E5 D0 02 AB 30 46 00 93 4F F0 00 44 ?? ?? ?? ?? 32 49 A0 1C 00 22 01 23 B0 47 20 B1 2D 4B 28 46 1B 68 98 47 D3 E7 4F F4 02 73 03 93 03 AB 01 93 06 AB 38 46 00 93 ?? ?? ?? ?? 02 98 26 49 00 22 04 AB B8 47 04 46 40 46 ?? ?? ?? ?? 02 98 C0 47 20 4B 28 46 1B 68 98 47 00 2C B8 D1 04 9B 01 2B B5 D1 03 9B 13 F0 01 0F B1 D1 5A 08 10 46 02 2A AD D3 52 1E 06 AB 03 EB 42 01 0B 88 00 2B A6 D1 31 F8 02 3C 5C 2B 02 D0 5C 23 0B 80 02 46 D3 43 12 2B 9C D3 02 F1 11 03 B3 F5 82 7F 97 D8 06 AB 03 EB 42 02 0A 49 02 F1 22 00 31 F8 02 3B 22 F8 02 3B 82 42 F9 D1 06 A8 00 21 4F F4 10 62 ?? ?? ?? ?? 0D F5 08 7D ?? ?? ?? ?? BD E8 F0 89 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_128_2_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z"
		size = 772
		refs = "0038 __vcrt_GetModuleFileNameW 00ae ?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ 00de _guard_check_icall 02d8 __imp_HeapFree 02dc __imp_GetProcessHeap 02e0 __imp_HeapAlloc 02e4 ??_C@_01KDCPPGHE@r?$AA@ 02ec ??_C@_0BB@KCIACLNC@PDBOpenValidate5?$AA@ 02f0 __imp_GetProcAddress 02f4 ?alreadyTried@?1??GetPdbDll@@YAPAUHINSTANCE__@@XZ@4_NA 02f8 ?mspdb@@3PAUHINSTANCE__@@A 02fc ?PDBOK@?1??_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z@4_NA 0300 __imp_VirtualQuery"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 97 B0 BC 4C 4F F0 00 08 C3 F8 00 80 05 46 A1 F8 00 80 24 68 6D 1E 0E 91 1C 22 10 A9 28 46 0C 93 A0 47 08 B9 00 26 4C E1 25 9A 24 99 11 98 ?? ?? ?? ?? 00 28 F6 D0 11 99 45 F6 4D 23 0A 88 9A 42 F0 D1 CB 6B 00 2B ED DD 5A 58 58 18 44 F2 50 53 9A 42 E7 D1 83 8A C4 88 69 1A 03 44 00 27 4F F0 00 09 6C B1 03 F1 18 02 D3 68 99 42 04 D3 A1 EB 03 09 93 68 99 42 03 D3 7F 1C 28 32 A7 42 F3 D3 A7 42 CF D0 9B 4D 99 4C 7F 1C 2B 78 93 B9 23 68 00 2B C7 D1 95 4A 13 78 13 B1 00 23 23 60 C1 E7 01 23 13 70 ?? ?? ?? ?? 20 60 00 28 BA D0 01 23 2B 70 00 E0 20 68 8B 4B 8A 49 1B 68 98 47 04 46 00 2C AF D0 08 AB 03 93 0F AB 00 93 CD F8 08 80 CD F8 04 80 ?? ?? ?? ?? 24 98 00 21 00 22 00 23 A0 47 00 28 9E D0 08 9D 00 26 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 79 4B 98 42 40 F0 D9 80 08 9D 2C 68 E4 69 20 46 ?? ?? ?? ?? 73 4A 28 46 00 21 0B AB A0 47 00 28 00 F0 CB 80 0B 9C CD F8 08 80 CD F8 04 80 22 68 CD F8 00 80 15 6A 28 46 ?? ?? ?? ?? 20 46 B9 B2 4A 46 07 AB A8 47 00 28 00 F0 AF 80 07 9D 00 23 05 93 2B 68 9C 6E 20 46 ?? ?? ?? ?? 28 46 05 A9 A0 47 00 28 00 F0 99 80 05 9D 00 2D 00 F0 95 80 2B 68 B0 46 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 00 28 7A D0 0D F1 18 0A 05 9C 09 AB 00 93 23 68 00 22 02 92 DD 68 CD F8 04 A0 28 46 ?? ?? ?? ?? 20 46 00 21 0A AA 04 AB A8 47 00 28 6D D0 BD F8 10 30 BB 42 06 D1 0A 9A 4A 45 03 D8 09 9B 13 44 99 45 0A D3 05 9D 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 00 28 50 D0 D6 E7 06 9A 00 2A 54 D0 6F F0 60 43 9A 42 50 D2 3C 4B 1B 68 98 47 06 9B 00 21 DA 00 3A 4B 1B 68 98 47 80 46 00 28 44 D0 05 9D 02 90 06 AB 2C 68 00 27 01 93 E4 68 00 97 20 46 ?? ?? ?? ?? 28 46 0D A9 00 22 00 23 A0 47 58 B3 0A 9B A9 EB 03 04 D8 F8 00 30 9C 42 24 D3 06 98 01 22 01 28 08 D9 08 F1 08 01 51 F8 08 3B 9C 42 02 D3 52 1C 82 42 F8 D3 08 EB C2 03 53 F8 04 3C 0C 9A 07 9C 23 F0 7F 43 13 60 22 68 02 97 01 97 15 6F 00 97 28 46 ?? ?? ?? ?? DD E9 0D 12 20 46 22 AB A8 47 00 B1 01 26 17 4B 1B 68 98 47 15 4B 42 46 00 21 1B 68 98 47 05 9D 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 07 9D 2B 68 1C 6C 20 46 ?? ?? ?? ?? 28 46 A0 47 0B 9D 2B 68 9C 6B 20 46 ?? ?? ?? ?? 28 46 A0 47 08 9D 2B 68 DC 6A 20 46 ?? ?? ?? ?? 28 46 A0 47 30 46 17 B0 BD E8 F0 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 41 91 32 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_130_1_0 {
	meta:
		name = "??__D@YAXPAX0IIP6AX00@ZP6AX0@Z@Z"
		size = 98
		refs = "0028 _guard_check_icall 0056 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 FE 4F 0D F1 28 0B 6F 46 1E 46 92 46 BA 63 89 46 80 46 38 63 00 24 7C 60 00 23 3B 70 3D 6C B4 42 0F D0 28 46 ?? ?? ?? ?? 40 46 49 46 01 22 A8 47 D0 44 C7 F8 30 80 D1 44 C7 F8 34 90 64 1C 7C 60 ED E7 01 23 3B 70 3B 78 2B B9 7B 6C 7A 68 B9 6B 38 6B ?? ?? ?? ?? BD E8 FE 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_134_19_0 {
	meta:
		name = "??__E?lsb_mask@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?lsb_mask@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_49_0 {
	meta:
		name = "?A1@?$VPow@M@@CA?AT__n128@@T2@@Z"
		size = 224
		refs = "0008 __security_push_cookie 009c __security_pop_cookie"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 96 B0 33 4B 4F F0 7E 52 CD E9 04 23 2F 4B 30 EE 10 1B 11 EE 10 0B 06 93 2B 4B 31 EE 10 4B 07 93 28 4B 08 93 26 4B 09 93 24 4B 0A 93 22 4B 0B 93 20 4B 0C 93 1E 4B 0D 93 1C 4B 0E 93 1A 4B 0F 93 18 4B 10 93 16 4B 11 93 14 4B 12 93 12 4B 13 93 A2 F5 00 03 10 EE 10 2B 14 93 04 AB 03 EB 82 03 53 F8 04 3C 00 93 04 AB 03 EB 81 03 53 F8 04 3C 01 93 04 AB 03 EB 80 03 53 F8 04 3C 02 93 04 AB 03 EB 84 03 53 F8 04 3C 03 93 9D EC 04 0B 16 B0 ?? ?? ?? ?? BD E8 10 88 C3 AA 05 3F C1 95 0B 3F D3 C3 11 3F F0 37 18 3F 32 F5 1E 3F D6 FE 25 3F 3E 58 2D 3F F3 04 35 3F A3 08 3D 3F 2A 67 45 3F 8C 24 4E 3F FC 44 57 3F DE CC 60 3F C6 C0 6A 3F 7D 25 75 3F }
	condition:
		$1
}

rule file_134_50_0 {
	meta:
		name = "?A2@?$VPow@M@@CA?AT__n128@@T2@@Z"
		size = 156
		refs = "0008 __security_push_cookie 0074 __security_pop_cookie"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 8C B0 22 4B 10 EE 10 2B 30 EE 10 1B 04 93 1E 4B 11 EE 10 0B 31 EE 10 4B 05 93 1A 4B 06 93 18 4B 07 93 16 4B 08 93 14 4B 09 93 12 4B 0A 93 10 4B 0B 93 04 AB 03 EB 82 03 53 F8 04 3C 00 93 04 AB 03 EB 81 03 53 F8 04 3C 01 93 04 AB 03 EB 80 03 53 F8 04 3C 02 93 04 AB 03 EB 84 03 53 F8 04 3C 03 93 9D EC 04 0B 0C B0 ?? ?? ?? ?? BD E8 10 88 90 98 CF 32 23 56 E7 32 42 23 C1 32 A1 42 6A 33 0C 58 1F 33 24 FC A8 31 94 2A 6C 33 36 24 A9 31 }
	condition:
		$1
}

rule file_134_53_0 {
	meta:
		name = "?adx@?$VectorOp@M@@SA?AT__n128@@T2@0@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 F7 EF 52 05 20 EF 60 08 BD E8 00 88 }
	condition:
		$1
}

rule file_134_76_0 {
	meta:
		name = "?idiv_by16@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 FD EF 50 00 A4 FF 70 01 BC EF 50 00 BD E8 00 88 }
	condition:
		$1
}

rule file_134_78_0 {
	meta:
		name = "?is_odd@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 32
		refs = "0010 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 01 20 20 EF 50 81 ?? ?? ?? ?? 20 EF 58 08 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_134_84_0 {
	meta:
		name = "?pow@?$VPow@M@@SA?AT__n128@@T2@0@Z"
		size = 2488
		refs = "000c __security_push_cookie 002e ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00ca ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 091a __security_pop_cookie 0928 ?ind@?$VectorOp@M@@2T__n128@@B 092c ?neginf@?$VectorOp@M@@2T__n128@@B 0930 ?smallx@?$VPow@M@@0T__n128@@B 0934 ?bigx@?$VPow@M@@0T__n128@@B 0938 ?inf@?$VectorOp@M@@2T__n128@@B 096c ?q1@?$VPow@M@@0T__n128@@B 0970 ?q2@?$VPow@M@@0T__n128@@B 0974 ?q3@?$VPow@M@@0T__n128@@B 0978 ?K@?$VPow@M@@0T__n128@@B 097c ?p1@?$VPow@M@@0T__n128@@B 09ac ?notExponentMask@?$VectorOp@M@@2T__n128@@B 09b0 ?exponentBias@?$VectorOp@M@@2T__n128@@B 09b4 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
		altNames = "__vdecl_powf4"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 2D ED 10 8B ?? ?? ?? ?? CC B0 9F ED 1F 8A 20 EF 50 A1 0D F1 18 0C 8C EC 04 2B 0D F1 28 0C 8C EC 04 AB B0 EE 48 0A ?? ?? ?? ?? 0D F1 88 0C 8C EC 04 0B 9F ED 14 0A ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A 0D F1 B8 0C CC EC 04 0B ?? ?? ?? ?? 0D F1 98 0C 8C EC 04 0B BF EE 00 0A ?? ?? ?? ?? 60 EF 50 01 B0 EE 48 0A 0D F1 A8 0C CC EC 04 0B B9 FF 4A C7 ?? ?? ?? ?? 60 EF 50 01 9F ED 01 0A 05 E0 00 00 80 3D 00 00 00 80 00 00 00 00 0D F1 78 0C CC EC 04 0B 8D ED 00 0A ?? ?? ?? ?? 60 EF 50 01 B3 EE 00 0A 0D F1 58 0C CC EC 04 0B 8D ED 01 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 38 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 81 01 20 0D F1 48 0C 8C EC 04 8B ?? ?? ?? ?? DF F8 D0 38 20 EF 50 A1 09 20 D3 EC 04 0B DF F8 C0 38 0D F1 68 0C 8C EC 04 AB 4C EF 70 01 E9 FF 70 20 D3 EC 04 0B DF F8 A4 38 22 FF E0 E8 68 EF 60 08 F7 EF 70 25 D3 EC 04 0B 4C EF 70 01 20 EF F2 C1 ?? ?? ?? ?? DF F8 40 38 DF F8 14 78 4F F0 7E 52 CD E9 32 23 DF F8 2C 38 DF F8 00 68 3D 97 34 93 DF F8 1C 38 35 93 DF F8 10 38 36 93 DF F8 08 38 37 93 DF F8 FC 37 38 93 DF F8 F4 37 39 93 DF F8 E8 37 3A 93 DF F8 E0 37 3B 93 DF F8 D4 37 3C 93 A2 F5 00 08 DF F8 08 58 DF F8 2C A8 DF F8 24 98 10 EE 10 2B 32 AB 03 EB 82 03 CD E9 3E 65 CD E9 40 A9 CD F8 08 81 53 F8 04 3C 30 EE 10 1B 11 EE 10 0B 44 93 32 AB 03 EB 81 03 31 EE 10 4B 53 F8 04 3C 45 93 32 AB 03 EB 80 03 53 F8 04 3C 04 20 46 93 32 AB 03 EB 84 03 53 F8 04 3C 47 93 0D F5 88 7C DC EC 04 0B 00 FF CC 8E 10 FF 5A 81 ?? ?? ?? ?? 4F F0 7E 53 68 EF 40 28 32 93 DF F8 78 37 CD E9 3D 76 12 EE 90 2B 33 93 DF F8 64 37 CD E9 3F 5A CD E9 41 98 34 93 DF F8 54 37 32 EE 90 1B 13 EE 90 0B 35 93 DF F8 40 37 33 EE 90 4B 36 93 DF F8 34 37 37 93 DF F8 28 37 38 93 DF F8 20 37 39 93 DF F8 14 37 3A 93 DF F8 0C 37 3B 93 DF F8 00 37 3C 93 32 AB 03 EB 82 03 53 F8 04 3C 44 93 32 AB 03 EB 81 03 53 F8 04 3C 45 93 32 AB 03 EB 80 03 53 F8 04 3C 46 93 32 AB 03 EB 84 03 53 F8 04 3C 02 20 47 93 0D F5 88 7C DC EC 04 0B 00 FF CC AE 12 FF D8 A1 ?? ?? ?? ?? 4F F0 7E 53 6A EF 40 28 32 93 DF F8 D0 36 DF F8 A8 E6 12 EE 90 2B 33 93 DF F8 BC 36 CD E9 3C E7 CD E9 3E 65 34 93 DF F8 AC 36 CD E9 40 A9 CD F8 08 81 35 93 DF F8 98 36 32 EE 90 1B 13 EE 90 0B 36 93 DF F8 88 36 33 EE 90 4B 37 93 DF F8 78 36 38 93 DF F8 70 36 39 93 DF F8 64 36 3A 93 DF F8 5C 36 3B 93 32 AB 03 EB 82 03 53 F8 04 3C 44 93 32 AB 03 EB 81 03 53 F8 04 3C 45 93 32 AB 03 EB 80 03 53 F8 04 3C 46 93 32 AB 03 EB 84 03 53 F8 04 3C 47 93 4F F0 7E 53 32 93 DF F8 40 36 0D F5 88 7C DC EC 04 0B 33 93 DF F8 2C 36 40 FF CC 8E 0D F1 68 0C DC EC 04 0B 34 93 DF F8 18 36 52 FF DA 81 35 93 DF F8 08 36 68 EF E0 28 36 93 DF F8 FC 35 37 93 DF F8 F0 35 38 93 DF F8 E8 35 39 93 DF F8 DC 35 3A 93 DF F8 D4 35 3B 93 CD E9 3E 65 12 EE 90 5B 32 AB 03 EB 85 03 CD E9 3C E7 CD E9 40 A9 CD F8 08 81 53 F8 04 3C 32 EE 90 6B 13 EE 90 7B 44 93 32 AB 03 EB 86 03 33 EE 90 EB 53 F8 04 3C 45 93 32 AB 03 EB 87 03 53 F8 04 3C 46 93 32 AB 03 EB 8E 03 53 F8 04 3C 47 93 DF F8 D4 35 0D F5 88 7C DC EC 04 0B 44 93 DF F8 C4 35 4C EF 60 6D FF FF 72 00 45 93 DF F8 B0 35 10 EE 90 2B 46 93 DF F8 A4 35 30 EE 90 1B 11 EE 90 0B 47 93 DF F8 90 35 31 EE 90 4B 48 93 DF F8 84 35 49 93 DF F8 78 35 4A 93 DF F8 70 35 4B 93 44 AB 03 EB 82 03 53 F8 04 3C 02 93 44 AB 03 EB 81 03 53 F8 04 3C 03 93 44 AB 03 EB 80 03 53 F8 04 3C 04 93 44 AB 03 EB 84 03 53 F8 04 3C 05 93 4F F0 7E 53 32 93 DF F8 18 35 33 93 DF F8 0C 35 34 93 DF F8 04 35 35 93 DF F8 F8 34 36 93 DF F8 F0 34 37 93 DF F8 E4 34 38 93 DF F8 DC 34 39 93 DF F8 D0 34 DF F8 00 45 CD E9 3F 4A 3A 93 DF F8 C0 34 CD E9 41 98 9D ED 00 0A 3B 93 DF F8 AC 34 3C 93 DF F8 A4 34 3D 93 DF F8 98 34 3E 93 32 AB 03 EB 85 03 53 F8 04 3C 44 93 32 AB 03 EB 86 03 53 F8 04 3C 45 93 32 AB 03 EB 87 03 53 F8 04 3C 46 93 32 AB 03 EB 8E 03 53 F8 04 3C 47 93 DC EC 04 0B DF F8 A0 34 6C EF 60 2D 0D F1 08 0C DC EC 04 0B 62 EF E0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 40 EF E0 6D D3 EC 04 0B DF F8 68 34 46 FF F6 2D D3 EC 04 4B 40 FF F2 0D 40 FF F6 2D 44 FF F2 0D 42 EF E0 2D 46 FF F4 0D 42 EF E0 0D 0D F1 58 0C DC EC 04 2B 00 EF E6 AD E4 EF 5E 05 60 FF E8 08 FB FF 60 06 00 FF F2 ED 0D F1 08 0C 8C EC 04 EB ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 0D F1 18 0C DC EC 04 4B 40 FF 74 0D 9D ED 00 0A FB FF 60 07 FB FF 60 06 00 FF D8 CD 64 EF CC 0D 4E FF 70 2D 4A FF 74 0D 00 EF E2 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D FB FF 60 07 9D ED 00 0A FB FF 60 06 40 FF D8 2D 0D F1 08 0C DC EC 04 0B 2A EF 62 ED 40 FF DC 0D 02 EF E0 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D 9D ED 00 0A FB FF 60 07 FB FF 60 06 00 FF D8 CD 6A EF 4C 0D 0E EF 60 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D 0D F1 38 0C DC EC 04 2B D8 4B FB FF 60 07 01 20 FB FF 60 06 00 FF D8 ED 4C EF 4E 0D 42 FF F0 0D 6A EF 4E 2D FB FF 60 47 0D F1 78 0C DC EC 04 0B 62 FF E0 6E 0D F1 58 0C DC EC 04 0B 66 EF F6 81 62 EF E0 0D 50 FF F2 81 0D F1 68 0C DC EC 04 2B 64 EF E2 08 50 FF F4 61 0D F1 48 0C DC EC 04 0B 20 EF E6 C3 10 FF F2 C1 FD EF 76 00 66 EF F6 21 E4 FF 70 21 BC EF 72 C1 E4 EF 5C 05 20 FF E6 88 D3 EC 04 0B B8 4B 40 FF F8 2D D3 EC 04 0B B4 4B 42 EF E0 0D 40 FF F8 2D D3 EC 04 0B 42 EF E0 0D 00 FF F8 AD ?? ?? ?? ?? 4F F0 7E 53 68 EF 40 08 32 93 AA 4B 33 93 A8 4B 34 93 A6 4B 35 93 A4 4B 36 93 A2 4B 37 93 A0 4B 38 93 9E 4B 39 93 9C 4B 3A 93 9A 4B 10 EE 90 2B CD E9 3F 4A 3B 93 96 4B CD E9 41 98 30 EE 90 1B 3C 93 92 4B 11 EE 90 0B 31 EE 90 4B 3D 93 8E 4B 3E 93 32 AB 03 EB 82 03 53 F8 04 3C 02 93 32 AB 03 EB 81 03 53 F8 04 3C 03 93 32 AB 03 EB 80 03 53 F8 04 3C 04 93 32 AB 03 EB 84 03 53 F8 04 3C 81 4C 01 20 05 93 0D F1 08 0C DC EC 04 2B 7C 4B 42 FF DA 0D 42 EF E0 2D F7 EF 5C 05 62 EF E0 28 D3 EC 04 0B 76 4B 6E FF 60 4E D4 EC 04 0B 50 FF F2 41 D3 EC 04 0B 20 FF CE AE 0D F1 18 0C 9C EC 04 EB 0D F1 78 0C DC EC 04 0B BB FF 4E 87 10 FF F4 A1 FB FF 48 06 00 EF CE CE 0D F1 38 0C 8C EC 04 CB ?? ?? ?? ?? 0D F1 88 0C DC EC 04 6B 0D F1 28 0C DC EC 04 8B 60 EF 58 08 6E FF 66 2E 4C EF 70 41 48 EF E6 0E 26 FF CE EE 40 EF F2 21 0D F1 48 0C CC EC 04 4B 00 EF DE C1 42 EF F4 01 4F F0 00 40 58 FF DA 01 B0 FF E4 A5 02 EF DA 81 16 FF F0 81 ?? ?? ?? ?? 0D F1 28 0C DC EC 04 0B 0D F1 48 0C 9C EC 04 2B 4C EF 5A 61 40 EF 70 01 94 EC 04 0B 4C EF 52 21 60 EF D0 01 50 FF D8 21 46 4B 0D F1 18 0C 9C EC 04 8B 0D F1 28 0C 9C EC 04 CB D3 EC 04 EB 0D F1 A8 0C DC EC 04 0B 48 EF 40 CE 48 EF 6E 4E 50 FF 72 61 0D F1 98 0C 9C EC 04 4B 4C EF 60 2E 6C EF F4 01 B9 FF 4C 67 36 4B 40 EF F2 01 64 FF 46 8E 54 FF 76 01 44 EF F8 21 66 FF 44 AE 50 FF 70 21 0D F1 88 0C 9C EC 04 4B 44 EF FA 01 4C EF FA 41 54 FF 72 01 4C EF F8 21 68 FF 44 AE 54 FF 70 21 0D F1 B8 0C DC EC 04 CB 4C EF 6E 0E 50 FF 72 41 40 EF DE 21 40 EF FA 61 42 EF D2 01 42 EF DA 21 5C FF F4 01 4C EF 40 8E 54 FF 70 21 46 EF D2 01 5E FF F2 01 46 EF DA 21 48 EF FA 61 50 FF 70 21 48 EF DE 01 54 FF 72 01 64 FF 4C 2E 50 FF 70 61 46 EF 40 0E 0C EF 4C 0E F0 FF E0 05 40 EF F2 21 0D F1 38 0C DC EC 04 0B F0 FF E0 05 42 EF F0 41 D3 EC 04 0B 42 EF D2 21 50 FF F6 41 F9 FF E4 07 50 FF F4 21 48 EF 48 0E 52 FF D8 01 10 FF DC 01 4C B0 ?? ?? ?? ?? BD EC 10 8B BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F0 37 18 3F 32 F5 1E 3F D6 FE 25 3F 3E 58 2D 3F F3 04 35 3F A3 08 3D 3F 2A 67 45 3F 8C 24 4E 3F FC 44 57 3F DE CC 60 3F C6 C0 6A 3F 7D 25 75 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D3 C3 11 3F 90 98 CF 32 23 56 E7 32 42 23 C1 32 A1 42 6A 33 0C 58 1F 33 24 FC A8 31 94 2A 6C 33 36 24 A9 31 C3 AA 05 3F C1 95 0B 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_85_0 {
	meta:
		name = "?pow_impl@?$VPow@M@@CA?AT__n128@@T2@0@Z"
		size = 1916
		refs = "000c __security_push_cookie 0022 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 006e ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 06e6 __security_pop_cookie 06f4 ?smallx@?$VPow@M@@0T__n128@@B 06f8 ?inf@?$VectorOp@M@@2T__n128@@B 06fc ?bigx@?$VPow@M@@0T__n128@@B 0730 ?q1@?$VPow@M@@0T__n128@@B 0734 ?q2@?$VPow@M@@0T__n128@@B 0738 ?q3@?$VPow@M@@0T__n128@@B 073c ?K@?$VPow@M@@0T__n128@@B 0740 ?p1@?$VPow@M@@0T__n128@@B 0770 ?notExponentMask@?$VectorOp@M@@2T__n128@@B 0774 ?exponentBias@?$VectorOp@M@@2T__n128@@B 0778 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 2D ED 10 8B ?? ?? ?? ?? B8 B0 20 EF 50 81 9F ED 07 0A 0D F1 48 0C 8C EC 04 2B ?? ?? ?? ?? 60 EF 50 01 9F ED 01 0A 03 E0 00 00 80 3D 00 00 00 00 0D F1 38 0C CC EC 04 0B 8D ED 00 0A ?? ?? ?? ?? 60 EF 50 01 B3 EE 00 0A 0D F1 18 0C CC EC 04 0B 8D ED 01 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 58 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 C1 01 20 0D F1 68 0C 8C EC 04 CB ?? ?? ?? ?? DF F8 F0 36 20 EF 50 A1 09 20 D3 EC 04 0B DF F8 E0 36 0D F1 28 0C 8C EC 04 AB 48 EF 70 01 E9 FF 70 20 D3 EC 04 0B DF F8 C4 36 22 FF E0 E8 6C EF 60 08 F7 EF 70 25 D3 EC 04 0B 48 EF 70 01 20 EF F2 C1 ?? ?? ?? ?? DF F8 60 36 4F F0 7E 52 CD E9 1E 23 DF F8 50 36 DF F8 28 76 DF F8 20 66 20 93 DF F8 3C 36 DF F8 58 56 DF F8 7C A6 21 93 DF F8 2C 36 DF F8 70 96 A2 F5 00 08 22 93 DF F8 18 36 10 EE 10 2B CD E9 29 76 23 93 DF F8 08 36 CD E9 2B 5A CD E9 2D 98 24 93 DF F8 F4 35 30 EE 10 1B 11 EE 10 0B 25 93 DF F8 E4 35 31 EE 10 4B 26 93 DF F8 D4 35 27 93 DF F8 CC 35 28 93 1E AB 03 EB 82 03 53 F8 04 3C 30 93 1E AB 03 EB 81 03 53 F8 04 3C 31 93 1E AB 03 EB 80 03 53 F8 04 3C 04 20 32 93 1E AB 03 EB 84 03 53 F8 04 3C 33 93 0D F1 C0 0C DC EC 04 0B 00 FF CC 8E 10 FF 5A 81 ?? ?? ?? ?? 4F F0 7E 53 68 EF 40 28 1E 93 DF F8 98 35 CD E9 29 76 12 EE 90 2B 1F 93 DF F8 88 35 CD E9 2B 5A CD E9 2D 98 20 93 DF F8 74 35 32 EE 90 1B 13 EE 90 0B 21 93 DF F8 64 35 33 EE 90 4B 22 93 DF F8 54 35 23 93 DF F8 4C 35 24 93 DF F8 40 35 25 93 DF F8 38 35 26 93 DF F8 2C 35 27 93 DF F8 24 35 28 93 1E AB 03 EB 82 03 53 F8 04 3C 30 93 1E AB 03 EB 81 03 53 F8 04 3C 31 93 1E AB 03 EB 80 03 53 F8 04 3C 32 93 1E AB 03 EB 84 03 53 F8 04 3C 02 20 33 93 0D F1 C0 0C DC EC 04 0B 00 FF CC AE 12 FF D8 A1 ?? ?? ?? ?? 4F F0 7E 53 6A EF 40 28 1E 93 DF F8 F0 34 1F 93 DF F8 E8 34 20 93 DF F8 DC 34 21 93 DF F8 D4 34 22 93 DF F8 C8 34 DF F8 B0 E4 12 EE 90 2B 23 93 DF F8 B8 34 CD E9 28 E7 CD E9 2A 65 24 93 DF F8 A4 34 CD E9 2C A9 CD F8 B8 80 25 93 DF F8 94 34 32 EE 90 1B 13 EE 90 0B 26 93 DF F8 80 34 33 EE 90 4B 27 93 1E AB 03 EB 82 03 53 F8 04 3C 30 93 1E AB 03 EB 81 03 53 F8 04 3C 31 93 1E AB 03 EB 80 03 53 F8 04 3C 32 93 1E AB 03 EB 84 03 53 F8 04 3C CD E9 2A 65 CD E9 28 E7 33 93 4F F0 7E 53 1E 93 DF F8 58 34 0D F1 C0 0C DC EC 04 0B CD E9 2C A9 1F 93 DF F8 44 34 40 FF CC 8E 0D F1 28 0C DC EC 04 0B 20 93 DF F8 2C 34 52 FF DA 81 CD F8 B8 80 21 93 DF F8 1C 34 68 EF E0 28 22 93 DF F8 0C 34 12 EE 90 5B 32 EE 90 6B 23 93 FF 4B 13 EE 90 7B 33 EE 90 EB 24 93 FB 4B 25 93 F9 4B 26 93 F7 4B 27 93 1E AB 03 EB 85 03 53 F8 04 3C 30 93 1E AB 03 EB 86 03 53 F8 04 3C 31 93 1E AB 03 EB 87 03 53 F8 04 3C 32 93 1E AB 03 EB 8E 03 53 F8 04 3C CD E9 2C A9 CD F8 B8 80 33 93 FE 4B 0D F1 C0 0C DC EC 04 0B 30 93 FA 4B 4C EF 60 6D FF FF 72 00 31 93 F6 4B 10 EE 90 2B 32 93 F3 4B 30 EE 90 1B 11 EE 90 0B 33 93 EF 4B 31 EE 90 4B 34 93 EC 4B 35 93 EA 4B 36 93 E8 4B 37 93 30 AB 03 EB 82 03 53 F8 04 3C 02 93 30 AB 03 EB 81 03 53 F8 04 3C 03 93 30 AB 03 EB 80 03 53 F8 04 3C 04 93 30 AB 03 EB 84 03 53 F8 04 3C DA 4C 05 93 4F F0 7E 53 1E 93 D2 4B 2B 94 1F 93 CF 4B 20 93 CD 4B 21 93 CB 4B 22 93 C9 4B 23 93 C7 4B 24 93 C5 4B 25 93 C3 4B 26 93 C1 4B 27 93 BF 4B 28 93 BD 4B 29 93 BB 4B 2A 93 1E AB 03 EB 85 03 53 F8 04 3C 9D ED 00 0A 30 93 1E AB 03 EB 86 03 53 F8 04 3C 31 93 1E AB 03 EB 87 03 53 F8 04 3C 32 93 1E AB 03 EB 8E 03 53 F8 04 3C 33 93 DC EC 04 0B BC 4B 6C EF 60 2D 0D F1 08 0C DC EC 04 0B 62 EF E0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 40 EF E0 6D D3 EC 04 0B AF 4B 46 FF F6 2D D3 EC 04 4B 40 FF F2 0D 40 FF F6 2D 44 FF F2 0D 42 EF E0 2D 46 FF F4 0D 42 EF E0 0D 0D F1 18 0C DC EC 04 2B 00 EF E6 AD E4 EF 5E 05 60 FF E8 08 FB FF 60 06 00 FF F2 ED 0D F1 08 0C 8C EC 04 EB ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 0D F1 48 0C DC EC 04 4B 40 FF 74 0D 9D ED 00 0A FB FF 60 07 FB FF 60 06 00 FF D8 CD 64 EF CC 0D 4E FF 70 2D 4A FF 74 0D 00 EF E2 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D 9D ED 00 0A FB FF 60 07 FB FF 60 06 40 FF D8 2D 0D F1 08 0C DC EC 04 0B 2A EF 62 ED 40 FF DC 0D 02 EF E0 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D FB FF 60 07 FB FF 60 06 00 FF D8 CD 6A EF 4C 0D 9D ED 00 0A 0E EF 60 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D 0D F1 58 0C DC EC 04 2B 6D 4B FB FF 60 07 01 20 FB FF 60 06 00 FF D8 ED 4C EF 4E 0D 42 FF F0 0D 6A EF 4E 2D FB FF 60 47 0D F1 38 0C DC EC 04 0B 62 FF E0 6E 0D F1 18 0C DC EC 04 0B 66 EF F6 81 62 EF E0 0D 50 FF F2 81 0D F1 28 0C DC EC 04 2B 64 EF E2 08 50 FF F4 61 0D F1 68 0C DC EC 04 0B 20 EF E6 C3 10 FF F2 C1 FD EF 76 00 66 EF F6 21 E4 FF 70 21 BC EF 72 C1 E4 EF 5C 05 20 FF E6 88 D3 EC 04 0B 4D 4B 40 FF F8 2D D3 EC 04 0B 4A 4B 42 EF E0 0D 40 FF F8 2D D3 EC 04 0B 42 EF E0 0D 00 FF F8 AD ?? ?? ?? ?? 4F F0 7E 53 68 EF 40 08 1E 93 40 4B CD E9 2B 4A CD E9 2D 98 1F 93 3C 4B 10 EE 90 2B 30 EE 90 1B 20 93 38 4B 11 EE 90 0B 31 EE 90 4B 21 93 34 4B 22 93 32 4B 23 93 30 4B 24 93 2E 4B 25 93 2C 4B 26 93 2A 4B 27 93 28 4B 28 93 26 4B 29 93 24 4B 2A 93 1E AB 03 EB 82 03 53 F8 04 3C 02 93 1E AB 03 EB 81 03 53 F8 04 3C 03 93 1E AB 03 EB 80 03 53 F8 04 3C 04 93 1E AB 03 EB 84 03 53 F8 04 3C 05 93 0D F1 08 0C DC EC 04 2B 14 4B 42 FF DA 0D 42 EF E0 2D F7 EF 5C 05 62 EF E0 28 D3 EC 04 0B 0D 4B 6E FF 60 4E D3 EC 04 0B 0A 4B 50 FF F2 41 D3 EC 04 0B 20 FF CE 0E 0D F1 38 0C DC EC 04 0B 10 FF F4 01 38 B0 ?? ?? ?? ?? BD EC 10 8B BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F0 37 18 3F 32 F5 1E 3F D6 FE 25 3F 3E 58 2D 3F F3 04 35 3F A3 08 3D 3F 2A 67 45 3F 8C 24 4E 3F FC 44 57 3F DE CC 60 3F C6 C0 6A 3F 7D 25 75 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D3 C3 11 3F 90 98 CF 32 23 56 E7 32 42 23 C1 32 A1 42 6A 33 0C 58 1F 33 24 FC A8 31 94 2A 6C 33 36 24 A9 31 C3 AA 05 3F C1 95 0B 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_87_0 {
	meta:
		name = "?reduce@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 64
		refs = "0012 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 08 8B 20 EF 50 81 9F ED 0B 0A ?? ?? ?? ?? 20 EF 50 A1 B3 EE 00 0A ?? ?? ?? ?? 40 FF 58 0D FB FF 60 07 FB FF 60 06 00 FF DA 0D BD EC 08 8B BD E8 00 88 FE DE 00 00 80 3D }
	condition:
		$1
}

rule file_144_2_0 {
	meta:
		name = "__u64tod"
		size = 140
		refs = "0080 __i64tofp_exception_helper"
	strings:
		$1 = { 2D E9 03 48 0D F1 08 0B 00 29 08 D1 B0 FA 80 F2 10 FA 02 F1 28 D0 00 20 02 F1 20 02 08 E0 B1 FA 81 F2 D2 F1 20 03 91 40 30 FA 03 F3 19 43 90 40 40 F2 3E 43 D2 EB 03 02 5F EA 00 5C C0 0A 4B 05 18 43 C9 0A 62 F3 1E 51 1C F0 80 4F 05 D0 3C F0 80 4C 02 D0 40 1C 41 F1 00 01 41 EC 10 0B 5F EA 4C 0C 04 D1 BD E8 03 88 41 EC 10 1B FA E7 F1 EE 10 3A 43 F0 01 03 03 EA 13 22 D2 06 F2 D0 02 4A ?? ?? ?? ?? EE E7 00 00 01 08 09 01 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "__u64tos"
		size = 136
		refs = "007c __i64tofp_exception_helper"
	strings:
		$1 = { 2D E9 03 48 0D F1 08 0B 00 29 08 D1 B0 FA 80 F2 10 FA 02 F1 26 D0 00 20 02 F1 20 02 08 E0 B1 FA 81 F2 D2 F1 20 03 91 40 30 FA 03 F3 19 43 90 40 4F F0 BE 03 D2 EB 03 02 5F EA C1 5C 09 0A 62 F3 DE 51 1C F0 80 4F 04 D0 3C F0 80 4C 01 D0 01 F1 01 01 00 EE 10 1A 5F EA 4C 0C 5C EA 00 0C 04 D1 BD E8 03 88 00 EE 10 1A FA E7 F1 EE 10 3A 43 F0 01 03 03 EA 13 22 D2 06 F2 D0 02 4A ?? ?? ?? ?? EE E7 00 00 01 08 09 00 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "??$tan_impl@$00@?$VTan@M@@CA?AT__n128@@T1@0@Z"
		size = 380
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00d8 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0150 ?ind@?$VectorOp@M@@2T__n128@@B 0154 ?inf@?$VectorOp@M@@2T__n128@@B 0158 ?eps@?$VTan@M@@0T__n128@@B 015c ?q0@?$VTan@M@@0T__n128@@B 0160 ?q1@?$VTan@M@@0T__n128@@B 0164 ?q2@?$VTan@M@@0T__n128@@B 0168 ?p1@?$VTan@M@@0T__n128@@B 016c ?c1@?$VTan@M@@0T__n128@@B 0170 ?c2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 88 B0 20 EF 50 E1 9F ED 59 0A 0D F1 10 0C 8C EC 04 2B ?? ?? ?? ?? 20 EF 50 81 B7 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 9F ED 50 0A CD EC 04 0B 0E FF 58 CD ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C CE FB FF 60 27 44 4B 01 20 F9 FF E2 03 10 FF F2 C1 D3 EC 04 0B 3F 4B FB FF 4C 46 44 FF F0 2D D3 EC 04 0B 3B 4B 44 FF F0 0D 6E EF 60 0D 60 EF E2 8D D3 EC 04 0B 35 4B 48 FF F8 4D 40 FF F4 0D 40 FF F8 0D 40 EF E8 6D D3 EC 04 0B 2F 4B 40 FF F4 2D D3 EC 04 0B 2B 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 27 4B 42 EF E0 2D D3 EC 04 0B 20 FF F8 AE DD EC 04 0B 2A EF 5A 81 18 FF F6 81 10 FF F2 A1 ?? ?? ?? ?? 60 EF 5C 88 F9 FF C8 07 FB FF 4A 25 1A 4B 68 EF F8 61 50 FF D8 61 4A EF 72 0F 42 FF F0 2D 4A EF 72 0F 42 FF F0 0D FB FF 66 25 46 FF F0 4D 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 4A FF 70 0D 50 FF F4 81 0D F1 10 0C DC EC 04 4B D3 EC 04 0B 08 4B 44 EF E4 2E 04 EF E0 0E D3 EC 04 0B 58 FF F4 21 10 FF F2 01 08 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 83 F9 22 3F }
	condition:
		$1
}

rule file_149_1_0 {
	meta:
		name = "??$tan_impl@$0A@@?$VTan@M@@CA?AT__n128@@T1@0@Z"
		size = 380
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00d8 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0150 ?ind@?$VectorOp@M@@2T__n128@@B 0154 ?inf@?$VectorOp@M@@2T__n128@@B 0158 ?eps@?$VTan@M@@0T__n128@@B 015c ?q0@?$VTan@M@@0T__n128@@B 0160 ?q1@?$VTan@M@@0T__n128@@B 0164 ?q2@?$VTan@M@@0T__n128@@B 0168 ?p1@?$VTan@M@@0T__n128@@B 016c ?c1@?$VTan@M@@0T__n128@@B 0170 ?c2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 88 B0 20 EF 50 E1 9F ED 59 0A 0D F1 10 0C 8C EC 04 2B ?? ?? ?? ?? 20 EF 50 81 B7 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 9F ED 50 0A CD EC 04 0B 0E FF 58 CD ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C CE FB FF 60 27 44 4B 01 20 F9 FF E2 03 10 FF F2 C1 D3 EC 04 0B 3F 4B FB FF 4C 46 44 FF F0 2D D3 EC 04 0B 3B 4B 44 FF F0 0D 6E EF 60 0D 60 EF E2 8D D3 EC 04 0B 35 4B 48 FF F8 4D 40 FF F4 0D 40 FF F8 0D 40 EF E8 6D D3 EC 04 0B 2F 4B 40 FF F4 2D D3 EC 04 0B 2B 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 27 4B 42 EF E0 2D D3 EC 04 0B 20 FF F8 AE DD EC 04 0B 2A EF 5A 81 18 FF F6 81 10 FF F2 A1 ?? ?? ?? ?? 60 EF 5C 88 F9 FF C8 07 68 EF F8 61 50 FF D8 61 19 4B FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D FB FF 4A 25 4A FF 70 4D 4A EF 72 0F 42 FF F0 2D 4A EF 72 0F 42 FF F0 0D 46 FF F0 0D 50 FF F4 81 0D F1 10 0C DC EC 04 4B D3 EC 04 0B 08 4B 44 EF E4 2E 04 EF E0 0E D3 EC 04 0B 58 FF F4 21 10 FF F2 01 08 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 83 F9 22 3F }
	condition:
		$1
}

rule file_149_2_0 {
	meta:
		name = "??__E?c1@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?c1@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 C9 3F }
	condition:
		$1
}

rule file_149_49_0 {
	meta:
		name = "?cotan@?$VTan@M@@SA?AT__n128@@T2@@Z"
		size = 428
		refs = "0026 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00de ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 017c ?eps1@?$VTan@M@@0T__n128@@B 0180 ?ind@?$VectorOp@M@@2T__n128@@B 0184 ?inf@?$VectorOp@M@@2T__n128@@B 0188 ?eps@?$VTan@M@@0T__n128@@B 018c ?q0@?$VTan@M@@0T__n128@@B 0190 ?q1@?$VTan@M@@0T__n128@@B 0194 ?q2@?$VTan@M@@0T__n128@@B 0198 ?p1@?$VTan@M@@0T__n128@@B 019c ?c1@?$VTan@M@@0T__n128@@B 01a0 ?c2@?$VTan@M@@0T__n128@@B"
		altNames = "__vdecl_cotanf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 89 B0 20 EF 50 A1 9F ED 65 0A F9 FF 4A 07 8D EC 04 AB 0D F1 10 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 81 B7 EE 00 0A ?? ?? ?? ?? 20 EF 50 E1 9F ED 5A 0A 0A FF 58 CD ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C CE FB FF 60 27 4F 4B 01 20 F9 FF E2 03 10 FF F2 C1 D3 EC 04 0B 4A 4B FB FF 4C 46 44 FF F0 2D D3 EC 04 0B 45 4B 44 FF F0 0D DD EC 04 4B 64 EF E0 0D 60 EF E2 8D D3 EC 04 0B 3F 4B 48 FF F8 4D 40 FF F4 0D 40 FF F8 0D 40 EF E8 6D D3 EC 04 0B 38 4B 40 FF F4 2D D3 EC 04 0B 35 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 30 4B 42 EF E0 2D D3 EC 04 0B 20 FF F8 AE 2A EF 5A 81 18 FF F6 81 1E FF 72 A1 ?? ?? ?? ?? 60 EF 5C 88 F9 FF C8 07 68 EF F8 61 50 FF D8 61 24 4C 22 4B FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D FB FF 4A 25 4A FF 70 4D 4A EF 72 0F 42 FF F0 2D 4A EF 72 0F 0D F1 10 0C 9C EC 04 AB 42 FF F0 0D 4A EF 4A 2E 46 FF F0 0D 50 FF F4 81 D4 EC 04 0B 58 FF DA 21 0A EF 60 8E D3 EC 04 0B 4F F0 00 40 10 FF F2 81 ?? ?? ?? ?? DD EC 04 0B 09 4B 40 EF 70 21 D4 EC 04 0B 62 EF F0 21 D3 EC 04 0B 20 FF CA 0E 12 FF D8 01 09 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 83 F9 22 3F }
	condition:
		$1
}

rule file_149_64_0 {
	meta:
		name = "?intrnd@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 72
		refs = "0012 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 0C 8B 20 EF 50 C1 9F ED 0D 0A ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C 0E FB FF 60 27 F9 FF E2 03 10 FF F2 01 BD EC 0C 8B BD E8 00 88 FE DE 00 00 00 00 }
	condition:
		$1
}

rule file_149_65_0 {
	meta:
		name = "?intrnd_posonly@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 38
		refs = "0012 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 20 EF 50 81 B6 EE 00 0A ?? ?? ?? ?? 48 EF 40 0D BB FF 60 07 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_149_73_0 {
	meta:
		name = "?tan@?$VTan@M@@SA?AT__n128@@T2@@Z"
		size = 368
		refs = "0014 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00d0 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0144 ?ind@?$VectorOp@M@@2T__n128@@B 0148 ?inf@?$VectorOp@M@@2T__n128@@B 014c ?eps@?$VTan@M@@0T__n128@@B 0150 ?q0@?$VTan@M@@0T__n128@@B 0154 ?q1@?$VTan@M@@0T__n128@@B 0158 ?q2@?$VTan@M@@0T__n128@@B 015c ?p1@?$VTan@M@@0T__n128@@B 0160 ?c1@?$VTan@M@@0T__n128@@B 0164 ?c2@?$VTan@M@@0T__n128@@B"
		altNames = "__vdecl_tanf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 84 B0 20 EF 50 E1 9F ED 56 0A ?? ?? ?? ?? 20 EF 50 81 B7 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 9F ED 4F 0A CD EC 04 0B 0E FF 58 CD ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C CE FB FF 60 27 43 4B 01 20 F9 FF E2 03 10 FF F2 C1 D3 EC 04 0B 3E 4B FB FF 4C 46 44 FF F0 2D D3 EC 04 0B 3A 4B 44 FF F0 0D 6E EF 60 0D 60 EF E2 8D D3 EC 04 0B 34 4B 48 FF F8 4D 40 FF F4 0D 40 FF F8 0D 40 EF E8 6D D3 EC 04 0B 2E 4B 40 FF F4 2D D3 EC 04 0B 2A 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 26 4B 42 EF E0 2D D3 EC 04 0B 20 FF F8 AE DD EC 04 0B 2A EF 5A 81 18 FF F6 81 10 FF F2 A1 ?? ?? ?? ?? 60 EF 5C 88 F9 FF C8 07 FB FF 4A 25 19 4B 68 EF F8 61 50 FF D8 61 4A EF 72 0F 42 FF F0 2D 4A EF 72 0F 42 FF F0 0D FB FF 66 25 46 FF F0 4D 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 4A FF 70 0D 50 FF F4 81 F9 FF 4E 47 D3 EC 04 0B 08 4B 44 EF E4 2E 04 EF E0 0E D3 EC 04 0B 58 FF F4 21 10 FF F2 01 04 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 83 F9 22 3F }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "_RTC_Initialize"
		size = 52
		refs = "001c _guard_check_icall 002c __rtc_izz 0030 __rtc_iaa"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 09 4B 08 4E 1D 1D 1B 1D B3 42 08 D2 55 F8 04 4B 1C B1 20 46 ?? ?? ?? ?? A0 47 B5 42 F6 D3 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_1_0 {
	meta:
		name = "_RTC_Terminate"
		size = 52
		refs = "001c _guard_check_icall 002c __rtc_tzz 0030 __rtc_taa"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 09 4B 08 4E 1D 1D 1B 1D B3 42 08 D2 55 F8 04 4B 1C B1 20 46 ?? ?? ?? ?? A0 47 B5 42 F6 D3 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "??__E?c1@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?c1@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 10 49 40 }
	condition:
		$1
}

rule file_154_48_0 {
	meta:
		name = "?cos@?$VSin@M@@SA?AT__n128@@T2@@Z"
		size = 328
		refs = "0016 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0058 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0114 ?ind@?$VectorOp@M@@2T__n128@@B 0118 ?inf@?$VectorOp@M@@2T__n128@@B 011c ?eps@?$VSin@M@@0T__n128@@B 0120 ?r1@?$VSin@M@@0T__n128@@B 0124 ?r2@?$VSin@M@@0T__n128@@B 0128 ?r3@?$VSin@M@@0T__n128@@B 012c ?r4@?$VSin@M@@0T__n128@@B 0130 ?c1@?$VSin@M@@0T__n128@@B 0134 ?c2@?$VSin@M@@0T__n128@@B 0138 ?half@?$VSin@M@@0T__n128@@B 0140 ?one@?$VSin@M@@0T__n128@@B"
		altNames = "__vdecl_cosf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 89 B0 20 EF 50 81 9F ED 4C 0A ?? ?? ?? ?? F9 FF 48 07 48 4B 00 EF C0 8D 9F ED 45 0A 93 EC 04 EB 0D F1 10 0C 8C EC 04 8B CD EC 04 0B ?? ?? ?? ?? 3E 4C 48 FF 50 2D 01 20 D4 EC 04 0B B9 FF CE 87 42 EF E0 0D BB FF 60 A7 BB FF 4A C6 ?? ?? ?? ?? D4 EC 04 0B DD EC 04 6B 0D F1 10 0C DC EC 04 AB 31 4B 6C EF 60 0D 46 EF EA 4E 60 EF 5A 88 5C FF 70 41 58 FF 5E 81 D3 EC 04 0B 2A 4B 44 FF F0 2D D3 EC 04 0B 26 4B 44 FF F0 0D 66 EF E0 0D 60 EF E2 6D D3 EC 04 0B 21 4B 46 FF F6 4D 40 FF F4 2D D3 EC 04 0B 1C 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 18 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 13 4B 42 EF E0 0D 40 FF F4 0D 46 FF F0 0D 46 EF E0 2D D3 EC 04 0B 0D 4B 60 FF F6 0E 56 FF F2 01 4A EF EA 2E 40 FF F8 0D 50 FF FA 21 D3 EC 04 0B 05 4B 0A EF E0 0E D3 EC 04 0B 10 FF F2 01 09 B0 BD EC 10 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F9 A2 3E ?? ?? ?? ?? DB 0F C9 3F }
	condition:
		$1
}

rule file_154_65_0 {
	meta:
		name = "?sin@?$VSin@M@@SA?AT__n128@@T2@@Z"
		size = 312
		refs = "002e ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 004e ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0104 ?ind@?$VectorOp@M@@2T__n128@@B 0108 ?inf@?$VectorOp@M@@2T__n128@@B 010c ?eps@?$VSin@M@@0T__n128@@B 0110 ?r1@?$VSin@M@@0T__n128@@B 0114 ?r2@?$VSin@M@@0T__n128@@B 0118 ?r3@?$VSin@M@@0T__n128@@B 011c ?r4@?$VSin@M@@0T__n128@@B 0120 ?c1@?$VSin@M@@0T__n128@@B 0124 ?c2@?$VSin@M@@0T__n128@@B 0128 ?half@?$VSin@M@@0T__n128@@B 0130 ?one@?$VSin@M@@0T__n128@@B 0134 ?sign_mask@?$VSin@M@@0T__n128@@B"
		altNames = "__vdecl_sinf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 85 B0 49 4B B9 FF 40 87 D3 EC 04 0B 45 4B 8D EC 04 8B 40 EF 70 21 D3 EC 04 0B 9F ED 41 0A 22 EF F0 E1 ?? ?? ?? ?? 3D 4C 48 FF 50 2D 01 20 D4 EC 04 0B B9 FF CE 87 42 EF E0 0D BB FF 60 A7 BB FF 4A C6 ?? ?? ?? ?? D4 EC 04 0B DD EC 04 AB 32 4B 6C EF 60 0D 4A EF EA 4E 60 EF 5A 88 5C FF 70 41 58 FF 5E 81 D3 EC 04 0B 2A 4B 44 FF F0 2D D3 EC 04 0B 27 4B 44 FF F0 0D 6A EF E0 0D 60 EF E2 6D D3 EC 04 0B 21 4B 46 FF F6 4D 40 FF F4 2D D3 EC 04 0B 1D 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 18 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 14 4B 42 EF E0 0D 40 FF F4 0D 46 FF F0 0D 46 EF E0 2D D3 EC 04 0B 0D 4B 60 FF F6 0E 56 FF F2 01 4A EF EA 2E 40 FF F8 0D 50 FF FA 21 D3 EC 04 0B 06 4B 0A EF E0 0E D3 EC 04 0B 10 FF F2 01 05 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F9 A2 3E ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_66_0 {
	meta:
		name = "?sincos@?$VSin@M@@CA?AT__n128@@T2@00@Z"
		size = 312
		refs = "0026 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 004e ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 010c ?ind@?$VectorOp@M@@2T__n128@@B 0110 ?inf@?$VectorOp@M@@2T__n128@@B 0114 ?eps@?$VSin@M@@0T__n128@@B 0118 ?r1@?$VSin@M@@0T__n128@@B 011c ?r2@?$VSin@M@@0T__n128@@B 0120 ?r3@?$VSin@M@@0T__n128@@B 0124 ?r4@?$VSin@M@@0T__n128@@B 0128 ?c1@?$VSin@M@@0T__n128@@B 012c ?c2@?$VSin@M@@0T__n128@@B 0130 ?half@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 89 B0 20 EF 50 81 9F ED 48 0A 22 EF 52 A1 24 EF 54 E1 0D F1 10 0C 8C EC 04 AB ?? ?? ?? ?? 41 4C 4A FF 50 2D 01 20 D4 EC 04 0B 42 EF E0 0D BB FF 60 A7 F9 FF 48 07 BB FF 4A C6 B9 FF CE 87 CD EC 04 0B ?? ?? ?? ?? 60 EF 5A 88 D4 EC 04 0B DD EC 04 6B 0D F1 10 0C DC EC 04 AB 31 4B 6C EF 60 0D 46 EF EA 4E 58 FF 5E 81 5C FF 70 41 D3 EC 04 0B 2A 4B 44 FF F0 2D D3 EC 04 0B 27 4B 44 FF F0 0D 66 EF E0 0D 60 EF E2 6D D3 EC 04 0B 21 4B 46 FF F6 4D 40 FF F4 2D D3 EC 04 0B 1D 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 18 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 14 4B 42 EF E0 0D 40 FF F4 0D 46 FF F0 0D 46 EF E0 2D D3 EC 04 0B 0D 4B 60 FF F6 0E 56 FF F2 01 4A EF EA 2E 40 FF F8 0D 50 FF FA 21 D3 EC 04 0B 06 4B 0A EF E0 0E D3 EC 04 0B 10 FF F2 01 09 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F9 A2 3E }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "__GSHandlerCheck_SEH_noexcept"
		size = 48
		refs = "000a __GSHandlerCheck_SEH 0026 terminate"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 63 68 13 F0 66 0F 05 D1 22 68 04 4B 9A 42 01 D1 01 28 01 D0 BD E8 18 88 ?? ?? ?? ?? FE DE 63 73 6D E0 }
	condition:
		$1
}

rule file_2_0_3 {
	meta:
		name = "__C_specific_handler_noexcept"
		size = 48
		refs = "000a __C_specific_handler 0026 terminate"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 63 68 13 F0 66 0F 05 D1 22 68 04 4B 9A 42 01 D1 01 28 01 D0 BD E8 18 88 ?? ?? ?? ?? FE DE 63 73 6D E0 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 136
		refs = "000a _set_app_type 000e _get_startup_file_mode 0012 _set_fmode 0016 _get_startup_commit_mode 001c __p__commode 0024 __scrt_initialize_onexit_tables 002a _RTC_Initialize 0030 atexit 0034 _get_startup_argv_mode 0038 _configure_narrow_argv 003e ?__scrt_initialize_type_info@@YAXXZ 0042 __scrt_is_user_matherr_present 004a __setusermatherr 004e _initialize_invalid_parameter_handler 0052 _initialize_denormal_control 0056 _get_startup_thread_locale_mode 005a _configthreadlocale 005e _should_initialize_environment 0064 _initialize_narrow_environment 0068 __scrt_initialize_winrt 0074 __scrt_fastfail 0080 _matherr 0084 _RTC_Terminate"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 04 60 01 20 ?? ?? ?? ?? 18 B3 ?? ?? ?? ?? 15 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 B9 ?? ?? ?? ?? ?? ?? ?? ?? 10 B1 0D 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 B1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 BD E8 18 88 07 20 ?? ?? ?? ?? 07 20 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 136
		refs = "000a _set_app_type 000e _get_startup_file_mode 0012 _set_fmode 0016 _get_startup_commit_mode 001c __p__commode 0024 __scrt_initialize_onexit_tables 002a _RTC_Initialize 0030 atexit 0034 _get_startup_argv_mode 0038 _configure_wide_argv 003e ?__scrt_initialize_type_info@@YAXXZ 0042 __scrt_is_user_matherr_present 004a __setusermatherr 004e _initialize_invalid_parameter_handler 0052 _initialize_denormal_control 0056 _get_startup_thread_locale_mode 005a _configthreadlocale 005e _should_initialize_environment 0064 _initialize_wide_environment 0068 __scrt_initialize_winrt 0074 __scrt_fastfail 0080 _matherr 0084 _RTC_Terminate"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 04 60 01 20 ?? ?? ?? ?? 18 B3 ?? ?? ?? ?? 15 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 B9 ?? ?? ?? ?? ?? ?? ?? ?? 10 B1 0D 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 B1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 BD E8 18 88 07 20 ?? ?? ?? ?? 07 20 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 260
		refs = "000c __scrt_initialize_crt 0014 __scrt_fastfail 001c __scrt_acquire_startup_lock 003a _initterm_e 004a _initterm 005a __scrt_release_startup_lock 005e __scrt_get_dyn_tls_init_callback 0068 __scrt_is_nonwritable_in_current_image 0072 _guard_check_icall 007e __scrt_get_dyn_tls_dtor_callback 0090 _register_thread_local_exe_atexit_callback 0094 _get_initial_narrow_environment 009a __p___argv 00a0 __p___argc 00aa main 00b0 __scrt_is_managed_app 00b8 exit 00be _cexit 00c6 __scrt_uninitialize_crt 00d8 _exit 00e0 _c_exit 00f0 __xc_a 00f4 __xc_z 00f8 __xi_a 00fc __xi_z 0100 __scrt_current_native_startup_state"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 01 20 ?? ?? ?? ?? 10 B9 07 20 ?? ?? ?? ?? 00 26 3E 70 ?? ?? ?? ?? 05 46 37 4C 23 68 01 2B 02 D1 07 20 ?? ?? ?? ?? 83 B9 01 23 23 60 31 49 2F 48 ?? ?? ?? ?? 10 B1 FF 24 7C 60 50 E0 2B 49 29 48 ?? ?? ?? ?? 02 23 23 60 01 E0 01 26 3E 70 28 46 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 23 68 53 B1 ?? ?? ?? ?? 38 B1 24 68 20 46 ?? ?? ?? ?? 00 20 02 21 00 22 A0 47 ?? ?? ?? ?? 04 46 23 68 2B B1 ?? ?? ?? ?? 10 B1 20 68 ?? ?? ?? ?? ?? ?? ?? ?? 05 46 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 21 68 00 68 2A 46 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 10 B9 20 46 ?? ?? ?? ?? 0E B9 ?? ?? ?? ?? 00 21 01 20 ?? ?? ?? ?? 7C 60 0C E0 04 46 ?? ?? ?? ?? 10 B9 20 46 ?? ?? ?? ?? 3B 78 1B B9 ?? ?? ?? ?? 00 E0 7C 68 20 46 BD E8 FC 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 260
		refs = "000c __scrt_initialize_crt 0014 __scrt_fastfail 001c __scrt_acquire_startup_lock 003a _initterm_e 004a _initterm 005a __scrt_release_startup_lock 005e __scrt_get_dyn_tls_init_callback 0068 __scrt_is_nonwritable_in_current_image 0072 _guard_check_icall 007e __scrt_get_dyn_tls_dtor_callback 0090 _register_thread_local_exe_atexit_callback 0094 _get_initial_wide_environment 009a __p___wargv 00a0 __p___argc 00aa wmain 00b0 __scrt_is_managed_app 00b8 exit 00be _cexit 00c6 __scrt_uninitialize_crt 00d8 _exit 00e0 _c_exit 00f0 __xc_a 00f4 __xc_z 00f8 __xi_a 00fc __xi_z 0100 __scrt_current_native_startup_state"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 01 20 ?? ?? ?? ?? 10 B9 07 20 ?? ?? ?? ?? 00 26 3E 70 ?? ?? ?? ?? 05 46 37 4C 23 68 01 2B 02 D1 07 20 ?? ?? ?? ?? 83 B9 01 23 23 60 31 49 2F 48 ?? ?? ?? ?? 10 B1 FF 24 7C 60 50 E0 2B 49 29 48 ?? ?? ?? ?? 02 23 23 60 01 E0 01 26 3E 70 28 46 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 23 68 53 B1 ?? ?? ?? ?? 38 B1 24 68 20 46 ?? ?? ?? ?? 00 20 02 21 00 22 A0 47 ?? ?? ?? ?? 04 46 23 68 2B B1 ?? ?? ?? ?? 10 B1 20 68 ?? ?? ?? ?? ?? ?? ?? ?? 05 46 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 21 68 00 68 2A 46 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 10 B9 20 46 ?? ?? ?? ?? 0E B9 ?? ?? ?? ?? 00 21 01 20 ?? ?? ?? ?? 7C 60 0C E0 04 46 ?? ?? ?? ?? 10 B9 20 46 ?? ?? ?? ?? 3B 78 1B B9 ?? ?? ?? ?? 00 E0 7C 68 20 46 BD E8 FC 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 38
		refs = "0008 _get_initial_narrow_environment 000e __p___argv 0014 __p___argc 001e main"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 05 46 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 00 68 21 68 2A 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_218_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 38
		refs = "0008 _get_initial_wide_environment 000e __p___wargv 0014 __p___argc 001e wmain"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 05 46 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 00 68 21 68 2A 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "_FindPESection"
		size = 58
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B C3 6B 00 24 1A 18 93 8A D5 88 13 44 03 F1 18 00 55 B1 C2 68 91 42 03 D3 83 68 13 44 99 42 06 D3 64 1C 28 30 AC 42 F4 D3 00 20 BD E8 30 88 BD E8 30 88 }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "_IsNonwritableInCurrentImage"
		size = 76
		refs = "000c __ImageBase 0016 _ValidateImageBase 0026 _FindPESection"
	strings:
		$1 = { 2D E9 B8 48 0D F1 10 0B 6F 46 04 46 ?? ?? ?? ?? C0 F2 00 05 28 46 ?? ?? ?? ?? 10 B9 00 20 38 60 12 E0 61 1B 28 46 ?? ?? ?? ?? 10 B9 00 20 38 60 0A E0 43 6A 00 2B 01 DB 01 20 00 E0 00 20 38 60 02 E0 00 20 00 E0 38 68 BD E8 B8 88 }
	condition:
		$1
}

rule file_159_3_0 {
	meta:
		name = "_ValidateImageBase"
		size = 52
	strings:
		$1 = { 2D E9 00 48 EB 46 02 88 45 F6 4D 23 9A 42 02 D0 00 20 BD E8 00 88 C3 6B 1A 58 19 18 44 F2 50 53 9A 42 F5 D1 0A 8B 40 F2 0B 13 9A 42 F0 D1 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "_guard_icall_checks_enforced"
		size = 40
		refs = "0020 _guard_check_icall_nop 0024 __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4B 1A 68 BF F3 5B 8F 04 4B 9A 42 18 BF 01 20 08 BF 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__fphelper_raise_exception"
		size = 628
		refs = "0008 __security_push_cookie 024e __security_pop_cookie 025c __imp_RaiseException"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 84 B0 6F 46 98 46 96 46 5D F8 80 49 6C 46 0F 34 24 F0 0F 09 C7 F8 04 90 F1 EE 10 2A 96 08 06 F4 00 15 02 F4 80 04 6F F3 1F 31 2C 43 49 01 41 EA 54 54 D9 F8 00 10 04 25 00 F0 08 03 6F F3 10 01 21 43 C9 F8 00 10 05 EA 90 01 01 24 19 43 3A 60 00 F0 02 03 00 EA 04 02 43 EA 82 03 9B 00 43 EA 91 02 D9 F8 04 30 4F F4 80 61 4F F4 00 6A 23 F0 1F 03 1A 43 00 EA 05 03 38 68 13 43 C9 F8 04 30 00 EA 0A 03 06 EA 01 02 1A 43 00 EA 01 03 4F F4 00 75 43 EA 92 02 00 EA 05 03 43 EA 92 02 00 F4 80 73 43 EA 92 02 D9 F8 08 30 23 F0 1F 03 43 EA 12 13 C9 F8 08 30 00 F0 02 03 00 EA 04 02 43 EA 82 01 06 F0 04 02 08 26 00 EA 06 03 13 43 9B 08 43 EA 81 02 D9 F8 0C 30 23 F0 1F 03 1A 43 00 F0 04 03 13 43 C9 F8 0C 30 BB 6B 38 6C C9 F8 10 30 FB 6B C9 F8 14 30 D9 F8 20 30 83 EA 4E 03 03 F0 1E 02 D9 F8 20 30 53 40 23 43 C9 F8 20 30 D9 F8 40 30 A3 43 C9 F8 40 30 C9 F8 50 00 79 6C C9 F8 54 10 D9 F8 60 30 83 EA 48 03 03 F0 1E 02 D9 F8 60 30 53 40 23 43 C9 F8 60 30 D9 F8 0C 30 10 22 13 42 08 D0 D9 F8 08 30 13 42 04 D0 45 48 02 26 4F F0 04 08 2C E0 D9 F8 0C 30 33 42 05 D0 D9 F8 08 30 33 42 01 D0 3E 48 F1 E7 D9 F8 0C 30 4F F0 04 08 13 EA 08 0F 07 D0 D9 F8 08 30 13 EA 08 0F 02 D0 36 48 02 26 13 E0 D9 F8 0C 30 02 26 33 42 05 D0 D9 F8 08 30 33 42 01 D0 2F 48 08 E0 D9 F8 0C 30 23 42 4B D0 D9 F8 08 30 23 42 47 D0 29 48 27 4C 3B 1D BB 60 24 68 17 F1 08 03 01 22 00 21 A0 47 22 4B 3A 68 1A 40 D9 F8 08 30 13 F0 10 0F 04 D0 4F F4 40 75 4F F4 80 71 00 E0 00 21 D9 F8 08 30 13 F0 08 0F D9 F8 08 30 08 BF 0D 46 2A 43 13 EA 08 0F 04 D0 4F F4 40 6A 4F F4 80 63 00 E0 00 23 43 EA 02 00 D9 F8 08 30 33 42 01 D0 4A EA 02 00 D9 F8 08 30 01 22 13 42 02 D0 4F F4 80 51 00 E0 00 21 D9 F8 00 30 1A 40 33 40 43 EA 82 03 41 EA 43 53 03 43 E1 EE 10 3A D9 E9 14 01 BD 46 04 B0 ?? ?? ?? ?? BD E8 F0 8F FE DE FF E0 3F FF ?? ?? ?? ?? 8F 00 00 C0 93 00 00 C0 91 00 00 C0 8E 00 00 C0 90 00 00 C0 }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "__helper_divide_by_0"
		size = 36
		refs = "0020 __imp_RaiseException"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4C 04 48 00 23 24 68 00 22 00 21 A0 47 BD E8 18 88 FE DE 94 00 00 C0 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "??2@YAPAXI@Z"
		size = 50
		refs = "000e _callnewh 001a ?__scrt_throw_std_bad_array_new_length@@YAXXZ 0020 ?__scrt_throw_std_bad_alloc@@YAXXZ 0026 malloc"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 0B E0 20 46 ?? ?? ?? ?? 38 B9 B4 F1 FF 3F 02 D1 ?? ?? ?? ?? 01 E0 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 00 28 EE D0 BD E8 18 88 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "__security_init_cookie"
		size = 136
		refs = "006c __security_cookie_complement 0070 __imp_QueryPerformanceCounter 0074 __imp_GetCurrentProcessId 0078 __imp_GetCurrentThreadId 007c __imp_GetSystemTimeAsFileTime 0084 __security_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 86 B0 1E 4C 00 23 1C 4D CD E9 02 33 23 68 AB 42 22 D1 18 4B 02 A8 1B 68 98 47 DD E9 02 32 53 40 00 93 13 4B 1B 68 98 47 00 9B 43 40 00 93 0F 4B 1B 68 98 47 00 9B 43 40 00 93 0B 4B 04 A8 1B 68 98 47 DD E9 04 32 5A 40 00 9B 5A 40 6B 46 53 40 AB 42 08 BF 6B 1C 23 60 02 4A DB 43 13 60 06 B0 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 4E E6 40 BB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_60_0 {
	meta:
		name = "?exp@?$VExp@M@@SA?AT__n128@@T2@@Z"
		size = 396
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00f8 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 015c ?eps@?$VExp@M@@0T__n128@@B 0160 ?smallx@?$VExp@M@@0T__n128@@B 0164 ?inf@?$VectorOp@M@@2T__n128@@B 0168 ?bigx@?$VExp@M@@0T__n128@@B 016c ?q0@?$VExp@M@@0T__n128@@B 0170 ?q1@?$VExp@M@@0T__n128@@B 0174 ?p0@?$VExp@M@@0T__n128@@B 0178 ?p1@?$VExp@M@@0T__n128@@B 017c ?C1@?$VExp@M@@0T__n128@@B 0180 ?C2@?$VExp@M@@0T__n128@@B 0184 ?inv_ln2@?$VExp@M@@0T__n128@@B"
		altNames = "__vdecl_expf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 0E 8B 8C B0 9F ED 5E 8A 20 EF 50 A1 8D EC 04 AB B0 EE 48 0A ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A 0D F1 10 0C CC EC 04 0B ?? ?? ?? ?? 53 4B 60 EF 50 01 0D F1 20 0C CC EC 04 0B D3 EC 04 0B B0 EE 48 0A 0A FF 70 CD ?? ?? ?? ?? B6 EE 00 EA 20 EF 50 A1 B0 EE 4E 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C AE FB FF 60 27 43 4B 9D EC 04 CB B0 EE 4E 0A F9 FF E2 03 10 FF F2 A1 D3 EC 04 0B 3C 4B FB FF 4A 46 44 FF F0 2D D3 EC 04 0B 38 4B 44 FF F0 0D 6C EF 60 0D 60 EF E2 4D D3 EC 04 0B 32 4B 44 FF F4 6D 46 FF F0 2D D3 EC 04 0B 2E 4B 42 EF E0 0D 40 FF F4 8D D3 EC 04 0B 29 4B 46 FF F0 2D D3 EC 04 0B 42 EF E0 0D 60 EF E8 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 08 FF F0 8D ?? ?? ?? ?? 01 20 00 EF 48 8D ?? ?? ?? ?? 6A EF 40 08 19 4B F7 EF 70 05 68 EF 60 28 D3 EC 04 0B 15 4B 6C FF 60 4E D3 EC 04 0B 11 4B 50 FF F2 41 D3 EC 04 0B 0E 4B 60 FF CC 2E 0D F1 10 0C DC EC 04 0B 50 FF F4 21 D3 EC 04 0B 0D F1 20 0C DC EC 04 4B 60 FF DC 0E 54 FF F2 01 0C EF 4C 0E 10 FF DC 01 0C B0 BD EC 0E 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_212_1_0 {
	meta:
		name = "__security_pop_cookie"
		size = 28
		refs = "0000 __security_cookie"
	strings:
		$1 = { ?? ?? ?? ?? C0 F2 00 0C 00 9B DC F8 00 C0 AD EB 03 03 63 45 01 D1 01 B0 70 47 18 46 }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "__ppgsfailure"
		size = 24
		refs = "000c __security_check_cookie"
	strings:
		$1 = { 10 B5 6C 46 EC 46 2C F0 07 0C E5 46 ?? ?? ?? ?? A5 46 BD E8 10 40 70 47 }
	condition:
		$1
}

rule file_214_2_0 {
	meta:
		name = "_RTC_InitBase"
		size = 36
		refs = "0016 _RTC_SetErrorFuncW 0020 ?init@?1??_RTC_InitBase@@9@4_NA"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4A 13 78 33 B9 01 23 13 70 00 20 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "??1type_info@@UAA@XZ"
		size = 20
		refs = "0010 ??_7type_info@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_38_2 {
	meta:
		name = "??0?$basic_ios@DU?$char_traits@D@std@@@std@@IAA@XZ"
		size = 20
		refs = "0010 ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_52_1 {
	meta:
		name = "??0?$basic_ios@GU?$char_traits@G@std@@@std@@IAA@XZ"
		size = 20
		refs = "0010 ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_38_2 {
	meta:
		name = "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAA@XZ"
		size = 20
		refs = "0010 ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_11_3 {
	meta:
		name = "??0DNameNode@@IAA@XZ"
		size = 20
		refs = "0010 ??_7DNameNode@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_122_1 {
	meta:
		name = "??0_Facet_base@std@@QAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_101_1 {
	meta:
		name = "??0ios_base@std@@IAA@XZ"
		size = 20
		refs = "0010 ??_7ios_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_59_1 {
	meta:
		name = "??1?$_Ref_count_obj@V__ExceptionPtr@@@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_60_1 {
	meta:
		name = "??1?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_103_2 {
	meta:
		name = "??1?$codecvt@DDU_Mbstatet@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_347_1 {
	meta:
		name = "??1?$codecvt@GDU_Mbstatet@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_102_2 {
	meta:
		name = "??1?$codecvt@_WDU_Mbstatet@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_160_1 {
	meta:
		name = "??1?$messages@D@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_353_1 {
	meta:
		name = "??1?$messages@G@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_304_2 {
	meta:
		name = "??1?$messages@_W@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_132_2 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_305_2 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_356_1 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_133_2 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_357_1 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_358_1 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_83_2 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_363_1 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_364_1 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_100_1 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_315_2 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_366_1 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_169_1 {
	meta:
		name = "??1_Facet_base@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_72_1 {
	meta:
		name = "??1_Generic_error_category@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_108_2 {
	meta:
		name = "??1_Iostream_error_category@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_62_1 {
	meta:
		name = "??1_Ref_count_base@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_69_2 {
	meta:
		name = "??1_System_error_category@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_136_1 {
	meta:
		name = "??1codecvt_base@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_137_1 {
	meta:
		name = "??1ctype_base@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_60_2 {
	meta:
		name = "??1error_category@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_141_1 {
	meta:
		name = "??1facet@locale@std@@MAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_387_1 {
	meta:
		name = "??1messages_base@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_388_1 {
	meta:
		name = "??1money_base@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_390_1 {
	meta:
		name = "??1time_base@std@@UAA@XZ"
		size = 20
		refs = "0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "??_Gtype_info@@UAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7type_info@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 0C 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_76_1 {
	meta:
		name = "??_G_Ref_count_base@std@@UAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 0C 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__dyn_tls_init"
		size = 60
		refs = "001e _guard_check_icall 002a terminate 0034 __xd_z 0038 __xd_a"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 6F 46 02 29 0F D1 0A 4B 1C 1D 08 4E B4 42 07 D0 25 68 1D B1 28 46 ?? ?? ?? ?? A8 47 24 1D F5 E7 01 E0 ?? ?? ?? ?? BD E8 F0 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_2_0 {
	meta:
		name = "dyntls_init_exception_filter"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 98 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 FE DE 63 73 6D E0 }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "_Dtento"
		size = 284
		refs = "000c __security_push_cookie 0036 _Xp_setw 0044 _Xp_movx 004e _Xp_ldexpx 006c _Xp_mulx 00b2 _Xp_getw 00e2 _errno 0108 __security_pop_cookie 0114 _Inf 0118 tenth"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 02 8B ?? ?? ?? ?? A3 B0 0C 46 00 2C 16 46 05 46 6C D0 90 ED 00 0B B5 EE 40 0B F1 EE 10 FA 65 D0 00 2C 06 DD 02 A8 04 21 B2 EE 04 0B ?? ?? ?? ?? 0A E0 36 4A 02 A8 04 21 64 42 ?? ?? ?? ?? 68 22 04 21 28 46 ?? ?? ?? ?? 12 AF 0D F1 48 08 4F F0 01 09 14 EA 09 0F 06 D0 04 23 02 AA 04 21 28 46 00 97 ?? ?? ?? ?? 64 10 0D D0 02 AA 04 21 0A A8 ?? ?? ?? ?? 04 23 0A AA 04 21 02 A8 CD F8 00 80 ?? ?? ?? ?? E5 E7 9D ED 02 1B B7 EE 00 0B B4 EE C0 1B F1 EE 10 FA 05 D2 6F F0 67 02 04 21 28 46 ?? ?? ?? ?? 04 21 28 46 ?? ?? ?? ?? B5 EE 40 0B B0 EE 40 8B F1 EE 10 FA 0E D0 13 4B 93 ED 00 0B B4 EE 40 8B F1 EE 10 FA 06 D0 B1 EE 40 0B B4 EE 40 8B F1 EE 10 FA 0F D1 ?? ?? ?? ?? 22 23 03 60 56 B1 33 68 43 EA 09 03 33 60 05 E0 04 21 28 46 ?? ?? ?? ?? B0 EE 40 8B B0 EE 48 0B 23 B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_0_1 {
	meta:
		name = "_LDtento"
		size = 284
		refs = "000c __security_push_cookie 0036 _LXp_setw 0044 _LXp_movx 004e _LXp_ldexpx 006c _LXp_mulx 00b2 _LXp_getw 00e2 _errno 0108 __security_pop_cookie 0114 _LInf 0118 tenth"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 02 8B ?? ?? ?? ?? A3 B0 0C 46 00 2C 16 46 05 46 6C D0 90 ED 00 0B B5 EE 40 0B F1 EE 10 FA 65 D0 00 2C 06 DD 02 A8 04 21 B2 EE 04 0B ?? ?? ?? ?? 0A E0 36 4A 02 A8 04 21 64 42 ?? ?? ?? ?? 68 22 04 21 28 46 ?? ?? ?? ?? 12 AF 0D F1 48 08 4F F0 01 09 14 EA 09 0F 06 D0 04 23 02 AA 04 21 28 46 00 97 ?? ?? ?? ?? 64 10 0D D0 02 AA 04 21 0A A8 ?? ?? ?? ?? 04 23 0A AA 04 21 02 A8 CD F8 00 80 ?? ?? ?? ?? E5 E7 9D ED 02 1B B7 EE 00 0B B4 EE C0 1B F1 EE 10 FA 05 D2 6F F0 67 02 04 21 28 46 ?? ?? ?? ?? 04 21 28 46 ?? ?? ?? ?? B5 EE 40 0B B0 EE 40 8B F1 EE 10 FA 0E D0 13 4B 93 ED 00 0B B4 EE 40 8B F1 EE 10 FA 06 D0 B1 EE 40 0B B4 EE 40 8B F1 EE 10 FA 0F D1 ?? ?? ?? ?? 22 23 03 60 56 B1 33 68 43 EA 09 03 33 60 05 E0 04 21 28 46 ?? ?? ?? ?? B0 EE 40 8B B0 EE 48 0B 23 B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_0_1 {
	meta:
		name = "_Wcsxfrm"
		size = 152
		refs = "001e ___lc_locale_name_func 0034 memcpy 003e _malloc_base 0056 __crtLCMapStringW 008e _free_base"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 9B 1A 5D 10 0C 9B 09 1A 92 46 80 46 4F EA 61 09 6F F0 00 04 1B B9 ?? ?? ?? ?? 47 68 00 E0 5F 68 47 B9 4D 45 04 D8 6A 00 51 46 40 46 ?? ?? ?? ?? 2C 46 2A E0 48 46 ?? ?? ?? ?? 06 46 2E B3 2B 46 52 46 4F F4 80 61 38 46 CD F8 04 90 00 96 ?? ?? ?? ?? 04 46 74 B9 00 23 01 93 00 93 2B 46 52 46 4F F4 80 61 38 46 ?? ?? ?? ?? 04 46 54 B9 6F F0 00 44 07 E0 00 22 2C B1 93 5D 52 1C A2 42 28 F8 02 3B F9 D3 30 46 ?? ?? ?? ?? 20 46 BD E8 FE 8F }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "_Strxfrm"
		size = 138
		refs = "001c ___lc_locale_name_func 0022 ___lc_collate_cp_func 003c memcpy 005a __crtLCMapStringA"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 85 B0 9C 1A 0E 9B 91 46 82 46 A1 EB 00 08 6F F0 00 05 33 B9 ?? ?? ?? ?? 46 68 ?? ?? ?? ?? 07 46 01 E0 D3 E9 00 76 4E B9 47 B9 44 45 04 D8 22 46 49 46 50 46 ?? ?? ?? ?? 25 46 1E E0 01 23 03 93 00 23 01 93 00 93 23 46 4A 46 4F F4 80 61 30 46 02 97 ?? ?? ?? ?? 80 B1 05 46 40 45 0D DC 01 23 03 93 23 46 4A 46 4F F4 80 61 30 46 02 97 CD F8 04 80 CD F8 00 A0 ?? ?? ?? ?? 28 46 05 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_3_0_1 {
	meta:
		name = "_Dscale"
		size = 400
		refs = "0038 _Dnorm 018c _Inf"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 07 46 FA 88 47 F6 F0 73 40 F2 FF 75 13 40 18 09 A8 42 0C 46 0A D1 12 F0 0F 0F 05 D1 BB 88 1B B9 7B 88 0B B9 3B 88 C3 B1 02 20 A9 E0 28 B9 38 46 ?? ?? ?? ?? 00 28 00 F3 A2 80 00 2C 0F DD 2B 1A A3 42 0C DC B7 F9 06 30 00 2B 4E 4B 93 ED 00 0B 01 DA B1 EE 40 0B 87 ED 00 0B 01 20 90 E0 43 42 A3 42 0A DA FA 88 48 F2 0F 03 01 19 13 40 43 EA 01 13 FB 80 6F F0 00 00 82 E0 FB 88 4F F4 00 49 10 25 03 EA 09 08 03 F0 0F 03 2B 43 FB 80 03 19 5A 1E 02 F1 35 03 34 2B 6B D8 11 B2 E9 42 4F F0 00 0E 15 DC 00 22 3B 88 BE F1 00 0F 18 BF 01 20 08 BF 00 20 40 EA 03 0E 7B 88 3B 80 BB 88 7B 80 FB 88 FA 80 BB 80 01 F1 10 03 19 B2 E9 42 EA DD 4B 42 18 B2 30 B3 39 88 BE F1 00 0F C0 F1 10 06 18 BF 01 22 7C 88 01 FA 06 F3 08 BF 00 22 13 43 85 B2 1F FA 83 FE B8 88 21 FA 05 F3 04 FA 06 F2 13 43 3B 80 F9 88 24 FA 05 F3 00 FA 06 F2 13 43 7B 80 20 FA 05 F3 01 FA 06 F2 13 43 BB 80 21 FA 05 F3 FB 80 FB 88 CE 45 48 EA 03 02 FA 80 04 D8 14 D1 3B 88 13 F0 01 0F 10 D0 3B 88 5B 1C 9B B2 3B 80 5B B9 7B 88 5B 1C 9B B2 7B 80 33 B9 BB 88 5B 1C 9B B2 BB 80 0B B9 53 1C 8A E7 42 45 89 D1 BB 88 00 2B 86 D1 7B 88 00 2B 83 D1 3B 88 33 B1 80 E7 00 22 BA 80 7A 80 3A 80 A7 F8 06 80 00 20 BD E8 F0 8B ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_0_1 {
	meta:
		name = "?_New_handler_interface@std@@YAHI@Z"
		size = 32
		refs = "000e _guard_check_icall 001c ?_New_handler@std@@3P6AXXZA"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 4B 1C 68 20 46 ?? ?? ?? ?? A0 47 01 20 BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_1_1 {
	meta:
		name = "?get_new_handler@std@@YAP6AXXZXZ"
		size = 48
		refs = "0016 ??0_Lockit@std@@QAA@H@Z 0020 ??1_Lockit@std@@QAA@XZ 002c ?_New_handler@std@@3P6AXXZA"
	strings:
		$1 = { 2D E9 9F 48 0D F1 18 0B 6F 46 6F F0 01 03 38 46 01 21 C7 E9 02 33 ?? ?? ?? ?? 04 4B 38 46 1C 68 ?? ?? ?? ?? 20 46 04 B0 BD E8 90 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_2_1 {
	meta:
		name = "?set_new_handler@std@@YAP6AXXZP6AXXZ@Z"
		size = 72
		refs = "001a ??0_Lockit@std@@QAA@H@Z 002c _set_new_handler 0032 ??1_Lockit@std@@QAA@XZ 0040 ?_New_handler_interface@std@@YAHI@Z 0044 ?_New_handler@std@@3P6AXXZA"
	strings:
		$1 = { 2D E9 B0 48 0D F1 0C 0B 85 B0 6F 46 04 46 6F F0 01 03 38 46 01 21 C7 E9 02 33 ?? ?? ?? ?? 09 4B 1D 68 1C 60 0C B1 06 48 00 E0 00 20 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? 28 46 05 B0 BD E8 B0 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_1 {
	meta:
		name = "_FDint"
		size = 144
		refs = "008c ?mask@?3??_FDint@@9@9"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 6A 88 02 F4 FF 43 D8 09 FF 28 08 D1 12 F0 7F 0F 03 D1 2B 88 0B B9 01 20 31 E0 02 20 2F E0 32 F4 00 43 01 D1 2B 88 4B B3 C0 F1 96 03 5B 1A 1E B2 00 2E 23 DD 18 2E 07 DB 02 F4 00 43 6B 80 00 23 2B 80 6F F0 00 00 1A E0 0E 49 34 11 0B 46 20 33 53 F8 24 00 06 F0 0F 03 31 F8 13 30 35 F8 10 20 00 2C 03 EA 02 01 82 EA 01 03 25 F8 10 30 03 DD 2B 88 19 43 00 23 2B 80 00 29 E2 D1 00 20 BD E8 78 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_0_1 {
	meta:
		name = "?_MP_Add@std@@YAXQA_K_K@Z"
		size = 34
		refs = "001a ?add@std@@YAXPA_KH0H@Z"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 00 92 02 93 00 22 00 23 01 92 03 93 6A 46 02 23 05 21 ?? ?? ?? ?? BD E8 0F 88 }
	condition:
		$1
}

rule file_6_1_1 {
	meta:
		name = "?_MP_Get@std@@YA_KQA_K@Z"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 9A 68 D3 E9 00 03 D1 18 BD E8 00 88 }
	condition:
		$1
}

rule file_6_2_1 {
	meta:
		name = "?_MP_Mul@std@@YAXQA_K_K1@Z"
		size = 198
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8B B0 08 93 00 23 09 93 14 9B 06 92 00 22 02 93 00 23 03 93 15 9B 07 92 04 46 04 93 00 23 00 F1 08 02 01 46 05 93 9E 46 C4 E9 00 33 02 F1 20 00 51 F8 04 3B 42 F8 04 3B 82 42 F9 D1 02 AB A3 EB 04 08 02 25 CD E9 00 58 08 EB 04 03 D3 E9 00 67 56 EA 07 03 02 D1 C4 E9 04 EE 29 E0 00 20 0D F1 18 0A 86 46 A1 46 4F F0 02 08 00 25 DA E9 00 13 0A F1 08 0A 03 FB 06 F3 01 FB 07 32 A1 FB 06 13 13 44 09 18 43 EB 0E 00 D9 E9 00 32 4F F0 00 0E 5B 18 42 41 C9 E9 00 32 C9 F8 04 50 09 F1 08 09 10 46 B8 F1 01 08 E1 D1 DD E9 00 58 C4 E9 04 0E 08 34 6D 1E 00 95 C7 D1 0B B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_6_3_1 {
	meta:
		name = "?_MP_Rem@std@@YAXQA_K_K@Z"
		size = 702
		refs = "006c __rt_udiv64 0252 ?add@std@@YAXPA_KH0H@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 93 B0 0E 92 00 22 02 27 CD E9 0F 23 11 92 80 46 08 90 05 97 1B 00 07 D1 12 A9 08 39 51 E9 02 23 7F 1E 13 43 F9 D0 05 97 D8 E9 08 23 05 20 13 43 07 D1 08 F1 28 01 08 39 51 E9 02 23 40 1E 13 43 F9 D0 0E AB 03 EB C7 03 53 E9 02 23 A0 EB 07 09 CD F8 04 90 50 1C 43 F1 00 01 01 23 00 22 08 B9 01 B9 F9 DE ?? ?? ?? ?? 8E 46 09 91 82 46 0C 90 01 28 00 D1 A9 B3 00 26 B1 46 45 46 05 20 D5 E9 00 43 03 FB 0A F3 04 FB 0E 32 A4 FB 0A 13 13 44 8A 19 43 F1 00 03 C5 E9 00 23 C5 F8 04 90 08 35 40 1E 1E 46 EB D1 DD F8 04 90 00 25 00 2F 18 DD 0E A8 3C 46 A8 46 D0 E9 00 12 0E FB 01 F3 0A FB 02 32 AA FB 01 13 13 44 4A 19 43 F1 00 03 C0 E9 00 23 C0 F8 04 80 08 30 64 1E 1D 46 EB D1 DD F8 20 80 B9 F1 00 0F C0 F2 C4 80 BA 1E 0E AB 03 EB C2 03 0A 93 0E AB 03 EB C7 03 53 E9 02 04 08 EB C9 03 CD E9 02 30 07 EB 09 03 08 EB C3 06 04 94 56 F8 08 19 D6 E9 00 23 00 96 0B 44 21 46 08 B9 01 B9 F9 DE ?? ?? ?? ?? 98 46 96 46 CD E9 06 10 50 EA 01 04 00 F0 8D 80 DD E9 03 32 0A 9F B1 46 6F F0 00 04 01 29 16 D8 15 D2 59 E9 02 A4 3D 68 0E EB 04 06 7C 68 04 FB 00 F3 05 FB 01 32 A5 FB 00 43 13 44 B3 42 13 D3 01 D8 54 45 10 D9 DD E9 03 32 6F F0 00 04 00 19 61 41 1E EB 03 0E 48 EB 02 08 B8 F1 01 0F DD D3 02 D8 BE F1 00 0F D9 D3 05 9F DD F8 04 90 00 24 00 25 00 2F CD E9 06 10 56 DD 02 9B 0D F1 38 0A B8 46 1E 46 8E 46 A9 46 01 27 DA E9 00 13 03 FB 00 F3 01 FB 0E 32 A1 FB 00 13 D0 18 D6 E9 00 32 5B 1A 82 41 1B 1B AA 41 14 46 C6 E9 00 32 00 25 23 00 02 D0 64 42 67 EB 05 05 C6 F8 04 90 07 98 08 36 B8 F1 01 08 0A F1 08 0A DE D1 05 9F DD E9 00 69 54 EA 05 03 28 D0 07 EB 09 00 06 F1 08 01 00 26 4F F0 01 09 05 28 12 DA D1 E9 00 32 1B 1B AA 41 14 46 C1 E9 00 32 00 25 23 00 02 D0 64 42 69 EB 05 05 4E 60 08 31 40 1C 54 EA 05 03 EA D1 DD E9 00 69 54 EA 05 03 07 D0 02 98 0E AA 3B 46 79 1C ?? ?? ?? ?? 00 E0 00 9E DD E9 02 30 A9 F1 01 09 04 9C 08 3B CD E9 01 93 B9 F1 00 0F BF F6 53 AF DD E9 08 8E DD F8 30 A0 BA F1 01 0F 02 D1 BE F1 00 0F 18 D0 00 23 00 26 0D 93 04 25 08 F1 20 04 74 E8 02 23 71 46 50 46 33 44 08 B9 01 B9 F9 DE ?? ?? ?? ?? 6D 1E DD F8 24 E0 00 2D 16 46 C4 E9 02 01 0D 93 EC DA 13 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_6_4_1 {
	meta:
		name = "?add@std@@YAXPA_KH0H@Z"
		size = 126
	strings:
		$1 = { 2D E9 F8 4F 0D F1 20 0B 1F 46 00 2F 00 91 4F F0 00 0E 32 DD 80 46 A2 EB 00 0A 19 46 F1 46 0A EB 08 02 D2 E9 00 56 D8 E9 00 24 52 19 74 41 12 EB 0E 02 44 F1 00 03 C8 E9 00 23 C8 F8 04 90 08 F1 08 08 9E 46 49 1E EA D1 DD F8 00 90 5F EA 03 03 13 D0 00 EB C7 01 00 20 4F 45 0E DA D1 E9 00 32 13 EB 0E 03 42 F1 00 02 C1 E9 00 32 48 60 08 31 7F 1C 5F EA 02 03 96 46 EE D1 BD E8 F8 8F }
	condition:
		$1
}

rule file_6_5_1 {
	meta:
		name = "?div@std@@YAXQA_K_K@Z"
		size = 66
		refs = "002c __rt_udiv64"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 1E 46 00 23 01 93 17 46 4F F0 00 0E 04 25 00 F1 20 04 74 E8 02 21 38 46 0E EB 01 03 31 46 08 B9 01 B9 F9 DE ?? ?? ?? ?? 6D 1E 00 2D 96 46 C4 E9 02 01 01 93 ED DA BD E8 FC 88 }
	condition:
		$1
}

rule file_6_6_1 {
	meta:
		name = "?limit@std@@YAHPA_KH@Z"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 00 EB C1 00 01 E0 49 1E 08 38 50 E9 02 23 13 43 F9 D0 08 46 BD E8 00 88 }
	condition:
		$1
}

rule file_6_7_1 {
	meta:
		name = "?mul@std@@YAXPA_KH_K@Z"
		size = 60
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 00 27 00 29 14 DD BE 46 D0 E9 00 64 04 FB 02 F4 06 FB 03 45 A6 FB 02 64 2C 44 F5 19 44 F1 00 04 C0 E9 00 54 C0 F8 04 E0 08 30 49 1E 27 46 EB D1 BD E8 F0 88 }
	condition:
		$1
}

rule file_8_0_1 {
	meta:
		name = "_FDnorm"
		size = 128
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 43 88 01 24 03 F0 7F 02 42 80 03 F4 00 47 42 B9 03 88 5B B3 2A B9 9B B2 43 80 00 23 03 80 6F F0 0E 04 42 88 80 2A 0C D2 01 88 53 00 9B B2 43 EA D1 32 4B 00 99 B2 63 1E 1C B2 80 2A F5 D3 42 80 01 80 41 88 4F F4 80 76 B1 42 0B D3 05 88 CB 03 9A B2 63 1C 49 08 1C B2 42 EA 55 05 B1 42 F6 D2 41 80 05 80 43 88 03 F0 7F 02 42 80 42 EA 07 03 43 80 20 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "_FCosh"
		size = 168
		refs = "0016 _FDtest 005c _FExp 008c _Feraise 00a4 _FXbig"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 68 46 B0 EE 60 8A 8D ED 00 0A ?? ?? ?? ?? D8 B3 43 1E 01 2B 36 D9 B5 EE 40 8A F1 EE 10 FA 33 D0 DD ED 00 0A F5 EE C0 0A F1 EE 10 FA 03 D2 F1 EE 60 0A CD ED 00 0A 18 4B 6F F0 00 01 93 ED 00 0A F4 EE C0 0A F1 EE 10 FA 0F D2 B7 EE 00 0A 68 46 ?? ?? ?? ?? DD ED 00 0A B5 EE 00 0A 80 EE 20 0A 30 EE 20 0A 20 EE 08 8A 0E E0 68 46 B0 EE 48 0A ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 00 8A B0 EE 48 0A 02 B0 BD EC 02 8B BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_1 {
	meta:
		name = "_Stoll"
		size = 16
		refs = "000c _Stollx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_0_1 {
	meta:
		name = "_Stod"
		size = 16
		refs = "000c _Stodx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_0_1 {
	meta:
		name = "_Stof"
		size = 16
		refs = "000c _Stofx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_0_1 {
	meta:
		name = "_Stold"
		size = 16
		refs = "000c _Stoldx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_0_1 {
	meta:
		name = "_Stoul"
		size = 16
		refs = "000c _Stoulx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_0_1 {
	meta:
		name = "_Stoull"
		size = 16
		refs = "000c _Stoullx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_0_1 {
	meta:
		name = "_WStod"
		size = 16
		refs = "000c _WStodx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_0_1 {
	meta:
		name = "_WStof"
		size = 16
		refs = "000c _WStofx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_0_1 {
	meta:
		name = "_WStold"
		size = 16
		refs = "000c _WStoldx"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1_1 {
	meta:
		name = "_Stollx"
		size = 180
		refs = "001e isspace 0040 _Stoullx 007e _errno"
	strings:
		$1 = { 2D E9 FC 4B 0D F1 20 0B 0E 46 99 46 90 46 07 46 06 B9 6E 46 38 78 3C 46 01 E0 64 1C 20 78 ?? ?? ?? ?? 00 28 F9 D1 94 F9 00 50 2D 2D 03 D0 2B 2D 18 BF 2B 25 00 D1 64 1C 4B 46 42 46 31 46 20 46 ?? ?? ?? ?? 33 68 9C 42 00 D1 37 60 33 68 6F F0 00 48 6F F0 00 04 9F 42 4F F0 00 46 02 D1 50 EA 01 03 0C D1 2B 2D 04 D1 41 45 08 D8 01 D3 A0 42 05 D8 2D 2D 18 D1 B1 42 11 D3 00 D8 78 B1 ?? ?? ?? ?? 22 23 03 60 B9 F1 00 0F 02 D0 01 23 C9 F8 00 30 2D 2D 08 BF 00 24 08 D0 46 46 06 E0 00 23 44 42 63 EB 01 06 01 E0 04 46 0E 46 20 46 31 46 BD E8 FC 8B }
	condition:
		$1
}

rule file_11_0_1 {
	meta:
		name = "_Poly"
		size = 40
		altNames = "_LPoly"
	strings:
		$1 = { 2D E9 00 48 EB 46 B0 EE 40 1B 90 ED 00 0B 06 E0 08 30 90 ED 00 2B 00 EE 01 2B B0 EE 42 0B 49 1E 00 29 F5 DA BD E8 00 88 }
	condition:
		$1
}

rule file_12_0_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z"
		size = 24
		altNames = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 23 03 60 C0 E9 05 33 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_12_4_1 {
	meta:
		name = "??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 54
		refs = "0010 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ"
		altNames = "?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBA_NABV12@@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 79 0C 46 0B B9 ?? ?? ?? ?? 23 79 13 B9 20 46 ?? ?? ?? ?? 2B 68 00 2B 23 68 03 D1 23 B1 00 20 BD E8 30 88 00 2B FA D0 01 20 F9 E7 }
	condition:
		$1
}

rule file_17_19_1 {
	meta:
		name = "??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 54
		refs = "0010 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 79 0C 46 0B B9 ?? ?? ?? ?? 23 79 13 B9 20 46 ?? ?? ?? ?? 2B 68 00 2B 23 68 03 D1 23 B1 00 20 BD E8 30 88 00 2B FA D0 01 20 F9 E7 }
	condition:
		$1
}

rule file_17_22_1 {
	meta:
		name = "??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 54
		refs = "0010 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 79 0C 46 0B B9 ?? ?? ?? ?? 23 79 13 B9 20 46 ?? ?? ?? ?? 2B 68 00 2B 23 68 03 D1 23 B1 00 20 BD E8 30 88 00 2B FA D0 01 20 F9 E7 }
	condition:
		$1
}

rule file_17_1237_1 {
	meta:
		name = "?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBA_NABV12@@Z"
		size = 54
		refs = "0010 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 79 0C 46 0B B9 ?? ?? ?? ?? 23 79 13 B9 20 46 ?? ?? ?? ?? 2B 68 00 2B 23 68 03 D1 23 B1 00 20 BD E8 30 88 00 2B FA D0 01 20 F9 E7 }
	condition:
		$1
}

rule file_17_1238_1 {
	meta:
		name = "?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBA_NABV12@@Z"
		size = 54
		refs = "0010 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 79 0C 46 0B B9 ?? ?? ?? ?? 23 79 13 B9 20 46 ?? ?? ?? ?? 2B 68 00 2B 23 68 03 D1 23 B1 00 20 BD E8 30 88 00 2B FA D0 01 20 F9 E7 }
	condition:
		$1
}

rule file_12_7_1 {
	meta:
		name = "??$?9DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 54
		refs = "0010 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 79 0C 46 0B B9 ?? ?? ?? ?? 23 79 13 B9 20 46 ?? ?? ?? ?? 2B 68 00 2B 23 68 03 D1 23 B9 00 20 BD E8 30 88 00 2B FA D1 01 20 F9 E7 }
	condition:
		$1
}

rule file_17_25_1 {
	meta:
		name = "??$?9GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 54
		refs = "0010 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 79 0C 46 0B B9 ?? ?? ?? ?? 23 79 13 B9 20 46 ?? ?? ?? ?? 2B 68 00 2B 23 68 03 D1 23 B9 00 20 BD E8 30 88 00 2B FA D1 01 20 F9 E7 }
	condition:
		$1
}

rule file_17_28_1 {
	meta:
		name = "??$?9_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 54
		refs = "0010 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 79 0C 46 0B B9 ?? ?? ?? ?? 23 79 13 B9 20 46 ?? ?? ?? ?? 2B 68 00 2B 23 68 03 D1 23 B9 00 20 BD E8 30 88 00 2B FA D1 01 20 F9 E7 }
	condition:
		$1
}

rule file_12_9_1 {
	meta:
		name = "??$_Find_elem@D@std@@YAIPADD@Z"
		size = 34
	strings:
		$1 = { 2D E9 00 48 EB 46 90 F9 00 20 03 46 04 E0 8A 42 04 D0 5B 1C 93 F9 00 20 00 2A F8 D1 18 1A BD E8 00 88 }
	condition:
		$1
}

rule file_12_10_1 {
	meta:
		name = "??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z"
		size = 450
		refs = "0008 __security_push_cookie 0044 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00ca ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 018c ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAAXXZ 0196 _invalid_parameter_noinfo_noreturn 01a2 ??3@YAXPAX@Z 01ba __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 92 46 6F F0 01 02 C7 E9 04 22 93 F9 00 50 3B 60 89 46 F9 60 80 46 4D B1 2C 46 1E 46 AC 42 01 D1 0A F1 01 0A 16 F9 01 4F 00 2C F7 D1 17 F1 18 00 00 22 51 46 ?? ?? ?? ?? 6F F0 01 03 01 25 BB 60 00 23 39 6B F8 69 00 26 00 24 7B 60 BA F1 00 0F 00 F0 9D 80 D7 F8 2C E0 3A 68 B3 56 6B B1 92 F9 00 20 D7 F8 00 90 93 42 04 D0 76 1C 16 F9 09 30 00 2B F8 D1 D7 F8 0C 90 3A 68 74 45 00 F2 85 80 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 43 B1 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 1E 44 4C E0 3B 68 2E 44 B2 56 93 F9 00 30 9A 42 38 D0 BA B3 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 99 F8 04 30 2B B9 48 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 D8 F8 00 30 00 2B D9 F8 00 30 01 D1 9B B1 00 E0 8B B9 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 3B 68 F2 56 98 F9 05 30 9A 42 02 D1 01 23 7B 60 18 E0 7F 2D 2B 46 28 BF 7F 23 74 45 36 D8 10 29 0B D2 17 F1 1C 00 08 E0 7F 2D 2B 46 28 BF 7F 23 10 29 01 D2 17 F1 1C 00 BC 60 03 55 F8 69 D7 E9 0B E1 7B 68 64 1C 54 45 89 D3 1B B3 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 39 6B F8 69 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? 39 6B F8 69 D8 F8 00 30 00 2B D9 F8 00 30 01 D1 63 B1 00 E0 53 B9 40 46 6D 1C ?? ?? ?? ?? 6F F0 00 03 5B E7 ?? ?? ?? ?? ?? ?? ?? ?? 10 29 01 D3 ?? ?? ?? ?? 0F 23 B8 69 3B 63 00 23 FB 62 3B 77 ?? ?? ?? ?? B8 68 0E B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_12_12_1 {
	meta:
		name = "??$_Getvals@D@?$numpunct@D@std@@IAAXDPBUlconv@@U_Cvtvec@@@Z"
		size = 28
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 13 68 1B 78 03 73 53 68 1B 78 43 73 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_12_14_1 {
	meta:
		name = "??$_Maklocstr@D@std@@YAPADPBDPADABU_Cvtvec@@@Z"
		size = 52
		refs = "000a strlen 0014 calloc 002e ?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 45 1C 28 46 01 21 ?? ?? ?? ?? 48 B1 35 B1 02 1B 23 78 6D 1E 13 55 64 1C 00 2D F9 D1 BD E8 30 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_16_1 {
	meta:
		name = "??$_Pocca@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@ABU10@U?$integral_constant@_N$0A@@0@@Z"
		size = 16
		altNames = "??$_Pocca@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@ABU10@U?$integral_constant@_N$0A@@0@@Z ??$_Pocca@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@ABU10@U?$integral_constant@_N$0A@@0@@Z ??$_Pocma@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@0U?$integral_constant@_N$00@0@@Z ??$_Pocma@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@0U?$integral_constant@_N$00@0@@Z ??$_Pocma@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0U?$integral_constant@_N$00@0@@Z ??$_Pocs@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@0U?$integral_constant@_N$0A@@0@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_12_22_1 {
	meta:
		name = "??$construct@PADAAPAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPAPADAAPAD@Z"
		size = 16
		altNames = "??$construct@PADAAPAD@?$allocator@D@std@@QAAXPAPADAAPAD@Z ??$construct@PADAAPAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPADAAPAD@Z ??$construct@PAGAAPAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAXPAPAGAAPAG@Z ??$construct@PAGAAPAG@?$allocator@G@std@@QAAXPAPAGAAPAG@Z ??$construct@PAGAAPAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAGAAPAG@Z ??$construct@PA_WAAPA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAXPAPA_WAAPA_W@Z ??$construct@PA_WAAPA_W@?$allocator@_W@std@@QAAXPAPA_WAAPA_W@Z ??$construct@PA_WAAPA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_WAAPA_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 B1 13 68 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_12_25_1 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAAXPAU_Container_proxy@1@$$QAU21@@Z"
		size = 20
		altNames = "??$construct@U_Container_proxy@std@@U12@@?$allocator@U_Container_proxy@std@@@std@@QAAXPAU_Container_proxy@1@$$QAU21@@Z ??$construct@U_Container_proxy@std@@U12@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@$$QAU31@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 19 B1 13 68 0B 60 53 68 4B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_12_38_1 {
	meta:
		name = "??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$codecvt@DDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_22_2 {
	meta:
		name = "??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$codecvt@GDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_22_2 {
	meta:
		name = "??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_48_2 {
	meta:
		name = "??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$collate@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$collate@D@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$collate@D@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_125_2 {
	meta:
		name = "??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$collate@G@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$collate@G@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_127_2 {
	meta:
		name = "??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$collate@_W@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$collate@_W@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_40_1 {
	meta:
		name = "??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$ctype@D@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$ctype@D@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_24_2 {
	meta:
		name = "??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$ctype@G@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$ctype@G@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_24_2 {
	meta:
		name = "??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$ctype@_W@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$ctype@_W@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_64_1 {
	meta:
		name = "??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$messages@D@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$messages@D@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_151_1 {
	meta:
		name = "??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$messages@G@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$messages@G@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_135_2 {
	meta:
		name = "??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$messages@_W@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$messages@_W@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_66_1 {
	meta:
		name = "??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_155_1 {
	meta:
		name = "??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_157_1 {
	meta:
		name = "??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_56_2 {
	meta:
		name = "??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_159_1 {
	meta:
		name = "??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_143_2 {
	meta:
		name = "??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_70_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$moneypunct@D$00@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$moneypunct@D$00@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_60_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$moneypunct@D$0A@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_145_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$moneypunct@G$00@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$moneypunct@G$00@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_147_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$moneypunct@G$0A@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_167_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$moneypunct@_W$00@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$moneypunct@_W$00@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_169_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$moneypunct@_W$0A@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_42_1 {
	meta:
		name = "??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_153_2 {
	meta:
		name = "??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_155_2 {
	meta:
		name = "??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_44_1 {
	meta:
		name = "??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_157_2 {
	meta:
		name = "??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_159_2 {
	meta:
		name = "??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_46_1 {
	meta:
		name = "??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$numpunct@D@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$numpunct@D@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_161_2 {
	meta:
		name = "??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$numpunct@G@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$numpunct@G@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_163_2 {
	meta:
		name = "??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$numpunct@_W@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$numpunct@_W@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_74_1 {
	meta:
		name = "??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_165_2 {
	meta:
		name = "??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_167_2 {
	meta:
		name = "??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_76_1 {
	meta:
		name = "??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_187_1 {
	meta:
		name = "??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_189_1 {
	meta:
		name = "??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 224
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0048 ??1_Lockit@std@@QAA@XZ 0068 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0088 ?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0096 ??0bad_cast@std@@QAA@XZ 00a0 _CxxThrowException 00b0 _guard_check_icall 00ba ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00d0 _TI2?AVbad_cast@std@@ 00d4 ?_Id_cnt@id@locale@std@@0HA 00d8 ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 00dc ?_Psave@?$_Facetptr@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8A B0 6F 46 80 46 6F F0 01 03 17 F1 08 00 00 21 C7 E9 04 33 ?? ?? ?? ?? DF F8 B8 90 2C 4D D9 F8 00 60 2C 68 3E 60 74 B9 38 1D 00 21 ?? ?? ?? ?? 2B 68 23 B9 25 4B 1A 68 52 1C 1A 60 2A 60 38 1D ?? ?? ?? ?? 2C 68 D8 F8 04 20 D3 68 9C 42 03 D2 93 68 53 F8 24 50 00 E0 00 25 65 BB 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 50 00 E0 00 25 FD B9 0E B1 35 46 1C E0 38 46 41 46 ?? ?? ?? ?? B0 F1 FF 3F 08 D1 17 F1 18 00 ?? ?? ?? ?? 0D 49 17 F1 18 00 ?? ?? ?? ?? 3D 68 C9 F8 00 50 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 28 46 ?? ?? ?? ?? 17 F1 08 00 ?? ?? ?? ?? 28 46 0A B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_48_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@XZ"
		size = 52
		refs = "0014 ??2@YAPAXI@Z 002e _invalid_parameter_noinfo_noreturn"
		altNames = "??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z ??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@XZ ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 00 23 08 20 23 60 C4 E9 05 33 ?? ?? ?? ?? 48 B1 00 23 00 22 20 60 C0 E9 00 32 23 68 20 46 1C 60 BD E8 18 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_49_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ"
		size = 18
		altNames = "??0?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ ??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 03 60 C0 E9 05 33 BD E8 00 88 }
	condition:
		$1
}

rule file_12_51_1 {
	meta:
		name = "??0?$_Yarn@D@std@@QAA@XZ"
		size = 16
		altNames = "??0task_continuation_context@Concurrency@@AAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 03 60 03 71 BD E8 00 88 }
	condition:
		$1
}

rule file_12_52_1 {
	meta:
		name = "??0?$_Yarn@_W@std@@QAA@XZ"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 03 60 83 80 BD E8 00 88 }
	condition:
		$1
}

rule file_12_55_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z"
		size = 108
		refs = "002a ??2@YAPAXI@Z 0030 _invalid_parameter_noinfo_noreturn 005e ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 04 46 6F F0 01 03 BC 62 4F F0 00 08 C7 E9 00 33 C0 F8 00 80 C0 E9 05 88 08 20 15 46 0E 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 0F 23 A3 61 10 2B 01 D3 63 68 00 E0 23 1D C4 F8 14 80 2A 46 31 46 20 46 83 F8 00 80 ?? ?? ?? ?? 20 46 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_99_104_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBDI@Z"
		size = 108
		refs = "002a ??2@YAPAXI@Z 0030 _invalid_parameter_noinfo_noreturn 005e ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 04 46 6F F0 01 03 BC 62 4F F0 00 08 C7 E9 00 33 C0 F8 00 80 C0 E9 05 88 08 20 15 46 0E 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 0F 23 A3 61 10 2B 01 D3 63 68 00 E0 23 1D C4 F8 14 80 2A 46 31 46 20 46 83 F8 00 80 ?? ?? ?? ?? 20 46 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_12_57_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z"
		size = 114
		refs = "0024 ??2@YAPAXI@Z 002a _invalid_parameter_noinfo_noreturn 005a strlen 0064 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
	strings:
		$1 = { 03 B4 2D E9 FC 48 0D F1 18 0B 6F 46 04 46 6F F0 01 03 3C 62 00 26 C7 E9 00 33 08 20 26 60 C4 E9 05 66 0D 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 0F 23 A3 61 10 2B 01 D3 63 68 00 E0 23 1D 66 61 1E 70 95 F9 00 30 0B B9 00 20 02 E0 28 46 ?? ?? ?? ?? 02 46 20 46 29 46 ?? ?? ?? ?? 20 46 BD E8 FC 08 5D F8 0C FB }
	condition:
		$1
}

rule file_12_59_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ"
		size = 68
		refs = "001e ??2@YAPAXI@Z 0024 _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 04 46 00 25 C7 E9 00 33 08 20 25 60 C4 E9 05 55 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 0F 23 C4 E9 05 53 25 71 20 46 BD E8 BE 88 }
	condition:
		$1
}

rule file_12_60_1 {
	meta:
		name = "??0?$codecvt@DDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_87_2 {
	meta:
		name = "??0?$messages@D@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$messages@D@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_265_1 {
	meta:
		name = "??0?$messages@G@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$messages@G@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_266_1 {
	meta:
		name = "??0?$messages@_W@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$messages@_W@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_88_2 {
	meta:
		name = "??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_267_1 {
	meta:
		name = "??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_268_1 {
	meta:
		name = "??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_89_2 {
	meta:
		name = "??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_229_2 {
	meta:
		name = "??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_270_1 {
	meta:
		name = "??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_48_2 {
	meta:
		name = "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_279_1 {
	meta:
		name = "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_280_1 {
	meta:
		name = "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_49_2 {
	meta:
		name = "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_281_1 {
	meta:
		name = "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_282_1 {
	meta:
		name = "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 20
		refs = "0010 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 32 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_61_1 {
	meta:
		name = "??0?$ctype@D@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 44
		refs = "0012 _Getctype 0028 ??_7?$ctype@D@std@@6B@"
	strings:
		$1 = { 2D E9 FF 48 0D F1 20 0B 07 4B 07 46 68 46 C7 E9 00 32 ?? ?? ?? ?? 6D 46 1E CD 07 F1 08 06 1E C6 38 46 04 B0 BD E8 F0 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_64_1 {
	meta:
		name = "??0?$numpunct@D@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 52
		refs = "0022 ?_Init@?$numpunct@D@std@@IAAXABV_Locinfo@2@_N@Z 0030 ??_7?$numpunct@D@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 05 4A 20 46 22 60 1A 46 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_283_1 {
	meta:
		name = "??0?$numpunct@G@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 52
		refs = "0022 ?_Init@?$numpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 0030 ??_7?$numpunct@G@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 05 4A 20 46 22 60 1A 46 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_285_1 {
	meta:
		name = "??0?$numpunct@_W@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 52
		refs = "0022 ?_Init@?$numpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 0030 ??_7?$numpunct@_W@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 05 4A 20 46 22 60 1A 46 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_68_1 {
	meta:
		name = "??0_Container_proxy@std@@QAA@XZ"
		size = 16
		altNames = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAA@XZ ??0?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAA@XZ ??0?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAA@XZ ??0?$_Ptr_base@V__ExceptionPtr@@@std@@QAA@XZ ??0?$shared_ptr@V__ExceptionPtr@@@std@@QAA@XZ ??0_Iterator_base12@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 00 33 BD E8 00 88 }
	condition:
		$1
}

rule file_12_70_1 {
	meta:
		name = "??0_Locinfo@std@@QAA@PBD@Z"
		size = 116
		refs = "001e ??0_Lockit@std@@QAA@H@Z 0048 ??0runtime_error@std@@QAA@PBD@Z 0052 _CxxThrowException 005a ?_Locinfo_ctor@_Locinfo@std@@SAXPAV12@PBD@Z 006c _TI2?AVruntime_error@std@@ 0070 ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@"
	strings:
		$1 = { 03 B4 2D E9 B0 48 0D F1 0C 0B 85 B0 6F 46 04 46 0D 46 6F F0 01 03 BC 62 00 21 C7 E9 00 33 ?? ?? ?? ?? 00 23 63 60 23 72 E3 60 23 74 63 61 23 83 E3 61 23 84 63 62 84 F8 28 30 E3 62 84 F8 30 30 4D B9 0B 49 17 F1 08 00 ?? ?? ?? ?? 07 49 17 F1 08 00 ?? ?? ?? ?? 29 46 20 46 ?? ?? ?? ?? 20 46 05 B0 BD E8 B0 08 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_80_1 {
	meta:
		name = "??0codecvt_base@std@@QAA@I@Z"
		size = 20
		refs = "0010 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_90_1 {
	meta:
		name = "??0ctype_base@std@@QAA@I@Z"
		size = 20
		refs = "0010 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_77_2 {
	meta:
		name = "??0facet@locale@std@@IAA@I@Z"
		size = 20
		refs = "0010 ??_7facet@locale@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_143_1 {
	meta:
		name = "??0messages_base@std@@QAA@I@Z"
		size = 20
		refs = "0010 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_277_2 {
	meta:
		name = "??0money_base@std@@QAA@I@Z"
		size = 20
		refs = "0010 ??_7money_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_147_1 {
	meta:
		name = "??0time_base@std@@QAA@I@Z"
		size = 20
		refs = "0010 ??_7time_base@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_3_1 {
	meta:
		name = "?resetiosflags@std@@YA?AU?$_Smanip@H@1@H@Z"
		size = 20
		refs = "0010 ?rsfun@std@@YAXAAVios_base@1@H@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_6_2 {
	meta:
		name = "?setbase@std@@YA?AU?$_Smanip@H@1@H@Z"
		size = 20
		refs = "0010 ?sbfun@std@@YAXAAVios_base@1@H@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_8_2 {
	meta:
		name = "?setiosflags@std@@YA?AU?$_Smanip@H@1@H@Z"
		size = 20
		refs = "0010 ?sifun@std@@YAXAAVios_base@1@H@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 31 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_83_1 {
	meta:
		name = "??0exception@std@@QAA@QBD@Z"
		size = 48
		refs = "0020 __std_exception_copy 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 08 4B 04 46 00 91 23 60 00 23 C4 E9 01 33 01 23 68 46 21 1D 8D F8 04 30 ?? ?? ?? ?? 20 46 BD E8 1E 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_87_1 {
	meta:
		name = "??0locale@std@@QAA@ABV01@@Z"
		size = 44
		refs = "001e _guard_check_icall"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 4D 68 06 46 75 60 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 30 46 BD E8 FC 88 }
	condition:
		$1
}

rule file_12_88_1 {
	meta:
		name = "??0locale@std@@QAA@XZ"
		size = 34
		refs = "0016 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
	strings:
		$1 = { 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 03 01 20 C7 E9 00 33 ?? ?? ?? ?? 60 60 20 46 BD E8 9C 88 }
	condition:
		$1
}

rule file_12_90_1 {
	meta:
		name = "??0runtime_error@std@@QAA@PBD@Z"
		size = 56
		refs = "0020 __std_exception_copy 0030 ??_7runtime_error@std@@6B@ 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0A 4B 04 46 00 91 23 60 00 23 C4 E9 01 33 01 23 68 46 21 1D 8D F8 04 30 ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 1E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_9_1 {
	meta:
		name = "??0invalid_argument@std@@QAA@PBD@Z"
		size = 56
		refs = "0020 __std_exception_copy 0030 ??_7invalid_argument@std@@6B@ 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0A 4B 04 46 00 91 23 60 00 23 C4 E9 01 33 01 23 68 46 21 1D 8D F8 04 30 ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 1E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_11_1 {
	meta:
		name = "??0length_error@std@@QAA@PBD@Z"
		size = 56
		refs = "0020 __std_exception_copy 0030 ??_7length_error@std@@6B@ 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0A 4B 04 46 00 91 23 60 00 23 C4 E9 01 33 01 23 68 46 21 1D 8D F8 04 30 ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 1E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_6_1 {
	meta:
		name = "??0logic_error@std@@QAA@PBD@Z"
		size = 56
		refs = "0020 __std_exception_copy 0030 ??_7logic_error@std@@6B@ 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0A 4B 04 46 00 91 23 60 00 23 C4 E9 01 33 01 23 68 46 21 1D 8D F8 04 30 ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 1E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_15_1 {
	meta:
		name = "??0out_of_range@std@@QAA@PBD@Z"
		size = 56
		refs = "0020 __std_exception_copy 0030 ??_7out_of_range@std@@6B@ 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0A 4B 04 46 00 91 23 60 00 23 C4 E9 01 33 01 23 68 46 21 1D 8D F8 04 30 ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 1E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_17_1 {
	meta:
		name = "??0overflow_error@std@@QAA@PBD@Z"
		size = 56
		refs = "0020 __std_exception_copy 0030 ??_7overflow_error@std@@6B@ 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0A 4B 04 46 00 91 23 60 00 23 C4 E9 01 33 01 23 68 46 21 1D 8D F8 04 30 ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 1E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_94_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QAA@XZ"
		size = 26
		refs = "000e free"
		altNames = "??1?$_Yarn@_W@std@@QAA@XZ ?_Tidy@?$_Yarn@D@std@@AAAXXZ ?_Tidy@?$_Yarn@_W@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 08 B1 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_12_96_1 {
	meta:
		name = "??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ"
		size = 44
		refs = "0012 ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 A3 69 10 2B 02 D3 60 68 ?? ?? ?? ?? 0F 23 00 25 C4 E9 05 53 25 71 20 68 ?? ?? ?? ?? 25 60 BD E8 30 88 }
	condition:
		$1
}

rule file_12_98_1 {
	meta:
		name = "??1?$ctype@D@std@@MAA@XZ"
		size = 60
		refs = "0016 free 0020 ??_V@YAXPAX@Z 0034 ??_7_Facet_base@std@@6B@ 0038 ??_7?$ctype@D@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0B 4B 04 46 23 60 23 69 00 2B 03 DD E0 68 ?? ?? ?? ?? 03 E0 02 DA E0 68 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_101_1 {
	meta:
		name = "??1?$numpunct@D@std@@MAA@XZ"
		size = 48
		refs = "0010 free 0028 ??_7_Facet_base@std@@6B@ 002c ??_7?$numpunct@D@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_367_1 {
	meta:
		name = "??1?$numpunct@G@std@@MAA@XZ"
		size = 48
		refs = "0010 free 0028 ??_7_Facet_base@std@@6B@ 002c ??_7?$numpunct@G@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_368_1 {
	meta:
		name = "??1?$numpunct@_W@std@@MAA@XZ"
		size = 48
		refs = "0010 free 0028 ??_7_Facet_base@std@@6B@ 002c ??_7?$numpunct@_W@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_105_1 {
	meta:
		name = "??1_Locinfo@std@@QAA@XZ"
		size = 96
		refs = "0014 ?_Locinfo_dtor@_Locinfo@std@@SAXPAV12@@Z 001c free 0058 ??1_Lockit@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 04 46 ?? ?? ?? ?? E0 6A 08 B1 ?? ?? ?? ?? 00 25 E5 62 60 6A 08 B1 ?? ?? ?? ?? 65 62 E0 69 08 B1 ?? ?? ?? ?? E5 61 60 69 08 B1 ?? ?? ?? ?? 65 61 E0 68 08 B1 ?? ?? ?? ?? E5 60 60 68 08 B1 ?? ?? ?? ?? 20 46 65 60 ?? ?? ?? ?? BD E8 BE 88 }
	condition:
		$1
}

rule file_12_111_1 {
	meta:
		name = "??1locale@std@@QAA@XZ"
		size = 60
		refs = "001c _guard_check_icall"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 45 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 BD E8 BE 88 }
	condition:
		$1
}

rule file_12_114_1 {
	meta:
		name = "??4?$_Yarn@D@std@@QAAAAV01@PBD@Z"
		size = 74
		refs = "0014 free 0034 malloc 0040 memcpy"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 28 68 0C 46 A0 42 18 D0 08 B1 ?? ?? ?? ?? 00 23 2B 60 94 B1 94 F9 00 30 22 46 02 E0 52 1C 92 F9 00 30 00 2B FA D1 16 1B 70 1C ?? ?? ?? ?? 28 60 18 B1 72 1C 21 46 ?? ?? ?? ?? 28 46 BD E8 78 88 }
	condition:
		$1
}

rule file_12_115_1 {
	meta:
		name = "??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@ABV01@@Z"
		size = 30
		refs = "0014 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 8C 42 04 D0 6F F0 00 03 00 22 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_401_1 {
	meta:
		name = "??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV01@ABV01@@Z"
		size = 30
		refs = "0014 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 8C 42 04 D0 6F F0 00 03 00 22 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_403_1 {
	meta:
		name = "??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV01@ABV01@@Z"
		size = 30
		refs = "0014 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 8C 42 04 D0 6F F0 00 03 00 22 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_116_1 {
	meta:
		name = "??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@D@Z"
		size = 88
		refs = "003e _guard_check_icall"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 06 46 75 68 0F 46 F5 B1 2B 6A 1B 68 13 B1 2B 6B 1B 68 00 E0 00 23 00 2B 0A DD 2A 6B F8 B2 13 68 5B 1E 13 60 2A 6A 11 68 4B 1C 13 60 0F 70 07 E0 2B 68 DC 68 20 46 ?? ?? ?? ?? 28 46 F9 B2 A0 47 B0 F1 FF 3F 01 D1 01 23 33 70 30 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_12_117_1 {
	meta:
		name = "??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAADI@Z"
		size = 36
		refs = "001e _invalid_parameter_noinfo_noreturn"
		altNames = "??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAABDI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 99 42 08 D8 83 69 10 2B 01 D3 43 68 00 E0 03 1D 58 18 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_119_1 {
	meta:
		name = "??Bid@locale@std@@QAAIXZ"
		size = 52
		refs = "0012 ??0_Lockit@std@@QAA@H@Z 0026 ??1_Lockit@std@@QAA@XZ 0030 ?_Id_cnt@id@locale@std@@0HA"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 68 6B B9 68 46 00 21 ?? ?? ?? ?? 23 68 23 B9 05 4B 1A 68 52 1C 1A 60 22 60 68 46 ?? ?? ?? ?? 20 68 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_120_1 {
	meta:
		name = "??D?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBADXZ"
		size = 26
		refs = "000e ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 79 0B B9 ?? ?? ?? ?? 94 F9 05 00 BD E8 18 88 }
	condition:
		$1
}

rule file_12_122_1 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@XZ"
		size = 20
		refs = "000a ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_82_2_1 {
	meta:
		name = "??0exception_ptr@std@@QAA@ABV01@@Z"
		size = 20
		refs = "000a ?__ExceptionPtrCopy@@YAXPAXPBX@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_429_1 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@XZ"
		size = 20
		refs = "000a ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_430_1 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@XZ"
		size = 20
		refs = "000a ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_445_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 20
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_446_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 20
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_9_79_3 {
	meta:
		name = "?getECSUName@UnDecorator@@CA?AVDName@@XZ"
		size = 20
		refs = "000a ?getScopedName@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_9_100_3 {
	meta:
		name = "?getReferenceType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z"
		size = 20
		refs = "000a ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_9_124_3 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 20
		refs = "000a ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_124_1 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@ABV01@@Z"
		size = 20
		refs = "0010 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z"
		altNames = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 03 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_448_1 {
	meta:
		name = "??Y?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV01@ABV01@@Z"
		size = 20
		refs = "0010 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 03 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_450_1 {
	meta:
		name = "??Y?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV01@ABV01@@Z"
		size = 20
		refs = "0010 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 03 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_934_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@@Z"
		size = 20
		refs = "0010 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 03 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_937_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@@Z"
		size = 20
		refs = "0010 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 03 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_279_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@@Z"
		size = 20
		refs = "0010 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 03 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_945_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@@Z"
		size = 20
		refs = "0010 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 03 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_951_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@@Z"
		size = 20
		refs = "0010 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 03 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_125_1 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@D@Z"
		size = 78
		refs = "001a ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0048 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 62 69 0E 46 D3 43 01 2B 19 D9 55 1C 29 46 00 22 ?? ?? ?? ?? 80 B1 D4 E9 05 23 10 2B 01 D3 63 68 00 E0 23 1D 9E 54 A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 5A 55 20 46 BD E8 78 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_126_1 {
	meta:
		name = "??_G?$codecvt@DDU_Mbstatet@@@std@@MAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7_Facet_base@std@@6B@"
		altNames = "??_G?$messages@D@std@@MAAPAXI@Z ??_G?$messages@G@std@@MAAPAXI@Z ??_G?$messages@_W@std@@MAAPAXI@Z ??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z ??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z ??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z ??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z ??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z ??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z ??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z ??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z ??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z ??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z ??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z ??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z ??_Gcodecvt_base@std@@UAAPAXI@Z ??_Gctype_base@std@@UAAPAXI@Z ??_Gfacet@locale@std@@MAAPAXI@Z ??_Gmessages_base@std@@UAAPAXI@Z ??_Gmoney_base@std@@UAAPAXI@Z ??_Gtime_base@std@@UAAPAXI@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 08 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_141_2 {
	meta:
		name = "??_G_Generic_error_category@std@@UAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 08 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_141_2 {
	meta:
		name = "??_G_Iostream_error_category@std@@UAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 08 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_80_2 {
	meta:
		name = "??_G_System_error_category@std@@UAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 08 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_146_2 {
	meta:
		name = "??_Gerror_category@std@@UAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 08 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_127_1 {
	meta:
		name = "??_G?$ctype@D@std@@MAAPAXI@Z"
		size = 76
		refs = "0018 free 0022 ??_V@YAXPAX@Z 003a ??3@YAXPAXI@Z 0044 ??_7_Facet_base@std@@6B@ 0048 ??_7?$ctype@D@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0F 4B 04 46 0D 46 23 60 23 69 00 2B 03 DD E0 68 ?? ?? ?? ?? 03 E0 02 DA E0 68 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 05 4B 15 F0 01 0F 23 60 03 D0 18 21 20 46 ?? ?? ?? ?? 20 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_130_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAAPAXI@Z"
		size = 68
		refs = "0012 free 0030 ??3@YAXPAXI@Z 003c ??_7_Facet_base@std@@6B@ 0040 ??_7?$numpunct@D@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 18 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_476_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAAPAXI@Z"
		size = 68
		refs = "0012 free 0030 ??3@YAXPAXI@Z 003c ??_7_Facet_base@std@@6B@ 0040 ??_7?$numpunct@G@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 18 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_477_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAAPAXI@Z"
		size = 68
		refs = "0012 free 0030 ??3@YAXPAXI@Z 003c ??_7_Facet_base@std@@6B@ 0040 ??_7?$numpunct@_W@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 18 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_131_1 {
	meta:
		name = "??_G_Facet_base@std@@UAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 04 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_139_1 {
	meta:
		name = "?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAXXZ"
		size = 42
		refs = "000c ??2@YAPAXI@Z 0024 _invalid_parameter_noinfo_noreturn"
		altNames = "?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAXXZ ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 08 20 ?? ?? ?? ?? 40 B1 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 BD E8 18 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_140_1 {
	meta:
		name = "?_Allocate@std@@YAPAXII_N@Z"
		size = 62
		refs = "001e __rt_udiv 002a ??2@YAPAXI@Z 0034 ?_Xbad_alloc@std@@YAXXZ 0038 _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 0D 46 14 B9 00 20 BD E8 30 88 6F F0 00 01 28 46 00 B9 F9 DE ?? ?? ?? ?? A0 42 06 D3 04 FB 05 F0 ?? ?? ?? ?? 00 28 EE D1 01 E0 ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_141_1 {
	meta:
		name = "?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX$$QAV12@@Z"
		size = 66
		refs = "001e memmove"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 46 A3 69 00 26 05 46 10 2B 07 D2 63 69 5A 1C 09 D0 28 1D 21 1D ?? ?? ?? ?? 04 E0 2A 1D 01 D0 63 68 13 60 66 60 63 69 6B 61 A3 69 AB 61 0F 23 C4 E9 05 63 26 71 BD E8 78 88 }
	condition:
		$1
}

rule file_12_142_1 {
	meta:
		name = "?_Atomic_fetch_add_4@std@@YAKPCKKW4memory_order@1@@Z"
		size = 114
		refs = "006c _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 00 2A 25 D0 2D DD 02 2A 18 DD 03 2A 0C D0 13 1F 01 2B 26 D8 BF F3 5B 8F 54 E8 00 0F 42 18 44 E8 00 23 00 2B F8 D1 10 E0 BF F3 5B 8F 54 E8 00 0F 42 18 44 E8 00 23 00 2B F8 D1 10 E0 54 E8 00 0F 42 18 44 E8 00 23 00 2B F8 D1 BF F3 5B 8F 06 E0 54 E8 00 0F 42 18 44 E8 00 23 00 2B F8 D1 BD E8 18 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_143_1 {
	meta:
		name = "?_Atomic_fetch_sub_4@std@@YAKPCKKW4memory_order@1@@Z"
		size = 16
		refs = "000c ?_Atomic_fetch_add_4@std@@YAKPCKKW4memory_order@1@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 49 42 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_145_1 {
	meta:
		name = "?_C_str@?$_Yarn@D@std@@QBAPBDXZ"
		size = 18
		altNames = "?_C_str@?$_Yarn@_W@std@@QBAPB_WXZ ?c_str@?$_Yarn@D@std@@QBAPBDXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 18 68 00 B9 18 1D BD E8 00 88 }
	condition:
		$1
}

rule file_12_146_1 {
	meta:
		name = "?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXIID@Z"
		size = 54
		refs = "002e memset"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 1C 46 01 2A 07 D1 82 69 10 2A 01 D3 42 68 00 E0 02 1D 54 54 09 E0 83 69 10 2B 01 D3 43 68 00 E0 03 1D 58 18 21 46 ?? ?? ?? ?? BD E8 18 88 }
	condition:
		$1
}

rule file_12_147_1 {
	meta:
		name = "?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXI@Z"
		size = 22
		refs = "0010 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 8B 42 01 D3 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_512_1 {
	meta:
		name = "?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXI@Z"
		size = 22
		refs = "0010 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 8B 42 01 D3 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_513_1 {
	meta:
		name = "?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXI@Z"
		size = 22
		refs = "0010 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 8B 42 01 D3 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_148_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIII@Z"
		size = 22
		altNames = "?_Clamp_suffix_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIII@Z ?_Clamp_suffix_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIII@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 5B 1A 9A 42 88 BF 1A 46 10 46 BD E8 00 88 }
	condition:
		$1
}

rule file_12_149_1 {
	meta:
		name = "?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXII@Z"
		size = 200
		refs = "0050 ??2@YAPAXI@Z 0058 _invalid_parameter_noinfo_noreturn 008a memcpy 0096 ??3@YAXPAX@Z"
	strings:
		$1 = { 0F B4 2D E9 FF 4B 0D F1 28 0B 6F 46 4F F0 0F 09 41 EA 09 05 04 46 6F F0 01 03 15 F1 02 0F 90 46 BA 63 79 63 3C 63 C7 E9 02 33 01 D9 0D 46 0D E0 A1 69 24 4B 48 08 A5 FB 03 32 B0 EB 52 0F 05 D9 6F F0 01 05 2B 1A 99 42 00 D8 45 18 68 1C 0D D0 ?? ?? ?? ?? 06 46 56 B9 ?? ?? ?? ?? 3C 6B D7 F8 38 80 D7 E9 00 56 4F F0 0F 09 00 E0 00 26 B8 F1 00 0F 0C D0 A3 69 10 2B 01 D3 61 68 00 E0 21 1D B8 F1 00 0F 03 D0 42 46 30 46 ?? ?? ?? ?? A3 69 10 2B 02 D3 60 68 ?? ?? ?? ?? 4F F0 00 02 C4 E9 05 29 23 1D 1A 70 00 D0 1E 60 A5 61 10 2D 00 D3 63 68 C4 F8 14 80 03 F8 08 20 BD E8 FF 0B 5D F8 14 FB FE DE AB AA AA AA }
	condition:
		$1
}

rule file_12_150_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXII@Z$1"
		size = 22
		refs = "0008 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 0010 _CxxThrowException"
	strings:
		$1 = { 10 B5 38 6B 00 22 01 21 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_523_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXII@Z$1"
		size = 22
		refs = "0008 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 0010 _CxxThrowException"
	strings:
		$1 = { 10 B5 38 6B 00 22 01 21 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_526_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII@Z$1"
		size = 22
		refs = "0008 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 0010 _CxxThrowException"
	strings:
		$1 = { 10 B5 38 6B 00 22 01 21 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_151_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXII@Z$0"
		size = 46
		refs = "0012 ??2@YAPAXI@Z 0022 _invalid_parameter_noinfo_noreturn 002a $LN19"
	strings:
		$1 = { 10 B5 7B 6B 3B 60 58 1C 40 F0 03 80 00 20 00 F0 05 B8 ?? ?? ?? ?? 00 28 00 F0 03 80 78 60 02 48 10 BD ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_152_1 {
	meta:
		name = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAXABU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z"
		size = 52
		refs = "000c ??3@YAXPAX@Z 0016 ??2@YAPAXI@Z 002e _invalid_parameter_noinfo_noreturn"
		altNames = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAXABU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z ?_Copy_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAXABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z ?_Move_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z ?_Move_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z ?_Move_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 08 20 23 60 ?? ?? ?? ?? 40 B1 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 BD E8 18 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_154_1 {
	meta:
		name = "?_Dec_atomic_counter_explicit@std@@YAKAAKW4memory_order@1@@Z"
		size = 22
		refs = "000c ?_Atomic_fetch_add_4@std@@YAKPCKKW4memory_order@1@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 46 6F F0 00 01 ?? ?? ?? ?? 40 1E BD E8 00 88 }
	condition:
		$1
}

rule file_12_155_1 {
	meta:
		name = "?_Decref@facet@locale@std@@UAAPAV_Facet_base@3@XZ"
		size = 46
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 21 1D BF F3 5B 8F 51 E8 00 0F 42 1E 41 E8 00 23 00 2B F8 D1 BF F3 5B 8F 43 1E 18 BF 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_156_1 {
	meta:
		name = "?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 83 69 10 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 5A 54 BD E8 00 88 }
	condition:
		$1
}

rule file_12_157_1 {
	meta:
		name = "?_Fetch_add_acquire_4@std@@YAKPCKK@Z"
		size = 32
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 50 E8 00 4F 62 18 40 E8 00 23 00 2B F8 D1 20 46 BF F3 5B 8F BD E8 18 88 }
	condition:
		$1
}

rule file_12_158_1 {
	meta:
		name = "?_Fetch_add_relaxed_4@std@@YAKPCKK@Z"
		size = 28
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 50 E8 00 4F 62 18 40 E8 00 23 00 2B F8 D1 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_159_1 {
	meta:
		name = "?_Fetch_add_release_4@std@@YAKPCKK@Z"
		size = 32
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B BF F3 5B 8F 50 E8 00 4F 62 18 40 E8 00 23 00 2B F8 D1 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_160_1 {
	meta:
		name = "?_Fetch_add_seq_cst_4@std@@YAKPCKK@Z"
		size = 36
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B BF F3 5B 8F 50 E8 00 4F 62 18 40 E8 00 23 00 2B F8 D1 20 46 BF F3 5B 8F BD E8 18 88 }
	condition:
		$1
}

rule file_12_161_1 {
	meta:
		name = "?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADDH@Z"
		size = 140
		altNames = "?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADDH@Z ?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADDH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 1C 46 25 23 48 1C 0B 70 14 F0 20 0F 02 D0 2B 23 03 70 40 1C 14 F0 10 0F 02 D0 23 23 03 70 40 1C 2E 23 03 70 2A 23 43 70 80 1C 0A B1 02 70 40 1C 4F F4 40 52 04 EA 02 03 14 F0 04 0F 0D D0 B3 F5 00 5F 0D D0 93 42 08 BF 41 23 15 D0 B3 F5 80 5F 08 BF 45 23 10 D0 47 23 0E E0 B3 F5 00 5F 01 D1 66 23 09 E0 93 42 08 BF 61 23 05 D0 B3 F5 80 5F 08 BF 65 23 18 BF 67 23 03 70 00 23 43 70 08 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_162_1 {
	meta:
		name = "?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z"
		size = 992
		refs = "000a __security_push_cookie 0078 strcspn 0082 localeconv 009e ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 00a2 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00bc _guard_check_icall 00e2 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 0116 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0150 ?grouping@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0180 _invalid_parameter_noinfo_noreturn 01cc ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@IID@Z 0228 ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@D@Z 0390 ??3@YAXPAX@Z 03cc __security_pop_cookie 03d8 ??_C@_02OOPEBDOJ@pP?$AA@ 03dc ??_C@_02MDKMJEGG@eE?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 9C B0 6F 46 D7 F8 A8 40 D7 F8 B4 50 C7 E9 05 41 6F F0 01 03 D7 F8 B0 90 C7 E9 0A 33 45 B1 99 F9 00 30 2B 2B 01 D0 2D 2B 02 D1 4F F0 01 08 01 E0 4F F0 00 08 63 69 03 F4 40 53 B3 F5 40 5F 01 D0 E3 49 11 E0 08 F1 02 02 E0 49 AA 42 0C D8 19 F9 08 30 09 EB 08 00 30 2B 06 D1 90 F9 01 30 78 2B 01 D0 58 2B 00 D1 90 46 48 46 ?? ?? ?? ?? 2E 23 3B 82 B8 60 ?? ?? ?? ?? 03 68 17 F1 10 01 48 46 1B 78 3B 74 ?? ?? ?? ?? 06 46 20 46 17 F1 20 01 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 3C 60 D7 F8 24 A0 BA F1 00 0F 12 D0 DA F8 00 30 9C 68 20 46 ?? ?? ?? ?? 50 46 A0 47 82 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 50 46 01 21 A0 47 3C 68 17 F1 30 00 00 22 29 46 ?? ?? ?? ?? BB 6C 10 2B 02 D3 D7 F8 34 A0 01 E0 17 F1 34 0A 22 68 D4 69 20 46 ?? ?? ?? ?? 38 68 49 46 05 EB 09 02 53 46 A0 47 78 69 17 F1 20 01 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 D7 F8 24 A0 BA F1 00 0F 11 D0 DA F8 00 30 9C 68 20 46 ?? ?? ?? ?? 50 46 A0 47 82 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 50 46 01 21 A0 47 17 F1 50 01 48 46 ?? ?? ?? ?? D9 F8 00 30 1C 69 20 46 ?? ?? ?? ?? 48 46 A0 47 82 46 AE 42 15 D0 D9 F8 00 30 DC 68 20 46 ?? ?? ?? ?? 48 46 A0 47 7B 6C 9E 42 01 D9 ?? ?? ?? ?? BB 6C 10 2B 01 D3 7B 6B 01 E0 17 F1 34 03 98 55 00 E0 BE 68 BD 6E 78 6D 10 2D 28 BF 04 46 01 D2 17 F1 54 04 94 F9 00 30 7F 2B 1A D0 94 F9 00 20 00 2A 14 DD A6 EB 08 03 9A 42 10 D2 B6 1A 31 46 53 46 01 22 17 F1 30 00 ?? ?? ?? ?? 94 F9 01 30 00 2B C8 BF 64 1C 94 F9 00 30 7F 2B E6 D1 BD 6E 78 6D 79 69 D7 F8 44 E0 D1 E9 08 23 C7 F8 08 E0 00 2B 06 DB 00 DC 22 B1 72 45 02 D9 A2 EB 0E 04 00 E0 00 24 4B 69 03 F4 E0 73 40 2B 2E D0 B3 F5 80 7F 2E D0 D7 E9 28 32 C7 E9 00 32 64 B1 97 F9 AC 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 F8 44 E0 BD 6E 78 6D D7 E9 00 32 BE 6C 79 6B 00 24 10 2E 28 BF 89 46 C7 E9 28 32 01 D2 17 F1 34 09 C2 46 C7 E9 00 32 B8 F1 00 0F 5E D0 19 F9 01 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 4E E0 B3 F5 80 7F 33 D1 BE 6C 79 6B 10 2E 28 BF 89 46 01 D2 17 F1 34 09 D7 E9 28 32 C2 46 B8 F1 00 0F C7 E9 00 32 0E D0 19 F9 01 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 11 E6 79 6B BD 6E 78 6D D7 E9 00 32 C7 E9 28 32 C7 E9 00 32 6C B1 97 F9 AC 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 E9 11 E6 79 6B BD 6E 78 6D D7 E9 00 32 00 24 1E E0 BE 6C 79 6B 10 2E 28 BF 89 46 01 D2 17 F1 34 09 D7 E9 28 32 C2 46 B8 F1 00 0F C7 E9 00 32 0E D0 19 F9 01 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 11 E6 D7 E9 00 32 78 6D BD 6E 79 6B C7 E9 28 32 F0 45 01 D9 ?? ?? ?? ?? 10 2E 01 D2 17 F1 34 01 01 EB 08 06 B9 68 C7 E9 02 32 B1 EB 08 08 0C D0 16 F9 01 1B 17 F1 08 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 BD 6E 78 6D D7 E9 02 32 D7 F8 14 E0 00 21 C7 E9 28 32 CE E9 08 11 C7 E9 02 32 5C B1 97 F9 AC 10 17 F1 08 00 ?? ?? ?? ?? 64 1E F7 D1 BD 6E 78 6D D7 E9 02 32 BC 69 C4 E9 00 32 10 2D 01 D3 ?? ?? ?? ?? 0F 23 38 6D BB 66 00 23 7B 66 87 F8 54 30 ?? ?? ?? ?? 00 23 3B 65 BB 6C 10 2B 02 D3 78 6B ?? ?? ?? ?? 0F 23 38 6B BB 64 00 23 7B 64 87 F8 34 30 ?? ?? ?? ?? 20 46 1C B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_178_1 {
	meta:
		name = "?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 02 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_180_1 {
	meta:
		name = "?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 140
		refs = "0024 ??2@YAPAXI@Z 0042 ??0_Locinfo@std@@QAA@PBD@Z 0054 _Getctype 0076 ??1_Locinfo@std@@QAA@XZ 0084 ??_7?$ctype@D@std@@6B@ 0088 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 96 B0 6F 46 6F F0 01 03 00 25 C7 E9 02 33 A9 46 0C 46 80 46 68 B3 03 68 5B BB 18 20 ?? ?? ?? ?? 06 46 3E 60 DE B1 63 68 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 20 00 ?? ?? ?? ?? 0F 4B 17 F1 10 00 4F F0 01 09 C6 E9 00 35 ?? ?? ?? ?? 17 F1 10 04 0F CC 06 F1 08 05 0F C5 00 E0 00 26 C8 F8 00 60 19 F0 01 0F 03 D0 17 F1 20 00 ?? ?? ?? ?? 02 20 16 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_182_1 {
	meta:
		name = "?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_633_1 {
	meta:
		name = "?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_635_1 {
	meta:
		name = "?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_184_1 {
	meta:
		name = "?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_637_1 {
	meta:
		name = "?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_639_1 {
	meta:
		name = "?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_186_1 {
	meta:
		name = "?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 136
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 0060 ?_Init@?$numpunct@D@std@@IAAXABV_Locinfo@2@_N@Z 0074 ??1_Locinfo@std@@QAA@XZ 0080 ??_7?$numpunct@D@std@@6B@ 0084 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 4D B3 2B 68 3B BB 18 20 ?? ?? ?? ?? 04 46 7C 60 C4 B1 D8 F8 04 30 0B B9 12 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 09 4B 01 22 20 46 23 60 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_641_1 {
	meta:
		name = "?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 136
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 0060 ?_Init@?$numpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 0074 ??1_Locinfo@std@@QAA@XZ 0080 ??_7?$numpunct@G@std@@6B@ 0084 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 4D B3 2B 68 3B BB 18 20 ?? ?? ?? ?? 04 46 7C 60 C4 B1 D8 F8 04 30 0B B9 12 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 09 4B 01 22 20 46 23 60 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_645_1 {
	meta:
		name = "?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 136
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 0060 ?_Init@?$numpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 0074 ??1_Locinfo@std@@QAA@XZ 0080 ??_7?$numpunct@_W@std@@6B@ 0084 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 4D B3 2B 68 3B BB 18 20 ?? ?? ?? ?? 04 46 7C 60 C4 B1 D8 F8 04 30 0B B9 12 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 09 4B 01 22 20 46 23 60 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 04 20 12 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_188_1 {
	meta:
		name = "__unwindfunclet$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
		size = 32
		refs = "001a ??1_Locinfo@std@@QAA@XZ"
		altNames = "__unwindfunclet$?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 08 80 3B 68 23 F0 01 03 3B 60 17 F1 10 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_1291_1 {
	meta:
		name = "__unwindfunclet$?name@locale@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ$0"
		size = 32
		refs = "001a ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 08 80 3B 68 23 F0 01 03 3B 60 17 F1 10 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_12_190_1 {
	meta:
		name = "?_Getctype@_Locinfo@std@@QBA?AU_Ctypevec@@XZ"
		size = 34
		refs = "000e _Getctype"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 85 B0 68 46 0E 46 ?? ?? ?? ?? 6D 46 1D CD 86 E8 1D 00 30 46 05 B0 BD E8 70 88 }
	condition:
		$1
}

rule file_12_191_1 {
	meta:
		name = "?_Getcvt@_Locinfo@std@@QBA?AU_Cvtvec@@XZ"
		size = 36
		refs = "000e _Getcvt 0018 memcpy"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8B B0 68 46 0C 46 ?? ?? ?? ?? 69 46 2C 22 20 46 ?? ?? ?? ?? 20 46 0B B0 BD E8 10 88 }
	condition:
		$1
}

rule file_12_192_1 {
	meta:
		name = "?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z"
		size = 58
		refs = "0022 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 42 68 0C 46 D3 68 9C 42 03 D2 93 68 53 F8 21 00 00 E0 00 20 58 B9 13 7D 4B B1 ?? ?? ?? ?? C3 68 9C 42 03 D2 83 68 53 F8 24 00 00 E0 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_12_194_1 {
	meta:
		name = "?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 2056
		refs = "0008 __security_push_cookie 003c ?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 004a ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0068 _guard_check_icall 008a ?grouping@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00a2 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00f2 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 0158 ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAAXXZ 01ce ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 02d8 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0312 _invalid_parameter_noinfo_noreturn 031a ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 039e ??3@YAXPAX@Z 049c localeconv 07f6 __security_pop_cookie 0800 ?_Src@?1??_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AAVios_base@3@PAH@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A4 B0 6F 46 82 B0 D7 F8 B8 50 99 46 6F F0 01 03 C7 E9 0E 33 6C 69 D7 F8 BC 30 16 46 04 F4 40 54 B4 F5 40 5F 39 61 7B 62 06 D1 01 93 4B 46 00 95 ?? ?? ?? ?? 03 46 D6 E3 17 F1 30 01 28 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 B8 61 D7 F8 34 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 17 F1 60 01 50 46 ?? ?? ?? ?? 00 23 D7 F8 10 A0 17 F1 28 01 28 46 FB 61 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 FD 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D8 F8 00 20 DF F8 2C 57 D4 69 20 46 ?? ?? ?? ?? 40 46 29 46 05 F1 0F 02 17 F1 80 03 A0 47 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 2B 21 2D 24 00 2B D9 F8 00 30 01 D1 23 B3 00 E0 13 BB 33 79 1B B9 30 46 ?? ?? ?? ?? 2B 21 96 F9 05 20 97 F9 8B 30 9A 42 04 D1 3C 69 21 70 04 F1 01 0A 0E E0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 8A 30 9A 42 06 D1 3B 69 1C 70 03 F1 01 0A 30 46 ?? ?? ?? ?? 30 23 C7 F8 28 A0 0A F8 01 3B 7B 6A 00 22 7A 60 1B 68 90 46 7A 61 DF F8 90 26 00 25 3D 60 93 42 03 D1 4F F4 40 72 BA 60 01 E0 24 23 BB 60 BB 6F 10 2B 01 D3 7B 6E 01 E0 17 F1 64 03 3B 62 93 F9 00 30 7F 2B 00 F0 0B 81 00 2B 40 F3 08 81 7B 6F 13 B9 4F F0 00 08 08 E0 BD 69 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 80 46 17 F1 40 00 00 22 01 21 ?? ?? ?? ?? 00 25 17 F1 80 04 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 03 D1 00 2B 00 F0 92 80 02 E0 00 2B 40 F0 8E 80 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 10 97 F9 80 30 17 F1 80 02 04 E0 8B 42 04 D0 52 1C 92 F9 00 30 00 2B F8 D1 13 1B 0A 2B 2D D2 01 22 B9 68 7A 60 7A 69 91 42 06 DC 3A 68 52 1C 3A 60 6B B1 01 23 FB 60 0A E0 03 B9 42 B1 DF F8 AC 15 52 1C 7A 61 5B 5C 8A F8 00 30 0A F1 01 0A 7B 6D 9D 42 54 D8 B9 6D 7A 6C 10 29 28 BF 13 46 01 D2 17 F1 44 03 5B 57 7F 2B 45 D0 10 29 01 D2 17 F1 44 02 53 5D 5B 1C 53 55 3D E0 7C 6D A5 42 44 D8 B9 6D 78 6C 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 FB B3 B8 F1 00 0F 3C D0 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 15 41 78 6C 96 F9 05 30 43 45 30 D1 C4 F1 FF 33 01 2B 23 D9 64 1C 21 46 00 22 17 F1 40 00 ?? ?? ?? ?? 90 B1 BB 6D 10 2B 01 D3 7A 6C 01 E0 17 F1 44 02 7B 6D 00 21 99 54 BB 6D 10 2B 01 D3 7B 6C 01 E0 17 F1 44 03 7C 65 19 55 6D 1C 17 F1 80 04 30 46 ?? ?? ?? ?? 62 E7 ?? ?? ?? ?? 17 F1 40 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 15 41 78 6C 6D B1 A5 42 01 D9 ?? ?? ?? ?? 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 00 2B 28 DD 6D 1C D7 F8 20 E0 35 B3 9E F9 00 20 7F 2A 22 D0 6D 1E 0A D0 A5 42 1A D8 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 9A 42 13 D1 4D B9 10 29 28 BF 03 46 01 D2 17 F1 44 03 93 F9 00 30 9A 42 08 DB 9E F9 01 30 00 2B DE DD 0E F1 01 0E DB E7 ?? ?? ?? ?? 01 23 FB 61 10 29 01 D3 ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? D7 F8 14 80 46 E0 17 F1 80 04 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 9B B3 00 E0 8B BB 33 79 13 B9 30 46 ?? ?? ?? ?? 97 F9 80 20 96 F9 05 00 17 F1 80 01 3A B1 13 46 83 42 04 D0 49 1C 91 F9 00 30 00 2B F8 D1 0B 1B 0A 2B 1C D2 BA 68 42 45 05 DC 6D 1C 3D 60 73 B1 01 23 FB 60 0B E0 13 B9 B8 F1 00 0F 07 D0 F4 4A 08 F1 01 08 9B 5C 8A F8 00 30 0A F1 01 0A 01 22 30 46 7A 60 ?? ?? ?? ?? BA E7 97 F9 80 20 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? 97 F9 80 20 33 68 00 2B D9 F8 00 30 01 D1 FB B1 00 E0 EB B9 33 79 13 B9 30 46 ?? ?? ?? ?? BB 69 96 F9 05 50 1B 68 DC 68 20 46 ?? ?? ?? ?? B8 69 A0 47 85 42 0A D1 ?? ?? ?? ?? 03 68 30 46 1B 78 8A F8 00 30 0A F1 01 0A ?? ?? ?? ?? 97 F9 80 20 7B 6A D2 49 1B 68 8B 42 38 D0 B8 F1 00 0F 35 D1 3D 68 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? 97 F9 80 20 33 68 00 2B D9 F8 00 30 01 D1 AB B1 00 E0 9B B9 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 80 20 96 F9 05 30 93 42 08 D1 6D 1E 01 22 30 46 7A 60 ?? ?? ?? ?? 97 F9 80 20 D4 E7 3D 60 00 2D 06 DA 30 23 6D 1C 8A F8 00 30 0A F1 01 0A 3D 60 BD 68 17 F1 80 04 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? 97 F9 80 20 33 68 00 2B D9 F8 00 30 01 D1 6B B3 00 E0 5B BB 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 80 20 96 F9 05 10 17 F1 80 03 04 E0 8A 42 04 D0 5B 1C 93 F9 00 20 00 2A F8 D1 1B 1B 0A 2B 15 D2 A8 45 08 DA 9A 4A 08 F1 01 08 9B 5C 8A F8 00 30 0A F1 01 0A 02 E0 0B B1 01 23 FB 60 01 22 30 46 7A 60 ?? ?? ?? ?? 97 F9 80 20 BC E7 FB 68 3D 68 FB B1 D7 F8 28 80 AA F1 01 04 44 45 15 D0 ?? ?? ?? ?? 03 68 94 F9 00 20 93 F9 00 30 9A 42 03 D0 39 2A 05 D1 30 23 23 70 64 1E 44 45 EF D1 02 E0 23 78 5B 1C 23 70 44 45 03 D1 31 23 6D 1C 3D 60 23 70 D7 F8 04 80 B8 F1 00 0F 00 F0 D7 80 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 03 D1 00 2B 00 F0 C4 80 02 E0 00 2B 40 F0 C0 80 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 8D 30 9A 42 0B D0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 8C 30 9A 42 40 F0 A9 80 65 23 8A F8 00 30 30 46 0A F1 01 0A ?? ?? ?? ?? 33 79 00 25 4F F0 00 08 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 0B B3 00 E0 FB B9 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 8B 30 9A 42 08 BF 2B 23 0B D0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 8A 30 9A 42 07 D1 2D 23 8A F8 00 30 0A F1 01 0A 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 7B B1 00 E0 6B B9 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 30 97 F9 80 20 93 42 04 D1 4F F0 01 08 DB E7 97 F9 80 20 B8 F1 00 0F 04 D0 30 23 8A F8 00 30 0A F1 01 0A 17 F1 80 04 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? 97 F9 80 20 33 68 00 2B D9 F8 00 30 01 D1 43 B3 00 E0 33 BB 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 80 20 96 F9 05 10 17 F1 80 03 04 E0 8A 42 04 D0 5B 1C 93 F9 00 20 00 2A F8 D1 1B 1B 0A 2B 10 D2 08 2D 06 DA 17 4A 6D 1C 9B 5C 8A F8 00 30 0A F1 01 0A 30 46 4F F0 01 08 ?? ?? ?? ?? 97 F9 80 20 C1 E7 FB 69 13 B9 B8 F1 00 0F 01 D1 3B 69 9A 46 00 23 8A F8 00 30 BB 6F 10 2B 02 D3 78 6E ?? ?? ?? ?? 0F 23 38 6E BB 67 00 23 7B 67 87 F8 64 30 ?? ?? ?? ?? 3B 68 18 46 26 B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? 00 CA 9A 3B }
	condition:
		$1
}

rule file_12_201_1 {
	meta:
		name = "?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 2112
		refs = "0008 __security_push_cookie 002e ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0032 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0044 _guard_check_icall 0066 ?grouping@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0074 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00cc ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 012a ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAAXXZ 0248 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 034c ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0386 _invalid_parameter_noinfo_noreturn 038e ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 0412 ??3@YAXPAX@Z 052a localeconv 0830 __security_pop_cookie 0838 ?_Src@?1??_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AAVios_base@3@PAH@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A6 B0 6F 46 98 46 6F F0 01 03 D7 F8 C0 90 C7 E9 0C 33 D7 F8 C4 30 C7 E9 06 13 17 F1 28 01 48 46 16 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 F8 60 FD 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 58 01 50 46 ?? ?? ?? ?? 17 F1 20 01 48 46 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 7D 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D9 F8 00 20 DF F8 90 57 D4 69 20 46 ?? ?? ?? ?? 48 46 29 46 05 F1 1D 02 17 F1 78 03 A0 47 00 23 BC 69 7B 61 33 79 A1 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 2B 21 2D 25 00 2B D8 F8 00 30 01 D1 03 B3 00 E0 F3 B9 33 79 1B B9 30 46 ?? ?? ?? ?? 2B 21 96 F9 05 20 97 F9 8F 30 9A 42 01 D1 21 70 0B E0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 8E 30 9A 42 05 D1 25 70 30 46 04 F1 01 09 ?? ?? ?? ?? 30 23 89 F8 00 30 78 23 89 F8 01 30 00 23 3B 60 33 79 00 24 09 F1 02 09 C7 E9 01 44 A2 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 F3 B3 00 E0 E3 BB 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 30 97 F9 78 10 8B 42 33 D1 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 DB B1 00 E0 CB B9 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 91 30 9A 42 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 90 30 9A 42 03 D1 30 46 ?? ?? ?? ?? 01 E0 01 23 7B 60 97 F9 78 10 FB 69 1A 68 DF F8 48 36 9A 42 02 D1 4F F4 40 75 00 E0 24 25 3B 6F 3D 61 10 2B 01 D3 FB 6D 01 E0 17 F1 5C 03 3B 62 93 F9 00 30 7F 2B 00 F0 0A 81 00 2B 40 F3 07 81 FB 6E 13 B9 4F F0 00 0A 08 E0 FD 68 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 82 46 17 F1 38 00 00 22 01 21 ?? ?? ?? ?? 00 25 17 F1 78 04 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 8F 80 02 E0 00 2B 40 F0 8B 80 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 10 97 F9 78 30 17 F1 78 02 04 E0 8B 42 04 D0 52 1C 92 F9 00 30 00 2B F8 D1 13 1B 16 2B 2A D2 01 22 39 69 7A 60 BA 68 91 42 03 DC 3B 68 5B 1C 3B 60 0A E0 03 B9 42 B1 DF F8 70 15 52 1C BA 60 5B 5C 89 F8 00 30 09 F1 01 09 FB 6C 9D 42 54 D8 39 6D FA 6B 10 29 28 BF 13 46 01 D2 17 F1 3C 03 5B 57 7F 2B 45 D0 10 29 01 D2 17 F1 3C 02 53 5D 5B 1C 53 55 3D E0 FC 6C A5 42 44 D8 39 6D F8 6B 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 FB B3 BA F1 00 0F 3C D0 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 13 41 F8 6B 96 F9 05 30 53 45 30 D1 C4 F1 FF 33 01 2B 23 D9 64 1C 21 46 00 22 17 F1 38 00 ?? ?? ?? ?? 90 B1 3B 6D 10 2B 01 D3 FA 6B 01 E0 17 F1 3C 02 FB 6C 00 21 99 54 3B 6D 10 2B 01 D3 FB 6B 01 E0 17 F1 3C 03 FC 64 E1 54 6D 1C 17 F1 78 04 30 46 ?? ?? ?? ?? 65 E7 ?? ?? ?? ?? 17 F1 38 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 13 41 F8 6B 6D B1 A5 42 01 D9 ?? ?? ?? ?? 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 00 2B 28 DD 6D 1C D7 F8 20 E0 35 B3 9E F9 00 20 7F 2A 22 D0 6D 1E 0A D0 A5 42 1A D8 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 9A 42 13 D1 4D B9 10 29 28 BF 03 46 01 D2 17 F1 3C 03 93 F9 00 30 9A 42 08 DB 9E F9 01 30 00 2B DE DD 0E F1 01 0E DB E7 ?? ?? ?? ?? 01 23 7B 61 10 29 01 D3 ?? ?? ?? ?? 0F 23 B8 6B 3B 65 00 23 FB 64 87 F8 3C 30 ?? ?? ?? ?? 97 F9 78 10 D7 F8 08 A0 49 E0 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 97 F9 78 10 33 68 00 2B D8 F8 00 30 01 D1 93 B3 00 E0 83 BB 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 10 96 F9 05 00 17 F1 78 03 39 B1 0A 46 82 42 04 D0 5B 1C 93 F9 00 20 00 2A F8 D1 1B 1B 16 2B 19 D2 55 45 03 DC 3B 68 5B 1C 3B 60 0B E0 13 B9 BA F1 00 0F 07 D0 E4 4A 0A F1 01 0A 9B 5C 89 F8 00 30 09 F1 01 09 01 23 30 46 7B 60 ?? ?? ?? ?? 97 F9 78 10 B7 E7 7B 68 3B B1 BA F1 00 0F 04 D1 30 23 89 F8 00 30 09 F1 01 09 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 97 F9 78 10 33 68 00 2B D8 F8 00 30 01 D1 FB B1 00 E0 EB B9 33 79 13 B9 30 46 ?? ?? ?? ?? FB 68 96 F9 05 50 1B 68 DC 68 20 46 ?? ?? ?? ?? F8 68 A0 47 85 42 0A D1 ?? ?? ?? ?? 03 68 30 46 1B 78 89 F8 00 30 09 F1 01 09 ?? ?? ?? ?? 97 F9 78 10 BA F1 00 0F 35 D1 3C 68 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 97 F9 78 10 33 68 00 2B D8 F8 00 30 01 D1 AB B1 00 E0 9B B9 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 10 96 F9 05 30 8B 42 08 D1 64 1E 01 23 30 46 7B 60 ?? ?? ?? ?? 97 F9 78 10 D4 E7 3C 60 00 2C 06 DA 30 23 64 1C 89 F8 00 30 09 F1 01 09 3C 60 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 97 F9 78 10 33 68 00 2B D8 F8 00 30 01 D1 53 B3 00 E0 43 BB 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 10 96 F9 05 20 17 F1 78 03 04 E0 91 42 04 D0 5B 1C 93 F9 00 10 00 29 F8 D1 1B 1B 16 2B 12 D2 3A 69 92 45 07 DA 87 4A 0A F1 01 0A 9B 5C 89 F8 00 30 09 F1 01 09 01 23 30 46 7B 60 ?? ?? ?? ?? 97 F9 78 10 BF E7 D7 F8 04 A0 BA F1 00 0F 00 F0 D7 80 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 C4 80 02 E0 00 2B 40 F0 C0 80 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 93 30 9A 42 0B D0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 92 30 9A 42 40 F0 A9 80 70 23 89 F8 00 30 30 46 09 F1 01 09 ?? ?? ?? ?? 33 79 00 25 4F F0 00 0A 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 0B B3 00 E0 FB B9 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 8F 30 9A 42 08 BF 2B 23 0B D0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 8E 30 9A 42 07 D1 2D 23 89 F8 00 30 09 F1 01 09 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 7B B1 00 E0 6B B9 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 30 97 F9 78 20 93 42 04 D1 4F F0 01 0A DB E7 97 F9 78 20 BA F1 00 0F 04 D0 30 23 89 F8 00 30 09 F1 01 09 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 20 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 97 F9 78 20 33 68 00 2B D8 F8 00 30 01 D1 43 B3 00 E0 33 BB 33 79 23 B9 30 46 ?? ?? ?? ?? 97 F9 78 20 96 F9 05 10 17 F1 78 03 04 E0 8A 42 04 D0 5B 1C 93 F9 00 20 00 2A F8 D1 1B 1B 16 2B 10 D2 08 2D 06 DA 18 4A 6D 1C 9B 5C 89 F8 00 30 09 F1 01 09 30 46 4F F0 01 0A ?? ?? ?? ?? 97 F9 78 20 C1 E7 7B 69 13 B9 BA F1 00 0F 01 D1 B9 69 89 46 00 23 FA 69 89 F8 00 30 3B 68 13 60 3B 6F 10 2B 02 D3 F8 6D ?? ?? ?? ?? 0F 23 B8 6D 3B 67 00 23 FB 66 87 F8 5C 30 ?? ?? ?? ?? 00 20 26 B0 ?? ?? ?? ?? BD E8 F0 8F ?? ?? ?? ?? 00 CA 9A 3B }
	condition:
		$1
}

rule file_12_208_1 {
	meta:
		name = "?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z"
		size = 1068
		refs = "0008 __security_push_cookie 0024 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 002e ?grouping@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0042 _guard_check_icall 004e ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 007a ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00d4 ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAAXXZ 01f4 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 02f8 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0330 _invalid_parameter_noinfo_noreturn 0338 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 03e4 ??3@YAXPAX@Z 0420 __security_pop_cookie 0428 ?_Src@?1??_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1HABVlocale@3@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A0 B0 6F 46 D7 F8 AC 90 98 46 6F F0 01 03 48 46 16 46 39 61 C7 E9 06 33 ?? ?? ?? ?? 17 F1 40 01 05 46 ?? ?? ?? ?? 78 6D 10 B9 00 23 7B 60 07 E0 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 78 60 48 46 ?? ?? ?? ?? 04 46 22 68 DF F8 D0 93 D5 69 28 46 ?? ?? ?? ?? 20 46 49 46 09 F1 1B 02 17 F1 60 03 A8 47 3C 69 33 79 A2 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 03 B3 00 E0 F3 B9 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 77 30 9A 42 08 BF 2B 23 0B D0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 76 30 9A 42 06 D1 2D 23 30 46 04 F1 01 0A 23 70 ?? ?? ?? ?? D7 F8 A8 30 03 F4 60 63 B3 F5 80 6F 02 D1 4F F0 08 09 0B E0 B3 F5 00 6F 02 D1 4F F0 10 09 05 E0 13 B9 4F F0 00 09 01 E0 4F F0 0A 09 00 23 FB 60 33 79 00 24 3C 60 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 02 D1 00 2B 4E D0 01 E0 00 2B 4B D1 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 60 30 9A 42 40 D1 01 24 30 46 3C 60 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 2B B3 00 E0 1B BB 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 79 30 9A 42 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 20 97 F9 78 30 9A 42 0D D1 B9 F1 00 0F 02 D0 B9 F1 10 0F 07 D1 00 24 30 46 3C 60 4F F0 10 09 ?? ?? ?? ?? 0F E0 B9 F1 00 0F 04 D1 4F F0 08 09 B9 F1 00 0F 09 D0 B9 F1 0A 0F 06 D0 B9 F1 08 0F 08 BF 08 25 02 D0 16 25 00 E0 0A 25 22 46 17 F1 20 00 01 21 BD 60 ?? ?? ?? ?? 00 24 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 90 80 02 E0 00 2B 40 F0 8C 80 33 79 13 B9 30 46 ?? ?? ?? ?? 96 F9 05 10 97 F9 60 30 17 F1 60 02 04 E0 8B 42 04 D0 52 1C 92 F9 00 30 00 2B F8 D1 17 F1 60 03 D3 1A AB 42 28 D2 73 4A 9B 56 FA 68 8A F8 00 30 0A B9 30 2B 08 D0 3A 69 02 F1 1F 03 9A 45 03 D2 01 23 FB 60 0A F1 01 0A 01 23 3B 60 7B 6B 9C 42 55 D8 B9 6B 7A 6A 10 29 28 BF 13 46 01 D2 17 F1 24 03 1B 57 7F 2B 46 D0 10 29 01 D2 17 F1 24 02 13 5D 5B 1C 13 55 3E E0 D7 F8 34 E0 74 45 44 D8 BD 6B 78 6A 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 FB B3 7B 68 EB B3 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 0D E5 78 6A 96 F9 05 30 7A 68 93 42 30 D1 CE F1 FF 33 01 2B 23 D9 0E F1 01 05 29 46 00 22 17 F1 20 00 ?? ?? ?? ?? 90 B1 BB 6B 10 2B 01 D3 7A 6A 01 E0 17 F1 24 02 7B 6B 00 21 99 54 BB 6B 10 2B 01 D3 7B 6A 01 E0 17 F1 24 03 7D 63 59 55 BD 68 64 1C 30 46 ?? ?? ?? ?? 64 E7 ?? ?? ?? ?? 17 F1 20 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 0D E5 78 6A 84 B1 74 45 01 D9 ?? ?? ?? ?? 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 00 2B C8 BF 64 1C D8 BF 00 21 00 DD 39 68 BB 6D 10 2B 01 D3 7A 6C 01 E0 17 F1 44 02 61 B3 1C B3 92 F9 00 10 7F 29 1F D0 64 1E 0A D0 74 45 19 D8 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 99 42 1A D1 4C B9 10 2D 28 BF 03 46 01 D2 17 F1 24 03 93 F9 00 30 99 42 0F DB 92 F9 01 30 00 2B DE DD 52 1C DC E7 ?? ?? ?? ?? FB 68 3B B9 30 23 8A F8 00 30 0A F1 01 0A 01 E0 3B 69 9A 46 00 23 8A F8 00 30 10 2D 01 D3 ?? ?? ?? ?? 0F 23 38 6A BB 63 00 23 7B 63 87 F8 24 30 ?? ?? ?? ?? 00 23 3B 62 BB 6D 10 2B 02 D3 78 6C ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? 48 46 20 B0 ?? ?? ?? ?? BD E8 F0 8F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_212_1 {
	meta:
		name = "?_Getname@_Locinfo@std@@QBAPBDXZ"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 D8 6A 08 B9 03 F1 30 00 BD E8 00 88 }
	condition:
		$1
}

rule file_12_214_1 {
	meta:
		name = "?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBA_JXZ"
		size = 26
		altNames = "?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBA_JXZ ?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBA_JXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 C3 69 1B 68 13 B1 C3 6A 18 68 00 E0 00 20 C1 17 BD E8 00 88 }
	condition:
		$1
}

rule file_12_215_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 C2 6A 13 68 5B 1E 13 60 C2 69 10 68 43 1C 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_12_216_1 {
	meta:
		name = "?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z"
		size = 122
		refs = "001a ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXII@Z 003c memcpy 0042 ??3@YAXPAX@Z 0074 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0D 46 04 46 11 F1 02 0F 2F D8 A3 69 AB 42 03 D2 62 69 ?? ?? ?? ?? 22 E0 C2 B1 10 2D 16 D2 66 69 B5 42 38 BF 2E 46 10 2B 09 D3 67 68 26 B1 20 1D 32 46 39 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? 0F 23 C4 E9 05 63 23 1D 00 22 9A 55 08 E0 45 B9 10 2B 01 D3 63 68 00 E0 23 1D 00 22 62 61 1A 70 0D B1 01 20 00 E0 00 20 BD E8 F0 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_217_1 {
	meta:
		name = "?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z"
		size = 116
		altNames = "?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 15 46 25 22 48 1C 0A 70 13 F0 20 0F 02 D0 2B 22 02 70 40 1C 13 F0 08 0F 02 D0 23 22 02 70 40 1C 95 F9 00 40 4C 2C 01 D0 04 70 06 E0 49 22 02 70 36 22 42 70 80 1C 34 22 02 70 03 F4 60 62 B2 F5 80 6F 08 BF 6F 23 0B D0 B2 F5 00 6F 02 D0 95 F9 01 30 05 E0 13 F0 04 0F 18 BF 58 23 08 BF 78 23 43 70 00 23 83 70 08 46 BD E8 30 88 }
	condition:
		$1
}

rule file_12_218_1 {
	meta:
		name = "?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAAXXZ"
		size = 88
		refs = "003a _guard_check_icall"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2E 68 F6 B1 F3 69 1B 68 13 B1 F3 6A 1B 68 00 E0 00 23 00 2B 09 DD F2 6A 13 68 5B 1E 13 60 F2 69 11 68 4B 1C 13 60 08 78 06 E0 33 68 DC 69 20 46 ?? ?? ?? ?? 30 46 A0 47 B0 F1 FF 3F 18 BF 00 23 02 D1 00 23 2B 60 01 23 2B 71 BD E8 78 88 }
	condition:
		$1
}

rule file_12_220_1 {
	meta:
		name = "?_Incref@facet@locale@std@@UAAXXZ"
		size = 26
		altNames = "?_Incref@_Ref_count_base@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 1D 52 E8 00 0F 41 1C 42 E8 00 13 00 2B F8 D1 BD E8 00 88 }
	condition:
		$1
}

rule file_12_222_1 {
	meta:
		name = "?_Init@?$ctype@D@std@@IAAXABV_Locinfo@2@@Z"
		size = 30
		refs = "000c _Getctype"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 04 46 68 46 ?? ?? ?? ?? 04 F1 08 05 6C 46 0F CC 0F C5 BD E8 3F 88 }
	condition:
		$1
}

rule file_12_225_1 {
	meta:
		name = "?_Init@?$numpunct@D@std@@IAAXABV_Locinfo@2@_N@Z"
		size = 228
		refs = "001a localeconv 0024 _Getcvt 0048 strlen 0052 calloc 0058 ?_Xbad_alloc@std@@YAXXZ 00d8 ??_C@_04LOAJBDKD@true?$AA@ 00dc ??_C@_05LAPONLG@false?$AA@ 00e0 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 90 B0 6F 46 04 46 6F F0 01 03 3C 60 91 46 C7 E9 02 33 ?? ?? ?? ?? 80 46 17 F1 10 00 ?? ?? ?? ?? 00 23 A3 60 C4 E9 04 33 17 F1 10 00 ?? ?? ?? ?? B9 F1 00 0F 01 D0 28 4D 01 E0 D8 F8 08 50 28 46 ?? ?? ?? ?? 46 1C 30 46 01 21 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 36 B1 42 1B 2B 78 76 1E 53 55 6D 1C 00 2E F9 D1 A0 60 1B 4D 06 20 01 21 06 26 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 42 1B 2B 78 76 1E 53 55 6D 1C 00 2E F9 D1 20 61 11 4D 05 20 01 21 05 26 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 42 1B 2B 78 76 1E 53 55 6D 1C 00 2E F9 D1 60 61 B9 F1 00 0F 03 D0 2E 23 23 73 2C 23 06 E0 D8 F8 00 30 1B 78 23 73 D8 F8 04 30 1B 78 63 73 10 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_226_1 {
	meta:
		name = "__catch$?_Init@?$numpunct@D@std@@IAAXABV_Locinfo@2@_N@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$numpunct@D@std@@AAAXXZ 000c _CxxThrowException"
	strings:
		$1 = { 10 B5 38 68 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_99_332_1 {
	meta:
		name = "__catch$?_Init@?$_Mpunct@D@std@@IAAXABV_Locinfo@2@_N@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$_Mpunct@D@std@@AAAXXZ 000c _CxxThrowException"
	strings:
		$1 = { 10 B5 38 68 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_766_1 {
	meta:
		name = "__catch$?_Init@?$_Mpunct@G@std@@IAAXABV_Locinfo@2@_N@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$_Mpunct@G@std@@AAAXXZ 000c _CxxThrowException"
	strings:
		$1 = { 10 B5 38 68 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_768_1 {
	meta:
		name = "__catch$?_Init@?$_Mpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$_Mpunct@_W@std@@AAAXXZ 000c _CxxThrowException"
	strings:
		$1 = { 10 B5 38 68 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_228_1 {
	meta:
		name = "?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NPBD@Z"
		size = 52
	strings:
		$1 = { 2D E9 00 48 EB 46 91 B1 82 69 10 2A 01 D3 43 68 00 E0 03 1D 99 42 0A D3 10 2A 01 D3 42 68 00 E0 02 1D 43 69 13 44 8B 42 88 BF 01 20 00 D8 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_12_229_1 {
	meta:
		name = "?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z"
		size = 882
		refs = "000a __security_push_cookie 0072 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0076 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0086 _guard_check_icall 00aa ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00e0 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0112 ?grouping@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0166 ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@IID@Z 01be ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@D@Z 02c0 _invalid_parameter_noinfo_noreturn 032a ??3@YAXPAX@Z 0366 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 98 B0 6F 46 39 61 D7 F8 A4 60 D7 F8 98 00 D7 F8 A0 90 6F F0 01 03 B8 60 C7 E9 06 33 46 B1 99 F9 00 30 2B 2B 01 D0 2D 2B 02 D1 4F F0 01 08 01 E0 4F F0 00 08 43 69 03 F4 60 63 B3 F5 00 6F 10 D1 08 F1 02 02 B2 42 0C D8 19 F9 08 30 09 EB 08 01 30 2B 06 D1 91 F9 01 30 78 2B 01 D0 58 2B 00 D1 90 46 39 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 20 00 00 22 31 46 ?? ?? ?? ?? BB 6B 10 2B 01 D3 7D 6A 01 E0 17 F1 24 05 DA F8 00 20 D4 69 20 46 ?? ?? ?? ?? 50 46 49 46 06 EB 09 02 2B 46 A0 47 D7 F8 08 A0 39 46 50 46 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 40 01 48 46 ?? ?? ?? ?? D7 F8 58 E0 78 6C BE F1 10 0F 28 BF 05 46 01 D2 17 F1 44 05 95 F9 00 30 7F 2B 27 D0 00 2B 25 DD D9 F8 00 30 1C 69 20 46 ?? ?? ?? ?? 48 46 A0 47 04 46 14 E0 95 F9 00 20 00 2A 14 DD A6 EB 08 03 9A 42 10 D2 B6 1A 31 46 23 46 01 22 17 F1 20 00 ?? ?? ?? ?? 95 F9 01 30 00 2B C8 BF 6D 1C 95 F9 00 30 7F 2B E6 D1 D7 F8 58 E0 78 6C 7E 6B DA E9 08 23 FE 60 00 2B 05 DB 00 DC 1A B1 B2 42 88 BF 94 1B 00 D8 00 24 DA F8 14 30 03 F4 E0 73 40 2B 2E D0 B3 F5 80 7F 2E D0 D7 E9 24 32 C7 E9 00 32 64 B1 97 F9 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 7E 6B D7 F8 58 E0 78 6C D7 E9 00 32 BD 6B 79 6A 00 24 10 2D 28 BF 89 46 C7 E9 24 32 01 D2 17 F1 24 09 C2 46 C7 E9 00 32 B8 F1 00 0F 61 D0 19 F9 01 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 50 E0 B3 F5 80 7F 35 D1 BD 6B 79 6A 10 2D 28 BF 89 46 01 D2 17 F1 24 09 D7 E9 24 32 C2 46 B8 F1 00 0F C7 E9 00 32 0F D0 19 F9 01 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 0D 65 79 6A D7 F8 58 E0 78 6C D7 E9 00 32 C7 E9 24 32 C7 E9 00 32 74 B1 97 F9 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 E9 0D 65 79 6A D7 F8 58 E0 78 6C D7 E9 00 32 00 24 1F E0 BD 6B 79 6A 10 2D 28 BF 89 46 01 D2 17 F1 24 09 D7 E9 24 32 C2 46 B8 F1 00 0F C7 E9 00 32 0F D0 19 F9 01 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 0D 65 D7 E9 00 32 78 6C D7 F8 58 E0 79 6A C7 E9 24 32 B0 45 01 D9 ?? ?? ?? ?? 10 2D 01 D2 17 F1 24 01 01 EB 08 05 F9 68 C7 E9 00 32 B1 EB 08 06 0B D0 15 F9 01 1B 38 46 ?? ?? ?? ?? 76 1E F8 D1 D7 F8 58 E0 78 6C D7 E9 00 32 B9 68 00 25 C7 E9 24 32 C1 E9 08 55 C7 E9 00 32 5C B1 97 F9 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 F8 58 E0 78 6C D7 E9 00 32 3C 69 C4 E9 00 32 BE F1 10 0F 01 D3 ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? 00 23 3B 64 BB 6B 10 2B 02 D3 78 6A ?? ?? ?? ?? 0F 23 38 6A BB 63 00 23 7B 63 87 F8 24 30 ?? ?? ?? ?? 20 46 18 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_236_1 {
	meta:
		name = "?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
		size = 168
		refs = "001c ??0_Lockit@std@@QAA@H@Z 0032 _realloc_base 0038 ?_Xbad_alloc@std@@YAXXZ 0060 _guard_check_icall 00a0 ??1_Lockit@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 FF 4B 0D F1 28 0B 6F 46 89 46 05 46 6F F0 01 03 38 46 00 21 C7 E9 02 33 16 46 ?? ?? ?? ?? EB 68 B3 42 18 D8 74 1C 28 2C A8 68 38 BF 28 24 A1 00 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? EB 68 A8 60 A3 42 09 D2 00 21 D5 E9 02 32 43 F8 22 10 EB 68 5B 1C EB 60 A3 42 F6 D3 D9 F8 00 30 5C 68 20 46 ?? ?? ?? ?? 48 46 A0 47 AB 68 53 F8 26 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 AB 68 43 F8 26 90 38 46 ?? ?? ?? ?? BD E8 FF 8B }
	condition:
		$1
}

rule file_12_238_1 {
	meta:
		name = "?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z"
		size = 160
		refs = "0026 ??0_Locinfo@std@@QAA@PBD@Z 0034 ?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 003c ??1_Locinfo@std@@QAA@XZ 0046 ??0_Lockit@std@@QAA@H@Z 0050 _malloc_base 0058 ?_Xbad_alloc@std@@YAXXZ 007e _guard_check_icall 008c ??1_Lockit@std@@QAA@XZ 0098 ??_C@_01GFHCPBMG@C?$AA@ 009c ?_Clocptr@_Locimp@locale@std@@0PAV123@A"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 C7 E9 02 33 21 4B 89 46 06 46 1B 68 99 45 10 D1 1D 49 17 F1 10 00 ?? ?? ?? ?? 17 F1 10 00 00 23 32 46 3F 21 ?? ?? ?? ?? 17 F1 10 00 ?? ?? ?? ?? 26 E0 38 46 00 21 ?? ?? ?? ?? F3 68 EB B1 98 00 ?? ?? ?? ?? B0 60 08 B9 ?? ?? ?? ?? F5 68 12 E0 D9 F8 08 30 6D 1E 53 F8 25 80 B3 68 B8 F1 00 0F 43 F8 25 80 07 D0 D8 F8 00 30 5C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 00 2D EA D1 38 46 ?? ?? ?? ?? 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_241_1 {
	meta:
		name = "?_Locinfo_Addcats@_Locinfo@std@@SAAAV12@PAV12@HPBD@Z"
		size = 208
		refs = "003e setlocale 005e free 007c strcmp 00a8 malloc 00b4 memcpy 00c0 ?_Xruntime_error@std@@YAXPBD@Z 00c8 ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@ 00cc ??_C@_01NBENCBCI@?$CK?$AA@"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 16 46 00 2E 0F 46 05 46 55 D0 92 F9 00 30 2A 2B 02 D1 92 F9 01 30 CB B1 0F B9 00 21 11 E0 3F 2F 0E D0 00 24 4F F0 01 08 08 FA 04 F3 17 EA 63 0F 03 D0 31 46 20 46 ?? ?? ?? ?? 64 1C 05 2C F3 DD 31 46 00 20 ?? ?? ?? ?? 04 46 74 B9 E8 6A 1D 4C A0 42 2D D0 08 B1 ?? ?? ?? ?? 00 23 EB 62 22 46 12 F9 01 3F 00 2B FB D1 18 E0 E8 6A 08 B9 05 F1 30 00 14 49 ?? ?? ?? ?? D0 B1 E8 6A A0 42 17 D0 08 B1 ?? ?? ?? ?? 00 23 EB 62 94 F9 00 30 22 46 02 E0 52 1C 92 F9 00 30 00 2B FA D1 16 1B 70 1C ?? ?? ?? ?? E8 62 18 B1 72 1C 21 46 ?? ?? ?? ?? 28 46 BD E8 F8 89 02 48 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_242_1 {
	meta:
		name = "?_Locinfo_ctor@_Locinfo@std@@SAXPAV12@HPBD@Z"
		size = 104
		refs = "0012 setlocale 0024 free 0044 malloc 0050 memcpy 005a ?_Locinfo_Addcats@_Locinfo@std@@SAAAV12@PAV12@HPBD@Z 0064 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 88 46 05 46 00 21 00 20 17 46 ?? ?? ?? ?? 04 46 04 B9 12 4C 68 6A A0 42 18 D0 08 B1 ?? ?? ?? ?? 00 23 6B 62 94 B1 94 F9 00 30 22 46 02 E0 52 1C 92 F9 00 30 00 2B FA D1 16 1B 70 1C ?? ?? ?? ?? 68 62 18 B1 72 1C 21 46 ?? ?? ?? ?? 3A 46 41 46 28 46 ?? ?? ?? ?? BD E8 F8 89 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_243_1 {
	meta:
		name = "?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 884
		refs = "0044 ??0_Lockit@std@@QAA@H@Z 0058 ??1_Lockit@std@@QAA@XZ 0064 ??2@YAPAXI@Z 0076 _Getctype 0092 ?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 00c4 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0184 ??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 01ba ??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0212 ?_Init@?$numpunct@D@std@@IAAXABV_Locinfo@2@_N@Z 0242 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 02ba ??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 02d4 ?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 02e0 ?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 02ec ?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 030c free 032e malloc 033c memcpy 0348 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 034c ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 0350 ??_7?$numpunct@D@std@@6B@ 0354 ?id@?$numpunct@D@std@@2V0locale@2@A 0358 ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 035c ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0360 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0364 ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0368 ?id@?$ctype@D@std@@2V0locale@2@A 036c ??_7?$ctype@D@std@@6B@ 0370 ?_Id_cnt@id@locale@std@@0HA"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8D B0 6F 46 99 46 FB 60 6F F0 01 03 C7 E9 06 33 00 24 11 F0 02 03 3C 61 D3 4E 3B 61 90 46 C7 E9 00 10 52 D0 B9 F1 00 0F 34 D1 CD 4D D5 F8 00 A0 BA F1 00 0F 11 D1 17 F1 08 00 00 21 ?? ?? ?? ?? 2C 68 1C B9 33 68 5B 1C 33 60 2B 60 17 F1 08 00 ?? ?? ?? ?? D5 F8 00 A0 00 24 18 20 ?? ?? ?? ?? 81 46 68 B1 BF 4B C0 E9 00 34 17 F1 20 00 ?? ?? ?? ?? 17 F1 20 04 0F CC 09 F1 08 05 0F C5 01 E0 4F F0 00 09 52 46 49 46 40 46 ?? ?? ?? ?? D7 F8 0C 90 1A E0 B2 4C 25 68 7D B9 17 F1 0C 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 0C 00 ?? ?? ?? ?? 25 68 48 46 ?? ?? ?? ?? 01 46 40 46 2A 46 ?? ?? ?? ?? 3B 68 13 F0 08 0A 76 D0 A2 4C B9 F1 00 0F 25 68 3D D1 7D B9 17 F1 0C 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 0C 00 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 20 B1 00 23 43 60 93 4B 03 60 00 E0 00 20 01 46 40 46 2A 46 ?? ?? ?? ?? 8C 4C 25 68 7D B9 17 F1 0C 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 0C 00 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 20 B1 00 23 43 60 81 4B 03 60 30 E0 00 20 2E E0 7D B9 17 F1 0C 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 0C 00 ?? ?? ?? ?? 25 68 48 46 ?? ?? ?? ?? 01 46 40 46 2A 46 ?? ?? ?? ?? 71 4C 25 68 7D B9 17 F1 0C 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 0C 00 ?? ?? ?? ?? 25 68 48 46 ?? ?? ?? ?? 01 46 40 46 2A 46 ?? ?? ?? ?? BA F1 00 0F 40 D0 61 4C B9 F1 00 0F 25 68 22 D1 7D B9 17 F1 0C 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 0C 00 ?? ?? ?? ?? 25 68 18 20 ?? ?? ?? ?? 04 46 FC 60 44 B1 00 23 63 60 51 4B 79 68 00 22 23 60 ?? ?? ?? ?? 00 E0 00 24 21 46 14 E0 7D B9 17 F1 0C 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 0C 00 ?? ?? ?? ?? 25 68 48 46 ?? ?? ?? ?? 01 46 2A 46 40 46 ?? ?? ?? ?? 3B 69 CB B3 3D 4C B9 F1 00 0F 25 68 1B D1 7D B9 17 F1 10 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 10 00 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 20 B1 00 23 43 60 2E 4B 03 60 15 E0 00 20 13 E0 7D B9 17 F1 10 00 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 17 F1 10 00 ?? ?? ?? ?? 25 68 48 46 ?? ?? ?? ?? 01 46 40 46 2A 46 ?? ?? ?? ?? D7 E9 00 45 4B 46 42 46 21 46 28 46 ?? ?? ?? ?? 4B 46 42 46 21 46 28 46 ?? ?? ?? ?? 4B 46 42 46 21 46 28 46 ?? ?? ?? ?? D8 F8 10 30 23 43 C8 F8 10 30 EC 6A 0C B9 05 F1 30 04 D8 F8 18 00 A0 42 1A D0 08 B1 ?? ?? ?? ?? 00 23 C8 F8 18 30 9C B1 94 F9 00 30 22 46 02 E0 52 1C 92 F9 00 30 00 2B FA D1 15 1B 68 1C ?? ?? ?? ?? C8 F8 18 00 18 B1 6A 1C 21 46 ?? ?? ?? ?? 40 46 0D B0 BD E8 F0 8F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_247_1 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ"
		size = 22
		altNames = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAPBDXZ ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAAPADXZ ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QBAPBDXZ ?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAPBDXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 83 69 10 2B 01 D3 40 68 00 E0 00 1D BD E8 00 88 }
	condition:
		$1
}

rule file_12_256_1 {
	meta:
		name = "?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ"
		size = 76
		refs = "002a _guard_check_icall"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2E 68 B6 B1 F3 69 1A 68 12 B1 F3 6A 1B 68 00 E0 00 23 00 2B 01 DD 10 78 06 E0 33 68 9C 69 20 46 ?? ?? ?? ?? 30 46 A0 47 B0 F1 FF 3F 01 D0 68 71 01 E0 00 23 2B 60 01 23 95 F9 05 00 2B 71 BD E8 78 88 }
	condition:
		$1
}

rule file_12_257_1 {
	meta:
		name = "?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBA_JXZ"
		size = 26
		altNames = "?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBA_JXZ ?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBA_JXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 6A 1B 68 13 B1 03 6B 18 68 00 E0 00 20 C1 17 BD E8 00 88 }
	condition:
		$1
}

rule file_12_258_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 02 6B 13 68 5B 1E 13 60 02 6A 10 68 43 1C 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_12_259_1 {
	meta:
		name = "?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PBDI@Z"
		size = 54
		refs = "001c ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@D@Z"
	strings:
		$1 = { 0F B4 2D E9 78 48 0D F1 10 0B 0B 9E CD E9 08 23 0C 46 4E B1 0A 9D 15 F9 01 1B 08 A8 ?? ?? ?? ?? 76 1E F8 D1 DD E9 08 23 C4 E9 00 23 20 46 BD E8 78 08 5D F8 14 FB }
	condition:
		$1
}

rule file_12_260_1 {
	meta:
		name = "?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z"
		size = 52
		refs = "001a ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@D@Z"
	strings:
		$1 = { 0F B4 2D E9 30 48 0D F1 08 0B 09 9D CD E9 06 23 0C 46 45 B1 9D F9 20 10 06 A8 ?? ?? ?? ?? 6D 1E F8 D1 DD E9 06 23 C4 E9 00 23 20 46 BD E8 30 08 5D F8 14 FB }
	condition:
		$1
}

rule file_12_261_1 {
	meta:
		name = "?_Stodx_v2@std@@YANPBDPAPADHPAH@Z"
		size = 90
		refs = "0014 _errno 0024 strtod 0046 pow"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 02 8B 98 46 91 46 0C 46 05 46 ?? ?? ?? ?? 07 46 3E 68 28 46 00 23 21 46 3B 60 ?? ?? ?? ?? 39 68 B0 EE 40 8B B9 F1 00 0F C8 F8 00 10 3E 60 09 D0 02 EE 10 9A B2 EE 04 0B B8 EE C2 1B ?? ?? ?? ?? 20 EE 08 8B B0 EE 48 0B BD EC 02 8B BD E8 F0 8B }
	condition:
		$1
}

rule file_12_262_1 {
	meta:
		name = "?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z"
		size = 90
		refs = "0014 _errno 0024 strtof 0046 powf"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 02 8B 98 46 91 46 0C 46 05 46 ?? ?? ?? ?? 07 46 3E 68 28 46 00 23 21 46 3B 60 ?? ?? ?? ?? 39 68 B0 EE 40 8A B9 F1 00 0F C8 F8 00 10 3E 60 09 D0 02 EE 10 9A B2 EE 04 0A F8 EE C2 0A ?? ?? ?? ?? 20 EE 08 8A B0 EE 48 0A BD EC 02 8B BD E8 F0 8B }
	condition:
		$1
}

rule file_12_265_1 {
	meta:
		name = "?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z"
		size = 54
		refs = "001c memcpy 0022 ??3@YAXPAX@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 15 46 04 46 59 B1 A3 69 10 2B 08 D3 66 68 1D B1 20 1D 31 46 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 0F 23 C4 E9 05 53 23 1D 00 22 5A 55 BD E8 78 88 }
	condition:
		$1
}

rule file_12_266_1 {
	meta:
		name = "?_Tidy@?$ctype@D@std@@IAAXXZ"
		size = 42
		refs = "0012 free 001c ??_V@YAXPAX@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 69 00 2B 03 DD E0 68 ?? ?? ?? ?? 03 E0 02 DA E0 68 ?? ?? ?? ?? 60 69 BD E8 18 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_267_1 {
	meta:
		name = "?_Tidy@?$numpunct@D@std@@AAAXXZ"
		size = 32
		refs = "000c free"
		altNames = "?_Tidy@?$_Mpunct@D@std@@AAAXXZ ?_Tidy@?$_Mpunct@G@std@@AAAXXZ ?_Tidy@?$_Mpunct@_W@std@@AAAXXZ ?_Tidy@?$numpunct@G@std@@AAAXXZ ?_Tidy@?$numpunct@_W@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 A0 68 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 BD E8 18 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_271_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAPADI@Z"
		size = 30
		refs = "0010 ??2@YAPAXI@Z 0018 _invalid_parameter_noinfo_noreturn"
		altNames = "?allocate@?$allocator@D@std@@QAAPADI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 11 B9 00 20 BD E8 00 88 08 46 ?? ?? ?? ?? 00 28 F8 D1 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_272_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAAPAU_Container_proxy@2@I@Z"
		size = 44
		refs = "0018 ??2@YAPAXI@Z 0022 ?_Xbad_alloc@std@@YAXXZ 0026 _invalid_parameter_noinfo_noreturn"
		altNames = "?allocate@?$allocator@U_Container_proxy@std@@@std@@QAAPAU_Container_proxy@2@I@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 11 B9 00 20 BD E8 00 88 6F F0 60 43 99 42 05 D8 C8 00 ?? ?? ?? ?? 00 28 F4 D1 01 E0 ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_276_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 130
		refs = "0030 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0058 memcpy 0076 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 007c ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0E 46 1D 46 73 69 90 46 04 46 43 45 2E D3 9B 1A 62 69 9D 42 88 BF 1D 46 D3 43 AB 42 29 D9 57 19 0D B3 00 22 39 46 20 46 ?? ?? ?? ?? D8 B1 B3 69 10 2B 01 D3 71 68 00 E0 31 1D A3 69 10 2B 01 D3 62 68 00 E0 22 1D 2D B1 63 69 41 44 D0 18 2A 46 ?? ?? ?? ?? A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 67 61 DA 55 20 46 BD E8 F8 89 30 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_277_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z"
		size = 110
		refs = "001e ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 004a memset 0068 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 04 46 0D 46 61 69 17 46 CB 43 AB 42 27 D9 4E 19 15 B3 00 22 31 46 ?? ?? ?? ?? E8 B1 D4 E9 05 23 01 2D 06 D1 10 2B 01 D3 63 68 00 E0 23 1D 9F 54 09 E0 10 2B 01 D3 63 68 00 E0 23 1D 98 18 2A 46 39 46 ?? ?? ?? ?? A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 9A 55 20 46 BD E8 F0 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_278_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@$$QAV12@@Z"
		size = 104
		refs = "0022 ??3@YAXPAX@Z 0042 memmove"
		altNames = "??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@$$QAV01@@Z"
	strings:
		$1 = { 2D E9 FE 49 0D F1 20 0B 6F 46 0D 46 04 46 6F F0 01 03 C7 E9 00 33 AC 42 23 D0 A3 69 10 2B 02 D3 60 68 ?? ?? ?? ?? 4F F0 0F 08 00 26 C4 E9 05 68 26 71 AB 69 10 2B 07 D2 6B 69 5A 1C 0A D0 29 1D 20 1D ?? ?? ?? ?? 05 E0 14 F1 04 0F 01 D0 6B 68 63 60 6E 60 6B 69 63 61 AB 69 A3 61 C5 E9 05 68 2E 71 20 46 BD E8 FE 89 }
	condition:
		$1
}

rule file_12_280_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 154
		refs = "0040 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@II@Z 004c ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0070 memcpy 008e ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0E 46 1D 46 73 69 17 46 04 46 BB 42 3A D3 DB 1B 9D 42 88 BF 1D 46 B4 42 11 D1 63 69 EA 19 93 42 33 D3 A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 21 62 61 99 54 3A 46 20 46 ?? ?? ?? ?? 1F E0 00 22 29 46 20 46 ?? ?? ?? ?? C8 B1 B3 69 10 2B 01 D3 72 68 00 E0 32 1D A3 69 10 2B 01 D3 60 68 00 E0 20 1D 1D B1 D1 19 2A 46 ?? ?? ?? ?? A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 5A 55 20 46 BD E8 F0 88 30 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_281_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z"
		size = 96
		refs = "0016 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 003e memset 005a ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 16 46 0D 46 04 46 B1 F1 FF 3F 22 D0 00 22 ?? ?? ?? ?? D8 B1 A3 69 01 2D 06 D1 10 2B 01 D3 63 68 00 E0 23 1D 1E 70 08 E0 10 2B 01 D3 60 68 00 E0 20 1D 2A 46 31 46 ?? ?? ?? ?? A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 5A 55 20 46 BD E8 78 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_282_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBD@Z"
		size = 42
		refs = "0018 strlen 0022 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 91 F9 00 30 0C 46 05 46 0B B9 00 20 02 E0 20 46 ?? ?? ?? ?? 02 46 28 46 21 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_68_250_2 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBD@Z"
		size = 42
		refs = "0018 strlen 0022 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 91 F9 00 30 0C 46 05 46 0B B9 00 20 02 E0 20 46 ?? ?? ?? ?? 02 46 28 46 21 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_12_283_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
		size = 134
		refs = "0044 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 0052 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 006a memcpy"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0E 46 15 46 04 46 EE B1 A2 69 10 2A 01 D3 63 68 00 E0 23 1D 9E 42 15 D3 10 2A 01 D3 61 68 00 E0 21 1D 63 69 0B 44 B3 42 0C D9 10 2A 01 D3 63 68 00 E0 23 1D F2 1A 2B 46 21 46 20 46 ?? ?? ?? ?? 04 46 19 E0 00 22 29 46 20 46 ?? ?? ?? ?? 98 B1 A3 69 10 2B 01 D3 60 68 00 E0 20 1D 1D B1 2A 46 31 46 ?? ?? ?? ?? A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 5A 55 20 46 BD E8 78 88 }
	condition:
		$1
}

rule file_12_284_1 {
	meta:
		name = "?assign@?$char_traits@D@std@@SAPADPADID@Z"
		size = 20
		refs = "0010 memset"
	strings:
		$1 = { 2D E9 00 48 EB 46 13 46 0A 46 19 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_288_1 {
	meta:
		name = "?c_str@locale@std@@QBAPBDXZ"
		size = 32
		refs = "001c ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 68 0B B9 04 48 03 E0 98 69 08 B9 03 F1 1C 00 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_294_1 {
	meta:
		name = "?decimal_point@?$numpunct@D@std@@QBADXZ"
		size = 28
		refs = "0010 _guard_check_icall"
		altNames = "?always_noconv@codecvt_base@std@@QBA_NXZ ?date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QBA?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QBA?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QBA?AW4dateorder@time_base@2@XZ ?decimal_point@?$_Mpunct@D@std@@QBADXZ ?decimal_point@?$_Mpunct@G@std@@QBAGXZ ?decimal_point@?$_Mpunct@_W@std@@QBA_WXZ ?decimal_point@?$numpunct@G@std@@QBAGXZ ?decimal_point@?$numpunct@_W@std@@QBA_WXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 68 DC 68 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 }
	condition:
		$1
}

rule file_12_299_1 {
	meta:
		name = "?do_falsename@?$numpunct@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z"
		altNames = "?do_curr_symbol@?$_Mpunct@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 01 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_995_1 {
	meta:
		name = "?do_curr_symbol@?$_Mpunct@G@std@@MBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBG@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 01 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_996_1 {
	meta:
		name = "?do_curr_symbol@?$_Mpunct@_W@std@@MBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 01 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1006_1 {
	meta:
		name = "?do_falsename@?$numpunct@G@std@@MBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBG@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 01 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1007_1 {
	meta:
		name = "?do_falsename@?$numpunct@_W@std@@MBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 01 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_300_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 262
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0090 _Stoulx 00a0 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00fa __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 A0 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 81 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F9 18 30 2D 2B 02 D1 17 F1 19 05 01 E0 17 F1 18 05 3B 46 39 1D 4A 46 28 46 ?? ?? ?? ?? 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? BA 6E 3B 6F 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 AB 42 0D D0 3B 68 5B B9 4F F6 FF 73 9C 42 07 D8 97 F9 18 30 2D 2B 08 BF 64 42 AA F8 00 40 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 23 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1020_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 262
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0090 _Stoulx 00a0 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00fa __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 A0 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 81 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F9 18 30 2D 2B 02 D1 17 F1 19 05 01 E0 17 F1 18 05 3B 46 39 1D 4A 46 28 46 ?? ?? ?? ?? 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? BA 6E 3B 6F 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 AB 42 0D D0 3B 68 5B B9 4F F6 FF 73 9C 42 07 D8 97 F9 18 30 2D 2B 08 BF 64 42 AA F8 00 40 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 23 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1052_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 262
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0090 _Stoulx 00a0 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00fa __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 A0 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 81 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F9 18 30 2D 2B 02 D1 17 F1 19 05 01 E0 17 F1 18 05 3B 46 39 1D 4A 46 28 46 ?? ?? ?? ?? 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? BA 6E 3B 6F 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 AB 42 0D D0 3B 68 5B B9 4F F6 FF 73 9C 42 07 D8 97 F9 18 30 2D 2B 08 BF 64 42 AA F8 00 40 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 23 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_303_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 254
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0090 _Stoulx 00a0 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00f2 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 A0 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 81 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F9 18 30 2D 2B 02 D1 17 F1 19 05 01 E0 17 F1 18 05 3B 46 39 1D 4A 46 28 46 ?? ?? ?? ?? 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? BA 6E 3B 6F 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 AB 42 09 D0 3B 68 3B B9 97 F9 18 30 2D 2B 08 BF 64 42 CA F8 00 40 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 23 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1023_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 254
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0090 _Stoulx 00a0 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00f2 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 A0 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 81 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F9 18 30 2D 2B 02 D1 17 F1 19 05 01 E0 17 F1 18 05 3B 46 39 1D 4A 46 28 46 ?? ?? ?? ?? 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? BA 6E 3B 6F 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 AB 42 09 D0 3B 68 3B B9 97 F9 18 30 2D 2B 08 BF 64 42 CA F8 00 40 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 23 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1055_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 254
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0090 _Stoulx 00a0 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00f2 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 A0 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 81 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F9 18 30 2D 2B 02 D1 17 F1 19 05 01 E0 17 F1 18 05 3B 46 39 1D 4A 46 28 46 ?? ?? ?? ?? 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? BA 6E 3B 6F 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 AB 42 09 D0 3B 68 3B B9 97 F9 18 30 2D 2B 08 BF 64 42 CA F8 00 40 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 23 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_306_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 230
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0058 _Stolx 0068 _guard_check_icall 008e ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00da __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 90 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 02 46 17 F1 18 00 3B 46 39 1D ?? ?? ?? ?? 82 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F8 6C 30 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 C9 F8 00 A0 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_309_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 230
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0058 _Stoulx 0068 _guard_check_icall 008e ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00da __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 90 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 02 46 17 F1 18 00 3B 46 39 1D ?? ?? ?? ?? 82 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F8 6C 30 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 C9 F8 00 A0 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1026_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 230
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0058 _Stolx 0068 _guard_check_icall 008e ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00da __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 90 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 02 46 17 F1 18 00 3B 46 39 1D ?? ?? ?? ?? 82 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F8 6C 30 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 C9 F8 00 A0 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1029_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 230
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0058 _Stoulx 0068 _guard_check_icall 008e ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00da __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 90 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 02 46 17 F1 18 00 3B 46 39 1D ?? ?? ?? ?? 82 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F8 6C 30 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 C9 F8 00 A0 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1058_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 230
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0058 _Stolx 0068 _guard_check_icall 008e ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00da __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 90 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 02 46 17 F1 18 00 3B 46 39 1D ?? ?? ?? ?? 82 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F8 6C 30 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 C9 F8 00 A0 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1061_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 230
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0058 _Stoulx 0068 _guard_check_icall 008e ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00da __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 BC 6F 6F F0 01 03 C7 E9 04 33 FE 6F D7 F8 80 90 00 23 88 46 05 46 20 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 68 02 00 93 17 F1 70 03 17 F1 18 01 28 46 ?? ?? ?? ?? 02 46 17 F1 18 00 3B 46 39 1D ?? ?? ?? ?? 82 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 97 F8 6C 30 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 C9 F8 00 A0 03 E0 33 68 43 F0 02 03 33 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_312_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 196
		refs = "000e __security_push_cookie 0032 ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 003e ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 0054 ldexp 0064 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00ae __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 2D ED 02 8B ?? ?? ?? ?? AD F5 4D 7D DC 9A 00 23 29 4C CD E9 02 43 02 AB DD 9D DE 9F 01 93 0E 46 00 92 DA AB D8 AA 06 A9 ?? ?? ?? ?? 02 46 06 A8 03 AB 04 A9 ?? ?? ?? ?? 02 9B B0 EE 40 8A A3 42 07 D0 33 B1 B7 EE C0 0A 98 00 ?? ?? ?? ?? B7 EE C0 8B 9D F8 64 33 13 B9 D8 A8 ?? ?? ?? ?? 9D F8 6C 33 13 B9 DA A8 ?? ?? ?? ?? D8 99 DA 9B 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 04 9B 06 AA 93 42 04 D0 03 9B 13 B9 87 ED 00 8A 03 E0 2B 68 43 F0 02 03 2B 60 D9 9B C6 E9 00 13 30 46 0D F5 4D 7D ?? ?? ?? ?? BD EC 02 8B BD E8 F0 08 5D F8 14 FB FE DE 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_1032_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 196
		refs = "000e __security_push_cookie 0032 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 003e ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 0054 ldexp 0064 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00ae __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 2D ED 02 8B ?? ?? ?? ?? AD F5 4D 7D DC 9A 00 23 29 4C CD E9 02 43 02 AB DD 9D DE 9F 01 93 0E 46 00 92 DA AB D8 AA 06 A9 ?? ?? ?? ?? 02 46 06 A8 03 AB 04 A9 ?? ?? ?? ?? 02 9B B0 EE 40 8A A3 42 07 D0 33 B1 B7 EE C0 0A 98 00 ?? ?? ?? ?? B7 EE C0 8B 9D F8 64 33 13 B9 D8 A8 ?? ?? ?? ?? 9D F8 6C 33 13 B9 DA A8 ?? ?? ?? ?? D8 99 DA 9B 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 04 9B 06 AA 93 42 04 D0 03 9B 13 B9 87 ED 00 8A 03 E0 2B 68 43 F0 02 03 2B 60 D9 9B C6 E9 00 13 30 46 0D F5 4D 7D ?? ?? ?? ?? BD EC 02 8B BD E8 F0 08 5D F8 14 FB FE DE 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_1064_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 196
		refs = "000e __security_push_cookie 0032 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 003e ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 0054 ldexp 0064 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00ae __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 2D ED 02 8B ?? ?? ?? ?? AD F5 4D 7D DC 9A 00 23 29 4C CD E9 02 43 02 AB DD 9D DE 9F 01 93 0E 46 00 92 DA AB D8 AA 06 A9 ?? ?? ?? ?? 02 46 06 A8 03 AB 04 A9 ?? ?? ?? ?? 02 9B B0 EE 40 8A A3 42 07 D0 33 B1 B7 EE C0 0A 98 00 ?? ?? ?? ?? B7 EE C0 8B 9D F8 64 33 13 B9 D8 A8 ?? ?? ?? ?? 9D F8 6C 33 13 B9 DA A8 ?? ?? ?? ?? D8 99 DA 9B 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 04 9B 06 AA 93 42 04 D0 03 9B 13 B9 87 ED 00 8A 03 E0 2B 68 43 F0 02 03 2B 60 D9 9B C6 E9 00 13 30 46 0D F5 4D 7D ?? ?? ?? ?? BD EC 02 8B BD E8 F0 08 5D F8 14 FB FE DE 00 CA 9A 3B }
	condition:
		$1
}

rule file_12_313_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 192
		refs = "000e __security_push_cookie 0032 ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 003e ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0050 ldexp 0060 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00aa __security_pop_cookie"
		altNames = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 2D ED 02 8B ?? ?? ?? ?? AD F5 4D 7D DC 9A 00 23 28 4C CD E9 02 43 02 AB DD 9D DE 9F 01 93 0E 46 00 92 DA AB D8 AA 06 A9 ?? ?? ?? ?? 02 46 06 A8 03 AB 04 A9 ?? ?? ?? ?? 02 9B B0 EE 40 8B A3 42 05 D0 23 B1 98 00 ?? ?? ?? ?? B0 EE 40 8B 9D F8 64 33 13 B9 D8 A8 ?? ?? ?? ?? 9D F8 6C 33 13 B9 DA A8 ?? ?? ?? ?? D8 99 DA 9B 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 04 9B 06 AA 93 42 04 D0 03 9B 13 B9 87 ED 00 8B 03 E0 2B 68 43 F0 02 03 2B 60 D9 9B C6 E9 00 13 30 46 0D F5 4D 7D ?? ?? ?? ?? BD EC 02 8B BD E8 F0 08 5D F8 14 FB FE DE 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_1033_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 192
		refs = "000e __security_push_cookie 0032 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 003e ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0050 ldexp 0060 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00aa __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 2D ED 02 8B ?? ?? ?? ?? AD F5 4D 7D DC 9A 00 23 28 4C CD E9 02 43 02 AB DD 9D DE 9F 01 93 0E 46 00 92 DA AB D8 AA 06 A9 ?? ?? ?? ?? 02 46 06 A8 03 AB 04 A9 ?? ?? ?? ?? 02 9B B0 EE 40 8B A3 42 05 D0 23 B1 98 00 ?? ?? ?? ?? B0 EE 40 8B 9D F8 64 33 13 B9 D8 A8 ?? ?? ?? ?? 9D F8 6C 33 13 B9 DA A8 ?? ?? ?? ?? D8 99 DA 9B 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 04 9B 06 AA 93 42 04 D0 03 9B 13 B9 87 ED 00 8B 03 E0 2B 68 43 F0 02 03 2B 60 D9 9B C6 E9 00 13 30 46 0D F5 4D 7D ?? ?? ?? ?? BD EC 02 8B BD E8 F0 08 5D F8 14 FB FE DE 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_1034_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
		size = 192
		refs = "000e __security_push_cookie 0032 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 003e ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0050 ldexp 0060 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00aa __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 2D ED 02 8B ?? ?? ?? ?? AD F5 4D 7D DC 9A 00 23 28 4C CD E9 02 43 02 AB DD 9D DE 9F 01 93 0E 46 00 92 DA AB D8 AA 06 A9 ?? ?? ?? ?? 02 46 06 A8 03 AB 04 A9 ?? ?? ?? ?? 02 9B B0 EE 40 8B A3 42 05 D0 23 B1 98 00 ?? ?? ?? ?? B0 EE 40 8B 9D F8 64 33 13 B9 D8 A8 ?? ?? ?? ?? 9D F8 6C 33 13 B9 DA A8 ?? ?? ?? ?? D8 99 DA 9B 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 04 9B 06 AA 93 42 04 D0 03 9B 13 B9 87 ED 00 8B 03 E0 2B 68 43 F0 02 03 2B 60 D9 9B C6 E9 00 13 30 46 0D F5 4D 7D ?? ?? ?? ?? BD EC 02 8B BD E8 F0 08 5D F8 14 FB FE DE 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_1065_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 192
		refs = "000e __security_push_cookie 0032 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 003e ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0050 ldexp 0060 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00aa __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 2D ED 02 8B ?? ?? ?? ?? AD F5 4D 7D DC 9A 00 23 28 4C CD E9 02 43 02 AB DD 9D DE 9F 01 93 0E 46 00 92 DA AB D8 AA 06 A9 ?? ?? ?? ?? 02 46 06 A8 03 AB 04 A9 ?? ?? ?? ?? 02 9B B0 EE 40 8B A3 42 05 D0 23 B1 98 00 ?? ?? ?? ?? B0 EE 40 8B 9D F8 64 33 13 B9 D8 A8 ?? ?? ?? ?? 9D F8 6C 33 13 B9 DA A8 ?? ?? ?? ?? D8 99 DA 9B 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 04 9B 06 AA 93 42 04 D0 03 9B 13 B9 87 ED 00 8B 03 E0 2B 68 43 F0 02 03 2B 60 D9 9B C6 E9 00 13 30 46 0D F5 4D 7D ?? ?? ?? ?? BD EC 02 8B BD E8 F0 08 5D F8 14 FB FE DE 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_1066_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
		size = 192
		refs = "000e __security_push_cookie 0032 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 003e ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0050 ldexp 0060 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00aa __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 2D ED 02 8B ?? ?? ?? ?? AD F5 4D 7D DC 9A 00 23 28 4C CD E9 02 43 02 AB DD 9D DE 9F 01 93 0E 46 00 92 DA AB D8 AA 06 A9 ?? ?? ?? ?? 02 46 06 A8 03 AB 04 A9 ?? ?? ?? ?? 02 9B B0 EE 40 8B A3 42 05 D0 23 B1 98 00 ?? ?? ?? ?? B0 EE 40 8B 9D F8 64 33 13 B9 D8 A8 ?? ?? ?? ?? 9D F8 6C 33 13 B9 DA A8 ?? ?? ?? ?? D8 99 DA 9B 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 04 9B 06 AA 93 42 04 D0 03 9B 13 B9 87 ED 00 8B 03 E0 2B 68 43 F0 02 03 2B 60 D9 9B C6 E9 00 13 30 46 0D F5 4D 7D ?? ?? ?? ?? BD EC 02 8B BD E8 F0 08 5D F8 14 FB FE DE 00 CA 9A 3B }
	condition:
		$1
}

rule file_12_315_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 236
		refs = "000a __security_push_cookie 0030 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0080 _Stoulx 0094 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00e0 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 6F F0 01 03 04 46 B8 6F C7 E9 04 33 FD 6F D7 F8 80 A0 00 23 88 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 4F F4 00 63 00 93 01 90 17 F1 70 03 17 F1 68 02 17 F1 18 01 20 46 ?? ?? ?? ?? 81 46 FE 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 3B 46 39 1D 17 F1 18 00 4A 46 ?? ?? ?? ?? 00 23 FB 60 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 CA F8 00 40 03 E0 2B 68 43 F0 02 03 2B 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1035_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 236
		refs = "000a __security_push_cookie 0030 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0080 _Stoulx 0094 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00e0 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 6F F0 01 03 04 46 B8 6F C7 E9 04 33 FD 6F D7 F8 80 A0 00 23 88 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 4F F4 00 63 00 93 01 90 17 F1 70 03 17 F1 68 02 17 F1 18 01 20 46 ?? ?? ?? ?? 81 46 FE 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 3B 46 39 1D 17 F1 18 00 4A 46 ?? ?? ?? ?? 00 23 FB 60 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 CA F8 00 40 03 E0 2B 68 43 F0 02 03 2B 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1067_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 236
		refs = "000a __security_push_cookie 0030 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004a ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005a _guard_check_icall 0080 _Stoulx 0094 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00e0 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 82 B0 6F F0 01 03 04 46 B8 6F C7 E9 04 33 FD 6F D7 F8 80 A0 00 23 88 46 17 F1 08 01 3B 60 ?? ?? ?? ?? 4F F4 00 63 00 93 01 90 17 F1 70 03 17 F1 68 02 17 F1 18 01 20 46 ?? ?? ?? ?? 81 46 FE 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 3B 46 39 1D 17 F1 18 00 4A 46 ?? ?? ?? ?? 00 23 FB 60 97 F8 6C 30 04 46 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 7B 68 17 F1 18 02 93 42 04 D0 3B 68 13 B9 CA F8 00 40 03 E0 2B 68 43 F0 02 03 2B 60 FB 6E C8 E9 00 13 40 46 10 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_318_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 242
		refs = "000a __security_push_cookie 0036 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005e _Stollx 0072 _guard_check_icall 009a ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00e6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 90 B0 6F 46 82 B0 D7 F8 80 40 6F F0 01 03 C7 E9 06 33 D7 F8 84 60 D7 F8 88 90 00 23 88 46 05 46 20 46 17 F1 10 01 7B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 70 02 00 93 17 F1 78 03 17 F1 20 01 28 46 ?? ?? ?? ?? 02 46 17 F1 20 00 3B 1D 17 F1 08 01 ?? ?? ?? ?? 04 46 3C 60 8A 46 7D 69 8D B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3C 68 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? 97 F8 7C 30 1B B9 17 F1 78 00 ?? ?? ?? ?? 39 6F BB 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 BB 68 17 F1 20 02 93 42 04 D0 7B 68 13 B9 C9 E9 00 4A 03 E0 33 68 43 F0 02 03 33 60 7B 6F C8 E9 00 13 40 46 12 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_321_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 242
		refs = "000a __security_push_cookie 0036 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005e _Stoullx 0072 _guard_check_icall 009a ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 00e6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 90 B0 6F 46 82 B0 D7 F8 80 40 6F F0 01 03 C7 E9 06 33 D7 F8 84 60 D7 F8 88 90 00 23 88 46 05 46 20 46 17 F1 10 01 7B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 70 02 00 93 17 F1 78 03 17 F1 20 01 28 46 ?? ?? ?? ?? 02 46 17 F1 20 00 3B 1D 17 F1 08 01 ?? ?? ?? ?? 04 46 3C 60 8A 46 7D 69 8D B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3C 68 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? 97 F8 7C 30 1B B9 17 F1 78 00 ?? ?? ?? ?? 39 6F BB 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 BB 68 17 F1 20 02 93 42 04 D0 7B 68 13 B9 C9 E9 00 4A 03 E0 33 68 43 F0 02 03 33 60 7B 6F C8 E9 00 13 40 46 12 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1038_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 242
		refs = "000a __security_push_cookie 0036 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005e _Stollx 0072 _guard_check_icall 009a ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00e6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 90 B0 6F 46 82 B0 D7 F8 80 40 6F F0 01 03 C7 E9 06 33 D7 F8 84 60 D7 F8 88 90 00 23 88 46 05 46 20 46 17 F1 10 01 7B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 70 02 00 93 17 F1 78 03 17 F1 20 01 28 46 ?? ?? ?? ?? 02 46 17 F1 20 00 3B 1D 17 F1 08 01 ?? ?? ?? ?? 04 46 3C 60 8A 46 7D 69 8D B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3C 68 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? 97 F8 7C 30 1B B9 17 F1 78 00 ?? ?? ?? ?? 39 6F BB 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 BB 68 17 F1 20 02 93 42 04 D0 7B 68 13 B9 C9 E9 00 4A 03 E0 33 68 43 F0 02 03 33 60 7B 6F C8 E9 00 13 40 46 12 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1041_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 242
		refs = "000a __security_push_cookie 0036 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005e _Stoullx 0072 _guard_check_icall 009a ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00e6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 90 B0 6F 46 82 B0 D7 F8 80 40 6F F0 01 03 C7 E9 06 33 D7 F8 84 60 D7 F8 88 90 00 23 88 46 05 46 20 46 17 F1 10 01 7B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 70 02 00 93 17 F1 78 03 17 F1 20 01 28 46 ?? ?? ?? ?? 02 46 17 F1 20 00 3B 1D 17 F1 08 01 ?? ?? ?? ?? 04 46 3C 60 8A 46 7D 69 8D B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3C 68 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? 97 F8 7C 30 1B B9 17 F1 78 00 ?? ?? ?? ?? 39 6F BB 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 BB 68 17 F1 20 02 93 42 04 D0 7B 68 13 B9 C9 E9 00 4A 03 E0 33 68 43 F0 02 03 33 60 7B 6F C8 E9 00 13 40 46 12 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1070_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 242
		refs = "000a __security_push_cookie 0036 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005e _Stollx 0072 _guard_check_icall 009a ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00e6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 90 B0 6F 46 82 B0 D7 F8 80 40 6F F0 01 03 C7 E9 06 33 D7 F8 84 60 D7 F8 88 90 00 23 88 46 05 46 20 46 17 F1 10 01 7B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 70 02 00 93 17 F1 78 03 17 F1 20 01 28 46 ?? ?? ?? ?? 02 46 17 F1 20 00 3B 1D 17 F1 08 01 ?? ?? ?? ?? 04 46 3C 60 8A 46 7D 69 8D B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3C 68 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? 97 F8 7C 30 1B B9 17 F1 78 00 ?? ?? ?? ?? 39 6F BB 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 BB 68 17 F1 20 02 93 42 04 D0 7B 68 13 B9 C9 E9 00 4A 03 E0 33 68 43 F0 02 03 33 60 7B 6F C8 E9 00 13 40 46 12 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1073_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 242
		refs = "000a __security_push_cookie 0036 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005e _Stoullx 0072 _guard_check_icall 009a ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00e6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 90 B0 6F 46 82 B0 D7 F8 80 40 6F F0 01 03 C7 E9 06 33 D7 F8 84 60 D7 F8 88 90 00 23 88 46 05 46 20 46 17 F1 10 01 7B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 70 02 00 93 17 F1 78 03 17 F1 20 01 28 46 ?? ?? ?? ?? 02 46 17 F1 20 00 3B 1D 17 F1 08 01 ?? ?? ?? ?? 04 46 3C 60 8A 46 7D 69 8D B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3C 68 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? 97 F8 7C 30 1B B9 17 F1 78 00 ?? ?? ?? ?? 39 6F BB 6F 09 B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 BB 68 17 F1 20 02 93 42 04 D0 7B 68 13 B9 C9 E9 00 4A 03 E0 33 68 43 F0 02 03 33 60 7B 6F C8 E9 00 13 40 46 12 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_324_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z"
		size = 536
		refs = "000a __security_push_cookie 0040 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0044 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 005c _guard_check_icall 0080 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 008a ?falsename@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0098 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 00a4 ??3@YAXPAX@Z 00c0 ??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@D@Z 00ca ?truename@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0112 ??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z 0158 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0168 _Stoulx 01bc ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 020c __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A2 B0 6F 46 82 B0 6F F0 01 03 C7 E9 08 33 D7 F8 D0 30 D7 F8 C8 40 D7 F8 CC 60 3B 61 63 69 80 46 89 46 13 F4 80 4F 6F F0 00 05 20 46 7D D0 17 F1 08 01 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 D7 F8 0C 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 17 F1 48 00 00 22 01 21 ?? ?? ?? ?? 17 F1 28 01 50 46 ?? ?? ?? ?? 01 46 17 F1 48 00 2B 46 00 22 ?? ?? ?? ?? 3B 6C 10 2B 02 D3 F8 6A ?? ?? ?? ?? 0F 23 B8 6A 3B 64 00 23 FB 63 87 F8 2C 30 ?? ?? ?? ?? 17 F1 48 00 00 21 ?? ?? ?? ?? 17 F1 28 01 50 46 ?? ?? ?? ?? 01 46 17 F1 48 00 2B 46 00 22 ?? ?? ?? ?? 3B 6C 10 2B 02 D3 F8 6A ?? ?? ?? ?? 0F 23 B8 6A 3B 64 00 23 FB 63 87 F8 2C 30 ?? ?? ?? ?? 3B 6E 10 2B 01 D3 FB 6C 01 E0 17 F1 4C 03 17 F1 C0 01 17 F1 B8 00 02 22 ?? ?? ?? ?? 05 46 3B 6E 10 2B 02 D3 F8 6C ?? ?? ?? ?? 0F 23 B8 6C 3B 66 00 23 FB 65 87 F8 4C 30 ?? ?? ?? ?? 3C E0 00 23 17 F1 18 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 B8 02 00 93 17 F1 C0 03 17 F1 68 01 40 46 ?? ?? ?? ?? 02 46 17 F1 68 00 3B 46 17 F1 08 01 ?? ?? ?? ?? 82 46 D7 F8 1C 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 BB 68 17 F1 68 02 93 42 05 D0 3B 68 1B B9 BA F1 01 0F 98 BF 55 46 97 F8 BC 30 1B B9 17 F1 B8 00 ?? ?? ?? ?? 97 F8 C4 30 1B B9 17 F1 C0 00 ?? ?? ?? ?? D7 F8 B8 20 D7 F8 C0 30 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 00 2D 04 DA 33 68 43 F0 02 03 33 60 05 E0 39 69 18 BF 01 23 08 BF 00 23 0B 70 D7 F8 BC 30 C9 E9 00 23 48 46 24 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_332_1 {
	meta:
		name = "?do_grouping@?$numpunct@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z"
		altNames = "?do_grouping@?$_Mpunct@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$_Mpunct@G@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$_Mpunct@_W@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$numpunct@G@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$numpunct@_W@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 81 68 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_333_1 {
	meta:
		name = "?do_in@?$codecvt@DDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z"
		size = 22
		altNames = "?do_out@?$codecvt@DDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 9B 03 20 1A 60 05 9A 03 9B 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_12_334_1 {
	meta:
		name = "?do_length@?$codecvt@DDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1I@Z"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 02 98 9B 1A 98 42 28 BF 18 46 BD E8 00 88 }
	condition:
		$1
}

rule file_12_337_1 {
	meta:
		name = "?do_narrow@?$ctype@D@std@@MBAPBDPBD0DPAD@Z"
		size = 24
		refs = "000e memcpy"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 98 14 46 62 1A ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_339_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DJ@Z"
		size = 92
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z 0028 sprintf_s 0042 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 004a __security_pop_cookie 0058 ??_C@_02EAOCLKAK@ld?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 11 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 40 21 ?? ?? ?? ?? 06 AB 02 93 9D F9 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_340_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DK@Z"
		size = 92
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z 0028 sprintf_s 0042 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 004a __security_pop_cookie 0058 ??_C@_02BDDLJJBK@lu?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 11 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 40 21 ?? ?? ?? ?? 06 AB 02 93 9D F9 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_341_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DN@Z"
		size = 388
		refs = "000e __security_push_cookie 0038 ??2@YAPAXI@Z 003e _invalid_parameter_noinfo_noreturn 00a2 frexp 00ee ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 00fc ?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADDH@Z 011c sprintf_s 0142 ?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 014e ??3@YAXPAX@Z 0168 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B ?? ?? ?? ?? 8E B0 6F 46 84 B0 BD 6F 6F F0 01 03 C7 E9 02 33 B0 EE 40 8B 0E 46 80 46 5A EC 10 9B 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 0F 20 1A 60 00 23 00 21 3B 75 C7 E9 09 10 D5 E9 05 34 EA 69 03 F4 40 53 B3 F5 00 5F 08 BF 01 23 18 BF 00 23 00 2A 04 DC 00 DB 14 B9 0B B9 06 24 00 22 7A 60 22 46 FB B1 9F ED 3C 0B B0 EE C8 1B B4 EE C1 0B F1 EE 10 FA 16 D2 38 46 B0 EE 48 0B ?? ?? ?? ?? 3A 68 82 EA E2 73 A3 EB E2 72 47 F2 97 53 02 FB 03 F1 2F 4B 81 FB 03 32 53 13 03 EB D3 73 D7 E9 09 10 1A 19 02 F1 32 03 8B 42 09 D8 10 28 01 D3 7A 69 01 E0 17 F1 14 02 00 21 7B 62 D1 54 05 E0 59 1A 17 F1 10 00 00 22 ?? ?? ?? ?? 6B 69 17 F1 30 01 00 22 40 46 ?? ?? ?? ?? BB 6A 02 46 10 2B 01 D3 78 69 01 E0 17 F1 14 00 79 6A 23 46 CD F8 00 90 CD F8 04 A0 ?? ?? ?? ?? BB 6A 10 2B 01 D3 7B 69 01 E0 17 F1 14 03 02 93 97 F9 7C 30 3A 6F 03 90 01 93 7B 6F 31 46 40 46 00 95 ?? ?? ?? ?? BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 30 46 BD 46 0E B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 0F 5D F8 14 FB 89 B5 F8 14 00 00 00 20 5F A0 02 42 }
	condition:
		$1
}

rule file_12_344_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DO@Z"
		size = 388
		refs = "000e __security_push_cookie 0038 ??2@YAPAXI@Z 003e _invalid_parameter_noinfo_noreturn 00a2 frexp 00ee ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 00fc ?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADDH@Z 011c sprintf_s 0142 ?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 014e ??3@YAXPAX@Z 0168 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B ?? ?? ?? ?? 8E B0 6F 46 84 B0 BD 6F 6F F0 01 03 C7 E9 02 33 B0 EE 40 8B 0E 46 80 46 5A EC 10 9B 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 0F 20 1A 60 00 23 00 21 3B 75 C7 E9 09 10 D5 E9 05 34 EA 69 03 F4 40 53 B3 F5 00 5F 08 BF 01 23 18 BF 00 23 00 2A 04 DC 00 DB 14 B9 0B B9 06 24 00 22 7A 60 22 46 FB B1 9F ED 3C 0B B0 EE C8 1B B4 EE C1 0B F1 EE 10 FA 16 D2 38 46 B0 EE 48 0B ?? ?? ?? ?? 3A 68 82 EA E2 73 A3 EB E2 72 47 F2 97 53 02 FB 03 F1 2F 4B 81 FB 03 32 53 13 03 EB D3 73 D7 E9 09 10 1A 19 02 F1 32 03 8B 42 09 D8 10 28 01 D3 7A 69 01 E0 17 F1 14 02 00 21 7B 62 D1 54 05 E0 59 1A 17 F1 10 00 00 22 ?? ?? ?? ?? 6B 69 17 F1 30 01 4C 22 40 46 ?? ?? ?? ?? BB 6A 02 46 10 2B 01 D3 78 69 01 E0 17 F1 14 00 79 6A 23 46 CD F8 00 90 CD F8 04 A0 ?? ?? ?? ?? BB 6A 10 2B 01 D3 7B 69 01 E0 17 F1 14 03 02 93 97 F9 7C 30 3A 6F 03 90 01 93 7B 6F 31 46 40 46 00 95 ?? ?? ?? ?? BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 30 46 BD 46 0E B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 0F 5D F8 14 FB 89 B5 F8 14 00 00 00 20 5F A0 02 42 }
	condition:
		$1
}

rule file_12_347_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBX@Z"
		size = 80
		refs = "000a __security_push_cookie 001e sprintf_s 0038 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0040 __security_pop_cookie 004c ??_C@_02BBAHNLBA@?$CFp?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 94 B0 20 9B 0E 4A 1E 9C 0E 46 05 46 04 A8 40 21 ?? ?? ?? ?? 04 AB 02 93 9D F9 7C 30 1C 9A 03 90 01 93 1D 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 14 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_348_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_J@Z"
		size = 96
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z 002e sprintf_s 0048 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0050 __security_pop_cookie 005c ??_C@_02HIKPPMOK@Ld?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 12 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 00 93 23 9B 40 21 01 93 ?? ?? ?? ?? 06 AB 02 93 9D F9 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_349_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_K@Z"
		size = 96
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z 002e sprintf_s 0048 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0050 __security_pop_cookie 005c ??_C@_02CLHGNPPK@Lu?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 12 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 00 93 23 9B 40 21 01 93 ?? ?? ?? ?? 06 AB 02 93 9D F9 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_350_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_N@Z"
		size = 460
		refs = "000a __security_push_cookie 004c _guard_check_icall 0060 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0064 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 009a ??2@YAPAXI@Z 00a0 _invalid_parameter_noinfo_noreturn 00cc ?truename@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00d6 ?falsename@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00e0 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@$$QAV12@@Z 00ec ??3@YAXPAX@Z 013a ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@D@Z 01c0 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 94 B0 6F 46 84 B0 D7 F8 88 90 1D 46 6F F0 01 03 C7 E9 20 25 C7 E9 02 33 0E 46 D9 F8 14 10 90 46 82 46 11 F4 80 4F 12 D1 97 F8 90 10 CD F8 00 90 02 91 97 F9 8C 10 01 91 01 68 4C 6A 20 46 ?? ?? ?? ?? 50 46 31 46 42 46 2B 46 A0 47 AF E0 39 46 48 46 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 1A 60 0F 23 BB 62 00 23 7B 62 3B 75 97 F8 90 30 40 46 23 B1 17 F1 30 01 ?? ?? ?? ?? 03 E0 17 F1 30 01 ?? ?? ?? ?? 01 46 17 F1 10 00 ?? ?? ?? ?? BB 6C 10 2B 02 D3 78 6B ?? ?? ?? ?? 0F 23 38 6B BB 64 00 23 7B 64 87 F8 34 30 ?? ?? ?? ?? D9 E9 08 23 7D 6A 00 2B 05 DB 00 DC 1A B1 AA 42 88 BF 54 1B 00 D8 00 24 D9 F8 14 30 D7 F8 84 20 03 F4 E0 73 40 2B D7 F8 80 30 0F D0 C7 E9 00 32 4C B1 97 F9 8C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 7D 6A D7 E9 00 32 C7 E9 20 32 00 24 B9 6A 78 69 10 29 28 BF 80 46 01 D2 17 F1 14 08 C7 E9 00 32 55 B1 18 F9 01 1B 38 46 ?? ?? ?? ?? 6D 1E F8 D1 B9 6A 78 69 D7 E9 00 32 00 25 C9 E9 08 55 C7 E9 20 32 C7 E9 00 32 54 B1 97 F9 8C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 B9 6A 78 69 D7 E9 00 32 C6 E9 00 32 10 29 01 D3 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 30 46 18 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_12_356_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MBADD@Z"
		size = 24
		refs = "000e _Tolower"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 46 00 F1 08 01 D8 B2 ?? ?? ?? ?? 40 B2 BD E8 00 88 }
	condition:
		$1
}

rule file_12_358_1 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MBADD@Z"
		size = 24
		refs = "000e _Toupper"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 46 00 F1 08 01 D8 B2 ?? ?? ?? ?? 40 B2 BD E8 00 88 }
	condition:
		$1
}

rule file_12_357_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MBAPBDPADPBD@Z"
		size = 50
		refs = "001e _Tolower"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0C 46 15 1B 00 26 94 42 88 BF 00 25 07 46 4D B1 20 78 07 F1 08 01 ?? ?? ?? ?? 76 1C AE 42 04 F8 01 0B F5 D1 20 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_12_359_1 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MBAPBDPADPBD@Z"
		size = 50
		refs = "001e _Toupper"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0C 46 15 1B 00 26 94 42 88 BF 00 25 07 46 4D B1 20 78 07 F1 08 01 ?? ?? ?? ?? 76 1C AE 42 04 F8 01 0B F5 D1 20 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_12_360_1 {
	meta:
		name = "?do_truename@?$numpunct@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z"
		altNames = "?do_positive_sign@?$_Mpunct@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 41 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1143_1 {
	meta:
		name = "?do_positive_sign@?$_Mpunct@G@std@@MBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBG@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 41 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1144_1 {
	meta:
		name = "?do_positive_sign@?$_Mpunct@_W@std@@MBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 41 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1221_1 {
	meta:
		name = "?do_truename@?$numpunct@G@std@@MBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBG@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 41 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1222_1 {
	meta:
		name = "?do_truename@?$numpunct@_W@std@@MBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 41 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_361_1 {
	meta:
		name = "?do_unshift@?$codecvt@DDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PAD1AAPAD@Z"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 02 9B 00 20 1A 60 BD E8 00 88 }
	condition:
		$1
}

rule file_12_363_1 {
	meta:
		name = "?do_widen@?$ctype@D@std@@MBAPBDPBD0PAD@Z"
		size = 24
		refs = "000e memcpy"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 14 46 62 1A 18 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_12_365_1 {
	meta:
		name = "?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z"
		size = 24
		altNames = "??$?8V__ExceptionPtr@@V0@@std@@YA_NABV?$shared_ptr@V__ExceptionPtr@@@0@0@Z ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBA_NABV01@@Z ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA_NABV01@@Z ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA_NABV01@@Z ?__ExceptionPtrCompare@@YA_NPBX0@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 68 0B 68 9A 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_12_367_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@I@Z"
		size = 40
		refs = "0022 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 8B 42 0A D3 83 69 10 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 5A 54 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_368_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@II@Z"
		size = 106
		refs = "0046 memmove 0064 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 60 69 88 42 28 D3 43 1A 93 42 09 D8 A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 61 61 5A 54 18 E0 BA B1 A3 69 10 2B 01 D3 63 68 00 E0 23 1D 85 1A 0B 44 68 1A 04 D0 99 18 02 46 18 46 ?? ?? ?? ?? A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 5A 55 20 46 BD E8 30 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_369_1 {
	meta:
		name = "?falsename@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 34
		refs = "0012 _guard_check_icall"
		altNames = "?curr_symbol@?$_Mpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?curr_symbol@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?curr_symbol@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ ?falsename@?$numpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?falsename@?$numpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 23 68 0E 46 9D 69 28 46 ?? ?? ?? ?? 20 46 31 46 A8 47 30 46 BD E8 78 88 }
	condition:
		$1
}

rule file_12_372_1 {
	meta:
		name = "?getloc@ios_base@std@@QBA?AVlocale@2@XZ"
		size = 46
		refs = "0020 _guard_check_icall"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 03 6B 0E 46 5D 68 75 60 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 30 46 BD E8 FC 88 }
	condition:
		$1
}

rule file_12_374_1 {
	meta:
		name = "?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 200
		refs = "0020 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0030 ??0_Lockit@std@@QAA@H@Z 0034 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0046 _guard_check_icall 0066 ?_Setgloballocale@locale@std@@CAXPAX@Z 008c setlocale 00b8 ??1_Lockit@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 FF 4B 0D F1 28 0B 6F 46 6F F0 01 03 38 63 C7 E9 02 33 0E 46 80 46 00 23 3B 60 01 20 ?? ?? ?? ?? C8 F8 04 00 01 23 38 1D 00 21 3B 60 ?? ?? ?? ?? ?? ?? ?? ?? 73 68 05 46 9D 42 3A D0 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 75 68 28 46 ?? ?? ?? ?? 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 2B 69 03 F0 3F 06 3F 2E 07 D1 A9 69 09 B9 05 F1 1C 01 00 20 ?? ?? ?? ?? 11 E0 00 24 4F F0 01 09 09 FA 04 F3 16 EA 63 0F 06 D0 A9 69 09 B9 05 F1 1C 01 20 46 ?? ?? ?? ?? 64 1C 05 2C F0 DD 38 1D ?? ?? ?? ?? 40 46 04 B0 BD E8 F0 0B 5D F8 0C FB }
	condition:
		$1
}

rule file_12_376_1 {
	meta:
		name = "__unwindfunclet$?global@locale@std@@SA?AV12@ABV12@@Z$0"
		size = 30
		refs = "0018 ??1locale@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 07 80 3B 68 23 F0 01 03 3B 60 38 6B ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_12_379_1 {
	meta:
		name = "?grouping@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 34
		refs = "0012 _guard_check_icall"
		altNames = "?grouping@?$_Mpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$_Mpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$_Mpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$numpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$numpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 23 68 0E 46 5D 69 28 46 ?? ?? ?? ?? 20 46 31 46 A8 47 30 46 BD E8 78 88 }
	condition:
		$1
}

rule file_12_380_1 {
	meta:
		name = "?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@IID@Z"
		size = 164
		refs = "0024 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0050 memmove 007a memset 0098 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 009e ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 04 46 15 46 62 69 0F 46 98 46 BA 42 3F D3 D3 43 AB 42 3F D9 56 19 BD B3 00 22 31 46 ?? ?? ?? ?? 90 B3 A3 69 10 2B 01 D3 61 68 00 E0 21 1D 10 2B 01 D3 62 68 00 E0 22 1D 63 69 B3 EB 07 0E 05 D0 D3 19 39 44 58 19 72 46 ?? ?? ?? ?? A3 69 01 2D 07 D1 10 2B 01 D3 63 68 00 E0 23 1D 03 F8 07 80 09 E0 10 2B 01 D3 63 68 00 E0 23 1D D8 19 2A 46 41 46 ?? ?? ?? ?? A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 9A 55 20 46 BD E8 F8 89 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_12_381_1 {
	meta:
		name = "?length@?$char_traits@D@std@@SAIPBD@Z"
		size = 28
		refs = "0014 strlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 90 F9 00 30 0B B9 00 20 03 E0 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_12_382_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBAIU_Nil@2@@Z"
		size = 20
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 6F F0 00 00 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_12_388_1 {
	meta:
		name = "?precision@ios_base@std@@QBA_JXZ"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 D3 E9 06 01 BD E8 00 88 }
	condition:
		$1
}

rule file_12_389_1 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
		size = 44
		refs = "0024 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 99 42 09 D8 83 69 10 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 5A 54 03 E0 C9 1A 00 22 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_12_390_1 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXID@Z"
		size = 42
		refs = "0022 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 99 42 09 D8 83 69 10 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 5A 54 02 E0 C9 1A ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_12_391_1 {
	meta:
		name = "?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAAHXZ"
		size = 66
		refs = "0036 _guard_check_icall"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 EB 69 1B 68 13 B1 EB 6A 1B 68 00 E0 00 23 00 2B 09 DD EA 6A 13 68 5B 1E 13 60 EA 69 11 68 4B 1C 13 60 08 78 06 E0 2B 68 DC 69 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 }
	condition:
		$1
}

rule file_12_392_1 {
	meta:
		name = "?sgetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAAHXZ"
		size = 50
		refs = "0026 _guard_check_icall"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 EB 69 1A 68 12 B1 EB 6A 1B 68 00 E0 00 23 00 2B 01 DD 10 78 06 E0 2B 68 9C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 }
	condition:
		$1
}

rule file_12_394_1 {
	meta:
		name = "?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAAHD@Z"
		size = 72
		refs = "003a _guard_check_icall"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2B 6A 0E 46 1B 68 13 B1 2B 6B 1B 68 00 E0 00 23 00 2B 0A DD 2A 6B F0 B2 13 68 5B 1E 13 60 2A 6A 11 68 4B 1C 13 60 0E 70 07 E0 2B 68 DC 68 20 46 ?? ?? ?? ?? 28 46 F1 B2 A0 47 BD E8 78 88 }
	condition:
		$1
}

rule file_12_395_1 {
	meta:
		name = "?thousands_sep@?$numpunct@D@std@@QBADXZ"
		size = 28
		refs = "0010 _guard_check_icall"
		altNames = "?thousands_sep@?$_Mpunct@D@std@@QBADXZ ?thousands_sep@?$_Mpunct@G@std@@QBAGXZ ?thousands_sep@?$_Mpunct@_W@std@@QBA_WXZ ?thousands_sep@?$numpunct@G@std@@QBAGXZ ?thousands_sep@?$numpunct@_W@std@@QBA_WXZ _Cnd_destroy_in_situ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 }
	condition:
		$1
}

rule file_12_398_1 {
	meta:
		name = "?truename@?$numpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 34
		refs = "0012 _guard_check_icall"
		altNames = "?positive_sign@?$_Mpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?positive_sign@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?positive_sign@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ ?truename@?$numpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?truename@?$numpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 23 68 0E 46 DD 69 28 46 ?? ?? ?? ?? 20 46 31 46 A8 47 30 46 BD E8 78 88 }
	condition:
		$1
}

rule file_12_400_1 {
	meta:
		name = "?widen@?$ctype@D@std@@QBAPBDPBD0PAD@Z"
		size = 40
		refs = "0016 _guard_check_icall"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 05 46 2C 68 98 46 17 46 E4 69 0E 46 20 46 ?? ?? ?? ?? 28 46 31 46 3A 46 43 46 A0 47 BD E8 F8 89 }
	condition:
		$1
}

rule file_12_401_1 {
	meta:
		name = "?width@ios_base@std@@QAA_J_J@Z"
		size = 22
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 D4 E9 08 01 C4 E9 08 23 BD E8 18 88 }
	condition:
		$1
}

rule file_12_402_1 {
	meta:
		name = "?width@ios_base@std@@QBA_JXZ"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 D3 E9 08 01 BD E8 00 88 }
	condition:
		$1
}

rule file_13_0_1 {
	meta:
		name = "_WStopfx"
		size = 282
		refs = "0018 iswctype"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 04 68 0F 46 80 46 00 25 00 E0 A4 1C 20 88 08 21 ?? ?? ?? ?? 00 28 F8 D1 23 88 2D 2B 08 BF 08 25 01 D0 2B 2B 00 D1 A4 1C 23 88 6E 2B 47 D0 4E 2B 45 D0 69 2B 1B D0 49 2B 19 D0 30 2B 14 D1 63 88 78 2B 01 D0 58 2B 0F D1 A3 88 22 1D 2E 2B 08 BF 92 1C 10 88 80 21 ?? ?? ?? ?? 08 B9 01 23 01 E0 24 1D 02 23 1D 43 4F E0 45 F0 01 05 4C E0 63 88 6E 2B 01 D0 4E 2B 2C D1 A3 88 66 2B 01 D0 46 2B 27 D1 A4 1D 23 88 45 F0 03 05 69 2B 01 D0 49 2B 38 D1 63 88 6E 2B 01 D0 4E 2B 33 D1 A3 88 69 2B 01 D0 49 2B 2E D1 E3 88 74 2B 01 D0 54 2B 29 D1 23 89 79 2B 01 D0 59 2B 24 D1 0A 34 22 E0 63 88 61 2B 01 D0 41 2B 04 D1 A3 88 6E 2B 05 D0 4E 2B 03 D0 D8 F8 00 40 00 25 14 E0 A4 1D 23 88 04 25 26 46 28 2B 0E D1 36 F8 02 0F 40 F2 07 11 ?? ?? ?? ?? 00 28 F7 D1 33 88 5F 2B F4 D0 9B B2 29 2B 08 BF B4 1C 07 B1 3C 60 C8 F8 00 40 28 46 BD E8 F8 89 }
	condition:
		$1
}

rule file_14_0_1 {
	meta:
		name = "_Stopfx"
		size = 304
		refs = "0016 isspace 0062 isxdigit 010a isalnum"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 04 68 0F 46 80 46 00 25 00 E0 64 1C 20 78 ?? ?? ?? ?? 00 28 F9 D1 94 F9 00 30 2D 2B 08 BF 08 25 01 D0 2B 2B 00 D1 64 1C 94 F9 00 30 6E 2B 4F D0 4E 2B 4D D0 69 2B 1C D0 49 2B 1A D0 30 2B 15 D1 94 F9 01 30 78 2B 01 D0 58 2B 0F D1 94 F9 02 30 A2 1C 2E 2B 08 BF 52 1C 10 78 ?? ?? ?? ?? 08 B9 01 23 01 E0 A4 1C 02 23 1D 43 58 E0 45 F0 01 05 55 E0 94 F9 01 30 6E 2B 01 D0 4E 2B 34 D1 94 F9 02 30 66 2B 01 D0 46 2B 2E D1 E4 1C 94 F9 00 30 45 F0 03 05 69 2B 01 D0 49 2B 3E D1 94 F9 01 30 6E 2B 01 D0 4E 2B 38 D1 94 F9 02 30 69 2B 01 D0 49 2B 32 D1 94 F9 03 30 74 2B 01 D0 54 2B 2C D1 94 F9 04 30 79 2B 01 D0 59 2B 26 D1 64 1D 24 E0 94 F9 01 30 61 2B 01 D0 41 2B 05 D1 94 F9 02 30 6E 2B 05 D0 4E 2B 03 D0 D8 F8 00 40 00 25 14 E0 E4 1C 94 F9 00 30 04 25 26 46 28 2B 0D D1 16 F8 01 0F ?? ?? ?? ?? 00 28 F9 D1 96 F9 00 30 5F 2B F5 D0 5B B2 29 2B 08 BF 74 1C 07 B1 3C 60 C8 F8 00 40 28 46 BD E8 F8 89 }
	condition:
		$1
}

rule file_15_3_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 24
		altNames = "??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 00 23 03 60 C0 E9 05 33 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_15_6_1 {
	meta:
		name = "??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ"
		size = 64
		refs = "0024 atexit 0030 ??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@YAXXZ 0034 ??_7_Iostream_error_category@std@@6B@ 0038 ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 003c ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@51"
		altNames = "?iostream_category@std@@YAABVerror_category@1@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 4A 0B 4C 13 68 13 F0 01 0F 09 D1 43 F0 01 03 13 60 06 4B 04 48 23 60 05 23 63 60 ?? ?? ?? ?? 20 46 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_30_1 {
	meta:
		name = "??0?$_Immortalizer@V_Iostream_error_category@std@@@std@@QAA@XZ"
		size = 24
		refs = "0014 ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 18 B1 02 4B 03 60 05 23 43 60 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_37_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@$$QAV01@@Z"
		size = 120
		refs = "0020 ??2@YAPAXI@Z 0026 _invalid_parameter_noinfo_noreturn 0052 memmove"
	strings:
		$1 = { 2D E9 FE 49 0D F1 20 0B 6F 46 6F F0 01 03 05 46 00 26 C7 E9 00 33 08 20 2E 60 C5 E9 05 66 0C 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 28 60 C0 E9 00 32 2B 68 4F F0 0F 08 1D 60 C5 E9 05 68 2E 71 A3 69 10 2B 07 D2 63 69 5A 1C 0A D0 21 1D 28 1D ?? ?? ?? ?? 05 E0 15 F1 04 0F 01 D0 63 68 6B 60 66 60 63 69 6B 61 A3 69 AB 61 C4 E9 05 68 26 71 28 46 BD E8 FE 89 }
	condition:
		$1
}

rule file_15_38_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ABV01@@Z"
		size = 102
		refs = "0024 ??2@YAPAXI@Z 002a _invalid_parameter_noinfo_noreturn 0058 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 03 B4 2D E9 FC 48 0D F1 18 0B 6F 46 04 46 6F F0 01 03 3C 62 00 26 C7 E9 00 33 08 20 26 60 C4 E9 05 66 0D 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 0F 23 A3 61 10 2B 01 D3 63 68 00 E0 23 1D 66 61 1E 70 6F F0 00 03 00 22 29 46 20 46 ?? ?? ?? ?? 20 46 BD E8 FC 08 5D F8 0C FB }
	condition:
		$1
}

rule file_15_45_1 {
	meta:
		name = "??0_Generic_error_category@std@@QAA@XZ"
		size = 24
		refs = "0014 ??_7_Generic_error_category@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 03 60 03 23 43 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_46_1 {
	meta:
		name = "??0_Iostream_error_category@std@@QAA@XZ"
		size = 24
		refs = "0014 ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 03 60 05 23 43 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_47_1 {
	meta:
		name = "??0_Sentry_base@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@AAV12@@Z"
		size = 42
		refs = "001c _guard_check_icall"
		altNames = "??0_Sentry_base@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@AAV12@@Z ??0_Sentry_base@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@AAV12@@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 06 46 31 60 0B 68 5B 68 0B 44 9D 6B 35 B1 2B 68 5C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 30 46 BD E8 78 88 }
	condition:
		$1
}

rule file_15_48_1 {
	meta:
		name = "??0_System_error@std@@IAA@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 152
		refs = "000a __security_push_cookie 0016 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ABV01@@Z 0022 ?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z 0048 __std_exception_copy 0058 ??3@YAXPAX@Z 007e __security_pop_cookie 008c ??_7_System_error@std@@6B@ 0090 ??_7runtime_error@std@@6B@ 0094 ??_7exception@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 92 B0 04 46 02 A8 19 46 ?? ?? ?? ?? DD E9 17 12 03 46 0A A8 ?? ?? ?? ?? 83 69 10 2B 01 D3 42 68 00 E0 02 1D 18 4B 68 46 21 1D 23 60 00 23 C4 E9 01 33 01 23 8D F8 04 30 00 92 ?? ?? ?? ?? 10 4B 23 60 10 9B 10 2B 02 D3 0B 98 ?? ?? ?? ?? 0F 23 0A 98 10 93 00 23 0F 93 8D F8 2C 30 ?? ?? ?? ?? 07 4B 20 46 23 60 17 9B E3 60 18 9B 23 61 12 B0 ?? ?? ?? ?? BD E8 10 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_49_1 {
	meta:
		name = "??0_System_error@std@@QAA@ABV01@@Z"
		size = 56
		refs = "001a __std_exception_copy 0030 ??_7_System_error@std@@6B@ 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4B 05 46 0C 46 2B 60 00 23 20 1D C5 E9 01 33 29 1D ?? ?? ?? ?? 04 4B 28 46 2B 60 E3 68 EB 60 23 69 2B 61 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_3_1 {
	meta:
		name = "??0future_error@std@@QAA@ABV01@@Z"
		size = 56
		refs = "001a __std_exception_copy 0030 ??_7future_error@std@@6B@ 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4B 05 46 0C 46 2B 60 00 23 20 1D C5 E9 01 33 29 1D ?? ?? ?? ?? 04 4B 28 46 2B 60 E3 68 EB 60 23 69 2B 61 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_50_1 {
	meta:
		name = "??0_Winit@std@@QAA@XZ"
		size = 32
		refs = "001c ?_Init_cnt@_Winit@std@@0HA"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 13 68 00 2B A8 BF 5B 1C B8 BF 01 23 13 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_50_1 {
	meta:
		name = "??0_UShinit@std@@QAA@XZ"
		size = 32
		refs = "001c ?_Init_cnt@_UShinit@std@@0HA"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 13 68 00 2B A8 BF 5B 1C B8 BF 01 23 13 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_117_1 {
	meta:
		name = "?_Init_ctor@Init@ios_base@std@@CAXPAV123@@Z"
		size = 32
		refs = "001c ?_Init_cnt@Init@ios_base@std@@0HA"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 13 68 00 2B A8 BF 5B 1C B8 BF 01 23 13 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_51_1 {
	meta:
		name = "??0error_category@std@@QAA@XZ"
		size = 20
		refs = "0010 ??_7error_category@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B C0 E9 00 30 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_56_1 {
	meta:
		name = "??0failure@ios_base@std@@QAA@ABV012@@Z"
		size = 64
		refs = "001a __std_exception_copy 0034 ??_7failure@ios_base@std@@6B@ 0038 ??_7_System_error@std@@6B@ 003c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4B 05 46 0C 46 2B 60 00 23 20 1D C5 E9 01 33 29 1D ?? ?? ?? ?? 06 4B 28 46 2B 60 E3 68 EB 60 23 69 2B 61 01 4B 2B 60 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_86_2 {
	meta:
		name = "??0system_error@std@@QAA@ABV01@@Z"
		size = 64
		refs = "001a __std_exception_copy 0034 ??_7system_error@std@@6B@ 0038 ??_7_System_error@std@@6B@ 003c ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4B 05 46 0C 46 2B 60 00 23 20 1D C5 E9 01 33 29 1D ?? ?? ?? ?? 06 4B 28 46 2B 60 E3 68 EB 60 23 69 2B 61 01 4B 2B 60 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_57_1 {
	meta:
		name = "??0failure@ios_base@std@@QAA@PBDABVerror_code@2@@Z"
		size = 36
		refs = "0010 ??0system_error@std@@QAA@Verror_code@1@PBD@Z 0020 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0B 46 D2 E9 00 12 04 46 ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_59_1 {
	meta:
		name = "??0runtime_error@std@@QAA@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 68
		refs = "002c __std_exception_copy 003c ??_7runtime_error@std@@6B@ 0040 ??_7exception@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 8B 69 04 46 10 2B 01 D3 4A 68 00 E0 0A 1D 0A 4B 68 46 00 92 23 60 00 23 C4 E9 01 33 01 23 21 1D 8D F8 04 30 ?? ?? ?? ?? 02 4B 20 46 23 60 BD E8 1E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_60_1 {
	meta:
		name = "??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@AAV12@@Z"
		size = 110
		refs = "0034 _guard_check_icall 004e ?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAAAV12@XZ"
	strings:
		$1 = { 03 B4 2D E9 FE 49 0D F1 20 0B 6F 46 06 46 6F F0 01 03 BE 62 0D 46 C7 E9 00 33 35 60 2B 68 5B 68 2B 44 D3 F8 38 80 B8 F1 00 0F 07 D0 D8 F8 00 30 5C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 2B 68 5B 68 5A 19 D3 68 2B B9 D0 6B 18 B1 A8 42 01 D0 ?? ?? ?? ?? 2B 68 5B 68 2B 44 DB 68 0B B9 01 23 00 E0 00 23 33 71 30 46 BD E8 FE 09 5D F8 0C FB }
	condition:
		$1
}

rule file_92_59_1 {
	meta:
		name = "??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@AAV12@@Z"
		size = 110
		refs = "0034 _guard_check_icall 004e ?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAAAV12@XZ"
	strings:
		$1 = { 03 B4 2D E9 FE 49 0D F1 20 0B 6F 46 06 46 6F F0 01 03 BE 62 0D 46 C7 E9 00 33 35 60 2B 68 5B 68 2B 44 D3 F8 38 80 B8 F1 00 0F 07 D0 D8 F8 00 30 5C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 2B 68 5B 68 5A 19 D3 68 2B B9 D0 6B 18 B1 A8 42 01 D0 ?? ?? ?? ?? 2B 68 5B 68 2B 44 DB 68 0B B9 01 23 00 E0 00 23 33 71 30 46 BD E8 FE 09 5D F8 0C FB }
	condition:
		$1
}

rule file_86_60_1 {
	meta:
		name = "??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@AAV12@@Z"
		size = 110
		refs = "0034 _guard_check_icall 004e ?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAAAV12@XZ"
	strings:
		$1 = { 03 B4 2D E9 FE 49 0D F1 20 0B 6F 46 06 46 6F F0 01 03 BE 62 0D 46 C7 E9 00 33 35 60 2B 68 5B 68 2B 44 D3 F8 38 80 B8 F1 00 0F 07 D0 D8 F8 00 30 5C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 2B 68 5B 68 5A 19 D3 68 2B B9 D0 6B 18 B1 A8 42 01 D0 ?? ?? ?? ?? 2B 68 5B 68 2B 44 DB 68 0B B9 01 23 00 E0 00 23 33 71 30 46 BD E8 FE 09 5D F8 0C FB }
	condition:
		$1
}

rule file_15_63_1 {
	meta:
		name = "??0system_error@std@@QAA@Verror_code@1@PBD@Z"
		size = 104
		refs = "000a __security_push_cookie 0022 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z 0030 ??0_System_error@std@@IAA@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 003c ??3@YAXPAX@Z 0058 __security_pop_cookie 0064 ??_7system_error@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B ?? ?? ?? ?? 89 B0 6F 46 04 46 6F F0 01 02 17 F1 08 00 19 46 C7 E9 00 22 ?? ?? ?? ?? D7 E9 0F 12 17 F1 08 03 20 46 ?? ?? ?? ?? 3B 6A 10 2B 02 D3 F8 68 ?? ?? ?? ?? 0F 23 B8 68 3B 62 00 23 FB 61 3B 73 ?? ?? ?? ?? 04 4B 23 60 20 46 09 B0 ?? ?? ?? ?? BD E8 90 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_74_1 {
	meta:
		name = "??1_Sentry_base@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@XZ"
		size = 56
		refs = "002c _guard_check_icall"
		altNames = "??1_Sentry_base@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@XZ ??1_Sentry_base@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 02 68 13 68 5B 68 13 44 9B 6B 53 B1 13 68 5B 68 13 44 9D 6B 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 BE 88 }
	condition:
		$1
}

rule file_15_76_1 {
	meta:
		name = "??1_Winit@std@@QAA@XZ"
		size = 80
		refs = "0022 ?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAAAV12@XZ 0040 ?_Ptr_wclog@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0044 ?_Ptr_wcerr@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0048 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 004c ?_Init_cnt@_Winit@std@@0HA"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0E 4A 13 68 5B 1E 13 60 0E D1 0A 4B 18 68 08 B1 ?? ?? ?? ?? 07 4B 18 68 08 B1 ?? ?? ?? ?? 03 4B 18 68 08 B1 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_81_1 {
	meta:
		name = "??1sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@XZ"
		size = 62
		refs = "0014 ?uncaught_exception@std@@YA_NXZ 001c ?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0032 _guard_check_icall"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 04 46 ?? ?? ?? ?? 10 B9 20 68 ?? ?? ?? ?? 22 68 13 68 5B 68 13 44 9D 6B 35 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 BE 88 }
	condition:
		$1
}

rule file_92_79_1 {
	meta:
		name = "??1sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@XZ"
		size = 62
		refs = "0014 ?uncaught_exception@std@@YA_NXZ 001c ?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ 0032 _guard_check_icall"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 04 46 ?? ?? ?? ?? 10 B9 20 68 ?? ?? ?? ?? 22 68 13 68 5B 68 13 44 9D 6B 35 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 BE 88 }
	condition:
		$1
}

rule file_86_81_1 {
	meta:
		name = "??1sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@XZ"
		size = 62
		refs = "0014 ?uncaught_exception@std@@YA_NXZ 001c ?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ 0032 _guard_check_icall"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 04 46 ?? ?? ?? ?? 10 B9 20 68 ?? ?? ?? ?? 22 68 13 68 5B 68 13 44 9D 6B 35 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 BE 88 }
	condition:
		$1
}

rule file_15_85_1 {
	meta:
		name = "??8error_category@std@@QBA_NABV01@@Z"
		size = 24
	strings:
		$1 = { 2D E9 00 48 EB 46 42 68 4B 68 9A 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_15_86_1 {
	meta:
		name = "??8std@@YA_NABVerror_condition@0@0@Z"
		size = 38
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 43 68 4A 68 5C 68 53 68 9C 42 05 D1 02 68 0B 68 9A 42 08 BF 01 20 00 D0 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_15_90_1 {
	meta:
		name = "??_G_System_error@std@@UAAPAXI@Z"
		size = 48
		refs = "0012 __std_exception_destroy 0020 ??3@YAXPAXI@Z 002c ??_7exception@std@@6B@"
		altNames = "??_Gfailure@ios_base@std@@UAAPAXI@Z ??_Gfuture_error@std@@UAAPAXI@Z ??_Gsystem_error@std@@UAAPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 08 4B 05 46 28 1D 2B 60 0C 46 ?? ?? ?? ?? 14 F0 01 0F 03 D0 14 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_119_1 {
	meta:
		name = "?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z"
		size = 160
		refs = "000a __security_push_cookie 002c ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z 0038 ?message@error_code@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0046 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 0052 ??3@YAXPAX@Z 006a ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@$$QAV01@@Z 008e __security_pop_cookie 009c ??_C@_02LMMGGCAJ@?3?5?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? 8B B0 6F 46 1C 46 6F F0 01 03 C7 E9 02 33 3C 60 05 46 00 26 62 69 22 B1 1D 49 02 22 20 46 ?? ?? ?? ?? 17 F1 10 01 17 F1 4C 00 ?? ?? ?? ?? 01 46 6F F0 00 03 00 22 20 46 ?? ?? ?? ?? BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 21 46 28 46 ?? ?? ?? ?? A3 69 10 2B 02 D3 60 68 ?? ?? ?? ?? 0F 23 C4 E9 05 63 26 71 20 68 ?? ?? ?? ?? 26 60 28 46 0B B0 ?? ?? ?? ?? BD E8 F0 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_132_1 {
	meta:
		name = "?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ"
		size = 90
		refs = "002e _guard_check_icall 0052 ?clear@ios_base@std@@QAAXH_N@Z"
		altNames = "?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ ?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 06 46 33 68 5B 68 9A 19 D3 68 DB B9 53 69 13 F0 02 0F 17 D0 95 6B 2B 68 5C 6B 20 46 ?? ?? ?? ?? 28 46 A0 47 B0 F1 FF 3F 0C D1 33 68 5B 68 98 19 C3 68 43 F0 04 01 83 6B 0B B9 41 F0 04 01 00 22 ?? ?? ?? ?? BD E8 FC 88 }
	condition:
		$1
}

rule file_15_145_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
		size = 158
		refs = "0044 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 005e ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 007a memcpy 0098 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0F 46 15 46 04 46 EF B1 A0 69 10 28 01 D3 63 68 00 E0 23 1D 9F 42 15 D3 10 28 01 D3 62 68 00 E0 22 1D 63 69 13 44 BB 42 0C D9 10 28 01 D3 63 68 00 E0 23 1D FA 1A 2B 46 21 46 20 46 ?? ?? ?? ?? 04 46 21 E0 62 69 D3 43 AB 42 20 D9 56 19 DD B1 00 22 31 46 20 46 ?? ?? ?? ?? A8 B1 A3 69 10 2B 01 D3 62 68 00 E0 22 1D 2D B1 63 69 39 46 D0 18 2A 46 ?? ?? ?? ?? A3 69 10 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 9A 55 20 46 BD E8 F0 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_15_153_1 {
	meta:
		name = "?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAXH_N@Z"
		size = 22
		refs = "0012 ?clear@ios_base@std@@QAAXH_N@Z"
		altNames = "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAXH_N@Z ?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAXH_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 83 6B 0B B9 41 F0 04 01 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_154_1 {
	meta:
		name = "?clear@ios_base@std@@QAAXH_N@Z"
		size = 148
		refs = "002e _CxxThrowException 0036 ?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z 0040 ??0failure@ios_base@std@@QAA@PBDABVerror_code@2@@Z 0084 _TI5?AVfailure@ios_base@std@@ 0088 ??_C@_0BF@OOHOMBOF@ios_base?3?3eofbit?5set?$AA@ 008c ??_C@_0BG@FMKFHCIL@ios_base?3?3failbit?5set?$AA@ 0090 ??_C@_0BF@PHHKMMFD@ios_base?3?3badbit?5set?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 88 B0 03 69 01 F0 17 01 C1 60 0B 40 07 D0 4A B9 13 F0 04 0F 0A D1 13 F0 02 0F 14 D1 20 E0 08 B0 BD E8 00 88 00 21 00 20 ?? ?? ?? ?? 68 46 01 21 ?? ?? ?? ?? 15 49 02 46 02 A8 ?? ?? ?? ?? 0F 49 02 A8 ?? ?? ?? ?? 68 46 01 21 ?? ?? ?? ?? 0D 49 02 46 02 A8 ?? ?? ?? ?? 09 49 02 A8 ?? ?? ?? ?? 68 46 01 21 ?? ?? ?? ?? 06 49 02 46 02 A8 ?? ?? ?? ?? 02 49 02 A8 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_160_1 {
	meta:
		name = "?default_error_condition@error_category@std@@UBA?AVerror_condition@2@H@Z"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 C1 E9 00 20 08 46 BD E8 00 88 }
	condition:
		$1
}

rule file_15_161_1 {
	meta:
		name = "?empty@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBA_NXZ"
		size = 20
		altNames = "?empty@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBA_NXZ ?empty@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBA_NXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 0B B9 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_15_162_1 {
	meta:
		name = "?equivalent@error_category@std@@UBA_NABVerror_code@2@H@Z"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 4B 68 40 68 5B 68 98 42 04 D1 0B 68 93 42 08 BF 01 20 00 D0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_15_163_1 {
	meta:
		name = "?equivalent@error_category@std@@UBA_NHABVerror_condition@2@@Z"
		size = 62
		refs = "0014 _guard_check_icall"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 04 46 23 68 17 46 0E 46 DD 68 28 46 ?? ?? ?? ?? 20 46 69 46 32 46 A8 47 43 68 79 68 5C 68 4B 68 9C 42 05 D1 01 68 3B 68 99 42 08 BF 01 20 00 D0 00 20 BD E8 FC 88 }
	condition:
		$1
}

rule file_15_167_1 {
	meta:
		name = "?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAAAV12@XZ"
		size = 142
		refs = "0022 ??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@AAV12@@Z 0038 _guard_check_icall 005c ?clear@ios_base@std@@QAAXH_N@Z 0060 ?uncaught_exception@std@@YA_NXZ 0068 ?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 FF 48 0D F1 20 0B 6F 46 6F F0 01 03 06 46 C7 E9 02 33 33 68 5B 68 33 44 9B 6B 9B B3 38 46 31 46 ?? ?? ?? ?? 3B 79 D3 B1 33 68 5B 68 33 44 9D 6B 2B 68 5C 6B 20 46 ?? ?? ?? ?? 28 46 A0 47 B0 F1 FF 3F 0C D1 33 68 5B 68 98 19 C3 68 43 F0 04 01 83 6B 0B B9 41 F0 04 01 00 22 ?? ?? ?? ?? ?? ?? ?? ?? 10 B9 38 68 ?? ?? ?? ?? 3A 68 13 68 5B 68 13 44 9D 6B 35 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 30 46 04 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_92_168_1 {
	meta:
		name = "?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAAAV12@XZ"
		size = 142
		refs = "0022 ??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@AAV12@@Z 0038 _guard_check_icall 005c ?clear@ios_base@std@@QAAXH_N@Z 0060 ?uncaught_exception@std@@YA_NXZ 0068 ?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 FF 48 0D F1 20 0B 6F 46 6F F0 01 03 06 46 C7 E9 02 33 33 68 5B 68 33 44 9B 6B 9B B3 38 46 31 46 ?? ?? ?? ?? 3B 79 D3 B1 33 68 5B 68 33 44 9D 6B 2B 68 5C 6B 20 46 ?? ?? ?? ?? 28 46 A0 47 B0 F1 FF 3F 0C D1 33 68 5B 68 98 19 C3 68 43 F0 04 01 83 6B 0B B9 41 F0 04 01 00 22 ?? ?? ?? ?? ?? ?? ?? ?? 10 B9 38 68 ?? ?? ?? ?? 3A 68 13 68 5B 68 13 44 9D 6B 35 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 30 46 04 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_86_167_1 {
	meta:
		name = "?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAAAV12@XZ"
		size = 142
		refs = "0022 ??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@AAV12@@Z 0038 _guard_check_icall 005c ?clear@ios_base@std@@QAAXH_N@Z 0060 ?uncaught_exception@std@@YA_NXZ 0068 ?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ"
	strings:
		$1 = { 2D E9 FF 48 0D F1 20 0B 6F 46 6F F0 01 03 06 46 C7 E9 02 33 33 68 5B 68 33 44 9B 6B 9B B3 38 46 31 46 ?? ?? ?? ?? 3B 79 D3 B1 33 68 5B 68 33 44 9D 6B 2B 68 5C 6B 20 46 ?? ?? ?? ?? 28 46 A0 47 B0 F1 FF 3F 0C D1 33 68 5B 68 98 19 C3 68 43 F0 04 01 83 6B 0B B9 41 F0 04 01 00 22 ?? ?? ?? ?? ?? ?? ?? ?? 10 B9 38 68 ?? ?? ?? ?? 3A 68 13 68 5B 68 13 44 9D 6B 35 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 30 46 04 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_15_171_1 {
	meta:
		name = "?good@ios_base@std@@QBA_NXZ"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 C3 68 0B B9 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_15_174_1 {
	meta:
		name = "?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z"
		size = 72
		refs = "0028 atexit 0038 ??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@YAXXZ 003c ??_7_Iostream_error_category@std@@6B@ 0040 ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 0044 ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@51"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0E 4A 0D 4D 0E 46 13 68 04 46 13 F0 01 0F 09 D1 43 F0 01 03 13 60 07 4B 05 48 2B 60 05 23 6B 60 ?? ?? ?? ?? C4 E9 00 65 20 46 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_179_1 {
	meta:
		name = "?message@_Generic_error_category@std@@UBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 30
		refs = "000c ?_Syserror_map@std@@YAPBDH@Z 0014 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 10 46 0C 46 ?? ?? ?? ?? 01 46 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_15_180_1 {
	meta:
		name = "?message@_Iostream_error_category@std@@UBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 40
		refs = "0012 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z 001a ?message@_Generic_error_category@std@@UBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z 0024 ??_C@_0BG@PADBLCHM@iostream?5stream?5error?$AA@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 01 2A 04 D1 05 49 20 46 ?? ?? ?? ?? 02 E0 21 46 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_181_1 {
	meta:
		name = "?message@error_code@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 38
		refs = "0014 _guard_check_icall"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B D0 E9 00 64 0F 46 23 68 9D 68 28 46 ?? ?? ?? ?? 20 46 39 46 32 46 A8 47 38 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_15_186_1 {
	meta:
		name = "?pubsync@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QAAHXZ"
		size = 28
		refs = "0010 _guard_check_icall"
		altNames = "?pubsync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAAHXZ ?pubsync@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QAAHXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 68 5C 6B 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 }
	condition:
		$1
}

rule file_15_189_1 {
	meta:
		name = "?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBA?AU12@U_Nil@2@@Z"
		size = 18
		altNames = "?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBA?AU12@U_Nil@2@@Z ?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBA?AU12@U_Nil@2@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 08 46 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_15_191_1 {
	meta:
		name = "?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAXH_N@Z"
		size = 28
		refs = "0014 ?clear@ios_base@std@@QAAXH_N@Z"
		altNames = "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAXH_N@Z ?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAXH_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 39 B1 C3 68 19 43 83 6B 0B B9 41 F0 04 01 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_17_30_1 {
	meta:
		name = "??$_Copy_no_deprecate1@PA_WV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@PA_W0V10@Uinput_iterator_tag@0@U_Any_tag@0@@Z"
		size = 74
		refs = "002e ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z"
		altNames = "??$_Copy_no_deprecate@PA_WV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@PA_W0V10@@Z ??$_Copy_unchecked@PA_WV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@PA_W0V10@@Z ??$copy@PA_WV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@PA_W0V10@@Z"
	strings:
		$1 = { 0F B4 2D E9 FC 48 0D F1 18 0B 0F 46 D4 1B 61 1C 00 26 97 42 05 46 0C 98 98 BF 4C 08 88 BF 00 24 0B 93 CD E9 00 30 4C B1 37 F8 02 1B 68 46 ?? ?? ?? ?? 76 1C A6 42 F7 D1 DD E9 00 30 C5 E9 00 30 28 46 BD E8 FC 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_31_1 {
	meta:
		name = "??$_Copy_no_deprecate1@PA_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@PA_W0V10@Uinput_iterator_tag@0@U_Any_tag@0@@Z"
		size = 74
		refs = "002e ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 0F B4 2D E9 FC 48 0D F1 18 0B 0F 46 D4 1B 61 1C 00 26 97 42 05 46 0C 98 98 BF 4C 08 88 BF 00 24 0B 93 CD E9 00 30 4C B1 37 F8 02 1B 68 46 ?? ?? ?? ?? 76 1C A6 42 F7 D1 DD E9 00 30 C5 E9 00 30 28 46 BD E8 FC 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_33_1 {
	meta:
		name = "??$_Copy_no_deprecate@PA_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@PA_W0V10@@Z"
		size = 74
		refs = "002e ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 0F B4 2D E9 FC 48 0D F1 18 0B 0F 46 D4 1B 61 1C 00 26 97 42 05 46 0C 98 98 BF 4C 08 88 BF 00 24 0B 93 CD E9 00 30 4C B1 37 F8 02 1B 68 46 ?? ?? ?? ?? 76 1C A6 42 F7 D1 DD E9 00 30 C5 E9 00 30 28 46 BD E8 FC 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_37_1 {
	meta:
		name = "??$_Copy_unchecked@PA_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@PA_W0V10@@Z"
		size = 74
		refs = "002e ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 0F B4 2D E9 FC 48 0D F1 18 0B 0F 46 D4 1B 61 1C 00 26 97 42 05 46 0C 98 98 BF 4C 08 88 BF 00 24 0B 93 CD E9 00 30 4C B1 37 F8 02 1B 68 46 ?? ?? ?? ?? 76 1C A6 42 F7 D1 DD E9 00 30 C5 E9 00 30 28 46 BD E8 FC 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_108_1 {
	meta:
		name = "??$copy@PA_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@PA_W0V10@@Z"
		size = 74
		refs = "002e ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 0F B4 2D E9 FC 48 0D F1 18 0B 0F 46 D4 1B 61 1C 00 26 97 42 05 46 0C 98 98 BF 4C 08 88 BF 00 24 0B 93 CD E9 00 30 4C B1 37 F8 02 1B 68 46 ?? ?? ?? ?? 76 1C A6 42 F7 D1 DD E9 00 30 C5 E9 00 30 28 46 BD E8 FC 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_34_1 {
	meta:
		name = "??$_Copy_unchecked1@PA_WV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@PA_W0V10@U_General_ptr_iterator_tag@0@@Z"
		size = 68
		refs = "0028 ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 0F 46 D4 1B 61 1C 00 26 97 42 98 BF 4C 08 88 BF 00 24 09 93 05 46 44 B1 37 F8 02 1B 09 A8 ?? ?? ?? ?? 76 1C A6 42 F7 D1 09 9B 2B 60 0A 9B 28 46 6B 60 BD E8 F0 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_35_1 {
	meta:
		name = "??$_Copy_unchecked1@PA_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@PA_W0V10@U_General_ptr_iterator_tag@0@@Z"
		size = 68
		refs = "0028 ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 0F 46 D4 1B 61 1C 00 26 97 42 98 BF 4C 08 88 BF 00 24 09 93 05 46 44 B1 37 F8 02 1B 09 A8 ?? ?? ?? ?? 76 1C A6 42 F7 D1 09 9B 2B 60 0A 9B 28 46 6B 60 BD E8 F0 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_38_1 {
	meta:
		name = "??$_Find_elem@G@std@@YAIPAGG@Z"
		size = 32
		altNames = "??$_Find_elem@_W@std@@YAIPA_W_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 88 03 46 03 E0 8A 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1A 58 10 BD E8 00 88 }
	condition:
		$1
}

rule file_17_40_1 {
	meta:
		name = "??$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBD@Z"
		size = 450
		refs = "0008 __security_push_cookie 0044 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00ca ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 018c ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ 0196 _invalid_parameter_noinfo_noreturn 01a2 ??3@YAXPAX@Z 01ba __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 92 46 6F F0 01 02 C7 E9 04 22 93 F9 00 50 3B 60 89 46 F9 60 80 46 4D B1 2C 46 1E 46 AC 42 01 D1 0A F1 01 0A 16 F9 01 4F 00 2C F7 D1 17 F1 18 00 00 22 51 46 ?? ?? ?? ?? 6F F0 01 03 01 25 BB 60 00 23 39 6B F8 69 00 26 00 24 7B 60 BA F1 00 0F 00 F0 9D 80 D7 F8 2C E0 3A 68 B3 56 6B B1 92 F9 00 20 D7 F8 00 90 93 42 04 D0 76 1C 16 F9 09 30 00 2B F8 D1 D7 F8 0C 90 3A 68 74 45 00 F2 85 80 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 43 B1 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 1E 44 4C E0 3B 68 2E 44 B2 56 93 F9 00 30 9A 42 38 D0 BA B3 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 99 F8 04 30 2B B9 48 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 D8 F8 00 30 00 2B D9 F8 00 30 01 D1 9B B1 00 E0 8B B9 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 3B 68 F2 56 B8 F8 06 30 9A 42 02 D1 01 23 7B 60 18 E0 7F 2D 2B 46 28 BF 7F 23 74 45 36 D8 10 29 0B D2 17 F1 1C 00 08 E0 7F 2D 2B 46 28 BF 7F 23 10 29 01 D2 17 F1 1C 00 BC 60 03 55 F8 69 D7 E9 0B E1 7B 68 64 1C 54 45 89 D3 1B B3 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 39 6B F8 69 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? 39 6B F8 69 D8 F8 00 30 00 2B D9 F8 00 30 01 D1 63 B1 00 E0 53 B9 40 46 6D 1C ?? ?? ?? ?? 6F F0 00 03 5B E7 ?? ?? ?? ?? ?? ?? ?? ?? 10 29 01 D3 ?? ?? ?? ?? 0F 23 B8 69 3B 63 00 23 FB 62 3B 77 ?? ?? ?? ?? B8 68 0E B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_42_1 {
	meta:
		name = "??$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPBD@Z"
		size = 450
		refs = "0008 __security_push_cookie 0044 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00ca ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 018c ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ 0196 _invalid_parameter_noinfo_noreturn 01a2 ??3@YAXPAX@Z 01ba __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 92 46 6F F0 01 02 C7 E9 04 22 93 F9 00 50 3B 60 89 46 F9 60 80 46 4D B1 2C 46 1E 46 AC 42 01 D1 0A F1 01 0A 16 F9 01 4F 00 2C F7 D1 17 F1 18 00 00 22 51 46 ?? ?? ?? ?? 6F F0 01 03 01 25 BB 60 00 23 39 6B F8 69 00 26 00 24 7B 60 BA F1 00 0F 00 F0 9D 80 D7 F8 2C E0 3A 68 B3 56 6B B1 92 F9 00 20 D7 F8 00 90 93 42 04 D0 76 1C 16 F9 09 30 00 2B F8 D1 D7 F8 0C 90 3A 68 74 45 00 F2 85 80 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 43 B1 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 1E 44 4C E0 3B 68 2E 44 B2 56 93 F9 00 30 9A 42 38 D0 BA B3 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 99 F8 04 30 2B B9 48 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 D8 F8 00 30 00 2B D9 F8 00 30 01 D1 9B B1 00 E0 8B B9 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B E1 F8 69 3B 68 F2 56 B8 F8 06 30 9A 42 02 D1 01 23 7B 60 18 E0 7F 2D 2B 46 28 BF 7F 23 74 45 36 D8 10 29 0B D2 17 F1 1C 00 08 E0 7F 2D 2B 46 28 BF 7F 23 10 29 01 D2 17 F1 1C 00 BC 60 03 55 F8 69 D7 E9 0B E1 7B 68 64 1C 54 45 89 D3 1B B3 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 39 6B F8 69 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? 39 6B F8 69 D8 F8 00 30 00 2B D9 F8 00 30 01 D1 63 B1 00 E0 53 B9 40 46 6D 1C ?? ?? ?? ?? 6F F0 00 03 5B E7 ?? ?? ?? ?? ?? ?? ?? ?? 10 29 01 D3 ?? ?? ?? ?? 0F 23 B8 69 3B 63 00 23 FB 62 3B 77 ?? ?? ?? ?? B8 68 0E B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_44_1 {
	meta:
		name = "??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z"
		size = 460
		refs = "0008 __security_push_cookie 0048 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00c8 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 0194 ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ 01a0 _invalid_parameter_noinfo_noreturn 01ac ??3@YAXPAX@Z 01c4 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 9E 46 3B 60 13 46 6F F0 01 02 C7 E9 04 22 BE F8 00 50 00 26 BB 60 8A 46 80 46 4D B1 2C 46 AC 42 08 BF 5B 1C 76 1C 3E F8 16 40 00 2C F7 D1 BB 60 17 F1 18 00 00 22 19 46 ?? ?? ?? ?? 6F F0 01 02 FA 60 01 25 BB 68 00 22 39 6B F8 69 00 24 00 2B 7A 60 91 46 00 F0 A0 80 FE 6A D7 F8 00 E0 3E F8 19 30 4B B1 BE F8 00 20 93 42 05 D0 09 F1 01 09 3E F8 19 30 00 2B F7 D1 B4 42 00 F2 8B 80 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 43 B1 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 99 44 50 E0 A9 44 3E F8 19 20 BE F8 00 30 9A 42 3C D0 DA B3 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B 61 F8 69 9A F8 04 30 2B B9 50 46 ?? ?? ?? ?? D7 E9 0B 61 F8 69 D8 F8 00 30 00 2B DA F8 00 30 01 D1 AB B1 00 E0 9B B9 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B 61 F8 69 D7 F8 00 E0 B8 F8 06 20 3E F8 19 30 93 42 04 D1 01 22 7A 60 1A E0 D7 F8 00 E0 7F 2D 2B 46 28 BF 7F 23 B4 42 38 D8 10 29 0B D2 17 F1 1C 00 08 E0 7F 2D 2B 46 28 BF 7F 23 10 29 01 D2 17 F1 1C 00 FC 60 03 55 F8 69 D7 E9 0B 61 7A 68 BB 68 64 1C 9C 42 88 D3 22 B3 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 39 6B F8 69 9A F8 04 30 23 B9 50 46 ?? ?? ?? ?? 39 6B F8 69 D8 F8 00 30 00 2B DA F8 00 30 01 D1 6B B1 00 E0 5B B9 40 46 6D 1C ?? ?? ?? ?? 6F F0 00 03 FB 60 59 E7 ?? ?? ?? ?? ?? ?? ?? ?? 10 29 01 D3 ?? ?? ?? ?? 0F 23 B8 69 3B 63 00 23 FB 62 3B 77 ?? ?? ?? ?? F8 68 0E B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_46_1 {
	meta:
		name = "??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z"
		size = 460
		refs = "0008 __security_push_cookie 0048 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00c8 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 0194 ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ 01a0 _invalid_parameter_noinfo_noreturn 01ac ??3@YAXPAX@Z 01c4 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 6F 46 9E 46 3B 60 13 46 6F F0 01 02 C7 E9 04 22 BE F8 00 50 00 26 BB 60 8A 46 80 46 4D B1 2C 46 AC 42 08 BF 5B 1C 76 1C 3E F8 16 40 00 2C F7 D1 BB 60 17 F1 18 00 00 22 19 46 ?? ?? ?? ?? 6F F0 01 02 FA 60 01 25 BB 68 00 22 39 6B F8 69 00 24 00 2B 7A 60 91 46 00 F0 A0 80 FE 6A D7 F8 00 E0 3E F8 19 30 4B B1 BE F8 00 20 93 42 05 D0 09 F1 01 09 3E F8 19 30 00 2B F7 D1 B4 42 00 F2 8B 80 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 43 B1 10 29 28 BF 03 46 01 D2 17 F1 1C 03 1B 57 99 44 50 E0 A9 44 3E F8 19 20 BE F8 00 30 9A 42 3C D0 DA B3 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B 61 F8 69 9A F8 04 30 2B B9 50 46 ?? ?? ?? ?? D7 E9 0B 61 F8 69 D8 F8 00 30 00 2B DA F8 00 30 01 D1 AB B1 00 E0 9B B9 98 F8 04 30 2B B9 40 46 ?? ?? ?? ?? D7 E9 0B 61 F8 69 D7 F8 00 E0 B8 F8 06 20 3E F8 19 30 93 42 04 D1 01 22 7A 60 1A E0 D7 F8 00 E0 7F 2D 2B 46 28 BF 7F 23 B4 42 38 D8 10 29 0B D2 17 F1 1C 00 08 E0 7F 2D 2B 46 28 BF 7F 23 10 29 01 D2 17 F1 1C 00 FC 60 03 55 F8 69 D7 E9 0B 61 7A 68 BB 68 64 1C 9C 42 88 D3 22 B3 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? 39 6B F8 69 9A F8 04 30 23 B9 50 46 ?? ?? ?? ?? 39 6B F8 69 D8 F8 00 30 00 2B DA F8 00 30 01 D1 6B B1 00 E0 5B B9 40 46 6D 1C ?? ?? ?? ?? 6F F0 00 03 FB 60 59 E7 ?? ?? ?? ?? ?? ?? ?? ?? 10 29 01 D3 ?? ?? ?? ?? 0F 23 B8 69 3B 63 00 23 FB 62 3B 77 ?? ?? ?? ?? F8 68 0E B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_48_1 {
	meta:
		name = "??$_Getvals@G@?$_Mpunct@G@std@@IAAXGPBUlconv@@@Z"
		size = 184
		refs = "0022 ??$_Maklocstr@G@std@@YAPAGPBDPAGABU_Cvtvec@@@Z 0076 _Mbrtowc 00b0 ??_C@_01JOAMLHOP@?9?$AA@ 00b4 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 87 B0 90 F8 28 30 14 46 05 46 0B B1 E0 68 00 E0 20 69 05 F1 2C 06 32 46 00 21 ?? ?? ?? ?? 28 61 94 F8 2E 30 04 2B 01 D9 20 48 00 E0 20 6A 32 46 00 21 ?? ?? ?? ?? 68 61 94 F8 2F 30 04 2B 01 D9 19 48 00 E0 60 6A 32 46 00 21 ?? ?? ?? ?? A8 61 63 69 02 A9 0D F1 0A 00 1B 78 01 22 00 96 8D F8 08 30 00 23 AD F8 0A 30 CD E9 04 33 04 AB ?? ?? ?? ?? BD F8 0A 30 02 A9 0D F1 0A 00 AB 81 A3 69 00 96 1B 78 8D F8 08 30 00 23 AD F8 0A 30 CD E9 04 33 04 AB 01 22 ?? ?? ?? ?? BD F8 0A 30 EB 81 07 B0 BD E8 70 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_49_1 {
	meta:
		name = "??$_Getvals@G@?$numpunct@G@std@@IAAXGPBUlconv@@U_Cvtvec@@@Z"
		size = 128
		refs = "000a __security_push_cookie 001a memcpy 003e _Mbrtowc 0074 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 91 B0 14 46 05 46 06 A8 2C 22 19 A9 ?? ?? ?? ?? 23 68 02 A9 1B 78 0D F1 0A 00 01 22 8D F8 08 30 00 23 AD F8 0A 30 CD E9 04 33 06 AB 00 93 04 AB ?? ?? ?? ?? BD F8 0A 30 02 A9 0D F1 0A 00 AB 81 63 68 1B 78 8D F8 08 30 00 23 AD F8 0A 30 CD E9 04 33 06 AB 00 93 04 AB 01 22 ?? ?? ?? ?? BD F8 0A 30 EB 81 11 B0 ?? ?? ?? ?? BD E8 30 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_50_1 {
	meta:
		name = "??$_Getvals@G@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXGABV_Locinfo@1@@Z"
		size = 92
		refs = "0010 _Getcvt 001c memcpy 0022 ?_Getdays@_Locinfo@std@@QBAPBDXZ 002c ??$_Maklocstr@G@std@@YAPAGPBDPAGABU_Cvtvec@@@Z 0034 ?_Getmonths@_Locinfo@std@@QBAPBDXZ 0058 ??_C@_0N@LPFKKEBD@?3AM?3am?3PM?3pm?$AA@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 8C B0 05 46 68 46 14 46 ?? ?? ?? ?? 05 F1 18 00 69 46 2C 22 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 05 F1 18 02 00 21 ?? ?? ?? ?? A8 60 20 46 ?? ?? ?? ?? 05 F1 18 02 00 21 ?? ?? ?? ?? E8 60 04 48 05 F1 18 02 00 21 ?? ?? ?? ?? 28 61 0C B0 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_51_1 {
	meta:
		name = "??$_Getvals@_W@?$_Mpunct@_W@std@@IAAX_WPBUlconv@@@Z"
		size = 192
		refs = "001a wcslen 0026 calloc 0034 memcpy 00aa ?_Xbad_alloc@std@@YAXXZ 00b8 ??_C@_13IMODFHAA@?$AA?9?$AA?$AA@ 00bc ??_C@_11LOCGONAA@?$AA?$AA@"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 90 F8 28 30 14 46 06 46 0B B1 A5 6B 00 E0 E5 6B 28 46 ?? ?? ?? ?? 00 F1 01 08 40 46 02 21 ?? ?? ?? ?? 07 46 EF B3 4F EA 48 02 29 46 ?? ?? ?? ?? 37 61 94 F8 2E 30 04 2B 01 D9 1E 4D 00 E0 A5 6C 28 46 ?? ?? ?? ?? 00 F1 01 08 40 46 02 21 ?? ?? ?? ?? 07 46 3F B3 4F EA 48 02 29 46 ?? ?? ?? ?? 77 61 94 F8 2F 30 04 2B 01 D9 11 4D 00 E0 E5 6C 28 46 ?? ?? ?? ?? 00 F1 01 08 40 46 02 21 ?? ?? ?? ?? 07 46 8F B1 4F EA 48 02 29 46 ?? ?? ?? ?? B7 61 23 6C 1B 88 B3 81 63 6C 1B 88 F3 81 BD E8 F8 89 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_52_1 {
	meta:
		name = "??$_Getvals@_W@?$numpunct@_W@std@@IAAX_WPBUlconv@@U_Cvtvec@@@Z"
		size = 28
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 13 6B 1B 88 83 81 53 6B 1B 88 C3 81 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_17_53_1 {
	meta:
		name = "??$_Getvals@_W@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAX_WABV_Locinfo@1@@Z"
		size = 156
		refs = "0010 _Getcvt 001c memcpy 0022 ?_W_Getdays@_Locinfo@std@@QBAPBGXZ 0028 wcslen 0034 calloc 004a ?_W_Getmonths@_Locinfo@std@@QBAPBGXZ 0088 ?_Xbad_alloc@std@@YAXXZ 0098 ??_C@_1BK@MHIKGOKE@?$AA?3?$AAA?$AAM?$AA?3?$AAa?$AAm?$AA?3?$AAP?$AAM?$AA?3?$AAp?$AAm?$AA?$AA@"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 8B B0 05 46 68 46 16 46 ?? ?? ?? ?? 05 F1 18 00 69 46 2C 22 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 07 46 ?? ?? ?? ?? 00 F1 01 08 40 46 02 21 ?? ?? ?? ?? 04 46 2C B3 4F EA 48 02 39 46 ?? ?? ?? ?? 30 46 AC 60 ?? ?? ?? ?? 06 46 ?? ?? ?? ?? 47 1C 38 46 02 21 ?? ?? ?? ?? 04 46 A4 B1 7A 00 31 46 ?? ?? ?? ?? 02 21 0D 20 EC 60 ?? ?? ?? ?? 04 46 5C B1 07 49 1A 22 ?? ?? ?? ?? 2C 61 0B B0 BD E8 F0 89 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_54_1 {
	meta:
		name = "??$_Is_checked@V?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AU?$integral_constant@_N$00@0@V?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@@Z"
		size = 26
		altNames = "??$_Is_checked@V?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YA?AU?$integral_constant@_N$00@0@V?$ostreambuf_iterator@DU?$char_traits@D@std@@@0@@Z ??$_Is_checked@V?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AU?$integral_constant@_N$00@0@V?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@@Z"
	strings:
		$1 = { 03 B4 2D E9 0C 48 0D F1 08 0B 00 23 8D F8 00 30 00 98 BD E8 0C 08 5D F8 0C FB }
	condition:
		$1
}

rule file_17_56_1 {
	meta:
		name = "??$_LStrcoll@G@std@@YAHPBG000PBU_Collvec@@@Z"
		size = 56
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 08 E0 9A 42 0D D0 04 88 32 F8 02 5B A5 42 05 D8 09 D3 80 1C 88 42 F4 D1 9A 42 02 D0 6F F0 00 00 04 E0 88 42 01 D0 01 20 00 E0 00 20 BD E8 30 88 }
	condition:
		$1
}

rule file_17_58_1 {
	meta:
		name = "??$_LStrxfrm@G@std@@YAIPAG0PBG1PBU_Collvec@@@Z"
		size = 90
		refs = "0020 _errno 0032 memcpy 003c memset 0050 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 16 46 9B 1B 5F 10 0B 1A 5B 10 9F 42 1E D8 7C 00 4F EA 43 05 1A D0 18 B9 ?? ?? ?? ?? 16 23 12 E0 36 B1 A5 42 04 D3 22 46 31 46 ?? ?? ?? ?? 0D E0 2A 46 00 21 ?? ?? ?? ?? 00 2E ED D0 A5 42 05 D2 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 38 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_17_60_1 {
	meta:
		name = "??$_Maklocchr@G@std@@YAGDPAGABU_Cvtvec@@@Z"
		size = 48
		refs = "001e _Mbrtowc"
		altNames = "??$_Maklocchr@_W@std@@YA_WDPA_WABU_Cvtvec@@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 00 23 AD F8 08 30 CD E9 04 33 04 AB 00 92 08 A9 02 A8 01 22 ?? ?? ?? ?? BD F8 08 00 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_17_63_1 {
	meta:
		name = "??$_Maklocstr@G@std@@YAPAGPBDPAGABU_Cvtvec@@@Z"
		size = 140
		refs = "0014 strlen 0032 _Mbrtowc 004a calloc 0086 ?_Xbad_alloc@std@@YAXXZ"
		altNames = "??$_Maklocstr@_W@std@@YAPA_WPBDPA_WABU_Cvtvec@@@Z"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 88 B0 00 23 CD E9 04 33 90 46 07 46 ?? ?? ?? ?? 10 F1 01 09 4D 46 4F F0 00 04 3E 46 0E D0 04 AB 2A 46 31 46 02 A8 CD F8 00 80 ?? ?? ?? ?? 00 28 04 DD 2D 1A 06 44 64 1C 00 2D F0 D1 64 1C 20 46 02 21 ?? ?? ?? ?? 06 46 CE B1 00 23 CD E9 06 33 05 46 0C E0 06 AB 4A 46 39 46 28 46 CD F8 00 80 ?? ?? ?? ?? 00 28 04 DD 07 44 64 1E AD 1C 00 2C F0 D1 00 23 2B 80 30 46 08 B0 BD E8 F0 8B ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_73_1 {
	meta:
		name = "??$_Ptr_copy_cat@PA_WV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AU_General_ptr_iterator_tag@0@ABQA_WABV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@@Z"
		size = 20
		altNames = "??$_Ptr_copy_cat@PADV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YA?AU_General_ptr_iterator_tag@0@ABQADABV?$ostreambuf_iterator@DU?$char_traits@D@std@@@0@@Z ??$_Ptr_copy_cat@PA_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AU_General_ptr_iterator_tag@0@ABQA_WABV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 00 23 8D F8 00 30 00 98 BD E8 0C 88 }
	condition:
		$1
}

rule file_17_75_1 {
	meta:
		name = "??$_Rechecked@V?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@V12@@std@@YAAAV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@AAV10@V10@@Z"
		size = 20
		altNames = "??$_Rechecked@V?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@V12@@std@@YAAAV?$ostreambuf_iterator@DU?$char_traits@D@std@@@0@AAV10@V10@@Z ??$_Rechecked@V?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@V12@@std@@YAAAV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@AAV10@V10@@Z ??$_Unchecked@V?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@0@V10@@Z ??$_Unchecked@V?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@V10@@Z ??$_Unchecked@V?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@V10@@Z ??$_Unchecked_idl0@V?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@0@V10@@Z ??$_Unchecked_idl0@V?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@0@V10@@Z ??$_Unchecked_idl0@V?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@0@V10@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 01 60 42 60 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_17_93_1 {
	meta:
		name = "??$assign@V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV01@V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@0@Z"
		size = 138
		refs = "003c ?end@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 005a ?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 0080 ?replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@1@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 99 B0 00 23 CD E9 02 33 13 68 04 46 1B B1 1B 68 0B B1 1B 68 02 93 93 68 04 93 00 23 CD E9 06 33 0B 68 1B B1 1B 68 0B B1 1B 68 06 93 8B 68 12 A9 20 46 08 93 ?? ?? ?? ?? 00 23 CD E9 0A 33 03 68 1B B1 1B 68 0B B1 1B 68 0A 93 83 68 16 A9 20 46 0C 93 ?? ?? ?? ?? 00 23 CD E9 0E 33 03 68 1B B1 1B 68 0B B1 1B 68 0E 93 83 68 0A AA 20 46 10 93 02 AB 00 93 06 AB 0E A9 ?? ?? ?? ?? 19 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_99_39_1 {
	meta:
		name = "??$assign@V?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@V?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@0@Z"
		size = 138
		refs = "003c ?end@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 005a ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0080 ?replace@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@1@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 99 B0 00 23 CD E9 02 33 13 68 04 46 1B B1 1B 68 0B B1 1B 68 02 93 93 68 04 93 00 23 CD E9 06 33 0B 68 1B B1 1B 68 0B B1 1B 68 06 93 8B 68 12 A9 20 46 08 93 ?? ?? ?? ?? 00 23 CD E9 0A 33 03 68 1B B1 1B 68 0B B1 1B 68 0A 93 83 68 16 A9 20 46 0C 93 ?? ?? ?? ?? 00 23 CD E9 0E 33 03 68 1B B1 1B 68 0B B1 1B 68 0E 93 83 68 0A AA 20 46 10 93 02 AB 00 93 06 AB 0E A9 ?? ?? ?? ?? 19 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_17_94_1 {
	meta:
		name = "??$assign@V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV01@V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@0@Z"
		size = 138
		refs = "003c ?end@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 005a ?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0080 ?replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@1@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 99 B0 00 23 CD E9 02 33 13 68 04 46 1B B1 1B 68 0B B1 1B 68 02 93 93 68 04 93 00 23 CD E9 06 33 0B 68 1B B1 1B 68 0B B1 1B 68 06 93 8B 68 12 A9 20 46 08 93 ?? ?? ?? ?? 00 23 CD E9 0A 33 03 68 1B B1 1B 68 0B B1 1B 68 0A 93 83 68 16 A9 20 46 0C 93 ?? ?? ?? ?? 00 23 CD E9 0E 33 03 68 1B B1 1B 68 0B B1 1B 68 0E 93 83 68 0A AA 20 46 10 93 02 AB 00 93 06 AB 0E A9 ?? ?? ?? ?? 19 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_17_191_1 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAA@$$QAU01@@Z"
		size = 28
		altNames = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAA@$$QAU01@@Z ??0?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAA@ABU01@@Z ??0?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAA@ABU01@@Z ??0?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAA@$$QAU01@@Z ??0?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAA@ABU01@@Z ??0_Iterator_base12@std@@QAA@ABU01@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 00 33 0B 68 1B B1 1B 68 0B B1 1B 68 03 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_197_1 {
	meta:
		name = "??0?$_Mpunct@G@std@@QAA@ABV_Locinfo@1@I_N1@Z"
		size = 60
		refs = "0028 ?_Init@?$_Mpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 0038 ??_7?$_Mpunct@G@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 07 4A 20 46 84 F8 28 30 22 60 97 F8 28 20 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_81_1 {
	meta:
		name = "??0?$_Mpunct@D@std@@QAA@ABV_Locinfo@1@I_N1@Z"
		size = 60
		refs = "0028 ?_Init@?$_Mpunct@D@std@@IAAXABV_Locinfo@2@_N@Z 0038 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 07 4A 20 46 84 F8 28 30 22 60 97 F8 28 20 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_199_1 {
	meta:
		name = "??0?$_Mpunct@_W@std@@QAA@ABV_Locinfo@1@I_N1@Z"
		size = 60
		refs = "0028 ?_Init@?$_Mpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 0038 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 07 4A 20 46 84 F8 28 30 22 60 97 F8 28 20 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_204_1 {
	meta:
		name = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@$$QAV01@@Z"
		size = 32
		altNames = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@$$QAV01@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@ABV01@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@ABV01@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@$$QAV01@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@ABV01@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@ABV01@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@ABV01@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 00 33 0B 68 1B B1 1B 68 0B B1 1B 68 03 60 8B 68 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_206_1 {
	meta:
		name = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@PBGPBU_Container_base12@1@@Z"
		size = 24
		altNames = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@PBDPBU_Container_base12@1@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@PB_WPBU_Container_base12@1@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@PADPBU_Container_base12@1@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@PAGPBU_Container_base12@1@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@PA_WPBU_Container_base12@1@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 00 33 81 60 0A B1 13 68 03 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_207_1 {
	meta:
		name = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@XZ"
		size = 18
		altNames = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 00 33 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_239_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@$$QAV01@@Z"
		size = 122
		refs = "0020 ??2@YAPAXI@Z 0026 _invalid_parameter_noinfo_noreturn 0054 memmove"
		altNames = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@$$QAV01@@Z"
	strings:
		$1 = { 2D E9 FE 49 0D F1 20 0B 6F 46 6F F0 01 03 05 46 00 26 C7 E9 00 33 08 20 2E 60 C5 E9 05 66 0C 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 28 60 C0 E9 00 32 2B 68 4F F0 07 08 1D 60 C5 E9 05 68 AE 80 A3 69 08 2B 08 D2 63 69 5B 1C 0B D0 5A 00 21 1D 28 1D ?? ?? ?? ?? 05 E0 15 F1 04 0F 01 D0 63 68 6B 60 66 60 63 69 6B 61 A3 69 AB 61 C4 E9 05 68 A6 80 28 46 BD E8 FE 89 }
	condition:
		$1
}

rule file_17_240_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@ABV01@@Z"
		size = 102
		refs = "0024 ??2@YAPAXI@Z 002a _invalid_parameter_noinfo_noreturn 0058 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 03 B4 2D E9 FC 48 0D F1 18 0B 6F 46 04 46 6F F0 01 03 3C 62 00 26 C7 E9 00 33 08 20 26 60 C4 E9 05 66 0D 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 A3 61 08 2B 01 D3 63 68 00 E0 23 1D 66 61 1E 80 6F F0 00 03 00 22 29 46 20 46 ?? ?? ?? ?? 20 46 BD E8 FC 08 5D F8 0C FB }
	condition:
		$1
}

rule file_17_250_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@ABV01@@Z"
		size = 102
		refs = "0024 ??2@YAPAXI@Z 002a _invalid_parameter_noinfo_noreturn 0058 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
	strings:
		$1 = { 03 B4 2D E9 FC 48 0D F1 18 0B 6F 46 04 46 6F F0 01 03 3C 62 00 26 C7 E9 00 33 08 20 26 60 C4 E9 05 66 0D 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 A3 61 08 2B 01 D3 63 68 00 E0 23 1D 66 61 1E 80 6F F0 00 03 00 22 29 46 20 46 ?? ?? ?? ?? 20 46 BD E8 FC 08 5D F8 0C FB }
	condition:
		$1
}

rule file_17_242_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@IG@Z"
		size = 108
		refs = "002a ??2@YAPAXI@Z 0030 _invalid_parameter_noinfo_noreturn 005e ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 04 46 6F F0 01 03 BC 62 4F F0 00 08 C7 E9 00 33 C0 F8 00 80 C0 E9 05 88 08 20 15 46 0E 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 A3 61 08 2B 01 D3 63 68 00 E0 23 1D C4 F8 14 80 2A 46 31 46 20 46 A3 F8 00 80 ?? ?? ?? ?? 20 46 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_246_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBGI@Z"
		size = 108
		refs = "002a ??2@YAPAXI@Z 0030 _invalid_parameter_noinfo_noreturn 005e ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBGI@Z"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 04 46 6F F0 01 03 BC 62 4F F0 00 08 C7 E9 00 33 C0 F8 00 80 C0 E9 05 88 08 20 15 46 0E 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 A3 61 08 2B 01 D3 63 68 00 E0 23 1D C4 F8 14 80 2A 46 31 46 20 46 A3 F8 00 80 ?? ?? ?? ?? 20 46 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_252_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@I_W@Z"
		size = 108
		refs = "002a ??2@YAPAXI@Z 0030 _invalid_parameter_noinfo_noreturn 005e ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 04 46 6F F0 01 03 BC 62 4F F0 00 08 C7 E9 00 33 C0 F8 00 80 C0 E9 05 88 08 20 15 46 0E 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 A3 61 08 2B 01 D3 63 68 00 E0 23 1D C4 F8 14 80 2A 46 31 46 20 46 A3 F8 00 80 ?? ?? ?? ?? 20 46 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_256_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_WI@Z"
		size = 108
		refs = "002a ??2@YAPAXI@Z 0030 _invalid_parameter_noinfo_noreturn 005e ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 04 46 6F F0 01 03 BC 62 4F F0 00 08 C7 E9 00 33 C0 F8 00 80 C0 E9 05 88 08 20 15 46 0E 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 A3 61 08 2B 01 D3 63 68 00 E0 23 1D C4 F8 14 80 2A 46 31 46 20 46 A3 F8 00 80 ?? ?? ?? ?? 20 46 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_244_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBG@Z"
		size = 112
		refs = "0024 ??2@YAPAXI@Z 002a _invalid_parameter_noinfo_noreturn 0058 wcslen 0062 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBGI@Z"
	strings:
		$1 = { 03 B4 2D E9 FC 48 0D F1 18 0B 6F 46 04 46 6F F0 01 03 3C 62 00 26 C7 E9 00 33 08 20 26 60 C4 E9 05 66 0D 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 A3 61 08 2B 01 D3 63 68 00 E0 23 1D 66 61 1E 80 2B 88 0B B9 00 20 02 E0 28 46 ?? ?? ?? ?? 02 46 20 46 29 46 ?? ?? ?? ?? 20 46 BD E8 FC 08 5D F8 0C FB }
	condition:
		$1
}

rule file_17_254_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z"
		size = 112
		refs = "0024 ??2@YAPAXI@Z 002a _invalid_parameter_noinfo_noreturn 0058 wcslen 0062 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
	strings:
		$1 = { 03 B4 2D E9 FC 48 0D F1 18 0B 6F 46 04 46 6F F0 01 03 3C 62 00 26 C7 E9 00 33 08 20 26 60 C4 E9 05 66 0D 46 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 A3 61 08 2B 01 D3 63 68 00 E0 23 1D 66 61 1E 80 2B 88 0B B9 00 20 02 E0 28 46 ?? ?? ?? ?? 02 46 20 46 29 46 ?? ?? ?? ?? 20 46 BD E8 FC 08 5D F8 0C FB }
	condition:
		$1
}

rule file_17_248_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
		size = 68
		refs = "001e ??2@YAPAXI@Z 0024 _invalid_parameter_noinfo_noreturn"
		altNames = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 04 46 00 25 C7 E9 00 33 08 20 25 60 C4 E9 05 55 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 C4 E9 05 53 A5 80 20 46 BD E8 BE 88 }
	condition:
		$1
}

rule file_17_259_1 {
	meta:
		name = "??0?$codecvt@GDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 48
		refs = "0014 _Getcvt 0020 memcpy 002c ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8B B0 08 4B 04 46 68 46 C4 E9 00 32 ?? ?? ?? ?? 69 46 2C 22 04 F1 08 00 ?? ?? ?? ?? 20 46 0B B0 BD E8 10 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_260_1 {
	meta:
		name = "??0?$codecvt@_WDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 48
		refs = "0014 _Getcvt 0020 memcpy 002c ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8B B0 08 4B 04 46 68 46 C4 E9 00 32 ?? ?? ?? ?? 69 46 2C 22 04 F1 08 00 ?? ?? ?? ?? 20 46 0B B0 BD E8 10 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_261_1 {
	meta:
		name = "??0?$collate@G@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 40
		refs = "0012 _Getcoll 0024 ??_7?$collate@G@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 06 4B 04 46 68 46 C4 E9 00 32 ?? ?? ?? ?? 00 9B 20 46 A3 60 01 9B E3 60 BD E8 1E 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_107_1 {
	meta:
		name = "??0?$collate@D@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 40
		refs = "0012 _Getcoll 0024 ??_7?$collate@D@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 06 4B 04 46 68 46 C4 E9 00 32 ?? ?? ?? ?? 00 9B 20 46 A3 60 01 9B E3 60 BD E8 1E 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_262_1 {
	meta:
		name = "??0?$collate@_W@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 40
		refs = "0012 _Getcoll 0024 ??_7?$collate@_W@std@@6B@"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 06 4B 04 46 68 46 C4 E9 00 32 ?? ?? ?? ?? 00 9B 20 46 A3 60 01 9B E3 60 BD E8 1E 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_263_1 {
	meta:
		name = "??0?$ctype@G@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 64
		refs = "0014 _Getctype 0024 _Getcvt 0030 memcpy 003c ??_7?$ctype@G@std@@6B@"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 90 B0 0C 4B 07 46 68 46 C7 E9 00 32 ?? ?? ?? ?? 6D 46 1E CD 07 F1 08 06 1E C6 04 A8 ?? ?? ?? ?? 04 A9 2C 22 07 F1 18 00 ?? ?? ?? ?? 38 46 10 B0 BD E8 F0 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_264_1 {
	meta:
		name = "??0?$ctype@_W@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 64
		refs = "0014 _Getctype 0024 _Getcvt 0030 memcpy 003c ??_7?$ctype@_W@std@@6B@"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 90 B0 0C 4B 07 46 68 46 C7 E9 00 32 ?? ?? ?? ?? 6D 46 1E CD 07 F1 08 06 1E C6 04 A8 ?? ?? ?? ?? 04 A9 2C 22 07 F1 18 00 ?? ?? ?? ?? 38 46 10 B0 BD E8 F0 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_271_1 {
	meta:
		name = "??0?$moneypunct@G$00@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 68
		refs = "0028 ?_Init@?$_Mpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 003c ??_7?$moneypunct@G$00@std@@6B@ 0040 ??_7?$_Mpunct@G@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 09 4A 20 46 22 60 01 22 84 F8 28 20 1A 46 ?? ?? ?? ?? 03 4B 23 60 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_112_1 {
	meta:
		name = "??0?$moneypunct@D$00@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 68
		refs = "0028 ?_Init@?$_Mpunct@D@std@@IAAXABV_Locinfo@2@_N@Z 003c ??_7?$moneypunct@D$00@std@@6B@ 0040 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 09 4A 20 46 22 60 01 22 84 F8 28 20 1A 46 ?? ?? ?? ?? 03 4B 23 60 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_275_1 {
	meta:
		name = "??0?$moneypunct@_W$00@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 68
		refs = "0028 ?_Init@?$_Mpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 003c ??_7?$moneypunct@_W$00@std@@6B@ 0040 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 09 4A 20 46 22 60 01 22 84 F8 28 20 1A 46 ?? ?? ?? ?? 03 4B 23 60 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_273_1 {
	meta:
		name = "??0?$moneypunct@G$0A@@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 68
		refs = "0028 ?_Init@?$_Mpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 003c ??_7?$moneypunct@G$0A@@std@@6B@ 0040 ??_7?$_Mpunct@G@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 09 4A 20 46 22 60 00 22 84 F8 28 20 1A 46 ?? ?? ?? ?? 03 4B 23 60 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_114_1 {
	meta:
		name = "??0?$moneypunct@D$0A@@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 68
		refs = "0028 ?_Init@?$_Mpunct@D@std@@IAAXABV_Locinfo@2@_N@Z 003c ??_7?$moneypunct@D$0A@@std@@6B@ 0040 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 09 4A 20 46 22 60 00 22 84 F8 28 20 1A 46 ?? ?? ?? ?? 03 4B 23 60 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_277_1 {
	meta:
		name = "??0?$moneypunct@_W$0A@@std@@QAA@ABV_Locinfo@1@I_N@Z"
		size = 68
		refs = "0028 ?_Init@?$_Mpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 003c ??_7?$moneypunct@_W$0A@@std@@6B@ 0040 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 00 BC 61 C7 E9 00 00 62 60 09 4A 20 46 22 60 00 22 84 F8 28 20 1A 46 ?? ?? ?? ?? 03 4B 23 60 20 46 BD E8 9C 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_287_1 {
	meta:
		name = "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 48
		refs = "001e ?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 002c ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 03 BC 61 C7 E9 00 33 62 60 04 4B 23 60 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_116_1 {
	meta:
		name = "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 48
		refs = "001e ?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 002c ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 03 BC 61 C7 E9 00 33 62 60 04 4B 23 60 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_289_1 {
	meta:
		name = "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 48
		refs = "001e ?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 002c ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 9C 48 0D F1 10 0B 6F 46 04 46 6F F0 01 03 BC 61 C7 E9 00 33 62 60 04 4B 23 60 ?? ?? ?? ?? 20 46 BD E8 9C 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_291_1 {
	meta:
		name = "??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 52
		refs = "001a ?_W_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 0026 free 0030 ??_7?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 09 4B 0C 46 05 46 00 26 C5 E9 00 32 69 46 20 46 AE 60 ?? ?? ?? ?? 03 68 AB 60 06 60 00 98 ?? ?? ?? ?? 28 46 BD E8 78 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_118_1 {
	meta:
		name = "??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 52
		refs = "001a ?_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 0026 free 0030 ??_7?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 09 4B 0C 46 05 46 00 26 C5 E9 00 32 69 46 20 46 AE 60 ?? ?? ?? ?? 03 68 AB 60 06 60 00 98 ?? ?? ?? ?? 28 46 BD E8 78 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_292_1 {
	meta:
		name = "??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 52
		refs = "001a ?_W_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 0026 free 0030 ??_7?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 09 4B 0C 46 05 46 00 26 C5 E9 00 32 69 46 20 46 AE 60 ?? ?? ?? ?? 03 68 AB 60 06 60 00 98 ?? ?? ?? ?? 28 46 BD E8 78 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_330_1 {
	meta:
		name = "??1?$_Mpunct@G@std@@MAA@XZ"
		size = 56
		refs = "0010 free 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$_Mpunct@G@std@@6B@"
		altNames = "??1?$moneypunct@G$00@std@@MAA@XZ ??1?$moneypunct@G$0A@@std@@MAA@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? A0 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_150_1 {
	meta:
		name = "??1?$_Mpunct@D@std@@MAA@XZ"
		size = 56
		refs = "0010 free 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? A0 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_331_1 {
	meta:
		name = "??1?$_Mpunct@_W@std@@MAA@XZ"
		size = 56
		refs = "0010 free 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? A0 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_163_1 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MAA@XZ"
		size = 56
		refs = "0010 free 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? A0 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_164_1 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MAA@XZ"
		size = 56
		refs = "0010 free 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? A0 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_361_1 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MAA@XZ"
		size = 56
		refs = "0010 free 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? A0 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_362_1 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MAA@XZ"
		size = 56
		refs = "0010 free 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? A0 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_345_1 {
	meta:
		name = "??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
		size = 44
		refs = "0012 ??3@YAXPAX@Z"
		altNames = "??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 A3 69 08 2B 02 D3 60 68 ?? ?? ?? ?? 07 23 00 25 C4 E9 05 53 A5 80 20 68 ?? ?? ?? ?? 25 60 BD E8 30 88 }
	condition:
		$1
}

rule file_17_349_1 {
	meta:
		name = "??1?$collate@G@std@@MAA@XZ"
		size = 36
		refs = "0010 free 001c ??_7_Facet_base@std@@6B@ 0020 ??_7?$collate@G@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 E0 68 23 60 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_158_1 {
	meta:
		name = "??1?$collate@D@std@@MAA@XZ"
		size = 36
		refs = "0010 free 001c ??_7_Facet_base@std@@6B@ 0020 ??_7?$collate@D@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 E0 68 23 60 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_350_1 {
	meta:
		name = "??1?$collate@_W@std@@MAA@XZ"
		size = 36
		refs = "0010 free 001c ??_7_Facet_base@std@@6B@ 0020 ??_7?$collate@_W@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 E0 68 23 60 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_351_1 {
	meta:
		name = "??1?$ctype@G@std@@MAA@XZ"
		size = 48
		refs = "0014 free 0028 ??_7_Facet_base@std@@6B@ 002c ??_7?$ctype@G@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 23 60 23 69 13 B1 E0 68 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_352_1 {
	meta:
		name = "??1?$ctype@_W@std@@MAA@XZ"
		size = 48
		refs = "0014 free 0028 ??_7_Facet_base@std@@6B@ 002c ??_7?$ctype@_W@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 23 60 23 69 13 B1 E0 68 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 02 4B 23 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_369_1 {
	meta:
		name = "??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 48
		refs = "0010 free 0028 ??_7_Facet_base@std@@6B@ 002c ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 A0 68 23 60 ?? ?? ?? ?? E0 68 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_165_1 {
	meta:
		name = "??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 48
		refs = "0010 free 0028 ??_7_Facet_base@std@@6B@ 002c ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 A0 68 23 60 ?? ?? ?? ?? E0 68 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_370_1 {
	meta:
		name = "??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 48
		refs = "0010 free 0028 ??_7_Facet_base@std@@6B@ 002c ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4B 04 46 A0 68 23 60 ?? ?? ?? ?? E0 68 ?? ?? ?? ?? 20 69 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_371_1 {
	meta:
		name = "??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 36
		refs = "0010 free 001c ??_7_Facet_base@std@@6B@ 0020 ??_7?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_166_1 {
	meta:
		name = "??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 36
		refs = "0010 free 001c ??_7_Facet_base@std@@6B@ 0020 ??_7?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_372_1 {
	meta:
		name = "??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 36
		refs = "0010 free 001c ??_7_Facet_base@std@@6B@ 0020 ??_7?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 A0 68 23 60 ?? ?? ?? ?? 01 4B 23 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_380_1 {
	meta:
		name = "??1_Timevec@std@@QAA@XZ"
		size = 16
		refs = "000c free"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_392_1 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAAAAU01@$$QAU01@@Z"
		size = 28
		altNames = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAAAAU01@$$QAU01@@Z ??4?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAAAAU01@$$QAU01@@Z ??4_Iterator_base12@std@@QAAAAU01@ABU01@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 68 03 68 93 42 04 D0 1A B1 13 68 0B B1 1B 68 03 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_394_1 {
	meta:
		name = "??4?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@$$QAV01@@Z"
		size = 32
		altNames = "??4?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAAAAV01@$$QAV01@@Z ??4?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@$$QAV01@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 68 03 68 93 42 04 D0 1A B1 13 68 0B B1 1B 68 03 60 8B 68 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_399_1 {
	meta:
		name = "??4?$_Yarn@_W@std@@QAAAAV01@PB_W@Z"
		size = 70
		refs = "0014 free 0030 malloc 003c memcpy"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 28 68 0C 46 A0 42 16 D0 08 B1 ?? ?? ?? ?? 00 23 2B 60 84 B1 23 88 22 46 01 E0 92 1C 13 88 00 2B FB D1 16 1B B0 1C ?? ?? ?? ?? 28 60 18 B1 B2 1C 21 46 ?? ?? ?? ?? 28 46 BD E8 78 88 }
	condition:
		$1
}

rule file_17_400_1 {
	meta:
		name = "??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV01@$$QAV01@@Z"
		size = 106
		refs = "0022 ??3@YAXPAX@Z 0044 memmove"
		altNames = "??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV01@$$QAV01@@Z ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@$$QAV12@@Z ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@$$QAV12@@Z"
	strings:
		$1 = { 2D E9 FE 49 0D F1 20 0B 6F 46 0D 46 04 46 6F F0 01 03 C7 E9 00 33 AC 42 24 D0 A3 69 08 2B 02 D3 60 68 ?? ?? ?? ?? 4F F0 07 08 00 26 C4 E9 05 68 A6 80 AB 69 08 2B 08 D2 6B 69 5B 1C 0B D0 5A 00 29 1D 20 1D ?? ?? ?? ?? 05 E0 14 F1 04 0F 01 D0 6B 68 63 60 6E 60 6B 69 63 61 AB 69 A3 61 C5 E9 05 68 AE 80 20 46 BD E8 FE 89 }
	condition:
		$1
}

rule file_17_404_1 {
	meta:
		name = "??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z"
		size = 90
		refs = "003c _guard_check_icall"
		altNames = "??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 06 46 75 68 0F 46 FD B1 2B 6A 1B 68 13 B1 2B 6B 1B 68 00 E0 00 23 00 2B 09 DD 2A 6B 13 68 5B 1E 13 60 2A 6A 11 68 8B 1C 13 60 0F 80 08 E0 2B 68 DC 68 20 46 ?? ?? ?? ?? 28 46 39 46 A0 47 07 46 4F F6 FF 73 9F 42 01 D1 01 23 33 70 30 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_17_407_1 {
	meta:
		name = "??4_Timevec@std@@QAAAAV01@ABV01@@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 68 03 60 00 23 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_408_1 {
	meta:
		name = "??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA_NABV01@@Z"
		size = 54
		refs = "0030 _invalid_parameter_noinfo_noreturn"
		altNames = "??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBA_NABV01@@Z ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA_NABV01@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 0B B9 00 23 00 E0 1B 68 0A 68 0A B9 00 22 00 E0 12 68 93 42 08 D1 82 68 8B 68 9A 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_410_1 {
	meta:
		name = "??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA_NABV01@@Z"
		size = 54
		refs = "0030 _invalid_parameter_noinfo_noreturn"
		altNames = "??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBA_NABV01@@Z ??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA_NABV01@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 0B B9 00 23 00 E0 1B 68 0A 68 0A B9 00 22 00 E0 12 68 93 42 08 D1 82 68 8B 68 9A 42 18 BF 01 20 08 BF 00 20 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_414_1 {
	meta:
		name = "??A?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAGI@Z"
		size = 38
		refs = "0020 _invalid_parameter_noinfo_noreturn"
		altNames = "??A?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAABGI@Z ??A?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAA_WI@Z ??A?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAAB_WI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 99 42 09 D8 83 69 08 2B 01 D3 43 68 00 E0 03 1D 03 EB 41 00 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_419_1 {
	meta:
		name = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAABGXZ"
		size = 66
		refs = "0034 _invalid_parameter_noinfo_noreturn"
		altNames = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAAB_WXZ ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAAAGXZ ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAAA_WXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 84 68 9C B1 03 68 AB B1 1A 68 9A B1 93 69 08 2B 01 D3 51 68 00 E0 11 1D A1 42 09 D8 53 69 01 EB 43 03 9C 42 04 D2 80 68 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_423_1 {
	meta:
		name = "??D?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBAGXZ"
		size = 24
		refs = "000e ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 79 0B B9 ?? ?? ?? ?? E0 88 BD E8 18 88 }
	condition:
		$1
}

rule file_17_424_1 {
	meta:
		name = "??D?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBA_WXZ"
		size = 24
		refs = "000e ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 79 0B B9 ?? ?? ?? ?? E0 88 BD E8 18 88 }
	condition:
		$1
}

rule file_17_427_1 {
	meta:
		name = "??E?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@XZ"
		size = 64
		refs = "0032 _invalid_parameter_noinfo_noreturn"
		altNames = "??E?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 81 68 91 B1 03 68 A3 B1 1A 68 92 B1 93 69 08 2B 01 D3 54 68 00 E0 14 1D 53 69 04 EB 43 03 99 42 05 D2 8B 1C 83 60 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_435_1 {
	meta:
		name = "??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAHABV01@@Z"
		size = 48
		refs = "002a _invalid_parameter_noinfo_noreturn"
		altNames = "??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAHABV01@@Z ??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z ??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 0B B9 00 23 00 E0 1B 68 0A 68 0A B9 00 22 00 E0 12 68 93 42 05 D1 82 68 8B 68 D3 1A 58 10 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_437_1 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 68
		refs = "0024 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 23 CD E9 00 33 03 68 0C 46 1B B1 1B 68 0B B1 1B 68 00 93 83 68 51 42 68 46 02 93 ?? ?? ?? ?? 00 23 C4 E9 00 33 00 9B 1B B1 1B 68 0B B1 1B 68 23 60 02 9B 20 46 A3 60 BD E8 1E 88 }
	condition:
		$1
}

rule file_17_439_1 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 68
		refs = "0024 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 23 CD E9 00 33 03 68 0C 46 1B B1 1B 68 0B B1 1B 68 00 93 83 68 51 42 68 46 02 93 ?? ?? ?? ?? 00 23 C4 E9 00 33 00 9B 1B B1 1B 68 0B B1 1B 68 23 60 02 9B 20 46 A3 60 BD E8 1E 88 }
	condition:
		$1
}

rule file_17_441_1 {
	meta:
		name = "??H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 68
		refs = "0024 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 23 CD E9 00 33 03 68 0C 46 1B B1 1B 68 0B B1 1B 68 00 93 83 68 68 46 11 46 02 93 ?? ?? ?? ?? 00 23 C4 E9 00 33 00 9B 1B B1 1B 68 0B B1 1B 68 23 60 02 9B 20 46 A3 60 BD E8 1E 88 }
	condition:
		$1
}

rule file_17_442_1 {
	meta:
		name = "??H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 68
		refs = "0024 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 23 CD E9 00 33 03 68 0C 46 1B B1 1B 68 0B B1 1B 68 00 93 83 68 68 46 11 46 02 93 ?? ?? ?? ?? 00 23 C4 E9 00 33 00 9B 1B B1 1B 68 0B B1 1B 68 23 60 02 9B 20 46 A3 60 BD E8 1E 88 }
	condition:
		$1
}

rule file_17_443_1 {
	meta:
		name = "??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 82
		refs = "0044 _invalid_parameter_noinfo_noreturn"
		altNames = "??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 AC B1 85 68 CD B1 03 68 DB B1 1A 68 CA B1 93 69 08 2B 01 D3 51 68 00 E0 11 1D 05 EB 44 05 A9 42 0D D8 53 69 01 EB 43 03 9D 42 00 D9 07 E0 83 68 03 EB 44 03 83 60 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_452_1 {
	meta:
		name = "??Z?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 22
		refs = "000c ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 49 42 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_453_1 {
	meta:
		name = "??Z?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 22
		refs = "000c ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 49 42 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_454_1 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MAAPAXI@Z"
		size = 72
		refs = "0012 free 0036 ??3@YAXPAXI@Z 0040 ??_7_Facet_base@std@@6B@ 0044 ??_7?$_Mpunct@G@std@@6B@"
		altNames = "??_G?$moneypunct@G$00@std@@MAAPAXI@Z ??_G?$moneypunct@G$0A@@std@@MAAPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0E 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? A8 69 ?? ?? ?? ?? 05 4B 14 F0 01 0F 2B 60 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_212_1 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MAAPAXI@Z"
		size = 72
		refs = "0012 free 0036 ??3@YAXPAXI@Z 0040 ??_7_Facet_base@std@@6B@ 0044 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0E 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? A8 69 ?? ?? ?? ?? 05 4B 14 F0 01 0F 2B 60 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_455_1 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MAAPAXI@Z"
		size = 72
		refs = "0012 free 0036 ??3@YAXPAXI@Z 0040 ??_7_Facet_base@std@@6B@ 0044 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0E 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? A8 69 ?? ?? ?? ?? 05 4B 14 F0 01 0F 2B 60 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_218_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MAAPAXI@Z"
		size = 72
		refs = "0012 free 0036 ??3@YAXPAXI@Z 0040 ??_7_Facet_base@std@@6B@ 0044 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0E 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? A8 69 ?? ?? ?? ?? 05 4B 14 F0 01 0F 2B 60 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_219_1 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MAAPAXI@Z"
		size = 72
		refs = "0012 free 0036 ??3@YAXPAXI@Z 0040 ??_7_Facet_base@std@@6B@ 0044 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0E 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? A8 69 ?? ?? ?? ?? 05 4B 14 F0 01 0F 2B 60 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_470_1 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MAAPAXI@Z"
		size = 72
		refs = "0012 free 0036 ??3@YAXPAXI@Z 0040 ??_7_Facet_base@std@@6B@ 0044 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0E 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? A8 69 ?? ?? ?? ?? 05 4B 14 F0 01 0F 2B 60 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_471_1 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MAAPAXI@Z"
		size = 72
		refs = "0012 free 0036 ??3@YAXPAXI@Z 0040 ??_7_Facet_base@std@@6B@ 0044 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0E 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 68 69 ?? ?? ?? ?? A8 69 ?? ?? ?? ?? 05 4B 14 F0 01 0F 2B 60 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_456_1 {
	meta:
		name = "??_G?$codecvt@GDU_Mbstatet@@@std@@MAAPAXI@Z"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z 0020 ??_7_Facet_base@std@@6B@"
		altNames = "??_G?$codecvt@_WDU_Mbstatet@@@std@@MAAPAXI@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 05 4B 04 46 11 F0 01 0F 23 60 02 D0 34 21 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_458_1 {
	meta:
		name = "??_G?$collate@G@std@@MAAPAXI@Z"
		size = 56
		refs = "0012 free 0024 ??3@YAXPAXI@Z 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$collate@G@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4B 05 46 E8 68 0C 46 2B 60 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 10 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_213_1 {
	meta:
		name = "??_G?$collate@D@std@@MAAPAXI@Z"
		size = 56
		refs = "0012 free 0024 ??3@YAXPAXI@Z 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$collate@D@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4B 05 46 E8 68 0C 46 2B 60 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 10 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_459_1 {
	meta:
		name = "??_G?$collate@_W@std@@MAAPAXI@Z"
		size = 56
		refs = "0012 free 0024 ??3@YAXPAXI@Z 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$collate@_W@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4B 05 46 E8 68 0C 46 2B 60 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 10 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_460_1 {
	meta:
		name = "??_G?$ctype@G@std@@MAAPAXI@Z"
		size = 64
		refs = "0016 free 002e ??3@YAXPAXI@Z 0038 ??_7_Facet_base@std@@6B@ 003c ??_7?$ctype@G@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4B 04 46 0D 46 23 60 23 69 13 B1 E0 68 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 05 4B 15 F0 01 0F 23 60 03 D0 44 21 20 46 ?? ?? ?? ?? 20 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_461_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAAPAXI@Z"
		size = 64
		refs = "0016 free 002e ??3@YAXPAXI@Z 0038 ??_7_Facet_base@std@@6B@ 003c ??_7?$ctype@_W@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4B 04 46 0D 46 23 60 23 69 13 B1 E0 68 ?? ?? ?? ?? 60 69 ?? ?? ?? ?? 05 4B 15 F0 01 0F 23 60 03 D0 44 21 20 46 ?? ?? ?? ?? 20 46 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_478_1 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z"
		size = 68
		refs = "0012 free 0030 ??3@YAXPAXI@Z 003c ??_7_Facet_base@std@@6B@ 0040 ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? E8 68 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 44 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_220_1 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z"
		size = 68
		refs = "0012 free 0030 ??3@YAXPAXI@Z 003c ??_7_Facet_base@std@@6B@ 0040 ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? E8 68 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 44 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_479_1 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z"
		size = 68
		refs = "0012 free 0030 ??3@YAXPAXI@Z 003c ??_7_Facet_base@std@@6B@ 0040 ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? E8 68 ?? ?? ?? ?? 28 69 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 44 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_480_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z"
		size = 56
		refs = "0012 free 0024 ??3@YAXPAXI@Z 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 0C 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_221_1 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z"
		size = 56
		refs = "0012 free 0024 ??3@YAXPAXI@Z 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 0C 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_481_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z"
		size = 56
		refs = "0012 free 0024 ??3@YAXPAXI@Z 0030 ??_7_Facet_base@std@@6B@ 0034 ??_7?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4B 05 46 A8 68 0C 46 2B 60 ?? ?? ?? ?? 06 4B 14 F0 01 0F 2B 60 03 D0 0C 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_493_1 {
	meta:
		name = "?_Adopt@_Iterator_base12@std@@QAAXPBU_Container_base12@2@@Z"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 09 B1 0B 68 03 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_499_1 {
	meta:
		name = "?_Assign_rv@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX$$QAV12@@Z"
		size = 68
		refs = "0020 memmove"
		altNames = "?_Assign_rv@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX$$QAV12@@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 46 A3 69 00 26 05 46 08 2B 08 D2 63 69 5B 1C 0A D0 28 1D 5A 00 21 1D ?? ?? ?? ?? 04 E0 2A 1D 01 D0 63 68 13 60 66 60 63 69 6B 61 A3 69 AB 61 07 23 C4 E9 05 63 A6 80 BD E8 78 88 }
	condition:
		$1
}

rule file_17_509_1 {
	meta:
		name = "?_Chassign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXIIG@Z"
		size = 66
		altNames = "?_Chassign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII_W@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 1C 46 01 2A 08 D1 82 69 08 2A 01 D3 42 68 00 E0 02 1D 22 F8 11 40 0E E0 83 69 08 2B 01 D3 43 68 00 E0 03 1D 03 EB 41 03 2A B1 03 EB 42 02 23 F8 02 4B 93 42 FB D1 BD E8 18 88 }
	condition:
		$1
}

rule file_17_517_1 {
	meta:
		name = "?_Compat@?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAXABV12@@Z"
		size = 40
		refs = "0022 _invalid_parameter_noinfo_noreturn"
		altNames = "?_Compat@?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAXABV12@@Z ?_Compat@?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAXABV12@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 0B B9 00 22 00 E0 1A 68 0B 68 0B B9 00 23 00 E0 1B 68 9A 42 01 D1 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_522_1 {
	meta:
		name = "?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXII@Z"
		size = 220
		refs = "005c ?_Xbad_alloc@std@@YAXXZ 0062 ??2@YAPAXI@Z 006a _invalid_parameter_noinfo_noreturn 009e memcpy 00aa ??3@YAXPAX@Z"
		altNames = "?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII@Z"
	strings:
		$1 = { 0F B4 2D E9 FF 4B 0D F1 28 0B 6F 46 6F F0 01 03 C7 E9 02 33 01 23 DE 07 4F F0 07 09 B6 1E 04 46 41 EA 09 05 B5 42 90 46 BA 63 79 63 3C 63 01 D9 0D 46 0D E0 A1 69 28 4B 48 08 A5 FB 03 32 B0 EB 52 0F 05 D9 33 1A 99 42 01 D8 45 18 00 E0 35 46 6A 1C 14 D0 6F F0 00 43 9A 42 01 D9 ?? ?? ?? ?? 50 00 ?? ?? ?? ?? 06 46 56 B9 ?? ?? ?? ?? 3C 6B D7 F8 38 80 D7 E9 00 56 4F F0 07 09 00 E0 00 26 B8 F1 00 0F 0D D0 A3 69 08 2B 01 D3 61 68 00 E0 21 1D B8 F1 00 0F 04 D0 4F EA 48 02 30 46 ?? ?? ?? ?? A3 69 08 2B 02 D3 60 68 ?? ?? ?? ?? 4F F0 00 02 C4 E9 05 29 23 1D 1A 80 00 D0 1E 60 A5 61 08 2D 00 D3 63 68 C4 F8 14 80 23 F8 18 20 BD E8 FF 0B 5D F8 14 FB FE DE AB AA AA AA }
	condition:
		$1
}

rule file_17_524_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXII@Z$0"
		size = 62
		refs = "001e ??2@YAPAXI@Z 002e _invalid_parameter_noinfo_noreturn 0032 ?_Xbad_alloc@std@@YAXXZ 003a $LN19"
		altNames = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII@Z$0"
	strings:
		$1 = { 10 B5 7B 6B 3B 60 5A 1C 40 F0 03 80 00 20 00 F0 0B B8 6F F0 00 43 9A 42 00 F2 0B 80 50 00 ?? ?? ?? ?? 00 28 00 F0 03 80 78 60 03 48 10 BD ?? ?? ?? ?? ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_533_1 {
	meta:
		name = "?_Deprecate@_Unchecked_iterators@?1???$copy@PA_WV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@PA_W0V32@@Z@SAXU?$integral_constant@_N$00@2@@Z"
		size = 16
		altNames = "?_Deprecate@_Unchecked_iterators@?1???$copy@PADV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@PAD0V32@@Z@SAXU?$integral_constant@_N$00@2@@Z ?_Deprecate@_Unchecked_iterators@?1???$copy@PA_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@PA_W0V32@@Z@SAXU?$integral_constant@_N$00@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_17_535_1 {
	meta:
		name = "?_Donarrow@?$ctype@G@std@@IBADGD@Z"
		size = 54
		refs = "0008 __security_push_cookie 001e _Wcrtomb 002e __security_pop_cookie"
		altNames = "?_Donarrow@?$ctype@_W@std@@IBAD_WD@Z ?do_narrow@?$ctype@G@std@@MBADGD@Z ?do_narrow@?$ctype@_W@std@@MBAD_WD@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 84 B0 00 23 CD E9 00 33 00 F1 18 03 14 46 02 A8 6A 46 ?? ?? ?? ?? 01 28 01 D1 9D F9 08 40 20 46 04 B0 ?? ?? ?? ?? BD E8 10 88 }
	condition:
		$1
}

rule file_17_537_1 {
	meta:
		name = "?_Dowiden@?$ctype@G@std@@IBAGD@Z"
		size = 58
		refs = "001e _Mbrtowc"
		altNames = "?_Dowiden@?$ctype@_W@std@@IBA_WD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 00 23 CD E9 04 33 00 F1 18 03 00 93 04 AB 09 A9 02 A8 01 22 ?? ?? ?? ?? 00 28 02 DA 4F F6 FF 70 01 E0 BD F8 08 00 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_17_539_1 {
	meta:
		name = "?_Empty@?$_Yarn@D@std@@QBA_NXZ"
		size = 20
		altNames = "?_Empty@?$_Yarn@_W@std@@QBA_NXZ ?isEmpty@DName@@QBAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 0B B9 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_17_542_1 {
	meta:
		name = "?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
		size = 30
		altNames = "?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 83 69 08 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 23 F8 11 20 BD E8 00 88 }
	condition:
		$1
}

rule file_17_550_1 {
	meta:
		name = "?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z"
		size = 992
		refs = "000a __security_push_cookie 0078 strcspn 0082 localeconv 009e ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 00a2 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 00bc _guard_check_icall 00e2 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@IG@Z 0116 ??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0150 ?grouping@?$numpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0180 _invalid_parameter_noinfo_noreturn 01ce ?insert@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IIG@Z 022a ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z 0392 ??3@YAXPAX@Z 03cc __security_pop_cookie 03d8 ??_C@_02OOPEBDOJ@pP?$AA@ 03dc ??_C@_02MDKMJEGG@eE?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 9C B0 6F 46 D7 F8 A8 40 D7 F8 B4 50 C7 E9 05 41 6F F0 01 03 D7 F8 B0 90 C7 E9 0A 33 45 B1 99 F9 00 30 2B 2B 01 D0 2D 2B 02 D1 4F F0 01 08 01 E0 4F F0 00 08 63 69 03 F4 40 53 B3 F5 40 5F 01 D0 E3 49 11 E0 08 F1 02 02 E0 49 AA 42 0C D8 19 F9 08 30 09 EB 08 00 30 2B 06 D1 90 F9 01 30 78 2B 01 D0 58 2B 00 D1 90 46 48 46 ?? ?? ?? ?? 2E 23 3B 82 B8 60 ?? ?? ?? ?? 03 68 17 F1 10 01 48 46 1B 78 3B 74 ?? ?? ?? ?? 06 46 20 46 17 F1 20 01 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 3C 60 D7 F8 24 A0 BA F1 00 0F 12 D0 DA F8 00 30 9C 68 20 46 ?? ?? ?? ?? 50 46 A0 47 82 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 50 46 01 21 A0 47 3C 68 17 F1 30 00 00 22 29 46 ?? ?? ?? ?? BB 6C 08 2B 02 D3 D7 F8 34 A0 01 E0 17 F1 34 0A 22 68 D4 6A 20 46 ?? ?? ?? ?? 38 68 49 46 05 EB 09 02 53 46 A0 47 78 69 17 F1 20 01 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 D7 F8 24 A0 BA F1 00 0F 11 D0 DA F8 00 30 9C 68 20 46 ?? ?? ?? ?? 50 46 A0 47 82 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 50 46 01 21 A0 47 17 F1 50 01 48 46 ?? ?? ?? ?? D9 F8 00 30 1C 69 20 46 ?? ?? ?? ?? 48 46 A0 47 82 46 AE 42 16 D0 D9 F8 00 30 DC 68 20 46 ?? ?? ?? ?? 48 46 A0 47 7B 6C 9E 42 01 D9 ?? ?? ?? ?? BB 6C 08 2B 01 D3 7B 6B 01 E0 17 F1 34 03 23 F8 16 00 00 E0 BE 68 BD 6E 78 6D 10 2D 28 BF 04 46 01 D2 17 F1 54 04 94 F9 00 30 7F 2B 1A D0 94 F9 00 20 00 2A 14 DD A6 EB 08 03 9A 42 10 D2 B6 1A 31 46 53 46 01 22 17 F1 30 00 ?? ?? ?? ?? 94 F9 01 30 00 2B C8 BF 64 1C 94 F9 00 30 7F 2B E6 D1 BD 6E 78 6D 79 69 D7 F8 44 E0 D1 E9 08 23 C7 F8 08 E0 00 2B 06 DB 00 DC 22 B1 72 45 02 D9 A2 EB 0E 04 00 E0 00 24 4B 69 03 F4 E0 73 40 2B 2E D0 B3 F5 80 7F 2E D0 D7 E9 28 32 C7 E9 00 32 64 B1 B7 F8 AC 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 F8 44 E0 BD 6E 78 6D D7 E9 00 32 BE 6C 79 6B 00 24 08 2E 28 BF 89 46 C7 E9 28 32 01 D2 17 F1 34 09 C2 46 C7 E9 00 32 B8 F1 00 0F 5E D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 4E E0 B3 F5 80 7F 33 D1 BE 6C 79 6B 08 2E 28 BF 89 46 01 D2 17 F1 34 09 D7 E9 28 32 C2 46 B8 F1 00 0F C7 E9 00 32 0E D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 11 E6 79 6B BD 6E 78 6D D7 E9 00 32 C7 E9 28 32 C7 E9 00 32 6C B1 B7 F8 AC 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 E9 11 E6 79 6B BD 6E 78 6D D7 E9 00 32 00 24 1E E0 BE 6C 79 6B 08 2E 28 BF 89 46 01 D2 17 F1 34 09 D7 E9 28 32 C2 46 B8 F1 00 0F C7 E9 00 32 0E D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 11 E6 D7 E9 00 32 78 6D BD 6E 79 6B C7 E9 28 32 F0 45 01 D9 ?? ?? ?? ?? 08 2E 01 D2 17 F1 34 01 01 EB 48 06 B9 68 C7 E9 02 32 B1 EB 08 08 0C D0 36 F8 02 1B 17 F1 08 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 BD 6E 78 6D D7 E9 02 32 D7 F8 14 E0 00 21 C7 E9 28 32 CE E9 08 11 C7 E9 02 32 5C B1 B7 F8 AC 10 17 F1 08 00 ?? ?? ?? ?? 64 1E F7 D1 BD 6E 78 6D D7 E9 02 32 BC 69 C4 E9 00 32 10 2D 01 D3 ?? ?? ?? ?? 0F 23 38 6D BB 66 00 23 7B 66 87 F8 54 30 ?? ?? ?? ?? 00 23 3B 65 BB 6C 08 2B 02 D3 78 6B ?? ?? ?? ?? 07 23 38 6B BB 64 00 23 7B 64 BB 86 ?? ?? ?? ?? 20 46 1C B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_557_1 {
	meta:
		name = "?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z"
		size = 992
		refs = "000a __security_push_cookie 0078 strcspn 0082 localeconv 009e ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 00a2 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 00bc _guard_check_icall 00e2 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@I_W@Z 0116 ??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0150 ?grouping@?$numpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0180 _invalid_parameter_noinfo_noreturn 01ce ?insert@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II_W@Z 022a ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z 0392 ??3@YAXPAX@Z 03cc __security_pop_cookie 03d8 ??_C@_02OOPEBDOJ@pP?$AA@ 03dc ??_C@_02MDKMJEGG@eE?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 9C B0 6F 46 D7 F8 A8 40 D7 F8 B4 50 C7 E9 05 41 6F F0 01 03 D7 F8 B0 90 C7 E9 0A 33 45 B1 99 F9 00 30 2B 2B 01 D0 2D 2B 02 D1 4F F0 01 08 01 E0 4F F0 00 08 63 69 03 F4 40 53 B3 F5 40 5F 01 D0 E3 49 11 E0 08 F1 02 02 E0 49 AA 42 0C D8 19 F9 08 30 09 EB 08 00 30 2B 06 D1 90 F9 01 30 78 2B 01 D0 58 2B 00 D1 90 46 48 46 ?? ?? ?? ?? 2E 23 3B 82 B8 60 ?? ?? ?? ?? 03 68 17 F1 10 01 48 46 1B 78 3B 74 ?? ?? ?? ?? 06 46 20 46 17 F1 20 01 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 3C 60 D7 F8 24 A0 BA F1 00 0F 12 D0 DA F8 00 30 9C 68 20 46 ?? ?? ?? ?? 50 46 A0 47 82 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 50 46 01 21 A0 47 3C 68 17 F1 30 00 00 22 29 46 ?? ?? ?? ?? BB 6C 08 2B 02 D3 D7 F8 34 A0 01 E0 17 F1 34 0A 22 68 D4 6A 20 46 ?? ?? ?? ?? 38 68 49 46 05 EB 09 02 53 46 A0 47 78 69 17 F1 20 01 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 D7 F8 24 A0 BA F1 00 0F 11 D0 DA F8 00 30 9C 68 20 46 ?? ?? ?? ?? 50 46 A0 47 82 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 50 46 01 21 A0 47 17 F1 50 01 48 46 ?? ?? ?? ?? D9 F8 00 30 1C 69 20 46 ?? ?? ?? ?? 48 46 A0 47 82 46 AE 42 16 D0 D9 F8 00 30 DC 68 20 46 ?? ?? ?? ?? 48 46 A0 47 7B 6C 9E 42 01 D9 ?? ?? ?? ?? BB 6C 08 2B 01 D3 7B 6B 01 E0 17 F1 34 03 23 F8 16 00 00 E0 BE 68 BD 6E 78 6D 10 2D 28 BF 04 46 01 D2 17 F1 54 04 94 F9 00 30 7F 2B 1A D0 94 F9 00 20 00 2A 14 DD A6 EB 08 03 9A 42 10 D2 B6 1A 31 46 53 46 01 22 17 F1 30 00 ?? ?? ?? ?? 94 F9 01 30 00 2B C8 BF 64 1C 94 F9 00 30 7F 2B E6 D1 BD 6E 78 6D 79 69 D7 F8 44 E0 D1 E9 08 23 C7 F8 08 E0 00 2B 06 DB 00 DC 22 B1 72 45 02 D9 A2 EB 0E 04 00 E0 00 24 4B 69 03 F4 E0 73 40 2B 2E D0 B3 F5 80 7F 2E D0 D7 E9 28 32 C7 E9 00 32 64 B1 B7 F8 AC 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 F8 44 E0 BD 6E 78 6D D7 E9 00 32 BE 6C 79 6B 00 24 08 2E 28 BF 89 46 C7 E9 28 32 01 D2 17 F1 34 09 C2 46 C7 E9 00 32 B8 F1 00 0F 5E D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 4E E0 B3 F5 80 7F 33 D1 BE 6C 79 6B 08 2E 28 BF 89 46 01 D2 17 F1 34 09 D7 E9 28 32 C2 46 B8 F1 00 0F C7 E9 00 32 0E D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 11 E6 79 6B BD 6E 78 6D D7 E9 00 32 C7 E9 28 32 C7 E9 00 32 6C B1 B7 F8 AC 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 E9 11 E6 79 6B BD 6E 78 6D D7 E9 00 32 00 24 1E E0 BE 6C 79 6B 08 2E 28 BF 89 46 01 D2 17 F1 34 09 D7 E9 28 32 C2 46 B8 F1 00 0F C7 E9 00 32 0E D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 11 E6 D7 E9 00 32 78 6D BD 6E 79 6B C7 E9 28 32 F0 45 01 D9 ?? ?? ?? ?? 08 2E 01 D2 17 F1 34 01 01 EB 48 06 B9 68 C7 E9 02 32 B1 EB 08 08 0C D0 36 F8 02 1B 17 F1 08 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 BD 6E 78 6D D7 E9 02 32 D7 F8 14 E0 00 21 C7 E9 28 32 CE E9 08 11 C7 E9 02 32 5C B1 B7 F8 AC 10 17 F1 08 00 ?? ?? ?? ?? 64 1E F7 D1 BD 6E 78 6D D7 E9 02 32 BC 69 C4 E9 00 32 10 2D 01 D3 ?? ?? ?? ?? 0F 23 38 6D BB 66 00 23 7B 66 87 F8 54 30 ?? ?? ?? ?? 00 23 3B 65 BB 6C 08 2B 02 D3 78 6B ?? ?? ?? ?? 07 23 38 6B BB 64 00 23 7B 64 BB 86 ?? ?? ?? ?? 20 46 1C B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_591_1 {
	meta:
		name = "?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 140
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0056 _Getcvt 0064 memcpy 0078 ??1_Locinfo@std@@QAA@XZ 0084 ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 0088 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 9E B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 6D B3 2B 68 5B BB 34 20 ?? ?? ?? ?? 04 46 3C 60 E4 B1 D8 F8 04 30 0B B9 14 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 40 00 ?? ?? ?? ?? 0E 4B 17 F1 10 00 01 26 C4 E9 00 39 ?? ?? ?? ?? 17 F1 10 01 2C 22 04 F1 08 00 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 40 00 ?? ?? ?? ?? 02 20 1E B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_593_1 {
	meta:
		name = "?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 140
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0056 _Getcvt 0064 memcpy 0078 ??1_Locinfo@std@@QAA@XZ 0084 ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 0088 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 9E B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 6D B3 2B 68 5B BB 34 20 ?? ?? ?? ?? 04 46 3C 60 E4 B1 D8 F8 04 30 0B B9 14 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 40 00 ?? ?? ?? ?? 0E 4B 17 F1 10 00 01 26 C4 E9 00 39 ?? ?? ?? ?? 17 F1 10 01 2C 22 04 F1 08 00 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 40 00 ?? ?? ?? ?? 02 20 1E B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_595_1 {
	meta:
		name = "?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 196
		refs = "0008 __security_push_cookie 0032 ??2@YAPAXI@Z 0042 ?name@locale@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 005a ??0_Locinfo@std@@QAA@PBD@Z 006a _Getcoll 008a ??1_Locinfo@std@@QAA@XZ 009c ??3@YAXPAX@Z 00b6 __security_pop_cookie 00c0 ??_7?$collate@G@std@@6B@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? 9B B0 6F 46 6F F0 01 03 06 46 4F F0 00 09 C7 E9 04 33 C7 F8 00 90 88 46 4C 46 00 2E 43 D0 33 68 00 2B 40 D1 10 20 ?? ?? ?? ?? 05 46 BD 60 ED B1 17 F1 50 01 40 46 ?? ?? ?? ?? 01 23 3B 60 83 69 10 2B 01 D3 41 68 00 E0 01 1D 17 F1 18 00 ?? ?? ?? ?? 18 4B 03 24 17 F1 08 00 C5 E9 00 39 ?? ?? ?? ?? BB 68 AB 60 FB 68 EB 60 00 E0 00 25 35 60 14 F0 02 0F 05 D0 17 F1 18 00 24 F0 02 04 ?? ?? ?? ?? 14 F0 01 0F 0E D0 BB 6E 10 2B 02 D3 78 6D ?? ?? ?? ?? 0F 23 38 6D BB 66 00 23 7B 66 87 F8 54 30 ?? ?? ?? ?? 01 20 1B B0 ?? ?? ?? ?? BD E8 F0 8B FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_266_1 {
	meta:
		name = "?_Getcat@?$collate@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 196
		refs = "0008 __security_push_cookie 0032 ??2@YAPAXI@Z 0042 ?name@locale@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 005a ??0_Locinfo@std@@QAA@PBD@Z 006a _Getcoll 008a ??1_Locinfo@std@@QAA@XZ 009c ??3@YAXPAX@Z 00b6 __security_pop_cookie 00c0 ??_7?$collate@D@std@@6B@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? 9B B0 6F 46 6F F0 01 03 06 46 4F F0 00 09 C7 E9 04 33 C7 F8 00 90 88 46 4C 46 00 2E 43 D0 33 68 00 2B 40 D1 10 20 ?? ?? ?? ?? 05 46 BD 60 ED B1 17 F1 50 01 40 46 ?? ?? ?? ?? 01 23 3B 60 83 69 10 2B 01 D3 41 68 00 E0 01 1D 17 F1 18 00 ?? ?? ?? ?? 18 4B 03 24 17 F1 08 00 C5 E9 00 39 ?? ?? ?? ?? BB 68 AB 60 FB 68 EB 60 00 E0 00 25 35 60 14 F0 02 0F 05 D0 17 F1 18 00 24 F0 02 04 ?? ?? ?? ?? 14 F0 01 0F 0E D0 BB 6E 10 2B 02 D3 78 6D ?? ?? ?? ?? 0F 23 38 6D BB 66 00 23 7B 66 87 F8 54 30 ?? ?? ?? ?? 01 20 1B B0 ?? ?? ?? ?? BD E8 F0 8B FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_598_1 {
	meta:
		name = "?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 196
		refs = "0008 __security_push_cookie 0032 ??2@YAPAXI@Z 0042 ?name@locale@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 005a ??0_Locinfo@std@@QAA@PBD@Z 006a _Getcoll 008a ??1_Locinfo@std@@QAA@XZ 009c ??3@YAXPAX@Z 00b6 __security_pop_cookie 00c0 ??_7?$collate@_W@std@@6B@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? 9B B0 6F 46 6F F0 01 03 06 46 4F F0 00 09 C7 E9 04 33 C7 F8 00 90 88 46 4C 46 00 2E 43 D0 33 68 00 2B 40 D1 10 20 ?? ?? ?? ?? 05 46 BD 60 ED B1 17 F1 50 01 40 46 ?? ?? ?? ?? 01 23 3B 60 83 69 10 2B 01 D3 41 68 00 E0 01 1D 17 F1 18 00 ?? ?? ?? ?? 18 4B 03 24 17 F1 08 00 C5 E9 00 39 ?? ?? ?? ?? BB 68 AB 60 FB 68 EB 60 00 E0 00 25 35 60 14 F0 02 0F 05 D0 17 F1 18 00 24 F0 02 04 ?? ?? ?? ?? 14 F0 01 0F 0E D0 BB 6E 10 2B 02 D3 78 6D ?? ?? ?? ?? 0F 23 38 6D BB 66 00 23 7B 66 87 F8 54 30 ?? ?? ?? ?? 01 20 1B B0 ?? ?? ?? ?? BD E8 F0 8B FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_597_1 {
	meta:
		name = "__unwindfunclet$?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
		size = 32
		refs = "001a ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ"
		altNames = "__unwindfunclet$?_Getcat@?$collate@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 08 80 3B 68 23 F0 01 03 3B 60 17 F1 50 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_601_1 {
	meta:
		name = "?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 160
		refs = "0024 ??2@YAPAXI@Z 0042 ??0_Locinfo@std@@QAA@PBD@Z 0054 _Getctype 0068 _Getcvt 0076 memcpy 008c ??1_Locinfo@std@@QAA@XZ 0098 ??_7?$ctype@G@std@@6B@ 009c ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B A2 B0 6F 46 6F F0 01 03 00 25 C7 E9 02 33 A9 46 0C 46 80 46 C0 B3 03 68 B3 BB 44 20 ?? ?? ?? ?? 06 46 3E 60 36 B3 63 68 0B B9 1A 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 50 00 ?? ?? ?? ?? 14 4B 17 F1 10 00 4F F0 01 09 C6 E9 00 35 ?? ?? ?? ?? 17 F1 10 04 0F CC 06 F1 08 05 0F C5 17 F1 20 00 ?? ?? ?? ?? 17 F1 20 01 2C 22 06 F1 18 00 ?? ?? ?? ?? 00 E0 00 26 C8 F8 00 60 19 F0 01 0F 03 D0 17 F1 50 00 ?? ?? ?? ?? 02 20 22 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_603_1 {
	meta:
		name = "?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 160
		refs = "0024 ??2@YAPAXI@Z 0042 ??0_Locinfo@std@@QAA@PBD@Z 0054 _Getctype 0068 _Getcvt 0076 memcpy 008c ??1_Locinfo@std@@QAA@XZ 0098 ??_7?$ctype@_W@std@@6B@ 009c ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B A2 B0 6F 46 6F F0 01 03 00 25 C7 E9 02 33 A9 46 0C 46 80 46 C0 B3 03 68 B3 BB 44 20 ?? ?? ?? ?? 06 46 3E 60 36 B3 63 68 0B B9 1A 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 50 00 ?? ?? ?? ?? 14 4B 17 F1 10 00 4F F0 01 09 C6 E9 00 35 ?? ?? ?? ?? 17 F1 10 04 0F CC 06 F1 08 05 0F C5 17 F1 20 00 ?? ?? ?? ?? 17 F1 20 01 2C 22 06 F1 18 00 ?? ?? ?? ?? 00 E0 00 26 C8 F8 00 60 19 F0 01 0F 03 D0 17 F1 50 00 ?? ?? ?? ?? 02 20 22 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_605_1 {
	meta:
		name = "?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$messages@G@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 06 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_271_1 {
	meta:
		name = "?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$messages@D@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 06 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_607_1 {
	meta:
		name = "?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$messages@_W@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 06 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_609_1 {
	meta:
		name = "?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_273_1 {
	meta:
		name = "?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_611_1 {
	meta:
		name = "?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_275_1 {
	meta:
		name = "?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_613_1 {
	meta:
		name = "?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_615_1 {
	meta:
		name = "?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 120
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0062 ??1_Locinfo@std@@QAA@XZ 0070 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 15 B3 2B 68 03 BB 08 20 ?? ?? ?? ?? 04 46 3C 60 8C B1 D8 F8 04 30 0B B9 0F 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 09 4B 01 26 C4 E9 00 39 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_617_1 {
	meta:
		name = "?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 152
		refs = "002a ??2@YAPAXI@Z 004e ??0_Locinfo@std@@QAA@PBD@Z 0068 ?_Init@?$_Mpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 0080 ??1_Locinfo@std@@QAA@XZ 008c ??_7?$moneypunct@G$00@std@@6B@ 0090 ??_7?$_Mpunct@G@std@@6B@ 0094 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 91 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 7D B3 2B 68 6B BB 58 20 ?? ?? ?? ?? 04 46 7C 60 4F F0 01 0A E4 B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 0C 4B 01 22 20 46 23 60 84 F8 28 A0 ?? ?? ?? ?? 07 4B 23 60 00 E0 00 24 2C 60 16 EA 0A 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 11 B0 BD E8 F0 8F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_277_1 {
	meta:
		name = "?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 152
		refs = "002a ??2@YAPAXI@Z 004e ??0_Locinfo@std@@QAA@PBD@Z 0068 ?_Init@?$_Mpunct@D@std@@IAAXABV_Locinfo@2@_N@Z 0080 ??1_Locinfo@std@@QAA@XZ 008c ??_7?$moneypunct@D$00@std@@6B@ 0090 ??_7?$_Mpunct@D@std@@6B@ 0094 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 91 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 7D B3 2B 68 6B BB 58 20 ?? ?? ?? ?? 04 46 7C 60 4F F0 01 0A E4 B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 0C 4B 01 22 20 46 23 60 84 F8 28 A0 ?? ?? ?? ?? 07 4B 23 60 00 E0 00 24 2C 60 16 EA 0A 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 11 B0 BD E8 F0 8F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_625_1 {
	meta:
		name = "?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 152
		refs = "002a ??2@YAPAXI@Z 004e ??0_Locinfo@std@@QAA@PBD@Z 0068 ?_Init@?$_Mpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 0080 ??1_Locinfo@std@@QAA@XZ 008c ??_7?$moneypunct@_W$00@std@@6B@ 0090 ??_7?$_Mpunct@_W@std@@6B@ 0094 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 91 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 7D B3 2B 68 6B BB 58 20 ?? ?? ?? ?? 04 46 7C 60 4F F0 01 0A E4 B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 0C 4B 01 22 20 46 23 60 84 F8 28 A0 ?? ?? ?? ?? 07 4B 23 60 00 E0 00 24 2C 60 16 EA 0A 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 11 B0 BD E8 F0 8F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_621_1 {
	meta:
		name = "?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 148
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 0064 ?_Init@?$_Mpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 007c ??1_Locinfo@std@@QAA@XZ 0088 ??_7?$moneypunct@G$0A@@std@@6B@ 008c ??_7?$_Mpunct@G@std@@6B@ 0090 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 6D B3 2B 68 5B BB 58 20 ?? ?? ?? ?? 04 46 7C 60 E4 B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 0C 4B 01 22 20 46 23 60 84 F8 28 90 ?? ?? ?? ?? 07 4B 23 60 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_281_1 {
	meta:
		name = "?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 148
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 0064 ?_Init@?$_Mpunct@D@std@@IAAXABV_Locinfo@2@_N@Z 007c ??1_Locinfo@std@@QAA@XZ 0088 ??_7?$moneypunct@D$0A@@std@@6B@ 008c ??_7?$_Mpunct@D@std@@6B@ 0090 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 6D B3 2B 68 5B BB 58 20 ?? ?? ?? ?? 04 46 7C 60 E4 B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 0C 4B 01 22 20 46 23 60 84 F8 28 90 ?? ?? ?? ?? 07 4B 23 60 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_629_1 {
	meta:
		name = "?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 148
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 0064 ?_Init@?$_Mpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 007c ??1_Locinfo@std@@QAA@XZ 0088 ??_7?$moneypunct@_W$0A@@std@@6B@ 008c ??_7?$_Mpunct@_W@std@@6B@ 0090 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 6D B3 2B 68 5B BB 58 20 ?? ?? ?? ?? 04 46 7C 60 E4 B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 0C 4B 01 22 20 46 23 60 84 F8 28 90 ?? ?? ?? ?? 07 4B 23 60 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 03 20 12 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_649_1 {
	meta:
		name = "?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 136
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 005e ?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0072 ??1_Locinfo@std@@QAA@XZ 0080 ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0084 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 45 B3 2B 68 33 BB 44 20 ?? ?? ?? ?? 04 46 7C 60 BC B1 D8 F8 04 30 0B B9 12 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 09 4B 20 46 23 60 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 05 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_285_1 {
	meta:
		name = "?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 136
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 005e ?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0072 ??1_Locinfo@std@@QAA@XZ 0080 ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0084 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 45 B3 2B 68 33 BB 44 20 ?? ?? ?? ?? 04 46 7C 60 BC B1 D8 F8 04 30 0B B9 12 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 09 4B 20 46 23 60 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 05 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_653_1 {
	meta:
		name = "?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 136
		refs = "002a ??2@YAPAXI@Z 004a ??0_Locinfo@std@@QAA@PBD@Z 005e ?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0072 ??1_Locinfo@std@@QAA@XZ 0080 ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0084 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 6F F0 01 03 05 46 4F F0 00 09 C7 E9 02 33 C7 F8 00 90 88 46 4E 46 45 B3 2B 68 33 BB 44 20 ?? ?? ?? ?? 04 46 7C 60 BC B1 D8 F8 04 30 0B B9 12 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 01 46 01 26 3E 60 C4 F8 04 90 09 4B 20 46 23 60 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 05 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_657_1 {
	meta:
		name = "?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 144
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0058 ?_W_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 0066 free 007a ??1_Locinfo@std@@QAA@XZ 0088 ??_7?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 008c ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 75 B3 2B 68 63 BB 0C 20 ?? ?? ?? ?? 04 46 3C 60 EC B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 0F 4B 01 26 C4 E9 00 39 39 46 C4 F8 08 90 ?? ?? ?? ?? 03 68 A3 60 C0 F8 00 90 38 68 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 05 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_289_1 {
	meta:
		name = "?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 144
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0058 ?_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 0066 free 007a ??1_Locinfo@std@@QAA@XZ 0088 ??_7?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 008c ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 75 B3 2B 68 63 BB 0C 20 ?? ?? ?? ?? 04 46 3C 60 EC B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 0F 4B 01 26 C4 E9 00 39 39 46 C4 F8 08 90 ?? ?? ?? ?? 03 68 A3 60 C0 F8 00 90 38 68 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 05 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_659_1 {
	meta:
		name = "?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 144
		refs = "0026 ??2@YAPAXI@Z 0046 ??0_Locinfo@std@@QAA@PBD@Z 0058 ?_W_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 0066 free 007a ??1_Locinfo@std@@QAA@XZ 0088 ??_7?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 008c ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 92 B0 6F 46 05 46 6F F0 01 03 4F F0 00 09 C7 E9 02 33 4E 46 88 46 75 B3 2B 68 63 BB 0C 20 ?? ?? ?? ?? 04 46 3C 60 EC B1 D8 F8 04 30 0B B9 15 49 03 E0 99 69 09 B9 03 F1 1C 01 17 F1 10 00 ?? ?? ?? ?? 0F 4B 01 26 C4 E9 00 39 39 46 C4 F8 08 90 ?? ?? ?? ?? 03 68 A3 60 C0 F8 00 90 38 68 ?? ?? ?? ?? 00 E0 00 24 2C 60 16 F0 01 0F 03 D0 17 F1 10 00 ?? ?? ?? ?? 05 20 12 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_661_1 {
	meta:
		name = "?_Getcoll@_Locinfo@std@@QBA?AU_Collvec@@XZ"
		size = 30
		refs = "000c _Getcoll"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 68 46 0C 46 ?? ?? ?? ?? 00 9B 20 46 23 60 01 9B 63 60 BD E8 1E 88 }
	condition:
		$1
}

rule file_17_662_1 {
	meta:
		name = "?_Getcont@_Iterator_base12@std@@QBAPBU_Container_base12@2@XZ"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 0B B9 00 20 00 E0 18 68 BD E8 00 88 }
	condition:
		$1
}

rule file_17_666_1 {
	meta:
		name = "?_Getdays@_Locinfo@std@@QBAPBDXZ"
		size = 104
		refs = "000a _Getdays 001a free 0038 malloc 0044 memcpy 0064 ??_C@_0FG@EOHGAEB@?3Sun?3Sunday?3Mon?3Monday?3Tue?3Tuesd@"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 ?? ?? ?? ?? 05 46 ED B1 60 68 A8 42 17 D0 08 B1 ?? ?? ?? ?? 00 23 63 60 95 F9 00 30 2A 46 02 E0 52 1C 92 F9 00 30 00 2B FA D1 56 1B 70 1C ?? ?? ?? ?? 60 60 18 B1 72 1C 29 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 63 68 23 B1 18 46 18 B9 04 F1 08 00 00 E0 01 48 BD E8 78 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_669_1 {
	meta:
		name = "?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z"
		size = 2028
		refs = "0008 __security_push_cookie 003c ?_Getffldx@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 004a ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0068 _guard_check_icall 008a ?grouping@?$numpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00a2 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 00f2 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 0154 ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ 01ca ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 02d0 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 030a _invalid_parameter_noinfo_noreturn 0312 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 0396 ??3@YAXPAX@Z 0490 localeconv 07da __security_pop_cookie 07e4 ?_Src@?1??_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1AAVios_base@3@PAH@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A8 B0 6F 46 82 B0 D7 F8 C8 50 99 46 6F F0 01 03 C7 E9 0E 33 6C 69 D7 F8 CC 30 16 46 04 F4 40 54 B4 F5 40 5F 39 61 7B 62 06 D1 01 93 4B 46 00 95 ?? ?? ?? ?? 03 46 C8 E3 17 F1 30 01 28 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 B8 61 D7 F8 34 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 17 F1 60 01 50 46 ?? ?? ?? ?? 00 23 D7 F8 10 A0 17 F1 28 01 28 46 FB 61 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 FD 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D8 F8 00 20 DF F8 10 57 D4 6A 20 46 ?? ?? ?? ?? 40 46 29 46 05 F1 0F 02 17 F1 80 03 A0 47 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 2B 21 2D 24 00 2B D9 F8 00 30 01 D1 13 B3 00 E0 03 BB 33 79 1B B9 30 46 ?? ?? ?? ?? 2B 21 F2 88 B7 F8 96 30 9A 42 04 D1 3C 69 21 70 04 F1 01 0A 0D E0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 94 30 9A 42 06 D1 3B 69 1C 70 03 F1 01 0A 30 46 ?? ?? ?? ?? 30 23 C7 F8 28 A0 0A F8 01 3B 7B 6A 00 22 7A 60 1B 68 90 46 7A 61 DF F8 78 26 00 25 3D 60 93 42 03 D1 4F F4 40 72 BA 60 01 E0 24 23 BB 60 BB 6F 10 2B 01 D3 7B 6E 01 E0 17 F1 64 03 3B 62 93 F9 00 30 7F 2B 00 F0 09 81 00 2B 40 F3 06 81 7B 6F 13 B9 4F F0 00 08 08 E0 BD 69 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 80 46 17 F1 40 00 00 22 01 21 ?? ?? ?? ?? 00 25 17 F1 80 04 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 03 D1 00 2B 00 F0 90 80 02 E0 00 2B 40 F0 8C 80 33 79 13 B9 30 46 ?? ?? ?? ?? F1 88 B7 F8 80 30 17 F1 80 02 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 13 1B 5B 10 0A 2B 2D D2 01 22 B9 68 7A 60 7A 69 91 42 06 DC 3A 68 52 1C 3A 60 6B B1 01 23 FB 60 0A E0 03 B9 42 B1 DF F8 98 15 52 1C 7A 61 5B 5C 8A F8 00 30 0A F1 01 0A 7B 6D 9D 42 53 D8 B9 6D 7A 6C 10 29 28 BF 13 46 01 D2 17 F1 44 03 5B 57 7F 2B 44 D0 10 29 01 D2 17 F1 44 02 53 5D 5B 1C 53 55 3C E0 7C 6D A5 42 43 D8 B9 6D 78 6C 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 F3 B3 B8 F1 00 0F 3B D0 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 15 41 78 6C F3 88 43 45 30 D1 C4 F1 FF 33 01 2B 23 D9 64 1C 21 46 00 22 17 F1 40 00 ?? ?? ?? ?? 90 B1 BB 6D 10 2B 01 D3 7A 6C 01 E0 17 F1 44 02 7B 6D 00 21 99 54 BB 6D 10 2B 01 D3 7B 6C 01 E0 17 F1 44 03 7C 65 19 55 6D 1C 17 F1 80 04 30 46 ?? ?? ?? ?? 64 E7 ?? ?? ?? ?? 17 F1 40 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 15 41 78 6C 6D B1 A5 42 01 D9 ?? ?? ?? ?? 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 00 2B 28 DD 6D 1C D7 F8 20 E0 35 B3 9E F9 00 20 7F 2A 22 D0 6D 1E 0A D0 A5 42 1A D8 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 9A 42 13 D1 4D B9 10 29 28 BF 03 46 01 D2 17 F1 44 03 93 F9 00 30 9A 42 08 DB 9E F9 01 30 00 2B DE DD 0E F1 01 0E DB E7 ?? ?? ?? ?? 01 23 FB 61 10 29 01 D3 ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? D7 F8 14 80 45 E0 17 F1 80 04 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 93 B3 00 E0 83 BB 33 79 13 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 F0 88 17 F1 80 01 32 B1 13 46 83 42 03 D0 89 1C 0B 88 00 2B F9 D1 0B 1B 5B 10 0A 2B 1C D2 BA 68 42 45 05 DC 6D 1C 3D 60 73 B1 01 23 FB 60 0B E0 13 B9 B8 F1 00 0F 07 D0 F0 4A 08 F1 01 08 9B 5C 8A F8 00 30 0A F1 01 0A 01 22 30 46 7A 60 ?? ?? ?? ?? BB E7 B7 F8 80 20 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? B7 F8 80 20 33 68 00 2B D9 F8 00 30 01 D1 F3 B1 00 E0 E3 B9 33 79 13 B9 30 46 ?? ?? ?? ?? BB 69 F5 88 1B 68 DC 68 20 46 ?? ?? ?? ?? B8 69 A0 47 85 42 0A D1 ?? ?? ?? ?? 03 68 30 46 1B 78 8A F8 00 30 0A F1 01 0A ?? ?? ?? ?? B7 F8 80 20 7B 6A CE 49 1B 68 8B 42 37 D0 B8 F1 00 0F 34 D1 3D 68 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? B7 F8 80 20 33 68 00 2B D9 F8 00 30 01 D1 A3 B1 00 E0 93 B9 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 F3 88 93 42 08 D1 6D 1E 01 22 30 46 7A 60 ?? ?? ?? ?? B7 F8 80 20 D5 E7 3D 60 00 2D 06 DA 30 23 6D 1C 8A F8 00 30 0A F1 01 0A 3D 60 BD 68 17 F1 80 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? B7 F8 80 20 33 68 00 2B D9 F8 00 30 01 D1 63 B3 00 E0 53 BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 F1 88 17 F1 80 03 03 E0 8A 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1B 5B 10 0A 2B 15 D2 A8 45 08 DA 97 4A 08 F1 01 08 9B 5C 8A F8 00 30 0A F1 01 0A 02 E0 0B B1 01 23 FB 60 01 22 30 46 7A 60 ?? ?? ?? ?? B7 F8 80 20 BD E7 FB 68 3D 68 FB B1 D7 F8 28 80 AA F1 01 04 44 45 15 D0 ?? ?? ?? ?? 03 68 94 F9 00 20 93 F9 00 30 9A 42 03 D0 39 2A 05 D1 30 23 23 70 64 1E 44 45 EF D1 02 E0 23 78 5B 1C 23 70 44 45 03 D1 31 23 6D 1C 3D 60 23 70 D7 F8 04 80 B8 F1 00 0F 00 F0 D1 80 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 03 D1 00 2B 00 F0 BE 80 02 E0 00 2B 40 F0 BA 80 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 9A 30 9A 42 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 98 30 9A 42 40 F0 A5 80 65 23 8A F8 00 30 30 46 0A F1 01 0A ?? ?? ?? ?? 33 79 00 25 4F F0 00 08 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 FB B1 00 E0 EB B9 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 96 30 9A 42 08 BF 2B 23 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 94 30 9A 42 07 D1 2D 23 8A F8 00 30 0A F1 01 0A 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 73 B1 00 E0 63 B9 33 79 13 B9 30 46 ?? ?? ?? ?? F3 88 B7 F8 80 20 93 42 04 D1 4F F0 01 08 DC E7 B7 F8 80 20 B8 F1 00 0F 04 D0 30 23 8A F8 00 30 0A F1 01 0A 17 F1 80 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? B7 F8 80 20 33 68 00 2B D9 F8 00 30 01 D1 3B B3 00 E0 2B BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 F1 88 17 F1 80 03 03 E0 8A 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1B 5B 10 0A 2B 10 D2 08 2D 06 DA 17 4A 6D 1C 9B 5C 8A F8 00 30 0A F1 01 0A 30 46 4F F0 01 08 ?? ?? ?? ?? B7 F8 80 20 C2 E7 FB 69 13 B9 B8 F1 00 0F 01 D1 3B 69 9A 46 00 23 8A F8 00 30 BB 6F 10 2B 02 D3 78 6E ?? ?? ?? ?? 0F 23 38 6E BB 67 00 23 7B 67 87 F8 64 30 ?? ?? ?? ?? 3B 68 18 46 2A B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_676_1 {
	meta:
		name = "?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z"
		size = 2028
		refs = "0008 __security_push_cookie 003c ?_Getffldx@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 004a ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 004e ??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0068 _guard_check_icall 008a ?grouping@?$numpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00a2 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 00f2 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 0154 ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ 01ca ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 02d0 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 030a _invalid_parameter_noinfo_noreturn 0312 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 0396 ??3@YAXPAX@Z 0490 localeconv 07da __security_pop_cookie 07e4 ?_Src@?1??_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1AAVios_base@3@PAH@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A8 B0 6F 46 82 B0 D7 F8 C8 50 99 46 6F F0 01 03 C7 E9 0E 33 6C 69 D7 F8 CC 30 16 46 04 F4 40 54 B4 F5 40 5F 39 61 7B 62 06 D1 01 93 4B 46 00 95 ?? ?? ?? ?? 03 46 C8 E3 17 F1 30 01 28 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 B8 61 D7 F8 34 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 17 F1 60 01 50 46 ?? ?? ?? ?? 00 23 D7 F8 10 A0 17 F1 28 01 28 46 FB 61 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 FD 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D8 F8 00 20 DF F8 10 57 D4 6A 20 46 ?? ?? ?? ?? 40 46 29 46 05 F1 0F 02 17 F1 80 03 A0 47 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 2B 21 2D 24 00 2B D9 F8 00 30 01 D1 13 B3 00 E0 03 BB 33 79 1B B9 30 46 ?? ?? ?? ?? 2B 21 F2 88 B7 F8 96 30 9A 42 04 D1 3C 69 21 70 04 F1 01 0A 0D E0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 94 30 9A 42 06 D1 3B 69 1C 70 03 F1 01 0A 30 46 ?? ?? ?? ?? 30 23 C7 F8 28 A0 0A F8 01 3B 7B 6A 00 22 7A 60 1B 68 90 46 7A 61 DF F8 78 26 00 25 3D 60 93 42 03 D1 4F F4 40 72 BA 60 01 E0 24 23 BB 60 BB 6F 10 2B 01 D3 7B 6E 01 E0 17 F1 64 03 3B 62 93 F9 00 30 7F 2B 00 F0 09 81 00 2B 40 F3 06 81 7B 6F 13 B9 4F F0 00 08 08 E0 BD 69 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 80 46 17 F1 40 00 00 22 01 21 ?? ?? ?? ?? 00 25 17 F1 80 04 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 03 D1 00 2B 00 F0 90 80 02 E0 00 2B 40 F0 8C 80 33 79 13 B9 30 46 ?? ?? ?? ?? F1 88 B7 F8 80 30 17 F1 80 02 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 13 1B 5B 10 0A 2B 2D D2 01 22 B9 68 7A 60 7A 69 91 42 06 DC 3A 68 52 1C 3A 60 6B B1 01 23 FB 60 0A E0 03 B9 42 B1 DF F8 98 15 52 1C 7A 61 5B 5C 8A F8 00 30 0A F1 01 0A 7B 6D 9D 42 53 D8 B9 6D 7A 6C 10 29 28 BF 13 46 01 D2 17 F1 44 03 5B 57 7F 2B 44 D0 10 29 01 D2 17 F1 44 02 53 5D 5B 1C 53 55 3C E0 7C 6D A5 42 43 D8 B9 6D 78 6C 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 F3 B3 B8 F1 00 0F 3B D0 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 15 41 78 6C F3 88 43 45 30 D1 C4 F1 FF 33 01 2B 23 D9 64 1C 21 46 00 22 17 F1 40 00 ?? ?? ?? ?? 90 B1 BB 6D 10 2B 01 D3 7A 6C 01 E0 17 F1 44 02 7B 6D 00 21 99 54 BB 6D 10 2B 01 D3 7B 6C 01 E0 17 F1 44 03 7C 65 19 55 6D 1C 17 F1 80 04 30 46 ?? ?? ?? ?? 64 E7 ?? ?? ?? ?? 17 F1 40 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 15 41 78 6C 6D B1 A5 42 01 D9 ?? ?? ?? ?? 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 00 2B 28 DD 6D 1C D7 F8 20 E0 35 B3 9E F9 00 20 7F 2A 22 D0 6D 1E 0A D0 A5 42 1A D8 10 29 28 BF 03 46 01 D2 17 F1 44 03 5B 57 9A 42 13 D1 4D B9 10 29 28 BF 03 46 01 D2 17 F1 44 03 93 F9 00 30 9A 42 08 DB 9E F9 01 30 00 2B DE DD 0E F1 01 0E DB E7 ?? ?? ?? ?? 01 23 FB 61 10 29 01 D3 ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? D7 F8 14 80 45 E0 17 F1 80 04 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 93 B3 00 E0 83 BB 33 79 13 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 F0 88 17 F1 80 01 32 B1 13 46 83 42 03 D0 89 1C 0B 88 00 2B F9 D1 0B 1B 5B 10 0A 2B 1C D2 BA 68 42 45 05 DC 6D 1C 3D 60 73 B1 01 23 FB 60 0B E0 13 B9 B8 F1 00 0F 07 D0 F0 4A 08 F1 01 08 9B 5C 8A F8 00 30 0A F1 01 0A 01 22 30 46 7A 60 ?? ?? ?? ?? BB E7 B7 F8 80 20 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? B7 F8 80 20 33 68 00 2B D9 F8 00 30 01 D1 F3 B1 00 E0 E3 B9 33 79 13 B9 30 46 ?? ?? ?? ?? BB 69 F5 88 1B 68 DC 68 20 46 ?? ?? ?? ?? B8 69 A0 47 85 42 0A D1 ?? ?? ?? ?? 03 68 30 46 1B 78 8A F8 00 30 0A F1 01 0A ?? ?? ?? ?? B7 F8 80 20 7B 6A CE 49 1B 68 8B 42 37 D0 B8 F1 00 0F 34 D1 3D 68 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? B7 F8 80 20 33 68 00 2B D9 F8 00 30 01 D1 A3 B1 00 E0 93 B9 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 F3 88 93 42 08 D1 6D 1E 01 22 30 46 7A 60 ?? ?? ?? ?? B7 F8 80 20 D5 E7 3D 60 00 2D 06 DA 30 23 6D 1C 8A F8 00 30 0A F1 01 0A 3D 60 BD 68 17 F1 80 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? B7 F8 80 20 33 68 00 2B D9 F8 00 30 01 D1 63 B3 00 E0 53 BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 F1 88 17 F1 80 03 03 E0 8A 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1B 5B 10 0A 2B 15 D2 A8 45 08 DA 97 4A 08 F1 01 08 9B 5C 8A F8 00 30 0A F1 01 0A 02 E0 0B B1 01 23 FB 60 01 22 30 46 7A 60 ?? ?? ?? ?? B7 F8 80 20 BD E7 FB 68 3D 68 FB B1 D7 F8 28 80 AA F1 01 04 44 45 15 D0 ?? ?? ?? ?? 03 68 94 F9 00 20 93 F9 00 30 9A 42 03 D0 39 2A 05 D1 30 23 23 70 64 1E 44 45 EF D1 02 E0 23 78 5B 1C 23 70 44 45 03 D1 31 23 6D 1C 3D 60 23 70 D7 F8 04 80 B8 F1 00 0F 00 F0 D1 80 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 03 D1 00 2B 00 F0 BE 80 02 E0 00 2B 40 F0 BA 80 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 9A 30 9A 42 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 98 30 9A 42 40 F0 A5 80 65 23 8A F8 00 30 30 46 0A F1 01 0A ?? ?? ?? ?? 33 79 00 25 4F F0 00 08 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 FB B1 00 E0 EB B9 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 96 30 9A 42 08 BF 2B 23 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 94 30 9A 42 07 D1 2D 23 8A F8 00 30 0A F1 01 0A 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 99 F8 04 30 13 B9 48 46 ?? ?? ?? ?? 33 68 00 2B D9 F8 00 30 01 D1 73 B1 00 E0 63 B9 33 79 13 B9 30 46 ?? ?? ?? ?? F3 88 B7 F8 80 20 93 42 04 D1 4F F0 01 08 DC E7 B7 F8 80 20 B8 F1 00 0F 04 D0 30 23 8A F8 00 30 0A F1 01 0A 17 F1 80 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 99 F8 04 30 23 B9 48 46 ?? ?? ?? ?? B7 F8 80 20 33 68 00 2B D9 F8 00 30 01 D1 3B B3 00 E0 2B BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 80 20 F1 88 17 F1 80 03 03 E0 8A 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1B 5B 10 0A 2B 10 D2 08 2D 06 DA 17 4A 6D 1C 9B 5C 8A F8 00 30 0A F1 01 0A 30 46 4F F0 01 08 ?? ?? ?? ?? B7 F8 80 20 C2 E7 FB 69 13 B9 B8 F1 00 0F 01 D1 3B 69 9A 46 00 23 8A F8 00 30 BB 6F 10 2B 02 D3 78 6E ?? ?? ?? ?? 0F 23 38 6E BB 67 00 23 7B 67 87 F8 64 30 ?? ?? ?? ?? 3B 68 18 46 2A B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_683_1 {
	meta:
		name = "?_Getffldx@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z"
		size = 2080
		refs = "0008 __security_push_cookie 002e ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0032 ??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0044 _guard_check_icall 0066 ?grouping@?$numpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0074 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 00cc ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 0126 ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ 023e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 033e ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0378 _invalid_parameter_noinfo_noreturn 0380 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 0404 ??3@YAXPAX@Z 0518 localeconv 080e __security_pop_cookie 0818 ?_Src@?1??_Getffldx@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1AAVios_base@3@PAH@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? AE B0 6F 46 98 46 6F F0 01 03 D7 F8 E0 90 C7 E9 0C 33 D7 F8 E4 30 C7 E9 06 13 17 F1 28 01 48 46 16 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 F8 60 FD 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 58 01 50 46 ?? ?? ?? ?? 17 F1 20 01 48 46 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 7D 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D9 F8 00 20 DF F8 70 57 D4 6A 20 46 ?? ?? ?? ?? 48 46 29 46 05 F1 1D 02 17 F1 78 03 A0 47 00 23 BC 69 7B 61 33 79 A1 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 2B 21 2D 25 00 2B D8 F8 00 30 01 D1 F3 B1 00 E0 E3 B9 33 79 1B B9 30 46 ?? ?? ?? ?? 2B 21 F2 88 B7 F8 A6 30 9A 42 01 D1 21 70 0A E0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 A4 30 9A 42 05 D1 25 70 30 46 04 F1 01 09 ?? ?? ?? ?? 30 23 89 F8 00 30 78 23 89 F8 01 30 00 23 3B 60 33 79 00 24 09 F1 02 09 C7 E9 01 44 A2 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 DB B3 00 E0 CB BB 33 79 13 B9 30 46 ?? ?? ?? ?? F3 88 B7 F8 78 10 8B 42 31 D1 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 CB B1 00 E0 BB B9 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 AA 30 9A 42 09 D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 A8 30 9A 42 03 D1 30 46 ?? ?? ?? ?? 01 E0 01 23 7B 60 B7 F8 78 10 FB 69 1A 68 DF F8 30 36 9A 42 02 D1 4F F4 40 75 00 E0 24 25 3B 6F 3D 61 10 2B 01 D3 FB 6D 01 E0 17 F1 5C 03 3B 62 93 F9 00 30 7F 2B 00 F0 08 81 00 2B 40 F3 05 81 FB 6E 13 B9 4F F0 00 0A 08 E0 FD 68 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 82 46 17 F1 38 00 00 22 01 21 ?? ?? ?? ?? 00 25 17 F1 78 04 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 8D 80 02 E0 00 2B 40 F0 89 80 33 79 13 B9 30 46 ?? ?? ?? ?? F1 88 B7 F8 78 30 17 F1 78 02 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 13 1B 5B 10 16 2B 2A D2 01 22 39 69 7A 60 BA 68 91 42 03 DC 3B 68 5B 1C 3B 60 0A E0 03 B9 42 B1 DF F8 5C 15 52 1C BA 60 5B 5C 89 F8 00 30 09 F1 01 09 FB 6C 9D 42 53 D8 39 6D FA 6B 10 29 28 BF 13 46 01 D2 17 F1 3C 03 5B 57 7F 2B 44 D0 10 29 01 D2 17 F1 3C 02 53 5D 5B 1C 53 55 3C E0 FC 6C A5 42 43 D8 39 6D F8 6B 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 F3 B3 BA F1 00 0F 3B D0 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 13 41 F8 6B F3 88 53 45 30 D1 C4 F1 FF 33 01 2B 23 D9 64 1C 21 46 00 22 17 F1 38 00 ?? ?? ?? ?? 90 B1 3B 6D 10 2B 01 D3 FA 6B 01 E0 17 F1 3C 02 FB 6C 00 21 99 54 3B 6D 10 2B 01 D3 FB 6B 01 E0 17 F1 3C 03 FC 64 E1 54 6D 1C 17 F1 78 04 30 46 ?? ?? ?? ?? 67 E7 ?? ?? ?? ?? 17 F1 38 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 13 41 F8 6B 6D B1 A5 42 01 D9 ?? ?? ?? ?? 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 00 2B 28 DD 6D 1C D7 F8 20 E0 35 B3 9E F9 00 20 7F 2A 22 D0 6D 1E 0A D0 A5 42 1A D8 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 9A 42 13 D1 4D B9 10 29 28 BF 03 46 01 D2 17 F1 3C 03 93 F9 00 30 9A 42 08 DB 9E F9 01 30 00 2B DE DD 0E F1 01 0E DB E7 ?? ?? ?? ?? 01 23 7B 61 10 29 01 D3 ?? ?? ?? ?? 0F 23 B8 6B 3B 65 00 23 FB 64 87 F8 3C 30 ?? ?? ?? ?? B7 F8 78 10 D7 F8 08 A0 48 E0 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 10 33 68 00 2B D8 F8 00 30 01 D1 8B B3 00 E0 7B BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 F0 88 17 F1 78 03 31 B1 0A 46 82 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1B 5B 10 16 2B 19 D2 55 45 03 DC 3B 68 5B 1C 3B 60 0B E0 13 B9 BA F1 00 0F 07 D0 E0 4A 0A F1 01 0A 9B 5C 89 F8 00 30 09 F1 01 09 01 23 30 46 7B 60 ?? ?? ?? ?? B7 F8 78 10 B8 E7 7B 68 3B B1 BA F1 00 0F 04 D1 30 23 89 F8 00 30 09 F1 01 09 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 10 33 68 00 2B D8 F8 00 30 01 D1 F3 B1 00 E0 E3 B9 33 79 13 B9 30 46 ?? ?? ?? ?? FB 68 F5 88 1B 68 DC 68 20 46 ?? ?? ?? ?? F8 68 A0 47 85 42 0A D1 ?? ?? ?? ?? 03 68 30 46 1B 78 89 F8 00 30 09 F1 01 09 ?? ?? ?? ?? B7 F8 78 10 BA F1 00 0F 34 D1 3C 68 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 10 33 68 00 2B D8 F8 00 30 01 D1 A3 B1 00 E0 93 B9 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 F3 88 8B 42 08 D1 64 1E 01 23 30 46 7B 60 ?? ?? ?? ?? B7 F8 78 10 D5 E7 3C 60 00 2C 06 DA 30 23 64 1C 89 F8 00 30 09 F1 01 09 3C 60 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 10 33 68 00 2B D8 F8 00 30 01 D1 4B B3 00 E0 3B BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 F2 88 17 F1 78 03 03 E0 91 42 03 D0 9B 1C 19 88 00 29 F9 D1 1B 1B 5B 10 16 2B 12 D2 3A 69 92 45 07 DA 84 4A 0A F1 01 0A 9B 5C 89 F8 00 30 09 F1 01 09 01 23 30 46 7B 60 ?? ?? ?? ?? B7 F8 78 10 C0 E7 D7 F8 04 A0 BA F1 00 0F 00 F0 D1 80 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 BE 80 02 E0 00 2B 40 F0 BA 80 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 AE 30 9A 42 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 AC 30 9A 42 40 F0 A5 80 70 23 89 F8 00 30 30 46 09 F1 01 09 ?? ?? ?? ?? 33 79 00 25 4F F0 00 0A 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 FB B1 00 E0 EB B9 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 A6 30 9A 42 08 BF 2B 23 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 A4 30 9A 42 07 D1 2D 23 89 F8 00 30 09 F1 01 09 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 73 B1 00 E0 63 B9 33 79 13 B9 30 46 ?? ?? ?? ?? F3 88 B7 F8 78 20 93 42 04 D1 4F F0 01 0A DC E7 B7 F8 78 20 BA F1 00 0F 04 D0 30 23 89 F8 00 30 09 F1 01 09 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 20 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 20 33 68 00 2B D8 F8 00 30 01 D1 3B B3 00 E0 2B BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 20 F1 88 17 F1 78 03 03 E0 8A 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1B 5B 10 16 2B 10 D2 08 2D 06 DA 18 4A 6D 1C 9B 5C 89 F8 00 30 09 F1 01 09 30 46 4F F0 01 0A ?? ?? ?? ?? B7 F8 78 20 C2 E7 7B 69 13 B9 BA F1 00 0F 01 D1 B9 69 89 46 00 23 FA 69 89 F8 00 30 3B 68 13 60 3B 6F 10 2B 02 D3 F8 6D ?? ?? ?? ?? 0F 23 B8 6D 3B 67 00 23 FB 66 87 F8 5C 30 ?? ?? ?? ?? 00 20 2E B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_690_1 {
	meta:
		name = "?_Getffldx@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z"
		size = 2080
		refs = "0008 __security_push_cookie 002e ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0032 ??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0044 _guard_check_icall 0066 ?grouping@?$numpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0074 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 00cc ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 0126 ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ 023e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 033e ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0378 _invalid_parameter_noinfo_noreturn 0380 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 0404 ??3@YAXPAX@Z 0518 localeconv 080e __security_pop_cookie 0818 ?_Src@?1??_Getffldx@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1AAVios_base@3@PAH@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? AE B0 6F 46 98 46 6F F0 01 03 D7 F8 E0 90 C7 E9 0C 33 D7 F8 E4 30 C7 E9 06 13 17 F1 28 01 48 46 16 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 F8 60 FD 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 58 01 50 46 ?? ?? ?? ?? 17 F1 20 01 48 46 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 7D 6A 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D9 F8 00 20 DF F8 70 57 D4 6A 20 46 ?? ?? ?? ?? 48 46 29 46 05 F1 1D 02 17 F1 78 03 A0 47 00 23 BC 69 7B 61 33 79 A1 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 2B 21 2D 25 00 2B D8 F8 00 30 01 D1 F3 B1 00 E0 E3 B9 33 79 1B B9 30 46 ?? ?? ?? ?? 2B 21 F2 88 B7 F8 A6 30 9A 42 01 D1 21 70 0A E0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 A4 30 9A 42 05 D1 25 70 30 46 04 F1 01 09 ?? ?? ?? ?? 30 23 89 F8 00 30 78 23 89 F8 01 30 00 23 3B 60 33 79 00 24 09 F1 02 09 C7 E9 01 44 A2 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 DB B3 00 E0 CB BB 33 79 13 B9 30 46 ?? ?? ?? ?? F3 88 B7 F8 78 10 8B 42 31 D1 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 CB B1 00 E0 BB B9 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 AA 30 9A 42 09 D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 A8 30 9A 42 03 D1 30 46 ?? ?? ?? ?? 01 E0 01 23 7B 60 B7 F8 78 10 FB 69 1A 68 DF F8 30 36 9A 42 02 D1 4F F4 40 75 00 E0 24 25 3B 6F 3D 61 10 2B 01 D3 FB 6D 01 E0 17 F1 5C 03 3B 62 93 F9 00 30 7F 2B 00 F0 08 81 00 2B 40 F3 05 81 FB 6E 13 B9 4F F0 00 0A 08 E0 FD 68 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 82 46 17 F1 38 00 00 22 01 21 ?? ?? ?? ?? 00 25 17 F1 78 04 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 8D 80 02 E0 00 2B 40 F0 89 80 33 79 13 B9 30 46 ?? ?? ?? ?? F1 88 B7 F8 78 30 17 F1 78 02 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 13 1B 5B 10 16 2B 2A D2 01 22 39 69 7A 60 BA 68 91 42 03 DC 3B 68 5B 1C 3B 60 0A E0 03 B9 42 B1 DF F8 5C 15 52 1C BA 60 5B 5C 89 F8 00 30 09 F1 01 09 FB 6C 9D 42 53 D8 39 6D FA 6B 10 29 28 BF 13 46 01 D2 17 F1 3C 03 5B 57 7F 2B 44 D0 10 29 01 D2 17 F1 3C 02 53 5D 5B 1C 53 55 3C E0 FC 6C A5 42 43 D8 39 6D F8 6B 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 F3 B3 BA F1 00 0F 3B D0 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 13 41 F8 6B F3 88 53 45 30 D1 C4 F1 FF 33 01 2B 23 D9 64 1C 21 46 00 22 17 F1 38 00 ?? ?? ?? ?? 90 B1 3B 6D 10 2B 01 D3 FA 6B 01 E0 17 F1 3C 02 FB 6C 00 21 99 54 3B 6D 10 2B 01 D3 FB 6B 01 E0 17 F1 3C 03 FC 64 E1 54 6D 1C 17 F1 78 04 30 46 ?? ?? ?? ?? 67 E7 ?? ?? ?? ?? 17 F1 38 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 13 41 F8 6B 6D B1 A5 42 01 D9 ?? ?? ?? ?? 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 00 2B 28 DD 6D 1C D7 F8 20 E0 35 B3 9E F9 00 20 7F 2A 22 D0 6D 1E 0A D0 A5 42 1A D8 10 29 28 BF 03 46 01 D2 17 F1 3C 03 5B 57 9A 42 13 D1 4D B9 10 29 28 BF 03 46 01 D2 17 F1 3C 03 93 F9 00 30 9A 42 08 DB 9E F9 01 30 00 2B DE DD 0E F1 01 0E DB E7 ?? ?? ?? ?? 01 23 7B 61 10 29 01 D3 ?? ?? ?? ?? 0F 23 B8 6B 3B 65 00 23 FB 64 87 F8 3C 30 ?? ?? ?? ?? B7 F8 78 10 D7 F8 08 A0 48 E0 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 10 33 68 00 2B D8 F8 00 30 01 D1 8B B3 00 E0 7B BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 F0 88 17 F1 78 03 31 B1 0A 46 82 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1B 5B 10 16 2B 19 D2 55 45 03 DC 3B 68 5B 1C 3B 60 0B E0 13 B9 BA F1 00 0F 07 D0 E0 4A 0A F1 01 0A 9B 5C 89 F8 00 30 09 F1 01 09 01 23 30 46 7B 60 ?? ?? ?? ?? B7 F8 78 10 B8 E7 7B 68 3B B1 BA F1 00 0F 04 D1 30 23 89 F8 00 30 09 F1 01 09 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 10 33 68 00 2B D8 F8 00 30 01 D1 F3 B1 00 E0 E3 B9 33 79 13 B9 30 46 ?? ?? ?? ?? FB 68 F5 88 1B 68 DC 68 20 46 ?? ?? ?? ?? F8 68 A0 47 85 42 0A D1 ?? ?? ?? ?? 03 68 30 46 1B 78 89 F8 00 30 09 F1 01 09 ?? ?? ?? ?? B7 F8 78 10 BA F1 00 0F 34 D1 3C 68 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 10 33 68 00 2B D8 F8 00 30 01 D1 A3 B1 00 E0 93 B9 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 F3 88 8B 42 08 D1 64 1E 01 23 30 46 7B 60 ?? ?? ?? ?? B7 F8 78 10 D5 E7 3C 60 00 2C 06 DA 30 23 64 1C 89 F8 00 30 09 F1 01 09 3C 60 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 10 33 68 00 2B D8 F8 00 30 01 D1 4B B3 00 E0 3B BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 10 F2 88 17 F1 78 03 03 E0 91 42 03 D0 9B 1C 19 88 00 29 F9 D1 1B 1B 5B 10 16 2B 12 D2 3A 69 92 45 07 DA 84 4A 0A F1 01 0A 9B 5C 89 F8 00 30 09 F1 01 09 01 23 30 46 7B 60 ?? ?? ?? ?? B7 F8 78 10 C0 E7 D7 F8 04 A0 BA F1 00 0F 00 F0 D1 80 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 BE 80 02 E0 00 2B 40 F0 BA 80 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 AE 30 9A 42 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 AC 30 9A 42 40 F0 A5 80 70 23 89 F8 00 30 30 46 09 F1 01 09 ?? ?? ?? ?? 33 79 00 25 4F F0 00 0A 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 FB B1 00 E0 EB B9 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 A6 30 9A 42 08 BF 2B 23 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 A4 30 9A 42 07 D1 2D 23 89 F8 00 30 09 F1 01 09 30 46 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 73 B1 00 E0 63 B9 33 79 13 B9 30 46 ?? ?? ?? ?? F3 88 B7 F8 78 20 93 42 04 D1 4F F0 01 0A DC E7 B7 F8 78 20 BA F1 00 0F 04 D0 30 23 89 F8 00 30 09 F1 01 09 17 F1 78 04 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 20 98 F8 04 30 23 B9 40 46 ?? ?? ?? ?? B7 F8 78 20 33 68 00 2B D8 F8 00 30 01 D1 3B B3 00 E0 2B BB 33 79 23 B9 30 46 ?? ?? ?? ?? B7 F8 78 20 F1 88 17 F1 78 03 03 E0 8A 42 03 D0 9B 1C 1A 88 00 2A F9 D1 1B 1B 5B 10 16 2B 10 D2 08 2D 06 DA 18 4A 6D 1C 9B 5C 89 F8 00 30 09 F1 01 09 30 46 4F F0 01 0A ?? ?? ?? ?? B7 F8 78 20 C2 E7 7B 69 13 B9 BA F1 00 0F 01 D1 B9 69 89 46 00 23 FA 69 89 F8 00 30 3B 68 13 60 3B 6F 10 2B 02 D3 F8 6D ?? ?? ?? ?? 0F 23 B8 6D 3B 67 00 23 FB 66 87 F8 5C 30 ?? ?? ?? ?? 00 20 2E B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? 00 CA 9A 3B }
	condition:
		$1
}

rule file_17_697_1 {
	meta:
		name = "?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 484
		refs = "0022 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0026 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0036 _guard_check_icall 00ca ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 011c ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 89 B0 6F 46 88 B0 78 60 38 6E 8A 46 6F F0 01 03 17 F1 08 01 C7 E9 04 33 ?? ?? ?? ?? ?? ?? ?? ?? 38 60 FD 68 8D B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3C 68 D7 F8 6C 90 D7 F8 64 80 97 F8 5C 10 99 F9 00 30 B8 6D 97 F8 54 20 D7 E9 14 56 00 2B 00 F0 94 80 D7 F8 68 E0 3C 68 25 2B 20 D1 09 F1 01 09 00 23 99 F9 00 10 06 93 3B 6E 05 91 F9 6D 02 93 7B 68 CD E9 00 01 CD F8 10 E0 19 68 CD F8 0C 80 4C 6A 20 46 ?? ?? ?? ?? 78 68 17 F1 18 01 2A 46 33 46 A0 47 05 68 3D 65 46 68 7E 65 52 E0 20 2B 37 D1 4A B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 10 B8 6D 97 F8 54 20 3D 6D 49 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 10 B8 6D 97 F8 54 20 3D 6D 0D B9 E8 B1 00 E0 D8 B9 1A B9 17 F1 50 00 ?? ?? ?? ?? 23 68 1C 69 20 46 ?? ?? ?? ?? 38 68 B7 F8 56 20 48 21 A0 47 20 B3 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 10 B8 6D 97 F8 54 20 3D 6D 3C 68 C9 E7 7E 6D 1D E0 1A B9 17 F1 50 00 ?? ?? ?? ?? 23 68 9C 6B 20 46 ?? ?? ?? ?? 38 68 B7 F8 56 10 00 22 A0 47 99 F9 00 30 98 42 13 D1 17 F1 50 00 ?? ?? ?? ?? D7 E9 14 56 97 F8 5C 10 B8 6D 97 F8 54 20 19 F9 01 3F 3C 68 D7 F8 68 E0 00 2B 7F F4 7D AF 0C E0 D8 F8 00 30 97 F8 5C 10 B8 6D 43 F0 02 03 97 F8 54 20 D7 E9 14 56 C8 F8 00 30 42 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 10 B8 6D D7 E9 14 56 31 B9 17 F1 58 00 ?? ?? ?? ?? B8 6D D7 E9 14 56 0D B9 08 B1 06 E0 28 B1 D8 F8 00 30 43 F0 01 03 C8 F8 00 30 CA E9 00 56 50 46 11 B0 BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_700_1 {
	meta:
		name = "?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 484
		refs = "0022 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0026 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0036 _guard_check_icall 00ca ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 011c ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 89 B0 6F 46 88 B0 78 60 38 6E 8A 46 6F F0 01 03 17 F1 08 01 C7 E9 04 33 ?? ?? ?? ?? ?? ?? ?? ?? 38 60 FD 68 8D B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3C 68 D7 F8 6C 90 D7 F8 64 80 97 F8 5C 10 99 F9 00 30 B8 6D 97 F8 54 20 D7 E9 14 56 00 2B 00 F0 94 80 D7 F8 68 E0 3C 68 25 2B 20 D1 09 F1 01 09 00 23 99 F9 00 10 06 93 3B 6E 05 91 F9 6D 02 93 7B 68 CD E9 00 01 CD F8 10 E0 19 68 CD F8 0C 80 4C 6A 20 46 ?? ?? ?? ?? 78 68 17 F1 18 01 2A 46 33 46 A0 47 05 68 3D 65 46 68 7E 65 52 E0 20 2B 37 D1 4A B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 10 B8 6D 97 F8 54 20 3D 6D 49 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 10 B8 6D 97 F8 54 20 3D 6D 0D B9 E8 B1 00 E0 D8 B9 1A B9 17 F1 50 00 ?? ?? ?? ?? 23 68 1C 69 20 46 ?? ?? ?? ?? 38 68 B7 F8 56 20 48 21 A0 47 20 B3 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 10 B8 6D 97 F8 54 20 3D 6D 3C 68 C9 E7 7E 6D 1D E0 1A B9 17 F1 50 00 ?? ?? ?? ?? 23 68 9C 6B 20 46 ?? ?? ?? ?? 38 68 B7 F8 56 10 00 22 A0 47 99 F9 00 30 98 42 13 D1 17 F1 50 00 ?? ?? ?? ?? D7 E9 14 56 97 F8 5C 10 B8 6D 97 F8 54 20 19 F9 01 3F 3C 68 D7 F8 68 E0 00 2B 7F F4 7D AF 0C E0 D8 F8 00 30 97 F8 5C 10 B8 6D 43 F0 02 03 97 F8 54 20 D7 E9 14 56 C8 F8 00 30 42 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 10 B8 6D D7 E9 14 56 31 B9 17 F1 58 00 ?? ?? ?? ?? B8 6D D7 E9 14 56 0D B9 08 B1 06 E0 28 B1 D8 F8 00 30 43 F0 01 03 C8 F8 00 30 CA E9 00 56 50 46 11 B0 BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_703_1 {
	meta:
		name = "?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z"
		size = 1056
		refs = "0008 __security_push_cookie 0024 ??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 002e ?grouping@?$numpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0042 _guard_check_icall 004e ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 007a ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00d0 ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ 01ea ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 02ea ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0322 _invalid_parameter_noinfo_noreturn 032a ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 03d6 ??3@YAXPAX@Z 0412 __security_pop_cookie 041c ?_Src@?1??_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1HABVlocale@3@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A6 B0 6F 46 D7 F8 C4 90 98 46 6F F0 01 03 48 46 16 46 39 61 C7 E9 06 33 ?? ?? ?? ?? 17 F1 40 01 05 46 ?? ?? ?? ?? 78 6D 10 B9 00 23 7B 60 07 E0 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 78 60 48 46 ?? ?? ?? ?? 04 46 22 68 DF F8 C4 93 D5 6A 28 46 ?? ?? ?? ?? 20 46 49 46 09 F1 1B 02 17 F1 60 03 A8 47 3C 69 33 79 A2 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 F3 B1 00 E0 E3 B9 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 8E 30 9A 42 08 BF 2B 23 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 8C 30 9A 42 06 D1 2D 23 30 46 04 F1 01 0A 23 70 ?? ?? ?? ?? D7 F8 C0 30 03 F4 60 63 B3 F5 80 6F 02 D1 4F F0 08 09 0B E0 B3 F5 00 6F 02 D1 4F F0 10 09 05 E0 13 B9 4F F0 00 09 01 E0 4F F0 0A 09 00 23 FB 60 33 79 00 24 3C 60 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 02 D1 00 2B 4B D0 01 E0 00 2B 48 D1 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 60 30 9A 42 3E D1 01 24 30 46 3C 60 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 1B B3 00 E0 0B BB 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 92 30 9A 42 09 D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 90 30 9A 42 0D D1 B9 F1 00 0F 02 D0 B9 F1 10 0F 07 D1 00 24 30 46 3C 60 4F F0 10 09 ?? ?? ?? ?? 0F E0 B9 F1 00 0F 04 D1 4F F0 08 09 B9 F1 00 0F 09 D0 B9 F1 0A 0F 06 D0 B9 F1 08 0F 08 BF 08 25 02 D0 16 25 00 E0 0A 25 22 46 17 F1 20 00 01 21 BD 60 ?? ?? ?? ?? 00 24 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 8E 80 02 E0 00 2B 40 F0 8A 80 33 79 13 B9 30 46 ?? ?? ?? ?? F1 88 B7 F8 60 30 17 F1 60 02 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 17 F1 60 03 D3 1A 5B 10 AB 42 28 D2 73 4A 9B 56 FA 68 8A F8 00 30 0A B9 30 2B 08 D0 3A 69 02 F1 1F 03 9A 45 03 D2 01 23 FB 60 0A F1 01 0A 01 23 3B 60 7B 6B 9C 42 54 D8 B9 6B 7A 6A 10 29 28 BF 13 46 01 D2 17 F1 24 03 1B 57 7F 2B 45 D0 10 29 01 D2 17 F1 24 02 13 5D 5B 1C 13 55 3D E0 D7 F8 34 E0 74 45 43 D8 BD 6B 78 6A 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 F3 B3 7B 68 E3 B3 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 0D E5 78 6A F3 88 7A 68 93 42 30 D1 CE F1 FF 33 01 2B 23 D9 0E F1 01 05 29 46 00 22 17 F1 20 00 ?? ?? ?? ?? 90 B1 BB 6B 10 2B 01 D3 7A 6A 01 E0 17 F1 24 02 7B 6B 00 21 99 54 BB 6B 10 2B 01 D3 7B 6A 01 E0 17 F1 24 03 7D 63 59 55 BD 68 64 1C 30 46 ?? ?? ?? ?? 66 E7 ?? ?? ?? ?? 17 F1 20 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 0D E5 78 6A 84 B1 74 45 01 D9 ?? ?? ?? ?? 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 00 2B C8 BF 64 1C D8 BF 00 21 00 DD 39 68 BB 6D 10 2B 01 D3 7A 6C 01 E0 17 F1 44 02 61 B3 1C B3 92 F9 00 10 7F 29 1F D0 64 1E 0A D0 74 45 19 D8 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 99 42 1A D1 4C B9 10 2D 28 BF 03 46 01 D2 17 F1 24 03 93 F9 00 30 99 42 0F DB 92 F9 01 30 00 2B DE DD 52 1C DC E7 ?? ?? ?? ?? FB 68 3B B9 30 23 8A F8 00 30 0A F1 01 0A 01 E0 3B 69 9A 46 00 23 8A F8 00 30 10 2D 01 D3 ?? ?? ?? ?? 0F 23 38 6A BB 63 00 23 7B 63 87 F8 24 30 ?? ?? ?? ?? 00 23 3B 62 BB 6D 10 2B 02 D3 78 6C ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? 48 46 26 B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_706_1 {
	meta:
		name = "?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z"
		size = 1056
		refs = "0008 __security_push_cookie 0024 ??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 002e ?grouping@?$numpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0042 _guard_check_icall 004e ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 007a ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00d0 ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ 01ea ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 02ea ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0322 _invalid_parameter_noinfo_noreturn 032a ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 03d6 ??3@YAXPAX@Z 0412 __security_pop_cookie 041c ?_Src@?1??_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1HABVlocale@3@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A6 B0 6F 46 D7 F8 C4 90 98 46 6F F0 01 03 48 46 16 46 39 61 C7 E9 06 33 ?? ?? ?? ?? 17 F1 40 01 05 46 ?? ?? ?? ?? 78 6D 10 B9 00 23 7B 60 07 E0 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 78 60 48 46 ?? ?? ?? ?? 04 46 22 68 DF F8 C4 93 D5 6A 28 46 ?? ?? ?? ?? 20 46 49 46 09 F1 1B 02 17 F1 60 03 A8 47 3C 69 33 79 A2 46 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 F3 B1 00 E0 E3 B9 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 8E 30 9A 42 08 BF 2B 23 0A D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 8C 30 9A 42 06 D1 2D 23 30 46 04 F1 01 0A 23 70 ?? ?? ?? ?? D7 F8 C0 30 03 F4 60 63 B3 F5 80 6F 02 D1 4F F0 08 09 0B E0 B3 F5 00 6F 02 D1 4F F0 10 09 05 E0 13 B9 4F F0 00 09 01 E0 4F F0 0A 09 00 23 FB 60 33 79 00 24 3C 60 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 02 D1 00 2B 4B D0 01 E0 00 2B 48 D1 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 60 30 9A 42 3E D1 01 24 30 46 3C 60 ?? ?? ?? ?? 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 01 D1 1B B3 00 E0 0B BB 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 92 30 9A 42 09 D0 33 79 13 B9 30 46 ?? ?? ?? ?? F2 88 B7 F8 90 30 9A 42 0D D1 B9 F1 00 0F 02 D0 B9 F1 10 0F 07 D1 00 24 30 46 3C 60 4F F0 10 09 ?? ?? ?? ?? 0F E0 B9 F1 00 0F 04 D1 4F F0 08 09 B9 F1 00 0F 09 D0 B9 F1 0A 0F 06 D0 B9 F1 08 0F 08 BF 08 25 02 D0 16 25 00 E0 0A 25 22 46 17 F1 20 00 01 21 BD 60 ?? ?? ?? ?? 00 24 33 79 13 B9 30 46 ?? ?? ?? ?? 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 33 68 00 2B D8 F8 00 30 03 D1 00 2B 00 F0 8E 80 02 E0 00 2B 40 F0 8A 80 33 79 13 B9 30 46 ?? ?? ?? ?? F1 88 B7 F8 60 30 17 F1 60 02 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 17 F1 60 03 D3 1A 5B 10 AB 42 28 D2 73 4A 9B 56 FA 68 8A F8 00 30 0A B9 30 2B 08 D0 3A 69 02 F1 1F 03 9A 45 03 D2 01 23 FB 60 0A F1 01 0A 01 23 3B 60 7B 6B 9C 42 54 D8 B9 6B 7A 6A 10 29 28 BF 13 46 01 D2 17 F1 24 03 1B 57 7F 2B 45 D0 10 29 01 D2 17 F1 24 02 13 5D 5B 1C 13 55 3D E0 D7 F8 34 E0 74 45 43 D8 BD 6B 78 6A 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 F3 B3 7B 68 E3 B3 33 79 2B B9 30 46 ?? ?? ?? ?? D7 E9 0D E5 78 6A F3 88 7A 68 93 42 30 D1 CE F1 FF 33 01 2B 23 D9 0E F1 01 05 29 46 00 22 17 F1 20 00 ?? ?? ?? ?? 90 B1 BB 6B 10 2B 01 D3 7A 6A 01 E0 17 F1 24 02 7B 6B 00 21 99 54 BB 6B 10 2B 01 D3 7B 6A 01 E0 17 F1 24 03 7D 63 59 55 BD 68 64 1C 30 46 ?? ?? ?? ?? 66 E7 ?? ?? ?? ?? 17 F1 20 00 ?? ?? ?? ?? ?? ?? ?? ?? D7 E9 0D E5 78 6A 84 B1 74 45 01 D9 ?? ?? ?? ?? 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 00 2B C8 BF 64 1C D8 BF 00 21 00 DD 39 68 BB 6D 10 2B 01 D3 7A 6C 01 E0 17 F1 44 02 61 B3 1C B3 92 F9 00 10 7F 29 1F D0 64 1E 0A D0 74 45 19 D8 10 2D 28 BF 03 46 01 D2 17 F1 24 03 1B 57 99 42 1A D1 4C B9 10 2D 28 BF 03 46 01 D2 17 F1 24 03 93 F9 00 30 99 42 0F DB 92 F9 01 30 00 2B DE DD 52 1C DC E7 ?? ?? ?? ?? FB 68 3B B9 30 23 8A F8 00 30 0A F1 01 0A 01 E0 3B 69 9A 46 00 23 8A F8 00 30 10 2D 01 D3 ?? ?? ?? ?? 0F 23 38 6A BB 63 00 23 7B 63 87 F8 24 30 ?? ?? ?? ?? 00 23 3B 62 BB 6D 10 2B 02 D3 78 6C ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? 48 46 26 B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_709_1 {
	meta:
		name = "?_Getint@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0HHAAHABV?$ctype@G@2@@Z"
		size = 448
		refs = "0008 __security_push_cookie 002a ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 0058 _guard_check_icall 007c ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ 00ee _Stolx 01b8 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 DD F8 68 A0 0E 46 30 79 03 93 19 9B CD F8 00 A0 0D F1 18 08 17 46 04 93 10 B9 08 46 ?? ?? ?? ?? 38 79 10 B9 38 46 ?? ?? ?? ?? 30 68 3B 68 08 B9 FB B1 00 E0 EB B9 33 79 13 B9 30 46 ?? ?? ?? ?? DA F8 00 30 F4 88 9D 6B 28 46 ?? ?? ?? ?? 50 46 21 46 00 22 A8 47 2B 28 08 BF 2B 23 02 D0 2D 28 07 D1 2D 23 30 46 0D F1 19 08 8D F8 18 30 ?? ?? ?? ?? 4F F0 00 09 33 79 13 B9 30 46 ?? ?? ?? ?? 3B 79 13 B9 38 46 ?? ?? ?? ?? 33 68 00 2B 3B 68 3A D1 DB BB B9 F1 00 0F 04 D0 30 23 88 F8 00 30 08 F1 01 08 0D F1 37 0A 33 79 13 B9 30 46 ?? ?? ?? ?? 3B 79 13 B9 38 46 ?? ?? ?? ?? 33 68 00 2B 3B 68 3B D1 E3 BB B9 F1 00 0F 01 D1 0D F1 18 08 00 23 88 F8 00 30 01 93 01 AB 02 A9 06 A8 0A 22 ?? ?? ?? ?? 33 79 00 24 05 46 13 B9 30 46 ?? ?? ?? ?? 3B 79 13 B9 38 46 ?? ?? ?? ?? 33 68 00 2B 3B 68 3D D1 EB B3 3D E0 00 2B C3 D1 33 79 13 B9 30 46 ?? ?? ?? ?? DA F8 00 30 F4 88 9D 6B 28 46 ?? ?? ?? ?? 50 46 21 46 00 22 A8 47 30 28 B1 D1 30 46 4F F0 01 09 ?? ?? ?? ?? 9C E7 00 2B C2 D1 33 79 13 B9 30 46 ?? ?? ?? ?? 00 9B F4 88 1B 68 9D 6B 28 46 ?? ?? ?? ?? 00 98 21 46 00 22 A8 47 30 28 B0 DB 39 28 AE DC 88 F8 00 00 D0 45 01 D2 08 F1 01 08 30 46 4F F0 01 09 ?? ?? ?? ?? 93 E7 03 B1 01 24 02 9B 06 AA 93 42 0A D0 01 9B 43 B9 03 9B 9D 42 05 DB 18 9B AB 42 02 DB 04 9B 1D 60 01 E0 44 F0 02 04 20 46 0E B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_710_1 {
	meta:
		name = "?_Getint@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0HHAAHABV?$ctype@_W@2@@Z"
		size = 448
		refs = "0008 __security_push_cookie 002a ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 0058 _guard_check_icall 007c ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ 00ee _Stolx 01b8 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 DD F8 68 A0 0E 46 30 79 03 93 19 9B CD F8 00 A0 0D F1 18 08 17 46 04 93 10 B9 08 46 ?? ?? ?? ?? 38 79 10 B9 38 46 ?? ?? ?? ?? 30 68 3B 68 08 B9 FB B1 00 E0 EB B9 33 79 13 B9 30 46 ?? ?? ?? ?? DA F8 00 30 F4 88 9D 6B 28 46 ?? ?? ?? ?? 50 46 21 46 00 22 A8 47 2B 28 08 BF 2B 23 02 D0 2D 28 07 D1 2D 23 30 46 0D F1 19 08 8D F8 18 30 ?? ?? ?? ?? 4F F0 00 09 33 79 13 B9 30 46 ?? ?? ?? ?? 3B 79 13 B9 38 46 ?? ?? ?? ?? 33 68 00 2B 3B 68 3A D1 DB BB B9 F1 00 0F 04 D0 30 23 88 F8 00 30 08 F1 01 08 0D F1 37 0A 33 79 13 B9 30 46 ?? ?? ?? ?? 3B 79 13 B9 38 46 ?? ?? ?? ?? 33 68 00 2B 3B 68 3B D1 E3 BB B9 F1 00 0F 01 D1 0D F1 18 08 00 23 88 F8 00 30 01 93 01 AB 02 A9 06 A8 0A 22 ?? ?? ?? ?? 33 79 00 24 05 46 13 B9 30 46 ?? ?? ?? ?? 3B 79 13 B9 38 46 ?? ?? ?? ?? 33 68 00 2B 3B 68 3D D1 EB B3 3D E0 00 2B C3 D1 33 79 13 B9 30 46 ?? ?? ?? ?? DA F8 00 30 F4 88 9D 6B 28 46 ?? ?? ?? ?? 50 46 21 46 00 22 A8 47 30 28 B1 D1 30 46 4F F0 01 09 ?? ?? ?? ?? 9C E7 00 2B C2 D1 33 79 13 B9 30 46 ?? ?? ?? ?? 00 9B F4 88 1B 68 9D 6B 28 46 ?? ?? ?? ?? 00 98 21 46 00 22 A8 47 30 28 B0 DB 39 28 AE DC 88 F8 00 00 D0 45 01 D2 08 F1 01 08 30 46 4F F0 01 09 ?? ?? ?? ?? 93 E7 03 B1 01 24 02 9B 06 AA 93 42 0A D0 01 9B 43 B9 03 9B 9D 42 05 DB 18 9B AB 42 02 DB 04 9B 1D 60 01 E0 44 F0 02 04 20 46 0E B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_712_1 {
	meta:
		name = "?_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0_NAAVios_base@2@PAG@Z"
		size = 2804
		refs = "0008 __security_push_cookie 0044 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0048 ??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 005a _guard_check_icall 0080 ??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 00be ??2@YAPAXI@Z 00c4 _invalid_parameter_noinfo_noreturn 0140 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 01da ?grouping@?$_Mpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0220 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 022c ??$?9GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 023a ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 0264 ??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@D@Z 02e2 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 02ec ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ 03a2 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 0522 ?positive_sign@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 0586 ??3@YAXPAX@Z 05bc ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 05e2 ??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV01@$$QAV01@@Z 0604 ?negative_sign@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 0686 ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ 0706 ?curr_symbol@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 07fc ?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 0842 ?end@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 0a54 ??E?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@XZ 0a5a ??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA_NABV01@@Z 0a7e ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAABGXZ 0ad8 ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@IID@Z 0ae8 __security_pop_cookie 0af0 ?_Src@?1??_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@3@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@0_NAAVios_base@3@PAG@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? BE B0 6F 46 9A 46 FB 61 6F F0 01 03 0E 46 C7 E9 1C 33 90 46 7A 61 3E 62 D7 F8 24 31 D7 F8 28 21 97 F8 20 01 7A 62 00 22 00 28 BA 60 18 46 FE 65 FB 63 1B D0 17 F1 60 01 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 F8 60 7D 6E 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 1A E0 17 F1 68 01 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 F8 60 FD 6E 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 00 23 3B 61 BB 62 08 20 C7 F8 D8 30 C7 E9 3B 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 C7 F8 D8 00 C0 E9 00 32 D7 F8 D8 30 17 F1 D8 02 1A 60 07 23 C7 F8 F0 30 00 23 C7 F8 EC 30 A7 F8 DC 30 D9 F8 00 30 DC 6A 20 46 ?? ?? ?? ?? 48 46 39 1D A0 47 00 24 08 20 34 60 C6 E9 05 44 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 30 60 C0 E9 00 32 33 68 1E 60 0F 23 C6 E9 05 43 34 71 F8 6B 4F F0 01 09 17 F1 30 01 C7 F8 18 90 C7 F8 08 90 ?? ?? ?? ?? ?? ?? ?? ?? 38 64 7D 6B 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3D 6C 2B 68 DC 6A 20 46 ?? ?? ?? ?? DF F8 74 39 28 46 19 46 03 F1 0C 02 7B 6A A0 47 00 23 08 24 3B 60 3A 1D 04 2B 80 F0 3D 84 9B 56 20 2B 00 F0 DF 83 24 2B 00 F0 AE 82 2B 2B 00 F0 9F 81 76 2B 04 D0 78 2B 00 F0 D4 83 00 F0 0A BC FD 68 4F F0 00 09 2B 68 C7 F8 44 90 5C 6A 20 46 ?? ?? ?? ?? 28 46 A0 47 82 46 B8 64 28 46 17 F1 B8 01 ?? ?? ?? ?? D7 F8 CC 30 00 2B 00 F0 F4 80 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 80 46 00 28 00 F0 E7 80 D7 F8 D0 30 10 2B 02 D3 D7 F8 BC 30 01 E0 17 F1 BC 03 1B 78 7F 2B 80 F0 DA 80 00 22 01 21 17 F1 98 00 ?? ?? ?? ?? 7C 69 F9 69 00 26 20 46 ?? ?? ?? ?? 00 28 7B D0 23 79 13 B9 20 46 ?? ?? ?? ?? 78 6A E1 88 03 88 02 46 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 13 1A 5B 10 0A 2B 1F D2 DF F8 90 28 38 6A 99 56 ?? ?? ?? ?? D7 F8 AC 30 9E 42 00 F2 B7 83 D7 F8 B0 10 D7 F8 9C 20 10 29 28 BF 13 46 01 D2 17 F1 9C 03 9B 57 7F 2B 2E D0 10 29 01 D2 17 F1 9C 02 93 5D 5B 1C 93 55 26 E0 D7 F8 AC 50 AE 42 00 F2 A1 83 D7 F8 B0 40 D7 F8 9C 00 10 2C 28 BF 03 46 01 D2 17 F1 9C 03 9B 57 13 B3 7A 69 13 79 3B B9 10 46 ?? ?? ?? ?? D7 E9 2B 54 D7 F8 9C 00 7A 69 D3 88 43 45 14 D1 00 22 01 21 17 F1 98 00 ?? ?? ?? ?? 7C 69 76 1C 20 46 ?? ?? ?? ?? F9 69 20 46 ?? ?? ?? ?? 00 28 9B D1 D7 E9 2B 54 D7 F8 9C 00 B6 B1 AE 42 00 F2 6C 83 10 2C 28 BF 03 46 01 D2 17 F1 9C 03 9B 57 00 2B C8 BF 76 1C 08 DC 4F F0 01 08 C7 F8 10 80 05 E0 D7 E9 2B 54 D7 F8 9C 00 D7 F8 10 80 D7 F8 D0 30 10 2B 02 D3 D7 F8 BC 10 01 E0 17 F1 BC 01 B8 F1 00 0F 2F D1 2E B3 91 F9 00 20 7F 2A 21 D0 76 1E 0B D0 AE 42 00 F2 44 83 10 2C 28 BF 03 46 01 D2 17 F1 9C 03 9B 57 9A 42 10 D1 4E B9 10 2C 28 BF 03 46 01 D2 17 F1 9C 03 93 F9 00 30 9A 42 05 DB 91 F9 01 30 00 2B DD DD 49 1C DB E7 01 23 3B 61 08 E0 17 F1 98 00 ?? ?? ?? ?? D7 F8 14 80 D7 E9 07 56 40 E0 17 F1 98 00 ?? ?? ?? ?? 17 F1 B8 00 ?? ?? ?? ?? D7 F8 14 80 3E 6A D7 E9 06 9A FE E2 D7 F8 14 80 FD 69 40 46 29 46 ?? ?? ?? ?? 50 B3 D7 F8 24 A0 DF F8 0C 97 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? B8 F8 06 10 BA F8 00 30 52 46 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 A2 EB 0A 03 5B 10 0A 2B 0D D2 13 F9 09 10 30 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 29 46 40 46 ?? ?? ?? ?? 00 28 DA D1 D7 E9 11 9A FB 68 1B 68 DC 68 20 46 ?? ?? ?? ?? F8 68 A0 47 04 46 40 46 29 46 ?? ?? ?? ?? C0 B3 BC B3 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? B8 F8 06 30 A3 42 2D D1 1F E0 D1 45 2A DA 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 78 6A B8 F8 06 10 03 88 02 46 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 13 1A 5B 10 0A 2B 10 D2 DF F8 58 26 30 46 99 56 ?? ?? ?? ?? 09 F1 01 09 40 46 ?? ?? ?? ?? 29 46 40 46 ?? ?? ?? ?? 00 28 D6 D1 D1 45 01 DA 01 23 3B 61 73 69 13 B9 01 23 3B 61 09 E0 D1 45 07 DA AA EB 09 04 30 21 30 46 ?? ?? ?? ?? 64 1E F9 D1 17 F1 B8 00 ?? ?? ?? ?? 6E E7 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 9A F8 04 30 13 B9 50 46 ?? ?? ?? ?? D8 F8 00 30 00 2B DA F8 00 30 03 D1 00 2B 00 F0 5C 82 02 E0 00 2B 40 F0 58 82 FC 68 17 F1 98 01 20 46 ?? ?? ?? ?? 43 69 49 F0 04 05 BD 60 E3 B1 17 F1 B8 01 20 46 ?? ?? ?? ?? 83 69 4F F0 08 09 45 EA 09 05 BD 60 08 2B 01 D3 44 68 00 E0 04 1D 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 22 88 B8 F8 06 30 9A 42 03 D1 01 24 02 E0 4F F0 08 09 00 24 15 EA 09 0F 18 D0 D7 F8 D0 30 25 EA 09 05 08 2B 03 D3 D7 F8 BC 00 ?? ?? ?? ?? 07 23 D7 F8 B8 00 C7 F8 D0 30 00 23 C7 F8 CC 30 A7 F8 BC 30 ?? ?? ?? ?? 00 23 C7 F8 B8 30 25 F0 04 09 00 22 01 21 17 F1 98 00 C7 F8 18 90 C7 F8 08 90 ?? ?? ?? ?? D7 F8 98 00 ?? ?? ?? ?? C4 B1 40 46 ?? ?? ?? ?? FD 68 17 F1 B8 01 28 46 ?? ?? ?? ?? 01 46 17 F1 D8 00 ?? ?? ?? ?? 00 22 01 21 17 F1 B8 00 ?? ?? ?? ?? D7 F8 B8 00 ?? ?? ?? ?? E6 E1 FC 68 17 F1 98 01 20 46 ?? ?? ?? ?? 43 69 49 F0 10 05 BD 60 E3 B1 17 F1 B8 01 20 46 ?? ?? ?? ?? 83 69 4F F0 20 09 45 EA 09 05 BD 60 08 2B 01 D3 44 68 00 E0 04 1D 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 22 88 B8 F8 06 30 9A 42 03 D1 01 24 02 E0 4F F0 20 09 00 24 15 EA 09 0F 0E D0 00 22 01 21 17 F1 B8 00 25 EA 09 05 ?? ?? ?? ?? D7 F8 B8 00 ?? ?? ?? ?? 00 23 C7 F8 B8 30 25 F0 10 09 17 F1 98 00 C7 F8 18 90 C7 F8 08 90 ?? ?? ?? ?? 9C B1 40 46 ?? ?? ?? ?? F8 68 17 F1 B8 01 ?? ?? ?? ?? 01 46 17 F1 D8 00 ?? ?? ?? ?? 17 F1 B8 00 ?? ?? ?? ?? 01 22 BA 62 8A E1 FD 68 17 F1 B8 01 28 46 ?? ?? ?? ?? 43 69 0B B9 01 24 00 E0 00 24 17 F1 B8 00 ?? ?? ?? ?? 00 2C 40 F0 79 81 17 F1 B8 01 28 46 ?? ?? ?? ?? 43 69 0B B9 01 24 00 E0 00 24 17 F1 B8 00 ?? ?? ?? ?? 00 2C 00 F0 68 81 01 23 BB 62 64 E1 F8 68 17 F1 98 01 ?? ?? ?? ?? FB 6B 00 25 5B 69 23 42 2A D1 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 9A F8 04 30 13 B9 50 46 ?? ?? ?? ?? D8 F8 00 30 00 2B DA F8 00 30 01 D1 BB B1 00 E0 AB B9 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? D7 F8 B0 00 D7 F8 9C 10 B8 F8 06 20 08 28 28 BF 0B 46 01 D2 17 F1 9C 03 1B 88 9A 42 04 D0 3C E0 D7 F8 B0 00 D7 F8 9C 10 3B 68 03 2B 3D D1 D7 F8 EC 30 01 2B 39 D8 98 F8 04 30 33 B9 40 46 ?? ?? ?? ?? D7 F8 B0 00 D7 F8 9C 10 9A F8 04 30 33 B9 50 46 ?? ?? ?? ?? D7 F8 B0 00 D7 F8 9C 10 D8 F8 00 30 00 2B DA F8 00 30 01 D1 B3 B1 00 E0 A3 B9 98 F8 04 30 33 B9 40 46 ?? ?? ?? ?? D7 F8 B0 00 D7 F8 9C 10 08 28 B8 F8 06 20 28 BF 0B 46 01 D2 17 F1 9C 03 1B 88 9A 42 07 D0 08 28 01 D2 17 F1 9C 01 00 23 C7 F8 AC 30 0B 80 17 F1 78 01 17 F1 98 00 ?? ?? ?? ?? 03 68 13 B1 1B 68 03 B1 1D 68 84 68 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 9A F8 04 30 13 B9 50 46 ?? ?? ?? ?? D8 F8 00 30 00 2B DA F8 00 30 02 D1 00 2B 43 D0 01 E0 00 2B 40 D1 17 F1 88 01 17 F1 98 00 ?? ?? ?? ?? 49 F0 02 09 C7 F8 18 90 C7 F8 08 90 0D B9 00 22 00 E0 2A 68 03 68 0B B9 00 23 00 E0 1B 68 9A 42 40 F0 C9 80 83 68 9C 42 25 D0 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? B8 F8 06 00 00 2C 00 F0 B9 80 00 2D 00 F0 B4 80 2A 68 00 2A 00 F0 B0 80 93 69 08 2B 01 D3 51 68 00 E0 11 1D A1 42 00 F2 A5 80 53 69 01 EB 43 03 9C 42 80 F0 9F 80 23 88 98 42 08 BF 01 23 00 D0 00 23 02 22 19 EA 02 0F 05 D0 29 EA 02 09 C7 F8 18 90 C7 F8 08 90 D3 B1 00 2C 00 F0 97 80 00 2D 00 F0 92 80 2A 68 00 2A 00 F0 8E 80 93 69 08 2B 01 D3 51 68 00 E0 11 1D 53 69 01 EB 43 03 9C 42 80 F0 80 80 40 46 A4 1C ?? ?? ?? ?? 80 E7 17 F1 50 01 17 F1 98 00 ?? ?? ?? ?? 0D B9 00 22 00 E0 2A 68 03 68 0B B9 00 23 00 E0 1B 68 9A 42 6F D1 83 68 9C 42 01 D0 01 23 3B 61 D7 F8 B0 30 08 2B 03 D3 D7 F8 9C 00 ?? ?? ?? ?? 07 23 C7 F8 B0 30 00 23 D7 F8 98 00 C7 F8 AC 30 A7 F8 9C 30 4C E6 3B 68 03 2B 35 D0 51 46 40 46 00 26 ?? ?? ?? ?? 00 B3 D7 F8 40 90 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? D9 F8 00 30 B8 F8 06 50 1C 69 20 46 ?? ?? ?? ?? 48 46 48 21 2A 46 A0 47 48 B1 40 46 01 26 ?? ?? ?? ?? 51 46 40 46 ?? ?? ?? ?? 00 28 E2 D1 D7 F8 18 90 3B 68 3A 1D 9B 56 20 2B 05 D1 3B 68 0E B9 01 26 3E 61 3E 6A 03 E0 3E 6A 00 E0 3A 1D 3B 68 5B 1C 3B 60 3B 69 00 2B 6F D1 3B 68 08 24 FF F7 D8 BB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D7 F8 EC 30 01 2B 59 D9 00 23 17 F1 50 01 17 F1 D8 00 C7 E9 0C 33 BB 63 ?? ?? ?? ?? 03 68 1B B1 1B 68 0B B1 1B 68 3B 63 83 68 BB 63 17 F1 50 01 17 F1 D8 00 ?? ?? ?? ?? 04 46 49 F0 40 05 17 F1 30 00 BD 60 ?? ?? ?? ?? 21 46 ?? ?? ?? ?? A8 B1 51 46 40 46 ?? ?? ?? ?? 80 B1 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? B8 F8 06 40 17 F1 30 00 ?? ?? ?? ?? 03 88 9C 42 08 BF 01 23 00 D0 00 23 25 F0 40 09 C7 F8 08 90 1B B1 40 46 ?? ?? ?? ?? CD E7 17 F1 50 01 17 F1 D8 00 ?? ?? ?? ?? 01 46 17 F1 30 00 ?? ?? ?? ?? 48 B1 B3 69 10 2B 01 D3 73 68 00 E0 33 1D 00 22 72 61 1A 70 07 E0 BB 6A 2B B1 2D 23 01 22 00 21 30 46 ?? ?? ?? ?? 17 F1 D8 00 ?? ?? ?? ?? 30 46 3E B0 ?? ?? ?? ?? BD E8 F0 8F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_730_1 {
	meta:
		name = "?_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0_NAAVios_base@2@PA_W@Z"
		size = 2804
		refs = "0008 __security_push_cookie 0044 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0048 ??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 005a _guard_check_icall 0080 ??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 00be ??2@YAPAXI@Z 00c4 _invalid_parameter_noinfo_noreturn 0140 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 01da ?grouping@?$_Mpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0220 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 022c ??$?9_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 023a ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 0264 ??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@D@Z 02e2 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 02ec ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ 03a2 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 0522 ?positive_sign@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 0586 ??3@YAXPAX@Z 05bc ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 05e2 ??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV01@$$QAV01@@Z 0604 ?negative_sign@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 0686 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ 0706 ?curr_symbol@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 07fc ?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0842 ?end@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0a54 ??E?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@XZ 0a5a ??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA_NABV01@@Z 0a7e ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAAB_WXZ 0ad8 ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@IID@Z 0ae8 __security_pop_cookie 0af0 ?_Src@?1??_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@3@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@0_NAAVios_base@3@PA_W@Z@4QBDB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? BE B0 6F 46 9A 46 FB 61 6F F0 01 03 0E 46 C7 E9 1C 33 90 46 7A 61 3E 62 D7 F8 24 31 D7 F8 28 21 97 F8 20 01 7A 62 00 22 00 28 BA 60 18 46 FE 65 FB 63 1B D0 17 F1 60 01 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 F8 60 7D 6E 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 1A E0 17 F1 68 01 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 F8 60 FD 6E 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 00 23 3B 61 BB 62 08 20 C7 F8 D8 30 C7 E9 3B 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 C7 F8 D8 00 C0 E9 00 32 D7 F8 D8 30 17 F1 D8 02 1A 60 07 23 C7 F8 F0 30 00 23 C7 F8 EC 30 A7 F8 DC 30 D9 F8 00 30 DC 6A 20 46 ?? ?? ?? ?? 48 46 39 1D A0 47 00 24 08 20 34 60 C6 E9 05 44 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 30 60 C0 E9 00 32 33 68 1E 60 0F 23 C6 E9 05 43 34 71 F8 6B 4F F0 01 09 17 F1 30 01 C7 F8 18 90 C7 F8 08 90 ?? ?? ?? ?? ?? ?? ?? ?? 38 64 7D 6B 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 3D 6C 2B 68 DC 6A 20 46 ?? ?? ?? ?? DF F8 74 39 28 46 19 46 03 F1 0C 02 7B 6A A0 47 00 23 08 24 3B 60 3A 1D 04 2B 80 F0 3D 84 9B 56 20 2B 00 F0 DF 83 24 2B 00 F0 AE 82 2B 2B 00 F0 9F 81 76 2B 04 D0 78 2B 00 F0 D4 83 00 F0 0A BC FD 68 4F F0 00 09 2B 68 C7 F8 44 90 5C 6A 20 46 ?? ?? ?? ?? 28 46 A0 47 82 46 B8 64 28 46 17 F1 B8 01 ?? ?? ?? ?? D7 F8 CC 30 00 2B 00 F0 F4 80 2B 68 1C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 80 46 00 28 00 F0 E7 80 D7 F8 D0 30 10 2B 02 D3 D7 F8 BC 30 01 E0 17 F1 BC 03 1B 78 7F 2B 80 F0 DA 80 00 22 01 21 17 F1 98 00 ?? ?? ?? ?? 7C 69 F9 69 00 26 20 46 ?? ?? ?? ?? 00 28 7B D0 23 79 13 B9 20 46 ?? ?? ?? ?? 78 6A E1 88 03 88 02 46 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 13 1A 5B 10 0A 2B 1F D2 DF F8 90 28 38 6A 99 56 ?? ?? ?? ?? D7 F8 AC 30 9E 42 00 F2 B7 83 D7 F8 B0 10 D7 F8 9C 20 10 29 28 BF 13 46 01 D2 17 F1 9C 03 9B 57 7F 2B 2E D0 10 29 01 D2 17 F1 9C 02 93 5D 5B 1C 93 55 26 E0 D7 F8 AC 50 AE 42 00 F2 A1 83 D7 F8 B0 40 D7 F8 9C 00 10 2C 28 BF 03 46 01 D2 17 F1 9C 03 9B 57 13 B3 7A 69 13 79 3B B9 10 46 ?? ?? ?? ?? D7 E9 2B 54 D7 F8 9C 00 7A 69 D3 88 43 45 14 D1 00 22 01 21 17 F1 98 00 ?? ?? ?? ?? 7C 69 76 1C 20 46 ?? ?? ?? ?? F9 69 20 46 ?? ?? ?? ?? 00 28 9B D1 D7 E9 2B 54 D7 F8 9C 00 B6 B1 AE 42 00 F2 6C 83 10 2C 28 BF 03 46 01 D2 17 F1 9C 03 9B 57 00 2B C8 BF 76 1C 08 DC 4F F0 01 08 C7 F8 10 80 05 E0 D7 E9 2B 54 D7 F8 9C 00 D7 F8 10 80 D7 F8 D0 30 10 2B 02 D3 D7 F8 BC 10 01 E0 17 F1 BC 01 B8 F1 00 0F 2F D1 2E B3 91 F9 00 20 7F 2A 21 D0 76 1E 0B D0 AE 42 00 F2 44 83 10 2C 28 BF 03 46 01 D2 17 F1 9C 03 9B 57 9A 42 10 D1 4E B9 10 2C 28 BF 03 46 01 D2 17 F1 9C 03 93 F9 00 30 9A 42 05 DB 91 F9 01 30 00 2B DD DD 49 1C DB E7 01 23 3B 61 08 E0 17 F1 98 00 ?? ?? ?? ?? D7 F8 14 80 D7 E9 07 56 40 E0 17 F1 98 00 ?? ?? ?? ?? 17 F1 B8 00 ?? ?? ?? ?? D7 F8 14 80 3E 6A D7 E9 06 9A FE E2 D7 F8 14 80 FD 69 40 46 29 46 ?? ?? ?? ?? 50 B3 D7 F8 24 A0 DF F8 0C 97 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? B8 F8 06 10 BA F8 00 30 52 46 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 A2 EB 0A 03 5B 10 0A 2B 0D D2 13 F9 09 10 30 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 29 46 40 46 ?? ?? ?? ?? 00 28 DA D1 D7 E9 11 9A FB 68 1B 68 DC 68 20 46 ?? ?? ?? ?? F8 68 A0 47 04 46 40 46 29 46 ?? ?? ?? ?? C0 B3 BC B3 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? B8 F8 06 30 A3 42 2D D1 1F E0 D1 45 2A DA 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 78 6A B8 F8 06 10 03 88 02 46 03 E0 8B 42 03 D0 92 1C 13 88 00 2B F9 D1 13 1A 5B 10 0A 2B 10 D2 DF F8 58 26 30 46 99 56 ?? ?? ?? ?? 09 F1 01 09 40 46 ?? ?? ?? ?? 29 46 40 46 ?? ?? ?? ?? 00 28 D6 D1 D1 45 01 DA 01 23 3B 61 73 69 13 B9 01 23 3B 61 09 E0 D1 45 07 DA AA EB 09 04 30 21 30 46 ?? ?? ?? ?? 64 1E F9 D1 17 F1 B8 00 ?? ?? ?? ?? 6E E7 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 9A F8 04 30 13 B9 50 46 ?? ?? ?? ?? D8 F8 00 30 00 2B DA F8 00 30 03 D1 00 2B 00 F0 5C 82 02 E0 00 2B 40 F0 58 82 FC 68 17 F1 98 01 20 46 ?? ?? ?? ?? 43 69 49 F0 04 05 BD 60 E3 B1 17 F1 B8 01 20 46 ?? ?? ?? ?? 83 69 4F F0 08 09 45 EA 09 05 BD 60 08 2B 01 D3 44 68 00 E0 04 1D 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 22 88 B8 F8 06 30 9A 42 03 D1 01 24 02 E0 4F F0 08 09 00 24 15 EA 09 0F 18 D0 D7 F8 D0 30 25 EA 09 05 08 2B 03 D3 D7 F8 BC 00 ?? ?? ?? ?? 07 23 D7 F8 B8 00 C7 F8 D0 30 00 23 C7 F8 CC 30 A7 F8 BC 30 ?? ?? ?? ?? 00 23 C7 F8 B8 30 25 F0 04 09 00 22 01 21 17 F1 98 00 C7 F8 18 90 C7 F8 08 90 ?? ?? ?? ?? D7 F8 98 00 ?? ?? ?? ?? C4 B1 40 46 ?? ?? ?? ?? FD 68 17 F1 B8 01 28 46 ?? ?? ?? ?? 01 46 17 F1 D8 00 ?? ?? ?? ?? 00 22 01 21 17 F1 B8 00 ?? ?? ?? ?? D7 F8 B8 00 ?? ?? ?? ?? E6 E1 FC 68 17 F1 98 01 20 46 ?? ?? ?? ?? 43 69 49 F0 10 05 BD 60 E3 B1 17 F1 B8 01 20 46 ?? ?? ?? ?? 83 69 4F F0 20 09 45 EA 09 05 BD 60 08 2B 01 D3 44 68 00 E0 04 1D 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 22 88 B8 F8 06 30 9A 42 03 D1 01 24 02 E0 4F F0 20 09 00 24 15 EA 09 0F 0E D0 00 22 01 21 17 F1 B8 00 25 EA 09 05 ?? ?? ?? ?? D7 F8 B8 00 ?? ?? ?? ?? 00 23 C7 F8 B8 30 25 F0 10 09 17 F1 98 00 C7 F8 18 90 C7 F8 08 90 ?? ?? ?? ?? 9C B1 40 46 ?? ?? ?? ?? F8 68 17 F1 B8 01 ?? ?? ?? ?? 01 46 17 F1 D8 00 ?? ?? ?? ?? 17 F1 B8 00 ?? ?? ?? ?? 01 22 BA 62 8A E1 FD 68 17 F1 B8 01 28 46 ?? ?? ?? ?? 43 69 0B B9 01 24 00 E0 00 24 17 F1 B8 00 ?? ?? ?? ?? 00 2C 40 F0 79 81 17 F1 B8 01 28 46 ?? ?? ?? ?? 43 69 0B B9 01 24 00 E0 00 24 17 F1 B8 00 ?? ?? ?? ?? 00 2C 00 F0 68 81 01 23 BB 62 64 E1 F8 68 17 F1 98 01 ?? ?? ?? ?? FB 6B 00 25 5B 69 23 42 2A D1 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 9A F8 04 30 13 B9 50 46 ?? ?? ?? ?? D8 F8 00 30 00 2B DA F8 00 30 01 D1 BB B1 00 E0 AB B9 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? D7 F8 B0 00 D7 F8 9C 10 B8 F8 06 20 08 28 28 BF 0B 46 01 D2 17 F1 9C 03 1B 88 9A 42 04 D0 3C E0 D7 F8 B0 00 D7 F8 9C 10 3B 68 03 2B 3D D1 D7 F8 EC 30 01 2B 39 D8 98 F8 04 30 33 B9 40 46 ?? ?? ?? ?? D7 F8 B0 00 D7 F8 9C 10 9A F8 04 30 33 B9 50 46 ?? ?? ?? ?? D7 F8 B0 00 D7 F8 9C 10 D8 F8 00 30 00 2B DA F8 00 30 01 D1 B3 B1 00 E0 A3 B9 98 F8 04 30 33 B9 40 46 ?? ?? ?? ?? D7 F8 B0 00 D7 F8 9C 10 08 28 B8 F8 06 20 28 BF 0B 46 01 D2 17 F1 9C 03 1B 88 9A 42 07 D0 08 28 01 D2 17 F1 9C 01 00 23 C7 F8 AC 30 0B 80 17 F1 78 01 17 F1 98 00 ?? ?? ?? ?? 03 68 13 B1 1B 68 03 B1 1D 68 84 68 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? 9A F8 04 30 13 B9 50 46 ?? ?? ?? ?? D8 F8 00 30 00 2B DA F8 00 30 02 D1 00 2B 43 D0 01 E0 00 2B 40 D1 17 F1 88 01 17 F1 98 00 ?? ?? ?? ?? 49 F0 02 09 C7 F8 18 90 C7 F8 08 90 0D B9 00 22 00 E0 2A 68 03 68 0B B9 00 23 00 E0 1B 68 9A 42 40 F0 C9 80 83 68 9C 42 25 D0 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? B8 F8 06 00 00 2C 00 F0 B9 80 00 2D 00 F0 B4 80 2A 68 00 2A 00 F0 B0 80 93 69 08 2B 01 D3 51 68 00 E0 11 1D A1 42 00 F2 A5 80 53 69 01 EB 43 03 9C 42 80 F0 9F 80 23 88 98 42 08 BF 01 23 00 D0 00 23 02 22 19 EA 02 0F 05 D0 29 EA 02 09 C7 F8 18 90 C7 F8 08 90 D3 B1 00 2C 00 F0 97 80 00 2D 00 F0 92 80 2A 68 00 2A 00 F0 8E 80 93 69 08 2B 01 D3 51 68 00 E0 11 1D 53 69 01 EB 43 03 9C 42 80 F0 80 80 40 46 A4 1C ?? ?? ?? ?? 80 E7 17 F1 50 01 17 F1 98 00 ?? ?? ?? ?? 0D B9 00 22 00 E0 2A 68 03 68 0B B9 00 23 00 E0 1B 68 9A 42 6F D1 83 68 9C 42 01 D0 01 23 3B 61 D7 F8 B0 30 08 2B 03 D3 D7 F8 9C 00 ?? ?? ?? ?? 07 23 C7 F8 B0 30 00 23 D7 F8 98 00 C7 F8 AC 30 A7 F8 9C 30 4C E6 3B 68 03 2B 35 D0 51 46 40 46 00 26 ?? ?? ?? ?? 00 B3 D7 F8 40 90 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? D9 F8 00 30 B8 F8 06 50 1C 69 20 46 ?? ?? ?? ?? 48 46 48 21 2A 46 A0 47 48 B1 40 46 01 26 ?? ?? ?? ?? 51 46 40 46 ?? ?? ?? ?? 00 28 E2 D1 D7 F8 18 90 3B 68 3A 1D 9B 56 20 2B 05 D1 3B 68 0E B9 01 26 3E 61 3E 6A 03 E0 3E 6A 00 E0 3A 1D 3B 68 5B 1C 3B 60 3B 69 00 2B 6F D1 3B 68 08 24 FF F7 D8 BB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D7 F8 EC 30 01 2B 59 D9 00 23 17 F1 50 01 17 F1 D8 00 C7 E9 0C 33 BB 63 ?? ?? ?? ?? 03 68 1B B1 1B 68 0B B1 1B 68 3B 63 83 68 BB 63 17 F1 50 01 17 F1 D8 00 ?? ?? ?? ?? 04 46 49 F0 40 05 17 F1 30 00 BD 60 ?? ?? ?? ?? 21 46 ?? ?? ?? ?? A8 B1 51 46 40 46 ?? ?? ?? ?? 80 B1 98 F8 04 30 13 B9 40 46 ?? ?? ?? ?? B8 F8 06 40 17 F1 30 00 ?? ?? ?? ?? 03 88 9C 42 08 BF 01 23 00 D0 00 23 25 F0 40 09 C7 F8 08 90 1B B1 40 46 ?? ?? ?? ?? CD E7 17 F1 50 01 17 F1 D8 00 ?? ?? ?? ?? 01 46 17 F1 30 00 ?? ?? ?? ?? 48 B1 B3 69 10 2B 01 D3 73 68 00 E0 33 1D 00 22 72 61 1A 70 07 E0 BB 6A 2B B1 2D 23 01 22 00 21 30 46 ?? ?? ?? ?? 17 F1 D8 00 ?? ?? ?? ?? 30 46 3E B0 ?? ?? ?? ?? BD E8 F0 8F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_720_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0_NAAVios_base@2@PAG@Z$3"
		size = 30
		refs = "0018 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ"
		altNames = "__unwindfunclet$?_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0_NAAVios_base@2@PA_W@Z$3"
	strings:
		$1 = { 10 B5 BB 68 03 F0 01 03 00 2B 00 F0 07 80 BB 68 23 F0 01 03 BB 60 F8 6D ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_725_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0_NAAVios_base@2@PAG@Z$6"
		size = 32
		refs = "001a ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 BB 68 03 F0 04 03 00 2B 00 F0 08 80 BB 68 23 F0 04 03 BB 60 17 F1 98 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_743_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0_NAAVios_base@2@PA_W@Z$6"
		size = 32
		refs = "001a ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 BB 68 03 F0 04 03 00 2B 00 F0 08 80 BB 68 23 F0 04 03 BB 60 17 F1 98 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_726_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0_NAAVios_base@2@PAG@Z$7"
		size = 32
		refs = "001a ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 BB 68 03 F0 08 03 00 2B 00 F0 08 80 BB 68 23 F0 08 03 BB 60 17 F1 B8 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_744_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0_NAAVios_base@2@PA_W@Z$7"
		size = 32
		refs = "001a ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 BB 68 03 F0 08 03 00 2B 00 F0 08 80 BB 68 23 F0 08 03 BB 60 17 F1 B8 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_727_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0_NAAVios_base@2@PAG@Z$9"
		size = 32
		refs = "001a ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 BB 68 03 F0 10 03 00 2B 00 F0 08 80 BB 68 23 F0 10 03 BB 60 17 F1 98 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_745_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0_NAAVios_base@2@PA_W@Z$9"
		size = 32
		refs = "001a ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 BB 68 03 F0 10 03 00 2B 00 F0 08 80 BB 68 23 F0 10 03 BB 60 17 F1 98 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_728_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0_NAAVios_base@2@PAG@Z$10"
		size = 32
		refs = "001a ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 BB 68 03 F0 20 03 00 2B 00 F0 08 80 BB 68 23 F0 20 03 BB 60 17 F1 B8 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_746_1 {
	meta:
		name = "__unwindfunclet$?_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0_NAAVios_base@2@PA_W@Z$10"
		size = 32
		refs = "001a ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 BB 68 03 F0 20 03 00 2B 00 F0 08 80 BB 68 23 F0 20 03 BB 60 17 F1 B8 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_748_1 {
	meta:
		name = "?_Getmonths@_Locinfo@std@@QBAPBDXZ"
		size = 104
		refs = "000a _Getmonths 001a free 0038 malloc 0044 memcpy 0064 ??_C@_0IH@HPGJLCCK@?3Jan?3January?3Feb?3February?3Mar?3Ma@"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 ?? ?? ?? ?? 05 46 ED B1 E0 68 A8 42 17 D0 08 B1 ?? ?? ?? ?? 00 23 E3 60 95 F9 00 30 2A 46 02 E0 52 1C 92 F9 00 30 00 2B FA D1 56 1B 70 1C ?? ?? ?? ?? E0 60 18 B1 72 1C 29 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? E3 68 23 B1 18 46 18 B9 04 F1 10 00 00 E0 01 48 BD E8 78 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_753_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ"
		size = 26
		altNames = "?_Gninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 C2 6A 13 68 5B 1E 13 60 C2 69 10 68 83 1C 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_756_1 {
	meta:
		name = "?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z"
		size = 128
		refs = "001e ?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXII@Z 0040 memcpy 0046 ??3@YAXPAX@Z 007a ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 4F F0 00 43 9B 1E 0D 46 9D 42 04 46 30 D8 A3 69 AB 42 03 D2 62 69 ?? ?? ?? ?? 23 E0 CA B1 08 2D 17 D2 66 69 B5 42 38 BF 2E 46 08 2B 09 D3 67 68 26 B1 72 00 20 1D 39 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? 07 23 C4 E9 05 63 23 1D 00 22 23 F8 16 20 08 E0 45 B9 08 2B 01 D3 63 68 00 E0 23 1D 00 22 62 61 1A 80 0D B1 01 20 00 E0 00 20 BD E8 F0 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_757_1 {
	meta:
		name = "?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z"
		size = 128
		refs = "001e ?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII@Z 0040 memcpy 0046 ??3@YAXPAX@Z 007a ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 4F F0 00 43 9B 1E 0D 46 9D 42 04 46 30 D8 A3 69 AB 42 03 D2 62 69 ?? ?? ?? ?? 23 E0 CA B1 08 2D 17 D2 66 69 B5 42 38 BF 2E 46 08 2B 09 D3 67 68 26 B1 72 00 20 1D 39 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? 07 23 C4 E9 05 63 23 1D 00 22 23 F8 16 20 08 E0 45 B9 08 2B 01 D3 63 68 00 E0 23 1D 00 22 62 61 1A 80 0D B1 01 20 00 E0 00 20 BD E8 F0 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_758_1 {
	meta:
		name = "?_Hash_seq@std@@YAIPBEI@Z"
		size = 44
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 07 48 00 22 39 B1 04 4C 53 5D 52 1C 43 40 03 FB 04 F0 8A 42 F8 D3 BD E8 30 88 93 01 00 01 C5 9D 1C 81 }
	condition:
		$1
}

rule file_17_761_1 {
	meta:
		name = "?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ"
		size = 90
		refs = "003a _guard_check_icall"
		altNames = "?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2E 68 FE B1 F3 69 1B 68 13 B1 F3 6A 1B 68 00 E0 00 23 00 2B 09 DD F2 6A 13 68 5B 1E 13 60 F2 69 11 68 8B 1C 13 60 08 88 06 E0 33 68 DC 69 20 46 ?? ?? ?? ?? 30 46 A0 47 4F F6 FF 73 98 42 18 BF 00 23 02 D1 00 23 2B 60 01 23 2B 71 BD E8 78 88 }
	condition:
		$1
}

rule file_17_765_1 {
	meta:
		name = "?_Init@?$_Mpunct@G@std@@IAAXABV_Locinfo@2@_N@Z"
		size = 364
		refs = "001e _Getcvt 002c memcpy 0030 localeconv 004a strlen 0056 calloc 005c ?_Xbad_alloc@std@@YAXXZ 0080 ??$_Getvals@G@?$_Mpunct@G@std@@IAAXGPBUlconv@@@Z 00f2 _errno 00fa _invalid_parameter_noinfo 0164 ??_C@_0HJ@PJOMAIHM@?$CLv$x?$CLv$xv$?$CLxv?$CL$xv$?$CLx?$CL$vx?$CL$vx$v?$CLx@ 0168 ??_C@_04FJCIEOIB@$?$CLxv?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8F B0 6F 46 04 46 6F F0 01 03 3C 60 17 F1 10 00 92 46 C7 E9 02 33 ?? ?? ?? ?? 04 F1 2C 00 17 F1 10 01 2C 22 ?? ?? ?? ?? ?? ?? ?? ?? 4F F0 00 09 C4 F8 08 90 C4 E9 04 99 C4 F8 18 90 05 46 EE 69 30 46 ?? ?? ?? ?? 00 F1 01 08 40 46 01 21 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? B8 F1 00 0F 08 D0 82 1B 33 78 A8 F1 01 08 93 55 76 1C B8 F1 00 0F F7 D1 A0 60 20 46 2A 46 00 21 ?? ?? ?? ?? 94 F8 28 20 12 B1 95 F9 28 30 01 E0 95 F9 29 30 E3 61 00 2B 01 DB 7F 2B 01 DB C4 F8 1C 90 95 F9 2E 10 95 F9 2A 30 95 F9 2B 00 8A B9 02 28 0F D8 01 2B 0D D8 04 29 0B D8 03 EB 40 03 DF F8 A0 90 03 EB 83 03 0B 44 DF F8 9C 80 09 EB 83 03 04 E0 DF F8 90 80 DF F8 88 90 43 46 14 F1 20 02 06 D0 1B B1 1B 68 16 26 13 60 07 E0 00 23 13 60 ?? ?? ?? ?? 16 26 06 60 ?? ?? ?? ?? 94 F8 28 30 95 F9 2F 20 95 F9 2C 10 95 F9 2D 00 63 B9 02 28 0A D8 01 29 08 D8 04 2A 06 D8 01 EB 40 03 03 EB 83 03 13 44 09 EB 83 08 14 F1 24 02 08 D0 B8 F1 00 0F 03 D0 D8 F8 00 30 13 60 06 E0 00 23 13 60 ?? ?? ?? ?? 06 60 ?? ?? ?? ?? BA F1 00 0F 02 D0 03 4B C4 E9 08 33 0F B0 BD E8 F0 8F FE DE 24 2B 78 76 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_331_1 {
	meta:
		name = "?_Init@?$_Mpunct@D@std@@IAAXABV_Locinfo@2@_N@Z"
		size = 364
		refs = "001e _Getcvt 002c memcpy 0030 localeconv 004a strlen 0056 calloc 005c ?_Xbad_alloc@std@@YAXXZ 0080 ??$_Getvals@D@?$_Mpunct@D@std@@IAAXDPBUlconv@@@Z 00f2 _errno 00fa _invalid_parameter_noinfo 0164 ??_C@_0HJ@PJOMAIHM@?$CLv$x?$CLv$xv$?$CLxv?$CL$xv$?$CLx?$CL$vx?$CL$vx$v?$CLx@ 0168 ??_C@_04FJCIEOIB@$?$CLxv?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8F B0 6F 46 04 46 6F F0 01 03 3C 60 17 F1 10 00 92 46 C7 E9 02 33 ?? ?? ?? ?? 04 F1 2C 00 17 F1 10 01 2C 22 ?? ?? ?? ?? ?? ?? ?? ?? 4F F0 00 09 C4 F8 08 90 C4 E9 04 99 C4 F8 18 90 05 46 EE 69 30 46 ?? ?? ?? ?? 00 F1 01 08 40 46 01 21 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? B8 F1 00 0F 08 D0 82 1B 33 78 A8 F1 01 08 93 55 76 1C B8 F1 00 0F F7 D1 A0 60 20 46 2A 46 00 21 ?? ?? ?? ?? 94 F8 28 20 12 B1 95 F9 28 30 01 E0 95 F9 29 30 E3 61 00 2B 01 DB 7F 2B 01 DB C4 F8 1C 90 95 F9 2E 10 95 F9 2A 30 95 F9 2B 00 8A B9 02 28 0F D8 01 2B 0D D8 04 29 0B D8 03 EB 40 03 DF F8 A0 90 03 EB 83 03 0B 44 DF F8 9C 80 09 EB 83 03 04 E0 DF F8 90 80 DF F8 88 90 43 46 14 F1 20 02 06 D0 1B B1 1B 68 16 26 13 60 07 E0 00 23 13 60 ?? ?? ?? ?? 16 26 06 60 ?? ?? ?? ?? 94 F8 28 30 95 F9 2F 20 95 F9 2C 10 95 F9 2D 00 63 B9 02 28 0A D8 01 29 08 D8 04 2A 06 D8 01 EB 40 03 03 EB 83 03 13 44 09 EB 83 08 14 F1 24 02 08 D0 B8 F1 00 0F 03 D0 D8 F8 00 30 13 60 06 E0 00 23 13 60 ?? ?? ?? ?? 06 60 ?? ?? ?? ?? BA F1 00 0F 02 D0 03 4B C4 E9 08 33 0F B0 BD E8 F0 8F FE DE 24 2B 78 76 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_767_1 {
	meta:
		name = "?_Init@?$_Mpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z"
		size = 364
		refs = "001e _Getcvt 002c memcpy 0030 localeconv 004a strlen 0056 calloc 005c ?_Xbad_alloc@std@@YAXXZ 0080 ??$_Getvals@_W@?$_Mpunct@_W@std@@IAAX_WPBUlconv@@@Z 00f2 _errno 00fa _invalid_parameter_noinfo 0164 ??_C@_0HJ@PJOMAIHM@?$CLv$x?$CLv$xv$?$CLxv?$CL$xv$?$CLx?$CL$vx?$CL$vx$v?$CLx@ 0168 ??_C@_04FJCIEOIB@$?$CLxv?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8F B0 6F 46 04 46 6F F0 01 03 3C 60 17 F1 10 00 92 46 C7 E9 02 33 ?? ?? ?? ?? 04 F1 2C 00 17 F1 10 01 2C 22 ?? ?? ?? ?? ?? ?? ?? ?? 4F F0 00 09 C4 F8 08 90 C4 E9 04 99 C4 F8 18 90 05 46 EE 69 30 46 ?? ?? ?? ?? 00 F1 01 08 40 46 01 21 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? B8 F1 00 0F 08 D0 82 1B 33 78 A8 F1 01 08 93 55 76 1C B8 F1 00 0F F7 D1 A0 60 20 46 2A 46 00 21 ?? ?? ?? ?? 94 F8 28 20 12 B1 95 F9 28 30 01 E0 95 F9 29 30 E3 61 00 2B 01 DB 7F 2B 01 DB C4 F8 1C 90 95 F9 2E 10 95 F9 2A 30 95 F9 2B 00 8A B9 02 28 0F D8 01 2B 0D D8 04 29 0B D8 03 EB 40 03 DF F8 A0 90 03 EB 83 03 0B 44 DF F8 9C 80 09 EB 83 03 04 E0 DF F8 90 80 DF F8 88 90 43 46 14 F1 20 02 06 D0 1B B1 1B 68 16 26 13 60 07 E0 00 23 13 60 ?? ?? ?? ?? 16 26 06 60 ?? ?? ?? ?? 94 F8 28 30 95 F9 2F 20 95 F9 2C 10 95 F9 2D 00 63 B9 02 28 0A D8 01 29 08 D8 04 2A 06 D8 01 EB 40 03 03 EB 83 03 13 44 09 EB 83 08 14 F1 24 02 08 D0 B8 F1 00 0F 03 D0 D8 F8 00 30 13 60 06 E0 00 23 13 60 ?? ?? ?? ?? 06 60 ?? ?? ?? ?? BA F1 00 0F 02 D0 03 4B C4 E9 08 33 0F B0 BD E8 F0 8F FE DE 24 2B 78 76 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_769_1 {
	meta:
		name = "?_Init@?$codecvt@GDU_Mbstatet@@@std@@IAAXABV_Locinfo@2@@Z"
		size = 36
		refs = "000e _Getcvt 001a memcpy"
		altNames = "?_Init@?$codecvt@_WDU_Mbstatet@@@std@@IAAXABV_Locinfo@2@@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8B B0 04 46 68 46 ?? ?? ?? ?? 69 46 2C 22 04 F1 08 00 ?? ?? ?? ?? 0B B0 BD E8 10 88 }
	condition:
		$1
}

rule file_17_771_1 {
	meta:
		name = "?_Init@?$collate@G@std@@IAAXABV_Locinfo@2@@Z"
		size = 28
		refs = "000c _Getcoll"
		altNames = "?_Init@?$collate@D@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$collate@_W@std@@IAAXABV_Locinfo@2@@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 04 46 68 46 ?? ?? ?? ?? 00 9B A3 60 01 9B E3 60 BD E8 1E 88 }
	condition:
		$1
}

rule file_17_773_1 {
	meta:
		name = "?_Init@?$ctype@G@std@@IAAXABV_Locinfo@2@@Z"
		size = 52
		refs = "000e _Getctype 001e _Getcvt 002a memcpy"
		altNames = "?_Init@?$ctype@_W@std@@IAAXABV_Locinfo@2@@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 90 B0 07 46 68 46 ?? ?? ?? ?? 6D 46 1E CD 07 F1 08 06 1E C6 04 A8 ?? ?? ?? ?? 04 A9 2C 22 07 F1 18 00 ?? ?? ?? ?? 10 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_17_785_1 {
	meta:
		name = "?_Init@?$numpunct@G@std@@IAAXABV_Locinfo@2@_N@Z"
		size = 284
		refs = "0008 __security_push_cookie 0020 localeconv 002a _Getcvt 0038 memcpy 005c strlen 0066 calloc 006c ?_Xbad_alloc@std@@YAXXZ 008a ??$_Maklocstr@G@std@@YAPAGPBDPAGABU_Cvtvec@@@Z 00c0 _Mbrtowc 0102 ??$_Getvals@G@?$numpunct@G@std@@IAAXGPBUlconv@@U_Cvtvec@@@Z 0108 __security_pop_cookie 0110 ??_C@_04LOAJBDKD@true?$AA@ 0114 ??_C@_05LAPONLG@false?$AA@ 0118 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? 9D B0 6F 46 8A B0 6F F0 01 03 05 46 C7 E9 04 33 7D 60 90 46 ?? ?? ?? ?? 81 46 17 F1 18 00 ?? ?? ?? ?? 17 F1 48 00 17 F1 18 01 2C 22 ?? ?? ?? ?? 00 23 AB 60 C5 E9 04 33 17 F1 18 00 ?? ?? ?? ?? B8 F1 00 0F 01 D0 31 4C 01 E0 D9 F8 08 40 20 46 ?? ?? ?? ?? 46 1C 30 46 01 21 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 36 B1 02 1B 23 78 76 1E 13 55 64 1C 00 2E F9 D1 A8 60 24 48 17 F1 48 02 00 21 ?? ?? ?? ?? 28 61 1F 48 17 F1 48 02 00 21 ?? ?? ?? ?? 68 61 B8 F1 00 0F 24 D0 2E 23 3B 70 00 23 BB 80 C7 E9 02 33 17 F1 48 03 00 93 17 F1 08 03 39 46 38 1D 01 22 ?? ?? ?? ?? BB 88 39 46 38 1D AB 81 2C 23 3B 70 00 23 BB 80 C7 E9 02 33 17 F1 48 03 00 93 17 F1 08 03 01 22 ?? ?? ?? ?? BB 88 EB 81 0B E0 68 46 17 F1 4C 01 28 22 ?? ?? ?? ?? BB 6C 4A 46 00 21 28 46 ?? ?? ?? ?? 27 B0 ?? ?? ?? ?? BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_786_1 {
	meta:
		name = "__catch$?_Init@?$numpunct@G@std@@IAAXABV_Locinfo@2@_N@Z$0"
		size = 20
		refs = "0006 ?_Tidy@?$numpunct@G@std@@AAAXXZ 000e _CxxThrowException"
	strings:
		$1 = { 10 B5 8A B0 78 68 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_787_1 {
	meta:
		name = "?_Init@?$numpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z"
		size = 276
		refs = "0008 __security_push_cookie 0020 localeconv 002a _Getcvt 0038 memcpy 005c strlen 0066 calloc 006c ?_Xbad_alloc@std@@YAXXZ 008a ??$_Maklocstr@_W@std@@YAPA_WPBDPA_WABU_Cvtvec@@@Z 00c0 _Mbrtowc 00fe __security_pop_cookie 0108 ??_C@_04LOAJBDKD@true?$AA@ 010c ??_C@_05LAPONLG@false?$AA@ 0110 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? 9D B0 6F 46 82 B0 6F F0 01 03 05 46 C7 E9 04 33 7D 60 91 46 ?? ?? ?? ?? 80 46 17 F1 18 00 ?? ?? ?? ?? 17 F1 48 00 17 F1 18 01 2C 22 ?? ?? ?? ?? 00 23 AB 60 C5 E9 04 33 17 F1 18 00 ?? ?? ?? ?? B9 F1 00 0F 01 D0 2F 4C 01 E0 D8 F8 08 40 20 46 ?? ?? ?? ?? 46 1C 30 46 01 21 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 36 B1 02 1B 23 78 76 1E 13 55 64 1C 00 2E F9 D1 A8 60 22 48 17 F1 48 02 00 21 ?? ?? ?? ?? 28 61 1D 48 17 F1 48 02 00 21 ?? ?? ?? ?? 68 61 B9 F1 00 0F 23 D0 2E 23 3B 70 00 23 BB 80 C7 E9 02 33 17 F1 48 03 00 93 17 F1 08 03 39 46 38 1D 01 22 ?? ?? ?? ?? BB 88 39 46 38 1D AB 81 2C 23 3B 70 00 23 BB 80 C7 E9 02 33 17 F1 48 03 00 93 17 F1 08 03 01 22 ?? ?? ?? ?? BB 88 06 E0 D8 F8 30 30 1B 88 AB 81 D8 F8 34 30 1B 88 EB 81 1F B0 ?? ?? ?? ?? BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_788_1 {
	meta:
		name = "__catch$?_Init@?$numpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$numpunct@_W@std@@AAAXXZ 000c _CxxThrowException"
	strings:
		$1 = { 1C B5 78 68 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_789_1 {
	meta:
		name = "?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z"
		size = 54
		refs = "0024 ??$_Getvals@G@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXGABV_Locinfo@1@@Z 0028 _Getdateorder"
	strings:
		$1 = { 03 B4 2D E9 9C 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 00 23 04 46 C4 E9 02 33 23 61 BC 61 0A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 60 61 BD E8 9C 08 5D F8 0C FB }
	condition:
		$1
}

rule file_99_338_1 {
	meta:
		name = "?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z"
		size = 54
		refs = "0024 ??$_Getvals@D@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXDABV_Locinfo@1@@Z 0028 _Getdateorder"
	strings:
		$1 = { 03 B4 2D E9 9C 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 00 23 04 46 C4 E9 02 33 23 61 BC 61 0A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 60 61 BD E8 9C 08 5D F8 0C FB }
	condition:
		$1
}

rule file_17_791_1 {
	meta:
		name = "?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z"
		size = 54
		refs = "0024 ??$_Getvals@_W@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAX_WABV_Locinfo@1@@Z 0028 _Getdateorder"
	strings:
		$1 = { 03 B4 2D E9 9C 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 00 23 04 46 C4 E9 02 33 23 61 BC 61 0A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 60 61 BD E8 9C 08 5D F8 0C FB }
	condition:
		$1
}

rule file_17_790_1 {
	meta:
		name = "__catch$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AAAXXZ 000c _CxxThrowException"
	strings:
		$1 = { 10 B5 B8 69 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_99_339_1 {
	meta:
		name = "__catch$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AAAXXZ 000c _CxxThrowException"
	strings:
		$1 = { 10 B5 B8 69 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_792_1 {
	meta:
		name = "__catch$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AAAXXZ 000c _CxxThrowException"
	strings:
		$1 = { 10 B5 B8 69 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_793_1 {
	meta:
		name = "?_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z"
		size = 38
		refs = "0010 ?_W_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 001e free"
		altNames = "?_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0B 46 04 46 18 46 69 46 ?? ?? ?? ?? 03 68 A3 60 00 23 03 60 00 98 ?? ?? ?? ?? BD E8 18 88 }
	condition:
		$1
}

rule file_99_340_1 {
	meta:
		name = "?_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z"
		size = 38
		refs = "0010 ?_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 001e free"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0B 46 04 46 18 46 69 46 ?? ?? ?? ?? 03 68 A3 60 00 23 03 60 00 98 ?? ?? ?? ?? BD E8 18 88 }
	condition:
		$1
}

rule file_17_797_1 {
	meta:
		name = "?_Inside@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NPBG@Z"
		size = 54
		altNames = "?_Inside@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NPB_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 99 B1 82 69 08 2A 01 D3 43 68 00 E0 03 1D 99 42 0B D3 08 2A 01 D3 42 68 00 E0 02 1D 43 69 02 EB 43 03 8B 42 88 BF 01 20 00 D8 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_17_799_1 {
	meta:
		name = "?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z"
		size = 880
		refs = "000a __security_push_cookie 0072 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0076 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0086 _guard_check_icall 00aa ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@IG@Z 00e0 ??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0112 ?grouping@?$numpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0166 ?insert@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IIG@Z 01be ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z 02c0 _invalid_parameter_noinfo_noreturn 032a ??3@YAXPAX@Z 0364 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 98 B0 6F 46 39 61 D7 F8 A4 60 D7 F8 98 00 D7 F8 A0 90 6F F0 01 03 B8 60 C7 E9 06 33 46 B1 99 F9 00 30 2B 2B 01 D0 2D 2B 02 D1 4F F0 01 08 01 E0 4F F0 00 08 43 69 03 F4 60 63 B3 F5 00 6F 10 D1 08 F1 02 02 B2 42 0C D8 19 F9 08 30 09 EB 08 01 30 2B 06 D1 91 F9 01 30 78 2B 01 D0 58 2B 00 D1 90 46 39 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 20 00 00 22 31 46 ?? ?? ?? ?? BB 6B 08 2B 01 D3 7D 6A 01 E0 17 F1 24 05 DA F8 00 20 D4 6A 20 46 ?? ?? ?? ?? 50 46 49 46 06 EB 09 02 2B 46 A0 47 D7 F8 08 A0 39 46 50 46 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 40 01 48 46 ?? ?? ?? ?? D7 F8 58 E0 78 6C BE F1 10 0F 28 BF 05 46 01 D2 17 F1 44 05 95 F9 00 30 7F 2B 27 D0 00 2B 25 DD D9 F8 00 30 1C 69 20 46 ?? ?? ?? ?? 48 46 A0 47 04 46 14 E0 95 F9 00 20 00 2A 14 DD A6 EB 08 03 9A 42 10 D2 B6 1A 31 46 23 46 01 22 17 F1 20 00 ?? ?? ?? ?? 95 F9 01 30 00 2B C8 BF 6D 1C 95 F9 00 30 7F 2B E6 D1 D7 F8 58 E0 78 6C 7E 6B DA E9 08 23 FE 60 00 2B 05 DB 00 DC 1A B1 B2 42 88 BF 94 1B 00 D8 00 24 DA F8 14 30 03 F4 E0 73 40 2B 2E D0 B3 F5 80 7F 2E D0 D7 E9 24 32 C7 E9 00 32 64 B1 B7 F8 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 7E 6B D7 F8 58 E0 78 6C D7 E9 00 32 BD 6B 79 6A 00 24 08 2D 28 BF 89 46 C7 E9 24 32 01 D2 17 F1 24 09 C2 46 C7 E9 00 32 B8 F1 00 0F 61 D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 50 E0 B3 F5 80 7F 35 D1 BD 6B 79 6A 08 2D 28 BF 89 46 01 D2 17 F1 24 09 D7 E9 24 32 C2 46 B8 F1 00 0F C7 E9 00 32 0F D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 0D 65 79 6A D7 F8 58 E0 78 6C D7 E9 00 32 C7 E9 24 32 C7 E9 00 32 74 B1 B7 F8 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 E9 0D 65 79 6A D7 F8 58 E0 78 6C D7 E9 00 32 00 24 1F E0 BD 6B 79 6A 08 2D 28 BF 89 46 01 D2 17 F1 24 09 D7 E9 24 32 C2 46 B8 F1 00 0F C7 E9 00 32 0F D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 0D 65 D7 E9 00 32 78 6C D7 F8 58 E0 79 6A C7 E9 24 32 B0 45 01 D9 ?? ?? ?? ?? 08 2D 01 D2 17 F1 24 01 01 EB 48 05 F9 68 C7 E9 00 32 B1 EB 08 06 0B D0 35 F8 02 1B 38 46 ?? ?? ?? ?? 76 1E F8 D1 D7 F8 58 E0 78 6C D7 E9 00 32 B9 68 00 25 C7 E9 24 32 C1 E9 08 55 C7 E9 00 32 5C B1 B7 F8 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 F8 58 E0 78 6C D7 E9 00 32 3C 69 C4 E9 00 32 BE F1 10 0F 01 D3 ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? 00 23 3B 64 BB 6B 08 2B 02 D3 78 6A ?? ?? ?? ?? 07 23 38 6A BB 63 00 23 7B 63 BB 84 ?? ?? ?? ?? 20 46 18 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_806_1 {
	meta:
		name = "?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z"
		size = 880
		refs = "000a __security_push_cookie 0072 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0076 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0086 _guard_check_icall 00aa ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@I_W@Z 00e0 ??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0112 ?grouping@?$numpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0166 ?insert@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II_W@Z 01be ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z 02c0 _invalid_parameter_noinfo_noreturn 032a ??3@YAXPAX@Z 0364 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 98 B0 6F 46 39 61 D7 F8 A4 60 D7 F8 98 00 D7 F8 A0 90 6F F0 01 03 B8 60 C7 E9 06 33 46 B1 99 F9 00 30 2B 2B 01 D0 2D 2B 02 D1 4F F0 01 08 01 E0 4F F0 00 08 43 69 03 F4 60 63 B3 F5 00 6F 10 D1 08 F1 02 02 B2 42 0C D8 19 F9 08 30 09 EB 08 01 30 2B 06 D1 91 F9 01 30 78 2B 01 D0 58 2B 00 D1 90 46 39 46 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 20 00 00 22 31 46 ?? ?? ?? ?? BB 6B 08 2B 01 D3 7D 6A 01 E0 17 F1 24 05 DA F8 00 20 D4 6A 20 46 ?? ?? ?? ?? 50 46 49 46 06 EB 09 02 2B 46 A0 47 D7 F8 08 A0 39 46 50 46 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F1 40 01 48 46 ?? ?? ?? ?? D7 F8 58 E0 78 6C BE F1 10 0F 28 BF 05 46 01 D2 17 F1 44 05 95 F9 00 30 7F 2B 27 D0 00 2B 25 DD D9 F8 00 30 1C 69 20 46 ?? ?? ?? ?? 48 46 A0 47 04 46 14 E0 95 F9 00 20 00 2A 14 DD A6 EB 08 03 9A 42 10 D2 B6 1A 31 46 23 46 01 22 17 F1 20 00 ?? ?? ?? ?? 95 F9 01 30 00 2B C8 BF 6D 1C 95 F9 00 30 7F 2B E6 D1 D7 F8 58 E0 78 6C 7E 6B DA E9 08 23 FE 60 00 2B 05 DB 00 DC 1A B1 B2 42 88 BF 94 1B 00 D8 00 24 DA F8 14 30 03 F4 E0 73 40 2B 2E D0 B3 F5 80 7F 2E D0 D7 E9 24 32 C7 E9 00 32 64 B1 B7 F8 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 7E 6B D7 F8 58 E0 78 6C D7 E9 00 32 BD 6B 79 6A 00 24 08 2D 28 BF 89 46 C7 E9 24 32 01 D2 17 F1 24 09 C2 46 C7 E9 00 32 B8 F1 00 0F 61 D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 50 E0 B3 F5 80 7F 35 D1 BD 6B 79 6A 08 2D 28 BF 89 46 01 D2 17 F1 24 09 D7 E9 24 32 C2 46 B8 F1 00 0F C7 E9 00 32 0F D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 0D 65 79 6A D7 F8 58 E0 78 6C D7 E9 00 32 C7 E9 24 32 C7 E9 00 32 74 B1 B7 F8 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 E9 0D 65 79 6A D7 F8 58 E0 78 6C D7 E9 00 32 00 24 1F E0 BD 6B 79 6A 08 2D 28 BF 89 46 01 D2 17 F1 24 09 D7 E9 24 32 C2 46 B8 F1 00 0F C7 E9 00 32 0F D0 39 F8 02 1B 38 46 ?? ?? ?? ?? BA F1 01 0A F7 D1 D7 E9 0D 65 D7 E9 00 32 78 6C D7 F8 58 E0 79 6A C7 E9 24 32 B0 45 01 D9 ?? ?? ?? ?? 08 2D 01 D2 17 F1 24 01 01 EB 48 05 F9 68 C7 E9 00 32 B1 EB 08 06 0B D0 35 F8 02 1B 38 46 ?? ?? ?? ?? 76 1E F8 D1 D7 F8 58 E0 78 6C D7 E9 00 32 B9 68 00 25 C7 E9 24 32 C1 E9 08 55 C7 E9 00 32 5C B1 B7 F8 9C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 D7 F8 58 E0 78 6C D7 E9 00 32 3C 69 C4 E9 00 32 BE F1 10 0F 01 D3 ?? ?? ?? ?? 0F 23 38 6C BB 65 00 23 7B 65 87 F8 44 30 ?? ?? ?? ?? 00 23 3B 64 BB 6B 08 2B 02 D3 78 6A ?? ?? ?? ?? 07 23 38 6A BB 63 00 23 7B 63 BB 84 ?? ?? ?? ?? 20 46 18 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_813_1 {
	meta:
		name = "?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 1924
		refs = "0026 ?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 004e ??0_Lockit@std@@QAA@H@Z 0060 ??1_Lockit@std@@QAA@XZ 006a ??2@YAPAXI@Z 0080 _Getctype 0094 _Getcvt 00a2 memcpy 00b2 ?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 00dc ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0196 ??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 01ca ??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0222 ?_Init@?$numpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 024e ??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0260 ?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 02b2 _Getcoll 02e6 ??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 035c ??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 040e ??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0440 ??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 049e ?_Init@?$_Mpunct@G@std@@IAAXABV_Locinfo@2@_N@Z 0524 ??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0556 ??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 05ae ?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 05fa ?_W_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 0608 free 0634 ??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0666 ??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0678 ?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 06fe ??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z 0714 ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 0718 ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A 071c ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0720 ??_7?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0724 ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0728 ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 072c ?id@?$moneypunct@G$00@std@@2V0locale@2@A 0730 ??_7?$moneypunct@G$00@std@@6B@ 0734 ??_7?$moneypunct@G$0A@@std@@6B@ 0738 ??_7?$_Mpunct@G@std@@6B@ 073c ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A 0740 ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0744 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0748 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 074c ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0750 ??_7?$messages@G@std@@6B@ 0754 ?id@?$messages@G@std@@2V0locale@2@A 0758 ??_7?$collate@G@std@@6B@ 075c ?id@?$collate@G@std@@2V0locale@2@A 0760 ??_7?$numpunct@G@std@@6B@ 0764 ?id@?$numpunct@G@std@@2V0locale@2@A 0768 ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 076c ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0770 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0774 ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0778 ??_7?$ctype@G@std@@6B@ 077c ?id@?$ctype@G@std@@2V0locale@2@A 0780 ?_Id_cnt@id@locale@std@@0HA"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 95 B0 6F 46 98 46 6F F0 01 03 C7 E9 04 33 00 23 8A 46 C7 E9 02 01 00 21 00 20 3B 60 91 46 ?? ?? ?? ?? 01 23 03 FA 00 F4 DF F8 4C 67 1A EA 64 0F 57 D0 DF F8 40 47 B8 F1 00 0F 25 68 3A D1 3D 60 75 B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 23 68 3B 60 44 20 ?? ?? ?? ?? 82 46 D0 B1 00 23 43 60 DF F8 00 37 03 60 17 F1 18 00 ?? ?? ?? ?? 17 F1 18 04 0F CC 0A F1 08 05 0F C5 17 F1 28 00 ?? ?? ?? ?? 17 F1 28 01 2C 22 0A F1 18 00 ?? ?? ?? ?? 01 E0 4F F0 00 0A 3A 68 51 46 48 46 ?? ?? ?? ?? D7 F8 0C A0 16 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? 1A F0 08 0A 73 D0 DF F8 80 46 B8 F1 00 0F 25 68 3C D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 28 B1 00 23 43 60 DF F8 48 36 03 60 00 E0 00 20 01 46 48 46 2A 46 ?? ?? ?? ?? DF F8 2C 46 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 28 B1 00 23 43 60 DF F8 00 36 03 60 2D E0 00 20 2B E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? DF F8 C0 45 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? BA F1 00 0F 3E D0 DF F8 84 45 B8 F1 00 0F 25 68 21 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 18 20 ?? ?? ?? ?? 04 46 3C 60 4C B1 00 23 63 60 DF F8 44 35 B9 68 00 22 23 60 ?? ?? ?? ?? 00 E0 00 24 21 46 12 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? D7 F8 0C A0 01 23 83 40 1A EA 63 0F 40 D0 DF F8 E8 44 B8 F1 00 0F 25 68 23 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 10 20 ?? ?? ?? ?? 04 46 64 B1 00 23 63 60 DF F8 AC 34 38 46 23 60 ?? ?? ?? ?? 3B 68 A3 60 7B 68 E3 60 00 E0 00 24 21 46 12 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? 1A F0 20 0F 37 D0 DF F8 58 44 B8 F1 00 0F 25 68 1A D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 28 B1 00 23 43 60 DF F8 1C 34 03 60 13 E0 00 20 11 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? 1A F0 04 0A 6E D0 F6 4C B8 F1 00 0F 25 68 39 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 20 B1 00 23 43 60 E8 4B 03 60 00 E0 00 20 01 46 48 46 2A 46 ?? ?? ?? ?? E2 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 20 B1 00 23 43 60 D7 4B 03 60 2C E0 00 20 2A E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? C8 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? BA F1 00 0F 00 F0 87 80 B9 4C B8 F1 00 0F 25 68 51 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 58 20 ?? ?? ?? ?? 04 46 3C 60 DF F8 AC A2 64 B1 00 23 63 60 B9 68 00 22 C0 F8 00 A0 80 F8 28 30 ?? ?? ?? ?? A4 4B 23 60 00 E0 00 24 2A 46 21 46 48 46 ?? ?? ?? ?? 9D 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 58 20 ?? ?? ?? ?? 04 46 3C 60 6C B1 00 23 63 60 B9 68 01 23 00 22 C0 F8 00 A0 80 F8 28 30 ?? ?? ?? ?? 8D 4B 23 60 00 E0 00 24 21 46 2B E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? 7E 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? D7 F8 0C A0 1A F0 10 0F 00 F0 82 80 6D 4C B8 F1 00 0F 25 68 4C D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 44 20 ?? ?? ?? ?? 04 46 3C 60 3C B1 00 23 63 60 5E 4B B9 68 23 60 ?? ?? ?? ?? 00 E0 00 24 2A 46 21 46 48 46 ?? ?? ?? ?? 56 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 0C 20 ?? ?? ?? ?? 04 46 84 B1 4C 4B B8 68 00 22 C4 E9 00 32 39 46 A2 60 ?? ?? ?? ?? 03 68 A3 60 00 23 03 60 38 68 ?? ?? ?? ?? 00 E0 00 24 21 46 2B E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? 36 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? 01 23 83 40 1A EA 63 0F 42 D0 24 4C B8 F1 00 0F 25 68 26 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 34 20 ?? ?? ?? ?? 04 46 7C B1 00 23 63 60 15 4B 17 F1 28 00 23 60 ?? ?? ?? ?? 17 F1 28 01 2C 22 04 F1 08 00 ?? ?? ?? ?? 00 E0 00 24 21 46 12 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? 15 B0 BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_822_1 {
	meta:
		name = "?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 1924
		refs = "0026 ?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 004e ??0_Lockit@std@@QAA@H@Z 0060 ??1_Lockit@std@@QAA@XZ 006a ??2@YAPAXI@Z 0080 _Getctype 0094 _Getcvt 00a2 memcpy 00b2 ?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 00dc ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0196 ??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 01ca ??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0222 ?_Init@?$numpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 024e ??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0260 ?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 02b2 _Getcoll 02e6 ??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 035c ??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 040e ??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0440 ??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 049e ?_Init@?$_Mpunct@_W@std@@IAAXABV_Locinfo@2@_N@Z 0524 ??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0556 ??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 05ae ?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 05fa ?_W_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ 0608 free 0634 ??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0666 ??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0678 ?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 06fe ??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z 0714 ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 0718 ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A 071c ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0720 ??_7?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0724 ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0728 ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 072c ?id@?$moneypunct@_W$00@std@@2V0locale@2@A 0730 ??_7?$moneypunct@_W$00@std@@6B@ 0734 ??_7?$moneypunct@_W$0A@@std@@6B@ 0738 ??_7?$_Mpunct@_W@std@@6B@ 073c ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A 0740 ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0744 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0748 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 074c ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0750 ??_7?$messages@_W@std@@6B@ 0754 ?id@?$messages@_W@std@@2V0locale@2@A 0758 ??_7?$collate@_W@std@@6B@ 075c ?id@?$collate@_W@std@@2V0locale@2@A 0760 ??_7?$numpunct@_W@std@@6B@ 0764 ?id@?$numpunct@_W@std@@2V0locale@2@A 0768 ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 076c ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0770 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0774 ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0778 ??_7?$ctype@_W@std@@6B@ 077c ?id@?$ctype@_W@std@@2V0locale@2@A 0780 ?_Id_cnt@id@locale@std@@0HA"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 95 B0 6F 46 98 46 6F F0 01 03 C7 E9 04 33 00 23 8A 46 C7 E9 02 01 00 21 00 20 3B 60 91 46 ?? ?? ?? ?? 01 23 03 FA 00 F4 DF F8 4C 67 1A EA 64 0F 57 D0 DF F8 40 47 B8 F1 00 0F 25 68 3A D1 3D 60 75 B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 23 68 3B 60 44 20 ?? ?? ?? ?? 82 46 D0 B1 00 23 43 60 DF F8 00 37 03 60 17 F1 18 00 ?? ?? ?? ?? 17 F1 18 04 0F CC 0A F1 08 05 0F C5 17 F1 28 00 ?? ?? ?? ?? 17 F1 28 01 2C 22 0A F1 18 00 ?? ?? ?? ?? 01 E0 4F F0 00 0A 3A 68 51 46 48 46 ?? ?? ?? ?? D7 F8 0C A0 16 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? 1A F0 08 0A 73 D0 DF F8 80 46 B8 F1 00 0F 25 68 3C D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 28 B1 00 23 43 60 DF F8 48 36 03 60 00 E0 00 20 01 46 48 46 2A 46 ?? ?? ?? ?? DF F8 2C 46 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 28 B1 00 23 43 60 DF F8 00 36 03 60 2D E0 00 20 2B E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? DF F8 C0 45 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? BA F1 00 0F 3E D0 DF F8 84 45 B8 F1 00 0F 25 68 21 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 18 20 ?? ?? ?? ?? 04 46 3C 60 4C B1 00 23 63 60 DF F8 44 35 B9 68 00 22 23 60 ?? ?? ?? ?? 00 E0 00 24 21 46 12 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? D7 F8 0C A0 01 23 83 40 1A EA 63 0F 40 D0 DF F8 E8 44 B8 F1 00 0F 25 68 23 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 10 20 ?? ?? ?? ?? 04 46 64 B1 00 23 63 60 DF F8 AC 34 38 46 23 60 ?? ?? ?? ?? 3B 68 A3 60 7B 68 E3 60 00 E0 00 24 21 46 12 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? 1A F0 20 0F 37 D0 DF F8 58 44 B8 F1 00 0F 25 68 1A D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 28 B1 00 23 43 60 DF F8 1C 34 03 60 13 E0 00 20 11 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? 1A F0 04 0A 6E D0 F6 4C B8 F1 00 0F 25 68 39 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 20 B1 00 23 43 60 E8 4B 03 60 00 E0 00 20 01 46 48 46 2A 46 ?? ?? ?? ?? E2 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 08 20 ?? ?? ?? ?? 20 B1 00 23 43 60 D7 4B 03 60 2C E0 00 20 2A E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? C8 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? BA F1 00 0F 00 F0 87 80 B9 4C B8 F1 00 0F 25 68 51 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 58 20 ?? ?? ?? ?? 04 46 3C 60 DF F8 AC A2 64 B1 00 23 63 60 B9 68 00 22 C0 F8 00 A0 80 F8 28 30 ?? ?? ?? ?? A4 4B 23 60 00 E0 00 24 2A 46 21 46 48 46 ?? ?? ?? ?? 9D 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 58 20 ?? ?? ?? ?? 04 46 3C 60 6C B1 00 23 63 60 B9 68 01 23 00 22 C0 F8 00 A0 80 F8 28 30 ?? ?? ?? ?? 8D 4B 23 60 00 E0 00 24 21 46 2B E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? 7E 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? D7 F8 0C A0 1A F0 10 0F 00 F0 82 80 6D 4C B8 F1 00 0F 25 68 4C D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 44 20 ?? ?? ?? ?? 04 46 3C 60 3C B1 00 23 63 60 5E 4B B9 68 23 60 ?? ?? ?? ?? 00 E0 00 24 2A 46 21 46 48 46 ?? ?? ?? ?? 56 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 0C 20 ?? ?? ?? ?? 04 46 84 B1 4C 4B B8 68 00 22 C4 E9 00 32 39 46 A2 60 ?? ?? ?? ?? 03 68 A3 60 00 23 03 60 38 68 ?? ?? ?? ?? 00 E0 00 24 21 46 2B E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 48 46 2A 46 ?? ?? ?? ?? 36 4C 25 68 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? 01 23 83 40 1A EA 63 0F 42 D0 24 4C B8 F1 00 0F 25 68 26 D1 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 34 20 ?? ?? ?? ?? 04 46 7C B1 00 23 63 60 15 4B 17 F1 28 00 23 60 ?? ?? ?? ?? 17 F1 28 01 2C 22 04 F1 08 00 ?? ?? ?? ?? 00 E0 00 24 21 46 12 E0 6D B9 38 46 00 21 ?? ?? ?? ?? 23 68 1B B9 33 68 5B 1C 33 60 23 60 38 46 ?? ?? ?? ?? 25 68 40 46 ?? ?? ?? ?? 01 46 2A 46 48 46 ?? ?? ?? ?? 15 B0 BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_831_1 {
	meta:
		name = "?_Maklocwcs@std@@YAPA_WPB_W@Z"
		size = 48
		refs = "000a wcslen 0014 calloc 0020 memcpy 002a ?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 ?? ?? ?? ?? 46 1C 30 46 02 21 ?? ?? ?? ?? 04 46 34 B1 72 00 29 46 ?? ?? ?? ?? 20 46 BD E8 78 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_832_1 {
	meta:
		name = "?_Makpat@?$_Mpunct@G@std@@AAAXAAUpattern@money_base@2@III@Z"
		size = 88
		refs = "003c _errno 0048 _invalid_parameter_noinfo 0050 ??_C@_04FJCIEOIB@$?$CLxv?$AA@ 0054 ??_C@_0HJ@PJOMAIHM@?$CLv$x?$CLv$xv$?$CLxv?$CL$xv$?$CLx?$CL$vx?$CL$vx$v?$CLx@"
		altNames = "?_Makpat@?$_Mpunct@D@std@@AAAXAAUpattern@money_base@2@III@Z ?_Makpat@?$_Mpunct@_W@std@@AAAXAAUpattern@money_base@2@III@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 90 F8 28 00 78 B9 02 2A 0D D8 01 2B 0B D8 02 98 04 28 08 D8 03 EB 42 03 03 EB 83 03 1A 18 0B 4B 03 EB 82 03 00 E0 08 4B 29 B1 13 B1 1B 68 0B 60 09 E0 00 23 0B 60 ?? ?? ?? ?? 16 23 03 60 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_841_1 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ"
		size = 22
		altNames = "?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAPBGXZ ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAPB_WXZ ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QAAPAGXZ ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QBAPBGXZ ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAAPA_WXZ ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QBAPB_WXZ ?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAPBGXZ ?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAPB_WXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 83 69 08 2B 01 D3 40 68 00 E0 00 1D BD E8 00 88 }
	condition:
		$1
}

rule file_17_864_1 {
	meta:
		name = "?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ"
		size = 76
		refs = "002a _guard_check_icall"
		altNames = "?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2E 68 BE B1 F3 69 1A 68 12 B1 F3 6A 1B 68 00 E0 00 23 00 2B 01 DD 10 88 06 E0 33 68 9C 69 20 46 ?? ?? ?? ?? 30 46 A0 47 4F F6 FF 73 98 42 01 D0 E8 80 01 E0 00 23 2B 60 01 23 E8 88 2B 71 BD E8 78 88 }
	condition:
		$1
}

rule file_17_868_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ"
		size = 26
		altNames = "?_Pninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 6B 13 68 5B 1E 13 60 02 6A 10 68 83 1C 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_870_1 {
	meta:
		name = "?_Put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@CA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@I@Z"
		size = 156
		refs = "0040 ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z 0082 _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 0F B4 2D E9 78 48 0D F1 10 0B 0A 9E 1C 46 CD E9 07 12 05 46 76 B3 A1 68 E9 B3 23 68 CB B3 1A 68 BA B3 93 69 08 2B 01 D3 50 68 00 E0 10 1D 88 42 2D D8 53 69 00 EB 43 03 99 42 28 D2 09 88 07 A8 ?? ?? ?? ?? A0 68 76 1E F8 B1 23 68 DB B1 1A 68 CA B1 93 69 08 2B 01 D3 51 68 00 E0 11 1D 53 69 01 EB 43 03 98 42 0C D2 83 1C A3 60 00 2E D2 D1 DD E9 07 12 C5 E9 00 12 28 46 BD E8 78 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_871_1 {
	meta:
		name = "?_Put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@CA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@I@Z"
		size = 156
		refs = "0040 ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z 0082 _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 0F B4 2D E9 78 48 0D F1 10 0B 0A 9E 1C 46 CD E9 07 12 05 46 76 B3 A1 68 E9 B3 23 68 CB B3 1A 68 BA B3 93 69 08 2B 01 D3 50 68 00 E0 10 1D 88 42 2D D8 53 69 00 EB 43 03 99 42 28 D2 09 88 07 A8 ?? ?? ?? ?? A0 68 76 1E F8 B1 23 68 DB B1 1A 68 CA B1 93 69 08 2B 01 D3 51 68 00 E0 11 1D 53 69 01 EB 43 03 98 42 0C D2 83 1C A3 60 00 2E D2 D1 DD E9 07 12 C5 E9 00 12 28 46 BD E8 78 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_872_1 {
	meta:
		name = "?_Put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@PBGI@Z"
		size = 54
		refs = "001c ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z"
	strings:
		$1 = { 0F B4 2D E9 78 48 0D F1 10 0B 0B 9E CD E9 08 23 0C 46 4E B1 0A 9D 35 F8 02 1B 08 A8 ?? ?? ?? ?? 76 1E F8 D1 DD E9 08 23 C4 E9 00 23 20 46 BD E8 78 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_873_1 {
	meta:
		name = "?_Put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@PB_WI@Z"
		size = 54
		refs = "001c ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 0F B4 2D E9 78 48 0D F1 10 0B 0B 9E CD E9 08 23 0C 46 4E B1 0A 9D 35 F8 02 1B 08 A8 ?? ?? ?? ?? 76 1E F8 D1 DD E9 08 23 C4 E9 00 23 20 46 BD E8 78 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_874_1 {
	meta:
		name = "?_Putmfld@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@G1V?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@G@Z"
		size = 1794
		refs = "000a __security_push_cookie 003a ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 003e ??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0052 _guard_check_icall 0078 ??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 00ae ?grouping@?$_Mpunct@G@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00e2 ?insert@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IIG@Z 0186 ??2@YAPAXI@Z 018c _invalid_parameter_noinfo_noreturn 01d8 ?negative_sign@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 01f6 ?positive_sign@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 0200 ??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV01@$$QAV01@@Z 0210 ??3@YAXPAX@Z 0278 ?curr_symbol@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 0366 ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z 03ca ?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 03f4 ?_Put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@CA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@I@Z 04fa ?end@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 0504 ??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA?AV01@H@Z 0634 ??H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA?AV01@H@Z 06a6 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 06da ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 06ee ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ 06f6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? F6 B0 6F 46 82 B0 D7 F8 14 92 D7 F8 20 A2 6F F0 01 03 C7 E9 3C 33 C7 F8 18 90 C7 F8 9C A0 B9 64 97 F8 10 32 48 46 E3 B1 17 F1 A0 01 ?? ?? ?? ?? ?? ?? ?? ?? 06 46 BE 60 D7 F8 A4 50 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 1B E0 17 F1 A8 01 ?? ?? ?? ?? ?? ?? ?? ?? 06 46 BE 60 D7 F8 AC 50 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F5 DC 71 30 46 ?? ?? ?? ?? 33 68 5C 6A 20 46 ?? ?? ?? ?? 30 46 A0 47 80 EA E0 73 A3 EB E0 78 DA F8 14 30 C7 F8 40 80 43 45 09 D8 A8 EB 03 03 5A 1C B7 F8 24 32 00 21 50 46 ?? ?? ?? ?? 48 E0 D7 F8 D0 11 D7 F8 BC 21 10 29 28 BF 13 46 01 D2 17 F5 DE 73 93 F9 00 30 7F 2B 3A D0 10 29 01 D2 17 F5 DE 72 92 F9 00 30 00 2B 32 DD 33 68 1C 69 20 46 ?? ?? ?? ?? 30 46 A0 47 D7 F8 D0 31 78 60 10 2B 02 D3 D7 F8 BC 41 01 E0 17 F5 DE 74 DA F8 14 30 A3 EB 08 05 94 F9 00 30 7F 2B 19 D0 D7 F8 04 90 94 F9 00 30 00 2B 11 DD AB 42 0F D2 ED 1A 29 46 4B 46 01 22 50 46 ?? ?? ?? ?? 94 F9 01 30 00 2B C8 BF 64 1C 94 F9 00 30 7F 2B E9 D1 D7 F8 18 90 00 23 08 20 C7 F8 58 31 C7 E9 5B 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 C7 F8 58 01 C0 E9 00 32 D7 F8 58 31 17 F5 AC 72 1A 60 07 23 C7 F8 70 31 00 23 C7 F8 6C 31 A7 F8 5C 31 97 F8 1C 32 00 2B 33 68 0E D0 DC 6A 20 46 ?? ?? ?? ?? 30 46 39 1D A0 47 7B 68 17 F5 CC 71 30 46 7B 60 ?? ?? ?? ?? 0D E0 9C 6A 20 46 ?? ?? ?? ?? 30 46 39 1D A0 47 7B 68 17 F5 CC 71 30 46 7B 60 ?? ?? ?? ?? 01 46 17 F5 AC 70 ?? ?? ?? ?? D7 F8 B0 31 08 2B 03 D3 D7 F8 9C 01 ?? ?? ?? ?? 07 23 D7 F8 98 01 C7 F8 B0 31 00 23 C7 F8 AC 31 A7 F8 9C 31 ?? ?? ?? ?? 00 23 08 20 C7 F8 78 31 C7 E9 63 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 C7 F8 78 01 C0 E9 00 32 D7 F8 78 31 17 F5 BC 72 00 20 1A 60 07 23 C7 E9 63 03 00 23 A7 F8 7C 31 38 60 D9 F8 14 30 13 F0 08 0F 20 D0 17 F5 CC 71 30 46 ?? ?? ?? ?? 01 46 17 F5 BC 70 ?? ?? ?? ?? D7 F8 B0 31 08 2B 03 D3 D7 F8 9C 01 ?? ?? ?? ?? 07 23 D7 F8 98 01 C7 F8 B0 31 00 23 C7 F8 AC 31 A7 F8 9C 31 ?? ?? ?? ?? D7 F8 8C 01 38 60 D7 F8 6C 91 00 22 00 21 3E 1D 4F F0 00 0E 8B 57 20 2B 1F D0 24 2B 1B D0 2B 2B 17 D0 76 2B 02 D0 78 2B 18 D0 1B E0 DA F8 14 40 B8 F1 00 0F 18 BF 01 25 08 BF 00 25 44 45 03 D8 A8 EB 04 03 5B 1C 00 E0 00 23 23 44 2B 44 1A 44 08 E0 4A 44 06 E0 02 44 04 E0 52 1C 03 29 01 D0 4F F0 01 0E 49 1C 04 29 D4 D3 B8 69 BE 68 D0 E9 08 13 00 2B 06 DB 00 DC 21 B1 91 42 02 D9 A1 EB 02 08 01 E0 4F F0 00 08 43 69 4F F4 80 72 03 F4 E0 73 7B 64 40 2B 22 D0 93 42 02 D1 BE F1 00 0F 1D D1 D7 E9 82 45 B8 F1 00 0F C7 E9 02 45 11 D0 B7 F8 18 12 17 F1 08 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 D7 F8 8C 31 D7 F8 6C 91 D7 E9 02 45 3B 60 4F F4 80 72 C7 E9 82 45 4F F0 00 08 01 E0 D7 E9 82 45 00 23 BB 60 39 1D 5B 56 20 2B 00 F0 02 81 24 2B 00 F0 E5 80 2B 2B 00 F0 C3 80 76 2B 03 D0 78 2B 00 F0 0A 81 2A E1 D7 F8 40 90 B9 F1 00 0F 27 D1 DA F8 14 90 17 F5 9C 71 50 46 ?? ?? ?? ?? 00 23 C7 E9 14 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 65 83 68 BB 65 17 F1 50 03 17 F1 F8 00 21 46 2A 46 CD F8 00 90 ?? ?? ?? ?? 04 68 D7 F8 8C 31 D7 F8 6C 91 C7 F8 08 42 45 68 3B 60 C7 F8 0C 52 FB E0 DA F8 14 30 3B 60 4B 45 3E D8 B7 F8 24 12 17 F5 02 70 ?? ?? ?? ?? 33 68 DC 68 20 46 ?? ?? ?? ?? 30 46 A0 47 01 46 17 F5 02 70 ?? ?? ?? ?? DA F8 14 30 D7 E9 82 45 B9 EB 03 09 C7 E9 0C 45 0A D0 B7 F8 24 12 17 F1 30 00 ?? ?? ?? ?? B9 F1 01 09 F6 D1 D7 E9 0C 45 DA F8 14 90 17 F5 A4 71 50 46 C7 E9 82 45 ?? ?? ?? ?? 00 23 C7 E9 18 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 66 83 68 BB 66 17 F1 60 03 17 F5 80 70 A9 E7 17 F5 84 71 50 46 ?? ?? ?? ?? 00 23 C7 E9 1C 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 67 83 68 2A 46 21 46 BB 67 3B 68 17 F1 D8 00 A3 EB 09 03 00 93 17 F1 70 03 ?? ?? ?? ?? 03 68 C7 F8 08 32 43 68 C7 F8 0C 32 33 68 DC 68 20 46 ?? ?? ?? ?? 30 46 A0 47 01 46 17 F5 02 70 ?? ?? ?? ?? 17 F5 8C 71 50 46 ?? ?? ?? ?? 4A 46 17 F5 94 71 ?? ?? ?? ?? 00 23 C7 E9 20 33 03 68 23 B1 1B 68 13 B1 1B 68 C7 F8 80 30 83 68 D7 E9 82 12 C7 F8 88 30 17 F1 80 03 17 F1 E0 00 5F E7 B9 F1 00 0F 6A D0 17 F1 B8 01 17 F5 AC 70 ?? ?? ?? ?? 00 23 C7 E9 24 33 03 68 23 B1 1B 68 13 B1 1B 68 C7 F8 90 30 83 68 2A 46 21 46 C7 F8 98 30 01 23 00 93 17 F1 90 03 17 F1 E8 00 42 E7 17 F1 C8 01 17 F5 BC 70 ?? ?? ?? ?? 00 23 C7 E9 08 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 62 83 68 2A 46 21 46 BB 62 3B 68 00 93 17 F1 20 03 17 F1 B0 00 28 E7 B7 F8 18 12 17 F1 38 00 C7 E9 0E 45 ?? ?? ?? ?? D7 E9 0E 45 D7 F8 8C 31 D7 F8 6C 91 C7 E9 82 45 3B 60 4F F4 80 72 7B 6C 93 42 1E D1 23 46 C7 E9 04 45 2A 46 B8 F1 00 0F 0F D0 B7 F8 18 12 17 F1 10 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 D7 F8 8C 31 D7 F8 6C 91 7A 69 3B 60 3B 69 1C 46 C7 E9 82 32 15 46 4F F0 00 08 4F F4 80 72 BB 68 07 F1 04 01 5B 1C BB 60 04 2B FF F4 BD AE B9 F1 01 0F 26 D9 17 F1 C8 01 17 F5 AC 70 ?? ?? ?? ?? 17 F1 B8 01 01 22 ?? ?? ?? ?? 00 23 C7 E9 08 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 62 83 68 D7 E9 82 12 BB 62 A9 F1 01 03 00 93 17 F1 20 03 17 F1 B0 00 ?? ?? ?? ?? 04 68 C7 F8 08 42 45 68 C7 F8 0C 52 BB 69 00 22 C7 E9 04 45 C3 E9 08 22 B8 F1 00 0F 0A D0 B7 F8 18 12 17 F1 10 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 D7 E9 04 45 BE 6C C6 E9 00 45 17 F5 BC 70 00 22 01 21 ?? ?? ?? ?? D7 F8 78 01 ?? ?? ?? ?? 00 23 C7 F8 78 31 17 F5 AC 70 00 22 01 21 ?? ?? ?? ?? D7 F8 58 01 ?? ?? ?? ?? 00 23 C7 F8 58 31 17 F5 DC 70 00 22 01 21 ?? ?? ?? ?? D7 F8 B8 01 ?? ?? ?? ?? 00 23 C7 F8 B8 31 50 46 ?? ?? ?? ?? 30 46 78 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_885_1 {
	meta:
		name = "?_Putmfld@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_W1V?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@3@Z"
		size = 1794
		refs = "000a __security_push_cookie 003a ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 003e ??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0052 _guard_check_icall 0078 ??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 00ae ?grouping@?$_Mpunct@_W@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00e2 ?insert@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II_W@Z 0186 ??2@YAPAXI@Z 018c _invalid_parameter_noinfo_noreturn 01d8 ?negative_sign@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 01f6 ?positive_sign@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 0200 ??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV01@$$QAV01@@Z 0210 ??3@YAXPAX@Z 0278 ?curr_symbol@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 0366 ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z 03ca ?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 03f4 ?_Put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@CA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@I@Z 04fa ?end@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0504 ??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA?AV01@H@Z 0634 ??H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA?AV01@H@Z 06a6 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 06da ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 06ee ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ 06f6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? F6 B0 6F 46 82 B0 D7 F8 14 92 D7 F8 20 A2 6F F0 01 03 C7 E9 3C 33 C7 F8 18 90 C7 F8 9C A0 B9 64 97 F8 10 32 48 46 E3 B1 17 F1 A0 01 ?? ?? ?? ?? ?? ?? ?? ?? 06 46 BE 60 D7 F8 A4 50 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 1B E0 17 F1 A8 01 ?? ?? ?? ?? ?? ?? ?? ?? 06 46 BE 60 D7 F8 AC 50 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 17 F5 DC 71 30 46 ?? ?? ?? ?? 33 68 5C 6A 20 46 ?? ?? ?? ?? 30 46 A0 47 80 EA E0 73 A3 EB E0 78 DA F8 14 30 C7 F8 40 80 43 45 09 D8 A8 EB 03 03 5A 1C B7 F8 24 32 00 21 50 46 ?? ?? ?? ?? 48 E0 D7 F8 D0 11 D7 F8 BC 21 10 29 28 BF 13 46 01 D2 17 F5 DE 73 93 F9 00 30 7F 2B 3A D0 10 29 01 D2 17 F5 DE 72 92 F9 00 30 00 2B 32 DD 33 68 1C 69 20 46 ?? ?? ?? ?? 30 46 A0 47 D7 F8 D0 31 78 60 10 2B 02 D3 D7 F8 BC 41 01 E0 17 F5 DE 74 DA F8 14 30 A3 EB 08 05 94 F9 00 30 7F 2B 19 D0 D7 F8 04 90 94 F9 00 30 00 2B 11 DD AB 42 0F D2 ED 1A 29 46 4B 46 01 22 50 46 ?? ?? ?? ?? 94 F9 01 30 00 2B C8 BF 64 1C 94 F9 00 30 7F 2B E9 D1 D7 F8 18 90 00 23 08 20 C7 F8 58 31 C7 E9 5B 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 C7 F8 58 01 C0 E9 00 32 D7 F8 58 31 17 F5 AC 72 1A 60 07 23 C7 F8 70 31 00 23 C7 F8 6C 31 A7 F8 5C 31 97 F8 1C 32 00 2B 33 68 0E D0 DC 6A 20 46 ?? ?? ?? ?? 30 46 39 1D A0 47 7B 68 17 F5 CC 71 30 46 7B 60 ?? ?? ?? ?? 0D E0 9C 6A 20 46 ?? ?? ?? ?? 30 46 39 1D A0 47 7B 68 17 F5 CC 71 30 46 7B 60 ?? ?? ?? ?? 01 46 17 F5 AC 70 ?? ?? ?? ?? D7 F8 B0 31 08 2B 03 D3 D7 F8 9C 01 ?? ?? ?? ?? 07 23 D7 F8 98 01 C7 F8 B0 31 00 23 C7 F8 AC 31 A7 F8 9C 31 ?? ?? ?? ?? 00 23 08 20 C7 F8 78 31 C7 E9 63 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 C7 F8 78 01 C0 E9 00 32 D7 F8 78 31 17 F5 BC 72 00 20 1A 60 07 23 C7 E9 63 03 00 23 A7 F8 7C 31 38 60 D9 F8 14 30 13 F0 08 0F 20 D0 17 F5 CC 71 30 46 ?? ?? ?? ?? 01 46 17 F5 BC 70 ?? ?? ?? ?? D7 F8 B0 31 08 2B 03 D3 D7 F8 9C 01 ?? ?? ?? ?? 07 23 D7 F8 98 01 C7 F8 B0 31 00 23 C7 F8 AC 31 A7 F8 9C 31 ?? ?? ?? ?? D7 F8 8C 01 38 60 D7 F8 6C 91 00 22 00 21 3E 1D 4F F0 00 0E 8B 57 20 2B 1F D0 24 2B 1B D0 2B 2B 17 D0 76 2B 02 D0 78 2B 18 D0 1B E0 DA F8 14 40 B8 F1 00 0F 18 BF 01 25 08 BF 00 25 44 45 03 D8 A8 EB 04 03 5B 1C 00 E0 00 23 23 44 2B 44 1A 44 08 E0 4A 44 06 E0 02 44 04 E0 52 1C 03 29 01 D0 4F F0 01 0E 49 1C 04 29 D4 D3 B8 69 BE 68 D0 E9 08 13 00 2B 06 DB 00 DC 21 B1 91 42 02 D9 A1 EB 02 08 01 E0 4F F0 00 08 43 69 4F F4 80 72 03 F4 E0 73 7B 64 40 2B 22 D0 93 42 02 D1 BE F1 00 0F 1D D1 D7 E9 82 45 B8 F1 00 0F C7 E9 02 45 11 D0 B7 F8 18 12 17 F1 08 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 D7 F8 8C 31 D7 F8 6C 91 D7 E9 02 45 3B 60 4F F4 80 72 C7 E9 82 45 4F F0 00 08 01 E0 D7 E9 82 45 00 23 BB 60 39 1D 5B 56 20 2B 00 F0 02 81 24 2B 00 F0 E5 80 2B 2B 00 F0 C3 80 76 2B 03 D0 78 2B 00 F0 0A 81 2A E1 D7 F8 40 90 B9 F1 00 0F 27 D1 DA F8 14 90 17 F5 9C 71 50 46 ?? ?? ?? ?? 00 23 C7 E9 14 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 65 83 68 BB 65 17 F1 50 03 17 F1 F8 00 21 46 2A 46 CD F8 00 90 ?? ?? ?? ?? 04 68 D7 F8 8C 31 D7 F8 6C 91 C7 F8 08 42 45 68 3B 60 C7 F8 0C 52 FB E0 DA F8 14 30 3B 60 4B 45 3E D8 B7 F8 24 12 17 F5 02 70 ?? ?? ?? ?? 33 68 DC 68 20 46 ?? ?? ?? ?? 30 46 A0 47 01 46 17 F5 02 70 ?? ?? ?? ?? DA F8 14 30 D7 E9 82 45 B9 EB 03 09 C7 E9 0C 45 0A D0 B7 F8 24 12 17 F1 30 00 ?? ?? ?? ?? B9 F1 01 09 F6 D1 D7 E9 0C 45 DA F8 14 90 17 F5 A4 71 50 46 C7 E9 82 45 ?? ?? ?? ?? 00 23 C7 E9 18 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 66 83 68 BB 66 17 F1 60 03 17 F5 80 70 A9 E7 17 F5 84 71 50 46 ?? ?? ?? ?? 00 23 C7 E9 1C 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 67 83 68 2A 46 21 46 BB 67 3B 68 17 F1 D8 00 A3 EB 09 03 00 93 17 F1 70 03 ?? ?? ?? ?? 03 68 C7 F8 08 32 43 68 C7 F8 0C 32 33 68 DC 68 20 46 ?? ?? ?? ?? 30 46 A0 47 01 46 17 F5 02 70 ?? ?? ?? ?? 17 F5 8C 71 50 46 ?? ?? ?? ?? 4A 46 17 F5 94 71 ?? ?? ?? ?? 00 23 C7 E9 20 33 03 68 23 B1 1B 68 13 B1 1B 68 C7 F8 80 30 83 68 D7 E9 82 12 C7 F8 88 30 17 F1 80 03 17 F1 E0 00 5F E7 B9 F1 00 0F 6A D0 17 F1 B8 01 17 F5 AC 70 ?? ?? ?? ?? 00 23 C7 E9 24 33 03 68 23 B1 1B 68 13 B1 1B 68 C7 F8 90 30 83 68 2A 46 21 46 C7 F8 98 30 01 23 00 93 17 F1 90 03 17 F1 E8 00 42 E7 17 F1 C8 01 17 F5 BC 70 ?? ?? ?? ?? 00 23 C7 E9 08 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 62 83 68 2A 46 21 46 BB 62 3B 68 00 93 17 F1 20 03 17 F1 B0 00 28 E7 B7 F8 18 12 17 F1 38 00 C7 E9 0E 45 ?? ?? ?? ?? D7 E9 0E 45 D7 F8 8C 31 D7 F8 6C 91 C7 E9 82 45 3B 60 4F F4 80 72 7B 6C 93 42 1E D1 23 46 C7 E9 04 45 2A 46 B8 F1 00 0F 0F D0 B7 F8 18 12 17 F1 10 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 D7 F8 8C 31 D7 F8 6C 91 7A 69 3B 60 3B 69 1C 46 C7 E9 82 32 15 46 4F F0 00 08 4F F4 80 72 BB 68 07 F1 04 01 5B 1C BB 60 04 2B FF F4 BD AE B9 F1 01 0F 26 D9 17 F1 C8 01 17 F5 AC 70 ?? ?? ?? ?? 17 F1 B8 01 01 22 ?? ?? ?? ?? 00 23 C7 E9 08 33 03 68 1B B1 1B 68 0B B1 1B 68 3B 62 83 68 D7 E9 82 12 BB 62 A9 F1 01 03 00 93 17 F1 20 03 17 F1 B0 00 ?? ?? ?? ?? 04 68 C7 F8 08 42 45 68 C7 F8 0C 52 BB 69 00 22 C7 E9 04 45 C3 E9 08 22 B8 F1 00 0F 0A D0 B7 F8 18 12 17 F1 10 00 ?? ?? ?? ?? B8 F1 01 08 F6 D1 D7 E9 04 45 BE 6C C6 E9 00 45 17 F5 BC 70 00 22 01 21 ?? ?? ?? ?? D7 F8 78 01 ?? ?? ?? ?? 00 23 C7 F8 78 31 17 F5 AC 70 00 22 01 21 ?? ?? ?? ?? D7 F8 58 01 ?? ?? ?? ?? 00 23 C7 F8 58 31 17 F5 DC 70 00 22 01 21 ?? ?? ?? ?? D7 F8 B8 01 ?? ?? ?? ?? 00 23 C7 F8 B8 31 50 46 ?? ?? ?? ?? 30 46 78 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_896_1 {
	meta:
		name = "?_Rep@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@CA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@GI@Z"
		size = 52
		refs = "001a ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z"
	strings:
		$1 = { 0F B4 2D E9 78 48 0D F1 10 0B 0A 9D 1E 46 CD E9 07 12 04 46 3D B1 31 46 07 A8 ?? ?? ?? ?? 6D 1E F9 D1 DD E9 07 12 C4 E9 00 12 20 46 BD E8 78 08 5D F8 14 FB }
	condition:
		$1
}

rule file_99_377_1 {
	meta:
		name = "?_Rep@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@CA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z"
		size = 52
		refs = "001a ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@D@Z"
	strings:
		$1 = { 0F B4 2D E9 78 48 0D F1 10 0B 0A 9D 1E 46 CD E9 07 12 04 46 3D B1 31 46 07 A8 ?? ?? ?? ?? 6D 1E F9 D1 DD E9 07 12 C4 E9 00 12 20 46 BD E8 78 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_897_1 {
	meta:
		name = "?_Rep@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@CA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_WI@Z"
		size = 52
		refs = "001a ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 0F B4 2D E9 78 48 0D F1 10 0B 0A 9D 1E 46 CD E9 07 12 04 46 3D B1 31 46 07 A8 ?? ?? ?? ?? 6D 1E F9 D1 DD E9 07 12 C4 E9 00 12 20 46 BD E8 78 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_898_1 {
	meta:
		name = "?_Rep@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@GI@Z"
		size = 52
		refs = "001a ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z"
	strings:
		$1 = { 0F B4 2D E9 30 48 0D F1 08 0B 09 9D CD E9 06 23 0C 46 45 B1 BD F8 20 10 06 A8 ?? ?? ?? ?? 6D 1E F8 D1 DD E9 06 23 C4 E9 00 23 20 46 BD E8 30 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_899_1 {
	meta:
		name = "?_Rep@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_WI@Z"
		size = 52
		refs = "001a ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z"
	strings:
		$1 = { 0F B4 2D E9 30 48 0D F1 08 0B 09 9D CD E9 06 23 0C 46 45 B1 BD F8 20 10 06 A8 ?? ?? ?? ?? 6D 1E F8 D1 DD E9 06 23 C4 E9 00 23 20 46 BD E8 30 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_907_1 {
	meta:
		name = "?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z"
		size = 58
		refs = "001e memcpy 0024 ??3@YAXPAX@Z"
		altNames = "?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 15 46 04 46 61 B1 A3 69 08 2B 09 D3 66 68 25 B1 6A 00 20 1D 31 46 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 07 23 C4 E9 05 53 23 1D 00 22 23 F8 15 20 BD E8 78 88 }
	condition:
		$1
}

rule file_17_911_1 {
	meta:
		name = "?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AAAXXZ"
		size = 32
		refs = "000c free"
		altNames = "?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AAAXXZ ?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 A0 68 ?? ?? ?? ?? E0 68 ?? ?? ?? ?? 20 69 BD E8 18 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_913_1 {
	meta:
		name = "?_W_Getdays@_Locinfo@std@@QBAPBGXZ"
		size = 100
		refs = "000a _W_Getdays 001a free 0034 malloc 0040 memcpy 0060 ??_C@_1KM@LPDIELBN@?$AA?3?$AAS?$AAu?$AAn?$AA?3?$AAS?$AAu?$AAn?$AAd?$AAa?$AAy?$AA?3?$AAM?$AAo?$AAn?$AA?3?$AAM?$AAo?$AAn?$AAd?$AAa?$AAy?$AA?3?$AAT?$AAu?$AAe?$AA?3?$AAT?$AAu?$AAe?$AAs?$AAd@"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 ?? ?? ?? ?? 05 46 DD B1 60 69 A8 42 15 D0 08 B1 ?? ?? ?? ?? 00 23 63 61 2B 88 2A 46 01 E0 92 1C 13 88 00 2B FB D1 56 1B B0 1C ?? ?? ?? ?? 60 61 18 B1 B2 1C 29 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 63 69 23 B1 18 46 18 B9 04 F1 18 00 00 E0 01 48 BD E8 78 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_914_1 {
	meta:
		name = "?_W_Getmonths@_Locinfo@std@@QBAPBGXZ"
		size = 100
		refs = "000a _W_Getmonths 001a free 0034 malloc 0040 memcpy 0060 ??_C@_1BAO@JIKOGLKA@?$AA?3?$AAJ?$AAa?$AAn?$AA?3?$AAJ?$AAa?$AAn?$AAu?$AAa?$AAr?$AAy?$AA?3?$AAF?$AAe?$AAb?$AA?3?$AAF?$AAe?$AAb?$AAr?$AAu?$AAa?$AAr?$AAy?$AA?3?$AAM?$AAa?$AAr?$AA?3?$AAM?$AAa@"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 ?? ?? ?? ?? 05 46 DD B1 E0 69 A8 42 15 D0 08 B1 ?? ?? ?? ?? 00 23 E3 61 2B 88 2A 46 01 E0 92 1C 13 88 00 2B FB D1 56 1B B0 1C ?? ?? ?? ?? E0 61 18 B1 B2 1C 29 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? E3 69 23 B1 18 46 18 B9 04 F1 20 00 00 E0 01 48 BD E8 78 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_915_1 {
	meta:
		name = "?_W_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ"
		size = 22
		refs = "000a _W_Gettnames"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 ?? ?? ?? ?? 20 60 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_99_323_1 {
	meta:
		name = "?_Gettnames@_Locinfo@std@@QBA?AV_Timevec@2@XZ"
		size = 22
		refs = "000a _Gettnames"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 ?? ?? ?? ?? 20 60 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_926_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAPAGI@Z"
		size = 44
		refs = "0018 ??2@YAPAXI@Z 0022 ?_Xbad_alloc@std@@YAXXZ 0026 _invalid_parameter_noinfo_noreturn"
		altNames = "?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAPA_WI@Z ?allocate@?$allocator@G@std@@QAAPAGI@Z ?allocate@?$allocator@_W@std@@QAAPA_WI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 11 B9 00 20 BD E8 00 88 6F F0 00 43 99 42 05 D8 48 00 ?? ?? ?? ?? 00 28 F4 D1 01 E0 ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_935_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 136
		refs = "0030 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 005c memcpy 007c ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ 0082 ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0E 46 1D 46 73 69 90 46 04 46 43 45 31 D3 9B 1A 62 69 9D 42 88 BF 1D 46 D3 43 AB 42 2C D9 57 19 25 B3 00 22 39 46 20 46 ?? ?? ?? ?? F0 B1 B3 69 08 2B 01 D3 71 68 00 E0 31 1D A3 69 08 2B 01 D3 60 68 00 E0 20 1D 3D B1 63 69 6A 00 01 EB 48 01 00 EB 43 00 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 67 61 23 F8 17 20 20 46 BD E8 F8 89 30 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_938_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 136
		refs = "0030 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 005c memcpy 007c ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ 0082 ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0E 46 1D 46 73 69 90 46 04 46 43 45 31 D3 9B 1A 62 69 9D 42 88 BF 1D 46 D3 43 AB 42 2C D9 57 19 25 B3 00 22 39 46 20 46 ?? ?? ?? ?? F0 B1 B3 69 08 2B 01 D3 71 68 00 E0 31 1D A3 69 08 2B 01 D3 60 68 00 E0 20 1D 3D B1 63 69 6A 00 01 EB 48 01 00 EB 43 00 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 67 61 23 F8 17 20 20 46 BD E8 F8 89 30 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_936_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z"
		size = 122
		refs = "001e ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 0074 ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 04 46 0D 46 61 69 17 46 CB 43 AB 42 2D D9 4E 19 45 B3 00 22 31 46 ?? ?? ?? ?? 18 B3 D4 E9 05 23 01 2D 07 D1 08 2B 01 D3 63 68 00 E0 23 1D 23 F8 12 70 0D E0 08 2B 01 D3 63 68 00 E0 23 1D 03 EB 42 03 2D B1 03 EB 45 02 23 F8 02 7B 93 42 FB D1 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 23 F8 16 20 20 46 BD E8 F0 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_939_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z"
		size = 122
		refs = "001e ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 0074 ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 04 46 0D 46 61 69 17 46 CB 43 AB 42 2D D9 4E 19 45 B3 00 22 31 46 ?? ?? ?? ?? 18 B3 D4 E9 05 23 01 2D 07 D1 08 2B 01 D3 63 68 00 E0 23 1D 23 F8 12 70 0D E0 08 2B 01 D3 63 68 00 E0 23 1D 03 EB 42 03 2D B1 03 EB 45 02 23 F8 02 7B 93 42 FB D1 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 23 F8 16 20 20 46 BD E8 F0 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_946_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 160
		refs = "0042 ?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@II@Z 004e ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 0074 memcpy 0094 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0D 46 1E 46 6B 69 17 46 04 46 BB 42 3D D3 DB 1B 9E 42 88 BF 1E 46 AC 42 12 D1 63 69 F2 19 93 42 36 D3 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 21 62 61 23 F8 12 10 3A 46 20 46 ?? ?? ?? ?? 21 E0 00 22 31 46 20 46 ?? ?? ?? ?? D8 B1 AB 69 08 2B 01 D3 69 68 00 E0 29 1D A3 69 08 2B 01 D3 60 68 00 E0 20 1D 26 B1 72 00 01 EB 47 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 23 F8 16 20 20 46 BD E8 F0 88 28 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_952_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 160
		refs = "0042 ?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II@Z 004e ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 0074 memcpy 0094 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0D 46 1E 46 6B 69 17 46 04 46 BB 42 3D D3 DB 1B 9E 42 88 BF 1E 46 AC 42 12 D1 63 69 F2 19 93 42 36 D3 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 21 62 61 23 F8 12 10 3A 46 20 46 ?? ?? ?? ?? 21 E0 00 22 31 46 20 46 ?? ?? ?? ?? D8 B1 AB 69 08 2B 01 D3 69 68 00 E0 29 1D A3 69 08 2B 01 D3 60 68 00 E0 20 1D 26 B1 72 00 01 EB 47 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 23 F8 16 20 20 46 BD E8 F0 88 28 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_947_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z"
		size = 104
		refs = "0016 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 0062 ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 16 46 0D 46 04 46 B1 F1 FF 3F 26 D0 00 22 ?? ?? ?? ?? F8 B1 A3 69 01 2D 06 D1 08 2B 01 D3 63 68 00 E0 23 1D 1E 80 0B E0 08 2B 01 D3 63 68 00 E0 23 1D 2D B1 03 EB 45 02 23 F8 02 6B 93 42 FB D1 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 23 F8 15 20 20 46 BD E8 78 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_953_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z"
		size = 104
		refs = "0016 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 0062 ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 16 46 0D 46 04 46 B1 F1 FF 3F 26 D0 00 22 ?? ?? ?? ?? F8 B1 A3 69 01 2D 06 D1 08 2B 01 D3 63 68 00 E0 23 1D 1E 80 0B E0 08 2B 01 D3 63 68 00 E0 23 1D 2D B1 03 EB 45 02 23 F8 02 6B 93 42 FB D1 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 23 F8 15 20 20 46 BD E8 78 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_948_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBG@Z"
		size = 40
		refs = "0016 wcslen 0020 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBGI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 23 88 05 46 0B B9 00 20 02 E0 20 46 ?? ?? ?? ?? 02 46 28 46 21 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_79_109_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_W@Z"
		size = 40
		refs = "0016 wcslen 0020 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 23 88 05 46 0B B9 00 20 02 E0 20 46 ?? ?? ?? ?? 02 46 28 46 21 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_17_954_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_W@Z"
		size = 40
		refs = "0016 wcslen 0020 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 23 88 05 46 0B B9 00 20 02 E0 20 46 ?? ?? ?? ?? 02 46 28 46 21 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_17_949_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBGI@Z"
		size = 140
		refs = "0048 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z 0056 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 006e memcpy"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0E 46 15 46 04 46 FE B1 A2 69 08 2A 01 D3 63 68 00 E0 23 1D 9E 42 17 D3 08 2A 01 D3 61 68 00 E0 21 1D 63 69 01 EB 43 03 B3 42 0D D9 08 2A 01 D3 63 68 00 E0 23 1D F3 1A 5A 10 2B 46 21 46 20 46 ?? ?? ?? ?? 04 46 1A E0 00 22 29 46 20 46 ?? ?? ?? ?? A0 B1 A3 69 08 2B 01 D3 60 68 00 E0 20 1D 1D B1 6A 00 31 46 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 23 F8 15 20 20 46 BD E8 78 88 }
	condition:
		$1
}

rule file_17_955_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
		size = 140
		refs = "0048 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z 0056 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 006e memcpy"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0E 46 15 46 04 46 FE B1 A2 69 08 2A 01 D3 63 68 00 E0 23 1D 9E 42 17 D3 08 2A 01 D3 61 68 00 E0 21 1D 63 69 01 EB 43 03 B3 42 0D D9 08 2A 01 D3 63 68 00 E0 23 1D F3 1A 5A 10 2B 46 21 46 20 46 ?? ?? ?? ?? 04 46 1A E0 00 22 29 46 20 46 ?? ?? ?? ?? A0 B1 A3 69 08 2B 01 D3 60 68 00 E0 20 1D 1D B1 6A 00 31 46 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 65 61 23 F8 15 20 20 46 BD E8 78 88 }
	condition:
		$1
}

rule file_17_958_1 {
	meta:
		name = "?assign@?$char_traits@G@std@@SAPAGPAGIG@Z"
		size = 26
		altNames = "?assign@?$char_traits@_W@std@@SAPA_WPA_WI_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 31 B1 03 46 00 EB 41 01 23 F8 02 2B 8B 42 FB D1 BD E8 00 88 }
	condition:
		$1
}

rule file_17_962_1 {
	meta:
		name = "?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 36
		altNames = "?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 83 69 08 2B 01 D3 43 68 00 E0 03 1D 00 22 C1 E9 00 22 8B 60 03 68 08 46 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_993_1 {
	meta:
		name = "?do_compare@?$collate@G@std@@MBAHPBG000@Z"
		size = 58
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 9D 08 E0 AB 42 0A D0 08 88 33 F8 02 4B 84 42 0B D8 08 D3 89 1C 91 42 F4 D1 AB 42 05 D1 91 42 08 BF 00 20 03 D0 01 20 01 E0 6F F0 00 00 BD E8 30 88 }
	condition:
		$1
}

rule file_17_994_1 {
	meta:
		name = "?do_compare@?$collate@_W@std@@MBAHPB_W000@Z"
		size = 52
		refs = "001a _Wcscoll"
	strings:
		$1 = { 2D E9 7E 48 0D F1 18 0B 1C 46 08 9B 08 30 15 46 0E 46 00 90 30 46 22 46 29 46 ?? ?? ?? ?? 00 28 02 DA 6F F0 00 00 03 E0 08 BF 00 20 18 BF 01 20 BD E8 7E 88 }
	condition:
		$1
}

rule file_99_413_1 {
	meta:
		name = "?do_compare@?$collate@D@std@@MBAHPBD000@Z"
		size = 52
		refs = "001a _Strcoll"
	strings:
		$1 = { 2D E9 7E 48 0D F1 18 0B 1C 46 08 9B 08 30 15 46 0E 46 00 90 30 46 22 46 29 46 ?? ?? ?? ?? 00 28 02 DA 6F F0 00 00 03 E0 08 BF 00 20 18 BF 01 20 BD E8 7E 88 }
	condition:
		$1
}

rule file_17_1010_1 {
	meta:
		name = "?do_get@?$messages@G@std@@MBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@HHHABV32@@Z"
		size = 24
		refs = "000e ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 05 99 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_99_418_1 {
	meta:
		name = "?do_get@?$messages@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@HHHABV32@@Z"
		size = 24
		refs = "000e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 05 99 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1011_1 {
	meta:
		name = "?do_get@?$messages@_W@std@@MBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@HHHABV32@@Z"
		size = 24
		refs = "000e ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 05 99 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1012_1 {
	meta:
		name = "?do_get@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z"
		size = 242
		refs = "000a __security_push_cookie 0044 ?_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0_NAAVios_base@2@PAG@Z 0052 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 008e _errno 009e strtod 00ce ??3@YAXPAX@Z 00e6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 92 B0 6F 46 84 B0 6F F0 01 03 C7 E9 02 33 17 F1 30 03 D7 F8 8C 20 02 93 97 F8 88 30 D7 F8 90 60 D7 F8 94 A0 00 93 89 46 01 92 17 F1 80 03 17 F1 78 02 17 F1 10 01 ?? ?? ?? ?? 97 F8 7C 30 1B B9 17 F1 78 00 ?? ?? ?? ?? 97 F8 84 30 1B B9 17 F1 80 00 ?? ?? ?? ?? BA 6F D7 F8 80 30 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 6A E3 B1 BB 6A 10 2B 02 D3 D7 F8 14 80 01 E0 17 F1 14 08 ?? ?? ?? ?? 05 46 2C 68 40 46 00 23 39 46 2B 60 ?? ?? ?? ?? 2A 68 2C 60 3B 68 43 45 04 D0 1A B9 BA 6F 8A ED 00 0B 04 E0 BA 6F 33 68 43 F0 02 03 33 60 FB 6F C9 E9 00 23 BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 48 46 16 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1016_1 {
	meta:
		name = "?do_get@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z"
		size = 242
		refs = "000a __security_push_cookie 0044 ?_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0_NAAVios_base@2@PA_W@Z 0052 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 008e _errno 009e strtod 00ce ??3@YAXPAX@Z 00e6 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 92 B0 6F 46 84 B0 6F F0 01 03 C7 E9 02 33 17 F1 30 03 D7 F8 8C 20 02 93 97 F8 88 30 D7 F8 90 60 D7 F8 94 A0 00 93 89 46 01 92 17 F1 80 03 17 F1 78 02 17 F1 10 01 ?? ?? ?? ?? 97 F8 7C 30 1B B9 17 F1 78 00 ?? ?? ?? ?? 97 F8 84 30 1B B9 17 F1 80 00 ?? ?? ?? ?? BA 6F D7 F8 80 30 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 7B 6A E3 B1 BB 6A 10 2B 02 D3 D7 F8 14 80 01 E0 17 F1 14 08 ?? ?? ?? ?? 05 46 2C 68 40 46 00 23 39 46 2B 60 ?? ?? ?? ?? 2A 68 2C 60 3B 68 43 45 04 D0 1A B9 BA 6F 8A ED 00 0B 04 E0 BA 6F 33 68 43 F0 02 03 33 60 FB 6F C9 E9 00 23 BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 48 46 16 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1014_1 {
	meta:
		name = "?do_get@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z"
		size = 338
		refs = "000a __security_push_cookie 0042 ?_Getmfld@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0_NAAVios_base@2@PAG@Z 0052 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00ac ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z 011a _invalid_parameter_noinfo_noreturn 012e ??3@YAXPAX@Z 0146 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? 90 B0 6F 46 84 B0 6F F0 01 03 C7 E9 00 33 17 F1 28 03 FA 6F 02 93 97 F8 78 30 D7 F8 80 50 D7 F8 84 40 00 93 88 46 01 92 17 F1 70 03 17 F1 68 02 17 F1 08 01 ?? ?? ?? ?? 97 F8 6C 30 FE 69 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 36 B9 2B 68 3A 6A F8 68 43 F0 02 03 2B 60 4D E0 63 69 00 25 9E 42 0A D8 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 23 F8 16 20 04 E0 F1 1A 00 22 20 46 ?? ?? ?? ?? 3A 6A F8 68 10 2A 28 BF 03 46 01 D2 17 F1 0C 03 93 F9 00 30 2D 2B 25 D1 A3 69 08 2B 01 D3 62 68 00 E0 22 1D BB 8F 01 25 13 80 19 E0 FB 69 9D 42 1D D8 10 2A 01 D2 17 F1 0C 00 63 69 9D 42 14 D8 A3 69 08 2B 01 D3 61 68 00 E0 21 1D 42 57 17 F1 28 03 03 EB 42 03 33 F8 60 3C 21 F8 15 30 6D 1C F8 68 3A 6A B5 42 E1 D3 03 E0 ?? ?? ?? ?? ?? ?? ?? ?? B9 6E FB 6E C8 E9 00 13 10 2A 01 D3 ?? ?? ?? ?? 0F 23 B8 68 3B 62 00 23 FB 61 3B 73 ?? ?? ?? ?? 40 46 14 B0 ?? ?? ?? ?? BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1018_1 {
	meta:
		name = "?do_get@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z"
		size = 338
		refs = "000a __security_push_cookie 0042 ?_Getmfld@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0_NAAVios_base@2@PA_W@Z 0052 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00ac ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z 011a _invalid_parameter_noinfo_noreturn 012e ??3@YAXPAX@Z 0146 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? 90 B0 6F 46 84 B0 6F F0 01 03 C7 E9 00 33 17 F1 28 03 FA 6F 02 93 97 F8 78 30 D7 F8 80 50 D7 F8 84 40 00 93 88 46 01 92 17 F1 70 03 17 F1 68 02 17 F1 08 01 ?? ?? ?? ?? 97 F8 6C 30 FE 69 1B B9 17 F1 68 00 ?? ?? ?? ?? 97 F8 74 30 1B B9 17 F1 70 00 ?? ?? ?? ?? B9 6E 3B 6F 09 B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 36 B9 2B 68 3A 6A F8 68 43 F0 02 03 2B 60 4D E0 63 69 00 25 9E 42 0A D8 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 23 F8 16 20 04 E0 F1 1A 00 22 20 46 ?? ?? ?? ?? 3A 6A F8 68 10 2A 28 BF 03 46 01 D2 17 F1 0C 03 93 F9 00 30 2D 2B 25 D1 A3 69 08 2B 01 D3 62 68 00 E0 22 1D BB 8F 01 25 13 80 19 E0 FB 69 9D 42 1D D8 10 2A 01 D2 17 F1 0C 00 63 69 9D 42 14 D8 A3 69 08 2B 01 D3 61 68 00 E0 21 1D 42 57 17 F1 28 03 03 EB 42 03 33 F8 60 3C 21 F8 15 30 6D 1C F8 68 3A 6A B5 42 E1 D3 03 E0 ?? ?? ?? ?? ?? ?? ?? ?? B9 6E FB 6E C8 E9 00 13 10 2A 01 D3 ?? ?? ?? ?? 0F 23 B8 68 3B 62 00 23 FB 61 3B 73 ?? ?? ?? ?? 40 46 14 B0 ?? ?? ?? ?? BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1044_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z"
		size = 534
		refs = "000a __security_push_cookie 0040 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0044 ??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 005c _guard_check_icall 0080 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@IG@Z 008a ?falsename@?$numpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 0098 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z 00a4 ??3@YAXPAX@Z 00c0 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z 00ca ?truename@?$numpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 0110 ??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z 0156 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0166 _Stoulx 01ba ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 020a __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A2 B0 6F 46 82 B0 6F F0 01 03 C7 E9 08 33 D7 F8 D0 30 D7 F8 C8 40 D7 F8 CC 60 3B 61 63 69 80 46 89 46 13 F4 80 4F 6F F0 00 05 20 46 7C D0 17 F1 08 01 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 D7 F8 0C 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 17 F1 48 00 00 22 01 21 ?? ?? ?? ?? 17 F1 28 01 50 46 ?? ?? ?? ?? 01 46 17 F1 48 00 2B 46 00 22 ?? ?? ?? ?? 3B 6C 08 2B 02 D3 F8 6A ?? ?? ?? ?? 07 23 B8 6A 3B 64 00 23 FB 63 BB 85 ?? ?? ?? ?? 17 F1 48 00 00 22 01 21 ?? ?? ?? ?? 17 F1 28 01 50 46 ?? ?? ?? ?? 01 46 17 F1 48 00 2B 46 00 22 ?? ?? ?? ?? 3B 6C 08 2B 02 D3 F8 6A ?? ?? ?? ?? 07 23 B8 6A 3B 64 00 23 FB 63 BB 85 ?? ?? ?? ?? 3B 6E 08 2B 01 D3 FB 6C 01 E0 17 F1 4C 03 17 F1 C0 01 17 F1 B8 00 02 22 ?? ?? ?? ?? 05 46 3B 6E 08 2B 02 D3 F8 6C ?? ?? ?? ?? 07 23 B8 6C 3B 66 00 23 FB 65 A7 F8 4C 30 ?? ?? ?? ?? 3C E0 00 23 17 F1 18 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 B8 02 00 93 17 F1 C0 03 17 F1 68 01 40 46 ?? ?? ?? ?? 02 46 17 F1 68 00 3B 46 17 F1 08 01 ?? ?? ?? ?? 82 46 D7 F8 1C 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 BB 68 17 F1 68 02 93 42 05 D0 3B 68 1B B9 BA F1 01 0F 98 BF 55 46 97 F8 BC 30 1B B9 17 F1 B8 00 ?? ?? ?? ?? 97 F8 C4 30 1B B9 17 F1 C0 00 ?? ?? ?? ?? D7 F8 B8 20 D7 F8 C0 30 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 00 2D 04 DA 33 68 43 F0 02 03 33 60 05 E0 39 69 18 BF 01 23 08 BF 00 23 0B 70 D7 F8 BC 30 C9 E9 00 23 48 46 24 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1076_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z"
		size = 534
		refs = "000a __security_push_cookie 0040 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0044 ??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 005c _guard_check_icall 0080 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@I_W@Z 008a ?falsename@?$numpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 0098 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z 00a4 ??3@YAXPAX@Z 00c0 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z 00ca ?truename@?$numpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 0110 ??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z 0156 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0166 _Stoulx 01ba ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 020a __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A2 B0 6F 46 82 B0 6F F0 01 03 C7 E9 08 33 D7 F8 D0 30 D7 F8 C8 40 D7 F8 CC 60 3B 61 63 69 80 46 89 46 13 F4 80 4F 6F F0 00 05 20 46 7C D0 17 F1 08 01 ?? ?? ?? ?? ?? ?? ?? ?? 82 46 D7 F8 0C 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 17 F1 48 00 00 22 01 21 ?? ?? ?? ?? 17 F1 28 01 50 46 ?? ?? ?? ?? 01 46 17 F1 48 00 2B 46 00 22 ?? ?? ?? ?? 3B 6C 08 2B 02 D3 F8 6A ?? ?? ?? ?? 07 23 B8 6A 3B 64 00 23 FB 63 BB 85 ?? ?? ?? ?? 17 F1 48 00 00 22 01 21 ?? ?? ?? ?? 17 F1 28 01 50 46 ?? ?? ?? ?? 01 46 17 F1 48 00 2B 46 00 22 ?? ?? ?? ?? 3B 6C 08 2B 02 D3 F8 6A ?? ?? ?? ?? 07 23 B8 6A 3B 64 00 23 FB 63 BB 85 ?? ?? ?? ?? 3B 6E 08 2B 01 D3 FB 6C 01 E0 17 F1 4C 03 17 F1 C0 01 17 F1 B8 00 02 22 ?? ?? ?? ?? 05 46 3B 6E 08 2B 02 D3 F8 6C ?? ?? ?? ?? 07 23 B8 6C 3B 66 00 23 FB 65 A7 F8 4C 30 ?? ?? ?? ?? 3C E0 00 23 17 F1 18 01 3B 60 ?? ?? ?? ?? 63 69 01 90 17 F1 B8 02 00 93 17 F1 C0 03 17 F1 68 01 40 46 ?? ?? ?? ?? 02 46 17 F1 68 00 3B 46 17 F1 08 01 ?? ?? ?? ?? 82 46 D7 F8 1C 80 B8 F1 00 0F 11 D0 D8 F8 00 30 9C 68 20 46 ?? ?? ?? ?? 40 46 A0 47 80 46 38 B1 03 68 1C 68 20 46 ?? ?? ?? ?? 40 46 01 21 A0 47 BB 68 17 F1 68 02 93 42 05 D0 3B 68 1B B9 BA F1 01 0F 98 BF 55 46 97 F8 BC 30 1B B9 17 F1 B8 00 ?? ?? ?? ?? 97 F8 C4 30 1B B9 17 F1 C0 00 ?? ?? ?? ?? D7 F8 B8 20 D7 F8 C0 30 0A B9 0B B1 04 E0 1B B1 33 68 43 F0 01 03 33 60 00 2D 04 DA 33 68 43 F0 02 03 33 60 05 E0 39 69 18 BF 01 23 08 BF 00 23 0B 70 D7 F8 BC 30 C9 E9 00 23 48 46 24 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1084_1 {
	meta:
		name = "?do_get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z"
		size = 852
		refs = "0026 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 002a ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 003a _guard_check_icall 0144 ?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0168 ?_Getint@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0HHAAHABV?$ctype@G@2@@Z 0256 ??$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBD@Z 02f8 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 0334 ??_C@_0N@LADGFGLL@?$CFd?5?1?5?$CFm?5?1?5?$CFy?$AA@ 0338 ??_C@_0N@GEFMGHCI@?$CFH?5?3?5?$CFM?5?3?5?$CFS?$AA@ 033c ??_C@_07GLPBMING@?$CFH?5?3?5?$CFM?$AA@ 0340 ??_C@_0BA@HGEPHOKI@?$CFI?5?3?5?$CFM?5?3?5?$CFS?5?$CFp?$AA@ 0344 ??_C@_0N@LPFKKEBD@?3AM?3am?3PM?3pm?$AA@ 0348 ??_C@_01CLKCMJKC@?5?$AA@ 034c ??_C@_0N@LIAHCJPJ@?$CFm?5?1?5?$CFd?5?1?5?$CFy?$AA@ 0350 ??_C@_0BG@ELKJEKEA@?$CFb?5?$CFd?5?$CFH?5?3?5?$CFM?5?3?5?$CFS?5?$CFY?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 87 B0 6F 46 86 B0 D7 F8 58 90 8A 46 06 46 6F F0 01 03 48 46 17 F1 08 01 C7 E9 04 33 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 FD 6D 00 23 3B 60 2B 60 97 F9 64 30 A3 F1 41 02 38 2A 00 F2 3D 81 DF E8 12 F0 39 00 51 00 70 00 9F 00 3B 01 3B 01 3B 01 A1 00 AC 00 3B 01 3B 01 3B 01 E6 00 3B 01 3B 01 3B 01 3B 01 04 01 06 01 0A 01 0C 01 3B 01 0C 01 0A 01 32 01 3B 01 3B 01 3B 01 3B 01 3B 01 3B 01 3B 01 39 00 51 00 5A 00 8D 00 8D 00 3B 01 3B 01 51 00 3B 01 C7 00 3B 01 3B 01 CD 00 EB 00 3B 01 ED 00 3B 01 02 01 3B 01 EB 00 3B 01 3B 01 11 01 16 01 18 01 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 9C 69 20 46 03 95 CD F8 08 90 ?? ?? ?? ?? D7 E9 12 23 30 46 39 46 A0 47 D7 E9 00 21 BA 64 F9 64 ED E0 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 DC 69 E6 E7 8A 4B 05 93 3B 6E BA 6C 17 F1 08 01 04 93 3B 6D 30 46 03 95 00 93 7B 6D CD F8 08 90 01 93 FB 6C ?? ?? ?? ?? 02 68 BA 64 41 68 DE E7 3B 46 01 93 63 23 00 93 00 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 40 F0 B8 80 3B 68 13 3B 64 22 03 FB 02 F2 3B 6E 5A 61 AF E0 3B 6E 0C 33 01 93 1F 23 00 93 17 F1 50 02 17 F1 48 01 01 23 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 9C E0 67 4B B9 E7 3B 6E 08 33 01 93 17 23 00 93 17 F1 50 02 17 F1 48 01 00 23 EA E7 3B 46 01 93 0C 23 00 93 01 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 7C D1 3A 68 3B 6E 0C 2A 08 BF 00 22 9A 60 75 E0 3B 6E 1C 33 01 93 4F F4 B7 73 C3 E7 3B 46 01 93 0C 23 00 93 01 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 5B D1 3B 68 5A 1E 3B 6E 1A 61 56 E0 3B 6E 1B 1D 01 93 3B 23 B9 E7 40 4B 6D E7 3E 4B 17 F1 50 01 17 F1 48 00 00 22 ?? ?? ?? ?? 00 28 03 DA 2B 68 43 F0 02 03 40 E0 01 28 3F DD 3A 6E 93 68 0C 33 93 60 3A E0 32 4B 56 E7 30 4B 54 E7 3B 6E 01 93 3C 23 9A E7 2C 4B 4E E7 3B 6E 1C 33 01 93 35 23 93 E7 3B 6E 18 33 01 93 06 23 8E E7 25 4B 42 E7 3B 46 01 93 63 23 00 93 00 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 10 D1 3A 68 45 2A BF F6 5A AF 64 32 57 E7 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 1C 6A 05 E7 02 23 2B 60 D7 E9 12 21 97 F8 4C 30 2B B9 17 F1 48 00 ?? ?? ?? ?? D7 E9 12 21 97 F8 54 30 2B B9 17 F1 50 00 ?? ?? ?? ?? D7 E9 12 21 3B 6D 0A B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 CA E9 00 21 50 46 0D B0 BD E8 F0 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_423_1 {
	meta:
		name = "?do_get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z"
		size = 852
		refs = "0026 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 002a ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 003a _guard_check_icall 0144 ?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0168 ?_Getint@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@0HHAAHABV?$ctype@D@2@@Z 0256 ??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z 02f8 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABADXZ 0334 ??_C@_0N@LADGFGLL@?$CFd?5?1?5?$CFm?5?1?5?$CFy?$AA@ 0338 ??_C@_0N@GEFMGHCI@?$CFH?5?3?5?$CFM?5?3?5?$CFS?$AA@ 033c ??_C@_07GLPBMING@?$CFH?5?3?5?$CFM?$AA@ 0340 ??_C@_0BA@HGEPHOKI@?$CFI?5?3?5?$CFM?5?3?5?$CFS?5?$CFp?$AA@ 0344 ??_C@_0N@LPFKKEBD@?3AM?3am?3PM?3pm?$AA@ 0348 ??_C@_01CLKCMJKC@?5?$AA@ 034c ??_C@_0N@LIAHCJPJ@?$CFm?5?1?5?$CFd?5?1?5?$CFy?$AA@ 0350 ??_C@_0BG@ELKJEKEA@?$CFb?5?$CFd?5?$CFH?5?3?5?$CFM?5?3?5?$CFS?5?$CFY?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 87 B0 6F 46 86 B0 D7 F8 58 90 8A 46 06 46 6F F0 01 03 48 46 17 F1 08 01 C7 E9 04 33 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 FD 6D 00 23 3B 60 2B 60 97 F9 64 30 A3 F1 41 02 38 2A 00 F2 3D 81 DF E8 12 F0 39 00 51 00 70 00 9F 00 3B 01 3B 01 3B 01 A1 00 AC 00 3B 01 3B 01 3B 01 E6 00 3B 01 3B 01 3B 01 3B 01 04 01 06 01 0A 01 0C 01 3B 01 0C 01 0A 01 32 01 3B 01 3B 01 3B 01 3B 01 3B 01 3B 01 3B 01 39 00 51 00 5A 00 8D 00 8D 00 3B 01 3B 01 51 00 3B 01 C7 00 3B 01 3B 01 CD 00 EB 00 3B 01 ED 00 3B 01 02 01 3B 01 EB 00 3B 01 3B 01 11 01 16 01 18 01 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 9C 69 20 46 03 95 CD F8 08 90 ?? ?? ?? ?? D7 E9 12 23 30 46 39 46 A0 47 D7 E9 00 21 BA 64 F9 64 ED E0 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 DC 69 E6 E7 8A 4B 05 93 3B 6E BA 6C 17 F1 08 01 04 93 3B 6D 30 46 03 95 00 93 7B 6D CD F8 08 90 01 93 FB 6C ?? ?? ?? ?? 02 68 BA 64 41 68 DE E7 3B 46 01 93 63 23 00 93 00 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 40 F0 B8 80 3B 68 13 3B 64 22 03 FB 02 F2 3B 6E 5A 61 AF E0 3B 6E 0C 33 01 93 1F 23 00 93 17 F1 50 02 17 F1 48 01 01 23 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 9C E0 67 4B B9 E7 3B 6E 08 33 01 93 17 23 00 93 17 F1 50 02 17 F1 48 01 00 23 EA E7 3B 46 01 93 0C 23 00 93 01 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 7C D1 3A 68 3B 6E 0C 2A 08 BF 00 22 9A 60 75 E0 3B 6E 1C 33 01 93 4F F4 B7 73 C3 E7 3B 46 01 93 0C 23 00 93 01 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 5B D1 3B 68 5A 1E 3B 6E 1A 61 56 E0 3B 6E 1B 1D 01 93 3B 23 B9 E7 40 4B 6D E7 3E 4B 17 F1 50 01 17 F1 48 00 00 22 ?? ?? ?? ?? 00 28 03 DA 2B 68 43 F0 02 03 40 E0 01 28 3F DD 3A 6E 93 68 0C 33 93 60 3A E0 32 4B 56 E7 30 4B 54 E7 3B 6E 01 93 3C 23 9A E7 2C 4B 4E E7 3B 6E 1C 33 01 93 35 23 93 E7 3B 6E 18 33 01 93 06 23 8E E7 25 4B 42 E7 3B 46 01 93 63 23 00 93 00 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 10 D1 3A 68 45 2A BF F6 5A AF 64 32 57 E7 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 1C 6A 05 E7 02 23 2B 60 D7 E9 12 21 97 F8 4C 30 2B B9 17 F1 48 00 ?? ?? ?? ?? D7 E9 12 21 97 F8 54 30 2B B9 17 F1 50 00 ?? ?? ?? ?? D7 E9 12 21 3B 6D 0A B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 CA E9 00 21 50 46 0D B0 BD E8 F0 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1087_1 {
	meta:
		name = "?do_get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z"
		size = 852
		refs = "0026 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 002a ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 003a _guard_check_icall 0144 ?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0168 ?_Getint@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0HHAAHABV?$ctype@_W@2@@Z 0256 ??$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPBD@Z 02f8 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 0334 ??_C@_0N@LADGFGLL@?$CFd?5?1?5?$CFm?5?1?5?$CFy?$AA@ 0338 ??_C@_0N@GEFMGHCI@?$CFH?5?3?5?$CFM?5?3?5?$CFS?$AA@ 033c ??_C@_07GLPBMING@?$CFH?5?3?5?$CFM?$AA@ 0340 ??_C@_0BA@HGEPHOKI@?$CFI?5?3?5?$CFM?5?3?5?$CFS?5?$CFp?$AA@ 0344 ??_C@_0N@LPFKKEBD@?3AM?3am?3PM?3pm?$AA@ 0348 ??_C@_01CLKCMJKC@?5?$AA@ 034c ??_C@_0N@LIAHCJPJ@?$CFm?5?1?5?$CFd?5?1?5?$CFy?$AA@ 0350 ??_C@_0BG@ELKJEKEA@?$CFb?5?$CFd?5?$CFH?5?3?5?$CFM?5?3?5?$CFS?5?$CFY?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 87 B0 6F 46 86 B0 D7 F8 58 90 8A 46 06 46 6F F0 01 03 48 46 17 F1 08 01 C7 E9 04 33 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 FD 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 FD 6D 00 23 3B 60 2B 60 97 F9 64 30 A3 F1 41 02 38 2A 00 F2 3D 81 DF E8 12 F0 39 00 51 00 70 00 9F 00 3B 01 3B 01 3B 01 A1 00 AC 00 3B 01 3B 01 3B 01 E6 00 3B 01 3B 01 3B 01 3B 01 04 01 06 01 0A 01 0C 01 3B 01 0C 01 0A 01 32 01 3B 01 3B 01 3B 01 3B 01 3B 01 3B 01 3B 01 39 00 51 00 5A 00 8D 00 8D 00 3B 01 3B 01 51 00 3B 01 C7 00 3B 01 3B 01 CD 00 EB 00 3B 01 ED 00 3B 01 02 01 3B 01 EB 00 3B 01 3B 01 11 01 16 01 18 01 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 9C 69 20 46 03 95 CD F8 08 90 ?? ?? ?? ?? D7 E9 12 23 30 46 39 46 A0 47 D7 E9 00 21 BA 64 F9 64 ED E0 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 DC 69 E6 E7 8A 4B 05 93 3B 6E BA 6C 17 F1 08 01 04 93 3B 6D 30 46 03 95 00 93 7B 6D CD F8 08 90 01 93 FB 6C ?? ?? ?? ?? 02 68 BA 64 41 68 DE E7 3B 46 01 93 63 23 00 93 00 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 40 F0 B8 80 3B 68 13 3B 64 22 03 FB 02 F2 3B 6E 5A 61 AF E0 3B 6E 0C 33 01 93 1F 23 00 93 17 F1 50 02 17 F1 48 01 01 23 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 9C E0 67 4B B9 E7 3B 6E 08 33 01 93 17 23 00 93 17 F1 50 02 17 F1 48 01 00 23 EA E7 3B 46 01 93 0C 23 00 93 01 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 7C D1 3A 68 3B 6E 0C 2A 08 BF 00 22 9A 60 75 E0 3B 6E 1C 33 01 93 4F F4 B7 73 C3 E7 3B 46 01 93 0C 23 00 93 01 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 5B D1 3B 68 5A 1E 3B 6E 1A 61 56 E0 3B 6E 1B 1D 01 93 3B 23 B9 E7 40 4B 6D E7 3E 4B 17 F1 50 01 17 F1 48 00 00 22 ?? ?? ?? ?? 00 28 03 DA 2B 68 43 F0 02 03 40 E0 01 28 3F DD 3A 6E 93 68 0C 33 93 60 3A E0 32 4B 56 E7 30 4B 54 E7 3B 6E 01 93 3C 23 9A E7 2C 4B 4E E7 3B 6E 1C 33 01 93 35 23 93 E7 3B 6E 18 33 01 93 06 23 8E E7 25 4B 42 E7 3B 46 01 93 63 23 00 93 00 23 17 F1 50 02 17 F1 48 01 30 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 2B 60 13 F0 02 0F 10 D1 3A 68 45 2A BF F6 5A AF 64 32 57 E7 3B 6E 04 93 3B 6D 00 93 7B 6D 01 93 33 68 1C 6A 05 E7 02 23 2B 60 D7 E9 12 21 97 F8 4C 30 2B B9 17 F1 48 00 ?? ?? ?? ?? D7 E9 12 21 97 F8 54 30 2B B9 17 F1 50 00 ?? ?? ?? ?? D7 E9 12 21 3B 6D 0A B9 0B B1 04 E0 1B B1 2B 68 43 F0 01 03 2B 60 CA E9 00 21 50 46 0D B0 BD E8 F0 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1090_1 {
	meta:
		name = "?do_get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 1682
		refs = "0022 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0026 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0036 _guard_check_icall 0072 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 0114 ?_Getint@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0HHAAHABV?$ctype@G@2@@Z 01ec ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 89 B0 6F 46 86 B0 81 46 38 6E 39 60 6F F0 01 03 17 F1 10 01 C7 E9 06 33 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 69 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D9 F8 00 30 DC 68 20 46 ?? ?? ?? ?? 48 46 A0 47 05 46 05 B9 02 25 97 F8 54 10 29 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 54 10 97 F8 5C 00 38 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 97 F8 54 10 3C 6D D7 F8 68 A0 7E 6E BA 6D 14 B9 00 2A 78 D0 01 E0 00 2A 75 D1 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 04 21 A0 47 B0 B9 3B 6E CD F8 10 A0 03 96 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 DC 69 20 46 ?? ?? ?? ?? D7 E9 14 23 48 46 17 F1 08 01 A0 47 02 25 44 E0 02 2D 18 D1 0A F1 10 03 01 93 0C 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 33 60 DA F8 10 30 5B 1E CA F8 10 30 3C 6D 2D E0 01 2D 12 D1 0A F1 0C 03 01 93 1F 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 33 60 E8 E7 3B 6E CD F8 10 A0 03 96 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 1C 6A 20 46 ?? ?? ?? ?? D7 E9 14 23 48 46 17 F1 08 01 A0 47 D7 E9 02 43 C7 E9 14 43 97 F8 5C 00 BA 6D 97 F8 54 10 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 EA B1 00 E0 DA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 48 21 A0 47 20 B1 17 F1 50 00 ?? ?? ?? ?? 9A E7 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 0A B3 00 E0 FA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 9C 6B 20 46 ?? ?? ?? ?? B7 F8 56 10 40 46 00 22 A0 47 3A 28 03 D0 2C 28 01 D0 2F 28 03 D1 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 CA B1 00 E0 BA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 48 21 A0 47 00 28 C9 D1 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 14 B9 00 2A 6F D0 01 E0 00 2A 6C D1 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 04 21 A0 47 40 BB 02 2D 04 D1 33 68 43 F0 02 03 33 60 4E E0 3B 6E CD F8 10 A0 03 96 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 DC 69 20 46 ?? ?? ?? ?? D7 E9 14 23 48 46 17 F1 08 01 A0 47 D7 E9 02 43 97 F8 5C 00 BA 6D C7 E9 14 43 97 F8 54 10 04 2D 34 D1 03 25 32 E0 01 2D 13 D0 03 2D 11 D0 0A F1 0C 03 01 93 1F 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 C5 E7 0A F1 10 03 01 93 0C 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 33 60 DA F8 10 30 5B 1E CA F8 10 30 3C 6D 97 F8 54 10 BA 6D 97 F8 5C 00 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 EA B1 00 E0 DA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 48 21 A0 47 20 B1 17 F1 50 00 ?? ?? ?? ?? C9 E7 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 0A B3 00 E0 FA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 9C 6B 20 46 ?? ?? ?? ?? B7 F8 56 10 40 46 00 22 A0 47 3A 28 03 D0 2C 28 01 D0 2F 28 03 D1 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 CA B1 00 E0 BA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 48 21 A0 47 00 28 C9 D1 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 0A B1 06 E0 2A B1 33 68 7D 6D 43 F0 02 03 33 60 6F E0 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 04 21 A0 47 90 B9 04 2D 06 D0 33 68 43 F0 02 03 33 60 D7 E9 14 45 50 E0 3B 6E 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 DC 69 36 E0 04 2D 17 D1 0A F1 10 03 01 93 0C 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 33 60 DA F8 10 30 5B 1E CA F8 10 30 D8 E7 03 2D 11 D1 0A F1 0C 03 01 93 1F 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 C3 E7 3B 6E 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 1C 6A 20 46 03 96 CD F8 10 A0 ?? ?? ?? ?? D7 E9 14 23 17 F1 08 01 48 46 A0 47 D7 E9 02 45 C7 E9 14 45 97 F8 5C 00 BA 6D 97 F8 54 10 41 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D D7 E9 14 45 30 B9 17 F1 58 00 ?? ?? ?? ?? BA 6D D7 E9 14 45 0C B9 0A B1 04 E0 1A B1 33 68 43 F0 01 03 33 60 3B 68 C3 E9 00 45 18 46 0F B0 BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1093_1 {
	meta:
		name = "?do_get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 1682
		refs = "0022 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0026 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0036 _guard_check_icall 0072 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 0114 ?_Getint@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0HHAAHABV?$ctype@_W@2@@Z 01ec ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 89 B0 6F 46 86 B0 81 46 38 6E 39 60 6F F0 01 03 17 F1 10 01 C7 E9 06 33 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 69 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D9 F8 00 30 DC 68 20 46 ?? ?? ?? ?? 48 46 A0 47 05 46 05 B9 02 25 97 F8 54 10 29 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 54 10 97 F8 5C 00 38 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 97 F8 54 10 3C 6D D7 F8 68 A0 7E 6E BA 6D 14 B9 00 2A 78 D0 01 E0 00 2A 75 D1 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 04 21 A0 47 B0 B9 3B 6E CD F8 10 A0 03 96 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 DC 69 20 46 ?? ?? ?? ?? D7 E9 14 23 48 46 17 F1 08 01 A0 47 02 25 44 E0 02 2D 18 D1 0A F1 10 03 01 93 0C 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 33 60 DA F8 10 30 5B 1E CA F8 10 30 3C 6D 2D E0 01 2D 12 D1 0A F1 0C 03 01 93 1F 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 33 60 E8 E7 3B 6E CD F8 10 A0 03 96 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 1C 6A 20 46 ?? ?? ?? ?? D7 E9 14 23 48 46 17 F1 08 01 A0 47 D7 E9 02 43 C7 E9 14 43 97 F8 5C 00 BA 6D 97 F8 54 10 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 EA B1 00 E0 DA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 48 21 A0 47 20 B1 17 F1 50 00 ?? ?? ?? ?? 9A E7 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 0A B3 00 E0 FA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 9C 6B 20 46 ?? ?? ?? ?? B7 F8 56 10 40 46 00 22 A0 47 3A 28 03 D0 2C 28 01 D0 2F 28 03 D1 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 CA B1 00 E0 BA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 48 21 A0 47 00 28 C9 D1 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 14 B9 00 2A 6F D0 01 E0 00 2A 6C D1 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 04 21 A0 47 40 BB 02 2D 04 D1 33 68 43 F0 02 03 33 60 4E E0 3B 6E CD F8 10 A0 03 96 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 DC 69 20 46 ?? ?? ?? ?? D7 E9 14 23 48 46 17 F1 08 01 A0 47 D7 E9 02 43 97 F8 5C 00 BA 6D C7 E9 14 43 97 F8 54 10 04 2D 34 D1 03 25 32 E0 01 2D 13 D0 03 2D 11 D0 0A F1 0C 03 01 93 1F 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 C5 E7 0A F1 10 03 01 93 0C 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 33 60 DA F8 10 30 5B 1E CA F8 10 30 3C 6D 97 F8 54 10 BA 6D 97 F8 5C 00 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 EA B1 00 E0 DA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 48 21 A0 47 20 B1 17 F1 50 00 ?? ?? ?? ?? C9 E7 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 0A B3 00 E0 FA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 9C 6B 20 46 ?? ?? ?? ?? B7 F8 56 10 40 46 00 22 A0 47 3A 28 03 D0 2C 28 01 D0 2F 28 03 D1 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 CA B1 00 E0 BA B9 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 48 21 A0 47 00 28 C9 D1 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 49 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 48 B9 17 F1 58 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D 97 F8 54 10 3C 6D 0C B9 0A B1 06 E0 2A B1 33 68 7D 6D 43 F0 02 03 33 60 6F E0 19 B9 17 F1 50 00 ?? ?? ?? ?? D8 F8 00 30 1C 69 20 46 ?? ?? ?? ?? B7 F8 56 20 40 46 04 21 A0 47 90 B9 04 2D 06 D0 33 68 43 F0 02 03 33 60 D7 E9 14 45 50 E0 3B 6E 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 DC 69 36 E0 04 2D 17 D1 0A F1 10 03 01 93 0C 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 33 60 DA F8 10 30 5B 1E CA F8 10 30 D8 E7 03 2D 11 D1 0A F1 0C 03 01 93 1F 23 00 93 01 23 17 F1 58 02 17 F1 50 01 48 46 CD F8 08 80 ?? ?? ?? ?? 33 68 03 43 C3 E7 3B 6E 02 93 BB 6D 00 93 FB 6D 01 93 D9 F8 00 30 1C 6A 20 46 03 96 CD F8 10 A0 ?? ?? ?? ?? D7 E9 14 23 17 F1 08 01 48 46 A0 47 D7 E9 02 45 C7 E9 14 45 97 F8 5C 00 BA 6D 97 F8 54 10 41 B9 17 F1 50 00 ?? ?? ?? ?? 97 F8 5C 00 BA 6D D7 E9 14 45 30 B9 17 F1 58 00 ?? ?? ?? ?? BA 6D D7 E9 14 45 0C B9 0A B1 04 E0 1A B1 33 68 43 F0 01 03 33 60 3B 68 C3 E9 00 45 18 46 0F B0 BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1096_1 {
	meta:
		name = "?do_get_monthname@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 64
		refs = "0014 ??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z"
	strings:
		$1 = { 0F B4 2D E9 18 48 0D F1 08 0B C3 68 0C 46 08 A9 06 A8 00 22 ?? ?? ?? ?? 00 28 05 DA 0B 9A 13 68 43 F0 02 03 13 60 02 E0 0C 9B 42 10 1A 61 06 9B 20 46 23 60 07 9B 63 60 BD E8 18 08 5D F8 14 FB }
	condition:
		$1
}

rule file_99_429_1 {
	meta:
		name = "?do_get_monthname@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 64
		refs = "0014 ??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z"
	strings:
		$1 = { 0F B4 2D E9 18 48 0D F1 08 0B C3 68 0C 46 08 A9 06 A8 00 22 ?? ?? ?? ?? 00 28 05 DA 0B 9A 13 68 43 F0 02 03 13 60 02 E0 0C 9B 42 10 1A 61 06 9B 20 46 23 60 07 9B 63 60 BD E8 18 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1097_1 {
	meta:
		name = "?do_get_monthname@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 64
		refs = "0014 ??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z"
	strings:
		$1 = { 0F B4 2D E9 18 48 0D F1 08 0B C3 68 0C 46 08 A9 06 A8 00 22 ?? ?? ?? ?? 00 28 05 DA 0B 9A 13 68 43 F0 02 03 13 60 02 E0 0C 9B 42 10 1A 61 06 9B 20 46 23 60 07 9B 63 60 BD E8 18 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1098_1 {
	meta:
		name = "?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 328
		refs = "0020 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0024 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0034 _guard_check_icall 006e ?_Getint@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0HHAAHABV?$ctype@G@2@@Z 0086 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABAGXZ 00a8 ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 85 B0 6F 46 84 B0 82 46 38 6D 0E 46 6F F0 01 03 39 46 C7 E9 02 33 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D7 F8 58 90 17 F1 48 02 17 F1 40 01 09 F1 08 03 01 93 17 23 00 93 00 23 50 46 CD F8 08 80 ?? ?? ?? ?? 7D 6D 2B 68 03 43 2B 60 29 D1 97 F8 44 30 1B B9 17 F1 40 00 ?? ?? ?? ?? D8 F8 00 30 9C 6B 20 46 ?? ?? ?? ?? B7 F8 46 10 40 46 00 22 A0 47 3A 28 15 D1 17 F1 40 00 ?? ?? ?? ?? 09 F1 04 03 01 93 3B 23 00 93 00 23 17 F1 48 02 17 F1 40 01 50 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 02 E0 2B 68 43 F0 02 03 2B 60 43 BB 97 F8 44 30 1B B9 17 F1 40 00 ?? ?? ?? ?? D8 F8 00 30 9C 6B 20 46 ?? ?? ?? ?? B7 F8 46 10 40 46 00 22 A0 47 3A 28 14 D1 17 F1 40 00 ?? ?? ?? ?? 3B 23 00 93 00 23 17 F1 48 02 17 F1 40 01 50 46 CD F8 08 80 CD F8 04 90 ?? ?? ?? ?? 2B 68 03 43 02 E0 2B 68 43 F0 02 03 2B 60 3B 6C 33 60 7B 6C 73 60 30 46 09 B0 BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1101_1 {
	meta:
		name = "?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 328
		refs = "0020 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0024 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0034 _guard_check_icall 006e ?_Getint@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0HHAAHABV?$ctype@_W@2@@Z 0086 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABA_WXZ 00a8 ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 85 B0 6F 46 84 B0 82 46 38 6D 0E 46 6F F0 01 03 39 46 C7 E9 02 33 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D7 F8 58 90 17 F1 48 02 17 F1 40 01 09 F1 08 03 01 93 17 23 00 93 00 23 50 46 CD F8 08 80 ?? ?? ?? ?? 7D 6D 2B 68 03 43 2B 60 29 D1 97 F8 44 30 1B B9 17 F1 40 00 ?? ?? ?? ?? D8 F8 00 30 9C 6B 20 46 ?? ?? ?? ?? B7 F8 46 10 40 46 00 22 A0 47 3A 28 15 D1 17 F1 40 00 ?? ?? ?? ?? 09 F1 04 03 01 93 3B 23 00 93 00 23 17 F1 48 02 17 F1 40 01 50 46 CD F8 08 80 ?? ?? ?? ?? 2B 68 03 43 02 E0 2B 68 43 F0 02 03 2B 60 43 BB 97 F8 44 30 1B B9 17 F1 40 00 ?? ?? ?? ?? D8 F8 00 30 9C 6B 20 46 ?? ?? ?? ?? B7 F8 46 10 40 46 00 22 A0 47 3A 28 14 D1 17 F1 40 00 ?? ?? ?? ?? 3B 23 00 93 00 23 17 F1 48 02 17 F1 40 01 50 46 CD F8 08 80 CD F8 04 90 ?? ?? ?? ?? 2B 68 03 43 02 E0 2B 68 43 F0 02 03 2B 60 3B 6C 33 60 7B 6C 73 60 30 46 09 B0 BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1104_1 {
	meta:
		name = "?do_get_weekday@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 64
		refs = "0014 ??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z"
	strings:
		$1 = { 0F B4 2D E9 18 48 0D F1 08 0B 83 68 0C 46 08 A9 06 A8 00 22 ?? ?? ?? ?? 00 28 05 DA 0B 9A 13 68 43 F0 02 03 13 60 02 E0 0C 9B 42 10 9A 61 06 9B 20 46 23 60 07 9B 63 60 BD E8 18 08 5D F8 14 FB }
	condition:
		$1
}

rule file_99_433_1 {
	meta:
		name = "?do_get_weekday@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 64
		refs = "0014 ??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z"
	strings:
		$1 = { 0F B4 2D E9 18 48 0D F1 08 0B 83 68 0C 46 08 A9 06 A8 00 22 ?? ?? ?? ?? 00 28 05 DA 0B 9A 13 68 43 F0 02 03 13 60 02 E0 0C 9B 42 10 9A 61 06 9B 20 46 23 60 07 9B 63 60 BD E8 18 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1105_1 {
	meta:
		name = "?do_get_weekday@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 64
		refs = "0014 ??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z"
	strings:
		$1 = { 0F B4 2D E9 18 48 0D F1 08 0B 83 68 0C 46 08 A9 06 A8 00 22 ?? ?? ?? ?? 00 28 05 DA 0B 9A 13 68 43 F0 02 03 13 60 02 E0 0C 9B 42 10 9A 61 06 9B 20 46 23 60 07 9B 63 60 BD E8 18 08 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1106_1 {
	meta:
		name = "?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 172
		refs = "0022 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0026 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0036 _guard_check_icall 0070 ?_Getint@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0HHAAHABV?$ctype@G@2@@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 4B 0D F1 18 0B 86 B0 6F 46 84 B0 80 46 38 6D 0D 46 6F F0 01 03 17 F1 08 01 C7 E9 04 33 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 FE 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 00 23 3B 60 3B 46 01 93 42 F2 0F 73 00 93 00 23 17 F1 48 02 17 F1 40 01 40 46 CD F8 08 90 ?? ?? ?? ?? 7A 6D 13 68 03 43 13 60 10 F0 02 0F 0A D1 3A 68 45 2A B8 BF 64 32 03 DB 64 2A 01 DB A2 F2 6C 72 BB 6D 5A 61 3B 6C 2B 60 7B 6C 6B 60 28 46 0A B0 BD E8 F0 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_99_434_1 {
	meta:
		name = "?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 172
		refs = "0022 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0026 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0036 _guard_check_icall 0070 ?_Getint@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@0HHAAHABV?$ctype@D@2@@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 4B 0D F1 18 0B 86 B0 6F 46 84 B0 80 46 38 6D 0D 46 6F F0 01 03 17 F1 08 01 C7 E9 04 33 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 FE 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 00 23 3B 60 3B 46 01 93 42 F2 0F 73 00 93 00 23 17 F1 48 02 17 F1 40 01 40 46 CD F8 08 90 ?? ?? ?? ?? 7A 6D 13 68 03 43 13 60 10 F0 02 0F 0A D1 3A 68 45 2A B8 BF 64 32 03 DB 64 2A 01 DB A2 F2 6C 72 BB 6D 5A 61 3B 6C 2B 60 7B 6C 6B 60 28 46 0A B0 BD E8 F0 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1109_1 {
	meta:
		name = "?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 172
		refs = "0022 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0026 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0036 _guard_check_icall 0070 ?_Getint@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0HHAAHABV?$ctype@_W@2@@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 4B 0D F1 18 0B 86 B0 6F 46 84 B0 80 46 38 6D 0D 46 6F F0 01 03 17 F1 08 01 C7 E9 04 33 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 FE 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 00 23 3B 60 3B 46 01 93 42 F2 0F 73 00 93 00 23 17 F1 48 02 17 F1 40 01 40 46 CD F8 08 90 ?? ?? ?? ?? 7A 6D 13 68 03 43 13 60 10 F0 02 0F 0A D1 3A 68 45 2A B8 BF 64 32 03 DB 64 2A 01 DB A2 F2 6C 72 BB 6D 5A 61 3B 6C 2B 60 7B 6C 6B 60 28 46 0A B0 BD E8 F0 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1116_1 {
	meta:
		name = "?do_hash@?$collate@G@std@@MBAJPBG0@Z"
		size = 52
		altNames = "?do_hash@?$collate@_W@std@@MBAJPB_W0@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 53 1A 5B 10 08 48 5D 00 4F F0 00 02 07 D0 05 4C 53 5C 52 1C 43 40 03 FB 04 F0 AA 42 F8 D3 BD E8 30 88 FE DE 93 01 00 01 C5 9D 1C 81 }
	condition:
		$1
}

rule file_17_1118_1 {
	meta:
		name = "?do_in@?$codecvt@GDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1AAPBDPAG3AAPAG@Z"
		size = 136
		refs = "003e _Mbrtowc 0058 strlen"
		altNames = "?do_in@?$codecvt@_WDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1AAPBDPA_W3AAPA_W@Z"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 0C 9D 0F 9F 1E 46 2A 60 0D 9A 8A 46 3A 60 2B 68 B3 42 08 BF 00 24 18 BF 01 24 B3 42 2D D0 DD F8 38 80 00 F1 08 09 38 68 40 45 26 D0 29 68 53 46 CD F8 00 90 72 1A ?? ?? ?? ?? 10 F1 02 0F 1B D0 B0 F1 FF 3F 16 D0 30 B9 3B 68 1B 88 3B B9 28 68 ?? ?? ?? ?? 40 1C 10 F1 03 0F 08 BF 00 20 2B 68 00 24 03 44 2B 60 3B 68 9B 1C 3B 60 2B 68 B3 42 D9 D1 02 E0 02 24 00 E0 2E 60 20 46 BD E8 FE 8F }
	condition:
		$1
}

rule file_17_1120_1 {
	meta:
		name = "?do_is@?$ctype@G@std@@MBAPBGPBG0PAF@Z"
		size = 32
		refs = "0018 _Getwctypes"
		altNames = "?do_is@?$ctype@_W@std@@MBAPB_WPB_W0PAF@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 1C 46 15 46 0E 46 00 F1 08 03 22 46 29 46 30 46 ?? ?? ?? ?? BD E8 78 88 }
	condition:
		$1
}

rule file_17_1121_1 {
	meta:
		name = "?do_is@?$ctype@G@std@@MBA_NFG@Z"
		size = 38
		refs = "0010 _Getwctype"
		altNames = "?do_is@?$ctype@_W@std@@MBA_NF_W@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 00 F1 08 01 10 46 ?? ?? ?? ?? 00 EA 04 03 1B B2 0B B1 01 20 00 E0 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1124_1 {
	meta:
		name = "?do_length@?$codecvt@GDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1I@Z"
		size = 108
		refs = "0034 _Mbrtowc 004e strlen"
		altNames = "?do_length@?$codecvt@_WDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1I@Z"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 87 B0 D1 E9 00 41 DD F8 38 80 1E 46 CD E9 04 41 00 24 B8 F1 00 0F 15 46 20 D0 00 F1 08 07 B5 42 1C D0 72 1B 04 AB 29 46 02 A8 00 97 ?? ?? ?? ?? 10 F1 02 0F 12 D0 B0 F1 FF 3F 0F D0 30 B9 BD F8 08 30 3B B9 28 46 ?? ?? ?? ?? 40 1C 10 F1 03 0F 08 BF 00 20 64 1C 05 44 44 45 E0 D3 20 46 07 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_17_1130_1 {
	meta:
		name = "?do_narrow@?$ctype@G@std@@MBAPBGPBG0DPAD@Z"
		size = 98
		refs = "0008 __security_push_cookie 003c _Wcrtomb 005a __security_pop_cookie"
		altNames = "?do_narrow@?$ctype@_W@std@@MBAPB_WPB_W0DPAD@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 84 B0 0D 46 54 1B 61 1C 00 26 95 42 98 BF 4C 08 0E 9F 88 BF 00 24 98 46 81 46 B4 B1 4F F0 00 0A 35 F8 02 1B 09 F1 18 03 6A 46 02 A8 CD E9 00 AA ?? ?? ?? ?? 01 28 18 BF 43 46 01 D1 9D F9 08 30 76 1C A6 42 07 F8 01 3B EA D1 28 46 04 B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_1133_1 {
	meta:
		name = "?do_neg_format@?$_Mpunct@G@std@@MBA?AUpattern@money_base@2@XZ"
		size = 16
		altNames = "?do_neg_format@?$_Mpunct@D@std@@MBA?AUpattern@money_base@2@XZ ?do_neg_format@?$_Mpunct@_W@std@@MBA?AUpattern@money_base@2@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 6A 08 46 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_1135_1 {
	meta:
		name = "?do_negative_sign@?$_Mpunct@G@std@@MBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBG@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 81 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_99_442_1 {
	meta:
		name = "?do_negative_sign@?$_Mpunct@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 81 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1136_1 {
	meta:
		name = "?do_negative_sign@?$_Mpunct@_W@std@@MBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 24
		refs = "000e ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 81 69 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_17_1139_1 {
	meta:
		name = "?do_out@?$codecvt@GDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBG1AAPBGPAD3AAPAD@Z"
		size = 170
		refs = "0008 __security_push_cookie 003e _Wcrtomb 006e memcpy 00a2 __security_pop_cookie"
		altNames = "?do_out@?$codecvt@_WDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PB_W1AAPB_WPAD3AAPAD@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 84 B0 0E 9C 01 90 11 9D 22 60 0F 9A 98 46 0E 46 2A 60 22 68 86 46 42 45 3B D0 10 9F 28 68 B8 42 32 D0 3B 1A 05 2B 23 68 32 46 19 88 0E F1 08 03 09 DB ?? ?? ?? ?? 00 28 22 DB 23 68 9B 1C 23 60 2B 68 03 44 15 E0 D6 E9 00 9A 02 A8 ?? ?? ?? ?? 02 46 00 92 00 2A 13 DB 28 68 3B 1A 93 42 11 DB 02 A9 ?? ?? ?? ?? 23 68 00 9A 9B 1C 23 60 2B 68 13 44 2B 60 23 68 43 45 06 D0 DD F8 04 E0 CD E7 02 20 07 E0 C6 E9 00 9A 23 68 43 45 18 BF 01 20 00 D1 00 20 04 B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_1141_1 {
	meta:
		name = "?do_pos_format@?$_Mpunct@G@std@@MBA?AUpattern@money_base@2@XZ"
		size = 16
		altNames = "?do_pos_format@?$_Mpunct@D@std@@MBA?AUpattern@money_base@2@XZ ?do_pos_format@?$_Mpunct@_W@std@@MBA?AUpattern@money_base@2@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 6A 08 46 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_1145_1 {
	meta:
		name = "?do_put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@GABV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z"
		size = 412
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0036 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0046 _guard_check_icall 00f4 _invalid_parameter_noinfo_noreturn 011a ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBGI@Z 012c ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z 0138 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@ABV01@@Z 0164 ?_Putmfld@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@G1V?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@G@Z 0170 ??3@YAXPAX@Z 018a __security_pop_cookie 0198 ?_Src@?1??do_put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@3@V43@_NAAVios_base@3@GABV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@3@@Z@4QBDB"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 9E B0 6F 46 86 B0 6F F0 01 03 C7 E9 06 33 D7 F8 B4 30 D7 F8 BC 60 89 46 C7 E9 00 13 B8 60 18 46 17 F1 10 01 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 69 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D8 F8 00 20 4C 4C D5 6A 28 46 ?? ?? ?? ?? 40 46 21 46 04 F1 0C 02 17 F1 60 03 A8 47 74 69 00 21 4F F0 00 0A 6C B1 B3 69 08 2B 01 D3 73 68 00 E0 33 1D 1A 88 B7 F8 74 30 9A 42 02 D1 4F F0 01 0A 01 21 0A 46 A1 42 29 D2 D6 F8 14 80 B7 F8 60 E0 17 F1 60 09 42 45 1C D8 B3 69 08 2B 01 D3 73 68 00 E0 33 1D 17 F1 60 00 BE F1 00 0F 08 D0 33 F8 12 50 73 46 AB 42 03 D0 80 1C 03 88 00 2B F9 D1 A0 EB 09 03 5B 10 0A 2B 05 D2 52 1C A2 42 E1 D3 01 E0 ?? ?? ?? ?? D7 F8 00 90 A1 42 01 D9 ?? ?? ?? ?? B3 69 08 2B 01 D3 73 68 00 E0 33 1D 52 1A 03 EB 41 01 17 F1 40 00 ?? ?? ?? ?? 7B 6D 33 B9 B7 F8 60 20 17 F1 40 00 01 21 ?? ?? ?? ?? 17 F1 40 01 17 F1 20 00 ?? ?? ?? ?? B7 F8 60 30 D7 F8 A8 20 04 90 05 93 B7 F8 B8 30 B8 68 49 46 02 93 7B 68 CD F8 0C A0 01 93 97 F8 B0 30 00 93 D7 F8 AC 30 ?? ?? ?? ?? BB 6D 08 2B 02 D3 78 6C ?? ?? ?? ?? 07 23 38 6C BB 65 00 23 7B 65 A7 F8 44 30 ?? ?? ?? ?? 48 46 24 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1153_1 {
	meta:
		name = "?do_put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_WABV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z"
		size = 412
		refs = "000a __security_push_cookie 0032 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0036 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0046 _guard_check_icall 00f4 _invalid_parameter_noinfo_noreturn 011a ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_WI@Z 012c ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z 0138 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@ABV01@@Z 0164 ?_Putmfld@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_W1V?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@3@Z 0170 ??3@YAXPAX@Z 018a __security_pop_cookie 0198 ?_Src@?1??do_put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@3@V43@_NAAVios_base@3@_WABV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@3@@Z@4QBDB"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 9E B0 6F 46 86 B0 6F F0 01 03 C7 E9 06 33 D7 F8 B4 30 D7 F8 BC 60 89 46 C7 E9 00 13 B8 60 18 46 17 F1 10 01 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 69 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D8 F8 00 20 4C 4C D5 6A 28 46 ?? ?? ?? ?? 40 46 21 46 04 F1 0C 02 17 F1 60 03 A8 47 74 69 00 21 4F F0 00 0A 6C B1 B3 69 08 2B 01 D3 73 68 00 E0 33 1D 1A 88 B7 F8 74 30 9A 42 02 D1 4F F0 01 0A 01 21 0A 46 A1 42 29 D2 D6 F8 14 80 B7 F8 60 E0 17 F1 60 09 42 45 1C D8 B3 69 08 2B 01 D3 73 68 00 E0 33 1D 17 F1 60 00 BE F1 00 0F 08 D0 33 F8 12 50 73 46 AB 42 03 D0 80 1C 03 88 00 2B F9 D1 A0 EB 09 03 5B 10 0A 2B 05 D2 52 1C A2 42 E1 D3 01 E0 ?? ?? ?? ?? D7 F8 00 90 A1 42 01 D9 ?? ?? ?? ?? B3 69 08 2B 01 D3 73 68 00 E0 33 1D 52 1A 03 EB 41 01 17 F1 40 00 ?? ?? ?? ?? 7B 6D 33 B9 B7 F8 60 20 17 F1 40 00 01 21 ?? ?? ?? ?? 17 F1 40 01 17 F1 20 00 ?? ?? ?? ?? B7 F8 60 30 D7 F8 A8 20 04 90 05 93 B7 F8 B8 30 B8 68 49 46 02 93 7B 68 CD F8 0C A0 01 93 97 F8 B0 30 00 93 D7 F8 AC 30 ?? ?? ?? ?? BB 6D 08 2B 02 D3 78 6C ?? ?? ?? ?? 07 23 38 6C BB 65 00 23 7B 65 A7 F8 44 30 ?? ?? ?? ?? 48 46 24 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1149_1 {
	meta:
		name = "?do_put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@GO@Z"
		size = 424
		refs = "000a __security_push_cookie 0084 sprintf_s 00a2 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 00a6 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 00b8 _guard_check_icall 00f0 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@IG@Z 012c ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z 0138 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@ABV01@@Z 0160 ?_Putmfld@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@G1V?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@G@Z 016c ??3@YAXPAX@Z 0186 __security_pop_cookie 0194 ??_C@_05NNKBBLJI@?$CF?40Lf?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A4 B0 6F 46 86 B0 D7 F8 CC 40 0E 46 00 21 B5 EE C0 0B 6F F0 01 03 C7 E9 08 33 F1 EE 10 FA C7 E9 03 40 52 EC 10 3B 79 60 05 D2 01 23 B1 EE 40 0B 7B 60 52 EC 10 3B 9F ED 56 1B 4F F0 00 08 B4 EE C0 1B F1 EE 10 FA 10 D8 9F ED 50 2B 41 F2 88 31 88 45 0A D2 80 EE 02 0B 08 F1 0A 08 52 EC 10 3B B4 EE C0 1B F1 EE 10 FA F2 D9 01 92 46 4A 17 F1 68 00 28 21 00 93 ?? ?? ?? ?? 82 46 00 28 06 DA D7 F8 C0 30 33 60 D7 F8 C4 30 73 60 72 E0 17 F1 18 01 20 46 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 38 60 FD 69 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D9 F8 00 30 1C 6B 20 46 ?? ?? ?? ?? 48 46 30 21 A0 47 B8 60 17 F1 48 00 00 22 51 46 ?? ?? ?? ?? 3B 6E 08 2B 02 D3 D7 F8 4C 90 01 E0 17 F1 4C 09 3B 68 17 F1 68 05 1A 68 D4 6A 20 46 ?? ?? ?? ?? 38 68 17 F1 68 01 0A EB 05 02 4B 46 A0 47 BC 68 17 F1 48 00 41 46 22 46 ?? ?? ?? ?? 17 F1 48 01 17 F1 28 00 ?? ?? ?? ?? 7B 68 D7 F8 C0 20 04 90 03 93 B7 F8 D0 30 38 69 31 46 02 93 FB 68 05 94 01 93 97 F8 C8 30 00 93 D7 F8 C4 30 ?? ?? ?? ?? 3B 6E 08 2B 02 D3 F8 6C ?? ?? ?? ?? 07 23 B8 6C 3B 66 00 23 FB 65 A7 F8 4C 30 ?? ?? ?? ?? 30 46 2A B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? 00 00 00 20 5F A0 02 42 82 4D C7 72 61 42 33 47 }
	condition:
		$1
}

rule file_17_1157_1 {
	meta:
		name = "?do_put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_WO@Z"
		size = 424
		refs = "000a __security_push_cookie 0084 sprintf_s 00a2 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 00a6 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 00b8 _guard_check_icall 00f0 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@I_W@Z 012c ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z 0138 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@ABV01@@Z 0160 ?_Putmfld@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_W1V?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@3@Z 016c ??3@YAXPAX@Z 0186 __security_pop_cookie 0194 ??_C@_05NNKBBLJI@?$CF?40Lf?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A4 B0 6F 46 86 B0 D7 F8 CC 40 0E 46 00 21 B5 EE C0 0B 6F F0 01 03 C7 E9 08 33 F1 EE 10 FA C7 E9 03 40 52 EC 10 3B 79 60 05 D2 01 23 B1 EE 40 0B 7B 60 52 EC 10 3B 9F ED 56 1B 4F F0 00 08 B4 EE C0 1B F1 EE 10 FA 10 D8 9F ED 50 2B 41 F2 88 31 88 45 0A D2 80 EE 02 0B 08 F1 0A 08 52 EC 10 3B B4 EE C0 1B F1 EE 10 FA F2 D9 01 92 46 4A 17 F1 68 00 28 21 00 93 ?? ?? ?? ?? 82 46 00 28 06 DA D7 F8 C0 30 33 60 D7 F8 C4 30 73 60 72 E0 17 F1 18 01 20 46 ?? ?? ?? ?? ?? ?? ?? ?? 81 46 38 60 FD 69 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 D9 F8 00 30 1C 6B 20 46 ?? ?? ?? ?? 48 46 30 21 A0 47 B8 60 17 F1 48 00 00 22 51 46 ?? ?? ?? ?? 3B 6E 08 2B 02 D3 D7 F8 4C 90 01 E0 17 F1 4C 09 3B 68 17 F1 68 05 1A 68 D4 6A 20 46 ?? ?? ?? ?? 38 68 17 F1 68 01 0A EB 05 02 4B 46 A0 47 BC 68 17 F1 48 00 41 46 22 46 ?? ?? ?? ?? 17 F1 48 01 17 F1 28 00 ?? ?? ?? ?? 7B 68 D7 F8 C0 20 04 90 03 93 B7 F8 D0 30 38 69 31 46 02 93 FB 68 05 94 01 93 97 F8 C8 30 00 93 D7 F8 C4 30 ?? ?? ?? ?? 3B 6E 08 2B 02 D3 F8 6C ?? ?? ?? ?? 07 23 B8 6C 3B 66 00 23 FB 65 A7 F8 4C 30 ?? ?? ?? ?? 30 46 2A B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? 00 00 00 20 5F A0 02 42 82 4D C7 72 61 42 33 47 }
	condition:
		$1
}

rule file_17_1161_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GJ@Z"
		size = 92
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z 0028 sprintf_s 0042 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 004a __security_pop_cookie 0058 ??_C@_02EAOCLKAK@ld?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 11 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 40 21 ?? ?? ?? ?? 06 AB 02 93 BD F8 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1162_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GK@Z"
		size = 92
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z 0028 sprintf_s 0042 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 004a __security_pop_cookie 0058 ??_C@_02BDDLJJBK@lu?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 11 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 40 21 ?? ?? ?? ?? 06 AB 02 93 BD F8 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1177_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WJ@Z"
		size = 92
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z 0028 sprintf_s 0042 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 004a __security_pop_cookie 0058 ??_C@_02EAOCLKAK@ld?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 11 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 40 21 ?? ?? ?? ?? 06 AB 02 93 BD F8 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1178_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WK@Z"
		size = 92
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z 0028 sprintf_s 0042 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 004a __security_pop_cookie 0058 ??_C@_02BDDLJJBK@lu?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 11 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 40 21 ?? ?? ?? ?? 06 AB 02 93 BD F8 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1163_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GN@Z"
		size = 388
		refs = "000e __security_push_cookie 0038 ??2@YAPAXI@Z 003e _invalid_parameter_noinfo_noreturn 00a2 frexp 00ee ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 00fc ?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADDH@Z 011c sprintf_s 0142 ?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z 014e ??3@YAXPAX@Z 0168 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B ?? ?? ?? ?? 8E B0 6F 46 84 B0 BD 6F 6F F0 01 03 C7 E9 02 33 B0 EE 40 8B 0E 46 80 46 5A EC 10 9B 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 0F 20 1A 60 00 23 00 21 3B 75 C7 E9 09 10 D5 E9 05 34 EA 69 03 F4 40 53 B3 F5 00 5F 08 BF 01 23 18 BF 00 23 00 2A 04 DC 00 DB 14 B9 0B B9 06 24 00 22 7A 60 22 46 FB B1 9F ED 3C 0B B0 EE C8 1B B4 EE C1 0B F1 EE 10 FA 16 D2 38 46 B0 EE 48 0B ?? ?? ?? ?? 3A 68 82 EA E2 73 A3 EB E2 72 47 F2 97 53 02 FB 03 F1 2F 4B 81 FB 03 32 53 13 03 EB D3 73 D7 E9 09 10 1A 19 02 F1 32 03 8B 42 09 D8 10 28 01 D3 7A 69 01 E0 17 F1 14 02 00 21 7B 62 D1 54 05 E0 59 1A 17 F1 10 00 00 22 ?? ?? ?? ?? 6B 69 17 F1 30 01 00 22 40 46 ?? ?? ?? ?? BB 6A 02 46 10 2B 01 D3 78 69 01 E0 17 F1 14 00 79 6A 23 46 CD F8 00 90 CD F8 04 A0 ?? ?? ?? ?? BB 6A 10 2B 01 D3 7B 69 01 E0 17 F1 14 03 02 93 B7 F8 7C 30 3A 6F 03 90 01 93 7B 6F 31 46 40 46 00 95 ?? ?? ?? ?? BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 30 46 BD 46 0E B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 0F 5D F8 14 FB 89 B5 F8 14 00 00 00 20 5F A0 02 42 }
	condition:
		$1
}

rule file_17_1179_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WN@Z"
		size = 388
		refs = "000e __security_push_cookie 0038 ??2@YAPAXI@Z 003e _invalid_parameter_noinfo_noreturn 00a2 frexp 00ee ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 00fc ?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADDH@Z 011c sprintf_s 0142 ?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z 014e ??3@YAXPAX@Z 0168 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B ?? ?? ?? ?? 8E B0 6F 46 84 B0 BD 6F 6F F0 01 03 C7 E9 02 33 B0 EE 40 8B 0E 46 80 46 5A EC 10 9B 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 0F 20 1A 60 00 23 00 21 3B 75 C7 E9 09 10 D5 E9 05 34 EA 69 03 F4 40 53 B3 F5 00 5F 08 BF 01 23 18 BF 00 23 00 2A 04 DC 00 DB 14 B9 0B B9 06 24 00 22 7A 60 22 46 FB B1 9F ED 3C 0B B0 EE C8 1B B4 EE C1 0B F1 EE 10 FA 16 D2 38 46 B0 EE 48 0B ?? ?? ?? ?? 3A 68 82 EA E2 73 A3 EB E2 72 47 F2 97 53 02 FB 03 F1 2F 4B 81 FB 03 32 53 13 03 EB D3 73 D7 E9 09 10 1A 19 02 F1 32 03 8B 42 09 D8 10 28 01 D3 7A 69 01 E0 17 F1 14 02 00 21 7B 62 D1 54 05 E0 59 1A 17 F1 10 00 00 22 ?? ?? ?? ?? 6B 69 17 F1 30 01 00 22 40 46 ?? ?? ?? ?? BB 6A 02 46 10 2B 01 D3 78 69 01 E0 17 F1 14 00 79 6A 23 46 CD F8 00 90 CD F8 04 A0 ?? ?? ?? ?? BB 6A 10 2B 01 D3 7B 69 01 E0 17 F1 14 03 02 93 B7 F8 7C 30 3A 6F 03 90 01 93 7B 6F 31 46 40 46 00 95 ?? ?? ?? ?? BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 30 46 BD 46 0E B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 0F 5D F8 14 FB 89 B5 F8 14 00 00 00 20 5F A0 02 42 }
	condition:
		$1
}

rule file_17_1166_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GO@Z"
		size = 388
		refs = "000e __security_push_cookie 0038 ??2@YAPAXI@Z 003e _invalid_parameter_noinfo_noreturn 00a2 frexp 00ee ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 00fc ?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADDH@Z 011c sprintf_s 0142 ?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z 014e ??3@YAXPAX@Z 0168 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B ?? ?? ?? ?? 8E B0 6F 46 84 B0 BD 6F 6F F0 01 03 C7 E9 02 33 B0 EE 40 8B 0E 46 80 46 5A EC 10 9B 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 0F 20 1A 60 00 23 00 21 3B 75 C7 E9 09 10 D5 E9 05 34 EA 69 03 F4 40 53 B3 F5 00 5F 08 BF 01 23 18 BF 00 23 00 2A 04 DC 00 DB 14 B9 0B B9 06 24 00 22 7A 60 22 46 FB B1 9F ED 3C 0B B0 EE C8 1B B4 EE C1 0B F1 EE 10 FA 16 D2 38 46 B0 EE 48 0B ?? ?? ?? ?? 3A 68 82 EA E2 73 A3 EB E2 72 47 F2 97 53 02 FB 03 F1 2F 4B 81 FB 03 32 53 13 03 EB D3 73 D7 E9 09 10 1A 19 02 F1 32 03 8B 42 09 D8 10 28 01 D3 7A 69 01 E0 17 F1 14 02 00 21 7B 62 D1 54 05 E0 59 1A 17 F1 10 00 00 22 ?? ?? ?? ?? 6B 69 17 F1 30 01 4C 22 40 46 ?? ?? ?? ?? BB 6A 02 46 10 2B 01 D3 78 69 01 E0 17 F1 14 00 79 6A 23 46 CD F8 00 90 CD F8 04 A0 ?? ?? ?? ?? BB 6A 10 2B 01 D3 7B 69 01 E0 17 F1 14 03 02 93 B7 F8 7C 30 3A 6F 03 90 01 93 7B 6F 31 46 40 46 00 95 ?? ?? ?? ?? BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 30 46 BD 46 0E B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 0F 5D F8 14 FB 89 B5 F8 14 00 00 00 20 5F A0 02 42 }
	condition:
		$1
}

rule file_17_1182_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WO@Z"
		size = 388
		refs = "000e __security_push_cookie 0038 ??2@YAPAXI@Z 003e _invalid_parameter_noinfo_noreturn 00a2 frexp 00ee ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 00fc ?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADDH@Z 011c sprintf_s 0142 ?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z 014e ??3@YAXPAX@Z 0168 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B ?? ?? ?? ?? 8E B0 6F 46 84 B0 BD 6F 6F F0 01 03 C7 E9 02 33 B0 EE 40 8B 0E 46 80 46 5A EC 10 9B 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 0F 20 1A 60 00 23 00 21 3B 75 C7 E9 09 10 D5 E9 05 34 EA 69 03 F4 40 53 B3 F5 00 5F 08 BF 01 23 18 BF 00 23 00 2A 04 DC 00 DB 14 B9 0B B9 06 24 00 22 7A 60 22 46 FB B1 9F ED 3C 0B B0 EE C8 1B B4 EE C1 0B F1 EE 10 FA 16 D2 38 46 B0 EE 48 0B ?? ?? ?? ?? 3A 68 82 EA E2 73 A3 EB E2 72 47 F2 97 53 02 FB 03 F1 2F 4B 81 FB 03 32 53 13 03 EB D3 73 D7 E9 09 10 1A 19 02 F1 32 03 8B 42 09 D8 10 28 01 D3 7A 69 01 E0 17 F1 14 02 00 21 7B 62 D1 54 05 E0 59 1A 17 F1 10 00 00 22 ?? ?? ?? ?? 6B 69 17 F1 30 01 4C 22 40 46 ?? ?? ?? ?? BB 6A 02 46 10 2B 01 D3 78 69 01 E0 17 F1 14 00 79 6A 23 46 CD F8 00 90 CD F8 04 A0 ?? ?? ?? ?? BB 6A 10 2B 01 D3 7B 69 01 E0 17 F1 14 03 02 93 B7 F8 7C 30 3A 6F 03 90 01 93 7B 6F 31 46 40 46 00 95 ?? ?? ?? ?? BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 30 46 BD 46 0E B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 0F 5D F8 14 FB 89 B5 F8 14 00 00 00 20 5F A0 02 42 }
	condition:
		$1
}

rule file_17_1169_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBX@Z"
		size = 80
		refs = "000a __security_push_cookie 001e sprintf_s 0038 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0040 __security_pop_cookie 004c ??_C@_02BBAHNLBA@?$CFp?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 94 B0 20 9B 0E 4A 1E 9C 0E 46 05 46 04 A8 40 21 ?? ?? ?? ?? 04 AB 02 93 BD F8 7C 30 1C 9A 03 90 01 93 1D 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 14 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1185_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBX@Z"
		size = 80
		refs = "000a __security_push_cookie 001e sprintf_s 0038 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0040 __security_pop_cookie 004c ??_C@_02BBAHNLBA@?$CFp?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 94 B0 20 9B 0E 4A 1E 9C 0E 46 05 46 04 A8 40 21 ?? ?? ?? ?? 04 AB 02 93 BD F8 7C 30 1C 9A 03 90 01 93 1D 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 14 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1170_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@G_J@Z"
		size = 96
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z 002e sprintf_s 0048 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0050 __security_pop_cookie 005c ??_C@_02HIKPPMOK@Ld?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 12 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 00 93 23 9B 40 21 01 93 ?? ?? ?? ?? 06 AB 02 93 BD F8 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1171_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@G_K@Z"
		size = 96
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z 002e sprintf_s 0048 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0050 __security_pop_cookie 005c ??_C@_02CLHGNPPK@Lu?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 12 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 00 93 23 9B 40 21 01 93 ?? ?? ?? ?? 06 AB 02 93 BD F8 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1186_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_W_J@Z"
		size = 96
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z 002e sprintf_s 0048 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0050 __security_pop_cookie 005c ??_C@_02HIKPPMOK@Ld?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 12 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 00 93 23 9B 40 21 01 93 ?? ?? ?? ?? 06 AB 02 93 BD F8 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1187_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_W_K@Z"
		size = 96
		refs = "000a __security_push_cookie 001c ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z 002e sprintf_s 0048 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0050 __security_pop_cookie 005c ??_C@_02CLHGNPPK@Lu?$AA@"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 96 B0 20 9C 12 4A 0E 46 63 69 04 A9 05 46 ?? ?? ?? ?? 22 9B 02 46 06 A8 00 93 23 9B 40 21 01 93 ?? ?? ?? ?? 06 AB 02 93 BD F8 84 30 1E 9A 03 90 01 93 1F 9B 31 46 28 46 00 94 ?? ?? ?? ?? 30 46 16 B0 ?? ?? ?? ?? BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1172_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@G_N@Z"
		size = 458
		refs = "000a __security_push_cookie 004c _guard_check_icall 0060 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0064 ??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 009a ??2@YAPAXI@Z 00a0 _invalid_parameter_noinfo_noreturn 00cc ?truename@?$numpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 00d6 ?falsename@?$numpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ 00e0 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@$$QAV12@@Z 00ec ??3@YAXPAX@Z 0138 ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z 01be __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 94 B0 6F 46 84 B0 D7 F8 88 90 1D 46 6F F0 01 03 C7 E9 20 25 C7 E9 02 33 0E 46 D9 F8 14 10 90 46 82 46 11 F4 80 4F 12 D1 97 F8 90 10 CD F8 00 90 02 91 B7 F8 8C 10 01 91 01 68 4C 6A 20 46 ?? ?? ?? ?? 50 46 31 46 42 46 2B 46 A0 47 AE E0 39 46 48 46 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 1A 60 07 23 BB 62 00 23 7B 62 BB 82 97 F8 90 30 40 46 23 B1 17 F1 30 01 ?? ?? ?? ?? 03 E0 17 F1 30 01 ?? ?? ?? ?? 01 46 17 F1 10 00 ?? ?? ?? ?? BB 6C 08 2B 02 D3 78 6B ?? ?? ?? ?? 07 23 38 6B BB 64 00 23 7B 64 BB 86 ?? ?? ?? ?? D9 E9 08 23 7D 6A 00 2B 05 DB 00 DC 1A B1 AA 42 88 BF 54 1B 00 D8 00 24 D9 F8 14 30 D7 F8 84 20 03 F4 E0 73 40 2B D7 F8 80 30 0F D0 C7 E9 00 32 4C B1 B7 F8 8C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 7D 6A D7 E9 00 32 C7 E9 20 32 00 24 B9 6A 78 69 08 29 28 BF 80 46 01 D2 17 F1 14 08 C7 E9 00 32 55 B1 38 F8 02 1B 38 46 ?? ?? ?? ?? 6D 1E F8 D1 B9 6A 78 69 D7 E9 00 32 00 25 C9 E9 08 55 C7 E9 20 32 C7 E9 00 32 54 B1 B7 F8 8C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 B9 6A 78 69 D7 E9 00 32 C6 E9 00 32 08 29 01 D3 ?? ?? ?? ?? 07 23 38 69 BB 62 00 23 7B 62 BB 82 ?? ?? ?? ?? 30 46 18 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1188_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_W_N@Z"
		size = 458
		refs = "000a __security_push_cookie 004c _guard_check_icall 0060 ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0064 ??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 009a ??2@YAPAXI@Z 00a0 _invalid_parameter_noinfo_noreturn 00cc ?truename@?$numpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 00d6 ?falsename@?$numpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ 00e0 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@$$QAV12@@Z 00ec ??3@YAXPAX@Z 0138 ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z 01be __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 94 B0 6F 46 84 B0 D7 F8 88 90 1D 46 6F F0 01 03 C7 E9 20 25 C7 E9 02 33 0E 46 D9 F8 14 10 90 46 82 46 11 F4 80 4F 12 D1 97 F8 90 10 CD F8 00 90 02 91 B7 F8 8C 10 01 91 01 68 4C 6A 20 46 ?? ?? ?? ?? 50 46 31 46 42 46 2B 46 A0 47 AE E0 39 46 48 46 ?? ?? ?? ?? ?? ?? ?? ?? 80 46 7D 68 85 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 05 46 3D B1 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 01 21 A0 47 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 1A 60 07 23 BB 62 00 23 7B 62 BB 82 97 F8 90 30 40 46 23 B1 17 F1 30 01 ?? ?? ?? ?? 03 E0 17 F1 30 01 ?? ?? ?? ?? 01 46 17 F1 10 00 ?? ?? ?? ?? BB 6C 08 2B 02 D3 78 6B ?? ?? ?? ?? 07 23 38 6B BB 64 00 23 7B 64 BB 86 ?? ?? ?? ?? D9 E9 08 23 7D 6A 00 2B 05 DB 00 DC 1A B1 AA 42 88 BF 54 1B 00 D8 00 24 D9 F8 14 30 D7 F8 84 20 03 F4 E0 73 40 2B D7 F8 80 30 0F D0 C7 E9 00 32 4C B1 B7 F8 8C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 7D 6A D7 E9 00 32 C7 E9 20 32 00 24 B9 6A 78 69 08 29 28 BF 80 46 01 D2 17 F1 14 08 C7 E9 00 32 55 B1 38 F8 02 1B 38 46 ?? ?? ?? ?? 6D 1E F8 D1 B9 6A 78 69 D7 E9 00 32 00 25 C9 E9 08 55 C7 E9 20 32 C7 E9 00 32 54 B1 B7 F8 8C 10 38 46 ?? ?? ?? ?? 64 1E F8 D1 B9 6A 78 69 D7 E9 00 32 C6 E9 00 32 08 29 01 D3 ?? ?? ?? ?? 07 23 38 69 BB 62 00 23 7B 62 BB 82 ?? ?? ?? ?? 30 46 18 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1193_1 {
	meta:
		name = "?do_put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBUtm@@DD@Z"
		size = 392
		refs = "000a __security_push_cookie 0040 ??2@YAPAXI@Z 0046 _invalid_parameter_noinfo_noreturn 00b2 _Wcsftime 00c4 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z 00d4 ?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0136 ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@G@Z 0150 ??3@YAXPAX@Z 0176 __security_pop_cookie 0184 ??_C@_19OKANBMPJ@?$AA?$CB?$AA?$CF?$AAx?$AA?$AA?$AA?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 92 B0 6F 46 82 B0 6F F0 01 03 C7 E9 04 33 59 4C 17 F1 38 05 D7 F8 88 A0 94 E8 0C 00 85 E8 0C 00 88 46 81 46 23 89 2B 81 00 23 08 20 BB 61 C7 E9 0B 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 B8 61 C0 E9 00 32 BB 69 17 F1 18 02 1A 60 07 23 3B 63 00 23 FB 62 BB 83 97 F9 90 30 1B B9 97 F9 8C 30 BB 87 03 E0 BB 87 97 F9 8C 30 FB 87 10 25 10 21 1D E0 1B 68 00 2B 71 D0 1A 68 00 2A 6E D0 93 69 08 2B 01 D3 51 68 00 E0 11 1D 81 42 64 D8 53 69 01 EB 43 03 98 42 5F D2 53 46 17 F1 38 02 31 46 00 94 ?? ?? ?? ?? 04 46 9C B9 6D 00 29 46 00 22 17 F1 18 00 ?? ?? ?? ?? D9 F8 08 40 FE 6A 39 46 17 F1 18 00 ?? ?? ?? ?? 03 46 98 68 00 28 D0 D1 46 E0 F9 6A 8C 42 01 D9 ?? ?? ?? ?? 3A 6B F8 69 08 2A 28 BF 03 46 01 D2 17 F1 1C 03 03 EB 44 04 01 29 01 D2 ?? ?? ?? ?? 08 2A 28 BF 03 46 01 D2 17 F1 1C 03 9E 1C A3 1B 5B 1C D7 E9 1E 1E 00 25 A6 42 98 BF 5C 08 88 BF 00 24 C7 E9 00 1E 5C B1 36 F8 02 1B 38 46 ?? ?? ?? ?? 6D 1C A5 42 F7 D1 3A 6B F8 69 D7 E9 00 1E C8 E9 00 1E 08 2A 01 D3 ?? ?? ?? ?? 07 23 B8 69 3B 63 00 23 FB 62 BB 83 ?? ?? ?? ?? 40 46 05 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 14 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1196_1 {
	meta:
		name = "?do_put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBUtm@@DD@Z"
		size = 392
		refs = "000a __security_push_cookie 0040 ??2@YAPAXI@Z 0046 _invalid_parameter_noinfo_noreturn 00b2 _Wcsftime 00c4 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z 00d4 ?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0136 ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@_W@Z 0150 ??3@YAXPAX@Z 0176 __security_pop_cookie 0184 ??_C@_19OKANBMPJ@?$AA?$CB?$AA?$CF?$AAx?$AA?$AA?$AA?$AA@"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 92 B0 6F 46 82 B0 6F F0 01 03 C7 E9 04 33 59 4C 17 F1 38 05 D7 F8 88 A0 94 E8 0C 00 85 E8 0C 00 88 46 81 46 23 89 2B 81 00 23 08 20 BB 61 C7 E9 0B 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 B8 61 C0 E9 00 32 BB 69 17 F1 18 02 1A 60 07 23 3B 63 00 23 FB 62 BB 83 97 F9 90 30 1B B9 97 F9 8C 30 BB 87 03 E0 BB 87 97 F9 8C 30 FB 87 10 25 10 21 1D E0 1B 68 00 2B 71 D0 1A 68 00 2A 6E D0 93 69 08 2B 01 D3 51 68 00 E0 11 1D 81 42 64 D8 53 69 01 EB 43 03 98 42 5F D2 53 46 17 F1 38 02 31 46 00 94 ?? ?? ?? ?? 04 46 9C B9 6D 00 29 46 00 22 17 F1 18 00 ?? ?? ?? ?? D9 F8 08 40 FE 6A 39 46 17 F1 18 00 ?? ?? ?? ?? 03 46 98 68 00 28 D0 D1 46 E0 F9 6A 8C 42 01 D9 ?? ?? ?? ?? 3A 6B F8 69 08 2A 28 BF 03 46 01 D2 17 F1 1C 03 03 EB 44 04 01 29 01 D2 ?? ?? ?? ?? 08 2A 28 BF 03 46 01 D2 17 F1 1C 03 9E 1C A3 1B 5B 1C D7 E9 1E 1E 00 25 A6 42 98 BF 5C 08 88 BF 00 24 C7 E9 00 1E 5C B1 36 F8 02 1B 38 46 ?? ?? ?? ?? 6D 1C A5 42 F7 D1 3A 6B F8 69 D7 E9 00 1E C8 E9 00 1E 08 2A 01 D3 ?? ?? ?? ?? 07 23 B8 69 3B 63 00 23 FB 62 BB 83 ?? ?? ?? ?? 40 46 05 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 14 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1199_1 {
	meta:
		name = "?do_scan_is@?$ctype@G@std@@MBAPBGFPBG0@Z"
		size = 54
		refs = "001c _guard_check_icall"
		altNames = "?do_scan_is@?$ctype@_W@std@@MBAPB_WFPB_W0@Z"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 1F 46 16 46 89 46 80 46 0C E0 D8 F8 00 40 35 88 24 69 20 46 ?? ?? ?? ?? 40 46 49 46 2A 46 A0 47 10 B9 B6 1C BE 42 F0 D1 30 46 BD E8 F0 8B }
	condition:
		$1
}

rule file_17_1201_1 {
	meta:
		name = "?do_scan_not@?$ctype@G@std@@MBAPBGFPBG0@Z"
		size = 54
		refs = "001c _guard_check_icall"
		altNames = "?do_scan_not@?$ctype@_W@std@@MBAPB_WFPB_W0@Z"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 1F 46 16 46 89 46 80 46 0C E0 D8 F8 00 40 35 88 24 69 20 46 ?? ?? ?? ?? 40 46 49 46 2A 46 A0 47 10 B1 B6 1C BE 42 F0 D1 30 46 BD E8 F0 8B }
	condition:
		$1
}

rule file_17_1207_1 {
	meta:
		name = "?do_tolower@?$ctype@G@std@@MBAGG@Z"
		size = 22
		refs = "0012 _Towlower"
		altNames = "?do_tolower@?$ctype@_W@std@@MBA_W_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 46 00 F1 08 01 18 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1211_1 {
	meta:
		name = "?do_toupper@?$ctype@G@std@@MBAGG@Z"
		size = 22
		refs = "0012 _Towupper"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 46 00 F1 08 01 18 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_291_2 {
	meta:
		name = "?do_toupper@?$ctype@_W@std@@MBA_W_W@Z"
		size = 22
		refs = "0012 _Towupper"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 46 00 F1 08 01 18 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1208_1 {
	meta:
		name = "?do_tolower@?$ctype@G@std@@MBAPBGPAGPBG@Z"
		size = 56
		refs = "0024 _Towlower"
		altNames = "?do_tolower@?$ctype@_W@std@@MBAPB_WPA_WPB_W@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0D 46 53 1B 5B 1C 00 26 95 42 98 BF 5C 08 88 BF 00 24 07 46 4C B1 28 88 07 F1 08 01 ?? ?? ?? ?? 76 1C A6 42 25 F8 02 0B F5 D1 28 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_17_1212_1 {
	meta:
		name = "?do_toupper@?$ctype@G@std@@MBAPBGPAGPBG@Z"
		size = 56
		refs = "0024 _Towupper"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0D 46 53 1B 5B 1C 00 26 95 42 98 BF 5C 08 88 BF 00 24 07 46 4C B1 28 88 07 F1 08 01 ?? ?? ?? ?? 76 1C A6 42 25 F8 02 0B F5 D1 28 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_102_290_2 {
	meta:
		name = "?do_toupper@?$ctype@_W@std@@MBAPB_WPA_WPB_W@Z"
		size = 56
		refs = "0024 _Towupper"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0D 46 53 1B 5B 1C 00 26 95 42 98 BF 5C 08 88 BF 00 24 07 46 4C B1 28 88 07 F1 08 01 ?? ?? ?? ?? 76 1C A6 42 25 F8 02 0B F5 D1 28 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_17_1215_1 {
	meta:
		name = "?do_transform@?$collate@G@std@@MBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z"
		size = 414
		refs = "002a ??2@YAPAXI@Z 0030 _invalid_parameter_noinfo_noreturn 007e ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z 0088 ?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 0118 memcpy 0124 memset 012e _errno 0142 _invalid_parameter_noinfo"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 8B B0 6F 46 1D 46 0C 46 6F F0 01 03 7C 65 C7 E9 02 33 92 46 00 26 3E 60 08 20 26 60 C4 E9 05 66 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 C4 E9 05 63 A6 80 01 23 3B 60 A5 EB 0A 03 5D 10 2A 46 00 F0 8A 80 4F EA 45 09 63 69 9A 42 09 D8 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 62 61 23 F8 12 60 04 E0 D1 1A 00 22 20 46 ?? ?? ?? ?? 17 F1 10 01 20 46 ?? ?? ?? ?? 86 68 00 2E 6A D0 03 68 00 2B 65 D0 1A 68 00 2A 62 D0 93 69 08 2B 01 D3 51 68 00 E0 11 1D B1 42 58 D8 53 69 01 EB 43 03 9E 42 53 D2 D4 F8 14 80 17 F1 20 01 20 46 ?? ?? ?? ?? D0 F8 08 E0 BE F1 00 0F 45 D0 03 68 00 2B 40 D0 1A 68 F2 B3 93 69 08 2B 01 D3 51 68 00 E0 11 1D 71 45 34 D8 53 69 01 EB 43 03 9E 45 2F D2 CE EB 48 03 33 44 5B 10 9D 42 22 D8 5E 00 B9 F1 00 0F 1E D0 BA F1 00 0F 07 D0 4E 45 05 D3 4A 46 51 46 70 46 ?? ?? ?? ?? 13 E0 32 46 00 21 70 46 ?? ?? ?? ?? BA F1 00 0F 03 D1 ?? ?? ?? ?? 16 23 04 E0 4E 45 05 D2 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 63 69 2A 46 9D 42 0E D9 6D B1 00 26 84 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 26 63 69 9D 42 09 D8 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 65 61 23 F8 15 60 04 E0 E9 1A 00 22 20 46 ?? ?? ?? ?? 20 46 0B B0 BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1217_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@G@std@@MBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z$0"
		size = 30
		refs = "0018 ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 07 80 3B 68 23 F0 01 03 3B 60 78 6D ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_99_464_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@D@std@@MBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z$0"
		size = 30
		refs = "0018 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 07 80 3B 68 23 F0 01 03 3B 60 78 6D ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_1220_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@_W@std@@MBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z$0"
		size = 30
		refs = "0018 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 07 80 3B 68 23 F0 01 03 3B 60 78 6D ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_17_1218_1 {
	meta:
		name = "?do_transform@?$collate@_W@std@@MBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z"
		size = 348
		refs = "0036 ??2@YAPAXI@Z 003c _invalid_parameter_noinfo_noreturn 0088 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z 0092 ?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0102 _Wcsxfrm"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 8B B0 6F 46 82 B0 9A 46 0C 46 6F F0 01 03 16 46 7C 65 C7 E9 02 33 7E 60 05 46 4F F0 00 08 C7 F8 00 80 08 20 C1 F8 00 80 C1 E9 05 88 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 20 60 C0 E9 00 32 23 68 1C 60 07 23 C4 E9 05 83 A4 F8 04 80 01 23 3B 60 AA EB 06 03 58 10 63 D0 05 F1 08 09 63 69 98 42 09 D8 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 60 61 23 F8 10 80 04 E0 C1 1A 00 22 20 46 ?? ?? ?? ?? 17 F1 10 01 20 46 ?? ?? ?? ?? 86 68 00 2E 45 D0 03 68 00 2B 40 D0 1A 68 F2 B3 93 69 08 2B 01 D3 51 68 00 E0 11 1D B1 42 34 D8 53 69 01 EB 43 03 9E 42 2F D2 D4 F8 14 80 17 F1 20 01 20 46 ?? ?? ?? ?? 85 68 25 B3 03 68 03 B3 1A 68 F2 B1 93 69 08 2B 01 D3 51 68 00 E0 11 1D A9 42 14 D8 53 69 01 EB 43 03 9D 42 0F D2 7A 68 06 EB 48 01 53 46 28 46 CD F8 00 90 ?? ?? ?? ?? 63 69 4F F0 00 08 98 42 0D D9 60 B1 A9 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 63 69 98 42 09 D8 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 60 61 23 F8 10 80 04 E0 C1 1A 00 22 20 46 ?? ?? ?? ?? 20 46 0D B0 BD E8 F0 0F 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1223_1 {
	meta:
		name = "?do_unshift@?$codecvt@GDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PAD1AAPAD@Z"
		size = 102
		refs = "0008 __security_push_cookie 0026 _Wcrtomb 0050 memcpy 005e __security_pop_cookie"
		altNames = "?do_unshift@?$codecvt@_WDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PAD1AAPAD@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 82 B0 0C 9F 9A 46 0E 46 3A 60 D1 E9 00 89 0A 46 00 F1 08 03 00 21 68 46 00 25 ?? ?? ?? ?? 04 46 00 2C D8 BF 02 25 12 DD 38 68 64 1E AA EB 00 03 A3 42 03 DA C6 E9 00 89 01 25 08 E0 00 2C 06 DD 69 46 22 46 ?? ?? ?? ?? 3B 68 23 44 3B 60 28 46 02 B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_17_1225_1 {
	meta:
		name = "?do_widen@?$ctype@G@std@@MBAGD@Z"
		size = 58
		refs = "0022 _Mbrtowc"
		altNames = "?do_widen@?$ctype@_W@std@@MBA_WD@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 86 B0 00 23 CD E9 04 33 00 F1 18 03 00 93 8D F8 08 10 04 AB 02 A9 0D F1 0A 00 01 22 ?? ?? ?? ?? 00 28 02 DA 4F F6 FF 70 01 E0 BD F8 0A 00 06 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_17_1226_1 {
	meta:
		name = "?do_widen@?$ctype@G@std@@MBAPBDPBD0PAG@Z"
		size = 96
		refs = "003c _Mbrtowc"
		altNames = "?do_widen@?$ctype@_W@std@@MBAPBDPBD0PA_W@Z"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 0C 46 15 1B 00 26 94 42 88 BF 00 25 1F 46 F5 B1 00 F1 18 08 4F F0 00 09 14 F8 01 3B 01 22 02 A9 8D F8 08 30 04 AB 0D F1 0A 00 CD E9 04 99 CD F8 00 80 ?? ?? ?? ?? 00 28 02 DA 4F F6 FF 73 01 E0 BD F8 0A 30 76 1C AE 42 27 F8 02 3B E4 D1 20 46 06 B0 BD E8 F0 8B }
	condition:
		$1
}

rule file_17_1231_1 {
	meta:
		name = "?end@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 42
		altNames = "?end@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 83 69 08 2B 01 D3 42 68 00 E0 02 1D 43 69 02 EB 43 03 00 22 C1 E9 00 22 8B 60 03 68 08 46 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_17_1235_1 {
	meta:
		name = "?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z"
		size = 24
		altNames = "?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 88 0B 88 9A 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_17_1241_1 {
	meta:
		name = "?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@I@Z"
		size = 42
		refs = "0024 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 8B 42 0B D3 83 69 08 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 23 F8 11 20 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1243_1 {
	meta:
		name = "?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I@Z"
		size = 42
		refs = "0024 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 8B 42 0B D3 83 69 08 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 23 F8 11 20 BD E8 00 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1242_1 {
	meta:
		name = "?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@II@Z"
		size = 114
		refs = "004c memmove 006c ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 15 46 62 69 8A 42 2B D3 53 1A AB 42 0A D8 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 61 61 23 F8 11 20 1A E0 CD B1 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 56 1B 03 EB 41 00 73 1A 04 D0 5A 00 00 EB 45 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 23 F8 16 20 20 46 BD E8 78 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1244_1 {
	meta:
		name = "?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II@Z"
		size = 114
		refs = "004c memmove 006c ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 15 46 62 69 8A 42 2B D3 53 1A AB 42 0A D8 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 61 61 23 F8 11 20 1A E0 CD B1 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 56 1B 03 EB 41 00 73 1A 04 D0 5A 00 00 EB 45 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 66 61 23 F8 16 20 20 46 BD E8 78 88 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1248_1 {
	meta:
		name = "?frac_digits@?$_Mpunct@G@std@@QBAHXZ"
		size = 28
		refs = "0010 _guard_check_icall"
		altNames = "?frac_digits@?$_Mpunct@D@std@@QBAHXZ ?frac_digits@?$_Mpunct@_W@std@@QBAHXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 68 5C 6A 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 }
	condition:
		$1
}

rule file_17_1252_1 {
	meta:
		name = "?get_monthname@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 76
		refs = "0032 _guard_check_icall"
		altNames = "?get_monthname@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z ?get_monthname@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B 87 B0 16 9C 05 46 16 46 04 94 15 9C 98 46 CD E9 10 63 03 94 14 9C 0F 46 02 94 12 9C 00 94 13 9C 01 94 2C 68 E4 69 20 46 ?? ?? ?? ?? 28 46 39 46 32 46 43 46 A0 47 38 46 07 B0 BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1254_1 {
	meta:
		name = "?get_weekday@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 76
		refs = "0032 _guard_check_icall"
		altNames = "?get_weekday@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z ?get_weekday@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B 87 B0 16 9C 05 46 16 46 04 94 15 9C 98 46 CD E9 10 63 03 94 14 9C 0F 46 02 94 12 9C 00 94 13 9C 01 94 2C 68 A4 69 20 46 ?? ?? ?? ?? 28 46 39 46 32 46 43 46 A0 47 38 46 07 B0 BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1256_1 {
	meta:
		name = "?get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 76
		refs = "0032 _guard_check_icall"
		altNames = "?get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z ?get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B 87 B0 16 9C 05 46 16 46 04 94 15 9C 98 46 CD E9 10 63 03 94 14 9C 0F 46 02 94 12 9C 00 94 13 9C 01 94 2C 68 24 6A 20 46 ?? ?? ?? ?? 28 46 39 46 32 46 43 46 A0 47 38 46 07 B0 BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_17_1267_1 {
	meta:
		name = "?insert@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IIG@Z"
		size = 176
		refs = "0024 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 0052 memmove 00a4 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ 00aa ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 04 46 15 46 62 69 0E 46 98 46 B2 42 45 D3 D3 43 AB 42 45 D9 57 19 ED B3 00 22 39 46 ?? ?? ?? ?? C0 B3 A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D 63 69 9B 1B 07 D0 5A 00 73 19 00 EB 43 00 01 EB 46 01 ?? ?? ?? ?? A3 69 01 2D 07 D1 08 2B 01 D3 63 68 00 E0 23 1D 23 F8 16 80 0D E0 08 2B 01 D3 63 68 00 E0 23 1D 03 EB 46 03 2D B1 03 EB 45 02 23 F8 02 8B 93 42 FB D1 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 67 61 23 F8 17 20 20 46 BD E8 F8 89 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1268_1 {
	meta:
		name = "?insert@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II_W@Z"
		size = 176
		refs = "0024 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 0052 memmove 00a4 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ 00aa ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 04 46 15 46 62 69 0E 46 98 46 B2 42 45 D3 D3 43 AB 42 45 D9 57 19 ED B3 00 22 39 46 ?? ?? ?? ?? C0 B3 A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D 63 69 9B 1B 07 D0 5A 00 73 19 00 EB 43 00 01 EB 46 01 ?? ?? ?? ?? A3 69 01 2D 07 D1 08 2B 01 D3 63 68 00 E0 23 1D 23 F8 16 80 0D E0 08 2B 01 D3 63 68 00 E0 23 1D 03 EB 46 03 2D B1 03 EB 45 02 23 F8 02 8B 93 42 FB D1 A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 67 61 23 F8 17 20 20 46 BD E8 F8 89 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1269_1 {
	meta:
		name = "?is@?$ctype@G@std@@QBA_NFG@Z"
		size = 36
		refs = "0014 _guard_check_icall"
		altNames = "?is@?$ctype@_W@std@@QBA_NF_W@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 04 46 23 68 17 46 0E 46 1D 69 28 46 ?? ?? ?? ?? 20 46 31 46 3A 46 A8 47 BD E8 F0 88 }
	condition:
		$1
}

rule file_17_1272_1 {
	meta:
		name = "?length@?$char_traits@G@std@@SAIPBG@Z"
		size = 26
		refs = "0012 wcslen"
		altNames = "?length@?$char_traits@_W@std@@SAIPB_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 88 0B B9 00 20 03 E0 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_17_1275_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBAIU_Nil@2@@Z"
		size = 20
		altNames = "?max_size@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBAIU_Nil@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 6F F0 00 40 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_17_1284_1 {
	meta:
		name = "?max_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIXZ"
		size = 16
		altNames = "?max_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 00 43 98 1E BD E8 00 88 }
	condition:
		$1
}

rule file_17_1289_1 {
	meta:
		name = "?name@locale@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 210
		refs = "0008 __security_push_cookie 002c ??2@YAPAXI@Z 0032 _invalid_parameter_noinfo_noreturn 0066 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z 0070 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@$$QAV01@@Z 008a ??3@YAXPAX@Z 00ca __security_pop_cookie"
	strings:
		$1 = { 2D E9 B0 48 0D F1 0C 0B ?? ?? ?? ?? 94 B0 6F 46 6F F0 01 03 C7 E9 02 33 00 23 3B 60 43 68 0D 46 DB B9 00 23 08 20 3B 61 C7 E9 09 33 ?? ?? ?? ?? 08 B9 ?? ?? ?? ?? 00 23 00 22 38 61 C0 E9 00 32 3B 69 17 F1 10 02 1A 60 0F 23 BB 62 00 23 7B 62 3B 75 17 F1 10 00 01 24 08 E0 99 69 09 B9 03 F1 1C 01 17 F1 30 00 ?? ?? ?? ?? 02 24 01 46 28 46 ?? ?? ?? ?? 44 F0 04 04 14 F0 02 0F 12 D0 BB 6C 24 F0 02 04 10 2B 02 D3 78 6B ?? ?? ?? ?? 0F 23 38 6B BB 64 00 23 7B 64 87 F8 34 30 ?? ?? ?? ?? 00 23 3B 63 14 F0 01 0F 0D D0 BB 6A 10 2B 02 D3 78 69 ?? ?? ?? ?? 0F 23 38 69 BB 62 00 23 7B 62 3B 75 ?? ?? ?? ?? 28 46 14 B0 ?? ?? ?? ?? BD E8 B0 88 }
	condition:
		$1
}

rule file_17_1292_1 {
	meta:
		name = "?narrow@?$ctype@G@std@@QBADGD@Z"
		size = 36
		refs = "0014 _guard_check_icall"
		altNames = "?narrow@?$ctype@_W@std@@QBAD_WD@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 04 46 23 68 17 46 0E 46 9D 6B 28 46 ?? ?? ?? ?? 20 46 31 46 3A 46 A8 47 BD E8 F0 88 }
	condition:
		$1
}

rule file_17_1294_1 {
	meta:
		name = "?neg_format@?$_Mpunct@G@std@@QBA?AUpattern@money_base@2@XZ"
		size = 34
		refs = "0012 _guard_check_icall"
		altNames = "?neg_format@?$_Mpunct@D@std@@QBA?AUpattern@money_base@2@XZ ?neg_format@?$_Mpunct@_W@std@@QBA?AUpattern@money_base@2@XZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 23 68 0E 46 DD 6A 28 46 ?? ?? ?? ?? 20 46 31 46 A8 47 30 46 BD E8 78 88 }
	condition:
		$1
}

rule file_17_1296_1 {
	meta:
		name = "?negative_sign@?$_Mpunct@G@std@@QBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 34
		refs = "0012 _guard_check_icall"
		altNames = "?negative_sign@?$_Mpunct@D@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?negative_sign@?$_Mpunct@_W@std@@QBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 23 68 0E 46 1D 6A 28 46 ?? ?? ?? ?? 20 46 31 46 A8 47 30 46 BD E8 78 88 }
	condition:
		$1
}

rule file_17_1301_1 {
	meta:
		name = "?pos_format@?$_Mpunct@G@std@@QBA?AUpattern@money_base@2@XZ"
		size = 34
		refs = "0012 _guard_check_icall"
		altNames = "?pos_format@?$_Mpunct@D@std@@QBA?AUpattern@money_base@2@XZ ?pos_format@?$_Mpunct@_W@std@@QBA?AUpattern@money_base@2@XZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 23 68 0E 46 9D 6A 28 46 ?? ?? ?? ?? 20 46 31 46 A8 47 30 46 BD E8 78 88 }
	condition:
		$1
}

rule file_17_1306_1 {
	meta:
		name = "?replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IIABV12@II@Z"
		size = 664
		refs = "0054 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 00ba memmove 00e6 memcpy 0286 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ 0292 ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F8 4F 0D F1 20 0B 04 46 60 69 89 46 1D 46 48 45 17 46 C0 F0 36 81 6B 69 DD F8 28 A0 53 45 C0 F0 33 81 0B 9E 42 1A 97 42 A3 EB 0A 03 88 BF 17 46 9E 42 88 BF 1E 46 F3 43 C1 1B 8B 42 40 F2 27 81 8B 19 00 93 98 42 A2 EB 07 08 04 D2 00 22 19 46 20 46 ?? ?? ?? ?? BE 42 14 D1 AB 69 08 2B 01 D3 69 68 00 E0 29 1D A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 2E 00 F0 F7 80 72 00 01 EB 4A 01 03 EB 49 00 EE E0 A3 69 AC 42 2F D0 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 0B D0 07 EB 09 03 01 EB 43 01 06 EB 09 03 00 EB 43 00 4F EA 48 02 ?? ?? ?? ?? AB 69 08 2B 01 D3 69 68 00 E0 29 1D A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 2E 00 F0 C6 80 72 00 01 EB 4A 01 03 EB 49 00 ?? ?? ?? ?? BD E0 BE 42 2B D2 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 63 68 00 E0 23 1D 36 B1 72 00 01 EB 4A 01 03 EB 49 00 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 00 F0 9B 80 07 EB 09 03 01 EB 43 01 06 EB 09 03 00 EB 43 00 4F EA 48 02 8D E0 CA 45 1F D8 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 0B D0 07 EB 09 03 01 EB 43 01 06 EB 09 03 00 EB 43 00 4F EA 48 02 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 70 E7 21 1D 6E E7 07 EB 09 05 55 45 29 D8 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 09 D0 06 EB 09 03 00 EB 43 00 4F EA 48 02 01 EB 45 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D 00 2E 45 D0 72 00 F3 1B 53 44 00 EB 49 00 3B E0 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 63 68 00 E0 23 1D 37 B1 7A 00 01 EB 4A 01 03 EB 49 00 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 09 D0 06 EB 09 03 00 EB 43 00 4F EA 48 02 01 EB 45 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D F3 1B 08 D0 5A 00 06 EB 0A 03 00 EB 45 00 01 EB 43 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 9A 00 21 20 46 62 61 23 F8 12 10 BD E8 F8 8F 20 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1309_1 {
	meta:
		name = "?replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@IIABV12@II@Z"
		size = 664
		refs = "0054 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 00ba memmove 00e6 memcpy 0286 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ 0292 ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 F8 4F 0D F1 20 0B 04 46 60 69 89 46 1D 46 48 45 17 46 C0 F0 36 81 6B 69 DD F8 28 A0 53 45 C0 F0 33 81 0B 9E 42 1A 97 42 A3 EB 0A 03 88 BF 17 46 9E 42 88 BF 1E 46 F3 43 C1 1B 8B 42 40 F2 27 81 8B 19 00 93 98 42 A2 EB 07 08 04 D2 00 22 19 46 20 46 ?? ?? ?? ?? BE 42 14 D1 AB 69 08 2B 01 D3 69 68 00 E0 29 1D A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 2E 00 F0 F7 80 72 00 01 EB 4A 01 03 EB 49 00 EE E0 A3 69 AC 42 2F D0 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 0B D0 07 EB 09 03 01 EB 43 01 06 EB 09 03 00 EB 43 00 4F EA 48 02 ?? ?? ?? ?? AB 69 08 2B 01 D3 69 68 00 E0 29 1D A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 2E 00 F0 C6 80 72 00 01 EB 4A 01 03 EB 49 00 ?? ?? ?? ?? BD E0 BE 42 2B D2 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 63 68 00 E0 23 1D 36 B1 72 00 01 EB 4A 01 03 EB 49 00 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 00 F0 9B 80 07 EB 09 03 01 EB 43 01 06 EB 09 03 00 EB 43 00 4F EA 48 02 8D E0 CA 45 1F D8 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 0B D0 07 EB 09 03 01 EB 43 01 06 EB 09 03 00 EB 43 00 4F EA 48 02 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 70 E7 21 1D 6E E7 07 EB 09 05 55 45 29 D8 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 09 D0 06 EB 09 03 00 EB 43 00 4F EA 48 02 01 EB 45 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D 00 2E 45 D0 72 00 F3 1B 53 44 00 EB 49 00 3B E0 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 63 68 00 E0 23 1D 37 B1 7A 00 01 EB 4A 01 03 EB 49 00 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 09 D0 06 EB 09 03 00 EB 43 00 4F EA 48 02 01 EB 45 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D F3 1B 08 D0 5A 00 06 EB 0A 03 00 EB 45 00 01 EB 43 01 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 9A 00 21 20 46 62 61 23 F8 12 10 BD E8 F8 8F 20 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1307_1 {
	meta:
		name = "?replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IIPBGI@Z"
		size = 322
		refs = "0054 ?replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IIABV12@II@Z 00ae memmove 00c2 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 0116 memcpy 0136 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ 013c ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 9A 46 15 46 89 46 04 46 23 B3 A2 69 08 2A 01 D3 60 68 00 E0 20 1D 82 45 1C D3 08 2A 01 D3 61 68 00 E0 21 1D 63 69 01 EB 43 03 53 45 12 D9 08 2A 01 D3 62 68 00 E0 22 1D 0C 9B 49 46 20 46 01 93 AA EB 02 03 5B 10 00 93 23 46 2A 46 ?? ?? ?? ?? 04 46 68 E0 63 69 4B 45 68 D3 A3 EB 09 01 0C 9E 8D 42 88 BF 0D 46 5A 1B F3 43 93 42 61 D9 A1 EB 05 08 AE 42 19 D2 A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 0B D0 05 EB 09 03 01 EB 43 01 09 EB 06 03 00 EB 43 00 4F EA 48 02 ?? ?? ?? ?? 63 69 5B 1B 9F 19 06 B9 C5 B3 00 22 39 46 20 46 ?? ?? ?? ?? 90 B3 B5 42 19 D2 A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 0B D0 05 EB 09 03 01 EB 43 01 09 EB 06 03 00 EB 43 00 4F EA 48 02 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 2E B1 72 00 03 EB 49 00 51 46 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 67 61 23 F8 17 20 20 46 BD E8 FE 8F 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1310_1 {
	meta:
		name = "?replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@IIPB_WI@Z"
		size = 322
		refs = "0054 ?replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@IIABV12@II@Z 00ae memmove 00c2 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 0116 memcpy 0136 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ 013c ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 9A 46 15 46 89 46 04 46 23 B3 A2 69 08 2A 01 D3 60 68 00 E0 20 1D 82 45 1C D3 08 2A 01 D3 61 68 00 E0 21 1D 63 69 01 EB 43 03 53 45 12 D9 08 2A 01 D3 62 68 00 E0 22 1D 0C 9B 49 46 20 46 01 93 AA EB 02 03 5B 10 00 93 23 46 2A 46 ?? ?? ?? ?? 04 46 68 E0 63 69 4B 45 68 D3 A3 EB 09 01 0C 9E 8D 42 88 BF 0D 46 5A 1B F3 43 93 42 61 D9 A1 EB 05 08 AE 42 19 D2 A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 0B D0 05 EB 09 03 01 EB 43 01 09 EB 06 03 00 EB 43 00 4F EA 48 02 ?? ?? ?? ?? 63 69 5B 1B 9F 19 06 B9 C5 B3 00 22 39 46 20 46 ?? ?? ?? ?? 90 B3 B5 42 19 D2 A3 69 08 2B 01 D3 61 68 00 E0 21 1D 08 2B 01 D3 60 68 00 E0 20 1D B8 F1 00 0F 0B D0 05 EB 09 03 01 EB 43 01 09 EB 06 03 00 EB 43 00 4F EA 48 02 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 2E B1 72 00 03 EB 49 00 51 46 ?? ?? ?? ?? A3 69 08 2B 01 D3 63 68 00 E0 23 1D 00 22 67 61 23 F8 17 20 20 46 BD E8 FE 8F 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1308_1 {
	meta:
		name = "?replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@1@Z"
		size = 342
		refs = "005c ?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 0088 ?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@II@Z 0124 ?replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IIPBGI@Z 0130 _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 1E 46 34 68 17 46 88 46 81 46 0C B9 00 25 00 E0 25 68 0E 99 0B 68 0B B9 00 22 00 E0 1A 68 95 42 40 F0 81 80 B5 68 89 68 8D 42 2B D1 3B 68 0B B9 00 22 00 E0 1A 68 D8 F8 00 30 0B B9 00 23 00 E0 1B 68 9A 42 71 D1 BA 68 D8 F8 08 30 02 A9 48 46 D4 1A ?? ?? ?? ?? D8 F8 00 30 0B B9 00 22 00 E0 1A 68 03 68 0B B9 00 23 00 E0 1B 68 9A 42 5E D1 D8 F8 08 20 83 68 48 46 D3 1A 59 10 62 10 ?? ?? ?? ?? 4C E0 0B B9 00 22 00 E0 1A 68 0C B9 00 23 00 E0 23 68 9A 42 4C D1 4B 1B 5E 10 00 2D 4A D0 00 2C 50 D0 22 68 00 2A 4D D0 93 69 08 2B 01 D3 51 68 00 E0 11 1D A9 42 43 D8 53 69 01 EB 43 03 9D 42 3E D2 3B 68 0B B9 00 22 00 E0 1A 68 D8 F8 00 30 0B B9 00 23 00 E0 1B 68 9A 42 2D D1 BA 68 D8 F8 08 30 02 A9 48 46 D4 1A ?? ?? ?? ?? D8 F8 00 30 0B B9 00 22 00 E0 1A 68 03 68 0B B9 00 23 00 E0 1B 68 9A 42 1A D1 D8 F8 08 10 82 68 2B 46 48 46 8A 1A 51 10 62 10 00 96 ?? ?? ?? ?? 48 46 06 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1311_1 {
	meta:
		name = "?replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@1@Z"
		size = 342
		refs = "005c ?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0088 ?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II@Z 0124 ?replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@IIPB_WI@Z 0130 _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 1E 46 34 68 17 46 88 46 81 46 0C B9 00 25 00 E0 25 68 0E 99 0B 68 0B B9 00 22 00 E0 1A 68 95 42 40 F0 81 80 B5 68 89 68 8D 42 2B D1 3B 68 0B B9 00 22 00 E0 1A 68 D8 F8 00 30 0B B9 00 23 00 E0 1B 68 9A 42 71 D1 BA 68 D8 F8 08 30 02 A9 48 46 D4 1A ?? ?? ?? ?? D8 F8 00 30 0B B9 00 22 00 E0 1A 68 03 68 0B B9 00 23 00 E0 1B 68 9A 42 5E D1 D8 F8 08 20 83 68 48 46 D3 1A 59 10 62 10 ?? ?? ?? ?? 4C E0 0B B9 00 22 00 E0 1A 68 0C B9 00 23 00 E0 23 68 9A 42 4C D1 4B 1B 5E 10 00 2D 4A D0 00 2C 50 D0 22 68 00 2A 4D D0 93 69 08 2B 01 D3 51 68 00 E0 11 1D A9 42 43 D8 53 69 01 EB 43 03 9D 42 3E D2 3B 68 0B B9 00 22 00 E0 1A 68 D8 F8 00 30 0B B9 00 23 00 E0 1B 68 9A 42 2D D1 BA 68 D8 F8 08 30 02 A9 48 46 D4 1A ?? ?? ?? ?? D8 F8 00 30 0B B9 00 22 00 E0 1A 68 03 68 0B B9 00 23 00 E0 1B 68 9A 42 1A D1 D8 F8 08 10 82 68 2B 46 48 46 8A 1A 51 10 62 10 00 96 ?? ?? ?? ?? 48 46 06 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_17_1314_1 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
		size = 46
		refs = "0026 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 99 42 0A D8 83 69 08 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 23 F8 11 20 03 E0 C9 1A 00 22 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_17_1316_1 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
		size = 46
		refs = "0026 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 99 42 0A D8 83 69 08 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 23 F8 11 20 03 E0 C9 1A 00 22 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_17_1315_1 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXIG@Z"
		size = 44
		refs = "0024 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 99 42 0A D8 83 69 08 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 23 F8 11 20 02 E0 C9 1A ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_17_1317_1 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI_W@Z"
		size = 44
		refs = "0024 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 43 69 99 42 0A D8 83 69 08 2B 01 D3 43 68 00 E0 03 1D 00 22 41 61 23 F8 11 20 02 E0 C9 1A ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_17_1318_1 {
	meta:
		name = "?sbumpc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QAAGXZ"
		size = 66
		refs = "0036 _guard_check_icall"
		altNames = "?sbumpc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QAAGXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 EB 69 1B 68 13 B1 EB 6A 1B 68 00 E0 00 23 00 2B 09 DD EA 6A 13 68 5B 1E 13 60 EA 69 11 68 8B 1C 13 60 08 88 06 E0 2B 68 DC 69 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 }
	condition:
		$1
}

rule file_17_1324_1 {
	meta:
		name = "?sgetc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QAAGXZ"
		size = 50
		refs = "0026 _guard_check_icall"
		altNames = "?sgetc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QAAGXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 EB 69 1A 68 12 B1 EB 6A 1B 68 00 E0 00 23 00 2B 01 DD 10 88 06 E0 2B 68 9C 69 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 }
	condition:
		$1
}

rule file_17_1329_1 {
	meta:
		name = "?sputc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QAAGG@Z"
		size = 74
		refs = "0038 _guard_check_icall"
		altNames = "?sputc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QAAG_W@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2B 6A 0E 46 1B 68 13 B1 2B 6B 1B 68 00 E0 00 23 00 2B 09 DD 2A 6B 13 68 5B 1E 13 60 2A 6A 11 68 8B 1C 13 60 0E 80 08 E0 2B 68 DC 68 20 46 ?? ?? ?? ?? 28 46 31 46 A0 47 06 46 30 46 BD E8 78 88 }
	condition:
		$1
}

rule file_17_1342_1 {
	meta:
		name = "?widen@?$ctype@G@std@@QBAGD@Z"
		size = 32
		refs = "0012 _guard_check_icall"
		altNames = "?widen@?$ctype@_W@std@@QBA_WD@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 23 68 0E 46 1D 6B 28 46 ?? ?? ?? ?? 20 46 31 46 A8 47 BD E8 78 88 }
	condition:
		$1
}

rule file_17_1343_1 {
	meta:
		name = "?widen@?$ctype@G@std@@QBAPBDPBD0PAG@Z"
		size = 40
		refs = "0016 _guard_check_icall"
		altNames = "?widen@?$ctype@_W@std@@QBAPBDPBD0PA_W@Z"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 05 46 2C 68 98 46 17 46 E4 6A 0E 46 20 46 ?? ?? ?? ?? 28 46 31 46 3A 46 43 46 A0 47 BD E8 F8 89 }
	condition:
		$1
}

rule file_17_1354_1 {
	meta:
		name = "memcpy_s"
		size = 94
		refs = "0016 _errno 001e _invalid_parameter_noinfo 0034 memcpy 003e memset"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 1C 46 16 46 0D 46 0C B9 00 24 07 E0 48 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 24 20 46 BD E8 78 88 36 B1 A5 42 04 D3 22 46 31 46 ?? ?? ?? ?? EA E7 2A 46 00 21 ?? ?? ?? ?? 1E B9 ?? ?? ?? ?? 16 24 04 E0 A5 42 E8 D2 ?? ?? ?? ?? 22 24 04 60 ?? ?? ?? ?? E2 E7 }
	condition:
		$1
}

rule file_17_1356_1 {
	meta:
		name = "wmemcpy"
		size = 16
		refs = "000c memcpy"
	strings:
		$1 = { 2D E9 00 48 EB 46 52 00 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1357_1 {
	meta:
		name = "wmemmove"
		size = 16
		refs = "000c memmove"
	strings:
		$1 = { 2D E9 00 48 EB 46 52 00 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1358_1 {
	meta:
		name = "wmemset"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 32 B1 03 46 00 EB 42 02 23 F8 02 1B 93 42 FB D1 BD E8 00 88 }
	condition:
		$1
}

rule file_18_0_1 {
	meta:
		name = "_FSinh"
		size = 324
		refs = "0018 _FDtest 00bc _FExp 00ec _Feraise 0130 _FXbig 0140 _FRteps"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 81 B0 68 46 B0 EE 60 8A 8D ED 00 0A ?? ?? ?? ?? 00 28 7B D0 01 28 6C D0 02 28 67 D0 B5 EE 40 8A F1 EE 10 FA 07 D1 9D ED 00 0A B5 EE C0 0A F1 EE 10 FA 6F D2 67 E0 9D ED 00 2A B5 EE C0 2A F1 EE 10 FA 05 D2 B1 EE 42 2A 01 24 8D ED 00 2A 00 E0 00 24 38 4B 93 ED 00 0A B4 EE C0 2A F1 EE 10 FA 16 D3 F7 EE 00 0A B4 EE E0 2A F1 EE 10 FA 12 D2 9F ED 2F 0A DF ED 2D 0A 62 EE 02 1A 9F ED 2A 1A 41 EE 80 0A 00 EE A1 1A 21 EE 21 0A 00 EE 02 2A 22 EE 08 8A 28 E0 23 4B 6F F0 00 01 93 ED 00 0A B4 EE C0 2A F1 EE 10 FA 0F D2 68 46 B0 EE 60 0A ?? ?? ?? ?? DD ED 00 0A B5 EE 00 0A 80 EE 20 0A 30 EE C0 0A 20 EE 08 8A 0E E0 68 46 B0 EE 48 0A ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 00 8A 00 2C 0B E0 9D ED 00 8A 10 E0 B5 EE 40 8A F1 EE 10 FA F7 D1 BD F8 02 30 13 F4 00 4F 06 D0 B1 EE 48 8A 03 E0 9D ED 00 2A 22 EE 08 8A B0 EE 48 0A 01 B0 BD EC 02 8B BD E8 10 88 FE DE ?? ?? ?? ?? DA AA 2A 3E D7 79 08 3C D5 E8 55 39 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_0_1 {
	meta:
		name = "??0_ContextCallback@details@Concurrency@@QAA@_N@Z"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 09 B1 01 23 00 E0 00 23 03 60 BD E8 00 88 }
	condition:
		$1
}

rule file_19_2_1 {
	meta:
		name = "??1?$_Func_class@X$$V@std@@QAA@XZ"
		size = 48
		refs = "001e _guard_check_icall"
		altNames = "??1?$function@$$A6AXXZ@std@@QAA@XZ ?_Tidy@?$_Func_class@X$$V@std@@IAAXXZ"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 06 46 75 6A 75 B1 2B 68 B5 42 18 BF 01 27 1C 69 08 BF 00 27 20 46 ?? ?? ?? ?? 28 46 39 46 A0 47 00 23 73 62 BD E8 F0 88 }
	condition:
		$1
}

rule file_19_5_1 {
	meta:
		name = "??R?$_Func_class@X$$V@std@@QBAXXZ"
		size = 36
		refs = "0012 _guard_check_icall 001e ?_Xbad_function_call@std@@YAXXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 45 6A 45 B1 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 BD E8 30 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_19_6_1 {
	meta:
		name = "?CaptureCallstack@platform@details@Concurrency@@YAIPAPAXII@Z"
		size = 36
		refs = "0020 __imp_RtlCaptureStackBackTrace"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 14 46 0D 46 21 46 04 4C 02 46 00 23 24 68 68 1C A0 47 BD E8 30 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_7_1 {
	meta:
		name = "?GetCurrentThreadId@platform@details@Concurrency@@YAJXZ"
		size = 20
		refs = "0010 __imp_GetCurrentThreadId"
		altNames = "_Thrd_id"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_1_1 {
	meta:
		name = "?_Mtx_lock@threads@stdext@@YAXPAX@Z"
		size = 20
		refs = "0010 __imp_EnterCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_3_1 {
	meta:
		name = "?_Mtx_unlock@threads@stdext@@YAXPAX@Z"
		size = 20
		refs = "0010 __imp_LeaveCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_95_2 {
	meta:
		name = "_Close_dir"
		size = 20
		refs = "0010 __imp_FindClose"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_0_2 {
	meta:
		name = "_Mtxdst"
		size = 20
		refs = "0010 __imp_DeleteCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_2_2 {
	meta:
		name = "_Mtxlock"
		size = 20
		refs = "0010 __imp_EnterCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_3_2 {
	meta:
		name = "_Mtxunlock"
		size = 20
		refs = "0010 __imp_LeaveCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_0_2 {
	meta:
		name = "_Smtx_lock_exclusive"
		size = 20
		refs = "0010 __imp_AcquireSRWLockExclusive"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_1_1 {
	meta:
		name = "_Smtx_lock_shared"
		size = 20
		refs = "0010 __imp_AcquireSRWLockShared"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_2_2 {
	meta:
		name = "_Smtx_try_lock_exclusive"
		size = 20
		refs = "0010 __imp_TryAcquireSRWLockExclusive"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_3_2 {
	meta:
		name = "_Smtx_try_lock_shared"
		size = 20
		refs = "0010 __imp_TryAcquireSRWLockShared"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_4_2 {
	meta:
		name = "_Smtx_unlock_exclusive"
		size = 20
		refs = "0010 __imp_ReleaseSRWLockExclusive"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_5_2 {
	meta:
		name = "_Smtx_unlock_shared"
		size = 20
		refs = "0010 __imp_ReleaseSRWLockShared"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_11_3 {
	meta:
		name = "__vcrt_FlsAlloc"
		size = 20
		refs = "0010 __imp_FlsAlloc"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_12_3 {
	meta:
		name = "__vcrt_FlsFree"
		size = 20
		refs = "0010 __imp_FlsFree"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_13_3 {
	meta:
		name = "__vcrt_FlsGetValue"
		size = 20
		refs = "0010 __imp_FlsGetValue"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_14_3 {
	meta:
		name = "__vcrt_FlsSetValue"
		size = 20
		refs = "0010 __imp_FlsSetValue"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_0_3 {
	meta:
		name = "__vcrt_GetModuleFileNameW"
		size = 20
		refs = "0010 __imp_GetModuleFileNameW"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_1_3 {
	meta:
		name = "__vcrt_GetModuleHandleW"
		size = 20
		refs = "0010 __imp_GetModuleHandleW"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_0_3 {
	meta:
		name = "__vcrt_InitializeCriticalSectionEx"
		size = 20
		refs = "0010 __imp_InitializeCriticalSectionEx"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_2_3 {
	meta:
		name = "__vcrt_LoadLibraryExW"
		size = 20
		refs = "0010 __imp_LoadLibraryExW"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_8_1 {
	meta:
		name = "?GetNextAsyncId@platform@details@Concurrency@@YAIXZ"
		size = 40
		refs = "0024 ?s_asyncId@platform@details@Concurrency@@3IA"
	strings:
		$1 = { 2D E9 00 48 EB 46 BF F3 5B 8F 06 4A 52 E8 00 0F 40 1C 42 E8 00 03 00 2B F8 D1 BF F3 5B 8F BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_11_1 {
	meta:
		name = "?_CallInContext@_ContextCallback@details@Concurrency@@QBAXV?$function@$$A6AXXZ@std@@_N@Z"
		size = 96
		refs = "001c ?_Xbad_function_call@std@@YAXXZ 0026 _guard_check_icall"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 0D 46 6F F0 01 03 FD 62 C7 E9 00 33 6E 6A 0E B9 ?? ?? ?? ?? 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 D5 F8 24 80 B8 F1 00 0F 0F D0 D8 F8 00 30 A8 45 18 BF 01 26 1C 69 08 BF 00 26 20 46 ?? ?? ?? ?? 40 46 31 46 A0 47 00 23 6B 62 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_19_14_1 {
	meta:
		name = "?_Empty@?$_Func_class@X$$V@std@@IBA_NXZ"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 43 6A 0B B9 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_19_19_1 {
	meta:
		name = "?_Local@?$_Func_class@X$$V@std@@ABA_NXZ"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 43 6A 83 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_20_6_1 {
	meta:
		name = "??$_Fgetc@G@std@@YA_NAAGPAU_iobuf@@@Z"
		size = 36
		refs = "000c fgetwc"
		altNames = "??$_Fgetc@_W@std@@YA_NAA_WPAU_iobuf@@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 08 46 ?? ?? ?? ?? 4F F6 FF 73 98 42 08 BF 00 20 01 D0 20 80 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_20_7_1 {
	meta:
		name = "??$_Fputc@G@std@@YA_NGPAU_iobuf@@@Z"
		size = 28
		refs = "0006 fputwc"
		altNames = "??$_Fputc@_W@std@@YA_N_WPAU_iobuf@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 4F F6 FF 73 98 42 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_20_12_1 {
	meta:
		name = "??$_Ungetc@G@std@@YA_NABGPAU_iobuf@@@Z"
		size = 30
		refs = "0008 ungetwc"
		altNames = "??$_Ungetc@_W@std@@YA_NAB_WPAU_iobuf@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 88 ?? ?? ?? ?? 4F F6 FF 73 98 42 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_20_51_1 {
	meta:
		name = "??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAA@PAU_iobuf@@@Z"
		size = 40
		refs = "000c ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAA@XZ 001a ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 0024 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 04 4B 00 22 21 46 28 46 2B 60 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_51_1 {
	meta:
		name = "??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAA@PAU_iobuf@@@Z"
		size = 40
		refs = "000c ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAA@XZ 001a ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 0024 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 04 4B 00 22 21 46 28 46 2B 60 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_51_1 {
	meta:
		name = "??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z"
		size = 40
		refs = "000c ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAA@XZ 001a ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 0024 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 04 4B 00 22 21 46 28 46 2B 60 ?? ?? ?? ?? 28 46 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_53_1 {
	meta:
		name = "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 156
		refs = "0050 ?_Init@ios_base@std@@IAAXXZ 005c ?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBAGD@Z 0076 ?clear@ios_base@std@@QAAXH_N@Z 007e ?_Addstd@ios_base@std@@SAXPAV12@@Z 0090 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0094 ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 0098 ??_8?$basic_ostream@GU?$char_traits@G@std@@@std@@7B@"
	strings:
		$1 = { 0F B4 2D E9 FF 4B 0D F1 28 0B 6F 46 16 46 05 46 6F F0 01 02 3D 63 4F F0 00 09 C7 E9 02 22 C7 F8 00 90 88 46 2B B1 1C 4B 2B 60 1A 4B AB 60 01 23 3B 60 2B 68 5C 68 16 4B 63 51 2B 68 5B 68 A3 F1 08 02 2B 44 43 F8 04 2C 2B 68 5B 68 5C 19 20 46 ?? ?? ?? ?? 20 21 20 46 C4 E9 0E 89 ?? ?? ?? ?? A3 6B A4 F8 40 00 43 B9 E3 68 00 22 20 46 43 F0 04 03 43 F0 04 01 ?? ?? ?? ?? 16 B1 20 46 ?? ?? ?? ?? 28 46 04 B0 BD E8 F0 0B 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_53_1 {
	meta:
		name = "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 156
		refs = "0050 ?_Init@ios_base@std@@IAAXXZ 005c ?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBA_WD@Z 0076 ?clear@ios_base@std@@QAAXH_N@Z 007e ?_Addstd@ios_base@std@@SAXPAV12@@Z 0090 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0094 ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 0098 ??_8?$basic_ostream@_WU?$char_traits@_W@std@@@std@@7B@"
	strings:
		$1 = { 0F B4 2D E9 FF 4B 0D F1 28 0B 6F 46 16 46 05 46 6F F0 01 02 3D 63 4F F0 00 09 C7 E9 02 22 C7 F8 00 90 88 46 2B B1 1C 4B 2B 60 1A 4B AB 60 01 23 3B 60 2B 68 5C 68 16 4B 63 51 2B 68 5B 68 A3 F1 08 02 2B 44 43 F8 04 2C 2B 68 5B 68 5C 19 20 46 ?? ?? ?? ?? 20 21 20 46 C4 E9 0E 89 ?? ?? ?? ?? A3 6B A4 F8 40 00 43 B9 E3 68 00 22 20 46 43 F0 04 03 43 F0 04 01 ?? ?? ?? ?? 16 B1 20 46 ?? ?? ?? ?? 28 46 04 B0 BD E8 F0 0B 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_54_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 3B 6B 03 F1 08 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_44_54_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 3B 6B 03 F1 08 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_60_54_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 3B 6B 03 F1 08 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_20_55_1 {
	meta:
		name = "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAA@XZ"
		size = 116
		refs = "001a ??2@YAPAXI@Z 0024 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0070 ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 17 4B 05 46 08 20 2B 60 ?? ?? ?? ?? 04 46 24 B1 01 20 ?? ?? ?? ?? 60 60 00 E0 00 24 2B 1D EB 60 05 F1 14 03 EB 61 05 F1 18 03 2B 62 05 F1 24 03 EB 62 05 F1 28 03 05 F1 08 02 00 21 C5 E9 0C 34 2A 61 11 60 2B 6A 19 60 2B 6B 19 60 EB 68 19 60 EB 69 19 60 EB 6A 19 60 28 46 BD E8 BE 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_55_1 {
	meta:
		name = "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAA@XZ"
		size = 116
		refs = "001a ??2@YAPAXI@Z 0024 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0070 ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 17 4B 05 46 08 20 2B 60 ?? ?? ?? ?? 04 46 24 B1 01 20 ?? ?? ?? ?? 60 60 00 E0 00 24 2B 1D EB 60 05 F1 14 03 EB 61 05 F1 18 03 2B 62 05 F1 24 03 EB 62 05 F1 28 03 05 F1 08 02 00 21 C5 E9 0C 34 2A 61 11 60 2B 6A 19 60 2B 6B 19 60 EB 68 19 60 EB 69 19 60 EB 6A 19 60 28 46 BD E8 BE 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_55_1 {
	meta:
		name = "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAA@XZ"
		size = 116
		refs = "001a ??2@YAPAXI@Z 0024 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0070 ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 17 4B 05 46 08 20 2B 60 ?? ?? ?? ?? 04 46 24 B1 01 20 ?? ?? ?? ?? 60 60 00 E0 00 24 2B 1D EB 60 05 F1 14 03 EB 61 05 F1 18 03 2B 62 05 F1 24 03 EB 62 05 F1 28 03 05 F1 08 02 00 21 C5 E9 0C 34 2A 61 11 60 2B 6A 19 60 2B 6B 19 60 EB 68 19 60 EB 69 19 60 EB 6A 19 60 28 46 BD E8 BE 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_67_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QAA@U_Mbstatet@@_J@Z"
		size = 34
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 00 23 C0 E9 00 33 06 9B C0 E9 04 12 83 60 07 9B C3 60 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_68_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z"
		size = 24
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 E9 00 23 00 23 C0 E9 02 33 C0 E9 04 33 BD E8 00 88 }
	condition:
		$1
}

rule file_20_74_1 {
	meta:
		name = "??0_Init_ushcout@std@@QAA@XZ"
		size = 84
		refs = "0040 ?_Ptr_wclog@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0044 ?_Ptr_wcerr@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0048 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 004c ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0050 ?_Ptr_wcin@std@@3PAV?$basic_istream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 11 4B 10 49 0E 4C 1A 68 21 60 22 B1 13 68 5B 68 13 44 D9 63 21 68 09 4B 1A 68 22 B1 13 68 5B 68 13 44 D9 63 21 68 04 4B 1A 68 1A B1 13 68 5B 68 13 44 D9 63 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_74_1 {
	meta:
		name = "??0_Init_cout@std@@QAA@XZ"
		size = 84
		refs = "0040 ?_Ptr_clog@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0044 ?_Ptr_cerr@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0048 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 004c ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0050 ?_Ptr_cin@std@@3PAV?$basic_istream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 11 4B 10 49 0E 4C 1A 68 21 60 22 B1 13 68 5B 68 13 44 D9 63 21 68 09 4B 1A 68 22 B1 13 68 5B 68 13 44 D9 63 21 68 04 4B 1A 68 1A B1 13 68 5B 68 13 44 D9 63 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_74_1 {
	meta:
		name = "??0_Init_wcout@std@@QAA@XZ"
		size = 84
		refs = "0040 ?_Ptr_wclog@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0044 ?_Ptr_wcerr@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0048 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 004c ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0050 ?_Ptr_wcin@std@@3PAV?$basic_istream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 11 4B 10 49 0E 4C 1A 68 21 60 22 B1 13 68 5B 68 13 44 D9 63 21 68 09 4B 1A 68 22 B1 13 68 5B 68 13 44 D9 63 21 68 04 4B 1A 68 1A B1 13 68 5B 68 13 44 D9 63 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_118_1 {
	meta:
		name = "??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 104
		refs = "0046 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAA_NXZ 004c fclose 0056 ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 005c ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0064 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 9C 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 14 4B 04 46 23 60 E3 6C 73 B1 E0 68 04 F1 3C 02 03 68 93 42 08 D1 D4 E9 14 21 02 60 E3 69 1A 60 8B 1A 5A 10 E3 6A 1A 60 94 F8 48 30 63 B1 E3 6C 2B B1 20 46 ?? ?? ?? ?? E0 6C ?? ?? ?? ?? 02 22 00 21 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? BD E8 9C 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_118_1 {
	meta:
		name = "??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 104
		refs = "0046 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAA_NXZ 004c fclose 0056 ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 005c ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0064 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 9C 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 14 4B 04 46 23 60 E3 6C 73 B1 E0 68 04 F1 3C 02 03 68 93 42 08 D1 D4 E9 14 21 02 60 E3 69 1A 60 8B 1A 5A 10 E3 6A 1A 60 94 F8 48 30 63 B1 E3 6C 2B B1 20 46 ?? ?? ?? ?? E0 6C ?? ?? ?? ?? 02 22 00 21 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? BD E8 9C 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_121_1 {
	meta:
		name = "??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 44
		refs = "0028 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 50 F8 08 3C 5B 68 1A 18 06 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 03 44 43 F8 0C 2C BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_122_1 {
	meta:
		name = "??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UAA@XZ"
		size = 44
		refs = "0028 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 50 F8 08 3C 5B 68 1A 18 06 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 03 44 43 F8 0C 2C BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_121_1 {
	meta:
		name = "??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 44
		refs = "0028 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 00 48 EB 46 50 F8 08 3C 5B 68 1A 18 06 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 03 44 43 F8 0C 2C BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_122_1 {
	meta:
		name = "??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 80
		refs = "0024 _guard_check_icall 0044 ??3@YAXPAXI@Z 004c ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 0E 4B 45 6B 03 60 B5 B1 6E 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 08 21 28 46 ?? ?? ?? ?? BD E8 FC 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_123_1 {
	meta:
		name = "??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAA@XZ"
		size = 80
		refs = "0024 _guard_check_icall 0044 ??3@YAXPAXI@Z 004c ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 0E 4B 45 6B 03 60 B5 B1 6E 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 08 21 28 46 ?? ?? ?? ?? BD E8 FC 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_122_1 {
	meta:
		name = "??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 80
		refs = "0024 _guard_check_icall 0044 ??3@YAXPAXI@Z 004c ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 0E 4B 45 6B 03 60 B5 B1 6E 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 08 21 28 46 ?? ?? ?? ?? BD E8 FC 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_149_1 {
	meta:
		name = "??B?$fpos@U_Mbstatet@@@std@@QBA_JXZ"
		size = 26
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B D0 E9 02 14 D0 E9 00 32 C8 18 44 EB 02 01 BD E8 18 88 }
	condition:
		$1
}

rule file_20_151_1 {
	meta:
		name = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAABDXZ"
		size = 64
		refs = "0032 _invalid_parameter_noinfo_noreturn"
		altNames = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 84 68 94 B1 03 68 A3 B1 1A 68 92 B1 93 69 10 2B 01 D3 51 68 00 E0 11 1D A1 42 08 D8 53 69 0B 44 9C 42 04 D2 80 68 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_20_153_1 {
	meta:
		name = "??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ"
		size = 68
		refs = "0034 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 50 F8 08 3B 5B 68 1A 18 09 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 03 44 43 F8 0C 2C 02 4B 03 60 ?? ?? ?? ?? BD E8 8E 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_154_1 {
	meta:
		name = "??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ"
		size = 68
		refs = "0034 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 50 F8 08 3B 5B 68 1A 18 09 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 03 44 43 F8 0C 2C 02 4B 03 60 ?? ?? ?? ?? BD E8 8E 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_153_1 {
	meta:
		name = "??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ"
		size = 68
		refs = "0034 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 50 F8 08 3B 5B 68 1A 18 09 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 03 44 43 F8 0C 2C 02 4B 03 60 ?? ?? ?? ?? BD E8 8E 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_155_1 {
	meta:
		name = "??_E?$basic_ostream@GU?$char_traits@G@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_ostream@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_156_1 {
	meta:
		name = "??_E?$basic_istream@DU?$char_traits@D@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_istream@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_130_2 {
	meta:
		name = "??_E?$basic_istream@GU?$char_traits@G@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_istream@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_155_1 {
	meta:
		name = "??_E?$basic_istream@_WU?$char_traits@_W@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_istream@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_131_2 {
	meta:
		name = "??_E?$basic_ostream@DU?$char_traits@D@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_ostream@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_155_1 {
	meta:
		name = "??_E?$basic_ostream@_WU?$char_traits@_W@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_156_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 36
		refs = "000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 001a ??3@YAXPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 14 F0 01 0F 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 }
	condition:
		$1
}

rule file_27_157_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
		size = 36
		refs = "000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 001a ??3@YAXPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 14 F0 01 0F 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 }
	condition:
		$1
}

rule file_24_156_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
		size = 36
		refs = "000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 001a ??3@YAXPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 14 F0 01 0F 03 D0 58 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 }
	condition:
		$1
}

rule file_20_157_1 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 56
		refs = "001a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0028 ??3@YAXPAXI@Z 0034 ??_7ios_base@std@@6B@"
		altNames = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAAPAXI@Z ??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 46 05 46 07 4B 2B 60 ?? ?? ?? ?? 14 F0 01 0F 03 D0 48 21 28 46 ?? ?? ?? ?? 28 46 BD E8 BE 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_159_1 {
	meta:
		name = "??_G?$basic_ostream@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 92
		refs = "0038 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0048 ??3@YAXPAXI@Z 0054 ??_7ios_base@std@@6B@ 0058 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 50 F8 08 3C 05 46 0C 46 5B 68 5A 19 0E 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 2B 44 43 F8 0C 2C 07 4B 2B 60 ?? ?? ?? ?? 14 F0 01 0F 04 D0 50 21 A5 F1 08 00 ?? ?? ?? ?? A5 F1 08 00 BD E8 BE 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_160_1 {
	meta:
		name = "??_G?$basic_ostream@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
		size = 92
		refs = "0038 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0048 ??3@YAXPAXI@Z 0054 ??_7ios_base@std@@6B@ 0058 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 50 F8 08 3C 05 46 0C 46 5B 68 5A 19 0E 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 2B 44 43 F8 0C 2C 07 4B 2B 60 ?? ?? ?? ?? 14 F0 01 0F 04 D0 50 21 A5 F1 08 00 ?? ?? ?? ?? A5 F1 08 00 BD E8 BE 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_159_1 {
	meta:
		name = "??_G?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
		size = 92
		refs = "0038 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0048 ??3@YAXPAXI@Z 0054 ??_7ios_base@std@@6B@ 0058 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 50 F8 08 3C 05 46 0C 46 5B 68 5A 19 0E 4B 42 F8 08 3C 50 F8 08 3C 5B 68 A3 F1 08 02 2B 44 43 F8 0C 2C 07 4B 2B 60 ?? ?? ?? ?? 14 F0 01 0F 04 D0 50 21 A5 F1 08 00 ?? ?? ?? ?? A5 F1 08 00 BD E8 BE 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_161_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 36
		refs = "000c ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAA@XZ 001a ??3@YAXPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 14 F0 01 0F 03 D0 38 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 }
	condition:
		$1
}

rule file_27_162_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
		size = 36
		refs = "000c ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAA@XZ 001a ??3@YAXPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 14 F0 01 0F 03 D0 38 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 }
	condition:
		$1
}

rule file_24_161_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
		size = 36
		refs = "000c ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 001a ??3@YAXPAXI@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 14 F0 01 0F 03 D0 38 21 28 46 ?? ?? ?? ?? 28 46 BD E8 30 88 }
	condition:
		$1
}

rule file_20_175_1 {
	meta:
		name = "??_Gios_base@std@@UAAPAXI@Z"
		size = 56
		refs = "001a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0028 ??3@YAXPAXI@Z 0034 ??_7ios_base@std@@6B@"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 46 05 46 07 4B 2B 60 ?? ?? ?? ?? 14 F0 01 0F 03 D0 38 21 28 46 ?? ?? ?? ?? 28 46 BD E8 BE 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_177_1 {
	meta:
		name = "??_Glocale@std@@QAAPAXI@Z"
		size = 80
		refs = "0020 _guard_check_icall 0046 ??3@YAXPAXI@Z"
	strings:
		$1 = { 2D E9 FE 49 0D F1 20 0B 6F 46 6F F0 01 03 C7 E9 00 33 88 46 05 46 6E 68 86 B1 33 68 9C 68 20 46 ?? ?? ?? ?? 30 46 A0 47 06 46 3E B1 33 68 1C 68 20 46 ?? ?? ?? ?? 30 46 01 21 A0 47 18 F0 01 0F 03 D0 08 21 28 46 ?? ?? ?? ?? 28 46 BD E8 FE 89 }
	condition:
		$1
}

rule file_20_182_1 {
	meta:
		name = "??__Einitlocks@@YAXXZ"
		size = 32
		refs = "0008 ??0_Init_locks@std@@QAA@XZ 0012 atexit 0018 ??__Finitlocks@@YAXXZ 001c ?initlocks@@3V_Init_locks@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_81_1 {
	meta:
		name = "??__E?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ"
		size = 32
		refs = "0008 ?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0012 atexit 0018 ??__F?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ 001c ?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_5_1 {
	meta:
		name = "??__Einitlocks@std@@YAXXZ"
		size = 32
		refs = "0008 ??0_Init_locks@std@@QAA@XZ 0012 atexit 0018 ??__Finitlocks@std@@YAXXZ 001c ?initlocks@std@@3V_Init_locks@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_183_1 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0018 atexit 001c ??__Fwcout@std@@YAXXZ 0020 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_157_2 {
	meta:
		name = "??__Ecerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0018 atexit 001c ??__Fcerr@std@@YAXXZ 0020 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0024 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_182_1 {
	meta:
		name = "??__Ecin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0018 atexit 001c ??__Fcin@std@@YAXXZ 0020 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 0024 ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_157_2 {
	meta:
		name = "??__Eclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0018 atexit 001c ??__Fclog@std@@YAXXZ 0020 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0024 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_157_2 {
	meta:
		name = "??__Ecout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0018 atexit 001c ??__Fcout@std@@YAXXZ 0020 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0024 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_183_1 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0018 atexit 001c ??__Fwcerr@std@@YAXXZ 0020 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_158_2 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0018 atexit 001c ??__Fwcerr@std@@YAXXZ 0020 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_183_1 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0018 atexit 001c ??__Fwcin@std@@YAXXZ 0020 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0024 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_158_2 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0018 atexit 001c ??__Fwcin@std@@YAXXZ 0020 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0024 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_158_2 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0018 atexit 001c ??__Fwcin@std@@YAXXZ 0020 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0024 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_183_1 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0018 atexit 001c ??__Fwcin@std@@YAXXZ 0020 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0024 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_183_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0018 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_158_2 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0018 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_158_2 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0018 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_183_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0018 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_158_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0018 atexit 001c ??__Fwcout@std@@YAXXZ 0020 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 05 48 01 23 00 22 ?? ?? ?? ?? 02 48 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_184_1 {
	meta:
		name = "??__Ewfout@std@@YAXXZ"
		size = 60
		refs = "000a __acrt_iob_func 0014 ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAA@XZ 0022 ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 002c atexit 0030 ??__Fwfout@std@@YAXXZ 0034 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 0038 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 01 20 ?? ?? ?? ?? 0A 4D 04 46 28 46 ?? ?? ?? ?? 06 4B 00 22 21 46 28 46 2B 60 ?? ?? ?? ?? 02 48 BD E8 30 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_183_1 {
	meta:
		name = "??__Efout@std@@YAXXZ"
		size = 60
		refs = "000a __acrt_iob_func 0014 ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAA@XZ 0022 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 002c atexit 0030 ??__Ffout@std@@YAXXZ 0034 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 0038 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 01 20 ?? ?? ?? ?? 0A 4D 04 46 28 46 ?? ?? ?? ?? 06 4B 00 22 21 46 28 46 2B 60 ?? ?? ?? ?? 02 48 BD E8 30 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_184_1 {
	meta:
		name = "??__Ewfout@std@@YAXXZ"
		size = 60
		refs = "000a __acrt_iob_func 0014 ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAA@XZ 0022 ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 002c atexit 0030 ??__Fwfout@std@@YAXXZ 0034 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 0038 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 01 20 ?? ?? ?? ?? 0A 4D 04 46 28 46 ?? ?? ?? ?? 06 4B 00 22 21 46 28 46 2B 60 ?? ?? ?? ?? 02 48 BD E8 30 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_187_1 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0044 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_187_1 {
	meta:
		name = "??__Fcerr@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0044 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_187_1 {
	meta:
		name = "??__Fclog@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0044 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_187_1 {
	meta:
		name = "??__Fcout@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0044 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_187_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0044 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_187_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0044 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_162_2 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0044 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_187_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0044 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_187_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0044 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_162_2 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0044 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_162_2 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0044 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_187_1 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 72
		refs = "0032 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 003c ??_7ios_base@std@@6B@ 0040 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0044 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 8E 48 0D F1 10 0B 6F 46 6F F0 01 03 C7 E9 00 33 0C 49 0B 68 5A 68 09 4B 53 50 0B 68 5B 68 A3 F1 08 02 0B 44 43 F8 04 2C 04 4B 01 F1 08 00 8B 60 ?? ?? ?? ?? BD E8 8E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_208_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAA_NXZ"
		size = 578
		refs = "0008 __security_push_cookie 003c _guard_check_icall 0058 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 0064 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0198 fwrite 01d2 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 01de _invalid_parameter_noinfo_noreturn 01f8 ??3@YAXPAX@Z 023a __security_pop_cookie"
		altNames = "?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAA_NXZ"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 9C B0 6F 46 82 B0 6F F0 01 03 C7 E9 06 33 00 23 3B 60 83 6B 80 46 00 2B 00 F0 06 81 90 F8 3E 30 00 2B 00 F0 01 81 03 68 4F F6 FF 75 DC 68 20 46 ?? ?? ?? ?? 40 46 29 46 A0 47 A8 42 08 BF 00 24 00 F0 F3 80 17 F1 50 00 00 22 08 21 ?? ?? ?? ?? 17 F1 08 01 17 F1 50 00 ?? ?? ?? ?? 86 68 00 2E 00 F0 E0 80 03 68 3D 1D 00 2B 00 F0 D9 80 1A 68 00 2A 00 F0 D5 80 93 69 10 2B 01 D3 51 68 00 E0 11 1D B1 42 00 F2 CA 80 53 69 0B 44 9E 42 80 F0 C5 80 D7 F8 64 A0 17 F1 20 01 17 F1 50 00 ?? ?? ?? ?? D0 F8 08 90 B9 F1 00 0F 00 F0 B5 80 03 68 00 2B 00 F0 AF 80 1A 68 00 2A 00 F0 AB 80 93 69 10 2B 01 D3 51 68 00 E0 11 1D 49 45 00 F2 A0 80 53 69 0B 44 99 45 80 F0 9B 80 D8 F8 38 40 00 95 23 68 1D 6A 28 46 ?? ?? ?? ?? 20 46 08 F1 40 01 4A 46 0A EB 06 03 A8 47 10 B1 01 28 66 D1 02 E0 00 23 88 F8 3E 30 17 F1 30 01 17 F1 50 00 ?? ?? ?? ?? 84 68 00 2C 79 D0 03 68 00 2B 74 D0 1A 68 00 2A 71 D0 93 69 10 2B 01 D3 51 68 00 E0 11 1D A1 42 67 D8 53 69 0B 44 9C 42 63 D2 7B 68 1C 1B 2A D0 17 F1 40 01 17 F1 50 00 ?? ?? ?? ?? D7 F8 00 90 03 46 98 68 4F F0 01 0A 49 EA 0A 09 C7 F8 00 90 D0 B3 1B 68 B3 B3 1A 68 A2 B3 93 69 10 2B 01 D3 51 68 00 E0 11 1D 81 42 2A D8 53 69 0B 44 98 42 26 D2 D8 F8 4C 30 22 46 01 21 ?? ?? ?? ?? 84 42 05 D0 01 23 04 E0 D7 F8 00 90 4F F0 01 0A 00 23 19 EA 0A 0F 03 D0 29 EA 0A 09 C7 F8 00 90 BB B9 98 F8 3E 30 93 B1 00 2C 7F F4 49 AF 00 22 08 21 17 F1 50 00 ?? ?? ?? ?? 41 E7 03 28 08 D1 05 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 24 00 E0 00 24 BB 6E 10 2B 02 D3 78 6D ?? ?? ?? ?? 0F 23 38 6D BB 66 00 23 7B 66 87 F8 54 30 ?? ?? ?? ?? 12 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 24 20 46 1E B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_20_233_1 {
	meta:
		name = "?_Gndec@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ"
		size = 26
		altNames = "?_Gndec@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 C2 6A 13 68 5B 1C 13 60 C2 69 13 68 98 1E 10 60 BD E8 00 88 }
	condition:
		$1
}

rule file_20_238_1 {
	meta:
		name = "?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
		size = 108
		refs = "0068 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 2A 08 BF 01 23 18 BF 00 23 80 F8 48 30 00 24 03 1D C3 60 00 F1 14 03 C3 61 00 F1 18 03 03 62 00 F1 24 03 C3 62 00 F1 28 03 00 F1 08 02 03 63 80 F8 3E 40 02 61 14 60 03 6A 09 4A 1C 60 03 6B 1C 60 C3 68 1C 60 C3 69 1C 60 C3 6A 1C 60 C1 64 13 68 03 64 53 68 84 63 43 64 BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_238_1 {
	meta:
		name = "?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
		size = 108
		refs = "0068 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 01 2A 08 BF 01 23 18 BF 00 23 80 F8 48 30 00 24 03 1D C3 60 00 F1 14 03 C3 61 00 F1 18 03 03 62 00 F1 24 03 C3 62 00 F1 28 03 00 F1 08 02 03 63 80 F8 3E 40 02 61 14 60 03 6A 09 4A 1C 60 03 6B 1C 60 C3 68 1C 60 C3 69 1C 60 C3 6A 1C 60 C1 64 13 68 03 64 53 68 84 63 43 64 BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_239_1 {
	meta:
		name = "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAPAG0PAH001@Z"
		size = 28
		altNames = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAPAD0PAH001@Z ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPAPA_W0PAH001@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 C1 60 02 99 C2 61 03 9A C3 62 04 9B 01 61 02 62 03 63 BD E8 00 88 }
	condition:
		$1
}

rule file_20_240_1 {
	meta:
		name = "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXXZ"
		size = 68
		altNames = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXXZ ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 1D C3 60 00 F1 14 03 C3 61 00 F1 18 03 03 62 00 F1 24 03 C3 62 00 F1 28 03 00 F1 08 02 00 21 03 63 02 61 11 60 03 6A 19 60 03 6B 19 60 C3 68 19 60 C3 69 19 60 C3 6A 19 60 BD E8 00 88 }
	condition:
		$1
}

rule file_20_243_1 {
	meta:
		name = "?_Init@ios_base@std@@IAAXXZ"
		size = 82
		refs = "0032 ?clear@ios_base@std@@QAAXH_N@Z 0038 ??2@YAPAXI@Z 0042 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 6F F0 01 03 C7 E9 00 33 40 F2 01 23 05 46 6B 61 06 23 00 22 00 21 C5 E9 06 32 C5 E9 0B 22 AA 60 2A 61 C5 E9 08 22 AA 62 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 04 46 24 B1 01 20 ?? ?? ?? ?? 60 60 00 E0 00 24 2C 63 BD E8 BE 88 }
	condition:
		$1
}

rule file_20_246_1 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPBV?$codecvt@GDU_Mbstatet@@@2@@Z"
		size = 98
		refs = "0012 _guard_check_icall"
		altNames = "?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPBV?$codecvt@DDU_Mbstatet@@@2@@Z ?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0E 46 33 68 05 46 DC 68 20 46 ?? ?? ?? ?? 30 46 A0 47 10 B1 00 23 AB 63 1D E0 2B 1D EB 60 05 F1 14 03 EB 61 05 F1 18 03 2B 62 05 F1 24 03 EB 62 05 F1 28 03 05 F1 08 02 00 21 2B 63 AE 63 2A 61 11 60 2B 6A 19 60 2B 6B 19 60 EB 68 19 60 EB 69 19 60 EB 6A 19 60 BD E8 78 88 }
	condition:
		$1
}

rule file_20_265_1 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ"
		size = 42
		altNames = "?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B C4 68 00 F1 3C 02 23 68 93 42 08 D1 D0 E9 14 21 22 60 C3 69 1A 60 8B 1A 5A 10 C3 6A 1A 60 BD E8 18 88 }
	condition:
		$1
}

rule file_20_266_1 {
	meta:
		name = "?_Set_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ"
		size = 56
		altNames = "?_Set_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B C4 68 00 F1 3C 01 23 68 8B 42 07 D0 03 65 C3 6A 1A 68 C3 69 1B 68 03 EB 42 03 43 65 21 60 C3 69 19 60 43 1A 3E 33 5A 10 C3 6A 1A 60 BD E8 18 88 }
	condition:
		$1
}

rule file_20_292_1 {
	meta:
		name = "?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 36
	strings:
		$1 = { 2D E9 00 48 EB 46 83 69 10 2B 01 D3 43 68 00 E0 03 1D 00 22 C1 E9 00 22 8B 60 03 68 08 46 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_20_299_1 {
	meta:
		name = "?clear@ios_base@std@@QAAXH@Z"
		size = 16
		refs = "000c ?clear@ios_base@std@@QAAXH_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_44_1 {
	meta:
		name = "_Cnd_wait"
		size = 16
		refs = "000c ?do_wait@@YAHPAU_Cnd_internal_imp_t@@PAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_301_1 {
	meta:
		name = "?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAAPAV12@XZ"
		size = 50
		refs = "0010 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAA_NXZ 001a fclose 0028 ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 EB 6C 04 46 3B B1 ?? ?? ?? ?? 00 B9 00 24 E8 6C ?? ?? ?? ?? 00 B1 00 24 02 22 00 21 28 46 ?? ?? ?? ?? 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_27_300_1 {
	meta:
		name = "?close@?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAAPAV12@XZ"
		size = 50
		refs = "0010 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAA_NXZ 001a fclose 0028 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 EB 6C 04 46 3B B1 ?? ?? ?? ?? 00 B9 00 24 E8 6C ?? ?? ?? ?? 00 B1 00 24 02 22 00 21 28 46 ?? ?? ?? ?? 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_24_301_1 {
	meta:
		name = "?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAAPAV12@XZ"
		size = 50
		refs = "0010 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAA_NXZ 001a fclose 0028 ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 EB 6C