/**
* @file src/llvmir2hll/semantics/semantics/gcc_general_semantics/get_c_header_file_for_func.cpp
* @brief Implementation of semantics::gcc_general::getCHeaderFileForFunc() for
*        GCCGeneralSemantics.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include "retdec/llvmir2hll/semantics/semantics/gcc_general_semantics/get_c_header_file_for_func.h"
#include "retdec/llvmir2hll/semantics/semantics/impl_support/get_c_header_file_for_func.h"

namespace retdec {
namespace llvmir2hll {
namespace semantics {
namespace gcc_general {

namespace {

/**
* @brief This function is used to initialize FUNC_C_HEADER_MAP later in the
*        file.
*/
const StringStringUMap &initFuncCHeaderMap() {
	static StringStringUMap m;

	//
	// The following list was automatically generated by
	// scripts/gen_getCHeaderFileForFunc.py on 2013-05-09.
	//
	// It has been updated by performing the following changes:
	//
	//  - Removed the mapping of functions from the header files in the "bits"
	//    directory (these cannot be #included manually). Most of such
	//    functions were placed into their corresponding non-"bits" header file.
	//
	//  - All the _IO_* functions from libio.h were moved into stdio.h.
	//

	// aio.h
	static const char *AIO_H_FUNCS[] = {
		"aio_cancel",
		"aio_error",
		"aio_fsync",
		"aio_read",
		"aio_return",
		"aio_suspend",
		"aio_write",
		"lio_listio",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(AIO_H_FUNCS, "aio.h", m);

	// alloca.h
	static const char *ALLOCA_H_FUNCS[] = {
		"alloca",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(ALLOCA_H_FUNCS, "alloca.h", m);

	// arpa/inet.h
	static const char *ARPA_INET_H_FUNCS[] = {
		"inet_addr",
		"inet_aton",
		"inet_lnaof",
		"inet_makeaddr",
		"inet_net_ntop",
		"inet_net_pton",
		"inet_neta",
		"inet_netof",
		"inet_network",
		"inet_nsap_addr",
		"inet_nsap_ntoa",
		"inet_ntoa",
		"inet_ntop",
		"inet_pton",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(ARPA_INET_H_FUNCS, "arpa/inet.h", m);

	// assert.h
	static const char *ASSERT_H_FUNCS[] = {
		"__assert",
		"__assert_fail",
		"__assert_perror_fail",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(ASSERT_H_FUNCS, "assert.h", m);

	// ctype.h
	static const char *CTYPE_H_FUNCS[] = {
		"__ctype_b_loc",
		"__ctype_tolower_loc",
		"__ctype_toupper_loc",
		"__tolower_l",
		"__toupper_l",
		"_tolower",
		"_toupper",
		"isalnum",
		"isalnum_l",
		"isalpha",
		"isalpha_l",
		"isascii",
		"isblank",
		"isblank_l",
		"iscntrl",
		"iscntrl_l",
		"isdigit",
		"isdigit_l",
		"isgraph",
		"isgraph_l",
		"islower",
		"islower_l",
		"isprint",
		"isprint_l",
		"ispunct",
		"ispunct_l",
		"isspace",
		"isspace_l",
		"isupper",
		"isupper_l",
		"isxdigit",
		"isxdigit_l",
		"toascii",
		"tolower",
		"tolower_l",
		"toupper",
		"toupper_l",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(CTYPE_H_FUNCS, "ctype.h", m);

	// dirent.h
	static const char *DIRENT_H_FUNCS[] = {
		"alphasort",
		"closedir",
		"dirfd",
		"fdopendir",
		"getdirentries",
		"opendir",
		"readdir",
		"readdir_r",
		"rewinddir",
		"seekdir",
		"telldir",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(DIRENT_H_FUNCS, "dirent.h", m);

	// dlfcn.h
	static const char *DLFCN_H_FUNCS[] = {
		"dlclose",
		"dlerror",
		"dlopen",
		"dlsym",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(DLFCN_H_FUNCS, "dlfcn.h", m);

	// errno.h
	static const char *ERRNO_H_FUNCS[] = {
		"__errno_location",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(ERRNO_H_FUNCS, "errno.h", m);

	// error.h
	static const char *ERROR_H_FUNCS[] = {
		"__error_alias",
		"__error_at_line_alias",
		"__error_at_line_noreturn",
		"__error_noreturn",
		"error",
		"error_at_line",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(ERROR_H_FUNCS, "error.h", m);

	// fcntl.h
	static const char *FCNTL_H_FUNCS[] = {
		"creat",
		"fcntl",
		"lockf",
		"open",
		"openat",
		"posix_fadvise",
		"posix_fallocate",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(FCNTL_H_FUNCS, "fcntl.h", m);

	// fenv.h
	static const char *FENV_H_FUNCS[] = {
		"feclearexcept",
		"fegetenv",
		"fegetexceptflag",
		"fegetround",
		"feholdexcept",
		"feraiseexcept",
		"fesetenv",
		"fesetexceptflag",
		"fesetround",
		"fetestexcept",
		"feupdateenv",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(FENV_H_FUNCS, "fenv.h", m);

	// fmtmsg.h
	static const char *FMTMSG_H_FUNCS[] = {
		"addseverity",
		"fmtmsg",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(FMTMSG_H_FUNCS, "fmtmsg.h", m);

	// fnmatch.h
	static const char *FNMATCH_H_FUNCS[] = {
		"fnmatch",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(FNMATCH_H_FUNCS, "fnmatch.h", m);

	// ftw.h
	static const char *FTW_H_FUNCS[] = {
		"ftw",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(FTW_H_FUNCS, "ftw.h", m);

	// gdbm.h
	static const char *GDBM_H_FUNCS[] = {
		"gdbm_close",
		"gdbm_delete",
		"gdbm_exists",
		"gdbm_export",
		"gdbm_fdesc",
		"gdbm_fetch",
		"gdbm_firstkey",
		"gdbm_import",
		"gdbm_nextkey",
		"gdbm_reorganize",
		"gdbm_setopt",
		"gdbm_store",
		"gdbm_strerror",
		"gdbm_sync",
		"gdbm_version_cmp",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(GDBM_H_FUNCS, "gdbm.h", m);

	// getopt.h
	static const char *GETOPT_H_FUNCS[] = {
		"getopt",
		"getopt_long",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(GETOPT_H_FUNCS, "getopt.h", m);

	// glob.h
	static const char *GLOB_H_FUNCS[] = {
		"globfree",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(GLOB_H_FUNCS, "glob.h", m);

	// grp.h
	static const char *GRP_H_FUNCS[] = {
		"endgrent",
		"fgetgrent",
		"fgetgrent_r",
		"getgrent",
		"getgrgid",
		"getgrgid_r",
		"getgrnam",
		"getgrnam_r",
		"getgrouplist",
		"initgroups",
		"setgrent",
		"setgroups",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(GRP_H_FUNCS, "grp.h", m);

	// iconv.h
	static const char *ICONV_H_FUNCS[] = {
		"iconv",
		"iconv_close",
		"iconv_open",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(ICONV_H_FUNCS, "iconv.h", m);

	// inttypes.h
	static const char *INTTYPES_H_FUNCS[] = {
		"imaxabs",
		"imaxdiv",
		"strtoimax",
		"strtoumax",
		"wcstoimax",
		"wcstoumax",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(INTTYPES_H_FUNCS, "inttypes.h", m);

	// langinfo.h
	static const char *LANGINFO_H_FUNCS[] = {
		"nl_langinfo",
		"nl_langinfo_l",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(LANGINFO_H_FUNCS, "langinfo.h", m);

	// libgen.h
	static const char *LIBGEN_H_FUNCS[] = {
		"__xpg_basename",
		"dirname",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(LIBGEN_H_FUNCS, "libgen.h", m);

	// libintl.h
	static const char *LIBINTL_H_FUNCS[] = {
		"bindtextdomain",
		"dcgettext",
		"dgettext",
		"gettext",
		"textdomain",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(LIBINTL_H_FUNCS, "libintl.h", m);

	// libio.h
	static const char *LIBIO_H_FUNCS[] = {
		"__overflow",
		"__uflow",
		"__underflow",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(LIBIO_H_FUNCS, "libio.h", m);

	// locale.h
	static const char *LOCALE_H_FUNCS[] = {
		"duplocale",
		"freelocale",
		"localeconv",
		"newlocale",
		"setlocale",
		"uselocale",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(LOCALE_H_FUNCS, "locale.h", m);

	// math.h
	static const char *MATH_H_FUNCS[] = {
		"__acos",
		"__acosf",
		"__acosh",
		"__acoshf",
		"__acoshl",
		"__acosl",
		"__asin",
		"__asinf",
		"__asinh",
		"__asinhf",
		"__asinhl",
		"__asinl",
		"__atan",
		"__atan2",
		"__atan2f",
		"__atan2l",
		"__atanf",
		"__atanh",
		"__atanhf",
		"__atanhl",
		"__atanl",
		"__cbrt",
		"__cbrtf",
		"__cbrtl",
		"__ceil",
		"__ceilf",
		"__ceill",
		"__copysign",
		"__copysignf",
		"__copysignl",
		"__cos",
		"__cosf",
		"__cosh",
		"__coshf",
		"__coshl",
		"__cosl",
		"__drem",
		"__dremf",
		"__dreml",
		"__erf",
		"__erfc",
		"__erfcf",
		"__erfcl",
		"__erff",
		"__erfl",
		"__exp",
		"__exp2",
		"__exp2f",
		"__exp2l",
		"__expf",
		"__expl",
		"__expm1",
		"__expm1f",
		"__expm1l",
		"__fabs",
		"__fabsf",
		"__fabsl",
		"__fdim",
		"__fdimf",
		"__fdiml",
		"__finite",
		"__finitef",
		"__finitel",
		"__floor",
		"__floorf",
		"__floorl",
		"__fma",
		"__fmaf",
		"__fmal",
		"__fmax",
		"__fmaxf",
		"__fmaxl",
		"__fmin",
		"__fminf",
		"__fminl",
		"__fmod",
		"__fmodf",
		"__fmodl",
		"__fpclassify",
		"__fpclassifyf",
		"__fpclassifyl",
		"__frexp",
		"__frexpf",
		"__frexpl",
		"__gamma",
		"__gammaf",
		"__gammal",
		"__hypot",
		"__hypotf",
		"__hypotl",
		"__ilogb",
		"__ilogbf",
		"__ilogbl",
		"__isinf",
		"__isinff",
		"__isinfl",
		"__isnan",
		"__isnanf",
		"__isnanl",
		"__j0",
		"__j0f",
		"__j0l",
		"__j1",
		"__j1f",
		"__j1l",
		"__jn",
		"__jnf",
		"__jnl",
		"__ldexp",
		"__ldexpf",
		"__ldexpl",
		"__lgamma",
		"__lgamma_r",
		"__lgammaf",
		"__lgammaf_r",
		"__lgammal",
		"__lgammal_r",
		"__llrint",
		"__llrintf",
		"__llrintl",
		"__llround",
		"__llroundf",
		"__llroundl",
		"__log",
		"__log10",
		"__log10f",
		"__log10l",
		"__log1p",
		"__log1pf",
		"__log1pl",
		"__log2",
		"__log2f",
		"__log2l",
		"__logb",
		"__logbf",
		"__logbl",
		"__logf",
		"__logl",
		"__lrint",
		"__lrintf",
		"__lrintl",
		"__lround",
		"__lroundf",
		"__lroundl",
		"__modf",
		"__modff",
		"__modfl",
		"__nan",
		"__nanf",
		"__nanl",
		"__nearbyint",
		"__nearbyintf",
		"__nearbyintl",
		"__nextafter",
		"__nextafterf",
		"__nextafterl",
		"__nexttoward",
		"__nexttowardf",
		"__nexttowardl",
		"__pow",
		"__powf",
		"__powl",
		"__remainder",
		"__remainderf",
		"__remainderl",
		"__remquo",
		"__remquof",
		"__remquol",
		"__rint",
		"__rintf",
		"__rintl",
		"__round",
		"__roundf",
		"__roundl",
		"__scalb",
		"__scalbf",
		"__scalbl",
		"__scalbln",
		"__scalblnf",
		"__scalblnl",
		"__scalbn",
		"__scalbnf",
		"__scalbnl",
		"__signbit",
		"__signbitf",
		"__signbitl",
		"__significand",
		"__significandf",
		"__significandl",
		"__sin",
		"__sinf",
		"__sinh",
		"__sinhf",
		"__sinhl",
		"__sinl",
		"__sqrt",
		"__sqrtf",
		"__sqrtl",
		"__tan",
		"__tanf",
		"__tanh",
		"__tanhf",
		"__tanhl",
		"__tanl",
		"__tgamma",
		"__tgammaf",
		"__tgammal",
		"__trunc",
		"__truncf",
		"__truncl",
		"__y0",
		"__y0f",
		"__y0l",
		"__y1",
		"__y1f",
		"__y1l",
		"__yn",
		"__ynf",
		"__ynl",
		"acos",
		"acosf",
		"acosh",
		"acoshf",
		"acoshl",
		"acosl",
		"asin",
		"asinf",
		"asinh",
		"asinhf",
		"asinhl",
		"asinl",
		"atan",
		"atan2",
		"atan2f",
		"atan2l",
		"atanf",
		"atanh",
		"atanhf",
		"atanhl",
		"atanl",
		"cbrt",
		"cbrtf",
		"cbrtl",
		"ceil",
		"ceilf",
		"ceill",
		"copysign",
		"copysignf",
		"copysignl",
		"cos",
		"cosf",
		"cosh",
		"coshf",
		"coshl",
		"cosl",
		"drem",
		"dremf",
		"dreml",
		"erf",
		"erfc",
		"erfcf",
		"erfcl",
		"erff",
		"erfl",
		"exp",
		"exp2",
		"exp2f",
		"exp2l",
		"expf",
		"expl",
		"expm1",
		"expm1f",
		"expm1l",
		"fabs",
		"fabsf",
		"fabsl",
		"fdim",
		"fdimf",
		"fdiml",
		"finite",
		"finitef",
		"finitel",
		"floor",
		"floorf",
		"floorl",
		"fma",
		"fmaf",
		"fmal",
		"fmax",
		"fmaxf",
		"fmaxl",
		"fmin",
		"fminf",
		"fminl",
		"fmod",
		"fmodf",
		"fmodl",
		"frexp",
		"frexpf",
		"frexpl",
		"gamma",
		"gammaf",
		"gammal",
		"hypot",
		"hypotf",
		"hypotl",
		"ilogb",
		"ilogbf",
		"ilogbl",
		"isinf",
		"isinff",
		"isinfl",
		"isnan",
		"isnanf",
		"isnanl",
		"j0",
		"j0f",
		"j0l",
		"j1",
		"j1f",
		"j1l",
		"jn",
		"jnf",
		"jnl",
		"ldexp",
		"ldexpf",
		"ldexpl",
		"lgamma",
		"lgamma_r",
		"lgammaf",
		"lgammaf_r",
		"lgammal",
		"lgammal_r",
		"llrint",
		"llrintf",
		"llrintl",
		"llround",
		"llroundf",
		"llroundl",
		"log",
		"log10",
		"log10f",
		"log10l",
		"log1p",
		"log1pf",
		"log1pl",
		"log2",
		"log2f",
		"log2l",
		"logb",
		"logbf",
		"logbl",
		"logf",
		"logl",
		"lrint",
		"lrintf",
		"lrintl",
		"lround",
		"lroundf",
		"lroundl",
		"matherr",
		"modf",
		"modff",
		"modfl",
		"nan",
		"nanf",
		"nanl",
		"nearbyint",
		"nearbyintf",
		"nearbyintl",
		"nextafter",
		"nextafterf",
		"nextafterl",
		"nexttoward",
		"nexttowardf",
		"nexttowardl",
		"pow",
		"powf",
		"powl",
		"remainder",
		"remainderf",
		"remainderl",
		"remquo",
		"remquof",
		"remquol",
		"rint",
		"rintf",
		"rintl",
		"round",
		"roundf",
		"roundl",
		"scalb",
		"scalbf",
		"scalbl",
		"scalbln",
		"scalblnf",
		"scalblnl",
		"scalbn",
		"scalbnf",
		"scalbnl",
		"significand",
		"significandf",
		"significandl",
		"sin",
		"sinf",
		"sinh",
		"sinhf",
		"sinhl",
		"sinl",
		"sqrt",
		"sqrtf",
		"sqrtl",
		"tan",
		"tanf",
		"tanh",
		"tanhf",
		"tanhl",
		"tanl",
		"tgamma",
		"tgammaf",
		"tgammal",
		"trunc",
		"truncf",
		"truncl",
		"y0",
		"y0f",
		"y0l",
		"y1",
		"y1f",
		"y1l",
		"yn",
		"ynf",
		"ynl",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(MATH_H_FUNCS, "math.h", m);

	// monetary.h
	static const char *MONETARY_H_FUNCS[] = {
		"strfmon",
		"strfmon_l",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(MONETARY_H_FUNCS, "monetary.h", m);

	// mqueue.h
	static const char *MQUEUE_H_FUNCS[] = {
		"mq_close",
		"mq_getattr",
		"mq_notify",
		"mq_open",
		"mq_receive",
		"mq_send",
		"mq_setattr",
		"mq_timedreceive",
		"mq_timedsend",
		"mq_unlink",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(MQUEUE_H_FUNCS, "mqueue.h", m);

	// ndbm.h
	static const char *NDBM_H_FUNCS[] = {
		"dbm_clearerr",
		"dbm_close",
		"dbm_delete",
		"dbm_dirfno",
		"dbm_error",
		"dbm_fetch",
		"dbm_firstkey",
		"dbm_nextkey",
		"dbm_open",
		"dbm_pagfno",
		"dbm_rdonly",
		"dbm_store",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(NDBM_H_FUNCS, "ndbm.h", m);

	// net/if.h
	static const char *NET_IF_H_FUNCS[] = {
		"if_freenameindex",
		"if_indextoname",
		"if_nameindex",
		"if_nametoindex",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(NET_IF_H_FUNCS, "net/if.h", m);

	// netdb.h
	static const char *NETDB_H_FUNCS[] = {
		"__h_errno_location",
		"endhostent",
		"endnetent",
		"endnetgrent",
		"endprotoent",
		"endservent",
		"freeaddrinfo",
		"gai_strerror",
		"getaddrinfo",
		"gethostbyaddr",
		"gethostbyaddr_r",
		"gethostbyname",
		"gethostbyname2",
		"gethostbyname2_r",
		"gethostbyname_r",
		"gethostent",
		"gethostent_r",
		"getnameinfo",
		"getnetbyaddr",
		"getnetbyaddr_r",
		"getnetbyname",
		"getnetbyname_r",
		"getnetent",
		"getnetent_r",
		"getnetgrent",
		"getnetgrent_r",
		"getprotobyname",
		"getprotobyname_r",
		"getprotobynumber",
		"getprotobynumber_r",
		"getprotoent",
		"getprotoent_r",
		"getservbyname",
		"getservbyname_r",
		"getservbyport",
		"getservbyport_r",
		"getservent",
		"getservent_r",
		"herror",
		"hstrerror",
		"innetgr",
		"iruserok",
		"iruserok_af",
		"rcmd",
		"rcmd_af",
		"rexec",
		"rexec_af",
		"rresvport",
		"rresvport_af",
		"ruserok",
		"ruserok_af",
		"sethostent",
		"setnetent",
		"setnetgrent",
		"setprotoent",
		"setservent",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(NETDB_H_FUNCS, "netdb.h", m);

	// netinet/in.h
	static const char *NETINET_IN_H_FUNCS[] = {
		"bindresvport",
		"bindresvport6",
		"htonl",
		"htons",
		"ntohl",
		"ntohs",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(NETINET_IN_H_FUNCS, "netinet/in.h", m);

	// nl_types.h
	static const char *NL_TYPES_H_FUNCS[] = {
		"catclose",
		"catgets",
		"catopen",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(NL_TYPES_H_FUNCS, "nl_types.h", m);

	// pthread.h
	static const char *PTHREAD_H_FUNCS[] = {
		"__pthread_register_cancel",
		"__pthread_unregister_cancel",
		"__pthread_unwind_next",
		"__sigsetjmp",
		"pthread_attr_destroy",
		"pthread_attr_getdetachstate",
		"pthread_attr_getguardsize",
		"pthread_attr_getinheritsched",
		"pthread_attr_getschedparam",
		"pthread_attr_getschedpolicy",
		"pthread_attr_getscope",
		"pthread_attr_getstack",
		"pthread_attr_getstackaddr",
		"pthread_attr_getstacksize",
		"pthread_attr_init",
		"pthread_attr_setdetachstate",
		"pthread_attr_setguardsize",
		"pthread_attr_setinheritsched",
		"pthread_attr_setschedparam",
		"pthread_attr_setschedpolicy",
		"pthread_attr_setscope",
		"pthread_attr_setstack",
		"pthread_attr_setstackaddr",
		"pthread_attr_setstacksize",
		"pthread_barrier_destroy",
		"pthread_barrier_init",
		"pthread_barrier_wait",
		"pthread_barrierattr_destroy",
		"pthread_barrierattr_getpshared",
		"pthread_barrierattr_init",
		"pthread_barrierattr_setpshared",
		"pthread_cancel",
		"pthread_cond_broadcast",
		"pthread_cond_destroy",
		"pthread_cond_init",
		"pthread_cond_signal",
		"pthread_cond_timedwait",
		"pthread_cond_wait",
		"pthread_condattr_destroy",
		"pthread_condattr_getclock",
		"pthread_condattr_getpshared",
		"pthread_condattr_init",
		"pthread_condattr_setclock",
		"pthread_condattr_setpshared",
		"pthread_create",
		"pthread_detach",
		"pthread_equal",
		"pthread_exit",
		"pthread_getcpuclockid",
		"pthread_getschedparam",
		"pthread_getspecific",
		"pthread_join",
		"pthread_key_delete",
		"pthread_kill",
		"pthread_mutex_consistent",
		"pthread_mutex_destroy",
		"pthread_mutex_getprioceiling",
		"pthread_mutex_init",
		"pthread_mutex_lock",
		"pthread_mutex_setprioceiling",
		"pthread_mutex_timedlock",
		"pthread_mutex_trylock",
		"pthread_mutex_unlock",
		"pthread_mutexattr_destroy",
		"pthread_mutexattr_getprioceiling",
		"pthread_mutexattr_getprotocol",
		"pthread_mutexattr_getpshared",
		"pthread_mutexattr_getrobust",
		"pthread_mutexattr_gettype",
		"pthread_mutexattr_init",
		"pthread_mutexattr_setprioceiling",
		"pthread_mutexattr_setprotocol",
		"pthread_mutexattr_setpshared",
		"pthread_mutexattr_setrobust",
		"pthread_mutexattr_settype",
		"pthread_rwlock_destroy",
		"pthread_rwlock_init",
		"pthread_rwlock_rdlock",
		"pthread_rwlock_timedrdlock",
		"pthread_rwlock_timedwrlock",
		"pthread_rwlock_tryrdlock",
		"pthread_rwlock_trywrlock",
		"pthread_rwlock_unlock",
		"pthread_rwlock_wrlock",
		"pthread_rwlockattr_destroy",
		"pthread_rwlockattr_getkind_np",
		"pthread_rwlockattr_getpshared",
		"pthread_rwlockattr_init",
		"pthread_rwlockattr_setkind_np",
		"pthread_rwlockattr_setpshared",
		"pthread_self",
		"pthread_setcancelstate",
		"pthread_setcanceltype",
		"pthread_setschedparam",
		"pthread_setschedprio",
		"pthread_setspecific",
		"pthread_sigmask",
		"pthread_spin_destroy",
		"pthread_spin_init",
		"pthread_spin_lock",
		"pthread_spin_trylock",
		"pthread_spin_unlock",
		"pthread_testcancel",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(PTHREAD_H_FUNCS, "pthread.h", m);

	// pwd.h
	static const char *PWD_H_FUNCS[] = {
		"endpwent",
		"fgetpwent",
		"fgetpwent_r",
		"getpwent",
		"getpwent_r",
		"getpwnam",
		"getpwnam_r",
		"getpwuid",
		"getpwuid_r",
		"putpwent",
		"setpwent",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(PWD_H_FUNCS, "pwd.h", m);

	// regex.h
	static const char *REGEX_H_FUNCS[] = {
		"regcomp",
		"regerror",
		"regexec",
		"regfree",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(REGEX_H_FUNCS, "regex.h", m);

	// rpc/netdb.h
	static const char *RPC_NETDB_H_FUNCS[] = {
		"endrpcent",
		"getrpcbyname",
		"getrpcbyname_r",
		"getrpcbynumber",
		"getrpcbynumber_r",
		"getrpcent",
		"getrpcent_r",
		"setrpcent",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(RPC_NETDB_H_FUNCS, "rpc/netdb.h", m);

	// sched.h
	static const char *SCHED_H_FUNCS[] = {
		"__sched_cpualloc",
		"__sched_cpucount",
		"__sched_cpufree",
		"sched_get_priority_max",
		"sched_get_priority_min",
		"sched_getparam",
		"sched_getscheduler",
		"sched_rr_get_interval",
		"sched_setparam",
		"sched_setscheduler",
		"sched_yield",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SCHED_H_FUNCS, "sched.h", m);

	// search.h
	static const char *SEARCH_H_FUNCS[] = {
		"hcreate",
		"hdestroy",
		"hsearch",
		"insque",
		"lfind",
		"lsearch",
		"remque",
		"tdelete",
		"tfind",
		"tsearch",
		"twalk",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SEARCH_H_FUNCS, "search.h", m);

	// semaphore.h
	static const char *SEMAPHORE_H_FUNCS[] = {
		"sem_close",
		"sem_destroy",
		"sem_getvalue",
		"sem_init",
		"sem_open",
		"sem_post",
		"sem_timedwait",
		"sem_trywait",
		"sem_unlink",
		"sem_wait",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SEMAPHORE_H_FUNCS, "semaphore.h", m);

	// setjmp.h
	static const char *SETJMP_H_FUNCS[] = {
		"__sigsetjmp",
		"_longjmp",
		"_setjmp",
		"longjmp",
		"setjmp",
		"siglongjmp",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SETJMP_H_FUNCS, "setjmp.h", m);

	// signal.h
	static const char *SIGNAL_H_FUNCS[] = {
		"__libc_current_sigrtmax",
		"__libc_current_sigrtmin",
		"__sigaddset",
		"__sigdelset",
		"__sigismember",
		"__sigpause",
		"__sysv_signal",
		"gsignal",
		"kill",
		"killpg",
		"psiginfo",
		"psignal",
		"raise",
		"sigaction",
		"sigaddset",
		"sigaltstack",
		"sigblock",
		"sigdelset",
		"sigemptyset",
		"sigfillset",
		"siggetmask",
		"siginterrupt",
		"sigismember",
		"signal",
		"sigpending",
		"sigprocmask",
		"sigqueue",
		"sigreturn",
		"sigsetmask",
		"sigstack",
		"sigsuspend",
		"sigtimedwait",
		"sigvec",
		"sigwait",
		"sigwaitinfo",
		"ssignal",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SIGNAL_H_FUNCS, "signal.h", m);

	// spawn.h
	static const char *SPAWN_H_FUNCS[] = {
		"posix_spawn",
		"posix_spawn_file_actions_addclose",
		"posix_spawn_file_actions_adddup2",
		"posix_spawn_file_actions_addopen",
		"posix_spawn_file_actions_destroy",
		"posix_spawn_file_actions_init",
		"posix_spawnattr_destroy",
		"posix_spawnattr_getflags",
		"posix_spawnattr_getpgroup",
		"posix_spawnattr_getschedparam",
		"posix_spawnattr_getschedpolicy",
		"posix_spawnattr_getsigdefault",
		"posix_spawnattr_getsigmask",
		"posix_spawnattr_init",
		"posix_spawnattr_setflags",
		"posix_spawnattr_setpgroup",
		"posix_spawnattr_setschedparam",
		"posix_spawnattr_setschedpolicy",
		"posix_spawnattr_setsigdefault",
		"posix_spawnattr_setsigmask",
		"posix_spawnp",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SPAWN_H_FUNCS, "spawn.h", m);

	// stdio.h
	static const char *STDIO_H_FUNCS[] = {
		"_IO_feof",
		"_IO_ferror",
		"_IO_flockfile",
		"_IO_free_backup_area",
		"_IO_ftrylockfile",
		"_IO_funlockfile",
		"_IO_getc",
		"_IO_padn",
		"_IO_peekc_locked",
		"_IO_putc",
		"_IO_seekoff",
		"_IO_seekpos",
		"_IO_sgetn",
		"_IO_vfprintf",
		"_IO_vfscanf",
		"__getdelim",
		"clearerr",
		"clearerr_unlocked",
		"ctermid",
		"dprintf",
		"fclose",
		"fcloseall",
		"fdopen",
		"feof",
		"feof_unlocked",
		"ferror",
		"ferror_unlocked",
		"fflush",
		"fflush_unlocked",
		"fgetc",
		"fgetc_unlocked",
		"fgetpos",
		"fgets",
		"fileno",
		"fileno_unlocked",
		"flockfile",
		"fmemopen",
		"fopen",
		"fprintf",
		"fputc",
		"fputc_unlocked",
		"fputs",
		"fputs_unlocked",
		"fread",
		"fread_unlocked",
		"freopen",
		"fscanf",
		"fseek",
		"fseeko",
		"fsetpos",
		"ftell",
		"ftello",
		"ftrylockfile",
		"funlockfile",
		"fwrite",
		"fwrite_unlocked",
		"getc",
		"getc_unlocked",
		"getchar",
		"getchar_unlocked",
		"getdelim",
		"getline",
		"gets",
		"getw",
		"open_memstream",
		"pclose",
		"perror",
		"popen",
		"printf",
		"putc",
		"putc_unlocked",
		"putchar",
		"putchar_unlocked",
		"puts",
		"putw",
		"remove",
		"rename",
		"renameat",
		"rewind",
		"scanf",
		"setbuf",
		"setbuffer",
		"setlinebuf",
		"setvbuf",
		"snprintf",
		"sprintf",
		"sscanf",
		"tempnam",
		"tmpfile",
		"tmpnam",
		"tmpnam_r",
		"ungetc",
		"vasprintf",
		"vdprintf",
		"vfprintf",
		"vfscanf",
		"vprintf",
		"vscanf",
		"vsnprintf",
		"vsprintf",
		"vsscanf",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(STDIO_H_FUNCS, "stdio.h", m);

	// stdlib.h
	static const char *STDLIB_H_FUNCS[] = {
		"_Exit",
		"__ctype_get_mb_cur_max",
		"a64l",
		"abort",
		"abs",
		"atof",
		"atoi",
		"atol",
		"atoll",
		"bsearch",
		"calloc",
		"cfree",
		"clearenv",
		"div",
		"drand48",
		"drand48_r",
		"ecvt",
		"ecvt_r",
		"erand48",
		"erand48_r",
		"exit",
		"fcvt",
		"fcvt_r",
		"free",
		"gcvt",
		"getenv",
		"getloadavg",
		"getsubopt",
		"initstate",
		"initstate_r",
		"jrand48",
		"jrand48_r",
		"l64a",
		"labs",
		"lcong48",
		"lcong48_r",
		"ldiv",
		"llabs",
		"lldiv",
		"lrand48",
		"lrand48_r",
		"malloc",
		"mblen",
		"mbstowcs",
		"mbtowc",
		"mkdtemp",
		"mkstemp",
		"mkstemps",
		"mktemp",
		"mrand48",
		"mrand48_r",
		"nrand48",
		"nrand48_r",
		"posix_memalign",
		"putenv",
		"qecvt",
		"qecvt_r",
		"qfcvt",
		"qfcvt_r",
		"qgcvt",
		"qsort",
		"rand",
		"rand_r",
		"random",
		"random_r",
		"realloc",
		"realpath",
		"rpmatch",
		"seed48",
		"seed48_r",
		"setenv",
		"setstate",
		"setstate_r",
		"srand",
		"srand48",
		"srand48_r",
		"srandom",
		"srandom_r",
		"strtod",
		"strtof",
		"strtol",
		"strtold",
		"strtoll",
		"strtoq",
		"strtoul",
		"strtoull",
		"strtouq",
		"system",
		"unsetenv",
		"valloc",
		"wcstombs",
		"wctomb",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(STDLIB_H_FUNCS, "stdlib.h", m);

	// string.h
	static const char *STRING_H_FUNCS[] = {
		"__bzero",
		"__stpcpy",
		"__stpncpy",
		"__strtok_r",
		"bcmp",
		"bcopy",
		"bzero",
		"ffs",
		"index",
		"memccpy",
		"memchr",
		"memcmp",
		"memcpy",
		"memmove",
		"memset",
		"rindex",
		"stpcpy",
		"stpncpy",
		"strcasecmp",
		"strcat",
		"strchr",
		"strcmp",
		"strcoll",
		"strcoll_l",
		"strcpy",
		"strcspn",
		"strdup",
		"strerror",
		"strerror_l",
		"strerror_r",
		"strlen",
		"strncasecmp",
		"strncat",
		"strncmp",
		"strncpy",
		"strndup",
		"strnlen",
		"strpbrk",
		"strrchr",
		"strsep",
		"strsignal",
		"strspn",
		"strstr",
		"strtok",
		"strtok_r",
		"strxfrm",
		"strxfrm_l",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(STRING_H_FUNCS, "string.h", m);

	// stropts.h
	static const char *STROPTS_H_FUNCS[] = {
		"fattach",
		"fdetach",
		"getmsg",
		"getpmsg",
		"ioctl",
		"isastream",
		"putmsg",
		"putpmsg",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(STROPTS_H_FUNCS, "stropts.h", m);

	// sys/file.h
	static const char *SYS_FILE_H_FUNCS[] = {
		"flock",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_FILE_H_FUNCS, "sys/file.h", m);

	// sys/ipc.h
	static const char *SYS_IPC_H_FUNCS[] = {
		"ftok",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_IPC_H_FUNCS, "sys/ipc.h", m);

	// sys/mman.h
	static const char *SYS_MMAN_H_FUNCS[] = {
		"madvise",
		"mincore",
		"mlock",
		"mlockall",
		"mmap",
		"mprotect",
		"msync",
		"munlock",
		"munlockall",
		"munmap",
		"posix_madvise",
		"shm_open",
		"shm_unlink",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_MMAN_H_FUNCS, "sys/mman.h", m);

	// sys/msg.h
	static const char *SYS_MSG_H_FUNCS[] = {
		"msgctl",
		"msgget",
		"msgrcv",
		"msgsnd",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_MSG_H_FUNCS, "sys/msg.h", m);

	// sys/poll.h
	static const char *SYS_POLL_H_FUNCS[] = {
		"poll",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_POLL_H_FUNCS, "sys/poll.h", m);

	// sys/prctl.h
	static const char *SYS_PRCTL_H_FUNCS[] = {
		"prctl",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_PRCTL_H_FUNCS, "sys/prctl.h", m);

	// sys/resource.h
	static const char *SYS_RESOURCE_H_FUNCS[] = {
		"getpriority",
		"getrlimit",
		"getrusage",
		"setpriority",
		"setrlimit",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_RESOURCE_H_FUNCS, "sys/resource.h", m);

	// sys/select.h
	static const char *SYS_SELECT_H_FUNCS[] = {
		"pselect",
		"select",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_SELECT_H_FUNCS, "sys/select.h", m);

	// sys/sem.h
	static const char *SYS_SEM_H_FUNCS[] = {
		"semctl",
		"semget",
		"semop",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_SEM_H_FUNCS, "sys/sem.h", m);

	// sys/shm.h
	static const char *SYS_SHM_H_FUNCS[] = {
		"__getpagesize",
		"shmat",
		"shmctl",
		"shmdt",
		"shmget",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_SHM_H_FUNCS, "sys/shm.h", m);

	// sys/socket.h
	static const char *SYS_SOCKET_H_FUNCS[] = {
		"__cmsg_nxthdr",
		"accept",
		"bind",
		"connect",
		"getpeername",
		"getsockname",
		"getsockopt",
		"isfdtype",
		"listen",
		"recv",
		"recvfrom",
		"recvmsg",
		"send",
		"sendmsg",
		"sendto",
		"setsockopt",
		"shutdown",
		"sockatmark",
		"socket",
		"socketpair",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_SOCKET_H_FUNCS, "sys/socket.h", m);

	// sys/stat.h
	static const char *SYS_STAT_H_FUNCS[] = {
		"__fxstat",
		"__fxstatat",
		"__lxstat",
		"__xmknod",
		"__xmknodat",
		"__xstat",
		"chmod",
		"fchmod",
		"fchmodat",
		"fstat",
		"fstatat",
		"futimens",
		"lchmod",
		"lstat",
		"mkdir",
		"mkdirat",
		"mkfifo",
		"mkfifoat",
		"mknod",
		"mknodat",
		"stat",
		"umask",
		"utimensat",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_STAT_H_FUNCS, "sys/stat.h", m);

	// sys/statvfs.h
	static const char *SYS_STATVFS_H_FUNCS[] = {
		"fstatvfs",
		"statvfs",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_STATVFS_H_FUNCS, "sys/statvfs.h", m);

	// sys/syslog.h
	static const char *SYS_SYSLOG_H_FUNCS[] = {
		"closelog",
		"openlog",
		"setlogmask",
		"syslog",
		"vsyslog",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_SYSLOG_H_FUNCS, "sys/syslog.h", m);

	// sys/sysmacros.h
	static const char *SYS_SYSMACROS_H_FUNCS[] = {
		"gnu_dev_major",
		"gnu_dev_makedev",
		"gnu_dev_minor",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_SYSMACROS_H_FUNCS, "sys/sysmacros.h", m);

	// sys/time.h
	static const char *SYS_TIME_H_FUNCS[] = {
		"adjtime",
		"futimes",
		"getitimer",
		"gettimeofday",
		"lutimes",
		"setitimer",
		"settimeofday",
		"utimes",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_TIME_H_FUNCS, "sys/time.h", m);

	// sys/times.h
	static const char *SYS_TIMES_H_FUNCS[] = {
		"times",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_TIMES_H_FUNCS, "sys/times.h", m);

	// sys/uio.h
	static const char *SYS_UIO_H_FUNCS[] = {
		"preadv",
		"pwritev",
		"readv",
		"writev",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_UIO_H_FUNCS, "sys/uio.h", m);

	// sys/utsname.h
	static const char *SYS_UTSNAME_H_FUNCS[] = {
		"uname",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_UTSNAME_H_FUNCS, "sys/utsname.h", m);

	// sys/wait.h
	static const char *SYS_WAIT_H_FUNCS[] = {
		"wait",
		"wait3",
		"wait4",
		"waitid",
		"waitpid",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(SYS_WAIT_H_FUNCS, "sys/wait.h", m);

	// termios.h
	static const char *TERMIOS_H_FUNCS[] = {
		"cfgetispeed",
		"cfgetospeed",
		"cfmakeraw",
		"cfsetispeed",
		"cfsetospeed",
		"cfsetspeed",
		"tcdrain",
		"tcflow",
		"tcflush",
		"tcgetattr",
		"tcgetsid",
		"tcsendbreak",
		"tcsetattr",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(TERMIOS_H_FUNCS, "termios.h", m);

	// time.h
	static const char *TIME_H_FUNCS[] = {
		"asctime",
		"asctime_r",
		"clock",
		"clock_getcpuclockid",
		"clock_getres",
		"clock_gettime",
		"clock_nanosleep",
		"clock_settime",
		"ctime",
		"ctime_r",
		"difftime",
		"dysize",
		"gmtime",
		"gmtime_r",
		"localtime",
		"localtime_r",
		"mktime",
		"nanosleep",
		"stime",
		"strftime",
		"strftime_l",
		"time",
		"timegm",
		"timelocal",
		"timer_create",
		"timer_delete",
		"timer_getoverrun",
		"timer_gettime",
		"timer_settime",
		"tzset",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(TIME_H_FUNCS, "time.h", m);

	// uchar.h
	static const char *UCHAR_H_FUNCS[] = {
		"c16rtomb",
		"c32rtomb",
		"mbrtoc16",
		"mbrtoc32",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(UCHAR_H_FUNCS, "uchar.h", m);

	// ulimit.h
	static const char *ULIMIT_H_FUNCS[] = {
		"ulimit",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(ULIMIT_H_FUNCS, "ulimit.h", m);

	// unistd.h
	static const char *UNISTD_H_FUNCS[] = {
		"__getpgid",
		"_exit",
		"access",
		"acct",
		"alarm",
		"brk",
		"chdir",
		"chown",
		"chroot",
		"close",
		"confstr",
		"daemon",
		"dup",
		"dup2",
		"endusershell",
		"execl",
		"execle",
		"execlp",
		"execv",
		"execve",
		"execvp",
		"faccessat",
		"fchdir",
		"fchown",
		"fchownat",
		"fdatasync",
		"fexecve",
		"fork",
		"fpathconf",
		"fsync",
		"ftruncate",
		"getcwd",
		"getdomainname",
		"getdtablesize",
		"getegid",
		"geteuid",
		"getgid",
		"getgroups",
		"gethostid",
		"gethostname",
		"getlogin",
		"getlogin_r",
		"getpagesize",
		"getpass",
		"getpgid",
		"getpgrp",
		"getpid",
		"getppid",
		"getsid",
		"getuid",
		"getusershell",
		"getwd",
		"isatty",
		"lchown",
		"link",
		"linkat",
		"lseek",
		"nice",
		"pathconf",
		"pause",
		"pipe",
		"pread",
		"profil",
		"pwrite",
		"read",
		"readlink",
		"readlinkat",
		"revoke",
		"rmdir",
		"sbrk",
		"setdomainname",
		"setegid",
		"seteuid",
		"setgid",
		"sethostid",
		"sethostname",
		"setlogin",
		"setpgid",
		"setpgrp",
		"setregid",
		"setreuid",
		"setsid",
		"setuid",
		"setusershell",
		"sleep",
		"symlink",
		"symlinkat",
		"sync",
		"syscall",
		"sysconf",
		"tcgetpgrp",
		"tcsetpgrp",
		"truncate",
		"ttyname",
		"ttyname_r",
		"ttyslot",
		"ualarm",
		"unlink",
		"unlinkat",
		"usleep",
		"vfork",
		"vhangup",
		"write",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(UNISTD_H_FUNCS, "unistd.h", m);

	// utime.h
	static const char *UTIME_H_FUNCS[] = {
		"utime",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(UTIME_H_FUNCS, "utime.h", m);

	// utmpx.h
	static const char *UTMPX_H_FUNCS[] = {
		"endutxent",
		"getutxent",
		"getutxid",
		"getutxline",
		"pututxline",
		"setutxent",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(UTMPX_H_FUNCS, "utmpx.h", m);

	// wchar.h
	static const char *WCHAR_H_FUNCS[] = {
		"__mbrlen",
		"btowc",
		"fgetwc",
		"fgetws",
		"fputwc",
		"fputws",
		"fwide",
		"fwprintf",
		"fwscanf",
		"getwc",
		"getwchar",
		"mbrlen",
		"mbrtowc",
		"mbsinit",
		"mbsnrtowcs",
		"mbsrtowcs",
		"open_wmemstream",
		"putwc",
		"putwchar",
		"swprintf",
		"swscanf",
		"ungetwc",
		"vfwprintf",
		"vfwscanf",
		"vswprintf",
		"vswscanf",
		"vwprintf",
		"vwscanf",
		"wcpcpy",
		"wcpncpy",
		"wcrtomb",
		"wcscasecmp",
		"wcscasecmp_l",
		"wcscat",
		"wcschr",
		"wcscmp",
		"wcscoll",
		"wcscoll_l",
		"wcscpy",
		"wcscspn",
		"wcsdup",
		"wcsftime",
		"wcslen",
		"wcsncasecmp",
		"wcsncasecmp_l",
		"wcsncat",
		"wcsncmp",
		"wcsncpy",
		"wcsnlen",
		"wcsnrtombs",
		"wcspbrk",
		"wcsrchr",
		"wcsrtombs",
		"wcsspn",
		"wcsstr",
		"wcstod",
		"wcstof",
		"wcstok",
		"wcstol",
		"wcstold",
		"wcstoll",
		"wcstoul",
		"wcstoull",
		"wcsxfrm",
		"wcsxfrm_l",
		"wctob",
		"wmemchr",
		"wmemcmp",
		"wmemcpy",
		"wmemmove",
		"wmemset",
		"wprintf",
		"wscanf",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(WCHAR_H_FUNCS, "wchar.h", m);

	// wctype.h
	static const char *WCTYPE_H_FUNCS[] = {
		"iswalnum",
		"iswalnum_l",
		"iswalpha",
		"iswalpha_l",
		"iswblank",
		"iswblank_l",
		"iswcntrl",
		"iswcntrl_l",
		"iswctype",
		"iswctype_l",
		"iswdigit",
		"iswdigit_l",
		"iswgraph",
		"iswgraph_l",
		"iswlower",
		"iswlower_l",
		"iswprint",
		"iswprint_l",
		"iswpunct",
		"iswpunct_l",
		"iswspace",
		"iswspace_l",
		"iswupper",
		"iswupper_l",
		"iswxdigit",
		"iswxdigit_l",
		"towctrans",
		"towctrans_l",
		"towlower",
		"towlower_l",
		"towupper",
		"towupper_l",
		"wctrans",
		"wctrans_l",
		"wctype",
		"wctype_l",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(WCTYPE_H_FUNCS, "wctype.h", m);

	// wordexp.h
	static const char *WORDEXP_H_FUNCS[] = {
		"wordexp",
		"wordfree",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(WORDEXP_H_FUNCS, "wordexp.h", m);

	return m;
}

/// Mapping of function names to their corresponding header files.
const StringStringUMap &FUNC_C_HEADER_MAP(initFuncCHeaderMap());

} // anonymous namespace

/**
* @brief Implements getCHeaderFileForFunc() for GCCGeneralSemantics.
*
* See its description for more details.
*/
std::optional<std::string> getCHeaderFileForFunc(const std::string &funcName) {
	return getCHeaderFileForFuncFromMap(funcName, FUNC_C_HEADER_MAP);
}

} // namespace gcc_general
} // namespace semantics
} // namespace llvmir2hll
} // namespace retdec
