/**
* @file tests/bin2llvmir/optimizations/dsm_generator/tests/dsm_generator_tests.cpp
* @brief Tests for the @c DsmGenerator pass.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include <regex>
#include <sstream>

#include "retdec/bin2llvmir/optimizations/dsm_generator/dsm_generator.h"
#include "bin2llvmir/utils/llvmir_tests.h"

using namespace ::testing;
using namespace llvm;

namespace retdec {
namespace bin2llvmir {
namespace tests {

/**
 * @brief Tests for the @c DsmGenerator pass.
 */
class DsmGeneratorTests: public LlvmIrTests
{
	protected:
		DsmGenerator pass;
};

TEST_F(DsmGeneratorTests, testHeaderGeneration)
{
	parseInput(R"(
		@whatever = global i64 0
	)");
	auto c = Config::fromJsonString(module.get(), R"({
		"architecture" : {
			"bitSize" : 32,
			"endian" : "little",
			"name" : "arm"
		}
	})");
	auto abi = AbiProvider::addAbi(module.get(), &c);
	auto format = createFormat();
	auto image = FileImage(module.get(), std::move(format), &c);

	std::stringstream ret;
	bool b = pass.runOnModuleCustom(*module, &c, &image, abi, ret);

	std::string ref =
R"(^;;
;; This file was generated by the Retargetable Decompiler
;; Website: https://retdec.com
;; Copyright \(c\) 20.. Retargetable Decompiler <info@retdec.com>
;;
;; Decompilation date: ....-..-.. ..:..:..
;; Architecture: arm
;;

;;
;; Code Segment
;;


;;
;; Data Segment
;;
)";

	bool matched = std::regex_search(ret.str(), std::regex(ref));

	EXPECT_FALSE(b);
	EXPECT_TRUE(matched)
			<< "expected:\n" << ref
			<< "\nactual:\n" << ret.str() << "\n";
}

} // namespace tests
} // namespace bin2llvmir
} // namespace retdec
