#include "retdec/utils/dynamic_buffer.h"
#include "retdec/fileformat/file_format/pe/pe_format.h"
#include "retdec/utils/container.h"
#include "retdec/utils/conversion.h"
#include "retdec/utils/scope_exit.h"
#include "retdec/utils/string.h"

/**
 * @file src/fileformat/file_format/pe/pe_dll_list.cpp
 * @brief List of DLL modules for evaluating missing dependencies
 * @copyright (c) 2017 Avast Software, licensed under the MIT license
 */

namespace retdec {
namespace fileformat {

// This list was obtained from Windows 10 build 17763 (Redstone 5)
// Keep it converted to lowerspace for speedup
const std::unordered_set<std::string> PeFormat::defDllList
{
	"7z.dll",
	"aadauthhelper.dll",
	"aadcloudap.dll",
	"aadjcsp.dll",
	"aadtb.dll",
	"aadwamextension.dll",
	"aboutsettingshandlers.dll",
	"abovelockapphost.dll",
	"accessibilitycpl.dll",
	"accountaccessor.dll",
	"accountsrt.dll",
	"acgenral.dll",
	"aclayers.dll",
	"acledit.dll",
	"aclui.dll",
	"acmigration.dll",
	"acpbackgroundmanagerpolicy.dll",
	"acpiservicevna64.dll",
	"acppage.dll",
	"acproxy.dll",
	"acspecfc.dll",
	"actioncenter.dll",
	"actioncentercpl.dll",
	"actionmgr.dll",
	"actionqueue.dll",
	"activationclient.dll",
	"activationmanager.dll",
	"activeds.dll",
	"activesynccsp.dll",
	"activesyncprovider.dll",
	"actxprxy.dll",
	"acwinrt.dll",
	"acwow64.dll",
	"acxtrnal.dll",
	"adaptivecards.dll",
	"addressparser.dll",
	"adhapi.dll",
	"adhsvc.dll",
	"admtmpl.dll",
	"adprovider.dll",
	"adrclient.dll",
	"adsldp.dll",
	"adsldpc.dll",
	"adsmsext.dll",
	"adsnt.dll",
	"adtschema.dll",
	"advancedemojids.dll",
	"advapi32.dll",
	"advapi32res.dll",
	"advpack.dll",
	"aeevts.dll",
	"aeinv.dll",
	"aepic.dll",
	"aertac64.dll",
	"aertar64.dll",
	"ajrouter.dll",
	"alljoyndiscoveryplugin.dll",
	"altspace.dll",
	"amsi.dll",
	"amsiproxy.dll",
	"amstream.dll",
	"analog.shell.broker.dll",
	"analogcommonproxystub.dll",
	"analytics.dll",
	"apds.dll",
	"aphostclient.dll",
	"aphostres.dll",
	"aphostservice.dll",
	"apisethost.appexecutionalias.dll",
	"apisetschema.dll",
	"apmon.dll",
	"appbackgroundtask.dll",
	"appcontracts.dll",
	"appextension.dll",
	"apphelp.dll",
	"apphlpdm.dll",
	"appidapi.dll",
	"appidpolicyengineapi.dll",
	"appidsvc.dll",
	"appinfo.dll",
	"appinfoext.dll",
	"applicationframe.dll",
	"applockercsp.dll",
	"appmanagementconfiguration.dll",
	"appmgmts.dll",
	"appmgr.dll",
	"appmon.dll",
	"appointmentactivation.dll",
	"appointmentapis.dll",
	"appraiser.dll",
	"appreadiness.dll",
	"apprepapi.dll",
	"appresolver.dll",
	"appsruprov.dll",
	"appvcatalog.dll",
	"appvclienteventlog.dll",
	"appvclientps.dll",
	"appventstreamingmanager.dll",
	"appventsubsystemcontroller.dll",
	"appventsubsystems32.dll",
	"appventsubsystems64.dll",
	"appventvirtualization.dll",
	"appverifui.dll",
	"appvetwclientres.dll",
	"appvetwsharedperformance.dll",
	"appvetwstreamingux.dll",
	"appvfilesystemmetadata.dll",
	"appvintegration.dll",
	"appvmanifest.dll",
	"appvorchestration.dll",
	"appvpolicy.dll",
	"appvpublishing.dll",
	"appvreporting.dll",
	"appvscripting.dll",
	"appvsentinel.dll",
	"appvstreamingux.dll",
	"appvstreammap.dll",
	"appvterminator.dll",
	"appxalluserstore.dll",
	"appxapplicabilityblob.dll",
	"appxapplicabilityengine.dll",
	"appxdeploymentclient.dll",
	"appxdeploymentextensions.desktop.dll",
	"appxdeploymentextensions.onecore.dll",
	"appxdeploymentserver.dll",
	"appxpackaging.dll",
	"appxsip.dll",
	"appxstreamingdatasourceps.dll",
	"appxsysprep.dll",
	"archiveint.dll",
	"asferror.dll",
	"aspnet_counters.dll",
	"assignedaccesscsp.dll",
	"assignedaccessmanager.dll",
	"assignedaccessmanagersvc.dll",
	"assignedaccessproviderevents.dll",
	"assignedaccessruntime.dll",
	"assignedaccessshellproxy.dll",
	"asycfilt.dll",
	"atl.dll",
	"atl100.dll",
	"atl110.dll",
	"atlthunk.dll",
	"atmfd.dll",
	"atmlib.dll",
	"audiodev.dll",
	"audioendpointbuilder.dll",
	"audioeng.dll",
	"audiohandlers.dll",
	"audiokse.dll",
	"audiolibvc.dll",
	"audioresourceregistrar.dll",
	"audioses.dll",
	"audiosrv.dll",
	"audiosrvpolicymanager.dll",
	"auditcse.dll",
	"auditnativesnapin.dll",
	"auditpolcore.dll",
	"auditpolicygpinterop.dll",
	"auditpolmsg.dll",
	"authbroker.dll",
	"authbrokerui.dll",
	"authentication.dll",
	"authext.dll",
	"authfwcfg.dll",
	"authfwgp.dll",
	"authfwsnapin.dll",
	"authfwwizfwk.dll",
	"authhostproxy.dll",
	"authui.dll",
	"authz.dll",
	"autopilot.dll",
	"autoplay.dll",
	"autoruns64.dll",
	"avgcorex.dll",
	"avicap32.dll",
	"avifil32.dll",
	"avrt.dll",
	"axinstsv.dll",
	"azroles.dll",
	"azroleui.dll",
	"azsqlext.dll",
	"azuresettingsyncprovider.dll",
	"backgroundmediapolicy.dll",
	"bamsettingsclient.dll",
	"barcodeprovisioningplugin.dll",
	"basecsp.dll",
	"basesrv.dll",
	"batmeter.dll",
	"battc.sys",
	"bcastdvr.proxy.dll",
	"bcastdvrbroker.dll",
	"bcastdvrclient.dll",
	"bcastdvrcommon.dll",
	"bcastdvruserservice.dll",
	"bcd.dll",
	"bcdprov.dll",
	"bcdsrv.dll",
	"bcp47langs.dll",
	"bcp47mrm.dll",
	"bcrypt.dll",
	"bcryptprimitives.dll",
	"bdehdcfglib.dll",
	"bderepair.dll",
	"bdesvc.dll",
	"bdesysprep.dll",
	"bdeui.dll",
	"be.windows.forms.hexbox.dll",
	"bfe.dll",
	"bi.dll",
	"bidispl.dll",
	"bingasds.dll",
	"bingfilterds.dll",
	"bingmaps.dll",
	"bingonlineservices.dll",
	"biocredprov.dll",
	"bisrv.dll",
	"bitlockercsp.dll",
	"bitsigd.dll",
	"bitsperf.dll",
	"bitsproxy.dll",
	"biwinrt.dll",
	"blb_ps.dll",
	"blbevents.dll",
	"blbres.dll",
	"bluetoothapis.dll",
	"bluetoothdesktophandlers.dll",
	"bnmanager.dll",
	"bootmenuux.dll",
	"bootstr.dll",
	"bootux.dll",
	"bootvid.dll",
	"bridgeres.dll",
	"brokerlib.dll",
	"browcli.dll",
	"browser.dll",
	"browserbroker.dll",
	"browsersettingsync.dll",
	"browseui.dll",
	"btagservice.dll",
	"btaudiogatewayclient.dll",
	"bthavctpsvc.dll",
	"bthavrcp.dll",
	"bthavrcpappsvc.dll",
	"bthci.dll",
	"bthmtpcontexthandler.dll",
	"bthpanapi.dll",
	"bthpancontexthandler.dll",
	"bthradiomedia.dll",
	"bthserv.dll",
	"bthtelemetry.dll",
	"btpanui.dll",
	"bwcontexthandler.dll",
	"c_g18030.dll",
	"c_gsm7.dll",
	"c_is2022.dll",
	"c_iscii.dll",
	"cabapi.dll",
	"cabinet.dll",
	"cabview.dll",
	"callbuttons.dll",
	"callbuttons.proxystub.dll",
	"callhistoryclient.dll",
	"cameracaptureui.dll",
	"canonurl.dll",
	"capabilityaccesshandlers.dll",
	"capabilityaccessmanager.dll",
	"capabilityaccessmanagerclient.dll",
	"capauthz.dll",
	"capiprovider.dll",
	"capisp.dll",
	"captureservice.dll",
	"castingshellext.dll",
	"castlaunch.dll",
	"catsrv.dll",
	"catsrvps.dll",
	"catsrvut.dll",
	"cbdhsvc.dll",
	"cca.dll",
	"ccmcore.dll",
	"ccmperf.dll",
	"ccmusrcse.dll",
	"cdd.dll",
	"cdosys.dll",
	"cdp.dll",
	"cdprt.dll",
	"cdpsvc.dll",
	"cdpusersvc.dll",
	"cellularapi.dll",
	"cellulardatacapabilityhandler.dll",
	"cemapi.dll",
	"certca.dll",
	"certcli.dll",
	"certcredprovider.dll",
	"certenc.dll",
	"certenroll.dll",
	"certenrollui.dll",
	"certmgr.dll",
	"certpkicmdlet.dll",
	"certpoleng.dll",
	"certprop.dll",
	"cewmdm.dll",
	"cfgbkend.dll",
	"cfgmgr32.dll",
	"cfgspcellular.dll",
	"cfgsppolicy.dll",
	"cflapi.dll",
	"cfmifs.dll",
	"cfmifsproxy.dll",
	"ci.dll",
	"cic.dll",
	"cimwin32.dll",
	"circoinst.dll",
	"ciwmi.dll",
	"class2.sys",
	"classpnp.sys",
	"clb.dll",
	"clbcatq.dll",
	"cldapi.dll",
	"cleanpccsp.dll",
	"clfsw32.dll",
	"cliconfg.dll",
	"clipboardserver.dll",
	"clipc.dll",
	"clipsvc.dll",
	"cloudap.dll",
	"cloudbackupsettings.dll",
	"clouddomainjoinaug.dll",
	"clouddomainjoindatamodelserver.dll",
	"cloudexperiencehost.dll",
	"cloudexperiencehostbroker.dll",
	"cloudexperiencehostcommon.dll",
	"cloudexperiencehostuser.dll",
	"clrhost.dll",
	"clusapi.dll",
	"cmcfg32.dll",
	"cmdext.dll",
	"cmdial32.dll",
	"cmgrcspps.dll",
	"cmifw.dll",
	"cmintegrator.dll",
	"cmlua.dll",
	"cmpbk32.dll",
	"cmstplua.dll",
	"cmutil.dll",
	"cng.sys",
	"cngcredui.dll",
	"cngprovider.dll",
	"cnvfat.dll",
	"cofiredm.dll",
	"colbact.dll",
	"coloradapterclient.dll",
	"colorcnv.dll",
	"colorui.dll",
	"combase.dll",
	"comcat.dll",
	"comctl32.dll",
	"comdlg32.dll",
	"coml2.dll",
	"compobj.dll",
	"composableshellproxystub.dll",
	"composerframework.dll",
	"comppkgsup.dll",
	"compstui.dll",
	"computecore.dll",
	"computelibeventlog.dll",
	"computenetwork.dll",
	"computestorage.dll",
	"comrepl.dll",
	"comres.dll",
	"comsnap.dll",
	"comsvcs.dll",
	"comuid.dll",
	"concrt140.dll",
	"concrt140d.dll",
	"coneqmsapoguilibrary.dll",
	"configmanager2.dll",
	"configureexpandedstorage.dll",
	"conhostv1.dll",
	"connect.dll",
	"connectedaccountstate.dll",
	"consentexperiencecommon.dll",
	"consentux.dll",
	"consentuxclient.dll",
	"console.dll",
	"consolelogon.dll",
	"constraintindex.search.dll",
	"contactactivation.dll",
	"contactapis.dll",
	"contactharvesterds.dll",
	"container.dll",
	"contentdeliverymanager.utilities.dll",
	"coreaudiopolicymanagerext.dll",
	"coredpus.dll",
	"coremessaging.dll",
	"coremmres.dll",
	"coreshell.dll",
	"coreshellapi.dll",
	"coreshellextframework.dll",
	"coreuicomponents.dll",
	"correngine.dll",
	"cortana.persona.dll",
	"cortanamapihelper.dll",
	"cortanamapihelper.proxystub.dll",
	"courtesyengine.dll",
	"cpfilters.dll",
	"creddialogbroker.dll",
	"credentialmigrationhandler.dll",
	"credprov2fahelper.dll",
	"credprovdatamodel.dll",
	"credprovhelper.dll",
	"credprovhost.dll",
	"credprovs.dll",
	"credprovslegacy.dll",
	"credssp.dll",
	"credui.dll",
	"crtdll.dll",
	"crypt32.dll",
	"cryptbase.dll",
	"cryptcatsvc.dll",
	"cryptdlg.dll",
	"cryptdll.dll",
	"cryptext.dll",
	"cryptnet.dll",
	"cryptngc.dll",
	"cryptowinrt.dll",
	"cryptsp.dll",
	"cryptsvc.dll",
	"crypttpmeksvc.dll",
	"cryptui.dll",
	"cryptuiwizard.dll",
	"cryptxml.dll",
	"cscapi.dll",
	"cscdll.dll",
	"cscmig.dll",
	"cscobj.dll",
	"cscsvc.dll",
	"cscui.dll",
	"cspcellularsettings.dll",
	"csplte.dll",
	"cspproxy.dll",
	"csrsrv.dll",
	"csystemeventsbrokerclient.dll",
	"ctl3d32.dll",
	"cuzzapi.dll",
	"cxcredprov.dll",
	"cxhprovisioningserver.dll",
	"d2d1.dll",
	"d2d1debug2.dll",
	"d2d1debug3.dll",
	"d3d9.dll",
	"d3dx9_26.dll",
	"d3d10.dll",
	"d3d10_1.dll",
	"d3d10_1core.dll",
	"d3d10core.dll",
	"d3d10level9.dll",
	"d3d10ref.dll",
	"d3d10sdklayers.dll",
	"d3d10warp.dll",
	"d3d11.dll",
	"d3d11_1sdklayers.dll",
	"d3d11_2sdklayers.dll",
	"d3d11_3sdklayers.dll",
	"d3d11on12.dll",
	"d3d11ref.dll",
	"d3d11sdklayers.dll",
	"d3d12.dll",
	"d3d12sdklayers.dll",
	"d3d8.dll",
	"d3d8thk.dll",
	"d3d9.dll",
	"d3d9on12.dll",
	"d3dcompiler_47.dll",
	"d3dcompiler_47.dll",
	"d3dim.dll",
	"d3dim700.dll",
	"d3dramp.dll",
	"d3dref9.dll",
	"d3dscache.dll",
	"d3dx9_26.dll",
	"d3dxof.dll",
	"dab.dll",
	"dabapi.dll",
	"daconn.dll",
	"dafaspinfraprovider.dll",
	"dafbth.dll",
	"dafcdp.dll",
	"dafdnssd.dll",
	"dafdockingprovider.dll",
	"dafgip.dll",
	"dafiot.dll",
	"dafipp.dll",
	"dafpos.dll",
	"dafprintprovider.dll",
	"dafupnp.dll",
	"dafwcn.dll",
	"dafwfdprovider.dll",
	"dafwiprov.dll",
	"dafwsd.dll",
	"damediamanager.dll",
	"damm.dll",
	"daotpcredentialprovider.dll",
	"das.dll",
	"dataclen.dll",
	"dataexchange.dll",
	"datamarketsvc.dll",
	"datausagehandlers.dll",
	"datusage.dll",
	"davclnt.dll",
	"davhlpr.dll",
	"davsyncprovider.dll",
	"daxexec.dll",
	"dbgcore.dll",
	"dbgeng.dll",
	"dbghelp.dll",
	"dbgmodel.dll",
	"dbnetlib.dll",
	"dbnmpntw.dll",
	"dciman32.dll",
	"dcntel.dll",
	"dcomp.dll",
	"ddaclsys.dll",
	"ddcantitheftapi.dll",
	"ddcclaimsapi.dll",
	"ddccomimplementationsdesktop.dll",
	"ddcwnslistener.dll",
	"ddds.dll",
	"ddisplay.dll",
	"ddoiproxy.dll",
	"ddores.dll",
	"ddp_ps.dll",
	"ddpa64.dll",
	"ddpd64a.dll",
	"ddpchunk.dll",
	"ddpo64a.dll",
	"ddpp64a.dll",
	"ddptrace.dll",
	"ddputils.dll",
	"ddraw.dll",
	"ddrawex.dll",
	"defaultdevicemanager.dll",
	"defaultprinterprovider.dll",
	"defragproxy.dll",
	"defragres.dll",
	"defragsvc.dll",
	"delegatorprovider.dll",
	"deskadp.dll",
	"deskmon.dll",
	"desktopshellappstatecontract.dll",
	"desktopshellext.dll",
	"desktopswitcherdatamodel.dll",
	"desktopview.internal.broker.dll",
	"desktopview.internal.broker.proxystub.dll",
	"devdispitemprovider.dll",
	"developeroptionssettingshandlers.dll",
	"devenum.dll",
	"deviceaccess.dll",
	"deviceassociation.dll",
	"devicecenter.dll",
	"devicecredential.dll",
	"devicedirectoryclient.dll",
	"devicedisplaystatusmanager.dll",
	"devicedriverretrievalclient.dll",
	"deviceelementsource.dll",
	"deviceflows.datamodel.dll",
	"devicemetadataretrievalclient.dll",
	"devicengccredprov.dll",
	"devicepairing.dll",
	"devicepairingexperiencemem.dll",
	"devicepairingfolder.dll",
	"devicepairingproxy.dll",
	"devicereactivation.dll",
	"deviceregistration.dll",
	"devicesetupmanager.dll",
	"devicesetupmanagerapi.dll",
	"devicesetupstatusprovider.dll",
	"devicesflowbroker.dll",
	"devicesoftwareinstallationclient.dll",
	"deviceupdateagent.dll",
	"deviceuxres.dll",
	"devinv.dll",
	"devmgr.dll",
	"devobj.dll",
	"devpropmgr.dll",
	"devquerybroker.dll",
	"devrtl.dll",
	"dfdts.dll",
	"dfscli.dll",
	"dfshim.dll",
	"dfsshlex.dll",
	"dggpext.dll",
	"dhcpcmonitor.dll",
	"dhcpcore.dll",
	"dhcpcore6.dll",
	"dhcpcsvc.dll",
	"dhcpcsvc6.dll",
	"dhcpsapi.dll",
	"dholographicdisplay.dll",
	"diagcpl.dll",
	"diagnosticinvoker.dll",
	"diagnosticlogcsp.dll",
	"diagperf.dll",
	"diagsvc.dll",
	"diagtrack.dll",
	"dialclient.dll",
	"dialserver.dll",
	"dictationmanager.dll",
	"difxapi.dll",
	"dimsjob.dll",
	"dimsroam.dll",
	"dinput.dll",
	"dinput8.dll",
	"direct2ddesktop.dll",
	"directmanipulation.dll",
	"directml.dll",
	"discan.dll",
	"dismapi.dll",
	"dispbroker.dll",
	"dispex.dll",
	"display.dll",
	"displaymanager.dll",
	"dlnashext.dll",
	"dmalertlistener.proxystub.dll",
	"dmapisetextimpldesktop.dll",
	"dmappsres.dll",
	"dmband.dll",
	"dmcfgutils.dll",
	"dmcmnutils.dll",
	"dmcommandlineutils.dll",
	"dmcompos.dll",
	"dmcsps.dll",
	"dmdlgs.dll",
	"dmdskmgr.dll",
	"dmdskres.dll",
	"dmdskres2.dll",
	"dmenrollengine.dll",
	"dmenterprisediagnostics.dll",
	"dmime.dll",
	"dmintf.dll",
	"dmiso8601utils.dll",
	"dml.dll",
	"dmloader.dll",
	"dmocx.dll",
	"dmoleaututils.dll",
	"dmprocessxmlfiltered.dll",
	"dmpushproxy.dll",
	"dmpushroutercore.dll",
	"dmrcdecoder.dll",
	"dmrserver.dll",
	"dmscript.dll",
	"dmstyle.dll",
	"dmsynth.dll",
	"dmusic.dll",
	"dmutil.dll",
	"dmvdsitf.dll",
	"dmwappushsvc.dll",
	"dmwmibridgeprov.dll",
	"dmwmibridgeprov1 (1).dll",
	"dmwmibridgeprov1.dll",
	"dmwmicsp.dll",
	"dmxmlhelputils.dll",
	"dnsapi.dll",
	"dnsclientcim.dll",
	"dnsclientpsprovider.dll",
	"dnscmmc.dll",
	"dnsext.dll",
	"dnshc.dll",
	"dnsrslvr.dll",
	"docking.virtualinput.dll",
	"dockinterface.proxystub.dll",
	"docprop.dll",
	"documentperformanceevents.dll",
	"dolbydecmft.dll",
	"dolbyhrtfenc.dll",
	"dolbymatenc.dll",
	"domgmt.dll",
	"dosettings.dll",
	"dosvc.dll",
	"dot3api.dll",
	"dot3cfg.dll",
	"dot3conn.dll",
	"dot3dlg.dll",
	"dot3gpclnt.dll",
	"dot3gpui.dll",
	"dot3hc.dll",
	"dot3mm.dll",
	"dot3msm.dll",
	"dot3svc.dll",
	"dot3ui.dll",
	"dpapi.dll",
	"dpapiprovider.dll",
	"dpapisrv.dll",
	"dplayx.dll",
	"dpmodemx.dll",
	"dpnaddr.dll",
	"dpnathlp.dll",
	"dpnet.dll",
	"dpnhpast.dll",
	"dpnhupnp.dll",
	"dpnlobby.dll",
	"dps.dll",
	"dpwsockx.dll",
	"dpx.dll",
	"dragdropexperiencecommon.dll",
	"dragdropexperiencedataexchangedelegated.dll",
	"drmk.sys",
	"drprov.dll",
	"drt.dll",
	"drtprov.dll",
	"drttransport.dll",
	"drvsetup.dll",
	"drvstore.dll",
	"dsauth.dll",
	"dsccore.dll",
	"dsccoreconfprov.dll",
	"dsclient.dll",
	"dscproxy.dll",
	"dscpspluginwkr.dll",
	"dsctimer.dll",
	"dsdmo.dll",
	"dskquota.dll",
	"dskquoui.dll",
	"dsound.dll",
	"dsparse.dll",
	"dsprop.dll",
	"dsprov.dll",
	"dsquery.dll",
	"dsreg.dll",
	"dsrole.dll",
	"dssec.dll",
	"dssenh.dll",
	"dssvc.dll",
	"dsui.dll",
	"dsuiext.dll",
	"dswave.dll",
	"dtsbassenhancementdll64.dll",
	"dtsboostdll64.dll",
	"dtsgaincompensatordll64.dll",
	"dtsgfxapo64.dll",
	"dtsgfxapons64.dll",
	"dtsh.dll",
	"dtslfxapo64.dll",
	"dtslimiterdll64.dll",
	"dtsneopcdll64.dll",
	"dtss2headphonedll64.dll",
	"dtss2speakerdll64.dll",
	"dtssymmetrydll64.dll",
	"dtsu2pgfx64.dll",
	"dtsu2plfx64.dll",
	"dtsu2prec64.dll",
	"dtsvoiceclaritydll64.dll",
	"dtuhandlerps.dll",
	"ducsps.dll",
	"dui70.dll",
	"duser.dll",
	"dusmapi.dll",
	"dusmsvc.dll",
	"dwmapi.dll",
	"dwmcore.dll",
	"dwmghost.dll",
	"dwminit.dll",
	"dwmredir.dll",
	"dwrite.dll",
	"dxapi.sys",
	"dxcapturereplay.dll",
	"dxdiagn.dll",
	"dxgi.dll",
	"dxgidebug.dll",
	"dxgkrnl.sys",
	"dxgwdi.dll",
	"dxilconv.dll",
	"dxmasf.dll",
	"dxp.dll",
	"dxpps.dll",
	"dxptasksync.dll",
	"dxtmsft.dll",
	"dxtoolsmonitor.dll",
	"dxtoolsofflineanalysis.dll",
	"dxtoolsreportgenerator.dll",
	"dxtoolsreporting.dll",
	"dxtrans.dll",
	"dxva2.dll",
	"dynamoapi.dll",
	"e1dmsg.dll",
	"eamprogresshandler.dll",
	"eapp3hst.dll",
	"eappcfg.dll",
	"eappcfgui.dll",
	"eappgnui.dll",
	"eapphost.dll",
	"eappprxy.dll",
	"eapprovp.dll",
	"eapsimextdesktop.dll",
	"eapsvc.dll",
	"easconsent.dll",
	"easinvoker.proxystub.dll",
	"easpolicymanagerbrokerps.dll",
	"easwrt.dll",
	"easylogin.dll",
	"edgeangle.dll",
	"edgecontent.dll",
	"edgehtml.dll",
	"edgeiso.dll",
	"edgemanager.dll",
	"editbuffertesthook.dll",
	"editionupgradehelper.dll",
	"editionupgrademanagerobj.dll",
	"edpauditapi.dll",
	"edpcsp.dll",
	"edptask.dll",
	"edputil.dll",
	"eeprov.dll",
	"eeutil.dll",
	"efsadu.dll",
	"efscore.dll",
	"efsext.dll",
	"efslsaext.dll",
	"efssvc.dll",
	"efsutil.dll",
	"efswrt.dll",
	"ehstorapi.dll",
	"ehstorpwdmgr.dll",
	"ehstorshell.dll",
	"els.dll",
	"elscore.dll",
	"elshyph.dll",
	"elslad.dll",
	"elstrans.dll",
	"emailapis.dll",
	"embeddedlockdownwmi.dll",
	"embeddedmodesvc.dll",
	"embeddedmodesvcapi.dll",
	"emojids.dll",
	"encapi.dll",
	"encdump.dll",
	"energy.dll",
	"energyprov.dll",
	"energytask.dll",
	"enrollmentapi.dll",
	"enterpriseapncsp.dll",
	"enterpriseappmgmtclient.dll",
	"enterpriseappmgmtsvc.dll",
	"enterpriseappvmgmtcsp.dll",
	"enterprisecsps.dll",
	"enterprisedesktopappmgmtcsp.dll",
	"enterpriseetw.dll",
	"enterprisemodernappmgmtcsp.dll",
	"enterpriseresourcemanager.dll",
	"eqossnap.dll",
	"errordetails.dll",
	"errordetailscore.dll",
	"es.dll",
	"esdsip.dll",
	"esent.dll",
	"esentprf.dll",
	"esevss.dll",
	"eshims.dll",
	"esscli.dll",
	"ethernetmediamanager.dll",
	"etwcoreuicomponentsresources.dll",
	"etweseproviderresources.dll",
	"etwrundown.dll",
	"euiccscsp.dll",
	"eventaggregation.dll",
	"eventcls.dll",
	"eventtracingmanagement.dll",
	"evr.dll",
	"execmodelclient.dll",
	"execmodelproxy.dll",
	"explorerframe.dll",
	"expsrv.dll",
	"exsmime.dll",
	"extrasxmlparser.dll",
	"f3ahvoas.dll",
	"facecredentialprovider.dll",
	"faceprocessor.dll",
	"faceprocessorcore.dll",
	"facetrackerinternal.dll",
	"family.authentication.dll",
	"family.cache.dll",
	"family.client.dll",
	"family.syncengine.dll",
	"familysafetyext.dll",
	"fastprox.dll",
	"faultrep.dll",
	"faxprinterinstaller.dll",
	"fcon.dll",
	"fdbth.dll",
	"fdbthproxy.dll",
	"fddevquery.dll",
	"fde.dll",
	"fdeploy.dll",
	"fdphost.dll",
	"fdpnp.dll",
	"fdprint.dll",
	"fdproxy.dll",
	"fdrespub.dll",
	"fdssdp.dll",
	"fdwcn.dll",
	"fdwnet.dll",
	"fdwsd.dll",
	"feclient.dll",
	"ffbroker.dll",
	"ffmpeg.dll",
	"fhcat.dll",
	"fhcfg.dll",
	"fhcleanup.dll",
	"fhcpl.dll",
	"fhengine.dll",
	"fhevents.dll",
	"fhlisten.dll",
	"fhsettingsprovider.dll",
	"fhshl.dll",
	"fhsrchapi.dll",
	"fhsrchph.dll",
	"fhsvc.dll",
	"fhsvcctl.dll",
	"fhtask.dll",
	"fhuxadapter.dll",
	"fhuxapi.dll",
	"fhuxcommon.dll",
	"fhuxgraphics.dll",
	"fhuxpresentation.dll",
	"fidocredprov.dll",
	"fileappxstreamingdatasource.dll",
	"filemgmt.dll",
	"filterds.dll",
	"findnetprinters.dll",
	"fingerprintcredential.dll",
	"firewallapi.dll",
	"firewallcontrolpanel.dll",
	"flightsettings.dll",
	"fltlib.dll",
	"fltmgr.sys",
	"fluencyds.dll",
	"fm20.dll",
	"fm20enu.dll",
	"fmapi.dll",
	"fmapo64.dll",
	"fmifs.dll",
	"fms.dll",
	"fntcache.dll",
	"fontext.dll",
	"fontglyphanimator.dll",
	"fontgroupsoverride.dll",
	"fontprovider.dll",
	"fontsub.dll",
	"fphc.dll",
	"framedyn.dll",
	"framedynos.dll",
	"frameserver.dll",
	"frameworkperf.dll",
	"frameworkperf.dll",
	"frprov.dll",
	"fsclient.dll",
	"fsutilext.dll",
	"fthsvc.dll",
	"fundisc.dll",
	"fveapi.dll",
	"fveapibase.dll",
	"fvecerts.dll",
	"fvecpl.dll",
	"fveskybackup.dll",
	"fveui.dll",
	"fvewiz.dll",
	"fwbase.dll",
	"fwcfg.dll",
	"fwmdmcsp.dll",
	"fwpkclnt.sys",
	"fwpolicyiomgr.dll",
	"fwpuclnt.dll",
	"fwremotesvr.dll",
	"fxcompchannel_x64.dll",
	"fxsapi.dll",
	"fxscom.dll",
	"fxscomex.dll",
	"fxscompose.dll",
	"fxscomposeres.dll",
	"fxsevent.dll",
	"fxsext32.dll",
	"fxsmon.dll",
	"fxsresm.dll",
	"fxsroute.dll",
	"fxsst.dll",
	"fxst30.dll",
	"fxstiff.dll",
	"fxsutility.dll",
	"fxsxp32.dll",
	"ga.analytics.monitor.dll",
	"gamebarpresencewriter.proxy.dll",
	"gamechatoverlayext.dll",
	"gamechattranscription.dll",
	"gamemode.dll",
	"gamemonitor.dll",
	"gamepanelexternalhook.dll",
	"gameux.dll",
	"gamingtcui.dll",
	"gcdef.dll",
	"gdi32.dll",
	"gdi32full.dll",
	"gdiplus.dll",
	"generaltel.dll",
	"geocommon.dll",
	"geolocation.dll",
	"getuname.dll",
	"gflagsui.dll",
	"glmf32.dll",
	"globcollationhost.dll",
	"globinputhost.dll",
	"glu32.dll",
	"gmsaclient.dll",
	"gnsdk_fp.dll",
	"gpapi.dll",
	"gpedit.dll",
	"gpprefcl.dll",
	"gpprnext.dll",
	"gpscript.dll",
	"gpsvc.dll",
	"gptext.dll",
	"graphicscapture.dll",
	"graphicsperfsvc.dll",
	"groupinghc.dll",
	"hal.dll",
	"halextintclpiodma.dll",
	"halextpl080.dll",
	"hascsp.dll",
	"hashtagds.dll",
	"hbaapi.dll",
	"hcproviders.dll",
	"hdcphandler.dll",
	"headtrackerstorage.dll",
	"heatcore.dll",
	"helppaneproxy.dll",
	"hgcpl.dll",
	"hgprint.dll",
	"hha.dll",
	"hhsetup.dll",
	"hid.dll",
	"hidparse.sys",
	"hidserv.dll",
	"hlink.dll",
	"hmkd.dll",
	"hnetcfg.dll",
	"hnetcfgclient.dll",
	"hnetmon.dll",
	"hologramcompositor.dll",
	"hologramworld.dll",
	"holographicextensions.dll",
	"holographicruntimes.dll",
	"holoshellruntime.dll",
	"holoshextensions.dll",
	"holosi.pcshell.dll",
	"hotplug.dll",
	"hpbmiapi.dll",
	"hpboid.dll",
	"hpboidps.dll",
	"hpbpro.dll",
	"hpbprops.dll",
	"hpbwsdr.dll",
	"hpcc3175.dll",
	"hpcc3196.dll",
	"hpcc3220.dll",
	"hpcdmc32.dll",
	"hpcjpm.dll",
	"hpcpn175.dll",
	"hpcpn196.dll",
	"hpcpn220.dll",
	"hplbddrv.dll",
	"hpmco175.dll",
	"hpmco196.dll",
	"hpmco220.dll",
	"hpmja175.dll",
	"hpmja196.dll",
	"hpmja220.dll",
	"hpmlm135.dll",
	"hpmlm190.dll",
	"hpmml175.dll",
	"hpmml196.dll",
	"hpmml220.dll",
	"hpmpm081.dll",
	"hpmpm082.dll",
	"hpmprein.dll",
	"hpmpw081.dll",
	"hpmpw082.dll",
	"hpmtp175.dll",
	"hpmtp196.dll",
	"hpmtp220.dll",
	"hppccompio.dll",
	"hppdcompio.dll",
	"hpzidr12.dll",
	"hpzinw12.dll",
	"hpzipm12.dll",
	"hpzipr12.dll",
	"hpzipt12.dll",
	"hpzisn12.dll",
	"hrtfapo.dll",
	"httpapi.dll",
	"httpprxc.dll",
	"httpprxm.dll",
	"httpprxp.dll",
	"httpsdatasource.dll",
	"htui.dll",
	"hvhostsvc.dll",
	"hvloader.dll",
	"hvsicontainerservice.dll",
	"hvsigpext.dll",
	"hvsocket.dll",
	"hydrogen.dll",
	"chakra.dll",
	"chakradiag.dll",
	"chakrathunk.dll",
	"chartv.dll",
	"chatapis.dll",
	"chkwudrv.dll",
	"chsstrokeds.dll",
	"chtadvancedds.dll",
	"chtbopomofods.dll",
	"chtcangjieds.dll",
	"chthkstrokeds.dll",
	"chtquickds.dll",
	"chxapds.dll",
	"chxdecoder.dll",
	"chxhapds.dll",
	"chxinputrouter.dll",
	"chxranker.dll",
	"chxreadingstringime.dll",
	"ias.dll",
	"iasacct.dll",
	"iasads.dll",
	"iasdatastore.dll",
	"iashlpr.dll",
	"iasmigplugin.dll",
	"iasnap.dll",
	"iaspolcy.dll",
	"iasrad.dll",
	"iasrecst.dll",
	"iassam.dll",
	"iassdo.dll",
	"iassvcs.dll",
	"iccvid.dll",
	"icfupgd.dll",
	"icm32.dll",
	"icmp.dll",
	"icmui.dll",
	"iconcodecservice.dll",
	"icsigd.dll",
	"icsvc.dll",
	"icsvcext.dll",
	"icuin.dll",
	"icuuc.dll",
	"idctrls.dll",
	"idlisten.dll",
	"idndl.dll",
	"idstore.dll",
	"ieadvpack.dll",
	"ieapfltr.dll",
	"iedkcs32.dll",
	"ieframe.dll",
	"iemigplugin.dll",
	"iepeers.dll",
	"ieproxy.dll",
	"iernonce.dll",
	"iertutil.dll",
	"iesetup.dll",
	"iesysprep.dll",
	"ieui.dll",
	"ifmon.dll",
	"ifsutil.dll",
	"ifsutilx.dll",
	"igddiag.dll",
	"ihds.dll",
	"ihvrilproxy.dll",
	"ikeext.dll",
	"imagehlp.dll",
	"imageres.dll",
	"imagesp1.dll",
	"imapi.dll",
	"imapi2.dll",
	"imapi2fs.dll",
	"imgutil.dll",
	"imm32.dll",
	"implatsetup.dll",
	"indexeddblegacy.dll",
	"indexeddbserver.dll",
	"inetcomm.dll",
	"inetmib1.dll",
	"inetpp.dll",
	"inetppui.dll",
	"inetres.dll",
	"inkanalysislegacycom.dll",
	"inked.dll",
	"inkobjcore.dll",
	"inproclogger.dll",
	"input.dll",
	"inputcontroller.dll",
	"inputhost.dll",
	"inputinjectionbroker.dll",
	"inputlocalemanager.dll",
	"inputservice.dll",
	"inputswitch.dll",
	"inseng.dll",
	"installservice.dll",
	"installservicetasks.dll",
	"internetmail.dll",
	"internetmailcsp.dll",
	"invagent.dll",
	"iologmsg.dll",
	"iotassignedaccesslockframework.dll",
	"ipeloggingdictationhelper.dll",
	"iphlpapi.dll",
	"iphlpsvc.dll",
	"ipmiprr.dll",
	"ipmiprv.dll",
	"ipnathlp.dll",
	"ipnathlpclient.dll",
	"ippmon.dll",
	"iprop.dll",
	"iprtprio.dll",
	"iprtrmgr.dll",
	"ipsecsnp.dll",
	"ipsecsvc.dll",
	"ipsmsnap.dll",
	"ipxlatcfg.dll",
	"ir32_32.dll",
	"ir32_32original.dll",
	"ir41_32original.dll",
	"ir41_qc.dll",
	"ir41_qcoriginal.dll",
	"ir41_qcx.dll",
	"ir41_qcxoriginal.dll",
	"ir50_32.dll",
	"ir50_32original.dll",
	"ir50_qc.dll",
	"ir50_qcoriginal.dll",
	"ir50_qcx.dll",
	"ir50_qcxoriginal.dll",
	"irclass.dll",
	"iri.dll",
	"irmon.dll",
	"iscsicpl.dll",
	"iscsidsc.dll",
	"iscsied.dll",
	"iscsiexe.dll",
	"iscsilog.dll",
	"iscsium.dll",
	"iscsiwmi.dll",
	"iscsiwmiv2.dll",
	"ism.dll",
	"ismif32.dll",
	"itircl.dll",
	"itss.dll",
	"iuilp.dll",
	"iumbase.dll",
	"iumcrypt.dll",
	"iumdll.dll",
	"iumsdk.dll",
	"iyuv_32.dll",
	"javascriptcollectionagent.dll",
	"joinproviderol.dll",
	"joinutil.dll",
	"jpmapcontrol.dll",
	"jpndecoder.dll",
	"jpninputrouter.dll",
	"jpnranker.dll",
	"jpnserviceds.dll",
	"jscript.dll",
	"jscript9.dll",
	"jscript9diag.dll",
	"jsproxy.dll",
	"kaaport64.dll",
	"kbd101.dll",
	"kbd101.dll",
	"kbd101.dll",
	"kbd101a.dll",
	"kbd101a.dll",
	"kbd101a.dll",
	"kbd101a.dll",
	"kbd101b.dll",
	"kbd101b.dll",
	"kbd101b.dll",
	"kbd101c.dll",
	"kbd101c.dll",
	"kbd103.dll",
	"kbd103.dll",
	"kbd103.dll",
	"kbd106.dll",
	"kbd106n.dll",
	"kbda1.dll",
	"kbda2.dll",
	"kbda3.dll",
	"kbdal.dll",
	"kbdarme.dll",
	"kbdarmph.dll",
	"kbdarmty.dll",
	"kbdarmw.dll",
	"kbdax2.dll",
	"kbdaze.dll",
	"kbdazel.dll",
	"kbdazst.dll",
	"kbdbash.dll",
	"kbdbe.dll",
	"kbdbene.dll",
	"kbdbgph.dll",
	"kbdbgph1.dll",
	"kbdbhc.dll",
	"kbdblr.dll",
	"kbdbr.dll",
	"kbdbu.dll",
	"kbdbug.dll",
	"kbdbulg.dll",
	"kbdca.dll",
	"kbdcan.dll",
	"kbdcr.dll",
	"kbdcz.dll",
	"kbdcz1.dll",
	"kbdcz2.dll",
	"kbdda.dll",
	"kbddiv1.dll",
	"kbddiv2.dll",
	"kbddv.dll",
	"kbddzo.dll",
	"kbdes.dll",
	"kbdest.dll",
	"kbdfa.dll",
	"kbdfar.dll",
	"kbdfc.dll",
	"kbdfi.dll",
	"kbdfi1.dll",
	"kbdfo.dll",
	"kbdfr.dll",
	"kbdfthrk.dll",
	"kbdgae.dll",
	"kbdgeo.dll",
	"kbdgeoer.dll",
	"kbdgeome.dll",
	"kbdgeooa.dll",
	"kbdgeoqw.dll",
	"kbdgkl.dll",
	"kbdgn.dll",
	"kbdgr.dll",
	"kbdgr1.dll",
	"kbdgrlnd.dll",
	"kbdgthc.dll",
	"kbdhau.dll",
	"kbdhaw.dll",
	"kbdhe.dll",
	"kbdhe220.dll",
	"kbdhe319.dll",
	"kbdheb.dll",
	"kbdhebl3.dll",
	"kbdhela2.dll",
	"kbdhela3.dll",
	"kbdhept.dll",
	"kbdhu.dll",
	"kbdhu1.dll",
	"kbdcher.dll",
	"kbdcherp.dll",
	"kbdibm02.dll",
	"kbdibm02.dll",
	"kbdibo.dll",
	"kbdic.dll",
	"kbdinasa.dll",
	"kbdinbe1.dll",
	"kbdinbe2.dll",
	"kbdinben.dll",
	"kbdindev.dll",
	"kbdinen.dll",
	"kbdinguj.dll",
	"kbdinhin.dll",
	"kbdinkan.dll",
	"kbdinmal.dll",
	"kbdinmar.dll",
	"kbdinori.dll",
	"kbdinpun.dll",
	"kbdintam.dll",
	"kbdintel.dll",
	"kbdinuk2.dll",
	"kbdir.dll",
	"kbdit.dll",
	"kbdit142.dll",
	"kbdiulat.dll",
	"kbdjav.dll",
	"kbdjpn.dll",
	"kbdkaz.dll",
	"kbdkhmr.dll",
	"kbdkni.dll",
	"kbdkor.dll",
	"kbdkurd.dll",
	"kbdkyr.dll",
	"kbdla.dll",
	"kbdlao.dll",
	"kbdlisub.dll",
	"kbdlisus.dll",
	"kbdlk41a.dll",
	"kbdlt.dll",
	"kbdlt1.dll",
	"kbdlt2.dll",
	"kbdlv.dll",
	"kbdlv1.dll",
	"kbdlvst.dll",
	"kbdmac.dll",
	"kbdmacst.dll",
	"kbdmaori.dll",
	"kbdmlt47.dll",
	"kbdmlt48.dll",
	"kbdmon.dll",
	"kbdmonmo.dll",
	"kbdmonst.dll",
	"kbdmyan.dll",
	"kbdne.dll",
	"kbdnec.dll",
	"kbdnec.dll",
	"kbdnec.dll",
	"kbdnec.dll",
	"kbdnec95.dll",
	"kbdnec95.dll",
	"kbdnecat.dll",
	"kbdnecat.dll",
	"kbdnecnt.dll",
	"kbdnecnt.dll",
	"kbdnepr.dll",
	"kbdnko.dll",
	"kbdno.dll",
	"kbdno1.dll",
	"kbdnso.dll",
	"kbdntl.dll",
	"kbdogham.dll",
	"kbdoldit.dll",
	"kbdolch.dll",
	"kbdosm.dll",
	"kbdpash.dll",
	"kbdphags.dll",
	"kbdpl.dll",
	"kbdpl1.dll",
	"kbdpo.dll",
	"kbdro.dll",
	"kbdropr.dll",
	"kbdrost.dll",
	"kbdru.dll",
	"kbdru1.dll",
	"kbdrum.dll",
	"kbdsf.dll",
	"kbdsg.dll",
	"kbdsl.dll",
	"kbdsl1.dll",
	"kbdsmsfi.dll",
	"kbdsmsno.dll",
	"kbdsn1.dll",
	"kbdsora.dll",
	"kbdsorex.dll",
	"kbdsors1.dll",
	"kbdsorst.dll",
	"kbdsp.dll",
	"kbdsw.dll",
	"kbdsw09.dll",
	"kbdsyr1.dll",
	"kbdsyr2.dll",
	"kbdtaile.dll",
	"kbdtajik.dll",
	"kbdtam99.dll",
	"kbdtat.dll",
	"kbdth0.dll",
	"kbdth1.dll",
	"kbdth2.dll",
	"kbdth3.dll",
	"kbdtifi.dll",
	"kbdtifi2.dll",
	"kbdtiprc.dll",
	"kbdtiprd.dll",
	"kbdtt102.dll",
	"kbdtuf.dll",
	"kbdtuq.dll",
	"kbdturme.dll",
	"kbdtzm.dll",
	"kbdughr.dll",
	"kbdughr1.dll",
	"kbduk.dll",
	"kbdukx.dll",
	"kbdur.dll",
	"kbdur1.dll",
	"kbdurdu.dll",
	"kbdus.dll",
	"kbdusa.dll",
	"kbdusl.dll",
	"kbdusr.dll",
	"kbdusx.dll",
	"kbduzb.dll",
	"kbdvntc.dll",
	"kbdwol.dll",
	"kbdyak.dll",
	"kbdyba.dll",
	"kbdycc.dll",
	"kbdycl.dll",
	"kd.dll",
	"kd_02_10df.dll",
	"kd_02_10ec.dll",
	"kd_02_1137.dll",
	"kd_02_14e4.dll",
	"kd_02_15b3.dll",
	"kd_02_1969.dll",
	"kd_02_19a2.dll",
	"kd_02_1af4.dll",
	"kd_02_8086.dll",
	"kd_07_1415.dll",
	"kd_0c_8086.dll",
	"kdcom.dll",
	"kdcpw.dll",
	"kdhvcom.dll",
	"kdnet.dll",
	"kdnet_uart16550.dll",
	"kdscli.dll",
	"kdstub.dll",
	"kdusb.dll",
	"keepaliveprovider.dll",
	"kerbclientshared.dll",
	"kerberos.dll",
	"kernel.appcore.dll",
	"kernel32.dll",
	"kernelbase.dll",
	"keyboardfiltercore.dll",
	"keyboardfiltershim.dll",
	"keycredmgr.dll",
	"keyiso.dll",
	"keymgr.dll",
	"keyworddetectormsftsidadapter.dll",
	"knobscore.dll",
	"knobscsp.dll",
	"koaytj_l.dll",
	"kobdrvapiif.dll",
	"krnlprov.dll",
	"ks.sys",
	"ksecdd.sys",
	"ksuser.dll",
	"ktmw32.dll",
	"l2gpstore.dll",
	"l2nacp.dll",
	"l2sechc.dll",
	"langcleanupsysprepaction.dll",
	"languagecomponentsinstaller.dll",
	"languageoverlayserver.dll",
	"languageoverlayutil.dll",
	"languagepackdiskcleanup.dll",
	"laprxy.dll",
	"ldbg.dll",
	"legacynetux.dll",
	"lfsvc.dll",
	"libarchive-2.dll",
	"libbz2-2.dll",
	"libcrypto.dll",
	"libcurl-x64.dll",
	"libcurl.dll",
	"libeay32.dll",
	"libegl.dll",
	"libexpat-1.dll",
	"libglesv2.dll",
	"liblzma-1.dll",
	"libssh2.dll",
	"libz-1.dll",
	"licensemanager.dll",
	"licensemanagerapi.dll",
	"licensemanagersvc.dll",
	"licensingcsp.dll",
	"licensingdiagspp.dll",
	"licensingwinrt.dll",
	"licmgr10.dll",
	"linkinfo.dll",
	"listsvc.dll",
	"lltdapi.dll",
	"lltdres.dll",
	"lltdsvc.dll",
	"lmhsvc.dll",
	"loadperf.dll",
	"localsec.dll",
	"localspl.dll",
	"localui.dll",
	"locationapi.dll",
	"locationframework.dll",
	"locationframeworkinternalps.dll",
	"locationframeworkps.dll",
	"locationwinpalmisc.dll",
	"lockappbroker.dll",
	"lockcontroller.dll",
	"lockhostingframework.dll",
	"lockscreencontent.dll",
	"lockscreencontenthost.dll",
	"lockscreendata.dll",
	"loghours.dll",
	"logoncli.dll",
	"logoncontroller.dll",
	"lpasvc.dll",
	"lpk.dll",
	"lpksetupproxyserv.dll",
	"lsasrv.dll",
	"lscshostpolicy.dll",
	"lsm.dll",
	"lsmproxy.dll",
	"lstelemetry.dll",
	"luainstall.dll",
	"luiapi.dll",
	"lz32.dll",
	"magnification.dll",
	"maintenanceui.dll",
	"mapconfiguration.dll",
	"mapcontrolcore.dll",
	"mapcontrolstringsres.dll",
	"mapgeocoder.dll",
	"mapi32.dll",
	"mapistub.dll",
	"maprouter.dll",
	"mapsbtsvc.dll",
	"mapsbtsvcproxy.dll",
	"mapscsp.dll",
	"mapsstore.dll",
	"mapstelemetry.dll",
	"mapstoasttask.dll",
	"mapsupdatetask.dll",
	"maxxaudioapo20.dll",
	"maxxaudioapo30.dll",
	"maxxaudioapo4064.dll",
	"maxxaudioapo5064.dll",
	"maxxaudioapo6064.dll",
	"maxxaudioaposhell64.dll",
	"maxxaudioeq64.dll",
	"maxxaudiorealtek264.dll",
	"maxxaudiorealtek64.dll",
	"maxxaudiovna64.dll",
	"maxxaudiovnn64.dll",
	"maxxspeechapo64.dll",
	"maxxvoiceapo2064.dll",
	"maxxvoiceapo3064.dll",
	"maxxvolumesdapo.dll",
	"mbaeapi.dll",
	"mbaeapipublic.dll",
	"mbaexmlparser.dll",
	"mbapo232.dll",
	"mbapo264.dll",
	"mbapo32.dll",
	"mbapo64.dll",
	"mbmediamanager.dll",
	"mbppcn64.dll",
	"mbppld64.dll",
	"mbsmsapi.dll",
	"mbthx32.dll",
	"mbthx64.dll",
	"mbussdapi.dll",
	"mbwrp64.dll",
	"mccsengineshared.dll",
	"mccspal.dll",
	"mciavi32.dll",
	"mcicda.dll",
	"mciqtz32.dll",
	"mciseq.dll",
	"mciwave.dll",
	"mcrecvsrc.dll",
	"mcupdate_authenticamd.dll",
	"mcupdate_genuineintel.dll",
	"mdmappprov.dll",
	"mdmcommon.dll",
	"mdmdiagnostics.dll",
	"mdminst.dll",
	"mdmlocalmanagement.dll",
	"mdmmigrator.dll",
	"mdmpostprocessevaluator.dll",
	"mdmregistration.dll",
	"mdmsettingsprov.dll",
	"mediafoundation.defaultperceptionprovider.dll",
	"memorydiagnostic.dll",
	"messagingdatamodel2.dll",
	"messagingservice.dll",
	"mf.dll",
	"mf3216.dll",
	"mfaacenc.dll",
	"mfasfsrcsnk.dll",
	"mfaudiocnv.dll",
	"mfc100.dll",
	"mfc100d.dll",
	"mfc100u.dll",
	"mfc100ud.dll",
	"mfc100deu.dll",
	"mfc100enu.dll",
	"mfc100esn.dll",
	"mfc100fra.dll",
	"mfc100chs.dll",
	"mfc100cht.dll",
	"mfc100ita.dll",
	"mfc100jpn.dll",
	"mfc100kor.dll",
	"mfc100rus.dll",
	"mfc100u.dll",
	"mfc110.dll",
	"mfc110deu.dll",
	"mfc110enu.dll",
	"mfc110esn.dll",
	"mfc110fra.dll",
	"mfc110chs.dll",
	"mfc110cht.dll",
	"mfc110ita.dll",
	"mfc110jpn.dll",
	"mfc110kor.dll",
	"mfc110rus.dll",
	"mfc110u.dll",
	"mfc110ud.dll",
	"mfc120.dll",
	"mfc120d.dll",
	"mfc120deu.dll",
	"mfc120enu.dll",
	"mfc120esn.dll",
	"mfc120fra.dll",
	"mfc120chs.dll",
	"mfc120cht.dll",
	"mfc120ita.dll",
	"mfc120jpn.dll",
	"mfc120kor.dll",
	"mfc120rus.dll",
	"mfc120u.dll",
	"mfc120ud.dll",
	"mfc140.dll",
	"mfc140d.dll",
	"mfc140deu.dll",
	"mfc140enu.dll",
	"mfc140esn.dll",
	"mfc140fra.dll",
	"mfc140chs.dll",
	"mfc140cht.dll",
	"mfc140ita.dll",
	"mfc140jpn.dll",
	"mfc140kor.dll",
	"mfc140rus.dll",
	"mfc140u.dll",
	"mfc140ud.dll",
	"mfc40.dll",
	"mfc40u.dll",
	"mfc42.dll",
	"mfc42d.dll",
	"mfc42u.dll",
	"mfc70.dll",
	"mfc70u.dll",
	"mfc71.dll",
	"mfc71u.dll",
	"mfc71ud.dll",
	"mfc80.dll",
	"mfc80u.dll",
	"mfc80ud.dll",
	"mfc90.dll",
	"mfc90d.dll",
	"mfc90u.dll",
	"mfc90ud.dll",
	"mfcaptureengine.dll",
	"mfcm100.dll",
	"mfcm100u.dll",
	"mfcm110.dll",
	"mfcm110u.dll",
	"mfcm120.dll",
	"mfcm120u.dll",
	"mfcm140.dll",
	"mfcm140d.dll",
	"mfcm140u.dll",
	"mfcm140ud.dll",
	"mfco42d.dll",
	"mfcore.dll",
	"mfcsubs.dll",
	"mfds.dll",
	"mfdvdec.dll",
	"mferror.dll",
	"mfh263enc.dll",
	"mfh264enc.dll",
	"mfksproxy.dll",
	"mfmediaengine.dll",
	"mfmjpegdec.dll",
	"mfmkvsrcsnk.dll",
	"mfmp4srcsnk.dll",
	"mfmpeg2srcsnk.dll",
	"mfnetcore.dll",
	"mfnetsrc.dll",
	"mfperfhelper.dll",
	"mfplat.dll",
	"mfplay.dll",
	"mfps.dll",
	"mfreadwrite.dll",
	"mfsensorgroup.dll",
	"mfsrcsnk.dll",
	"mfsvr.dll",
	"mftranscode.dll",
	"mfvdsp.dll",
	"mfvfw.dll",
	"mfwmaaec.dll",
	"mgmtapi.dll",
	"mgmtrefreshcredprov.dll",
	"mi.dll",
	"mibincodec.dll",
	"microsoft-windows-appmodelexecevents.dll",
	"microsoft-windows-battery-events.dll",
	"microsoft-windows-hal-events.dll",
	"microsoft-windows-internal-shell-nearshareexperience.dll",
	"microsoft-windows-kernel-pnp-events.dll",
	"microsoft-windows-kernel-power-events.dll",
	"microsoft-windows-kernel-processor-power-events.dll",
	"microsoft-windows-mapcontrols.dll",
	"microsoft-windows-moshost.dll",
	"microsoft-windows-mostrace.dll",
	"microsoft-windows-pdc.dll",
	"microsoft-windows-power-cad-events.dll",
	"microsoft-windows-processor-aggregator-events.dll",
	"microsoft-windows-sleepstudy-events.dll",
	"microsoft-windows-storage-tiering-events.dll",
	"microsoft-windows-system-events.dll",
	"microsoft-windowsphone-semanagementprovider.dll",
	"microsoft.appv.appvclientwmi (1).dll",
	"microsoft.appv.appvclientwmi.dll",
	"microsoft.bluetooth.proxy.dll",
	"microsoft.bluetooth.service.dll",
	"microsoft.bluetooth.userservice.dll",
	"microsoft.graphics.display.displayenhancementservice.dll",
	"microsoft.management.infrastructure.native.unmanaged.dll",
	"microsoft.uev.agentdriverevents.dll",
	"microsoft.uev.agentwmi (1).dll",
	"microsoft.uev.agentwmi.dll",
	"microsoft.uev.appagent.dll",
	"microsoft.uev.cabutil.dll",
	"microsoft.uev.cmutil.dll",
	"microsoft.uev.common.dll",
	"microsoft.uev.common.winrt.dll",
	"microsoft.uev.commonbridge.dll",
	"microsoft.uev.configwrapper.dll",
	"microsoft.uev.eventlogmessages.dll",
	"microsoft.uev.localsyncprovider.dll",
	"microsoft.uev.managedeventlogging.dll",
	"microsoft.uev.management.dll",
	"microsoft.uev.management.wmiaccess.dll",
	"microsoft.uev.modernappagent.dll",
	"microsoft.uev.modernappcore.dll",
	"microsoft.uev.modernappdata.winrt.dll",
	"microsoft.uev.modernsync.dll",
	"microsoft.uev.monitorsyncprovider.dll",
	"microsoft.uev.office2010customactions.dll",
	"microsoft.uev.office2013customactions.dll",
	"microsoft.uev.printercustomactions.dll",
	"microsoft.uev.smbsyncprovider.dll",
	"microsoft.uev.synccommon.dll",
	"microsoft.uev.syncconditions.dll",
	"microsoft.windowsapicodepack.dll",
	"microsoftaccountcloudap.dll",
	"microsoftaccountextension.dll",
	"microsoftaccounttokenprovider.dll",
	"microsoftaccountwamextension.dll",
	"microsoftupdatecatalogwebcontrol.dll",
	"midimap.dll",
	"migisol.dll",
	"miguiresource.dll",
	"mimefilt.dll",
	"mimofcodec.dll",
	"minstoreevents.dll",
	"mintdh.dll",
	"miracastinputmgr.dll",
	"miracastreceiver.dll",
	"mirrordrvcompat.dll",
	"mispace.dll",
	"miss_apo.dll",
	"mitigationconfiguration.dll",
	"miutils.dll",
	"mixedreality.broker.dll",
	"mixedrealitycapture.broker.dll",
	"mixedrealitycapture.pipeline.dll",
	"mlang.dll",
	"mmcbase.dll",
	"mmci.dll",
	"mmcico.dll",
	"mmcndmgr.dll",
	"mmcshext.dll",
	"mmdevapi.dll",
	"mmfutil.dll",
	"mmgaclient.dll",
	"mmgaproxystub.dll",
	"mmres.dll",
	"mobilenetworking.dll",
	"modemui.dll",
	"modernexecserver.dll",
	"mofd.dll",
	"mofinstall.dll",
	"moricons.dll",
	"mos.dll",
	"moshost.dll",
	"moshostclient.dll",
	"moshostcore.dll",
	"mosresource.dll",
	"mosstorage.dll",
	"mp3dmod.dll",
	"mp43decd.dll",
	"mp4sdecd.dll",
	"mpeval.dll",
	"mpg4decd.dll",
	"mpr.dll",
	"mprapi.dll",
	"mprddm.dll",
	"mprdim.dll",
	"mprext.dll",
	"mprmsg.dll",
	"mpssvc.dll",
	"mpunits.dll",
	"mqcertui.dll",
	"mqsnap.dll",
	"mrmcorer.dll",
	"mrmdeploy.dll",
	"mrmindexer.dll",
	"mrt_map.dll",
	"mrt100.dll",
	"ms3dthumbnailprovider.dll",
	"msaatext.dll",
	"msac3enc.dll",
	"msacm32.dll",
	"msafd.dll",
	"msajapi.dll",
	"msalacdecoder.dll",
	"msalacencoder.dll",
	"msamrnbdecoder.dll",
	"msamrnbencoder.dll",
	"msamrnbsink.dll",
	"msamrnbsource.dll",
	"msaprofilenotificationhandler.dll",
	"msasn1.dll",
	"msauddecmft.dll",
	"msaudite.dll",
	"msauserext.dll",
	"mscandui.dll",
	"mscat32.dll",
	"msclmd.dll",
	"mscms.dll",
	"mscoree.dll",
	"mscorier.dll",
	"mscories.dll",
	"mscpx32r.dll",
	"mscpxl32.dll",
	"msctf.dll",
	"msctfmonitor.dll",
	"msctfp.dll",
	"msctfui.dll",
	"msctfuimanager.dll",
	"msdadiag.dll",
	"msdart.dll",
	"msdelta.dll",
	"msdmo.dll",
	"msdrm.dll",
	"msdtckrm.dll",
	"msdtclog.dll",
	"msdtcprx.dll",
	"msdtcspoffln.dll",
	"msdtctm.dll",
	"msdtcuiu.dll",
	"msdtcvsp1res.dll",
	"msdtcwmi.dll",
	"msexcl40.dll",
	"msexch40.dll",
	"msfeeds.dll",
	"msfeedsbs.dll",
	"msflacdecoder.dll",
	"msflacencoder.dll",
	"msftedit.dll",
	"msftoemdlligneous.dll",
	"msheif.dll",
	"mshtml.dll",
	"mshtmldac.dll",
	"mshtmled.dll",
	"mshtmler.dll",
	"msi.dll",
	"msicofire.dll",
	"msidcrl40.dll",
	"msident.dll",
	"msidle.dll",
	"msidntld.dll",
	"msieftp.dll",
	"msihnd.dll",
	"msiltcfg.dll",
	"msimg32.dll",
	"msimsg.dll",
	"msimtf.dll",
	"msiprov.dll",
	"msisip.dll",
	"msiso.dll",
	"msiwer.dll",
	"msjet40.dll",
	"msjetoledb40.dll",
	"msjint40.dll",
	"msjter40.dll",
	"msjtes40.dll",
	"mskeyprotcli.dll",
	"mskeyprotect.dll",
	"msls31.dll",
	"msltus40.dll",
	"msmpeg2adec.dll",
	"msmpeg2enc.dll",
	"msmpeg2vdec.dll",
	"msobjs.dll",
	"msoert2.dll",
	"msopusdecoder.dll",
	"msorc32r.dll",
	"msorcl32.dll",
	"mspatcha.dll",
	"mspatchc.dll",
	"mspbde40.dll",
	"mspdb80.dll",
	"mspdbcore.dll",
	"msphotography.dll",
	"msports.dll",
	"msprivs.dll",
	"msrahc.dll",
	"msrating.dll",
	"msrd2x40.dll",
	"msrd3x40.dll",
	"msrdc.dll",
	"msrdpwebaccess.dll",
	"msrepl40.dll",
	"msrle32.dll",
	"msrpc.sys",
	"msscntrs.dll",
	"mssecuser.dll",
	"mssign32.dll",
	"mssip32.dll",
	"mssitlb.dll",
	"msspellcheckingfacility.dll",
	"mssph.dll",
	"mssprxy.dll",
	"mssrch.dll",
	"msstdfmt.dll",
	"mssvp.dll",
	"mstask.dll",
	"mstext40.dll",
	"mstextprediction.dll",
	"mstscax.dll",
	"msutb.dll",
	"msv1_0.dll",
	"msvbvm60.dll",
	"msvcirt.dll",
	"msvcp_win.dll",
	"msvcm80.dll",
	"msvcm90.dll",
	"msvcp100.dll",
	"msvcp100d.dll",
	"msvcp110.dll",
	"msvcp110d.dll",
	"msvcp110_win.dll",
	"msvcp120.dll",
	"msvcp120d.dll",
	"msvcp120_clr0400.dll",
	"msvcp140.dll",
	"msvcp140d.dll",
	"msvcp140_1.dll",
	"msvcp140_1d.dll",
	"msvcp140_2.dll",
	"msvcp140_2d.dll",
	"msvcp50.dll",
	"msvcp50d.dll",
	"msvcp60.dll",
	"msvcp60d.dll",
	"msvcp70.dll",
	"msvcp70d.dll",
	"msvcp71.dll",
	"msvcp71d.dll",
	"msvcp80.dll",
	"msvcp80d.dll",
	"msvcp90.dll",
	"msvcp90d.dll",
	"msvcr100.dll",
	"msvcr100d.dll",
	"msvcr100_clr0400.dll",
	"msvcr110.dll",
	"msvcr110d.dll",
	"msvcr120.dll",
	"msvcr120d.dll",
	"msvcr120_clr0400.dll",
	"msvcr70.dll",
	"msvcr70d.dll",
	"msvcr71.dll",
	"msvcr71d.dll",
	"msvcr80.dll",
	"msvcr80d.dll",
	"msvcr90.dll",
	"msvcr90d.dll",
	"msvcrt.dll",
	"msvcrtd.dll",
	"msvcrt20.dll",
	"msvcrt40.dll",
	"msvfw32.dll",
	"msvidc32.dll",
	"msvidctl.dll",
	"msvideodsp.dll",
	"msvp9dec.dll",
	"msvproc.dll",
	"msvpxenc.dll",
	"mswb7.dll",
	"mswdat10.dll",
	"mswebp.dll",
	"mswmdm.dll",
	"mswsock.dll",
	"mswstr10.dll",
	"msxbde40.dll",
	"msxml3.dll",
	"msxml3r.dll",
	"msxml4.dll",
	"msxml4r.dll",
	"msxml6.dll",
	"msxml6r.dll",
	"msys-2.0.dll",
	"msys-archive-13.dll",
	"msys-asn1-8.dll",
	"msys-asprintf-0.dll",
	"msys-assuan-0.dll",
	"msys-atomic-1.dll",
	"msys-blkid-1.dll",
	"msys-brotlicommon-1.dll",
	"msys-brotlidec-1.dll",
	"msys-brotlienc-1.dll",
	"msys-bz2-1.dll",
	"msys-cilkrts-5.dll",
	"msys-com_err-1.dll",
	"msys-crypt-0.dll",
	"msys-crypto-1.1.dll",
	"msys-curl-4.dll",
	"msys-db-5.3.dll",
	"msys-db_cxx-5.3.dll",
	"msys-edit-0.dll",
	"msys-expat-1.dll",
	"msys-exslt-0.dll",
	"msys-fdisk-1.dll",
	"msys-ffi-6.dll",
	"msys-formw6.dll",
	"msys-gcc_s-seh-1.dll",
	"msys-gcrypt-20.dll",
	"msys-gettextlib-0-19-8-1.dll",
	"msys-gettextpo-0.dll",
	"msys-gettextsrc-0-19-8-1.dll",
	"msys-gfortran-4.dll",
	"msys-gio-2.0-0.dll",
	"msys-glib-2.0-0.dll",
	"msys-gmodule-2.0-0.dll",
	"msys-gmp-10.dll",
	"msys-gmpxx-4.dll",
	"msys-gnutls-30.dll",
	"msys-gnutlsxx-28.dll",
	"msys-gobject-2.0-0.dll",
	"msys-gomp-1.dll",
	"msys-gpg-error-0.dll",
	"msys-gpgme-11.dll",
	"msys-gpgmepp-6.dll",
	"msys-gssapi-3.dll",
	"msys-gthread-2.0-0.dll",
	"msys-hcrypto-4.dll",
	"msys-hdb-9.dll",
	"msys-heimbase-1.dll",
	"msys-heimntlm-0.dll",
	"msys-history7.dll",
	"msys-hogweed-4.dll",
	"msys-hx509-5.dll",
	"msys-charset-1.dll",
	"msys-iconv-2.dll",
	"msys-icudata62.dll",
	"msys-icui18n62.dll",
	"msys-icuio62.dll",
	"msys-icutest62.dll",
	"msys-icutu62.dll",
	"msys-icuuc62.dll",
	"msys-idn-12.dll",
	"msys-idn2-0.dll",
	"msys-intl-8.dll",
	"msys-kadm5clnt-7.dll",
	"msys-kadm5srv-8.dll",
	"msys-kafs-0.dll",
	"msys-kdc-2.dll",
	"msys-krb5-26.dll",
	"msys-ksba-8.dll",
	"msys-lz4-1.dll",
	"msys-lzma-5.dll",
	"msys-lzo2-2.dll",
	"msys-magic-1.dll",
	"msys-menuw6.dll",
	"msys-metalink-3.dll",
	"msys-mpfr-6.dll",
	"msys-ncurses++w6.dll",
	"msys-ncursesw6.dll",
	"msys-nettle-6.dll",
	"msys-nghttp2-14.dll",
	"msys-npth-0.dll",
	"msys-otp-0.dll",
	"msys-p11-kit-0.dll",
	"msys-panelw6.dll",
	"msys-pcre-1.dll",
	"msys-pcre16-0.dll",
	"msys-pcre2-8-0.dll",
	"msys-pcre32-0.dll",
	"msys-pcrecpp-0.dll",
	"msys-pcreposix-0.dll",
	"msys-psl-5.dll",
	"msys-quadmath-0.dll",
	"msys-readline7.dll",
	"msys-roken-18.dll",
	"msys-sl-0.dll",
	"msys-smartcols-1.dll",
	"msys-sqlite3-0.dll",
	"msys-sqlite3amatch-0.dll",
	"msys-sqlite3anycollseq-0.dll",
	"msys-sqlite3carray-0.dll",
	"msys-sqlite3closure-0.dll",
	"msys-sqlite3completion-0.dll",
	"msys-sqlite3compress-0.dll",
	"msys-sqlite3csv-0.dll",
	"msys-sqlite3eval-0.dll",
	"msys-sqlite3fileio-0.dll",
	"msys-sqlite3fuzzer-0.dll",
	"msys-sqlite3icu-0.dll",
	"msys-sqlite3ieee754-0.dll",
	"msys-sqlite3memvfs-0.dll",
	"msys-sqlite3nextchar-0.dll",
	"msys-sqlite3percentile-0.dll",
	"msys-sqlite3rbu-0.dll",
	"msys-sqlite3regexp-0.dll",
	"msys-sqlite3remember-0.dll",
	"msys-sqlite3rot13-0.dll",
	"msys-sqlite3series-0.dll",
	"msys-sqlite3sha1-0.dll",
	"msys-sqlite3shathree-0.dll",
	"msys-sqlite3showauth-0.dll",
	"msys-sqlite3spellfix-0.dll",
	"msys-sqlite3stmt-0.dll",
	"msys-sqlite3totype-0.dll",
	"msys-sqlite3unionvtab-0.dll",
	"msys-sqlite3vfslog-0.dll",
	"msys-sqlite3vfsstat-0.dll",
	"msys-sqlite3vtshim-0.dll",
	"msys-sqlite3wholenumber-0.dll",
	"msys-ssh2-1.dll",
	"msys-ssl-1.1.dll",
	"msys-stdc++-6.dll",
	"msys-tasn1-6.dll",
	"msys-ticw6.dll",
	"msys-ucl-1.dll",
	"msys-unistring-2.dll",
	"msys-uuid-1.dll",
	"msys-wind-0.dll",
	"msys-xml2-2.dll",
	"msys-xslt-1.dll",
	"msys-z.dll",
	"msyuv.dll",
	"mtcmodel.dll",
	"mtf.dll",
	"mtfappserviceds.dll",
	"mtfdecoder.dll",
	"mtffuzzyds.dll",
	"mtfserver.dll",
	"mtfspellcheckds.dll",
	"mtxclu.dll",
	"mtxdm.dll",
	"mtxex.dll",
	"mtxlegih.dll",
	"mtxoci.dll",
	"muifontsetup.dll",
	"muilanguagecleanup.dll",
	"musdialoghandlers.dll",
	"musupdatehandlers.dll",
	"mycomput.dll",
	"mydocs.dll",
	"napcrypt.dll",
	"napinsp.dll",
	"nativemap.dll",
	"naturalauth.dll",
	"naturalauthclient.dll",
	"naturallanguage6.dll",
	"navshutdown.dll",
	"ncaapi.dll",
	"ncasvc.dll",
	"ncbservice.dll",
	"ncdautosetup.dll",
	"ncdprop.dll",
	"nci.dll",
	"ncobjapi.dll",
	"ncprov.dll",
	"ncrypt.dll",
	"ncryptprov.dll",
	"ncryptsslp.dll",
	"ncsi.dll",
	"ncuprov.dll",
	"nddeapi.dll",
	"ndfapi.dll",
	"ndfetw.dll",
	"ndfhcdiscovery.dll",
	"ndis.sys",
	"ndishc.dll",
	"ndisimplatcim.dll",
	"ndproxystub.dll",
	"nduprov.dll",
	"negoexts.dll",
	"netadaptercim.dll",
	"netapi32.dll",
	"netbios.dll",
	"netcellcorecellmanagerproviderresources.dll",
	"netcenter.dll",
	"netcfgx.dll",
	"netcorehc.dll",
	"netdacim.dll",
	"netdiagfx.dll",
	"netdriverinstall.dll",
	"netevent.dll",
	"neteventpacketcapture.dll",
	"netfxperf.dll",
	"neth.dll",
	"netid.dll",
	"netio.sys",
	"netiohlp.dll",
	"netjoin.dll",
	"netlogon.dll",
	"netman.dll",
	"netmsg.dll",
	"netnccim.dll",
	"netpeerdistcim.dll",
	"netplwiz.dll",
	"netprofm.dll",
	"netprofmsvc.dll",
	"netprovfw.dll",
	"netprovisionsp.dll",
	"netsetupapi.dll",
	"netsetupengine.dll",
	"netsetupshim.dll",
	"netsetupsvc.dll",
	"netshell.dll",
	"netswitchteamcim.dll",
	"nettcpip.dll",
	"nettrace.dll",
	"netttcim.dll",
	"netutils.dll",
	"networkbindingenginemigplugin.dll",
	"networkcollectionagent.dll",
	"networkdesktopsettings.dll",
	"networkexplorer.dll",
	"networkhelper.dll",
	"networkitemfactory.dll",
	"networkmobilesettings.dll",
	"networkproxycsp.dll",
	"networkstatus.dll",
	"networkuxbroker.dll",
	"netwphelper.dll",
	"newdev.dll",
	"newtonsoft.json.dll",
	"nfcprovisioningplugin.dll",
	"nfcradiomedia.dll",
	"ngccredprov.dll",
	"ngcctnr.dll",
	"ngcctnrgidshandler.dll",
	"ngcctnrsvc.dll",
	"ngcisoctnr.dll",
	"ngckeyenum.dll",
	"ngcksp.dll",
	"ngclocal.dll",
	"ngcpopkeysrv.dll",
	"ngcprocsp.dll",
	"ngcrecovery.dll",
	"ngcsvc.dll",
	"ngctasks.dll",
	"nicco4.dll",
	"nicinstd.dll",
	"ninput.dll",
	"nlaapi.dll",
	"nlahc.dll",
	"nlasvc.dll",
	"nlhtml.dll",
	"nlmcim.dll",
	"nlmgp.dll",
	"nlmproxy.dll",
	"nlmsprep.dll",
	"nlsbres.dll",
	"nlsdata0000.dll",
	"nlsdata0009.dll",
	"nlsdl.dll",
	"nlslexicons0009.dll",
	"nmaa.dll",
	"nmadirect.dll",
	"node.dll",
	"normaliz.dll",
	"notificationcontroller.dll",
	"notificationcontrollerps.dll",
	"notificationplatformcomponent.dll",
	"nousbwarning.dll",
	"npmproxy.dll",
	"npsm.dll",
	"npsmdesktopprovider.dll",
	"nrpsrv.dll",
	"nshhttp.dll",
	"nshipsec.dll",
	"nshwfp.dll",
	"nsi.dll",
	"nsisvc.dll",
	"ntasn1.dll",
	"ntdll.dll",
	"ntdsapi.dll",
	"ntevt.dll",
	"ntlanman.dll",
	"ntlanui2.dll",
	"ntlmshared.dll",
	"ntmarta.dll",
	"ntoskrnl.exe",
	"ntprint.dll",
	"ntshrui.dll",
	"ntvdm64.dll",
	"nv3dappshext.dll",
	"nv3dappshextr.dll",
	"nvapi.dll",
	"nvapi64.dll",
	"nvcompiler.dll",
	"nvcpl.dll",
	"nvcuda.dll",
	"nvcuvid.dll",
	"nvdispco6435362.dll",
	"nvdispco6436909.dll",
	"nvdispgenco6435362.dll",
	"nvdispgenco6436909.dll",
	"nvfatbinaryloader.dll",
	"nvfbc.dll",
	"nvfbc64.dll",
	"nvhdagenco6420103.dll",
	"nvhdap64.dll",
	"nvifr.dll",
	"nvifr64.dll",
	"nvmctray.dll",
	"nvoglv32.dll",
	"nvoglv64.dll",
	"nvopencl.dll",
	"nvptxjitcompiler.dll",
	"nvshext.dll",
	"nvsvc64.dll",
	"nvsvcr.dll",
	"objsel.dll",
	"occache.dll",
	"ocsetapi.dll",
	"odbc32.dll",
	"odbcbcp.dll",
	"odbcconf.dll",
	"odbccp32.dll",
	"odbccr32.dll",
	"odbccu32.dll",
	"odbcint.dll",
	"odbcji32.dll",
	"odbcjt32.dll",
	"odbctrac.dll",
	"oddbse32.dll",
	"odexl32.dll",
	"odfox32.dll",
	"odpdx32.dll",
	"odtext32.dll",
	"oemdefaultassociations.dll",
	"oemlicense.dll",
	"offfilt.dll",
	"officecsp.dll",
	"offlinelsa.dll",
	"offlinesam.dll",
	"offreg.dll",
	"ole2.dll",
	"ole2disp.dll",
	"ole2nls.dll",
	"ole32.dll",
	"oleacc.dll",
	"oleaccrc.dll",
	"oleacchooks.dll",
	"oleaut32.dll",
	"olecli32.dll",
	"oledlg.dll",
	"oleprn.dll",
	"olepro32.dll",
	"olesvr32.dll",
	"olethk32.dll",
	"omadmagent.dll",
	"omadmapi.dll",
	"ondemandbrokerclient.dll",
	"ondemandconnroutehelper.dll",
	"onebackuphandler.dll",
	"onecorecommonproxystub.dll",
	"onecoreuapcommonproxystub.dll",
	"onedrivesettingsyncprovider.dll",
	"onex.dll",
	"onexui.dll",
	"oobefldr.dll",
	"opcservices.dll",
	"opencl.dll",
	"opengl32.dll",
	"ortcengine.dll",
	"osbaseln.dll",
	"osksupport.dll",
	"osuninst.dll",
	"p2p.dll",
	"p2pgraph.dll",
	"p2pnetsh.dll",
	"p2psvc.dll",
	"packager.dll",
	"packagestateroaming.dll",
	"packet.dll",
	"panmap.dll",
	"pautoenr.dll",
	"payloadrestrictions.dll",
	"paymentmediatorserviceproxy.dll",
	"pcacli.dll",
	"pcadm.dll",
	"pcaevts.dll",
	"pcasvc.dll",
	"pcaui.dll",
	"pcpksp.dll",
	"pcshellcommonproxystub.dll",
	"pcsvdevice.dll",
	"pcwum.dll",
	"pcwutl.dll",
	"pdh.dll",
	"pdhui.dll",
	"peerdist.dll",
	"peerdistad.dll",
	"peerdistcacheprovider.dll",
	"peerdistcleaner.dll",
	"peerdisthttptrans.dll",
	"peerdistsh.dll",
	"peerdistsvc.dll",
	"peerdistwsddiscoprov.dll",
	"peopleapis.dll",
	"peopleband.dll",
	"perceptiondriverclient.dll",
	"perceptionsimulation.proxystubs.dll",
	"perceptionsimulationextensions.dll",
	"perceptionsimulationmanager.dll",
	"perf_gputiming.dll",
	"perfctrs.dll",
	"perfdisk.dll",
	"perfnet.dll",
	"perfos.dll",
	"perfproc.dll",
	"perftrack.dll",
	"perfts.dll",
	"perl522.dll",
	"perlse.dll",
	"personalizationcsp.dll",
	"personax.dll",
	"phonecallhistoryapis.dll",
	"phonedatasync.dll",
	"phoneom.dll",
	"phoneplatformabstraction.dll",
	"phoneproviders.dll",
	"phoneservice.dll",
	"phoneserviceres.dll",
	"phoneutil.dll",
	"phoneutilres.dll",
	"photometadatahandler.dll",
	"photowiz.dll",
	"pickerplatform.dll",
	"pid.dll",
	"pidgenx.dll",
	"pifmgr.dll",
	"pimindexmaintenance.dll",
	"pimindexmaintenanceclient.dll",
	"pimstore.dll",
	"pinenrollmenthelper.dll",
	"pkeyhelper.dll",
	"pku2u.dll",
	"pla.dll",
	"playlistfolder.dll",
	"playsndsrv.dll",
	"playtodevice.dll",
	"playtomanager.dll",
	"playtomenu.dll",
	"playtoreceiver.dll",
	"playtostatusprovider.dll",
	"ploptin.dll",
	"pmcsnap.dll",
	"pngfilt.dll",
	"pnidui.dll",
	"pnpclean.dll",
	"pnppolicy.dll",
	"pnpts.dll",
	"pnpui.dll",
	"pnpxassoc.dll",
	"pnpxassocprx.dll",
	"pnrpauto.dll",
	"pnrphc.dll",
	"pnrpnsp.dll",
	"pnrpsvc.dll",
	"policman.dll",
	"policymanager.dll",
	"policymanagerprecheck.dll",
	"polstore.dll",
	"portabledeviceapi.dll",
	"portabledeviceclassextension.dll",
	"portabledeviceconnectapi.dll",
	"portabledevicestatus.dll",
	"portabledevicesyncprovider.dll",
	"portabledevicetypes.dll",
	"portabledevicewiacompat.dll",
	"portcls.sys",
	"posyncservices.dll",
	"pots.dll",
	"powercpl.dll",
	"powrprof.dll",
	"ppcsnap.dll",
	"prauthproviders.dll",
	"presentationcffrasterizernative_v0300.dll",
	"presentationhostproxy.dll",
	"presentationnative_v0300.dll",
	"prflbmsg.dll",
	"print.workflow.source.dll",
	"printconfig.dll",
	"printfilterpipelineprxy.dll",
	"printisolationproxy.dll",
	"printmanagementprovider.dll",
	"printplatformconfig.dll",
	"printrenderapihost.dll",
	"printui.dll",
	"printworkflowproxy.dll",
	"printworkflowservice.dll",
	"printwsdahost.dll",
	"prm0005.dll",
	"prm0009.dll",
	"prncache.dll",
	"prnfldr.dll",
	"prnntfy.dll",
	"prntvpt.dll",
	"productenumerator.dll",
	"profapi.dll",
	"profext.dll",
	"profprov.dll",
	"profsvc.dll",
	"profsvcext.dll",
	"propsys.dll",
	"provcore.dll",
	"provdatastore.dll",
	"provdiagnostics.dll",
	"provengine.dll",
	"provhandlers.dll",
	"provisioningcommandscsp.dll",
	"provisioningcsp.dll",
	"provisioninghandlers.dll",
	"provmigrate.dll",
	"provops.dll",
	"provpackageapidll.dll",
	"provplatformdesktop.dll",
	"provplugineng.dll",
	"provsvc.dll",
	"provsysprep.dll",
	"provthrd.dll",
	"proximitycommon.dll",
	"proximitycommonpal.dll",
	"proximityrtapipal.dll",
	"proximityservice.dll",
	"proximityservicepal.dll",
	"prvdmofcomp.dll",
	"psapi.dll",
	"psevents.dll",
	"pshed.dll",
	"psisdecd.dll",
	"psmodulediscoveryprovider.dll",
	"psmserviceexthost.dll",
	"psmsrv.dll",
	"pspluginwkr.dll",
	"pstask.dll",
	"pstorec.dll",
	"pthreadvc.dll",
	"ptpprov.dll",
	"puiapi.dll",
	"puiobj.dll",
	"pushtoinstall.dll",
	"pwlauncher.dll",
	"pwrshmsg.dll",
	"pwrshplugin.dll",
	"pwrshsip.dll",
	"pwsso.dll",
	"pyshellext.amd64.dll",
	"python27.dll",
	"python3.dll",
	"python3_d.dll",
	"python37.dll",
	"python37_d.dll",
	"qasf.dll",
	"qcap.dll",
	"qdv.dll",
	"qdvd.dll",
	"qedit.dll",
	"qedwipes.dll",
	"qmgr.dll",
	"qoswmi.dll",
	"qtcore4.dll",
	"qtgui4.dll",
	"quartz.dll",
	"query.dll",
	"quickactionsdatamodel.dll",
	"quiethours.dll",
	"qwave.dll",
	"r4eea64a.dll",
	"r4eed64a.dll",
	"r4eeg64a.dll",
	"r4eel64a.dll",
	"r4eep64a.dll",
	"racengn.dll",
	"racpldlg.dll",
	"racwmiprov.dll",
	"radardt.dll",
	"radarrs.dll",
	"radcui.dll",
	"rasadhlp.dll",
	"rasapi32.dll",
	"rasauto.dll",
	"rasctrs.dll",
	"rascustom.dll",
	"rasdiag.dll",
	"rasdlg.dll",
	"rasgcw.dll",
	"raschap.dll",
	"raschapext.dll",
	"rasman.dll",
	"rasmans.dll",
	"rasmbmgr.dll",
	"rasmediamanager.dll",
	"rasmm.dll",
	"rasmontr.dll",
	"rasplap.dll",
	"rasppp.dll",
	"rastapi.dll",
	"rastls.dll",
	"rastlsext.dll",
	"rcoinstii64.dll",
	"rdbui.dll",
	"rdpbase.dll",
	"rdpcfgex.dll",
	"rdpcore.dll",
	"rdpcorets.dll",
	"rdpencom.dll",
	"rdpendp.dll",
	"rdpnano.dll",
	"rdprelaytransport.dll",
	"rdpsaps.dll",
	"rdpserverbase.dll",
	"rdpudd.dll",
	"rdsappxhelper.dll",
	"rdsdwmdr.dll",
	"rdvgocl32.dll",
	"rdvgogl32.dll",
	"rdvgu1132.dll",
	"rdvgumd32.dll",
	"rdvvmtransport.dll",
	"rdxservice.dll",
	"rdxtaskfactory.dll",
	"reagent.dll",
	"reagenttask.dll",
	"recovery.dll",
	"regapi.dll",
	"regctrl.dll",
	"regidle.dll",
	"regsvc.dll",
	"reguwpapi.dll",
	"reinfo.dll",
	"remoteapplifetimemanagerproxystub.dll",
	"remoteaudioendpoint.dll",
	"remotepg.dll",
	"remotewipecsp.dll",
	"removablemediaprovisioningplugin.dll",
	"removedevicecontexthandler.dll",
	"removedeviceelevated.dll",
	"repdrvfs.dll",
	"reportingcsp.dll",
	"resampledmo.dll",
	"reseteng.dll",
	"resetengine.dll",
	"resetengonline.dll",
	"resourcemapper.dll",
	"resourcepolicyclient.dll",
	"resourcepolicyserver.dll",
	"resutils.dll",
	"retdec-libdwarf.dll",
	"retdec-libelf.dll",
	"rfxvmt.dll",
	"rgb9rast.dll",
	"ricu0ilm.dll",
	"riched20.dll",
	"riched32.dll",
	"rilproxy.dll",
	"rjvmdmconfig.dll",
	"rmapi.dll",
	"rmclient.dll",
	"rmsroamingsecurity.dll",
	"rnr20.dll",
	"roamingsecurity.dll",
	"rometadata.dll",
	"rotmgr.dll",
	"rp3daa64.dll",
	"rp3dht64.dll",
	"rpcepmap.dll",
	"rpcns4.dll",
	"rpcnsh.dll",
	"rpcrt4.dll",
	"rpcrtremote.dll",
	"rpcss.dll",
	"rpchttp.dll",
	"rsaenh.dll",
	"rshx32.dll",
	"rstrtmgr.dll",
	"rtcom64.dll",
	"rtdataproc64.dll",
	"rteed64a.dll",
	"rteeg64a.dll",
	"rteel64a.dll",
	"rteep64a.dll",
	"rtffilt.dll",
	"rthdasio.dll",
	"rthdasio64.dll",
	"rtkapi64.dll",
	"rtkapo64.dll",
	"rtkcfg64.dll",
	"rtkcoldr64.dll",
	"rtksmlfx.dll",
	"rtksmsettingsipc.dll",
	"rtlcpapi64.dll",
	"rtlexupd.dll",
	"rtm.dll",
	"rtmcodecs.dll",
	"rtmediaframe.dll",
	"rtmmvrortc.dll",
	"rtmpal.dll",
	"rtmpltfm.dll",
	"rtpgex64.dll",
	"rtutils.dll",
	"rtworkq.dll",
	"rulebasedds.dll",
	"samcli.dll",
	"samlib.dll",
	"samsrv.dll",
	"sas.dll",
	"sbe.dll",
	"sbeio.dll",
	"sberes.dll",
	"sbservicetrigger.dll",
	"scansetting.dll",
	"scardbi.dll",
	"scarddlg.dll",
	"scardsvr.dll",
	"scavengeui.dll",
	"scdeviceenum.dll",
	"scecli.dll",
	"scesrv.dll",
	"scilexer.dll",
	"scksp.dll",
	"scripto.dll",
	"scrobj.dll",
	"scrptadm.dll",
	"scrrun.dll",
	"sdcpl.dll",
	"sdds.dll",
	"sdengin2.dll",
	"sdfhost.dll",
	"sdhcinst.dll",
	"sdiageng.dll",
	"sdiagprv.dll",
	"sdiagschd.dll",
	"sdohlp.dll",
	"sdrsvc.dll",
	"sdshext.dll",
	"search.protocolhandler.mapi2.dll",
	"searchfolder.dll",
	"sebbackgroundmanagerpolicy.dll",
	"seclogon.dll",
	"secproc.dll",
	"secproc_isv.dll",
	"secproc_ssp.dll",
	"secproc_ssp_isv.dll",
	"secur32.dll",
	"secureassessmenthandlers.dll",
	"securebiosysprep.dll",
	"securetimeaggregator.dll",
	"security.dll",
	"securitycenterbroker.dll",
	"securitycenterbrokerps.dll",
	"securityhealthagent.dll",
	"securityhealthproxystub.dll",
	"securityhealthsso.dll",
	"sechost.dll",
	"semgrps.dll",
	"semgrsvc.dll",
	"semgrsvcpal.dll",
	"sendmail.dll",
	"sens.dll",
	"sensapi.dll",
	"sensorcustomadbalgorithm.dll",
	"sensorperformanceevents.dll",
	"sensorsapi.dll",
	"sensorsclassextension.dll",
	"sensorscpl.dll",
	"sensorservice.dll",
	"sensorsnativeapi.dll",
	"sensorsnativeapi.v2.dll",
	"sensorsutilsv2.dll",
	"sensrsvc.dll",
	"serialui.dll",
	"servdeps.dll",
	"serwvdrv.dll",
	"sessenv.dll",
	"setbcdlocale.dll",
	"setnetworklocation.dll",
	"setnetworklocationflyout.dll",
	"setproxycredential.dll",
	"settingmonitor.dll",
	"settingsenvironment.desktop.dll",
	"settingsextensibilityhandlers.dll",
	"settingshandlers_accessibility.dll",
	"settingshandlers_analogshell.dll",
	"settingshandlers_appcontrol.dll",
	"settingshandlers_appexecutionalias.dll",
	"settingshandlers_assignedaccess.dll",
	"settingshandlers_backgroundapps.dll",
	"settingshandlers_batteryusage.dll",
	"settingshandlers_capabilityaccess.dll",
	"settingshandlers_closedcaptioning.dll",
	"settingshandlers_contentdeliverymanager.dll",
	"settingshandlers_cortana.dll",
	"settingshandlers_devices.dll",
	"settingshandlers_display.dll",
	"settingshandlers_flashlight.dll",
	"settingshandlers_flights.dll",
	"settingshandlers_fonts.dll",
	"settingshandlers_gaming.dll",
	"settingshandlers_geolocation.dll",
	"settingshandlers_gpu.dll",
	"settingshandlers_hololens_environment.dll",
	"settingshandlers_inkingtypingprivacy.dll",
	"settingshandlers_inputpersonalization.dll",
	"settingshandlers_language.dll",
	"settingshandlers_managephone.dll",
	"settingshandlers_maps.dll",
	"settingshandlers_notifications.dll",
	"settingshandlers_nt.dll",
	"settingshandlers_onecore_batterysaver.dll",
	"settingshandlers_pcdisplay.dll",
	"settingshandlers_pen.dll",
	"settingshandlers_privacy.dll",
	"settingshandlers_quickactions.dll",
	"settingshandlers_region.dll",
	"settingshandlers_sharedexperiences_rome.dll",
	"settingshandlers_signinoptions.dll",
	"settingshandlers_siuf.dll",
	"settingshandlers_speechprivacy.dll",
	"settingshandlers_startup.dll",
	"settingshandlers_storagesense.dll",
	"settingshandlers_troubleshoot.dll",
	"settingshandlers_user.dll",
	"settingshandlers_useraccount.dll",
	"settingshandlers_workaccess.dll",
	"settingsync.dll",
	"settingsynccore.dll",
	"settingsyncpolicy.dll",
	"setupapi.dll",
	"setupcln.dll",
	"setupetw.dll",
	"sfapo64.dll",
	"sfc.dll",
	"sfc_os.dll",
	"sfcom.dll",
	"sfcom64.dll",
	"sfnhk64.dll",
	"sfss_apo.dll",
	"sgrmclientapi.dll",
	"sgrmenclave.dll",
	"sgrmenclave_secure.dll",
	"shacct.dll",
	"shacctprofile.dll",
	"sharedpccsp.dll",
	"sharedrealitysvc.dll",
	"sharedstartmodel.dll",
	"sharedstartmodelshim.dll",
	"sharehost.dll",
	"sharemediacpl.dll",
	"shcore.dll",
	"shdocvw.dll",
	"shell32.dll",
	"shellcommoncommonproxystub.dll",
	"shellstyle.dll",
	"shfolder.dll",
	"shgina.dll",
	"shimeng.dll",
	"shimgvw.dll",
	"shlwapi.dll",
	"shpafact.dll",
	"shsetup.dll",
	"shsvcs.dll",
	"shunimpl.dll",
	"shutdownext.dll",
	"shutdownux.dll",
	"shwebsvc.dll",
	"schannel.dll",
	"schedcli.dll",
	"schedprov.dll",
	"schedsvc.dll",
	"scsiport.sys",
	"signdrv.dll",
	"simauth.dll",
	"simcfg.dll",
	"skci.dll",
	"sl3apo64.dll",
	"slc.dll",
	"slcext.dll",
	"slcnt64.dll",
	"slprp64.dll",
	"slr100.dll",
	"sltech64.dll",
	"slwga.dll",
	"smartcardbackgroundpolicy.dll",
	"smartcardcredentialprovider.dll",
	"smartcardsimulator.dll",
	"smartscreenps.dll",
	"smbhelperclass.dll",
	"smbwmiv2.dll",
	"smiengine.dll",
	"smphost.dll",
	"smsdeviceaccessrevocation.dll",
	"smsrouter.dll",
	"smsroutersvc.dll",
	"smtpcons.dll",
	"sndvolsso.dll",
	"snmpapi.dll",
	"socialapis.dll",
	"softkbd.dll",
	"softpub.dll",
	"sortserver2003compat.dll",
	"sortwindows61.dll",
	"sortwindows6compat.dll",
	"spacebridge.dll",
	"spacecontrol.dll",
	"spatializerapo.dll",
	"spatialstore.dll",
	"spbcd.dll",
	"spectrumsyncclient.dll",
	"speechpal.dll",
	"spfileq.dll",
	"spinf.dll",
	"spmpm.dll",
	"spnet.dll",
	"spoolss.dll",
	"spopk.dll",
	"sporder.dll",
	"spp.dll",
	"sppc.dll",
	"sppcext.dll",
	"sppcomapi.dll",
	"sppcommdlg.dll",
	"sppinst.dll",
	"sppnp.dll",
	"sppobjs.dll",
	"sppwinob.dll",
	"sppwmi.dll",
	"spwinsat.dll",
	"spwizeng.dll",
	"spwizimg.dll",
	"spwizres.dll",
	"spwmp.dll",
	"spyxxhk.dll",
	"spyxxhk_amd64.dll",
	"sqlcecompact40.dll",
	"sqlceoledb40.dll",
	"sqlceqp40.dll",
	"sqlcese40.dll",
	"sqlncli11.dll",
	"sqlserverspatial.dll",
	"sqlserverspatial120.dll",
	"sqlserverspatial130.dll",
	"sqlserverspatial150.dll",
	"sqlsrv32.dll",
	"sqlunirl.dll",
	"sqlwid.dll",
	"sqlwoa.dll",
	"sqmapi.dll",
	"srclient.dll",
	"srcore.dll",
	"srevents.dll",
	"srh.dll",
	"srhelper.dll",
	"srchadmin.dll",
	"srm.dll",
	"srm_ps.dll",
	"srmclient.dll",
	"srmlib.dll",
	"srmscan.dll",
	"srmshell.dll",
	"srmstormod.dll",
	"srmtrace.dll",
	"srpapi.dll",
	"srpuxnativesnapin.dll",
	"srrstr.dll",
	"srshp64.dll",
	"srstsh64.dll",
	"srstsx64.dll",
	"srswow64.dll",
	"srumapi.dll",
	"srumsvc.dll",
	"srvcli.dll",
	"srvsvc.dll",
	"srwmi.dll",
	"sscore.dll",
	"sscoreext.dll",
	"ssdm.dll",
	"ssdpapi.dll",
	"ssdpsrv.dll",
	"ssleay32.dll",
	"sspicli.dll",
	"sspisrv.dll",
	"ssshim.dll",
	"sstpsvc.dll",
	"startmenuhelper32.dll",
	"startmenuhelper64.dll",
	"starttiledata.dll",
	"startupscan.dll",
	"staterepository.core.dll",
	"staticdictds.dll",
	"stclient.dll",
	"stdprov.dll",
	"sti.dll",
	"sti_ci.dll",
	"stobject.dll",
	"storage.dll",
	"storagecontexthandler.dll",
	"storageusage.dll",
	"storagewmi.dll",
	"storagewmi_passthru.dll",
	"storewuauth.dll",
	"storport.sys",
	"storprop.dll",
	"storsvc.dll",
	"streamci.dll",
	"structuredquery.dll",
	"sud.dll",
	"svf.dll",
	"svsvc.dll",
	"swishdbgext.dll",
	"switcherdatamodel.dll",
	"swprv.dll",
	"sxproxy.dll",
	"sxs.dll",
	"sxshared.dll",
	"sxssrv.dll",
	"sxsstore.dll",
	"symsrv.dll",
	"synccenter.dll",
	"synccontroller.dll",
	"synchostps.dll",
	"syncinfrastructure.dll",
	"syncinfrastructureps.dll",
	"syncproxy.dll",
	"syncreg.dll",
	"syncres.dll",
	"syncsettings.dll",
	"syncutil.dll",
	"sysclass.dll",
	"sysfxui.dll",
	"sysmain.dll",
	"sysntfy.dll",
	"syssetup.dll",
	"systemcpl.dll",
	"systemeventsbrokerclient.dll",
	"systemeventsbrokerserver.dll",
	"systemsettings.datamodel.dll",
	"systemsettings.deviceencryptionhandlers.dll",
	"systemsettings.handlers.dll",
	"systemsettings.settingsextensibility.dll",
	"systemsettings.useraccountshandlers.dll",
	"systemsettingsthresholdadminflowui.dll",
	"systemsupportinfo.dll",
	"t2embed.dll",
	"tabbtn.dll",
	"tabbtnex.dll",
	"tabsvc.dll",
	"tadefxapo.dll",
	"tadefxapo264.dll",
	"tapi3.dll",
	"tapi32.dll",
	"tapilua.dll",
	"tapimigplugin.dll",
	"tapiperf.dll",
	"tapisrv.dll",
	"tapisysprep.dll",
	"tapiui.dll",
	"taskapis.dll",
	"taskbarcpl.dll",
	"taskcomp.dll",
	"taskflowdataengine.dll",
	"taskschd.dll",
	"taskschdps.dll",
	"tbauth.dll",
	"tbs.dll",
	"tcbloader.dll",
	"tcpipcfg.dll",
	"tcpmib.dll",
	"tcpmon.dll",
	"tcpmonui.dll",
	"tdh.dll",
	"tdi.sys",
	"tdlmigration.dll",
	"telephonyinteractiveuser.dll",
	"telephonyinteractiveuserres.dll",
	"tellib.dll",
	"tempsignedlicenseexchangetask.dll",
	"tepeqapo64.dll",
	"termmgr.dll",
	"termsrv.dll",
	"tetheringclient.dll",
	"tetheringconfigsp.dll",
	"tetheringieprovider.dll",
	"tetheringmgr.dll",
	"tetheringservice.dll",
	"tetheringstation.dll",
	"textinputframework.dll",
	"themecpl.dll",
	"themeservice.dll",
	"themeui.dll",
	"threadpoolwinrt.dll",
	"thumbcache.dll",
	"tier2punctuations.dll",
	"tieringengineproxy.dll",
	"tiledatarepository.dll",
	"timebrokerclient.dll",
	"timebrokerserver.dll",
	"timedatemuicallback.dll",
	"timesynctask.dll",
	"tlscsp.dll",
	"tokenbinding.dll",
	"tokenbroker.dll",
	"tokenbrokerui.dll",
	"tosade.dll",
	"tosasfapo64.dll",
	"toseaeapo64.dll",
	"tossaeapo64.dll",
	"tpmcertresources.dll",
	"tpmcompc.dll",
	"tpmcoreprovisioning.dll",
	"tpmtasks.dll",
	"tpmvsc.dll",
	"tquery.dll",
	"traffic.dll",
	"transliterationranker.dll",
	"transportdsa.dll",
	"trie.dll",
	"trkwks.dll",
	"trustedsignalcredprov.dll",
	"tsbyuv.dll",
	"tscfgwmi.dll",
	"tserrredir.dll",
	"tsgqec.dll",
	"tsmf.dll",
	"tspkg.dll",
	"tspubwmi.dll",
	"tssessionux.dll",
	"tssrvlic.dll",
	"tsusbgdcoinstaller.dll",
	"tsusbredirectiongrouppolicyextension.dll",
	"tsworkspace.dll",
	"ttdloader.dll",
	"ttdloaderwow64.dll",
	"ttdplm.dll",
	"ttdrecord.dll",
	"ttdrecordcpu.dll",
	"ttdwriter.dll",
	"ttlsauth.dll",
	"ttlscfg.dll",
	"ttlsext.dll",
	"tvratings.dll",
	"twain_32.dll",
	"twext.dll",
	"twinapi.appcore.dll",
	"twinapi.dll",
	"twinui.appcore.dll",
	"twinui.dll",
	"twinui.pcshell.dll",
	"txflog.dll",
	"txfw32.dll",
	"typelib.dll",
	"tzautoupdate.dll",
	"tzres.dll",
	"tzsyncres.dll",
	"ubpm.dll",
	"ucmhc.dll",
	"ucrtbase.dll",
	"ucrtbase_enclave.dll",
	"ucrtbased.dll",
	"udhisapi.dll",
	"udwm.dll",
	"ueficsp.dll",
	"uexfat.dll",
	"ufat.dll",
	"uiamanager.dll",
	"uianimation.dll",
	"uiautomationcore.dll",
	"uiccdll.dll",
	"uicom.dll",
	"uimanagerbrokerps.dll",
	"uireng.dll",
	"uiribbon.dll",
	"uiribbonres.dll",
	"ulib.dll",
	"umb.dll",
	"umdmxfrm.dll",
	"umpnpmgr.dll",
	"umpo-overrides.dll",
	"umpo.dll",
	"umpoext.dll",
	"umpowmi.dll",
	"umrdp.dll",
	"unattend.dll",
	"unenrollhook.dll",
	"unimdmat.dll",
	"uniplat.dll",
	"unistore.dll",
	"untfs.dll",
	"updateagent.dll",
	"updatecsp.dll",
	"updatehandlers.dll",
	"updatepolicy.dll",
	"upnp.dll",
	"upnphost.dll",
	"upshared.dll",
	"urefs.dll",
	"urefsv1.dll",
	"ureg.dll",
	"url.dll",
	"urlmon.dll",
	"usbcapi.dll",
	"usbceip.dll",
	"usbd.sys",
	"usbmon.dll",
	"usbperf.dll",
	"usbpmapi.dll",
	"usbsettingshandlers.dll",
	"usbtask.dll",
	"usbui.dll",
	"user32.dll",
	"useraccountcontrolsettings.dll",
	"useractivitybroker.dll",
	"usercpl.dll",
	"userdataaccessres.dll",
	"userdataaccountapis.dll",
	"userdatalanguageutil.dll",
	"userdataplatformhelperutil.dll",
	"userdataservice.dll",
	"userdatatimeutil.dll",
	"userdatatypehelperutil.dll",
	"userdeviceregistration.dll",
	"userdeviceregistration.ngc.dll",
	"userenv.dll",
	"userinitext.dll",
	"userlanguageprofilecallback.dll",
	"userlanguagescpl.dll",
	"usermgr.dll",
	"usermgrcli.dll",
	"usermgrproxy.dll",
	"usoapi.dll",
	"usocore.dll",
	"usp10.dll",
	"ustprov.dll",
	"utcutil.dll",
	"utildll.dll",
	"uudf.dll",
	"uvcmodel.dll",
	"uwfcfgmgmt.dll",
	"uwfcsp.dll",
	"uwfservicingapi.dll",
	"uwfwmi.dll",
	"uxinit.dll",
	"uxlib.dll",
	"uxlibres.dll",
	"uxtheme.dll",
	"vac.dll",
	"van.dll",
	"vault.dll",
	"vaultcds.dll",
	"vaultcli.dll",
	"vaultroaming.dll",
	"vaultsvc.dll",
	"vbajet32.dll",
	"vbsapi.dll",
	"vbscript.dll",
	"vcamp110.dll",
	"vcamp120.dll",
	"vcamp140.dll",
	"vcamp140d.dll",
	"vcardparser.dll",
	"vccorlib110.dll",
	"vccorlib120.dll",
	"vccorlib140.dll",
	"vccorlib140d.dll",
	"vcomp100.dll",
	"vcomp110.dll",
	"vcomp120.dll",
	"vcomp140.dll",
	"vcomp140d.dll",
	"vcruntime140.dll",
	"vcruntime140d.dll",
	"vdmdbg.dll",
	"vds_ps.dll",
	"vdsbas.dll",
	"vdsdyn.dll",
	"vdsutil.dll",
	"vdsvd.dll",
	"vdswmi.dll",
	"verifier.dll",
	"version.dll",
	"vertdll.dll",
	"vfbasics.dll",
	"vfcompat.dll",
	"vfcuzz.dll",
	"vfluapriv.dll",
	"vfnet.dll",
	"vfntlmless.dll",
	"vfnws.dll",
	"vfprint.dll",
	"vfprintpthelper.dll",
	"vfrdvcompat.dll",
	"vfuprov.dll",
	"vfwwdm32.dll",
	"vid.dll",
	"videohandlers.dll",
	"videoprt.sys",
	"vidreszr.dll",
	"viewprov.dll",
	"virtdisk.dll",
	"vm3ddevapi.dll",
	"vm3ddevapi64.dll",
	"vm3dgl.dll",
	"vm3dgl64.dll",
	"vm3dglhelper.dll",
	"vm3dglhelper64.dll",
	"vm3dum-debug.dll",
	"vm3dum-stats.dll",
	"vm3dum.dll",
	"vm3dum_10-debug.dll",
	"vm3dum_10-stats.dll",
	"vm3dum_10.dll",
	"vm3dum_loader.dll",
	"vm3dum64-debug.dll",
	"vm3dum64-stats.dll",
	"vm3dum64.dll",
	"vm3dum64_10-debug.dll",
	"vm3dum64_10-stats.dll",
	"vm3dum64_10.dll",
	"vm3dum64_loader.dll",
	"vmapplicationhealthmonitorproxy.dll",
	"vmbuspipe.dll",
	"vmbkmcl.sys",
	"vmdevicehost.dll",
	"vmguestlib.dll",
	"vmguestlibjava.dll",
	"vmhgfs.dll",
	"vmictimeprovider.dll",
	"vmnetbridge.dll",
	"vmrdvcore.dll",
	"vmstaging.dll",
	"vmwsu_v1_0.dll",
	"vnetinst.dll",
	"vnetlib64.dll",
	"vocabroaminghandler.dll",
	"voiceactivationmanager.dll",
	"voiprt.dll",
	"vpnclientpsprovider.dll",
	"vpnike.dll",
	"vpnikeapi.dll",
	"vpnsohdesktop.dll",
	"vpnv2csp.dll",
	"vrfcore.dll",
	"vscmgrps.dll",
	"vscover140.dll",
	"vscover150.dll",
	"vscover150.dll",
	"vsd3drefdebug.dll",
	"vsd3dwarpdebug.dll",
	"vsgraphicscapture.dll",
	"vsgraphicsexperiment.dll",
	"vsgraphicshelper.dll",
	"vsgraphicsproxystub.dll",
	"vsocklib.dll",
	"vsperf140.dll",
	"vsperf150.dll",
	"vss_ps.dll",
	"vssapi.dll",
	"vsstrace.dll",
	"vsswmi.dll",
	"w32time.dll",
	"w32topl.dll",
	"waasassessment.dll",
	"waasmediccapsule.dll",
	"waasmedicps.dll",
	"waasmedicsvc.dll",
	"wabsyncprovider.dll",
	"walletbackgroundserviceproxy.dll",
	"walletproxy.dll",
	"walletservice.dll",
	"watchdog.sys",
	"wavemsp.dll",
	"wavesguilib64.dll",
	"wbemcntl.dll",
	"wbemcomn.dll",
	"wbemcons.dll",
	"wbemcore.dll",
	"wbemdisp.dll",
	"wbemess.dll",
	"wbemprox.dll",
	"wbemsvc.dll",
	"wbiosrvc.dll",
	"wc_storage.dll",
	"wcimage.dll",
	"wcl.dll",
	"wcletw.dll",
	"wclpowrprof.dll",
	"wclsqm.dll",
	"wclunicode.dll",
	"wclwdi.dll",
	"wcmapi.dll",
	"wcmcsp.dll",
	"wcmsvc.dll",
	"wcnapi.dll",
	"wcncsvc.dll",
	"wcneapauthproxy.dll",
	"wcneappeerproxy.dll",
	"wcnnetsh.dll",
	"wcnwiz.dll",
	"wdacwmiprov.dll",
	"wdc.dll",
	"wdfldr.sys",
	"wdi.dll",
	"wdigest.dll",
	"wdscore.dll",
	"webauthn.dll",
	"webcamui.dll",
	"webclnt.dll",
	"webcheck.dll",
	"webio.dll",
	"webplatstorageserver.dll",
	"webruntimemanager.dll",
	"webservices.dll",
	"websocket.dll",
	"wecapi.dll",
	"wecsvc.dll",
	"wephostsvc.dll",
	"wer.dll",
	"werconcpl.dll",
	"wercplsupport.dll",
	"werdiagcontroller.dll",
	"weretw.dll",
	"wersvc.dll",
	"werui.dll",
	"wevtapi.dll",
	"wevtfwd.dll",
	"wevtsvc.dll",
	"wfapigp.dll",
	"wfascim.dll",
	"wfdprov.dll",
	"wfdsconmgr.dll",
	"wfdsconmgrsvc.dll",
	"wfhc.dll",
	"wfsr.dll",
	"whealogr.dll",
	"whhelper.dll",
	"wiaaut.dll",
	"wiadefui.dll",
	"wiadss.dll",
	"wiaextensionhost64.dll",
	"wiarpc.dll",
	"wiascanprofiles.dll",
	"wiaservc.dll",
	"wiashext.dll",
	"wiatrace.dll",
	"wificloudstore.dll",
	"wificonfigsp.dll",
	"wificonnapi.dll",
	"wifidiscoveryplugin.dll",
	"wifidisplay.dll",
	"wifinetworkmanager.dll",
	"wifionboardingplugin.dll",
	"wifiprofilessettinghandler.dll",
	"wimgapi.dll",
	"win32_deviceguard.dll",
	"win32_encryptablevolume.dll",
	"win32_tpm.dll",
	"win32appinventorycsp.dll",
	"win32compatibilityappraisercsp.dll",
	"win32k.sys",
	"win32spl.dll",
	"win32u.dll",
	"winbio.dll",
	"winbiodatamodel.dll",
	"winbioext.dll",
	"winbrand.dll",
	"wincorlib.dll",
	"wincredprovider.dll",
	"wincredui.dll",
	"windowmanagement.dll",
	"windows.accountscontrol.dll",
	"windows.ai.machinelearning.dll",
	"windows.ai.machinelearning.preview.dll",
	"windows.applicationmodel.background.systemeventsbroker.dll",
	"windows.applicationmodel.background.timebroker.dll",
	"windows.applicationmodel.core.dll",
	"windows.applicationmodel.datatransfer.dll",
	"windows.applicationmodel.dll",
	"windows.applicationmodel.lockscreen.dll",
	"windows.applicationmodel.store.dll",
	"windows.applicationmodel.store.preview.dosettings.dll",
	"windows.applicationmodel.store.testingframework.dll",
	"windows.applicationmodel.wallet.dll",
	"windows.clouddomainjoinaug.proxystub.dll",
	"windows.cloudstore.dll",
	"windows.cloudstore.schema.desktopshell.dll",
	"windows.cloudstore.schema.shell.dll",
	"windows.cortana.analog.dll",
	"windows.cortana.analog.proxystub.dll",
	"windows.cortana.desktop.dll",
	"windows.cortana.onecore.dll",
	"windows.cortana.pal.desktop.dll",
	"windows.cortana.proxystub.dll",
	"windows.data.activities.dll",
	"windows.data.pdf.dll",
	"windows.devices.alljoyn.dll",
	"windows.devices.background.dll",
	"windows.devices.background.ps.dll",
	"windows.devices.bluetooth.dll",
	"windows.devices.custom.dll",
	"windows.devices.custom.ps.dll",
	"windows.devices.enumeration.dll",
	"windows.devices.haptics.dll",
	"windows.devices.humaninterfacedevice.dll",
	"windows.devices.lights.dll",
	"windows.devices.lowlevel.dll",
	"windows.devices.midi.dll",
	"windows.devices.perception.dll",
	"windows.devices.picker.dll",
	"windows.devices.pointofservice.dll",
	"windows.devices.portable.dll",
	"windows.devices.printers.dll",
	"windows.devices.printers.extensions.dll",
	"windows.devices.radios.dll",
	"windows.devices.scanners.dll",
	"windows.devices.sensors.dll",
	"windows.devices.serialcommunication.dll",
	"windows.devices.smartcards.dll",
	"windows.devices.smartcards.phone.dll",
	"windows.devices.usb.dll",
	"windows.devices.wifi.dll",
	"windows.devices.wifidirect.dll",
	"windows.energy.dll",
	"windows.gaming.input.dll",
	"windows.gaming.preview.dll",
	"windows.gaming.ui.gamebar.dll",
	"windows.gaming.xboxlive.storage.dll",
	"windows.globalization.dll",
	"windows.globalization.fontgroups.dll",
	"windows.globalization.phonenumberformatting.dll",
	"windows.graphics.display.brightnessoverride.dll",
	"windows.graphics.display.displayenhancementoverride.dll",
	"windows.graphics.dll",
	"windows.graphics.printing.3d.dll",
	"windows.graphics.printing.dll",
	"windows.graphics.printing.workflow.dll",
	"windows.graphics.printing.workflow.native.dll",
	"windows.help.runtime.dll",
	"windows.immersiveshell.serviceprovider.dll",
	"windows.internal.adaptivecards.xamlcardrenderer.dll",
	"windows.internal.bluetooth.dll",
	"windows.internal.capturepicker.desktop.dll",
	"windows.internal.capturepicker.dll",
	"windows.internal.devices.sensors.dll",
	"windows.internal.feedback.analog.dll",
	"windows.internal.feedback.analog.proxystub.dll",
	"windows.internal.graphics.display.displayenhancementmanagement.dll",
	"windows.internal.management.dll",
	"windows.internal.management.secureassessment.dll",
	"windows.internal.platformextension.devicepickerexperience.dll",
	"windows.internal.platformextension.miracastbannerexperience.dll",
	"windows.internal.predictionunit.dll",
	"windows.internal.security.attestation.deviceattestation.dll",
	"windows.internal.securitymitigationsbroker.dll",
	"windows.internal.shell.broker.dll",
	"windows.internal.shellcommon.accountscontrolexperience.dll",
	"windows.internal.shellcommon.appresolvermodal.dll",
	"windows.internal.shellcommon.broker.dll",
	"windows.internal.shellcommon.filepickerexperiencemem.dll",
	"windows.internal.shellcommon.printexperience.dll",
	"windows.internal.shellcommon.shareexperience.dll",
	"windows.internal.shellcommon.shellposition.dll",
	"windows.internal.shellcommon.tokenbrokermodal.dll",
	"windows.internal.signals.dll",
	"windows.internal.ui.bioenrollment.proxystub.dll",
	"windows.internal.ui.logon.proxystub.dll",
	"windows.management.provisioning.proxystub.dll",
	"windows.management.secureassessment.cfgprovider.dll",
	"windows.management.secureassessment.diagnostics.dll",
	"windows.management.service.dll",
	"windows.management.workplace.dll",
	"windows.management.workplace.workplacesettings.dll",
	"windows.media.audio.dll",
	"windows.media.backgroundmediaplayback.dll",
	"windows.media.devices.dll",
	"windows.media.dll",
	"windows.media.editing.dll",
	"windows.media.faceanalysis.dll",
	"windows.media.import.dll",
	"windows.media.mediacontrol.dll",
	"windows.media.mixedrealitycapture.dll",
	"windows.media.ocr.dll",
	"windows.media.playback.backgroundmediaplayer.dll",
	"windows.media.playback.mediaplayer.dll",
	"windows.media.playback.proxystub.dll",
	"windows.media.protection.playready.dll",
	"windows.media.renewal.dll",
	"windows.media.speech.dll",
	"windows.media.speech.uxres.dll",
	"windows.media.streaming.dll",
	"windows.media.streaming.ps.dll",
	"windows.mirage.dll",
	"windows.mirage.internal.capture.pipeline.proxystub.dll",
	"windows.mirage.internal.dll",
	"windows.networking.backgroundtransfer.backgroundmanagerpolicy.dll",
	"windows.networking.backgroundtransfer.contentprefetchtask.dll",
	"windows.networking.backgroundtransfer.dll",
	"windows.networking.connectivity.dll",
	"windows.networking.dll",
	"windows.networking.hostname.dll",
	"windows.networking.networkoperators.esim.dll",
	"windows.networking.networkoperators.hotspotauthentication.dll",
	"windows.networking.proximity.dll",
	"windows.networking.servicediscovery.dnssd.dll",
	"windows.networking.sockets.pushenabledapplication.dll",
	"windows.networking.ux.eaprequesthandler.dll",
	"windows.networking.vpn.dll",
	"windows.networking.xboxlive.proxystub.dll",
	"windows.payments.dll",
	"windows.perception.stub.dll",
	"windows.security.authentication.identity.provider.dll",
	"windows.security.authentication.onlineid.dll",
	"windows.security.authentication.web.core.dll",
	"windows.security.credentials.ui.credentialpicker.dll",
	"windows.security.credentials.ui.userconsentverifier.dll",
	"windows.security.integrity.dll",
	"windows.services.targetedcontent.dll",
	"windows.sharedpc.accountmanager.dll",
	"windows.sharedpc.credentialprovider.dll",
	"windows.shell.bluelightreduction.dll",
	"windows.shell.search.urihandler.dll",
	"windows.shell.servicehostbuilder.dll",
	"windows.shell.startlayoutpopulationevents.dll",
	"windows.staterepository.dll",
	"windows.staterepositorybroker.dll",
	"windows.staterepositoryclient.dll",
	"windows.staterepositorycore.dll",
	"windows.staterepositoryps.dll",
	"windows.staterepositoryupgrade.dll",
	"windows.storage.applicationdata.dll",
	"windows.storage.compression.dll",
	"windows.storage.dll",
	"windows.storage.onecore.dll",
	"windows.storage.search.dll",
	"windows.system.diagnostics.dll",
	"windows.system.diagnostics.telemetry.platformtelemetryclient.dll",
	"windows.system.diagnostics.tracereporting.platformdiagnosticactions.dll",
	"windows.system.launcher.dll",
	"windows.system.profile.hardwareid.dll",
	"windows.system.profile.platformdiagnosticsandusagedatasettings.dll",
	"windows.system.profile.retailinfo.dll",
	"windows.system.profile.systemid.dll",
	"windows.system.profile.systemmanufacturers.dll",
	"windows.system.remotedesktop.dll",
	"windows.system.systemmanagement.dll",
	"windows.system.userdeviceassociation.dll",
	"windows.system.userprofile.diagnosticssettings.dll",
	"windows.ui.accessibility.dll",
	"windows.ui.appdefaults.dll",
	"windows.ui.biofeedback.dll",
	"windows.ui.blockedshutdown.dll",
	"windows.ui.core.textinput.dll",
	"windows.ui.cred.dll",
	"windows.ui.creddialogcontroller.dll",
	"windows.ui.dll",
	"windows.ui.immersive.dll",
	"windows.ui.input.inking.analysis.dll",
	"windows.ui.input.inking.dll",
	"windows.ui.internal.input.expressiveinput.dll",
	"windows.ui.internal.input.expressiveinput.resource.dll",
	"windows.ui.logon.dll",
	"windows.ui.networkuxcontroller.dll",
	"windows.ui.picturepassword.dll",
	"windows.ui.search.dll",
	"windows.ui.shell.dll",
	"windows.ui.storage.dll",
	"windows.ui.xaml.controls.dll",
	"windows.ui.xaml.dll",
	"windows.ui.xaml.inkcontrols.dll",
	"windows.ui.xaml.maps.dll",
	"windows.ui.xaml.phone.dll",
	"windows.ui.xaml.resources.common.dll",
	"windows.ui.xaml.resources.rs1.dll",
	"windows.ui.xaml.resources.rs2.dll",
	"windows.ui.xaml.resources.rs3.dll",
	"windows.ui.xaml.resources.rs4.dll",
	"windows.ui.xaml.resources.rs5.dll",
	"windows.ui.xaml.resources.th.dll",
	"windows.ui.xaml.resources.win81.dll",
	"windows.ui.xaml.resources.win8rtm.dll",
	"windows.ui.xamlhost.dll",
	"windows.warp.jitservice.dll",
	"windows.web.diagnostics.dll",
	"windows.web.dll",
	"windows.web.http.dll",
	"windowscodecs.dll",
	"windowscodecsext.dll",
	"windowscodecsraw.dll",
	"windowsdefaultheatprocessor.dll",
	"windowsdefenderapplicationguardcsp.dll",
	"windowsinternal.composableshell.composerframework.dll",
	"windowsinternal.composableshell.desktophosting.dll",
	"windowslivelogin.dll",
	"windowsperformancerecordercontrol.dll",
	"winethc.dll",
	"winfax.dll",
	"winhttp.dll",
	"winhttpcom.dll",
	"winhvemulation.dll",
	"winhvplatform.dll",
	"wininet.dll",
	"wininetlui.dll",
	"wininitext.dll",
	"winipcfile.dll",
	"winipcsecproc.dll",
	"winipsec.dll",
	"winjson.dll",
	"winlangdb.dll",
	"winlogonext.dll",
	"winmde.dll",
	"winmgmtr.dll",
	"winml.dll",
	"winmm.dll",
	"winmmbase.dll",
	"winmsipc.dll",
	"winmsoirmprotector.dll",
	"winnlsres.dll",
	"winnsi.dll",
	"winopcirmprotector.dll",
	"winquic.dll",
	"winrnr.dll",
	"winrscmd.dll",
	"winrsmgr.dll",
	"winrssrv.dll",
	"winrttracing.dll",
	"winsatapi.dll",
	"winscard.dll",
	"winsetupui.dll",
	"winshfhc.dll",
	"winsku.dll",
	"winsockhc.dll",
	"winspool.drv",
	"winsqlite3.dll",
	"winsrpc.dll",
	"winsrv.dll",
	"winsrvext.dll",
	"winsta.dll",
	"winsync.dll",
	"winsyncmetastore.dll",
	"winsyncproviders.dll",
	"wintrust.dll",
	"wintypes.dll",
	"winusb.dll",
	"wirednetworkcsp.dll",
	"wisp.dll",
	"witnesswmiv2provider.dll",
	"wkscli.dll",
	"wkspbrokerax.dll",
	"wksprtps.dll",
	"wkssvc.dll",
	"wlanapi.dll",
	"wlancfg.dll",
	"wlanconn.dll",
	"wlandlg.dll",
	"wlangpui.dll",
	"wlanhc.dll",
	"wlanhlp.dll",
	"wlanmediamanager.dll",
	"wlanmm.dll",
	"wlanmsm.dll",
	"wlanpref.dll",
	"wlanradiomanager.dll",
	"wlansec.dll",
	"wlansvc.dll",
	"wlansvcpal.dll",
	"wlanui.dll",
	"wlanutil.dll",
	"wldap32.dll",
	"wldp.dll",
	"wlgpclnt.dll",
	"wlidcli.dll",
	"wlidcredprov.dll",
	"wlidfdp.dll",
	"wlidnsp.dll",
	"wlidprov.dll",
	"wlidres.dll",
	"wlidsvc.dll",
	"wmadmod.dll",
	"wmadmoe.dll",
	"wmalfxgfxdsp.dll",
	"wmasf.dll",
	"wmcodecdspps.dll",
	"wmdmlog.dll",
	"wmdmps.dll",
	"wmdrmsdk.dll",
	"wmerror.dll",
	"wmi.dll",
	"wmiapres.dll",
	"wmiaprpl.dll",
	"wmiclnt.dll",
	"wmicmiplugin.dll",
	"wmicookr.dll",
	"wmidcom.dll",
	"wmidcprv.dll",
	"wmidx.dll",
	"wmilib.sys",
	"wmipcima.dll",
	"wmipdfs.dll",
	"wmipdskq.dll",
	"wmiperfclass.dll",
	"wmiperfinst.dll",
	"wmipicmp.dll",
	"wmipiprt.dll",
	"wmipjobj.dll",
	"wmiprop.dll",
	"wmiprov.dll",
	"wmiprvsd.dll",
	"wmipsess.dll",
	"wmisvc.dll",
	"wmitimep.dll",
	"wmitomi.dll",
	"wmiutils.dll",
	"wmnetmgr.dll",
	"wmp.dll",
	"wmpdui.dll",
	"wmpdxm.dll",
	"wmpeffects.dll",
	"wmphoto.dll",
	"wmploc.dll",
	"wmpps.dll",
	"wmpshell.dll",
	"wmsgapi.dll",
	"wmspdmod.dll",
	"wmspdmoe.dll",
	"wmvcore.dll",
	"wmvdecod.dll",
	"wmvdspa.dll",
	"wmvencod.dll",
	"wmvsdecd.dll",
	"wmvsencd.dll",
	"wmvxencd.dll",
	"woftasks.dll",
	"wofutil.dll",
	"wordbreakers.dll",
	"workfolderscontrol.dll",
	"workfoldersgpext.dll",
	"workfoldersres.dll",
	"workfoldersshell.dll",
	"workfolderssvc.dll",
	"wosc.dll",
	"wow32.dll",
	"wow64.dll",
	"wow64cpu.dll",
	"wow64win.dll",
	"wpaxholder.dll",
	"wpbcreds.dll",
	"wpc.dll",
	"wpcap.dll",
	"wpcapi.dll",
	"wpcdesktopmonsvc.dll",
	"wpcrefreshtask.dll",
	"wpcwebfilter.dll",
	"wpd_ci.dll",
	"wpdbusenum.dll",
	"wpdmtp.dll",
	"wpdmtpus.dll",
	"wpdshext.dll",
	"wpdshserviceobj.dll",
	"wpdsp.dll",
	"wpnapps.dll",
	"wpnclient.dll",
	"wpncore.dll",
	"wpninprc.dll",
	"wpnprv.dll",
	"wpnservice.dll",
	"wpnsruprov.dll",
	"wpnuserservice.dll",
	"wpportinglibrary.dll",
	"wpprecorderum.dll",
	"wptaskscheduler.dll",
	"wpx.dll",
	"wpprecorder.sys",
	"ws2_32.dll",
	"ws2help.dll",
	"wscapi.dll",
	"wscinterop.dll",
	"wscisvif.dll",
	"wsclient.dll",
	"wscproxystub.dll",
	"wscsvc.dll",
	"wsdapi.dll",
	"wsdchngr.dll",
	"wsdmon.dll",
	"wsdprintproxy.dll",
	"wsdscanproxy.dll",
	"wsecedit.dll",
	"wsepno.dll",
	"wshbth.dll",
	"wshcon.dll",
	"wshelper.dll",
	"wshext.dll",
	"wshhyperv.dll",
	"wship6.dll",
	"wshirda.dll",
	"wshqos.dll",
	"wshrm.dll",
	"wshtcpip.dll",
	"wshunix.dll",
	"wslapi.dll",
	"wsmagent.dll",
	"wsmanmigrationplugin.dll",
	"wsmauto.dll",
	"wsmplpxy.dll",
	"wsmres.dll",
	"wsmsvc.dll",
	"wsmwmipl.dll",
	"wsnmp32.dll",
	"wsock32.dll",
	"wsp_fs.dll",
	"wsp_health.dll",
	"wsp_sr.dll",
	"wsplib.dll",
	"wtsapi32.dll",
	"wuapi.dll",
	"wuaprovider.dll",
	"wuaueng.dll",
	"wuceffects.dll",
	"wudfcoinstaller.dll",
	"wudfplatform.dll",
	"wudfsmcclassext.dll",
	"wudfx.dll",
	"wudfx02000.dll",
	"wudriver.dll",
	"wups.dll",
	"wups2.dll",
	"wuuhext.dll",
	"wuuhosdeployment.dll",
	"wvc.dll",
	"wwaapi.dll",
	"wwaext.dll",
	"wwanapi.dll",
	"wwancfg.dll",
	"wwanconn.dll",
	"wwanhc.dll",
	"wwanmm.dll",
	"wwanpref.dll",
	"wwanprotdim.dll",
	"wwanradiomanager.dll",
	"wwansvc.dll",
	"wwapi.dll",
	"xamltilerender.dll",
	"xaudio2_8.dll",
	"xaudio2_9.dll",
	"xbgmengine.dll",
	"xblauthmanager.dll",
	"xblauthmanagerproxy.dll",
	"xblauthtokenbrokerext.dll",
	"xblgamesave.dll",
	"xblgamesaveext.dll",
	"xblgamesaveproxy.dll",
	"xboxgipradiomanager.dll",
	"xboxgipsvc.dll",
	"xboxgipsynthetic.dll",
	"xboxnetapisvc.dll",
	"xceed.compression.formats.v5.4.dll",
	"xceed.compression.v5.4.dll",
	"xceed.filesystem.v5.4.dll",
	"xceed.zip.v5.4.dll",
	"xginterop.dll",
	"xgwin.dll",
	"xinput1_4.dll",
	"xinput9_1_0.dll",
	"xinputuap.dll",
	"xmlfilter.dll",
	"xmllite.dll",
	"xmlprovi.dll",
	"xolehlp.dll",
	"xpsdocumenttargetprint.dll",
	"xpsfilt.dll",
	"xpsgdiconverter.dll",
	"xpsprint.dll",
	"xpsrasterservice.dll",
	"xpsservices.dll",
	"xpsshhdr.dll",
	"xwizards.dll",
	"xwreg.dll",
	"xwtpdui.dll",
	"xwtpw32.dll",
	"zipcontainer.dll",
	"zipfldr.dll",
	"ztrace_maps.dll",
};

}	// namespace retdec
}	// namespace fileformat
