Keystone Engine
==============

[![Build Status](https://travis-ci.org/keystone-engine/keystone.svg?branch=master)](https://travis-ci.org/keystone-engine/keystone)
[![Build Status](https://semaphoreci.com/api/v1/aquynh/keystone/branches/master/badge.svg)](https://semaphoreci.com/aquynh/keystone)
[![Build status](https://ci.appveyor.com/api/projects/status/c27slvyrijiejvqs?svg=true)](https://ci.appveyor.com/project/aquynh/keystone)

Keystone is a lightweight multi-platform, multi-architecture assembler framework.
It offers some unparalleled features:

- Multi-architecture, with support for Arm, Arm64 (AArch64/Armv8), Hexagon, Mips, PowerPC, Sparc, SystemZ & X86 (include 16/32/64bit).
- Clean/simple/lightweight/intuitive architecture-neutral API.
- Implemented in C/C++ languages, with bindings for Masm, C#, PowerShell, Perl, Python, NodeJS, Ruby, Go, Rust, Haskell, VB6 & OCaml available.
- Native support for Windows & \*nix (with Mac OSX, Linux, *BSD & Solaris confirmed).
- Thread-safe by design.
- Open source - with a dual license.

Keystone is based on LLVM, but it goes much further with [a lot more to offer](/docs/beyond_llvm.md).

Further information is available at http://www.keystone-engine.org


License
-------

Keystone is available under a dual license:

- Version 2 of the GNU General Public License (GPLv2). (I.e. Without the "any later version" clause.).
  License information can be found in the [COPYING file](COPYING) and the [EXCEPTIONS-CLIENT file](EXCEPTIONS-CLIENT).

  This combination allows almost all of open source projects to use Keystone without conflicts.

- For commercial usage in production environments, contact the authors of Keystone to buy a royalty-free license.

  See [LICENSE-COM.TXT](LICENSE-COM.TXT) for more information.


Compilation & Docs
------------------

See [COMPILE.md](docs/COMPILE.md) file for how to compile and install Keystone.

More documentation is available in [docs/README.md](docs/README.md).


Contact
-------

[Contact us](http://www.keystone-engine.org/contact/) via mailing list, email or twitter for any questions.


Contribute
----------

Keystone is impossible without generous support from [our sponsors](/SPONSORS.TXT). We cannot thank them enough! 

[CREDITS.TXT](CREDITS.TXT) records other important contributors of our project.

If you want to contribute, please pick up something from our [Github issues](https://github.com/keystone-engine/keystone/issues).

We also maintain a list of more challenged problems in a [TODO list](https://github.com/keystone-engine/keystone/wiki/TODO).


