/*
 *   retail - a logfile monitoring utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Yee ole includes (I put this all in one file for my sanity) */
#include "include.h"

int open_infile(char *fname) {
	/* open our input file read only */
	in_file = fopen(fname, "r");
	if(in_file == NULL) { /* oops, we got problems */
		perror(fname);
		retval = RV_OPEN;
	} 
	/* if we're debugging, and we succeeded in opening that file, print to screen */
	if(debug && in_file != NULL) fprintf(stderr, "opened file: %s\n", fname);
	return retval;
}

int open_stfile_getfname(char *fname, long int mal_size) {
	char *ptr;
	char *new_fname;
	
	new_fname = malloc(mal_size);
	if(new_fname == NULL) {
		retval = RV_FATAL;
		perror("malloc");
		exit(retval);
	}
	
	/* if we got a prefix, then set that up */
	if(prefix != NULL) {
		/* put prefix into new_fname */
		strcpy(new_fname, prefix);
		/* if user didn't put trailing / do it for them */
		if(new_fname[strlen(new_fname - 1)] != '/') {
			strcat(new_fname, "/");
		}
		/* see if we got a full path in the current fname */
		ptr = strrchr(fname, '/');
		if(ptr != NULL) { /* if we did, we need to strip that */
			++ptr; /* move one past the / */
			strcat(new_fname, ptr); 	/* add it to new_fname */
			strcpy(fname, new_fname);	/* put new_fname where fname used to be */
		}
	}
	
	
	/* we'll make sure we got a '.' at the start of suffix */
	if(suffix[0] != '.') {
		strcat(fname, ".");
	}

	/* we'll add the suffix to the fname */
	strcat(fname, suffix);

	if(debug) fprintf(stderr, "st_file: %s\n", fname);
	
	return retval;
}

/* open our status file carefully */
int open_stfile(char *fname) {
	
	long int mal_size = 0;	/* how much memory do we malloc to store the new filename in?	*/
	/* figure out how much space we need to malloc() for the offset filename */
	if(prefix != NULL) {
		/* ok, we had a prefix, add it to the mix */
		mal_size = (strlen(fname) + strlen(suffix) + strlen(prefix) + 32);
	} else {
		/* no prefix, don't try to strlen(NULL), it'll crash if yee do :)	*/
		mal_size = (strlen(fname) + strlen(suffix) + 32);
	}
	
	/* malloc enough space for this guy */
	st_filename = malloc(mal_size);
	/* standard malloc retval thingy */
	if(st_filename == NULL) {
		retval = RV_FATAL;
		perror("malloc");
		exit(retval);
	}

	/* put the filename into our temp variable name */
	strcpy(st_filename, fname);

	/* we see if we can get a valid filename here; set retval accordingly */
	retval = open_stfile_getfname(st_filename, mal_size);

	/* open that suckka */
	in_stat = fopen(st_filename, "a+");
	if(in_stat == NULL) {
		/* eeek!! couldn't open!! FAIL FAIL FAIL!! */
		retval = RV_FATAL;
		perror(st_filename);
		exit(retval);
	}
	
	return retval;
}
