# Rekall Memory Forensics
#
# Copyright 2013 Google Inc. All Rights Reserved.
#
# Authors:
# Michael Cohen <scudette@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

"""Tests for the devicetree plugin."""

from rekall import testlib


class TestDeviceTree(testlib.RekallBaseUnitTestCase):
    """Test the devicetree module."""

    PARAMETERS = dict(commandline="devicetree")

    def testDeviceTree(self):
        previous = self.baseline['output']
        current = self.current['output']

        self.assertListEqual(previous, current)


class TestDriverIrp(testlib.RekallBaseUnitTestCase):
    """Test the driverirp module."""

    PARAMETERS = dict(commandline="driverirp")

    def testDriverIrp(self):
        previous = self.FilterOutput(self.baseline['output'], "IRP_MJ_")
        current = self.FilterOutput(self.current['output'], "IRP_MJ_")

        self.assertListEqual(previous, current)
