/* Free Foundation Classes for XML ver.0.1.3
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcxml: ffcsax.h,v 1.8.3 2001/09/17 22:57:51 Toshihiro Inoue Exp $
 */

#ifndef _FFCSAX_H_
#define _FFCSAX_H_

#include <ffcdictstring.h>
#include <ffcstring.h>


/**
  SAX: Simple API for XML
*/

class FFCSAX
{
public:
  inline void setLetter(bool f) { letter = f; }
  inline FFCString getVersion() const { return version; }
  inline FFCString getEncoding() const { return encoding; }
  
public:
  FFCSAX();
  virtual ~FFCSAX();
  virtual FFCSAX* newObject();
  virtual void init();
  void parse(char ch);
  void parse(const FFCString& str);
  void parse(const char* str, int len = -1);
  virtual void startDocument();
  virtual void endDocument();
  virtual void startElement(const FFCString& name, const FFCDictString& atts);
  virtual void endElement(const FFCString& name);
  virtual void characters(const FFCString& text);
  
protected:
  void parseElement();
  
private:
  void __init_class__();
  
protected:
  bool letter;
  FFCString element;
  FFCString chars;
  int state;
  FFCString version;
  FFCString encoding;
};

#endif // _FFCSAX_H_
