/***************************************************************************
                               queryresult.cpp
                             -------------------
    copyright            : (C) 2003 by Giancarlo Formicuccia
    email                : ilsensine@inwind.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "queryresult.h"

FXIMPLEMENT(FXQueryForm, FXDialogBox, NULL, 0);

FXQueryForm::FXQueryForm(FXWindow *owner, FXDatabaseQuery *hQ): FXDialogBox(owner, "Query result", DECOR_ALL, 0, 0, 400, 400) {
  FXint x;
  FXint rPos;
  this->hQ = hQ;
  Cols = hQ->fieldCount();
  table = new FXTable(this, 0, Cols, NULL, 0, TABLE_COL_SIZABLE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  table->setTableSize(1, Cols);
  for(x=0; x<Cols; ++x) {
    table->setItemText(0, x, hQ->operator[](x).name());
    table->getItem(0, x)->setButton(TRUE);
  }
  rPos = 0;
  if(hQ->recordCount()) {
    while(1) {
      ++rPos;
      table->insertRows(rPos);
      for(x=0; x<Cols; ++x)
        table->setItemText(rPos, x, hQ->operator[](x).getValue().asFXString().trim());
      if(!hQ->moveNext()) break;
    }
  }
}
