/********************************************************************************
*                                                                               *
*                  Utility functions                                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
using namespace FX;
#include "fxexdefs.h"
using namespace FXEX;

// Allows GNU autoconfigure to find FOXEX
extern "C" FXAPI void fxfindfoxex(void) {}

namespace FXEX {

// fxex version number
const FXuchar FXUtils::fxexversion[3]={FOXEX_MAJOR_VERSION,FOXEX_MINOR_VERSION,FOXEX_PATCH_LEVEL};

#if defined(WIN32)
// get_time_now - this formula should work until 1st March 2100
static void FXUtils::get_time_now(unsigned long* abs_sec, unsigned long* abs_nsec) {
  static int days_in_preceding_months[12]={0,31,59,90,120,151,181,212,243,273,304,334};
  static int days_in_preceding_months_leap[12]={0,31,60,91,121,152,182,213,244,274,305,335};
  SYSTEMTIME st;
  GetSystemTime(&st);
  *abs_nsec = st.wMilliseconds * 1000000;
  DWORD days = ((st.wYear - 1970) * 365 + (st.wYear - 1969) / 4 + ((st.wYear % 4)
      ? days_in_preceding_months[st.wMonth - 1]
      : days_in_preceding_months_leap[st.wMonth - 1])
      + st.wDay - 1);
  *abs_sec = st.wSecond + 60 * (st.wMinute + 60 * (st.wHour + 24 * days));
  }

// convert secs/nsecs to a timeout value
static DWORD FXUtils::get_timeout(unsigned long secs, unsigned long nsecs,DWORD default_to){
  DWORD timeout=default_to;
  if (secs != 0 && nsecs != 0 ){
    unsigned long now_sec, now_nsec;
    FXUtils::get_time_now(&now_sec, &now_nsec);
    if ((secs <= now_sec) && ((secs < now_sec) || (nanosecs < now_nsec))) timeout = 0;
    else {
      timeout = (secs-now_sec) * 1000;
      if( nanosecs < now_nsec )  timeout -= (now_nsec-nanosecs) / 1000000;
      else                       timeout += (nanosecs-now_nsec) / 1000000;
      }
    }
  return timeout;
  }
#endif


#ifndef WIN32
// convert a millisecond to struct timeval  (ie seconds / microseconds)
void FXUtils::convert_timeval(struct timeval *tv,FXuint ms){
  tv->tv_sec+=ms/1000; tv->tv_usec+=(ms%1000)*1000;
  while(tv->tv_usec>1000000){ tv->tv_sec+=1; tv->tv_usec-=1000000; }
  }

// convert millisecond to struct timespec  (ie seconds / nanoseconds)
void FXUtils::convert_timespec(struct timespec *ts,FXuint ms){
  ts->tv_sec+=ms/1000; ts->tv_nsec+=(ms%1000000)*1000000;
  while(ts->tv_nsec>1000000000){ ts->tv_sec+=1; ts->tv_nsec-=1000000000; }
  }
#endif

}
