/********************************************************************************
*                                                                               *
*                  LCD symbol objects                                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXLCDMARK_H
#define FXLCDMARK_H

#ifndef FXFRAME_H
#include <fox/FXFrame.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * Implements a decimalpoint, full-stop or colon as used by the LCD clock
 */
class FXAPI FXLCDSymbol : public FXFrame{
  FXDECLARE(FXLCDSymbol)

  private:
    FXchar  value;      // The currently shown character
    FXColor fgcolor;    // The color of the LCD text
    FXColor bgcolor;    // The color of the LCD background
    FXint   hsl;        // This is horizontal pixel length of a segment
    FXint   vsl;        // This is vertical pixel length of a segment (ie between the dots)
    FXint   st;         // This is segment thickness, in pixels
    FXint   groove;     // Groove between segments

  protected:
    FXLCDSymbol () {}

    // helper routine
    void calcLayout();

    // Draws the individual segment types
    void drawSegment(FXDCWindow &dc,FXshort x,FXshort y);

    // Draw a unit (each segment can be set indepentantly)
    void drawSegments (FXDCWindow &dc,FXbool s1,FXbool s2);

    // Draw appropriate symbol
    void drawAMsymbol (FXDCWindow &dc);
    void drawPMsymbol (FXDCWindow &dc);

    // Draw an alphanumeric figure (consisting of seven segments)
    virtual void drawFigure (FXDCWindow &dc, FXchar figure);

  public:
    long onPaint(FXObject*,FXSelector,void*);
    long onQueryTip(FXObject*,FXSelector,void*);
    long onQueryHelp(FXObject*,FXSelector,void*);

  public:
    virtual FXint getDefaultWidth(); // Return minimum width
    virtual FXint getDefaultHeight(); // Return minimum height

  public:
    /// create symbol/marker
    FXLCDSymbol (FXComposite* p,FXObject *tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_NONE,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

    /// choose character
    void setText(const FXchar val);

    /// return chose character
    FXchar getText() const {return value;};

    /// set foreground color
    void setFgColor(const FXColor clr);

    /// get foreground color
    FXColor getFgColor() const { return fgcolor; }

    /// set background color
    void setBgColor(const FXColor clr);

    /// get background color
    FXColor getBgColor() const { return bgcolor; }

    /// set segment vertical length (ie the distance between dots)
    void setHorizontal(const FXint len);

    FXint getHorizontal() const { return hsl; }

    /// set segment vertical length (ie the distance between dots)
    void setVertical(const FXint len);

    /// get segment vertical length
    FXint getVertical() const { return vsl; }

    /// set segment thickness
    void setThickness(const FXint width);

    /// get segment thickness
    FXint getThickness() const { return st; }

    /// set groove width
    void setGroove(const FXint width);

    /// get groove width
    FXint getGroove() const { return groove; }

    // dtor
    virtual ~FXLCDSymbol() {}
  };

} // namespace FXEX
#endif // FXLCDSYMBOL
