/***********************************-*- mode: c++; tab-width: 2 -*-*\
 *
 * NAME:     
 *   FXFileDialogEx - File dialog using native dialog
 *
 * AUTHOR:
 *   Daniel Gehriger (gehriger@linkcad.com)
 *
 * Copyright (c) 1999 by Daniel Gehriger.  All Rights Reserved.
 *
 * PUPROSE:
 *   File dialog using native Common Controls dialog
 *
 * NOTE
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Library General Public   
 * License as published by the Free Software Foundation; either  
 * version 2 of the License, or (at your option) any later version.
 *                                                                 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.                 
 *                                                                  
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free       
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * $Id: FXFileDialogEx.h,v 1.6 1999/12/15 09:39:41 dgehrige Exp $
 *
 * HISTORY:
 *        dgehrige - Dec, 10 1999: Created.
 *
\*******************************************************************/
#ifndef FXFILEDIALOGEX_H
#define FXFILEDIALOGEX_H

// use commctl32 dialog on Win32, or normal FXFileDialog for other platforms
#if !defined(WIN32) && !defined (WIN32_COMDLG)
#include <fox/fx.h>
#define FXFileDialogEx FXFileDialog
#else
#include <fox/FXObject.h>
using namespace FX;
#include <commdlg.h>
namespace FXEX {

/// File dialog options
#define DLGEX_SAVE              0x00100000  // "Save" dialog box
#define DLGEX_CREATEPROMPT      0x00400000  // -> OFN_CREATEPROMPT
#define DLGEX_READONLY          0x00800000  // -> OFN_READONLY
#define DLGEX_PATHMUSTEXIST     0x01000000  // -> OFN_PATHMUSTEXIST
#define DLGEX_FILEMUSTEXIST     0x02000000  // -> OFN_FILEMUSTEXIST
#define DLGEX_HIDEREADONLY      0x04000000  // -> OFN_HIDEREADONLY
#define DLGEX_OVERWRITEPROMPT   0x08000000  // -> OFN_OVERWRITEPROMPT

/**
 * Use comctl32 dialog under WIN32 for file dialog cases
 */
class FXAPI FXFileDialogEx : public FXObject {
  FXDECLARE(FXFileDialogEx)

public:
  OPENFILENAME   m_ofn;   // low-level access to OPENFILENAME
  FXuint         m_opts;
  FXchar       **m_pszFoxPats;
  FXchar        *m_pszFoxCustomPat;
  FXint          m_nFoxPats;

private:
  FXFileDialogEx(const FXFileDialogEx&);
  FXFileDialogEx& operator=(const FXFileDialogEx&);

  // get FOX patterns into Win32 patterns
  void getWinPattern(FXchar*& pszWinPat, const FXchar* pszFoxPat) const;

protected:
  FXFileDialogEx();

public:
  // ctor
  FXFileDialogEx(FXWindow* owner,const FXString& title,FXuint opts=0,FXint x=0,FXint y=0,FXint w=500,FXint h=300);

  /// Run modal invocation of the dialog
  FXuint execute();

  /// set the initial file name/path
  void setFilename(const FXString& path);

  /// set the initial directory
  void setDirectory(const FXString& path);

  /// set the inital pattern
  void setPattern(const FXString& ptrn);

  /// set the pattern list
  void setPatternList(const FXchar* ptrns[]);

  /// select the inital pattern from the list  (zero based)
  void setCurrentPattern(FXint n);

  /// modify pattern list
  void setPatternText(FXint patno,const FXString& text);

  /// get the selected file path
  FXString getFilename() const;

  /// get the selected file extension 
  FXString getPattern() const;
  
  /// get the selected directory
  FXString getDirectory() const;

  /// get index of selected pattern in the list (zero based)
  FXint getCurrentPattern() const;

  /// get a pattern by index
  FXString getPatternText(FXint patno) const;

  /// set the title of the dialog
  void setTitle(const FXString& name);

  /// get the title of the dialog
  FXString getTitle() const;

  // dtor
  virtual ~FXFileDialogEx();
  };

} // namespace FXEX
#endif /* use commctl32 dialog */
#endif /* FXFILEDIALOGEX_H */
